/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016d10ULL, 0x0000000000016890ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000156a0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000015810ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000015850ULL, 0x0000000000000130ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000015980ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000156a000000000ULL, 0x0000040400000000ULL, 0x810c000000780400ULL, 0x0055240400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080960828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000156a000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080960828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001581000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9a08288080960828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809a920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x0001585000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000d6ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001456000183104ULL, 0x0001494000014930ULL, 0x00014b6000014b50ULL,
0x00f8290400014b70ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500002005000020ULL, 0x0500002005000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000b000f82804ULL, 0x00001d80000000f0ULL, 0x000034b000003400ULL, 0x0000354000003510ULL,
0x0000396000003930ULL, 0x00005650000040a0ULL, 0x0000577000005700ULL, 0x00005ae000005790ULL,
0x000060a000005b20ULL, 0x000076d000007620ULL, 0x0000777000007750ULL, 0x00007ac000007a80ULL,
0x000095e000008070ULL, 0x000096e000009680ULL, 0x00009a3000009710ULL, 0x0000a0e000009a40ULL,
0x0000a9e00000a0f0ULL, 0x0000c9900000c830ULL, 0x0000ceb00000ce80ULL, 0x000144100000d6f0ULL,
0x0001445000014440ULL, 0x0001448000014460ULL, 0x000144c0000144a0ULL, 0x00014b40000144d0ULL,
0x00014bb000014ba0ULL, 0x000151f000014bc0ULL, 0x000152e000015270ULL, 0x000153c000015350ULL,
0x000154a000015430ULL, 0x0001557000015510ULL, 0x00015630000155e0ULL, 0x0170390400015680ULL,
0x000000ff00000160ULL, 0x003f010000024600ULL, 0x00000009000001a0ULL, 0x003f013000024608ULL,
0x00000009000001c0ULL, 0x003f013000024610ULL, 0x000000ff00000530ULL, 0x003f010700024600ULL,
0x0000000000000680ULL, 0x003f010200000004ULL, 0x0000000000000730ULL, 0x003f010100000000ULL,
0x000000ff00003210ULL, 0x003f01060002460cULL, 0x000000ff000032e0ULL, 0x003f01060002460cULL,
0x000000ff00004050ULL, 0x003f010100024610ULL, 0x000000ff00005510ULL, 0x003f01060002461cULL,
0x000000ff000055c0ULL, 0x003f01060002461cULL, 0x000000ff00006040ULL, 0x003f010100024620ULL,
0x000000ff000074d0ULL, 0x003f01060002462cULL, 0x000000ff00007580ULL, 0x003f01060002462cULL,
0x000000ff00008010ULL, 0x003f010100024630ULL, 0x000000ff000094b0ULL, 0x003f01060002463cULL,
0x000000ff00009560ULL, 0x003f01060002463cULL, 0x000000ff00009ea0ULL, 0x003f010100024640ULL,
0x000000ff0000f1d0ULL, 0x003f010600024604ULL, 0x000000ff0000f260ULL, 0x003f010600024604ULL,
0x0000002d000137f0ULL, 0x003f010600024614ULL, 0x0000002d00013d10ULL, 0x003f010600024614ULL,
0x0000002d00015140ULL, 0x003f010100024608ULL, 0x00101c0400033803ULL, 0x0000f2b00000db30ULL,
0x000151a00000f330ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001c4ULL,
0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL, 0x00000000000000ccULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x000000000000019aULL,
0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL, 0x00000000000000a8ULL,
0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000b7919ULL, 0x000ea80000002100ULL,
0x00000000006d7919ULL, 0x000ee80000002700ULL, 0x00000000002f7919ULL, 0x000f220000002600ULL,
0x0000000108007824ULL, 0x002fc800078e0203ULL, 0x0000008000097824ULL, 0x104fe200078e020bULL,
0x00000005ff7a7819ULL, 0x000fe2000001160bULL, 0x00001fff08007589ULL, 0x000e6200000e0000ULL,
0x000060006d0a7625ULL, 0x008fe400078e000aULL, 0x000000ff0900720cULL, 0x040fe40003f05270ULL,
0x000000030900780cULL, 0x040fe20003f24070ULL, 0x00001fff7a7a7589ULL, 0x000ea200000e0000ULL,
0x0000007f0900780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe200078e00ffULL,
0x7fffff8000038802ULL, 0x000fe20000000f00ULL, 0x3fffffe0ff049424ULL, 0x000fe200078e00ffULL,
0x7fffff8000079802ULL, 0x000fe20000000f00ULL, 0x7fffffe0ff059424ULL, 0x000fe400078e00ffULL,
0x02460002ff008388ULL, 0x0007e20000000a00ULL, 0xff317217ff0ca424ULL, 0x000fe200078e00ffULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff069424ULL, 0x000fe200078e00ffULL,
0x0246080409009388ULL, 0x0007e8000000ca00ULL, 0x0244000c0900a388ULL, 0x0007e80000004800ULL,
0x0246100609009388ULL, 0x0007e8000000ca00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003b000000947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x014e620000000000ULL,
0x00005800ff027624ULL, 0x008fc400078e00ffULL, 0x000000047a047824ULL, 0x000fe400078e00ffULL,
0x000000102f037824ULL, 0x000fe200078e00ffULL, 0x0000000402027819ULL, 0x000fe200000006ffULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x000000040f057211ULL, 0x002fc600078fd8ffULL,
0x0000006d02047224ULL, 0x000fe200078e0203ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x00000003050d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000705027812ULL, 0x000fe400078ec0ffULL,
0x0000000707037812ULL, 0x000fe400078ec0ffULL, 0x000000070d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000001f02027812ULL, 0x000fc400078e780fULL, 0x0000001f03067812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000000205097810ULL, 0x040fe40007ffe0ffULL,
0x0000001f0c127812ULL, 0x000fe200078e780fULL, 0x00000020050c7824ULL, 0x000fe200078e0202ULL,
0x0000000709087812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x040fe200078e0205ULL,
0x000001f003117812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x00000006070e7211ULL, 0x000fe200078e28ffULL, 0x00005c0002027625ULL, 0x000fe200078e0013ULL,
0x0000001f08087812ULL, 0x000fc400078e780fULL, 0x000000120d127211ULL, 0x000fe200078e28ffULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000001102027210ULL, 0x000fe20007f1e0ffULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x00005c0005047625ULL, 0x000fc800078e0013ULL,
0x00005c0006067625ULL, 0x000fe200078e0013ULL, 0x0000001104047210ULL, 0x000fc60007f3e0ffULL,
0x0000002009107824ULL, 0x000fe400078e0208ULL, 0x00005c000f087625ULL, 0x000fc800078e0013ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001106067210ULL, 0x080fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0x0000001108087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100e0f7824ULL, 0x000fe200078e00ffULL,
0x00000009ff097210ULL, 0x000fe200017fe4ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc400078e00ffULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x00000000040f7faeULL, 0x0003e8000b901c46ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x02460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060a797981ULL, 0x014ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff7b7e24ULL, 0x010fe2000f8e00ffULL,
0x000000ff79787810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff787819ULL, 0x000fce0000011678ULL,
0x0000d53000008947ULL, 0x000fea0003800000ULL, 0x000246107a007811ULL, 0x000fe400078e20ffULL,
0x0000000300037802ULL, 0x00afe20000000f00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040300ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000017b037810ULL, 0x002fe20007ffe0ffULL, 0x000000026d6d7824ULL, 0x000fe200078e00ffULL,
0x000058002f027a10ULL, 0x000fe20007ffe0ffULL, 0x000001007b047824ULL, 0x000fe200078e00ffULL,
0x000000780300720cULL, 0x000fe20003f06070ULL, 0x0000000000ff7f8cULL, 0x0003e4000c80043fULL,
0x000058006d6d7a24ULL, 0x000fc800078e0202ULL, 0x000062006d1a7a24ULL, 0x000fcc00078e0204ULL,
0x00000ac000008947ULL, 0x000fea0003800000ULL, 0x0000000000747919ULL, 0x002e620000000000ULL,
0x0000000479007217ULL, 0x000fe20007800000ULL, 0x00000200ff237424ULL, 0x000fe200078e00ffULL,
0x000140007a137811ULL, 0x000fc600078e70ffULL, 0x0000000100007824ULL, 0x000fca00078e0a04ULL,
0x0000004000007817ULL, 0x000fe40003800000ULL, 0x00000003ff0d7819ULL, 0x002fe40000011674ULL,
0x0ffffff874037812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d097810ULL, 0x040fe40007ffe0ffULL,
0x000000040d057810ULL, 0x040fe40007ffe0ffULL, 0x000000080d077810ULL, 0x000fe20007ffe0ffULL,
0x00000008090e7824ULL, 0x040fe200078e00ffULL, 0x00000074090b7212ULL, 0x000fe200078e3cffULL,
0x00000008050f7824ULL, 0x000fe200078e00ffULL, 0x000000100d197810ULL, 0x000fc40007ffe0ffULL,
0x000000740d027212ULL, 0x080fe400078e3cffULL, 0x0000007407087212ULL, 0x0c0fe400078e3cffULL,
0x0000000307117819ULL, 0x000fe400000006ffULL, 0x0000001c0d1f7810ULL, 0x000fe40007ffe0ffULL,
0x0000007405067212ULL, 0x000fe400078e3cffULL, 0x000000180d1d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL, 0x00000008190b7824ULL, 0x000fe200078e00ffULL,
0x000000140d1b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000703047812ULL, 0x000fe200078ef802ULL,
0x000000100e177824ULL, 0x000fe200078e0213ULL, 0xfffffff8110c7812ULL, 0x000fe200078ee208ULL,
0x000000081b127824ULL, 0x000fe200078e00ffULL, 0x0000007419027212ULL, 0x080fe400078e3cffULL,
0x000000741f087212ULL, 0x000fc400078e3cffULL, 0x000000031f117819ULL, 0x000fe400000006ffULL,
0xfffffff80f0a7812ULL, 0x000fe200078ee206ULL, 0x000000081d0f7824ULL, 0x040fe200078e00ffULL,
0x000000741d067212ULL, 0x080fe400078e3cffULL, 0x000000200d217810ULL, 0x000fe40007ffe0ffULL,
0x000000741b037212ULL, 0x000fe400078e3cffULL, 0xfffffff80b107812ULL, 0x000fe200078ee202ULL,
0x000000011a027824ULL, 0x000fe200078e020dULL, 0xfffffff811167812ULL, 0x000fe200078ee208ULL,
0x000000087a117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee206ULL,
0x00000008210f7824ULL, 0x000fe200078e00ffULL, 0x000000000d00720cULL, 0x080fe20003f06070ULL,
0x00000010040b7824ULL, 0x000fe200078e0213ULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x000fe200078e0023ULL, 0x000000000500720cULL, 0x000fc40003f26070ULL,
0x000000000700720cULL, 0x000fe20003f46070ULL, 0x000000011a057824ULL, 0x040fe200078e0205ULL,
0x000000071a077210ULL, 0x040fe40007ffe0ffULL, 0x0000007421067212ULL, 0x000fe200078e3cffULL,
0x00005e0005047625ULL, 0x080fe200078e0023ULL, 0xfffffff811117812ULL, 0x000fe400078ee274ULL,
0x000000000900720cULL, 0x000fe20003f66070ULL, 0x000000011a097824ULL, 0x000fe200078e0209ULL,
0xfffffff80f187812ULL, 0x000fe200078ee206ULL, 0x00005e0007067625ULL, 0x000fe200078e0023ULL,
0x000000130c157211ULL, 0x000fc400078e20ffULL, 0x000000002100720cULL, 0x000fe20003f86070ULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x00005e0009087625ULL, 0x000fe200078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000c101c46ULL,
0x000000001900720cULL, 0x000fe40003f06070ULL, 0x000000100a0f7824ULL, 0x000fe400078e0213ULL,
0x0000001011047825ULL, 0x000fc800078e0004ULL, 0x0000001011067825ULL, 0x000fe200078e0006ULL,
0x00000000040f7faeULL, 0x0005e2000c901c46ULL, 0x000000001b00720cULL, 0x080fe40003f26070ULL,
0x0000001011087825ULL, 0x000fe200078e0008ULL, 0x0000000006157faeULL, 0x0007e2000d101c46ULL,
0x000000001d00720cULL, 0x080fe40003f46070ULL, 0x000000011a197824ULL, 0x040fe200078e0219ULL,
0x0000000008177faeULL, 0x0009e2000d901c46ULL, 0x000000011a1b7824ULL, 0x000fe200078e021bULL,
0x000000001f00720cULL, 0x000fe20003f66070ULL, 0x00005e0019027625ULL, 0x002fe200078e0023ULL,
0x0000001310197211ULL, 0x000fc600078e20ffULL, 0x000000011a1d7824ULL, 0x040fe400078e021dULL,
0x000000011a1f7824ULL, 0x040fe400078e021fULL, 0x000000011a0a7824ULL, 0x000fe200078e0221ULL,
0x0000001316177211ULL, 0x010fe200078e20ffULL, 0x00005e001b047625ULL, 0x084fe200078e0023ULL,
0x000000280d1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000340d217810ULL, 0x000fe20007ffe0ffULL,
0x00005e001d067625ULL, 0x008fe200078e0023ULL, 0x0000002c0d1d7810ULL, 0x000fc60007ffe0ffULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x00005e001f087625ULL, 0x080fe200078e0023ULL,
0x0000000002197faeULL, 0x0003e2000c101c46ULL, 0x000000300d1f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0023ULL, 0x00000010120f7824ULL, 0x000fe400078e0213ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x000000240d197810ULL, 0x002fc60007ffe0ffULL,
0x0000001014157824ULL, 0x000fe200078e0213ULL, 0x00000000040f7faeULL, 0x0003e2000c901c46ULL,
0x0000001011067825ULL, 0x000fe200078e0006ULL, 0x0000007419027212ULL, 0x040fe400078e3cffULL,
0x000000001900720cULL, 0x080fe20003f06070ULL, 0x0000001011087825ULL, 0x000fe200078e0008ULL,
0x0000000006157faeULL, 0x0005e2000d101c46ULL, 0x000000001b00720cULL, 0x000fe40003f26070ULL,
0x0000001018037824ULL, 0x000fe200078e0213ULL, 0x0000000008177faeULL, 0x0007e2000d901c46ULL,
0x00000010110a7825ULL, 0x000fe200078e000aULL, 0x000000380d0f7810ULL, 0x002fc40007ffe0ffULL,
0x0000003c0d0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819057824ULL, 0x000fe200078e00ffULL,
0x000000000a037faeULL, 0x0003e2000e101c46ULL, 0x000000081b107824ULL, 0x000fe200078e00ffULL,
0x000000741d047212ULL, 0x040fe200078e3cffULL, 0x000000081d077824ULL, 0x044fe200078e00ffULL,
0x000000001d00720cULL, 0x080fe20003f46070ULL, 0x000000011a067824ULL, 0x040fe200078e021dULL,
0x000000001f00720cULL, 0x080fe20003f66070ULL, 0x000000011a087824ULL, 0x048fe200078e021fULL,
0x000000002100720cULL, 0x080fe20003f86070ULL, 0x000000081f147824ULL, 0x000fe200078e00ffULL,
0x000000000f00720cULL, 0x000fe20003fa6070ULL, 0x0000000821167824ULL, 0x000fe200078e00ffULL,
0x000000741b037212ULL, 0x002fe200078e3cffULL, 0x000000011a0c7824ULL, 0x040fe200078e020fULL,
0x000000000d00720cULL, 0x000fe20003fc6070ULL, 0x000000011a0e7824ULL, 0x040fe200078e020dULL,
0xfffffff805007812ULL, 0x000fe200078ee202ULL, 0x000000080f187824ULL, 0x000fe200078e00ffULL,
0xfffffff807127812ULL, 0x000fe200078ee204ULL, 0x000000011a047824ULL, 0x000fe200078e021bULL,
0xfffffff810107812ULL, 0x000fc400078ee203ULL, 0x000000191a027210ULL, 0x000fe20007ffe0ffULL,
0x0000001012177824ULL, 0x100fe200078e0213ULL, 0x000000211a0a7210ULL, 0x000fe20007ffe0ffULL,
0x0000001010157824ULL, 0x000fe200078e0213ULL, 0x000000741f037212ULL, 0x080fe400078e3cffULL,
0x0000007421057212ULL, 0x080fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0023ULL,
0x000000740f077212ULL, 0x080fe400078e3cffULL, 0x000000740d097212ULL, 0x040fe200078e3cffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0023ULL, 0x000000030d1a7819ULL, 0x000fc400000006ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x080fe200078e0023ULL,
0xfffffff816167812ULL, 0x000fe400078ee205ULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee209ULL,
0x00000013161b7211ULL, 0x000fe200078e20ffULL, 0x00005e0006067625ULL, 0x000fc800078e0023ULL,
0x00005e0008087625ULL, 0x000fc800078e0023ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0023ULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fc800078e0004ULL,
0x0000001011067825ULL, 0x000fc800078e0006ULL, 0x0000001011087825ULL, 0x000fc800078e0008ULL,
0x00000010110a7825ULL, 0x000fc800078e000aULL, 0x00000010110c7825ULL, 0x000fc800078e000cULL,
0x00000010110e7825ULL, 0x000fc800078e000eULL, 0x0000001000117824ULL, 0x100fe400078e0213ULL,
0x0000001014197824ULL, 0x100fe400078e0213ULL, 0x00000010181d7824ULL, 0x100fe200078e0213ULL,
0x0000000002117faeULL, 0x0003e2000c101c46ULL, 0x000000101a137824ULL, 0x000fc600078e0213ULL,
0x0000000004157faeULL, 0x0003e8000c901c46ULL, 0x0000000006177faeULL, 0x0003e8000d101c46ULL,
0x0000000008197faeULL, 0x0003e8000d901c46ULL, 0x000000000a1b7faeULL, 0x0003e8000e101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000e901c46ULL, 0x000000000e137faeULL, 0x0003e2000f101c46ULL,
0x0000098000007947ULL, 0x000fea0003800000ULL, 0x0000000000747919ULL, 0x002e620000000000ULL,
0x000000087a217824ULL, 0x040fe200078e00ffULL, 0x000140007a237811ULL, 0x000fc400078e70ffULL,
0x00000003ff037819ULL, 0x002fe40000011674ULL, 0x0ffffff874057812ULL, 0x000fe400078ec0ffULL,
0x0000000803097810ULL, 0x040fe40007ffe0ffULL, 0x0000000403077810ULL, 0x000fe40007ffe0ffULL,
0x0000007409047212ULL, 0x0c0fe200078e3cffULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x0000007403007212ULL, 0x080fe200078e3cffULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000007407027212ULL, 0x000fc400078e3cffULL, 0xfffffff80d227812ULL, 0x000fe400078ee204ULL,
0x0000000705007812ULL, 0x000fe400078ef800ULL, 0x00000014030d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b207812ULL, 0x000fe400078ee202ULL, 0x0000000c03057810ULL, 0x000fe20007ffe0ffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x00000010030b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a0c7824ULL, 0x040fe200078e020dULL, 0x0000007405027212ULL, 0x0c0fe200078e3cffULL,
0x000000011a087824ULL, 0x000fe200078e0205ULL, 0x00000003050f7819ULL, 0x000fe200000006ffULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x000000740d067212ULL, 0x000fc400078e3cffULL,
0x000000740b047212ULL, 0x080fe400078e3cffULL, 0xfffffff80f247812ULL, 0x000fe400078ee202ULL,
0x00000018030f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813287812ULL, 0x000fe400078ee206ULL,
0x0000002003137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f157824ULL, 0x000fe200078e00ffULL,
0xfffffff811267812ULL, 0x000fe200078ee204ULL, 0x000000011a0e7824ULL, 0x040fe200078e020fULL,
0x0000001c03117810ULL, 0x000fe20007ffe0ffULL, 0x000000011a127824ULL, 0x000fe200078e0213ULL,
0x0000007413067212ULL, 0x0c0fe200078e3cffULL, 0x00000010282b7824ULL, 0x000fe200078e0223ULL,
0x0000000313197819ULL, 0x000fe200000006ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x000000740f027212ULL, 0x080fe200078e3cffULL, 0x000000011a107824ULL, 0x000fe200078e0211ULL,
0x0000007411047212ULL, 0x000fc400078e3cffULL, 0xfffffff8192e7812ULL, 0x000fe400078ee206ULL,
0xfffffff8152a7812ULL, 0x000fe400078ee202ULL, 0x0000002c03197810ULL, 0x040fe20007ffe0ffULL,
0x000000102e317824ULL, 0x100fe200078e0223ULL, 0x0000002403157810ULL, 0x000fe20007ffe0ffULL,
0x000000102a2d7824ULL, 0x000fe200078e0223ULL, 0xfffffff8172c7812ULL, 0x000fe200078ee204ULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0x0000002803177810ULL, 0x000fe20007ffe0ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000007419067212ULL, 0x080fe200078e3cffULL,
0x000000011a187824ULL, 0x000fe200078e0219ULL, 0x0000007415027212ULL, 0x080fe200078e3cffULL,
0x00000008171d7824ULL, 0x040fe200078e00ffULL, 0x0000007417047212ULL, 0x000fe200078e3cffULL,
0x0000001000197824ULL, 0x000fe200078e0223ULL, 0xfffffff81f347812ULL, 0x000fe200078ee206ULL,
0x000000011a067824ULL, 0x040fe200078e0209ULL, 0xfffffff81b307812ULL, 0x000fe200078ee202ULL,
0x000000011a027824ULL, 0x040fe200078e0203ULL, 0x00000200001f7802ULL, 0x000fe20000000f00ULL,
0x000000011a167824ULL, 0x040fe200078e0217ULL, 0xfffffff81d327812ULL, 0x000fe200078ee204ULL,
0x000000011a047824ULL, 0x000fe200078e0207ULL, 0x00000030031b7810ULL, 0x040fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e001fULL, 0x00000034031d7810ULL, 0x000fc40007ffe0ffULL,
0x0000003803257810ULL, 0x000fe20007ffe0ffULL, 0x000000081b367824ULL, 0x000fe200078e00ffULL,
0x0000003c03277810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0xfffffff821217812ULL, 0x000fe400078ee274ULL, 0x0000000b1a0a7210ULL, 0x040fe20007ffe0ffULL,
0x000000011a1c7824ULL, 0x040fe200078e021bULL, 0x000000151a147210ULL, 0x000fe20007ffe0ffULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x000000741b057212ULL, 0x000fc400078e3cffULL,
0x0000001d1a1e7210ULL, 0x040fe20007ffe0ffULL, 0x000000081d3a7824ULL, 0x040fe200078e00ffULL,
0x000000741d077212ULL, 0x080fe200078e3cffULL, 0x000000011a387824ULL, 0x040fe200078e0225ULL,
0x0000007425097212ULL, 0x080fe200078e3cffULL, 0x000000011a3c7824ULL, 0x000fe200078e0227ULL,
0x00000074270b7212ULL, 0x000fe200078e3cffULL, 0x00000008251a7824ULL, 0x000fe200078e00ffULL,
0x00000003273e7819ULL, 0x000fe200000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002197faeULL, 0x0003e2000b901c46ULL, 0xfffffff836007812ULL, 0x000fe200078ee205ULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0xfffffff83a367812ULL, 0x000fc400078ee207ULL,
0xfffffff81a3a7812ULL, 0x000fe200078ee209ULL, 0x00005e0006067625ULL, 0x000fe200078e001fULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee20bULL, 0x0000002326297211ULL, 0x000fe200078e20ffULL,
0x00005e0008087625ULL, 0x000fe200078e001fULL, 0x0000002330337211ULL, 0x080fe400078e20ffULL,
0x000000233a3d7211ULL, 0x000fe200078e20ffULL, 0x00005e0018027625ULL, 0x002fc800078e001fULL,
0x00005e001c187625ULL, 0x000fc800078e001fULL, 0x00005e000a0a7625ULL, 0x000fc800078e001fULL,
0x00005e000e0e7625ULL, 0x000fc800078e001fULL, 0x00005e0010107625ULL, 0x000fc800078e001fULL,
0x00005e0012127625ULL, 0x000fc800078e001fULL, 0x00005e0014147625ULL, 0x000fc800078e001fULL,
0x00005e0016167625ULL, 0x000fc800078e001fULL, 0x00005e001e1a7625ULL, 0x000fc800078e001fULL,
0x00005e00381c7625ULL, 0x000fc800078e001fULL, 0x00005e003c1e7625ULL, 0x000fc800078e001fULL,
0x0000001021047825ULL, 0x000fc800078e0004ULL, 0x0000001021067825ULL, 0x000fc800078e0006ULL,
0x0000001021087825ULL, 0x000fc800078e0008ULL, 0x00000010210a7825ULL, 0x000fc800078e000aULL,
0x00000010210c7825ULL, 0x000fc800078e000cULL, 0x00000010210e7825ULL, 0x000fc800078e000eULL,
0x0000001021107825ULL, 0x000fc800078e0010ULL, 0x0000001021127825ULL, 0x000fc800078e0012ULL,
0x0000001021147825ULL, 0x000fc800078e0014ULL, 0x0000001021167825ULL, 0x000fc800078e0016ULL,
0x0000001021027825ULL, 0x000fc800078e0002ULL, 0x0000001021187825ULL, 0x000fc800078e0018ULL,
0x00000010211a7825ULL, 0x000fc800078e001aULL, 0x00000010211c7825ULL, 0x000fc800078e001cULL,
0x00000010211e7825ULL, 0x000fc800078e001eULL, 0x0000001020217824ULL, 0x100fe400078e0223ULL,
0x0000001022257824ULL, 0x100fe400078e0223ULL, 0x0000001024277824ULL, 0x100fe200078e0223ULL,
0x0000000004217faeULL, 0x0003e2000b901c46ULL, 0x000000102c2f7824ULL, 0x100fe400078e0223ULL,
0x0000001032357824ULL, 0x100fe200078e0223ULL, 0x0000000006257faeULL, 0x0003e2000b901c46ULL,
0x0000001034377824ULL, 0x000fc400078e0223ULL, 0x0000001000397824ULL, 0x100fe200078e0223ULL,
0x0000000008277faeULL, 0x0003e2000b901c46ULL, 0x00000010363b7824ULL, 0x100fe400078e0223ULL,
0x000000103e237824ULL, 0x000fe200078e0223ULL, 0x000000000a297faeULL, 0x0003e8000b901c46ULL,
0x000000000c2b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e2d7faeULL, 0x0003e8000b901c46ULL,
0x00000000102f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012317faeULL, 0x0003e8000b901c46ULL,
0x0000000014337faeULL, 0x0003e8000b901c46ULL, 0x0000000016357faeULL, 0x0003e8000b901c46ULL,
0x0000000002377faeULL, 0x0003e8000b901c46ULL, 0x0000000018397faeULL, 0x0003e8000b901c46ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e237faeULL, 0x0003e4000b901c46ULL, 0x000000787b00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff6b7424ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x002fe2000001ff00ULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000823000000947ULL, 0x000fea0003800000ULL,
0xff317217ff6b7424ULL, 0x000fe200078e00ffULL, 0x000000ff00057202ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x00007610ff677816ULL, 0x000fc40000000067ULL,
0x000001007b727824ULL, 0x000fca00078e00ffULL, 0x000000797200720cULL, 0x000fda0003f06070ULL,
0x0000816000000947ULL, 0x000fea0003800000ULL, 0x000000017b037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000780300720cULL, 0x000fe20003f06070ULL,
0x000000ffff657224ULL, 0x000fe200078e0005ULL, 0x0000004072007810ULL, 0x000fe40007ffe0ffULL,
0x0000000105637812ULL, 0x000fc600078e0cffULL, 0x000062006d2e7a24ULL, 0x000fcc00078e0200ULL,
0x00000ab000008947ULL, 0x000fea0003800000ULL, 0x00000003ff317819ULL, 0x000fe20000011674ULL,
0x000000087a337824ULL, 0x040fe200078e00ffULL, 0x000000637a207211ULL, 0x000fe200078e08ffULL,
0x00000200ff357424ULL, 0x000fe200078e00ffULL, 0x00000008310b7810ULL, 0x040fe40007ffe0ffULL,
0x00000010311f7810ULL, 0x000fe40007ffe0ffULL, 0x000000740b037212ULL, 0x040fe200078e3cffULL,
0x000000010b087824ULL, 0x140fe200078e022eULL, 0x000000030b047819ULL, 0x000fe200000006ffULL,
0x000000081f067824ULL, 0x000fe200078e00ffULL, 0x0000001c31477810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1c7824ULL, 0x000fe200078e022eULL, 0xfffffff804237812ULL, 0x000fc400078ee203ULL,
0x000000741f037212ULL, 0x080fe200078e3cffULL, 0x00000001472c7824ULL, 0x100fe200078e022eULL,
0x0000000431097810ULL, 0x040fe40007ffe0ffULL, 0xfffffff8062f7812ULL, 0x000fe400078ee203ULL,
0x0000001431377810ULL, 0x000fe20007ffe0ffULL, 0x0000000809217824ULL, 0x000fe200078e00ffULL,
0x0000007447037212ULL, 0x040fe400078e3cffULL, 0x0000000347067819ULL, 0x000fe200000006ffULL,
0x00000008373d7824ULL, 0x000fe200078e00ffULL, 0x0000002831537810ULL, 0x000fe20007ffe0ffULL,
0x00000001371e7824ULL, 0x000fe200078e022eULL, 0x0000000c311d7810ULL, 0x000fc40007ffe0ffULL,
0x0000007409027212ULL, 0x080fe400078e3cffULL, 0xfffffff806497812ULL, 0x000fe200078ee203ULL,
0x0000000853067824ULL, 0x000fe200078e00ffULL, 0x00000020314b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d2d7824ULL, 0x000fe200078e00ffULL, 0x0000007437047212ULL, 0x080fe200078e3cffULL,
0x000000011d0a7824ULL, 0x000fe200078e022eULL, 0x0000007453037212ULL, 0x000fe200078e3cffULL,
0x000000084b4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fc400078ee202ULL,
0x00000018313f7810ULL, 0x000fe40007ffe0ffULL, 0x000000741d027212ULL, 0x080fe400078e3cffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL, 0x000000083f457824ULL, 0x000fe200078e00ffULL,
0x0000002c31577810ULL, 0x000fe40007ffe0ffULL, 0xfffffff806557812ULL, 0x000fe400078ee203ULL,
0x000000744b047212ULL, 0x000fe200078e3cffULL, 0x0000000857597824ULL, 0x000fe200078e00ffULL,
0x0000000079037217ULL, 0x000fc40007800000ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee202ULL,
0x00000024314f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a00ULL,
0x000000743f027212ULL, 0x080fe400078e3cffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee204ULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0x0000007457047212ULL, 0x000fe400078e3cffULL,
0xfffffff845457812ULL, 0x000fc400078ee202ULL, 0x000000744f027212ULL, 0x000fe400078e3cffULL,
0x0000000731077812ULL, 0x000fe400078e4874ULL, 0xfffffff859597812ULL, 0x000fe400078ee204ULL,
0x0000004003047817ULL, 0x000fe40003800000ULL, 0xfffffff851517812ULL, 0x000fe200078ee202ULL,
0x0000000131027824ULL, 0x000fe200078e022eULL, 0x0001400020207811ULL, 0x000fc400078e68ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef874ULL, 0x00005e0002027625ULL, 0x080fe200078e0035ULL,
0x0000002e09067210ULL, 0x000fe40007ffe0ffULL, 0x000000043100720cULL, 0x080fe20003f26070ULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x000000040900720cULL, 0x080fe20003f46070ULL,
0x00005e0008087625ULL, 0x080fe200078e0035ULL, 0x000000041f00720cULL, 0x080fe40003fa6070ULL,
0x000000040b00720cULL, 0x080fe20003f66070ULL, 0x00000010071f7824ULL, 0x000fe200078e0220ULL,
0xfffffff833337812ULL, 0x000fe200078ee274ULL, 0x00005e0006067625ULL, 0x000fe200078e0035ULL,
0x000000041d00720cULL, 0x000fc40003f86070ULL, 0x0000002021217211ULL, 0x000fe200078e20ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0035ULL, 0x0000002e3f227210ULL, 0x000fc60007ffe0ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e0035ULL, 0x0000001033027825ULL, 0x000fc800078e0002ULL,
0x0000001033067825ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021f7faeULL, 0x0003e2000c901c46ULL, 0x000000043700720cULL, 0x080fe40003f26070ULL,
0x0000001033087825ULL, 0x000fe200078e0008ULL, 0x0000000006217faeULL, 0x0005e2000d101c46ULL,
0x000000043f00720cULL, 0x080fe40003f46070ULL, 0x000000102d2d7824ULL, 0x000fe200078e0220ULL,
0x0000000008237faeULL, 0x0007e2000d901c46ULL, 0x00000010330a7825ULL, 0x000fe200078e000aULL,
0x000000044700720cULL, 0x000fc40003f66070ULL, 0x0000003031377810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0220ULL, 0x000000000a2d7faeULL, 0x0009e2000e101c46ULL,
0x00000010331c7825ULL, 0x000fe200078e001cULL, 0x000000044b00720cULL, 0x080fe40003f86070ULL,
0x00000038313f7810ULL, 0x000fe20007ffe0ffULL, 0x000000014b1f7824ULL, 0x102fe200078e022eULL,
0x000000001c2f7faeULL, 0x0003e2000e901c46ULL, 0x000000014f217824ULL, 0x044fe200078e022eULL,
0x000000044f00720cULL, 0x000fe20003fa6070ULL, 0x00005e001e027625ULL, 0x000fc800078e0035ULL,
0x00005e0022067625ULL, 0x000fc800078e0035ULL, 0x00005e002c087625ULL, 0x008fc800078e0035ULL,
0x00005e001f0a7625ULL, 0x010fc800078e0035ULL, 0x00005e00211c7625ULL, 0x002fe200078e0035ULL,
0x0000002045217211ULL, 0x000fc600078e20ffULL, 0x000000103d1f7824ULL, 0x000fe200078e0220ULL,
0x00000034313d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001033027825ULL, 0x000fe200078e0002ULL,
0x0000003c31317810ULL, 0x000fc60007ffe0ffULL, 0x0000001033067825ULL, 0x000fe200078e0006ULL,
0x00000000021f7faeULL, 0x0003e2000c901c46ULL, 0x000000045300720cULL, 0x080fe40003f26070ULL,
0x0000001049237824ULL, 0x000fe200078e0220ULL, 0x0000000006217faeULL, 0x0005e2000d101c46ULL,
0x0000001033087825ULL, 0x000fe200078e0008ULL, 0x000000045700720cULL, 0x080fe40003f46070ULL,
0x000000043100720cULL, 0x000fe20003fc6070ULL, 0x000000104d2d7824ULL, 0x000fe200078e0220ULL,
0x0000000008237faeULL, 0x0007e2000d901c46ULL, 0x00000010330a7825ULL, 0x000fe200078e000aULL,
0x0000007437037212ULL, 0x002fc400078e3cffULL, 0x000000043700720cULL, 0x000fe20003f66070ULL,
0x00000010512f7824ULL, 0x000fe200078e0220ULL, 0x000000000a2d7faeULL, 0x0003e2000e101c46ULL,
0x00000010331c7825ULL, 0x000fe200078e001cULL, 0x0000002e57067210ULL, 0x004fe40007ffe0ffULL,
0x000000743f077212ULL, 0x080fe200078e3cffULL, 0x0000000837227824ULL, 0x000fe200078e00ffULL,
0x000000001c2f7faeULL, 0x0005e2000e901c46ULL, 0x0000000153027824ULL, 0x100fe200078e022eULL,
0x0000007431097212ULL, 0x008fe200078e3cffULL, 0x0000000137087824ULL, 0x100fe200078e022eULL,
0x000000043d00720cULL, 0x080fe20003f86070ULL, 0x00000001311e7824ULL, 0x100fe200078e022eULL,
0x000000043f00720cULL, 0x000fe20003fa6070ULL, 0x000000013d0a7824ULL, 0x002fe200078e022eULL,
0xfffffff8222d7812ULL, 0x000fe200078ee203ULL, 0x000000083f2c7824ULL, 0x000fe200078e00ffULL,
0x000000743d047212ULL, 0x000fe200078e3cffULL, 0x00005e0002027625ULL, 0x000fe200078e0035ULL,
0x0000002e3f1c7210ULL, 0x004fc40007ffe0ffULL, 0x0000002059237211ULL, 0x000fe200078e20ffULL,
0x00000008312e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c317812ULL, 0x000fe200078ee207ULL,
0x000000083d2f7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x080fe200078e0035ULL,
0xfffffff82e377812ULL, 0x000fe400078ee209ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL,
0x00005e0008087625ULL, 0x000fc800078e0035ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0035ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0035ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0035ULL,
0x0000001033027825ULL, 0x000fc800078e0002ULL, 0x0000001055217824ULL, 0x000fe400078e0220ULL,
0x0000001033067825ULL, 0x000fc600078e0006ULL, 0x0000000002217faeULL, 0x0003e2000c901c46ULL,
0x0000001033087825ULL, 0x000fc600078e0008ULL, 0x0000000006237faeULL, 0x0003e2000d101c46ULL,
0x000000102d2d7824ULL, 0x000fe400078e0220ULL, 0x00000010330a7825ULL, 0x000fc600078e000aULL,
0x00000000082d7faeULL, 0x0003e2000d901c46ULL, 0x000000102f2f7824ULL, 0x000fe400078e0220ULL,
0x00000010331c7825ULL, 0x000fc600078e001cULL, 0x000000000a2f7faeULL, 0x0003e2000e101c46ULL,
0x00000010331e7825ULL, 0x000fc800078e001eULL, 0x0000001031317824ULL, 0x100fe400078e0220ULL,
0x0000001037337824ULL, 0x000fc600078e0220ULL, 0x000000001c317faeULL, 0x0003e8000e901c46ULL,
0x000000001e337faeULL, 0x0003e2000f101c46ULL, 0x0000097000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fe20000011674ULL, 0x000000087a3f7824ULL, 0x000fe400078e00ffULL,
0x00000200ff3d7424ULL, 0x000fe200078e00ffULL, 0x0000000403097810ULL, 0x040fe40007ffe0ffULL,
0x00000008030b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c031d7810ULL, 0x000fe40007ffe0ffULL,
0x0000007409027212ULL, 0x080fe200078e3cffULL, 0x000000080b477824ULL, 0x000fe200078e00ffULL,
0x0000000309457819ULL, 0x000fe200000006ffULL, 0x000000081d497824ULL, 0x000fe200078e00ffULL,
0x00000010031f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b087824ULL, 0x000fe200078e022eULL,
0xfffffff845457812ULL, 0x000fe200078ee202ULL, 0x000000011d0a7824ULL, 0x100fe200078e022eULL,
0x000000740b047212ULL, 0x080fe200078e3cffULL, 0x000000081f4b7824ULL, 0x000fe200078e00ffULL,
0x000000741d027212ULL, 0x000fe200078e3cffULL, 0x000000011f1c7824ULL, 0x000fe200078e022eULL,
0x0000001403217810ULL, 0x000fc40007ffe0ffULL, 0x0000001803237810ULL, 0x000fe40007ffe0ffULL,
0xfffffff847477812ULL, 0x000fe200078ee204ULL, 0x00000008214d7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee202ULL, 0x00000001211e7824ULL, 0x100fe200078e022eULL,
0x0000001c032d7810ULL, 0x040fe40007ffe0ffULL, 0x0000002403317810ULL, 0x000fe40007ffe0ffULL,
0x000000741f047212ULL, 0x080fe200078e3cffULL, 0x000000082d517824ULL, 0x000fe200078e00ffULL,
0x0000007423027212ULL, 0x080fe200078e3cffULL, 0x0000000831557824ULL, 0x000fe200078e00ffULL,
0x00000003234f7819ULL, 0x000fe200000006ffULL, 0x000000012d227824ULL, 0x100fe200078e022eULL,
0x00000020032f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000131307824ULL, 0x000fe200078e022eULL,
0x0000007421067212ULL, 0x000fc400078e3cffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee204ULL,
0x000000082f537824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee202ULL,
0x000000012f2c7824ULL, 0x000fe200078e022eULL, 0x0000002803337810ULL, 0x000fe40007ffe0ffULL,
0x000000742d047212ULL, 0x080fe200078e3cffULL, 0x00005e002c2c7625ULL, 0x000fe200078e003dULL,
0x0000007431027212ULL, 0x080fe400078e3cffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee206ULL,
0x0000000833577824ULL, 0x000fe200078e00ffULL, 0x000000742f067212ULL, 0x000fe200078e3cffULL,
0x0000000133327824ULL, 0x000fe200078e022eULL, 0x0000002c03357810ULL, 0x000fc40007ffe0ffULL,
0xfffffff851517812ULL, 0x000fe400078ee204ULL, 0xfffffff855557812ULL, 0x000fe200078ee202ULL,
0x000000027a027824ULL, 0x000fe200078e0263ULL, 0x0000007433047212ULL, 0x080fe400078e3cffULL,
0xfffffff853537812ULL, 0x000fe400078ee206ULL, 0x0000007435067212ULL, 0x040fe400078e3cffULL,
0x0000000335597819ULL, 0x000fc400000006ffULL, 0x0000000703077812ULL, 0x040fe400078e4874ULL,
0x0000003003377810ULL, 0x040fe40007ffe0ffULL, 0x00000034035d7810ULL, 0x040fe40007ffe0ffULL,
0x0000003c03617810ULL, 0x000fe20007ffe0ffULL, 0x0000000837467824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee204ULL, 0x0000000137367824ULL, 0x100fe200078e022eULL,
0x00000038035f7810ULL, 0x000fe20007ffe0ffULL, 0x000000015d3c7824ULL, 0x100fe200078e022eULL,
0x0001400002047811ULL, 0x000fe200078e68ffULL, 0x0000000103027824ULL, 0x000fe200078e022eULL,
0xfffffff859597812ULL, 0x000fe200078ee206ULL, 0x000000085d487824ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef874ULL, 0x0000000161447824ULL, 0x000fe200078e022eULL,
0x0000002e09067210ULL, 0x080fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e003dULL,
0x0000002e23207210ULL, 0x000fc40007ffe0ffULL, 0x0000002e35347210ULL, 0x000fe20007ffe0ffULL,
0x00000008614a7824ULL, 0x000fe200078e00ffULL, 0x0000007437097212ULL, 0x000fe200078e3cffULL,
0x0000001007337824ULL, 0x000fe200078e0204ULL, 0x0000002e5f3e7210ULL, 0x040fe20007ffe0ffULL,
0x000000085f2e7824ULL, 0x000fe200078e00ffULL, 0x000000745d0b7212ULL, 0x080fe200078e3cffULL,
0x00005e0006067625ULL, 0x080fe200078e003dULL, 0x000000745f1d7212ULL, 0x080fe400078e3cffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee274ULL, 0x00005e0020207625ULL, 0x000fe200078e003dULL,
0x00000074611f7212ULL, 0x000fc400078e3cffULL, 0xfffffff8465d7812ULL, 0x000fe200078ee209ULL,
0x00005e0008087625ULL, 0x080fe200078e003dULL, 0xfffffff8485f7812ULL, 0x000fe400078ee20bULL,
0xfffffff82e617812ULL, 0x000fe200078ee21dULL, 0x00005e000a0a7625ULL, 0x080fe200078e003dULL,
0xfffffff84a6f7812ULL, 0x000fe400078ee21fULL, 0x0000000445457211ULL, 0x080fe200078e20ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e003dULL, 0x000000044f4f7211ULL, 0x000fc400078e20ffULL,
0x0000000459597211ULL, 0x000fe200078e20ffULL, 0x000000103f027825ULL, 0x000fc800078e0002ULL,
0x00005e001e1e7625ULL, 0x080fe200078e003dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002337faeULL, 0x0003e6000b901c46ULL, 0x00005e0022227625ULL, 0x000fc800078e003dULL,
0x000000103f067825ULL, 0x000fc800078e0006ULL, 0x000000103f087825ULL, 0x000fe200078e0008ULL,
0x0000000006457faeULL, 0x0005e6000b901c46ULL, 0x0000001047477824ULL, 0x000fe400078e0204ULL,
0x00005e00302e7625ULL, 0x000fc600078e003dULL, 0x0000000008477faeULL, 0x0005e2000b901c46ULL,
0x000000103f0a7825ULL, 0x000fc800078e000aULL, 0x0000001049497824ULL, 0x000fe400078e0204ULL,
0x00005e0032307625ULL, 0x000fc600078e003dULL, 0x000000000a497faeULL, 0x0005e2000b901c46ULL,
0x000000103f1c7825ULL, 0x000fc800078e001cULL, 0x000000104b4b7824ULL, 0x000fe400078e0204ULL,
0x00005e0034027625ULL, 0x002fc600078e003dULL, 0x000000001c4b7faeULL, 0x0005e2000b901c46ULL,
0x000000103f1e7825ULL, 0x000fc800078e001eULL, 0x000000104d4d7824ULL, 0x000fe400078e0204ULL,
0x00005e0036327625ULL, 0x000fc600078e003dULL, 0x000000001e4d7faeULL, 0x0005e2000b901c46ULL,
0x000000103f207825ULL, 0x000fc800078e0020ULL, 0x00005e003c347625ULL, 0x000fe200078e003dULL,
0x00000000204f7faeULL, 0x0005e6000b901c46ULL, 0x000000103f227825ULL, 0x000fc800078e0022ULL,
0x0000001051517824ULL, 0x000fe400078e0204ULL, 0x00005e003e367625ULL, 0x000fc600078e003dULL,
0x0000000022517faeULL, 0x0005e2000b901c46ULL, 0x000000103f2c7825ULL, 0x000fc800078e002cULL,
0x0000001053537824ULL, 0x000fe400078e0204ULL, 0x00005e00443c7625ULL, 0x000fc600078e003dULL,
0x000000002c537faeULL, 0x0005e2000b901c46ULL, 0x000000103f2e7825ULL, 0x000fc800078e002eULL,
0x0000001055557824ULL, 0x000fe400078e0204ULL, 0x000000103f307825ULL, 0x000fc600078e0030ULL,
0x000000002e557faeULL, 0x0005e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e0204ULL,
0x000000103f027825ULL, 0x000fc600078e0002ULL, 0x0000000030577faeULL, 0x0005e2000b901c46ULL,
0x000000103f327825ULL, 0x000fc600078e0032ULL, 0x0000000002597faeULL, 0x0005e2000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e0204ULL, 0x000000103f347825ULL, 0x000fc600078e0034ULL,
0x00000000325d7faeULL, 0x0005e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e0204ULL,
0x000000103f367825ULL, 0x000fc600078e0036ULL, 0x00000000345f7faeULL, 0x0005e2000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e0204ULL, 0x000000103f3c7825ULL, 0x000fc600078e003cULL,
0x0000000036617faeULL, 0x0005e2000b901c46ULL, 0x000000106f6f7824ULL, 0x000fca00078e0204ULL,
0x000000003c6f7faeULL, 0x0005e4000b901c46ULL, 0x02460c00ff037984ULL, 0x006e620000000800ULL,
0x0000ffff67027812ULL, 0x000fc600078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000888002617816ULL, 0x000fc800000000ffULL, 0x0000001f61027819ULL, 0x000fc800000006ffULL,
0x8000000003ff7812ULL, 0x002fe20007824802ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fe400078e00ffULL,
0x8000000061047824ULL, 0x000fe400078e00ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x02460c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007824804ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000010745f7824ULL, 0x040fe200078e00ffULL, 0x00000001ff027819ULL, 0x100fe40000011674ULL,
0x00000007745d7812ULL, 0x000fe400078ec0ffULL, 0x000000705f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fe400078ec0ffULL, 0x00000004ff097819ULL, 0x100fe40000011674ULL,
0x000000085d507812ULL, 0x000fe200078ef874ULL, 0x000000015f5f7824ULL, 0x000fe200078e0202ULL,
0x0000000100087802ULL, 0x000fc40000000f00ULL, 0x00000008740a7812ULL, 0x000fe400078ec0ffULL,
0x024000005f047984ULL, 0x000e620000000800ULL, 0x0000000709597812ULL, 0x000fc600078e7850ULL,
0x024200005f4c7984ULL, 0x0004e20000000800ULL, 0x0000006b0400720bULL, 0x002fda0003f3d000ULL,
0x0000000000027806ULL, 0x000fc800008e0100ULL, 0x0000ffff020b7812ULL, 0x000fe2000782c0ffULL,
0x000040007a027824ULL, 0x000fd800078e00ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x0000006b0400720bULL, 0x00cfe40003f34000ULL, 0x000000046b1e7209ULL, 0x000fe40007810000ULL,
0x00000002ff077819ULL, 0x000fc60000011674ULL, 0x8000001e6b037221ULL, 0x100fe20000010000ULL,
0x0000000807087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6b7224ULL, 0x000fe400078e001eULL,
0x3fb8aa3b03067820ULL, 0x000fe40000410000ULL, 0x0000000000037806ULL, 0x000fe400008e0100ULL,
0x000000ff7a00720cULL, 0x000fe40003f25270ULL, 0x0000000600067308ULL, 0x000e620000000800ULL,
0x0000ffff031c7812ULL, 0x000fc800078e3cffULL, 0x0000001c0bff7212ULL, 0x000fcc000784c0ffULL,
0x0244001e5f009388ULL, 0x000fe80000000800ULL, 0x00001f0806087589ULL, 0x002e6200000e0000ULL,
0x0000000669697220ULL, 0x000fe40000410000ULL, 0x8000001e04042221ULL, 0x000fe20000010000ULL,
0x00001f0706077589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b04042820ULL, 0x000fc80000410000ULL,
0x00000004005b2308ULL, 0x000ee20000000800ULL, 0x0000000827277220ULL, 0x082fe40000410000ULL,
0x0000000826267220ULL, 0x080fe40000410000ULL, 0x0000000813137220ULL, 0x080fe40000410000ULL,
0x0000000812127220ULL, 0x080fe40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x000000083a3a7220ULL, 0x000fc40000410000ULL, 0x000000080f0f7220ULL, 0x080fe40000410000ULL,
0x000000080e0e7220ULL, 0x080fe40000410000ULL, 0x000000082b2b7220ULL, 0x080fe40000410000ULL,
0x000000082a2a7220ULL, 0x080fe40000410000ULL, 0x000000081b1b7220ULL, 0x080fe40000410000ULL,
0x000000081a1a7220ULL, 0x000fc40000410000ULL, 0x0000000843437220ULL, 0x080fe40000410000ULL,
0x0000000842427220ULL, 0x080fe40000410000ULL, 0x0000000817177220ULL, 0x080fe40000410000ULL,
0x0000000816167220ULL, 0x000fe20000410000ULL, 0x00000001ff087807ULL, 0x000fe20001000000ULL,
0x0000000725257220ULL, 0x084fe40000410000ULL, 0x0000000724247220ULL, 0x000fc40000410000ULL,
0x0000000711117220ULL, 0x080fe40000410000ULL, 0x0000000710107220ULL, 0x080fe40000410000ULL,
0x0000000739397220ULL, 0x080fe40000410000ULL, 0x0000000738387220ULL, 0x080fe40000410000ULL,
0x000000070d0d7220ULL, 0x080fe40000410000ULL, 0x000000070c0c7220ULL, 0x000fc40000410000ULL,
0x0000000729297220ULL, 0x080fe40000410000ULL, 0x0000000728287220ULL, 0x080fe40000410000ULL,
0x0000000719197220ULL, 0x080fe40000410000ULL, 0x0000000718187220ULL, 0x080fe40000410000ULL,
0x0000000741417220ULL, 0x080fe40000410000ULL, 0x0000000740407220ULL, 0x000fc40000410000ULL,
0x0000000715157220ULL, 0x080fe40000410000ULL, 0x0000000714147220ULL, 0x000fe40000410000ULL,
0x0000005b4c4c2220ULL, 0x008fe40000410000ULL, 0x000000070a1c7812ULL, 0x00cfe200078ec85dULL,
0x0000000850597824ULL, 0x000fe200078e0259ULL, 0x0000005d0a4d7212ULL, 0x000fe200078efcffULL,
0x0000200005037824ULL, 0x000fe200078e0202ULL, 0x000000091c587212ULL, 0x000fe200078e3cffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0001200059047811ULL, 0x000fe400078e20ffULL,
0x00014000034f7810ULL, 0x000fe40007ffe0ffULL, 0x000000584d707211ULL, 0x000fe400078e18ffULL,
0x00000002091d7810ULL, 0x000fe20007ffe0ffULL, 0x000000000404783bULL, 0x000fe20000000200ULL,
0x0000005bff03723eULL, 0x000fe200000000ffULL, 0x00000010700a7824ULL, 0x000fe200078e024fULL,
0x0000001d1c567212ULL, 0x000fc400078e3cffULL, 0x00000002ff0b7819ULL, 0x000fe40000011674ULL,
0x000000000a3c783bULL, 0x0003e20000004200ULL, 0x000000084d6e7824ULL, 0x000fe200078e0256ULL,
0x000000080b577810ULL, 0x000fe40007ffe0ffULL, 0x00000004092d7810ULL, 0x000fe20007ffe0ffULL,
0x000000106e207824ULL, 0x000fe200078e024fULL, 0x0000991008087816ULL, 0x000fe400000000ffULL,
0x00005410030a7816ULL, 0x002fc40000000003ULL, 0x0000002d1c547212ULL, 0x000fe200078e3cffULL,
0x000000002020783bULL, 0x000fe20000004200ULL, 0x000000ff0800720cULL, 0x000fe40003f25270ULL,
0x00000006092f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f0b0a037589ULL, 0x000e6200000e0000ULL,
0x000000084d6c7824ULL, 0x000fe200078e0254ULL, 0x000000071d557812ULL, 0x000fe400078e7850ULL,
0x00001f570a4e7589ULL, 0x000ea200000e0000ULL, 0x0000002f1c527212ULL, 0x000fc400078e3cffULL,
0x0000004f6c087211ULL, 0x000fe200078e20ffULL, 0x0000000850557824ULL, 0x040fe200078e0255ULL,
0x000000072d537812ULL, 0x000fe200078e7850ULL, 0x000000084d6a7824ULL, 0x000fe200078e0252ULL,
0x000000072f517812ULL, 0x000fe400078e7850ULL, 0x000000000808783bULL, 0x000fe20000004200ULL,
0x0001200055347811ULL, 0x000fe200078e20ffULL, 0x0000000850537824ULL, 0x040fe400078e0253ULL,
0x0000000850517824ULL, 0x000fc600078e0251ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000304049232ULL, 0x082fe40000000000ULL, 0x0000000306069232ULL, 0x000fe40000000000ULL,
0x0000004e05059232ULL, 0x084fe40000000000ULL, 0x0000004e07079232ULL, 0x000fce0000000000ULL,
0x0000003c0448723cULL, 0x040fee0000001814ULL, 0x000000106a147824ULL, 0x000fe200078e024fULL,
0x0000003e043c723cULL, 0x040fea0000001840ULL, 0x000000001414783bULL, 0x000e640000004200ULL,
0x000000804d417811ULL, 0x000fe200078e18ffULL, 0x000000200430723cULL, 0x000fe60000001818ULL,
0x0000004152627210ULL, 0x000fe20007ffe0ffULL, 0x0000000158687824ULL, 0x000fc400078e0241ULL,
0x0000000156667824ULL, 0x100fe200078e0241ULL, 0x0000000334349232ULL, 0x088fe20000000000ULL,
0x000000220420723cULL, 0x040fe20000001828ULL, 0x0000000154647824ULL, 0x000fe200078e0241ULL,
0x0000000336369232ULL, 0x000fe40000000000ULL, 0x0000004e35359232ULL, 0x080fe40000000000ULL,
0x0000004e37379232ULL, 0x000fe20000000000ULL, 0x0000004f68287211ULL, 0x000fe200078e20ffULL,
0x00000008041c723cULL, 0x040fea000000180cULL, 0x000000002828783bULL, 0x000ea40000004200ULL,
0x00000010660c7824ULL, 0x100fe200078e024fULL, 0x0000000a0418723cULL, 0x000fe20000001838ULL,
0x0000001064087824ULL, 0x000fc800078e024fULL, 0x000000000c0c783bULL, 0x000ee80000004200ULL,
0x000000000808783bULL, 0x000f220000004200ULL, 0x000000140410723cULL, 0x042fee0000001810ULL,
0x000001004d157811ULL, 0x040fe200078e18ffULL, 0x000000160404723cULL, 0x000fe20000001824ULL,
0x000001804d4d7811ULL, 0x000fc400078e18ffULL, 0x00000015545c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000158607824ULL, 0x100fe400078e0215ULL, 0x00000001565e7824ULL, 0x100fe200078e0215ULL,
0x0001200051247811ULL, 0x000fe200078e20ffULL, 0x00000001525a7824ULL, 0x040fe200078e0215ULL,
0x0000004d52527210ULL, 0x000fe20007ffe0ffULL, 0x0000001060447824ULL, 0x100fe400078e024fULL,
0x000000105e2c7824ULL, 0x100fe200078e024fULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000105c147824ULL, 0x000fe200078e024fULL, 0x000000283448723cULL, 0x004fe40000001848ULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x0000000158587824ULL, 0x000fc400078e024dULL,
0x0000000156567824ULL, 0x100fe200078e024dULL, 0x000000002c2c783bULL, 0x000fe20000004200ULL,
0x0000000154547824ULL, 0x000fe400078e024dULL, 0x0000001062287824ULL, 0x100fe200078e024fULL,
0x0000002a343c723cULL, 0x040fe2000000183cULL, 0x000000001414783bULL, 0x000fe20000004200ULL,
0x0000001058407824ULL, 0x100fe400078e024fULL, 0x0000001054387824ULL, 0x000fe200078e024fULL,
0x000000002828783bULL, 0x000ea60000004200ULL, 0x0000000c3430723cULL, 0x048fe20000001830ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000003838783bULL, 0x000fe40000004200ULL,
0x00012000530c7811ULL, 0x000fe200078e20ffULL, 0x0000000e3420723cULL, 0x040fea0000001820ULL,
0x000000000c0c783bULL, 0x000ee60000000200ULL, 0x00000008341c723cULL, 0x010fe2000000181cULL,
0x0000000324249232ULL, 0x002fc40000000000ULL, 0x0000000326269232ULL, 0x000fc80000000000ULL,
0x0000004f5a087211ULL, 0x000fe200078e20ffULL, 0x0000000a3418723cULL, 0x040fe20000001818ULL,
0x0000004e25259232ULL, 0x080fe40000000000ULL, 0x0000004e27279232ULL, 0x000fe40000000000ULL,
0x000000000808783bULL, 0x000e660000004200ULL, 0x000000283410723cULL, 0x044fee0000001810ULL,
0x0000001056287824ULL, 0x100fe200078e024fULL, 0x0000002a3434723cULL, 0x000fea0000001804ULL,
0x000000002828783bULL, 0x000ea40000004200ULL, 0x0000001052047824ULL, 0x000fe200078e024fULL,
0x000000030c0c9232ULL, 0x008fc40000000000ULL, 0x000000030e0e9232ULL, 0x000fe40000000000ULL,
0x0000004e0d0d9232ULL, 0x080fe20000000000ULL, 0x000000000404783bULL, 0x000ee20000004200ULL,
0x0000004e0f0f9232ULL, 0x000fce0000000000ULL, 0x000000440c48723cULL, 0x040ff00000001848ULL,
0x0000002c0c30723cULL, 0x040ff00000001830ULL, 0x0000002e0c20723cULL, 0x040ff00000001820ULL,
0x000000140c1c723cULL, 0x040ff0000000181cULL, 0x000000460c3c723cULL, 0x040ff0000000183cULL,
0x000000160c2c723cULL, 0x040ff00000001818ULL, 0x000000080c10723cULL, 0x042ff00000001810ULL,
0x0000000a0c34723cULL, 0x000ff00000001834ULL, 0x000000402414723cULL, 0x040ff00000001848ULL,
0x000000282418723cULL, 0x044ff00000001830ULL, 0x00000038240c723cULL, 0x040ff0000000181cULL,
0x000000422440723cULL, 0x040ff0000000183cULL, 0x0000002a2428723cULL, 0x040ff00000001820ULL,
0x0000003a2438723cULL, 0x040ff0000000182cULL, 0x000000042410723cULL, 0x048ff00000001810ULL,
0x000000062424723cULL, 0x000fe20000001834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000790000720cULL, 0x000fe20003f26070ULL, 0x02461000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000694c697221ULL, 0x000fe20000010000ULL, 0x0000006300057202ULL, 0x000fd40000000f00ULL,
0x00005e4000001947ULL, 0x000fea0003800000ULL, 0x0000008072047810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000062006d007a24ULL, 0x000fe200078e0204ULL,
0x00000ac000008947ULL, 0x000fea0003800000ULL, 0x00000003ff337819ULL, 0x000fe20000011674ULL,
0x00000200ff357424ULL, 0x000fe200078e00ffULL, 0x0000000479037217ULL, 0x000fe40007800000ULL,
0x0000000433097810ULL, 0x040fe40007ffe0ffULL, 0x00000008330b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103047824ULL, 0x000fe200078e0a04ULL, 0x0000007409057212ULL, 0x040fe200078e3cffULL,
0x0000000809067824ULL, 0x000fe200078e00ffULL, 0x0000001033317810ULL, 0x000fe20007ffe0ffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x0000001c33497810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8061f7812ULL, 0x000fe400078ee205ULL, 0x0000000c332d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0x000000740b037212ULL, 0x080fe400078e3cffULL,
0x0000007431067212ULL, 0x000fe200078e3cffULL, 0x000000082d0a7824ULL, 0x000fe200078e00ffULL,
0x0000000331377819ULL, 0x000fe400000006ffULL, 0x00000014333d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff808217812ULL, 0x000fe400078ee203ULL, 0xfffffff837377812ULL, 0x000fe200078ee206ULL,
0x000000083d087824ULL, 0x000fe200078e00ffULL, 0x0000007449067212ULL, 0x080fe400078e3cffULL,
0x00000020334d7810ULL, 0x000fe40007ffe0ffULL, 0x000000742d057212ULL, 0x000fe400078e3cffULL,
0x0000001833457810ULL, 0x000fc40007ffe0ffULL, 0x000000743d037212ULL, 0x080fe400078e3cffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee206ULL, 0x000000084d067824ULL, 0x000fe200078e00ffULL,
0xfffffff80a2f7812ULL, 0x000fe200078ee205ULL, 0x00000008450a7824ULL, 0x040fe200078e00ffULL,
0xfffffff8083f7812ULL, 0x000fe200078ee203ULL, 0x0000000145207824ULL, 0x000fe200078e0200ULL,
0x0000002833737810ULL, 0x000fe40007ffe0ffULL, 0x000000744d037212ULL, 0x000fc400078e3cffULL,
0x0000007445057212ULL, 0x080fe200078e3cffULL, 0x0000000873757824ULL, 0x000fe200078e00ffULL,
0x00000024336f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8064f7812ULL, 0x000fe400078ee203ULL,
0xfffffff80a477812ULL, 0x000fe200078ee205ULL, 0x000000012d0a7824ULL, 0x000fe200078e0200ULL,
0x0000007473067212ULL, 0x000fe400078e3cffULL, 0x0000000165037812ULL, 0x000fc400078ec0ffULL,
0x000000746f057212ULL, 0x040fe400078e3cffULL, 0x000000036f087819ULL, 0x000fe400000006ffULL,
0xfffffff875757812ULL, 0x000fe200078ee206ULL, 0x0000200003067824ULL, 0x000fe200078e0202ULL,
0xfffffff808717812ULL, 0x000fe200078ee205ULL, 0x000000087a087824ULL, 0x000fe200078e00ffULL,
0x0000004004037817ULL, 0x000fe40003800000ULL, 0x0000000033057210ULL, 0x000fc40007ffe0ffULL,
0x0000000733077812ULL, 0x000fe400078e4874ULL, 0x0001400006227810ULL, 0x000fe20007ffe0ffULL,
0x0000000109067824ULL, 0x100fe200078e0200ULL, 0xfffffff808237812ULL, 0x000fe200078ee25dULL,
0x000000010b087824ULL, 0x000fe200078e0200ULL, 0x000000033300720cULL, 0x000fe20003f06070ULL,
0x00005e0005047625ULL, 0x000fe200078e0035ULL, 0x0000002c33777810ULL, 0x000fe40007ffe0ffULL,
0x000000030900720cULL, 0x000fe20003f26070ULL, 0x00005e0008087625ULL, 0x000fe200078e0035ULL,
0x0ffffff8071d7812ULL, 0x000fc400078ef874ULL, 0x000000030b00720cULL, 0x000fe20003f46070ULL,
0x00005e0006067625ULL, 0x000fe200078e0035ULL, 0x000000032d00720cULL, 0x000fe40003f66070ULL,
0x00000074771c7212ULL, 0x000fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0035ULL,
0x000000221d1d7211ULL, 0x000fe400078e20ffULL, 0x000000003d1e7210ULL, 0x000fe20007ffe0ffULL,
0x00000008777d7824ULL, 0x000fe200078e00ffULL, 0x000000034d00720cULL, 0x000fe20003f86070ULL,
0x0000001023047825ULL, 0x000fc600078e0004ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee21cULL,
0x000000101f1f7824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000041d7faeULL, 0x0003e2000c101c46ULL, 0x0000001023067825ULL, 0x000fe200078e0006ULL,
0x000000033100720cULL, 0x000fc60003f06070ULL, 0x0000001021217824ULL, 0x000fe200078e0222ULL,
0x00000000061f7faeULL, 0x0005e2000c901c46ULL, 0x0000001023087825ULL, 0x000fe200078e0008ULL,
0x000000033d00720cULL, 0x080fe40003f26070ULL, 0x00000034333d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2d7824ULL, 0x000fe200078e0222ULL, 0x0000000008217faeULL, 0x0007e2000d101c46ULL,
0x00000010230a7825ULL, 0x000fe200078e000aULL, 0x000000034500720cULL, 0x080fe40003f46070ULL,
0x000000033d2e7819ULL, 0x000fe200000006ffULL, 0x00000001311c7824ULL, 0x100fe200078e0200ULL,
0x000000000a2d7faeULL, 0x0009e2000d901c46ULL, 0x00000001491d7824ULL, 0x142fe200078e0200ULL,
0x000000034900720cULL, 0x000fe20003f66070ULL, 0x000000014d1f7824ULL, 0x004fc400078e0200ULL,
0x00005e001c047625ULL, 0x080fe200078e0035ULL, 0x000000223f217211ULL, 0x008fe400078e20ffULL,
0x00000038333f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001e067625ULL, 0x000fc600078e0035ULL,
0x000000033f00720cULL, 0x000fe20003fa6070ULL, 0x00005e0020087625ULL, 0x000fc800078e0035ULL,
0x00005e001d0a7625ULL, 0x010fc800078e0035ULL, 0x00005e001f1c7625ULL, 0x000fc800078e0035ULL,
0x00000010371f7824ULL, 0x000fe200078e0222ULL, 0x0000003033377810ULL, 0x000fe20007ffe0ffULL,
0x0000001023047825ULL, 0x000fe200078e0004ULL, 0x0000003c33337810ULL, 0x000fc60007ffe0ffULL,
0x0000001023067825ULL, 0x000fe200078e0006ULL, 0x00000000041f7faeULL, 0x0003e2000c101c46ULL,
0x000000036f00720cULL, 0x080fe40003f06070ULL, 0x00000010472d7824ULL, 0x000fe200078e0222ULL,
0x0000000006217faeULL, 0x0005e2000c901c46ULL, 0x0000001023087825ULL, 0x000fe200078e0008ULL,
0x000000037300720cULL, 0x080fe40003f26070ULL, 0x000000033300720cULL, 0x000fe20003fc6070ULL,
0x000000104b2f7824ULL, 0x000fe200078e0222ULL, 0x00000000082d7faeULL, 0x0007e2000d101c46ULL,
0x00000010230a7825ULL, 0x000fe200078e000aULL, 0x000000743d057212ULL, 0x002fc400078e3cffULL,
0x000000037700720cULL, 0x080fe20003f46070ULL, 0x000000104f317824ULL, 0x000fe200078e0222ULL,
0x000000000a2f7faeULL, 0x0003e2000d901c46ULL, 0x00000010231c7825ULL, 0x000fe200078e001cULL,
0x0000000073067210ULL, 0x004fe40007ffe0ffULL, 0x0000007433077212ULL, 0x0c0fe200078e3cffULL,
0x0000000833307824ULL, 0x000fe200078e00ffULL, 0x000000001c317faeULL, 0x0005e2000e101c46ULL,
0x000000016f047824ULL, 0x100fe200078e0200ULL, 0x000000033700720cULL, 0x080fe20003f66070ULL,
0x0000000177087824ULL, 0x108fe200078e0200ULL, 0x000000033d00720cULL, 0x000fe20003f86070ULL,
0x000000013f1e7824ULL, 0x100fe200078e0200ULL, 0x0000007437037212ULL, 0x040fe200078e3cffULL,
0x00000001370a7824ULL, 0x002fc400078e0200ULL, 0x0000000133207824ULL, 0x100fe400078e0200ULL,
0x00000008372c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e317812ULL, 0x004fe200078ee205ULL,
0x000000013d1c7824ULL, 0x000fe200078e0200ULL, 0xfffffff830377812ULL, 0x000fe200078ee207ULL,
0x00005e0004047625ULL, 0x080fe200078e0035ULL, 0x000000743f007212ULL, 0x000fe400078e3cffULL,
0xfffffff82c2f7812ULL, 0x000fe200078ee203ULL, 0x00005e0006067625ULL, 0x000fe200078e0035ULL,
0x0000002271037211ULL, 0x000fc600078e20ffULL, 0x00005e0008087625ULL, 0x000fc800078e0035ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0035ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0035ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0035ULL, 0x00005e0020207625ULL, 0x000fc800078e0035ULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x0000001023047825ULL, 0x000fc600078e0004ULL,
0xfffffff83f337812ULL, 0x000fe200078ee200ULL, 0x0000001023067825ULL, 0x000fe200078e0006ULL,
0x0000000004037faeULL, 0x0003e4000c101c46ULL, 0x0000002233337211ULL, 0x000fe200078e20ffULL,
0x0000001023087825ULL, 0x000fc800078e0008ULL, 0x00000010230a7825ULL, 0x000fc800078e000aULL,
0x00000010231c7825ULL, 0x000fc800078e001cULL, 0x00000010231e7825ULL, 0x000fc800078e001eULL,
0x0000001023207825ULL, 0x000fc800078e0020ULL, 0x0000001075237824ULL, 0x100fe400078e0222ULL,
0x000000107d2d7824ULL, 0x100fe400078e0222ULL, 0x000000102f2f7824ULL, 0x100fe200078e0222ULL,
0x0000000006237faeULL, 0x0003e2000c901c46ULL, 0x0000001031317824ULL, 0x100fe400078e0222ULL,
0x0000001037357824ULL, 0x000fe200078e0222ULL, 0x00000000082d7faeULL, 0x0003e8000d101c46ULL,
0x000000000a2f7faeULL, 0x0003e8000d901c46ULL, 0x000000001c317faeULL, 0x0003e8000e101c46ULL,
0x000000001e337faeULL, 0x0003e8000e901c46ULL, 0x0000000020357faeULL, 0x0003e2000f101c46ULL,
0x0000098000007947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x000fe20000011674ULL,
0x00000200ff3d7424ULL, 0x000fc600078e00ffULL, 0x0000000405097810ULL, 0x040fe40007ffe0ffULL,
0x00000008050b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c051d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809067824ULL, 0x040fe200078e00ffULL, 0x0000007409037212ULL, 0x080fe200078e3cffULL,
0x000000080b457824ULL, 0x000fe200078e00ffULL, 0x0000001405217810ULL, 0x000fe20007ffe0ffULL,
0x000000081d087824ULL, 0x000fe200078e00ffULL, 0x000000740b047212ULL, 0x080fe200078e3cffULL,
0x000000011d0a7824ULL, 0x100fe200078e0200ULL, 0xfffffff8063f7812ULL, 0x000fe200078ee203ULL,
0x00000008214b7824ULL, 0x000fe200078e00ffULL, 0x00000010051f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001211e7824ULL, 0x000fe200078e0200ULL, 0x000000741d037212ULL, 0x000fc400078e3cffULL,
0x0000001805237810ULL, 0x040fe40007ffe0ffULL, 0x00000020052f7810ULL, 0x000fe40007ffe0ffULL,
0x0000007421067212ULL, 0x080fe200078e3cffULL, 0x0000000123207824ULL, 0x000fe200078e0200ULL,
0xfffffff845457812ULL, 0x000fe200078ee204ULL, 0x000000082f6f7824ULL, 0x000fe200078e00ffULL,
0x0000001c052d7810ULL, 0x000fe20007ffe0ffULL, 0x000000012f2c7824ULL, 0x000fe200078e0200ULL,
0x000000741f047212ULL, 0x040fe200078e3cffULL, 0x00005e0020207625ULL, 0x000fe200078e003dULL,
0x000000031f497819ULL, 0x000fc400000006ffULL, 0xfffffff808477812ULL, 0x000fe200078ee203ULL,
0x0000000823087824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee206ULL,
0x000000082d4f7824ULL, 0x000fe200078e00ffULL, 0x0000007423037212ULL, 0x080fe200078e3cffULL,
0x000000012d227824ULL, 0x000fe200078e0200ULL, 0x000000742f067212ULL, 0x000fe400078e3cffULL,
0x0000002405317810ULL, 0x000fe20007ffe0ffULL, 0x00005e0022227625ULL, 0x000fe200078e003dULL,
0xfffffff849497812ULL, 0x000fc400078ee204ULL, 0x0000002805337810ULL, 0x000fe40007ffe0ffULL,
0x000000742d047212ULL, 0x080fe200078e3cffULL, 0x00005e002c2c7625ULL, 0x000fe200078e003dULL,
0xfffffff8084d7812ULL, 0x000fe400078ee203ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee206ULL,
0x0000000833737824ULL, 0x000fe200078e00ffULL, 0x0000002c05357810ULL, 0x000fe20007ffe0ffULL,
0x000000010b087824ULL, 0x100fe200078e0200ULL, 0x0000007431037212ULL, 0x080fe200078e3cffULL,
0x0000000133307824ULL, 0x000fe200078e0200ULL, 0x0000000331067819ULL, 0x000fe200000006ffULL,
0x0000000835757824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee204ULL,
0x0000000135327824ULL, 0x000fe200078e0200ULL, 0x0000007433047212ULL, 0x000fc400078e3cffULL,
0xfffffff806717812ULL, 0x000fe400078ee203ULL, 0x0000007435067212ULL, 0x000fe400078e3cffULL,
0x0000000165037812ULL, 0x000fe400078ec0ffULL, 0xfffffff873737812ULL, 0x000fe200078ee204ULL,
0x000000087a047824ULL, 0x000fe200078e00ffULL, 0xfffffff875757812ULL, 0x000fe400078ee206ULL,
0x0000000203067211ULL, 0x000fc400078e68ffULL, 0x0000000705077812ULL, 0x040fe400078e4874ULL,
0x0000003005377810ULL, 0x040fe40007ffe0ffULL, 0x0000003405777810ULL, 0x040fe40007ffe0ffULL,
0xfffffff804037812ULL, 0x000fe200078ee25dULL, 0x0000000105047824ULL, 0x140fe200078e0200ULL,
0x00000038057d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000837467824ULL, 0x000fe200078e00ffULL,
0x0000003c057f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000877487824ULL, 0x000fe200078e00ffULL,
0x00014000063e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109067824ULL, 0x000fe200078e0200ULL,
0x0ffffff807077812ULL, 0x000fe200078ef874ULL, 0x0000000137347824ULL, 0x140fe200078e0200ULL,
0x0000007437097212ULL, 0x000fe200078e3cffULL, 0x000000017d3c7824ULL, 0x100fe200078e0200ULL,
0x000000001f1c7210ULL, 0x000fe20007ffe0ffULL, 0x000000017f447824ULL, 0x000fe200078e0200ULL,
0x00000074770b7212ULL, 0x000fe200078e3cffULL, 0x00005e0004047625ULL, 0x000fe200078e003dULL,
0x00000000312e7210ULL, 0x000fc40007ffe0ffULL, 0x0000000077367210ULL, 0x000fe20007ffe0ffULL,
0x000000087d1f7824ULL, 0x000fe200078e00ffULL, 0x000000747f1d7212ULL, 0x080fe200078e3cffULL,
0x0000001007337824ULL, 0x000fe200078e023eULL, 0x000000037f4a7819ULL, 0x000fe200000006ffULL,
0x00005e0006067625ULL, 0x080fe200078e003dULL, 0x000000747d007212ULL, 0x000fe400078e3cffULL,
0xfffffff846777812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e003dULL,
0xfffffff8487d7812ULL, 0x000fc400078ee20bULL, 0xfffffff84a817812ULL, 0x000fe200078ee21dULL,
0x00005e000a0a7625ULL, 0x080fe200078e003dULL, 0xfffffff81f7f7812ULL, 0x000fe400078ee200ULL,
0x0000003e49497211ULL, 0x080fe200078e20ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e003dULL,
0x0000003e71717211ULL, 0x080fe400078e20ffULL, 0x0000003e7f7f7211ULL, 0x000fe200078e20ffULL,
0x0000001003047825ULL, 0x000fc800078e0004ULL, 0x00005e001e1e7625ULL, 0x000fe200078e003dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004337faeULL, 0x0003e6000b901c46ULL,
0x0000001003067825ULL, 0x000fc800078e0006ULL, 0x000000103f3f7824ULL, 0x000fe400078e023eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x00000000063f7faeULL, 0x0005e2000b901c46ULL,
0x0000001045457824ULL, 0x000fe400078e023eULL, 0x00005e002e2e7625ULL, 0x000fc600078e003dULL,
0x0000000008457faeULL, 0x0005e2000b901c46ULL, 0x00000010030a7825ULL, 0x000fc800078e000aULL,
0x0000001047477824ULL, 0x000fe400078e023eULL, 0x00005e0030307625ULL, 0x000fc600078e003dULL,
0x000000000a477faeULL, 0x0005e2000b901c46ULL, 0x00000010031c7825ULL, 0x000fc800078e001cULL,
0x00005e0032047625ULL, 0x002fe200078e003dULL, 0x000000001c497faeULL, 0x0005e6000b901c46ULL,
0x00000010031e7825ULL, 0x000fc800078e001eULL, 0x000000104b4b7824ULL, 0x000fe400078e023eULL,
0x00005e0034327625ULL, 0x000fc600078e003dULL, 0x000000001e4b7faeULL, 0x0005e2000b901c46ULL,
0x0000001003207825ULL, 0x000fc800078e0020ULL, 0x000000104d4d7824ULL, 0x000fe400078e023eULL,
0x00005e0036347625ULL, 0x000fc600078e003dULL, 0x00000000204d7faeULL, 0x0005e2000b901c46ULL,
0x0000001003227825ULL, 0x000fc800078e0022ULL, 0x000000104f4f7824ULL, 0x000fe400078e023eULL,
0x00005e003c367625ULL, 0x000fc600078e003dULL, 0x00000000224f7faeULL, 0x0005e2000b901c46ULL,
0x00000010032c7825ULL, 0x000fc800078e002cULL, 0x000000106f6f7824ULL, 0x000fe400078e023eULL,
0x00005e00443c7625ULL, 0x000fc600078e003dULL, 0x000000002c6f7faeULL, 0x0005e2000b901c46ULL,
0x00000010032e7825ULL, 0x000fc800078e002eULL, 0x0000001003307825ULL, 0x000fe200078e0030ULL,
0x000000002e717faeULL, 0x0005e6000b901c46ULL, 0x0000001073737824ULL, 0x000fe400078e023eULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x0000000030737faeULL, 0x0005e2000b901c46ULL,
0x0000001075757824ULL, 0x000fe400078e023eULL, 0x0000001003327825ULL, 0x000fc600078e0032ULL,
0x0000000004757faeULL, 0x0005e2000b901c46ULL, 0x0000001077777824ULL, 0x000fe400078e023eULL,
0x0000001003347825ULL, 0x000fc600078e0034ULL, 0x0000000032777faeULL, 0x0005e2000b901c46ULL,
0x000000107d7d7824ULL, 0x000fe400078e023eULL, 0x0000001003367825ULL, 0x000fc600078e0036ULL,
0x00000000347d7faeULL, 0x0005e2000b901c46ULL, 0x00000010033c7825ULL, 0x000fc600078e003cULL,
0x00000000367f7faeULL, 0x0005e2000b901c46ULL, 0x0000001081817824ULL, 0x000fca00078e023eULL,
0x000000003c817faeULL, 0x0005e4000b901c46ULL, 0x02461c00ff007984ULL, 0x000ee20000000800ULL,
0x8000000061037824ULL, 0x002fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000000ff7812ULL, 0x008fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000061047824ULL, 0x004fe400078e00ffULL, 0x0000000000037305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x02461c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804804ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x024080005f007984ULL, 0x000e620000000800ULL, 0x00002000634f7824ULL, 0x004fe200078e0202ULL,
0x0001280059347811ULL, 0x000fe400078e20ffULL, 0x024280005f507984ULL, 0x0004e20000000800ULL,
0x0000006b0000720bULL, 0x002fda0003f1d000ULL, 0x0000000000037806ULL, 0x000fc800000e0100ULL,
0x0000ffff03047812ULL, 0x000fe4000780c0ffULL, 0x0000000100037802ULL, 0x000fc80000000f00ULL,
0x0000761003027816ULL, 0x000fce0000000002ULL, 0x0000034000008947ULL, 0x000fea0003800000ULL,
0x0000006b0000720bULL, 0x00cfe40003f14000ULL, 0x000000006b067209ULL, 0x000fe40007810000ULL,
0x00000002ff077819ULL, 0x000fc60000011674ULL, 0x800000066b027221ULL, 0x100fe40000010000ULL,
0x000000ffff6b7224ULL, 0x000fe400078e0006ULL, 0x3fb8aa3b02037820ULL, 0x000fe40000410000ULL,
0x0000000000027806ULL, 0x000fe400000e0100ULL, 0x0000000300087308ULL, 0x000e620000000800ULL,
0x000000017a00780cULL, 0x000fe40003f05270ULL, 0x0000ffff02057812ULL, 0x000fc800078e3cffULL,
0x0000000504ff7212ULL, 0x000fce000782c0ffULL, 0x024480065f008388ULL, 0x000fe20000000800ULL,
0x0000000869697220ULL, 0x002fc60000410000ULL, 0x00001f0708027589ULL, 0x000e6400000e0000ULL,
0x8000000600041221ULL, 0x000fe40000010000ULL, 0x00001f5708007589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b04041820ULL, 0x000fc80000410000ULL, 0x00000004005b1308ULL, 0x000ee20000000800ULL,
0x0000000214147220ULL, 0x082fe40000410000ULL, 0x0000000215157220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x0000000218187220ULL, 0x080fe40000410000ULL, 0x0000000219197220ULL, 0x000fc40000410000ULL,
0x0000000228287220ULL, 0x080fe40000410000ULL, 0x0000000229297220ULL, 0x080fe40000410000ULL,
0x000000020c0c7220ULL, 0x080fe40000410000ULL, 0x000000020d0d7220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x000fc40000410000ULL,
0x0000000210107220ULL, 0x080fe40000410000ULL, 0x0000000211117220ULL, 0x080fe40000410000ULL,
0x0000000224247220ULL, 0x080fe40000410000ULL, 0x0000000225257220ULL, 0x000fe20000410000ULL,
0x00000001ff027807ULL, 0x000fe20000800000ULL, 0x0000000016167220ULL, 0x084fe40000410000ULL,
0x0000000017177220ULL, 0x000fc40000410000ULL, 0x0000000042427220ULL, 0x080fe40000410000ULL,
0x0000000043437220ULL, 0x080fe40000410000ULL, 0x000000001a1a7220ULL, 0x080fe40000410000ULL,
0x000000001b1b7220ULL, 0x080fe40000410000ULL, 0x000000002a2a7220ULL, 0x080fe40000410000ULL,
0x000000002b2b7220ULL, 0x000fc40000410000ULL, 0x000000000e0e7220ULL, 0x080fe40000410000ULL,
0x000000000f0f7220ULL, 0x080fe40000410000ULL, 0x000000003a3a7220ULL, 0x080fe40000410000ULL,
0x000000003b3b7220ULL, 0x080fe40000410000ULL, 0x0000000012127220ULL, 0x080fe40000410000ULL,
0x0000000013137220ULL, 0x000fc40000410000ULL, 0x0000000026267220ULL, 0x080fe40000410000ULL,
0x0000000027277220ULL, 0x000fe40000410000ULL, 0x000000505b501220ULL, 0x008fe40000410000ULL,
0x000140004f4f7810ULL, 0x00cfe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x000000106e4d7824ULL, 0x100fe200078e024fULL,
0x0000005bff00723eULL, 0x000fe200000000ffULL, 0x00000010704e7824ULL, 0x100fe200078e024fULL,
0x00000002ff6f7819ULL, 0x000fe20000011674ULL, 0x000000106a037824ULL, 0x100fe200078e024fULL,
0x000000004d44783bULL, 0x000fe20000004200ULL, 0x0000541000047816ULL, 0x000fe20000000000ULL,
0x0000001064717824ULL, 0x100fe200078e024fULL, 0x0000991002007816ULL, 0x000fe200000000ffULL,
0x000000004e1c783bULL, 0x000fe20000004200ULL, 0x0000004f6c4c7211ULL, 0x080fe200078e20ffULL,
0x0000001068027824ULL, 0x100fe200078e024fULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00001f6f046f7589ULL, 0x000e6200000e0000ULL, 0x0000001066007824ULL, 0x100fe200078e024fULL,
0x0000004f62737211ULL, 0x080fe200078e20ffULL, 0x0000001060757824ULL, 0x100fe200078e024fULL,
0x00001f5704767589ULL, 0x0004e200000e0000ULL, 0x000000105e777824ULL, 0x100fe200078e024fULL,
0x0000004f587e7211ULL, 0x000fe200078e20ffULL, 0x000000105c7c7824ULL, 0x100fe200078e024fULL,
0x000000004c48783bULL, 0x000fe20000004200ULL, 0x000000105a7d7824ULL, 0x000fc400078e024fULL,
0x0000001056817824ULL, 0x100fe200078e024fULL, 0x00000000033c783bULL, 0x000fe20000004200ULL,
0x00000010547f7824ULL, 0x100fe200078e024fULL, 0x0001280055047811ULL, 0x004fe200078e20ffULL,
0x0000001052807824ULL, 0x000fe200078e024fULL, 0x00000000002c783bULL, 0x000fe80000004200ULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x000000007108783bULL, 0x000fe20000004200ULL,
0x0000006f34348232ULL, 0x002fc40000000000ULL, 0x0000006f36368232ULL, 0x000fe40000000000ULL,
0x0000007635358232ULL, 0x088fe40000000000ULL, 0x0000007637378232ULL, 0x000fce0000000000ULL,
0x000000443420723cULL, 0x040fe20000001818ULL, 0x000000000218783bULL, 0x000e6e0000004200ULL,
0x0000001c3414723cULL, 0x040ff00000001814ULL, 0x0000001e341c723cULL, 0x000fe20000001840ULL,
0x000000007340783bULL, 0x000fe20000004200ULL, 0x0000006f04048232ULL, 0x004fc40000000000ULL,
0x0000006f06068232ULL, 0x000fc80000000000ULL, 0x000000463444723cULL, 0x000fe20000001828ULL,
0x0000007605058232ULL, 0x080fe40000000000ULL, 0x0000007607078232ULL, 0x000fca0000000000ULL,
0x000000483430723cULL, 0x040fee000000180cULL, 0x00012800530c7811ULL, 0x000fe200078e20ffULL,
0x0000004a3438723cULL, 0x040fea0000001838ULL, 0x000000000c0c783bULL, 0x000ea60000000200ULL,
0x0000003c3410723cULL, 0x040ff00000001810ULL, 0x0000003e3428723cULL, 0x000fe20000001824ULL,
0x000000007734783bULL, 0x000ee80000004200ULL, 0x000000007d24783bULL, 0x000fe60000004200ULL,
0x000000180414723cULL, 0x042ff00000001814ULL, 0x0000001a0418723cULL, 0x040ff0000000181cULL,
0x0000002c041c723cULL, 0x000fe20000001820ULL, 0x000000007c20783bULL, 0x000fe20000004200ULL,
0x0000006f0c0c8232ULL, 0x004fc40000000000ULL, 0x0000006f0e0e8232ULL, 0x000fc80000000000ULL,
0x0000002e042c723cULL, 0x000fe20000001844ULL, 0x000000007544783bULL, 0x000e620000004200ULL,
0x000000760d0d8232ULL, 0x080fe40000000000ULL, 0x000000760f0f8232ULL, 0x000fc80000000000ULL,
0x000000080430723cULL, 0x040fee0000001830ULL, 0x0001280051087811ULL, 0x000fe200078e20ffULL,
0x0000000a0438723cULL, 0x040fea0000001838ULL, 0x000000000808783bULL, 0x000ea60000000200ULL,
0x00000040043c723cULL, 0x040fe20000001810ULL, 0x000000007f10783bULL, 0x000fee0000004200ULL,
0x000000420448723cULL, 0x000fe20000001828ULL, 0x000000007e40783bULL, 0x000f280000004200ULL,
0x000000008128783bULL, 0x000f660000004200ULL, 0x000000340c1c723cULL, 0x048fe2000000181cULL,
0x000000008004783bULL, 0x000eee0000004200ULL, 0x000000440c14723cULL, 0x042ff00000001814ULL,
0x000000460c18723cULL, 0x000fe20000001818ULL, 0x0000006f08088232ULL, 0x004fc40000000000ULL,
0x0000006f0a0a8232ULL, 0x000fca0000000000ULL, 0x000000200c30723cULL, 0x000fe20000001830ULL,
0x0000007609098232ULL, 0x080fe40000000000ULL, 0x000000760b0b8232ULL, 0x000fca0000000000ULL,
0x000000220c38723cULL, 0x040ff00000001838ULL, 0x000000240c3c723cULL, 0x040ff0000000183cULL,
0x000000360c2c723cULL, 0x040ff0000000182cULL, 0x000000260c24723cULL, 0x000ff00000001848ULL,
0x000000400814723cULL, 0x050ff00000001814ULL, 0x000000420840723cULL, 0x040ff00000001818ULL,
0x000000280818723cULL, 0x060ff0000000181cULL, 0x00000010080c723cULL, 0x040ff00000001830ULL,
0x000000120838723cULL, 0x040ff00000001838ULL, 0x0000002a0828723cULL, 0x040ff0000000182cULL,
0x000000040810723cULL, 0x048ff0000000183cULL, 0x000000060824723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008072047810ULL, 0x000fe20007ffe0ffULL,
0x02462000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000006950697221ULL, 0x000fe20000010000ULL,
0x0000000165057812ULL, 0x000fc400078ec0ffULL, 0x000000790400720cULL, 0x000fda0003f06070ULL,
0x00003e4000000947ULL, 0x000fea0003800000ULL, 0x000000017b057810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000780500720cULL, 0x000fe40003f06070ULL,
0x000000c072067810ULL, 0x000fca0007ffe0ffULL, 0x000062006d047a24ULL, 0x000fcc00078e0206ULL,
0x00000a9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff337819ULL, 0x000fe20000011674ULL,
0x00000200ff377424ULL, 0x000fe200078e00ffULL, 0x0000000679057217ULL, 0x000fe40007800000ULL,
0x00000008330b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000433097810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057210ULL, 0x000fe20007ffe1ffULL, 0x000000080b1f7824ULL, 0x000fe200078e00ffULL,
0x0000000c331d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809207824ULL, 0x000fe200078e00ffULL,
0x00000010332f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x040fe200078e0204ULL,
0x000000740b067212ULL, 0x080fe200078e3cffULL, 0x000000081d2c7824ULL, 0x000fe200078e00ffULL,
0x0000001433317810ULL, 0x000fe20007ffe0ffULL, 0x000000082f217824ULL, 0x000fe200078e00ffULL,
0x0000007409077212ULL, 0x000fc400078e3cffULL, 0xfffffff81f227812ULL, 0x000fe200078ee206ULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe400078ee207ULL,
0x000000741d077212ULL, 0x080fe200078e3cffULL, 0x0000001022237824ULL, 0x000fe200078e024fULL,
0x000000742f087212ULL, 0x080fe400078e3cffULL, 0x0000001c333f7810ULL, 0x000fe40007ffe0ffULL,
0x0000007431067212ULL, 0x000fc400078e3cffULL, 0x0000002033457810ULL, 0x040fe40007ffe0ffULL,
0x00000018333d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee207ULL,
0xfffffff8212e7812ULL, 0x000fe200078ee208ULL, 0x000000083f217824ULL, 0x000fe200078e00ffULL,
0xfffffff81f307812ULL, 0x000fe200078ee206ULL, 0x00000008451f7824ULL, 0x000fe200078e00ffULL,
0x0000002433477810ULL, 0x000fe20007ffe0ffULL, 0x000000013d227824ULL, 0x040fe200078e0204ULL,
0x000000743d077212ULL, 0x000fc400078e3cffULL, 0x000000033d327819ULL, 0x000fe200000006ffULL,
0x00000008473c7824ULL, 0x000fe200078e00ffULL, 0x000000743f087212ULL, 0x080fe400078e3cffULL,
0x0000002833497810ULL, 0x000fe40007ffe0ffULL, 0x0000007445067212ULL, 0x080fe400078e3cffULL,
0xfffffff832327812ULL, 0x000fe400078ee207ULL, 0xfffffff821347812ULL, 0x000fe200078ee208ULL,
0x0000000849217824ULL, 0x000fe200078e00ffULL, 0x0000007447077212ULL, 0x000fc400078e3cffULL,
0xfffffff81f367812ULL, 0x000fe400078ee206ULL, 0x000000037a067819ULL, 0x000fe400000006ffULL,
0x0000007449087212ULL, 0x000fe400078e3cffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee207ULL,
0x0000004005057817ULL, 0x000fe40003800000ULL, 0xfffffff806357812ULL, 0x000fe200078ee25dULL,
0x0000000133067824ULL, 0x040fe200078e0204ULL, 0x0000000733077812ULL, 0x000fc400078e4874ULL,
0xfffffff8213e7812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x100fe200078e0204ULL,
0x000000041d1c7210ULL, 0x000fe20007ffe0ffULL, 0x0000001020217824ULL, 0x000fe200078e024fULL,
0x000000053300720cULL, 0x000fe20003f06070ULL, 0x0000000131207824ULL, 0x000fe200078e0204ULL,
0x0ffffff8071e7812ULL, 0x000fe200078ef874ULL, 0x00005e0006067625ULL, 0x000fe200078e0037ULL,
0x000000050900720cULL, 0x080fe40003f26070ULL, 0x000000050b00720cULL, 0x000fe20003f46070ULL,
0x00005e0008087625ULL, 0x000fe200078e0037ULL, 0x000000051d00720cULL, 0x000fc40003f66070ULL,
0x0000004f2c2d7211ULL, 0x000fe200078e20ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0037ULL,
0x000000054500720cULL, 0x000fe40003f86070ULL, 0x0000002c334b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e001c1c7625ULL, 0x000fc600078e0037ULL, 0x000000744b447212ULL, 0x000fe200078e3cffULL,
0x000000101e1f7824ULL, 0x000fe400078e024fULL, 0x0000001035067825ULL, 0x000fc800078e0006ULL,
0x0000001035087825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000061f7faeULL, 0x0003e2000c101c46ULL, 0x000000052f00720cULL, 0x080fe40003f06070ULL,
0x00000010350a7825ULL, 0x000fe200078e000aULL, 0x0000000008217faeULL, 0x0005e2000c901c46ULL,
0x000000053100720cULL, 0x080fe40003f26070ULL, 0x00000010351c7825ULL, 0x000fe200078e001cULL,
0x000000000a237faeULL, 0x0007e2000d101c46ULL, 0x000000053d00720cULL, 0x000fc40003f46070ULL,
0x000000012f1e7824ULL, 0x100fe200078e0204ULL, 0x000000001c2d7faeULL, 0x0009e2000d901c46ULL,
0x000000013f1f7824ULL, 0x042fe200078e0204ULL, 0x000000053f00720cULL, 0x000fe20003f66070ULL,
0x00005e001e067625ULL, 0x000fe200078e0037ULL, 0x0000000445217210ULL, 0x004fe40007ffe0ffULL,
0x0000004f36317211ULL, 0x000fe200078e20ffULL, 0x00005e0020087625ULL, 0x080fe200078e0037ULL,
0x00000030333d7810ULL, 0x040fe40007ffe0ffULL, 0x00000034333f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e00220a7625ULL, 0x008fe200078e0037ULL, 0x0000003833457810ULL, 0x000fc40007ffe0ffULL,
0x0000003c33337810ULL, 0x000fe20007ffe0ffULL, 0x00005e001f1c7625ULL, 0x010fe200078e0037ULL,
0x000000054500720cULL, 0x080fe40003fa6070ULL, 0x000000053300720cULL, 0x000fe20003fc6070ULL,
0x00005e00211e7625ULL, 0x000fe200078e0037ULL, 0x000000033d227819ULL, 0x000fc600000006ffULL,
0x000000102e217824ULL, 0x000fe400078e024fULL, 0x0000001035067825ULL, 0x000fc800078e0006ULL,
0x0000001030237824ULL, 0x000fe200078e024fULL, 0x0000000006217faeULL, 0x0003e2000c101c46ULL,
0x0000001035087825ULL, 0x000fe200078e0008ULL, 0x000000054700720cULL, 0x000fc60003f06070ULL,
0x00000010322d7824ULL, 0x000fe200078e024fULL, 0x0000000008237faeULL, 0x0005e2000c901c46ULL,
0x00000010350a7825ULL, 0x000fe200078e000aULL, 0x000000054900720cULL, 0x000fc60003f26070ULL,
0x00000010342f7824ULL, 0x000fe200078e024fULL, 0x000000000a2d7faeULL, 0x0007e2000d101c46ULL,
0x00000010351c7825ULL, 0x000fe200078e001cULL, 0x000000054b00720cULL, 0x080fe40003f46070ULL,
0x000000743d077212ULL, 0x082fe200078e3cffULL, 0x00000010351e7825ULL, 0x000fe200078e001eULL,
0x000000001c2f7faeULL, 0x0003e2000d901c46ULL, 0x000000053d00720cULL, 0x080fe40003f66070ULL,
0x0000000149067824ULL, 0x100fe200078e0204ULL, 0x000000001e317faeULL, 0x0009e2000e101c46ULL,
0x000000053f00720cULL, 0x000fe20003f86070ULL, 0x0000000147057824ULL, 0x100fe200078e0204ULL,
0x000000743f097212ULL, 0x084fe200078e3cffULL, 0x000000014b087824ULL, 0x100fe200078e0204ULL,
0x00000074330b7212ULL, 0x008fe200078e3cffULL, 0x000000013d0a7824ULL, 0x100fe200078e0204ULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x000000013f1c7824ULL, 0x002fc400078e0204ULL,
0x0000000133207824ULL, 0x100fe400078e0204ULL, 0x00000001451e7824ULL, 0x050fe200078e0204ULL,
0x0000007445047212ULL, 0x000fe200078e3cffULL, 0x000000083f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000345457819ULL, 0x000fe200000006ffULL, 0x0000000833307824ULL, 0x000fe200078e00ffULL,
0x0000004f22317211ULL, 0x000fe200078e20ffULL, 0x000000084b6f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8452e7812ULL, 0x000fe200078ee204ULL, 0x00005e0005047625ULL, 0x000fe200078e0037ULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee209ULL, 0xfffffff830307812ULL, 0x000fe200078ee20bULL,
0x00005e0006067625ULL, 0x000fe200078e0037ULL, 0xfffffff86f447812ULL, 0x000fc600078ee244ULL,
0x00005e0008087625ULL, 0x000fc800078e0037ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0037ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0037ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0037ULL,
0x00005e0020207625ULL, 0x000fc800078e0037ULL, 0x0000001035047825ULL, 0x000fc800078e0004ULL,
0x000000103c237824ULL, 0x000fe400078e024fULL, 0x0000001035067825ULL, 0x000fc600078e0006ULL,
0x0000000004237faeULL, 0x0003e2000c101c46ULL, 0x000000103e2d7824ULL, 0x000fe400078e024fULL,
0x0000001035087825ULL, 0x000fc600078e0008ULL, 0x00000000062d7faeULL, 0x0003e2000c901c46ULL,
0x00000010442f7824ULL, 0x000fe400078e024fULL, 0x00000010350a7825ULL, 0x000fc600078e000aULL,
0x00000000082f7faeULL, 0x0003e2000d101c46ULL, 0x00000010351c7825ULL, 0x000fc600078e001cULL,
0x000000000a317faeULL, 0x0003e2000d901c46ULL, 0x00000010351e7825ULL, 0x000fc800078e001eULL,
0x0000001035207825ULL, 0x000fc800078e0020ULL, 0x000000102c337824ULL, 0x100fe400078e024fULL,
0x000000102e357824ULL, 0x100fe400078e024fULL, 0x00000010304f7824ULL, 0x000fe200078e024fULL,
0x000000001c337faeULL, 0x0003e8000e101c46ULL, 0x000000001e357faeULL, 0x0003e8000e901c46ULL,
0x00000000204f7faeULL, 0x0003e2000f101c46ULL, 0x0000095000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fe20000011674ULL, 0x00000200ff3f7424ULL, 0x000fc600078e00ffULL,
0x0000000405097810ULL, 0x040fe40007ffe0ffULL, 0x0000001405217810ULL, 0x000fe40007ffe0ffULL,
0x0000007409067212ULL, 0x0c0fe200078e3cffULL, 0x00000008091d7824ULL, 0x000fe200078e00ffULL,
0x00000008050b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008212d7824ULL, 0x000fe200078e00ffULL,
0x00000020052f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x000fe200078e0204ULL,
0xfffffff81d447812ULL, 0x000fe200078ee206ULL, 0x000000010b1c7824ULL, 0x100fe200078e0204ULL,
0x0000000c051d7810ULL, 0x000fe20007ffe0ffULL, 0x000000082f337824ULL, 0x000fe200078e00ffULL,
0x00000010051f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000121227824ULL, 0x100fe200078e0204ULL,
0x000000741d067212ULL, 0x0c0fe200078e3cffULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x0000007421087212ULL, 0x080fe200078e3cffULL, 0x000000081f4a7824ULL, 0x000fe200078e00ffULL,
0x000000740b077212ULL, 0x000fe200078e3cffULL, 0x000000011f207824ULL, 0x000fe200078e0204ULL,
0xfffffff823487812ULL, 0x000fc400078ee206ULL, 0x0000001805237810ULL, 0x000fe40007ffe0ffULL,
0x000000030b467819ULL, 0x000fe400000006ffULL, 0x0000007423067212ULL, 0x040fe200078e3cffULL,
0x0000000823317824ULL, 0x000fe200078e00ffULL, 0xfffffff82d507812ULL, 0x000fe200078ee208ULL,
0x00000001232c7824ULL, 0x000fe200078e0204ULL, 0xfffffff846467812ULL, 0x000fe400078ee207ULL,
0xfffffff831767812ULL, 0x000fe200078ee206ULL, 0x00000010504b7824ULL, 0x000fe200078e024fULL,
0x0000002405317810ULL, 0x000fc40007ffe0ffULL, 0x000000742f087212ULL, 0x080fe200078e3cffULL,
0x00000010766f7824ULL, 0x000fe200078e024fULL, 0x000000741f077212ULL, 0x080fe200078e3cffULL,
0x0000000831377824ULL, 0x000fe200078e00ffULL, 0x0000001c052d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000131327824ULL, 0x000fe200078e0204ULL, 0x0000002c05357810ULL, 0x000fe40007ffe0ffULL,
0xfffffff833847812ULL, 0x000fe200078ee208ULL, 0x000000012d2e7824ULL, 0x100fe200078e0204ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee207ULL, 0x00000008353d7824ULL, 0x000fe200078e00ffULL,
0x0000002805337810ULL, 0x000fe20007ffe0ffULL, 0x0000000135367824ULL, 0x000fe200078e0204ULL,
0x0000007431067212ULL, 0x000fc400078e3cffULL, 0x000000742d077212ULL, 0x080fe200078e3cffULL,
0x0000000833887824ULL, 0x000fe200078e00ffULL, 0x000000032d827819ULL, 0x000fe200000006ffULL,
0x0000000133347824ULL, 0x000fe200078e0204ULL, 0x0000007435087212ULL, 0x080fe400078e3cffULL,
0xfffffff837867812ULL, 0x000fe400078ee206ULL, 0xfffffff882827812ULL, 0x000fe400078ee207ULL,
0x000000037a067819ULL, 0x000fe200000006ffULL, 0x0000001086877824ULL, 0x100fe200078e024fULL,
0x0000007433077212ULL, 0x000fe200078e3cffULL, 0x0000001082837824ULL, 0x000fe200078e024fULL,
0xfffffff83d8a7812ULL, 0x000fc400078ee208ULL, 0x0000003005377810ULL, 0x040fe40007ffe0ffULL,
0x00000034053d7810ULL, 0x040fe20007ffe0ffULL, 0x000000108a8b7824ULL, 0x000fe200078e024fULL,
0x0000003805477810ULL, 0x000fe20007ffe0ffULL, 0x00000001373c7824ULL, 0x100fe200078e0204ULL,
0x0000003c05497810ULL, 0x000fe20007ffe0ffULL, 0x000000013d3e7824ULL, 0x100fe200078e0204ULL,
0xfffffff806457812ULL, 0x000fe200078ee25dULL, 0x0000000105067824ULL, 0x100fe200078e0204ULL,
0xfffffff888887812ULL, 0x000fe200078ee207ULL, 0x0000000147907824ULL, 0x000fe200078e0204ULL,
0x0000000705077812ULL, 0x000fe200078e4874ULL, 0x0000000149947824ULL, 0x000fe200078e0204ULL,
0x000000041d1e7210ULL, 0x080fe20007ffe0ffULL, 0x000000083d8e7824ULL, 0x000fe200078e00ffULL,
0x000000042f307210ULL, 0x000fe20007ffe0ffULL, 0x00005e0006047625ULL, 0x000fe200078e003fULL,
0x0ffffff807087812ULL, 0x000fc400078ef874ULL, 0x0000007447067212ULL, 0x080fe200078e3cffULL,
0x0000000849967824ULL, 0x000fe200078e00ffULL, 0x0000007437077212ULL, 0x0c0fe200078e3cffULL,
0x0000001008337824ULL, 0x000fe200078e024fULL, 0x00000003378c7819ULL, 0x000fe200000006ffULL,
0x0000001045047825ULL, 0x000fe200078e0004ULL, 0x000000743d097212ULL, 0x080fe400078e3cffULL,
0x0000000347477819ULL, 0x000fe200000006ffULL, 0x0000001088897824ULL, 0x000fe200078e024fULL,
0x00000074490b7212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004337faeULL, 0x0003e2000b901c46ULL, 0xfffffff88c8c7812ULL, 0x000fe200078ee207ULL,
0x000000104a497824ULL, 0x000fe200078e024fULL, 0xfffffff88e8e7812ULL, 0x000fe200078ee209ULL,
0x00005e001c087625ULL, 0x000fe200078e003fULL, 0xfffffff847927812ULL, 0x000fc400078ee206ULL,
0xfffffff896967812ULL, 0x000fe200078ee20bULL, 0x00005e000a067625ULL, 0x000fe200078e003fULL,
0x0000004f48477211ULL, 0x080fe400078e20ffULL, 0x0000004f84857211ULL, 0x000fe200078e20ffULL,
0x00005e001e0a7625ULL, 0x000fe200078e003fULL, 0x0000004f8e8f7211ULL, 0x000fc600078e20ffULL,
0x00005e00201c7625ULL, 0x000fc800078e003fULL, 0x00005e00221e7625ULL, 0x000fc800078e003fULL,
0x00005e002c207625ULL, 0x000fc800078e003fULL, 0x00005e002e227625ULL, 0x000fc800078e003fULL,
0x00005e00302c7625ULL, 0x000fc800078e003fULL, 0x00005e00322e7625ULL, 0x000fc800078e003fULL,
0x00005e0034307625ULL, 0x000fc800078e003fULL, 0x00005e0036327625ULL, 0x002fc800078e003fULL,
0x00005e003c347625ULL, 0x000fc800078e003fULL, 0x00005e003e367625ULL, 0x000fc800078e003fULL,
0x00005e00903c7625ULL, 0x000fc800078e003fULL, 0x00005e00943e7625ULL, 0x000fc800078e003fULL,
0x0000001045047825ULL, 0x000fc800078e0006ULL, 0x0000001045067825ULL, 0x000fc800078e0008ULL,
0x0000001045087825ULL, 0x000fc800078e000aULL, 0x00000010450a7825ULL, 0x000fc800078e001cULL,
0x00000010451c7825ULL, 0x000fc800078e001eULL, 0x0000001045207825ULL, 0x000fc800078e0020ULL,
0x0000001045227825ULL, 0x000fc800078e0022ULL, 0x00000010452c7825ULL, 0x000fc800078e002cULL,
0x00000010452e7825ULL, 0x000fc800078e002eULL, 0x0000001045307825ULL, 0x000fc800078e0030ULL,
0x0000001045327825ULL, 0x000fc800078e0032ULL, 0x0000001045347825ULL, 0x000fc800078e0034ULL,
0x0000001045367825ULL, 0x000fc800078e0036ULL, 0x00000010453c7825ULL, 0x000fc800078e003cULL,
0x00000010453e7825ULL, 0x000fc800078e003eULL, 0x00000010441f7824ULL, 0x100fe400078e024fULL,
0x0000001046457824ULL, 0x100fe400078e024fULL, 0x000000108c8d7824ULL, 0x100fe200078e024fULL,
0x00000000041f7faeULL, 0x0003e2000b901c46ULL, 0x0000001092917824ULL, 0x100fe400078e024fULL,
0x00000010964f7824ULL, 0x000fe200078e024fULL, 0x0000000006457faeULL, 0x0003e8000b901c46ULL,
0x0000000008477faeULL, 0x0003e8000b901c46ULL, 0x000000000a497faeULL, 0x0003e8000b901c46ULL,
0x000000001c4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000206f7faeULL, 0x0003e8000b901c46ULL,
0x0000000022837faeULL, 0x0003e8000b901c46ULL, 0x000000002c857faeULL, 0x0003e8000b901c46ULL,
0x000000002e877faeULL, 0x0003e8000b901c46ULL, 0x0000000030897faeULL, 0x0003e8000b901c46ULL,
0x00000000328b7faeULL, 0x0003e8000b901c46ULL, 0x00000000348d7faeULL, 0x0003e8000b901c46ULL,
0x00000000368f7faeULL, 0x0003e8000b901c46ULL, 0x000000003c917faeULL, 0x0003e8000b901c46ULL,
0x000000003e4f7faeULL, 0x0003e4000b901c46ULL, 0x02462c00ff047984ULL, 0x002e620000000800ULL,
0x8000000061057824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fe200078e00ffULL,
0x0000001f61067819ULL, 0x000fc600000006ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x02462c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x024100005f047984ULL, 0x000e620000000800ULL, 0x0000200065067824ULL, 0x000fe200078e00ffULL,
0x00013000591d7811ULL, 0x000fe200078e20ffULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x024300005f507984ULL, 0x0004e20000000800ULL, 0x0000006b0400720bULL, 0x002fda0003f1d000ULL,
0x0000000000057806ULL, 0x000fc800000e0100ULL, 0x0000ffff05087812ULL, 0x000fe4000780c0ffULL,
0x0000200006057812ULL, 0x000fca00078ee2ffULL, 0x000040007a4f7824ULL, 0x000fcc00078e0205ULL,
0x0000034000008947ULL, 0x000fea0003800000ULL, 0x0000006b0400720bULL, 0x00cfe40003f14000ULL,
0x000000046b067209ULL, 0x000fe40007810000ULL, 0x00000002ff0b7819ULL, 0x000fc60000011674ULL,
0x800000066b057221ULL, 0x040fe20000010000ULL, 0x000000046b6b7209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b05077820ULL, 0x000fe40000410000ULL, 0x0000000000057806ULL, 0x000fe400000e0100ULL,
0x00000007000a7308ULL, 0x000e620000000800ULL, 0x000000027a00780cULL, 0x000fe40003f05270ULL,
0x0000ffff05097812ULL, 0x000fc800078e3cffULL, 0x0000000908ff7212ULL, 0x000fc8000782c0ffULL,
0x00000001ff1c7807ULL, 0x000fc60000800000ULL, 0x024500065f008388ULL, 0x000fe20000000800ULL,
0x0000000a69697220ULL, 0x002fc60000410000ULL, 0x00001f0b0a057589ULL, 0x000e6400000e0000ULL,
0x8000000604091221ULL, 0x000fe40000010000ULL, 0x00001f570a087589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b09091820ULL, 0x000fc80000410000ULL, 0x00000009005b1308ULL, 0x000ee20000000800ULL,
0x0000000514147220ULL, 0x082fe40000410000ULL, 0x0000000515157220ULL, 0x080fe40000410000ULL,
0x0000000540407220ULL, 0x080fe40000410000ULL, 0x0000000541417220ULL, 0x080fe40000410000ULL,
0x0000000518187220ULL, 0x080fe40000410000ULL, 0x0000000519197220ULL, 0x000fc40000410000ULL,
0x0000000528287220ULL, 0x080fe40000410000ULL, 0x0000000529297220ULL, 0x080fe40000410000ULL,
0x000000050c0c7220ULL, 0x080fe40000410000ULL, 0x000000050d0d7220ULL, 0x080fe40000410000ULL,
0x0000000538387220ULL, 0x080fe40000410000ULL, 0x0000000539397220ULL, 0x000fc40000410000ULL,
0x0000000510107220ULL, 0x080fe40000410000ULL, 0x0000000511117220ULL, 0x080fe40000410000ULL,
0x0000000524247220ULL, 0x080fe40000410000ULL, 0x0000000525257220ULL, 0x000fe40000410000ULL,
0x0000000816167220ULL, 0x084fe40000410000ULL, 0x0000000817177220ULL, 0x000fc40000410000ULL,
0x0000000842427220ULL, 0x080fe40000410000ULL, 0x0000000843437220ULL, 0x080fe40000410000ULL,
0x000000081a1a7220ULL, 0x080fe40000410000ULL, 0x000000081b1b7220ULL, 0x080fe40000410000ULL,
0x000000082a2a7220ULL, 0x080fe40000410000ULL, 0x000000082b2b7220ULL, 0x000fc40000410000ULL,
0x000000080e0e7220ULL, 0x080fe40000410000ULL, 0x000000080f0f7220ULL, 0x080fe40000410000ULL,
0x000000083a3a7220ULL, 0x080fe40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x0000000812127220ULL, 0x080fe40000410000ULL, 0x0000000813137220ULL, 0x000fc40000410000ULL,
0x0000000826267220ULL, 0x080fe40000410000ULL, 0x0000000827277220ULL, 0x000fe40000410000ULL,
0x000000505b501220ULL, 0x008fe40000410000ULL, 0x000140004f4f7810ULL, 0x00cfe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001d04783bULL, 0x000fe20000000200ULL,
0x0000001070087824ULL, 0x100fe200078e024fULL, 0x0000005bff1e723eULL, 0x000fe200000000ffULL,
0x000000106a2c7824ULL, 0x100fe200078e024fULL, 0x00000002ff6f7819ULL, 0x000fe20000011674ULL,
0x00000010663c7824ULL, 0x100fe200078e024fULL, 0x000054101e2e7816ULL, 0x000fe2000000001eULL,
0x000000000808783bULL, 0x000fe20000004200ULL, 0x0000004f6e1e7211ULL, 0x000fe200078e20ffULL,
0x0000001068347824ULL, 0x100fe200078e024fULL, 0x000099101c207816ULL, 0x000fe200000000ffULL,
0x00001f6f2e6f7589ULL, 0x000e6200000e0000ULL, 0x0001300055447811ULL, 0x000fe200078e20ffULL,
0x0000001062627824ULL, 0x100fe200078e024fULL, 0x000000ff2000720cULL, 0x000fe20003f05270ULL,
0x00001f572e6e7589ULL, 0x000ea200000e0000ULL, 0x000000106c207824ULL, 0x000fc400078e024fULL,
0x0000001058487824ULL, 0x000fe200078e024fULL, 0x000000001e1c783bULL, 0x000ee80000004200ULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000002c2c783bULL, 0x000fe80000004200ULL,
0x000000003c3c783bULL, 0x000fe80000004200ULL, 0x000000003434783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x0000006f04048232ULL, 0x002fc40000000000ULL,
0x0000006f06068232ULL, 0x000fe40000000000ULL, 0x0000006e05058232ULL, 0x084fe40000000000ULL,
0x0000006e07078232ULL, 0x000fce0000000000ULL, 0x000000080430723cULL, 0x040fe20000001814ULL,
0x000000004414783bULL, 0x0002ae0000000200ULL, 0x0000001c0418723cULL, 0x008fe20000001818ULL,
0x0001300053447811ULL, 0x002fce00078e20ffULL, 0x0000001e041c723cULL, 0x040fee0000001828ULL,
0x0000004f64287211ULL, 0x080fe200078e20ffULL, 0x00000020040c723cULL, 0x050fea000000180cULL,
0x000000002828783bULL, 0x000e660000004200ULL, 0x0000000a0408723cULL, 0x040fee0000001840ULL,
0x0000004f5a407211ULL, 0x000fe200078e20ffULL, 0x000000220420723cULL, 0x000fe20000001838ULL,
0x0000006f14148232ULL, 0x004fc40000000000ULL, 0x0000006f16168232ULL, 0x000fe40000000000ULL,
0x0000006e15158232ULL, 0x080fe20000000000ULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x0000006e17178232ULL, 0x000fe20000000000ULL, 0x0000002c0410723cULL, 0x000fe20000001810ULL,
0x000000105c387824ULL, 0x000fcc00078e024fULL, 0x00000010602c7824ULL, 0x100fe200078e024fULL,
0x0000002e0424723cULL, 0x000fe20000001824ULL, 0x000000006204783bULL, 0x000ea80000004200ULL,
0x000000003838783bULL, 0x000fe60000004200ULL, 0x0000003c1418723cULL, 0x040fe20000001818ULL,
0x000000002c2c783bULL, 0x000fee0000004200ULL, 0x0000003e143c723cULL, 0x040fe2000000181cULL,
0x00000000441c783bULL, 0x00072e0000000200ULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x0000001056447824ULL, 0x008fcc00078e024fULL, 0x000000105e347824ULL, 0x000fe200078e024fULL,
0x000000361408723cULL, 0x040fe20000001808ULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x000000003434783bULL, 0x000ee60000004200ULL, 0x00000028140c723cULL, 0x042ff0000000180cULL,
0x0000002a1428723cULL, 0x040fee0000001820ULL, 0x0001300051207811ULL, 0x000fe200078e20ffULL,
0x000000041410723cULL, 0x004fe20000001810ULL, 0x0000006f1c1c8232ULL, 0x010fc40000000000ULL,
0x0000006f1e1e8232ULL, 0x000fe40000000000ULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x0000006e1d1d8232ULL, 0x080fe20000000000ULL, 0x0000001054047824ULL, 0x000fe200078e024fULL,
0x000000061414723cULL, 0x000fe20000001824ULL, 0x0000006e1f1f8232ULL, 0x000fc80000000000ULL,
0x000000000404783bULL, 0x000fe40000004200ULL, 0x0000001052247824ULL, 0x000fe200078e024fULL,
0x000000381c0c723cULL, 0x040fea000000180cULL, 0x000000002424783bULL, 0x000ea60000004200ULL,
0x0000002c1c30723cULL, 0x040ff00000001830ULL, 0x0000002e1c08723cULL, 0x040ff00000001808ULL,
0x000000341c18723cULL, 0x008fe20000001818ULL, 0x0000006f20208232ULL, 0x002fc40000000000ULL,
0x0000006f22228232ULL, 0x000fca0000000000ULL, 0x000000361c3c723cULL, 0x000fe2000000183cULL,
0x0000006e21218232ULL, 0x080fe40000000000ULL, 0x0000006e23238232ULL, 0x000fca0000000000ULL,
0x0000003a1c38723cULL, 0x040ff00000001828ULL, 0x000000401c10723cULL, 0x040ff00000001810ULL,
0x000000421c1c723cULL, 0x000ff00000001814ULL, 0x000000482014723cULL, 0x040ff00000001830ULL,
0x000000242010723cULL, 0x044ff00000001810ULL, 0x0000004a2040723cULL, 0x040ff00000001808ULL,
0x000000442018723cULL, 0x040ff00000001818ULL, 0x000000462028723cULL, 0x040ff0000000183cULL,
0x00000004200c723cULL, 0x040ff0000000180cULL, 0x000000062038723cULL, 0x040ff00000001838ULL,
0x000000262024723cULL, 0x000fe2000000181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c072727810ULL, 0x000fe20007ffe0ffULL, 0x02463000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000006950697221ULL, 0x000fe20000010000ULL, 0x0000006300057202ULL, 0x000fc40000000f00ULL,
0x000000797200720cULL, 0x000fda0003f06070ULL, 0x00001e7000000947ULL, 0x000fea0003800000ULL,
0x000003007b047a10ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000104057810ULL, 0x040fe20007ffe0ffULL, 0x0000010004067824ULL, 0x000fc600078e00ffULL,
0x000000780500720cULL, 0x000fe20003f06070ULL, 0x000062006d047a24ULL, 0x000fd800078e0206ULL,
0x00000a9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff337819ULL, 0x000fe20000011674ULL,
0x000000087a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000679057217ULL, 0x000fe20007800000ULL,
0x00000200ff357424ULL, 0x000fe200078e00ffULL, 0x00000008330b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000433097810ULL, 0x000fe40007ffe0ffULL, 0x000000740b087212ULL, 0x0c0fe200078e3cffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x00000010332f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809207824ULL, 0x040fe200078e00ffULL, 0x0000007409077212ULL, 0x000fc400078e3cffULL,
0xfffffff81d227812ULL, 0x000fe200078ee208ULL, 0x000000082f2e7824ULL, 0x000fe200078e00ffULL,
0x0000000c331d7810ULL, 0x040fe40007ffe0ffULL, 0x0000001433317810ULL, 0x040fe40007ffe0ffULL,
0x0000001833377810ULL, 0x000fe20007ffe0ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x0000000506057210ULL, 0x000fe20007ffe1ffULL, 0x0000000831217824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000837237824ULL, 0x000fe200078e00ffULL,
0x00000020333f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1c7824ULL, 0x040fe200078e0204ULL,
0x000000741d067212ULL, 0x000fc400078e3cffULL, 0x000000742f077212ULL, 0x080fe200078e3cffULL,
0x000000083f367824ULL, 0x000fe200078e00ffULL, 0xfffffff80a5d7812ULL, 0x000fe400078ee25dULL,
0x0000007431087212ULL, 0x080fe400078e3cffULL, 0x0000001c333d7810ULL, 0x040fe40007ffe0ffULL,
0x0000002433457810ULL, 0x000fe40007ffe0ffULL, 0x00000074370a7212ULL, 0x000fc400078e3cffULL,
0x0000002833477810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f2c7812ULL, 0x000fe400078ee206ULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee207ULL, 0xfffffff821307812ULL, 0x000fe200078ee208ULL,
0x0000000845217824ULL, 0x000fe200078e00ffULL, 0x000000743d067212ULL, 0x040fe200078e3cffULL,
0x000000102c2d7824ULL, 0x000fe200078e024fULL, 0x000000033d1f7819ULL, 0x000fc400000006ffULL,
0x000000743f077212ULL, 0x080fe400078e3cffULL, 0xfffffff823327812ULL, 0x000fe200078ee20aULL,
0x0000000847237824ULL, 0x000fe200078e00ffULL, 0x0000007445087212ULL, 0x080fe400078e3cffULL,
0x00000074470a7212ULL, 0x000fe400078e3cffULL, 0xfffffff81f347812ULL, 0x000fe400078ee206ULL,
0xfffffff836367812ULL, 0x000fc400078ee207ULL, 0x0000004005057817ULL, 0x000fe40003800000ULL,
0x0000000733077812ULL, 0x040fe400078e4874ULL, 0x0000000433067210ULL, 0x000fe40007ffe0ffULL,
0xfffffff8213c7812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x000fe200078e0204ULL,
0xfffffff8233e7812ULL, 0x000fe200078ee20aULL, 0x000000010b0a7824ULL, 0x000fe200078e0204ULL,
0x000000053300720cULL, 0x000fe20003f06070ULL, 0x0000001020217824ULL, 0x000fe200078e024fULL,
0x0ffffff8071e7812ULL, 0x000fe200078ef874ULL, 0x00005e0006067625ULL, 0x000fe200078e0035ULL,
0x000000050900720cULL, 0x000fc40003f26070ULL, 0x000000050b00720cULL, 0x000fe20003f46070ULL,
0x00005e0008087625ULL, 0x000fe200078e0035ULL, 0x000000051d00720cULL, 0x000fe40003f66070ULL,
0x0000004f1e1f7211ULL, 0x000fe200078e20ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0035ULL,
0x0000000431207210ULL, 0x000fe40007ffe0ffULL, 0x000000053f00720cULL, 0x000fe20003f86070ULL,
0x00005e001c1c7625ULL, 0x000fe200078e0035ULL, 0x0000002c33497810ULL, 0x000fc60007ffe0ffULL,
0x000000105d067825ULL, 0x000fe200078e0006ULL, 0x0000007449447212ULL, 0x000fc600078e3cffULL,
0x000000105d087825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000061f7faeULL, 0x0003e2000c101c46ULL, 0x000000052f00720cULL, 0x080fe40003f06070ULL,
0x0000001022237824ULL, 0x000fe200078e024fULL, 0x0000000008217faeULL, 0x0005e2000c901c46ULL,
0x000000105d0a7825ULL, 0x000fe200078e000aULL, 0x000000053100720cULL, 0x000fc60003f26070ULL,
0x000000105d1c7825ULL, 0x000fe200078e001cULL, 0x000000000a237faeULL, 0x0007e2000d101c46ULL,
0x000000053700720cULL, 0x080fe40003f46070ULL, 0x000000012f1e7824ULL, 0x100fe200078e0204ULL,
0x000000001c2d7faeULL, 0x0009e2000d901c46ULL, 0x0000000137227824ULL, 0x100fe200078e0204ULL,
0x000000053d00720cULL, 0x040fe20003f66070ULL, 0x000000013d1f7824ULL, 0x102fe200078e0204ULL,
0x0000003033377810ULL, 0x000fe20007ffe0ffULL, 0x000000013f217824ULL, 0x004fe200078e0204ULL,
0x00000034333d7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001e067625ULL, 0x000fe200078e0035ULL,
0x0000004f30237211ULL, 0x008fc400078e20ffULL, 0x00000038333f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0020087625ULL, 0x000fe200078e0035ULL, 0x0000003c33337810ULL, 0x000fe40007ffe0ffULL,
0x000000053f00720cULL, 0x000fe20003fa6070ULL, 0x00005e00220a7625ULL, 0x000fe200078e0035ULL,
0x000000053300720cULL, 0x000fe40003fc6070ULL, 0x000000033d2c7819ULL, 0x000fe200000006ffULL,
0x00005e001f1c7625ULL, 0x010fc800078e0035ULL, 0x00005e00211e7625ULL, 0x000fc800078e0035ULL,
0x000000102e217824ULL, 0x000fe400078e024fULL, 0x000000105d067825ULL, 0x000fc800078e0006ULL,
0x000000105d087825ULL, 0x000fe200078e0008ULL, 0x0000000006217faeULL, 0x0003e2000c101c46ULL,
0x000000054500720cULL, 0x080fe40003f06070ULL, 0x00000010322d7824ULL, 0x000fe200078e024fULL,
0x0000000008237faeULL, 0x0005e2000c901c46ULL, 0x000000105d0a7825ULL, 0x000fe200078e000aULL,
0x000000054700720cULL, 0x000fc60003f26070ULL, 0x00000010342f7824ULL, 0x000fe200078e024fULL,
0x000000000a2d7faeULL, 0x0007e2000d101c46ULL, 0x000000105d1c7825ULL, 0x000fe200078e001cULL,
0x000000054900720cULL, 0x080fe40003f46070ULL, 0x0000000447067210ULL, 0x002fe20007ffe0ffULL,
0x0000001036317824ULL, 0x000fe200078e024fULL, 0x000000001c2f7faeULL, 0x0003e2000d901c46ULL,
0x000000105d1e7825ULL, 0x000fe200078e001eULL, 0x000000053700720cULL, 0x0c0fe40003f66070ULL,
0x0000007437077212ULL, 0x080fe200078e3cffULL, 0x0000000149087824ULL, 0x104fe200078e0204ULL,
0x000000001e317faeULL, 0x0005e2000e101c46ULL, 0x000000053d00720cULL, 0x000fe20003f86070ULL,
0x0000000145057824ULL, 0x100fe200078e0204ULL, 0x000000743d097212ULL, 0x080fe200078e3cffULL,
0x00000001370a7824ULL, 0x108fe200078e0204ULL, 0x00000074330b7212ULL, 0x000fe200078e3cffULL,
0x000000013d1c7824ULL, 0x102fe200078e0204ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL,
0x0000000133207824ULL, 0x000fe200078e0204ULL, 0x0000004f3c237211ULL, 0x000fe200078e20ffULL,
0x0000000837227824ULL, 0x000fc400078e00ffULL, 0x000000013f1e7824ULL, 0x044fe200078e0204ULL,
0x000000743f047212ULL, 0x040fe200078e3cffULL, 0x000000083f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x0000000833307824ULL, 0x000fe400078e00ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f2e7812ULL, 0x000fe200078ee204ULL,
0x00005e0005047625ULL, 0x080fe200078e0035ULL, 0xfffffff830307812ULL, 0x000fe400078ee20bULL,
0xfffffff84b447812ULL, 0x000fe200078ee244ULL, 0x00005e0006067625ULL, 0x000fc800078e0035ULL,
0x00005e0008087625ULL, 0x000fc800078e0035ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0035ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0035ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0035ULL,
0x00005e0020207625ULL, 0x000fe200078e0035ULL, 0x0000004f2e357211ULL, 0x000fc600078e20ffULL,
0x000000105d047825ULL, 0x000fc800078e0004ULL, 0x000000105d067825ULL, 0x040fe200078e0006ULL,
0x0000000004237faeULL, 0x0003e6000c101c46ULL, 0x000000103e2d7824ULL, 0x000fe400078e024fULL,
0x000000105d087825ULL, 0x000fc600078e0008ULL, 0x00000000062d7faeULL, 0x0003e2000c901c46ULL,
0x00000010442f7824ULL, 0x000fe400078e024fULL, 0x000000105d0a7825ULL, 0x000fc600078e000aULL,
0x00000000082f7faeULL, 0x0003e2000d101c46ULL, 0x0000001022317824ULL, 0x000fe400078e024fULL,
0x000000105d1c7825ULL, 0x000fc600078e001cULL, 0x000000000a317faeULL, 0x0003e2000d901c46ULL,
0x000000102c337824ULL, 0x000fe400078e024fULL, 0x000000105d1e7825ULL, 0x000fc600078e001eULL,
0x000000001c337faeULL, 0x0003e2000e101c46ULL, 0x000000105d207825ULL, 0x000fc600078e0020ULL,
0x000000001e357faeULL, 0x0003e2000e901c46ULL, 0x00000010304f7824ULL, 0x000fca00078e024fULL,
0x00000000204f7faeULL, 0x0003e2000f101c46ULL, 0x0000095000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fe20000011674ULL, 0x000000087a0a7824ULL, 0x000fc600078e00ffULL,
0x0000000405097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c051d7810ULL, 0x000fe40007ffe0ffULL,
0x0000007409067212ULL, 0x0c0fe200078e3cffULL, 0x00000008091f7824ULL, 0x000fe200078e00ffULL,
0x0000001c052d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1e7824ULL, 0x000fe200078e0204ULL,
0x0000001805237810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f3e7812ULL, 0x000fe200078ee206ULL,
0x000000082d337824ULL, 0x000fe200078e00ffULL, 0x00000010051f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823317824ULL, 0x000fe200078e00ffULL, 0x00000008050b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001232c7824ULL, 0x100fe200078e0204ULL, 0x000000741d087212ULL, 0x080fe200078e3cffULL,
0x000000081f2f7824ULL, 0x000fe200078e00ffULL, 0x000000031d217819ULL, 0x000fe200000006ffULL,
0x000000080b447824ULL, 0x040fe200078e00ffULL, 0xfffffff80a5d7812ULL, 0x000fe200078ee25dULL,
0x000000010b1c7824ULL, 0x100fe200078e0204ULL, 0x000000741f067212ULL, 0x0c0fe200078e3cffULL,
0x000000011f207824ULL, 0x100fe200078e0204ULL, 0x000000742d0a7212ULL, 0x040fe200078e3cffULL,
0x000000012d2e7824ULL, 0x000fe200078e0204ULL, 0xfffffff821467812ULL, 0x000fc400078ee208ULL,
0x0000001405217810ULL, 0x000fe40007ffe0ffULL, 0x0000007423087212ULL, 0x080fe400078e3cffULL,
0x000000740b077212ULL, 0x080fe200078e3cffULL, 0x00000008214a7824ULL, 0x000fe200078e00ffULL,
0x0000002c05357810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82f487812ULL, 0x000fe400078ee206ULL,
0xfffffff833527812ULL, 0x000fe200078ee20aULL, 0x00000008353f7824ULL, 0x000fe200078e00ffULL,
0x00000020052f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000135367824ULL, 0x000fe200078e0204ULL,
0x0000002805337810ULL, 0x000fe20007ffe0ffULL, 0x0000001048497824ULL, 0x000fe200078e024fULL,
0xfffffff831507812ULL, 0x000fe200078ee208ULL, 0x000000012f307824ULL, 0x000fe200078e0204ULL,
0xfffffff844447812ULL, 0x000fe200078ee207ULL, 0x00000008333d7824ULL, 0x000fe200078e00ffULL,
0x0000002405317810ULL, 0x000fe20007ffe0ffULL, 0x0000001052637824ULL, 0x000fe200078e024fULL,
0x0000007421077212ULL, 0x000fc400078e3cffULL, 0x000000742f067212ULL, 0x080fe200078e3cffULL,
0x0000000831567824ULL, 0x000fe200078e00ffULL, 0x000000032f377819ULL, 0x000fe200000006ffULL,
0x0000000131327824ULL, 0x000fe200078e0204ULL, 0x00000074350a7212ULL, 0x080fe400078e3cffULL,
0x0000007433087212ULL, 0x080fe400078e3cffULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee207ULL,
0x0000007431077212ULL, 0x000fc400078e3cffULL, 0xfffffff837547812ULL, 0x000fe400078ee206ULL,
0xfffffff83f5a7812ULL, 0x000fe200078ee20aULL, 0x00000001090a7824ULL, 0x100fe200078e0204ULL,
0x0000003005377810ULL, 0x040fe20007ffe0ffULL, 0x00000010546f7824ULL, 0x100fe200078e024fULL,
0x00000034053f7810ULL, 0x040fe20007ffe0ffULL, 0x000000105a877824ULL, 0x000fe200078e024fULL,
0x0000003805457810ULL, 0x000fe20007ffe0ffULL, 0x00000001373c7824ULL, 0x100fe200078e0204ULL,
0x0000003c05477810ULL, 0x000fe20007ffe0ffULL, 0x000000013f5e7824ULL, 0x000fe200078e0204ULL,
0xfffffff83d587812ULL, 0x000fe200078ee208ULL, 0x00000200ff3d7424ULL, 0x000fe200078e00ffULL,
0x0000000405067210ULL, 0x080fe20007ffe0ffULL, 0x0000000145627824ULL, 0x100fe200078e0204ULL,
0xfffffff856567812ULL, 0x000fe200078ee207ULL, 0x0000000147667824ULL, 0x000fe200078e0204ULL,
0x0000000705077812ULL, 0x000fe200078e4874ULL, 0x00000008375c7824ULL, 0x000fe200078e00ffULL,
0x0000000421227210ULL, 0x080fe20007ffe0ffULL, 0x0000000847687824ULL, 0x000fe200078e00ffULL,
0x0000000433347210ULL, 0x000fe20007ffe0ffULL, 0x00005e0006047625ULL, 0x000fe200078e003dULL,
0x0000007445067212ULL, 0x000fc400078e3cffULL, 0x0ffffff807087812ULL, 0x000fe200078ef874ULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0x0000007437077212ULL, 0x080fe200078e3cffULL,
0x000000105d047825ULL, 0x000fe200078e0004ULL, 0x000000743f097212ULL, 0x0c0fe400078e3cffULL,
0x000000033f607819ULL, 0x000fe200000006ffULL, 0x000000103e3f7824ULL, 0x100fe200078e024fULL,
0x00000074470b7212ULL, 0x000fe200078e3cffULL, 0x0000001046477824ULL, 0x100fe200078e024fULL,
0x0000004f08337211ULL, 0x000fe200078e20ffULL, 0x0000001056837824ULL, 0x000fe200078e024fULL,
0xfffffff85c5c7812ULL, 0x000fc400078ee207ULL, 0xfffffff860607812ULL, 0x000fe200078ee209ULL,
0x00005e001c087625ULL, 0x080fe200078e003dULL, 0xfffffff845647812ULL, 0x000fe200078ee206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004337faeULL, 0x0003e2000b901c46ULL,
0xfffffff868687812ULL, 0x000fe200078ee20bULL, 0x00005e000a067625ULL, 0x000fe200078e003dULL,
0x0000004f4a4b7211ULL, 0x080fe400078e20ffULL, 0x0000004f58857211ULL, 0x000fe200078e20ffULL,
0x00005e001e0a7625ULL, 0x000fc800078e003dULL, 0x00005e00201c7625ULL, 0x000fc800078e003dULL,
0x00005e00221e7625ULL, 0x000fc800078e003dULL, 0x00005e002c207625ULL, 0x000fc800078e003dULL,
0x00005e002e227625ULL, 0x000fc800078e003dULL, 0x00005e00302c7625ULL, 0x000fc800078e003dULL,
0x00005e00322e7625ULL, 0x000fc800078e003dULL, 0x00005e0034307625ULL, 0x000fc800078e003dULL,
0x00005e0036047625ULL, 0x002fc800078e003dULL, 0x00005e003c327625ULL, 0x000fc800078e003dULL,
0x00005e005e347625ULL, 0x000fc800078e003dULL, 0x00005e0062367625ULL, 0x000fc800078e003dULL,
0x00005e00663c7625ULL, 0x000fc800078e003dULL, 0x000000105d067825ULL, 0x000fc800078e0006ULL,
0x000000105d087825ULL, 0x040fe200078e0008ULL, 0x00000000063f7faeULL, 0x0003e6000b901c46ULL,
0x0000001044457824ULL, 0x000fe400078e024fULL, 0x000000105d0a7825ULL, 0x000fc600078e000aULL,
0x0000000008457faeULL, 0x0003e2000b901c46ULL, 0x000000105d1c7825ULL, 0x000fc600078e001cULL,
0x000000000a477faeULL, 0x0003e2000b901c46ULL, 0x000000105d1e7825ULL, 0x000fc600078e001eULL,
0x000000001c497faeULL, 0x0003e2000b901c46ULL, 0x000000105d207825ULL, 0x000fc600078e0020ULL,
0x000000001e4b7faeULL, 0x0003e2000b901c46ULL, 0x000000105d227825ULL, 0x000fc800078e0022ULL,
0x000000105d2c7825ULL, 0x000fc800078e002cULL, 0x000000105d2e7825ULL, 0x000fc800078e002eULL,
0x000000105d307825ULL, 0x000fc800078e0030ULL, 0x000000105d047825ULL, 0x000fc800078e0004ULL,
0x000000105d327825ULL, 0x000fc800078e0032ULL, 0x000000105d347825ULL, 0x000fc800078e0034ULL,
0x000000105d367825ULL, 0x000fc800078e0036ULL, 0x000000105d3c7825ULL, 0x000fc800078e003cULL,
0x00000010505d7824ULL, 0x100fe400078e024fULL, 0x000000105c897824ULL, 0x100fe400078e024fULL,
0x00000010608b7824ULL, 0x100fe200078e024fULL, 0x00000000205d7faeULL, 0x0003e2000b901c46ULL,
0x00000010648d7824ULL, 0x000fe200078e024fULL, 0x0000004f684f7211ULL, 0x000fe400078e20ffULL,
0x0000000022637faeULL, 0x0003e8000b901c46ULL, 0x000000002c6f7faeULL, 0x0003e8000b901c46ULL,
0x000000002e837faeULL, 0x0003e8000b901c46ULL, 0x0000000030857faeULL, 0x0003e8000b901c46ULL,
0x0000000004877faeULL, 0x0003e8000b901c46ULL, 0x0000000032897faeULL, 0x0003e8000b901c46ULL,
0x00000000348b7faeULL, 0x0003e8000b901c46ULL, 0x00000000368d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c4f7faeULL, 0x0003e4000b901c46ULL, 0x02463c00ff047984ULL, 0x002e620000000800ULL,
0x8000000061057824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000061067824ULL, 0x000fe400078e00ffULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x02463c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x024180005f047984ULL, 0x000e620000000800ULL, 0x00013800591c7811ULL, 0x000fc600078e20ffULL,
0x024380005f087984ULL, 0x0004e20000000800ULL, 0x0000006b0400720bULL, 0x002fda0003f1d000ULL,
0x0000000000057806ULL, 0x000fc800000e0100ULL, 0x0000ffff05077812ULL, 0x000fe2000780c0ffULL,
0x00000001ff057424ULL, 0x000fd800078e00ffULL, 0x0000034000008947ULL, 0x000fea0003800000ULL,
0x0000006b0400720bULL, 0x00cfe40003f14000ULL, 0x000000046b1e7209ULL, 0x000fe40007810000ULL,
0x00000002ff097819ULL, 0x000fc60000011674ULL, 0x8000001e6b057221ULL, 0x000fe20000010000ULL,
0x0000001e006b7202ULL, 0x000fc60000000f00ULL, 0x3fb8aa3b05067820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400000e0100ULL, 0x000000037a00780cULL, 0x000fe40003f05270ULL,
0x0000ffff050a7812ULL, 0x000fe200078e3cffULL, 0x0000000600067308ULL, 0x000e660000000800ULL,
0x0000000a07ff7212ULL, 0x000fce000782c0ffULL, 0x0245801e5f008388ULL, 0x000fe80000000800ULL,
0x00001f0906057589ULL, 0x002e6400000e0000ULL, 0x8000001e04071221ULL, 0x000fe40000010000ULL,
0x0000000669697220ULL, 0x000fe20000410000ULL, 0x00001f5706047589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b07071820ULL, 0x000fc80000410000ULL, 0x00000007005b1308ULL, 0x000ee20000000800ULL,
0x0000000514147220ULL, 0x082fe40000410000ULL, 0x0000000515157220ULL, 0x080fe40000410000ULL,
0x0000000540407220ULL, 0x080fe40000410000ULL, 0x0000000541417220ULL, 0x080fe40000410000ULL,
0x0000000518187220ULL, 0x080fe40000410000ULL, 0x0000000519197220ULL, 0x000fc40000410000ULL,
0x0000000528287220ULL, 0x080fe40000410000ULL, 0x0000000529297220ULL, 0x080fe40000410000ULL,
0x000000050c0c7220ULL, 0x080fe40000410000ULL, 0x000000050d0d7220ULL, 0x080fe40000410000ULL,
0x0000000538387220ULL, 0x080fe40000410000ULL, 0x0000000539397220ULL, 0x000fc40000410000ULL,
0x0000000510107220ULL, 0x080fe40000410000ULL, 0x0000000511117220ULL, 0x080fe40000410000ULL,
0x0000000524247220ULL, 0x080fe40000410000ULL, 0x0000000525257220ULL, 0x000fe20000410000ULL,
0x00000001ff057807ULL, 0x000fe20000800000ULL, 0x0000000416167220ULL, 0x084fe40000410000ULL,
0x0000000417177220ULL, 0x000fc40000410000ULL, 0x0000000442427220ULL, 0x080fe40000410000ULL,
0x0000000443437220ULL, 0x080fe40000410000ULL, 0x000000041a1a7220ULL, 0x080fe40000410000ULL,
0x000000041b1b7220ULL, 0x080fe40000410000ULL, 0x000000042a2a7220ULL, 0x080fe40000410000ULL,
0x000000042b2b7220ULL, 0x000fc40000410000ULL, 0x000000040e0e7220ULL, 0x080fe40000410000ULL,
0x000000040f0f7220ULL, 0x080fe40000410000ULL, 0x000000043a3a7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x080fe40000410000ULL, 0x0000000412127220ULL, 0x080fe40000410000ULL,
0x0000000413137220ULL, 0x000fc40000410000ULL, 0x0000000426267220ULL, 0x080fe40000410000ULL,
0x0000000427277220ULL, 0x000fe40000410000ULL, 0x000000085b081220ULL, 0x008fe40000410000ULL,
0x000080400000791aULL, 0x00cfc80000000000ULL, 0x000000001c1c783bULL, 0x000fe20000000200ULL,
0x0000005bff04723eULL, 0x000fe400000000ffULL, 0x00000002ff097819ULL, 0x000fe20000011674ULL,
0x000000004e20783bULL, 0x000fe20000004200ULL, 0x0000541004447816ULL, 0x000fe40000000004ULL,
0x0000991005057816ULL, 0x000fe200000000ffULL, 0x000000004d2c783bULL, 0x000fe20000004200ULL,
0x0001380055047811ULL, 0x000fe400078e20ffULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x000000004c30783bULL, 0x000fe20000004200ULL, 0x0001380053537811ULL, 0x000fc400078e20ffULL,
0x0001380051517811ULL, 0x000fe200078e20ffULL, 0x00001f0944097589ULL, 0x000e6800000e0000ULL,
0x00001f57440a7589ULL, 0x000ea800000e0000ULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000334783bULL, 0x000f280000004200ULL, 0x00000000023c783bULL, 0x000f620000004200ULL,
0x000000091c1c8232ULL, 0x002fc40000000000ULL, 0x000000091e1e8232ULL, 0x000fe40000000000ULL,
0x0000000a1d1d8232ULL, 0x084fe40000000000ULL, 0x0000000a1f1f8232ULL, 0x000fce0000000000ULL,
0x000000201c14723cULL, 0x040ff00000001814ULL, 0x000000221c20723cULL, 0x000fe20000001840ULL,
0x0000000904048232ULL, 0x088fe40000000000ULL, 0x0000000906068232ULL, 0x000fc40000000000ULL,
0x0000000a05058232ULL, 0x000fc60000000000ULL, 0x0000002c1c40723cULL, 0x040fe20000001818ULL,
0x0000000a07078232ULL, 0x000fe20000000000ULL, 0x000000005318783bULL, 0x000e6c0000000200ULL,
0x0000002e1c28723cULL, 0x040ff00000001828ULL, 0x000000301c2c723cULL, 0x040fe2000000180cULL,
0x00000000000c783bULL, 0x000eae0000004200ULL, 0x000000321c30723cULL, 0x040ff00000001838ULL,
0x000000341c38723cULL, 0x010fe20000001810ULL, 0x000000007110783bULL, 0x000eee0000004200ULL,
0x0000003c0444723cULL, 0x020fe20000001814ULL, 0x000000007314783bULL, 0x000f220000004200ULL,
0x0000000918188232ULL, 0x002fc40000000000ULL, 0x000000091a1a8232ULL, 0x000fe40000000000ULL,
0x0000000a19198232ULL, 0x080fe40000000000ULL, 0x000000361c34723cULL, 0x000fe20000001824ULL,
0x00000000771c783bULL, 0x000e620000004200ULL, 0x0000000a1b1b8232ULL, 0x000fc60000000000ULL,
0x000000007d24783bULL, 0x000fe60000004200ULL, 0x0000003e043c723cULL, 0x040fe20000001820ULL,
0x000000007c20783bULL, 0x000fee0000004200ULL, 0x0000000c0448723cULL, 0x044fe20000001840ULL,
0x000000007e40783bULL, 0x000fee0000004200ULL, 0x0000000e044c723cULL, 0x040fe20000001828ULL,
0x00000000750c783bULL, 0x000ea80000004200ULL, 0x000000008128783bULL, 0x000fe60000004200ULL,
0x000000100454723cULL, 0x048fe2000000182cULL, 0x00000000512c783bULL, 0x000eee0000000200ULL,
0x000000120430723cULL, 0x040ff00000001830ULL, 0x000000140410723cULL, 0x050fe20000001838ULL,
0x000000007f38783bULL, 0x000f2e0000004200ULL, 0x000000160434723cULL, 0x000fe20000001834ULL,
0x000000008004783bULL, 0x000f6e0000004200ULL, 0x0000001c1848723cULL, 0x042ff00000001848ULL,
0x0000000c1844723cULL, 0x004fe20000001844ULL, 0x000000092c2c8232ULL, 0x008fc40000000000ULL,
0x000000092e2e8232ULL, 0x000fe40000000000ULL, 0x0000000a2d2d8232ULL, 0x080fe40000000000ULL,
0x0000000a2f2f8232ULL, 0x000fe20000000000ULL, 0x000000201854723cULL, 0x040ff00000001854ULL,
0x000000241810723cULL, 0x040ff00000001810ULL, 0x0000000e183c723cULL, 0x040ff0000000183cULL,
0x0000001e184c723cULL, 0x040ff0000000184cULL, 0x000000221830723cULL, 0x040ff00000001830ULL,
0x000000261824723cULL, 0x000ff00000001834ULL, 0x000000402c14723cULL, 0x040ff00000001844ULL,
0x000000282c18723cULL, 0x040ff00000001848ULL, 0x000000382c0c723cULL, 0x050ff00000001854ULL,
0x000000422c40723cULL, 0x040ff0000000183cULL, 0x0000002a2c28723cULL, 0x040ff0000000184cULL,
0x0000003a2c38723cULL, 0x040ff00000001830ULL, 0x000000042c10723cULL, 0x060ff00000001810ULL,
0x000000062c24723cULL, 0x000fe20000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fdc0000008000ULL,
0x02464000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000006908697221ULL, 0x000fe20000010000ULL,
0x0000000165057812ULL, 0x000fce00078ec0ffULL, 0x000003007b7b7a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff67ff7812ULL, 0x000fc4000780c0ffULL, 0x000000787b00720cULL, 0x000fe40003f26070ULL,
0x00000001ff677807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff7e1000007947ULL, 0x000fea000383ffffULL, 0x0000000000317919ULL, 0x000e620000002500ULL,
0x000000ffff097224ULL, 0x000fe400078e0010ULL, 0x000000ffff077224ULL, 0x000fe200078e000cULL,
0x00000016000c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e000eULL,
0x000000ffff0b7224ULL, 0x000fe200078e0017ULL, 0x000000783100720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x0180000069007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e0069ULL, 0x0000a03000167802ULL, 0x000fe40000000f00ULL,
0x0000b67000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000006900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000069ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000803037811ULL, 0x004fe400078ff0ffULL, 0x00000002ff057819ULL, 0x008fc80000011602ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500027589ULL, 0x000ee200000e0000ULL,
0x0000000c030c7220ULL, 0x044fe40000410000ULL, 0x0000000b030b7220ULL, 0x000fe40000410000ULL,
0x0000001402147220ULL, 0x048fe40000410000ULL, 0x0000001502157220ULL, 0x000fc40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x040fe40000410000ULL,
0x0000001802187220ULL, 0x040fe40000410000ULL, 0x0000001902197220ULL, 0x040fe40000410000ULL,
0x0000002802287220ULL, 0x040fe40000410000ULL, 0x0000002902297220ULL, 0x000fc40000410000ULL,
0x0000000702077220ULL, 0x040fe40000410000ULL, 0x0000000d020d7220ULL, 0x040fe40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000000902097220ULL, 0x040fe40000410000ULL, 0x0000001102117220ULL, 0x000fc40000410000ULL,
0x0000002402247220ULL, 0x040fe40000410000ULL, 0x0000002502257220ULL, 0x000fe40000410000ULL,
0x0000004203427220ULL, 0x040fe40000410000ULL, 0x0000004303437220ULL, 0x040fe40000410000ULL,
0x0000001a031a7220ULL, 0x040fe40000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x0000002a032a7220ULL, 0x040fe40000410000ULL, 0x0000002b032b7220ULL, 0x040fe40000410000ULL,
0x0000001003107220ULL, 0x040fe40000410000ULL, 0x0000000f030f7220ULL, 0x040fe40000410000ULL,
0x0000003a033a7220ULL, 0x040fe40000410000ULL, 0x0000003b033b7220ULL, 0x000fc40000410000ULL,
0x0000001203127220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000002603267220ULL, 0x040fe40000410000ULL, 0x0000002703277220ULL, 0x000fe40000410000ULL,
0x00000000001c7919ULL, 0x000ea20000000000ULL, 0x000000141503723eULL, 0x000fe400000000ffULL,
0x000000091109723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000121311723eULL, 0x000fc400000000ffULL, 0x000000070d07723eULL, 0x000fe400000000ffULL,
0x000000181905723eULL, 0x000fe400000000ffULL, 0x0000001a1b0d723eULL, 0x000fe400000000ffULL,
0x000000262712723eULL, 0x000fe400000000ffULL, 0x00000024250a723eULL, 0x000fe400000000ffULL,
0x000000404104723eULL, 0x000fc400000000ffULL, 0x000000282906723eULL, 0x000fe400000000ffULL,
0x0000002a2b0e723eULL, 0x000fe400000000ffULL, 0x000000383908723eULL, 0x000fe400000000ffULL,
0x00000002ff1f7819ULL, 0x004fe4000001161cULL, 0x000000081c2d7811ULL, 0x000fe400078ff0ffULL,
0x000000031f027819ULL, 0x040fe200000006ffULL, 0x000000081f147824ULL, 0x040fe200078e00ffULL,
0x000000071f007812ULL, 0x000fe200078ec0ffULL, 0x000000082d167824ULL, 0x000fe200078e00ffULL,
0x0000001fff217212ULL, 0x000fc400078e33ffULL, 0x0000002dff2f7212ULL, 0x000fe400078e33ffULL,
0xfffffff802137812ULL, 0x000fe400078ee21fULL, 0x0000000100027812ULL, 0x000fe400078e3cffULL,
0xfffffff814217812ULL, 0x000fe400078ee221ULL, 0xfffffff8162f7812ULL, 0x000fe200078ee22fULL,
0x000000081f157824ULL, 0x000fe200078e0202ULL, 0x0000000200147812ULL, 0x000fe200078e3cffULL,
0x000008007a027824ULL, 0x000fe200078e00ffULL, 0x0000000300167812ULL, 0x000fc400078e3cffULL,
0x0000000400187812ULL, 0x040fe200078e3cffULL, 0x000000081f177824ULL, 0x040fe200078e0214ULL,
0x00000005001a7812ULL, 0x040fe200078e3cffULL, 0x000000081f197824ULL, 0x040fe200078e0216ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x000000081f1b7824ULL, 0x040fe200078e0218ULL,
0x0000001a1f1d7211ULL, 0x000fe200078e18ffULL, 0x000000041c147824ULL, 0x000fe200078e00ffULL,
0x000000072d167812ULL, 0x000fe200078ec0ffULL, 0x000000081f1f7824ULL, 0x000fe200078e0200ULL,
0x0001200002007810ULL, 0x000fe20007ffe0ffULL, 0x000000082d187824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fc400078ec0ffULL, 0x0000000013137211ULL, 0x080fe200078e20ffULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0xfffffff818237812ULL, 0x000fe200078ee22dULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000000116187812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0x00000002161a7812ULL, 0x040fe200078e3cffULL,
0x000000101b1b7824ULL, 0x000fe200078e0200ULL, 0x00000003161c7812ULL, 0x040fe200078e3cffULL,
0x000000082d257824ULL, 0x040fe200078e0218ULL, 0x00000004161e7812ULL, 0x040fe200078e3cffULL,
0x000000082d277824ULL, 0x000fe200078e021aULL, 0x0000000516207812ULL, 0x000fe200078e3cffULL,
0x0000000114157824ULL, 0x000fe200078e0215ULL, 0x0000000616227812ULL, 0x000fe200078e3cffULL,
0x0000000113167824ULL, 0x000fe200078e0214ULL, 0x000000001d1d7211ULL, 0x000fe200078e20ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x0000001e2d137211ULL, 0x040fe200078e18ffULL,
0x000000082d297824ULL, 0x000fe200078e021cULL, 0x0000000316007388ULL, 0x0005e20000000800ULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000000027277211ULL, 0x000fe200078e20ffULL,
0x0000000114197824ULL, 0x040fe200078e0219ULL, 0x0000001d141d7210ULL, 0x040fe20007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0200ULL, 0x0000000415007388ULL, 0x0007e20000000800ULL,
0x0000000114187824ULL, 0x040fe200078e021bULL, 0x0000000c0b0b723eULL, 0x000fe200000000ffULL,
0x000000082d2b7824ULL, 0x000fe200078e0220ULL, 0x00000042430c723eULL, 0x000fe200000000ffULL,
0x0000000114167824ULL, 0x044fe200078e0217ULL, 0x000000002f2f7211ULL, 0x000fe200078e20ffULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x0000000516007388ULL, 0x0007e20000000800ULL,
0x000000082d2d7824ULL, 0x000fe200078e0222ULL, 0x0000030003007a0cULL, 0x000fe20003f05270ULL,
0x00000001141a7824ULL, 0x040fe200078e021fULL, 0x0000000619007388ULL, 0x0007e20000000800ULL,
0x0000000114217824ULL, 0x040fe200078e0221ULL, 0x0000003a3b10723eULL, 0x000fe200000000ffULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000000718007388ULL, 0x0007e20000000800ULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x0000002f142f7210ULL, 0x040fe20007ffe0ffULL,
0x00000001141c7824ULL, 0x040fe200078e0223ULL, 0x000000081d007388ULL, 0x0007e20000000800ULL,
0x000000102b2b7824ULL, 0x100fe200078e0200ULL, 0x0000001314207210ULL, 0x040fe20007ffe0ffULL,
0x0000000114257824ULL, 0x000fe200078e0225ULL, 0x000000091a007388ULL, 0x0007e20000000800ULL,
0x000000102d2d7824ULL, 0x000fc400078e0200ULL, 0x00000001141e7824ULL, 0x040fe200078e0227ULL,
0x0000000a21007388ULL, 0x0007e20000000800ULL, 0x0000000114297824ULL, 0x040fe400078e0229ULL,
0x00000001142b7824ULL, 0x040fe200078e022bULL, 0x0000000b1c007388ULL, 0x0007e20000000800ULL,
0x0000000114147824ULL, 0x000fc600078e022dULL, 0x0000000c25007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000e29007388ULL, 0x0007e80000000800ULL,
0x0000000f20007388ULL, 0x0007e80000000800ULL, 0x000000102b007388ULL, 0x0007e80000000800ULL,
0x0000001114007388ULL, 0x0007e80000000800ULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002d0000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00005800ff047624ULL, 0x008fe200078e00ffULL,
0x000000ff7a00720cULL, 0x000fe20003f25270ULL, 0x00002000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000127919ULL, 0x000ee80000002700ULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x0000000203097211ULL, 0x044fe400078e20ffULL, 0x00000020030d7810ULL, 0x000fc40007ffe0ffULL,
0x00000040030f7810ULL, 0x040fe20007ffe0ffULL, 0x0120000009147984ULL, 0x0005220000000c00ULL,
0x0000006003117810ULL, 0x040fe20007ffe0ffULL, 0x0000580012127a24ULL, 0x008fe400078e0205ULL,
0x0122000009187984ULL, 0x0004e20000000c00ULL, 0x0000030004057a24ULL, 0x000fe200078e02ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000030012047a24ULL, 0x000fe200078e02ffULL,
0x01240000091c7984ULL, 0x0004620000000c00ULL, 0x0000640005057a24ULL, 0x000fe200078e02ffULL,
0x000000ff7a00720cULL, 0x000fe20000705670ULL, 0x0000000104087824ULL, 0x000fe200078e0231ULL,
0x0126000009207984ULL, 0x0004640000000c00ULL, 0x00001fff05137811ULL, 0x000fc400078e40ffULL,
0x01ffffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000000813067211ULL, 0x000fca00078f98ffULL,
0x00006a0006067625ULL, 0x000fcc00078e0007ULL, 0x000008007a067825ULL, 0x000fcc00078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x0000001011107825ULL, 0x000fc800078e0006ULL, 0x00000010030a7825ULL, 0x000fe200078e0006ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x01cea20000000000ULL,
0x00000080ff247424ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x000fe200078e0205ULL,
0x0000000406257819ULL, 0x004fe400000006ffULL, 0x00000001ff267819ULL, 0x000fe20000011606ULL,
0x00006a0008067625ULL, 0x080fe200078e0024ULL, 0x0000007025257812ULL, 0x000fe400078ec0ffULL,
0x0000000c26267812ULL, 0x000fe200078ec0ffULL, 0x00006a0009087625ULL, 0x000fc600078e0024ULL,
0x0000000626067210ULL, 0x140fe40007b5e025ULL, 0x0000000826087210ULL, 0x000fe40007d9e025ULL,
0x00000007ff077210ULL, 0x000fe400017e64ffULL, 0x00000009ff097210ULL, 0x000fc600027ea4ffULL,
0x0000006b06007986ULL, 0x0005e8000c101906ULL, 0x0000006908007986ULL, 0x0005e4000c101906ULL,
0x000000140a007986ULL, 0x01c5e2000c101d06ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000180c007986ULL, 0x0005e8000c101d06ULL, 0x0000001c0e007986ULL, 0x0025e8000c101d06ULL,
0x0000002010007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x00000004ff077424ULL, 0x000fc600078e00ffULL, 0x0000030009097a10ULL, 0x000fe20007ffe1ffULL,
0x0000680012067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000009060679a8ULL, 0x000ee400099ee1c6ULL,
0x000000090600720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x000ee40000000000ULL, 0x000000ff0600720cULL, 0x008fda0003f05270ULL,
0x0000287000008947ULL, 0x000fea0003800000ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x004fe200078e00ffULL, 0x0000000104087810ULL, 0x002fe40007ffe0ffULL,
0x0000007006197812ULL, 0x000fe400078ec0ffULL, 0x0000000c070e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0004067625ULL, 0x000fc800078e0017ULL, 0x00006a0008087625ULL, 0x000fe200078e0017ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x000000080e087210ULL, 0x000fe40007b5e019ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x00000006060a7981ULL, 0x000368000c1e1900ULL, 0x00000006080b7981ULL, 0x000362000c1e1900ULL,
0x00000300000c7a02ULL, 0x000fc80000000f00ULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x000000060e067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x00000006060d7981ULL, 0x000362000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304067810ULL, 0x002fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0017ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x00000006060f7981ULL, 0x000362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x000000060e067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606117981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504067810ULL, 0x002fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0017ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606157981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x002fe40003f06070ULL,
0x0000000604067810ULL, 0x000fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0017ULL,
0x000000060e067210ULL, 0x000fe40007a3e019ULL, 0x0000000704080810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff077210ULL, 0x000fc60000fe44ffULL, 0x00006a0008080625ULL, 0x000fca00078e0017ULL,
0x000000080e080210ULL, 0x000fe40007c7e019ULL, 0x0000000606197981ULL, 0x000364000c1e1900ULL,
0x00000009ff090210ULL, 0x000fca0001fe84ffULL, 0x00000006081b0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0004ULL, 0x000000ffff097224ULL, 0x020fe400078e000aULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000000412007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000090a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000808067810ULL, 0x000fe20007ffe0ffULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x0000008000077802ULL, 0x000fe40000000f00ULL,
0x00000001ff0c7819ULL, 0x000fe40000011603ULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e009ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606097981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000910067810ULL, 0x042fe40007ffe0ffULL, 0x0000000210077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000908067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000010030b7824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e00bULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060b7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000004030c7819ULL, 0x000fe400000006ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x000000700c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e00dULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x00000006060d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000410077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e00fULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060f7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000110a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c117812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e011ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606117981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000610077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000150a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d08067810ULL, 0x000fe20007ffe0ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000008000077802ULL, 0x000fe40000000f00ULL, 0x00000001ff0e7819ULL, 0x000fe40000011603ULL,
0x000000700c157812ULL, 0x000fe200078ec0ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e015ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c177812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e017ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f10067810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000004030c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x000000700c177812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007a3e017ULL,
0x00000007ff077210ULL, 0x000fca0000fe44ffULL, 0x00000006061b7981ULL, 0x000368000c1e1900ULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003067824ULL, 0x00afe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000a07007388ULL, 0x0203e40000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001003067824ULL, 0x040fe200078e00ffULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x00002000ff0b7424ULL, 0x004fe200078e00ffULL,
0x0000000413167211ULL, 0x000fe200078f98ffULL, 0x0000000104177824ULL, 0x000fe200078e0205ULL,
0x00000001ff077819ULL, 0x002fe20000011603ULL, 0x000010007a227824ULL, 0x000fe200078e00ffULL,
0x0000007006087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000c07097812ULL, 0x000fe200078ec0ffULL, 0x00006a0016067625ULL, 0x000fe200078e000bULL,
0x00000040030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000908157210ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0e8424ULL, 0x000fe200078e00ffULL,
0x0000002003097810ULL, 0x040fe20007ffe0ffULL, 0x000008007a067825ULL, 0x000fe200078e0006ULL,
0x00000060030d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000008000118802ULL, 0x000fe20000000f00ULL, 0x00006a00170e8625ULL, 0x000fe200078e000eULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000015157984ULL, 0x000e620000000800ULL, 0x0000001009087825ULL, 0x100fe200078e0006ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000100b0a7825ULL, 0x100fe200078e0006ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000ff00147202ULL, 0x000fe20000000f00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000100d0c7825ULL, 0x000fc800078e0006ULL,
0x000000107a198824ULL, 0x000fe400078e0203ULL, 0x00006a0004108625ULL, 0x000fc600078e0011ULL,
0x0000458019198811ULL, 0x000fe200078e20ffULL, 0x0000001003137824ULL, 0x040fe400078e0222ULL,
0x0000001003067825ULL, 0x000fc800078e0006ULL, 0x000000107a1b8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006137faeULL, 0x0005e2000b901c46ULL,
0x00000010030e8825ULL, 0x000fc600078e000eULL, 0x000041801b1b8811ULL, 0x000fe200078e20ffULL,
0x0000001003108825ULL, 0x000fe200078e0010ULL, 0x0038000008137faeULL, 0x0007e6000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x005800000a137faeULL, 0x0009e2000b901c46ULL,
0x0000000000067805ULL, 0x004fc6000001ff00ULL, 0x007800000c137faeULL, 0x0005e8000b901c46ULL,
0x000000000e198faeULL, 0x000be2000b901c46ULL, 0x0000000000087805ULL, 0x008fc6000001ff00ULL,
0x00000000101b8faeULL, 0x0007e2000b901c46ULL, 0x00000000000a7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x00000d7000009947ULL, 0x000fea0003800000ULL,
0x0000000104367810ULL, 0x002fe20007ffe0ffULL, 0x00000001ff047424ULL, 0x000fe200078e00ffULL,
0x0000000117347810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000116357810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fda0003f06070ULL,
0x0000025000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00002000ff167424ULL, 0x000fe200078e00ffULL, 0x00000001041b7812ULL, 0x040fe200078ec0ffULL,
0x0000080004187824ULL, 0x000fe200078e00ffULL, 0x00000040031f7810ULL, 0x000fe20007ffe0ffULL,
0x00006a0035167625ULL, 0x000fe200078e0016ULL, 0x00000020031d7810ULL, 0x040fe40007ffe0ffULL,
0x0000080018197812ULL, 0x000fe400078ec0ffULL, 0x0000006003217810ULL, 0x000fe20007ffe0ffULL,
0x000008007a167825ULL, 0x000fc400078e0016ULL, 0x0000001b7a208211ULL, 0x000fe400078e08ffULL,
0x0000000122187824ULL, 0x000fe400078e0219ULL, 0x00000080ff398424ULL, 0x000fe400078e00ffULL,
0x000000027a388824ULL, 0x000fe200078e021bULL, 0x0000001803377211ULL, 0x000fe200078e20ffULL,
0x00000080ff3b8424ULL, 0x000fe400078e00ffULL, 0x000000101f1a7825ULL, 0x000fc800078e0016ULL,
0x000000101d187825ULL, 0x000fc800078e0016ULL, 0x00006a00341e8625ULL, 0x000fc800078e0039ULL,
0x00000010211c7825ULL, 0x000fc800078e0016ULL, 0x0000000820398824ULL, 0x000fe400078e0203ULL,
0x00006a0036208625ULL, 0x000fc600078e003bULL, 0x0000458039398811ULL, 0x000fe200078e20ffULL,
0x0000001003167825ULL, 0x000fc800078e0016ULL, 0x0000000838388824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000016377faeULL, 0x0003e2000b901c46ULL,
0x00000010031e8825ULL, 0x000fc600078e001eULL, 0x00004180383b8811ULL, 0x000fe200078e20ffULL,
0x0000001003208825ULL, 0x000fe200078e0020ULL, 0x0038000018377faeULL, 0x0003e8000b901c46ULL,
0x005800001a377faeULL, 0x0003e8000b901c46ULL, 0x007800001c377faeULL, 0x0003e8000b901c46ULL,
0x000000001e398faeULL, 0x0003e8000b901c46ULL, 0x00000000203b8faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff04167810ULL, 0x002fe20007ffe0ffULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff197819ULL, 0x000fc40000011603ULL,
0x00000002ff4b7819ULL, 0x000fe20000011603ULL, 0x0000008016177824ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c19197812ULL, 0x000fe200078ec0ffULL,
0x000000084b1e7824ULL, 0x000fe200078e00ffULL, 0x0000008017177812ULL, 0x000fe200078ec0ffULL,
0x000000084b1c7824ULL, 0x000fe200078e00ffULL, 0x0000000b16167819ULL, 0x000fe400000006ffULL,
0x000000177a177211ULL, 0x000fc400078e40ffULL, 0x000000074b397812ULL, 0x000fe400078ec0ffULL,
0x0000001719197210ULL, 0x000fe20007ffe018ULL, 0x000000084b187824ULL, 0x040fe200078e00ffULL,
0x0000004bff177212ULL, 0x000fe400078e33ffULL, 0x000000084b4d7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000191a7984ULL, 0x000e620000000800ULL,
0xfffffff81e417812ULL, 0x000fe200078ee217ULL, 0x00000004031e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c177812ULL, 0x100fe200078ee239ULL, 0x0045800019497984ULL, 0x0004e20000000800ULL,
0x00000001181b7812ULL, 0x140fe200078ef639ULL, 0x000000084d1c7824ULL, 0x040fe200078e00ffULL,
0x00000002181d7812ULL, 0x140fe200078ef639ULL, 0x000000084d3d7824ULL, 0x040fe200078e00ffULL,
0x00000003181f7812ULL, 0x140fe200078ef639ULL, 0x000000084d3b7824ULL, 0x000fe200078e00ffULL,
0x0000000418217812ULL, 0x000fc400078ef639ULL, 0x0000080016197812ULL, 0x004fe400078ec0ffULL,
0x0000000518377812ULL, 0x000fe400078ef639ULL, 0x0000018022167810ULL, 0x000fe40007ffe019ULL,
0x0000004dff477212ULL, 0x000fe400078e33ffULL, 0x0000000618397812ULL, 0x000fe200078ef639ULL,
0x0000001017177824ULL, 0x100fe200078e0216ULL, 0x0000000c1e1e7812ULL, 0x000fe200078ec0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0216ULL, 0xfffffff81c477812ULL, 0x000fe200078ee247ULL,
0x000000101d1d7824ULL, 0x100fe200078e0216ULL, 0x000000161f1f7211ULL, 0x080fe200078e20ffULL,
0x000000011e177824ULL, 0x040fe200078e0217ULL, 0x0000001639397211ULL, 0x080fe200078e20ffULL,
0x000000011e1b7824ULL, 0x040fe200078e021bULL, 0x0000001647477211ULL, 0x080fe200078e20ffULL,
0x000000011e1d7824ULL, 0x000fe200078e021dULL, 0x0000030004007a0cULL, 0x000fe20003f06070ULL,
0x0000000017177984ULL, 0x000ea20000000800ULL, 0x0000001021217824ULL, 0x000fe200078e0216ULL,
0x000000471e477210ULL, 0x040fe20007ffe0ffULL, 0x000000011e1f7824ULL, 0x040fe200078e021fULL,
0x000000001b1b7984ULL, 0x000fe20000000800ULL, 0x000000011e217824ULL, 0x000fe200078e0221ULL,
0x0000000104047810ULL, 0x000fe20007ffe0ffULL, 0x0000001a15187221ULL, 0x002fe20000010100ULL,
0x000000074d1a7812ULL, 0x000fe200078ec0ffULL, 0x000000001d1d7984ULL, 0x000fe20000000800ULL,
0x0000001037377824ULL, 0x000fe200078e0216ULL, 0x0000000134347810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b181c7820ULL, 0x000fe20000410000ULL, 0x0000001641187211ULL, 0x080fe200078e20ffULL,
0x000000001f1f7984ULL, 0x000fe20000000800ULL, 0xfffffff83d197812ULL, 0x100fe200078ee21aULL,
0x000000011e377824ULL, 0x040fe200078e0237ULL, 0x000000013b3d7812ULL, 0x040fe200078ef61aULL,
0x0000001c001c7308ULL, 0x000ee20000000800ULL, 0x000000011e187824ULL, 0x040fe200078e0218ULL,
0x0000000021217984ULL, 0x000fe20000000800ULL, 0x000000023b3f7812ULL, 0x000fe200078ef61aULL,
0x0000001019197824ULL, 0x000fe200078e0216ULL, 0x000000033b417812ULL, 0x140fe200078ef61aULL,
0x0000000037377984ULL, 0x000fe20000000800ULL, 0x000000043b437812ULL, 0x140fe200078ef61aULL,
0x000000011e197824ULL, 0x000fe200078e0219ULL, 0x000000053b457812ULL, 0x140fe200078ef61aULL,
0x0000000018187984ULL, 0x000fe20000000800ULL, 0x000000063b3b7812ULL, 0x000fe200078ef61aULL,
0x000000103f3f7824ULL, 0x100fe200078e0216ULL, 0x0000001643437211ULL, 0x000fe200078e20ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0216ULL, 0x0000000019197984ULL, 0x000fe20000000800ULL,
0x000000491c1c7220ULL, 0x008fe20000410000ULL, 0x0000003f1e3f7210ULL, 0x040fe20007ffe0ffULL,
0x000000011e397824ULL, 0x040fe200078e0239ULL, 0x0000000047477984ULL, 0x000fe20000000800ULL,
0x000000011e3d7824ULL, 0x040fe200078e023dULL, 0x0000000135357810ULL, 0x000fe20007ffe0ffULL,
0x0000001041417824ULL, 0x100fe200078e0216ULL, 0x00001f4b1c1a7589ULL, 0x000e6200000e0000ULL,
0x0000001045457824ULL, 0x100fe200078e0216ULL, 0x20000017ff497230ULL, 0x104fe20000004100ULL,
0x000000011e417824ULL, 0x040fe200078e0241ULL, 0x0000000039397984ULL, 0x000ea20000000800ULL,
0x000000103b3b7824ULL, 0x000fe200078e0216ULL, 0x30000017ff167230ULL, 0x000fe20000004100ULL,
0x000000011e437824ULL, 0x040fe200078e0243ULL, 0x000000003d3d7984ULL, 0x000ee20000000800ULL,
0x000000011e457824ULL, 0x000fe200078e0245ULL, 0x0000000136367810ULL, 0x000fe20007ffe0ffULL,
0x000000011e3b7824ULL, 0x000fe200078e023bULL, 0x000000003f3f7984ULL, 0x000fe20000000800ULL,
0x000000331c337221ULL, 0x000fc60000010000ULL, 0x0000000041417984ULL, 0x000fe80000000800ULL,
0x0000000043437984ULL, 0x000fe20000000800ULL, 0x0000001a16317223ULL, 0x082fe20000010031ULL,
0x3000001bff167230ULL, 0x000fe40000004100ULL, 0x0000000045457984ULL, 0x000fe20000000800ULL,
0x20000018ff177230ULL, 0x100fe20000004100ULL, 0x0000001a49327223ULL, 0x080fe20000010032ULL,
0x30000018ff187230ULL, 0x000fe20000004100ULL, 0x00001f4d1c1c7589ULL, 0x000e6200000e0000ULL,
0x0000001a162f7223ULL, 0x080fe2000001002fULL, 0x3000001dff167230ULL, 0x000fe20000004100ULL,
0x0000001a17247223ULL, 0x080fe20000010024ULL, 0x2000001bff177230ULL, 0x000fe20000004100ULL,
0x000000003b3b7984ULL, 0x000f220000000800ULL, 0x0000001a18237223ULL, 0x080fe20000010023ULL,
0x3000001fff187230ULL, 0x000fe20000004100ULL, 0x0000001a162d7223ULL, 0x080fe2000001002dULL,
0x30000021ff167230ULL, 0x000fe20000004100ULL, 0x0000001a17307223ULL, 0x080fe20000010030ULL,
0x2000001fff177230ULL, 0x000fe20000004100ULL, 0x0000001a182b7223ULL, 0x080fe2000001002bULL,
0x2000001dff1b7230ULL, 0x000fe20000004100ULL, 0x0000001a16297223ULL, 0x080fe20000010029ULL,
0x30000037ff167230ULL, 0x100fe20000004100ULL, 0x0000001a172c7223ULL, 0x080fe2000001002cULL,
0x20000037ff177230ULL, 0x000fe20000004100ULL, 0x0000001a1b2e7223ULL, 0x080fe2000001002eULL,
0x30000039ff187230ULL, 0x004fe20000004100ULL, 0x0000001a16277223ULL, 0x080fe20000010027ULL,
0x30000019ff167230ULL, 0x100fe20000004100ULL, 0x0000001a17287223ULL, 0x080fe20000010028ULL,
0x20000019ff177230ULL, 0x000fe20000004100ULL, 0x0000001a18257223ULL, 0x000fe20000010025ULL,
0x3000003dff187230ULL, 0x008fe20000004100ULL, 0x0000001c16137223ULL, 0x082fe20000010013ULL,
0x3000003fff167230ULL, 0x000fe20000004100ULL, 0x0000001c17147223ULL, 0x080fe20000010014ULL,
0x2000003dff177230ULL, 0x000fe20000004100ULL, 0x0000001c18117223ULL, 0x080fe20000010011ULL,
0x2000003fff197230ULL, 0x000fe20000004100ULL, 0x0000001c160f7223ULL, 0x080fe2000001000fULL,
0x30000041ff167230ULL, 0x100fe20000004100ULL, 0x0000001c17127223ULL, 0x080fe20000010012ULL,
0x20000041ff177230ULL, 0x000fe20000004100ULL, 0x0000001c19107223ULL, 0x080fe20000010010ULL,
0x20000021ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001c160d7223ULL, 0x080fe2000001000dULL,
0x20000043ff197230ULL, 0x100fe20000004100ULL, 0x0000001c170e7223ULL, 0x000fe2000001000eULL,
0x30000043ff187230ULL, 0x000fe20000004100ULL, 0x0000001a1b2a7223ULL, 0x000fe2000001002aULL,
0x20000045ff177230ULL, 0x100fe20000004100ULL, 0x0000001c190c7223ULL, 0x080fe2000001000cULL,
0x30000045ff167230ULL, 0x000fe20000004100ULL, 0x0000001c180b7223ULL, 0x080fe2000001000bULL,
0x20000039ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001c170a7223ULL, 0x080fe2000001000aULL,
0x2000003bff177230ULL, 0x110fe20000004100ULL, 0x0000001c16097223ULL, 0x000fe20000010009ULL,
0x3000003bff187230ULL, 0x000fe20000004100ULL, 0x0000001a1b267223ULL, 0x000fe20000010026ULL,
0x20000047ff197230ULL, 0x100fe20000004100ULL, 0x0000001c17087223ULL, 0x080fe20000010008ULL,
0x30000047ff167230ULL, 0x000fe20000004100ULL, 0x0000001c18077223ULL, 0x000fc40000010007ULL,
0x0000001c19067223ULL, 0x080fe40000010006ULL, 0x0000001c16057223ULL, 0x000fe20000010005ULL,
0xfffff2e000008947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cdd000167802ULL, 0x000fe40000000f00ULL,
0x000088d000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff187819ULL, 0x010fe40000011616ULL,
0x00000008161a7811ULL, 0x040fe200078ff0ffULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x00001f1803047589ULL, 0x00cea200000e0000ULL, 0x00000008181c7824ULL, 0x000fc400078e00ffULL,
0x000000081a417824ULL, 0x040fe200078e00ffULL, 0x00001f1a03157589ULL, 0x00072200000e0000ULL,
0x000000081a337824ULL, 0x002fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fc800078ec0ffULL,
0xfffffff833337812ULL, 0x000fe400078ee21aULL, 0x00000018ff037212ULL, 0x008fe400078e33ffULL,
0x0000000033337211ULL, 0x000fe400078e20ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee203ULL,
0x0000000818037824ULL, 0x000fc800078e00ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0xfffffff803037812ULL, 0x000fe200078ee218ULL, 0x0000003204327220ULL, 0x044fe40000410000ULL,
0x0000003104317220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x0000002e042e7220ULL, 0x000fc40000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000002c042c7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000002804287220ULL, 0x000fc40000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000002604267220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fe20000410000ULL, 0x0000001aff047212ULL, 0x000fe200078e33ffULL,
0x0000000615067220ULL, 0x010fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000000515057220ULL, 0x000fe20000410000ULL, 0xfffffff841417812ULL, 0x000fe200078ee204ULL,
0x0000001415147220ULL, 0x040fe20000410000ULL, 0x0000000718047812ULL, 0x000fe200078ec0ffULL,
0x0000001315137220ULL, 0x000fe20000410000ULL, 0x000000060505723eULL, 0x000fe200000000ffULL,
0x0000001215127220ULL, 0x040fe20000410000ULL, 0x000000071a067812ULL, 0x000fe200078ec0ffULL,
0x0000001115117220ULL, 0x040fe20000410000ULL, 0x0000000204177812ULL, 0x040fe200078e3cffULL,
0x0000001015107220ULL, 0x040fe20000410000ULL, 0x0000000304197812ULL, 0x000fe200078e3cffULL,
0x0000000f150f7220ULL, 0x040fe20000410000ULL, 0x0000000206377812ULL, 0x000fe200078e3cffULL,
0x0000000e150e7220ULL, 0x040fe20000410000ULL, 0x00000004041b7812ULL, 0x040fe200078e3cffULL,
0x0000000d150d7220ULL, 0x040fe20000410000ULL, 0x00000005041d7812ULL, 0x040fe200078e3cffULL,
0x0000000c150c7220ULL, 0x040fe20000410000ULL, 0x00000006041f7812ULL, 0x000fe200078e3cffULL,
0x0000000b150b7220ULL, 0x040fe20000410000ULL, 0x0000000106357812ULL, 0x040fe200078e3cffULL,
0x0000000a150a7220ULL, 0x040fe20000410000ULL, 0x0000000306397812ULL, 0x040fe200078e3cffULL,
0x0000000915097220ULL, 0x040fe20000410000ULL, 0x00000004063b7812ULL, 0x040fe200078e3cffULL,
0x0000000815087220ULL, 0x040fe20000410000ULL, 0x00000005063d7812ULL, 0x000fe200078e3cffULL,
0x0000000715077220ULL, 0x000fe20000410000ULL, 0x0000000104157812ULL, 0x000fe200078e3cffULL,
0x0000000818177824ULL, 0x000fe200078e0217ULL, 0x00000006063f7812ULL, 0x000fe200078e3cffULL,
0x0000000818197824ULL, 0x040fe200078e0219ULL, 0x0000001518157211ULL, 0x000fe200078e18ffULL,
0x000000081a377824ULL, 0x000fe200078e0237ULL, 0x0000001f181f7211ULL, 0x040fe200078e18ffULL,
0x00000008181b7824ULL, 0x000fe200078e021bULL, 0x0000003b1a3b7211ULL, 0x000fe200078e18ffULL,
0x00000008181d7824ULL, 0x000fe200078e021dULL, 0x0000000019197211ULL, 0x080fe200078e20ffULL,
0x000000081a357824ULL, 0x040fe200078e0235ULL, 0x0000000037377211ULL, 0x000fe200078e20ffULL,
0x000000081a397824ULL, 0x040fe200078e0239ULL, 0x000000080707723eULL, 0x000fe200000000ffULL,
0x000000081a3d7824ULL, 0x040fe200078e023dULL, 0x0000000a0909723eULL, 0x000fe200000000ffULL,
0x000000081a3f7824ULL, 0x000fe200078e023fULL, 0x0000001916087210ULL, 0x040fe20007ffe0ffULL,
0x0000001003037824ULL, 0x100fe200078e0200ULL, 0x0000000c0b0b723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000001041417824ULL, 0x000fe200078e0200ULL, 0x000000242323723eULL, 0x000fe200000000ffULL,
0x0000000103047824ULL, 0x000fe200078e0216ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0x0000002116107210ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x0000003104007388ULL, 0x0003e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000001035357824ULL, 0x000fc400078e0200ULL, 0x0000001039397824ULL, 0x100fe400078e0200ULL,
0x000000103b3b7824ULL, 0x100fe400078e0200ULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x0000003716047210ULL, 0x042fe20007ffe0ffULL, 0x000000103f3f7824ULL, 0x000fe400078e0200ULL,
0x0000000116007824ULL, 0x040fe400078e0215ULL, 0x0000000116067824ULL, 0x000fc400078e0217ULL,
0x00000001160a7824ULL, 0x040fe200078e021bULL, 0x0000002f00007388ULL, 0x0003e20000000800ULL,
0x00000001160c7824ULL, 0x040fe400078e021dULL, 0x00000001160e7824ULL, 0x040fe200078e021fULL,
0x0000002d06007388ULL, 0x0003e20000000800ULL, 0x0000000116127824ULL, 0x040fe400078e0233ULL,
0x0000000116147824ULL, 0x040fe200078e0235ULL, 0x0000002b08007388ULL, 0x0003e20000000800ULL,
0x0000000116187824ULL, 0x000fc400078e0239ULL, 0x00000001161a7824ULL, 0x040fe200078e023bULL,
0x000000290a007388ULL, 0x0003e20000000800ULL, 0x00000001161e7824ULL, 0x040fe400078e0241ULL,
0x00000001161c7824ULL, 0x040fe200078e023dULL, 0x000000270c007388ULL, 0x0003e20000000800ULL,
0x0000000116167824ULL, 0x000fc600078e023fULL, 0x000000250e007388ULL, 0x0003e80000000800ULL,
0x0000002310007388ULL, 0x0003e80000000800ULL, 0x0000001312007388ULL, 0x0003e80000000800ULL,
0x0000001114007388ULL, 0x0003e80000000800ULL, 0x0000000f04007388ULL, 0x0003e80000000800ULL,
0x0000000d18007388ULL, 0x0003e80000000800ULL, 0x0000000b1a007388ULL, 0x0003e80000000800ULL,
0x000000091c007388ULL, 0x0003e80000000800ULL, 0x0000000716007388ULL, 0x0003e80000000800ULL,
0x000000051e007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000b7919ULL, 0x00ee620000000000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0x00000000000a7919ULL, 0x000ee20000002600ULL, 0x0000000405057899ULL, 0x000fc6000800063fULL,
0x1ffffff87a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff047819ULL, 0x002fe2000001160bULL,
0x00000004050472a4ULL, 0x004fe2000f8e023fULL, 0x000000200b157810ULL, 0x040fe40007ffe0ffULL,
0x000000040a037819ULL, 0x048fe200000006ffULL, 0x000000100a237824ULL, 0x040fe200078e00ffULL,
0x000000400b177810ULL, 0x040fe20007ffe0ffULL, 0x000000100a257824ULL, 0x000fe200078e00ffULL,
0x000000600b217810ULL, 0x000fc40007ffe0ffULL, 0xfffffff003007812ULL, 0x000fe400078ee204ULL,
0x00000003ff037819ULL, 0x000fe40000011615ULL, 0x00000003ff067819ULL, 0x000fe40000011617ULL,
0x00000003ff087819ULL, 0x000fe40000011621ULL, 0x00000007040c7812ULL, 0x000fe400078e480bULL,
0x0000000703047812ULL, 0x000fc400078e4815ULL, 0x0000000706077812ULL, 0x000fe400078e4817ULL,
0x0000000708097812ULL, 0x000fe400078e4821ULL, 0x0ffffff80c0d7812ULL, 0x000fe400078ef80bULL,
0x0ffffff804057812ULL, 0x000fe400078ef815ULL, 0x0ffffff807077812ULL, 0x000fe200078ef817ULL,
0x000000100d0c7824ULL, 0x100fe200078e0202ULL, 0x0ffffff809097812ULL, 0x000fe200078ef821ULL,
0x0000001005057824ULL, 0x100fe200078e0202ULL, 0x000000040a047819ULL, 0x000fe200000006ffULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x0000000400007c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x012000000c0c7984ULL, 0x000e620000000c00ULL,
0xfffffff004047812ULL, 0x000fc400078ee203ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0120000005107984ULL, 0x0004e20000000c00ULL, 0x00005a0000027a11ULL, 0x040fe400078048ffULL,
0xfffffff023067812ULL, 0x000fe200078ee206ULL, 0x0120000007187984ULL, 0x0009620000000c00ULL,
0xfffffff025087812ULL, 0x000fe400078ee208ULL, 0x00005b0000037a11ULL, 0x000fe200000f4c03ULL,
0x01200000091c7984ULL, 0x0009620000000c00ULL, 0x0000000404057c10ULL, 0x004fc4000ff1e0ffULL,
0x0000000408007c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000406077c10ULL, 0x010fe4000ff3e0ffULL,
0x000000ffff147210ULL, 0x000fe200007fe4ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005a0007067a11ULL, 0x000fe400078248ffULL, 0x00005a0000087a11ULL, 0x000fc400078448ffULL,
0x000000077a0b7812ULL, 0x040fe400078ef80bULL, 0x000000077a157812ULL, 0x040fe400078ef815ULL,
0x00005b0005057a11ULL, 0x000fe200000f4c14ULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x000000077a177812ULL, 0x040fe400078ef817ULL, 0x00005b0007077a11ULL, 0x000fe200008f4c0aULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x000000077a217812ULL, 0x000fc400078ef821ULL,
0x00005b0000097a11ULL, 0x000fe200010f4c09ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x0000000c02007986ULL, 0x002fe6000c101d06ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000001004007986ULL, 0x008fe8000c101d06ULL, 0x0000001806007986ULL, 0x020fe8000c101d06ULL,
0x0000001c08007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000017b037810ULL, 0x00afe20007ffe0ffULL, 0x000000407a2e7824ULL, 0x000fc400078e00ffULL,
0x000000026d007824ULL, 0x000fe200078e00ffULL, 0x000000780300720cULL, 0x000fe40003f06070ULL,
0x0000002e7b027211ULL, 0x000fe200078e40ffULL, 0x00005800002f7a24ULL, 0x000fc800078e022fULL,
0x000062002f187a24ULL, 0x000fcc00078e0202ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x00000000001a7919ULL, 0x000e620000000000ULL, 0x0000000279007217ULL, 0x000fe20007800000ULL,
0x00000200ff1d7424ULL, 0x000fe200078e00ffULL, 0x000020007a167811ULL, 0x000fc600078e70ffULL,
0x0000000100007824ULL, 0x000fe200078e0a02ULL, 0x00000003ff1b7819ULL, 0x002fc8000001161aULL,
0x000000081b077810ULL, 0x040fe40007ffe0ffULL, 0x000000041b057810ULL, 0x000fe40007ffe0ffULL,
0x0000001a07047212ULL, 0x0c0fe200078e3cffULL, 0x0000000807217824ULL, 0x000fe200078e00ffULL,
0x0000001a05037212ULL, 0x040fe200078e3cffULL, 0x0000000805067824ULL, 0x000fe200078e00ffULL,
0x0000001b18027210ULL, 0x000fe40007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x000000101a047824ULL, 0x000fe200078e00ffULL, 0xfffffff806197812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x000fe200078e001dULL, 0x000000101b0d7810ULL, 0x000fc40007ffe0ffULL,
0x00000070041f7812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x000fe200078e0216ULL,
0x0000000c1b097810ULL, 0x000fe20007ffe0ffULL, 0x000000080d257824ULL, 0x000fe200078e00ffULL,
0x000000021f0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000118027824ULL, 0x000fe200078e0205ULL,
0x0000001a0d047212ULL, 0x000fe200078e3cffULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7210ULL, 0x000fe200007fe4ffULL, 0x00005e0002027625ULL, 0x000fe200078e001dULL,
0xfffffff825257812ULL, 0x000fc400078ee204ULL, 0x0000001a09067212ULL, 0x000fe200078e3cffULL,
0x0000000118047824ULL, 0x000fe200078e0207ULL, 0x000000000500720cULL, 0x000fe40003f86070ULL,
0x000000021f0c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0004047625ULL, 0x000fe200078e001dULL,
0xfffffff823237812ULL, 0x000fe400078ee206ULL, 0x000000000700720cULL, 0x080fe20003f46070ULL,
0x0000000118067824ULL, 0x040fe200078e0209ULL, 0x000000141b137810ULL, 0x000fe20007ffe0ffULL,
0x0000000118077824ULL, 0x000fe200078e020dULL, 0x000000000d00720cULL, 0x000fc40003f06070ULL,
0x00000003ff0d7210ULL, 0x000fe20000ffe4ffULL, 0x00005e0006027625ULL, 0x080fe200078e001dULL,
0x000000041f0e7210ULL, 0x000fe40007f3e0ffULL, 0x000000181b157810ULL, 0x000fe20007ffe0ffULL,
0x0000000118087824ULL, 0x000fe200078e0213ULL, 0x000000000900720cULL, 0x000fe20003f66070ULL,
0x00005e0007067625ULL, 0x080fe200078e001dULL, 0x0000001c1b297810ULL, 0x000fe40007ffe0ffULL,
0x0000001a13047212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0605ULL,
0x000000021f107210ULL, 0x040fe20007f3e0ffULL, 0x00005e0008087625ULL, 0x000fe200078e001dULL,
0x000000061f067210ULL, 0x000fc40007fbe0ffULL, 0x000000071b057812ULL, 0x100fe200078e481aULL,
0x0000000118027824ULL, 0x000fe200078e0215ULL, 0x000000081f087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0603ULL, 0x0ffffff805057812ULL, 0x000fe200078ef81aULL,
0x00005e0002027625ULL, 0x000fe200078e001dULL, 0x00000009ff097210ULL, 0x000fe400037fe4ffULL,
0x000000001300720cULL, 0x080fe20003f26070ULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x000000001b00720cULL, 0x000fe20003fa6070ULL, 0x0000000813277824ULL, 0x000fe200078e00ffULL,
0x000000021f127210ULL, 0x000fe20007fde0ffULL, 0x0000001005177824ULL, 0x000fe200078e0216ULL,
0x0000002918027210ULL, 0x000fe20007ffe0ffULL, 0x00000008152d7824ULL, 0x000fe200078e00ffULL,
0x000000201b2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200030e0603ULL,
0xfffffff827277812ULL, 0x000fe200078ee204ULL, 0x00005e0002027625ULL, 0x000fe200078e001dULL,
0x0000001a151c7212ULL, 0x000fc600078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a177faeULL, 0x0003e2000e901c46ULL, 0x000000021f147210ULL, 0x000fe20007fde0ffULL,
0x0000000118047824ULL, 0x000fe200078e022bULL, 0x0000001a29027212ULL, 0x040fe200078e3cffULL,
0x000000000c197faeULL, 0x0005e2000e101c46ULL, 0x000000002900720cULL, 0x0c0fe20003f86070ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000001500720cULL, 0x000fe20003fa6070ULL,
0x00005e0004047625ULL, 0x000fc600078e001dULL, 0xfffffff829297812ULL, 0x000fe200078ee202ULL,
0x000000ffff157224ULL, 0x000fe200030e0603ULL, 0x000000041f047210ULL, 0x000fe20007fde0ffULL,
0x0000001023177824ULL, 0x002fe200078e0216ULL, 0x0000001a2b0b7212ULL, 0x000fe400078e3cffULL,
0x00000016210d7211ULL, 0x004fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x000000241b217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d197812ULL, 0x000fe200078ee21cULL,
0x000000082b1c7824ULL, 0x000fe200078e00ffULL, 0x000000000e0d7faeULL, 0x0003e2000d101c46ULL,
0x0000000118027824ULL, 0x000fe200078e0221ULL, 0x000000002100720cULL, 0x000fc40003f46070ULL,
0x0000001a210c7212ULL, 0x040fe200078e3cffULL, 0x00005e0002027625ULL, 0x000fe200078e001dULL,
0x0000000321237819ULL, 0x000fe200000006ffULL, 0x0000000010177faeULL, 0x0005e2000d901c46ULL,
0xfffffff81c217812ULL, 0x000fe400078ee20bULL, 0x000000021f0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010250d7824ULL, 0x102fe200078e0216ULL, 0x000000002b00720cULL, 0x000fe20003f66070ULL,
0x00000010190f7824ULL, 0x100fe200078e0216ULL, 0x000000281b197810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0603ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x0000001027037824ULL, 0x100fe200078e0216ULL, 0x0000001a19027212ULL, 0x000fe200078e3cffULL,
0x0000001021177824ULL, 0x004fe200078e0216ULL, 0xfffffff823237812ULL, 0x000fc400078ee20cULL,
0x0000000008037faeULL, 0x0005e2000c901c46ULL, 0x0000001629117211ULL, 0x000fe400078e20ffULL,
0x0000002c1b217810ULL, 0x040fe20007ffe0ffULL, 0x00000000120f7faeULL, 0x0007e2000e901c46ULL,
0x000000301b257810ULL, 0x040fe40007ffe0ffULL, 0x000000341b0d7810ULL, 0x042fe20007ffe0ffULL,
0x0000000014117faeULL, 0x0003e2000e101c46ULL, 0x000000381b277810ULL, 0x000fe20007ffe0ffULL,
0x00000008210c7824ULL, 0x000fe200078e00ffULL, 0x0000003c1b1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001023097824ULL, 0x004fe200078e0216ULL, 0x0000000004177faeULL, 0x0005e2000d901c46ULL,
0x0000001a21077212ULL, 0x000fe200078e3cffULL, 0x00000008190f7824ULL, 0x008fc400078e00ffULL,
0x000000000a097faeULL, 0x0007e2000d101c46ULL, 0x0000000825137824ULL, 0x040fe200078e00ffULL,
0x0000001a25087212ULL, 0x000fe400078e3cffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL,
0x0000000118027824ULL, 0x040fe200078e0219ULL, 0x000000001900720cULL, 0x080fe20003fc6070ULL,
0x000000081b197824ULL, 0x000fe200078e00ffULL, 0x0000002118047210ULL, 0x004fe20007ffe0ffULL,
0x00005e0002027625ULL, 0x000fe200078e001dULL, 0x000000002100720cULL, 0x000fc40003fa6070ULL,
0x000000002500720cULL, 0x000fe20003f86070ULL, 0x00005e0004047625ULL, 0x080fe200078e001dULL,
0x000000021f067210ULL, 0x000fe40007f5e0ffULL, 0x000000000d00720cULL, 0x080fe20003f66070ULL,
0x0000000827177824ULL, 0x040fe200078e00ffULL, 0x000000002700720cULL, 0x080fe40003f26070ULL,
0x000000001b00720cULL, 0x000fe20003f06070ULL, 0x0000000118007824ULL, 0x000fe200078e0225ULL,
0xfffffff80c117812ULL, 0x002fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200010e0603ULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x00005e0000027625ULL, 0x000fe200078e001dULL,
0x000000041f087210ULL, 0x000fc40007f5e0ffULL, 0x0000001a0d007212ULL, 0x040fe200078e3cffULL,
0x0000000118047824ULL, 0x000fe200078e020dULL, 0x000000030d157819ULL, 0x000fe200000006ffULL,
0x000000ffff097224ULL, 0x008fe200010e0605ULL, 0x000000021f0a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001dULL, 0xfffffff815157812ULL, 0x000fe400078ee200ULL,
0x0000001b18007210ULL, 0x040fe20007ffe0ffULL, 0x0000000118027824ULL, 0x000fe200078e0227ULL,
0x0000001a270e7212ULL, 0x000fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0603ULL,
0x000000041f0c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0002027625ULL, 0x000fe200078e001dULL,
0x0000001a1b1a7212ULL, 0x000fc400078e3cffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000ffff0d7224ULL, 0x000fe200010e0605ULL, 0x000000021f027210ULL, 0x000fe20007f5e0ffULL,
0x00005e0000047625ULL, 0x000fe200078e001dULL, 0x000000160f0f7211ULL, 0x000fe400078e20ffULL,
0xfffffff819197812ULL, 0x000fe200078ee21aULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x000000041f047210ULL, 0x000fe20007f5e0ffULL, 0x0000001011117824ULL, 0x100fe200078e0216ULL,
0x0000001619197211ULL, 0x000fe200078e20ffULL, 0x0000001013137824ULL, 0x100fe200078e0216ULL,
0x00000000060f7faeULL, 0x0003e2000f101c46ULL, 0x0000001015157824ULL, 0x000fc400078e0216ULL,
0x0000001017177824ULL, 0x000fe200078e0216ULL, 0x0000000008117faeULL, 0x0003e2000e901c46ULL,
0x000000ffff057224ULL, 0x000fc600010e0605ULL, 0x000000000a137faeULL, 0x0003e8000e101c46ULL,
0x000000000c157faeULL, 0x0003e8000d901c46ULL, 0x0000000002177faeULL, 0x0003e8000c901c46ULL,
0x0000000004197faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00000200ff217424ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x002fc80000011600ULL, 0x0000000403077810ULL, 0x040fe40007ffe0ffULL,
0x0000000803097810ULL, 0x000fe40007ffe0ffULL, 0x0000000007027212ULL, 0x0c0fe200078e3cffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0x0000001003137810ULL, 0x000fe20007ffe0ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000001403177810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee202ULL, 0x00000001180a7824ULL, 0x040fe200078e0213ULL,
0x0000000c030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0x0000000009027212ULL, 0x080fe200078e3cffULL, 0x00000001180c7824ULL, 0x000fe200078e0217ULL,
0x0000000013057212ULL, 0x000fe200078e3cffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0x0000000313067819ULL, 0x000fc400000006ffULL, 0x0000001c031f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee202ULL, 0xfffffff806157812ULL, 0x000fe200078ee205ULL,
0x000000081f067824ULL, 0x000fe200078e00ffULL, 0x0000002003257810ULL, 0x040fe20007ffe0ffULL,
0x0000000118107824ULL, 0x040fe200078e021fULL, 0x00000018031b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000017027212ULL, 0x080fe200078e3cffULL, 0x0000000825377824ULL, 0x000fe200078e00ffULL,
0x000000000f047212ULL, 0x080fe200078e3cffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0x000000001f057212ULL, 0x000fe200078e3cffULL, 0x00000001180e7824ULL, 0x000fe200078e021bULL,
0x0000002803297810ULL, 0x000fc40007ffe0ffULL, 0xfffffff819197812ULL, 0x000fe400078ee202ULL,
0x0000002c032b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000118167824ULL, 0x000fe200078e0229ULL,
0xfffffff811117812ULL, 0x000fe400078ee204ULL, 0xfffffff806357812ULL, 0x000fe200078ee205ULL,
0x0000000829067824ULL, 0x000fe200078e00ffULL, 0x0000000025027212ULL, 0x080fe200078e3cffULL,
0x000000082b3d7824ULL, 0x000fe200078e00ffULL, 0x000000001b047212ULL, 0x080fe200078e3cffULL,
0x00000001181a7824ULL, 0x000fe200078e022bULL, 0x0000002403277810ULL, 0x000fe20007ffe0ffULL,
0x00005e0016167625ULL, 0x000fe200078e0021ULL, 0x0000000029057212ULL, 0x000fc400078e3cffULL,
0x0000003403317810ULL, 0x000fe20007ffe0ffULL, 0x0000000118147824ULL, 0x040fe200078e0227ULL,
0xfffffff837377812ULL, 0x000fe400078ee202ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee204ULL,
0x00000030032d7810ULL, 0x000fe40007ffe0ffULL, 0x000000002b027212ULL, 0x080fe400078e3cffULL,
0x0000000027047212ULL, 0x080fe200078e3cffULL, 0x000000082d3f7824ULL, 0x000fe200078e00ffULL,
0x0000000327397819ULL, 0x000fe200000006ffULL, 0x00000001181c7824ULL, 0x000fe200078e022dULL,
0xfffffff8063b7812ULL, 0x000fe200078ee205ULL, 0x0000000831067824ULL, 0x040fe200078e00ffULL,
0x0000000031057212ULL, 0x000fc400078e3cffULL, 0xfffffff83d3d7812ULL, 0x000fe400078ee202ULL,
0xfffffff839397812ULL, 0x000fe400078ee204ULL, 0x0000000400027819ULL, 0x000fe400000006ffULL,
0x000000002d047212ULL, 0x000fe400078e3cffULL, 0xfffffff806417812ULL, 0x000fe200078ee205ULL,
0x0000000118067824ULL, 0x000fe200078e0209ULL, 0x0000000703057812ULL, 0x000fc400078e4800ULL,
0x0000003803337810ULL, 0x040fe40007ffe0ffULL, 0x0000003c03437810ULL, 0x000fe40007ffe0ffULL,
0x0000007002237812ULL, 0x000fe200078ec0ffULL, 0x0000000118027824ULL, 0x040fe200078e0203ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL, 0x0000000118047824ULL, 0x000fe200078e0207ULL,
0x0ffffff805057812ULL, 0x000fe200078ef800ULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x0000000033077212ULL, 0x000fc400078e3cffULL, 0x0000000043097212ULL, 0x040fe200078e3cffULL,
0x0000000118207824ULL, 0x000fe200078e0233ULL, 0x000020007a007811ULL, 0x000fe200078e70ffULL,
0x0000000118227824ULL, 0x040fe200078e0243ULL, 0x0000002518127210ULL, 0x040fe20007ffe0ffULL,
0x0000000843247824ULL, 0x000fe200078e00ffULL, 0x0000000f18087210ULL, 0x040fe20007ffe0ffULL,
0x0000001005257824ULL, 0x000fe200078e0200ULL, 0x00000031181e7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x0000000223027210ULL, 0x000fc40007f1e0ffULL,
0xfffffff824137812ULL, 0x000fe200078ee209ULL, 0x0000000833187824ULL, 0x000fe200078e00ffULL,
0x00000003ff037210ULL, 0x000fe200007fe4ffULL, 0x000000100b277824ULL, 0x000fe200078e0200ULL,
0x0000000423047210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0021ULL,
0xfffffff8180f7812ULL, 0x000fe200078ee207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e2000b901c46ULL, 0x00000000152d7211ULL, 0x080fe200078e20ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x000000000f437211ULL, 0x000fc400078e20ffULL,
0x0000000039397211ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000a230a7210ULL, 0x040fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0021ULL,
0x0000000623067210ULL, 0x000fe40007f3e0ffULL, 0x0000000bff0b7210ULL, 0x000fe200007fe4ffULL,
0x000000100d297824ULL, 0x100fe200078e0200ULL, 0x0000000e230e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x0000000004277faeULL, 0x0003e6000b901c46ULL,
0x0000001013457824ULL, 0x000fc400078e0200ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c230c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0012127625ULL, 0x000fc600078e0021ULL,
0x0000000006297faeULL, 0x0003e2000b901c46ULL, 0x00000010112b7824ULL, 0x000fe400078e0200ULL,
0x00005e0010107625ULL, 0x000fc800078e0021ULL, 0x00005e0008087625ULL, 0x000fc800078e0021ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001223127210ULL, 0x000fe20007f1e0ffULL,
0x0000001019317824ULL, 0x000fe200078e0200ULL, 0x0000000823087210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000001023107210ULL, 0x000fe20007f3e0ffULL,
0x00005e001a187625ULL, 0x000fc800078e0021ULL, 0x00005e0014147625ULL, 0x000fc800078e0021ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001823187210ULL, 0x000fe20007f1e0ffULL,
0x000000101d337824ULL, 0x000fe400078e0200ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001423147210ULL, 0x000fe20007f3e0ffULL, 0x00005e001c1a7625ULL, 0x000fc600078e0021ULL,
0x00000015ff157210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000001623167210ULL, 0x000fe20007f5e0ffULL, 0x00005e001e1c7625ULL, 0x000fc600078e0021ULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x00005e00201e7625ULL, 0x080fe200078e0021ULL,
0x0000001c231c7210ULL, 0x000fe40007f3e0ffULL, 0x000000000a2d7faeULL, 0x0003e2000b901c46ULL,
0x00005e0022207625ULL, 0x000fc600078e0021ULL, 0x000000000c317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x0000001a231a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001035357824ULL, 0x100fe200078e0200ULL, 0x0000002023207210ULL, 0x000fe20007f7e0ffULL,
0x0000001037377824ULL, 0x100fe200078e0200ULL, 0x000000000e337faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001e231e7210ULL, 0x000fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0200ULL, 0x0000000010357faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x100fe200078e0200ULL, 0x0000001fff1f7210ULL, 0x000fe200017fe4ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0200ULL, 0x0000000012377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc400000e061bULL, 0x0000001041417824ULL, 0x000fe200078e0200ULL,
0x0000000014397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe400008e061dULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x00000000163b7faeULL, 0x0003e8000b901c46ULL,
0x00000000183d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e8000b901c46ULL, 0x000000001e437faeULL, 0x0003e8000b901c46ULL,
0x0000000020457faeULL, 0x0003e4000b901c46ULL, 0x02460400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x02460400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000787b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000107a2d7824ULL, 0x002fe200078e00ffULL,
0xffffffff78027810ULL, 0x000fe40007ffe0ffULL, 0x00007610ff037816ULL, 0x000fe40000000003ULL,
0x000001007b047824ULL, 0x008fe200078e022eULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000047900720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000017b057810ULL, 0x000fe20007ffe0ffULL, 0x0000144000007945ULL, 0x000fe20003800000ULL,
0x000062002f0c7a24ULL, 0x000fe400078e0204ULL, 0x000000780500720cULL, 0x000fda0003f06070ULL,
0x00000a9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x004fe40000011600ULL,
0x00000007009d7812ULL, 0x000fe400078ec0ffULL, 0x0000000405077810ULL, 0x040fe20007ffe0ffULL,
0x0000000105d37824ULL, 0x140fe200078e020cULL, 0x00000014050f7810ULL, 0x000fe40007ffe0ffULL,
0x00000000079b7212ULL, 0x040fe200078e3cffULL, 0x0000000107cf7824ULL, 0x140fe200078e020cULL,
0x0000000307067819ULL, 0x000fe200000006ffULL, 0x000000080f087824ULL, 0x000fe200078e00ffULL,
0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010fc77824ULL, 0x000fe200078e020cULL,
0xfffffff8069b7812ULL, 0x000fc400078ee29bULL, 0x000000000f977212ULL, 0x080fe200078e3cffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x000000000b997212ULL, 0x080fe400078e3cffULL,
0xfffffff808977812ULL, 0x000fe400078ee297ULL, 0x00000000050e7212ULL, 0x000fe400078e3cffULL,
0x8000000479087210ULL, 0x000fe40007ffe0ffULL, 0xfffffff806997812ULL, 0x000fe200078ee299ULL,
0x00000200ff067424ULL, 0x000fe200078e00ffULL, 0x000000070e197812ULL, 0x000fc400078ec0ffULL,
0x000000080500720cULL, 0x000fe20003f26070ULL, 0x00005e00d3d27625ULL, 0x080fe200078e0006ULL,
0x000040007a0a7811ULL, 0x000fe400078e70ffULL, 0x000000089d317812ULL, 0x000fe200078efcffULL,
0x00005e00cfce7625ULL, 0x000fe200078e0006ULL, 0x0ffffff8199c7812ULL, 0x000fe400078ef800ULL,
0x0000000805097810ULL, 0x000fe20007ffe0ffULL, 0x0000001031187825ULL, 0x000fe200078e00d2ULL,
0x00000010050d7810ULL, 0x000fc40007ffe0ffULL, 0x00000000099a7212ULL, 0x040fe200078e3cffULL,
0x000000109c1b7824ULL, 0x000fe200078e020aULL, 0x000000080900720cULL, 0x040fe20003f46070ULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0x000000000d987212ULL, 0x000fe200078e3cffULL,
0x0000000109cd7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e2000c901c46ULL, 0x000000080700720cULL, 0x000fe20003f26070ULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0xfffffff8119a7812ULL, 0x000fe200078ee29aULL,
0x00005e00cdcc7625ULL, 0x000fe200078e0006ULL, 0x0000001805117810ULL, 0x000fc40007ffe0ffULL,
0x0000000c0bcb7210ULL, 0x000fe20007ffe0ffULL, 0x000000010dc97824ULL, 0x000fe200078e020cULL,
0x0000002005157810ULL, 0x000fe20007ffe0ffULL, 0x00000008111d7824ULL, 0x000fe200078e00ffULL,
0x000000080b00720cULL, 0x000fe20003f66070ULL, 0x00005e00cbca7625ULL, 0x000fe200078e0006ULL,
0xfffffff813987812ULL, 0x000fe400078ee298ULL, 0x000000080d00720cULL, 0x080fe20003f86070ULL,
0x000000109b237824ULL, 0x000fe200078e020aULL, 0x0000001c05137810ULL, 0x000fe20007ffe0ffULL,
0x0000001031187825ULL, 0x002fe200078e00ceULL, 0x000000080f00720cULL, 0x000fc40003fa6070ULL,
0x0000000011967212ULL, 0x000fe200078e3cffULL, 0x00005e00c9c87625ULL, 0x000fe200078e0006ULL,
0x0000000015947212ULL, 0x0c0fe200078e3cffULL, 0x0000000018237faeULL, 0x0003e2000c901c46ULL,
0x00000003151f7819ULL, 0x000fe200000006ffULL, 0x000000109a257824ULL, 0x000fe200078e020aULL,
0xfffffff81d967812ULL, 0x000fe200078ee296ULL, 0x00000010311a7825ULL, 0x000fe200078e00ccULL,
0x0000000013957212ULL, 0x000fe400078e3cffULL, 0xfffffff81f947812ULL, 0x000fe200078ee294ULL,
0x00005e00c7c67625ULL, 0x000fe200078e0006ULL, 0x0000000a99277211ULL, 0x000fe200078e20ffULL,
0x000000001a257faeULL, 0x0005e2000d101c46ULL, 0x000000081100720cULL, 0x0c0fe20003f26070ULL,
0x0000000111c57824ULL, 0x100fe200078e020cULL, 0x000000081300720cULL, 0x040fe20003f46070ULL,
0x00000008130e7824ULL, 0x000fe200078e00ffULL, 0x0000002405177810ULL, 0x000fe20007ffe0ffULL,
0x0000000113c37824ULL, 0x000fe200078e020cULL, 0x0000000c15c17210ULL, 0x000fe20007ffe0ffULL,
0x00000010311c7825ULL, 0x000fe200078e00caULL, 0xfffffff80e957812ULL, 0x000fc400078ee295ULL,
0x0000000017937212ULL, 0x000fe200078e3cffULL, 0x0000001098297824ULL, 0x000fe200078e020aULL,
0x000000001c277faeULL, 0x0007e2000d901c46ULL, 0x00000010311e7825ULL, 0x000fe200078e00c8ULL,
0x000000081500720cULL, 0x080fe40003f66070ULL, 0x0000002805197810ULL, 0x002fe20007ffe0ffULL,
0x00000010972b7824ULL, 0x000fe200078e020aULL, 0x000000001e297faeULL, 0x0003e2000e101c46ULL,
0x0000001031207825ULL, 0x000fe200078e00c6ULL, 0x000000081700720cULL, 0x000fc40003f86070ULL,
0x0000002c051b7810ULL, 0x004fe20007ffe0ffULL, 0x00005e00c5c47625ULL, 0x000fe200078e0006ULL,
0x00000000202b7faeULL, 0x0005e2000e901c46ULL, 0x0000000019927212ULL, 0x000fe400078e3cffULL,
0x00005e00c3c27625ULL, 0x000fe200078e0006ULL, 0x00000030051d7810ULL, 0x048fe40007ffe0ffULL,
0x00000034051f7810ULL, 0x002fe20007ffe0ffULL, 0x0000000117bf7824ULL, 0x000fe200078e020cULL,
0x000000001b917212ULL, 0x000fe200078e3cffULL, 0x0000000817107824ULL, 0x000fe200078e00ffULL,
0x0000000c1db77210ULL, 0x000fe20007ffe0ffULL, 0x0000001031227825ULL, 0x000fe200078e00c4ULL,
0x0000003805217810ULL, 0x004fc40007ffe0ffULL, 0xfffffff810937812ULL, 0x000fe200078ee293ULL,
0x00000010962b7824ULL, 0x100fe200078e020aULL, 0x000000082100720cULL, 0x000fe20003fa6070ULL,
0x0000001095337824ULL, 0x000fe200078e020aULL, 0x0000000a93377211ULL, 0x000fe200078e20ffULL,
0x0000001031247825ULL, 0x000fe200078e00c2ULL, 0x00000000222b7faeULL, 0x0003e2000c901c46ULL,
0x000000081900720cULL, 0x000fe40003f26070ULL, 0x00005e00c1c07625ULL, 0x000fe200078e0006ULL,
0x0000000024337faeULL, 0x0005e2000d101c46ULL, 0x000000081b00720cULL, 0x000fc40003f46070ULL,
0x00005e00bfbe7625ULL, 0x000fe200078e0006ULL, 0x000000001d907212ULL, 0x080fe400078e3cffULL,
0x000000001f8f7212ULL, 0x080fe200078e3cffULL, 0x0000000119bb7824ULL, 0x000fe200078e020cULL,
0x0000003c05237810ULL, 0x002fe20007ffe0ffULL, 0x0000001094357824ULL, 0x000fe200078e020aULL,
0x00000000218e7212ULL, 0x000fe200078e3cffULL, 0x0000001031267825ULL, 0x000fe200078e00c0ULL,
0x000000082300720cULL, 0x040fe40003fc6070ULL, 0x00000000238d7212ULL, 0x000fe200078e3cffULL,
0x0000000819257824ULL, 0x004fe200078e00ffULL, 0x0000000026357faeULL, 0x0003e2000d901c46ULL,
0x0000001031287825ULL, 0x000fe200078e00beULL, 0x000000081d00720cULL, 0x000fc40003f66070ULL,
0xfffffff825927812ULL, 0x000fe200078ee292ULL, 0x000000081b0e7824ULL, 0x000fe200078e00ffULL,
0x0000000028377faeULL, 0x0005e2000e101c46ULL, 0x00005e00bbba7625ULL, 0x000fe200078e0006ULL,
0x000000081f00720cULL, 0x000fe40003f86070ULL, 0xfffffff80e917812ULL, 0x000fe200078ee291ULL,
0x000000011bb97824ULL, 0x100fe200078e020cULL, 0x000000031f087819ULL, 0x040fe200000006ffULL,
0x000000011fb57824ULL, 0x100fe400078e020cULL, 0x00000008212b7824ULL, 0x040fe200078e00ffULL,
0xfffffff8088f7812ULL, 0x000fe200078ee28fULL, 0x0000000121af7824ULL, 0x000fc400078e020cULL,
0x000000081d297824ULL, 0x004fe200078e00ffULL, 0xfffffff82b8e7812ULL, 0x000fe200078ee28eULL,
0x00000008230e7824ULL, 0x000fe400078e00ffULL, 0x0000001092277824ULL, 0x002fe200078e020aULL,
0xfffffff829907812ULL, 0x000fe200078ee290ULL, 0x0000001031247825ULL, 0x000fe200078e00baULL,
0xfffffff80e8d7812ULL, 0x000fe400078ee28dULL, 0x0000000a90357211ULL, 0x000fe200078e20ffULL,
0x0000000123ab7824ULL, 0x000fe200078e020cULL, 0x0000000024277faeULL, 0x0003e2000c901c46ULL,
0x00005e00b9b87625ULL, 0x000fc800078e0006ULL, 0x00005e00b7b67625ULL, 0x000fc800078e0006ULL,
0x00005e00b5b47625ULL, 0x000fc800078e0006ULL, 0x00005e00afae7625ULL, 0x000fc800078e0006ULL,
0x00005e00abaa7625ULL, 0x000fc800078e0006ULL, 0x0000001091337824ULL, 0x000fe400078e020aULL,
0x0000001031247825ULL, 0x002fc800078e00b8ULL, 0x0000001031267825ULL, 0x000fe200078e00b6ULL,
0x0000000024337faeULL, 0x0003e6000d101c46ULL, 0x000000108f377824ULL, 0x000fe200078e020aULL,
0x0000000026357faeULL, 0x0003e2000d901c46ULL, 0x0000001031287825ULL, 0x000fc800078e00b4ULL,
0x000000108e397824ULL, 0x000fe200078e020aULL, 0x0000000028377faeULL, 0x0003e2000e101c46ULL,
0x00000010312a7825ULL, 0x000fc800078e00aeULL, 0x000000108d3b7824ULL, 0x000fe200078e020aULL,
0x000000002a397faeULL, 0x0003e2000e901c46ULL, 0x0000001031307825ULL, 0x000fca00078e00aaULL,
0x00000000303b7faeULL, 0x0003e2000f101c46ULL, 0x0000097000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x004fe40000011600ULL, 0x00000007009d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105d37824ULL, 0x140fe200078e020cULL,
0x0000000405077810ULL, 0x040fe40007ffe0ffULL, 0x0000000805097810ULL, 0x000fe20007ffe0ffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x0000001805117810ULL, 0x000fe20007ffe0ffULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0x00000000099a7212ULL, 0x080fe200078e3cffULL,
0x0000000107cf7824ULL, 0x100fe200078e020cULL, 0x00000003090d7819ULL, 0x000fe200000006ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x000000000b997212ULL, 0x080fe200078e3cffULL,
0x0000000109cd7824ULL, 0x100fe200078e020cULL, 0x00000000079b7212ULL, 0x000fe200078e3cffULL,
0x000000010bcb7824ULL, 0x100fe200078e020cULL, 0x00000014050f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111c57824ULL, 0x000fe200078e020cULL, 0x0000001c05137810ULL, 0x000fc40007ffe0ffULL,
0x0000000011967212ULL, 0x080fe200078e3cffULL, 0x000000010fc77824ULL, 0x000fe200078e020cULL,
0xfffffff80d9a7812ULL, 0x000fe200078ee29aULL, 0x0000000113c37824ULL, 0x000fe200078e020cULL,
0xfffffff808997812ULL, 0x000fe400078ee299ULL, 0x00000010050d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8069b7812ULL, 0x000fe200078ee29bULL, 0x000000080f067824ULL, 0x000fe200078e00ffULL,
0x0000000013957212ULL, 0x000fe200078e3cffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0x0000000313087819ULL, 0x000fc400000006ffULL, 0x0000002c051b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff817967812ULL, 0x000fe400078ee296ULL, 0x000000000f977212ULL, 0x080fe200078e3cffULL,
0x000000011bb97824ULL, 0x000fe200078e020cULL, 0x0000002405177810ULL, 0x000fe40007ffe0ffULL,
0xfffffff808957812ULL, 0x000fe200078ee295ULL, 0x000000081b087824ULL, 0x000fe200078e00ffULL,
0x000000000d987212ULL, 0x000fc400078e3cffULL, 0xfffffff806977812ULL, 0x000fe200078ee297ULL,
0x0000000817067824ULL, 0x000fe200078e00ffULL, 0x000000001b917212ULL, 0x080fe400078e3cffULL,
0x0000000017937212ULL, 0x000fe400078e3cffULL, 0xfffffff815987812ULL, 0x000fe400078ee298ULL,
0x0000002005157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff808917812ULL, 0x000fc400078ee291ULL,
0x0000000005087212ULL, 0x080fe200078e3cffULL, 0x00000008151d7824ULL, 0x040fe200078e00ffULL,
0xfffffff806937812ULL, 0x000fe200078ee293ULL, 0x0000000115c17824ULL, 0x040fe200078e020cULL,
0x0000020000067802ULL, 0x000fe40000000f00ULL, 0x0000000708257812ULL, 0x000fe400078ec0ffULL,
0x0000000015947212ULL, 0x000fe200078e3cffULL, 0x00005e00d3d27625ULL, 0x000fe200078e0006ULL,
0x0000002805197810ULL, 0x000fc40007ffe0ffULL, 0x000040007a0a7811ULL, 0x000fe200078e70ffULL,
0x00005e00cfce7625ULL, 0x000fe200078e0006ULL, 0x000000089d337812ULL, 0x000fe400078efcffULL,
0x0ffffff8259c7812ULL, 0x000fe200078ef800ULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d947812ULL, 0x000fe200078ee294ULL, 0x0000001033247825ULL, 0x000fe200078e00d2ULL,
0x00000030051d7810ULL, 0x040fe40007ffe0ffULL, 0x0000003805217810ULL, 0x000fe20007ffe0ffULL,
0x000000109c277824ULL, 0x000fe200078e020aULL, 0x0000000c0dc97210ULL, 0x000fe20007ffe0ffULL,
0x00005e00cdcc7625ULL, 0x000fe200078e0006ULL, 0x0000000019927212ULL, 0x000fc400078e3cffULL,
0x000000001d907212ULL, 0x040fe200078e3cffULL, 0x000000081d297824ULL, 0x000fe200078e00ffULL,
0xfffffff81f927812ULL, 0x000fe200078ee292ULL, 0x00005e00cbca7625ULL, 0x000fe200078e0006ULL,
0x00000000218e7212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000b901c46ULL, 0x0000000c17bf7210ULL, 0x000fe20007ffe0ffULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0x00000034051f7810ULL, 0x000fe20007ffe0ffULL,
0x00005e00c9c87625ULL, 0x000fe200078e0006ULL, 0x0000003c05237810ULL, 0x000fc40007ffe0ffULL,
0xfffffff829907812ULL, 0x000fe200078ee290ULL, 0x00005e00c7c67625ULL, 0x000fe200078e0006ULL,
0xfffffff82b8e7812ULL, 0x000fe400078ee28eULL, 0x0000000a983b7211ULL, 0x000fe200078e20ffULL,
0x000000109b357824ULL, 0x000fe200078e020aULL, 0x0000000c21af7210ULL, 0x000fe20007ffe0ffULL,
0x0000001033247825ULL, 0x002fe200078e00ceULL, 0x000000001f8f7212ULL, 0x080fe400078e3cffULL,
0x00000000238d7212ULL, 0x000fe200078e3cffULL, 0x0000000119bb7824ULL, 0x000fe200078e020cULL,
0x0000000024357faeULL, 0x0003e2000b901c46ULL, 0x00005e00c5c47625ULL, 0x000fe200078e0006ULL,
0x00000003230e7819ULL, 0x000fc600000006ffULL, 0x000000109a377824ULL, 0x000fe200078e020aULL,
0xfffffff80e8d7812ULL, 0x000fe200078ee28dULL, 0x0000001033267825ULL, 0x000fc800078e00ccULL,
0x00005e00c3c27625ULL, 0x000fe200078e0006ULL, 0x0000000026377faeULL, 0x0005e6000b901c46ULL,
0x0000001099397824ULL, 0x000fe400078e020aULL, 0x0000001033287825ULL, 0x000fc800078e00caULL,
0x00005e00c1c07625ULL, 0x000fe200078e0006ULL, 0x0000000028397faeULL, 0x0007e6000b901c46ULL,
0x00000010332a7825ULL, 0x000fc800078e00c8ULL, 0x00005e00bfbe7625ULL, 0x000fe200078e0006ULL,
0x000000002a3b7faeULL, 0x0009e6000b901c46ULL, 0x000000011db77824ULL, 0x000fe400078e020cULL,
0x000000081f087824ULL, 0x000fe400078e00ffULL, 0x00000010973d7824ULL, 0x000fe400078e020aULL,
0x0000001033307825ULL, 0x000fe200078e00c6ULL, 0xfffffff8088f7812ULL, 0x000fc400078ee28fULL,
0x0000000a933b7211ULL, 0x010fe200078e20ffULL, 0x00005e00bbba7625ULL, 0x000fe200078e0006ULL,
0x00000000303d7faeULL, 0x0009e6000b901c46ULL, 0x000000011fb57824ULL, 0x000fe400078e020cULL,
0x0000001096357824ULL, 0x002fe400078e020aULL, 0x0000001033247825ULL, 0x000fc800078e00c4ULL,
0x0000000123ab7824ULL, 0x000fe200078e020cULL, 0x0000000024357faeULL, 0x0003e2000b901c46ULL,
0x00005e00b9b87625ULL, 0x000fc800078e0006ULL, 0x0000001095377824ULL, 0x004fe400078e020aULL,
0x0000001033267825ULL, 0x000fc800078e00c2ULL, 0x00005e00b7b67625ULL, 0x000fe200078e0006ULL,
0x0000000026377faeULL, 0x0005e6000b901c46ULL, 0x0000001094397824ULL, 0x008fe400078e020aULL,
0x0000001033287825ULL, 0x000fc800078e00c0ULL, 0x00005e00b5b47625ULL, 0x000fe200078e0006ULL,
0x0000000028397faeULL, 0x0007e6000b901c46ULL, 0x00000010332a7825ULL, 0x000fc800078e00beULL,
0x00005e00afae7625ULL, 0x000fe200078e0006ULL, 0x000000002a3b7faeULL, 0x000be6000b901c46ULL,
0x00000010923d7824ULL, 0x010fe400078e020aULL, 0x0000001033307825ULL, 0x000fc800078e00baULL,
0x00005e00abaa7625ULL, 0x000fe200078e0006ULL, 0x00000000303d7faeULL, 0x0009e2000b901c46ULL,
0x0000000a8e3b7211ULL, 0x020fe400078e20ffULL, 0x0000001091357824ULL, 0x002fe400078e020aULL,
0x0000001033247825ULL, 0x000fc800078e00b8ULL, 0x0000001090377824ULL, 0x004fe200078e020aULL,
0x0000000024357faeULL, 0x0003e2000b901c46ULL, 0x0000001033267825ULL, 0x000fc800078e00b6ULL,
0x000000108f397824ULL, 0x008fe200078e020aULL, 0x0000000026377faeULL, 0x0003e2000b901c46ULL,
0x0000001033287825ULL, 0x000fc800078e00b4ULL, 0x00000010332a7825ULL, 0x000fe200078e00aeULL,
0x0000000028397faeULL, 0x0003e6000b901c46ULL, 0x000000108d3d7824ULL, 0x010fe200078e020aULL,
0x000000002a3b7faeULL, 0x0003e2000b901c46ULL, 0x0000001033307825ULL, 0x000fca00078e00aaULL,
0x00000000303d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004ff087819ULL, 0x100fe40000011600ULL,
0x000000089d257812ULL, 0x002fc800078ef800ULL, 0x00000007080a7812ULL, 0x000fca00078e7825ULL,
0x00000020250a7824ULL, 0x000fc800078e020aULL, 0x000000100a287824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0x0000000e7aa87819ULL, 0x000fe200000006ffULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x00000002080e7810ULL, 0x000fe20007ffe0ffULL,
0x00000f8000007945ULL, 0x000fe20003800000ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee29dULL,
0x00002000a82c7810ULL, 0x000fe40007ffe0ffULL, 0x000000070c557812ULL, 0x040fe200078ec0ffULL,
0x000000080ca47824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fc400078e7825ULL,
0x0000000155d17812ULL, 0x000fe400078e7805ULL, 0x000000100ca77810ULL, 0x040fe20007ffe0ffULL,
0x00000020250e7824ULL, 0x000fe200078e020eULL, 0x000000a4d1d17212ULL, 0x000fe400078efcffULL,
0x000000200ca67810ULL, 0x000fe20007ffe0ffULL, 0x000000100e607824ULL, 0x000fe200078e00ffULL,
0x000000300c0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d19e7824ULL, 0x000fe200078e022cULL,
0x00000001050a7812ULL, 0x000fc400078ec0ffULL, 0x00000007a7277812ULL, 0x040fe200078ec0ffULL,
0x00000008a7a77824ULL, 0x000fe200078e00ffULL, 0x000000009e34783bULL, 0x000e620000000200ULL,
0x00000007a6537812ULL, 0x040fe200078ec0ffULL, 0x00000008a6a67824ULL, 0x000fe200078e00ffULL,
0x000000070c517812ULL, 0x040fe200078ec0ffULL, 0x000000080ca57824ULL, 0x000fe200078e00ffULL,
0x0000000255ad7812ULL, 0x000fe200078e1e0aULL, 0x000000006060783bULL, 0x000fe20000000200ULL,
0x00000001270e7812ULL, 0x100fe400078e7805ULL, 0x0000000153b17812ULL, 0x000fc400078e7805ULL,
0x00000001510c7812ULL, 0x000fe400078e7805ULL, 0x000000a4adad7212ULL, 0x000fe400078efcffULL,
0x000000a70ebd7212ULL, 0x000fe400078efcffULL, 0x000000a6b1b17212ULL, 0x000fe400078efcffULL,
0x000000a50cb37212ULL, 0x000fe200078efcffULL, 0x00000010bd8c7824ULL, 0x000fe200078e022cULL,
0x0000002cad897211ULL, 0x000fc400078e20ffULL, 0x0000002cb18b7211ULL, 0x000fe200078e20ffULL,
0x00000010b38a7824ULL, 0x000fe200078e022cULL, 0x000000008c4c783bULL, 0x000ea20000000200ULL,
0x00000002537d7812ULL, 0x100fe400078e1e0aULL, 0x00000002270c7812ULL, 0x100fe200078e1e0aULL,
0x000000008958783bULL, 0x000ee20000000200ULL, 0x000000a67d7d7212ULL, 0x000fe400078efcffULL,
0x000000a70ca97212ULL, 0x000fe200078efcffULL, 0x000000008b30783bULL, 0x000f220000000200ULL,
0x00000002510c7812ULL, 0x000fe200078e1e0aULL, 0x000000107d877824ULL, 0x000fe200078e022cULL,
0x0000000455777812ULL, 0x000fe200078e1e0aULL, 0x000000008a48783bULL, 0x000f620000000200ULL,
0x000000a50c9f7212ULL, 0x000fe200078efcffULL, 0x00000010a9887824ULL, 0x100fe200078e022cULL,
0x000000342844723cULL, 0x002fe200000018ffULL, 0x000000008738783bULL, 0x000e620000000200ULL,
0x00000004080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000109f867824ULL, 0x000fe200078e022cULL,
0x00000004270e7812ULL, 0x000fe200078e1e0aULL, 0x000000008840783bULL, 0x000e620000000200ULL,
0x000000070c0c7812ULL, 0x000fc400078e7825ULL, 0x000000362834723cULL, 0x040fe200000018ffULL,
0x0000000453757812ULL, 0x100fe400078e1e0aULL, 0x0000000451107812ULL, 0x000fe400078e1e0aULL,
0x0000000c250c7211ULL, 0x000fe400078e28ffULL, 0x000000a477777212ULL, 0x000fe400078efcffULL,
0x000000a70ea37212ULL, 0x000fe200078efcffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x000000a675757212ULL, 0x000fe200078efcffULL, 0x0000001077857824ULL, 0x100fe200078e022cULL,
0x000000a510a17212ULL, 0x000fe200078efcffULL, 0x00000010a3847824ULL, 0x100fe200078e022cULL,
0x00000006080e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001075837824ULL, 0x000fe200078e022cULL,
0x0000004c286c723cULL, 0x004fe200000018ffULL, 0x0000002ca1827211ULL, 0x000fe200078e20ffULL,
0x000000008570783bULL, 0x000fe20000000200ULL, 0x000000070e107812ULL, 0x000fc400078e7825ULL,
0x0000000655557812ULL, 0x100fe200078e1e0aULL, 0x000000008468783bULL, 0x000fe20000000200ULL,
0x00000006270e7812ULL, 0x100fe200078e1e0aULL, 0x000000586044723cULL, 0x048fe20000001844ULL,
0x0000000653537812ULL, 0x100fe200078e1e0aULL, 0x000000008364783bULL, 0x000fe20000000200ULL,
0x00000006510a7812ULL, 0x000fe400078e1e0aULL, 0x000000a455a47212ULL, 0x000fe200078efcffULL,
0x00000000825c783bULL, 0x000fe20000000200ULL, 0x000000a70ea77212ULL, 0x000fe200078efcffULL,
0x0000005a6058723cULL, 0x000fe20000001834ULL, 0x000000a653a67212ULL, 0x000fe200078efcffULL,
0x00000010a4817824ULL, 0x100fe200078e022cULL, 0x000000a50aa57212ULL, 0x000fe200078efcffULL,
0x00000010a7807824ULL, 0x000fe200078e022cULL, 0x0000002ca67f7211ULL, 0x000fc600078e20ffULL,
0x000000302834723cULL, 0x050fe200000018ffULL, 0x00000010a57e7824ULL, 0x000fe200078e022cULL,
0x000000008054783bULL, 0x000fe80000000200ULL, 0x000000007f50783bULL, 0x000fe40000000200ULL,
0x0000004e284c723cULL, 0x040ff000000018ffULL, 0x000000322830723cULL, 0x040ff000000018ffULL,
0x00000048283c723cULL, 0x060ff000000018ffULL, 0x0000004a2828723cULL, 0x000fe200000018ffULL,
0x000000008648783bULL, 0x000eae0000000200ULL, 0x000000386034723cULL, 0x042ff00000001834ULL,
0x0000003a6038723cULL, 0x040fe20000001830ULL, 0x000000000c30783bULL, 0x0002ee0000000200ULL,
0x00000040606c723cULL, 0x000fe2000000186cULL, 0x00000020250c7824ULL, 0x002fc800078e0210ULL,
0x000000100c0c7824ULL, 0x000fc600078e00ffULL, 0x000000426040723cULL, 0x040fe2000000184cULL,
0x00000000814c783bULL, 0x000fee0000000200ULL, 0x00000048603c723cULL, 0x044ff0000000183cULL,
0x0000004a6060723cULL, 0x000fe20000001828ULL, 0x000000000c48783bULL, 0x000e680000000200ULL,
0x000000007e28783bULL, 0x000ea60000000200ULL, 0x000000703044723cULL, 0x048ff00000001844ULL,
0x00000068306c723cULL, 0x040ff0000000186cULL, 0x000000643034723cULL, 0x040ff00000001834ULL,
0x000000723058723cULL, 0x040ff00000001858ULL, 0x0000006a3040723cULL, 0x040ff00000001840ULL,
0x000000663038723cULL, 0x040ff00000001838ULL, 0x0000005c303c723cULL, 0x040ff0000000183cULL,
0x0000005e3030723cULL, 0x000ff00000001860ULL, 0x0000004c4844723cULL, 0x042ff00000001844ULL,
0x00000054486c723cULL, 0x040ff0000000186cULL, 0x000000504834723cULL, 0x040ff00000001834ULL,
0x0000004e484c723cULL, 0x040ff00000001858ULL, 0x000000564854723cULL, 0x040ff00000001840ULL,
0x000000524850723cULL, 0x040ff00000001838ULL, 0x00000028483c723cULL, 0x044ff0000000183cULL,
0x0000002a4848723cULL, 0x000fe20000001830ULL, 0x0000046000008947ULL, 0x000fee0003800000ULL,
0x0000000179207824ULL, 0x000fe200078e0a04ULL, 0x000000109d417812ULL, 0x000fe200078efcffULL,
0x000000109c0a7824ULL, 0x100fe200078e022cULL, 0x0000002c9a0e7211ULL, 0x000fe200078e20ffULL,
0x000000109b0c7824ULL, 0x000fe200078e022cULL, 0x000000200500720cULL, 0x080fe20003f26070ULL,
0x0000001041267825ULL, 0x000fe200078e00d2ULL, 0x000000200700720cULL, 0x000fc40003f46070ULL,
0x000000200900720cULL, 0x080fe20003f66070ULL, 0x0000001041287825ULL, 0x000fe200078e00ceULL,
0x000000200d00720cULL, 0x080fe40003f86070ULL, 0x000000201700720cULL, 0x000fe20003fa6070ULL,
0x00000010412a7825ULL, 0x000fe200078e00ccULL, 0x0000002c95187211ULL, 0x000fe400078e20ffULL,
0x000000202300720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260a7faeULL, 0x0003e2000c901c46ULL, 0x000000200b00720cULL, 0x000fe20003f26070ULL,
0x0000001099107824ULL, 0x000fe200078e022cULL, 0x0000002c90227211ULL, 0x000fe200078e20ffULL,
0x00000000280c7faeULL, 0x0005e2000d101c46ULL, 0x000000200f00720cULL, 0x000fe20003f46070ULL,
0x0000001041307825ULL, 0x000fc400078e00caULL, 0x000000002a0e7faeULL, 0x0007e2000d901c46ULL,
0x000000201100720cULL, 0x080fe20003f66070ULL, 0x0000001098127824ULL, 0x000fe400078e022cULL,
0x0000001041327825ULL, 0x000fe400078e00c8ULL, 0x0000000030107faeULL, 0x0009e2000c901c46ULL,
0x000000201900720cULL, 0x080fe20003f26070ULL, 0x0000001097147824ULL, 0x000fe400078e022cULL,
0x0000001041267825ULL, 0x002fe200078e00c6ULL, 0x0000000032127faeULL, 0x0003e2000e101c46ULL,
0x000000201300720cULL, 0x000fc40003f86070ULL, 0x0000001096167824ULL, 0x000fe200078e022cULL,
0x0000000026147faeULL, 0x000be2000d101c46ULL, 0x000000201500720cULL, 0x000fe20003f46070ULL,
0x00000010412a7825ULL, 0x008fc800078e00c2ULL, 0x0000001041307825ULL, 0x010fc800078e00c4ULL,
0x00000010941a7824ULL, 0x000fe200078e022cULL, 0x0000000030167faeULL, 0x0007e2000d901c46ULL,
0x0000001041287825ULL, 0x004fe200078e00c0ULL, 0x000000201d00720cULL, 0x080fe40003f66070ULL,
0x000000002a187faeULL, 0x0005e2000e101c46ULL, 0x00000010931c7824ULL, 0x000fe200078e022cULL,
0x000000201f00720cULL, 0x080fe20003f86070ULL, 0x0000001041267825ULL, 0x020fe200078e00beULL,
0x00000000281a7faeULL, 0x0009e2000d101c46ULL, 0x000000201b00720cULL, 0x000fc40003f46070ULL,
0x00000010921e7824ULL, 0x000fe200078e022cULL, 0x00000000261c7faeULL, 0x000be2000e901c46ULL,
0x000000202100720cULL, 0x000fe20003fa6070ULL, 0x00000010413a7825ULL, 0x000fc800078e00baULL,
0x0000001091207824ULL, 0x000fe200078e022cULL, 0x000000003a1e7faeULL, 0x0005e2000c901c46ULL,
0x0000001041387825ULL, 0x000fc800078e00b8ULL, 0x0000001041327825ULL, 0x002fe200078e00b6ULL,
0x0000000038207faeULL, 0x0003e6000d101c46ULL, 0x000000108f247824ULL, 0x000fe200078e022cULL,
0x0000000032227faeULL, 0x0003e2000d901c46ULL, 0x0000001041307825ULL, 0x008fc800078e00b4ULL,
0x000000108e267824ULL, 0x020fe200078e022cULL, 0x0000000030247faeULL, 0x0003e2000e101c46ULL,
0x00000010412a7825ULL, 0x004fc800078e00aeULL, 0x000000108d277824ULL, 0x000fe200078e022cULL,
0x000000002a267faeULL, 0x0003e2000e901c46ULL, 0x0000001041287825ULL, 0x010fca00078e00aaULL,
0x0000000028277faeULL, 0x0003e2000f101c46ULL, 0x0000034000007947ULL, 0x000fea0003800000ULL,
0x000000109d437812ULL, 0x000fe200078efcffULL, 0x000000109c0a7824ULL, 0x100fe200078e022cULL,
0x0000002c9b0c7211ULL, 0x080fe200078e20ffULL, 0x000000109a0e7824ULL, 0x000fe200078e022cULL,
0x0000002c96167211ULL, 0x080fe200078e20ffULL, 0x0000001043267825ULL, 0x000fe200078e00d2ULL,
0x0000002c91207211ULL, 0x000fc600078e20ffULL, 0x0000001043287825ULL, 0x040fe200078e00ceULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260a7faeULL, 0x0003e6000b901c46ULL,
0x00000010432a7825ULL, 0x000fe200078e00ccULL, 0x00000000280c7faeULL, 0x0005e6000b901c46ULL,
0x0000001099107824ULL, 0x000fe200078e022cULL, 0x000000002a0e7faeULL, 0x0007e2000b901c46ULL,
0x0000001043327825ULL, 0x000fc800078e00caULL, 0x0000001098127824ULL, 0x000fe200078e022cULL,
0x0000000032107faeULL, 0x0009e2000b901c46ULL, 0x0000001043387825ULL, 0x000fc800078e00c8ULL,
0x0000001097147824ULL, 0x000fe200078e022cULL, 0x0000000038127faeULL, 0x000be2000b901c46ULL,
0x0000001043407825ULL, 0x000fc800078e00c6ULL, 0x0000001043267825ULL, 0x002fe200078e00c4ULL,
0x0000000040147faeULL, 0x0003e6000b901c46ULL, 0x0000001095187824ULL, 0x000fe200078e022cULL,
0x0000000026167faeULL, 0x0003e2000b901c46ULL, 0x0000001043307825ULL, 0x000fc800078e00c2ULL,
0x00000010941a7824ULL, 0x000fe200078e022cULL, 0x0000000030187faeULL, 0x0003e2000b901c46ULL,
0x00000010432a7825ULL, 0x008fc800078e00c0ULL, 0x00000010931c7824ULL, 0x000fe200078e022cULL,
0x000000002a1a7faeULL, 0x0007e2000b901c46ULL, 0x0000001043287825ULL, 0x004fc800078e00beULL,
0x00000010921e7824ULL, 0x000fe200078e022cULL, 0x00000000281c7faeULL, 0x0005e2000b901c46ULL,
0x00000010433a7825ULL, 0x000fc800078e00baULL, 0x0000001043387825ULL, 0x060fe200078e00b8ULL,
0x000000003a1e7faeULL, 0x0005e6000b901c46ULL, 0x0000001090227824ULL, 0x000fe200078e022cULL,
0x0000000038207faeULL, 0x0005e2000b901c46ULL, 0x0000001043327825ULL, 0x010fc800078e00b6ULL,
0x000000108f247824ULL, 0x000fe200078e022cULL, 0x0000000032227faeULL, 0x0009e2000b901c46ULL,
0x0000001043307825ULL, 0x002fc800078e00b4ULL, 0x000000108e267824ULL, 0x000fe200078e022cULL,
0x0000000030247faeULL, 0x0009e2000b901c46ULL, 0x00000010432a7825ULL, 0x008fc800078e00aeULL,
0x000000108d277824ULL, 0x000fe200078e022cULL, 0x000000002a267faeULL, 0x0009e2000b901c46ULL,
0x0000001043287825ULL, 0x004fca00078e00aaULL, 0x0000000028277faeULL, 0x0009e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000808287810ULL, 0x012fe20007ffe0ffULL, 0x00000d1000007945ULL, 0x000fe20003800000ULL,
0x00004000a8a87810ULL, 0x000fe40007ffe0ffULL, 0x0000000728287812ULL, 0x100fe400078e7825ULL,
0x0000000a082a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010a97c7824ULL, 0x100fe200078e02a8ULL,
0x0000002825297211ULL, 0x000fe200078e28ffULL, 0x00000010d1287824ULL, 0x100fe200078e02a8ULL,
0x000000072a2c7812ULL, 0x000fe200078e7825ULL, 0x00000010b32b7824ULL, 0x100fe200078e02a8ULL,
0x000000a8b12a7211ULL, 0x080fe200078e20ffULL, 0x0000001029587824ULL, 0x000fe200078e00ffULL,
0x000000a875a27211ULL, 0x000fe200078e20ffULL, 0x00000010bd297824ULL, 0x000fc400078e02a8ULL,
0x0000002025407824ULL, 0x000fe400078e022cULL, 0x00000010ad2c7824ULL, 0x100fe400078e02a8ULL,
0x000000107d7d7824ULL, 0x000fe200078e02a8ULL, 0x0000000440407819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002830783bULL, 0x000fe20000000200ULL,
0x000000109f9f7824ULL, 0x100fe400078e02a8ULL, 0x0000001077a07824ULL, 0x100fe200078e02a8ULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x00000010a3a37824ULL, 0x100fe400078e02a8ULL,
0x00000010a1a17824ULL, 0x100fe200078e02a8ULL, 0x000000002938783bULL, 0x000ea20000000200ULL,
0x00000010a4a47824ULL, 0x100fe400078e02a8ULL, 0x00000010a7a77824ULL, 0x100fe200078e02a8ULL,
0x000000002c70783bULL, 0x000fe20000000200ULL, 0x00000010a6a67824ULL, 0x000fc400078e02a8ULL,
0x00000010a5a57824ULL, 0x000fe200078e02a8ULL, 0x000000004040783bULL, 0x000ee80000000200ULL,
0x000000002a60783bULL, 0x000f280000000200ULL, 0x000000002b5c783bULL, 0x000fe80000000200ULL,
0x00000000a074783bULL, 0x000fe80000000200ULL, 0x00000000a368783bULL, 0x000fe80000000200ULL,
0x00000000a264783bULL, 0x000fe20000000200ULL, 0x000000305844723cULL, 0x042ff00000001844ULL,
0x00000032584c723cULL, 0x040fe2000000184cULL, 0x000000007c30783bULL, 0x000e6e0000000200ULL,
0x00000038586c723cULL, 0x044ff0000000186cULL, 0x0000003a5854723cULL, 0x000fe20000001854ULL,
0x000000007d38783bULL, 0x000eae0000000200ULL, 0x000000704044723cULL, 0x048ff00000001844ULL,
0x000000724070723cULL, 0x000fe2000000184cULL, 0x000000009f4c783bULL, 0x000eee0000000200ULL,
0x000000605834723cULL, 0x050ff00000001834ULL, 0x000000625850723cULL, 0x000fe20000001850ULL,
0x00000000a160783bULL, 0x000fee0000000200ULL, 0x00000030406c723cULL, 0x002fee000000186cULL,
0x0000000c08307810ULL, 0x000fe20007ffe0ffULL, 0x0000005c583c723cULL, 0x040ff0000000183cULL,
0x0000005e5848723cULL, 0x000fee0000001848ULL, 0x0000000730587812ULL, 0x000fe200078e7825ULL,
0x000000384034723cULL, 0x004fe60000001834ULL, 0x0000005825587211ULL, 0x000fca00078e28ffULL,
0x0000001058587824ULL, 0x000fe200078e00ffULL, 0x0000003a4038723cULL, 0x040fe80000001850ULL,
0x00000000585c783bULL, 0x000e660000000200ULL, 0x0000000e08507810ULL, 0x000fe20007ffe0ffULL,
0x000000324030723cULL, 0x000fe20000001854ULL, 0x00000000a458783bULL, 0x000fe40000000200ULL,
0x0000000750507812ULL, 0x000fc400078e7825ULL, 0x00000000a754783bULL, 0x000fe60000000200ULL,
0x0000002025507824ULL, 0x000fe200078e0250ULL, 0x0000004c403c723cULL, 0x048fe8000000183cULL,
0x0000000450a97819ULL, 0x000fe400000006ffULL, 0x00000000a650783bULL, 0x000fe40000000200ULL,
0x0000004e4040723cULL, 0x000fe40000001848ULL, 0x00000000a948783bULL, 0x000ea80000000200ULL,
0x00000000a54c783bULL, 0x000ee40000000200ULL, 0x000000745c44723cULL, 0x042ff00000001844ULL,
0x000000765c70723cULL, 0x040ff00000001870ULL, 0x000000685c6c723cULL, 0x040ff0000000186cULL,
0x0000006a5c30723cULL, 0x040ff00000001830ULL, 0x000000645c34723cULL, 0x040ff00000001834ULL,
0x000000665c38723cULL, 0x040ff00000001838ULL, 0x000000605c3c723cULL, 0x040ff0000000183cULL,
0x000000625c40723cULL, 0x000ff00000001840ULL, 0x000000584844723cULL, 0x044ff00000001844ULL,
0x0000005a4870723cULL, 0x040ff00000001870ULL, 0x00000054486c723cULL, 0x040ff0000000186cULL,
0x000000564830723cULL, 0x040ff00000001830ULL, 0x000000504834723cULL, 0x040ff00000001834ULL,
0x000000524838723cULL, 0x040ff00000001838ULL, 0x0000004c483c723cULL, 0x048ff0000000183cULL,
0x0000004e4848723cULL, 0x000fe20000001840ULL, 0x0000046000008947ULL, 0x000fee0003800000ULL,
0x8000000479407210ULL, 0x000fe20007ffe0ffULL, 0x000000109c417824ULL, 0x100fe200078e02a8ULL,
0x000000189d9d7812ULL, 0x000fe200078efcffULL, 0x000000109b9b7824ULL, 0x100fe200078e02a8ULL,
0x000000400500720cULL, 0x080fe20003f06070ULL, 0x000000109a437824ULL, 0x000fe200078e02a8ULL,
0x000000400700720cULL, 0x080fe20003f26070ULL, 0x000000109dd27825ULL, 0x000fe200078e00d2ULL,
0x000000400d00720cULL, 0x000fc40003f46070ULL, 0x000000400f00720cULL, 0x080fe20003f66070ULL,
0x000000109dce7825ULL, 0x000fe200078e00ceULL, 0x000000401100720cULL, 0x080fe40003f86070ULL,
0x000000401300720cULL, 0x080fe20003fa6070ULL, 0x000000109dcc7825ULL, 0x000fe200078e00ccULL,
0x000000401500720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000d2417faeULL, 0x0003e2000c101c46ULL, 0x000000400900720cULL, 0x000fe20003f06070ULL,
0x000000109dca7825ULL, 0x000fe200078e00caULL, 0x000000a899997211ULL, 0x000fe200078e20ffULL,
0x00000000ce9b7faeULL, 0x0005e2000c901c46ULL, 0x000000400b00720cULL, 0x000fe20003f26070ULL,
0x00000010984d7824ULL, 0x000fe200078e02a8ULL, 0x000000a895957211ULL, 0x080fe200078e20ffULL,
0x000000109dc87825ULL, 0x000fe200078e00c8ULL, 0x000000a891917211ULL, 0x000fc400078e20ffULL,
0x000000a88d8d7211ULL, 0x000fe200078e20ffULL, 0x0000001097977824ULL, 0x000fe400078e02a8ULL,
0x000000109dc67825ULL, 0x000fe200078e00c6ULL, 0x00000000cc437faeULL, 0x0005e2000c101c46ULL,
0x000000401700720cULL, 0x080fe40003f06070ULL, 0x00000010964f7824ULL, 0x000fe200078e02a8ULL,
0x00000000ca997faeULL, 0x0005e2000c901c46ULL, 0x000000109dc47825ULL, 0x000fe200078e00c4ULL,
0x000000401900720cULL, 0x000fc40003f26070ULL, 0x00000000c84d7faeULL, 0x0005e2000d101c46ULL,
0x000000109dc27825ULL, 0x000fe200078e00c2ULL, 0x000000401b00720cULL, 0x080fe40003f46070ULL,
0x00000000c6977faeULL, 0x0005e2000d901c46ULL, 0x0000001094517824ULL, 0x000fe200078e02a8ULL,
0x000000401d00720cULL, 0x080fe20003f66070ULL, 0x000000109dc07825ULL, 0x000fe200078e00c0ULL,
0x00000000c44f7faeULL, 0x0005e2000e101c46ULL, 0x000000401f00720cULL, 0x080fe40003f86070ULL,
0x0000001093937824ULL, 0x000fe200078e02a8ULL, 0x00000000c2957faeULL, 0x0005e2000e901c46ULL,
0x000000402100720cULL, 0x000fe20003fa6070ULL, 0x000000109dbe7825ULL, 0x000fc400078e00beULL,
0x00000000c0517faeULL, 0x0005e2000f101c46ULL, 0x000000402300720cULL, 0x000fe20003fc6070ULL,
0x0000001092537824ULL, 0x000fe400078e02a8ULL, 0x000000109dba7825ULL, 0x040fe200078e00baULL,
0x00000000be937faeULL, 0x0005e6000c101c46ULL, 0x000000109db87825ULL, 0x040fe200078e00b8ULL,
0x00000000ba537faeULL, 0x0005e6000c901c46ULL, 0x0000001090417824ULL, 0x002fe200078e02a8ULL,
0x00000000b8917faeULL, 0x0005e2000d101c46ULL, 0x000000109db67825ULL, 0x000fc800078e00b6ULL,
0x000000108f8f7824ULL, 0x000fe200078e02a8ULL, 0x00000000b6417faeULL, 0x0005e2000d901c46ULL,
0x000000109db47825ULL, 0x000fc800078e00b4ULL, 0x000000108e557824ULL, 0x000fe200078e02a8ULL,
0x00000000b48f7faeULL, 0x0005e2000e101c46ULL, 0x000000109dae7825ULL, 0x000fc800078e00aeULL,
0x000000109daa7825ULL, 0x000fe200078e00aaULL, 0x00000000ae557faeULL, 0x0005e8000e901c46ULL,
0x00000000aa8d7faeULL, 0x0005e2000f101c46ULL, 0x0000034000007947ULL, 0x000fea0003800000ULL,
0x000000189d9d7812ULL, 0x000fe200078efcffULL, 0x000000109c417824ULL, 0x100fe200078e02a8ULL,
0x000000a899997211ULL, 0x080fe200078e20ffULL, 0x000000109b9b7824ULL, 0x000fe200078e02a8ULL,
0x000000a895957211ULL, 0x080fe200078e20ffULL, 0x000000109dd27825ULL, 0x000fe200078e00d2ULL,
0x000000a891917211ULL, 0x000fc400078e20ffULL, 0x000000a88d8d7211ULL, 0x000fe200078e20ffULL,
0x000000109dce7825ULL, 0x040fe200078e00ceULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000d2417faeULL, 0x0003e6000b901c46ULL, 0x000000109a437824ULL, 0x000fe200078e02a8ULL,
0x00000000ce9b7faeULL, 0x0003e2000b901c46ULL, 0x000000109dcc7825ULL, 0x000fc800078e00ccULL,
0x000000109dca7825ULL, 0x040fe200078e00caULL, 0x00000000cc437faeULL, 0x0003e6000b901c46ULL,
0x00000010984d7824ULL, 0x000fe200078e02a8ULL, 0x00000000ca997faeULL, 0x0003e2000b901c46ULL,
0x000000109dc87825ULL, 0x000fc800078e00c8ULL, 0x0000001097977824ULL, 0x000fe200078e02a8ULL,
0x00000000c84d7faeULL, 0x0003e2000b901c46ULL, 0x000000109dc67825ULL, 0x000fc800078e00c6ULL,
0x00000010964f7824ULL, 0x000fe200078e02a8ULL, 0x00000000c6977faeULL, 0x0003e2000b901c46ULL,
0x000000109dc47825ULL, 0x000fc800078e00c4ULL, 0x000000109dc27825ULL, 0x040fe200078e00c2ULL,
0x00000000c44f7faeULL, 0x0003e6000b901c46ULL, 0x0000001094517824ULL, 0x000fe200078e02a8ULL,
0x00000000c2957faeULL, 0x0003e2000b901c46ULL, 0x000000109dc07825ULL, 0x000fc800078e00c0ULL,
0x0000001093937824ULL, 0x000fe200078e02a8ULL, 0x00000000c0517faeULL, 0x0003e2000b901c46ULL,
0x000000109dbe7825ULL, 0x000fc800078e00beULL, 0x0000001092537824ULL, 0x000fe200078e02a8ULL,
0x00000000be937faeULL, 0x0003e2000b901c46ULL, 0x000000109dba7825ULL, 0x000fc800078e00baULL,
0x000000109db87825ULL, 0x040fe200078e00b8ULL, 0x00000000ba537faeULL, 0x0003e6000b901c46ULL,
0x0000001090557824ULL, 0x000fe200078e02a8ULL, 0x00000000b8917faeULL, 0x0003e2000b901c46ULL,
0x000000109db67825ULL, 0x000fc800078e00b6ULL, 0x000000108f8f7824ULL, 0x000fe200078e02a8ULL,
0x00000000b6557faeULL, 0x0003e2000b901c46ULL, 0x000000109db47825ULL, 0x000fc800078e00b4ULL,
0x000000108e577824ULL, 0x000fe200078e02a8ULL, 0x00000000b48f7faeULL, 0x0003e2000b901c46ULL,
0x000000109dae7825ULL, 0x000fc800078e00aeULL, 0x000000109daa7825ULL, 0x000fe200078e00aaULL,
0x00000000ae577faeULL, 0x0003e8000b901c46ULL, 0x00000000aa8d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001008407810ULL, 0x040fe20007ffe0ffULL, 0x0000108000007945ULL, 0x000fe20003800000ULL,
0x00000012084c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000740407812ULL, 0x000fc400078e7825ULL,
0x000000074c4c7812ULL, 0x000fc600078e7825ULL, 0x0000002025407824ULL, 0x040fe400078e0240ULL,
0x00000020254c7824ULL, 0x000fe400078e024cULL, 0x0000001040547824ULL, 0x000fc600078e00ffULL,
0x000000044c4c7819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000009e64783bULL, 0x000fe80000000200ULL, 0x000000005454783bULL, 0x006e680000000200ULL,
0x000000008c40783bULL, 0x000ea80000000200ULL, 0x000000008b5c783bULL, 0x000ee80000000200ULL,
0x000000004c4c783bULL, 0x000fe80000000200ULL, 0x000000008a58783bULL, 0x000fe80000000200ULL,
0x000000008950783bULL, 0x000fe80000000200ULL, 0x000000008174783bULL, 0x000fe80000000200ULL,
0x000000008068783bULL, 0x000fe20000000200ULL, 0x000000645460723cULL, 0x042fe60000001844ULL,
0x000000008844783bULL, 0x000e6a0000000200ULL, 0x00000040546c723cULL, 0x044ff0000000186cULL,
0x000000665470723cULL, 0x040fe20000001870ULL, 0x000000008764783bULL, 0x000eae0000000200ULL,
0x000000425430723cULL, 0x040fe20000001830ULL, 0x000000008640783bULL, 0x000f2e0000000200ULL,
0x0000005c5434723cULL, 0x048ff00000001834ULL, 0x0000005e5438723cULL, 0x000fe20000001838ULL,
0x00000000825c783bULL, 0x000fee0000000200ULL, 0x000000444c6c723cULL, 0x002fee000000186cULL,
0x0000001408447810ULL, 0x000fe20007ffe0ffULL, 0x00000058543c723cULL, 0x000fe6000000183cULL,
0x0000000744447812ULL, 0x000fca00078e7825ULL, 0x0000002025447824ULL, 0x000fe200078e0244ULL,
0x0000005a5448723cULL, 0x000fe20000001848ULL, 0x000000008354783bULL, 0x000fe40000000200ULL,
0x0000001044587824ULL, 0x000fca00078e00ffULL, 0x000000504c60723cULL, 0x040fe20000001860ULL,
0x000000005858783bULL, 0x000fee0000000200ULL, 0x000000524c70723cULL, 0x040fe20000001870ULL,
0x000000008450783bULL, 0x000fee0000000200ULL, 0x000000464c30723cULL, 0x040fe20000001830ULL,
0x000000008544783bULL, 0x000e6e0000000200ULL, 0x000000644c34723cULL, 0x044fee0000001834ULL,
0x0000001608647810ULL, 0x000fe20007ffe0ffULL, 0x000000664c38723cULL, 0x000fe60000001838ULL,
0x0000000764647812ULL, 0x000fca00078e7825ULL, 0x0000002025647824ULL, 0x000fe200078e0264ULL,
0x000000404c3c723cULL, 0x050fee000000183cULL, 0x0000000464407819ULL, 0x000fe200000006ffULL,
0x000000424c48723cULL, 0x000fe20000001848ULL, 0x000000007f64783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000ea60000000200ULL, 0x000000445860723cULL, 0x042fe20000001860ULL,
0x000000007e4c783bULL, 0x000e6e0000000200ULL, 0x000000465870723cULL, 0x040ff00000001870ULL,
0x00000050586c723cULL, 0x040ff0000000186cULL, 0x000000525830723cULL, 0x040ff00000001830ULL,
0x000000545834723cULL, 0x040ff00000001834ULL, 0x000000565838723cULL, 0x040ff00000001838ULL,
0x0000005c583c723cULL, 0x040ff0000000183cULL, 0x0000005e5848723cULL, 0x000ff00000001848ULL,
0x000000744060723cULL, 0x044ff00000001860ULL, 0x000000764070723cULL, 0x040ff00000001870ULL,
0x00000068406c723cULL, 0x040ff0000000186cULL, 0x0000006a4030723cULL, 0x040ff00000001830ULL,
0x000000644034723cULL, 0x040ff00000001834ULL, 0x000000664038723cULL, 0x040ff00000001838ULL,
0x0000004c403c723cULL, 0x042ff0000000183cULL, 0x0000004e4048723cULL, 0x000fee0000001848ULL,
0x000003007b417a10ULL, 0x000fc80007ffe0ffULL, 0x0000000141437810ULL, 0x040fe20007ffe0ffULL,
0x0000010041427824ULL, 0x000fc600078e022eULL, 0x000000784300720cULL, 0x000fe20003f06070ULL,
0x000062002f567a24ULL, 0x000fd800078e0242ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000004279407217ULL, 0x000fe20007800000ULL, 0x0000000105437824ULL, 0x100fe200078e0256ULL,
0x0000000400447819ULL, 0x000fe200000006ffULL, 0x0000000107457824ULL, 0x000fe400078e0256ULL,
0x0000000140407824ULL, 0x000fe200078e0a42ULL, 0x0000007044577812ULL, 0x000fe200078ec0ffULL,
0x00005e0043427625ULL, 0x000fc600078e0006ULL, 0x000000400900720cULL, 0x000fe20003f86070ULL,
0x00005e0045447625ULL, 0x000fe200078e0006ULL, 0x00000042574c7210ULL, 0x000fe40007f1e0ffULL,
0x000000400500720cULL, 0x000fe20003f66070ULL, 0x0000000109097824ULL, 0x100fe200078e0256ULL,
0x00000043ff4d7210ULL, 0x000fe200007fe4ffULL, 0x000000010b477824ULL, 0x000fe200078e0256ULL,
0x00000044574e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0009427625ULL, 0x000fe200078e0006ULL,
0x000000400700720cULL, 0x000fc40003f46070ULL, 0x000000400b00720cULL, 0x000fe20003fa6070ULL,
0x000000010d057824ULL, 0x100fe200078e0256ULL, 0x0000004257507210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff4f7224ULL, 0x000fe200000e0645ULL, 0x000000400d00720cULL, 0x000fe20003f06070ULL,
0x00005e0047467625ULL, 0x000fe200078e0006ULL, 0x00000043ff517210ULL, 0x000fe20000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004c0a7faeULL, 0x0003e2000d901c46ULL,
0x00000056150b7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0005447625ULL, 0x000fe200078e0006ULL,
0x0000004657467210ULL, 0x000fe20007fde0ffULL, 0x000000004e0c7faeULL, 0x0005e2000d101c46ULL,
0x000000401100720cULL, 0x000fe20003f46070ULL, 0x000000010f077824ULL, 0x000fe200078e0256ULL,
0x0000004457527210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff477224ULL, 0x000fe200030e0647ULL,
0x00000000500e7faeULL, 0x0007e2000e101c46ULL, 0x00005e0007427625ULL, 0x000fe200078e0006ULL,
0x00000045ff537210ULL, 0x000fc40000ffe4ffULL, 0x000000400f00720cULL, 0x000fe20003f26070ULL,
0x0000000113077824ULL, 0x100fe200078e0256ULL, 0x0000004257547210ULL, 0x000fe20007fde0ffULL,
0x0000000111057824ULL, 0x100fe200078e0256ULL, 0x0000000046107faeULL, 0x0009e2000e901c46ULL,
0x00000001170d7824ULL, 0x000fe200078e0256ULL, 0x000000401500720cULL, 0x000fe20003fa6070ULL,
0x000000ffff557224ULL, 0x000fe200030e0643ULL, 0x0000000052127faeULL, 0x000be2000c101c46ULL,
0x00005e0007427625ULL, 0x000fe200078e0006ULL, 0x000000401900720cULL, 0x000fc40003f06070ULL,
0x000000401700720cULL, 0x000fe20003f86070ULL, 0x00005e0005447625ULL, 0x000fe200078e0006ULL,
0x0000004257427210ULL, 0x000fe20007fde0ffULL, 0x0000000054147faeULL, 0x0009e4000c901c46ULL,
0x00005e000b0a7625ULL, 0x002fe200078e0006ULL, 0x0000004457447210ULL, 0x000fc60007f7e0ffULL,
0x00005e000d0c7625ULL, 0x004fe200078e0006ULL, 0x0000000a570e7210ULL, 0x008fc60007f3e0ffULL,
0x0000000119197824ULL, 0x100fe200078e0256ULL, 0x0000000bff0f7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff437224ULL, 0x000fe200030e0643ULL, 0x0000000c57107210ULL, 0x010fe20007fde0ffULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x000000401300720cULL, 0x000fe20003f66070ULL,
0x00005e00190a7625ULL, 0x000fe200078e0006ULL, 0x000000401b00720cULL, 0x040fe40003f26070ULL,
0x0000000044167faeULL, 0x0003e2000d101c46ULL, 0x000000011b057824ULL, 0x000fe200078e0256ULL,
0x0000000a57127210ULL, 0x020fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fc400030e060dULL,
0x00005e00050c7625ULL, 0x000fe200078e0006ULL, 0x0000000bff137210ULL, 0x000fe400017fe4ffULL,
0x000000401d00720cULL, 0x040fe20003f46070ULL, 0x000000011d057824ULL, 0x100fe200078e0256ULL,
0x0000000042187faeULL, 0x0005e2000d901c46ULL, 0x0000000c57147210ULL, 0x000fe20007fde0ffULL,
0x000000011f077824ULL, 0x100fe400078e0256ULL, 0x00005e00050a7625ULL, 0x000fe200078e0006ULL,
0x000000000e1a7faeULL, 0x0005e6000e901c46ULL, 0x0000000121057824ULL, 0x000fe200078e0256ULL,
0x0000000a57167210ULL, 0x002fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200030e060dULL,
0x00000000101c7faeULL, 0x0005e2000e101c46ULL, 0x00005e00070c7625ULL, 0x000fe200078e0006ULL,
0x0000000bff177210ULL, 0x000fc40001ffe4ffULL, 0x000000401f00720cULL, 0x000fe20003f66070ULL,
0x00005e00050a7625ULL, 0x000fe200078e0006ULL, 0x0000000c570c7210ULL, 0x000fe20007fde0ffULL,
0x00000000121e7faeULL, 0x0005e2000c101c46ULL, 0x000000402100720cULL, 0x000fe20003f86070ULL,
0x0000000123077824ULL, 0x000fe200078e0256ULL, 0x0000000a570a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000014207faeULL, 0x0005e2000c901c46ULL,
0x00005e0007067625ULL, 0x000fc600078e0006ULL, 0x0000000016227faeULL, 0x0005e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x000000402300720cULL, 0x000fe40003fa6070ULL,
0x0000000657067210ULL, 0x000fe20007fde0ffULL, 0x000000000c247faeULL, 0x0005e8000d901c46ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000000a267faeULL, 0x0005ea000e101c46ULL,
0x0000000006277faeULL, 0x0005e2000e901c46ULL, 0x0000055000007947ULL, 0x000fea0003800000ULL,
0x0000005605437210ULL, 0x080fe20007ffe0ffULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x000000560d4f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000107457824ULL, 0x000fe200078e0256ULL,
0x0000005615577210ULL, 0x000fe20007ffe0ffULL, 0x00005e0043427625ULL, 0x000fe200078e0006ULL,
0x0000007005057812ULL, 0x000fc400078ec0ffULL, 0x000000561b5d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0045447625ULL, 0x000fe200078e0006ULL, 0x0000004205427210ULL, 0x000fe40007f1e0ffULL,
0x0000005623697210ULL, 0x000fe20007ffe0ffULL, 0x0000000109477824ULL, 0x000fe400078e0256ULL,
0x000000ffff437224ULL, 0x000fe200000e0643ULL, 0x0000004405447210ULL, 0x000fe20007f1e0ffULL,
0x00005e004f4e7625ULL, 0x000fc600078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000420a7faeULL, 0x0003e2000b901c46ULL, 0x00005e0047467625ULL, 0x000fc800078e0006ULL,
0x0000000111537824ULL, 0x100fe200078e0256ULL, 0x0000004605467210ULL, 0x000fe20007f3e0ffULL,
0x000000010f517824ULL, 0x000fe400078e0256ULL, 0x000000ffff457224ULL, 0x000fe200000e0645ULL,
0x0000004e054e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0053527625ULL, 0x000fc600078e0006ULL,
0x00000000440c7faeULL, 0x0003e2000b901c46ULL, 0x00005e0051507625ULL, 0x000fc800078e0006ULL,
0x0000000113557824ULL, 0x100fe400078e0256ULL, 0x000000010b4d7824ULL, 0x100fe400078e0256ULL,
0x000000ffff4f7224ULL, 0x000fe200000e064fULL, 0x0000005205527210ULL, 0x000fe20007f1e0ffULL,
0x0000000117597824ULL, 0x100fe400078e0256ULL, 0x00000001195b7824ULL, 0x100fe400078e0256ULL,
0x000000011d5f7824ULL, 0x000fc400078e0256ULL, 0x000000011f657824ULL, 0x100fe400078e0256ULL,
0x0000000121677824ULL, 0x000fe400078e0256ULL, 0x000000ffff477224ULL, 0x000fe200008e0647ULL,
0x0000005005507210ULL, 0x000fe20007f3e0ffULL, 0x00005e0057567625ULL, 0x000fc600078e0006ULL,
0x00000000460e7faeULL, 0x0003e2000b901c46ULL, 0x00005e0055547625ULL, 0x000fc800078e0006ULL,
0x00005e004d4c7625ULL, 0x000fc800078e0006ULL, 0x000000ffff537224ULL, 0x000fe200000e0653ULL,
0x0000005605567210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff517224ULL, 0x000fe200008e0651ULL,
0x0000005405547210ULL, 0x000fe20007f3e0ffULL, 0x00005e0059587625ULL, 0x000fe200078e0006ULL,
0x0000004c054c7210ULL, 0x000fe40007f5e0ffULL, 0x00000055ff557210ULL, 0x000fe20000ffe4ffULL,
0x00005e005d5c7625ULL, 0x000fe200078e0006ULL, 0x0000004dff4d7210ULL, 0x000fe400017fe4ffULL,
0x0000005805587210ULL, 0x000fe20007f3e0ffULL, 0x00005e005b5a7625ULL, 0x000fc400078e0006ULL,
0x000000004c107faeULL, 0x0003e4000b901c46ULL, 0x000000ffff577224ULL, 0x000fe200000e0657ULL,
0x0000005c055c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e005f5e7625ULL, 0x000fe200078e0006ULL,
0x0000005a055a7210ULL, 0x000fe20007f5e0ffULL, 0x000000004e127faeULL, 0x0003e2000b901c46ULL,
0x0000005dff5d7210ULL, 0x000fe200007fe4ffULL, 0x00005e0065647625ULL, 0x080fe400078e0006ULL,
0x0000000050147faeULL, 0x0003e4000b901c46ULL, 0x00005e0067667625ULL, 0x000fc400078e0006ULL,
0x0000000052167faeULL, 0x0003e4000b901c46ULL, 0x00005e0069687625ULL, 0x000fe200078e0006ULL,
0x0000005e05067210ULL, 0x040fe20007f1e0ffULL, 0x0000000054187faeULL, 0x0003e4000b901c46ULL,
0x000000ffff597224ULL, 0x000fe200008e0659ULL, 0x00000064055e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff5b7224ULL, 0x000fe200010e065bULL, 0x0000006605647210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e065fULL, 0x0000006805667210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff5f7224ULL, 0x000fe200008e0665ULL, 0x00000000561a7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff657224ULL, 0x000fe200010e0667ULL, 0x00000069ff677210ULL, 0x000fc40001ffe4ffULL,
0x00000000581c7faeULL, 0x0003e8000b901c46ULL, 0x000000005a1e7faeULL, 0x0003e8000b901c46ULL,
0x000000005c207faeULL, 0x0003e8000b901c46ULL, 0x0000000006227faeULL, 0x0003e8000b901c46ULL,
0x000000005e247faeULL, 0x0003e8000b901c46ULL, 0x0000000064267faeULL, 0x0003e8000b901c46ULL,
0x0000000066277faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001808067810ULL, 0x006fc40007ffe0ffULL,
0x0000001a080a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000706067812ULL, 0x100fe400078e7825ULL,
0x000000070a0a7812ULL, 0x000fe400078e7825ULL, 0x0000ffff03057812ULL, 0x000fe200078ec0ffULL,
0x0000002025067824ULL, 0x040fe400078e0206ULL, 0x00000020250a7824ULL, 0x000fe200078e020aULL,
0x0000888005077816ULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x000fc600078e00ffULL,
0x000000040a0a7819ULL, 0x000fe200000006ffULL, 0x8000000007057824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002810783bULL, 0x000fe80000000200ULL,
0x00000000060c783bULL, 0x0002a80000000200ULL, 0x000000002914783bULL, 0x000ee80000000200ULL,
0x000000002a18783bULL, 0x000f220000000200ULL, 0x0000001c08067810ULL, 0x002fc60007ffe0ffULL,
0x000000002b1c783bULL, 0x000e620000000200ULL, 0x0000000706067812ULL, 0x000fc600078e7825ULL,
0x000000002c20783bULL, 0x000fe40000000200ULL, 0x0000002025067824ULL, 0x000fe400078e0206ULL,
0x000000007c44783bULL, 0x000fe40000000200ULL, 0x0000001006067824ULL, 0x000fe400078e00ffULL,
0x000000007d4c783bULL, 0x000fe80000000200ULL, 0x000000009f9c783bULL, 0x000fe80000000200ULL,
0x00000000a528783bULL, 0x000fe20000000200ULL, 0x000000100c60723cULL, 0x044ff00000001860ULL,
0x000000120c70723cULL, 0x040fe20000001870ULL, 0x000000000a10783bULL, 0x000eae0000000200ULL,
0x000000140c6c723cULL, 0x048ff0000000186cULL, 0x000000160c30723cULL, 0x040fe20000001830ULL,
0x000000000614783bULL, 0x000fe80000000200ULL, 0x024614002d067984ULL, 0x000ee60000000800ULL,
0x000000180c34723cULL, 0x050ff00000001834ULL, 0x0000001a0c38723cULL, 0x040fe20000001838ULL,
0x00000000a018783bULL, 0x000f2e0000000200ULL, 0x0000001c0c3c723cULL, 0x042ff0000000183cULL,
0x0000001e0c48723cULL, 0x000fe20000001848ULL, 0x00000000a11c783bULL, 0x000fec0000000200ULL,
0x0000001e080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000201060723cULL, 0x004fe20000001860ULL,
0x00000000a308783bULL, 0x000e640000000200ULL, 0x000000070c0c7812ULL, 0x000fc400078e7825ULL,
0x8000000006ff7812ULL, 0x008fc60007804805ULL, 0x000000221070723cULL, 0x040fe20000001870ULL,
0x0000002025257824ULL, 0x000fe200078e020cULL, 0x00000000a720783bULL, 0x000fe80000000200ULL,
0x00000000a20c783bULL, 0x000ea20000000200ULL, 0x0000000425257819ULL, 0x000fe200000006ffULL,
0x00000044106c723cULL, 0x040fea000000186cULL, 0x000000002524783bULL, 0x000fe60000000200ULL,
0x000000461030723cULL, 0x040ff00000001830ULL, 0x0000004c1034723cULL, 0x040ff00000001834ULL,
0x0000004e1038723cULL, 0x040ff00000001838ULL, 0x0000009c103c723cULL, 0x040ff0000000183cULL,
0x0000009e1048723cULL, 0x000fe20000001848ULL, 0x00000000a410783bULL, 0x000eee0000000200ULL,
0x000000181460723cULL, 0x050ff00000001860ULL, 0x0000001a1470723cULL, 0x040fe20000001870ULL,
0x00000000a618783bULL, 0x000f2e0000000200ULL, 0x00000008146c723cULL, 0x042ff0000000186cULL,
0x0000000a1430723cULL, 0x040ff00000001830ULL, 0x0000000c1434723cULL, 0x044ff00000001834ULL,
0x0000000e1438723cULL, 0x040ff00000001838ULL, 0x0000001c143c723cULL, 0x040ff0000000183cULL,
0x0000001e1448723cULL, 0x000ff00000001848ULL, 0x000000102460723cULL, 0x048ff00000001860ULL,
0x000000122470723cULL, 0x040ff00000001870ULL, 0x00000020246c723cULL, 0x040ff0000000186cULL,
0x000000222430723cULL, 0x000fe20000001830ULL, 0x3d80000060607820ULL, 0x000fc40000410000ULL,
0x3d80000061617820ULL, 0x000fe40000410000ULL, 0x3d80000062627820ULL, 0x000fe40000410000ULL,
0x3d80000063637820ULL, 0x000fe20000410000ULL, 0x000000182434723cULL, 0x010fe20000001834ULL,
0x3d80000070707820ULL, 0x000fe40000410000ULL, 0x3d80000071717820ULL, 0x000fe40000410000ULL,
0x3d80000072727820ULL, 0x000fc40000410000ULL, 0x3d80000073737820ULL, 0x000fe20000410000ULL,
0x0000001a2438723cULL, 0x040fe20000001838ULL, 0x3d8000006c6c7820ULL, 0x000fe40000410000ULL,
0x3d8000006d6d7820ULL, 0x000fe40000410000ULL, 0x3d8000006e6e7820ULL, 0x000fe40000410000ULL,
0x3d8000006f6f7820ULL, 0x000fe20000410000ULL, 0x00000028243c723cULL, 0x000fe2000000183cULL,
0x3d80000030307820ULL, 0x000fc40000410000ULL, 0x3d80000031317820ULL, 0x000fe40000410000ULL,
0x3d80000032327820ULL, 0x000fe40000410000ULL, 0x3d80000033337820ULL, 0x000fe20000410000ULL,
0x0000002a2448723cULL, 0x000fe20000001848ULL, 0x3d80000034347820ULL, 0x000fe40000410000ULL,
0x3d80000035357820ULL, 0x000fe40000410000ULL, 0x3d80000036367820ULL, 0x000fc40000410000ULL,
0x3d80000037377820ULL, 0x000fe40000410000ULL, 0x3d80000038387820ULL, 0x000fe40000410000ULL,
0x3d80000039397820ULL, 0x000fe40000410000ULL, 0x3d8000003a3a7820ULL, 0x000fe40000410000ULL,
0x3d8000003b3b7820ULL, 0x000fe40000410000ULL, 0x3d8000003c3c7820ULL, 0x000fc40000410000ULL,
0x3d8000003d3d7820ULL, 0x000fe40000410000ULL, 0x3d8000003e3e7820ULL, 0x000fe40000410000ULL,
0x3d8000003f3f7820ULL, 0x000fe40000410000ULL, 0x3d80000048487820ULL, 0x000fe40000410000ULL,
0x3d80000049497820ULL, 0x000fe40000410000ULL, 0x3d8000004a4a7820ULL, 0x000fc40000410000ULL,
0x3d8000004b4b7820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000007077824ULL, 0x000fe400078e00ffULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500067305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x024614002d067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200197819ULL, 0x000fe200000006ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000027b00720cULL, 0x000fe40003f05270ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x000000807a187824ULL, 0x000fca00078e0205ULL, 0x0244000018087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000200057824ULL, 0x000fe400078e00ffULL,
0x00000001790d7824ULL, 0x000fc600078e0a04ULL, 0x0000000605057812ULL, 0x000fc800078ec0ffULL,
0x0000000105047812ULL, 0x040fe400078efcffULL, 0x0000000805067812ULL, 0x040fe400078efcffULL,
0x0000000d0400720cULL, 0x080fe40003f26070ULL, 0x0000001005047812ULL, 0x000fe400078efcffULL,
0x0000000d0600720cULL, 0x080fe40003f06070ULL, 0x0000000d0400720cULL, 0x000fc40003fc6070ULL,
0x0000001105067812ULL, 0x040fe400078efcffULL, 0x0000001805047812ULL, 0x040fe400078efcffULL,
0x0000000d0500720cULL, 0x0c0fe40003f46070ULL, 0x0000000d0600720cULL, 0x080fe40003fa6070ULL,
0x0000000d0400720cULL, 0x000fe40003f66070ULL, 0x0000000905077812ULL, 0x000fc400078efcffULL,
0x0000001905067812ULL, 0x040fe400078efcffULL, 0x0000002005047812ULL, 0x000fe400078efcffULL,
0xff7fffff62627808ULL, 0x000fe40005000000ULL, 0xff7fffff60607808ULL, 0x000fe40005000000ULL,
0xff7fffff63637808ULL, 0x000fe40004800000ULL, 0xff7fffff61617808ULL, 0x000fc40004800000ULL,
0x0000000d0700720cULL, 0x080fe40003f86070ULL, 0x0000000d0600720cULL, 0x080fe40003f46070ULL,
0x0000000d0400720cULL, 0x000fe40003f26070ULL, 0x0000002105067812ULL, 0x040fe400078efcffULL,
0x0000002805047812ULL, 0x000fe400078efcffULL, 0xff7fffff72727808ULL, 0x000fc40004000000ULL,
0xff7fffff70707808ULL, 0x000fe40004000000ULL, 0xff7fffff73737808ULL, 0x000fe40006000000ULL,
0xff7fffff71717808ULL, 0x000fe40006000000ULL, 0x0000000d0600720cULL, 0x080fe40003f06070ULL,
0x0000000d0400720cULL, 0x000fe40003f86070ULL, 0x0000002905067812ULL, 0x000fc400078efcffULL,
0x0000003005047812ULL, 0x000fe400078efcffULL, 0xff7fffff6e6e7808ULL, 0x000fe40007000000ULL,
0xff7fffff6c6c7808ULL, 0x000fe40007000000ULL, 0xff7fffff6f6f7808ULL, 0x000fe40006800000ULL,
0xff7fffff6d6d7808ULL, 0x000fe40006800000ULL, 0x0000000d0600720cULL, 0x000fc40003fc6070ULL,
0x0000000d0400720cULL, 0x000fe40003fa6070ULL, 0x0000003105067812ULL, 0x040fe400078efcffULL,
0x0000003805047812ULL, 0x040fe400078efcffULL, 0x0000003905057812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005800000ULL,
0xff7fffff33337808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40005000000ULL,
0xff7fffff36367808ULL, 0x000fe40004800000ULL, 0xff7fffff34347808ULL, 0x000fe40004800000ULL,
0x0000000d0600720cULL, 0x080fe40003f66070ULL, 0x0000000d0400720cULL, 0x000fc40003f46070ULL,
0x0000000d0500720cULL, 0x000fe40003f26070ULL, 0xff7fffff37377808ULL, 0x000fe40004000000ULL,
0xff7fffff35357808ULL, 0x000fe40004000000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40006000000ULL,
0xff7fffff38387808ULL, 0x000fe40006000000ULL, 0xff7fffff3b3b7808ULL, 0x000fc40007000000ULL,
0xff7fffff39397808ULL, 0x000fe40007000000ULL, 0xff7fffff3e3e7808ULL, 0x000fe40006800000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40006800000ULL, 0xff7fffff3f3f7808ULL, 0x000fe40005800000ULL,
0xff7fffff3d3d7808ULL, 0x000fe40005800000ULL, 0xff7fffff4a4a7808ULL, 0x000fc40005000000ULL,
0xff7fffff48487808ULL, 0x000fe40005000000ULL, 0xff7fffff4b4b7808ULL, 0x000fe40004800000ULL,
0xff7fffff49497808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006008087209ULL, 0x004fe40007810000ULL, 0x0000006209047209ULL, 0x000fe40007810000ULL,
0x0000006108057209ULL, 0x000fe40007810000ULL, 0x0000006304077209ULL, 0x000fc40007810000ULL,
0x0000007005047209ULL, 0x000fe40007810000ULL, 0x0000007207067209ULL, 0x000fe40007810000ULL,
0x0000007104057209ULL, 0x000fe40007810000ULL, 0x0000007306077209ULL, 0x000fe40007810000ULL,
0x0000006c05047209ULL, 0x000fe40007810000ULL, 0x0000006e07067209ULL, 0x000fc40007810000ULL,
0x0000006d04057209ULL, 0x000fe40007810000ULL, 0x0000006f06077209ULL, 0x000fe40007810000ULL,
0x0000003005047209ULL, 0x000fe40007810000ULL, 0x0000003207067209ULL, 0x000fe40007810000ULL,
0x0000003104057209ULL, 0x000fe40007810000ULL, 0x0000003306077209ULL, 0x000fc40007810000ULL,
0x0000003405047209ULL, 0x000fe40007810000ULL, 0x0000003607067209ULL, 0x000fe40007810000ULL,
0x0000003504057209ULL, 0x000fe40007810000ULL, 0x0000003706077209ULL, 0x000fe40007810000ULL,
0x0000003805047209ULL, 0x000fe40007810000ULL, 0x0000003a07067209ULL, 0x000fc40007810000ULL,
0x0000003904057209ULL, 0x000fe40007810000ULL, 0x0000003b06077209ULL, 0x000fe40007810000ULL,
0x0000003c05047209ULL, 0x000fe40007810000ULL, 0x0000003e07067209ULL, 0x000fe40007810000ULL,
0x0000003d04057209ULL, 0x000fe40007810000ULL, 0x0000003f06077209ULL, 0x000fc40007810000ULL,
0x0000004805047209ULL, 0x000fe40007810000ULL, 0x0000004a07067209ULL, 0x000fe40007810000ULL,
0x0000004904077209ULL, 0x000fe40007810000ULL, 0x0000004b060d7209ULL, 0x000fe20007810000ULL,
0x00000da27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x00000004070e7209ULL, 0x008fe20007810000ULL, 0x00000de27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a057f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b067f89ULL, 0x000f6200000e0000ULL, 0x000000040d077209ULL, 0x00efc60007810000ULL,
0x0c201f000e047f89ULL, 0x000e6200000e0000ULL, 0x000000050a087209ULL, 0x010fc60007810000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x000000060b1a7209ULL, 0x020fc60007810000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f001a1b7f89ULL, 0x00092200000e0000ULL,
0x000000040e047209ULL, 0x002fe40007810000ULL, 0x0000000c07057209ULL, 0x004fe40007810000ULL,
0x0000000908067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x3c003c0000227802ULL, 0x000fe20000000f00ULL, 0x3fb8aa3b05157820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b61617823ULL, 0x100fe20000010807ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b71717823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b60607823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b70707823ULL, 0x000fe20000010807ULL,
0x0000006100617308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b62627823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b63637823ULL, 0x100fe40000010815ULL, 0x3fb8aa3b72727823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b73737823ULL, 0x000fe20000010815ULL, 0x0000006000087308ULL, 0x000e620000000800ULL,
0x3c003c00ff237424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b6d6d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b6c6c7823ULL, 0x100fe20000010807ULL,
0x00000070000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b6e6e7823ULL, 0x100fe40000010815ULL, 0x3fb8aa3b6f6f7823ULL, 0x000fc40000010815ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010815ULL, 0x0000007100717308ULL, 0x000ee20000000800ULL,
0x000000086108723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b33337823ULL, 0x000fe40000010815ULL,
0x3fb8aa3b35357823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b39397823ULL, 0x100fe40000010807ULL,
0x0000006200097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b34347823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b38387823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010815ULL, 0x00000063001c7308ULL, 0x000e620000000800ULL,
0x0000000a710a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe40000010815ULL, 0x3fb8aa3b3c3c7823ULL, 0x000fc40000010807ULL,
0x00000072000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b48487823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010815ULL, 0x00000073001e7308ULL, 0x000ee20000000800ULL,
0x000000091c09723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b4a4a7823ULL, 0x000fc40000010815ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fe20000010815ULL, 0xfffffffc00157812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b49077823ULL, 0x000fe40000010807ULL, 0x0000006c000c7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x008fce00000000ffULL, 0x0000006d006d7308ULL, 0x000e620000000800ULL,
0x000000220824723cULL, 0x000fee00000018ffULL, 0x00000030000e7308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x0000000c6d0c723eULL, 0x002fce00000000ffULL,
0x0000006e000d7308ULL, 0x000ff00000000800ULL, 0x0000006f00207308ULL, 0x000e620000000800ULL,
0x0000000e310e723eULL, 0x008fce00000000ffULL, 0x00000032000f7308ULL, 0x000ff00000000800ULL,
0x00000033001c7308ULL, 0x000ee20000000800ULL, 0x0000000d200d723eULL, 0x002fe200000000ffULL,
0x0000000fff207424ULL, 0x000fca00078e00ffULL, 0x0000001520207219ULL, 0x000fe200000006ffULL,
0x0000003400107308ULL, 0x000fe60000000800ULL, 0x00000000201d73a1ULL, 0x000e6200000e8000ULL,
0x00000000200473c4ULL, 0x000f620000004000ULL, 0x0000000f1c0f723eULL, 0x008fc600000000ffULL,
0x0000003500357308ULL, 0x000ee80000000800ULL, 0x000000220c24723cULL, 0x000fe80000001824ULL,
0x0000003800127308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000f220000000800ULL,
0x000000103510723eULL, 0x008fc400000000ffULL, 0x0000000520ff7c12ULL, 0x002fca000f80401dULL,
0x0000003600117308ULL, 0x000ff00000000800ULL, 0x00000037001e7308ULL, 0x000e620000000800ULL,
0x000000123912723eULL, 0x010fce00000000ffULL, 0x0000003a00137308ULL, 0x000ff00000000800ULL,
0x0000003b001c7308ULL, 0x000ee20000000800ULL, 0x000000111e11723eULL, 0x002fce00000000ffULL,
0x0000003c00147308ULL, 0x000fe20000000800ULL, 0x000000131c13723eULL, 0x008fce00000000ffULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x000000221024723cULL, 0x000fee0000001824ULL,
0x0000004800167308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ee20000000800ULL,
0x000000143d14723eULL, 0x002fce00000000ffULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x000000160716723eULL, 0x008fe400000000ffULL,
0x0000001a1b077209ULL, 0x004fca0007810000ULL, 0x0000004a00177308ULL, 0x000ff00000000800ULL,
0x0000004b001c7308ULL, 0x000ea20000000800ULL, 0x0000003e3f15723eULL, 0x002fe400000000ffULL,
0x000000171c17723eULL, 0x004fce00000000ffULL, 0x000000221424723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000009f204008947ULL, 0x020fde000b800000ULL,
0x001c1fff241c7589ULL, 0x0002a400000e0000ULL, 0x00000000201b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000520ff7c12ULL, 0x008fda000f80401bULL, 0x00000a0204008947ULL, 0x010fea000b800000ULL,
0x001c1fff261d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1a7819ULL, 0x000fe40000011600ULL,
0x0000000c19377812ULL, 0x000fc400078ec0ffULL, 0x000000071a1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081a207824ULL, 0x04afe200078e00ffULL, 0x000000031a247819ULL, 0x040fe200000006ffULL,
0x000000081a337824ULL, 0x040fe200078e00ffULL, 0x0000001aff227212ULL, 0x000fe400078e33ffULL,
0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824217812ULL, 0x100fe400078ee21bULL,
0x0000000120237812ULL, 0x100fe200078ef61bULL, 0x000000081a477824ULL, 0x000fe200078e00ffULL,
0x0000000220257812ULL, 0x000fc400078ef61bULL, 0x0000000320277812ULL, 0x140fe400078ef61bULL,
0x0000000420297812ULL, 0x140fe400078ef61bULL, 0x00000005202b7812ULL, 0x140fe400078ef61bULL,
0x0000000620317812ULL, 0x000fe200078ef61bULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee222ULL, 0x0000001aff227212ULL, 0x000fc400078e33ffULL,
0x000000071a1b7812ULL, 0x040fe400078ec0ffULL, 0x000000031a247819ULL, 0x000fe400000006ffULL,
0x000120007a1a7811ULL, 0x000fe400078e58ffULL, 0xfffffff824357812ULL, 0x100fe400078ee21bULL,
0x0000000120397812ULL, 0x140fe200078ef61bULL, 0x0000001021197824ULL, 0x100fe200078e021aULL,
0x00000002203b7812ULL, 0x140fe200078ef61bULL, 0x0000001029247824ULL, 0x100fe200078e021aULL,
0x00000003203d7812ULL, 0x040fe200078ef61bULL, 0x0000000137197824ULL, 0x000fe200078e0219ULL,
0x00000004203f7812ULL, 0x140fe200078ef61bULL, 0x000000102b267824ULL, 0x100fe200078e021aULL,
0x0000000520437812ULL, 0x140fe200078ef61bULL, 0x00000010332a7824ULL, 0x100fe200078e021aULL,
0x0000000620457812ULL, 0x000fe200078ef61bULL, 0x00000010231b7824ULL, 0x000fe200078e021aULL,
0xfffffff847477812ULL, 0x000fe200078ee222ULL, 0x0000001027227824ULL, 0x000fe200078e021aULL,
0x0000001a25207211ULL, 0x080fe200078e20ffULL, 0x00000001371b7824ULL, 0x000fe200078e021bULL,
0x0000001a31287211ULL, 0x000fe200078e20ffULL, 0x0000000137237824ULL, 0x040fe200078e0222ULL,
0x0000002037217210ULL, 0x000fe20007ffe0ffULL, 0x00000010352c7824ULL, 0x000fe200078e021aULL,
0x0000001a39307211ULL, 0x000fe200078e20ffULL, 0x0000000137257824ULL, 0x000fe200078e0224ULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x000000103b317824ULL, 0x000fe200078e021aULL,
0x0000002837297210ULL, 0x040fe20007ffe0ffULL, 0x0000000137277824ULL, 0x000fe200078e0226ULL,
0x0000000a1b007388ULL, 0x0007e20000000800ULL, 0x000000103d327824ULL, 0x000fe200078e021aULL,
0x0000001a43347211ULL, 0x000fe200078e20ffULL, 0x00000001372b7824ULL, 0x000fe200078e022aULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000103f337824ULL, 0x000fe200078e021aULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x00000001372c7824ULL, 0x000fe200078e022cULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x0000001045357824ULL, 0x000fc400078e021aULL,
0x0000001047367824ULL, 0x000fe200078e021aULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x00000031371a7210ULL, 0x040fe20007ffe0ffULL,
0x0000000137327824ULL, 0x040fe200078e0232ULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x0000000137087824ULL, 0x042fe200078e0233ULL, 0x0000003537207210ULL, 0x040fe20007ffe0ffULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000137367824ULL, 0x000fc600078e0236ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000092c007388ULL, 0x0007e80000000800ULL, 0x0000000b30007388ULL, 0x0007e80000000800ULL,
0x0000000d1a007388ULL, 0x0007e80000000800ULL, 0x0000000f32007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001334007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001736007388ULL, 0x0007e80000000800ULL,
0x0240000418008388ULL, 0x0007e80000000c00ULL, 0x0242001c18008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000784100720cULL, 0x000fe20003f26070ULL,
0x024608002dff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff7b7224ULL, 0x000fc600078e0041ULL, 0x00000001ff037807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffa16000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000002000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fe200078e00ffULL, 0x0001520000087802ULL, 0x000fe20000000f00ULL,
0xffffffffff107424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e001bULL, 0xfffff20000007947ULL, 0x000fea000383ffffULL,
0x0000000d00077202ULL, 0x006fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001528000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fe400078e00ffULL, 0x0000059000007944ULL, 0x000fea0003c00000ULL,
0x0000001b0d067209ULL, 0x004fe20007810000ULL, 0x00000002ff0c7424ULL, 0x002fe200078e00ffULL,
0x0000000a00077202ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fe200078e00ffULL,
0x000152f000087802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x0000001b0a0a7209ULL, 0x004fe20007810000ULL,
0x00000002ff0c7424ULL, 0x002fe200078e00ffULL, 0x0000000b00077202ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fe200078e00ffULL, 0x0001536000087802ULL, 0x000fe20000000f00ULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x0000001b0b1a7209ULL, 0x004fe20007810000ULL, 0x00000001ff0c7424ULL, 0x002fe200078e00ffULL,
0x0000000e00077202ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fe200078e00ffULL,
0x000153d000087802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000001b0e047209ULL, 0x004fe20007810000ULL,
0x00000001ff0c7424ULL, 0x002fe200078e00ffULL, 0x0000000600077202ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fe200078e00ffULL, 0x0001544000087802ULL, 0x000fe20000000f00ULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000001b06057209ULL, 0x004fe20007810000ULL, 0x00000001ff0c7424ULL, 0x002fe200078e00ffULL,
0x0000000a00077202ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fe200078e00ffULL,
0x000154b000087802ULL, 0x000fe20000000f00ULL, 0xffffffffff107424ULL, 0x000fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x0000001b0a067209ULL, 0x004fe20007810000ULL,
0x00000001ff0c7424ULL, 0x002fe200078e00ffULL, 0x0000001a00077202ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fe200078e00ffULL, 0x0001552000087802ULL, 0x000fe20000000f00ULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xffffefe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0024ULL,
0x000000ff00227202ULL, 0x000fe20000000f00ULL, 0x00001c1fff237424ULL, 0x000fe200078e00ffULL,
0x00015580001a7802ULL, 0x000fc40000000f00ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e001fULL, 0xfffff5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x002fe200078e0026ULL, 0x000000ff00227202ULL, 0x000fe20000000f00ULL,
0x00001c1fff237424ULL, 0x000fe200078e00ffULL, 0x000155f0001a7802ULL, 0x000fc40000000f00ULL,
0x0000026000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff227224ULL, 0x002fe200078e00ffULL,
0x0000001f001d7202ULL, 0x004fe20000000f00ULL, 0x00001c1fff237424ULL, 0x000fe200078e00ffULL,
0x00015640001a7802ULL, 0x000fc40000000f00ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff227224ULL, 0x002fe200078e00ffULL, 0x00015690001a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff237424ULL, 0x000fc400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff53000007947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000003300038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff33ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000033047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003300037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000177802ULL, 0x000fc80000000f00ULL,
0xfffea7f016007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001000007348ULL, 0x000fe80003800000ULL, 0x0c00000c071b7389ULL, 0x0002a200000e001bULL,
0xfffea7b008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000002000007348ULL, 0x000fe80003800000ULL, 0x00000022211f7389ULL, 0x0002a200000e0023ULL,
0xfffea7701a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000024680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x000000000000045cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c44ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c78ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c98ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d08ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d20ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000015980ULL, 0xd600001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016880ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016890ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016890ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016d10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d08ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015b78ULL, 0x0000000000015b78ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016d10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_16_m_16_sm_80_cubin_len = 93680;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
