/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013c90ULL, 0x0000000000013810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000011d50ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000011ec0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000011f00ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000011f40ULL,
0x0000000000000140ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012080ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00011d5000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x0045ec0400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8b082880808a0828ULL, 0x2880809008288080ULL, 0x80b0082880809208ULL, 0x08288080d8082880ULL,
0x8082801628808084ULL, 0x0000000000031028ULL, 0x2880808492000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00011d5000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x90082880808b0828ULL,
0x2880809208288080ULL, 0x80d808288080b008ULL, 0x1628808088082880ULL, 0x0000031028808280ULL,
0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000010800000000ULL,
0x00011ec000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8b082880808a0828ULL, 0x2880809008288080ULL, 0x80b0082880809208ULL,
0x16288080d8082880ULL, 0x0000031028808280ULL, 0xd892000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000019800000000ULL, 0x00011f0000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8b082880808a0828ULL,
0x2880809008288080ULL, 0x80d8082880809208ULL, 0x16288080b0082880ULL, 0x0000031028808280ULL,
0xb092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000022800000000ULL,
0x00011f4000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL,
0x000812040000007aULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0000fff000000020ULL, 0x000104a000010490ULL, 0x0001062000010610ULL,
0x01c8290400010630ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500005c0500005cULL, 0x0500005c0500005cULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000d001c82804ULL, 0x000017f0000000f0ULL,
0x0000191000001870ULL, 0x00001d2000001940ULL, 0x00001dc000001d50ULL, 0x00002c0000001e30ULL,
0x00002c8000002c20ULL, 0x00003a6000002ce0ULL, 0x00003b9000003ae0ULL, 0x00003f7000003cb0ULL,
0x00003ff000003f90ULL, 0x00004bd000004050ULL, 0x00004c5000004bf0ULL, 0x000059b000004cb0ULL,
0x00005ae000005a30ULL, 0x00005ec000005c00ULL, 0x00005f4000005ee0ULL, 0x00006b2000005fa0ULL,
0x00006ba000006b40ULL, 0x0000790000006c00ULL, 0x00007a3000007980ULL, 0x00007e1000007b50ULL,
0x00007e9000007e30ULL, 0x00008aa000007ef0ULL, 0x00008b2000008ac0ULL, 0x0000935000008b80ULL,
0x00009ae000009360ULL, 0x0000b8f00000b630ULL, 0x0000be100000bde0ULL, 0x0000fed00000c650ULL,
0x0000ff100000ff00ULL, 0x0000ff400000ff20ULL, 0x0000ff800000ff60ULL, 0x000106000000ff90ULL,
0x0001067000010660ULL, 0x00010d9000010680ULL, 0x00010e4000010de0ULL, 0x00010f0000010ea0ULL,
0x00010fd000010f70ULL, 0x0001109000011040ULL, 0x00011140000110e0ULL, 0x000111f0000111a0ULL,
0x000112c000011260ULL, 0x0001138000011330ULL, 0x00011430000113d0ULL, 0x000114e000011490ULL,
0x000115b000011550ULL, 0x0001167000011620ULL, 0x00011720000116c0ULL, 0x000117d000011780ULL,
0x000118a000011840ULL, 0x0001197000011910ULL, 0x00011a20000119d0ULL, 0x00011ac000011a70ULL,
0x00011b6000011b10ULL, 0x00011c1000011bb0ULL, 0x00011cd000011c80ULL, 0x0700390400011d20ULL,
0x000000ff000001e0ULL, 0x003f010000010600ULL, 0x0000000500000240ULL, 0x003f012000010608ULL,
0x00000005000002f0ULL, 0x003f012000010688ULL, 0x0000000500000390ULL, 0x003f0120000106a8ULL,
0x000000ff000003d0ULL, 0x003f0100000106b8ULL, 0x000000ff000004f0ULL, 0x003f010700010600ULL,
0x0000002500000690ULL, 0x003f01020001068cULL, 0x0000002500000740ULL, 0x003f010100010688ULL,
0x000000ff00000c70ULL, 0x003f0107000106a8ULL, 0x000000ff00000cf0ULL, 0x003f0101000106a8ULL,
0x000000ff00000d50ULL, 0x003f0101000106b8ULL, 0x000000ff00000ec0ULL, 0x003f0105000106bcULL,
0x000000ff00000f10ULL, 0x003f0105000106bcULL, 0x000000ff00000f90ULL, 0x003f0105000106bcULL,
0x000000ff00001560ULL, 0x003f0107000106b0ULL, 0x000000ff000015e0ULL, 0x003f0101000106b0ULL,
0x000000ff000015f0ULL, 0x003f0105000106acULL, 0x0000002500001660ULL, 0x003f010100010608ULL,
0x0000002500001680ULL, 0x003f01050001060cULL, 0x0000002500001710ULL, 0x003f01050001060cULL,
0x000000ff00001c00ULL, 0x003f0105000106acULL, 0x000000ff00001c80ULL, 0x003f0105000106acULL,
0x000000ff00002520ULL, 0x003f0101000106b8ULL, 0x000000ff00002530ULL, 0x003f0105000106bcULL,
0x000000ff00002580ULL, 0x003f0105000106bcULL, 0x000000ff00002600ULL, 0x003f0105000106bcULL,
0x000000ff00002a00ULL, 0x003f0107000106a8ULL, 0x000000ff00002a80ULL, 0x003f0101000106a8ULL,
0x000000ff00002a90ULL, 0x003f0105000106b4ULL, 0x000000ff00002af0ULL, 0x003f0105000106b4ULL,
0x000000ff00002b70ULL, 0x003f0105000106b4ULL, 0x000000ff000032e0ULL, 0x003f0101000106b8ULL,
0x000000ff00003350ULL, 0x003f010100010688ULL, 0x000000ff00003380ULL, 0x003f0105000106bcULL,
0x000000ff000033d0ULL, 0x003f0105000106bcULL, 0x000000ff00003450ULL, 0x003f0105000106bcULL,
0x000000ff00003820ULL, 0x003f0107000106b0ULL, 0x000000ff000038a0ULL, 0x003f0101000106b0ULL,
0x000000ff000038b0ULL, 0x003f0105000106acULL, 0x0000002500003920ULL, 0x003f010100010628ULL,
0x0000002500003940ULL, 0x003f01050001062cULL, 0x00000025000039d0ULL, 0x003f01050001062cULL,
0x000000ff00003e60ULL, 0x003f0105000106acULL, 0x000000ff00003ee0ULL, 0x003f0105000106acULL,
0x000000ff000045e0ULL, 0x003f0101000106b8ULL, 0x000000ff000045f0ULL, 0x003f0105000106bcULL,
0x000000ff00004640ULL, 0x003f0105000106bcULL, 0x000000ff000046c0ULL, 0x003f0105000106bcULL,
0x000000ff000049d0ULL, 0x003f0107000106a8ULL, 0x000000ff00004a50ULL, 0x003f0101000106a8ULL,
0x000000ff00004a60ULL, 0x003f0105000106b4ULL, 0x000000ff00004ac0ULL, 0x003f0105000106b4ULL,
0x000000ff00004b40ULL, 0x003f0105000106b4ULL, 0x000000ff00005230ULL, 0x003f0101000106b8ULL,
0x000000ff000052a0ULL, 0x003f010100010690ULL, 0x000000ff000052d0ULL, 0x003f0105000106bcULL,
0x000000ff00005320ULL, 0x003f0105000106bcULL, 0x000000ff000053a0ULL, 0x003f0105000106bcULL,
0x000000ff00005770ULL, 0x003f0107000106b0ULL, 0x000000ff000057f0ULL, 0x003f0101000106b0ULL,
0x000000ff00005800ULL, 0x003f0105000106acULL, 0x0000002500005870ULL, 0x003f010100010648ULL,
0x0000002500005890ULL, 0x003f01050001064cULL, 0x0000002500005920ULL, 0x003f01050001064cULL,
0x000000ff00005db0ULL, 0x003f0105000106acULL, 0x000000ff00005e30ULL, 0x003f0105000106acULL,
0x000000ff00006530ULL, 0x003f0101000106b8ULL, 0x000000ff00006540ULL, 0x003f0105000106bcULL,
0x000000ff00006590ULL, 0x003f0105000106bcULL, 0x000000ff00006610ULL, 0x003f0105000106bcULL,
0x000000ff00006920ULL, 0x003f0107000106a8ULL, 0x000000ff000069a0ULL, 0x003f0101000106a8ULL,
0x000000ff000069b0ULL, 0x003f0105000106b4ULL, 0x000000ff00006a10ULL, 0x003f0105000106b4ULL,
0x000000ff00006a90ULL, 0x003f0105000106b4ULL, 0x000000ff00007180ULL, 0x003f0101000106b8ULL,
0x000000ff000071f0ULL, 0x003f010100010698ULL, 0x000000ff00007220ULL, 0x003f0105000106bcULL,
0x000000ff00007270ULL, 0x003f0105000106bcULL, 0x000000ff000072f0ULL, 0x003f0105000106bcULL,
0x000000ff000076c0ULL, 0x003f0107000106b0ULL, 0x000000ff00007740ULL, 0x003f0101000106b0ULL,
0x000000ff00007750ULL, 0x003f0105000106acULL, 0x00000025000077c0ULL, 0x003f010100010668ULL,
0x00000025000077e0ULL, 0x003f01050001066cULL, 0x0000002500007870ULL, 0x003f01050001066cULL,
0x000000ff00007d00ULL, 0x003f0105000106acULL, 0x000000ff00007d80ULL, 0x003f0105000106acULL,
0x000000ff00008480ULL, 0x003f0101000106b8ULL, 0x000000ff00008490ULL, 0x003f0105000106bcULL,
0x000000ff000084e0ULL, 0x003f0105000106bcULL, 0x000000ff00008560ULL, 0x003f0105000106bcULL,
0x000000ff000088a0ULL, 0x003f0107000106a8ULL, 0x000000ff00008920ULL, 0x003f0101000106a8ULL,
0x000000ff00008930ULL, 0x003f0105000106b4ULL, 0x000000ff00008990ULL, 0x003f0105000106b4ULL,
0x000000ff00008a10ULL, 0x003f0105000106b4ULL, 0x000000ff00009100ULL, 0x003f0101000106b8ULL,
0x000000ff00009160ULL, 0x003f0101000106a0ULL, 0x000000ff0000c990ULL, 0x003f010100010600ULL,
0x000000ff0000d790ULL, 0x003f010500010604ULL, 0x000000ff0000d830ULL, 0x003f010500010604ULL,
0x000000ff0000db50ULL, 0x003f010100010600ULL, 0x000000ff0000db60ULL, 0x003f010500010604ULL,
0x000000ff0000dbf0ULL, 0x003f010500010604ULL, 0x0000002d0000f330ULL, 0x003f010100000000ULL,
0x0000002d0000f370ULL, 0x003f010500000004ULL, 0x0000002d0000f7d0ULL, 0x003f010500000004ULL,
0x0000002f00010bf0ULL, 0x003f010100000000ULL, 0x0000002f00010c50ULL, 0x003f010100000008ULL,
0x0000002f00010cb0ULL, 0x003f010100000010ULL, 0x0000002f00010d20ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0000dc500000c8a0ULL, 0x00010d600000dd00ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000002a4ULL, 0x0000001200000002ULL, 0x0000000000000214ULL,
0x0000001200000002ULL, 0x0000000000000184ULL, 0x0000001200000002ULL, 0x00000000000000f4ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000027eULL,
0x0000001200000002ULL, 0x00000000000001eeULL, 0x0000001200000002ULL, 0x000000000000015eULL,
0x0000001200000002ULL, 0x00000000000000cbULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000027919ULL, 0x000ea20000002300ULL, 0x0000000304057899ULL, 0x000fe4000800063fULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000077919ULL, 0x000f280000000000ULL, 0x0000000000637919ULL, 0x000f680000002600ULL,
0x0000000000047919ULL, 0x000f220000002700ULL, 0x00000005ff2c7819ULL, 0x002fc60000011605ULL,
0x00000000002b7919ULL, 0x000e680000000000ULL, 0x00001fff020f7589ULL, 0x0045e200000e0000ULL,
0x0000000102007824ULL, 0x008fc600078e0203ULL, 0x00001fff2c2c7589ULL, 0x000ee200000e0000ULL,
0x0000008000057824ULL, 0x000fe400078e0205ULL, 0x0000001300007300ULL, 0x000f2600000e0000ULL,
0x000000ff0500720cULL, 0x040fe40003f25270ULL, 0x0000000f0500780cULL, 0x040fe40003f44070ULL,
0x0000007f0500780cULL, 0x040fe20003f84070ULL, 0x0000001300137309ULL, 0x000f620000000000ULL,
0x000000030500780cULL, 0x000fe20003f64070ULL, 0x000000102b0e7824ULL, 0x002fe200078e00ffULL,
0x000000070000720cULL, 0x010fca0003f02070ULL, 0x3fffff80ff029424ULL, 0x004fe400078e00ffULL,
0x000000040f007824ULL, 0x008fe400078e022cULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x0000000200007824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x00000008000b7817ULL, 0x040fe20007800000ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0x0000000100107810ULL, 0x000fe20007ffe0ffULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x010608060500a388ULL, 0x0005e20000008a00ULL, 0x000000010500780cULL, 0x000fe20003f44070ULL,
0x000000010b0a7824ULL, 0x100fe200078e0a00ULL, 0x0000000710127812ULL, 0x000fe200078ec0ffULL,
0x00000008630b7824ULL, 0x020fe200078e00ffULL, 0x0000000700027812ULL, 0x002fe200078ec0ffULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x0104000c0500c388ULL, 0x0003e20000004800ULL,
0x00000005040b7c24ULL, 0x000fe2000f8e020bULL, 0x0000001f02037812ULL, 0x100fe200078e782bULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x010688080500b388ULL, 0x0007e20000008a00ULL,
0x000000ff0a00720cULL, 0x040fe20003f63070ULL, 0x000000010b027824ULL, 0x040fe200078e0200ULL,
0x000000010a00780cULL, 0x000fe20003f83070ULL, 0x000000010b067824ULL, 0x004fe200078e0210ULL,
0x0000001f12117812ULL, 0x000fe200078e782bULL, 0x3fffff00ff0aa424ULL, 0x000fc400078e00ffULL,
0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0c9424ULL, 0x002fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a80a0500a388ULL, 0x0003e20000008a00ULL,
0x0000002000007824ULL, 0x000fe200078e0203ULL, 0x000001f00e097812ULL, 0x008fe200078ec0ffULL,
0x00005c0002027625ULL, 0x080fe200078e0007ULL, 0x0106b80cff009388ULL, 0x0005e60000000a00ULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000902087210ULL, 0x000fc40007fbe0ffULL, 0x0000002010107824ULL, 0x000fe200078e0211ULL,
0x0000000906067210ULL, 0x000fe20007f5e0ffULL, 0x0000001000117824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe400028e0603ULL, 0x000000ffff007224ULL, 0x000fe400078e0a13ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001010137824ULL, 0x000fc400078e00ffULL,
0x00000004ff057424ULL, 0x002fc800078e00ffULL, 0x0000620004027625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0005e8000d901c46ULL,
0x0000000006137faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01060400ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006022a7981ULL, 0x000ee2000c1e1900ULL,
0x00000000000579c3ULL, 0x000e620000002500ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000005ff297e24ULL, 0x002fe2000f8e00ffULL, 0x0000003f2a287810ULL, 0x008fc40007ffe0ffULL,
0x000000ff2a277810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff287819ULL, 0x000fe40000011628ULL,
0x00000008ff277819ULL, 0x000fca0000011627ULL, 0x0000c2b000008947ULL, 0x000fea0003800000ULL,
0x0000000429267824ULL, 0x000fe400078e00ffULL, 0x000000082c257824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x004fe200078e00ffULL, 0x000000282600720cULL, 0x000fe20003f06070ULL,
0xffffffffff247424ULL, 0x000fd800078e00ffULL, 0x0000640026038a10ULL, 0x000fe20007ffe0ffULL,
0x0000000204008824ULL, 0x000fc800078e00ffULL, 0x0000640000038a24ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0625ff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602248981ULL, 0x0004e2000c1e1900ULL, 0x00000004ff067819ULL, 0x002fe2000001162bULL,
0x0000010029057824ULL, 0x040fe200078e00ffULL, 0x0000000129007810ULL, 0x000fe20007ffe0ffULL,
0x0106880025ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000206077810ULL, 0x040fe20007ffe0ffULL,
0xff317217ff237424ULL, 0x000fe200078e00ffULL, 0x00000004060b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000000270000720cULL, 0x000fe20003f06070ULL,
0x0000000125087824ULL, 0x040fe200078e0207ULL, 0x000000052a007217ULL, 0x000fe20007800000ULL,
0x00000001250c7824ULL, 0x040fe200078e020bULL, 0x00000006060d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000007080a7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000070c027812ULL, 0x004fe200078ec0ffULL,
0x0000000125057824ULL, 0x040fe200078e020dULL, 0x0000000f0a037812ULL, 0x000fe200078e782bULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000f00e117812ULL, 0x000fe200078ec0ffULL,
0x0000001008097824ULL, 0x000fe200078e0203ULL, 0x0000000f02037812ULL, 0x000fe200078e782bULL,
0x0000000125087824ULL, 0x000fe200078e0206ULL, 0x0000000705027812ULL, 0x000fe200078ec0ffULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x00000007080a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000f02107812ULL, 0x100fe200078e782bULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000000f0a037812ULL, 0x000fe200078e782bULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x0000000025027217ULL, 0x000fe20007800000ULL,
0x0000001005107824ULL, 0x000fc400078e0210ULL, 0x0000001008057824ULL, 0x000fe400078e0203ULL,
0x0000000102027824ULL, 0x000fe400078e0a25ULL, 0x0000004063037824ULL, 0x000fe200078e0208ULL,
0x0000c00005057811ULL, 0x000fe400078e20ffULL, 0x000000020700720cULL, 0x080fe40003f46070ULL,
0x0000000203077810ULL, 0x000fe40007ffe0ffULL, 0x000000020b00720cULL, 0x000fc40003f06070ULL,
0x00000004030b7810ULL, 0x000fe40007ffe0ffULL, 0x000000020600720cULL, 0x000fe20003f26070ULL,
0x0000580024007a24ULL, 0x008fc800078e02ffULL, 0x0000004000007824ULL, 0x000fca00078e00ffULL,
0x0000000300137210ULL, 0x040fe40007f7e0ffULL, 0x00000007000f7210ULL, 0x000fe40007f9e0ffULL,
0x0000000603037810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078640ffULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x00005e000f077a11ULL, 0x000fe400078840ffULL, 0x00005f0013137a11ULL, 0x000fc400018f4408ULL,
0x0000000b000b7210ULL, 0x040fe40007f7e0ffULL, 0x0000000300007210ULL, 0x000fe40007fbe0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200020f4406ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005e000b087a11ULL, 0x000fe200078840ffULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x00005e00000a7a11ULL, 0x000fe400078a40ffULL, 0x000000020d00720cULL, 0x000fc40003f66070ULL,
0x00005f000b0b7a11ULL, 0x000fe400020f4406ULL, 0x0000001211027210ULL, 0x000fe40007f9e0ffULL,
0x00005f0000007a11ULL, 0x000fe400028f4403ULL, 0x0000001107067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff037224ULL, 0x000fe200020e0613ULL, 0x0000001108087210ULL, 0x080fe40007f9e0ffULL,
0x0000c000090d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e060fULL,
0x000000110a0a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200020e060bULL,
0x0000c0000c0f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c46ULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fc400028e0600ULL, 0x00000000060d7faeULL, 0x0003e8000d101c46ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x000000272900720cULL, 0x000fc60003f06070ULL,
0x000000000a117faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff027f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x000083c000000947ULL, 0x000fea0003800000ULL,
0x000000042c607824ULL, 0x000fe400078e00ffULL, 0x0000000204047824ULL, 0x000fc400078e00ffULL,
0x00006400ff217624ULL, 0x000fe200078e00ffULL, 0x0000000260617810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff627224ULL, 0x002fe400078e0003ULL, 0x000000ffff317224ULL, 0x004fe400078e0007ULL,
0x0000640004217624ULL, 0x000fe400078e0221ULL, 0xff317217ff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fc400078e00ffULL, 0x0000010029037824ULL, 0x000fca00078e00ffULL,
0x0000002a0300720cULL, 0x000fda0003f06070ULL, 0x000082c000000947ULL, 0x002fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000326027812ULL, 0x000fe200078ec0ffULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x0000580024047a24ULL, 0x000fe200078e02ffULL,
0x000000030200780cULL, 0x000fe20003f05270ULL, 0xfffffffd05007424ULL, 0x000fe200078e0200ULL,
0x00000004ff067819ULL, 0x000fe2000001162bULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0x0000000100037807ULL, 0x000fca0004000000ULL, 0x0000000126267824ULL, 0x000fca00078e0203ULL,
0x000000282600720cULL, 0x000fe20003f06070ULL, 0x0000000125697824ULL, 0x000fe200078e0206ULL,
0x00000020631c7811ULL, 0x000fe200078e30ffULL, 0x00000040040b7824ULL, 0x000fc600078e00ffULL,
0x0000000769087812ULL, 0x040fe200078ec0ffULL, 0x0000000169207824ULL, 0x000fcc00078e021cULL,
0x0000000126028824ULL, 0x000fc800078e0221ULL, 0x0000600002028625ULL, 0x000fe200078e0005ULL,
0x0000000f08087812ULL, 0x000fe400078e782bULL, 0x00000004062d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000602248981ULL, 0x000362000c1e1900ULL, 0x0000000129007810ULL, 0x000fe20007ffe0ffULL,
0x0000001069697824ULL, 0x000fe200078e0208ULL, 0x0000002029057811ULL, 0x000fe200078e40ffULL,
0x00000001251d7824ULL, 0x000fe200078e022dULL, 0x000000270000720cULL, 0x000fe20003f06070ULL,
0x000000102b167824ULL, 0x000fe200078e00ffULL, 0x00000006061f7810ULL, 0x000fc40007ffe0ffULL,
0x000000052a007217ULL, 0x000fe40007800000ULL, 0x000000200b037210ULL, 0x002fe20007f3e0ffULL,
0x0000000125077824ULL, 0x000fe200078e021fULL, 0x00000002062e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000f0161b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0003087a11ULL, 0x000fe200078240ffULL,
0x0000000125057824ULL, 0x000fe200078e022eULL, 0x00000007070a7812ULL, 0x000fc400078ec0ffULL,
0x00005f0003037a11ULL, 0x000fe200008f4402ULL, 0x00000001051e7824ULL, 0x000fe200078e021cULL,
0x000000071d027812ULL, 0x000fe400078ec0ffULL, 0x0000002000007807ULL, 0x000fe40000000000ULL,
0x0000000f02027812ULL, 0x100fe400078e782bULL, 0x0000000705047812ULL, 0x000fe400078ec0ffULL,
0x0000000f0a0a7812ULL, 0x100fe200078e782bULL, 0x000000101d677824ULL, 0x000fe200078e0202ULL,
0x0000000025007217ULL, 0x000fe20007800000ULL, 0x000000011d1d7824ULL, 0x100fe200078e021cULL,
0x0000000f04047812ULL, 0x000fe200078e782bULL, 0x00000001071c7824ULL, 0x000fe200078e021cULL,
0x0000001e0b097210ULL, 0x000fe20007f5e0ffULL, 0x0000001007687824ULL, 0x000fe200078e020aULL,
0x0000001d0b077210ULL, 0x000fe20007f7e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a25ULL,
0x0000e000691a7811ULL, 0x000fe200078e20ffULL, 0x00000010055f7824ULL, 0x000fe200078e0204ULL,
0x0000e00067187811ULL, 0x000fe200078e20ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00090a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff027224ULL, 0x000fe200018e06ffULL,
0x000000000600720cULL, 0x000fc40003f26070ULL, 0x00005e0007067a11ULL, 0x000fe400078640ffULL,
0x00005f0009097a11ULL, 0x000fe400010f4404ULL, 0x0000001c0b047210ULL, 0x000fe40007f9e0ffULL,
0x00005f0007077a11ULL, 0x000fe400018f4402ULL, 0x0000001b08027210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x00005e0004087a11ULL, 0x000fc400078a40ffULL,
0x000000002d00720cULL, 0x080fe20003f66070ULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x000000002e00720cULL, 0x080fe40003f46070ULL, 0x000000001f00720cULL, 0x000fe40003f86070ULL,
0x00005f0004007a11ULL, 0x000fe200028f4405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021a7faeULL, 0x0003e2000c901c46ULL, 0x0000001b0a047210ULL, 0x080fe40007fbe0ffULL,
0x0000001b06067210ULL, 0x000fc40007f3e0ffULL, 0x0000e0005f197811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200028e0609ULL, 0x0000001b08087210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000e00068177811ULL, 0x000fe400078e20ffULL,
0x0000000004197faeULL, 0x0003e2000d101c46ULL, 0x000000ffff097224ULL, 0x000fc600028e0600ULL,
0x0000000006187faeULL, 0x0003e8000d901c46ULL, 0x0000000008177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff027f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff077984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080025047f8cULL, 0x000fe2000c80043fULL, 0x8000000007ff7812ULL, 0x004fc60007844862ULL,
0x01060c0025097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007824805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000060000735dULL, 0x008fe20003800000ULL, 0x01060c0025077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc40007824805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe2000001162bULL, 0xffffffffff647424ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe400078ec0ffULL, 0x0000000c00057812ULL, 0x000fca00078ec0ffULL,
0x0000000116167824ULL, 0x000fca00078e0205ULL, 0x0100000016007984ULL, 0x000ea80000000800ULL,
0x0102000016047984ULL, 0x0007220000000800ULL, 0x000000230000720bULL, 0x004fe20003f3d000ULL,
0x0000f5827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x008fc800008e0100ULL,
0x0000ffff05077812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff2c00720cULL, 0x000fe40003f65270ULL, 0x000000230000720bULL, 0x000fe20003f34000ULL,
0x0000f5527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x000fe400008e0100ULL,
0x0000000023097209ULL, 0x000fe40007810000ULL, 0x0000ffff05087812ULL, 0x000fe400078e3cffULL,
0x00000002ff5e7819ULL, 0x000fe2000001162bULL, 0x010400091600b388ULL, 0x0005e20000000800ULL,
0x8000000923067221ULL, 0x000fe20000010000ULL, 0x0000000807ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x00000006005b7308ULL, 0x0004e20000000800ULL,
0x0000f5027f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b057589ULL, 0x0086a400000e0000ULL,
0x000000085e5e7810ULL, 0x00afe20007ffe0ffULL, 0x0000f5327f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b5a7589ULL, 0x0002e400000e0000ULL, 0x8000000900001221ULL, 0x100fe20000010000ULL,
0x0000005b22227220ULL, 0x000fe20000410000ULL, 0x0000005a4b4b7220ULL, 0x08cfe20000410000ULL,
0x0000005a4a4a7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00001820ULL, 0x000fe20000410000ULL,
0x0000005a47477220ULL, 0x080fe20000410000ULL, 0x0000005a46467220ULL, 0x080fe20000410000ULL,
0x0000005a43437220ULL, 0x080fe20000410000ULL, 0x0000000000151308ULL, 0x000ea20000000800ULL,
0x0000005a42427220ULL, 0x080fe20000410000ULL, 0x0000005a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000005a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005a37377220ULL, 0x080fe20000410000ULL,
0x0000005a36367220ULL, 0x080fe20000410000ULL, 0x0000005a57577220ULL, 0x080fe20000410000ULL,
0x0000005a56567220ULL, 0x080fe20000410000ULL, 0x0000005a53537220ULL, 0x080fe20000410000ULL,
0x0000005a52527220ULL, 0x000fe20000410000ULL, 0x00000001ff0c7807ULL, 0x000fe20000800000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000541417220ULL, 0x080fe20000410000ULL, 0x0000000540407220ULL, 0x080fe20000410000ULL,
0x000000053d3d7220ULL, 0x080fe20000410000ULL, 0x000000053c3c7220ULL, 0x080fe20000410000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000555557220ULL, 0x080fe20000410000ULL, 0x0000000554547220ULL, 0x080fe20000410000ULL,
0x0000000551517220ULL, 0x080fe20000410000ULL, 0x0000000550507220ULL, 0x000fe20000410000ULL,
0x000000ffff237224ULL, 0x000fe200078e0009ULL, 0x0000001504041220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002204227221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fc40007824862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000040000735dULL, 0x008fe20003800000ULL,
0x0106ac00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007824862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff00723eULL, 0x000fe400000000ffULL,
0x00000004ff077819ULL, 0x000fc4000001162bULL, 0x00000002ff047819ULL, 0x000fe4000001162bULL,
0x00005410005b7816ULL, 0x002fe20000000000ULL, 0x0000f1a27f007947ULL, 0x000fea000b800000ULL,
0x00001f045b0d7589ULL, 0x0002a400000e0000ULL, 0x00000008042f7810ULL, 0x000fe20007ffe0ffULL,
0x0000f1e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b007589ULL, 0x00072400000e0000ULL,
0x0000001004667810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0066ULL, 0x00001dd000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0001013000007944ULL, 0x03cfea0003c00000ULL, 0x0000001804657810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0065ULL,
0x00001e4000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000100c000007944ULL, 0x03cfea0003c00000ULL,
0x000000082b047812ULL, 0x042fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000072b6c7812ULL, 0x040fe400078ec0ffULL, 0x000000602b057211ULL, 0x000fe400078fe0ffULL,
0x0000000704107812ULL, 0x100fe400078ec82bULL, 0x000000086c6c7812ULL, 0x100fe400078ef82bULL,
0x00000007040e7812ULL, 0x000fc400078ef82bULL, 0x00000005100f7212ULL, 0x000fe400078e3cffULL,
0x0000000707057812ULL, 0x000fe400078e786cULL, 0x000000612b117211ULL, 0x000fe200078fe0ffULL,
0x000000100e6d7824ULL, 0x000fe200078e020fULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x000000086c147824ULL, 0x000fe200078e0205ULL, 0x0000001110117212ULL, 0x000fe400078e3cffULL,
0x0000c0006d137811ULL, 0x000fc400078e20ffULL, 0x0000a00014047811ULL, 0x000fe200078e20ffULL,
0x000000100e6b7824ULL, 0x000fe200078e0211ULL, 0x000000ff0c00720cULL, 0x000fe20003f25270ULL,
0x000000001308783bULL, 0x000e620000004200ULL, 0x000001000e0e7811ULL, 0x000fe400078e20ffULL,
0x0000c0006b127811ULL, 0x000fe200078e20ffULL, 0x000000000404783bULL, 0x000ee40000000200ULL,
0x00000001116a7824ULL, 0x100fe400078e020eULL, 0x00000000124c783bULL, 0x000f220000004200ULL,
0x000000010f6e7824ULL, 0x000fc400078e020eULL, 0x0000c0006a107811ULL, 0x000fc600078e20ffULL,
0x0000c0006e0f7811ULL, 0x000fe400078e20ffULL, 0x0000312008087816ULL, 0x002fe400000000ffULL,
0x0000312009097816ULL, 0x000fe400000000ffULL, 0x00000008ff30723eULL, 0x080fe200020006ffULL,
0x0000000d04049232ULL, 0x08cfe20000000000ULL, 0x00000009ff31723eULL, 0x080fe200020006ffULL,
0x0000000d06069232ULL, 0x000fe20000000000ULL, 0x00000008ff08723eULL, 0x000fe200030006ffULL,
0x0000000005059232ULL, 0x090fe20000000000ULL, 0x00000009ff09723eULL, 0x000fe200030006ffULL,
0x0000000007079232ULL, 0x000fe20000000000ULL, 0x000031200a0c7816ULL, 0x000fc400000000ffULL,
0x000031200b597816ULL, 0x000fe400000000ffULL, 0x0000000cff58723eULL, 0x080fe400030006ffULL,
0x000000080454723cULL, 0x040fe20000001854ULL, 0x000031204c4c7816ULL, 0x000fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204f0e7816ULL, 0x000fe400000000ffULL,
0x000000072e097812ULL, 0x000fe200078e786cULL, 0x000000300450723cULL, 0x000fe20000001850ULL,
0x0000000cff08723eULL, 0x000fc400020006ffULL, 0x000031204e0c7816ULL, 0x000fe200000000ffULL,
0x000000086c117824ULL, 0x000fe200078e0209ULL, 0x00000059ff09723eULL, 0x080fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400030006ffULL, 0x0000a00011307811ULL, 0x000fc600078e20ffULL,
0x000000080434723cULL, 0x040fe20000001834ULL, 0x000000001008783bULL, 0x000e680000004200ULL,
0x000000003030783bULL, 0x000ea60000000200ULL, 0x000000580438723cULL, 0x000fee0000001838ULL,
0x0000004cff58723eULL, 0x000fc400020006ffULL, 0x0000004dff59723eULL, 0x080fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x00000058043c723cULL, 0x040fee000000183cULL, 0x0000000cff58723eULL, 0x000fe200020006ffULL,
0x0000004c0440723cULL, 0x000fe20000001840ULL, 0x000000000f4c783bULL, 0x000ee20000004200ULL,
0x0000000eff59723eULL, 0x000fce00020006ffULL, 0x000000580444723cULL, 0x000fe20000001844ULL,
0x0000312008087816ULL, 0x002fe400000000ffULL, 0x0000312009097816ULL, 0x000fe200000000ffULL,
0x0000000d30309232ULL, 0x084fe20000000000ULL, 0x000031200a0a7816ULL, 0x000fe200000000ffULL,
0x0000000d32329232ULL, 0x000fe20000000000ULL, 0x0000000cff58723eULL, 0x000fe200030006ffULL,
0x0000000031319232ULL, 0x080fe20000000000ULL, 0x00000008ff0c723eULL, 0x000fe200020006ffULL,
0x0000000033339232ULL, 0x000fe20000000000ULL, 0x00000009ff0d723eULL, 0x000fc400020006ffULL,
0x00000008ff08723eULL, 0x000fe400030006ffULL, 0x00000009ff09723eULL, 0x000fe400030006ffULL,
0x0000000eff59723eULL, 0x000fe200030006ffULL, 0x0000000c303c723cULL, 0x000fe2000000183cULL,
0x000031200b0b7816ULL, 0x000fce00000000ffULL, 0x000000083040723cULL, 0x000fe20000001840ULL,
0x000031204c4c7816ULL, 0x008fcc00000000ffULL, 0x0000000aff08723eULL, 0x080fe200020006ffULL,
0x000000580404723cULL, 0x000fe20000001848ULL, 0x0000000bff09723eULL, 0x000fe400020006ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204e4e7816ULL, 0x000fe400000000ffULL,
0x000031204f4f7816ULL, 0x000fe200000000ffULL, 0x000000083044723cULL, 0x000fe20000001844ULL,
0x0000000aff0a723eULL, 0x000fc400030006ffULL, 0x0000000bff0b723eULL, 0x000fc800030006ffULL,
0x0000004cff08723eULL, 0x080fe400020006ffULL, 0x0000004dff09723eULL, 0x080fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000083050723cULL, 0x040fee0000001850ULL, 0x0000004eff08723eULL, 0x080fe200020006ffULL,
0x0000004c3054723cULL, 0x000fe20000001854ULL, 0x0000004fff09723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fc400030006ffULL, 0x0000004fff4f723eULL, 0x000fc600030006ffULL,
0x000000083034723cULL, 0x040ff00000001834ULL, 0x0000004e3038723cULL, 0x040ff00000001838ULL,
0x0000000a3030723cULL, 0x000fe20000001804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007844805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004029057811ULL, 0x000fe200078e40ffULL,
0x0000580024007a24ULL, 0x020fe200078e02ffULL, 0x000000252b0e7211ULL, 0x040fe400078fe0ffULL,
0x000000052a047217ULL, 0x000fe20007800000ULL, 0x0000004000097824ULL, 0x000fe200078e00ffULL,
0x000000022b487811ULL, 0x000fe200078fe0ffULL, 0x00000040630e7824ULL, 0x000fe200078e020eULL,
0x000000042b087811ULL, 0x000fe200078fe0ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000125007824ULL, 0x000fe200078e0248ULL, 0x0000000e09067210ULL, 0x000fe20007f5e0ffULL,
0x00000001250c7824ULL, 0x000fe200078e0208ULL, 0x0000002004047807ULL, 0x000fe20000000000ULL,
0x00000040630d7824ULL, 0x000fe200078e0200ULL, 0x000000062b007811ULL, 0x000fe200078fe0ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00005e00060a7a11ULL, 0x000fe200078440ffULL,
0x00000040630c7824ULL, 0x000fe200078e020cULL, 0x0000000425047217ULL, 0x000fc40007800000ULL,
0x00005f0006057a11ULL, 0x000fe400010f4405ULL, 0x0000000d09497210ULL, 0x040fe20007f5e0ffULL,
0x0000000104077824ULL, 0x000fe200078e0a25ULL, 0x00000004ff067819ULL, 0x000fe4000001162bULL,
0x0000000c094b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00494e7a11ULL, 0x000fe400078440ffULL, 0x000000070600720cULL, 0x000fe20003f66070ULL,
0x0000000125067824ULL, 0x000fe200078e0200ULL, 0x00005f0049497a11ULL, 0x000fe200010f4404ULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000001b0a047210ULL, 0x000fe20007f5e0ffULL,
0x00000040630b7824ULL, 0x000fe200078e0206ULL, 0x0000c000690a7811ULL, 0x000fc400078e20ffULL,
0x00005e004b4a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000000b09067210ULL, 0x000fe40007fde0ffULL, 0x000000074800720cULL, 0x000fe40003f46070ULL,
0x0000001b4e487210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040a7faeULL, 0x0003e2000d901c46ULL, 0x00005f004b4b7a11ULL, 0x000fe200020f444cULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e00064c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff497224ULL, 0x000fe200028e0649ULL, 0x000000070800720cULL, 0x000fc40003f86070ULL,
0x000000070000720cULL, 0x000fe40003fa6070ULL, 0x0000001b4a4a7210ULL, 0x080fe40007fde0ffULL,
0x00005f0006007a11ULL, 0x000fe400018f4409ULL, 0x0000001b4c4c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200030e064bULL, 0x0000c0005f097811ULL, 0x000fe400078e20ffULL,
0x0000c00067087811ULL, 0x000fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200018e0600ULL,
0x0000c00068077811ULL, 0x000fe200078e20ffULL, 0x0000000048097faeULL, 0x0003e8000d101c46ULL,
0x000000004a087faeULL, 0x0003e8000e101c46ULL, 0x000000004c077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff047f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff497984ULL, 0x000e640000000800ULL,
0x8000000049ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff627224ULL, 0x000fe200078e0005ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x000fe4000001162bULL,
0x00005410005b7816ULL, 0x000fe20000000000ULL, 0x0000e3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b677589ULL, 0x0002a400000e0000ULL, 0x0000e3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5b687589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0066ULL, 0x00002c9000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000f27000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0065ULL, 0x00002cf000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000f21000007944ULL, 0x01cfea0003c00000ULL, 0x000000072d057812ULL, 0x000fe200078e786cULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0006d067811ULL, 0x000fe400078e20ffULL,
0x0000e0006b047811ULL, 0x000fe200078e20ffULL, 0x000000086c057824ULL, 0x000fe400078e0205ULL,
0x000000000648783bULL, 0x000f660000004200ULL, 0x0000a00005007811ULL, 0x000fe200078e20ffULL,
0x00000000044c783bULL, 0x000fe80000004200ULL, 0x00000000005c783bULL, 0x002e620000000200ULL,
0x0000312048487816ULL, 0x020fc400000000ffULL, 0x0000312049497816ULL, 0x000fe400000000ffULL,
0x00000048ff02723eULL, 0x080fe400020006ffULL, 0x00000049ff03723eULL, 0x080fe200020006ffULL,
0x000000675c5c9232ULL, 0x086fe20000000000ULL, 0x00000048ff48723eULL, 0x000fe200030006ffULL,
0x000000675e5e9232ULL, 0x000fe20000000000ULL, 0x00000049ff49723eULL, 0x000fe200030006ffULL,
0x000000685d5d9232ULL, 0x090fe20000000000ULL, 0x000031204b6d7816ULL, 0x000fe200000000ffULL,
0x000000685f5f9232ULL, 0x000fe20000000000ULL, 0x000031204a007816ULL, 0x000fc400000000ffULL,
0x000031204c4c7816ULL, 0x000fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x000000025c50723cULL, 0x000fe20000001850ULL, 0x000031204e697816ULL, 0x000fe400000000ffULL,
0x000031204f6b7816ULL, 0x000fc800000000ffULL, 0x000000071f037812ULL, 0x000fe200078e786cULL,
0x000000485c54723cULL, 0x000fe20000001854ULL, 0x0000e0006e027811ULL, 0x000fc600078e20ffULL,
0x000000086c037824ULL, 0x000fe200078e0203ULL, 0x00000000ff6c723eULL, 0x080fe200030006ffULL,
0x000000000258783bULL, 0x008e620000004200ULL, 0x0000006dff49723eULL, 0x080fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400030006ffULL, 0x00000000ff48723eULL, 0x000fe400020006ffULL,
0x0000a000034a7811ULL, 0x000fe400078e20ffULL, 0x0000e0006a007811ULL, 0x000fe200078e20ffULL,
0x0000006c5c38723cULL, 0x000fe20000001838ULL, 0x00000069ff6a723eULL, 0x000fcc00030006ffULL,
0x0000004cff6c723eULL, 0x080fe200020006ffULL, 0x000000485c34723cULL, 0x000fe20000001834ULL,
0x0000004dff6d723eULL, 0x080fe200020006ffULL, 0x000000004a48783bULL, 0x000ea20000000200ULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x0000006c5c3c723cULL, 0x040ff0000000183cULL, 0x0000004c5c40723cULL, 0x000fe20000001840ULL,
0x0000312058587816ULL, 0x002fcc00000000ffULL, 0x00000069ff4c723eULL, 0x000fe400020006ffULL,
0x0000006bff4d723eULL, 0x080fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x0000004c5c44723cULL, 0x000fe20000001844ULL, 0x00000000004c783bULL, 0x000e620000004200ULL,
0x000031205b5b7816ULL, 0x000fcc00000000ffULL, 0x0000006a5c30723cULL, 0x000fe20000001830ULL,
0x0000006748489232ULL, 0x084fe40000000000ULL, 0x000000674a4a9232ULL, 0x000fe40000000000ULL,
0x0000006849499232ULL, 0x080fe40000000000ULL, 0x00000058ff5c723eULL, 0x080fe200020006ffULL,
0x000000684b4b9232ULL, 0x000fe20000000000ULL, 0x00000059ff5d723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400030006ffULL, 0x00000059ff59723eULL, 0x000fc600030006ffULL,
0x0000005c4850723cULL, 0x040ff00000001850ULL, 0x000000584854723cULL, 0x000fee0000001854ULL,
0x0000005aff58723eULL, 0x000fc400020006ffULL, 0x0000005bff59723eULL, 0x000fe400020006ffULL,
0x000031204c4c7816ULL, 0x002fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x000031204e4e7816ULL, 0x000fe200000000ffULL, 0x000000584834723cULL, 0x000fe20000001834ULL,
0x000031204f4f7816ULL, 0x000fe400000000ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fe400030006ffULL, 0x0000004cff58723eULL, 0x080fe400020006ffULL,
0x0000004dff59723eULL, 0x080fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe200030006ffULL,
0x0000005a4838723cULL, 0x000fe20000001838ULL, 0x0000004dff4d723eULL, 0x000fce00030006ffULL,
0x0000004c4840723cULL, 0x040fee0000001840ULL, 0x0000004eff4c723eULL, 0x080fe200020006ffULL,
0x00000058483c723cULL, 0x000fe2000000183cULL, 0x0000004fff4d723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fc400030006ffULL, 0x0000004fff4f723eULL, 0x000fc600030006ffULL,
0x0000004c4844723cULL, 0x040ff00000001844ULL, 0x0000004e4848723cULL, 0x000fe20000001830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004029337811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332a00720cULL, 0x000fda0003f24070ULL, 0x00005e0000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000326327812ULL, 0x000fe200078ec0ffULL,
0x00000300ff317624ULL, 0x000fc600078e00ffULL, 0x000000033200780cULL, 0x000fe20003f25270ULL,
0xfffffffd30317424ULL, 0x000fe400078e0231ULL, 0x0000580024327a24ULL, 0x000fe400078e02ffULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000131317807ULL, 0x000fca0004800000ULL,
0x0000000126267824ULL, 0x000fca00078e0231ULL, 0x000000282600720cULL, 0x000fe20003f26070ULL,
0x00000040324d7824ULL, 0x000fe200078e00ffULL, 0x0000006029337811ULL, 0x000fd600078e40ffULL,
0x0000000126319824ULL, 0x000fc800078e0221ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x000000332a327217ULL, 0x000fc80007800000ULL, 0x0000000630249981ULL, 0x000362000c1e1900ULL,
0x000000204d4c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x0000001d4d597210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200008e06ffULL,
0x00005e004c587a11ULL, 0x000fe200078240ffULL, 0x000000ffff5a7224ULL, 0x000fe200010e06ffULL,
0x0000002032327807ULL, 0x000fe40000000000ULL, 0x00005f004c4f7a11ULL, 0x000fe400008f444fULL,
0x0000001e4d337210ULL, 0x000fe40007f3e0ffULL, 0x0000003225327217ULL, 0x000fe40007800000ULL,
0x00000004ff317819ULL, 0x002fe2000001162bULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e00334c7a11ULL, 0x000fe200078240ffULL, 0x00000001324e7824ULL, 0x000fe200078e0a25ULL,
0x0000001c4d4d7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0033337a11ULL, 0x000fe400008f4430ULL,
0x0000001b58307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200018e06ffULL,
0x00005e00595c7a11ULL, 0x000fe400078440ffULL, 0x0000001b4c327210ULL, 0x000fe40007fbe0ffULL,
0x0000004e3100720cULL, 0x000fe20003f26070ULL, 0x000000ffff317224ULL, 0x000fe200020e064fULL,
0x00005f00595a7a11ULL, 0x000fe200010f445aULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x00005e004d587a11ULL, 0x000fc400078440ffULL, 0x0000004e2e00720cULL, 0x080fe40003f86070ULL,
0x0000004e2d00720cULL, 0x080fe40003fc6070ULL, 0x0000004e1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b5c4c7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000301a7faeULL, 0x0003e2000c901c46ULL, 0x00005f004d5e7a11ULL, 0x000fe400010f445eULL,
0x0000001b584e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4d7224ULL, 0x000fc400018e065aULL,
0x0000000032197faeULL, 0x0003e4000e101c46ULL, 0x000000ffff4f7224ULL, 0x000fe400010e065eULL,
0x000000004c187faeULL, 0x0003e8000f101c46ULL, 0x000000004e177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280025327f8cULL, 0x000fe2000c80043fULL, 0x8000000031ff7812ULL, 0x002fc60007844862ULL,
0x01062c00254d7984ULL, 0x000e640000000800ULL, 0x800000004dff7812ULL, 0x002fe40007824833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002e4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x008fe40003800000ULL, 0x01062c0025317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800016327984ULL, 0x000e680000000800ULL, 0x0102800016337984ULL, 0x0007220000000800ULL,
0x000000233200720bULL, 0x002fe20003f3d000ULL, 0x0000d6127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x008fc800008e0100ULL, 0x0000ffff304d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff5f7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000012c00780cULL, 0x000fe40003f65270ULL,
0x000000233200720bULL, 0x000fe20003f34000ULL, 0x0000d5e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fe400008e0100ULL, 0x0000003223317209ULL, 0x040fe40007810000ULL,
0x0000ffff30307812ULL, 0x000fe400078e3cffULL, 0x00000002ff5e7819ULL, 0x000fe2000001162bULL,
0x80000031234c7221ULL, 0x000fe20000010000ULL, 0x010480311600b388ULL, 0x0003e20000000800ULL,
0x000000304dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b4c4c7820ULL, 0x000fc80000410000ULL,
0x0000004c005b7308ULL, 0x000ee40000000800ULL, 0x0000005b22227220ULL, 0x008fe20000410000ULL,
0x0000d5827f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b5a7589ULL, 0x0022e400000e0000ULL,
0x0000005a50507220ULL, 0x08cfe20000410000ULL, 0x0000005a51517220ULL, 0x080fe20000410000ULL,
0x0000005a54547220ULL, 0x080fe20000410000ULL, 0x0000005a55557220ULL, 0x080fe20000410000ULL,
0x0000005a34347220ULL, 0x080fe20000410000ULL, 0x0000005a35357220ULL, 0x080fe20000410000ULL,
0x0000005a38387220ULL, 0x080fe20000410000ULL, 0x0000005a39397220ULL, 0x080fe20000410000ULL,
0x0000005a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005a40407220ULL, 0x080fe20000410000ULL, 0x0000005a41417220ULL, 0x080fe20000410000ULL,
0x0000005a44447220ULL, 0x080fe20000410000ULL, 0x0000005a45457220ULL, 0x080fe20000410000ULL,
0x0000005a48487220ULL, 0x080fe20000410000ULL, 0x0000005a49497220ULL, 0x000fe20000410000ULL,
0x0000d4b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b5a7589ULL, 0x0004e400000e0000ULL,
0x0000003223237209ULL, 0x000fe20007810000ULL, 0x0000005a52527220ULL, 0x08cfe20000410000ULL,
0x00000001ff5f7807ULL, 0x000fe20000800000ULL, 0x0000005a53537220ULL, 0x080fe20000410000ULL,
0x0000005a56567220ULL, 0x080fe20000410000ULL, 0x8000002332321221ULL, 0x000fe20000010000ULL,
0x0000005a57577220ULL, 0x080fe20000410000ULL, 0x0000005a36367220ULL, 0x080fe20000410000ULL,
0x0000005a37377220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL,
0x0000005a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000003200151308ULL, 0x000ea20000000800ULL,
0x0000005a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005a42427220ULL, 0x080fe20000410000ULL,
0x0000005a43437220ULL, 0x080fe20000410000ULL, 0x0000005a46467220ULL, 0x080fe20000410000ULL,
0x0000005a47477220ULL, 0x080fe20000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005a4b4b7220ULL, 0x000fe20000410000ULL, 0x0000003315331220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002233227221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fc40007824862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x000724000021f000ULL,
0x3fa0000030307823ULL, 0x008fe200000100ffULL, 0x000000310000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe40007824862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x002fc4000001162bULL, 0x00005410305b7816ULL, 0x000fe20000000030ULL,
0x0000d2527f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b677589ULL, 0x0002e400000e0000ULL,
0x0000d2927f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b627589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0066ULL,
0x0000400000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000df0000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0065ULL,
0x0000406000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000dea000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a800144d7811ULL, 0x000fe200078e20ffULL,
0x000000001330783bULL, 0x000f220000004200ULL, 0x000099105f587816ULL, 0x000fc600000000ffULL,
0x00000000125c783bULL, 0x002fe20000004200ULL, 0x000000ff5800720cULL, 0x000fc60003f25270ULL,
0x000000004d4c783bULL, 0x000e620000000200ULL, 0x0000312030307816ULL, 0x010fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x00000030ff58723eULL, 0x000fe400020006ffULL,
0x00000031ff59723eULL, 0x000fc600020006ffULL, 0x000000674c4c9232ULL, 0x08afe20000000000ULL,
0x00000030ff30723eULL, 0x000fe200030006ffULL, 0x000000674e4e9232ULL, 0x000fe20000000000ULL,
0x00000031ff31723eULL, 0x000fe200030006ffULL, 0x000000624d4d9232ULL, 0x080fe20000000000ULL,
0x00003120326a7816ULL, 0x000fe200000000ffULL, 0x000000624f4f9232ULL, 0x000fe20000000000ULL,
0x00003120336b7816ULL, 0x000fe400000000ffULL, 0x000031205c5c7816ULL, 0x000fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fc400000000ffULL, 0x000000304c54723cULL, 0x000fe20000001854ULL,
0x0000a80011327811ULL, 0x000fcc00078e20ffULL, 0x0000006aff30723eULL, 0x080fe200020006ffULL,
0x000000584c50723cULL, 0x000fe20000001850ULL, 0x0000006bff31723eULL, 0x080fe200020006ffULL,
0x000000000f58783bULL, 0x004e620000004200ULL, 0x0000006aff6a723eULL, 0x000fe400030006ffULL,
0x0000006bff6b723eULL, 0x000fc600030006ffULL, 0x000000304c34723cULL, 0x040fe20000001834ULL,
0x000000003230783bULL, 0x000eae0000000200ULL, 0x0000006a4c38723cULL, 0x000fee0000001838ULL,
0x0000005cff6a723eULL, 0x000fc400020006ffULL, 0x0000005dff6b723eULL, 0x080fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x0000006a4c3c723cULL, 0x040fee000000183cULL, 0x000031205e6a7816ULL, 0x000fe200000000ffULL,
0x0000005c4c40723cULL, 0x000fe20000001840ULL, 0x000031205f6b7816ULL, 0x000fe400000000ffULL,
0x0000312058587816ULL, 0x002fc400000000ffULL, 0x0000312059597816ULL, 0x000fe400000000ffULL,
0x0000006aff5c723eULL, 0x080fe400020006ffULL, 0x0000006bff5d723eULL, 0x080fe200020006ffULL,
0x0000006730309232ULL, 0x084fe20000000000ULL, 0x0000006aff6a723eULL, 0x000fe200030006ffULL,
0x0000006732329232ULL, 0x000fe20000000000ULL, 0x0000006bff6b723eULL, 0x000fe200030006ffULL,
0x0000006231319232ULL, 0x080fe20000000000ULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x0000005c4c44723cULL, 0x000fe20000001844ULL, 0x00000000105c783bULL, 0x000e620000004200ULL,
0x0000006233339232ULL, 0x000fe20000000000ULL, 0x000031205b5b7816ULL, 0x000fca00000000ffULL,
0x0000006a4c48723cULL, 0x000fee0000001848ULL, 0x00000058ff4c723eULL, 0x080fe400020006ffULL,
0x00000059ff4d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x0000004c3050723cULL, 0x040fee0000001850ULL,
0x0000005aff4c723eULL, 0x080fe200020006ffULL, 0x000000583054723cULL, 0x000fe20000001854ULL,
0x0000005bff4d723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fc600030006ffULL, 0x0000004c3034723cULL, 0x040fe20000001834ULL,
0x000031205c5c7816ULL, 0x002fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x0000005cff4c723eULL, 0x000fe200020006ffULL,
0x0000005a3038723cULL, 0x000fe20000001838ULL, 0x0000005dff4d723eULL, 0x000fe400020006ffULL,
0x000031205f5f7816ULL, 0x000fc400000000ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fe200030006ffULL, 0x0000004c303c723cULL, 0x040fee000000183cULL,
0x0000005eff4c723eULL, 0x000fe200020006ffULL, 0x0000005c3040723cULL, 0x000fe20000001840ULL,
0x0000005fff4d723eULL, 0x000fce00020006ffULL, 0x0000004c3044723cULL, 0x000fee0000001844ULL,
0x0000005eff4c723eULL, 0x000fe400030006ffULL, 0x0000005fff4d723eULL, 0x000fce00030006ffULL,
0x0000004c304c723cULL, 0x000fe20000001848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff327f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580024307a24ULL, 0x020fe200078e02ffULL,
0x0000008029317811ULL, 0x000fc600078e40ffULL, 0x0000004030327824ULL, 0x000fe200078e00ffULL,
0x000000312a307217ULL, 0x000fc80007800000ULL, 0x0000000e32337210ULL, 0x000fe20007f5e0ffULL,
0x0000000130307824ULL, 0x000fe200078e0a31ULL, 0x0000000d32497210ULL, 0x000fe40007f7e0ffULL,
0x00000004ff317819ULL, 0x000fe2000001162bULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005e0033587a11ULL, 0x000fe200078440ffULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x00005e00495a7a11ULL, 0x000fe400078640ffULL, 0x00005f0033337a11ULL, 0x000fc400010f4448ULL,
0x0000000c32487210ULL, 0x040fe40007f5e0ffULL, 0x00005f0049497a11ULL, 0x000fe400018f444aULL,
0x0000000b32327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x0000002030307807ULL, 0x000fe40000000000ULL, 0x00005e00485c7a11ULL, 0x000fe200078440ffULL,
0x000000ffff597224ULL, 0x000fe200018e06ffULL, 0x0000003025307217ULL, 0x000fc40007800000ULL,
0x00005e00325e7a11ULL, 0x000fe400078640ffULL, 0x00005f00484b7a11ULL, 0x000fe200010f444bULL,
0x00000001304a7824ULL, 0x000fe200078e0a25ULL, 0x00005f0032597a11ULL, 0x000fe400018f4459ULL,
0x0000001b58307210ULL, 0x080fe40007f7e0ffULL, 0x0000001b5a327210ULL, 0x080fe40007f9e0ffULL,
0x0000001b5c487210ULL, 0x000fc40007fbe0ffULL, 0x0000004a3100720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200018e0633ULL, 0x0000004a2e00720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0649ULL, 0x0000004a2d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff497224ULL, 0x000fe200028e064bULL, 0x0000004a1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b5e4a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff4b7224ULL, 0x000fe200030e0659ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300a7faeULL, 0x0003e8000d101c46ULL,
0x0000000032097faeULL, 0x0003e8000d901c46ULL, 0x0000000048087faeULL, 0x0003e8000e101c46ULL,
0x000000004a077faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff627224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x000fe4000001162bULL, 0x00005410305b7816ULL, 0x000fe20000000030ULL,
0x0000c6c27f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b677589ULL, 0x0002a400000e0000ULL,
0x0000c7027f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b687589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0066ULL,
0x00004c6000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000d2a000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0065ULL,
0x00004cc000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000d24000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a80005587811ULL, 0x000fe200078e20ffULL,
0x000000000648783bULL, 0x000f680000004200ULL, 0x000000005830783bULL, 0x000e680000000200ULL,
0x00000000045c783bULL, 0x002e620000004200ULL, 0x0000312048487816ULL, 0x020fc400000000ffULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x00000048ff5a723eULL, 0x084fe200020006ffULL,
0x0000006730309232ULL, 0x080fe20000000000ULL, 0x00000049ff5b723eULL, 0x088fe200020006ffULL,
0x0000006732329232ULL, 0x000fe20000000000ULL, 0x00000048ff48723eULL, 0x000fe200030006ffULL,
0x0000006831319232ULL, 0x090fe20000000000ULL, 0x00000049ff49723eULL, 0x000fe200030006ffULL,
0x0000006833339232ULL, 0x000fe20000000000ULL, 0x000031204b6b7816ULL, 0x000fc400000000ffULL,
0x000031204a697816ULL, 0x000fe400000000ffULL, 0x000031205c5c7816ULL, 0x002fe400000000ffULL,
0x000000483054723cULL, 0x040fe20000001854ULL, 0x00000069ff6a723eULL, 0x000fe400030006ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x0000a800034a7811ULL, 0x000fe400078e20ffULL,
0x0000006bff49723eULL, 0x080fe200020006ffULL, 0x0000005a3050723cULL, 0x000fe20000001850ULL,
0x0000006bff6b723eULL, 0x000fe200030006ffULL, 0x000000000258783bULL, 0x000e620000004200ULL,
0x00000069ff48723eULL, 0x000fc400020006ffULL, 0x000031205e697816ULL, 0x000fc600000000ffULL,
0x0000006a3038723cULL, 0x040fee0000001838ULL, 0x0000005cff6a723eULL, 0x080fe200020006ffULL,
0x000000483034723cULL, 0x000fe20000001834ULL, 0x0000005dff6b723eULL, 0x000fe200020006ffULL,
0x000000004a48783bULL, 0x000ea20000000200ULL, 0x0000005cff5c723eULL, 0x000fc400030006ffULL,
0x0000005dff5d723eULL, 0x000fc600030006ffULL, 0x0000006a303c723cULL, 0x040fee000000183cULL,
0x000031205f6b7816ULL, 0x000fe200000000ffULL, 0x0000005c3040723cULL, 0x000fe20000001840ULL,
0x00000069ff6a723eULL, 0x000fcc00030006ffULL, 0x00000069ff5c723eULL, 0x000fe400020006ffULL,
0x0000006bff5d723eULL, 0x080fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x0000312058587816ULL, 0x002fe400000000ffULL, 0x0000312059597816ULL, 0x000fe200000000ffULL,
0x0000005c3044723cULL, 0x000fe20000001844ULL, 0x00000000005c783bULL, 0x000e620000004200ULL,
0x000031205a5a7816ULL, 0x000fc400000000ffULL, 0x000031205b5b7816ULL, 0x000fc800000000ffULL,
0x0000006a304c723cULL, 0x000fe2000000184cULL, 0x0000006748489232ULL, 0x084fe40000000000ULL,
0x000000674a4a9232ULL, 0x000fe40000000000ULL, 0x0000006849499232ULL, 0x080fe40000000000ULL,
0x00000058ff30723eULL, 0x080fe200020006ffULL, 0x000000684b4b9232ULL, 0x000fe20000000000ULL,
0x00000059ff31723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x000000304850723cULL, 0x040fee0000001850ULL,
0x0000005aff30723eULL, 0x080fe200020006ffULL, 0x000000584854723cULL, 0x000fe20000001854ULL,
0x0000005bff31723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fc600030006ffULL, 0x000000304834723cULL, 0x040fe20000001834ULL,
0x000031205c5c7816ULL, 0x002fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x0000005cff30723eULL, 0x000fe200020006ffULL,
0x0000005a4838723cULL, 0x000fe20000001838ULL, 0x0000005dff31723eULL, 0x000fe400020006ffULL,
0x000031205f5f7816ULL, 0x000fc400000000ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fe200030006ffULL, 0x00000030483c723cULL, 0x040fee000000183cULL,
0x0000005eff30723eULL, 0x000fe200020006ffULL, 0x0000005c4840723cULL, 0x000fe20000001840ULL,
0x0000005fff31723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400030006ffULL,
0x0000005fff5f723eULL, 0x000fc600030006ffULL, 0x000000304844723cULL, 0x040ff00000001844ULL,
0x0000005e4848723cULL, 0x000fe2000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008029337811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000332a00720cULL, 0x000fda0003f24070ULL,
0x00003eb000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x002e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000327305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000320000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff327984ULL, 0x000e640000000800ULL, 0x8000000032ff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff307424ULL, 0x000fe200078e00ffULL,
0x0000000326327812ULL, 0x000fe200078ec0ffULL, 0x00000300ff317624ULL, 0x000fc600078e00ffULL,
0x000000033200780cULL, 0x000fe20003f25270ULL, 0xfffffffd30317424ULL, 0x000fe400078e0231ULL,
0x0000580024327a24ULL, 0x000fe400078e02ffULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x0000000131317807ULL, 0x000fca0004800000ULL, 0x0000000126267824ULL, 0x000fca00078e0231ULL,
0x000000282600720cULL, 0x000fe20003f26070ULL, 0x00000040324d7824ULL, 0x000fe200078e00ffULL,
0x000000a029337811ULL, 0x000fd600078e40ffULL, 0x0000000126319824ULL, 0x000fc800078e0221ULL,
0x0000600031309625ULL, 0x000fe200078e0030ULL, 0x000000332a327217ULL, 0x000fc80007800000ULL,
0x0000000630249981ULL, 0x000362000c1e1900ULL, 0x000000204d4c7210ULL, 0x040fe20007f3e0ffULL,
0x0000000132327824ULL, 0x000fe200078e0a33ULL, 0x0000001d4d597210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff4f7224ULL, 0x000fe200008e06ffULL, 0x00005e004c587a11ULL, 0x000fe200078240ffULL,
0x000000ffff5a7224ULL, 0x000fe200010e06ffULL, 0x0000002032327807ULL, 0x000fe40000000000ULL,
0x00005f004c4f7a11ULL, 0x000fe400008f444fULL, 0x0000001e4d337210ULL, 0x000fe40007f3e0ffULL,
0x0000003225327217ULL, 0x000fe40007800000ULL, 0x00000004ff317819ULL, 0x002fe2000001162bULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x00005e00334c7a11ULL, 0x000fe200078240ffULL,
0x00000001324e7824ULL, 0x000fe200078e0a25ULL, 0x0000001c4d4d7210ULL, 0x000fc40007f7e0ffULL,
0x00005f0033337a11ULL, 0x000fe400008f4430ULL, 0x0000001b58307210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff5e7224ULL, 0x000fe200018e06ffULL, 0x00005e00595c7a11ULL, 0x000fe400078440ffULL,
0x0000001b4c327210ULL, 0x000fe40007fbe0ffULL, 0x0000004e3100720cULL, 0x000fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200020e064fULL, 0x00005f00595a7a11ULL, 0x000fe200010f445aULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x00005e004d587a11ULL, 0x000fc400078440ffULL,
0x0000004e2e00720cULL, 0x080fe40003f86070ULL, 0x0000004e2d00720cULL, 0x080fe40003fc6070ULL,
0x0000004e1f00720cULL, 0x000fe40003fa6070ULL, 0x0000001b5c4c7210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000301a7faeULL, 0x0003e2000c901c46ULL,
0x00005f004d5e7a11ULL, 0x000fe400010f445eULL, 0x0000001b584e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4d7224ULL, 0x000fc400018e065aULL, 0x0000000032197faeULL, 0x0003e4000e101c46ULL,
0x000000ffff4f7224ULL, 0x000fe400010e065eULL, 0x000000004c187faeULL, 0x0003e8000f101c46ULL,
0x000000004e177faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff687f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff317984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480025327f8cULL, 0x000fe2000c80043fULL,
0x8000000031ff7812ULL, 0x002fc60007844862ULL, 0x01064c00254d7984ULL, 0x000e640000000800ULL,
0x800000004dff7812ULL, 0x002fe40007824833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002e4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x008fe40003800000ULL,
0x01064c0025317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000016327984ULL, 0x000e680000000800ULL,
0x0103000016337984ULL, 0x0007220000000800ULL, 0x000000233200720bULL, 0x002fe20003f3d000ULL,
0x0000b9b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x008fc800008e0100ULL,
0x0000ffff304d7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff5f7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000022c00780cULL, 0x000fe40003f65270ULL, 0x000000233200720bULL, 0x000fe20003f34000ULL,
0x0000b9827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x000fe400008e0100ULL,
0x0000003223317209ULL, 0x040fe40007810000ULL, 0x0000ffff30307812ULL, 0x000fe400078e3cffULL,
0x00000002ff5e7819ULL, 0x000fe2000001162bULL, 0x80000031234c7221ULL, 0x000fe20000010000ULL,
0x010500311600b388ULL, 0x0003e20000000800ULL, 0x000000304dff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b4c4c7820ULL, 0x000fc80000410000ULL, 0x0000004c005b7308ULL, 0x000ee40000000800ULL,
0x0000005b22227220ULL, 0x008fe20000410000ULL, 0x0000b9227f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b5a7589ULL, 0x0022e400000e0000ULL, 0x0000005a50507220ULL, 0x08cfe20000410000ULL,
0x0000005a51517220ULL, 0x080fe20000410000ULL, 0x0000005a54547220ULL, 0x080fe20000410000ULL,
0x0000005a55557220ULL, 0x080fe20000410000ULL, 0x0000005a34347220ULL, 0x080fe20000410000ULL,
0x0000005a35357220ULL, 0x080fe20000410000ULL, 0x0000005a38387220ULL, 0x080fe20000410000ULL,
0x0000005a39397220ULL, 0x080fe20000410000ULL, 0x0000005a3c3c7220ULL, 0x080fe20000410000ULL,
0x0000005a3d3d7220ULL, 0x080fe20000410000ULL, 0x0000005a40407220ULL, 0x080fe20000410000ULL,
0x0000005a41417220ULL, 0x080fe20000410000ULL, 0x0000005a44447220ULL, 0x080fe20000410000ULL,
0x0000005a45457220ULL, 0x080fe20000410000ULL, 0x0000005a48487220ULL, 0x080fe20000410000ULL,
0x0000005a49497220ULL, 0x000fe20000410000ULL, 0x0000b8527f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5b5a7589ULL, 0x0004e400000e0000ULL, 0x0000003223237209ULL, 0x000fe20007810000ULL,
0x0000005a52527220ULL, 0x08cfe20000410000ULL, 0x00000001ff5f7807ULL, 0x000fe20000800000ULL,
0x0000005a53537220ULL, 0x080fe20000410000ULL, 0x0000005a56567220ULL, 0x080fe20000410000ULL,
0x8000002332321221ULL, 0x000fe20000010000ULL, 0x0000005a57577220ULL, 0x080fe20000410000ULL,
0x0000005a36367220ULL, 0x080fe20000410000ULL, 0x0000005a37377220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL, 0x0000005a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000003200151308ULL, 0x000ea20000000800ULL, 0x0000005a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005a42427220ULL, 0x080fe20000410000ULL, 0x0000005a43437220ULL, 0x080fe20000410000ULL,
0x0000005a46467220ULL, 0x080fe20000410000ULL, 0x0000005a47477220ULL, 0x080fe20000410000ULL,
0x0000005a4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005a4b4b7220ULL, 0x000fe20000410000ULL,
0x0000003315331220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002233227221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff317984ULL, 0x000ee40000000800ULL,
0x8000000031ff7812ULL, 0x008fc40007824862ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x000724000021f000ULL, 0x3fa0000030307823ULL, 0x008fe200000100ffULL,
0x000000310000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff317984ULL, 0x000ee40000000800ULL,
0x8000000031ff7812ULL, 0x008fe40007824862ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x002fc4000001162bULL,
0x00005410305b7816ULL, 0x000fe20000000030ULL, 0x0000b5f27f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b677589ULL, 0x0002e400000e0000ULL, 0x0000b6327f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5b627589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0066ULL, 0x00005f5000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000bfb000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0065ULL, 0x00005fb000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000bf5000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b00014317811ULL, 0x000fe200078e20ffULL, 0x00000000134c783bULL, 0x000f220000004200ULL,
0x000099105f587816ULL, 0x000fc400000000ffULL, 0x0000b000116c7811ULL, 0x000fe200078e20ffULL,
0x00000000125c783bULL, 0x002fe20000004200ULL, 0x000000ff5800720cULL, 0x000fc60003f25270ULL,
0x000000003130783bULL, 0x000e620000000200ULL, 0x000031204c4c7816ULL, 0x010fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x0000004cff58723eULL, 0x000fe400020006ffULL,
0x0000004dff59723eULL, 0x000fc600020006ffULL, 0x0000006730309232ULL, 0x08afe20000000000ULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x0000006732329232ULL, 0x000fe20000000000ULL,
0x0000004dff4d723eULL, 0x000fe200030006ffULL, 0x0000006231319232ULL, 0x080fe20000000000ULL,
0x000031204e6a7816ULL, 0x000fe200000000ffULL, 0x0000006233339232ULL, 0x000fe20000000000ULL,
0x000031204f6b7816ULL, 0x000fe400000000ffULL, 0x000031205c5c7816ULL, 0x000fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fc400000000ffULL, 0x0000004c3054723cULL, 0x040fee0000001854ULL,
0x0000006aff4c723eULL, 0x080fe200020006ffULL, 0x000000583050723cULL, 0x000fe20000001850ULL,
0x0000006bff4d723eULL, 0x000fe200020006ffULL, 0x000000000f58783bULL, 0x004e620000004200ULL,
0x0000006aff6a723eULL, 0x000fc400030006ffULL, 0x0000006bff6b723eULL, 0x000fc600030006ffULL,
0x0000004c304c723cULL, 0x040fe20000001834ULL, 0x000000006c34783bULL, 0x000eae0000000200ULL,
0x0000006a3038723cULL, 0x000fee0000001838ULL, 0x0000005cff6a723eULL, 0x000fc400020006ffULL,
0x0000005dff6b723eULL, 0x080fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fc600030006ffULL, 0x0000006a303c723cULL, 0x040fee000000183cULL,
0x000031205e6a7816ULL, 0x000fe200000000ffULL, 0x0000005c3040723cULL, 0x000fe20000001840ULL,
0x000031205f6b7816ULL, 0x000fe400000000ffULL, 0x0000312058587816ULL, 0x002fc400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x0000006aff5c723eULL, 0x080fe400020006ffULL,
0x0000006bff5d723eULL, 0x080fe200020006ffULL, 0x0000006734349232ULL, 0x084fe20000000000ULL,
0x0000006aff6a723eULL, 0x000fe200030006ffULL, 0x0000006736369232ULL, 0x000fe20000000000ULL,
0x0000006bff6b723eULL, 0x000fe200030006ffULL, 0x0000006235359232ULL, 0x080fe20000000000ULL,
0x000031205a5a7816ULL, 0x000fe200000000ffULL, 0x0000005c3044723cULL, 0x000fe20000001844ULL,
0x00000000105c783bULL, 0x000e620000004200ULL, 0x0000006237379232ULL, 0x000fe20000000000ULL,
0x000031205b5b7816ULL, 0x000fca00000000ffULL, 0x0000006a3030723cULL, 0x000fee0000001848ULL,
0x00000058ff48723eULL, 0x080fe400020006ffULL, 0x00000059ff49723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400030006ffULL, 0x00000059ff59723eULL, 0x000fc600030006ffULL,
0x000000483450723cULL, 0x040fee0000001850ULL, 0x0000005aff48723eULL, 0x080fe200020006ffULL,
0x000000583454723cULL, 0x000fe20000001854ULL, 0x0000005bff49723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400030006ffULL, 0x0000005bff5b723eULL, 0x000fc600030006ffULL,
0x00000048344c723cULL, 0x040fe2000000184cULL, 0x000031205c5c7816ULL, 0x002fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x000031205e5e7816ULL, 0x000fe400000000ffULL,
0x0000005cff48723eULL, 0x000fe200020006ffULL, 0x0000005a3438723cULL, 0x000fe20000001838ULL,
0x0000005dff49723eULL, 0x000fe400020006ffULL, 0x000031205f5f7816ULL, 0x000fc400000000ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fe200030006ffULL,
0x00000048343c723cULL, 0x040fee000000183cULL, 0x0000005eff48723eULL, 0x000fe200020006ffULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x0000005fff49723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400030006ffULL, 0x0000005fff5f723eULL, 0x000fc600030006ffULL,
0x000000483444723cULL, 0x040ff00000001844ULL, 0x0000005e3434723cULL, 0x000fe20000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff327f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580024307a24ULL, 0x020fe200078e02ffULL, 0x000000c029317811ULL, 0x000fc600078e40ffULL,
0x0000004030327824ULL, 0x000fe200078e00ffULL, 0x000000312a307217ULL, 0x000fc80007800000ULL,
0x0000000e32337210ULL, 0x000fe20007f5e0ffULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000000d32497210ULL, 0x000fe40007f7e0ffULL, 0x00000004ff317819ULL, 0x000fe2000001162bULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e0033587a11ULL, 0x000fe200078440ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005e00495a7a11ULL, 0x000fe400078640ffULL,
0x00005f0033337a11ULL, 0x000fc400010f4448ULL, 0x0000000c32487210ULL, 0x040fe40007f5e0ffULL,
0x00005f0049497a11ULL, 0x000fe400018f444aULL, 0x0000000b32327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4b7224ULL, 0x000fe200010e06ffULL, 0x0000002030307807ULL, 0x000fe40000000000ULL,
0x00005e00485c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff597224ULL, 0x000fe200018e06ffULL,
0x0000003025307217ULL, 0x000fc40007800000ULL, 0x00005e00325e7a11ULL, 0x000fe400078640ffULL,
0x00005f00484b7a11ULL, 0x000fe200010f444bULL, 0x00000001304a7824ULL, 0x000fe200078e0a25ULL,
0x00005f0032597a11ULL, 0x000fe400018f4459ULL, 0x0000001b58307210ULL, 0x080fe40007f7e0ffULL,
0x0000001b5a327210ULL, 0x080fe40007f9e0ffULL, 0x0000001b5c487210ULL, 0x000fc40007fbe0ffULL,
0x0000004a3100720cULL, 0x080fe20003f46070ULL, 0x000000ffff317224ULL, 0x000fe200018e0633ULL,
0x0000004a2e00720cULL, 0x080fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200020e0649ULL,
0x0000004a2d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff497224ULL, 0x000fe200028e064bULL,
0x0000004a1f00720cULL, 0x000fe40003fa6070ULL, 0x0000001b5e4a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff4b7224ULL, 0x000fe200030e0659ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000300a7faeULL, 0x0003e8000d101c46ULL, 0x0000000032097faeULL, 0x0003e8000d901c46ULL,
0x0000000048087faeULL, 0x0003e8000e101c46ULL, 0x000000004a077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff627224ULL, 0x000fe200078e0031ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x000fe4000001162bULL,
0x00005410305b7816ULL, 0x000fe20000000030ULL, 0x0000aa627f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b677589ULL, 0x0002a400000e0000ULL, 0x0000aaa27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5b687589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0066ULL, 0x00006bb000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000b35000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0065ULL, 0x00006c1000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000b2f000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b00005587811ULL, 0x000fe200078e20ffULL, 0x000000000648783bULL, 0x000f680000004200ULL,
0x000000005830783bULL, 0x000e680000000200ULL, 0x00000000045c783bULL, 0x002e620000004200ULL,
0x0000312048487816ULL, 0x020fc400000000ffULL, 0x0000312049497816ULL, 0x000fe400000000ffULL,
0x00000048ff5a723eULL, 0x084fe200020006ffULL, 0x0000006730309232ULL, 0x080fe20000000000ULL,
0x00000049ff5b723eULL, 0x088fe200020006ffULL, 0x0000006732329232ULL, 0x000fe20000000000ULL,
0x00000048ff48723eULL, 0x000fe200030006ffULL, 0x0000006831319232ULL, 0x090fe20000000000ULL,
0x00000049ff49723eULL, 0x000fe200030006ffULL, 0x0000006833339232ULL, 0x000fe20000000000ULL,
0x000031204b6b7816ULL, 0x000fc400000000ffULL, 0x000031204a697816ULL, 0x000fe400000000ffULL,
0x000031205c5c7816ULL, 0x002fe400000000ffULL, 0x000000483054723cULL, 0x040fe20000001854ULL,
0x00000069ff6a723eULL, 0x000fe400030006ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x0000b000034a7811ULL, 0x000fe400078e20ffULL, 0x0000006bff49723eULL, 0x080fe200020006ffULL,
0x0000005a3050723cULL, 0x000fe20000001850ULL, 0x0000006bff6b723eULL, 0x000fe200030006ffULL,
0x000000000258783bULL, 0x000e620000004200ULL, 0x00000069ff48723eULL, 0x000fc400020006ffULL,
0x000031205e697816ULL, 0x000fc600000000ffULL, 0x0000006a3038723cULL, 0x040fee0000001838ULL,
0x0000005cff6a723eULL, 0x080fe200020006ffULL, 0x00000048304c723cULL, 0x000fe2000000184cULL,
0x0000005dff6b723eULL, 0x000fe200020006ffULL, 0x000000004a48783bULL, 0x000ea20000000200ULL,
0x0000005cff5c723eULL, 0x000fc400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x0000006a303c723cULL, 0x040fee000000183cULL, 0x000031205f6b7816ULL, 0x000fe200000000ffULL,
0x0000005c3040723cULL, 0x000fe20000001840ULL, 0x00000069ff6a723eULL, 0x000fcc00030006ffULL,
0x00000069ff5c723eULL, 0x000fe400020006ffULL, 0x0000006bff5d723eULL, 0x080fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400030006ffULL, 0x0000312058587816ULL, 0x002fe400000000ffULL,
0x0000312059597816ULL, 0x000fe200000000ffULL, 0x0000005c3044723cULL, 0x000fe20000001844ULL,
0x00000000005c783bULL, 0x000e620000004200ULL, 0x000031205a5a7816ULL, 0x000fc400000000ffULL,
0x000031205b5b7816ULL, 0x000fc800000000ffULL, 0x0000006a3030723cULL, 0x000fe20000001834ULL,
0x0000006748489232ULL, 0x084fe40000000000ULL, 0x000000674a4a9232ULL, 0x000fe40000000000ULL,
0x0000006849499232ULL, 0x080fe40000000000ULL, 0x00000058ff34723eULL, 0x080fe200020006ffULL,
0x000000684b4b9232ULL, 0x000fe20000000000ULL, 0x00000059ff35723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400030006ffULL, 0x00000059ff59723eULL, 0x000fc600030006ffULL,
0x000000344850723cULL, 0x040fee0000001850ULL, 0x0000005aff34723eULL, 0x080fe200020006ffULL,
0x000000584854723cULL, 0x000fe20000001854ULL, 0x0000005bff35723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400030006ffULL, 0x0000005bff5b723eULL, 0x000fc600030006ffULL,
0x000000344834723cULL, 0x040fe2000000184cULL, 0x000031205c5c7816ULL, 0x002fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x000031205e5e7816ULL, 0x000fe400000000ffULL,
0x0000005cff4c723eULL, 0x000fe200020006ffULL, 0x0000005a4838723cULL, 0x000fe20000001838ULL,
0x0000005dff4d723eULL, 0x000fe400020006ffULL, 0x000031205f5f7816ULL, 0x000fc400000000ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fe200030006ffULL,
0x0000004c483c723cULL, 0x040fee000000183cULL, 0x0000005eff4c723eULL, 0x000fe200020006ffULL,
0x0000005c4840723cULL, 0x000fe20000001840ULL, 0x0000005fff4d723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400030006ffULL, 0x0000005fff5f723eULL, 0x000fc600030006ffULL,
0x0000004c4844723cULL, 0x040ff00000001844ULL, 0x0000005e4848723cULL, 0x000fe20000001830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c029337811ULL, 0x000fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332a00720cULL, 0x000fda0003f24070ULL, 0x00001f6000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000326327812ULL, 0x000fe200078ec0ffULL,
0x00000300ff317624ULL, 0x000fe400078e00ffULL, 0x00005800244c7a24ULL, 0x000fe200078e02ffULL,
0x000000033200780cULL, 0x000fe20003f25270ULL, 0xfffffffd30317424ULL, 0x000fe200078e0231ULL,
0x000000e029337811ULL, 0x000fe200078e40ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0x0000000131317807ULL, 0x000fca0004800000ULL, 0x0000000126267824ULL, 0x000fca00078e0231ULL,
0x000000282600720cULL, 0x000fe40003f26070ULL, 0x000000332a327217ULL, 0x000fe20007800000ULL,
0x000000404c4d7824ULL, 0x000fc800078e00ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x000000204d207210ULL, 0x000fca0007f5e0ffULL, 0x0000000126319824ULL, 0x000fe200078e0221ULL,
0x0000002032327807ULL, 0x000fc60000000000ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x0000001e4d1e7210ULL, 0x040fe40007f7e0ffULL, 0x0000001d4d4c7210ULL, 0x000fe40007f9e0ffULL,
0x0000003225327217ULL, 0x000fe20007800000ULL, 0x0000000630249981ULL, 0x000362000c1e1900ULL,
0x0000001c4d4f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00005e00201c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff4d7224ULL, 0x000fe200020e06ffULL,
0x00000004ff1d7819ULL, 0x000fe2000001162bULL, 0x0000000132327824ULL, 0x000fe200078e0a25ULL,
0x00005e004c4e7a11ULL, 0x000fc400078640ffULL, 0x0000001b1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x002fe200010e06ffULL, 0x00005e001e307a11ULL, 0x000fe400078440ffULL,
0x00005f004c4d7a11ULL, 0x000fe400018f444dULL, 0x00005f0020317a11ULL, 0x000fe400000f4431ULL,
0x00005f001e337a11ULL, 0x000fe200010f4433ULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x000000321d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e0631ULL,
0x00005e004f4c7a11ULL, 0x000fc400078240ffULL, 0x000000322e00720cULL, 0x080fe40003f66070ULL,
0x000000322d00720cULL, 0x080fe40003fa6070ULL, 0x000000321f00720cULL, 0x000fe40003f86070ULL,
0x0000001b30307210ULL, 0x080fe40007f5e0ffULL, 0x0000001b4e327210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1a7faeULL, 0x0003e2000c101c46ULL,
0x00005f004f1e7a11ULL, 0x000fe200008f441eULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x0000001b4c4c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fc600030e064dULL,
0x0000000030197faeULL, 0x0003e2000d901c46ULL, 0x000000ffff4d7224ULL, 0x000fc600008e061eULL,
0x0000000032187faeULL, 0x0003e8000e901c46ULL, 0x000000004c177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff187f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff177984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01066800251c7f8cULL, 0x000fe2000c80043fULL, 0x8000000017ff7812ULL, 0x004fc60007804862ULL,
0x01066c0025317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fe4000782481dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff177424ULL, 0x000fc800078e00ffULL,
0x00000017001a7305ULL, 0x0004e4000021f000ULL, 0x3fa0000017177823ULL, 0x004fe200000100ffULL,
0x0000001a0000735dULL, 0x008fe20003800000ULL, 0x01066c0025317984ULL, 0x000ea40000000800ULL,
0x8000000031ff7812ULL, 0x004fc4000782481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01018000161a7984ULL, 0x000ea80000000800ULL, 0x0103800016177984ULL, 0x0007220000000800ULL,
0x000000231a00720bULL, 0x004fe20003f3d000ULL, 0x00009d527f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff1c1e7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000032c00780cULL, 0x000fe40003f45270ULL,
0x000000231a00720bULL, 0x000fe20003f34000ULL, 0x00009d227f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x000fe400008e0100ULL, 0x0000001a23317209ULL, 0x000fe40007810000ULL,
0x00000002ff5e7819ULL, 0x000fc6000001162bULL, 0x80000031231d7221ULL, 0x000fe20000010000ULL,
0x010580311600a388ULL, 0x0005e20000000800ULL, 0x0000ffff1c237812ULL, 0x000fe400078e3cffULL,
0x3fb8aa3b1d1d7820ULL, 0x000fe40000410000ULL, 0x000000231eff7212ULL, 0x000fe4000782c0ffULL,
0x0000001d005b7308ULL, 0x000ee40000000800ULL, 0x0000005b22227220ULL, 0x008fe20000410000ULL,
0x00009cc27f007947ULL, 0x000fec000b800000ULL, 0x00001f5e5b5a7589ULL, 0x0044e400000e0000ULL,
0x0000005a50507220ULL, 0x08cfe20000410000ULL, 0x0000005a51517220ULL, 0x080fe20000410000ULL,
0x0000005a54547220ULL, 0x080fe20000410000ULL, 0x0000005a55557220ULL, 0x080fe20000410000ULL,
0x0000005a34347220ULL, 0x080fe20000410000ULL, 0x0000005a35357220ULL, 0x080fe20000410000ULL,
0x0000005a38387220ULL, 0x080fe20000410000ULL, 0x0000005a39397220ULL, 0x080fe20000410000ULL,
0x0000005a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005a40407220ULL, 0x080fe20000410000ULL, 0x0000005a41417220ULL, 0x080fe20000410000ULL,
0x0000005a44447220ULL, 0x080fe20000410000ULL, 0x0000005a45457220ULL, 0x080fe20000410000ULL,
0x0000005a48487220ULL, 0x080fe20000410000ULL, 0x0000005a49497220ULL, 0x000fe20000410000ULL,
0x00009bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b5a7589ULL, 0x0004e400000e0000ULL,
0x800000311a1a1221ULL, 0x100fe20000010000ULL, 0x00000001ff1c7807ULL, 0x000fe20000800000ULL,
0x0000005a52527220ULL, 0x08cfe20000410000ULL, 0x0000005a53537220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b1a1a1820ULL, 0x000fe20000410000ULL, 0x0000005a56567220ULL, 0x080fe20000410000ULL,
0x0000005a57577220ULL, 0x080fe20000410000ULL, 0x0000005a36367220ULL, 0x080fe20000410000ULL,
0x0000001a00151308ULL, 0x000ea20000000800ULL, 0x0000005a37377220ULL, 0x080fe20000410000ULL,
0x0000005a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000005a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005a42427220ULL, 0x080fe20000410000ULL, 0x0000005a43437220ULL, 0x080fe20000410000ULL,
0x0000005a46467220ULL, 0x080fe20000410000ULL, 0x0000005a47477220ULL, 0x080fe20000410000ULL,
0x0000005a4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005a4b4b7220ULL, 0x000fe20000410000ULL,
0x000000ffff237224ULL, 0x000fe200078e0031ULL, 0x0000001715171220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002217227221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fc40007804862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff167424ULL, 0x000fc800078e00ffULL, 0x0000001600177305ULL, 0x0004e4000021f000ULL,
0x3fa0000016167823ULL, 0x004fe200000100ffULL, 0x000000170000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe40007804862ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x002fc4000001162bULL, 0x00005410165b7816ULL, 0x000fe20000000016ULL,
0x000099927f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b177589ULL, 0x0002a400000e0000ULL,
0x000099d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5b167589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0066ULL,
0x00007ea000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000a06000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0065ULL,
0x00007f0000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000a00000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001358783bULL, 0x00ee620000004200ULL,
0x0000b80014147811ULL, 0x000fc400078e20ffULL, 0x000099101c1a7816ULL, 0x000fe200000000ffULL,
0x00000000124c783bULL, 0x000fe20000004200ULL, 0x0000b80011117811ULL, 0x000fe400078e20ffULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x000000001430783bULL, 0x000ea80000000200ULL,
0x000000000f5c783bULL, 0x0007220000004200ULL, 0x0000312058587816ULL, 0x002fc400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00000058ff1c723eULL, 0x080fe400020006ffULL,
0x00000059ff1d723eULL, 0x080fe200020006ffULL, 0x0000001730308232ULL, 0x084fe20000000000ULL,
0x00000058ff58723eULL, 0x000fe200030006ffULL, 0x0000001732328232ULL, 0x000fe20000000000ULL,
0x00000059ff59723eULL, 0x000fe200030006ffULL, 0x0000001631318232ULL, 0x090fe20000000000ULL,
0x000031205a127816ULL, 0x000fe200000000ffULL, 0x0000001633338232ULL, 0x000fe20000000000ULL,
0x000031205b697816ULL, 0x000fc400000000ffULL, 0x000031204e0f7816ULL, 0x008fe400000000ffULL,
0x000031204f757816ULL, 0x000fe400000000ffULL, 0x000000583054723cULL, 0x040fe20000001854ULL,
0x0000000fff70723eULL, 0x000fe400020006ffULL, 0x00000075ff71723eULL, 0x000fe400020006ffULL,
0x000031204c4c7816ULL, 0x000fe400000000ffULL, 0x00000012ff58723eULL, 0x000fe200020006ffULL,
0x0000001c3050723cULL, 0x000fe20000001850ULL, 0x00000069ff59723eULL, 0x000fc400020006ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x0000004cff6c723eULL, 0x000fe400020006ffULL,
0x0000004dff6d723eULL, 0x000fe200020006ffULL, 0x000000583058723cULL, 0x000fe20000001834ULL,
0x000000001134783bULL, 0x000e620000000200ULL, 0x00000012ff68723eULL, 0x000fe400030006ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x0000004cff4c723eULL, 0x000fc400030006ffULL,
0x000000703070723cULL, 0x040fe20000001844ULL, 0x000000001044783bULL, 0x000ea20000004200ULL,
0x0000004dff4d723eULL, 0x000fe400030006ffULL, 0x0000000fff74723eULL, 0x000fe400030006ffULL,
0x00000075ff75723eULL, 0x000fe400030006ffULL, 0x000000683068723cULL, 0x000fe20000001838ULL,
0x000031205c5c7816ULL, 0x000fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fc400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x0000005cff12723eULL, 0x000fe200020006ffULL,
0x0000006c306c723cULL, 0x000fe2000000183cULL, 0x0000005dff13723eULL, 0x000fe400020006ffULL,
0x0000005eff38723eULL, 0x000fc800020006ffULL, 0x000031205f3d7816ULL, 0x000fe200000000ffULL,
0x0000004c304c723cULL, 0x000fe20000001840ULL, 0x0000005eff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x000000743074723cULL, 0x000fe20000001848ULL, 0x0000001734348232ULL, 0x082fe40000000000ULL,
0x0000001736368232ULL, 0x000fe40000000000ULL, 0x0000001635358232ULL, 0x080fe40000000000ULL,
0x0000001637378232ULL, 0x000fe20000000000ULL, 0x0000005cff30723eULL, 0x000fe400030006ffULL,
0x0000312044447816ULL, 0x004fc400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x00003120460f7816ULL, 0x000fe200000000ffULL, 0x000000123410723cULL, 0x040fe20000001850ULL,
0x0000312047177816ULL, 0x000fe400000000ffULL, 0x00000044ff40723eULL, 0x080fe400020006ffULL,
0x00000045ff41723eULL, 0x000fe400020006ffULL, 0x0000005dff31723eULL, 0x000fe200030006ffULL,
0x000000383438723cULL, 0x000fe20000001858ULL, 0x00000044ff44723eULL, 0x000fc400030006ffULL,
0x00000045ff45723eULL, 0x000fe400030006ffULL, 0x0000000fff48723eULL, 0x000fe400020006ffULL,
0x00000017ff49723eULL, 0x000fe200020006ffULL, 0x000000303430723cULL, 0x000fe20000001854ULL,
0x0000000fff16723eULL, 0x000fe400030006ffULL, 0x00000017ff17723eULL, 0x000fca00030006ffULL,
0x0000003c343c723cULL, 0x040ff00000001868ULL, 0x000000403440723cULL, 0x040ff0000000186cULL,
0x000000443444723cULL, 0x040ff0000000184cULL, 0x000000483448723cULL, 0x040ff00000001870ULL,
0x000000163434723cULL, 0x000fe20000001874ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff167f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00147305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000140000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300290f7a10ULL, 0x000fe20007ffe0ffULL,
0x0000580024147a24ULL, 0x020fc800078e02ffULL, 0x000001000f177824ULL, 0x040fe400078e00ffULL,
0x00000040141a7824ULL, 0x000fe200078e00ffULL, 0x000000010f147810ULL, 0x000fe40007ffe0ffULL,
0x000000172a167217ULL, 0x000fe40007800000ULL, 0x0000000e1a0e7210ULL, 0x000fe40007f3e0ffULL,
0x000000271400720cULL, 0x000fe20003f46070ULL, 0x0000000116167824ULL, 0x000fe200078e0a17ULL,
0x0000000d1a0d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e000e1c7a11ULL, 0x000fc400078640ffULL, 0x0000002016167807ULL, 0x000fe40001000000ULL,
0x0000000c1a1d7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x0000000b1a207210ULL, 0x000fe40007f3e0ffULL, 0x00005f000e0f7a11ULL, 0x000fe200018f440fULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0x0000001625167217ULL, 0x000fe20007800000ULL,
0x000000ffff4d7224ULL, 0x000fe200008e06ffULL, 0x00005e000d0e7a11ULL, 0x000fc400078440ffULL,
0x00005e001d1e7a11ULL, 0x000fe200078640ffULL, 0x0000000116147824ULL, 0x000fe200078e0a25ULL,
0x00005f000d177a11ULL, 0x000fe400010f440cULL, 0x00000004ff0b7819ULL, 0x000fe4000001162bULL,
0x00005e00204c7a11ULL, 0x000fe400078240ffULL, 0x0000001b1c0c7210ULL, 0x080fe40007f9e0ffULL,
0x0000001b0e0e7210ULL, 0x000fc40007fbe0ffULL, 0x00005f001d1a7a11ULL, 0x000fe200018f441aULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x00005f00204d7a11ULL, 0x000fe200008f444dULL,
0x000000ffff0f7224ULL, 0x000fe200028e0617ULL, 0x000000140b00720cULL, 0x080fe40003f46070ULL,
0x0000001b1e167210ULL, 0x000fe40007f7e0ffULL, 0x000000142e00720cULL, 0x080fe40003f26070ULL,
0x000000142d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff177224ULL, 0x000fe200018e061aULL,
0x000000141f00720cULL, 0x000fc40003fa6070ULL, 0x0000001b4c1a7210ULL, 0x000fc60007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0a7faeULL, 0x0003e4000d101c46ULL,
0x000000ffff1b7224ULL, 0x000fe400018e064dULL, 0x000000000e097faeULL, 0x0003e8000c901c46ULL,
0x0000000016087faeULL, 0x0003e8000e101c46ULL, 0x000000001a077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff087f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007824819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff627224ULL, 0x000fe200078e0009ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0002a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x0106b400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x000fe4000001162bULL,
0x00005410075b7816ULL, 0x000fe20000000007ULL, 0x00008dd27f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b0d7589ULL, 0x0002a400000e0000ULL, 0x00008e127f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5b0c7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0066ULL, 0x00008b3000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000093d000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0065ULL, 0x00008b9000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000937000007944ULL, 0x01cfea0003c00000ULL, 0x0000b80005057811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000618783bULL, 0x000f620000004200ULL,
0x0000b80003037811ULL, 0x000fc600078e20ffULL, 0x000000000508783bULL, 0x000e680000000200ULL,
0x00000000041c783bULL, 0x0007220000004200ULL, 0x0000312018187816ULL, 0x020fe400000000ffULL,
0x0000312019197816ULL, 0x000fe200000000ffULL, 0x0000000d08088232ULL, 0x086fe20000000000ULL,
0x00000018ff0e723eULL, 0x000fe200020006ffULL, 0x0000000d0a0a8232ULL, 0x000fe20000000000ULL,
0x00000019ff0f723eULL, 0x000fe200020006ffULL, 0x0000000c09098232ULL, 0x090fe20000000000ULL,
0x000031201a1a7816ULL, 0x000fe200000000ffULL, 0x0000000c0b0b8232ULL, 0x000fe20000000000ULL,
0x000031201b1b7816ULL, 0x000fc400000000ffULL, 0x0000001aff04723eULL, 0x008fe400020006ffULL,
0x0000001bff05723eULL, 0x000fe400020006ffULL, 0x0000000e084c723cULL, 0x000fe20000001810ULL,
0x000000000210783bULL, 0x0002a20000004200ULL, 0x00000018ff18723eULL, 0x000fe400030006ffULL,
0x00000019ff19723eULL, 0x000fe400030006ffULL, 0x0000001aff1a723eULL, 0x000fc400030006ffULL,
0x0000001bff1b723eULL, 0x000fe200030006ffULL, 0x000000040838723cULL, 0x040fe20000001838ULL,
0x000000000304783bULL, 0x0007220000000200ULL, 0x000031201c1c7816ULL, 0x000fe400000000ffULL,
0x000031201d1d7816ULL, 0x000fe400000000ffULL, 0x0000001cff0e723eULL, 0x000fe400020006ffULL,
0x000000180830723cULL, 0x000fe20000001830ULL, 0x0000001dff0f723eULL, 0x000fc400020006ffULL,
0x0000001cff1c723eULL, 0x000fe400030006ffULL, 0x0000001dff1d723eULL, 0x000fe400030006ffULL,
0x000031201e1e7816ULL, 0x000fe200000000ffULL, 0x0000001a083c723cULL, 0x000fe2000000183cULL,
0x000000000018783bULL, 0x000f620000004200ULL, 0x000031201f1f7816ULL, 0x000fe400000000ffULL,
0x0000001eff02723eULL, 0x002fe400020006ffULL, 0x0000001fff03723eULL, 0x008fc400020006ffULL,
0x0000000e0840723cULL, 0x000fe20000001840ULL, 0x0000001eff1e723eULL, 0x000fe400030006ffULL,
0x0000001fff1f723eULL, 0x000fca00030006ffULL, 0x0000001c0844723cULL, 0x040fe20000001844ULL,
0x0000312012127816ULL, 0x004fe400000000ffULL, 0x0000312013137816ULL, 0x000fe400000000ffULL,
0x0000312010107816ULL, 0x000fe400000000ffULL, 0x0000312011117816ULL, 0x000fe200000000ffULL,
0x000000020848723cULL, 0x040fe20000001848ULL, 0x0000000d04048232ULL, 0x090fe20000000000ULL,
0x00000010ff50723eULL, 0x080fe200020006ffULL, 0x0000000d06068232ULL, 0x000fe20000000000ULL,
0x00000011ff51723eULL, 0x080fe200020006ffULL, 0x0000000c05058232ULL, 0x080fe20000000000ULL,
0x00000010ff10723eULL, 0x000fe200030006ffULL, 0x0000000c07078232ULL, 0x000fe20000000000ULL,
0x0000001e0808723cULL, 0x000fe20000001834ULL, 0x00000011ff11723eULL, 0x000fcc00030006ffULL,
0x00000012ff34723eULL, 0x080fe200020006ffULL, 0x000000500450723cULL, 0x040fe2000000184cULL,
0x00000013ff35723eULL, 0x080fe400020006ffULL, 0x00000012ff12723eULL, 0x000fe400030006ffULL,
0x00000013ff13723eULL, 0x000fe400030006ffULL, 0x0000312018187816ULL, 0x020fe200000000ffULL,
0x000000340434723cULL, 0x000fe20000001838ULL, 0x0000312019197816ULL, 0x000fc400000000ffULL,
0x000031201a1a7816ULL, 0x000fe400000000ffULL, 0x000031201b1b7816ULL, 0x000fc600000000ffULL,
0x000000120438723cULL, 0x040fee000000183cULL, 0x00000018ff3c723eULL, 0x080fe200020006ffULL,
0x000000100454723cULL, 0x000fe20000001830ULL, 0x00000019ff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fc400030006ffULL, 0x00000019ff19723eULL, 0x000fc600030006ffULL,
0x0000003c043c723cULL, 0x040ff00000001840ULL, 0x000000180440723cULL, 0x000fee0000001844ULL,
0x0000001aff44723eULL, 0x000fc400020006ffULL, 0x0000001bff45723eULL, 0x080fe400020006ffULL,
0x0000001aff1a723eULL, 0x000fe400030006ffULL, 0x0000001bff1b723eULL, 0x000fc600030006ffULL,
0x000000440444723cULL, 0x040ff00000001848ULL, 0x0000001a0448723cULL, 0x000fe20000001808ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff027f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff317224ULL, 0x002fc600078e0003ULL,
0x0000030029297a10ULL, 0x000fc80007ffe0ffULL, 0x000000272900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff7cd000007947ULL, 0x000fea000383ffffULL,
0x00000000000e7919ULL, 0x000ee40000002500ULL, 0x000000270e00720cULL, 0x008fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e0022ULL, 0x0000927000047802ULL, 0x000fe40000000f00ULL,
0x00008ae000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000057919ULL, 0x000f240000000000ULL,
0x00000002ff077819ULL, 0x014fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x008fca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000005004507220ULL, 0x044fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000005404547220ULL, 0x040fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003c043c7220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x000fe20000410000ULL, 0x0000005205527220ULL, 0x048fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000004605467220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x000fe20000410000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x00000300ff127624ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x0000000203007812ULL, 0x002fe400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200047811ULL, 0x000fc400078ff8ffULL, 0x0000000400067811ULL, 0x044fe400078ff8ffULL,
0x00000006000a7811ULL, 0x000fe400078ff8ffULL, 0x0000000803177811ULL, 0x000fe400078ff0ffULL,
0x0000000702007812ULL, 0x100fe400078e780fULL, 0x0000000706087812ULL, 0x040fe400078e780fULL,
0x0000000706067812ULL, 0x100fe200078e7817ULL, 0x000000080f077824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7817ULL, 0x000008002c007824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e780fULL, 0x0000000817157824ULL, 0x040fe200078e0206ULL,
0x000000070a0c7812ULL, 0x000fe200078e780fULL, 0x0000000817117824ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x100fe200078e7817ULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x000000070a0a7812ULL, 0x000fe200078e7817ULL, 0x000000080f097824ULL, 0x040fe200078e0205ULL,
0x0000a00000027810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0b7824ULL, 0x000fe200078e0208ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000000817137824ULL, 0x000fe200078e0204ULL,
0x000000505104723eULL, 0x000fe200000000ffULL, 0x000000080f0f7824ULL, 0x000fe200078e020cULL,
0x000000545505723eULL, 0x000fe200000000ffULL, 0x0000000817177824ULL, 0x000fe200078e020aULL,
0x000000525308723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000541004187816ULL, 0x140fe20000000005ULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000763204197816ULL, 0x000fe20000000005ULL, 0x000000100b0d7824ULL, 0x100fe200078e0202ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x000000404105723eULL, 0x000fe200000000ffULL, 0x0000001013137824ULL, 0x000fc400078e0202ULL,
0x000000100f0f7824ULL, 0x100fe400078e0202ULL, 0x0000001015157824ULL, 0x100fe400078e0202ULL,
0x0000001017177824ULL, 0x000fe400078e0202ULL, 0x00000001070a7824ULL, 0x000fe200078e0206ULL,
0x000000383907723eULL, 0x000fe200000000ffULL, 0x00000001060b7824ULL, 0x040fe200078e0209ULL,
0x000000565709723eULL, 0x000fe200000000ffULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x000000180a007388ULL, 0x0003e20000000a00ULL, 0x0000000106117824ULL, 0x000fc400078e0211ULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106157824ULL, 0x040fe400078e0215ULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x000000343506723eULL, 0x000fe400000000ffULL, 0x00005410040a7816ULL, 0x002fe40000000005ULL,
0x0000541006187816ULL, 0x000fc40000000007ULL, 0x0000763206197816ULL, 0x000fe40000000007ULL,
0x000000444506723eULL, 0x000fe400000000ffULL, 0x000000484907723eULL, 0x000fe200000000ffULL,
0x000000180b007388ULL, 0x0003e40000000a00ULL, 0x00007632040b7816ULL, 0x002fe40000000005ULL,
0x000000363704723eULL, 0x000fe400000000ffULL, 0x0000003a3b05723eULL, 0x000fe200000000ffULL,
0x0000000a0d007388ULL, 0x0003e40000000a00ULL, 0x00005410060a7816ULL, 0x002fc40000000007ULL,
0x00007632060b7816ULL, 0x000fe40000000007ULL, 0x0000003e3f06723eULL, 0x000fe400000000ffULL,
0x000000424307723eULL, 0x000fe200000000ffULL, 0x0000000a0f007388ULL, 0x0003e40000000a00ULL,
0x00005410080a7816ULL, 0x142fe40000000009ULL, 0x00007632080b7816ULL, 0x000fe40000000009ULL,
0x000000464708723eULL, 0x000fc400000000ffULL, 0x0000004a4b09723eULL, 0x000fe200000000ffULL,
0x0000000a11007388ULL, 0x0003e40000000a00ULL, 0x00005410040a7816ULL, 0x142fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a13007388ULL, 0x0003e20000000a00ULL,
0x0000541008067816ULL, 0x000fc40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x0000000415007388ULL, 0x0003e80000000a00ULL, 0x0000000617007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000001003097824ULL, 0x040fe200078e0200ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x0000580012047a24ULL, 0x002fe200078e02ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x00000020030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000660004087a24ULL, 0x000fe200078e02ffULL,
0x00a0000009147984ULL, 0x0002e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x00a2000009187984ULL, 0x0003220000000c00ULL, 0x0000580010107a24ULL, 0x004fe200078e0205ULL,
0x00000fff08057811ULL, 0x000fc600078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x00000001040a7824ULL, 0x000fca00078e020eULL, 0x0000000a05067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x000004002c067825ULL, 0x000fcc00078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x00000010030c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08077812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x01afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff067424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008117812ULL, 0x000fe400078ec0ffULL, 0x0000000c09137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a087625ULL, 0x000fc800078e0006ULL, 0x00006c000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000813087210ULL, 0x000fc80007b5e011ULL, 0x0000000a130a7210ULL, 0x000fe40007d9e011ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000002308007986ULL, 0x0003e8000c101906ULL, 0x000000220a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x01a3e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff120b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a0010087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000800000ULL,
0x00000006ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x004ea40000000000ULL,
0x000000ff0600720cULL, 0x004fda0003f25270ULL, 0x000027a000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff177424ULL, 0x002fe200078e00ffULL, 0x0000000c080c7812ULL, 0x000fe400078ec0ffULL,
0x0000007006197812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e0017ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608067981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021200780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081200780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fe40007a3e019ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000000712087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x00000008190c7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c097810ULL, 0x040fe40007ffe0ffULL,
0x000000010c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c097810ULL, 0x042fe40007ffe0ffULL, 0x000000020c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000030c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000040c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000050c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000060c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000070c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL, 0x0000000b06067209ULL, 0x000fe40007810000ULL,
0x0000030009007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000609007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000405087211ULL, 0x000fe200078fa0ffULL, 0x00001000ff097424ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x000004002c3d7824ULL, 0x000fe200078e00ffULL,
0x00000016ff3f7819ULL, 0x000fe2000001162cULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000020030d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000003d08087210ULL, 0x000fe20007f3e0ffULL, 0x00000001040e8824ULL, 0x000fe200078e0207ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e063fULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x000010002c207824ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00006c000e0e8625ULL, 0x000fe200078e000fULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000102c158824ULL, 0x000fc400078e0203ULL,
0x00006c0004108625ULL, 0x000fc600078e0011ULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x0000000106177824ULL, 0x000fe400078e020bULL, 0x000000102c198824ULL, 0x000fe400078e0203ULL,
0x0000001003137824ULL, 0x040fe400078e0220ULL, 0x00000010030a7825ULL, 0x100fe200078e0008ULL,
0x0000418019198811ULL, 0x000fe200078e20ffULL, 0x0000000017177984ULL, 0x000e640000000800ULL,
0x000000100d0c7825ULL, 0x000fc400078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0005e2000b901c46ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000010030e8825ULL, 0x040fe400078e000eULL, 0x003800000c137faeULL, 0x0007e4000b901c46ULL,
0x0000001003108825ULL, 0x000fe400078e0010ULL, 0x000000000e158faeULL, 0x0009e4000b901c46ULL,
0x000000ffff067224ULL, 0x000fc400078e00ffULL, 0x0000000010198faeULL, 0x000be2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134357810ULL, 0x000fc80007ffe0ffULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000104367824ULL, 0x000fe200078e0235ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x00000001351f7812ULL, 0x040fe200078ec0ffULL, 0x00000800351a7824ULL, 0x000fe200078e00ffULL,
0x0000003605187211ULL, 0x000fe400078fa0ffULL, 0x00000020033b7810ULL, 0x000fe40007ffe0ffULL,
0x000008001a1d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0018187625ULL, 0x000fc800078e0019ULL,
0x00000001071b9824ULL, 0x000fe200078e0236ULL, 0x0000003d18187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1c9424ULL, 0x000fe400078e00ffULL, 0x000000022c1e9824ULL, 0x140fe400078e021fULL,
0x000000022c389824ULL, 0x000fe400078e021fULL, 0x00006c001b1a9625ULL, 0x000fc800078e001cULL,
0x00000080ff1f9424ULL, 0x000fe400078e00ffULL, 0x00000001201c7824ULL, 0x000fe400078e021dULL,
0x0000000119197824ULL, 0x000fe400000e063fULL, 0x000000081e399824ULL, 0x000fe400078e0203ULL,
0x00006c00361e9625ULL, 0x000fc600078e001fULL, 0x0000458039399811ULL, 0x000fe200078e20ffULL,
0x0000001003377824ULL, 0x040fe400078e021cULL, 0x0000000838389824ULL, 0x000fe400078e0203ULL,
0x00000010031c9825ULL, 0x000fc800078e001aULL, 0x000000103b1a7825ULL, 0x000fe200078e0018ULL,
0x00004180383b9811ULL, 0x000fc600078e20ffULL, 0x0000001003187825ULL, 0x000fc800078e0018ULL,
0x00000010031e9825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018377faeULL, 0x0005e8000b901c46ULL, 0x003800001a377faeULL, 0x0005e8000b901c46ULL,
0x000000001c399faeULL, 0x0005e8000b901c46ULL, 0x000000001e3b9faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1c7819ULL, 0x100fe20000011603ULL, 0x00000010031a7824ULL, 0x000fe200078e00ffULL,
0x00000002ff377819ULL, 0x000fe20000011603ULL, 0x000000801b187824ULL, 0x000fe200078e00ffULL,
0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL, 0x000000701a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000008371f7824ULL, 0x040fe200078e00ffULL, 0x0000008018197812ULL, 0x000fe200078ec0ffULL,
0x00000008371d7824ULL, 0x040fe200078e00ffULL, 0x00000007373e7812ULL, 0x000fe400078ec0ffULL,
0x00000037ff3c7212ULL, 0x000fe200078e33ffULL, 0x000001002c197824ULL, 0x000fe200078e0219ULL,
0xfffffff81d187812ULL, 0x000fe400078ee23eULL, 0xfffffff81f3c7812ULL, 0x000fc400078ee23cULL,
0x000000191c1a7210ULL, 0x000fe20007ffe01aULL, 0x0000000837197824ULL, 0x040fe200078e00ffULL,
0x0000000837397810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001a3a7984ULL, 0x000ea20000000800ULL, 0x00000001191c7812ULL, 0x100fe200078ef63eULL,
0x00000008391d7824ULL, 0x000fe200078e00ffULL, 0x00000002191e7812ULL, 0x140fe200078ef63eULL,
0x004580001a4c7984ULL, 0x0004e20000000800ULL, 0x0000000319347812ULL, 0x100fe200078ef63eULL,
0x0000000839407824ULL, 0x000fe200078e00ffULL, 0x0000000419367812ULL, 0x140fe400078ef63eULL,
0x0000000519387812ULL, 0x000fe400078ef63eULL, 0x00000039ff4a7212ULL, 0x000fc800078e33ffULL,
0xfffffff81d4a7812ULL, 0x000fe400078ee24aULL, 0x00000007391d7812ULL, 0x000fe200078ec0ffULL,
0x0000003a171a7221ULL, 0x006fe20000010100ULL, 0x00000006193a7812ULL, 0x000fe200078ef63eULL,
0x000008001b197824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1a1f7820ULL, 0x000fe20000410000ULL,
0x00000004031a7824ULL, 0x000fe400078e00ffULL, 0x0000080019197812ULL, 0x000fe200078ec0ffULL,
0x00000008393e7824ULL, 0x000fc400078e00ffULL, 0x0000000c1a1b7812ULL, 0x000fe200078ec0ffULL,
0x0000001f001f7308ULL, 0x000ee20000000800ULL, 0x0000018020197810ULL, 0x000fe40007ffe019ULL,
0xfffffff8401a7812ULL, 0x100fe400078ee21dULL, 0x000000013e407812ULL, 0x000fe200078ef61dULL,
0x0000001018187824ULL, 0x000fe200078e0219ULL, 0x000000033e447812ULL, 0x000fe200078ef61dULL,
0x000000101c1c7824ULL, 0x000fe200078e0219ULL, 0x000000023e427812ULL, 0x000fe200078ef61dULL,
0x0000000118187824ULL, 0x000fe200078e021bULL, 0x000000043e467812ULL, 0x000fe200078ef61dULL,
0x000000103c3c7824ULL, 0x000fe200078e0219ULL, 0x000000053e487812ULL, 0x140fe200078ef61dULL,
0x000000011b1c7824ULL, 0x040fe200078e021cULL, 0x000000063e3e7812ULL, 0x000fe200078ef61dULL,
0x0000000018187984ULL, 0x000e620000000800ULL, 0x000000011b3c7824ULL, 0x000fe200078e023cULL,
0x0000004c1f4c7220ULL, 0x008fe20000410000ULL, 0x0000001034347824ULL, 0x100fe200078e0219ULL,
0x000000001c1c7984ULL, 0x000fe20000000800ULL, 0x000000101e1e7824ULL, 0x000fe200078e0219ULL,
0x000000334c337221ULL, 0x000fe20000010000ULL, 0x000000011b347824ULL, 0x040fe200078e0234ULL,
0x000000003c3c7984ULL, 0x000ea20000000800ULL, 0x000000011b1e7824ULL, 0x000fc400078e021eULL,
0x0000001038387824ULL, 0x100fe200078e0219ULL, 0x00001f374c1f7589ULL, 0x000ee200000e0000ULL,
0x0000001036367824ULL, 0x100fe400078e0219ULL, 0x000000011b387824ULL, 0x040fe200078e0238ULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x000000011b367824ULL, 0x000fe400078e0236ULL,
0x0000001040407824ULL, 0x100fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000f220000000800ULL,
0x000000103a3a7824ULL, 0x000fc400078e0219ULL, 0x000000011b407824ULL, 0x040fe200078e0240ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x000000011b3a7824ULL, 0x040fe400078e023aULL,
0x0000001044447824ULL, 0x100fe200078e0219ULL, 0x0000000036367984ULL, 0x000f620000000800ULL,
0x0000001042427824ULL, 0x000fe400078e0219ULL, 0x000000011b447824ULL, 0x040fe200078e0244ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000011b427824ULL, 0x000fc400078e0242ULL,
0x0000001046467824ULL, 0x100fe200078e0219ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0219ULL, 0x0000001048487824ULL, 0x000fe200078e0219ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x000000011b467824ULL, 0x040fe400078e0246ULL,
0x000000011b1a7824ULL, 0x040fe200078e021aULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x000000011b487824ULL, 0x000fc400078e0248ULL, 0x000000103e3e7824ULL, 0x100fe200078e0219ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x000000104a4a7824ULL, 0x000fe400078e0219ULL,
0x000000011b3e7824ULL, 0x040fe200078e023eULL, 0x000000001a1a7984ULL, 0x000fe20000000800ULL,
0x000000011b4a7824ULL, 0x000fe400078e024aULL, 0x20000018ff197230ULL, 0x002fe20000004100ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x2000003cff1b7230ULL, 0x004fc40000004100ULL,
0x30000018ff187230ULL, 0x000fe20000004100ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x0000001f19327223ULL, 0x088fe20000010032ULL, 0x2000001cff197230ULL, 0x000fe20000004100ULL,
0x0000001f1b227223ULL, 0x080fe20000010022ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x2000001eff1b7230ULL, 0x010fe20000004100ULL, 0x0000001f18317223ULL, 0x080fe20000010031ULL,
0x0000001f19307223ULL, 0x080fe20000010030ULL, 0x00001f394c4c7589ULL, 0x000e6200000e0000ULL,
0x30000034ff197230ULL, 0x000fe20000004100ULL, 0x0000001f1b2e7223ULL, 0x000fe2000001002eULL,
0x30000036ff1b7230ULL, 0x020fc40000004100ULL, 0x20000034ff187230ULL, 0x000fe20000004100ULL,
0x0000001f192a7223ULL, 0x080fe2000001002aULL, 0x30000038ff197230ULL, 0x000fe20000004100ULL,
0x0000001f1b287223ULL, 0x080fe20000010028ULL, 0x2000003aff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f182b7223ULL, 0x080fe2000001002bULL, 0x000000ffff347224ULL, 0x000fe200078e0035ULL,
0x0000001f19267223ULL, 0x080fe20000010026ULL, 0x20000040ff197230ULL, 0x000fe20000004100ULL,
0x0000001f1b247223ULL, 0x000fe20000010024ULL, 0x3000001cff1c7230ULL, 0x000fe20000004100ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x20000042ff1b7230ULL, 0x000fc40000004100ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000001f1c2f7223ULL, 0x080fe2000001002fULL,
0x3000001eff1e7230ULL, 0x000fe40000004100ULL, 0x20000036ff1c7230ULL, 0x000fe20000004100ULL,
0x0000004c19147223ULL, 0x082fe20000010014ULL, 0x20000044ff197230ULL, 0x000fe20000004100ULL,
0x0000004c1b127223ULL, 0x080fe20000010012ULL, 0x2000001aff1d7230ULL, 0x000fe20000004100ULL,
0x0000001f3c217223ULL, 0x080fe20000010021ULL, 0x20000048ff1b7230ULL, 0x000fe20000004100ULL,
0x0000004c19107223ULL, 0x080fe20000010010ULL, 0x20000046ff197230ULL, 0x000fe20000004100ULL,
0x0000004c1d167223ULL, 0x080fe20000010016ULL, 0x20000038ff187230ULL, 0x000fe20000004100ULL,
0x0000004c1b0c7223ULL, 0x080fe2000001000cULL, 0x3000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000004c190e7223ULL, 0x080fe2000001000eULL, 0x2000003eff197230ULL, 0x000fe20000004100ULL,
0x0000001f1e2d7223ULL, 0x080fe2000001002dULL, 0x3000001aff1a7230ULL, 0x000fe20000004100ULL,
0x0000001f1c297223ULL, 0x080fe20000010029ULL, 0x30000040ff407230ULL, 0x000fe20000004100ULL,
0x0000001f18277223ULL, 0x080fe20000010027ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000001f3a237223ULL, 0x000fe20000010023ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000004c1a157223ULL, 0x080fe20000010015ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000004c40137223ULL, 0x080fe20000010013ULL, 0x30000048ff487230ULL, 0x000fe20000004100ULL,
0x0000004c42117223ULL, 0x080fe20000010011ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000004c440f7223ULL, 0x080fe2000001000fULL, 0x2000004aff1b7230ULL, 0x100fe20000004100ULL,
0x0000004c460d7223ULL, 0x080fe2000001000dULL, 0x3000004aff1d7230ULL, 0x000fe20000004100ULL,
0x0000004c480b7223ULL, 0x080fe2000001000bULL, 0x0000004c190a7223ULL, 0x080fe2000001000aULL,
0x0000004c3e097223ULL, 0x080fe20000010009ULL, 0x0000004c1b087223ULL, 0x080fe20000010008ULL,
0x0000004c1d067223ULL, 0x000fe20000010006ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000bd2000047802ULL, 0x000fe40000000f00ULL, 0x0000603000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300047308ULL, 0x000ea40000001000ULL, 0xbf80000004037423ULL, 0x004fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008033b7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff337819ULL, 0x002fe40000011603ULL, 0x0000003bff3d7212ULL, 0x000fe200078e33ffULL,
0x00001f3b04077589ULL, 0x000e6200000e0000ULL, 0x000000083b187824ULL, 0x000fc400078e00ffULL,
0x00000008333f7824ULL, 0x000fe200078e00ffULL, 0x00001f3304057589ULL, 0x0004e400000e0000ULL,
0xfffffff8183d7812ULL, 0x000fca00078ee23dULL, 0x000000103d3d7824ULL, 0x000fe200078e0202ULL,
0x00000033ff047212ULL, 0x004fc800078e33ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee204ULL,
0x0000000733047812ULL, 0x000fe200078ec0ffULL, 0x0000001607167220ULL, 0x042fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0x0000000907097220ULL, 0x040fe20000410000ULL, 0x0000000807087220ULL, 0x040fe20000410000ULL,
0x0000000607077220ULL, 0x000fe20000410000ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000002705277220ULL, 0x008fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000002605267220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000000ffULL, 0x0000003205327220ULL, 0x000fe20000410000ULL,
0x000000080707723eULL, 0x000fe200000000ffULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0xfffffff806177812ULL, 0x000fe200078ee233ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000000104067812ULL, 0x040fe200078e3cffULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000000204087812ULL, 0x040fe200078e3cffULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x00000003040a7812ULL, 0x040fe200078e3cffULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x00000004040c7812ULL, 0x040fe200078e3cffULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x00000005040e7812ULL, 0x040fe200078e3cffULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000002805287220ULL, 0x000fe20000410000ULL,
0x000000073b127812ULL, 0x000fe200078ec0ffULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000002105057220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x0000000833197824ULL, 0x000fe200078e0206ULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x00000008331b7824ULL, 0x040fe200078e0208ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x00000008331d7824ULL, 0x040fe200078e020aULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x00000008331f7824ULL, 0x040fe200078e020cULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000833277824ULL, 0x000fe200078e0204ULL,
0x0000000112047812ULL, 0x040fe200078e3cffULL, 0x000000083b147824ULL, 0x000fe200078e00ffULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x0000000833217824ULL, 0x000fe200078e020eULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x0000000403107824ULL, 0x000fe200078e00ffULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x000000083b2b7824ULL, 0x040fe200078e0204ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x000000083b337824ULL, 0x000fe200078e0206ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x000000083b357824ULL, 0x040fe200078e0208ULL,
0xfffffff814297812ULL, 0x000fe200078ee23bULL, 0x000000083b377824ULL, 0x040fe200078e020aULL,
0x0000000c10167812ULL, 0x000fe200078ec0ffULL, 0x000000083b397824ULL, 0x000fe200078e020cULL,
0x000000323131723eULL, 0x000fe200000000ffULL, 0x000000083b3b7824ULL, 0x000fe200078e020eULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x000000103f067824ULL, 0x100fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000220505723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x000fc400078e0202ULL,
0x000000101d1d7824ULL, 0x100fe400078e0202ULL, 0x0000001029297824ULL, 0x100fe400078e0202ULL,
0x0000000116047824ULL, 0x000fe400078e0217ULL, 0x000000101f1f7824ULL, 0x100fe400078e0202ULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x0000003104007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x000fc400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x0000001033337824ULL, 0x100fe400078e0202ULL, 0x0000001035357824ULL, 0x100fe400078e0202ULL,
0x0000001037377824ULL, 0x100fe400078e0202ULL, 0x0000001039397824ULL, 0x100fe400078e0202ULL,
0x000000103b3b7824ULL, 0x000fc400078e0202ULL, 0x00000001160a7824ULL, 0x040fe400078e0206ULL,
0x0000000116027824ULL, 0x040fe400078e0219ULL, 0x0000000116067824ULL, 0x040fe400078e021bULL,
0x00000001161d7824ULL, 0x040fe200078e021dULL, 0x0000002f02007388ULL, 0x0005e20000000800ULL,
0x00000001161f7824ULL, 0x040fe400078e021fULL, 0x0000000116217824ULL, 0x040fe200078e0221ULL,
0x0000002d06007388ULL, 0x0005e20000000800ULL, 0x0000000116087824ULL, 0x000fc400078e0227ULL,
0x00000001160c7824ULL, 0x040fe200078e0229ULL, 0x0000002a1d007388ULL, 0x0005e20000000800ULL,
0x00000001160e7824ULL, 0x040fe400078e022bULL, 0x0000000116047824ULL, 0x042fe200078e0233ULL,
0x000000281f007388ULL, 0x0005e20000000800ULL, 0x0000000116107824ULL, 0x040fe400078e0235ULL,
0x0000000116127824ULL, 0x040fe200078e0237ULL, 0x0000002621007388ULL, 0x0005e20000000800ULL,
0x0000000116187824ULL, 0x000fc400078e023dULL, 0x0000000116147824ULL, 0x040fe200078e0239ULL,
0x0000002308007388ULL, 0x0005e20000000800ULL, 0x0000000116167824ULL, 0x000fc600078e023bULL,
0x000000050a007388ULL, 0x0005e80000000800ULL, 0x000000150c007388ULL, 0x0005e80000000800ULL,
0x000000130e007388ULL, 0x0005e80000000800ULL, 0x0000001104007388ULL, 0x0005e80000000800ULL,
0x0000000f10007388ULL, 0x0005e80000000800ULL, 0x0000000d12007388ULL, 0x0005e80000000800ULL,
0x0000000b14007388ULL, 0x0005e80000000800ULL, 0x0000000916007388ULL, 0x0005e80000000800ULL,
0x0000000718007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002003117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000107919ULL, 0x000ea20000002600ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff067819ULL, 0x002fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000702047812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fc400078e4811ULL, 0x0ffffff804057812ULL, 0x000fe400078ef803ULL,
0x0ffffff807077812ULL, 0x000fe400078ef811ULL, 0x0000000703127812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000711007812ULL, 0x000fe400078ec0ffULL, 0x00a0000005087984ULL, 0x000e680000000c00ULL,
0x00a00000070c7984ULL, 0x0009620000000c00ULL, 0x0000000810137824ULL, 0x004fc400078e00ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff813027812ULL, 0x000fe400078ee202ULL, 0xfffffff815067812ULL, 0x000fe400078ee206ULL,
0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff812077812ULL, 0x010fe200078ef825ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0010027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0006047a11ULL, 0x000fc400078248ffULL, 0x00005b0010037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0006057a11ULL, 0x000fe400008f4c05ULL, 0x1ffffff800257812ULL, 0x000fe200078ef825ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001025047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000429037824ULL, 0x000fe400078e022cULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x000000280300720cULL, 0x000fda0003f06070ULL,
0x0000000204088824ULL, 0x004fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0203ULL,
0x0000600008088625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff0b7624ULL, 0x000fc600078e00ffULL, 0x01060000ff067f8cULL, 0x000e68000c80043fULL,
0x000000060a057981ULL, 0x000762000c1e9900ULL, 0x0000000129007810ULL, 0x000fe20007ffe0ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000402c247824ULL, 0x000fe400078e00ffULL,
0x000000270000720cULL, 0x000fe20003f06070ULL, 0x0000004063267824ULL, 0x000fc400078e00ffULL,
0x0000000402177c24ULL, 0x004fd4000f8e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000010029097824ULL, 0x00afe200078e0224ULL, 0x00000002ff1b7819ULL, 0x100fe4000001162bULL,
0x00000003ff107819ULL, 0x000fe4000001162bULL, 0x000000092a007217ULL, 0x000fe20007800000ULL,
0x0000004063637824ULL, 0x000fe200078e021bULL, 0x0000000310107812ULL, 0x000fe400078e482bULL,
0x000000300e1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a09ULL,
0x0000001063097810ULL, 0x000fc40007ffe0ffULL, 0x0000000863087810ULL, 0x000fe40007ffe0ffULL,
0x0000000917097210ULL, 0x040fe40007f5e0ffULL, 0x0000000817157210ULL, 0x040fe40007f3e0ffULL,
0x0000006317147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x00005e00090d7a11ULL, 0x000fe200078440ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0015137a11ULL, 0x000fe200078240ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005f0009117a11ULL, 0x000fc400010f4408ULL, 0x00005e00140c7a11ULL, 0x040fe400078040ffULL,
0x0000001863087810ULL, 0x000fe40007ffe0ffULL, 0x000000001b00720cULL, 0x000fe40003f66070ULL,
0x00005f0015157a11ULL, 0x000fe400008f440aULL, 0x00005f0014147a11ULL, 0x000fe400000f440bULL,
0x00000008170f7210ULL, 0x000fc40007f3e0ffULL, 0x000020002c127811ULL, 0x000fe400078e68ffULL,
0x0ffffffc102b7812ULL, 0x000fe400078ef82bULL, 0x0000002063097810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1d087210ULL, 0x000fe20007f1e0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0212ULL,
0x0000000917187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00000028630a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0614ULL,
0x00000030630b7810ULL, 0x000fc40007ffe0ffULL, 0x0000003863637810ULL, 0x000fe40007ffe0ffULL,
0x0000000a17167210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082b7faeULL, 0x0003e2000d901c46ULL, 0x0000001d130a7210ULL, 0x000fe40007f7e0ffULL,
0x0000000b17147210ULL, 0x040fe40007f1e0ffULL, 0x0000006317637210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0615ULL, 0x000000081b177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0x00005e000f0e7a11ULL, 0x000fc400078840ffULL,
0x000000001700720cULL, 0x040fe20003f66070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x00005f000f0f7a11ULL, 0x000fe400020f440cULL, 0x0000001d0d0c7210ULL, 0x000fe40007f9e0ffULL,
0x000000101b137810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc17097812ULL, 0x002fe200078ee210ULL,
0x000000ffff0d7224ULL, 0x000fe200020e0611ULL, 0x00005e0018087a11ULL, 0x040fe200078440ffULL,
0x0000000413117824ULL, 0x000fe200078e00ffULL, 0x000000181b197810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x000fe200078e0212ULL, 0x00005f0018187a11ULL, 0x000fc400010f4415ULL,
0x0000001d0e0e7210ULL, 0x000fe40007fbe0ffULL, 0x000000001300720cULL, 0x080fe20003f86070ULL,
0x0000000419137824ULL, 0x000fe200078e00ffULL, 0x000000201b157810ULL, 0x000fe20007ffe0ffULL,
0x000000000a097faeULL, 0x0003e2000d901c46ULL, 0xfffffffc11117812ULL, 0x000fe200078ee210ULL,
0x000000ffff0f7224ULL, 0x000fe200028e060fULL, 0x000000281b177810ULL, 0x000fe40007ffe0ffULL,
0x000000001900720cULL, 0x000fe20003fa6070ULL, 0x0000001011117824ULL, 0x000fe200078e0212ULL,
0xfffffffc13137812ULL, 0x000fc400078ee210ULL, 0x000000301b197810ULL, 0x000fe40007ffe0ffULL,
0x000000000c117faeULL, 0x0005e2000e101c46ULL, 0x0000000415097824ULL, 0x002fe200078e00ffULL,
0x000000381b1b7810ULL, 0x000fe20007ffe0ffULL, 0x00000004170b7824ULL, 0x000fe200078e00ffULL,
0x000000001500720cULL, 0x000fe20003f46070ULL, 0x0000001013137824ULL, 0x000fe200078e0212ULL,
0xfffffffc09097812ULL, 0x100fe400078ee210ULL, 0xfffffffc0b0b7812ULL, 0x000fc400078ee210ULL,
0x000000000e137faeULL, 0x0003e2000e901c46ULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x00000004190d7824ULL, 0x044fe200078e00ffULL, 0x000000001900720cULL, 0x080fe20003f86070ULL,
0x0000001009117824ULL, 0x000fe200078e0212ULL, 0x000000001b00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e00160a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0xfffffffc0d0d7812ULL, 0x000fe400078ee210ULL,
0x0000001d0a0a7210ULL, 0x080fe20007f3e0ffULL, 0x000000100b137824ULL, 0x102fe200078e0212ULL,
0x00005f00160b7a11ULL, 0x000fe200030f4409ULL, 0x000000100d157824ULL, 0x000fe200078e0212ULL,
0x0000001d08087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e00140c7a11ULL, 0x000fe200078040ffULL, 0x000000041b0f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200030e0618ULL, 0x00005e00630e7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x00005f00140d7a11ULL, 0x000fe400000f440dULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee210ULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x0000001d0c0c7210ULL, 0x080fe40007f1e0ffULL, 0x00005f0063007a11ULL, 0x000fe200030f4400ULL,
0x000000100f177824ULL, 0x000fe200078e0212ULL, 0x0000001d0e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000000a137faeULL, 0x0003e6000d901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200008e0600ULL, 0x000000000c157faeULL, 0x0003e8000e101c46ULL,
0x000000000e177faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x000000262b007211ULL, 0x04afe400078ff0ffULL, 0x000000082b197811ULL, 0x000fc400078ff0ffULL,
0x0000000017007210ULL, 0x000fe40007f1e0ffULL, 0x000000182b0b7811ULL, 0x040fe400078ff0ffULL,
0x000000202b0d7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0000187a11ULL, 0x000fe200078040ffULL, 0x00000001260a7824ULL, 0x040fe200078e020bULL,
0x000000282b0f7811ULL, 0x000fe200078ff0ffULL, 0x00000001260c7824ULL, 0x000fe200078e020dULL,
0x00005f0000227a11ULL, 0x000fe200000f4409ULL, 0x0000000119007824ULL, 0x000fe200078e0226ULL,
0x000000102b097811ULL, 0x040fe200078ff0ffULL, 0x0000000126107824ULL, 0x040fe200078e020fULL,
0x000000302b117811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x000000382b137811ULL, 0x000fe200078ff0ffULL, 0x0000000126087824ULL, 0x040fe200078e0209ULL,
0x00000003ff167819ULL, 0x000fe2000001162bULL, 0x0000000126127824ULL, 0x040fe200078e0211ULL,
0x0000000017207210ULL, 0x040fe20007fde0ffULL, 0x0000000126147824ULL, 0x000fe200078e0213ULL,
0x0000000817157210ULL, 0x000fe20007fbe0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x0000000a171c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x0000000c171a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000001017107210ULL, 0x000fe20007f5e0ffULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x0000001217127210ULL, 0x000fe20007f7e0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000001417147210ULL, 0x000fe20007f9e0ffULL, 0x000000040f177824ULL, 0x000fe200078e00ffULL,
0x0000000316167812ULL, 0x000fe200078e482bULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x000020002c257811ULL, 0x000fc400078e68ffULL, 0xfffffffc09087812ULL, 0x100fe400078ee216ULL,
0xfffffffc0b097812ULL, 0x100fe400078ee216ULL, 0xfffffffc170b7812ULL, 0x100fe200078ee216ULL,
0x00000010081b7824ULL, 0x000fe200078e0225ULL, 0x0ffffffc162b7812ULL, 0x000fe200078ef82bULL,
0x00000010091d7824ULL, 0x100fe200078e0225ULL, 0x00005e00201e7a11ULL, 0x040fe200078c40ffULL,
0x000000100b217824ULL, 0x000fe200078e0225ULL, 0xfffffffc19007812ULL, 0x100fe200078ee216ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0xfffffffc110c7812ULL, 0x100fe200078ee216ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f440fULL,
0x000000102b2d7824ULL, 0x100fe200078e0225ULL, 0x00005e001a117a11ULL, 0x000fe200078240ffULL,
0x0000001000197824ULL, 0x100fe200078e0225ULL, 0xfffffffc0d0a7812ULL, 0x100fe200078ee216ULL,
0x000000100c237824ULL, 0x100fe200078e0225ULL, 0x00005e001c0f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0xfffffffc130d7812ULL, 0x000fe200078ee216ULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x000000300e2b7812ULL, 0x000fe200078ec0ffULL,
0x000000100a1f7824ULL, 0x100fe200078e0225ULL, 0x00005e00150c7a11ULL, 0x000fe200078a40ffULL,
0x000000100d257824ULL, 0x000fe200078e0225ULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4409ULL,
0x000000ffff097224ULL, 0x000fe200020e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200000f440bULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005e0014167a11ULL, 0x000fc400078640ffULL,
0x000000182b087210ULL, 0x000fe40007f1e0ffULL, 0x00005f00150d7a11ULL, 0x000fe400028f4400ULL,
0x00005e0010137a11ULL, 0x000fe400078240ffULL, 0x00005e0012157a11ULL, 0x000fe400078440ffULL,
0x00005f0014007a11ULL, 0x000fe200018f4409ULL, 0x000000ffff097224ULL, 0x000fe200000e0622ULL,
0x00005f0010187a11ULL, 0x000fc400008f440bULL, 0x0000001e2b0a7210ULL, 0x040fe40007f1e0ffULL,
0x00005f0012177a11ULL, 0x000fe200010f4417ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082d7faeULL, 0x0003e2000b901c46ULL, 0x0000000c2b0c7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0620ULL, 0x0000000f2b0e7210ULL, 0x040fe40007f5e0ffULL,
0x000000112b107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000132b127210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x000000152b147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e061aULL,
0x000000162b167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0618ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400028e0617ULL,
0x000000ffff177224ULL, 0x000fe200000e0600ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x01060400ff097984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000009ff7812ULL, 0x002fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000087305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x000000202c007824ULL, 0x002fc800078e0207ULL,
0x0000002000087824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x000001e008087812ULL, 0x000fe400078ec0ffULL,
0x00000001070b7812ULL, 0x040fe400078efcffULL, 0x0000000707097812ULL, 0x100fe400078e7800ULL,
0x000000070b0b7812ULL, 0x100fe400078e7800ULL, 0x0000001007157810ULL, 0x040fe20007ffe0ffULL,
0x0000000108097824ULL, 0x040fe200078e0209ULL, 0x0000001107077810ULL, 0x000fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x0000000715157812ULL, 0x000fc400078e7800ULL,
0x0000000009107984ULL, 0x000e62000000cc00ULL, 0x0000000707077812ULL, 0x000fe400078e7800ULL,
0x0000000108157824ULL, 0x040fe200078e0215ULL, 0x000000000b0c7984ULL, 0x000ea4000000cc00ULL,
0x0000000108077824ULL, 0x000fe400078e0207ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0013ULL, 0x0000001809007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fca00078e000fULL,
0x0000001c0b007388ULL, 0x000fe8000000cc00ULL, 0x00000000070c7984ULL, 0x000e68000000cc00ULL,
0x0000000015107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002015007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff067f8cULL, 0x002fe8000c80043fULL,
0x01060400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000087305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000272900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000257919ULL, 0x000e620000000000ULL, 0x3d800000052b7820ULL, 0x020fe20000410000ULL,
0x00006400042e7a24ULL, 0x000fe200078e02ffULL, 0x000106882c2d7811ULL, 0x040fe200078e18ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0xffffffff27307810ULL, 0x000fe40007ffe0ffULL,
0x000106082c2f7811ULL, 0x000fe400078e28ffULL, 0x0000010029337824ULL, 0x008fe200078e0224ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000332a00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x034fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0031ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fc4000001ff00ULL, 0x0000000100327810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0000ULL,
0x0000000135317812ULL, 0x000fe200078e0cffULL, 0x0000000402457c24ULL, 0x020fe2000f8e02ffULL,
0x00000002ff347819ULL, 0x100fe20000011632ULL, 0x000000ffff007224ULL, 0x000fe200078e0032ULL,
0x000000043200780cULL, 0x000fc40003f06070ULL, 0x0000000332547812ULL, 0x000fe200078ec0ffULL,
0x0000030034377a24ULL, 0x000fca00078e0229ULL, 0x0000000137347810ULL, 0x000fc80007ffe0ffULL,
0x000000273400720cULL, 0x000fda0003f26070ULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff3f7819ULL, 0x002fe20000011625ULL, 0x0000010037377824ULL, 0x000fe400078e0224ULL,
0x0000000454427824ULL, 0x000fe200078e00ffULL, 0x000000083f477810ULL, 0x040fe20007ffe0ffULL,
0x000000013f327824ULL, 0x140fe200078e0226ULL, 0x000000103f4d7810ULL, 0x040fe40007ffe0ffULL,
0x000000183f4f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000147347824ULL, 0x100fe200078e0226ULL,
0x00000032453d7210ULL, 0x000fe20007f3e0ffULL, 0x000000014d367824ULL, 0x000fe200078e0226ULL,
0x000000372a327217ULL, 0x000fe20007800000ULL, 0x00000004474b7824ULL, 0x000fe200078e00ffULL,
0x0000003445397210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x0000003645347210ULL, 0x000fe20007f7e0ffULL, 0x0000000132327824ULL, 0x000fe200078e0a37ULL,
0x00005e003d367a11ULL, 0x000fe200078240ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x000000283f537810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3b7224ULL, 0x000fe200018e06ffULL,
0x00005e00343a7a11ULL, 0x000fc400078640ffULL, 0x000000303f557810ULL, 0x000fe40007ffe0ffULL,
0x00005f00343b7a11ULL, 0x000fe200018f443bULL, 0x000000014f347824ULL, 0x000fe200078e0226ULL,
0x00005e0039387a11ULL, 0x000fe400078440ffULL, 0x000000203f517810ULL, 0x040fe40007ffe0ffULL,
0x000000383f577810ULL, 0x000fe40007ffe0ffULL, 0x00005f003d377a11ULL, 0x000fe200008f443eULL,
0x00000001263d7824ULL, 0x040fe200078e0253ULL, 0x00005f0039397a11ULL, 0x000fe200010f443cULL,
0x00000001263e7824ULL, 0x040fe200078e0255ULL, 0x0000003445407210ULL, 0x000fe20007f3e0ffULL,
0x00000001263c7824ULL, 0x040fe200078e0251ULL, 0x000000323f00720cULL, 0x000fe20003f46070ULL,
0x0000000126347824ULL, 0x000fe200078e0257ULL, 0x0000003d45417210ULL, 0x040fe20007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x0000003e45437210ULL, 0x000fc40007f9e0ffULL,
0x0000003c453f7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200030e06ffULL,
0x00000003ff3e7819ULL, 0x000fe20000011625ULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x00005e00403c7a11ULL, 0x000fe400078240ffULL, 0x0000003445457210ULL, 0x000fe20007f7e0ffULL,
0x000000022c347824ULL, 0x000fe200078e0231ULL, 0x000000033e4e7812ULL, 0x000fe400078e4825ULL,
0x00005f00403d7a11ULL, 0x000fe200008f443dULL, 0x000000ffff407224ULL, 0x000fe200028e06ffULL,
0x000000324700720cULL, 0x000fe20003f26070ULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x0000200034347811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4e497812ULL, 0x100fe400078ef825ULL,
0xfffffffc42477812ULL, 0x000fe400078ee225ULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0234ULL, 0x00005e003f3e7a11ULL, 0x000fe200078a40ffULL,
0x0000001047367825ULL, 0x000fe200078e0036ULL, 0x00005e0045447a11ULL, 0x000fe400078640ffULL,
0x00005f003f3f7a11ULL, 0x000fe200028f4440ULL, 0x000000104b4b7824ULL, 0x000fe200078e0234ULL,
0x00005e0043427a11ULL, 0x000fe200078840ffULL, 0x0000001047387825ULL, 0x000fe200078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036497faeULL, 0x0003e2000d101c46ULL,
0x00005e0041407a11ULL, 0x000fc400078a40ffULL, 0x00005f0045457a11ULL, 0x000fe200018f4446ULL,
0x00000000384b7faeULL, 0x0005e2000c901c46ULL, 0x000000324d00720cULL, 0x0c0fe20003f26070ULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x000000324f00720cULL, 0x0c0fe20003f46070ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x00005f0043437a11ULL, 0x000fe400020f4448ULL,
0x000000325100720cULL, 0x0c0fe20003f66070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x00005f0041417a11ULL, 0x000fe200028f444aULL, 0x0000001047367825ULL, 0x002fe200078e003aULL,
0x000000325300720cULL, 0x000fc40003f86070ULL, 0x000000325500720cULL, 0x080fe20003fa6070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x000000325700720cULL, 0x000fe20003fc6070ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0xfffffffc4d497812ULL, 0x100fe200078ee24eULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f4b7812ULL, 0x004fe200078ee24eULL,
0x0000001047387825ULL, 0x000fe200078e003cULL, 0xfffffffc514d7812ULL, 0x100fe400078ee24eULL,
0xfffffffc534f7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0234ULL,
0xfffffffc55517812ULL, 0x000fe200078ee24eULL, 0x000000104b4b7824ULL, 0x000fe200078e0234ULL,
0xfffffffc57537812ULL, 0x000fe200078ee24eULL, 0x000000104d4d7824ULL, 0x000fe200078e0234ULL,
0x0000000036497faeULL, 0x0003e2000c901c46ULL, 0x00000010473a7825ULL, 0x000fc600078e003eULL,
0x00000000384b7faeULL, 0x0003e2000d101c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e0234ULL,
0x00000010473c7825ULL, 0x000fe200078e0040ULL, 0x000000003a4d7faeULL, 0x0003e6000d901c46ULL,
0x0000001051517824ULL, 0x000fe200078e0234ULL, 0x000000003c4f7faeULL, 0x0003e2000e101c46ULL,
0x00000010473e7825ULL, 0x000fc800078e0042ULL, 0x0000001053537824ULL, 0x000fe200078e0234ULL,
0x000000003e517faeULL, 0x0003e2000e901c46ULL, 0x0000001047407825ULL, 0x000fca00078e0044ULL,
0x0000000040537faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000000825437811ULL, 0x042fe200078ff0ffULL, 0x000000022c3c7824ULL, 0x000fe200078e0231ULL,
0x0000002625347211ULL, 0x040fe200078ff0ffULL, 0x0000000454527824ULL, 0x000fe200078e00ffULL,
0x0000001025477811ULL, 0x000fe200078ff0ffULL, 0x0000000143327824ULL, 0x040fe200078e0226ULL,
0x0000004534347210ULL, 0x080fe20007f3e0ffULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0x00000020254b7811ULL, 0x040fe400078ff0ffULL, 0x0000004532327210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00005e0034367a11ULL, 0x000fe200078240ffULL,
0x00000001263e7824ULL, 0x000fe200078e024bULL, 0x0000001825497811ULL, 0x000fe200078ff0ffULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x00005e0032387a11ULL, 0x000fe200078440ffULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0x00000028254d7811ULL, 0x000fc400078ff0ffULL,
0x00005f0032397a11ULL, 0x000fe200010f4439ULL, 0x0000000126327824ULL, 0x040fe200078e0247ULL,
0x00000030254f7811ULL, 0x040fe200078ff0ffULL, 0x0000000126407824ULL, 0x000fe200078e024dULL,
0x0000003825517811ULL, 0x000fe200078ff0ffULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0x00005f0034377a11ULL, 0x000fe200008f4437ULL, 0x0000000126347824ULL, 0x000fe200078e0249ULL,
0x00000045323b7210ULL, 0x080fe20007fde0ffULL, 0x0000000126427824ULL, 0x040fe200078e024fULL,
0x00000003ff3a7819ULL, 0x000fe20000011625ULL, 0x0000000126447824ULL, 0x000fe200078e0251ULL,
0x000000453e3f7210ULL, 0x080fe20007f9e0ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0x000020003c537811ULL, 0x000fe200078e60ffULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x00000045343d7210ULL, 0x080fe20007fbe0ffULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x000000033a3e7812ULL, 0x000fe200078e4825ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000004540417210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200030e06ffULL,
0x00005e003b3a7a11ULL, 0x000fc400078c40ffULL, 0x0000004542347210ULL, 0x080fe40007f5e0ffULL,
0x0000004544327210ULL, 0x000fe40007f7e0ffULL, 0xfffffffc43427812ULL, 0x100fe200078ee23eULL,
0x000000ffff437224ULL, 0x000fe200010e06ffULL, 0xfffffffc47447812ULL, 0x100fe200078ee23eULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0xfffffffc49467812ULL, 0x100fe200078ee23eULL,
0x0000001042477824ULL, 0x100fe200078e0253ULL, 0xfffffffc4b487812ULL, 0x100fe200078ee23eULL,
0x0000001044497824ULL, 0x100fe200078e0253ULL, 0xfffffffc4d4a7812ULL, 0x100fe200078ee23eULL,
0x00000010464b7824ULL, 0x100fe200078e0253ULL, 0xfffffffc4f4e7812ULL, 0x100fe200078ee23eULL,
0x00000010484d7824ULL, 0x000fe200078e0253ULL, 0x0ffffffc3e407812ULL, 0x000fe200078ef825ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0xfffffffc51507812ULL, 0x000fe200078ee23eULL,
0x000000ffff3e7224ULL, 0x000fe200028e06ffULL, 0x00005f003b3b7a11ULL, 0x000fe200030f443cULL,
0x0000001040577824ULL, 0x000fe200078e0253ULL, 0x00005e003d3c7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff467224ULL, 0x000fe200008e06ffULL, 0xfffffffc52557812ULL, 0x000fe200078ee225ULL,
0x000000104a4f7824ULL, 0x100fe200078e0253ULL, 0x00005f003d3d7a11ULL, 0x000fe200028f443eULL,
0x000000104e517824ULL, 0x000fe200078e0253ULL, 0x00005e003f3e7a11ULL, 0x000fe200078840ffULL,
0x0000001055367825ULL, 0x000fe200078e0036ULL, 0x00005e0041407a11ULL, 0x000fc400078240ffULL,
0x00005e0034427a11ULL, 0x000fe200078440ffULL, 0x0000001055387825ULL, 0x000fe200078e0038ULL,
0x00005e0032447a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036577faeULL, 0x0003e2000b901c46ULL, 0x00005f003f3f7a11ULL, 0x000fe200020f4448ULL,
0x00000010553a7825ULL, 0x000fe200078e003aULL, 0x00005f0041417a11ULL, 0x000fe200008f4446ULL,
0x0000000038477faeULL, 0x0003e2000b901c46ULL, 0x00005f0034437a11ULL, 0x000fe200010f4443ULL,
0x00000010553c7825ULL, 0x040fe200078e003cULL, 0x00005f0032457a11ULL, 0x000fe200018f4445ULL,
0x000000003a497faeULL, 0x0003e4000b901c46ULL, 0x00000010553e7825ULL, 0x000fc400078e003eULL,
0x000000003c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055407825ULL, 0x040fe400078e0040ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055427825ULL, 0x000fe400078e0042ULL,
0x00000000404f7faeULL, 0x0003e4000b901c46ULL, 0x0000001050537824ULL, 0x000fc400078e0253ULL,
0x0000001055447825ULL, 0x000fe200078e0044ULL, 0x0000000042517faeULL, 0x0003e8000b901c46ULL,
0x0000000044537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x00000004ff377424ULL, 0x002fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0000030037037a24ULL, 0x000fca00078e0203ULL,
0x000000280300720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x000000022e367824ULL, 0x000fc800078e0203ULL, 0x0000600036367625ULL, 0x000fca00078e0037ULL,
0x0000000636027981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002025367810ULL, 0x042fe20007ffe0ffULL,
0x000000022c377824ULL, 0x000fe200078e0235ULL, 0xfffffff825347812ULL, 0x040fe200078ec0ffULL,
0x000000084c327824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000000734417812ULL, 0x100fe400078ef825ULL,
0x0000000736427812ULL, 0x000fe400078ef825ULL, 0x0000000725367812ULL, 0x000fc400078ec0ffULL,
0x00000001ff347819ULL, 0x000fe40000011641ULL, 0x00000001ff357819ULL, 0x000fe40000011642ULL,
0x0000200037547811ULL, 0x000fe400078e60ffULL, 0x00000008364b7812ULL, 0x000fe400078ef825ULL,
0x0000000334437812ULL, 0x000fe400078ec0ffULL, 0x0000000335497812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000004043347212ULL, 0x000fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000032253c7211ULL, 0x000fc400078fe0ffULL,
0x0000004049397212ULL, 0x000fe200078e3cffULL, 0x0000000441357824ULL, 0x000fe200078e0234ULL,
0x000000073c347812ULL, 0x000fe400078e784bULL, 0x0000000140487810ULL, 0x000fe20007ffe0ffULL,
0x00000010353d7824ULL, 0x000fe200078e0254ULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000204b347824ULL, 0x000fe200078e0234ULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x0000000442397824ULL, 0x000fe200078e0239ULL, 0x000000003d44783bULL, 0x000e620000000200ULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0x000000073c3c7812ULL, 0x000fe200078e784bULL,
0x0000001039397824ULL, 0x000fe200078e0254ULL, 0x000000044000780cULL, 0x000fc40003f25270ULL,
0x0000000432327810ULL, 0x000fe20007ffe0ffULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x000000204b3c7824ULL, 0x000fc600078e023cULL, 0x000000003938783bULL, 0x000ee20000000200ULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x00000044ff3e723eULL, 0x082fe400020006ffULL,
0x00000044ff3f723eULL, 0x000fe400030006ffULL, 0x00000045ff44723eULL, 0x080fe400020006ffULL,
0x00000045ff45723eULL, 0x000fc600030006ffULL, 0x0000003e3418723cULL, 0x044fee0000001818ULL,
0x00000046ff3e723eULL, 0x080fe200020006ffULL, 0x00000044341c723cULL, 0x000fe2000000181cULL,
0x00000046ff3f723eULL, 0x000fe400030006ffULL, 0x00000047ff46723eULL, 0x000fc400020006ffULL,
0x00000047ff47723eULL, 0x000fe400030006ffULL, 0x0000004843447212ULL, 0x000fe200078e3cffULL,
0x0000003e3420723cULL, 0x000fe20000001820ULL, 0x000000003c3c783bULL, 0x000fe60000000200ULL,
0x0000000441447824ULL, 0x000fc800078e0244ULL, 0x00000010444a7824ULL, 0x000fe400078e0254ULL,
0x000000463444723cULL, 0x000fe60000001804ULL, 0x000000004a4c783bULL, 0x000e680000000200ULL,
0x0000004849077212ULL, 0x000fe400078e3cffULL, 0x00000038ff04723eULL, 0x008fc400020006ffULL,
0x00000038ff05723eULL, 0x000fe200030006ffULL, 0x0000000442077824ULL, 0x000fe200078e0207ULL,
0x00000039ff38723eULL, 0x080fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe200030006ffULL,
0x0000001007077824ULL, 0x000fe400078e0254ULL, 0x000000043408723cULL, 0x040fe60000001808ULL,
0x000000000750783bULL, 0x000ea80000000200ULL, 0x0000003aff04723eULL, 0x080fe200020006ffULL,
0x00000038340c723cULL, 0x000fe2000000180cULL, 0x0000003aff05723eULL, 0x000fc400030006ffULL,
0x0000003bff3a723eULL, 0x080fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000043410723cULL, 0x040ff00000001810ULL, 0x0000003a3414723cULL, 0x000fe20000001814ULL,
0x0000004cff04723eULL, 0x082fe400020006ffULL, 0x0000004cff05723eULL, 0x000fc400030006ffULL,
0x0000004dff4c723eULL, 0x080fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000043c18723cULL, 0x040fee0000001818ULL, 0x0000004eff04723eULL, 0x000fe200020006ffULL,
0x0000004c3c1c723cULL, 0x000fe2000000181cULL, 0x00000050ff34723eULL, 0x084fe400020006ffULL,
0x00000050ff35723eULL, 0x000fc400030006ffULL, 0x0000004eff05723eULL, 0x000fe400030006ffULL,
0x00000051ff50723eULL, 0x080fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe200030006ffULL,
0x000000343c08723cULL, 0x040fee0000001808ULL, 0x00000052ff34723eULL, 0x080fe200020006ffULL,
0x000000043c20723cULL, 0x000fe20000001820ULL, 0x00000052ff35723eULL, 0x000fc400030006ffULL,
0x00000053ff52723eULL, 0x080fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400030006ffULL,
0x0000004fff04723eULL, 0x080fe200020006ffULL, 0x000000503c0c723cULL, 0x000fe2000000180cULL,
0x0000004fff05723eULL, 0x000fce00030006ffULL, 0x000000043c04723cULL, 0x040ff00000001844ULL,
0x000000343c10723cULL, 0x040ff00000001810ULL, 0x000000523c14723cULL, 0x000fe20000001814ULL,
0xfffffb0000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff357224ULL, 0x000fe200078e0031ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb6000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d347f8cULL, 0x000fe2000c80043fULL,
0x000000192b197220ULL, 0x040fe20000410000ULL, 0x0000001e2b387220ULL, 0x040fe20000410000ULL,
0x000000182b187220ULL, 0x040fe20000410000ULL, 0x000004002d377984ULL, 0x000e620000000800ULL,
0x0000001a2b327220ULL, 0x040fe20000410000ULL, 0x0000001b2b367220ULL, 0x040fe20000410000ULL,
0x000000152b1e7220ULL, 0x040fe20000410000ULL, 0x0000001d2b1d7220ULL, 0x040fe20000410000ULL,
0x0000001f2b1f7220ULL, 0x040fe20000410000ULL, 0x000000202b207220ULL, 0x040fe20000410000ULL,
0x000000212b217220ULL, 0x040fe20000410000ULL, 0x000000112b1a7220ULL, 0x040fe20000410000ULL,
0x000000142b1b7220ULL, 0x040fe20000410000ULL, 0x000000222b227220ULL, 0x040fe20000410000ULL,
0x000000232b237220ULL, 0x040fe20000410000ULL, 0x000000062b397220ULL, 0x040fe20000410000ULL,
0x000000072b3a7220ULL, 0x040fe20000410000ULL, 0x0000000a2b3b7220ULL, 0x040fe20000410000ULL,
0x0000001c2b1c7220ULL, 0x040fe20000410000ULL, 0x000000042b047220ULL, 0x040fe20000410000ULL,
0x000000052b057220ULL, 0x040fe20000410000ULL, 0x000000082b087220ULL, 0x040fe20000410000ULL,
0x000000092b097220ULL, 0x040fe20000410000ULL, 0x0000000b2b3c7220ULL, 0x040fe20000410000ULL,
0x0000000c2b007220ULL, 0x040fe20000410000ULL, 0x0000000d2b067220ULL, 0x040fe20000410000ULL,
0x0000000e2b3d7220ULL, 0x040fe20000410000ULL, 0x0000000f2b3e7220ULL, 0x040fe20000410000ULL,
0x000000102b077220ULL, 0x040fe20000410000ULL, 0x000000122b3f7220ULL, 0x040fe20000410000ULL,
0x000000132b407220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x000000172b427220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x000000162b417220ULL, 0x000fe20000410000ULL, 0x000000ffff197224ULL, 0x000fc400078e001eULL,
0x000000ffff0d7224ULL, 0x000fe400078e001dULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff177224ULL, 0x000fe200078e001aULL,
0x8000000037ff7812ULL, 0x002fe20007804835ULL, 0x000000ffff187224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe400078e0032ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0036ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff207224ULL, 0x000fe400078e0023ULL,
0x000000ffff217224ULL, 0x000fc400078e0039ULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff107224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe400078e0005ULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fc400078e0000ULL, 0x000000ffff157224ULL, 0x000fe400078e0006ULL,
0x000000ffff167224ULL, 0x000fe400078e0007ULL, 0x000000ffff227224ULL, 0x000fe400078e003aULL,
0x000000ffff237224ULL, 0x000fe400078e003bULL, 0x000000ffff327224ULL, 0x000fe400078e003cULL,
0x000000ffff367224ULL, 0x000fc400078e003dULL, 0x000000ffff377224ULL, 0x000fe400078e003eULL,
0x000000ffff387224ULL, 0x000fe400078e003fULL, 0x000000ffff397224ULL, 0x000fe200078e0040ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0041ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0042ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004002d057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004251c7824ULL, 0x000fe200078e00ffULL, 0x000000302900720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x000000802c007824ULL, 0x000fca00078e0205ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000225087824ULL, 0x000fe400078e00ffULL, 0x000000012a337824ULL, 0x000fc600078e0a33ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108347812ULL, 0x040fe400078efcffULL,
0x00000008083c7812ULL, 0x000fe400078efcffULL, 0x000000333400720cULL, 0x080fe40003f26070ULL,
0x0000001008347812ULL, 0x000fe400078efcffULL, 0x000000333c00720cULL, 0x080fe40003f06070ULL,
0x000000333400720cULL, 0x000fc40003fc6070ULL, 0x00000011083c7812ULL, 0x040fe400078efcffULL,
0x0000001808347812ULL, 0x040fe400078efcffULL, 0x000000330800720cULL, 0x080fe40003f46070ULL,
0x000000333c00720cULL, 0x080fe40003fa6070ULL, 0x000000333400720cULL, 0x000fe40003f66070ULL,
0x00000009083e7812ULL, 0x000fc400078efcffULL, 0x00000019083c7812ULL, 0x040fe400078efcffULL,
0x0000002008347812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000333e00720cULL, 0x080fe40003f86070ULL,
0x000000333c00720cULL, 0x080fe40003f46070ULL, 0x000000333400720cULL, 0x000fe40003f26070ULL,
0x00000021083c7812ULL, 0x040fe400078efcffULL, 0x0000002808347812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000333c00720cULL, 0x080fe40003f06070ULL, 0x000000333400720cULL, 0x000fe40003f86070ULL,
0x00000029083c7812ULL, 0x000fc400078efcffULL, 0x0000003008347812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000333c00720cULL, 0x000fc40003fc6070ULL, 0x000000333400720cULL, 0x000fe40003fa6070ULL,
0x00000031083c7812ULL, 0x040fe400078efcffULL, 0x0000003808347812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000333c00720cULL, 0x080fe40003f66070ULL,
0x000000333400720cULL, 0x000fc40003f46070ULL, 0x000000330800720cULL, 0x000fe40003f26070ULL,
0xff7fffff32327808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff36367808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff37377808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff38387808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff39397808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fc40005000000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff407424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000003205057209ULL, 0x000fe40007810000ULL,
0x0000001409047209ULL, 0x000fe40007810000ULL, 0x0000003605087209ULL, 0x000fc40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000003708097209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000003809087209ULL, 0x000fe40007810000ULL,
0x0000001704057209ULL, 0x000fe40007810000ULL, 0x0000003908097209ULL, 0x000fc40007810000ULL,
0x0000001805047209ULL, 0x000fe40007810000ULL, 0x0000003a09087209ULL, 0x000fe40007810000ULL,
0x0000001904057209ULL, 0x000fe40007810000ULL, 0x0000003b08357209ULL, 0x000fe20007810000ULL,
0x00001a727f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x00000004053d7209ULL, 0x008fe20007810000ULL, 0x00001aa27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0035047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0007347f89ULL, 0x000f2200000e0000ULL, 0x0000000435087209ULL, 0x008fc60007810000ULL,
0x0c201f003d047f89ULL, 0x000ee200000e0000ULL, 0x0000000506097209ULL, 0x004fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000003407347209ULL, 0x010fc60007810000ULL,
0x0c201f00093c7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0034337f89ULL, 0x00092200000e0000ULL,
0x000000043d047209ULL, 0x008fe40007810000ULL, 0x0000000508057209ULL, 0x004fe40007810000ULL,
0x0000003c09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000087886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x0000000a00097308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010819ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3b197823ULL, 0x000fc80000010819ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000080908723eULL, 0x008fce00000000ffULL,
0x0000000c000c7308ULL, 0x000ff00000000800ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000000ffULL, 0x3c003c00ff1a7424ULL, 0x000fc400078e00ffULL,
0x3c003c00ff1b7424ULL, 0x000fc800078e00ffULL, 0x0000001d000b7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000000ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x002fce00000000ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000001a083c723cULL, 0x000fee00000018ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000000ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000000ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000001a0c3c723cULL, 0x000fee000000183cULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe200000000ffULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc25147812ULL, 0x000fc800078ec0ffULL, 0x00000014155c7219ULL, 0x000fe200000006ffULL,
0x0000003600367308ULL, 0x000fe60000000800ULL, 0x000000005c1d73a1ULL, 0x000ee200000e8000ULL,
0x000000005c0573c4ULL, 0x000f280000004000ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x000000233211723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000363713723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000085cff7c12ULL, 0x008fe2000f80401dULL, 0x0000001a103c723cULL, 0x000fec000000183cULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x0000003433077209ULL, 0x010fca0007810000ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x000000383915723eULL, 0x002fe400000000ffULL,
0x0000003a1917723eULL, 0x004fce00000000ffULL, 0x0000001a143c723cULL, 0x000fe2000000183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000015d205008947ULL, 0x000fde000b800000ULL,
0x001c1fff3c187589ULL, 0x0002a400000e0000ULL, 0x000000005c1973a1ULL, 0x000ee200000e8000ULL,
0x000000005c0573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x000000085cff7c12ULL, 0x008fda000f804019ULL, 0x000015e205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e197589ULL, 0x00072800000e0000ULL, 0x001c1fff011a7589ULL, 0x00066800000e0000ULL,
0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011625ULL,
0x0000000c1c417812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000325ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3c7824ULL, 0x042fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f327812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f347812ULL, 0x000fc400078ef61eULL,
0x000000041f367812ULL, 0x140fe400078ef61eULL, 0x000000051f387812ULL, 0x140fe400078ef61eULL,
0x000000061f3a7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x0000a0002c1d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233e7812ULL, 0x108fe400078ee21eULL, 0x000000011f407812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001032207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001036327824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000103a367824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010403a7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010423b7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001034227824ULL, 0x100fe400078e021dULL,
0x0000001038347824ULL, 0x100fe400078e021dULL, 0x00000001411f7824ULL, 0x000fe400078e021cULL,
0x000000103c387824ULL, 0x100fe400078e021dULL, 0x000000103e1c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010443c7824ULL, 0x000fc400078e021dULL,
0x00000010463d7824ULL, 0x100fe400078e021dULL, 0x00000010483e7824ULL, 0x100fe400078e021dULL,
0x000000104a3f7824ULL, 0x100fe400078e021dULL, 0x000000104c407824ULL, 0x000fe400078e021dULL,
0x00000001411d7824ULL, 0x040fe400078e021eULL, 0x0000000141217824ULL, 0x000fc400078e0220ULL,
0x0000000141237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000141337824ULL, 0x040fe400078e0232ULL, 0x0000000141357824ULL, 0x040fe200078e0234ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000141377824ULL, 0x040fe400078e0236ULL,
0x0000000141397824ULL, 0x040fe200078e0238ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001411c7824ULL, 0x000fc400078e021cULL, 0x00000001413a7824ULL, 0x040fe200078e023aULL,
0x0000001033007388ULL, 0x0007e20000000800ULL, 0x00000001411e7824ULL, 0x040fe400078e023bULL,
0x00000001413c7824ULL, 0x040fe200078e023cULL, 0x0000001235007388ULL, 0x0007e20000000800ULL,
0x0000000141087824ULL, 0x042fe400078e023dULL, 0x00000001413e7824ULL, 0x040fe200078e023eULL,
0x0000001437007388ULL, 0x0007e20000000800ULL, 0x0000000141207824ULL, 0x000fc400078e023fULL,
0x0000000141407824ULL, 0x000fe200078e0240ULL, 0x0000001639007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f3c007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x000000133e007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001740007388ULL, 0x0007e80000000800ULL,
0x0100000400008388ULL, 0x0007e80000000c00ULL, 0x0102001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002fff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030029297a10ULL, 0x000fe20007ffe0ffULL,
0x000018002fff7f8cULL, 0x0003e6000c80043fULL, 0x000000272900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffcf7000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x00010da000307802ULL, 0x000fe40000000f00ULL, 0x000011a000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e004cULL, 0xffff0a4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x00010df000307802ULL, 0x000fe40000000f00ULL,
0x0000115000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e004cULL,
0xffff0a7000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x00010e5000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000010b000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e005aULL,
0xffff0ab000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x00010eb000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fc400078e00ffULL,
0x0000105000007944ULL, 0x034fea0003c00000ULL, 0xffff0a9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x000fe200078e0004ULL, 0x00010f1000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000ff000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e005aULL,
0xffff0e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e002fULL,
0x00010f8000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000f8000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e005aULL, 0xffff0dc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x00010fe000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000f2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e005aULL, 0xffff1c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x0001105000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000eb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e005aULL,
0xffff1bc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x000110a000307802ULL, 0x000fe40000000f00ULL, 0x00000ea000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e004cULL, 0xffff29b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x000110f000307802ULL, 0x000fe40000000f00ULL,
0x00000e5000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e004cULL,
0xffff29e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x002fe200078e00ffULL,
0x0001115000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000db000007944ULL, 0x034fea0003c00000ULL, 0xffff2a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x000111b000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000d5000007944ULL, 0x030fea0003c00000ULL, 0xffff2b0000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x0001120000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000d0000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e005aULL, 0xffff2d6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x0001127000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000c9000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff627224ULL, 0x004fe200078e005aULL,
0xffff2d1000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x000112d000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fc400078e00ffULL,
0x00000c3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e005aULL,
0xffff38f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e002fULL,
0x0001134000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000bc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff687224ULL, 0x004fe200078e005aULL, 0xffff38a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x008fe40004800000ULL, 0x0001139000307802ULL, 0x000fe40000000f00ULL,
0x00000bb000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e004cULL,
0xffff461000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x000fe40004800000ULL,
0x000113e000307802ULL, 0x000fe40000000f00ULL, 0x00000b6000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e004cULL, 0xffff464000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x002fe200078e00ffULL, 0x0001144000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000ac000007944ULL, 0x034fea0003c00000ULL,
0xffff46a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e002fULL,
0x000114a000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000a6000007944ULL, 0x030fea0003c00000ULL,
0xffff476000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x000114f000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000a1000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e005aULL,
0xffff49c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e002fULL,
0x0001156000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000009a000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff627224ULL, 0x004fe200078e005aULL, 0xffff497000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x000115c000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fc400078e00ffULL, 0x0000094000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e005aULL, 0xffff555000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x0001163000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000008d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e005aULL,
0xffff550000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x0001168000307802ULL, 0x000fe40000000f00ULL, 0x000008c000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e004cULL, 0xffff627000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x000116d000307802ULL, 0x000fe40000000f00ULL,
0x0000087000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e004cULL,
0xffff62a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x004fe200078e00ffULL,
0x0001173000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000007d000007944ULL, 0x032fea0003c00000ULL, 0xffff630000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x0001179000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000077000007944ULL, 0x030fea0003c00000ULL, 0xffff63c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x000117e000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000072000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e005aULL, 0xffff662000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e002fULL, 0x0001185000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000006b000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e005aULL,
0xffff65d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x000118b000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fc400078e00ffULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e005aULL,
0xffff71e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e002fULL,
0x0001192000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e005aULL, 0xffff719000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x000fe200078e0005ULL, 0x0001198000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xffffe54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x000fe200078e0035ULL, 0x000119e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fe400078e00ffULL, 0x000004e000007944ULL, 0x024fea0003c00000ULL,
0x00000033353e7209ULL, 0x004fe20007810000ULL, 0x000000ffff337224ULL, 0x000fe200078e0006ULL,
0x00011a3000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff337224ULL, 0x000fe200078e0007ULL, 0x00011a8000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000003307347209ULL, 0x004fe20007810000ULL, 0x000000ffff337224ULL, 0x000fe200078e003dULL,
0x00011ad000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x000000333d047209ULL, 0x004fe20007810000ULL,
0x000000ffff337224ULL, 0x000fe200078e003eULL, 0x00011b2000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x000000333e057209ULL, 0x004fe20007810000ULL, 0x000000ffff337224ULL, 0x000fe200078e0006ULL,
0x00011b7000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff337224ULL, 0x000fe200078e0034ULL, 0x00011bc000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0xffffe40000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e003cULL,
0x00011c2000587802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL, 0x000002e000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xffffe9d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e003eULL, 0x00011c9000587802ULL, 0x000fe20000000f00ULL,
0x000000ffff5e7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL,
0x0000027000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e00ffULL,
0x00011ce000587802ULL, 0x000fe20000000f00ULL, 0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x004fe400078e005aULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e00ffULL, 0x00011d3000587802ULL, 0x000fe20000000f00ULL,
0x00001c1fff5d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e005aULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e005aULL,
0xffffe94000007947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003300038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff187807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000318ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000033057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000318ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003300037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffee14004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0c00003c33337389ULL, 0x0002a200000e003fULL, 0xfffee10008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff597424ULL, 0x000fe200078e00ffULL, 0x0000005c00007348ULL, 0x000fe80003800000ULL,
0x0000005e5b5a7389ULL, 0x0002a200000e005dULL, 0xfffee0c058007950ULL, 0x000fea0003c3ffffULL,
0x000000013100780cULL, 0x000fe20003f25070ULL, 0x0000006400007348ULL, 0x000fd80003800000ULL,
0x0000000000317806ULL, 0x000fc800048e0100ULL, 0x00000064314c7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff317424ULL, 0x000fc800078e00ffULL, 0xfffee06030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002b8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000898ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000928ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014b4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000014e8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001508ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001598ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000015b0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001780ULL, 0x0000000000012080ULL, 0x7a00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001598ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012268ULL, 0x0000000000012268ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 81264;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
