/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011b10ULL, 0x0000000000011690ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000010010ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000010180ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000101c0ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000010300ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001001000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x003f600400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001001000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8016288080b00828ULL, 0x0000000310288082ULL, 0x80b0920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001018000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9a08288080b00828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809a920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x000101c000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x0008120400000073ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0018310400ff1b03ULL, 0x0000f4e00000efa0ULL, 0x0000f5c00000f4f0ULL, 0x0000f5e00000f5d0ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002dffffffffULL, 0x0500002d0500002dULL, 0xffffffff0500002dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x000000f0000000c0ULL, 0x000017d000001740ULL,
0x0000187000001850ULL, 0x00001d6000001cc0ULL, 0x00002930000028e0ULL, 0x0000361000003590ULL,
0x000036b000003690ULL, 0x00003aa000003a90ULL, 0x0000452000004510ULL, 0x000051a000005120ULL,
0x0000524000005220ULL, 0x0000564000005630ULL, 0x000060b0000060a0ULL, 0x00006d1000006c90ULL,
0x00006db000006d90ULL, 0x000071b0000071a0ULL, 0x00007c5000007c40ULL, 0x0000843000008420ULL,
0x0000aa0000008bb0ULL, 0x0000b0000000ab70ULL, 0x0000b8600000b040ULL, 0x0000eeb00000ee80ULL,
0x0000eed00000eec0ULL, 0x0000ef100000eef0ULL, 0x0000ef400000ef30ULL, 0x0000f6100000f5b0ULL,
0x0000f6300000f620ULL, 0x0000fcb00000fc50ULL, 0x0000fd500000fd00ULL, 0x0000fdf00000fda0ULL,
0x0000fe900000fe40ULL, 0x0000ff500000fee0ULL, 0x0000fff00000ffa0ULL, 0x0000017005e03904ULL,
0x00010600000000ffULL, 0x000001a0003f0100ULL, 0x000106080000000fULL, 0x000001d0003f0130ULL,
0x000106100000000fULL, 0x00000230003f0130ULL, 0x000106480000000fULL, 0x00000240003f0120ULL,
0x00010658000000ffULL, 0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x00000770003f0107ULL,
0x000000040000000cULL, 0x00000880003f0102ULL, 0x000000000000000cULL, 0x00000ce0003f0101ULL,
0x00010648000000ffULL, 0x00000d60003f0107ULL, 0x00010658000000ffULL, 0x00000ed0003f0101ULL,
0x0001065c000000ffULL, 0x00000f30003f0106ULL, 0x0001065c000000ffULL, 0x00000fb0003f0106ULL,
0x0001065c000000ffULL, 0x000014f0003f0106ULL, 0x00010650000000ffULL, 0x00001560003f0107ULL,
0x0001064c000000ffULL, 0x00001580003f0106ULL, 0x0001060c000000ffULL, 0x00001680003f0106ULL,
0x0001060c000000ffULL, 0x00001ae0003f0106ULL, 0x0001064c000000ffULL, 0x00001b80003f0106ULL,
0x0001064c000000ffULL, 0x00002300003f0106ULL, 0x00010658000000ffULL, 0x00002310003f0101ULL,
0x0001065c000000ffULL, 0x00002350003f0106ULL, 0x0001065c000000ffULL, 0x000023d0003f0106ULL,
0x0001065c000000ffULL, 0x00002690003f0106ULL, 0x00010648000000ffULL, 0x00002700003f0107ULL,
0x00010654000000ffULL, 0x00002770003f0106ULL, 0x00010654000000ffULL, 0x00002810003f0106ULL,
0x00010654000000ffULL, 0x00002e80003f0106ULL, 0x00010658000000ffULL, 0x00002ef0003f0101ULL,
0x00010610000000ffULL, 0x00002f40003f0101ULL, 0x0001065c000000ffULL, 0x00002f80003f0106ULL,
0x0001065c000000ffULL, 0x00003000003f0106ULL, 0x0001065c000000ffULL, 0x000033a0003f0106ULL,
0x00010650000000ffULL, 0x00003410003f0107ULL, 0x0001064c000000ffULL, 0x00003430003f0106ULL,
0x0001061c000000ffULL, 0x00003510003f0106ULL, 0x0001061c000000ffULL, 0x00003920003f0106ULL,
0x0001064c000000ffULL, 0x000039c0003f0106ULL, 0x0001064c000000ffULL, 0x00003fc0003f0106ULL,
0x00010658000000ffULL, 0x00003fd0003f0101ULL, 0x0001065c000000ffULL, 0x00004010003f0106ULL,
0x0001065c000000ffULL, 0x00004090003f0106ULL, 0x0001065c000000ffULL, 0x00004310003f0106ULL,
0x00010648000000ffULL, 0x00004380003f0107ULL, 0x00010654000000ffULL, 0x000043d0003f0106ULL,
0x00010654000000ffULL, 0x00004460003f0106ULL, 0x00010654000000ffULL, 0x00004a50003f0106ULL,
0x00010658000000ffULL, 0x00004ac0003f0101ULL, 0x00010620000000ffULL, 0x00004b10003f0101ULL,
0x0001065c000000ffULL, 0x00004b50003f0106ULL, 0x0001065c000000ffULL, 0x00004bd0003f0106ULL,
0x0001065c000000ffULL, 0x00004f30003f0106ULL, 0x00010650000000ffULL, 0x00004fa0003f0107ULL,
0x0001064c000000ffULL, 0x00004fc0003f0106ULL, 0x0001062c000000ffULL, 0x000050a0003f0106ULL,
0x0001062c000000ffULL, 0x000054b0003f0106ULL, 0x0001064c000000ffULL, 0x00005550003f0106ULL,
0x0001064c000000ffULL, 0x00005b50003f0106ULL, 0x00010658000000ffULL, 0x00005b60003f0101ULL,
0x0001065c000000ffULL, 0x00005ba0003f0106ULL, 0x0001065c000000ffULL, 0x00005c20003f0106ULL,
0x0001065c000000ffULL, 0x00005ea0003f0106ULL, 0x00010648000000ffULL, 0x00005f10003f0107ULL,
0x00010654000000ffULL, 0x00005f60003f0106ULL, 0x00010654000000ffULL, 0x00005ff0003f0106ULL,
0x00010654000000ffULL, 0x000065e0003f0106ULL, 0x00010658000000ffULL, 0x00006650003f0101ULL,
0x00010630000000ffULL, 0x000066a0003f0101ULL, 0x0001065c000000ffULL, 0x000066e0003f0106ULL,
0x0001065c000000ffULL, 0x00006760003f0106ULL, 0x0001065c000000ffULL, 0x00006ac0003f0106ULL,
0x00010650000000ffULL, 0x00006b30003f0107ULL, 0x0001064c000000ffULL, 0x00006b50003f0106ULL,
0x0001063c000000ffULL, 0x00006c10003f0106ULL, 0x0001063c000000ffULL, 0x00007020003f0106ULL,
0x0001064c000000ffULL, 0x000070c0003f0106ULL, 0x0001064c000000ffULL, 0x000076c0003f0106ULL,
0x00010658000000ffULL, 0x000076d0003f0101ULL, 0x0001065c000000ffULL, 0x00007710003f0106ULL,
0x0001065c000000ffULL, 0x00007790003f0106ULL, 0x0001065c000000ffULL, 0x00007a40003f0106ULL,
0x00010648000000ffULL, 0x00007ab0003f0107ULL, 0x00010654000000ffULL, 0x00007b00003f0106ULL,
0x00010654000000ffULL, 0x00007b90003f0106ULL, 0x00010654000000ffULL, 0x00008180003f0106ULL,
0x00010658000000ffULL, 0x000081e0003f0101ULL, 0x00010640000000ffULL, 0x0000c9e0003f0101ULL,
0x00010604000000ffULL, 0x0000ca70003f0106ULL, 0x00010604000000ffULL, 0x0000cda0003f0106ULL,
0x00010600000000ffULL, 0x0000cdb0003f0101ULL, 0x00010604000000ffULL, 0x0000ce30003f0106ULL,
0x00010604000000ffULL, 0x0000e370003f0106ULL, 0x0001061400000039ULL, 0x0000e760003f0106ULL,
0x0001061400000039ULL, 0x0000fbb0003f0106ULL, 0x0001060800000039ULL, 0x00053803003f0101ULL,
0x0000bcc000101c04ULL, 0x0000cf500000ce80ULL, 0x000004010000fc10ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff157624ULL, 0x000fc600078e00ffULL, 0x0000000000417919ULL, 0x000ee80000002100ULL,
0x00000000003e7919ULL, 0x000f220000002700ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x108fe200078e0241ULL, 0x00000005ff417819ULL, 0x000fe20000011641ULL,
0x00001fff08007589ULL, 0x00086600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff41417589ULL, 0x000ee200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x000062003e087625ULL, 0x010fe200078e0017ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0009e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040f008388ULL, 0x0009e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0aa424ULL, 0x000fe200078e00ffULL, 0x010610060f008388ULL, 0x0009e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x0104000e0f009388ULL, 0x0009e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x0106480a0f00a388ULL, 0x0009e80000008a00ULL,
0x0106580cff00b388ULL, 0x0009e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x004fea0003800000ULL, 0x00000000000f7919ULL, 0x018e620000000000ULL,
0x0000000441027824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001015037824ULL, 0x000fc400078e00ffULL, 0x00000200ff167424ULL, 0x000fc600078e00ffULL,
0x0000000503047e24ULL, 0x000fe2000f8e023eULL, 0x000000020f057211ULL, 0x042fe200078fd8ffULL,
0x000000100f027824ULL, 0x000fc600078e00ffULL, 0x0000000705037812ULL, 0x040fe400078ec0ffULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0205ULL,
0x00000002050d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fe200078e0016ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe20007ffe0ffULL, 0x00000020050c7824ULL, 0x000fe200078e0206ULL,
0x000000070d0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0207ULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000104127824ULL, 0x000fe200078e0211ULL,
0x00000007110b7812ULL, 0x000fc400078ec0ffULL, 0x0000001f0a107812ULL, 0x100fe400078e780fULL,
0x00000013020a7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f06067812ULL, 0x100fe200078e780fULL,
0x000000200d107824ULL, 0x000fe200078e0210ULL, 0x0000001f0b147812ULL, 0x000fe200078e780fULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe400000e0603ULL,
0x00005c0005027625ULL, 0x000fc800078e0016ULL, 0x00000020070e7824ULL, 0x000fe200078e0206ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x00005c000f047625ULL, 0x000fc800078e0016ULL,
0x00005c0012067625ULL, 0x000fe200078e0016ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x0000002011147824ULL, 0x000fe200078e0214ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001014137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006080f7981ULL, 0x01aea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000e620000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff437e24ULL, 0x002fe2000f8e00ffULL, 0x0000003f0f407810ULL, 0x004fc40007ffe0ffULL,
0x000000ff0f0e7810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff407819ULL, 0x000fe40000011640ULL,
0x00000008ff0e7819ULL, 0x000fca000001160eULL, 0x0000b63000008947ULL, 0x000fea0003800000ULL,
0x00000004430d7824ULL, 0x000fe200078e00ffULL, 0x00010610410c7811ULL, 0x000fe200078e20ffULL,
0x00000003ff077424ULL, 0x000fc600078e00ffULL, 0x000000400d00720cULL, 0x000fda0003f06070ULL,
0x000064000d038a10ULL, 0x000fe20007ffe0ffULL, 0x000000023e008824ULL, 0x000fc800078e00ffULL,
0x0000640000038a24ULL, 0x000fe400078e0203ULL, 0xffffffffff007424ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000004070cff738cULL, 0x0003e20000000000ULL,
0x0000600003048625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604008981ULL, 0x0004e2000c1e1900ULL, 0x0000010043067824ULL, 0x040fe200078e00ffULL,
0x0000000143037810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000000000027919ULL, 0x000f220000000000ULL, 0x00000100ff1b7424ULL, 0x000fe200078e00ffULL,
0x000000060f077217ULL, 0x002fe20007800000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000e0300720cULL, 0x000fe20003f06070ULL, 0x0000000841037824ULL, 0x000fe200078e00ffULL,
0x000000000cff7f8cULL, 0x0003e2000c80043fULL, 0x0000000107077824ULL, 0x000fe200078e0a06ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000004015057824ULL, 0x004fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000002007067807ULL, 0x000fe20000000000ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000306067217ULL, 0x000fe20007800000ULL, 0x000000ffff1d7224ULL, 0x000fc800078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0a03ULL, 0x00000004ff077819ULL, 0x010fe20000011602ULL,
0x0000001002197824ULL, 0x000fc600078e00ffULL, 0x0000000207047810ULL, 0x040fe40007ffe0ffULL,
0x0000000407087810ULL, 0x040fe40007ffe0ffULL, 0x00000006070a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001030b7824ULL, 0x000fe200078e0204ULL, 0x000000060700720cULL, 0x080fe20003f66070ULL,
0x0000000103077824ULL, 0x040fe200078e0207ULL, 0x000000060400720cULL, 0x080fe20003f46070ULL,
0x0000000103117824ULL, 0x040fe200078e0208ULL, 0x000000060800720cULL, 0x000fe20003f26070ULL,
0x0000000103177824ULL, 0x000fe200078e020aULL, 0x0000000707097812ULL, 0x000fc400078ec0ffULL,
0x000000060a00720cULL, 0x000fe40003f06070ULL, 0x0000000f09067812ULL, 0x000fe400078e7802ULL,
0x000000070b097812ULL, 0x000fe400078ec0ffULL, 0x0000000711137812ULL, 0x000fe200078ec0ffULL,
0x0000001007147824ULL, 0x000fe200078e0206ULL, 0x0000000717157812ULL, 0x000fe400078ec0ffULL,
0x0000000f09067812ULL, 0x000fc400078e7802ULL, 0x0000000f13087812ULL, 0x100fe400078e7802ULL,
0x0000000f15127812ULL, 0x000fe200078e7802ULL, 0x000000100b157824ULL, 0x000fe200078e0206ULL,
0x000000f019197812ULL, 0x000fe200078ec0ffULL, 0x0000001011167824ULL, 0x000fc600078e0208ULL,
0x0000c00015157811ULL, 0x000fe200078e20ffULL, 0x0000000400047e24ULL, 0x008fca000f8e0205ULL,
0x0000003f04077812ULL, 0x040fe400078ef807ULL, 0x0000003f04087812ULL, 0x040fe400078ef80bULL,
0x0000003f040a7812ULL, 0x040fe200078ef811ULL, 0x00005e0007067625ULL, 0x000fe200078e001bULL,
0x0000003f04107812ULL, 0x000fc600078ef817ULL, 0x0000001017047824ULL, 0x000fe200078e0212ULL,
0x0000001906127210ULL, 0x000fe20007fbe0ffULL, 0x00005e0008087625ULL, 0x000fe200078e001bULL,
0x0000c00016177811ULL, 0x000fc600078e20ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e001bULL,
0x0000001908087210ULL, 0x000fc60007f9e0ffULL, 0x00005e0010107625ULL, 0x000fc800078e001bULL,
0x000000ffff137224ULL, 0x000fe200028e0607ULL, 0x000000190a0a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x0000001910107210ULL, 0x000fe20007fde0ffULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000c00014077811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x0000c00004197811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012077faeULL, 0x0003e2000d901c46ULL, 0xff317217ff047424ULL, 0x000fc600078e00ffULL,
0x0000000008157faeULL, 0x0003e8000d101c46ULL, 0x000000000a177faeULL, 0x0003e2000c901c46ULL,
0x0000000e4300720cULL, 0x000fc60003f26070ULL, 0x0000000010197faeULL, 0x0003e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000746000001947ULL, 0x000fea0003800000ULL, 0x000000023e097824ULL, 0x000fe200078e00ffULL,
0x00007610ff6b7816ULL, 0x000fe2000000006bULL, 0x00006400ff087624ULL, 0x000fc400078e00ffULL,
0x0000000441077824ULL, 0x000fe400078e00ffULL, 0x0000640009087624ULL, 0x000fe200078e0208ULL,
0x00007610ff097816ULL, 0x000fe20000000009ULL, 0xff317217ff047424ULL, 0x000fe200078e00ffULL,
0x00000002070b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00000100430a7824ULL, 0x000fca00078e00ffULL, 0x0000000f0a00720cULL, 0x000fda0003f06070ULL,
0x0000734000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000ffff6a7224ULL, 0x000fe200078e000dULL, 0x000076106b0a7816ULL, 0x000fe2000000000aULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000300ff107624ULL, 0x000fe200078e00ffULL,
0x000000030d117812ULL, 0x000fe200078ec0ffULL, 0x00000004002c7e24ULL, 0x000fe2000f8e0205ULL,
0x00000004ff3c7819ULL, 0x000fe20000011602ULL, 0xffffffffff007424ULL, 0x000fe200078e00ffULL,
0x000000031100780cULL, 0x000fe40003f05270ULL, 0xfffffffd10107811ULL, 0x000fc800078e10ffULL,
0x0000000110107807ULL, 0x000fca0004000000ULL, 0x000000010d0d7824ULL, 0x000fca00078e0210ULL,
0x000000400d00720cULL, 0x000fe40003f06070ULL, 0x0000002043127811ULL, 0x000fe400078e40ffULL,
0x000000023c4a7810ULL, 0x040fe40007ffe0ffULL, 0x000000043c487810ULL, 0x000fe40007ffe0ffULL,
0x000000120f2d7217ULL, 0x000fca0007800000ULL, 0x000000010d108824ULL, 0x000fe400078e0208ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0x000000063c467810ULL, 0x000fe20007ffe0ffULL,
0x00000001034b7824ULL, 0x000fe400078e023cULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x0000000143137810ULL, 0x000fc60007ffe0ffULL, 0x0000000103477824ULL, 0x040fe200078e024aULL,
0x0000000610008981ULL, 0x000362000c1e1900ULL, 0x0000000103457824ULL, 0x000fe200078e0248ULL,
0x0000000e1300720cULL, 0x000fe20003f06070ULL, 0x000000012d2d7824ULL, 0x000fe200078e0a12ULL,
0x000000202c137810ULL, 0x000fe20007ffe0ffULL, 0x0000000103447824ULL, 0x000fe200078e0246ULL,
0x0000003f4b607812ULL, 0x000fe200078ec0ffULL, 0x0000001002387824ULL, 0x000fe200078e00ffULL,
0x0000003f475f7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x0000003f455e7812ULL, 0x000fe200078ec0ffULL, 0x0000000160107824ULL, 0x102fe200078e0213ULL,
0x000000202d127807ULL, 0x000fe20000000000ULL, 0x000000015f2c7824ULL, 0x100fe200078e0213ULL,
0x0000003f445d7812ULL, 0x000fe200078ec0ffULL, 0x000000015e2e7824ULL, 0x000fe200078e0213ULL,
0x00000012033a7217ULL, 0x000fe20007800000ULL, 0x00005e0010107625ULL, 0x000fe200078e003dULL,
0x000000f038497812ULL, 0x000fc600078ec0ffULL, 0x000000015d3b7824ULL, 0x000fe200078e0213ULL,
0x0000004910127210ULL, 0x000fe20007f3e0ffULL, 0x00005e002c2c7625ULL, 0x000fc800078e003dULL,
0x00005e002e2e7625ULL, 0x000fe200078e003dULL, 0x000000492c107210ULL, 0x000fc60007f5e0ffULL,
0x000000013a397824ULL, 0x000fe200078e0a03ULL, 0x000000492e2c7210ULL, 0x000fe20007f7e0ffULL,
0x00005e003b3a7625ULL, 0x000fe200078e003dULL, 0x000000074b3d7812ULL, 0x000fe400078ec0ffULL,
0x000000394600720cULL, 0x000fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200008e0611ULL,
0x000000493a2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200010e062dULL,
0x000000393c00720cULL, 0x080fe20003f26070ULL, 0x000000ffff2d7224ULL, 0x000fe200018e062fULL,
0x000000394a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff2f7224ULL, 0x000fe200028e063bULL,
0x000000394800720cULL, 0x000fc40003f66070ULL, 0x0000000f3d3a7812ULL, 0x000fe400078e7802ULL,
0x0000000747397812ULL, 0x000fe400078ec0ffULL, 0x00000007453b7812ULL, 0x000fe200078ec0ffULL,
0x000000104b557824ULL, 0x000fe200078e023aULL, 0x00000007443d7812ULL, 0x000fe400078ec0ffULL,
0x0000000f39547812ULL, 0x100fe400078e7802ULL, 0x0000000f3b3a7812ULL, 0x000fc400078e7802ULL,
0x0000000f3d3d7812ULL, 0x000fe200078e7802ULL, 0x0000001047547824ULL, 0x000fe200078e0254ULL,
0x0000e00055677811ULL, 0x000fe200078e20ffULL, 0x0000001045537824ULL, 0x000fe400078e023aULL,
0x0000001044527824ULL, 0x000fe200078e023dULL, 0x0000e00054667811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012677faeULL, 0x0003e2000c901c46ULL,
0x0000e00053657811ULL, 0x000fe400078e20ffULL, 0x0000e00052647811ULL, 0x000fe200078e20ffULL,
0x0000000010667faeULL, 0x0003e8000d101c46ULL, 0x000000002c657faeULL, 0x0003e8000d901c46ULL,
0x000000002e647faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff137984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff127984ULL, 0x000ea20000000800ULL, 0x0000ffff6b107812ULL, 0x000fc400078ec0ffULL,
0x0000ffff09117812ULL, 0x000fe400078ec0ffULL, 0x00008880102d7816ULL, 0x000fe400000000ffULL,
0x0000888011617816ULL, 0x000fc600000000ffULL, 0x800000002d107824ULL, 0x000fe400078e00ffULL,
0x8000000061117824ULL, 0x000fc600078e00ffULL, 0x8000000013ff7812ULL, 0x002fe40007824810ULL,
0x8000000012ff7812ULL, 0x004fe20007844811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000061127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01060c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff107819ULL, 0x000fe20000011602ULL, 0x00000001ff2c7424ULL, 0x000fe200078e00ffULL,
0x0000007038637812ULL, 0x000fe400078ec0ffULL, 0x0000000c10107812ULL, 0x000fca00078ec0ffULL,
0x0000000163637824ULL, 0x000fca00078e0210ULL, 0x0100000063117984ULL, 0x000e680000000800ULL,
0x0102000063137984ULL, 0x0004e20000000800ULL, 0x000000041100720bULL, 0x002fda0003f5d000ULL,
0x0000000000107806ULL, 0x000fc800010e0100ULL, 0x0000ffff102e7812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000041100720bULL, 0x00cfe40003f54000ULL,
0x0000001104387209ULL, 0x000fe40007810000ULL, 0x00000002ff127819ULL, 0x000fc60000011602ULL,
0x8000003804107221ULL, 0x000fe20000010000ULL, 0x00000008122c7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000047806ULL, 0x000fe400010e0100ULL,
0x0000001000397308ULL, 0x000e620000000800ULL, 0x000000ff4100720cULL, 0x000fe40003f45270ULL,
0x0000ffff042f7812ULL, 0x000fe200078e3cffULL, 0x000000ffff047224ULL, 0x000fc600078e0038ULL,
0x0000002f2eff7212ULL, 0x000fce000786c0ffULL, 0x010400386300a388ULL, 0x000fe20000000800ULL,
0x0000003906067220ULL, 0x002fc60000410000ULL, 0x00001f2c392c7589ULL, 0x000e6400000e0000ULL,
0x8000003811113221ULL, 0x000fe40000010000ULL, 0x00001f1239127589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b11113820ULL, 0x000fc80000410000ULL, 0x00000011000c3308ULL, 0x000ee20000000800ULL,
0x0000002c2b2b7220ULL, 0x082fe20000410000ULL, 0x0000002c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000002c27277220ULL, 0x080fe20000410000ULL, 0x0000002c26267220ULL, 0x080fe20000410000ULL,
0x0000002c23237220ULL, 0x080fe20000410000ULL, 0x0000002c22227220ULL, 0x080fe20000410000ULL,
0x0000002c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002c17177220ULL, 0x080fe20000410000ULL, 0x0000002c16167220ULL, 0x080fe20000410000ULL,
0x0000002c37377220ULL, 0x080fe20000410000ULL, 0x0000002c36367220ULL, 0x080fe20000410000ULL,
0x0000002c33337220ULL, 0x080fe20000410000ULL, 0x0000002c32327220ULL, 0x000fe20000410000ULL,
0x00000001ff2c7807ULL, 0x000fe20001800000ULL, 0x0000001229297220ULL, 0x084fe20000410000ULL,
0x0000001228287220ULL, 0x080fe20000410000ULL, 0x0000001225257220ULL, 0x080fe20000410000ULL,
0x0000001224247220ULL, 0x080fe20000410000ULL, 0x0000001221217220ULL, 0x080fe20000410000ULL,
0x0000001220207220ULL, 0x080fe20000410000ULL, 0x000000121d1d7220ULL, 0x080fe20000410000ULL,
0x000000121c1c7220ULL, 0x080fe20000410000ULL, 0x0000001219197220ULL, 0x080fe20000410000ULL,
0x0000001218187220ULL, 0x080fe20000410000ULL, 0x0000001215157220ULL, 0x080fe20000410000ULL,
0x0000001214147220ULL, 0x080fe20000410000ULL, 0x0000001235357220ULL, 0x080fe20000410000ULL,
0x0000001234347220ULL, 0x080fe20000410000ULL, 0x0000001231317220ULL, 0x080fe20000410000ULL,
0x0000001230307220ULL, 0x000fe20000410000ULL, 0x0000000c13133220ULL, 0x008fc80000410000ULL,
0x0000000613067221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff107984ULL, 0x000e620000000800ULL, 0x800000002d117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007824811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000002d127824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01064c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000802117812ULL, 0x040fe400078ec0ffULL, 0x0000000702577812ULL, 0x040fe400078ec0ffULL,
0x0000000702567211ULL, 0x000fe400078fe0ffULL, 0x00000007112f7812ULL, 0x100fe400078ec802ULL,
0x00000004ff5c7819ULL, 0x100fe40000011602ULL, 0x0000000857577812ULL, 0x000fc400078ef802ULL,
0x0000000711597812ULL, 0x000fe400078ef802ULL, 0x000000562f567212ULL, 0x000fe400078e3cffULL,
0x000000075c5c7812ULL, 0x000fe400078e7857ULL, 0x0000000cff2d723eULL, 0x000fe200000000ffULL,
0x0000001059587824ULL, 0x000fe200078e0256ULL, 0x00000002ff3c7819ULL, 0x000fe20000011602ULL,
0x00000008575c7824ULL, 0x000fe200078e025cULL, 0x000054102d3d7816ULL, 0x000fc4000000002dULL,
0x0000c00058627811ULL, 0x000fe400078e20ffULL, 0x0000a0005c107811ULL, 0x000fe200078e20ffULL,
0x00001f3c3d517589ULL, 0x000fe200000e0000ULL, 0x000099102c2d7816ULL, 0x000fe400000000ffULL,
0x0000000b022c7211ULL, 0x000fe200078fe0ffULL, 0x000000006238783bULL, 0x000e620000004200ULL,
0x000000083c427810ULL, 0x000fe40007ffe0ffULL, 0x0000002c2f687212ULL, 0x000fe200078e3cffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x000000ff2d00720cULL, 0x000fc40003f25270ULL,
0x000000074a5a7812ULL, 0x000fe200078e7857ULL, 0x0000001059507824ULL, 0x040fe200078e0268ULL,
0x00001f423d4e7589ULL, 0x00072200000e0000ULL, 0x0000010059597811ULL, 0x000fe400078e20ffULL,
0x00000008575a7824ULL, 0x000fe200078e025aULL, 0x0000c000505b7811ULL, 0x000fe400078e20ffULL,
0x0000000168687824ULL, 0x100fe400078e0259ULL, 0x0000000156567824ULL, 0x000fe200078e0259ULL,
0x000000005b2c783bULL, 0x000f240000004200ULL, 0x0000c000684f7811ULL, 0x000fc400078e20ffULL,
0x0000c00056597811ULL, 0x000fe400078e20ffULL, 0x0000312038387816ULL, 0x002fe400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x00000038ff3c723eULL, 0x080fe200020006ffULL,
0x0000005110109232ULL, 0x084fe20000000000ULL, 0x00000039ff3d723eULL, 0x088fe200020006ffULL,
0x0000005112129232ULL, 0x000fe20000000000ULL, 0x00000038ff38723eULL, 0x000fe200030006ffULL,
0x0000004e11119232ULL, 0x090fe20000000000ULL, 0x00000039ff39723eULL, 0x000fe200030006ffULL,
0x0000004e13139232ULL, 0x000fe20000000000ULL, 0x000031203a4c7816ULL, 0x000fc400000000ffULL,
0x000031203b4d7816ULL, 0x000fc800000000ffULL, 0x000000381034723cULL, 0x040fe20000001834ULL,
0x000031202c697816ULL, 0x000fe400000000ffULL, 0x000031202d6c7816ULL, 0x000fe400000000ffULL,
0x00000069ff2c723eULL, 0x000fe400020006ffULL, 0x0000004cff38723eULL, 0x000fe200020006ffULL,
0x0000003c1030723cULL, 0x000fe20000001830ULL, 0x0000004dff39723eULL, 0x000fe400020006ffULL,
0x0000006cff2d723eULL, 0x000fc400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400030006ffULL,
0x0000a0005a3c7811ULL, 0x000fe200078e20ffULL, 0x000000381014723cULL, 0x000fe20000001814ULL,
0x000000004f38783bULL, 0x000e620000004200ULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000003c3c783bULL, 0x000ea60000000200ULL, 0x0000002c101c723cULL, 0x040fee000000181cULL,
0x00000069ff2c723eULL, 0x000fe200030006ffULL, 0x0000004c1018723cULL, 0x000fe20000001818ULL,
0x0000006cff2d723eULL, 0x000fc400030006ffULL, 0x000031202e697816ULL, 0x000fe400000000ffULL,
0x000031202f6c7816ULL, 0x000fe400000000ffULL, 0x00000069ff4c723eULL, 0x000fe200020006ffULL,
0x0000002c1020723cULL, 0x000fe20000001820ULL, 0x00000000592c783bULL, 0x000ee20000004200ULL,
0x0000006cff4d723eULL, 0x000fce00020006ffULL, 0x0000004c1024723cULL, 0x040fee0000001824ULL,
0x00000069ff4c723eULL, 0x000fe400030006ffULL, 0x0000006cff4d723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x000000513c3c9232ULL, 0x084fe20000000000ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x000000513e3e9232ULL, 0x000fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x0000004c1010723cULL, 0x000fe20000001828ULL,
0x0000004e3d3d9232ULL, 0x080fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000004e3f3f9232ULL, 0x000fc80000000000ULL, 0x00000038ff28723eULL, 0x000fe400020006ffULL,
0x00000039ff29723eULL, 0x000fce00020006ffULL, 0x000000283c1c723cULL, 0x000fe2000000181cULL,
0x000031202c2c7816ULL, 0x008fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x000031202e2e7816ULL, 0x000fe400000000ffULL, 0x00000038ff28723eULL, 0x000fe400030006ffULL,
0x00000039ff29723eULL, 0x000fe400030006ffULL, 0x000031202f2f7816ULL, 0x000fca00000000ffULL,
0x000000283c20723cULL, 0x000fee0000001820ULL, 0x0000003aff28723eULL, 0x000fe400020006ffULL,
0x0000003bff29723eULL, 0x000fce00020006ffULL, 0x000000283c24723cULL, 0x000fee0000001824ULL,
0x0000002cff28723eULL, 0x000fe400020006ffULL, 0x0000002dff29723eULL, 0x000fce00020006ffULL,
0x000000283c30723cULL, 0x000fee0000001830ULL, 0x0000002cff28723eULL, 0x000fe400030006ffULL,
0x0000002dff29723eULL, 0x000fce00030006ffULL, 0x000000283c34723cULL, 0x000fee0000001834ULL,
0x0000002eff28723eULL, 0x000fe400020006ffULL, 0x0000002fff29723eULL, 0x000fce00020006ffULL,
0x000000283c14723cULL, 0x000fee0000001814ULL, 0x0000002eff28723eULL, 0x000fe400030006ffULL,
0x0000002fff29723eULL, 0x000fce00030006ffULL, 0x000000283c18723cULL, 0x000fee0000001818ULL,
0x0000003aff28723eULL, 0x000fe400030006ffULL, 0x0000003bff29723eULL, 0x000fce00030006ffULL,
0x000000283c3c723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000004043107811ULL, 0x000fe200078e40ffULL,
0x00000004002e7e24ULL, 0x020fe2000f8e0205ULL, 0x00000004ff2c7819ULL, 0x000fc40000011602ULL,
0x000000100f117217ULL, 0x000fe40007800000ULL, 0x0000003f2e2a7812ULL, 0x040fe400078ef84bULL,
0x0000003f2e287812ULL, 0x040fe200078ef847ULL, 0x0000000111117824ULL, 0x000fe200078e0a10ULL,
0x0000003f2e127812ULL, 0x000fe400078ef845ULL, 0x0000c00055557811ULL, 0x000fe400078e20ffULL,
0x0000002011107807ULL, 0x000fe20000000000ULL, 0x00000100ff117424ULL, 0x000fe200078e00ffULL,
0x0000c00054547811ULL, 0x000fc400078e20ffULL, 0x0000001003107217ULL, 0x000fe20007800000ULL,
0x00005e002a2a7625ULL, 0x080fe200078e0011ULL, 0x0000c00053537811ULL, 0x000fe400078e20ffULL,
0x0000c00052527811ULL, 0x000fe200078e20ffULL, 0x00005e0028287625ULL, 0x000fe200078e0011ULL,
0x000000492a2a7210ULL, 0x000fc60007f7e0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0011ULL,
0x0000004928287210ULL, 0x000fc60007f9e0ffULL, 0x00000001102d7824ULL, 0x000fe200078e0a03ULL,
0x0000003f2e107812ULL, 0x000fe200078ef844ULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x0000004912127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x0000002d2c00720cULL, 0x000fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fe200078e0011ULL,
0x0000002d4a00720cULL, 0x080fe40003f66070ULL, 0x0000002d4800720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000002d4600720cULL, 0x000fc40003fa6070ULL,
0x0000004910107210ULL, 0x000fca0007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a557faeULL, 0x0003e8000d101c46ULL,
0x0000000028547faeULL, 0x0003e8000d901c46ULL, 0x0000000012537faeULL, 0x0003e8000e101c46ULL,
0x0000000010527faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff117984ULL, 0x002e620000000800ULL, 0x0000ffff6b107812ULL, 0x000fc800078ec0ffULL,
0x0000888010127816ULL, 0x000fca00000000ffULL, 0x8000000012107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x01065400ff117984ULL, 0x000e620000000800ULL,
0x8000000012107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe20007844810ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000012117824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x01065400ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000748107812ULL, 0x000fe400078e7857ULL,
0x0000e00058587811ULL, 0x000fe400078e20ffULL, 0x0000000cff2c723eULL, 0x000fe200000000ffULL,
0x0000000857517824ULL, 0x000fe200078e0210ULL, 0x00000002ff697819ULL, 0x000fe20000011602ULL,
0x000000005828783bULL, 0x000e620000004200ULL, 0x000054102c3a7816ULL, 0x000fe4000000002cULL,
0x0000a00051107811ULL, 0x000fc400078e20ffULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x00001f693a697589ULL, 0x000fe200000e0000ULL, 0x00000007464e7812ULL, 0x000fe400078e7857ULL,
0x0000e000564d7811ULL, 0x000fe200078e20ffULL, 0x000000001010783bULL, 0x000ea40000000200ULL,
0x00000008574e7824ULL, 0x000fe400078e024eULL, 0x00001f423a6c7589ULL, 0x000ee800000e0000ULL,
0x00000000502c783bULL, 0x000f220000004200ULL, 0x0000312028287816ULL, 0x002fc400000000ffULL,
0x0000312029297816ULL, 0x000fe400000000ffULL, 0x00000028ff38723eULL, 0x080fe400020006ffULL,
0x00000029ff39723eULL, 0x080fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000006910109232ULL, 0x084fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000006912129232ULL, 0x000fe20000000000ULL, 0x000031202a4c7816ULL, 0x000fe200000000ffULL,
0x0000006c11119232ULL, 0x088fe20000000000ULL, 0x000031202b6d7816ULL, 0x000fe200000000ffULL,
0x0000006c13139232ULL, 0x000fe20000000000ULL, 0x0000a0004e2a7811ULL, 0x000fc400078e20ffULL,
0x0000004cff56723eULL, 0x080fe400030006ffULL, 0x0000006dff57723eULL, 0x080fe400030006ffULL,
0x000000281034723cULL, 0x040fee0000001834ULL, 0x0000004cff28723eULL, 0x000fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x0000006dff29723eULL, 0x000fe200020006ffULL,
0x000000004d38783bULL, 0x000e620000004200ULL, 0x000031202c4c7816ULL, 0x010fc400000000ffULL,
0x000031202d6d7816ULL, 0x000fe400000000ffULL, 0x0000004cff2c723eULL, 0x000fe200020006ffULL,
0x000000281014723cULL, 0x000fe20000001814ULL, 0x000000002a28783bULL, 0x000ea20000000200ULL,
0x0000006dff2d723eULL, 0x000fcc00020006ffULL, 0x000000561018723cULL, 0x040fee0000001818ULL,
0x000031202e567816ULL, 0x000fe200000000ffULL, 0x0000002c101c723cULL, 0x000fe2000000181cULL,
0x000031202f577816ULL, 0x000fcc00000000ffULL, 0x0000004cff2c723eULL, 0x000fe400030006ffULL,
0x0000006dff2d723eULL, 0x000fe400030006ffULL, 0x0000e000684c7811ULL, 0x000fca00078e20ffULL,
0x0000002c1020723cULL, 0x040fe20000001820ULL, 0x0000312038687816ULL, 0x002fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x00000068ff38723eULL, 0x000fe400020006ffULL,
0x00000056ff2c723eULL, 0x080fe200020006ffULL, 0x0000006928289232ULL, 0x084fe20000000000ULL,
0x00000057ff2d723eULL, 0x000fe200020006ffULL, 0x000000692a2a9232ULL, 0x000fe20000000000ULL,
0x0000312039697816ULL, 0x000fe200000000ffULL, 0x0000006c29299232ULL, 0x080fe20000000000ULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x0000006c2b2b9232ULL, 0x000fe20000000000ULL,
0x00000069ff39723eULL, 0x000fe200020006ffULL, 0x0000002c1024723cULL, 0x000fe20000001824ULL,
0x000000004c2c783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fc400030006ffULL,
0x00000057ff57723eULL, 0x000fc800030006ffULL, 0x000000382830723cULL, 0x000fee0000001830ULL,
0x00000068ff38723eULL, 0x000fe200030006ffULL, 0x000000561010723cULL, 0x000fe2000000183cULL,
0x00000069ff39723eULL, 0x000fce00030006ffULL, 0x000000382834723cULL, 0x000fee0000001834ULL,
0x0000003aff38723eULL, 0x000fe400020006ffULL, 0x0000003bff39723eULL, 0x000fce00020006ffULL,
0x000000382814723cULL, 0x000fe20000001814ULL, 0x000031202e2e7816ULL, 0x002fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fc800000000ffULL, 0x0000003aff38723eULL, 0x000fe400030006ffULL,
0x0000003bff39723eULL, 0x000fe400030006ffULL, 0x000031202c3a7816ULL, 0x000fe400000000ffULL,
0x000031202d3b7816ULL, 0x000fe400000000ffULL, 0x0000003aff2c723eULL, 0x000fe200020006ffULL,
0x000000382818723cULL, 0x000fe20000001818ULL, 0x0000003bff2d723eULL, 0x000fce00020006ffULL,
0x0000002c281c723cULL, 0x000fee000000181cULL, 0x0000003aff2c723eULL, 0x000fe400030006ffULL,
0x0000003bff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2820723cULL, 0x000fee0000001820ULL,
0x0000002eff2c723eULL, 0x000fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2824723cULL, 0x000fee0000001824ULL, 0x0000002eff2c723eULL, 0x000fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004043107811ULL, 0x000fe200078e40ffULL, 0x01061000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff6bff7812ULL, 0x000fe4000782c0ffULL, 0x000000100f00720cULL, 0x000fe40003f44070ULL,
0x00000001ff6b7807ULL, 0x000fd60000800000ULL, 0x000052d00000a947ULL, 0x000fea0003800000ULL,
0x01065c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000004ff137424ULL, 0x000fe200078e00ffULL, 0x000000036a117812ULL, 0x000fe200078ec0ffULL,
0x00000300ff107624ULL, 0x000fe400078e00ffULL, 0x00000004002c7e24ULL, 0x000fe2000f8e0205ULL,
0x000000031100780cULL, 0x000fe20003f25270ULL, 0xfffffffd130d7424ULL, 0x000fe200078e0210ULL,
0xfffffffd10697811ULL, 0x000fe200078e10ffULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000010d0d7807ULL, 0x000fca0004800000ULL, 0x000000016a6a7824ULL, 0x000fca00078e020dULL,
0x000000036a0d7812ULL, 0x000fc800078ec0ffULL, 0x000000030d00780cULL, 0x000fc80003f25270ULL,
0x0000000169697807ULL, 0x000fca0004800000ULL, 0x000000016a0d7824ULL, 0x000fca00078e0269ULL,
0x000000400d00720cULL, 0x000fe40003f26070ULL, 0x0000006043107811ULL, 0x000fc800078e40ffULL,
0x000000100f117217ULL, 0x000fca0007800000ULL, 0x0000000111117824ULL, 0x000fe400078e0a10ULL,
0x0000006908129210ULL, 0x000fe40007ffe06aULL, 0x000000202c2f7810ULL, 0x000fc60007ffe0ffULL,
0x0000600012129625ULL, 0x000fe200078e0013ULL, 0x00000020112c7807ULL, 0x000fc60000000000ULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000612009981ULL, 0x000362000c1e1900ULL,
0x0000000160107824ULL, 0x100fe200078e022fULL, 0x00000004ff387819ULL, 0x000fe20000011602ULL,
0x000000015f2e7824ULL, 0x100fe400078e022fULL, 0x000000015e3a7824ULL, 0x000fe400078e022fULL,
0x00005e0010107625ULL, 0x000fe200078e003bULL, 0x0000002c03127217ULL, 0x002fc60007800000ULL,
0x00005e002e2c7625ULL, 0x000fe200078e003bULL, 0x00000049102e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000112397824ULL, 0x000fe200078e0a03ULL, 0x000000492c2c7210ULL, 0x000fe20007f7e0ffULL,
0x00005e003a127625ULL, 0x000fc600078e003bULL, 0x000000393800720cULL, 0x000fe20003f46070ULL,
0x000000015d107824ULL, 0x000fe200078e022fULL, 0x0000004912127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e0611ULL, 0x000000394a00720cULL, 0x000fe20003f26070ULL,
0x00005e0010107625ULL, 0x000fc800078e003bULL, 0x000000ffff2d7224ULL, 0x000fe200018e062dULL,
0x000000394800720cULL, 0x080fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x000000394600720cULL, 0x000fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e677faeULL, 0x0003e2000d101c46ULL, 0x0000004910107210ULL, 0x000fc60007fbe0ffULL,
0x000000002c667faeULL, 0x0003e4000c901c46ULL, 0x000000ffff117224ULL, 0x000fc800028e0611ULL,
0x0000000012657faeULL, 0x0003e8000d901c46ULL, 0x0000000010647faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff117984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01061c00ff127984ULL, 0x000ea20000000800ULL,
0x000000ff0aff7812ULL, 0x000fe2000782c0ffULL, 0x8000000061137824ULL, 0x000fc600078e00ffULL,
0x00000001ff687807ULL, 0x000fca0000800000ULL, 0x8000000068107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe40007824810ULL, 0x8000000012ff7812ULL, 0x004fe20007844813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000061127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01061c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0100800063117984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x0102800063137984ULL, 0x0004e20000000800ULL,
0x000000041100720bULL, 0x002fda0003f5d000ULL, 0x0000000000107806ULL, 0x000fc800010e0100ULL,
0x0000ffff102c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000041100720bULL, 0x00cfe40003f54000ULL, 0x0000001104107209ULL, 0x000fe40007810000ULL,
0x00000002ff2e7819ULL, 0x000fc60000011602ULL, 0x8000001004127221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL, 0x0000000000047806ULL, 0x000fe400010e0100ULL,
0x00000012002d7308ULL, 0x000e620000000800ULL, 0x000000014100780cULL, 0x000fe40003f45270ULL,
0x0000ffff042f7812ULL, 0x000fc800078e3cffULL, 0x0000002f2cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff387807ULL, 0x000fc60001800000ULL, 0x010480106300a388ULL, 0x000fe20000000800ULL,
0x0000002d06067220ULL, 0x002fc60000410000ULL, 0x00001f2e2d047589ULL, 0x000e6400000e0000ULL,
0x80000010112c3221ULL, 0x000fe40000010000ULL, 0x00001f422d117589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL, 0x0000002c000c3308ULL, 0x000ee20000000800ULL,
0x0000000430307220ULL, 0x082fe20000410000ULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000434347220ULL, 0x080fe20000410000ULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000414147220ULL, 0x080fe20000410000ULL, 0x0000000415157220ULL, 0x080fe20000410000ULL,
0x0000000418187220ULL, 0x080fe20000410000ULL, 0x0000000419197220ULL, 0x080fe20000410000ULL,
0x000000041c1c7220ULL, 0x080fe20000410000ULL, 0x000000041d1d7220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x000fe20000410000ULL,
0x0000001132327220ULL, 0x084fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff047224ULL, 0x000fe200078e0010ULL, 0x000000130c133220ULL, 0x008fc80000410000ULL,
0x0000000613067221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff107984ULL, 0x000e620000000800ULL, 0x8000000068117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007824811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000068127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01064c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000a8005c2c7811ULL, 0x000fe200078e20ffULL, 0x000000006210783bULL, 0x000e620000004200ULL,
0x0000000cff39723eULL, 0x000fe400000000ffULL, 0x00000002ff6b7819ULL, 0x000fe20000011602ULL,
0x000000005b3c783bULL, 0x000fe20000004200ULL, 0x00005410393a7816ULL, 0x000fe40000000039ULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x000000002c2c783bULL, 0x000fe60000000200ULL,
0x000000ff3800720cULL, 0x000fe20003f25270ULL, 0x00001f6b3a6b7589ULL, 0x000ea800000e0000ULL,
0x00001f423a6c7589ULL, 0x000ee200000e0000ULL, 0x0000312010107816ULL, 0x002fc400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x080fe400020006ffULL,
0x00000011ff39723eULL, 0x080fe200020006ffULL, 0x0000006b2c2c9232ULL, 0x084fe20000000000ULL,
0x00000010ff10723eULL, 0x000fe200030006ffULL, 0x0000006b2e2e9232ULL, 0x000fe20000000000ULL,
0x00000011ff11723eULL, 0x000fe200030006ffULL, 0x0000006c2d2d9232ULL, 0x088fe20000000000ULL,
0x0000312012567816ULL, 0x000fe200000000ffULL, 0x0000006c2f2f9232ULL, 0x000fe20000000000ULL,
0x0000312013577816ULL, 0x000fc400000000ffULL, 0x0000a8005a127811ULL, 0x000fe400078e20ffULL,
0x000031203c6d7816ULL, 0x000fe400000000ffULL, 0x000000102c34723cULL, 0x040fe20000001834ULL,
0x000031203d6e7816ULL, 0x000fe400000000ffULL, 0x0000006dff3c723eULL, 0x000fe400020006ffULL,
0x0000006eff3d723eULL, 0x000fe400020006ffULL, 0x00000056ff10723eULL, 0x080fe200020006ffULL,
0x000000382c30723cULL, 0x000fe20000001830ULL, 0x00000057ff11723eULL, 0x000fe200020006ffULL,
0x000000005938783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fc400030006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x000000102c14723cULL, 0x040fe20000001814ULL,
0x000000001210783bULL, 0x000eae0000000200ULL, 0x0000003c2c1c723cULL, 0x040fee000000181cULL,
0x0000006dff3c723eULL, 0x000fe200030006ffULL, 0x000000562c18723cULL, 0x000fe20000001818ULL,
0x0000006eff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e567816ULL, 0x000fe200000000ffULL,
0x0000003c2c20723cULL, 0x000fe20000001820ULL, 0x000031203f577816ULL, 0x000fcc00000000ffULL,
0x00000056ff3c723eULL, 0x080fe400020006ffULL, 0x00000057ff3d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c2c24723cULL, 0x040fe20000001824ULL,
0x000000004f3c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000006b10109232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x0000006b12129232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000006c11119232ULL, 0x080fe20000000000ULL, 0x000000562c28723cULL, 0x000fe20000001828ULL,
0x0000006c13139232ULL, 0x000fcc0000000000ULL, 0x00000038ff2c723eULL, 0x000fe400020006ffULL,
0x00000039ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c1030723cULL, 0x000fee0000001830ULL,
0x00000038ff2c723eULL, 0x000fe400030006ffULL, 0x00000039ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1034723cULL, 0x000fe20000001834ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003aff2c723eULL, 0x000fe400020006ffULL, 0x0000003bff2d723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fca00000000ffULL, 0x0000002c1014723cULL, 0x000fee0000001814ULL,
0x0000003aff2c723eULL, 0x000fe400030006ffULL, 0x0000003bff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1018723cULL, 0x000fee0000001818ULL, 0x0000003cff2c723eULL, 0x000fe400020006ffULL,
0x0000003dff2d723eULL, 0x000fce00020006ffULL, 0x0000002c101c723cULL, 0x000fee000000181cULL,
0x0000003cff2c723eULL, 0x000fe400030006ffULL, 0x0000003dff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1020723cULL, 0x000fee0000001820ULL, 0x0000003eff2c723eULL, 0x000fe400020006ffULL,
0x0000003fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c1024723cULL, 0x000fee0000001824ULL,
0x0000003eff2c723eULL, 0x000fe400030006ffULL, 0x0000003fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c102c723cULL, 0x000fe20000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000008043107811ULL, 0x000fe200078e40ffULL,
0x00000004003a7e24ULL, 0x020fe2000f8e0205ULL, 0x00000004ff387819ULL, 0x000fe20000011602ULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x000000100f117217ULL, 0x000fc40007800000ULL,
0x0000003f3a287812ULL, 0x040fe400078ef847ULL, 0x0000003f3a3c7812ULL, 0x040fe200078ef845ULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x0000003f3a107812ULL, 0x000fe200078ef84bULL,
0x00005e0028287625ULL, 0x000fc600078e003bULL, 0x0000002011127807ULL, 0x000fe20000000000ULL,
0x00005e0010107625ULL, 0x000fe200078e003bULL, 0x0000004928287210ULL, 0x080fe40007f9e0ffULL,
0x0000001203127217ULL, 0x000fe40007800000ULL, 0x00000049102a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x0000003f3a107812ULL, 0x000fe200078ef844ULL,
0x0000000112397824ULL, 0x000fe400078e0a03ULL, 0x00005e003c127625ULL, 0x000fc600078e003bULL,
0x000000394a00720cULL, 0x000fe20003f66070ULL, 0x000000ffff2b7224ULL, 0x000fe200010e0611ULL,
0x0000004912127210ULL, 0x000fe20007fbe0ffULL, 0x00005e0010107625ULL, 0x000fe200078e003bULL,
0x000000393800720cULL, 0x080fe40003f46070ULL, 0x000000394800720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x000000394600720cULL, 0x000fe40003fa6070ULL,
0x0000004910107210ULL, 0x000fca0007fde0ffULL, 0x000000ffff117224ULL, 0x000fe400030e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a557faeULL, 0x0003e8000d101c46ULL,
0x0000000028547faeULL, 0x0003e8000d901c46ULL, 0x0000000012537faeULL, 0x0003e8000e101c46ULL,
0x0000000010527faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff107984ULL, 0x002e620000000800ULL, 0x8000000068117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007844811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000068127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000a80051107811ULL, 0x000fe200078e20ffULL, 0x000000005828783bULL, 0x000e620000004200ULL,
0x0000000cff38723eULL, 0x000fe400000000ffULL, 0x00000002ff6b7819ULL, 0x000fe20000011602ULL,
0x00000000503c783bULL, 0x000fe20000004200ULL, 0x00005410383a7816ULL, 0x000fc60000000038ULL,
0x000000001010783bULL, 0x000fe80000000200ULL, 0x00001f6b3a6b7589ULL, 0x000ea800000e0000ULL,
0x00001f423a6c7589ULL, 0x000ee200000e0000ULL, 0x0000312028287816ULL, 0x002fe400000000ffULL,
0x0000312029297816ULL, 0x000fc400000000ffULL, 0x00000028ff38723eULL, 0x080fe400020006ffULL,
0x00000029ff39723eULL, 0x080fe200020006ffULL, 0x0000006b10109232ULL, 0x084fe20000000000ULL,
0x00000028ff28723eULL, 0x000fe200030006ffULL, 0x0000006b12129232ULL, 0x000fe20000000000ULL,
0x00000029ff29723eULL, 0x000fe200030006ffULL, 0x0000006c11119232ULL, 0x088fe20000000000ULL,
0x000031202a567816ULL, 0x000fe200000000ffULL, 0x0000006c13139232ULL, 0x000fe20000000000ULL,
0x000031202b577816ULL, 0x000fc400000000ffULL, 0x0000a8004e2a7811ULL, 0x000fe400078e20ffULL,
0x000031203c6d7816ULL, 0x000fe400000000ffULL, 0x000000281034723cULL, 0x040fe20000001834ULL,
0x000031203d6e7816ULL, 0x000fe400000000ffULL, 0x0000006dff3c723eULL, 0x000fe400020006ffULL,
0x0000006eff3d723eULL, 0x000fe400020006ffULL, 0x00000056ff28723eULL, 0x080fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000057ff29723eULL, 0x000fe200020006ffULL,
0x000000004d38783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fc400030006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x000000281014723cULL, 0x040fe20000001814ULL,
0x000000002a28783bULL, 0x000eae0000000200ULL, 0x0000003c101c723cULL, 0x040fee000000181cULL,
0x0000006dff3c723eULL, 0x000fe200030006ffULL, 0x000000561018723cULL, 0x000fe20000001818ULL,
0x0000006eff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e567816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x000031203f577816ULL, 0x000fcc00000000ffULL,
0x00000056ff3c723eULL, 0x080fe400020006ffULL, 0x00000057ff3d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c1024723cULL, 0x040fe20000001824ULL,
0x000000004c3c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000006b28289232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x0000006b2a2a9232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000006c29299232ULL, 0x080fe20000000000ULL, 0x00000056102c723cULL, 0x000fe2000000182cULL,
0x0000006c2b2b9232ULL, 0x000fcc0000000000ULL, 0x00000038ff10723eULL, 0x000fe400020006ffULL,
0x00000039ff11723eULL, 0x000fce00020006ffULL, 0x000000102830723cULL, 0x000fee0000001830ULL,
0x00000038ff10723eULL, 0x000fe400030006ffULL, 0x00000039ff11723eULL, 0x000fce00030006ffULL,
0x000000102834723cULL, 0x000fe20000001834ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003aff10723eULL, 0x000fe400020006ffULL, 0x0000003bff11723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fca00000000ffULL, 0x000000102814723cULL, 0x000fee0000001814ULL,
0x0000003aff10723eULL, 0x000fe400030006ffULL, 0x0000003bff11723eULL, 0x000fce00030006ffULL,
0x000000102818723cULL, 0x000fee0000001818ULL, 0x0000003cff10723eULL, 0x000fe400020006ffULL,
0x0000003dff11723eULL, 0x000fce00020006ffULL, 0x00000010281c723cULL, 0x000fee000000181cULL,
0x0000003cff10723eULL, 0x000fe400030006ffULL, 0x0000003dff11723eULL, 0x000fce00030006ffULL,
0x000000102820723cULL, 0x000fee0000001820ULL, 0x0000003eff10723eULL, 0x000fe400020006ffULL,
0x0000003fff11723eULL, 0x000fce00020006ffULL, 0x000000102824723cULL, 0x000fee0000001824ULL,
0x0000003eff10723eULL, 0x000fe400030006ffULL, 0x0000003fff11723eULL, 0x000fce00030006ffULL,
0x000000102828723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008043107811ULL, 0x000fe200078e40ffULL,
0x01062000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0aff7812ULL, 0x000fe4000784c0ffULL,
0x000000100f00720cULL, 0x000fe40003f24070ULL, 0x00000001ff6b7807ULL, 0x000fd60005000000ULL,
0x0000370000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00107305ULL, 0x0002a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000016a697824ULL, 0x000fe400078e0269ULL,
0x00000004ff127424ULL, 0x000fe400078e00ffULL, 0x00000300ff0d7624ULL, 0x000fe200078e00ffULL,
0x0000000369107812ULL, 0x000fe200078ec0ffULL, 0x00000004002c7e24ULL, 0x000fe4000f8e0205ULL,
0xfffffffd120d7424ULL, 0x000fe200078e020dULL, 0x000000031000780cULL, 0x000fe20003f25270ULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x000000010d6a7807ULL, 0x000fca0004800000ULL,
0x00000001690d7824ULL, 0x000fca00078e026aULL, 0x000000400d00720cULL, 0x000fe40003f26070ULL,
0x000000a043107811ULL, 0x000fc800078e40ffULL, 0x000000100f117217ULL, 0x000fca0007800000ULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x000000010d139824ULL, 0x000fe200078e0208ULL,
0x000000202c2f7810ULL, 0x000fc60007ffe0ffULL, 0x0000600013129625ULL, 0x000fe200078e0012ULL,
0x00000020112c7807ULL, 0x000fc60000000000ULL, 0x00000100ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000000612009981ULL, 0x000362000c1e1900ULL, 0x0000000160107824ULL, 0x100fe200078e022fULL,
0x00000004ff387819ULL, 0x000fe20000011602ULL, 0x000000015f2e7824ULL, 0x100fe400078e022fULL,
0x000000015e3a7824ULL, 0x000fe400078e022fULL, 0x00005e0010107625ULL, 0x000fe200078e003bULL,
0x0000002c03127217ULL, 0x002fc60007800000ULL, 0x00005e002e2c7625ULL, 0x000fe200078e003bULL,
0x00000049102e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000112397824ULL, 0x000fe200078e0a03ULL,
0x000000492c2c7210ULL, 0x000fe20007f7e0ffULL, 0x00005e003a127625ULL, 0x000fc600078e003bULL,
0x000000393800720cULL, 0x000fe20003f46070ULL, 0x000000015d107824ULL, 0x000fe200078e022fULL,
0x0000004912127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0611ULL,
0x000000394a00720cULL, 0x000fe20003f26070ULL, 0x00005e0010107625ULL, 0x000fc800078e003bULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x000000394800720cULL, 0x080fe20003f66070ULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x000000394600720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e677faeULL, 0x0003e2000d101c46ULL,
0x0000004910107210ULL, 0x000fc60007fbe0ffULL, 0x000000002c667faeULL, 0x0003e4000c901c46ULL,
0x000000ffff117224ULL, 0x000fc800028e0611ULL, 0x0000000012657faeULL, 0x0003e8000d901c46ULL,
0x0000000010647faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff117984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01062c00ff127984ULL, 0x000ea20000000800ULL, 0x000000ff0aff7812ULL, 0x000fe2000782c0ffULL,
0x8000000061137824ULL, 0x000fc600078e00ffULL, 0x00000001ff6b7807ULL, 0x000fca0004800000ULL,
0x800000006b107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe40007824810ULL,
0x8000000012ff7812ULL, 0x004fe20007844813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000061127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01062c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0101000063117984ULL, 0x000e620000000800ULL, 0x00000001ff387424ULL, 0x000fc600078e00ffULL,
0x0103000063137984ULL, 0x0004e20000000800ULL, 0x000000041100720bULL, 0x002fda0003f5d000ULL,
0x0000000000107806ULL, 0x000fc800010e0100ULL, 0x0000ffff102c7812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000041100720bULL, 0x00cfe40003f54000ULL,
0x0000001104107209ULL, 0x000fe40007810000ULL, 0x00000002ff2e7819ULL, 0x000fc60000011602ULL,
0x8000001004127221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL,
0x0000000000047806ULL, 0x000fe400010e0100ULL, 0x00000012002d7308ULL, 0x000e620000000800ULL,
0x000000024100780cULL, 0x000fe40003f45270ULL, 0x0000ffff042f7812ULL, 0x000fc800078e3cffULL,
0x0000002f2cff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff387807ULL, 0x000fc60001800000ULL,
0x010500106300a388ULL, 0x000fe20000000800ULL, 0x0000002d06067220ULL, 0x002fc60000410000ULL,
0x00001f2e2d047589ULL, 0x000e6400000e0000ULL, 0x80000010112c3221ULL, 0x000fe40000010000ULL,
0x00001f422d117589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL,
0x0000002c000c3308ULL, 0x000ee20000000800ULL, 0x0000000430307220ULL, 0x082fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000414147220ULL, 0x080fe20000410000ULL,
0x0000000415157220ULL, 0x080fe20000410000ULL, 0x0000000418187220ULL, 0x080fe20000410000ULL,
0x0000000419197220ULL, 0x080fe20000410000ULL, 0x000000041c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x000fe20000410000ULL, 0x0000001132327220ULL, 0x084fe20000410000ULL,
0x0000001133337220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff047224ULL, 0x000fe200078e0010ULL,
0x000000130c133220ULL, 0x008fc80000410000ULL, 0x0000000613067221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff107984ULL, 0x000e620000000800ULL,
0x800000006b117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007824811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x800000006b127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01064c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000b0005c107811ULL, 0x000fe200078e20ffULL,
0x00000000622c783bULL, 0x000e620000004200ULL, 0x0000000cff39723eULL, 0x000fe400000000ffULL,
0x00000002ff6d7819ULL, 0x000fe20000011602ULL, 0x000000005b3c783bULL, 0x000fe20000004200ULL,
0x00005410393a7816ULL, 0x000fe40000000039ULL, 0x0000991038387816ULL, 0x000fe200000000ffULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000b0005a707811ULL, 0x000fc400078e20ffULL,
0x000000ff3800720cULL, 0x000fe20003f25270ULL, 0x00001f6d3a6d7589ULL, 0x000ea800000e0000ULL,
0x00001f423a6c7589ULL, 0x000ee200000e0000ULL, 0x000031202c2c7816ULL, 0x002fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x0000002cff38723eULL, 0x000fc400020006ffULL,
0x0000002dff39723eULL, 0x080fe200020006ffULL, 0x0000006d10109232ULL, 0x084fe20000000000ULL,
0x0000002cff2c723eULL, 0x000fe200030006ffULL, 0x0000006d12129232ULL, 0x000fe20000000000ULL,
0x0000002dff2d723eULL, 0x000fe200030006ffULL, 0x0000006c11119232ULL, 0x088fe20000000000ULL,
0x000031202e567816ULL, 0x000fe200000000ffULL, 0x0000006c13139232ULL, 0x000fe20000000000ULL,
0x000031202f577816ULL, 0x000fe400000000ffULL, 0x000031203c6e7816ULL, 0x000fc400000000ffULL,
0x000031203d6f7816ULL, 0x000fe400000000ffULL, 0x0000002c1034723cULL, 0x000fe20000001834ULL,
0x0000006eff3c723eULL, 0x000fe400020006ffULL, 0x0000006fff3d723eULL, 0x000fc800020006ffULL,
0x00000056ff2c723eULL, 0x080fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000057ff2d723eULL, 0x080fe200020006ffULL, 0x000000005938783bULL, 0x000e620000004200ULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fc600030006ffULL,
0x0000002c102c723cULL, 0x040fe20000001814ULL, 0x000000007014783bULL, 0x000eae0000000200ULL,
0x0000003c101c723cULL, 0x040fee000000181cULL, 0x0000006eff3c723eULL, 0x000fe200030006ffULL,
0x000000561018723cULL, 0x000fe20000001818ULL, 0x0000006fff3d723eULL, 0x000fcc00030006ffULL,
0x000031203e567816ULL, 0x000fe200000000ffULL, 0x0000003c1020723cULL, 0x000fe20000001820ULL,
0x000031203f577816ULL, 0x000fcc00000000ffULL, 0x00000056ff3c723eULL, 0x080fe400020006ffULL,
0x00000057ff3d723eULL, 0x080fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe200000000ffULL,
0x0000003c1024723cULL, 0x040fe20000001824ULL, 0x000000004f3c783bULL, 0x000e620000004200ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000006d14149232ULL, 0x084fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x0000006d16169232ULL, 0x000fe20000000000ULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x0000006c15159232ULL, 0x080fe20000000000ULL,
0x000000561010723cULL, 0x000fe20000001828ULL, 0x0000006c17179232ULL, 0x000fcc0000000000ULL,
0x00000038ff28723eULL, 0x000fe400020006ffULL, 0x00000039ff29723eULL, 0x000fce00020006ffULL,
0x000000281430723cULL, 0x000fee0000001830ULL, 0x00000038ff28723eULL, 0x000fe400030006ffULL,
0x00000039ff29723eULL, 0x000fce00030006ffULL, 0x000000281434723cULL, 0x000fe20000001834ULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000003aff28723eULL, 0x000fe400020006ffULL,
0x0000003bff29723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fca00000000ffULL,
0x00000028142c723cULL, 0x000fee000000182cULL, 0x0000003aff28723eULL, 0x000fe400030006ffULL,
0x0000003bff29723eULL, 0x000fce00030006ffULL, 0x000000281418723cULL, 0x000fee0000001818ULL,
0x0000003cff28723eULL, 0x000fe400020006ffULL, 0x0000003dff29723eULL, 0x000fce00020006ffULL,
0x00000028141c723cULL, 0x000fee000000181cULL, 0x0000003cff28723eULL, 0x000fe400030006ffULL,
0x0000003dff29723eULL, 0x000fce00030006ffULL, 0x000000281420723cULL, 0x000fee0000001820ULL,
0x0000003eff28723eULL, 0x000fe400020006ffULL, 0x0000003fff29723eULL, 0x000fce00020006ffULL,
0x000000281424723cULL, 0x000fee0000001824ULL, 0x0000003eff28723eULL, 0x000fe400030006ffULL,
0x0000003fff29723eULL, 0x000fce00030006ffULL, 0x000000281414723cULL, 0x000fe20000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000c043107811ULL, 0x000fe200078e40ffULL, 0x00000004003a7e24ULL, 0x020fe2000f8e0205ULL,
0x00000004ff387819ULL, 0x000fe20000011602ULL, 0x00000100ff3b7424ULL, 0x000fe200078e00ffULL,
0x000000100f117217ULL, 0x000fc40007800000ULL, 0x0000003f3a287812ULL, 0x040fe400078ef847ULL,
0x0000003f3a3c7812ULL, 0x040fe200078ef845ULL, 0x0000000111117824ULL, 0x000fe200078e0a10ULL,
0x0000003f3a107812ULL, 0x000fe200078ef84bULL, 0x00005e0028287625ULL, 0x000fc600078e003bULL,
0x0000002011127807ULL, 0x000fe20000000000ULL, 0x00005e0010107625ULL, 0x000fe200078e003bULL,
0x0000004928287210ULL, 0x080fe40007f9e0ffULL, 0x0000001203127217ULL, 0x000fe40007800000ULL,
0x00000049102a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x0000003f3a107812ULL, 0x000fe200078ef844ULL, 0x0000000112397824ULL, 0x000fe400078e0a03ULL,
0x00005e003c127625ULL, 0x000fc600078e003bULL, 0x000000394a00720cULL, 0x000fe20003f66070ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0611ULL, 0x0000004912127210ULL, 0x000fe20007fbe0ffULL,
0x00005e0010107625ULL, 0x000fe200078e003bULL, 0x000000393800720cULL, 0x080fe40003f46070ULL,
0x000000394800720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000394600720cULL, 0x000fe40003fa6070ULL, 0x0000004910107210ULL, 0x000fca0007fde0ffULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a557faeULL, 0x0003e8000d101c46ULL, 0x0000000028547faeULL, 0x0003e8000d901c46ULL,
0x0000000012537faeULL, 0x0003e8000e101c46ULL, 0x0000000010527faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff107984ULL, 0x002e620000000800ULL,
0x800000006b117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007844811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000006b127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000b00051107811ULL, 0x000fe200078e20ffULL,
0x000000005828783bULL, 0x000e620000004200ULL, 0x0000000cff38723eULL, 0x000fe400000000ffULL,
0x00000002ff6b7819ULL, 0x000fe20000011602ULL, 0x00000000503c783bULL, 0x000fe20000004200ULL,
0x00005410383a7816ULL, 0x000fc60000000038ULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x00001f6b3a6b7589ULL, 0x000ea800000e0000ULL, 0x00001f423a6c7589ULL, 0x000ee200000e0000ULL,
0x0000312028287816ULL, 0x002fe400000000ffULL, 0x0000312029297816ULL, 0x000fc400000000ffULL,
0x00000028ff38723eULL, 0x080fe400020006ffULL, 0x00000029ff39723eULL, 0x080fe200020006ffULL,
0x0000006b10109232ULL, 0x084fe20000000000ULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000006b12129232ULL, 0x000fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000006c11119232ULL, 0x088fe20000000000ULL, 0x000031202a567816ULL, 0x000fe200000000ffULL,
0x0000006c13139232ULL, 0x000fe20000000000ULL, 0x000031202b577816ULL, 0x000fc400000000ffULL,
0x0000b0004e2a7811ULL, 0x000fe400078e20ffULL, 0x000031203c6d7816ULL, 0x000fe400000000ffULL,
0x000000281034723cULL, 0x040fe20000001834ULL, 0x000031203d6e7816ULL, 0x000fe400000000ffULL,
0x0000006dff3c723eULL, 0x000fe400020006ffULL, 0x0000006eff3d723eULL, 0x000fe400020006ffULL,
0x00000056ff28723eULL, 0x080fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000057ff29723eULL, 0x000fe200020006ffULL, 0x000000004d38783bULL, 0x000e620000004200ULL,
0x00000056ff56723eULL, 0x000fc400030006ffULL, 0x00000057ff57723eULL, 0x000fc600030006ffULL,
0x00000028102c723cULL, 0x040fe2000000182cULL, 0x000000002a28783bULL, 0x000eae0000000200ULL,
0x0000003c101c723cULL, 0x040fee000000181cULL, 0x0000006dff3c723eULL, 0x000fe200030006ffULL,
0x000000561018723cULL, 0x000fe20000001818ULL, 0x0000006eff3d723eULL, 0x000fcc00030006ffULL,
0x000031203e567816ULL, 0x000fe200000000ffULL, 0x0000003c1020723cULL, 0x000fe20000001820ULL,
0x000031203f577816ULL, 0x000fcc00000000ffULL, 0x00000056ff3c723eULL, 0x080fe400020006ffULL,
0x00000057ff3d723eULL, 0x080fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe200000000ffULL,
0x0000003c1024723cULL, 0x040fe20000001824ULL, 0x000000004c3c783bULL, 0x000e620000004200ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000006b28289232ULL, 0x084fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x0000006b2a2a9232ULL, 0x000fe20000000000ULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x0000006c29299232ULL, 0x080fe20000000000ULL,
0x000000561010723cULL, 0x000fe20000001814ULL, 0x0000006c2b2b9232ULL, 0x000fcc0000000000ULL,
0x00000038ff14723eULL, 0x000fe400020006ffULL, 0x00000039ff15723eULL, 0x000fce00020006ffULL,
0x000000142830723cULL, 0x000fee0000001830ULL, 0x00000038ff14723eULL, 0x000fe400030006ffULL,
0x00000039ff15723eULL, 0x000fce00030006ffULL, 0x000000142834723cULL, 0x000fe20000001834ULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000003aff14723eULL, 0x000fe400020006ffULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fca00000000ffULL,
0x000000142814723cULL, 0x000fee000000182cULL, 0x0000003aff2c723eULL, 0x000fe400030006ffULL,
0x0000003bff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2818723cULL, 0x000fee0000001818ULL,
0x0000003cff2c723eULL, 0x000fe400020006ffULL, 0x0000003dff2d723eULL, 0x000fce00020006ffULL,
0x0000002c281c723cULL, 0x000fee000000181cULL, 0x0000003cff2c723eULL, 0x000fe400030006ffULL,
0x0000003dff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2820723cULL, 0x000fee0000001820ULL,
0x0000003eff2c723eULL, 0x000fe400020006ffULL, 0x0000003fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2824723cULL, 0x000fee0000001824ULL, 0x0000003eff2c723eULL, 0x000fe400030006ffULL,
0x0000003fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c043107811ULL, 0x000fe200078e40ffULL, 0x01063000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0aff7812ULL, 0x000fe4000784c0ffULL, 0x000000100f00720cULL, 0x000fe40003f24070ULL,
0x00000001ff6b7807ULL, 0x000fd60001000000ULL, 0x00001b7000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001696a7824ULL, 0x000fe400078e026aULL, 0x00000004ff107424ULL, 0x000fe400078e00ffULL,
0x00000300ff0d7624ULL, 0x000fe200078e00ffULL, 0x000000036a117812ULL, 0x000fe200078ec0ffULL,
0x00000004002c7e24ULL, 0x000fe4000f8e0205ULL, 0xfffffffd100d7424ULL, 0x000fe200078e020dULL,
0x000000031100780cULL, 0x000fe20003f25270ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000010d0d7807ULL, 0x000fca0004800000ULL, 0x000000016a0d7824ULL, 0x000fe200078e020dULL,
0x000000e043127811ULL, 0x000fc800078e40ffULL, 0x000000400d00720cULL, 0x000fe40003f26070ULL,
0x000000120f137217ULL, 0x000fe40007800000ULL, 0x000000202c2d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000113137824ULL, 0x000fe400078e0a12ULL, 0x00000100ff3b7424ULL, 0x000fc800078e00ffULL,
0x000000010d119824ULL, 0x000fe200078e0208ULL, 0x00000020132c7807ULL, 0x000fe20000000000ULL,
0x0000000160127824ULL, 0x000fe400078e022dULL, 0x0000600011109625ULL, 0x000fe200078e0010ULL,
0x0000002c032c7217ULL, 0x000fc60007800000ULL, 0x000000015f387824ULL, 0x000fe200078e022dULL,
0x0000000610009981ULL, 0x000362000c1e1900ULL, 0x00005e0012127625ULL, 0x000fe200078e003bULL,
0x00000004ff2e7819ULL, 0x000fc60000011602ULL, 0x000000012c397824ULL, 0x000fe200078e0a03ULL,
0x0000004912127210ULL, 0x000fe20007f1e0ffULL, 0x000000015e5e7824ULL, 0x100fe400078e022dULL,
0x000000015d2c7824ULL, 0x000fe200078e022dULL, 0x000000394a00720cULL, 0x000fe20003f26070ULL,
0x00005e0038107625ULL, 0x002fe200078e003bULL, 0x000000394600720cULL, 0x000fc60003f66070ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000004910107210ULL, 0x000fe20007f5e0ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e003bULL, 0x000000392e00720cULL, 0x000fc60003f06070ULL,
0x00005e005e2e7625ULL, 0x000fe200078e003bULL, 0x000000492c2c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000394800720cULL, 0x000fe20003f46070ULL,
0x000000ffff2d7224ULL, 0x000fe200028e062dULL, 0x000000492e2e7210ULL, 0x000fc60007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012677faeULL, 0x0003e4000c101c46ULL,
0x000000ffff2f7224ULL, 0x000fe400020e062fULL, 0x0000000010667faeULL, 0x0003e8000c901c46ULL,
0x000000002e657faeULL, 0x0003e8000d101c46ULL, 0x000000002c647faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff107984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01063c00ff117984ULL, 0x000ea20000000800ULL,
0x8000000068137824ULL, 0x000fc400078e00ffULL, 0x8000000061127824ULL, 0x000fc600078e00ffULL,
0x8000000010ff7812ULL, 0x002fe40007804813ULL, 0x8000000011ff7812ULL, 0x004fe20007824812ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000061127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01063c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0101800063117984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x0103800063137984ULL, 0x0004e20000000800ULL,
0x000000041100720bULL, 0x002fda0003f3d000ULL, 0x0000000000107806ULL, 0x000fc800008e0100ULL,
0x0000ffff10127812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000041100720bULL, 0x00cfe40003f34000ULL, 0x00000011042c7209ULL, 0x000fe40007810000ULL,
0x00000002ff2e7819ULL, 0x000fc60000011602ULL, 0x8000002c04107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000047806ULL, 0x000fe400008e0100ULL,
0x00000010002d7308ULL, 0x000e620000000800ULL, 0x000000034100780cULL, 0x000fe40003f25270ULL,
0x0000ffff042f7812ULL, 0x000fc800078e3cffULL, 0x0000002f12ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff387807ULL, 0x000fc60001000000ULL, 0x0105802c63009388ULL, 0x000fe20000000800ULL,
0x0000002d06067220ULL, 0x002fc60000410000ULL, 0x00001f2e2d047589ULL, 0x000e6400000e0000ULL,
0x8000002c11122221ULL, 0x000fe40000010000ULL, 0x00001f422d117589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b12122820ULL, 0x000fc80000410000ULL, 0x00000012000c2308ULL, 0x000ee20000000800ULL,
0x0000000430307220ULL, 0x082fe20000410000ULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000434347220ULL, 0x080fe20000410000ULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000414147220ULL, 0x080fe20000410000ULL, 0x0000000415157220ULL, 0x080fe20000410000ULL,
0x0000000418187220ULL, 0x080fe20000410000ULL, 0x0000000419197220ULL, 0x080fe20000410000ULL,
0x000000041c1c7220ULL, 0x080fe20000410000ULL, 0x000000041d1d7220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x000fe20000410000ULL,
0x0000001132327220ULL, 0x084fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff047224ULL, 0x000fe200078e002cULL, 0x000000130c132220ULL, 0x008fc80000410000ULL,
0x0000000613067221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x01064c00ff107984ULL, 0x000e620000000800ULL, 0x8000000068117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007804811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000068127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01064c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000b8005c107811ULL, 0x000fe200078e20ffULL, 0x00000000622c783bULL, 0x000e620000004200ULL,
0x0000000cff39723eULL, 0x000fe400000000ffULL, 0x00000002ff5d7819ULL, 0x000fe20000011602ULL,
0x000000005b3c783bULL, 0x000fe20000004200ULL, 0x00005410393a7816ULL, 0x000fe40000000039ULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x000000001010783bULL, 0x000fe20000000200ULL,
0x0000b8005a5e7811ULL, 0x000fc400078e20ffULL, 0x000000ff3800720cULL, 0x000fe20003f05270ULL,
0x00001f5d3a5d7589ULL, 0x000ea800000e0000ULL, 0x00001f423a5c7589ULL, 0x000ee200000e0000ULL,
0x000031202c2c7816ULL, 0x002fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x0000002cff38723eULL, 0x000fc400020006ffULL, 0x0000002dff39723eULL, 0x080fe200020006ffULL,
0x0000005d10108232ULL, 0x084fe20000000000ULL, 0x0000002cff2c723eULL, 0x000fe200030006ffULL,
0x0000005d12128232ULL, 0x000fe20000000000ULL, 0x0000002dff2d723eULL, 0x000fe200030006ffULL,
0x0000005c11118232ULL, 0x088fe20000000000ULL, 0x000031202e567816ULL, 0x000fe200000000ffULL,
0x0000005c13138232ULL, 0x000fe20000000000ULL, 0x000031202f577816ULL, 0x000fe400000000ffULL,
0x000031203c5a7816ULL, 0x000fc400000000ffULL, 0x000031203d5b7816ULL, 0x000fe400000000ffULL,
0x0000002c1034723cULL, 0x000fe20000001834ULL, 0x0000005aff3c723eULL, 0x000fe400020006ffULL,
0x0000005bff3d723eULL, 0x000fc800020006ffULL, 0x00000056ff2c723eULL, 0x080fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000057ff2d723eULL, 0x080fe200020006ffULL,
0x000000005938783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x0000002c102c723cULL, 0x040fe20000001814ULL,
0x000000005e14783bULL, 0x000eae0000000200ULL, 0x0000003c101c723cULL, 0x040fee000000181cULL,
0x0000005aff3c723eULL, 0x000fe200030006ffULL, 0x000000561018723cULL, 0x000fe20000001818ULL,
0x0000005bff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e567816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x000031203f577816ULL, 0x000fcc00000000ffULL,
0x00000056ff3c723eULL, 0x080fe400020006ffULL, 0x00000057ff3d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c1024723cULL, 0x040fe20000001824ULL,
0x000000004f3c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000005d14148232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x0000005d16168232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000005c15158232ULL, 0x080fe20000000000ULL, 0x000000561010723cULL, 0x000fe20000001828ULL,
0x0000005c17178232ULL, 0x000fcc0000000000ULL, 0x00000038ff28723eULL, 0x000fe400020006ffULL,
0x00000039ff29723eULL, 0x000fce00020006ffULL, 0x000000281430723cULL, 0x000fee0000001830ULL,
0x00000038ff28723eULL, 0x000fe400030006ffULL, 0x00000039ff29723eULL, 0x000fce00030006ffULL,
0x000000281434723cULL, 0x000fe20000001834ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003aff28723eULL, 0x000fe400020006ffULL, 0x0000003bff29723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fc400000000ffULL, 0x0000003aff3a723eULL, 0x000fe400030006ffULL,
0x0000003bff3b723eULL, 0x000fe200030006ffULL, 0x00000028142c723cULL, 0x040fee000000182cULL,
0x0000003cff28723eULL, 0x000fe200020006ffULL, 0x0000003a1418723cULL, 0x000fe20000001818ULL,
0x0000003dff29723eULL, 0x000fc400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x00000028141c723cULL, 0x040fee000000181cULL,
0x0000003eff28723eULL, 0x080fe200020006ffULL, 0x0000003c1420723cULL, 0x000fe20000001820ULL,
0x0000003fff29723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fc400030006ffULL,
0x0000003fff3f723eULL, 0x000fc600030006ffULL, 0x000000281424723cULL, 0x040ff00000001824ULL,
0x0000003e1414723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000030043107a10ULL, 0x000fe20007ffe0ffULL,
0x0000000400387e24ULL, 0x020fe2000f8e0205ULL, 0x00000004ff2a7819ULL, 0x000fe20000011602ULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000000110117810ULL, 0x040fe20007ffe0ffULL,
0x0000010010127824ULL, 0x000fe200078e00ffULL, 0x0000003f38107812ULL, 0x000fe400078ef84bULL,
0x0000000e1100720cULL, 0x000fe40003f26070ULL, 0x000000120f137217ULL, 0x000fe20007800000ULL,
0x00005e0010107625ULL, 0x000fe200078e002bULL, 0x0000003f383a7812ULL, 0x000fc600078ef847ULL,
0x0000000113137824ULL, 0x000fca00078e0a12ULL, 0x0000002013127807ULL, 0x000fe40000800000ULL,
0x0000004910107210ULL, 0x000fe40007f3e0ffULL, 0x0000001203287217ULL, 0x000fe20007800000ULL,
0x00005e003a127625ULL, 0x000fc800078e002bULL, 0x0000000128397824ULL, 0x000fe200078e0a03ULL,
0x0000003f38287812ULL, 0x040fe200078ef845ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000003f38387812ULL, 0x000fe400078ef844ULL, 0x0000004912127210ULL, 0x000fe20007f7e0ffULL,
0x00005e0028287625ULL, 0x000fe200078e002bULL, 0x000000392a00720cULL, 0x080fe40003f46070ULL,
0x000000394a00720cULL, 0x000fe20003f26070ULL, 0x00005e00382a7625ULL, 0x000fe200078e002bULL,
0x000000394600720cULL, 0x000fc40003f86070ULL, 0x0000004928287210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000394800720cULL, 0x000fe40003f66070ULL,
0x000000492a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff297224ULL, 0x000fe400028e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010557faeULL, 0x0003e4000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe400030e062bULL, 0x0000000012547faeULL, 0x0003e8000c901c46ULL,
0x0000000028537faeULL, 0x0003e8000d901c46ULL, 0x000000002a527faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff107984ULL, 0x002e620000000800ULL,
0x8000000068117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007824811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000068687824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824868ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000b80051107811ULL, 0x000fe200078e20ffULL,
0x000000005828783bULL, 0x000e620000004200ULL, 0x0000000cff38723eULL, 0x000fe400000000ffULL,
0x00000002ff457819ULL, 0x000fe20000011602ULL, 0x00000000503c783bULL, 0x000fe20000004200ULL,
0x00005410383a7816ULL, 0x000fc60000000038ULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x00001f453a457589ULL, 0x000ea800000e0000ULL, 0x00001f423a427589ULL, 0x000ee200000e0000ULL,
0x0000312028287816ULL, 0x002fe400000000ffULL, 0x0000312029297816ULL, 0x000fc400000000ffULL,
0x00000028ff38723eULL, 0x080fe400020006ffULL, 0x00000029ff39723eULL, 0x080fe200020006ffULL,
0x0000004510108232ULL, 0x084fe20000000000ULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000004512128232ULL, 0x000fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000004211118232ULL, 0x088fe20000000000ULL, 0x000031202b477816ULL, 0x000fe200000000ffULL,
0x0000004213138232ULL, 0x000fe20000000000ULL, 0x000031202a447816ULL, 0x000fc400000000ffULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x00000044ff46723eULL, 0x000fe400030006ffULL,
0x000000281034723cULL, 0x000fe20000001834ULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x0000b8004e2a7811ULL, 0x000fc800078e20ffULL, 0x00000047ff29723eULL, 0x080fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000047ff47723eULL, 0x000fe200030006ffULL,
0x000000004d38783bULL, 0x000e620000004200ULL, 0x00000044ff28723eULL, 0x000fe400020006ffULL,
0x000031203e447816ULL, 0x000fc600000000ffULL, 0x000000461018723cULL, 0x040fee0000001818ULL,
0x0000003cff46723eULL, 0x080fe200020006ffULL, 0x00000028102c723cULL, 0x000fe2000000182cULL,
0x0000003dff47723eULL, 0x000fe200020006ffULL, 0x000000002a28783bULL, 0x000ea20000000200ULL,
0x0000003cff3c723eULL, 0x000fc400030006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x00000046101c723cULL, 0x040fee000000181cULL, 0x000031203f477816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x00000044ff46723eULL, 0x000fcc00030006ffULL,
0x00000044ff3c723eULL, 0x000fe400020006ffULL, 0x00000047ff3d723eULL, 0x080fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe400000000ffULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000003c1024723cULL, 0x000fe20000001824ULL,
0x000000004c3c783bULL, 0x000e620000004200ULL, 0x000031203a3a7816ULL, 0x000fc400000000ffULL,
0x000031203b3b7816ULL, 0x000fc800000000ffULL, 0x000000461010723cULL, 0x000fe20000001814ULL,
0x0000004528288232ULL, 0x084fe40000000000ULL, 0x000000452a2a8232ULL, 0x000fe40000000000ULL,
0x0000004229298232ULL, 0x080fe40000000000ULL, 0x00000038ff14723eULL, 0x080fe200020006ffULL,
0x000000422b2b8232ULL, 0x000fe20000000000ULL, 0x00000039ff15723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400030006ffULL, 0x00000039ff39723eULL, 0x000fc600030006ffULL,
0x000000142830723cULL, 0x040fee0000001830ULL, 0x0000003aff14723eULL, 0x080fe200020006ffULL,
0x000000382834723cULL, 0x000fe20000001834ULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000142814723cULL, 0x040fe2000000182cULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003cff2c723eULL, 0x000fe200020006ffULL, 0x0000003a2818723cULL, 0x000fe20000001818ULL,
0x0000003dff2d723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fc400000000ffULL,
0x0000003cff3c723eULL, 0x000fe400030006ffULL, 0x0000003dff3d723eULL, 0x000fe200030006ffULL,
0x0000002c281c723cULL, 0x040fee000000181cULL, 0x0000003eff2c723eULL, 0x000fe200020006ffULL,
0x0000003c2820723cULL, 0x000fe20000001820ULL, 0x0000003fff2d723eULL, 0x000fc400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x0000002c2824723cULL, 0x040ff00000001824ULL, 0x0000003e2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff6b7807ULL, 0x000fe40004000000ULL, 0x0000030043437a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff09ff7812ULL, 0x000fe4000780c0ffULL, 0x0000000e4300720cULL, 0x000fe40003f26070ULL,
0x00000001ff097807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff8c3000007947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000e620000002500ULL,
0x000000ffff397224ULL, 0x000fe400078e0019ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0015ULL,
0x0000000e0700720cULL, 0x002fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0006ULL,
0x0000834000087802ULL, 0x000fe40000000f00ULL, 0x00007cd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc80000000006ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff097624ULL, 0x000fe400078e00ffULL,
0x00006800ff087624ULL, 0x000fca00078e00ffULL, 0x0000000608097981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff0b7819ULL, 0x008fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000009007220ULL, 0x004fca0000410000ULL,
0x00001f0b00027589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000003002307220ULL, 0x044fe20000410000ULL, 0x0000003102317220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000002f022f7220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000002102217220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002802287220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x000fe20000410000ULL,
0x0000003205327220ULL, 0x048fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x0000000000107919ULL, 0x000ea20000000000ULL, 0x0000001c1d1c723eULL, 0x000fc400000000ffULL,
0x000000242524723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000282912723eULL, 0x000fe400000000ffULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x000000161716723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000000262726723eULL, 0x000fc400000000ffULL, 0x0000000210007812ULL, 0x004fe400078ec0ffULL,
0x00000002ff117819ULL, 0x000fe40000011610ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200057811ULL, 0x040fe400078ff8ffULL, 0x00000004000a7811ULL, 0x040fe400078ff8ffULL,
0x00000006000d7811ULL, 0x000fc400078ff8ffULL, 0x0000000702007812ULL, 0x100fe400078e7811ULL,
0x00000008102d7811ULL, 0x002fe400078ff0ffULL, 0x0000000705087812ULL, 0x100fe200078e7811ULL,
0x0000000811097824ULL, 0x000fe200078e0200ULL, 0x000000070a0c7812ULL, 0x000fe200078e7811ULL,
0x0000080041007824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x100fe200078e782dULL,
0x00000008110b7824ULL, 0x040fe200078e0208ULL, 0x000000070a0a7812ULL, 0x100fe200078e782dULL,
0x00000008110f7824ULL, 0x000fe200078e020cULL, 0x0000000705057812ULL, 0x000fc400078e782dULL,
0x000000070d0e7812ULL, 0x000fe200078e7811ULL, 0x000000082d197824ULL, 0x000fe200078e020aULL,
0x000000070d087812ULL, 0x000fe200078e782dULL, 0x000000082d0d7824ULL, 0x040fe200078e0202ULL,
0x0000a00000027810ULL, 0x000fe20007ffe0ffULL, 0x00000008100a7824ULL, 0x000fe400078e00ffULL,
0x000000082d157824ULL, 0x000fe200078e0205ULL, 0x000000303105723eULL, 0x000fe200000000ffULL,
0x0000000811117824ULL, 0x000fe200078e020eULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000082d2d7824ULL, 0x000fe200078e0208ULL, 0x000000343508723eULL, 0x000fe200000000ffULL,
0x000000100d137824ULL, 0x100fe200078e0202ULL, 0x00000020210e723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x00005410052e7816ULL, 0x000fe20000000008ULL,
0x000000100b0d7824ULL, 0x000fc400078e0202ULL, 0x0000001015157824ULL, 0x100fe400078e0202ULL,
0x000000100f0f7824ULL, 0x100fe400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x100fe400078e0202ULL, 0x000000102d2d7824ULL, 0x000fe400078e0202ULL,
0x00000001090b7824ULL, 0x000fe200078e020aULL, 0x000000142f09723eULL, 0x000fe200000000ffULL,
0x000000010a107824ULL, 0x040fe200078e0213ULL, 0x00007632052f7816ULL, 0x000fe20000000008ULL,
0x000000010a0d7824ULL, 0x040fe200078e020dULL, 0x000000323305723eULL, 0x000fe200000000ffULL,
0x000000010a157824ULL, 0x040fe200078e0215ULL, 0x0000002a2b13723eULL, 0x000fe200000000ffULL,
0x000000010a0c7824ULL, 0x040fe200078e020fULL, 0x0000002e0b007388ULL, 0x0003e20000000a00ULL,
0x000000010a117824ULL, 0x040fe200078e0211ULL, 0x00000022230f723eULL, 0x000fe200000000ffULL,
0x000000010a197824ULL, 0x000fc400078e0219ULL, 0x000000010a2d7824ULL, 0x000fe200078e022dULL,
0x00000018390a723eULL, 0x000fc800000000ffULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe4000000000aULL, 0x0000001a1b0b723eULL, 0x002fc600000000ffULL,
0x000000080d007388ULL, 0x0003e20000000a00ULL, 0x00005410160a7816ULL, 0x140fe4000000000bULL,
0x00007632160b7816ULL, 0x000fe4000000000bULL, 0x000054101c087816ULL, 0x142fe4000000000eULL,
0x000076321c097816ULL, 0x000fe4000000000eULL, 0x000054101e0e7816ULL, 0x140fe4000000000fULL,
0x000076321e0f7816ULL, 0x000fe2000000000fULL, 0x000000080c007388ULL, 0x0003e40000000a00ULL,
0x0000541024087816ULL, 0x002fc40000000012ULL, 0x0000763224097816ULL, 0x000fe40000000012ULL,
0x0000541026127816ULL, 0x140fe40000000013ULL, 0x0000763226137816ULL, 0x000fe20000000013ULL,
0x0000000811007388ULL, 0x0003e40000000a00ULL, 0x0000541005087816ULL, 0x142fe40000000036ULL,
0x0000763205097816ULL, 0x000fca0000000036ULL, 0x0000000810007388ULL, 0x0003e80000000a00ULL,
0x0000000a15007388ULL, 0x0005e80000000a00ULL, 0x0000000e19007388ULL, 0x0005e20000000a00ULL,
0x00000300ff097624ULL, 0x002fc600078e00ffULL, 0x000000122d007388ULL, 0x0005e40000000a00ULL,
0x000000010900780cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00002ca000008947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x004e620000000000ULL,
0x0000580009057a24ULL, 0x000fe200078e02ffULL, 0x000000ff4100720cULL, 0x000fe20003f25270ULL,
0x00002000ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000000002a7919ULL, 0x000ea80000002700ULL,
0x00000000000b7919ULL, 0x000ea20000002600ULL, 0x00000010080e7824ULL, 0x042fe200078e0200ULL,
0x0000002008257810ULL, 0x000fc40007ffe0ffULL, 0x0000004008277810ULL, 0x040fe40007ffe0ffULL,
0x00a000000e107984ULL, 0x0002e20000000c00ULL, 0x0000006008297810ULL, 0x000fe20007ffe0ffULL,
0x000058002a2a7a24ULL, 0x004fe400078e020bULL, 0x00a200000e147984ULL, 0x0002a20000000c00ULL,
0x00006600050b7a24ULL, 0x000fe200078e02ffULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x000003002a057a24ULL, 0x000fe200078e02ffULL, 0x00a400000e187984ULL, 0x0003240000000c00ULL,
0x00001fff0b0a7811ULL, 0x000fe200078e40ffULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x00a600000e1c7984ULL, 0x0002620000000c00ULL, 0x000000ff4100720cULL, 0x000fc60000705670ULL,
0x000000070a0c7211ULL, 0x000fca00078f98ffULL, 0x00006c000c0c7625ULL, 0x000fcc00078e000dULL,
0x00000800410c7825ULL, 0x000fcc00078e000cULL, 0x0000001025247825ULL, 0x000fc800078e000cULL,
0x0000001027267825ULL, 0x000fc800078e000cULL, 0x0000001029287825ULL, 0x000fc800078e000cULL,
0x0000001008227825ULL, 0x000fe200078e000cULL, 0x01ffffff0b0c7812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x00cea20000000000ULL,
0x00000080ff217424ULL, 0x000fe400078e00ffULL, 0x0000000107207824ULL, 0x040fe400078e020cULL,
0x00006c00070e7625ULL, 0x002fc800078e0021ULL, 0x00006c0020207625ULL, 0x000fc800078e0021ULL,
0x000000100b0d7824ULL, 0x004fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc8000001160bULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000e0b0e7210ULL, 0x140fe40007b5e00dULL, 0x000000200b207210ULL, 0x000fe40007d9e00dULL,
0x0000000fff0f7210ULL, 0x000fe400017e64ffULL, 0x00000021ff217210ULL, 0x000fc600027ea4ffULL,
0x000000040e007986ULL, 0x0003e8000c101906ULL, 0x0000000620007986ULL, 0x0003e4000c101906ULL,
0x0000001022007986ULL, 0x00c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001424007986ULL, 0x0005e8000c101d06ULL, 0x0000001826007986ULL, 0x0105e8000c101d06ULL,
0x0000001c28007986ULL, 0x0025e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0xffffffff090b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a002a067625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b060679a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0600720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff047807ULL, 0x000fca0000000000ULL,
0x00000004ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff047984ULL, 0x002e640000000000ULL,
0x000000ff0400720cULL, 0x002fda0003f05270ULL, 0x0000283000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff067819ULL, 0x000fe20000011608ULL,
0x0000001008047824ULL, 0x000fe200078e00ffULL, 0x00000001050e7810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff157424ULL, 0x004fe200078e00ffULL, 0x0000000c06167812ULL, 0x000fe400078ec0ffULL,
0x0000007004177812ULL, 0x000fe200078ec0ffULL, 0x00006c0005067625ULL, 0x000fc800078e0015ULL,
0x00006c000e0e7625ULL, 0x000fe200078e0015ULL, 0x0000000616107210ULL, 0x000fc8000791e017ULL,
0x0000000e16067210ULL, 0x000fe40007b5e017ULL, 0x00000007ff117210ULL, 0x000fe400007e24ffULL,
0x0000000fff077210ULL, 0x000fc600017e64ffULL, 0x0000000610047981ULL, 0x000368000c1e1900ULL,
0x0000000606077981ULL, 0x000362000c1e1900ULL, 0x000000020900780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0015ULL, 0x0000000e160e7210ULL, 0x000fc8000791e017ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e0b7981ULL, 0x000362000c1e1900ULL,
0x000000040900780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0015ULL,
0x0000000e160e7210ULL, 0x000fc8000791e017ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e0d7981ULL, 0x000362000c1e1900ULL, 0x000000040900780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0015ULL, 0x0000000e160e7210ULL, 0x000fc8000791e017ULL,
0x0000000fff0f7210ULL, 0x000fcc00007e24ffULL, 0x000000060e0f7981ULL, 0x000362000c1e1900ULL,
0x000000060900780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000505107810ULL, 0x002fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e0015ULL,
0x0000001016107210ULL, 0x000fc8000791e017ULL, 0x00000011ff117210ULL, 0x000fcc00007e24ffULL,
0x0000000610117981ULL, 0x000362000c1e1900ULL, 0x000000060900780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080900780cULL, 0x002fe40003f06070ULL,
0x0000000605127810ULL, 0x000fca0007ffe0ffULL, 0x00006c0012127625ULL, 0x000fca00078e0015ULL,
0x0000001216127210ULL, 0x000fe40007a3e017ULL, 0x0000000705140810ULL, 0x000fe40007ffe0ffULL,
0x00000013ff137210ULL, 0x000fc60000fe44ffULL, 0x00006c0014140625ULL, 0x000fca00078e0015ULL,
0x0000001416140210ULL, 0x000fe40007c7e017ULL, 0x0000000612177981ULL, 0x000364000c1e1900ULL,
0x00000015ff150210ULL, 0x000fcc0001fe84ffULL, 0x0000000614150981ULL, 0x000366000c1e1900ULL,
0x0000000709097810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff097819ULL, 0x000fc80000011609ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff147224ULL, 0x004fe400078e00ffULL, 0x000000ffff197224ULL, 0x020fe400078e0004ULL,
0x0000000814167824ULL, 0x040fe200078e00ffULL, 0x0000000114147810ULL, 0x000fc80007ffe0ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x000000091400720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000816127810ULL, 0x040fe40007ffe0ffULL,
0x0000000116067810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000001904047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x00000001ff0e7819ULL, 0x000fe20000011608ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001008067824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x0000007006197812ULL, 0x000fc800078ec0ffULL,
0x000000120e127210ULL, 0x000fc80007b3e019ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612197981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000916067810ULL, 0x040fe40007ffe0ffULL, 0x00000002160e7810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000000704047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105067824ULL, 0x000fe200078e0206ULL, 0x00000001ff107819ULL, 0x000fe20000011608ULL,
0x00000080ff077424ULL, 0x000fe400078e00ffULL, 0x00000010080e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0006067625ULL, 0x000fc600078e0007ULL,
0x000000700e137812ULL, 0x002fc800078ec0ffULL, 0x0000000610067210ULL, 0x000fc80007b3e013ULL,
0x00000007ff077210ULL, 0x000fcc0000fe64ffULL, 0x0000000606077981ULL, 0x000366000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a16127810ULL, 0x042fe40007ffe0ffULL,
0x0000000316067810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000b04047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x00000001ff0e7819ULL, 0x000fe20000011608ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001008067824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x00000070060b7812ULL, 0x000fc800078ec0ffULL,
0x000000120e127210ULL, 0x000fc80007b3e00bULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x00000006120b7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b16127810ULL, 0x042fe40007ffe0ffULL, 0x0000000416067810ULL, 0x000fe40007ffe0ffULL,
0x0000030012007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000000d04047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105127824ULL, 0x000fe200078e0212ULL, 0x00000001ff0e7819ULL, 0x000fe20000011608ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001008067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x00000070060d7812ULL, 0x000fc800078ec0ffULL, 0x000000120e127210ULL, 0x000fc80007b3e00dULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x00000006120d7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c160e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000516067810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000f04047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x00000001ff107819ULL, 0x000fe20000011608ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001008067824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007006137812ULL, 0x002fc800078ec0ffULL,
0x0000000e100e7210ULL, 0x000fc80007b3e013ULL, 0x0000000fff0f7210ULL, 0x000fcc0000fe64ffULL,
0x000000060e0f7981ULL, 0x000366000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d16107810ULL, 0x040fe40007ffe0ffULL, 0x0000000616067810ULL, 0x000fe40007ffe0ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000001104047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105107824ULL, 0x000fe200078e0210ULL, 0x00000001ff0e7819ULL, 0x002fe20000011608ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001008067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0010107625ULL, 0x000fc600078e0011ULL,
0x0000007006137812ULL, 0x000fc800078ec0ffULL, 0x000000100e107210ULL, 0x000fc80007b3e013ULL,
0x00000011ff117210ULL, 0x000fcc0000fe64ffULL, 0x0000000610117981ULL, 0x000366000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e16127810ULL, 0x042fe40007ffe0ffULL,
0x0000000716067810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000001704047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x00000001ff0e7819ULL, 0x000fe20000011608ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001008067824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x0000007006177812ULL, 0x000fc800078ec0ffULL,
0x000000120e127210ULL, 0x000fc80007b3e017ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f16127810ULL, 0x002fe40007ffe0ffULL, 0x0000001504047209ULL, 0x000fe40007810000ULL,
0x0000030012007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105127824ULL, 0x000fe200078e0212ULL, 0x00000001ff0e7819ULL, 0x000fe20000011608ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001008067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x0000007006157812ULL, 0x000fc800078ec0ffULL, 0x000000120e127210ULL, 0x000fc80007a3e015ULL,
0x00000013ff137210ULL, 0x000fca0000fe44ffULL, 0x0000000612157981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x000ee40000000000ULL,
0x0000001008067824ULL, 0x00afe200078e00ffULL, 0x00000001ff077819ULL, 0x020fc80000011608ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000407007388ULL, 0x0003e40000000800ULL,
0x000000050a0e7211ULL, 0x000fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0f7424ULL, 0x000fe200078e00ffULL, 0x000000070800780cULL, 0x040fe20003f04070ULL,
0x0000001008077824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011608ULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x00000015ff067819ULL, 0x000fe20000011641ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000080041047824ULL, 0x000fe200078e00ffULL, 0x0000000c09107812ULL, 0x004fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000002008117810ULL, 0x000fe20007ffe0ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000040e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105168824ULL, 0x000fe200078e020cULL, 0x0000004008137810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x0000006008157810ULL, 0x000fe20007ffe0ffULL,
0x0000000107097824ULL, 0x000fe200078e0210ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000010f0f7824ULL, 0x000fe200008e0606ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff188424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000100041077824ULL, 0x000fe200078e00ffULL, 0x0000000009097984ULL, 0x000e620000000800ULL,
0x00006c0016168625ULL, 0x000fe200078e0017ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000001011107825ULL, 0x000fc800078e000eULL, 0x0000001013127825ULL, 0x000fc800078e000eULL,
0x0000001015147825ULL, 0x000fc800078e000eULL, 0x00000010411d8824ULL, 0x000fe400078e0208ULL,
0x00006c0005188625ULL, 0x000fc600078e0018ULL, 0x000045801d1d8811ULL, 0x000fe200078e20ffULL,
0x00000010080d7824ULL, 0x040fe400078e0207ULL, 0x00000010080e7825ULL, 0x000fc800078e000eULL,
0x00000010411f8824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e0d7faeULL, 0x0005e2000b901c46ULL, 0x0000001008168825ULL, 0x000fc600078e0016ULL,
0x000041801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000001008188825ULL, 0x000fe200078e0018ULL,
0x00380000100d7faeULL, 0x0007e6000b901c46ULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x00580000120d7faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x004fc6000001ff00ULL,
0x00780000140d7faeULL, 0x0005e8000b901c46ULL, 0x00000000161d8faeULL, 0x000be2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x00000000181f8faeULL, 0x0007e2000b901c46ULL,
0x0000000000127805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000147805ULL, 0x004fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000d5000009947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x002fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fca00078e00ffULL, 0x000000013a2c7810ULL, 0x000fc80007ffe0ffULL,
0x000003002c007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x00000001053f7824ULL, 0x000fe200078e022cULL, 0x000000070800780cULL, 0x000fe20003f24070ULL,
0x00002000ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000012c327812ULL, 0x000fe400078ec0ffULL,
0x0000003f0a2e7211ULL, 0x000fe400078f98ffULL, 0x0000002008337810ULL, 0x040fe40007ffe0ffULL,
0x0000004008377810ULL, 0x000fe20007ffe0ffULL, 0x00006c002e2e7625ULL, 0x000fe200078e002fULL,
0x00000060083d7810ULL, 0x000fc60007ffe0ffULL, 0x000000010c349824ULL, 0x000fe200078e023fULL,
0x000000042e307210ULL, 0x000fe20007f1e0ffULL, 0x000008002c2e7824ULL, 0x000fe400078e00ffULL,
0x00000080ff359424ULL, 0x000fe400078e00ffULL, 0x000000012f317824ULL, 0x000fe200000e0606ULL,
0x000008002e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000241399824ULL, 0x140fe400078e0232ULL,
0x0000000241439824ULL, 0x000fc400078e0232ULL, 0x00000001072f7824ULL, 0x000fe400078e022eULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00000010083b7824ULL, 0x000fe400078e022fULL,
0x00000010332e7825ULL, 0x000fc800078e0030ULL, 0x0000001037327825ULL, 0x000fc800078e0030ULL,
0x0000001008367825ULL, 0x000fc800078e0030ULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000363b7faeULL, 0x0003e6000b901c46ULL,
0x00006c0034349625ULL, 0x000fe200078e0035ULL, 0x003800002e3b7faeULL, 0x0003e6000b901c46ULL,
0x00000008393d9824ULL, 0x000fe200078e0208ULL, 0x00580000323b7faeULL, 0x0003e2000b901c46ULL,
0x00006c003f389625ULL, 0x000fc600078e0038ULL, 0x000045803d3d9811ULL, 0x000fe200078e20ffULL,
0x00000008433f9824ULL, 0x000fe200078e0208ULL, 0x00780000303b7faeULL, 0x0003e2000b901c46ULL,
0x0000001008349825ULL, 0x000fc600078e0034ULL, 0x000041803f3f9811ULL, 0x000fe200078e20ffULL,
0x0000001008389825ULL, 0x000fe200078e0038ULL, 0x00000000343d9faeULL, 0x0003e8000b901c46ULL,
0x00000000383f9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000803a2e7824ULL, 0x002fe200078e00ffULL, 0x00000001ff307819ULL, 0x100fe20000011608ULL,
0x00000010082f7824ULL, 0x000fe200078e00ffULL, 0x00000002ff537819ULL, 0x000fc40000011608ULL,
0x000000802e2e7812ULL, 0x000fe400078ec0ffULL, 0x000000702f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000853347824ULL, 0x000fe200078e00ffULL, 0x0000000c30307812ULL, 0x000fe200078ec0ffULL,
0x00000100412e7824ULL, 0x000fe200078e022eULL, 0x00000007533d7812ULL, 0x040fe400078ec0ffULL,
0x00000053ff3f7212ULL, 0x000fe400078e33ffULL, 0x0000002e30317210ULL, 0x000fe20007ffe02fULL,
0x0000000853307824ULL, 0x040fe200078e00ffULL, 0xfffffff8342f7812ULL, 0x000fe200078ee23dULL,
0x00000008532e7824ULL, 0x000fc600078e00ffULL, 0x0000000130337812ULL, 0x000fe200078ef63dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031327984ULL, 0x000e620000000800ULL,
0x0000000230357812ULL, 0x140fe400078ef63dULL, 0x0000000330377812ULL, 0x140fe200078ef63dULL,
0x0045800031517984ULL, 0x0004e20000000800ULL, 0x0000000430397812ULL, 0x140fe400078ef63dULL,
0x00000005303b7812ULL, 0x140fe400078ef63dULL, 0x00000006303d7812ULL, 0x000fe200078ef63dULL,
0x000008003a307824ULL, 0x000fe200078e00ffULL, 0xfffffff82e3f7812ULL, 0x000fe200078ee23fULL,
0x0000000408317824ULL, 0x004fe200078e00ffULL, 0x00000008532e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e002cULL, 0x0000080030307812ULL, 0x000fc400078ec0ffULL,
0x0000002eff4f7212ULL, 0x000fe200078e33ffULL, 0x000000082e347824ULL, 0x040fe200078e00ffULL,
0x0000018007307810ULL, 0x000fe20007ffe030ULL, 0x000000082e457824ULL, 0x000fe200078e00ffULL,
0x000003003a007a0cULL, 0x000fe20003f06070ULL, 0x000000082e437824ULL, 0x000fe200078e00ffULL,
0xfffffff8344f7812ULL, 0x000fe200078ee24fULL, 0x000000102f2f7824ULL, 0x100fe200078e0230ULL,
0x000000072e347812ULL, 0x000fe200078ec0ffULL, 0x000000103f3f7824ULL, 0x100fe400078e0230ULL,
0x0000001033337824ULL, 0x000fe200078e0230ULL, 0x0000000243477812ULL, 0x000fe200078ef634ULL,
0x0000001035357824ULL, 0x000fe200078e0230ULL, 0x0000000343497812ULL, 0x000fe200078ef634ULL,
0x0000001037377824ULL, 0x000fe200078e0230ULL, 0x00000004434b7812ULL, 0x000fe200078ef634ULL,
0x0000001039397824ULL, 0x000fe200078e0230ULL, 0x00000005434d7812ULL, 0x000fe200078ef634ULL,
0x000000103b3b7824ULL, 0x000fc400078e0230ULL, 0x000000103d3d7824ULL, 0x000fe200078e0230ULL,
0x0000003209327221ULL, 0x002fe20000010100ULL, 0x0000001047477824ULL, 0x100fe400078e0230ULL,
0x0000001049497824ULL, 0x100fe200078e0230ULL, 0x3fb8aa3b32367820ULL, 0x000fe20000410000ULL,
0x0000000c31327812ULL, 0x000fe200078ec0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0230ULL,
0xfffffff845317812ULL, 0x000fe200078ee234ULL, 0x000000104d4d7824ULL, 0x000fe200078e0230ULL,
0x0000000143457812ULL, 0x000fe200078ef634ULL, 0x000000012f2f7824ULL, 0x000fe200078e0232ULL,
0x0000003600367308ULL, 0x000ee20000000800ULL, 0x00000001323f7824ULL, 0x040fe200078e023fULL,
0x0000000643437812ULL, 0x000fe200078ef634ULL, 0x0000000132337824ULL, 0x000fc400078e0233ULL,
0x000000002f2f7984ULL, 0x000e620000000800ULL, 0x0000000132357824ULL, 0x040fe400078e0235ULL,
0x0000000132377824ULL, 0x040fe200078e0237ULL, 0x000000003f3f7984ULL, 0x000ea20000000800ULL,
0x0000000132397824ULL, 0x040fe400078e0239ULL, 0x00000001323b7824ULL, 0x040fe200078e023bULL,
0x0000000033337984ULL, 0x000fe20000000800ULL, 0x00000001323d7824ULL, 0x000fe400078e023dULL,
0x0000001031317824ULL, 0x100fe200078e0230ULL, 0x0000000035357984ULL, 0x000fe20000000800ULL,
0x0000001045457824ULL, 0x000fe200078e0230ULL, 0x0000005136367220ULL, 0x008fe20000410000ULL,
0x0000000132317824ULL, 0x040fe200078e0231ULL, 0x0000000037377984ULL, 0x000fe20000000800ULL,
0x0000000132457824ULL, 0x000fe200078e0245ULL, 0x0000002d362d7221ULL, 0x000fe20000010000ULL,
0x0000000132477824ULL, 0x040fe200078e0247ULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000000132497824ULL, 0x000fc400078e0249ULL, 0x00000001324b7824ULL, 0x040fe200078e024bULL,
0x000000003b3b7984ULL, 0x000fe20000000800ULL, 0x00000001324d7824ULL, 0x040fe400078e024dULL,
0x0000001043437824ULL, 0x100fe200078e0230ULL, 0x000000003d3d7984ULL, 0x000fe20000000800ULL,
0x000000104f4f7824ULL, 0x000fe400078e0230ULL, 0x0000000132437824ULL, 0x040fe200078e0243ULL,
0x00001f5336347589ULL, 0x000ee200000e0000ULL, 0x00000001324f7824ULL, 0x000fc600078e024fULL,
0x0000000031317984ULL, 0x000fe80000000800ULL, 0x0000000045457984ULL, 0x000f220000000800ULL,
0x3000002fff307230ULL, 0x102fe40000004100ULL, 0x2000002fff517230ULL, 0x000fe20000004100ULL,
0x0000000047477984ULL, 0x000fe20000000800ULL, 0x2000003fff2f7230ULL, 0x104fe40000004100ULL,
0x3000003fff327230ULL, 0x000fe20000004100ULL, 0x0000000049497984ULL, 0x000fe80000000800ULL,
0x000000004b4b7984ULL, 0x000fe80000000800ULL, 0x000000004d4d7984ULL, 0x000fe20000000800ULL,
0x00000034301d7223ULL, 0x088fe2000001001dULL, 0x30000035ff307230ULL, 0x000fe20000004100ULL,
0x000000342f1c7223ULL, 0x080fe2000001001cULL, 0x0000000043437984ULL, 0x000fe20000000800ULL,
0x20000033ff2f7230ULL, 0x000fe20000004100ULL, 0x00000034511e7223ULL, 0x080fe2000001001eULL,
0x0000003430177223ULL, 0x080fe20000010017ULL, 0x000000004f4f7984ULL, 0x000fe20000000800ULL,
0x30000039ff307230ULL, 0x000fe20000004100ULL, 0x000000342f1a7223ULL, 0x080fe2000001001aULL,
0x20000037ff2f7230ULL, 0x000fe20000004100ULL, 0x00001f2e36367589ULL, 0x0002a200000e0000ULL,
0x00000034321b7223ULL, 0x080fe2000001001bULL, 0x0000003430137223ULL, 0x080fe20000010013ULL,
0x3000003dff307230ULL, 0x000fe20000004100ULL, 0x000000342f167223ULL, 0x000fe20000010016ULL,
0x2000003bff2f7230ULL, 0x000fc60000004100ULL, 0x00000034300f7223ULL, 0x080fe2000001000fULL,
0x30000033ff2e7230ULL, 0x002fe20000004100ULL, 0x000000342f127223ULL, 0x080fe20000010012ULL,
0x20000045ff307230ULL, 0x010fe40000004100ULL, 0x20000035ff337230ULL, 0x000fe20000004100ULL,
0x000000342e197223ULL, 0x080fe20000010019ULL, 0x30000037ff2e7230ULL, 0x000fe40000004100ULL,
0x2000003dff2f7230ULL, 0x000fe20000004100ULL, 0x0000003433187223ULL, 0x080fe20000010018ULL,
0x20000039ff337230ULL, 0x000fe20000004100ULL, 0x000000342e157223ULL, 0x080fe20000010015ULL,
0x3000003bff2e7230ULL, 0x000fe20000004100ULL, 0x000000342f107223ULL, 0x000fe20000010010ULL,
0x00000036302b7223ULL, 0x004fe2000001002bULL, 0x20000049ff307230ULL, 0x000fe20000004100ULL,
0x0000003433147223ULL, 0x080fe20000010014ULL, 0x000000342e117223ULL, 0x000fe20000010011ULL,
0x30000031ff2e7230ULL, 0x000fc40000004100ULL, 0x0000003630297223ULL, 0x080fe20000010029ULL,
0x20000047ff2f7230ULL, 0x100fe40000004100ULL, 0x000000362e0d7223ULL, 0x080fe2000001000dULL,
0x30000047ff2e7230ULL, 0x000fe40000004100ULL, 0x2000004dff307230ULL, 0x000fe20000004100ULL,
0x000000362f267223ULL, 0x080fe20000010026ULL, 0x20000031ff337230ULL, 0x000fe20000004100ULL,
0x000000362e257223ULL, 0x080fe20000010025ULL, 0x2000004bff2e7230ULL, 0x000fe20000004100ULL,
0x0000003630237223ULL, 0x080fe20000010023ULL, 0x30000045ff457230ULL, 0x000fe20000004100ULL,
0x00000036330e7223ULL, 0x080fe2000001000eULL, 0x30000049ff497230ULL, 0x000fe20000004100ULL,
0x000000362e1f7223ULL, 0x080fe2000001001fULL, 0x3000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000036452a7223ULL, 0x080fe2000001002aULL, 0x3000004dff2c7230ULL, 0x000fe20000004100ULL,
0x0000003649287223ULL, 0x080fe20000010028ULL, 0x20000043ff2f7230ULL, 0x100fe20000004100ULL,
0x000000364b247223ULL, 0x080fe20000010024ULL, 0x30000043ff2e7230ULL, 0x000fe20000004100ULL,
0x000000362c277223ULL, 0x080fe20000010027ULL, 0x2000004fff317230ULL, 0x100fe20000004100ULL,
0x000000362f227223ULL, 0x080fe20000010022ULL, 0x3000004fff307230ULL, 0x000fe20000004100ULL,
0x000000362e217223ULL, 0x000fc40000010021ULL, 0x0000003631207223ULL, 0x080fe40000010020ULL,
0x00000036300b7223ULL, 0x000fe2000001000bULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x018000002d047810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000004047812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000af4000087802ULL, 0x000fe40000000f00ULL, 0x000050d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00047308ULL, 0x000e640000001000ULL, 0xbf80000004057423ULL, 0x002fc8000000002dULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000504047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2d7819ULL, 0x006fe40000011608ULL,
0x0000000808397811ULL, 0x000fe400078ff0ffULL, 0x0000002dff077212ULL, 0x000fe200078e33ffULL,
0x00001f2d04057589ULL, 0x000e6200000e0000ULL, 0x000000082d0a7824ULL, 0x000fe200078e00ffULL,
0x00000039ff3b7212ULL, 0x000fe200078e33ffULL, 0x00000008390c7824ULL, 0x000fe200078e00ffULL,
0x00001f3904067589ULL, 0x000ea400000e0000ULL, 0xfffffff80a3d7812ULL, 0x000fc400078ee207ULL,
0xfffffff80c3b7812ULL, 0x000fe400078ee23bULL, 0xfffffff80a077812ULL, 0x000fc600078ee22dULL,
0x000000103b3b7824ULL, 0x100fe400078e0202ULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x0000001205127220ULL, 0x042fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000000f050f7220ULL, 0x000fe20000410000ULL,
0x0000000e060e7220ULL, 0x044fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000002706047220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x000fe20000410000ULL,
0x000000072d067812ULL, 0x000fe200078ec0ffULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x0000001605167220ULL, 0x000fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000001505157220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x00000001060a7812ULL, 0x040fe200078e3cffULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x00000002060c7812ULL, 0x040fe200078e3cffULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x00000003060e7812ULL, 0x040fe200078e3cffULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000000406107812ULL, 0x040fe200078e3cffULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000000506127812ULL, 0x040fe200078e3cffULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000000606067812ULL, 0x000fe200078e3cffULL,
0x0000001c051c7220ULL, 0x000fe20000410000ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000001b05057220ULL, 0x000fe20000410000ULL, 0x0000000739147812ULL, 0x000fe200078ec0ffULL,
0x000000082d097824ULL, 0x040fe200078e020aULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x000000082d297824ULL, 0x040fe200078e0212ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x000000082d1b7824ULL, 0x040fe200078e020cULL, 0x000000230404723eULL, 0x000fe200000000ffULL,
0x000000082d237824ULL, 0x000fe200078e020eULL, 0x000000161515723eULL, 0x000fe200000000ffULL,
0x000000082d2b7824ULL, 0x000fe200078e0206ULL, 0x0000000114067812ULL, 0x000fe200078e3cffULL,
0x0000000408127824ULL, 0x000fe200078e00ffULL, 0x0000000214087812ULL, 0x040fe200078e3cffULL,
0x0000000839167824ULL, 0x000fe200078e00ffULL, 0x00000003140a7812ULL, 0x040fe200078e3cffULL,
0x000000082d277824ULL, 0x000fe200078e0210ULL, 0x00000004140c7812ULL, 0x040fe200078e3cffULL,
0x00000008392f7824ULL, 0x040fe200078e0206ULL, 0x00000005140e7812ULL, 0x040fe200078e3cffULL,
0x0000000839317824ULL, 0x040fe200078e0208ULL, 0x0000000614107812ULL, 0x000fe200078e3cffULL,
0x0000000839337824ULL, 0x000fe200078e020aULL, 0x000000181717723eULL, 0x000fe200000000ffULL,
0x0000000839357824ULL, 0x040fe200078e020cULL, 0xfffffff8162d7812ULL, 0x000fe200078ee239ULL,
0x0000000839377824ULL, 0x040fe200078e020eULL, 0x0000000c12187812ULL, 0x000fe200078ec0ffULL,
0x0000000839397824ULL, 0x000fe200078e0210ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x000000103d087824ULL, 0x100fe200078e0202ULL, 0x0000001a1919723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x0000001c0505723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0202ULL, 0x0000001f241f723eULL, 0x000fe200000000ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x0000000118067824ULL, 0x000fe200078e0207ULL, 0x000000200b0b723eULL, 0x000fe200000000ffULL,
0x0000001027277824ULL, 0x000fc400078e0202ULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000001d06007388ULL, 0x0003e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102f2f7824ULL, 0x100fe400078e0202ULL, 0x0000001031317824ULL, 0x100fe400078e0202ULL,
0x0000001033337824ULL, 0x100fe400078e0202ULL, 0x0000001035357824ULL, 0x000fc400078e0202ULL,
0x0000001037377824ULL, 0x100fe400078e0202ULL, 0x0000001039397824ULL, 0x000fe400078e0202ULL,
0x0000000118127824ULL, 0x040fe400078e0208ULL, 0x0000000118027824ULL, 0x040fe400078e0209ULL,
0x0000000118087824ULL, 0x040fe400078e021bULL, 0x00000001180a7824ULL, 0x040fe200078e0223ULL,
0x0000001902007388ULL, 0x0005e20000000800ULL, 0x00000001180c7824ULL, 0x000fc400078e0227ULL,
0x00000001180e7824ULL, 0x040fe200078e0229ULL, 0x0000001708007388ULL, 0x0005e20000000800ULL,
0x0000000118107824ULL, 0x040fe400078e022bULL, 0x0000000118147824ULL, 0x040fe200078e022dULL,
0x000000150a007388ULL, 0x0005e20000000800ULL, 0x00000001182f7824ULL, 0x040fe400078e022fULL,
0x0000000118067824ULL, 0x042fe200078e0231ULL, 0x000000130c007388ULL, 0x0005e20000000800ULL,
0x0000000118337824ULL, 0x000fc400078e0233ULL, 0x0000000118167824ULL, 0x040fe200078e0235ULL,
0x000000110e007388ULL, 0x0005e20000000800ULL, 0x00000001181a7824ULL, 0x040fe400078e023bULL,
0x0000000118377824ULL, 0x040fe200078e0237ULL, 0x0000000f10007388ULL, 0x0005e20000000800ULL,
0x0000000118187824ULL, 0x000fc600078e0239ULL, 0x0000000512007388ULL, 0x0005e80000000800ULL,
0x0000000d14007388ULL, 0x0005e80000000800ULL, 0x0000002a2f007388ULL, 0x0005e80000000800ULL,
0x0000002506007388ULL, 0x0005e80000000800ULL, 0x0000002833007388ULL, 0x0005e80000000800ULL,
0x0000001f16007388ULL, 0x0005e80000000800ULL, 0x0000000437007388ULL, 0x0005e80000000800ULL,
0x0000002118007388ULL, 0x0005e80000000800ULL, 0x0000000b1a007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000147919ULL, 0x004e620000002600ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000580000057ab9ULL, 0x000fc40000000800ULL,
0x00000000001b7919ULL, 0x000ee20000000000ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000001014057824ULL, 0x002fc600078e00ffULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x0000001014167824ULL, 0x040fe200078e00ffULL, 0x00000003ff027819ULL, 0x008fe2000001161bULL,
0x00000010141d7824ULL, 0x000fe200078e00ffULL, 0x000000201b1a7810ULL, 0x040fe40007ffe0ffULL,
0x000000401b1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000601b1f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff005047812ULL, 0x000fc400078ee202ULL, 0x00000003ff057819ULL, 0x000fe4000001161aULL,
0x00000003ff157819ULL, 0x000fe4000001161cULL, 0x00000003ff187819ULL, 0x000fe4000001161fULL,
0x0000000702027812ULL, 0x000fe400078e481bULL, 0x0000000705067812ULL, 0x000fe400078e481aULL,
0x0000000715087812ULL, 0x000fc400078e481cULL, 0xfffffff016167812ULL, 0x000fe400078ee205ULL,
0x00000007180a7812ULL, 0x000fe400078e481fULL, 0x0ffffff802057812ULL, 0x000fe200078ef81bULL,
0x0000001014027824ULL, 0x000fe200078e00ffULL, 0x0ffffff806077812ULL, 0x000fe400078ef81aULL,
0x0ffffff808097812ULL, 0x000fe200078ef81cULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0ffffff80a0b7812ULL, 0x000fe200078ef81fULL, 0x0000001007087824ULL, 0x100fe200078e0200ULL,
0xfffffff002177812ULL, 0x000fe200078ee215ULL, 0x00000010090c7824ULL, 0x100fe200078e0200ULL,
0x000000071b027812ULL, 0x000fe200078ec0ffULL, 0x000000100b107824ULL, 0x000fe200078e0200ULL,
0x0000000404007c10ULL, 0x000fe2000ff1e0ffULL, 0x00a0000008087984ULL, 0x000fe20000000c00ULL,
0xfffffff01d187812ULL, 0x000fc400078ee218ULL, 0x1ffffff8021d7812ULL, 0x000fe200078ef803ULL,
0x00a0000005047984ULL, 0x000e620000000c00ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005a0000147a11ULL, 0x000fe400078048ffULL, 0x00a000000c0c7984ULL, 0x000ea20000000c00ULL,
0x000000071c027812ULL, 0x000fe400078ec0ffULL, 0x00005b0000157a11ULL, 0x000fe200000f4c19ULL,
0x00a0000010107984ULL, 0x000ee20000000c00ULL, 0x000000071a007812ULL, 0x000fc400078ec0ffULL,
0x000000071f1c7812ULL, 0x000fe400078ec0ffULL, 0x00000004161e7c10ULL, 0x000fe4000ff1e0ffULL,
0x1ffffff802217812ULL, 0x100fe400078ef803ULL, 0x1ffffff8001f7812ULL, 0x000fe400078ef803ULL,
0x0000000417027c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000000418007c10ULL, 0x000fc4000ff5e0ffULL, 0x00005a001e167a11ULL, 0x000fe200078048ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x00005a0002187a11ULL, 0x000fe200078248ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x00005a00001a7a11ULL, 0x000fe400078448ffULL,
0x00005b001e177a11ULL, 0x000fe400000f4c17ULL, 0x00005b0002197a11ULL, 0x000fe400008f4c19ULL,
0x1ffffff81c237812ULL, 0x000fe200078ef803ULL, 0x000000101d027825ULL, 0x000fe200078e0014ULL,
0x00005b00001b7a11ULL, 0x000fc600010f4c1bULL, 0x000000101f147825ULL, 0x000fe200078e0016ULL,
0x0000000402007986ULL, 0x002fe6000c101d06ULL, 0x0000001021167825ULL, 0x000fe200078e0018ULL,
0x0000000814007986ULL, 0x000fe6000c101d06ULL, 0x0000001023187825ULL, 0x000fe200078e001aULL,
0x0000000c16007986ULL, 0x004fe8000c101d06ULL, 0x0000001018007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff067624ULL, 0x000fe200078e00ffULL,
0x03ffffff41007812ULL, 0x000fe200078ec0ffULL, 0x00006900ff077624ULL, 0x000fc400078e00ffULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x00000004430d7824ULL, 0x000fe200078e0200ULL,
0x00000006063b7981ULL, 0x000368000c1e9900ULL, 0x000000400d00720cULL, 0x000fe40003f06070ULL,
0x0000000143097810ULL, 0x000fd60007ffe0ffULL, 0x000000023e048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e020dULL, 0x0000600004048625ULL, 0x000fca00078e0017ULL,
0x0000000604038981ULL, 0x000362000c1e1900ULL, 0x0000000e0900720cULL, 0x000fe20003f06070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x00000040150c7824ULL, 0x000fe400078e00ffULL,
0x0000004041027824ULL, 0x000fd200078e00ffULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x002e620000000000ULL, 0x000000040c0c7e24ULL, 0x020fe2000f8e0203ULL,
0x0000200041157811ULL, 0x000fe200078e68ffULL, 0x00000100ff257424ULL, 0x000fe400078e00ffULL,
0x0000010043007824ULL, 0x000fca00078e0202ULL, 0x000000000f097217ULL, 0x000fca0007800000ULL,
0x0000000109007824ULL, 0x000fe200078e0a00ULL, 0x00000002ff217819ULL, 0x102fe20000011617ULL,
0x0000001017237824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x000fe40000011617ULL,
0x0000003f21057812ULL, 0x040fe400078ec0ffULL, 0x0000001021277810ULL, 0x040fe40007ffe0ffULL,
0x0000000821197810ULL, 0x000fe20007ffe0ffULL, 0x000000010c057824ULL, 0x000fe200078e0205ULL,
0x0000003f270b7812ULL, 0x000fc400078ec0ffULL, 0x0000003f19077812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e0025ULL, 0x0000003023237812ULL, 0x000fe400078ec0ffULL,
0x0000001821297810ULL, 0x040fe20007ffe0ffULL, 0x000000010c087824ULL, 0x000fe200078e020bULL,
0x0000002304107210ULL, 0x000fe20007f1e0ffULL, 0x000000010c077824ULL, 0x000fe200078e0207ULL,
0x0000000314147812ULL, 0x000fe200078e4817ULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0x00000028211d7810ULL, 0x000fc40007ffe0ffULL, 0x00000020211b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0025ULL, 0x0000002308047210ULL, 0x080fe40007f3e0ffULL,
0x0ffffffc140a7812ULL, 0x000fe200078ef817ULL, 0x000000ffff117224ULL, 0x000fe200000e0605ULL,
0x0000003f29057812ULL, 0x000fe400078ec0ffULL, 0x0000002306127210ULL, 0x000fe20007f1e0ffULL,
0x000000100a177824ULL, 0x000fe200078e0215ULL, 0x0000003f1d0b7812ULL, 0x000fe200078ec0ffULL,
0x000000010c067824ULL, 0x040fe200078e0205ULL, 0x00000030211f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0609ULL, 0x000000001900720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0x000000002100720cULL, 0x000fe20003f06070ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x0000003f1b077812ULL, 0x000fe200078ec0ffULL,
0x000000010c0b7824ULL, 0x000fe200078e020bULL, 0x0000003821217810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc19167812ULL, 0x000fe200078ee214ULL, 0x000000010c087824ULL, 0x000fe200078e0207ULL,
0x000000002700720cULL, 0x080fe20003fa6070ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0025ULL,
0x000000002900720cULL, 0x000fc60003f86070ULL, 0x0000001016197824ULL, 0x000fe200078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e2000c101c46ULL,
0x00005e0008087625ULL, 0x080fe200078e0025ULL, 0x000000002100720cULL, 0x080fe40003f06070ULL,
0x0000000012197faeULL, 0x0005e2000c901c46ULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x0000002308087210ULL, 0x080fe40007f7e0ffULL, 0x000000001f00720cULL, 0x080fe20003f26070ULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x0000002306067210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0609ULL, 0x0000003f1f117812ULL, 0x002fe200078ec0ffULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x000000001b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x0000003f21137812ULL, 0x004fe200078ec0ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000230a127210ULL, 0x000fe20007fde0ffULL,
0x000000010c0a7824ULL, 0x040fe200078e0211ULL, 0x000000001d00720cULL, 0x000fe20003f46070ULL,
0x000000010c107824ULL, 0x000fe200078e0213ULL, 0xfffffffc27007812ULL, 0x100fe200078ee214ULL,
0x000000ffff137224ULL, 0x000fe200030e060bULL, 0xfffffffc290c7812ULL, 0x100fe200078ee214ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0025ULL, 0xfffffffc1b167812ULL, 0x000fc600078ee214ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x000000230a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000041f1f7824ULL, 0x000fe400078e00ffULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d187812ULL, 0x100fe200078ee214ULL, 0x00005e0010107625ULL, 0x000fe200078e0025ULL,
0xfffffffc1f1a7812ULL, 0x100fe400078ee214ULL, 0xfffffffc21147812ULL, 0x000fe200078ee214ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000002310107210ULL, 0x000fe20007fde0ffULL,
0x0000001000177824ULL, 0x000fc400078e0215ULL, 0x000000100c197824ULL, 0x100fe400078e0215ULL,
0x00000010161b7824ULL, 0x100fe200078e0215ULL, 0x0000000004177faeULL, 0x0003e2000e901c46ULL,
0x00000010181d7824ULL, 0x100fe400078e0215ULL, 0x000000101a1f7824ULL, 0x100fe200078e0215ULL,
0x0000000006197faeULL, 0x0003e2000e101c46ULL, 0x0000001014157824ULL, 0x000fe400078e0215ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x00000000081b7faeULL, 0x0003e8000d901c46ULL,
0x00000000121d7faeULL, 0x0003e8000d101c46ULL, 0x000000000a1f7faeULL, 0x0003e8000c901c46ULL,
0x0000000010157faeULL, 0x0003e2000c101c46ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x000000040c0c7e24ULL, 0x020fe2000f8e0203ULL,
0x00000002ff047819ULL, 0x002fc40000011600ULL, 0x00000003ff057819ULL, 0x000fe40000011600ULL,
0x0000003f04077812ULL, 0x040fe400078ec0ffULL, 0x0000000804067810ULL, 0x040fe40007ffe0ffULL,
0x0000001004097810ULL, 0x040fe40007ffe0ffULL, 0x0000001804107810ULL, 0x040fe40007ffe0ffULL,
0x0000002004137810ULL, 0x000fc40007ffe0ffULL, 0x0000002804167810ULL, 0x040fe40007ffe0ffULL,
0x0000003004197810ULL, 0x040fe20007ffe0ffULL, 0x00000004131e7824ULL, 0x000fe200078e00ffULL,
0x00000038041a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c047824ULL, 0x000fe200078e0207ULL,
0x0000003f06077812ULL, 0x040fe200078ec0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000003f090b7812ULL, 0x000fe200078ec0ffULL, 0x0000000416227824ULL, 0x000fe200078e00ffULL,
0x0000003f10117812ULL, 0x000fe200078ec0ffULL, 0x000000010c087824ULL, 0x040fe200078e0207ULL,
0x0000003f13157812ULL, 0x000fe200078ec0ffULL, 0x000000010c0a7824ULL, 0x000fe200078e020bULL,
0x0000003f16177812ULL, 0x000fe200078ec0ffULL, 0x000000010c127824ULL, 0x040fe200078e0211ULL,
0x0000003f191b7812ULL, 0x000fe200078ec0ffULL, 0x000000010c147824ULL, 0x000fe200078e0215ULL,
0x0000003f1a1d7812ULL, 0x000fe200078ec0ffULL, 0x000000010c187824ULL, 0x040fe200078e0217ULL,
0x0000000305077812ULL, 0x100fe200078e4800ULL, 0x000000010c1c7824ULL, 0x040fe200078e021bULL,
0x00002000410b7811ULL, 0x000fe200078e68ffULL, 0x000000010c207824ULL, 0x000fe200078e021dULL,
0xfffffffc06067812ULL, 0x100fe200078ee207ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e167812ULL, 0x000fe200078ee207ULL, 0x00000004090c7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc07007812ULL, 0x000fe200078ef800ULL, 0x0000000410107824ULL, 0x000fc400078e00ffULL,
0x0000000419247824ULL, 0x000fe200078e00ffULL, 0x0000003005197812ULL, 0x000fe200078ec0ffULL,
0x000000041a267824ULL, 0x000fe200078e00ffULL, 0xfffffffc221a7812ULL, 0x100fe200078ee207ULL,
0x00000100ff177424ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee207ULL,
0x00000010061d7824ULL, 0x000fe200078e020bULL, 0xfffffffc10107812ULL, 0x100fe200078ee207ULL,
0x00005e0004047625ULL, 0x080fe200078e0017ULL, 0xfffffffc241e7812ULL, 0x100fe400078ee207ULL,
0xfffffffc26227812ULL, 0x000fe200078ee207ULL, 0x00005e0008067625ULL, 0x000fe200078e0017ULL,
0x0000001904047210ULL, 0x000fc60007f1e0ffULL, 0x00000010001b7824ULL, 0x100fe200078e020bULL,
0x0000001906067210ULL, 0x000fe20007f3e0ffULL, 0x000000100c1f7824ULL, 0x100fe400078e020bULL,
0x0000001010217824ULL, 0x100fe400078e020bULL, 0x0000001016237824ULL, 0x100fe400078e020bULL,
0x000000101a257824ULL, 0x000fe400078e020bULL, 0x00005e000a087625ULL, 0x000fc800078e0017ULL,
0x000000101e277824ULL, 0x100fe200078e020bULL, 0x0000001908087210ULL, 0x000fe20007f5e0ffULL,
0x0000001022297824ULL, 0x000fe400078e020bULL, 0x00005e00120a7625ULL, 0x000fc800078e0017ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000190a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0014107625ULL, 0x000fc600078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000041b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0018127625ULL, 0x000fc800078e0017ULL,
0x00005e001c147625ULL, 0x000fc800078e0017ULL, 0x00005e0020167625ULL, 0x000fc800078e0017ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001910107210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000001912127210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001914147210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001916167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc400010e0615ULL, 0x000000ffff177224ULL, 0x000fe200018e0617ULL,
0x00000000081f7faeULL, 0x0003e8000b901c46ULL, 0x000000000a217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e8000b901c46ULL,
0x0000000014277faeULL, 0x0003e8000b901c46ULL, 0x0000000016297faeULL, 0x0003e4000b901c46ULL,
0x01060400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000034100780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000002041007824ULL, 0x004fc800078e0200ULL, 0x0000002000067824ULL, 0x002fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7800ULL, 0x0000000709097812ULL, 0x100fe400078e7800ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7800ULL, 0x0000000007147984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7800ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x0000000009107984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0017ULL,
0x0000001807007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fca00078e0013ULL, 0x0000001c09007388ULL, 0x000fe8000000cc00ULL,
0x0000000005107984ULL, 0x000e68000000cc00ULL, 0x000000000b147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x000000200b007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01060400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000e4300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000ea20000000000ULL,
0x00005800ff0c7624ULL, 0x000fe200078e00ffULL, 0x3d8000003b3b7820ULL, 0x000fe20000410000ULL,
0x000064003e3e7a24ULL, 0x000fe200078e02ffULL, 0xffffffff0e3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001041397824ULL, 0x000fe200078e00ffULL, 0x00007610ff387816ULL, 0x000fe20000000038ULL,
0x000000ffff3a7224ULL, 0x000fe400078e00ffULL, 0x000000400c0c7824ULL, 0x000fe400078e00ffULL,
0x0000010043427824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000420f00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e003aULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000100267810ULL, 0x000fe20007ffe0ffULL, 0x00000bb000007945ULL, 0x000fe20003800000ULL,
0x00000001243a7812ULL, 0x000fc400078e0cffULL, 0x00000002ff287819ULL, 0x000fe40000011626ULL,
0x000000042600780cULL, 0x040fe40003f06070ULL, 0x00000003263f7812ULL, 0x000fe200078ec0ffULL,
0x0000030028277a24ULL, 0x000fca00078e0243ULL, 0x0000000127257810ULL, 0x000fc80007ffe0ffULL,
0x0000000e2500720cULL, 0x000fe20003f26070ULL, 0x000000ffff257224ULL, 0x000fe400078e0000ULL,
0x000000ffff007224ULL, 0x000fd400078e0026ULL, 0x000005e000009947ULL, 0x020fea0003800000ULL,
0x0000010027267824ULL, 0x000fe200078e0202ULL, 0x00000002ff377819ULL, 0x104fe2000001163dULL,
0x000000043f2a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff287819ULL, 0x100fe2000001163dULL,
0x000000040c327e24ULL, 0x000fe2000f8e0203ULL, 0x00000008372b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000241317824ULL, 0x000fe200078e023aULL, 0x000000260f277217ULL, 0x000fe40007800000ULL,
0x0000003f37297812ULL, 0x000fe400078ec0ffULL, 0x0000003f2b337812ULL, 0x000fe200078ec0ffULL,
0x0000000127307824ULL, 0x000fe200078e0a26ULL, 0xfffffffc2a267812ULL, 0x100fe200078ee23dULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x0000000328347812ULL, 0x000fe200078e483dULL,
0x0000000132287824ULL, 0x040fe200078e0229ULL, 0x000000303700720cULL, 0x080fe20003f26070ULL,
0x00000001322a7824ULL, 0x000fe200078e0233ULL, 0x000000302b00720cULL, 0x040fe20003f46070ULL,
0x000000042b337824ULL, 0x000fe200078e00ffULL, 0x0000200031317811ULL, 0x000fe200078e60ffULL,
0x00005e0028287625ULL, 0x000fe200078e0027ULL, 0x0ffffffc34367812ULL, 0x000fc400078ef83dULL,
0xfffffffc33447812ULL, 0x000fe200078ee234ULL, 0x00005e002a2a7625ULL, 0x000fe200078e0027ULL,
0x0000001037457810ULL, 0x040fe40007ffe0ffULL, 0x0000001837477810ULL, 0x040fe20007ffe0ffULL,
0x0000001036337824ULL, 0x000fe200078e0231ULL, 0x0000002037497810ULL, 0x040fe20007ffe0ffULL,
0x0000001026287825ULL, 0x000fe200078e0028ULL, 0x00000028374b7810ULL, 0x040fe40007ffe0ffULL,
0x00000030374d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001044357824ULL, 0x000fe200078e0231ULL,
0x00000038374f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010262a7825ULL, 0x000fe200078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028337faeULL, 0x0003e2000c901c46ULL,
0x000000304500720cULL, 0x000fc40003f26070ULL, 0x000000304900720cULL, 0x080fe20003f66070ULL,
0x000000002a357faeULL, 0x0005e2000d101c46ULL, 0x000000304700720cULL, 0x080fe40003f46070ULL,
0x000000304b00720cULL, 0x080fe40003f86070ULL, 0x000000304d00720cULL, 0x0c0fe40003fa6070ULL,
0x0000003f4d377812ULL, 0x040fe200078ec0ffULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x0000003f45297812ULL, 0x042fe200078ec0ffULL, 0x0000000445457824ULL, 0x000fe200078e00ffULL,
0x0000003f49337812ULL, 0x040fe200078ec0ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0x0000003f472b7812ULL, 0x044fe200078ec0ffULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0x0000003f4b357812ULL, 0x040fe200078ec0ffULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0x0000003f4f517812ULL, 0x040fe200078ec0ffULL, 0x0000000132287824ULL, 0x040fe200078e0229ULL,
0x000000304f00720cULL, 0x040fe20003fc6070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc452a7812ULL, 0x100fe200078ee234ULL, 0x0000000132307824ULL, 0x040fe200078e022bULL,
0xfffffffc49447812ULL, 0x100fe200078ee234ULL, 0x0000000132367824ULL, 0x040fe200078e0233ULL,
0xfffffffc4b487812ULL, 0x100fe200078ee234ULL, 0x0000000132467824ULL, 0x040fe200078e0235ULL,
0xfffffffc4d4c7812ULL, 0x000fe200078ee234ULL, 0x00000001324a7824ULL, 0x000fc400078e0237ULL,
0x00000001324e7824ULL, 0x000fe200078e0251ULL, 0xfffffffc47327812ULL, 0x100fe200078ee234ULL,
0x000000102a457824ULL, 0x000fe200078e0231ULL, 0xfffffffc4f347812ULL, 0x000fe200078ee234ULL,
0x00005e0028287625ULL, 0x000fc800078e0027ULL, 0x0000001032477824ULL, 0x100fe400078e0231ULL,
0x0000001044497824ULL, 0x100fe400078e0231ULL, 0x00000010484b7824ULL, 0x100fe400078e0231ULL,
0x000000104c4d7824ULL, 0x100fe400078e0231ULL, 0x00000010344f7824ULL, 0x000fe400078e0231ULL,
0x00005e00302a7625ULL, 0x000fc800078e0027ULL, 0x00005e0036307625ULL, 0x000fc800078e0027ULL,
0x00005e0046327625ULL, 0x000fc800078e0027ULL, 0x00005e004a347625ULL, 0x000fc800078e0027ULL,
0x00005e004e367625ULL, 0x000fc800078e0027ULL, 0x0000001026287825ULL, 0x000fc800078e0028ULL,
0x00000010262a7825ULL, 0x040fe200078e002aULL, 0x0000000028457faeULL, 0x0003e6000c901c46ULL,
0x0000001026307825ULL, 0x040fe200078e0030ULL, 0x000000002a477faeULL, 0x0003e6000d101c46ULL,
0x0000001026327825ULL, 0x040fe200078e0032ULL, 0x0000000030497faeULL, 0x0003e6000d901c46ULL,
0x0000001026347825ULL, 0x040fe200078e0034ULL, 0x00000000324b7faeULL, 0x0003e6000e101c46ULL,
0x0000001026267825ULL, 0x000fe200078e0036ULL, 0x00000000344d7faeULL, 0x0003e8000e901c46ULL,
0x00000000264f7faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x004fe2000001163dULL, 0x000000040c277e24ULL, 0x000fc6000f8e0203ULL,
0x0000003f26287812ULL, 0x040fe400078ec0ffULL, 0x00000008262b7810ULL, 0x040fe40007ffe0ffULL,
0x0000001026327810ULL, 0x040fe20007ffe0ffULL, 0x0000000127297824ULL, 0x000fe200078e0228ULL,
0x0000001826337810ULL, 0x040fe40007ffe0ffULL, 0x0000002026347810ULL, 0x000fe20007ffe0ffULL,
0x0000000432497824ULL, 0x000fe200078e00ffULL, 0x0000002826367810ULL, 0x040fe20007ffe0ffULL,
0x00000004334b7824ULL, 0x000fe200078e00ffULL, 0x0000003026377810ULL, 0x000fe20007ffe0ffULL,
0x0000000434517824ULL, 0x000fe200078e00ffULL, 0x0000003826477810ULL, 0x000fe20007ffe0ffULL,
0x0000000436557824ULL, 0x000fe200078e00ffULL, 0x0000003f2b267812ULL, 0x000fe200078ec0ffULL,
0x0000000437597824ULL, 0x000fe200078e00ffULL, 0x0000003f32287812ULL, 0x000fe200078ec0ffULL,
0x00000004475d7824ULL, 0x000fe200078e00ffULL, 0x0000003f332a7812ULL, 0x000fe200078ec0ffULL,
0x0000000127317824ULL, 0x040fe200078e0226ULL, 0x0000003f34307812ULL, 0x000fe200078ec0ffULL,
0x0000000127357824ULL, 0x040fe200078e0228ULL, 0x0000003f36447812ULL, 0x000fe200078ec0ffULL,
0x0000000127457824ULL, 0x000fe200078e022aULL, 0x0000003f37467812ULL, 0x000fe200078ec0ffULL,
0x00000001274f7824ULL, 0x000fe200078e0230ULL, 0x0000003f47487812ULL, 0x000fe200078ec0ffULL,
0x0000000127537824ULL, 0x040fe200078e0244ULL, 0x00000003ff267819ULL, 0x000fe2000001163dULL,
0x0000000127577824ULL, 0x000fc400078e0246ULL, 0x00000001275b7824ULL, 0x000fe200078e0248ULL,
0x00000003262a7812ULL, 0x100fe200078e483dULL, 0x0000000241277824ULL, 0x000fe400078e023aULL,
0x00000100ff467424ULL, 0x000fe200078e00ffULL, 0xfffffffc49377812ULL, 0x100fe200078ee22aULL,
0x000000043f287824ULL, 0x000fe200078e00ffULL, 0x0000200027307811ULL, 0x000fe200078e60ffULL,
0x000000042b277824ULL, 0x000fe200078e00ffULL, 0x0ffffffc2a2b7812ULL, 0x000fe400078ef83dULL,
0xfffffffc4b477812ULL, 0x000fe200078ee22aULL, 0x00000010374b7824ULL, 0x000fe200078e0230ULL,
0xfffffffc27337812ULL, 0x100fe200078ee22aULL, 0x00005e0029267625ULL, 0x000fe200078e0046ULL,
0xfffffffc51517812ULL, 0x000fc400078ee22aULL, 0xfffffffc55557812ULL, 0x000fe200078ee22aULL,
0x000000102b297824ULL, 0x000fe200078e0230ULL, 0xfffffffc59597812ULL, 0x000fe200078ee22aULL,
0x0000001033497824ULL, 0x000fe200078e0230ULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee22aULL,
0x00000010474d7824ULL, 0x100fe200078e0230ULL, 0xfffffffc28287812ULL, 0x000fe200078ee23dULL,
0x0000001051517824ULL, 0x100fe400078e0230ULL, 0x0000001055557824ULL, 0x100fe400078e0230ULL,
0x0000001059597824ULL, 0x000fc400078e0230ULL, 0x000000105d5d7824ULL, 0x000fe400078e0230ULL,
0x00005e00312a7625ULL, 0x000fc800078e0046ULL, 0x00005e0035307625ULL, 0x000fc800078e0046ULL,
0x00005e0045327625ULL, 0x000fc800078e0046ULL, 0x00005e004f347625ULL, 0x000fc800078e0046ULL,
0x00005e0053367625ULL, 0x000fc800078e0046ULL, 0x0000001028267825ULL, 0x000fc800078e0026ULL,
0x00005e0057447625ULL, 0x080fe200078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e6000b901c46ULL, 0x00005e005b467625ULL, 0x000fc800078e0046ULL,
0x00000010282a7825ULL, 0x000fc800078e002aULL, 0x0000001028307825ULL, 0x040fe200078e0030ULL,
0x000000002a497faeULL, 0x0003e6000b901c46ULL, 0x0000001028327825ULL, 0x040fe200078e0032ULL,
0x00000000304b7faeULL, 0x0003e6000b901c46ULL, 0x0000001028347825ULL, 0x040fe200078e0034ULL,
0x00000000324d7faeULL, 0x0003e6000b901c46ULL, 0x0000001028367825ULL, 0x040fe200078e0036ULL,
0x0000000034517faeULL, 0x0003e6000b901c46ULL, 0x0000001028447825ULL, 0x040fe200078e0044ULL,
0x0000000036557faeULL, 0x0003e6000b901c46ULL, 0x0000001028467825ULL, 0x000fe200078e0046ULL,
0x0000000044597faeULL, 0x0003e8000b901c46ULL, 0x00000000465d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000033f00780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x00000004ff277424ULL, 0x002fe400078e00ffULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x00000300270d7a24ULL, 0x000fca00078e020dULL, 0x000000400d00720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000023e267824ULL, 0x000fc800078e020dULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x0000000626037981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000203d487810ULL, 0x000fe20007ffe0ffULL, 0x0000000241477824ULL, 0x002fe200078e0224ULL,
0xfffffff83d267812ULL, 0x000fe200078ec0ffULL, 0x0000000825447824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ec0ffULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x00000007263f7812ULL, 0x100fe400078ef83dULL, 0x0000000748487812ULL, 0x000fe400078ef83dULL,
0x000000073d467812ULL, 0x000fc400078ec0ffULL, 0x00000001ff4a7819ULL, 0x000fe4000001163fULL,
0x00000001ff4c7819ULL, 0x000fe40000011648ULL, 0x0000200047477811ULL, 0x000fe400078e60ffULL,
0x0000000846467812ULL, 0x000fe400078ef83dULL, 0x000000034a4a7812ULL, 0x000fe400078ec0ffULL,
0x000000034c4c7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000454a247212ULL, 0x000fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000443d357211ULL, 0x000fc400078fe0ffULL, 0x000000454c317212ULL, 0x000fe200078e3cffULL,
0x000000043f247824ULL, 0x000fe200078e0224ULL, 0x0000000735257812ULL, 0x100fe400078e7846ULL,
0x0000000145497810ULL, 0x000fe20007ffe0ffULL, 0x0000001024287824ULL, 0x000fe200078e0247ULL,
0x0000000235357810ULL, 0x000fe20007ffe0ffULL, 0x0000002046257824ULL, 0x000fe200078e0225ULL,
0x0000000245457810ULL, 0x000fe20007ffe0ffULL, 0x0000000448307824ULL, 0x000fe200078e0231ULL,
0x0000000735357812ULL, 0x000fe200078e7846ULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x000000044500780cULL, 0x000fe20003f25270ULL,
0x0000001030307824ULL, 0x000fe200078e0247ULL, 0x0000000444447810ULL, 0x000fc60007ffe0ffULL,
0x000000002524783bULL, 0x000ea80000000200ULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x00000028ff36723eULL, 0x082fe400020006ffULL, 0x00000028ff37723eULL, 0x000fe400030006ffULL,
0x00000029ff4e723eULL, 0x080fe400020006ffULL, 0x00000029ff4f723eULL, 0x000fc400030006ffULL,
0x0000002aff28723eULL, 0x080fe200020006ffULL, 0x000000362404723cULL, 0x004fe20000001804ULL,
0x0000002aff29723eULL, 0x000fe400030006ffULL, 0x000000494a2a7212ULL, 0x080fe400078e3cffULL,
0x000000494c497212ULL, 0x000fc600078e3cffULL, 0x000000282410723cULL, 0x040fee0000001810ULL,
0x000000043f287824ULL, 0x000fe200078e022aULL, 0x0000004e2408723cULL, 0x000fe20000001808ULL,
0x0000002bff2a723eULL, 0x080fe400020006ffULL, 0x0000001028347824ULL, 0x000fe200078e0247ULL,
0x0000002bff2b723eULL, 0x000fe200030006ffULL, 0x0000002046287824ULL, 0x000fc400078e0235ULL,
0x00000030ff4e723eULL, 0x088fe400020006ffULL, 0x00000030ff4f723eULL, 0x000fe200030006ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x00000031ff30723eULL, 0x080fe200020006ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x0000002a242c723cULL, 0x040fe8000000182cULL, 0x000000002828783bULL, 0x000ea80000000200ULL,
0x000000302418723cULL, 0x040fee0000001818ULL, 0x00000032ff30723eULL, 0x080fe200020006ffULL,
0x0000004e2414723cULL, 0x000fe20000001814ULL, 0x00000032ff31723eULL, 0x000fe200030006ffULL,
0x0000000448327824ULL, 0x000fc800078e0249ULL, 0x0000001032327824ULL, 0x000fe200078e0247ULL,
0x00000033ff4e723eULL, 0x080fe200020006ffULL, 0x00000030241c723cULL, 0x000fe2000000181cULL,
0x00000033ff4f723eULL, 0x000fc600030006ffULL, 0x000000003230783bULL, 0x000ee80000000200ULL,
0x0000004e2420723cULL, 0x000fee0000001820ULL, 0x00000034ff24723eULL, 0x002fc400020006ffULL,
0x00000034ff25723eULL, 0x000fe400030006ffULL, 0x00000035ff34723eULL, 0x080fe400020006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x000000242804723cULL, 0x044fee0000001804ULL,
0x00000036ff24723eULL, 0x080fe200020006ffULL, 0x000000342808723cULL, 0x000fe20000001808ULL,
0x00000036ff25723eULL, 0x000fe400030006ffULL, 0x00000037ff36723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x000000242810723cULL, 0x040fee0000001810ULL,
0x00000030ff24723eULL, 0x088fe200020006ffULL, 0x00000036282c723cULL, 0x000fe2000000182cULL,
0x00000030ff25723eULL, 0x000fe400030006ffULL, 0x00000031ff30723eULL, 0x000fc400020006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000242814723cULL, 0x040fee0000001814ULL,
0x00000032ff24723eULL, 0x080fe200020006ffULL, 0x000000302818723cULL, 0x000fe20000001818ULL,
0x00000032ff25723eULL, 0x000fe400030006ffULL, 0x00000033ff32723eULL, 0x000fc400020006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x00000024281c723cULL, 0x040ff0000000181cULL,
0x000000322820723cULL, 0x000fe20000001820ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff247224ULL, 0x000fe200078e003aULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed2000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0106140039257984ULL, 0x000e620000000800ULL,
0x0000ffff38007812ULL, 0x000fe200078ec0ffULL, 0x000000073b277220ULL, 0x040fe20000410000ULL,
0x0000000b3b077220ULL, 0x040fe20000410000ULL, 0x000000083b2a7220ULL, 0x040fe20000410000ULL,
0x0000888000317816ULL, 0x000fe200000000ffULL, 0x000000143b0b7220ULL, 0x040fe20000410000ULL,
0x000000103b087220ULL, 0x040fe20000410000ULL, 0x000000153b157220ULL, 0x040fe20000410000ULL,
0x000000163b147220ULL, 0x040fe20000410000ULL, 0x0000001d3b1d7220ULL, 0x040fe20000410000ULL,
0x000000203b207220ULL, 0x000fe20000410000ULL, 0x8000000031007824ULL, 0x000fe200078e00ffULL,
0x000000063b267220ULL, 0x040fe20000410000ULL, 0x000000093b287220ULL, 0x040fe20000410000ULL,
0x000000133b107220ULL, 0x040fe20000410000ULL, 0x000000173b167220ULL, 0x040fe20000410000ULL,
0x000000193b247220ULL, 0x040fe20000410000ULL, 0x0000001b3b1b7220ULL, 0x040fe20000410000ULL,
0x000000043b047220ULL, 0x040fe20000410000ULL, 0x000000053b057220ULL, 0x040fe20000410000ULL,
0x0000000a3b097220ULL, 0x040fe20000410000ULL, 0x0000002d3b067220ULL, 0x040fe20000410000ULL,
0x0000002e3b2e7220ULL, 0x040fe20000410000ULL, 0x0000002f3b2b7220ULL, 0x040fe20000410000ULL,
0x000000183b187220ULL, 0x040fe20000410000ULL, 0x0000001a3b1a7220ULL, 0x040fe20000410000ULL,
0x0000001e3b197220ULL, 0x040fe20000410000ULL, 0x000000113b0a7220ULL, 0x040fe20000410000ULL,
0x000000213b297220ULL, 0x040fe20000410000ULL, 0x000000233b307220ULL, 0x040fe20000410000ULL,
0x0000002c3b117220ULL, 0x040fe20000410000ULL, 0x0000001c3b137220ULL, 0x040fe20000410000ULL,
0x000000ffff237224ULL, 0x000fe200078e0015ULL, 0x0000001f3b1c7220ULL, 0x040fe20000410000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e001dULL, 0x000000223b2c7220ULL, 0x040fe20000410000ULL,
0x000000ffff217224ULL, 0x000fe200078e0020ULL, 0x000000123b127220ULL, 0x000fe20000410000ULL,
0x000000ffff207224ULL, 0x000fe200078e0026ULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff177224ULL, 0x000fc400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0016ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001bULL, 0x000000ffff2f7224ULL, 0x000fe400078e0004ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0005ULL, 0x000000ffff227224ULL, 0x000fe400078e0006ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0018ULL, 0x000000ffff267224ULL, 0x000fe400078e0007ULL,
0x000000ffff257224ULL, 0x000fe400078e002eULL, 0x000000ffff107224ULL, 0x000fe400078e002bULL,
0x000000ffff167224ULL, 0x000fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fe200078e0019ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fc400078e002cULL, 0x000000ffff197224ULL, 0x000fe200078e0030ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000031317824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x0106140039047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043d007824ULL, 0x000fe200078e00ffULL,
0x0000003c4300720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000187812ULL, 0x000fca00078ec0ffULL, 0x0000008041187824ULL, 0x000fca00078e0218ULL,
0x0104000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023d2b7824ULL, 0x000fe400078e00ffULL, 0x000000010f427824ULL, 0x000fc600078e0a42ULL,
0x000000062b2b7812ULL, 0x000fc800078ec0ffULL, 0x000000012b317812ULL, 0x040fe400078efcffULL,
0x000000082b337812ULL, 0x000fe400078efcffULL, 0x000000423100720cULL, 0x080fe40003f26070ULL,
0x000000102b317812ULL, 0x000fe400078efcffULL, 0x000000423300720cULL, 0x080fe40003f06070ULL,
0x000000423100720cULL, 0x000fc40003fc6070ULL, 0x000000112b337812ULL, 0x040fe400078efcffULL,
0x000000182b317812ULL, 0x040fe400078efcffULL, 0x000000422b00720cULL, 0x080fe40003f46070ULL,
0x000000423300720cULL, 0x080fe40003fa6070ULL, 0x000000423100720cULL, 0x000fe40003f66070ULL,
0x000000092b357812ULL, 0x000fc400078efcffULL, 0x000000192b337812ULL, 0x040fe400078efcffULL,
0x000000202b317812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40004800000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40004800000ULL, 0x000000423500720cULL, 0x080fe40003f86070ULL,
0x000000423300720cULL, 0x080fe40003f46070ULL, 0x000000423100720cULL, 0x000fe40003f26070ULL,
0x000000212b337812ULL, 0x040fe400078efcffULL, 0x000000282b317812ULL, 0x000fe400078efcffULL,
0xff7fffff09097808ULL, 0x000fc40004000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0x000000423300720cULL, 0x080fe40003f06070ULL, 0x000000423100720cULL, 0x000fe40003f86070ULL,
0x000000292b337812ULL, 0x000fc400078efcffULL, 0x000000302b317812ULL, 0x000fe400078efcffULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff08087808ULL, 0x000fe40007000000ULL,
0xff7fffff17177808ULL, 0x000fe40006800000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006800000ULL,
0x000000423300720cULL, 0x000fc40003fc6070ULL, 0x000000423100720cULL, 0x000fe40003fa6070ULL,
0x000000312b337812ULL, 0x040fe400078efcffULL, 0x000000382b317812ULL, 0x040fe400078efcffULL,
0x000000392b2b7812ULL, 0x000fe400078efcffULL, 0xff7fffff25257808ULL, 0x000fe40005800000ULL,
0xff7fffff11117808ULL, 0x000fc40005800000ULL, 0xff7fffff10107808ULL, 0x000fe40005000000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff14147808ULL, 0x000fe40004800000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40004800000ULL, 0x000000423300720cULL, 0x080fe40003f66070ULL,
0x000000423100720cULL, 0x000fc40003f46070ULL, 0x000000422b00720cULL, 0x000fe40003f26070ULL,
0xff7fffff15157808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40004000000ULL,
0xff7fffff16167808ULL, 0x000fe40006000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff1d1d7808ULL, 0x000fc40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40006800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005800000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL,
0xff7fffff21217808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff29297808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002f04047209ULL, 0x004fe20007810000ULL,
0x0000001fff2e7424ULL, 0x000fe200078e00ffULL, 0x00000020052c7209ULL, 0x000fe20007810000ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0000002d04057209ULL, 0x000fe40007810000ULL,
0x000000272c2c7209ULL, 0x000fc40007810000ULL, 0x0000002a05057209ULL, 0x000fe40007810000ULL,
0x000000092c2b7209ULL, 0x000fe40007810000ULL, 0x0000002805057209ULL, 0x000fe40007810000ULL,
0x000000262b2b7209ULL, 0x000fe40007810000ULL, 0x0000000805057209ULL, 0x000fe40007810000ULL,
0x000000122b047209ULL, 0x000fc40007810000ULL, 0x0000000a052c7209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x000000112c057209ULL, 0x000fe40007810000ULL,
0x00000025042b7209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fe40007810000ULL,
0x000000102b2b7209ULL, 0x000fc40007810000ULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x000000142b2c7209ULL, 0x000fe40007810000ULL, 0x0000002304047209ULL, 0x000fe40007810000ULL,
0x000000152c057209ULL, 0x000fe40007810000ULL, 0x0000001f042b7209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fc40007810000ULL, 0x000000242b2c7209ULL, 0x000fe40007810000ULL,
0x0000001d04047209ULL, 0x000fe40007810000ULL, 0x000000132c057209ULL, 0x000fe40007810000ULL,
0x0000001b042b7209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000001c2b2b7209ULL, 0x000fc40007810000ULL, 0x0000002104047209ULL, 0x000fe40007810000ULL,
0x0000001a2b2c7209ULL, 0x000fe40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x000000192c357209ULL, 0x000fe20007810000ULL, 0x00000da27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x0000000405377209ULL, 0x008fe20007810000ULL,
0x00000dd27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0035047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x00000004352e7209ULL, 0x00afc60007810000ULL, 0x0c201f0037047f89ULL, 0x000e6200000e0000ULL,
0x0000000506307209ULL, 0x004fc60007810000ULL, 0x0c201f002e057f89ULL, 0x000ea200000e0000ULL,
0x0000002c072b7209ULL, 0x010fc60007810000ULL, 0x0c201f0030317f89ULL, 0x000ee800000e0000ULL,
0x0c201f002b2c7f89ULL, 0x00092200000e0000ULL, 0x0000000437047209ULL, 0x002fe40007810000ULL,
0x000000052e057209ULL, 0x004fe40007810000ULL, 0x0000003130067209ULL, 0x008fe40007810000ULL,
0x3fb8aa3b042e7820ULL, 0x002fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b08087823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b29297823ULL, 0x000fe2000001082eULL, 0x3fb8aa3b052e7820ULL, 0x000fe20000410000ULL,
0x0000002d00307308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082eULL,
0x0000000b002d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b19197823ULL, 0x000fc6000001082eULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b090b7823ULL, 0x002fce000001082eULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002800077308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ee20000000800ULL,
0x000000202709723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b15277823ULL, 0x000fcc000001082eULL,
0x0000002300287308ULL, 0x0003f00000000800ULL, 0x0000000800317308ULL, 0x0009e20000000800ULL,
0x3fb8aa3b25237823ULL, 0x102fe2000001082eULL, 0x0000000b260b723eULL, 0x008fe200000000ffULL,
0x3c003c00ff257424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b14267823ULL, 0x000fc8000001082eULL,
0x0000000a00327308ULL, 0x0002e20000000800ULL, 0x0000002f3008723eULL, 0x010fce00000000ffULL,
0x0000002400347308ULL, 0x0009e20000000800ULL, 0x0000002a070a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b10077823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b162a7823ULL, 0x000fca000001082eULL,
0x0000002100367308ULL, 0x000fe20000000800ULL, 0x3c003c00ff247424ULL, 0x010fe200078e00ffULL,
0x000000313214723eULL, 0x008fcc00000000ffULL, 0x0000001100337308ULL, 0x000ff00000000800ULL,
0x0000001300357308ULL, 0x000ff00000000800ULL, 0x0000001200217308ULL, 0x0003f00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x000000240810723cULL, 0x002fee00000018ffULL,
0x0000001700427308ULL, 0x000e700000000800ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000332216723eULL, 0x008fce00000000ffULL, 0x0000000700207308ULL, 0x0007220000000800ULL,
0x000000214215723eULL, 0x002fce00000000ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0xfffffffc3d077812ULL, 0x008fe400078ec0ffULL, 0x000000232017723eULL, 0x010fca00000000ffULL,
0x0000002600267308ULL, 0x000fe40000000800ULL, 0x000000241420723cULL, 0x000fec0000001810ULL,
0x0000002700277308ULL, 0x000ee20000000800ULL, 0x0000002d2810723eULL, 0x000fe400000000ffULL,
0x0000001f3412723eULL, 0x002fca00000000ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000e620000000800ULL, 0x000000262711723eULL, 0x008fce00000000ffULL,
0x0000001c00307308ULL, 0x0007e20000000800ULL, 0x0000002a1d13723eULL, 0x002fe200000000ffULL,
0x0000000fff1c7424ULL, 0x008fcc00078e00ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x000000071c2d7219ULL, 0x000fe200000006ffULL, 0x000000241020723cULL, 0x000fe20000001820ULL,
0x0000002b2c077209ULL, 0x004fca0007810000ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000002d2873a1ULL, 0x000ee200000e8000ULL, 0x000000002d0573c4ULL, 0x000f2c0000004000ULL,
0x0000001b001b7308ULL, 0x000ee20000000800ULL, 0x000000351e1c723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x00000036291e723eULL, 0x004fce00000000ffULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x0000001b301d723eULL, 0x008fe400000000ffULL,
0x000000082dff7c12ULL, 0x000fe4000f804028ULL, 0x0000001a191f723eULL, 0x002fce00000000ffULL,
0x000000241c24723cULL, 0x000fe80000001820ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000090205008947ULL, 0x010fde000b800000ULL, 0x001c1fff24207589ULL, 0x0002a400000e0000ULL,
0x000000002d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000002d0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000082dff7c12ULL, 0x008fda000f80401aULL,
0x0000090205008947ULL, 0x010fea000b800000ULL, 0x001c1fff26217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff197819ULL, 0x002fe4000001163dULL, 0x0000000c00377812ULL, 0x000fc400078ec0ffULL,
0x00000007191a7812ULL, 0x040fe200078ec0ffULL, 0x0000000819277824ULL, 0x040fe200078e00ffULL,
0x00000019ff257212ULL, 0x000fe200078e33ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x000000033dff7812ULL, 0x000fe2000780c0ffULL, 0x0000000819327824ULL, 0x040fe200078e00ffULL,
0x0000000819197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee21aULL,
0x000000011b267812ULL, 0x108fe200078ef61aULL, 0x00000008194c7824ULL, 0x000fe200078e00ffULL,
0x000000021b287812ULL, 0x100fe200078ef61aULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0x000000031b2a7812ULL, 0x000fc400078ef61aULL, 0x000000041b2c7812ULL, 0x140fe400078ef61aULL,
0x000000051b2e7812ULL, 0x140fe400078ef61aULL, 0x000000061b307812ULL, 0x000fe200078ef61aULL,
0x00000008191b7824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee225ULL,
0x00000019ff257212ULL, 0x000fe400078e33ffULL, 0x00000007191a7812ULL, 0x000fc400078ec0ffULL,
0x0000a00041197811ULL, 0x000fe400078e58ffULL, 0xfffffff827347812ULL, 0x100fe400078ee21aULL,
0x000000011b367812ULL, 0x140fe200078ef61aULL, 0x0000001024007824ULL, 0x000fe200078e0219ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee225ULL, 0x0000001028247824ULL, 0x100fe200078e0219ULL,
0x000000021b427812ULL, 0x140fe200078ef61aULL, 0x000000102c287824ULL, 0x100fe200078e0219ULL,
0x000000031b447812ULL, 0x140fe200078ef61aULL, 0x00000010302c7824ULL, 0x100fe200078e0219ULL,
0x000000041b467812ULL, 0x140fe200078ef61aULL, 0x0000001036307824ULL, 0x100fe200078e0219ULL,
0x000000051b487812ULL, 0x140fe200078ef61aULL, 0x0000001042317824ULL, 0x100fe200078e0219ULL,
0x000000061b4a7812ULL, 0x000fe200078ef61aULL, 0x00000010261a7824ULL, 0x000fc400078e0219ULL,
0x000000102a267824ULL, 0x100fe400078e0219ULL, 0x000000102e2a7824ULL, 0x100fe400078e0219ULL,
0x00000001371b7824ULL, 0x000fe400078e0200ULL, 0x00000010322e7824ULL, 0x100fe400078e0219ULL,
0x0000001034007824ULL, 0x100fe200078e0219ULL, 0x000000081b007388ULL, 0x0003e20000000800ULL,
0x0000001044327824ULL, 0x000fc400078e0219ULL, 0x0000001046337824ULL, 0x100fe400078e0219ULL,
0x0000001048347824ULL, 0x100fe400078e0219ULL, 0x000000104a357824ULL, 0x100fe400078e0219ULL,
0x000000104c367824ULL, 0x000fe400078e0219ULL, 0x0000000137197824ULL, 0x040fe400078e021aULL,
0x0000000137257824ULL, 0x000fc400078e0224ULL, 0x0000000137277824ULL, 0x040fe200078e0226ULL,
0x0000000a19007388ULL, 0x0007e20000000800ULL, 0x0000000137297824ULL, 0x040fe400078e0228ULL,
0x00000001372b7824ULL, 0x040fe200078e022aULL, 0x0000001425007388ULL, 0x0007e20000000800ULL,
0x00000001372d7824ULL, 0x040fe400078e022cULL, 0x00000001372f7824ULL, 0x040fe200078e022eULL,
0x0000001627007388ULL, 0x0007e20000000800ULL, 0x0000000137007824ULL, 0x000fc400078e0200ULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001029007388ULL, 0x0007e20000000800ULL,
0x00000001371a7824ULL, 0x040fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x000000122b007388ULL, 0x0007e20000000800ULL, 0x0000000137087824ULL, 0x042fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x0000001c2d007388ULL, 0x0007e20000000800ULL,
0x0000000137247824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x0000001e2f007388ULL, 0x0007e80000000800ULL, 0x0000000900007388ULL, 0x0007e80000000800ULL,
0x0000000b30007388ULL, 0x0007e80000000800ULL, 0x000000151a007388ULL, 0x0007e80000000800ULL,
0x0000001732007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001334007388ULL, 0x0007e80000000800ULL, 0x0000001d24007388ULL, 0x0007e80000000800ULL,
0x0000001f36007388ULL, 0x0007e80000000800ULL, 0x0100000418008388ULL, 0x0007e80000000c00ULL,
0x0102002018008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030043437a10ULL, 0x000fe20007ffe0ffULL, 0x0106080039ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL, 0x0000000e4300720cULL, 0x000fe40003f26070ULL,
0x00000001ff387807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffd31000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0005ULL, 0x0000fc6000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002cULL, 0xfffff21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2c7224ULL, 0x000fe200078e0035ULL, 0x0000fcc000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x002fe400078e00ffULL, 0x000004c000007944ULL, 0x024fea0003c00000ULL,
0x0000002c35057209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0006ULL,
0x0000fd1000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x002fe400078e00ffULL,
0x0000047000007944ULL, 0x000fea0003c00000ULL, 0x0000002c06357209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0007ULL, 0x0000fd6000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x002fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002c072b7209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0037ULL,
0x0000fdb000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000002c37047209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0005ULL, 0x0000fe0000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000002c05057209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0035ULL,
0x0000fe5000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x0000002c35067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e002bULL, 0x0000fea000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x000002e000007944ULL, 0x000fea0003c00000ULL,
0xfffff0d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000fef0001a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fc400078e00ffULL,
0x000002d000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xfffff6b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x002fe200078e0026ULL,
0x0000ff60001a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff197224ULL, 0x000fc400078e00ffULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff197224ULL, 0x002fe200078e00ffULL, 0x0000ffb0001a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x002fe200078e00ffULL,
0x00010000001a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff63000007947ULL, 0x000fea000383ffffULL, 0x018000002d057810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000005097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000002d00058308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff057807ULL, 0x004fc80004000000ULL, 0x000000050aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff2dff7812ULL, 0x040fe4000780c0ffULL,
0x800000002d097812ULL, 0x000fe400078ec0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x000000050aff7212ULL, 0x000fda000780c0ffULL, 0x0080000009050812ULL, 0x000fe200078efcffULL,
0x000000ffff058224ULL, 0x000fe200078e0009ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002d00057308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffefe8008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003f00007348ULL, 0x000fe80003800000ULL,
0x0c0000332c2c7389ULL, 0x0002a200000e002eULL, 0xfffefe4030007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1b7424ULL, 0x000fe200078e00ffULL, 0x0000002d00007348ULL, 0x000fe80003800000ULL,
0x0000001924237389ULL, 0x0002a200000e0025ULL, 0xfffefe001a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001190ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011a8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000010300ULL, 0x7300001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011680ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011690ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011b10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001190ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000104f0ULL, 0x00000000000104f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000011680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011b10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 72688;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
