/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013e90ULL, 0x0000000000013a10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000011e80ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000011ff0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000012030ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000012070ULL,
0x0000000000000110ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012180ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00011e8000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x0046340400288080ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8e082880808b0828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL, 0x0828808099082880ULL,
0x8080b0082880809dULL, 0xb508288080b30828ULL, 0x288080b708288080ULL, 0x80cd08288080cc08ULL,
0x08288080ce082880ULL, 0x8080de08288080d8ULL, 0x80162880809a0828ULL, 0x0000000310288082ULL,
0x809a920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00011e8000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8e082880808b0828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL,
0x0828808099082880ULL, 0x80809d082880809aULL, 0xb508288080b00828ULL, 0x288080cc08288080ULL,
0x80ce08288080cd08ULL, 0x08288080d8082880ULL, 0x80808c08288080deULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL,
0x00011ff000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c082880808b0828ULL, 0x2880808e08288080ULL, 0x8094082880809008ULL,
0x0828808096082880ULL, 0x80809a0828808099ULL, 0xb0082880809d0828ULL, 0x288080b508288080ULL,
0x80cc08288080b708ULL, 0x08288080cd082880ULL, 0x8080de08288080ceULL, 0x8016288080d80828ULL,
0x0000000310288082ULL, 0x80d8920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x000001f800000000ULL, 0x0001203000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808b0828ULL, 0x2880808e08288080ULL,
0x8094082880809008ULL, 0x0828808096082880ULL, 0x80809a0828808099ULL, 0xb0082880809d0828ULL,
0x288080b508288080ULL, 0x80cc08288080b708ULL, 0x08288080ce082880ULL, 0x8080de08288080d8ULL,
0x8016288080cd0828ULL, 0x0000000310288082ULL, 0x80cd920000000000ULL, 0x0000000022002880ULL,
0x0000002cffffffffULL, 0x000002c000000000ULL, 0x0001207000000000ULL, 0x0000011000000000ULL,
0x0000180400000000ULL, 0x80b0288080cd0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x000812040000006bULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0001026000000020ULL, 0x00010620000105c0ULL, 0x0001075000010740ULL,
0x01c8290400010760ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500005c0500005cULL, 0x0500005c0500005cULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001c82804ULL, 0x0000174000000110ULL,
0x00001860000017c0ULL, 0x00001c7000001890ULL, 0x00001d1000001ca0ULL, 0x00002b2000001d80ULL,
0x00002ba000002b40ULL, 0x00003a0000002c00ULL, 0x00003b3000003a80ULL, 0x00003f1000003c50ULL,
0x00003f9000003f30ULL, 0x00004bf000003ff0ULL, 0x00004c7000004c10ULL, 0x0000597000004cd0ULL,
0x00005aa0000059f0ULL, 0x00005e8000005bc0ULL, 0x00005f0000005ea0ULL, 0x00006b3000005f60ULL,
0x00006bb000006b50ULL, 0x0000799000006c10ULL, 0x00007ac000007a10ULL, 0x00007ea000007be0ULL,
0x00007f2000007ec0ULL, 0x00008b9000007f80ULL, 0x00008c1000008bb0ULL, 0x0000944000008c70ULL,
0x00009bd000009450ULL, 0x0000b9c00000b6e0ULL, 0x0000bef00000bec0ULL, 0x000100000000c730ULL,
0x0001004000010030ULL, 0x0001007000010050ULL, 0x000100b000010090ULL, 0x00010730000100c0ULL,
0x000107a000010790ULL, 0x00010ec0000107b0ULL, 0x00010f7000010f10ULL, 0x0001103000010fd0ULL,
0x00011100000110a0ULL, 0x000111c000011170ULL, 0x0001127000011210ULL, 0x00011320000112d0ULL,
0x000113f000011390ULL, 0x000114b000011460ULL, 0x0001156000011500ULL, 0x00011610000115c0ULL,
0x000116e000011680ULL, 0x000117a000011750ULL, 0x00011850000117f0ULL, 0x00011900000118b0ULL,
0x000119d000011970ULL, 0x00011aa000011a40ULL, 0x00011b5000011b00ULL, 0x00011bf000011ba0ULL,
0x00011c9000011c40ULL, 0x00011d4000011ce0ULL, 0x00011e0000011db0ULL, 0x0700390400011e50ULL,
0x000000ff00000230ULL, 0x003f010000010600ULL, 0x0000000f00000270ULL, 0x003f012000010608ULL,
0x0000000f000002b0ULL, 0x003f012000010688ULL, 0x0000000f000003a0ULL, 0x003f0120000106a8ULL,
0x000000ff000003d0ULL, 0x003f0100000106b8ULL, 0x000000ff00000500ULL, 0x003f010700010600ULL,
0x00000009000006a0ULL, 0x003f01020001068cULL, 0x0000000900000750ULL, 0x003f010100010688ULL,
0x000000ff00000c80ULL, 0x003f0107000106a8ULL, 0x000000ff00000d00ULL, 0x003f0101000106a8ULL,
0x000000ff00000d60ULL, 0x003f0101000106b8ULL, 0x000000ff00000ec0ULL, 0x003f0105000106bcULL,
0x000000ff00000f20ULL, 0x003f0105000106bcULL, 0x000000ff00000fa0ULL, 0x003f0105000106bcULL,
0x000000ff000014b0ULL, 0x003f0107000106b0ULL, 0x000000ff00001530ULL, 0x003f0101000106b0ULL,
0x000000ff00001540ULL, 0x003f0105000106acULL, 0x00000009000015b0ULL, 0x003f010100010608ULL,
0x00000009000015d0ULL, 0x003f01050001060cULL, 0x0000000900001660ULL, 0x003f01050001060cULL,
0x000000ff00001b50ULL, 0x003f0105000106acULL, 0x000000ff00001bd0ULL, 0x003f0105000106acULL,
0x000000ff00002470ULL, 0x003f0101000106b8ULL, 0x000000ff00002480ULL, 0x003f0105000106bcULL,
0x000000ff000024d0ULL, 0x003f0105000106bcULL, 0x000000ff00002550ULL, 0x003f0105000106bcULL,
0x000000ff00002910ULL, 0x003f0107000106a8ULL, 0x000000ff00002990ULL, 0x003f0101000106a8ULL,
0x000000ff000029a0ULL, 0x003f0105000106b4ULL, 0x000000ff00002a00ULL, 0x003f0105000106b4ULL,
0x000000ff00002a80ULL, 0x003f0105000106b4ULL, 0x000000ff00003210ULL, 0x003f0101000106b8ULL,
0x000000ff00003280ULL, 0x003f010100010688ULL, 0x000000ff000032b0ULL, 0x003f0105000106bcULL,
0x000000ff00003300ULL, 0x003f0105000106bcULL, 0x000000ff00003380ULL, 0x003f0105000106bcULL,
0x000000ff000037c0ULL, 0x003f0107000106b0ULL, 0x000000ff00003840ULL, 0x003f0101000106b0ULL,
0x000000ff00003850ULL, 0x003f0105000106acULL, 0x00000009000038c0ULL, 0x003f010100010628ULL,
0x00000009000038e0ULL, 0x003f01050001062cULL, 0x0000000900003970ULL, 0x003f01050001062cULL,
0x000000ff00003e00ULL, 0x003f0105000106acULL, 0x000000ff00003e80ULL, 0x003f0105000106acULL,
0x000000ff00004580ULL, 0x003f0101000106b8ULL, 0x000000ff00004590ULL, 0x003f0105000106bcULL,
0x000000ff000045e0ULL, 0x003f0105000106bcULL, 0x000000ff00004660ULL, 0x003f0105000106bcULL,
0x000000ff000049f0ULL, 0x003f0107000106a8ULL, 0x000000ff00004a70ULL, 0x003f0101000106a8ULL,
0x000000ff00004a80ULL, 0x003f0105000106b4ULL, 0x000000ff00004ae0ULL, 0x003f0105000106b4ULL,
0x000000ff00004b60ULL, 0x003f0105000106b4ULL, 0x000000ff00005250ULL, 0x003f0101000106b8ULL,
0x000000ff000052c0ULL, 0x003f010100010690ULL, 0x000000ff000052f0ULL, 0x003f0105000106bcULL,
0x000000ff00005340ULL, 0x003f0105000106bcULL, 0x000000ff000053c0ULL, 0x003f0105000106bcULL,
0x000000ff00005730ULL, 0x003f0107000106b0ULL, 0x000000ff000057b0ULL, 0x003f0101000106b0ULL,
0x000000ff000057c0ULL, 0x003f0105000106acULL, 0x0000000900005830ULL, 0x003f010100010648ULL,
0x0000000900005850ULL, 0x003f01050001064cULL, 0x00000009000058e0ULL, 0x003f01050001064cULL,
0x000000ff00005d70ULL, 0x003f0105000106acULL, 0x000000ff00005df0ULL, 0x003f0105000106acULL,
0x000000ff000064f0ULL, 0x003f0101000106b8ULL, 0x000000ff00006500ULL, 0x003f0105000106bcULL,
0x000000ff00006550ULL, 0x003f0105000106bcULL, 0x000000ff000065d0ULL, 0x003f0105000106bcULL,
0x000000ff00006940ULL, 0x003f0107000106a8ULL, 0x000000ff000069c0ULL, 0x003f0101000106a8ULL,
0x000000ff000069d0ULL, 0x003f0105000106b4ULL, 0x000000ff00006a20ULL, 0x003f0105000106b4ULL,
0x000000ff00006aa0ULL, 0x003f0105000106b4ULL, 0x000000ff00007190ULL, 0x003f0101000106b8ULL,
0x000000ff00007200ULL, 0x003f010100010698ULL, 0x000000ff00007230ULL, 0x003f0105000106bcULL,
0x000000ff00007280ULL, 0x003f0105000106bcULL, 0x000000ff00007300ULL, 0x003f0105000106bcULL,
0x000000ff00007750ULL, 0x003f0107000106b0ULL, 0x000000ff000077d0ULL, 0x003f0101000106b0ULL,
0x000000ff000077e0ULL, 0x003f0105000106acULL, 0x0000000900007850ULL, 0x003f010100010668ULL,
0x0000000900007870ULL, 0x003f01050001066cULL, 0x0000000900007900ULL, 0x003f01050001066cULL,
0x000000ff00007d90ULL, 0x003f0105000106acULL, 0x000000ff00007e10ULL, 0x003f0105000106acULL,
0x000000ff00008510ULL, 0x003f0101000106b8ULL, 0x000000ff00008520ULL, 0x003f0105000106bcULL,
0x000000ff00008570ULL, 0x003f0105000106bcULL, 0x000000ff000085f0ULL, 0x003f0105000106bcULL,
0x000000ff000089a0ULL, 0x003f0107000106a8ULL, 0x000000ff00008a20ULL, 0x003f0101000106a8ULL,
0x000000ff00008a30ULL, 0x003f0105000106b4ULL, 0x000000ff00008a80ULL, 0x003f0105000106b4ULL,
0x000000ff00008b00ULL, 0x003f0105000106b4ULL, 0x000000ff000091f0ULL, 0x003f0101000106b8ULL,
0x000000ff00009250ULL, 0x003f0101000106a0ULL, 0x000000ff0000ca80ULL, 0x003f010100010600ULL,
0x000000ff0000d890ULL, 0x003f010500010604ULL, 0x000000ff0000d930ULL, 0x003f010500010604ULL,
0x000000ff0000dc50ULL, 0x003f010100010600ULL, 0x000000ff0000dc60ULL, 0x003f010500010604ULL,
0x000000ff0000dcf0ULL, 0x003f010500010604ULL, 0x0000002f0000f460ULL, 0x003f010100000000ULL,
0x0000002f0000f4a0ULL, 0x003f010500000004ULL, 0x0000002f0000f900ULL, 0x003f010500000004ULL,
0x0000003100010d20ULL, 0x003f010100000000ULL, 0x0000003100010d80ULL, 0x003f010100000008ULL,
0x0000003100010de0ULL, 0x003f010100000010ULL, 0x0000003100010e50ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0000dd500000c980ULL, 0x00010e900000de00ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000374ULL, 0x0000001200000002ULL, 0x00000000000002acULL,
0x0000001200000002ULL, 0x00000000000001e4ULL, 0x0000001200000002ULL, 0x0000000000000124ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000034dULL,
0x0000001200000002ULL, 0x0000000000000285ULL, 0x0000001200000002ULL, 0x00000000000001c0ULL,
0x0000001200000002ULL, 0x00000000000000fdULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff2d7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001200077300ULL, 0x000fe200000e0000ULL, 0x000000082d057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee20000002200ULL, 0x00000200ff177424ULL, 0x000fc600078e00ffULL,
0x0000000000007919ULL, 0x000f220000002600ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x00000000000d7919ULL, 0x000f280000002700ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff027819ULL, 0x002fc60000011606ULL, 0x00001fff04117589ULL, 0x0049e200000e0000ULL,
0x000000ffff127224ULL, 0x020fc600078e0a12ULL, 0x00001fff02027589ULL, 0x000e6200000e0000ULL,
0x0000000104037824ULL, 0x008fe400078e0203ULL, 0x0000000800047824ULL, 0x010fe400078e00ffULL,
0x00000080030f7824ULL, 0x000fe400078e0206ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000000d050a7224ULL, 0x000fe400078e0204ULL, 0x000000ff0f00720cULL, 0x000fc40003f25270ULL,
0x0000000f0f00780cULL, 0x000fe40003f44070ULL, 0x000000080700720cULL, 0x000fe40003f02070ULL,
0x000000030f00780cULL, 0x040fe40003f64070ULL, 0x0000007f0f00780cULL, 0x000fe20003f84070ULL,
0x0000000411067824ULL, 0x002fc800078e0202ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002060b7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000070b0e7812ULL, 0x040fe200078ec0ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x000fe20007800000ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x010608060f00a388ULL, 0x0007e20000008a00ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x0000001f0e0e7812ULL, 0x004fe200078e7803ULL, 0x010688080f00b388ULL, 0x0005e20000008a00ULL,
0x000000010b137810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fc400078e0a0bULL,
0x000000010a047824ULL, 0x002fe200078e020bULL, 0x010400100f00c388ULL, 0x0003e20000004800ULL,
0x000000200b0e7824ULL, 0x000fe200078e020eULL, 0x000000ff0c00720cULL, 0x000fe20003f63070ULL,
0x000000010a067824ULL, 0x008fe200078e0213ULL, 0x000000010c00780cULL, 0x000fe20003f83070ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x3fffff00ff08a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL, 0x0000000713107812ULL, 0x002fe200078ec0ffULL,
0x7fffff80ff0b9424ULL, 0x000fc400078e00ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0106a8080f00a388ULL, 0x0003e20000008a00ULL, 0x00005c0004047625ULL, 0x080fe200078e0017ULL,
0x0000001f10107812ULL, 0x000fe400078e7803ULL, 0x0106b80aff009388ULL, 0x0005e20000000a00ULL,
0x000001f00c157812ULL, 0x000fe200078ec0ffULL, 0x00005c0006067625ULL, 0x000fe400078e0017ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001504047210ULL, 0x080fe20007fbe0ffULL,
0x0000002013107824ULL, 0x000fe200078e0210ULL, 0x0000001506067210ULL, 0x000fe20007f5e0ffULL,
0x000000100e137824ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001010157824ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x002fe400078e0012ULL, 0x00000004ff0e7424ULL, 0x000fc800078e00ffULL,
0x000062000d087625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004137faeULL, 0x0005e8000d901c46ULL, 0x0000000006157faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0106040fffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608047981ULL, 0x004ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x00000004ff057e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f04067810ULL, 0x004fc40007ffe0ffULL, 0x000000ff04077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff067819ULL, 0x000fe40000011606ULL, 0x00000008ff077819ULL, 0x000fca0000011607ULL,
0x0000c38000008947ULL, 0x000fea0003800000ULL, 0x0000000205087824ULL, 0x000fe400078e00ffULL,
0x0000000802097824ULL, 0x000fe400078e00ffULL, 0x00000003ff107424ULL, 0x000fe200078e00ffULL,
0x000000060800720cULL, 0x000fda0003f06070ULL, 0x00006400080b8a10ULL, 0x000fe20007ffe0ffULL,
0x000000020d0a8824ULL, 0x000fc800078e00ffULL, 0x000064000a0b8a24ULL, 0x000fe400078e020bULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c1009ff738cULL, 0x0003e20000000000ULL, 0x000060000b0e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060e0a8981ULL, 0x0004e2000c1e1900ULL,
0x00000004ff117819ULL, 0x000fe20000011603ULL, 0x00000100050b7824ULL, 0x040fe200078e00ffULL,
0x0000000105107810ULL, 0x002fe20007ffe0ffULL, 0x0106880009ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000211137810ULL, 0x040fe20007ffe0ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000411167810ULL, 0x000fe20007ffe0ffULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000000071000720cULL, 0x000fe20003f06070ULL, 0x0000000109127824ULL, 0x040fe200078e0213ULL,
0x0000000b04107217ULL, 0x000fe20007800000ULL, 0x0000000109177824ULL, 0x000fe200078e0216ULL,
0x0000000611197810ULL, 0x000fe20007ffe0ffULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000712147812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0bULL,
0x00000007170e7812ULL, 0x004fe200078ec0ffULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000f140f7812ULL, 0x000fe200078e7803ULL, 0x0000000109147824ULL, 0x040fe200078e0219ULL,
0x0000002010107807ULL, 0x000fe20000000000ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000001012157824ULL, 0x000fe200078e020fULL,
0x0000000f0e127812ULL, 0x000fe200078e7803ULL, 0x00000001090f7824ULL, 0x040fe200078e0211ULL,
0x00000007141a7812ULL, 0x000fe200078ec0ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000001009107217ULL, 0x000fe20007800000ULL, 0x0000001017187824ULL, 0x000fe200078e0212ULL,
0x000000070f0e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000f1a177812ULL, 0x000fe200078e7803ULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x0000000f0e0e7812ULL, 0x000fc600078e7803ULL, 0x00000010141a7824ULL, 0x000fe200078e0217ULL,
0x000000101600720cULL, 0x080fe20003f06070ULL, 0x000000100f127824ULL, 0x000fe200078e020eULL,
0x000000101100720cULL, 0x080fe20003f26070ULL, 0x00000080000e7824ULL, 0x000fe200078e020fULL,
0x000000101300720cULL, 0x000fc80003f46070ULL, 0x000000020e147810ULL, 0x040fe40007ffe0ffULL,
0x000000040e167810ULL, 0x000fe20007ffe0ffULL, 0x000058000a0b7a24ULL, 0x008fc800078e02ffULL,
0x000000800b0b7824ULL, 0x000fca00078e00ffULL, 0x0000000e0b1d7210ULL, 0x040fe40007f7e0ffULL,
0x000000140b147210ULL, 0x000fe40007f9e0ffULL, 0x000000060e0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e001d177a11ULL, 0x040fe200078640ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x00005e0014117a11ULL, 0x000fe400078840ffULL,
0x00005f001d1d7a11ULL, 0x000fc400018f441cULL, 0x000000160b167210ULL, 0x040fe40007f7e0ffULL,
0x0000000e0b0b7210ULL, 0x000fe40007fbe0ffULL, 0x00005f00141b7a11ULL, 0x000fe200020f441bULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x000000f00c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x00005e0016137a11ULL, 0x000fe400078840ffULL,
0x00005e000b147a11ULL, 0x000fc400078a40ffULL, 0x00005f0016167a11ULL, 0x000fe400020f440fULL,
0x000000101900720cULL, 0x000fe40003f66070ULL, 0x000000171c0e7210ULL, 0x000fe40007f9e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe200028f440cULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000001c11107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e061dULL,
0x0000c00012177811ULL, 0x000fc400078e20ffULL, 0x0000001c13127210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e061bULL, 0x0000001c14147210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x0000c00015197811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200020e0616ULL,
0x0000c000181b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff157224ULL, 0x000fe200028e060bULL,
0x0000c0001a1d7811ULL, 0x000fe200078e20ffULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0xff317217ff0b7424ULL, 0x000fc600078e00ffULL, 0x00000000121b7faeULL, 0x0003e2000c101c46ULL,
0x000000070500720cULL, 0x000fc60003f06070ULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff627f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff0e7f8cULL, 0x002e62000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x000084a000000947ULL, 0x000fea0003800000ULL, 0x0000000402117824ULL, 0x000fe400078e00ffULL,
0x000000020d0d7824ULL, 0x000fc400078e00ffULL, 0x00006400ff127624ULL, 0x000fe200078e00ffULL,
0x0000000211137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x002fe400078e000fULL,
0x000064000d127624ULL, 0x000fe400078e0212ULL, 0xff317217ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe400078e00ffULL, 0x00000100050d7824ULL, 0x000fca00078e00ffULL,
0x000000040d00720cULL, 0x000fda0003f06070ULL, 0x000083b000000947ULL, 0x006fea0003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d000e7305ULL, 0x0002e4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x0000000e0000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff187819ULL, 0x000fe20000011603ULL,
0x000058000a0f7a24ULL, 0x000fe200078e02ffULL, 0x00000001050e7810ULL, 0x000fe40007ffe0ffULL,
0x0000002000157811ULL, 0x000fe200078e38ffULL, 0x0000000109167824ULL, 0x000fe200078e0218ULL,
0x000000070e00720cULL, 0x000fe20003f06070ULL, 0x000000800f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000218327810ULL, 0x000fe20007ffe0ffULL, 0x00000001160f7824ULL, 0x040fe200078e0215ULL,
0x00000007161a7812ULL, 0x000fc400078ec0ffULL, 0x00000020050d7811ULL, 0x000fe200078e40ffULL,
0x00000001091e7824ULL, 0x000fe200078e0232ULL, 0x0000000f1a5f7812ULL, 0x000fe400078e7803ULL,
0x0000000f0e0f7210ULL, 0x000fe40007f3e0ffULL, 0x0000000d04107217ULL, 0x000fe20007800000ULL,
0x00000010165f7824ULL, 0x000fe200078e025fULL, 0x0000000418227810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x000000071e207812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a0dULL, 0x00005e000f1a7a11ULL, 0x000fe200078240ffULL,
0x0000000109247824ULL, 0x000fe200078e0222ULL, 0x0000000f200d7812ULL, 0x000fc400078e7803ULL,
0x0000000618287810ULL, 0x000fe20007ffe0ffULL, 0x0000000124177824ULL, 0x000fe200078e0215ULL,
0x00005f000f1b7a11ULL, 0x000fe400008f4416ULL, 0x0000002010167807ULL, 0x000fe20000000000ULL,
0x000000101e107824ULL, 0x000fe200078e020dULL, 0x0000000724267812ULL, 0x000fe200078ec0ffULL,
0x000000011e0d7824ULL, 0x000fe200078e0215ULL, 0x0000001609167217ULL, 0x040fe20007800000ULL,
0x00000001092e7824ULL, 0x000fe200078e0228ULL, 0x0000000f260f7812ULL, 0x000fc400078e7803ULL,
0x0000000d0e1f7210ULL, 0x000fe20007f3e0ffULL, 0x00000001160d7824ULL, 0x000fe200078e0a09ULL,
0x000000072e1e7812ULL, 0x000fe200078ec0ffULL, 0x00000010240f7824ULL, 0x000fe200078e020fULL,
0x000000170e177210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000000f1e1d7812ULL, 0x000fe200078e7803ULL, 0x0000001003247824ULL, 0x000fe200078e00ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078440ffULL, 0x000000012e197824ULL, 0x040fe200078e0215ULL,
0x00005e0017207a11ULL, 0x000fe200078a40ffULL, 0x000000102e2e7824ULL, 0x000fe200078e021dULL,
0x00005f001f1f7a11ULL, 0x000fe200010f4416ULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x000000f024157812ULL, 0x000fc400078ec0ffULL, 0x000000190e197210ULL, 0x000fe40007fde0ffULL,
0x0000000d1800720cULL, 0x000fe40003f26070ULL, 0x000000151a1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x0000000d2200720cULL, 0x000fe40003f46070ULL,
0x00005f00171d7a11ULL, 0x000fe200028f4416ULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x00005e0019227a11ULL, 0x000fc400078a40ffULL, 0x0000000d2800720cULL, 0x080fe40003f66070ULL,
0x0000000d3200720cULL, 0x000fe40003f86070ULL, 0x0000e0005f167811ULL, 0x000fe400078e20ffULL,
0x00005f00190d7a11ULL, 0x000fe400028f4418ULL, 0x000000151e1e7210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a167faeULL, 0x0003e2000c901c46ULL,
0x0000001520207210ULL, 0x000fc40007f3e0ffULL, 0x0000e00010177811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e061fULL, 0x0000001522227210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff217224ULL, 0x000fe200008e061dULL, 0x0000e0000f187811ULL, 0x000fe400078e20ffULL,
0x0000e0002e197811ULL, 0x000fe200078e20ffULL, 0x000000ffff237224ULL, 0x000fe200028e060dULL,
0x000000001e177faeULL, 0x0003e8000e101c46ULL, 0x0000000020187faeULL, 0x0003e8000d101c46ULL,
0x0000000022197faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff2c7f8cULL, 0x000ee8000c80043fULL,
0x0106ac00ff1e7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800091a7f8cULL, 0x000fe2000c80043fULL,
0x800000001eff7812ULL, 0x006fc60007844863ULL, 0x01060c00090d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000782481bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01060c00091d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0xffffffffff1b7424ULL, 0x000fe200078e00ffULL, 0x00000070241a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0d0d7812ULL, 0x000fca00078ec0ffULL, 0x000000011a1a7824ULL, 0x000fca00078e020dULL,
0x010000001a1e7984ULL, 0x000e680000000800ULL, 0x010200001a0d7984ULL, 0x0005220000000800ULL,
0x0000000b1e00720bULL, 0x002fe20003f3d000ULL, 0x0000f7627f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x004fc800008e0100ULL, 0x0000ffff1d1f7812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff207424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fe40003f65270ULL,
0x0000000b1e00720bULL, 0x000fe20003f34000ULL, 0x0000f7327f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fe400008e0100ULL, 0x0000001e0b217209ULL, 0x000fe40007810000ULL,
0x0000ffff1d207812ULL, 0x000fe400078e3cffULL, 0x00000002ff5e7819ULL, 0x000fe20000011603ULL,
0x010400211a00b388ULL, 0x0003e20000000800ULL, 0x800000210b0b7221ULL, 0x000fe20000010000ULL,
0x000000201fff7212ULL, 0x000fc6000782c0ffULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b005b7308ULL, 0x0002a20000000800ULL, 0x0000f6e27f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b0b7589ULL, 0x0062a400000e0000ULL, 0x000000085e5e7810ULL, 0x002fe20007ffe0ffULL,
0x0000f7127f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b5a7589ULL, 0x00032400000e0000ULL,
0x800000211e1e1221ULL, 0x100fe20000010000ULL, 0x0000000b49497220ULL, 0x084fe20000410000ULL,
0x0000000b48487220ULL, 0x080fe20000410000ULL, 0x0000000b45457220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b1e1e1820ULL, 0x000fe20000410000ULL, 0x0000000b44447220ULL, 0x080fe20000410000ULL,
0x0000000b41417220ULL, 0x080fe20000410000ULL, 0x0000000b40407220ULL, 0x080fe20000410000ULL,
0x0000001e001c1308ULL, 0x000ea20000000800ULL, 0x0000000b3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000b3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b35357220ULL, 0x080fe20000410000ULL,
0x0000000b34347220ULL, 0x080fe20000410000ULL, 0x0000000b55557220ULL, 0x080fe20000410000ULL,
0x0000000b54547220ULL, 0x080fe20000410000ULL, 0x0000000b51517220ULL, 0x080fe20000410000ULL,
0x0000000b50507220ULL, 0x000fe20000410000ULL, 0x0000005b0c0c7220ULL, 0x000fe20000410000ULL,
0x0000005a4b4b7220ULL, 0x090fe20000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005a47477220ULL, 0x080fe20000410000ULL, 0x0000005a46467220ULL, 0x080fe20000410000ULL,
0x0000005a43437220ULL, 0x080fe20000410000ULL, 0x0000005a42427220ULL, 0x080fe20000410000ULL,
0x0000005a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000005a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005a37377220ULL, 0x080fe20000410000ULL, 0x0000005a36367220ULL, 0x080fe20000410000ULL,
0x0000005a57577220ULL, 0x080fe20000410000ULL, 0x0000005a56567220ULL, 0x080fe20000410000ULL,
0x0000005a53537220ULL, 0x080fe20000410000ULL, 0x0000005a52527220ULL, 0x000fe20000410000ULL,
0x00000001ff207807ULL, 0x000fe20000800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0021ULL,
0x0000001c0d0d1220ULL, 0x004fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000c0d0c7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff1e7984ULL, 0x000ea40000000800ULL,
0x800000001eff7812ULL, 0x004fc40007824863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d001d7305ULL, 0x000524000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x0000001d0000735dULL, 0x010fe20003800000ULL, 0x0106ac00ff1e7984ULL, 0x000ea40000000800ULL,
0x800000001eff7812ULL, 0x004fe40007824863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001cff0d723eULL, 0x000fe400000000ffULL, 0x00000004ff237819ULL, 0x000fc40000011603ULL,
0x00000002ff607819ULL, 0x000fe40000011603ULL, 0x000054100d5b7816ULL, 0x002fe2000000000dULL,
0x0000f3827f007947ULL, 0x000fea000b800000ULL, 0x00001f605b0d7589ULL, 0x0002a400000e0000ULL,
0x00000008601d7810ULL, 0x000fe20007ffe0ffULL, 0x0000f3c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b687589ULL, 0x00086400000e0000ULL, 0x0000001060617810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0061ULL,
0x00001d2000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0001031000007944ULL, 0x01cfea0003c00000ULL,
0x0000001860607810ULL, 0x002fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x000fe200078e0060ULL, 0x00001d9000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000102a000007944ULL, 0x01cfea0003c00000ULL, 0x00000008031e7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000703647812ULL, 0x040fe400078ec0ffULL,
0x00000011031f7211ULL, 0x000fe400078fe0ffULL, 0x000000071e227812ULL, 0x100fe400078ec803ULL,
0x0000000864647812ULL, 0x100fe400078ef803ULL, 0x000000071e217812ULL, 0x000fc400078ef803ULL,
0x0000001f22587212ULL, 0x000fe400078e3cffULL, 0x00000007231f7812ULL, 0x000fe400078e7864ULL,
0x0000001303237211ULL, 0x000fe200078fe0ffULL, 0x0000001021667824ULL, 0x000fe200078e0258ULL,
0x0000991020207816ULL, 0x000fe200000000ffULL, 0x00000008641e7824ULL, 0x000fe200078e021fULL,
0x0000002322227212ULL, 0x000fe400078e3cffULL, 0x0000c000661f7811ULL, 0x000fc400078e20ffULL,
0x0000a0001e247811ULL, 0x000fe200078e20ffULL, 0x0000001021657824ULL, 0x040fe200078e0222ULL,
0x000000ff2000720cULL, 0x000fe20003f25270ULL, 0x000000001f28783bULL, 0x000f620000004200ULL,
0x0000010021677811ULL, 0x000fe400078e20ffULL, 0x0000c00065207811ULL, 0x000fe200078e20ffULL,
0x000000002424783bULL, 0x000e640000000200ULL, 0x0000000122627824ULL, 0x100fe400078e0267ULL,
0x00000000204c783bULL, 0x000f220000004200ULL, 0x0000000158677824ULL, 0x000fc400078e0267ULL,
0x0000c00062227811ULL, 0x000fe400078e20ffULL, 0x0000312028287816ULL, 0x020fe400000000ffULL,
0x0000312029297816ULL, 0x000fe400000000ffULL, 0x00000028ff30723eULL, 0x080fe200020006ffULL,
0x0000000d24249232ULL, 0x086fe20000000000ULL, 0x00000029ff31723eULL, 0x080fe200020006ffULL,
0x0000000d26269232ULL, 0x000fe20000000000ULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000006825259232ULL, 0x080fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000006827279232ULL, 0x000fe20000000000ULL, 0x000031202a237816ULL, 0x000fc400000000ffULL,
0x000031202b5b7816ULL, 0x010fe400000000ffULL, 0x00000023ff5a723eULL, 0x080fe400030006ffULL,
0x000000282454723cULL, 0x040fe20000001854ULL, 0x000031204c4c7816ULL, 0x000fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204e2f7816ULL, 0x000fe400000000ffULL,
0x0000000732297812ULL, 0x000fe200078e7864ULL, 0x000000302450723cULL, 0x000fe20000001850ULL,
0x00000023ff28723eULL, 0x000fc400020006ffULL, 0x0000c00067237811ULL, 0x000fe200078e20ffULL,
0x0000000864217824ULL, 0x000fe200078e0229ULL, 0x0000005bff29723eULL, 0x080fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400030006ffULL, 0x0000a00021307811ULL, 0x000fe400078e20ffULL,
0x0000002fff58723eULL, 0x000fe200020006ffULL, 0x000000282434723cULL, 0x040fe20000001834ULL,
0x000000002228783bULL, 0x000e680000004200ULL, 0x000000003030783bULL, 0x000ea60000000200ULL,
0x0000005a2438723cULL, 0x000fee0000001838ULL, 0x0000004cff5a723eULL, 0x000fc400020006ffULL,
0x0000004dff5b723eULL, 0x080fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400030006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x0000005a243c723cULL, 0x040fee000000183cULL,
0x000031204f5a7816ULL, 0x000fe200000000ffULL, 0x0000004c2440723cULL, 0x000fe20000001840ULL,
0x00000000234c783bULL, 0x000f240000004200ULL, 0x0000005aff59723eULL, 0x000fc400020006ffULL,
0x0000312028287816ULL, 0x002fca00000000ffULL, 0x000000582444723cULL, 0x000fe20000001844ULL,
0x0000312029297816ULL, 0x000fe200000000ffULL, 0x0000000d30309232ULL, 0x084fe20000000000ULL,
0x000031202a2a7816ULL, 0x000fe200000000ffULL, 0x0000000d32329232ULL, 0x000fe20000000000ULL,
0x000031202b2b7816ULL, 0x000fe200000000ffULL, 0x0000006831319232ULL, 0x080fe20000000000ULL,
0x0000002fff58723eULL, 0x000fe200030006ffULL, 0x0000006833339232ULL, 0x000fe20000000000ULL,
0x0000005aff59723eULL, 0x000fce00030006ffULL, 0x000000582424723cULL, 0x000fee0000001848ULL,
0x00000028ff48723eULL, 0x080fe400020006ffULL, 0x00000029ff49723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fc400030006ffULL, 0x00000029ff29723eULL, 0x000fe400030006ffULL,
0x000031204c4c7816ULL, 0x010fe200000000ffULL, 0x00000048303c723cULL, 0x000fe2000000183cULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204e4e7816ULL, 0x000fe400000000ffULL,
0x000031204f4f7816ULL, 0x000fc600000000ffULL, 0x000000283040723cULL, 0x000fee0000001840ULL,
0x0000002aff28723eULL, 0x080fe400020006ffULL, 0x0000002bff29723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fc400030006ffULL, 0x0000002bff2b723eULL, 0x000fc600030006ffULL,
0x000000283044723cULL, 0x000fee0000001844ULL, 0x0000004cff28723eULL, 0x080fe400020006ffULL,
0x0000004dff29723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fc400030006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x000000283050723cULL, 0x040fee0000001850ULL,
0x0000004eff28723eULL, 0x080fe200020006ffULL, 0x0000004c3054723cULL, 0x000fe20000001854ULL,
0x0000004fff29723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fc400030006ffULL,
0x0000004fff4f723eULL, 0x000fc600030006ffULL, 0x000000283034723cULL, 0x040ff00000001834ULL,
0x0000004e3038723cULL, 0x040ff00000001838ULL, 0x0000002a3030723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff247f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007844825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00267305ULL, 0x0002a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000040050d7811ULL, 0x000fe400078e40ffULL, 0x00000004ff487819ULL, 0x000fe40000011603ULL,
0x0000000d04247217ULL, 0x000fe40007800000ULL, 0x0000004000287811ULL, 0x000fe400078e38ffULL,
0x0000000248587810ULL, 0x000fe20007ffe0ffULL, 0x0000000124247824ULL, 0x000fe200078e0a0dULL,
0x00000009280d7210ULL, 0x000fc40007ffe048ULL, 0x0000000928257210ULL, 0x000fe40007ffe058ULL,
0x0000002024247807ULL, 0x000fe40000000000ULL, 0x000000250e257210ULL, 0x000fe40007f7e0ffULL,
0x0000002409247217ULL, 0x000fe40007800000ULL, 0x00000004484e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000d0e277210ULL, 0x000fe20007f5e0ffULL, 0x00000001240d7824ULL, 0x000fe200078e0a09ULL,
0x00005e00254a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00000006484c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001092f7824ULL, 0x000fe200078e024eULL,
0x0000000d4800720cULL, 0x000fe20003f66070ULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005f0025297a11ULL, 0x000fe200020f4424ULL, 0x000000012f257824ULL, 0x000fe200078e0228ULL,
0x00005e0027267a11ULL, 0x000fc400078440ffULL, 0x0000c0005f247811ULL, 0x000fe400078e20ffULL,
0x00005f0027277a11ULL, 0x000fe400010f442aULL, 0x000000250e2b7210ULL, 0x000fe40007f9e0ffULL,
0x0000001526267210ULL, 0x000fe40007f5e0ffULL, 0x0000000928257210ULL, 0x000fe20007ffe04cULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x000000250e257210ULL, 0x000fc40007fde0ffULL,
0x000000154a287210ULL, 0x000fe40007fbe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200020f4448ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000000d5800720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026247faeULL, 0x0003e2000d901c46ULL,
0x00005e0025487a11ULL, 0x000fe200078840ffULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000000d4e00720cULL, 0x080fe40003f66070ULL, 0x0000000d4c00720cULL, 0x000fc40003fa6070ULL,
0x000000152a2a7210ULL, 0x080fe40007fde0ffULL, 0x00005f00250d7a11ULL, 0x000fe400020f444aULL,
0x0000001548487210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e062bULL,
0x0000c00010257811ULL, 0x000fe400078e20ffULL, 0x0000c0000f267811ULL, 0x002fe200078e20ffULL,
0x000000ffff497224ULL, 0x000fe200020e060dULL, 0x0000c0002e277811ULL, 0x000fe200078e20ffULL,
0x0000000028257faeULL, 0x0003e8000d101c46ULL, 0x000000002a267faeULL, 0x0003e8000d901c46ULL,
0x0000000048277faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff287f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x00afc4000784482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff637224ULL, 0x000fe200078e0029ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x0106b400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001cff0f723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x000fe40000011603ULL, 0x00000004030d7811ULL, 0x000fe400078fe0ffULL,
0x000054100f5b7816ULL, 0x000fe2000000000fULL, 0x0000e5b27f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b0f7589ULL, 0x0002a400000e0000ULL, 0x0000e5f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b107589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0061ULL, 0x00002bb000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fc400078e00ffULL,
0x0000f48000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0060ULL, 0x00002c1000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000f42000007944ULL, 0x01cfea0003c00000ULL, 0x000000070d0d7812ULL, 0x000fe200078e7864ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e00066287811ULL, 0x000fe400078e20ffULL,
0x0000e000652a7811ULL, 0x000fe200078e20ffULL, 0x0000000864297824ULL, 0x000fe400078e020dULL,
0x000000002848783bULL, 0x000f660000004200ULL, 0x0000a000290d7811ULL, 0x000fe200078e20ffULL,
0x000000002a4c783bULL, 0x000fe80000004200ULL, 0x000000000d5c783bULL, 0x0022e40000000200ULL,
0x00000006030d7811ULL, 0x002fc800078fe0ffULL, 0x000000070d0d7812ULL, 0x000fca00078e7864ULL,
0x00000008642b7824ULL, 0x000fe200078e020dULL, 0x0000312048487816ULL, 0x020fe400000000ffULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x00000048ff2c723eULL, 0x080fe400020006ffULL,
0x00000049ff2d723eULL, 0x080fe200020006ffULL, 0x0000000f5c5c9232ULL, 0x08cfe20000000000ULL,
0x000031204a4a7816ULL, 0x000fe200000000ffULL, 0x0000000f5e5e9232ULL, 0x000fe20000000000ULL,
0x000031204b4b7816ULL, 0x000fe200000000ffULL, 0x000000105d5d9232ULL, 0x090fe20000000000ULL,
0x00000048ff48723eULL, 0x000fe200030006ffULL, 0x000000105f5f9232ULL, 0x000fe20000000000ULL,
0x00000049ff49723eULL, 0x000fc400030006ffULL, 0x0000004aff64723eULL, 0x080fe400030006ffULL,
0x0000004bff65723eULL, 0x080fe400030006ffULL, 0x0000002c5c50723cULL, 0x040fe20000001850ULL,
0x000031204c4c7816ULL, 0x000fe400000000ffULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x000031204e4e7816ULL, 0x000fe400000000ffULL, 0x0000004aff2c723eULL, 0x000fe200020006ffULL,
0x000000485c54723cULL, 0x000fe20000001854ULL, 0x0000004bff2d723eULL, 0x000fc400020006ffULL,
0x000031204f4f7816ULL, 0x000fc800000000ffULL, 0x0000a0002b487811ULL, 0x000fe200078e20ffULL,
0x0000002c5c34723cULL, 0x040fea0000001834ULL, 0x000000004848783bULL, 0x000e640000000200ULL,
0x0000e000672c7811ULL, 0x000fe200078e20ffULL, 0x000000645c38723cULL, 0x000fe20000001838ULL,
0x0000e000622d7811ULL, 0x000fc600078e20ffULL, 0x000000002c58783bULL, 0x000ea60000004200ULL,
0x0000004cff64723eULL, 0x080fe400020006ffULL, 0x0000004dff65723eULL, 0x080fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000645c3c723cULL, 0x040fee000000183cULL, 0x0000004eff64723eULL, 0x000fe200030006ffULL,
0x0000004c5c40723cULL, 0x000fe20000001840ULL, 0x0000004fff65723eULL, 0x000fcc00030006ffULL,
0x0000004eff4c723eULL, 0x000fe200020006ffULL, 0x000000645c30723cULL, 0x000fe20000001830ULL,
0x0000004fff4d723eULL, 0x000fe200020006ffULL, 0x0000000f48489232ULL, 0x082fe40000000000ULL,
0x0000000f4a4a9232ULL, 0x000fc80000000000ULL, 0x0000004c5c44723cULL, 0x000fe20000001844ULL,
0x000000002d4c783bULL, 0x000e620000004200ULL, 0x0000001049499232ULL, 0x080fe20000000000ULL,
0x0000312058587816ULL, 0x004fe200000000ffULL, 0x000000104b4b9232ULL, 0x000fe20000000000ULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00000058ff5c723eULL, 0x080fe400020006ffULL,
0x00000059ff5d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fe400030006ffULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x0000005c4850723cULL, 0x000fe20000001850ULL, 0x000031205b5b7816ULL, 0x000fce00000000ffULL,
0x000000584854723cULL, 0x000fee0000001854ULL, 0x0000005aff58723eULL, 0x080fe400020006ffULL,
0x0000005bff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fe400030006ffULL, 0x000031204c4c7816ULL, 0x002fe200000000ffULL,
0x000000584834723cULL, 0x040fe20000001834ULL, 0x000031204d4d7816ULL, 0x000fe400000000ffULL,
0x000031204e4e7816ULL, 0x000fe400000000ffULL, 0x000031204f4f7816ULL, 0x000fe400000000ffULL,
0x0000004cff58723eULL, 0x000fe200020006ffULL, 0x0000005a4838723cULL, 0x000fe20000001838ULL,
0x0000004dff59723eULL, 0x000fc400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400030006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x00000058483c723cULL, 0x040ff0000000183cULL,
0x0000004c4840723cULL, 0x000fee0000001840ULL, 0x0000004eff4c723eULL, 0x000fc400020006ffULL,
0x0000004fff4d723eULL, 0x080fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400030006ffULL,
0x0000004fff4f723eULL, 0x000fc600030006ffULL, 0x0000004c4844723cULL, 0x040ff00000001844ULL,
0x0000004e4848723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040050d7811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000000d0400720cULL, 0x000fda0003f24070ULL,
0x00005fc000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0a7984ULL, 0x000ea40000000800ULL,
0x800000000aff7812ULL, 0x006fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff2e7624ULL, 0x000fe200078e00ffULL,
0x00000001080a7812ULL, 0x000fc800078ec0ffULL, 0x000000010a00780cULL, 0x000fe20003f25070ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0xffffffff2e2e7811ULL, 0x000fc800078e08ffULL,
0x000000012e2e7807ULL, 0x000fca0004800000ULL, 0x0000000108087824ULL, 0x000fca00078e022eULL,
0x000000060800720cULL, 0x000fe40003f26070ULL, 0x00000004ff5d7819ULL, 0x000fe40000011603ULL,
0x0000006000327811ULL, 0x000fd200078e38ffULL, 0x0000002e12309210ULL, 0x000fe20007ffe014ULL,
0x00000004ff319424ULL, 0x000fe200078e00ffULL, 0x00000009320f7210ULL, 0x000fc60007ffe05dULL,
0x0000600030309625ULL, 0x000fe200078e0031ULL, 0x00000060050d7811ULL, 0x000fc800078e40ffULL,
0x00000006300a9981ULL, 0x000362000c1e1900ULL, 0x0000000f0e4f7210ULL, 0x000fe40007f3e0ffULL,
0x0000000d04107217ULL, 0x000fe40007800000ULL, 0x00000004035b7811ULL, 0x000fe200078fe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200008e06ffULL, 0x000000025d5a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a0dULL, 0x0000000603597811ULL, 0x000fe400078fe0ffULL,
0x00005e004f587a11ULL, 0x000fe200078240ffULL, 0x00000001090d7824ULL, 0x000fe200078e025aULL,
0x0000005b320f7210ULL, 0x000fc40007ffe009ULL, 0x0000005932317210ULL, 0x002fe40007ffe009ULL,
0x00005f004f4f7a11ULL, 0x000fe400008f444cULL, 0x0000000f0e337210ULL, 0x040fe20007f3e0ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0232ULL, 0x000000310e317210ULL, 0x000fe40007f7e0ffULL,
0x0000002010107807ULL, 0x000fe20000000000ULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x00005e0033327a11ULL, 0x000fe200078440ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x0000001009107217ULL, 0x000fc40007800000ULL, 0x0000000f0e0f7210ULL, 0x000fe40007f3e0ffULL,
0x00005e00314c7a11ULL, 0x000fe200078640ffULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x00005f0033337a11ULL, 0x000fe200010f444eULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x00005f00314d7a11ULL, 0x000fe400018f4430ULL, 0x00005e000f307a11ULL, 0x000fe400078640ffULL,
0x00000015580e7210ULL, 0x000fc40007f9e0ffULL, 0x000000105d00720cULL, 0x080fe40003f46070ULL,
0x00005f000f317a11ULL, 0x000fe200018f444eULL, 0x000000ffff0f7224ULL, 0x000fe200020e064fULL,
0x0000001530307210ULL, 0x000fe40007fbe0ffULL, 0x000000105a00720cULL, 0x080fe40003f26070ULL,
0x000000105b00720cULL, 0x080fe20003f66070ULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x000000105900720cULL, 0x000fc40003f86070ULL, 0x0000001532327210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e167faeULL, 0x0003e2000d101c46ULL,
0x000000154c4c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe400030e0633ULL,
0x000000ffff4d7224ULL, 0x000fe200028e064dULL, 0x0000000030177faeULL, 0x0003e8000c901c46ULL,
0x0000000032187faeULL, 0x0003e8000d901c46ULL, 0x000000004c197faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff647f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff0e7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280009307f8cULL, 0x000fe2000c80043fULL, 0x800000000eff7812ULL, 0x002fc60007844863ULL,
0x01062c00090f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0002e4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x008fe40003800000ULL, 0x01062c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080001a0e7984ULL, 0x000e680000000800ULL, 0x010280001a0f7984ULL, 0x0007220000000800ULL,
0x0000000b0e00720bULL, 0x002fe20003f3d000ULL, 0x0000d7a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800008e0100ULL, 0x0000ffff10327812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f65270ULL,
0x0000000b0e00720bULL, 0x000fe20003f34000ULL, 0x0000d7727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x0000000e0b307209ULL, 0x040fe40007810000ULL,
0x0000ffff10337812ULL, 0x000fe400078e3cffULL, 0x00000002ff5e7819ULL, 0x000fe20000011603ULL,
0x800000300b317221ULL, 0x000fe20000010000ULL, 0x010480301a00b388ULL, 0x0003e20000000800ULL,
0x0000003332ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x00000031005b7308ULL, 0x000ee40000000800ULL, 0x0000005b0c0c7220ULL, 0x008fe20000410000ULL,
0x0000d7127f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b5a7589ULL, 0x0022e400000e0000ULL,
0x0000005a50507220ULL, 0x08cfe20000410000ULL, 0x0000005a51517220ULL, 0x080fe20000410000ULL,
0x0000005a54547220ULL, 0x080fe20000410000ULL, 0x0000005a55557220ULL, 0x080fe20000410000ULL,
0x0000005a34347220ULL, 0x080fe20000410000ULL, 0x0000005a35357220ULL, 0x080fe20000410000ULL,
0x0000005a38387220ULL, 0x080fe20000410000ULL, 0x0000005a39397220ULL, 0x080fe20000410000ULL,
0x0000005a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005a40407220ULL, 0x080fe20000410000ULL, 0x0000005a41417220ULL, 0x080fe20000410000ULL,
0x0000005a44447220ULL, 0x080fe20000410000ULL, 0x0000005a45457220ULL, 0x080fe20000410000ULL,
0x0000005a48487220ULL, 0x080fe20000410000ULL, 0x0000005a49497220ULL, 0x000fe20000410000ULL,
0x0000d6427f007947ULL, 0x000fea000b800000ULL, 0x00001f1d5b5a7589ULL, 0x0004e400000e0000ULL,
0x0000000e0b0b7209ULL, 0x000fe20007810000ULL, 0x0000005a52527220ULL, 0x08cfe20000410000ULL,
0x00000001ff107807ULL, 0x000fe20000800000ULL, 0x0000005a53537220ULL, 0x080fe20000410000ULL,
0x0000005a56567220ULL, 0x080fe20000410000ULL, 0x8000000b0e0e1221ULL, 0x000fe20000010000ULL,
0x0000005a57577220ULL, 0x080fe20000410000ULL, 0x0000005a36367220ULL, 0x080fe20000410000ULL,
0x0000005a37377220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fe20000410000ULL,
0x0000005a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000e001c1308ULL, 0x000ea20000000800ULL,
0x0000005a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005a42427220ULL, 0x080fe20000410000ULL,
0x0000005a43437220ULL, 0x080fe20000410000ULL, 0x0000005a46467220ULL, 0x080fe20000410000ULL,
0x0000005a47477220ULL, 0x080fe20000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005a4b4b7220ULL, 0x000fe20000410000ULL, 0x0000000f1c0f1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000c0f0c7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0e7984ULL, 0x000ee40000000800ULL, 0x800000000eff7812ULL, 0x008fc40007824863ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x000724000021f000ULL,
0x3fa000000e0e7823ULL, 0x008fe200000100ffULL, 0x0000000f0000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff307984ULL, 0x000ee40000000800ULL, 0x8000000030ff7812ULL, 0x008fe40007824863ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001cff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x002fc40000011603ULL, 0x000054100e5b7816ULL, 0x000fe2000000000eULL,
0x0000d3e27f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b0f7589ULL, 0x0002e400000e0000ULL,
0x0000d4227f007947ULL, 0x000fea000b800000ULL, 0x00001f1d5b0e7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0061ULL,
0x00003fa000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000e09000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0060ULL,
0x0000400000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000e03000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a8001e4d7811ULL, 0x000fe200078e20ffULL,
0x000000001f30783bULL, 0x000f220000004200ULL, 0x0000991010107816ULL, 0x000fc600000000ffULL,
0x00000000205c783bULL, 0x002fe20000004200ULL, 0x000000ff1000720cULL, 0x000fc60003f25270ULL,
0x000000004d4c783bULL, 0x000e620000000200ULL, 0x0000312030307816ULL, 0x010fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x00000030ff58723eULL, 0x000fe400020006ffULL,
0x00000031ff59723eULL, 0x000fc600020006ffULL, 0x0000000f4c4c9232ULL, 0x08afe20000000000ULL,
0x00000030ff30723eULL, 0x000fe200030006ffULL, 0x0000000f4e4e9232ULL, 0x000fe20000000000ULL,
0x00000031ff31723eULL, 0x000fe200030006ffULL, 0x0000000e4d4d9232ULL, 0x080fe20000000000ULL,
0x0000312033637816ULL, 0x000fe200000000ffULL, 0x0000000e4f4f9232ULL, 0x000fe20000000000ULL,
0x0000312032107816ULL, 0x000fe400000000ffULL, 0x000031205c5c7816ULL, 0x000fe400000000ffULL,
0x00000010ff62723eULL, 0x000fc400030006ffULL, 0x000000304c54723cULL, 0x000fe20000001854ULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x0000a80021327811ULL, 0x000fc800078e20ffULL,
0x00000063ff31723eULL, 0x080fe200020006ffULL, 0x000000584c50723cULL, 0x000fe20000001850ULL,
0x00000063ff63723eULL, 0x000fe200030006ffULL, 0x000000002358783bULL, 0x004e620000004200ULL,
0x00000010ff30723eULL, 0x000fe400020006ffULL, 0x000031205e107816ULL, 0x000fc600000000ffULL,
0x000000624c38723cULL, 0x040fee0000001838ULL, 0x0000005cff62723eULL, 0x080fe200020006ffULL,
0x000000304c34723cULL, 0x000fe20000001834ULL, 0x0000005dff63723eULL, 0x000fe200020006ffULL,
0x000000003230783bULL, 0x000ea20000000200ULL, 0x0000005cff5c723eULL, 0x000fc400030006ffULL,
0x0000005dff5d723eULL, 0x000fc600030006ffULL, 0x000000624c3c723cULL, 0x040fee000000183cULL,
0x000031205f637816ULL, 0x000fe200000000ffULL, 0x0000005c4c40723cULL, 0x000fe20000001840ULL,
0x00000010ff62723eULL, 0x000fcc00030006ffULL, 0x00000010ff5c723eULL, 0x000fe400020006ffULL,
0x00000063ff5d723eULL, 0x080fe400020006ffULL, 0x0000312058587816ULL, 0x002fe400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00000063ff63723eULL, 0x000fe200030006ffULL,
0x0000005c4c44723cULL, 0x000fe20000001844ULL, 0x00000000225c783bULL, 0x000e620000004200ULL,
0x000031205a5a7816ULL, 0x000fc400000000ffULL, 0x000031205b5b7816ULL, 0x000fc800000000ffULL,
0x000000624c48723cULL, 0x000fe20000001848ULL, 0x0000000f30309232ULL, 0x084fe40000000000ULL,
0x0000000f32329232ULL, 0x000fe20000000000ULL, 0x00000059ff0f723eULL, 0x080fe200020006ffULL,
0x0000000e31319232ULL, 0x080fe20000000000ULL, 0x00000059ff59723eULL, 0x000fe200030006ffULL,
0x0000000e33339232ULL, 0x000fe20000000000ULL, 0x00000058ff0e723eULL, 0x080fe400020006ffULL,
0x00000058ff58723eULL, 0x000fca00030006ffULL, 0x0000000e3050723cULL, 0x040fee0000001850ULL,
0x0000005aff0e723eULL, 0x080fe200020006ffULL, 0x000000583054723cULL, 0x000fe20000001854ULL,
0x0000005bff0f723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fc600030006ffULL, 0x0000000e3034723cULL, 0x040fe20000001834ULL,
0x000031205c5c7816ULL, 0x002fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x0000005cff0e723eULL, 0x000fe200020006ffULL,
0x0000005a3038723cULL, 0x000fe20000001838ULL, 0x0000005dff0f723eULL, 0x000fe400020006ffULL,
0x000031205f5f7816ULL, 0x000fc400000000ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fe200030006ffULL, 0x0000000e303c723cULL, 0x040fee000000183cULL,
0x0000005eff0e723eULL, 0x000fe200020006ffULL, 0x0000005c3040723cULL, 0x000fe20000001840ULL,
0x0000005fff0f723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400030006ffULL,
0x0000005fff5f723eULL, 0x000fc600030006ffULL, 0x0000000e3044723cULL, 0x040ff00000001844ULL,
0x0000005e3030723cULL, 0x000fe20000001848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff487f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007844849ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007844849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007844849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff597819ULL, 0x000fe20000011603ULL,
0x000058000a0f7a24ULL, 0x020fe200078e02ffULL, 0x0000008005497811ULL, 0x000fe400078e40ffULL,
0x00000002594f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090e7824ULL, 0x000fe200078e0259ULL,
0x0000004904107217ULL, 0x000fe20007800000ULL, 0x000000800f0f7824ULL, 0x000fe200078e00ffULL,
0x00000004595b7810ULL, 0x000fe20007ffe0ffULL, 0x00000080005a7824ULL, 0x000fe400078e020eULL,
0x0000000110107824ULL, 0x000fc600078e0a49ULL, 0x0000000f5a487210ULL, 0x000fe40007f5e0ffULL,
0x0000002010107807ULL, 0x000fe40000000000ULL, 0x000000025a4a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00005e0048587a11ULL, 0x040fe400078440ffULL,
0x0000001009107217ULL, 0x000fe40007800000ULL, 0x00005f0048497a11ULL, 0x000fc400010f4449ULL,
0x000000045a487810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x0000000f4a4b7210ULL, 0x080fe40007f5e0ffULL, 0x0000000f484d7210ULL, 0x000fe40007f9e0ffULL,
0x000000065a5a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4e7224ULL, 0x000fe200010e06ffULL,
0x00005e004b4a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x00005e004d4c7a11ULL, 0x000fc400078840ffULL, 0x000000104f00720cULL, 0x000fe40003f46070ULL,
0x00005f004d4d7a11ULL, 0x000fe400020f4448ULL, 0x0000001558487210ULL, 0x000fe40007fbe0ffULL,
0x0000000f5a4f7210ULL, 0x000fe40007f9e0ffULL, 0x00005f004b4b7a11ULL, 0x000fe200018f444eULL,
0x000000ffff497224ULL, 0x000fe200028e0649ULL, 0x000000154a4a7210ULL, 0x080fe20007fde0ffULL,
0x000000ffff587224ULL, 0x000fe200020e06ffULL, 0x000000154c4c7210ULL, 0x000fc40007fbe0ffULL,
0x000000105900720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff4b7224ULL, 0x000fe200030e064bULL,
0x0000000659597810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200028e064dULL,
0x00005e004f4e7a11ULL, 0x000fe400078840ffULL, 0x000000105b00720cULL, 0x080fe40003fc6070ULL,
0x000000105900720cULL, 0x000fe40003fa6070ULL, 0x00005f004f107a11ULL, 0x000fc400020f4458ULL,
0x000000154e4e7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048247faeULL, 0x0003e8000d901c46ULL, 0x000000ffff4f7224ULL, 0x000fe200020e0610ULL,
0x000000004a257faeULL, 0x0003e8000d101c46ULL, 0x000000004c267faeULL, 0x0003e8000f101c46ULL,
0x000000004e277faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff627f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff497984ULL, 0x002e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007844865ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000109107824ULL, 0x000fe200078e0259ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fe40007844865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff487424ULL, 0x000fc800078e00ffULL, 0x0000004800497305ULL, 0x0002a4000021f000ULL,
0x3fa0000048487823ULL, 0x002fe200000100ffULL, 0x000000490000735dULL, 0x004fe40003800000ULL,
0x0106b400ff497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007844865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001cff48723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x000fe40000011603ULL, 0x00005410485b7816ULL, 0x000fe20000000048ULL,
0x0000c7d27f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b657589ULL, 0x0002a400000e0000ULL,
0x0000c8127f007947ULL, 0x000fea000b800000ULL, 0x00001f1d5b627589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0061ULL,
0x00004c8000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000d3b000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e0060ULL,
0x00004ce000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000d35000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a80029587811ULL, 0x000fe200078e20ffULL,
0x000000002848783bULL, 0x000f680000004200ULL, 0x00000000585c783bULL, 0x002e680000000200ULL,
0x000000002a4c783bULL, 0x000ee20000004200ULL, 0x0000312048487816ULL, 0x020fc400000000ffULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x00000048ff5a723eULL, 0x084fe200020006ffULL,
0x000000655c5c9232ULL, 0x082fe20000000000ULL, 0x00000049ff5b723eULL, 0x088fe200020006ffULL,
0x000000655e5e9232ULL, 0x000fe20000000000ULL, 0x00000048ff48723eULL, 0x000fe200030006ffULL,
0x000000625d5d9232ULL, 0x090fe20000000000ULL, 0x00000049ff49723eULL, 0x000fe200030006ffULL,
0x000000625f5f9232ULL, 0x000fe20000000000ULL, 0x000031204b677816ULL, 0x000fc400000000ffULL,
0x000031204a647816ULL, 0x000fe400000000ffULL, 0x000031204c4c7816ULL, 0x000fe400000000ffULL,
0x000000485c54723cULL, 0x040fe20000001854ULL, 0x00000064ff66723eULL, 0x080fe400030006ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x0000a8002b4a7811ULL, 0x000fe400078e20ffULL,
0x00000067ff49723eULL, 0x080fe200020006ffULL, 0x0000005a5c50723cULL, 0x000fe20000001850ULL,
0x00000067ff67723eULL, 0x000fe200030006ffULL, 0x000000002c58783bULL, 0x000e620000004200ULL,
0x00000064ff48723eULL, 0x000fc400020006ffULL, 0x000031204e647816ULL, 0x000fc600000000ffULL,
0x000000665c38723cULL, 0x040fee0000001838ULL, 0x0000004cff66723eULL, 0x080fe200020006ffULL,
0x000000485c34723cULL, 0x000fe20000001834ULL, 0x0000004dff67723eULL, 0x000fe200020006ffULL,
0x000000004a48783bULL, 0x000ea20000000200ULL, 0x0000004cff4c723eULL, 0x000fc400030006ffULL,
0x0000004dff4d723eULL, 0x000fc600030006ffULL, 0x000000665c3c723cULL, 0x040fee000000183cULL,
0x000031204f677816ULL, 0x000fe200000000ffULL, 0x0000004c5c40723cULL, 0x000fe20000001840ULL,
0x00000064ff66723eULL, 0x000fcc00030006ffULL, 0x00000064ff4c723eULL, 0x000fe400020006ffULL,
0x00000067ff4d723eULL, 0x080fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400030006ffULL,
0x0000312058587816ULL, 0x002fe400000000ffULL, 0x0000312059597816ULL, 0x000fe200000000ffULL,
0x0000004c5c44723cULL, 0x000fe20000001844ULL, 0x000000002d4c783bULL, 0x000e620000004200ULL,
0x000031205a5a7816ULL, 0x000fc400000000ffULL, 0x000031205b5b7816ULL, 0x000fc800000000ffULL,
0x000000665c30723cULL, 0x000fe20000001830ULL, 0x0000006548489232ULL, 0x084fe40000000000ULL,
0x000000654a4a9232ULL, 0x000fe40000000000ULL, 0x0000006249499232ULL, 0x080fe40000000000ULL,
0x00000058ff5c723eULL, 0x080fe200020006ffULL, 0x000000624b4b9232ULL, 0x000fe20000000000ULL,
0x00000059ff5d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x0000005c4850723cULL, 0x040ff00000001850ULL,
0x000000584854723cULL, 0x000fee0000001854ULL, 0x0000005aff58723eULL, 0x000fc400020006ffULL,
0x0000005bff59723eULL, 0x000fe400020006ffULL, 0x000031204c4c7816ULL, 0x002fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fe400000000ffULL, 0x000031204e4e7816ULL, 0x000fe200000000ffULL,
0x000000584834723cULL, 0x000fe20000001834ULL, 0x000031204f4f7816ULL, 0x000fe400000000ffULL,
0x0000005aff5a723eULL, 0x000fc400030006ffULL, 0x0000005bff5b723eULL, 0x000fe400030006ffULL,
0x0000004cff58723eULL, 0x080fe400020006ffULL, 0x0000004dff59723eULL, 0x080fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x0000005a4838723cULL, 0x000fe20000001838ULL,
0x0000004dff4d723eULL, 0x000fce00030006ffULL, 0x0000004c4840723cULL, 0x040fee0000001840ULL,
0x0000004eff4c723eULL, 0x080fe200020006ffULL, 0x00000058483c723cULL, 0x000fe2000000183cULL,
0x0000004fff4d723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fc400030006ffULL,
0x0000004fff4f723eULL, 0x000fc600030006ffULL, 0x0000004c4844723cULL, 0x040ff00000001844ULL,
0x0000004e4848723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008005337811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000330400720cULL, 0x000fda0003f24070ULL,
0x00003f8000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x002e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000327305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000320000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff327984ULL, 0x000e640000000800ULL, 0x8000000032ff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff5b7819ULL, 0x000fe40000011603ULL,
0x00000020004e7811ULL, 0x000fe400078e38ffULL, 0x000000a005317811ULL, 0x000fe400078e40ffULL,
0x0000005b4e307210ULL, 0x000fe40007ffe009ULL, 0x0000003104327217ULL, 0x000fe40007800000ULL,
0x000000300f307210ULL, 0x000fc40007f3e0ffULL, 0x000000065b5d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000132317824ULL, 0x000fe200078e0a31ULL, 0x000000045b5f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff597224ULL, 0x000fe200008e06ffULL, 0x00005e00305e7a11ULL, 0x040fe400078240ffULL,
0x000000025b657810ULL, 0x000fe40007ffe0ffULL, 0x00005f0030597a11ULL, 0x000fe400008f4459ULL,
0x0000005d4e307210ULL, 0x000fc40007ffe009ULL, 0x0000005f4e327210ULL, 0x140fe40007ffe009ULL,
0x000000654e4c7210ULL, 0x000fe40007ffe009ULL, 0x000000300f307210ULL, 0x000fe40007f7e0ffULL,
0x00000020314e7807ULL, 0x000fe40000000000ULL, 0x000000320f327210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x0000004c0f337210ULL, 0x000fc40007f3e0ffULL,
0x0000004e094e7217ULL, 0x000fe20007800000ULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x00005e0030587a11ULL, 0x000fe200078640ffULL, 0x000000ffff5c7224ULL, 0x000fe200008e06ffULL,
0x00005e00324c7a11ULL, 0x000fe200078440ffULL, 0x000000014e4e7824ULL, 0x000fe200078e0a09ULL,
0x00005e00335a7a11ULL, 0x000fe400078240ffULL, 0x00005f00304f7a11ULL, 0x000fe400018f444fULL,
0x00005f00324d7a11ULL, 0x000fc400010f444dULL, 0x000000155e307210ULL, 0x080fe40007f7e0ffULL,
0x00005f0033337a11ULL, 0x000fe400008f445cULL, 0x000000155a327210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200018e0659ULL, 0x0000004e5b00720cULL, 0x080fe40003f46070ULL,
0x000000154c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000004e6500720cULL, 0x000fc40003f26070ULL, 0x0000004e5f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff4d7224ULL, 0x000fe200028e064dULL, 0x0000004e5d00720cULL, 0x000fe40003f86070ULL,
0x00000015584e7210ULL, 0x000fc60007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030167faeULL, 0x0003e4000d101c46ULL, 0x000000ffff4f7224ULL, 0x000fe400028e064fULL,
0x0000000032177faeULL, 0x0003e8000c901c46ULL, 0x000000004c187faeULL, 0x0003e8000d901c46ULL,
0x000000004e197faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff647f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff307984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480009327f8cULL, 0x000fe2000c80043fULL,
0x8000000030ff7812ULL, 0x002fc60007844863ULL, 0x01064c0009317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007824833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002e4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x008fe40003800000ULL,
0x01064c0009317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100001a327984ULL, 0x000e680000000800ULL,
0x010300001a337984ULL, 0x0007220000000800ULL, 0x0000000b3200720bULL, 0x002fe20003f3d000ULL,
0x0000bb227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x008fc800008e0100ULL,
0x0000ffff304e7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff5f7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f65270ULL, 0x0000000b3200720bULL, 0x000fe20003f34000ULL,
0x0000baf27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x000fe400008e0100ULL,
0x000000320b317209ULL, 0x040fe40007810000ULL, 0x0000ffff304d7812ULL, 0x000fe400078e3cffULL,
0x00000002ff5e7819ULL, 0x000fe20000011603ULL, 0x800000310b4c7221ULL, 0x000fe20000010000ULL,
0x010500311a00b388ULL, 0x0003e20000000800ULL, 0x0000004d4eff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b4c4c7820ULL, 0x000fc80000410000ULL, 0x0000004c005b7308ULL, 0x000ee40000000800ULL,
0x0000005b0c0c7220ULL, 0x008fe20000410000ULL, 0x0000ba927f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b5a7589ULL, 0x0022e400000e0000ULL, 0x0000005a50507220ULL, 0x08cfe20000410000ULL,
0x0000005a51517220ULL, 0x080fe20000410000ULL, 0x0000005a54547220ULL, 0x080fe20000410000ULL,
0x0000005a55557220ULL, 0x080fe20000410000ULL, 0x0000005a34347220ULL, 0x080fe20000410000ULL,
0x0000005a35357220ULL, 0x080fe20000410000ULL, 0x0000005a38387220ULL, 0x080fe20000410000ULL,
0x0000005a39397220ULL, 0x080fe20000410000ULL, 0x0000005a3c3c7220ULL, 0x080fe20000410000ULL,
0x0000005a3d3d7220ULL, 0x080fe20000410000ULL, 0x0000005a40407220ULL, 0x080fe20000410000ULL,
0x0000005a41417220ULL, 0x080fe20000410000ULL, 0x0000005a44447220ULL, 0x080fe20000410000ULL,
0x0000005a45457220ULL, 0x080fe20000410000ULL, 0x0000005a48487220ULL, 0x080fe20000410000ULL,
0x0000005a49497220ULL, 0x000fe20000410000ULL, 0x0000b9c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b5a7589ULL, 0x0004e400000e0000ULL, 0x000000320b0b7209ULL, 0x000fe20007810000ULL,
0x0000005a52527220ULL, 0x08cfe20000410000ULL, 0x00000001ff5f7807ULL, 0x000fe20000800000ULL,
0x0000005a53537220ULL, 0x080fe20000410000ULL, 0x0000005a56567220ULL, 0x080fe20000410000ULL,
0x8000000b32321221ULL, 0x000fe20000010000ULL, 0x0000005a57577220ULL, 0x080fe20000410000ULL,
0x0000005a36367220ULL, 0x080fe20000410000ULL, 0x0000005a37377220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL, 0x0000005a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005a3e3e7220ULL, 0x080fe20000410000ULL,
0x00000032001c1308ULL, 0x000ea20000000800ULL, 0x0000005a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005a42427220ULL, 0x080fe20000410000ULL, 0x0000005a43437220ULL, 0x080fe20000410000ULL,
0x0000005a46467220ULL, 0x080fe20000410000ULL, 0x0000005a47477220ULL, 0x080fe20000410000ULL,
0x0000005a4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005a4b4b7220ULL, 0x000fe20000410000ULL,
0x000000331c331220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000c330c7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff307984ULL, 0x000ee40000000800ULL,
0x8000000030ff7812ULL, 0x008fc40007824863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x000724000021f000ULL, 0x3fa0000030307823ULL, 0x008fe200000100ffULL,
0x000000310000735dULL, 0x010fe20003800000ULL, 0x0106ac00ff327984ULL, 0x000ee40000000800ULL,
0x8000000032ff7812ULL, 0x008fe40007824863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001cff30723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x002fc40000011603ULL,
0x00005410305b7816ULL, 0x000fe20000000030ULL, 0x0000b7627f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b637589ULL, 0x0002e400000e0000ULL, 0x0000b7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b627589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0061ULL, 0x00005f1000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000c12000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0060ULL, 0x00005f7000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000c0c000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000b0001e4d7811ULL, 0x000fe200078e20ffULL, 0x000000001f30783bULL, 0x000f620000004200ULL,
0x000099105f587816ULL, 0x000fc600000000ffULL, 0x00000000205c783bULL, 0x002fe20000004200ULL,
0x000000ff5800720cULL, 0x000fc60003f25270ULL, 0x000000004d4c783bULL, 0x000e620000000200ULL,
0x0000312030307816ULL, 0x020fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x00000030ff58723eULL, 0x000fe400020006ffULL, 0x00000031ff59723eULL, 0x000fc600020006ffULL,
0x000000634c4c9232ULL, 0x08afe20000000000ULL, 0x00000030ff30723eULL, 0x000fe200030006ffULL,
0x000000634e4e9232ULL, 0x000fe20000000000ULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x000000624d4d9232ULL, 0x080fe20000000000ULL, 0x0000312032667816ULL, 0x000fe200000000ffULL,
0x000000624f4f9232ULL, 0x000fe20000000000ULL, 0x0000312033677816ULL, 0x000fe400000000ffULL,
0x000031205c5c7816ULL, 0x000fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fc400000000ffULL,
0x000000304c54723cULL, 0x000fe20000001854ULL, 0x0000b00021327811ULL, 0x000fcc00078e20ffULL,
0x00000066ff30723eULL, 0x080fe200020006ffULL, 0x000000584c50723cULL, 0x000fe20000001850ULL,
0x00000067ff31723eULL, 0x080fe200020006ffULL, 0x000000002358783bULL, 0x014e620000004200ULL,
0x00000066ff66723eULL, 0x000fe400030006ffULL, 0x00000067ff67723eULL, 0x000fc600030006ffULL,
0x000000304c34723cULL, 0x040fe20000001834ULL, 0x000000003230783bULL, 0x000eae0000000200ULL,
0x000000664c38723cULL, 0x000fee0000001838ULL, 0x0000005cff66723eULL, 0x000fc400020006ffULL,
0x0000005dff67723eULL, 0x080fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fc600030006ffULL, 0x000000664c3c723cULL, 0x040fee000000183cULL,
0x000031205e667816ULL, 0x000fe200000000ffULL, 0x0000005c4c40723cULL, 0x000fe20000001840ULL,
0x000031205f677816ULL, 0x000fe400000000ffULL, 0x0000312058587816ULL, 0x002fc400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00000066ff5c723eULL, 0x080fe400020006ffULL,
0x00000067ff5d723eULL, 0x080fe200020006ffULL, 0x0000006330309232ULL, 0x084fe20000000000ULL,
0x00000066ff66723eULL, 0x000fe200030006ffULL, 0x0000006332329232ULL, 0x000fe20000000000ULL,
0x00000067ff67723eULL, 0x000fe200030006ffULL, 0x0000006231319232ULL, 0x080fe20000000000ULL,
0x000031205a5a7816ULL, 0x000fe200000000ffULL, 0x0000005c4c44723cULL, 0x000fe20000001844ULL,
0x00000000225c783bULL, 0x000e620000004200ULL, 0x0000006233339232ULL, 0x000fe20000000000ULL,
0x000031205b5b7816ULL, 0x000fca00000000ffULL, 0x000000664c48723cULL, 0x000fee0000001848ULL,
0x00000058ff4c723eULL, 0x080fe400020006ffULL, 0x00000059ff4d723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400030006ffULL, 0x00000059ff59723eULL, 0x000fc600030006ffULL,
0x0000004c3050723cULL, 0x040fee0000001850ULL, 0x0000005aff4c723eULL, 0x080fe200020006ffULL,
0x000000583054723cULL, 0x000fe20000001854ULL, 0x0000005bff4d723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400030006ffULL, 0x0000005bff5b723eULL, 0x000fc600030006ffULL,
0x0000004c3034723cULL, 0x040fe20000001834ULL, 0x000031205c5c7816ULL, 0x002fe400000000ffULL,
0x000031205d5d7816ULL, 0x000fe400000000ffULL, 0x000031205e5e7816ULL, 0x000fe400000000ffULL,
0x0000005cff4c723eULL, 0x000fe200020006ffULL, 0x0000005a3038723cULL, 0x000fe20000001838ULL,
0x0000005dff4d723eULL, 0x000fe400020006ffULL, 0x000031205f5f7816ULL, 0x000fc400000000ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fe200030006ffULL,
0x0000004c303c723cULL, 0x040fee000000183cULL, 0x0000005eff4c723eULL, 0x000fe200020006ffULL,
0x0000005c3040723cULL, 0x000fe20000001840ULL, 0x0000005fff4d723eULL, 0x000fce00020006ffULL,
0x0000004c3044723cULL, 0x000fee0000001844ULL, 0x0000005eff4c723eULL, 0x000fe400030006ffULL,
0x0000005fff4d723eULL, 0x000fce00030006ffULL, 0x0000004c304c723cULL, 0x000fe20000001848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff327f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000040004a7811ULL, 0x000fe400078e38ffULL, 0x000000c005317811ULL, 0x000fc400078e40ffULL,
0x00000004ff5e7819ULL, 0x000fe20000011603ULL, 0x000000010d307824ULL, 0x100fe400078e024aULL,
0x000000010e487824ULL, 0x100fe200078e024aULL, 0x000000025e627810ULL, 0x000fe20007ffe0ffULL,
0x000000012f587824ULL, 0x100fe200078e024aULL, 0x0000000f30337210ULL, 0x000fe20007f7e0ffULL,
0x00000001104a7824ULL, 0x000fe200078e024aULL, 0x0000003104307217ULL, 0x000fe40007800000ULL,
0x0000000f48487210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00005e00335a7a11ULL, 0x000fe200078640ffULL, 0x0000000130307824ULL, 0x000fc400078e0a31ULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00005f0033337a11ULL, 0x000fe400018f4432ULL,
0x0000000f4a4b7210ULL, 0x000fe40007f7e0ffULL, 0x00005e00485c7a11ULL, 0x000fe400078440ffULL,
0x0000002030307807ULL, 0x000fe20000000000ULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00005f0048317a11ULL, 0x000fe400010f4449ULL, 0x0000003009307217ULL, 0x000fc40007800000ULL,
0x0000000f58497210ULL, 0x000fe40007f5e0ffULL, 0x00005e004b4a7a11ULL, 0x040fe200078640ffULL,
0x00000001302f7824ULL, 0x000fe400078e0a09ULL, 0x000000ffff587224ULL, 0x000fe200010e06ffULL,
0x00005f004b4b7a11ULL, 0x000fe400018f4432ULL, 0x000000155c307210ULL, 0x000fe40007f7e0ffULL,
0x00005e0049487a11ULL, 0x000fc400078440ffULL, 0x000000155a327210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200018e0631ULL, 0x00005f0049497a11ULL, 0x000fe400010f4458ULL,
0x0000001548487210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x000000045e587810ULL, 0x040fe40007ffe0ffULL, 0x0000002f5e00720cULL, 0x040fe20003f66070ULL,
0x000000ffff497224ULL, 0x000fe200028e0649ULL, 0x000000065e5e7810ULL, 0x000fc40007ffe0ffULL,
0x0000002f6200720cULL, 0x080fe40003f46070ULL, 0x0000002f5800720cULL, 0x080fe40003f86070ULL,
0x0000002f5e00720cULL, 0x000fe40003fa6070ULL, 0x000000154a4a7210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030247faeULL, 0x0003e4000d901c46ULL,
0x000000ffff4b7224ULL, 0x000fe400030e064bULL, 0x0000000032257faeULL, 0x0003e8000d101c46ULL,
0x0000000048267faeULL, 0x0003e8000e101c46ULL, 0x000000004a277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff627f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff2f7984ULL, 0x000ea40000000800ULL,
0x800000002fff7812ULL, 0x004fc40007844865ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff2f7984ULL, 0x000ea40000000800ULL, 0x800000002fff7812ULL, 0x004fe40007844865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x0022a4000021f000ULL,
0x3fa000002f2f7823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe20003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001cff2f723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x000fe40000011603ULL, 0x000054102f5b7816ULL, 0x000fe2000000002fULL,
0x0000ab827f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b2f7589ULL, 0x0004e400000e0000ULL,
0x0000abc27f007947ULL, 0x000fea000b800000ULL, 0x00001f1d5b627589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x006fe200078e0061ULL,
0x00006bc000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000b47000007944ULL, 0x018fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x006fe200078e0060ULL,
0x00006c2000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000b41000007944ULL, 0x018fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b00029587811ULL, 0x000fe200078e20ffULL,
0x000000002848783bULL, 0x002e680000004200ULL, 0x000000005830783bULL, 0x000f680000000200ULL,
0x000000002a5c783bULL, 0x004ea20000004200ULL, 0x0000312048487816ULL, 0x002fc400000000ffULL,
0x0000312049497816ULL, 0x000fe400000000ffULL, 0x00000048ff5a723eULL, 0x080fe200020006ffULL,
0x0000002f30309232ULL, 0x0a8fe20000000000ULL, 0x00000049ff5b723eULL, 0x090fe200020006ffULL,
0x0000002f32329232ULL, 0x000fe20000000000ULL, 0x00000048ff48723eULL, 0x000fe200030006ffULL,
0x0000006231319232ULL, 0x080fe20000000000ULL, 0x00000049ff49723eULL, 0x000fe200030006ffULL,
0x0000006233339232ULL, 0x000fe20000000000ULL, 0x000031204a647816ULL, 0x000fc400000000ffULL,
0x000031204b657816ULL, 0x000fe400000000ffULL, 0x000031205c5c7816ULL, 0x004fe400000000ffULL,
0x000000483054723cULL, 0x000fe20000001854ULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x0000b0002b4a7811ULL, 0x000fc800078e20ffULL, 0x00000064ff48723eULL, 0x080fe200020006ffULL,
0x0000005a3050723cULL, 0x000fe20000001850ULL, 0x00000065ff49723eULL, 0x080fe200020006ffULL,
0x000000002c58783bULL, 0x000e620000004200ULL, 0x00000064ff64723eULL, 0x000fe400030006ffULL,
0x00000065ff65723eULL, 0x000fc600030006ffULL, 0x000000483034723cULL, 0x040fe20000001834ULL,
0x000000004a48783bULL, 0x000eae0000000200ULL, 0x000000643038723cULL, 0x000fee0000001838ULL,
0x0000005cff64723eULL, 0x000fc400020006ffULL, 0x0000005dff65723eULL, 0x080fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x00000064303c723cULL, 0x040fee000000183cULL, 0x000031205e647816ULL, 0x000fe200000000ffULL,
0x0000005c3040723cULL, 0x000fe20000001840ULL, 0x000031205f657816ULL, 0x000fe400000000ffULL,
0x0000312058587816ULL, 0x002fc400000000ffULL, 0x0000312059597816ULL, 0x000fe400000000ffULL,
0x00000064ff5c723eULL, 0x080fe400020006ffULL, 0x00000065ff5d723eULL, 0x080fe200020006ffULL,
0x0000002f48489232ULL, 0x084fe20000000000ULL, 0x00000064ff64723eULL, 0x000fe200030006ffULL,
0x0000002f4a4a9232ULL, 0x000fe20000000000ULL, 0x00000065ff65723eULL, 0x000fe200030006ffULL,
0x0000006249499232ULL, 0x080fe20000000000ULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x0000005c3044723cULL, 0x000fe20000001844ULL, 0x000000002d5c783bULL, 0x000e620000004200ULL,
0x000000624b4b9232ULL, 0x000fe20000000000ULL, 0x000031205b5b7816ULL, 0x000fca00000000ffULL,
0x00000064304c723cULL, 0x000fee000000184cULL, 0x00000058ff30723eULL, 0x080fe400020006ffULL,
0x00000059ff31723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x000000304850723cULL, 0x040fee0000001850ULL,
0x0000005aff30723eULL, 0x080fe200020006ffULL, 0x000000584854723cULL, 0x000fe20000001854ULL,
0x0000005bff31723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fc400030006ffULL,
0x0000005bff5b723eULL, 0x000fc600030006ffULL, 0x000000304834723cULL, 0x040fe20000001834ULL,
0x000031205c5c7816ULL, 0x002fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x0000005cff30723eULL, 0x000fe200020006ffULL,
0x0000005a4838723cULL, 0x000fe20000001838ULL, 0x0000005dff31723eULL, 0x000fe400020006ffULL,
0x000031205f5f7816ULL, 0x000fc400000000ffULL, 0x0000005cff5c723eULL, 0x000fe400030006ffULL,
0x0000005dff5d723eULL, 0x000fe200030006ffULL, 0x00000030483c723cULL, 0x040fee000000183cULL,
0x0000005eff30723eULL, 0x000fe200020006ffULL, 0x0000005c4840723cULL, 0x000fe20000001840ULL,
0x0000005fff31723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400030006ffULL,
0x0000005fff5f723eULL, 0x000fc600030006ffULL, 0x000000304844723cULL, 0x040ff00000001844ULL,
0x0000005e4848723cULL, 0x000fe2000000184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c0052f7811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000002f0400720cULL, 0x000fda0003f24070ULL,
0x0000204000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff087984ULL, 0x000ea40000000800ULL,
0x8000000008ff7812ULL, 0x006fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x00000008000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000114317824ULL, 0x000fe400078e022eULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x00000001310a7812ULL, 0x000fc600078ec0ffULL, 0x0000030008087a24ULL, 0x000fe200078e0a2fULL,
0x000000010a00780cULL, 0x000fe20003f25070ULL, 0xffffffffff0a7424ULL, 0x000fc600078e00ffULL,
0x0000000108087807ULL, 0x000fca0004800000ULL, 0x0000000131087824ULL, 0x000fca00078e0208ULL,
0x000000060800720cULL, 0x000fe40003f26070ULL, 0x000000e005317811ULL, 0x000fe400078e40ffULL,
0x0000006000327811ULL, 0x000fe400078e38ffULL, 0x0000003104147217ULL, 0x000fce0007800000ULL,
0x00000001082e9824ULL, 0x000fe400078e0212ULL, 0x00000004ff2f9424ULL, 0x000fe200078e00ffULL,
0x00000004034d7811ULL, 0x040fe200078fe0ffULL, 0x000000010e307824ULL, 0x000fe400078e0232ULL,
0x000060002e2e9625ULL, 0x000fe200078e002fULL, 0x00000006034f7811ULL, 0x000fc600078fe0ffULL,
0x000000010d4c7824ULL, 0x000fe200078e0232ULL, 0x000000062e0a9981ULL, 0x000362000c1e1900ULL,
0x0000000114147824ULL, 0x000fe200078e0a31ULL, 0x0000004d320e7210ULL, 0x100fe40007ffe009ULL,
0x0000000f30307210ULL, 0x000fe40007f3e0ffULL, 0x0000004f32327210ULL, 0x000fe40007ffe009ULL,
0x0000000f0e317210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200008e06ffULL,
0x0000000f4c2f7210ULL, 0x002fc40007f5e0ffULL, 0x0000002014147807ULL, 0x000fe20000000000ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e00304e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005e002f4c7a11ULL, 0x000fe400078440ffULL,
0x0000000f320d7210ULL, 0x000fe40007f9e0ffULL, 0x0000001409147217ULL, 0x000fe40007800000ULL,
0x00005f00300f7a11ULL, 0x000fc400008f4433ULL, 0x00005f002f2f7a11ULL, 0x000fe200010f440eULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00000004ff337819ULL, 0x000fe20000011603ULL,
0x0000000114147824ULL, 0x000fe200078e0a09ULL, 0x00005e000d327a11ULL, 0x000fe400078240ffULL,
0x00005e0031307a11ULL, 0x000fe400078040ffULL, 0x0000000233597810ULL, 0x000fe40007ffe0ffULL,
0x00005f000d0d7a11ULL, 0x000fc400008f440eULL, 0x00005f0031317a11ULL, 0x000fe400000f442eULL,
0x000000154e0e7210ULL, 0x080fe40007f9e0ffULL, 0x000000143300720cULL, 0x080fe40003f66070ULL,
0x000000154c2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x000000145900720cULL, 0x080fe40003f46070ULL, 0x000000144d00720cULL, 0x080fe20003f26070ULL,
0x000000ffff2f7224ULL, 0x000fe200028e062fULL, 0x000000144f00720cULL, 0x000fc40003f06070ULL,
0x0000001530307210ULL, 0x080fe40007f9e0ffULL, 0x0000001532327210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e167faeULL, 0x0003e4000d901c46ULL,
0x000000ffff317224ULL, 0x000fe400020e0631ULL, 0x000000ffff337224ULL, 0x000fe200028e060dULL,
0x000000002e177faeULL, 0x0003e8000d101c46ULL, 0x0000000030187faeULL, 0x0003e8000c901c46ULL,
0x0000000032197faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff0e7f8cULL, 0x002e68000c80043fULL,
0x0106ac00ff147984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680009167f8cULL, 0x000fe2000c80043fULL,
0x8000000014ff7812ULL, 0x004fc60007804863ULL, 0x01066c00090d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007824817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00147305ULL, 0x0004e4000021f000ULL,
0x3fa000000d0d7823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x008fe20003800000ULL,
0x01066c0009197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fc40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180001a147984ULL, 0x000ea80000000800ULL,
0x010380001a0d7984ULL, 0x0007220000000800ULL, 0x0000000b1400720bULL, 0x004fe20003f3d000ULL,
0x00009df27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000167806ULL, 0x008fc800008e0100ULL,
0x0000ffff16177812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x000fe40003f45270ULL, 0x0000000b1400720bULL, 0x000fe20003f34000ULL,
0x00009dc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000167806ULL, 0x000fe400008e0100ULL,
0x000000140b197209ULL, 0x040fe40007810000ULL, 0x0000ffff16167812ULL, 0x000fe400078e3cffULL,
0x00000002ff5e7819ULL, 0x000fe20000011603ULL, 0x800000190b0b7221ULL, 0x000fe20000010000ULL,
0x010580191a00a388ULL, 0x0005e20000000800ULL, 0x0000001617ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b005b7308ULL, 0x000ee40000000800ULL,
0x0000005b0c0c7220ULL, 0x008fe20000410000ULL, 0x00009d627f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b5a7589ULL, 0x0044e400000e0000ULL, 0x0000005a50507220ULL, 0x08cfe20000410000ULL,
0x0000005a51517220ULL, 0x080fe20000410000ULL, 0x0000005a54547220ULL, 0x080fe20000410000ULL,
0x0000005a55557220ULL, 0x080fe20000410000ULL, 0x0000005a34347220ULL, 0x080fe20000410000ULL,
0x0000005a35357220ULL, 0x080fe20000410000ULL, 0x0000005a38387220ULL, 0x080fe20000410000ULL,
0x0000005a39397220ULL, 0x080fe20000410000ULL, 0x0000005a3c3c7220ULL, 0x080fe20000410000ULL,
0x0000005a3d3d7220ULL, 0x080fe20000410000ULL, 0x0000005a40407220ULL, 0x080fe20000410000ULL,
0x0000005a41417220ULL, 0x080fe20000410000ULL, 0x0000005a44447220ULL, 0x080fe20000410000ULL,
0x0000005a45457220ULL, 0x080fe20000410000ULL, 0x0000005a48487220ULL, 0x080fe20000410000ULL,
0x0000005a49497220ULL, 0x000fe20000410000ULL, 0x00009c927f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b5a7589ULL, 0x0004e400000e0000ULL, 0x8000001914141221ULL, 0x100fe20000010000ULL,
0x00000001ff167807ULL, 0x000fe20000800000ULL, 0x0000005a52527220ULL, 0x08cfe20000410000ULL,
0x0000005a53537220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b14141820ULL, 0x000fe20000410000ULL,
0x0000005a56567220ULL, 0x080fe20000410000ULL, 0x0000005a57577220ULL, 0x080fe20000410000ULL,
0x0000005a36367220ULL, 0x080fe20000410000ULL, 0x00000014001c1308ULL, 0x000ea20000000800ULL,
0x0000005a37377220ULL, 0x080fe20000410000ULL, 0x0000005a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000005a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005a42427220ULL, 0x080fe20000410000ULL,
0x0000005a43437220ULL, 0x080fe20000410000ULL, 0x0000005a46467220ULL, 0x080fe20000410000ULL,
0x0000005a47477220ULL, 0x080fe20000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005a4b4b7220ULL, 0x000fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0019ULL,
0x0000000d1c0d1220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000c0d0c7221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fc40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00147305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x000000140000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001cff0d723eULL, 0x000fe400000000ffULL, 0x00000002ff5e7819ULL, 0x002fc40000011603ULL,
0x000054100d5b7816ULL, 0x000fe2000000000dULL, 0x00009a327f007947ULL, 0x000fea000b800000ULL,
0x00001f5e5b0d7589ULL, 0x0002a400000e0000ULL, 0x00009a727f007947ULL, 0x000fea000b800000ULL,
0x00001f1d5b147589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0061ULL, 0x00007f3000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000a10000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e0060ULL, 0x00007f9000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000a0a000007944ULL, 0x03cfea0003c00000ULL, 0x0000b8001e197811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001f4c783bULL, 0x000e620000004200ULL,
0x0000991016167816ULL, 0x000fc400000000ffULL, 0x0000b80021217811ULL, 0x000fe200078e20ffULL,
0x000000001918783bULL, 0x000ee20000000200ULL, 0x000000ff1600720cULL, 0x000fc60003f05270ULL,
0x000000002030783bULL, 0x000f280000004200ULL, 0x000000002358783bULL, 0x00ee680000004200ULL,
0x00000000225c783bULL, 0x000ea20000004200ULL, 0x000031204c4c7816ULL, 0x000fe400000000ffULL,
0x000031204d4d7816ULL, 0x000fc400000000ffULL, 0x0000004cff16723eULL, 0x080fe200020006ffULL,
0x0000000d18188232ULL, 0x080fe20000000000ULL, 0x0000004dff17723eULL, 0x080fe200020006ffULL,
0x0000000d1a1a8232ULL, 0x000fe20000000000ULL, 0x0000004cff4c723eULL, 0x000fe200030006ffULL,
0x0000001419198232ULL, 0x090fe20000000000ULL, 0x0000004dff4d723eULL, 0x000fe200030006ffULL,
0x000000141b1b8232ULL, 0x000fe20000000000ULL, 0x0000312030307816ULL, 0x000fe400000000ffULL,
0x0000312031317816ULL, 0x000fc400000000ffULL, 0x0000312032327816ULL, 0x000fe400000000ffULL,
0x000000161850723cULL, 0x040fe20000001850ULL, 0x0000312033337816ULL, 0x000fe400000000ffULL,
0x000031205a5a7816ULL, 0x002fe400000000ffULL, 0x000031205b5b7816ULL, 0x000fe400000000ffULL,
0x000031204e167816ULL, 0x000fe200000000ffULL, 0x0000004c1854723cULL, 0x000fe20000001854ULL,
0x000031204f177816ULL, 0x000fc400000000ffULL, 0x00000000214c783bULL, 0x0002e20000000200ULL,
0x00000016ff1e723eULL, 0x080fe400020006ffULL, 0x00000017ff1f723eULL, 0x080fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe400030006ffULL, 0x00000017ff17723eULL, 0x000fe400030006ffULL,
0x0000312059217816ULL, 0x002fe200000000ffULL, 0x0000001e1834723cULL, 0x000fe20000001834ULL,
0x000031205c5c7816ULL, 0x004fc400000000ffULL, 0x000031205d5d7816ULL, 0x000fe400000000ffULL,
0x000031205e5e7816ULL, 0x000fe400000000ffULL, 0x000031205f5f7816ULL, 0x000fe200000000ffULL,
0x000000161838723cULL, 0x000fe20000001838ULL, 0x0000312058587816ULL, 0x000fc800000000ffULL,
0x00000058ff20723eULL, 0x000fe400030006ffULL, 0x00000030ff16723eULL, 0x080fe400020006ffULL,
0x00000031ff17723eULL, 0x080fe400020006ffULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x00000016183c723cULL, 0x000fe2000000183cULL,
0x0000000d4c4c8232ULL, 0x008fcc0000000000ULL, 0x00000032ff16723eULL, 0x080fe200020006ffULL,
0x000000301840723cULL, 0x040fe20000001840ULL, 0x00000033ff17723eULL, 0x080fe200020006ffULL,
0x0000000d4e4e8232ULL, 0x000fe20000000000ULL, 0x00000032ff32723eULL, 0x000fe200030006ffULL,
0x000000144d4d8232ULL, 0x080fe20000000000ULL, 0x00000033ff33723eULL, 0x000fe200030006ffULL,
0x000000144f4f8232ULL, 0x000fe20000000000ULL, 0x0000005aff30723eULL, 0x000fe200020006ffULL,
0x000000161844723cULL, 0x000fe20000001844ULL, 0x0000005bff31723eULL, 0x000fcc00020006ffULL,
0x0000005eff16723eULL, 0x080fe200020006ffULL, 0x000000321848723cULL, 0x000fe20000001848ULL,
0x0000005fff17723eULL, 0x080fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400030006ffULL,
0x0000005fff5f723eULL, 0x000fe400030006ffULL, 0x00000021ff19723eULL, 0x000fe200020006ffULL,
0x000000304c30723cULL, 0x000fe20000001834ULL, 0x00000058ff18723eULL, 0x000fc400020006ffULL,
0x00000021ff21723eULL, 0x000fc800030006ffULL, 0x0000005aff34723eULL, 0x000fe200030006ffULL,
0x000000184c18723cULL, 0x000fe20000001850ULL, 0x0000005bff35723eULL, 0x000fce00030006ffULL,
0x000000344c34723cULL, 0x040fee0000001838ULL, 0x0000005cff38723eULL, 0x080fe200020006ffULL,
0x000000204c20723cULL, 0x000fe20000001854ULL, 0x0000005dff39723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x000000384c38723cULL, 0x040ff0000000183cULL, 0x0000005c4c40723cULL, 0x040ff00000001840ULL,
0x000000164c44723cULL, 0x040ff00000001844ULL, 0x0000005e4c48723cULL, 0x000fe20000001848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff167f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007824817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00147305ULL, 0x0002a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x000000140000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300050d7a10ULL, 0x000fe20007ffe0ffULL, 0x000058000a167a24ULL, 0x020fe200078e02ffULL,
0x00000004ff4e7819ULL, 0x000fe20000011603ULL, 0x0000008000107824ULL, 0x000fe200078e0210ULL,
0x000000010d147810ULL, 0x040fe20007ffe0ffULL, 0x000001000d177824ULL, 0x000fe200078e00ffULL,
0x000000024e507810ULL, 0x000fe20007ffe0ffULL, 0x00000080162e7824ULL, 0x000fe200078e00ffULL,
0xfffffffa100d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001704167217ULL, 0x000fc40007800000ULL,
0x000000071400720cULL, 0x000fe40003f46070ULL, 0x0000000d2e3d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000116167824ULL, 0x000fe200078e0a17ULL, 0xfffffffc10147810ULL, 0x040fe40007ffe0ffULL,
0xfffffffe100d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000002016167807ULL, 0x000fe40001000000ULL, 0x00005e003d4c7a11ULL, 0x000fc400078640ffULL,
0x000000142e1f7210ULL, 0x040fe40007f9e0ffULL, 0x0000000d2e2f7210ULL, 0x040fe40007fbe0ffULL,
0x0000001609167217ULL, 0x000fe20007800000ULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x000000102e107210ULL, 0x000fe40007f3e0ffULL, 0x00005f003d3d7a11ULL, 0x000fe200018f441eULL,
0x000000ffff1e7224ULL, 0x000fe200028e06ffULL, 0x00005e001f3c7a11ULL, 0x000fe200078440ffULL,
0x00000001160d7824ULL, 0x000fe200078e0a09ULL, 0x00005e002f2e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x00005e0010147a11ULL, 0x000fc400078240ffULL,
0x00005f001f1f7a11ULL, 0x000fe400010f443eULL, 0x00005f002f2f7a11ULL, 0x000fe400018f441eULL,
0x000000154c167210ULL, 0x000fe40007f9e0ffULL, 0x000000064e3e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000d4e00720cULL, 0x000fe40003f46070ULL, 0x000000153c1e7210ULL, 0x000fc40007fbe0ffULL,
0x000000044e4e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0010107a11ULL, 0x000fe200008f4417ULL,
0x000000ffff177224ULL, 0x000fe200020e063dULL, 0x000000152e2e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e061fULL, 0x0000000d5000720cULL, 0x080fe40003f26070ULL,
0x0000000d4e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff2f7224ULL, 0x000fe200018e062fULL,
0x0000000d3e00720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016247faeULL, 0x0003e2000d101c46ULL, 0x0000001514147210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe400018e0610ULL, 0x000000001e257faeULL, 0x0003e8000c901c46ULL,
0x000000002e267faeULL, 0x0003e8000e101c46ULL, 0x0000000014277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff627f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fc4000782480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00107305ULL, 0x0004e4000021f000ULL,
0x3fa000000d0d7823ULL, 0x004fe200000100ffULL, 0x000000100000735dULL, 0x008fe20003800000ULL,
0x0106b400ff157984ULL, 0x002e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001cff0d723eULL, 0x000fe400000000ffULL,
0x00000002ff5e7819ULL, 0x000fe40000011603ULL, 0x000054100d5b7816ULL, 0x000fe2000000000dULL,
0x00008e127f007947ULL, 0x000fea000b800000ULL, 0x00001f5e5b0d7589ULL, 0x0004e400000e0000ULL,
0x00008e527f007947ULL, 0x000fea000b800000ULL, 0x00001f1d5b0e7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x006fe200078e0061ULL,
0x00008c2000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000941000007944ULL, 0x018fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5e7224ULL, 0x006fe200078e0060ULL,
0x00008c8000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000093b000007944ULL, 0x018fea0003c00000ULL,
0x0000b80029297811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002814783bULL, 0x002e680000004200ULL, 0x000000002924783bULL, 0x000f680000000200ULL,
0x000000002a3c783bULL, 0x000f220000004200ULL, 0x0000312014147816ULL, 0x002fc400000000ffULL,
0x0000312015157816ULL, 0x000fe200000000ffULL, 0x0000000d24248232ULL, 0x0a8fe20000000000ULL,
0x00000014ff1e723eULL, 0x080fe200020006ffULL, 0x0000000d26268232ULL, 0x000fe20000000000ULL,
0x00000015ff1f723eULL, 0x080fe200020006ffULL, 0x0000000e25258232ULL, 0x080fe20000000000ULL,
0x00000014ff14723eULL, 0x000fe200030006ffULL, 0x0000000e27278232ULL, 0x000fe20000000000ULL,
0x00000015ff15723eULL, 0x000fe400030006ffULL, 0x00003120160f7816ULL, 0x000fc400000000ffULL,
0x0000b8002b167811ULL, 0x000fe400078e20ffULL, 0x0000001e244c723cULL, 0x040fe20000001818ULL,
0x000031203c3c7816ULL, 0x010fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000312017197816ULL, 0x000fe200000000ffULL,
0x000000142454723cULL, 0x000fe20000001820ULL, 0x000000002c20783bULL, 0x000e620000004200ULL,
0x0000000fff18723eULL, 0x000fc400030006ffULL, 0x000031203f3f7816ULL, 0x000fe200000000ffULL,
0x000000002d2c783bULL, 0x000ee40000004200ULL, 0x0000000fff14723eULL, 0x000fe400020006ffULL,
0x00000019ff15723eULL, 0x080fe400020006ffULL, 0x00000019ff19723eULL, 0x000fca00030006ffULL,
0x000000142430723cULL, 0x040fe20000001830ULL, 0x000000001614783bULL, 0x000f2e0000000200ULL,
0x000000182428723cULL, 0x000fee0000001834ULL, 0x0000003cff18723eULL, 0x000fc400020006ffULL,
0x0000003dff19723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x000000182458723cULL, 0x044fe20000001838ULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x0000312022227816ULL, 0x000fe400000000ffULL, 0x0000003eff18723eULL, 0x080fe200020006ffULL,
0x0000003c2440723cULL, 0x000fe20000001840ULL, 0x0000003fff19723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fc400030006ffULL, 0x0000003fff3f723eULL, 0x000fe400030006ffULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000182418723cULL, 0x040fe20000001844ULL,
0x000031202c2c7816ULL, 0x008fe200000000ffULL, 0x0000000d14148232ULL, 0x090fe20000000000ULL,
0x000031202d2d7816ULL, 0x000fe200000000ffULL, 0x0000000d16168232ULL, 0x000fe20000000000ULL,
0x000031202e2e7816ULL, 0x000fe200000000ffULL, 0x0000000e15158232ULL, 0x080fe20000000000ULL,
0x000031202f2f7816ULL, 0x000fe200000000ffULL, 0x0000003e2448723cULL, 0x000fe20000001848ULL,
0x00000020ff50723eULL, 0x000fe200020006ffULL, 0x0000000e17178232ULL, 0x000fe20000000000ULL,
0x00000021ff51723eULL, 0x000fc400020006ffULL, 0x00000022ff34723eULL, 0x000fe400020006ffULL,
0x00000023ff35723eULL, 0x000fe400020006ffULL, 0x0000002cff3c723eULL, 0x000fe200020006ffULL,
0x000000501450723cULL, 0x000fe2000000184cULL, 0x0000002dff3d723eULL, 0x000fe400020006ffULL,
0x0000002eff44723eULL, 0x000fe400020006ffULL, 0x0000002fff45723eULL, 0x000fc400020006ffULL,
0x00000020ff20723eULL, 0x000fe200030006ffULL, 0x000000341434723cULL, 0x040fe20000001830ULL,
0x00000021ff21723eULL, 0x000fe400030006ffULL, 0x00000022ff22723eULL, 0x000fe400030006ffULL,
0x00000023ff23723eULL, 0x000fe400030006ffULL, 0x0000002cff2c723eULL, 0x000fe200030006ffULL,
0x000000201454723cULL, 0x000fe20000001854ULL, 0x0000002dff2d723eULL, 0x000fc400030006ffULL,
0x0000002eff2e723eULL, 0x000fe400030006ffULL, 0x0000002fff2f723eULL, 0x000fc600030006ffULL,
0x000000221438723cULL, 0x040ff00000001828ULL, 0x0000003c143c723cULL, 0x040ff00000001858ULL,
0x0000002c1440723cULL, 0x040ff00000001840ULL, 0x000000441444723cULL, 0x040ff00000001818ULL,
0x0000002e1448723cULL, 0x000fe20000001848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff317224ULL, 0x002fc600078e000fULL, 0x0000030005057a10ULL, 0x000fc80007ffe0ffULL,
0x000000070500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff7be000007947ULL, 0x000fea000383ffffULL, 0x0000000000127919ULL, 0x000ee40000002500ULL,
0x000000071200720cULL, 0x008fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000000c007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e000cULL,
0x00009360001a7802ULL, 0x000fe40000000f00ULL, 0x00008b2000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000c00037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc8000000000cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ee8000c1e9900ULL,
0x0000000000077919ULL, 0x000f240000000000ULL, 0x00000002ff037819ULL, 0x010fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000005007220ULL, 0x008fca0000410000ULL,
0x00001f0300037589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000005003507220ULL, 0x048fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000005403547220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000003c033c7220ULL, 0x040fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000004003407220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x0000004403447220ULL, 0x040fe20000410000ULL, 0x0000004503457220ULL, 0x040fe20000410000ULL,
0x0000004803487220ULL, 0x040fe20000410000ULL, 0x0000004903497220ULL, 0x000fe20000410000ULL,
0x0000005207527220ULL, 0x050fe20000410000ULL, 0x0000005307537220ULL, 0x040fe20000410000ULL,
0x0000005607567220ULL, 0x040fe20000410000ULL, 0x0000005707577220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x040fe20000410000ULL,
0x0000003a073a7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x040fe20000410000ULL,
0x0000003e073e7220ULL, 0x040fe20000410000ULL, 0x0000003f073f7220ULL, 0x040fe20000410000ULL,
0x0000004207427220ULL, 0x040fe20000410000ULL, 0x0000004307437220ULL, 0x040fe20000410000ULL,
0x0000004607467220ULL, 0x040fe20000410000ULL, 0x0000004707477220ULL, 0x040fe20000410000ULL,
0x0000004a074a7220ULL, 0x040fe20000410000ULL, 0x0000004b074b7220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x00000300ff207624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000012000780cULL, 0x000fe40003f05270ULL,
0x0000000203007812ULL, 0x008fe400078ec0ffULL, 0x00000002ff137819ULL, 0x000fe40000011603ULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000000200057811ULL, 0x000fc400078ff8ffULL,
0x0000000400087811ULL, 0x040fe400078ff8ffULL, 0x00000006000e7811ULL, 0x002fe400078ff8ffULL,
0x00000008031b7811ULL, 0x000fe400078ff0ffULL, 0x0000000704007812ULL, 0x100fe400078e7813ULL,
0x00000007080a7812ULL, 0x040fe400078e7813ULL, 0x0000000708087812ULL, 0x100fe200078e781bULL,
0x0000000813077824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e781bULL,
0x0000080002007824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x100fe200078e7813ULL,
0x000000081b197824ULL, 0x040fe200078e0208ULL, 0x000000070e107812ULL, 0x040fe200078e7813ULL,
0x000000081b157824ULL, 0x000fe200078e0204ULL, 0x0000000705057812ULL, 0x100fe200078e781bULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fe200078e781bULL,
0x00000008130d7824ULL, 0x040fe200078e0206ULL, 0x0000a00000047810ULL, 0x000fe20007ffe0ffULL,
0x00000008130f7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x000000081b177824ULL, 0x000fe200078e0205ULL, 0x000000505105723eULL, 0x000fe200000000ffULL,
0x0000000813137824ULL, 0x000fe200078e0210ULL, 0x000000545506723eULL, 0x000fe200000000ffULL,
0x000000081b1b7824ULL, 0x000fe200078e020eULL, 0x00000052530a723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x00005410051c7816ULL, 0x000fe20000000006ULL,
0x000000100d0d7824ULL, 0x000fe200078e0204ULL, 0x00007632051d7816ULL, 0x000fe20000000006ULL,
0x000000100f117824ULL, 0x100fe200078e0204ULL, 0x0000003c3d05723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x100fe200078e0204ULL, 0x000000404106723eULL, 0x000fe200000000ffULL,
0x0000001017177824ULL, 0x000fc400078e0204ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x000000101b1b7824ULL, 0x000fe400078e0204ULL,
0x00000001070e7824ULL, 0x000fe200078e0208ULL, 0x000000343507723eULL, 0x000fe200000000ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x00000056570d723eULL, 0x000fe200000000ffULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x0000001c0e007388ULL, 0x0003e20000000a00ULL,
0x0000000108157824ULL, 0x000fc400078e0215ULL, 0x0000000108177824ULL, 0x040fe400078e0217ULL,
0x0000000108137824ULL, 0x040fe400078e0213ULL, 0x0000000108197824ULL, 0x040fe400078e0219ULL,
0x00000001081b7824ULL, 0x000fe200078e021bULL, 0x000000383908723eULL, 0x000fe400000000ffULL,
0x00005410050e7816ULL, 0x002fe40000000006ULL, 0x00005410071c7816ULL, 0x000fc40000000008ULL,
0x00007632071d7816ULL, 0x000fe40000000008ULL, 0x000000444507723eULL, 0x000fe400000000ffULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x0000001c0f007388ULL, 0x0003e40000000a00ULL,
0x00007632050f7816ULL, 0x002fe40000000006ULL, 0x000000363705723eULL, 0x000fe400000000ffULL,
0x0000003a3b06723eULL, 0x000fe200000000ffULL, 0x0000000e11007388ULL, 0x0003e40000000a00ULL,
0x00005410070e7816ULL, 0x002fc40000000008ULL, 0x00007632070f7816ULL, 0x000fe40000000008ULL,
0x0000003e3f07723eULL, 0x000fe400000000ffULL, 0x000000424308723eULL, 0x000fe200000000ffULL,
0x0000000e13007388ULL, 0x0003e40000000a00ULL, 0x000054100a0e7816ULL, 0x142fe4000000000dULL,
0x000076320a0f7816ULL, 0x000fe4000000000dULL, 0x00000046470a723eULL, 0x000fc400000000ffULL,
0x0000004a4b0d723eULL, 0x000fe200000000ffULL, 0x0000000e15007388ULL, 0x0003e40000000a00ULL,
0x00005410050e7816ULL, 0x142fe40000000006ULL, 0x00007632050f7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000e17007388ULL, 0x0003e80000000a00ULL, 0x0000000619007388ULL, 0x0007e20000000a00ULL,
0x000054100a0e7816ULL, 0x002fc4000000000dULL, 0x000076320a0f7816ULL, 0x000fca000000000dULL,
0x0000000e1b007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b5000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000002700ULL,
0x00000010030d7824ULL, 0x040fe200078e0200ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x0000580020057a24ULL, 0x000fe200078e02ffULL, 0x0000000000077919ULL, 0x008e620000002600ULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000002003157810ULL, 0x000fe20007ffe0ffULL,
0x0000660005087a24ULL, 0x000fe200078e02ffULL, 0x00a000000d187984ULL, 0x0007220000000c00ULL,
0x000000ff0300720cULL, 0x000fc60000725670ULL, 0x00a200000d1c7984ULL, 0x0006a20000000c00ULL,
0x00000fff08067811ULL, 0x040fe400078e40ffULL, 0x01ffffff08087812ULL, 0x000fe200078ec0ffULL,
0x000058000a0a7a24ULL, 0x002fc800078e0207ULL, 0x000003000a057a24ULL, 0x000fc800078e02ffULL,
0x0000000105077824ULL, 0x000fca00078e0212ULL, 0x00000007060e7211ULL, 0x000fca00078fa0ffULL,
0x00006c000e0e7625ULL, 0x000fcc00078e000fULL, 0x00000400020e7825ULL, 0x000fcc00078e000eULL,
0x0000001015147825ULL, 0x000fc800078e000eULL, 0x0000001003127825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff0e7819ULL, 0x01cfe20000011603ULL,
0x00000010030d7824ULL, 0x000fe400078e00ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c0e167812ULL, 0x000fe200078ec0ffULL, 0x0000000107107824ULL, 0x000fe200078e0208ULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c00070e7625ULL, 0x000fc800078e0011ULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000e160e7210ULL, 0x000fc80007b5e00dULL,
0x0000001016107210ULL, 0x000fe40007d9e00dULL, 0x0000000fff0f7210ULL, 0x000fe400017e64ffULL,
0x00000011ff117210ULL, 0x000fc600027ea4ffULL, 0x0000000b0e007986ULL, 0x0003e8000c101906ULL,
0x0000000c10007986ULL, 0x0003e4000c101906ULL, 0x0000001812007986ULL, 0x01c5e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c14007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x002fe200078e00ffULL, 0xffffffff20077810ULL, 0x000fc60007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000070a0a79a8ULL, 0x000ee400099ee1c6ULL,
0x000000070a00720cULL, 0x008fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000800000ULL, 0x0000000cff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x000ee40000000000ULL, 0x000000ff0700720cULL, 0x008fda0003f25270ULL,
0x0000279000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x00000001050c7810ULL, 0x002fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000c0a137812ULL, 0x004fe400078ec0ffULL, 0x0000007007117812ULL, 0x000fe200078ec0ffULL,
0x00006c00050a7625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000c130c7210ULL, 0x000fe40007b5e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x000000060c0e7981ULL, 0x000362000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe40003f06070ULL, 0x00000006050a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fe40007a3e011ULL,
0x00000007050c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e000fULL, 0x000000060a187981ULL, 0x000366000c1e1900ULL,
0x0000000c130c0210ULL, 0x000fc80007c7e011ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c0c0981ULL, 0x000368000c1e1900ULL, 0x00000007200a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0d7819ULL, 0x000fc8000001160aULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1a7224ULL, 0x004fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x020fe400078e0007ULL, 0x000000081a0f7824ULL, 0x040fe200078e00ffULL,
0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000000d1a00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1c7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000030f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000050f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000070f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000000c07077209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007a3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0a7824ULL, 0x000fca00078e020bULL,
0x000000070a007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000005060a7211ULL, 0x002fe200078fa0ffULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000400023b7824ULL, 0x000fe200078e00ffULL, 0x00000016ff3d7819ULL, 0x000fe20000011602ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000020030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x0000003b0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105108824ULL, 0x000fe200078e0208ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00000080ff128424ULL, 0x004fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000010b0b7824ULL, 0x000fe200008e063dULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x0000100002227824ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006c0010108625ULL, 0x000fe200078e0011ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001002178824ULL, 0x000fe200078e0203ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00006c0005128625ULL, 0x000fc600078e0012ULL, 0x0000458017178811ULL, 0x000fe200078e20ffULL,
0x0000000107197824ULL, 0x000fe400078e020cULL, 0x00000010021b8824ULL, 0x000fe400078e0203ULL,
0x0000001003157824ULL, 0x040fe400078e0222ULL, 0x00000010030c7825ULL, 0x100fe200078e000aULL,
0x000041801b1b8811ULL, 0x000fe200078e20ffULL, 0x0000000019197984ULL, 0x000e640000000800ULL,
0x000000100f0e7825ULL, 0x000fc400078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c157faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000001003108825ULL, 0x040fe400078e0010ULL, 0x003800000e157faeULL, 0x0007e4000b901c46ULL,
0x0000001003128825ULL, 0x000fe400078e0012ULL, 0x0000000010178faeULL, 0x0009e4000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x00000000121b8faeULL, 0x000be2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x010fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x020fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134367810ULL, 0x000fc80007ffe0ffULL, 0x0000030036007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000105357824ULL, 0x000fe200078e0236ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x00001000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000136217812ULL, 0x040fe200078ec0ffULL, 0x00000800361c7824ULL, 0x000fe200078e00ffULL,
0x00000035061a7211ULL, 0x000fe400078fa0ffULL, 0x0000002003397810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1f7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fc800078e001bULL,
0x00000001081d9824ULL, 0x000fe200078e0235ULL, 0x0000003b1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x0000000202209824ULL, 0x000fe400078e0221ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00006c001d1c9625ULL, 0x000fc800078e001eULL,
0x00000001221e7824ULL, 0x000fe400078e021fULL, 0x00000002023a9824ULL, 0x000fe400078e0221ULL,
0x000000011b1b7824ULL, 0x000fe400000e063dULL, 0x0000000820379824ULL, 0x000fe400078e0203ULL,
0x00006c0035209625ULL, 0x000fc600078e0038ULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001003357824ULL, 0x040fe400078e021eULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x00000010031e9825ULL, 0x000fc800078e001cULL, 0x00000010391c7825ULL, 0x000fe200078e001aULL,
0x000041803a399811ULL, 0x000fc600078e20ffULL, 0x00000010031a7825ULL, 0x000fc800078e001aULL,
0x0000001003209825ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001a357faeULL, 0x0005e8000b901c46ULL, 0x003800001c357faeULL, 0x0005e8000b901c46ULL,
0x000000001e379faeULL, 0x0005e8000b901c46ULL, 0x0000000020399faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1e7819ULL, 0x100fe20000011603ULL, 0x00000010031c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000801d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000835217824ULL, 0x040fe200078e00ffULL, 0x000000801a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008351f7824ULL, 0x040fe200078e00ffULL, 0x0000000735407812ULL, 0x000fe400078ec0ffULL,
0x00000035ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100021b7824ULL, 0x000fe200078e021bULL,
0xfffffff81f1a7812ULL, 0x000fe400078ee240ULL, 0xfffffff8213e7812ULL, 0x000fc400078ee23eULL,
0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL, 0x00000008351b7824ULL, 0x040fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c3c7984ULL, 0x000ea20000000800ULL, 0x000000011b1e7812ULL, 0x100fe200078ef640ULL,
0x00000008371f7824ULL, 0x000fe200078e00ffULL, 0x000000021b207812ULL, 0x140fe200078ef640ULL,
0x004580001c4e7984ULL, 0x0004e20000000800ULL, 0x000000031b347812ULL, 0x100fe200078ef640ULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x000000041b387812ULL, 0x140fe400078ef640ULL,
0x000000051b3a7812ULL, 0x000fe400078ef640ULL, 0x00000037ff4c7212ULL, 0x000fc800078e33ffULL,
0xfffffff81f4c7812ULL, 0x000fe400078ee24cULL, 0x00000007371f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c191c7221ULL, 0x006fe20000010100ULL, 0x000000061b3c7812ULL, 0x000fe200078ef640ULL,
0x000008001d1b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c217820ULL, 0x000fe20000410000ULL,
0x00000004031c7824ULL, 0x000fe400078e00ffULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000837407824ULL, 0x000fc400078e00ffULL, 0x0000000c1c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000002100217308ULL, 0x000ee20000000800ULL, 0x00000180221b7810ULL, 0x000fe40007ffe01bULL,
0xfffffff8421c7812ULL, 0x100fe400078ee21fULL, 0x0000000140427812ULL, 0x000fe200078ef61fULL,
0x000000101a1a7824ULL, 0x000fe200078e021bULL, 0x0000000240447812ULL, 0x000fe200078ef61fULL,
0x000000101e1e7824ULL, 0x000fe200078e021bULL, 0x0000000340467812ULL, 0x000fe200078ef61fULL,
0x000000011a1a7824ULL, 0x000fe200078e021dULL, 0x0000000440487812ULL, 0x140fe200078ef61fULL,
0x000000011d1e7824ULL, 0x000fe200078e021eULL, 0x00000005404a7812ULL, 0x000fe200078ef61fULL,
0x000000103e3e7824ULL, 0x000fe200078e021bULL, 0x0000000640407812ULL, 0x000fe200078ef61fULL,
0x000000001a1a7984ULL, 0x000e620000000800ULL, 0x0000001034347824ULL, 0x000fe200078e021bULL,
0x0000004e214e7220ULL, 0x008fe20000410000ULL, 0x000000011d3e7824ULL, 0x040fe200078e023eULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x000000011d347824ULL, 0x000fe200078e0234ULL,
0x000000334e337221ULL, 0x000fe20000010000ULL, 0x0000001020207824ULL, 0x100fe200078e021bULL,
0x00001f354e1f7589ULL, 0x000ea200000e0000ULL, 0x000000103a3a7824ULL, 0x000fc400078e021bULL,
0x000000011d207824ULL, 0x040fe200078e0220ULL, 0x000000003e3e7984ULL, 0x000ee20000000800ULL,
0x000000011d3a7824ULL, 0x040fe400078e023aULL, 0x0000001038387824ULL, 0x100fe200078e021bULL,
0x0000000034347984ULL, 0x000f220000000800ULL, 0x000000103c3c7824ULL, 0x000fe400078e021bULL,
0x000000011d387824ULL, 0x040fe200078e0238ULL, 0x0000000020207984ULL, 0x000f620000000800ULL,
0x000000011d3c7824ULL, 0x000fc400078e023cULL, 0x000000101c1c7824ULL, 0x100fe200078e021bULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x0000001042427824ULL, 0x100fe400078e021bULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x0000000038387984ULL, 0x000f620000000800ULL,
0x000000011d427824ULL, 0x000fe400078e0242ULL, 0x0000001044447824ULL, 0x100fe200078e021bULL,
0x000000003c3c7984ULL, 0x000f620000000800ULL, 0x0000001046467824ULL, 0x000fc400078e021bULL,
0x000000011d447824ULL, 0x040fe200078e0244ULL, 0x000000001c1c7984ULL, 0x000f620000000800ULL,
0x000000011d467824ULL, 0x040fe400078e0246ULL, 0x0000001048487824ULL, 0x100fe200078e021bULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x000000104a4a7824ULL, 0x000fe400078e021bULL,
0x000000011d487824ULL, 0x040fe200078e0248ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x000000011d4a7824ULL, 0x000fc400078e024aULL, 0x0000001040407824ULL, 0x100fe200078e021bULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x000000104c4c7824ULL, 0x000fe400078e021bULL,
0x2000001aff1b7230ULL, 0x002fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x000000011d407824ULL, 0x040fe400078e0240ULL, 0x000000011d4c7824ULL, 0x000fe200078e024cULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x0000001f1b327223ULL, 0x004fe20000010032ULL,
0x2000001eff1b7230ULL, 0x000fc40000004100ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x2000003eff1d7230ULL, 0x008fe40000004100ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x000000004c4c7984ULL, 0x000fe20000000800ULL, 0x20000034ff1b7230ULL, 0x010fe20000004100ULL,
0x0000001f1d247223ULL, 0x080fe20000010024ULL, 0x20000020ff1d7230ULL, 0x020fe20000004100ULL,
0x00001f374e4e7589ULL, 0x000e6200000e0000ULL, 0x30000034ff347230ULL, 0x000fe20000004100ULL,
0x0000001f1b2c7223ULL, 0x080fe2000001002cULL, 0x2000003aff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1d2e7223ULL, 0x080fe2000001002eULL, 0x20000038ff1d7230ULL, 0x000fe20000004100ULL,
0x0000001f342b7223ULL, 0x080fe2000001002bULL, 0x000000ffff347224ULL, 0x000fe200078e0036ULL,
0x0000001f1b287223ULL, 0x080fe20000010028ULL, 0x2000003cff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1d2a7223ULL, 0x080fe2000001002aULL, 0x2000001cff1d7230ULL, 0x000fe20000004100ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x3000001aff1a7230ULL, 0x000fe20000004100ULL,
0x0000001f1b267223ULL, 0x000fe20000010026ULL, 0x20000042ff1b7230ULL, 0x000fc40000004100ULL,
0x3000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000001f1a317223ULL, 0x080fe20000010031ULL,
0x3000001eff1e7230ULL, 0x000fe40000004100ULL, 0x30000020ff207230ULL, 0x000fe20000004100ULL,
0x0000001f3e237223ULL, 0x080fe20000010023ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000004e1d187223ULL, 0x082fe20000010018ULL, 0x0000004e1b167223ULL, 0x080fe20000010016ULL,
0x20000044ff1d7230ULL, 0x000fe20000004100ULL, 0x0000001f1e2f7223ULL, 0x080fe2000001002fULL,
0x20000046ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f202d7223ULL, 0x080fe2000001002dULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000004e1d147223ULL, 0x080fe20000010014ULL,
0x2000004aff1d7230ULL, 0x000fe20000004100ULL, 0x0000004e1b127223ULL, 0x080fe20000010012ULL,
0x20000048ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f38297223ULL, 0x080fe20000010029ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000004e1d0e7223ULL, 0x080fe2000001000eULL,
0x2000004cff1d7230ULL, 0x000fe20000004100ULL, 0x0000004e1b107223ULL, 0x080fe20000010010ULL,
0x20000040ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f3a277223ULL, 0x080fe20000010027ULL,
0x3000001cff1c7230ULL, 0x000fe20000004100ULL, 0x0000001f3c257223ULL, 0x000fe20000010025ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000004e1b0c7223ULL, 0x080fe2000001000cULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000004e1c177223ULL, 0x080fe20000010017ULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004e42157223ULL, 0x080fe20000010015ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000004e44137223ULL, 0x080fe20000010013ULL,
0x3000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000004e46117223ULL, 0x080fe20000010011ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000004e480f7223ULL, 0x080fe2000001000fULL,
0x3000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000004e4a0d7223ULL, 0x080fe2000001000dULL,
0x0000004e1d0a7223ULL, 0x080fe2000001000aULL, 0x0000004e400b7223ULL, 0x000fc4000001000bULL,
0x0000004e4c077223ULL, 0x000fe20000010007ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033027810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000002027812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000be00001a7802ULL, 0x000fe40000000f00ULL, 0x0000608000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300027308ULL, 0x000ea40000001000ULL, 0xbf80000002037423ULL, 0x004fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803417811ULL, 0x004fe400078ff0ffULL,
0x00000002ff337819ULL, 0x002fe40000011603ULL, 0x00000041ff437212ULL, 0x000fe200078e33ffULL,
0x00001f4102067589ULL, 0x000e6200000e0000ULL, 0x0000000841087824ULL, 0x000fc400078e00ffULL,
0x0000000833457824ULL, 0x000fe200078e00ffULL, 0x00001f3302057589ULL, 0x0004e400000e0000ULL,
0xfffffff808437812ULL, 0x000fca00078ee243ULL, 0x0000001043437824ULL, 0x000fe200078e0204ULL,
0x00000033ff027212ULL, 0x004fc800078e33ffULL, 0xfffffff845457812ULL, 0x000fe400078ee202ULL,
0x0000000733027812ULL, 0x040fe200078ec0ffULL, 0x0000001806187220ULL, 0x042fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x0000000c060c7220ULL, 0x040fe20000410000ULL,
0x0000000b060b7220ULL, 0x040fe20000410000ULL, 0x0000000a060a7220ULL, 0x040fe20000410000ULL,
0x0000000706077220ULL, 0x000fe20000410000ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000003205327220ULL, 0x008fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000003105317220ULL, 0x000fe20000410000ULL,
0x0000000a0707723eULL, 0x000fe200000000ffULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0xfffffff806197812ULL, 0x000fe200078ee233ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000000102067812ULL, 0x040fe200078e3cffULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000000202087812ULL, 0x040fe200078e3cffULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x00000004020c7812ULL, 0x040fe200078e3cffULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x00000005020e7812ULL, 0x040fe200078e3cffULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x000fe20000410000ULL,
0x0000000741127812ULL, 0x000fe200078ec0ffULL, 0x0000002305057220ULL, 0x000fe20000410000ULL,
0x00000008331b7824ULL, 0x000fe200078e0206ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x00000008331d7824ULL, 0x000fe200078e0208ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x00000008331f7824ULL, 0x040fe200078e020aULL, 0x0000000212067812ULL, 0x040fe200078e3cffULL,
0x0000000833217824ULL, 0x040fe200078e020cULL, 0x0000000312087812ULL, 0x040fe200078e3cffULL,
0x0000000833237824ULL, 0x040fe200078e020eULL, 0x00000004120a7812ULL, 0x040fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e0202ULL, 0x0000000112027812ULL, 0x040fe200078e3cffULL,
0x0000000841147824ULL, 0x000fe200078e00ffULL, 0x00000005120c7812ULL, 0x040fe200078e3cffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x00000006120e7812ULL, 0x000fe200078e3cffULL,
0x0000000841377824ULL, 0x040fe200078e0202ULL, 0xfffffff814357812ULL, 0x000fe200078ee241ULL,
0x0000000841397824ULL, 0x040fe200078e0206ULL, 0x0000000c101c7812ULL, 0x000fe200078ec0ffULL,
0x00000008413b7824ULL, 0x000fe200078e0208ULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x00000008413d7824ULL, 0x000fe200078e020aULL, 0x000000302f2f723eULL, 0x000fe200000000ffULL,
0x00000008413f7824ULL, 0x000fe200078e020cULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000000841417824ULL, 0x000fe200078e020eULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000001045067824ULL, 0x100fe200078e0204ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0204ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0204ULL, 0x000000240505723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0204ULL, 0x000000181717723eULL, 0x000fe200000000ffULL,
0x0000001035357824ULL, 0x000fe200078e0204ULL, 0x000000161515723eULL, 0x000fe200000000ffULL,
0x000000011c027824ULL, 0x000fc400078e0219ULL, 0x0000001021217824ULL, 0x100fe400078e0204ULL,
0x0000001023237824ULL, 0x100fe200078e0204ULL, 0x0000003102007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x100fe400078e0204ULL, 0x0000001037377824ULL, 0x100fe400078e0204ULL,
0x0000001039397824ULL, 0x100fe400078e0204ULL, 0x000000103b3b7824ULL, 0x000fc400078e0204ULL,
0x000000103d3d7824ULL, 0x100fe400078e0204ULL, 0x000000103f3f7824ULL, 0x100fe400078e0204ULL,
0x0000001041417824ULL, 0x000fe400078e0204ULL, 0x000000011c107824ULL, 0x040fe400078e0206ULL,
0x000000011c047824ULL, 0x040fe400078e021bULL, 0x000000011c067824ULL, 0x000fc400078e021dULL,
0x000000011c087824ULL, 0x040fe200078e021fULL, 0x0000002f04007388ULL, 0x0005e20000000800ULL,
0x000000011c0a7824ULL, 0x040fe400078e0221ULL, 0x000000011c0c7824ULL, 0x040fe200078e0223ULL,
0x0000002d06007388ULL, 0x0005e20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0233ULL,
0x000000011c127824ULL, 0x040fe200078e0235ULL, 0x0000002b08007388ULL, 0x0005e20000000800ULL,
0x000000011c147824ULL, 0x000fc400078e0237ULL, 0x000000011c027824ULL, 0x042fe200078e0239ULL,
0x000000290a007388ULL, 0x0005e20000000800ULL, 0x000000011c167824ULL, 0x040fe400078e023bULL,
0x000000011c187824ULL, 0x040fe200078e023dULL, 0x000000270c007388ULL, 0x0005e20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0243ULL, 0x000000011c1a7824ULL, 0x040fe200078e023fULL,
0x000000250e007388ULL, 0x0005e20000000800ULL, 0x000000011c1c7824ULL, 0x000fc600078e0241ULL,
0x0000000510007388ULL, 0x0005e80000000800ULL, 0x0000001712007388ULL, 0x0005e80000000800ULL,
0x0000001514007388ULL, 0x0005e80000000800ULL, 0x0000001302007388ULL, 0x0005e80000000800ULL,
0x0000001116007388ULL, 0x0005e80000000800ULL, 0x0000000f18007388ULL, 0x0005e80000000800ULL,
0x0000000d1a007388ULL, 0x0005e80000000800ULL, 0x0000000b1c007388ULL, 0x0005e80000000800ULL,
0x000000071e007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000020030b7810ULL, 0x006fe20007ffe0ffULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff067819ULL, 0x008fe2000001160bULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000702047812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fc400078e480bULL, 0x0ffffff804057812ULL, 0x000fe400078ef803ULL,
0x0ffffff807077812ULL, 0x000fe400078ef80bULL, 0x00000007030a7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000000070b007812ULL, 0x000fe400078ec0ffULL, 0x00a00000050c7984ULL, 0x000ee80000000c00ULL,
0x00a0000007107984ULL, 0x0009620000000c00ULL, 0x0000000808157824ULL, 0x002fc400078e00ffULL,
0x0000000808177824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0xfffffff815027812ULL, 0x000fe400078ee202ULL, 0xfffffff817067812ULL, 0x000fe400078ee206ULL,
0x0000000402087c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff80a077812ULL, 0x010fe200078ef809ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0008027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0006047a11ULL, 0x000fc400078248ffULL, 0x00005b0008037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0006057a11ULL, 0x000fe400008f4c05ULL, 0x1ffffff800097812ULL, 0x000fe200078ef809ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001009047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011602ULL,
0xffffffffff287424ULL, 0x000fc800078e00ffULL, 0x0000000205297824ULL, 0x000fca00078e0208ULL,
0x000000062900720cULL, 0x000fda0003f06070ULL, 0x000000020d0a8824ULL, 0x000fc800078e00ffULL,
0x000064000a0a8a24ULL, 0x000fc800078e0229ULL, 0x000060000a0a8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0e7624ULL, 0x000fe200078e00ffULL,
0x000000060a288981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0f7624ULL, 0x000fc600078e00ffULL,
0x01060000ff087f8cULL, 0x000e68000c80043fULL, 0x000000060e2c7981ULL, 0x000762000c1e9900ULL,
0x0000000105107810ULL, 0x040fe20007ffe0ffULL, 0x00000040022a7824ULL, 0x000fe400078e00ffULL,
0x00000080002b7824ULL, 0x000fe200078e00ffULL, 0x000000071000720cULL, 0x000fe20003f06070ULL,
0x0000010005117824ULL, 0x000fc400078e022aULL, 0x000000802d2d7824ULL, 0x000fc600078e00ffULL,
0x000000402b217812ULL, 0x000fe200078ef811ULL, 0x0000002d281e7224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011603ULL,
0x0000001104007217ULL, 0x000fe40007800000ULL, 0x000000081d177810ULL, 0x040fe20007ffe0ffULL,
0x000000011d0a7824ULL, 0x040fe200078e0221ULL, 0x000000101d197810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a11ULL, 0x000000181d1c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a1e157210ULL, 0x000fe20007f1e0ffULL, 0x00000001170a7824ULL, 0x100fe200078e0221ULL,
0x000000300c1f7812ULL, 0x000fe200078ec0ffULL, 0x00000001190b7824ULL, 0x000fe200078e0221ULL,
0x00000003ff127819ULL, 0x000fe20000011603ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005e0015167a11ULL, 0x000fc400078040ffULL, 0x0000000b1e117210ULL, 0x000fe40007f3e0ffULL,
0x00005f0015157a11ULL, 0x000fe200000f440eULL, 0x000000011c0e7824ULL, 0x000fe200078e0221ULL,
0x0000000a1e147210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0011107a11ULL, 0x000fe400078240ffULL, 0x0000000e1e0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e0014137a11ULL, 0x000fc400078040ffULL,
0x00005f0011117a11ULL, 0x000fe200008f440aULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x00005f0014147a11ULL, 0x000fe200000f440fULL, 0x00000004170f7824ULL, 0x000fe200078e00ffULL,
0x00005e000e187a11ULL, 0x000fe400078440ffULL, 0x000000161f0a7210ULL, 0x000fe40007f7e0ffULL,
0x0000000312127812ULL, 0x000fe400078e4803ULL, 0x000000001d00720cULL, 0x000fc40003f06070ULL,
0x00005f000e1a7a11ULL, 0x000fe200010f440bULL, 0x000000ffff0b7224ULL, 0x000fe200018e0615ULL,
0x00002000020c7811ULL, 0x000fe400078e68ffULL, 0xfffffffc0f0f7812ULL, 0x000fe400078ee212ULL,
0x0ffffffc12037812ULL, 0x000fe400078ef803ULL, 0x000000001700720cULL, 0x080fe40003f26070ULL,
0x000000001900720cULL, 0x040fe20003f46070ULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x0000001f130e7210ULL, 0x080fe20007f7e0ffULL, 0x000000100f137824ULL, 0x100fe200078e020cULL,
0x000000201d177810ULL, 0x000fe20007ffe0ffULL, 0x0000001003037824ULL, 0x000fe200078e020cULL,
0xfffffffc19157812ULL, 0x000fe200078ee212ULL, 0x000000ffff0f7224ULL, 0x000fe200018e0614ULL,
0x0000001f10107210ULL, 0x000fe20007f9e0ffULL, 0x0000000121147824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000c101c46ULL,
0x0000001015157824ULL, 0x000fe200078e020cULL, 0x000000281d197810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0611ULL, 0x000000141e147210ULL, 0x000fe20007f1e0ffULL,
0x000000000e137faeULL, 0x0005e2000c901c46ULL, 0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000010157faeULL, 0x0007e2000d101c46ULL,
0x000000001c00720cULL, 0x0c0fe20003f86070ULL, 0x000000ffff0b7224ULL, 0x002fe200000e06ffULL,
0x000000001700720cULL, 0x080fe20003f66070ULL, 0x000000041c037824ULL, 0x000fe200078e00ffULL,
0x000000001900720cULL, 0x080fe40003f46070ULL, 0x000000001b00720cULL, 0x080fe20003f26070ULL,
0x00000001210f7824ULL, 0x004fe200078e021dULL, 0x00005e0014167a11ULL, 0x000fe200078c40ffULL,
0x000000041b137824ULL, 0x000fe200078e00ffULL, 0x0000001f180a7210ULL, 0x000fe20007fbe0ffULL,
0x00000001210e7824ULL, 0x000fe200078e021bULL, 0x000000001d00720cULL, 0x000fe20003f06070ULL,
0x0000000121007824ULL, 0x000fe200078e0219ULL, 0x00005f0014187a11ULL, 0x000fe200030f440bULL,
0x000000ffff0b7224ULL, 0x000fe200028e061aULL, 0xfffffffc03037812ULL, 0x100fe200078ee212ULL,
0x0000000419117824ULL, 0x008fe200078e00ffULL, 0x000000001e107210ULL, 0x040fe20007fbe0ffULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000f1e007210ULL, 0x000fe20007fde0ffULL,
0x00000004170f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc13137812ULL, 0x000fe200078ee212ULL,
0x0000001003037824ULL, 0x000fe200078e020cULL, 0xfffffffc11117812ULL, 0x000fc400078ee212ULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee212ULL, 0x0000001013177824ULL, 0x100fe200078e020cULL,
0x000000000a037faeULL, 0x0003e2000e101c46ULL, 0x0000000e1e147210ULL, 0x000fe20007f9e0ffULL,
0x0000001011157824ULL, 0x000fc800078e020cULL, 0x000000ffff117224ULL, 0x000fe400020e06ffULL,
0x000000100f037824ULL, 0x002fe200078e020cULL, 0xfffffffc1d0b7812ULL, 0x000fe200078ee212ULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0x00005e00100e7a11ULL, 0x000fc600078a40ffULL,
0x000000100b197824ULL, 0x000fe200078e020cULL, 0x00005f0010137a11ULL, 0x000fe200028f440fULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000001f160a7210ULL, 0x080fe40007fbe0ffULL,
0x00005e0014107a11ULL, 0x000fe400078840ffULL, 0x00005e0000127a11ULL, 0x000fe200078c40ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e0618ULL, 0x0000001f0e0e7210ULL, 0x000fe40007fbe0ffULL,
0x00005f00140c7a11ULL, 0x000fc400020f4411ULL, 0x00005f0000007a11ULL, 0x000fe200030f440fULL,
0x000000ffff0f7224ULL, 0x000fe200028e0613ULL, 0x0000001f10107210ULL, 0x080fe20007f9e0ffULL,
0x000000000a037faeULL, 0x0003e2000d901c46ULL, 0x0000001f12127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e060cULL, 0x000000000e157faeULL, 0x0003e2000d101c46ULL,
0x000000ffff137224ULL, 0x000fc600028e0600ULL, 0x0000000010177faeULL, 0x0003e8000c901c46ULL,
0x0000000012197faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000002103007211ULL, 0x04afe400078ff0ffULL, 0x00000010030a7811ULL, 0x040fe400078ff0ffULL,
0x000000001e007210ULL, 0x000fe40007f1e0ffULL, 0x0000002003107811ULL, 0x000fc400078ff0ffULL,
0x0000000803247811ULL, 0x000fe200078ff0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e0000197a11ULL, 0x000fe200078040ffULL, 0x0000000121117824ULL, 0x000fe200078e0210ULL,
0x00000018030e7811ULL, 0x000fe200078ff0ffULL, 0x00000004101d7824ULL, 0x000fe200078e00ffULL,
0x00005f0000227a11ULL, 0x000fe200000f440bULL, 0x00000001210b7824ULL, 0x000fe200078e020aULL,
0x0000002803127811ULL, 0x040fe200078ff0ffULL, 0x0000000124007824ULL, 0x000fe200078e0221ULL,
0x0000003003147811ULL, 0x000fe200078ff0ffULL, 0x00000001210f7824ULL, 0x000fe200078e020eULL,
0x0000003803167811ULL, 0x000fe200078ff0ffULL, 0x0000000121137824ULL, 0x040fe200078e0212ULL,
0x00000003ff1a7819ULL, 0x100fe20000011603ULL, 0x0000000121157824ULL, 0x040fe200078e0214ULL,
0x0000000b1e187210ULL, 0x000fe20007fbe0ffULL, 0x00000004240b7824ULL, 0x000fe200078e00ffULL,
0x000000111e1b7210ULL, 0x040fe20007f3e0ffULL, 0x0000000121177824ULL, 0x000fe200078e0216ULL,
0x000000001e207210ULL, 0x000fe20007fde0ffULL, 0x000000040e117824ULL, 0x000fe200078e00ffULL,
0x000000031a1a7812ULL, 0x100fe200078e4803ULL, 0x00000004121f7824ULL, 0x000fe200078e00ffULL,
0x0000000f1e1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000040a0f7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc1a127812ULL, 0x000fe200078ef803ULL, 0x0000000414217824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b007812ULL, 0x000fe200078ee21aULL, 0x000000ffff037224ULL, 0x000fe200030e06ffULL,
0x000000131e137210ULL, 0x000fe20007f5e0ffULL, 0x0000000416237824ULL, 0x000fe200078e00ffULL,
0x000000151e157210ULL, 0x000fc40007f7e0ffULL, 0x000000171e177210ULL, 0x000fe40007f9e0ffULL,
0x0000200002277811ULL, 0x000fe400078e68ffULL, 0xfffffffc110b7812ULL, 0x100fe400078ee21aULL,
0x00005e00201e7a11ULL, 0x000fe200078c40ffULL, 0x0000001012317824ULL, 0x100fe200078e0227ULL,
0xfffffffc0f0a7812ULL, 0x100fe400078ee21aULL, 0xfffffffc1f0f7812ULL, 0x100fe200078ee21aULL,
0x000000100b1f7824ULL, 0x000fe200078e0227ULL, 0xfffffffc21107812ULL, 0x100fe200078ee21aULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f4403ULL,
0x0000001000037824ULL, 0x100fe200078e0227ULL, 0xfffffffc1d0e7812ULL, 0x100fe200078ee21aULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0xfffffffc23117812ULL, 0x000fe200078ee21aULL,
0x000000100f237824ULL, 0x100fe200078e0227ULL, 0x00005e001c127a11ULL, 0x000fe200078040ffULL,
0x0000001010257824ULL, 0x100fe200078e0227ULL, 0x00005e001b147a11ULL, 0x040fe200078240ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0x000000300c2f7812ULL, 0x000fe200078ec0ffULL,
0x000000100a1d7824ULL, 0x100fe200078e0227ULL, 0x00005e0018107a11ULL, 0x000fe200078a40ffULL,
0x000000100e217824ULL, 0x000fe200078e0227ULL, 0x00005f001c1c7a11ULL, 0x000fe200000f440bULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4400ULL,
0x0000001011277824ULL, 0x000fe200078e0227ULL, 0x000000192f0a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005e0013167a11ULL, 0x000fe200078240ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005f0018117a11ULL, 0x000fe200028f440fULL,
0x000000ffff0b7224ULL, 0x000fe200000e0622ULL, 0x00005e0015187a11ULL, 0x000fc400078440ffULL,
0x00005e00171a7a11ULL, 0x000fe400078640ffULL, 0x00005f0013197a11ULL, 0x000fe200008f440eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a317faeULL, 0x0003e2000b901c46ULL,
0x0000001e2f0e7210ULL, 0x000fe40007f1e0ffULL, 0x00005f00150c7a11ULL, 0x000fe400010f440cULL,
0x000000102f107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0620ULL,
0x00005f0017007a11ULL, 0x000fc400018f4400ULL, 0x000000122f127210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000142f147210ULL, 0x040fe20007f7e0ffULL,
0x000000000e037faeULL, 0x0003e2000b901c46ULL, 0x000000162f167210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e061cULL, 0x000000182f187210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200018e061bULL, 0x0000001a2f1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0619ULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc400028e060cULL, 0x000000ffff1b7224ULL, 0x000fe200000e0600ULL,
0x00000000121f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e8000b901c46ULL,
0x000000001a277faeULL, 0x0003e4000b901c46ULL, 0x01060400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc60007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0203ULL,
0x0000002000087824ULL, 0x000fe200078e00ffULL, 0x00000003ff037819ULL, 0x000fc80000011600ULL,
0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL, 0x000001e008087812ULL, 0x000fe400078ec0ffULL,
0x00000001030b7812ULL, 0x040fe400078efcffULL, 0x0000000703097812ULL, 0x100fe400078e7800ULL,
0x000000070b0b7812ULL, 0x100fe400078e7800ULL, 0x00000010030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108097824ULL, 0x040fe200078e0209ULL, 0x0000001103037810ULL, 0x000fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x000000070f0f7812ULL, 0x000fc400078e7800ULL,
0x0000000009147984ULL, 0x000e62000000cc00ULL, 0x0000000703037812ULL, 0x000fe400078e7800ULL,
0x00000001080f7824ULL, 0x040fe200078e020fULL, 0x000000000b107984ULL, 0x000ea4000000cc00ULL,
0x0000000108037824ULL, 0x000fe400078e0203ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0017ULL, 0x0000001809007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fca00078e0013ULL,
0x0000001c0b007388ULL, 0x000fe8000000cc00ULL, 0x0000000003107984ULL, 0x000e68000000cc00ULL,
0x000000000f147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x004fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x000000200f007388ULL, 0x0003e8000000cc00ULL, 0x0000001003007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff087f8cULL, 0x000fe8000c80043fULL,
0x01060400ff037984ULL, 0x002e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x01060400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3d8000002c2c7820ULL, 0x020fe20000410000ULL,
0x000064000d2e7a24ULL, 0x000fe200078e02ffULL, 0x00010688022f7811ULL, 0x040fe200078e18ffULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0xffffffff07307810ULL, 0x000fe40007ffe0ffULL,
0x0001060802317811ULL, 0x000fe400078e28ffULL, 0x0000010005357824ULL, 0x008fe200078e022aULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000350400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x034fea0003800000ULL, 0x000000ffff377224ULL, 0x000fe200078e0033ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000100347810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x0000002d28477224ULL, 0x020fc400078e02ffULL,
0x00000002ff327819ULL, 0x000fe40000011634ULL, 0x000000043400780cULL, 0x040fe40003f06070ULL,
0x0000000334547812ULL, 0x000fe200078ec0ffULL, 0x0000030032337a24ULL, 0x000fe400078e0205ULL,
0x000000ffff327224ULL, 0x000fe400078e0000ULL, 0x00000100333f7824ULL, 0x040fe200078e022aULL,
0x0000000133367810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fe200078e0034ULL,
0x0000000137337812ULL, 0x000fc400078e0cffULL, 0x000000073600720cULL, 0x000fe40003f26070ULL,
0x000000403f367812ULL, 0x000fca00078ec0ffULL, 0x000000012b447824ULL, 0x000fcc00078e0236ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff417819ULL, 0x002fc80000011603ULL,
0x0000000841497810ULL, 0x040fe20007ffe0ffULL, 0x0000000141347824ULL, 0x140fe200078e0244ULL,
0x00000010414f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001841517810ULL, 0x000fe20007ffe0ffULL,
0x0000000149367824ULL, 0x100fe200078e0244ULL, 0x0000003447397210ULL, 0x000fe20007f3e0ffULL,
0x000000014f387824ULL, 0x000fe200078e0244ULL, 0x0000003f04347217ULL, 0x000fe20007800000ULL,
0x00000004494d7824ULL, 0x000fe200078e00ffULL, 0x00000036473b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x0000003847367210ULL, 0x000fe20007f7e0ffULL,
0x0000000134347824ULL, 0x000fe200078e0a3fULL, 0x00005e0039387a11ULL, 0x000fe200078240ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x0000002841557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e00363c7a11ULL, 0x000fc400078640ffULL,
0x0000003041577810ULL, 0x000fe20007ffe0ffULL, 0x00000001553f7824ULL, 0x100fe200078e0244ULL,
0x00005f00363d7a11ULL, 0x000fe200018f443dULL, 0x0000000151367824ULL, 0x000fe200078e0244ULL,
0x00005e003b3a7a11ULL, 0x000fe400078440ffULL, 0x0000002041537810ULL, 0x040fe40007ffe0ffULL,
0x0000003841597810ULL, 0x000fe40007ffe0ffULL, 0x00005f0039397a11ULL, 0x000fe200008f4440ULL,
0x0000000157407824ULL, 0x000fe200078e0244ULL, 0x00005f003b3b7a11ULL, 0x000fe200010f443eULL,
0x00000001533e7824ULL, 0x100fe200078e0244ULL, 0x0000003647427210ULL, 0x000fe20007f3e0ffULL,
0x0000000159367824ULL, 0x000fe200078e0244ULL, 0x000000344100720cULL, 0x000fe20003f46070ULL,
0x0000000454447824ULL, 0x000fe200078e00ffULL, 0x0000003f47437210ULL, 0x040fe20007fde0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x0000004047457210ULL, 0x000fc40007f9e0ffULL,
0x0000003e47417210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x00000003ff407819ULL, 0x000fe20000011603ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e00423e7a11ULL, 0x000fe400078240ffULL, 0x0000003647477210ULL, 0x000fe20007f7e0ffULL,
0x0000000202367824ULL, 0x000fe200078e0233ULL, 0x00000003404e7812ULL, 0x000fe400078e4803ULL,
0x00005f00423f7a11ULL, 0x000fe200008f443fULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0x000000344900720cULL, 0x000fe20003f26070ULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x0000200036367811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4e4b7812ULL, 0x100fe400078ef803ULL,
0xfffffffc44497812ULL, 0x000fe400078ee203ULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee24eULL,
0x000000104b4b7824ULL, 0x000fe200078e0236ULL, 0x00005e0041407a11ULL, 0x000fe200078a40ffULL,
0x0000001049387825ULL, 0x000fe200078e0038ULL, 0x00005e0045447a11ULL, 0x000fe400078640ffULL,
0x00005f0041417a11ULL, 0x000fe200028f4442ULL, 0x000000104d4d7824ULL, 0x000fe200078e0236ULL,
0x00005e0047467a11ULL, 0x000fe200078840ffULL, 0x00000010493a7825ULL, 0x000fe200078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000384b7faeULL, 0x0003e2000d101c46ULL,
0x00005e0043427a11ULL, 0x000fc400078a40ffULL, 0x00005f0045457a11ULL, 0x000fe200018f444aULL,
0x000000003a4d7faeULL, 0x0005e2000c901c46ULL, 0x000000344f00720cULL, 0x0c0fe20003f26070ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x000000345100720cULL, 0x0c0fe20003f46070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x00005f0047477a11ULL, 0x000fe400020f4448ULL,
0x000000345300720cULL, 0x0c0fe20003f66070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x00005f0043437a11ULL, 0x000fe200028f444cULL, 0x0000001049387825ULL, 0x002fe200078e003cULL,
0x000000345500720cULL, 0x000fc40003f86070ULL, 0x000000345700720cULL, 0x080fe20003fa6070ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0x000000345900720cULL, 0x000fe20003fc6070ULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f4b7812ULL, 0x100fe200078ee24eULL,
0x0000000459597824ULL, 0x000fe200078e00ffULL, 0xfffffffc514d7812ULL, 0x004fe200078ee24eULL,
0x00000010493a7825ULL, 0x000fe200078e003eULL, 0xfffffffc534f7812ULL, 0x100fe400078ee24eULL,
0xfffffffc55517812ULL, 0x000fe200078ee24eULL, 0x000000104b4b7824ULL, 0x000fe200078e0236ULL,
0xfffffffc57537812ULL, 0x000fe200078ee24eULL, 0x000000104d4d7824ULL, 0x000fe200078e0236ULL,
0xfffffffc59557812ULL, 0x000fe200078ee24eULL, 0x000000104f4f7824ULL, 0x000fe200078e0236ULL,
0x00000000384b7faeULL, 0x0003e2000c901c46ULL, 0x00000010493c7825ULL, 0x000fc600078e0040ULL,
0x000000003a4d7faeULL, 0x0003e2000d101c46ULL, 0x0000001051517824ULL, 0x000fe400078e0236ULL,
0x00000010493e7825ULL, 0x000fe200078e0042ULL, 0x000000003c4f7faeULL, 0x0003e6000d901c46ULL,
0x0000001053537824ULL, 0x000fe200078e0236ULL, 0x000000003e517faeULL, 0x0003e2000e101c46ULL,
0x0000001049407825ULL, 0x000fc800078e0044ULL, 0x0000001055557824ULL, 0x000fe200078e0236ULL,
0x0000000040537faeULL, 0x0003e2000e901c46ULL, 0x0000001049427825ULL, 0x000fca00078e0046ULL,
0x0000000042557faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008033d7811ULL, 0x042fe400078ff0ffULL, 0x0000004403347211ULL, 0x040fe400078ff0ffULL,
0x00000010033f7811ULL, 0x000fe200078ff0ffULL, 0x000000013d367824ULL, 0x000fe200078e0244ULL,
0x0000003447347210ULL, 0x000fe20007f3e0ffULL, 0x000000043d4d7824ULL, 0x000fe200078e00ffULL,
0x0000001803417811ULL, 0x000fe200078ff0ffULL, 0x000000043f4f7824ULL, 0x000fe200078e00ffULL,
0x0000003647367210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x00005e0034387a11ULL, 0x000fc400078240ffULL, 0x0000002003437811ULL, 0x000fe200078ff0ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x00005e00363a7a11ULL, 0x000fe400078440ffULL,
0x00005f0034397a11ULL, 0x000fe200008f4439ULL, 0x00000001433c7824ULL, 0x040fe200078e0244ULL,
0x00000003ff347819ULL, 0x000fe20000011603ULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0x00005f00363b7a11ULL, 0x000fe200010f443bULL, 0x0000000202367824ULL, 0x000fe200078e0233ULL,
0x0000002803457811ULL, 0x000fc400078ff0ffULL, 0x0000003003497811ULL, 0x040fe400078ff0ffULL,
0x00000038034b7811ULL, 0x000fe200078ff0ffULL, 0x00000001453d7824ULL, 0x100fe200078e0244ULL,
0x0000000334407812ULL, 0x100fe200078e4803ULL, 0x000000013f347824ULL, 0x100fe200078e0244ULL,
0x0000200036557811ULL, 0x000fe200078e60ffULL, 0x0000000141367824ULL, 0x000fe200078e0244ULL,
0xfffffffc4d467812ULL, 0x000fe200078ee240ULL, 0x00000001493e7824ULL, 0x100fe200078e0244ULL,
0x0000003447427210ULL, 0x000fe20007f7e0ffULL, 0x000000014b3f7824ULL, 0x000fe200078e0244ULL,
0xfffffffc4f487812ULL, 0x100fe200078ee240ULL, 0x0000000441417824ULL, 0x000fe200078e00ffULL,
0xfffffffc434c7812ULL, 0x100fe200078ee240ULL, 0x0000000445457824ULL, 0x000fe200078e00ffULL,
0x0ffffffc40447812ULL, 0x000fe200078ef803ULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0xfffffffc414a7812ULL, 0x100fe200078ee240ULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc454e7812ULL, 0x100fe200078ee240ULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0xfffffffc49507812ULL, 0x100fe200078ee240ULL, 0x000000104a4d7824ULL, 0x100fe200078e0255ULL,
0xfffffffc4b527812ULL, 0x000fe200078ee240ULL, 0x00000010484b7824ULL, 0x100fe200078e0255ULL,
0x0000003647407210ULL, 0x040fe20007f5e0ffULL, 0x0000001044597824ULL, 0x100fe200078e0255ULL,
0x0000003c47417210ULL, 0x040fe20007f3e0ffULL, 0x0000001046497824ULL, 0x100fe200078e0255ULL,
0x00005e00423c7a11ULL, 0x000fe200078c40ffULL, 0x000000104c4f7824ULL, 0x000fe200078e0255ULL,
0x0000003d47437210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x0000003f47347210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0x0000003e47367210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005f00423d7a11ULL, 0x000fe200030f4445ULL, 0x0000000454427824ULL, 0x000fe200078e00ffULL,
0x00005e00403e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff457224ULL, 0x000fe200020e06ffULL,
0x00005e0036447a11ULL, 0x000fe200078640ffULL, 0x000000ffff477224ULL, 0x000fe200028e06ffULL,
0x00005f00403f7a11ULL, 0x000fe200010f443fULL, 0x000000104e517824ULL, 0x000fe200078e0255ULL,
0xfffffffc42577812ULL, 0x000fe200078ee203ULL, 0x0000001050537824ULL, 0x100fe200078e0255ULL,
0x00005e0041407a11ULL, 0x000fe200078240ffULL, 0x0000001052557824ULL, 0x000fe200078e0255ULL,
0x00005e0043427a11ULL, 0x000fe200078440ffULL, 0x0000001057387825ULL, 0x000fe200078e0038ULL,
0x00005e0034467a11ULL, 0x000fc400078840ffULL, 0x00005f0041417a11ULL, 0x000fe200008f444aULL,
0x00000010573a7825ULL, 0x000fe200078e003aULL, 0x00005f0043437a11ULL, 0x000fe200010f4448ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038597faeULL, 0x0003e2000b901c46ULL,
0x00005f0036457a11ULL, 0x000fe200018f4445ULL, 0x00000010573c7825ULL, 0x040fe200078e003cULL,
0x00005f0034477a11ULL, 0x000fe200020f4447ULL, 0x000000003a497faeULL, 0x0003e4000b901c46ULL,
0x00000010573e7825ULL, 0x040fe400078e003eULL, 0x000000003c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000001057407825ULL, 0x000fc400078e0040ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001057427825ULL, 0x040fe400078e0042ULL, 0x00000000404f7faeULL, 0x0003e4000b901c46ULL,
0x0000001057447825ULL, 0x040fe400078e0044ULL, 0x0000000042517faeULL, 0x0003e4000b901c46ULL,
0x0000001057467825ULL, 0x000fc400078e0046ULL, 0x0000000044537faeULL, 0x0003e8000b901c46ULL,
0x0000000046557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035400780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff287624ULL, 0x000fc800078e00ffULL,
0x0000000228297824ULL, 0x000fe400078e0229ULL, 0xffffffffff287424ULL, 0x000fc600078e00ffULL,
0x000000062900720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000022e387824ULL, 0x002fe400078e0229ULL, 0x00000004ff397424ULL, 0x000fc800078e00ffULL,
0x0000600038387625ULL, 0x000fca00078e0039ULL, 0x0000000638287981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003367810ULL, 0x040fe20007ffe0ffULL, 0x0000000202387824ULL, 0x002fe200078e0237ULL,
0xfffffff803347812ULL, 0x040fe200078ec0ffULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe400078ec0ffULL, 0x0000000734447812ULL, 0x100fe200078ef803ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x0000000736467812ULL, 0x000fe400078ef803ULL,
0x00000007033a7812ULL, 0x000fc400078ec0ffULL, 0x00000001ff367819ULL, 0x000fe40000011644ULL,
0x00000001ff377819ULL, 0x000fe40000011646ULL, 0x0000200038547811ULL, 0x000fe400078e60ffULL,
0x000000083a557812ULL, 0x000fe400078ef803ULL, 0x0000000336457812ULL, 0x000fe400078ec0ffULL,
0x0000000337477812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003445377212ULL, 0x000fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003203367211ULL, 0x000fc400078fe0ffULL, 0x00000034473d7212ULL, 0x000fe200078e3cffULL,
0x0000000444387824ULL, 0x000fe200078e0237ULL, 0x0000000736377812ULL, 0x000fe400078e7855ULL,
0x00000001344c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001038407824ULL, 0x100fe200078e0254ULL,
0x0000000236367810ULL, 0x000fe20007ffe0ffULL, 0x0000002055377824ULL, 0x000fe200078e0237ULL,
0x0000000234347810ULL, 0x000fe20007ffe0ffULL, 0x00000004463d7824ULL, 0x000fe200078e023dULL,
0x0000000736367812ULL, 0x000fe200078e7855ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000001037377824ULL, 0x000fe200078e00ffULL, 0x000000043400780cULL, 0x000fe20003f25270ULL,
0x000000103d3d7824ULL, 0x000fe200078e0254ULL, 0x0000000432327810ULL, 0x000fe20007ffe0ffULL,
0x0000002055367824ULL, 0x000fe200078e0236ULL, 0x000000003738783bULL, 0x0004e60000000200ULL,
0x0000001036367824ULL, 0x000fe200078e00ffULL, 0x000000003d3c783bULL, 0x000f220000000200ULL,
0x0000004c45377212ULL, 0x004fca00078e3cffULL, 0x0000000444377824ULL, 0x000fc800078e0237ULL,
0x0000001037377824ULL, 0x000fca00078e0254ULL, 0x000000003750783bULL, 0x000ea20000000200ULL,
0x00000040ff48723eULL, 0x082fe400020006ffULL, 0x00000040ff49723eULL, 0x000fe400030006ffULL,
0x00000041ff4a723eULL, 0x080fe400020006ffULL, 0x00000041ff4b723eULL, 0x000fe400030006ffULL,
0x00000042ff40723eULL, 0x080fe200020006ffULL, 0x00000048381c723cULL, 0x008fe2000000181cULL,
0x00000042ff41723eULL, 0x000fc400030006ffULL, 0x00000043ff42723eULL, 0x080fe400020006ffULL,
0x00000043ff43723eULL, 0x000fc600030006ffULL, 0x0000004a3820723cULL, 0x040ff00000001820ULL,
0x000000423848723cULL, 0x040fee0000001808ULL, 0x0000004c470b7212ULL, 0x000fe200078e3cffULL,
0x000000403824723cULL, 0x000fe20000001824ULL, 0x000000003640783bULL, 0x000e620000000200ULL,
0x0000003cff08723eULL, 0x010fc400020006ffULL, 0x00000004460b7824ULL, 0x000fe200078e020bULL,
0x0000003cff09723eULL, 0x000fe400030006ffULL, 0x0000003dff3c723eULL, 0x080fe200020006ffULL,
0x000000100b0b7824ULL, 0x000fe200078e0254ULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x00000008380c723cULL, 0x040fe2000000180cULL, 0x000000000b4c783bULL, 0x000eec0000000200ULL,
0x0000003eff08723eULL, 0x080fe200020006ffULL, 0x0000003c3810723cULL, 0x000fe20000001810ULL,
0x0000003eff09723eULL, 0x000fe400030006ffULL, 0x0000003fff3e723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fc600030006ffULL, 0x000000083814723cULL, 0x040fee0000001814ULL,
0x00000050ff08723eULL, 0x084fe200020006ffULL, 0x0000003e3818723cULL, 0x000fe20000001818ULL,
0x00000050ff09723eULL, 0x000fe400030006ffULL, 0x00000051ff50723eULL, 0x000fc400020006ffULL,
0x00000051ff51723eULL, 0x000fc600030006ffULL, 0x00000008401c723cULL, 0x042fee000000181cULL,
0x00000052ff08723eULL, 0x000fe200020006ffULL, 0x000000504020723cULL, 0x000fe20000001820ULL,
0x0000004cff36723eULL, 0x088fe400020006ffULL, 0x0000004cff37723eULL, 0x000fc400030006ffULL,
0x00000052ff09723eULL, 0x000fe400030006ffULL, 0x0000004dff4c723eULL, 0x080fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe200030006ffULL, 0x00000036400c723cULL, 0x040fee000000180cULL,
0x0000004eff36723eULL, 0x080fe200020006ffULL, 0x000000084024723cULL, 0x000fe20000001824ULL,
0x0000004eff37723eULL, 0x000fc400030006ffULL, 0x0000004fff4e723eULL, 0x080fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400030006ffULL, 0x00000053ff08723eULL, 0x080fe200020006ffULL,
0x0000004c4010723cULL, 0x000fe20000001810ULL, 0x00000053ff09723eULL, 0x000fce00030006ffULL,
0x000000084008723cULL, 0x040ff00000001848ULL, 0x000000364014723cULL, 0x040ff00000001814ULL,
0x0000004e4018723cULL, 0x000fe20000001818ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff377224ULL, 0x000fe200078e0033ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffeb3000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002f367f8cULL, 0x000fe2000c80043fULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000222c387220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x000004002f397984ULL, 0x000e620000000800ULL, 0x0000001e2c327220ULL, 0x040fe20000410000ULL,
0x0000001f2c347220ULL, 0x040fe20000410000ULL, 0x000000192c227220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x040fe20000410000ULL,
0x000000152c1e7220ULL, 0x040fe20000410000ULL, 0x000000182c1f7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x040fe20000410000ULL,
0x0000000a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000000b2c3b7220ULL, 0x040fe20000410000ULL,
0x0000000e2c3c7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000082c087220ULL, 0x040fe20000410000ULL, 0x000000092c097220ULL, 0x040fe20000410000ULL,
0x0000000c2c0c7220ULL, 0x040fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x0000000f2c3d7220ULL, 0x040fe20000410000ULL, 0x000000102c007220ULL, 0x040fe20000410000ULL,
0x000000112c0a7220ULL, 0x040fe20000410000ULL, 0x000000122c3e7220ULL, 0x040fe20000410000ULL,
0x000000132c3f7220ULL, 0x040fe20000410000ULL, 0x000000142c0b7220ULL, 0x040fe20000410000ULL,
0x000000162c407220ULL, 0x040fe20000410000ULL, 0x000000172c417220ULL, 0x040fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001dULL, 0x0000001b2c437220ULL, 0x040fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001cULL, 0x0000001a2c427220ULL, 0x000fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0022ULL, 0x000000ffff117224ULL, 0x000fe400078e0021ULL,
0x000000ffff127224ULL, 0x000fe400078e0024ULL, 0x000000ffff137224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe200078e001eULL, 0x8000000039ff7812ULL, 0x002fe20007804837ULL,
0x000000ffff1c7224ULL, 0x000fe400078e001fULL, 0x000000ffff227224ULL, 0x000fc400078e0023ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0032ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0034ULL,
0x000000ffff217224ULL, 0x000fe400078e0038ULL, 0x000000ffff237224ULL, 0x000fe400078e0026ULL,
0x000000ffff247224ULL, 0x000fe400078e0027ULL, 0x000000ffff257224ULL, 0x000fc400078e003aULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff147224ULL, 0x000fe400078e0008ULL,
0x000000ffff157224ULL, 0x000fe400078e0009ULL, 0x000000ffff167224ULL, 0x000fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000dULL, 0x000000ffff187224ULL, 0x000fc400078e0000ULL,
0x000000ffff197224ULL, 0x000fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fe400078e000bULL,
0x000000ffff267224ULL, 0x000fe400078e003bULL, 0x000000ffff277224ULL, 0x000fe400078e003cULL,
0x000000ffff327224ULL, 0x000fe400078e003dULL, 0x000000ffff347224ULL, 0x000fc400078e003eULL,
0x000000ffff387224ULL, 0x000fe400078e003fULL, 0x000000ffff397224ULL, 0x000fe400078e0040ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0041ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0042ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0043ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000087305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000080000735dULL, 0x004fe20003800000ULL,
0x000004002f097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403207824ULL, 0x000fe200078e00ffULL,
0x000000300500720cULL, 0x000fc80003f05270ULL, 0xfffffff020097812ULL, 0x000fca00078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e0209ULL, 0x0104000000087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002030c7824ULL, 0x000fe400078e00ffULL,
0x0000000104357824ULL, 0x000fc600078e0a35ULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c367812ULL, 0x040fe400078efcffULL, 0x000000080c3e7812ULL, 0x000fe400078efcffULL,
0x000000353600720cULL, 0x080fe40003f26070ULL, 0x000000100c367812ULL, 0x000fe400078efcffULL,
0x000000353e00720cULL, 0x080fe40003f06070ULL, 0x000000353600720cULL, 0x000fc40003fc6070ULL,
0x000000110c3e7812ULL, 0x040fe400078efcffULL, 0x000000180c367812ULL, 0x040fe400078efcffULL,
0x000000350c00720cULL, 0x080fe40003f46070ULL, 0x000000353e00720cULL, 0x080fe40003fa6070ULL,
0x000000353600720cULL, 0x000fe40003f66070ULL, 0x000000090c407812ULL, 0x000fc400078efcffULL,
0x000000190c3e7812ULL, 0x040fe400078efcffULL, 0x000000200c367812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000354000720cULL, 0x080fe40003f86070ULL, 0x000000353e00720cULL, 0x080fe40003f46070ULL,
0x000000353600720cULL, 0x000fe40003f26070ULL, 0x000000210c3e7812ULL, 0x040fe400078efcffULL,
0x000000280c367812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff22227808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000353e00720cULL, 0x080fe40003f06070ULL,
0x000000353600720cULL, 0x000fe40003f86070ULL, 0x000000290c3e7812ULL, 0x000fc400078efcffULL,
0x000000300c367812ULL, 0x000fe400078efcffULL, 0xff7fffff23237808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000353e00720cULL, 0x000fc40003fc6070ULL,
0x000000353600720cULL, 0x000fe40003fa6070ULL, 0x000000310c3e7812ULL, 0x040fe400078efcffULL,
0x000000380c367812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff25257808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff26267808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000353e00720cULL, 0x080fe40003f66070ULL, 0x000000353600720cULL, 0x000fc40003f46070ULL,
0x000000350c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff32327808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff34347808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff38387808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff39397808ULL, 0x000fe40006800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL, 0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL, 0x0000000f080d7209ULL, 0x004fe20007810000ULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001e09087209ULL, 0x000fe20007810000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d7209ULL, 0x000fe40007810000ULL,
0x0000001f08087209ULL, 0x000fc40007810000ULL, 0x000000100d0c7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fe40007810000ULL, 0x000000110c0d7209ULL, 0x000fe40007810000ULL,
0x0000002209087209ULL, 0x000fe40007810000ULL, 0x000000120d0c7209ULL, 0x000fe40007810000ULL,
0x0000002308097209ULL, 0x000fc40007810000ULL, 0x000000130c0d7209ULL, 0x000fe40007810000ULL,
0x0000002409087209ULL, 0x000fe40007810000ULL, 0x000000140d0c7209ULL, 0x000fe40007810000ULL,
0x0000002508097209ULL, 0x000fe40007810000ULL, 0x000000150c0d7209ULL, 0x000fe40007810000ULL,
0x0000002609087209ULL, 0x000fc40007810000ULL, 0x000000160d0c7209ULL, 0x000fe40007810000ULL,
0x0000002708097209ULL, 0x000fe40007810000ULL, 0x000000170c0d7209ULL, 0x000fe40007810000ULL,
0x0000003209097209ULL, 0x000fe40007810000ULL, 0x000000180d087209ULL, 0x000fe40007810000ULL,
0x0000003409097209ULL, 0x000fc40007810000ULL, 0x00000019080d7209ULL, 0x000fe40007810000ULL,
0x0000003809087209ULL, 0x000fe40007810000ULL, 0x0000001a0d0c7209ULL, 0x000fe40007810000ULL,
0x0000003908097209ULL, 0x000fe40007810000ULL, 0x0000001b0c0d7209ULL, 0x000fe40007810000ULL,
0x0000003a09087209ULL, 0x000fc40007810000ULL, 0x0000001c0d0c7209ULL, 0x000fe40007810000ULL,
0x0000003b08097209ULL, 0x000fe40007810000ULL, 0x0000001d0c377209ULL, 0x000fe40007810000ULL,
0x0000003c093d7209ULL, 0x000fe20007810000ULL, 0x00001a727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037087f89ULL, 0x0004e400000e0000ULL, 0x0000000837377209ULL, 0x00cfe20007810000ULL,
0x00001aa27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003d087f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a097f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b367f89ULL, 0x000f2200000e0000ULL,
0x000000083d0c7209ULL, 0x004fc60007810000ULL, 0x0c201f0037087f89ULL, 0x000ea200000e0000ULL,
0x000000090a0d7209ULL, 0x008fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000ee200000e0000ULL,
0x000000360b367209ULL, 0x010fc60007810000ULL, 0x0c201f000d3e7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0036357f89ULL, 0x00092200000e0000ULL, 0x0000000837087209ULL, 0x004fe40007810000ULL,
0x000000090c097209ULL, 0x008fe40007810000ULL, 0x0000003e0d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x3c003c00ff3e7424ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff3f7424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1d0b7823ULL, 0x000fe2000001080bULL,
0x3fb8aa3b091d7820ULL, 0x000fe20000410000ULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081dULL,
0x0000000e000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001081dULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001081dULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001081dULL,
0x3fb8aa3b3c1d7823ULL, 0x000fc8000001081dULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000c0d0c723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000000ffULL,
0x00000021000f7308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001e1f0d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000000f220f723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003e0c40723cULL, 0x000fee00000018ffULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fce00000000ffULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ee20000000800ULL, 0x000000232411723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x008fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000003e1040723cULL, 0x000fee0000001840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ee20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x008fe200000000ffULL,
0x0000000fff197424ULL, 0x000fe200078e00ffULL, 0xfffffffc03187812ULL, 0x000fc800078ec0ffULL,
0x00000018195c7219ULL, 0x000fe200000006ffULL, 0x0000003400347308ULL, 0x000fe60000000800ULL,
0x000000005c0473c4ULL, 0x000eea0000004000ULL, 0x00000038001f7308ULL, 0x000f220000000800ULL,
0x000000273215723eULL, 0x002fce00000000ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000341f17723eULL, 0x010fce00000000ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000005c1f73a1ULL, 0x000f2200000e8000ULL, 0x0000003e1440723cULL, 0x000fec0000001840ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000000ffULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000055cff7c12ULL, 0x010fce000f80401fULL, 0x0000003a003a7308ULL, 0x000e620000000800ULL,
0x0000001c0b1a723eULL, 0x004fe400000000ffULL, 0x00000036350b7209ULL, 0x000fca0007810000ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000001d001e7308ULL, 0x000ea20000000800ULL,
0x000000393a19723eULL, 0x002fe400000000ffULL, 0x0000003b1e1b723eULL, 0x004fce00000000ffULL,
0x0000003e1840723cULL, 0x000fe20000001840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000015d204008947ULL, 0x008fde000b800000ULL, 0x001c1fff401c7589ULL, 0x0002a400000e0000ULL,
0x000000005c1d73a1ULL, 0x000ee200000e8000ULL, 0x000000005c0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000055cff7c12ULL, 0x008fda000f80401dULL,
0x000015e204008947ULL, 0x010fea000b800000ULL, 0x001c1fff421d7589ULL, 0x00072800000e0000ULL,
0x001c1fff011e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff217819ULL, 0x000fe40000011603ULL, 0x0000000c20437812ULL, 0x000fc400078ec0ffULL,
0x0000000721227812ULL, 0x040fe200078ec0ffULL, 0x0000000821277824ULL, 0x040fe200078e00ffULL,
0x00000021ff257212ULL, 0x000fe200078e33ffULL, 0x0000000821237824ULL, 0x000fe200078e00ffULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x00000008213c7824ULL, 0x040fe200078e00ffULL,
0x0000000821217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee222ULL,
0x0000000123267812ULL, 0x100fe200078ef622ULL, 0x00000008214c7824ULL, 0x000fe200078e00ffULL,
0x0000000223327812ULL, 0x100fe200078ef622ULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0x0000000323347812ULL, 0x000fc400078ef622ULL, 0x0000000423367812ULL, 0x140fe400078ef622ULL,
0x0000000523387812ULL, 0x140fe400078ef622ULL, 0x00000006233a7812ULL, 0x000fe200078ef622ULL,
0x0000000821237824ULL, 0x040fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee225ULL,
0x00000021ff257212ULL, 0x000fe400078e33ffULL, 0x0000000721227812ULL, 0x000fc400078ec0ffULL,
0x0000a00002217811ULL, 0x000fe400078e58ffULL, 0xfffffff8273e7812ULL, 0x100fe400078ee222ULL,
0x0000000123407812ULL, 0x142fe200078ef622ULL, 0x0000001024207824ULL, 0x000fe200078e0221ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee225ULL, 0x0000001032247824ULL, 0x100fe200078e0221ULL,
0x0000000223427812ULL, 0x148fe200078ef622ULL, 0x0000001036327824ULL, 0x100fe200078e0221ULL,
0x0000000323447812ULL, 0x140fe200078ef622ULL, 0x000000103a367824ULL, 0x100fe200078e0221ULL,
0x0000000423467812ULL, 0x140fe200078ef622ULL, 0x00000010403a7824ULL, 0x100fe200078e0221ULL,
0x0000000523487812ULL, 0x140fe200078ef622ULL, 0x00000010443d7824ULL, 0x100fe200078e0221ULL,
0x00000006234a7812ULL, 0x000fe200078ef622ULL, 0x0000001026227824ULL, 0x000fc400078e0221ULL,
0x0000001034267824ULL, 0x100fe400078e0221ULL, 0x0000001038347824ULL, 0x100fe400078e0221ULL,
0x0000000143237824ULL, 0x000fe400078e0220ULL, 0x000000103c387824ULL, 0x100fe400078e0221ULL,
0x000000103e207824ULL, 0x100fe200078e0221ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x00000010423c7824ULL, 0x000fc400078e0221ULL, 0x00000010463e7824ULL, 0x100fe400078e0221ULL,
0x00000010483f7824ULL, 0x100fe400078e0221ULL, 0x000000104a407824ULL, 0x100fe400078e0221ULL,
0x000000104c417824ULL, 0x000fe400078e0221ULL, 0x0000000143217824ULL, 0x040fe400078e0222ULL,
0x0000000143257824ULL, 0x000fc400078e0224ULL, 0x0000000143277824ULL, 0x040fe200078e0226ULL,
0x0000000e21007388ULL, 0x0007e20000000800ULL, 0x0000000143357824ULL, 0x040fe400078e0232ULL,
0x0000000143377824ULL, 0x040fe200078e0234ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x0000000143397824ULL, 0x040fe400078e0236ULL, 0x00000001433b7824ULL, 0x040fe200078e0238ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000143207824ULL, 0x000fc400078e0220ULL,
0x00000001433a7824ULL, 0x040fe200078e023aULL, 0x0000001435007388ULL, 0x0007e20000000800ULL,
0x00000001433c7824ULL, 0x040fe400078e023cULL, 0x00000001430c7824ULL, 0x042fe200078e023dULL,
0x0000001637007388ULL, 0x0007e20000000800ULL, 0x00000001433e7824ULL, 0x040fe400078e023eULL,
0x0000000143227824ULL, 0x040fe200078e023fULL, 0x0000001839007388ULL, 0x0007e20000000800ULL,
0x0000000143407824ULL, 0x000fc400078e0240ULL, 0x0000000143247824ULL, 0x000fe200078e0241ULL,
0x0000001a3b007388ULL, 0x0007e80000000800ULL, 0x0000000d20007388ULL, 0x0007e80000000800ULL,
0x0000000f3a007388ULL, 0x0007e80000000800ULL, 0x000000113c007388ULL, 0x0007e80000000800ULL,
0x000000130c007388ULL, 0x0007e80000000800ULL, 0x000000153e007388ULL, 0x0007e80000000800ULL,
0x0000001722007388ULL, 0x0007e80000000800ULL, 0x0000001940007388ULL, 0x0007e80000000800ULL,
0x0000001b24007388ULL, 0x0007e80000000800ULL, 0x0100000800008388ULL, 0x0007e80000000c00ULL,
0x0102001c00008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000031ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080031ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100031ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030005057a10ULL, 0x000fe20007ffe0ffULL, 0x0000180031ff7f8cULL, 0x0003e6000c80043fULL,
0x000000070500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffcf4000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff307807ULL, 0x004fe40004800000ULL, 0x00010ed0004d7802ULL, 0x000fe40000000f00ULL,
0x000011a000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e004cULL,
0xffff086000007947ULL, 0x000fea000383ffffULL, 0x00000001ff307807ULL, 0x000fe40004800000ULL,
0x00010f20004d7802ULL, 0x000fe40000000f00ULL, 0x0000115000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e004cULL, 0xffff089000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x00010f8000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000010b000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e005aULL, 0xffff08d000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x00010fe000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x01cfea0003c00000ULL,
0xffff08b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0060ULL,
0x0001104000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000ff000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e005aULL, 0xffff0c2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e001dULL, 0x000110b000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000f8000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e005aULL,
0xffff0be000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x0001111000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e005aULL,
0xffff1a0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e001dULL,
0x0001118000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000eb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e005aULL, 0xffff19b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x008fe40004800000ULL, 0x000111d0004d7802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e004cULL,
0xffff282000007947ULL, 0x000fea000383ffffULL, 0x00000001ff307807ULL, 0x000fe40004800000ULL,
0x00011220004d7802ULL, 0x000fe40000000f00ULL, 0x00000e5000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e004cULL, 0xffff285000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x002fe200078e00ffULL, 0x0001128000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000db000007944ULL, 0x034fea0003c00000ULL,
0xffff28b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e001dULL,
0x000112e000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x030fea0003c00000ULL,
0xffff297000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x0001133000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000d0000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e005aULL,
0xffff2bd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e001dULL,
0x000113a000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000c9000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e005aULL, 0xffff2b8000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x0001140000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fc400078e00ffULL, 0x00000c3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e005aULL, 0xffff37e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e001dULL, 0x0001147000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff627224ULL, 0x004fe200078e005aULL,
0xffff379000007947ULL, 0x000fea000383ffffULL, 0x00000001ff307807ULL, 0x008fe40004800000ULL,
0x000114c0004d7802ULL, 0x000fe40000000f00ULL, 0x00000bb000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e004cULL, 0xffff44a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe40004800000ULL, 0x00011510004d7802ULL, 0x000fe40000000f00ULL,
0x00000b6000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e004cULL,
0xffff44d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x002fe200078e00ffULL,
0x0001157000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x014fea0003c00000ULL, 0xffff453000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e001dULL, 0x000115d000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x00000a6000007944ULL, 0x010fea0003c00000ULL, 0xffff45f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x0001162000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x00000a1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e005aULL, 0xffff485000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x002fe200078e001dULL, 0x0001169000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000009a000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff627224ULL, 0x004fe200078e005aULL,
0xffff480000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x000116f000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fc400078e00ffULL,
0x0000094000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e005aULL,
0xffff543000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x006fe200078e001dULL,
0x0001176000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff627224ULL, 0x004fe200078e005aULL, 0xffff53e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x008fe40004800000ULL, 0x000117b0004d7802ULL, 0x000fe40000000f00ULL,
0x000008c000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e004cULL,
0xffff61d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff307807ULL, 0x000fe40004800000ULL,
0x00011800004d7802ULL, 0x000fe40000000f00ULL, 0x0000087000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff167224ULL, 0x000fe200078e004cULL, 0xffff620000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x004fe200078e00ffULL, 0x0001186000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000007d000007944ULL, 0x032fea0003c00000ULL,
0xffff626000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e001dULL,
0x000118c000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x0000077000007944ULL, 0x030fea0003c00000ULL,
0xffff632000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5d7424ULL, 0x000fe200078e00ffULL,
0x0001191000587802ULL, 0x000fe20000000f00ULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e005aULL,
0xffff658000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5e7224ULL, 0x002fe200078e001dULL,
0x0001198000587802ULL, 0x000fe20000000f00ULL, 0x0000001fff5d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5c7424ULL, 0x000fe400078e00ffULL, 0x000006b000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e005aULL, 0xffff653000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5d7424ULL, 0x000fe200078e00ffULL, 0x000119e000587802ULL, 0x000fe20000000f00ULL,
0xffffffffff5c7424ULL, 0x000fc400078e00ffULL, 0x0000065000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e005aULL, 0xffff71a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5e7224ULL, 0x006fe200078e001dULL, 0x00011a5000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff5d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5c7424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e005aULL,
0xffff715000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0037ULL,
0x00011ab0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000054000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0035ULL,
0xffffe54000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003dULL,
0x00011b10000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fe400078e00ffULL,
0x000004e000007944ULL, 0x020fea0003c00000ULL, 0x000000353d407209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e000aULL, 0x00011b60000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff3e7424ULL, 0x002fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000350a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e000bULL,
0x00011bb0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x000000350b367209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e0037ULL, 0x00011c00000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x0000003537087209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e0040ULL,
0x00011c50000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000003540097209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e000aULL, 0x00011ca0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x000000350a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e0036ULL,
0x00011cf0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0xffffe40000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0040ULL, 0x00011d5000587802ULL, 0x000fe20000000f00ULL,
0x000000ffff5e7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL,
0x000002e000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e005aULL,
0xffffe9d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e0042ULL,
0x00011dc000587802ULL, 0x000fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL, 0x0000027000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff5e7224ULL, 0x002fe200078e00ffULL, 0x00011e1000587802ULL, 0x000fe20000000f00ULL,
0x00001c1fff5d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x004fe400078e005aULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff5e7224ULL, 0x002fe200078e00ffULL,
0x00011e6000587802ULL, 0x000fe20000000f00ULL, 0x00001c1fff5d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e005aULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e005aULL, 0xffffe94000007947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003300038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000306ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000033057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003300037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff1b7424ULL, 0x000fc800078e00ffULL,
0xfffee0101a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003e35357389ULL, 0x0002a200000e003fULL,
0xfffedfd00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff597424ULL, 0x000fe200078e00ffULL,
0x0000005c00007348ULL, 0x000fe80003800000ULL, 0x0000005e5b5a7389ULL, 0x0002a200000e005dULL,
0xfffedf9058007950ULL, 0x000fea0003c3ffffULL, 0x000000013000780cULL, 0x000fe20003f25070ULL,
0x0000001b00007348ULL, 0x000fe80003800000ULL, 0x00000000ff317424ULL, 0x000fd000078e00ffULL,
0x0000000000307806ULL, 0x000fc800048e0100ULL, 0x0000001b304c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff307224ULL, 0x000fc800078e004dULL, 0xfffedf2030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000398ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000978ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001594ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015b8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015c8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015e8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000012180ULL, 0x6b00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013a00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013a10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013a10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013e90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001678ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012388ULL, 0x0000000000012388ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013e90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 81776;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
