/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013010ULL, 0x0000000000012b90ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000010e10ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000010f80ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000010fc0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000011000ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000011100ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00010e1000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x0042180400288080ULL, 0x0000000000000000ULL, 0x00000104ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x92082880808e0828ULL, 0x2880809a08288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080a108288080a0ULL, 0xa308288080a20828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL,
0x08288080a7082880ULL, 0x8080aa08288080a8ULL, 0xac08288080ab0828ULL, 0x288080ad08288080ULL,
0x80af08288080ae08ULL, 0x08288080b0082880ULL, 0x8080b208288080b1ULL, 0xb408288080b30828ULL,
0x288080b508288080ULL, 0x80b808288080b608ULL, 0x08288080b9082880ULL, 0x8080bb08288080baULL,
0xc108288080c00828ULL, 0x288080cc08288080ULL, 0x80e708288080e608ULL, 0x08288080e9082880ULL,
0x8082801628808098ULL, 0x0000000000031028ULL, 0x2880809892000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00010e1000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000124ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8808288080850828ULL,
0x2880808e08288080ULL, 0x8091082880809008ULL, 0x0828808092082880ULL, 0x8080980828808093ULL,
0x9a08288080990828ULL, 0x2880809b08288080ULL, 0x809d082880809c08ULL, 0x082880809e082880ULL,
0x8080a1082880809fULL, 0xa308288080a20828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL,
0x08288080a7082880ULL, 0x8080aa08288080a8ULL, 0xac08288080ab0828ULL, 0x288080ad08288080ULL,
0x80af08288080ae08ULL, 0x08288080b1082880ULL, 0x8080b308288080b2ULL, 0xb508288080b40828ULL,
0x288080b608288080ULL, 0x80b908288080b808ULL, 0x08288080ba082880ULL, 0x8080c008288080bbULL,
0xcc08288080c10828ULL, 0x288080e608288080ULL, 0x80e908288080e708ULL, 0x162880808c082880ULL,
0x0000031028808280ULL, 0x8c92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000001a800000000ULL, 0x00010f8000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000124ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8808288080850828ULL, 0x2880808c08288080ULL,
0x8090082880808e08ULL, 0x0828808091082880ULL, 0x8080930828808092ULL, 0x9908288080980828ULL,
0x2880809a08288080ULL, 0x809c082880809b08ULL, 0x082880809d082880ULL, 0x80809f082880809eULL,
0xa208288080a10828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL, 0x08288080a6082880ULL,
0x8080a808288080a7ULL, 0xab08288080aa0828ULL, 0x288080ad08288080ULL, 0x80af08288080ae08ULL,
0x08288080b1082880ULL, 0x8080b308288080b2ULL, 0xb508288080b40828ULL, 0x288080b608288080ULL,
0x80b908288080b808ULL, 0x08288080ba082880ULL, 0x8080c008288080bbULL, 0xcc08288080c10828ULL,
0x288080e608288080ULL, 0x80e908288080e708ULL, 0x16288080ac082880ULL, 0x0000031028808280ULL,
0xac92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000030000000000ULL,
0x00010fc000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000011cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080850828ULL, 0x2880808c08288080ULL, 0x8090082880808e08ULL,
0x0828808091082880ULL, 0x8080930828808092ULL, 0x9908288080980828ULL, 0x2880809a08288080ULL,
0x809c082880809b08ULL, 0x082880809d082880ULL, 0x80809f082880809eULL, 0xa208288080a10828ULL,
0x288080a308288080ULL, 0x80a508288080a408ULL, 0x08288080a6082880ULL, 0x8080a808288080a7ULL,
0xac08288080aa0828ULL, 0x288080ad08288080ULL, 0x80b108288080af08ULL, 0x08288080b2082880ULL,
0x8080b408288080b3ULL, 0xb608288080b50828ULL, 0x288080b808288080ULL, 0x80ba08288080b908ULL,
0x08288080bb082880ULL, 0x8080c108288080c0ULL, 0xe608288080cc0828ULL, 0x288080e708288080ULL,
0x80ab08288080e908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080ab9200ULL,
0x0000002cffffffffULL, 0x0000045800000000ULL, 0x0001100000000000ULL, 0x0000010000000000ULL,
0x0000180400000000ULL, 0x808c288080ab0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x000812040000006eULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0000f34000000020ULL, 0x0000f5d00000f5b0ULL, 0x0000f6f00000f6e0ULL,
0x01c829040000f700ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500003005000030ULL, 0x0500003005000030ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000d001c82804ULL, 0x000014f0000000f0ULL,
0x0000161000001570ULL, 0x00001a2000001640ULL, 0x00001ac000001a50ULL, 0x000027c000001b30ULL,
0x00002840000027e0ULL, 0x000034e0000028a0ULL, 0x0000361000003560ULL, 0x000039f000003730ULL,
0x00003a7000003a10ULL, 0x000045c000003ad0ULL, 0x00004640000045e0ULL, 0x00005260000046a0ULL,
0x00005390000052e0ULL, 0x00005770000054b0ULL, 0x000057f000005790ULL, 0x0000634000005850ULL,
0x000063c000006360ULL, 0x00006fe000006420ULL, 0x0000711000007060ULL, 0x000074f000007230ULL,
0x0000757000007510ULL, 0x000080f0000075d0ULL, 0x0000817000008110ULL, 0x00008b20000081d0ULL,
0x000092b000008b30ULL, 0x0000b1600000af30ULL, 0x0000b5e00000b5b0ULL, 0x0000efa00000be20ULL,
0x0000efe00000efd0ULL, 0x0000f0100000eff0ULL, 0x0000f0500000f030ULL, 0x0000f6d00000f060ULL,
0x0000f7400000f730ULL, 0x0000fe600000f750ULL, 0x0000ff100000feb0ULL, 0x0000ffd00000ff70ULL,
0x000100a000010040ULL, 0x0001016000010110ULL, 0x00010210000101b0ULL, 0x000102c000010270ULL,
0x0001039000010330ULL, 0x0001045000010400ULL, 0x00010500000104a0ULL, 0x000105b000010560ULL,
0x0001068000010620ULL, 0x00010740000106f0ULL, 0x000107f000010790ULL, 0x000108a000010850ULL,
0x0001097000010910ULL, 0x00010a30000109e0ULL, 0x00010ae000010a90ULL, 0x00010b8000010b30ULL,
0x00010c2000010bd0ULL, 0x00010cd000010c70ULL, 0x00010d9000010d40ULL, 0x0700390400010de0ULL,
0x000000ff00000230ULL, 0x003f010000010600ULL, 0x0000000300000270ULL, 0x003f012000010608ULL,
0x00000003000002e0ULL, 0x003f012000010688ULL, 0x00000003000003c0ULL, 0x003f0120000106a8ULL,
0x000000ff000003e0ULL, 0x003f0100000106b8ULL, 0x000000ff00000500ULL, 0x003f010700010600ULL,
0x0000003e00000690ULL, 0x003f01020001068cULL, 0x0000003e00000a00ULL, 0x003f010100010688ULL,
0x000000ff00000b40ULL, 0x003f0107000106a8ULL, 0x000000ff00000bd0ULL, 0x003f0101000106a8ULL,
0x000000ff00000c30ULL, 0x003f0101000106b8ULL, 0x000000ff00000d50ULL, 0x003f0105000106bcULL,
0x000000ff00000da0ULL, 0x003f0105000106bcULL, 0x000000ff00000e20ULL, 0x003f0105000106bcULL,
0x000000ff00001260ULL, 0x003f0107000106b0ULL, 0x000000ff000012e0ULL, 0x003f0101000106b0ULL,
0x000000ff000012f0ULL, 0x003f0105000106acULL, 0x0000003e00001360ULL, 0x003f010100010608ULL,
0x0000003e00001380ULL, 0x003f01050001060cULL, 0x0000003e00001410ULL, 0x003f01050001060cULL,
0x000000ff00001900ULL, 0x003f0105000106acULL, 0x000000ff00001980ULL, 0x003f0105000106acULL,
0x000000ff00002220ULL, 0x003f0101000106b8ULL, 0x000000ff00002230ULL, 0x003f0105000106bcULL,
0x000000ff00002280ULL, 0x003f0105000106bcULL, 0x000000ff00002300ULL, 0x003f0105000106bcULL,
0x000000ff000025d0ULL, 0x003f0107000106a8ULL, 0x000000ff00002650ULL, 0x003f0101000106a8ULL,
0x000000ff00002660ULL, 0x003f0105000106b4ULL, 0x000000ff000026b0ULL, 0x003f0105000106b4ULL,
0x000000ff00002730ULL, 0x003f0105000106b4ULL, 0x000000ff00002ea0ULL, 0x003f0101000106b8ULL,
0x000000ff00002f10ULL, 0x003f010100010688ULL, 0x000000ff00002f40ULL, 0x003f0105000106bcULL,
0x000000ff00002f90ULL, 0x003f0105000106bcULL, 0x000000ff00003010ULL, 0x003f0105000106bcULL,
0x000000ff000032a0ULL, 0x003f0107000106b0ULL, 0x000000ff00003320ULL, 0x003f0101000106b0ULL,
0x000000ff00003330ULL, 0x003f0105000106acULL, 0x0000003e000033a0ULL, 0x003f010100010628ULL,
0x0000003e000033c0ULL, 0x003f01050001062cULL, 0x0000003e00003450ULL, 0x003f01050001062cULL,
0x000000ff000038e0ULL, 0x003f0105000106acULL, 0x000000ff00003960ULL, 0x003f0105000106acULL,
0x000000ff00004060ULL, 0x003f0101000106b8ULL, 0x000000ff00004070ULL, 0x003f0105000106bcULL,
0x000000ff000040c0ULL, 0x003f0105000106bcULL, 0x000000ff00004140ULL, 0x003f0105000106bcULL,
0x000000ff000043d0ULL, 0x003f0107000106a8ULL, 0x000000ff00004450ULL, 0x003f0101000106a8ULL,
0x000000ff00004460ULL, 0x003f0105000106b4ULL, 0x000000ff000044b0ULL, 0x003f0105000106b4ULL,
0x000000ff00004530ULL, 0x003f0105000106b4ULL, 0x000000ff00004c20ULL, 0x003f0101000106b8ULL,
0x000000ff00004c90ULL, 0x003f010100010690ULL, 0x000000ff00004cc0ULL, 0x003f0105000106bcULL,
0x000000ff00004d10ULL, 0x003f0105000106bcULL, 0x000000ff00004d90ULL, 0x003f0105000106bcULL,
0x000000ff00005020ULL, 0x003f0107000106b0ULL, 0x000000ff000050a0ULL, 0x003f0101000106b0ULL,
0x000000ff000050b0ULL, 0x003f0105000106acULL, 0x0000003e00005120ULL, 0x003f010100010648ULL,
0x0000003e00005140ULL, 0x003f01050001064cULL, 0x0000003e000051d0ULL, 0x003f01050001064cULL,
0x000000ff00005660ULL, 0x003f0105000106acULL, 0x000000ff000056e0ULL, 0x003f0105000106acULL,
0x000000ff00005de0ULL, 0x003f0101000106b8ULL, 0x000000ff00005df0ULL, 0x003f0105000106bcULL,
0x000000ff00005e40ULL, 0x003f0105000106bcULL, 0x000000ff00005ec0ULL, 0x003f0105000106bcULL,
0x000000ff00006150ULL, 0x003f0107000106a8ULL, 0x000000ff000061d0ULL, 0x003f0101000106a8ULL,
0x000000ff000061e0ULL, 0x003f0105000106b4ULL, 0x000000ff00006230ULL, 0x003f0105000106b4ULL,
0x000000ff000062b0ULL, 0x003f0105000106b4ULL, 0x000000ff000069a0ULL, 0x003f0101000106b8ULL,
0x000000ff00006a10ULL, 0x003f010100010698ULL, 0x000000ff00006a40ULL, 0x003f0105000106bcULL,
0x000000ff00006a90ULL, 0x003f0105000106bcULL, 0x000000ff00006b10ULL, 0x003f0105000106bcULL,
0x000000ff00006da0ULL, 0x003f0107000106b0ULL, 0x000000ff00006e20ULL, 0x003f0101000106b0ULL,
0x000000ff00006e30ULL, 0x003f0105000106acULL, 0x0000003e00006ea0ULL, 0x003f010100010668ULL,
0x0000003e00006ec0ULL, 0x003f01050001066cULL, 0x0000003e00006f50ULL, 0x003f01050001066cULL,
0x000000ff000073e0ULL, 0x003f0105000106acULL, 0x000000ff00007460ULL, 0x003f0105000106acULL,
0x000000ff00007b60ULL, 0x003f0101000106b8ULL, 0x000000ff00007b70ULL, 0x003f0105000106bcULL,
0x000000ff00007bc0ULL, 0x003f0105000106bcULL, 0x000000ff00007c40ULL, 0x003f0105000106bcULL,
0x000000ff00007f00ULL, 0x003f0107000106a8ULL, 0x000000ff00007f80ULL, 0x003f0101000106a8ULL,
0x000000ff00007f90ULL, 0x003f0105000106b4ULL, 0x000000ff00007fe0ULL, 0x003f0105000106b4ULL,
0x000000ff00008060ULL, 0x003f0105000106b4ULL, 0x000000ff00008750ULL, 0x003f0101000106b8ULL,
0x000000ff000087b0ULL, 0x003f0101000106a0ULL, 0x000000ff0000c120ULL, 0x003f010100010600ULL,
0x000000ff0000cc10ULL, 0x003f010500010604ULL, 0x000000ff0000ccb0ULL, 0x003f010500010604ULL,
0x000000ff0000cfd0ULL, 0x003f010100010600ULL, 0x000000ff0000cfe0ULL, 0x003f010500010604ULL,
0x000000ff0000d070ULL, 0x003f010500010604ULL, 0x000000280000e400ULL, 0x003f010100000000ULL,
0x000000280000e440ULL, 0x003f010500000004ULL, 0x000000280000e8a0ULL, 0x003f010500000004ULL,
0x0000002a0000fcc0ULL, 0x003f010100000000ULL, 0x0000002a0000fd20ULL, 0x003f010100000008ULL,
0x0000002a0000fd80ULL, 0x003f010100000010ULL, 0x0000002a0000fdf0ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0000d0d00000c070ULL, 0x0000fe300000d170ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000594ULL, 0x0000001200000002ULL, 0x0000000000000444ULL,
0x0000001200000002ULL, 0x00000000000002ecULL, 0x0000001200000002ULL, 0x0000000000000194ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000571ULL,
0x0000001200000002ULL, 0x000000000000041eULL, 0x0000001200000002ULL, 0x00000000000002c6ULL,
0x0000001200000002ULL, 0x000000000000016bULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00000200ff157424ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001400077300ULL, 0x000fe600000e0000ULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000127919ULL, 0x000f220000002600ULL, 0x0000001400147309ULL, 0x000f660000000000ULL,
0x00000000003f7919ULL, 0x000f280000002700ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fc60000011605ULL, 0x00001fff040f7589ULL, 0x0049e200000e0000ULL,
0x000000ffff147224ULL, 0x020fc600078e0a14ULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x0000000104027824ULL, 0x008fe400078e0203ULL, 0x0000000812047824ULL, 0x010fe400078e00ffULL,
0x0000008002037824ULL, 0x000fe400078e0205ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x00005800ff057624ULL, 0x000fe400078e00ffULL, 0x000000ff0300720cULL, 0x000fc40003f25270ULL,
0x0000000f0300780cULL, 0x000fe20003f44070ULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0x0000007f0300780cULL, 0x040fe40003f84070ULL, 0x000000030300780cULL, 0x000fe20003f64070ULL,
0x0000003f050a7224ULL, 0x000fe200078e0204ULL, 0x000000080700720cULL, 0x000fe20003f02070ULL,
0x000000040f067824ULL, 0x002fc800078e0200ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002060b7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x010608060300a388ULL, 0x0007e20000008a00ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x000000010c0c7824ULL, 0x100fe200078e0a0bULL, 0x010400100300c388ULL, 0x0009e20000004800ULL,
0x000000010b117810ULL, 0x000fe20007ffe0ffULL, 0x000000010a047824ULL, 0x002fc400078e020bULL,
0x010688080300b388ULL, 0x0003e20000008a00ULL, 0x000000ff0c00720cULL, 0x000fe20003f63070ULL,
0x00000010020e7824ULL, 0x004fe200078e00ffULL, 0x000000010c00780cULL, 0x000fe20003f83070ULL,
0x000000010a067824ULL, 0x008fe200078e0211ULL, 0x0000001f0d0c7812ULL, 0x000fe200078e7802ULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x000001f00e137812ULL, 0x000fe200078ec0ffULL,
0x3fffff00ff0aa424ULL, 0x000fe400078e00ffULL, 0x000000200b107824ULL, 0x010fc400078e020cULL,
0x7fffff00ff0ba424ULL, 0x000fe200078e00ffULL, 0x0000000711097812ULL, 0x002fe200078ec0ffULL,
0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x080fe200078e0015ULL,
0x0106a80a0300a388ULL, 0x0003e60000008a00ULL, 0x00005c0006067625ULL, 0x000fe200078e0015ULL,
0x0106b80cff009388ULL, 0x0005e80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001304087210ULL, 0x000fc40007fbe0ffULL, 0x0000001f09047812ULL, 0x000fe200078e7802ULL,
0x000000ffff037224ULL, 0x002fe200078e0014ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe400028e0605ULL, 0x0000002011047824ULL, 0x000fe400078e0204ULL,
0x0000001010117824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400010e0607ULL,
0x0000001004137824ULL, 0x000fc400078e00ffULL, 0x00000004ff047424ULL, 0x000fc800078e00ffULL,
0x000060003f047625ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0005e8000d901c46ULL, 0x0000000006137faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060403ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x004ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff3c7e24ULL, 0x002fe2000f8e00ffULL,
0x000000ff033d7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff3d7819ULL, 0x000fce000001163dULL,
0x0000ba9000008947ULL, 0x000fea0003800000ULL, 0x0000580012047a10ULL, 0x000fe20007ffe0ffULL,
0x000000023f3f7824ULL, 0x000fe200078e00ffULL, 0x000000013c067810ULL, 0x000fe20007ffe0ffULL,
0x00000008003e7824ULL, 0x000fe400078e00ffULL, 0x000058003f3f7a24ULL, 0x000fe200078e0204ULL,
0x0000003d0600720cULL, 0x000fe20003f06070ULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004ff097819ULL, 0x000fe20000011602ULL,
0x000001003c047824ULL, 0x000fe200078e00ffULL, 0x01068c0d3eff738cULL, 0x0003e20000000000ULL,
0x00000100ff147424ULL, 0x000fe200078e00ffULL, 0x00000002090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e077824ULL, 0x040fe200078e0209ULL, 0x0000000403057217ULL, 0x000fe20007800000ULL,
0x000062003f067a24ULL, 0x100fe200078e0204ULL, 0x0000000409137810ULL, 0x000fe20007ffe0ffULL,
0x000000013e117824ULL, 0x040fe200078e020fULL, 0x00000007070b7812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x0000000609177810ULL, 0x000fe20007ffe0ffULL,
0x000000013e157824ULL, 0x000fe200078e0213ULL, 0x0000000f0b047812ULL, 0x000fc400078e7802ULL,
0x00000007110b7812ULL, 0x000fe200078ec0ffULL, 0x000000013e197824ULL, 0x000fe200078e0217ULL,
0x000000f00e1b7812ULL, 0x000fe200078ec0ffULL, 0x00000010070d7824ULL, 0x002fe200078e0204ULL,
0x0000000f0b087812ULL, 0x000fe200078e7802ULL, 0x0000000106047824ULL, 0x000fe200078e0207ULL,
0x0000002005077807ULL, 0x000fe40000000000ULL, 0x00000007150b7812ULL, 0x000fe200078ec0ffULL,
0x00000010110e7824ULL, 0x000fe200078e0208ULL, 0x000000073e077217ULL, 0x000fe20007800000ULL,
0x00005e0004047625ULL, 0x000fe200078e0014ULL, 0x0000000f0b087812ULL, 0x000fc400078e7802ULL,
0x00000007190b7812ULL, 0x000fe200078ec0ffULL, 0x00000001070c7824ULL, 0x000fe200078e0a3eULL,
0x0000001b040a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015107824ULL, 0x000fe200078e0208ULL,
0x0000000f0b127812ULL, 0x000fe200078e7802ULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x0000000c0900720cULL, 0x080fe20003f26070ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x0000000c0f00720cULL, 0x080fe20003f46070ULL, 0x0000000106087824ULL, 0x000fe200078e0219ULL,
0x0000000c1300720cULL, 0x080fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000000c1700720cULL, 0x000fe20003f06070ULL, 0x00005e0011047625ULL, 0x000fe200078e0014ULL,
0x0000c0000d0d7811ULL, 0x000fc600078e20ffULL, 0x00005e0015067625ULL, 0x000fe200078e0014ULL,
0x0000001b04047210ULL, 0x000fc60007f9e0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0014ULL,
0x0000001b06067210ULL, 0x000fc60007fbe0ffULL, 0x0000001019127824ULL, 0x000fe200078e0212ULL,
0x0000001b08087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe400020e0605ULL,
0x000000ffff077224ULL, 0x000fe400028e0607ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL,
0x010688003eff7f8cULL, 0x0003e2000c80043fULL, 0x0000c00010157811ULL, 0x000fe200078e20ffULL,
0xff317217ff407424ULL, 0x000fe200078e00ffULL, 0x0000c00012177811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0005e2000c901c46ULL,
0x0000003d3c00720cULL, 0x000fe20003f26070ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000040f7faeULL, 0x0003e2000d101c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000006157faeULL, 0x0003e2000d901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1d7224ULL, 0x000fc400078e00ffULL,
0x0000000008177faeULL, 0x0007e2000c101c46ULL, 0x00000000000a7805ULL, 0x004fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000087805ULL, 0x008fc6000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00007b2000001947ULL, 0x000fea0003800000ULL,
0x0000000400427824ULL, 0x000fe400078e00ffULL, 0xff317217ff407424ULL, 0x000fc400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x0000000242437810ULL, 0x000fe40007ffe0ffULL,
0x000001003c0c7824ULL, 0x006fca00078e00ffULL, 0x000000030c00720cULL, 0x000fda0003f06070ULL,
0x00007a7000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0c7984ULL, 0x000ea40000000800ULL,
0x800000000cff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000e7305ULL, 0x0004e4000021f000ULL,
0x3fa000000c0c7823ULL, 0x004fe200000100ffULL, 0x0000000e0000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fc4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000203c0c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff2f7424ULL, 0x000fe200078e00ffULL, 0x00000004ff2c7819ULL, 0x000fe20000011602ULL,
0x0000001002507824ULL, 0x000fe200078e00ffULL, 0x0000000c030d7217ULL, 0x000fe20007800000ULL,
0x000062003f2b7a24ULL, 0x000fe200078e020cULL, 0x000000013c0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e447824ULL, 0x000fe200078e022cULL, 0x000000022c467810ULL, 0x040fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0cULL, 0x000000042c477810ULL, 0x000fe20007ffe0ffULL,
0x00000001440c7824ULL, 0x000fe200078e022bULL, 0x0000003d0e00720cULL, 0x000fe20003f06070ULL,
0x000000013e497824ULL, 0x000fe200078e0246ULL, 0x000000062c487810ULL, 0x000fe20007ffe0ffULL,
0x000000013e4a7824ULL, 0x000fe200078e0247ULL, 0x000000200d0f7807ULL, 0x000fe20000000000ULL,
0x00000001490e7824ULL, 0x100fe200078e022bULL, 0x000000f050457812ULL, 0x000fe200078ec0ffULL,
0x000000014a287824ULL, 0x000fe200078e022bULL, 0x0000000f3e2d7217ULL, 0x000fe20007800000ULL,
0x00005e000c0c7625ULL, 0x000fe200078e002fULL, 0x000000074a317812ULL, 0x000fc600078ec0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e002fULL, 0x000000450c2a7210ULL, 0x000fe40007f3e0ffULL,
0x0000000f31317812ULL, 0x000fe200078e7802ULL, 0x00005e0028287625ULL, 0x000fe200078e002fULL,
0x000000450e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000013e4b7824ULL, 0x000fe200078e0248ULL,
0x0000004528287210ULL, 0x000fe20007f7e0ffULL, 0x000000012d2d7824ULL, 0x000fe400078e0a3eULL,
0x000000014b0c7824ULL, 0x040fe200078e022bULL, 0x000000074b337812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e060dULL, 0x0000002d2c00720cULL, 0x000fe20003f26070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e002fULL, 0x00000007442f7812ULL, 0x000fe400078ec0ffULL,
0x0000002d4800720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000002d4600720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x0000002d4700720cULL, 0x000fe20003f66070ULL, 0x000000104a5d7824ULL, 0x000fe200078e0231ULL,
0x00000007492d7812ULL, 0x000fc400078ec0ffULL, 0x0000000f2f2f7812ULL, 0x100fe400078e7802ULL,
0x0000000f2d5c7812ULL, 0x100fe400078e7802ULL, 0x0000000f335e7812ULL, 0x000fe200078e7802ULL,
0x00000010445b7824ULL, 0x000fe200078e022fULL, 0x000000450c0c7210ULL, 0x000fe20007fbe0ffULL,
0x00000010495c7824ULL, 0x000fe200078e025cULL, 0x0000e0005d4e7811ULL, 0x000fe200078e20ffULL,
0x000000104b5e7824ULL, 0x000fe200078e025eULL, 0x0000e0005b4c7811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000e0005c4d7811ULL, 0x000fc400078e20ffULL,
0x0000e0005e4f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4c7faeULL, 0x0005e8000c901c46ULL, 0x000000000e4d7faeULL, 0x0005e8000d101c46ULL,
0x00000000284e7faeULL, 0x0005e8000d901c46ULL, 0x000000000c4f7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff347f8cULL, 0x000ee8000c80043fULL, 0x0106ac00ff0c7984ULL, 0x004ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010608003e0e7f8cULL, 0x000fe2000c80043fULL, 0x800000000cff7812ULL, 0x006fc60007844867ULL,
0x01060c003e0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x01060c003e0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff0c7819ULL, 0x000fe20000011602ULL, 0xffffffffff517424ULL, 0x000fe200078e00ffULL,
0x0000007050507812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL,
0x0000000150507824ULL, 0x000fca00078e020dULL, 0x01000000500f7984ULL, 0x000e680000000800ULL,
0x01020000500e7984ULL, 0x0005220000000800ULL, 0x000000400f00720bULL, 0x002fe20003f3d000ULL,
0x0000e9527f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800008e0100ULL,
0x0000ffff0c287812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff337424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f65270ULL, 0x000000400f00720bULL, 0x000fe20003f34000ULL,
0x0000e9227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x000fe400008e0100ULL,
0x0000000f402b7209ULL, 0x000fe40007810000ULL, 0x0000ffff0c297812ULL, 0x000fe400078e3cffULL,
0x00000002ff327819ULL, 0x000fe20000011602ULL, 0x0104002b5000b388ULL, 0x0003e20000000800ULL,
0x8000002b400d7221ULL, 0x000fe20000010000ULL, 0x0000002928ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d002f7308ULL, 0x0002a20000000800ULL,
0x0000e8d27f007947ULL, 0x000fea000b800000ULL, 0x00001f322f0c7589ULL, 0x00446400000e0000ULL,
0x0000000832327810ULL, 0x006fe20007ffe0ffULL, 0x0000e9027f007947ULL, 0x000fea000b800000ULL,
0x00001f322f2e7589ULL, 0x0002a400000e0000ULL, 0x8000002b0f0f1221ULL, 0x100fe20000010000ULL,
0x0000002f41417220ULL, 0x000fe20000410000ULL, 0x0000002e13137220ULL, 0x084fe20000410000ULL,
0x0000002e12127220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b0f0f1820ULL, 0x000fe20000410000ULL,
0x0000002e23237220ULL, 0x080fe20000410000ULL, 0x0000002e22227220ULL, 0x080fe20000410000ULL,
0x0000002e0b0b7220ULL, 0x080fe20000410000ULL, 0x0000000f00521308ULL, 0x000ea20000000800ULL,
0x0000002e0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002e27277220ULL, 0x080fe20000410000ULL,
0x0000002e26267220ULL, 0x080fe20000410000ULL, 0x0000002e07077220ULL, 0x080fe20000410000ULL,
0x0000002e06067220ULL, 0x080fe20000410000ULL, 0x0000002e17177220ULL, 0x080fe20000410000ULL,
0x0000002e16167220ULL, 0x000fe20000410000ULL, 0x00000001ff337807ULL, 0x000fe20000800000ULL,
0x0000000c11117220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c09097220ULL, 0x080fe20000410000ULL, 0x0000000c08087220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c05057220ULL, 0x080fe20000410000ULL, 0x0000000c04047220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x000fe20000410000ULL,
0x000000ffff407224ULL, 0x000fe200078e002bULL, 0x000000520e0e1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000410e417221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fc40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x000524000021f000ULL,
0x3fa000000c0c7823ULL, 0x004fe200000100ffULL, 0x0000000d0000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000004ff0e7819ULL, 0x000fc40000011602ULL, 0x00000002ff547819ULL, 0x000fe40000011602ULL,
0x000054100c2f7816ULL, 0x002fe2000000000cULL, 0x0000e5727f007947ULL, 0x000fea000b800000ULL,
0x00001f542f397589ULL, 0x0002a400000e0000ULL, 0x0000000854537810ULL, 0x000fe20007ffe0ffULL,
0x0000e5b27f007947ULL, 0x000fea000b800000ULL, 0x00001f532f367589ULL, 0x00086400000e0000ULL,
0x0000001054657810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0065ULL, 0x00001ad0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000f4f000007944ULL, 0x01cfea0003c00000ULL, 0x0000001854547810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x000fe200078e0054ULL,
0x00001b40002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000f48000007944ULL, 0x01cfea0003c00000ULL,
0x00000008020d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000702377812ULL, 0x040fe400078ec0ffULL, 0x00000042020c7211ULL, 0x000fe400078fe0ffULL,
0x000000070d2d7812ULL, 0x100fe400078ec802ULL, 0x0000000837377812ULL, 0x100fe400078ef802ULL,
0x000000070d2c7812ULL, 0x000fc400078ef802ULL, 0x0000000c2d637212ULL, 0x000fe400078e3cffULL,
0x000000070e0c7812ULL, 0x000fe400078e7837ULL, 0x00000043022e7211ULL, 0x004fe200078fe0ffULL,
0x000000102c5f7824ULL, 0x000fe200078e0263ULL, 0x00009910332f7816ULL, 0x012fe200000000ffULL,
0x0000000837557824ULL, 0x000fe200078e020cULL, 0x0000002e2d2d7212ULL, 0x000fe400078e3cffULL,
0x0000c0005f567811ULL, 0x000fc400078e20ffULL, 0x0000a00055287811ULL, 0x000fe200078e20ffULL,
0x000000102c617824ULL, 0x040fe200078e022dULL, 0x000000ff2f00720cULL, 0x000fe20003f25270ULL,
0x00000000560c783bULL, 0x000e620000004200ULL, 0x000001002c5a7811ULL, 0x000fe400078e20ffULL,
0x0000c00061577811ULL, 0x000fe200078e20ffULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x0000000746587812ULL, 0x000fe200078e7837ULL, 0x000000012d647824ULL, 0x100fe400078e025aULL,
0x000000005730783bULL, 0x000f220000004200ULL, 0x0000000163637824ULL, 0x000fc400078e025aULL,
0x0000000837587824ULL, 0x000fe200078e0258ULL, 0x0000c00064597811ULL, 0x000fe400078e20ffULL,
0x0000c000635a7811ULL, 0x000fe400078e20ffULL, 0x000031200c0c7816ULL, 0x002fe400000000ffULL,
0x000031200d0d7816ULL, 0x000fe400000000ffULL, 0x0000000cff2e723eULL, 0x080fe200020006ffULL,
0x0000003928289232ULL, 0x084fe20000000000ULL, 0x0000000dff2f723eULL, 0x080fe200020006ffULL,
0x000000392a2a9232ULL, 0x000fe20000000000ULL, 0x0000000cff0c723eULL, 0x000fe200030006ffULL,
0x0000003629299232ULL, 0x080fe20000000000ULL, 0x0000000dff0d723eULL, 0x000fe200030006ffULL,
0x000000362b2b9232ULL, 0x000fe20000000000ULL, 0x000031200e387816ULL, 0x000fc400000000ffULL,
0x000031200f3b7816ULL, 0x000fe400000000ffULL, 0x0000a000580e7811ULL, 0x000fe400078e20ffULL,
0x0000000c2804723cULL, 0x040fe20000001804ULL, 0x00000038ff3a723eULL, 0x080fe400030006ffULL,
0x0000312030307816ULL, 0x010fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x00000038ff0c723eULL, 0x000fe200020006ffULL, 0x0000002e2814723cULL, 0x000fe20000001814ULL,
0x0000003bff0d723eULL, 0x080fe200020006ffULL, 0x00000000592c783bULL, 0x000e620000004200ULL,
0x0000003bff3b723eULL, 0x000fc400030006ffULL, 0x0000312032387816ULL, 0x000fe400000000ffULL,
0x0000312033607816ULL, 0x000fe200000000ffULL, 0x0000000c2824723cULL, 0x040fe20000001824ULL,
0x000000000e0c783bULL, 0x000eae0000000200ULL, 0x0000003a2818723cULL, 0x000fee0000001818ULL,
0x00000030ff3a723eULL, 0x000fc400020006ffULL, 0x00000031ff3b723eULL, 0x080fe400020006ffULL,
0x00000030ff30723eULL, 0x000fe400030006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x0000003a281c723cULL, 0x040fee000000181cULL, 0x00000038ff3a723eULL, 0x000fe200020006ffULL,
0x000000302808723cULL, 0x000fe20000001808ULL, 0x000000005a30783bULL, 0x000f220000004200ULL,
0x00000060ff3b723eULL, 0x000fc400020006ffULL, 0x000031202c2c7816ULL, 0x002fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x000031202e2e7816ULL, 0x000fe200000000ffULL,
0x0000003a2820723cULL, 0x000fe20000001820ULL, 0x000000390c0c9232ULL, 0x084fe20000000000ULL,
0x000031202f2f7816ULL, 0x000fe200000000ffULL, 0x000000390e0e9232ULL, 0x000fe40000000000ULL,
0x000000360d0d9232ULL, 0x000fc40000000000ULL, 0x00000038ff3a723eULL, 0x000fe200030006ffULL,
0x000000360f0f9232ULL, 0x000fe20000000000ULL, 0x00000060ff3b723eULL, 0x000fce00030006ffULL,
0x0000003a2828723cULL, 0x000fee0000001810ULL, 0x0000002cff10723eULL, 0x080fe400020006ffULL,
0x0000002dff11723eULL, 0x000fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fc400030006ffULL,
0x0000002dff2d723eULL, 0x000fc600030006ffULL, 0x000000100c1c723cULL, 0x040fe2000000181cULL,
0x0000312030307816ULL, 0x010fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x0000312032327816ULL, 0x000fe400000000ffULL, 0x0000002eff10723eULL, 0x000fe200020006ffULL,
0x0000002c0c08723cULL, 0x000fe20000001808ULL, 0x0000002fff11723eULL, 0x000fe400020006ffULL,
0x0000312033337816ULL, 0x000fc400000000ffULL, 0x0000002eff2e723eULL, 0x000fe400030006ffULL,
0x0000002fff2f723eULL, 0x000fe200030006ffULL, 0x000000100c20723cULL, 0x000fee0000001820ULL,
0x00000030ff10723eULL, 0x000fc400020006ffULL, 0x00000031ff11723eULL, 0x000fce00020006ffULL,
0x000000100c14723cULL, 0x000fee0000001814ULL, 0x00000030ff10723eULL, 0x000fe400030006ffULL,
0x00000031ff11723eULL, 0x000fce00030006ffULL, 0x000000100c10723cULL, 0x000fee0000001804ULL,
0x00000032ff04723eULL, 0x080fe400020006ffULL, 0x00000033ff05723eULL, 0x000fe400020006ffULL,
0x00000032ff32723eULL, 0x000fc400030006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000040c24723cULL, 0x040ff00000001824ULL, 0x000000320c18723cULL, 0x040ff00000001818ULL,
0x0000002e0c0c723cULL, 0x000fe20000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff067f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007844807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007844807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007844807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000403c047811ULL, 0x000fe200078e40ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff2c7819ULL, 0x000fe40000011602ULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x000062003f2a7a24ULL, 0x100fe200078e0204ULL,
0x0000c0005b5b7811ULL, 0x000fe400078e20ffULL, 0x0000c0005c5c7811ULL, 0x000fe200078e20ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x0000c0005d5d7811ULL, 0x000fe200078e20ffULL,
0x0000000144047824ULL, 0x100fe200078e022aULL, 0x0000c0005e5e7811ULL, 0x000fe200078e20ffULL,
0x0000000149067824ULL, 0x100fe200078e022aULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x000000014a287824ULL, 0x000fc400078e022aULL, 0x000000014b2a7824ULL, 0x000fe200078e022aULL,
0x000000053e077217ULL, 0x000fe20007800000ULL, 0x00005e0004047625ULL, 0x000fc800078e002bULL,
0x00000001072d7824ULL, 0x000fe200078e0a3eULL, 0x0000004504047210ULL, 0x000fe20007f7e0ffULL,
0x00005e0006067625ULL, 0x000fc600078e002bULL, 0x0000002d2c00720cULL, 0x000fe20003f46070ULL,
0x00005e0028287625ULL, 0x000fe200078e002bULL, 0x0000004506067210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200018e0605ULL, 0x0000004528287210ULL, 0x000fe20007fbe0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e002bULL, 0x0000002d4600720cULL, 0x000fc60003f66070ULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0x0000002d4700720cULL, 0x080fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x0000002d4800720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000045b7faeULL, 0x0003e2000d101c46ULL,
0x000000452a2a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e062bULL,
0x00000000065c7faeULL, 0x0003e8000d901c46ULL, 0x00000000285d7faeULL, 0x0003e8000e101c46ULL,
0x000000002a5e7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff057984ULL, 0x002e640000000800ULL, 0x8000000005ff7812ULL, 0x00afc40007844835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff327819ULL, 0x000fe40000011602ULL,
0x00005410042f7816ULL, 0x000fe20000000004ULL, 0x0000d8b27f007947ULL, 0x000fea000b800000ULL,
0x00001f322f357589ULL, 0x0002a400000e0000ULL, 0x0000d8f27f007947ULL, 0x000fea000b800000ULL,
0x00001f532f347589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0065ULL, 0x00002850002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000e77000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0054ULL, 0x000028b0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000e71000007944ULL, 0x01cfea0003c00000ULL, 0x0000000747607812ULL, 0x100fe200078e7837ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0005f5f7811ULL, 0x000fe400078e20ffULL,
0x0000e00061617811ULL, 0x000fe200078e20ffULL, 0x0000000837607824ULL, 0x000fe200078e0260ULL,
0x0000000748627812ULL, 0x000fe200078e7837ULL, 0x000000005f04783bULL, 0x000f620000004200ULL,
0x0000e00063637811ULL, 0x000fe400078e20ffULL, 0x0000a000602c7811ULL, 0x000fe200078e20ffULL,
0x000000006128783bULL, 0x000fe20000004200ULL, 0x0000000837627824ULL, 0x000fe200078e0262ULL,
0x0000e00064647811ULL, 0x000fc400078e20ffULL, 0x000000002c30783bULL, 0x002e620000000200ULL,
0x0000312004047816ULL, 0x020fe400000000ffULL, 0x0000312005057816ULL, 0x000fe400000000ffULL,
0x00000004ff2e723eULL, 0x084fe400020006ffULL, 0x00000005ff2f723eULL, 0x088fe200020006ffULL,
0x0000003530309232ULL, 0x082fe20000000000ULL, 0x00000004ff04723eULL, 0x000fe200030006ffULL,
0x0000003532329232ULL, 0x000fe20000000000ULL, 0x00000005ff05723eULL, 0x000fe200030006ffULL,
0x0000003431319232ULL, 0x090fe20000000000ULL, 0x0000312006367816ULL, 0x000fe200000000ffULL,
0x0000003433339232ULL, 0x000fe20000000000ULL, 0x0000312007387816ULL, 0x000fc400000000ffULL,
0x0000312028287816ULL, 0x000fe400000000ffULL, 0x00000038ff37723eULL, 0x000fe400030006ffULL,
0x000000043004723cULL, 0x000fe20000001810ULL, 0x0000312029297816ULL, 0x000fcc00000000ffULL,
0x00000036ff10723eULL, 0x080fe200020006ffULL, 0x0000002e3014723cULL, 0x000fe20000001814ULL,
0x00000036ff36723eULL, 0x000fe200030006ffULL, 0x00000000632c783bULL, 0x000e620000004200ULL,
0x00000038ff11723eULL, 0x000fe400020006ffULL, 0x0000a00062127811ULL, 0x000fc600078e20ffULL,
0x000000363018723cULL, 0x040fee0000001818ULL, 0x00000028ff36723eULL, 0x080fe200020006ffULL,
0x000000103024723cULL, 0x000fe20000001824ULL, 0x00000029ff37723eULL, 0x000fe200020006ffULL,
0x000000001210783bULL, 0x000ea20000000200ULL, 0x00000028ff28723eULL, 0x000fc400030006ffULL,
0x00000029ff29723eULL, 0x000fc600030006ffULL, 0x00000036301c723cULL, 0x040fee000000181cULL,
0x000031202a367816ULL, 0x000fe200000000ffULL, 0x000000283008723cULL, 0x000fe20000001808ULL,
0x000031202b377816ULL, 0x000fcc00000000ffULL, 0x00000036ff28723eULL, 0x080fe400020006ffULL,
0x00000037ff29723eULL, 0x080fe400020006ffULL, 0x00000036ff36723eULL, 0x000fe400030006ffULL,
0x00000037ff37723eULL, 0x000fe400030006ffULL, 0x000031202c2c7816ULL, 0x002fe200000000ffULL,
0x000000283020723cULL, 0x000fe20000001820ULL, 0x000000006428783bULL, 0x000e620000004200ULL,
0x000031202d2d7816ULL, 0x000fc400000000ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x00000036300c723cULL, 0x000fe2000000180cULL,
0x0000003510109232ULL, 0x084fe40000000000ULL, 0x0000003512129232ULL, 0x000fe40000000000ULL,
0x0000003411119232ULL, 0x080fe40000000000ULL, 0x0000002cff30723eULL, 0x000fe200020006ffULL,
0x0000003413139232ULL, 0x000fe20000000000ULL, 0x0000002dff31723eULL, 0x000fc400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x000000301014723cULL, 0x040ff00000001814ULL, 0x0000002c1004723cULL, 0x000fee0000001804ULL,
0x0000002eff2c723eULL, 0x000fc400020006ffULL, 0x0000002fff2d723eULL, 0x000fe400020006ffULL,
0x0000312028287816ULL, 0x002fe400000000ffULL, 0x0000312029297816ULL, 0x000fe400000000ffULL,
0x000031202a2a7816ULL, 0x000fe200000000ffULL, 0x0000002c1024723cULL, 0x000fe20000001824ULL,
0x000031202b2b7816ULL, 0x000fe400000000ffULL, 0x0000002eff2e723eULL, 0x000fc400030006ffULL,
0x0000002fff2f723eULL, 0x000fe400030006ffULL, 0x00000028ff2c723eULL, 0x080fe400020006ffULL,
0x00000029ff2d723eULL, 0x080fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000002e1018723cULL, 0x000fe20000001818ULL, 0x00000029ff29723eULL, 0x000fce00030006ffULL,
0x000000281008723cULL, 0x040fee0000001808ULL, 0x0000002aff28723eULL, 0x080fe200020006ffULL,
0x0000002c101c723cULL, 0x000fe2000000181cULL, 0x0000002bff29723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fc400030006ffULL, 0x0000002bff2b723eULL, 0x000fc600030006ffULL,
0x000000281020723cULL, 0x040ff00000001820ULL, 0x0000002a1010723cULL, 0x000fe2000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000403c0c7811ULL, 0x002fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000000c0300720cULL, 0x000fda0003f24070ULL, 0x0000588000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000782480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000603c0c7811ULL, 0x000fe200078e40ffULL, 0x00000100ff2f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff2c7819ULL, 0x000fe40000011602ULL, 0x0000000c030d7217ULL, 0x000fe20007800000ULL,
0x000062003f287a24ULL, 0x000fc800078e020cULL, 0x000000010d0d7824ULL, 0x000fe400078e0a0cULL,
0x00000001440c7824ULL, 0x100fe400078e0228ULL, 0x00000001490e7824ULL, 0x000fe200078e0228ULL,
0x000000200d0f7807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fc600078e002fULL,
0x0000000f3e297217ULL, 0x000fe20007800000ULL, 0x00005e000e0e7625ULL, 0x000fe200078e002fULL,
0x000000450c2a7210ULL, 0x000fc60007f3e0ffULL, 0x00000001292d7824ULL, 0x000fe200078e0a3eULL,
0x000000450e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000014a0c7824ULL, 0x100fe400078e0228ULL,
0x000000014b287824ULL, 0x000fe200078e0228ULL, 0x0000002d2c00720cULL, 0x080fe20003f46070ULL,
0x000000ffff2b7224ULL, 0x000fe200008e060dULL, 0x0000002d4600720cULL, 0x000fe20003f26070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e002fULL, 0x0000002d4800720cULL, 0x000fc60003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e002fULL, 0x000000450c0c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e060fULL, 0x0000002d4700720cULL, 0x000fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000004528287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a4c7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x000000000e4d7faeULL, 0x0003ea000c901c46ULL,
0x000000000c4e7faeULL, 0x0003e8000d901c46ULL, 0x00000000284f7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff0c7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010628003e0e7f8cULL, 0x000fe2000c80043fULL, 0x800000000cff7812ULL, 0x002fc60007844867ULL,
0x01062c003e0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002e4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x008fe40003800000ULL, 0x01062c003e0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01008000500f7984ULL, 0x000e680000000800ULL, 0x01028000500e7984ULL, 0x0007220000000800ULL,
0x000000400f00720bULL, 0x002fe20003f3d000ULL, 0x0000cc627f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff0c297812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f65270ULL,
0x000000400f00720bULL, 0x000fe20003f34000ULL, 0x0000cc327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x000fe400008e0100ULL, 0x0000000f400d7209ULL, 0x000fe40007810000ULL,
0x0000ffff0c0c7812ULL, 0x000fe400078e3cffULL, 0x00000002ff327819ULL, 0x000fe20000011602ULL,
0x8000000d40287221ULL, 0x000fe20000010000ULL, 0x0104800d5000b388ULL, 0x0003e20000000800ULL,
0x0000000c29ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x00000028002f7308ULL, 0x000ee40000000800ULL, 0x0000002f41417220ULL, 0x008fe20000410000ULL,
0x0000cbd27f007947ULL, 0x000fea000b800000ULL, 0x00001f322f2e7589ULL, 0x0022e400000e0000ULL,
0x0000002e14147220ULL, 0x08cfe20000410000ULL, 0x0000002e15157220ULL, 0x080fe20000410000ULL,
0x0000002e04047220ULL, 0x080fe20000410000ULL, 0x0000002e05057220ULL, 0x080fe20000410000ULL,
0x0000002e24247220ULL, 0x080fe20000410000ULL, 0x0000002e25257220ULL, 0x080fe20000410000ULL,
0x0000002e18187220ULL, 0x080fe20000410000ULL, 0x0000002e19197220ULL, 0x080fe20000410000ULL,
0x0000002e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002e08087220ULL, 0x080fe20000410000ULL, 0x0000002e09097220ULL, 0x080fe20000410000ULL,
0x0000002e20207220ULL, 0x080fe20000410000ULL, 0x0000002e21217220ULL, 0x080fe20000410000ULL,
0x0000002e10107220ULL, 0x080fe20000410000ULL, 0x0000002e11117220ULL, 0x000fe20000410000ULL,
0x0000cb027f007947ULL, 0x000fea000b800000ULL, 0x00001f532f2e7589ULL, 0x0004e400000e0000ULL,
0x0000000f40407209ULL, 0x000fe20007810000ULL, 0x0000002e16167220ULL, 0x08cfe20000410000ULL,
0x00000001ff0d7807ULL, 0x000fe20000800000ULL, 0x0000002e17177220ULL, 0x080fe20000410000ULL,
0x0000002e06067220ULL, 0x080fe20000410000ULL, 0x800000400f0f1221ULL, 0x000fe20000010000ULL,
0x0000002e07077220ULL, 0x080fe20000410000ULL, 0x0000002e26267220ULL, 0x080fe20000410000ULL,
0x0000002e27277220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b0f0f1820ULL, 0x000fe20000410000ULL,
0x0000002e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f00521308ULL, 0x000ea20000000800ULL,
0x0000002e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002e0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002e0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002e22227220ULL, 0x080fe20000410000ULL,
0x0000002e23237220ULL, 0x080fe20000410000ULL, 0x0000002e12127220ULL, 0x080fe20000410000ULL,
0x0000002e13137220ULL, 0x000fe20000410000ULL, 0x0000000e520e1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000410e417221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0c7984ULL, 0x000ee40000000800ULL, 0x800000000cff7812ULL, 0x008fc40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000e7305ULL, 0x000724000021f000ULL,
0x3fa000000c0c7823ULL, 0x008fe200000100ffULL, 0x0000000e0000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff0e7984ULL, 0x000ee40000000800ULL, 0x800000000eff7812ULL, 0x008fe40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff327819ULL, 0x002fc40000011602ULL, 0x000054100c2f7816ULL, 0x000fe2000000000cULL,
0x0000c8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f322f677589ULL, 0x0002e400000e0000ULL,
0x0000c8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f532f667589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0065ULL,
0x00003a80002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000d54000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0054ULL,
0x00003ae0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000d4e000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a80055297811ULL, 0x000fe200078e20ffULL,
0x000000005630783bULL, 0x002e620000004200ULL, 0x000099100d0c7816ULL, 0x000fc800000000ffULL,
0x000000002928783bULL, 0x000f620000000200ULL, 0x000000ff0c00720cULL, 0x000fc60003f25270ULL,
0x00000000570c783bULL, 0x000f220000004200ULL, 0x0000312030307816ULL, 0x002fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x00000030ff2c723eULL, 0x000fca00020006ffULL,
0x0000006728289232ULL, 0x0a8fe20000000000ULL, 0x00000031ff2d723eULL, 0x080fe200020006ffULL,
0x000000672a2a9232ULL, 0x000fe20000000000ULL, 0x00000030ff30723eULL, 0x000fe200030006ffULL,
0x0000006629299232ULL, 0x080fe20000000000ULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x000000662b2b9232ULL, 0x000fe20000000000ULL, 0x0000312032347816ULL, 0x000fe400000000ffULL,
0x0000312033357816ULL, 0x000fe400000000ffULL, 0x000031200c0c7816ULL, 0x010fc400000000ffULL,
0x000000302830723cULL, 0x040fe20000001804ULL, 0x000031200d0d7816ULL, 0x000fe400000000ffULL,
0x000031200e6a7816ULL, 0x000fe400000000ffULL, 0x000031200f6b7816ULL, 0x000fe400000000ffULL,
0x00000034ff04723eULL, 0x080fe200020006ffULL, 0x0000002c282c723cULL, 0x004fe20000001814ULL,
0x00000035ff05723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fc400030006ffULL,
0x00000035ff35723eULL, 0x000fe400030006ffULL, 0x0000a80058147811ULL, 0x000fe200078e20ffULL,
0x000000042824723cULL, 0x040fe20000001824ULL, 0x000000005a04783bULL, 0x000e620000004200ULL,
0x0000006aff38723eULL, 0x080fe400020006ffULL, 0x0000006bff39723eULL, 0x080fe200020006ffULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x0000006aff6a723eULL, 0x000fe400030006ffULL,
0x000000342818723cULL, 0x000fe20000001818ULL, 0x0000006bff6b723eULL, 0x000fcc00030006ffULL,
0x0000000cff34723eULL, 0x000fe200020006ffULL, 0x000000382838723cULL, 0x000fe20000001820ULL,
0x0000000dff35723eULL, 0x000fce00020006ffULL, 0x00000034281c723cULL, 0x040fee000000181cULL,
0x0000000cff34723eULL, 0x000fe200030006ffULL, 0x0000006a2810723cULL, 0x040fe20000001810ULL,
0x0000000dff35723eULL, 0x000fe400030006ffULL, 0x00000000590c783bULL, 0x000eea0000004200ULL,
0x000000342834723cULL, 0x000fe20000001808ULL, 0x0000312004047816ULL, 0x002fc400000000ffULL,
0x0000312005057816ULL, 0x000fe200000000ffULL, 0x0000006714149232ULL, 0x084fe20000000000ULL,
0x00000004ff20723eULL, 0x000fe200020006ffULL, 0x0000006716169232ULL, 0x000fe20000000000ULL,
0x0000312006287816ULL, 0x000fe200000000ffULL, 0x0000006615159232ULL, 0x080fe20000000000ULL,
0x0000312007297816ULL, 0x000fe200000000ffULL, 0x0000006617179232ULL, 0x000fe20000000000ULL,
0x00000028ff08723eULL, 0x000fe400020006ffULL, 0x00000029ff09723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe400030006ffULL, 0x00000029ff29723eULL, 0x000fe400030006ffULL,
0x00000005ff21723eULL, 0x080fe200020006ffULL, 0x000000081408723cULL, 0x000fe20000001824ULL,
0x00000004ff04723eULL, 0x000fe400030006ffULL, 0x00000005ff05723eULL, 0x000fca00030006ffULL,
0x000000281418723cULL, 0x000fe20000001818ULL, 0x000031200c0c7816ULL, 0x008fe400000000ffULL,
0x000031200d0d7816ULL, 0x000fca00000000ffULL, 0x000000201420723cULL, 0x040fe2000000182cULL,
0x0000000cff24723eULL, 0x080fe400020006ffULL, 0x0000000dff25723eULL, 0x080fe400020006ffULL,
0x000031200e287816ULL, 0x000fe400000000ffULL, 0x000031200f297816ULL, 0x000fe200000000ffULL,
0x000000041404723cULL, 0x000fe20000001830ULL, 0x0000000cff0c723eULL, 0x000fe400030006ffULL,
0x0000000dff0d723eULL, 0x000fca00030006ffULL, 0x00000024141c723cULL, 0x040fee000000181cULL,
0x00000028ff24723eULL, 0x080fe200020006ffULL, 0x0000000c140c723cULL, 0x000fe20000001834ULL,
0x00000029ff25723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fc400030006ffULL,
0x00000029ff29723eULL, 0x000fc600030006ffULL, 0x000000241424723cULL, 0x040ff00000001838ULL,
0x000000281414723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff127f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007844813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000803c107811ULL, 0x000fe200078e40ffULL,
0x00000100ff2f7424ULL, 0x000fe200078e00ffULL, 0x00000004ff2c7819ULL, 0x000fe40000011602ULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x000062003f2b7a24ULL, 0x000fc800078e0210ULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x0000000144107824ULL, 0x100fe400078e022bULL,
0x0000000149127824ULL, 0x100fe200078e022bULL, 0x0000002011137807ULL, 0x000fe20000000000ULL,
0x000000014a287824ULL, 0x000fe400078e022bULL, 0x00005e0010107625ULL, 0x000fe200078e002fULL,
0x000000133e297217ULL, 0x000fc60007800000ULL, 0x00005e0012127625ULL, 0x000fe200078e002fULL,
0x00000045102a7210ULL, 0x000fc60007f5e0ffULL, 0x00000001292d7824ULL, 0x000fe200078e0a3eULL,
0x0000004512127210ULL, 0x000fe20007f9e0ffULL, 0x00005e0028287625ULL, 0x000fc600078e002fULL,
0x0000002d4600720cULL, 0x000fe20003f66070ULL, 0x000000014b107824ULL, 0x000fe200078e022bULL,
0x0000004528287210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e0611ULL,
0x0000002d2c00720cULL, 0x000fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fc800078e002fULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000002d4700720cULL, 0x080fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x0000002d4800720cULL, 0x000fe40003fa6070ULL,
0x0000004510107210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a5b7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff117224ULL, 0x000fe400030e0611ULL,
0x00000000125c7faeULL, 0x0003e8000d901c46ULL, 0x00000000285d7faeULL, 0x0003e8000e101c46ULL,
0x00000000105e7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff327819ULL, 0x000fe40000011602ULL,
0x00005410102f7816ULL, 0x000fe20000000010ULL, 0x0000bda27f007947ULL, 0x000fea000b800000ULL,
0x00001f322f697589ULL, 0x0002a400000e0000ULL, 0x0000bde27f007947ULL, 0x000fea000b800000ULL,
0x00001f532f667589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0065ULL, 0x00004650002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000c97000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0054ULL, 0x000046b0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000c91000007944ULL, 0x01cfea0003c00000ULL, 0x0000a800602c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005f10783bULL, 0x000f680000004200ULL,
0x000000002c28783bULL, 0x000e680000000200ULL, 0x000000006134783bULL, 0x000ee20000004200ULL,
0x0000312010107816ULL, 0x020fc400000000ffULL, 0x0000312011117816ULL, 0x000fe200000000ffULL,
0x0000006928289232ULL, 0x086fe20000000000ULL, 0x00000010ff2e723eULL, 0x080fe200020006ffULL,
0x000000692a2a9232ULL, 0x000fe20000000000ULL, 0x00000011ff2f723eULL, 0x088fe200020006ffULL,
0x0000006629299232ULL, 0x090fe20000000000ULL, 0x00000010ff10723eULL, 0x000fe200030006ffULL,
0x000000662b2b9232ULL, 0x000fe20000000000ULL, 0x00000011ff11723eULL, 0x000fe400030006ffULL,
0x0000312012387816ULL, 0x000fc400000000ffULL, 0x0000312013397816ULL, 0x000fe400000000ffULL,
0x0000002e2820723cULL, 0x040fe20000001820ULL, 0x00000038ff30723eULL, 0x000fe400020006ffULL,
0x00000039ff31723eULL, 0x000fe400020006ffULL, 0x0000312034347816ULL, 0x000fe400000000ffULL,
0x0000312035357816ULL, 0x000fe200000000ffULL, 0x00000010282c723cULL, 0x000fe20000001804ULL,
0x000000006304783bULL, 0x000e620000004200ULL, 0x0000312036687816ULL, 0x000fc400000000ffULL,
0x00003120376a7816ULL, 0x000fe400000000ffULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x0000a80062107811ULL, 0x000fe200078e20ffULL, 0x000000302830723cULL, 0x000fe20000001808ULL,
0x00000039ff39723eULL, 0x000fc800030006ffULL, 0x000000001010783bULL, 0x000ea40000000200ULL,
0x00000034ff08723eULL, 0x080fe200020006ffULL, 0x000000382818723cULL, 0x040fe20000001818ULL,
0x00000035ff09723eULL, 0x080fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe400030006ffULL, 0x00000068ff38723eULL, 0x000fe200020006ffULL,
0x00000008281c723cULL, 0x000fe2000000181cULL, 0x000000006408783bULL, 0x000ee20000004200ULL,
0x0000006aff39723eULL, 0x000fcc00020006ffULL, 0x000000342834723cULL, 0x040fee000000180cULL,
0x00000068ff0c723eULL, 0x000fe200030006ffULL, 0x000000382838723cULL, 0x000fe20000001824ULL,
0x0000006aff0d723eULL, 0x000fe400030006ffULL, 0x0000312004047816ULL, 0x002fc400000000ffULL,
0x0000312005057816ULL, 0x000fc600000000ffULL, 0x0000000c280c723cULL, 0x000fe20000001814ULL,
0x0000006910109232ULL, 0x084fe40000000000ULL, 0x0000006912129232ULL, 0x000fc80000000000ULL,
0x00000004ff14723eULL, 0x080fe200020006ffULL, 0x0000006611119232ULL, 0x080fe20000000000ULL,
0x00000005ff15723eULL, 0x080fe200020006ffULL, 0x0000006613139232ULL, 0x000fe20000000000ULL,
0x00000004ff04723eULL, 0x000fe400030006ffULL, 0x00000005ff05723eULL, 0x000fe400030006ffULL,
0x0000312008087816ULL, 0x008fe400000000ffULL, 0x000000141014723cULL, 0x000fe20000001820ULL,
0x0000312009097816ULL, 0x000fc400000000ffULL, 0x000031200a287816ULL, 0x000fe400000000ffULL,
0x000031200b297816ULL, 0x000fe400000000ffULL, 0x0000312006207816ULL, 0x000fe400000000ffULL,
0x0000312007217816ULL, 0x000fe400000000ffULL, 0x00000020ff24723eULL, 0x000fe200020006ffULL,
0x000000041004723cULL, 0x000fe2000000182cULL, 0x00000021ff25723eULL, 0x000fc400020006ffULL,
0x00000020ff20723eULL, 0x000fe400030006ffULL, 0x00000021ff21723eULL, 0x000fc600030006ffULL,
0x000000241024723cULL, 0x040ff00000001830ULL, 0x000000201018723cULL, 0x000fee0000001818ULL,
0x00000008ff20723eULL, 0x000fc400020006ffULL, 0x00000009ff21723eULL, 0x080fe400020006ffULL,
0x00000008ff08723eULL, 0x000fe400030006ffULL, 0x00000009ff09723eULL, 0x000fc600030006ffULL,
0x00000020101c723cULL, 0x040fee000000181cULL, 0x00000028ff20723eULL, 0x080fe200020006ffULL,
0x000000081008723cULL, 0x000fe20000001834ULL, 0x00000029ff21723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fc400030006ffULL, 0x00000029ff29723eULL, 0x000fc600030006ffULL,
0x000000201020723cULL, 0x040ff00000001838ULL, 0x000000281010723cULL, 0x000fe2000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000803c0c7811ULL, 0x002fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000000c0300720cULL, 0x000fda0003f24070ULL, 0x00003b0000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000782480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a03c0c7811ULL, 0x000fe200078e40ffULL, 0x00000100ff2f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff2c7819ULL, 0x000fe40000011602ULL, 0x0000000c030d7217ULL, 0x000fe20007800000ULL,
0x000062003f287a24ULL, 0x000fc800078e020cULL, 0x000000010d0d7824ULL, 0x000fe400078e0a0cULL,
0x00000001440c7824ULL, 0x100fe400078e0228ULL, 0x00000001490e7824ULL, 0x000fe200078e0228ULL,
0x000000200d0f7807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fc600078e002fULL,
0x0000000f3e297217ULL, 0x000fe20007800000ULL, 0x00005e000e0e7625ULL, 0x000fe200078e002fULL,
0x000000450c2a7210ULL, 0x000fc60007f3e0ffULL, 0x00000001292d7824ULL, 0x000fe200078e0a3eULL,
0x000000450e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000014a0c7824ULL, 0x100fe400078e0228ULL,
0x000000014b287824ULL, 0x000fe200078e0228ULL, 0x0000002d2c00720cULL, 0x080fe20003f46070ULL,
0x000000ffff2b7224ULL, 0x000fe200008e060dULL, 0x0000002d4600720cULL, 0x000fe20003f26070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e002fULL, 0x0000002d4800720cULL, 0x000fc60003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e002fULL, 0x000000450c0c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e060fULL, 0x0000002d4700720cULL, 0x000fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000004528287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a4c7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x000000000e4d7faeULL, 0x0003ea000c901c46ULL,
0x000000000c4e7faeULL, 0x0003e8000d901c46ULL, 0x00000000284f7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff387f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff0c7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648003e0e7f8cULL, 0x000fe2000c80043fULL, 0x800000000cff7812ULL, 0x002fc60007844867ULL,
0x01064c003e0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000782480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002e4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x008fe40003800000ULL, 0x01064c003e0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01010000500f7984ULL, 0x000e680000000800ULL, 0x01030000500e7984ULL, 0x0007220000000800ULL,
0x000000400f00720bULL, 0x002fe20003f3d000ULL, 0x0000b1d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff0c297812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f65270ULL,
0x000000400f00720bULL, 0x000fe20003f34000ULL, 0x0000b1a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x000fe400008e0100ULL, 0x0000000f400d7209ULL, 0x000fe40007810000ULL,
0x0000ffff0c0c7812ULL, 0x000fe400078e3cffULL, 0x00000002ff327819ULL, 0x000fe20000011602ULL,
0x8000000d40287221ULL, 0x000fe20000010000ULL, 0x0105000d5000b388ULL, 0x0003e20000000800ULL,
0x0000000c29ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x00000028002f7308ULL, 0x000ee40000000800ULL, 0x0000002f41417220ULL, 0x008fe20000410000ULL,
0x0000b1427f007947ULL, 0x000fea000b800000ULL, 0x00001f322f2e7589ULL, 0x0022e400000e0000ULL,
0x0000002e14147220ULL, 0x08cfe20000410000ULL, 0x0000002e15157220ULL, 0x080fe20000410000ULL,
0x0000002e04047220ULL, 0x080fe20000410000ULL, 0x0000002e05057220ULL, 0x080fe20000410000ULL,
0x0000002e24247220ULL, 0x080fe20000410000ULL, 0x0000002e25257220ULL, 0x080fe20000410000ULL,
0x0000002e18187220ULL, 0x080fe20000410000ULL, 0x0000002e19197220ULL, 0x080fe20000410000ULL,
0x0000002e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002e08087220ULL, 0x080fe20000410000ULL, 0x0000002e09097220ULL, 0x080fe20000410000ULL,
0x0000002e20207220ULL, 0x080fe20000410000ULL, 0x0000002e21217220ULL, 0x080fe20000410000ULL,
0x0000002e10107220ULL, 0x080fe20000410000ULL, 0x0000002e11117220ULL, 0x000fe20000410000ULL,
0x0000b0727f007947ULL, 0x000fea000b800000ULL, 0x00001f532f2e7589ULL, 0x0004e400000e0000ULL,
0x0000000f40407209ULL, 0x000fe20007810000ULL, 0x0000002e16167220ULL, 0x08cfe20000410000ULL,
0x00000001ff0d7807ULL, 0x000fe20000800000ULL, 0x0000002e17177220ULL, 0x080fe20000410000ULL,
0x0000002e06067220ULL, 0x080fe20000410000ULL, 0x800000400f0f1221ULL, 0x000fe20000010000ULL,
0x0000002e07077220ULL, 0x080fe20000410000ULL, 0x0000002e26267220ULL, 0x080fe20000410000ULL,
0x0000002e27277220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b0f0f1820ULL, 0x000fe20000410000ULL,
0x0000002e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f00521308ULL, 0x000ea20000000800ULL,
0x0000002e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002e0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002e0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002e22227220ULL, 0x080fe20000410000ULL,
0x0000002e23237220ULL, 0x080fe20000410000ULL, 0x0000002e12127220ULL, 0x080fe20000410000ULL,
0x0000002e13137220ULL, 0x000fe20000410000ULL, 0x0000000e520e1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000410e417221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0c7984ULL, 0x000ee40000000800ULL, 0x800000000cff7812ULL, 0x008fc40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000e7305ULL, 0x000724000021f000ULL,
0x3fa000000c0c7823ULL, 0x008fe200000100ffULL, 0x0000000e0000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff0e7984ULL, 0x000ee40000000800ULL, 0x800000000eff7812ULL, 0x008fe40007824867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff327819ULL, 0x002fc40000011602ULL, 0x000054100c2f7816ULL, 0x000fe2000000000cULL,
0x0000ae127f007947ULL, 0x000fea000b800000ULL, 0x00001f322f3b7589ULL, 0x0002e400000e0000ULL,
0x0000ae527f007947ULL, 0x000fea000b800000ULL, 0x00001f532f3a7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0065ULL,
0x00005800002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000b7c000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0054ULL,
0x00005860002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000b76000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b000552d7811ULL, 0x000fe200078e20ffULL,
0x000000005630783bULL, 0x002e620000004200ULL, 0x000099100d0c7816ULL, 0x000fc800000000ffULL,
0x000000002d2c783bULL, 0x014ea20000000200ULL, 0x000000ff0c00720cULL, 0x000fc60003f25270ULL,
0x00000000570c783bULL, 0x000f220000004200ULL, 0x0000312030307816ULL, 0x002fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x00000030ff28723eULL, 0x000fca00020006ffULL,
0x0000003b2c2c9232ULL, 0x08cfe20000000000ULL, 0x00000031ff29723eULL, 0x080fe200020006ffULL,
0x0000003b2e2e9232ULL, 0x000fe20000000000ULL, 0x00000030ff30723eULL, 0x000fe200030006ffULL,
0x0000003a2d2d9232ULL, 0x080fe20000000000ULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x0000003a2f2f9232ULL, 0x000fe20000000000ULL, 0x0000312032347816ULL, 0x000fe400000000ffULL,
0x0000312033357816ULL, 0x000fe400000000ffULL, 0x000031200c0c7816ULL, 0x010fc400000000ffULL,
0x000000302c30723cULL, 0x040fe20000001804ULL, 0x000031200d0d7816ULL, 0x000fe400000000ffULL,
0x000031200e667816ULL, 0x000fe400000000ffULL, 0x000031200f677816ULL, 0x000fe400000000ffULL,
0x00000034ff04723eULL, 0x080fe200020006ffULL, 0x000000282c28723cULL, 0x000fe20000001814ULL,
0x00000035ff05723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fc400030006ffULL,
0x00000035ff35723eULL, 0x000fe400030006ffULL, 0x0000b00058147811ULL, 0x000fe200078e20ffULL,
0x000000042c24723cULL, 0x040fe20000001824ULL, 0x000000005a04783bULL, 0x000e680000004200ULL,
0x000000001414783bULL, 0x000ea60000000200ULL, 0x000000342c18723cULL, 0x000fee0000001818ULL,
0x0000000cff34723eULL, 0x000fc400020006ffULL, 0x0000000dff35723eULL, 0x000fce00020006ffULL,
0x000000342c1c723cULL, 0x040fee000000181cULL, 0x0000000cff34723eULL, 0x000fe400030006ffULL,
0x0000000dff35723eULL, 0x000fe400030006ffULL, 0x00000000590c783bULL, 0x000eea0000004200ULL,
0x000000342c34723cULL, 0x000fe20000001808ULL, 0x0000312004047816ULL, 0x002fc400000000ffULL,
0x0000312005057816ULL, 0x000fe200000000ffULL, 0x0000003b14149232ULL, 0x004fc60000000000ULL,
0x00000066ff08723eULL, 0x080fe200020006ffULL, 0x0000003b16169232ULL, 0x000fe20000000000ULL,
0x00000067ff09723eULL, 0x080fe200020006ffULL, 0x0000003a15159232ULL, 0x080fe20000000000ULL,
0x00000066ff66723eULL, 0x000fe200030006ffULL, 0x0000003a17179232ULL, 0x000fe20000000000ULL,
0x00000067ff67723eULL, 0x000fc600030006ffULL, 0x000000082c20723cULL, 0x040fee0000001820ULL,
0x00000004ff08723eULL, 0x080fe200020006ffULL, 0x000000662c10723cULL, 0x000fe20000001810ULL,
0x00000005ff09723eULL, 0x000fe400020006ffULL, 0x00000004ff04723eULL, 0x000fc400030006ffULL,
0x00000005ff05723eULL, 0x000fe400030006ffULL, 0x00003120062c7816ULL, 0x000fe200000000ffULL,
0x000000081428723cULL, 0x040fe20000001828ULL, 0x00003120072d7816ULL, 0x000fe400000000ffULL,
0x000031200c0c7816ULL, 0x008fe400000000ffULL, 0x000031200d0d7816ULL, 0x000fe400000000ffULL,
0x0000002cff08723eULL, 0x000fe200020006ffULL, 0x000000041404723cULL, 0x000fe20000001830ULL,
0x0000002dff09723eULL, 0x000fc400020006ffULL, 0x000031200e0e7816ULL, 0x000fe400000000ffULL,
0x000031200f0f7816ULL, 0x000fe400000000ffULL, 0x0000002cff2c723eULL, 0x000fe200030006ffULL,
0x000000081408723cULL, 0x000fe20000001824ULL, 0x0000002dff2d723eULL, 0x000fcc00030006ffULL,
0x0000000cff24723eULL, 0x080fe200020006ffULL, 0x0000002c1418723cULL, 0x000fe20000001818ULL,
0x0000000dff25723eULL, 0x080fe400020006ffULL, 0x0000000cff0c723eULL, 0x000fe400030006ffULL,
0x0000000dff0d723eULL, 0x000fc600030006ffULL, 0x00000024141c723cULL, 0x040ff0000000181cULL,
0x0000000c1434723cULL, 0x000fee0000001834ULL, 0x0000000eff0c723eULL, 0x000fc400020006ffULL,
0x0000000fff0d723eULL, 0x080fe400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400030006ffULL,
0x0000000fff0f723eULL, 0x000fc600030006ffULL, 0x0000000c1420723cULL, 0x040ff00000001820ULL,
0x0000000e1414723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff0e7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000784480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000784480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000784480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c03c0c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x00000004ff247819ULL, 0x000fe40000011602ULL,
0x0000000c030d7217ULL, 0x000fe20007800000ULL, 0x000062003f137a24ULL, 0x000fc800078e020cULL,
0x000000010d0d7824ULL, 0x000fe400078e0a0cULL, 0x00000001440c7824ULL, 0x100fe400078e0213ULL,
0x00000001490e7824ULL, 0x100fe200078e0213ULL, 0x000000200d0f7807ULL, 0x000fe20000000000ULL,
0x000000014a107824ULL, 0x000fe400078e0213ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0027ULL,
0x0000000f3e117217ULL, 0x000fc60007800000ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0027ULL,
0x000000450c127210ULL, 0x000fc60007f5e0ffULL, 0x0000000111257824ULL, 0x000fe200078e0a3eULL,
0x000000450e0e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0010107625ULL, 0x000fc600078e0027ULL,
0x000000254600720cULL, 0x000fe20003f66070ULL, 0x000000014b0c7824ULL, 0x000fe200078e0213ULL,
0x0000004510107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e060dULL,
0x000000252400720cULL, 0x000fe20003f46070ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0027ULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x000000254700720cULL, 0x080fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x000000254800720cULL, 0x000fe40003fa6070ULL,
0x000000450c0c7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000125b7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0d7224ULL, 0x000fe400030e060dULL,
0x000000000e5c7faeULL, 0x0003e8000d901c46ULL, 0x00000000105d7faeULL, 0x0003e8000e101c46ULL,
0x000000000c5e7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff0d7984ULL, 0x002e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007844839ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007844839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x0106b400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc40007844839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff327819ULL, 0x000fe40000011602ULL,
0x000054100c2f7816ULL, 0x000fe2000000000cULL, 0x0000a3127f007947ULL, 0x000fea000b800000ULL,
0x00001f322f397589ULL, 0x0002a400000e0000ULL, 0x0000a3527f007947ULL, 0x000fea000b800000ULL,
0x00001f532f387589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0065ULL, 0x000063d0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000abf000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0054ULL, 0x00006430002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000ab9000007944ULL, 0x01cfea0003c00000ULL, 0x0000b00060247811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005f10783bULL, 0x000f680000004200ULL,
0x00000000240c783bULL, 0x000e680000000200ULL, 0x000000006130783bULL, 0x002e620000004200ULL,
0x0000312010107816ULL, 0x020fc400000000ffULL, 0x0000312011117816ULL, 0x000fe200000000ffULL,
0x000000390c0c9232ULL, 0x084fe20000000000ULL, 0x00000010ff2c723eULL, 0x080fe200020006ffULL,
0x000000390e0e9232ULL, 0x000fe20000000000ULL, 0x00000011ff2d723eULL, 0x080fe200020006ffULL,
0x000000380d0d9232ULL, 0x090fe20000000000ULL, 0x00000010ff10723eULL, 0x000fe200030006ffULL,
0x000000380f0f9232ULL, 0x000fe20000000000ULL, 0x00000011ff11723eULL, 0x000fe400030006ffULL,
0x00003120123a7816ULL, 0x000fc400000000ffULL, 0x00003120133b7816ULL, 0x000fe400000000ffULL,
0x0000002c0c2c723cULL, 0x048fe20000001828ULL, 0x0000003aff24723eULL, 0x000fe400020006ffULL,
0x0000003bff25723eULL, 0x000fe400020006ffULL, 0x0000312030307816ULL, 0x002fe400000000ffULL,
0x0000312031317816ULL, 0x000fe200000000ffULL, 0x000000100c28723cULL, 0x000fe20000001804ULL,
0x000000006304783bULL, 0x000e620000004200ULL, 0x0000312032327816ULL, 0x000fc400000000ffULL,
0x0000312033337816ULL, 0x000fe400000000ffULL, 0x0000003aff3a723eULL, 0x000fe400030006ffULL,
0x0000b00062107811ULL, 0x000fe200078e20ffULL, 0x000000240c24723cULL, 0x000fe20000001808ULL,
0x0000003bff3b723eULL, 0x000fc800030006ffULL, 0x000000001010783bULL, 0x000ea40000000200ULL,
0x00000030ff08723eULL, 0x080fe200020006ffULL, 0x0000003a0c18723cULL, 0x000fe20000001818ULL,
0x00000031ff09723eULL, 0x080fe400020006ffULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000080c1c723cULL, 0x040fee000000181cULL,
0x00000032ff08723eULL, 0x080fe200020006ffULL, 0x000000300c34723cULL, 0x000fe20000001834ULL,
0x00000033ff09723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fc400030006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x000000080c20723cULL, 0x000fe20000001820ULL,
0x000000006408783bULL, 0x000ee20000004200ULL, 0x0000312004047816ULL, 0x002fe400000000ffULL,
0x0000312005057816ULL, 0x000fc800000000ffULL, 0x000000320c0c723cULL, 0x000fe20000001814ULL,
0x0000003910109232ULL, 0x084fe40000000000ULL, 0x0000003912129232ULL, 0x000fc80000000000ULL,
0x00000004ff14723eULL, 0x080fe200020006ffULL, 0x0000003811119232ULL, 0x080fe20000000000ULL,
0x00000005ff15723eULL, 0x080fe200020006ffULL, 0x0000003813139232ULL, 0x000fe20000000000ULL,
0x00000004ff04723eULL, 0x000fe400030006ffULL, 0x00000005ff05723eULL, 0x000fc800030006ffULL,
0x000000141014723cULL, 0x040fee000000182cULL, 0x00003120062c7816ULL, 0x000fe400000000ffULL,
0x00003120072d7816ULL, 0x000fe400000000ffULL, 0x000000041004723cULL, 0x000fe20000001828ULL,
0x0000312008087816ULL, 0x008fc400000000ffULL, 0x0000312009097816ULL, 0x000fc800000000ffULL,
0x0000002cff28723eULL, 0x080fe400020006ffULL, 0x0000002dff29723eULL, 0x080fe400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x000000281024723cULL, 0x040fee0000001824ULL, 0x00000008ff28723eULL, 0x080fe200020006ffULL,
0x0000002c1018723cULL, 0x000fe20000001818ULL, 0x00000009ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff08723eULL, 0x000fc400030006ffULL, 0x00000009ff09723eULL, 0x000fc600030006ffULL,
0x00000028101c723cULL, 0x040fee000000181cULL, 0x000031200a287816ULL, 0x000fe400000000ffULL,
0x000031200b297816ULL, 0x000fe400000000ffULL, 0x00000028ff2a723eULL, 0x000fe200020006ffULL,
0x000000081008723cULL, 0x000fe20000001834ULL, 0x00000029ff2b723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe400030006ffULL, 0x00000029ff29723eULL, 0x000fc600030006ffULL,
0x0000002a1020723cULL, 0x040ff00000001820ULL, 0x000000281010723cULL, 0x000fe2000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c03c0c7811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000000c0300720cULL, 0x000fda0003f24070ULL, 0x00001d8000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000782480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000782480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000e03c0c7811ULL, 0x000fe200078e40ffULL, 0x00000100ff2e7424ULL, 0x000fe200078e00ffULL,
0x00000004ff2c7819ULL, 0x000fe40000011602ULL, 0x0000000c030d7217ULL, 0x000fe20007800000ULL,
0x000062003f0e7a24ULL, 0x000fc800078e020cULL, 0x000000010d0d7824ULL, 0x000fe400078e0a0cULL,
0x00000001440c7824ULL, 0x100fe400078e020eULL, 0x0000000149287824ULL, 0x000fe200078e020eULL,
0x000000200d0f7807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fc600078e002eULL,
0x0000000f3e0f7217ULL, 0x000fe20007800000ULL, 0x000000014b297824ULL, 0x000fe200078e020eULL,
0x000000450c2a7210ULL, 0x000fc60007f1e0ffULL, 0x000000010f2d7824ULL, 0x000fe400078e0a3eULL,
0x000000014a0f7824ULL, 0x000fe400078e020eULL, 0x000000ffff2b7224ULL, 0x000fe200000e060dULL,
0x0000002d2c00720cULL, 0x080fe20003f06070ULL, 0x00005e00280c7625ULL, 0x080fe200078e002eULL,
0x0000002d4600720cULL, 0x080fe40003f26070ULL, 0x0000002d4700720cULL, 0x080fe20003f46070ULL,
0x00005e000f0e7625ULL, 0x000fe200078e002eULL, 0x0000002d4800720cULL, 0x000fc40003f66070ULL,
0x000000450c0c7210ULL, 0x080fe20007f9e0ffULL, 0x00005e0029287625ULL, 0x000fe200078e002eULL,
0x000000450e0e7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000004528287210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a4c7faeULL, 0x0003e6000c101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x000000000c4d7faeULL, 0x0003e8000c901c46ULL,
0x000000000e4e7faeULL, 0x0003e8000d101c46ULL, 0x00000000284f7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff287f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff0c7984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010668003e0e7f8cULL, 0x000fe2000c80043fULL, 0x800000000cff7812ULL, 0x004fc60007804867ULL,
0x01066c003e0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe4000782480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0004e4000021f000ULL, 0x3fa000000c0c7823ULL, 0x004fe200000100ffULL,
0x0000000d0000735dULL, 0x008fe40003800000ULL, 0x01066c003e0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01018000500f7984ULL, 0x000ea80000000800ULL, 0x01038000500e7984ULL, 0x0007220000000800ULL,
0x000000400f00720bULL, 0x004fe20003f3d000ULL, 0x000097427f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff0c2c7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2a7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f45270ULL,
0x000000400f00720bULL, 0x000fe20003f34000ULL, 0x000097127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x000fe400008e0100ULL, 0x0000000f40337209ULL, 0x000fe40007810000ULL,
0x0000ffff0c2b7812ULL, 0x000fe400078e3cffULL, 0x00000002ff327819ULL, 0x000fe20000011602ULL,
0x80000033400d7221ULL, 0x000fe20000010000ULL, 0x010580335000a388ULL, 0x0005e20000000800ULL,
0x0000002b2cff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d002f7308ULL, 0x000ee40000000800ULL, 0x0000002f41417220ULL, 0x008fe20000410000ULL,
0x000096b27f007947ULL, 0x000fea000b800000ULL, 0x00001f322f2e7589ULL, 0x0044e400000e0000ULL,
0x0000002e14147220ULL, 0x08cfe20000410000ULL, 0x0000002e15157220ULL, 0x080fe20000410000ULL,
0x0000002e04047220ULL, 0x080fe20000410000ULL, 0x0000002e05057220ULL, 0x080fe20000410000ULL,
0x0000002e24247220ULL, 0x080fe20000410000ULL, 0x0000002e25257220ULL, 0x080fe20000410000ULL,
0x0000002e18187220ULL, 0x080fe20000410000ULL, 0x0000002e19197220ULL, 0x080fe20000410000ULL,
0x0000002e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002e08087220ULL, 0x080fe20000410000ULL, 0x0000002e09097220ULL, 0x080fe20000410000ULL,
0x0000002e20207220ULL, 0x080fe20000410000ULL, 0x0000002e21217220ULL, 0x080fe20000410000ULL,
0x0000002e10107220ULL, 0x080fe20000410000ULL, 0x0000002e11117220ULL, 0x000fe20000410000ULL,
0x000095e27f007947ULL, 0x000fea000b800000ULL, 0x00001f532f2e7589ULL, 0x0004e400000e0000ULL,
0x800000330f0f1221ULL, 0x100fe20000010000ULL, 0x00000001ff2a7807ULL, 0x000fe20000800000ULL,
0x0000002e16167220ULL, 0x08cfe20000410000ULL, 0x0000002e17177220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fe20000410000ULL, 0x0000002e06067220ULL, 0x080fe20000410000ULL,
0x0000002e07077220ULL, 0x080fe20000410000ULL, 0x0000002e26267220ULL, 0x080fe20000410000ULL,
0x0000000f00521308ULL, 0x000ea20000000800ULL, 0x0000002e27277220ULL, 0x080fe20000410000ULL,
0x0000002e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002e0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002e0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002e22227220ULL, 0x080fe20000410000ULL, 0x0000002e23237220ULL, 0x080fe20000410000ULL,
0x0000002e12127220ULL, 0x080fe20000410000ULL, 0x0000002e13137220ULL, 0x000fe20000410000ULL,
0x000000ffff407224ULL, 0x000fe200078e0033ULL, 0x0000000e520e1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000410e417221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fc40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0004e4000021f000ULL,
0x3fa000000c0c7823ULL, 0x004fe200000100ffULL, 0x0000000d0000735dULL, 0x008fe20003800000ULL,
0x0106ac00ff0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff327819ULL, 0x002fc40000011602ULL, 0x000054100c2f7816ULL, 0x000fe2000000000cULL,
0x000093827f007947ULL, 0x000fea000b800000ULL, 0x00001f322f2b7589ULL, 0x0002a400000e0000ULL,
0x000093c27f007947ULL, 0x000fea000b800000ULL, 0x00001f532f4c7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0065ULL,
0x00007580002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00009a4000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0054ULL,
0x000075e0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000099e000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000b800550d7811ULL, 0x000fe200078e20ffULL,
0x000000005630783bULL, 0x002e620000004200ULL, 0x000099102a2a7816ULL, 0x000fc400000000ffULL,
0x0000b80058587811ULL, 0x000fe200078e20ffULL, 0x00000000572c783bULL, 0x00cfe20000004200ULL,
0x000000ff2a00720cULL, 0x000fc60003f05270ULL, 0x000000000d0c783bULL, 0x000ea20000000200ULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x00000030ff34723eULL, 0x000fe400020006ffULL, 0x00000031ff35723eULL, 0x000fc600020006ffULL,
0x0000002b0c0c8232ULL, 0x084fe20000000000ULL, 0x00000030ff30723eULL, 0x000fe200030006ffULL,
0x0000002b0e0e8232ULL, 0x000fe20000000000ULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x0000004c0d0d8232ULL, 0x090fe20000000000ULL, 0x00003120322a7816ULL, 0x000fe200000000ffULL,
0x0000004c0f0f8232ULL, 0x000fe20000000000ULL, 0x0000312033397816ULL, 0x000fe400000000ffULL,
0x0000002aff38723eULL, 0x000fe400030006ffULL, 0x000031202c2c7816ULL, 0x000fc400000000ffULL,
0x000000300c04723cULL, 0x000fe20000001804ULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x000031202f4f7816ULL, 0x000fc800000000ffULL, 0x0000002aff30723eULL, 0x000fe200020006ffULL,
0x000000340c14723cULL, 0x000fe20000001814ULL, 0x00000039ff31723eULL, 0x080fe200020006ffULL,
0x000000005a34783bULL, 0x000e620000004200ULL, 0x00000039ff39723eULL, 0x000fe400030006ffULL,
0x000031202e2a7816ULL, 0x000fc600000000ffULL, 0x000000300c30723cULL, 0x000fe20000001824ULL,
0x000000005824783bULL, 0x000ea20000000200ULL, 0x0000002aff4e723eULL, 0x000fcc00030006ffULL,
0x000000380c18723cULL, 0x000fee0000001818ULL, 0x0000002cff38723eULL, 0x080fe400020006ffULL,
0x0000002dff39723eULL, 0x000fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fc400030006ffULL,
0x0000002dff2d723eULL, 0x000fc600030006ffULL, 0x000000380c1c723cULL, 0x040fe2000000181cULL,
0x000000005938783bULL, 0x000eee0000004200ULL, 0x0000002c0c2c723cULL, 0x000fe20000001808ULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x0000312035357816ULL, 0x000fc400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x0000002aff08723eULL, 0x000fe200020006ffULL,
0x0000002b24248232ULL, 0x084fe20000000000ULL, 0x0000004fff09723eULL, 0x080fe200020006ffULL,
0x0000002b26268232ULL, 0x000fe20000000000ULL, 0x0000004fff4f723eULL, 0x000fe200030006ffULL,
0x0000004c25258232ULL, 0x080fe40000000000ULL, 0x0000004c27278232ULL, 0x000fe40000000000ULL,
0x000000080c20723cULL, 0x040fee0000001820ULL, 0x00000034ff08723eULL, 0x000fe200020006ffULL,
0x0000004e0c4c723cULL, 0x000fe20000001810ULL, 0x00000035ff09723eULL, 0x000fcc00020006ffULL,
0x00000034ff0c723eULL, 0x000fe200030006ffULL, 0x000000082408723cULL, 0x000fe20000001814ULL,
0x0000312038387816ULL, 0x008fe400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x00000035ff0d723eULL, 0x000fe400030006ffULL, 0x0000312037157816ULL, 0x000fe400000000ffULL,
0x00000036ff14723eULL, 0x000fc400030006ffULL, 0x00000015ff11723eULL, 0x080fe200020006ffULL,
0x0000000c240c723cULL, 0x040fe20000001804ULL, 0x00000015ff15723eULL, 0x000fe400030006ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe400000000ffULL,
0x00000036ff10723eULL, 0x000fe200020006ffULL, 0x000000142414723cULL, 0x000fe20000001818ULL,
0x0000003aff04723eULL, 0x000fc400020006ffULL, 0x0000003bff05723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400030006ffULL, 0x00000038ff18723eULL, 0x000fe200020006ffULL,
0x000000102410723cULL, 0x000fe20000001830ULL, 0x00000039ff19723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fca00030006ffULL, 0x000000182418723cULL, 0x040fee000000181cULL,
0x00000038ff1c723eULL, 0x000fe200030006ffULL, 0x000000042420723cULL, 0x000fe20000001820ULL,
0x00000039ff1d723eULL, 0x000fce00030006ffULL, 0x0000001c241c723cULL, 0x040ff0000000182cULL,
0x0000003a2424723cULL, 0x000fe2000000184cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff067f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007824807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000003003c047a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x00000004ff2e7819ULL, 0x000fc60000011602ULL,
0x0000010004067824ULL, 0x040fe200078e00ffULL, 0x0000000104047810ULL, 0x000fc60007ffe0ffULL,
0x000062003f2a7a24ULL, 0x000fe200078e0206ULL, 0x0000000603057217ULL, 0x000fe40007800000ULL,
0x0000003d0400720cULL, 0x000fe20003f26070ULL, 0x0000000144047824ULL, 0x000fe400078e022aULL,
0x0000000105057824ULL, 0x000fe400078e0a06ULL, 0x0000000149067824ULL, 0x000fc600078e022aULL,
0x0000002005077807ULL, 0x000fe20000800000ULL, 0x00005e0004047625ULL, 0x000fc600078e0031ULL,
0x000000073e2b7217ULL, 0x000fe20007800000ULL, 0x00005e0006067625ULL, 0x000fe200078e0031ULL,
0x00000045042c7210ULL, 0x000fc60007f3e0ffULL, 0x000000012b2f7824ULL, 0x000fe200078e0a3eULL,
0x0000004506067210ULL, 0x000fe20007f7e0ffULL, 0x000000014a047824ULL, 0x100fe400078e022aULL,
0x000000014b2a7824ULL, 0x000fe200078e022aULL, 0x0000002f2e00720cULL, 0x080fe20003f46070ULL,
0x000000ffff2d7224ULL, 0x000fe200008e0605ULL, 0x0000002f4600720cULL, 0x000fe20003f26070ULL,
0x00005e0004047625ULL, 0x000fe200078e0031ULL, 0x0000002f4800720cULL, 0x000fc60003f86070ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0031ULL, 0x0000004504047210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0x0000002f4700720cULL, 0x000fe20003f66070ULL,
0x000000ffff057224ULL, 0x000fe200028e0605ULL, 0x000000452a2a7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c5b7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x00000000065c7faeULL, 0x0003ea000c901c46ULL,
0x00000000045d7faeULL, 0x0003e8000d901c46ULL, 0x000000002a5e7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff667f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff057984ULL, 0x002e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007824829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff327819ULL, 0x000fe40000011602ULL, 0x00005410042f7816ULL, 0x000fe20000000004ULL,
0x000088527f007947ULL, 0x000fea000b800000ULL, 0x00001f322f057589ULL, 0x0002a400000e0000ULL,
0x000088927f007947ULL, 0x000fea000b800000ULL, 0x00001f532f047589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0065ULL,
0x00008180002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00008e4000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff327224ULL, 0x002fe200078e0054ULL,
0x000081e0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00008de000007944ULL, 0x01cfea0003c00000ULL,
0x0000b80060607811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005f5c783bULL, 0x000f620000004200ULL, 0x0000b80062627811ULL, 0x000fc600078e20ffULL,
0x000000006028783bULL, 0x000e680000000200ULL, 0x00000000612c783bULL, 0x00ee620000004200ULL,
0x000031205c5c7816ULL, 0x020fe400000000ffULL, 0x000031205d5d7816ULL, 0x000fe200000000ffULL,
0x0000000528288232ULL, 0x080fe20000000000ULL, 0x0000005cff06723eULL, 0x000fe200020006ffULL,
0x000000052a2a8232ULL, 0x000fe20000000000ULL, 0x0000005dff07723eULL, 0x000fe200020006ffULL,
0x0000000429298232ULL, 0x090fe20000000000ULL, 0x000031205e5e7816ULL, 0x000fe200000000ffULL,
0x000000042b2b8232ULL, 0x000fe20000000000ULL, 0x000031205f5f7816ULL, 0x000fc400000000ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fe400030006ffULL,
0x000000062830723cULL, 0x000fe20000001808ULL, 0x000000006308783bULL, 0x000ea20000004200ULL,
0x000031202c2c7816ULL, 0x002fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x000031202e2e7816ULL, 0x000fc400000000ffULL, 0x0000005eff06723eULL, 0x080fe200020006ffULL,
0x0000005c2834723cULL, 0x040fe2000000180cULL, 0x0000005fff07723eULL, 0x080fe200020006ffULL,
0x00000000640c783bULL, 0x000e620000004200ULL, 0x000031202f2f7816ULL, 0x000fe400000000ffULL,
0x0000005eff5e723eULL, 0x000fe400030006ffULL, 0x0000005fff5f723eULL, 0x000fe200030006ffULL,
0x000000062838723cULL, 0x040fe20000001810ULL, 0x000000006210783bULL, 0x000eec0000000200ULL,
0x0000002cff06723eULL, 0x000fe200020006ffULL, 0x0000005e285c723cULL, 0x000fe20000001814ULL,
0x0000002dff07723eULL, 0x000fc400020006ffULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fc600030006ffULL, 0x000000062844723cULL, 0x040fee0000001818ULL,
0x0000002eff06723eULL, 0x080fe200020006ffULL, 0x0000002c2848723cULL, 0x000fe2000000181cULL,
0x0000002fff07723eULL, 0x000fe400020006ffULL, 0x0000002eff2e723eULL, 0x000fc400030006ffULL,
0x0000002fff2f723eULL, 0x000fe400030006ffULL, 0x000031200a0a7816ULL, 0x004fe200000000ffULL,
0x00000006284c723cULL, 0x040fe20000001820ULL, 0x000031200b0b7816ULL, 0x000fe400000000ffULL,
0x0000312008087816ULL, 0x000fe400000000ffULL, 0x000031200c0c7816ULL, 0x002fe400000000ffULL,
0x000031200e0e7816ULL, 0x000fe200000000ffULL, 0x0000002e2828723cULL, 0x000fe20000001824ULL,
0x0000000510108232ULL, 0x088fe20000000000ULL, 0x000031200f0f7816ULL, 0x000fe200000000ffULL,
0x0000000512128232ULL, 0x000fe20000000000ULL, 0x0000312009057816ULL, 0x000fe200000000ffULL,
0x0000000411118232ULL, 0x080fe20000000000ULL, 0x000031200d097816ULL, 0x000fe200000000ffULL,
0x0000000413138232ULL, 0x000fe20000000000ULL, 0x0000000aff24723eULL, 0x000fc400020006ffULL,
0x0000000bff25723eULL, 0x000fe400020006ffULL, 0x00000008ff14723eULL, 0x080fe400020006ffULL,
0x00000005ff15723eULL, 0x000fe400020006ffULL, 0x00000008ff04723eULL, 0x000fe200030006ffULL,
0x000000241024723cULL, 0x000fe20000001838ULL, 0x0000000aff0a723eULL, 0x000fe400030006ffULL,
0x0000000bff0b723eULL, 0x000fc400030006ffULL, 0x00000009ff1d723eULL, 0x000fe400020006ffULL,
0x00000005ff05723eULL, 0x000fe200030006ffULL, 0x000000141014723cULL, 0x040fe20000001830ULL,
0x0000000cff1c723eULL, 0x080fe400020006ffULL, 0x0000000cff08723eULL, 0x000fe400030006ffULL,
0x00000009ff09723eULL, 0x000fe400030006ffULL, 0x0000000eff20723eULL, 0x000fe200020006ffULL,
0x0000000a1018723cULL, 0x000fe2000000185cULL, 0x0000000fff21723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400030006ffULL, 0x0000000fff0f723eULL, 0x000fc600030006ffULL,
0x000000041004723cULL, 0x040ff00000001834ULL, 0x0000001c101c723cULL, 0x040ff00000001844ULL,
0x000000081008723cULL, 0x040ff00000001848ULL, 0x000000201020723cULL, 0x040ff0000000184cULL,
0x0000000e1010723cULL, 0x000fe20000001828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000003003c3c7a10ULL, 0x000fc80007ffe0ffULL, 0x0000003d3c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff852000007947ULL, 0x000fea000383ffffULL,
0x0000000000367919ULL, 0x000ee20000002500ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff307224ULL, 0x000fe400078e0022ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0020ULL, 0x000000ffff237224ULL, 0x000fe400078e001fULL,
0x000000ffff347224ULL, 0x000fc400078e0012ULL, 0x000000ffff327224ULL, 0x000fe400078e0010ULL,
0x000000ffff287224ULL, 0x000fe400078e001eULL, 0x000000ffff217224ULL, 0x000fe400078e001dULL,
0x000000ffff227224ULL, 0x000fe400078e001cULL, 0x000000ffff1f7224ULL, 0x000fe400078e001bULL,
0x000000ffff207224ULL, 0x000fe200078e001aULL, 0x0000003d3600720cULL, 0x008fe20003f06070ULL,
0x000000ffff337224ULL, 0x000fc400078e0013ULL, 0x000000ffff317224ULL, 0x000fe400078e0011ULL,
0x000000ffff2b7224ULL, 0x000fe400078e000bULL, 0x000000ffff2c7224ULL, 0x000fe400078e000aULL,
0x000000ffff297224ULL, 0x000fe400078e0009ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0019ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0005ULL, 0x000000ffff127224ULL, 0x000fe400078e0004ULL,
0x000000ffff107224ULL, 0x000fc400078e0017ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0015ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000041027810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008a4000187802ULL, 0x000fe40000000f00ULL, 0x000083d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004100047308ULL, 0x000ee40000001000ULL, 0xbf80000004027423ULL, 0x008fc80000000041ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ee8000c1e9900ULL,
0x0000000000077919ULL, 0x000f240000000000ULL, 0x00000002ff057819ULL, 0x010fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000403047220ULL, 0x008fca0000410000ULL,
0x00001f0504057589ULL, 0x000ee800000e0000ULL, 0x00001f0704077589ULL, 0x000f2200000e0000ULL,
0x0000001405147220ULL, 0x048fe20000410000ULL, 0x0000000e050e7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002905297220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x000fe20000410000ULL,
0x0000001607167220ULL, 0x050fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000003007307220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003407347220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203027812ULL, 0x008fc400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011603ULL,
0x00000001ff047819ULL, 0x000fe40000011602ULL, 0x0000000202057811ULL, 0x040fe400078ff8ffULL,
0x0000000402087811ULL, 0x040fe400078ff8ffULL, 0x00000006020c7811ULL, 0x006fe400078ff8ffULL,
0x0000000803177811ULL, 0x000fc400078ff0ffULL, 0x0000000704027812ULL, 0x100fe400078e780fULL,
0x00000007080a7812ULL, 0x040fe400078e780fULL, 0x0000000708087812ULL, 0x100fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0202ULL, 0x0000000704047812ULL, 0x000fe200078e7817ULL,
0x0000080000027824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x100fe200078e780fULL,
0x0000000817157824ULL, 0x040fe200078e0208ULL, 0x000000070c0d7812ULL, 0x040fe200078e780fULL,
0x0000000817117824ULL, 0x000fe200078e0204ULL, 0x0000000705057812ULL, 0x100fe200078e7817ULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x000000070c0c7812ULL, 0x000fe200078e7817ULL,
0x000000080f097824ULL, 0x040fe200078e0206ULL, 0x0000a00002047810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0b7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x000000140e05723eULL, 0x000fe200000000ffULL,
0x000000080f0f7824ULL, 0x000fe200078e020dULL, 0x000000121a06723eULL, 0x000fe200000000ffULL,
0x0000000817177824ULL, 0x000fe200078e020cULL, 0x0000001c1b0a723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x0000541005187816ULL, 0x000fe20000000006ULL,
0x0000001009097824ULL, 0x000fe200078e0204ULL, 0x0000763205197816ULL, 0x000fe20000000006ULL,
0x000000100b0d7824ULL, 0x100fe200078e0204ULL, 0x000000222105723eULL, 0x000fe200000000ffULL,
0x0000001011117824ULL, 0x100fe200078e0204ULL, 0x0000002a2906723eULL, 0x000fe200000000ffULL,
0x0000001013137824ULL, 0x000fc400078e0204ULL, 0x000000100f0f7824ULL, 0x100fe400078e0204ULL,
0x0000001015157824ULL, 0x100fe400078e0204ULL, 0x0000001017177824ULL, 0x000fe400078e0204ULL,
0x00000001070b7824ULL, 0x000fe200078e0208ULL, 0x000000242507723eULL, 0x000fe200000000ffULL,
0x00000001080c7824ULL, 0x000fe200078e0209ULL, 0x000000161009723eULL, 0x000fe200000000ffULL,
0x00000001080d7824ULL, 0x040fe200078e020dULL, 0x000000180b007388ULL, 0x0003e20000000a00ULL,
0x0000000108117824ULL, 0x000fc400078e0211ULL, 0x0000000108137824ULL, 0x040fe400078e0213ULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001e1d08723eULL, 0x000fe200000000ffULL,
0x00000300ff1c7624ULL, 0x000fc600078e00ffULL, 0x0000541007187816ULL, 0x142fe40000000008ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fe400000000ffULL,
0x000000323108723eULL, 0x000fe200000000ffULL, 0x000000180c007388ULL, 0x0003e20000000a00ULL,
0x000000011c00780cULL, 0x000fe40003f05270ULL, 0x0000541005187816ULL, 0x002fc40000000006ULL,
0x0000763205197816ULL, 0x000fe40000000006ULL, 0x00005410070c7816ULL, 0x100fe40000000008ULL,
0x000000262705723eULL, 0x000fe200000000ffULL, 0x000000180d007388ULL, 0x0003e20000000a00ULL,
0x000000201f06723eULL, 0x000fe400000000ffULL, 0x00007632070d7816ULL, 0x002fe40000000008ULL,
0x000000282307723eULL, 0x000fc400000000ffULL, 0x0000002c2b08723eULL, 0x000fe200000000ffULL,
0x0000000c0f007388ULL, 0x0003e40000000a00ULL, 0x00005410090c7816ULL, 0x142fe4000000000aULL,
0x00007632090d7816ULL, 0x000fe4000000000aULL, 0x000000302f09723eULL, 0x000fe400000000ffULL,
0x00000034330a723eULL, 0x000fe200000000ffULL, 0x0000000c11007388ULL, 0x0003e40000000a00ULL,
0x00005410050c7816ULL, 0x002fc40000000006ULL, 0x00007632050d7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000c13007388ULL, 0x0003e20000000a00ULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x0000000615007388ULL, 0x0003e80000000a00ULL,
0x0000000817007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b6000008947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x000ea20000002700ULL,
0x00000010030a7824ULL, 0x040fe200078e0202ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x000058001c057a24ULL, 0x000fe200078e02ffULL, 0x0000000000077919ULL, 0x002ea20000002600ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000002003117810ULL, 0x040fe40007ffe0ffULL,
0x00a000000a147984ULL, 0x0002e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x00a200000a187984ULL, 0x0003220000000c00ULL, 0x0000580012127a24ULL, 0x004fe400078e0207ULL,
0x0000640005077a24ULL, 0x000fe400078e02ffULL, 0x0000030012057a24ULL, 0x000fc600078e02ffULL,
0x00000fff07067811ULL, 0x000fe200078e40ffULL, 0x00000001050b7824ULL, 0x000fca00078e0236ULL,
0x0000000b06087211ULL, 0x000fca00078fa0ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x0000040000087825ULL, 0x000fcc00078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x00000010030e7825ULL, 0x000fe200078e0008ULL, 0x01ffffff07087812ULL, 0x000fe200078ec0ffULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001003077824ULL, 0x01afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x000fe200078e0208ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00006a000b0a7625ULL, 0x000fe200078e000dULL, 0x0000000c09097812ULL, 0x000fc600078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000a090a7210ULL, 0x000fc80007b5e007ULL,
0x0000000c090c7210ULL, 0x000fe40007d9e007ULL, 0x0000000bff0b7210ULL, 0x000fe400017e64ffULL,
0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL, 0x000000400a007986ULL, 0x0003e8000c101906ULL,
0x000000410c007986ULL, 0x0003e4000c101906ULL, 0x000000140e007986ULL, 0x01a3e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001810007986ULL, 0x0003e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff1c077810ULL, 0x000fc60007ffe0ffULL,
0x00006800120a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000070a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x000000070a00720cULL, 0x004fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff097807ULL, 0x000fca0000800000ULL, 0x00000009ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x000ee40000000000ULL, 0x000000ff0700720cULL, 0x008fda0003f25270ULL,
0x000027a000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x00000001050c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x004fe200078e00ffULL,
0x0000000c0a117812ULL, 0x002fe400078ec0ffULL, 0x00000070070f7812ULL, 0x000fe200078ec0ffULL,
0x00006a00050a7625ULL, 0x000fc800078e0009ULL, 0x00006a000c0c7625ULL, 0x000fe200078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000c110c7210ULL, 0x000fe40007b5e00fULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x000000060c0e7981ULL, 0x000362000c1e1900ULL,
0x000000021c00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00fULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00fULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081c00780cULL, 0x002fe40003f06070ULL, 0x00000006050a7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fe40007a3e00fULL,
0x00000007050c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006a000c0c0625ULL, 0x000fe400078e0009ULL, 0x000000060a1a7981ULL, 0x000366000c1e1900ULL,
0x0000000c110c0210ULL, 0x000fc80007c7e00fULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c0c0981ULL, 0x000368000c1e1900ULL, 0x000000071c097810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011609ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff187224ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x020fe400078e0007ULL, 0x00000008180d7824ULL, 0x040fe200078e00ffULL,
0x0000000118187810ULL, 0x000fc80007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000000091800720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080d0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000010d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1c7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000030d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000050d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000070d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001a07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1a7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0d0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000000c07077209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003097824ULL, 0x004fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fc80000011603ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL, 0x00000001090a7824ULL, 0x000fca00078e020aULL,
0x000000070a007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000005060a7211ULL, 0x002fe200078fa0ffULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x004fe20000011603ULL,
0x00000400003b7824ULL, 0x000fe200078e00ffULL, 0x00000016ff3d7819ULL, 0x000fe20000011600ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c090c7812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000020030d7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x0000003b0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001050e8824ULL, 0x000fe200078e0208ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00000080ff108424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000010b0b7824ULL, 0x000fe200008e063dULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x0000100000227824ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006a000e0e8625ULL, 0x000fe200078e000fULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001000158824ULL, 0x000fc400078e0203ULL, 0x00006a0005108625ULL, 0x000fc600078e0010ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x0000000107207824ULL, 0x000fe400078e020cULL,
0x0000001000178824ULL, 0x000fe400078e0203ULL, 0x000000100d0c7825ULL, 0x000fe400078e000aULL,
0x0000000020207984ULL, 0x000e620000000800ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x0000001003137824ULL, 0x040fe400078e0222ULL, 0x00000010030a7825ULL, 0x000fc800078e000aULL,
0x00000010030e8825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0005e6000b901c46ULL, 0x0000001003108825ULL, 0x000fe200078e0010ULL,
0x003800000c137faeULL, 0x0007e6000b901c46ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000000000e158faeULL, 0x0009e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fc400078e00ffULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000010178faeULL, 0x000be2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000cf000009947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fca00078e00ffULL, 0x0000000133347810ULL, 0x000fc80007ffe0ffULL,
0x0000030034007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x0000000105357824ULL, 0x000fe200078e0234ULL, 0x000000070300780cULL, 0x040fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001341f7812ULL, 0x040fe200078ec0ffULL,
0x00000800341a7824ULL, 0x000fe200078e00ffULL, 0x0000003506187211ULL, 0x000fe400078fa0ffULL,
0x0000002003397810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1d7812ULL, 0x000fe200078ec0ffULL,
0x00006a0018187625ULL, 0x000fc800078e0019ULL, 0x00000001081b9824ULL, 0x000fe200078e0235ULL,
0x0000003b18187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff1c9424ULL, 0x000fe400078e00ffULL,
0x00000002001e9824ULL, 0x000fe400078e021fULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00006a001b1a9625ULL, 0x000fc800078e001cULL, 0x00000001221c7824ULL, 0x000fe400078e021dULL,
0x0000000200389824ULL, 0x000fe400078e021fULL, 0x0000000119197824ULL, 0x000fe400000e063dULL,
0x000000081e379824ULL, 0x000fe400078e0203ULL, 0x00006a00351e9625ULL, 0x000fc600078e0036ULL,
0x0000458037379811ULL, 0x000fe200078e20ffULL, 0x0000001003357824ULL, 0x040fe400078e021cULL,
0x0000000838389824ULL, 0x000fe400078e0203ULL, 0x00000010031c9825ULL, 0x000fc800078e001aULL,
0x00000010391a7825ULL, 0x000fe200078e0018ULL, 0x0000418038399811ULL, 0x000fc600078e20ffULL,
0x0000001003187825ULL, 0x000fc800078e0018ULL, 0x00000010031e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018357faeULL, 0x0005e8000b901c46ULL,
0x003800001a357faeULL, 0x0005e8000b901c46ULL, 0x000000001c379faeULL, 0x0005e8000b901c46ULL,
0x000000001e399faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008033187824ULL, 0x004fe200078e00ffULL, 0x00000001ff1b7819ULL, 0x100fe20000011603ULL,
0x00000010031a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff527819ULL, 0x000fc40000011603ULL,
0x0000008018197812ULL, 0x000fe400078ec0ffULL, 0x000000701a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000008521d7824ULL, 0x000fe200078e00ffULL, 0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000010000197824ULL, 0x000fe200078e0219ULL, 0x00000007523c7812ULL, 0x040fe200078ec0ffULL,
0x00000008521f7824ULL, 0x040fe200078e00ffULL, 0x00000052ff407212ULL, 0x000fe400078e33ffULL,
0x000000191b1a7210ULL, 0x000fe20007ffe01aULL, 0x0000000852197824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fc400078ee23cULL, 0xfffffff81f407812ULL, 0x000fe400078ee240ULL,
0x00000001191c7812ULL, 0x000fe200078ef63cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001a1b7984ULL, 0x000ea20000000800ULL, 0x00000002191e7812ULL, 0x140fe400078ef63cULL,
0x0000000319367812ULL, 0x140fe200078ef63cULL, 0x004580001a507984ULL, 0x0007220000000800ULL,
0x0000000419387812ULL, 0x140fe400078ef63cULL, 0x00000005193a7812ULL, 0x140fe400078ef63cULL,
0x00000006193c7812ULL, 0x000fe200078ef63cULL, 0x0000080033197824ULL, 0x000fe200078e00ffULL,
0x0000000852547810ULL, 0x000fe20007ffe0ffULL, 0x00000004031a7824ULL, 0x008fc400078e00ffULL,
0x000000ffff337224ULL, 0x000fe200078e0034ULL, 0x0000080019197812ULL, 0x000fe200078ec0ffULL,
0x00000008541d7824ULL, 0x040fe200078e00ffULL, 0x00000054ff4e7212ULL, 0x000fe200078e33ffULL,
0x0000000854447824ULL, 0x000fe200078e00ffULL, 0x0000018022197810ULL, 0x000fe20007ffe019ULL,
0x0000000854427824ULL, 0x040fe200078e00ffULL, 0xfffffff81d4e7812ULL, 0x000fe400078ee24eULL,
0x00000007541d7812ULL, 0x000fe200078ec0ffULL, 0x0000001018187824ULL, 0x100fe200078e0219ULL,
0x0000030033007a0cULL, 0x000fe20003f06070ULL, 0x0000001040407824ULL, 0x000fe200078e0219ULL,
0x0000000242467812ULL, 0x000fe200078ef61dULL, 0x000000101c1c7824ULL, 0x000fe200078e0219ULL,
0x0000000342487812ULL, 0x000fe200078ef61dULL, 0x0000001036367824ULL, 0x000fe200078e0219ULL,
0x00000004424a7812ULL, 0x000fe200078ef61dULL, 0x000000101e1e7824ULL, 0x000fe200078e0219ULL,
0x00000005424c7812ULL, 0x000fe200078ef61dULL, 0x000000103a3a7824ULL, 0x000fc400078e0219ULL,
0x0000001038387824ULL, 0x100fe400078e0219ULL, 0x000000103c3c7824ULL, 0x000fe200078e0219ULL,
0x0000001b201b7221ULL, 0x006fe20000010100ULL, 0x0000001046467824ULL, 0x100fe400078e0219ULL,
0x0000001048487824ULL, 0x100fe200078e0219ULL, 0x3fb8aa3b1b1f7820ULL, 0x000fe20000410000ULL,
0x0000000c1a1b7812ULL, 0x000fe200078ec0ffULL, 0x000000104c4c7824ULL, 0x000fe200078e0219ULL,
0xfffffff8441a7812ULL, 0x000fe200078ee21dULL, 0x000000104a4a7824ULL, 0x000fe200078e0219ULL,
0x0000000142447812ULL, 0x000fe200078ef61dULL, 0x0000000118187824ULL, 0x000fe200078e021bULL,
0x0000001f001f7308ULL, 0x000f220000000800ULL, 0x000000011b407824ULL, 0x040fe200078e0240ULL,
0x0000000642427812ULL, 0x000fe200078ef61dULL, 0x000000011b1c7824ULL, 0x000fc400078e021cULL,
0x0000000018187984ULL, 0x000e620000000800ULL, 0x000000011b367824ULL, 0x040fe400078e0236ULL,
0x000000011b1e7824ULL, 0x040fe200078e021eULL, 0x0000000040407984ULL, 0x000ea20000000800ULL,
0x000000011b3a7824ULL, 0x040fe400078e023aULL, 0x000000011b387824ULL, 0x040fe200078e0238ULL,
0x000000001c1c7984ULL, 0x000fe20000000800ULL, 0x000000011b3c7824ULL, 0x000fe200078e023cULL,
0x000000501f1f7220ULL, 0x010fc40000410000ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0219ULL, 0x0000001044447824ULL, 0x000fe200078e0219ULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x000000011b1a7824ULL, 0x000fe200078e021aULL,
0x000000321f327221ULL, 0x000fe20000010000ULL, 0x000000011b447824ULL, 0x040fe200078e0244ULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x000000011b467824ULL, 0x040fe400078e0246ULL,
0x000000011b487824ULL, 0x040fe200078e0248ULL, 0x00001f521f1d7589ULL, 0x000ee200000e0000ULL,
0x000000011b4c7824ULL, 0x000fc400078e024cULL, 0x000000011b4a7824ULL, 0x040fe200078e024aULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000104e4e7824ULL, 0x100fe400078e0219ULL,
0x0000001042427824ULL, 0x000fe200078e0219ULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x000000011b4e7824ULL, 0x040fe400078e024eULL, 0x000000011b427824ULL, 0x000fe200078e0242ULL,
0x000000001a1a7984ULL, 0x000f680000000800ULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x20000018ff507230ULL, 0x002fc40000004100ULL, 0x30000018ff197230ULL, 0x000fe20000004100ULL,
0x0000000046467984ULL, 0x000e620000000800ULL, 0x20000040ff187230ULL, 0x104fe40000004100ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x0000001d19307223ULL, 0x088fe20000010030ULL, 0x0000001d18237223ULL, 0x080fe20000010023ULL,
0x2000001cff187230ULL, 0x100fe20000004100ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x3000001cff197230ULL, 0x000fe20000004100ULL, 0x0000001d50317223ULL, 0x080fe20000010031ULL,
0x0000001d40217223ULL, 0x080fe20000010021ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x0000001d182f7223ULL, 0x080fe2000001002fULL, 0x20000036ff187230ULL, 0x000fe20000004100ULL,
0x0000001d192e7223ULL, 0x000fe2000001002eULL, 0x000000004e4e7984ULL, 0x000fe20000000800ULL,
0x3000001eff1b7230ULL, 0x000fc40000004100ULL, 0x0000001d182b7223ULL, 0x080fe2000001002bULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x30000036ff197230ULL, 0x000fe20000004100ULL,
0x0000001d1b2c7223ULL, 0x080fe2000001002cULL, 0x2000003aff187230ULL, 0x000fe20000004100ULL,
0x00001f541f1f7589ULL, 0x000ea200000e0000ULL, 0x2000001eff1c7230ULL, 0x000fe20000004100ULL,
0x0000001d192a7223ULL, 0x080fe2000001002aULL, 0x30000038ff1b7230ULL, 0x010fe20000004100ULL,
0x0000001d18277223ULL, 0x080fe20000010027ULL, 0x3000003aff197230ULL, 0x000fe20000004100ULL,
0x0000001d1c2d7223ULL, 0x080fe2000001002dULL, 0x2000003cff187230ULL, 0x020fe20000004100ULL,
0x0000001d1b287223ULL, 0x080fe20000010028ULL, 0x20000038ff1c7230ULL, 0x000fe20000004100ULL,
0x0000001d19267223ULL, 0x080fe20000010026ULL, 0x3000003cff1b7230ULL, 0x000fe20000004100ULL,
0x0000001d18257223ULL, 0x080fe20000010025ULL, 0x3000001aff197230ULL, 0x000fe20000004100ULL,
0x0000001d1c297223ULL, 0x080fe20000010029ULL, 0x20000044ff187230ULL, 0x000fe20000004100ULL,
0x0000001d1b247223ULL, 0x000fe20000010024ULL, 0x2000001aff1c7230ULL, 0x000fc40000004100ULL,
0x20000046ff1a7230ULL, 0x102fe40000004100ULL, 0x30000046ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f19167223ULL, 0x084fe20000010016ULL, 0x0000001f18157223ULL, 0x080fe20000010015ULL,
0x30000044ff197230ULL, 0x000fe20000004100ULL, 0x0000001f1a137223ULL, 0x080fe20000010013ULL,
0x20000048ff187230ULL, 0x000fe20000004100ULL, 0x0000001f1b127223ULL, 0x080fe20000010012ULL,
0x2000004cff1a7230ULL, 0x000fe20000004100ULL, 0x0000001f19147223ULL, 0x080fe20000010014ULL,
0x30000048ff197230ULL, 0x000fe20000004100ULL, 0x0000001f18117223ULL, 0x080fe20000010011ULL,
0x2000004aff187230ULL, 0x100fe20000004100ULL, 0x0000001f1a0d7223ULL, 0x080fe2000001000dULL,
0x3000004aff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f19107223ULL, 0x080fe20000010010ULL,
0x2000004eff1a7230ULL, 0x000fe20000004100ULL, 0x0000001f180f7223ULL, 0x080fe2000001000fULL,
0x3000004cff197230ULL, 0x000fe20000004100ULL, 0x0000001f1b0e7223ULL, 0x080fe2000001000eULL,
0x20000042ff187230ULL, 0x100fe20000004100ULL, 0x0000001f1c177223ULL, 0x080fe20000010017ULL,
0x30000042ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f190c7223ULL, 0x080fe2000001000cULL,
0x3000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000001f180b7223ULL, 0x080fe2000001000bULL,
0x0000001f1a097223ULL, 0x080fe20000010009ULL, 0x0000001f1b0a7223ULL, 0x000fc4000001000aULL,
0x0000001f4e077223ULL, 0x000fe20000010007ULL, 0xfffff33000008947ULL, 0x000fea000383ffffULL,
0x0180000032007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0032ULL, 0x0000b4f000187802ULL, 0x000fe40000000f00ULL,
0x0000592000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003200037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000032ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000803357811ULL, 0x004fe400078ff0ffULL, 0x00000002ff197819ULL, 0x000fe40000011603ULL,
0x00000035ff337212ULL, 0x000fe200078e33ffULL, 0x00001f3500087589ULL, 0x000ea200000e0000ULL,
0x0000000835187824ULL, 0x000fc400078e00ffULL, 0x0000000819377824ULL, 0x000fe200078e00ffULL,
0x00001f1900067589ULL, 0x00072200000e0000ULL, 0x0000000835227824ULL, 0x000fe200078e00ffULL,
0xfffffff818337812ULL, 0x000fe200078ee233ULL, 0x0000000819187824ULL, 0x000fc800078e00ffULL,
0x0000001033337824ULL, 0x000fe200078e0204ULL, 0xfffffff818057812ULL, 0x000fe400078ee219ULL,
0x00000019ff007212ULL, 0x008fc600078e33ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0xfffffff837377812ULL, 0x000fe400078ee200ULL, 0x0000000719007812ULL, 0x040fe200078ec0ffULL,
0x0000000f080f7220ULL, 0x044fe20000410000ULL, 0x0000000e080e7220ULL, 0x000fe40000410000ULL,
0x0000000500207812ULL, 0x002fe200078e3cffULL, 0x0000001708177220ULL, 0x040fe20000410000ULL,
0x0000001608167220ULL, 0x040fe20000410000ULL, 0x0000001508157220ULL, 0x040fe20000410000ULL,
0x0000001408147220ULL, 0x040fe20000410000ULL, 0x0000001308137220ULL, 0x040fe20000410000ULL,
0x0000001208127220ULL, 0x040fe20000410000ULL, 0x0000001108117220ULL, 0x040fe20000410000ULL,
0x0000001008107220ULL, 0x040fe20000410000ULL, 0x0000000d080d7220ULL, 0x040fe20000410000ULL,
0x0000000c080c7220ULL, 0x040fe20000410000ULL, 0x0000000b080b7220ULL, 0x040fe20000410000ULL,
0x0000000a080a7220ULL, 0x040fe20000410000ULL, 0x0000000908097220ULL, 0x040fe20000410000ULL,
0x0000000708087220ULL, 0x000fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x00000008190f7824ULL, 0x000fe200078e0220ULL, 0x0000000100187812ULL, 0x040fe200078e3cffULL,
0x0000000403207824ULL, 0x000fe200078e00ffULL, 0x00000002001a7812ULL, 0x000fe200078e3cffULL,
0x0000003106317220ULL, 0x010fe20000410000ULL, 0x00000003001c7812ULL, 0x040fe200078e3cffULL,
0x0000000819077824ULL, 0x000fe200078e0218ULL, 0x00000004001e7812ULL, 0x000fe200078e3cffULL,
0x0000003006307220ULL, 0x000fe20000410000ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x0000002f062f7220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000000735177812ULL, 0x000fe200078ec0ffULL,
0x0000002d062d7220ULL, 0x000fe20000410000ULL, 0x000000090808723eULL, 0x000fe200000000ffULL,
0x0000000819097824ULL, 0x040fe200078e021aULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000819117824ULL, 0x040fe200078e0200ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x00000008190b7824ULL, 0x040fe200078e021cULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x00000008190d7824ULL, 0x000fe200078e021eULL, 0x0000000c20207812ULL, 0x000fe200078ec0ffULL,
0x0000002c062c7220ULL, 0x000fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x100fe200078e0204ULL, 0x0000000117007812ULL, 0x040fe200078e3cffULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000000217157812ULL, 0x000fe200078e3cffULL,
0x0000002a062a7220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x100fe200078e0204ULL, 0x0000000317187812ULL, 0x000fe200078e3cffULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x000fe20000410000ULL,
0xfffffff822137812ULL, 0x000fe200078ee235ULL, 0x000000100b0b7824ULL, 0x100fe200078e0204ULL,
0x00000004171a7812ULL, 0x040fe200078e3cffULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x000fe20000410000ULL, 0x000000313030723eULL, 0x000fe200000000ffULL,
0x0000000120057824ULL, 0x000fe200078e0205ULL, 0x00000005171c7812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x000fe200078e0204ULL, 0x00000006171e7812ULL, 0x000fe200078e3cffULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x000fe20000410000ULL, 0x0000002f2e2e723eULL, 0x000fe200000000ffULL,
0x0000000835177824ULL, 0x000fe200078e0200ULL, 0x0000002106067220ULL, 0x000fe20000410000ULL,
0x000000100f0f7824ULL, 0x100fe200078e0204ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000000120077824ULL, 0x000fe200078e0207ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000000835197824ULL, 0x000fe200078e0215ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000001011117824ULL, 0x000fe200078e0204ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000000120097824ULL, 0x000fe200078e0209ULL, 0x0000003005007388ULL, 0x0003e20000000800ULL,
0x00000008351b7824ULL, 0x000fe200078e0218ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000001037007824ULL, 0x000fe200078e0204ULL, 0x0000002e07007388ULL, 0x0003e20000000800ULL,
0x00000001200b7824ULL, 0x000fe200078e020bULL, 0x000000230606723eULL, 0x000fe200000000ffULL,
0x00000008351d7824ULL, 0x000fe200078e021aULL, 0x0000002c09007388ULL, 0x0003e20000000800ULL,
0x0000001013157824ULL, 0x000fc400078e0204ULL, 0x00000001200d7824ULL, 0x040fe200078e020dULL,
0x0000002a0b007388ULL, 0x0003e20000000800ULL, 0x00000008351f7824ULL, 0x000fe400078e021cULL,
0x0000001017177824ULL, 0x000fe200078e0204ULL, 0x000000280d007388ULL, 0x0003e20000000800ULL,
0x00000001200f7824ULL, 0x040fe400078e020fULL, 0x0000000835217824ULL, 0x000fe400078e021eULL,
0x0000001019197824ULL, 0x000fe200078e0204ULL, 0x000000260f007388ULL, 0x0003e20000000800ULL,
0x0000000120117824ULL, 0x000fc400078e0211ULL, 0x000000101b1b7824ULL, 0x000fe400078e0204ULL,
0x0000000120137824ULL, 0x040fe200078e0200ULL, 0x0000002411007388ULL, 0x0003e20000000800ULL,
0x000000101d1d7824ULL, 0x100fe400078e0204ULL, 0x0000000120157824ULL, 0x040fe200078e0215ULL,
0x0000000613007388ULL, 0x0003e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe400078e0204ULL,
0x0000000120177824ULL, 0x000fe200078e0217ULL, 0x0000001615007388ULL, 0x0003e20000000800ULL,
0x0000001021217824ULL, 0x000fc400078e0204ULL, 0x0000000120197824ULL, 0x040fe200078e0219ULL,
0x0000001417007388ULL, 0x0003e20000000800ULL, 0x00000001201b7824ULL, 0x040fe400078e021bULL,
0x00000001201d7824ULL, 0x040fe200078e021dULL, 0x0000001219007388ULL, 0x0003e20000000800ULL,
0x00000001201f7824ULL, 0x040fe400078e021fULL, 0x0000000120217824ULL, 0x040fe200078e0221ULL,
0x000000101b007388ULL, 0x0003e20000000800ULL, 0x0000000120337824ULL, 0x000fc600078e0233ULL,
0x0000000e1d007388ULL, 0x0003e80000000800ULL, 0x0000000c1f007388ULL, 0x0003e80000000800ULL,
0x0000000a21007388ULL, 0x0003e80000000800ULL, 0x0000000833007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000020030d7810ULL, 0x002fe20007ffe0ffULL,
0x00000000000c7919ULL, 0x000e620000002600ULL, 0x00000003ff007819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff067819ULL, 0x000fe2000001160dULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000700047812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000706077812ULL, 0x000fc400078e480dULL,
0x0ffffff804057812ULL, 0x000fe400078ef803ULL, 0x0ffffff807077812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x100fe400078e0202ULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x1ffffff80d0d7812ULL, 0x000fe400078ef83eULL,
0x00a0000005087984ULL, 0x0045280000000c00ULL, 0x00a0000007107984ULL, 0x000b220000000c00ULL,
0x000000080c0f7824ULL, 0x002fc400078e00ffULL, 0x000000080c157824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff80f007812ULL, 0x000fe400078ee200ULL,
0xfffffff815067812ULL, 0x000fe400078ee206ULL, 0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL, 0x00000007030f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe200078048ffULL,
0x000000ffff057224ULL, 0x004fe200008e06ffULL, 0x00005a0006047a11ULL, 0x000fc400078248ffULL,
0x00005b0000037a11ULL, 0x000fe400000f4c03ULL, 0x1ffffff80f077812ULL, 0x020fe400078ef83eULL,
0x00005b0006057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x00000006041e7981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013c047810ULL, 0x002fe20007ffe0ffULL, 0x000000023f3f7824ULL, 0x000fe200078e00ffULL,
0x01060000ff067f8cULL, 0x000e62000c80043fULL, 0x0000004000057824ULL, 0x000fe200078e00ffULL,
0x0000003d0400720cULL, 0x000fe20003f06070ULL, 0x000058003f047a24ULL, 0x000fe400078e0212ULL,
0x000001003c157824ULL, 0x000fc800078e0205ULL, 0x0000620004217a24ULL, 0x000fcc00078e0215ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1a7819ULL, 0x000fe20000011602ULL,
0x00000100ff237424ULL, 0x000fe200078e00ffULL, 0x000000300e1f7812ULL, 0x000fe400078ec0ffULL,
0x000000081a127810ULL, 0x040fe20007ffe0ffULL, 0x000000011a087824ULL, 0x140fe200078e0221ULL,
0x000000181a207810ULL, 0x040fe40007ffe0ffULL, 0x000000101a1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001120a7824ULL, 0x000fe200078e0221ULL, 0x000000201a167810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x00000015030c7217ULL, 0x000fc40007800000ULL,
0x00000003ff177819ULL, 0x100fe20000011602ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0x0000001f08107210ULL, 0x080fe40007f1e0ffULL, 0x0000000317177812ULL, 0x000fe200078e4802ULL,
0x00000001200e7824ULL, 0x100fe200078e0221ULL, 0x0000001f0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000011c0d7824ULL, 0x000fe200078e0221ULL, 0x0000200000197811ULL, 0x000fe200078e68ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0023ULL, 0x000000281a187810ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc17027812ULL, 0x000fe200078ef802ULL, 0x0000000121087824ULL, 0x000fe400078e0216ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000001f0e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010c157824ULL, 0x000fe400078e0a15ULL, 0x00005e000d0c7625ULL, 0x000fc600078e0023ULL,
0x000000151c00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff117224ULL, 0x000fe200000e0609ULL,
0x0000001f0c0c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x000000152000720cULL, 0x080fe40003f86070ULL, 0x000000151600720cULL, 0x080fe20003f66070ULL,
0x0000000412147824ULL, 0x040fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000151200720cULL, 0x000fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001f08127210ULL, 0x000fe20007f5e0ffULL, 0x00000010021b7824ULL, 0x000fe200078e0219ULL,
0xfffffffc14087812ULL, 0x000fe200078ee217ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x000000151a00720cULL, 0x0c0fe20003f06070ULL, 0x000000ffff137224ULL, 0x000fe200010e0609ULL,
0x000000301a027810ULL, 0x000fe20007ffe0ffULL, 0x00000010081d7824ULL, 0x000fe200078e0219ULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000121087824ULL, 0x000fe200078e0218ULL,
0x000000151800720cULL, 0x000fe20003f46070ULL, 0x0000000416167824ULL, 0x000fc400078e00ffULL,
0x00005e0008087625ULL, 0x000fc600078e0023ULL, 0xfffffffc16167812ULL, 0x000fe200078ee217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101b7faeULL, 0x0005e2000c101c46ULL,
0x0000001f08147210ULL, 0x000fe20007fde0ffULL, 0x0000000121087824ULL, 0x000fe200078e0202ULL,
0x000000151a00720cULL, 0x080fe20003f06070ULL, 0x000000000a1d7faeULL, 0x0007e2000c901c46ULL,
0x000000150200720cULL, 0x000fe20003f26070ULL, 0x000000ffff157224ULL, 0x000fe400030e0609ULL,
0x00005e0008087625ULL, 0x000fc800078e0023ULL, 0x0000000420107824ULL, 0x004fe200078e00ffULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x0000000418187824ULL, 0x000fe400078e00ffULL,
0x00000001210a7824ULL, 0x008fe200078e021aULL, 0xfffffffc10107812ULL, 0x100fe200078ee217ULL,
0x0000000402207824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c027812ULL, 0x100fe200078ee217ULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x100fe200078ee217ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0023ULL, 0xfffffffc201a7812ULL, 0x000fc400078ee217ULL,
0xfffffffc221c7812ULL, 0x000fe200078ee217ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000001f0a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001002117824ULL, 0x100fe400078e0219ULL,
0x0000001010177824ULL, 0x100fe400078e0219ULL, 0x00000010161b7824ULL, 0x100fe200078e0219ULL,
0x000000000c117faeULL, 0x0005e2000e901c46ULL, 0x00000010181d7824ULL, 0x100fe400078e0219ULL,
0x000000101a1f7824ULL, 0x100fe200078e0219ULL, 0x000000000e177faeULL, 0x0005e2000e101c46ULL,
0x000000101c197824ULL, 0x000fc400078e0219ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x00000000121b7faeULL, 0x0005e8000d901c46ULL, 0x00000000141d7faeULL, 0x0005e8000d101c46ULL,
0x00000000081f7faeULL, 0x0005e8000c901c46ULL, 0x000000000a197faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x000fe20000011602ULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x0000001002097811ULL, 0x000fc400078ff0ffULL,
0x0000002102087211ULL, 0x040fe400078ff0ffULL, 0x000000030b177812ULL, 0x000fe200078e4802ULL,
0x00000001210b7824ULL, 0x000fe200078e0209ULL, 0x0000000802107811ULL, 0x040fe200078ff0ffULL,
0x0000000409207824ULL, 0x000fe200078e00ffULL, 0x0000003802127811ULL, 0x000fe200078ff0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0027ULL, 0x00000028020f7811ULL, 0x000fe400078ff0ffULL,
0x000000300e297812ULL, 0x000fe200078ec0ffULL, 0x0000000410147824ULL, 0x000fe200078e00ffULL,
0x00000018020c7811ULL, 0x040fe200078ff0ffULL, 0x00000001211c7824ULL, 0x000fe200078e0212ULL,
0x0000003002117811ULL, 0x000fe200078ff0ffULL, 0x0000000412287824ULL, 0x000fe200078e00ffULL,
0x0000002908127210ULL, 0x000fe20007f1e0ffULL, 0x000000040f247824ULL, 0x000fe200078e00ffULL,
0x00000020020e7811ULL, 0x000fe200078ff0ffULL, 0x00000001100a7824ULL, 0x000fe200078e0221ULL,
0x0ffffffc17167812ULL, 0x000fe200078ef802ULL, 0x00000001210d7824ULL, 0x000fe200078e020cULL,
0xfffffffc14027812ULL, 0x100fe200078ee217ULL, 0x0000000411267824ULL, 0x000fe200078e00ffULL,
0xfffffffc24147812ULL, 0x000fe200078ee217ULL, 0x000000ffff137224ULL, 0x000fe200000e0609ULL,
0x0000200000257811ULL, 0x000fe200078e68ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc26157812ULL, 0x000fe200078ee217ULL, 0x000000040e227824ULL, 0x000fc400078e00ffULL,
0x00005e000a087625ULL, 0x000fc800078e0027ULL, 0x00005e000b0a7625ULL, 0x000fc800078e0027ULL,
0x0000000121107824ULL, 0x040fe200078e020eULL, 0xfffffffc200e7812ULL, 0x000fe200078ee217ULL,
0x0000000121187824ULL, 0x040fe200078e020fULL, 0xfffffffc0c0f7812ULL, 0x000fe200078ee217ULL,
0x00000001211a7824ULL, 0x000fe200078e0211ULL, 0xfffffffc22117812ULL, 0x000fe200078ee217ULL,
0x0000001014217824ULL, 0x000fe200078e0225ULL, 0x0000002908147210ULL, 0x000fe20007f1e0ffULL,
0x00005e000d0c7625ULL, 0x000fe200078e0027ULL, 0xfffffffc28177812ULL, 0x000fc600078ee217ULL,
0x00000010162b7824ULL, 0x100fe200078e0225ULL, 0x000000290a167210ULL, 0x000fe20007f3e0ffULL,
0x0000001015237824ULL, 0x100fe400078e0225ULL, 0x0000001002197824ULL, 0x100fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000122b7faeULL, 0x0005e2000b901c46ULL,
0x000000100e1b7824ULL, 0x100fe400078e0225ULL, 0x000000100f1d7824ULL, 0x100fe400078e0225ULL,
0x00000010111f7824ULL, 0x000fc400078e0225ULL, 0x000000ffff157224ULL, 0x000fe200000e0609ULL,
0x000000290c0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001017257824ULL, 0x000fe400078e0225ULL,
0x000000ffff177224ULL, 0x000fe200008e060bULL, 0x0000000014197faeULL, 0x0005e2000b901c46ULL,
0x00005e0010087625ULL, 0x000fc600078e0027ULL, 0x00000000161b7faeULL, 0x0005e2000b901c46ULL,
0x00005e00180a7625ULL, 0x000fc800078e0027ULL, 0x00005e001a0e7625ULL, 0x000fe200078e0027ULL,
0x000000290a0a7210ULL, 0x000fc60007f3e0ffULL, 0x00005e001c107625ULL, 0x000fe200078e0027ULL,
0x000000290e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000002908087210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002910107210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x000000000c1d7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe400000e0609ULL,
0x000000ffff117224ULL, 0x000fc600018e0611ULL, 0x00000000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000a217faeULL, 0x0005e8000b901c46ULL, 0x000000000e237faeULL, 0x0005e8000b901c46ULL,
0x0000000010257faeULL, 0x0005e4000b901c46ULL, 0x01060400ff097984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000009ff7812ULL, 0x006fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200087305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fc800078e0207ULL,
0x0000002002087824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc80000011602ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x000001e008087812ULL, 0x000fe400078ec0ffULL,
0x00000001070b7812ULL, 0x040fe400078efcffULL, 0x0000000707097812ULL, 0x100fe400078e7802ULL,
0x000000070b0b7812ULL, 0x100fe400078e7802ULL, 0x0000001007157810ULL, 0x040fe20007ffe0ffULL,
0x0000000108097824ULL, 0x040fe200078e0209ULL, 0x0000001107077810ULL, 0x000fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x0000000715157812ULL, 0x000fc400078e7802ULL,
0x0000000009107984ULL, 0x000e62000000cc00ULL, 0x0000000707077812ULL, 0x000fe400078e7802ULL,
0x0000000108157824ULL, 0x040fe200078e0215ULL, 0x000000000b0c7984ULL, 0x000ea4000000cc00ULL,
0x0000000108077824ULL, 0x000fe400078e0207ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fe200078e0013ULL, 0x0000001809007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fca00078e000fULL,
0x000000200b007388ULL, 0x000fe8000000cc00ULL, 0x00000000070c7984ULL, 0x000e68000000cc00ULL,
0x0000000015107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002415007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff067f8cULL, 0x002fe8000c80043fULL,
0x01060400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200087305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01060400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003d3c00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x3d8000001e077820ULL, 0x020fe20000410000ULL,
0x0001068800287811ULL, 0x040fe200078e18ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0xffffffff3d297810ULL, 0x000fe40007ffe0ffULL, 0x00010608002a7811ULL, 0x000fe400078e28ffULL,
0x000001003c2c7824ULL, 0x000fe200078e0205ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002c0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e002bULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x00000001022e7810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fc400078e0002ULL, 0x00000002ff2b7819ULL, 0x100fe2000001162eULL,
0x000000ffff027224ULL, 0x000fe200078e002eULL, 0x000000042e00780cULL, 0x040fe40003f06070ULL,
0x000000032e2f7812ULL, 0x000fe200078ec0ffULL, 0x000003002b307a24ULL, 0x000fe200078e023cULL,
0x000000012d2b7812ULL, 0x000fc600078e0cffULL, 0x0000010030317824ULL, 0x040fe200078e0205ULL,
0x0000000130327810ULL, 0x000fc60007ffe0ffULL, 0x0000620004377a24ULL, 0x000fe200078e0231ULL,
0x0000003d3200720cULL, 0x000fda0003f26070ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x000000042f3b7824ULL, 0x000fe200078e00ffULL, 0x00000003ff2f7819ULL, 0x102fe20000011606ULL,
0x00000002003a7824ULL, 0x000fe200078e022bULL, 0x00000031032e7217ULL, 0x000fe20007800000ULL,
0x00000100ff397424ULL, 0x000fe200078e00ffULL, 0x00000002ff347819ULL, 0x100fe40000011606ULL,
0x000000032f3f7812ULL, 0x100fe200078e4806ULL, 0x000000012e327824ULL, 0x000fe200078e0a31ULL,
0x00000008342f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001342e7824ULL, 0x000fe200078e0237ULL,
0xfffffffc3b3b7812ULL, 0x000fc400078ee206ULL, 0x000000323400720cULL, 0x080fe20003f26070ULL,
0x000000012f307824ULL, 0x040fe200078e0237ULL, 0x000000322f00720cULL, 0x040fe20003f46070ULL,
0x000000042f367824ULL, 0x000fe200078e00ffULL, 0x000020003a3a7811ULL, 0x000fe200078e60ffULL,
0x00005e002e2e7625ULL, 0x080fe200078e0039ULL, 0x0ffffffc3f337812ULL, 0x000fe400078ef806ULL,
0xfffffffc36357812ULL, 0x000fe200078ee23fULL, 0x00005e0030307625ULL, 0x000fe200078e0039ULL,
0x0000001034367810ULL, 0x000fc40007ffe0ffULL, 0x0000001834387810ULL, 0x040fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e023aULL, 0x00000020343e7810ULL, 0x040fe20007ffe0ffULL,
0x000000103b2e7825ULL, 0x000fe200078e002eULL, 0x0000002834417810ULL, 0x040fe40007ffe0ffULL,
0x0000003034427810ULL, 0x040fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e023aULL,
0x0000003834437810ULL, 0x000fe20007ffe0ffULL, 0x000000103b307825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e337faeULL, 0x0003e2000c901c46ULL,
0x000000323600720cULL, 0x000fc40003f26070ULL, 0x000000323e00720cULL, 0x080fe20003f66070ULL,
0x0000000030357faeULL, 0x0005e2000d101c46ULL, 0x000000323800720cULL, 0x080fe20003f46070ULL,
0x0000000436447824ULL, 0x000fe200078e00ffULL, 0x000000324100720cULL, 0x0c0fe20003f86070ULL,
0x0000000438467824ULL, 0x000fe200078e00ffULL, 0x000000324200720cULL, 0x080fe20003fa6070ULL,
0x0000000141347824ULL, 0x100fe200078e0237ULL, 0x000000324300720cULL, 0x000fe20003fc6070ULL,
0x00000001362e7824ULL, 0x102fe400078e0237ULL, 0x000000013e327824ULL, 0x000fc400078e0237ULL,
0x0000000138307824ULL, 0x104fe400078e0237ULL, 0x0000000142367824ULL, 0x100fe400078e0237ULL,
0x0000000143387824ULL, 0x000fe400078e0237ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x00005e002e2e7625ULL, 0x000fc600078e0039ULL, 0xfffffffc3e457812ULL, 0x000fe200078ee23fULL,
0x00005e0030307625ULL, 0x000fc800078e0039ULL, 0x00005e0032327625ULL, 0x000fc800078e0039ULL,
0x00005e0034347625ULL, 0x000fc800078e0039ULL, 0x00005e0036367625ULL, 0x000fc800078e0039ULL,
0x0000000441487824ULL, 0x000fe200078e00ffULL, 0xfffffffc44417812ULL, 0x000fe200078ee23fULL,
0x00005e0038387625ULL, 0x000fc600078e0039ULL, 0xfffffffc48477812ULL, 0x100fe200078ee23fULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00000004434a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46437812ULL, 0x000fe200078ee23fULL, 0x000000103b2e7825ULL, 0x040fe200078e002eULL,
0xfffffffc42497812ULL, 0x100fe400078ee23fULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee23fULL,
0x000000103b307825ULL, 0x000fc800078e0030ULL, 0x000000103b327825ULL, 0x000fc800078e0032ULL,
0x000000103b347825ULL, 0x000fc800078e0034ULL, 0x000000103b367825ULL, 0x000fc800078e0036ULL,
0x000000103b387825ULL, 0x000fc800078e0038ULL, 0x00000010413b7824ULL, 0x100fe400078e023aULL,
0x00000010433f7824ULL, 0x100fe400078e023aULL, 0x0000001045417824ULL, 0x100fe200078e023aULL,
0x000000002e3b7faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e023aULL,
0x0000001049457824ULL, 0x100fe200078e023aULL, 0x00000000303f7faeULL, 0x0003e2000d101c46ULL,
0x000000104b477824ULL, 0x000fc600078e023aULL, 0x0000000032417faeULL, 0x0003e8000d901c46ULL,
0x0000000034437faeULL, 0x0003e8000e101c46ULL, 0x0000000036457faeULL, 0x0003e8000e901c46ULL,
0x0000000038477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000200307824ULL, 0x000fe200078e022bULL, 0x0000000806327811ULL, 0x042fe200078ff0ffULL,
0x000000042f417824ULL, 0x000fe200078e00ffULL, 0x0000001006347811ULL, 0x040fe200078ff0ffULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001806367811ULL, 0x000fe200078ff0ffULL,
0x0000000432447824ULL, 0x000fe200078e00ffULL, 0x0000002006387811ULL, 0x000fe200078ff0ffULL,
0x0000000434467824ULL, 0x000fe200078e00ffULL, 0x00000028063a7811ULL, 0x000fe200078ff0ffULL,
0x0000000436487824ULL, 0x000fe200078e00ffULL, 0x00000030063e7811ULL, 0x000fe200078ff0ffULL,
0x00000004384a7824ULL, 0x000fe200078e00ffULL, 0x0000003806427811ULL, 0x000fe200078ff0ffULL,
0x000000043a4c7824ULL, 0x000fe200078e00ffULL, 0x00002000304d7811ULL, 0x000fe200078e60ffULL,
0x0000000132307824ULL, 0x100fe200078e0237ULL, 0x00000003ff2f7819ULL, 0x100fe20000011606ULL,
0x0000000134327824ULL, 0x100fe200078e0237ULL, 0x00000037062e7211ULL, 0x000fe200078ff0ffULL,
0x0000000136347824ULL, 0x100fe200078e0237ULL, 0x000000032f317812ULL, 0x100fe200078e4806ULL,
0x0000000138367824ULL, 0x000fe200078e0237ULL, 0xfffffffc41417812ULL, 0x000fe200078ee206ULL,
0x000000043e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee231ULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee231ULL,
0x000000013a387824ULL, 0x000fe200078e0237ULL, 0xfffffffc48487812ULL, 0x000fe200078ee231ULL,
0x000000013e3a7824ULL, 0x000fe200078e0237ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee231ULL,
0x00000001423e7824ULL, 0x000fe200078e0237ULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee231ULL,
0x00005e002e2e7625ULL, 0x000fe200078e003fULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee231ULL,
0xfffffffc50507812ULL, 0x000fe200078ee231ULL, 0x00005e0032327625ULL, 0x000fe200078e003fULL,
0x0ffffffc31427812ULL, 0x000fc600078ef806ULL, 0x00005e0030307625ULL, 0x000fc800078e003fULL,
0x00005e0034347625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x00000010412e7825ULL, 0x000fc800078e002eULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x0000001041347825ULL, 0x000fc800078e0034ULL, 0x0000001041367825ULL, 0x000fc800078e0036ULL,
0x0000001041387825ULL, 0x000fc800078e0038ULL, 0x00000010413a7825ULL, 0x000fc800078e003aULL,
0x00000010413e7825ULL, 0x000fc800078e003eULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044417824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x0000000030417faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x0000000036477faeULL, 0x0003e8000b901c46ULL, 0x0000000038497faeULL, 0x0003e8000b901c46ULL,
0x000000003a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002006337810ULL, 0x002fe20007ffe0ffULL, 0x0000000200327824ULL, 0x000fe200078e022dULL,
0xfffffff806317812ULL, 0x000fe200078ec0ffULL, 0x00000008402f7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x0000000731347812ULL, 0x000fc400078ef806ULL, 0x0000000733377812ULL, 0x000fe400078ef806ULL,
0x0000000706357812ULL, 0x000fe400078ec0ffULL, 0x00000001ff2e7819ULL, 0x000fe40000011634ULL,
0x00000001ff307819ULL, 0x000fe40000011637ULL, 0x0000200032507811ULL, 0x000fe400078e60ffULL,
0x0000000835517812ULL, 0x000fc400078ef806ULL, 0x000000032e367812ULL, 0x000fe400078ec0ffULL,
0x00000003303e7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000002d36317212ULL, 0x000fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000002f062e7211ULL, 0x000fe400078fe0ffULL, 0x0000002d3e407212ULL, 0x000fe200078e3cffULL,
0x0000000434317824ULL, 0x000fe200078e0231ULL, 0x000000072e307812ULL, 0x140fe400078e7851ULL,
0x000000022e2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001031357824ULL, 0x000fe200078e0250ULL,
0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002051307824ULL, 0x000fe200078e0230ULL,
0x000000072e2e7812ULL, 0x000fe200078e7851ULL, 0x0000000437407824ULL, 0x000fe200078e0240ULL,
0x000000003538783bULL, 0x0002a20000000200ULL, 0x0000001030307824ULL, 0x000fc400078e00ffULL,
0x0000001040407824ULL, 0x000fe400078e0250ULL, 0x00000020512e7824ULL, 0x000fe400078e022eULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000012d357810ULL, 0x042fe20007ffe0ffULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x000000022d2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x00000035363f7212ULL, 0x000fe400078e3cffULL,
0x000000042d00780cULL, 0x000fc60003f25270ULL, 0x00000004343f7824ULL, 0x000fc800078e023fULL,
0x000000103f3f7824ULL, 0x000fca00078e0250ULL, 0x000000003f48783bULL, 0x000f220000000200ULL,
0x00000038ff44723eULL, 0x084fe400020006ffULL, 0x00000038ff45723eULL, 0x000fe400030006ffULL,
0x00000039ff38723eULL, 0x080fe400020006ffULL, 0x00000039ff39723eULL, 0x000fc600030006ffULL,
0x00000044301c723cULL, 0x048fe2000000181cULL, 0x000000002e44783bULL, 0x000eae0000000200ULL,
0x000000383020723cULL, 0x000fee0000001820ULL, 0x0000003aff38723eULL, 0x000fc400020006ffULL,
0x0000003aff39723eULL, 0x000fe400030006ffULL, 0x0000003bff3a723eULL, 0x080fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x000000383024723cULL, 0x040ff00000001824ULL,
0x0000003a3038723cULL, 0x000fee0000001808ULL, 0x000000353e0a7212ULL, 0x000fc400078e3cffULL,
0x00000040ff08723eULL, 0x082fe400020006ffULL, 0x00000040ff09723eULL, 0x000fe200030006ffULL,
0x00000004370a7824ULL, 0x000fe200078e020aULL, 0x00000041ff40723eULL, 0x080fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe200030006ffULL, 0x000000100a0a7824ULL, 0x000fe400078e0250ULL,
0x00000008300c723cULL, 0x040fe6000000180cULL, 0x000000000a4c783bULL, 0x000e680000000200ULL,
0x00000042ff08723eULL, 0x080fe200020006ffULL, 0x000000403010723cULL, 0x000fe20000001810ULL,
0x00000042ff09723eULL, 0x000fc400030006ffULL, 0x00000043ff42723eULL, 0x080fe400020006ffULL,
0x00000043ff43723eULL, 0x000fc600030006ffULL, 0x000000083014723cULL, 0x040fee0000001814ULL,
0x00000048ff08723eULL, 0x090fe200020006ffULL, 0x000000423018723cULL, 0x000fe20000001818ULL,
0x00000048ff09723eULL, 0x000fe400030006ffULL, 0x00000049ff48723eULL, 0x000fc400020006ffULL,
0x00000049ff49723eULL, 0x000fc600030006ffULL, 0x00000008441c723cULL, 0x044fee000000181cULL,
0x0000004aff08723eULL, 0x080fe200020006ffULL, 0x000000484420723cULL, 0x000fe20000001820ULL,
0x0000004aff09723eULL, 0x000fe400030006ffULL, 0x0000004cff30723eULL, 0x002fc400020006ffULL,
0x0000004cff31723eULL, 0x000fe400030006ffULL, 0x0000004dff4c723eULL, 0x080fe200020006ffULL,
0x000000084424723cULL, 0x000fe20000001824ULL, 0x0000004dff4d723eULL, 0x000fcc00030006ffULL,
0x0000004bff08723eULL, 0x080fe200020006ffULL, 0x00000030440c723cULL, 0x000fe2000000180cULL,
0x0000004bff09723eULL, 0x000fcc00030006ffULL, 0x0000004eff30723eULL, 0x080fe200020006ffULL,
0x000000084408723cULL, 0x000fe20000001838ULL, 0x0000004eff31723eULL, 0x000fe400030006ffULL,
0x0000004fff4e723eULL, 0x080fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fc600030006ffULL,
0x0000004c4410723cULL, 0x040ff00000001810ULL, 0x000000304414723cULL, 0x040ff00000001814ULL,
0x0000004e4418723cULL, 0x000fe20000001818ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e002bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffef0000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000282e7f8cULL, 0x000fe2000c80043fULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000002207327220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x00000400282d7984ULL, 0x000e620000000800ULL, 0x0000001e07307220ULL, 0x040fe20000410000ULL,
0x0000001f07317220ULL, 0x040fe20000410000ULL, 0x0000001907227220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x00000015071e7220ULL, 0x040fe20000410000ULL, 0x00000018071f7220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000000a07337220ULL, 0x040fe20000410000ULL, 0x0000000b07347220ULL, 0x040fe20000410000ULL,
0x0000000e07357220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000000807087220ULL, 0x040fe20000410000ULL, 0x0000000907097220ULL, 0x040fe20000410000ULL,
0x0000000c070c7220ULL, 0x040fe20000410000ULL, 0x0000000d070d7220ULL, 0x040fe20000410000ULL,
0x0000000f07367220ULL, 0x040fe20000410000ULL, 0x0000001007027220ULL, 0x040fe20000410000ULL,
0x00000011070a7220ULL, 0x040fe20000410000ULL, 0x0000001207377220ULL, 0x040fe20000410000ULL,
0x0000001307387220ULL, 0x040fe20000410000ULL, 0x00000014070b7220ULL, 0x040fe20000410000ULL,
0x0000001607397220ULL, 0x040fe20000410000ULL, 0x00000017073a7220ULL, 0x040fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001dULL, 0x0000001b073e7220ULL, 0x040fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001cULL, 0x0000001a073b7220ULL, 0x000fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0022ULL, 0x000000ffff117224ULL, 0x000fe400078e0021ULL,
0x000000ffff127224ULL, 0x000fe400078e0024ULL, 0x000000ffff137224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe200078e001eULL, 0x800000002dff7812ULL, 0x002fe2000780482fULL,
0x000000ffff1c7224ULL, 0x000fe400078e001fULL, 0x000000ffff227224ULL, 0x000fc400078e0023ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0030ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0031ULL,
0x000000ffff217224ULL, 0x000fe400078e0032ULL, 0x000000ffff237224ULL, 0x000fe400078e0026ULL,
0x000000ffff247224ULL, 0x000fe400078e0027ULL, 0x000000ffff257224ULL, 0x000fc400078e0033ULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff147224ULL, 0x000fe400078e0008ULL,
0x000000ffff157224ULL, 0x000fe400078e0009ULL, 0x000000ffff167224ULL, 0x000fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000dULL, 0x000000ffff187224ULL, 0x000fc400078e0002ULL,
0x000000ffff197224ULL, 0x000fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fe400078e000bULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff277224ULL, 0x000fe400078e0035ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0036ULL, 0x000000ffff307224ULL, 0x000fc400078e0037ULL,
0x000000ffff317224ULL, 0x000fe400078e0038ULL, 0x000000ffff327224ULL, 0x000fe400078e0039ULL,
0x000000ffff337224ULL, 0x000fe200078e003aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe400078e003bULL,
0x000000ffff357224ULL, 0x000fe200078e003eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200087305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000080000735dULL, 0x004fe20003800000ULL,
0x0000040028097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000406207824ULL, 0x000fe200078e00ffULL,
0x000000293c00720cULL, 0x000fc80003f05270ULL, 0xfffffff020097812ULL, 0x000fca00078ec0ffULL,
0x0000008000027824ULL, 0x000fca00078e0209ULL, 0x0104000002087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002060c7824ULL, 0x000fe400078e00ffULL,
0x00000001032c7824ULL, 0x000fc600078e0a2cULL, 0x000000060c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000010d2f7812ULL, 0x040fe400078efcffULL, 0x000000080d377812ULL, 0x000fe400078efcffULL,
0x0000002c2f00720cULL, 0x080fe40003f26070ULL, 0x000000100d2f7812ULL, 0x000fe400078efcffULL,
0x0000002c3700720cULL, 0x080fe40003f06070ULL, 0x0000002c2f00720cULL, 0x000fc40003fc6070ULL,
0x000000110d377812ULL, 0x040fe400078efcffULL, 0x000000180d2f7812ULL, 0x040fe400078efcffULL,
0x0000002c0d00720cULL, 0x080fe40003f46070ULL, 0x0000002c3700720cULL, 0x080fe40003fa6070ULL,
0x0000002c2f00720cULL, 0x000fe40003f66070ULL, 0x000000090d397812ULL, 0x000fc400078efcffULL,
0x000000190d377812ULL, 0x040fe400078efcffULL, 0x000000200d2f7812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x0000002c3900720cULL, 0x080fe40003f86070ULL, 0x0000002c3700720cULL, 0x080fe40003f46070ULL,
0x0000002c2f00720cULL, 0x000fe40003f26070ULL, 0x000000210d377812ULL, 0x040fe400078efcffULL,
0x000000280d2f7812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff22227808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x0000002c3700720cULL, 0x080fe40003f06070ULL,
0x0000002c2f00720cULL, 0x000fe40003f86070ULL, 0x000000290d377812ULL, 0x000fc400078efcffULL,
0x000000300d2f7812ULL, 0x000fe400078efcffULL, 0xff7fffff23237808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x0000002c3700720cULL, 0x000fc40003fc6070ULL,
0x0000002c2f00720cULL, 0x000fe40003fa6070ULL, 0x000000310d377812ULL, 0x040fe400078efcffULL,
0x000000380d2f7812ULL, 0x040fe400078efcffULL, 0x000000390d0d7812ULL, 0x000fe400078efcffULL,
0xff7fffff25257808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff26267808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x0000002c3700720cULL, 0x080fe40003f66070ULL, 0x0000002c2f00720cULL, 0x000fc40003f46070ULL,
0x0000002c0d00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff30307808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff31317808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff32327808ULL, 0x000fe40006800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff33337808ULL, 0x000fe40005800000ULL, 0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL,
0xff7fffff34347808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff35357808ULL, 0x000fe40004800000ULL, 0x0000000f080d7209ULL, 0x004fe20007810000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x0000001e09087209ULL, 0x000fe20007810000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d7209ULL, 0x000fe40007810000ULL,
0x0000001f08087209ULL, 0x000fc40007810000ULL, 0x000000100d0c7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fe40007810000ULL, 0x000000110c0d7209ULL, 0x000fe40007810000ULL,
0x0000002209087209ULL, 0x000fe40007810000ULL, 0x000000120d0c7209ULL, 0x000fe40007810000ULL,
0x0000002308097209ULL, 0x000fc40007810000ULL, 0x000000130c0d7209ULL, 0x000fe40007810000ULL,
0x0000002409087209ULL, 0x000fe40007810000ULL, 0x000000140d0c7209ULL, 0x000fe40007810000ULL,
0x0000002508097209ULL, 0x000fe40007810000ULL, 0x000000150c0d7209ULL, 0x000fe40007810000ULL,
0x0000002609087209ULL, 0x000fc40007810000ULL, 0x000000160d0c7209ULL, 0x000fe40007810000ULL,
0x0000002708087209ULL, 0x000fe40007810000ULL, 0x000000170c097209ULL, 0x000fe40007810000ULL,
0x0000002d080d7209ULL, 0x000fe40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x000000300d0c7209ULL, 0x000fc40007810000ULL, 0x0000001908097209ULL, 0x000fe40007810000ULL,
0x000000310c0d7209ULL, 0x000fe40007810000ULL, 0x0000001a09087209ULL, 0x000fe40007810000ULL,
0x000000320d0c7209ULL, 0x000fe40007810000ULL, 0x0000001b08097209ULL, 0x000fe40007810000ULL,
0x000000330c0d7209ULL, 0x000fc40007810000ULL, 0x0000001c09087209ULL, 0x000fe40007810000ULL,
0x000000340d0c7209ULL, 0x000fe40007810000ULL, 0x0000001d082e7209ULL, 0x000fe40007810000ULL,
0x000000350c367209ULL, 0x000fe20007810000ULL, 0x00001a727f007947ULL, 0x000fea000b800000ULL,
0x0c401f002e087f89ULL, 0x0004e400000e0000ULL, 0x000000082e377209ULL, 0x008fe20007810000ULL,
0x00001a927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0036087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b2c7f89ULL, 0x000f6200000e0000ULL,
0x00000008360c7209ULL, 0x008fc60007810000ULL, 0x0c201f0037087f89ULL, 0x000ee200000e0000ULL,
0x000000090a0d7209ULL, 0x010fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000f2200000e0000ULL,
0x0000002c0b2c7209ULL, 0x020fc60007810000ULL, 0x0c201f000d2e7f89ULL, 0x006e6800000e0000ULL,
0x0c201f002c2f7f89ULL, 0x0004a200000e0000ULL, 0x0000000837087209ULL, 0x008fe40007810000ULL,
0x000000090c097209ULL, 0x010fe40007810000ULL, 0x0000002e0d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b092e7820ULL, 0x002fe20000410000ULL,
0x3c003c00ff367424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3c003c00ff377424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082eULL,
0x0000000e000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1d0b7823ULL, 0x000fe2000001080bULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000c0d0c723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b352e7823ULL, 0x000fe2000001082eULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000000ffULL,
0x00000021000f7308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001e1f0d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000000f220f723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000360c38723cULL, 0x000fee00000018ffULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fce00000000ffULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ee20000000800ULL, 0x000000232411723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x008fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000361038723cULL, 0x000fee0000001838ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ee20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002d001e7308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x008fe200000000ffULL,
0x0000000fff197424ULL, 0x000fe200078e00ffULL, 0xfffffffc06187812ULL, 0x000fca00078ec0ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0x000000271e15723eULL, 0x002fce00000000ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000303117723eULL, 0x008fce00000000ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000001819307219ULL, 0x000fc800000006ffULL, 0x00000000301f73a1ULL, 0x000ee200000e8000ULL,
0x000000361438723cULL, 0x000fe20000001838ULL, 0x00000000300473c4ULL, 0x000f220000004000ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000f620000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000000530ff7c12ULL, 0x008fce000f80401fULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x0000001c0b1a723eULL, 0x020fe400000000ffULL, 0x0000002c2f0b7209ULL, 0x004fca0007810000ULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000002e001d7308ULL, 0x000ea20000000800ULL,
0x000000323319723eULL, 0x002fe400000000ffULL, 0x000000341d1b723eULL, 0x004fce00000000ffULL,
0x000000361838723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000015c204008947ULL, 0x010fde000b800000ULL, 0x001c1fff381c7589ULL, 0x0002a400000e0000ULL,
0x00000000301d73a1ULL, 0x000ee200000e8000ULL, 0x00000000300473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000530ff7c12ULL, 0x008fda000f80401dULL,
0x000015d204008947ULL, 0x010fea000b800000ULL, 0x001c1fff3a1d7589ULL, 0x00072800000e0000ULL,
0x001c1fff011e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff217819ULL, 0x000fe40000011606ULL, 0x0000000c203b7812ULL, 0x000fc400078ec0ffULL,
0x0000000721227812ULL, 0x040fe200078ec0ffULL, 0x0000000821277824ULL, 0x040fe200078e00ffULL,
0x00000021ff257212ULL, 0x000fe200078e33ffULL, 0x0000000821237824ULL, 0x040fe200078e00ffULL,
0x0000000306ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000821367824ULL, 0x040fe200078e00ffULL,
0x0000000821217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee222ULL,
0x0000000123267812ULL, 0x100fe200078ef622ULL, 0x0000000821487824ULL, 0x000fe200078e00ffULL,
0x00000002232c7812ULL, 0x100fe200078ef622ULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0x00000003232e7812ULL, 0x000fc400078ef622ULL, 0x0000000423307812ULL, 0x14afe400078ef622ULL,
0x0000000523327812ULL, 0x140fe400078ef622ULL, 0x0000000623347812ULL, 0x000fe200078ef622ULL,
0x0000000821237824ULL, 0x040fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe400078ee225ULL,
0x00000021ff257212ULL, 0x000fe400078e33ffULL, 0x0000000721227812ULL, 0x000fc400078ec0ffULL,
0x0000a00000217811ULL, 0x000fe400078e58ffULL, 0xfffffff827387812ULL, 0x100fe400078ee222ULL,
0x00000001233a7812ULL, 0x140fe200078ef622ULL, 0x0000001024207824ULL, 0x000fe200078e0221ULL,
0xfffffff848487812ULL, 0x000fe200078ee225ULL, 0x000000102c247824ULL, 0x100fe200078e0221ULL,
0x00000002233e7812ULL, 0x140fe200078ef622ULL, 0x00000010302c7824ULL, 0x100fe200078e0221ULL,
0x0000000323407812ULL, 0x140fe200078ef622ULL, 0x0000001034307824ULL, 0x100fe200078e0221ULL,
0x0000000423427812ULL, 0x140fe200078ef622ULL, 0x000000103a347824ULL, 0x100fe200078e0221ULL,
0x0000000523447812ULL, 0x140fe200078ef622ULL, 0x000000103e357824ULL, 0x100fe200078e0221ULL,
0x0000000623467812ULL, 0x000fe200078ef622ULL, 0x0000001026227824ULL, 0x000fc400078e0221ULL,
0x000000102e267824ULL, 0x100fe400078e0221ULL, 0x00000010322e7824ULL, 0x100fe400078e0221ULL,
0x000000013b237824ULL, 0x000fe400078e0220ULL, 0x0000001036327824ULL, 0x100fe400078e0221ULL,
0x0000001038207824ULL, 0x100fe200078e0221ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000001040367824ULL, 0x000fc400078e0221ULL, 0x0000001042377824ULL, 0x100fe400078e0221ULL,
0x0000001044387824ULL, 0x100fe400078e0221ULL, 0x0000001046397824ULL, 0x100fe400078e0221ULL,
0x00000010483a7824ULL, 0x000fe400078e0221ULL, 0x000000013b217824ULL, 0x040fe400078e0222ULL,
0x000000013b257824ULL, 0x000fc400078e0224ULL, 0x000000013b277824ULL, 0x040fe200078e0226ULL,
0x0000000e21007388ULL, 0x0007e20000000800ULL, 0x000000013b2d7824ULL, 0x040fe400078e022cULL,
0x000000013b2f7824ULL, 0x040fe200078e022eULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x000000013b317824ULL, 0x040fe400078e0230ULL, 0x000000013b337824ULL, 0x040fe200078e0232ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x000000013b207824ULL, 0x000fc400078e0220ULL,
0x000000013b347824ULL, 0x040fe200078e0234ULL, 0x000000142d007388ULL, 0x0007e20000000800ULL,
0x000000013b227824ULL, 0x040fe400078e0235ULL, 0x000000013b367824ULL, 0x040fe200078e0236ULL,
0x000000162f007388ULL, 0x0007e20000000800ULL, 0x000000013b0c7824ULL, 0x042fe400078e0237ULL,
0x000000013b387824ULL, 0x040fe200078e0238ULL, 0x0000001831007388ULL, 0x0007e20000000800ULL,
0x000000013b247824ULL, 0x000fc400078e0239ULL, 0x000000013b3a7824ULL, 0x000fe200078e023aULL,
0x0000001a33007388ULL, 0x0007e80000000800ULL, 0x0000000d20007388ULL, 0x0007e80000000800ULL,
0x0000000f34007388ULL, 0x0007e80000000800ULL, 0x0000001122007388ULL, 0x0007e80000000800ULL,
0x0000001336007388ULL, 0x0007e80000000800ULL, 0x000000150c007388ULL, 0x0007e80000000800ULL,
0x0000001738007388ULL, 0x0007e80000000800ULL, 0x0000001924007388ULL, 0x0007e80000000800ULL,
0x0000001b3a007388ULL, 0x0007e80000000800ULL, 0x0100000802008388ULL, 0x0007e80000000c00ULL,
0x0102001c02008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002aff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003003c3c7a10ULL, 0x000fe20007ffe0ffULL, 0x000018002aff7f8cULL, 0x0003e6000c80043fULL,
0x0000003d3c00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffd31000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7807ULL, 0x004fe40004800000ULL, 0x0000fe70002b7802ULL, 0x000fe40000000f00ULL,
0x0000119000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e002aULL,
0xffff167000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x0000fec0002b7802ULL, 0x000fe40000000f00ULL, 0x0000114000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e002aULL, 0xffff16a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x0000ff20002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000010a000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e002eULL, 0xffff16e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x0000ff80002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000104000007944ULL, 0x018fea0003c00000ULL,
0xffff16c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x000fe200078e0054ULL,
0x0000ffe0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000fe000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff397224ULL, 0x004fe200078e002eULL, 0xffff1a3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e0053ULL, 0x00010050002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000f7000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff367224ULL, 0x004fe200078e002eULL,
0xffff19f000007947ULL, 0x000fea000383ffffULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x000100b0002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000f1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e002eULL,
0xffff270000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010120002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000ea000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e002eULL, 0xffff26b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004800000ULL, 0x00010170002b7802ULL, 0x000fe40000000f00ULL,
0x00000e9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e002aULL,
0xffff336000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x000101c0002b7802ULL, 0x000fe40000000f00ULL, 0x00000e4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e002aULL, 0xffff339000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x002fe200078e00ffULL, 0x00010220002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000da000007944ULL, 0x014fea0003c00000ULL,
0xffff33f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010280002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000d4000007944ULL, 0x010fea0003c00000ULL,
0xffff34b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x000102d0002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000cf000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e002eULL,
0xffff371000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010340002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000c8000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff667224ULL, 0x004fe200078e002eULL, 0xffff36c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x000103a0002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000c2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e002eULL, 0xffff421000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e0053ULL, 0x00010410002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000bb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff667224ULL, 0x004fe200078e002eULL,
0xffff41c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004800000ULL,
0x00010460002b7802ULL, 0x000fe40000000f00ULL, 0x00000ba000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e002aULL, 0xffff4df000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40004800000ULL, 0x000104b0002b7802ULL, 0x000fe40000000f00ULL,
0x00000b5000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e002aULL,
0xffff4e2000007947ULL, 0x000fea000383ffffULL, 0x0000001fff317424ULL, 0x002fe200078e00ffULL,
0x00010510002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000ab000007944ULL, 0x014fea0003c00000ULL, 0xffff4e8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e0053ULL, 0x00010570002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000a5000007944ULL, 0x010fea0003c00000ULL, 0xffff4f4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x000105c0002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000a0000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e002eULL, 0xffff51a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e0053ULL, 0x00010630002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000099000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e002eULL,
0xffff515000007947ULL, 0x000fea000383ffffULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x00010690002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000093000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e002eULL,
0xffff5ca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010700002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000008c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e002eULL, 0xffff5c5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004800000ULL, 0x00010750002b7802ULL, 0x000fe40000000f00ULL,
0x000008b000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e002aULL,
0xffff688000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x000107a0002b7802ULL, 0x000fe40000000f00ULL, 0x0000086000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e002aULL, 0xffff68b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x004fe200078e00ffULL, 0x00010800002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000007c000007944ULL, 0x012fea0003c00000ULL,
0xffff691000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010860002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000076000007944ULL, 0x010fea0003c00000ULL,
0xffff69d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x000108b0002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000071000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e002eULL,
0xffff6c3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0053ULL,
0x00010920002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000006a000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x004fe200078e002eULL, 0xffff6be000007947ULL, 0x000fea000383ffffULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x00010980002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e002eULL, 0xffff776000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e0053ULL, 0x000109f0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x000005d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002eULL,
0xffff771000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2f7424ULL, 0x000fe200078e00ffULL,
0x00010a40000c7802ULL, 0x000fe40000000f00ULL, 0x0000054000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e002fULL, 0xffffe55000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x006fe200078e0036ULL, 0x00010aa0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x0000002f36367209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e000aULL,
0x00010af0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e000bULL, 0x00010b40000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0b2c7209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0037ULL,
0x00010b90000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000002f37087209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0036ULL, 0x00010be0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f36097209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e000aULL,
0x00010c30000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e002cULL, 0x00010c80000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0xffffe41000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0038ULL,
0x00010ce0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fc400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000002e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e002eULL, 0xffffe9e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x002fe200078e003aULL, 0x00010d50002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff327224ULL, 0x000fe400078e00ffULL, 0x00001c1fff317424ULL, 0x000fe400078e00ffULL,
0x0000027000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff327224ULL, 0x002fe200078e00ffULL,
0x00010da0002c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x004fe400078e002eULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff327224ULL, 0x002fe200078e00ffULL, 0x00010df0002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff317424ULL, 0x000fc400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e002eULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e002eULL,
0xffffe95000007947ULL, 0x000fea000383ffffULL, 0x0180000041037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000004100038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff41ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000041057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000004100037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff197424ULL, 0x000fc800078e00ffULL, 0xfffef08018007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0c00002f2e2f7389ULL, 0x0002a200000e0038ULL, 0xfffef0400c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000003000007348ULL, 0x000fe80003800000ULL,
0x000000322f2e7389ULL, 0x0002a200000e0031ULL, 0xfffef0002c007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f25070ULL, 0x0000005100007348ULL, 0x000fe80003800000ULL,
0x00000000ff0d7424ULL, 0x000fd000078e00ffULL, 0x00000000000c7806ULL, 0x000fc800048e0100ULL,
0x000000510c2a7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e002bULL,
0xfffeef900c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000005b8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c28ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017b4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000017e8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001808ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001898ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000018b0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a80ULL, 0x0000000000011100ULL, 0x6e00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012b80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012b90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012b90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013010ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001898ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000112e8ULL, 0x00000000000112e8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012b80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013010ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 78064;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
