/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011310ULL, 0x0000000000010e90ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000000f7d0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x000000000000f960ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000000f9a0ULL, 0x00000000000000e0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000000fa80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000f7d000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x003d540400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8a08288080820828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808a920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0000f7d000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8088288080820900ULL, 0x0900000004042880ULL, 0x288080822880808aULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8a08288080820828ULL, 0x288080b008288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b0ULL, 0x0000001cffffffffULL,
0x0000010800000000ULL, 0x0000f96000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8a08288080820828ULL, 0x288080b008288080ULL,
0x8280162880809608ULL, 0x0000000003102880ULL, 0x8080969200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000018800000000ULL, 0x0000f9a000000000ULL, 0x000000e000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x0008120400000069ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL,
0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL,
0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL,
0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0018310400ff1b03ULL,
0x0000ed000000e780ULL, 0x0000ed800000ed10ULL, 0x0000eda00000ed90ULL, 0xffffffff01082904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500002bffffffffULL, 0x0500002b0500002bULL, 0xffffffff0500002bULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01082804ffffffffULL, 0x000000f000000090ULL, 0x000015f000001560ULL, 0x000016a000001670ULL,
0x00001b8000001ae0ULL, 0x0000274000002700ULL, 0x0000331000003290ULL, 0x000033b000003380ULL,
0x000037a000003790ULL, 0x0000422000004210ULL, 0x00004dc000004d40ULL, 0x00004e6000004e30ULL,
0x0000526000005250ULL, 0x00005cd000005cc0ULL, 0x00006850000067d0ULL, 0x000068f0000068c0ULL,
0x00006cf000006ce0ULL, 0x0000779000007780ULL, 0x00007f7000007f60ULL, 0x0000a370000086f0ULL,
0x0000ab400000a580ULL, 0x0000b3b00000ab70ULL, 0x0000e6800000e650ULL, 0x0000e6a00000e690ULL,
0x0000e6e00000e6c0ULL, 0x0000e7100000e700ULL, 0x0000edd00000ed70ULL, 0x0000edf00000ede0ULL,
0x0000f4700000f410ULL, 0x0000f5100000f4c0ULL, 0x0000f5b00000f560ULL, 0x0000f6500000f600ULL,
0x0000f7100000f6a0ULL, 0x0000f7b00000f760ULL, 0x0000016005e03904ULL, 0x00010600000000ffULL,
0x00000190003f0100ULL, 0x0001060800000011ULL, 0x000001c0003f0130ULL, 0x0001061000000011ULL,
0x00000220003f0130ULL, 0x0001064800000011ULL, 0x00000230003f0120ULL, 0x00010658000000ffULL,
0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x000007e0003f0107ULL, 0x000000040000000cULL,
0x00000a90003f0102ULL, 0x000000000000000cULL, 0x00000c50003f0101ULL, 0x00010648000000ffULL,
0x00000cd0003f0107ULL, 0x00010658000000ffULL, 0x00000e10003f0101ULL, 0x0001065c000000ffULL,
0x00000e60003f0106ULL, 0x0001065c000000ffULL, 0x00000ee0003f0106ULL, 0x0001065c000000ffULL,
0x00001310003f0106ULL, 0x00010650000000ffULL, 0x00001380003f0107ULL, 0x0001064c000000ffULL,
0x000013a0003f0106ULL, 0x0001060c000000ffULL, 0x000014a0003f0106ULL, 0x0001060c000000ffULL,
0x00001900003f0106ULL, 0x0001064c000000ffULL, 0x000019a0003f0106ULL, 0x0001064c000000ffULL,
0x00002120003f0106ULL, 0x00010658000000ffULL, 0x00002130003f0101ULL, 0x0001065c000000ffULL,
0x00002170003f0106ULL, 0x0001065c000000ffULL, 0x000021f0003f0106ULL, 0x0001065c000000ffULL,
0x000024b0003f0106ULL, 0x00010648000000ffULL, 0x00002520003f0107ULL, 0x00010654000000ffULL,
0x00002590003f0106ULL, 0x00010654000000ffULL, 0x00002630003f0106ULL, 0x00010654000000ffULL,
0x00002ca0003f0106ULL, 0x00010658000000ffULL, 0x00002d10003f0101ULL, 0x00010610000000ffULL,
0x00002d60003f0101ULL, 0x0001065c000000ffULL, 0x00002da0003f0106ULL, 0x0001065c000000ffULL,
0x00002e20003f0106ULL, 0x0001065c000000ffULL, 0x000030a0003f0106ULL, 0x00010650000000ffULL,
0x00003110003f0107ULL, 0x0001064c000000ffULL, 0x00003130003f0106ULL, 0x0001061c000000ffULL,
0x00003210003f0106ULL, 0x0001061c000000ffULL, 0x00003620003f0106ULL, 0x0001064c000000ffULL,
0x000036c0003f0106ULL, 0x0001064c000000ffULL, 0x00003cc0003f0106ULL, 0x00010658000000ffULL,
0x00003cd0003f0101ULL, 0x0001065c000000ffULL, 0x00003d10003f0106ULL, 0x0001065c000000ffULL,
0x00003d90003f0106ULL, 0x0001065c000000ffULL, 0x00004010003f0106ULL, 0x00010648000000ffULL,
0x00004080003f0107ULL, 0x00010654000000ffULL, 0x000040d0003f0106ULL, 0x00010654000000ffULL,
0x00004160003f0106ULL, 0x00010654000000ffULL, 0x00004750003f0106ULL, 0x00010658000000ffULL,
0x000047c0003f0101ULL, 0x00010620000000ffULL, 0x00004810003f0101ULL, 0x0001065c000000ffULL,
0x00004850003f0106ULL, 0x0001065c000000ffULL, 0x000048d0003f0106ULL, 0x0001065c000000ffULL,
0x00004b50003f0106ULL, 0x00010650000000ffULL, 0x00004bc0003f0107ULL, 0x0001064c000000ffULL,
0x00004be0003f0106ULL, 0x0001062c000000ffULL, 0x00004cc0003f0106ULL, 0x0001062c000000ffULL,
0x000050d0003f0106ULL, 0x0001064c000000ffULL, 0x00005170003f0106ULL, 0x0001064c000000ffULL,
0x00005770003f0106ULL, 0x00010658000000ffULL, 0x00005780003f0101ULL, 0x0001065c000000ffULL,
0x000057c0003f0106ULL, 0x0001065c000000ffULL, 0x00005840003f0106ULL, 0x0001065c000000ffULL,
0x00005ac0003f0106ULL, 0x00010648000000ffULL, 0x00005b30003f0107ULL, 0x00010654000000ffULL,
0x00005b80003f0106ULL, 0x00010654000000ffULL, 0x00005c10003f0106ULL, 0x00010654000000ffULL,
0x00006200003f0106ULL, 0x00010658000000ffULL, 0x00006270003f0101ULL, 0x00010630000000ffULL,
0x000062c0003f0101ULL, 0x0001065c000000ffULL, 0x00006300003f0106ULL, 0x0001065c000000ffULL,
0x00006380003f0106ULL, 0x0001065c000000ffULL, 0x00006600003f0106ULL, 0x00010650000000ffULL,
0x00006670003f0107ULL, 0x0001064c000000ffULL, 0x00006690003f0106ULL, 0x0001063c000000ffULL,
0x00006750003f0106ULL, 0x0001063c000000ffULL, 0x00006b60003f0106ULL, 0x0001064c000000ffULL,
0x00006c00003f0106ULL, 0x0001064c000000ffULL, 0x00007200003f0106ULL, 0x00010658000000ffULL,
0x00007210003f0101ULL, 0x0001065c000000ffULL, 0x00007250003f0106ULL, 0x0001065c000000ffULL,
0x000072d0003f0106ULL, 0x0001065c000000ffULL, 0x00007580003f0106ULL, 0x00010648000000ffULL,
0x000075f0003f0107ULL, 0x00010654000000ffULL, 0x00007640003f0106ULL, 0x00010654000000ffULL,
0x000076d0003f0106ULL, 0x00010654000000ffULL, 0x00007cc0003f0106ULL, 0x00010658000000ffULL,
0x00007d20003f0101ULL, 0x00010640000000ffULL, 0x0000c390003f0101ULL, 0x00010604000000ffULL,
0x0000c420003f0106ULL, 0x00010604000000ffULL, 0x0000c750003f0106ULL, 0x00010600000000ffULL,
0x0000c760003f0101ULL, 0x00010604000000ffULL, 0x0000c7e0003f0106ULL, 0x00010604000000ffULL,
0x0000db10003f0106ULL, 0x000106140000003bULL, 0x0000df30003f0106ULL, 0x000106140000003bULL,
0x0000f370003f0106ULL, 0x000106080000003bULL, 0x00053803003f0101ULL, 0x0000b81000101c04ULL,
0x0000c8d00000c830ULL, 0x000004010000f3d0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001fcULL,
0x0000001100000002ULL, 0x0000000000000174ULL, 0x0000001100000002ULL, 0x00000000000000dcULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001d4ULL,
0x0000001100000002ULL, 0x000000000000014fULL, 0x0000001100000002ULL, 0x00000000000000b2ULL,
0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000c7919ULL, 0x000e620000002300ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000d7919ULL, 0x000ea80000002100ULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x0000000000167919ULL, 0x000f220000002600ULL,
0x000000010c007824ULL, 0x002fc600078e0203ULL, 0x00001fff0c0c7589ULL, 0x000e6200000e0000ULL,
0x0000008000117824ULL, 0x104fe200078e020dULL, 0x00000005ff0d7819ULL, 0x000fe2000001160dULL,
0x00006000140a7625ULL, 0x008fc600078e000bULL, 0x000000ff1100720cULL, 0x040fe40003f65270ULL,
0x000000031100780cULL, 0x040fe20003f04070ULL, 0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL,
0x0000007f1100780cULL, 0x040fe40003f24070ULL, 0x000000011100780cULL, 0x000fce0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01060002ff00b388ULL, 0x0007e20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x0106080411008388ULL, 0x0007e2000000ca00ULL,
0xff317217ff009424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL,
0x0106100611008388ULL, 0x0007e2000000ca00ULL, 0x000000ff0c00720cULL, 0x002fe20003f05270ULL,
0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0eb424ULL, 0x000fe200078e00ffULL,
0x0104000011009388ULL, 0x0007e20000004800ULL, 0x7fffff80ff0fb424ULL, 0x000fc600078e00ffULL,
0x010648081100a388ULL, 0x0007e80000008a00ULL, 0x0106580eff00b388ULL, 0x0007e80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003b000000947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x01ce620000000000ULL, 0x000000040d027824ULL, 0x000fc400078e00ffULL,
0x00005800ff007624ULL, 0x000fe400078e00ffULL, 0x0000001016037824ULL, 0x000fe400078e00ffULL,
0x0000001000007824ULL, 0x000fe400078e00ffULL, 0x00000200ff157424ULL, 0x000fe400078e00ffULL,
0x0000001400007224ULL, 0x000fe200078e0203ULL, 0x0000000211057211ULL, 0x002fc800078fd8ffULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x00000003050f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000705027812ULL, 0x000fe400078ec0ffULL, 0x0000000707037812ULL, 0x000fe400078ec0ffULL,
0x000000070f0e7812ULL, 0x000fe400078ec0ffULL, 0x0000001f02027812ULL, 0x000fc400078e7811ULL,
0x0000000205097810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03047812ULL, 0x100fe200078e7811ULL,
0x0000001011037824ULL, 0x000fe200078e00ffULL, 0x0000001f0e127812ULL, 0x000fe200078e7811ULL,
0x00000020050e7824ULL, 0x000fe200078e0202ULL, 0x0000000709067812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x000fe200078e0205ULL, 0x000001f003137812ULL, 0x000fe200078ec0ffULL,
0x0000002007107824ULL, 0x000fe200078e0204ULL, 0x0000001f06087812ULL, 0x000fe200078e7811ULL,
0x00005c0002027625ULL, 0x000fc800078e0015ULL, 0x0000000100047824ULL, 0x000fe200078e0207ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x040fe400078e0209ULL,
0x0000000100117824ULL, 0x000fe400078e020fULL, 0x00005c0004047625ULL, 0x000fc800078e0015ULL,
0x0000002009007824ULL, 0x000fe200078e0208ULL, 0x0000001304047210ULL, 0x000fe20007f3e0ffULL,
0x00005c0006067625ULL, 0x000fc800078e0015ULL, 0x00005c0011087625ULL, 0x000fc800078e0015ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001306067210ULL, 0x080fe20007f1e0ffULL,
0x000000200f127824ULL, 0x000fe200078e0212ULL, 0x0000001308087210ULL, 0x000fe20007f5e0ffULL,
0x000000100e0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400000e0607ULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x0000000004117faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fe400010e0609ULL, 0x0000001012157824ULL, 0x000fe200078e00ffULL,
0x0000000006137faeULL, 0x0003e8000b901c46ULL, 0x0000000008157faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060a007981ULL, 0x01cea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff0f7e24ULL, 0x00afe2000f8e00ffULL, 0x000000ff00027810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff027819ULL, 0x000fce0000011602ULL, 0x0000b1a000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000001000f077824ULL, 0x040fe200078e00ffULL,
0x0000580016057a10ULL, 0x000fe20007ffe0ffULL, 0x0000000214047824ULL, 0x000fe200078e00ffULL,
0x000000010f097810ULL, 0x000fe20007ffe0ffULL, 0x00000003ff117424ULL, 0x000fe200078e00ffULL,
0x0000000700067217ULL, 0x000fe20007800000ULL, 0x0000580004047a24ULL, 0x000fe200078e0205ULL,
0x000000020900720cULL, 0x000fe20003f06070ULL, 0x000000080d057824ULL, 0x040fe200078e00ffULL,
0x000106100d0c7811ULL, 0x000fe200078e20ffULL, 0x0000000106067824ULL, 0x000fe200078e0a07ULL,
0x00000004ff0a7819ULL, 0x002fe20000011603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001050b7824ULL, 0x000fe200078e020aULL, 0x0000002006067807ULL, 0x000fe20000000000ULL,
0x0000620004087a24ULL, 0x000fe200078e0207ULL, 0x000000020a107810ULL, 0x000fe20007ffe0ffULL,
0x000004110cff738cULL, 0x0003e20000000000ULL, 0x000000070b0e7812ULL, 0x000fe200078ec0ffULL,
0x00000100ff177424ULL, 0x000fe200078e00ffULL, 0x0000000506067217ULL, 0x000fe20007800000ULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000f0e0e7812ULL, 0x000fc400078e7803ULL,
0x000000040a127810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0a05ULL,
0x000000060a147810ULL, 0x000fe20007ffe0ffULL, 0x000000100b0e7824ULL, 0x000fe200078e020eULL,
0x000000f015157812ULL, 0x000fe200078ec0ffULL, 0x0000000108067824ULL, 0x000fe200078e020bULL,
0x000000090a00720cULL, 0x080fe20003f66070ULL, 0x00000001050b7824ULL, 0x040fe200078e0210ULL,
0x000000091000720cULL, 0x080fe20003f46070ULL, 0x0000000105137824ULL, 0x000fe200078e0214ULL,
0x000000091200720cULL, 0x000fe20003f26070ULL, 0x00005e0006067625ULL, 0x000fe200078e0017ULL,
0x000000091400720cULL, 0x000fc40003f06070ULL, 0x000000070b0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000105097824ULL, 0x000fe200078e0212ULL, 0x0000000713167812ULL, 0x000fe400078ec0ffULL,
0x0000000f0a0a7812ULL, 0x100fe400078e7803ULL, 0x0000000709127812ULL, 0x000fe400078ec0ffULL,
0x0000001506107210ULL, 0x000fe20007f9e0ffULL, 0x000000100b147824ULL, 0x000fe200078e020aULL,
0x0000000f12127812ULL, 0x000fe200078e7803ULL, 0x0000000108067824ULL, 0x000fe200078e020bULL,
0x0000000f16187812ULL, 0x000fe200078e7803ULL, 0x00000001080a7824ULL, 0x000fc400078e0209ULL,
0x00000001080b7824ULL, 0x000fe400078e0213ULL, 0x0000001009167824ULL, 0x000fe400078e0212ULL,
0x000000ffff117224ULL, 0x002fe400020e0607ULL, 0x00005e000a087625ULL, 0x000fc800078e0017ULL,
0x0000001013187824ULL, 0x000fe400078e0218ULL, 0x00005e0006067625ULL, 0x000fc800078e0017ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000001506127210ULL, 0x080fe20007f9e0ffULL, 0x000000000cff7f8cULL, 0x0003e2000c80043fULL,
0x0000001508087210ULL, 0x080fe20007fbe0ffULL, 0xff317217ff067424ULL, 0x000fe200078e00ffULL,
0x000000150a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0607ULL,
0x0000c0000e157811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x0000c00014177811ULL, 0x000fe200078e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000c00016197811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000d901c46ULL, 0x0000c000181b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000012177faeULL, 0x0003e2000d101c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000008197faeULL, 0x0003e2000c901c46ULL, 0x000000020f00720cULL, 0x000fe20003f26070ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000000a1b7faeULL, 0x0003e2000c101c46ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fc400078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000703000001947ULL, 0x000fea0003800000ULL,
0x000000040d087824ULL, 0x000fe200078e00ffULL, 0x00007610ff617816ULL, 0x000fe20000000061ULL,
0xff317217ff067424ULL, 0x000fe200078e00ffULL, 0x00007610ff097816ULL, 0x000fe20000000009ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x00000002080a7810ULL, 0x000fc40007ffe0ffULL,
0x000001000f0b7824ULL, 0x000fca00078e00ffULL, 0x000000000b00720cULL, 0x000fda0003f06070ULL,
0x00006f4000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x00007610610b7816ULL, 0x000fe2000000000bULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x01065c00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000200f117811ULL, 0x000fe200078e40ffULL, 0x00000100ff3a7424ULL, 0x000fe200078e00ffULL,
0x00000004ff387819ULL, 0x000fe20000011603ULL, 0x00000010035b7824ULL, 0x000fe200078e00ffULL,
0x00000011000e7217ULL, 0x000fe40007800000ULL, 0x000000010f137810ULL, 0x000fe20007ffe0ffULL,
0x0000000105477824ULL, 0x000fe200078e0238ULL, 0x0000000238467810ULL, 0x000fe20007ffe0ffULL,
0x000000010e107824ULL, 0x100fe200078e0a11ULL, 0x000000021300720cULL, 0x000fe20003f06070ULL,
0x00006200040e7a24ULL, 0x000fe200078e0211ULL, 0x0000000438447810ULL, 0x000fe20007ffe0ffULL,
0x0000000105437824ULL, 0x000fe200078e0246ULL, 0x0000002010127807ULL, 0x000fe20000000000ULL,
0x0000000147117824ULL, 0x000fe200078e020eULL, 0x0000000638427810ULL, 0x000fe20007ffe0ffULL,
0x0000000105417824ULL, 0x000fe200078e0244ULL, 0x000000f05b457812ULL, 0x000fe200078ec0ffULL,
0x00005e0011107625ULL, 0x000fe200078e003aULL, 0x00000012052e7217ULL, 0x000fc60007800000ULL,
0x0000000143137824ULL, 0x100fe200078e020eULL, 0x0000004510107210ULL, 0x000fe20007f3e0ffULL,
0x00000001412c7824ULL, 0x000fe400078e020eULL, 0x0000000105407824ULL, 0x000fe400078e0242ULL,
0x00005e0013127625ULL, 0x000fc600078e003aULL, 0x00000007403c7812ULL, 0x000fe200078ec0ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e003aULL, 0x0000004512127210ULL, 0x000fc60007f5e0ffULL,
0x000000012e397824ULL, 0x000fe200078e0a05ULL, 0x000000452c2c7210ULL, 0x000fe20007f7e0ffULL,
0x00000001402f7824ULL, 0x000fe200078e020eULL, 0x00000007470e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000393800720cULL, 0x000fe20003f26070ULL,
0x00005e002f2e7625ULL, 0x000fe200078e003aULL, 0x0000000743387812ULL, 0x000fe400078ec0ffULL,
0x00000007413a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000000f0e0e7812ULL, 0x000fe200078e7803ULL, 0x000000ffff2d7224ULL, 0x000fe200018e062dULL,
0x0000000f38387812ULL, 0x000fc400078e7803ULL, 0x000000394600720cULL, 0x080fe20003f46070ULL,
0x0000001047517824ULL, 0x000fe200078e020eULL, 0x000000394400720cULL, 0x080fe20003f66070ULL,
0x0000001043507824ULL, 0x000fe200078e0238ULL, 0x000000394200720cULL, 0x000fe40003f86070ULL,
0x0000000f3a3a7812ULL, 0x100fe400078e7803ULL, 0x0000000f3c397812ULL, 0x000fe400078e7803ULL,
0x000000452e2e7210ULL, 0x000fe20007fbe0ffULL, 0x00000010414f7824ULL, 0x000fe200078e023aULL,
0x0000e000515f7811ULL, 0x000fe200078e20ffULL, 0x00000010404e7824ULL, 0x000fe200078e0239ULL,
0x0000e000505e7811ULL, 0x000fe200078e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200028e062fULL,
0x0000e0004f5d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000105f7faeULL, 0x0003e2000c901c46ULL, 0x0000e0004e5c7811ULL, 0x000fc600078e20ffULL,
0x00000000125e7faeULL, 0x0003e8000d101c46ULL, 0x000000002c5d7faeULL, 0x0003e8000d901c46ULL,
0x000000002e5c7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff117984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff137984ULL, 0x000ea20000000800ULL, 0x0000ffff610e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff09107812ULL, 0x000fe400078ec0ffULL, 0x000088800e2d7816ULL, 0x000fe400000000ffULL,
0x0000888010597816ULL, 0x000fc600000000ffULL, 0x800000002d0e7824ULL, 0x000fe400078e00ffULL,
0x8000000059107824ULL, 0x000fc600078e00ffULL, 0x8000000011ff7812ULL, 0x002fe4000782480eULL,
0x8000000013ff7812ULL, 0x004fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fe400078e00ffULL,
0x8000000059117824ULL, 0x000fe400078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01060c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000001ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000705b5b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fca00078ec0ffULL,
0x000000015b5b7824ULL, 0x000fca00078e020eULL, 0x010000005b117984ULL, 0x000e680000000800ULL,
0x010200005b0e7984ULL, 0x0004e20000000800ULL, 0x000000061100720bULL, 0x002fda0003f5d000ULL,
0x0000000000107806ULL, 0x000fc800010e0100ULL, 0x0000ffff102e7812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000061100720bULL, 0x00cfe40003f54000ULL,
0x0000001106387209ULL, 0x000fe40007810000ULL, 0x00000002ff127819ULL, 0x000fc60000011603ULL,
0x8000003806107221ULL, 0x000fe20000010000ULL, 0x0000000812137810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400010e0100ULL,
0x000000ff0d00720cULL, 0x000fe40003f45270ULL, 0x0000ffff062f7812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x000000ffff067224ULL, 0x000fe400078e0038ULL,
0x0000002f2eff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff2c7807ULL, 0x000fc60001800000ULL,
0x010400385b00a388ULL, 0x000fe80000000800ULL, 0x00001f1310137589ULL, 0x002e6400000e0000ULL,
0x8000003811113221ULL, 0x000fe20000010000ULL, 0x0000001007077220ULL, 0x000fe20000410000ULL,
0x00001f1210127589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b11113820ULL, 0x000fc80000410000ULL,
0x00000011000c3308ULL, 0x000ee20000000800ULL, 0x000000132b2b7220ULL, 0x082fe20000410000ULL,
0x000000132a2a7220ULL, 0x080fe20000410000ULL, 0x0000001327277220ULL, 0x080fe20000410000ULL,
0x0000001326267220ULL, 0x080fe20000410000ULL, 0x0000001323237220ULL, 0x080fe20000410000ULL,
0x0000001322227220ULL, 0x080fe20000410000ULL, 0x000000131f1f7220ULL, 0x080fe20000410000ULL,
0x000000131e1e7220ULL, 0x080fe20000410000ULL, 0x000000131b1b7220ULL, 0x080fe20000410000ULL,
0x000000131a1a7220ULL, 0x080fe20000410000ULL, 0x0000001317177220ULL, 0x080fe20000410000ULL,
0x0000001316167220ULL, 0x080fe20000410000ULL, 0x0000001337377220ULL, 0x080fe20000410000ULL,
0x0000001336367220ULL, 0x080fe20000410000ULL, 0x0000001333337220ULL, 0x080fe20000410000ULL,
0x0000001332327220ULL, 0x000fe20000410000ULL, 0x0000001229297220ULL, 0x084fe20000410000ULL,
0x0000001228287220ULL, 0x080fe20000410000ULL, 0x0000001225257220ULL, 0x080fe20000410000ULL,
0x0000001224247220ULL, 0x080fe20000410000ULL, 0x0000001221217220ULL, 0x080fe20000410000ULL,
0x0000001220207220ULL, 0x080fe20000410000ULL, 0x000000121d1d7220ULL, 0x080fe20000410000ULL,
0x000000121c1c7220ULL, 0x080fe20000410000ULL, 0x0000001219197220ULL, 0x080fe20000410000ULL,
0x0000001218187220ULL, 0x080fe20000410000ULL, 0x0000001215157220ULL, 0x080fe20000410000ULL,
0x0000001214147220ULL, 0x080fe20000410000ULL, 0x0000001235357220ULL, 0x080fe20000410000ULL,
0x0000001234347220ULL, 0x080fe20000410000ULL, 0x0000001231317220ULL, 0x080fe20000410000ULL,
0x0000001230307220ULL, 0x000fe20000410000ULL, 0x0000000c0e0e3220ULL, 0x008fc80000410000ULL,
0x000000070e077221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff0e7984ULL, 0x000e620000000800ULL, 0x800000002d117824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe20007824811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000002d2d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01064c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000008030e7812ULL, 0x040fe400078ec0ffULL, 0x0000000703107812ULL, 0x040fe400078ec0ffULL,
0x0000000803567211ULL, 0x000fe400078fe0ffULL, 0x000000070e2f7812ULL, 0x100fe400078ec803ULL,
0x00000004ff587819ULL, 0x100fe40000011603ULL, 0x0000000810577812ULL, 0x000fc400078ef803ULL,
0x000000070e3f7812ULL, 0x000fe400078ef803ULL, 0x000000562f567212ULL, 0x000fe400078e3cffULL,
0x0000000758587812ULL, 0x000fe400078e7857ULL, 0x0000000cff2d723eULL, 0x000fe200000000ffULL,
0x000000103f527824ULL, 0x000fe200078e0256ULL, 0x00000002ff3c7819ULL, 0x000fe20000011603ULL,
0x0000000857587824ULL, 0x000fe200078e0258ULL, 0x000054102d3d7816ULL, 0x000fc4000000002dULL,
0x0000c000525a7811ULL, 0x000fe400078e20ffULL, 0x0000a00058107811ULL, 0x000fe200078e20ffULL,
0x00001f3c3d4d7589ULL, 0x000fe200000e0000ULL, 0x000099102c2d7816ULL, 0x000fe400000000ffULL,
0x0000000a032c7211ULL, 0x000fe200078fe0ffULL, 0x000000005a38783bULL, 0x000e620000004200ULL,
0x000000083c0e7810ULL, 0x000fe40007ffe0ffULL, 0x0000002c2f487212ULL, 0x000fe200078e3cffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x000000ff2d00720cULL, 0x000fc40003f25270ULL,
0x000001003f637811ULL, 0x040fe200078e20ffULL, 0x000000103f4c7824ULL, 0x000fe200078e0248ULL,
0x00001f0e3d607589ULL, 0x00072200000e0000ULL, 0x0000000746547812ULL, 0x000fe400078e7857ULL,
0x0000000148487824ULL, 0x100fe200078e0263ULL, 0x0000c0004c557811ULL, 0x000fe200078e20ffULL,
0x0000000156567824ULL, 0x000fe400078e0263ULL, 0x0000000857547824ULL, 0x000fe200078e0254ULL,
0x0000c00048497811ULL, 0x000fe200078e20ffULL, 0x00000000552c783bULL, 0x000f620000004200ULL,
0x0000312038387816ULL, 0x002fc400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x00000038ff3c723eULL, 0x080fe200020006ffULL, 0x0000004d10109232ULL, 0x084fe20000000000ULL,
0x00000039ff3d723eULL, 0x088fe200020006ffULL, 0x0000004d12129232ULL, 0x000fe20000000000ULL,
0x00000038ff38723eULL, 0x000fe200030006ffULL, 0x0000006011119232ULL, 0x090fe20000000000ULL,
0x00000039ff39723eULL, 0x000fe200030006ffULL, 0x0000006013139232ULL, 0x000fe20000000000ULL,
0x000031203a4a7816ULL, 0x000fc400000000ffULL, 0x000031203b4b7816ULL, 0x000fc800000000ffULL,
0x000000381034723cULL, 0x040fe20000001834ULL, 0x000031202c537816ULL, 0x020fe400000000ffULL,
0x000031202d627816ULL, 0x000fe400000000ffULL, 0x00000053ff2c723eULL, 0x000fe400020006ffULL,
0x0000004aff38723eULL, 0x000fe200020006ffULL, 0x0000003c1030723cULL, 0x000fe20000001830ULL,
0x0000004bff39723eULL, 0x000fe400020006ffULL, 0x00000062ff2d723eULL, 0x000fc400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400030006ffULL, 0x0000a000543c7811ULL, 0x000fe200078e20ffULL,
0x000000381014723cULL, 0x040fe20000001814ULL, 0x000000004938783bULL, 0x000e620000004200ULL,
0x0000004bff4b723eULL, 0x000fe400030006ffULL, 0x000031202f637816ULL, 0x000fe200000000ffULL,
0x000000003c3c783bULL, 0x000ea60000000200ULL, 0x0000002c101c723cULL, 0x040fee000000181cULL,
0x00000053ff2c723eULL, 0x000fe200030006ffULL, 0x0000004a1018723cULL, 0x000fe20000001818ULL,
0x00000062ff2d723eULL, 0x000fc400030006ffULL, 0x0000c00056537811ULL, 0x000fe400078e20ffULL,
0x000031202e627816ULL, 0x000fe400000000ffULL, 0x00000063ff4b723eULL, 0x000fe200020006ffULL,
0x0000002c1020723cULL, 0x000fe20000001820ULL, 0x00000000532c783bULL, 0x000ee20000004200ULL,
0x00000062ff4a723eULL, 0x000fce00020006ffULL, 0x0000004a1024723cULL, 0x040fee0000001824ULL,
0x00000062ff4a723eULL, 0x000fe400030006ffULL, 0x00000063ff4b723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000004d3c3c9232ULL, 0x084fe20000000000ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000004d3e3e9232ULL, 0x000fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x0000004a1010723cULL, 0x000fe20000001828ULL,
0x000000603d3d9232ULL, 0x080fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x000000603f3f9232ULL, 0x000fc80000000000ULL, 0x00000038ff28723eULL, 0x000fe400020006ffULL,
0x00000039ff29723eULL, 0x000fce00020006ffULL, 0x000000283c1c723cULL, 0x000fe2000000181cULL,
0x000031202c2c7816ULL, 0x008fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x000031202e2e7816ULL, 0x000fe400000000ffULL, 0x00000038ff28723eULL, 0x000fe400030006ffULL,
0x00000039ff29723eULL, 0x000fe400030006ffULL, 0x000031202f2f7816ULL, 0x000fca00000000ffULL,
0x000000283c20723cULL, 0x000fee0000001820ULL, 0x0000003aff28723eULL, 0x000fe400020006ffULL,
0x0000003bff29723eULL, 0x000fce00020006ffULL, 0x000000283c24723cULL, 0x000fee0000001824ULL,
0x0000002cff28723eULL, 0x000fe400020006ffULL, 0x0000002dff29723eULL, 0x000fce00020006ffULL,
0x000000283c30723cULL, 0x000fee0000001830ULL, 0x0000002cff28723eULL, 0x000fe400030006ffULL,
0x0000002dff29723eULL, 0x000fce00030006ffULL, 0x000000283c34723cULL, 0x000fee0000001834ULL,
0x0000002eff28723eULL, 0x000fe400020006ffULL, 0x0000002fff29723eULL, 0x000fce00020006ffULL,
0x000000283c14723cULL, 0x000fee0000001814ULL, 0x0000002eff28723eULL, 0x000fe400030006ffULL,
0x0000002fff29723eULL, 0x000fce00030006ffULL, 0x000000283c18723cULL, 0x000fee0000001818ULL,
0x0000003aff28723eULL, 0x000fe400030006ffULL, 0x0000003bff29723eULL, 0x000fce00030006ffULL,
0x000000283c3c723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000400f117811ULL, 0x000fe400078e40ffULL,
0x00000004ff2c7819ULL, 0x000fc40000011603ULL, 0x0000001100107217ULL, 0x000fe40007800000ULL,
0x0000c00051517811ULL, 0x000fe400078e20ffULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x0000000110127824ULL, 0x100fe200078e0a11ULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000620004107a24ULL, 0x000fe200078e0211ULL, 0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL,
0x00000100ff117424ULL, 0x000fe200078e00ffULL, 0x0000002012127807ULL, 0x000fe20000000000ULL,
0x00000001472a7824ULL, 0x000fc400078e0210ULL, 0x0000000143287824ULL, 0x100fe200078e0210ULL,
0x0000001205127217ULL, 0x000fe20007800000ULL, 0x0000000141137824ULL, 0x000fe400078e0210ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0011ULL, 0x00000001122d7824ULL, 0x000fe200078e0a05ULL,
0x000000452a2a7210ULL, 0x000fe20007f7e0ffULL, 0x00005e0028287625ULL, 0x000fc600078e0011ULL,
0x0000002d2c00720cULL, 0x000fe20003f46070ULL, 0x00005e0013127625ULL, 0x000fe200078e0011ULL,
0x0000004528287210ULL, 0x000fc60007f9e0ffULL, 0x0000000140107824ULL, 0x000fe200078e0210ULL,
0x0000004512127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x0000002d4600720cULL, 0x000fe20003f66070ULL, 0x00005e0010107625ULL, 0x000fc800078e0011ULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x0000002d4400720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000002d4200720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a517faeULL, 0x0003e2000d101c46ULL,
0x0000004510107210ULL, 0x000fc60007fde0ffULL, 0x0000000028507faeULL, 0x0003e4000d901c46ULL,
0x000000ffff117224ULL, 0x000fc800030e0611ULL, 0x00000000124f7faeULL, 0x0003e8000e101c46ULL,
0x00000000104e7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff117984ULL, 0x002e620000000800ULL, 0x0000ffff61107812ULL, 0x000fc800078ec0ffULL,
0x0000888010127816ULL, 0x000fca00000000ffULL, 0x8000000012107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x01065400ff117984ULL, 0x000e620000000800ULL,
0x8000000012107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe20007844810ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000012117824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x01065400ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000744107812ULL, 0x000fe400078e7857ULL,
0x0000e00052527811ULL, 0x000fe400078e20ffULL, 0x0000000cff2c723eULL, 0x000fe200000000ffULL,
0x00000008574d7824ULL, 0x000fe200078e0210ULL, 0x00000002ff637819ULL, 0x000fe20000011603ULL,
0x000000005228783bULL, 0x000e620000004200ULL, 0x000054102c3a7816ULL, 0x000fe4000000002cULL,
0x0000a0004d107811ULL, 0x000fc400078e20ffULL, 0x0000e0004c4c7811ULL, 0x000fe200078e20ffULL,
0x00001f633a637589ULL, 0x000fe200000e0000ULL, 0x0000e000564a7811ULL, 0x000fe400078e20ffULL,
0x0000e00048487811ULL, 0x000fe200078e20ffULL, 0x000000001010783bULL, 0x000ea80000000200ULL,
0x00001f0e3a607589ULL, 0x000ee800000e0000ULL, 0x000000004c2c783bULL, 0x000f220000004200ULL,
0x0000312028287816ULL, 0x002fc400000000ffULL, 0x0000312029297816ULL, 0x000fe400000000ffULL,
0x00000028ff38723eULL, 0x080fe400020006ffULL, 0x00000029ff39723eULL, 0x080fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe200030006ffULL, 0x0000006310109232ULL, 0x084fe20000000000ULL,
0x00000029ff29723eULL, 0x000fe200030006ffULL, 0x0000006312129232ULL, 0x000fe20000000000ULL,
0x000031202a627816ULL, 0x000fe200000000ffULL, 0x0000006011119232ULL, 0x088fe20000000000ULL,
0x000031202b647816ULL, 0x000fe200000000ffULL, 0x0000006013139232ULL, 0x000fe20000000000ULL,
0x00000062ff56723eULL, 0x000fcc00030006ffULL, 0x000000381030723cULL, 0x040fee0000001830ULL,
0x0000000742387812ULL, 0x000fe200078e7857ULL, 0x000000281034723cULL, 0x000fe80000001834ULL,
0x00000008574b7824ULL, 0x000fe200078e0238ULL, 0x00000064ff57723eULL, 0x000fe200030006ffULL,
0x000000004a38783bULL, 0x000e620000004200ULL, 0x00000062ff28723eULL, 0x000fc400020006ffULL,
0x00000064ff29723eULL, 0x000fe400020006ffULL, 0x0000a0004b2a7811ULL, 0x000fe200078e20ffULL,
0x000000561018723cULL, 0x040fe20000001818ULL, 0x000031202c627816ULL, 0x010fe400000000ffULL,
0x000031202d647816ULL, 0x000fe400000000ffULL, 0x00000062ff2c723eULL, 0x000fe400020006ffULL,
0x00000064ff2d723eULL, 0x000fe200020006ffULL, 0x000000281014723cULL, 0x000fe20000001814ULL,
0x000000002a28783bULL, 0x000ea20000000200ULL, 0x000031202e567816ULL, 0x000fc400000000ffULL,
0x000031202f577816ULL, 0x000fc800000000ffULL, 0x0000002c101c723cULL, 0x000fee000000181cULL,
0x00000062ff2c723eULL, 0x000fe400030006ffULL, 0x00000064ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1020723cULL, 0x000fe20000001820ULL, 0x0000312038627816ULL, 0x002fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x00000062ff38723eULL, 0x000fe400020006ffULL,
0x00000056ff2c723eULL, 0x000fe400020006ffULL, 0x00000057ff2d723eULL, 0x000fe400020006ffULL,
0x000031203b3b7816ULL, 0x000fc400000000ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe200030006ffULL, 0x0000002c1024723cULL, 0x040fe20000001824ULL,
0x00000000482c783bULL, 0x000e620000004200ULL, 0x0000006328289232ULL, 0x084fe40000000000ULL,
0x000000632a2a9232ULL, 0x000fe20000000000ULL, 0x0000312039637816ULL, 0x000fe200000000ffULL,
0x0000006029299232ULL, 0x080fe40000000000ULL, 0x000000602b2b9232ULL, 0x000fe20000000000ULL,
0x00000063ff39723eULL, 0x000fe200020006ffULL, 0x000000561010723cULL, 0x000ff0000000183cULL,
0x000000382830723cULL, 0x000fee0000001830ULL, 0x00000062ff38723eULL, 0x000fc400030006ffULL,
0x00000063ff39723eULL, 0x000fce00030006ffULL, 0x000000382834723cULL, 0x000fee0000001834ULL,
0x0000003aff38723eULL, 0x000fe400020006ffULL, 0x0000003bff39723eULL, 0x000fe400020006ffULL,
0x000031202e2e7816ULL, 0x002fc400000000ffULL, 0x000031202f2f7816ULL, 0x000fc600000000ffULL,
0x000000382814723cULL, 0x000fee0000001814ULL, 0x0000003aff38723eULL, 0x000fe400030006ffULL,
0x0000003bff39723eULL, 0x000fe400030006ffULL, 0x000031202c3a7816ULL, 0x000fc400000000ffULL,
0x000031202d3b7816ULL, 0x000fe400000000ffULL, 0x0000003aff2c723eULL, 0x000fe200020006ffULL,
0x000000382818723cULL, 0x000fe20000001818ULL, 0x0000003bff2d723eULL, 0x000fce00020006ffULL,
0x0000002c281c723cULL, 0x000fee000000181cULL, 0x0000003aff2c723eULL, 0x000fe400030006ffULL,
0x0000003bff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2820723cULL, 0x000fee0000001820ULL,
0x0000002eff2c723eULL, 0x000fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2824723cULL, 0x000fee0000001824ULL, 0x0000002eff2c723eULL, 0x000fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000400f117811ULL, 0x000fe200078e40ffULL, 0x01061000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff61ff7812ULL, 0x000fe4000782c0ffULL, 0x000000110000720cULL, 0x000fe40003f44070ULL,
0x00000001ff617807ULL, 0x000fd60000800000ULL, 0x00004ff00000a947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000600f117811ULL, 0x000fe200078e40ffULL, 0x00000100ff3c7424ULL, 0x000fe200078e00ffULL,
0x00000004ff3a7819ULL, 0x000fe40000011603ULL, 0x0000001100107217ULL, 0x000fe20007800000ULL,
0x0000620004127a24ULL, 0x000fc800078e0211ULL, 0x0000000110107824ULL, 0x000fe400078e0a11ULL,
0x0000000147117824ULL, 0x100fe400078e0212ULL, 0x00000001432d7824ULL, 0x000fe200078e0212ULL,
0x00000020102c7807ULL, 0x000fe20000000000ULL, 0x00005e0011107625ULL, 0x000fc600078e003cULL,
0x0000002c05387217ULL, 0x000fe20007800000ULL, 0x00005e002d2c7625ULL, 0x000fe200078e003cULL,
0x00000045102e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000138397824ULL, 0x000fe200078e0a05ULL,
0x000000452c2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000141137824ULL, 0x100fe400078e0212ULL,
0x0000000140107824ULL, 0x000fe200078e0212ULL, 0x000000393a00720cULL, 0x080fe20003f46070ULL,
0x000000ffff2f7224ULL, 0x000fe200008e0611ULL, 0x000000394600720cULL, 0x080fe20003f26070ULL,
0x00005e0013127625ULL, 0x000fe200078e003cULL, 0x000000394200720cULL, 0x000fc60003f86070ULL,
0x00005e0010107625ULL, 0x000fe200078e003cULL, 0x0000004512127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x000000394400720cULL, 0x000fe20003f66070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000004510107210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e5f7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000002c5e7faeULL, 0x0003ea000c901c46ULL,
0x00000000125d7faeULL, 0x0003e8000d901c46ULL, 0x00000000105c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff117984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01061c00ff127984ULL, 0x000ea20000000800ULL,
0x000000ff0bff7812ULL, 0x000fe2000782c0ffULL, 0x8000000059137824ULL, 0x000fc600078e00ffULL,
0x00000001ff607807ULL, 0x000fca0000800000ULL, 0x8000000060107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe40007824810ULL, 0x8000000012ff7812ULL, 0x004fe20007844813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000059127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01061c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x010080005b117984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x010280005b107984ULL, 0x0004e20000000800ULL,
0x000000061100720bULL, 0x002fda0003f5d000ULL, 0x0000000000127806ULL, 0x000fc800010e0100ULL,
0x0000ffff122c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000061100720bULL, 0x00cfe40003f54000ULL, 0x0000001106127209ULL, 0x000fe40007810000ULL,
0x00000002ff2e7819ULL, 0x000fc60000011603ULL, 0x8000001206137221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b13137820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400010e0100ULL,
0x000000010d00780cULL, 0x000fe40003f45270ULL, 0x0000ffff062d7812ULL, 0x000fe200078e3cffULL,
0x0000001300137308ULL, 0x000e660000000800ULL, 0x0000002d2cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff387807ULL, 0x000fc60001800000ULL, 0x010480125b00a388ULL, 0x000fe80000000800ULL,
0x00001f2e13067589ULL, 0x002e6400000e0000ULL, 0x80000012112c3221ULL, 0x000fe20000010000ULL,
0x0000001307077220ULL, 0x000fe20000410000ULL, 0x00001f0e13117589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL, 0x0000002c000c3308ULL, 0x000ee20000000800ULL,
0x0000000630307220ULL, 0x082fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000614147220ULL, 0x080fe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x000fe20000410000ULL,
0x0000001132327220ULL, 0x084fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe200078e0012ULL, 0x000000100c103220ULL, 0x008fc80000410000ULL,
0x0000000710077221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff107984ULL, 0x000e620000000800ULL, 0x8000000060117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007824811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000060127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01064c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000a800582c7811ULL, 0x000fe200078e20ffULL, 0x000000005a10783bULL, 0x000e620000004200ULL,
0x0000000cff39723eULL, 0x000fe400000000ffULL, 0x00000002ff617819ULL, 0x000fe20000011603ULL,
0x00000000553c783bULL, 0x000fe20000004200ULL, 0x00005410393a7816ULL, 0x000fe40000000039ULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x000000002c2c783bULL, 0x000fe60000000200ULL,
0x000000ff3800720cULL, 0x000fe20003f25270ULL, 0x00001f613a617589ULL, 0x000ea800000e0000ULL,
0x00001f0e3a627589ULL, 0x000ee200000e0000ULL, 0x0000312010107816ULL, 0x002fc400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x080fe400020006ffULL,
0x00000011ff39723eULL, 0x080fe200020006ffULL, 0x000000612c2c9232ULL, 0x084fe20000000000ULL,
0x00000010ff10723eULL, 0x000fe200030006ffULL, 0x000000612e2e9232ULL, 0x000fe20000000000ULL,
0x00000011ff11723eULL, 0x000fe200030006ffULL, 0x000000622d2d9232ULL, 0x088fe20000000000ULL,
0x0000312012567816ULL, 0x000fe200000000ffULL, 0x000000622f2f9232ULL, 0x000fe20000000000ULL,
0x0000312013577816ULL, 0x000fc400000000ffULL, 0x0000a80054127811ULL, 0x000fe400078e20ffULL,
0x000031203c637816ULL, 0x000fe400000000ffULL, 0x000000102c34723cULL, 0x040fe20000001834ULL,
0x000031203d647816ULL, 0x000fe400000000ffULL, 0x00000063ff3c723eULL, 0x000fe400020006ffULL,
0x00000064ff3d723eULL, 0x000fe400020006ffULL, 0x00000056ff10723eULL, 0x080fe200020006ffULL,
0x000000382c30723cULL, 0x000fe20000001830ULL, 0x00000057ff11723eULL, 0x000fe200020006ffULL,
0x000000005338783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fc400030006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x000000102c14723cULL, 0x040fe20000001814ULL,
0x000000001210783bULL, 0x000eae0000000200ULL, 0x0000003c2c1c723cULL, 0x040fee000000181cULL,
0x00000063ff3c723eULL, 0x000fe200030006ffULL, 0x000000562c18723cULL, 0x000fe20000001818ULL,
0x00000064ff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e567816ULL, 0x000fe200000000ffULL,
0x0000003c2c20723cULL, 0x000fe20000001820ULL, 0x000031203f577816ULL, 0x000fcc00000000ffULL,
0x00000056ff3c723eULL, 0x080fe400020006ffULL, 0x00000057ff3d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c2c24723cULL, 0x040fe20000001824ULL,
0x00000000493c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000006110109232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x0000006112129232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000006211119232ULL, 0x080fe20000000000ULL, 0x000000562c28723cULL, 0x000fe20000001828ULL,
0x0000006213139232ULL, 0x000fcc0000000000ULL, 0x00000038ff2c723eULL, 0x000fe400020006ffULL,
0x00000039ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c1030723cULL, 0x000fee0000001830ULL,
0x00000038ff2c723eULL, 0x000fe400030006ffULL, 0x00000039ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1034723cULL, 0x000fe20000001834ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003aff2c723eULL, 0x000fe400020006ffULL, 0x0000003bff2d723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fca00000000ffULL, 0x0000002c1014723cULL, 0x000fee0000001814ULL,
0x0000003aff2c723eULL, 0x000fe400030006ffULL, 0x0000003bff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1018723cULL, 0x000fee0000001818ULL, 0x0000003cff2c723eULL, 0x000fe400020006ffULL,
0x0000003dff2d723eULL, 0x000fce00020006ffULL, 0x0000002c101c723cULL, 0x000fee000000181cULL,
0x0000003cff2c723eULL, 0x000fe400030006ffULL, 0x0000003dff2d723eULL, 0x000fce00030006ffULL,
0x0000002c1020723cULL, 0x000fee0000001820ULL, 0x0000003eff2c723eULL, 0x000fe400020006ffULL,
0x0000003fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c1024723cULL, 0x000fee0000001824ULL,
0x0000003eff2c723eULL, 0x000fe400030006ffULL, 0x0000003fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c102c723cULL, 0x000fe20000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000800f117811ULL, 0x000fe200078e40ffULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff3a7819ULL, 0x000fc40000011603ULL,
0x0000001100107217ULL, 0x000fe20007800000ULL, 0x0000620004387a24ULL, 0x000fc800078e0211ULL,
0x0000000110107824ULL, 0x000fe400078e0a11ULL, 0x0000000147117824ULL, 0x100fe400078e0238ULL,
0x0000000143287824ULL, 0x100fe200078e0238ULL, 0x0000002010127807ULL, 0x000fe20000000000ULL,
0x0000000141137824ULL, 0x000fe400078e0238ULL, 0x00005e0011107625ULL, 0x000fe200078e003bULL,
0x0000001205127217ULL, 0x000fc60007800000ULL, 0x00005e0028287625ULL, 0x000fe200078e003bULL,
0x00000045102a7210ULL, 0x000fc60007f5e0ffULL, 0x0000000112397824ULL, 0x000fe200078e0a05ULL,
0x0000004528287210ULL, 0x000fe20007f9e0ffULL, 0x00005e0013127625ULL, 0x000fc600078e003bULL,
0x000000394600720cULL, 0x000fe20003f66070ULL, 0x0000000140107824ULL, 0x000fe200078e0238ULL,
0x0000004512127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e0611ULL,
0x000000393a00720cULL, 0x000fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fc800078e003bULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x000000394400720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x000000394200720cULL, 0x000fe40003fa6070ULL,
0x0000004510107210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a517faeULL, 0x0003e4000d101c46ULL, 0x000000ffff117224ULL, 0x000fe400030e0611ULL,
0x0000000028507faeULL, 0x0003e8000d901c46ULL, 0x00000000124f7faeULL, 0x0003e8000e101c46ULL,
0x00000000104e7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff107984ULL, 0x002e620000000800ULL, 0x8000000060117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007844811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000060127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000a8004d107811ULL, 0x000fe200078e20ffULL, 0x000000005228783bULL, 0x000e620000004200ULL,
0x0000000cff38723eULL, 0x000fe400000000ffULL, 0x00000002ff617819ULL, 0x000fe20000011603ULL,
0x000000004c3c783bULL, 0x000fe20000004200ULL, 0x00005410383a7816ULL, 0x000fc60000000038ULL,
0x000000001010783bULL, 0x000fe80000000200ULL, 0x00001f613a617589ULL, 0x000ea800000e0000ULL,
0x00001f0e3a627589ULL, 0x000ee200000e0000ULL, 0x0000312028287816ULL, 0x002fe400000000ffULL,
0x0000312029297816ULL, 0x000fc400000000ffULL, 0x00000028ff38723eULL, 0x080fe400020006ffULL,
0x00000029ff39723eULL, 0x080fe200020006ffULL, 0x0000006110109232ULL, 0x084fe20000000000ULL,
0x00000028ff28723eULL, 0x000fe200030006ffULL, 0x0000006112129232ULL, 0x000fe20000000000ULL,
0x00000029ff29723eULL, 0x000fe200030006ffULL, 0x0000006211119232ULL, 0x088fe20000000000ULL,
0x000031202a567816ULL, 0x000fe200000000ffULL, 0x0000006213139232ULL, 0x000fe20000000000ULL,
0x000031202b577816ULL, 0x000fc400000000ffULL, 0x0000a8004b2a7811ULL, 0x000fe400078e20ffULL,
0x000031203c637816ULL, 0x000fe400000000ffULL, 0x000000281034723cULL, 0x040fe20000001834ULL,
0x000031203d647816ULL, 0x000fe400000000ffULL, 0x00000063ff3c723eULL, 0x000fe400020006ffULL,
0x00000064ff3d723eULL, 0x000fe400020006ffULL, 0x00000056ff28723eULL, 0x080fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000057ff29723eULL, 0x000fe200020006ffULL,
0x000000004a38783bULL, 0x000e620000004200ULL, 0x00000056ff56723eULL, 0x000fc400030006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x000000281014723cULL, 0x040fe20000001814ULL,
0x000000002a28783bULL, 0x000eae0000000200ULL, 0x0000003c101c723cULL, 0x040fee000000181cULL,
0x00000063ff3c723eULL, 0x000fe200030006ffULL, 0x000000561018723cULL, 0x000fe20000001818ULL,
0x00000064ff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e567816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x000031203f577816ULL, 0x000fcc00000000ffULL,
0x00000056ff3c723eULL, 0x080fe400020006ffULL, 0x00000057ff3d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c1024723cULL, 0x040fe20000001824ULL,
0x00000000483c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000006128289232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x000000612a2a9232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000006229299232ULL, 0x080fe20000000000ULL, 0x00000056102c723cULL, 0x000fe2000000182cULL,
0x000000622b2b9232ULL, 0x000fcc0000000000ULL, 0x00000038ff10723eULL, 0x000fe400020006ffULL,
0x00000039ff11723eULL, 0x000fce00020006ffULL, 0x000000102830723cULL, 0x000fee0000001830ULL,
0x00000038ff10723eULL, 0x000fe400030006ffULL, 0x00000039ff11723eULL, 0x000fce00030006ffULL,
0x000000102834723cULL, 0x000fe20000001834ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003aff10723eULL, 0x000fe400020006ffULL, 0x0000003bff11723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fca00000000ffULL, 0x000000102814723cULL, 0x000fee0000001814ULL,
0x0000003aff10723eULL, 0x000fe400030006ffULL, 0x0000003bff11723eULL, 0x000fce00030006ffULL,
0x000000102818723cULL, 0x000fee0000001818ULL, 0x0000003cff10723eULL, 0x000fe400020006ffULL,
0x0000003dff11723eULL, 0x000fce00020006ffULL, 0x00000010281c723cULL, 0x000fee000000181cULL,
0x0000003cff10723eULL, 0x000fe400030006ffULL, 0x0000003dff11723eULL, 0x000fce00030006ffULL,
0x000000102820723cULL, 0x000fee0000001820ULL, 0x0000003eff10723eULL, 0x000fe400020006ffULL,
0x0000003fff11723eULL, 0x000fce00020006ffULL, 0x000000102824723cULL, 0x000fee0000001824ULL,
0x0000003eff10723eULL, 0x000fe400030006ffULL, 0x0000003fff11723eULL, 0x000fce00030006ffULL,
0x000000102828723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000800f117811ULL, 0x000fe200078e40ffULL,
0x01062000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0bff7812ULL, 0x000fe4000784c0ffULL,
0x000000110000720cULL, 0x000fe40003f24070ULL, 0x00000001ff617807ULL, 0x000fd60005000000ULL,
0x0000354000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000a00f117811ULL, 0x000fe200078e40ffULL,
0x00000100ff3c7424ULL, 0x000fe200078e00ffULL, 0x00000004ff3a7819ULL, 0x000fe40000011603ULL,
0x0000001100107217ULL, 0x000fe20007800000ULL, 0x0000620004127a24ULL, 0x000fc800078e0211ULL,
0x0000000110107824ULL, 0x000fe400078e0a11ULL, 0x0000000147117824ULL, 0x100fe400078e0212ULL,
0x00000001432d7824ULL, 0x000fe200078e0212ULL, 0x00000020102c7807ULL, 0x000fe20000000000ULL,
0x00005e0011107625ULL, 0x000fc600078e003cULL, 0x0000002c05387217ULL, 0x000fe20007800000ULL,
0x00005e002d2c7625ULL, 0x000fe200078e003cULL, 0x00000045102e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000138397824ULL, 0x000fe200078e0a05ULL, 0x000000452c2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000141137824ULL, 0x100fe400078e0212ULL, 0x0000000140107824ULL, 0x000fe200078e0212ULL,
0x000000393a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff2f7224ULL, 0x000fe200008e0611ULL,
0x000000394600720cULL, 0x080fe20003f26070ULL, 0x00005e0013127625ULL, 0x000fe200078e003cULL,
0x000000394200720cULL, 0x000fc60003f86070ULL, 0x00005e0010107625ULL, 0x000fe200078e003cULL,
0x0000004512127210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e062dULL,
0x000000394400720cULL, 0x000fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x0000004510107210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e5f7faeULL, 0x0003e8000d101c46ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x000000002c5e7faeULL, 0x0003ea000c901c46ULL, 0x00000000125d7faeULL, 0x0003e8000d901c46ULL,
0x00000000105c7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff117984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01062c00ff127984ULL, 0x000ea20000000800ULL, 0x000000ff0bff7812ULL, 0x000fe2000782c0ffULL,
0x8000000059137824ULL, 0x000fc600078e00ffULL, 0x00000001ff617807ULL, 0x000fca0004800000ULL,
0x8000000061107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe40007824810ULL,
0x8000000012ff7812ULL, 0x004fe20007844813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000059127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01062c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x010100005b117984ULL, 0x000e620000000800ULL, 0x00000001ff387424ULL, 0x000fc600078e00ffULL,
0x010300005b107984ULL, 0x0004e20000000800ULL, 0x000000061100720bULL, 0x002fda0003f5d000ULL,
0x0000000000127806ULL, 0x000fc800010e0100ULL, 0x0000ffff122c7812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000061100720bULL, 0x00cfe40003f54000ULL,
0x0000001106127209ULL, 0x000fe40007810000ULL, 0x00000002ff2e7819ULL, 0x000fc60000011603ULL,
0x8000001206137221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b13137820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x000000020d00780cULL, 0x000fe40003f45270ULL,
0x0000ffff062d7812ULL, 0x000fe200078e3cffULL, 0x0000001300137308ULL, 0x000e660000000800ULL,
0x0000002d2cff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff387807ULL, 0x000fc60001800000ULL,
0x010500125b00a388ULL, 0x000fe80000000800ULL, 0x00001f2e13067589ULL, 0x002e6400000e0000ULL,
0x80000012112c3221ULL, 0x000fe20000010000ULL, 0x0000001307077220ULL, 0x000fe20000410000ULL,
0x00001f0e13117589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL,
0x0000002c000c3308ULL, 0x000ee20000000800ULL, 0x0000000630307220ULL, 0x082fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000614147220ULL, 0x080fe20000410000ULL,
0x0000000615157220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000628287220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x000fe20000410000ULL, 0x0000001132327220ULL, 0x084fe20000410000ULL,
0x0000001133337220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fe200078e0012ULL,
0x000000100c103220ULL, 0x008fc80000410000ULL, 0x0000000710077221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff107984ULL, 0x000e620000000800ULL,
0x8000000061117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007824811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000061127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01064c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000b00058107811ULL, 0x000fe200078e20ffULL,
0x000000005a2c783bULL, 0x000e620000004200ULL, 0x0000000cff39723eULL, 0x000fe400000000ffULL,
0x00000002ff637819ULL, 0x000fe20000011603ULL, 0x00000000553c783bULL, 0x000fe20000004200ULL,
0x00005410393a7816ULL, 0x000fe40000000039ULL, 0x0000991038387816ULL, 0x000fe200000000ffULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000b00054667811ULL, 0x000fc400078e20ffULL,
0x000000ff3800720cULL, 0x000fe20003f25270ULL, 0x00001f633a637589ULL, 0x000ea800000e0000ULL,
0x00001f0e3a627589ULL, 0x000ee200000e0000ULL, 0x000031202c2c7816ULL, 0x002fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x0000002cff38723eULL, 0x000fc400020006ffULL,
0x0000002dff39723eULL, 0x080fe200020006ffULL, 0x0000006310109232ULL, 0x084fe20000000000ULL,
0x0000002cff2c723eULL, 0x000fe200030006ffULL, 0x0000006312129232ULL, 0x000fe20000000000ULL,
0x0000002dff2d723eULL, 0x000fe200030006ffULL, 0x0000006211119232ULL, 0x088fe20000000000ULL,
0x000031202e567816ULL, 0x000fe200000000ffULL, 0x0000006213139232ULL, 0x000fe20000000000ULL,
0x000031202f577816ULL, 0x000fe400000000ffULL, 0x000031203c647816ULL, 0x000fc400000000ffULL,
0x000031203d657816ULL, 0x000fe400000000ffULL, 0x0000002c1034723cULL, 0x000fe20000001834ULL,
0x00000064ff3c723eULL, 0x000fe400020006ffULL, 0x00000065ff3d723eULL, 0x000fc800020006ffULL,
0x00000056ff2c723eULL, 0x080fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000057ff2d723eULL, 0x080fe200020006ffULL, 0x000000005338783bULL, 0x000e620000004200ULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fc600030006ffULL,
0x0000002c102c723cULL, 0x040fe20000001814ULL, 0x000000006614783bULL, 0x000eae0000000200ULL,
0x0000003c101c723cULL, 0x040fee000000181cULL, 0x00000064ff3c723eULL, 0x000fe200030006ffULL,
0x000000561018723cULL, 0x000fe20000001818ULL, 0x00000065ff3d723eULL, 0x000fcc00030006ffULL,
0x000031203e567816ULL, 0x000fe200000000ffULL, 0x0000003c1020723cULL, 0x000fe20000001820ULL,
0x000031203f577816ULL, 0x000fcc00000000ffULL, 0x00000056ff3c723eULL, 0x080fe400020006ffULL,
0x00000057ff3d723eULL, 0x080fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe200000000ffULL,
0x0000003c1024723cULL, 0x040fe20000001824ULL, 0x00000000493c783bULL, 0x000e620000004200ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000006314149232ULL, 0x084fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x0000006316169232ULL, 0x000fe20000000000ULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x0000006215159232ULL, 0x080fe20000000000ULL,
0x000000561010723cULL, 0x000fe20000001828ULL, 0x0000006217179232ULL, 0x000fcc0000000000ULL,
0x00000038ff28723eULL, 0x000fe400020006ffULL, 0x00000039ff29723eULL, 0x000fce00020006ffULL,
0x000000281430723cULL, 0x000fee0000001830ULL, 0x00000038ff28723eULL, 0x000fe400030006ffULL,
0x00000039ff29723eULL, 0x000fce00030006ffULL, 0x000000281434723cULL, 0x000fe20000001834ULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000003aff28723eULL, 0x000fe400020006ffULL,
0x0000003bff29723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fca00000000ffULL,
0x00000028142c723cULL, 0x000fee000000182cULL, 0x0000003aff28723eULL, 0x000fe400030006ffULL,
0x0000003bff29723eULL, 0x000fce00030006ffULL, 0x000000281418723cULL, 0x000fee0000001818ULL,
0x0000003cff28723eULL, 0x000fe400020006ffULL, 0x0000003dff29723eULL, 0x000fce00020006ffULL,
0x00000028141c723cULL, 0x000fee000000181cULL, 0x0000003cff28723eULL, 0x000fe400030006ffULL,
0x0000003dff29723eULL, 0x000fce00030006ffULL, 0x000000281420723cULL, 0x000fee0000001820ULL,
0x0000003eff28723eULL, 0x000fe400020006ffULL, 0x0000003fff29723eULL, 0x000fce00020006ffULL,
0x000000281424723cULL, 0x000fee0000001824ULL, 0x0000003eff28723eULL, 0x000fe400030006ffULL,
0x0000003fff29723eULL, 0x000fce00030006ffULL, 0x000000281414723cULL, 0x000fe20000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000c00f117811ULL, 0x000fe200078e40ffULL, 0x00000100ff3b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff3a7819ULL, 0x000fc40000011603ULL, 0x0000001100107217ULL, 0x000fe20007800000ULL,
0x0000620004387a24ULL, 0x000fc800078e0211ULL, 0x0000000110107824ULL, 0x000fe400078e0a11ULL,
0x0000000147117824ULL, 0x100fe400078e0238ULL, 0x0000000143287824ULL, 0x100fe200078e0238ULL,
0x0000002010127807ULL, 0x000fe20000000000ULL, 0x0000000141137824ULL, 0x000fe400078e0238ULL,
0x00005e0011107625ULL, 0x000fe200078e003bULL, 0x0000001205127217ULL, 0x000fc60007800000ULL,
0x00005e0028287625ULL, 0x000fe200078e003bULL, 0x00000045102a7210ULL, 0x000fc60007f5e0ffULL,
0x0000000112397824ULL, 0x000fe200078e0a05ULL, 0x0000004528287210ULL, 0x000fe20007f9e0ffULL,
0x00005e0013127625ULL, 0x000fc600078e003bULL, 0x000000394600720cULL, 0x000fe20003f66070ULL,
0x0000000140107824ULL, 0x000fe200078e0238ULL, 0x0000004512127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e0611ULL, 0x000000393a00720cULL, 0x000fe20003f46070ULL,
0x00005e0010107625ULL, 0x000fc800078e003bULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x000000394400720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000394200720cULL, 0x000fe40003fa6070ULL, 0x0000004510107210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a517faeULL, 0x0003e4000d101c46ULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x0000000028507faeULL, 0x0003e8000d901c46ULL,
0x00000000124f7faeULL, 0x0003e8000e101c46ULL, 0x00000000104e7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff107984ULL, 0x002e620000000800ULL,
0x8000000061117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007844811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000061127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000b0004d107811ULL, 0x000fe200078e20ffULL,
0x000000005228783bULL, 0x000e620000004200ULL, 0x0000000cff38723eULL, 0x000fe400000000ffULL,
0x00000002ff617819ULL, 0x000fe20000011603ULL, 0x000000004c3c783bULL, 0x000fe20000004200ULL,
0x00005410383a7816ULL, 0x000fc60000000038ULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x00001f613a617589ULL, 0x000ea800000e0000ULL, 0x00001f0e3a627589ULL, 0x000ee200000e0000ULL,
0x0000312028287816ULL, 0x002fe400000000ffULL, 0x0000312029297816ULL, 0x000fc400000000ffULL,
0x00000028ff38723eULL, 0x080fe400020006ffULL, 0x00000029ff39723eULL, 0x080fe200020006ffULL,
0x0000006110109232ULL, 0x084fe20000000000ULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000006112129232ULL, 0x000fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000006211119232ULL, 0x088fe20000000000ULL, 0x000031202a567816ULL, 0x000fe200000000ffULL,
0x0000006213139232ULL, 0x000fe20000000000ULL, 0x000031202b577816ULL, 0x000fc400000000ffULL,
0x0000b0004b2a7811ULL, 0x000fe400078e20ffULL, 0x000031203c637816ULL, 0x000fe400000000ffULL,
0x000000281034723cULL, 0x040fe20000001834ULL, 0x000031203d647816ULL, 0x000fe400000000ffULL,
0x00000063ff3c723eULL, 0x000fe400020006ffULL, 0x00000064ff3d723eULL, 0x000fe400020006ffULL,
0x00000056ff28723eULL, 0x080fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000057ff29723eULL, 0x000fe200020006ffULL, 0x000000004a38783bULL, 0x000e620000004200ULL,
0x00000056ff56723eULL, 0x000fc400030006ffULL, 0x00000057ff57723eULL, 0x000fc600030006ffULL,
0x00000028102c723cULL, 0x040fe2000000182cULL, 0x000000002a28783bULL, 0x000eae0000000200ULL,
0x0000003c101c723cULL, 0x040fee000000181cULL, 0x00000063ff3c723eULL, 0x000fe200030006ffULL,
0x000000561018723cULL, 0x000fe20000001818ULL, 0x00000064ff3d723eULL, 0x000fcc00030006ffULL,
0x000031203e567816ULL, 0x000fe200000000ffULL, 0x0000003c1020723cULL, 0x000fe20000001820ULL,
0x000031203f577816ULL, 0x000fcc00000000ffULL, 0x00000056ff3c723eULL, 0x080fe400020006ffULL,
0x00000057ff3d723eULL, 0x080fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400030006ffULL,
0x00000057ff57723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe200000000ffULL,
0x0000003c1024723cULL, 0x040fe20000001824ULL, 0x00000000483c783bULL, 0x000e620000004200ULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000006128289232ULL, 0x084fe20000000000ULL,
0x000031203a3a7816ULL, 0x000fe200000000ffULL, 0x000000612a2a9232ULL, 0x000fe20000000000ULL,
0x000031203b3b7816ULL, 0x000fe200000000ffULL, 0x0000006229299232ULL, 0x080fe20000000000ULL,
0x000000561010723cULL, 0x000fe20000001814ULL, 0x000000622b2b9232ULL, 0x000fcc0000000000ULL,
0x00000038ff14723eULL, 0x000fe400020006ffULL, 0x00000039ff15723eULL, 0x000fce00020006ffULL,
0x000000142830723cULL, 0x000fee0000001830ULL, 0x00000038ff14723eULL, 0x000fe400030006ffULL,
0x00000039ff15723eULL, 0x000fce00030006ffULL, 0x000000142834723cULL, 0x000fe20000001834ULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000003aff14723eULL, 0x000fe400020006ffULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fca00000000ffULL,
0x000000142814723cULL, 0x000fee000000182cULL, 0x0000003aff2c723eULL, 0x000fe400030006ffULL,
0x0000003bff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2818723cULL, 0x000fee0000001818ULL,
0x0000003cff2c723eULL, 0x000fe400020006ffULL, 0x0000003dff2d723eULL, 0x000fce00020006ffULL,
0x0000002c281c723cULL, 0x000fee000000181cULL, 0x0000003cff2c723eULL, 0x000fe400030006ffULL,
0x0000003dff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2820723cULL, 0x000fee0000001820ULL,
0x0000003eff2c723eULL, 0x000fe400020006ffULL, 0x0000003fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2824723cULL, 0x000fee0000001824ULL, 0x0000003eff2c723eULL, 0x000fe400030006ffULL,
0x0000003fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c00f117811ULL, 0x000fe200078e40ffULL, 0x01063000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0bff7812ULL, 0x000fe4000784c0ffULL, 0x000000110000720cULL, 0x000fe40003f24070ULL,
0x00000001ff617807ULL, 0x000fd60001000000ULL, 0x00001a9000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000e00f117811ULL, 0x000fe200078e40ffULL, 0x00000100ff3a7424ULL, 0x000fe200078e00ffULL,
0x00000004ff387819ULL, 0x000fe40000011603ULL, 0x0000001100107217ULL, 0x000fe20007800000ULL,
0x0000620004127a24ULL, 0x000fc800078e0211ULL, 0x0000000110107824ULL, 0x000fe400078e0a11ULL,
0x0000000147117824ULL, 0x100fe400078e0212ULL, 0x00000001432d7824ULL, 0x000fe200078e0212ULL,
0x00000020102c7807ULL, 0x000fe20000000000ULL, 0x00005e0011107625ULL, 0x000fc600078e003aULL,
0x0000002c052c7217ULL, 0x000fe20007800000ULL, 0x0000000141137824ULL, 0x100fe200078e0212ULL,
0x00000045102e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000140107824ULL, 0x000fe400078e0212ULL,
0x000000012c397824ULL, 0x000fe400078e0a05ULL, 0x000000ffff2f7224ULL, 0x000fe400000e0611ULL,
0x00005e002d2c7625ULL, 0x000fe200078e003aULL, 0x000000393800720cULL, 0x000fc40003f06070ULL,
0x000000394600720cULL, 0x080fe20003f26070ULL, 0x00005e0013127625ULL, 0x080fe200078e003aULL,
0x000000394400720cULL, 0x080fe40003f46070ULL, 0x000000394200720cULL, 0x000fe20003f66070ULL,
0x00005e0010107625ULL, 0x000fe200078e003aULL, 0x000000452c2c7210ULL, 0x080fe40007f9e0ffULL,
0x0000004512127210ULL, 0x080fe40007fbe0ffULL, 0x0000004510107210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2d7224ULL, 0x000fe200020e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e5f7faeULL, 0x0003e2000c101c46ULL, 0x000000ffff137224ULL, 0x000fc400028e0613ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000002c5e7faeULL, 0x0003e8000c901c46ULL,
0x00000000125d7faeULL, 0x0003e8000d101c46ULL, 0x00000000105c7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff107984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01063c00ff117984ULL, 0x000ea20000000800ULL,
0x8000000060137824ULL, 0x000fc400078e00ffULL, 0x8000000059127824ULL, 0x000fc600078e00ffULL,
0x8000000010ff7812ULL, 0x002fe40007804813ULL, 0x8000000011ff7812ULL, 0x004fe20007824812ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000059127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01063c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x010180005b117984ULL, 0x000e620000000800ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x010380005b107984ULL, 0x0004e20000000800ULL,
0x000000061100720bULL, 0x002fda0003f3d000ULL, 0x0000000000127806ULL, 0x000fc800008e0100ULL,
0x0000ffff12137812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000061100720bULL, 0x00cfe40003f34000ULL, 0x00000011062e7209ULL, 0x000fe40007810000ULL,
0x00000002ff2d7819ULL, 0x000fc60000011603ULL, 0x8000002e06127221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x000000030d00780cULL, 0x000fe40003f25270ULL, 0x0000ffff062c7812ULL, 0x000fe200078e3cffULL,
0x0000001200127308ULL, 0x000e660000000800ULL, 0x0000002c13ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff387807ULL, 0x000fc60001000000ULL, 0x0105802e5b009388ULL, 0x000fe80000000800ULL,
0x00001f2d12067589ULL, 0x002e6400000e0000ULL, 0x8000002e11132221ULL, 0x000fe20000010000ULL,
0x0000001207077220ULL, 0x000fe20000410000ULL, 0x00001f0e12117589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b13132820ULL, 0x000fc80000410000ULL, 0x00000013000c2308ULL, 0x000ee20000000800ULL,
0x0000000630307220ULL, 0x082fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000614147220ULL, 0x080fe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x000fe20000410000ULL,
0x0000001132327220ULL, 0x084fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe200078e002eULL, 0x000000100c102220ULL, 0x008fc80000410000ULL,
0x0000000710077221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x01064c00ff107984ULL, 0x000e620000000800ULL, 0x8000000060117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007804811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000060127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01064c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000b80058107811ULL, 0x000fe200078e20ffULL, 0x000000005a2c783bULL, 0x0002a20000004200ULL,
0x0000000cff39723eULL, 0x000fe400000000ffULL, 0x00000002ff577819ULL, 0x000fe20000011603ULL,
0x00000000553c783bULL, 0x000fe20000004200ULL, 0x00005410393a7816ULL, 0x000fe40000000039ULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x000000001010783bULL, 0x000fe20000000200ULL,
0x0000b800545a7811ULL, 0x002fc400078e20ffULL, 0x000000ff3800720cULL, 0x000fe20003f05270ULL,
0x00001f573a577589ULL, 0x000e6800000e0000ULL, 0x00001f0e3a567589ULL, 0x000ee200000e0000ULL,
0x000031202c2c7816ULL, 0x004fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fe400000000ffULL,
0x0000002cff38723eULL, 0x000fc400020006ffULL, 0x0000002dff39723eULL, 0x080fe200020006ffULL,
0x0000005710108232ULL, 0x082fe20000000000ULL, 0x0000002cff2c723eULL, 0x000fe200030006ffULL,
0x0000005712128232ULL, 0x000fe20000000000ULL, 0x0000002dff2d723eULL, 0x000fe200030006ffULL,
0x0000005611118232ULL, 0x088fe20000000000ULL, 0x000031202e557816ULL, 0x000fe200000000ffULL,
0x0000005613138232ULL, 0x000fe20000000000ULL, 0x000031202f587816ULL, 0x000fe400000000ffULL,
0x00000055ff54723eULL, 0x000fc400030006ffULL, 0x000031203d597816ULL, 0x000fe400000000ffULL,
0x0000002c1034723cULL, 0x000fe40000001834ULL, 0x00000059ff3d723eULL, 0x000fca00020006ffULL,
0x00000055ff2c723eULL, 0x000fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000058ff2d723eULL, 0x080fe200020006ffULL, 0x000000005338783bULL, 0x000e620000004200ULL,
0x00000058ff55723eULL, 0x000fe400030006ffULL, 0x000031203c587816ULL, 0x000fc600000000ffULL,
0x0000002c102c723cULL, 0x040fe20000001814ULL, 0x00000058ff3c723eULL, 0x080fe200020006ffULL,
0x000000005a14783bULL, 0x000eac0000000200ULL, 0x0000003c101c723cULL, 0x040fee000000181cULL,
0x00000058ff3c723eULL, 0x000fe200030006ffULL, 0x000000541018723cULL, 0x000fe20000001818ULL,
0x00000059ff3d723eULL, 0x000fcc00030006ffULL, 0x000031203e547816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x000031203f557816ULL, 0x000fcc00000000ffULL,
0x00000054ff3c723eULL, 0x080fe400020006ffULL, 0x00000055ff3d723eULL, 0x080fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400030006ffULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe200000000ffULL, 0x0000003c1024723cULL, 0x040fe20000001824ULL,
0x00000000493c783bULL, 0x000e620000004200ULL, 0x0000312039397816ULL, 0x000fe200000000ffULL,
0x0000005714148232ULL, 0x084fe20000000000ULL, 0x000031203a3a7816ULL, 0x000fe200000000ffULL,
0x0000005716168232ULL, 0x000fe20000000000ULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000005615158232ULL, 0x080fe20000000000ULL, 0x000000541010723cULL, 0x000fe20000001828ULL,
0x0000005617178232ULL, 0x000fcc0000000000ULL, 0x00000038ff28723eULL, 0x080fe400020006ffULL,
0x00000039ff29723eULL, 0x080fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400030006ffULL,
0x00000039ff39723eULL, 0x000fc600030006ffULL, 0x000000281430723cULL, 0x040fee0000001830ULL,
0x0000003aff28723eULL, 0x080fe200020006ffULL, 0x000000381434723cULL, 0x000fe20000001834ULL,
0x0000003bff29723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400030006ffULL,
0x0000003bff3b723eULL, 0x000fc600030006ffULL, 0x00000028142c723cULL, 0x040fe2000000182cULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x0000003cff28723eULL, 0x000fe200020006ffULL,
0x0000003a1418723cULL, 0x000fe20000001818ULL, 0x0000003dff29723eULL, 0x000fe400020006ffULL,
0x000031203f3f7816ULL, 0x000fc400000000ffULL, 0x0000003cff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff3d723eULL, 0x000fe200030006ffULL, 0x00000028141c723cULL, 0x040fee000000181cULL,
0x0000003eff28723eULL, 0x000fe200020006ffULL, 0x0000003c1420723cULL, 0x000fe20000001820ULL,
0x0000003fff29723eULL, 0x000fc400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400030006ffULL,
0x0000003fff3f723eULL, 0x000fc600030006ffULL, 0x000000281424723cULL, 0x040ff00000001824ULL,
0x0000003e1414723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000003000f107a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x00000004ff3a7819ULL, 0x000fe40000011603ULL,
0x0000000110137810ULL, 0x040fe20007ffe0ffULL, 0x0000010010117824ULL, 0x000fc600078e00ffULL,
0x000000021300720cULL, 0x000fe20003f26070ULL, 0x0000620004287a24ULL, 0x000fe200078e0211ULL,
0x0000001100107217ULL, 0x000fc60007800000ULL, 0x0000000143137824ULL, 0x100fe400078e0228ULL,
0x0000000110107824ULL, 0x000fe400078e0a11ULL, 0x0000000147117824ULL, 0x000fc600078e0228ULL,
0x0000002010127807ULL, 0x000fe20000800000ULL, 0x00005e0011107625ULL, 0x000fc600078e0029ULL,
0x0000001205387217ULL, 0x000fe20007800000ULL, 0x00005e0013127625ULL, 0x000fe200078e0029ULL,
0x00000045102a7210ULL, 0x000fc60007f3e0ffULL, 0x0000000138397824ULL, 0x000fe200078e0a05ULL,
0x0000004512127210ULL, 0x000fe20007f7e0ffULL, 0x0000000141107824ULL, 0x100fe400078e0228ULL,
0x0000000140287824ULL, 0x000fe200078e0228ULL, 0x000000393a00720cULL, 0x080fe20003f46070ULL,
0x000000ffff2b7224ULL, 0x000fe200008e0611ULL, 0x000000394600720cULL, 0x000fe20003f26070ULL,
0x00005e0010107625ULL, 0x000fe200078e0029ULL, 0x000000394200720cULL, 0x000fc60003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e0029ULL, 0x0000004510107210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000394400720cULL, 0x000fe20003f66070ULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x0000004528287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a517faeULL, 0x0003e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x0000000012507faeULL, 0x0003ea000c901c46ULL,
0x00000000104f7faeULL, 0x0003e8000d901c46ULL, 0x00000000284e7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff107984ULL, 0x002e620000000800ULL,
0x8000000060117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007824811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000060607824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824860ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000b8004d107811ULL, 0x000fe200078e20ffULL,
0x000000005228783bULL, 0x000e620000004200ULL, 0x0000000cff38723eULL, 0x000fe400000000ffULL,
0x00000002ff417819ULL, 0x000fe20000011603ULL, 0x000000004c3c783bULL, 0x000fe20000004200ULL,
0x00005410383a7816ULL, 0x000fc60000000038ULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x00001f413a417589ULL, 0x000ea800000e0000ULL, 0x00001f0e3a0e7589ULL, 0x000ee200000e0000ULL,
0x0000312028287816ULL, 0x002fe400000000ffULL, 0x0000312029297816ULL, 0x000fc400000000ffULL,
0x00000028ff38723eULL, 0x080fe400020006ffULL, 0x00000029ff39723eULL, 0x080fe200020006ffULL,
0x0000004110108232ULL, 0x084fe20000000000ULL, 0x00000028ff28723eULL, 0x000fe200030006ffULL,
0x0000004112128232ULL, 0x000fe20000000000ULL, 0x00000029ff29723eULL, 0x000fe200030006ffULL,
0x0000000e11118232ULL, 0x088fe20000000000ULL, 0x000031202b437816ULL, 0x000fe200000000ffULL,
0x0000000e13138232ULL, 0x000fe20000000000ULL, 0x000031202a407816ULL, 0x000fc400000000ffULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x00000040ff42723eULL, 0x000fe400030006ffULL,
0x000000281034723cULL, 0x000fe20000001834ULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x0000b8004b2a7811ULL, 0x000fc800078e20ffULL, 0x00000043ff29723eULL, 0x080fe200020006ffULL,
0x000000381030723cULL, 0x000fe20000001830ULL, 0x00000043ff43723eULL, 0x000fe200030006ffULL,
0x000000004a38783bULL, 0x000e620000004200ULL, 0x00000040ff28723eULL, 0x000fe400020006ffULL,
0x000031203e407816ULL, 0x000fc600000000ffULL, 0x000000421018723cULL, 0x040fee0000001818ULL,
0x0000003cff42723eULL, 0x080fe200020006ffULL, 0x00000028102c723cULL, 0x000fe2000000182cULL,
0x0000003dff43723eULL, 0x000fe200020006ffULL, 0x000000002a28783bULL, 0x000ea20000000200ULL,
0x0000003cff3c723eULL, 0x000fc400030006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x00000042101c723cULL, 0x040fee000000181cULL, 0x000031203f437816ULL, 0x000fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe20000001820ULL, 0x00000040ff42723eULL, 0x000fcc00030006ffULL,
0x00000040ff3c723eULL, 0x000fe400020006ffULL, 0x00000043ff3d723eULL, 0x080fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fe400000000ffULL,
0x0000312039397816ULL, 0x000fe200000000ffULL, 0x0000003c1024723cULL, 0x000fe20000001824ULL,
0x00000000483c783bULL, 0x000e620000004200ULL, 0x000031203a3a7816ULL, 0x000fc400000000ffULL,
0x000031203b3b7816ULL, 0x000fc800000000ffULL, 0x000000421010723cULL, 0x000fe20000001814ULL,
0x0000004128288232ULL, 0x084fe40000000000ULL, 0x000000412a2a8232ULL, 0x000fe40000000000ULL,
0x0000000e29298232ULL, 0x080fe40000000000ULL, 0x00000038ff14723eULL, 0x080fe200020006ffULL,
0x0000000e2b2b8232ULL, 0x000fe20000000000ULL, 0x00000039ff15723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400030006ffULL, 0x00000039ff39723eULL, 0x000fc600030006ffULL,
0x000000142830723cULL, 0x040fee0000001830ULL, 0x0000003aff14723eULL, 0x080fe200020006ffULL,
0x000000382834723cULL, 0x000fe20000001834ULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000142814723cULL, 0x040fe2000000182cULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x0000003cff2c723eULL, 0x000fe200020006ffULL, 0x0000003a2818723cULL, 0x000fe20000001818ULL,
0x0000003dff2d723eULL, 0x000fe400020006ffULL, 0x000031203f3f7816ULL, 0x000fc400000000ffULL,
0x0000003cff3c723eULL, 0x000fe400030006ffULL, 0x0000003dff3d723eULL, 0x000fe200030006ffULL,
0x0000002c281c723cULL, 0x040fee000000181cULL, 0x0000003eff2c723eULL, 0x000fe200020006ffULL,
0x0000003c2820723cULL, 0x000fe20000001820ULL, 0x0000003fff2d723eULL, 0x000fc400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x0000002c2824723cULL, 0x040ff00000001824ULL, 0x0000003e2828723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0bff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff617807ULL, 0x000fe40004000000ULL, 0x000003000f0f7a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff09ff7812ULL, 0x000fe4000780c0ffULL, 0x000000020f00720cULL, 0x000fe40003f26070ULL,
0x00000001ff097807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff903000007947ULL, 0x000fea000383ffffULL, 0x0000000000097919ULL, 0x000e620000002500ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0019ULL, 0x000000ffff397224ULL, 0x000fe200078e0015ULL,
0x000000020900720cULL, 0x002fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0007ULL,
0x00007e80000a7802ULL, 0x000fe40000000f00ULL, 0x0000795000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0008ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x00000000000b7919ULL, 0x000ee40000000000ULL, 0x00000002ff0f7819ULL, 0x008fe4000001160bULL,
0x000000080b0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0f00047589ULL, 0x000ea800000e0000ULL, 0x00001f0b000b7589ULL, 0x000ee200000e0000ULL,
0x0000003004307220ULL, 0x044fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x000fe20000410000ULL,
0x000000320b327220ULL, 0x048fe20000410000ULL, 0x000000330b337220ULL, 0x040fe20000410000ULL,
0x000000360b367220ULL, 0x040fe20000410000ULL, 0x000000370b377220ULL, 0x040fe20000410000ULL,
0x000000160b167220ULL, 0x040fe20000410000ULL, 0x000000170b177220ULL, 0x040fe20000410000ULL,
0x0000001a0b1a7220ULL, 0x040fe20000410000ULL, 0x0000001b0b1b7220ULL, 0x040fe20000410000ULL,
0x0000001e0b1e7220ULL, 0x040fe20000410000ULL, 0x0000001f0b1f7220ULL, 0x040fe20000410000ULL,
0x000000220b227220ULL, 0x040fe20000410000ULL, 0x000000230b237220ULL, 0x040fe20000410000ULL,
0x000000260b267220ULL, 0x040fe20000410000ULL, 0x000000270b277220ULL, 0x040fe20000410000ULL,
0x0000002a0b2a7220ULL, 0x040fe20000410000ULL, 0x0000002b0b2b7220ULL, 0x000fe20000410000ULL,
0x0000000000107919ULL, 0x000ea20000000000ULL, 0x0000001c1d1c723eULL, 0x000fc400000000ffULL,
0x000000242524723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000282912723eULL, 0x000fe400000000ffULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x000000161716723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000000262726723eULL, 0x000fc400000000ffULL, 0x0000000210007812ULL, 0x004fe400078ec0ffULL,
0x00000002ff137819ULL, 0x000fe40000011610ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200037811ULL, 0x040fe400078ff8ffULL, 0x0000000400087811ULL, 0x040fe400078ff8ffULL,
0x00000006000c7811ULL, 0x000fc400078ff8ffULL, 0x00000008102f7811ULL, 0x000fe400078ff0ffULL,
0x0000000702007812ULL, 0x100fe400078e7813ULL, 0x00000007080a7812ULL, 0x040fe400078e7813ULL,
0x0000000708087812ULL, 0x000fe200078e782fULL, 0x00000008130b7824ULL, 0x000fe200078e0200ULL,
0x0000000703047812ULL, 0x100fe200078e7813ULL, 0x000008000d007824ULL, 0x000fe200078e00ffULL,
0x000000070c0e7812ULL, 0x000fe200078e7813ULL, 0x000000082f2d7824ULL, 0x002fe200078e0208ULL,
0x0000000702027812ULL, 0x100fe200078e782fULL, 0x00000008130f7824ULL, 0x000fe200078e0204ULL,
0x0000000703037812ULL, 0x100fe200078e782fULL, 0x0000000810087824ULL, 0x000fe200078e00ffULL,
0x000000070c0c7812ULL, 0x000fe200078e782fULL, 0x0000000813117824ULL, 0x000fe200078e020aULL,
0x0000a00000047810ULL, 0x000fe20007ffe0ffULL, 0x000000082f157824ULL, 0x040fe200078e0202ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x000000082f197824ULL, 0x000fe200078e0203ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x0000000813137824ULL, 0x000fe200078e020eULL,
0x000000343503723eULL, 0x000fe200000000ffULL, 0x000000082f2f7824ULL, 0x000fe200078e020cULL,
0x000000183b0a723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0204ULL,
0x0000541002307816ULL, 0x140fe20000000003ULL, 0x0000001015157824ULL, 0x100fe200078e0204ULL,
0x0000763202317816ULL, 0x000fe20000000003ULL, 0x000000100f0f7824ULL, 0x100fe200078e0204ULL,
0x00000020210e723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x0000541024107816ULL, 0x000fe20000000012ULL, 0x0000001011117824ULL, 0x000fe200078e0204ULL,
0x000054101c207816ULL, 0x040fe2000000000eULL, 0x0000001013137824ULL, 0x000fe200078e0204ULL,
0x000076321c217816ULL, 0x000fe2000000000eULL, 0x000000102d2d7824ULL, 0x100fe200078e0204ULL,
0x000000323302723eULL, 0x000fe200000000ffULL, 0x000000102f2f7824ULL, 0x000fc400078e0204ULL,
0x000000010b0b7824ULL, 0x000fe400078e0208ULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x00000001080f7824ULL, 0x040fe200078e020fULL, 0x000000300b007388ULL, 0x0003e20000000a00ULL,
0x0000000108197824ULL, 0x040fe400078e0219ULL, 0x0000000108117824ULL, 0x040fe400078e0211ULL,
0x00000001080c7824ULL, 0x040fe200078e0213ULL, 0x0000002a2b13723eULL, 0x000fe200000000ffULL,
0x00000001082d7824ULL, 0x000fc400078e022dULL, 0x00000001082f7824ULL, 0x000fe200078e022fULL,
0x000000143908723eULL, 0x000fe400000000ffULL, 0x0000001a1b0b723eULL, 0x002fe400000000ffULL,
0x0000541008307816ULL, 0x140fe4000000000aULL, 0x0000763208317816ULL, 0x000fe4000000000aULL,
0x00005410160a7816ULL, 0x140fe4000000000bULL, 0x00007632160b7816ULL, 0x000fe2000000000bULL,
0x000000300f007388ULL, 0x0003e80000000a00ULL, 0x0000002011007388ULL, 0x0005e20000000a00ULL,
0x00000022230f723eULL, 0x002fc400000000ffULL, 0x0000763224117816ULL, 0x004fe40000000012ULL,
0x000054101e0e7816ULL, 0x140fe4000000000fULL, 0x000076321e0f7816ULL, 0x000fe2000000000fULL,
0x000000100c007388ULL, 0x0003e20000000a00ULL, 0x0000541026127816ULL, 0x140fe40000000013ULL,
0x0000763226137816ULL, 0x000fe20000000013ULL, 0x00000300ff0c7624ULL, 0x002fe200078e00ffULL,
0x0000541002107816ULL, 0x000fc40000000036ULL, 0x0000763202117816ULL, 0x000fe40000000036ULL,
0x000000010c00780cULL, 0x000fc60003f05270ULL, 0x0000001015007388ULL, 0x0003e80000000a00ULL,
0x0000000a19007388ULL, 0x0003e80000000a00ULL, 0x0000000e2d007388ULL, 0x0003e80000000a00ULL,
0x000000122f007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cb000008947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x000058000c037a24ULL, 0x000fe200078e02ffULL, 0x000000ff0d00720cULL, 0x000fe40003f25270ULL,
0x00000000002a7919ULL, 0x000ee20000002700ULL, 0x00006400030e7a24ULL, 0x002fc600078e02ffULL,
0x00000000000b7919ULL, 0x000ee40000002600ULL, 0x00001fff0e087811ULL, 0x000fe200078e40ffULL,
0x00000010020f7824ULL, 0x044fe200078e0200ULL, 0x0000002002257810ULL, 0x040fe40007ffe0ffULL,
0x0000004002277810ULL, 0x040fe40007ffe0ffULL, 0x00a000000f107984ULL, 0x0002a20000000c00ULL,
0x0000006002297810ULL, 0x000fe20007ffe0ffULL, 0x000058002a2a7a24ULL, 0x008fc400078e020bULL,
0x00a200000f147984ULL, 0x0002e20000000c00ULL, 0x00002000ff0b7424ULL, 0x000fe200078e00ffULL,
0x000000ff0200720cULL, 0x000fe20003f05270ULL, 0x000003002a037a24ULL, 0x000fe200078e02ffULL,
0x00a400000f187984ULL, 0x0003240000000c00ULL, 0x000000ff0d00720cULL, 0x000fe20000705670ULL,
0x0000000103097824ULL, 0x000fe200078e0209ULL, 0x00a600000f1c7984ULL, 0x0002680000000c00ULL,
0x00000009080a7211ULL, 0x000fca00078f98ffULL, 0x00006a000a0a7625ULL, 0x000fcc00078e000bULL,
0x000008000d0a7825ULL, 0x000fcc00078e000aULL, 0x0000001025247825ULL, 0x000fc800078e000aULL,
0x0000001027267825ULL, 0x000fc800078e000aULL, 0x0000001029287825ULL, 0x000fc800078e000aULL,
0x0000001002227825ULL, 0x000fe200078e000aULL, 0x01ffffff0e0a7812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x00cea20000000000ULL,
0x00000080ff217424ULL, 0x000fe400078e00ffULL, 0x0000000109207824ULL, 0x040fe400078e020aULL,
0x00006a00090e7625ULL, 0x002fc800078e0021ULL, 0x00006a0020207625ULL, 0x000fc800078e0021ULL,
0x000000100b2b7824ULL, 0x004fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc8000001160bULL,
0x000000702b2b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000e0b0e7210ULL, 0x140fe40007b5e02bULL, 0x000000200b207210ULL, 0x000fe40007d9e02bULL,
0x0000000fff0f7210ULL, 0x000fe400017e64ffULL, 0x00000021ff217210ULL, 0x000fc600027ea4ffULL,
0x000000060e007986ULL, 0x0003e8000c101906ULL, 0x0000000720007986ULL, 0x0003e4000c101906ULL,
0x0000001022007986ULL, 0x00c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001424007986ULL, 0x0005e8000c101d06ULL, 0x0000001826007986ULL, 0x0105e8000c101d06ULL,
0x0000001c28007986ULL, 0x0025e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0xffffffff0c097810ULL, 0x000fc60007ffe0ffULL, 0x000068002a067625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000009060679a8ULL, 0x000ee400099ee1c6ULL, 0x000000090600720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0b7807ULL, 0x000fca0000000000ULL,
0x0000000bff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x000ee40000000000ULL,
0x000000ff0600720cULL, 0x008fda0003f05270ULL, 0x0000284000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011602ULL, 0x00000080ff157424ULL, 0x004fe200078e00ffULL,
0x00000001030e7810ULL, 0x000fe40007ffe0ffULL, 0x0000007006177812ULL, 0x000fe400078ec0ffULL,
0x0000000c07167812ULL, 0x000fe200078ec0ffULL, 0x00006a0003067625ULL, 0x000fc800078e0015ULL,
0x00006a000e0e7625ULL, 0x000fe200078e0015ULL, 0x0000000616107210ULL, 0x000fc8000791e017ULL,
0x0000000e160e7210ULL, 0x000fe40007b5e017ULL, 0x00000007ff117210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x0000000610067981ULL, 0x000568000c1e1900ULL,
0x000000060e077981ULL, 0x000562000c1e1900ULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002030e7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0015ULL, 0x0000000e160e7210ULL, 0x000fc8000791e017ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e097981ULL, 0x000562000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003030e7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0015ULL,
0x0000000e160e7210ULL, 0x000fc8000791e017ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e0b7981ULL, 0x002362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004030e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0015ULL, 0x0000000e160e7210ULL, 0x000fc8000791e017ULL,
0x0000000fff0f7210ULL, 0x000fcc00007e24ffULL, 0x000000060e0f7981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000503107810ULL, 0x002fca0007ffe0ffULL, 0x00006a0010107625ULL, 0x000fca00078e0015ULL,
0x0000001016107210ULL, 0x000fc8000791e017ULL, 0x00000011ff117210ULL, 0x000fcc00007e24ffULL,
0x0000000610117981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x002fe40003f06070ULL,
0x0000000603127810ULL, 0x000fca0007ffe0ffULL, 0x00006a0012127625ULL, 0x000fca00078e0015ULL,
0x0000001216127210ULL, 0x000fe40007a3e017ULL, 0x0000000703140810ULL, 0x000fe40007ffe0ffULL,
0x00000013ff137210ULL, 0x000fc60000fe44ffULL, 0x00006a0014140625ULL, 0x000fca00078e0015ULL,
0x0000001416140210ULL, 0x000fe40007c7e017ULL, 0x0000000612177981ULL, 0x000364000c1e1900ULL,
0x00000015ff150210ULL, 0x000fcc0001fe84ffULL, 0x0000000614150981ULL, 0x000366000c1e1900ULL,
0x000000070c0c7810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x000fc8000001160cULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x0000000819147824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000c1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000814127810ULL, 0x040fe40007ffe0ffULL,
0x00000001140e7810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103127824ULL, 0x000fe200078e0212ULL,
0x00000001ff107819ULL, 0x000fe20000011602ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x00000010020e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0012127625ULL, 0x000fc600078e0013ULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000001210127210ULL, 0x000fc80007b3e01bULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x00000006121b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000914127810ULL, 0x042fe40007ffe0ffULL, 0x00000002140e7810ULL, 0x000fe40007ffe0ffULL,
0x0000030012007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000000706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103127824ULL, 0x000fe200078e0212ULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0012127625ULL, 0x000fc600078e0013ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x000000120e127210ULL, 0x000fc80007b3e007ULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x0000000612077981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a14127810ULL, 0x042fe40007ffe0ffULL,
0x00000003140e7810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000000906067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103127824ULL, 0x000fe200078e0212ULL,
0x00000001ff0e7819ULL, 0x000fe20000011602ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001002097824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0012127625ULL, 0x000fc600078e0013ULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x000000120e127210ULL, 0x000fc80007b3e009ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612097981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b14127810ULL, 0x042fe40007ffe0ffULL, 0x00000004140e7810ULL, 0x000fe40007ffe0ffULL,
0x0000030012007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000000b06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103127824ULL, 0x000fe200078e0212ULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0012127625ULL, 0x000fc600078e0013ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000120e127210ULL, 0x000fc80007b3e00bULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x00000006120b7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c140e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000514107810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001030e7824ULL, 0x000fe200078e020eULL,
0x00000001ff127819ULL, 0x002fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000e120e7210ULL, 0x000fc80007b3e013ULL, 0x0000000fff0f7210ULL, 0x000fcc0000fe64ffULL,
0x000000060e0f7981ULL, 0x000366000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d14107810ULL, 0x040fe40007ffe0ffULL, 0x00000006140e7810ULL, 0x002fe40007ffe0ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103107824ULL, 0x000fe200078e0210ULL, 0x00000001ff127819ULL, 0x000fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x000000700e137812ULL, 0x000fc800078ec0ffULL, 0x0000001012107210ULL, 0x000fc80007b3e013ULL,
0x00000011ff117210ULL, 0x000fcc0000fe64ffULL, 0x0000000610117981ULL, 0x000366000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e14127810ULL, 0x040fe40007ffe0ffULL,
0x00000007140e7810ULL, 0x000fe40007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103127824ULL, 0x000fe200078e0212ULL,
0x00000001ff107819ULL, 0x002fe20000011602ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x00000010020e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0012127625ULL, 0x000fc600078e0013ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000001210127210ULL, 0x000fc80007b3e017ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f14127810ULL, 0x002fe40007ffe0ffULL, 0x0000001506067209ULL, 0x000fe40007810000ULL,
0x0000030012007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103127824ULL, 0x000fe200078e0212ULL, 0x00000001ff107819ULL, 0x000fe20000011602ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a0012127625ULL, 0x000fc600078e0013ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000001210127210ULL, 0x000fc80007a3e015ULL,
0x00000013ff137210ULL, 0x000fca0000fe44ffULL, 0x0000000612157981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x0000001002077824ULL, 0x024fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011602ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c090c7812ULL, 0x000fca00078ec0ffULL,
0x0000000107077824ULL, 0x000fca00078e020cULL, 0x0000000607007388ULL, 0x0005e40000000800ULL,
0x00000003080e7211ULL, 0x002fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0f7424ULL, 0x000fe200078e00ffULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x0000001002097824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011602ULL,
0x00006a000e0e7625ULL, 0x000fe200078e000fULL, 0x00000015ff077819ULL, 0x004fe2000001160dULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x000008000d067824ULL, 0x000fe200078e00ffULL, 0x0000000c0b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000002002117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000060e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000103168824ULL, 0x000fe200078e020aULL, 0x0000004002137810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x0000006002157810ULL, 0x000fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x000fe200078e020cULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000010f0f7824ULL, 0x000fe200008e0607ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff188424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000010000d097824ULL, 0x000fe200078e00ffULL, 0x000000000b0b7984ULL, 0x000e620000000800ULL,
0x00006a0016168625ULL, 0x000fe200078e0017ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x0000001011107825ULL, 0x000fc800078e000eULL,
0x0000001013127825ULL, 0x000fc800078e000eULL, 0x0000001015147825ULL, 0x000fc800078e000eULL,
0x000000100d1f8824ULL, 0x000fe400078e0202ULL, 0x00006a0003188625ULL, 0x000fc600078e0018ULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x00000010021b7824ULL, 0x040fe400078e0209ULL,
0x00000010020e7825ULL, 0x000fc800078e000eULL, 0x000000100d258824ULL, 0x000fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e1b7faeULL, 0x0005e2000b901c46ULL,
0x0000001002168825ULL, 0x000fc600078e0016ULL, 0x0000418025258811ULL, 0x000fe200078e20ffULL,
0x0000001002188825ULL, 0x000fe200078e0018ULL, 0x00380000101b7faeULL, 0x0007e6000b901c46ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00580000121b7faeULL, 0x0009e2000b901c46ULL,
0x00000000000e7805ULL, 0x004fc6000001ff00ULL, 0x00780000141b7faeULL, 0x0005e8000b901c46ULL,
0x00000000161f8faeULL, 0x000be2000b901c46ULL, 0x0000000000107805ULL, 0x008fc6000001ff00ULL,
0x0000000018258faeULL, 0x0007e2000b901c46ULL, 0x0000000000127805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x020fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000d6000009947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x002fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fca00078e00ffULL,
0x000000012f2e7810ULL, 0x000fc80007ffe0ffULL, 0x000003002e007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x0000000103417824ULL, 0x000fe200078e022eULL,
0x000000070200780cULL, 0x000fe20003f24070ULL, 0x00002000ff317424ULL, 0x000fe200078e00ffULL,
0x000000012e347812ULL, 0x000fe400078ec0ffULL, 0x0000004108307211ULL, 0x000fe400078f98ffULL,
0x0000002002357810ULL, 0x040fe40007ffe0ffULL, 0x0000004002397810ULL, 0x000fe20007ffe0ffULL,
0x00006a0030307625ULL, 0x000fe200078e0031ULL, 0x00000060023f7810ULL, 0x000fc60007ffe0ffULL,
0x000000010a369824ULL, 0x000fe200078e0241ULL, 0x0000000630327210ULL, 0x000fe20007f1e0ffULL,
0x000008002e307824ULL, 0x000fe400078e00ffULL, 0x00000080ff379424ULL, 0x000fe400078e00ffULL,
0x0000000131337824ULL, 0x000fe200000e0607ULL, 0x0000080030307812ULL, 0x000fe200078ec0ffULL,
0x000000020d3b9824ULL, 0x140fe400078e0234ULL, 0x000000020d439824ULL, 0x000fc400078e0234ULL,
0x0000000109317824ULL, 0x000fe400078e0230ULL, 0x00000080ff3a9424ULL, 0x000fe400078e00ffULL,
0x00000010023d7824ULL, 0x000fe400078e0231ULL, 0x0000001035307825ULL, 0x000fc800078e0032ULL,
0x0000001039347825ULL, 0x000fc800078e0032ULL, 0x0000001002387825ULL, 0x000fc800078e0032ULL,
0x000000103f327825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000383d7faeULL, 0x0003e6000b901c46ULL, 0x00006a0036369625ULL, 0x000fe200078e0037ULL,
0x00380000303d7faeULL, 0x0003e6000b901c46ULL, 0x000000083b3f9824ULL, 0x000fe200078e0202ULL,
0x00580000343d7faeULL, 0x0003e2000b901c46ULL, 0x00006a00413a9625ULL, 0x000fc600078e003aULL,
0x000045803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000000843419824ULL, 0x000fe200078e0202ULL,
0x00780000323d7faeULL, 0x0003e2000b901c46ULL, 0x0000001002369825ULL, 0x000fc600078e0036ULL,
0x0000418041419811ULL, 0x000fe200078e20ffULL, 0x00000010023a9825ULL, 0x000fe200078e003aULL,
0x00000000363f9faeULL, 0x0003e8000b901c46ULL, 0x000000003a419faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff337224ULL, 0x002fe200078e002fULL,
0x00000001ff327819ULL, 0x100fe20000011602ULL, 0x0000001002317824ULL, 0x000fe200078e00ffULL,
0x00000002ff397819ULL, 0x000fe20000011602ULL, 0x00000080332f7824ULL, 0x000fe200078e00ffULL,
0x0000000c32327812ULL, 0x000fc400078ec0ffULL, 0x0000007031317812ULL, 0x000fe200078ec0ffULL,
0x0000000839357824ULL, 0x000fe200078e00ffULL, 0x000000802f307812ULL, 0x000fe200078ec0ffULL,
0x00000008392f7824ULL, 0x040fe200078e00ffULL, 0x0000000739427812ULL, 0x000fe400078ec0ffULL,
0x00000039ff407212ULL, 0x000fe200078e33ffULL, 0x000001000d307824ULL, 0x000fc600078e0230ULL,
0xfffffff82f407812ULL, 0x000fe400078ee240ULL, 0x0000003032327210ULL, 0x000fe20007ffe031ULL,
0x0000000839317824ULL, 0x040fe200078e00ffULL, 0x00000008392f7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000323e7984ULL, 0x000e620000000800ULL,
0x0000000131347812ULL, 0x100fe200078ef642ULL, 0x000000082f447824ULL, 0x000fe200078e00ffULL,
0x0000000231367812ULL, 0x140fe200078ef642ULL, 0x0045800032507984ULL, 0x0002a20000000800ULL,
0x0000000331387812ULL, 0x140fe400078ef642ULL, 0x00000004313a7812ULL, 0x140fe400078ef642ULL,
0x00000005313c7812ULL, 0x100fe400078ef642ULL, 0xfffffff835307812ULL, 0x000fe200078ee242ULL,
0x000000082f357824ULL, 0x000fe200078e00ffULL, 0x0000002fff4e7212ULL, 0x000fc800078e33ffULL,
0xfffffff8354e7812ULL, 0x000fe400078ee24eULL, 0x000000072f357812ULL, 0x000fe200078ec0ffULL,
0x0000003e0b327221ULL, 0x002fe20000010100ULL, 0x00000006313e7812ULL, 0x000fe200078ef642ULL,
0x0000080033317824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b32377820ULL, 0x000fe20000410000ULL,
0x0000000402337824ULL, 0x000fe400078e00ffULL, 0x0000080031327812ULL, 0x000fe200078ec0ffULL,
0x000000082f427824ULL, 0x000fc400078e00ffULL, 0x0000000c33337812ULL, 0x000fe200078ec0ffULL,
0x0000003700377308ULL, 0x000ea20000000800ULL, 0x0000018009317810ULL, 0x000fe40007ffe032ULL,
0xfffffff844327812ULL, 0x100fe400078ee235ULL, 0x0000000242467812ULL, 0x000fe200078ef635ULL,
0x0000001034347824ULL, 0x000fe200078e0231ULL, 0x0000000142447812ULL, 0x000fe200078ef635ULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x0000000342487812ULL, 0x140fe200078ef635ULL,
0x0000000133347824ULL, 0x000fe200078e0234ULL, 0x00000004424a7812ULL, 0x000fe200078ef635ULL,
0x0000001038387824ULL, 0x000fe200078e0231ULL, 0x00000005424c7812ULL, 0x000fe200078ef635ULL,
0x0000000130307824ULL, 0x000fe200078e0233ULL, 0x0000000642427812ULL, 0x000fe200078ef635ULL,
0x0000001040407824ULL, 0x100fe200078e0231ULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e0231ULL, 0x0000005037527220ULL, 0x004fe20000410000ULL,
0x0000000133387824ULL, 0x040fe200078e0238ULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x000000103c3c7824ULL, 0x000fe200078e0231ULL, 0x0000002d522d7221ULL, 0x000fe20000010000ULL,
0x0000000133407824ULL, 0x040fe200078e0240ULL, 0x00001f3952357589ULL, 0x000fe200000e0000ULL,
0x0000000133367824ULL, 0x000fc400078e0236ULL, 0x000000103a3a7824ULL, 0x100fe200078e0231ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x00000001333c7824ULL, 0x040fe400078e023cULL,
0x0000001032327824ULL, 0x100fe200078e0231ULL, 0x0000000040407984ULL, 0x000ea20000000800ULL,
0x00000001333a7824ULL, 0x040fe400078e023aULL, 0x000000103e3e7824ULL, 0x000fe200078e0231ULL,
0x0000000036367984ULL, 0x000ee20000000800ULL, 0x0000000133327824ULL, 0x000fc400078e0232ULL,
0x0000001046467824ULL, 0x100fe200078e0231ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x00000001333e7824ULL, 0x040fe400078e023eULL, 0x0000001044447824ULL, 0x100fe200078e0231ULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x0000000133467824ULL, 0x040fe400078e0246ULL,
0x0000000133447824ULL, 0x000fe200078e0244ULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x0000001048487824ULL, 0x000fc400078e0231ULL, 0x000000104a4a7824ULL, 0x100fe200078e0231ULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000000133487824ULL, 0x040fe400078e0248ULL,
0x000000104c4c7824ULL, 0x100fe200078e0231ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x00000001334a7824ULL, 0x040fe400078e024aULL, 0x00000001334c7824ULL, 0x000fe200078e024cULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x0000001042427824ULL, 0x000fc400078e0231ULL,
0x000000104e4e7824ULL, 0x000fe200078e0231ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x0000000133427824ULL, 0x040fe400078e0242ULL, 0x00000001334e7824ULL, 0x000fe200078e024eULL,
0x00001f2f52527589ULL, 0x00076200000e0000ULL, 0x30000030ff317230ULL, 0x102fe40000004100ULL,
0x20000030ff507230ULL, 0x000fe20000004100ULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x20000040ff307230ULL, 0x104fe20000004100ULL, 0x00000035311e7223ULL, 0x080fe2000001001eULL,
0x30000040ff337230ULL, 0x000fe20000004100ULL, 0x000000004c4c7984ULL, 0x000ea20000000800ULL,
0x30000036ff317230ULL, 0x008fe20000004100ULL, 0x00000035301d7223ULL, 0x080fe2000001001dULL,
0x30000034ff2f7230ULL, 0x100fe20000004100ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x20000034ff307230ULL, 0x000fe20000004100ULL, 0x0000003531187223ULL, 0x080fe20000010018ULL,
0x20000036ff347230ULL, 0x000fe20000004100ULL, 0x000000352f1a7223ULL, 0x080fe2000001001aULL,
0x000000004e4e7984ULL, 0x000ee20000000800ULL, 0x30000038ff2f7230ULL, 0x000fe20000004100ULL,
0x00000035301b7223ULL, 0x080fe2000001001bULL, 0x3000003aff317230ULL, 0x010fe20000004100ULL,
0x00000035331c7223ULL, 0x080fe2000001001cULL, 0x20000038ff307230ULL, 0x000fe20000004100ULL,
0x000000352f167223ULL, 0x080fe20000010016ULL, 0x3000003cff2f7230ULL, 0x000fe20000004100ULL,
0x0000003531147223ULL, 0x080fe20000010014ULL, 0x3000003eff317230ULL, 0x020fe20000004100ULL,
0x0000003530177223ULL, 0x080fe20000010017ULL, 0x2000003cff307230ULL, 0x000fe20000004100ULL,
0x000000352f127223ULL, 0x080fe20000010012ULL, 0x30000032ff2f7230ULL, 0x000fe20000004100ULL,
0x0000003531107223ULL, 0x080fe20000010010ULL, 0x20000044ff317230ULL, 0x000fe20000004100ULL,
0x0000003530137223ULL, 0x080fe20000010013ULL, 0x2000003eff307230ULL, 0x000fe20000004100ULL,
0x000000522f0e7223ULL, 0x080fe2000001000eULL, 0x30000046ff2f7230ULL, 0x000fe20000004100ULL,
0x00000052312c7223ULL, 0x080fe2000001002cULL, 0x20000048ff317230ULL, 0x000fe20000004100ULL,
0x0000003534197223ULL, 0x080fe20000010019ULL, 0x0000003530117223ULL, 0x080fe20000010011ULL,
0x000000522f267223ULL, 0x080fe20000010026ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x00000052312a7223ULL, 0x080fe2000001002aULL, 0x2000003aff347230ULL, 0x000fe20000004100ULL,
0x00000035501f7223ULL, 0x080fe2000001001fULL, 0x20000046ff307230ULL, 0x000fe20000004100ULL,
0x000003002f007a0cULL, 0x000fe20003f06070ULL, 0x2000004aff317230ULL, 0x002fe20000004100ULL,
0x0000003534157223ULL, 0x000fe20000010015ULL, 0x2000004cff337230ULL, 0x004fe20000004100ULL,
0x0000005230277223ULL, 0x080fe20000010027ULL, 0x20000032ff347230ULL, 0x000fe20000004100ULL,
0x0000005231207223ULL, 0x080fe20000010020ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000005233247223ULL, 0x080fe20000010024ULL, 0x30000048ff487230ULL, 0x000fe20000004100ULL,
0x00000052340f7223ULL, 0x080fe2000001000fULL, 0x3000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000052442b7223ULL, 0x080fe2000001002bULL, 0x3000004cff317230ULL, 0x000fe20000004100ULL,
0x0000005248297223ULL, 0x080fe20000010029ULL, 0x20000042ff2e7230ULL, 0x108fe20000004100ULL,
0x000000524a257223ULL, 0x080fe20000010025ULL, 0x30000042ff337230ULL, 0x000fe20000004100ULL,
0x0000005231287223ULL, 0x080fe20000010028ULL, 0x2000004eff307230ULL, 0x100fe20000004100ULL,
0x000000522e237223ULL, 0x080fe20000010023ULL, 0x3000004eff357230ULL, 0x000fe20000004100ULL,
0x0000005233227223ULL, 0x000fc40000010022ULL, 0x0000005230217223ULL, 0x080fe40000010021ULL,
0x00000052350c7223ULL, 0x000fe2000001000cULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x018000002d027810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000002027812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000aa80000a7802ULL, 0x000fe40000000f00ULL, 0x00004d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0008ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc8000000002dULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000806317811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2f7819ULL, 0x000fe40000011606ULL, 0x00000031ff2d7212ULL, 0x002fe200078e33ffULL,
0x00001f3102077589ULL, 0x000e6200000e0000ULL, 0x0000000831087824ULL, 0x000fc400078e00ffULL,
0x000000082f337824ULL, 0x040fe200078e00ffULL, 0x00001f2f02037589ULL, 0x0004e400000e0000ULL,
0xfffffff8082d7812ULL, 0x000fe200078ee22dULL, 0x000000082f087824ULL, 0x000fc800078e00ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0204ULL, 0x0000002fff027212ULL, 0x004fc800078e33ffULL,
0xfffffff833337812ULL, 0x000fe400078ee202ULL, 0x000000072f027812ULL, 0x000fe200078ec0ffULL,
0x0000002107217220ULL, 0x042fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x000fe20000410000ULL,
0x0000001f031f7220ULL, 0x048fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001103117220ULL, 0x040fe20000410000ULL, 0x0000001003107220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x000fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000002807037220ULL, 0x040fe20000410000ULL,
0x00000002020a7812ULL, 0x000fe200078e3cffULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x000000210c0c723eULL, 0x000fe200000000ffULL,
0x0000000f070f7220ULL, 0x000fe20000410000ULL, 0x0000000731217812ULL, 0x000fe200078ec0ffULL,
0x0000000e070e7220ULL, 0x040fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002b072b7220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x000fe20000410000ULL, 0xfffffff808077812ULL, 0x000fe200078ee22fULL,
0x000000082f0b7824ULL, 0x000fe200078e020aULL, 0x0000002a2929723eULL, 0x000fc400000000ffULL,
0x000000240303723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x0000000102087812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x000fe200078e0204ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000000406237824ULL, 0x000fe200078e00ffULL,
0x0000000302247812ULL, 0x040fe200078e3cffULL, 0x000000082f097824ULL, 0x040fe200078e0208ULL,
0x0000000402287812ULL, 0x040fe400078e3cffULL, 0x00000005022a7812ULL, 0x040fe200078e3cffULL,
0x000000082f0d7824ULL, 0x000fe200078e0224ULL, 0x00000004210a7812ULL, 0x000fe200078e3cffULL,
0x0000001009097824ULL, 0x100fe200078e0204ULL, 0x0000000602027812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x000fe200078e0204ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x00000008311d7824ULL, 0x000fe200078e020aULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x00000008312c7824ULL, 0x000fe200078e00ffULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x000000082f137824ULL, 0x040fe200078e0202ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082f0f7824ULL, 0x000fe200078e0228ULL, 0x0000000c230a7812ULL, 0x000fe200078ec0ffULL,
0x0000001013137824ULL, 0x000fe200078e0204ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x000000082f117824ULL, 0x000fe200078e022aULL, 0x0000000121027812ULL, 0x040fe200078e3cffULL,
0x000000010a077824ULL, 0x000fe200078e0207ULL, 0x0000000221067812ULL, 0x000fe200078e3cffULL,
0x000000100f0f7824ULL, 0x100fe200078e0204ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000001011117824ULL, 0x000fe200078e0204ULL, 0x0000000321087812ULL, 0x000fe200078e3cffULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020bULL, 0xfffffff82c157812ULL, 0x000fe200078ee231ULL,
0x000000010a0d7824ULL, 0x000fe200078e020dULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000000831177824ULL, 0x000fe200078e0202ULL, 0x00000005211f7812ULL, 0x000fe200078e3cffULL,
0x0000001033027824ULL, 0x000fe200078e0204ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x00000008311b7824ULL, 0x040fe200078e0208ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000000831197824ULL, 0x000fe200078e0206ULL, 0x0000000621217812ULL, 0x000fe200078e3cffULL,
0x0000001015067824ULL, 0x100fe200078e0204ULL, 0x0000001e07007388ULL, 0x0003e20000000800ULL,
0x000000010a0f7824ULL, 0x000fe200078e020fULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x00000008311f7824ULL, 0x000fe200078e021fULL, 0x0000001a09007388ULL, 0x0003e20000000800ULL,
0x0000001017087824ULL, 0x000fe200078e0204ULL, 0x000000202520723eULL, 0x000fe200000000ffULL,
0x000000010a117824ULL, 0x000fe200078e0211ULL, 0x000000180b007388ULL, 0x0003e20000000800ULL,
0x0000000831217824ULL, 0x000fc400078e0221ULL, 0x0000001019197824ULL, 0x100fe200078e0204ULL,
0x000000160d007388ULL, 0x0003e20000000800ULL, 0x000000010a137824ULL, 0x040fe400078e0213ULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0x000000140f007388ULL, 0x0003e20000000800ULL,
0x000000010a157824ULL, 0x040fe400078e0202ULL, 0x000000101d1d7824ULL, 0x000fe200078e0204ULL,
0x0000001211007388ULL, 0x0003e20000000800ULL, 0x000000010a177824ULL, 0x000fc400078e0206ULL,
0x000000101f1f7824ULL, 0x000fe200078e0204ULL, 0x0000001013007388ULL, 0x0003e20000000800ULL,
0x000000010a087824ULL, 0x040fe400078e0208ULL, 0x0000001021217824ULL, 0x000fe200078e0204ULL,
0x0000001c15007388ULL, 0x0003e20000000800ULL, 0x000000010a197824ULL, 0x040fe400078e0219ULL,
0x000000010a027824ULL, 0x040fe200078e021bULL, 0x0000000e17007388ULL, 0x0003e20000000800ULL,
0x000000010a1d7824ULL, 0x000fc400078e021dULL, 0x000000010a047824ULL, 0x040fe200078e021fULL,
0x0000002b08007388ULL, 0x0003e20000000800ULL, 0x000000010a217824ULL, 0x040fe400078e0221ULL,
0x000000010a2d7824ULL, 0x000fe200078e022dULL, 0x0000002619007388ULL, 0x0003e80000000800ULL,
0x0000002902007388ULL, 0x0003e80000000800ULL, 0x000000201d007388ULL, 0x0003e80000000800ULL,
0x0000000304007388ULL, 0x0003e80000000800ULL, 0x0000002221007388ULL, 0x0003e80000000800ULL,
0x0000000c2d007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000001b7919ULL, 0x004ea20000002600ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000580000057ab9ULL, 0x000fc40000000800ULL, 0x00000000001d7919ULL, 0x002e620000000000ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x000000101b037824ULL, 0x004fc600078e00ffULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0x000000101b187824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x002fe4000001161dULL, 0x000000201d1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000401d1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000601d217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff003047812ULL, 0x000fc400078ee202ULL, 0x00000003ff037819ULL, 0x100fe4000001161eULL,
0x00000003ff197819ULL, 0x000fe4000001161fULL, 0x00000003ff1a7819ULL, 0x000fe40000011621ULL,
0x0000000702027812ULL, 0x000fe400078e481dULL, 0x0000000703067812ULL, 0x000fe400078e481eULL,
0x0000000719087812ULL, 0x000fc400078e481fULL, 0xfffffff018187812ULL, 0x000fe400078ee203ULL,
0x000000071a0a7812ULL, 0x000fe400078e4821ULL, 0x0ffffff802037812ULL, 0x000fe400078ef81dULL,
0x0ffffff806077812ULL, 0x000fe400078ef81eULL, 0x0ffffff808097812ULL, 0x000fe200078ef81fULL,
0x0000001003087824ULL, 0x100fe200078e0200ULL, 0x0ffffff80a0b7812ULL, 0x000fe200078ef821ULL,
0x0000001007077824ULL, 0x100fe200078e0200ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009107824ULL, 0x100fe200078e0200ULL, 0x000000071d1c7812ULL, 0x000fe200078ec0ffULL,
0x000000100b147824ULL, 0x000fe200078e0200ULL, 0x00a00000070c7984ULL, 0x0003e20000000c00ULL,
0x000000101b007824ULL, 0x000fc400078e00ffULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x00a0000008087984ULL, 0x000ea20000000c00ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0004027a11ULL, 0x000fe400078048ffULL, 0x00a0000010107984ULL, 0x000ee20000000c00ULL,
0xfffffff000197812ULL, 0x000fe400078ee219ULL, 0x000000071e007812ULL, 0x000fe200078ec0ffULL,
0x00a0000014147984ULL, 0x000f220000000c00ULL, 0xfffffff01b067812ULL, 0x000fc400078ee21aULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x00000004181e7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000071f047812ULL, 0x000fe400078ec0ffULL, 0x1ffffff8001d7812ULL, 0x000fe200078ef805ULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x0000000419077c10ULL, 0x002fe4000ff3e0ffULL,
0x0000000406007c10ULL, 0x000fc4000ff5e0ffULL, 0x1ffffff81c1b7812ULL, 0x100fe200078ef805ULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00000007211a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x1ffffff8041f7812ULL, 0x000fe200078ef805ULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a001e047a11ULL, 0x000fe400078048ffULL,
0x00005a0007067a11ULL, 0x000fe400078248ffULL, 0x00005a0000187a11ULL, 0x000fc400078448ffULL,
0x1ffffff81a217812ULL, 0x000fe400078ef805ULL, 0x00005b001e057a11ULL, 0x000fe400000f4c23ULL,
0x00005b0007077a11ULL, 0x000fe200008f4c1cULL, 0x0000000802007986ULL, 0x004fe2000c101d06ULL,
0x00005b0000197a11ULL, 0x000fe200010f4c19ULL, 0x000000101d047825ULL, 0x000fc800078e0004ULL,
0x000000101f067825ULL, 0x000fe200078e0006ULL, 0x0000000c04007986ULL, 0x000fe6000c101d06ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000001006007986ULL, 0x008fe8000c101d06ULL,
0x0000001418007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x00000006043d7981ULL, 0x000362000c1e9900ULL, 0x000000010f077810ULL, 0x000fe20007ffe0ffULL,
0x0000000214037824ULL, 0x000fe400078e00ffULL, 0x000000400d0e7824ULL, 0x000fe200078e00ffULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x00005800030c7a24ULL, 0x000fe400078e0216ULL,
0x000001000f097824ULL, 0x000fc800078e020eULL, 0x000062000c1b7a24ULL, 0x000fcc00078e0209ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x002e620000000000ULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x0000000900037217ULL, 0x000fe40007800000ULL,
0x000020000d187811ULL, 0x000fc600078e68ffULL, 0x0000000103037824ULL, 0x000fe200078e0a09ULL,
0x00000002ff207819ULL, 0x002fe20000011615ULL, 0x00000010151f7824ULL, 0x000fc600078e00ffULL,
0x0000000820147810ULL, 0x040fe20007ffe0ffULL, 0x0000000120047824ULL, 0x140fe200078e021bULL,
0x0000001820247810ULL, 0x040fe40007ffe0ffULL, 0x0000001020227810ULL, 0x000fe20007ffe0ffULL,
0x0000000114067824ULL, 0x000fe200078e021bULL, 0x000000301f1f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x080fe200078e0021ULL, 0x00000020201a7810ULL, 0x040fe40007ffe0ffULL,
0x00000028201c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000001f04107210ULL, 0x000fc40007f1e0ffULL, 0x00000030201e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001240a7824ULL, 0x100fe200078e021bULL, 0x0000001f06127210ULL, 0x000fe20007f3e0ffULL,
0x0000000122087824ULL, 0x040fe200078e021bULL, 0x000000032200720cULL, 0x000fe20003fa6070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0021ULL, 0x000000032400720cULL, 0x080fe40003f86070ULL,
0x000000031a00720cULL, 0x000fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fc800078e0021ULL,
0x000000011b067824ULL, 0x000fe400078e021aULL, 0x000000ffff137224ULL, 0x000fe200008e0607ULL,
0x0000001f0a0a7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0605ULL,
0x0000001f08047210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x00000003ff087819ULL, 0x000fc60000011615ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000000031400720cULL, 0x040fe20003f26070ULL, 0x0000000414177824ULL, 0x000fe200078e00ffULL,
0x0000000308087812ULL, 0x000fe200078e4815ULL, 0x000000ffff057224ULL, 0x000fe200000e0609ULL,
0x0000001f06147210ULL, 0x000fe20007f5e0ffULL, 0x000000011b067824ULL, 0x000fe200078e021cULL,
0x000000032000720cULL, 0x000fe20003f06070ULL, 0x000000041e1d7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc08097812ULL, 0x000fe200078ef815ULL, 0x000000ffff157224ULL, 0x000fe200010e0607ULL,
0xfffffffc17177812ULL, 0x000fe200078ee208ULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000003820207810ULL, 0x000fc40007ffe0ffULL, 0x000000031c00720cULL, 0x000fe20003f46070ULL,
0x0000001009097824ULL, 0x100fe200078e0218ULL, 0x0000001f06167210ULL, 0x000fe20007fde0ffULL,
0x0000001017197824ULL, 0x000fe400078e0218ULL, 0x000000011b067824ULL, 0x000fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c46ULL,
0x000000032000720cULL, 0x080fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fe400030e0607ULL,
0x0000000012197faeULL, 0x0005e2000c901c46ULL, 0x000000031e00720cULL, 0x000fe20003f26070ULL,
0x0000000422037824ULL, 0x000fc400078e00ffULL, 0x0000000420237824ULL, 0x000fe400078e00ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0xfffffffc03037812ULL, 0x000fc600078ee208ULL,
0x0000000424117824ULL, 0x002fe200078e00ffULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x000000041a137824ULL, 0x004fe400078e00ffULL, 0x000000041c197824ULL, 0x000fe200078e00ffULL,
0xfffffffc11117812ULL, 0x000fe200078ee208ULL, 0x000000011b097824ULL, 0x000fe200078e0220ULL,
0xfffffffc1d1b7812ULL, 0x100fe200078ee208ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0xfffffffc13137812ULL, 0x000fe200078ee208ULL, 0x0000001003037824ULL, 0x000fe200078e0218ULL,
0xfffffffc19197812ULL, 0x000fe200078ee208ULL, 0x0000001011117824ULL, 0x000fe200078e0218ULL,
0xfffffffc231d7812ULL, 0x000fe200078ee208ULL, 0x00005e0009087625ULL, 0x000fe200078e0021ULL,
0x0000000004037faeULL, 0x0003e6000e901c46ULL, 0x0000001013137824ULL, 0x100fe200078e0218ULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x100fe200078e0218ULL,
0x000000000a117faeULL, 0x0003e2000e101c46ULL, 0x000000101b1b7824ULL, 0x000fc400078e0218ULL,
0x000000101d1d7824ULL, 0x000fe200078e0218ULL, 0x0000000014137faeULL, 0x0003e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fc600030e0609ULL, 0x0000000016197faeULL, 0x0003e8000d101c46ULL,
0x00000000061b7faeULL, 0x0003e8000c901c46ULL, 0x00000000081d7faeULL, 0x0003e2000c101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x002e620000000000ULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0x000020000d237811ULL, 0x000fe200078e68ffULL,
0x0000001012067824ULL, 0x042fe200078e00ffULL, 0x0000001012057811ULL, 0x000fc400078ff0ffULL,
0x0000001b12047211ULL, 0x040fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011612ULL,
0x00000004051e7824ULL, 0x000fe200078e00ffULL, 0x0000000812087811ULL, 0x000fe400078ff0ffULL,
0x0000003006277812ULL, 0x000fe200078ec0ffULL, 0x000000011b067824ULL, 0x000fe200078e0205ULL,
0x0000001812077811ULL, 0x000fe200078ff0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0x0000002012097811ULL, 0x000fc400078ff0ffULL, 0x00000028120a7811ULL, 0x000fe200078ff0ffULL,
0x0000000408147824ULL, 0x000fe200078e00ffULL, 0x00000030120b7811ULL, 0x040fe200078ff0ffULL,
0x0000000407207824ULL, 0x000fe200078e00ffULL, 0x0000003812107811ULL, 0x000fe200078ff0ffULL,
0x0000000409227824ULL, 0x000fe200078e00ffULL, 0x0000000303137812ULL, 0x100fe200078e4812ULL,
0x000000040a247824ULL, 0x000fe400078e00ffULL, 0x000000040b267824ULL, 0x000fe200078e00ffULL,
0x0ffffffc13167812ULL, 0x000fe200078ef812ULL, 0x0000000410287824ULL, 0x000fe200078e00ffULL,
0x0000002704127210ULL, 0x000fe20007f1e0ffULL, 0x0000000108037824ULL, 0x000fe200078e021bULL,
0xfffffffc24157812ULL, 0x100fe200078ee213ULL, 0x000000011b187824ULL, 0x040fe200078e020aULL,
0xfffffffc140a7812ULL, 0x000fe200078ee213ULL, 0x000000011b1a7824ULL, 0x040fe200078e020bULL,
0xfffffffc1e0b7812ULL, 0x100fe200078ee213ULL, 0x000000011b1c7824ULL, 0x040fe200078e0210ULL,
0xfffffffc20107812ULL, 0x000fe200078ee213ULL, 0x000000011b087824ULL, 0x000fe200078e0207ULL,
0xfffffffc22147812ULL, 0x100fe200078ee213ULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0xfffffffc26177812ULL, 0x000fc400078ee213ULL, 0xfffffffc281e7812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe400000e0605ULL, 0x00005e0003047625ULL, 0x000fc800078e0025ULL,
0x00000010141d7824ULL, 0x000fe200078e0223ULL, 0x0000002704147210ULL, 0x000fe20007f1e0ffULL,
0x000000011b117824ULL, 0x000fe400078e0209ULL, 0x00005e0008087625ULL, 0x000fc800078e0025ULL,
0x0000001016297824ULL, 0x100fe200078e0223ULL, 0x0000002706167210ULL, 0x080fe20007f3e0ffULL,
0x00000010151f7824ULL, 0x000fe400078e0223ULL, 0x000000ffff157224ULL, 0x000fe200000e0605ULL,
0x0000002708087210ULL, 0x000fe20007f1e0ffULL, 0x0000001017217824ULL, 0x000fe200078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe400008e0607ULL, 0x00005e0011047625ULL, 0x000fc800078e0025ULL,
0x000000100a037824ULL, 0x100fe400078e0223ULL, 0x000000100b197824ULL, 0x100fe400078e0223ULL,
0x00005e0018067625ULL, 0x000fe200078e0025ULL, 0x0000000014037faeULL, 0x0003e6000b901c46ULL,
0x00000010101b7824ULL, 0x000fe200078e0223ULL, 0x0000002706067210ULL, 0x000fe20007f3e0ffULL,
0x00005e001a0a7625ULL, 0x080fe200078e0025ULL, 0x0000000016197faeULL, 0x0003e6000b901c46ULL,
0x00005e001c107625ULL, 0x000fe200078e0025ULL, 0x000000270a0a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000002704047210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000002710107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x00000000081b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff057224ULL, 0x000fe400000e0605ULL, 0x000000101e237824ULL, 0x000fe400078e0223ULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e8000b901c46ULL, 0x000000000a217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e4000b901c46ULL, 0x01060400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000030d00780cULL, 0x000fda0003f04070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x000000200d037824ULL, 0x002fc800078e0204ULL,
0x0000002003057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104087812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x100fe400078e7803ULL,
0x0000000708087812ULL, 0x100fe400078e7803ULL, 0x00000010040a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x000000070a0a7812ULL, 0x000fc400078e7803ULL,
0x0000000006147984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7803ULL,
0x00000001050a7824ULL, 0x040fe200078e020aULL, 0x0000000008107984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0017ULL, 0x0000001806007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fca00078e0013ULL,
0x0000001c08007388ULL, 0x000fe8000000cc00ULL, 0x0000000004107984ULL, 0x000e68000000cc00ULL,
0x000000000a147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x004fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x000000200a007388ULL, 0x0003e8000000cc00ULL, 0x0000001004007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01060400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0022a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000020f00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000387919ULL, 0x000ea20000000000ULL, 0x3d8000003d3d7820ULL, 0x020fe20000410000ULL,
0x000000100d3b7824ULL, 0x000fe200078e00ffULL, 0xffffffff023c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x00007610ff397816ULL, 0x000fe40000000039ULL,
0x000001000f3f7824ULL, 0x000fe200078e020eULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003f0000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e003aULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000103267810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x00000001243a7812ULL, 0x000fc400078e0cffULL, 0x00000002ff287819ULL, 0x000fe40000011626ULL,
0x000000042600780cULL, 0x000fc60003f06070ULL, 0x0000030028257a24ULL, 0x000fc800078e020fULL,
0x0000010025297824ULL, 0x040fe200078e020eULL, 0x0000000125277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe400078e0003ULL, 0x000000ffff037224ULL, 0x000fe200078e0026ULL,
0x000000022700720cULL, 0x000fe20003f26070ULL, 0x000062000c337a24ULL, 0x000fe200078e0229ULL,
0x0000000326277812ULL, 0x000fd600078ec0ffULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000000427377824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x004fe20000011638ULL,
0x000000020d367824ULL, 0x000fe200078e023aULL, 0x0000002900267217ULL, 0x000fe20007800000ULL,
0x00000100ff357424ULL, 0x000fe200078e00ffULL, 0x00000002ff307819ULL, 0x100fe40000011638ULL,
0x0000000327417812ULL, 0x100fe200078e4838ULL, 0x00000001262a7824ULL, 0x000fe200078e0a29ULL,
0x0000000830277810ULL, 0x040fe20007ffe0ffULL, 0x0000000130267824ULL, 0x000fe200078e0233ULL,
0xfffffffc37377812ULL, 0x000fc400078ee238ULL, 0x0000002a3000720cULL, 0x080fe20003f26070ULL,
0x0000000127287824ULL, 0x040fe200078e0233ULL, 0x0000002a2700720cULL, 0x040fe20003f46070ULL,
0x0000000427327824ULL, 0x000fe200078e00ffULL, 0x0000200036367811ULL, 0x000fe200078e60ffULL,
0x00005e0026267625ULL, 0x080fe200078e0035ULL, 0x0ffffffc412b7812ULL, 0x000fe400078ef838ULL,
0xfffffffc32317812ULL, 0x000fe200078ee241ULL, 0x00005e0028287625ULL, 0x000fe200078e0035ULL,
0x0000001030327810ULL, 0x000fc40007ffe0ffULL, 0x0000001830347810ULL, 0x040fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0236ULL, 0x00000020303e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001037267825ULL, 0x000fe200078e0026ULL, 0x0000002830407810ULL, 0x040fe40007ffe0ffULL,
0x0000003030427810ULL, 0x040fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0236ULL,
0x0000003830437810ULL, 0x000fe20007ffe0ffULL, 0x0000001037287825ULL, 0x000fe200078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000c901c46ULL,
0x0000002a3200720cULL, 0x000fc40003f26070ULL, 0x0000002a3e00720cULL, 0x080fe20003f66070ULL,
0x0000000028317faeULL, 0x0005e2000d101c46ULL, 0x0000002a3400720cULL, 0x080fe20003f46070ULL,
0x0000000432447824ULL, 0x000fe200078e00ffULL, 0x0000002a4000720cULL, 0x080fe20003f86070ULL,
0x0000000434467824ULL, 0x000fe200078e00ffULL, 0x0000002a4200720cULL, 0x080fe20003fa6070ULL,
0x0000000140307824ULL, 0x100fe200078e0233ULL, 0x0000002a4300720cULL, 0x000fe20003fc6070ULL,
0x0000000132267824ULL, 0x002fe200078e0233ULL, 0xfffffffc46457812ULL, 0x000fe200078ee241ULL,
0x000000013e2a7824ULL, 0x000fc400078e0233ULL, 0x0000000134287824ULL, 0x104fe400078e0233ULL,
0x0000000142327824ULL, 0x100fe400078e0233ULL, 0x0000000143347824ULL, 0x000fe400078e0233ULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x00005e0026267625ULL, 0x000fc600078e0035ULL,
0xfffffffc3e477812ULL, 0x000fe200078ee241ULL, 0x00005e0028287625ULL, 0x000fc800078e0035ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0035ULL, 0x00005e0030307625ULL, 0x000fc800078e0035ULL,
0x00005e0032327625ULL, 0x000fc800078e0035ULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x00005e0034347625ULL, 0x000fc600078e0035ULL, 0xfffffffc40497812ULL, 0x100fe200078ee241ULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x0000000443487824ULL, 0x000fe200078e00ffULL,
0xfffffffc44437812ULL, 0x000fe200078ee241ULL, 0x0000001037267825ULL, 0x040fe200078e0026ULL,
0xfffffffc424b7812ULL, 0x100fe400078ee241ULL, 0xfffffffc484d7812ULL, 0x000fe200078ee241ULL,
0x0000001037287825ULL, 0x000fc800078e0028ULL, 0x00000010372a7825ULL, 0x000fc800078e002aULL,
0x0000001037307825ULL, 0x000fc800078e0030ULL, 0x0000001037327825ULL, 0x000fc800078e0032ULL,
0x0000001037347825ULL, 0x000fc800078e0034ULL, 0x0000001043377824ULL, 0x100fe400078e0236ULL,
0x0000001045417824ULL, 0x100fe400078e0236ULL, 0x0000001047437824ULL, 0x100fe200078e0236ULL,
0x0000000026377faeULL, 0x0003e2000c901c46ULL, 0x0000001049457824ULL, 0x100fe400078e0236ULL,
0x000000104b477824ULL, 0x100fe200078e0236ULL, 0x0000000028417faeULL, 0x0003e2000d101c46ULL,
0x000000104d497824ULL, 0x000fc600078e0236ULL, 0x000000002a437faeULL, 0x0003e8000d901c46ULL,
0x0000000030457faeULL, 0x0003e8000e101c46ULL, 0x0000000032477faeULL, 0x0003e8000e901c46ULL,
0x0000000034497faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x000000020d287824ULL, 0x000fe200078e023aULL, 0x00000008382a7811ULL, 0x044fe200078ff0ffULL,
0x0000000427437824ULL, 0x000fe200078e00ffULL, 0x0000001038307811ULL, 0x040fe200078ff0ffULL,
0x00000100ff417424ULL, 0x000fe200078e00ffULL, 0x0000001838327811ULL, 0x000fe200078ff0ffULL,
0x000000042a447824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fe20000011638ULL,
0x0000000430467824ULL, 0x000fe200078e00ffULL, 0x0000002038347811ULL, 0x000fe200078ff0ffULL,
0x0000000432487824ULL, 0x000fe200078e00ffULL, 0x0000002838367811ULL, 0x000fc400078ff0ffULL,
0x00002000284f7811ULL, 0x000fe200078e60ffULL, 0x000000012a287824ULL, 0x100fe200078e0233ULL,
0x00000030383e7811ULL, 0x000fe200078ff0ffULL, 0x00000001302a7824ULL, 0x100fe200078e0233ULL,
0x0000003838427811ULL, 0x000fe200078ff0ffULL, 0x0000000132307824ULL, 0x100fe200078e0233ULL,
0x0000000327297812ULL, 0x100fe200078e4838ULL, 0x0000000134327824ULL, 0x100fe200078e0233ULL,
0x0000003338267211ULL, 0x000fe200078ff0ffULL, 0x00000004344a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc43437812ULL, 0x000fe200078ee238ULL, 0x0000000136347824ULL, 0x000fc400078e0233ULL,
0x00000004364c7824ULL, 0x000fe400078e00ffULL, 0x000000013e367824ULL, 0x100fe400078e0233ULL,
0x0000000142407824ULL, 0x040fe400078e0233ULL, 0x00000004424e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44427812ULL, 0x100fe200078ee229ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46447812ULL, 0x100fe200078ee229ULL, 0x00005e0026267625ULL, 0x000fe200078e0041ULL,
0xfffffffc48467812ULL, 0x000fc400078ee229ULL, 0xfffffffc4a487812ULL, 0x100fe200078ee229ULL,
0x00005e002a2a7625ULL, 0x080fe200078e0041ULL, 0xfffffffc4c4a7812ULL, 0x100fe400078ee229ULL,
0xfffffffc3e4c7812ULL, 0x100fe200078ee229ULL, 0x00005e0030307625ULL, 0x080fe200078e0041ULL,
0xfffffffc4e4e7812ULL, 0x000fe400078ee229ULL, 0x0ffffffc293e7812ULL, 0x000fe200078ef838ULL,
0x00005e0028287625ULL, 0x000fc800078e0041ULL, 0x00005e0032327625ULL, 0x000fc800078e0041ULL,
0x00005e0034347625ULL, 0x000fc800078e0041ULL, 0x00005e0036367625ULL, 0x000fc800078e0041ULL,
0x00005e0040407625ULL, 0x000fc800078e0041ULL, 0x0000001043267825ULL, 0x000fc800078e0026ULL,
0x0000001043287825ULL, 0x000fc800078e0028ULL, 0x00000010432a7825ULL, 0x000fc800078e002aULL,
0x0000001043307825ULL, 0x000fc800078e0030ULL, 0x0000001043327825ULL, 0x000fc800078e0032ULL,
0x0000001043347825ULL, 0x000fc800078e0034ULL, 0x0000001043367825ULL, 0x000fc800078e0036ULL,
0x0000001043407825ULL, 0x000fc800078e0040ULL, 0x000000103e517824ULL, 0x100fe400078e024fULL,
0x0000001042437824ULL, 0x100fe400078e024fULL, 0x0000001044457824ULL, 0x100fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026517faeULL, 0x0003e2000b901c46ULL,
0x0000001046477824ULL, 0x100fe400078e024fULL, 0x0000001048497824ULL, 0x100fe200078e024fULL,
0x0000000028437faeULL, 0x0003e2000b901c46ULL, 0x000000104a4b7824ULL, 0x000fc400078e024fULL,
0x000000104c4d7824ULL, 0x100fe200078e024fULL, 0x000000002a457faeULL, 0x0003e2000b901c46ULL,
0x000000104e4f7824ULL, 0x000fc600078e024fULL, 0x0000000030477faeULL, 0x0003e8000b901c46ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e8000b901c46ULL,
0x00000000364d7faeULL, 0x0003e8000b901c46ULL, 0x00000000404f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002038277810ULL, 0x042fe20007ffe0ffULL, 0x0000000825417824ULL, 0x000fe200078e00ffULL,
0xfffffff838257812ULL, 0x000fe200078ec0ffULL, 0x000000020d437824ULL, 0x000fe200078e0224ULL,
0xfffffff827277812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000000725407812ULL, 0x000fc400078ef838ULL, 0x0000000727447812ULL, 0x000fe400078ef838ULL,
0x0000000738297812ULL, 0x000fe400078ec0ffULL, 0x00000001ff457819ULL, 0x000fe40000011640ULL,
0x00000001ff477819ULL, 0x000fe40000011644ULL, 0x0000200043437811ULL, 0x000fe400078e60ffULL,
0x0000000829427812ULL, 0x000fc400078ef838ULL, 0x0000000345457812ULL, 0x000fe400078ec0ffULL,
0x0000000347477812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003e45257212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000004138357211ULL, 0x000fe400078fe0ffULL, 0x0000003e47317212ULL, 0x000fe200078e3cffULL,
0x0000000440247824ULL, 0x000fe200078e0225ULL, 0x0000000735257812ULL, 0x140fe400078e7842ULL,
0x000000013e467810ULL, 0x000fe20007ffe0ffULL, 0x0000001024287824ULL, 0x000fe200078e0243ULL,
0x0000000235357810ULL, 0x000fe20007ffe0ffULL, 0x0000002042257824ULL, 0x000fe200078e0225ULL,
0x000000023e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000444307824ULL, 0x000fe200078e0231ULL,
0x0000000735357812ULL, 0x000fe200078e7842ULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x000000043e00780cULL, 0x000fe20003f25270ULL,
0x0000001030307824ULL, 0x000fe200078e0243ULL, 0x0000000441417810ULL, 0x000fc60007ffe0ffULL,
0x000000002524783bULL, 0x000ea80000000200ULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x00000028ff36723eULL, 0x082fe400020006ffULL, 0x00000028ff37723eULL, 0x000fe400030006ffULL,
0x00000029ff48723eULL, 0x080fe400020006ffULL, 0x00000029ff49723eULL, 0x000fc400030006ffULL,
0x0000002aff28723eULL, 0x080fe200020006ffULL, 0x000000362404723cULL, 0x044fe20000001804ULL,
0x0000002aff29723eULL, 0x000fe400030006ffULL, 0x0000002bff2a723eULL, 0x080fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe400030006ffULL, 0x0000004645377212ULL, 0x000fe200078e3cffULL,
0x000000282410723cULL, 0x040fee0000001810ULL, 0x0000000440287824ULL, 0x000fe200078e0237ULL,
0x000000482408723cULL, 0x000fe60000001808ULL, 0x0000001028347824ULL, 0x000fc400078e0243ULL,
0x0000002042287824ULL, 0x000fe400078e0235ULL, 0x00000030ff48723eULL, 0x088fe200020006ffULL,
0x0000002a242c723cULL, 0x000fe2000000182cULL, 0x00000030ff49723eULL, 0x000fe200030006ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x00000031ff30723eULL, 0x080fe200020006ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000482414723cULL, 0x040fe40000001814ULL, 0x000000002828783bULL, 0x000eaa0000000200ULL,
0x0000004647497212ULL, 0x000fe200078e3cffULL, 0x000000302418723cULL, 0x000fe20000001818ULL,
0x00000033ff48723eULL, 0x000fcc00020006ffULL, 0x00000032ff30723eULL, 0x080fe400020006ffULL,
0x00000032ff31723eULL, 0x000fe200030006ffULL, 0x0000000444327824ULL, 0x000fe200078e0249ULL,
0x00000033ff49723eULL, 0x000fc600030006ffULL, 0x0000001032327824ULL, 0x000fe400078e0243ULL,
0x00000030241c723cULL, 0x040fe8000000181cULL, 0x000000003230783bULL, 0x000ee80000000200ULL,
0x000000482420723cULL, 0x000fee0000001820ULL, 0x00000034ff24723eULL, 0x002fc400020006ffULL,
0x00000034ff25723eULL, 0x000fe400030006ffULL, 0x00000035ff34723eULL, 0x080fe400020006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x000000242804723cULL, 0x044fee0000001804ULL,
0x00000036ff24723eULL, 0x080fe200020006ffULL, 0x000000342808723cULL, 0x000fe20000001808ULL,
0x00000036ff25723eULL, 0x000fe400030006ffULL, 0x00000037ff36723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x000000242810723cULL, 0x040fee0000001810ULL,
0x00000030ff24723eULL, 0x088fe200020006ffULL, 0x00000036282c723cULL, 0x000fe2000000182cULL,
0x00000030ff25723eULL, 0x000fe400030006ffULL, 0x00000031ff30723eULL, 0x000fc400020006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000242814723cULL, 0x040fee0000001814ULL,
0x00000032ff24723eULL, 0x080fe200020006ffULL, 0x000000302818723cULL, 0x000fe20000001818ULL,
0x00000032ff25723eULL, 0x000fe400030006ffULL, 0x00000033ff32723eULL, 0x000fc400020006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x00000024281c723cULL, 0x040ff0000000181cULL,
0x000000322820723cULL, 0x000fe20000001820ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff247224ULL, 0x000fe200078e003aULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffef0000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x010614003b247984ULL, 0x000e620000000800ULL,
0x0000ffff39037812ULL, 0x000fe200078ec0ffULL, 0x000000093d2b7220ULL, 0x040fe20000410000ULL,
0x000000073d267220ULL, 0x040fe20000410000ULL, 0x000000113d097220ULL, 0x000fe20000410000ULL,
0x0000888003337816ULL, 0x000fe200000000ffULL, 0x0000000a3d077220ULL, 0x040fe20000410000ULL,
0x000000103d287220ULL, 0x040fe20000410000ULL, 0x000000133d137220ULL, 0x040fe20000410000ULL,
0x000000173d117220ULL, 0x040fe20000410000ULL, 0x000000193d197220ULL, 0x000fe20000410000ULL,
0x8000000033037824ULL, 0x000fe200078e00ffULL, 0x000000063d257220ULL, 0x040fe20000410000ULL,
0x000000083d087220ULL, 0x040fe20000410000ULL, 0x000000123d127220ULL, 0x040fe20000410000ULL,
0x0000002f3d107220ULL, 0x040fe20000410000ULL, 0x000000143d0a7220ULL, 0x040fe20000410000ULL,
0x000000183d187220ULL, 0x040fe20000410000ULL, 0x0000001b3d177220ULL, 0x040fe20000410000ULL,
0x000000043d047220ULL, 0x040fe20000410000ULL, 0x000000053d057220ULL, 0x040fe20000410000ULL,
0x0000000b3d297220ULL, 0x040fe20000410000ULL, 0x0000002d3d067220ULL, 0x040fe20000410000ULL,
0x0000002e3d2e7220ULL, 0x040fe20000410000ULL, 0x000000153d157220ULL, 0x040fe20000410000ULL,
0x000000163d167220ULL, 0x040fe20000410000ULL, 0x0000001a3d147220ULL, 0x040fe20000410000ULL,
0x0000001e3d2a7220ULL, 0x040fe20000410000ULL, 0x0000001f3d307220ULL, 0x040fe20000410000ULL,
0x0000001c3d1b7220ULL, 0x040fe20000410000ULL, 0x000000233d327220ULL, 0x040fe20000410000ULL,
0x0000002c3d0b7220ULL, 0x040fe20000410000ULL, 0x000000ffff237224ULL, 0x000fe200078e0019ULL,
0x000000213d277220ULL, 0x040fe20000410000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0013ULL,
0x000000223d317220ULL, 0x040fe20000410000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0008ULL,
0x0000001d3d1d7220ULL, 0x040fe20000410000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0018ULL,
0x000000203d207220ULL, 0x000fe20000410000ULL, 0x8000000024ff7812ULL, 0x002fe20007804803ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0025ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0012ULL,
0x000000ffff137224ULL, 0x000fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0017ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0004ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0005ULL,
0x000000ffff217224ULL, 0x000fc400078e0006ULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff087224ULL, 0x000fe400078e0007ULL, 0x000000ffff257224ULL, 0x000fe400078e0029ULL,
0x000000ffff247224ULL, 0x000fe400078e002eULL, 0x000000ffff107224ULL, 0x000fe400078e0016ULL,
0x000000ffff127224ULL, 0x000fc400078e0014ULL, 0x000000ffff177224ULL, 0x000fe400078e002aULL,
0x000000ffff187224ULL, 0x000fe200078e0030ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe400078e0031ULL,
0x000000ffff157224ULL, 0x000fe200078e0032ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000033337824ULL, 0x000fe400078e00ffULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x010614003b047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc40007804833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000438037824ULL, 0x000fe200078e00ffULL, 0x0000003c0f00720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff003147812ULL, 0x000fca00078ec0ffULL,
0x000000800d147824ULL, 0x000fca00078e0214ULL, 0x0104000014047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000238297824ULL, 0x000fe400078e00ffULL,
0x00000001003f7824ULL, 0x000fc600078e0a3fULL, 0x00000006292a7812ULL, 0x000fc800078ec0ffULL,
0x000000012a2e7812ULL, 0x040fe400078efcffULL, 0x000000082a307812ULL, 0x000fe400078efcffULL,
0x0000003f2e00720cULL, 0x080fe40003f26070ULL, 0x000000102a2e7812ULL, 0x000fe400078efcffULL,
0x0000003f3000720cULL, 0x080fe40003f06070ULL, 0x0000003f2e00720cULL, 0x000fc40003fc6070ULL,
0x000000112a307812ULL, 0x040fe400078efcffULL, 0x000000182a2e7812ULL, 0x040fe400078efcffULL,
0x0000003f2a00720cULL, 0x080fe40003f46070ULL, 0x0000003f3000720cULL, 0x080fe40003fa6070ULL,
0x0000003f2e00720cULL, 0x000fe40003f66070ULL, 0x000000092a327812ULL, 0x000fc400078efcffULL,
0x000000192a307812ULL, 0x040fe400078efcffULL, 0x000000202a2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40004800000ULL,
0x0000003f3200720cULL, 0x080fe40003f86070ULL, 0x0000003f3000720cULL, 0x080fe40003f46070ULL,
0x0000003f2e00720cULL, 0x000fe40003f26070ULL, 0x000000212a307812ULL, 0x040fe400078efcffULL,
0x000000282a2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fc40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL, 0x0000003f3000720cULL, 0x080fe40003f06070ULL,
0x0000003f2e00720cULL, 0x000fe40003f86070ULL, 0x000000292a307812ULL, 0x000fc400078efcffULL,
0x000000302a2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40007000000ULL,
0xff7fffff28287808ULL, 0x000fe40007000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0x0000003f3000720cULL, 0x000fc40003fc6070ULL,
0x0000003f2e00720cULL, 0x000fe40003fa6070ULL, 0x000000312a307812ULL, 0x040fe400078efcffULL,
0x000000382a2e7812ULL, 0x040fe400078efcffULL, 0x000000392a2a7812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40005800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40005000000ULL,
0xff7fffff10107808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40004800000ULL,
0x0000003f3000720cULL, 0x080fe40003f66070ULL, 0x0000003f2e00720cULL, 0x000fc40003f46070ULL,
0x0000003f2a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff22227808ULL, 0x000fe40004000000ULL, 0xff7fffff12127808ULL, 0x000fe40006000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff19197808ULL, 0x000fc40007000000ULL,
0xff7fffff23237808ULL, 0x000fe40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40006800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fc40005000000ULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40004800000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002f04047209ULL, 0x004fe20007810000ULL, 0x0000001fff2e7424ULL, 0x000fe200078e00ffULL,
0x0000001e05297209ULL, 0x000fe20007810000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x0000002d04057209ULL, 0x000fe40007810000ULL, 0x0000002629297209ULL, 0x000fc40007810000ULL,
0x0000002c05047209ULL, 0x000fe40007810000ULL, 0x00000008292a7209ULL, 0x000fe40007810000ULL,
0x0000002b04057209ULL, 0x000fe40007810000ULL, 0x000000252a297209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000001a29297209ULL, 0x000fc40007810000ULL,
0x0000000904047209ULL, 0x000fe40007810000ULL, 0x0000001c29297209ULL, 0x000fe40007810000ULL,
0x0000000b04047209ULL, 0x000fe40007810000ULL, 0x00000024292a7209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x000000132a297209ULL, 0x000fc40007810000ULL,
0x0000000a05057209ULL, 0x000fe40007810000ULL, 0x0000001029047209ULL, 0x000fe40007810000ULL,
0x00000022052a7209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x0000001f2a2a7209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fc40007810000ULL,
0x000000232a2a7209ULL, 0x000fe40007810000ULL, 0x0000001904047209ULL, 0x000fe40007810000ULL,
0x0000001b2a2a7209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000001d2a297209ULL, 0x000fe40007810000ULL, 0x0000001805057209ULL, 0x000fc40007810000ULL,
0x0000002029047209ULL, 0x000fe40007810000ULL, 0x00000016052a7209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x000000152a357209ULL, 0x000fe20007810000ULL,
0x00000d927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x0000000405377209ULL, 0x008fe20007810000ULL, 0x00000dc27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0035047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f2200000e0000ULL, 0x00000004352e7209ULL, 0x00afc60007810000ULL,
0x0c201f0037047f89ULL, 0x000e6200000e0000ULL, 0x0000000506307209ULL, 0x004fc60007810000ULL,
0x0c201f002e057f89ULL, 0x000ea200000e0000ULL, 0x0000002a07297209ULL, 0x010fc60007810000ULL,
0x0c201f0030317f89ULL, 0x000ee800000e0000ULL, 0x0c201f00292a7f89ULL, 0x00092200000e0000ULL,
0x0000000437047209ULL, 0x002fe40007810000ULL, 0x000000052e057209ULL, 0x004fe40007810000ULL,
0x0000003130067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b042e7820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b053f7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001082eULL, 0x0000000b00317308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL, 0x0000002000377308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b080b7823ULL, 0x102fe2000001083fULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001083fULL, 0x0000000900077308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b22227823ULL, 0x000fe2000001082eULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001083fULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b15157823ULL, 0x000fcc000001083fULL,
0x0000002500207308ULL, 0x0002f00000000800ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11257823ULL, 0x002fce000001083fULL, 0x0000002d00307308ULL, 0x000e620000000800ULL,
0x0000000b200b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff207424ULL, 0x000fcc00078e00ffULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x0000002f3008723eULL, 0x002fce00000000ffULL, 0x0000001e00097308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e700000000800ULL, 0x0000002100327308ULL, 0x0007f00000000800ULL,
0x0000000a002d7308ULL, 0x000be20000000800ULL, 0x000000092609723eULL, 0x002fe200000000ffULL,
0x3c003c00ff217424ULL, 0x008fcc00078e00ffULL, 0x0000001b00357308ULL, 0x000fe20000000800ULL,
0x0000002c2b0a723eULL, 0x020fce00000000ffULL, 0x0000001f00337308ULL, 0x000ff00000000800ULL,
0x0000001d00367308ULL, 0x000ff00000000800ULL, 0x0000001c001b7308ULL, 0x0003f00000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x00000020081c723cULL, 0x002fee00000018ffULL,
0x0000001a001a7308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x0000001a1b11723eULL, 0x002fce00000000ffULL,
0x0000002300347308ULL, 0x0003700000000800ULL, 0x00000027002e7308ULL, 0x0009e20000000800ULL,
0x3fb8aa3b10237823ULL, 0x102fe2000001083fULL, 0x000000280710723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b19077823ULL, 0x100fe2000001083fULL, 0x000000241313723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b18287823ULL, 0x000fc6000001083fULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x3fb8aa3b12277823ULL, 0x010fe2000001083fULL, 0x000000313212723eULL, 0x000fe400000000ffULL,
0x00000033341a723eULL, 0x020fc800000000ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x00000020101c723cULL, 0x000fee000000181cULL, 0x0000002500267308ULL, 0x000ee20000000800ULL,
0x0000002d2218723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000000700247308ULL, 0x0003220000000800ULL, 0x000000232619723eULL, 0x008fce00000000ffULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0xfffffffc38077812ULL, 0x002fe400078ec0ffULL,
0x00000027241b723eULL, 0x010fca00000000ffULL, 0x0000002800287308ULL, 0x000e640000000800ULL,
0x000000201824723cULL, 0x000fec000000181cULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x0000000fff1c7424ULL, 0x000fe200078e00ffULL, 0x000000372e1e723eULL, 0x000fcc00000000ffULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x00000017281d723eULL, 0x002fe400000000ffULL,
0x000000071c2b7219ULL, 0x000fe400000006ffULL, 0x00000035361c723eULL, 0x000fe400000000ffULL,
0x000000002b2273a1ULL, 0x000e6200000e8000ULL, 0x000000002b0473c4ULL, 0x000f220000004000ULL,
0x000000292a077209ULL, 0x004fe40007810000ULL, 0x00000016151f723eULL, 0x008fce00000000ffULL,
0x000000201c24723cULL, 0x000fe20000001824ULL, 0x000000052bff7c12ULL, 0x002fda000f804022ULL,
0x0000090204008947ULL, 0x010ff2000b800000ULL, 0x001c1fff24207589ULL, 0x0002a400000e0000ULL,
0x000000002b1673a1ULL, 0x000ee200000e8000ULL, 0x000000002b0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000052bff7c12ULL, 0x008fda000f804016ULL,
0x0000090204008947ULL, 0x010fea000b800000ULL, 0x001c1fff26217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff157819ULL, 0x002fe40000011638ULL, 0x0000000c03377812ULL, 0x000fc400078ec0ffULL,
0x0000000715167812ULL, 0x040fe200078ec0ffULL, 0x0000000815277824ULL, 0x040fe200078e00ffULL,
0x00000015ff257212ULL, 0x000fe200078e33ffULL, 0x0000000815177824ULL, 0x040fe200078e00ffULL,
0x0000000338ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000815327824ULL, 0x040fe200078e00ffULL,
0x0000000815157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee216ULL,
0x0000000117267812ULL, 0x108fe200078ef616ULL, 0x0000000815277824ULL, 0x000fe200078e00ffULL,
0x0000000217287812ULL, 0x100fe200078ef616ULL, 0x0000000815487824ULL, 0x000fe200078e00ffULL,
0x00000003172a7812ULL, 0x000fc400078ef616ULL, 0x00000004172c7812ULL, 0x140fe400078ef616ULL,
0x00000005172e7812ULL, 0x140fe400078ef616ULL, 0x0000000617307812ULL, 0x000fe200078ef616ULL,
0x0000000815177824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee225ULL,
0x00000015ff257212ULL, 0x000fe400078e33ffULL, 0x0000000715167812ULL, 0x000fc400078ec0ffULL,
0x0000a0000d157811ULL, 0x000fe400078e58ffULL, 0xfffffff827347812ULL, 0x100fe400078ee216ULL,
0xfffffff848487812ULL, 0x000fe200078ee225ULL, 0x0000001024037824ULL, 0x100fe200078e0215ULL,
0x0000000117367812ULL, 0x140fe200078ef616ULL, 0x000000102a247824ULL, 0x100fe200078e0215ULL,
0x00000002173e7812ULL, 0x140fe200078ef616ULL, 0x00000010302a7824ULL, 0x000fe200078e0215ULL,
0x0000000317407812ULL, 0x100fe200078ef616ULL, 0x0000000137037824ULL, 0x000fe200078e0203ULL,
0x0000000417427812ULL, 0x140fe200078ef616ULL, 0x00000010362f7824ULL, 0x100fe200078e0215ULL,
0x0000000517447812ULL, 0x140fe200078ef616ULL, 0x000000103e307824ULL, 0x100fe200078e0215ULL,
0x0000000617467812ULL, 0x000fe200078ef616ULL, 0x0000001026167824ULL, 0x100fe200078e0215ULL,
0x0000000803007388ULL, 0x0003e20000000800ULL, 0x0000001028177824ULL, 0x000fc400078e0215ULL,
0x000000102c267824ULL, 0x100fe400078e0215ULL, 0x000000102e287824ULL, 0x100fe400078e0215ULL,
0x00000010322c7824ULL, 0x100fe400078e0215ULL, 0x00000010342e7824ULL, 0x100fe400078e0215ULL,
0x0000001040317824ULL, 0x100fe400078e0215ULL, 0x0000001042327824ULL, 0x000fc400078e0215ULL,
0x0000001044337824ULL, 0x100fe400078e0215ULL, 0x0000001046347824ULL, 0x100fe400078e0215ULL,
0x0000001048357824ULL, 0x000fe400078e0215ULL, 0x0000000137157824ULL, 0x040fe400078e0216ULL,
0x0000000137177824ULL, 0x040fe400078e0217ULL, 0x0000000137257824ULL, 0x040fe200078e0224ULL,
0x0000000a15007388ULL, 0x0007e20000000800ULL, 0x0000000137277824ULL, 0x000fc400078e0226ULL,
0x0000000137297824ULL, 0x040fe200078e0228ULL, 0x0000001017007388ULL, 0x0007e20000000800ULL,
0x00000001372b7824ULL, 0x040fe400078e022aULL, 0x00000001372d7824ULL, 0x040fe200078e022cULL,
0x0000001225007388ULL, 0x0007e20000000800ULL, 0x00000001372e7824ULL, 0x040fe400078e022eULL,
0x0000000137167824ULL, 0x040fe200078e022fULL, 0x0000001827007388ULL, 0x0007e20000000800ULL,
0x0000000137307824ULL, 0x000fc400078e0230ULL, 0x0000000137087824ULL, 0x042fe200078e0231ULL,
0x0000001a29007388ULL, 0x0007e20000000800ULL, 0x0000000137327824ULL, 0x040fe400078e0232ULL,
0x0000000137247824ULL, 0x040fe200078e0233ULL, 0x0000001c2b007388ULL, 0x0007e20000000800ULL,
0x0000000137347824ULL, 0x040fe400078e0234ULL, 0x0000000137267824ULL, 0x000fe200078e0235ULL,
0x0000001e2d007388ULL, 0x0007e80000000800ULL, 0x000000092e007388ULL, 0x0007e80000000800ULL,
0x0000000b16007388ULL, 0x0007e80000000800ULL, 0x0000001130007388ULL, 0x0007e80000000800ULL,
0x0000001308007388ULL, 0x0007e80000000800ULL, 0x0000001932007388ULL, 0x0007e80000000800ULL,
0x0000001b24007388ULL, 0x0007e80000000800ULL, 0x0000001d34007388ULL, 0x0007e80000000800ULL,
0x0000001f26007388ULL, 0x0007e80000000800ULL, 0x0100000414008388ULL, 0x0007e80000000c00ULL,
0x0102002014008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003000f0f7a10ULL, 0x000fe20007ffe0ffULL, 0x010608003bff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff39ff7812ULL, 0x000fc4000780c0ffULL, 0x000000020f00720cULL, 0x000fe40003f26070ULL,
0x00000001ff397807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffd4d000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0005ULL, 0x0000f42000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002aULL, 0xfffff22000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0035ULL, 0x0000f48000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x002fe400078e00ffULL, 0x000004e000007944ULL, 0x004fea0003c00000ULL,
0x0000002a35057209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0006ULL,
0x0000f4d000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x002fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002a06357209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0007ULL, 0x0000f52000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x002fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000002a07297209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0037ULL,
0x0000f57000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000002a37047209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0005ULL, 0x0000f5c000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000002a05057209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0035ULL,
0x0000f61000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000002a35067209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0029ULL, 0x0000f66000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0xfffff0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000f6b000167802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fc400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xfffff6b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x002fe200078e0026ULL,
0x0000f72000167802ULL, 0x000fe20000000f00ULL, 0x000000ffff157224ULL, 0x000fc400078e00ffULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x0000028000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff157224ULL, 0x002fe200078e00ffULL, 0x0000f77000167802ULL, 0x000fe20000000f00ULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x002fe200078e00ffULL,
0x0000f7c000167802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0xfffff63000007947ULL, 0x000fea000383ffffULL, 0x018000002d027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000002d00028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff2dff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000002d037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002d00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e000aULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xffff06a002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003f00007348ULL, 0x000fe80003800000ULL,
0x0c0000332a2a7389ULL, 0x0002a200000e002eULL, 0xffff066030007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff177424ULL, 0x000fe200078e00ffULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x0000001524237389ULL, 0x0002a200000e0025ULL, 0xffff062016007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000210ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007a8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001128ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001138ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001158ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011c8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011d0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011e0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001400ULL, 0x000000000000fa80ULL, 0x6900001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010e80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000010e90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010e90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011310ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000011c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000fcb8ULL, 0x000000000000fcb8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000010e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011310ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin_len = 70640;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
