/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014490ULL, 0x0000000000014010ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000012760ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000128d0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000012910ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000012950ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012a80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001276000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0048940400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a10828808081ULL,
0xa608288080a40828ULL, 0x288080a808288080ULL, 0x80ac08288080aa08ULL, 0x08288080ad082880ULL,
0x8080b208288080afULL, 0xb508288080b30828ULL, 0x288080bc08288080ULL, 0x808408288080f108ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080849200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001276000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8e082880808b0828ULL, 0x288080a108288080ULL,
0x80a608288080a408ULL, 0x08288080a8082880ULL, 0x8080ac08288080aaULL, 0xaf08288080ad0828ULL,
0x288080b208288080ULL, 0x80bc08288080b508ULL, 0x08288080f1082880ULL, 0x8082801628808088ULL,
0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000012000000000ULL, 0x000128d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8b08288080880828ULL, 0x2880808e08288080ULL,
0x80a408288080a108ULL, 0x08288080a6082880ULL, 0x8080aa08288080a8ULL, 0xaf08288080ad0828ULL,
0x288080b208288080ULL, 0x80bc08288080b508ULL, 0x08288080f1082880ULL, 0x80828016288080acULL,
0x0000000000031028ULL, 0x288080ac92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000001e000000000ULL, 0x0001291000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8b08288080880828ULL, 0x2880808e08288080ULL,
0x80a408288080a108ULL, 0x08288080a6082880ULL, 0x8080ac08288080aaULL, 0xaf08288080ad0828ULL,
0x288080b208288080ULL, 0x80bc08288080b508ULL, 0x08288080f1082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000002a000000000ULL, 0x0001295000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL,
0x80a4288080a80900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL, 0x00081204000000a4ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL,
0x00010db000000020ULL, 0x0001112000011110ULL, 0x000112a000011290ULL, 0x01602904000112b0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001d0500001dULL, 0x0500001d0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000010001602804ULL, 0x00001ab000000120ULL, 0x00001bf000001b30ULL, 0x00001ff000001c20ULL,
0x0000208000002020ULL, 0x00003bf0000020e0ULL, 0x00003d5000003c80ULL, 0x0000419000003e70ULL,
0x00004210000041b0ULL, 0x00005ae000004270ULL, 0x00005c4000005b70ULL, 0x0000607000005d60ULL,
0x000060f000006090ULL, 0x0000799000006150ULL, 0x00007af000007a20ULL, 0x00007f3000007c10ULL,
0x00007fb000007f50ULL, 0x000091f000008010ULL, 0x0000b86000009200ULL, 0x0000c0400000ba70ULL,
0x00010b500000c070ULL, 0x00010b9000010b80ULL, 0x00010bc000010ba0ULL, 0x00010c0000010be0ULL,
0x0001128000010c10ULL, 0x000112f0000112e0ULL, 0x00011a1000011300ULL, 0x00011ad000011a60ULL,
0x00011bb000011b40ULL, 0x00011c7000011c20ULL, 0x00011d2000011cc0ULL, 0x00011df000011d90ULL,
0x00011eb000011e60ULL, 0x00011f6000011f00ULL, 0x0001203000011fd0ULL, 0x000120f0000120a0ULL,
0x000121a000012140ULL, 0x0001227000012210ULL, 0x00012340000122e0ULL, 0x000123f0000123a0ULL,
0x0001249000012440ULL, 0x00012530000124e0ULL, 0x000125f000012580ULL, 0x000126d000012670ULL,
0x04c0390400012730ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL, 0x0000000b00000290ULL,
0x003f01200000f608ULL, 0x0000000b000002d0ULL, 0x003f01200000f688ULL, 0x0000000b00000360ULL,
0x003f01200000f6a8ULL, 0x0000000b000003a0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL,
0x003f01070000f600ULL, 0x0000003400000630ULL, 0x003f01020000f68cULL, 0x0000003400000750ULL,
0x003f01010000f688ULL, 0x000000ff00000d60ULL, 0x0004010700000000ULL, 0x000000ff00000e20ULL,
0x0004010100000000ULL, 0x0000003e00000e80ULL, 0x003f010100000020ULL, 0x0000005f00000fc0ULL,
0x003f010500000004ULL, 0x0000003e00001030ULL, 0x003f010500000024ULL, 0x0000003e000010b0ULL,
0x003f010500000024ULL, 0x0000002d000017a0ULL, 0x003f010700000000ULL, 0x0000002d00001870ULL,
0x003f010100000000ULL, 0x0000002f00001880ULL, 0x003f010500000004ULL, 0x00000043000018f0ULL,
0x003f01010000f608ULL, 0x0000004300001910ULL, 0x003f01050000f60cULL, 0x00000027000019c0ULL,
0x003f01050000f60cULL, 0x0000002f00001ee0ULL, 0x003f010500000004ULL, 0x0000002f00001f60ULL,
0x003f010500000004ULL, 0x0000003e000031b0ULL, 0x003f010100000020ULL, 0x0000005e00003230ULL,
0x003f01010000f688ULL, 0x0000005f00003280ULL, 0x003f010500000004ULL, 0x0000003e000032d0ULL,
0x003f010500000024ULL, 0x0000003e00003350ULL, 0x003f010500000024ULL, 0x0000006100003920ULL,
0x003f010700000000ULL, 0x00000061000039a0ULL, 0x003f010100000000ULL, 0x00000060000039b0ULL,
0x003f010500000004ULL, 0x0000004300003a20ULL, 0x003f01010000f628ULL, 0x0000004300003a40ULL,
0x003f01050000f62cULL, 0x0000004300003b20ULL, 0x003f01050000f62cULL, 0x0000002400004060ULL,
0x003f01050000f6acULL, 0x00000024000040e0ULL, 0x003f01050000f6acULL, 0x0000003e000051f0ULL,
0x003f010100000020ULL, 0x0000005e00005260ULL, 0x003f01010000f690ULL, 0x0000005f000052a0ULL,
0x003f010500000004ULL, 0x0000003e000052f0ULL, 0x003f010500000024ULL, 0x0000003e00005370ULL,
0x003f010500000024ULL, 0x0000006000005820ULL, 0x003f010700000000ULL, 0x00000060000058a0ULL,
0x003f010100000000ULL, 0x00000061000058b0ULL, 0x003f010500000004ULL, 0x0000004300005920ULL,
0x003f01010000f648ULL, 0x0000004300005940ULL, 0x003f01050000f64cULL, 0x0000004300005a10ULL,
0x003f01050000f64cULL, 0x0000000000005f40ULL, 0x003f01050000f6acULL, 0x0000006100005fc0ULL,
0x003f010500000004ULL, 0x0000003e00007080ULL, 0x003f010100000020ULL, 0x0000005e000070f0ULL,
0x003f01010000f698ULL, 0x0000005f00007140ULL, 0x003f010500000004ULL, 0x0000003e00007190ULL,
0x003f010500000024ULL, 0x0000003e00007210ULL, 0x003f010500000024ULL, 0x0000006100007710ULL,
0x003f010700000000ULL, 0x0000006100007790ULL, 0x003f010100000000ULL, 0x00000060000077a0ULL,
0x003f010500000004ULL, 0x0000004300007810ULL, 0x003f01010000f668ULL, 0x0000004300007830ULL,
0x003f01050000f66cULL, 0x00000043000078c0ULL, 0x003f01050000f66cULL, 0x0000002500007e00ULL,
0x003f01050000f6acULL, 0x0000006000007e80ULL, 0x003f010500000004ULL, 0x0000003e00008e90ULL,
0x003f010100000020ULL, 0x0000005e00008ef0ULL, 0x003f01010000f6a0ULL, 0x000000ff0000cda0ULL,
0x003f01010000f600ULL, 0x000000ff0000dba0ULL, 0x003f01050000f604ULL, 0x000000ff0000dc40ULL,
0x003f01050000f604ULL, 0x000000ff0000de50ULL, 0x003f01010000f600ULL, 0x000000ff0000de60ULL,
0x003f01050000f604ULL, 0x000000ff0000def0ULL, 0x003f01050000f604ULL, 0x0000002e00010050ULL,
0x003f010100000000ULL, 0x0000002e00010090ULL, 0x003f010500000004ULL, 0x0000002e00010450ULL,
0x003f010500000004ULL, 0x0000002f00011870ULL, 0x003f010100000000ULL, 0x0000002f000118d0ULL,
0x003f010100000008ULL, 0x0000002f00011930ULL, 0x003f010100000010ULL, 0x0000002f000119a0ULL,
0x003f010100000018ULL, 0x00141c0400053803ULL, 0x0000ccb00000ca60ULL, 0x0000e0000000df50ULL,
0x00000401000119e0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000034cULL, 0x0000001200000002ULL,
0x000000000000028cULL, 0x0000001200000002ULL, 0x00000000000001ccULL, 0x0000001200000002ULL,
0x000000000000010cULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000323ULL, 0x0000001200000002ULL, 0x0000000000000263ULL, 0x0000001200000002ULL,
0x00000000000001a3ULL, 0x0000001200000002ULL, 0x00000000000000e9ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff267624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000e00047300ULL, 0x000ee200000e0000ULL, 0x0000000826067824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff157424ULL, 0x000fc600078e00ffULL,
0x0000000000397919ULL, 0x000f220000002600ULL, 0x0000000e000e7309ULL, 0x000f660000000000ULL,
0x0000000000277919ULL, 0x000ee80000002700ULL, 0x0000000000337919ULL, 0x000f620000000000ULL,
0x00000005ff327819ULL, 0x002fc6000001160bULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x00001fff32327589ULL, 0x000fe200000e0000ULL, 0x000000010d007824ULL, 0x004fc600078e0200ULL,
0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe400078e020bULL,
0x0000000839007824ULL, 0x010fc600078e00ffULL, 0x000000ff0b00720cULL, 0x040fe20003f45270ULL,
0x0000002706007224ULL, 0x008fe200078e0200ULL, 0x0000000f0b00780cULL, 0x000fe20003f64070ULL,
0x00000010330a7824ULL, 0x020fe200078e00ffULL, 0x000000030b00780cULL, 0x040fe40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x00000004ff0f7819ULL, 0x000fe40000011633ULL,
0x000000050400720cULL, 0x002fc40003f02070ULL, 0x000000f00a137812ULL, 0x000fe200078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040d067824ULL, 0x004fe400078e0232ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fe400078e00ffULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000100027824ULL, 0x002fe400078e0211ULL,
0x0000000109007824ULL, 0x000fe200078e0a08ULL, 0x00f688060b009388ULL, 0x000fe20000008a00ULL,
0xff317217ff0cc424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL,
0x000000000f00720cULL, 0x000fe20003f66070ULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f4000c0b00c388ULL, 0x0003e20000004800ULL, 0x3fffff80ff049424ULL, 0x004fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0015ULL,
0x00f6a8040b009388ULL, 0x0005e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a0eULL,
0x00000007110c7812ULL, 0x002fe200078ec0ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000f0c0c7812ULL, 0x000fe400078e7833ULL, 0x0000001302027210ULL, 0x000fe20007f9e0ffULL,
0x0000620027047625ULL, 0x004fc800078e000fULL, 0x00000010110c7824ULL, 0x000fe400078e020cULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100c077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604307981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff317e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f30037810ULL, 0x006fc40007ffe0ffULL, 0x000000ff30027810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000c75000008947ULL, 0x000fea0003800000ULL, 0x00000002ff357819ULL, 0x000fe20000011632ULL,
0x0000000832347824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x03ffffff35007812ULL, 0x000fca00078ec0ffULL, 0x0000000431097824ULL, 0x000fca00078e0200ULL,
0x000000030900720cULL, 0x000fda0003f06070ULL, 0x0000000227008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000048624ULL, 0x000fe400078e0205ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000109048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0734ff738cULL, 0x0003e20000000000ULL,
0x0000600004048625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604008981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff367424ULL, 0x000fe200078e00ffULL,
0x0000000309067812ULL, 0x000fe200078ec0ffULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x0000000132387812ULL, 0x000fe200078ec0ffULL, 0x000003000f367a24ULL, 0x000fe200078e0a36ULL,
0x000000030600780cULL, 0x000fc40003f05270ULL, 0x00000003ff087819ULL, 0x000fe40000011633ULL,
0x00000001ff457819ULL, 0x000fe20000011632ULL, 0x0000004039397824ULL, 0x000fe200078e00ffULL,
0x0000000136427807ULL, 0x000fe20004000000ULL, 0x00f6880034ff7f8cULL, 0x0009e8000c80043fULL,
0x0000000109427824ULL, 0x000fca00078e0242ULL, 0x000000034200720cULL, 0x000fe40003f06070ULL,
0x00000004080d7810ULL, 0x000fd60007ffe0ffULL, 0x0000000227068824ULL, 0x000fe400078e00ffULL,
0x00006400ff078624ULL, 0x002fc800078e00ffULL, 0x0000640006078624ULL, 0x000fe400078e0207ULL,
0x0000001038067824ULL, 0x000fe400078e00ffULL, 0x0000000107048824ULL, 0x004fe400078e0242ULL,
0x00000001060e7824ULL, 0x000fe400078e020dULL, 0x0000600004048625ULL, 0x000fc800078e000fULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x0000000604378981ULL, 0x000362000c1e1900ULL,
0x00000020453a7824ULL, 0x000fe200078e00ffULL, 0x0000000131077810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0208ULL, 0x0000000808107810ULL, 0x000fe20007ffe0ffULL,
0x00002000453b7824ULL, 0x000fe200078e00ffULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x00000033090b7212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x000fe200078e0210ULL, 0x000000330e047212ULL, 0x082fe200078e3cffULL,
0x00000000450473c2ULL, 0x000e6200000e0000ULL, 0x0000000c08147810ULL, 0x000fe20007ffe0ffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee204ULL,
0x0000010031047824ULL, 0x000fe200078e023aULL, 0x0000003311127212ULL, 0x080fe200078e3cffULL,
0x0000000106157824ULL, 0x000fe200078e0214ULL, 0xfffffff80c0b7812ULL, 0x000fe200078ee20bULL,
0xff317217ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000430057217ULL, 0x000fe20007800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x0000003315167212ULL, 0x000fc400078e3cffULL,
0x0000b0003b0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x100fe200078e0a04ULL,
0x0000002039047812ULL, 0x000fe400078ef804ULL, 0x0000f6a8453e7811ULL, 0x000fe200078e18ffULL,
0x000000100b0b7824ULL, 0x000fe200078e020cULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000000104097824ULL, 0x040fe400078e0209ULL, 0x0000000104077824ULL, 0x040fe200078e020eULL,
0x0000000605057217ULL, 0x000fe20007800000ULL, 0x0000000104137824ULL, 0x000fe200078e0211ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x0000000815117824ULL, 0x000fc400078e00ffULL,
0x0000000105057824ULL, 0x000fe400078e0a06ULL, 0x0000000104177824ULL, 0x000fe200078e0215ULL,
0xfffffff819157812ULL, 0x000fe400078ee212ULL, 0x000000051000720cULL, 0x080fe40003f06070ULL,
0xfffffff811197812ULL, 0x000fe200078ee216ULL, 0x000000100f117824ULL, 0x100fe200078e020cULL,
0x000000050d00720cULL, 0x080fe20003f26070ULL, 0x0000001015157824ULL, 0x100fe200078e020cULL,
0x000000050800720cULL, 0x000fe20003f46070ULL, 0x0000001019197824ULL, 0x000fe200078e020cULL,
0x000000700a0f7812ULL, 0x000fe200078ec0ffULL, 0x0000580000007a24ULL, 0x008fc800078e02ffULL,
0x0000004000007824ULL, 0x000fca00078e00ffULL, 0x0000000900097210ULL, 0x040fe40007f7e0ffULL,
0x0000000700077210ULL, 0x040fe40007f9e0ffULL, 0x0000001300137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e0009107a11ULL, 0x000fc600078638ffULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x00005f00090d7a11ULL, 0x000fe200018f3c04ULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e0007087a11ULL, 0x000fe400078638ffULL,
0x0000001700007210ULL, 0x000fe40007fbe0ffULL, 0x00005e00130c7a11ULL, 0x000fe400078838ffULL,
0x00005f0007097a11ULL, 0x000fe200018f3c04ULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x00005f0013067a11ULL, 0x000fc400020f3c06ULL, 0x000000100f047210ULL, 0x000fe20007fbe0ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000f08087210ULL, 0x000fe40007f9e0ffULL,
0x00005e00000e7a11ULL, 0x000fe400078c38ffULL, 0x000000051400720cULL, 0x000fe20003f66070ULL,
0x000000ffff057224ULL, 0x000fe200028e060dULL, 0x0000000f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00005f0000007a11ULL, 0x000fc400030f3c07ULL,
0x0000000f0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0606ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000d101c46ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0600ULL,
0x0000000008117faeULL, 0x0005e8000c901c46ULL, 0x000000000c157faeULL, 0x0007e2000c101c46ULL,
0x000000023100720cULL, 0x000fc60003f06070ULL, 0x000000000e197faeULL, 0x0009e2000d901c46ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fc4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff687f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003e247f8cULL, 0x0004e2000c80043fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000203e5f7810ULL, 0x000fe20007ffe0ffULL,
0x0000802000000947ULL, 0x000fea0003800000ULL, 0x00000002273f7824ULL, 0x004fe400078e00ffULL,
0x00006400ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff3c7424ULL, 0x000fe400078e00ffULL,
0x000064003f3f7624ULL, 0x000fe400078e0200ULL, 0x000000ffff567224ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x0000010031277824ULL, 0x000fca00078e00ffULL,
0x000000302700720cULL, 0x000fda0003f06070ULL, 0x00007f5000000947ULL, 0x006fea0003800000ULL,
0x000004005f007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff577224ULL, 0x000fe400078e0042ULL, 0x000000ffff407224ULL, 0x000fe200078e0056ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000342007812ULL, 0x000fe200078ec0ffULL, 0x0000580037267a24ULL, 0x020fe200078e02ffULL,
0x00000003ff287819ULL, 0x000fe20000011633ULL, 0x0000010031527824ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fe20003f05270ULL, 0xffffffffff377424ULL, 0x000fc600078e00ffULL,
0x0000000136257807ULL, 0x000fe20004000000ULL, 0x0000001032007824ULL, 0x000fc800078e00ffULL,
0x0000000142427824ULL, 0x000fe200078e0225ULL, 0x0000001000297812ULL, 0x000fc800078ec0ffULL,
0x000000034200720cULL, 0x000fe20003f06070ULL, 0x0000000128447824ULL, 0x000fe200078e0229ULL,
0x00000001ff457819ULL, 0x000fc60000011632ULL, 0x0000000844007824ULL, 0x040fe200078e00ffULL,
0x0000003344477212ULL, 0x000fe400078e3cffULL, 0x0000000428507810ULL, 0x000fe40007ffe0ffULL,
0xfffffff800477812ULL, 0x000fe200078ee247ULL, 0x0000002045007824ULL, 0x000fe400078e0252ULL,
0x000000013f248824ULL, 0x000fe400078e0242ULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x0000000150467824ULL, 0x000fc400078e0229ULL,
0x0000600024248625ULL, 0x000fc600078e0025ULL, 0x0000003346497212ULL, 0x080fe400078e3cffULL,
0x0000000624378981ULL, 0x000562000c1e1900ULL, 0x0000000c28587810ULL, 0x000fe20007ffe0ffULL,
0x0000004026267824ULL, 0x000fe200078e00ffULL, 0x0000000131277810ULL, 0x000fe20007ffe0ffULL,
0x00000010334d7824ULL, 0x000fe200078e00ffULL, 0x0000000828547810ULL, 0x000fe20007ffe0ffULL,
0x00000001584a7824ULL, 0x100fe200078e0229ULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x0000053000007945ULL, 0x000fe20003800000ULL, 0x000000704d4e7812ULL, 0x000fe200078ec0ffULL,
0x0000000846247824ULL, 0x004fe200078e00ffULL, 0x0000000030257217ULL, 0x000fe20007800000ULL,
0x000000084a2b7824ULL, 0x040fe200078e00ffULL, 0x000000334a4c7212ULL, 0x000fe200078e3cffULL,
0x0000000154487824ULL, 0x000fe200078e0229ULL, 0xfffffff824497812ULL, 0x000fe200078ee249ULL,
0x0000000125247824ULL, 0x100fe200078e0a00ULL, 0x0000002039257812ULL, 0x000fe200078ef800ULL,
0x00000008482a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b4c7812ULL, 0x000fc400078ee24cULL,
0x0000002024247807ULL, 0x000fe20000000000ULL, 0x0000000125277824ULL, 0x040fe200078e0244ULL,
0x00000033484b7212ULL, 0x000fe200078e3cffULL, 0x00000001252b7824ULL, 0x040fe200078e0246ULL,
0x0000002924247217ULL, 0x000fe20007800000ULL, 0x00000001252d7824ULL, 0x040fe200078e0248ULL,
0x0000002726277210ULL, 0x040fe20007f5e0ffULL, 0x0000000125257824ULL, 0x000fe200078e024aULL,
0x0000002b262b7210ULL, 0x000fe20007f7e0ffULL, 0x0000000124297824ULL, 0x000fe200078e0a29ULL,
0x0000002d262d7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005e00272f7a11ULL, 0x040fe200078438ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x0000002526257210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x00005f0027437a11ULL, 0x000fe200010f3c00ULL, 0x0000100056007824ULL, 0x000fe200078e00ffULL,
0x00005e002b277a11ULL, 0x000fe200078438ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0xfffffff82a4b7812ULL, 0x000fc400078ee24bULL, 0x0000100000007812ULL, 0x000fe400078e0cffULL,
0x00005f002b2c7a11ULL, 0x000fe400010f3c2cULL, 0x000000292800720cULL, 0x000fe20003f46070ULL,
0x0000200045007824ULL, 0x000fe200078e0200ULL, 0x00005e002d287a11ULL, 0x000fe400078638ffULL,
0x00005e00252a7a11ULL, 0x000fe400078038ffULL, 0x00005f002d2e7a11ULL, 0x000fc400018f3c2eULL,
0x0000004e2f247210ULL, 0x080fe20007f7e0ffULL, 0x00000008562f7824ULL, 0x000fe200078e00ffULL,
0x0000b00000007810ULL, 0x000fe40007ffe0ffULL, 0x00005f00252b7a11ULL, 0x000fe200000f3c26ULL,
0x000000ffff257224ULL, 0x000fe200018e0643ULL, 0x0000004e27267210ULL, 0x080fe20007fbe0ffULL,
0x00000010475a7824ULL, 0x100fe200078e0200ULL, 0x000000295000720cULL, 0x080fe20003f06070ULL,
0x00000010495b7824ULL, 0x000fe200078e0200ULL, 0x0000004e28287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245a7faeULL, 0x0005e2000d101c46ULL, 0x000000295400720cULL, 0x080fe20003f46070ULL,
0x000000104b5c7824ULL, 0x100fe200078e0200ULL, 0x000000295800720cULL, 0x000fe20003fa6070ULL,
0x000000104c5d7824ULL, 0x000fe200078e0200ULL, 0xfffffff034297812ULL, 0x000fc400078ec0ffULL,
0x0000004e2a2a7210ULL, 0x000fe40007f9e0ffULL, 0x0000f6a8292c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200018e062eULL, 0x000000082f2d7812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x00000000265b7faeULL, 0x0007e2000c101c46ULL,
0xffffffe034437812ULL, 0x000fe400078ec0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e022dULL,
0x00000000285c7faeULL, 0x0007e2000d101c46ULL, 0x0000001034007812ULL, 0x000fc400078ec0ffULL,
0x0000000834247812ULL, 0x004fe200078ec0ffULL, 0x000000002a5d7faeULL, 0x0007e2000e901c46ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000004324437210ULL, 0x000fe20007ffe000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000002d0403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000012c2f7824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d547f8cULL, 0x000528000c80043fULL,
0x000004002f267984ULL, 0x0084e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080043247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x00afc60007844869ULL, 0x00f60c0043277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x0000002035277824ULL, 0x000fe400078e0200ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x0000000838277824ULL, 0x000fe400078e0227ULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe20003800000ULL,
0x00f60c0027297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff4e7819ULL, 0x000fe20000011633ULL,
0xffffffffff4f7424ULL, 0x000fe200078e00ffULL, 0x000000704d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4e4e7812ULL, 0x000fc600078ec0ffULL, 0x0000008035257824ULL, 0x000fc800078e024dULL,
0x0000000125257824ULL, 0x000fca00078e024eULL, 0x00f0000025277984ULL, 0x000e680000000800ULL,
0x00f2000025007984ULL, 0x0006a20000000800ULL, 0x0000003c2700720bULL, 0x002fe20003f1d000ULL,
0x0000ff427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x008fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6d7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000323500720cULL, 0x000fe40003f65270ULL, 0x0000003c2700720bULL, 0x000fe20003f14000ULL,
0x0000ff127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000803225b824ULL, 0x000fe200078e024dULL, 0x000000273c287209ULL, 0x000fe40007810000ULL,
0x0000ffff24247812ULL, 0x000fe200078e3cffULL, 0x000000014e25b824ULL, 0x000fe400078e0225ULL,
0x800000283c267221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc4000780c0ffULL,
0x00f400282500b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL,
0x00000002ff247819ULL, 0x000fc60000011633ULL, 0x0000002600707308ULL, 0x0002e20000000800ULL,
0x0000fea27f007947ULL, 0x000fea000b800000ULL, 0x00001f2470257589ULL, 0x00a2e400000e0000ULL,
0x0000000824247810ULL, 0x002fe20007ffe0ffULL, 0x0000fee27f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x00032400000e0000ULL, 0x8000002827270221ULL, 0x100fe20000010000ULL,
0x000000703d3d7220ULL, 0x000fe20000410000ULL, 0x0000002407077220ULL, 0x090fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002700410308ULL, 0x000f220000000800ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x000fe20000410000ULL, 0x00000001ff6d7807ULL, 0x000fe20000000000ULL,
0x0000002505057220ULL, 0x088fe20000410000ULL, 0x0000002504047220ULL, 0x080fe20000410000ULL,
0x0000002509097220ULL, 0x080fe20000410000ULL, 0x0000002508087220ULL, 0x080fe20000410000ULL,
0x000000250d0d7220ULL, 0x080fe20000410000ULL, 0x000000250c0c7220ULL, 0x080fe20000410000ULL,
0x0000002511117220ULL, 0x080fe20000410000ULL, 0x0000002510107220ULL, 0x080fe20000410000ULL,
0x0000002515157220ULL, 0x080fe20000410000ULL, 0x0000002514147220ULL, 0x080fe20000410000ULL,
0x0000002519197220ULL, 0x080fe20000410000ULL, 0x0000002518187220ULL, 0x080fe20000410000ULL,
0x000000251d1d7220ULL, 0x080fe20000410000ULL, 0x000000251c1c7220ULL, 0x080fe20000410000ULL,
0x0000002521217220ULL, 0x080fe20000410000ULL, 0x0000002520207220ULL, 0x000fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0028ULL, 0x0000004100000220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003d003d7221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x000004002f007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x000004002f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000041ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff257819ULL, 0x000fc40000011633ULL, 0x0000541000707816ULL, 0x002fe20000000000ULL,
0x0000fb827f007947ULL, 0x000fea000b800000ULL, 0x00001f2570617589ULL, 0x0002a400000e0000ULL,
0x0000000825507810ULL, 0x000fe20007ffe0ffULL, 0x0000fbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f5070007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001025717810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff727424ULL, 0x000fe200078e00ffULL,
0x00002090002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0001088000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001825717810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff727424ULL, 0x000fe200078e00ffULL,
0x000020f0002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0001082000007944ULL, 0x03cfea0003c00000ULL, 0x00000002325e7824ULL, 0x000fe200078e00ffULL,
0x0000000733687812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000045e247812ULL, 0x000fc400078ec0ffULL, 0x0000000868687812ULL, 0x000fe400078ef833ULL,
0x0000002433817211ULL, 0x040fe400078fe0ffULL, 0x0000000833247812ULL, 0x000fe400078ec0ffULL,
0x0000000781257812ULL, 0x002fca00078e7868ULL, 0x0000000868257824ULL, 0x000fc800078e0225ULL,
0x0000001025667824ULL, 0x000fc800078e00ffULL, 0x0000080035877824ULL, 0x000fe400078e0266ULL,
0x0000000432257824ULL, 0x000fe200078e00ffULL, 0x00000007242d7812ULL, 0x100fe200078ec833ULL,
0x0000100032277824ULL, 0x000fe200078e00ffULL, 0x0000000724517812ULL, 0x000fe200078ef833ULL,
0x0000100056297824ULL, 0x040fe200078e023bULL, 0x0000000425267812ULL, 0x000fe400078ec0ffULL,
0xffffe00027277812ULL, 0x000fe400078ec0ffULL, 0x00000026332c7211ULL, 0x000fe400078fe0ffULL,
0x0000008051737811ULL, 0x000fe200078e18ffULL, 0x0000100056277824ULL, 0x000fe200078e0227ULL,
0x0000002c2d287212ULL, 0x000fc400078e3cffULL, 0x0000b00029707810ULL, 0x008fe40007ffe0ffULL,
0x0000b000272e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000851537824ULL, 0x000fe200078e0228ULL,
0x000000022c2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000128597824ULL, 0x000fe200078e0273ULL,
0x0000000281817810ULL, 0x000fe20007ffe0ffULL, 0x0000001053247824ULL, 0x000fe200078e022eULL,
0x0000002c2d587212ULL, 0x000fe200078e3cffULL, 0x0000001059287824ULL, 0x000fe200078e0270ULL,
0x0000000781817812ULL, 0x000fc600078e7868ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x0000000851517824ULL, 0x000fe400078e0258ULL, 0x0000000158587824ULL, 0x000fe200078e0273ULL,
0x000000002828783bULL, 0x000ee20000004200ULL, 0x00000010512e7824ULL, 0x000fe400078e022eULL,
0x0000000868687824ULL, 0x000fc800078e0281ULL, 0x0000001068687824ULL, 0x000fe400078e00ffULL,
0x00000100242f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011424ULL,
0x00000100252c7824ULL, 0x000fe200078e00ffULL, 0x0000888024867816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe2000001142fULL,
0x000001002a767824ULL, 0x008fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001142cULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000002e2c783bULL, 0x000e620000004200ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff607819ULL, 0x000fe40000011428ULL,
0x00000018ff6e7819ULL, 0x004fe40000011425ULL, 0x0000006900897306ULL, 0x0005e20000200c00ULL,
0x00008880256a7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011476ULL, 0x00000018ff657819ULL, 0x000fe40000011426ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x00000024008b7306ULL, 0x0007220000200c00ULL,
0x0000010026697824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc40000011427ULL,
0x00000018ff647819ULL, 0x000fe40000011429ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000006b008d7306ULL, 0x0005e20000200c00ULL, 0x0000010027247824ULL, 0x008fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe4000001142aULL, 0x00000018ff637819ULL, 0x000fe4000001142bULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000006900837306ULL, 0x0007e20000200c00ULL,
0x0000888026807816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888027857816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00008880296b7816ULL, 0x004fe400000000ffULL, 0x000088802a727816ULL, 0x000fe200000000ffULL,
0x0000002400887306ULL, 0x0005e20000200c00ULL, 0x0000888028697816ULL, 0x008fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000088802b767816ULL, 0x000fe200000000ffULL,
0x000001002e947824ULL, 0x002fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x00000025008f7306ULL, 0x0003e20000200c00ULL,
0x0000010028247824ULL, 0x044fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe4000001142cULL,
0x000088802c8c7816ULL, 0x000fe400000000ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000010029257824ULL, 0x042fe200078e00ffULL, 0x0000006a008a7306ULL, 0x0002a20000200c00ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fc4000001142dULL,
0x000088802d907816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002800737306ULL, 0x0007e20000200c00ULL, 0x00000018ff6a7819ULL, 0x002fe20000011424ULL,
0x0000001058247824ULL, 0x000fe200078e0270ULL, 0x00000018ff707819ULL, 0x000fe40000011425ULL,
0x00000018ff6f7819ULL, 0x000fe4000001142eULL, 0x00000018ff717819ULL, 0x000fe2000001142fULL,
0x0000002600827306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x008fe200078e00ffULL,
0x000054108b6c7816ULL, 0x010fe2000000006cULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fc40000011494ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002700847306ULL, 0x0003f00000200c00ULL,
0x00000028007d7306ULL, 0x0007e20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000004200ULL,
0x0000002900757306ULL, 0x000fe20000200c00ULL, 0x000001002c287824ULL, 0x008fc400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe20000011428ULL,
0x000001002d287824ULL, 0x040fe200078e00ffULL, 0x0000002a007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100002d2d7824ULL, 0x000fe400078e00ffULL,
0x00000018ff927819ULL, 0x000fc60000011428ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002b007e7306ULL, 0x0007f00000200c00ULL, 0x0000009200957306ULL, 0x0009e20000200c00ULL,
0x009000008728783bULL, 0x008eee0000000200ULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x000099106d927816ULL, 0x010fe200000000ffULL, 0x000001002f6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x002fc40000011424ULL, 0x000000ff9200720cULL, 0x000fe40003f05270ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011425ULL, 0x00000018ff797819ULL, 0x000fe40000011426ULL,
0x00000018ff7a7819ULL, 0x000fc60000011427ULL, 0x0000002c00937306ULL, 0x0009f00000200c00ULL,
0x0000002d00977306ULL, 0x0005e20000200c00ULL, 0x000088802f2c7816ULL, 0x050fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002c00967306ULL, 0x0009e20000200c00ULL, 0x0000006128288232ULL, 0x088fe20000000000ULL,
0x000054108a2d7816ULL, 0x004fe2000000008dULL, 0x000000612a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x0000006d00997306ULL, 0x0004e20000200c00ULL, 0x00005410862c7816ULL, 0x010fce0000000089ULL,
0x0000008e00917306ULL, 0x0009e20000200c00ULL, 0x00008880246d7816ULL, 0x004fe200000000ffULL,
0x0000002c2820723cULL, 0x000fec0000001820ULL, 0x0000006d00897306ULL, 0x0003e20000200c00ULL,
0x000088802e8e7816ULL, 0x050fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fc400078e00ffULL,
0x00000800352c7824ULL, 0x000fe400078e0268ULL, 0x00000100242d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002f00867306ULL, 0x000fe20000200c00ULL,
0x000054108f6d7816ULL, 0x002fe2000000006eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00005410968f7816ULL, 0x008fe20000000099ULL, 0x00000100256e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006c281c723cULL, 0x000fe2000000181cULL,
0x0000002e00927306ULL, 0x0003e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fca000001146eULL,
0x00000018ff6c7819ULL, 0x000fe4000001142dULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x009000002c2c783bULL, 0x002e620000000200ULL, 0x00008880256d7816ULL, 0x000fcc00000000ffULL,
0x0000008000807306ULL, 0x000ef00000200c00ULL, 0x0000006700677306ULL, 0x000f220000200c00ULL,
0x0000541082827816ULL, 0x004fce0000000065ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541080807816ULL, 0x008fce0000000083ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000541084837816ULL, 0x010fe20000000067ULL, 0x0001000025677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x000000822814723cULL, 0x000fe20000001814ULL, 0x000000002d2d8232ULL, 0x082fe40000000000ULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x0000888027007816ULL, 0x000fe200000000ffULL,
0x000000612c2c8232ULL, 0x080fe40000000000ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541085817816ULL, 0x004fe20000000088ULL, 0x000000612e2e8232ULL, 0x000fcc0000000000ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541097257816ULL, 0x008fe20000000078ULL,
0x000000802818723cULL, 0x000fec0000001818ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x0000541092927816ULL, 0x002fce000000006fULL, 0x0000009000907306ULL, 0x000e700000200c00ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000054108c8c7816ULL, 0x004fce0000000091ULL,
0x0000009400877306ULL, 0x000ea20000200c00ULL, 0x00005410908d7816ULL, 0x002fce0000000095ULL,
0x0000002400657306ULL, 0x0003e20000200c00ULL, 0x0000008c2810723cULL, 0x000fe20000001810ULL,
0x000054108e8e7816ULL, 0x004fcc0000000087ULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x0000541093247816ULL, 0x002fe40000000074ULL, 0x0000541086937816ULL, 0x000fe20000000071ULL,
0x0000008e2808723cULL, 0x040fe80000001808ULL, 0x0000007600767306ULL, 0x000e680000200c00ULL,
0x00000024280c723cULL, 0x000fe8000000180cULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x0000541073607816ULL, 0x004fc40000000060ULL, 0x0000888026247816ULL, 0x040fe200000000ffULL,
0x000000922804723cULL, 0x000fe20000001804ULL, 0x0000010026257824ULL, 0x000fc600078e00ffULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000541076737816ULL, 0x002fe4000000007dULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000010027287824ULL, 0x040fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x0000541075617816ULL, 0x008fe40000000064ULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000018ff277819ULL, 0x000fc60000011427ULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x000054107f627816ULL, 0x004fe20000000062ULL, 0x000000602c1c723cULL, 0x000fec000000181cULL,
0x0000006300637306ULL, 0x000eb00000200c00ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541024247816ULL, 0x002fce0000000025ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x000054107e637816ULL, 0x004fce0000000063ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000622c14723cULL, 0x000fee0000001814ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x00005410696a7816ULL, 0x002fce000000006aULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x000054106b6b7816ULL, 0x004fce0000000070ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000006a2c20723cULL, 0x000fee0000001820ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x002fce0000000077ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x00005410657c7816ULL, 0x004fe2000000007cULL,
0x000000722c18723cULL, 0x000fec0000001818ULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000e700000200c00ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x00005410896c7816ULL, 0x002fce000000006cULL,
0x0000006700747306ULL, 0x000e700000200c00ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000054106d6d7816ULL, 0x004fce000000006eULL, 0x0000002800297306ULL, 0x000ea20000200c00ULL,
0x00005410747d7816ULL, 0x002fe2000000007bULL, 0x0000006c2c10723cULL, 0x040fec0000001810ULL,
0x0000002600267306ULL, 0x000e640000200c00ULL, 0x0000007c2c0c723cULL, 0x000fec000000180cULL,
0x0000002700277306ULL, 0x000ee20000200c00ULL, 0x0000541000257816ULL, 0x004fc40000000029ULL,
0x0000541026267816ULL, 0x002fca0000000079ULL, 0x000000242c08723cULL, 0x000fe20000001808ULL,
0x0000541027277816ULL, 0x008fce000000007aULL, 0x000000262c04723cULL, 0x000fe20000001804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003e247f8cULL, 0x0002a2000c80043fULL,
0xfffffff85e5e7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004052277810ULL, 0x000fe20007ffe0ffULL, 0x00f688005eff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff697224ULL, 0x000fe200078e0055ULL, 0x0000000156567812ULL, 0x000fe400078e0cffULL,
0x000000302700720cULL, 0x000fda0003f06070ULL, 0x00005c9000000947ULL, 0x000fea0003800000ULL,
0x000004005f007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000357007812ULL, 0x000fe200078ec0ffULL, 0x0000580037267a24ULL, 0x020fe200078e02ffULL,
0x00000001ff457819ULL, 0x000fe20000011632ULL, 0x00000008406a7824ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fe20003f05270ULL, 0xffffffffff377424ULL, 0x000fc600078e00ffULL,
0x00000001366c7807ULL, 0x000fca0004000000ULL, 0x00000001576c7824ULL, 0x000fca00078e026cULL,
0x000000036c007812ULL, 0x000fc800078ec0ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x00000001366d7807ULL, 0x000fca0004000000ULL, 0x000000016c427824ULL, 0x000fca00078e026dULL,
0x000000034200720cULL, 0x000fe20003f06070ULL, 0x0000002045007824ULL, 0x000fe200078e0252ULL,
0xfffffff034287812ULL, 0x000fe400078ec0ffULL, 0x000000086a617812ULL, 0x000fe400078ec0ffULL,
0x0000000131277810ULL, 0x000fce0007ffe0ffULL, 0x0000006d3f248210ULL, 0x000fe20007ffe06cULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0x0000008000007810ULL, 0x000fc60007ffe0ffULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x0000f6a828287810ULL, 0x000fe40007ffe0ffULL,
0x0000000861607812ULL, 0x000fe400078e3cffULL, 0x0000000624378981ULL, 0x000562000c1e1900ULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x0000000128617824ULL, 0x000fe200078e0261ULL,
0x0000000030277217ULL, 0x000fe20007800000ULL, 0x0000000128607824ULL, 0x000fe200078e0260ULL,
0x00000003ff627819ULL, 0x000fe20000011633ULL, 0x00000040262b7824ULL, 0x000fe200078e00ffULL,
0x00000000610473c2ULL, 0x000ee200000e0000ULL, 0x0000000127277824ULL, 0x000fc400078e0a00ULL,
0x0000001032247824ULL, 0x004fe200078e00ffULL, 0x0000002039257812ULL, 0x000fe200078ef800ULL,
0x00001000406b7824ULL, 0x000fe200078e00ffULL, 0x0000002027277807ULL, 0x000fe40000000000ULL,
0x0000001024287812ULL, 0x000fe200078ec0ffULL, 0x0000000144007824ULL, 0x100fe400078e0225ULL,
0x0000000146247824ULL, 0x100fe200078e0225ULL, 0x0000002728277217ULL, 0x000fe20007800000ULL,
0x0000000148267824ULL, 0x100fe200078e0225ULL, 0x000000002b007210ULL, 0x040fe20007f1e0ffULL,
0x000000014a257824ULL, 0x000fe200078e0225ULL, 0x000000242b247210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a28ULL, 0x000000262b267210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0000567a11ULL, 0x000fe200078038ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00005e00242c7a11ULL, 0x000fc400078438ffULL,
0x000000252b257210ULL, 0x000fe40007f9e0ffULL, 0x00005f00002d7a11ULL, 0x000fe400000f3c2dULL,
0x00005f00242e7a11ULL, 0x000fe200010f3c29ULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x000010006b007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e0026287a11ULL, 0x040fe400078038ffULL, 0x00005e00252a7a11ULL, 0x000fe200078438ffULL,
0x0000200045007824ULL, 0x000fe200078e0200ULL, 0x00005f0026297a11ULL, 0x000fc400000f3c29ULL,
0x0000000462267810ULL, 0x040fe40007ffe0ffULL, 0x000000276200720cULL, 0x000fe40003f86070ULL,
0x00005f00252b7a11ULL, 0x000fe400010f3c24ULL, 0x0000004d56247210ULL, 0x000fe40007f5e0ffULL,
0x000000272600720cULL, 0x000fe40003f06070ULL, 0x0000b00000007810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e062dULL, 0x0000000862267810ULL, 0x000fc40007ffe0ffULL,
0x0000000c62627810ULL, 0x000fe20007ffe0ffULL, 0x00000010472d7824ULL, 0x100fe200078e0200ULL,
0x000000272600720cULL, 0x000fe20003f66070ULL, 0x00000010492f7824ULL, 0x100fe200078e0200ULL,
0x0000004d2c267210ULL, 0x000fe20007fbe0ffULL, 0x000000104b577824ULL, 0x000fe200078e0200ULL,
0x000000276200720cULL, 0x000fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242d7faeULL, 0x0005e2000e101c46ULL, 0x0000004d28287210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e062eULL, 0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL,
0x000000104c637824ULL, 0x000fc400078e0200ULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x00000000262f7faeULL, 0x0005e2000c101c46ULL, 0x000000ffff2b7224ULL, 0x000fc600028e062bULL,
0x0000000028577faeULL, 0x0005e8000d901c46ULL, 0x000000002a637faeULL, 0x0005e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000061247f8cULL, 0x0044e8000c80043fULL, 0x0000040060297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280043267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc60007844855ULL,
0x00f62c00432b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x008fe200078e0025ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe034437812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x0000001034247812ULL, 0x040fe400078ec0ffULL, 0x0000000834257812ULL, 0x000fc800078ec0ffULL,
0x0000004325437210ULL, 0x000fe40007ffe024ULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe20003800000ULL,
0x00f62c0043257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002032007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x000000804d257810ULL, 0x000fca0007ffe000ULL,
0x000000014e257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ee80000000800ULL,
0x00f2000025007984ULL, 0x0008620000000800ULL, 0x0000003c2700720bULL, 0x008fe20003f1d000ULL,
0x0000e0627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff677424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000135257810ULL, 0x000fe40007ffe0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000322500720cULL, 0x000fe20003f65270ULL, 0x0000e0227f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c257209ULL, 0x000fe20007810000ULL,
0x00000080322bb824ULL, 0x000fe200078e024dULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff717819ULL, 0x000fe20000011633ULL, 0x000000014e28b824ULL, 0x000fe200078e022bULL,
0x800000253c267221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL, 0x00f400252800b388ULL, 0x0007e60000000800ULL,
0x0000002600707308ULL, 0x000f240000000800ULL, 0x000000703d3d7220ULL, 0x010fe20000410000ULL,
0x0000dfa27f007947ULL, 0x000fea000b800000ULL, 0x00001f7170247589ULL, 0x00872400000e0000ULL,
0x0000002420207220ULL, 0x090fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000dee27f007947ULL, 0x000fea000b800000ULL, 0x00001f5070247589ULL, 0x0008a400000e0000ULL,
0x000000273c3c7209ULL, 0x000fe20007810000ULL, 0x0000002422227220ULL, 0x084fe20000410000ULL,
0x00000001ff677807ULL, 0x000fe20000000000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x8000003c27270221ULL, 0x000fe20000010000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002700410308ULL, 0x000ea20000000800ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x0000000041000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003d003d7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000840007824ULL, 0x000fe200078e00ffULL, 0xfffffff034257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff717819ULL, 0x008fe40000011633ULL,
0x00000041ff00723eULL, 0x000fe400000000ffULL, 0x0000001871247810ULL, 0x040fe40007ffe0ffULL,
0x0000001071257810ULL, 0x000fe40007ffe0ffULL, 0x0000541000707816ULL, 0x010fe20000000000ULL,
0x0000dc327f007947ULL, 0x000fea000b800000ULL, 0x00001f71706f7589ULL, 0x0002e400000e0000ULL,
0x0000dc727f007947ULL, 0x000fea000b800000ULL, 0x00001f5070007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0025ULL,
0x00004220002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000e6f000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0024ULL,
0x00004280002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000e69000007944ULL, 0x03cfea0003c00000ULL,
0x0000100040247824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100032257824ULL, 0x000fe200078e00ffULL, 0x0000991067677816ULL, 0x000fe400000000ffULL,
0x0000100024247812ULL, 0x000fe400078e0cffULL, 0xffffe00025257812ULL, 0x000fc400078ec0ffULL,
0x000000ff6700720cULL, 0x000fe40003f05270ULL, 0x0000b00025647810ULL, 0x100fe40007ffe024ULL,
0x0000b0003b247810ULL, 0x000fc60007ffe024ULL, 0x0000001053637824ULL, 0x100fe400078e0264ULL,
0x0000001051647824ULL, 0x000fe400078e0264ULL, 0x0000001059657824ULL, 0x100fe200078e0224ULL,
0x000000006328783bULL, 0x000f220000004200ULL, 0x0000001058627824ULL, 0x000fc600078e0224ULL,
0x000000006454783bULL, 0x000ee80000004200ULL, 0x00000000652c783bULL, 0x000ea80000004200ULL,
0x000000006224783bULL, 0x000e620000004200ULL, 0x00000018ff7e7819ULL, 0x010fe20000011428ULL,
0x0000010028807824ULL, 0x040fe200078e00ffULL, 0x00008880287f7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011429ULL,
0x0000010029827824ULL, 0x040fe200078e00ffULL, 0x0000888029817816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000007f008c7306ULL, 0x0009e20000200c00ULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff7b7819ULL, 0x000fe4000001142aULL,
0x00000018ff7c7819ULL, 0x000fe2000001142bULL, 0x00000028008f7306ULL, 0x0003e20000200c00ULL,
0x000088802a7f7816ULL, 0x010fe400000000ffULL, 0x00000018ff787819ULL, 0x008fe40000011457ULL,
0x0000888057847816ULL, 0x000fc400000000ffULL, 0x00000018ff7a7819ULL, 0x000fe20000011455ULL,
0x00000080008d7306ULL, 0x0007e20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011456ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000081008e7306ULL, 0x0003e20000200c00ULL, 0x000088802b807816ULL, 0x008fc400000000ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff797819ULL, 0x000fe40000011454ULL,
0x00000018ff767819ULL, 0x004fe2000001142dULL, 0x0000002800937306ULL, 0x0005e20000200c00ULL,
0x000001002b817824ULL, 0x042fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001142cULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe4000001142eULL,
0x00000018ff817819ULL, 0x000fc40000011481ULL, 0x0000002900907306ULL, 0x0003e20000200c00ULL,
0x0000010054287824ULL, 0x004fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff757819ULL, 0x000fe4000001142fULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002a00947306ULL, 0x0005e20000200c00ULL, 0x0000888055297816ULL, 0x002fe400000000ffULL,
0x00000018ff717819ULL, 0x000fc40000011424ULL, 0x00000018ff747819ULL, 0x000fe40000011425ULL,
0x00000018ff6e7819ULL, 0x000fe20000011426ULL, 0x00000028008b7306ULL, 0x0003e20000200c00ULL,
0x00000100552a7824ULL, 0x044fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011427ULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002900987306ULL, 0x0005e20000200c00ULL, 0x0000010056287824ULL, 0x002fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc80000011455ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002b00977306ULL, 0x0003e20000200c00ULL, 0x0000010057297824ULL, 0x044fe400078e00ffULL,
0x0001000057577824ULL, 0x000fca00078e00ffULL, 0x0000002800837306ULL, 0x0005e20000200c00ULL,
0x00000018ff2b7819ULL, 0x002fce0000011457ULL, 0x0000008000957306ULL, 0x0003e20000200c00ULL,
0x000001002c287824ULL, 0x004fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011428ULL,
0x0000020032287824ULL, 0x000fe200078e00ffULL, 0x0000005500877306ULL, 0x0005e20000200c00ULL,
0x0000888056807816ULL, 0x042fe200000000ffULL, 0x0001000056567824ULL, 0x000fcc00078e00ffULL,
0x0000002a00997306ULL, 0x0003e20000200c00ULL, 0xfffff80028557812ULL, 0x004fe200078ec0ffULL,
0x000001002d287824ULL, 0x000fc800078e00ffULL, 0x0000000166667824ULL, 0x000fe200078e0255ULL,
0x00000018ff887819ULL, 0x000fe20000011428ULL, 0x0000002b009d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2a7819ULL, 0x002fe20000011429ULL, 0x0000000168677824ULL, 0x000fe200078e0255ULL,
0x00000018ff297819ULL, 0x000fe40000011456ULL, 0x000088802c567816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe400078e00ffULL, 0x0000002a009b7306ULL, 0x000fe60000200c00ULL,
0x00000018ff2c7819ULL, 0x000fca000001142cULL, 0x00000029009a7306ULL, 0x0003f00000200c00ULL,
0x0000008200917306ULL, 0x0004e20000200c00ULL, 0x009800006628783bULL, 0x002e6e0000000200ULL,
0x0000007f00927306ULL, 0x0009e20000200c00ULL, 0x0000888054827816ULL, 0x044fe200000000ffULL,
0x0001000054547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000008100967306ULL, 0x0005e20000200c00ULL, 0x000088802d7f7816ULL, 0x050fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000005400867306ULL, 0x0009e20000200c00ULL, 0x000088802e817816ULL, 0x004fce00000000ffULL,
0x0000002d00897306ULL, 0x0005e20000200c00ULL, 0x000001002e547824ULL, 0x050fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000007e007e7306ULL, 0x000f220000200c00ULL, 0x000001002f2d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000006f28288232ULL, 0x082fe40000000000ULL,
0x0000006f2a2a8232ULL, 0x000fe20000000000ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000000029298232ULL, 0x080fe20000000000ULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x000000002b2b8232ULL, 0x000fce0000000000ULL, 0x0000002c00857306ULL, 0x0005f00000200c00ULL,
0x0000002d00a17306ULL, 0x0007e20000200c00ULL, 0x000088802f2c7816ULL, 0x044fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002c009c7306ULL, 0x0005e20000200c00ULL, 0x000054108e2d7816ULL, 0x008fce0000000091ULL,
0x0000002e009f7306ULL, 0x0007e20000200c00ULL, 0x000054108c2c7816ULL, 0x004fce000000008dULL,
0x00000054008a7306ULL, 0x0005e20000200c00ULL, 0x00000100242e7824ULL, 0x048fe200078e00ffULL,
0x0000002c2820723cULL, 0x000fe80000001820ULL, 0x00000018ff557819ULL, 0x000fe4000001142eULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000888024547816ULL, 0x044fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x000054108f2c7816ULL, 0x010fc4000000007eULL,
0x00005410902d7816ULL, 0x002fe4000000007dULL, 0x00008880257e7816ULL, 0x000fe200000000ffULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x00000018ff247819ULL, 0x000fc60000011424ULL,
0x0000002c281c723cULL, 0x000fe8000000181cULL, 0x0000005400687306ULL, 0x0005f00000200c00ULL,
0x00000055007d7306ULL, 0x0007e20000200c00ULL, 0x0000541092547816ULL, 0x004fce0000000093ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x0000541095557816ULL, 0x008fce0000000096ULL,
0x0000002f009e7306ULL, 0x0007e20000200c00ULL, 0x000000542818723cULL, 0x000fee0000001818ULL,
0x000000ffff547224ULL, 0x000fe200078e007eULL, 0x00980000672c783bULL, 0x008ee20000000200ULL,
0x0000541097557816ULL, 0x002fe2000000007cULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x00000100257e7824ULL, 0x000fc400078e00ffULL, 0x0001000025257824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000054008c7306ULL, 0x0003f00000200c00ULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x0000541094547816ULL, 0x002fce000000007bULL,
0x000000542814723cULL, 0x000fe20000001814ULL, 0x0000007900797306ULL, 0x000e6c0000200c00ULL,
0x0000541082547816ULL, 0x004fe4000000008bULL, 0x0000541098557816ULL, 0x000fe20000000099ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x000054109c8b7816ULL, 0x000fe200000000a1ULL,
0x0000006f2c2c8232ULL, 0x008fc80000000000ULL, 0x000000542810723cULL, 0x000fe20000001810ULL,
0x0000541086867816ULL, 0x002fe20000000079ULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000888026797816ULL, 0x000fe200000000ffULL, 0x0000006f2e2e8232ULL, 0x000fe40000000000ULL,
0x000000002d2d8232ULL, 0x080fe20000000000ULL, 0x00000018ff557819ULL, 0x000fe20000011425ULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x0000541084257816ULL, 0x000fe2000000009bULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0x0000541087877816ULL, 0x004fce000000007aULL,
0x0000002400547306ULL, 0x0005e20000200c00ULL, 0x000054109a9a7816ULL, 0x002fe20000000077ULL,
0x00000086280c723cULL, 0x000fec000000180cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541080247816ULL, 0x004fe40000000083ULL, 0x000054109d9b7816ULL, 0x008fca0000000078ULL,
0x000000242808723cULL, 0x040fe20000001808ULL, 0x0000007500757306ULL, 0x000e6c0000200c00ULL,
0x0000010026257824ULL, 0x040fe200078e00ffULL, 0x0000009a2804723cULL, 0x000fe20000001804ULL,
0x000000ffff247224ULL, 0x000fe200078e0079ULL, 0x0000007e007b7306ULL, 0x000fe20000200c00ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc60000011425ULL,
0x0000888027287816ULL, 0x040fe400000000ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x00000024006f7306ULL, 0x0005f00000200c00ULL, 0x0000002500007306ULL, 0x0007e20000200c00ULL,
0x0000010027247824ULL, 0x004fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0001000027257824ULL, 0x008fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe40000011425ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000054109e257816ULL, 0x002fce0000000075ULL, 0x0000002400297306ULL, 0x0003f00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054109f247816ULL, 0x002fe40000000072ULL,
0x0000541056567816ULL, 0x004fca0000000057ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000000242c14723cULL, 0x000fee0000001814ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000541068247816ULL, 0x000fe4000000007dULL, 0x000054108c257816ULL, 0x000fca000000007bULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000054107f577816ULL, 0x002fe20000000088ULL,
0x000000242c10723cULL, 0x040fec0000001810ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000054106f247816ULL, 0x000fe20000000000ULL, 0x000000562c20723cULL, 0x000fe20000001820ULL,
0x0000541085887816ULL, 0x004fca0000000070ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541089897816ULL, 0x008fce0000000076ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541054547816ULL, 0x002fe20000000071ULL, 0x000000882c1c723cULL, 0x000fec000000181cULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000e700000200c00ULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x0000002800287306ULL, 0x000ee20000200c00ULL,
0x00005410818a7816ULL, 0x002fce000000008aULL, 0x0000002600277306ULL, 0x000e620000200c00ULL,
0x0000541055557816ULL, 0x004fe20000000074ULL, 0x0000008a2c18723cULL, 0x040fec0000001818ULL,
0x0000002a002a7306ULL, 0x000ea20000200c00ULL, 0x0000541028257816ULL, 0x008fe20000000029ULL,
0x000000542c0c723cULL, 0x000fe2000000180cULL, 0x00005410276e7816ULL, 0x002fce000000006eULL,
0x000000242c08723cULL, 0x000fe20000001808ULL, 0x000054102a6f7816ULL, 0x004fce0000000073ULL,
0x0000006e2c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003e247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008052277810ULL, 0x000fe20007ffe0ffULL,
0x00f690005eff7f8cULL, 0x0007e2000c80043fULL, 0x0000000140567812ULL, 0x000fe400078ec0ffULL,
0x000000302700720cULL, 0x000fda0003f06070ULL, 0x00003c7000000947ULL, 0x000fea0003800000ULL,
0x000004005f007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000016c6d7824ULL, 0x000fe400078e026dULL, 0x0000580037287a24ULL, 0x020fe200078e02ffULL,
0x00000001ff457819ULL, 0x000fe20000011632ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000036d007812ULL, 0x000fc800078ec0ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x0000000136427807ULL, 0x000fca0004000000ULL, 0x000000016d427824ULL, 0x000fe400078e0242ULL,
0x0000002045007824ULL, 0x000fc600078e0252ULL, 0x000000034200720cULL, 0x000fe40003f06070ULL,
0x000000c000007810ULL, 0x000fe40007ffe0ffULL, 0x0000000131277810ULL, 0x000fe40007ffe0ffULL,
0x0000000030297217ULL, 0x000fe40007800000ULL, 0x000000022700720cULL, 0x000fe40003f46070ULL,
0x0000002039277812ULL, 0x000fc600078ef800ULL, 0x000000013f248824ULL, 0x000fe400078e0242ULL,
0x00000004ff258424ULL, 0x000fe400078e00ffULL, 0x0000000129297824ULL, 0x000fe400078e0a00ULL,
0x0000600024248625ULL, 0x000fc800078e0025ULL, 0x0000004028287824ULL, 0x000fe200078e00ffULL,
0x0000000624378981ULL, 0x000562000c1e1900ULL, 0x0000000144007824ULL, 0x000fe200078e0227ULL,
0x0000002029297807ULL, 0x000fe20001000000ULL, 0x0000001032267824ULL, 0x000fe200078e00ffULL,
0x00000003ff547819ULL, 0x000fe20000011633ULL, 0x00000000600473c2ULL, 0x000ee200000e0000ULL,
0x0000000028007210ULL, 0x000fe40007f1e0ffULL, 0x0000001026267812ULL, 0x000fe200078ec0ffULL,
0x0000000146247824ULL, 0x104fe200078e0227ULL, 0x0000000454567810ULL, 0x000fe20007ffe0ffULL,
0x0000000148257824ULL, 0x100fe200078e0227ULL, 0x0000002926297217ULL, 0x000fe20007800000ULL,
0x000000014a277824ULL, 0x000fe200078e0227ULL, 0x00000024282c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e00002e7a11ULL, 0x000fe200078038ffULL,
0x0000000129297824ULL, 0x000fe200078e0a26ULL, 0x0000002528257210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x0000002728277210ULL, 0x000fc40007f9e0ffULL,
0x00005f00002d7a11ULL, 0x000fe200000f3c2dULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e002c267a11ULL, 0x040fe200078038ffULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x00005e0025287a11ULL, 0x000fe400078438ffULL, 0x00005e00272a7a11ULL, 0x000fe400078638ffULL,
0x00005f002c2c7a11ULL, 0x000fe400000f3c2bULL, 0x00005f00252b7a11ULL, 0x000fc400010f3c24ULL,
0x00005f0027007a11ULL, 0x000fe400018f3c00ULL, 0x000000295600720cULL, 0x000fe40003f46070ULL,
0x0000004d2e247210ULL, 0x000fe40007f9e0ffULL, 0x0000000854567810ULL, 0x040fe40007ffe0ffULL,
0x000000295400720cULL, 0x040fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200020e062dULL,
0x0000000c54547810ULL, 0x000fc40007ffe0ffULL, 0x0000004d26267210ULL, 0x000fe40007fbe0ffULL,
0x000000295600720cULL, 0x080fe40003f06070ULL, 0x000000295400720cULL, 0x000fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x0000004d28287210ULL, 0x080fe40007fde0ffULL,
0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245a7faeULL, 0x0005e4000d901c46ULL, 0x000000ffff297224ULL, 0x000fc400030e062bULL,
0x000000ffff2b7224ULL, 0x000fe200028e0600ULL, 0x00000000265b7faeULL, 0x0005e8000d101c46ULL,
0x00000000285c7faeULL, 0x0005e8000c101c46ULL, 0x000000002a5d7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000605a7f8cULL, 0x0044e8000c80043fULL, 0x0000040061007984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480043247f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x010fc60007844869ULL,
0x00f64c0043277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe034437812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001034267812ULL, 0x040fe400078ec0ffULL,
0x0000000834277812ULL, 0x000fc800078ec0ffULL, 0x0000004327437210ULL, 0x000fe40007ffe026ULL,
0x0000000000267305ULL, 0x000864000021f000ULL, 0x3fa0000000007823ULL, 0x010fe200000100ffULL,
0x000000260000735dULL, 0x002fe20003800000ULL, 0x00f64c0043277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002032007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x000001004d257810ULL, 0x000fca0007ffe000ULL, 0x000000014e257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000f280000000800ULL, 0x00f2000025007984ULL, 0x0002a20000000800ULL,
0x0000003c2700720bULL, 0x010fe20003f1d000ULL, 0x0000c3b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff7f7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000235257810ULL, 0x000fe40007ffe0ffULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000322500720cULL, 0x000fe20003f65270ULL,
0x0000c3727f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273c257209ULL, 0x000fe20007810000ULL, 0x00000080322bb824ULL, 0x000fe200078e024dULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff717819ULL, 0x000fe20000011633ULL,
0x000000014e28b824ULL, 0x000fe200078e022bULL, 0x800000253c267221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL,
0x00f400252800b388ULL, 0x0003e60000000800ULL, 0x0000002600707308ULL, 0x000f240000000800ULL,
0x000000703d3d7220ULL, 0x010fe20000410000ULL, 0x0000c2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f7170247589ULL, 0x00232400000e0000ULL, 0x0000002420207220ULL, 0x090fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000c2327f007947ULL, 0x000fea000b800000ULL,
0x00001f5070247589ULL, 0x00086400000e0000ULL, 0x000000273c3c7209ULL, 0x000fe20007810000ULL,
0x0000002422227220ULL, 0x082fe20000410000ULL, 0x00000001ff7f7807ULL, 0x000fe20000000000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x8000003c27270221ULL, 0x000fe20000010000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002700410308ULL, 0x000e620000000800ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x0000000041000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003d003d7221ULL, 0x004fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x000000086a007812ULL, 0x000fe400078ec0ffULL,
0xfffffff034257812ULL, 0x000fca00078ec0ffULL, 0x0000000125007824ULL, 0x000fcc00078e0200ULL,
0x00f6ac0000007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0000040061247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff717819ULL, 0x000fe40000011633ULL,
0x00000041ff00723eULL, 0x000fe400000000ffULL, 0x0000001871247810ULL, 0x040fe40007ffe0ffULL,
0x0000001071257810ULL, 0x000fe40007ffe0ffULL, 0x0000541000707816ULL, 0x010fe20000000000ULL,
0x0000bf927f007947ULL, 0x000fea000b800000ULL, 0x00001f71705d7589ULL, 0x0002a400000e0000ULL,
0x0000bfd27f007947ULL, 0x000fea000b800000ULL, 0x00001f5070007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0025ULL,
0x00006100002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000c81000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0024ULL,
0x00006160002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000c7b000007944ULL, 0x03cfea0003c00000ULL,
0x000010006b547812ULL, 0x000fe200078ec0ffULL, 0x00001000322c7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000099107f7f7816ULL, 0x000fe400000000ffULL,
0x0000b0003b247810ULL, 0x000fe40007ffe054ULL, 0xffffe0002c2d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff7f00720cULL, 0x000fe20003f05270ULL, 0x0000001059287824ULL, 0x000fe200078e0224ULL,
0x0000b0002d547810ULL, 0x000fe20007ffe054ULL, 0x0000001058247824ULL, 0x000fc800078e0224ULL,
0x00000010532c7824ULL, 0x100fe200078e0254ULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x0000001051547824ULL, 0x000fc600078e0254ULL, 0x000000002424783bULL, 0x000fe80000004200ULL,
0x000000002c2c783bULL, 0x000ee80000004200ULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x00000018ff6c7819ULL, 0x010fe2000001142bULL, 0x00000100296d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011428ULL, 0x000001002a6f7824ULL, 0x000fe200078e00ffULL,
0x0000006c00517306ULL, 0x0009e20000200c00ULL, 0x00000018ff597819ULL, 0x000fc40000011429ULL,
0x00000018ff587819ULL, 0x000fe2000001142aULL, 0x000001002d837824ULL, 0x008fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001142cULL, 0x000100002f8b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x002fe2000001146fULL, 0x00000100548d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x010fe2000001142dULL, 0x0000006b00827306ULL, 0x0003e20000200c00ULL,
0x000088802b6f7816ULL, 0x000fe200000000ffULL, 0x00000100558f7824ULL, 0x000fe200078e00ffULL,
0x000088802a707816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001142eULL, 0x0000010056907824ULL, 0x000fe200078e00ffULL,
0x000088802e867816ULL, 0x000fe200000000ffULL, 0x0000006c00847306ULL, 0x0005e20000200c00ULL,
0x00008880286b7816ULL, 0x002fc400000000ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff807819ULL, 0x000fe4000001142fULL, 0x000088802f897816ULL, 0x000fe200000000ffULL,
0x0000002a007b7306ULL, 0x0003e20000200c00ULL, 0x00000100286c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888057917816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001146cULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x00008880296c7816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000088802d2a7816ULL, 0x042fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011454ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002800727306ULL, 0x0003e20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff7e7819ULL, 0x000fe40000011455ULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x00008880548c7816ULL, 0x040fe200000000ffULL, 0x0000002900747306ULL, 0x0005e20000200c00ULL,
0x000001002b287824ULL, 0x002fe200078e00ffULL, 0x00008880558e7816ULL, 0x000fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011457ULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000010024297824ULL, 0x004fe200078e00ffULL, 0x00000028007c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff767819ULL, 0x000fe20000011429ULL, 0x000001002c297824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011424ULL, 0x0000002b00787306ULL, 0x000fe20000200c00ULL,
0x0000010025287824ULL, 0x002fe200078e00ffULL, 0x0000888024797816ULL, 0x000fe400000000ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff7a7819ULL, 0x000fc40000011428ULL,
0x000088802c287816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x0000002d00857306ULL, 0x000fe20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff737819ULL, 0x000fe40000011456ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00008880567f7816ULL, 0x040fe200000000ffULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001148dULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x0000002c002b7306ULL, 0x0002a20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff6a7819ULL, 0x000fe40000011425ULL, 0x0000888025777816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011426ULL,
0x0000002900297306ULL, 0x000ee20000200c00ULL, 0x000001002e2c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011427ULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff877819ULL, 0x000fe2000001142cULL,
0x000001002f2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001142eULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x000054102b827816ULL, 0x004fe40000000082ULL,
0x00000018ff8a7819ULL, 0x000fe4000001142cULL, 0x00a00000662c783bULL, 0x000ea20000000200ULL,
0x0000541028287816ULL, 0x008fe40000000029ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000054102a297816ULL, 0x002fe20000000083ULL, 0x000000ffff837224ULL, 0x000fcc00078e0091ULL,
0x0000008700877306ULL, 0x000e700000200c00ULL, 0x0000008300917306ULL, 0x0007f00000200c00ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541085837816ULL, 0x008fc40000000084ULL,
0x0000541086867816ULL, 0x002fca0000000087ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x0000005d2c2c8232ULL, 0x084fe40000000000ULL, 0x0000005d2e2e8232ULL, 0x000fe40000000000ULL,
0x000000002d2d8232ULL, 0x000fc60000000000ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000000002f2f8232ULL, 0x000fce0000000000ULL, 0x000000282c20723cULL, 0x000fe20000001820ULL,
0x0000008b008b7306ULL, 0x000ea20000200c00ULL, 0x0000541089877816ULL, 0x002fca000000008aULL,
0x0000010057287824ULL, 0x040fe200078e00ffULL, 0x000000822c1c723cULL, 0x000fe2000000181cULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0001000057577824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011428ULL, 0x000000862c18723cULL, 0x000fe20000001818ULL,
0x00a000006728783bULL, 0x000e620000000200ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x000054108b897816ULL, 0x004fe20000000080ULL,
0x0001000024807824ULL, 0x000fc800078e00ffULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x00000018ff807819ULL, 0x000fce0000011480ULL, 0x0000005500557306ULL, 0x000ef00000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541054547816ULL, 0x004fce000000007dULL,
0x0000005700247306ULL, 0x000ea20000200c00ULL, 0x0000541055557816ULL, 0x008fe2000000007eULL,
0x0000005d28288232ULL, 0x002fcc0000000000ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000542c0c723cULL, 0x000fe2000000180cULL, 0x0000005d2a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x0000888027007816ULL, 0x000fe200000000ffULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000888026547816ULL, 0x000fe400000000ffULL, 0x0000541024577816ULL, 0x004fc60000000075ULL,
0x000000ffff247224ULL, 0x000fe400078e0054ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000010026547824ULL, 0x040fe400078e00ffULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x0000008c008c7306ULL, 0x000ff00000200c00ULL,
0x0000008d008d7306ULL, 0x000e700000200c00ULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054108c8c7816ULL, 0x002fce000000008dULL,
0x0000008800887306ULL, 0x000e700000200c00ULL, 0x0000008e008e7306ULL, 0x000ff00000200c00ULL,
0x0000008f008f7306ULL, 0x000ea20000200c00ULL, 0x0000541088887816ULL, 0x002fce0000000081ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000000882c14723cULL, 0x000fee0000001814ULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x000054108e8d7816ULL, 0x004fce000000008fULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x0000008c2c10723cULL, 0x000fee0000001810ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x000054107f907816ULL, 0x002fce0000000090ULL,
0x0000002500557306ULL, 0x0003e20000200c00ULL, 0x0000541091917816ULL, 0x004fce0000000082ULL,
0x00000024005d7306ULL, 0x0005e20000200c00ULL, 0x000054106c257816ULL, 0x002fe2000000006dULL,
0x000000902c08723cULL, 0x000fe20000001808ULL, 0x0000541056567816ULL, 0x008fca0000000073ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000054106b247816ULL, 0x004fe2000000006eULL,
0x000000562c04723cULL, 0x000fec0000001804ULL, 0x0000006a006a7306ULL, 0x000fe40000200c00ULL,
0x000000242820723cULL, 0x000fec0000001820ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x0000541074737816ULL, 0x002fe20000000059ULL,
0x0001000027257824ULL, 0x000fe200078e00ffULL, 0x0000541078597816ULL, 0x000fc40000000051ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x000054105d547816ULL, 0x004fce0000000054ULL,
0x0000005800587306ULL, 0x000eb00000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x002fce0000000053ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000054107b587816ULL, 0x004fe20000000058ULL, 0x00000072281c723cULL, 0x040fec000000181cULL,
0x0000006900697306ULL, 0x000fe40000200c00ULL, 0x000000582814723cULL, 0x000fec0000001814ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410706e7816ULL, 0x002fce0000000071ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054106f6f7816ULL, 0x004fce000000007cULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000006e2818723cULL, 0x000fee0000001818ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000541079767816ULL, 0x002fce0000000076ULL, 0x0000008000817306ULL, 0x000e700000200c00ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541077777816ULL, 0x004fce000000007aULL,
0x00000024002d7306ULL, 0x0003e20000200c00ULL, 0x000000762810723cULL, 0x000fee0000001810ULL,
0x0000002600277306ULL, 0x000ea20000200c00ULL, 0x0000541081247816ULL, 0x002fce0000000068ULL,
0x00000025002c7306ULL, 0x0002e20000200c00ULL, 0x00005410275c7816ULL, 0x004fe4000000005cULL,
0x0000541055257816ULL, 0x002fe4000000006aULL, 0x0000541000557816ULL, 0x000fe4000000002dULL,
0x000054102c5d7816ULL, 0x008fc60000000069ULL, 0x00000024280c723cULL, 0x040ff0000000180cULL,
0x000000542808723cULL, 0x040ff00000001808ULL, 0x0000005c2804723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003e247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c052277810ULL, 0x000fe20007ffe0ffULL, 0x00f698005eff7f8cULL, 0x0007e2000c80043fULL,
0x0000000140567812ULL, 0x000fe200078e0cffULL, 0x000000ffff697224ULL, 0x000fe200078e005bULL,
0x000000302700720cULL, 0x000fda0003f06070ULL, 0x00001dd000000947ULL, 0x000fea0003800000ULL,
0x000004005f007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000342007812ULL, 0x000fe200078ec0ffULL, 0x0000580037267a24ULL, 0x020fe200078e02ffULL,
0x0000030031277a10ULL, 0x000fe20007ffe0ffULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x0000000136257807ULL, 0x000fca0004000000ULL,
0x0000000142427824ULL, 0x000fca00078e0225ULL, 0x000000034200720cULL, 0x000fe20003f06070ULL,
0x0000010027007824ULL, 0x040fe200078e023aULL, 0x0000000127277810ULL, 0x000fd60007ffe0ffULL,
0x000000013f248824ULL, 0x000fe400078e0242ULL, 0x00000004ff258424ULL, 0x000fc800078e00ffULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x0000000030297217ULL, 0x000fc80007800000ULL,
0x0000000624378981ULL, 0x000562000c1e1900ULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x0000000129297824ULL, 0x100fe200078e0a00ULL, 0x0000002039277812ULL, 0x000fe200078ef800ULL,
0x0000001032007824ULL, 0x000fe200078e00ffULL, 0x00000000610473c2ULL, 0x000ee200000e0000ULL,
0x00000040262b7824ULL, 0x000fe200078e00ffULL, 0x0000002029297807ULL, 0x000fe20000000000ULL,
0x0000000146467824ULL, 0x100fe200078e0227ULL, 0x0000001000007812ULL, 0x000fe200078ec0ffULL,
0x0000000144447824ULL, 0x000fc400078e0227ULL, 0x0000000148487824ULL, 0x100fe200078e0227ULL,
0x000000462b467210ULL, 0x040fe20007f5e0ffULL, 0x000000014a277824ULL, 0x000fe200078e0227ULL,
0x000000442b447210ULL, 0x040fe40007f1e0ffULL, 0x0000002900297217ULL, 0x000fe20007800000ULL,
0x000000ffff2d7224ULL, 0x000fe200010e06ffULL, 0x000000272b277210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x004fe200000e06ffULL, 0x00005e0046267a11ULL, 0x000fe200078438ffULL,
0x0000000129297824ULL, 0x000fe200078e0a00ULL, 0x000000482b487210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e0044247a11ULL, 0x000fc400078038ffULL,
0x00005f00462d7a11ULL, 0x000fe400010f3c2dULL, 0x00005e00272a7a11ULL, 0x040fe400078438ffULL,
0x00005f00442e7a11ULL, 0x000fe200000f3c25ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005e0048287a11ULL, 0x000fe400078038ffULL, 0x00000003ff447819ULL, 0x000fe40000011633ULL,
0x00005f00272b7a11ULL, 0x000fe200010f3c00ULL, 0x0000100040007824ULL, 0x000fe200078e00ffULL,
0x0000004d26267210ULL, 0x000fc40007fbe0ffULL, 0x00005f00482c7a11ULL, 0x000fe400000f3c25ULL,
0x0000000444487810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062dULL,
0x0000004d24247210ULL, 0x000fe40007f9e0ffULL, 0x0000000844467810ULL, 0x040fe40007ffe0ffULL,
0x000000294400720cULL, 0x000fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200020e062eULL,
0x0000100000007812ULL, 0x000fc400078ec0ffULL, 0x0000000c44447810ULL, 0x000fe40007ffe0ffULL,
0x0000004d28287210ULL, 0x000fe40007fbe0ffULL, 0x000000294800720cULL, 0x080fe40003f46070ULL,
0x000000294600720cULL, 0x080fe40003f06070ULL, 0x0000b0003b007810ULL, 0x000fe40007ffe000ULL,
0x000000294400720cULL, 0x000fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e062cULL,
0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001047477824ULL, 0x000fc400078e0200ULL,
0x0000001049497824ULL, 0x100fe400078e0200ULL, 0x000000104b4b7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024477faeULL, 0x0005e2000d901c46ULL,
0x000000104c2d7824ULL, 0x000fe400078e0200ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000026497faeULL, 0x0005e8000d101c46ULL, 0x00000000284b7faeULL, 0x0005e8000c101c46ULL,
0x000000002a2d7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000061687f8cULL, 0x000728000c80043fULL,
0x0000040060277984ULL, 0x0046a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680043247f8cULL, 0x000fe2000c80043fULL,
0x8000000027ff7812ULL, 0x004fc6000784485bULL, 0x00f66c0043297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000464000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x002fe20003800000ULL,
0x00f66c0043277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002032007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x000001804d257810ULL, 0x000fca0007ffe000ULL,
0x000000014e257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ea80000000800ULL,
0x00f2000025007984ULL, 0x0002e20000000800ULL, 0x0000003c2700720bULL, 0x004fe20003f1d000ULL,
0x0000a7427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff537424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000335257810ULL, 0x000fe40007ffe0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000322500720cULL, 0x000fe20003f65270ULL, 0x0000a7027f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c267209ULL, 0x000fe20007810000ULL,
0x00000080324db824ULL, 0x000fe200078e024dULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff717819ULL, 0x000fe20000011633ULL, 0x000000014e4db824ULL, 0x000fe200078e024dULL,
0x800000263c257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400264d00b388ULL, 0x0003e60000000800ULL,
0x0000002500707308ULL, 0x000ea40000000800ULL, 0x000000703d3d7220ULL, 0x004fe20000410000ULL,
0x0000a6827f007947ULL, 0x000fea000b800000ULL, 0x00001f7170247589ULL, 0x0022a400000e0000ULL,
0x0000002420207220ULL, 0x084fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000a5c27f007947ULL, 0x000fea000b800000ULL, 0x00001f5070247589ULL, 0x00046400000e0000ULL,
0x8000002627270221ULL, 0x100fe20000010000ULL, 0x00000001ff537807ULL, 0x000fe20000000000ULL,
0x0000002422227220ULL, 0x082fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x0000002700410308ULL, 0x000e620000000800ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0026ULL, 0x0000000041000220ULL, 0x00afc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003d003d7221ULL, 0x008fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000840007824ULL, 0x000fe200078e00ffULL, 0xfffffff034257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125257824ULL, 0x000fcc00078e0200ULL,
0x00f6ac0025257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x008fe20003800000ULL,
0x0000040060257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff717819ULL, 0x000fe40000011633ULL,
0x00000041ff25723eULL, 0x000fe400000000ffULL, 0x0000001871007810ULL, 0x040fe40007ffe0ffULL,
0x0000001071247810ULL, 0x000fe40007ffe0ffULL, 0x0000541025707816ULL, 0x004fe20000000025ULL,
0x0000a3127f007947ULL, 0x000fea000b800000ULL, 0x00001f7170437589ULL, 0x0002a400000e0000ULL,
0x0000a3527f007947ULL, 0x000fea000b800000ULL, 0x00001f5070507589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0024ULL,
0x00007fc0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000a95000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0000ULL,
0x00008020002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000a8f000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006324783bULL, 0x000ee80000004200ULL,
0x00000000642c783bULL, 0x0008a80000004200ULL, 0x000000006528783bULL, 0x000e680000004200ULL,
0x000000006260783bULL, 0x000e620000004200ULL, 0x00000018ff007819ULL, 0x008fe20000011424ULL,
0x0000010024557824ULL, 0x040fe200078e00ffULL, 0x0000888024547816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011425ULL,
0x0000010025577824ULL, 0x040fe200078e00ffULL, 0x0000888025587816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x00000100265d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011457ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fc40000011426ULL,
0x00008880265c7816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff527819ULL, 0x000fe20000011427ULL,
0x0000002400577306ULL, 0x0007e20000200c00ULL, 0x0000888027647816ULL, 0x010fe400000000ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff4c7819ULL, 0x004fc4000001142eULL,
0x00000018ff4d7819ULL, 0x000fe2000001142fULL, 0x00000025005b7306ULL, 0x0005e20000200c00ULL,
0x0000010027247824ULL, 0x048fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001142cULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002600687306ULL, 0x0007e20000200c00ULL,
0x000088802c257816ULL, 0x004fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff4e7819ULL, 0x000fe4000001142dULL, 0x00000018ff4a7819ULL, 0x002fe20000011428ULL,
0x00000024006b7306ULL, 0x0003e20000200c00ULL, 0x000001002d267824ULL, 0x008fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff4b7819ULL, 0x000fe40000011429ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000025006c7306ULL, 0x0005e20000200c00ULL,
0x000088802d247816ULL, 0x042fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x0000888029787816ULL, 0x000fe400000000ffULL, 0x00000018ff497819ULL, 0x000fe4000001142bULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x00000024006e7306ULL, 0x0003e20000200c00ULL,
0x000088802e257816ULL, 0x004fe400000000ffULL, 0x00000018ff487819ULL, 0x000fc4000001142aULL,
0x00000018ff477819ULL, 0x000fe40000011461ULL, 0x00000018ff467819ULL, 0x000fe20000011463ULL,
0x00000027006d7306ULL, 0x0005e20000200c00ULL, 0x000001002e247824ULL, 0x042fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002500707306ULL, 0x0003e20000200c00ULL, 0x000001002f277824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fc8000001142eULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002400737306ULL, 0x0004e20000200c00ULL, 0x000100002f257824ULL, 0x002fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002600717306ULL, 0x0003e20000200c00ULL,
0x0000010028247824ULL, 0x004fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011424ULL,
0x0000010029247824ULL, 0x000fe200078e00ffULL, 0x0000002700757306ULL, 0x000fe20000200c00ULL,
0x000088802f267816ULL, 0x002fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000541070707816ULL, 0x008fc80000000073ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002e002f7306ULL, 0x0003f00000200c00ULL, 0x0000002600727306ULL, 0x000fe20000200c00ULL,
0x00000018ff2e7819ULL, 0x002fce0000011424ULL, 0x0000002500747306ULL, 0x0003f00000200c00ULL,
0x00000064006a7306ULL, 0x0005e20000200c00ULL, 0x00a800006624783bULL, 0x0022ee0000000200ULL,
0x0000005500557306ULL, 0x000f220000200c00ULL, 0x000001002c647824ULL, 0x044fe200078e00ffULL,
0x0000991053667816ULL, 0x002fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000000ff6600720cULL, 0x000fe40003f05270ULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x010fce0000000055ULL,
0x00000064006f7306ULL, 0x0005300000200c00ULL, 0x0000000000567306ULL, 0x0009220000200c00ULL,
0x0000888028647816ULL, 0x044fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000004324248232ULL, 0x088fe20000000000ULL, 0x0000541058557816ULL, 0x002fe20000000059ULL,
0x0000004326268232ULL, 0x000fc40000000000ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x00000044005a7306ULL, 0x0002a20000200c00ULL, 0x0000005025258232ULL, 0x080fe20000000000ULL,
0x000054106c6c7816ULL, 0x010fe2000000006fULL, 0x0000005027278232ULL, 0x000fe20000000000ULL,
0x00000018ff007819ULL, 0x000fc80000011462ULL, 0x0000006500777306ULL, 0x0007e20000200c00ULL,
0x0000541057567816ULL, 0x000fe20000000056ULL, 0x000000542420723cULL, 0x000fe20000001820ULL,
0x00000018ff447819ULL, 0x002fca0000011460ULL, 0x0000006400767306ULL, 0x0003220000200c00ULL,
0x000001002a657824ULL, 0x008fe200078e00ffULL, 0x000054105b577816ULL, 0x004fc8000000005aULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000088802a647816ULL, 0x042fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000056241c723cULL, 0x000fe8000000181cULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541076767816ULL, 0x010fe20000000077ULL,
0x0000010061567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000054105c5c7816ULL, 0x002fc4000000005dULL,
0x000054106a5d7816ULL, 0x000fca000000006bULL, 0x0000004e004e7306ULL, 0x000fe40000200c00ULL,
0x0000005c2418723cULL, 0x000fec0000001818ULL, 0x0000004c004c7306ULL, 0x000e700000200c00ULL,
0x0000004d004d7306ULL, 0x000eb00000200c00ULL, 0x0000002c002c7306ULL, 0x000ee20000200c00ULL,
0x000054102f4c7816ULL, 0x002fce000000004cULL, 0x0000002d002d7306ULL, 0x000e620000200c00ULL,
0x00005410744d7816ULL, 0x004fce000000004dULL, 0x0000002800797306ULL, 0x0005e20000200c00ULL,
0x000054102c2c7816ULL, 0x008fe2000000004fULL, 0x0000004c2404723cULL, 0x000fec0000001804ULL,
0x0000002e007b7306ULL, 0x0007e20000200c00ULL, 0x000088802b287816ULL, 0x004fe400000000ffULL,
0x000054102d2d7816ULL, 0x002fca000000004eULL, 0x00000064007c7306ULL, 0x000fe20000200c00ULL,
0x000001002b2e7824ULL, 0x048fe200078e00ffULL, 0x0000002c240c723cULL, 0x000fe2000000180cULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x00000065007d7306ULL, 0x0002a20000200c00ULL, 0x00000100622c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002800537306ULL, 0x0007e20000200c00ULL,
0x00a800006764783bULL, 0x002e6e0000000200ULL, 0x00000029007a7306ULL, 0x0009e20000200c00ULL,
0x0000888060287816ULL, 0x008fc400000000ffULL, 0x000054107c7c7816ULL, 0x004fca000000007dULL,
0x0000002800547306ULL, 0x0005e20000200c00ULL, 0x00000018ff297819ULL, 0x010fce000001142bULL,
0x00000029007e7306ULL, 0x0007e20000200c00ULL, 0x0000888061287816ULL, 0x044fe200000000ffULL,
0x0001000061617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000002a002b7306ULL, 0x0005e20000200c00ULL, 0x000054106d297816ULL, 0x008fe40000000052ULL,
0x000054106e6d7816ULL, 0x000fe40000000071ULL, 0x0000541072717816ULL, 0x000fc60000000075ULL,
0x0000002800577306ULL, 0x0007e20000200c00ULL, 0x00000100602a7824ULL, 0x044fe200078e00ffULL,
0x0000006c2410723cULL, 0x040fe20000001810ULL, 0x0001000060607824ULL, 0x000fe200078e00ffULL,
0x0000004364648232ULL, 0x082fe40000000000ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000004366668232ULL, 0x000fe20000000000ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000541068287816ULL, 0x008fe20000000051ULL,
0x000000702408723cULL, 0x000fe20000001808ULL, 0x0000005065658232ULL, 0x000fc40000000000ULL,
0x0000005067678232ULL, 0x000fc60000000000ULL, 0x0000002a00557306ULL, 0x0002a40000200c00ULL,
0x000000282414723cULL, 0x000fec0000001814ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000888063247816ULL, 0x040fe200000000ffULL, 0x0000010063257824ULL, 0x040fe200078e00ffULL,
0x00008880622a7816ULL, 0x002fe200000000ffULL, 0x0001000063637824ULL, 0x000fc400078e00ffULL,
0x0001000062627824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000006000297306ULL, 0x000fe20000200c00ULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000541054547816ULL, 0x004fc60000000055ULL,
0x0000006100287306ULL, 0x000ff00000200c00ULL, 0x0000004800487306ULL, 0x000e700000200c00ULL,
0x0000004a004a7306ULL, 0x000eb00000200c00ULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x000054102b487816ULL, 0x002fce0000000048ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x00005410794a7816ULL, 0x004fce000000004aULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000054107a4b7816ULL, 0x008fce000000004bULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x000054107e497816ULL, 0x002fe20000000049ULL, 0x0000004a641c723cULL, 0x040fec000000181cULL,
0x0000007800787306ULL, 0x000e640000200c00ULL, 0x000000486414723cULL, 0x000fec0000001814ULL,
0x0000002e002e7306ULL, 0x000eb00000200c00ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541078777816ULL, 0x002fce000000007bULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x00005410537d7816ULL, 0x004fe2000000002eULL, 0x000000766420723cULL, 0x040fec0000001820ULL,
0x0000002c00277306ULL, 0x000e620000200c00ULL, 0x0000541057557816ULL, 0x008fe20000000056ULL,
0x0000007c6418723cULL, 0x040fec0000001818ULL, 0x0000002400267306ULL, 0x0005e40000200c00ULL,
0x000000546410723cULL, 0x000fec0000001810ULL, 0x00000025002f7306ULL, 0x0007220000200c00ULL,
0x0000541029247816ULL, 0x004fc40000000044ULL, 0x000054102a2a7816ULL, 0x002fca0000000027ULL,
0x00000062002d7306ULL, 0x000e620000200c00ULL, 0x0000541028257816ULL, 0x008fce0000000047ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x00000024640c723cULL, 0x000fe2000000180cULL,
0x00005410262b7816ULL, 0x010fcc000000002fULL, 0x000054102d247816ULL, 0x002fe20000000000ULL,
0x0000002a6408723cULL, 0x000fe20000001808ULL, 0x0000541063257816ULL, 0x004fce0000000046ULL,
0x000000246404723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003e247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0005eff7f8cULL, 0x0007e2000c80043fULL,
0x0000000140567812ULL, 0x000fc600078ec0ffULL, 0x0000030031317a10ULL, 0x008fc80007ffe0ffULL,
0x000000023100720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff804000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff2d7224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe400078e0017ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0007ULL, 0x000000ffff377224ULL, 0x020fe400078e0006ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff337224ULL, 0x000fc400078e0004ULL,
0x000000ffff2a7224ULL, 0x000fe400078e000bULL, 0x000000ffff317224ULL, 0x000fe400078e000aULL,
0x000000ffff287224ULL, 0x000fe400078e0009ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff267224ULL, 0x000fe400078e000fULL, 0x000000ffff247224ULL, 0x008fe200078e000dULL,
0x0000000402007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff2b7224ULL, 0x000fc400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e0013ULL, 0x000000ffff277224ULL, 0x000fe400078e0011ULL,
0x000000ffff257224ULL, 0x000fe400078e0016ULL, 0x000000ffff177224ULL, 0x000fc800078e0015ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000910000047802ULL, 0x000fe40000000f00ULL, 0x0000966000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc8000000003dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x010fe200078ff0ffULL,
0x0000000003057220ULL, 0x004fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000002000207220ULL, 0x044fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001000107220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000003300337220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x000fe20000410000ULL, 0x0000002204227220ULL, 0x048fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x000fe20000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000400067811ULL, 0x040fe400078ff8ffULL, 0x0000000803157811ULL, 0x000fe400078ff0ffULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x00000006000a7811ULL, 0x000fc400078ff8ffULL,
0x0000000702007812ULL, 0x100fe400078e780dULL, 0x0000000706087812ULL, 0x040fe400078e780dULL,
0x0000000706067812ULL, 0x100fe200078e7815ULL, 0x000000080d077824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7815ULL, 0x0000100038007824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e780dULL, 0x0000000815137824ULL, 0x000fe200078e0206ULL,
0x000000070a0c7812ULL, 0x000fe200078e780dULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e7815ULL, 0x00000008150f7824ULL, 0x000fe200078e0202ULL,
0x000000070a0a7812ULL, 0x000fe200078e7815ULL, 0x0000080045027824ULL, 0x000fe200078e0200ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x000000080d097824ULL, 0x000fe200078e0205ULL,
0x0000001c1d05723eULL, 0x000fe200000000ffULL, 0x000000080d0b7824ULL, 0x000fc400078e0208ULL,
0x0000000815117824ULL, 0x000fe200078e0204ULL, 0x000000202104723eULL, 0x000fe200000000ffULL,
0x000000080d0d7824ULL, 0x000fe400078e020cULL, 0x0000000815157824ULL, 0x000fe200078e020aULL,
0x0000541004167816ULL, 0x000fe20000000005ULL, 0x0000001007077824ULL, 0x100fe400078e0202ULL,
0x0000001009097824ULL, 0x100fe400078e0202ULL, 0x000000100b0b7824ULL, 0x000fc400078e0202ULL,
0x000000100f0f7824ULL, 0x100fe400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x000fe400078e0202ULL, 0x0000000107087824ULL, 0x000fe200078e0206ULL,
0x000000141707723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x0000763204177816ULL, 0x000fe20000000005ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x000000102704723eULL, 0x000fe200000000ffULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000002b2405723eULL, 0x000fe200000000ffULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x0000001608007388ULL, 0x0005e20000000a00ULL, 0x00000001060d7824ULL, 0x000fc400078e020dULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x000fe200078e0215ULL,
0x000000181906723eULL, 0x000fc800000000ffULL, 0x0000541006167816ULL, 0x144fe40000000007ULL,
0x0000763206177816ULL, 0x000fe40000000007ULL, 0x0000541004087816ULL, 0x100fe40000000005ULL,
0x0000002f2806723eULL, 0x000fe200000000ffULL, 0x0000001609007388ULL, 0x0005e20000000a00ULL,
0x000000332c07723eULL, 0x000fe400000000ffULL, 0x0000763204097816ULL, 0x004fc40000000005ULL,
0x000000222304723eULL, 0x000fe400000000ffULL, 0x0000001e1f05723eULL, 0x000fe200000000ffULL,
0x000000080b007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fe20000000007ULL,
0x000000013a0b7824ULL, 0x000fe200078e0203ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x0000001a1b06723eULL, 0x000fe200000000ffULL, 0x000000100b0a7824ULL, 0x000fe200078e0200ULL,
0x000000250e07723eULL, 0x000fe200000000ffULL, 0x000000080d007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x004fc40000000005ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000000122904723eULL, 0x000fe200000000ffULL, 0x00000300ff127624ULL, 0x000fe200078e00ffULL,
0x0000002d2605723eULL, 0x000fe200000000ffULL, 0x000000080f007388ULL, 0x0005e60000000a00ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x0000541006087816ULL, 0x004fc40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000312a06723eULL, 0x000fe400000000ffULL,
0x000000372e07723eULL, 0x000fe200000000ffULL, 0x0000000811007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x144fe40000000005ULL, 0x0000763204097816ULL, 0x000fca0000000005ULL,
0x0000000813007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000815007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000a047984ULL, 0x000ea80000000c00ULL,
0x000400000a187984ULL, 0x000ee80000000c00ULL, 0x000800000a0c7984ULL, 0x000f280000000c00ULL,
0x000c00000a1c7984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x004fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x008fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x0000000f07077230ULL, 0x010fe40000000000ULL,
0x0000000e06067230ULL, 0x000fe40000000000ULL, 0x0000000d05057230ULL, 0x000fe40000000000ULL,
0x0000000c04047230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x020fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x000000040a007388ULL, 0x0005e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fca0000000000ULL,
0x000400180a007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f2000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ee20000002700ULL,
0x0000580012047a24ULL, 0x004fe200078e02ffULL, 0x0000000145ff7812ULL, 0x000fe2000780f832ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x0000660004077a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x0000040038067824ULL, 0x000fe200078e00ffULL, 0x000000000a147984ULL, 0x0005220000000c00ULL,
0x000000ff0300720cULL, 0x000fe20000725670ULL, 0x000058000e0e7a24ULL, 0x008fe200078e0205ULL,
0x000007ff07057811ULL, 0x000fc400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x000003000e047a24ULL, 0x000fca00078e02ffULL, 0x0000000404107c10ULL, 0x000fc8000fffe0ffULL,
0x0000001005087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000006080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x014fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x000fe200078e0207ULL,
0x00000070080f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c09117812ULL, 0x000fe200078ec0ffULL,
0x00006c0010087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007a1e00fULL, 0x0000000a110a7210ULL, 0x000fe40007c7e00fULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000003c08007986ULL, 0x0005e8000c101906ULL, 0x0000003d0a007986ULL, 0x0005e4000c101906ULL,
0x0000000000007941ULL, 0x014fea0003800000ULL, 0x000000140c007986ULL, 0x0005e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff120b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0800720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0007e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000f240000000000ULL,
0x000000ff0800720cULL, 0x010fda0003f05270ULL, 0x00002b7000008947ULL, 0x000fea0003800000ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x004fe200078e00ffULL, 0x00000001040a7810ULL, 0x008fe40007ffe0ffULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x000568000c1e1900ULL, 0x000000060a0d7981ULL, 0x000562000c1e1900ULL,
0x000000021200780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x004fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000562000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x004fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000562000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x004fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000562000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x004fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000562000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081200780cULL, 0x004fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000566000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000566000c1e1900ULL, 0x0000000712087810ULL, 0x004fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x008fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e000cULL, 0x00000008190e7824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000a1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x024fea0003800000ULL,
0x000000080e097810ULL, 0x040fe40007ffe0ffULL, 0x000000010e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000568000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e097810ULL, 0x044fe40007ffe0ffULL,
0x000000020e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000568000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e097810ULL, 0x044fe40007ffe0ffULL, 0x000000030e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000568000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e097810ULL, 0x044fe40007ffe0ffULL,
0x000000040e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000568000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e097810ULL, 0x044fe40007ffe0ffULL, 0x000000050e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000568000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e097810ULL, 0x044fe40007ffe0ffULL,
0x000000060e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000150c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000568000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e097810ULL, 0x044fe40007ffe0ffULL, 0x000000070e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000170c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000568000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e097810ULL, 0x004fe40007ffe0ffULL,
0x0000000b0c0c7209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000568000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x0000001003087824ULL, 0x00cfe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0208ULL,
0x0000000c09007388ULL, 0x0205e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003097824ULL, 0x004fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x0000000145107824ULL, 0x000fe200078e0204ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000800ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000070090a7812ULL, 0x008fe200078ec0ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0200ULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000001005087211ULL, 0x000fe200078fa8ffULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000010b307824ULL, 0x000fe200078e020aULL, 0x00000001350a7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fe200078e000dULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000002450b8824ULL, 0x140fe200078e0238ULL, 0x0000000608087210ULL, 0x000fe20007f3e0ffULL,
0x00000002450d8824ULL, 0x000fe200078e0238ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000080035357824ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000020b0c8824ULL, 0x100fe200078e020aULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020d128824ULL, 0x000fe200078e020aULL, 0x00000800350a7812ULL, 0x000fe200078ec0ffULL,
0x00000001070e8824ULL, 0x000fe200078e0210ULL, 0x00000020030d7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000030307984ULL, 0x000ea20000000800ULL,
0x00000080ff118424ULL, 0x000fc400078e00ffULL, 0x000000013b0a7824ULL, 0x000fe400078e020aULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000030045007a0cULL, 0x000fe20003f26070ULL,
0x00006c000e0e8625ULL, 0x000fc800078e000fULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x000000080c158824ULL, 0x100fe400078e0203ULL, 0x0000000812128824ULL, 0x000fe400078e0203ULL,
0x0000001003137824ULL, 0x000fe200078e020aULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000010030a7825ULL, 0x000fe200078e0008ULL, 0x0000418012178811ULL, 0x000fc600078e20ffULL,
0x000000100d0c7825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0007e2000b901c46ULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x00000010030e8825ULL, 0x040fe200078e000eULL, 0x003800000c137faeULL, 0x0009e6000b901c46ULL,
0x0000001003108825ULL, 0x000fe200078e0010ULL, 0x000000000e158faeULL, 0x000be6000b901c46ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000000010178faeULL, 0x0003e2000b901c46ULL,
0x00000000000a7805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x004fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e0045ULL, 0x0000000232337810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030033007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x040fe20003f24070ULL,
0x00000001042e7824ULL, 0x100fe200078e0233ULL, 0x00000001ff287819ULL, 0x000fe20000011633ULL,
0x00000800ff347424ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x000fe20007ffe0ffULL,
0x00000400332a7824ULL, 0x000fe200078e00ffULL, 0x0000002e05297211ULL, 0x000fe400078fa8ffULL,
0x00000001282c7812ULL, 0x000fc600078ec0ffULL, 0x00006c0029287625ULL, 0x000fc800078e0034ULL,
0x00000002452d9824ULL, 0x140fe200078e0238ULL, 0x0000000628287210ULL, 0x000fe20007f1e0ffULL,
0x00000002452f9824ULL, 0x000fe400078e0238ULL, 0x000000022d349824ULL, 0x100fe400078e022cULL,
0x000000022f3c9824ULL, 0x000fe200078e022cULL, 0x000008002a2c7812ULL, 0x000fe200078ec0ffULL,
0x00000001072b9824ULL, 0x000fe400078e022eULL, 0x00000080ff369424ULL, 0x000fc400078e00ffULL,
0x00000080ff2f9424ULL, 0x000fe400078e00ffULL, 0x00006c002b2a9625ULL, 0x000fc800078e0036ULL,
0x000000013b2c7824ULL, 0x000fe400078e022cULL, 0x000000ffff297224ULL, 0x000fe400000e0629ULL,
0x00006c002e2e9625ULL, 0x000fc800078e002fULL, 0x0000001003357824ULL, 0x040fe400078e022cULL,
0x0000000834349824ULL, 0x000fe400078e0203ULL, 0x00000010032c9825ULL, 0x000fc800078e002aULL,
0x000000083c399824ULL, 0x000fe400078e0203ULL, 0x00000010372a7825ULL, 0x100fe200078e0028ULL,
0x0000458034379811ULL, 0x000fe400078e20ffULL, 0x0000418039399811ULL, 0x000fe200078e20ffULL,
0x0000001003287825ULL, 0x000fc800078e0028ULL, 0x00000010032e9825ULL, 0x000fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000028357faeULL, 0x0003e8000b901c46ULL,
0x003800002a357faeULL, 0x0003e8000b901c46ULL, 0x000000002c379faeULL, 0x0003e8000b901c46ULL,
0x000000002e399faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0032ULL,
0x00000001ff2a7819ULL, 0x100fe20000011603ULL, 0x00000002452b7824ULL, 0x000fe200078e0238ULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000402d287824ULL, 0x000fe200078e00ffULL,
0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL, 0x0000001003297824ULL, 0x000fe200078e00ffULL,
0x00000007353c7812ULL, 0x040fe200078ec0ffULL, 0x00000008352f7824ULL, 0x040fe200078e00ffULL,
0x0000008028287812ULL, 0x000fe200078ec0ffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x0000007029297812ULL, 0x000fc400078ec0ffULL, 0x00000035ff3e7212ULL, 0x000fe200078e33ffULL,
0x000001002b287824ULL, 0x000fc600078e0028ULL, 0xfffffff8373e7812ULL, 0x000fe400078ee23eULL,
0x000000282a2a7210ULL, 0x000fe20007ffe029ULL, 0x0000000835297824ULL, 0x000fe200078e00ffULL,
0xfffffff82f287812ULL, 0x000fe200078ee23cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002a2b7984ULL, 0x000e620000000800ULL, 0x00000001292c7812ULL, 0x140fe400078ef63cULL,
0x00000002292e7812ULL, 0x140fe200078ef63cULL, 0x004580002a4e7984ULL, 0x0004e20000000800ULL,
0x0000000329327812ULL, 0x140fe400078ef63cULL, 0x0000000429347812ULL, 0x140fe400078ef63cULL,
0x0000000529367812ULL, 0x140fe400078ef63cULL, 0x00000006293c7812ULL, 0x000fe200078ef63cULL,
0x000004002d297824ULL, 0x000fe200078e00ffULL, 0x0000000835377810ULL, 0x000fc80007ffe0ffULL,
0x00000800292a7812ULL, 0x004fe200078ec0ffULL, 0x0000000837427824ULL, 0x040fe200078e00ffULL,
0x00000007372d7812ULL, 0x040fe200078ec0ffULL, 0x0000000837407824ULL, 0x000fe200078e00ffULL,
0x000001803b297810ULL, 0x000fe20007ffe02aULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0xfffffff8422a7812ULL, 0x100fe400078ee22dULL, 0x0000000140427812ULL, 0x000fe200078ef62dULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000240447812ULL, 0x000fe200078ef62dULL,
0x000000103e3e7824ULL, 0x000fe200078e0229ULL, 0x0000000340467812ULL, 0x000fe200078ef62dULL,
0x000000102c2c7824ULL, 0x000fe200078e0229ULL, 0x0000000440487812ULL, 0x000fe200078ef62dULL,
0x0000001032327824ULL, 0x000fe200078e0229ULL, 0x00000005404a7812ULL, 0x000fe200078ef62dULL,
0x000000102e2e7824ULL, 0x000fe200078e0229ULL, 0x0000000640407812ULL, 0x000fe200078ef62dULL,
0x0000001036367824ULL, 0x100fe200078e0229ULL, 0x00000037ff4c7212ULL, 0x000fe200078e33ffULL,
0x0000001034347824ULL, 0x000fe200078e0229ULL, 0x0000002b302b7221ULL, 0x002fe20000010100ULL,
0x000000103c3c7824ULL, 0x100fe200078e0229ULL, 0xfffffff8394c7812ULL, 0x000fe200078ee24cULL,
0x000000102a2a7824ULL, 0x000fe200078e0229ULL, 0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL,
0x00000004032b7824ULL, 0x000fc400078e00ffULL, 0x0000001042427824ULL, 0x100fe400078e0229ULL,
0x0000001044447824ULL, 0x100fe200078e0229ULL, 0x0000000c2b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x0000001046467824ULL, 0x100fe400078e0229ULL,
0x0000001048487824ULL, 0x000fe400078e0229ULL, 0x0000000128287824ULL, 0x000fe400078e022bULL,
0x000000012b3e7824ULL, 0x000fc400078e023eULL, 0x000000012b2c7824ULL, 0x040fe400078e022cULL,
0x0000000028287984ULL, 0x000e620000000800ULL, 0x000000012b327824ULL, 0x040fe400078e0232ULL,
0x000000012b2e7824ULL, 0x040fe200078e022eULL, 0x000000003e3e7984ULL, 0x000ea20000000800ULL,
0x000000012b367824ULL, 0x000fe200078e0236ULL, 0x0000004e2f507220ULL, 0x008fe20000410000ULL,
0x000000012b347824ULL, 0x040fe200078e0234ULL, 0x000000002c2c7984ULL, 0x000fe20000000800ULL,
0x000000012b3c7824ULL, 0x040fe200078e023cULL, 0x0000003150317221ULL, 0x000fe20000010000ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x000000012b427824ULL, 0x000fc400078e0242ULL, 0x000000012b447824ULL, 0x040fe200078e0244ULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x000000012b467824ULL, 0x040fe400078e0246ULL,
0x000000104a4a7824ULL, 0x100fe200078e0229ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x0000001040407824ULL, 0x100fe400078e0229ULL, 0x000000104c4c7824ULL, 0x000fe200078e0229ULL,
0x00001f35502d7589ULL, 0x000ee200000e0000ULL, 0x000000012b487824ULL, 0x000fc400078e0248ULL,
0x000000012b4a7824ULL, 0x040fe200078e024aULL, 0x0000000034347984ULL, 0x000f220000000800ULL,
0x000000012b407824ULL, 0x040fe400078e0240ULL, 0x000000012b4c7824ULL, 0x000fe200078e024cULL,
0x000000003c3c7984ULL, 0x000f680000000800ULL, 0x000000002a2a7984ULL, 0x000f680000000800ULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x20000028ff4e7230ULL, 0x002fc40000004100ULL,
0x30000028ff2b7230ULL, 0x000fe20000004100ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x2000003eff287230ULL, 0x104fe40000004100ULL, 0x3000003eff2f7230ULL, 0x000fe20000004100ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000002d2b267223ULL, 0x088fe20000010026ULL,
0x0000002d28197223ULL, 0x080fe20000010019ULL, 0x2000002cff287230ULL, 0x100fe20000004100ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x3000002cff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2f187223ULL, 0x080fe20000010018ULL, 0x0000002d4e277223ULL, 0x080fe20000010027ULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x0000002d28257223ULL, 0x080fe20000010025ULL,
0x20000032ff287230ULL, 0x000fe20000004100ULL, 0x0000002d2b247223ULL, 0x000fe20000010024ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x3000002eff2f7230ULL, 0x000fc40000004100ULL,
0x0000002d28217223ULL, 0x080fe20000010021ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x30000032ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2f227223ULL, 0x080fe20000010022ULL,
0x20000036ff287230ULL, 0x000fe20000004100ULL, 0x00001f3750297589ULL, 0x000ea200000e0000ULL,
0x2000002eff2c7230ULL, 0x000fe20000004100ULL, 0x0000002d2b207223ULL, 0x080fe20000010020ULL,
0x30000034ff2f7230ULL, 0x010fe20000004100ULL, 0x0000002d281d7223ULL, 0x080fe2000001001dULL,
0x30000036ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2c237223ULL, 0x080fe20000010023ULL,
0x2000003cff287230ULL, 0x020fe20000004100ULL, 0x0000002d2f1e7223ULL, 0x080fe2000001001eULL,
0x20000034ff2c7230ULL, 0x000fe20000004100ULL, 0x0000002d2b1c7223ULL, 0x080fe2000001001cULL,
0x3000003cff2f7230ULL, 0x000fe20000004100ULL, 0x0000002d281b7223ULL, 0x080fe2000001001bULL,
0x3000002aff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2c1f7223ULL, 0x080fe2000001001fULL,
0x20000042ff287230ULL, 0x000fe20000004100ULL, 0x0000002d2f1a7223ULL, 0x000fe2000001001aULL,
0x000000ffff327224ULL, 0x000fc400078e0033ULL, 0x2000002aff2c7230ULL, 0x000fe40000004100ULL,
0x20000044ff2a7230ULL, 0x102fe20000004100ULL, 0x0000030032007a0cULL, 0x000fe20003f06070ULL,
0x30000044ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292b167223ULL, 0x084fe20000010016ULL,
0x0000002928157223ULL, 0x080fe20000010015ULL, 0x30000042ff2b7230ULL, 0x000fe20000004100ULL,
0x000000292a137223ULL, 0x080fe20000010013ULL, 0x20000046ff287230ULL, 0x000fe20000004100ULL,
0x000000292d127223ULL, 0x080fe20000010012ULL, 0x30000048ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292b147223ULL, 0x080fe20000010014ULL, 0x30000046ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002928117223ULL, 0x080fe20000010011ULL, 0x20000048ff287230ULL, 0x000fe20000004100ULL,
0x000000292d0e7223ULL, 0x080fe2000001000eULL, 0x2000004aff2a7230ULL, 0x100fe20000004100ULL,
0x000000292b107223ULL, 0x080fe20000010010ULL, 0x3000004aff2b7230ULL, 0x000fe20000004100ULL,
0x00000029280f7223ULL, 0x080fe2000001000fULL, 0x20000040ff287230ULL, 0x100fe20000004100ULL,
0x000000292a0d7223ULL, 0x080fe2000001000dULL, 0x30000040ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292c177223ULL, 0x080fe20000010017ULL, 0x2000004cff2a7230ULL, 0x100fe20000004100ULL,
0x000000292b0c7223ULL, 0x080fe2000001000cULL, 0x3000004cff2f7230ULL, 0x000fe20000004100ULL,
0x00000029280b7223ULL, 0x080fe2000001000bULL, 0x000000292d0a7223ULL, 0x080fe2000001000aULL,
0x000000292a097223ULL, 0x000fc40000010009ULL, 0x000000292f087223ULL, 0x000fe20000010008ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x004fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff3800720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103057824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c03067812ULL, 0x000fc600078ec0ffULL, 0x0000008045037824ULL, 0x000fc800078e0204ULL,
0x0000000106047824ULL, 0x000fca00078e0203ULL, 0x0049803104007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800005037984ULL, 0x000ea80000000800ULL, 0x004a000005047984ULL, 0x002e620000000800ULL,
0x00000003ff037221ULL, 0x004fc80000010000ULL, 0x0000000403037221ULL, 0x002fca0000010000ULL,
0x0180000003047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0003ULL,
0x0000bf8000047802ULL, 0x000fe40000000f00ULL, 0x000067e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300047308ULL, 0x000e640000001000ULL, 0xbf80000003057423ULL, 0x002fc80000000004ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000504047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803287811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2b7819ULL, 0x000fe40000011603ULL, 0x00000028ff297212ULL, 0x000fe200078e33ffULL,
0x00001f2804067589ULL, 0x000ea200000e0000ULL, 0x00000008282a7824ULL, 0x000fc400078e00ffULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0x00001f2b04057589ULL, 0x00072400000e0000ULL,
0xfffffff82a297812ULL, 0x000fca00078ee229ULL, 0x0000001029297824ULL, 0x000fe200078e0202ULL,
0x0000002bff047212ULL, 0x008fc800078e33ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee204ULL,
0x000000072b047812ULL, 0x040fe200078ec0ffULL, 0x0000001706177220ULL, 0x044fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000001206127220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000000c060c7220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000a060a7220ULL, 0x040fe20000410000ULL, 0x0000000906097220ULL, 0x040fe20000410000ULL,
0x0000000806067220ULL, 0x000fe20000410000ULL, 0x000000082b087824ULL, 0x000fe200078e00ffULL,
0x0000002105217220ULL, 0x050fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x000fe20000410000ULL,
0xfffffff808057812ULL, 0x000fc400078ee22bULL, 0x0000000104087812ULL, 0x040fe400078e3cffULL,
0x00000002042a7812ULL, 0x040fe200078e3cffULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x00000003042c7812ULL, 0x040fe200078e3cffULL, 0x000000082b077824ULL, 0x000fe200078e0208ULL,
0x00000004042e7812ULL, 0x040fe400078e3cffULL, 0x0000000504307812ULL, 0x040fe200078e3cffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x0000000604047812ULL, 0x000fc400078e3cffULL,
0x000000212020723eULL, 0x000fe400000000ffULL, 0x0000000728217812ULL, 0x000fe400078ec0ffULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x000000082b117824ULL, 0x000fe200078e0204ULL,
0x0000001f1e1e723eULL, 0x000fe400000000ffULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001011117824ULL, 0x000fe200078e0202ULL, 0x000000171616723eULL, 0x000fc400000000ffULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000828137824ULL, 0x000fe200078e00ffULL,
0x0000000121047812ULL, 0x040fe400078e3cffULL, 0x0000000221087812ULL, 0x040fe400078e3cffULL,
0x0000000321177812ULL, 0x040fe400078e3cffULL, 0x00000004211d7812ULL, 0x040fe400078e3cffULL,
0x00000005211f7812ULL, 0x000fc400078e3cffULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000000403237824ULL, 0x000fe200078e00ffULL, 0x0000000621217812ULL, 0x000fe200078e3cffULL,
0x00000008281d7824ULL, 0x000fe200078e021dULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x00000008281b7824ULL, 0x000fe200078e0217ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000000828197824ULL, 0x000fe200078e0208ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000000828157824ULL, 0x000fe200078e0204ULL, 0x000000090606723eULL, 0x000fe200000000ffULL,
0x000000082b097824ULL, 0x000fe200078e022aULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x00000008281f7824ULL, 0x040fe200078e021fULL, 0xfffffff813137812ULL, 0x000fe200078ee228ULL,
0x0000000828217824ULL, 0x000fe200078e0221ULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x000000082b0b7824ULL, 0x000fe200078e022cULL, 0x0000000c23287812ULL, 0x000fe200078ec0ffULL,
0x000000082b0d7824ULL, 0x040fe200078e022eULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082b0f7824ULL, 0x000fe200078e0230ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x000000100b0b7824ULL, 0x000fc400078e0202ULL, 0x0000000128057824ULL, 0x040fe400078e0205ULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe200078e0202ULL,
0x0000002605007388ULL, 0x0005e20000000800ULL, 0x0000000128077824ULL, 0x040fe400078e0207ULL,
0x0000000128097824ULL, 0x040fe400078e0209ULL, 0x000000102d047824ULL, 0x000fe200078e0202ULL,
0x0000002407007388ULL, 0x000fe20000000800ULL, 0x00000001280b7824ULL, 0x000fc400078e020bULL,
0x0000001013087824ULL, 0x100fe200078e0202ULL, 0x0000002209007388ULL, 0x000fe20000000800ULL,
0x00000001280d7824ULL, 0x040fe400078e020dULL, 0x0000001015177824ULL, 0x100fe200078e0202ULL,
0x000000200b007388ULL, 0x000fe20000000800ULL, 0x00000001280f7824ULL, 0x040fe400078e020fULL,
0x0000001019197824ULL, 0x000fe200078e0202ULL, 0x0000001e0d007388ULL, 0x000fe20000000800ULL,
0x0000000128117824ULL, 0x000fc400078e0211ULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x0000001c0f007388ULL, 0x000fe20000000800ULL, 0x0000000128137824ULL, 0x040fe400078e0204ULL,
0x000000101d1d7824ULL, 0x000fe200078e0202ULL, 0x0000001a11007388ULL, 0x000fe20000000800ULL,
0x0000000128157824ULL, 0x040fe400078e0208ULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x0000001813007388ULL, 0x000fe20000000800ULL, 0x0000000128177824ULL, 0x000fc400078e0217ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000001615007388ULL, 0x000fe20000000800ULL,
0x0000000128197824ULL, 0x040fe400078e0219ULL, 0x00000001281b7824ULL, 0x040fe200078e021bULL,
0x0000001417007388ULL, 0x000fe20000000800ULL, 0x00000001281d7824ULL, 0x040fe400078e021dULL,
0x00000001281f7824ULL, 0x040fe200078e021fULL, 0x0000001219007388ULL, 0x000fe20000000800ULL,
0x0000000128217824ULL, 0x000fc400078e0221ULL, 0x0000000128297824ULL, 0x000fe200078e0229ULL,
0x000000101b007388ULL, 0x000fe20000000800ULL, 0x000000013a057824ULL, 0x004fc600078e0203ULL,
0x0000000e1d007388ULL, 0x000fe20000000800ULL, 0x0000001005057824ULL, 0x000fc600078e0200ULL,
0x0000000c1f007388ULL, 0x000fe80000000800ULL, 0x0000000a21007388ULL, 0x000fe80000000800ULL,
0x0000000629007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000005247984ULL, 0x000ea80000000c00ULL, 0x00040000052c7984ULL, 0x000ee80000000c00ULL,
0x0008000005147984ULL, 0x000f280000000c00ULL, 0x000c000005307984ULL, 0x000f620000000c00ULL,
0x200000ff27277230ULL, 0x004fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000001727277230ULL, 0x010fe40000000000ULL, 0x0000001626267230ULL, 0x000fe40000000000ULL,
0x0000001525257230ULL, 0x000fe40000000000ULL, 0x0000001424247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x020fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000002405007388ULL, 0x0005e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c05007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4500720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000f220000002600ULL, 0x00000003ff127819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f620000002700ULL, 0x00000003ff047819ULL, 0x004fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000712027812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704067812ULL, 0x000fe400078e4811ULL,
0x0ffffff802057812ULL, 0x000fc400078ef803ULL, 0x0ffffff806077812ULL, 0x000fc600078ef811ULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fc600078e0200ULL,
0x0000000005087984ULL, 0x0084e80000000c00ULL, 0x00000000070c7984ULL, 0x0002e20000000c00ULL,
0x0000000810137824ULL, 0x050fe400078e00ffULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x020fe2000f8e023fULL, 0x0000000838107824ULL, 0x040fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee212ULL, 0x0000000838387824ULL, 0x000fe200078e00ffULL,
0xfffffff815047812ULL, 0x000fc400078ee204ULL, 0x0000000400027c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404007c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff810037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x004fe200000e06ffULL, 0x00005a0002047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x002fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fe400078240ffULL,
0x00005b0002057a11ULL, 0x000fc400000f4405ULL, 0x00005b0000077a11ULL, 0x000fe400008f4407ULL,
0xfffffff838117812ULL, 0x000fe200078ee211ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000431247824ULL, 0x000fe400078e0232ULL, 0xffffffffff257424ULL, 0x000fc600078e00ffULL,
0x000000032400720cULL, 0x000fda0003f06070ULL, 0x0000000227058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e0224ULL, 0x0000600006068625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606258981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082b7981ULL, 0x000762000c1e9900ULL,
0x00000001310b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004026267824ULL, 0x000fe400078e00ffULL,
0x0000004032287824ULL, 0x000fe200078e00ffULL, 0x000000020b00720cULL, 0x000fe20003f06070ULL,
0x00000040392a7824ULL, 0x000fc400078e00ffULL, 0x0000002625177224ULL, 0x004fd400078e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000010031077824ULL, 0x00afe200078e0228ULL,
0x00000002ff197819ULL, 0x100fe40000011633ULL, 0x00000003ff0e7819ULL, 0x000fe40000011633ULL,
0x0000000730007217ULL, 0x000fe20007800000ULL, 0x0000004039067824ULL, 0x000fe200078e0219ULL,
0x000000030e0e7812ULL, 0x000fe400078e4833ULL, 0x000000300a1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a07ULL, 0x0000000806077810ULL, 0x000fc40007ffe0ffULL,
0x0000001006087810ULL, 0x000fe40007ffe0ffULL, 0x0000000717077210ULL, 0x040fe40007f3e0ffULL,
0x0000000617147210ULL, 0x040fe40007f1e0ffULL, 0x0000000817087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007137a11ULL, 0x000fe200078238ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0014127a11ULL, 0x000fe200078038ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00005e00080f7a11ULL, 0x000fc400078438ffULL,
0x00005f0007157a11ULL, 0x000fe400008f3c0cULL, 0x0000001806077810ULL, 0x000fe40007ffe0ffULL,
0x000000001900720cULL, 0x000fe40003f66070ULL, 0x00005f0014147a11ULL, 0x000fe400000f3c09ULL,
0x00005f0008117a11ULL, 0x000fe400010f3c11ULL, 0x0000002006087810ULL, 0x000fc40007ffe0ffULL,
0x0000002806097810ULL, 0x040fe40007ffe0ffULL, 0x00000030060a7810ULL, 0x040fe40007ffe0ffULL,
0x00000038060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000100032107811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0e337812ULL, 0x000fe400078ef833ULL, 0x00000007170d7210ULL, 0x000fc40007f3e0ffULL,
0x000000121b067210ULL, 0x000fe20007f1e0ffULL, 0x0000001033337824ULL, 0x000fe200078e0210ULL,
0x0000000817187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078838ffULL, 0x000000ffff077224ULL, 0x000fe200000e0614ULL,
0x0000000917167210ULL, 0x000fe40007fde0ffULL, 0x00005f000d0d7a11ULL, 0x000fe400020f3c08ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006337faeULL, 0x0003e2000d901c46ULL,
0x0000001b13087210ULL, 0x000fc40007f7e0ffULL, 0x0000000a17147210ULL, 0x040fe40007f1e0ffULL,
0x0000000b17127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0x0000000819177810ULL, 0x000fe40007ffe0ffULL, 0x0000001b0f0a7210ULL, 0x080fe40007f9e0ffULL,
0x0000001019137810ULL, 0x000fe40007ffe0ffULL, 0x000000001700720cULL, 0x0c0fe20003f66070ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x00000018190f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0611ULL, 0x0000001b0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000413117824ULL, 0x040fe200078e00ffULL, 0x000000001300720cULL, 0x080fe20003f86070ULL,
0x000000040f157824ULL, 0x000fe200078e00ffULL, 0xfffffffc17077812ULL, 0x002fe200078ee20eULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e0018067a11ULL, 0x000fe200078438ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000000f00720cULL, 0x000fe20003fa6070ULL,
0x0000001007077824ULL, 0x000fe200078e0210ULL, 0xfffffffc110f7812ULL, 0x000fc400078ee20eULL,
0xfffffffc15117812ULL, 0x000fe400078ee20eULL, 0x00005f0018187a11ULL, 0x000fe200010f3c13ULL,
0x000000100f0f7824ULL, 0x100fe200078e0210ULL, 0x0000002019137810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x0000002819157810ULL, 0x040fe40007ffe0ffULL, 0x0000003019177810ULL, 0x040fe20007ffe0ffULL,
0x000000000a0f7faeULL, 0x0005e2000e101c46ULL, 0x0000003819197810ULL, 0x000fc40007ffe0ffULL,
0x000000001500720cULL, 0x080fe20003f66070ULL, 0x000000000c117faeULL, 0x0007e2000e901c46ULL,
0x000000001300720cULL, 0x080fe40003f46070ULL, 0x000000001700720cULL, 0x080fe20003f86070ULL,
0x0000000413077824ULL, 0x002fe200078e00ffULL, 0x000000001900720cULL, 0x000fe20003fa6070ULL,
0x0000000415097824ULL, 0x000fe400078e00ffULL, 0x00000004170b7824ULL, 0x004fe200078e00ffULL,
0xfffffffc07077812ULL, 0x000fc400078ee20eULL, 0xfffffffc09097812ULL, 0x100fe200078ee20eULL,
0x00000004190d7824ULL, 0x008fe200078e00ffULL, 0xfffffffc0b0b7812ULL, 0x000fe200078ee20eULL,
0x00000010070f7824ULL, 0x000fe400078e0210ULL, 0x000000ffff077224ULL, 0x000fe200030e06ffULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee20eULL, 0x0000001009117824ULL, 0x100fe200078e0210ULL,
0x00005e0016087a11ULL, 0x040fe200078c38ffULL, 0x000000100b137824ULL, 0x100fe400078e0210ULL,
0x000000100d157824ULL, 0x000fe200078e0210ULL, 0x00005f00160d7a11ULL, 0x000fe200030f3c07ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x0000001b06067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e00140a7a11ULL, 0x000fc400078038ffULL,
0x0000001b08087210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0618ULL,
0x00005e00120c7a11ULL, 0x000fe400078c38ffULL, 0x00005f00140b7a11ULL, 0x000fe400000f3c0bULL,
0x00005f0012007a11ULL, 0x000fe200030f3c09ULL, 0x000000ffff097224ULL, 0x000fe200008e060dULL,
0x0000001b0a0a7210ULL, 0x080fe20007f1e0ffULL, 0x00000000060f7faeULL, 0x0003e2000d101c46ULL,
0x0000001b0c0c7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000008117faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0d7224ULL, 0x000fc600008e0600ULL,
0x000000000a137faeULL, 0x0003e8000e101c46ULL, 0x000000000c157faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000002a33007211ULL, 0x04afe400078ff0ffULL,
0x0000000833137811ULL, 0x000fe400078ff0ffULL, 0x0000000017007210ULL, 0x000fe40007f1e0ffULL,
0x0000001833097811ULL, 0x000fc400078ff0ffULL, 0x00000003ff147819ULL, 0x000fe20000011633ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005e0000167a11ULL, 0x000fe200078038ffULL,
0x000000012a087824ULL, 0x000fe200078e0209ULL, 0x00000020330b7811ULL, 0x000fe200078ff0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0x00005f0000227a11ULL, 0x000fe200000f3c07ULL,
0x000000012a007824ULL, 0x040fe200078e0213ULL, 0x0000001033077811ULL, 0x040fe200078ff0ffULL,
0x000000012a0c7824ULL, 0x040fe200078e020bULL, 0x00000028330d7811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x00000030330f7811ULL, 0x000fe200078ff0ffULL,
0x000000012a067824ULL, 0x000fe200078e0207ULL, 0x0000000314147812ULL, 0x000fe200078e4833ULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x0000003833117811ULL, 0x000fe200078ff0ffULL,
0x000000040d157824ULL, 0x000fe200078e00ffULL, 0x0000000017207210ULL, 0x040fe20007fde0ffULL,
0x000000012a107824ULL, 0x040fe200078e020fULL, 0x00000006171c7210ULL, 0x000fe20007fbe0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc07067812ULL, 0x100fe200078ee214ULL,
0x000000012a0e7824ULL, 0x000fe200078e020dULL, 0x0000100032237811ULL, 0x000fe200078e68ffULL,
0x000000012a127824ULL, 0x000fe200078e0211ULL, 0xfffffffc09077812ULL, 0x100fe200078ee214ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x0000000c17187210ULL, 0x000fe20007f3e0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc15097812ULL, 0x100fe200078ee214ULL,
0x00000010071b7824ULL, 0x100fe200078e0223ULL, 0x00000008171a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b087812ULL, 0x100fe200078ee214ULL,
0x00000010091f7824ULL, 0x100fe200078e0223ULL, 0x00005e00201e7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0xfffffffc0f0b7812ULL, 0x100fe200078ee214ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001017107210ULL, 0x040fe20007f7e0ffULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x0000001217127210ULL, 0x000fe20007f9e0ffULL,
0x000000100b217824ULL, 0x000fe200078e0223ULL, 0x00005f0020207a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x00005e00180f7a11ULL, 0x000fe200078238ffULL,
0x00000010081d7824ULL, 0x000fe200078e0223ULL, 0xfffffffc110c7812ULL, 0x000fe200078ee214ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e001a0d7a11ULL, 0x000fc400078038ffULL,
0x0000000e170e7210ULL, 0x000fe40007f5e0ffULL, 0x000000300a2c7812ULL, 0x000fe400078ec0ffULL,
0x00005e001c0b7a11ULL, 0x000fe400078a38ffULL, 0xfffffffc13007812ULL, 0x000fe400078ee214ULL,
0x00005f0018187a11ULL, 0x000fe200008f3c07ULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x0ffffffc14337812ULL, 0x000fe200078ef833ULL, 0x0000001000177824ULL, 0x000fe200078e0223ULL,
0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005e0012147a11ULL, 0x000fe200078638ffULL, 0x0000001033337824ULL, 0x100fe200078e0223ULL,
0x000000162c067210ULL, 0x000fe20007f1e0ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x00005f001c1c7a11ULL, 0x000fc400028f3c11ULL, 0x00005e000e117a11ULL, 0x000fe400078238ffULL,
0x00005e0010137a11ULL, 0x000fe400078438ffULL, 0x00005f0012007a11ULL, 0x000fe200018f3c07ULL,
0x000000ffff077224ULL, 0x000fe200000e0622ULL, 0x00005f000e167a11ULL, 0x000fe400008f3c09ULL,
0x0000001e2c087210ULL, 0x000fe40007f1e0ffULL, 0x00005f0010157a11ULL, 0x000fe200010f3c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006337faeULL, 0x0003e2000b901c46ULL,
0x0000000b2c0a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0620ULL,
0x0000000d2c0c7210ULL, 0x000fc40007f5e0ffULL, 0x0000000f2c0e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e061cULL, 0x000000112c107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061aULL, 0x000000132c127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0618ULL, 0x000000142c147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0616ULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fe400028e0615ULL, 0x000000ffff157224ULL, 0x000fe200000e0600ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x00f60400ff077984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x002fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002032007824ULL, 0x002fc800078e0205ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff047f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000023100720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000297919ULL, 0x000e620000000000ULL, 0x3db504f32b2b7820ULL, 0x020fe20000410000ULL,
0x0000640027277a24ULL, 0x000fe200078e02ffULL, 0x0000f688322e7811ULL, 0x000fe200078e18ffULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0xffffffff02347810ULL, 0x000fe40007ffe0ffULL,
0x0000f608322f7811ULL, 0x000fe400078e28ffULL, 0x00000100312d7824ULL, 0x008fe200078e0228ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002d3000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x034fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0033ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x00000001002c7810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fc400078e0000ULL,
0x00000001ff367819ULL, 0x100fe2000001162cULL, 0x0000002625457224ULL, 0x020fe200078e02ffULL,
0x000000022c00780cULL, 0x040fe20003f06070ULL, 0x000000ffff007224ULL, 0x000fe200078e002cULL,
0x000000012c547812ULL, 0x000fe200078ec0ffULL, 0x0000030036377a24ULL, 0x000fca00078e0231ULL,
0x0000000137337810ULL, 0x000fc80007ffe0ffULL, 0x000000023300720cULL, 0x000fe40003f26070ULL,
0x0000000135337812ULL, 0x000fd600078e0cffULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff3f7819ULL, 0x002fe20000011629ULL, 0x0000010037377824ULL, 0x000fe400078e0228ULL,
0x0000000232467824ULL, 0x000fe200078e0233ULL, 0x000000103f4d7810ULL, 0x040fe20007ffe0ffULL,
0x000000012a2c7824ULL, 0x040fe200078e023fULL, 0x000000083f477810ULL, 0x040fe40007ffe0ffULL,
0x000000183f4f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a387824ULL, 0x040fe200078e024dULL,
0x0000002c453d7210ULL, 0x000fe20007f3e0ffULL, 0x000000012a367824ULL, 0x000fe200078e0247ULL,
0x00000037302c7217ULL, 0x000fe20007800000ULL, 0x00000004474b7824ULL, 0x000fe200078e00ffULL,
0x00000038453b7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200008e06ffULL,
0x0000003645397210ULL, 0x000fe20007f5e0ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a37ULL,
0x00005e003d367a11ULL, 0x000fe200078238ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078638ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e0039387a11ULL, 0x000fc400078438ffULL, 0x00005f003b3b7a11ULL, 0x000fe200018f3c3cULL,
0x000000012a3c7824ULL, 0x040fe200078e024fULL, 0x000000203f517810ULL, 0x040fe40007ffe0ffULL,
0x000000283f537810ULL, 0x040fe40007ffe0ffULL, 0x000000303f557810ULL, 0x040fe40007ffe0ffULL,
0x000000383f577810ULL, 0x000fe40007ffe0ffULL, 0x00005f003d377a11ULL, 0x000fe200008f3c40ULL,
0x000000012a3d7824ULL, 0x040fe200078e0251ULL, 0x00005f0039397a11ULL, 0x000fe200010f3c3eULL,
0x000000012a3e7824ULL, 0x040fe200078e0253ULL, 0x0000002c3f00720cULL, 0x000fe20003f46070ULL,
0x000000012a3f7824ULL, 0x040fe200078e0255ULL, 0x0000003c45447210ULL, 0x040fe20007f3e0ffULL,
0x000000012a407824ULL, 0x000fe200078e0257ULL, 0x0000003d45427210ULL, 0x000fc40007fbe0ffULL,
0x0000003e45417210ULL, 0x040fe20007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e06ffULL,
0x00000003ff3e7819ULL, 0x100fe40000011629ULL, 0x00005e00443c7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x0000003f45437210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e06ffULL, 0x0000004045457210ULL, 0x000fe20007f7e0ffULL,
0x0000000454407824ULL, 0x000fe200078e00ffULL, 0x000000033e507812ULL, 0x000fe200078e4829ULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005f00443d7a11ULL, 0x000fe200008f3c3dULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0000002c4700720cULL, 0x000fc40003f26070ULL,
0x0000100046467811ULL, 0x000fe400078e60ffULL, 0x0ffffffc50497812ULL, 0x100fe400078ef829ULL,
0xfffffffc40477812ULL, 0x000fe400078ee229ULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee250ULL,
0x0000001049497824ULL, 0x000fe200078e0246ULL, 0x00005e00423e7a11ULL, 0x000fe200078a38ffULL,
0x0000001047367825ULL, 0x000fe200078e0036ULL, 0x00005e0045447a11ULL, 0x000fc400078638ffULL,
0x00005f00423f7a11ULL, 0x000fe200028f3c3fULL, 0x000000104b4b7824ULL, 0x000fe200078e0246ULL,
0x00005e0043427a11ULL, 0x000fe200078838ffULL, 0x0000001047387825ULL, 0x000fe200078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036497faeULL, 0x0003e2000d101c46ULL,
0x00005e0041407a11ULL, 0x000fe400078a38ffULL, 0x00005f0045457a11ULL, 0x000fe200018f3c48ULL,
0x00000000384b7faeULL, 0x0005e2000c901c46ULL, 0x0000002c4d00720cULL, 0x0c0fe20003f26070ULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x0000002c4f00720cULL, 0x040fe20003f46070ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x00005f0043437a11ULL, 0x000fc400020f3c4aULL,
0x0000002c5100720cULL, 0x0c0fe20003f66070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x00005f0041417a11ULL, 0x000fe200028f3c4cULL, 0x0000001047367825ULL, 0x002fe200078e003aULL,
0x0000002c5300720cULL, 0x080fe40003f86070ULL, 0x0000002c5500720cULL, 0x080fe20003fa6070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x0000002c5700720cULL, 0x000fe20003fc6070ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0xfffffffc4d497812ULL, 0x100fe200078ee250ULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f4b7812ULL, 0x004fe200078ee250ULL,
0x0000001047387825ULL, 0x000fe200078e003cULL, 0xfffffffc514d7812ULL, 0x000fc400078ee250ULL,
0xfffffffc534f7812ULL, 0x000fe200078ee250ULL, 0x0000001049497824ULL, 0x000fe200078e0246ULL,
0xfffffffc55517812ULL, 0x000fe200078ee250ULL, 0x000000104b4b7824ULL, 0x000fe200078e0246ULL,
0xfffffffc57537812ULL, 0x000fe200078ee250ULL, 0x000000104d4d7824ULL, 0x000fe200078e0246ULL,
0x0000000036497faeULL, 0x0003e2000c901c46ULL, 0x00000010473a7825ULL, 0x000fc600078e003eULL,
0x00000000384b7faeULL, 0x0003e2000d101c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e0246ULL,
0x00000010473c7825ULL, 0x000fe200078e0040ULL, 0x000000003a4d7faeULL, 0x0003e6000d901c46ULL,
0x0000001051517824ULL, 0x000fe200078e0246ULL, 0x000000003c4f7faeULL, 0x0003e2000e101c46ULL,
0x00000010473e7825ULL, 0x000fc800078e0042ULL, 0x0000001053537824ULL, 0x000fe200078e0246ULL,
0x000000003e517faeULL, 0x0003e2000e901c46ULL, 0x0000001047407825ULL, 0x000fca00078e0044ULL,
0x0000000040537faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000000829477811ULL, 0x042fe200078ff0ffULL, 0x00000002323c7824ULL, 0x000fe200078e0233ULL,
0x0000002a292c7211ULL, 0x040fe200078ff0ffULL, 0x0000000454527824ULL, 0x000fe200078e00ffULL,
0x0000001029497811ULL, 0x000fe200078ff0ffULL, 0x000000012a367824ULL, 0x000fe200078e0247ULL,
0x000000452c377210ULL, 0x080fe20007f3e0ffULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0x00000018294b7811ULL, 0x000fe400078ff0ffULL, 0x00000045362c7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078238ffULL,
0x000000012a3e7824ULL, 0x000fe200078e024bULL, 0x00000020294d7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x00005e002c387a11ULL, 0x000fe200078438ffULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0x00000028294f7811ULL, 0x040fe200078ff0ffULL,
0x000000012a407824ULL, 0x000fe200078e024dULL, 0x00005f002c397a11ULL, 0x000fe200010f3c39ULL,
0x000000012a2c7824ULL, 0x040fe200078e0249ULL, 0x0000003029517811ULL, 0x040fe200078ff0ffULL,
0x000000012a427824ULL, 0x040fe200078e024fULL, 0x0000003829557811ULL, 0x000fe200078ff0ffULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x00005f0037377a11ULL, 0x000fe200008f3c3aULL,
0x000000012a447824ULL, 0x000fe200078e0251ULL, 0x000000452c3b7210ULL, 0x080fe20007fde0ffULL,
0x000000012a467824ULL, 0x000fe200078e0255ULL, 0x00000003ff3a7819ULL, 0x100fe20000011629ULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x000000453e3d7210ULL, 0x080fe20007fbe0ffULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x000010003c537811ULL, 0x000fe200078e60ffULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000033a3e7812ULL, 0x000fe200078e4829ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0x00000045403f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200030e06ffULL, 0x00005e003b3a7a11ULL, 0x000fc400078c38ffULL,
0x0000004542417210ULL, 0x080fe40007f3e0ffULL, 0x0000004544437210ULL, 0x080fe40007f5e0ffULL,
0x00000045462c7210ULL, 0x000fe40007f7e0ffULL, 0xfffffffc47427812ULL, 0x100fe400078ee23eULL,
0xfffffffc49447812ULL, 0x100fe200078ee23eULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0xfffffffc4b467812ULL, 0x100fe200078ee23eULL, 0x0000001042477824ULL, 0x100fe200078e0253ULL,
0xfffffffc4d487812ULL, 0x100fe200078ee23eULL, 0x0000001044497824ULL, 0x100fe200078e0253ULL,
0xfffffffc4f4a7812ULL, 0x100fe200078ee23eULL, 0x00000010464b7824ULL, 0x100fe200078e0253ULL,
0xfffffffc514c7812ULL, 0x100fe200078ee23eULL, 0x00000010484d7824ULL, 0x000fe200078e0253ULL,
0x0ffffffc3e407812ULL, 0x000fe200078ef829ULL, 0x000000104a4f7824ULL, 0x100fe200078e0253ULL,
0xfffffffc55507812ULL, 0x000fe200078ee23eULL, 0x000000ffff3e7224ULL, 0x000fe200028e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200030f3c3cULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e003d3c7a11ULL, 0x040fe200078a38ffULL, 0x0000001040577824ULL, 0x000fe200078e0253ULL,
0xfffffffc52557812ULL, 0x000fe200078ee229ULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x00005f003d3d7a11ULL, 0x000fe200028f3c3eULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078838ffULL, 0x0000001055367825ULL, 0x000fe200078e0036ULL,
0x00005e0041407a11ULL, 0x000fc400078238ffULL, 0x00005e0043427a11ULL, 0x000fe200078438ffULL,
0x0000001055387825ULL, 0x000fe200078e0038ULL, 0x00005e002c447a11ULL, 0x040fe200078638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036577faeULL, 0x0003e2000b901c46ULL,
0x00005f003f3f7a11ULL, 0x000fe200020f3c4aULL, 0x00000010553a7825ULL, 0x000fe200078e003aULL,
0x00005f0041417a11ULL, 0x000fe200008f3c48ULL, 0x0000000038477faeULL, 0x0003e2000b901c46ULL,
0x00005f0043437a11ULL, 0x000fe200010f3c46ULL, 0x00000010553c7825ULL, 0x040fe200078e003cULL,
0x00005f002c457a11ULL, 0x000fe200018f3c45ULL, 0x000000003a497faeULL, 0x0003e4000b901c46ULL,
0x00000010553e7825ULL, 0x000fc400078e003eULL, 0x000000003c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000001055407825ULL, 0x040fe400078e0040ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x000000104c517824ULL, 0x000fe400078e0253ULL, 0x0000001055427825ULL, 0x040fe200078e0042ULL,
0x00000000404f7faeULL, 0x0003e6000b901c46ULL, 0x0000001050537824ULL, 0x000fe200078e0253ULL,
0x0000000042517faeULL, 0x0003e2000b901c46ULL, 0x0000001055447825ULL, 0x000fca00078e0044ULL,
0x0000000044537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5400720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x00000004ff377424ULL, 0x002fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fe400078e00ffULL, 0x0000030037247a24ULL, 0x000fca00078e0224ULL,
0x000000032400720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x0000000227367824ULL, 0x000fc800078e0224ULL, 0x0000600036367625ULL, 0x000fca00078e0037ULL,
0x0000000636257981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002029387810ULL, 0x042fe20007ffe0ffULL,
0x0000000232447824ULL, 0x000fe200078e0235ULL, 0xfffffff829367812ULL, 0x040fe200078ec0ffULL,
0x000000084e2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ec0ffULL,
0x0000000736357812ULL, 0x100fe200078ef829ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x0000000738457812ULL, 0x000fe400078ef829ULL, 0x0000000729387812ULL, 0x000fc400078ec0ffULL,
0x00000001ff477819ULL, 0x000fe40000011635ULL, 0x00000001ff497819ULL, 0x000fe40000011645ULL,
0x0000100044447811ULL, 0x000fe400078e60ffULL, 0x0000000838377812ULL, 0x000fe400078ef829ULL,
0x0000000347477812ULL, 0x000fe400078ec0ffULL, 0x0000000349497812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003647387212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000036493c7212ULL, 0x000fc400078e3cffULL,
0x00000001364e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000435397824ULL, 0x000fe200078e0238ULL,
0x0000000236367810ULL, 0x000fe20007ffe0ffULL, 0x00000004453d7824ULL, 0x000fe400078e023cULL,
0x0000001039397824ULL, 0x100fe200078e0244ULL, 0x000000043600780cULL, 0x000fe20003f25270ULL,
0x000000103d3d7824ULL, 0x000fc800078e0244ULL, 0x000000003938783bULL, 0x000e680000000200ULL,
0x000000003d3c783bULL, 0x000ea20000000200ULL, 0x00000018ff427819ULL, 0x002fe2000001143aULL,
0x0001000039437824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011439ULL,
0x00000042005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011438ULL,
0x00000018ff4c7819ULL, 0x000fe4000001143bULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff4b7819ULL, 0x004fe2000001143cULL, 0x0000004100587306ULL, 0x0005e20000200c00ULL,
0x0000888039427816ULL, 0x042fe200000000ffULL, 0x0000010039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143dULL, 0x00000018ff487819ULL, 0x000fc4000001143eULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000004000547306ULL, 0x0003e20000200c00ULL,
0x0001000038417824ULL, 0x004fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc8000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003900597306ULL, 0x0005e20000200c00ULL,
0x0000888038407816ULL, 0x042fe200000000ffULL, 0x0000010038387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000004100537306ULL, 0x0003e20000200c00ULL,
0x000100003b397824ULL, 0x004fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004000527306ULL, 0x0004e20000200c00ULL, 0x000088803b417816ULL, 0x042fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003800557306ULL, 0x0003220000200c00ULL, 0x000088803a407816ULL, 0x004fce00000000ffULL,
0x00000040005a7306ULL, 0x0005e20000200c00ULL, 0x000100003a387824ULL, 0x002fe200078e00ffULL,
0x0000541052527816ULL, 0x008fe20000000053ULL, 0x000001003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003b00617306ULL, 0x0003e20000200c00ULL,
0x0000004e47407212ULL, 0x084fe400078e3cffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000004e494e7212ULL, 0x000fe400078e3cffULL, 0x0000541055537816ULL, 0x010fe20000000054ULL,
0x0000004200567306ULL, 0x000fe20000200c00ULL, 0x00000004353b7824ULL, 0x002fc400078e0240ULL,
0x00000004454d7824ULL, 0x000fe400078e024eULL, 0x000000103b3b7824ULL, 0x000fe400078e0244ULL,
0x000100003f4e7824ULL, 0x000fe200078e00ffULL, 0x0000004300577306ULL, 0x000e680000200c00ULL,
0x00000018ff4e7819ULL, 0x000fc8000001144eULL, 0x00000041005e7306ULL, 0x0005f00000200c00ULL,
0x00000038005b7306ULL, 0x0007220000200c00ULL, 0x000000003b40783bULL, 0x004ea20000000200ULL,
0x0000541056567816ULL, 0x002fc40000000057ULL, 0x0000541059577816ULL, 0x000fc80000000058ULL,
0x0000003a005d7306ULL, 0x0003220000200c00ULL, 0x000088803c387816ULL, 0x008fce00000000ffULL,
0x00000039005f7306ULL, 0x0006a20000200c00ULL, 0x000100003c3a7824ULL, 0x002fe200078e00ffULL,
0x000054105a5a7816ULL, 0x010fe2000000005bULL, 0x000001003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003800607306ULL, 0x0003e20000200c00ULL,
0x000088803d397816ULL, 0x008fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000054105d5b7816ULL, 0x000fc6000000005cULL, 0x0000003a00637306ULL, 0x0007220000200c00ULL,
0x000100003d387824ULL, 0x042fe200078e00ffULL, 0x000054105e5e7816ULL, 0x004fe2000000005fULL,
0x000001003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900647306ULL, 0x0003e20000200c00ULL, 0x000000104d3a7824ULL, 0x008fe200078e0244ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0001000042767824ULL, 0x000fe200078e00ffULL,
0x0000888041707816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011443ULL,
0x0000003800657306ULL, 0x0004e20000200c00ULL, 0x000100003e397824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fc40000011476ULL, 0x0000541060607816ULL, 0x010fe40000000063ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x0000003c00627306ULL, 0x0003e20000200c00ULL,
0x000000003a38783bULL, 0x004eae0000000200ULL, 0x0000003d00677306ULL, 0x0009e20000200c00ULL,
0x000088803e3c7816ULL, 0x042fe200000000ffULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000541064647816ULL, 0x008fc80000000065ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003c00667306ULL, 0x0003e20000200c00ULL, 0x000088803f3d7816ULL, 0x050fe200000000ffULL,
0x000001003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003d00687306ULL, 0x0007e20000200c00ULL, 0x00000018ff3c7819ULL, 0x002fce0000011440ULL,
0x0000003c006e7306ULL, 0x0003e20000200c00ULL, 0x00008880403d7816ULL, 0x008fce00000000ffULL,
0x0000003e006b7306ULL, 0x0007e20000200c00ULL, 0x00010000403c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff507819ULL, 0x004fe20000011438ULL, 0x0000010040407824ULL, 0x000fe200078e00ffULL,
0x0000888039547816ULL, 0x000fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011439ULL,
0x00000018ff6c7819ULL, 0x000fe20000011440ULL, 0x0000004d00697306ULL, 0x0002a20000200c00ULL,
0x00000018ff3e7819ULL, 0x008fc40000011441ULL, 0x0000002c29407211ULL, 0x000fe400078fe0ffULL,
0x000000042c2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000003e00747306ULL, 0x0007e20000200c00ULL,
0x00000018ff4d7819ULL, 0x002fce0000011442ULL, 0x0000003f006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3e7819ULL, 0x008fe4000001143cULL, 0x00000007403c7812ULL, 0x040fe400078e7837ULL,
0x0000000240407810ULL, 0x000fe40007ffe0ffULL, 0x0000541066667816ULL, 0x004fe20000000069ULL,
0x00000010373c7824ULL, 0x000fe200078e023cULL, 0x0000003d006a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3f7819ULL, 0x002fc4000001143bULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000740407812ULL, 0x000fc800078e7837ULL, 0x0000004d00787306ULL, 0x000fe20000200c00ULL,
0x00010000413d7824ULL, 0x044fe400078e00ffULL, 0x0000010041417824ULL, 0x000fe400078e00ffULL,
0x0000001037407824ULL, 0x000fe200078e0240ULL, 0x00000018ff727819ULL, 0x000fe4000001143dULL,
0x0000003f004d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000001040407824ULL, 0x000fcc00078e00ffULL, 0x0000003e00717306ULL, 0x0002b00000200c00ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x000000003c3c783bULL, 0x002e6e0000000200ULL,
0x0000004b004b7306ULL, 0x000f220000200c00ULL, 0x000054106a6a7816ULL, 0x004fce0000000071ULL,
0x0000006c00737306ULL, 0x0005e20000200c00ULL, 0x00005410615f7816ULL, 0x008fe2000000004cULL,
0x000000ffff4c7224ULL, 0x000fe400078e0054ULL, 0x0001000039547824ULL, 0x000fc800078e00ffULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x00008880426c7816ULL, 0x044fe200000000ffULL,
0x0000010042427824ULL, 0x000fe200078e00ffULL, 0x0000541062617816ULL, 0x010fe4000000004bULL,
0x000088803a4b7816ULL, 0x000fe400000000ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x0000007200757306ULL, 0x0009e20000200c00ULL, 0x000000523c04723cULL, 0x002fe20000001804ULL,
0x0000541067657816ULL, 0x008fcc000000004aULL, 0x0000004100777306ULL, 0x0002e20000200c00ULL,
0x0000888043727816ULL, 0x010fe200000000ffULL, 0x0001000038527824ULL, 0x000fe200078e00ffULL,
0x000054106b677816ULL, 0x004fe20000000048ULL, 0x000000ffff487224ULL, 0x000fe200078e004bULL,
0x000000563c08723cULL, 0x040fe20000001808ULL, 0x000100003a4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x0001000043417824ULL, 0x002fe200078e00ffULL, 0x00005410736b7816ULL, 0x000fe2000000006eULL,
0x0000010043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000005a3c0c723cULL, 0x000fe2000000180cULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x0000004e006d7306ULL, 0x0003220000200c00ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000541077717816ULL, 0x008fe40000000074ULL, 0x0000005e3c10723cULL, 0x000fe60000001810ULL,
0x00000042007b7306ULL, 0x0007220000200c00ULL, 0x00000018ff4e7819ULL, 0x002fe2000001143aULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x000054106f697816ULL, 0x004fc40000000046ULL,
0x000000603c14723cULL, 0x040fe40000001814ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000007600797306ULL, 0x000fe20000200c00ULL, 0x0000888038427816ULL, 0x048fe200000000ffULL,
0x0000010038387824ULL, 0x000fe200078e00ffULL, 0x0000541068687816ULL, 0x010fe4000000006dULL,
0x000000643c18723cULL, 0x000fe40000001818ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x00000041007d7306ULL, 0x000fe20000200c00ULL, 0x000054107b6d7816ULL, 0x000fc80000000078ULL,
0x000000663c1c723cULL, 0x040fe6000000181cULL, 0x0000004300767306ULL, 0x000fea0000200c00ULL,
0x000000683c20723cULL, 0x000fe60000001820ULL, 0x0000004200537306ULL, 0x0003e80000200c00ULL,
0x000100003b3c7824ULL, 0x000fc800078e00ffULL, 0x0000003800557306ULL, 0x0005e20000200c00ULL,
0x000000004040783bULL, 0x002e620000000200ULL, 0x00000018ff3c7819ULL, 0x000fcc000001143cULL,
0x0000003a003d7306ULL, 0x0007e20000200c00ULL, 0x0000010039387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000001003b3a7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000005400397306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x00000038004a7306ULL, 0x0005e20000200c00ULL, 0x0000006a4004723cULL, 0x002fee0000001804ULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000088803b387816ULL, 0x004fce00000000ffULL,
0x0000005100517306ULL, 0x000eb00000200c00ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x0000541053527816ULL, 0x002fce0000000052ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541076737816ULL, 0x004fce0000000051ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541055537816ULL, 0x008fce0000000050ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x000000524014723cULL, 0x000fee0000001814ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x0000541070707816ULL, 0x002fce0000000075ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054106c6c7816ULL, 0x004fe20000000079ULL, 0x000000704008723cULL, 0x040fec0000001808ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x008fe2000000007dULL,
0x0000006c400c723cULL, 0x040fec000000180cULL, 0x00000038003e7306ULL, 0x0003e40000200c00ULL,
0x000000724010723cULL, 0x000fec0000001810ULL, 0x0000003c003b7306ULL, 0x000ea20000200c00ULL,
0x000054104c387816ULL, 0x002fc40000000039ULL, 0x000054104a397816ULL, 0x000fca000000004fULL,
0x0000003a003a7306ULL, 0x000e640000200c00ULL, 0x000000384018723cULL, 0x000fe20000001818ULL,
0x000054103e3e7816ULL, 0x004fcc000000003bULL, 0x0000541048387816ULL, 0x000fe4000000004bULL,
0x000054103d397816ULL, 0x000fe4000000004eULL, 0x000054103a3f7816ULL, 0x002fca000000004dULL,
0x00000038401c723cULL, 0x040ff0000000181cULL, 0x0000003e4020723cULL, 0x000fe20000001820ULL,
0xfffff0e000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff357224ULL, 0x000fe200078e0033ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe14000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002e367f8cULL, 0x000fe2000c80043fULL,
0x000000162b3e7220ULL, 0x040fe20000410000ULL, 0x000000062b2c7220ULL, 0x040fe20000410000ULL,
0x0000000a2b387220ULL, 0x040fe20000410000ULL, 0x000004002e357984ULL, 0x000e620000000800ULL,
0x0000000b2b397220ULL, 0x040fe20000410000ULL, 0x0000000e2b3a7220ULL, 0x040fe20000410000ULL,
0x0000001c2b167220ULL, 0x040fe20000410000ULL, 0x000000042b047220ULL, 0x040fe20000410000ULL,
0x000000052b057220ULL, 0x040fe20000410000ULL, 0x000000072b077220ULL, 0x040fe20000410000ULL,
0x000000082b087220ULL, 0x040fe20000410000ULL, 0x000000092b097220ULL, 0x040fe20000410000ULL,
0x0000000c2b007220ULL, 0x040fe20000410000ULL, 0x0000000d2b067220ULL, 0x040fe20000410000ULL,
0x0000000f2b3b7220ULL, 0x040fe20000410000ULL, 0x000000122b3c7220ULL, 0x040fe20000410000ULL,
0x000000132b3d7220ULL, 0x040fe20000410000ULL, 0x000000172b3f7220ULL, 0x040fe20000410000ULL,
0x0000001a2b407220ULL, 0x040fe20000410000ULL, 0x0000001b2b417220ULL, 0x040fe20000410000ULL,
0x0000001e2b1c7220ULL, 0x040fe20000410000ULL, 0x0000001f2b427220ULL, 0x040fe20000410000ULL,
0x000000142b127220ULL, 0x040fe20000410000ULL, 0x000000152b137220ULL, 0x040fe20000410000ULL,
0x000000182b147220ULL, 0x040fe20000410000ULL, 0x000000192b157220ULL, 0x040fe20000410000ULL,
0x0000001d2b177220ULL, 0x040fe20000410000ULL, 0x000000202b187220ULL, 0x040fe20000410000ULL,
0x000000212b197220ULL, 0x040fe20000410000ULL, 0x000000222b437220ULL, 0x040fe20000410000ULL,
0x000000232b447220ULL, 0x040fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e002cULL,
0x000000102b107220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0038ULL,
0x000000112b117220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0039ULL,
0x000000ffff1f7224ULL, 0x000fe400078e003aULL, 0x000000ffff0b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0005ULL, 0x8000000035ff7812ULL, 0x002fe20007804837ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff207224ULL, 0x000fe400078e003bULL,
0x000000ffff217224ULL, 0x000fe400078e003cULL, 0x000000ffff227224ULL, 0x000fe400078e003dULL,
0x000000ffff237224ULL, 0x000fc400078e003eULL, 0x000000ffff2c7224ULL, 0x000fe400078e003fULL,
0x000000ffff357224ULL, 0x000fe400078e0040ULL, 0x000000ffff387224ULL, 0x000fe400078e0041ULL,
0x000000ffff397224ULL, 0x000fe400078e001cULL, 0x000000ffff3a7224ULL, 0x000fe200078e0042ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fc400078e0043ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0044ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004002e057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004291c7824ULL, 0x000fe200078e00ffULL, 0x000000343100720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008032007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000229087824ULL, 0x000fe400078e00ffULL, 0x00000001302d7824ULL, 0x000fc600078e0a2dULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108367812ULL, 0x040fe400078efcffULL,
0x00000008083e7812ULL, 0x000fe400078efcffULL, 0x0000002d3600720cULL, 0x080fe40003f26070ULL,
0x0000001008367812ULL, 0x000fe400078efcffULL, 0x0000002d3e00720cULL, 0x080fe40003f06070ULL,
0x0000002d3600720cULL, 0x000fc40003fc6070ULL, 0x00000011083e7812ULL, 0x040fe400078efcffULL,
0x0000001808367812ULL, 0x040fe400078efcffULL, 0x0000002d0800720cULL, 0x080fe40003f46070ULL,
0x0000002d3e00720cULL, 0x080fe40003fa6070ULL, 0x0000002d3600720cULL, 0x000fe40003f66070ULL,
0x0000000908407812ULL, 0x000fc400078efcffULL, 0x00000019083e7812ULL, 0x040fe400078efcffULL,
0x0000002008367812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000002d4000720cULL, 0x080fe40003f86070ULL,
0x0000002d3e00720cULL, 0x080fe40003f46070ULL, 0x0000002d3600720cULL, 0x000fe40003f26070ULL,
0x00000021083e7812ULL, 0x040fe400078efcffULL, 0x0000002808367812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002d3e00720cULL, 0x080fe40003f06070ULL, 0x0000002d3600720cULL, 0x000fe40003f86070ULL,
0x00000029083e7812ULL, 0x000fc400078efcffULL, 0x0000003008367812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002d3e00720cULL, 0x000fc40003fc6070ULL, 0x0000002d3600720cULL, 0x000fe40003fa6070ULL,
0x00000031083e7812ULL, 0x040fe400078efcffULL, 0x0000003808367812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002d3e00720cULL, 0x080fe40003f66070ULL,
0x0000002d3600720cULL, 0x000fc40003f46070ULL, 0x0000002d0800720cULL, 0x000fe40003f26070ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff38387808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff39397808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff3b3b7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002c05047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000003504057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000003805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000003904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003b04057209ULL, 0x000fe40007810000ULL,
0x0000001908377209ULL, 0x000fe40007810000ULL, 0x0000003c053d7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037047f89ULL, 0x0004e400000e0000ULL,
0x0000000437377209ULL, 0x00cfe20007810000ULL, 0x000017f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007367f89ULL, 0x000f2200000e0000ULL, 0x000000043d087209ULL, 0x004fc60007810000ULL,
0x0c201f0037047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000003607367209ULL, 0x010fc60007810000ULL,
0x0c201f00093e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f00362d7f89ULL, 0x00092200000e0000ULL,
0x0000000437047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3c003c00ff3e7424ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff3f7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3c197823ULL, 0x000fc80000010819ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000000ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003e0840723cULL, 0x000fee00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003e0c40723cULL, 0x000fee0000001840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc29147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000003500357308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x0000003800387308ULL, 0x000ea20000000800ULL,
0x000000232c11723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000353813723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000003e1040723cULL, 0x000fec0000001840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x000000362d077209ULL, 0x000fca0007810000ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000393a15723eULL, 0x002fe400000000ffULL,
0x0000003b1a17723eULL, 0x004fce00000000ffULL, 0x0000003e1440723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000132204008947ULL, 0x010fde000b800000ULL,
0x001c1fff40187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000134204008947ULL, 0x010fea000b800000ULL,
0x001c1fff42197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011629ULL,
0x0000000c1c417812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000329ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3e7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4e7824ULL, 0x000fe200078e00ffULL, 0x000000021f2c7812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f367812ULL, 0x000fc400078ef61eULL,
0x000000041f387812ULL, 0x140fe400078ef61eULL, 0x000000051f3a7812ULL, 0x140fe400078ef61eULL,
0x000000061f3c7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000321d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823407812ULL, 0x100fe400078ee21eULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee221ULL,
0x00000010201c7824ULL, 0x100fe200078e021dULL, 0x000000011f427812ULL, 0x140fe200078ef61eULL,
0x000000102c207824ULL, 0x100fe200078e021dULL, 0x000000021f447812ULL, 0x140fe200078ef61eULL,
0x00000010382c7824ULL, 0x100fe200078e021dULL, 0x000000031f467812ULL, 0x140fe200078ef61eULL,
0x000000103a357824ULL, 0x100fe200078e021dULL, 0x000000041f487812ULL, 0x140fe200078ef61eULL,
0x000000103e387824ULL, 0x100fe200078e021dULL, 0x000000051f4a7812ULL, 0x140fe200078ef61eULL,
0x00000010423a7824ULL, 0x100fe200078e021dULL, 0x000000061f4c7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001036227824ULL, 0x100fe400078e021dULL,
0x00000001411f7824ULL, 0x000fe400078e021cULL, 0x000000103c367824ULL, 0x100fe400078e021dULL,
0x00000010401c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010443b7824ULL, 0x100fe400078e021dULL, 0x00000010463c7824ULL, 0x000fc400078e021dULL,
0x00000010483d7824ULL, 0x100fe400078e021dULL, 0x000000104a3e7824ULL, 0x100fe400078e021dULL,
0x000000104c3f7824ULL, 0x100fe400078e021dULL, 0x000000104e407824ULL, 0x000fe400078e021dULL,
0x00000001411d7824ULL, 0x040fe400078e021eULL, 0x0000000141217824ULL, 0x000fc400078e0220ULL,
0x0000000141237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x00000001412d7824ULL, 0x040fe400078e022cULL, 0x0000000141357824ULL, 0x040fe200078e0235ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000141377824ULL, 0x040fe400078e0236ULL,
0x0000000141397824ULL, 0x040fe200078e0238ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001411c7824ULL, 0x000fc400078e021cULL, 0x00000001413a7824ULL, 0x040fe200078e023aULL,
0x000000102d007388ULL, 0x0007e20000000800ULL, 0x00000001411e7824ULL, 0x040fe400078e023bULL,
0x00000001413c7824ULL, 0x040fe200078e023cULL, 0x0000001235007388ULL, 0x0007e20000000800ULL,
0x0000000141087824ULL, 0x042fe400078e023dULL, 0x00000001413e7824ULL, 0x040fe200078e023eULL,
0x0000001437007388ULL, 0x0007e20000000800ULL, 0x0000000141207824ULL, 0x000fc400078e023fULL,
0x0000000141407824ULL, 0x000fe200078e0240ULL, 0x0000001639007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f3c007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x000000133e007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001740007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002fff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030031317a10ULL, 0x000fe20007ffe0ffULL,
0x000018002fff7f8cULL, 0x0003e6000c80043fULL, 0x000000023100720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc5f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0x00011a2000287802ULL, 0x000fe40000000f00ULL, 0x00000f3000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff008000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00011a7000287802ULL, 0x000fe40000000f00ULL,
0x00000ee000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff00b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff717224ULL, 0x000fe200078e0024ULL,
0x00011ae0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e006eULL, 0xffff010000007947ULL, 0x000fea000383ffffULL,
0x000000ffff717224ULL, 0x000fe200078e0024ULL, 0x00011b50002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff727424ULL, 0x000fc400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e006eULL,
0xffff00c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0x00011bc0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff617224ULL, 0x004fe200078e006eULL, 0xffff042000007947ULL, 0x000fea000383ffffULL,
0x000000ffff717224ULL, 0x002fe200078e0050ULL, 0x00011c30002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff727424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e006eULL,
0xffff03e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x010fe40004000000ULL,
0x00011c8000287802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff1f6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00011cd000287802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff1fa000007947ULL, 0x000fea000383ffffULL, 0x0000001fff727424ULL, 0x008fe200078e00ffULL,
0x00011d30002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e006eULL,
0xffff201000007947ULL, 0x000fea000383ffffULL, 0x000000ffff717224ULL, 0x00afe200078e0050ULL,
0x00011da0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e006eULL, 0xffff20c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff727424ULL, 0x000fe200078e00ffULL, 0x00011e00002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000b1000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6f7224ULL, 0x004fe200078e006eULL, 0xffff238000007947ULL, 0x000fea000383ffffULL,
0x000000ffff717224ULL, 0x002fe200078e0050ULL, 0x00011e70002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff727424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x00000aa000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e006eULL,
0xffff233000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe40004000000ULL,
0x00011ec000287802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff3c1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00011f1000287802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff3c5000007947ULL, 0x000fea000383ffffULL, 0x0000001fff727424ULL, 0x002fe200078e00ffULL,
0x00011f70002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e006eULL,
0xffff3cc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff717224ULL, 0x002fe200078e0050ULL,
0x00011fe0002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e006eULL, 0xffff3d7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff727424ULL, 0x000fe200078e00ffULL, 0x00012040002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff5d7224ULL, 0x004fe200078e006eULL, 0xffff402000007947ULL, 0x000fea000383ffffULL,
0x000000ffff717224ULL, 0x002fe200078e0050ULL, 0x000120b0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff727424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e006eULL,
0xffff3fd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe40004000000ULL,
0x0001210000287802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff588000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x0001215000287802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff58c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff727424ULL, 0x002fe200078e00ffULL,
0x000121b0002c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e006eULL,
0xffff593000007947ULL, 0x000fea000383ffffULL, 0x000000ffff717224ULL, 0x002fe200078e0050ULL,
0x00012220002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff727424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x000006f000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e006eULL, 0xffff59e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff727424ULL, 0x000fe200078e00ffULL, 0x00012280002c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff437224ULL, 0x004fe200078e006eULL, 0xffff5ca000007947ULL, 0x000fea000383ffffULL,
0x000000ffff717224ULL, 0x002fe200078e0050ULL, 0x000122f0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff727424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff507224ULL, 0x004fe200078e006eULL,
0xffff5c5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0037ULL,
0x0001235000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002dULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e003dULL,
0x000123b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x0000002d3d407209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x0001240000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3e7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0007ULL,
0x0001245000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002d07367209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0037ULL, 0x000124a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002d37047209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0040ULL,
0x000124f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002d40057209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x0001254000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0036ULL,
0x0001259000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x000fe200078e0040ULL, 0x00012600002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff717224ULL, 0x000fc400078e00ffULL, 0x00001c1fff727424ULL, 0x000fe400078e00ffULL,
0x000000ffff737224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e006eULL, 0xffffec7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0042ULL, 0x00012680002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff717224ULL, 0x000fe400078e00ffULL, 0x00001c1fff727424ULL, 0x000fe400078e00ffULL,
0x000000ffff737224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff717224ULL, 0x002fe200078e00ffULL, 0x000126e0002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff727424ULL, 0x000fc400078e00ffULL, 0x000000ffff737224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e006eULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff737224ULL, 0x002fe200078e001dULL, 0x00012740002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff717224ULL, 0x000fe400078e00ffULL, 0x00001c1fff727424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e006eULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e006eULL, 0xffffebb000007947ULL, 0x000fea000383ffffULL,
0x018000003d037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003d00038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000306ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3dff7812ULL, 0x040fe4000780c0ffULL, 0x800000003d057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003d00037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffed73004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003e2d2d7389ULL, 0x0002a200000e003fULL,
0xfffed6f008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000007300007348ULL, 0x000fe80003800000ULL, 0x00000071706e7389ULL, 0x0002a200000e0072ULL,
0xfffed6b02c007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f05070ULL,
0x0000004f00007348ULL, 0x000fe80003800000ULL, 0x00000000ff257424ULL, 0x000fd000078e00ffULL,
0x0000000000247806ULL, 0x000fc800040e0100ULL, 0x0000004f24267212ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fc800078e0028ULL, 0xfffed64024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000370ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000950ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009e0ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001260ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001290ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012b0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001340ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001348ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001358ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000012a80ULL, 0xa400001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014010ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014490ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001340ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012cc0ULL, 0x0000000000012cc0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014490ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 83312;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
