/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014610ULL, 0x0000000000014190ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000012890ULL, 0x0000000000000190ULL,
0x000e002200000106ULL, 0x0000000000012a20ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000012a60ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000012aa0ULL,
0x0000000000000160ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012c00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001289000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0048e00400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9208288080820828ULL, 0x288080a208288080ULL, 0x80a608288080a408ULL, 0x08288080a7082880ULL,
0x8080aa08288080a8ULL, 0xaf08288080ad0828ULL, 0x288080b008288080ULL, 0x80be08288080b708ULL,
0x08288080ef082880ULL, 0x8082801628808086ULL, 0x0000000000031028ULL, 0x2880808692000000ULL,
0x0000000000002200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001289000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808086ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8b08288080820828ULL,
0x2880808e08288080ULL, 0x80a2082880809208ULL, 0x08288080a4082880ULL, 0x8080a708288080a6ULL,
0xaa08288080a80828ULL, 0x288080ad08288080ULL, 0x80b708288080b008ULL, 0x08288080ef082880ULL,
0x8082801628808088ULL, 0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000014800000000ULL, 0x00012a2000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080820828ULL,
0x2880808b08288080ULL, 0x8092082880808e08ULL, 0x08288080a2082880ULL, 0x8080a708288080a4ULL,
0xaa08288080a80828ULL, 0x288080ad08288080ULL, 0x80b708288080b008ULL, 0x08288080ef082880ULL,
0x80828016288080a6ULL, 0x0000000000031028ULL, 0x288080a692000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000020800000000ULL, 0x00012a6000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080820828ULL,
0x2880808b08288080ULL, 0x8092082880808e08ULL, 0x08288080a2082880ULL, 0x8080a608288080a4ULL,
0xaa08288080a80828ULL, 0x288080ad08288080ULL, 0x80b708288080b008ULL, 0x08288080ef082880ULL,
0x80828016288080a7ULL, 0x0000000000031028ULL, 0x288080a792000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000002c800000000ULL, 0x00012aa000000000ULL, 0x0000016000000000ULL,
0x0000140400000000ULL, 0x80a4288080a70900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000a3ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000110d000010c40ULL, 0x00011250000110e0ULL,
0x0001127000011260ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000020ffffffffULL, 0x0500002005000020ULL, 0xffffffff05000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x00000110000000f0ULL, 0x00001b3000001ab0ULL,
0x00001c2000001bf0ULL, 0x0000202000001ff0ULL, 0x000020e000002080ULL, 0x00003c8000003bf0ULL,
0x00003e7000003d50ULL, 0x000041b000004190ULL, 0x0000427000004210ULL, 0x00005b6000005ad0ULL,
0x00005d5000005c30ULL, 0x0000608000006060ULL, 0x00006140000060e0ULL, 0x000079f000007960ULL,
0x00007be000007ac0ULL, 0x00007f2000007f00ULL, 0x00007fe000007f80ULL, 0x000091e0000091d0ULL,
0x0000ba300000b790ULL, 0x0000c0500000c020ULL, 0x00010b4000010b10ULL, 0x00010b6000010b50ULL,
0x00010ba000010b80ULL, 0x00010bd000010bc0ULL, 0x000112a000011240ULL, 0x000112c0000112b0ULL,
0x00011a40000119e0ULL, 0x00011b2000011ab0ULL, 0x00011c0000011b90ULL, 0x00011cc000011c60ULL,
0x00011d9000011d20ULL, 0x00011e6000011df0ULL, 0x00011f2000011ec0ULL, 0x00011ff000011f80ULL,
0x000120c000012050ULL, 0x0001218000012120ULL, 0x00012250000121e0ULL, 0x00012320000122b0ULL,
0x0001241000012390ULL, 0x000124f000012480ULL, 0x000125d000012560ULL, 0x000126b000012640ULL,
0x000127a000012720ULL, 0x0001286000012800ULL, 0x0000021004c03904ULL, 0x0000f600000000ffULL,
0x000002b0003f0100ULL, 0x0000f6080000000dULL, 0x000002f0003f0120ULL, 0x0000f6880000000dULL,
0x00000370003f0120ULL, 0x0000f6a80000000dULL, 0x000003b0003f0120ULL, 0x0000f6c80000000dULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000630003f0107ULL, 0x0000f68c00000048ULL,
0x00000750003f0102ULL, 0x0000f68800000048ULL, 0x00000d60003f0101ULL, 0x00000000000000ffULL,
0x00000e2000040107ULL, 0x00000000000000ffULL, 0x00000e8000040101ULL, 0x000000200000003dULL,
0x00000fd0003f0101ULL, 0x0000000400000062ULL, 0x00001040003f0105ULL, 0x000000240000003dULL,
0x000010c0003f0105ULL, 0x000000240000003dULL, 0x000017b0003f0105ULL, 0x0000000000000052ULL,
0x00001880003f0107ULL, 0x0000000000000052ULL, 0x00001890003f0101ULL, 0x000000040000002dULL,
0x00001900003f0105ULL, 0x0000f60800000031ULL, 0x00001920003f0101ULL, 0x0000f60c00000031ULL,
0x000019d0003f0105ULL, 0x0000f60c00000000ULL, 0x00001ee0003f0105ULL, 0x000000040000002dULL,
0x00001f60003f0105ULL, 0x000000040000002dULL, 0x000031b0003f0105ULL, 0x000000200000003dULL,
0x00003230003f0101ULL, 0x0000f6880000005eULL, 0x00003280003f0101ULL, 0x0000000400000062ULL,
0x000032d0003f0105ULL, 0x000000240000003dULL, 0x00003350003f0105ULL, 0x000000240000003dULL,
0x00003920003f0105ULL, 0x000000000000005fULL, 0x000039a0003f0107ULL, 0x000000000000005fULL,
0x000039b0003f0101ULL, 0x0000000400000060ULL, 0x00003a20003f0105ULL, 0x0000f62800000031ULL,
0x00003a40003f0101ULL, 0x0000f62c00000031ULL, 0x00003b20003f0105ULL, 0x0000f62c00000031ULL,
0x00004060003f0105ULL, 0x0000f6ac00000026ULL, 0x000040e0003f0105ULL, 0x0000f6ac00000026ULL,
0x000051e0003f0105ULL, 0x000000200000003dULL, 0x00005250003f0101ULL, 0x0000f6900000005eULL,
0x00005290003f0101ULL, 0x0000000400000062ULL, 0x000052e0003f0105ULL, 0x000000240000003dULL,
0x00005360003f0105ULL, 0x000000240000003dULL, 0x00005810003f0105ULL, 0x0000000000000060ULL,
0x00005890003f0107ULL, 0x0000000000000060ULL, 0x000058a0003f0101ULL, 0x000000040000005fULL,
0x00005910003f0105ULL, 0x0000f64800000031ULL, 0x00005930003f0101ULL, 0x0000f64c00000031ULL,
0x00005a00003f0105ULL, 0x0000f64c00000031ULL, 0x00005f30003f0105ULL, 0x0000f6ac00000024ULL,
0x00005fb0003f0105ULL, 0x000000040000005fULL, 0x00007050003f0105ULL, 0x000000200000003dULL,
0x000070c0003f0101ULL, 0x0000f6980000005eULL, 0x00007110003f0101ULL, 0x0000000400000062ULL,
0x00007160003f0105ULL, 0x000000240000003dULL, 0x000071e0003f0105ULL, 0x000000240000003dULL,
0x000076e0003f0105ULL, 0x000000000000005fULL, 0x00007760003f0107ULL, 0x000000000000005fULL,
0x00007770003f0101ULL, 0x0000000400000060ULL, 0x000077e0003f0105ULL, 0x0000f66800000031ULL,
0x00007800003f0101ULL, 0x0000f66c00000031ULL, 0x00007890003f0105ULL, 0x0000f66c00000031ULL,
0x00007dd0003f0105ULL, 0x0000f6ac00000003ULL, 0x00007e50003f0105ULL, 0x0000000400000060ULL,
0x00008e70003f0105ULL, 0x000000200000003dULL, 0x00008ed0003f0101ULL, 0x0000f6a00000005eULL,
0x0000cd70003f0101ULL, 0x0000f600000000ffULL, 0x0000db70003f0101ULL, 0x0000f604000000ffULL,
0x0000dc10003f0105ULL, 0x0000f604000000ffULL, 0x0000de20003f0105ULL, 0x0000f600000000ffULL,
0x0000de30003f0101ULL, 0x0000f604000000ffULL, 0x0000dec0003f0105ULL, 0x0000f604000000ffULL,
0x00010030003f0105ULL, 0x000000000000002bULL, 0x00010060003f0101ULL, 0x000000040000002bULL,
0x00010430003f0105ULL, 0x000000040000002bULL, 0x00011830003f0105ULL, 0x000000000000002dULL,
0x00011890003f0101ULL, 0x000000080000002dULL, 0x000118f0003f0101ULL, 0x000000100000002dULL,
0x00011960003f0101ULL, 0x000000180000002dULL, 0x00053803003f0101ULL, 0x0000ca3000141c04ULL,
0x0000df200000cc80ULL, 0x000119a00000dfd0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000374ULL, 0x0000001200000002ULL, 0x00000000000002b4ULL, 0x0000001200000002ULL,
0x00000000000001f4ULL, 0x0000001200000002ULL, 0x000000000000011cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000034bULL, 0x0000001200000002ULL,
0x000000000000028bULL, 0x0000001200000002ULL, 0x00000000000001cbULL, 0x0000001200000002ULL,
0x00000000000000f3ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff257624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee200000e0000ULL, 0x00000100ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea80000002200ULL, 0x00000000004f7919ULL, 0x000f220000000000ULL,
0x0000001200127309ULL, 0x000f660000000000ULL, 0x0000000000417919ULL, 0x000ee80000002600ULL,
0x0000000000267919ULL, 0x000f620000002700ULL, 0x00000005ff517819ULL, 0x002fc6000001160dULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff51517589ULL, 0x000fe200000e0000ULL,
0x000000010c007824ULL, 0x004fc600078e0203ULL, 0x00001fff0c0c7589ULL, 0x000ea200000e0000ULL,
0x00000080000d7824ULL, 0x000fe200078e020dULL, 0x00000004ff0f7819ULL, 0x010fe2000001164fULL,
0x0000000825007824ULL, 0x000fe400078e00ffULL, 0x0000000841077824ULL, 0x008fe200078e00ffULL,
0x000000ff0d00720cULL, 0x000fe20003f45270ULL, 0x000000104f0e7824ULL, 0x000fe200078e00ffULL,
0x0000007f0d00780cULL, 0x040fe20003f84070ULL, 0x0000002600007224ULL, 0x020fe200078e0207ULL,
0x0000000f0d00780cULL, 0x000fc40003f64070ULL, 0x000000030d00780cULL, 0x000fe40003f24070ULL,
0x000000050400720cULL, 0x002fca0003f02070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x000000040c067824ULL, 0x004fe400078e0251ULL,
0xff317217ff0ac424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x0000000206087824ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x00f4000a0d00c388ULL, 0x000fe20000004800ULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL, 0x3fffff60ff069424ULL, 0x000fe400078e00ffULL,
0x0000000100027824ULL, 0x002fe200078e0211ULL, 0x00f608040d00b388ULL, 0x0003e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000109007824ULL, 0x000fe400078e0a08ULL,
0x00005c0002027625ULL, 0x000fe200078e000bULL, 0x00f688060d009388ULL, 0x0005e40000008a00ULL,
0x000000000f00720cULL, 0x000fe20003f66070ULL, 0x3fffff80ff089424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff099424ULL, 0x000fe200078e00ffULL, 0x0000000711047812ULL, 0x002fe200078ec0ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL, 0x000000f00e057812ULL, 0x000fe200078ec0ffULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f6a8080d009388ULL, 0x0003e20000008a00ULL,
0x0000000f04107812ULL, 0x000fe200078e784fULL, 0x000000ffff007224ULL, 0x000fe200078e0a12ULL,
0x0000000502047210ULL, 0x000fe20007f9e0ffULL, 0x00f6c80a0d00a388ULL, 0x0003e20000008a00ULL,
0x00000004ff0f7424ULL, 0x000fc400078e00ffULL, 0x0000001011107824ULL, 0x000fe400078e0210ULL,
0x000000ffff057224ULL, 0x000fe400020e0603ULL, 0x0000001010077824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000620026027625ULL, 0x000fca00078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006024d7981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x00000004ff4b7e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f4d4c7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff4d4a7810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff4c7819ULL, 0x000fe4000001164cULL, 0x00000008ff4a7819ULL, 0x000fca000001164aULL,
0x0000c72000008947ULL, 0x000fea0003800000ULL, 0x00000002ff497819ULL, 0x000fe20000011651ULL,
0x0000000851487824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x002fe200078e00ffULL,
0x03ffffff49007812ULL, 0x000fca00078ec0ffULL, 0x000000044b077824ULL, 0x000fca00078e0200ULL,
0x0000004c0700720cULL, 0x000fda0003f06070ULL, 0x0000000226008824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640000028624ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000107028824ULL, 0x000fe200078e0202ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0548ff738cULL, 0x0003e20000000000ULL,
0x0000600002028625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602008981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff467424ULL, 0x000fe200078e00ffULL,
0x0000000307047812ULL, 0x000fe200078ec0ffULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0000000151437812ULL, 0x000fe200078ec0ffULL, 0x000003000f467a24ULL, 0x000fe200078e0a46ULL,
0x000000030400780cULL, 0x000fc40003f05270ULL, 0x00000003ff067819ULL, 0x000fe4000001164fULL,
0x00000001ff447819ULL, 0x000fe20000011651ULL, 0x0000004041417824ULL, 0x000fe200078e00ffULL,
0x0000000146477807ULL, 0x000fe20004000000ULL, 0x00f6880048ff7f8cULL, 0x0009e8000c80043fULL,
0x0000000107477824ULL, 0x000fca00078e0247ULL, 0x0000004c4700720cULL, 0x000fe40003f06070ULL,
0x0000000406097810ULL, 0x000fd60007ffe0ffULL, 0x0000000226048824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x002fc800078e00ffULL, 0x0000640004048624ULL, 0x000fc800078e0205ULL,
0x0000000104028824ULL, 0x004fe400078e0247ULL, 0x0000001043047824ULL, 0x000fe400078e00ffULL,
0x0000600002028625ULL, 0x000fc800078e000fULL, 0x00000001040a7824ULL, 0x000fe200078e0209ULL,
0x0000000602458981ULL, 0x000362000c1e1900ULL, 0x0000002044427824ULL, 0x000fe200078e00ffULL,
0x000000014b057810ULL, 0x000fe20007ffe0ffULL, 0x0000000104077824ULL, 0x000fe200078e0206ULL,
0x00000008060f7810ULL, 0x000fe20007ffe0ffULL, 0x0000200044407824ULL, 0x000fe200078e00ffULL,
0x0000004a0500720cULL, 0x000fe20003f06070ULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000004f07087212ULL, 0x080fe200078e3cffULL, 0x00000000440473c2ULL, 0x000ea200000e0000ULL,
0x000000080a037824ULL, 0x042fe200078e00ffULL, 0x0000004f0a027212ULL, 0x080fe200078e3cffULL,
0xff317217ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000000c06127810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0xfffffff8030c7812ULL, 0x000fe200078ee202ULL,
0x000001004b027824ULL, 0x000fe200078e0242ULL, 0xfffffff80b087812ULL, 0x000fe200078ee208ULL,
0x00000001040b7824ULL, 0x000fe200078e020fULL, 0x0000b00040057810ULL, 0x000fe20007ffe0ffULL,
0x0000000104117824ULL, 0x000fe200078e0212ULL, 0x000000024d037217ULL, 0x000fe20007800000ULL,
0x000000080b157824ULL, 0x040fe200078e00ffULL, 0x0000004f0b107212ULL, 0x000fc400078e3cffULL,
0x0000004f11147212ULL, 0x000fe200078e3cffULL, 0x0000000103037824ULL, 0x100fe200078e0a02ULL,
0x0000002041027812ULL, 0x000fe400078ef802ULL, 0xfffffff815107812ULL, 0x000fe400078ee210ULL,
0x0000002003037807ULL, 0x000fe20000000000ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x0000f6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000102137824ULL, 0x040fe200078e020bULL,
0x0000000403037217ULL, 0x000fe20007800000ULL, 0x00000001020d7824ULL, 0x000fe200078e020aULL,
0x0000f6a8443d7811ULL, 0x000fe200078e18ffULL, 0x0000000102177824ULL, 0x000fc400078e0211ULL,
0x0000000103037824ULL, 0x000fe400078e0a04ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x00000010080b7824ULL, 0x100fe200078e0205ULL, 0x000000030600720cULL, 0x080fe20003f46070ULL,
0x0000001010157824ULL, 0x100fe200078e0205ULL, 0xfffffff811147812ULL, 0x000fe200078ee214ULL,
0x000000100c117824ULL, 0x100fe200078e0205ULL, 0x000000030f00720cULL, 0x080fe40003f06070ULL,
0x000000700e0f7812ULL, 0x000fe200078ec0ffULL, 0x0000001014197824ULL, 0x000fe200078e0205ULL,
0x000000030900720cULL, 0x000fe20003f26070ULL, 0x0000580000007a24ULL, 0x008fc800078e02ffULL,
0x0000004000007824ULL, 0x000fca00078e00ffULL, 0x0000000700077210ULL, 0x040fe40007f7e0ffULL,
0x0000001300137210ULL, 0x040fe40007fbe0ffULL, 0x0000000d000d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e0007027a11ULL, 0x000fc600078638ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x00005f0007077a11ULL, 0x000fe200018f3c04ULL,
0x000000ffff047224ULL, 0x000fe200028e06ffULL, 0x0000001700007210ULL, 0x000fe40007fbe0ffULL,
0x00005e00130c7a11ULL, 0x000fe400078838ffULL, 0x00005e000d087a11ULL, 0x000fe200078638ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005f0013047a11ULL, 0x000fe400020f3c04ULL,
0x000000020f027210ULL, 0x000fc40007fbe0ffULL, 0x00005f000d067a11ULL, 0x000fe400018f3c06ULL,
0x0000000f08087210ULL, 0x000fe40007f9e0ffULL, 0x00005e00000e7a11ULL, 0x000fe400078c38ffULL,
0x000000031200720cULL, 0x000fe20003f66070ULL, 0x000000ffff037224ULL, 0x000fe200028e0607ULL,
0x0000000f0c0c7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200020e0606ULL,
0x00005f0000007a11ULL, 0x000fe200030f3c05ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000f0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0604ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000d101c46ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200020e0600ULL, 0x0000000008117faeULL, 0x0005e8000c901c46ULL,
0x000000000c157faeULL, 0x0007e2000c101c46ULL, 0x0000004a4b00720cULL, 0x000fc60003f06070ULL,
0x000000000e197faeULL, 0x0009e2000d901c46ULL, 0x00000000000a7805ULL, 0x002fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff667f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003d027f8cULL, 0x0004e2000c80043fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000203d627810ULL, 0x000fe20007ffe0ffULL,
0x0000800000000947ULL, 0x000fea0003800000ULL, 0x00000002263c7824ULL, 0x004fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff257224ULL, 0x008fe400078e0003ULL,
0x000064003c3c7624ULL, 0x000fe400078e0207ULL, 0xff317217ff3f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000001004b007824ULL, 0x000fca00078e00ffULL, 0x0000004d0000720cULL, 0x000fda0003f06070ULL,
0x00007f2000000947ULL, 0x00afea0003800000ULL, 0x0000040062007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff547224ULL, 0x000fe400078e0047ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0055ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003d007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000037305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000030000735dULL, 0x008fe20003800000ULL,
0x000024003d247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000347007812ULL, 0x000fe200078ec0ffULL,
0x0000580045267a24ULL, 0x020fe200078e02ffULL, 0x00000003ff2a7819ULL, 0x000fe2000001164fULL,
0x000001004b397824ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fe20003f05270ULL,
0xffffffffff457424ULL, 0x000fc600078e00ffULL, 0x0000000146007807ULL, 0x000fca0004000000ULL,
0x0000000147477824ULL, 0x000fe400078e0200ULL, 0x0000001051007824ULL, 0x000fc600078e00ffULL,
0x0000004c4700720cULL, 0x000fe40003f06070ULL, 0x0000001000277812ULL, 0x000fca00078ec0ffULL,
0x000000012a3a7824ULL, 0x000fe200078e0227ULL, 0x00000001ff447819ULL, 0x000fc60000011651ULL,
0x000000083a007824ULL, 0x040fe200078e00ffULL, 0x0000004f3a377212ULL, 0x000fe200078e3cffULL,
0x000000013c248824ULL, 0x000fe200078e0247ULL, 0x000000042a317810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0xfffffff800377812ULL, 0x000fe200078ee237ULL,
0x0000002044007824ULL, 0x000fe400078e0239ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x000000014b037810ULL, 0x000fe40007ffe0ffULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x0000000131387824ULL, 0x000fe200078e0227ULL, 0x0000000624458981ULL, 0x000562000c1e1900ULL,
0x0000004a0300720cULL, 0x000fe20003f06070ULL, 0x0000004026267824ULL, 0x000fe200078e00ffULL,
0x000000004d037217ULL, 0x000fe20007800000ULL, 0x000000104f307824ULL, 0x000fe200078e00ffULL,
0x0000004f38357212ULL, 0x000fe200078e3cffULL, 0x0000055000007945ULL, 0x000fe20003800000ULL,
0x0000000c2a507810ULL, 0x000fc40007ffe0ffULL, 0x000000082a4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000838247824ULL, 0x004fe200078e00ffULL, 0x00000070302f7812ULL, 0x000fe200078ec0ffULL,
0x0000000150347824ULL, 0x100fe400078e0227ULL, 0x000000014e367824ULL, 0x000fe200078e0227ULL,
0xfffffff824357812ULL, 0x000fe200078ee235ULL, 0x0000000103247824ULL, 0x100fe200078e0a00ULL,
0x0000002041037812ULL, 0x000fe200078ef800ULL, 0x0000000834297824ULL, 0x040fe200078e00ffULL,
0x0000004f34327212ULL, 0x080fe200078e3cffULL, 0x0000000836287824ULL, 0x040fe200078e00ffULL,
0x0000004f36337212ULL, 0x000fe200078e3cffULL, 0x0000000103257824ULL, 0x000fe200078e023aULL,
0xfffffff829327812ULL, 0x000fe200078ee232ULL, 0x0000000103297824ULL, 0x040fe200078e0238ULL,
0x0000002024247807ULL, 0x000fe20000000000ULL, 0x00000001032b7824ULL, 0x040fe200078e0236ULL,
0x0000002526257210ULL, 0x040fe20007f5e0ffULL, 0x0000000103037824ULL, 0x000fe200078e0234ULL,
0x0000002926297210ULL, 0x000fc40007f7e0ffULL, 0x0000002b262b7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e00252c7a11ULL, 0x000fe400078438ffULL,
0x0000000326267210ULL, 0x000fe20007f1e0ffULL, 0x0000100055037824ULL, 0x000fe200078e00ffULL,
0xfffffff828337812ULL, 0x000fe200078ee233ULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000002724247217ULL, 0x000fe40007800000ULL, 0x00005f00252e7a11ULL, 0x000fe200010f3c2eULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e00292d7a11ULL, 0x000fe200078438ffULL,
0x0000000124007824ULL, 0x000fe200078e0a27ULL, 0x0000100003037812ULL, 0x000fe200078e0cffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005f0029277a11ULL, 0x000fc400010f3c28ULL,
0x00005e002b287a11ULL, 0x040fe200078638ffULL, 0x0000200044037824ULL, 0x000fe200078e0203ULL,
0x000000002a00720cULL, 0x000fe40003f46070ULL, 0x00005f002b297a11ULL, 0x000fe400018f3c24ULL,
0x0000002f2c247210ULL, 0x000fe40007f7e0ffULL, 0x00005e00262a7a11ULL, 0x000fe400078038ffULL,
0x0000b000032c7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0026037a11ULL, 0x000fe200000f3c25ULL,
0x000000ffff257224ULL, 0x000fe200018e062eULL, 0x0000002f2d267210ULL, 0x080fe20007fbe0ffULL,
0x00000010375a7824ULL, 0x100fe200078e022cULL, 0x000000003100720cULL, 0x080fe20003f06070ULL,
0x00000008552e7824ULL, 0x000fe200078e00ffULL, 0x0000002f28287210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245a7faeULL, 0x0005e2000d101c46ULL, 0x000000004e00720cULL, 0x080fe20003f46070ULL,
0x00000010355b7824ULL, 0x100fe200078e022cULL, 0x000000005000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0xfffffff048007812ULL, 0x000fe200078ec0ffULL,
0x00000010335c7824ULL, 0x100fe200078e022cULL, 0x0000002f2a2a7210ULL, 0x000fe20007f9e0ffULL,
0x00000010325d7824ULL, 0x000fe200078e022cULL, 0x0000f6a8002d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000265b7faeULL, 0x0007e2000c101c46ULL, 0x000000082e007812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e0603ULL, 0xffffffe048317812ULL, 0x040fe200078ec0ffULL,
0x00000000285c7faeULL, 0x0007e2000d101c46ULL, 0x0000000848037812ULL, 0x040fe200078ec0ffULL,
0x000000012d527824ULL, 0x000fe200078e0200ULL, 0x0000001048007812ULL, 0x000fe200078ec0ffULL,
0x000000002a5d7faeULL, 0x0007e2000e901c46ULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000003103317210ULL, 0x000fe20007ffe000ULL, 0x0000000000007918ULL, 0x004ff40000000000ULL,
0x00000000520403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012d2d7824ULL, 0x000fe200078e022eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000052527f8cULL, 0x000ea8000c80043fULL, 0x000004002d267984ULL, 0x0087220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080031247f8cULL, 0x000fe2000c80043fULL, 0x8000000026ff7812ULL, 0x012fc60007844867ULL,
0x00f60c0031037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x0000002049007824ULL, 0x000fe400078e0200ULL,
0x3e000000ff037424ULL, 0x000fe400078e00ffULL, 0x0000000843007824ULL, 0x000fe400078e0200ULL,
0x0000000300267305ULL, 0x000324000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x010fe20003800000ULL, 0x00f60c0000277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe4000001164fULL, 0x0000007030307812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc600078ec0ffULL, 0x0000008049007824ULL, 0x000fc800078e0230ULL,
0x0000000100007824ULL, 0x000fca00078e0203ULL, 0x00f0000000287984ULL, 0x000e680000000800ULL,
0x00f2000000297984ULL, 0x0008e20000000800ULL, 0x0000003f2800720bULL, 0x002fe20003f1d000ULL,
0x0000ff027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x010fc800000e0100ULL,
0x0000ffff002a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff717424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000514900720cULL, 0x000fe40003f65270ULL, 0x0000003f2800720bULL, 0x000fe20003f14000ULL,
0x0000fee27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000805124b824ULL, 0x000fe200078e0230ULL, 0x000000283f2b7209ULL, 0x000fe40007810000ULL,
0x0000ffff00277812ULL, 0x000fe200078e3cffULL, 0x000000010324b824ULL, 0x000fe200078e0224ULL,
0x00000002ff007819ULL, 0x000fe2000001164fULL, 0x8000002b3f257221ULL, 0x000fe20000010000ULL,
0x000000272aff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002b2400b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x00000025006e7308ULL, 0x0003220000000800ULL,
0x0000fe827f007947ULL, 0x000fea000b800000ULL, 0x00001f006e247589ULL, 0x01232400000e0000ULL,
0x0000000800007810ULL, 0x002fe20007ffe0ffULL, 0x0000fec27f007947ULL, 0x000fea000b800000ULL,
0x00001f006e007589ULL, 0x00032400000e0000ULL, 0x8000002b28280221ULL, 0x000fe20000010000ULL,
0x00000001ff717807ULL, 0x000fe20000000000ULL, 0x0000006e3e3e7220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b28280820ULL, 0x000fe40000410000ULL, 0x0000000007077220ULL, 0x090fe40000410000ULL,
0x0000002800020308ULL, 0x000f220000000800ULL, 0x0000000006067220ULL, 0x000fc40000410000ULL,
0x000000000b0b7220ULL, 0x080fe40000410000ULL, 0x000000000a0a7220ULL, 0x080fe40000410000ULL,
0x000000000f0f7220ULL, 0x080fe40000410000ULL, 0x000000000e0e7220ULL, 0x080fe40000410000ULL,
0x0000000013137220ULL, 0x080fe40000410000ULL, 0x0000000012127220ULL, 0x000fc40000410000ULL,
0x0000000017177220ULL, 0x080fe40000410000ULL, 0x0000000016167220ULL, 0x080fe40000410000ULL,
0x000000001b1b7220ULL, 0x080fe40000410000ULL, 0x000000001a1a7220ULL, 0x080fe40000410000ULL,
0x000000001f1f7220ULL, 0x080fe40000410000ULL, 0x000000001e1e7220ULL, 0x000fc40000410000ULL,
0x0000000023237220ULL, 0x080fe40000410000ULL, 0x0000000022227220ULL, 0x000fe40000410000ULL,
0x0000002405057220ULL, 0x080fe40000410000ULL, 0x0000002404047220ULL, 0x080fe40000410000ULL,
0x0000002409097220ULL, 0x080fe40000410000ULL, 0x0000002408087220ULL, 0x000fc40000410000ULL,
0x000000240d0d7220ULL, 0x080fe40000410000ULL, 0x000000240c0c7220ULL, 0x080fe40000410000ULL,
0x0000002411117220ULL, 0x080fe40000410000ULL, 0x0000002410107220ULL, 0x080fe40000410000ULL,
0x0000002415157220ULL, 0x080fe40000410000ULL, 0x0000002414147220ULL, 0x000fc40000410000ULL,
0x0000002419197220ULL, 0x080fe40000410000ULL, 0x0000002418187220ULL, 0x080fe40000410000ULL,
0x000000241d1d7220ULL, 0x080fe40000410000ULL, 0x000000241c1c7220ULL, 0x080fe40000410000ULL,
0x0000002421217220ULL, 0x080fe40000410000ULL, 0x0000002420207220ULL, 0x000fc40000410000ULL,
0x000000ffff3f7224ULL, 0x000fe400078e002bULL, 0x0000000229290220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003e293e7221ULL, 0x008fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x000004002d007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x000004002d247984ULL, 0x000ee40000000800ULL, 0x8000000024ff7812ULL, 0x008fc40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff257819ULL, 0x000fe4000001164fULL, 0x00005410006e7816ULL, 0x002fe20000000000ULL,
0x0000fb627f007947ULL, 0x000fea000b800000ULL, 0x00001f256e577589ULL, 0x0002e400000e0000ULL,
0x0000000825007810ULL, 0x000fe20007ffe0ffULL, 0x0000fba27f007947ULL, 0x000fea000b800000ULL,
0x00001f006e567589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010256f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff707424ULL, 0x000fe200078e00ffULL,
0x0000209000267802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x000109d000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018256f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff707424ULL, 0x000fe200078e00ffULL,
0x000020f000267802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x0001097000007944ULL, 0x03cfea0003c00000ULL, 0x00000002515e7824ULL, 0x000fe200078e00ffULL,
0x000000074f667812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000045e247812ULL, 0x000fc400078ec0ffULL, 0x0000000866667812ULL, 0x000fe400078ef84fULL,
0x000000244f7f7211ULL, 0x040fe400078fe0ffULL, 0x000000084f247812ULL, 0x000fe400078ec0ffULL,
0x000000077f257812ULL, 0x002fca00078e7866ULL, 0x0000000866257824ULL, 0x000fc800078e0225ULL,
0x0000001025647824ULL, 0x000fc800078e00ffULL, 0x0000080049857824ULL, 0x000fe400078e0264ULL,
0x0000000451257824ULL, 0x040fe200078e00ffULL, 0x00000007242d7812ULL, 0x140fe200078ec84fULL,
0x0000100051277824ULL, 0x000fe200078e00ffULL, 0x00000007244e7812ULL, 0x000fe400078ef84fULL,
0x0000000425267812ULL, 0x000fe400078ec0ffULL, 0xffffe00027287812ULL, 0x000fe400078ec0ffULL,
0x000000264f2c7211ULL, 0x000fe400078fe0ffULL, 0x000000804e6e7811ULL, 0x010fe200078e18ffULL,
0x0000100055287824ULL, 0x000fe200078e0228ULL, 0x0000002c2d297212ULL, 0x000fc400078e3cffULL,
0x000000022c2c7810ULL, 0x000fe40007ffe0ffULL, 0x0000b000282f7810ULL, 0x004fe20007ffe0ffULL,
0x000000084e507824ULL, 0x000fe200078e0229ULL, 0x0000991071967816ULL, 0x000fe200000000ffULL,
0x0000100055287824ULL, 0x000fe200078e0240ULL, 0x000000027f7f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001050247824ULL, 0x000fe200078e022fULL, 0x000000ff9600720cULL, 0x000fe20003f05270ULL,
0x0000000129587824ULL, 0x000fe200078e026eULL, 0x0000b00028707810ULL, 0x000fc40007ffe0ffULL,
0x000000077f7f7812ULL, 0x000fe200078e7866ULL, 0x000000002424783bULL, 0x000e640000004200ULL,
0x0000001058287824ULL, 0x000fe400078e0270ULL, 0x0000000866667824ULL, 0x000fc800078e027fULL,
0x000000002828783bULL, 0x000ea20000004200ULL, 0x0000001066667824ULL, 0x000fe400078e00ffULL,
0x0000010024597824ULL, 0x042fe200078e00ffULL, 0x00008880242e7816ULL, 0x040fe400000000ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011459ULL, 0x0000002e00867306ULL, 0x0003e20000200c00ULL,
0x0000002c2d597212ULL, 0x000fe200078e3cffULL, 0x00000100252c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000001002a757824ULL, 0x004fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011428ULL, 0x000000084e4e7824ULL, 0x000fe200078e0259ULL,
0x00000018ff6b7819ULL, 0x000fe2000001142cULL, 0x0000006800877306ULL, 0x0005e20000200c00ULL,
0x0000888025697816ULL, 0x000fe200000000ffULL, 0x000000104e2f7824ULL, 0x000fe200078e022fULL,
0x00000018ff6c7819ULL, 0x000fe20000011425ULL, 0x0000000159597824ULL, 0x000fe200078e026eULL,
0x00000018ff777819ULL, 0x000fe20000011475ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011429ULL, 0x000000002f2c783bULL, 0x002e620000004200ULL,
0x0000002400897306ULL, 0x0009e20000200c00ULL, 0x0000010026687824ULL, 0x004fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff607819ULL, 0x000fe4000001142aULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000006900887306ULL, 0x000fe20000200c00ULL,
0x0000010027247824ULL, 0x010fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe4000001142bULL,
0x000088802a727816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000006800817306ULL, 0x0005e20000200c00ULL,
0x000088802b757816ULL, 0x000fe400000000ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff657819ULL, 0x000fe40000011426ULL, 0x00000018ff677819ULL, 0x000fe20000011427ULL,
0x00000024008a7306ULL, 0x0009e20000200c00ULL, 0x0000888028687816ULL, 0x004fe400000000ffULL,
0x0000888026807816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888027837816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fc400078e00ffULL,
0x0000006b008b7306ULL, 0x0004e20000200c00ULL, 0x0000010028247824ULL, 0x050fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff697819ULL, 0x000fe20000011424ULL,
0x0000001059247824ULL, 0x000fe200078e0270ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x00000025008d7306ULL, 0x0009e20000200c00ULL, 0x00008880296b7816ULL, 0x004fe200000000ffULL,
0x000001002e947824ULL, 0x002fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001142cULL,
0x000001002f717824ULL, 0x000fe200078e00ffULL, 0x000088802c8c7816ULL, 0x000fc400000000ffULL,
0x00000018ff767819ULL, 0x000fe2000001142dULL, 0x0000002800707306ULL, 0x0003e20000200c00ULL,
0x0000010029257824ULL, 0x010fe200078e00ffULL, 0x000088802d917816ULL, 0x000fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001142eULL,
0x00000018ff947819ULL, 0x000fe40000011494ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000001002b287824ULL, 0x042fe200078e00ffULL, 0x0000002a007d7306ULL, 0x000fe20000200c00ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc4000001142fULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000028007c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe40000011425ULL,
0x00000018ff717819ULL, 0x000fca0000011471ULL, 0x0000002900747306ULL, 0x000fe20000200c00ULL,
0x000001002c287824ULL, 0x042fe400078e00ffULL, 0x000100002c2c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe20000011428ULL, 0x000001002d287824ULL, 0x040fe200078e00ffULL,
0x0000002b007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000100002d2d7824ULL, 0x000fe400078e00ffULL, 0x00000018ff927819ULL, 0x000fc60000011428ULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x009000008528783bULL, 0x002e6e0000000200ULL, 0x0000006c006c7306ULL, 0x000f300000200c00ULL,
0x0000002c00907306ULL, 0x0005f00000200c00ULL, 0x0000008e008f7306ULL, 0x0007e20000200c00ULL,
0x000088802f2c7816ULL, 0x044fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d00937306ULL, 0x0005e20000200c00ULL,
0x000088802e8e7816ULL, 0x048fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002c00957306ULL, 0x0007e20000200c00ULL,
0x0000005728288232ULL, 0x082fe20000000000ULL, 0x00005410882d7816ULL, 0x004fe2000000008bULL,
0x000000572a2a8232ULL, 0x000fe40000000000ULL, 0x0000005629298232ULL, 0x080fe40000000000ULL,
0x000000562b2b8232ULL, 0x000fe20000000000ULL, 0x0000009400857306ULL, 0x000fe20000200c00ULL,
0x00005410862c7816ULL, 0x008fce0000000087ULL, 0x0000002c2820723cULL, 0x040fe20000001820ULL,
0x0000002600827306ULL, 0x000fec0000200c00ULL, 0x00005410892c7816ULL, 0x000fe4000000006aULL,
0x000054108d2d7816ULL, 0x010fe2000000006cULL, 0x0000002700847306ULL, 0x0003ec0000200c00ULL,
0x0000002c281c723cULL, 0x000fe4000000181cULL, 0x0000002e00947306ULL, 0x0005e20000200c00ULL,
0x000000002424783bULL, 0x002e6e0000004200ULL, 0x0000002f00867306ULL, 0x0007e20000200c00ULL,
0x00000800492e7824ULL, 0x004fce00078e0266ULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x009000002e2c783bULL, 0x008eee0000000200ULL, 0x0000008c008c7306ULL, 0x000f300000200c00ULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541080807816ULL, 0x004fce0000000081ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x000054108c8c7816ULL, 0x010fe2000000008fULL,
0x00000100247f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe40000011424ULL,
0x00000018ff7a7819ULL, 0x000fe40000011425ULL, 0x00008880256c7816ULL, 0x000fe200000000ffULL,
0x0000009200927306ULL, 0x000e620000200c00ULL, 0x0000541083817816ULL, 0x000fe4000000008aULL,
0x00000018ff787819ULL, 0x000fc40000011426ULL, 0x00000018ff797819ULL, 0x000fe40000011427ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000007100967306ULL, 0x0005220000200c00ULL,
0x000000802818723cULL, 0x000fe20000001818ULL, 0x000000572c2c8232ULL, 0x088fe40000000000ULL,
0x000000572e2e8232ULL, 0x000fe20000000000ULL, 0x0000010026577824ULL, 0x000fe200078e00ffULL,
0x000000562d2d8232ULL, 0x080fe40000000000ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x00005410918d7816ULL, 0x002fe20000000092ULL, 0x000000562f2f8232ULL, 0x000fe20000000000ULL,
0x0000888024717816ULL, 0x044fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc60000011457ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x00005410958f7816ULL, 0x010fe20000000096ULL, 0x0000008c2810723cULL, 0x000fe20000001810ULL,
0x00000018ff247819ULL, 0x000fca0000011424ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541082827816ULL, 0x008fce0000000065ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x0000541084837816ULL, 0x002fe40000000067ULL, 0x0000888026677816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fc800078e00ffULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000541090907816ULL, 0x004fe20000000073ULL, 0x000000822814723cULL, 0x000fe20000001814ULL,
0x00000018ff267819ULL, 0x000fca0000011426ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000541093917816ULL, 0x008fce0000000076ULL, 0x0000008e008e7306ULL, 0x000ee20000200c00ULL,
0x0000541094947816ULL, 0x002fe2000000006dULL, 0x00000090280c723cULL, 0x000fe2000000180cULL,
0x0000541086957816ULL, 0x004fca000000006fULL, 0x0000007100877306ULL, 0x0003e40000200c00ULL,
0x000000942804723cULL, 0x000fe20000001804ULL, 0x000054108e8e7816ULL, 0x008fca0000000085ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000010025717824ULL, 0x042fe400078e00ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x0000008e2808723cULL, 0x000fe40000001808ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000100272a7824ULL, 0x040fe200078e00ffULL,
0x0000888027297816ULL, 0x040fe200000000ffULL, 0x00010000272b7824ULL, 0x000fc600078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff2b7819ULL, 0x000fca000001142bULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000541068687816ULL, 0x002fce0000000069ULL, 0x0000005f005f7306ULL, 0x000e700000200c00ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000054106b697816ULL, 0x004fce000000006eULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x0000541070707816ULL, 0x002fe2000000005fULL,
0x000000682c20723cULL, 0x000fec0000001820ULL, 0x0000006100617306ULL, 0x000e700000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000054107d607816ULL, 0x004fce0000000060ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x000054107e617816ULL, 0x002fce0000000061ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x000000602c14723cULL, 0x000fee0000001814ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x004fce0000000077ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541075737816ULL, 0x002fce000000007cULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x000000722c18723cULL, 0x000fee0000001818ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007f006a7306ULL, 0x000e700000200c00ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000007100657306ULL, 0x0004e20000200c00ULL,
0x00005410876a7816ULL, 0x002fce000000006aULL, 0x0000002400247306ULL, 0x000e620000200c00ULL,
0x0000541074717816ULL, 0x004fce0000000063ULL, 0x0000002500257306ULL, 0x000ea20000200c00ULL,
0x000054106c6b7816ULL, 0x008fe20000000065ULL, 0x000000702c1c723cULL, 0x040fec000000181cULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541024247816ULL, 0x002fe2000000007bULL,
0x0000006a2c10723cULL, 0x000fec0000001810ULL, 0x0000005700287306ULL, 0x000e620000200c00ULL,
0x0000541025257816ULL, 0x004fce000000007aULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x000000242c0c723cULL, 0x000fee000000180cULL, 0x0000002a002a7306ULL, 0x000ea20000200c00ULL,
0x0000541067287816ULL, 0x002fce0000000028ULL, 0x0000002600277306ULL, 0x000e700000200c00ULL,
0x0000002b00567306ULL, 0x000ee20000200c00ULL, 0x0000541029297816ULL, 0x004fe4000000002aULL,
0x0000541027787816ULL, 0x002fca0000000078ULL, 0x000000282c08723cULL, 0x000fe20000001808ULL,
0x0000541056797816ULL, 0x008fce0000000079ULL, 0x000000782c04723cULL, 0x000fe20000001804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003d247f8cULL, 0x0002a2000c80043fULL,
0xfffffff85e5e7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004039247810ULL, 0x004fe20007ffe0ffULL, 0x00f688005eff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff677224ULL, 0x000fe200078e0053ULL, 0x0000000155557812ULL, 0x000fe400078e0cffULL,
0x0000004d2400720cULL, 0x000fda0003f06070ULL, 0x00005c7000000947ULL, 0x000fea0003800000ULL,
0x0000040062247984ULL, 0x004ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003d247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400267305ULL, 0x0004e4000021f000ULL, 0x3fa0000024247823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x000024003d267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000354247812ULL, 0x000fe200078ec0ffULL, 0x0000580045287a24ULL, 0x020fe200078e02ffULL,
0x00000001ff447819ULL, 0x000fe20000011651ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x000000032400780cULL, 0x000fc80003f05270ULL, 0x00000001466b7807ULL, 0x000fca0004000000ULL,
0x00000001546b7824ULL, 0x000fca00078e026bULL, 0x000000036b247812ULL, 0x000fc800078ec0ffULL,
0x000000032400780cULL, 0x000fc80003f05270ULL, 0x00000001466a7807ULL, 0x000fca0004000000ULL,
0x000000016b477824ULL, 0x000fca00078e026aULL, 0x0000004c4700720cULL, 0x000fe20003f06070ULL,
0x0000002044267824ULL, 0x000fe200078e0239ULL, 0x000000014b277810ULL, 0x000fd60007ffe0ffULL,
0x0000006a3c248210ULL, 0x000fe20007ffe06bULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000008026267810ULL, 0x000fc60007ffe0ffULL, 0x0000600024248625ULL, 0x000fca00078e0025ULL,
0x0000000624458981ULL, 0x000562000c1e1900ULL, 0x0000004a2700720cULL, 0x000fe20003f06070ULL,
0x000000083b687824ULL, 0x000fe200078e00ffULL, 0x000000264d277217ULL, 0x000fe20007800000ULL,
0x00000040282d7824ULL, 0x000fe200078e00ffULL, 0xfffffff048297812ULL, 0x000fe200078ec0ffULL,
0x000010003b697824ULL, 0x000fe200078e00ffULL, 0x00000008685f7812ULL, 0x000fe200078ec0ffULL,
0x0000000127277824ULL, 0x100fe200078e0a26ULL, 0x0000f6a829297810ULL, 0x000fe20007ffe0ffULL,
0x0000001051247824ULL, 0x004fe200078e00ffULL, 0x0000002041257812ULL, 0x000fc400078ef826ULL,
0x000000085f607812ULL, 0x000fe200078e3cffULL, 0x00000001295f7824ULL, 0x000fe200078e025fULL,
0x00000010242a7812ULL, 0x000fe200078ec0ffULL, 0x0000000138267824ULL, 0x100fe200078e0225ULL,
0x0000002027277807ULL, 0x000fe20000000000ULL, 0x000000013a247824ULL, 0x100fe200078e0225ULL,
0x000000005f0473c2ULL, 0x000ea200000e0000ULL, 0x0000000136287824ULL, 0x100fe200078e0225ULL,
0x000000262d267210ULL, 0x000fe20007f5e0ffULL, 0x0000000129607824ULL, 0x000fe200078e0260ULL,
0x000000242d247210ULL, 0x040fe20007f1e0ffULL, 0x0000000134257824ULL, 0x000fe200078e0225ULL,
0x000000272a277217ULL, 0x000fe20007800000ULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00005e00262f7a11ULL, 0x000fe200078438ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x000000282d287210ULL, 0x000fe20007f7e0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a2aULL,
0x00005e0024577a11ULL, 0x000fc400078038ffULL, 0x000000252d2e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x00005f00262a7a11ULL, 0x000fe400010f3c29ULL,
0x00000003ff267819ULL, 0x000fe2000001164fULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x0000100069257812ULL, 0x000fe400078ec0ffULL, 0x00005f0024567a11ULL, 0x000fe400000f3c2bULL,
0x00005e0028557a11ULL, 0x000fe200078038ffULL, 0x0000200044257824ULL, 0x000fe200078e0225ULL,
0x00005e002e2b7a11ULL, 0x000fc400078438ffULL, 0x0000000426247810ULL, 0x000fe40007ffe0ffULL,
0x00005f0028547a11ULL, 0x000fe400000f3c2dULL, 0x000000272600720cULL, 0x080fe40003f86070ULL,
0x00005f002e2e7a11ULL, 0x000fe400010f3c29ULL, 0x000000272400720cULL, 0x000fe40003f06070ULL,
0x0000003057247210ULL, 0x000fc40007f5e0ffULL, 0x0000000826287810ULL, 0x040fe40007ffe0ffULL,
0x0000b000252c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0656ULL,
0x0000000c26267810ULL, 0x000fe40007ffe0ffULL, 0x000000272800720cULL, 0x080fe20003f66070ULL,
0x00000010372d7824ULL, 0x100fe200078e022cULL, 0x000000272600720cULL, 0x000fe20003f46070ULL,
0x0000001032577824ULL, 0x100fe200078e022cULL, 0x000000302f267210ULL, 0x080fe20007fbe0ffULL,
0x00000010352f7824ULL, 0x100fe200078e022cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242d7faeULL, 0x0007e2000e101c46ULL, 0x0000003055287210ULL, 0x000fe20007f9e0ffULL,
0x0000001033557824ULL, 0x000fc400078e022cULL, 0x000000ffff277224ULL, 0x000fe200028e062aULL,
0x000000302b2a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fc600020e0654ULL,
0x00000000262f7faeULL, 0x0009e2000c101c46ULL, 0x000000ffff2b7224ULL, 0x000fc600028e062eULL,
0x0000000028557faeULL, 0x0009e8000d901c46ULL, 0x000000002a577faeULL, 0x0009e8000d101c46ULL,
0x0000000000007918ULL, 0x008fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005f247f8cULL, 0x0004e8000c80043fULL, 0x0000040060297984ULL, 0x0105220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280031267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc60007844853ULL,
0x00f62c00312b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x008fe200078e0025ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe048317812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff247424ULL, 0x000fe200078e00ffULL,
0x0000001048287812ULL, 0x040fe400078ec0ffULL, 0x0000000848257812ULL, 0x000fc800078ec0ffULL,
0x0000003125317210ULL, 0x000fe40007ffe028ULL, 0x0000002400257305ULL, 0x000724000021f000ULL,
0x3fa0000024247823ULL, 0x008fe200000100ffULL, 0x000000250000735dULL, 0x010fe40003800000ULL,
0x00f62c0031257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002051247824ULL, 0x000fca00078e00ffULL,
0xffffff8024257812ULL, 0x000fc800078ec0ffULL, 0x0000008030247810ULL, 0x000fca0007ffe025ULL,
0x0000000103247824ULL, 0x000fca00078e0224ULL, 0x00f0000024287984ULL, 0x000ee80000000800ULL,
0x00f2000024297984ULL, 0x0008620000000800ULL, 0x0000003f2800720bULL, 0x008fe20003f1d000ULL,
0x0000e0427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff657424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000149247810ULL, 0x000fe40007ffe0ffULL, 0x0000003f2800720bULL, 0x000fe40003f14000ULL,
0x000000512400720cULL, 0x000fe20003f65270ULL, 0x0000e0127f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000283f267209ULL, 0x000fe20007810000ULL,
0x00000080512cb824ULL, 0x000fe200078e0230ULL, 0x0000ffff24277812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe2000001164fULL, 0x00000001032bb824ULL, 0x000fe200078e022cULL,
0x000000272aff7212ULL, 0x000fe2000780c0ffULL, 0x800000263f257221ULL, 0x000fc60000010000ULL,
0x00f400262b00b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x00000025006e7308ULL, 0x000f240000000800ULL, 0x0000006e3e3e7220ULL, 0x010fe20000410000ULL,
0x0000dfa27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e247589ULL, 0x00872400000e0000ULL,
0x0000002420207220ULL, 0x090fe40000410000ULL, 0x0000002421217220ULL, 0x080fe40000410000ULL,
0x000000241c1c7220ULL, 0x080fe40000410000ULL, 0x000000241d1d7220ULL, 0x080fe40000410000ULL,
0x0000002418187220ULL, 0x000fc40000410000ULL, 0x0000002419197220ULL, 0x080fe40000410000ULL,
0x0000002414147220ULL, 0x080fe40000410000ULL, 0x0000002415157220ULL, 0x080fe40000410000ULL,
0x0000002410107220ULL, 0x080fe40000410000ULL, 0x0000002411117220ULL, 0x080fe40000410000ULL,
0x000000240c0c7220ULL, 0x000fc40000410000ULL, 0x000000240d0d7220ULL, 0x080fe40000410000ULL,
0x0000002408087220ULL, 0x080fe40000410000ULL, 0x0000002409097220ULL, 0x080fe40000410000ULL,
0x0000002404047220ULL, 0x080fe40000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000dee27f007947ULL, 0x000fea000b800000ULL, 0x00001f006e247589ULL, 0x0008a400000e0000ULL,
0x000000283f3f7209ULL, 0x000fe20007810000ULL, 0x0000002422227220ULL, 0x084fe20000410000ULL,
0x00000001ff657807ULL, 0x000fe20000000000ULL, 0x0000002423237220ULL, 0x000fc40000410000ULL,
0x8000003f28280221ULL, 0x000fe40000010000ULL, 0x000000241e1e7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b28280820ULL, 0x000fe40000410000ULL, 0x000000241f1f7220ULL, 0x080fe40000410000ULL,
0x0000002800020308ULL, 0x000ea20000000800ULL, 0x000000241a1a7220ULL, 0x080fe40000410000ULL,
0x000000241b1b7220ULL, 0x000fc40000410000ULL, 0x0000002416167220ULL, 0x080fe40000410000ULL,
0x0000002417177220ULL, 0x080fe40000410000ULL, 0x0000002412127220ULL, 0x080fe40000410000ULL,
0x0000002413137220ULL, 0x080fe40000410000ULL, 0x000000240e0e7220ULL, 0x080fe40000410000ULL,
0x000000240f0f7220ULL, 0x000fc40000410000ULL, 0x000000240a0a7220ULL, 0x080fe40000410000ULL,
0x000000240b0b7220ULL, 0x080fe40000410000ULL, 0x0000002406067220ULL, 0x080fe40000410000ULL,
0x0000002407077220ULL, 0x000fe40000410000ULL, 0x0000002902290220ULL, 0x006fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003e293e7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000083b247824ULL, 0x000fe200078e00ffULL, 0xfffffff048257812ULL, 0x000fc800078ec0ffULL,
0x0000000824247812ULL, 0x000fca00078e0cffULL, 0x0000000125267824ULL, 0x000fca00078e0224ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x0002a4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6f7819ULL, 0x008fe4000001164fULL,
0x00000002ff26723eULL, 0x000fe400000000ffULL, 0x000000186f247810ULL, 0x040fe40007ffe0ffULL,
0x000000106f257810ULL, 0x000fe40007ffe0ffULL, 0x00005410266e7816ULL, 0x010fe20000000026ULL,
0x0000dc327f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e6d7589ULL, 0x0002e400000e0000ULL,
0x0000dc727f007947ULL, 0x000fea000b800000ULL, 0x00001f006e6c7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0025ULL,
0x0000422000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000e84000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0024ULL,
0x0000428000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000e7e000007944ULL, 0x03cfea0003c00000ULL,
0x000010003b257824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100051247824ULL, 0x000fe200078e00ffULL, 0x0000991065657816ULL, 0x000fe400000000ffULL,
0x0000100025257812ULL, 0x000fe400078e0cffULL, 0xffffe00024247812ULL, 0x000fc400078ec0ffULL,
0x000000ff6500720cULL, 0x000fe40003f05270ULL, 0x0000b00024617810ULL, 0x100fe40007ffe025ULL,
0x0000b00040257810ULL, 0x000fc60007ffe025ULL, 0x0000001050537824ULL, 0x100fe400078e0261ULL,
0x000000104e617824ULL, 0x000fe400078e0261ULL, 0x0000001058637824ULL, 0x100fe200078e0225ULL,
0x000000005328783bULL, 0x000f220000004200ULL, 0x0000001059527824ULL, 0x000fc600078e0225ULL,
0x000000006154783bULL, 0x000ee80000004200ULL, 0x00000000632c783bULL, 0x004ea80000004200ULL,
0x000000005224783bULL, 0x000e620000004200ULL, 0x00000018ff7d7819ULL, 0x010fe20000011428ULL,
0x00000100287f7824ULL, 0x040fe200078e00ffULL, 0x00008880287e7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011429ULL,
0x0000010029817824ULL, 0x040fe200078e00ffULL, 0x0000888029807816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000007e00887306ULL, 0x0009e20000200c00ULL, 0x00000018ff7f7819ULL, 0x000fc4000001147fULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff7a7819ULL, 0x000fe4000001142aULL,
0x00000018ff7b7819ULL, 0x000fe2000001142bULL, 0x00000028008a7306ULL, 0x0003e20000200c00ULL,
0x000088802a7e7816ULL, 0x010fe400000000ffULL, 0x00000018ff777819ULL, 0x008fe40000011457ULL,
0x0000888057837816ULL, 0x000fc400000000ffULL, 0x00000018ff797819ULL, 0x000fe20000011455ULL,
0x0000007f00897306ULL, 0x0007e20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011456ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x004fe4000001142dULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000080008b7306ULL, 0x0003e20000200c00ULL, 0x000088802b7f7816ULL, 0x008fc400000000ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff6f7819ULL, 0x000fe2000001142cULL, 0x00000028008f7306ULL, 0x0005e20000200c00ULL,
0x000001002b807824ULL, 0x042fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011454ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe4000001142eULL,
0x00000018ff807819ULL, 0x000fc40000011480ULL, 0x00000029008d7306ULL, 0x0003e20000200c00ULL,
0x0000010054287824ULL, 0x004fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff747819ULL, 0x000fe4000001142fULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002a00917306ULL, 0x0005e20000200c00ULL, 0x0000888055297816ULL, 0x002fe400000000ffULL,
0x00000018ff707819ULL, 0x000fc40000011424ULL, 0x00000018ff737819ULL, 0x000fe40000011425ULL,
0x00000018ff6e7819ULL, 0x000fe20000011426ULL, 0x0000002800947306ULL, 0x0003e20000200c00ULL,
0x00000100552a7824ULL, 0x044fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011427ULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002900957306ULL, 0x0005e20000200c00ULL, 0x0000010056287824ULL, 0x002fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc80000011455ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002b00927306ULL, 0x0003e20000200c00ULL, 0x0000010057297824ULL, 0x044fe400078e00ffULL,
0x0001000057577824ULL, 0x000fca00078e00ffULL, 0x0000002800827306ULL, 0x0005e20000200c00ULL,
0x00000018ff2b7819ULL, 0x002fce0000011457ULL, 0x0000007f00907306ULL, 0x0003e20000200c00ULL,
0x000001002c287824ULL, 0x004fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011428ULL,
0x0000020051287824ULL, 0x000fe200078e00ffULL, 0x0000005500987306ULL, 0x0005e20000200c00ULL,
0x00008880567f7816ULL, 0x042fe200000000ffULL, 0x0001000056567824ULL, 0x000fcc00078e00ffULL,
0x0000002a00967306ULL, 0x0002e20000200c00ULL, 0xfffff80028557812ULL, 0x004fe200078ec0ffULL,
0x000001002d287824ULL, 0x000fc800078e00ffULL, 0x0000000164647824ULL, 0x000fe200078e0255ULL,
0x00000018ff877819ULL, 0x000fe20000011428ULL, 0x0000002b009c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2a7819ULL, 0x002fe20000011429ULL, 0x0000000166657824ULL, 0x000fe200078e0255ULL,
0x00000018ff297819ULL, 0x000fe40000011456ULL, 0x000088802c567816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe400078e00ffULL, 0x0000002a009a7306ULL, 0x000fe20000200c00ULL,
0x0000541095957816ULL, 0x008fc40000000096ULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x0000002900977306ULL, 0x0003f00000200c00ULL, 0x0000007e008e7306ULL, 0x0005e20000200c00ULL,
0x009800006428783bULL, 0x002e6e0000000200ULL, 0x00000081008c7306ULL, 0x0007220000200c00ULL,
0x000088802d7e7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x0000888054817816ULL, 0x048fe200000000ffULL, 0x0001000054547824ULL, 0x000fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000002d00867306ULL, 0x0007f00000200c00ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000001002f2d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002c00847306ULL, 0x0007e20000200c00ULL,
0x0000006d28288232ULL, 0x082fe40000000000ULL, 0x0000006d2a2a8232ULL, 0x000fe40000000000ULL,
0x0000006c29298232ULL, 0x080fe40000000000ULL, 0x0000006c2b2b8232ULL, 0x000fe20000000000ULL,
0x0000008000937306ULL, 0x0003e20000200c00ULL, 0x000088802f2c7816ULL, 0x048fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000005400857306ULL, 0x0007e20000200c00ULL, 0x000088802e807816ULL, 0x002fce00000000ffULL,
0x0000002c009b7306ULL, 0x0003e20000200c00ULL, 0x000001002e547824ULL, 0x048fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000002d00a07306ULL, 0x0009e20000200c00ULL, 0x00005410882c7816ULL, 0x002fe40000000089ULL,
0x00000018ff2e7819ULL, 0x000fca000001142eULL, 0x0000002e009e7306ULL, 0x0003e20000200c00ULL,
0x000054108b2d7816ULL, 0x010fce000000008cULL, 0x0000002c2820723cULL, 0x000fe20000001820ULL,
0x00000100242e7824ULL, 0x002fe200078e00ffULL, 0x0000002f009f7306ULL, 0x0003e80000200c00ULL,
0x00000018ff557819ULL, 0x000fe4000001142eULL, 0x000054108a2c7816ULL, 0x004fe4000000007dULL,
0x000054108d2d7816ULL, 0x000fe2000000007cULL, 0x0000005400997306ULL, 0x0005e20000200c00ULL,
0x00008880257c7816ULL, 0x000fca00000000ffULL, 0x0000002c281c723cULL, 0x000fe2000000181cULL,
0x00980000652c783bULL, 0x002e620000000200ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x0000888024547816ULL, 0x044fe200000000ffULL, 0x0001000024247824ULL, 0x000fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000007900797306ULL, 0x000eb00000200c00ULL,
0x0000005400667306ULL, 0x0009e20000200c00ULL, 0x0000541085787816ULL, 0x008fce0000000078ULL,
0x00000055007d7306ULL, 0x0007e20000200c00ULL, 0x000054108e547816ULL, 0x010fe4000000008fULL,
0x0000541098797816ULL, 0x004fca0000000079ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000541090557816ULL, 0x008fe20000000093ULL, 0x00000078280c723cULL, 0x000fe2000000180cULL,
0x0000006d2c2c8232ULL, 0x002fca0000000000ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x0000006d2e2e8232ULL, 0x000fe20000000000ULL, 0x000000542818723cULL, 0x000fe20000001818ULL,
0x00000100266d7824ULL, 0x000fe200078e00ffULL, 0x0000006c2d2d8232ULL, 0x080fe40000000000ULL,
0x0000006c2f2f8232ULL, 0x000fe40000000000ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x000000ffff547224ULL, 0x000fe200078e007cULL, 0x00005410917a7816ULL, 0x004fe2000000007aULL,
0x00000100257c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x00005410927b7816ULL, 0x002fe4000000007bULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff7c7819ULL, 0x000fc6000001147cULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541097767816ULL, 0x008fe20000000076ULL, 0x0000007a2814723cULL, 0x000fec0000001814ULL,
0x0000007f007f7306ULL, 0x000ee20000200c00ULL, 0x000054109c777816ULL, 0x004fce0000000077ULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541081947816ULL, 0x002fe20000000094ULL,
0x000000762804723cULL, 0x000fe20000001804ULL, 0x000054109b817816ULL, 0x000fe400000000a0ULL,
0x000054107f827816ULL, 0x008fc60000000082ULL, 0x0000006f006f7306ULL, 0x000e640000200c00ULL,
0x000000942810723cULL, 0x000fe20000001810ULL, 0x0000541083837816ULL, 0x004fca000000009aULL,
0x0000002400557306ULL, 0x0005e40000200c00ULL, 0x000000822808723cULL, 0x000fec0000001808ULL,
0x0000002500787306ULL, 0x0007e20000200c00ULL, 0x0000888026247816ULL, 0x044fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000541084847816ULL, 0x002fc8000000006fULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400797306ULL, 0x0003e20000200c00ULL,
0x0000888027257816ULL, 0x008fce00000000ffULL, 0x0000002500297306ULL, 0x0005e20000200c00ULL,
0x0000010027247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0001000027257824ULL, 0x004fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000005600567306ULL, 0x000ff00000200c00ULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x000054109e9e7816ULL, 0x002fce0000000071ULL,
0x0000007500757306ULL, 0x000e700000200c00ULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x0000541056567816ULL, 0x004fce0000000057ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000541086857816ULL, 0x002fce0000000075ULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x000054109f9f7816ULL, 0x008fe20000000074ULL, 0x000000842c1c723cULL, 0x040fec000000181cULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541055707816ULL, 0x004fe20000000070ULL,
0x0000009e2c14723cULL, 0x000fec0000001814ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541078717816ULL, 0x002fce0000000073ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x000000702c0c723cULL, 0x000fee000000180cULL, 0x0000008700877306ULL, 0x000e700000200c00ULL,
0x0000008000807306ULL, 0x000eb00000200c00ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054107e577816ULL, 0x002fce0000000087ULL, 0x0000007c007b7306ULL, 0x000fe20000200c00ULL,
0x0000541080807816ULL, 0x004fe20000000099ULL, 0x000000562c20723cULL, 0x040fec0000001820ULL,
0x0000006d00287306ULL, 0x000e640000200c00ULL, 0x000000802c18723cULL, 0x000fec0000001818ULL,
0x00000024002a7306ULL, 0x0004f00000200c00ULL, 0x0000002600277306ULL, 0x000f220000200c00ULL,
0x0000541066247816ULL, 0x004fc4000000007dULL, 0x0000541079287816ULL, 0x002fca0000000028ULL,
0x00000025006f7306ULL, 0x0002a20000200c00ULL, 0x0000541029297816ULL, 0x008fe4000000002aULL,
0x00005410276e7816ULL, 0x010fca000000006eULL, 0x000000282c08723cULL, 0x000fe20000001808ULL,
0x0000541054257816ULL, 0x002fe4000000007bULL, 0x000054106f6f7816ULL, 0x004fca0000000072ULL,
0x000000242c10723cULL, 0x040ff00000001810ULL, 0x0000006e2c04723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003d247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008039247810ULL, 0x004fe20007ffe0ffULL, 0x00f690005eff7f8cULL, 0x0005e2000c80043fULL,
0x000000013b557812ULL, 0x000fc400078ec0ffULL, 0x0000004d2400720cULL, 0x000fda0003f06070ULL,
0x00003c6000000947ULL, 0x000fea0003800000ULL, 0x0000040062247984ULL, 0x004ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003d247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400267305ULL, 0x0004e4000021f000ULL,
0x3fa0000024247823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x000024003d267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000016b6a7824ULL, 0x000fe400078e026aULL,
0x00005800452a7a24ULL, 0x020fe200078e02ffULL, 0x00000001ff447819ULL, 0x000fe20000011651ULL,
0xffffffffff457424ULL, 0x000fe200078e00ffULL, 0x000000036a247812ULL, 0x000fc800078ec0ffULL,
0x000000032400780cULL, 0x000fc80003f05270ULL, 0x0000000146477807ULL, 0x000fca0004000000ULL,
0x000000016a477824ULL, 0x000fca00078e0247ULL, 0x0000004c4700720cULL, 0x000fe20003f06070ULL,
0x0000002044267824ULL, 0x000fe200078e0239ULL, 0x000000014b277810ULL, 0x000fc80007ffe0ffULL,
0x000000c026267810ULL, 0x000fe40007ffe0ffULL, 0x0000004a2700720cULL, 0x000fca0003f46070ULL,
0x000000013c248824ULL, 0x000fe400078e0247ULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000002041277812ULL, 0x000fc600078ef826ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x000000264d297217ULL, 0x000fc60007800000ULL, 0x000000402a2b7824ULL, 0x000fe200078e00ffULL,
0x0000000624458981ULL, 0x000562000c1e1900ULL, 0x0000001051287824ULL, 0x000fe200078e00ffULL,
0x00000003ff547819ULL, 0x000fe2000001164fULL, 0x0000000129297824ULL, 0x000fe200078e0a26ULL,
0x00000000600473c2ULL, 0x000ee200000e0000ULL, 0x0000000136267824ULL, 0x100fe200078e0227ULL,
0x00000010282a7812ULL, 0x000fe400078ec0ffULL, 0x0000002029297807ULL, 0x000fe20001000000ULL,
0x000000013a247824ULL, 0x104fe200078e0227ULL, 0x000000262b267210ULL, 0x040fe20007f7e0ffULL,
0x0000000138257824ULL, 0x100fe200078e0227ULL, 0x000000292a297217ULL, 0x000fe20007800000ULL,
0x0000000134277824ULL, 0x000fe200078e0227ULL, 0x000000242b247210ULL, 0x000fc40007f1e0ffULL,
0x000000252b2e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000129297824ULL, 0x000fe200078e0a2aULL,
0x000000272b277210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0024577a11ULL, 0x000fe200078038ffULL, 0x000000ffff557224ULL, 0x000fe200010e06ffULL,
0x00005e00262d7a11ULL, 0x000fe200078438ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005f0024287a11ULL, 0x000fe200000f3c25ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x0000000454247810ULL, 0x000fc40007ffe0ffULL, 0x00005e00272b7a11ULL, 0x000fe400078638ffULL,
0x00005f00262a7a11ULL, 0x000fe400010f3c25ULL, 0x000000292400720cULL, 0x000fe40003f46070ULL,
0x00005e002e2f7a11ULL, 0x000fe400078038ffULL, 0x0000003057247210ULL, 0x000fe40007f9e0ffULL,
0x0000000854267810ULL, 0x000fc40007ffe0ffULL, 0x00005f00272c7a11ULL, 0x000fe200018f3c2cULL,
0x000000ffff257224ULL, 0x000fe200020e0628ULL, 0x00005f002e2e7a11ULL, 0x000fe400000f3c55ULL,
0x000000295400720cULL, 0x080fe40003f66070ULL, 0x000000292600720cULL, 0x000fe40003f06070ULL,
0x0000000c54547810ULL, 0x000fe40007ffe0ffULL, 0x000000302f267210ULL, 0x000fc40007fbe0ffULL,
0x000000302d287210ULL, 0x080fe40007fde0ffULL, 0x000000295400720cULL, 0x000fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe400028e062eULL, 0x000000ffff297224ULL, 0x000fe200030e062aULL,
0x000000302b2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245a7faeULL, 0x0005e8000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062cULL,
0x00000000265b7faeULL, 0x0005e8000d101c46ULL, 0x00000000285c7faeULL, 0x0005e8000c101c46ULL,
0x000000002a5d7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000605a7f8cULL, 0x0044e8000c80043fULL,
0x000004005f267984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480031247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x010fc60007844867ULL, 0x00f64c0031277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe048317812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff267424ULL, 0x000fe200078e00ffULL,
0x0000001048287812ULL, 0x040fe400078ec0ffULL, 0x0000000848277812ULL, 0x000fc800078ec0ffULL,
0x0000003127317210ULL, 0x000fe40007ffe028ULL, 0x0000002600277305ULL, 0x000864000021f000ULL,
0x3fa0000026267823ULL, 0x010fe200000100ffULL, 0x000000270000735dULL, 0x002fe40003800000ULL,
0x00f64c0031277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002051247824ULL, 0x000fca00078e00ffULL,
0xffffff8024257812ULL, 0x000fc800078ec0ffULL, 0x0000010030247810ULL, 0x000fca0007ffe025ULL,
0x0000000103247824ULL, 0x000fca00078e0224ULL, 0x00f0000024287984ULL, 0x000f280000000800ULL,
0x00f2000024297984ULL, 0x0002a20000000800ULL, 0x0000003f2800720bULL, 0x010fe20003f1d000ULL,
0x0000c3c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7e7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000249247810ULL, 0x000fe40007ffe0ffULL, 0x0000003f2800720bULL, 0x000fe40003f14000ULL,
0x000000512400720cULL, 0x000fe20003f65270ULL, 0x0000c3927f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000283f267209ULL, 0x000fe20007810000ULL,
0x00000080512cb824ULL, 0x000fe200078e0230ULL, 0x0000ffff24277812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe2000001164fULL, 0x00000001032bb824ULL, 0x000fe200078e022cULL,
0x000000272aff7212ULL, 0x000fe2000780c0ffULL, 0x800000263f257221ULL, 0x000fc60000010000ULL,
0x00f400262b00b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x00000025006e7308ULL, 0x000f240000000800ULL, 0x0000006e3e3e7220ULL, 0x010fe20000410000ULL,
0x0000c3227f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e247589ULL, 0x00232400000e0000ULL,
0x0000002420207220ULL, 0x090fe40000410000ULL, 0x0000002421217220ULL, 0x080fe40000410000ULL,
0x000000241c1c7220ULL, 0x080fe40000410000ULL, 0x000000241d1d7220ULL, 0x080fe40000410000ULL,
0x0000002418187220ULL, 0x000fc40000410000ULL, 0x0000002419197220ULL, 0x080fe40000410000ULL,
0x0000002414147220ULL, 0x080fe40000410000ULL, 0x0000002415157220ULL, 0x080fe40000410000ULL,
0x0000002410107220ULL, 0x080fe40000410000ULL, 0x0000002411117220ULL, 0x080fe40000410000ULL,
0x000000240c0c7220ULL, 0x000fc40000410000ULL, 0x000000240d0d7220ULL, 0x080fe40000410000ULL,
0x0000002408087220ULL, 0x080fe40000410000ULL, 0x0000002409097220ULL, 0x080fe40000410000ULL,
0x0000002404047220ULL, 0x080fe40000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000c2627f007947ULL, 0x000fea000b800000ULL, 0x00001f006e247589ULL, 0x00086400000e0000ULL,
0x000000283f3f7209ULL, 0x000fe20007810000ULL, 0x0000002422227220ULL, 0x082fe20000410000ULL,
0x00000001ff7e7807ULL, 0x000fe20000000000ULL, 0x0000002423237220ULL, 0x000fc40000410000ULL,
0x8000003f28280221ULL, 0x000fe40000010000ULL, 0x000000241e1e7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b28280820ULL, 0x000fe40000410000ULL, 0x000000241f1f7220ULL, 0x080fe40000410000ULL,
0x0000002800020308ULL, 0x000e620000000800ULL, 0x000000241a1a7220ULL, 0x080fe40000410000ULL,
0x000000241b1b7220ULL, 0x000fc40000410000ULL, 0x0000002416167220ULL, 0x080fe40000410000ULL,
0x0000002417177220ULL, 0x080fe40000410000ULL, 0x0000002412127220ULL, 0x080fe40000410000ULL,
0x0000002413137220ULL, 0x080fe40000410000ULL, 0x000000240e0e7220ULL, 0x080fe40000410000ULL,
0x000000240f0f7220ULL, 0x000fc40000410000ULL, 0x000000240a0a7220ULL, 0x080fe40000410000ULL,
0x000000240b0b7220ULL, 0x080fe40000410000ULL, 0x0000002406067220ULL, 0x080fe40000410000ULL,
0x0000002407077220ULL, 0x000fe40000410000ULL, 0x0000002902290220ULL, 0x006fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003e293e7221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000868247812ULL, 0x000fe400078ec0ffULL, 0xfffffff048257812ULL, 0x000fca00078ec0ffULL,
0x0000000125247824ULL, 0x000fcc00078e0224ULL, 0x00f6ac0024247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400257305ULL, 0x0002a4000021f000ULL, 0x3fa0000024247823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe20003800000ULL, 0x000004005f267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff6f7819ULL, 0x000fe4000001164fULL, 0x00000002ff26723eULL, 0x000fe400000000ffULL,
0x000000186f247810ULL, 0x040fe40007ffe0ffULL, 0x000000106f257810ULL, 0x000fe40007ffe0ffULL,
0x00005410266e7816ULL, 0x010fe20000000026ULL, 0x0000bfc27f007947ULL, 0x000fea000b800000ULL,
0x00001f6f6e5d7589ULL, 0x0002a400000e0000ULL, 0x0000c0027f007947ULL, 0x000fea000b800000ULL,
0x00001f006e5c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0025ULL, 0x000060f000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000c97000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0024ULL, 0x0000615000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000c91000007944ULL, 0x03cfea0003c00000ULL, 0x0000100069557812ULL, 0x000fe200078ec0ffULL,
0x00001000512c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000099107e7e7816ULL, 0x000fe400000000ffULL, 0x0000b00040247810ULL, 0x000fe40007ffe055ULL,
0xffffe0002c2c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff7e00720cULL, 0x000fe20003f05270ULL,
0x0000001058287824ULL, 0x100fe200078e0224ULL, 0x0000b0002c557810ULL, 0x000fe20007ffe055ULL,
0x0000001059247824ULL, 0x000fc800078e0224ULL, 0x00000010502c7824ULL, 0x100fe200078e0255ULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x000000104e557824ULL, 0x000fc600078e0255ULL,
0x000000002424783bULL, 0x000fe80000004200ULL, 0x000000002c2c783bULL, 0x004ea80000004200ULL,
0x000000005554783bULL, 0x000ee20000004200ULL, 0x00000018ff6b7819ULL, 0x010fe2000001142bULL,
0x00000100296c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011428ULL,
0x000001002a737824ULL, 0x002fe200078e00ffULL, 0x0000006b004e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff597819ULL, 0x000fc40000011429ULL, 0x00000018ff587819ULL, 0x000fe2000001142aULL,
0x000001002d827824ULL, 0x004fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001142cULL,
0x000100002f8c7824ULL, 0x000fe200078e00ffULL, 0x000088802a727816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x002fe2000001142dULL,
0x0000006a00817306ULL, 0x0003e20000200c00ULL, 0x00000018ff757819ULL, 0x000fe20000011473ULL,
0x00010000557e7824ULL, 0x008fe200078e00ffULL, 0x000088802b737816ULL, 0x000fe200000000ffULL,
0x00000100548e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000010056907824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001142eULL,
0x0000006b00837306ULL, 0x0005e20000200c00ULL, 0x00008880286a7816ULL, 0x002fc400000000ffULL,
0x000088802e857816ULL, 0x000fe400000000ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001142fULL,
0x000088802f887816ULL, 0x000fe200000000ffULL, 0x0000002a007d7306ULL, 0x000fe20000200c00ULL,
0x00000100286b7824ULL, 0x044fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff6d7819ULL, 0x000fc4000001146bULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00008880296b7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011454ULL,
0x00008880548d7816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x00000028006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7e7819ULL, 0x000fc4000001147eULL, 0x00000018ff7c7819ULL, 0x000fe40000011455ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff6e7819ULL, 0x000fe20000011456ULL,
0x0000002900707306ULL, 0x0005e20000200c00ULL, 0x000001002b287824ULL, 0x042fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011457ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000010024297824ULL, 0x004fe200078e00ffULL,
0x0000002800747306ULL, 0x0003e20000200c00ULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff677819ULL, 0x000fe40000011424ULL, 0x00000018ff767819ULL, 0x000fe20000011429ULL,
0x000001002c297824ULL, 0x000fe200078e00ffULL, 0x0000888024797816ULL, 0x040fe200000000ffULL,
0x0000002b007b7306ULL, 0x0005e20000200c00ULL, 0x0000010025287824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011425ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff787819ULL, 0x000fe40000011428ULL,
0x000088802c287816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x000088802d2b7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000888025777816ULL, 0x000fe200000000ffULL, 0x0000002c002a7306ULL, 0x0002a20000200c00ULL,
0x00000018ff687819ULL, 0x000fe40000011427ULL, 0x00000018ff667819ULL, 0x000fe40000011426ULL,
0x00000018ff6c7819ULL, 0x000fc6000001146cULL, 0x0000002d00847306ULL, 0x0007e20000200c00ULL,
0x000001002e2c7824ULL, 0x042fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001142cULL, 0x000001002f2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001142eULL, 0x0000002800287306ULL, 0x000e620000200c00ULL,
0x000054102a2a7816ULL, 0x004fe40000000081ULL, 0x00000018ff8a7819ULL, 0x000fe4000001142cULL,
0x00a00000642c783bULL, 0x008ea60000000200ULL, 0x0000002b002b7306ULL, 0x000ee20000200c00ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000054102b297816ULL, 0x008fce0000000082ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410842b7816ULL, 0x000fe20000000083ULL, 0x0001000057827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008700897306ULL, 0x0003f00000200c00ULL,
0x0000008c008c7306ULL, 0x000ee20000200c00ULL, 0x0000888055877816ULL, 0x002fe200000000ffULL,
0x0000005d2c2c8232ULL, 0x004fc40000000000ULL, 0x0000005d2e2e8232ULL, 0x000fe40000000000ULL,
0x0000005c2d2d8232ULL, 0x080fe40000000000ULL, 0x0000007e00917306ULL, 0x000fe20000200c00ULL,
0x0000005c2f2f8232ULL, 0x000fe20000000000ULL, 0x000054108c7f7816ULL, 0x008fcc000000007fULL,
0x000000282c20723cULL, 0x040fe20000001820ULL, 0x0000008a008b7306ULL, 0x0003ec0000200c00ULL,
0x0000010057287824ULL, 0x000fe200078e00ffULL, 0x0000002a2c1c723cULL, 0x000fe2000000181cULL,
0x00000087008f7306ULL, 0x0005e20000200c00ULL, 0x00000100558a7824ULL, 0x002fc400078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011428ULL, 0x00a000006528783bULL, 0x000e620000000200ULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x0000888056877816ULL, 0x044fe200000000ffULL, 0x0001000056567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000007c007c7306ULL, 0x000eb00000200c00ULL,
0x0000005400557306ULL, 0x0007f00000200c00ULL, 0x0000007e00817306ULL, 0x0009e20000200c00ULL,
0x0000888057547816ULL, 0x008fce00000000ffULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00005410897e7816ULL, 0x010fe20000000080ULL, 0x0000005d28288232ULL, 0x082fe40000000000ULL,
0x0000005d2a2a8232ULL, 0x000fc80000000000ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000007e2c14723cULL, 0x000fe20000001814ULL, 0x0000005c29298232ULL, 0x080fe40000000000ULL,
0x0000005c2b2b8232ULL, 0x000fc80000000000ULL, 0x0000008700927306ULL, 0x000fe20000200c00ULL,
0x00010000257e7824ULL, 0x000fe200078e00ffULL, 0x0000541091257816ULL, 0x004fc8000000007cULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000009000937306ULL, 0x000e700000200c00ULL,
0x0000005600577306ULL, 0x000ff00000200c00ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x0000541092927816ULL, 0x002fce0000000093ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000008800887306ULL, 0x000eb00000200c00ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x0000541085867816ULL, 0x002fce0000000086ULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x0000541088877816ULL, 0x004fce000000008bULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x000000862c18723cULL, 0x000fee0000001818ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x000054108d8e7816ULL, 0x002fce000000008eULL,
0x0000002400567306ULL, 0x0003e20000200c00ULL, 0x000054108f8f7816ULL, 0x004fce000000008aULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541055247816ULL, 0x002fe2000000007aULL,
0x0000008e2c10723cULL, 0x040fe20000001810ULL, 0x0000541054937816ULL, 0x008fe20000000081ULL,
0x0000010026557824ULL, 0x040fe200078e00ffULL, 0x0000888026547816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe400078e00ffULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x000000242c0c723cULL, 0x000fe2000000180cULL,
0x00000018ff267819ULL, 0x000fca0000011426ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541057247816ULL, 0x000fe2000000006eULL, 0x000000922c08723cULL, 0x000fe20000001808ULL,
0x0000541082257816ULL, 0x000fca0000000071ULL, 0x0000005400547306ULL, 0x000fe40000200c00ULL,
0x000000242c04723cULL, 0x000fec0000001804ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x0000888027247816ULL, 0x040fe200000000ffULL, 0x00000100272c7824ULL, 0x040fe200078e00ffULL,
0x0000541070257816ULL, 0x002fe20000000059ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000541056567816ULL, 0x004fc40000000067ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000024002d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x000054107b597816ULL, 0x000fca000000004eULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000054106f247816ULL, 0x002fe40000000050ULL, 0x0000541054547816ULL, 0x008fca0000000055ULL,
0x00000024281c723cULL, 0x000fe2000000181cULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000054107d587816ULL, 0x004fce0000000058ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000000582814723cULL, 0x000fee0000001814ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x0000006a006a7306ULL, 0x000ff00000200c00ULL, 0x0000006d006d7306ULL, 0x000e700000200c00ULL,
0x0000006b006b7306ULL, 0x000ff00000200c00ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x000054106a6a7816ULL, 0x002fce000000006dULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x000054106b6b7816ULL, 0x004fce000000006cULL,
0x0000007300737306ULL, 0x000ea20000200c00ULL, 0x0000006a2820723cULL, 0x000fee0000001820ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x002fce0000000075ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000541073737816ULL, 0x004fce0000000074ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x000000722818723cULL, 0x000fee0000001818ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541079767816ULL, 0x002fce0000000076ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000002c002c7306ULL, 0x000ee20000200c00ULL,
0x0000541077777816ULL, 0x004fce0000000078ULL, 0x0000002600257306ULL, 0x000ea20000200c00ULL,
0x000054107e577816ULL, 0x002fe20000000069ULL, 0x000000762810723cULL, 0x040fec0000001810ULL,
0x0000002700277306ULL, 0x000e620000200c00ULL, 0x000054102d557816ULL, 0x008fe2000000002cULL,
0x00000056280c723cULL, 0x000fe2000000180cULL, 0x0000541025667816ULL, 0x004fce0000000066ULL,
0x000000542808723cULL, 0x000fe20000001808ULL, 0x0000541027677816ULL, 0x002fce0000000068ULL,
0x000000662804723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003d247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c039247810ULL, 0x004fe20007ffe0ffULL,
0x00f698005eff7f8cULL, 0x0005e2000c80043fULL, 0x000000013b557812ULL, 0x000fe200078e0cffULL,
0x000000ffff677224ULL, 0x000fe200078e005bULL, 0x0000004d2400720cULL, 0x000fda0003f06070ULL,
0x00001de000000947ULL, 0x000fea0003800000ULL, 0x0000040062247984ULL, 0x004ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003d247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400267305ULL, 0x0004e4000021f000ULL,
0x3fa0000024247823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x000024003d267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000347247812ULL, 0x000fe200078ec0ffULL,
0x0000580045287a24ULL, 0x020fe200078e02ffULL, 0x000003004b277a10ULL, 0x000fe20007ffe0ffULL,
0xffffffffff457424ULL, 0x000fe200078e00ffULL, 0x000000032400780cULL, 0x000fc80003f05270ULL,
0x0000000146247807ULL, 0x000fca0004000000ULL, 0x0000000147477824ULL, 0x000fca00078e0224ULL,
0x0000004c4700720cULL, 0x000fe20003f06070ULL, 0x0000010027267824ULL, 0x040fe200078e0242ULL,
0x0000000127277810ULL, 0x000fd60007ffe0ffULL, 0x000000013c248824ULL, 0x000fe400078e0247ULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x000000264d297217ULL, 0x000fc80007800000ULL, 0x0000000624458981ULL, 0x000562000c1e1900ULL,
0x0000004a2700720cULL, 0x000fe20003f06070ULL, 0x0000000129297824ULL, 0x100fe200078e0a26ULL,
0x0000002041277812ULL, 0x000fe200078ef826ULL, 0x00000040282d7824ULL, 0x000fe200078e00ffULL,
0x000000005f0473c2ULL, 0x000ee200000e0000ULL, 0x0000001051267824ULL, 0x000fe200078e00ffULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x0000000138387824ULL, 0x100fe400078e0227ULL,
0x000000013a3a7824ULL, 0x100fe200078e0227ULL, 0x0000001026267812ULL, 0x000fe200078ec0ffULL,
0x0000000136367824ULL, 0x100fe200078e0227ULL, 0x000000382d387210ULL, 0x040fe20007f5e0ffULL,
0x0000000134277824ULL, 0x000fe200078e0227ULL, 0x0000003a2d3a7210ULL, 0x000fc40007f1e0ffULL,
0x000000362d367210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x004fe200010e06ffULL,
0x00005e00382f7a11ULL, 0x000fe200078438ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x0000002926297217ULL, 0x000fe40007800000ULL, 0x00005e003a397a11ULL, 0x000fe400078038ffULL,
0x00005f0038287a11ULL, 0x000fe200010f3c25ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x000000272d277210ULL, 0x000fe20007f9e0ffULL, 0x0000000129297824ULL, 0x000fe200078e0a26ULL,
0x00005f003a347a11ULL, 0x000fc400000f3c2bULL, 0x00005e00362d7a11ULL, 0x040fe200078038ffULL,
0x000000ffff2e7224ULL, 0x000fe200020e06ffULL, 0x00000003ff267819ULL, 0x000fe4000001164fULL,
0x00005f00362a7a11ULL, 0x000fe200000f3c25ULL, 0x000010003b257824ULL, 0x000fe200078e00ffULL,
0x0000000826247810ULL, 0x040fe40007ffe0ffULL, 0x00000004262c7810ULL, 0x040fe40007ffe0ffULL,
0x000000292600720cULL, 0x000fc40003f66070ULL, 0x0000000c26367810ULL, 0x000fe40007ffe0ffULL,
0x00005e00272b7a11ULL, 0x000fe400078438ffULL, 0x000000302f267210ULL, 0x080fe40007fbe0ffULL,
0x000000292400720cULL, 0x000fe40003f06070ULL, 0x0000100025257812ULL, 0x000fe400078ec0ffULL,
0x0000003039247210ULL, 0x000fc40007f9e0ffULL, 0x00005f00272e7a11ULL, 0x000fe200010f3c2eULL,
0x000000ffff277224ULL, 0x000fe200028e0628ULL, 0x000000292c00720cULL, 0x080fe40003f46070ULL,
0x000000302d287210ULL, 0x080fe40007fbe0ffULL, 0x0000b000402c7810ULL, 0x000fe20007ffe025ULL,
0x000000ffff257224ULL, 0x000fe200020e0634ULL, 0x000000293600720cULL, 0x000fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e062aULL, 0x000000302b2a7210ULL, 0x000fe20007fbe0ffULL,
0x0000001037377824ULL, 0x000fc400078e022cULL, 0x0000001035357824ULL, 0x100fe400078e022cULL,
0x0000001033337824ULL, 0x100fe200078e022cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024377faeULL, 0x0005e2000d901c46ULL, 0x00000010322d7824ULL, 0x000fe400078e022cULL,
0x000000ffff2b7224ULL, 0x000fe200028e062eULL, 0x0000000026357faeULL, 0x0005e8000d101c46ULL,
0x0000000028337faeULL, 0x0005e8000c101c46ULL, 0x000000002a2d7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005f667f8cULL, 0x000728000c80043fULL, 0x0000040060277984ULL, 0x0046a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680031247f8cULL, 0x000fe2000c80043fULL, 0x8000000027ff7812ULL, 0x004fc6000784485bULL,
0x00f66c0031297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff267424ULL, 0x000fc800078e00ffULL,
0x0000002600277305ULL, 0x000464000021f000ULL, 0x3fa0000026267823ULL, 0x004fe200000100ffULL,
0x000000270000735dULL, 0x002fe40003800000ULL, 0x00f66c0031277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002051247824ULL, 0x000fca00078e00ffULL, 0xffffff8024257812ULL, 0x000fc800078ec0ffULL,
0x0000018030247810ULL, 0x000fca0007ffe025ULL, 0x0000000103247824ULL, 0x000fca00078e0224ULL,
0x00f0000024287984ULL, 0x000ea80000000800ULL, 0x00f2000024297984ULL, 0x0002e20000000800ULL,
0x0000003f2800720bULL, 0x004fe20003f1d000ULL, 0x0000a7927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff587424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000349247810ULL, 0x000fe40007ffe0ffULL,
0x0000003f2800720bULL, 0x000fe40003f14000ULL, 0x000000512400720cULL, 0x000fe20003f65270ULL,
0x0000a7627f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000283f2b7209ULL, 0x000fe20007810000ULL, 0x000000805130b824ULL, 0x000fe200078e0230ULL,
0x00000002ff6f7819ULL, 0x000fc6000001164fULL, 0x000000010330b824ULL, 0x000fe200078e0230ULL,
0x0000ffff24037812ULL, 0x000fe200078e3cffULL, 0x8000002b3f257221ULL, 0x000fc60000010000ULL,
0x00f4002b3000b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x000000032aff7212ULL, 0x000fc6000780c0ffULL, 0x00000025006e7308ULL, 0x000ea40000000800ULL,
0x0000006e3e3e7220ULL, 0x004fe20000410000ULL, 0x0000a6f27f007947ULL, 0x000fea000b800000ULL,
0x00001f6f6e037589ULL, 0x0022a400000e0000ULL, 0x0000000320207220ULL, 0x084fe40000410000ULL,
0x0000000321217220ULL, 0x080fe40000410000ULL, 0x000000031c1c7220ULL, 0x080fe40000410000ULL,
0x000000031d1d7220ULL, 0x080fe40000410000ULL, 0x0000000318187220ULL, 0x000fc40000410000ULL,
0x0000000319197220ULL, 0x080fe40000410000ULL, 0x0000000314147220ULL, 0x080fe40000410000ULL,
0x0000000315157220ULL, 0x080fe40000410000ULL, 0x0000000310107220ULL, 0x080fe40000410000ULL,
0x0000000311117220ULL, 0x080fe40000410000ULL, 0x000000030c0c7220ULL, 0x000fc40000410000ULL,
0x000000030d0d7220ULL, 0x080fe40000410000ULL, 0x0000000308087220ULL, 0x080fe40000410000ULL,
0x0000000309097220ULL, 0x080fe40000410000ULL, 0x0000000304047220ULL, 0x080fe40000410000ULL,
0x0000000305057220ULL, 0x000fe20000410000ULL, 0x0000a6327f007947ULL, 0x000fea000b800000ULL,
0x00001f006e037589ULL, 0x00046400000e0000ULL, 0x8000002b28280221ULL, 0x000fe20000010000ULL,
0x00000001ff587807ULL, 0x000fe20000000000ULL, 0x0000000322227220ULL, 0x002fc40000410000ULL,
0x3fb8aa3b28280820ULL, 0x000fe40000410000ULL, 0x0000000323237220ULL, 0x080fe40000410000ULL,
0x0000002800020308ULL, 0x000e620000000800ULL, 0x000000031e1e7220ULL, 0x080fe40000410000ULL,
0x000000031f1f7220ULL, 0x080fe40000410000ULL, 0x000000031a1a7220ULL, 0x080fe40000410000ULL,
0x000000031b1b7220ULL, 0x000fc40000410000ULL, 0x0000000316167220ULL, 0x080fe40000410000ULL,
0x0000000317177220ULL, 0x080fe40000410000ULL, 0x0000000312127220ULL, 0x080fe40000410000ULL,
0x0000000313137220ULL, 0x080fe40000410000ULL, 0x000000030e0e7220ULL, 0x080fe40000410000ULL,
0x000000030f0f7220ULL, 0x000fc40000410000ULL, 0x000000030a0a7220ULL, 0x080fe40000410000ULL,
0x000000030b0b7220ULL, 0x080fe40000410000ULL, 0x0000000306067220ULL, 0x080fe40000410000ULL,
0x0000000307077220ULL, 0x000fe40000410000ULL, 0x000000ffff3f7224ULL, 0x000fe400078e002bULL,
0x0000002902290220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003e293e7221ULL, 0x008fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000083b037824ULL, 0x000fe200078e00ffULL,
0xfffffff048247812ULL, 0x000fc800078ec0ffULL, 0x0000000803037812ULL, 0x000fca00078e0cffULL,
0x0000000124037824ULL, 0x000fcc00078e0203ULL, 0x00f6ac0003037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300247305ULL, 0x0002e4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x008fe20003800000ULL, 0x0000040060257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780485bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff6f7819ULL, 0x000fe4000001164fULL, 0x00000002ff03723eULL, 0x000fe400000000ffULL,
0x000000186f247810ULL, 0x040fe40007ffe0ffULL, 0x000000106f257810ULL, 0x000fe40007ffe0ffULL,
0x00005410036e7816ULL, 0x004fe20000000003ULL, 0x0000a3827f007947ULL, 0x000fea000b800000ULL,
0x00001f6f6e037589ULL, 0x0002a400000e0000ULL, 0x0000a3c27f007947ULL, 0x000fea000b800000ULL,
0x00001f006e007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0025ULL, 0x00007f9000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000aad000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0024ULL, 0x00007ff000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000aa7000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005328783bULL, 0x000ee20000004200ULL, 0x00009910587c7816ULL, 0x000fc600000000ffULL,
0x000000006130783bULL, 0x000fe20000004200ULL, 0x000000ff7c00720cULL, 0x000fc60003f05270ULL,
0x00000000632c783bULL, 0x004ea80000004200ULL, 0x000000005224783bULL, 0x0008620000004200ULL,
0x00000018ff347819ULL, 0x008fe20000011428ULL, 0x0000010028597824ULL, 0x040fe200078e00ffULL,
0x0000888028527816ULL, 0x050fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011429ULL, 0x00000100295b7824ULL, 0x040fe200078e00ffULL,
0x00008880295c7816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000001002a637824ULL, 0x040fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145bULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00000018ff567819ULL, 0x000fe2000001142aULL, 0x000001002f587824ULL, 0x004fe200078e00ffULL,
0x000088802a617816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff577819ULL, 0x000fe2000001142bULL,
0x00000028005b7306ULL, 0x0005e20000200c00ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x000088802b687816ULL, 0x040fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011431ULL,
0x00000018ff507819ULL, 0x000fe20000011432ULL, 0x0000002900607306ULL, 0x0007e20000200c00ULL,
0x000001002b287824ULL, 0x044fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011433ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fc40000011463ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002a00697306ULL, 0x0005e20000200c00ULL,
0x0000888030297816ULL, 0x008fe400000000ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff557819ULL, 0x000fe40000011430ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x00000028006b7306ULL, 0x0007e20000200c00ULL, 0x00000100312a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fc4000001142cULL, 0x00000018ff4e7819ULL, 0x000fe4000001142dULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000029006c7306ULL, 0x0005e20000200c00ULL,
0x0000888031287816ULL, 0x048fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x000088802d797816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe4000001142eULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x00000028006d7306ULL, 0x0007e20000200c00ULL,
0x0000888032297816ULL, 0x004fc400000000ffULL, 0x00000018ff397819ULL, 0x000fe4000001142fULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff377819ULL, 0x002fe20000011425ULL,
0x0000002b006a7306ULL, 0x0003e20000200c00ULL, 0x0000010032287824ULL, 0x048fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011427ULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900717306ULL, 0x0005e20000200c00ULL,
0x00000100332b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc80000011432ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002800727306ULL, 0x0002e20000200c00ULL,
0x0001000033297824ULL, 0x004fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000031006f7306ULL, 0x0005e20000200c00ULL, 0x000001002c287824ULL, 0x002fce00078e00ffULL,
0x0000002a00707306ULL, 0x0003220000200c00ULL, 0x00000018ff317819ULL, 0x004fe20000011428ULL,
0x000001002d287824ULL, 0x000fe200078e00ffULL, 0x0000541071727816ULL, 0x008fe20000000072ULL,
0x000100002d2d7824ULL, 0x000fc800078e00ffULL, 0x0000002b00747306ULL, 0x000fe20000200c00ULL,
0x00008880332a7816ULL, 0x002fe400000000ffULL, 0x00000018ff2d7819ULL, 0x000fca000001142dULL,
0x0000003200337306ULL, 0x0003e20000200c00ULL, 0x000054106d6d7816ULL, 0x010fce0000000070ULL,
0x0000002a00737306ULL, 0x000ea20000200c00ULL, 0x00000018ff327819ULL, 0x002fce0000011428ULL,
0x0000002900767306ULL, 0x0003f00000200c00ULL, 0x0000006300667306ULL, 0x0007e20000200c00ULL,
0x00a800006428783bULL, 0x002e620000000200ULL, 0x0000541073737816ULL, 0x004fcc0000000074ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000010030637824ULL, 0x048fe400078e00ffULL,
0x0001000030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x00000030006e7306ULL, 0x0005f00000200c00ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000088802c307816ULL, 0x044fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d007b7306ULL, 0x0007e20000200c00ULL,
0x0000000328288232ULL, 0x082fe40000000000ULL, 0x000000032a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x0000002c00777306ULL, 0x0003e20000200c00ULL, 0x000054105c2d7816ULL, 0x008fca000000005dULL,
0x000000722808723cULL, 0x000fe40000001808ULL, 0x0000003000757306ULL, 0x0005e20000200c00ULL,
0x000088802f2c7816ULL, 0x042fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002c00647306ULL, 0x0003e20000200c00ULL,
0x000088802e307816ULL, 0x004fce00000000ffULL, 0x0000003100787306ULL, 0x0004e20000200c00ULL,
0x00005410522c7816ULL, 0x002fe40000000059ULL, 0x0000888025527816ULL, 0x000fca00000000ffULL,
0x0000002c2820723cULL, 0x000fe20000001820ULL, 0x000001002e317824ULL, 0x044fe200078e00ffULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x00000100242c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541075787816ULL, 0x008fce0000000078ULL, 0x00000031007d7306ULL, 0x0003f00000200c00ULL,
0x0000002e007f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff317819ULL, 0x002fce000001142cULL,
0x0000002f007c7306ULL, 0x0003f00000200c00ULL, 0x00000030007a7306ULL, 0x0004e20000200c00ULL,
0x00a80000652c783bULL, 0x002e6e0000000200ULL, 0x0000005800817306ULL, 0x000fe20000200c00ULL,
0x0000888024307816ULL, 0x004fce00000000ffULL, 0x0000003000587306ULL, 0x0005e20000200c00ULL,
0x000054107a7a7816ULL, 0x008fce000000007dULL, 0x0000003100597306ULL, 0x0007220000200c00ULL,
0x0000541061307816ULL, 0x004fce0000000066ULL, 0x00000034005a7306ULL, 0x0005220000200c00ULL,
0x0000541068317816ULL, 0x008fce000000006bULL, 0x00000035005f7306ULL, 0x0006e20000200c00ULL,
0x000000302818723cULL, 0x000fe20000001818ULL, 0x000000032c2c8232ULL, 0x082fe20000000000ULL,
0x00000018ff347819ULL, 0x004fe20000011426ULL, 0x000000032e2e8232ULL, 0x000fe20000000000ULL,
0x0000010026037824ULL, 0x000fe200078e00ffULL, 0x000000002d2d8232ULL, 0x080fe20000000000ULL,
0x0000541058587816ULL, 0x010fe20000000059ULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x000000ffff307224ULL, 0x000fe200078e0052ULL, 0x00000018ff357819ULL, 0x008fe20000011424ULL,
0x0000010025527824ULL, 0x000fe200078e00ffULL, 0x000054105b5a7816ULL, 0x000fe2000000005aULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff037819ULL, 0x000fe20000011403ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x00005410605b7816ULL, 0x000fc4000000005fULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x0000541069567816ULL, 0x002fe20000000056ULL, 0x0000005a281c723cULL, 0x000fec000000181cULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000054106a577816ULL, 0x004fce0000000057ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000054106e6e7816ULL, 0x008fe20000000055ULL,
0x000000562814723cULL, 0x000fec0000001814ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x000054106f6f7816ULL, 0x002fce0000000054ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x0000006e280c723cULL, 0x000fee000000180cULL, 0x0000005200317306ULL, 0x0007e20000200c00ULL,
0x0000541076537816ULL, 0x004fe40000000053ULL, 0x000054106c6c7816ULL, 0x002fca0000000063ULL,
0x0000002500547306ULL, 0x0003e20000200c00ULL, 0x0000541033527816ULL, 0x008fe20000000050ULL,
0x0000006c2810723cULL, 0x040fec0000001810ULL, 0x00000030005a7306ULL, 0x000ea20000200c00ULL,
0x0000888027257816ULL, 0x042fe200000000ffULL, 0x000000522804723cULL, 0x000fec0000001804ULL,
0x0000002400307306ULL, 0x0003e20000200c00ULL, 0x0000010027287824ULL, 0x000fc400078e00ffULL,
0x0001000027277824ULL, 0x000fca00078e00ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0000888026247816ULL, 0x042fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000054105a597816ULL, 0x004fce0000000031ULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x000000582c10723cULL, 0x000fee0000001810ULL, 0x0000000300007306ULL, 0x000ff00000200c00ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x0000541030307816ULL, 0x002fce0000000035ULL,
0x0000003900397306ULL, 0x000e700000200c00ULL, 0x0000003700377306ULL, 0x000ee20000200c00ULL,
0x000054107f387816ULL, 0x004fce0000000038ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000054107c397816ULL, 0x002fce0000000039ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541054317816ULL, 0x008fe20000000037ULL, 0x000000382c14723cULL, 0x040fec0000001814ULL,
0x0000007900797306ULL, 0x000fe40000200c00ULL, 0x000000302c0c723cULL, 0x000fec000000180cULL,
0x0000003200327306ULL, 0x000e700000200c00ULL, 0x0000002400337306ULL, 0x0004f00000200c00ULL,
0x0000002500297306ULL, 0x0009e20000200c00ULL, 0x0000541077247816ULL, 0x004fc4000000003aULL,
0x0000541079797816ULL, 0x002fca0000000032ULL, 0x0000002800287306ULL, 0x000e620000200c00ULL,
0x000054107b257816ULL, 0x010fe2000000004eULL, 0x000000782c20723cULL, 0x000fe20000001820ULL,
0x00005410647b7816ULL, 0x000fca0000000081ULL, 0x0000002600037306ULL, 0x000ea40000200c00ULL,
0x000000242c1c723cULL, 0x040fec000000181cULL, 0x0000002700277306ULL, 0x000f220000200c00ULL,
0x0000541033247816ULL, 0x008fe20000000000ULL, 0x0000007a2c18723cULL, 0x000fe20000001818ULL,
0x0000541029257816ULL, 0x002fc40000000028ULL, 0x0000541003347816ULL, 0x004fca0000000034ULL,
0x000000242c08723cULL, 0x000fe20000001808ULL, 0x0000541027357816ULL, 0x010fce0000000036ULL,
0x000000342c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003d247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0005eff7f8cULL, 0x0007e2000c80043fULL,
0x000000013b557812ULL, 0x000fc600078ec0ffULL, 0x000003004b4b7a10ULL, 0x004fc80007ffe0ffULL,
0x0000004a4b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff807000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff2d7224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe400078e0017ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0007ULL, 0x000000ffff357224ULL, 0x000fe400078e0006ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff337224ULL, 0x000fc400078e0004ULL,
0x000000ffff2a7224ULL, 0x000fe400078e000bULL, 0x000000ffff317224ULL, 0x000fe400078e000aULL,
0x000000ffff287224ULL, 0x000fe400078e0009ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff267224ULL, 0x000fe400078e000fULL, 0x000000ffff247224ULL, 0x000fe200078e000dULL,
0x000000044a007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff2b7224ULL, 0x000fc400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e0013ULL, 0x000000ffff277224ULL, 0x000fe400078e0011ULL,
0x000000ffff257224ULL, 0x000fe400078e0016ULL, 0x000000ffff177224ULL, 0x000fc800078e0015ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000003e007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000090e000067802ULL, 0x000fe40000000f00ULL, 0x000097b000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0004ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003e00037308ULL, 0x008ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000003eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x010fe200078ff0ffULL,
0x0000000003057220ULL, 0x004fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000002000207220ULL, 0x044fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x000fc40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000001400147220ULL, 0x040fe40000410000ULL,
0x0000001700177220ULL, 0x040fe40000410000ULL, 0x0000001000107220ULL, 0x040fe40000410000ULL,
0x0000002700277220ULL, 0x000fc40000410000ULL, 0x0000002b002b7220ULL, 0x040fe40000410000ULL,
0x0000002400247220ULL, 0x040fe40000410000ULL, 0x0000002f002f7220ULL, 0x040fe40000410000ULL,
0x0000002800287220ULL, 0x040fe40000410000ULL, 0x0000003300337220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x048fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000002504257220ULL, 0x040fe40000410000ULL,
0x0000000e040e7220ULL, 0x040fe40000410000ULL, 0x0000001204127220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002604267220ULL, 0x000fc40000410000ULL, 0x0000003104317220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000003504357220ULL, 0x040fe40000410000ULL,
0x0000002e042e7220ULL, 0x000fe40000410000ULL, 0x0000000000037919ULL, 0x008ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x0000000400067811ULL, 0x000fe400078ff8ffULL, 0x0000000803157811ULL, 0x000fe400078ff0ffULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000704057812ULL, 0x000fc400078e780dULL,
0x0000000706087812ULL, 0x040fe400078e780dULL, 0x0000000706067812ULL, 0x000fe200078e7815ULL,
0x000000080d097824ULL, 0x000fe200078e0205ULL, 0x00000006000a7811ULL, 0x000fe200078ff8ffULL,
0x0000100043057824ULL, 0x000fe200078e00ffULL, 0x0000000702007812ULL, 0x100fe200078e780dULL,
0x0000000815137824ULL, 0x000fe200078e0206ULL, 0x000000070a0c7812ULL, 0x000fe200078e780dULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x100fe200078e7815ULL,
0x000000080d077824ULL, 0x040fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e7815ULL,
0x0000080044007824ULL, 0x000fe200078e0205ULL, 0x000000070a0a7812ULL, 0x000fe200078e7815ULL,
0x000000080d0b7824ULL, 0x000fe200078e0208ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x00000008150f7824ULL, 0x000fe200078e0202ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x0000000815117824ULL, 0x000fe200078e0204ULL, 0x0000001c1d04723eULL, 0x000fe200000000ffULL,
0x000000080d0d7824ULL, 0x000fc400078e020cULL, 0x0000000815157824ULL, 0x000fe200078e020aULL,
0x0000541002167816ULL, 0x000fe20000000004ULL, 0x0000001007077824ULL, 0x100fe400078e0200ULL,
0x0000001009097824ULL, 0x100fe400078e0200ULL, 0x000000100b0b7824ULL, 0x100fe400078e0200ULL,
0x000000100f0f7824ULL, 0x100fe400078e0200ULL, 0x0000001011117824ULL, 0x000fc400078e0200ULL,
0x000000100d0d7824ULL, 0x100fe400078e0200ULL, 0x0000001013137824ULL, 0x100fe400078e0200ULL,
0x0000001015157824ULL, 0x000fe400078e0200ULL, 0x0000000107087824ULL, 0x000fe200078e0206ULL,
0x000000141707723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x000000102702723eULL, 0x000fe200000000ffULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000002b2404723eULL, 0x000fe200000000ffULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x0000001608007388ULL, 0x0005e20000000a00ULL, 0x00000001060d7824ULL, 0x000fc400078e020dULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x000fe200078e0215ULL,
0x000000181906723eULL, 0x000fe200000000ffULL, 0x00000001420a7824ULL, 0x000fe400078e0203ULL,
0x00000300ff147624ULL, 0x000fe200078e00ffULL, 0x0000541006167816ULL, 0x144fe40000000007ULL,
0x0000763206177816ULL, 0x000fe40000000007ULL, 0x0000541002087816ULL, 0x000fc40000000004ULL,
0x0000002f2806723eULL, 0x000fe200000000ffULL, 0x0000001609007388ULL, 0x0005e20000000a00ULL,
0x000000332c07723eULL, 0x000fe400000000ffULL, 0x000000011400780cULL, 0x000fe40003f05270ULL,
0x0000763202097816ULL, 0x004fe40000000004ULL, 0x000000222302723eULL, 0x000fe400000000ffULL,
0x0000001e1f04723eULL, 0x000fe200000000ffULL, 0x000000080b007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fe20000000007ULL, 0x000000100a0b7824ULL, 0x000fe200078e0205ULL,
0x0000763206097816ULL, 0x000fc40000000007ULL, 0x0000001a1b06723eULL, 0x000fe400000000ffULL,
0x000000250e07723eULL, 0x000fe200000000ffULL, 0x000000080d007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000122902723eULL, 0x000fe400000000ffULL, 0x0000002d2604723eULL, 0x000fe200000000ffULL,
0x000000080f007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fc40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000312a06723eULL, 0x000fe400000000ffULL,
0x000000352e07723eULL, 0x000fe200000000ffULL, 0x0000000811007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe40000000004ULL, 0x0000763202097816ULL, 0x000fca0000000004ULL,
0x0000000813007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000815007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000b0c7984ULL, 0x000ea80000000c00ULL,
0x000400000b1c7984ULL, 0x000ee80000000c00ULL, 0x000800000b187984ULL, 0x000f280000000c00ULL,
0x000c00000b207984ULL, 0x000e620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000001b0f0f7230ULL, 0x010fe40000000000ULL,
0x0000001a0e0e7230ULL, 0x000fe40000000000ULL, 0x000000190d0d7230ULL, 0x000fe40000000000ULL,
0x000000180c0c7230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x002fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000000c0b007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c0b007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f1000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x002e620000002700ULL,
0x0000580014027a24ULL, 0x000fe200078e02ffULL, 0x0000000144ff7812ULL, 0x000fe2000780f851ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x0000660002067a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x0000040043047824ULL, 0x000fe200078e00ffULL, 0x000000000b107984ULL, 0x0004e20000000c00ULL,
0x000000ff0300720cULL, 0x000fc40000725670ULL, 0x000007ff06027811ULL, 0x040fe400078e40ffULL,
0x01ffffff06067812ULL, 0x000fe200078ec0ffULL, 0x000058000e0e7a24ULL, 0x002fc800078e0207ULL,
0x000003000e077a24ULL, 0x000fca00078e02ffULL, 0x00000004070f7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000f02087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000004080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x000000100a0c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x00cfe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0206ULL,
0x0000007008157812ULL, 0x000fe400078ec0ffULL, 0x0000000c09167812ULL, 0x000fe200078ec0ffULL,
0x00006c000f087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000816087210ULL, 0x000fc80007a1e015ULL, 0x0000000a160a7210ULL, 0x000fe40007c7e015ULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000003f08007986ULL, 0x0003e8000c101906ULL, 0x0000003e0a007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00cfea0003800000ULL, 0x000000100c007986ULL, 0x0005e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x002fe200078e00ffULL,
0xffffffff140b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0800720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x002e640000000000ULL,
0x000000ff0800720cULL, 0x002fda0003f05270ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x000000ff5100720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x000fe200078e00ffULL, 0x00000001070a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0007087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x004368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021400780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000207087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041400780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000307087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000041400780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000407087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000061400780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000507087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000061400780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081400780cULL, 0x002fe40003f06070ULL, 0x0000000607087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007070a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a190981ULL, 0x000368000c1e1900ULL, 0x0000000714087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e000cULL, 0x000000080b0e7824ULL, 0x040fe200078e00ffULL,
0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000a0b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e087810ULL, 0x040fe40007ffe0ffULL, 0x000000010e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0c0c7209ULL, 0x004fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e087810ULL, 0x042fe40007ffe0ffULL,
0x000000020e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e087810ULL, 0x042fe40007ffe0ffULL, 0x000000030e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e087810ULL, 0x042fe40007ffe0ffULL,
0x000000040e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e087810ULL, 0x042fe40007ffe0ffULL, 0x000000050e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e087810ULL, 0x042fe40007ffe0ffULL,
0x000000060e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000150c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e087810ULL, 0x042fe40007ffe0ffULL, 0x000000070e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000170c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e087810ULL, 0x002fe40007ffe0ffULL,
0x000000190c0c7209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e197812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007a3e019ULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x0000000608197981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x0000001003087824ULL, 0x00afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0208ULL,
0x0000000c09007388ULL, 0x0203e40000000800ULL, 0x0000001003097824ULL, 0x042fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x0000000144117824ULL, 0x004fe200078e0207ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000070090a7812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000140407824ULL, 0x000fe200078e0205ULL,
0x0000001102087211ULL, 0x000fe200078fa8ffULL, 0x000010e000007945ULL, 0x000fe20003800000ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000010b307824ULL, 0x000fe200078e020aULL,
0x00000001490a7812ULL, 0x040fe200078ec0ffULL, 0x0000080049497824ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00006c0008087625ULL, 0x000fe200078e000dULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000080049497812ULL, 0x000fe200078ec0ffULL, 0x00000002440b8824ULL, 0x100fe200078e0243ULL,
0x0000000408087210ULL, 0x000fe20007f3e0ffULL, 0x00000002440d8824ULL, 0x000fe200078e0243ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000001060e8824ULL, 0x000fe200078e0211ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000020b0c8824ULL, 0x100fe200078e020aULL,
0x0000000030307984ULL, 0x000e620000000800ULL, 0x00000080ff108424ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000020d128824ULL, 0x000fe200078e020aULL,
0x00000020030d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001400a7824ULL, 0x000fc400078e0249ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000030044007a0cULL, 0x000fe20003f26070ULL,
0x00006c000e0e8625ULL, 0x000fc800078e000fULL, 0x00006c0011108625ULL, 0x000fc800078e0010ULL,
0x000000080c158824ULL, 0x100fe400078e0203ULL, 0x0000000812128824ULL, 0x000fe400078e0203ULL,
0x0000001003137824ULL, 0x000fe200078e020aULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000010030a7825ULL, 0x000fe200078e0008ULL, 0x0000418012178811ULL, 0x000fc600078e20ffULL,
0x000000100d0c7825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0005e2000b901c46ULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x00000010030e8825ULL, 0x040fe200078e000eULL, 0x003800000c137faeULL, 0x0007e6000b901c46ULL,
0x0000001003108825ULL, 0x000fe200078e0010ULL, 0x000000000e158faeULL, 0x0009e6000b901c46ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000000010178faeULL, 0x0003e2000b901c46ULL,
0x00000000000a7805ULL, 0x004fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e0044ULL, 0x0000000232347810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030034007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00000001072f7824ULL, 0x100fe200078e0234ULL, 0x00000001ff287819ULL, 0x000fe20000011634ULL,
0x00000800ff2e7424ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x000fe20007ffe0ffULL,
0x00000400342a7824ULL, 0x000fe200078e00ffULL, 0x0000002f02297211ULL, 0x000fe400078fa8ffULL,
0x00000001282c7812ULL, 0x000fc600078ec0ffULL, 0x00006c0029287625ULL, 0x000fc800078e002eULL,
0x00000002442d9824ULL, 0x000fe200078e0243ULL, 0x0000000428287210ULL, 0x000fe20007f1e0ffULL,
0x00000001062b9824ULL, 0x000fe400078e022fULL, 0x000000022d369824ULL, 0x100fe200078e022cULL,
0x000008002a2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000244339824ULL, 0x000fe400078e0243ULL,
0x00000080ff2e9424ULL, 0x000fe400078e00ffULL, 0x00000002333a9824ULL, 0x000fc400078e022cULL,
0x00006c002b2a9625ULL, 0x000fc800078e002eULL, 0x00000080ff389424ULL, 0x000fe400078e00ffULL,
0x00000001402c7824ULL, 0x000fe400078e022dULL, 0x000000ffff297224ULL, 0x000fe400000e0629ULL,
0x00006c002f2e9625ULL, 0x000fc800078e0038ULL, 0x0000001003337824ULL, 0x040fe400078e022cULL,
0x0000000836359824ULL, 0x000fe400078e0203ULL, 0x00000010032c9825ULL, 0x000fc600078e002aULL,
0x0000458035359811ULL, 0x000fe200078e20ffULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x00000010372a7825ULL, 0x000fc600078e0028ULL, 0x000041803a379811ULL, 0x000fe200078e20ffULL,
0x0000001003287825ULL, 0x000fc800078e0028ULL, 0x00000010032e9825ULL, 0x000fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000028337faeULL, 0x0003e8000b901c46ULL,
0x003800002a337faeULL, 0x0003e8000b901c46ULL, 0x000000002c359faeULL, 0x0003e8000b901c46ULL,
0x000000002e379faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0032ULL,
0x00000001ff2a7819ULL, 0x000fe20000011603ULL, 0x00000002442b7824ULL, 0x000fe200078e0243ULL,
0x00000002ff337819ULL, 0x000fe20000011603ULL, 0x000000402d287824ULL, 0x000fe200078e00ffULL,
0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL, 0x0000001003297824ULL, 0x000fe200078e00ffULL,
0x00000007333a7812ULL, 0x040fe200078ec0ffULL, 0x00000008332f7824ULL, 0x040fe200078e00ffULL,
0x0000008028287812ULL, 0x000fe200078ec0ffULL, 0x0000000833357824ULL, 0x000fe200078e00ffULL,
0x0000007029297812ULL, 0x000fc400078ec0ffULL, 0x00000033ff3c7212ULL, 0x000fe200078e33ffULL,
0x000001002b287824ULL, 0x000fc600078e0028ULL, 0xfffffff8353c7812ULL, 0x000fe400078ee23cULL,
0x000000282a2a7210ULL, 0x000fe20007ffe029ULL, 0x0000000833297824ULL, 0x000fe200078e00ffULL,
0xfffffff82f287812ULL, 0x000fe200078ee23aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002a2b7984ULL, 0x000e620000000800ULL, 0x00000001292c7812ULL, 0x140fe400078ef63aULL,
0x00000002292e7812ULL, 0x140fe200078ef63aULL, 0x004580002a527984ULL, 0x0004e20000000800ULL,
0x0000000329327812ULL, 0x140fe400078ef63aULL, 0x0000000429367812ULL, 0x140fe400078ef63aULL,
0x0000000529387812ULL, 0x140fe400078ef63aULL, 0x00000006293a7812ULL, 0x000fe200078ef63aULL,
0x000004002d297824ULL, 0x000fe200078e00ffULL, 0x0000000833357810ULL, 0x000fe20007ffe0ffULL,
0x00000004032a7824ULL, 0x004fc600078e00ffULL, 0x0000080029297812ULL, 0x000fe200078ec0ffULL,
0x0000000835467824ULL, 0x040fe200078e00ffULL, 0x00000007352d7812ULL, 0x040fe200078ec0ffULL,
0x00000008353e7824ULL, 0x040fe200078e00ffULL, 0x0000018040297810ULL, 0x000fe20007ffe029ULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0x00000035ff507212ULL, 0x000fe400078e33ffULL,
0x000000023e487812ULL, 0x000fe200078ef62dULL, 0x0000001028287824ULL, 0x000fe200078e0229ULL,
0x000000033e4a7812ULL, 0x000fe200078ef62dULL, 0x000000102c2c7824ULL, 0x000fe200078e0229ULL,
0x000000043e4c7812ULL, 0x000fe200078ef62dULL, 0x0000001032327824ULL, 0x000fe200078e0229ULL,
0x000000053e4e7812ULL, 0x000fe200078ef62dULL, 0x0000001038387824ULL, 0x100fe200078e0229ULL,
0xfffffff837507812ULL, 0x000fe200078ee250ULL, 0x0000001036367824ULL, 0x000fc400078e0229ULL,
0x000000103a3a7824ULL, 0x100fe400078e0229ULL, 0x0000001048487824ULL, 0x000fe400078e0229ULL,
0x0000002b302b7221ULL, 0x002fe40000010100ULL, 0x000000104a4a7824ULL, 0x100fe400078e0229ULL,
0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL, 0x0000000c2a2b7812ULL, 0x000fe200078ec0ffULL,
0x000000103c3c7824ULL, 0x000fe200078e0229ULL, 0xfffffff8462a7812ULL, 0x000fe200078ee22dULL,
0x000000104c4c7824ULL, 0x000fe200078e0229ULL, 0x000000013e467812ULL, 0x000fe200078ef62dULL,
0x0000000128287824ULL, 0x000fe200078e022bULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000012b2c7824ULL, 0x040fe200078e022cULL, 0x000000063e3e7812ULL, 0x000fe200078ef62dULL,
0x000000012b327824ULL, 0x000fc400078e0232ULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b387824ULL, 0x040fe400078e0238ULL, 0x000000012b367824ULL, 0x040fe200078e0236ULL,
0x000000002c2c7984ULL, 0x000fe20000000800ULL, 0x000000012b3a7824ULL, 0x000fe400078e023aULL,
0x000000102a2a7824ULL, 0x100fe200078e0229ULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x0000001046467824ULL, 0x000fe400078e0229ULL, 0x000000522f567220ULL, 0x008fe20000410000ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x000000012b2a7824ULL, 0x000fc400078e022aULL,
0x000000012b467824ULL, 0x040fe200078e0246ULL, 0x00001f33562d7589ULL, 0x000ea200000e0000ULL,
0x000000012b487824ULL, 0x040fe400078e0248ULL, 0x000000012b4a7824ULL, 0x040fe200078e024aULL,
0x0000000036367984ULL, 0x000ee20000000800ULL, 0x000000104e4e7824ULL, 0x000fe400078e0229ULL,
0x000000012b3c7824ULL, 0x040fe200078e023cULL, 0x000000003a3a7984ULL, 0x000f220000000800ULL,
0x000000012b4c7824ULL, 0x000fc400078e024cULL, 0x000000012b4e7824ULL, 0x040fe200078e024eULL,
0x000000002a2a7984ULL, 0x000f220000000800ULL, 0x000000102e2e7824ULL, 0x100fe400078e0229ULL,
0x000000103e3e7824ULL, 0x100fe200078e0229ULL, 0x0000000046467984ULL, 0x000f220000000800ULL,
0x0000001050507824ULL, 0x000fe400078e0229ULL, 0x000000012b2e7824ULL, 0x040fe200078e022eULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x000000012b3e7824ULL, 0x000fc400078e023eULL,
0x000000012b507824ULL, 0x000fe200078e0250ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x20000028ff527230ULL, 0x102fe20000004100ULL, 0x0000003156317221ULL, 0x000fe20000010000ULL,
0x30000028ff287230ULL, 0x000fe20000004100ULL, 0x000000003c3c7984ULL, 0x000e640000000800ULL,
0x0000002d52277223ULL, 0x084fe40000010027ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x0000002d28267223ULL, 0x000fe20000010026ULL, 0x2000002cff287230ULL, 0x000fc40000004100ULL,
0x000000004e4e7984ULL, 0x000fe20000000800ULL, 0x3000002cff2c7230ULL, 0x000fe40000004100ULL,
0x0000002d28257223ULL, 0x080fe20000010025ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x20000032ff287230ULL, 0x100fe20000004100ULL, 0x0000002d2c247223ULL, 0x080fe20000010024ULL,
0x30000032ff327230ULL, 0x000fe20000004100ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x20000036ff2c7230ULL, 0x008fe20000004100ULL, 0x0000002d28217223ULL, 0x080fe20000010021ULL,
0x20000038ff287230ULL, 0x000fe20000004100ULL, 0x0000000050507984ULL, 0x000fe20000000800ULL,
0x0000002d32207223ULL, 0x080fe20000010020ULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x0000002d2c1f7223ULL, 0x080fe2000001001fULL, 0x00001f3556297589ULL, 0x000ea200000e0000ULL,
0x0000002d281d7223ULL, 0x080fe2000001001dULL, 0x2000003aff287230ULL, 0x010fe20000004100ULL,
0x000000ffff327224ULL, 0x000fe200078e0034ULL, 0x2000002aff2c7230ULL, 0x100fe20000004100ULL,
0x0000002d361e7223ULL, 0x080fe2000001001eULL, 0x3000002aff2a7230ULL, 0x000fe20000004100ULL,
0x0000002d281b7223ULL, 0x000fe2000001001bULL, 0x20000046ff287230ULL, 0x000fe20000004100ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x30000038ff387230ULL, 0x000fc40000004100ULL,
0x3000003aff3a7230ULL, 0x000fe40000004100ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000002d381c7223ULL, 0x080fe2000001001cULL, 0x2000003cff547230ULL, 0x102fe20000004100ULL,
0x0000002d3a1a7223ULL, 0x000fe2000001001aULL, 0x3000003cff3c7230ULL, 0x000fc60000004100ULL,
0x0000002d54197223ULL, 0x080fe40000010019ULL, 0x0000002d3c187223ULL, 0x000fe40000010018ULL,
0x000000292a167223ULL, 0x084fe20000010016ULL, 0x20000048ff2a7230ULL, 0x000fe20000004100ULL,
0x0000002928157223ULL, 0x080fe20000010015ULL, 0x2000004aff287230ULL, 0x000fe20000004100ULL,
0x000000292c177223ULL, 0x080fe20000010017ULL, 0x2000002eff3c7230ULL, 0x000fe20000004100ULL,
0x000000292a137223ULL, 0x080fe20000010013ULL, 0x2000004eff2a7230ULL, 0x000fe20000004100ULL,
0x0000002928117223ULL, 0x000fe20000010011ULL, 0x2000004cff287230ULL, 0x000fe20000004100ULL,
0x0000002d3c237223ULL, 0x000fe20000010023ULL, 0x3000002eff2e7230ULL, 0x000fe20000004100ULL,
0x000000292a0d7223ULL, 0x080fe2000001000dULL, 0x20000050ff2a7230ULL, 0x000fe20000004100ULL,
0x00000029280f7223ULL, 0x000fe2000001000fULL, 0x2000003eff287230ULL, 0x000fe20000004100ULL,
0x0000002d2e227223ULL, 0x000fe20000010022ULL, 0x30000048ff487230ULL, 0x000fe20000004100ULL,
0x0000002946147223ULL, 0x080fe20000010014ULL, 0x3000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000029280b7223ULL, 0x080fe2000001000bULL, 0x3000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000002948127223ULL, 0x080fe20000010012ULL, 0x3000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000294a107223ULL, 0x080fe20000010010ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000000294c0e7223ULL, 0x080fe2000001000eULL, 0x30000050ff507230ULL, 0x000fe20000004100ULL,
0x000000294e0c7223ULL, 0x000fc4000001000cULL, 0x000000293e0a7223ULL, 0x080fe4000001000aULL,
0x000000292a097223ULL, 0x080fe40000010009ULL, 0x0000002950087223ULL, 0x000fe20000010008ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff4300720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fca00078ec0ffULL,
0x0000000102047824ULL, 0x000fe200078e0203ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02077812ULL, 0x000fc600078ec0ffULL, 0x0000008044027824ULL, 0x000fc800078e0203ULL,
0x0000000107027824ULL, 0x000fca00078e0202ULL, 0x0049803102007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0049800004027984ULL, 0x002e680000000800ULL, 0x004a000004037984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000302027221ULL, 0x004fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0002ULL,
0x0000bf6000067802ULL, 0x000fe40000000f00ULL, 0x0000693000007944ULL, 0x020fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403047223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008032d7811ULL, 0x004fe200078ff0ffULL, 0x0000000142427824ULL, 0x100fe200078e0203ULL,
0x00000002ff2b7819ULL, 0x000fe40000011603ULL, 0x0000002dff297212ULL, 0x000fe200078e33ffULL,
0x00001f2d04067589ULL, 0x000ea200000e0000ULL, 0x000000082d2e7824ULL, 0x000fc400078e00ffULL,
0x000000082b2f7824ULL, 0x000fe200078e00ffULL, 0x00001f2b04027589ULL, 0x00072200000e0000ULL,
0x0000001042427824ULL, 0x000fe200078e0205ULL, 0x0000002bff047212ULL, 0x008fc800078e33ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee204ULL, 0x000000072b047812ULL, 0x000fe200078ec0ffULL,
0x0000001706177220ULL, 0x004fc60000410000ULL, 0x0000000304287812ULL, 0x000fe200078e3cffULL,
0x0000001606167220ULL, 0x000fe20000410000ULL, 0x00000004042a7812ULL, 0x000fe200078e3cffULL,
0x0000001506157220ULL, 0x000fe20000410000ULL, 0x00000005042c7812ULL, 0x000fe200078e3cffULL,
0x0000001406147220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000001306137220ULL, 0x040fe40000410000ULL, 0x0000001206127220ULL, 0x000fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000001106117220ULL, 0x000fe20000410000ULL,
0xfffffff82e157812ULL, 0x000fe200078ee22dULL, 0x0000001006107220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000f060f7220ULL, 0x000fc40000410000ULL,
0x0000000e060e7220ULL, 0x000fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000d060d7220ULL, 0x040fe40000410000ULL, 0x0000000c060c7220ULL, 0x000fe20000410000ULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x040fe40000410000ULL,
0x0000000a060a7220ULL, 0x000fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000000906097220ULL, 0x000fc40000410000ULL, 0x0000002702277220ULL, 0x010fe20000410000ULL,
0x0000000b0a0a723eULL, 0x000fe200000000ffULL, 0x0000002602267220ULL, 0x040fe40000410000ULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002402247220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000002302237220ULL, 0x040fe40000410000ULL,
0x0000002202227220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000002102217220ULL, 0x000fc40000410000ULL, 0x0000002002207220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000001f021f7220ULL, 0x040fe20000410000ULL,
0x000000072d237812ULL, 0x000fe200078ec0ffULL, 0x0000001e021e7220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000000523217812ULL, 0x000fe200078e3cffULL, 0x0000001c021c7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001b021b7220ULL, 0x000fc40000410000ULL,
0x0000001a021a7220ULL, 0x000fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001902197220ULL, 0x000fe40000410000ULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000001802027220ULL, 0x000fe20000410000ULL,
0x00000004231b7812ULL, 0x000fe200078e3cffULL, 0x000000082b087824ULL, 0x000fe200078e00ffULL,
0x000000090606723eULL, 0x000fe200000000ffULL, 0x000000082d187824ULL, 0x000fe200078e00ffULL,
0x000000190202723eULL, 0x000fe200000000ffULL, 0x0000000403257824ULL, 0x000fe200078e00ffULL,
0xfffffff808077812ULL, 0x000fe200078ee22bULL, 0x000000082b0d7824ULL, 0x040fe200078e0228ULL,
0xfffffff818297812ULL, 0x000fe200078ee229ULL, 0x000000082b0f7824ULL, 0x000fe200078e022aULL,
0x0000000104087812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000204187812ULL, 0x040fe200078e3cffULL, 0x000000082b117824ULL, 0x040fe200078e022cULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x000000082b097824ULL, 0x000fe200078e0208ULL,
0x0000000c25287812ULL, 0x000fe200078ec0ffULL, 0x000000082b0b7824ULL, 0x000fe200078e0218ULL,
0x0000000223087812ULL, 0x000fe200078e3cffULL, 0x000000082b137824ULL, 0x000fe200078e0204ULL,
0x0000000123047812ULL, 0x000fe200078e3cffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x0000000323187812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0x0000000623237812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x000fc400078e0200ULL,
0x0000000128077824ULL, 0x040fe400078e0207ULL, 0x000000100f0f7824ULL, 0x000fe400078e0200ULL,
0x000000082d177824ULL, 0x000fe200078e0204ULL, 0x0000002607007388ULL, 0x000fe20000000800ULL,
0x0000001011117824ULL, 0x000fe400078e0200ULL, 0x0000000128097824ULL, 0x000fe400078e0209ULL,
0x000000082d197824ULL, 0x000fc400078e0208ULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x0000002409007388ULL, 0x000fe20000000800ULL, 0x00000001280b7824ULL, 0x040fe400078e020bULL,
0x000000082d1d7824ULL, 0x000fe400078e0218ULL, 0x000000102f047824ULL, 0x000fe200078e0200ULL,
0x000000220b007388ULL, 0x000fe20000000800ULL, 0x00000001280d7824ULL, 0x000fe400078e020dULL,
0x000000082d1f7824ULL, 0x000fc400078e021bULL, 0x0000001015087824ULL, 0x100fe200078e0200ULL,
0x000000200d007388ULL, 0x000fe20000000800ULL, 0x00000001280f7824ULL, 0x040fe400078e020fULL,
0x000000082d217824ULL, 0x000fe400078e0221ULL, 0x0000001017187824ULL, 0x000fe200078e0200ULL,
0x0000001e0f007388ULL, 0x000fe20000000800ULL, 0x0000000128117824ULL, 0x000fe400078e0211ULL,
0x000000082d237824ULL, 0x000fc400078e0223ULL, 0x00000010191b7824ULL, 0x100fe200078e0200ULL,
0x0000001c11007388ULL, 0x000fe20000000800ULL, 0x0000000128137824ULL, 0x040fe400078e0213ULL,
0x000000101d1d7824ULL, 0x000fe400078e0200ULL, 0x0000000128157824ULL, 0x040fe200078e0204ULL,
0x0000001a13007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x000fe400078e0200ULL,
0x0000000128177824ULL, 0x000fe200078e0208ULL, 0x0000000215007388ULL, 0x000fe20000000800ULL,
0x0000001021217824ULL, 0x000fc400078e0200ULL, 0x0000000128197824ULL, 0x040fe200078e0218ULL,
0x0000001617007388ULL, 0x000fe20000000800ULL, 0x0000001023237824ULL, 0x100fe400078e0200ULL,
0x00000001281b7824ULL, 0x040fe200078e021bULL, 0x0000001419007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x000fe400078e0200ULL, 0x00000001281d7824ULL, 0x040fe200078e021dULL,
0x000000121b007388ULL, 0x000fe20000000800ULL, 0x00000001281f7824ULL, 0x000fc400078e021fULL,
0x0000000128217824ULL, 0x040fe200078e0221ULL, 0x000000101d007388ULL, 0x000fe20000000800ULL,
0x0000000128237824ULL, 0x040fe400078e0223ULL, 0x0000000128297824ULL, 0x000fe200078e0229ULL,
0x0000000e1f007388ULL, 0x000fe80000000800ULL, 0x0000000c21007388ULL, 0x000fe80000000800ULL,
0x0000000a23007388ULL, 0x000fe80000000800ULL, 0x0000000629007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000042247984ULL, 0x000ea80000000c00ULL,
0x00040000422c7984ULL, 0x000ee80000000c00ULL, 0x0008000042147984ULL, 0x000f280000000c00ULL,
0x000c000042187984ULL, 0x000e620000000c00ULL, 0x200000ff27277230ULL, 0x004fc40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x008fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000001727277230ULL, 0x010fe40000000000ULL,
0x0000001626267230ULL, 0x000fe40000000000ULL, 0x0000001525257230ULL, 0x000fe40000000000ULL,
0x0000001424247230ULL, 0x000fe40000000000ULL, 0x0000001b2f2f7230ULL, 0x002fc40000000000ULL,
0x0000001a2e2e7230ULL, 0x000fe20000000000ULL, 0x0000002442007388ULL, 0x0003e20000000c00ULL,
0x000000192d2d7230ULL, 0x000fe40000000000ULL, 0x000000182c2c7230ULL, 0x000fca0000000000ULL,
0x0004002c42007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000ea20000002600ULL,
0x00000003ff107819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000710007812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704027812ULL, 0x000fe200078e4811ULL, 0x0000000843127824ULL, 0x000fe200078e00ffULL,
0x0ffffff800007812ULL, 0x000fc400078ef803ULL, 0x0ffffff802027812ULL, 0x100fe400078ef811ULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x0000001000007824ULL, 0x100fe400078e0205ULL,
0x0000001002057824ULL, 0x000fc600078e0205ULL, 0x0000000000087984ULL, 0x0023280000000c00ULL,
0x00000000050c7984ULL, 0x0003220000000c00ULL, 0x0000000806077824ULL, 0x044fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000843007824ULL, 0x002fe200078e00ffULL, 0xfffffff807027812ULL, 0x000fc400078ee210ULL,
0xfffffff813047812ULL, 0x000fe400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fc400078240ffULL,
0x00005b0010057a11ULL, 0x000fe400000f4405ULL, 0x00005b0002077a11ULL, 0x000fc600008f4407ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000044b037824ULL, 0x000fe400078e0251ULL,
0xffffffffff007424ULL, 0x002fc600078e00ffULL, 0x0000004c0300720cULL, 0x000fda0003f06070ULL,
0x0000000226068824ULL, 0x000fc800078e00ffULL, 0x0000640006068a24ULL, 0x000fc800078e0203ULL,
0x0000600006068625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff087624ULL, 0x000fe200078e00ffULL, 0x0000000606008981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff097624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x0000000608287981ULL, 0x000762000c1e9900ULL, 0x000000014b0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000004025257824ULL, 0x000fe400078e00ffULL, 0x0000004051027824ULL, 0x000fe200078e00ffULL,
0x0000004a0b00720cULL, 0x000fe20003f06070ULL, 0x0000004041247824ULL, 0x000fc400078e00ffULL,
0x0000002500177224ULL, 0x004fd400078e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000001004b067824ULL, 0x00afe200078e0202ULL, 0x00000002ff167819ULL, 0x100fe4000001164fULL,
0x00000003ff107819ULL, 0x100fe4000001164fULL, 0x000000064d077217ULL, 0x000fe20007800000ULL,
0x0000004041087824ULL, 0x000fe200078e0216ULL, 0x0000000310107812ULL, 0x000fe400078e484fULL,
0x000000300e1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001070f7824ULL, 0x000fe200078e0a06ULL,
0x0000001008077810ULL, 0x000fc40007ffe0ffULL, 0x0000000808067810ULL, 0x000fe40007ffe0ffULL,
0x0000000717077210ULL, 0x040fe40007f5e0ffULL, 0x0000000617147210ULL, 0x040fe40007f3e0ffULL,
0x0000000817157210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x00005e00070b7a11ULL, 0x040fe200078438ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0014137a11ULL, 0x000fe200078238ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x00005f0007117a11ULL, 0x000fc400010f3c06ULL, 0x0000001808067810ULL, 0x000fe40007ffe0ffULL,
0x00005e00150c7a11ULL, 0x000fe400078038ffULL, 0x00005f0014147a11ULL, 0x000fe400008f3c09ULL,
0x0000000f1600720cULL, 0x000fe40003f66070ULL, 0x00000006170d7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0015157a11ULL, 0x000fc400000f3c0aULL, 0x00001000510e7811ULL, 0x000fe200078e68ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0ffffffc104f7812ULL, 0x000fe400078ef84fULL,
0x0000002008077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1d067210ULL, 0x000fe20007f1e0ffULL,
0x000000104f4f7824ULL, 0x000fe200078e020eULL, 0x00000030080a7810ULL, 0x000fe40007ffe0ffULL,
0x00000007171b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0615ULL,
0x00005e000d0c7a11ULL, 0x000fc400078838ffULL, 0x0000002808097810ULL, 0x040fe40007ffe0ffULL,
0x0000003808087810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000064f7faeULL, 0x0003e2000d901c46ULL, 0x0000000a17187210ULL, 0x000fe40007f1e0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400020f3c12ULL, 0x0000000917197210ULL, 0x000fe40007fde0ffULL,
0x0000001d0b0a7210ULL, 0x000fc40007f9e0ffULL, 0x0000000817177210ULL, 0x000fe40007f3e0ffULL,
0x0000000816127810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0611ULL,
0x0000001d13087210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff067224ULL, 0x002fe200010e06ffULL,
0x00000010161a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000412117824ULL, 0x000fe200078e00ffULL,
0x00000018161c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0614ULL,
0x0000001d0c0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000041a137824ULL, 0x000fe200078e00ffULL,
0x0000000f1200720cULL, 0x080fe20003f66070ULL, 0x000000041c157824ULL, 0x000fe200078e00ffULL,
0x0000000f1a00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0xfffffffc11077812ULL, 0x000fc400078ee210ULL, 0x0000000f1c00720cULL, 0x000fe40003fa6070ULL,
0xfffffffc13117812ULL, 0x000fe200078ee210ULL, 0x0000001007077824ULL, 0x000fe200078e020eULL,
0x00005e001b1a7a11ULL, 0x000fe400078438ffULL, 0xfffffffc15137812ULL, 0x000fe200078ee210ULL,
0x0000001011117824ULL, 0x000fe200078e020eULL, 0x0000002816127810ULL, 0x040fe20007ffe0ffULL,
0x0000000008077faeULL, 0x0003e2000d901c46ULL, 0x00005f001b1b7a11ULL, 0x000fe200010f3c06ULL,
0x0000001013137824ULL, 0x000fe200078e020eULL, 0x0000002016067810ULL, 0x040fe20007ffe0ffULL,
0x000000000a117faeULL, 0x0005e2000e101c46ULL, 0x0000003016147810ULL, 0x000fc40007ffe0ffULL,
0x0000003816167810ULL, 0x000fe20007ffe0ffULL, 0x000000000c137faeULL, 0x0007e2000e901c46ULL,
0x0000000f0600720cULL, 0x080fe40003f46070ULL, 0x0000000f1200720cULL, 0x0c0fe20003f66070ULL,
0x0000000412097824ULL, 0x002fe200078e00ffULL, 0x0000000f1400720cULL, 0x080fe20003f86070ULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x0000000f1600720cULL, 0x000fe20003fa6070ULL,
0x00000004140b7824ULL, 0x004fe200078e00ffULL, 0xfffffffc09097812ULL, 0x100fe200078ee210ULL,
0x000000ffff067224ULL, 0x000fe200030e06ffULL, 0x00005e0019087a11ULL, 0x000fe200078c38ffULL,
0x00000004160d7824ULL, 0x008fe200078e00ffULL, 0xfffffffc07077812ULL, 0x000fe200078ee210ULL,
0x0000001009117824ULL, 0x000fe200078e020eULL, 0xfffffffc0b0b7812ULL, 0x000fc400078ee210ULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee210ULL, 0x00000010070f7824ULL, 0x000fe200078e020eULL,
0x00005f0019097a11ULL, 0x000fe200030f3c06ULL, 0x000000100b137824ULL, 0x100fe200078e020eULL,
0x0000001d1a067210ULL, 0x080fe20007fde0ffULL, 0x000000100d157824ULL, 0x000fe400078e020eULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e00180a7a11ULL, 0x000fe200078038ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x0000001d08087210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e061bULL, 0x00005e00170c7a11ULL, 0x000fc400078c38ffULL,
0x00005f00180b7a11ULL, 0x000fe200000f3c0bULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000001d0a0a7210ULL, 0x080fe20007f1e0ffULL, 0x00000000060f7faeULL, 0x0003e2000d101c46ULL,
0x00005f00170d7a11ULL, 0x000fe400030f3c0eULL, 0x0000001d0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000008117faeULL, 0x0003e6000d901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000000a137faeULL, 0x0003e8000e101c46ULL,
0x000000000c157faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x000000244f067211ULL, 0x04afe400078ff0ffULL, 0x000000084f157811ULL, 0x000fc400078ff0ffULL,
0x0000000617067210ULL, 0x000fe40007f1e0ffULL, 0x000000104f077811ULL, 0x040fe400078ff0ffULL,
0x000000184f097811ULL, 0x040fe200078ff0ffULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005e0006167a11ULL, 0x000fe200078038ffULL, 0x0000000124087824ULL, 0x040fe200078e0207ULL,
0x000000204f0b7811ULL, 0x040fe200078ff0ffULL, 0x00000001240a7824ULL, 0x040fe200078e0209ULL,
0x000000284f0d7811ULL, 0x000fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x000000304f117811ULL, 0x040fe200078ff0ffULL, 0x00000001240c7824ULL, 0x040fe200078e020bULL,
0x000000384f137811ULL, 0x000fe200078ff0ffULL, 0x00000001240f7824ULL, 0x040fe200078e020dULL,
0x00000003ff147819ULL, 0x000fe2000001164fULL, 0x0000000124107824ULL, 0x000fe200078e0211ULL,
0x00005f0006277a11ULL, 0x000fe200000f3c27ULL, 0x0000000124067824ULL, 0x000fe200078e0215ULL,
0x0000000314147812ULL, 0x000fe200078e484fULL, 0x0000000124127824ULL, 0x000fe200078e0213ULL,
0x00000008171e7210ULL, 0x000fe20007fbe0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000617227210ULL, 0x000fe20007fde0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0xfffffffc09087812ULL, 0x000fe200078ee214ULL, 0x0000000407077824ULL, 0x000fe200078e00ffULL,
0x0000000a171c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x0000000c171a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000000f170f7210ULL, 0x000fc40007f5e0ffULL, 0x0000001017107210ULL, 0x040fe40007f7e0ffULL,
0x0000001217127210ULL, 0x000fe20007f9e0ffULL, 0x000000040d177824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b097812ULL, 0x100fe200078ee214ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0000100051237811ULL, 0x000fe200078e68ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0xfffffffc110b7812ULL, 0x100fe200078ee214ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e0022207a11ULL, 0x040fe200078c38ffULL, 0x00000010091d7824ULL, 0x100fe200078e0223ULL,
0xfffffffc07077812ULL, 0x100fe200078ee214ULL, 0x000000100b217824ULL, 0x000fe200078e0223ULL,
0x00005f0022227a11ULL, 0x000fe200030f3c0dULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e001c0d7a11ULL, 0x000fe200078038ffULL, 0x0000001007197824ULL, 0x100fe200078e0223ULL,
0xfffffffc170a7812ULL, 0x100fe200078ee214ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0xfffffffc15067812ULL, 0x000fe200078ee214ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x00005e001a097a11ULL, 0x000fe200078238ffULL, 0x000000100a1f7824ULL, 0x000fe200078e0223ULL,
0x00005f001c1c7a11ULL, 0x000fe200000f3c0bULL, 0x0000001006177824ULL, 0x100fe200078e0223ULL,
0x000000300e0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010081b7824ULL, 0x000fe200078e0223ULL,
0x00005e001e0a7a11ULL, 0x000fc400078a38ffULL, 0x00005f001a1a7a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200018e06ffULL, 0xfffffffc130c7812ULL, 0x000fe400078ee214ULL,
0x00005e0010137a11ULL, 0x000fe400078438ffULL, 0x000000160b067210ULL, 0x000fe40007f1e0ffULL,
0x0ffffffc144f7812ULL, 0x000fe400078ef84fULL, 0x00005f001e1e7a11ULL, 0x000fc400028f3c11ULL,
0x00005e000f117a11ULL, 0x000fe200078238ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0223ULL,
0x00005f0010167a11ULL, 0x000fe200010f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0627ULL,
0x00005e0012147a11ULL, 0x000fe200078638ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x000000200b087210ULL, 0x000fe40007f1e0ffULL, 0x00005f000f187a11ULL, 0x000fe200008f3c18ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000064f7faeULL, 0x0003e2000b901c46ULL,
0x0000000a0b0a7210ULL, 0x000fc40007f3e0ffULL, 0x00005f0012157a11ULL, 0x000fe400018f3c15ULL,
0x0000000d0b0c7210ULL, 0x040fe40007f5e0ffULL, 0x000000090b0e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0622ULL, 0x000000110b107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061cULL, 0x000000130b127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e061aULL, 0x000000140b147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e061eULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc400020e0618ULL, 0x000000ffff137224ULL, 0x000fe200028e0616ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc600000e0615ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002051047824ULL, 0x002fc800078e0204ULL,
0x0000001004067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7804ULL,
0x0000000707077812ULL, 0x000fc600078e7804ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x000000070000735dULL, 0x004fe40003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004a4b00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000297919ULL, 0x000e620000000000ULL,
0x3db504f328287820ULL, 0x020fe20000410000ULL, 0x0000f688512b7811ULL, 0x040fe200078e18ffULL,
0x00006400262a7a24ULL, 0x000fe200078e02ffULL, 0xffffffff4a2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000f608512d7811ULL, 0x000fe400078e28ffULL,
0x000001004b267824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000264d00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e002eULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x00000001272f7810ULL, 0x000fe20007ffe0ffULL, 0x00000d7000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fc400078e0027ULL, 0x00000001ff2e7819ULL, 0x100fe2000001162fULL,
0x0000002500407224ULL, 0x020fe200078e02ffULL, 0x000000022f00780cULL, 0x040fe20003f06070ULL,
0x000000ffff277224ULL, 0x000fe200078e002fULL, 0x000000012f567812ULL, 0x000fe200078ec0ffULL,
0x000003002e337a24ULL, 0x000fe200078e024bULL, 0x00000001302e7812ULL, 0x000fc800078e0cffULL,
0x0000000133317810ULL, 0x000fc80007ffe0ffULL, 0x0000004a3100720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff397819ULL, 0x002fe20000011629ULL,
0x0000010033387824ULL, 0x000fe400078e0202ULL, 0x0000000251427824ULL, 0x000fe200078e022eULL,
0x0000000839437810ULL, 0x040fe20007ffe0ffULL, 0x00000001242f7824ULL, 0x040fe200078e0239ULL,
0x0000001039477810ULL, 0x040fe40007ffe0ffULL, 0x0000001839497810ULL, 0x000fe20007ffe0ffULL,
0x0000000124317824ULL, 0x000fe200078e0243ULL, 0x0000002f40337210ULL, 0x000fe20007f3e0ffULL,
0x0000000124327824ULL, 0x000fe200078e0247ULL, 0x000000384d2f7217ULL, 0x000fe20007800000ULL,
0x0000000443457824ULL, 0x000fe200078e00ffULL, 0x0000003140357210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200008e06ffULL, 0x0000003240317210ULL, 0x000fe20007f7e0ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a38ULL, 0x0000002839527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078438ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e0031367a11ULL, 0x000fc400078638ffULL,
0x0000003039537810ULL, 0x000fe40007ffe0ffULL, 0x00005f0031377a11ULL, 0x000fe200018f3c3aULL,
0x0000000124317824ULL, 0x040fe200078e0249ULL, 0x00005e0033327a11ULL, 0x000fe200078238ffULL,
0x00000001243a7824ULL, 0x040fe200078e0253ULL, 0x00000020394f7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0035357a11ULL, 0x000fe400010f3c3cULL, 0x0000002f3900720cULL, 0x040fe20003f46070ULL,
0x0000000124387824ULL, 0x040fe200078e024fULL, 0x0000003839547810ULL, 0x000fe20007ffe0ffULL,
0x0000000124397824ULL, 0x000fe200078e0252ULL, 0x00005f0033337a11ULL, 0x000fe200008f3c3eULL,
0x00000004563e7824ULL, 0x000fe200078e00ffULL, 0x00000031403c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000124317824ULL, 0x000fe200078e0254ULL, 0x00000039403d7210ULL, 0x000fc40007fde0ffULL,
0x0000003a403f7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x00000038403b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff487224ULL, 0x000fe200030e06ffULL,
0x00000003ff3a7819ULL, 0x100fe20000011629ULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005e003c387a11ULL, 0x000fe400078238ffULL, 0x000000033a507812ULL, 0x000fe400078e4829ULL,
0x00005f003c397a11ULL, 0x000fe200008f3c39ULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x0000002f4300720cULL, 0x000fc40003f26070ULL, 0x0000003140417210ULL, 0x000fe40007f7e0ffULL,
0x0000100042427811ULL, 0x000fe400078e60ffULL, 0x0ffffffc50437812ULL, 0x100fe200078ef829ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0xfffffffc3e317812ULL, 0x000fe400078ee229ULL,
0xfffffffc45457812ULL, 0x000fe200078ee250ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0x00005e003b3a7a11ULL, 0x000fe200078a38ffULL, 0x0000001031327825ULL, 0x000fe200078e0032ULL,
0x00005e003f3e7a11ULL, 0x000fc400078838ffULL, 0x00005f003b3b7a11ULL, 0x000fe200028f3c3cULL,
0x0000001045457824ULL, 0x000fe200078e0242ULL, 0x00005e003d3c7a11ULL, 0x000fe200078a38ffULL,
0x0000001031347825ULL, 0x000fe200078e0034ULL, 0x00005e0041407a11ULL, 0x000fe200078638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032437faeULL, 0x0003e2000d101c46ULL,
0x00005f003d3d7a11ULL, 0x000fe400028f3c48ULL, 0x00005f003f3f7a11ULL, 0x000fe200020f3c46ULL,
0x0000000034457faeULL, 0x0005e2000c901c46ULL, 0x00005f0041417a11ULL, 0x000fc400018f3c44ULL,
0x0000002f4700720cULL, 0x080fe40003f26070ULL, 0x0000002f4900720cULL, 0x0c0fe20003f46070ULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0000002f4f00720cULL, 0x0c0fe20003f66070ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x0000002f5200720cULL, 0x080fe20003f86070ULL,
0x0000000454337824ULL, 0x042fe200078e00ffULL, 0x0000002f5300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x0000002f5400720cULL, 0x000fe20003fc6070ULL,
0x00000004472f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc49437812ULL, 0x100fe200078ee250ULL,
0x0000000452477824ULL, 0x000fe200078e00ffULL, 0xfffffffc4f457812ULL, 0x004fe200078ee250ULL,
0x0000001031347825ULL, 0x000fe200078e0038ULL, 0xfffffffc2f2f7812ULL, 0x000fc400078ee250ULL,
0xfffffffc47477812ULL, 0x000fe200078ee250ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0xfffffffc53497812ULL, 0x000fe200078ee250ULL, 0x000000102f2f7824ULL, 0x000fe200078e0242ULL,
0xfffffffc334f7812ULL, 0x000fe200078ee250ULL, 0x0000001031327825ULL, 0x000fc800078e0036ULL,
0x0000001045457824ULL, 0x000fe200078e0242ULL, 0x00000000322f7faeULL, 0x0003e2000c901c46ULL,
0x0000001031367825ULL, 0x000fc600078e003aULL, 0x0000000034437faeULL, 0x0003e2000d101c46ULL,
0x0000001047477824ULL, 0x000fe400078e0242ULL, 0x0000001031387825ULL, 0x000fe200078e003cULL,
0x0000000036457faeULL, 0x0003e6000d901c46ULL, 0x0000001049497824ULL, 0x000fe200078e0242ULL,
0x0000000038477faeULL, 0x0003e2000e101c46ULL, 0x00000010313a7825ULL, 0x000fc800078e003eULL,
0x000000104f4f7824ULL, 0x000fe200078e0242ULL, 0x000000003a497faeULL, 0x0003e2000e901c46ULL,
0x00000010313c7825ULL, 0x000fca00078e0040ULL, 0x000000003c4f7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000829377811ULL, 0x042fe200078ff0ffULL,
0x00000004563e7824ULL, 0x000fe200078e00ffULL, 0x0000002429317211ULL, 0x040fe400078ff0ffULL,
0x0000001029437811ULL, 0x000fe200078ff0ffULL, 0x00000001242f7824ULL, 0x040fe200078e0237ULL,
0x0000004031317210ULL, 0x080fe20007f3e0ffULL, 0x0000000437377824ULL, 0x000fe200078e00ffULL,
0x0000001829457811ULL, 0x000fe400078ff0ffULL, 0x000000402f2f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0031327a11ULL, 0x000fe200078238ffULL,
0x0000000124397824ULL, 0x040fe200078e0245ULL, 0x0000002029477811ULL, 0x000fe200078ff0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005e002f347a11ULL, 0x000fe200078438ffULL,
0x0000000445557824ULL, 0x000fe200078e00ffULL, 0x00005f0031337a11ULL, 0x000fe200008f3c38ULL,
0x0000000251317824ULL, 0x000fe200078e022eULL, 0x00005f002f357a11ULL, 0x000fe200010f3c36ULL,
0x00000001242f7824ULL, 0x040fe200078e0243ULL, 0x00000003ff387819ULL, 0x000fe20000011629ULL,
0x0000000447577824ULL, 0x000fe200078e00ffULL, 0x0000002829497811ULL, 0x040fe200078ff0ffULL,
0x00000001243b7824ULL, 0x000fe200078e0247ULL, 0x00000030294f7811ULL, 0x000fc400078ff0ffULL,
0x0000003829537811ULL, 0x000fe200078ff0ffULL, 0x0000000449597824ULL, 0x000fe200078e00ffULL,
0x000000402f2f7210ULL, 0x080fe20007fde0ffULL, 0x000000044f5b7824ULL, 0x000fe200078e00ffULL,
0x00001000313c7811ULL, 0x000fe200078e60ffULL, 0x0000000443317824ULL, 0x000fe200078e00ffULL,
0x00000003383a7812ULL, 0x000fe200078e4829ULL, 0x00000004535d7824ULL, 0x000fe200078e00ffULL,
0x0000004039397210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff387224ULL, 0x000fe200030e06ffULL,
0xfffffffc31457812ULL, 0x100fe200078ee23aULL, 0x00000001243d7824ULL, 0x040fe200078e0249ULL,
0x00005e002f367a11ULL, 0x000fe200078c38ffULL, 0x00000001243f7824ULL, 0x000fe200078e024fULL,
0x0ffffffc3a317812ULL, 0x000fe200078ef829ULL, 0x0000000124417824ULL, 0x000fe200078e0253ULL,
0xfffffffc37437812ULL, 0x000fc400078ee23aULL, 0xfffffffc57497812ULL, 0x100fe400078ee23aULL,
0xfffffffc55477812ULL, 0x000fe200078ee23aULL, 0x0000001031557824ULL, 0x000fe200078e023cULL,
0xfffffffc594f7812ULL, 0x000fe200078ee23aULL, 0x0000001045317824ULL, 0x000fe200078e023cULL,
0xfffffffc5b537812ULL, 0x000fe200078ee23aULL, 0x0000001049457824ULL, 0x000fe200078e023cULL,
0xfffffffc5d577812ULL, 0x000fe200078ee23aULL, 0x000000ffff3a7224ULL, 0x000fe200028e06ffULL,
0x000000403b3b7210ULL, 0x080fe20007f9e0ffULL, 0x0000001053497824ULL, 0x000fe200078e023cULL,
0x00005f002f377a11ULL, 0x000fe200030f3c38ULL, 0x00000010432f7824ULL, 0x100fe200078e023cULL,
0x000000403d3d7210ULL, 0x080fe20007f3e0ffULL, 0x0000001047437824ULL, 0x100fe200078e023cULL,
0x00005e0039387a11ULL, 0x000fe200078a38ffULL, 0x000000104f477824ULL, 0x100fe200078e023cULL,
0x000000403f3f7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x0000004041417210ULL, 0x000fe20007f7e0ffULL, 0x00000010574f7824ULL, 0x000fe200078e023cULL,
0x00005f0039397a11ULL, 0x000fe200028f3c3aULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0xfffffffc3e537812ULL, 0x000fe200078ee229ULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078838ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078238ffULL, 0x0000001053327825ULL, 0x000fe200078e0032ULL,
0x00005e003f3e7a11ULL, 0x000fc400078438ffULL, 0x00005e0041407a11ULL, 0x000fe200078638ffULL,
0x0000001053347825ULL, 0x000fe200078e0034ULL, 0x00005f003b3b7a11ULL, 0x000fe200020f3c48ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032557faeULL, 0x0003e2000b901c46ULL,
0x00005f003d3d7a11ULL, 0x000fe200008f3c46ULL, 0x0000001053367825ULL, 0x000fe200078e0036ULL,
0x00005f003f3f7a11ULL, 0x000fe200010f3c44ULL, 0x00000000342f7faeULL, 0x0003e2000b901c46ULL,
0x00005f0041417a11ULL, 0x000fe200018f3c42ULL, 0x0000001053387825ULL, 0x040fe400078e0038ULL,
0x0000000036317faeULL, 0x0003e4000b901c46ULL, 0x00000010533a7825ULL, 0x000fc400078e003aULL,
0x0000000038437faeULL, 0x0003e4000b901c46ULL, 0x00000010533c7825ULL, 0x040fe400078e003cULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0x00000010533e7825ULL, 0x040fe400078e003eULL,
0x000000003c477faeULL, 0x0003e4000b901c46ULL, 0x0000001053407825ULL, 0x000fc400078e0040ULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x00000000404f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff337424ULL, 0x002fe400078e00ffULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000030033037a24ULL, 0x000fca00078e0203ULL, 0x0000004c0300720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000022a327824ULL, 0x000fc800078e0203ULL,
0x0000600032327625ULL, 0x000fca00078e0033ULL, 0x0000000632007981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002029407810ULL, 0x002fe20007ffe0ffULL, 0x00000002513f7824ULL, 0x000fe200078e0230ULL,
0xfffffff829327812ULL, 0x040fe200078ec0ffULL, 0x000000084e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x00000007322f7812ULL, 0x100fe400078ef829ULL, 0x0000000740407812ULL, 0x000fe400078ef829ULL,
0x00000007293e7812ULL, 0x000fc400078ec0ffULL, 0x00000001ff427819ULL, 0x000fe4000001162fULL,
0x00000001ff447819ULL, 0x000fe40000011640ULL, 0x000010003f3f7811ULL, 0x000fe400078e60ffULL,
0x000000083e3e7812ULL, 0x000fe400078ef829ULL, 0x0000000342427812ULL, 0x000fe400078ec0ffULL,
0x0000000344447812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003d42307212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003d44357212ULL, 0x000fc400078e3cffULL, 0x000000013d497810ULL, 0x000fe20007ffe0ffULL,
0x000000042f307824ULL, 0x000fe200078e0230ULL, 0x0000003c29537211ULL, 0x000fe200078fe0ffULL,
0x0000000440347824ULL, 0x000fe200078e0235ULL, 0x000000023d3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001030307824ULL, 0x100fe200078e023fULL, 0x000000043c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe200078e023fULL, 0x000000043d00780cULL, 0x000fc60003f25270ULL,
0x000000003030783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x00000018ff387819ULL, 0x002fe20000011430ULL, 0x00010000313b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011431ULL, 0x0000003800547306ULL, 0x0003e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fc40000011432ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff477819ULL, 0x000fe40000011433ULL, 0x00000018ff467819ULL, 0x004fe20000011434ULL,
0x0000003900587306ULL, 0x0005e20000200c00ULL, 0x0000888030387816ULL, 0x002fe400000000ffULL,
0x00000018ff457819ULL, 0x000fe40000011435ULL, 0x00000018ff437819ULL, 0x000fc40000011436ULL,
0x00000018ff417819ULL, 0x000fe20000011437ULL, 0x0000003800527306ULL, 0x0003e20000200c00ULL,
0x0001000030397824ULL, 0x044fe400078e00ffULL, 0x0000010030307824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003a005c7306ULL, 0x0005e20000200c00ULL, 0x0000888032387816ULL, 0x002fce00000000ffULL,
0x0000003000577306ULL, 0x0003e20000200c00ULL, 0x00008880313a7816ULL, 0x044fe200000000ffULL,
0x0000010031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000038005a7306ULL, 0x0005e20000200c00ULL, 0x0001000032307824ULL, 0x042fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003900557306ULL, 0x0003e20000200c00ULL,
0x0000004942387212ULL, 0x084fe400078e3cffULL, 0x0000004944497212ULL, 0x000fc600078e3cffULL,
0x000000042f387824ULL, 0x000fe400078e0238ULL, 0x00000031005b7306ULL, 0x0005e20000200c00ULL,
0x0000888033397816ULL, 0x002fe200000000ffULL, 0x0000001038387824ULL, 0x000fcc00078e023fULL,
0x00000032005f7306ULL, 0x0003e20000200c00ULL, 0x0001000033317824ULL, 0x044fe400078e00ffULL,
0x0000010033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000030005d7306ULL, 0x0004e20000200c00ULL, 0x0001000034327824ULL, 0x002fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fc80000011433ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003a00567306ULL, 0x000fe20000200c00ULL, 0x0000888034307816ULL, 0x044fe200000000ffULL,
0x0000010034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003b00597306ULL, 0x000e620000200c00ULL, 0x000054105a5a7816ULL, 0x008fce000000005dULL,
0x00000039005e7306ULL, 0x0005f00000200c00ULL, 0x0000003100617306ULL, 0x0007220000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x0000541056567816ULL, 0x002fcc0000000059ULL,
0x0000003000627306ULL, 0x0003e20000200c00ULL, 0x0000888035317816ULL, 0x008fce00000000ffULL,
0x0000003200637306ULL, 0x0006a20000200c00ULL, 0x0001000035307824ULL, 0x042fe200078e00ffULL,
0x000054105e5e7816ULL, 0x010fe20000000061ULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100647306ULL, 0x0003e20000200c00ULL,
0x0000000440327824ULL, 0x008fe200078e0249ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000037497824ULL, 0x000fe400078e00ffULL, 0x0000001032327824ULL, 0x000fc600078e023fULL,
0x0000003300607306ULL, 0x000fe20000200c00ULL, 0x0001000036317824ULL, 0x002fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000541062627816ULL, 0x004fe40000000063ULL,
0x00000018ff487819ULL, 0x000fe40000011431ULL, 0x0000003000677306ULL, 0x0002a20000200c00ULL,
0x00008880396d7816ULL, 0x000fe200000000ffULL, 0x000100003a777824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc8000001143bULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000003400657306ULL, 0x0007e20000200c00ULL, 0x000000003230783bULL, 0x002e6e0000000200ULL,
0x0000003500667306ULL, 0x0009e20000200c00ULL, 0x0000888036347816ULL, 0x048fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x0000541064647816ULL, 0x004fc80000000067ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400687306ULL, 0x0005e20000200c00ULL,
0x0000888037357816ULL, 0x050fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x00000036006a7306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x004fce0000011438ULL, 0x00000035006b7306ULL, 0x0005e20000200c00ULL,
0x00000018ff367819ULL, 0x008fce0000011439ULL, 0x0000003600757306ULL, 0x0007e20000200c00ULL,
0x0001000038357824ULL, 0x004fe200078e00ffULL, 0x00008880307e7816ULL, 0x002fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011430ULL, 0x00000018ff4e7819ULL, 0x000fe40000011431ULL,
0x0000003400717306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x008fe40000011435ULL,
0x0000000753357812ULL, 0x000fc400078e783eULL, 0x0000000253537810ULL, 0x000fc60007ffe0ffULL,
0x000000103e357824ULL, 0x000fe200078e0235ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000004800697306ULL, 0x0002a20000200c00ULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000000753537812ULL, 0x000fe200078e783eULL, 0x0000001035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000000103e537824ULL, 0x000fe200078e0253ULL,
0x00000037006e7306ULL, 0x0007e20000200c00ULL, 0x00000018ff487819ULL, 0x002fce000001143aULL,
0x00000034006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff377819ULL, 0x008fe40000011433ULL,
0x0000541068687816ULL, 0x004fca0000000069ULL, 0x0000004800797306ULL, 0x000fe20000200c00ULL,
0x0001000039347824ULL, 0x042fe400078e00ffULL, 0x0000010039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011434ULL, 0x0000003700487306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003600707306ULL, 0x0002b00000200c00ULL,
0x0000003900767306ULL, 0x0007220000200c00ULL, 0x000000003534783bULL, 0x002e6e0000000200ULL,
0x0000003800727306ULL, 0x0009220000200c00ULL, 0x000100003b397824ULL, 0x008fe200078e00ffULL,
0x000054106f707816ULL, 0x004fc80000000070ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x000088803a387816ULL, 0x050fe200000000ffULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541076757816ULL, 0x000fc80000000075ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000003800787306ULL, 0x0007e20000200c00ULL,
0x0000541072717816ULL, 0x000fce0000000071ULL, 0x00000039007c7306ULL, 0x0009e20000200c00ULL,
0x0000541052387816ULL, 0x008fe40000000055ULL, 0x0000541065637816ULL, 0x004fca0000000046ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000541057397816ULL, 0x010fe20000000054ULL,
0x000000623414723cULL, 0x002fe20000001814ULL, 0x000054105b577816ULL, 0x000fe40000000058ULL,
0x000054105f5b7816ULL, 0x000fc6000000005cULL, 0x0000004500457306ULL, 0x000e640000200c00ULL,
0x000000383404723cULL, 0x040fec0000001804ULL, 0x0000004300437306ULL, 0x000ee20000200c00ULL,
0x000000ffff387224ULL, 0x000fe200078e007eULL, 0x00005410605f7816ULL, 0x004fe20000000047ULL,
0x000000563408723cULL, 0x000fea0000001808ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000541066657816ULL, 0x002fc40000000045ULL, 0x0000888032457816ULL, 0x000fe200000000ffULL,
0x0000005a340c723cULL, 0x040fe8000000180cULL, 0x00000049006c7306ULL, 0x0002a20000200c00ULL,
0x000054106a697816ULL, 0x008fe20000000043ULL, 0x000000ffff437224ULL, 0x000fe400078e0045ULL,
0x0000005e3410723cULL, 0x000fe20000001810ULL, 0x0001000032457824ULL, 0x000fc600078e00ffULL,
0x0000006d00747306ULL, 0x0007e20000200c00ULL, 0x00000018ff497819ULL, 0x002fe40000011432ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x000000643418723cULL, 0x040fe80000001818ULL,
0x0000003a007a7306ULL, 0x0003220000200c00ULL, 0x000088803b6d7816ULL, 0x048fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x000054106b6c7816ULL, 0x004fe2000000006cULL,
0x00000068341c723cULL, 0x000fe6000000181cULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003800547306ULL, 0x0005e20000200c00ULL, 0x00010000303a7824ULL, 0x002fc400078e00ffULL,
0x0000010030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143aULL,
0x0000006d007b7306ULL, 0x0002e20000200c00ULL, 0x0000001053387824ULL, 0x004fe200078e00ffULL,
0x0000888031537816ULL, 0x000fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x000054107a797816ULL, 0x010fe20000000079ULL, 0x000000ffff477224ULL, 0x000fe200078e0053ULL,
0x0000003b007d7306ULL, 0x0005e20000200c00ULL, 0x000054106e6d7816ULL, 0x002fce0000000041ULL,
0x0000005200557306ULL, 0x0003220000200c00ULL, 0x000000003838783bULL, 0x004ea20000000200ULL,
0x0000006c3420723cULL, 0x000fe20000001820ULL, 0x000054107b7c7816ULL, 0x008fca000000007cULL,
0x0000005000507306ULL, 0x000ee20000200c00ULL, 0x0001000031527824ULL, 0x002fe200078e00ffULL,
0x0000888033357816ULL, 0x000fe200000000ffULL, 0x0000010031317824ULL, 0x000fe400078e00ffULL,
0x0000010032347824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0001000033367824ULL, 0x040fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000010033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000541054547816ULL, 0x010fe40000000055ULL,
0x000054107d7d7816ULL, 0x008fe20000000050ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000000703804723cULL, 0x044fee0000001804ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000007c3810723cULL, 0x000fee0000001810ULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x0000541074747816ULL, 0x002fce0000000073ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541078787816ULL, 0x004fe20000000077ULL, 0x000000743808723cULL, 0x040fec0000001808ULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0000541030557816ULL, 0x008fe2000000004fULL,
0x00000078380c723cULL, 0x040fec000000180cULL, 0x0000003100317306ULL, 0x000ea40000200c00ULL,
0x000000543814723cULL, 0x000fec0000001814ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000541047527816ULL, 0x002fce0000000052ULL, 0x0000004500327306ULL, 0x000e620000200c00ULL,
0x0000541031537816ULL, 0x004fce000000004eULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000000523818723cULL, 0x000fee0000001818ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x0000541043327816ULL, 0x002fce0000000032ULL, 0x0000003600367306ULL, 0x000e700000200c00ULL,
0x0000003300377306ULL, 0x0004e20000200c00ULL, 0x0000541035367816ULL, 0x002fe40000000036ULL,
0x0000541034337816ULL, 0x004fc40000000049ULL, 0x0000541037377816ULL, 0x008fca0000000048ULL,
0x00000032381c723cULL, 0x040ff0000000181cULL, 0x000000363820723cULL, 0x000fe20000001820ULL,
0xfffff0d000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff307224ULL, 0x000fe200078e002eULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe13000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002b307f8cULL, 0x000fe2000c80043fULL,
0x0000001228377220ULL, 0x000fc40000410000ULL, 0x0000001328387220ULL, 0x040fe20000410000ULL,
0x000004002b277984ULL, 0x000e620000000800ULL, 0x0000001428127220ULL, 0x040fe40000410000ULL,
0x0000001528137220ULL, 0x040fe40000410000ULL, 0x00000006282f7220ULL, 0x040fe40000410000ULL,
0x0000000728327220ULL, 0x040fe40000410000ULL, 0x0000000a28337220ULL, 0x000fc40000410000ULL,
0x0000000b28347220ULL, 0x040fe40000410000ULL, 0x0000000e28357220ULL, 0x040fe40000410000ULL,
0x0000001828147220ULL, 0x040fe40000410000ULL, 0x0000001928157220ULL, 0x040fe40000410000ULL,
0x0000000428047220ULL, 0x040fe40000410000ULL, 0x0000000528057220ULL, 0x000fc40000410000ULL,
0x0000000828087220ULL, 0x040fe40000410000ULL, 0x0000000928097220ULL, 0x040fe40000410000ULL,
0x0000000c28067220ULL, 0x040fe40000410000ULL, 0x0000000d28077220ULL, 0x040fe40000410000ULL,
0x0000000f28367220ULL, 0x040fe40000410000ULL, 0x0000001628397220ULL, 0x000fc40000410000ULL,
0x00000017283a7220ULL, 0x040fe40000410000ULL, 0x0000001a28187220ULL, 0x040fe40000410000ULL,
0x0000001b28197220ULL, 0x040fe20000410000ULL, 0x8000000027ff7812ULL, 0x002fe20007804831ULL,
0x0000001e283b7220ULL, 0x040fe40000410000ULL, 0x0000001f283c7220ULL, 0x040fe40000410000ULL,
0x0000001c28167220ULL, 0x000fc40000410000ULL, 0x0000001d28177220ULL, 0x040fe40000410000ULL,
0x00000020281a7220ULL, 0x040fe40000410000ULL, 0x00000021281b7220ULL, 0x040fe40000410000ULL,
0x00000022283d7220ULL, 0x040fe40000410000ULL, 0x00000023283e7220ULL, 0x000fe40000410000ULL,
0x000000ffff1c7224ULL, 0x000fc400078e002fULL, 0x000000ffff1d7224ULL, 0x000fe400078e0032ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0033ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0034ULL,
0x000000ffff207224ULL, 0x000fe400078e0035ULL, 0x0000001028107220ULL, 0x040fe40000410000ULL,
0x0000001128117220ULL, 0x000fc40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0005ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0007ULL, 0x000000ffff217224ULL, 0x000fe400078e0036ULL,
0x000000ffff227224ULL, 0x000fe400078e0037ULL, 0x000000ffff237224ULL, 0x000fe400078e0038ULL,
0x000000ffff277224ULL, 0x000fe400078e0039ULL, 0x000000ffff2f7224ULL, 0x000fe400078e003aULL,
0x000000ffff327224ULL, 0x000fc400078e0018ULL, 0x000000ffff337224ULL, 0x000fe400078e0019ULL,
0x000000ffff347224ULL, 0x000fe400078e003bULL, 0x000000ffff357224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe400078e003dULL, 0x000000ffff377224ULL, 0x000fe200078e003eULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x000004002b057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000429197824ULL, 0x000fe200078e00ffULL, 0x0000002c4b00720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008051187824ULL, 0x000fca00078e0218ULL,
0x00f4000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000229087824ULL, 0x000fe400078e00ffULL, 0x000000014d267824ULL, 0x000fc600078e0a26ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109317812ULL, 0x040fe400078efcffULL,
0x0000000809397812ULL, 0x000fe400078efcffULL, 0x000000263100720cULL, 0x080fe40003f26070ULL,
0x0000001009317812ULL, 0x000fe400078efcffULL, 0x000000263900720cULL, 0x080fe40003f06070ULL,
0x000000263100720cULL, 0x000fc40003fc6070ULL, 0x0000001109397812ULL, 0x040fe400078efcffULL,
0x0000001809317812ULL, 0x040fe400078efcffULL, 0x000000260900720cULL, 0x080fe40003f46070ULL,
0x000000263900720cULL, 0x080fe40003fa6070ULL, 0x000000263100720cULL, 0x000fe40003f66070ULL,
0x00000009093b7812ULL, 0x000fc400078efcffULL, 0x0000001909397812ULL, 0x040fe400078efcffULL,
0x0000002009317812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000263b00720cULL, 0x080fe40003f86070ULL,
0x000000263900720cULL, 0x080fe40003f46070ULL, 0x000000263100720cULL, 0x000fe40003f26070ULL,
0x0000002109397812ULL, 0x040fe400078efcffULL, 0x0000002809317812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000263900720cULL, 0x080fe40003f06070ULL, 0x000000263100720cULL, 0x000fe40003f86070ULL,
0x0000002909397812ULL, 0x000fc400078efcffULL, 0x0000003009317812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000263900720cULL, 0x000fc40003fc6070ULL, 0x000000263100720cULL, 0x000fe40003fa6070ULL,
0x0000003109397812ULL, 0x040fe400078efcffULL, 0x0000003809317812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000263900720cULL, 0x080fe40003f66070ULL,
0x000000263100720cULL, 0x000fc40003f46070ULL, 0x000000260900720cULL, 0x000fe40003f26070ULL,
0xff7fffff2f2f7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff32327808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff33337808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff34347808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff35357808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff36367808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff37377808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fc40007810000ULL,
0x0000000c09047209ULL, 0x000fe40007810000ULL, 0x0000001e05087209ULL, 0x000fe40007810000ULL,
0x0000000d04057209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fe40007810000ULL,
0x0000000e05047209ULL, 0x000fe40007810000ULL, 0x0000002009087209ULL, 0x000fc40007810000ULL,
0x0000000f04057209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x0000002209087209ULL, 0x000fe40007810000ULL,
0x0000001104057209ULL, 0x000fe40007810000ULL, 0x0000002308087209ULL, 0x000fc40007810000ULL,
0x0000001205047209ULL, 0x000fe40007810000ULL, 0x0000002708087209ULL, 0x000fe40007810000ULL,
0x0000001304057209ULL, 0x000fe40007810000ULL, 0x0000002f08097209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000003209087209ULL, 0x000fc40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000003308097209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000003409087209ULL, 0x000fe40007810000ULL,
0x0000001704057209ULL, 0x000fe40007810000ULL, 0x0000003508097209ULL, 0x000fc40007810000ULL,
0x0000001a05047209ULL, 0x000fe40007810000ULL, 0x0000003609087209ULL, 0x000fe40007810000ULL,
0x0000001b04307209ULL, 0x000fe40007810000ULL, 0x0000003708387209ULL, 0x000fe20007810000ULL,
0x000018427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030047f89ULL, 0x0004e400000e0000ULL,
0x0000000430397209ULL, 0x008fe20007810000ULL, 0x000018827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0038047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007267f89ULL, 0x000e6200000e0000ULL, 0x0000000438087209ULL, 0x008fc60007810000ULL,
0x0c201f0039047f89ULL, 0x000ee200000e0000ULL, 0x0000000506097209ULL, 0x010fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000f2200000e0000ULL, 0x0000002607267209ULL, 0x002fc60007810000ULL,
0x0c201f0009307f89ULL, 0x004e6800000e0000ULL, 0x0c201f0026317f89ULL, 0x0004a200000e0000ULL,
0x0000000439047209ULL, 0x008fe40007810000ULL, 0x0000000508057209ULL, 0x010fe40007810000ULL,
0x0000003009067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b05307820ULL, 0x002fe20000410000ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0b0b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b21217823ULL, 0x000fc40000010830ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010830ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b23237823ULL, 0x000fe40000010830ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b15157823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010830ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe40000010830ULL, 0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL,
0x0000001e000b7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1b077823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b34347823ULL, 0x000fe20000010830ULL, 0x0000001f00387308ULL, 0x0008a20000000800ULL,
0x0000001c1d09723eULL, 0x002fe200000000ffULL, 0x3c003c00ff1e7424ULL, 0x008fc400078e00ffULL,
0x3fb8aa3b35357823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b36367823ULL, 0x100fe40000010830ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x3c003c00ff1f7424ULL, 0x010fe400078e00ffULL,
0x3fb8aa3b37307823ULL, 0x000fe20000010830ULL, 0x0000000b380b723eULL, 0x004fc800000000ffULL,
0x0000000f000f7308ULL, 0x000e660000000800ULL, 0x0000001e0838723cULL, 0x000fea00000018ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000000ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fce00000000ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x00000020210d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000001e0c38723cULL, 0x000fee0000001838ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002f001c7308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x004fe200000000ffULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc29147812ULL, 0x000fc800078ec0ffULL, 0x0000001415207219ULL, 0x000fe200000006ffULL,
0x0000003200327308ULL, 0x000fe60000000800ULL, 0x00000000201d73a1ULL, 0x000ea200000e8000ULL,
0x00000000200473c4ULL, 0x000ee80000004000ULL, 0x0000003300337308ULL, 0x000f220000000800ULL,
0x000000271c11723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000323313723eULL, 0x010fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x0000000520ff7c12ULL, 0x004fe2000f80401dULL, 0x0000001e1038723cULL, 0x000fec0000001838ULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x0000001a0716723eULL, 0x004fe400000000ffULL,
0x0000002631077209ULL, 0x000fca0007810000ULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x00000030001b7308ULL, 0x000ea20000000800ULL, 0x000000343515723eULL, 0x002fe400000000ffULL,
0x000000361b17723eULL, 0x004fce00000000ffULL, 0x0000001e1438723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000149204008947ULL, 0x008fde000b800000ULL,
0x001c1fff381c7589ULL, 0x0002a400000e0000ULL, 0x00000000201b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000520ff7c12ULL, 0x008fda000f80401bULL, 0x000014b204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1a7819ULL, 0x000fe40000011629ULL,
0x0000000c193d7812ULL, 0x000fc400078ec0ffULL, 0x000000071a1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081a267824ULL, 0x040fe200078e00ffULL, 0x0000001aff227212ULL, 0x000fe200078e33ffULL,
0x000000081a207824ULL, 0x04afe200078e00ffULL, 0x0000000329ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081a377824ULL, 0x040fe200078e00ffULL, 0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff826217812ULL, 0x100fe400078ee21bULL, 0x0000000120237812ULL, 0x100fe200078ef61bULL,
0x000000081a497824ULL, 0x000fe200078e00ffULL, 0x0000000220277812ULL, 0x100fe200078ef61bULL,
0x000000081a267824ULL, 0x000fe200078e00ffULL, 0x00000003202f7812ULL, 0x000fc400078ef61bULL,
0x0000000420317812ULL, 0x140fe400078ef61bULL, 0x0000000520337812ULL, 0x140fe400078ef61bULL,
0x0000000620357812ULL, 0x000fe200078ef61bULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe400078ee222ULL, 0x0000001aff227212ULL, 0x000fe400078e33ffULL,
0x000000071a1b7812ULL, 0x000fc400078ec0ffULL, 0x00009000511a7811ULL, 0x000fe400078e58ffULL,
0xfffffff826397812ULL, 0x100fe400078ee21bULL, 0x00000001203b7812ULL, 0x140fe200078ef61bULL,
0x0000001021197824ULL, 0x100fe200078e021aULL, 0x00000002203f7812ULL, 0x140fe200078ef61bULL,
0x0000001031267824ULL, 0x100fe200078e021aULL, 0x0000000320417812ULL, 0x040fe200078ef61bULL,
0x000000013d197824ULL, 0x000fe200078e0219ULL, 0x0000000420437812ULL, 0x140fe200078ef61bULL,
0x0000001035307824ULL, 0x100fe200078e021aULL, 0x0000000520457812ULL, 0x140fe200078ef61bULL,
0x0000001037327824ULL, 0x100fe200078e021aULL, 0x0000000620477812ULL, 0x000fe200078ef61bULL,
0x00000010231b7824ULL, 0x000fe200078e021aULL, 0xfffffff849497812ULL, 0x000fe200078ee222ULL,
0x0000001027207824ULL, 0x100fe200078e021aULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x000000102f227824ULL, 0x000fc400078e021aULL, 0x00000010332f7824ULL, 0x000fe400078e021aULL,
0x000000013d1b7824ULL, 0x040fe400078e021bULL, 0x000000013d217824ULL, 0x040fe400078e0220ULL,
0x000000013d237824ULL, 0x000fe200078e0222ULL, 0x0000000a1b007388ULL, 0x0007e20000000800ULL,
0x0000001039347824ULL, 0x000fe400078e021aULL, 0x000000013d277824ULL, 0x000fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000103b357824ULL, 0x000fc400078e021aULL,
0x000000013d2f7824ULL, 0x000fe200078e022fULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x000000103f367824ULL, 0x000fe400078e021aULL, 0x000000013d317824ULL, 0x000fe200078e0230ULL,
0x0000001027007388ULL, 0x0007e20000000800ULL, 0x0000001041377824ULL, 0x000fe400078e021aULL,
0x000000013d337824ULL, 0x000fe200078e0232ULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x0000001043387824ULL, 0x000fc400078e021aULL, 0x0000001045397824ULL, 0x100fe200078e021aULL,
0x0000001431007388ULL, 0x0007e20000000800ULL, 0x00000010473a7824ULL, 0x100fe400078e021aULL,
0x00000010493b7824ULL, 0x000fe200078e021aULL, 0x0000001633007388ULL, 0x0007e20000000800ULL,
0x000000013d347824ULL, 0x040fe400078e0234ULL, 0x000000013d1a7824ULL, 0x040fe400078e0235ULL,
0x000000013d367824ULL, 0x040fe200078e0236ULL, 0x0000000934007388ULL, 0x0007e20000000800ULL,
0x000000013d087824ULL, 0x002fc400078e0237ULL, 0x000000013d387824ULL, 0x040fe200078e0238ULL,
0x0000000b1a007388ULL, 0x0007e20000000800ULL, 0x000000013d207824ULL, 0x040fe400078e0239ULL,
0x000000013d3a7824ULL, 0x040fe200078e023aULL, 0x0000000d36007388ULL, 0x0007e20000000800ULL,
0x000000013d227824ULL, 0x000fc600078e023bULL, 0x0000000f08007388ULL, 0x0007e80000000800ULL,
0x0000001138007388ULL, 0x0007e80000000800ULL, 0x0000001320007388ULL, 0x0007e80000000800ULL,
0x000000153a007388ULL, 0x0007e80000000800ULL, 0x0000001722007388ULL, 0x0007e80000000800ULL,
0x00f0000418008388ULL, 0x0007e80000000c00ULL, 0x00f2001c18008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002dff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003004b4b7a10ULL, 0x000fe20007ffe0ffULL,
0x000018002dff7f8cULL, 0x0003e6000c80043fULL, 0x0000004a4b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc60000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x010fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x000119f000277802ULL, 0x000fe40000000f00ULL,
0x000010b000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0026ULL,
0xffff00b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00011a5000277802ULL, 0x000fe40000000f00ULL,
0x0000105000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0026ULL,
0xffff00d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0000ULL,
0x00011ac000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fc400078e00ffULL, 0x00000fa000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff012000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x000fe200078e0000ULL, 0x00011b3000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x00000f3000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002fULL,
0xffff00e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0025ULL,
0x00011ba000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000ec000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff577224ULL, 0x004fe200078e002fULL, 0xffff044000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0000ULL, 0x00011c1000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x00000e5000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff567224ULL, 0x004fe200078e002fULL,
0xffff040000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x010fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00011c7000277802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff1f7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00011cd000277802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff1fa000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x008fe200078e00ffULL,
0x00011d3000267802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x00000d3000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff201000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x00afe200078e0000ULL,
0x00011da000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000cc000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff20c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x00011e0000267802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000c6000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x004fe200078e002fULL, 0xffff238000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0000ULL, 0x00011e7000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x00000bf000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e002fULL,
0xffff233000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00011ed000277802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff3bf000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00011f3000277802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff3c2000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x002fe200078e00ffULL,
0x00011f9000267802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff3c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e0000ULL,
0x0001200000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000a6000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff3d4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x0001206000267802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x00000a0000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff5d7224ULL, 0x004fe200078e002fULL, 0xffff3ff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0000ULL, 0x000120d000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000099000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff5c7224ULL, 0x004fe200078e002fULL,
0xffff3fa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001213000277802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff582000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001219000277802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff585000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x002fe200078e00ffULL,
0x000121f000267802ULL, 0x000fe20000000f00ULL, 0xffffffffff737424ULL, 0x000fc400078e00ffULL,
0x0000087000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e002fULL,
0xffff58c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e0000ULL,
0x0001226000267802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x0000080000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e002fULL, 0xffff597000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x000122c000267802ULL, 0x000fe20000000f00ULL,
0xffffffffff737424ULL, 0x000fe400078e00ffULL, 0x000007a000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e002fULL, 0xffff5c3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0000ULL, 0x0001233000267802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff737424ULL, 0x000fe400078e00ffULL,
0x0000073000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002fULL,
0xffff5be000007947ULL, 0x000fea000383ffffULL, 0x00000002ff317424ULL, 0x000fe200078e00ffULL,
0x000123a000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff3a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000068000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0031ULL, 0xffffe76000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x006fe200078e0038ULL, 0x0001242000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000060000007944ULL, 0x020fea0003c00000ULL,
0x0000003138387209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0006ULL,
0x0001249000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000059000007944ULL, 0x000fea0003c00000ULL, 0x0000003106067209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0007ULL, 0x0001250000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x0000003107267209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0039ULL,
0x0001257000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x0000003139047209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0038ULL, 0x000125e000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000003138057209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0006ULL,
0x0001265000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000003106067209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0026ULL, 0x000126c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0xffffe54000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x000fe200078e0038ULL,
0x0001273000267802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff737224ULL, 0x000fe400078e0020ULL,
0x0000033000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e002fULL,
0xffffeb0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e003aULL,
0x000127b000267802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff737224ULL, 0x000fe400078e0020ULL,
0x000002b000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00ffULL,
0x0001281000267802ULL, 0x000fe20000000f00ULL, 0x00001c1fff707424ULL, 0x000fc400078e00ffULL,
0x000000ffff737224ULL, 0x000fe400078e0020ULL, 0x000000ffff1d7224ULL, 0x004fe400078e002fULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff737224ULL, 0x002fe200078e0020ULL,
0x0001287000267802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e002fULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e002fULL,
0xffffea4000007947ULL, 0x000fea000383ffffULL, 0x018000003e027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000003e00028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3eff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000003e037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003e00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0006ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffed5e002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c00003130317389ULL, 0x0002a200000e003aULL, 0xfffed5a008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000007300007348ULL, 0x000fe80003800000ULL,
0x0000006f6e2f7389ULL, 0x0002a200000e0070ULL, 0xfffed56026007950ULL, 0x000fea0003c3ffffULL,
0x000000012400780cULL, 0x000fe20003f05070ULL, 0x0000002500007348ULL, 0x000fd80003800000ULL,
0x0000000000247806ULL, 0x000fc800040e0100ULL, 0x0000002524267212ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe400078e0027ULL, 0x00000000ff257424ULL, 0x000fc800078e00ffULL,
0xfffed4f024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000398ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000978ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000128cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000012b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012c0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012e0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001370ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001378ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001388ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000012c00ULL, 0xa300001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014180ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014190ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014190ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001370ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012e10ULL, 0x0000000000012e10ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014610ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 83696;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
