/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012c90ULL, 0x0000000000012810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000113a0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000011510ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000011550ULL, 0x0000000000000130ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000011680ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000113a000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0044400400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000113a000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080920828808081ULL, 0xac08288080bc0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080ac920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x0001151000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080920828808081ULL, 0xbc08288080ac0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080bc920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001155000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000a6ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x0001078000010200ULL, 0x0001080000010790ULL,
0x0001082000010810ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000021ffffffffULL, 0x0500002105000021ULL, 0xffffffff05000021ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x00000100000000a0ULL,
0x00001a0000001970ULL, 0x00001ac000001a90ULL, 0x0000263000002500ULL, 0x00003970000038d0ULL,
0x00003a20000039f0ULL, 0x0000447000004430ULL, 0x0000562000005580ULL, 0x000056d0000056a0ULL,
0x00005ee000005b00ULL, 0x00007280000071f0ULL, 0x00007330000072f0ULL, 0x00007c4000007720ULL,
0x0000886000008850ULL, 0x0000b2d00000b2b0ULL, 0x0000b7e00000b7a0ULL, 0x00010100000100d0ULL,
0x0001012000010110ULL, 0x0001016000010140ULL, 0x0001019000010180ULL, 0x00010850000107f0ULL,
0x0001087000010860ULL, 0x00010f3000010eb0ULL, 0x00010fe000010f80ULL, 0x0001108000011030ULL,
0x00011120000110d0ULL, 0x000111c000011170ULL, 0x000112b000011230ULL, 0x0001137000011310ULL,
0x0000017003e03904ULL, 0x0000f600000000ffULL, 0x000001b0003f0100ULL, 0x0000f6080000000fULL,
0x000001e0003f0130ULL, 0x0000f6100000000fULL, 0x00000210003f0130ULL, 0x0000f6480000000fULL,
0x00000240003f0120ULL, 0x0000f6680000000fULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000005ULL, 0x00000740003f0102ULL, 0x0000f61000000005ULL,
0x00000d80003f0101ULL, 0x00000000000000ffULL, 0x00000e0000040107ULL, 0x0000002000000012ULL,
0x00000f80003f0101ULL, 0x0000002400000012ULL, 0x00001030003f0106ULL, 0x0000002400000012ULL,
0x000010c0003f0106ULL, 0x0000002400000012ULL, 0x00001700003f0106ULL, 0x000000000000006bULL,
0x0000177000040107ULL, 0x0000000400000021ULL, 0x0000179000040106ULL, 0x0000f60c00000016ULL,
0x000018a0003f0106ULL, 0x0000000400000019ULL, 0x00001d30003f0106ULL, 0x0000000400000021ULL,
0x00001dd000040106ULL, 0x0000000400000021ULL, 0x00002f7000040106ULL, 0x0000002000000012ULL,
0x00002ff0003f0101ULL, 0x0000000000000018ULL, 0x000030a0003f0101ULL, 0x0000002400000012ULL,
0x000030f0003f0106ULL, 0x0000002400000012ULL, 0x00003180003f0106ULL, 0x0000002400000012ULL,
0x00003670003f0106ULL, 0x00000000000000ffULL, 0x000036e000060107ULL, 0x0000000400000061ULL,
0x00003700003f0106ULL, 0x0000f61c00000016ULL, 0x00003810003f0106ULL, 0x0000f61c00000016ULL,
0x00003cd0003f0106ULL, 0x0000f64c0000001aULL, 0x00003d60003f0106ULL, 0x0000f64c0000001aULL,
0x00004d60003f0106ULL, 0x0000002000000012ULL, 0x00004de0003f0101ULL, 0x0000000000000018ULL,
0x00004e70003f0101ULL, 0x0000002400000012ULL, 0x00004ed0003f0106ULL, 0x0000002400000012ULL,
0x00004f60003f0106ULL, 0x0000002400000012ULL, 0x00005320003f0106ULL, 0x000000000000006bULL,
0x0000539000040107ULL, 0x00000004000000ffULL, 0x000053b000060106ULL, 0x0000f62c00000016ULL,
0x000054c0003f0106ULL, 0x0000f62c00000016ULL, 0x00005960003f0106ULL, 0x0000f64c00000018ULL,
0x000059f0003f0106ULL, 0x00000004000000ffULL, 0x000069c000060106ULL, 0x0000002000000012ULL,
0x00006a40003f0101ULL, 0x0000000000000018ULL, 0x00006ad0003f0101ULL, 0x0000002400000012ULL,
0x00006b20003f0106ULL, 0x0000002400000012ULL, 0x00006bb0003f0106ULL, 0x0000002400000012ULL,
0x00006fc0003f0106ULL, 0x00000000000000ffULL, 0x0000703000060107ULL, 0x0000000400000061ULL,
0x00007050003f0106ULL, 0x0000f63c00000016ULL, 0x00007130003f0106ULL, 0x0000f63c00000016ULL,
0x000075f0003f0106ULL, 0x0000f64c0000005eULL, 0x00007680003f0106ULL, 0x0000f64c0000005eULL,
0x00008580003f0106ULL, 0x0000002000000012ULL, 0x000085e0003f0101ULL, 0x0000f64000000016ULL,
0x0000d340003f0101ULL, 0x0000f604000000ffULL, 0x0000d3d0003f0106ULL, 0x0000f604000000ffULL,
0x0000d5f0003f0106ULL, 0x0000f600000000ffULL, 0x0000d600003f0101ULL, 0x0000f604000000ffULL,
0x0000d680003f0106ULL, 0x0000f604000000ffULL, 0x0000f5c0003f0106ULL, 0x0000f61400000037ULL,
0x0000f9b0003f0106ULL, 0x0000f61400000037ULL, 0x00010df0003f0106ULL, 0x0000f60800000037ULL,
0x00053803003f0101ULL, 0x0000c1d000141c04ULL, 0x0000d6d00000c620ULL, 0x00010e500000d7a0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff1d7624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000000137919ULL, 0x000ee80000002700ULL,
0x0000000000307919ULL, 0x000f220000002600ULL, 0x000000010e007824ULL, 0x002fc600078e0203ULL,
0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL, 0x00000080000f7824ULL, 0x104fe200078e0207ULL,
0x00000005ff447819ULL, 0x000fe20000011607ULL, 0x0000620013067625ULL, 0x008fc600078e0011ULL,
0x000000ff0f00720cULL, 0x040fe40003f05270ULL, 0x000000030f00780cULL, 0x040fe20003f44070ULL,
0x00001fff44447589ULL, 0x000ea200000e0000ULL, 0x0000007f0f00780cULL, 0x040fe40003f24070ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0e00720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f608040f00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6100a0f00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff009424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f648080f00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f400000f009388ULL, 0x0007e80000004800ULL,
0x00f6680c0f00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x01ce620000000000ULL,
0x0000000444037824ULL, 0x000fc400078e00ffULL, 0x000000101d007824ULL, 0x000fe400078e00ffULL,
0x0000001030027824ULL, 0x000fe400078e00ffULL, 0x00000100ff0a7424ULL, 0x000fe400078e00ffULL,
0x0000001300007224ULL, 0x000fe200078e0202ULL, 0x000000030d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d037824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x040fe200078e0209ULL, 0x0000000709047812ULL, 0x000fe400078ec0ffULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x000fe200078e020bULL,
0x000000f0030f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0002027625ULL, 0x080fe200078e000aULL,
0x0000000f04007812ULL, 0x100fe400078e780dULL, 0x0000000f08087812ULL, 0x000fe200078e780dULL,
0x00005c0005047625ULL, 0x000fe200078e000aULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009007824ULL, 0x000fe200078e0200ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b087824ULL, 0x000fe400078e0208ULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001000097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806007981ULL, 0x01cea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x00000004ff467e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f00027810ULL, 0x006fc40007ffe0ffULL,
0x000000ff00037810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff027819ULL, 0x000fe40000011602ULL,
0x00000008ff037819ULL, 0x000fca0000011603ULL, 0x0000c0d000008947ULL, 0x000fea0003800000ULL,
0x00000002ff047819ULL, 0x000fe20000011644ULL, 0x00000003ff0a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fe200078e00ffULL, 0x03ffffff04057812ULL, 0x000fca00078ec0ffULL,
0x00000004460b7824ULL, 0x000fca00078e0205ULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x0000000213058824ULL, 0x000fe400078e00ffULL, 0x00006400ff068624ULL, 0x000fc800078e00ffULL,
0x0000640005068624ULL, 0x000fe400078e0206ULL, 0x0000001044057824ULL, 0x000fe400078e00ffULL,
0x000000010b068824ULL, 0x000fe200078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140a05ff738cULL, 0x0003e20000000000ULL, 0x0000600006088625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000808108981ULL, 0x0004e2000c1e1900ULL,
0x00000300ff067624ULL, 0x000fe200078e00ffULL, 0x000000030b077812ULL, 0x000fe400078ec0ffULL,
0x00000001460e7810ULL, 0x000fe20007ffe0ffULL, 0xfffffffd11067424ULL, 0x000fe200078e0206ULL,
0x000000030700780cULL, 0x000fe20003f05270ULL, 0x00000080ff227424ULL, 0x000fe200078e00ffULL,
0x00f6100005ff7f8cULL, 0x0009e4000c80043fULL, 0x0000000106077807ULL, 0x000fe20004000000ULL,
0xffffffffff087424ULL, 0x004fc800078e00ffULL, 0x000000010b077824ULL, 0x000fe200078e0207ULL,
0x0000000000097919ULL, 0x000ea80000000000ULL, 0x000000020700720cULL, 0x000fda0003f06070ULL,
0x00000002130a8824ULL, 0x002fe400078e00ffULL, 0x00006400ff0b8624ULL, 0x000fc800078e00ffULL,
0x000064000a0a8624ULL, 0x000fc800078e020bULL, 0x000000010a0c8824ULL, 0x000fe200078e0207ULL,
0x00000001440a7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff147819ULL, 0x004fe20000011609ULL,
0x000060000c0c8625ULL, 0x000fc800078e0011ULL, 0x000000100a0f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011644ULL, 0x000000080c088981ULL, 0x000362000c1e1900ULL,
0x0000000414177810ULL, 0x000fe20007ffe0ffULL, 0x000000010f167824ULL, 0x040fe200078e0214ULL,
0x000000030e00720cULL, 0x000fe20003f06070ULL, 0x000000000b0473c2ULL, 0x000ea200000e0000ULL,
0x00000008141b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000816127824ULL, 0x040fe200078e00ffULL,
0x0000000916117212ULL, 0x080fe200078e3cffULL, 0x000000010f1a7824ULL, 0x000fe200078e0217ULL,
0x0000000c141e7810ULL, 0x000fe20007ffe0ffULL, 0x000000200b0c7824ULL, 0x002fe200078e00ffULL,
0xfffffff812157812ULL, 0x000fe200078ee211ULL, 0x000000081a127824ULL, 0x040fe200078e00ffULL,
0x000000091a0d7212ULL, 0x000fe200078e3cffULL, 0x0000010046117824ULL, 0x000fe200078e020cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000010f1c7824ULL, 0x040fe200078e021bULL,
0xfffffff812197812ULL, 0x000fe200078ee20dULL, 0x000000010f207824ULL, 0x000fe200078e021eULL,
0x00000011000e7217ULL, 0x000fe20007800000ULL, 0x000000081c127824ULL, 0x040fe200078e00ffULL,
0x000000091c0d7212ULL, 0x080fe200078e3cffULL, 0x0000000820237824ULL, 0x040fe200078e00ffULL,
0x0000000920187212ULL, 0x000fe200078e3cffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a11ULL,
0xfffffff812217812ULL, 0x000fe200078ee20dULL, 0x000020000b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x0000001009257824ULL, 0x000fe200078e00ffULL,
0x000000200e0e7807ULL, 0x000fe20000000000ULL, 0x0000f64804047891ULL, 0x004fe2000f8e203fULL,
0x0000b0000d187810ULL, 0x000fe20007ffe0ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000f0e127217ULL, 0x000fe20007800000ULL, 0x00000040300e7824ULL, 0x000fe200078e00ffULL,
0x0000007025257812ULL, 0x000fe200078ec0ffULL, 0x00000010191f7824ULL, 0x100fe200078e0218ULL,
0x0000003f1c197812ULL, 0x000fe200078ec0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a0fULL,
0x000000200e117812ULL, 0x000fe200078ef811ULL, 0x000000401d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000010151d7824ULL, 0x100fe200078e0218ULL,
0x000000121400720cULL, 0x080fe20003f46070ULL, 0x0000001023297824ULL, 0x100fe200078e0218ULL,
0x0000003f1a157812ULL, 0x000fe200078ec0ffULL, 0x0000001021217824ULL, 0x000fe200078e0218ULL,
0x0000003f20237812ULL, 0x000fe200078ec0ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000121700720cULL, 0x080fe20003f26070ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000121b00720cULL, 0x000fe20003f06070ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fc400078e00ffULL, 0x000000100f147224ULL, 0x008fe200078e0211ULL,
0x0000003f16117812ULL, 0x000fc600078ec0ffULL, 0x0000000114157824ULL, 0x040fe400078e0215ULL,
0x0000000114117824ULL, 0x040fe400078e0211ULL, 0x0000000114167824ULL, 0x000fe400078e0219ULL,
0x00005e0011107625ULL, 0x000fc800078e0022ULL, 0x0000000114187824ULL, 0x000fe200078e0223ULL,
0x00000025101a7210ULL, 0x000fe20007f7e0ffULL, 0x00005e0015147625ULL, 0x000fc800078e0022ULL,
0x00005e0016167625ULL, 0x000fe200078e0022ULL, 0x0000002514147210ULL, 0x000fc60007f9e0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0022ULL, 0x0000002516167210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e0611ULL, 0x000000121e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x0000002518187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1d7faeULL, 0x0009e2000d101c48ULL, 0xff317217ff107424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x00000000141f7faeULL, 0x0009e2000c901c48ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000f6480b127811ULL, 0x000fc400078e18ffULL, 0x0000000016217faeULL, 0x0009e2000c101c48ULL,
0x000000034600720cULL, 0x000fc60003f06070ULL, 0x0000000018297faeULL, 0x0009e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200012ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x010fe2000001ff00ULL,
0x0000780000000947ULL, 0x000fea0003800000ULL, 0x0000000213147824ULL, 0x002fe200078e00ffULL,
0x00007610ff497816ULL, 0x000fe20000000049ULL, 0x00006400ff137624ULL, 0x000fe200078e00ffULL,
0x00007610ff4a7816ULL, 0x000fe2000000004aULL, 0xff317217ff107424ULL, 0x000fc400078e00ffULL,
0x0000640014147624ULL, 0x000fe200078e0213ULL, 0x00007610ff137816ULL, 0x000fe20000000013ULL,
0x000000ffff487224ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0xffffffc005157812ULL, 0x000fca00078ec0ffULL, 0x0000010046157824ULL, 0x000fca00078e0215ULL,
0x000000001500720cULL, 0x000fda0003f06070ULL, 0x000076d000000947ULL, 0x002fea0003800000ULL,
0x0000240012167984ULL, 0x000e620000000800ULL, 0x0000ffff490b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6d7224ULL, 0x000fe400078e0007ULL, 0x000000ffff157224ULL, 0x000fe200078e0048ULL,
0x000088800b187816ULL, 0x000fca00000000ffULL, 0x80000000180b7824ULL, 0x000fca00078e00ffULL,
0x8000000016ff7812ULL, 0x002fe2000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000076104a6e7816ULL, 0x000fe4000000006eULL, 0x0000761049557816ULL, 0x000fe20000000055ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000240012167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000018197824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b00167305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe40003800000ULL,
0x0000240012167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000003070b7812ULL, 0x000fe200078ec0ffULL, 0x0000010046687824ULL, 0x000fc600078e00ffULL,
0x000000030b00780cULL, 0x000fe40003f05270ULL, 0x00000001ff0b7819ULL, 0x000fe40000011644ULL,
0x0000000106167807ULL, 0x000fca0004000000ULL, 0x0000000107077824ULL, 0x000fe400078e0216ULL,
0x000000200b167824ULL, 0x000fc600078e0268ULL, 0x000000020700720cULL, 0x000fe40003f06070ULL,
0x00000040161b7810ULL, 0x000fc80007ffe0ffULL, 0x000000200e167812ULL, 0x000fe400078ef81bULL,
0x00000003ff1c7819ULL, 0x000fc60000011609ULL, 0x0000000f081f7224ULL, 0x020fe400078e0216ULL,
0x0000000114188824ULL, 0x000fe400078e0207ULL, 0x00000004ff198424ULL, 0x000fe200078e00ffULL,
0x00000010051d7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff087424ULL, 0x000fe200078e00ffULL,
0x000000041c207810ULL, 0x000fe20007ffe0ffULL, 0x0000600018188625ULL, 0x000fe200078e0019ULL,
0x0000000146167810ULL, 0x000fc60007ffe0ffULL, 0x000000011c547824ULL, 0x100fe200078e021dULL,
0x0000000818088981ULL, 0x000362000c1e1900ULL, 0x000000031600720cULL, 0x000fe20003f06070ULL,
0x0000000120527824ULL, 0x000fe200078e021dULL, 0x0000001b00167217ULL, 0x000fe20007800000ULL,
0x00000008441a7824ULL, 0x000fe200078e00ffULL, 0x0000000954537212ULL, 0x080fe200078e3cffULL,
0x00000008521e7824ULL, 0x040fe200078e00ffULL, 0x0000000952517212ULL, 0x000fe200078e3cffULL,
0x0000000116167824ULL, 0x000fe200078e0a1bULL, 0x000000081c227810ULL, 0x000fe20007ffe0ffULL,
0x0000000854187824ULL, 0x042fe200078e00ffULL, 0x0000003f54547812ULL, 0x000fe200078ec0ffULL,
0x0000001009457824ULL, 0x000fe200078e00ffULL, 0xfffffff81e517812ULL, 0x000fe200078ee251ULL,
0x00000080ff1e7424ULL, 0x000fe200078e00ffULL, 0xfffffff818537812ULL, 0x000fe200078ee253ULL,
0x000000011f187824ULL, 0x000fe200078e0254ULL, 0xfffffff01a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000122507824ULL, 0x000fe200078e021dULL, 0x0000002016167807ULL, 0x000fe20000000000ULL,
0x0000000848217824ULL, 0x000fe200078e00ffULL, 0x000000001a0473c2ULL, 0x0002a200000e0000ULL,
0x00005e0018187625ULL, 0x000fe200078e001eULL, 0x0000007045237812ULL, 0x000fc400078ec0ffULL,
0x0000001d16167217ULL, 0x000fe40007800000ULL, 0x00000009504f7212ULL, 0x040fe200078e3cffULL,
0x00000008501a7824ULL, 0x002fe200078e00ffULL, 0x0000000c1c477810ULL, 0x000fe20007ffe0ffULL,
0x0000000116167824ULL, 0x100fe200078e0a1dULL, 0x00000008216b7812ULL, 0x000fe400078e0cffULL,
0x0000003f52527812ULL, 0x000fe200078ec0ffULL, 0x00000001474e7824ULL, 0x000fe200078e021dULL,
0x0000002318187210ULL, 0x000fe20007f1e0ffULL, 0x000000006b0573c2ULL, 0x000e6200000e0000ULL,
0xfffffff81a4f7812ULL, 0x000fe200078ee24fULL, 0x00001000481a7824ULL, 0x000fe200078e00ffULL,
0x000000094e4d7212ULL, 0x000fe200078e3cffULL, 0x000000011f1b7824ULL, 0x000fe200078e0252ULL,
0x0000003f50507812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x000000161c00720cULL, 0x000fe20003f06070ULL, 0x000000084e4c7824ULL, 0x000fe200078e00ffULL,
0x000010001a1c7812ULL, 0x000fe200078e0cffULL, 0x00005e001b1a7625ULL, 0x000fe200078e001eULL,
0x0000003f4e4e7812ULL, 0x000fe200078ec0ffULL, 0x0000f64804047890ULL, 0x004fe2000fffe03fULL,
0x000000162000720cULL, 0x080fe20003f26070ULL, 0x000000011f1d7824ULL, 0x040fe200078e0250ULL,
0x000000231a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e024eULL,
0x000000164700720cULL, 0x000fe20003f66070ULL, 0x000020000b207824ULL, 0x000fe200078e021cULL,
0xfffffff84c4d7812ULL, 0x000fe200078ee24dULL, 0x00005e001d1c7625ULL, 0x000fc600078e001eULL,
0x0000b00020207810ULL, 0x000fe20007ffe0ffULL, 0x00005e001f1e7625ULL, 0x000fe200078e001eULL,
0x000000231c1c7210ULL, 0x080fe20007f9e0ffULL, 0x0000000504057290ULL, 0x002fe4000fffe03fULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000162200720cULL, 0x000fe20003f46070ULL,
0x0000001053667824ULL, 0x100fe200078e0220ULL, 0x000000231e1e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001051657824ULL, 0x100fe400078e0220ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018667faeULL, 0x0003e2000c101c48ULL,
0x000000104f647824ULL, 0x000fc400078e0220ULL, 0x000000ffff1f7224ULL, 0x000fe200028e061fULL,
0x000000001a657faeULL, 0x0003e2000c901c48ULL, 0x000000104d637824ULL, 0x000fe400078e0220ULL,
0x0000000444167824ULL, 0x000fe200078e00ffULL, 0x000000001c647faeULL, 0x0003e8000d101c48ULL,
0x000000001e637faeULL, 0x0003e2000d901c48ULL, 0xfffffff016167812ULL, 0x000fc600078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000404211b7984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c00161a7984ULL, 0x000ee20000000800ULL,
0x0000ffff4a187812ULL, 0x000fe400078ec0ffULL, 0x0000ffff13197812ULL, 0x000fe400078ec0ffULL,
0x00008880181e7816ULL, 0x000fc400000000ffULL, 0x0000888019477816ULL, 0x000fc600000000ffULL,
0x800000001e187824ULL, 0x000fe400078e00ffULL, 0x8000000047197824ULL, 0x000fc600078e00ffULL,
0x800000001bff7812ULL, 0x004fe40007804818ULL, 0x800000001aff7812ULL, 0x008fe20007824819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000f60804197811ULL, 0x000fe200078e20ffULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000471b7824ULL, 0x000fe400078e00ffULL, 0x00000018001a7305ULL, 0x0004e4000021f000ULL,
0x3fa0000018187823ULL, 0x004fe200000100ffULL, 0x0000001a0000735dULL, 0x008fe40003800000ULL,
0x00000400191a7984ULL, 0x000ea40000000800ULL, 0x800000001aff7812ULL, 0x004fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff4c7819ULL, 0x000fe20000011609ULL, 0x00000001ff807424ULL, 0x000fe200078e00ffULL,
0x0000007045457812ULL, 0x000fe400078ec0ffULL, 0x0000000c4c4c7812ULL, 0x000fc600078ec0ffULL,
0x0000008004197824ULL, 0x000fc800078e0245ULL, 0x0000000119197824ULL, 0x000fca00078e024cULL,
0x00f00000191b7984ULL, 0x000ea80000000800ULL, 0x00f2000019187984ULL, 0x0007220000000800ULL,
0x000000101b00720bULL, 0x004fda0003f3d000ULL, 0x00000000001a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1a1f7812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000101b00720bULL, 0x018fe40003f34000ULL, 0x0000001b10207209ULL, 0x000fe40007810000ULL,
0x00000002ff1c7819ULL, 0x000fc60000011609ULL, 0x8000002010197221ULL, 0x000fe20000010000ULL,
0x000000081c1d7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b191a7820ULL, 0x000fe40000410000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x000000440400720cULL, 0x000fe40003f25270ULL,
0x0000ffff10107812ULL, 0x000fe200078e3cffULL, 0x0000001a001a7308ULL, 0x000ea60000000800ULL,
0x000000101fff7212ULL, 0x000fe2000784c0ffULL, 0x000000ffff107224ULL, 0x000fc600078e0020ULL,
0x00000001ff807807ULL, 0x000fc60001000000ULL, 0x0000008044199824ULL, 0x000fc800078e0245ULL,
0x000000014c199824ULL, 0x000fe200078e0219ULL, 0x00001f1d1a1d7589ULL, 0x004ea200000e0000ULL,
0x800000201b1b2221ULL, 0x000fe20000010000ULL, 0x0000001a11117220ULL, 0x000fe40000410000ULL,
0x00001f1c1a1c7589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b1b1b2820ULL, 0x000fc60000410000ULL,
0x00f4002019009388ULL, 0x0009e20000000800ULL, 0x0000001b00172308ULL, 0x000e620000000800ULL,
0x0000001d27277220ULL, 0x084fe20000410000ULL, 0x0000001d26267220ULL, 0x080fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d42427220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001d2a2a7220ULL, 0x000fe20000410000ULL,
0x0000001c25257220ULL, 0x088fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c28287220ULL, 0x000fe20000410000ULL,
0x0000001718182220ULL, 0x002fc80000410000ULL, 0x0000001118117221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000040421187984ULL, 0x000ea20008000800ULL,
0x800000001e197824ULL, 0x000fca00078e00ffULL, 0x8000000018ff7812ULL, 0x004fe20007804819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x0000040421197984ULL, 0x000ea40008000800ULL,
0x8000000019ff7812ULL, 0x004fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000004441a7824ULL, 0x040fe200078e00ffULL,
0x0000000809187812ULL, 0x000fe200078ec0ffULL, 0x0000100044197824ULL, 0x000fe200078e00ffULL,
0x00000002ff9a7819ULL, 0x000fe20000011609ULL, 0x0000100048567824ULL, 0x000fe200078e020dULL,
0x000000041a1a7812ULL, 0x000fe400078ec0ffULL, 0xffffe000191b7812ULL, 0x000fe400078ec0ffULL,
0x0000000718197812ULL, 0x000fe400078ec809ULL, 0x0000001a091a7211ULL, 0x000fe200078fe0ffULL,
0x00001000481b7824ULL, 0x000fe200078e021bULL, 0x0000000718187812ULL, 0x000fc400078ef809ULL,
0x0000001a196a7212ULL, 0x000fe400078e3cffULL, 0x0000b0001b1b7810ULL, 0x000fe40007ffe0ffULL,
0x0000008018697811ULL, 0x040fe200078e18ffULL, 0x00000008185c7824ULL, 0x000fe200078e026aULL,
0x0000b00056567810ULL, 0x000fe40007ffe0ffULL, 0x000000021a1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000105c1c7824ULL, 0x000fe400078e021bULL, 0x000000016a6a7824ULL, 0x000fc800078e0269ULL,
0x000000001c1c783bULL, 0x000ea20000004200ULL, 0x000000106a207824ULL, 0x000fcc00078e0256ULL,
0x000000002020783bULL, 0x002e620000004200ULL, 0x000001001c577824ULL, 0x044fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe2000001141cULL, 0x000001001d5b7824ULL, 0x000fe200078e00ffULL,
0x000088801c7a7816ULL, 0x000fe200000000ffULL, 0x000001001e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011457ULL, 0x000100001c577824ULL, 0x000fe200078e00ffULL,
0x0000001a191c7212ULL, 0x000fe200078e3cffULL, 0x0000009400947306ULL, 0x000fe20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fc4000001141dULL, 0x00000018ff957819ULL, 0x000fe20000011457ULL,
0x0000000818577824ULL, 0x000fe200078e021cULL, 0x000088801d777816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x002fe20000011420ULL,
0x00000010571b7824ULL, 0x000fe200078e021bULL, 0x0000888020797816ULL, 0x000fe200000000ffULL,
0x000000011c697824ULL, 0x000fe200078e0269ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe20000011421ULL,
0x000000001b18783bULL, 0x000e620000004200ULL, 0x0000888021747816ULL, 0x000fe200000000ffULL,
0x00000010691c7824ULL, 0x000fe200078e0256ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000010022567824ULL, 0x040fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011422ULL,
0x0000001d00967306ULL, 0x0005e20000200c00ULL, 0x0000888022727816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc4000001145dULL,
0x00000018ff597819ULL, 0x000fe40000011423ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000005b00987306ULL, 0x0007e20000200c00ULL, 0x00000100201d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001141eULL, 0x00000018ff787819ULL, 0x000fe2000001141dULL,
0x00000100211d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000005d005e7306ULL, 0x0005e20000200c00ULL,
0x000001001f5b7824ULL, 0x008fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fc4000001141fULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000002000767306ULL, 0x0007e20000200c00ULL, 0x00008880235d7816ULL, 0x004fe400000000ffULL,
0x000088801e937816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x000088801f5f7816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001141dULL, 0x0000002100737306ULL, 0x0005e20000200c00ULL,
0x0000010023207824ULL, 0x048fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x002fe20000011418ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x0000888018917816ULL, 0x000fe200000000ffULL,
0x000001001a817824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x00000022006f7306ULL, 0x0003e20000200c00ULL, 0x0000000244217824ULL, 0x004fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff857819ULL, 0x000fe40000011419ULL,
0x0000000421867812ULL, 0x000fe200078ec0ffULL, 0x0000010019217824ULL, 0x000fe200078e00ffULL,
0x0000002000707306ULL, 0x0005e20000200c00ULL, 0x0000010018227824ULL, 0x042fe200078e00ffULL,
0x0000008609867211ULL, 0x000fe200078fe0ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fc40000011421ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000005b007c7306ULL, 0x0003e20000200c00ULL, 0x0000000709207812ULL, 0x004fe400078ec0ffULL,
0x0000888019827816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x0000000820977812ULL, 0x000fe400078ef809ULL, 0x00000018ff8b7819ULL, 0x000fe20000011418ULL,
0x00000023006c7306ULL, 0x000fe20000200c00ULL, 0x0000000786207812ULL, 0x000fc400078e7897ULL,
0x00000017ff18723eULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000000897207824ULL, 0x000fe200078e0220ULL, 0x0000541018997816ULL, 0x000fe20000000018ULL,
0x00000022008e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff887819ULL, 0x000fe20000011481ULL,
0x00000010205b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x00001f9a99817589ULL, 0x0003e200000e0000ULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000080004207824ULL, 0x000fe200078e025bULL, 0x0000000286867810ULL, 0x000fe20007ffe0ffULL,
0x0000005600717306ULL, 0x0007e20000200c00ULL, 0x000001001b187824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc4000001141aULL, 0x009000002020783bULL, 0x004ea20000000200ULL,
0x000088801a897816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00000019008c7306ULL, 0x0009e20000200c00ULL,
0x000000089a567810ULL, 0x008fe40007ffe0ffULL, 0x00000007869a7812ULL, 0x002fe400078e7897ULL,
0x00000018ff7e7819ULL, 0x000fe4000001141bULL, 0x000088801b847816ULL, 0x000fe200000000ffULL,
0x0000001e00927306ULL, 0x000fe20000200c00ULL, 0x0000991080197816ULL, 0x010fe200000000ffULL,
0x00000008979a7824ULL, 0x000fe200078e029aULL, 0x00001f5699807589ULL, 0x000e6200000e0000ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000000ff1900720cULL, 0x000fc40003f05270ULL, 0x0000001f00907306ULL, 0x0007e40000200c00ULL,
0x00000018ff1b7819ULL, 0x000fcc000001141bULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000000001c1c783bULL, 0x008eee0000004200ULL, 0x0000007700777306ULL, 0x000f220000200c00ULL,
0x0000008120208232ULL, 0x084fe40000000000ULL, 0x0000008122228232ULL, 0x000fca0000000000ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000008021218232ULL, 0x082fe40000000000ULL,
0x0000008023238232ULL, 0x000fca0000000000ULL, 0x0000009500957306ULL, 0x000fe20000200c00ULL,
0x0000541077197816ULL, 0x010fe20000000098ULL, 0x000000109a777824ULL, 0x000fcc00078e00ffULL,
0x0000009300937306ULL, 0x000e700000200c00ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x00000018ff617819ULL, 0x008fe2000001141cULL, 0x000001001c977824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fc4000001141dULL, 0x00000018ff627819ULL, 0x000fe4000001141fULL,
0x00000018ff607819ULL, 0x000fe2000001141eULL, 0x0000001800877306ULL, 0x0007e20000200c00ULL,
0x00005410935e7816ULL, 0x002fe2000000005eULL, 0x000001001d937824ULL, 0x000fcc00078e00ffULL,
0x0000008d008d7306ULL, 0x000e620000200c00ULL, 0x000054107a187816ULL, 0x008fe40000000083ULL,
0x000054105f5f7816ULL, 0x004fe4000000007cULL, 0x000088801c7a7816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x000000182028723cULL, 0x000fe40000001828ULL, 0x00000018ff1c7819ULL, 0x000fca000001141cULL,
0x0000541095187816ULL, 0x000fe20000000094ULL, 0x0000001a00867306ULL, 0x0007e20000200c00ULL,
0x0000541096197816ULL, 0x000fe2000000007bULL, 0x0000005e2030723cULL, 0x000fe20000001830ULL,
0x000088801d947816ULL, 0x000fe400000000ffULL, 0x00000018ff7b7819ULL, 0x000fc60000011497ULL,
0x0000009100917306ULL, 0x000f220000200c00ULL, 0x00000800041a7824ULL, 0x008fe200078e0277ULL,
0x00000018202c723cULL, 0x040fe2000000182cULL, 0x00005410925e7816ULL, 0x002fe2000000008dULL,
0x000000ffff7c7224ULL, 0x000fe200078e0094ULL, 0x00005410905f7816ULL, 0x004fe4000000007dULL,
0x00000018ff7d7819ULL, 0x000fe20000011493ULL, 0x0000008200827306ULL, 0x000fe80000200c00ULL,
0x0000005e2034723cULL, 0x000fe80000001834ULL, 0x0000008f008f7306ULL, 0x000e660000200c00ULL,
0x00005410915e7816ULL, 0x010fca000000008eULL, 0x0000001b00837306ULL, 0x0005f00000200c00ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x009000001a18783bULL, 0x004ea20000000200ULL,
0x00005410825f7816ULL, 0x002fcc000000008fULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x0000005e2038723cULL, 0x000fee0000001838ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000100001d5e7824ULL, 0x000fce00078e00ffULL, 0x0000008400847306ULL, 0x000ee20000200c00ULL,
0x000054108c1d7816ULL, 0x002fe40000000085ULL, 0x000088801e857816ULL, 0x000fca00000000ffULL,
0x0000007f007f7306ULL, 0x000e700000200c00ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x00005410845f7816ULL, 0x008fe20000000087ULL, 0x0000008118188232ULL, 0x004fc40000000000ULL,
0x000000811a1a8232ULL, 0x000fe40000000000ULL, 0x0000008019198232ULL, 0x080fe40000000000ULL,
0x0000001c00827306ULL, 0x0005e20000200c00ULL, 0x000000801b1b8232ULL, 0x000fce0000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054108b1c7816ULL, 0x004fce000000008aULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x0000001c203c723cULL, 0x000fee000000183cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001145eULL,
0x00005410861c7816ULL, 0x002fca000000007fULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x00005410895e7816ULL, 0x004fce0000000088ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000005e2040723cULL, 0x000fee0000001840ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000001001e5f7824ULL, 0x040fe400078e00ffULL, 0x000100001e1e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff5e7224ULL, 0x000fc600078e0085ULL, 0x0000001d00847306ULL, 0x0007e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00005410831d7816ULL, 0x008fce000000007eULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x0000001c2024723cULL, 0x000fee0000001824ULL, 0x00005410791c7816ULL, 0x002fe20000000078ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00005410741d7816ULL, 0x004fc40000000075ULL,
0x000088801f207816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc6000001145fULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000001c1828723cULL, 0x000fee0000001828ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410731d7816ULL, 0x008fe2000000005aULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c005f7306ULL, 0x0005f00000200c00ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410761c7816ULL, 0x004fc4000000004bULL,
0x0000541082827816ULL, 0x002fca0000000061ULL, 0x0000001c182c723cULL, 0x040fe2000000182cULL,
0x0000007b007b7306ULL, 0x000e6c0000200c00ULL, 0x00005410721c7816ULL, 0x000fe40000000071ULL,
0x000054105d1d7816ULL, 0x000fe20000000070ULL, 0x0000005800587306ULL, 0x000eac0000200c00ULL,
0x0000001c1830723cULL, 0x000fe20000001830ULL, 0x000054107a7a7816ULL, 0x002fe2000000007bULL,
0x0000005900597306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x000054106f587816ULL, 0x004fce0000000058ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054106c597816ULL, 0x002fce0000000059ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541084837816ULL, 0x008fe20000000067ULL, 0x000000581834723cULL, 0x040fec0000001834ULL,
0x0000007c007c7306ULL, 0x000fe40000200c00ULL, 0x00000082183c723cULL, 0x000fec000000183cULL,
0x0000007d007d7306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ff00000200c00ULL,
0x0000002100217306ULL, 0x000ea20000200c00ULL, 0x000054107c7b7816ULL, 0x002fce000000007dULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0000007a1838723cULL, 0x000fee0000001838ULL,
0x0000001e001d7306ULL, 0x000ee20000200c00ULL, 0x000054105e5e7816ULL, 0x004fce0000000021ULL,
0x0000001f001f7306ULL, 0x000ea20000200c00ULL, 0x000054105f5f7816ULL, 0x002fe40000000020ULL,
0x000054101d607816ULL, 0x008fca0000000060ULL, 0x0000005e1840723cULL, 0x000fe20000001840ULL,
0x000054101f617816ULL, 0x004fcc0000000062ULL, 0x00000100465f7824ULL, 0x000fe200078e00ffULL,
0x000000601824723cULL, 0x000fee0000001824ULL, 0x0000f61004187811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x0000200012ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004004197824ULL, 0x000fe200078e025fULL,
0x000000ff4aff7812ULL, 0x000fe2000782c0ffULL, 0x0000000018ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff49ff7812ULL, 0x000fc4000784c0ffULL, 0x0000004019197810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff597807ULL, 0x000fe40000800000ULL, 0x000000001900720cULL, 0x000fe40003f26070ULL,
0x000000014800780cULL, 0x040fe40003f05270ULL, 0x00000001ff677807ULL, 0x000fe40001000000ULL,
0x0000000148487812ULL, 0x000fc400078e0cffULL, 0x0000004a594a7207ULL, 0x000fe40004000000ULL,
0x0000761067497816ULL, 0x000fc60000000049ULL, 0x000055b000001947ULL, 0x000fea0003800000ULL,
0x0000240012187984ULL, 0x004ea20000000800ULL, 0x8000000067077824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x004fe20007824807ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000240012187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fe40007824807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff077424ULL, 0x000fe400078e00ffULL,
0x8000000067187824ULL, 0x000fe400078e00ffULL, 0x00000007000b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000007077823ULL, 0x004fe200000100ffULL, 0x0000000b0000735dULL, 0x008fe40003800000ULL,
0x00002400120b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fc40007824818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000036d077812ULL, 0x000fe400078ec0ffULL, 0x00000001ff0b7819ULL, 0x000fe40000011644ULL,
0x000000030700780cULL, 0x000fc60003f25270ULL, 0x000000200b1b7824ULL, 0x000fe200078e0268ULL,
0x0000000106187807ULL, 0x000fc80004800000ULL, 0x000000801b1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000016d6d7824ULL, 0x000fc600078e0218ULL, 0x000000200e187812ULL, 0x000fe400078ef81bULL,
0x000000036d077812ULL, 0x000fc600078ec0ffULL, 0x0000000f081d7224ULL, 0x020fe200078e0218ULL,
0x000000030700780cULL, 0x000fe20003f25270ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x00000001066c7807ULL, 0x000fca0004800000ULL, 0x000000016d077824ULL, 0x000fca00078e026cULL,
0x000000020700720cULL, 0x000fe40003f26070ULL, 0x00000001461c7810ULL, 0x000fd60007ffe0ffULL,
0x0000006c14199210ULL, 0x000fe20007ffe06dULL, 0x00000004ff1a9424ULL, 0x000fc800078e00ffULL,
0x0000600019189625ULL, 0x000fe200078e001aULL, 0x0000001b001a7217ULL, 0x000fc80007800000ULL,
0x0000000818089981ULL, 0x000562000c1e1900ULL, 0x000000011a1a7824ULL, 0x000fe200078e0a1bULL,
0x000000031c00720cULL, 0x000fe20003f26070ULL, 0x00000008445e7824ULL, 0x000fe200078e00ffULL,
0x00000010051b7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff497424ULL, 0x000fe200078e00ffULL,
0x000000201a1a7807ULL, 0x000fe20000800000ULL, 0x000000014e1e7824ULL, 0x100fe200078e021dULL,
0x0000000115627812ULL, 0x000fe400078ec0ffULL, 0xfffffff05e5e7812ULL, 0x000fe200078ec0ffULL,
0x0000000154187824ULL, 0x004fe200078e021dULL, 0x0000001a1b1a7217ULL, 0x000fe20007800000ULL,
0x00000008621c7824ULL, 0x000fe200078e00ffULL, 0x0000f6485e487810ULL, 0x000fe20007ffe0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0049ULL, 0x00000003ff217819ULL, 0x000fe20000011609ULL,
0x000000001c0773c2ULL, 0x0004e200000e0000ULL, 0x000000081c617812ULL, 0x000fe200078e3cffULL,
0x000000011a207824ULL, 0x000fe200078e0a1bULL, 0x0000004518187210ULL, 0x000fe20007f3e0ffULL,
0x00000001521a7824ULL, 0x000fe200078e021dULL, 0x0000000821237810ULL, 0x000fe20007ffe0ffULL,
0x000000020b227824ULL, 0x000fe200078e0262ULL, 0x00000004211f7810ULL, 0x040fe20007ffe0ffULL,
0x00000000480673c2ULL, 0x000ee200000e0000ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0049ULL,
0x000000202100720cULL, 0x000fc40003f46070ULL, 0x0000b00022227811ULL, 0x000fe200078e60ffULL,
0x00000001501c7824ULL, 0x004fe200078e021dULL, 0x000000451a1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000201f00720cULL, 0x000fe20003f26070ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0049ULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x000000451c1c7210ULL, 0x000fe20007f9e0ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e0049ULL,
0x000000202300720cULL, 0x080fe40003f66070ULL, 0x0000000c21237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x000000451e1e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001053217824ULL, 0x100fe200078e0222ULL, 0x000000202300720cULL, 0x000fe20003f86070ULL,
0x0000001051237824ULL, 0x100fe200078e0222ULL, 0x0000000706067290ULL, 0x008fe2000fffe03fULL,
0x000000104f497824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0005e2000d101c48ULL, 0x000000ffff1f7224ULL, 0x000fc400028e061fULL,
0x000000104d4b7824ULL, 0x000fe200078e0222ULL, 0x000000001a237faeULL, 0x0005e2000c901c48ULL,
0x0000000148617824ULL, 0x000fc600078e0261ULL, 0x000000001c497faeULL, 0x0005e8000d901c48ULL,
0x000000001e4b7faeULL, 0x0005e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040061197984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c00161a7984ULL, 0x000f220000000800ULL, 0x0000006e596e7207ULL, 0x000fe20004000000ULL,
0x80000000471b7824ULL, 0x000fc600078e00ffULL, 0x0000ffff6e187812ULL, 0x000fc800078ec0ffULL,
0x00008880181f7816ULL, 0x000fca00000000ffULL, 0x800000001f187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x008fe40007804818ULL, 0x800000001aff7812ULL, 0x010fe2000782481bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x0000000444167824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000471a7824ULL, 0x000fe200078e00ffULL, 0xfffffff016167812ULL, 0x000fe400078ec0ffULL,
0x0000001800197305ULL, 0x000724000021f000ULL, 0x3fa0000018187823ULL, 0x008fe200000100ffULL,
0x000000190000735dULL, 0x010fe40003800000ULL, 0x00f61c0016197984ULL, 0x000ee40000000800ULL,
0x8000000019ff7812ULL, 0x008fc4000782481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000002044187824ULL, 0x000fe400078e00ffULL,
0x00000001ff787424ULL, 0x000fc600078e00ffULL, 0xffffff8018187812ULL, 0x000fc800078ec0ffULL,
0x0000008045197810ULL, 0x000fca0007ffe018ULL, 0x000000014c197824ULL, 0x000fca00078e0219ULL,
0x00f00000191b7984ULL, 0x000ee80000000800ULL, 0x00f2000019187984ULL, 0x0008620000000800ULL,
0x000000101b00720bULL, 0x008fda0003f3d000ULL, 0x00000000001a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1a1e7812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000101b00720bULL, 0x012fe40003f34000ULL, 0x0000001b101c7209ULL, 0x000fe40007810000ULL,
0x00000002ff207819ULL, 0x000fc60000011609ULL, 0x8000001c10197221ULL, 0x040fe20000010000ULL,
0x0000001b10107209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b191d7820ULL, 0x000fe20000410000ULL,
0x0000000104197810ULL, 0x000fe40007ffe0ffULL, 0x00000000001a7806ULL, 0x000fe400008e0100ULL,
0x000000441900720cULL, 0x000fe20003f25270ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000ffff1a217812ULL, 0x000fc800078e3cffULL, 0x000000211eff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff787807ULL, 0x000fc60001000000ULL, 0x0000008044219824ULL, 0x000fc800078e0245ULL,
0x000000014c219824ULL, 0x000fe200078e0221ULL, 0x00001f201d197589ULL, 0x002e6200000e0000ULL,
0x8000001c1b1e2221ULL, 0x000fe20000010000ULL, 0x0000001d11117220ULL, 0x000fe40000410000ULL,
0x00001f561d1a7589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b1e1e2820ULL, 0x000fc60000410000ULL,
0x00f4001c21009388ULL, 0x0009e20000000800ULL, 0x0000001e00172308ULL, 0x000ea20000000800ULL,
0x0000001928287220ULL, 0x082fe20000410000ULL, 0x0000001929297220ULL, 0x080fe20000410000ULL,
0x000000192c2c7220ULL, 0x080fe20000410000ULL, 0x000000192d2d7220ULL, 0x080fe20000410000ULL,
0x0000001930307220ULL, 0x080fe20000410000ULL, 0x0000001931317220ULL, 0x080fe20000410000ULL,
0x0000001934347220ULL, 0x080fe20000410000ULL, 0x0000001935357220ULL, 0x080fe20000410000ULL,
0x0000001938387220ULL, 0x080fe20000410000ULL, 0x0000001939397220ULL, 0x080fe20000410000ULL,
0x000000193c3c7220ULL, 0x080fe20000410000ULL, 0x000000193d3d7220ULL, 0x080fe20000410000ULL,
0x0000001940407220ULL, 0x080fe20000410000ULL, 0x0000001941417220ULL, 0x080fe20000410000ULL,
0x0000001924247220ULL, 0x080fe20000410000ULL, 0x0000001925257220ULL, 0x000fe20000410000ULL,
0x0000001a2a2a7220ULL, 0x088fe20000410000ULL, 0x0000001a2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001a2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001a2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001a32327220ULL, 0x080fe20000410000ULL, 0x0000001a33337220ULL, 0x080fe20000410000ULL,
0x0000001a36367220ULL, 0x080fe20000410000ULL, 0x0000001a37377220ULL, 0x080fe20000410000ULL,
0x0000001a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001a42427220ULL, 0x080fe20000410000ULL, 0x0000001a43437220ULL, 0x080fe20000410000ULL,
0x0000001a26267220ULL, 0x080fe20000410000ULL, 0x0000001a27277220ULL, 0x000fe20000410000ULL,
0x0000001817182220ULL, 0x004fc80000410000ULL, 0x0000001118117221ULL, 0x012fe20000010000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x0000000862187824ULL, 0x000fca00078e00ffULL,
0x0000000818197812ULL, 0x000fca00078e3cffULL, 0x000000015e1a7824ULL, 0x000fe400078e0219ULL,
0x800000001f197824ULL, 0x000fc600078e00ffULL, 0x00f64c001a187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001f1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0002e4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x008fe40003800000ULL,
0x00f64c001a197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000100015187824ULL, 0x000fe200078e00ffULL, 0x00000002ff897819ULL, 0x000fe20000011609ULL,
0x0000100044197824ULL, 0x000fc600078e00ffULL, 0x0000100018187812ULL, 0x000fe400078e0cffULL,
0xffffe00019197812ULL, 0x000fe400078ec0ffULL, 0x0000b0000d597810ULL, 0x100fe40007ffe018ULL,
0x0000b000195d7810ULL, 0x000fc60007ffe018ULL, 0x000000106a5a7824ULL, 0x000fe400078e0259ULL,
0x000000105c607824ULL, 0x100fe400078e025dULL, 0x00000010575d7824ULL, 0x000fe200078e025dULL,
0x000000005a18783bULL, 0x000e620000004200ULL, 0x0000001069597824ULL, 0x000fc600078e0259ULL,
0x000000006020783bULL, 0x000ee80000004200ULL, 0x000000005d48783bULL, 0x000f280000004200ULL,
0x00000000591c783bULL, 0x000ea20000004200ULL, 0x00000018ff757819ULL, 0x002fe40000011419ULL,
0x00008880197d7816ULL, 0x000fc400000000ffULL, 0x00000018ff9d7819ULL, 0x008fe20000011420ULL,
0x0000010020587824ULL, 0x040fe200078e00ffULL, 0x0000888020a07816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011421ULL,
0x0000010021797824ULL, 0x040fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011458ULL,
0x0000009d009d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000888021587816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x010fc40000011448ULL, 0x0000888048967816ULL, 0x000fe200000000ffULL,
0x00000020009e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff977819ULL, 0x000fe40000011422ULL,
0x00000018ff877819ULL, 0x000fe20000011423ULL, 0x00000021009f7306ULL, 0x0007e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00008880229c7816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888023847816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000007900a17306ULL, 0x0003e20000200c00ULL,
0x0000010049217824ULL, 0x008fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff8c7819ULL, 0x000fe40000011449ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020009b7306ULL, 0x0007e20000200c00ULL, 0x0000010023797824ULL, 0x002fe200078e00ffULL,
0x00008880498b7816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011418ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x0000888018817816ULL, 0x000fc400000000ffULL, 0x0000002100947306ULL, 0x0003e20000200c00ULL,
0x0000010048207824ULL, 0x048fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000001004b217824ULL, 0x002fe200078e00ffULL, 0x0000002000957306ULL, 0x0003e20000200c00ULL,
0x00000018ff797819ULL, 0x000fc40000011479ULL, 0x00000018ff837819ULL, 0x000fe4000001144bULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x000088804b8a7816ULL, 0x040fe200000000ffULL,
0x0000004800927306ULL, 0x0007e20000200c00ULL, 0x000001004a207824ULL, 0x002fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe2000001141aULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x000088801a7b7816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x00000022009a7306ULL, 0x000fe20000200c00ULL, 0x0000020044487824ULL, 0x008fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff857819ULL, 0x000fe4000001144aULL,
0xfffff80048487812ULL, 0x000fe400078ec0ffULL, 0x00000020008f7306ULL, 0x0003e20000200c00ULL,
0x000088804a907816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe2000001141bULL, 0x000000015b5b7824ULL, 0x000fe200078e0248ULL,
0x00000018ff727819ULL, 0x004fc4000001141cULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000002300987306ULL, 0x000fe20000200c00ULL, 0x0000010018207824ULL, 0x042fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001141dULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe4000001141eULL, 0x00000018ff807819ULL, 0x000fe20000011420ULL,
0x0000010019207824ULL, 0x040fe200078e00ffULL, 0x00000021008d7306ULL, 0x0003e20000200c00ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff7e7819ULL, 0x000fe40000011420ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000004900937306ULL, 0x0005e20000200c00ULL, 0x009800005b20783bULL, 0x002fe20000000200ULL,
0x00000018ff6f7819ULL, 0x000fcc000001141fULL, 0x00000019007c7306ULL, 0x0003e20000200c00ULL,
0x00000017ff49723eULL, 0x004fce00000000ffULL, 0x00000018007f7306ULL, 0x0005e20000200c00ULL,
0x0000541049197816ULL, 0x002fe20000000049ULL, 0x000001001a497824ULL, 0x040fe400078e00ffULL,
0x000100001a1a7824ULL, 0x000fe400078e00ffULL, 0x00001f8919897589ULL, 0x000e6200000e0000ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000000a000a07306ULL, 0x000fe20000200c00ULL,
0x0000991078187816ULL, 0x004fe200000000ffULL, 0x00001f5619867589ULL, 0x000ea200000e0000ULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x000000ff1800720cULL, 0x000fe20003f05270ULL,
0x000001001b187824ULL, 0x000fe400078e00ffULL, 0x000000a300a37306ULL, 0x000fe60000200c00ULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x0000005800587306ULL, 0x000ee40000200c00ULL,
0x0000008920208232ULL, 0x002fcc0000000000ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x0000008922228232ULL, 0x000fe40000000000ULL, 0x0000008621218232ULL, 0x084fe40000000000ULL,
0x0000008623238232ULL, 0x000fc60000000000ULL, 0x0000009c009c7306ULL, 0x000e620000200c00ULL,
0x0000541058197816ULL, 0x008fe200000000a1ULL, 0x0000000177587824ULL, 0x000fcc00078e0248ULL,
0x0000008400847306ULL, 0x000ff00000200c00ULL, 0x0000007900997306ULL, 0x000ea20000200c00ULL,
0x000054109c487816ULL, 0x002fce000000009bULL, 0x0000001800787306ULL, 0x0003f00000200c00ULL,
0x0000009700977306ULL, 0x000ee20000200c00ULL, 0x00005410a0187816ULL, 0x002fce00000000a3ULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000000182028723cULL, 0x000fee0000001828ULL,
0x0000004b00887306ULL, 0x0009e20000200c00ULL, 0x000054109e187816ULL, 0x000fe4000000009dULL,
0x000054109f197816ULL, 0x000fc40000000082ULL, 0x000088801d9d7816ULL, 0x000fc600000000ffULL,
0x00000049007a7306ULL, 0x0003e20000200c00ULL, 0x000088801b4b7816ULL, 0x050fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018202c723cULL, 0x000fe8000000182cULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0000001a00797306ULL, 0x0009e20000200c00ULL,
0x000088801c497816ULL, 0x002fce00000000ffULL, 0x0000004900777306ULL, 0x0005e20000200c00ULL,
0x000001001c1a7824ULL, 0x050fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff827819ULL, 0x000fe4000001141aULL, 0x0000009600967306ULL, 0x000e620000200c00ULL,
0x0000541084497816ULL, 0x004fe20000000099ULL, 0x000001001d997824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000000ffff847224ULL, 0x000fc800078e009dULL,
0x0000008b008b7306ULL, 0x000ea20000200c00ULL, 0x000000482030723cULL, 0x000fee0000001830ULL,
0x0000004a008e7306ULL, 0x000fe20000200c00ULL, 0x000054109a487816ULL, 0x008fe40000000097ULL,
0x0000541098497816ULL, 0x000fc40000000087ULL, 0x00000018ff877819ULL, 0x000fc60000011499ULL,
0x0000001b004a7306ULL, 0x0007e40000200c00ULL, 0x000000482034723cULL, 0x000fec0000001834ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x009800005818783bULL, 0x008ee20000000200ULL,
0x0000541096487816ULL, 0x002fc40000000095ULL, 0x000054108b497816ULL, 0x004fc80000000094ULL,
0x0000008c008c7306ULL, 0x000e660000200c00ULL, 0x000000482038723cULL, 0x000fea0000001838ULL,
0x0000008a008a7306ULL, 0x000ea40000200c00ULL, 0x000100001d487824ULL, 0x000fcc00078e00ffULL,
0x0000008500857306ULL, 0x000f220000200c00ULL, 0x00005410931d7816ULL, 0x002fe4000000008cULL,
0x000088801e8c7816ULL, 0x000fca00000000ffULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000054108a497816ULL, 0x004fce000000008dULL, 0x0000001c008b7306ULL, 0x0003e20000200c00ULL,
0x0000008918188232ULL, 0x088fe40000000000ULL, 0x000000891a1a8232ULL, 0x000fe40000000000ULL,
0x0000008619198232ULL, 0x080fe40000000000ULL, 0x000000861b1b8232ULL, 0x000fe20000000000ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x00005410921c7816ULL, 0x002fce0000000091ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000001c203c723cULL, 0x000fee000000183cULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe40000011448ULL,
0x000054108e1c7816ULL, 0x010fc40000000085ULL, 0x0000541090487816ULL, 0x004fc6000000008fULL,
0x0000007d007d7306ULL, 0x000fe80000200c00ULL, 0x000000482040723cULL, 0x000fe80000001840ULL,
0x0000007e007e7306ULL, 0x000ea60000200c00ULL, 0x000001001e497824ULL, 0x000fc400078e00ffULL,
0x000100001e1e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff487224ULL, 0x000fe200078e008cULL,
0x0000001d008a7306ULL, 0x0007e40000200c00ULL, 0x00000018ff1e7819ULL, 0x000fcc000001141eULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x00005410881d7816ULL, 0x008fce0000000083ULL,
0x0000007500757306ULL, 0x000ee20000200c00ULL, 0x0000001c2024723cULL, 0x000fee0000001824ULL,
0x00005410811c7816ULL, 0x002fe20000000080ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x000054107d1d7816ULL, 0x004fc4000000007eULL, 0x000088801f207816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fc60000011449ULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x0000001c1828723cULL, 0x000fee0000001828ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0020ULL,
0x000054107c1d7816ULL, 0x008fe20000000075ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000001001f207824ULL, 0x000fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000001c00227306ULL, 0x0007f00000200c00ULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x000054107f1c7816ULL, 0x008fce0000000076ULL, 0x0000001c182c723cULL, 0x040fe2000000182cULL,
0x0000008200827306ULL, 0x000eec0000200c00ULL, 0x000054107b1c7816ULL, 0x002fe4000000007aULL,
0x000054104b1d7816ULL, 0x004fe20000000078ULL, 0x0000008400847306ULL, 0x000fec0000200c00ULL,
0x0000001c1830723cULL, 0x000fe40000001830ULL, 0x0000008700877306ULL, 0x000e6a0000200c00ULL,
0x000100001f1c7824ULL, 0x000fe200078e00ffULL, 0x000054104a1d7816ULL, 0x010fc40000000073ULL,
0x0000007200727306ULL, 0x000ea40000200c00ULL, 0x00000018ff497819ULL, 0x000fe4000001141cULL,
0x00005410791c7816ULL, 0x000fc80000000074ULL, 0x0000007100717306ULL, 0x000f260000200c00ULL,
0x0000001c1834723cULL, 0x000fea0000001834ULL, 0x0000002000237306ULL, 0x000ea40000200c00ULL,
0x00005410771c7816ULL, 0x008fc40000000082ULL, 0x00005410841d7816ULL, 0x002fc80000000087ULL,
0x0000007000707306ULL, 0x000fe60000200c00ULL, 0x0000001c1838723cULL, 0x000fea0000001838ULL,
0x0000006f006f7306ULL, 0x000fe40000200c00ULL, 0x000054108b1c7816ULL, 0x004fc40000000072ULL,
0x000054108a1d7816ULL, 0x010fc80000000071ULL, 0x0000004800487306ULL, 0x000fe60000200c00ULL,
0x0000001c183c723cULL, 0x000fea000000183cULL, 0x0000002100217306ULL, 0x000e640000200c00ULL,
0x00005410221d7816ULL, 0x000fcc0000000023ULL, 0x0000001e001f7306ULL, 0x000eb00000200c00ULL,
0x0000004900207306ULL, 0x000ee20000200c00ULL, 0x00005410481c7816ULL, 0x002fe40000000021ULL,
0x000054101f707816ULL, 0x004fca0000000070ULL, 0x0000001c1840723cULL, 0x000fe20000001840ULL,
0x0000541020717816ULL, 0x008fce000000006fULL, 0x000000701824723cULL, 0x000fee0000001824ULL,
0x0000f62004187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200012ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000446197824ULL, 0x000fe200078e0204ULL, 0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff55ff7812ULL, 0x000fc4000782c0ffULL,
0x0000008019197811ULL, 0x000fe400078e30ffULL, 0x00000001ff6f7807ULL, 0x000fe40001000000ULL,
0x000000001900720cULL, 0x000fe40003f46070ULL, 0x0000000115487812ULL, 0x000fe4000780c0ffULL,
0x00000001ff497807ULL, 0x000fe40004800000ULL, 0x0000006e6f4a7207ULL, 0x000fce0004000000ULL,
0x000037e000002947ULL, 0x000fea0003800000ULL, 0x0000240012187984ULL, 0x004ea20000000800ULL,
0x00000001ff0b7807ULL, 0x000fca0004800000ULL, 0x800000000b077824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x004fe20007844807ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x0000240012187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fe40007844807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000000b187824ULL, 0x000fe400078e00ffULL,
0x3e000000ff077424ULL, 0x000fc800078e00ffULL, 0x00000007000b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000007077823ULL, 0x004fe200000100ffULL, 0x0000000b0000735dULL, 0x008fe40003800000ULL,
0x00002400120b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fc40007844818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000016d6c7824ULL, 0x000fe200078e026cULL, 0x00000001ff0b7819ULL, 0x000fc80000011644ULL,
0x000000036c077812ULL, 0x000fe200078ec0ffULL, 0x000000200b1b7824ULL, 0x000fc600078e0268ULL,
0x000000030700780cULL, 0x000fe40003f45270ULL, 0x000000c01b1b7810ULL, 0x000fe40007ffe0ffULL,
0x00000001066d7807ULL, 0x000fe40005000000ULL, 0x000000200e187812ULL, 0x000fc600078ef81bULL,
0x000000016c077824ULL, 0x000fe400078e026dULL, 0x0000000f081d7224ULL, 0x020fe400078e0218ULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x000000020700720cULL, 0x000fe40003f46070ULL,
0x00000001461c7810ULL, 0x000fd60007ffe0ffULL, 0x000000011419a824ULL, 0x000fe400078e0207ULL,
0x00000004ff1aa424ULL, 0x000fc800078e00ffULL, 0x000060001918a625ULL, 0x000fe200078e001aULL,
0x0000001b001a7217ULL, 0x000fc80007800000ULL, 0x000000081808a981ULL, 0x000562000c1e1900ULL,
0x000000011a1a7824ULL, 0x000fe200078e0a1bULL, 0x000000031c00720cULL, 0x000fe20003f46070ULL,
0x00000080ff227424ULL, 0x000fe200078e00ffULL, 0x00000010051f7812ULL, 0x000fe200078ec0ffULL,
0x00000001541b7824ULL, 0x100fe200078e021dULL, 0x000000201a1a7807ULL, 0x000fe20001000000ULL,
0x00000001521e7824ULL, 0x000fe200078e021dULL, 0x00000003ff217819ULL, 0x000fe40000011609ULL,
0x0000001a1f1c7217ULL, 0x000fe20007800000ULL, 0x00005e001b1a7625ULL, 0x000fe200078e0022ULL,
0x0000000421237810ULL, 0x000fc60007ffe0ffULL, 0x00005e001e187625ULL, 0x004fe200078e0022ULL,
0x000000451a1a7210ULL, 0x000fc60007f5e0ffULL, 0x00000001501e7824ULL, 0x100fe200078e021dULL,
0x0000004518187210ULL, 0x000fe20007f7e0ffULL, 0x000000014e1d7824ULL, 0x000fe400078e021dULL,
0x000000011c207824ULL, 0x000fe400078e0a1fULL, 0x00005e001e1e7625ULL, 0x000fc800078e0022ULL,
0x00005e001d1c7625ULL, 0x000fe200078e0022ULL, 0x000000451e1e7210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000202300720cULL, 0x080fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x000000451c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x0000000821237810ULL, 0x040fe40007ffe0ffULL,
0x000000202100720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000000c21217810ULL, 0x000fe40007ffe0ffULL, 0x000000202300720cULL, 0x000fc40003f86070ULL,
0x000000202100720cULL, 0x000fce0003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a667faeULL, 0x0005e8000d901c48ULL, 0x0000000018657faeULL, 0x0005e8000d101c48ULL,
0x000000001e647faeULL, 0x0005e8000e101c48ULL, 0x000000001c637faeULL, 0x0005e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000406ff197984ULL, 0x004ea20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f62c00161a7984ULL, 0x000ee20000000800ULL,
0x0000006e6f6e7207ULL, 0x000fe20004000000ULL, 0x80000000471b7824ULL, 0x000fc600078e00ffULL,
0x0000ffff6e187812ULL, 0x000fc800078ec0ffULL, 0x00008880181f7816ULL, 0x000fca00000000ffULL,
0x800000001f187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x004fe40007844818ULL,
0x800000001aff7812ULL, 0x008fe2000786481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x0000000444167824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000471a7824ULL, 0x000fe200078e00ffULL,
0xfffffff016167812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x0004e4000021f000ULL,
0x3fa0000018187823ULL, 0x004fe200000100ffULL, 0x000000190000735dULL, 0x008fe40003800000ULL,
0x00f62c0016197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fc4000786481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000002044187824ULL, 0x000fe400078e00ffULL, 0x00000001ff807424ULL, 0x000fc600078e00ffULL,
0xffffff8018187812ULL, 0x000fc800078ec0ffULL, 0x0000010045197810ULL, 0x000fca0007ffe018ULL,
0x000000014c197824ULL, 0x000fca00078e0219ULL, 0x00f00000191b7984ULL, 0x000ea80000000800ULL,
0x00f2000019187984ULL, 0x0007220000000800ULL, 0x000000101b00720bULL, 0x004fda0003f7d000ULL,
0x00000000001a7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1a1e7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000101b00720bULL, 0x018fe40003f74000ULL,
0x0000001b101c7209ULL, 0x000fe40007810000ULL, 0x00000002ff207819ULL, 0x000fc60000011609ULL,
0x8000001c10197221ULL, 0x040fe20000010000ULL, 0x0000001b10107209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b191d7820ULL, 0x000fe20000410000ULL, 0x0000000204197810ULL, 0x000fe40007ffe0ffULL,
0x00000000001a7806ULL, 0x000fe400018e0100ULL, 0x000000441900720cULL, 0x000fe20003f65270ULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000ffff1a217812ULL, 0x000fc800078e3cffULL,
0x000000211eff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff807807ULL, 0x000fc60002000000ULL,
0x000000804421b824ULL, 0x000fc800078e0245ULL, 0x000000014c21b824ULL, 0x000fe200078e0221ULL,
0x00001f201d197589ULL, 0x004ea200000e0000ULL, 0x8000001c1b1e4221ULL, 0x000fe20000010000ULL,
0x0000001d11117220ULL, 0x000fe40000410000ULL, 0x00001f561d1a7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1e1e4820ULL, 0x000fc60000410000ULL, 0x00f4001c2100b388ULL, 0x0009e20000000800ULL,
0x0000001e00174308ULL, 0x000e620000000800ULL, 0x0000001928287220ULL, 0x084fe20000410000ULL,
0x0000001929297220ULL, 0x080fe20000410000ULL, 0x000000192c2c7220ULL, 0x080fe20000410000ULL,
0x000000192d2d7220ULL, 0x080fe20000410000ULL, 0x0000001930307220ULL, 0x080fe20000410000ULL,
0x0000001931317220ULL, 0x080fe20000410000ULL, 0x0000001934347220ULL, 0x080fe20000410000ULL,
0x0000001935357220ULL, 0x080fe20000410000ULL, 0x0000001938387220ULL, 0x080fe20000410000ULL,
0x0000001939397220ULL, 0x080fe20000410000ULL, 0x000000193c3c7220ULL, 0x080fe20000410000ULL,
0x000000193d3d7220ULL, 0x080fe20000410000ULL, 0x0000001940407220ULL, 0x080fe20000410000ULL,
0x0000001941417220ULL, 0x080fe20000410000ULL, 0x0000001924247220ULL, 0x080fe20000410000ULL,
0x0000001925257220ULL, 0x000fe20000410000ULL, 0x0000001a2a2a7220ULL, 0x088fe20000410000ULL,
0x0000001a2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001a2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001a2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001a32327220ULL, 0x080fe20000410000ULL,
0x0000001a33337220ULL, 0x080fe20000410000ULL, 0x0000001a36367220ULL, 0x080fe20000410000ULL,
0x0000001a37377220ULL, 0x080fe20000410000ULL, 0x0000001a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001a42427220ULL, 0x080fe20000410000ULL,
0x0000001a43437220ULL, 0x080fe20000410000ULL, 0x0000001a26267220ULL, 0x080fe20000410000ULL,
0x0000001a27277220ULL, 0x000fe20000410000ULL, 0x0000001817184220ULL, 0x002fc80000410000ULL,
0x0000001118117221ULL, 0x018fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000862187824ULL, 0x000fe400078e025eULL, 0x800000001f197824ULL, 0x000fc800078e00ffULL,
0x00f64c0018187984ULL, 0x000ea40000000800ULL, 0x8000000018ff7812ULL, 0x004fe40007844819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001f1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00000406ff197984ULL, 0x000ea40008000800ULL,
0x8000000019ff7812ULL, 0x004fc4000784481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000100015187824ULL, 0x000fe200078e00ffULL,
0x00000017ff84723eULL, 0x000fe200000000ffULL, 0x0000100044207824ULL, 0x000fe200078e00ffULL,
0x0000991080857816ULL, 0x000fe400000000ffULL, 0x0000100018187812ULL, 0x000fe400078ec0ffULL,
0xffffe00020217812ULL, 0x000fe400078ec0ffULL, 0x0000b0000d1c7810ULL, 0x000fe40007ffe018ULL,
0x0000541084877816ULL, 0x000fe20000000084ULL, 0x0000100062207824ULL, 0x000fe200078e0221ULL,
0x000000ff8500720cULL, 0x000fe20003f45270ULL, 0x000000106a187824ULL, 0x000fc400078e021cULL,
0x00000010691c7824ULL, 0x000fe200078e021cULL, 0x0000b00020487810ULL, 0x000fe20007ffe0ffULL,
0x00001f5687807589ULL, 0x000fe800000e0000ULL, 0x000000001818783bULL, 0x000ea20000004200ULL,
0x000000105c207824ULL, 0x100fe400078e0248ULL, 0x0000001057487824ULL, 0x000fe200078e0248ULL,
0x000000001c1c783bULL, 0x000fe80000004200ULL, 0x000000002020783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000ee20000004200ULL, 0x00000018ff5c7819ULL, 0x004fe20000011418ULL,
0x00000100186a7824ULL, 0x040fe200078e00ffULL, 0x00008880187d7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011419ULL,
0x00000100196b7824ULL, 0x040fe200078e00ffULL, 0x0000888019797816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fc4000001146aULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000010048817824ULL, 0x008fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe2000001141aULL, 0x0000010049847824ULL, 0x000fe200078e00ffULL,
0x000088801a787816ULL, 0x000fe200000000ffULL, 0x00000018007b7306ULL, 0x0005e20000200c00ULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x000001004a987824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe4000001141bULL, 0x00000018ff967819ULL, 0x000fc40000011420ULL,
0x00000018ff8f7819ULL, 0x000fe20000011421ULL, 0x0000006a007c7306ULL, 0x0007e20000200c00ULL,
0x000001001b187824ULL, 0x004fe200078e00ffULL, 0x0000888021867816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011422ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001900777306ULL, 0x0005e20000200c00ULL, 0x000001001a6a7824ULL, 0x048fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011423ULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x0000888022937816ULL, 0x000fc400000000ffULL, 0x00000018ff757819ULL, 0x000fe4000001146aULL,
0x0000001800737306ULL, 0x0007e20000200c00ULL, 0x000001001c197824ULL, 0x004fe200078e00ffULL,
0x000088801b6a7816ULL, 0x040fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff717819ULL, 0x000fe20000011419ULL,
0x0000010020197824ULL, 0x000fe200078e00ffULL, 0x0000006b007a7306ULL, 0x0005e20000200c00ULL,
0x000001001d187824ULL, 0x008fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fc4000001141bULL,
0x0000888023927816ULL, 0x000fe400000000ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011481ULL,
0x0000001a00767306ULL, 0x0007e20000200c00ULL, 0x00000018ff6b7819ULL, 0x004fe40000011418ULL,
0x0000888020187816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000002ff817819ULL, 0x000fe40000011609ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001b00747306ULL, 0x0005e20000200c00ULL, 0x00000100211a7824ULL, 0x048fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011448ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00001f8187817589ULL, 0x000fe200000e0000ULL, 0x00008880488d7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe2000001141aULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x00000018ff1b7819ULL, 0x004fe20000011420ULL,
0x0000010022207824ULL, 0x040fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe20000011421ULL,
0x0000010023217824ULL, 0x040fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011421ULL,
0x0000001900197306ULL, 0x000ea20000200c00ULL, 0x00000018ff917819ULL, 0x000fc40000011422ULL,
0x00000018ff907819ULL, 0x000fe40000011423ULL, 0x00000018ff827819ULL, 0x000fe40000011449ULL,
0x00008880498b7816ULL, 0x040fe200000000ffULL, 0x0000002000947306ULL, 0x0007e20000200c00ULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x00000018ff7f7819ULL, 0x000fe4000001144aULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x00a000005b20783bULL, 0x008ee20000000200ULL,
0x0000541018187816ULL, 0x004fe40000000019ULL, 0x00000018ff7e7819ULL, 0x000fe4000001144bULL,
0x000088804a857816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000009700977306ULL, 0x000ea20000200c00ULL, 0x00000018ff657819ULL, 0x000fe4000001141cULL,
0x000088801c727816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff687819ULL, 0x000fe2000001141dULL,
0x0000009600967306ULL, 0x000fe20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000088801d707816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe4000001141eULL,
0x00000018ff667819ULL, 0x000fe2000001141fULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x0000541086197816ULL, 0x004fce0000000097ULL, 0x0000001b001b7306ULL, 0x000eb00000200c00ULL,
0x0000001a001a7306ULL, 0x000f220000200c00ULL, 0x000000812020a232ULL, 0x088fe40000000000ULL,
0x000000812222a232ULL, 0x000fc40000000000ULL, 0x000000802121a232ULL, 0x080fe40000000000ULL,
0x000000802323a232ULL, 0x000fe20000000000ULL, 0x0000004800887306ULL, 0x0007ec0000200c00ULL,
0x000000182028723cULL, 0x000fe40000001828ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000088804b487816ULL, 0x008fc800000000ffULL, 0x000054101b187816ULL, 0x004fe20000000096ULL,
0x000000ffff867224ULL, 0x000fe200078e0048ULL, 0x000054101a197816ULL, 0x010fe2000000008fULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x000001004b487824ULL, 0x040fe400078e00ffULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x0000009500957306ULL, 0x000ea20000200c00ULL,
0x00a000005818783bULL, 0x000ee20000000200ULL, 0x00000018ff4b7819ULL, 0x000fcc000001144bULL,
0x0000008a008a7306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000ff00000200c00ULL,
0x0000009100917306ULL, 0x000f300000200c00ULL, 0x0000009000907306ULL, 0x000e700000200c00ULL,
0x0000004900877306ULL, 0x0005e20000200c00ULL, 0x000000811818a232ULL, 0x008fc40000000000ULL,
0x000000811a1aa232ULL, 0x000fe40000000000ULL, 0x000000801919a232ULL, 0x080fe40000000000ULL,
0x000000801b1ba232ULL, 0x000fe20000000000ULL, 0x00000048008f7306ULL, 0x0007e20000200c00ULL,
0x0000541092497816ULL, 0x004fce0000000095ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x0000541093487816ULL, 0x008fce0000000094ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x000000482030723cULL, 0x000fee0000001830ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541091487816ULL, 0x010fe4000000008aULL, 0x0000541090497816ULL, 0x002fca0000000089ULL,
0x00000084008e7306ULL, 0x0002e40000200c00ULL, 0x000000482034723cULL, 0x000fec0000001834ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000054108d487816ULL, 0x004fe4000000008cULL,
0x00000018ff847819ULL, 0x002fca0000011498ULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x000054108b497816ULL, 0x008fce000000008eULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000000482038723cULL, 0x000fee0000001838ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x000100001d487824ULL, 0x000fe200078e00ffULL, 0x00005410871d7816ULL, 0x002fc40000000082ULL,
0x000088801e827816ULL, 0x000fc800000000ffULL, 0x0000004a00927306ULL, 0x000e700000200c00ULL,
0x0000004b00897306ULL, 0x000ff00000200c00ULL, 0x0000001c004a7306ULL, 0x0005f00000200c00ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x00005410881c7816ULL, 0x004fce0000000083ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x0000001c203c723cULL, 0x000fee000000183cULL,
0x0000008600867306ULL, 0x000ee20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe40000011448ULL,
0x00005410921c7816ULL, 0x002fca000000007fULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541085487816ULL, 0x004fce0000000084ULL, 0x0000001d004b7306ULL, 0x0005e20000200c00ULL,
0x0000541086497816ULL, 0x008fce000000008fULL, 0x000000482040723cULL, 0x040fe20000001840ULL,
0x00005410891d7816ULL, 0x004fe2000000007eULL, 0x0000005c005c7306ULL, 0x000fea0000200c00ULL,
0x000001001e497824ULL, 0x040fe200078e00ffULL, 0x0000001c2024723cULL, 0x000fe20000001824ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x000000ffff487224ULL, 0x000fc600078e0082ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x000054107d1c7816ULL, 0x000fe4000000007cULL, 0x00005410791d7816ULL, 0x002fe2000000007aULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000088801f207816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fc60000011449ULL, 0x0000001c1828723cULL, 0x000fe40000001828ULL,
0x0000006300637306ULL, 0x000e6a0000200c00ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0020ULL,
0x00005410771d7816ULL, 0x004fe20000000064ULL, 0x000001001f207824ULL, 0x040fe200078e00ffULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x000100001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000063ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000541074777816ULL, 0x004fce0000000069ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x008fe20000000065ULL,
0x000000761834723cULL, 0x000fec0000001834ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000054104b4b7816ULL, 0x002fce0000000068ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000004a183c723cULL, 0x000fee000000183cULL, 0x0000007500757306ULL, 0x000ff00000200c00ULL,
0x0000007200727306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000ff00000200c00ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000006b006b7306ULL, 0x000e700000200c00ULL,
0x0000004800487306ULL, 0x000ff00000200c00ULL, 0x0000002100217306ULL, 0x000ea20000200c00ULL,
0x00005410706b7816ULL, 0x002fce000000006bULL, 0x0000001c00497306ULL, 0x0003f00000200c00ULL,
0x0000002000207306ULL, 0x000ee20000200c00ULL, 0x000054107b1c7816ULL, 0x002fe4000000005cULL,
0x0000541048487816ULL, 0x004fca0000000021ULL, 0x0000001e001e7306ULL, 0x000e620000200c00ULL,
0x0000001c182c723cULL, 0x000fee000000182cULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x000054106a1d7816ULL, 0x000fe40000000073ULL, 0x00005410781c7816ULL, 0x000fc40000000075ULL,
0x00005410726a7816ULL, 0x000fe40000000071ULL, 0x0000541049497816ULL, 0x008fe40000000020ULL,
0x000054101e1e7816ULL, 0x002fe20000000057ULL, 0x0000001c1830723cULL, 0x000fe20000001830ULL,
0x000054101f1f7816ULL, 0x004fce0000000066ULL, 0x0000006a1838723cULL, 0x040ff00000001838ULL,
0x000000481840723cULL, 0x040ff00000001840ULL, 0x0000001e1824723cULL, 0x000fee0000001824ULL,
0x0000f63004187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200012ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004004197824ULL, 0x000fe200078e025fULL, 0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff55ff7812ULL, 0x000fc4000786c0ffULL,
0x000000c019197810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff5c7807ULL, 0x000fe40001000000ULL,
0x000000001900720cULL, 0x000fe40003f46070ULL, 0x00000001ff497807ULL, 0x000fe40001800000ULL,
0x0000005c6f4a7207ULL, 0x000fe40004000000ULL, 0x0000000115487812ULL, 0x000fce00078e0cffULL,
0x00001b8000002947ULL, 0x000fea0003800000ULL, 0x0000240012077984ULL, 0x004ea20000000800ULL,
0x8000000067187824ULL, 0x000fca00078e00ffULL, 0x8000000007ff7812ULL, 0x004fe20007844818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x0000240012077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007844818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000067677824ULL, 0x000fe400078e00ffULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700187305ULL, 0x0004e4000021f000ULL, 0x3fa0000007077823ULL, 0x004fe200000100ffULL,
0x000000180000735dULL, 0x008fe40003800000ULL, 0x0000240012187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fc40007844867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000016c6c7824ULL, 0x000fe200078e026dULL,
0x00000300461b7a10ULL, 0x000fc80007ffe0ffULL, 0x000000036c077812ULL, 0x000fe200078ec0ffULL,
0x000001001b1d7824ULL, 0x000fc600078e020cULL, 0x000000030700780cULL, 0x000fe40003f45270ULL,
0x000000200e187812ULL, 0x000fe400078ef81dULL, 0x0000000106077807ULL, 0x000fc60005000000ULL,
0x0000000f081f7224ULL, 0x020fe400078e0218ULL, 0x000000016c077824ULL, 0x000fe200078e0207ULL,
0x0000001d001c7217ULL, 0x000fe20007800000ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x000000020700720cULL, 0x000fe20003f46070ULL, 0x000000011c1c7824ULL, 0x000fe400078e0a1dULL,
0x00000080ff497424ULL, 0x000fd400078e00ffULL, 0x000000011419a824ULL, 0x000fe400078e0207ULL,
0x00000004ff1aa424ULL, 0x000fc800078e00ffULL, 0x000060001918a625ULL, 0x000fe200078e001aULL,
0x000000011b1a7810ULL, 0x000fc60007ffe0ffULL, 0x0000000154547824ULL, 0x100fe200078e021fULL,
0x000000081808a981ULL, 0x000562000c1e1900ULL, 0x000000031a00720cULL, 0x000fe20003f46070ULL,
0x00000001521a7824ULL, 0x100fe200078e021fULL, 0x0000001005207812ULL, 0x000fe200078ec0ffULL,
0x00000001501d7824ULL, 0x100fe200078e021fULL, 0x000000201c1c7807ULL, 0x000fe20001000000ULL,
0x000000014e4e7824ULL, 0x000fe200078e021fULL, 0x00000003ff237819ULL, 0x000fe20000011609ULL,
0x00005e001a1a7625ULL, 0x000fe200078e0049ULL, 0x0000001c201f7217ULL, 0x000fc40007800000ULL,
0x0000000423217810ULL, 0x000fe20007ffe0ffULL, 0x00005e0054187625ULL, 0x004fe200078e0049ULL,
0x000000451a1a7210ULL, 0x000fc60007f7e0ffULL, 0x000000011f207824ULL, 0x000fe200078e0a20ULL,
0x00000045181e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e001d1c7625ULL, 0x000fc800078e0049ULL,
0x000000ffff1f7224ULL, 0x000fe200010e0619ULL, 0x000000451c1c7210ULL, 0x000fe20007f9e0ffULL,
0x00005e004e187625ULL, 0x000fe200078e0049ULL, 0x000000202100720cULL, 0x080fe40003f46070ULL,
0x0000000823497810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x0000004518187210ULL, 0x000fe20007fbe0ffULL, 0x0000100062217824ULL, 0x000fe200078e020dULL,
0x000000202300720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000000c23237810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200028e0619ULL,
0x000000204900720cULL, 0x000fc40003f86070ULL, 0x0000b00021227810ULL, 0x000fe40007ffe0ffULL,
0x000000202300720cULL, 0x000fc60003fa6070ULL, 0x0000001053537824ULL, 0x100fe400078e0222ULL,
0x0000001051517824ULL, 0x100fe400078e0222ULL, 0x000000104f4f7824ULL, 0x100fe200078e0222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e537faeULL, 0x0005e2000d901c48ULL,
0x000000104d4d7824ULL, 0x000fc600078e0222ULL, 0x000000001a517faeULL, 0x0005e8000d101c48ULL,
0x000000001c4f7faeULL, 0x0005e8000e101c48ULL, 0x00000000184d7faeULL, 0x0005e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040061617984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f63c0016197984ULL, 0x004ea20000000800ULL,
0x0000005c6f6f7207ULL, 0x000fe20004000000ULL, 0x80000000471a7824ULL, 0x000fc600078e00ffULL,
0x0000ffff6f1c7812ULL, 0x000fca00078ec0ffULL, 0x800000001c187824ULL, 0x000fca00078e00ffULL,
0x8000000061ff7812ULL, 0x008fe40007844818ULL, 0x8000000019ff7812ULL, 0x004fe2000786481aULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000003947ULL, 0x000fea0003800000ULL,
0x80000000471a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00f63c0016197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fc4000786481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x0000002044187824ULL, 0x000fe400078e00ffULL,
0x00000001ff617424ULL, 0x000fc600078e00ffULL, 0xffffff8018187812ULL, 0x000fc800078ec0ffULL,
0x0000018045197810ULL, 0x000fca0007ffe018ULL, 0x000000014c197824ULL, 0x000fca00078e0219ULL,
0x00f00000191b7984ULL, 0x000ea80000000800ULL, 0x00f2000019187984ULL, 0x0007220000000800ULL,
0x000000101b00720bULL, 0x004fda0003f7d000ULL, 0x00000000001a7806ULL, 0x000fc800018e0100ULL,
0x0000ffff1a1d7812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000101b00720bULL, 0x018fe40003f74000ULL, 0x0000001b101f7209ULL, 0x000fe40007810000ULL,
0x00000002ff217819ULL, 0x000fc60000011609ULL, 0x8000001f10197221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b191a7820ULL, 0x000fe20000410000ULL, 0x0000000304197810ULL, 0x000fe40007ffe0ffULL,
0x0000000000107806ULL, 0x000fe400018e0100ULL, 0x000000441900720cULL, 0x000fe20003f65270ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000ffff101e7812ULL, 0x000fc800078e3cffULL,
0x0000001e1dff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff617807ULL, 0x000fc60002000000ULL,
0x000000804445b824ULL, 0x000fe200078e0245ULL, 0x00001f211a107589ULL, 0x004ea600000e0000ULL,
0x000000014c4cb824ULL, 0x000fe400078e0245ULL, 0x8000001f1b1b4221ULL, 0x000fe20000010000ULL,
0x0000001a11117220ULL, 0x000fe20000410000ULL, 0x00001f561a197589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b1b1b4820ULL, 0x000fc40000410000ULL, 0x00f4001f4c00b388ULL, 0x0009e40000000800ULL,
0x0000001b00174308ULL, 0x000e620000000800ULL, 0x0000001028287220ULL, 0x084fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x000000103c3c7220ULL, 0x080fe20000410000ULL,
0x000000103d3d7220ULL, 0x080fe20000410000ULL, 0x0000001040407220ULL, 0x080fe20000410000ULL,
0x0000001041417220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x000fe20000410000ULL, 0x000000192a2a7220ULL, 0x088fe20000410000ULL,
0x000000192b2b7220ULL, 0x080fe20000410000ULL, 0x000000192e2e7220ULL, 0x080fe20000410000ULL,
0x000000192f2f7220ULL, 0x080fe20000410000ULL, 0x0000001932327220ULL, 0x080fe20000410000ULL,
0x0000001933337220ULL, 0x080fe20000410000ULL, 0x0000001936367220ULL, 0x080fe20000410000ULL,
0x0000001937377220ULL, 0x080fe20000410000ULL, 0x000000193a3a7220ULL, 0x080fe20000410000ULL,
0x000000193b3b7220ULL, 0x080fe20000410000ULL, 0x000000193e3e7220ULL, 0x080fe20000410000ULL,
0x000000193f3f7220ULL, 0x080fe20000410000ULL, 0x0000001942427220ULL, 0x080fe20000410000ULL,
0x0000001943437220ULL, 0x080fe20000410000ULL, 0x0000001926267220ULL, 0x080fe20000410000ULL,
0x0000001927277220ULL, 0x000fe20000410000ULL, 0x000000ffff107224ULL, 0x000fe200078e001fULL,
0x0000001817184220ULL, 0x002fc80000410000ULL, 0x0000001118117221ULL, 0x018fe20000010000ULL,
0x0000011000002947ULL, 0x000fea0003800000ULL, 0x0000000862627824ULL, 0x000fca00078e00ffULL,
0x0000000862197812ULL, 0x000fca00078e3cffULL, 0x000000015e5e7824ULL, 0x000fe400078e0219ULL,
0x800000001c197824ULL, 0x000fc600078e00ffULL, 0x00f64c005e187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000001c1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0004e4000021f000ULL,
0x3fa0000018187823ULL, 0x004fe200000100ffULL, 0x000000190000735dULL, 0x008fe40003800000ULL,
0x00f64c005e197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fc4000784481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000006020783bULL, 0x000ea80000004200ULL, 0x000000005d48783bULL, 0x000ee80000004200ULL,
0x000000005a18783bULL, 0x000f280000004200ULL, 0x00000000591c783bULL, 0x0002e40000004200ULL,
0x00000017ff59723eULL, 0x002fc800000000ffULL, 0x0000541059627816ULL, 0x000fca0000000059ULL,
0x00001f56626a7589ULL, 0x000fe200000e0000ULL, 0x00000018ff727819ULL, 0x004fe20000011420ULL,
0x0000010020547824ULL, 0x040fe200078e00ffULL, 0x0000888020697816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011421ULL,
0x0000010021557824ULL, 0x040fe200078e00ffULL, 0x0000888021797816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff717819ULL, 0x000fe40000011422ULL,
0x00000018ff6d7819ULL, 0x000fe20000011423ULL, 0x00000020007b7306ULL, 0x0003e20000200c00ULL,
0x0000888022747816ULL, 0x000fe400000000ffULL, 0x0000888023777816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x008fc4000001144bULL, 0x000088804b5f7816ULL, 0x000fe200000000ffULL,
0x00000021007d7306ULL, 0x0005e20000200c00ULL, 0x0000010023207824ULL, 0x042fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011449ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005400807306ULL, 0x0003e20000200c00ULL, 0x0000010048217824ULL, 0x004fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fc40000011423ULL, 0x00008880496b7816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007e7306ULL, 0x0005e20000200c00ULL,
0x0000010022547824ULL, 0x042fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe2000001144aULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x000088804a647816ULL, 0x000fe400000000ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x0000002100767306ULL, 0x0003e20000200c00ULL,
0x0000010049207824ULL, 0x044fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x010fe40000011419ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000005500827306ULL, 0x000fe20000200c00ULL,
0x000001004a217824ULL, 0x042fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fc40000011448ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000787306ULL, 0x0003e20000200c00ULL,
0x0000888048737816ULL, 0x040fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001144aULL, 0x00000018ff477819ULL, 0x000fe40000011418ULL,
0x00008880184a7816ULL, 0x000fe200000000ffULL, 0x0000002100657306ULL, 0x0005e20000200c00ULL,
0x000001004b207824ULL, 0x042fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc4000001141aULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff687819ULL, 0x000fe2000001144bULL,
0x0000010018217824ULL, 0x044fe200078e00ffULL, 0x0000002000667306ULL, 0x0003e20000200c00ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x000088801a577816ULL, 0x000fe400000000ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011421ULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000022007a7306ULL, 0x000fe20000200c00ULL, 0x0000010019207824ULL, 0x002fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe4000001141bULL, 0x000088801b597816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011420ULL, 0x00000023007c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001141cULL, 0x00000018ff4f7819ULL, 0x000fc4000001141dULL,
0x00000018ff457819ULL, 0x000fe4000001141eULL, 0x00000018ff4e7819ULL, 0x000fe2000001141fULL,
0x00000049006c7306ULL, 0x0005e20000200c00ULL, 0x00a800005b20783bULL, 0x002fee0000000200ULL,
0x0000005400757306ULL, 0x0003e20000200c00ULL, 0x00000002ff497819ULL, 0x004fca0000011609ULL,
0x00001f49625b7589ULL, 0x000ea400000e0000ULL, 0x00000048006e7306ULL, 0x0007e20000200c00ULL,
0x0000888019547816ULL, 0x042fe200000000ffULL, 0x0001000019197824ULL, 0x000fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000001001a487824ULL, 0x048fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000019005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1a7819ULL, 0x000fce000001141aULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x0000991061197816ULL, 0x002fc800000000ffULL, 0x000000ff1900720cULL, 0x000fc60003f45270ULL,
0x00000018005a7306ULL, 0x0003f00000200c00ULL, 0x0000007900797306ULL, 0x000f220000200c00ULL,
0x000001001b187824ULL, 0x002fe200078e00ffULL, 0x0000005b2020a232ULL, 0x084fe20000000000ULL,
0x0000541077497816ULL, 0x008fe2000000007eULL, 0x0000005b2222a232ULL, 0x000fe20000000000ULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000006a2121a232ULL, 0x080fe20000000000ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000006a2323a232ULL, 0x000fe20000000000ULL, 0x00000018ff1b7819ULL, 0x000fcc000001141bULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541079197816ULL, 0x010fce0000000082ULL,
0x0000004800607306ULL, 0x0003f00000200c00ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000088801c487816ULL, 0x002fce00000000ffULL, 0x0000007000707306ULL, 0x000e700000200c00ULL,
0x0000001800567306ULL, 0x0007f00000200c00ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541069187816ULL, 0x008fe20000000080ULL, 0x000000ffff697224ULL, 0x000fe200078e0048ULL,
0x0000541074487816ULL, 0x000fe20000000075ULL, 0x000001001d747824ULL, 0x000fc800078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000182028723cULL, 0x040fee0000001828ULL,
0x0000006400647306ULL, 0x000ee20000200c00ULL, 0x000000482030723cULL, 0x000fe20000001830ULL,
0x000054107b187816ULL, 0x004fc40000000072ULL, 0x000054107d197816ULL, 0x002fe40000000070ULL,
0x000088801d727816ULL, 0x000fe400000000ffULL, 0x000054107a487816ULL, 0x000fe20000000071ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000054107c497816ULL, 0x000fe2000000006dULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x00000018ff6d7819ULL, 0x000fe40000011474ULL,
0x0000541064647816ULL, 0x008fc60000000065ULL, 0x0000005d005d7306ULL, 0x000e640000200c00ULL,
0x000000482034723cULL, 0x000fec0000001834ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x0000541073487816ULL, 0x000fe40000000076ULL, 0x000054106b497816ULL, 0x000fca0000000078ULL,
0x0000005300537306ULL, 0x000fe40000200c00ULL, 0x000000482038723cULL, 0x000fec0000001838ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000100001d487824ULL, 0x000fe200078e00ffULL,
0x000054106c1d7816ULL, 0x002fc8000000005dULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000006700677306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x000054105f657816ULL, 0x004fce0000000066ULL, 0x0000001a00627306ULL, 0x0005e20000200c00ULL,
0x0000541067527816ULL, 0x002fe20000000052ULL, 0x000000642040723cULL, 0x000fec0000001840ULL,
0x0000001b00617306ULL, 0x0003e20000200c00ULL, 0x000001001c1a7824ULL, 0x004fe200078e00ffULL,
0x0000541068537816ULL, 0x008fe20000000053ULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe4000001141aULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00a800005818783bULL, 0x0022a20000000200ULL, 0x000000522024723cULL, 0x000fe20000001824ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000001c00497306ULL, 0x0007f00000200c00ULL,
0x0000004d004d7306ULL, 0x000f220000200c00ULL, 0x000054106e1c7816ULL, 0x008fc40000000063ULL,
0x0000541057587816ULL, 0x002fca0000000060ULL, 0x0000001c203c723cULL, 0x000fe2000000183cULL,
0x0000004a004a7306ULL, 0x000fec0000200c00ULL, 0x000088801e1c7816ULL, 0x040fe200000000ffULL,
0x000001001e1d7824ULL, 0x040fe200078e00ffULL, 0x000088801f207816ULL, 0x040fe200000000ffULL,
0x000001001f217824ULL, 0x040fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000005b1818a232ULL, 0x084fe20000000000ULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000005b1a1aa232ULL, 0x000fe20000000000ULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x0000541062607816ULL, 0x010fe2000000004dULL,
0x0000006a1919a232ULL, 0x000fc40000000000ULL, 0x0000006a1b1ba232ULL, 0x000fe20000000000ULL,
0x000054104a4a7816ULL, 0x002fc6000000004bULL, 0x0000001d001d7306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000eb00000200c00ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x000054101c1c7816ULL, 0x002fce000000001dULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000054105a5a7816ULL, 0x004fce0000000047ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000054105e5b7816ULL, 0x008fce0000000051ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541061617816ULL, 0x002fe20000000050ULL, 0x0000005a182c723cULL, 0x040fec000000182cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410494c7816ULL, 0x004fe2000000004cULL,
0x000000601834723cULL, 0x000fec0000001834ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000005900597306ULL, 0x000eb00000200c00ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410544b7816ULL, 0x002fce0000000055ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541059597816ULL, 0x004fe20000000056ULL, 0x0000004a1828723cULL, 0x040fec0000001828ULL,
0x0000007200727306ULL, 0x000fe40000200c00ULL, 0x000000581830723cULL, 0x000fec0000001830ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00005410696c7816ULL, 0x002fce0000000070ULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x00005410726d7816ULL, 0x004fce000000006dULL, 0x0000002100217306ULL, 0x000ea20000200c00ULL,
0x00005410484d7816ULL, 0x002fe2000000004fULL, 0x0000006c1838723cULL, 0x040fec0000001838ULL,
0x0000001e001e7306ULL, 0x000e640000200c00ULL, 0x0000004c183c723cULL, 0x000fec000000183cULL,
0x0000001f001f7306ULL, 0x000ee20000200c00ULL, 0x00005410201d7816ULL, 0x004fc40000000021ULL,
0x000054101e1e7816ULL, 0x002fca0000000045ULL, 0x0000001c1840723cULL, 0x000fe20000001840ULL,
0x000054101f1f7816ULL, 0x008fce000000004eULL, 0x0000001e1824723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200012ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400016ff7f8cULL, 0x0005e2000c80043fULL, 0x000099106f187816ULL, 0x000fe400000000ffULL,
0x00000001ff497807ULL, 0x000fe40004800000ULL, 0x000000ff1800720cULL, 0x000fe40003f45270ULL,
0x0000000115487812ULL, 0x000fe400078ec0ffULL, 0x00000001ff5c8807ULL, 0x000fc80001000000ULL,
0x000076105c4a7816ULL, 0x000fe4000000004aULL, 0x0000030046467a10ULL, 0x004fe40007ffe0ffULL,
0x000000ff13ff7812ULL, 0x000fe4000780c0ffULL, 0x000000034600720cULL, 0x000fe40003f26070ULL,
0x00000001ff137807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff889000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x002e640000002500ULL,
0x0000000403007c0cULL, 0x002fda000bf03070ULL, 0x0000039000000947ULL, 0x000fea0003800000ULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0011ULL,
0x0000876000067802ULL, 0x000fe40000000f00ULL, 0x00008c4000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001100007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000011ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x002e680000000000ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000806057811ULL, 0x008fe200078ff0ffULL,
0x0000000003087220ULL, 0x024fca0000410000ULL, 0x00001f0708007589ULL, 0x000e6800000e0000ULL,
0x00001f0508067589ULL, 0x000ea200000e0000ULL, 0x0000002800287220ULL, 0x042fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000002a062a7220ULL, 0x044fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000003a063a7220ULL, 0x040fe20000410000ULL,
0x0000003b063b7220ULL, 0x040fe20000410000ULL, 0x0000003e063e7220ULL, 0x040fe20000410000ULL,
0x0000003f063f7220ULL, 0x040fe20000410000ULL, 0x0000004206427220ULL, 0x040fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000424343723eULL, 0x000fc400000000ffULL, 0x000000262726723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x0000541043427816ULL, 0x140fe40000000026ULL,
0x0000763243437816ULL, 0x000fe40000000026ULL, 0x0000000203007812ULL, 0x002fe400078ec0ffULL,
0x00000002ff157819ULL, 0x000fc40000011603ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000400087811ULL, 0x060fe400078ff8ffULL, 0x00000008031d7811ULL, 0x000fe400078ff0ffULL,
0x0000000200057811ULL, 0x040fe400078ff8ffULL, 0x00000006000f7811ULL, 0x000fe400078ff8ffULL,
0x0000000702007812ULL, 0x000fc400078e7815ULL, 0x00000007080e7812ULL, 0x040fe400078e7815ULL,
0x0000000708087812ULL, 0x000fe200078e781dULL, 0x0000000815077824ULL, 0x000fe200078e0200ULL,
0x0000000705067812ULL, 0x000fe200078e7815ULL, 0x000010000a007824ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x000fe200078e781dULL, 0x000000081d1b7824ULL, 0x000fe200078e0208ULL,
0x000000070f127812ULL, 0x000fe200078e7815ULL, 0x0000000803087824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e781dULL, 0x000000081d177824ULL, 0x000fe200078e0202ULL,
0x000000070f0f7812ULL, 0x000fe200078e781dULL, 0x0000000815097824ULL, 0x040fe200078e0206ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x0000000815137824ULL, 0x000fe200078e020eULL,
0x0000002c2d06723eULL, 0x000fe200000000ffULL, 0x000000081d197824ULL, 0x000fe200078e0205ULL,
0x000000282905723eULL, 0x000fe200000000ffULL, 0x000008000b027824ULL, 0x000fc400078e0200ULL,
0x0000000815157824ULL, 0x000fe200078e0212ULL, 0x00005410051e7816ULL, 0x100fe20000000006ULL,
0x000000081d1d7824ULL, 0x000fe200078e020fULL, 0x00007632051f7816ULL, 0x000fe20000000006ULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x000000383905723eULL, 0x000fe200000000ffULL,
0x00000010090f7824ULL, 0x100fe200078e0202ULL, 0x0000003c3d06723eULL, 0x000fe200000000ffULL,
0x0000001013137824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x000fe200078e0202ULL,
0x00005410050e7816ULL, 0x000fe20000000006ULL, 0x0000001019197824ULL, 0x000fc400078e0202ULL,
0x0000001015157824ULL, 0x100fe400078e0202ULL, 0x000000101b1b7824ULL, 0x100fe400078e0202ULL,
0x000000101d1d7824ULL, 0x000fe400078e0202ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x000000303107723eULL, 0x000fe200000000ffULL, 0x00000001080f7824ULL, 0x040fe400078e020fULL,
0x0000000108137824ULL, 0x040fe200078e0213ULL, 0x0000001e09007388ULL, 0x0003e20000000a00ULL,
0x0000000108177824ULL, 0x000fc400078e0217ULL, 0x0000000108197824ULL, 0x040fe400078e0219ULL,
0x0000000108157824ULL, 0x040fe400078e0215ULL, 0x00000001081b7824ULL, 0x040fe400078e021bULL,
0x00000001081d7824ULL, 0x000fe200078e021dULL, 0x000000343508723eULL, 0x000fc800000000ffULL,
0x00005410071e7816ULL, 0x142fe40000000008ULL, 0x00007632071f7816ULL, 0x000fe40000000008ULL,
0x000000404107723eULL, 0x000fe400000000ffULL, 0x000000242508723eULL, 0x000fe200000000ffULL,
0x0000001e0f007388ULL, 0x0003e40000000a00ULL, 0x00007632050f7816ULL, 0x002fe40000000006ULL,
0x0000002a2b05723eULL, 0x000fc400000000ffULL, 0x0000002e2f06723eULL, 0x000fe200000000ffULL,
0x0000000e13007388ULL, 0x0003e60000000a00ULL, 0x0000541005127816ULL, 0x000fe40000000006ULL,
0x00005410070e7816ULL, 0x142fe40000000008ULL, 0x00007632070f7816ULL, 0x000fe40000000008ULL,
0x0000763205137816ULL, 0x000fc40000000006ULL, 0x000000323307723eULL, 0x000fe200000000ffULL,
0x0000000e15007388ULL, 0x0003e20000000a00ULL, 0x000000363708723eULL, 0x000fe400000000ffULL,
0x0000003a3b05723eULL, 0x000fe200000000ffULL, 0x0000001217007388ULL, 0x0005e20000000a00ULL,
0x0000003e3f06723eULL, 0x000fc800000000ffULL, 0x0000763205097816ULL, 0x000fe20000000006ULL,
0x000000010c0f7824ULL, 0x002fe200078e0203ULL, 0x0000541007127816ULL, 0x004fc60000000008ULL,
0x000000100f0e7824ULL, 0x000fe200078e0200ULL, 0x0000763207137816ULL, 0x000fe40000000008ULL,
0x0000541005087816ULL, 0x000fc60000000006ULL, 0x0000001219007388ULL, 0x000fe80000000a00ULL,
0x000000081b007388ULL, 0x000fe80000000a00ULL, 0x000000421d007388ULL, 0x0003e80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000300ff1d7624ULL, 0x002fca00078e00ffULL,
0x000000011d00780cULL, 0x000fe20003f05270ULL, 0x000000000e147984ULL, 0x000e680000000c00ULL,
0x000400000e247984ULL, 0x000ea80000000c00ULL, 0x000800000e207984ULL, 0x000ee80000000c00ULL,
0x000c00000e287984ULL, 0x000f220000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000002317177230ULL, 0x008fe40000000000ULL,
0x0000002216167230ULL, 0x000fe40000000000ULL, 0x0000002115157230ULL, 0x000fe40000000000ULL,
0x0000002014147230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x010fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x000000140e007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x000400240e007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000303000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000ea20000002700ULL,
0x000058001d057a24ULL, 0x000fe200078e02ffULL, 0x000000010bff7812ULL, 0x000fe2000780f844ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x0000660005127a24ULL, 0x000fe200078e02ffULL, 0x000000400f1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000000e147984ULL, 0x0022e40000000c00ULL, 0x00000fff12057811ULL, 0x000fe400078e40ffULL,
0x000400000e207984ULL, 0x0003220000000c00ULL, 0x000058001c1c7a24ULL, 0x004fe400078e0207ULL,
0x000008000a077824ULL, 0x000fe400078e00ffULL, 0x000003001c067a24ULL, 0x000fca00078e02ffULL,
0x0000000406137c10ULL, 0x000fc8000fffe0ffULL, 0x0000001305087211ULL, 0x000fca00078fa0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0009ULL, 0x0000000708087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x000000100f187825ULL, 0x000fc800078e0008ULL, 0x000000101b1a7825ULL, 0x000fe200078e0008ULL,
0x01ffffff12087812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030e7824ULL, 0x01afe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe200078e0208ULL,
0x000000700e1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f1e7812ULL, 0x000fe200078ec0ffULL,
0x00006c00130e7625ULL, 0x000fc800078e0009ULL, 0x00006c0012127625ULL, 0x000fe200078e0009ULL,
0x0000000e1e0e7210ULL, 0x000fc80007a1e01fULL, 0x000000121e127210ULL, 0x000fe40007c7e01fULL,
0x0000000fff0f7210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x000000100e007986ULL, 0x0003e8000c101908ULL, 0x0000001112007986ULL, 0x0003e4000c101908ULL,
0x0000001418007986ULL, 0x01a3e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000201a007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0xffffffff1d097810ULL, 0x000fc60007ffe0ffULL, 0x00006a001c0e7625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000090e0e79a8ULL, 0x000ea400099ee1c8ULL, 0x000000090e00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff107807ULL, 0x000fca0000000000ULL,
0x00000010ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x000ee40000000000ULL,
0x000000ff0900720cULL, 0x008fda0003f05270ULL, 0x00002c6000008947ULL, 0x000fea0003800000ULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x0000000106107810ULL, 0x004fe20007ffe0ffULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0x0000000c0e177812ULL, 0x002fe400078ec0ffULL, 0x0000007009157812ULL, 0x000fe200078ec0ffULL,
0x00006c00060e7625ULL, 0x000fc800078e0013ULL, 0x00006c0010107625ULL, 0x000fe200078e0013ULL,
0x0000000e170e7210ULL, 0x000fc8000791e015ULL, 0x0000001017107210ULL, 0x000fe40007b5e015ULL,
0x0000000fff0f7210ULL, 0x000fe400007e24ffULL, 0x00000011ff117210ULL, 0x000fc600017e64ffULL,
0x000000080e097981ULL, 0x000368000c1e1900ULL, 0x0000000810127981ULL, 0x000362000c1e1900ULL,
0x000000021d00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0013ULL,
0x0000000e170e7210ULL, 0x000fc8000791e015ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e147981ULL, 0x000362000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0013ULL, 0x0000000e170e7210ULL, 0x000fc8000791e015ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e167981ULL, 0x000362000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0013ULL,
0x0000000e170e7210ULL, 0x000fc8000791e015ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e187981ULL, 0x000362000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0013ULL, 0x0000000e170e7210ULL, 0x000fc8000791e015ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e1a7981ULL, 0x000362000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081d00780cULL, 0x002fe40003f06070ULL, 0x00000006060e7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0013ULL, 0x0000000e170e7210ULL, 0x000fe40007a3e015ULL,
0x0000000706100810ULL, 0x000fe40007ffe0ffULL, 0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL,
0x00006c0010100625ULL, 0x000fe400078e0013ULL, 0x000000080e1c7981ULL, 0x000366000c1e1900ULL,
0x0000001017100210ULL, 0x000fc80007c7e015ULL, 0x00000011ff110210ULL, 0x000fca0001fe84ffULL,
0x0000000810100981ULL, 0x000368000c1e1900ULL, 0x000000071d0e7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff117819ULL, 0x000fc8000001160eULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fe400078e00ffULL,
0x000000ffff207224ULL, 0x020fe400078e0009ULL, 0x000000081e137824ULL, 0x040fe200078e00ffULL,
0x000000011e1e7810ULL, 0x000fc80007ffe0ffULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x000000111e00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008130f7810ULL, 0x040fe40007ffe0ffULL, 0x00000001130e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000002009097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e207981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009130f7810ULL, 0x042fe40007ffe0ffULL,
0x00000002130e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001209097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007012157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e127981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a130f7810ULL, 0x042fe40007ffe0ffULL, 0x00000003130e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001409097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003147824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e147981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b130f7810ULL, 0x042fe40007ffe0ffULL,
0x00000004130e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001609097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e167981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c130f7810ULL, 0x042fe40007ffe0ffULL, 0x00000005130e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001809097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e187981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d130f7810ULL, 0x042fe40007ffe0ffULL,
0x00000006130e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001a09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e1a7981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e130f7810ULL, 0x042fe40007ffe0ffULL, 0x00000007130e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001c09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e1c7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f13137810ULL, 0x000fe40007ffe0ffULL,
0x0000001009097209ULL, 0x000fe40007810000ULL, 0x0000030013007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x002fe200078e0213ULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x004fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000e150e7210ULL, 0x000fc80007a3e013ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL,
0x000000080e107981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030e7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011603ULL, 0x000000700e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f0f7812ULL, 0x000fca00078ec0ffULL, 0x000000010f0e7824ULL, 0x000fca00078e020eULL,
0x000000090e007388ULL, 0x0203e40000000800ULL, 0x000000010b187824ULL, 0x002fe200078e0206ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011603ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000018050e7211ULL, 0x000fe200078fa0ffULL, 0x00001000ff137424ULL, 0x000fe200078e00ffULL,
0x0000007009117812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0200ULL,
0x0000000c0f127812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e0013ULL,
0x0000000104097812ULL, 0x040fe200078ec0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000004003137810ULL, 0x000fe20007ffe0ffULL, 0x0000080004047824ULL, 0x000fe200078e00ffULL,
0x000000070e0e7210ULL, 0x000fe20007f3e0ffULL, 0x000000020b108824ULL, 0x104fe200078e020aULL,
0x0000006003157810ULL, 0x000fe20007ffe0ffULL, 0x00000001121c7824ULL, 0x000fe200078e0211ULL,
0x0000080004047812ULL, 0x000fe200078ec0ffULL, 0x000000020b128824ULL, 0x000fe200078e020aULL,
0x0000002003117810ULL, 0x000fe20007ffe0ffULL, 0x0000000108168824ULL, 0x000fe200078e0218ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000080ff178424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000002101a8824ULL, 0x000fe200078e0209ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000003000b007a0cULL, 0x000fe20003f26070ULL, 0x00000080ff198424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000002121e8824ULL, 0x000fe200078e0209ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000010d047824ULL, 0x000fe200078e0204ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00006c0016168625ULL, 0x000fc800078e0017ULL,
0x0000001011107825ULL, 0x000fc800078e000eULL, 0x0000001013127825ULL, 0x000fc800078e000eULL,
0x0000001015147825ULL, 0x000fc800078e000eULL, 0x00006c0018188625ULL, 0x000fc800078e0019ULL,
0x000000081a1a8824ULL, 0x000fe400078e0203ULL, 0x00000010031b7824ULL, 0x040fe400078e0204ULL,
0x00000010030e7825ULL, 0x040fe200078e000eULL, 0x000000001c047984ULL, 0x0002a20000000800ULL,
0x000045801a1d8811ULL, 0x000fe400078e20ffULL, 0x000000081e1e8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e1b7faeULL, 0x0007e2000b901c48ULL,
0x0000001003168825ULL, 0x000fc600078e0016ULL, 0x000041801e1f8811ULL, 0x000fe200078e20ffULL,
0x0000001003188825ULL, 0x000fe200078e0018ULL, 0x00380000101b7faeULL, 0x0009e6000b901c48ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00580000121b7faeULL, 0x000be2000b901c48ULL,
0x00000000000e7805ULL, 0x008fc6000001ff00ULL, 0x00780000141b7faeULL, 0x0007e8000b901c48ULL,
0x00000000161d8faeULL, 0x0003e2000b901c48ULL, 0x0000000000107805ULL, 0x010fc6000001ff00ULL,
0x00000000181f8faeULL, 0x0009e2000b901c48ULL, 0x0000000000127805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x002fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x010fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x004fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fca00078e000bULL, 0x00000002312f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200078e0031ULL, 0x00000002ff307819ULL, 0x000fe20000011603ULL,
0x000000020b327824ULL, 0x000fe200078e020aULL, 0x000003002f007a0cULL, 0x000fe20003f06070ULL,
0x0000004045317824ULL, 0x000fe200078e00ffULL, 0x0000000730337812ULL, 0x040fe200078ec0ffULL,
0x00000008302e7824ULL, 0x040fe200078e00ffULL, 0x00000030ff4c7212ULL, 0x000fe200078e33ffULL,
0x00000008303e7824ULL, 0x042fe200078e00ffULL, 0x0000008031317812ULL, 0x000fe200078ec0ffULL,
0x0000000830357824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0x000000012e407812ULL, 0x140fe200078ef633ULL, 0x0000001003477824ULL, 0x000fe200078e00ffULL,
0x000000022e427812ULL, 0x000fe200078ef633ULL, 0x0000010032437824ULL, 0x000fe200078e0031ULL,
0x000000032e447812ULL, 0x000fc400078ef633ULL, 0x000000042e467812ULL, 0x140fe400078ef633ULL,
0x000000052e487812ULL, 0x140fe400078ef633ULL, 0x000000062e4a7812ULL, 0x100fe400078ef633ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee233ULL, 0xfffffff8354c7812ULL, 0x000fe400078ee24cULL,
0x00000008302e7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x008fea0003800000ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x00000001063c7824ULL, 0x100fe200078e022fULL,
0x00000001ff317819ULL, 0x000fe2000001162fULL, 0x00001000ff337424ULL, 0x000fe200078e00ffULL,
0x0000004003397810ULL, 0x000fc40007ffe0ffULL, 0x0000003c05327211ULL, 0x000fe400078fa0ffULL,
0x0000000131347812ULL, 0x000fe200078ec0ffULL, 0x000004002f317824ULL, 0x000fe200078e00ffULL,
0x00000060033f7810ULL, 0x000fe20007ffe0ffULL, 0x00006c0032327625ULL, 0x000fc800078e0033ULL,
0x000000020b359824ULL, 0x140fe200078e020aULL, 0x0000000732327210ULL, 0x000fe20007f1e0ffULL,
0x000000020b379824ULL, 0x000fe400078e020aULL, 0x00000002354e9824ULL, 0x100fe400078e0234ULL,
0x0000000237509824ULL, 0x000fe200078e0234ULL, 0x0000080031347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000002003377810ULL, 0x000fe20007ffe0ffULL,
0x00000001083a9824ULL, 0x000fc400078e023cULL, 0x000000010d347824ULL, 0x000fe400078e0234ULL,
0x00000080ff3b9424ULL, 0x000fe400078e00ffULL, 0x00000080ff3d9424ULL, 0x000fe400078e00ffULL,
0x0000001003317824ULL, 0x040fe400078e0234ULL, 0x0000001003347825ULL, 0x000fc800078e0032ULL,
0x0000001037367825ULL, 0x100fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000034317faeULL, 0x0003e6000b901c48ULL, 0x0000001039387825ULL, 0x100fe200078e0032ULL,
0x0038000036317faeULL, 0x0003e6000b901c48ULL, 0x00006c003a3a9625ULL, 0x000fe200078e003bULL,
0x0058000038317faeULL, 0x0003e6000b901c48ULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x00006c003c3c9625ULL, 0x000fe200078e003dULL, 0x0078000032317faeULL, 0x0003e6000b901c48ULL,
0x000000084e3f9824ULL, 0x100fe400078e0203ULL, 0x0000000850419824ULL, 0x000fe400078e0203ULL,
0x00000010033a9825ULL, 0x000fe200078e003aULL, 0x000045803f3f9811ULL, 0x000fe400078e20ffULL,
0x0000418041419811ULL, 0x000fe200078e20ffULL, 0x00000010033c9825ULL, 0x000fc400078e003cULL,
0x000000003a3f9faeULL, 0x0003e8000b901c48ULL, 0x000000003c419faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff347819ULL, 0x002fe20000011603ULL, 0x000000082e377824ULL, 0x040fe200078e00ffULL,
0x0000007047527812ULL, 0x000fe200078ec0ffULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0x0000000c34357812ULL, 0x000fe200078ec0ffULL, 0x0000040045317824ULL, 0x000fe200078e00ffULL,
0x000000072e327812ULL, 0x000fc400078ec0ffULL, 0x0000004335437210ULL, 0x000fe20007ffe052ULL,
0x000000082e527824ULL, 0x000fe200078e00ffULL, 0xfffffff837347812ULL, 0x100fe400078ee232ULL,
0x0000000133367812ULL, 0x140fe400078ef632ULL, 0x0000000233387812ULL, 0x140fe400078ef632ULL,
0x00000003333a7812ULL, 0x140fe400078ef632ULL, 0x00000004333c7812ULL, 0x000fc400078ef632ULL,
0x00000005334e7812ULL, 0x140fe400078ef632ULL, 0x0000000633507812ULL, 0x000fe200078ef632ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800043357984ULL, 0x000e620000000800ULL,
0x0000080031327812ULL, 0x000fe200078ec0ffULL, 0x0000000403337824ULL, 0x000fe200078e00ffULL,
0x0000002eff377212ULL, 0x000fe400078e33ffULL, 0x000001800d317810ULL, 0x000fe40007ffe032ULL,
0xfffffff852327812ULL, 0x000fe400078ee237ULL, 0x0000000c33337812ULL, 0x000fe200078ec0ffULL,
0x0000001040407824ULL, 0x100fe200078e0231ULL, 0x0045800043527984ULL, 0x000ea20000000800ULL,
0x0000001042427824ULL, 0x000fc400078e0231ULL, 0x0000001044447824ULL, 0x100fe400078e0231ULL,
0x0000001046467824ULL, 0x100fe400078e0231ULL, 0x0000001048487824ULL, 0x100fe400078e0231ULL,
0x000000104a4a7824ULL, 0x100fe400078e0231ULL, 0x0000001034347824ULL, 0x100fe400078e0231ULL,
0x0000001036367824ULL, 0x000fc400078e0231ULL, 0x0000001038387824ULL, 0x100fe400078e0231ULL,
0x000000104e4e7824ULL, 0x100fe400078e0231ULL, 0x0000001050507824ULL, 0x100fe400078e0231ULL,
0x000000104c4c7824ULL, 0x100fe400078e0231ULL, 0x0000001032327824ULL, 0x100fe400078e0231ULL,
0x000000103e3e7824ULL, 0x000fc400078e0231ULL, 0x000000103a3a7824ULL, 0x100fe400078e0231ULL,
0x000000103c3c7824ULL, 0x000fe200078e0231ULL, 0x0000003504357221ULL, 0x002fe20000010100ULL,
0x0000000133407824ULL, 0x040fe400078e0240ULL, 0x0000000133427824ULL, 0x000fe200078e0242ULL,
0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL, 0x0000000133447824ULL, 0x040fe400078e0244ULL,
0x0000000133467824ULL, 0x040fe200078e0246ULL, 0x0000000040407984ULL, 0x000e620000000800ULL,
0x0000000133487824ULL, 0x040fe200078e0248ULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x00000001334a7824ULL, 0x040fe200078e024aULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x00000001334c7824ULL, 0x000fc400078e024cULL, 0x0000000133347824ULL, 0x040fe200078e0234ULL,
0x0000000044447984ULL, 0x000f220000000800ULL, 0x0000000133367824ULL, 0x040fe400078e0236ULL,
0x0000000133387824ULL, 0x040fe200078e0238ULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x00000001334e7824ULL, 0x040fe400078e024eULL, 0x0000000133507824ULL, 0x040fe200078e0250ULL,
0x0000000048487984ULL, 0x000f620000000800ULL, 0x0000000133327824ULL, 0x000fe200078e0232ULL,
0x0000005235597220ULL, 0x004fe20000410000ULL, 0x000000013e3e7824ULL, 0x000fe200078e0233ULL,
0x000000004a4a7984ULL, 0x000ea20000000800ULL, 0x00000001333a7824ULL, 0x000fe200078e023aULL,
0x0000002d592d7221ULL, 0x000fe20000010000ULL, 0x00000001333c7824ULL, 0x000fe200078e023cULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x000000ffff317224ULL, 0x000fc600078e002fULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000030031007a0cULL, 0x000fe40003f06070ULL,
0x0000000036367984ULL, 0x000ea80000000800ULL, 0x0000000038387984ULL, 0x000ea80000000800ULL,
0x000000004e4e7984ULL, 0x000ea20000000800ULL, 0x20000040ff357230ULL, 0x002fc40000004100ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000000050507984ULL, 0x000e620000000800ULL,
0x20000042ff377230ULL, 0x108fe40000004100ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000000032327984ULL, 0x000ee20000000800ULL, 0x20000044ff397230ULL, 0x110fe40000004100ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x000000003e3e7984ULL, 0x000f220000000800ULL,
0x20000046ff3b7230ULL, 0x020fc40000004100ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x20000048ff437230ULL, 0x100fe40000004100ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x2000004aff457230ULL, 0x104fe40000004100ULL, 0x3000004aff4a7230ULL, 0x000fe40000004100ULL,
0x2000004cff477230ULL, 0x000fc40000004100ULL, 0x3000004cff4c7230ULL, 0x000fe40000004100ULL,
0x20000034ff497230ULL, 0x100fe40000004100ULL, 0x30000034ff347230ULL, 0x000fe40000004100ULL,
0x20000036ff4b7230ULL, 0x100fe40000004100ULL, 0x30000036ff367230ULL, 0x000fe40000004100ULL,
0x20000038ff4d7230ULL, 0x000fc40000004100ULL, 0x30000038ff387230ULL, 0x000fe40000004100ULL,
0x2000004eff537230ULL, 0x100fe40000004100ULL, 0x3000004eff4e7230ULL, 0x000fe40000004100ULL,
0x20000050ff557230ULL, 0x102fe40000004100ULL, 0x30000050ff507230ULL, 0x000fe40000004100ULL,
0x20000032ff577230ULL, 0x008fc40000004100ULL, 0x30000032ff327230ULL, 0x000fe40000004100ULL,
0x2000003eff337230ULL, 0x110fe40000004100ULL, 0x3000003eff527230ULL, 0x000fe40000004100ULL,
0x2000003aff4f7230ULL, 0x120fe40000004100ULL, 0x3000003aff547230ULL, 0x000fe40000004100ULL,
0x2000003cff517230ULL, 0x000fc40000004100ULL, 0x3000003cff567230ULL, 0x000fe20000004100ULL,
0x00005bb27f007947ULL, 0x000fea000b800000ULL, 0x00001f3059307589ULL, 0x0002a400000e0000ULL,
0x00005c127f007947ULL, 0x000fea000b800000ULL, 0x00001f2e592e7589ULL, 0x00072400000e0000ULL,
0x00000030332c7223ULL, 0x084fe2000001002cULL, 0x00000030522b7223ULL, 0x080fe2000001002bULL,
0x0000003035287223ULL, 0x080fe20000010028ULL, 0x0000003040277223ULL, 0x080fe20000010027ULL,
0x0000003037247223ULL, 0x080fe20000010024ULL, 0x0000003042237223ULL, 0x080fe20000010023ULL,
0x0000003039207223ULL, 0x080fe20000010020ULL, 0x00000030441f7223ULL, 0x080fe2000001001fULL,
0x000000303b1c7223ULL, 0x080fe2000001001cULL, 0x00000030461b7223ULL, 0x080fe2000001001bULL,
0x0000003043187223ULL, 0x080fe20000010018ULL, 0x0000003048177223ULL, 0x080fe20000010017ULL,
0x0000003045147223ULL, 0x080fe20000010014ULL, 0x000000304a137223ULL, 0x080fe20000010013ULL,
0x0000003047107223ULL, 0x080fe20000010010ULL, 0x000000304c0f7223ULL, 0x000fe2000001000fULL,
0x0000002e492a7223ULL, 0x090fe2000001002aULL, 0x0000002e34297223ULL, 0x080fe20000010029ULL,
0x0000002e4b267223ULL, 0x080fe20000010026ULL, 0x0000002e36257223ULL, 0x080fe20000010025ULL,
0x0000002e4d227223ULL, 0x080fe20000010022ULL, 0x0000002e38217223ULL, 0x080fe20000010021ULL,
0x0000002e4f1e7223ULL, 0x080fe2000001001eULL, 0x0000002e541d7223ULL, 0x080fe2000001001dULL,
0x0000002e511a7223ULL, 0x080fe2000001001aULL, 0x0000002e56197223ULL, 0x080fe20000010019ULL,
0x0000002e53167223ULL, 0x080fe20000010016ULL, 0x0000002e4e157223ULL, 0x080fe20000010015ULL,
0x0000002e55127223ULL, 0x080fe20000010012ULL, 0x0000002e50117223ULL, 0x080fe20000010011ULL,
0x0000002e570e7223ULL, 0x080fe2000001000eULL, 0x0000002e32097223ULL, 0x000fe20000010009ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x004ea20000000000ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103057824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003047824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c03067812ULL, 0x000fc600078ec0ffULL, 0x000000800b037824ULL, 0x000fc800078e0204ULL,
0x0000000106047824ULL, 0x000fca00078e0203ULL, 0x0049802d04007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800005037984ULL, 0x000f280000000800ULL,
0x004a000005047984ULL, 0x004ea20000000800ULL, 0x00000003ff037221ULL, 0x010fc80000010000ULL,
0x0000000403037221ULL, 0x004fca0000010000ULL, 0x0180000003047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0003ULL, 0x0000b6f000067802ULL, 0x000fe40000000f00ULL,
0x00005cb000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300047308ULL, 0x000ea40000001000ULL,
0xbf80000003057423ULL, 0x004fc80000000004ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff337819ULL, 0x004fe40000011603ULL, 0x0000000803417811ULL, 0x002fc600078ff0ffULL,
0x00001f3304057589ULL, 0x000e6200000e0000ULL, 0x0000000833457824ULL, 0x000fe200078e00ffULL,
0x00000041ff437212ULL, 0x000fe200078e33ffULL, 0x0000000841087824ULL, 0x000fe200078e00ffULL,
0x00001f4104067589ULL, 0x00052800000e0000ULL, 0xfffffff808437812ULL, 0x000fca00078ee243ULL,
0x0000001043437824ULL, 0x000fe200078e0202ULL, 0x00000033ff047212ULL, 0x004fc800078e33ffULL,
0xfffffff845457812ULL, 0x000fe400078ee204ULL, 0x0000000733047812ULL, 0x000fe200078ec0ffULL,
0x0000002c052c7220ULL, 0x042fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002805287220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x050fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000906097220ULL, 0x000fe20000410000ULL, 0x0000000f05057220ULL, 0x000fe20000410000ULL,
0x0000000833067824ULL, 0x000fe200078e00ffULL, 0x000000121111723eULL, 0x000fc400000000ffULL,
0x0000000e0909723eULL, 0x000fe400000000ffULL, 0x000000100505723eULL, 0x000fe400000000ffULL,
0xfffffff806077812ULL, 0x000fe400078ee233ULL, 0x0000000104067812ULL, 0x040fe400078e3cffULL,
0x0000000204087812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x00000003040e7812ULL, 0x040fe200078e3cffULL, 0x00000008330d7824ULL, 0x040fe200078e0206ULL,
0x0000000404107812ULL, 0x040fe200078e3cffULL, 0x00000008330f7824ULL, 0x040fe200078e0208ULL,
0x0000000504127812ULL, 0x040fe200078e3cffULL, 0x00000008332d7824ULL, 0x040fe200078e020eULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x00000008332f7824ULL, 0x000fe200078e0210ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x0000000833317824ULL, 0x000fe200078e0212ULL,
0x0000000741167812ULL, 0x000fe200078ec0ffULL, 0x0000000833337824ULL, 0x000fe200078e0204ULL,
0x000000181717723eULL, 0x000fe200000000ffULL, 0x0000000841187824ULL, 0x000fe200078e00ffULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x0000000403147824ULL, 0x000fe200078e00ffULL,
0x0000000116047812ULL, 0x040fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0202ULL,
0x0000000216067812ULL, 0x040fe200078e3cffULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0x0000000316087812ULL, 0x040fe200078e3cffULL, 0x0000000841377824ULL, 0x040fe200078e0204ULL,
0x00000004160e7812ULL, 0x040fe200078e3cffULL, 0x0000000841397824ULL, 0x040fe200078e0206ULL,
0x0000000516107812ULL, 0x040fe200078e3cffULL, 0x00000008413b7824ULL, 0x040fe200078e0208ULL,
0x0000000616127812ULL, 0x000fe200078e3cffULL, 0x00000008413d7824ULL, 0x000fe200078e020eULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x00000008413f7824ULL, 0x040fe200078e0210ULL,
0xfffffff818357812ULL, 0x000fe200078ee241ULL, 0x0000000841417824ULL, 0x000fe200078e0212ULL,
0x0000000c14207812ULL, 0x000fe200078ec0ffULL, 0x0000001045067824ULL, 0x100fe200078e0202ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000000120047824ULL, 0x000fe200078e0207ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000001031317824ULL, 0x100fe200078e0202ULL,
0x0000002b04007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000001037377824ULL, 0x100fe200078e0202ULL,
0x000000222121723eULL, 0x000fe200000000ffULL, 0x0000001039397824ULL, 0x100fe200078e0202ULL,
0x0000001a1919723eULL, 0x000fe200000000ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0202ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x000000103d3d7824ULL, 0x000fc400078e0202ULL,
0x000000103f3f7824ULL, 0x100fe400078e0202ULL, 0x0000001041417824ULL, 0x000fe400078e0202ULL,
0x0000000120147824ULL, 0x040fe400078e0206ULL, 0x0000000120027824ULL, 0x040fe400078e020dULL,
0x0000000120067824ULL, 0x040fe400078e020fULL, 0x0000000120087824ULL, 0x040fe200078e022dULL,
0x0000002702007388ULL, 0x0005e20000000800ULL, 0x00000001200e7824ULL, 0x000fc400078e022fULL,
0x0000000120107824ULL, 0x040fe200078e0231ULL, 0x0000002306007388ULL, 0x000fe20000000800ULL,
0x0000000120127824ULL, 0x040fe400078e0233ULL, 0x0000000120167824ULL, 0x040fe200078e0235ULL,
0x0000001f08007388ULL, 0x000fe20000000800ULL, 0x0000000120187824ULL, 0x040fe400078e0237ULL,
0x0000000120047824ULL, 0x042fe200078e0239ULL, 0x0000001b0e007388ULL, 0x000fe20000000800ULL,
0x00000001201a7824ULL, 0x000fc400078e023bULL, 0x00000001201c7824ULL, 0x040fe200078e023dULL,
0x0000001710007388ULL, 0x000fe20000000800ULL, 0x0000000120227824ULL, 0x040fe400078e0243ULL,
0x00000001201e7824ULL, 0x040fe200078e023fULL, 0x0000001312007388ULL, 0x000fe20000000800ULL,
0x0000000120207824ULL, 0x000fe400078e0241ULL, 0x000000010c077824ULL, 0x000fe200078e0203ULL,
0x0000000514007388ULL, 0x000fe60000000800ULL, 0x0000001007027824ULL, 0x004fe200078e0200ULL,
0x0000002916007388ULL, 0x000fe80000000800ULL, 0x0000002518007388ULL, 0x000fe80000000800ULL,
0x0000002104007388ULL, 0x000fe80000000800ULL, 0x0000001d1a007388ULL, 0x000fe80000000800ULL,
0x000000191c007388ULL, 0x000fe80000000800ULL, 0x000000151e007388ULL, 0x000fe80000000800ULL,
0x0000001120007388ULL, 0x000fe80000000800ULL, 0x0000000922007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000020c7984ULL, 0x000e680000000c00ULL,
0x0004000002287984ULL, 0x000ea80000000c00ULL, 0x0008000002247984ULL, 0x000f280000000c00ULL,
0x000c000002047984ULL, 0x000f620000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x004fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fc40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x000000270f0f7230ULL, 0x010fe40000000000ULL,
0x000000260e0e7230ULL, 0x000fe40000000000ULL, 0x000000250d0d7230ULL, 0x000fe40000000000ULL,
0x000000240c0c7230ULL, 0x000fe40000000000ULL, 0x000000072b2b7230ULL, 0x020fc40000000000ULL,
0x000000062a2a7230ULL, 0x000fe20000000000ULL, 0x0000000c02007388ULL, 0x0003e20000000c00ULL,
0x0000000529297230ULL, 0x000fe40000000000ULL, 0x0000000428287230ULL, 0x000fca0000000000ULL,
0x0004002802007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x002e620000002600ULL, 0x00000020031d7810ULL, 0x040fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000f220000002700ULL, 0x00000040031f7810ULL, 0x040fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe20000011603ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x0000006003217810ULL, 0x000fe20007ffe0ffULL,
0x000000080a1a7824ULL, 0x040fe200078e00ffULL, 0x00000003ff097819ULL, 0x000fe2000001161dULL,
0x000000080a1e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0b7819ULL, 0x000fc4000001161fULL,
0x00000003ff187819ULL, 0x000fe40000011621ULL, 0x0000000709047812ULL, 0x000fe400078e481dULL,
0x000000070b067812ULL, 0x000fe400078e481fULL, 0x00000007180c7812ULL, 0x000fe400078e4821ULL,
0x0ffffff804077812ULL, 0x000fe400078ef81dULL, 0x0ffffff8060d7812ULL, 0x000fe200078ef81fULL,
0x0000001019057824ULL, 0x002fe200078e00ffULL, 0x0ffffff80c0f7812ULL, 0x000fe200078ef821ULL,
0x00000010070c7824ULL, 0x100fe200078e0200ULL, 0x00000004050472a4ULL, 0x010fe2000f8e023fULL,
0x000000100d107824ULL, 0x004fe200078e0200ULL, 0xfffffff005087812ULL, 0x000fe200078ee202ULL,
0x000000100f147824ULL, 0x000fe200078e0200ULL, 0x0000000702027812ULL, 0x000fe200078e4803ULL,
0x000000000c0c7984ULL, 0x000fe20000000c00ULL, 0x0000000408087c10ULL, 0x000fc4000ff1e0ffULL,
0x0ffffff802057812ULL, 0x000fe200078ef803ULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x000000080a027824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x00000010191a7824ULL, 0x000fe200078e00ffULL, 0x0000000014147984ULL, 0x000fe20000000c00ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0xfffffff8021d7812ULL, 0x000fe200078ee21dULL,
0x000000080a007824ULL, 0x000fe200078e00ffULL, 0xfffffff01a0b7812ULL, 0x000fe400078ee20bULL,
0xfffffff81e217812ULL, 0x000fe200078ee221ULL, 0x0000000005047984ULL, 0x000e620000000c00ULL,
0xfffffff8001b7812ULL, 0x000fe200078ee203ULL, 0x0000001019007824ULL, 0x000fe200078e00ffULL,
0x000000040b0b7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001019197824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0008027a11ULL, 0x000fe200078040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0xfffffff000097812ULL, 0x000fe400078ee209ULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x00005b0008037a11ULL, 0x000fe400000f4403ULL,
0x0000000409097c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000418007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a000b0a7a11ULL, 0x000fc600078240ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005a0009087a11ULL, 0x040fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x040fe400078440ffULL,
0x00005b0009097a11ULL, 0x000fe400000f441cULL, 0x00005b000b0b7a11ULL, 0x000fe400008f441aULL,
0x00005b0000197a11ULL, 0x000fe200010f4419ULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x000000101f0a7825ULL, 0x000fc800078e000aULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x002fe8000c101d08ULL, 0x0000000c08007986ULL, 0x000fe8000c101d08ULL,
0x000000100a007986ULL, 0x000fe8000c101d08ULL, 0x0000001418007986ULL, 0x000fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff067624ULL, 0x000fe200078e00ffULL,
0x03ffffff44357812ULL, 0x000fe200078ec0ffULL, 0x00006900ff077624ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000000446357824ULL, 0x040fe200078e0235ULL,
0x0000000806347981ULL, 0x000368000c1e9900ULL, 0x000000023500720cULL, 0x000fe40003f06070ULL,
0x0000000146087810ULL, 0x000fd60007ffe0ffULL, 0x0000000213048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e0235ULL, 0x0000600004048625ULL, 0x000fca00078e0011ULL,
0x0000000804338981ULL, 0x000362000c1e1900ULL, 0x000000030800720cULL, 0x000fe20003f06070ULL,
0x0000004030307824ULL, 0x000fe400078e00ffULL, 0x000000401d147824ULL, 0x000fe400078e00ffULL,
0x0000004044317824ULL, 0x000fd000078e00ffULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x002e620000000000ULL, 0x0000003314147224ULL, 0x020fe200078e0230ULL,
0x0000100044177811ULL, 0x000fe200078e68ffULL, 0x00000080ff1c7424ULL, 0x000fe400078e00ffULL,
0x0000010046097824ULL, 0x000fca00078e0231ULL, 0x0000000900087217ULL, 0x000fca0007800000ULL,
0x0000000108127824ULL, 0x000fe200078e0a09ULL, 0x00000002ff217819ULL, 0x102fe20000011610ULL,
0x0000001010237824ULL, 0x000fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe40000011610ULL,
0x0000003f21057812ULL, 0x040fe400078ec0ffULL, 0x0000001021257810ULL, 0x040fe40007ffe0ffULL,
0x00000008210f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114057824ULL, 0x000fe200078e0205ULL,
0x0000003f250b7812ULL, 0x000fc400078ec0ffULL, 0x0000003023237812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x080fe200078e001cULL, 0x0000003f0f077812ULL, 0x000fe400078ec0ffULL,
0x0000001821277810ULL, 0x040fe20007ffe0ffULL, 0x00000001140b7824ULL, 0x000fe200078e020bULL,
0x00000023040a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000114077824ULL, 0x000fe200078e0207ULL,
0x00000020211b7810ULL, 0x000fe20007ffe0ffULL, 0x00005e000b087625ULL, 0x000fe200078e001cULL,
0x0000000315157812ULL, 0x000fc400078e4810ULL, 0x00000028211d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000003f27057812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e001cULL, 0x0000002308087210ULL, 0x080fe40007f3e0ffULL,
0x00000030211f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114057824ULL, 0x000fe200078e0205ULL,
0x00000023060c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000120f00720cULL, 0x000fe20003f26070ULL, 0x00005e0005047625ULL, 0x000fe200078e001cULL,
0x000000122500720cULL, 0x000fc40003fa6070ULL, 0x000000122700720cULL, 0x080fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x0000003f1b077812ULL, 0x000fe200078ec0ffULL,
0x000000040f167824ULL, 0x000fe200078e00ffULL, 0x00000023040e7210ULL, 0x000fe20007f5e0ffULL,
0x000000041f187824ULL, 0x000fe200078e00ffULL, 0x000000122100720cULL, 0x000fe20003f06070ULL,
0x0000000114077824ULL, 0x000fe200078e0207ULL, 0x0ffffffc15047812ULL, 0x000fe200078ef810ULL,
0x000000ffff0f7224ULL, 0x000fe200010e0605ULL, 0x0000003f1d057812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e001cULL, 0x0000003821217810ULL, 0x000fc40007ffe0ffULL,
0x000000121d00720cULL, 0x040fe20003f46070ULL, 0x0000001004197824ULL, 0x000fe200078e0217ULL,
0x0000002306107210ULL, 0x000fe20007f7e0ffULL, 0x0000000114057824ULL, 0x000fe200078e0205ULL,
0xfffffffc16067812ULL, 0x100fe200078ee215ULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e2000c101c48ULL,
0x00005e0005047625ULL, 0x000fe200078e001cULL, 0x000000122100720cULL, 0x080fe40003f06070ULL,
0xfffffffc16167812ULL, 0x000fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200018e0607ULL,
0x000000121b00720cULL, 0x000fe20003f66070ULL, 0x0000001006077824ULL, 0x000fe200078e0217ULL,
0xfffffffc18187812ULL, 0x000fe200078ee215ULL, 0x00000004211a7824ULL, 0x000fe200078e00ffULL,
0x0000003f1f0b7812ULL, 0x002fc400078ec0ffULL, 0x000000000c077faeULL, 0x0003e2000c901c48ULL,
0x00000023040a7210ULL, 0x000fe20007fde0ffULL, 0x00000010181d7824ULL, 0x000fe200078e0217ULL,
0x000000121f00720cULL, 0x000fe20003f26070ULL, 0x0000000114047824ULL, 0x000fe200078e020bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee215ULL, 0x000000ffff0b7224ULL, 0x000fe400030e0605ULL,
0x00005e0004047625ULL, 0x000fe200078e001cULL, 0x0000003f21077812ULL, 0x002fc600078ec0ffULL,
0x00000004250c7824ULL, 0x000fe200078e00ffULL, 0x0000002304047210ULL, 0x000fe20007fde0ffULL,
0x0000000427127824ULL, 0x000fe400078e00ffULL, 0x0000000114077824ULL, 0x000fe200078e0207ULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee215ULL, 0x000000041b147824ULL, 0x000fe200078e00ffULL,
0xfffffffc12127812ULL, 0x000fe200078ee215ULL, 0x00005e0007067625ULL, 0x000fc600078e001cULL,
0xfffffffc14147812ULL, 0x000fe200078ee215ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x000000100c0d7824ULL, 0x100fe400078e0217ULL,
0x0000001012157824ULL, 0x100fe400078e0217ULL, 0x0000001014197824ULL, 0x100fe200078e0217ULL,
0x00000000080d7faeULL, 0x0003e2000e901c48ULL, 0x00000010161b7824ULL, 0x100fe400078e0217ULL,
0x000000101a177824ULL, 0x000fe200078e0217ULL, 0x000000000e157faeULL, 0x0003e2000e101c48ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0000000010197faeULL, 0x0003e8000d901c48ULL,
0x000000000a1b7faeULL, 0x0003e8000d101c48ULL, 0x00000000041d7faeULL, 0x0003e8000c901c48ULL,
0x0000000006177faeULL, 0x0003e2000c101c48ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000003314147224ULL, 0x020fe200078e0230ULL,
0x00000002ff057819ULL, 0x102fe20000011604ULL, 0x0000001004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc40000011604ULL, 0x0000003f05097812ULL, 0x040fe400078ec0ffULL,
0x00000010050a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000805087810ULL, 0x040fe40007ffe0ffULL,
0x00000018050c7810ULL, 0x040fe40007ffe0ffULL, 0x00000020050e7810ULL, 0x040fe40007ffe0ffULL,
0x0000002805107810ULL, 0x000fc40007ffe0ffULL, 0x0000003005127810ULL, 0x040fe40007ffe0ffULL,
0x0000003805167810ULL, 0x000fe20007ffe0ffULL, 0x0000000114057824ULL, 0x000fe200078e0209ULL,
0x0000003f0a0b7812ULL, 0x040fe200078ec0ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x0000003f08097812ULL, 0x040fe200078ec0ffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x0000003f0c0f7812ULL, 0x000fe200078ec0ffULL, 0x00000001140d7824ULL, 0x000fe200078e020bULL,
0x0000003f0e117812ULL, 0x000fe200078ec0ffULL, 0x0000000114097824ULL, 0x000fe200078e0209ULL,
0x0000003f10157812ULL, 0x000fe200078ec0ffULL, 0x00000001140f7824ULL, 0x000fe200078e020fULL,
0x0000003f12177812ULL, 0x000fe200078ec0ffULL, 0x0000000114117824ULL, 0x000fe200078e0211ULL,
0x0000003f16197812ULL, 0x000fe200078ec0ffULL, 0x0000000114157824ULL, 0x040fe200078e0215ULL,
0x0000000307077812ULL, 0x100fe200078e4804ULL, 0x0000000114257824ULL, 0x000fe200078e0217ULL,
0x00001000440b7811ULL, 0x000fe200078e68ffULL, 0x0000000114297824ULL, 0x000fe200078e0219ULL,
0x0ffffffc07047812ULL, 0x000fe200078ef804ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x100fe200078ee207ULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee207ULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee207ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee207ULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0xfffffffc10107812ULL, 0x100fe200078ee207ULL, 0x00000080ff147424ULL, 0x000fe200078e00ffULL,
0xfffffffc12127812ULL, 0x000fe200078ee207ULL, 0x0000001004197824ULL, 0x000fe200078e020bULL,
0xfffffffc16167812ULL, 0x000fe200078ee207ULL, 0x00005e0005047625ULL, 0x000fe200078e0014ULL,
0x0000003006177812ULL, 0x000fc600078ec0ffULL, 0x00000010081b7824ULL, 0x100fe200078e020bULL,
0x0000001704047210ULL, 0x000fe20007f1e0ffULL, 0x000000100a1d7824ULL, 0x100fe400078e020bULL,
0x000000100c1f7824ULL, 0x100fe400078e020bULL, 0x000000100e217824ULL, 0x100fe400078e020bULL,
0x0000001010237824ULL, 0x100fe400078e020bULL, 0x0000001012277824ULL, 0x000fc400078e020bULL,
0x00000010162b7824ULL, 0x000fe400078e020bULL, 0x00005e000f0a7625ULL, 0x000fc800078e0014ULL,
0x00005e0009067625ULL, 0x000fc800078e0014ULL, 0x00005e000d087625ULL, 0x000fe200078e0014ULL,
0x0000001706067210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000170a0a7210ULL, 0x080fe20007f1e0ffULL, 0x00005e00110c7625ULL, 0x080fe200078e0014ULL,
0x0000001708087210ULL, 0x000fe40007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004197faeULL, 0x0003e2000b901c48ULL, 0x00005e00150e7625ULL, 0x000fc800078e0014ULL,
0x00005e0025107625ULL, 0x000fc800078e0014ULL, 0x00005e0029147625ULL, 0x000fc800078e0014ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000170c0c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000170e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001710107210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000001714147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x00000000061b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff117224ULL, 0x000fc400010e0611ULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x00000000081d7faeULL, 0x0003e8000b901c48ULL, 0x000000000a1f7faeULL, 0x0003e8000b901c48ULL,
0x000000000c217faeULL, 0x0003e8000b901c48ULL, 0x000000000e237faeULL, 0x0003e8000b901c48ULL,
0x0000000010277faeULL, 0x0003e8000b901c48ULL, 0x00000000142b7faeULL, 0x0003e4000b901c48ULL,
0x00f60400ff047984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000004ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000034400780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002044047824ULL, 0x002fc800078e0205ULL, 0x0000001004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7804ULL, 0x0000000707077812ULL, 0x000fc600078e7804ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001405007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x00f60400ff047984ULL, 0x000ea40000000800ULL, 0x8000000004ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0022a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000327919ULL, 0x000ea20000000000ULL, 0x3db504f334347820ULL, 0x000fe20000410000ULL,
0x0000640013367a24ULL, 0x000fe200078e02ffULL, 0xffffffff03397810ULL, 0x000fe20007ffe0ffULL,
0x0000001044377824ULL, 0x000fe200078e00ffULL, 0x00007610ff387816ULL, 0x000fe20000000038ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fe4000800063fULL, 0x00000100463d7824ULL, 0x000fe200078e0231ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003d0000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x028fea0003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e003bULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x000000013a0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000bb000007945ULL, 0x000fe20003800000ULL, 0x00000001093b7812ULL, 0x000fc400078e0cffULL,
0x00000001ff0b7819ULL, 0x000fe4000001160aULL, 0x000000020a00780cULL, 0x040fe40003f06070ULL,
0x000000010a4a7812ULL, 0x000fe200078ec0ffULL, 0x000003000b247a24ULL, 0x000fca00078e0246ULL,
0x0000000124087810ULL, 0x000fc80007ffe0ffULL, 0x000000030800720cULL, 0x000fe20003f26070ULL,
0x000000ffff087224ULL, 0x000fe400078e003aULL, 0x000000ffff3a7224ULL, 0x000fd400078e000aULL,
0x000005e000009947ULL, 0x020fea0003800000ULL, 0x00000100240b7824ULL, 0x000fe200078e0231ULL,
0x00000002ff3f7819ULL, 0x004fe20000011632ULL, 0x00000004332c7c24ULL, 0x000fe4000f8e0230ULL,
0x000000044a417824ULL, 0x000fe200078e00ffULL, 0x0000000b000a7217ULL, 0x000fe20007800000ULL,
0x0000000244277824ULL, 0x000fe200078e023bULL, 0x000000083f2d7810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff4f7424ULL, 0x000fe200078e00ffULL, 0x0000003f3f257812ULL, 0x000fe200078ec0ffULL,
0x000000010a267824ULL, 0x000fe200078e0a0bULL, 0x00000003ff0b7819ULL, 0x100fe20000011632ULL,
0x000000042d3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc41417812ULL, 0x100fe200078ee232ULL,
0x000000012c0a7824ULL, 0x000fe200078e0225ULL, 0x000000030b437812ULL, 0x000fc400078e4832ULL,
0x0000003f2d0b7812ULL, 0x000fe400078ec0ffULL, 0x000000263f00720cULL, 0x080fe40003f26070ULL,
0x000000262d00720cULL, 0x000fe20003f46070ULL, 0x000000012c247824ULL, 0x000fe200078e020bULL,
0x0000100027277811ULL, 0x000fe200078e60ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e004fULL,
0x0ffffffc432e7812ULL, 0x000fe400078ef832ULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee243ULL,
0x00005e0024247625ULL, 0x000fe200078e004fULL, 0x000000103f457810ULL, 0x000fc40007ffe0ffULL,
0x000000183f477810ULL, 0x040fe20007ffe0ffULL, 0x000000102e2d7824ULL, 0x000fe200078e0227ULL,
0x000000203f497810ULL, 0x000fe20007ffe0ffULL, 0x00000010410a7825ULL, 0x000fe200078e000aULL,
0x000000283f4b7810ULL, 0x040fe40007ffe0ffULL, 0x000000303f4d7810ULL, 0x040fe20007ffe0ffULL,
0x000000103c2f7824ULL, 0x000fe200078e0227ULL, 0x000000383f517810ULL, 0x000fe20007ffe0ffULL,
0x0000001041247825ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2d7faeULL, 0x0003e2000c901c48ULL, 0x0000003f4d3f7812ULL, 0x000fc400078ec0ffULL,
0x0000003f51537812ULL, 0x000fe200078ec0ffULL, 0x00000000242f7faeULL, 0x0005e2000d101c48ULL,
0x000000264500720cULL, 0x080fe20003f26070ULL, 0x000000012c427824ULL, 0x040fe200078e023fULL,
0x000000264700720cULL, 0x080fe20003f46070ULL, 0x000000012c4c7824ULL, 0x040fe200078e0253ULL,
0x000000264900720cULL, 0x0c0fe20003f66070ULL, 0x00000004493c7824ULL, 0x000fe200078e00ffULL,
0x000000264b00720cULL, 0x0c0fe20003f86070ULL, 0x000000044b407824ULL, 0x000fe200078e00ffULL,
0x0000003f450b7812ULL, 0x002fe200078ec0ffULL, 0x000000044d487824ULL, 0x000fe200078e00ffULL,
0x0000003f492d7812ULL, 0x000fe200078ec0ffULL, 0x0000000445247824ULL, 0x004fe200078e00ffULL,
0x0000003f47257812ULL, 0x000fe200078ec0ffULL, 0x000000012c0a7824ULL, 0x040fe200078e020bULL,
0x0000003f4b2f7812ULL, 0x000fe200078ec0ffULL, 0x000000012c2e7824ULL, 0x040fe200078e022dULL,
0x000000264d00720cULL, 0x080fe20003fa6070ULL, 0x00000004514e7824ULL, 0x040fe200078e00ffULL,
0x000000265100720cULL, 0x000fe20003fc6070ULL, 0x000000012c267824ULL, 0x000fe200078e0225ULL,
0xfffffffc24247812ULL, 0x000fe200078ee243ULL, 0x000000012c3e7824ULL, 0x000fe200078e022fULL,
0xfffffffc3c3c7812ULL, 0x100fe200078ee243ULL, 0x00000004472c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40407812ULL, 0x100fe200078ee243ULL, 0x00005e000a0a7625ULL, 0x000fe200078e004fULL,
0xfffffffc48487812ULL, 0x000fc400078ee243ULL, 0xfffffffc2c2c7812ULL, 0x000fe200078ee243ULL,
0x000000103c477824ULL, 0x000fe200078e0227ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee243ULL,
0x0000001024437824ULL, 0x100fe400078e0227ULL, 0x000000102c457824ULL, 0x100fe400078e0227ULL,
0x0000001040497824ULL, 0x100fe400078e0227ULL, 0x00000010484b7824ULL, 0x100fe400078e0227ULL,
0x000000104e4d7824ULL, 0x000fc400078e0227ULL, 0x00005e0026247625ULL, 0x000fc800078e004fULL,
0x00005e002e267625ULL, 0x000fc800078e004fULL, 0x00005e003e2c7625ULL, 0x000fc800078e004fULL,
0x00005e00422e7625ULL, 0x000fc800078e004fULL, 0x00005e004c3e7625ULL, 0x000fc800078e004fULL,
0x00000010410a7825ULL, 0x000fc800078e000aULL, 0x0000001041247825ULL, 0x040fe200078e0024ULL,
0x000000000a437faeULL, 0x0003e6000c901c48ULL, 0x0000001041267825ULL, 0x040fe200078e0026ULL,
0x0000000024457faeULL, 0x0003e6000d101c48ULL, 0x00000010412c7825ULL, 0x040fe200078e002cULL,
0x0000000026477faeULL, 0x0003e6000d901c48ULL, 0x00000010412e7825ULL, 0x040fe200078e002eULL,
0x000000002c497faeULL, 0x0003e6000e101c48ULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0x000000002e4b7faeULL, 0x0003e8000e901c48ULL, 0x000000003e4d7faeULL, 0x0003e2000f101c48ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff0a7819ULL, 0x004fe20000011632ULL,
0x00000004330b7c24ULL, 0x000fc4000f8e0230ULL, 0x000000044a457824ULL, 0x000fe200078e00ffULL,
0x0000003f0a247812ULL, 0x040fe200078ec0ffULL, 0x00000080ff437424ULL, 0x000fe200078e00ffULL,
0x000000080a267810ULL, 0x040fe40007ffe0ffULL, 0x000000100a2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000180a2f7810ULL, 0x040fe40007ffe0ffULL, 0x000000200a3f7810ULL, 0x040fe40007ffe0ffULL,
0x000000280a417810ULL, 0x000fc40007ffe0ffULL, 0x000000300a477810ULL, 0x040fe40007ffe0ffULL,
0x000000380a497810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e0224ULL,
0x0000003f26247812ULL, 0x040fe200078ec0ffULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x0000003f2d2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000449567824ULL, 0x000fe200078e00ffULL,
0x0000003f2f3c7812ULL, 0x000fe200078ec0ffULL, 0x000000010b2c7824ULL, 0x000fe200078e0224ULL,
0x0000003f3f407812ULL, 0x000fe200078ec0ffULL, 0x000000010b2e7824ULL, 0x000fe200078e022eULL,
0x0000003f41487812ULL, 0x000fe200078ec0ffULL, 0x000000010b3e7824ULL, 0x000fe200078e023cULL,
0x0000003f474e7812ULL, 0x000fe200078ec0ffULL, 0x000000010b427824ULL, 0x000fe200078e0240ULL,
0x0000003f49527812ULL, 0x000fe200078ec0ffULL, 0x000000010b4c7824ULL, 0x000fe200078e0248ULL,
0xfffffffc45457812ULL, 0x000fe200078ee232ULL, 0x000000010b507824ULL, 0x000fc400078e024eULL,
0x000000010b547824ULL, 0x000fe200078e0252ULL, 0x00000003ff0b7819ULL, 0x100fe20000011632ULL,
0x0000000244247824ULL, 0x000fe400078e023bULL, 0x000000042d3c7824ULL, 0x000fe200078e00ffULL,
0x000000030b257812ULL, 0x100fe200078e4832ULL, 0x000000042f407824ULL, 0x000fe200078e00ffULL,
0x0000100024277811ULL, 0x000fe200078e60ffULL, 0x000000043f487824ULL, 0x000fe200078e00ffULL,
0x0ffffffc25247812ULL, 0x000fe200078ef832ULL, 0x00000004414e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc26267812ULL, 0x100fe200078ee225ULL, 0x0000000447527824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c3c7812ULL, 0x100fe200078ee225ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0043ULL,
0xfffffffc40407812ULL, 0x000fc400078ee225ULL, 0xfffffffc48487812ULL, 0x000fe200078ee225ULL,
0x0000001024477824ULL, 0x000fe200078e0227ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee225ULL,
0x0000001026497824ULL, 0x000fe200078e0227ULL, 0xfffffffc52527812ULL, 0x000fe200078ee225ULL,
0x000000103c4b7824ULL, 0x000fe200078e0227ULL, 0xfffffffc56567812ULL, 0x000fe200078ee225ULL,
0x00000010404d7824ULL, 0x100fe400078e0227ULL, 0x00000010484f7824ULL, 0x100fe400078e0227ULL,
0x000000104e517824ULL, 0x000fc400078e0227ULL, 0x0000001052537824ULL, 0x100fe400078e0227ULL,
0x0000001056557824ULL, 0x000fe400078e0227ULL, 0x00005e002c247625ULL, 0x000fc800078e0043ULL,
0x00005e002e267625ULL, 0x000fc800078e0043ULL, 0x00005e003e2c7625ULL, 0x000fc800078e0043ULL,
0x00005e00422e7625ULL, 0x000fc800078e0043ULL, 0x00005e004c3e7625ULL, 0x000fc800078e0043ULL,
0x00000010450a7825ULL, 0x000fc800078e000aULL, 0x00005e0050407625ULL, 0x080fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a477faeULL, 0x0003e6000b901c48ULL,
0x00005e0054427625ULL, 0x000fc800078e0043ULL, 0x0000001045247825ULL, 0x000fc800078e0024ULL,
0x0000001045267825ULL, 0x040fe200078e0026ULL, 0x0000000024497faeULL, 0x0003e6000b901c48ULL,
0x00000010452c7825ULL, 0x040fe200078e002cULL, 0x00000000264b7faeULL, 0x0003e6000b901c48ULL,
0x00000010452e7825ULL, 0x040fe200078e002eULL, 0x000000002c4d7faeULL, 0x0003e6000b901c48ULL,
0x00000010453e7825ULL, 0x040fe200078e003eULL, 0x000000002e4f7faeULL, 0x0003e6000b901c48ULL,
0x0000001045407825ULL, 0x040fe200078e0040ULL, 0x000000003e517faeULL, 0x0003e6000b901c48ULL,
0x0000001045427825ULL, 0x000fe200078e0042ULL, 0x0000000040537faeULL, 0x0003e8000b901c48ULL,
0x0000000042557faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff4a00720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x002fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000003000b357a24ULL, 0x000fca00078e0235ULL,
0x000000023500720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x00000002360a7824ULL, 0x000fc800078e0235ULL, 0x000060000a0a7625ULL, 0x000fca00078e000bULL,
0x000000080a337981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002032437810ULL, 0x002fe20007ffe0ffULL,
0x0000000244407824ULL, 0x000fe200078e0209ULL, 0xfffffff8320b7812ULL, 0x000fe200078ec0ffULL,
0x0000000808457824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000000070b427812ULL, 0x100fe400078ef832ULL,
0x0000000743437812ULL, 0x000fe400078ef832ULL, 0x0000000732097812ULL, 0x000fc400078ec0ffULL,
0x00000001ff3f7819ULL, 0x000fe40000011642ULL, 0x00000001ff417819ULL, 0x000fe40000011643ULL,
0x0000100040407811ULL, 0x000fe400078e60ffULL, 0x00000008093e7812ULL, 0x000fe400078ef832ULL,
0x000000033f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000000341417812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003c3f097212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003c41247212ULL, 0x000fc400078e3cffULL,
0x00000045327b7211ULL, 0x000fe200078fe0ffULL, 0x0000000442097824ULL, 0x000fe200078e0209ULL,
0x0000000445457810ULL, 0x000fe20007ffe0ffULL, 0x0000000443257824ULL, 0x000fe400078e0224ULL,
0x0000001009097824ULL, 0x100fe400078e0240ULL, 0x0000001025257824ULL, 0x000fc800078e0240ULL,
0x000000000908783bULL, 0x000e680000000200ULL, 0x000000002524783bULL, 0x000ea20000000200ULL,
0x00000018ff6c7819ULL, 0x002fe20000011408ULL, 0x00010000082c7824ULL, 0x040fe200078e00ffULL,
0x0000888008717816ULL, 0x040fe200000000ffULL, 0x0000010008087824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011409ULL, 0x00010000092d7824ULL, 0x040fe200078e00ffULL,
0x0000888009727816ULL, 0x040fe200000000ffULL, 0x0000010009097824ULL, 0x000fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff697819ULL, 0x000fc4000001140aULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x000088800a6f7816ULL, 0x000fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe2000001140bULL,
0x0000000800777306ULL, 0x0003e20000200c00ULL, 0x000088800b6d7816ULL, 0x000fe400000000ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff497819ULL, 0x004fe20000011424ULL, 0x0000000900797306ULL, 0x0005e20000200c00ULL,
0x000100000a087824ULL, 0x002fe200078e00ffULL, 0x00008880246b7816ULL, 0x000fe200000000ffULL,
0x000001000a0a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011425ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x000100000b097824ULL, 0x044fe200078e00ffULL, 0x0000002c007a7306ULL, 0x000fe20000200c00ULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x0000888025677816ULL, 0x000fc400000000ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000000a00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe40000011426ULL,
0x0000888026637816ULL, 0x000fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe40000011427ULL,
0x00008880275a7816ULL, 0x000fe200000000ffULL, 0x0000000900747306ULL, 0x0005e20000200c00ULL,
0x000000013c0a7810ULL, 0x002fc40007ffe0ffULL, 0x000000023c3c7810ULL, 0x000fc80007ffe0ffULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x0000000b00737306ULL, 0x0003e20000200c00ULL,
0x0000000a3f097212ULL, 0x084fe400078e3cffULL, 0x0000000a410a7212ULL, 0x000fca00078e3cffULL,
0x0000002d00757306ULL, 0x0005e20000200c00ULL, 0x00000004420b7824ULL, 0x002fe400078e0209ULL,
0x0001000025097824ULL, 0x000fe400078e00ffULL, 0x000000100b0b7824ULL, 0x000fe400078e0240ULL,
0x0000010025257824ULL, 0x000fe200078e00ffULL, 0x0000000800767306ULL, 0x0003e20000200c00ULL,
0x00000004434b7824ULL, 0x000fe200078e020aULL, 0x000000000b2c783bULL, 0x004ea20000000200ULL,
0x00000018ff097819ULL, 0x000fc40000011409ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x000000104b0a7824ULL, 0x000fe400078e0240ULL, 0x0000000900687306ULL, 0x000fe20000200c00ULL,
0x0001000024087824ULL, 0x042fe400078e00ffULL, 0x0000010024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002500667306ULL, 0x0003f00000200c00ULL, 0x0000002400707306ULL, 0x0007e20000200c00ULL,
0x000000077b257812ULL, 0x002fc400078e783eULL, 0x000000027b7b7810ULL, 0x000fc60007ffe0ffULL,
0x000000103e257824ULL, 0x040fe200078e0225ULL, 0x000000077b7b7812ULL, 0x000fe200078e783eULL,
0x00000008006e7306ULL, 0x0003e20000200c00ULL, 0x0001000027247824ULL, 0x048fe400078e00ffULL,
0x0000010027277824ULL, 0x000fe400078e00ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000103e7b7824ULL, 0x000fe200078e027bULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000026087824ULL, 0x042fe200078e00ffULL,
0x00000024005d7306ULL, 0x0003e20000200c00ULL, 0x0000010026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x004fc4000001142cULL, 0x00000018ff4c7819ULL, 0x000fe4000001142dULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002700607306ULL, 0x000fe20000200c00ULL,
0x000100002c247824ULL, 0x042fe200078e00ffULL, 0x000088802c537816ULL, 0x040fe200000000ffULL,
0x000001002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802d557816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000002600657306ULL, 0x0003e20000200c00ULL,
0x00000018ff647819ULL, 0x000fe40000011408ULL, 0x000000000a08783bULL, 0x000ea20000000200ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff4d7819ULL, 0x000fe4000001142eULL,
0x0000002400547306ULL, 0x0007e20000200c00ULL, 0x000100002d267824ULL, 0x042fe200078e00ffULL,
0x000088802e597816ULL, 0x000fe200000000ffULL, 0x000001002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001142fULL, 0x00000018ff587819ULL, 0x000fe40000011426ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000002524783bULL, 0x008ee20000000200ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x000088802f5b7816ULL, 0x000fc800000000ffULL,
0x0000002c00567306ULL, 0x0009f00000200c00ULL, 0x0000002d00577306ULL, 0x0003e20000200c00ULL,
0x000100002e2c7824ULL, 0x050fe400078e00ffULL, 0x000001002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000100002f2d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x004fe40000011408ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x00000018ff507819ULL, 0x000fc40000011409ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff527819ULL, 0x000fe4000001140bULL, 0x00000018ff517819ULL, 0x000fe2000001140aULL,
0x0000002c005c7306ULL, 0x0005f00000200c00ULL, 0x0000002d00627306ULL, 0x0009e20000200c00ULL,
0x00005410712c7816ULL, 0x004fce000000007aULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410772d7816ULL, 0x010fe2000000006cULL, 0x00010000086c7824ULL, 0x000fcc00078e00ffULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000002c2428723cULL, 0x008fee0000001828ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00005410722c7816ULL, 0x002fe40000000075ULL,
0x00005410792d7816ULL, 0x000fca000000006aULL, 0x0000004900497306ULL, 0x000e640000200c00ULL,
0x0000002c2420723cULL, 0x000fec0000001820ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x000054106f2c7816ULL, 0x004fe40000000076ULL, 0x00005410782d7816ULL, 0x000fc40000000069ULL,
0x00000018ff6f7819ULL, 0x000fc6000001146cULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x0000541070497816ULL, 0x002fe20000000049ULL, 0x0000002c241c723cULL, 0x000fec000000181cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00005410732d7816ULL, 0x000fe40000000048ULL,
0x000054106b487816ULL, 0x008fca000000006eULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054106d2c7816ULL, 0x004fe20000000074ULL, 0x000000482404723cULL, 0x000fe20000001804ULL,
0x00008880096d7816ULL, 0x000fca00000000ffULL, 0x0000002e005e7306ULL, 0x0003e20000200c00ULL,
0x0000010009497824ULL, 0x000fe200078e00ffULL, 0x0000002c2418723cULL, 0x000fe80000001818ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x00008880082e7816ULL, 0x042fe200000000ffULL, 0x0000010008087824ULL, 0x000fca00078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000004700477306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x004fe2000000004aULL,
0x000100000a4a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000006400647306ULL, 0x000e700000200c00ULL, 0x0000005a005a7306ULL, 0x000eb00000200c00ULL,
0x0000006f00697306ULL, 0x0007e20000200c00ULL, 0x0000541063647816ULL, 0x002fce0000000064ULL,
0x00000008006c7306ULL, 0x0003e20000200c00ULL, 0x00010000096f7824ULL, 0x008fe200078e00ffULL,
0x0000541066097816ULL, 0x000fe20000000061ULL, 0x000000642410723cULL, 0x000fe60000001810ULL,
0x00000018ff487819ULL, 0x000fe4000001146fULL, 0x0000002e006a7306ULL, 0x0007e20000200c00ULL,
0x0000541067087816ULL, 0x002fce0000000068ULL, 0x000000082414723cULL, 0x000fe20000001814ULL,
0x000000107b2e7824ULL, 0x008fe200078e00ffULL, 0x0000002f005f7306ULL, 0x0003ea0000200c00ULL,
0x000088800a087816ULL, 0x000fe400000000ffULL, 0x0000541060097816ULL, 0x000fe20000000047ULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x000000002e2c783bULL, 0x002e6e0000000200ULL,
0x0000000800617306ULL, 0x0005f00000200c00ULL, 0x0000004c004c7306ULL, 0x000f220000200c00ULL,
0x000054105a087816ULL, 0x004fc4000000005dULL, 0x00005410564b7816ULL, 0x008fca000000004bULL,
0x00000008240c723cULL, 0x000fe2000000180cULL, 0x0000004d004d7306ULL, 0x000eac0000200c00ULL,
0x000100000b257824ULL, 0x040fe200078e00ffULL, 0x000088800b247816ULL, 0x040fe200000000ffULL,
0x000001000a097824ULL, 0x000fe200078e00ffULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000000900087306ULL, 0x000fe20000200c00ULL, 0x0000541057577816ULL, 0x010fe4000000004cULL,
0x000054105e4d7816ULL, 0x004fca000000004dULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x000054105f5f7816ULL, 0x008fe4000000004eULL, 0x000054106a4e7816ULL, 0x000fca0000000069ULL,
0x0000002500257306ULL, 0x000eb00000200c00ULL, 0x0000004f004f7306ULL, 0x000ef00000200c00ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541024247816ULL, 0x004fce0000000025ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054106c4f7816ULL, 0x008fce000000004fULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0000004e2c04723cULL, 0x002fee0000001804ULL,
0x0000005300537306ULL, 0x000ff00000200c00ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000005800587306ULL, 0x000e700000200c00ULL, 0x0000005900597306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x0000541055567816ULL, 0x002fce0000000058ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00005410594c7816ULL, 0x004fe2000000005cULL,
0x000000562c20723cULL, 0x040fec0000001820ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x000054105b5e7816ULL, 0x008fe20000000062ULL, 0x0000004c2c1c723cULL, 0x040fec000000181cULL,
0x0000004900497306ULL, 0x000ea40000200c00ULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x0000004a000a7306ULL, 0x0007220000200c00ULL, 0x000054106d487816ULL, 0x002fce0000000048ULL,
0x0000000b00097306ULL, 0x0002620000200c00ULL, 0x00005410534a7816ULL, 0x008fe40000000054ULL,
0x0000541049497816ULL, 0x004fe40000000050ULL, 0x00005410610a7816ULL, 0x010fc6000000000aULL,
0x0000004a2c28723cULL, 0x000fe20000001828ULL, 0x00005410080b7816ULL, 0x002fe40000000051ULL,
0x0000541009257816ULL, 0x000fca0000000052ULL, 0x000000482c14723cULL, 0x040ff00000001814ULL,
0x0000000a2c10723cULL, 0x040ff00000001810ULL, 0x000000242c0c723cULL, 0x000fe2000000180cULL,
0xfffff10000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff097224ULL, 0x000fe200078e003bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe32000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140037097984ULL, 0x000e620000000800ULL, 0x0000002134267220ULL, 0x040fe20000410000ULL,
0x0000000434217220ULL, 0x000fe20000410000ULL, 0x0000ffff38047812ULL, 0x000fe200078ec0ffULL,
0x00000022340a7220ULL, 0x040fe20000410000ULL, 0x00000023340b7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x000fe20000410000ULL, 0x00008880043a7816ULL, 0x000fe200000000ffULL,
0x0000002b34087220ULL, 0x040fe20000410000ULL, 0x0000001834237220ULL, 0x040fe20000410000ULL,
0x0000001934227220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x000fe20000410000ULL,
0x800000003a047824ULL, 0x000fe200078e00ffULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b34187220ULL, 0x040fe20000410000ULL, 0x0000001634197220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000001e34277220ULL, 0x040fe20000410000ULL,
0x0000001f342c7220ULL, 0x040fe20000410000ULL, 0x0000000534057220ULL, 0x040fe20000410000ULL,
0x0000000634067220ULL, 0x040fe20000410000ULL, 0x0000000734077220ULL, 0x040fe20000410000ULL,
0x00000017342d7220ULL, 0x040fe20000410000ULL, 0x00000012342e7220ULL, 0x040fe20000410000ULL,
0x00000013342f7220ULL, 0x040fe20000410000ULL, 0x0000001d34247220ULL, 0x040fe20000410000ULL,
0x00000015341e7220ULL, 0x040fe20000410000ULL, 0x0000001c34257220ULL, 0x040fe20000410000ULL,
0x00000014341f7220ULL, 0x040fe20000410000ULL, 0x00000010341d7220ULL, 0x040fe20000410000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0028ULL, 0x00000011341c7220ULL, 0x040fe20000410000ULL,
0x000000ffff157224ULL, 0x000fe200078e0008ULL, 0x0000000c341b7220ULL, 0x040fe20000410000ULL,
0x000000ffff287224ULL, 0x000fe200078e0020ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0000000d34177220ULL, 0x040fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e001aULL, 0x0000000e340e7220ULL, 0x040fe20000410000ULL,
0x8000000009ff7812ULL, 0x002fe20007804804ULL, 0x000000ffff137224ULL, 0x000fe200078e0018ULL,
0x0000000f340c7220ULL, 0x000fe20000410000ULL, 0x000000ffff107224ULL, 0x000fc400078e0019ULL,
0x000000ffff207224ULL, 0x000fe400078e0005ULL, 0x000000ffff167224ULL, 0x000fe400078e002aULL,
0x000000ffff0a7224ULL, 0x000fe400078e0027ULL, 0x000000ffff097224ULL, 0x000fe400078e002cULL,
0x000000ffff127224ULL, 0x000fe400078e0006ULL, 0x000000ffff117224ULL, 0x000fc400078e0007ULL,
0x000000ffff1a7224ULL, 0x000fe400078e002dULL, 0x000000ffff197224ULL, 0x000fe400078e002eULL,
0x000000ffff187224ULL, 0x000fe200078e002fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000003a3a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x00f6140037057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000780483aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004320c7824ULL, 0x000fe200078e00ffULL, 0x000000394600720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff00c0d7812ULL, 0x000fca00078ec0ffULL,
0x00000080440d7824ULL, 0x000fca00078e020dULL, 0x00f400000d047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000232277824ULL, 0x000fe400078e00ffULL,
0x00000001003d7824ULL, 0x000fc600078e0a3dULL, 0x00000006272a7812ULL, 0x000fc800078ec0ffULL,
0x000000012a2c7812ULL, 0x040fe400078efcffULL, 0x000000082a2e7812ULL, 0x000fe400078efcffULL,
0x0000003d2c00720cULL, 0x080fe40003f26070ULL, 0x000000102a2c7812ULL, 0x000fe400078efcffULL,
0x0000003d2e00720cULL, 0x080fe40003f06070ULL, 0x0000003d2c00720cULL, 0x000fc40003fc6070ULL,
0x000000112a2e7812ULL, 0x040fe400078efcffULL, 0x000000182a2c7812ULL, 0x040fe400078efcffULL,
0x0000003d2a00720cULL, 0x080fe40003f46070ULL, 0x0000003d2e00720cULL, 0x080fe40003fa6070ULL,
0x0000003d2c00720cULL, 0x000fe40003f66070ULL, 0x000000092a3a7812ULL, 0x000fc400078efcffULL,
0x000000192a2e7812ULL, 0x040fe400078efcffULL, 0x000000202a2c7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff29297808ULL, 0x000fc40004800000ULL,
0x0000003d3a00720cULL, 0x080fe40003f86070ULL, 0x0000003d2e00720cULL, 0x080fe40003f46070ULL,
0x0000003d2c00720cULL, 0x000fe40003f26070ULL, 0x000000212a2e7812ULL, 0x040fe400078efcffULL,
0x000000282a2c7812ULL, 0x000fe400078efcffULL, 0xff7fffff14147808ULL, 0x000fc40004000000ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0x0000003d2e00720cULL, 0x080fe40003f06070ULL,
0x0000003d2c00720cULL, 0x000fe40003f86070ULL, 0x000000292a2e7812ULL, 0x000fc400078efcffULL,
0x000000302a2c7812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0x0000003d2e00720cULL, 0x000fc40003fc6070ULL,
0x0000003d2c00720cULL, 0x000fe40003fa6070ULL, 0x000000312a2e7812ULL, 0x040fe400078efcffULL,
0x000000382a2c7812ULL, 0x040fe400078efcffULL, 0x000000392a2a7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff23237808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0x0000003d2e00720cULL, 0x080fe40003f66070ULL, 0x0000003d2c00720cULL, 0x000fc40003f46070ULL,
0x0000003d2a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff20207808ULL, 0x000fe40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40006000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff1a1a7808ULL, 0x000fc40007000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL, 0xff7fffff19197808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0xff7fffff18187808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002b04047209ULL, 0x004fe20007810000ULL, 0x0000001fff3a7424ULL, 0x000fe200078e00ffULL,
0x00000016052a7209ULL, 0x000fe20007810000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x000000152a277209ULL, 0x000fc40007810000ULL,
0x0000002805057209ULL, 0x000fe40007810000ULL, 0x0000001427047209ULL, 0x000fe40007810000ULL,
0x00000026052a7209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fe40007810000ULL,
0x000000252a277209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fc40007810000ULL,
0x00000024272a7209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000232a277209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x00000022272a7209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fc40007810000ULL,
0x000000212a277209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fe40007810000ULL,
0x00000020272a7209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x0000001f2a277209ULL, 0x000fe40007810000ULL, 0x0000001005057209ULL, 0x000fc40007810000ULL,
0x0000001e27047209ULL, 0x000fe40007810000ULL, 0x0000001a052a7209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x000000192a277209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x00000018272a7209ULL, 0x000fc40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000000f2a057209ULL, 0x000fe40007810000ULL,
0x00000017042a7209ULL, 0x000fe40007810000ULL, 0x0000000e053d7209ULL, 0x000fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f002a047f89ULL, 0x0004e400000e0000ULL,
0x000000042a3f7209ULL, 0x008fe20007810000ULL, 0x00000eb27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072e7f89ULL, 0x000e6400000e0000ULL, 0x000000043d2a7209ULL, 0x00efc40007810000ULL,
0x0c201f003f047f89ULL, 0x000e6200000e0000ULL, 0x00000005062c7209ULL, 0x010fc60007810000ULL,
0x0c201f002a057f89ULL, 0x000ea200000e0000ULL, 0x0000002e07277209ULL, 0x000fc60007810000ULL,
0x0c201f002c2d7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00272e7f89ULL, 0x00092200000e0000ULL,
0x000000043f047209ULL, 0x002fe40007810000ULL, 0x000000052a057209ULL, 0x004fe40007810000ULL,
0x0000002d2c067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b042a7820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b052f7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000067886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082aULL, 0x00000029002c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL, 0x0000001c00297308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b0b1c7823ULL, 0x102fe2000001082fULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe2000001082aULL,
0x3fb8aa3b083c7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0e0e7823ULL, 0x000fc4000001082fULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002600077308ULL, 0x000e620000000800ULL,
0x0000002b2c08723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b102b7823ULL, 0x000fcc000001082fULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001c000b7308ULL, 0x0007300000000800ULL,
0x0000001b002d7308ULL, 0x0005e20000000800ULL, 0x3c003c00ff1c7424ULL, 0x008fce00078e00ffULL,
0x00000017002a7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0a1b7823ULL, 0x104fe2000001082fULL,
0x00000028070a723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b12077823ULL, 0x100fe2000001082fULL,
0x000000140b0b723eULL, 0x010fe200000000ffULL, 0x3fb8aa3b11287823ULL, 0x000fc6000001082fULL,
0x0000001d00267308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b09177823ULL, 0x008fe2000001082fULL,
0x000000161509723eULL, 0x000fcc00000000ffULL, 0x00000017003a7308ULL, 0x0005e20000000800ULL,
0x3c003c00ff1d7424ULL, 0x002fce00078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000001c0814723cULL, 0x004fee00000018ffULL, 0x0000002400247308ULL, 0x000e700000000800ULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ea20000000800ULL,
0x000000252410723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b18247823ULL, 0x000fcc000001082fULL,
0x0000001b001b7308ULL, 0x000e700000000800ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x000000232212723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1a227823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b19237823ULL, 0x000fca000001082fULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x0000001b3a11723eULL, 0x002fce00000000ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x0000003c1313723eULL, 0x004fce00000000ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x0000001c1014723cULL, 0x000fee0000001814ULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0x000000212018723eULL, 0x002fce00000000ffULL,
0x0000000700077308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000001f1e1a723eULL, 0x004fce00000000ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x000000072819723eULL, 0x002fe400000000ffULL,
0xfffffffc32077812ULL, 0x000fca00078ec0ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000002b221b723eULL, 0x004fce00000000ffULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x0000001c183c723cULL, 0x000fee0000001814ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000fff147424ULL, 0x000fe200078e00ffULL, 0x0000002d2a16723eULL, 0x000fcc00000000ffULL,
0x0000000e000e7308ULL, 0x000ea20000000800ULL, 0x000000232415723eULL, 0x002fe400000000ffULL,
0x0000000714217219ULL, 0x000fe400000006ffULL, 0x000000262914723eULL, 0x000fe400000000ffULL,
0x00000000211e73a1ULL, 0x000e6200000e8000ULL, 0x00000000210573c4ULL, 0x000ee20000004000ULL,
0x000000272e077209ULL, 0x000fe40007810000ULL, 0x0000000f0e17723eULL, 0x004fce00000000ffULL,
0x0000001c1428723cULL, 0x000fe2000000183cULL, 0x0000000621ff7c12ULL, 0x002fda000f80401eULL,
0x000009f205008947ULL, 0x008ff4000b800000ULL, 0x001c1fff281c7589ULL, 0x0002a400000e0000ULL,
0x00000000210e73a1ULL, 0x000ee200000e8000ULL, 0x00000000210573c4ULL, 0x000f220000004000ULL,
0x0000000000067886ULL, 0x000fe400038e0100ULL, 0x0000000621ff7c12ULL, 0x008fda000f80400eULL,
0x00000a1205008947ULL, 0x010fea000b800000ULL, 0x001c1fff2a1d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff001f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff0e7819ULL, 0x000fe40000011632ULL, 0x0000000c0c417812ULL, 0x002fc400078ec0ffULL,
0x000000070e0f7812ULL, 0x040fe200078ec0ffULL, 0x000000080e247824ULL, 0x040fe200078e00ffULL,
0x0000000eff227212ULL, 0x000fe200078e33ffULL, 0x000000080e207824ULL, 0x000fe200078e00ffULL,
0x0000000332ff7812ULL, 0x000fe2000780c0ffULL, 0x000000080e2d7824ULL, 0x040fe200078e00ffULL,
0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824217812ULL, 0x108fe400078ee20fULL,
0x0000000120237812ULL, 0x100fe200078ef60fULL, 0x000000080e4d7824ULL, 0x000fe200078e00ffULL,
0x0000000220257812ULL, 0x100fe200078ef60fULL, 0x000000080e2f7824ULL, 0x000fe200078e00ffULL,
0x0000000320277812ULL, 0x100fe200078ef60fULL, 0x000000080e3d7824ULL, 0x000fe200078e00ffULL,
0x0000000420297812ULL, 0x000fc400078ef60fULL, 0x00000005202b7812ULL, 0x140fe400078ef60fULL,
0x00000006200f7812ULL, 0x000fe400078ef60fULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL,
0x0000000eff227212ULL, 0x000fe400078e33ffULL, 0x000000070e207812ULL, 0x000fe400078ec0ffULL,
0x00009000440e7811ULL, 0x000fc400078e58ffULL, 0xfffffff82f2f7812ULL, 0x100fe400078ee220ULL,
0x000000013d3f7812ULL, 0x000fe200078ef620ULL, 0x00000010210c7824ULL, 0x000fe200078e020eULL,
0x000000023d437812ULL, 0x000fe200078ef620ULL, 0x0000001027247824ULL, 0x000fe200078e020eULL,
0x000000033d457812ULL, 0x000fe200078ef620ULL, 0x000000100f2a7824ULL, 0x000fe200078e020eULL,
0x000000043d477812ULL, 0x000fe200078ef620ULL, 0x0000001029267824ULL, 0x000fe200078e020eULL,
0x000000053d497812ULL, 0x000fe200078ef620ULL, 0x00000001410f7824ULL, 0x000fe200078e020cULL,
0x000000063d4b7812ULL, 0x000fe200078ef620ULL, 0x0000001023207824ULL, 0x000fe200078e020eULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee222ULL, 0x0000001025227824ULL, 0x100fe200078e020eULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x000000102b287824ULL, 0x000fc400078e020eULL,
0x0000000141217824ULL, 0x040fe400078e0220ULL, 0x0000000141237824ULL, 0x000fe400078e0222ULL,
0x000000102d2c7824ULL, 0x000fe200078e020eULL, 0x0000000a21007388ULL, 0x0007e20000000800ULL,
0x0000000141257824ULL, 0x000fe400078e0224ULL, 0x000000102f0c7824ULL, 0x000fe200078e020eULL,
0x0000001023007388ULL, 0x0007e20000000800ULL, 0x0000000141277824ULL, 0x000fc400078e0226ULL,
0x000000103f2e7824ULL, 0x000fe200078e020eULL, 0x0000001225007388ULL, 0x0007e20000000800ULL,
0x0000000141297824ULL, 0x000fe400078e0228ULL, 0x00000010432f7824ULL, 0x000fe200078e020eULL,
0x0000001827007388ULL, 0x0007e20000000800ULL, 0x00000001412b7824ULL, 0x000fe400078e022aULL,
0x00000010453a7824ULL, 0x000fe200078e020eULL, 0x0000001a29007388ULL, 0x0007e20000000800ULL,
0x00000001412d7824ULL, 0x000fc400078e022cULL, 0x00000010473c7824ULL, 0x000fe200078e020eULL,
0x000000142b007388ULL, 0x0007e20000000800ULL, 0x00000001410c7824ULL, 0x000fe400078e020cULL,
0x00000010493d7824ULL, 0x100fe200078e020eULL, 0x000000162d007388ULL, 0x0007e20000000800ULL,
0x000000104b3e7824ULL, 0x100fe400078e020eULL, 0x000000104d3f7824ULL, 0x000fe200078e020eULL,
0x000000090c007388ULL, 0x0007e20000000800ULL, 0x00000001412e7824ULL, 0x000fc400078e022eULL,
0x00000001410e7824ULL, 0x040fe400078e022fULL, 0x00000001413a7824ULL, 0x040fe200078e023aULL,
0x0000000b2e007388ULL, 0x0007e20000000800ULL, 0x00000001413c7824ULL, 0x040fe400078e023cULL,
0x0000000141087824ULL, 0x042fe200078e023dULL, 0x000000110e007388ULL, 0x0007e20000000800ULL,
0x00000001413e7824ULL, 0x040fe400078e023eULL, 0x0000000141207824ULL, 0x000fe200078e023fULL,
0x000000133a007388ULL, 0x0007e80000000800ULL, 0x000000193c007388ULL, 0x0007e80000000800ULL,
0x0000001b08007388ULL, 0x0007e80000000800ULL, 0x000000153e007388ULL, 0x0007e80000000800ULL,
0x0000001720007388ULL, 0x0007e80000000800ULL, 0x00f000040d008388ULL, 0x0007e80000000c00ULL,
0x00f2001c0d008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030046467a10ULL, 0x000fe20007ffe0ffULL, 0x00f6080037ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL, 0x000000034600720cULL, 0x000fe40003f26070ULL,
0x00000001ff387807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffc92000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0030ULL, 0x00010ec0003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0059ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff307224ULL, 0x004fe200078e002fULL, 0xffffa3e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x002fe200078e0059ULL, 0x00010f40003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fe400078e002eULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e002fULL, 0xffffa38000007947ULL, 0x000fea000383ffffULL,
0x00000002ff2f7424ULL, 0x000fe200078e00ffULL, 0x00010f90002c7802ULL, 0x000fe40000000f00ULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002eULL,
0xfffff13000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x006fe200078e003dULL,
0x00010ff0002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x0000002e3d057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0006ULL, 0x00011040002c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002e063d7209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0007ULL,
0x00011090002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002e07277209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e003fULL, 0x000110e0002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002e3f047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0005ULL,
0x00011130002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002e05057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e003dULL, 0x00011180002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002e3d067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0027ULL,
0x000111d0002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffeff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0028ULL, 0x00011240003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x000fe400078e0021ULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e002fULL, 0xfffff5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x002fe200078e002aULL, 0x000112c0003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x000fe400078e0021ULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff3f7224ULL, 0x002fe200078e00ffULL, 0x00011320003c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff3e7424ULL, 0x000fc400078e00ffULL, 0x000000ffff417224ULL, 0x000fe400078e0021ULL,
0x000000ffff1d7224ULL, 0x004fe400078e002fULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff417224ULL, 0x002fe200078e0021ULL, 0x00011380003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e002fULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e002fULL, 0xfffff4e000007947ULL, 0x000fea000383ffffULL,
0x0180000005037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff087807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000308ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000308ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffeeaf006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0c00002f2a2e7389ULL, 0x0002a200000e003aULL,
0xfffeeab02c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff3d7424ULL, 0x000fe200078e00ffULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0000003f3a2f7389ULL, 0x0002a200000e003eULL,
0xfffeea703c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000011680ULL, 0xa600001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000118a0ULL, 0x00000000000118a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 77168;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
