/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013790ULL, 0x0000000000013310ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000012060ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000121d0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000012210ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000012300ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001206000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0047700400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001206000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080920828808081ULL, 0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80ae08288080ad08ULL,
0x08288080b0082880ULL, 0x8080b208288080b4ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080b292ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x000121d000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080920828808081ULL,
0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80b008288080ad08ULL, 0x08288080b2082880ULL,
0x8080ae08288080b4ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080ae92ULL,
0x0000001cffffffffULL, 0x0000017800000000ULL, 0x0001221000000000ULL, 0x000000f000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000c7ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00010dd000183104ULL, 0x0001135000011340ULL, 0x000113e0000113d0ULL, 0x00c02904000113f0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002805000028ULL,
0x0500002805000028ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000a000c02804ULL, 0x00001ec000000100ULL, 0x00001ff000001f60ULL, 0x000032c000002020ULL,
0x00005060000032f0ULL, 0x000051a000005110ULL, 0x00006270000051d0ULL, 0x0000781000006280ULL,
0x00007bd000007840ULL, 0x0000a62000007be0ULL, 0x0000ab200000a640ULL, 0x00010ca00000ab50ULL,
0x00010ce000010cd0ULL, 0x00010d1000010cf0ULL, 0x00010d5000010d30ULL, 0x000113c000010d60ULL,
0x0001143000011420ULL, 0x00011a8000011440ULL, 0x00011b6000011af0ULL, 0x00011c5000011be0ULL,
0x00011d3000011cc0ULL, 0x00011e1000011da0ULL, 0x00011ef000011e80ULL, 0x00011fd000011f70ULL,
0x0280390400012030ULL, 0x000000ff00000170ULL, 0x003f01000001b600ULL, 0x00000011000001b0ULL,
0x003f01300001b608ULL, 0x00000011000001e0ULL, 0x003f01300001b610ULL, 0x0000001100000210ULL,
0x003f01200001b648ULL, 0x0000001100000240ULL, 0x003f01200001b668ULL, 0x000000ff00000460ULL,
0x003f01070001b600ULL, 0x0000000e00000660ULL, 0x003f010200000004ULL, 0x0000000e00000710ULL,
0x003f010100000000ULL, 0x000000ff00000fa0ULL, 0x0005010700000000ULL, 0x0000001200001020ULL,
0x003f010100000020ULL, 0x0000005800001280ULL, 0x003f01060001b66cULL, 0x0000005800001300ULL,
0x003f01060001b66cULL, 0x0000005800001390ULL, 0x003f01060001b66cULL, 0x0000001a00001c40ULL,
0x0005010700000000ULL, 0x0000000f00001cb0ULL, 0x0005010600000004ULL, 0x0000004a00001cd0ULL,
0x003f01060001b60cULL, 0x0000001100001de0ULL, 0x003f010600000004ULL, 0x0000000f000022b0ULL,
0x0005010600000004ULL, 0x0000000f00002350ULL, 0x0005010600000004ULL, 0x0000001d000043f0ULL,
0x003f010100000000ULL, 0x0000001c00004470ULL, 0x003f010100000000ULL, 0x0000005800004560ULL,
0x003f01060001b66cULL, 0x00000058000045b0ULL, 0x003f01060001b66cULL, 0x0000001d00004640ULL,
0x003f010600000004ULL, 0x000000ff00004dd0ULL, 0x0005010700000000ULL, 0x0000000400004e40ULL,
0x003f010600000004ULL, 0x0000006500004e60ULL, 0x003f01060001b62cULL, 0x0000006500004f70ULL,
0x003f01060001b62cULL, 0x0000001c000054e0ULL, 0x003f01060001b64cULL, 0x0000000400005590ULL,
0x003f010600000004ULL, 0x00000011000074a0ULL, 0x003f010100000000ULL, 0x0000000f00007500ULL,
0x003f010100000000ULL, 0x000000ff0000d2f0ULL, 0x003f01060001b604ULL, 0x000000ff0000d400ULL,
0x003f01060001b604ULL, 0x000000ff0000d620ULL, 0x003f01010001b600ULL, 0x000000ff0000d630ULL,
0x003f01060001b604ULL, 0x000000ff0000d6b0ULL, 0x003f01060001b604ULL, 0x00000038000101d0ULL,
0x003f01060001b614ULL, 0x00000038000105a0ULL, 0x003f01060001b614ULL, 0x00000038000119c0ULL,
0x003f01010001b608ULL, 0x00141c0400053803ULL, 0x0000b9900000b540ULL, 0x0000d7d00000d700ULL,
0x0000040100011a30ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001fcULL, 0x0000001100000002ULL,
0x0000000000000164ULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001d8ULL, 0x0000001100000002ULL,
0x0000000000000140ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff257624ULL, 0x000fc600078e00ffULL, 0x00000000001b7919ULL, 0x000ee80000002100ULL,
0x00000000001a7919ULL, 0x000f220000002700ULL, 0x0000000108007824ULL, 0x002fc600078e0203ULL,
0x00001fff08087589ULL, 0x000e6200000e0000ULL, 0x0000008000117824ULL, 0x108fe200078e021bULL,
0x00000005ff1b7819ULL, 0x000fe2000001161bULL, 0x000062001a067625ULL, 0x010fc600078e0009ULL,
0x000000ff1100720cULL, 0x040fe40003f05270ULL, 0x000000031100780cULL, 0x040fe20003f44070ULL,
0x00001fff1b1b7589ULL, 0x000ee200000e0000ULL, 0x0000007f1100780cULL, 0x040fe40003f24070ULL,
0x000000011100780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0009e20000000a00ULL,
0x000000ff0800720cULL, 0x002fe20003f05270ULL, 0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x01b608041100a388ULL, 0x0009e2000000ca00ULL,
0x3fffffc0ff0ca424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x01b6100a1100a388ULL, 0x0009e2000000ca00ULL, 0xff317217ff009424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x01b6480c1100a388ULL, 0x0009e20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x01b4000011009388ULL, 0x0009e80000004800ULL,
0x01b6680e1100b388ULL, 0x0009e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x004fea0003800000ULL, 0x00000000000e7919ULL, 0x018e620000000000ULL,
0x000000041b007824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001025037824ULL, 0x000fc400078e00ffULL, 0x00000100ff117424ULL, 0x000fc600078e00ffULL,
0x0000000503037e24ULL, 0x000fe2000f8e021aULL, 0x000000000e007211ULL, 0x042fe200078fe0ffULL,
0x000000100e047824ULL, 0x000fc600078e00ffULL, 0x00000002000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103027824ULL, 0x040fe200078e0200ULL, 0x0000000700057812ULL, 0x000fe400078ec0ffULL,
0x000000070a0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001030c7824ULL, 0x000fe200078e020aULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0002027625ULL, 0x080fe200078e0011ULL,
0x0000000f050b7812ULL, 0x100fe400078e780eULL, 0x0000000f0d0d7812ULL, 0x000fe200078e780eULL,
0x00005c000c047625ULL, 0x000fe200078e0011ULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x00000010000b7824ULL, 0x000fe200078e020bULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100a0d7824ULL, 0x000fe400078e020dULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000040d7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806007981ULL, 0x018ea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x00000005ff167e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f00027810ULL, 0x006fc40007ffe0ffULL,
0x000000ff00037810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff027819ULL, 0x000fe40000011602ULL,
0x00000008ff037819ULL, 0x000fca0000011603ULL, 0x0000b44000008947ULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe2000001161bULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x0001b6101b0e7811ULL, 0x000fe200078e20ffULL, 0xffffffffff0c7424ULL, 0x000fe200078e00ffULL,
0x03ffffff04057812ULL, 0x000fca00078ec0ffULL, 0x0000000416107824ULL, 0x000fca00078e0205ULL,
0x000000021000720cULL, 0x000fda0003f06070ULL, 0x000000021a058824ULL, 0x000fe400078e00ffULL,
0x00006400ff068624ULL, 0x000fc800078e00ffULL, 0x0000640005058624ULL, 0x000fc800078e0206ULL,
0x00000001100a8824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000004070eff738cULL, 0x0003e20000000000ULL, 0x000060000a0a8625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080a0c8981ULL, 0x0004e2000c1e1900ULL,
0x0000000310057812ULL, 0x000fe200078ec0ffULL, 0x00000300ff087624ULL, 0x000fe200078e00ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000000eff7f8cULL, 0x0009e2000c80043fULL,
0x0000000205067810ULL, 0x000fe20007ffe0ffULL, 0xfffffffe09057424ULL, 0x000fc600078e0208ULL,
0x000000030600780cULL, 0x000fc80003f04070ULL, 0x0000000205077807ULL, 0x002fca0000000000ULL,
0x0000000110077824ULL, 0x000fe200078e0207ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x000000020700720cULL, 0x000fda0003f06070ULL, 0x000000021a068824ULL, 0x000fe400078e00ffULL,
0x00006400ff0d8624ULL, 0x000fc800078e00ffULL, 0x0000640006068624ULL, 0x000fc800078e020dULL,
0x00000001060a8824ULL, 0x004fe400078e0207ULL, 0x00000004160d7824ULL, 0x000fe400078e0204ULL,
0x000060000a0a8625ULL, 0x000fe200078e0009ULL, 0x000000011b097812ULL, 0x000fe400078ec0ffULL,
0x00000003ff147819ULL, 0x002fe20000011608ULL, 0x000000400d0d7824ULL, 0x000fe400078e00ffULL,
0x00000020090f7824ULL, 0x000fe200078e00ffULL, 0x00000008141c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x0000000d00127217ULL, 0x000fe20007800000ULL,
0x000000010f117824ULL, 0x040fe200078e0214ULL, 0x0000000414187810ULL, 0x000fe20007ffe0ffULL,
0x000000010f197824ULL, 0x000fc400078e021cULL, 0x000000080a068981ULL, 0x000362000c1e1900ULL,
0x0000000112127824ULL, 0x000fe200078e0a0dULL, 0x0000000811137212ULL, 0x080fe200078e3cffULL,
0x000000010f0d7824ULL, 0x000fe200078e0218ULL, 0x0000000c141e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0x0000001014207810ULL, 0x000fe20007ffe0ffULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0x0000000116107810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1f7824ULL, 0x000fe200078e021eULL, 0x00000008190b7212ULL, 0x082fe200078e3cffULL,
0x00000008110a7824ULL, 0x000fe200078e00ffULL, 0x0000001814267810ULL, 0x000fe20007ffe0ffULL,
0x000000010f217824ULL, 0x000fe200078e0220ULL, 0xfffffff822177812ULL, 0x000fe200078ee20bULL,
0x000000081f1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a137812ULL, 0x000fe200078ee213ULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0x000000080d0a7212ULL, 0x080fe200078e3cffULL,
0x000000010f287824ULL, 0x000fe200078e0226ULL, 0x0000001414227810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff357424ULL, 0x000fe200078e00ffULL, 0x000000031000720cULL, 0x000fe20003f06070ULL,
0x00000008282f7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x000000010f247824ULL, 0x000fe200078e0222ULL, 0x000000081f107212ULL, 0x080fe200078e3cffULL,
0x0000001008337824ULL, 0x000fe200078e00ffULL, 0x00000008210a7212ULL, 0x080fe200078e3cffULL,
0x00000008242e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x00000000040573c2ULL, 0x000e6200000e0000ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL,
0x00004000040a7824ULL, 0x000fe200078e00ffULL, 0x0000000828107212ULL, 0x000fc400078e3cffULL,
0x00000008240b7212ULL, 0x080fe400078e3cffULL, 0x0000001c142a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee210ULL, 0x000130000a107810ULL, 0x000fe20007ffe0ffULL,
0x000000010f2c7824ULL, 0x000fe200078e022aULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee20bULL,
0x00000040250b7824ULL, 0x000fe200078e00ffULL, 0x0000004012127807ULL, 0x000fe20000000000ULL,
0x000000101d297824ULL, 0x100fe200078e0210ULL, 0x000000082c237212ULL, 0x040fe200078e3cffULL,
0x000000082c307824ULL, 0x000fe200078e00ffULL, 0x0000000f12127217ULL, 0x000fe20007800000ULL,
0x0000001017277824ULL, 0x100fe200078e0210ULL, 0x0000007033337812ULL, 0x000fe200078ec0ffULL,
0x0000001015257824ULL, 0x100fe200078e0210ULL, 0xfffffff830317812ULL, 0x000fe200078ee223ULL,
0x0000000112177824ULL, 0x000fe200078e0a0fULL, 0x0001b64805057891ULL, 0x002fe2000f8e203fULL,
0x0000001013237824ULL, 0x000fc400078e0210ULL, 0x000000102b2b7824ULL, 0x100fe200078e0210ULL,
0x000000171400720cULL, 0x080fe20003fa6070ULL, 0x000000102d2d7824ULL, 0x100fe200078e0210ULL,
0x000000171800720cULL, 0x080fe20003f26070ULL, 0x000000102f2f7824ULL, 0x100fe200078e0210ULL,
0x000000171c00720cULL, 0x080fe20003f06070ULL, 0x0000001031317824ULL, 0x000fe200078e0210ULL,
0x000000171e00720cULL, 0x080fe40003f66070ULL, 0x000000172000720cULL, 0x000fe20003f46070ULL,
0x000000040b1d7e24ULL, 0x008fca000f8e020cULL, 0x0000003f1d0c7812ULL, 0x040fe400078ef811ULL,
0x0000003f1d0f7812ULL, 0x040fe400078ef80dULL, 0x0000003f1d107812ULL, 0x000fe200078ef819ULL,
0x00005e000c0c7625ULL, 0x000fc800078e0035ULL, 0x00005e000f0e7625ULL, 0x010fe200078e0035ULL,
0x000000330c127210ULL, 0x000fe40007f9e0ffULL, 0x0000003f1d0c7812ULL, 0x000fe200078ef81fULL,
0x00005e0010107625ULL, 0x000fc800078e0035ULL, 0x000000ffff137224ULL, 0x000fe200020e060dULL,
0x000000330e147210ULL, 0x000fe20007f9e0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0035ULL,
0x0000003f1d0e7812ULL, 0x040fe400078ef821ULL, 0x0000003310187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200020e060fULL, 0x0000003f1d107812ULL, 0x040fe200078ef824ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012237faeULL, 0x0003e6000e901c48ULL, 0x000000ffff197224ULL, 0x000fe200030e0611ULL,
0x000000330c1c7210ULL, 0x000fe20007fde0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0035ULL,
0x0000003f1d0c7812ULL, 0x000fe200078ef828ULL, 0x0000000014257faeULL, 0x0005e2000c901c48ULL,
0x000000330e1e7210ULL, 0x000fc40007f9e0ffULL, 0x0000003f1d0e7812ULL, 0x000fe200078ef82cULL,
0x000000ffff1d7224ULL, 0x000fe200030e060dULL, 0x0000003310107210ULL, 0x000fe20007fde0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0035ULL, 0x000000172600720cULL, 0x000fe20003f26070ULL,
0x0000000018277faeULL, 0x0005e2000c101c48ULL, 0x000000031600720cULL, 0x000fe20003f06070ULL,
0x000000ffff1f7224ULL, 0x000fe200020e060fULL, 0x000000330c207210ULL, 0x000fe20007fbe0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0035ULL, 0x000000172200720cULL, 0x080fe20003f86070ULL,
0x000000001c297faeULL, 0x0005e2000d901c48ULL, 0x0001b64804127811ULL, 0x002fe200078e18ffULL,
0x000000ffff217224ULL, 0x000fe200028e060dULL, 0x000000172a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000330e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000001e2b7faeULL, 0x0005e2000d101c48ULL, 0xff317217ff0c7424ULL, 0x000fc600078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe400030e060fULL, 0x00000000102d7faeULL, 0x0005e8000e101c48ULL,
0x00000000202f7faeULL, 0x0005e8000c901c48ULL, 0x000000000e317faeULL, 0x0005e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200012ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x004fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000649000000947ULL, 0x000fea0003800000ULL, 0x000000021a0e7824ULL, 0x002fe200078e00ffULL,
0x00007610ff5b7816ULL, 0x000fe2000000005bULL, 0x00006400ff0f7624ULL, 0x000fe200078e00ffULL,
0x00007610ff5a7816ULL, 0x000fe2000000005aULL, 0xff317217ff0c7424ULL, 0x000fe200078e00ffULL,
0x00007610ff107816ULL, 0x000fe20000000010ULL, 0x000000ffff5d7224ULL, 0x000fc400078e00ffULL,
0x000064000e0e7624ULL, 0x000fe400078e020fULL, 0x000000ffff477224ULL, 0x000fe400078e00ffULL,
0x000000201b0f7824ULL, 0x000fca00078e00ffULL, 0xffffffc00f0f7812ULL, 0x000fca00078ec0ffULL,
0x0000010016177824ULL, 0x000fca00078e020fULL, 0x000000001700720cULL, 0x000fda0003f06070ULL,
0x0000635000000947ULL, 0x002fea0003800000ULL, 0x000000041b587824ULL, 0x000fe200078e00ffULL,
0x0000ffff5b0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff597224ULL, 0x000fc600078e0007ULL,
0xfffffff858587812ULL, 0x000fe400078ec0ffULL, 0x000088800f117816ULL, 0x000fc600000000ffULL,
0x01b66c0058127984ULL, 0x000e640000000800ULL, 0x80000000110f7824ULL, 0x000fca00078e00ffULL,
0x8000000012ff7812ULL, 0x002fe2000780480fULL, 0x000000ffff127224ULL, 0x000fe200078e005dULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x000076105a137816ULL, 0x000fe40000000013ULL,
0x000076105b147816ULL, 0x000fe20000000014ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01b66c0058187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000011187824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000f00117305ULL, 0x0002a4000021f000ULL, 0x3fa000000f0f7823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01b66c0058117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003070f7812ULL, 0x000fe200078ec0ffULL,
0x00000004061d7e24ULL, 0x020fe2000f8e020bULL, 0x00000003ff247819ULL, 0x000fe20000011608ULL,
0x000000201b4d7824ULL, 0x000fe200078e00ffULL, 0x000000020f0f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff067424ULL, 0x000fc600078e00ffULL, 0x000000030f00780cULL, 0x000fc80003f04070ULL,
0x00000002054e7807ULL, 0x000fca0000000000ULL, 0x00000001070f7824ULL, 0x000fca00078e024eULL,
0x000000020f00720cULL, 0x000fe40003f06070ULL, 0x000000204d117812ULL, 0x000fe400078ec0ffULL,
0x00000004244a7810ULL, 0x000fe40007ffe0ffULL, 0x00000080170f7810ULL, 0x000fce0007ffe0ffULL,
0x0000004e0e188210ULL, 0x000fe20007ffe007ULL, 0x00000004ff198424ULL, 0x000fe200078e00ffULL,
0x0000000c245c7810ULL, 0x000fe20007ffe0ffULL, 0x000000014a1f7824ULL, 0x100fe400078e0211ULL,
0x0000600018188625ULL, 0x000fe200078e0019ULL, 0x0000000f001c7217ULL, 0x000fe40007800000ULL,
0x00000008244c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001241e7824ULL, 0x000fe200078e0211ULL,
0x0000000818068981ULL, 0x000362000c1e1900ULL, 0x000000081f177824ULL, 0x040fe200078e00ffULL,
0x00000001161a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a0fULL,
0x000000081f567212ULL, 0x080fe200078e3cffULL, 0x000000014c0f7824ULL, 0x100fe200078e0211ULL,
0x000000081e577212ULL, 0x080fe200078e3cffULL, 0x00000080ff497424ULL, 0x000fe200078e00ffULL,
0x00000010245e7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e187824ULL, 0x002fe200078e00ffULL,
0x0000001424607810ULL, 0x000fe20007ffe0ffULL, 0x000000015c197824ULL, 0x100fe200078e0211ULL,
0x000000031a00720cULL, 0x000fe20003f06070ULL, 0x000000015e1a7824ULL, 0x000fe200078e0211ULL,
0xfffffff817567812ULL, 0x000fe200078ee256ULL, 0x0000000819177824ULL, 0x040fe200078e00ffULL,
0xfffffff818577812ULL, 0x000fe200078ee257ULL, 0x0000000160217824ULL, 0x000fe200078e0211ULL,
0x0000000819547212ULL, 0x080fe200078e3cffULL, 0x000000080f187824ULL, 0x040fe200078e00ffULL,
0x000000080f557212ULL, 0x080fe200078e3cffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0x000000401c1c7807ULL, 0x000fe20000000000ULL, 0x0000000821237824ULL, 0x000fe200078e00ffULL,
0xfffffff817547812ULL, 0x000fe200078ee254ULL, 0x0000001008177824ULL, 0x000fe200078e00ffULL,
0x000000081a537212ULL, 0x000fc400078e3cffULL, 0x0000000821527212ULL, 0x000fe400078e3cffULL,
0xfffffff818557812ULL, 0x000fe400078ee255ULL, 0x0000001824627810ULL, 0x000fe40007ffe0ffULL,
0x000000111c1c7217ULL, 0x000fe40007800000ULL, 0x0000001c24647810ULL, 0x000fe40007ffe0ffULL,
0x0000003f1d187812ULL, 0x000fc400078ef81eULL, 0xfffffff820537812ULL, 0x000fe400078ee253ULL,
0xfffffff823527812ULL, 0x000fe200078ee252ULL, 0x0000000162237824ULL, 0x100fe200078e0211ULL,
0x00000070174b7812ULL, 0x000fe200078ec0ffULL, 0x000000011c177824ULL, 0x000fe200078e0a11ULL,
0x0000003f1d207812ULL, 0x040fe200078ef819ULL, 0x0000000164117824ULL, 0x000fe200078e0211ULL,
0x0000003f1d1c7812ULL, 0x040fe200078ef81fULL, 0x00005e0018187625ULL, 0x000fe200078e0049ULL,
0x0000003f1d227812ULL, 0x000fc400078ef81aULL, 0x0000003f1d1e7812ULL, 0x000fe200078ef80fULL,
0x0000000823667824ULL, 0x000fe200078e00ffULL, 0x0000003f1d267812ULL, 0x040fe200078ef821ULL,
0x00005e0020207625ULL, 0x080fe200078e0049ULL, 0x0000003f1d1a7812ULL, 0x040fe400078ef823ULL,
0x0000003f1d487812ULL, 0x000fe200078ef811ULL, 0x00005e001c1c7625ULL, 0x000fe200078e0049ULL,
0x0000004b18187210ULL, 0x000fe40007f1e0ffULL, 0x0000000823517212ULL, 0x000fe200078e3cffULL,
0x00005e001e1e7625ULL, 0x000fe200078e0049ULL, 0x0000004b20207210ULL, 0x000fc40007f3e0ffULL,
0x000000172400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000004b1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0022227625ULL, 0x000fe200078e0049ULL,
0x0000000811507212ULL, 0x000fe400078e3cffULL, 0x000000174a00720cULL, 0x000fe20003f86070ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000004b1e1e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0049ULL, 0x000000174c00720cULL, 0x000fc40003f66070ULL,
0x000000175c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000004b22247210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000004b26227210ULL, 0x000fe20007f3e0ffULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0xfffffff866517812ULL, 0x000fe200078ee251ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x000000085d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff0264a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0623ULL, 0xfffffff811507812ULL, 0x000fe200078ee250ULL,
0x000000ffff237224ULL, 0x000fe200008e0627ULL, 0x000000004a0573c2ULL, 0x000e6200000e0000ULL,
0x00005e001a267625ULL, 0x000fe200078e0049ULL, 0x000000080f1a7812ULL, 0x000fc400078e0cffULL,
0x000000175e00720cULL, 0x000fe20003f26070ULL, 0x000020005d117824ULL, 0x000fe200078e00ffULL,
0x0000004b26267210ULL, 0x000fe20007f1e0ffULL, 0x00005e0048487625ULL, 0x000fe200078e0049ULL,
0x000000001a0673c2ULL, 0x000ea400000e0000ULL, 0x0000200011117812ULL, 0x000fe200078e0cffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000004b48487210ULL, 0x000fe40007fde0ffULL,
0x000130000a117810ULL, 0x000fc40007ffe011ULL, 0x000000176000720cULL, 0x080fe20003f06070ULL,
0x000000ffff497224ULL, 0x000fe400030e0649ULL, 0x00000010574b7824ULL, 0x100fe400078e0211ULL,
0x00000010564f7824ULL, 0x100fe400078e0211ULL, 0x00000010555f7824ULL, 0x100fe200078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000184b7faeULL, 0x0007e2000e901c48ULL,
0x000000176200720cULL, 0x080fe20003fa6070ULL, 0x0001b64805057890ULL, 0x002fe2000fffe03fULL,
0x0000001053617824ULL, 0x100fe200078e0211ULL, 0x000000001c4f7faeULL, 0x0003e2000e101c48ULL,
0x000000176400720cULL, 0x000fe20003f86070ULL, 0x0000001054177824ULL, 0x100fe200078e0211ULL,
0x0000000605067290ULL, 0x004fe2000fffe03fULL, 0x000000001e5f7faeULL, 0x0003e2000d901c48ULL,
0x0000001052197824ULL, 0x008fc600078e0211ULL, 0x0000000020177faeULL, 0x0003e2000d101c48ULL,
0x00000010514b7824ULL, 0x100fe400078e0211ULL, 0x0000001050117824ULL, 0x000fe200078e0211ULL,
0x0000000024617faeULL, 0x0003e8000c901c48ULL, 0x0000000022197faeULL, 0x0003e8000c101c48ULL,
0x00000000264b7faeULL, 0x0003e8000e901c48ULL, 0x0000000048117faeULL, 0x0003e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004050f187984ULL, 0x0004e20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b60c004a4a7984ULL, 0x000f220000000800ULL,
0x0000ffff5a117812ULL, 0x002fc400078ec0ffULL, 0x0000ffff10177812ULL, 0x000fe400078ec0ffULL,
0x00008880111c7816ULL, 0x000fe400000000ffULL, 0x0000888017117816ULL, 0x000fc600000000ffULL,
0x800000001c177824ULL, 0x000fe400078e00ffULL, 0x8000000011197824ULL, 0x000fc600078e00ffULL,
0x8000000018ff7812ULL, 0x008fe40007804817ULL, 0x800000004aff7812ULL, 0x010fe20007824819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x8000000011187824ULL, 0x000fe200078e00ffULL, 0x0001b60804117811ULL, 0x000fe200078e20ffULL,
0x3e000000ff177424ULL, 0x000fc800078e00ffULL, 0x0000001700197305ULL, 0x0002e4000021f000ULL,
0x3fa0000017177823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x008fe40003800000ULL,
0x0000040011197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc40007824818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000001008207824ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011608ULL,
0x00000001ff667424ULL, 0x000fc600078e00ffULL, 0x0000007020177812ULL, 0x000fe400078ec0ffULL,
0x0000000c11187812ULL, 0x000fc600078ec0ffULL, 0x0000008004117824ULL, 0x000fc800078e0217ULL,
0x0000000111117824ULL, 0x000fca00078e0218ULL, 0x01b0000011177984ULL, 0x000e680000000800ULL,
0x01b2000011187984ULL, 0x0007220000000800ULL, 0x0000000c1700720bULL, 0x002fda0003f3d000ULL,
0x0000000000197806ULL, 0x000fc800008e0100ULL, 0x0000ffff191d7812ULL, 0x000fda000782c0ffULL,
0x000003a000009947ULL, 0x000fea0003800000ULL, 0x0000000c1700720bULL, 0x018fe40003f54000ULL,
0x000000170c1f7209ULL, 0x000fe40007810000ULL, 0x00000002ff197819ULL, 0x000fe40000011608ULL,
0x0000001b0400720cULL, 0x000fe20003f25270ULL, 0x8000001f0c117221ULL, 0x000fe20000010000ULL,
0x00000008191a7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b11117820ULL, 0x000fe40000410000ULL,
0x00000000000c7806ULL, 0x000fe400010e0100ULL, 0x00000011001e7308ULL, 0x000e640000000800ULL,
0x0000ffff0c0c7812ULL, 0x000fc800078e3cffULL, 0x0000000c1dff7212ULL, 0x000fe4000784c0ffULL,
0x00000070200c9812ULL, 0x000fe400078ec0ffULL, 0x00000001ff1d9819ULL, 0x000fe40000011608ULL,
0x00000001ff667807ULL, 0x000fe20001000000ULL, 0x000000801b0c9824ULL, 0x000fe200078e020cULL,
0x0000000c1d1d9812ULL, 0x000fe200078ec0ffULL, 0x00001f1a1e1a7589ULL, 0x002e6200000e0000ULL,
0x0000001e0d0d7220ULL, 0x000fc60000410000ULL, 0x8000001f17172221ULL, 0x000fe20000010000ULL,
0x00001f191e197589ULL, 0x000ee200000e0000ULL, 0x000000011d0c9824ULL, 0x000fe400078e020cULL,
0x3fb8aa3b17172820ULL, 0x000fc60000410000ULL, 0x01b4001f0c009388ULL, 0x0009e20000000800ULL,
0x0000001700152308ULL, 0x000ea20000000800ULL, 0x000000ffff0c7224ULL, 0x010fe400078e001fULL,
0x0000001a47477220ULL, 0x082fe40000410000ULL, 0x0000001a46467220ULL, 0x080fe40000410000ULL,
0x0000001a3f3f7220ULL, 0x080fe40000410000ULL, 0x0000001a3e3e7220ULL, 0x000fc40000410000ULL,
0x0000001a33337220ULL, 0x080fe40000410000ULL, 0x0000001a32327220ULL, 0x080fe40000410000ULL,
0x0000001a2f2f7220ULL, 0x080fe40000410000ULL, 0x0000001a2e2e7220ULL, 0x080fe40000410000ULL,
0x0000001a2b2b7220ULL, 0x080fe40000410000ULL, 0x0000001a2a2a7220ULL, 0x000fc40000410000ULL,
0x0000001a37377220ULL, 0x080fe40000410000ULL, 0x0000001a36367220ULL, 0x080fe40000410000ULL,
0x0000001a3b3b7220ULL, 0x080fe40000410000ULL, 0x0000001a3a3a7220ULL, 0x080fe40000410000ULL,
0x0000001a43437220ULL, 0x080fe40000410000ULL, 0x0000001a42427220ULL, 0x000fc40000410000ULL,
0x0000001945457220ULL, 0x088fe40000410000ULL, 0x0000001944447220ULL, 0x080fe40000410000ULL,
0x000000193d3d7220ULL, 0x080fe40000410000ULL, 0x000000193c3c7220ULL, 0x080fe40000410000ULL,
0x0000001931317220ULL, 0x080fe40000410000ULL, 0x0000001930307220ULL, 0x000fc40000410000ULL,
0x000000192d2d7220ULL, 0x080fe40000410000ULL, 0x000000192c2c7220ULL, 0x080fe40000410000ULL,
0x0000001929297220ULL, 0x080fe40000410000ULL, 0x0000001928287220ULL, 0x080fe40000410000ULL,
0x0000001935357220ULL, 0x080fe40000410000ULL, 0x0000001934347220ULL, 0x000fc40000410000ULL,
0x0000001939397220ULL, 0x080fe40000410000ULL, 0x0000001938387220ULL, 0x080fe40000410000ULL,
0x0000001941417220ULL, 0x080fe40000410000ULL, 0x0000001940407220ULL, 0x000fe40000410000ULL,
0x0000001518182220ULL, 0x004fc80000410000ULL, 0x0000000d180d7221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x000004050f117984ULL, 0x000e620008000800ULL,
0x800000001c187824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe20007804818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001c1c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff117424ULL, 0x000fc800078e00ffULL,
0x0000001100177305ULL, 0x0002e4000021f000ULL, 0x3fa0000011117823ULL, 0x002fe200000100ffULL,
0x000000170000735dULL, 0x008fe40003800000ULL, 0x000004050f177984ULL, 0x000e640008000800ULL,
0x8000000017ff7812ULL, 0x002fc4000780481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000041b0f7824ULL, 0x004fe200078e00ffULL,
0x00000008084f7812ULL, 0x040fe400078ec0ffULL, 0x00000002ff6d7819ULL, 0x100fe40000011608ULL,
0x000000040f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000074f197812ULL, 0x000fe400078ec808ULL,
0x0000000f08187211ULL, 0x000fe200078fe0ffULL, 0x000020005d0f7824ULL, 0x000fe200078e020aULL,
0x000000074f677812ULL, 0x000fc400078ef808ULL, 0x00000018194c7212ULL, 0x000fe400078e3cffULL,
0x000130000f0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000008067177811ULL, 0x040fe200078e18ffULL,
0x00000008671a7824ULL, 0x040fe200078e024cULL, 0x0000010067117811ULL, 0x000fe400078e18ffULL,
0x000000086d6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101a1a7824ULL, 0x000fe200078e020fULL,
0x0000991066667816ULL, 0x000fe200000000ffULL, 0x000000014c207824ULL, 0x000fc400078e0217ULL,
0x000000014c247824ULL, 0x000fe200078e0211ULL, 0x000000001a1c783bULL, 0x000e620000004200ULL,
0x0000001020207824ULL, 0x100fe200078e020fULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000001024247824ULL, 0x000fc800078e020fULL, 0x000000002020783bULL, 0x000ea80000004200ULL,
0x000000002424783bULL, 0x000ee20000004200ULL, 0x000001001c1a7824ULL, 0x042fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe4000001141cULL, 0x000088801cc07816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fc4000001141aULL,
0x00000002181a7810ULL, 0x000fe20007ffe0ffULL, 0x000000be00be7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001a191a7212ULL, 0x000fe200078e3cffULL,
0x000001001d197824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001141dULL,
0x00000018ff6a7819ULL, 0x000fe2000001141eULL, 0x0000000867187824ULL, 0x000fe200078e021aULL,
0x0000001c00c17306ULL, 0x0003e20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fc4000001141fULL,
0x0000001018187824ULL, 0x000fe200078e020fULL, 0x000088801d657816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x000088801ebd7816ULL, 0x040fe400000000ffULL,
0x000000001848783bULL, 0x0008e20000004200ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x000088801f637816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000c000c07306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000001001f187824ULL, 0x050fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fc40000011419ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000001d00bf7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ffa67819ULL, 0x004fe40000011420ULL, 0x00000018ff987819ULL, 0x000fe40000011421ULL,
0x00000018ff967819ULL, 0x000fe20000011422ULL, 0x0000001800ba7306ULL, 0x0003e20000200c00ULL,
0x00000018ff937819ULL, 0x000fc40000011423ULL, 0x0000888020aa7816ULL, 0x000fe400000000ffULL,
0x0000888021997816ULL, 0x000fe400000000ffULL, 0x0000888022a57816ULL, 0x000fe200000000ffULL,
0x0000001c00bc7306ULL, 0x000fe20000200c00ULL, 0x0000010020187824ULL, 0x042fe200078e00ffULL,
0x00008880239f7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x008fe40000011424ULL, 0x00000018ffab7819ULL, 0x000fe20000011418ULL,
0x000000011a187824ULL, 0x000fe200078e0217ULL, 0x0000001e00b77306ULL, 0x000fe20000200c00ULL,
0x0000010021177824ULL, 0x040fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000001018187824ULL, 0x000fe200078e020fULL, 0x00000018ff8c7819ULL, 0x000fe20000011448ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x0000001f00627306ULL, 0x0003e20000200c00ULL, 0x0000888048bb7816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff757819ULL, 0x000fe40000011449ULL,
0x00000018ffae7819ULL, 0x000fe2000001144aULL, 0x0000001700ac7306ULL, 0x0005e20000200c00ULL,
0x00000000181c783bULL, 0x0022e20000004200ULL, 0x00000018ffad7819ULL, 0x000fc4000001144bULL,
0x0000888049747816ULL, 0x000fe400000000ffULL, 0x000088804ab47816ULL, 0x000fe400000000ffULL,
0x0000001900c47306ULL, 0x0009e20000200c00ULL, 0x000000011a187824ULL, 0x002fe200078e0211ULL,
0x000088804bb17816ULL, 0x000fe200000000ffULL, 0x0000010026117824ULL, 0x000fe200078e00ffULL,
0x0000888024877816ULL, 0x000fe200000000ffULL, 0x0000001018187824ULL, 0x000fe200078e020fULL,
0x00000018ff7f7819ULL, 0x000fe20000011425ULL, 0x00000100250f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000010023177824ULL, 0x044fe200078e00ffULL,
0x0000002000a97306ULL, 0x000fe20000200c00ULL, 0x0000010022197824ULL, 0x050fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fc40000011419ULL, 0x0000000f00897306ULL, 0x0003e20000200c00ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000888025867816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000018067677811ULL, 0x000fe200078e18ffULL, 0x0000001100807306ULL, 0x0005e20000200c00ULL,
0x00000100270f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc40000011426ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x000000014c5c7824ULL, 0x000fe200078e0267ULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000001700a47306ULL, 0x0003e20000200c00ULL,
0x0000010049117824ULL, 0x044fe200078e00ffULL, 0x00000018ff917819ULL, 0x008fe2000001141cULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x000088801ca27816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x0000000f00817306ULL, 0x0005e20000200c00ULL,
0x0000010024177824ULL, 0x042fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001141dULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000001100b97306ULL, 0x0003e20000200c00ULL,
0x00000100480f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001141eULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000002100a77306ULL, 0x000fe20000200c00ULL,
0x000001004b117824ULL, 0x042fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001141fULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000000f00b87306ULL, 0x0003e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x000088801d9d7816ULL, 0x000fe400000000ffULL,
0x000088801e977816ULL, 0x000fe400000000ffULL, 0x000088801f927816ULL, 0x000fe200000000ffULL,
0x00000022009b7306ULL, 0x000fe20000200c00ULL, 0x000001004a0f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011427ULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000888026837816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fc4000001140fULL, 0x00000023009e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00008880277e7816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc60000011426ULL,
0x0000000f00b37306ULL, 0x0005e20000200c00ULL, 0x000000001820783bULL, 0x002e620000004200ULL,
0x00000018ff277819ULL, 0x000fcc0000011427ULL, 0x00000017008a7306ULL, 0x0007e20000200c00ULL,
0x000001001c0f7824ULL, 0x044fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000001100b27306ULL, 0x0005e20000200c00ULL,
0x00000004ff177819ULL, 0x008fe40000011608ULL, 0x00000018ff1c7819ULL, 0x000fca000001141cULL,
0x0000000f00a17306ULL, 0x0007e20000200c00ULL, 0x000001001d117824ULL, 0x044fe400078e00ffULL,
0x000100001d1d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000004800b57306ULL, 0x000fe20000200c00ULL, 0x000001001e0f7824ULL, 0x048fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000001100a07306ULL, 0x0005e20000200c00ULL,
0x00000018ff687819ULL, 0x002fe20000011421ULL, 0x00000100217b7824ULL, 0x040fe200078e00ffULL,
0x00008880217a7816ULL, 0x040fe200000000ffULL, 0x0001000021777824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011420ULL, 0x00000100207c7824ULL, 0x040fe200078e00ffULL,
0x00008880207d7816ULL, 0x040fe200000000ffULL, 0x0000000f00947306ULL, 0x0003e20000200c00ULL,
0x000001001f117824ULL, 0x004fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011422ULL,
0x0001000020767824ULL, 0x000fe200078e00ffULL, 0x0000888022707816ULL, 0x000fe200000000ffULL,
0x0000010023207824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000001900a37306ULL, 0x0005e20000200c00ULL,
0x00000007080f7812ULL, 0x002fe200078ec0ffULL, 0x00000100226f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x000000080f187812ULL, 0x000fe200078ef808ULL, 0x0001000023737824ULL, 0x000fe200078e00ffULL,
0x00000004080f7811ULL, 0x000fe200078fe0ffULL, 0x0000001100957306ULL, 0x0003e20000200c00ULL,
0x0000000717177812ULL, 0x000fc400078e7818ULL, 0x0000000208197811ULL, 0x004fe400078fe0ffULL,
0x000000070f0f7812ULL, 0x100fe200078e7818ULL, 0x0000000818177824ULL, 0x000fe200078e0217ULL,
0x0000000719197812ULL, 0x000fe200078e7818ULL, 0x0000004900b67306ULL, 0x000fe20000200c00ULL,
0x0000000608117811ULL, 0x002fe200078fe0ffULL, 0x0000001017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000000818197824ULL, 0x000fe200078e0219ULL,
0x0000000711117812ULL, 0x000fe200078e7818ULL, 0x0000080004487824ULL, 0x000fe200078e0217ULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000004a00af7306ULL, 0x000fe20000200c00ULL,
0x00000008180f7824ULL, 0x040fe200078e020fULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000000818117824ULL, 0x000fe200078e0211ULL, 0x00000015ff18723eULL, 0x000fe200000000ffULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011423ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000004b00b07306ULL, 0x0003e20000200c00ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x00008880236e7816ULL, 0x000fe200000000ffULL,
0x0000080004c27824ULL, 0x040fe200078e0219ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000080004a87824ULL, 0x040fe200078e020fULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000080004887824ULL, 0x000fe200078e0211ULL, 0x0000002400857306ULL, 0x0005e20000200c00ULL,
0x011000004848783bULL, 0x002fe20000000200ULL, 0x00000001ff047819ULL, 0x000fc4000001161bULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000000204217824ULL, 0x000fe200078e025dULL, 0x000000c300c37306ULL, 0x000fe20000200c00ULL,
0x0000541018247816ULL, 0x004fe20000000018ULL, 0x000000011a187824ULL, 0x000fe200078e0267ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0001300021217811ULL, 0x000fe200078e68ffULL,
0x00001f6d246d7589ULL, 0x000e6200000e0000ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000006500657306ULL, 0x000ea40000200c00ULL, 0x00001f6c246c7589ULL, 0x000eec00000e0000ULL,
0x0000006400647306ULL, 0x000f300000200c00ULL, 0x0000002500847306ULL, 0x0003f00000200c00ULL,
0x0000001c009c7306ULL, 0x0005e20000200c00ULL, 0x0000001018257824ULL, 0x002fe200078e0221ULL,
0x0000006d48488232ULL, 0x000fc40000000000ULL, 0x0000006d4a4a8232ULL, 0x000fe40000000000ULL,
0x0000006c49498232ULL, 0x088fe40000000000ULL, 0x0000002000717306ULL, 0x0003e20000200c00ULL,
0x000000105c1c7824ULL, 0x004fe200078e0221ULL, 0x0000006c4b4b8232ULL, 0x000fe20000000000ULL,
0x0000541065217816ULL, 0x000fca00000000c4ULL, 0x000000bd00bd7306ULL, 0x000ea20000200c00ULL,
0x00005410c0207816ULL, 0x002fce00000000c3ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x000000204840723cULL, 0x000fee0000001840ULL, 0x0000006a006a7306ULL, 0x000ee20000200c00ULL,
0x00005410c1207816ULL, 0x000fe400000000beULL, 0x00005410bf217816ULL, 0x010fca0000000064ULL,
0x0000006b006b7306ULL, 0x000f240000200c00ULL, 0x000000204838723cULL, 0x000fec0000001838ULL,
0x000000bb00bb7306ULL, 0x000f220000200c00ULL, 0x00005410bd207816ULL, 0x004fe400000000bcULL,
0x0000541063217816ULL, 0x002fc400000000baULL, 0x00005410b76a7816ULL, 0x008fc6000000006aULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x00005410626b7816ULL, 0x010fe2000000006bULL,
0x000000204834723cULL, 0x040fec0000001834ULL, 0x0000001d009a7306ULL, 0x000fe40000200c00ULL,
0x0000006a4828723cULL, 0x000fec0000001828ULL, 0x0000001e00907306ULL, 0x000fe20000200c00ULL,
0x00005410bb6a7816ULL, 0x000fc400000000b8ULL, 0x00005410746b7816ULL, 0x002fca00000000b9ULL,
0x0000001f008e7306ULL, 0x0003e40000200c00ULL, 0x0000006a482c723cULL, 0x000fec000000182cULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000000001c1c783bULL, 0x002e6e0000004200ULL,
0x0000007500757306ULL, 0x000ef00000200c00ULL, 0x0000002200727306ULL, 0x0009e20000200c00ULL,
0x00005410b56a7816ULL, 0x004fce000000008cULL, 0x000000b400b47306ULL, 0x000ea20000200c00ULL,
0x01100000c220783bULL, 0x010f220000000200ULL, 0x00005410b66b7816ULL, 0x008fcc0000000075ULL,
0x000000b100b17306ULL, 0x000ee20000200c00ULL, 0x0000006a4830723cULL, 0x000fee0000001830ULL,
0x000000ae00ae7306ULL, 0x000f220000200c00ULL, 0x00005410b46a7816ULL, 0x004fe400000000b3ULL,
0x00000018ff677819ULL, 0x002fc4000001141cULL, 0x00000018ff667819ULL, 0x000fe4000001141dULL,
0x000088801c8c7816ULL, 0x040fe200000000ffULL, 0x000000ad00ad7306ULL, 0x000e620000200c00ULL,
0x00005410b16b7816ULL, 0x008fe200000000b2ULL, 0x000001001cb17824ULL, 0x040fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001141eULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fc6000001141fULL, 0x000000aa00aa7306ULL, 0x000fe20000200c00ULL,
0x0000006a483c723cULL, 0x000fe2000000183cULL, 0x00000018ff1c7819ULL, 0x000fcc000001141cULL,
0x000000ab00ab7306ULL, 0x000fe20000200c00ULL, 0x00005410af6a7816ULL, 0x010fe200000000aeULL,
0x0000006d20208232ULL, 0x080fe20000000000ULL, 0x00005410b06b7816ULL, 0x002fe200000000adULL,
0x0000006d22228232ULL, 0x000fe20000000000ULL, 0x00000018ffad7819ULL, 0x000fe200000114b1ULL,
0x0000006c21218232ULL, 0x080fe40000000000ULL, 0x0000009900997306ULL, 0x000e620000200c00ULL,
0x0000006c23238232ULL, 0x000fe20000000000ULL, 0x0000006a4844723cULL, 0x000fec0000001844ULL,
0x000000a600a67306ULL, 0x000ea20000200c00ULL, 0x000088801d487816ULL, 0x040fe200000000ffULL,
0x000001001d4a7824ULL, 0x000fc400078e00ffULL, 0x000100001d1d7824ULL, 0x000fc800078e00ffULL,
0x0000009800987306ULL, 0x000ee20000200c00ULL, 0x0000541099497816ULL, 0x002fe400000000acULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff997819ULL, 0x000fc6000001144aULL,
0x00000048006a7306ULL, 0x0003f00000200c00ULL, 0x000000a500a57306ULL, 0x000f220000200c00ULL,
0x00005410aa487816ULL, 0x002fce00000000abULL, 0x0000009f009f7306ULL, 0x000e620000200c00ULL,
0x000000482040723cULL, 0x000fee0000001840ULL, 0x0000009600967306ULL, 0x000e620000200c00ULL,
0x00005410a9487816ULL, 0x004fe400000000a6ULL, 0x00005410a7497816ULL, 0x008fca0000000098ULL,
0x0000009300937306ULL, 0x000ea40000200c00ULL, 0x000000482038723cULL, 0x000fec0000001838ULL,
0x000000a200a27306ULL, 0x000ee20000200c00ULL, 0x00005410a5487816ULL, 0x010fe400000000a3ULL,
0x000054109f497816ULL, 0x002fc400000000a4ULL, 0x000088801ea37816ULL, 0x000fc600000000ffULL,
0x0000009d009d7306ULL, 0x000e640000200c00ULL, 0x000000482048723cULL, 0x000fe20000001834ULL,
0x01100000a834783bULL, 0x000f2a0000000200ULL, 0x0000001c00987306ULL, 0x0003f00000200c00ULL,
0x0000001d009f7306ULL, 0x0005e20000200c00ULL, 0x000054109b1c7816ULL, 0x002fe20000000096ULL,
0x000001001e967824ULL, 0x000fe200078e00ffULL, 0x000088801f9b7816ULL, 0x000fc800000000ffULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x000054109e1d7816ULL, 0x004fce0000000093ULL, 0x0000008f008f7306ULL, 0x000ea20000200c00ULL,
0x0000001c2028723cULL, 0x000fee0000001828ULL, 0x0000009700977306ULL, 0x000e620000200c00ULL,
0x00005410a21c7816ULL, 0x008fe400000000a1ULL, 0x000054109d1d7816ULL, 0x000fe200000000a0ULL,
0x0000006d34348232ULL, 0x010fc40000000000ULL, 0x0000006d36368232ULL, 0x000fe40000000000ULL,
0x0000009200927306ULL, 0x000ee20000200c00ULL, 0x0000006c35358232ULL, 0x080fe20000000000ULL,
0x0000001c202c723cULL, 0x000fe2000000182cULL, 0x0000006c37378232ULL, 0x000fca0000000000ULL,
0x0000002600787306ULL, 0x000fe20000200c00ULL, 0x000054109c1c7816ULL, 0x002fe20000000091ULL,
0x000001001f917824ULL, 0x040fe200078e00ffULL, 0x000054109a1d7816ULL, 0x004fe2000000008fULL,
0x000000ffff8f7224ULL, 0x000fe400078e009bULL, 0x000100001f1f7824ULL, 0x000fe400078e00ffULL,
0x0000002700797306ULL, 0x0003e40000200c00ULL, 0x0000001c2030723cULL, 0x000fe20000001830ULL,
0x00000018ff1f7819ULL, 0x000fca000001141fULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000000002524783bULL, 0x002e620000004200ULL, 0x00005410971c7816ULL, 0x000fe40000000094ULL,
0x00005410921d7816ULL, 0x008fc80000000095ULL, 0x0000008b008b7306ULL, 0x000ea60000200c00ULL,
0x0000001c203c723cULL, 0x000fea000000183cULL, 0x0000008700877306ULL, 0x000ee40000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe20000011491ULL, 0x000100001e917824ULL, 0x000fca00078e00ffULL,
0x0000008600867306ULL, 0x000f220000200c00ULL, 0x000054108e1d7816ULL, 0x004fe4000000008bULL,
0x00000018ff8e7819ULL, 0x000fca0000011491ULL, 0x0000001c001e7306ULL, 0x0005f00000200c00ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x00005410901c7816ULL, 0x004fe4000000008dULL,
0x00000018ff627819ULL, 0x002fc40000011425ULL, 0x00000018ff637819ULL, 0x000fe40000011424ULL,
0x00000018ff747819ULL, 0x000fe20000011426ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x0000001c2020723cULL, 0x000fe20000001844ULL, 0x00000018ff757819ULL, 0x000fcc0000011427ULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x00005410871c7816ULL, 0x008fe4000000008aULL,
0x00005410861d7816ULL, 0x010fe40000000089ULL, 0x0000888024447816ULL, 0x000fc600000000ffULL,
0x0000007e007e7306ULL, 0x000ee40000200c00ULL, 0x0000001c3440723cULL, 0x000fe20000001840ULL,
0x000000ffff867224ULL, 0x000fe400078e0044ULL, 0x0000010024447824ULL, 0x040fe400078e00ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000006100617306ULL, 0x000f220000200c00ULL,
0x00005410851c7816ULL, 0x000fe40000000082ULL, 0x00005410841d7816ULL, 0x002fc4000000007fULL,
0x00000018ff7f7819ULL, 0x000fe40000011444ULL, 0x011000008844783bULL, 0x000e620000000200ULL,
0x0000006000607306ULL, 0x000f220000200c00ULL, 0x0000888025827816ULL, 0x000fe200000000ffULL,
0x0000001c3438723cULL, 0x000fe20000001838ULL, 0x00000018ff247819ULL, 0x000fca0000011424ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x00005410831c7816ULL, 0x004fe20000000080ULL,
0x0000010025807824ULL, 0x040fe200078e00ffULL, 0x000054107e1d7816ULL, 0x008fe20000000081ULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe400078e0082ULL,
0x0000007c007c7306ULL, 0x000ea40000200c00ULL, 0x0000001c3448723cULL, 0x000fec0000001848ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410781c7816ULL, 0x010fc40000000061ULL,
0x00005410791d7816ULL, 0x000fe40000000060ULL, 0x00000018ff617819ULL, 0x000fc60000011480ULL,
0x0000007b007b7306ULL, 0x000ee40000200c00ULL, 0x0000001c3428723cULL, 0x000fe20000001828ULL,
0x0000006d44448232ULL, 0x002fca0000000000ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000054107d1c7816ULL, 0x004fe2000000007cULL, 0x0000006d46468232ULL, 0x000fe40000000000ULL,
0x0000006c45458232ULL, 0x080fe40000000000ULL, 0x0000006c47478232ULL, 0x000fe40000000000ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054107a1d7816ULL, 0x008fce000000007bULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000001c342c723cULL, 0x000fee000000182cULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x00005410761c7816ULL, 0x002fce0000000069ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00005410771d7816ULL, 0x004fce0000000068ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x008fe2000000005fULL, 0x0000001c3430723cULL, 0x000fec0000001830ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe20000011425ULL,
0x0000010026257824ULL, 0x040fe200078e00ffULL, 0x00008880261c7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x00000018ff267819ULL, 0x000fce0000011426ULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x0000541070707816ULL, 0x002fce000000006fULL,
0x0000008f008f7306ULL, 0x000e620000200c00ULL, 0x000054106e717816ULL, 0x004fce0000000071ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541073737816ULL, 0x008fe2000000005eULL,
0x00000070343c723cULL, 0x000fe2000000183cULL, 0x00008880275e7816ULL, 0x000fca00000000ffULL,
0x0000006400647306ULL, 0x000fe40000200c00ULL, 0x000000723420723cULL, 0x000fec0000001820ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000054108f357816ULL, 0x002fe2000000001eULL,
0x00010000271e7824ULL, 0x000fc400078e00ffULL, 0x0000010027347824ULL, 0x000fc800078e00ffULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x00000018ff607819ULL, 0x000fce0000011434ULL,
0x0000006700677306ULL, 0x000eb00000200c00ULL, 0x00000025005f7306ULL, 0x0007e20000200c00ULL,
0x000054101f1f7816ULL, 0x002fce0000000064ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000018ff257819ULL, 0x008fe4000001141eULL, 0x000054108e1e7816ULL, 0x000fe40000000065ULL,
0x0000541098987816ULL, 0x004fc60000000067ULL, 0x0000009900997306ULL, 0x000e640000200c00ULL,
0x0000001e4428723cULL, 0x000fec0000001828ULL, 0x0000001d001d7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x000054106a8d7816ULL, 0x002fce0000000099ULL,
0x0000006300637306ULL, 0x000ff00000200c00ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x000054109f997816ULL, 0x004fce0000000066ULL, 0x000000ad006b7306ULL, 0x000e620000200c00ULL,
0x000000984438723cULL, 0x000fee0000001838ULL, 0x000000a300937306ULL, 0x000ff00000200c00ULL,
0x0000009600967306ULL, 0x000ea20000200c00ULL, 0x000054108c8c7816ULL, 0x002fce000000006bULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x0000008c4440723cULL, 0x000fee0000001840ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541093347816ULL, 0x004fce0000000096ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x000000344434723cULL, 0x000fee0000001848ULL,
0x0000006100617306ULL, 0x000e700000200c00ULL, 0x0000002400247306ULL, 0x000eb00000200c00ULL,
0x0000001c001c7306ULL, 0x000ee20000200c00ULL, 0x000054107e617816ULL, 0x002fce0000000061ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541024247816ULL, 0x004fce0000000063ULL,
0x0000006000677306ULL, 0x0003e20000200c00ULL, 0x000054101c1c7816ULL, 0x008fce000000005fULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541086607816ULL, 0x002fce000000007fULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000060442c723cULL, 0x000fee000000182cULL,
0x0000002600277306ULL, 0x000e700000200c00ULL, 0x00000025001e7306ULL, 0x0004e20000200c00ULL,
0x0000541027747816ULL, 0x002fc40000000074ULL, 0x000054101d257816ULL, 0x004fe40000000062ULL,
0x000054105e1d7816ULL, 0x000fe40000000067ULL, 0x000054101e757816ULL, 0x008fc60000000075ULL,
0x000000244430723cULL, 0x000fe20000001830ULL, 0x00000003071e7812ULL, 0x000fce00078ec0ffULL,
0x0000001c443c723cULL, 0x040fee000000183cULL, 0x0001b610041c7811ULL, 0x040fe200078e20ffULL,
0x000000744444723cULL, 0x000fe20000001820ULL, 0x0001b668041d7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000001dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004161f7824ULL, 0x000fe200078e0204ULL,
0x000000ff5aff7812ULL, 0x000fe2000780c0ffULL, 0x000000001cff7f8cULL, 0x0005e2000c80043fULL,
0x000000021e1e7810ULL, 0x000fc40007ffe0ffULL, 0x000000801f1f7811ULL, 0x000fe400078e30ffULL,
0x00000001ff5e7807ULL, 0x000fe40000000000ULL, 0x000000001f00720cULL, 0x000fe40003f06070ULL,
0x000000031e00780cULL, 0x000fe40003f64070ULL, 0x000000ff5bff7812ULL, 0x000fe4000784c0ffULL,
0x00000002051e7807ULL, 0x000fc40001800000ULL, 0x000000015d00780cULL, 0x000fe40003f25270ULL,
0x00000001ff1c7807ULL, 0x004fe20001000000ULL, 0x0000000107077824ULL, 0x000fe200078e021eULL,
0x0000005a5e5a7207ULL, 0x000fe40004800000ULL, 0x000076101c5b7816ULL, 0x000fe4000000005bULL,
0x000000015d5d7812ULL, 0x000fe200078e0cffULL, 0x0000302000000947ULL, 0x000fea0003800000ULL,
0x01b66c0058077984ULL, 0x000ea20000000800ULL, 0x800000001c047824ULL, 0x000fca00078e00ffULL,
0x8000000007ff7812ULL, 0x004fe20007804804ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01b66c0058077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe40007804804ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001c1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400077305ULL, 0x0004e4000021f000ULL,
0x3fa0000004047823ULL, 0x004fe200000100ffULL, 0x000000070000735dULL, 0x008fe40003800000ULL,
0x000004001d077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000159597824ULL, 0x000fe400078e024eULL, 0x0000000406257e24ULL, 0x020fe2000f8e020bULL,
0x00000300161e7a10ULL, 0x000fe20007ffe0ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x0000000359047812ULL, 0x000fc800078ec0ffULL, 0x0000000204047810ULL, 0x000fc80007ffe0ffULL,
0x000000030400780cULL, 0x000fc80003f04070ULL, 0x0000000205047807ULL, 0x000fca0000000000ULL,
0x0000000159077824ULL, 0x000fca00078e0204ULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x0000200012047824ULL, 0x000fe200078e00ffULL, 0x00000003ff4a7819ULL, 0x000fe40000011608ULL,
0x000000011e207810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff1f7819ULL, 0x000fce000001161bULL,
0x000000010e1c8824ULL, 0x000fe400078e0207ULL, 0x00000004ff1d8424ULL, 0x002fe200078e00ffULL,
0x0000200004047812ULL, 0x000fc600078ec0ffULL, 0x000060001c1c8625ULL, 0x000fe200078e001dULL,
0x000000204d277812ULL, 0x000fe400078ec0ffULL, 0x000000144a687810ULL, 0x000fe40007ffe0ffULL,
0x000000081c068981ULL, 0x000362000c1e1900ULL, 0x000000032000720cULL, 0x000fe20003f06070ULL,
0x000000041e207824ULL, 0x000fe200078e021fULL, 0x000000184a647810ULL, 0x040fe20007ffe0ffULL,
0x000040001f1e7824ULL, 0x000fe200078e0204ULL, 0x000000044a4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000812047824ULL, 0x000fe200078e00ffULL, 0x0000000c4a667810ULL, 0x040fe20007ffe0ffULL,
0x000000081b497824ULL, 0x000fe200078e00ffULL, 0x0000001c4a587810ULL, 0x000fe20007ffe0ffULL,
0x00000001681d7824ULL, 0x102fe200078e0227ULL, 0x00000008041f7812ULL, 0x000fe200078ec0ffULL,
0x00000001641c7824ULL, 0x100fe200078e0227ULL, 0x000000104a607810ULL, 0x040fe20007ffe0ffULL,
0x000000014a047824ULL, 0x000fe200078e0227ULL, 0x0000003f25707812ULL, 0x040fe200078ef81dULL,
0x00000040201d7824ULL, 0x000fe200078e00ffULL, 0x000000084a627810ULL, 0x000fe20007ffe0ffULL,
0x000000014e247824ULL, 0x100fe200078e0227ULL, 0x0000003f25727812ULL, 0x040fe200078ef81cULL,
0x0000000166227824ULL, 0x100fe200078e0227ULL, 0x0000003f25267812ULL, 0x040fe200078ef804ULL,
0x0000000158047824ULL, 0x100fe200078e0227ULL, 0x0000001d001c7217ULL, 0x000fe20007800000ULL,
0x0000000160217824ULL, 0x100fe200078e0227ULL, 0x0000003f25487812ULL, 0x040fe200078ef824ULL,
0x0000001008247824ULL, 0x000fe200078e00ffULL, 0x0000003f256c7812ULL, 0x000fe200078ef822ULL,
0x00000080ff637424ULL, 0x000fe200078e00ffULL, 0xfffffff049657812ULL, 0x000fe200078ec0ffULL,
0x0000000162237824ULL, 0x000fe200078e0227ULL, 0x0000003f25747812ULL, 0x040fe200078ef804ULL,
0x000000011c227824ULL, 0x000fe200078e0a1dULL, 0x0000003f256e7812ULL, 0x000fe200078ef821ULL,
0x000000001f0673c2ULL, 0x0002a200000e0000ULL, 0x000000081f047812ULL, 0x000fe200078e3cffULL,
0x00005e00261c7625ULL, 0x000fe200078e0063ULL, 0x000130001e207810ULL, 0x000fc40007ffe0ffULL,
0x0001b64865217810ULL, 0x000fe40007ffe0ffULL, 0x0000007024617812ULL, 0x000fe200078ec0ffULL,
0x00005e00481e7625ULL, 0x002fe200078e0063ULL, 0x0000003f256a7812ULL, 0x000fe200078ef823ULL,
0x00000000210573c2ULL, 0x0002a200000e0000ULL, 0x0000004022257807ULL, 0x000fe20000000000ULL,
0x0000000121047824ULL, 0x000fe200078e0204ULL, 0x000000611c1c7210ULL, 0x080fe20007f3e0ffULL,
0x0000001057577824ULL, 0x100fe200078e0220ULL, 0x000000611e1e7210ULL, 0x000fe20007f1e0ffULL,
0x00000010564d7824ULL, 0x100fe200078e0220ULL, 0x0000002527257217ULL, 0x000fe20007800000ULL,
0x0000001055557824ULL, 0x000fc400078e0220ULL, 0x0000001054597824ULL, 0x100fe400078e0220ULL,
0x0000001053537824ULL, 0x100fe400078e0220ULL, 0x00000010525b7824ULL, 0x100fe400078e0220ULL,
0x00000010515d7824ULL, 0x100fe400078e0220ULL, 0x00000010505f7824ULL, 0x000fe400078e0220ULL,
0x00005e006c227625ULL, 0x000fc800078e0063ULL, 0x00005e006a207625ULL, 0x002fe200078e0063ULL,
0x0000000605057290ULL, 0x004fc6000fffe03fULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000006122227210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000006120207210ULL, 0x000fe20007f1e0ffULL, 0x0000000125257824ULL, 0x000fe400078e0a27ULL,
0x00005e0070487625ULL, 0x000fc600078e0063ULL, 0x000000254a00720cULL, 0x000fe20003f86070ULL,
0x00005e006e267625ULL, 0x000fe200078e0063ULL, 0x000000254e00720cULL, 0x080fe40003fa6070ULL,
0x000000256200720cULL, 0x000fe20003f66070ULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000006148487210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000006126267210ULL, 0x000fe20007f1e0ffULL, 0x00005e0074507625ULL, 0x000fe200078e0063ULL,
0x000000256600720cULL, 0x000fc60003f46070ULL, 0x00005e00724a7625ULL, 0x000fe200078e0063ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c577faeULL, 0x0003e2000e101c48ULL,
0x000000256400720cULL, 0x000fe40003f86070ULL, 0x000000ffff497224ULL, 0x000fe200008e0649ULL,
0x0000006150507210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000614a4a7210ULL, 0x000fe20007f1e0ffULL, 0x000000001e4d7faeULL, 0x0005e2000e901c48ULL,
0x000000255800720cULL, 0x080fe20003fa6070ULL, 0x000000ffff517224ULL, 0x000fe200008e0651ULL,
0x000000256000720cULL, 0x080fe20003f26070ULL, 0x000000ffff4b7224ULL, 0x000fe200000e064bULL,
0x000000256800720cULL, 0x000fe20003f06070ULL, 0x0000000020557faeULL, 0x0005e8000d901c48ULL,
0x0000000022597faeULL, 0x0005ec000d101c48ULL, 0x0000000026537faeULL, 0x0005e8000c901c48ULL,
0x00000000485b7faeULL, 0x0005e8000c101c48ULL, 0x000000004a5d7faeULL, 0x0005e8000e101c48ULL,
0x00000000505f7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000400041d7984ULL, 0x0002e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01b62c00651f7984ULL, 0x004ea20000000800ULL, 0x0000ffff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff101c7812ULL, 0x000fe400078ec0ffULL, 0x000088805a5a7816ULL, 0x000fe400000000ffULL,
0x000088801c207816ULL, 0x000fc600000000ffULL, 0x000000ffff1c7224ULL, 0x000fe400078e005aULL,
0x80000000201e7824ULL, 0x000fe400078e00ffULL, 0x800000001c1c7824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x008fe4000780481cULL, 0x800000001fff7812ULL, 0x004fe2000782481eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x80000000201d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001e7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001e0000735dULL, 0x008fe40003800000ULL, 0x01b62c00651e7984ULL, 0x000ea40000000800ULL,
0x800000001eff7812ULL, 0x004fc4000782481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000401b1c7824ULL, 0x000fe200078e00ffULL,
0x00000070241f7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff6a7424ULL, 0x000fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe40000011608ULL, 0xffffff801c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1d1d7812ULL, 0x000fe400078ec0ffULL, 0x000001001f1c7810ULL, 0x000fca0007ffe01cULL,
0x000000011d1c7824ULL, 0x000fca00078e021cULL, 0x01b000001c1d7984ULL, 0x000ea80000000800ULL,
0x01b200001c1e7984ULL, 0x0007220000000800ULL, 0x0000000c1d00720bULL, 0x004fda0003f3d000ULL,
0x00000000001f7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1f1f7812ULL, 0x000fda000782c0ffULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000000c1d00720bULL, 0x018fe40003f54000ULL,
0x0000001d0c217209ULL, 0x000fe40007810000ULL, 0x00000002ff237819ULL, 0x000fc60000011608ULL,
0x800000210c1c7221ULL, 0x000fe20000010000ULL, 0x000000021b0c7811ULL, 0x000fe400078ff8ffULL,
0x0000000823257810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b1c1c7820ULL, 0x000fe20000410000ULL,
0x0000001b0c00720cULL, 0x000fe40003f25270ULL, 0x00000000000c7806ULL, 0x000fe200010e0100ULL,
0x0000001c00227308ULL, 0x000ea60000000800ULL, 0x0000ffff0c207812ULL, 0x000fc800078e3cffULL,
0x000000201fff7212ULL, 0x000fc6000784c0ffULL, 0x0000007024249812ULL, 0x000fe400078ec0ffULL,
0x00000001ff1f9819ULL, 0x000fe40000011608ULL, 0x00000001ff6a7807ULL, 0x000fe20001000000ULL,
0x000000801b249824ULL, 0x000fe200078e0224ULL, 0x0000000c1f1f9812ULL, 0x000fe200078ec0ffULL,
0x00001f23220c7589ULL, 0x004ea200000e0000ULL, 0x000000220d0d7220ULL, 0x000fe40000410000ULL,
0x800000211d1d2221ULL, 0x000fe20000010000ULL, 0x00001f25221c7589ULL, 0x000ee200000e0000ULL,
0x000000011f249824ULL, 0x000fc400078e0224ULL, 0x3fb8aa3b1d1d2820ULL, 0x000fc60000410000ULL,
0x01b4002124009388ULL, 0x0009e20000000800ULL, 0x0000001d00152308ULL, 0x000e620000000800ULL,
0x0000000c40407220ULL, 0x084fe40000410000ULL, 0x0000000c41417220ULL, 0x080fe40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x000fc40000410000ULL, 0x0000000c35357220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x080fe40000410000ULL, 0x0000000c29297220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x000fc40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c44447220ULL, 0x080fe40000410000ULL, 0x0000000c45457220ULL, 0x000fe40000410000ULL,
0x0000001c42427220ULL, 0x008fc40000410000ULL, 0x0000001c43437220ULL, 0x080fe40000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001c36367220ULL, 0x080fe40000410000ULL, 0x0000001c37377220ULL, 0x080fe40000410000ULL,
0x0000001c2a2a7220ULL, 0x000fc40000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000001c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001c32327220ULL, 0x080fe40000410000ULL, 0x0000001c33337220ULL, 0x080fe40000410000ULL,
0x0000001c3e3e7220ULL, 0x000fc40000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000001c46467220ULL, 0x080fe40000410000ULL, 0x0000001c47477220ULL, 0x000fe40000410000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0021ULL, 0x0000001e151e2220ULL, 0x002fc80000410000ULL,
0x0000000d1e0d7221ULL, 0x018fe20000010000ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x00000008121c7824ULL, 0x040fe200078e00ffULL, 0x000000011200780cULL, 0x000fe20003f05270ULL,
0x000000081b1d7824ULL, 0x000fc600078e00ffULL, 0x000000081c1c7812ULL, 0x000fe400078e0cffULL,
0xfffffff01d1d7812ULL, 0x000fca00078ec0ffULL, 0x000000011d1c7824ULL, 0x000fe200078e021cULL,
0x000000135e1d7207ULL, 0x000fc80004000000ULL, 0x0000ffff1d1d7812ULL, 0x000fe200078ec0ffULL,
0x01b64c001c1c7984ULL, 0x000ea60000000800ULL, 0x000088801d1e7816ULL, 0x000fca00000000ffULL,
0x800000001e1d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x004fe2000780481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001d0000735dULL, 0x008fe40003800000ULL, 0x00000400041d7984ULL, 0x000ea40000000800ULL,
0x800000001dff7812ULL, 0x004fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00002000121d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x002fe4000001161bULL, 0x000000074f4f7812ULL, 0x000fe400078ef808ULL,
0x000020001d1d7812ULL, 0x000fe400078e0cffULL, 0x000000804f497811ULL, 0x040fe200078e18ffULL,
0x000000084f1c7824ULL, 0x040fe200078e024cULL, 0x000001004f557811ULL, 0x000fe200078e18ffULL,
0x00004000041d7824ULL, 0x000fc400078e021dULL, 0x000000084f207824ULL, 0x000fe400078e021aULL,
0x000000014c247824ULL, 0x100fe200078e0249ULL, 0x000130001d597810ULL, 0x000fe20007ffe0ffULL,
0x000000011a497824ULL, 0x000fe400078e0249ULL, 0x000000014c4c7824ULL, 0x000fe400078e0255ULL,
0x000000101c1c7824ULL, 0x100fe400078e0259ULL, 0x0000001020207824ULL, 0x000fc400078e0259ULL,
0x0000001024247824ULL, 0x100fe400078e0259ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x0000001049497824ULL, 0x100fe400078e0259ULL, 0x000000104c4c7824ULL, 0x100fe200078e0259ULL,
0x000000002020783bULL, 0x000fe20000004200ULL, 0x000000105c507824ULL, 0x000fe400078e0259ULL,
0x000000011a1a7824ULL, 0x000fe200078e0255ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x0000001018587824ULL, 0x000fc400078e0259ULL, 0x000000101a1a7824ULL, 0x000fe200078e0259ULL,
0x000000004948783bULL, 0x000fe80000004200ULL, 0x000000004c4c783bULL, 0x000ee80000004200ULL,
0x000000005050783bULL, 0x000f280000004200ULL, 0x000000001a54783bULL, 0x000ee80000004200ULL,
0x000000005858783bULL, 0x000ee20000004200ULL, 0x00000018ffb17819ULL, 0x002fe2000001141cULL,
0x000001001c6e7824ULL, 0x040fe200078e00ffULL, 0x000088801cb87816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe2000001141dULL,
0x000001001d6f7824ULL, 0x040fe200078e00ffULL, 0x000088801db37816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x000000b800b87306ULL, 0x000fe20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fc4000001146eULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ffa67819ULL, 0x000fe4000001141eULL,
0x000088801eb07816ULL, 0x000fe200000000ffULL, 0x0000001c00b47306ULL, 0x0003e20000200c00ULL,
0x00000018ffa37819ULL, 0x000fe4000001141fULL, 0x000088801fab7816ULL, 0x000fe400000000ffULL,
0x00000018ff8d7819ULL, 0x004fc40000011424ULL, 0x00008880249c7816ULL, 0x000fe200000000ffULL,
0x0000001d00b27306ULL, 0x0005e20000200c00ULL, 0x000001001f1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011421ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011422ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000006e00b57306ULL, 0x0002e20000200c00ULL, 0x00000100201d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x0000888021a57816ULL, 0x040fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00ae7306ULL, 0x0005e20000200c00ULL,
0x000001001e6e7824ULL, 0x002fe200078e00ffULL, 0x0000888022a17816ULL, 0x000fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe40000011420ULL,
0x0000888020aa7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000001d00a77306ULL, 0x0003e20000200c00ULL, 0x00000100211c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001146fULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001e00a97306ULL, 0x000fe20000200c00ULL, 0x00000100221d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00a87306ULL, 0x0003e20000200c00ULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff687819ULL, 0x008fe4000001144fULL, 0x000088804f707816ULL, 0x000fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000001d00a07306ULL, 0x0005e20000200c00ULL,
0x00000100231c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001144bULL,
0x000088804b7e7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000001f00ac7306ULL, 0x000fe20000200c00ULL, 0x00000100241d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011423ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00008880239e7816ULL, 0x040fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c009f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff8b7819ULL, 0x000fc40000011425ULL,
0x0000888025957816ULL, 0x040fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe2000001144eULL,
0x0000001d00977306ULL, 0x0005e20000200c00ULL, 0x00000100251c7824ULL, 0x042fe200078e00ffULL,
0x000088804e727816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000002400967306ULL, 0x0003e20000200c00ULL, 0x00000100261d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff837819ULL, 0x000fe40000011426ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c009a7306ULL, 0x0005e20000200c00ULL,
0x00000002ff247819ULL, 0x002fe40000011608ULL, 0x0000888026917816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00008880278e7816ULL, 0x040fe400000000ffULL,
0x00000018ff777819ULL, 0x000fe20000011449ULL, 0x0000001d00907306ULL, 0x0003e20000200c00ULL,
0x00000100271c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x00000018ff697819ULL, 0x000fe4000001144dULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000002100a27306ULL, 0x000fe20000200c00ULL, 0x00000100481d7824ULL, 0x002fe200078e00ffULL,
0x0000888049857816ULL, 0x000fe400000000ffULL, 0x000088804d757816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x0000001c008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff827819ULL, 0x000fe20000011427ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011448ULL, 0x00008880488a7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001144aULL,
0x0000001d00877306ULL, 0x0005e20000200c00ULL, 0x00000100491c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001144cULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x000088804a817816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000002200987306ULL, 0x0003e20000200c00ULL, 0x000001004a1d7824ULL, 0x004fe200078e00ffULL,
0x000088804c7a7816ULL, 0x000fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00887306ULL, 0x0005e20000200c00ULL, 0x0000000824227810ULL, 0x002fc40007ffe0ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff627819ULL, 0x010fe20000011450ULL, 0x0000001d00807306ULL, 0x0003e20000200c00ULL,
0x000001004b1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011452ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000006f00b67306ULL, 0x0005e20000200c00ULL,
0x000001004c1d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011453ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c007f7306ULL, 0x0003e20000200c00ULL,
0x000100004f6f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff617819ULL, 0x000fe40000011451ULL, 0x00000018ff667819ULL, 0x000fe40000011454ULL,
0x0000001d00797306ULL, 0x0005e20000200c00ULL, 0x000001004d1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011455ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011456ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000002000a47306ULL, 0x0003e20000200c00ULL, 0x000001004e1d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff637819ULL, 0x000fe40000011457ULL,
0x00000018ff717819ULL, 0x000fe4000001141dULL, 0x0000001c00787306ULL, 0x0005e20000200c00ULL,
0x000099106a207816ULL, 0x002fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fc4000001146fULL,
0x000000ff2000720cULL, 0x000fe40003f05270ULL, 0x00005410b8207816ULL, 0x000fe200000000b5ULL,
0x000000b300b37306ULL, 0x000e620000200c00ULL, 0x000004001b1c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011458ULL, 0x00000018ff5c7819ULL, 0x000fe40000011459ULL,
0xfffff8001c1e7812ULL, 0x000fe200078ec0ffULL, 0x000001004f1c7824ULL, 0x000fe200078e00ffULL,
0x000000b100b17306ULL, 0x000fe20000200c00ULL, 0x00000018ff187819ULL, 0x000fc4000001145bULL,
0x000120001e1d7810ULL, 0x000fe40007ffe017ULL, 0x00000018ff737819ULL, 0x000fe4000001141cULL,
0x00000015ff17723eULL, 0x000fe200000000ffULL, 0x000000af00af7306ULL, 0x000fe20000200c00ULL,
0x000000001d1c783bULL, 0x000fe20000000200ULL, 0x00000018ff1a7819ULL, 0x000fe4000001145aULL,
0x0000541017217816ULL, 0x000fe20000000017ULL, 0x0000010050177824ULL, 0x000fc600078e00ffULL,
0x000000b000b07306ULL, 0x000fe20000200c00ULL, 0x00001f24214f7589ULL, 0x000ea800000e0000ULL,
0x00001f22216a7589ULL, 0x0002e600000e0000ULL, 0x0000006e00ad7306ULL, 0x0009e20000200c00ULL,
0x00005410b3217816ULL, 0x002fce00000000b6ULL, 0x000000ab00ab7306ULL, 0x000fe20000200c00ULL,
0x0000888052227816ULL, 0x000fe200000000ffULL, 0x000100004e6e7824ULL, 0x010fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x000000a600a67306ULL, 0x000e700000200c00ULL,
0x000000a300a37306ULL, 0x000f220000200c00ULL, 0x0000004f1c1c8232ULL, 0x004fc40000000000ULL,
0x0000004f1e1e8232ULL, 0x000fe40000000000ULL, 0x0000006a1d1d8232ULL, 0x088fe40000000000ULL,
0x0000006a1f1f8232ULL, 0x000fe20000000000ULL, 0x0000004b007c7306ULL, 0x0005e20000200c00ULL,
0x00005410a9247816ULL, 0x002fca00000000a6ULL, 0x000000201c40723cULL, 0x000fe40000001840ULL,
0x000000aa00aa7306ULL, 0x000e620000200c00ULL, 0x000000ffff4b7224ULL, 0x004fe400078e0022ULL,
0x0000010052227824ULL, 0x000fe400078e00ffULL, 0x00005410b4207816ULL, 0x000fe200000000b1ULL,
0x0001000052527824ULL, 0x000fe200078e00ffULL, 0x00005410b2217816ULL, 0x000fe200000000afULL,
0x000000a500a57306ULL, 0x000ea20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe20000011422ULL,
0x0000080004227824ULL, 0x000fe200078e0219ULL, 0x0000888053197816ULL, 0x000fc600000000ffULL,
0x000000201c38723cULL, 0x040fe40000001838ULL, 0x0000002300997306ULL, 0x0007ea0000200c00ULL,
0x00005410b0207816ULL, 0x000fe400000000adULL, 0x00005410ab217816ULL, 0x000fe200000000aeULL,
0x0000002500947306ULL, 0x0009ec0000200c00ULL, 0x000000201c34723cULL, 0x000fe20000001834ULL,
0x012000002220783bULL, 0x008ee20000000200ULL, 0x0000009d009d7306ULL, 0x000e620000200c00ULL,
0x00005410ac257816ULL, 0x010fce00000000a3ULL, 0x0000009b009b7306ULL, 0x000f220000200c00ULL,
0x000000241c28723cULL, 0x000fee0000001828ULL, 0x000000a100a17306ULL, 0x000ee20000200c00ULL,
0x00005410aa247816ULL, 0x002fe400000000a7ULL, 0x00005410a5257816ULL, 0x004fca00000000a8ULL,
0x0000009e009e7306ULL, 0x000e640000200c00ULL, 0x000000241c2c723cULL, 0x000fec000000182cULL,
0x0000009300937306ULL, 0x000ea20000200c00ULL, 0x00005410a4247816ULL, 0x000fe4000000009dULL,
0x00005410a2257816ULL, 0x010fe2000000009bULL, 0x0000004f20208232ULL, 0x008fc80000000000ULL,
0x0000009200927306ULL, 0x000ee20000200c00ULL, 0x0000004f22228232ULL, 0x000fe20000000000ULL,
0x000000241c30723cULL, 0x000fe20000001830ULL, 0x0000006a21218232ULL, 0x080fe40000000000ULL,
0x0000006a23238232ULL, 0x000fc60000000000ULL, 0x0000009c009c7306ULL, 0x000f220000200c00ULL,
0x00005410a1247816ULL, 0x000fe400000000a0ULL, 0x000054109e257816ULL, 0x002fca000000009fULL,
0x0000009500957306ULL, 0x000e640000200c00ULL, 0x000000241c3c723cULL, 0x000fec000000183cULL,
0x0000008d008d7306ULL, 0x000e620000200c00ULL, 0x0000541098247816ULL, 0x004fe40000000093ULL,
0x0000541099257816ULL, 0x008fc40000000092ULL, 0x0000888055927816ULL, 0x000fc600000000ffULL,
0x0000008b008b7306ULL, 0x000ea40000200c00ULL, 0x000000241c1c723cULL, 0x000fec0000001844ULL,
0x00000026008c7306ULL, 0x0007e20000200c00ULL, 0x000054109c247816ULL, 0x010fe20000000097ULL,
0x0000080004457824ULL, 0x000fe200078e020fULL, 0x0000541095257816ULL, 0x002fe2000000009aULL,
0x0000010056467824ULL, 0x000fe200078e00ffULL, 0x0000888057477816ULL, 0x000fc400000000ffULL,
0x00008880560f7816ULL, 0x000fe200000000ffULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000010053267824ULL, 0x048fe200078e00ffULL, 0x000000242040723cULL, 0x000fe20000001840ULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000008e008e7306ULL, 0x000ee20000200c00ULL,
0x0000541096247816ULL, 0x000fc4000000008dULL, 0x0000541094257816ULL, 0x004fca000000008bULL,
0x0000004900847306ULL, 0x0005e40000200c00ULL, 0x000000242038723cULL, 0x000fec0000001838ULL,
0x0000004d00747306ULL, 0x0009e20000200c00ULL, 0x0000888050497816ULL, 0x004fe400000000ffULL,
0x0000541091247816ULL, 0x002fc40000000090ULL, 0x000054108e257816ULL, 0x008fc6000000008fULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x00010000504d7824ULL, 0x010fc600078e00ffULL,
0x000000242034723cULL, 0x000fe40000001834ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000002600507306ULL, 0x0005f00000200c00ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x0000010054267824ULL, 0x004fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002700897306ULL, 0x0004f00000200c00ULL, 0x0000004800867306ULL, 0x0009e20000200c00ULL,
0x0000010055277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000004a007d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff487819ULL, 0x010fe40000011417ULL,
0x0000888051177816ULL, 0x000fca00000000ffULL, 0x0000004c00767306ULL, 0x0009e20000200c00ULL,
0x00000100514a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x00010000514c7824ULL, 0x010fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011452ULL, 0x00000018ff527819ULL, 0x000fe40000011453ULL,
0x0000888054537816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x0000008500857306ULL, 0x000f220000200c00ULL, 0x00000018ff4c7819ULL, 0x000fc6000001144cULL,
0x00000018ff447819ULL, 0x000fc80000011454ULL, 0x0000002600987306ULL, 0x0003f00000200c00ULL,
0x0000002700937306ULL, 0x0005e20000200c00ULL, 0x0001000055267824ULL, 0x002fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011426ULL, 0x0000004400557306ULL, 0x0003e20000200c00ULL,
0x012000004524783bULL, 0x0046ae0000000200ULL, 0x0000007b007b7306ULL, 0x000ea20000200c00ULL,
0x000054108c447816ULL, 0x002fc40000000083ULL, 0x0000541089457816ULL, 0x008fca0000000082ULL,
0x0000007700777306ULL, 0x000e640000200c00ULL, 0x000000442028723cULL, 0x000fec0000001828ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054108a447816ULL, 0x000fe40000000087ULL,
0x0000541085457816ULL, 0x010fca0000000088ULL, 0x0000007e007e7306ULL, 0x000f240000200c00ULL,
0x00000044202c723cULL, 0x040fec000000182cULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x0000541086447816ULL, 0x004fe2000000007bULL, 0x000000ffff7b7224ULL, 0x000fe200078e0047ULL,
0x0000541084457816ULL, 0x002fe20000000077ULL, 0x0000010057477824ULL, 0x040fe200078e00ffULL,
0x0000004f24248232ULL, 0x080fe20000000000ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x0000004f26268232ULL, 0x000fe20000000000ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000006a25258232ULL, 0x080fe20000000000ULL, 0x000000442030723cULL, 0x000fe20000001830ULL,
0x0000006a27278232ULL, 0x000fe20000000000ULL, 0x00000018ff477819ULL, 0x000fc80000011447ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x0000541081447816ULL, 0x008fe40000000080ULL,
0x000054107e457816ULL, 0x010fe4000000007fULL, 0x000054107d6c7816ULL, 0x000fc6000000006cULL,
0x0000007500757306ULL, 0x000ee20000200c00ULL, 0x000054107c6d7816ULL, 0x002fe2000000006dULL,
0x00000044203c723cULL, 0x040fec000000183cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0001000056447824ULL, 0x000fe200078e00ffULL, 0x0000006c201c723cULL, 0x000fe2000000181cULL,
0x0000888058457816ULL, 0x000fc600000000ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x000054107a207816ULL, 0x004fe40000000079ULL,
0x0000541075217816ULL, 0x008fe40000000078ULL, 0x00000018ff227819ULL, 0x000fe20000011457ULL,
0x0000010059577824ULL, 0x000fe400078e00ffULL, 0x0000004400237306ULL, 0x0005e40000200c00ULL,
0x000000202440723cULL, 0x000fec0000001840ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x0000080004447824ULL, 0x004fe200078e0211ULL, 0x000054106e6e7816ULL, 0x002fe20000000067ULL,
0x000000ffff217224ULL, 0x000fe200078e0045ULL, 0x00000018ff677819ULL, 0x000fe20000011457ULL,
0x0000010058207824ULL, 0x000fc400078e00ffULL, 0x0001000058577824ULL, 0x000fe200078e00ffULL,
0x0000004600827306ULL, 0x000fe40000200c00ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff577819ULL, 0x000fc80000011457ULL, 0x0000004700567306ULL, 0x0003e20000200c00ULL,
0x0000541023647816ULL, 0x008fe40000000064ULL, 0x000088805b237816ULL, 0x000fca00000000ffULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x012000004444783bULL, 0x002e6e0000000200ULL,
0x0000009200927306ULL, 0x000ef00000200c00ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541053987816ULL, 0x004fce0000000098ULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x0000541092997816ULL, 0x008fce0000000093ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000098242c723cULL, 0x000fee000000182cULL, 0x0000001700177306ULL, 0x000fe20000200c00ULL,
0x0000541049487816ULL, 0x004fe20000000048ULL, 0x0000004f44448232ULL, 0x002fc40000000000ULL,
0x0000004f46468232ULL, 0x000fe40000000000ULL, 0x0000006a45458232ULL, 0x080fe40000000000ULL,
0x0000004a004a7306ULL, 0x000e620000200c00ULL, 0x0000006a47478232ULL, 0x000fce0000000000ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541017497816ULL, 0x002fe2000000004aULL, 0x000000ffff177224ULL, 0x000fc400078e0023ULL,
0x000001005b237824ULL, 0x040fe400078e00ffULL, 0x000100005b5b7824ULL, 0x000fe400078e00ffULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x000000484440723cULL, 0x000fe20000001840ULL, 0x00000018ff5b7819ULL, 0x000fca000001145bULL,
0x0000000f000f7306ULL, 0x000e700000200c00ULL, 0x0000006b006b7306ULL, 0x000eb00000200c00ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x000054100f7a7816ULL, 0x002fc40000000082ULL,
0x000088805a0f7816ULL, 0x000fca00000000ffULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541076767816ULL, 0x004fce000000006bULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000541074777816ULL, 0x008fce0000000069ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000000762438723cULL, 0x000fee0000001838ULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x0000541055667816ULL, 0x002fce0000000066ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541072727816ULL, 0x004fce0000000071ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x0000541070737816ULL, 0x002fce0000000073ULL, 0x0000002100117306ULL, 0x0003e20000200c00ULL,
0x000054106f6f7816ULL, 0x004fe20000000068ULL, 0x000000722434723cULL, 0x040fec0000001834ULL,
0x0000006700587306ULL, 0x0005e20000200c00ULL, 0x0000888059217816ULL, 0x042fe200000000ffULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x000054107b7b7816ULL, 0x008fe20000000056ULL,
0x0000006e2428723cULL, 0x000fe60000001828ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0000541054677816ULL, 0x004fc40000000065ULL,
0x0000541022657816ULL, 0x000fe20000000063ULL, 0x000001005a227824ULL, 0x040fe200078e00ffULL,
0x0000007a243c723cULL, 0x040fe2000000183cULL, 0x000100005a5a7824ULL, 0x000fe400078e00ffULL,
0x0000002100217306ULL, 0x000ea20000200c00ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x000000662430723cULL, 0x000fe60000001830ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000541011207816ULL, 0x002fc40000000020ULL,
0x0001b66804117811ULL, 0x000fe400078e18ffULL, 0x00000064241c723cULL, 0x000fe6000000181cULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000541021217816ULL, 0x004fce0000000058ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000020442c723cULL, 0x000fee000000182cULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054104c637816ULL, 0x002fce0000000061ULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000005d005d7306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000004d004d7306ULL, 0x000e700000200c00ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054104d627816ULL, 0x002fce0000000062ULL, 0x0000001900197306ULL, 0x000e620000200c00ULL,
0x000000624438723cULL, 0x000fee0000001838ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x000054104b4e7816ULL, 0x004fce000000004eULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x00005410194f7816ULL, 0x002fce0000000050ULL, 0x0000005700687306ULL, 0x000e620000200c00ULL,
0x0000541051607816ULL, 0x008fe20000000060ULL, 0x0000004e4434723cULL, 0x000fec0000001834ULL,
0x0000005900597306ULL, 0x000ee20000200c00ULL, 0x0000541052617816ULL, 0x004fce000000005fULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x0000541068687816ULL, 0x002fe2000000005dULL,
0x000000604428723cULL, 0x000fe20000001828ULL, 0x00000001125d7812ULL, 0x000fca000782c0ffULL,
0x0000002200227306ULL, 0x000e620000200c00ULL, 0x0000541059697816ULL, 0x008fce000000005cULL,
0x0000001700247306ULL, 0x000fe20000200c00ULL, 0x000000684430723cULL, 0x000fee0000001830ULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x000054100f227816ULL, 0x002fe40000000022ULL,
0x0001b630040f7811ULL, 0x000fca00078e20ffULL, 0x0000001a001a7306ULL, 0x000ff00000200c00ULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x0000541024237816ULL, 0x004fce0000000023ULL,
0x0000005a00177306ULL, 0x000e620000200c00ULL, 0x00000022443c723cULL, 0x000fee000000183cULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x0000541017207816ULL, 0x002fe4000000001aULL,
0x000054105b217816ULL, 0x004fce0000000018ULL, 0x000000204444723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000011ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000fff7f8cULL, 0x0005e2000c80043fULL, 0x000000011200780cULL, 0x000fc80003f05270ULL,
0x000000135e137207ULL, 0x000fe40004000000ULL, 0x000000ff14ff7812ULL, 0x000fe4000780c0ffULL,
0x000000ff13ff7812ULL, 0x000fe4000784c0ffULL, 0x00000001ff5b7807ULL, 0x000fe40004000000ULL,
0x00000001ff139807ULL, 0x000fc80001000000ULL, 0x00007610135a7816ULL, 0x000fe4000000005aULL,
0x0000030016167a10ULL, 0x004fe40007ffe0ffULL, 0x000000ff10ff7812ULL, 0x000fe4000780c0ffULL,
0x000000031600720cULL, 0x000fe40003f26070ULL, 0x00000001ff107807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff9c0000007947ULL, 0x000fea000383ffffULL,
0x00000000000a7919ULL, 0x002e620000000000ULL, 0x0000000204007824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000ea40000002500ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000200027812ULL, 0x000fe200078e0cffULL, 0x000000801b007824ULL, 0x000fc600078e00ffULL,
0x0000000102027812ULL, 0x000fe200078ef81bULL, 0x000000100a057824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x120fe4000001160aULL, 0x00000002ff0e7819ULL, 0x000fe4000001160aULL,
0x0000007005117812ULL, 0x000fe400078ec0ffULL, 0x0000000c06137812ULL, 0x000fe200078ec0ffULL,
0x0000008002067824ULL, 0x000fe200078e00ffULL, 0x0001b00011027810ULL, 0x000fc40007ffe000ULL,
0x0001b20011007810ULL, 0x040fe40007ffe000ULL, 0x0001b00011057810ULL, 0x000fe20007ffe006ULL,
0x0000000113077824ULL, 0x000fe200078e0202ULL, 0x0001b20011067810ULL, 0x000fe20007ffe006ULL,
0x0000000113007824ULL, 0x000fe200078e0200ULL, 0x0000000403007c0cULL, 0x004fe2000bf03070ULL,
0x0000000113027824ULL, 0x040fe200078e0205ULL, 0x0000000c07007388ULL, 0x000fe20000000800ULL,
0x0000000113067824ULL, 0x000fc600078e0206ULL, 0x0000000d00007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000002027984ULL, 0x000e680000000800ULL,
0x0000000006067984ULL, 0x000ea20000000800ULL, 0x0000000c020b7209ULL, 0x002fca0007810000ULL,
0x0000000c0b057221ULL, 0x000fe40000010100ULL, 0x8000000b02027221ULL, 0x000fe40000010000ULL,
0x3fb8aa3b05087820ULL, 0x000fe40000410000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x3fb8aa3b02027820ULL, 0x000fe20000410000ULL, 0x00000008000f7308ULL, 0x000ef00000000800ULL,
0x0000000200037308ULL, 0x000ea20000000800ULL, 0x00001f0e0f077589ULL, 0x008ee200000e0000ULL,
0x0000000805007811ULL, 0x002fe200078ff0ffULL, 0x0000000306067220ULL, 0x004fc80000410000ULL,
0x00001f000f0a7589ULL, 0x000e6200000e0000ULL, 0x0000000d0f0d7223ULL, 0x000fe40000010006ULL,
0x0000004007407220ULL, 0x048fe40000410000ULL, 0x0000004107417220ULL, 0x040fe40000410000ULL,
0x0000003807387220ULL, 0x040fe40000410000ULL, 0x0000003907397220ULL, 0x040fe40000410000ULL,
0x0000003407347220ULL, 0x000fc40000410000ULL, 0x0000003507357220ULL, 0x040fe40000410000ULL,
0x0000002807287220ULL, 0x040fe40000410000ULL, 0x0000002907297220ULL, 0x040fe40000410000ULL,
0x0000002c072c7220ULL, 0x040fe40000410000ULL, 0x0000002d072d7220ULL, 0x040fe40000410000ULL,
0x0000003007307220ULL, 0x000fc40000410000ULL, 0x0000003107317220ULL, 0x040fe40000410000ULL,
0x0000003c073c7220ULL, 0x040fe40000410000ULL, 0x0000003d073d7220ULL, 0x040fe40000410000ULL,
0x0000004407447220ULL, 0x040fe40000410000ULL, 0x0000004507457220ULL, 0x000fe40000410000ULL,
0x000000420a427220ULL, 0x002fc40000410000ULL, 0x000000430a437220ULL, 0x040fe40000410000ULL,
0x0000003a0a3a7220ULL, 0x040fe40000410000ULL, 0x0000003b0a3b7220ULL, 0x040fe40000410000ULL,
0x000000360a367220ULL, 0x040fe40000410000ULL, 0x000000370a377220ULL, 0x040fe40000410000ULL,
0x0000002a0a2a7220ULL, 0x000fc40000410000ULL, 0x0000002b0a2b7220ULL, 0x040fe40000410000ULL,
0x0000002e0a2e7220ULL, 0x040fe40000410000ULL, 0x0000002f0a2f7220ULL, 0x040fe40000410000ULL,
0x000000320a327220ULL, 0x040fe40000410000ULL, 0x000000330a337220ULL, 0x040fe40000410000ULL,
0x0000003e0a3e7220ULL, 0x000fc40000410000ULL, 0x0000003f0a3f7220ULL, 0x040fe40000410000ULL,
0x000000460a467220ULL, 0x040fe40000410000ULL, 0x000000470a477220ULL, 0x000fe20000410000ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000000d007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e000dULL, 0x00007af000067802ULL, 0x000fe40000000f00ULL,
0x0000a57000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0002ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000d00007308ULL, 0x000e640000001000ULL,
0xbf8000000d027423ULL, 0x002fc80000000000ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x00000002ff067819ULL, 0x002fe20000011605ULL, 0x0000000003077220ULL, 0x004fe20000410000ULL,
0x0000000805007811ULL, 0x000fc800078ff0ffULL, 0x00001f0607067589ULL, 0x000e6800000e0000ULL,
0x00001f0007087589ULL, 0x000ea200000e0000ULL, 0x0000000640407220ULL, 0x082fe40000410000ULL,
0x0000000641417220ULL, 0x080fe40000410000ULL, 0x0000000638387220ULL, 0x080fe40000410000ULL,
0x0000000639397220ULL, 0x000fc40000410000ULL, 0x0000000634347220ULL, 0x080fe40000410000ULL,
0x0000000635357220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x080fe40000410000ULL,
0x0000000629297220ULL, 0x080fe40000410000ULL, 0x000000062c2c7220ULL, 0x080fe40000410000ULL,
0x000000062d2d7220ULL, 0x000fc40000410000ULL, 0x0000000630307220ULL, 0x080fe40000410000ULL,
0x0000000631317220ULL, 0x080fe40000410000ULL, 0x000000063c3c7220ULL, 0x080fe40000410000ULL,
0x000000063d3d7220ULL, 0x080fe40000410000ULL, 0x0000000644447220ULL, 0x080fe40000410000ULL,
0x0000000645457220ULL, 0x000fc40000410000ULL, 0x0000000842427220ULL, 0x084fe40000410000ULL,
0x0000000843437220ULL, 0x080fe40000410000ULL, 0x000000083a3a7220ULL, 0x080fe40000410000ULL,
0x000000083b3b7220ULL, 0x080fe40000410000ULL, 0x0000000836367220ULL, 0x080fe40000410000ULL,
0x0000000837377220ULL, 0x000fc40000410000ULL, 0x000000082a2a7220ULL, 0x080fe40000410000ULL,
0x000000082b2b7220ULL, 0x080fe40000410000ULL, 0x000000082e2e7220ULL, 0x080fe40000410000ULL,
0x000000082f2f7220ULL, 0x080fe40000410000ULL, 0x0000000832327220ULL, 0x080fe40000410000ULL,
0x0000000833337220ULL, 0x000fc40000410000ULL, 0x000000083e3e7220ULL, 0x080fe40000410000ULL,
0x000000083f3f7220ULL, 0x080fe40000410000ULL, 0x0000000846467220ULL, 0x080fe40000410000ULL,
0x0000000847477220ULL, 0x000fe40000410000ULL, 0x0000000205027812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff0a7819ULL, 0x100fe20000011605ULL,
0x0000002004127824ULL, 0x000fe200078e0205ULL, 0x0000000202117811ULL, 0x000fc400078ff8ffULL,
0x00000001ff077819ULL, 0x000fe40000011602ULL, 0x0000000402157811ULL, 0x040fe400078ff8ffULL,
0x0000000602197811ULL, 0x000fe400078ff8ffULL, 0x0000000711037812ULL, 0x100fe400078e780aULL,
0x0000000707027812ULL, 0x100fe400078e780aULL, 0x0000000715067812ULL, 0x100fe200078e780aULL,
0x000000080a137824ULL, 0x040fe200078e0203ULL, 0x0000000719087812ULL, 0x000fe200078e780aULL,
0x0000100009037824ULL, 0x000fe200078e00ffULL, 0x0000000707077812ULL, 0x000fe200078e7800ULL,
0x000000080a0f7824ULL, 0x000fe200078e0202ULL, 0x0000000711117812ULL, 0x100fe200078e7800ULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0x0000000715157812ULL, 0x100fe200078e7800ULL,
0x0000000800077824ULL, 0x040fe200078e0207ULL, 0x0000000719197812ULL, 0x000fe200078e7800ULL,
0x0000000800117824ULL, 0x000fe200078e0211ULL, 0x0000000802027812ULL, 0x000fe200078ec0ffULL,
0x0000000800157824ULL, 0x040fe200078e0215ULL, 0x000000404140723eULL, 0x000fe200000000ffULL,
0x0000000800197824ULL, 0x000fe200078e0219ULL, 0x000000383920723eULL, 0x000fe200000000ffULL,
0x0000080004007824ULL, 0x000fe200078e0203ULL, 0x000000343534723eULL, 0x000fe200000000ffULL,
0x000000080a177824ULL, 0x000fe200078e0206ULL, 0x0000541040227816ULL, 0x040fe20000000020ULL,
0x000000100f0f7824ULL, 0x000fe200078e0200ULL, 0x0000763240237816ULL, 0x000fe20000000020ULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0x00000028291a723eULL, 0x000fe200000000ffULL,
0x000000010f0f7824ULL, 0x000fe200078e0202ULL, 0x0000002c2d2c723eULL, 0x000fe200000000ffULL,
0x0000000102137824ULL, 0x000fe200078e0213ULL, 0x00005410340e7816ULL, 0x000fe2000000001aULL,
0x0000001017177824ULL, 0x000fe200078e0200ULL, 0x000000220f007388ULL, 0x0003e20000000a00ULL,
0x000000303116723eULL, 0x000fe200000000ffULL, 0x000000080a1d7824ULL, 0x000fe200078e0208ULL,
0x0000003c3d3c723eULL, 0x000fe200000000ffULL, 0x0000000102177824ULL, 0x040fe200078e0217ULL,
0x00000044451e723eULL, 0x000fe200000000ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x000000424342723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000003a3b21723eULL, 0x000fe200000000ffULL, 0x00000001021d7824ULL, 0x040fe200078e021dULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x00007632340f7816ULL, 0x002fe2000000001aULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x0000541042207816ULL, 0x140fe20000000021ULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000763242217816ULL, 0x000fe20000000021ULL, 0x0000000e13007388ULL, 0x0003e20000000a00ULL,
0x0000002a2b2a723eULL, 0x000fe200000000ffULL, 0x0000000102117824ULL, 0x000fe200078e0211ULL,
0x0000002e2f2e723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x000fe200078e0200ULL,
0x0000541036067816ULL, 0x000fe2000000002aULL, 0x0000000102157824ULL, 0x040fe200078e0215ULL,
0x0000003e3f3e723eULL, 0x000fe200000000ffULL, 0x0000000102197824ULL, 0x000fe200078e0219ULL,
0x00000046471f723eULL, 0x000fe200000000ffULL, 0x0000001012087824ULL, 0x000fe200078e0203ULL,
0x000054102c0e7816ULL, 0x002fc40000000016ULL, 0x000076322c0f7816ULL, 0x000fca0000000016ULL,
0x0000000e17007388ULL, 0x0003e40000000a00ULL, 0x000054103c0e7816ULL, 0x142fe4000000001eULL,
0x000076323c0f7816ULL, 0x000fe4000000001eULL, 0x000000323317723eULL, 0x000fc600000000ffULL,
0x0000000e1d007388ULL, 0x000fe20000000a00ULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x0000002007007388ULL, 0x0003e40000000a00ULL,
0x0000763236077816ULL, 0x002fca000000002aULL, 0x0000000611007388ULL, 0x0003e80000000a00ULL,
0x0000001615007388ULL, 0x0005e20000000a00ULL, 0x000054103e067816ULL, 0x142fe4000000001fULL,
0x000076323e077816ULL, 0x000fe2000000001fULL, 0x00000300ff167624ULL, 0x004fc800078e00ffULL,
0x0000000619007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000011600780cULL, 0x000fca0003f05270ULL, 0x00000000081c7984ULL, 0x000e680000000c00ULL,
0x0004000008247984ULL, 0x000ea80000000c00ULL, 0x0008000008207984ULL, 0x000ee80000000c00ULL,
0x000c000008287984ULL, 0x000f220000000c00ULL, 0x200000ff1f1f7230ULL, 0x002fc40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x008fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe40000000000ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x010fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001c08007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002408007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000304000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7919ULL, 0x000ea20000002700ULL,
0x0000580016027a24ULL, 0x000fe200078e02ffULL, 0x0000000104ff7812ULL, 0x000fe2000780f81bULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00006600020a7a24ULL, 0x000fe200078e02ffULL, 0x0000004012157810ULL, 0x000fe20007ffe0ffULL,
0x0000080009067824ULL, 0x000fe200078e00ffULL, 0x00000000081c7984ULL, 0x002e640000000c00ULL,
0x00000fff0a027811ULL, 0x000fc400078e40ffULL, 0x0004000008207984ULL, 0x0007240000000c00ULL,
0x01ffffff0a087812ULL, 0x008fe200078ec0ffULL, 0x000058000c0c7a24ULL, 0x004fc800078e0207ULL,
0x000003000c077a24ULL, 0x000fca00078e02ffULL, 0x0000000407117c10ULL, 0x000fc8000fffe0ffULL,
0x00000011020e7211ULL, 0x000fca00078fa0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e000fULL,
0x000000060e0e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000ff0500720cULL, 0x000fc60000725670ULL, 0x0000001012127825ULL, 0x000fc800078e000eULL,
0x0000001015147825ULL, 0x000fe200078e000eULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010050e7824ULL, 0x012fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011605ULL,
0x00000080ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000000111107824ULL, 0x000fe200078e0208ULL,
0x000000700e177812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f187812ULL, 0x000fe200078ec0ffULL,
0x00006c00110e7625ULL, 0x000fc800078e000aULL, 0x00006c0010107625ULL, 0x000fe200078e000aULL,
0x0000000e180e7210ULL, 0x000fc80007a1e017ULL, 0x0000001018107210ULL, 0x000fe40007c7e017ULL,
0x0000000fff0f7210ULL, 0x000fe400007e44ffULL, 0x00000011ff117210ULL, 0x000fc60001fe84ffULL,
0x0000000b0e007986ULL, 0x0003e8000c101908ULL, 0x0000000d10007986ULL, 0x0003e4000c101908ULL,
0x0000001c12007986ULL, 0x0123e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000002014007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0xffffffff160d7810ULL, 0x000fc60007ffe0ffULL, 0x00006a000c0a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000d0a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x000ee40000000000ULL,
0x000000ff0a00720cULL, 0x008fda0003f05270ULL, 0x00002c7000008947ULL, 0x000fea0003800000ULL,
0x000000ff1b00720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000010050a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011605ULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001070c7810ULL, 0x004fe40007ffe0ffULL,
0x000000700a197812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b107812ULL, 0x000fe200078ec0ffULL,
0x00006c00070a7625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a100a7210ULL, 0x000fc8000791e019ULL, 0x0000000c100c7210ULL, 0x000fe40007b5e019ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000080a0a7981ULL, 0x000568000c1e1900ULL, 0x000000080c117981ULL, 0x000562000c1e1900ULL,
0x000000021600780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002070c7810ULL, 0x004fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c0b7981ULL, 0x000562000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003070c7810ULL, 0x004fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c137981ULL, 0x002362000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004070c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c157981ULL, 0x000362000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005070c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c177981ULL, 0x000362000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081600780cULL, 0x002fe40003f06070ULL, 0x00000006070c7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fe40007a3e019ULL,
0x00000007070e0810ULL, 0x000fe40007ffe0ffULL, 0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL,
0x00006c000e0e0625ULL, 0x000fca00078e000fULL, 0x0000000e100e0210ULL, 0x000fe40007c7e019ULL,
0x000000080c197981ULL, 0x000364000c1e1900ULL, 0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL,
0x000000080e1d0981ULL, 0x000368000c1e1900ULL, 0x00000007160c7810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff0e7819ULL, 0x000fc8000001160cULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x020fe400078e000aULL, 0x000000080f107824ULL, 0x040fe200078e00ffULL,
0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000e0f00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008100c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001f0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff147819ULL, 0x000fe20000011605ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001005127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x00000070121f7812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e01fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c1f7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000110a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff127819ULL, 0x000fe20000011605ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001005117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c117981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003100d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e00bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c0b7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001005127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012137812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005100d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000150a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff147819ULL, 0x000fe20000011605ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001005127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012157812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e015ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000170a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001005127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012177812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e017ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007100d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000190a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff147819ULL, 0x000fe20000011605ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001005127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012197812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e019ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001d0a0a7209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff127819ULL, 0x000fe20000011605ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001005107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x00000070101d7812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007a3e01dULL, 0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL,
0x000000080c1d7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x00000010050b7824ULL, 0x024fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x002fc80000011605ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fca00078ec0ffULL, 0x000000010c0b7824ULL, 0x000fca00078e020bULL,
0x0000000a0b007388ULL, 0x0003e40000000800ULL, 0x000000070500780cULL, 0x040fe20003f04070ULL,
0x0000000104197824ULL, 0x000fe200078e0207ULL, 0x00000001ff0d7819ULL, 0x000fe20000011605ULL,
0x00000010050c7824ULL, 0x004fe200078e00ffULL, 0x00000002ff0a7819ULL, 0x002fe2000001161bULL,
0x00001000ff107424ULL, 0x000fe200078e00ffULL, 0x00000019020b7211ULL, 0x000fe200078fa0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000c0d0f7812ULL, 0x000fe200078ec0ffULL,
0x000002001b1b7824ULL, 0x000fe200078e00ffULL, 0x000000700c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000010a0d7812ULL, 0x000fe200078ec0ffULL,
0x00000002040c8824ULL, 0x000fe200078e0209ULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x00006c000b0a7625ULL, 0x000fe200078e0010ULL, 0x0000004005117810ULL, 0x040fe20007ffe0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000006005157810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1a7824ULL, 0x000fe200078e020eULL, 0x00000020050f7810ULL, 0x000fe20007ffe0ffULL,
0x000000020c168824ULL, 0x000fe200078e020dULL, 0x000000060a0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000002040e8824ULL, 0x040fe200078e0209ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00002000040a7824ULL, 0x000fe200078e0203ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020e1c8824ULL, 0x000fe200078e020dULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000010a0e7824ULL, 0x000fe200078e021bULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000108128824ULL, 0x000fc400078e0219ULL, 0x00000080ff138424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x0000030004007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff188424ULL, 0x000fe200078e00ffULL, 0x000000001a0b7984ULL, 0x0002a20000000800ULL,
0x00000010051b7824ULL, 0x000fe400078e020eULL, 0x00006c0012128625ULL, 0x000fc800078e0013ULL,
0x000000100f0e7825ULL, 0x000fc800078e000cULL, 0x0000001011107825ULL, 0x000fc800078e000cULL,
0x0000001015147825ULL, 0x000fc800078e000cULL, 0x00006c0019188625ULL, 0x000fc800078e0018ULL,
0x00000008161d8824ULL, 0x000fe400078e0205ULL, 0x00000010050c7825ULL, 0x000fc600078e000cULL,
0x000045801d1d8811ULL, 0x000fe200078e20ffULL, 0x000000081c1c8824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1b7faeULL, 0x0007e2000b901c48ULL,
0x0000001005168825ULL, 0x040fe400078e0012ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000041801c1f8811ULL, 0x000fe200078e20ffULL, 0x0000001005188825ULL, 0x000fe200078e0018ULL,
0x003800000e1b7faeULL, 0x0009e6000b901c48ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x00580000101b7faeULL, 0x000be2000b901c48ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00780000141b7faeULL, 0x0007e8000b901c48ULL, 0x00000000161d8faeULL, 0x0005e2000b901c48ULL,
0x00000000000e7805ULL, 0x010fc6000001ff00ULL, 0x00000000181f8faeULL, 0x0009e2000b901c48ULL,
0x0000000000107805ULL, 0x020fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x004fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x010fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000e0000001947ULL, 0x000fea0003800000ULL, 0x00000df000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff317224ULL, 0x000fca00078e0004ULL,
0x0000000231307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe200078e0031ULL,
0x00000002ff2e7819ULL, 0x002fe20000011605ULL, 0x0000000204327824ULL, 0x000fe200078e0209ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x00000040432f7824ULL, 0x000fe200078e00ffULL,
0x000000072e4a7812ULL, 0x040fe200078ec0ffULL, 0x000000082e317824ULL, 0x040fe200078e00ffULL,
0x0000002eff4c7212ULL, 0x000fe200078e33ffULL, 0x000000082e2d7824ULL, 0x040fe200078e00ffULL,
0x000000802f2f7812ULL, 0x000fe200078ec0ffULL, 0x000000082e337824ULL, 0x008fe200078e00ffULL,
0x0000039000017945ULL, 0x000fe20003800000ULL, 0xfffffff8313e7812ULL, 0x100fe200078ee24aULL,
0x0000001005457824ULL, 0x000fe200078e00ffULL, 0x000000012d407812ULL, 0x140fe200078ef64aULL,
0x0000010032417824ULL, 0x000fe200078e002fULL, 0x000000022d427812ULL, 0x000fc400078ef64aULL,
0x000000032d447812ULL, 0x140fe400078ef64aULL, 0x000000042d467812ULL, 0x140fe400078ef64aULL,
0x000000052d487812ULL, 0x140fe400078ef64aULL, 0x000000062d4a7812ULL, 0x000fe400078ef64aULL,
0xfffffff8334c7812ULL, 0x000fe400078ee24cULL, 0x000000082e2d7810ULL, 0x000fe20007ffe0ffULL,
0x000002c000000947ULL, 0x000fea0003800000ULL, 0x00000001073d7824ULL, 0x100fe200078e0230ULL,
0x000000070500780cULL, 0x000fe20003f24070ULL, 0x00001000ff337424ULL, 0x000fe200078e00ffULL,
0x00000001ff2f7819ULL, 0x000fc40000011630ULL, 0x0000003d02327211ULL, 0x000fe400078fa0ffULL,
0x000000012f317812ULL, 0x000fe200078ec0ffULL, 0x00000400302f7824ULL, 0x000fe200078e00ffULL,
0x0000002005377810ULL, 0x040fe20007ffe0ffULL, 0x00006c0032327625ULL, 0x000fe200078e0033ULL,
0x0000004005397810ULL, 0x000fe40007ffe0ffULL, 0x000008002f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000204349824ULL, 0x100fe200078e0209ULL, 0x0000000632327210ULL, 0x000fe20007f1e0ffULL,
0x00000002044e9824ULL, 0x000fc400078e0209ULL, 0x0000000234509824ULL, 0x100fe400078e0231ULL,
0x000000024e4e9824ULL, 0x000fe200078e0231ULL, 0x0000006005317810ULL, 0x000fe20007ffe0ffULL,
0x000000010a347824ULL, 0x000fe400078e022fULL, 0x000000ffff337224ULL, 0x000fe400000e0633ULL,
0x00000001083a9824ULL, 0x000fe400078e023dULL, 0x00000080ff3b9424ULL, 0x000fc400078e00ffULL,
0x00000080ff3c9424ULL, 0x000fe400078e00ffULL, 0x00000010052f7824ULL, 0x040fe400078e0234ULL,
0x0000001005347825ULL, 0x000fc800078e0032ULL, 0x0000001037367825ULL, 0x100fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000342f7faeULL, 0x0003e6000b901c48ULL,
0x0000001039387825ULL, 0x100fe200078e0032ULL, 0x00380000362f7faeULL, 0x0003e6000b901c48ULL,
0x00006c003a3a9625ULL, 0x000fe200078e003bULL, 0x00580000382f7faeULL, 0x0003e6000b901c48ULL,
0x0000001031327825ULL, 0x000fc800078e0032ULL, 0x00006c003d3c9625ULL, 0x000fe200078e003cULL,
0x00780000322f7faeULL, 0x0003e6000b901c48ULL, 0x000000084e319824ULL, 0x100fe400078e0205ULL,
0x00000008503f9824ULL, 0x000fe400078e0205ULL, 0x00000010053a9825ULL, 0x000fe200078e003aULL,
0x0000458031319811ULL, 0x000fe400078e20ffULL, 0x000041803f3f9811ULL, 0x000fe200078e20ffULL,
0x00000010053c9825ULL, 0x000fc400078e003cULL, 0x000000003a319faeULL, 0x0003e8000b901c48ULL,
0x000000003c3f9faeULL, 0x0003e4000b901c48ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff327819ULL, 0x002fe20000011605ULL,
0x00000400432f7824ULL, 0x000fe200078e00ffULL, 0x0000007045507812ULL, 0x000fe200078ec0ffULL,
0x000000082d367824ULL, 0x040fe200078e00ffULL, 0x0000000c32337812ULL, 0x000fe200078ec0ffULL,
0x000000082d347824ULL, 0x040fe200078e00ffULL, 0x000000072d317812ULL, 0x000fc400078ec0ffULL,
0x0000004133417210ULL, 0x000fe20007ffe050ULL, 0x000000082d337824ULL, 0x000fe200078e00ffULL,
0xfffffff836327812ULL, 0x100fe400078ee231ULL, 0x000008002f2f7812ULL, 0x000fe400078ec0ffULL,
0x0000000134367812ULL, 0x140fe400078ef631ULL, 0x0000000234387812ULL, 0x140fe400078ef631ULL,
0x00000003343a7812ULL, 0x000fc400078ef631ULL, 0x00000004343c7812ULL, 0x140fe400078ef631ULL,
0x00000005344e7812ULL, 0x000fe200078ef631ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800041527984ULL, 0x000e620000000800ULL, 0x0000000634347812ULL, 0x000fe200078ef631ULL,
0x0000000405317824ULL, 0x000fe200078e00ffULL, 0x0000002dff507212ULL, 0x000fe200078e33ffULL,
0x0045800041417984ULL, 0x000fe20000000800ULL, 0x000001800a2f7810ULL, 0x000fe40007ffe02fULL,
0xfffffff833507812ULL, 0x000fe400078ee250ULL, 0x0000000c31317812ULL, 0x000fe200078ec0ffULL,
0x000000103e3e7824ULL, 0x000fc400078e022fULL, 0x0000001040407824ULL, 0x100fe400078e022fULL,
0x0000001042427824ULL, 0x100fe400078e022fULL, 0x0000001044447824ULL, 0x100fe400078e022fULL,
0x0000001046467824ULL, 0x100fe400078e022fULL, 0x0000001048487824ULL, 0x100fe400078e022fULL,
0x000000104a4a7824ULL, 0x000fc400078e022fULL, 0x0000001038387824ULL, 0x100fe400078e022fULL,
0x000000103a3a7824ULL, 0x100fe400078e022fULL, 0x000000103c3c7824ULL, 0x100fe400078e022fULL,
0x000000104e4e7824ULL, 0x100fe400078e022fULL, 0x000000104c4c7824ULL, 0x100fe400078e022fULL,
0x0000001050507824ULL, 0x000fc400078e022fULL, 0x0000001032327824ULL, 0x100fe400078e022fULL,
0x0000001036367824ULL, 0x100fe400078e022fULL, 0x0000001034347824ULL, 0x000fe400078e022fULL,
0x000000013e3e7824ULL, 0x000fe400078e0231ULL, 0x0000000131407824ULL, 0x040fe400078e0240ULL,
0x0000000131427824ULL, 0x000fc400078e0242ULL, 0x0000000131447824ULL, 0x040fe200078e0244ULL,
0x000000003e3e7984ULL, 0x000ea20000000800ULL, 0x0000000131467824ULL, 0x040fe400078e0246ULL,
0x0000000131487824ULL, 0x040fe200078e0248ULL, 0x0000000040407984ULL, 0x000ee20000000800ULL,
0x00000001314a7824ULL, 0x040fe400078e024aULL, 0x00000001314c7824ULL, 0x040fe200078e024cULL,
0x0000000042427984ULL, 0x000f220000000800ULL, 0x0000000131387824ULL, 0x000fc400078e0238ULL,
0x00000001313a7824ULL, 0x040fe200078e023aULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x00000001313c7824ULL, 0x040fe400078e023cULL, 0x00000001314e7824ULL, 0x040fe200078e024eULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x0000000131507824ULL, 0x040fe400078e0250ULL,
0x0000000131327824ULL, 0x040fe200078e0232ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x0000000131367824ULL, 0x000fc400078e0236ULL, 0x0000000131347824ULL, 0x000fe200078e0234ULL,
0x000000004a4a7984ULL, 0x000f620000000800ULL, 0x000000520b527221ULL, 0x002fe40000010100ULL,
0x000000ffff317224ULL, 0x000fe200078e0030ULL, 0x000000004c4c7984ULL, 0x000e620000000800ULL,
0x3fb8aa3b52527820ULL, 0x000fc60000410000ULL, 0x0000000038387984ULL, 0x000e620000000800ULL,
0x0000030031007a0cULL, 0x000fe40003f06070ULL, 0x0000005200527308ULL, 0x000f220000000800ULL,
0x000000003a3a7984ULL, 0x000e680000000800ULL, 0x000000003c3c7984ULL, 0x000e620000000800ULL,
0x2000003eff377230ULL, 0x104fe40000004100ULL, 0x3000003eff397230ULL, 0x000fe20000004100ULL,
0x000000004e4e7984ULL, 0x000ea20000000800ULL, 0x20000040ff3b7230ULL, 0x008fc40000004100ULL,
0x30000040ff3d7230ULL, 0x000fe20000004100ULL, 0x0000000050507984ULL, 0x000ee20000000800ULL,
0x20000042ff3e7230ULL, 0x110fe20000004100ULL, 0x0000004152337220ULL, 0x000fe40000410000ULL,
0x0000000032327984ULL, 0x000f220000000800ULL, 0x30000042ff3f7230ULL, 0x000fe40000004100ULL,
0x20000044ff407230ULL, 0x120fe20000004100ULL, 0x0000000036367984ULL, 0x000f620000000800ULL,
0x30000044ff417230ULL, 0x000fe20000004100ULL, 0x0000002c332c7221ULL, 0x000fe20000010000ULL,
0x20000046ff427230ULL, 0x100fe20000004100ULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x30000046ff437230ULL, 0x000fc40000004100ULL, 0x20000048ff447230ULL, 0x100fe40000004100ULL,
0x30000048ff457230ULL, 0x000fe40000004100ULL, 0x2000004aff467230ULL, 0x100fe40000004100ULL,
0x3000004aff477230ULL, 0x000fe40000004100ULL, 0x2000004cff487230ULL, 0x102fe40000004100ULL,
0x3000004cff497230ULL, 0x000fc40000004100ULL, 0x20000038ff527230ULL, 0x000fe40000004100ULL,
0x2000003aff547230ULL, 0x000fe40000004100ULL, 0x30000038ff387230ULL, 0x000fe40000004100ULL,
0x2000003cff567230ULL, 0x000fe40000004100ULL, 0x3000003aff3a7230ULL, 0x000fe40000004100ULL,
0x2000004eff587230ULL, 0x004fc40000004100ULL, 0x3000003cff3c7230ULL, 0x000fe40000004100ULL,
0x20000050ff5c7230ULL, 0x008fe40000004100ULL, 0x3000004eff4e7230ULL, 0x000fe40000004100ULL,
0x20000032ff4a7230ULL, 0x110fe40000004100ULL, 0x30000032ff4b7230ULL, 0x000fe40000004100ULL,
0x20000036ff4c7230ULL, 0x020fc40000004100ULL, 0x30000036ff4d7230ULL, 0x000fe40000004100ULL,
0x20000034ff5a7230ULL, 0x100fe40000004100ULL, 0x30000034ff4f7230ULL, 0x000fe40000004100ULL,
0x30000050ff507230ULL, 0x000fe20000004100ULL, 0x000074227f007947ULL, 0x000fea000b800000ULL,
0x00001f2e33307589ULL, 0x0002a400000e0000ULL, 0x000074727f007947ULL, 0x000fea000b800000ULL,
0x00001f2d332d7589ULL, 0x00072400000e0000ULL, 0x00000030372b7223ULL, 0x084fe4000001002bULL,
0x00000030392a7223ULL, 0x080fe4000001002aULL, 0x000000303b277223ULL, 0x000fc40000010027ULL,
0x000000303d267223ULL, 0x080fe40000010026ULL, 0x000000303e237223ULL, 0x080fe40000010023ULL,
0x000000303f227223ULL, 0x080fe40000010022ULL, 0x00000030401f7223ULL, 0x080fe4000001001fULL,
0x00000030411e7223ULL, 0x080fe4000001001eULL, 0x00000030421b7223ULL, 0x000fc4000001001bULL,
0x00000030431a7223ULL, 0x080fe4000001001aULL, 0x0000003044177223ULL, 0x080fe40000010017ULL,
0x0000003045167223ULL, 0x080fe40000010016ULL, 0x0000003046137223ULL, 0x080fe40000010013ULL,
0x0000003047127223ULL, 0x080fe40000010012ULL, 0x00000030480f7223ULL, 0x000fc4000001000fULL,
0x00000030490e7223ULL, 0x000fe4000001000eULL, 0x0000002d4a297223ULL, 0x090fe40000010029ULL,
0x0000002d4b287223ULL, 0x080fe40000010028ULL, 0x0000002d4c257223ULL, 0x080fe40000010025ULL,
0x0000002d4d247223ULL, 0x080fe40000010024ULL, 0x0000002d52217223ULL, 0x000fc40000010021ULL,
0x0000002d38207223ULL, 0x080fe40000010020ULL, 0x0000002d541d7223ULL, 0x080fe4000001001dULL,
0x0000002d3a1c7223ULL, 0x080fe4000001001cULL, 0x0000002d56197223ULL, 0x080fe40000010019ULL,
0x0000002d3c187223ULL, 0x080fe40000010018ULL, 0x0000002d58157223ULL, 0x000fc40000010015ULL,
0x0000002d4e147223ULL, 0x080fe40000010014ULL, 0x0000002d5a117223ULL, 0x080fe40000010011ULL,
0x0000002d4f107223ULL, 0x080fe40000010010ULL, 0x0000002d5c0d7223ULL, 0x080fe4000001000dULL,
0x0000002d500c7223ULL, 0x000fe2000001000cULL, 0xfffff24000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000001002057824ULL, 0x004fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000102067824ULL, 0x000fe200078e0205ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x0000001002057824ULL, 0x004fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fc600078ec0ffULL,
0x0000008004057824ULL, 0x000fc800078e0205ULL, 0x0000000105057824ULL, 0x000fca00078e0202ULL,
0x0049802c05007388ULL, 0x0005e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800006027984ULL, 0x000f280000000800ULL, 0x004a000006057984ULL, 0x004ea20000000800ULL,
0x00000002ff027221ULL, 0x010fc80000010000ULL, 0x0000000502027221ULL, 0x004fca0000010000ULL,
0x0180000002057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0002ULL,
0x0000aa6000067802ULL, 0x000fe40000000f00ULL, 0x0000760000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff067224ULL, 0x00cfe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200057308ULL, 0x000ea40000001000ULL, 0xbf80000002067423ULL, 0x004fc80000000005ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000605067223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x002e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000805317811ULL, 0x002fe400078ff0ffULL,
0x00000002ff2f7819ULL, 0x000fe40000011605ULL, 0x00000031ff2d7212ULL, 0x000fe200078e33ffULL,
0x00001f3106077589ULL, 0x000e6200000e0000ULL, 0x0000000831087824ULL, 0x000fc400078e00ffULL,
0x000000082f337824ULL, 0x008fe200078e00ffULL, 0x00001f2f06027589ULL, 0x0004e200000e0000ULL,
0x0000000831307824ULL, 0x000fe200078e00ffULL, 0xfffffff8082d7812ULL, 0x000fe200078ee22dULL,
0x000000082f087824ULL, 0x000fc800078e00ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0200ULL,
0x0000002fff067212ULL, 0x004fc800078e33ffULL, 0xfffffff833337812ULL, 0x000fe400078ee206ULL,
0x000000072f067812ULL, 0x000fe200078ec0ffULL, 0x0000002507257220ULL, 0x002fc60000410000ULL,
0x00000002060a7812ULL, 0x040fe200078e3cffULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x00000004062c7812ULL, 0x000fe200078e3cffULL, 0x0000002302237220ULL, 0x008fe20000410000ULL,
0x00000005062e7812ULL, 0x000fe200078e3cffULL, 0x0000002202227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002907297220ULL, 0x040fe40000410000ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000002107217220ULL, 0x000fe20000410000ULL, 0x0000000731237812ULL, 0x000fe200078ec0ffULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000001d071d7220ULL, 0x000fc40000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000001907197220ULL, 0x000fe20000410000ULL,
0x0000000523217812ULL, 0x000fe200078e3cffULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000001507157220ULL, 0x040fe40000410000ULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000001107117220ULL, 0x000fc40000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000d070d7220ULL, 0x040fe40000410000ULL,
0x0000000c070c7220ULL, 0x000fe20000410000ULL, 0xfffffff808077812ULL, 0x000fe200078ee22fULL,
0x0000002b022b7220ULL, 0x000fe20000410000ULL, 0x0000000106087812ULL, 0x000fe200078e3cffULL,
0x0000002a022a7220ULL, 0x000fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000002702277220ULL, 0x000fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000002602267220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000001f021f7220ULL, 0x000fc40000410000ULL, 0x0000001e021e7220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000001b021b7220ULL, 0x040fe40000410000ULL,
0x0000001a021a7220ULL, 0x000fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x0000001702177220ULL, 0x040fe40000410000ULL, 0x0000001602167220ULL, 0x000fe20000410000ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000001302137220ULL, 0x000fc40000410000ULL,
0x0000001202127220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000000f020f7220ULL, 0x000fe20000410000ULL, 0xfffffff830177812ULL, 0x000fe200078ee231ULL,
0x0000000e02027220ULL, 0x000fe20000410000ULL, 0x00000003060e7812ULL, 0x040fe200078e3cffULL,
0x0000000405257824ULL, 0x000fe200078e00ffULL, 0x0000000606067812ULL, 0x000fe200078e3cffULL,
0x000000082f0b7824ULL, 0x040fe200078e0208ULL, 0x0000000f0202723eULL, 0x000fe200000000ffULL,
0x000000082f0d7824ULL, 0x040fe200078e020aULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x000000082f117824ULL, 0x000fe200078e022cULL, 0x0000000c252c7812ULL, 0x000fe200078ec0ffULL,
0x000000082f0f7824ULL, 0x000fe200078e020eULL, 0x0000000223087812ULL, 0x000fe200078e3cffULL,
0x000000082f157824ULL, 0x000fe200078e0206ULL, 0x0000000123067812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x00000003230a7812ULL, 0x000fe200078e3cffULL,
0x000000082f137824ULL, 0x000fe200078e022eULL, 0x00000004230e7812ULL, 0x000fe200078e3cffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x0000000623237812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x000fc400078e0200ULL, 0x000000100f0f7824ULL, 0x100fe400078e0200ULL,
0x000000012c077824ULL, 0x040fe400078e0207ULL, 0x0000001011117824ULL, 0x000fe400078e0200ULL,
0x0000000831197824ULL, 0x000fe200078e0206ULL, 0x0000002a07007388ULL, 0x0003e20000000800ULL,
0x0000001013137824ULL, 0x000fe400078e0200ULL, 0x000000012c0b7824ULL, 0x000fc400078e020bULL,
0x00000008311b7824ULL, 0x000fe400078e0208ULL, 0x0000001015157824ULL, 0x000fe200078e0200ULL,
0x000000260b007388ULL, 0x000fe20000000800ULL, 0x000000012c0d7824ULL, 0x040fe400078e020dULL,
0x00000008311d7824ULL, 0x000fe400078e020aULL, 0x0000001033067824ULL, 0x000fe200078e0200ULL,
0x000000220d007388ULL, 0x000fe20000000800ULL, 0x000000012c0f7824ULL, 0x000fc400078e020fULL,
0x00000008311f7824ULL, 0x000fe400078e020eULL, 0x0000001017087824ULL, 0x100fe200078e0200ULL,
0x0000001e0f007388ULL, 0x000fe20000000800ULL, 0x000000012c117824ULL, 0x040fe400078e0211ULL,
0x0000000831217824ULL, 0x000fe400078e0221ULL, 0x00000010190a7824ULL, 0x000fe200078e0200ULL,
0x0000001a11007388ULL, 0x000fe20000000800ULL, 0x000000012c137824ULL, 0x000fc400078e0213ULL,
0x0000000831237824ULL, 0x000fe400078e0223ULL, 0x000000101b0e7824ULL, 0x100fe200078e0200ULL,
0x0000001613007388ULL, 0x000fe20000000800ULL, 0x000000012c157824ULL, 0x040fe400078e0215ULL,
0x000000101d1d7824ULL, 0x000fe400078e0200ULL, 0x000000012c177824ULL, 0x000fe200078e0206ULL,
0x0000001215007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x000fc400078e0200ULL,
0x000000012c197824ULL, 0x040fe200078e0208ULL, 0x0000000217007388ULL, 0x000fe20000000800ULL,
0x0000001021217824ULL, 0x000fe400078e0200ULL, 0x000000012c1b7824ULL, 0x040fe200078e020aULL,
0x0000002819007388ULL, 0x000fe20000000800ULL, 0x0000001023237824ULL, 0x000fe400078e0200ULL,
0x000000012c077824ULL, 0x042fe200078e020eULL, 0x000000241b007388ULL, 0x000fe20000000800ULL,
0x000000012c1d7824ULL, 0x000fc400078e021dULL, 0x000000012c1f7824ULL, 0x040fe200078e021fULL,
0x0000002007007388ULL, 0x000fe20000000800ULL, 0x000000012c217824ULL, 0x040fe400078e0221ULL,
0x000000012c237824ULL, 0x040fe200078e0223ULL, 0x0000001c1d007388ULL, 0x000fe20000000800ULL,
0x000000012c2d7824ULL, 0x000fe400078e022dULL, 0x0000002004007824ULL, 0x000fe200078e0205ULL,
0x000000181f007388ULL, 0x000fe60000000800ULL, 0x0000001000007824ULL, 0x000fe200078e0203ULL,
0x0000001421007388ULL, 0x000fe80000000800ULL, 0x0000001023007388ULL, 0x000fe80000000800ULL,
0x0000000c2d007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000287984ULL, 0x000e680000000c00ULL, 0x0004000000307984ULL, 0x000ea80000000c00ULL,
0x0008000000247984ULL, 0x000ee80000000c00ULL, 0x000c000000347984ULL, 0x000f220000000c00ULL,
0x200000ff2b2b7230ULL, 0x002fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff33337230ULL, 0x004fe40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fc40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x000000272b2b7230ULL, 0x008fe40000000000ULL, 0x000000262a2a7230ULL, 0x000fe40000000000ULL,
0x0000002529297230ULL, 0x000fe40000000000ULL, 0x0000002428287230ULL, 0x000fe40000000000ULL,
0x0000003733337230ULL, 0x010fc40000000000ULL, 0x0000003632327230ULL, 0x000fe20000000000ULL,
0x0000002800007388ULL, 0x0003e20000000c00ULL, 0x0000003531317230ULL, 0x000fe40000000000ULL,
0x0000003430307230ULL, 0x000fca0000000000ULL, 0x0004003000007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x002e620000002600ULL,
0x00000020051d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x00000040051f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006005217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff007819ULL, 0x000fe20000011605ULL, 0x00000008091e7824ULL, 0x040fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe2000001161dULL, 0x0000000809207824ULL, 0x040fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe2000001161fULL, 0x0000000809227824ULL, 0x000fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fc40000011621ULL, 0x0000000704067812ULL, 0x000fe400078e481dULL,
0x0000000707087812ULL, 0x000fe400078e481fULL, 0x0ffffff806067812ULL, 0x000fe400078ef81dULL,
0x0ffffff808087812ULL, 0x000fe400078ef81fULL, 0xfffffff8201d7812ULL, 0x000fe200078ee21dULL,
0x000000101c0b7824ULL, 0x002fe200078e00ffULL, 0xfffffff8221f7812ULL, 0x000fe200078ee21fULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0xfffffff00b027812ULL, 0x000fe200078ee200ULL,
0x000000101c237824ULL, 0x000fe200078e00ffULL, 0x0000000700007812ULL, 0x000fe200078e4805ULL,
0x0000000006107984ULL, 0x000fe20000000c00ULL, 0x000000070a0b7812ULL, 0x000fc400078e4821ULL,
0x0ffffff800007812ULL, 0x000fe200078ef805ULL, 0x0000000008147984ULL, 0x000fe20000000c00ULL,
0x0ffffff80b0c7812ULL, 0x004fe400078ef821ULL, 0xfffffff81e0b7812ULL, 0x000fe200078ee205ULL,
0x0000001000007824ULL, 0x100fe200078e0203ULL, 0xfffffff0230a7812ULL, 0x000fe200078ee20aULL,
0x000000100c187824ULL, 0x000fe200078e0203ULL, 0x0000000402037c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101c057824ULL, 0x040fe200078e00ffULL, 0x00000000000c7984ULL, 0x0002a20000000c00ULL,
0x000000101c1e7824ULL, 0x000fe200078e00ffULL, 0x000000040a0a7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000018187984ULL, 0x000ee20000000c00ULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0xfffffff01e077812ULL, 0x000fe200078ee207ULL, 0x000000ffff007224ULL, 0x002fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fe200078040ffULL, 0x00000008091e7824ULL, 0x000fe200078e00ffULL,
0x0000000407077c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4400ULL, 0x0000000404057c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe200078240ffULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x00005a000a087a11ULL, 0x000fc400078440ffULL,
0x00005b0007077a11ULL, 0x000fe200008f4400ULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe400078040ffULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x000000101f067825ULL, 0x000fe200078e0006ULL, 0x00005b0005057a11ULL, 0x000fe400000f441cULL,
0x00005b000a097a11ULL, 0x000fc600010f4409ULL, 0x000000101d047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x004fe8000c101d08ULL,
0x0000001004007986ULL, 0x000fe8000c101d08ULL, 0x0000001406007986ULL, 0x000fe8000c101d08ULL,
0x0000001808007986ULL, 0x008fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x03ffffff1b177812ULL, 0x000fe200078ec0ffULL,
0x00006900ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff087424ULL, 0x000fe400078e00ffULL,
0x0000000416177824ULL, 0x040fe200078e0217ULL, 0x0000000806197981ULL, 0x000368000c1e9900ULL,
0x000000021700720cULL, 0x000fe40003f06070ULL, 0x00000001160a7810ULL, 0x000fd60007ffe0ffULL,
0x000000021a048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0217ULL,
0x0000600004048625ULL, 0x000fca00078e0009ULL, 0x0000000804088981ULL, 0x000362000c1e1900ULL,
0x000000030a00720cULL, 0x000fe20003f06070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004025257824ULL, 0x000fe400078e00ffULL, 0x000000401b157824ULL, 0x000fd200078e00ffULL,
0x00000cc000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x0000010016057824ULL, 0x000fe200078e0215ULL, 0x000010001b147811ULL, 0x000fe200078e70ffULL,
0x0000000425067e24ULL, 0x020fc6000f8e0208ULL, 0x0000000500087217ULL, 0x000fca0007800000ULL,
0x0000000108087824ULL, 0x000fe200078e0a05ULL, 0x00000003ff397819ULL, 0x002fc80000011604ULL,
0x00000008390f7810ULL, 0x040fe40007ffe0ffULL, 0x00000004390d7810ULL, 0x000fe40007ffe0ffULL,
0x000000040f0a7212ULL, 0x0c0fe200078e3cffULL, 0x000000080f2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c39117810ULL, 0x000fe20007ffe0ffULL, 0x000000080d0c7824ULL, 0x000fe200078e00ffULL,
0x00000014391f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL,
0x00000008110a7824ULL, 0x000fe200078e00ffULL, 0x000000040d077212ULL, 0x080fe200078e3cffULL,
0x000000081f0e7824ULL, 0x000fe200078e00ffULL, 0x0000001039137810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0214ULL, 0x0000000411057212ULL, 0x000fc400078e3cffULL,
0xfffffff80c297812ULL, 0x000fe200078ee207ULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a2d7812ULL, 0x000fe200078ee205ULL, 0x00000010040a7824ULL, 0x000fe200078e00ffULL,
0x000000041f057212ULL, 0x080fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0214ULL,
0x0000000413077212ULL, 0x000fe200078e3cffULL, 0x000000102d2d7824ULL, 0x000fe200078e0214ULL,
0x0000003f390b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff80e317812ULL, 0x000fc400078ee205ULL,
0xfffffff80c2f7812ULL, 0x000fe200078ee207ULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x000000700a057812ULL, 0x000fe200078ec0ffULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x000000080f00720cULL, 0x080fe20003fa6070ULL, 0x000000102f2f7824ULL, 0x100fe200078e0214ULL,
0x0000003f0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0007ULL,
0x000000080d00720cULL, 0x0c0fe40003f86070ULL, 0x0000003f0d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001060e7824ULL, 0x040fe200078e020fULL, 0x000000081100720cULL, 0x080fe20003f06070ULL,
0x0000001031317824ULL, 0x000fe200078e0214ULL, 0x0000003f11117812ULL, 0x000fe200078ec0ffULL,
0x00000001060c7824ULL, 0x000fe200078e020dULL, 0x000000081300720cULL, 0x040fe20003f46070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0007ULL, 0x0000003f13137812ULL, 0x000fc400078ec0ffULL,
0x000000050a127210ULL, 0x080fe20007f3e0ffULL, 0x00000001060a7824ULL, 0x000fe200078e0211ULL,
0x000000050e0e7210ULL, 0x000fe20007f7e0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0007ULL,
0x0000001839257810ULL, 0x040fe40007ffe0ffULL, 0x0000001c393b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106107824ULL, 0x000fe200078e0213ULL, 0x0000000739237812ULL, 0x000fe200078e4804ULL,
0x000000ffff137224ULL, 0x000fe200008e060bULL, 0x000000050c1c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x0000003f3b217812ULL, 0x000fc400078ec0ffULL,
0x0000002039357810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e060fULL,
0x000000050a1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e060dULL,
0x0000003f1f0d7812ULL, 0x040fe200078ec0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0007ULL,
0x000000081f00720cULL, 0x080fe40003f26070ULL, 0x0ffffff823277812ULL, 0x000fe200078ef804ULL,
0x000000ffff1f7224ULL, 0x000fe200018e060bULL, 0x0000003f250b7812ULL, 0x000fe200078ec0ffULL,
0x00000001060a7824ULL, 0x000fe200078e020dULL, 0x0000000510107210ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fe200078e0214ULL, 0x000000083900720cULL, 0x000fe20003f66070ULL,
0x00000001060c7824ULL, 0x000fe200078e020bULL, 0x0000003f35237812ULL, 0x000fe200078ec0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x0000002439377810ULL, 0x000fc40007ffe0ffULL,
0x0000000435187212ULL, 0x000fe200078e3cffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x000000050a207210ULL, 0x000fe20007fde0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0007ULL,
0x00000001060a7824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012277faeULL, 0x0003e2000d901c48ULL, 0x000000ffff217224ULL, 0x000fe200030e060bULL,
0x000000050c227210ULL, 0x000fe20007fde0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0007ULL,
0x000000082500720cULL, 0x080fe20003f66070ULL, 0x000000001c297faeULL, 0x0005e2000e101c48ULL,
0x000000083b00720cULL, 0x000fe20003f86070ULL, 0x00000001060c7824ULL, 0x000fe400078e0223ULL,
0x000000ffff237224ULL, 0x000fe200030e060dULL, 0x000000050a247210ULL, 0x000fe20007fde0ffULL,
0x0000000825337824ULL, 0x040fe200078e00ffULL, 0x00000004250a7212ULL, 0x000fe200078e3cffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0007ULL, 0x000000000e2b7faeULL, 0x0007e2000e901c48ULL,
0x000000083500720cULL, 0x000fc40003fa6070ULL, 0x000000ffff257224ULL, 0x000fe200030e060bULL,
0x0000003f370b7812ULL, 0x000fe200078ec0ffULL, 0x000000083b267824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000043b137212ULL, 0x082fe200078e3cffULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001033337824ULL, 0x000fe200078e0214ULL,
0xfffffff8261d7812ULL, 0x004fe200078ee213ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0007ULL,
0xfffffff8350f7812ULL, 0x008fe200078ee218ULL, 0x000000001e2d7faeULL, 0x0003e2000c101c48ULL,
0x0000002839277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x000000050a127210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0214ULL,
0x00000000102f7faeULL, 0x0005e2000d101c48ULL, 0x000000100f0f7824ULL, 0x000fe200078e0214ULL,
0x00000004370a7212ULL, 0x040fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200030e060bULL,
0x0000000020317faeULL, 0x0007e2000c901c48ULL, 0x00000008370b7824ULL, 0x000fe200078e00ffULL,
0x0000003039297810ULL, 0x000fc40007ffe0ffULL, 0x0000000022337faeULL, 0x0009e2000d901c48ULL,
0x0000002c391f7810ULL, 0x042fe40007ffe0ffULL, 0x00000034392b7810ULL, 0x040fe20007ffe0ffULL,
0x00000000241d7faeULL, 0x0003e2000e101c48ULL, 0x00000038392d7810ULL, 0x040fe40007ffe0ffULL,
0x0000003c392f7810ULL, 0x004fe20007ffe0ffULL, 0x000000000c0f7faeULL, 0x0005e2000e901c48ULL,
0x000000082700720cULL, 0x080fe20003fa6070ULL, 0x000000081f217824ULL, 0x008fe200078e00ffULL,
0x000000083700720cULL, 0x000fe20003fc6070ULL, 0x0000000829237824ULL, 0x010fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fc400078ee20aULL, 0x000000081f00720cULL, 0x080fe20003f86070ULL,
0x00000008271d7824ULL, 0x002fe200078e00ffULL, 0x000000082900720cULL, 0x080fe20003f66070ULL,
0x000000100b117824ULL, 0x000fe200078e0214ULL, 0x000000082b00720cULL, 0x000fe40003f46070ULL,
0x00000004270c7212ULL, 0x044fe400078e3cffULL, 0x0000003f27277812ULL, 0x000fe200078ec0ffULL,
0x0000000012117faeULL, 0x0003e2000f101c48ULL, 0x000000082d00720cULL, 0x000fc40003f26070ULL,
0x000000082f00720cULL, 0x000fe20003f06070ULL, 0x00000001060a7824ULL, 0x000fe200078e0227ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL, 0x000000082f277824ULL, 0x000fe200078e00ffULL,
0x000000041f087212ULL, 0x080fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0007ULL,
0x00000004290c7212ULL, 0x000fe400078e3cffULL, 0x0000003f1f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0214ULL, 0xfffffff823237812ULL, 0x000fc400078ee20cULL,
0x0000003f29297812ULL, 0x000fe200078ec0ffULL, 0x00000001060c7824ULL, 0x000fe200078e021fULL,
0x000000050a0e7210ULL, 0x000fe20007fde0ffULL, 0x000000082b1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0007ULL,
0x000000042b087212ULL, 0x040fe400078e3cffULL, 0x0000003f2b2b7812ULL, 0x000fe200078ec0ffULL,
0x00000001060a7824ULL, 0x000fe200078e0229ULL, 0x0000003f2d137812ULL, 0x002fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060bULL, 0x000000050c107210ULL, 0x000fe20007fde0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x0000003f2f257812ULL, 0x000fc400078ec0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x00000001060c7824ULL, 0x000fe200078e022bULL,
0x000000000e1d7faeULL, 0x0003e2000e901c48ULL, 0x000000ffff117224ULL, 0x000fe200030e060dULL,
0x000000050a127210ULL, 0x000fe20007fde0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0007ULL,
0x00000001060a7824ULL, 0x000fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fe200030e060bULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000000106087824ULL, 0x000fe200078e0225ULL,
0x000000042d067212ULL, 0x080fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0007ULL,
0x000000042f047212ULL, 0x000fc600078e3cffULL, 0x000000082d257824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee204ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x000000050a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fe200078e0214ULL,
0xfffffff825257812ULL, 0x000fe200078ee206ULL, 0x00005e0008067625ULL, 0x000fc600078e0007ULL,
0x0000000010217faeULL, 0x0003e2000e101c48ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000506047210ULL, 0x000fe20007fde0ffULL, 0x0000001023237824ULL, 0x100fe400078e0214ULL,
0x000000101f1f7824ULL, 0x100fe400078e0214ULL, 0x0000001025257824ULL, 0x100fe200078e0214ULL,
0x0000000012237faeULL, 0x0003e2000d901c48ULL, 0x0000001027277824ULL, 0x000fe400078e0214ULL,
0x000000ffff057224ULL, 0x000fe200030e0607ULL, 0x000000000c1f7faeULL, 0x0003e8000d101c48ULL,
0x000000000a257faeULL, 0x0003e8000c901c48ULL, 0x0000000004277faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x0000000425087e24ULL, 0x020fc4000f8e0208ULL, 0x00000080ff2c7424ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x002fc80000011604ULL, 0x0000000805117810ULL, 0x040fe40007ffe0ffULL,
0x0000001805297810ULL, 0x040fe40007ffe0ffULL, 0x00000004050d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008110a7824ULL, 0x000fe200078e00ffULL, 0x0000001005217810ULL, 0x000fe20007ffe0ffULL,
0x00000008290e7824ULL, 0x000fe200078e00ffULL, 0x0000000411077212ULL, 0x000fe200078e3cffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000000c051d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008210c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a137812ULL, 0x000fc400078ee207ULL,
0x00000004290b7212ULL, 0x080fe200078e3cffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x0000002805337810ULL, 0x000fe40007ffe0ffULL, 0x000000040d067212ULL, 0x080fe400078e3cffULL,
0x0000000421077212ULL, 0x000fe400078e3cffULL, 0x00000020052f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e2b7812ULL, 0x000fe200078ee20bULL, 0x00000008330e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fc400078ee206ULL, 0x0000001405257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c237812ULL, 0x000fe200078ee207ULL, 0x000000082f0c7824ULL, 0x000fe200078e00ffULL,
0x0000001c052d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0x000000041d067212ULL, 0x080fe400078e3cffULL, 0x00000004330b7212ULL, 0x000fe200078e3cffULL,
0x000000082d3f7824ULL, 0x000fe200078e00ffULL, 0x00000038053b7810ULL, 0x000fc40007ffe0ffULL,
0x000000042f077212ULL, 0x080fe400078e3cffULL, 0x0000003005377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee206ULL, 0x0000002405317810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e497812ULL, 0x000fe200078ee20bULL, 0x000000083b0e7824ULL, 0x000fe200078e00ffULL,
0x0000002c05357810ULL, 0x000fe20007ffe0ffULL, 0x0000000831457824ULL, 0x000fe200078e00ffULL,
0x00000004250a7212ULL, 0x000fc400078e3cffULL, 0x000000042d067212ULL, 0x080fe200078e3cffULL,
0x00000008354d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c417812ULL, 0x000fe200078ee207ULL,
0x00000008370c7824ULL, 0x000fe200078e00ffULL, 0x000000043b0b7212ULL, 0x080fe400078e3cffULL,
0x0000000437077212ULL, 0x000fe400078e3cffULL, 0xfffffff827277812ULL, 0x000fe400078ee20aULL,
0xfffffff83f3f7812ULL, 0x000fc400078ee206ULL, 0x00000004310a7212ULL, 0x080fe400078e3cffULL,
0x0000000435067212ULL, 0x000fe400078e3cffULL, 0xfffffff80e597812ULL, 0x000fe400078ee20bULL,
0x0000003c053d7810ULL, 0x040fe40007ffe0ffULL, 0x0000003405397810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c517812ULL, 0x000fe200078ee207ULL, 0x000000083d5d7824ULL, 0x000fe200078e00ffULL,
0x00000007050b7812ULL, 0x000fe200078e4804ULL, 0x0000000839557824ULL, 0x000fe200078e00ffULL,
0x0000003f05077812ULL, 0x000fc400078ec0ffULL, 0x0000003f0d0d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20aULL, 0x0000000108057824ULL, 0x000fe200078e0207ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e00ffULL,
0x0000003f1d1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000108077824ULL, 0x040fe200078e020dULL,
0x00000004390a7212ULL, 0x000fe400078e3cffULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef804ULL,
0x00000001080d7824ULL, 0x000fe200078e021dULL, 0x0000003f2d2d7812ULL, 0x000fc400078ec0ffULL,
0x0000003f2f2f7812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e002cULL,
0x000000043d047212ULL, 0x000fe400078e3cffULL, 0x0000003f21217812ULL, 0x000fe200078ec0ffULL,
0x00000001081d7824ULL, 0x040fe200078e022dULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee204ULL,
0x00000001082d7824ULL, 0x000fe200078e022fULL, 0x00000070062f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e002cULL, 0x0000003f11117812ULL, 0x000fc400078ec0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee20aULL, 0x00005e0007067625ULL, 0x000fe200078e002cULL,
0x0000003f33337812ULL, 0x000fe400078ec0ffULL, 0x0000002f04047210ULL, 0x080fe20007f1e0ffULL,
0x0000000108217824ULL, 0x040fe200078e0221ULL, 0x000010001b0a7811ULL, 0x000fe200078e70ffULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x0000003f31317812ULL, 0x000fe200078ec0ffULL,
0x0000000108477824ULL, 0x040fe200078e0233ULL, 0x0000003f35357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000003f37377812ULL, 0x000fe200078ec0ffULL,
0x0000000108437824ULL, 0x040fe200078e0231ULL, 0x0000003f39397812ULL, 0x000fe200078ec0ffULL,
0x00000001084b7824ULL, 0x040fe200078e0235ULL, 0x0000003f3b3b7812ULL, 0x000fe200078ec0ffULL,
0x00000001084f7824ULL, 0x040fe200078e0237ULL, 0x0000003f29297812ULL, 0x000fe200078ec0ffULL,
0x0000000108537824ULL, 0x040fe200078e0239ULL, 0x0000003f25257812ULL, 0x000fe200078ec0ffULL,
0x0000000108577824ULL, 0x000fe200078e023bULL, 0x0000003f3d5b7812ULL, 0x000fe200078ec0ffULL,
0x000000100f337824ULL, 0x100fe200078e020aULL, 0x0000002f06067210ULL, 0x080fe20007f1e0ffULL,
0x000000100b317824ULL, 0x100fe200078e020aULL, 0x0000002f0c0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001013357824ULL, 0x000fc400078e020aULL, 0x000000101f377824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e2000b901c48ULL,
0x0000001023397824ULL, 0x100fe400078e020aULL, 0x00000010273b7824ULL, 0x100fe400078e020aULL,
0x000000102b3d7824ULL, 0x100fe400078e020aULL, 0x000000103f3f7824ULL, 0x100fe400078e020aULL,
0x0000001041417824ULL, 0x000fc400078e020aULL, 0x0000001045457824ULL, 0x100fe400078e020aULL,
0x0000001049497824ULL, 0x100fe400078e020aULL, 0x000000104d4d7824ULL, 0x100fe400078e020aULL,
0x0000001051517824ULL, 0x100fe400078e020aULL, 0x0000001055557824ULL, 0x100fe400078e020aULL,
0x0000001059597824ULL, 0x000fc400078e020aULL, 0x000000105d5d7824ULL, 0x000fe400078e020aULL,
0x00005e00210e7625ULL, 0x000fc800078e002cULL, 0x00005e00110a7625ULL, 0x000fc800078e002cULL,
0x0000000108297824ULL, 0x000fe200078e0229ULL, 0x0000002f0a0a7210ULL, 0x080fe20007f3e0ffULL,
0x0000000108257824ULL, 0x000fe400078e0225ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000002f0e0e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0029127625ULL, 0x000fc600078e002cULL,
0x0000000006337faeULL, 0x0003e2000b901c48ULL, 0x00005e0025107625ULL, 0x000fc800078e002cULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000002f12127210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000002f10107210ULL, 0x000fe20007f3e0ffULL,
0x00005e002d1e7625ULL, 0x000fc600078e002cULL, 0x000000000a357faeULL, 0x0003e2000b901c48ULL,
0x00005e001d1c7625ULL, 0x000fc800078e002cULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000002f1e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000002f1c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e004b247625ULL, 0x000fc800078e002cULL,
0x00005e0043207625ULL, 0x000fc800078e002cULL, 0x00005e0047227625ULL, 0x000fc800078e002cULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000002f24247210ULL, 0x080fe20007f1e0ffULL,
0x00000001085b7824ULL, 0x000fe400078e025bULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000002f20207210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x0000002f22227210ULL, 0x000fe20007f5e0ffULL, 0x00005e004f267625ULL, 0x000fc600078e002cULL,
0x000000000c377faeULL, 0x0003e2000b901c48ULL, 0x00005e0053287625ULL, 0x000fc600078e002cULL,
0x000000000e397faeULL, 0x0003e2000b901c48ULL, 0x00005e00572a7625ULL, 0x000fc600078e002cULL,
0x00000000103b7faeULL, 0x0003e2000b901c48ULL, 0x00005e005b2c7625ULL, 0x000fc600078e002cULL,
0x00000000123d7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x0000002f26267210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000002f28287210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x0000002f2a2a7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x0000002f2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000001c3f7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff297224ULL, 0x000fc400008e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200010e062bULL,
0x000000001e417faeULL, 0x0003e2000b901c48ULL, 0x000000ffff2d7224ULL, 0x000fc600018e062dULL,
0x0000000020457faeULL, 0x0003e8000b901c48ULL, 0x0000000022497faeULL, 0x0003e8000b901c48ULL,
0x00000000244d7faeULL, 0x0003e8000b901c48ULL, 0x0000000026517faeULL, 0x0003e8000b901c48ULL,
0x0000000028557faeULL, 0x0003e8000b901c48ULL, 0x000000002a597faeULL, 0x0003e8000b901c48ULL,
0x000000002c5d7faeULL, 0x0003e4000b901c48ULL, 0x01b60400ff067984ULL, 0x002e620000000800ULL,
0x0000030009177a24ULL, 0x000fc400078e0217ULL, 0xffffffffff147424ULL, 0x000fc600078e00ffULL,
0x000000021700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000021a047824ULL, 0x000fc800078e00ffULL, 0x0000640004047a24ULL, 0x000fc800078e0217ULL,
0x0000600004047625ULL, 0x000fca00078e0009ULL, 0x0000000804147981ULL, 0x000564000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000006ff7812ULL, 0x002fe2000780c0ffULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x004fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000031b00780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004e640000000000ULL, 0x000000201b047824ULL, 0x002fc800078e0204ULL,
0x0000001004067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7804ULL,
0x0000000707077812ULL, 0x000fc600078e7804ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01b60400ff047984ULL, 0x004ea40000000800ULL,
0x8000000004ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0022a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01b60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000031600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000ea20000000000ULL,
0x00005800ff3b7624ULL, 0x000fe200078e00ffULL, 0xffffffff03397810ULL, 0x000fe20007ffe0ffULL,
0x3db504f319197820ULL, 0x000fe20000410000ULL, 0x00007610ff3a7816ULL, 0x000fe2000000003aULL,
0x000064001a1a7a24ULL, 0x000fe400078e02ffULL, 0x000000101b387824ULL, 0x000fe400078e00ffULL,
0x000000ffff047224ULL, 0x000fe400078e00ffULL, 0x000000403b3b7824ULL, 0x000fc400078e00ffULL,
0x00000100163d7824ULL, 0x000fe200078e0215ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003d0000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000300163c7a10ULL, 0x000fe20007ffe0ffULL, 0x0000189000007945ULL, 0x000fe20003800000ULL,
0x00000001043e7812ULL, 0x000fe400078e0cffULL, 0x000000013c067810ULL, 0x000fc80007ffe0ffULL,
0x000000030600720cULL, 0x000fda0003f06070ULL, 0x00000cc000008947ULL, 0x000fea0003800000ULL,
0x00000003ff227819ULL, 0x004fe20000011618ULL, 0x000001003c057824ULL, 0x002fe400078e0215ULL,
0x000000043b147e24ULL, 0x020fe2000f8e0214ULL, 0x00000004220a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008220b7810ULL, 0x000fe40007ffe0ffULL, 0x000000180a077212ULL, 0x0c0fe200078e3cffULL,
0x000000080a0e7824ULL, 0x000fe200078e00ffULL, 0x0000000500067217ULL, 0x000fe20007800000ULL,
0x000000080b237824ULL, 0x040fe200078e00ffULL, 0x000000180b087212ULL, 0x000fc400078e3cffULL,
0xfffffff80e217812ULL, 0x000fe200078ee207ULL, 0x0000000106097824ULL, 0x000fe200078e0a05ULL,
0x0000003f22077812ULL, 0x000fe200078ec0ffULL, 0x0000001018057824ULL, 0x000fe200078e00ffULL,
0x0000000c220c7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x00000080ff087424ULL, 0x000fe200078e00ffULL, 0x0000001822267810ULL, 0x000fe20007ffe0ffULL,
0x0000000107077824ULL, 0x000fe200078e0214ULL, 0x000000180c0d7212ULL, 0x040fe200078e3cffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0008ULL, 0x00000010220e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff810257812ULL, 0x000fe200078ee20dULL, 0x00000008261e7824ULL, 0x040fe200078e00ffULL,
0x0000001826117212ULL, 0x080fe200078e3cffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x0000000506107210ULL, 0x000fe40007f1e0ffULL, 0x0000001422247810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e2d7812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0x000000180e0d7212ULL, 0x000fe200078e3cffULL, 0x00000008241c7824ULL, 0x000fe200078e00ffULL,
0x0000003f0a077812ULL, 0x000fc400078ec0ffULL, 0x00000018240f7212ULL, 0x000fe400078e3cffULL,
0x000000090b00720cULL, 0x000fe20003f86070ULL, 0x0000000107077824ULL, 0x100fe200078e0214ULL,
0xfffffff812277812ULL, 0x000fe400078ee20dULL, 0x0000003f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0008ULL, 0xfffffff81c297812ULL, 0x000fe400078ee20fULL,
0x0000003f0c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0214ULL,
0x0000003f0e0f7812ULL, 0x000fc400078ec0ffULL, 0x0000001c22287810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x100fe200078e0214ULL, 0x000000090a00720cULL, 0x080fe20003fa6070ULL,
0x000000010f0f7824ULL, 0x000fe200078e0214ULL, 0x000000090c00720cULL, 0x080fe20003f26070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0008ULL, 0x000000090e00720cULL, 0x000fe40003f06070ULL,
0x0000001828137212ULL, 0x040fe200078e3cffULL, 0x0000000828207824ULL, 0x000fe200078e00ffULL,
0x0000000506127210ULL, 0x080fe20007f5e0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0008ULL,
0x000000050a1c7210ULL, 0x000fc40007f7e0ffULL, 0xfffffff8202f7812ULL, 0x000fe200078ee213ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0008ULL, 0x000000050c1e7210ULL, 0x080fe40007fde0ffULL,
0x0000003f262b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0607ULL,
0x000000050e067210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e060bULL,
0x000000092400720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff1f7224ULL, 0x000fe200030e060dULL,
0x0000003f240b7812ULL, 0x000fe200078ec0ffULL, 0x000000021b207824ULL, 0x000fe200078e023eULL,
0x00000007220d7812ULL, 0x040fe200078e4818ULL, 0x000000ffff077224ULL, 0x000fe200010e060fULL,
0x0000002422247810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0214ULL,
0x000000092200720cULL, 0x000fc40003f46070ULL, 0x0000100020207811ULL, 0x000fe200078e68ffULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef818ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0008ULL, 0x00000020220e7810ULL, 0x000fe40007ffe0ffULL,
0x00000018240f7212ULL, 0x080fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0220ULL,
0x000000180e0c7212ULL, 0x040fe200078e3cffULL, 0x000000080e317824ULL, 0x000fe200078e00ffULL,
0xfffffff82a337812ULL, 0x000fe200078ee20fULL, 0x00000010210f7824ULL, 0x100fe200078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000d101c48ULL,
0x0000001023217824ULL, 0x000fe200078e0220ULL, 0x000000092600720cULL, 0x000fe20003f46070ULL,
0x000000012b237824ULL, 0x000fe200078e0214ULL, 0x000000050a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000000120f7faeULL, 0x0005e2000e901c48ULL, 0xfffffff831317812ULL, 0x000fc400078ee20cULL,
0x0000002822267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000003f282b7812ULL, 0x040fe200078ec0ffULL, 0x000000001c217faeULL, 0x0007e2000e101c48ULL,
0x00005e00230c7625ULL, 0x002fe200078e0008ULL, 0x000000092800720cULL, 0x000fe40003fa6070ULL,
0x0000001826117212ULL, 0x040fe200078e3cffULL, 0x0000000826287824ULL, 0x000fe200078e00ffULL,
0x000000050c107210ULL, 0x000fe20007fde0ffULL, 0x000000012b0f7824ULL, 0x004fe200078e0214ULL,
0x0000003f0e237812ULL, 0x000fc400078ec0ffULL, 0xfffffff8282b7812ULL, 0x000fe200078ee211ULL,
0x000000ffff117224ULL, 0x000fe200030e060dULL, 0x0000002c221c7810ULL, 0x008fe20007ffe0ffULL,
0x00000010251d7824ULL, 0x000fe200078e0220ULL, 0x0000003f24217812ULL, 0x000fe200078ec0ffULL,
0x00005e000f0c7625ULL, 0x080fe200078e0008ULL, 0x000000090e00720cULL, 0x080fe40003f86070ULL,
0x000000001e1d7faeULL, 0x0003e2000c901c48ULL, 0x000000092400720cULL, 0x000fe20003f26070ULL,
0x0000000123137824ULL, 0x000fe200078e0214ULL, 0x000000050c127210ULL, 0x000fe20007fde0ffULL,
0x000000081c357824ULL, 0x000fe200078e00ffULL, 0x0000003422247810ULL, 0x000fe20007ffe0ffULL,
0x00005e00130e7625ULL, 0x000fe200078e0008ULL, 0x000000181c0c7212ULL, 0x000fc600078e3cffULL,
0x000000ffff137224ULL, 0x000fe200030e060dULL, 0x000000050e0e7210ULL, 0x000fe20007fde0ffULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0x00000030221e7810ULL, 0x002fe20007ffe0ffULL,
0x00000001210d7824ULL, 0x000fe200078e0214ULL, 0x00000018241f7212ULL, 0x080fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x000000181e1d7212ULL, 0x040fe200078e3cffULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x00005e000d0c7625ULL, 0x000fe200078e0008ULL, 0xfffffff82a3f7812ULL, 0x000fc400078ee21fULL,
0xfffffff828377812ULL, 0x000fe200078ee21dULL, 0x00000010271d7824ULL, 0x100fe200078e0220ULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010291f7824ULL, 0x100fe200078e0220ULL,
0x0000003f26297812ULL, 0x040fe200078ec0ffULL, 0x000000102d217824ULL, 0x100fe200078e0220ULL,
0x00000000061d7faeULL, 0x0003e2000c101c48ULL, 0x000000102f237824ULL, 0x100fe200078e0220ULL,
0x000000092600720cULL, 0x080fe20003f06070ULL, 0x0000001031257824ULL, 0x100fe200078e0220ULL,
0x000000000a1f7faeULL, 0x0005e2000d901c48ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x000000092400720cULL, 0x000fe20003f66070ULL, 0x0000001033277824ULL, 0x000fe200078e0220ULL,
0x0000000010217faeULL, 0x0007e2000d101c48ULL, 0x0000000129077824ULL, 0x002fc600078e0214ULL,
0x0000000012237faeULL, 0x0003e2000e901c48ULL, 0x00000038221d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003f1c0b7812ULL, 0x004fe200078ec0ffULL, 0x00005e0007067625ULL, 0x080fe200078e0008ULL,
0x000000000e257faeULL, 0x0005e2000e101c48ULL, 0x0000003c22227810ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0214ULL, 0x0000003f1e117812ULL, 0x008fe200078ec0ffULL,
0x000000000c277faeULL, 0x0007e2000c901c48ULL, 0x000000091c00720cULL, 0x080fe20003fa6070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0008ULL, 0x000000091e00720cULL, 0x000fc40003f86070ULL,
0x000000091d00720cULL, 0x0c0fe20003f46070ULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x000000092200720cULL, 0x000fe20003f26070ULL, 0x00000001110f7824ULL, 0x004fe200078e0214ULL,
0x0000003f24097812ULL, 0x000fe200078ec0ffULL, 0x00000010371f7824ULL, 0x000fe200078e0220ULL,
0x0000003f1d137812ULL, 0x002fe400078ec0ffULL, 0x00000005060c7210ULL, 0x088fe20007fde0ffULL,
0x0000000109097824ULL, 0x100fe200078e0214ULL, 0x0000003f22117812ULL, 0x000fe200078ec0ffULL,
0x0000000113137824ULL, 0x000fe200078e0214ULL, 0x000000181d127212ULL, 0x000fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0607ULL, 0x000000050a0e7210ULL, 0x000fe20007fde0ffULL,
0x00005e000f067625ULL, 0x000fe200078e0008ULL, 0xfffffff821217812ULL, 0x000fc600078ee212ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060bULL, 0x0000000506107210ULL, 0x000fe20007fde0ffULL,
0x00005e00090a7625ULL, 0x000fc800078e0008ULL, 0x0000000111097824ULL, 0x000fe400078e0214ULL,
0x000000ffff117224ULL, 0x000fe200030e0607ULL, 0x000000050a0a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0013067625ULL, 0x000fe200078e0008ULL, 0x0000001822137212ULL, 0x000fc600078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000506067210ULL, 0x000fe20007fde0ffULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x00005e0009087625ULL, 0x000fc600078e0008ULL,
0xfffffff822237812ULL, 0x000fe200078ee213ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000508087210ULL, 0x000fe20007fde0ffULL, 0x000000102b137824ULL, 0x100fe400078e0220ULL,
0x00000010351d7824ULL, 0x100fe400078e0220ULL, 0x000000103f057824ULL, 0x100fe200078e0220ULL,
0x000000000c137faeULL, 0x0003e2000c101c48ULL, 0x0000001021217824ULL, 0x100fe400078e0220ULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x000000000e1d7faeULL, 0x0003e2000e901c48ULL,
0x000000ffff097224ULL, 0x000fc600030e0609ULL, 0x00000000101f7faeULL, 0x0003e8000e101c48ULL,
0x000000000a057faeULL, 0x0003e8000d901c48ULL, 0x0000000006217faeULL, 0x0003e8000d101c48ULL,
0x0000000008237faeULL, 0x0003e2000c901c48ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x006fe20000011618ULL, 0x000000043b147e24ULL, 0x020fc4000f8e0214ULL,
0x00000080ff2c7424ULL, 0x000fe200078e00ffULL, 0x00000008050f7810ULL, 0x040fe40007ffe0ffULL,
0x00000010051f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001805277810ULL, 0x000fe20007ffe0ffULL,
0x000000080f087824ULL, 0x040fe200078e00ffULL, 0x000000180f077212ULL, 0x000fe200078e3cffULL,
0x000000081f0a7824ULL, 0x000fe200078e00ffULL, 0x00000004050b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008270c7824ULL, 0x000fe200078e00ffULL, 0xfffffff808117812ULL, 0x000fc400078ee207ULL,
0x000000181f077212ULL, 0x080fe200078e3cffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0x0000001827097212ULL, 0x080fe400078e3cffULL, 0x00000020052f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002805337810ULL, 0x040fe40007ffe0ffULL, 0x0000000c05137810ULL, 0x000fe40007ffe0ffULL,
0x000000180b067212ULL, 0x000fc400078e3cffULL, 0x0000001405237810ULL, 0x000fe20007ffe0ffULL,
0x00000008131d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a217812ULL, 0x000fe200078ee207ULL,
0x000000082f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c297812ULL, 0x000fe200078ee209ULL,
0x00000008330c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0x0000001c052b7810ULL, 0x000fe40007ffe0ffULL,
0x000000182f077212ULL, 0x000fc400078e3cffULL, 0x0000001833097212ULL, 0x080fe200078e3cffULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0x0000003005377810ULL, 0x040fe40007ffe0ffULL,
0x0000003805417810ULL, 0x000fe40007ffe0ffULL, 0x0000001813067212ULL, 0x080fe400078e3cffULL,
0x0000002405317810ULL, 0x000fe40007ffe0ffULL, 0x0000001823087212ULL, 0x000fc400078e3cffULL,
0xfffffff80a477812ULL, 0x000fe200078ee207ULL, 0x00000008370a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c4f7812ULL, 0x000fe200078ee209ULL, 0x00000008410c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x00000008314b7824ULL, 0x000fe200078e00ffULL,
0x0000002c05357810ULL, 0x000fe40007ffe0ffULL, 0xfffffff825257812ULL, 0x000fe400078ee208ULL,
0x000000182b067212ULL, 0x000fe200078e3cffULL, 0x0000000835537824ULL, 0x000fe200078e00ffULL,
0x00000034053f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001837077212ULL, 0x080fe400078e3cffULL,
0x0000001841097212ULL, 0x080fe200078e3cffULL, 0x000000083f5b7824ULL, 0x000fe200078e00ffULL,
0x0000001831087212ULL, 0x000fe400078e3cffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee206ULL,
0xfffffff80a577812ULL, 0x000fe400078ee207ULL, 0xfffffff80c5f7812ULL, 0x000fc400078ee209ULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee208ULL, 0x0000001835067212ULL, 0x080fe400078e3cffULL,
0x0000003f05077812ULL, 0x040fe400078ec0ffULL, 0x0000000705097812ULL, 0x000fe400078e4818ULL,
0x000000183f087212ULL, 0x000fe200078e3cffULL, 0x0000000107077824ULL, 0x000fe200078e0214ULL,
0x0000003c05057810ULL, 0x000fc40007ffe0ffULL, 0xfffffff853537812ULL, 0x000fe200078ee206ULL,
0x0000001018067824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee208ULL,
0x000000021b087824ULL, 0x000fe200078e023eULL, 0x00000018050a7212ULL, 0x040fe200078e3cffULL,
0x0000000805637824ULL, 0x000fe200078e00ffULL, 0x0000003f0b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000003f05437812ULL, 0x000fe400078ec0ffULL, 0x0000003f2f2f7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0214ULL, 0x0000003f31317812ULL, 0x000fe200078ec0ffULL,
0x0000000143617824ULL, 0x100fe200078e0214ULL, 0x0000003f33337812ULL, 0x000fe200078ec0ffULL,
0x000000012f457824ULL, 0x100fe200078e0214ULL, 0x0000003f35357812ULL, 0x000fe200078ec0ffULL,
0x0000000131497824ULL, 0x100fe200078e0214ULL, 0x0000003f37377812ULL, 0x000fe200078ec0ffULL,
0x00000001334d7824ULL, 0x100fe200078e0214ULL, 0x0000003f3f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000135517824ULL, 0x100fe200078e0214ULL, 0x0000003f41417812ULL, 0x000fe200078ec0ffULL,
0x0000000137557824ULL, 0x000fe200078e0214ULL, 0x0000007006057812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e002cULL, 0x0000100008087811ULL, 0x000fc400078e68ffULL,
0x0ffffff809097812ULL, 0x000fe200078ef818ULL, 0x000000013f597824ULL, 0x000fe200078e0214ULL,
0xfffffff863637812ULL, 0x000fe200078ee20aULL, 0x00000001415d7824ULL, 0x000fe200078e0214ULL,
0x0000003f0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00000010092f7824ULL, 0x100fe200078e0208ULL,
0x0000003f1f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000100d317824ULL, 0x100fe200078e0208ULL,
0x0000000506067210ULL, 0x000fe20007f1e0ffULL, 0x0000001011337824ULL, 0x100fe200078e0208ULL,
0x0000003f13137812ULL, 0x000fe200078ec0ffULL, 0x000000101d357824ULL, 0x100fe200078e0208ULL,
0x0000003f27277812ULL, 0x000fe200078ec0ffULL, 0x0000001021377824ULL, 0x100fe200078e0208ULL,
0x0000003f23237812ULL, 0x000fe200078ec0ffULL, 0x00000010253f7824ULL, 0x100fe200078e0208ULL,
0x0000003f2b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000001029417824ULL, 0x000fc400078e0208ULL,
0x000000102d437824ULL, 0x100fe400078e0208ULL, 0x0000001047477824ULL, 0x100fe400078e0208ULL,
0x000000104b4b7824ULL, 0x100fe400078e0208ULL, 0x000000104f4f7824ULL, 0x100fe400078e0208ULL,
0x0000001053537824ULL, 0x100fe400078e0208ULL, 0x0000001057577824ULL, 0x000fc400078e0208ULL,
0x000000105b5b7824ULL, 0x100fe400078e0208ULL, 0x000000105f5f7824ULL, 0x100fe400078e0208ULL,
0x0000001063637824ULL, 0x000fe400078e0208ULL, 0x00005e000b087625ULL, 0x000fc800078e002cULL,
0x000000010f0f7824ULL, 0x100fe400078e0214ULL, 0x000000011f1f7824ULL, 0x000fe400078e0214ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000508087210ULL, 0x000fe20007f1e0ffULL,
0x00005e000f0a7625ULL, 0x000fc600078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062f7faeULL, 0x0003e2000b901c48ULL, 0x00005e001f0e7625ULL, 0x000fe200078e002cULL,
0x000000050a0a7210ULL, 0x000fc60007f3e0ffULL, 0x0000000113137824ULL, 0x100fe400078e0214ULL,
0x0000000127277824ULL, 0x100fe400078e0214ULL, 0x0000000123237824ULL, 0x000fe400078e0214ULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000050e0e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00130c7625ULL, 0x000fc600078e002cULL, 0x0000000008317faeULL, 0x0003e2000b901c48ULL,
0x00005e0027127625ULL, 0x000fe200078e002cULL, 0x000000050c0c7210ULL, 0x000fc60007f5e0ffULL,
0x00005e0023107625ULL, 0x000fc800078e002cULL, 0x000000012b2b7824ULL, 0x000fe400078e0214ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000000512127210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000000510107210ULL, 0x000fe20007f3e0ffULL,
0x00005e00451e7625ULL, 0x000fc600078e002cULL, 0x000000000a337faeULL, 0x0003e2000b901c48ULL,
0x00005e002b1c7625ULL, 0x000fc800078e002cULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x000000051e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000051c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0051247625ULL, 0x000fc800078e002cULL,
0x00005e0049207625ULL, 0x000fc800078e002cULL, 0x00005e004d227625ULL, 0x000fc800078e002cULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000000524247210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000000520207210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x0000000522227210ULL, 0x000fe20007f5e0ffULL,
0x00005e0055267625ULL, 0x000fc600078e002cULL, 0x000000000c357faeULL, 0x0003e2000b901c48ULL,
0x00005e0059287625ULL, 0x000fc600078e002cULL, 0x000000000e377faeULL, 0x0003e2000b901c48ULL,
0x00005e005d2a7625ULL, 0x000fc600078e002cULL, 0x00000000103f7faeULL, 0x0003e2000b901c48ULL,
0x00005e00612c7625ULL, 0x000fc600078e002cULL, 0x0000000012417faeULL, 0x0003e2000b901c48ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000000526267210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000000528287210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e0623ULL, 0x000000052a2a7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000052c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000001c437faeULL, 0x0003e2000b901c48ULL, 0x000000ffff297224ULL, 0x000fc400008e0629ULL,
0x000000ffff2b7224ULL, 0x000fe200010e062bULL, 0x000000001e477faeULL, 0x0003e2000b901c48ULL,
0x000000ffff2d7224ULL, 0x000fc600018e062dULL, 0x00000000204b7faeULL, 0x0003e8000b901c48ULL,
0x00000000224f7faeULL, 0x0003e8000b901c48ULL, 0x0000000024537faeULL, 0x0003e8000b901c48ULL,
0x0000000026577faeULL, 0x0003e8000b901c48ULL, 0x00000000285b7faeULL, 0x0003e8000b901c48ULL,
0x000000002a5f7faeULL, 0x0003e8000b901c48ULL, 0x000000002c637faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff077424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff147424ULL, 0x000fc400078e00ffULL,
0x0000030007177a24ULL, 0x000fca00078e0217ULL, 0x000000021700720cULL, 0x000fe40003f06070ULL,
0x00000020183f7810ULL, 0x040fe20007ffe0ffULL, 0x000000021b447824ULL, 0x000fe200078e0204ULL,
0x0000000718097812ULL, 0x040fe400078ec0ffULL, 0xfffffff818437812ULL, 0x000fce00078ec0ffULL,
0x000000021a068824ULL, 0x000fe200078e0217ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000600006068625ULL, 0x000fe200078e0007ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000806148981ULL, 0x000362000c1e1900ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x002fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000100044447811ULL, 0x000fe400078e68ffULL, 0x0000000809427812ULL, 0x100fe400078ef818ULL,
0x0000000743437812ULL, 0x100fe400078ef818ULL, 0x000000073f3f7812ULL, 0x000fe400078ef818ULL,
0x0000000740087812ULL, 0x040fe200078e7843ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000740307812ULL, 0x000fe400078e783fULL, 0x0000004118797211ULL, 0x000fe200078fe0ffULL,
0x0000000843097824ULL, 0x000fe200078e0208ULL, 0x0000000441417810ULL, 0x000fe20007ffe0ffULL,
0x000000083f317824ULL, 0x000fc400078e0230ULL, 0x0000001009097824ULL, 0x100fe400078e0244ULL,
0x0000001031317824ULL, 0x000fc800078e0244ULL, 0x000000000908783bULL, 0x000e680000000200ULL,
0x000000003130783bULL, 0x000ea20000000200ULL, 0x00000018ff697819ULL, 0x002fe20000011408ULL,
0x0001000008347824ULL, 0x040fe200078e00ffULL, 0x00008880086f7816ULL, 0x040fe200000000ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011409ULL,
0x0001000009357824ULL, 0x040fe200078e00ffULL, 0x0000888009707816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff657819ULL, 0x000fc4000001140aULL,
0x000088800a6e7816ULL, 0x000fe400000000ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff567819ULL, 0x000fe2000001140bULL, 0x0000000800787306ULL, 0x0003e20000200c00ULL,
0x000088800b6d7816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fc40000011435ULL, 0x00000018ff577819ULL, 0x004fe20000011430ULL,
0x0000000900777306ULL, 0x0005e20000200c00ULL, 0x000100000a087824ULL, 0x002fe200078e00ffULL,
0x0000888030677816ULL, 0x000fe200000000ffULL, 0x000001000a0a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011431ULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x000100000b097824ULL, 0x044fe200078e00ffULL,
0x0000003400767306ULL, 0x000fe20000200c00ULL, 0x000001000b0b7824ULL, 0x000fe200078e00ffULL,
0x0000888031647816ULL, 0x000fc400000000ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000000a00747306ULL, 0x0003e20000200c00ULL,
0x00000018ff467819ULL, 0x000fe40000011432ULL, 0x0000888032617816ULL, 0x000fe400000000ffULL,
0x00000018ff457819ULL, 0x000fe40000011433ULL, 0x00008880335b7816ULL, 0x000fe200000000ffULL,
0x0000000b00717306ULL, 0x0005e20000200c00ULL, 0x00000001400a7810ULL, 0x002fc40007ffe0ffULL,
0x0000000240407810ULL, 0x000fe40007ffe0ffULL, 0x000000070a347812ULL, 0x040fe400078e7843ULL,
0x000000070a0a7812ULL, 0x000fe200078e783fULL, 0x0000003500757306ULL, 0x0003e20000200c00ULL,
0x000000084000780cULL, 0x000fe20003f05270ULL, 0x00000008430b7824ULL, 0x004fe400078e0234ULL,
0x000000083f477824ULL, 0x000fe400078e020aULL, 0x000000100b0b7824ULL, 0x000fc400078e0244ULL,
0x0000000800737306ULL, 0x0005e20000200c00ULL, 0x00000010470a7824ULL, 0x000fe400078e0244ULL,
0x000000000b34783bULL, 0x002e6a0000000200ULL, 0x0000000900727306ULL, 0x0007e20000200c00ULL,
0x0001000030087824ULL, 0x044fe400078e00ffULL, 0x0000010030307824ULL, 0x000fc600078e00ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0001000031097824ULL, 0x048fe200078e00ffULL, 0x00000008006a7306ULL, 0x0005e20000200c00ULL,
0x0000010031317824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000030006c7306ULL, 0x0007e20000200c00ULL,
0x0001000032087824ULL, 0x044fe400078e00ffULL, 0x0000010032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011408ULL, 0x0000003100687306ULL, 0x0005e20000200c00ULL,
0x0001000033307824ULL, 0x048fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000010033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003200637306ULL, 0x0007e20000200c00ULL, 0x0000000779317812ULL, 0x004fe400078e7842ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000018ff477819ULL, 0x002fe20000011434ULL,
0x0000001042317824ULL, 0x000fe200078e0231ULL, 0x00000018ff487819ULL, 0x000fe20000011435ULL,
0x00000030005e7306ULL, 0x0003e20000200c00ULL, 0x0001000035327824ULL, 0x008fe200078e00ffULL,
0x00008880344f7816ULL, 0x000fe200000000ffULL, 0x0000001031317824ULL, 0x000fe200078e00ffULL,
0x0000888035507816ULL, 0x040fe200000000ffULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc40000011432ULL, 0x0000003300607306ULL, 0x000fe20000200c00ULL,
0x0001000034307824ULL, 0x042fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000010034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011436ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000009006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000888036537816ULL, 0x000fc400000000ffULL,
0x0000000279797810ULL, 0x000fe40007ffe0ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011437ULL,
0x0000003000527306ULL, 0x0005e20000200c00ULL, 0x000000000a08783bULL, 0x002e620000000200ULL,
0x0000000779797812ULL, 0x000fe400078e7842ULL, 0x0000888037597816ULL, 0x000fc600000000ffULL,
0x0000001042797824ULL, 0x000fe200078e0279ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x000000003130783bULL, 0x004eae0000000200ULL, 0x0000003400547306ULL, 0x0009f00000200c00ULL,
0x0000003500517306ULL, 0x0007e20000200c00ULL, 0x0001000036347824ULL, 0x010fc400078e00ffULL,
0x0000010036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0001000037357824ULL, 0x048fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000010037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x00000018ff4b7819ULL, 0x002fe40000011408ULL,
0x00000018ff4c7819ULL, 0x000fe40000011409ULL, 0x00000018ff4e7819ULL, 0x000fe2000001140bULL,
0x00000034005a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4d7819ULL, 0x000fce000001140aULL,
0x00000035005c7306ULL, 0x0009e20000200c00ULL, 0x000054106f347816ULL, 0x002fce0000000076ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541078357816ULL, 0x010fe20000000069ULL,
0x0001000008697824ULL, 0x000fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x00000034302c723cULL, 0x004fee000000182cULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541070347816ULL, 0x008fc40000000075ULL,
0x0000541077357816ULL, 0x000fca0000000066ULL, 0x0000006d006d7306ULL, 0x000ea40000200c00ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x0000005700577306ULL, 0x000ee20000200c00ULL,
0x000054106e347816ULL, 0x002fe40000000073ULL, 0x0000541074357816ULL, 0x000fca0000000065ULL,
0x0000006700677306ULL, 0x000e640000200c00ULL, 0x000000343024723cULL, 0x000fec0000001824ULL,
0x0000006400647306ULL, 0x000f220000200c00ULL, 0x000054106d347816ULL, 0x004fe20000000072ULL,
0x00010000096d7824ULL, 0x000fe200078e00ffULL, 0x0000541071357816ULL, 0x000fc40000000056ULL,
0x000054106c577816ULL, 0x008fc60000000057ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x0000541067567816ULL, 0x002fe2000000006aULL, 0x000000343020723cULL, 0x040fec0000001820ULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x00005410646a7816ULL, 0x010fe2000000006bULL,
0x000000563004723cULL, 0x000fec0000001804ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x00005410686b7816ULL, 0x004fc4000000005fULL, 0x000088800a577816ULL, 0x000fe400000000ffULL,
0x00000018ff567819ULL, 0x000fc6000001146dULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541063637816ULL, 0x002fe20000000046ULL, 0x0000006a301c723cULL, 0x000fe2000000181cULL,
0x000000ffff467224ULL, 0x000fe400078e0057ULL, 0x000100000a577824ULL, 0x000fc600078e00ffULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x00005410605f7816ULL, 0x008fe40000000045ULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x0000005b005b7306ULL, 0x000eb00000200c00ULL,
0x0000003600587306ULL, 0x0007e20000200c00ULL, 0x0000541061627816ULL, 0x002fe40000000062ULL,
0x000054105b5e7816ULL, 0x004fca000000005eULL, 0x00000037005d7306ULL, 0x000fe20000200c00ULL,
0x0000888008367816ULL, 0x048fe200000000ffULL, 0x000000623010723cULL, 0x000fe20000001810ULL,
0x0000010008087824ULL, 0x000fca00078e00ffULL, 0x0000003600667306ULL, 0x0003e20000200c00ULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000005e300c723cULL, 0x000fec000000180cULL,
0x0000006900657306ULL, 0x0005e20000200c00ULL, 0x0000001079367824ULL, 0x002fe200078e00ffULL,
0x000088800b317816ULL, 0x000fe200000000ffULL, 0x000001000a307824ULL, 0x000fc400078e00ffULL,
0x000100000b327824ULL, 0x040fe400078e00ffULL, 0x000000003634783bULL, 0x000e620000000200ULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x0000888009697816ULL, 0x044fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000018ff097819ULL, 0x000fc40000011409ULL, 0x00000018ff0b7819ULL, 0x000fc6000001140bULL,
0x0000004a004a7306ULL, 0x000ef00000200c00ULL, 0x0000004700477306ULL, 0x000f220000200c00ULL,
0x0000541051517816ULL, 0x004fce0000000048ULL, 0x0000004900497306ULL, 0x000ea20000200c00ULL,
0x000054105d5d7816ULL, 0x008fe4000000004aULL, 0x00005410664a7816ULL, 0x000fca0000000065ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541054477816ULL, 0x010fce0000000047ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541058497816ULL, 0x004fce0000000049ULL,
0x0000004d004d7306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x0000005300537306ULL, 0x000ef00000200c00ULL,
0x0000005900597306ULL, 0x000f220000200c00ULL, 0x0000541050507816ULL, 0x004fce0000000055ULL,
0x0000000800087306ULL, 0x000ea20000200c00ULL, 0x0000541053487816ULL, 0x008fe2000000005aULL,
0x000000503428723cULL, 0x042fec0000001828ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410595c7816ULL, 0x010fe2000000005cULL, 0x000000483424723cULL, 0x040fec0000001824ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x00005410084b7816ULL, 0x004fe2000000004bULL,
0x0000005c3420723cULL, 0x040fec0000001820ULL, 0x0000000900097306ULL, 0x000ea40000200c00ULL,
0x0000004a3404723cULL, 0x000fec0000001804ULL, 0x0000004600617306ULL, 0x0007e20000200c00ULL,
0x0000541069567816ULL, 0x002fce0000000056ULL, 0x00000057000a7306ULL, 0x0004620000200c00ULL,
0x000054104f467816ULL, 0x008fce0000000052ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541009577816ULL, 0x004fe2000000004cULL, 0x00000046342c723cULL, 0x040fec000000182cULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x00005410610a7816ULL, 0x002fe2000000000aULL,
0x00000056341c723cULL, 0x000fec000000181cULL, 0x0000003200327306ULL, 0x000e700000200c00ULL,
0x0000000b00337306ULL, 0x0004e20000200c00ULL, 0x0000541031327816ULL, 0x002fc40000000032ULL,
0x00005410300b7816ULL, 0x004fe4000000004dULL, 0x0000541033337816ULL, 0x008fca000000004eULL,
0x0000000a3410723cULL, 0x040ff00000001810ULL, 0x00000032340c723cULL, 0x000fe2000000180cULL,
0xfffff0f000000947ULL, 0x000fee000383ffffULL, 0x01b6140038097984ULL, 0x000e620000000800ULL,
0x0000002e19087220ULL, 0x000fc40000410000ULL, 0x00000029192e7220ULL, 0x040fe40000410000ULL,
0x0000000419297220ULL, 0x040fe20000410000ULL, 0x0000ffff3a047812ULL, 0x000fe200078ec0ffULL,
0x0000002f190a7220ULL, 0x040fe40000410000ULL, 0x0000002a190b7220ULL, 0x040fe20000410000ULL,
0x0000888004377816ULL, 0x000fe200000000ffULL, 0x0000002b19327220ULL, 0x040fe40000410000ULL,
0x00000028192f7220ULL, 0x000fc40000410000ULL, 0x00000020192b7220ULL, 0x040fe40000410000ULL,
0x00000021192a7220ULL, 0x040fe40000410000ULL, 0x0000002219227220ULL, 0x000fe40000410000ULL,
0x8000000037047824ULL, 0x000fe400078e00ffULL, 0x0000002319207220ULL, 0x040fe40000410000ULL,
0x0000000519287220ULL, 0x000fc40000410000ULL, 0x0000001f19217220ULL, 0x040fe40000410000ULL,
0x0000002619337220ULL, 0x040fe40000410000ULL, 0x0000002719347220ULL, 0x040fe40000410000ULL,
0x0000000619067220ULL, 0x040fe40000410000ULL, 0x0000000719077220ULL, 0x040fe40000410000ULL,
0x0000001e19057220ULL, 0x000fc40000410000ULL, 0x0000001219357220ULL, 0x000fe20000410000ULL,
0x8000000009ff7812ULL, 0x002fe20007804804ULL, 0x0000001319367220ULL, 0x040fe40000410000ULL,
0x0000002c19317220ULL, 0x040fe40000410000ULL, 0x0000002d19307220ULL, 0x040fe40000410000ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0008ULL, 0x00000024192d7220ULL, 0x000fc40000410000ULL,
0x00000025192c7220ULL, 0x040fe40000410000ULL, 0x0000001c19277220ULL, 0x040fe40000410000ULL,
0x0000001d19267220ULL, 0x040fe40000410000ULL, 0x000000ffff087224ULL, 0x000fe400078e0022ULL,
0x0000001019257220ULL, 0x040fe40000410000ULL, 0x0000001119247220ULL, 0x000fc40000410000ULL,
0x0000000c19237220ULL, 0x040fe40000410000ULL, 0x000000ffff1d7224ULL, 0x000fe400078e000aULL,
0x000000ffff1c7224ULL, 0x000fe400078e000bULL, 0x000000ffff137224ULL, 0x000fe400078e0020ULL,
0x000000ffff227224ULL, 0x000fe400078e0021ULL, 0x0000000d191f7220ULL, 0x000fc40000410000ULL,
0x0000000e190e7220ULL, 0x040fe40000410000ULL, 0x0000000f190c7220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0032ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0033ULL,
0x000000ffff097224ULL, 0x000fe400078e0034ULL, 0x000000ffff127224ULL, 0x000fc400078e0006ULL,
0x000000ffff117224ULL, 0x000fe400078e0007ULL, 0x000000ffff107224ULL, 0x000fe400078e0005ULL,
0x000000ffff217224ULL, 0x000fe400078e0035ULL, 0x000000ffff207224ULL, 0x000fe200078e0036ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000037067824ULL, 0x000fe400078e00ffULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01b6140038057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004180c7824ULL, 0x000fe200078e00ffULL,
0x000000391600720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff00c047812ULL, 0x000fca00078ec0ffULL, 0x000000801b0d7824ULL, 0x000fca00078e0204ULL,
0x01b400000d047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000218167824ULL, 0x000fe400078e00ffULL, 0x00000001003d7824ULL, 0x000fc600078e0a3dULL,
0x0000000616167812ULL, 0x000fc800078ec0ffULL, 0x0000000116327812ULL, 0x040fe400078efcffULL,
0x0000000816347812ULL, 0x000fe400078efcffULL, 0x0000003d3200720cULL, 0x080fe40003f26070ULL,
0x0000001016327812ULL, 0x000fe400078efcffULL, 0x0000003d3400720cULL, 0x080fe40003f06070ULL,
0x0000003d3200720cULL, 0x000fc40003fc6070ULL, 0x0000001116347812ULL, 0x040fe400078efcffULL,
0x0000001816327812ULL, 0x040fe400078efcffULL, 0x0000003d1600720cULL, 0x080fe40003f46070ULL,
0x0000003d3400720cULL, 0x080fe40003fa6070ULL, 0x0000003d3200720cULL, 0x000fe40003f66070ULL,
0x0000000916367812ULL, 0x000fc400078efcffULL, 0x0000001916347812ULL, 0x040fe400078efcffULL,
0x0000002016327812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff30307808ULL, 0x000fc40004800000ULL, 0x0000003d3600720cULL, 0x080fe40003f86070ULL,
0x0000003d3400720cULL, 0x080fe40003f46070ULL, 0x0000003d3200720cULL, 0x000fe40003f26070ULL,
0x0000002116347812ULL, 0x040fe400078efcffULL, 0x0000002816327812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fc40004000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006000000ULL,
0x0000003d3400720cULL, 0x080fe40003f06070ULL, 0x0000003d3200720cULL, 0x000fe40003f86070ULL,
0x0000002916347812ULL, 0x000fc400078efcffULL, 0x0000003016327812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006800000ULL,
0x0000003d3400720cULL, 0x000fc40003fc6070ULL, 0x0000003d3200720cULL, 0x000fe40003fa6070ULL,
0x0000003116347812ULL, 0x040fe400078efcffULL, 0x0000003816327812ULL, 0x040fe400078efcffULL,
0x0000003916167812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff29297808ULL, 0x000fe40004800000ULL, 0x0000003d3400720cULL, 0x080fe40003f66070ULL,
0x0000003d3200720cULL, 0x000fc40003f46070ULL, 0x0000003d1600720cULL, 0x000fe40003f26070ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0xff7fffff22227808ULL, 0x000fc40007000000ULL, 0xff7fffff26267808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff20207808ULL, 0x000fe40005800000ULL, 0xff7fffff24247808ULL, 0x000fe40005800000ULL,
0xff7fffff0f0f7808ULL, 0x000fc40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003104337209ULL, 0x004fe40007810000ULL,
0x0000001e05167209ULL, 0x000fe40007810000ULL, 0x0000003033047209ULL, 0x000fe40007810000ULL,
0x0000001d16057209ULL, 0x000fc40007810000ULL, 0x0000002f04337209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000002e33167209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002d16337209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fc40007810000ULL, 0x0000002c33167209ULL, 0x000fe40007810000ULL,
0x0000000904057209ULL, 0x000fe40007810000ULL, 0x0000002b16337209ULL, 0x000fe40007810000ULL,
0x0000000805047209ULL, 0x000fe40007810000ULL, 0x0000002a33167209ULL, 0x000fe40007810000ULL,
0x0000001304057209ULL, 0x000fc40007810000ULL, 0x0000002916337209ULL, 0x000fe40007810000ULL,
0x0000001205047209ULL, 0x000fe40007810000ULL, 0x0000002833167209ULL, 0x000fe40007810000ULL,
0x0000001104057209ULL, 0x000fe40007810000ULL, 0x0000002716337209ULL, 0x000fe40007810000ULL,
0x0000001005057209ULL, 0x000fc40007810000ULL, 0x0000002633047209ULL, 0x000fe40007810000ULL,
0x0000002205167209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x0000002116337209ULL, 0x000fe40007810000ULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x0000002033167209ULL, 0x000fc40007810000ULL, 0x0000002304047209ULL, 0x000fe40007810000ULL,
0x0000000f16057209ULL, 0x000fe40007810000ULL, 0x0000001f04347209ULL, 0x000fe40007810000ULL,
0x0000000e05367209ULL, 0x000fe20007810000ULL, 0x00000e827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x0004e400000e0000ULL, 0x0000000434377209ULL, 0x008fe20007810000ULL,
0x00000ec27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0036047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007167f89ULL, 0x000e6200000e0000ULL,
0x0000000436327209ULL, 0x008fc60007810000ULL, 0x0c201f0037047f89ULL, 0x000ee200000e0000ULL,
0x0000000506337209ULL, 0x010fc60007810000ULL, 0x0c201f0032057f89ULL, 0x000f2200000e0000ULL,
0x0000001607167209ULL, 0x002fc60007810000ULL, 0x0c201f0033347f89ULL, 0x004e6800000e0000ULL,
0x0c201f0016357f89ULL, 0x0004a200000e0000ULL, 0x0000000437047209ULL, 0x008fe40007810000ULL,
0x0000000532057209ULL, 0x010fe40007810000ULL, 0x0000003433067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04327820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b05377820ULL, 0x000fe20000410000ULL, 0x0000000000067886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b24247823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010832ULL, 0x0000002400347308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b2e2e7823ULL, 0x000fe40000010832ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010837ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fc40000010837ULL,
0x3fb8aa3b0b247823ULL, 0x002fe40000010837ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL, 0x0000003000307308ULL, 0x000e620000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b2c2c7823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010832ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b29297823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010832ULL, 0x0000002e002e7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b26267823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b083d7823ULL, 0x100fe20000010837ULL,
0x000000313008723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b11307823ULL, 0x100fe20000010837ULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b10317823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc60000010837ULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x00000024000b7308ULL, 0x0003300000000800ULL,
0x0000002300337308ULL, 0x0005e20000000800ULL, 0x3c003c00ff247424ULL, 0x002fce00078e00ffULL,
0x0000001f00327308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a237823ULL, 0x104fe20000010837ULL,
0x0000002f2e0a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b122f7823ULL, 0x000fe20000010837ULL,
0x0000001c0b0b723eULL, 0x010fc800000000ffULL, 0x0000002500077308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b091f7823ULL, 0x002fe20000010837ULL, 0x0000001e1d09723eULL, 0x000fcc00000000ffULL,
0x0000001f00367308ULL, 0x0003e20000000800ULL, 0x3c003c00ff257424ULL, 0x004fce00078e00ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x00000024081c723cULL, 0x002fee00000018ffULL,
0x0000002c002c7308ULL, 0x000e700000000800ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000002d2c10723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b202c7823ULL, 0x000fcc0000010837ULL, 0x0000002300237308ULL, 0x000e700000000800ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x0000002b2a12723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b222a7823ULL, 0x000fc40000010837ULL, 0x3fb8aa3b212b7823ULL, 0x000fc80000010837ULL,
0x00000013002e7308ULL, 0x000ea20000000800ULL, 0x000000233611723eULL, 0x002fce00000000ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000003d2e13723eULL, 0x004fce00000000ffULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x00000024101c723cULL, 0x000fee000000181cULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000292820723eULL, 0x002fce00000000ffULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000272622723eULL, 0x004fce00000000ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000002f3021723eULL, 0x002fce00000000ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x000000312a23723eULL, 0x004fce00000000ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x000000242040723cULL, 0x000fee000000181cULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000fff1d7424ULL, 0x000fe200078e00ffULL, 0xfffffffc181c7812ULL, 0x000fcc00078ec0ffULL,
0x0000000e000e7308ULL, 0x000ea20000000800ULL, 0x00000033321e723eULL, 0x000fe400000000ffULL,
0x0000001c1d287219ULL, 0x000fe400000006ffULL, 0x00000007341c723eULL, 0x000fe400000000ffULL,
0x00000000282773a1ULL, 0x000ee200000e8000ULL, 0x00000000280573c4ULL, 0x000f220000004000ULL,
0x0000002b2c1d723eULL, 0x002fe400000000ffULL, 0x0000001635077209ULL, 0x000fc40007810000ULL,
0x0000000f0e1f723eULL, 0x004fce00000000ffULL, 0x000000241c40723cULL, 0x000fe20000001840ULL,
0x0000000628ff7c12ULL, 0x008fda000f804027ULL, 0x00000ae205008947ULL, 0x010ff4000b800000ULL,
0x001c1fff40247589ULL, 0x0002a400000e0000ULL, 0x00000000280f73a1ULL, 0x000ee200000e8000ULL,
0x00000000280573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x0000000628ff7c12ULL, 0x008fda000f80400fULL, 0x00000b0205008947ULL, 0x010fea000b800000ULL,
0x001c1fff42257589ULL, 0x00072800000e0000ULL, 0x001c1fff01267589ULL, 0x00066800000e0000ULL,
0x001c1fff27277589ULL, 0x0006a400000e0000ULL, 0x00000002ff0e7819ULL, 0x000fe40000011618ULL,
0x0000000c0c437812ULL, 0x000fc400078ec0ffULL, 0x000000070e0f7812ULL, 0x040fe200078ec0ffULL,
0x000000080e2a7824ULL, 0x040fe200078e00ffULL, 0x0000000eff287212ULL, 0x00afe200078e33ffULL,
0x000000080e167824ULL, 0x000fe200078e00ffULL, 0x0000000318ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080e357824ULL, 0x040fe200078e00ffULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82a297812ULL, 0x100fe400078ee20fULL, 0x00000001162b7812ULL, 0x100fe200078ef60fULL,
0x000000080e4d7824ULL, 0x000fe200078e00ffULL, 0x00000002162d7812ULL, 0x100fe200078ef60fULL,
0x000000080e377824ULL, 0x000fe200078e00ffULL, 0x00000003162f7812ULL, 0x100fe200078ef60fULL,
0x000000080e3d7824ULL, 0x000fe200078e00ffULL, 0x0000000416317812ULL, 0x000fc400078ef60fULL,
0x0000000516337812ULL, 0x140fe400078ef60fULL, 0x00000006160f7812ULL, 0x000fe400078ef60fULL,
0xfffffff835357812ULL, 0x000fe400078ee228ULL, 0x0000000eff287212ULL, 0x000fe400078e33ffULL,
0x000000070e167812ULL, 0x000fe400078ec0ffULL, 0x000110001b0e7811ULL, 0x000fc400078e58ffULL,
0xfffffff837377812ULL, 0x100fe400078ee216ULL, 0x000000013d3f7812ULL, 0x000fe200078ef616ULL,
0x00000010290c7824ULL, 0x000fe200078e020eULL, 0x000000023d417812ULL, 0x000fe200078ef616ULL,
0x000000102f2a7824ULL, 0x000fe200078e020eULL, 0x000000033d457812ULL, 0x000fe200078ef616ULL,
0x000000100f307824ULL, 0x000fe200078e020eULL, 0x000000043d477812ULL, 0x000fe200078ef616ULL,
0x00000010312c7824ULL, 0x000fe200078e020eULL, 0x000000053d497812ULL, 0x000fe200078ef616ULL,
0x00000001430f7824ULL, 0x000fe200078e020cULL, 0x000000063d4b7812ULL, 0x000fe200078ef616ULL,
0x000000102b167824ULL, 0x000fe200078e020eULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee228ULL,
0x000000102d287824ULL, 0x100fe200078e020eULL, 0x000000080f007388ULL, 0x0003e20000000800ULL,
0x00000010332e7824ULL, 0x000fc400078e020eULL, 0x0000000143297824ULL, 0x040fe400078e0216ULL,
0x00000001432b7824ULL, 0x000fe400078e0228ULL, 0x0000001035327824ULL, 0x000fe200078e020eULL,
0x0000000a29007388ULL, 0x0007e20000000800ULL, 0x00000001432d7824ULL, 0x000fe400078e022aULL,
0x00000010370c7824ULL, 0x000fe200078e020eULL, 0x000000102b007388ULL, 0x0007e20000000800ULL,
0x00000001432f7824ULL, 0x000fc400078e022cULL, 0x000000103f347824ULL, 0x000fe200078e020eULL,
0x000000122d007388ULL, 0x0007e20000000800ULL, 0x0000000143317824ULL, 0x000fe400078e022eULL,
0x0000001041367824ULL, 0x000fe200078e020eULL, 0x000000202f007388ULL, 0x0007e20000000800ULL,
0x0000000143337824ULL, 0x000fe400078e0230ULL, 0x0000001045377824ULL, 0x000fe200078e020eULL,
0x0000002231007388ULL, 0x0007e20000000800ULL, 0x0000000143357824ULL, 0x000fc400078e0232ULL,
0x00000010473d7824ULL, 0x000fe200078e020eULL, 0x0000001c33007388ULL, 0x0007e20000000800ULL,
0x00000001430c7824ULL, 0x000fe400078e020cULL, 0x00000010493f7824ULL, 0x000fe200078e020eULL,
0x0000001e35007388ULL, 0x0007e20000000800ULL, 0x0000000143347824ULL, 0x000fe400078e0234ULL,
0x000000104b407824ULL, 0x000fe200078e020eULL, 0x000000090c007388ULL, 0x0007e20000000800ULL,
0x0000000143367824ULL, 0x000fc400078e0236ULL, 0x000000104d417824ULL, 0x000fe200078e020eULL,
0x0000000b34007388ULL, 0x0007e20000000800ULL, 0x0000000143087824ULL, 0x042fe400078e0237ULL,
0x00000001430e7824ULL, 0x040fe200078e023dULL, 0x0000001136007388ULL, 0x0007e20000000800ULL,
0x0000000143167824ULL, 0x040fe400078e023fULL, 0x0000000143407824ULL, 0x040fe200078e0240ULL,
0x0000001308007388ULL, 0x0007e20000000800ULL, 0x0000000143287824ULL, 0x000fc600078e0241ULL,
0x000000210e007388ULL, 0x0007e80000000800ULL, 0x0000002316007388ULL, 0x0007e80000000800ULL,
0x0000001d40007388ULL, 0x0007e80000000800ULL, 0x0000001f28007388ULL, 0x0007e80000000800ULL,
0x01b000040d008388ULL, 0x0007e80000000c00ULL, 0x01b200240d008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000033c00720cULL, 0x000fe20003f26070ULL,
0x01b6080038ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff3aff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff167224ULL, 0x008fc400078e003cULL, 0x000000ffff047224ULL, 0x000fe200078e003eULL,
0x00000001ff3a7807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffbd7000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e002eULL, 0x00011a90002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000078000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff307224ULL, 0x004fe200078e0032ULL,
0xffff8b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002dULL,
0x00011b00002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0032ULL, 0xffff8b3000007947ULL, 0x000fea000383ffffULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x00011b7000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000066000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0035ULL,
0xfffff12000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x006fe200078e0036ULL,
0x00011bf000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x020fea0003c00000ULL, 0x0000003536367209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e0006ULL, 0x00011c6000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x0000001fff3d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x0000003506067209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0007ULL,
0x00011cd000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000003507167209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e0037ULL, 0x00011d4000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x0000001fff3d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000003537047209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0036ULL,
0x00011db000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000003536057209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e0006ULL, 0x00011e2000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x0000001fff3d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000003506067209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0016ULL,
0x00011e9000327802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffef0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x000fe200078e0040ULL, 0x00011f00002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fc400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0028ULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0032ULL, 0xfffff4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x002fe200078e0042ULL, 0x00011f80002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0028ULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff347224ULL, 0x002fe200078e00ffULL, 0x00011fe0002e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff357424ULL, 0x000fc400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0028ULL,
0x000000ffff257224ULL, 0x004fe400078e0032ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff367224ULL, 0x002fe200078e0028ULL, 0x00012040002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff267224ULL, 0x004fe400078e0032ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e0032ULL, 0xfffff3f000007947ULL, 0x000fea000383ffffULL,
0x0180000005027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000500028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000207ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000207ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffede3006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff337424ULL, 0x000fe200078e00ffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0c00003534357389ULL, 0x0002a200000e003dULL,
0xfffeddf032007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0000003433327389ULL, 0x0002a200000e0035ULL,
0xfffeddb02e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000210ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007a8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x0000000000000500ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d20ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d50ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d70ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000de0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000df8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000012300ULL, 0xc700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013300ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013310ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013310ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013790ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000de0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012520ULL, 0x0000000000012520ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013790ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin_len = 79984;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
