/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018fb8ULL, 0x0000000000018c38ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000017590ULL, 0x0000000000000270ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000017800ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001759000000000ULL, 0x0001380400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001759000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000c3ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000027000dc2804ULL,
0x000009f000000460ULL, 0x0000307000003000ULL, 0x0000328000003150ULL, 0x000034f0000033b0ULL,
0x00003a7000003a60ULL, 0x00003a9000003a80ULL, 0x00005980000058f0ULL, 0x00005b9000005a60ULL,
0x00005e0000005cc0ULL, 0x000062c0000062b0ULL, 0x000062e0000062d0ULL, 0x000080c000008030ULL,
0x000082d0000081a0ULL, 0x0000854000008400ULL, 0x00008a00000089f0ULL, 0x00008a2000008a10ULL,
0x0000a8900000a820ULL, 0x0000aab00000a980ULL, 0x0000ad200000abe0ULL, 0x0000b2300000b220ULL,
0x0000b2500000b240ULL, 0x0000c5100000c500ULL, 0x0000c5300000c520ULL, 0x00015e6000015db0ULL,
0x0001625000016140ULL, 0x0001674000016650ULL, 0x00016b00000169f0ULL, 0x0000053004303904ULL,
0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000009ULL, 0x00000720003f0100ULL,
0x0001a68800000009ULL, 0x00000860003f0100ULL, 0x0001a6a800000000ULL, 0x00000960003f0100ULL,
0x0001a6c800000006ULL, 0x000013f0003f0100ULL, 0x0001a600000000ffULL, 0x0000156000080107ULL,
0x0001a68800000003ULL, 0x00001ff0003f0101ULL, 0x00000000000000ffULL, 0x0000207000040107ULL,
0x00000000000000ffULL, 0x000020f000040101ULL, 0x0000002000000004ULL, 0x00002200003f0101ULL,
0x0001a6c800000036ULL, 0x0000239000080109ULL, 0x0001a6c800000038ULL, 0x00002ca0003f0109ULL,
0x0001a6b000000038ULL, 0x00002d7000080107ULL, 0x0001a6b00000003aULL, 0x00002d80003f0101ULL,
0x0001a60800000080ULL, 0x00002da0003f0101ULL, 0x0001a60800000080ULL, 0x00002f10003f0109ULL,
0x0001a60800000080ULL, 0x00003680003f0109ULL, 0x0001a6a80000003aULL, 0x000037f0003f0109ULL,
0x0001a6a80000003aULL, 0x00004c10003f0109ULL, 0x0001a6c800000034ULL, 0x00004c20003f0101ULL,
0x0001a68800000081ULL, 0x00004c5000080101ULL, 0x0000000000000006ULL, 0x00004dc0003f0109ULL,
0x0000000000000006ULL, 0x00005600003f0109ULL, 0x0001a6a80000007aULL, 0x000056a000080107ULL,
0x0001a6a800000088ULL, 0x000056b0003f0101ULL, 0x0001a62800000080ULL, 0x000056d0003f0101ULL,
0x0001a62800000080ULL, 0x00005840003f0109ULL, 0x0001a62800000080ULL, 0x00005fd0003f0109ULL,
0x0001a6b00000002fULL, 0x0000615000080109ULL, 0x0001a6b000000037ULL, 0x00007340003f0109ULL,
0x0001a6c800000034ULL, 0x00007350003f0101ULL, 0x0001a69000000036ULL, 0x0000738000080101ULL,
0x0000000000000006ULL, 0x000074f0003f0109ULL, 0x0000000000000006ULL, 0x00007d60003f0109ULL,
0x0001a6b00000002eULL, 0x00007de000080107ULL, 0x0001a6b000000084ULL, 0x00007df0003f0101ULL,
0x0001a64800000080ULL, 0x00007e10003f0101ULL, 0x0001a64800000080ULL, 0x00007f80003f0109ULL,
0x0001a64800000080ULL, 0x00008710003f0109ULL, 0x0001a6a80000002fULL, 0x0000889000080109ULL,
0x0001a6a800000037ULL, 0x00009a60003f0109ULL, 0x0001a6c80000004dULL, 0x00009a80003f0101ULL,
0x0001a69800000036ULL, 0x00009ab000080101ULL, 0x0001a6c80000004dULL, 0x00009c40003f0109ULL,
0x0001a6c80000004dULL, 0x0000a580003f0109ULL, 0x0001a6a80000002fULL, 0x0000a5d000080107ULL,
0x0001a6a800000034ULL, 0x0000a5f0003f0101ULL, 0x0001a6680000002dULL, 0x0000a620003f0101ULL,
0x0001a6680000002dULL, 0x0000a790003f0109ULL, 0x0001a6680000002dULL, 0x0000aee0003f0109ULL,
0x0001a6b00000002fULL, 0x0000b06000080109ULL, 0x0001a6b000000037ULL, 0x0000c190003f0109ULL,
0x0000000000000006ULL, 0x0000c200003f0101ULL, 0x0001a6a000000006ULL, 0x0000e530003f0101ULL,
0x0001a600000000ffULL, 0x0000feb000080101ULL, 0x0001a600000000ffULL, 0x0001007000080109ULL,
0x0001a600000000ffULL, 0x000103c000080109ULL, 0x0001a600000000ffULL, 0x000103e000080101ULL,
0x0001a600000000ffULL, 0x0001055000080109ULL, 0x0001a600000000ffULL, 0x0001341000080109ULL,
0x0001a68800000052ULL, 0x000137e0003f0101ULL, 0x0001a68800000052ULL, 0x00013950003f0109ULL,
0x0001a68800000052ULL, 0x00017520003f0109ULL, 0x0001a60800000077ULL, 0x00017530003f0101ULL,
0x0001a61000000077ULL, 0x00017540003f0101ULL, 0x0001a61800000077ULL, 0x00017550003f0101ULL,
0x0001a62000000077ULL, 0x00053803003f0101ULL, 0x0000d43000301c04ULL, 0x0000d7200000d460ULL,
0x0000db000000d910ULL, 0x0000dee00000dcf0ULL, 0x0000e2d00000e0d0ULL, 0x000105800000e480ULL,
0x000c050400017580ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL,
0x0000000000017590ULL, 0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000797919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x000000ff0200720cULL, 0x004fca0003f45070ULL, 0x00008500ff027b82ULL, 0x000ea20000000800ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff062b82ULL, 0x000f220000000a00ULL,
0x0000000179032836ULL, 0x008fe40000000000ULL, 0x0000000479042825ULL, 0x010fc800078e0006ULL,
0x0000000403062825ULL, 0x000fe400078e0006ULL, 0x0000000604052981ULL, 0x000ee8000c1e1900ULL,
0x0000000606002981ULL, 0x0008e2000c1e1900ULL, 0x0000000200037306ULL, 0x004ea20000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0200720cULL, 0x000fe20003f65070ULL,
0x00000000000c7919ULL, 0x000f220000002200ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe60003800000ULL, 0x0000000300037308ULL, 0x004ea40000001000ULL,
0x0ffffffe03087836ULL, 0x004fcc0000000000ULL, 0x0000000800097305ULL, 0x000524000021f000ULL,
0x000000ffff087224ULL, 0x004fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x012fc800078e0a09ULL,
0x000000020b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fe400078e0008ULL,
0x00000000000b7919ULL, 0x000e680000002300ULL, 0x0000000a09097227ULL, 0x020fe200078e00ffULL,
0x0000000000087919ULL, 0x000ea60000002600ULL, 0x000000ffff077224ULL, 0x000fc800078e0a09ULL,
0x0000000702037224ULL, 0x000fe400078e020aULL, 0x00000000000a7919ULL, 0x000f260000002100ULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a02ULL,
0x0000000109090836ULL, 0x000fc60000000000ULL, 0x000000020300720cULL, 0x000fe40003f26070ULL,
0x00000005ff637819ULL, 0x010fd6000001160aULL, 0x0000000109091836ULL, 0x000fe20000000000ULL,
0x00000002ff09b212ULL, 0x000fe200078e33ffULL, 0x00001fff63637589ULL, 0x000f2600000e0000ULL,
0x0000000900037306ULL, 0x000f620000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f65070ULL,
0x0000000300037308ULL, 0x020f640000001000ULL, 0x0ffffffe03067836ULL, 0x020fe40000000000ULL,
0x000000040b037c24ULL, 0x002fe2000f8e020cULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000600077305ULL, 0x000364000021f000ULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x0000000709047224ULL, 0x020fc800078e02ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a04ULL,
0x0000000d07077227ULL, 0x000fc800078e0006ULL, 0x0000000403067c24ULL, 0x000fe4000f8e020aULL,
0x0000000807777227ULL, 0x004fc600078e00ffULL, 0x0000007f0600780cULL, 0x040fe20003fa4070ULL,
0x000000ffff047224ULL, 0x000fe200078e0a77ULL, 0x000000030600780cULL, 0x000fc60003f84070ULL,
0x0000000409047224ULL, 0x000fca00078e0208ULL, 0x000000090400720cULL, 0x000fc60003f06070ULL,
0x000000000007d919ULL, 0x000e740000008800ULL, 0x0000000104040824ULL, 0x000fc400078e0a09ULL,
0x0000000177770836ULL, 0x000fe20000000000ULL, 0x000000ff0600720cULL, 0x000fe40003f05270ULL,
0x000000090400720cULL, 0x080fe40003f26070ULL, 0x00008400ff04ab82ULL, 0x000f360000000800ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000009ff77b212ULL, 0x000fc400078e33ffULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000010600780cULL, 0x000fe20003f64070ULL,
0x000000ffff757224ULL, 0x000fc800078e0a77ULL, 0x0000007509757224ULL, 0x000fe400078e0208ULL,
0x00001fff0b087589ULL, 0x00092200000e0000ULL, 0x0000000100032824ULL, 0x008fe200078e0a05ULL,
0x000004000000d802ULL, 0x000fc80000000f00ULL, 0x00000654070dd816ULL, 0x002fe20000000000ULL,
0x00008400ff03ab82ULL, 0x000ea20000000800ULL, 0xff317217ff07d424ULL, 0x000fc600078e00ffULL,
0x000000040600d824ULL, 0x000fe200078e020dULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000406097c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000090812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000406097c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400070000d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002075757824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000406007c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000406067c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000060912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803007c24ULL, 0x006fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a75ULL, 0x000000750000720cULL, 0x000fe20003f06070ULL,
0x000000047905a224ULL, 0x000fc400078e02ffULL, 0x0000000802147c24ULL, 0x000fe2000f8e02ffULL,
0x00000020000b7446ULL, 0x000fe2000380000bULL, 0x0000000408007824ULL, 0x000fe400078e0263ULL,
0x00000014050a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000400007824ULL, 0x000fe400078e00ffULL, 0x0000000877157c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x0000000400308947ULL, 0x000fea0003800000ULL,
0x00000008000c7d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000167919ULL, 0x000ee80000008800ULL, 0x0000000c000c7308ULL, 0x002e640000001000ULL,
0x0ffffffe0c077836ULL, 0x002fe20000000000ULL, 0x00000004ff047819ULL, 0x004fca0000011609ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x00000002040f7836ULL, 0x000fe40000000000ULL,
0x00000001000e7824ULL, 0x040fe400078e0204ULL, 0x0000000100107824ULL, 0x000fc800078e020fULL,
0x0000000175127824ULL, 0x000fe400078e0210ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL,
0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d070d7227ULL, 0x000fc800078e0006ULL,
0x0000000175067824ULL, 0x000fe400078e020eULL, 0x000000120d117227ULL, 0x000fc800078e00ffULL,
0x000000060d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x000000ffff137224ULL, 0x000fe400078e0a11ULL, 0x000000080d0c7c24ULL, 0x000fe4000f8e0206ULL,
0x00000008130d7c24ULL, 0x000fc6000f8e0212ULL, 0x000000080c007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x800000080c0c0c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe2000bf26070ULL, 0x0000000111112836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff0c7c12ULL, 0x000fce000f8e33ffULL, 0x0000000107071836ULL, 0x000fe40000000000ULL,
0x0000000111113836ULL, 0x000fc60000000000ULL, 0x000000070c0d7207ULL, 0x040fe40004000000ULL,
0x000000110c0c7207ULL, 0x000fe40004000000ULL, 0x000000000b077248ULL, 0x000fe20007fe0000ULL,
0x000000ffff117224ULL, 0x000fe400078e0a0dULL, 0x000000ffff137224ULL, 0x000fe400078e0a0cULL,
0x0000000811067c24ULL, 0x000fe2000f8e0206ULL, 0x0000040000117802ULL, 0x000fe20000000f00ULL,
0x0000000813127c24ULL, 0x000fc4000f8e0212ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000065416167816ULL, 0x008fe20000000011ULL, 0x0000000115067824ULL, 0x040fe400078e0206ULL,
0x0000000115117824ULL, 0x000fe200078e0212ULL, 0x000000070400720cULL, 0x080fe20003f06070ULL,
0x000000140d067224ULL, 0x080fe200078e0206ULL, 0x000000070f00720cULL, 0x000fe20003f26070ULL,
0x0000001009047824ULL, 0x000fe200078e00ffULL, 0x00000000160872caULL, 0x000fe200000e0000ULL,
0x000000140c0c7224ULL, 0x000fc400078e0211ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000f0040f7812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fc600078efcffULL, 0x000000010e007824ULL, 0x100fe200078e0209ULL,
0x0000000f0c0c7212ULL, 0x000fe200078efcffULL, 0x000000100e117824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x00000001100e7824ULL, 0x040fe200078e0209ULL,
0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010100f7824ULL, 0x000fe200078e00ffULL,
0xfffffff011007812ULL, 0x000fe400078ee200ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0xfffffff00f0e7812ULL, 0x000fc400078ee20eULL, 0x00000008000f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40009ffe4ffULL, 0x000000080e117c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060f7faeULL, 0x0003e8000c101c46ULL,
0x000000000c117faeULL, 0x0003e2000c901c46ULL, 0x0000000400147947ULL, 0x000fea0003800000ULL,
0x0000000800047d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000117919ULL, 0x000ee80000008800ULL, 0x0000000400047308ULL, 0x002e640000001000ULL,
0x0ffffffe04077836ULL, 0x002fe20000000000ULL, 0x0000000009007211ULL, 0x004fca00078fe0ffULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x0000000200107836ULL, 0x000fe40000000000ULL,
0x0000000175047824ULL, 0x040fe400078e0200ULL, 0x00000001750c7824ULL, 0x000fe400078e0210ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d070d7227ULL, 0x000fcc00078e0006ULL, 0x000000040d067227ULL, 0x000fc800078e00ffULL,
0x0000000c0d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL, 0x0000000807077c24ULL, 0x000fe4000f8e0204ULL,
0x000000080f0e7c24ULL, 0x000fc6000f8e020cULL, 0x0000000807007c0cULL, 0x000fe4000bf06070ULL,
0x000000080e007c0cULL, 0x000fd6000bf46070ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x800000080e0e2c36ULL, 0x000fe40008000000ULL, 0x0000000106060836ULL, 0x000fe20000000000ULL,
0x0000000807007c0cULL, 0x000fe2000bf26070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x000000080e007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff077c12ULL, 0x000fc4000f8e33ffULL, 0x00000400000e7802ULL, 0x000fc80000000f00ULL,
0x00000654110e7816ULL, 0x008fe2000000000eULL, 0x0000000106061836ULL, 0x000fe40000000000ULL,
0x000000010d0d3836ULL, 0x000fe40000000000ULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000607067207ULL, 0x040fe40004000000ULL, 0x0000000d070d7207ULL, 0x000fc60004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL,
0x0000000807047c24ULL, 0x000fe4000f8e0204ULL, 0x000000080f0c7c24ULL, 0x000fe2000f8e020cULL,
0x000000000e0872caULL, 0x000fe200000e0000ULL, 0x0000000115077824ULL, 0x040fe400078e0204ULL,
0x00000001150c7824ULL, 0x000fc400078e020cULL, 0x0000001009047824ULL, 0x000fe400078e00ffULL,
0x0000001406077224ULL, 0x080fe400078e0207ULL, 0x000000140d0c7224ULL, 0x000fe200078e020cULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fc800078e00ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000f06067212ULL, 0x000fc600078efcffULL,
0x00000001000e7824ULL, 0x100fe200078e0209ULL, 0x0000000f0c0c7212ULL, 0x000fe200078efcffULL,
0x0000000110007824ULL, 0x040fe200078e0209ULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010100f7824ULL, 0x000fe200078e00ffULL, 0xfffffff0110e7812ULL, 0x000fe400078ee20eULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00f007812ULL, 0x000fe400078ee200ULL,
0x0000000507077c10ULL, 0x000fc400087fe4ffULL, 0x000000080e0f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000800117c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060f7faeULL, 0x0003e8000b901c46ULL,
0x000000000c117faeULL, 0x0003e4000b901c46ULL, 0x0001a60008047890ULL, 0x000fe2000fffe03fULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000479067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606767981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x0000003f76747836ULL, 0x004fe40000000000ULL, 0x000000ff76007836ULL, 0x000fc60000000000ULL,
0x00000006ff747819ULL, 0x000fe40000011674ULL, 0x00000008ff627819ULL, 0x000fca0000011600ULL,
0x000000cc00f88947ULL, 0x000fea0003800000ULL, 0x00000002ff607819ULL, 0x000fc80000011663ULL,
0x03ffffff60597812ULL, 0x000fc800078ec0ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff088b82ULL, 0x000e620000000800ULL, 0x0000000279038824ULL, 0x000fce00078e00ffULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000803088224ULL, 0x002fe200078e0208ULL,
0x0000000863037c11ULL, 0x000fc6000f8e18ffULL, 0x0000000159058824ULL, 0x000fe400078e0208ULL,
0x00000004ff087424ULL, 0x000fe400078e00ffULL, 0x0000000405068825ULL, 0x004fe400078e0006ULL,
0x01a6880803ff79a7ULL, 0x0003e4000850003fULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000606058981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x00000040775a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff617819ULL, 0x000fe40000011663ULL,
0x0000000163037812ULL, 0x002fc600078ec0ffULL, 0x00000020615b7824ULL, 0x000fca00078e00ffULL,
0x000000205a007812ULL, 0x000fe200078ef85bULL, 0x0000000205057224ULL, 0x004fc800078e02ffULL,
0x0000004005117824ULL, 0x000fe200078e00ffULL, 0x0000000400080947ULL, 0x000fec0003800000ULL,
0x0000005b76027248ULL, 0x000fe20007fe0000ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe20000011609ULL, 0x00009000ff187b82ULL, 0x000e640000000a00ULL,
0x0000000102027824ULL, 0x000fe400078e0a5bULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x00000004050c7836ULL, 0x000fe20000000000ULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000106077824ULL, 0x000fc400078e0209ULL, 0x0000000806087824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a03ULL, 0x0000000c050d7836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x000000020c00720cULL, 0x080fe20003f46070ULL, 0x00000001030c7824ULL, 0x000fe200078e020cULL,
0x000000020500720cULL, 0x080fe20003f66070ULL, 0x00000001030e7824ULL, 0x000fe200078e020dULL,
0x000000020700720cULL, 0x080fe20003f26070ULL, 0x0000000103077824ULL, 0x000fe200078e0207ULL,
0x000000020d00720cULL, 0x000fe20003f06070ULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0x0000001811137211ULL, 0x002fe200078838ffULL, 0x000000010c057824ULL, 0x000fc400078e0209ULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x0000001911197211ULL, 0x000fe200020f3cffULL,
0x0000000100067824ULL, 0x040fe400078e020cULL, 0x00000001000c7824ULL, 0x040fe200078e0207ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x00000001000f7824ULL, 0x000fe400078e020eULL,
0x0000000107007824ULL, 0x000fe400078e0209ULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x000000010e057824ULL, 0x040fe400078e0209ULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff807127812ULL, 0x000fe200078ee200ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000000213027210ULL, 0x000fe40007f9e0ffULL, 0x0000000861007c11ULL, 0x000fe2000f8e68ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000007006117812ULL, 0x000fc400078ef804ULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c067812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200020e0619ULL,
0x000000700e0c7812ULL, 0x000fe200078ef804ULL, 0x0001600000057836ULL, 0x000fe20000000000ULL,
0x0000001311047210ULL, 0x000fe40007f9e0ffULL, 0x0000001306067210ULL, 0x000fe20007fbe0ffULL,
0x0000001008117824ULL, 0x100fe200078e0205ULL, 0x000000130c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001010137824ULL, 0x100fe400078e0205ULL, 0x0000001012157824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000d901c46ULL,
0x0000001014177824ULL, 0x000fc400078e0205ULL, 0x0000000107057824ULL, 0x100fe400020e0619ULL,
0x000000010d077824ULL, 0x100fe400028e0619ULL, 0x000000010f0d7824ULL, 0x000fe200030e0619ULL,
0x0000000004137faeULL, 0x0003e8000d101c46ULL, 0x0000000006157faeULL, 0x0003e8000c901c46ULL,
0x000000000c177faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001003027824ULL, 0x000fe200078e00ffULL, 0x00009000ff127b82ULL, 0x000e680000000a00ULL,
0x0000000209027211ULL, 0x000fc800078fe8ffULL, 0x0000000902037210ULL, 0x000fe20007ffe0ffULL,
0x0000000802087824ULL, 0x000fe400078e00ffULL, 0x0000000402067836ULL, 0x000fe40000000000ULL,
0x0000000c020e7836ULL, 0x000fe20000000000ULL, 0xfffffff808057812ULL, 0x000fe200078ee203ULL,
0x0000000106077824ULL, 0x040fe400078e0209ULL, 0x0000000806087824ULL, 0x000fe400078e00ffULL,
0x0000000100037824ULL, 0x000fc400078e0202ULL, 0x00000008020c7836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000008003027825ULL, 0x000fe200078e00ffULL,
0x0000001211157211ULL, 0x002fe400078038ffULL, 0x0000000861127c11ULL, 0x000fe2000f8e68ffULL,
0x000000010e077824ULL, 0x040fe200078e0209ULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x0000001311197211ULL, 0x000fe200000f3cffULL,
0x0000000100067824ULL, 0x040fe200078e0206ULL, 0x0000000215027210ULL, 0x000fe20007f1e0ffULL,
0x00000001000d7824ULL, 0x040fe200078e020cULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x00000001000f7824ULL, 0x000fc400078e020eULL, 0x000000010c007824ULL, 0x040fe400078e0209ULL,
0x000000080c177824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff817007812ULL, 0x000fe200078ee200ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000007006117812ULL, 0x000fc600078ef804ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c067812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200000e0619ULL,
0x000000700e0c7812ULL, 0x000fe200078ef804ULL, 0x0001600012177836ULL, 0x000fe20000000000ULL,
0x0000001115047210ULL, 0x000fe40007f1e0ffULL, 0x0000000615067210ULL, 0x000fe20007f3e0ffULL,
0x0000001005117824ULL, 0x100fe200078e0217ULL, 0x0000000c150c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001008137824ULL, 0x000fe400078e0217ULL, 0x0000000107057824ULL, 0x000fe200000e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000b901c46ULL,
0x0000001000157824ULL, 0x000fc400078e0217ULL, 0x000000010d077824ULL, 0x000fe200008e0619ULL,
0x0000000004137faeULL, 0x0003e2000b901c46ULL, 0x0000001010177824ULL, 0x000fe400078e0217ULL,
0x000000010f0d7824ULL, 0x000fe200010e0619ULL, 0x0000000006157faeULL, 0x0003e8000b901c46ULL,
0x000000000c177faeULL, 0x0003e4000b901c46ULL, 0x0000000159597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff058b82ULL, 0x002e620000000800ULL, 0x0000000279008824ULL, 0x000fe200078e00ffULL,
0x00000000610472caULL, 0x000fcc00000e0000ULL, 0x00009200ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fe400078e0259ULL,
0x00000008ff007e24ULL, 0x000fe4000f8e00ffULL, 0x0000000405028825ULL, 0x004fc800078e0002ULL,
0x0001a6a800007836ULL, 0x000fe20000000000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff6200720cULL, 0x000fe20003f05270ULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fe200000e0000ULL,
0x000000ffff827224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff497224ULL, 0x000fe400078e00ffULL, 0x0000000861047824ULL, 0x000fe200078e0200ULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x00000005ff0279a7ULL, 0x0002a20008500004ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fc4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00002005040479a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000000a000808947ULL, 0x000fec0003800000ULL, 0x00009600ff077b82ULL, 0x000ee20000000800ULL,
0x0000000279087824ULL, 0x000fe200078e00ffULL, 0x0000000161587812ULL, 0x000fe200078ec0ffULL,
0x000000ffff797224ULL, 0x004fe400078e0003ULL, 0x000000ffff397224ULL, 0x002fe400078e0005ULL,
0xff317217ff7e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe400078e00ffULL,
0x0000000708087224ULL, 0x008fc400078e0207ULL, 0x000000ffff077224ULL, 0x000fce00078e00ffULL,
0x000000ffff6e7224ULL, 0x000fce00078e0059ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000000463067824ULL, 0x000fca00078e00ffULL, 0xfffffff806367812ULL, 0x000fc800078ec0ffULL,
0x01a6c839360075a7ULL, 0x000e620008000148ULL, 0x0000000836387c36ULL, 0x000fc80008000000ULL,
0x0001a6c838067836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01a6c839380075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001063347824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000000107357836ULL, 0x000fe40000000000ULL,
0x0000000481817c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe034367812ULL, 0x000fe400078ec0ffULL,
0x000000623500720cULL, 0x000fe20003f26070ULL, 0x0000004081817824ULL, 0x000fe400078e00ffULL,
0x0000010007367824ULL, 0x000fc800078e0236ULL, 0x0000004036397836ULL, 0x000fca0000000000ULL,
0x0000002039357812ULL, 0x000fca00078ec0ffULL, 0x000000015a4d7824ULL, 0x000fe200078e0235ULL,
0x0000000400109947ULL, 0x000fec0003800000ULL, 0x0000001034377812ULL, 0x000fe400078ec0ffULL,
0x0000003976347248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3a7819ULL, 0x000fc60000011609ULL,
0x0000000134347824ULL, 0x000fe400078e0a39ULL, 0x000000013a387824ULL, 0x000fe400078e0237ULL,
0x000000083a4c7836ULL, 0x000fe20000000000ULL, 0x0000003734367248ULL, 0x000fe20007fe0000ULL,
0x0000000138397824ULL, 0x040fe200078e0209ULL, 0x00009000ff347b82ULL, 0x000e620000000a00ULL,
0x00000008384e7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc400078e0a37ULL,
0x0000000c3a3b7836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee239ULL,
0x000000043a397836ULL, 0x000fe20000000000ULL, 0x000000363a00720cULL, 0x080fe20003f86070ULL,
0x000000013b647824ULL, 0x100fe200078e0237ULL, 0x000000364c00720cULL, 0x0c0fe20003f46070ULL,
0x00000001393a7824ULL, 0x140fe200078e0237ULL, 0x000000363900720cULL, 0x080fe20003f66070ULL,
0x0000001009397824ULL, 0x000fe200078e00ffULL, 0x000000363b00720cULL, 0x000fe20003f06070ULL,
0x000000014c4c7824ULL, 0x000fc400078e0237ULL, 0x000000013a367824ULL, 0x140fe200078e0209ULL,
0x00000070395d7812ULL, 0x000fe200078ec0ffULL, 0x000000083a3b7824ULL, 0x000fe400078e00ffULL,
0x000000014d387824ULL, 0x000fe400078e0238ULL, 0x000000014c377824ULL, 0x040fe200078e0209ULL,
0xfffffff83b5c7812ULL, 0x000fe200078ee236ULL, 0x000000084c5e7824ULL, 0x000fe200078e00ffULL,
0x00000034814f7211ULL, 0x002fe200078a38ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee237ULL, 0x000000014d367824ULL, 0x040fe200078e023aULL,
0x0000005d38347212ULL, 0x000fe200078efcffULL, 0x000000014d3a7824ULL, 0x000fe200078e024cULL,
0x0000003581677211ULL, 0x000fe200028f3cffULL, 0x000000014d4c7824ULL, 0x000fe200078e0264ULL,
0x000000344f347210ULL, 0x000fe20007fbe0ffULL, 0x00000001643b7824ULL, 0x040fe400078e0209ULL,
0x0000000864647824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005d36367212ULL, 0x000fc600078efcffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000005d3a387212ULL, 0x000fc600078efcffULL, 0x0000000139357824ULL, 0x100fe200028e0667ULL,
0x0000000861397c11ULL, 0x000fe4000f8e68ffULL, 0x0000004f36367210ULL, 0x000fe40007fbe0ffULL,
0x0000005d4c3a7212ULL, 0x000fe200078efcffULL, 0x0001700039397836ULL, 0x000fe40000000000ULL,
0x0000000137377824ULL, 0x000fe200028e0667ULL, 0x0000004f38387210ULL, 0x000fe20007fbe0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e0239ULL, 0x0000004f3a3a7210ULL, 0x000fe20007fde0ffULL,
0x000000104e4f7824ULL, 0x000fc400078e0239ULL, 0x000000105e5f7824ULL, 0x100fe400078e0239ULL,
0x0000001064657824ULL, 0x000fe200078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000e101c46ULL, 0x000000013b397824ULL, 0x100fe400028e0667ULL,
0x000000014d3b7824ULL, 0x000fe200030e0667ULL, 0x00000000365d7faeULL, 0x0003e8000d901c46ULL,
0x00000000385f7faeULL, 0x0003e8000d101c46ULL, 0x000000003a657faeULL, 0x0003e2000c101c46ULL,
0x0000000000dc7947ULL, 0x000fea0003800000ULL, 0x0000001034367812ULL, 0x000fe400078ec0ffULL,
0x00009000ff347b82ULL, 0x000e640000000a00ULL, 0x0000003609367211ULL, 0x000fca00078fe8ffULL,
0x0000000436387836ULL, 0x000fe40000000000ULL, 0x0000000136377824ULL, 0x140fe400078e0209ULL,
0x00000008364e7824ULL, 0x000fe400078e00ffULL, 0x0000000138397824ULL, 0x040fe400078e0209ULL,
0x00000008385c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee237ULL,
0x000000014d377824ULL, 0x000fc400078e0236ULL, 0x00000008363a7836ULL, 0x000fe20000000000ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee239ULL, 0x0000001009397824ULL, 0x000fe400078e00ffULL,
0x0000000c364c7836ULL, 0x000fe20000000000ULL, 0x00000034815d7211ULL, 0x002fe200078038ffULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x00000070394f7812ULL, 0x000fe400078ec0ffULL,
0x0000003581817211ULL, 0x000fe200000f3cffULL, 0x000000014d3b7824ULL, 0x000fe200078e023aULL,
0x0000004f36347212ULL, 0x000fe200078efcffULL, 0x000000013a397824ULL, 0x000fc400078e0209ULL,
0x000000083a5e7824ULL, 0x000fe200078e00ffULL, 0x000000345d347210ULL, 0x000fe20007f1e0ffULL,
0x000000014c3a7824ULL, 0x040fe400078e0209ULL, 0x000000084c5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee239ULL, 0x000000014d387824ULL, 0x040fe400078e0238ULL,
0x000000014d4d7824ULL, 0x000fe200078e024cULL, 0xfffffff85f647812ULL, 0x000fe200078ee23aULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x000000803b3a7825ULL, 0x000fe200078e00ffULL,
0x0000004f38367212ULL, 0x000fc600078efcffULL, 0x000000804d4c7825ULL, 0x000fe200078e00ffULL,
0x0000004f3a387212ULL, 0x000fc600078efcffULL, 0x0000000137357824ULL, 0x000fe200000e0681ULL,
0x0000000861377c11ULL, 0x000fe4000f8e68ffULL, 0x0000004f4c3a7212ULL, 0x000fe400078efcffULL,
0x000000365d367210ULL, 0x000fe20007f1e0ffULL, 0x0001700037377836ULL, 0x000fe20000000000ULL,
0x000000385d387210ULL, 0x000fe40007f5e0ffULL, 0x0000003a5d3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000104e4f7824ULL, 0x100fe200078e0237ULL, 0x000000375c5d7211ULL, 0x000fe200078e20ffULL,
0x000000105e5f7824ULL, 0x000fc400078e0237ULL, 0x0000001064657824ULL, 0x000fe200078e0237ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344f7faeULL, 0x0003e2000b901c46ULL,
0x0000000139377824ULL, 0x100fe400000e0681ULL, 0x000000013b397824ULL, 0x100fe400010e0681ULL,
0x000000014d3b7824ULL, 0x000fe200018e0681ULL, 0x00000000365d7faeULL, 0x0003e8000b901c46ULL,
0x00000000385f7faeULL, 0x0003e8000b901c46ULL, 0x000000003a657faeULL, 0x0003e4000b901c46ULL,
0x0000000159377836ULL, 0x002fe40000000000ULL, 0xffffffffff7c7424ULL, 0x000fc600078e00ffULL,
0x000000743700720cULL, 0x000fe20003f06070ULL, 0x00000008637a7824ULL, 0x000fca00078e00ffULL,
0xfffffff07a387812ULL, 0x000fca00078ec0ffULL, 0x00000008383a7c36ULL, 0x000fe40008000000ULL,
0x00009200ff348b82ULL, 0x000e620000000a00ULL, 0x0000000108378824ULL, 0x000fe200078e0237ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000003a0472caULL, 0x000fda00000e0000ULL,
0x0001a6b004047890ULL, 0x000fe2000fffe03fULL, 0x0000000437348825ULL, 0x002fd000078e0034ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x00000006347c8981ULL, 0x000322000c1e1900ULL,
0xffffffe07a367812ULL, 0x040fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x000000107a377812ULL, 0x000fc800078ec0ffULL, 0x0000000837367c10ULL, 0x000fe4000fffe036ULL,
0x000000087a377812ULL, 0x000fca00078ec0ffULL, 0x0000000136807824ULL, 0x000fe200078e0237ULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x01a6b0393a8679a7ULL, 0x0002a4000850003fULL,
0x01a60839803879a7ULL, 0x0022e4000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x01a60839800075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a60839800075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000010096d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011609ULL, 0x0000002063347824ULL, 0x000fe400078e00ffULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x000000706d6d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff837224ULL, 0x000fe200078e007eULL, 0xffffff8034347812ULL, 0x000fe400078ec0ffULL,
0x0000000c70707812ULL, 0x000fe400078ec0ffULL, 0x000000086d357c10ULL, 0x000fca000fffe034ULL,
0x0000000135357824ULL, 0x000fca00078e0270ULL, 0x01a0000035377984ULL, 0x000ee80000000800ULL,
0x01a2000035397984ULL, 0x000b620000000800ULL, 0x0000007e3700720bULL, 0x008fda0003f1d000ULL,
0x0000000000367806ULL, 0x000fc800000e0100ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x00000004008c8947ULL, 0x026fea0003800000ULL, 0x000000636000720cULL, 0x000fe40003f45270ULL,
0x0000007e3700720bULL, 0x0c0fe40003f14000ULL, 0x0000007e37837209ULL, 0x000fd20007810000ULL,
0x000000086334ac11ULL, 0x000fe4000f8e38ffULL, 0x0000000000357806ULL, 0x000fe400000e0100ULL,
0x000000347034a210ULL, 0x000fe40007ffe06dULL, 0x000000ff3500720cULL, 0x000fc60003f05270ULL,
0x01a400833400a388ULL, 0x0003f40000000800ULL, 0x0000000400508947ULL, 0x002fea0003800000ULL,
0x0000007e83347221ULL, 0x000fe20000010100ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL,
0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000035ff7812ULL, 0x000fe2000788c0ffULL,
0x00000034003b7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011609ULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003454547220ULL, 0x082fe20000410000ULL, 0x0000003455557220ULL, 0x080fe20000410000ULL,
0x000000343c3c7220ULL, 0x080fe20000410000ULL, 0x000000343d3d7220ULL, 0x080fe20000410000ULL,
0x0000003440407220ULL, 0x080fe20000410000ULL, 0x0000003441417220ULL, 0x080fe20000410000ULL,
0x0000003444447220ULL, 0x080fe20000410000ULL, 0x0000003445457220ULL, 0x080fe20000410000ULL,
0x0000003448487220ULL, 0x080fe20000410000ULL, 0x0000003449497220ULL, 0x080fe20000410000ULL,
0x0000003450507220ULL, 0x080fe20000410000ULL, 0x0000003451517220ULL, 0x080fe20000410000ULL,
0x0000003428287220ULL, 0x080fe20000410000ULL, 0x0000003429297220ULL, 0x080fe20000410000ULL,
0x0000003424247220ULL, 0x080fe20000410000ULL, 0x0000003425257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003456567220ULL, 0x082fe20000410000ULL,
0x0000003457577220ULL, 0x080fe20000410000ULL, 0x000000343e3e7220ULL, 0x080fe20000410000ULL,
0x000000343f3f7220ULL, 0x080fe20000410000ULL, 0x0000003442427220ULL, 0x080fe20000410000ULL,
0x0000003443437220ULL, 0x080fe20000410000ULL, 0x0000003446467220ULL, 0x080fe20000410000ULL,
0x0000003447477220ULL, 0x080fe20000410000ULL, 0x000000344a4a7220ULL, 0x080fe20000410000ULL,
0x000000344b4b7220ULL, 0x080fe20000410000ULL, 0x0000003452527220ULL, 0x080fe20000410000ULL,
0x0000003453537220ULL, 0x080fe20000410000ULL, 0x000000342a2a7220ULL, 0x080fe20000410000ULL,
0x000000342b2b7220ULL, 0x080fe20000410000ULL, 0x0000003426267220ULL, 0x080fe20000410000ULL,
0x0000003427277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x000000340c0c7220ULL, 0x082fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x000000341d1d7220ULL, 0x080fe20000410000ULL,
0x0000003420207220ULL, 0x080fe20000410000ULL, 0x0000003421217220ULL, 0x080fe20000410000ULL,
0x0000003430307220ULL, 0x080fe20000410000ULL, 0x0000003431317220ULL, 0x080fe20000410000ULL,
0x000000342c2c7220ULL, 0x080fe20000410000ULL, 0x000000342d2d7220ULL, 0x000fce0000410000ULL,
0x0000003b82827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x000e6400000e0000ULL,
0x000000340e0e7220ULL, 0x082fe20000410000ULL, 0x000000340f0f7220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x0000003413137220ULL, 0x080fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x000000341a1a7220ULL, 0x080fe20000410000ULL, 0x000000341b1b7220ULL, 0x080fe20000410000ULL,
0x000000341e1e7220ULL, 0x080fe20000410000ULL, 0x000000341f1f7220ULL, 0x080fe20000410000ULL,
0x0000003422227220ULL, 0x080fe20000410000ULL, 0x0000003423237220ULL, 0x080fe20000410000ULL,
0x0000003432327220ULL, 0x080fe20000410000ULL, 0x0000003433337220ULL, 0x080fe20000410000ULL,
0x000000342e2e7220ULL, 0x080fe20000410000ULL, 0x000000342f2f7220ULL, 0x000fce0000410000ULL,
0x0000003536ff7212ULL, 0x000fda00078030ffULL, 0x8000008337370221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL,
0x0000003700040308ULL, 0x000ea40000000800ULL, 0x0000000439390220ULL, 0x004fce0000410000ULL,
0x0000008239827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x01a6a8793a0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3b7224ULL, 0x000fce00078e00ffULL, 0x000000103b00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003936367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013b3b7836ULL, 0x000fce0000000000ULL, 0x01a6a8793a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000040063347824ULL, 0x000fe200078e00ffULL,
0x0000991038357816ULL, 0x000fe200000000ffULL, 0x00000008ff797e24ULL, 0x000fe2000f8e00ffULL,
0x00000008096c7812ULL, 0x000fe200078ec0ffULL, 0x0000000263817824ULL, 0x000fe200078e00ffULL,
0xfffff00034347812ULL, 0x000fe200078ec0ffULL, 0x00000008ff377e24ULL, 0x000fe2000f8e00ffULL,
0x000000ff3500720cULL, 0x000fe20003f05270ULL, 0x0000100063357824ULL, 0x000fe200078e00ffULL,
0x0001200079797810ULL, 0x000fe20007ffe034ULL, 0x0000000463347824ULL, 0x000fe200078e00ffULL,
0x0000000481727812ULL, 0x000fc400078ec0ffULL, 0x000000076c6c7812ULL, 0x000fe400078ef809ULL,
0xffffe00035367812ULL, 0x000fe400078ec0ffULL, 0x0000007209357211ULL, 0x000fe200078fe0ffULL,
0x000000086c6f7824ULL, 0x040fe200078e00ffULL, 0x000000106c787812ULL, 0x000fe400078efcffULL,
0x0000000434347812ULL, 0x000fe200078ec0ffULL, 0x000000016c7f7824ULL, 0x040fe200078e0235ULL,
0x00016000374e7810ULL, 0x000fe20007ffe036ULL, 0x00000001357e7824ULL, 0x000fe200078e0278ULL,
0x00000034097d7211ULL, 0x000fe200078fe0ffULL, 0x000000086c347824ULL, 0x000fc400078e00ffULL,
0x0000000878357824ULL, 0x000fe400078e00ffULL, 0x000000016c4c7824ULL, 0x000fe200078e027dULL,
0xfffffff8347f7812ULL, 0x000fe400078ee27fULL, 0xfffffff8357e7812ULL, 0x000fe400078ee27eULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee24cULL, 0x000000107f367824ULL, 0x100fe400078e0279ULL,
0x000000107e387824ULL, 0x000fe200078e0279ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000347816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f0534057589ULL, 0x0002a800000e0000ULL, 0x00001f3534027589ULL, 0x0002e800000e0000ULL,
0x00001f0334037589ULL, 0x00026800000e0000ULL, 0x00001f3734007589ULL, 0x00026400000e0000ULL,
0x000000003634783bULL, 0x002e620000000200ULL, 0x000000106f5c7824ULL, 0x000fc600078e024eULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x088fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x0000000538387232ULL, 0x084fe40000000000ULL, 0x000000053a3a7232ULL, 0x000fc40000000000ULL,
0x0000000039397232ULL, 0x080fe40000000000ULL, 0x000000003b3b7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000086c647824ULL, 0x000fe200078e00ffULL,
0x0000000272727812ULL, 0x000fe200078efcffULL, 0x000000024c7b7836ULL, 0x000fca0000000000ULL,
0xfffffff8647b7812ULL, 0x000fca00078ee27bULL, 0x000000107b4e7824ULL, 0x000fcc00078e024eULL,
0x000000004e4c783bULL, 0x000f640000004200ULL, 0x00000018ff8a7819ULL, 0x028fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d937816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001145fULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc40000011464ULL,
0x000088805c737816ULL, 0x040fe400000000ffULL, 0x00000018ff917819ULL, 0x000fe2000001145dULL,
0x0000006400947306ULL, 0x0007e20000200c00ULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x004fe2000001144cULL, 0x000001004d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145eULL, 0x0000006500967306ULL, 0x0005e20000200c00ULL,
0x000001005f647824ULL, 0x048fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe2000001145cULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fc40000011464ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x000001004c657824ULL, 0x044fe200078e00ffULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x0000005f008e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff8c7819ULL, 0x000fe40000011468ULL,
0x00000018ff897819ULL, 0x000fe40000011465ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff677819ULL, 0x000fe2000001144dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000001004e5f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc4000001144eULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000009500957306ULL, 0x000ea20000200c00ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x000088804f697816ULL, 0x000fe200000000ffULL, 0x0000004c00857306ULL, 0x0007e20000200c00ULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000005f00717306ULL, 0x000be20000200c00ULL, 0x000001004f4c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x000100004f5f7824ULL, 0x022fe200078e00ffULL, 0x00005410954f7816ULL, 0x004fc8000000008aULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000004c00847306ULL, 0x0003f00000200c00ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x00005410734c7816ULL, 0x002fce0000000094ULL,
0x0000008b008b7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541085667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000ff00000200c00ULL, 0x0000006b006b7306ULL, 0x000ff00000200c00ULL,
0x0000009300937306ULL, 0x000ff00000200c00ULL, 0x0000009200927306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000009000907306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105d5d7816ULL, 0x002fce0000000090ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008dULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x0000005c3814723cULL, 0x000fee0000001814ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x002fce0000000089ULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000004d00887306ULL, 0x0004e20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x00005410934d7816ULL, 0x004fe20000000096ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0000541088677816ULL, 0x008fca0000000067ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000004c3454723cULL, 0x000fe20000001854ULL, 0x0000541068687816ULL, 0x002fcc0000000071ULL,
0x0000004e00737306ULL, 0x0002e20000200c00ULL, 0x000000663450723cULL, 0x000fe20000001850ULL,
0x0000541069697816ULL, 0x004fcc0000000084ULL, 0x0000005f008a7306ULL, 0x0005620000200c00ULL,
0x00005410924e7816ULL, 0x002fe2000000008fULL, 0x0000004c380c723cULL, 0x000fe2000000180cULL,
0x00005410736a7816ULL, 0x008fca000000006aULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x000054108e5f7816ULL, 0x004fe2000000008bULL, 0x00000001784c7824ULL, 0x040fe200078e027dULL,
0x0000000861737c11ULL, 0x000fe2000f8e68ffULL, 0x00000008787d7824ULL, 0x000fe400078e00ffULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x000054108a6b7816ULL, 0x020fe2000000006bULL,
0x0001600073847836ULL, 0x000fe20000000000ULL, 0xfffffff87d7d7812ULL, 0x000fc600078ee24cULL,
0x0000005e3444723cULL, 0x000fe40000001844ULL, 0x000000107d5c7824ULL, 0x000fc800078e0284ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e3810723cULL, 0x000fe20000001810ULL,
0x0000007209357211ULL, 0x000fe200078fe0ffULL, 0x000000086c347824ULL, 0x000fe400078e00ffULL,
0x0000000878377824ULL, 0x000fc400078e00ffULL, 0x000000016c717824ULL, 0x100fe200078e0235ULL,
0x0000005e3818723cULL, 0x000fe20000001818ULL, 0x0000000178727824ULL, 0x000fc600078e0235ULL,
0xfffffff834717812ULL, 0x000fe400078ee271ULL, 0xfffffff837727812ULL, 0x000fe200078ee272ULL,
0x00000064381c723cULL, 0x000fe4000000181cULL, 0x0000001071347824ULL, 0x100fe400078e0279ULL,
0x0000001072797824ULL, 0x000fe400078e0279ULL, 0x000000663820723cULL, 0x000fe40000001820ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000683830723cULL, 0x000fec0000001830ULL,
0x0000006a3838723cULL, 0x000fe2000000182cULL, 0x00000000792c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000008784e7824ULL, 0x000fe200078e00ffULL,
0xfffffff881817812ULL, 0x000fe200078ec0ffULL, 0x000000024c797836ULL, 0x004fca0000000000ULL,
0xfffffff84e797812ULL, 0x000fca00078ee279ULL, 0x00000010794c7824ULL, 0x000fcc00078e0284ULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x000001005c647824ULL, 0x020fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d957816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff937819ULL, 0x000fc4000001145cULL,
0x000088805c897816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe2000001145eULL, 0x0000006400967306ULL, 0x000be20000200c00ULL,
0x00000018ff947819ULL, 0x000fe4000001145cULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004c697824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001144dULL,
0x000001004d857824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x0000006500987306ULL, 0x0005e20000200c00ULL, 0x000001005f647824ULL, 0x028fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc40000011469ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x00000018ff687819ULL, 0x000fe20000011464ULL, 0x000100005e647824ULL, 0x000fe200078e00ffULL,
0x0000009500957306ULL, 0x000ee20000200c00ULL, 0x000088804e997816ULL, 0x000fe400000000ffULL,
0x00000018ff917819ULL, 0x000fe4000001145dULL, 0x00000018ff657819ULL, 0x004fe20000011464ULL,
0x000100005f647824ULL, 0x040fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001144fULL,
0x00000068005e7306ULL, 0x0005e20000200c00ULL, 0x000088805f5d7816ULL, 0x000fc400000000ffULL,
0x00000018ff927819ULL, 0x000fe40000011464ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145fULL,
0x0000009700977306ULL, 0x000f620000200c00ULL, 0x000088804d687816ULL, 0x044fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008900897306ULL, 0x000ff00000200c00ULL, 0x00000069008d7306ULL, 0x0005f00000200c00ULL,
0x0000004d008a7306ULL, 0x0007e20000200c00ULL, 0x000001004e697824ULL, 0x004fc400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011469ULL,
0x0000004c008b7306ULL, 0x0005e20000200c00ULL, 0x00005410954d7816ULL, 0x008fe20000000098ULL,
0x000100004f957824ULL, 0x040fe200078e00ffULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00005410974f7816ULL, 0x022fe4000000008cULL,
0x00000018ff8c7819ULL, 0x000fe40000011495ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000065005f7306ULL, 0x000fe20000200c00ULL, 0x000054105d5d7816ULL, 0x008fce000000005eULL,
0x0000004c00887306ULL, 0x0003f00000200c00ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x00005410894c7816ULL, 0x002fce0000000096ULL, 0x0000006800657306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fe20000001854ULL, 0x000054105f5e7816ULL, 0x004fcc0000000090ULL,
0x00000085008e7306ULL, 0x000e620000200c00ULL, 0x0000004c2c0c723cULL, 0x000fee000000180cULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008eULL,
0x0000008f008f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054108b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054108a677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fee0000001850ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410925f7816ULL, 0x004fcc000000008fULL, 0x0000009900687306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000009a00857306ULL, 0x000e620000200c00ULL, 0x0000005e3444723cULL, 0x000fee0000001844ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0000541068687816ULL, 0x002fcc0000000085ULL, 0x0000004e00897306ULL, 0x0002e20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541069697816ULL, 0x004fcc0000000088ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x00005410944e7816ULL, 0x002fe20000000093ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x00005410896a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fec000000183cULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x000054108c6b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000001810ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x0000000861347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff367424ULL, 0x000fc800078e00ffULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x01a6c836343479a7ULL, 0x0002a2000850003fULL,
0x01a6883681ff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000010632c7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c4e7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02c2e7812ULL, 0x000fe400078ec0ffULL,
0x000000404e4e7824ULL, 0x000fc600078e00ffULL, 0x00000100072e7824ULL, 0x000fc800078e022eULL,
0x000000802e2f7836ULL, 0x000fca0000000000ULL, 0x000000202f2d7812ULL, 0x000fca00078ec0ffULL,
0x000000015a2d7824ULL, 0x000fe200078e022dULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x000000102c377812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2e7819ULL, 0x000fe40000011609ULL,
0x0000002f762c7248ULL, 0x000fc60007fe0000ULL, 0x000000012e367824ULL, 0x002fe400078e0237ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x00000001362f7824ULL, 0x040fe200078e0209ULL,
0x0000000336347819ULL, 0x000fe200000006ffULL, 0x000000042e4c7836ULL, 0x000fe20000000000ULL,
0x0000002c372c7248ULL, 0x000fe20007fe0000ULL, 0x0000000c2e4d7836ULL, 0x000fe20000000000ULL,
0xfffffff8345d7812ULL, 0x000fe200078ee22fULL, 0x000000082e2f7836ULL, 0x000fe20000000000ULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x000000012c2c7824ULL, 0x000fc400078e0a37ULL,
0x000000012f5c7824ULL, 0x100fe400078e0237ULL, 0x000000014d5e7824ULL, 0x100fe200078e0237ULL,
0x0000002c4c00720cULL, 0x0c0fe20003f66070ULL, 0x000000014c4c7824ULL, 0x000fe200078e0237ULL,
0x0000002c2e00720cULL, 0x080fe20003f86070ULL, 0x0000000136367824ULL, 0x000fe200078e022dULL,
0x0000002c2f00720cULL, 0x080fe20003f46070ULL, 0x000000014c2e7824ULL, 0x040fe200078e0209ULL,
0x0000002c4d00720cULL, 0x000fe20003f06070ULL, 0x000000084c5f7824ULL, 0x000fc400078e00ffULL,
0x000000014c4c7824ULL, 0x100fe400078e022dULL, 0x000000015e2c7824ULL, 0x100fe200078e022dULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22eULL, 0x000000015c2e7824ULL, 0x000fe400078e022dULL,
0x000000015e2f7824ULL, 0x100fe400078e0209ULL, 0x000000015c2d7824ULL, 0x000fe200078e0209ULL,
0x000000344e4f7211ULL, 0x002fe200078a38ffULL, 0x000000085e5e7824ULL, 0x000fc400078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000354e657211ULL, 0x000fe400028f3cffULL,
0xfffffff85e697812ULL, 0x000fe200078ee22fULL, 0x000000085c5c7824ULL, 0x000fe200078e00ffULL,
0x0000006d36347212ULL, 0x000fe200078efcffULL, 0x000000804c4c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85c677812ULL, 0x000fe200078ee22dULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d4c367212ULL, 0x080fe400078efcffULL, 0x000000344f347210ULL, 0x000fe20007fbe0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000004f36367210ULL, 0x000fe40007fde0ffULL,
0x0000006d2e2e7212ULL, 0x080fe200078efcffULL, 0x0000000137357824ULL, 0x100fe200028e0665ULL,
0x0000006d2c2c7212ULL, 0x000fe200078efcffULL, 0x000000014d377824ULL, 0x000fe200030e0665ULL,
0x0000004f2e2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000105d4d7824ULL, 0x100fe200078e0284ULL,
0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x000000105f4f7824ULL, 0x000fc400078e0284ULL,
0x00000010675d7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344d7faeULL, 0x0003e2000e101c46ULL, 0x000000012f2f7824ULL, 0x100fe400028e0665ULL,
0x00000010695f7824ULL, 0x000fe200078e0284ULL, 0x00000000364f7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e0665ULL, 0x000000002e5d7faeULL, 0x0003e8000d101c46ULL,
0x000000002c5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x00009000ff367b82ULL, 0x002e620000000a00ULL, 0x000000102c2c7812ULL, 0x000fc800078ec0ffULL,
0x0000002c092c7211ULL, 0x000fca00078fe8ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0209ULL,
0x000000082c4f7824ULL, 0x040fe400078e00ffULL, 0x0000000c2c647836ULL, 0x000fe40000000000ULL,
0x000000042c5c7836ULL, 0x000fe20000000000ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee22eULL,
0x000000012c4c7824ULL, 0x000fe400078e022dULL, 0x000000082c5e7836ULL, 0x000fc40000000000ULL,
0x00000001642c7824ULL, 0x040fe400078e022dULL, 0x0000000164357824ULL, 0x000fe200078e0209ULL,
0x000000364e5d7211ULL, 0x002fe200078038ffULL, 0x000000015c347824ULL, 0x040fe400078e022dULL,
0x000000015c2f7824ULL, 0x000fe200078e0209ULL, 0x000000374e657211ULL, 0x000fe200000f3cffULL,
0x000000015e2e7824ULL, 0x000fe400078e022dULL, 0x0000000864647824ULL, 0x000fc400078e00ffULL,
0x000000804c4c7825ULL, 0x000fc600078e00ffULL, 0xfffffff864697812ULL, 0x000fe200078ee235ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000006d4c367212ULL, 0x080fe200078efcffULL,
0x000000015e2d7824ULL, 0x040fe400078e0209ULL, 0x000000085e5e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5f7812ULL, 0x000fe200078ee22fULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000365d367210ULL, 0x000fe40007f1e0ffULL, 0xfffffff85e677812ULL, 0x000fe200078ee22dULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d34347212ULL, 0x000fc600078efcffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000006d2e2e7212ULL, 0x000fc600078efcffULL,
0x000000014d377824ULL, 0x100fe200000e0665ULL, 0x0000006d2c2c7212ULL, 0x000fe200078efcffULL,
0x000000104f4d7824ULL, 0x100fe200078e0284ULL, 0x000000345d347210ULL, 0x000fe20007f1e0ffULL,
0x000000105f4f7824ULL, 0x100fe200078e0284ULL, 0x0000002e5d2e7210ULL, 0x000fe20007f5e0ffULL,
0x00000010695f7824ULL, 0x100fe200078e0284ULL, 0x0000002c5d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000135357824ULL, 0x000fe200000e0665ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364d7faeULL, 0x0003e2000b901c46ULL, 0x00000010675d7824ULL, 0x000fc400078e0284ULL,
0x000000012f2f7824ULL, 0x100fe200010e0665ULL, 0x00000000344f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fc600018e0665ULL, 0x000000002e5d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c5f7faeULL, 0x0003e4000b901c46ULL, 0x00000002592f7836ULL, 0x002fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000742f00720cULL, 0x000fe40003f06070ULL,
0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL, 0x000000087a887c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00009200ff2c8b82ULL, 0x000e620000000a00ULL,
0x00000000880472caULL, 0x000fe200000e0000ULL, 0x00000001082f8824ULL, 0x000fd800078e022fULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000042f2c8825ULL, 0x002fca00078e002cULL, 0x000000062c818981ULL, 0x000322000c1e1900ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x01a6a82f888879a7ULL, 0x0004e4000850003fULL, 0x01a6282f802e79a7ULL, 0x004464000850003fULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x01a6282f800075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342c377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6282f800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020632c7824ULL, 0x000fe400078e00ffULL, 0x00000008ff2d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x000000802d2c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x000b620000000800ULL,
0x000000832e00720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x02cfea0003800000ULL,
0x00000001602c7836ULL, 0x000fe20000000000ULL, 0x000000832e00720bULL, 0x000fc80003f14000ULL,
0x000000632c00720cULL, 0x000fda0003f45270ULL, 0x000000086334ac11ULL, 0x000fe4000f8e38ffULL,
0x000000832e2ca209ULL, 0x000fe40007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000832e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000832c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000832e837209ULL, 0x000fd60007810000ULL,
0x800000832e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000822d827221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL, 0x01a6b0872f0075a7ULL, 0x000e620008000148ULL,
0x000000082f377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400632d7824ULL, 0x040fe400078e00ffULL, 0x00001000632e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x00000008ff7c7e24ULL, 0x000fe2000f8e00ffULL,
0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000008ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL, 0x000130007c7c7810ULL, 0x000fc40007ffe02dULL,
0x000170002f4c7810ULL, 0x000fc60007ffe02eULL, 0x000000107f347824ULL, 0x100fe400078e027cULL,
0x000000107e2c7824ULL, 0x000fe400078e027cULL, 0x000000106f5c7824ULL, 0x000fe200078e024cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4e7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4e2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000107b4c7824ULL, 0x000fcc00078e024cULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x000001005c647824ULL, 0x028fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d927816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004d697824ULL, 0x004fe200078e00ffULL, 0x0000006400947306ULL, 0x0005e20000200c00ULL,
0x00000018ff907819ULL, 0x000fe2000001145cULL, 0x000001004c687824ULL, 0x000fe200078e00ffULL,
0x000088805c877816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001145eULL, 0x0000006500977306ULL, 0x0007e20000200c00ULL,
0x000001005f647824ULL, 0x004fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc4000001145cULL,
0x000088805e5c7816ULL, 0x040fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe4000001144dULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x00000018ff657819ULL, 0x008fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff8f7819ULL, 0x000fe20000011464ULL,
0x00000065005e7306ULL, 0x0007e20000200c00ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fc4000001145dULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000088804d657816ULL, 0x048fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001145fULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000009500957306ULL, 0x000ee20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x000088804e857816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000008700877306ULL, 0x000ff00000200c00ULL, 0x0000004d00847306ULL, 0x0005f00000200c00ULL,
0x00000068008d7306ULL, 0x000be20000200c00ULL, 0x00005410924d7816ULL, 0x004fe20000000097ULL,
0x000100004f927824ULL, 0x000fcc00078e00ffULL, 0x0000004c008b7306ULL, 0x0005e20000200c00ULL,
0x000001004e687824ULL, 0x062fe400078e00ffULL, 0x000100004e4e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000069008a7306ULL, 0x0003e20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc8000001144eULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x000088804f697816ULL, 0x002fe400000000ffULL, 0x00005410954f7816ULL, 0x008fe40000000086ULL,
0x00000018ff867819ULL, 0x000fc60000011492ULL, 0x0000004c007a7306ULL, 0x0003e20000200c00ULL,
0x000054105d5d7816ULL, 0x004fce000000005eULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00005410874c7816ULL, 0x002fce0000000094ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x000fec0000001854ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x0000008c008c7306ULL, 0x000fec0000200c00ULL, 0x00000010724c7824ULL, 0x000fc400078e027cULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541084677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000008f008f7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054108f5e7816ULL, 0x004fcc000000008eULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008cULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x0000541064647816ULL, 0x004fcc000000008dULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x0000541065657816ULL, 0x002fcc000000008aULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541085687816ULL, 0x002fcc0000000068ULL,
0x0000004e00877306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce000000007aULL,
0x0000008600867306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe20000000090ULL,
0x00017000737a7836ULL, 0x000fe20000000000ULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x00005410876a7816ULL, 0x008fca000000006aULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00005410866b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000001810ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x0000001071347824ULL, 0x000fc400078e027cULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000004c2c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007c5c783bULL, 0x000f620000004200ULL,
0x00000010794c7824ULL, 0x004fcc00078e027aULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000001005c647824ULL, 0x020fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000001004d687824ULL, 0x004fe200078e00ffULL,
0x0000006400967306ULL, 0x0005e20000200c00ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x000000085e5d7819ULL, 0x000fc400000006ffULL,
0x00000018ff667819ULL, 0x000fe4000001144cULL, 0x00000018ff917819ULL, 0x000fe2000001145dULL,
0x0000006500977306ULL, 0x000be20000200c00ULL, 0x000001005f647824ULL, 0x044fe200078e00ffULL,
0x000088805c877816ULL, 0x000fe400000000ffULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011464ULL, 0x0000009400947306ULL, 0x000fe20000200c00ULL,
0x000001004c657824ULL, 0x068fe200078e00ffULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc4000001144dULL,
0x00000018ff8d7819ULL, 0x000fe40000011465ULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe2000001145cULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff937819ULL, 0x000fc4000001145cULL, 0x00000018ff8f7819ULL, 0x000fe2000001145eULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff8e7819ULL, 0x000fe2000001145fULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011468ULL,
0x00000018ff6a7819ULL, 0x000fe2000001144eULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc40000011469ULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000004c008b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x000054105d5d7816ULL, 0x004fe2000000008aULL,
0x0000004d00867306ULL, 0x0005e20000200c00ULL, 0x000001004f4c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009200927306ULL, 0x000fe20000200c00ULL,
0x00005410944d7816ULL, 0x004fe20000000097ULL, 0x000100004f947824ULL, 0x000fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000004c00847306ULL, 0x0005f00000200c00ULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x00005410874c7816ULL, 0x004fce0000000096ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000004c3454723cULL, 0x002fec0000001854ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x0000008e008e7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541086677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009500957306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410954f7816ULL, 0x002fce0000000090ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008fULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008eULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fee0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc0000000085ULL,
0x0000004e00877306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce0000000084ULL,
0x00000094008a7306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe20000000092ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410876a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x000054108a6b7816ULL, 0x004fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x0000000263357824ULL, 0x000fe200078e00ffULL,
0x0000000861347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ec0ffULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x01a6c837343479a7ULL, 0x0002a4000850003fULL, 0x01a6903736ff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010632c7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x00000004814e7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe02c2e7812ULL, 0x000fe400078ec0ffULL, 0x000000404e4e7824ULL, 0x000fc600078e00ffULL,
0x00000100072e7824ULL, 0x000fc800078e022eULL, 0x000000c02e2f7836ULL, 0x000fca0000000000ULL,
0x000000202f2d7812ULL, 0x000fca00078ec0ffULL, 0x000000015a377824ULL, 0x002fe200078e022dULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x000000102c357812ULL, 0x000fe400078ec0ffULL,
0x0000002f762c7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff347819ULL, 0x000fc60000011609ULL,
0x000000012c2e7824ULL, 0x000fe400078e0a2fULL, 0x00009000ff2c7b82ULL, 0x000e620000000a00ULL,
0x0000000134367824ULL, 0x000fe400078e0235ULL, 0x0000002e352e7248ULL, 0x000fe20007fe0000ULL,
0x00000008344d7836ULL, 0x000fe40000000000ULL, 0x00000001362f7824ULL, 0x040fe400078e0209ULL,
0x00000008364c7824ULL, 0x000fc400078e00ffULL, 0x000000012e2e7824ULL, 0x000fe400078e0a35ULL,
0x0000000c344f7836ULL, 0x000fe20000000000ULL, 0xfffffff84c5f7812ULL, 0x000fe200078ee22fULL,
0x00000004344c7836ULL, 0x000fe20000000000ULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x00000001362f7824ULL, 0x000fe200078e0237ULL, 0x0000002e4d00720cULL, 0x0c0fe20003f46070ULL,
0x000000014c347824ULL, 0x140fe200078e0235ULL, 0x0000002e4c00720cULL, 0x080fe20003f66070ULL,
0x000000014d367824ULL, 0x100fe200078e0235ULL, 0x0000002e4f00720cULL, 0x040fe20003f06070ULL,
0x000000014f5c7824ULL, 0x000fc400078e0235ULL, 0x0000000134357824ULL, 0x100fe200078e0209ULL,
0x0000002c4e4f7211ULL, 0x002fe200078a38ffULL, 0x00000008345e7824ULL, 0x000fe400078e00ffULL,
0x000000802f2e7825ULL, 0x000fe200078e00ffULL, 0x0000002d4e5d7211ULL, 0x000fe400028f3cffULL,
0xfffffff85e657812ULL, 0x000fe200078ee235ULL, 0x00000001364c7824ULL, 0x000fe200078e0209ULL,
0x0000006d2e2c7212ULL, 0x000fe200078efcffULL, 0x0000000836677824ULL, 0x000fc400078e00ffULL,
0x0000000134347824ULL, 0x100fe200078e0237ULL, 0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000136367824ULL, 0x000fe200078e0237ULL, 0xfffffff867677812ULL, 0x000fe200078ee24cULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000015c4c7824ULL, 0x000fe200078e0237ULL,
0x0000006d342e7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36347212ULL, 0x000fc600078efcffULL,
0x000000012f2d7824ULL, 0x000fe200028e065dULL, 0x0000004f2e2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000015c4e7824ULL, 0x000fe200078e0209ULL, 0x0000006d4c367212ULL, 0x000fe200078efcffULL,
0x000000085c697824ULL, 0x000fe400078e00ffULL, 0x00000001352f7824ULL, 0x100fe200028e065dULL,
0x0000004f34347210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004f36367210ULL, 0x000fe20007fde0ffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0xfffffff8694f7812ULL, 0x000fe200078ee24eULL, 0x0000000137357824ULL, 0x000fe200028e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c5f7faeULL, 0x0003e2000e101c46ULL,
0x0000001067677824ULL, 0x000fc400078e027aULL, 0x000000014d377824ULL, 0x000fe200030e065dULL,
0x000000002e657faeULL, 0x0003e2000d901c46ULL, 0x000000104f4f7824ULL, 0x000fc600078e027aULL,
0x0000000034677faeULL, 0x0003e8000d101c46ULL, 0x00000000364f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x00009000ff347b82ULL, 0x000e620000000a00ULL,
0x000000102c2c7812ULL, 0x000fc800078ec0ffULL, 0x0000002c092c7211ULL, 0x000fca00078fe8ffULL,
0x000000012c2d7824ULL, 0x040fe400078e0209ULL, 0x000000082c367824ULL, 0x040fe400078e00ffULL,
0x000000042c2e7836ULL, 0x000fe40000000000ULL, 0x0000000c2c5e7836ULL, 0x000fe20000000000ULL,
0xfffffff8364f7812ULL, 0x000fe200078ee22dULL, 0x000000082c5c7836ULL, 0x000fe40000000000ULL,
0x000000012c367824ULL, 0x000fc400078e0237ULL, 0x000000012e4c7824ULL, 0x040fe400078e0237ULL,
0x000000012e2d7824ULL, 0x000fe200078e0209ULL, 0x000000344e5d7211ULL, 0x002fe200078038ffULL,
0x000000082e647824ULL, 0x000fe400078e00ffULL, 0x000000015e2c7824ULL, 0x000fe200078e0237ULL,
0x000000354e5f7211ULL, 0x000fe200000f3cffULL, 0x000000015e4d7824ULL, 0x000fe200078e0209ULL,
0xfffffff864657812ULL, 0x000fe200078ee22dULL, 0x000000015c2e7824ULL, 0x000fc400078e0237ULL,
0x000000015c2f7824ULL, 0x000fe400078e0209ULL, 0x000000085e5e7824ULL, 0x000fe400078e00ffULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff85e697812ULL, 0x000fe400078ee24dULL, 0xfffffff85c677812ULL, 0x000fe200078ee22fULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36347212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000345d347210ULL, 0x000fe40007f1e0ffULL,
0x0000006d4c367212ULL, 0x080fe200078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000006d2e2e7212ULL, 0x080fe400078efcffULL, 0x000000365d367210ULL, 0x000fe20007f5e0ffULL,
0x0000000137357824ULL, 0x100fe200000e065fULL, 0x0000006d2c2c7212ULL, 0x000fe200078efcffULL,
0x000000104f4f7824ULL, 0x100fe200078e027aULL, 0x0000002e5d2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014d377824ULL, 0x100fe200010e065fULL, 0x0000002c5d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001065657824ULL, 0x000fe200078e027aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000b901c46ULL, 0x000000012f2f7824ULL, 0x000fc400000e065fULL,
0x0000001067677824ULL, 0x100fe200078e027aULL, 0x0000000036657faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fe400018e065fULL, 0x0000001069697824ULL, 0x000fe200078e027aULL,
0x000000002e677faeULL, 0x0003e8000b901c46ULL, 0x000000002c697faeULL, 0x0003e4000b901c46ULL,
0x00000003592f7836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000742f00720cULL, 0x000fe20003f06070ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL, 0x000000082e847c36ULL, 0x000fe40008000000ULL,
0x00009200ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000001082f8824ULL, 0x000fe200078e022fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000840472caULL, 0x000fda00000e0000ULL,
0x0001a6b004047890ULL, 0x000fe2000fffe03fULL, 0x000000042f2c8825ULL, 0x002fd000078e002cULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x000000062c818981ULL, 0x000322000c1e1900ULL,
0x00000001ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x01a6b02f848479a7ULL, 0x0004e2000850003fULL, 0x01a6482f802c79a7ULL, 0x002464000850003fULL,
0x00000000002e7805ULL, 0x004fce0000015200ULL, 0x01a6482d800075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6482d800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020632c7824ULL, 0x000fe400078e00ffULL, 0x00000008ff2d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL,
0x000001002d2c7810ULL, 0x000fc80007ffe02cULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x0004a20000000800ULL,
0x000000832e00720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x00cfea0003800000ULL,
0x00000002602c7836ULL, 0x000fe20000000000ULL, 0x000000832e00720bULL, 0x000fc80003f14000ULL,
0x000000632c00720cULL, 0x000fda0003f45270ULL, 0x000000086334ac11ULL, 0x000fe4000f8e38ffULL,
0x000000832e2ca209ULL, 0x000fe40007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000832e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000832c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000832e837209ULL, 0x000fd60007810000ULL,
0x800000832e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000822d827221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x00000008632e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL, 0x01a6a8892f0075a7ULL, 0x000e620008000148ULL,
0x000000082f377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6a889370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400632d7824ULL, 0x040fe400078e00ffULL, 0x00001000632e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x00000008ff807e24ULL, 0x000fe2000f8e00ffULL,
0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000008ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL, 0x0001400080807810ULL, 0x000fc40007ffe02dULL,
0x000160002f4e7810ULL, 0x000fc60007ffe02eULL, 0x000000107f347824ULL, 0x100fe400078e0280ULL,
0x000000107e2c7824ULL, 0x000fe400078e0280ULL, 0x000000106f5c7824ULL, 0x000fe200078e024eULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fe400000000ffULL, 0x000000182e4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fc80000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4c2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000107b4e7824ULL, 0x000fcc00078e024eULL,
0x000000004e4c783bULL, 0x000f640000004200ULL, 0x000001005d657824ULL, 0x068fe200078e00ffULL,
0x000088805c867816ULL, 0x040fe200000000ffULL, 0x000001005c647824ULL, 0x000fe200078e00ffULL,
0x000088805d907816ULL, 0x000fe400000000ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x00000018ff677819ULL, 0x004fe2000001144dULL, 0x000001004d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001144cULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145cULL, 0x0000006500957306ULL, 0x0005e20000200c00ULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001145eULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fc4000001145fULL, 0x00000018ff8e7819ULL, 0x000fe2000001145cULL,
0x0000006400917306ULL, 0x0007620000200c00ULL, 0x000001004c657824ULL, 0x004fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001145dULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011465ULL,
0x000088804d657816ULL, 0x000fe200000000ffULL, 0x000001005f647824ULL, 0x008fe200078e00ffULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011464ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff887819ULL, 0x000fe40000011468ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x0000004d007e7306ULL, 0x0007e20000200c00ULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000004c00877306ULL, 0x000be20000200c00ULL, 0x000001004f4d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x00005410864c7816ULL, 0x022fe40000000091ULL, 0x00000018ff867819ULL, 0x000fe4000001144dULL,
0x00005410904d7816ULL, 0x004fe20000000095ULL, 0x000100004f907824ULL, 0x000fe400078e00ffULL,
0x0000008b008b7306ULL, 0x000fe60000200c00ULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0000004c3454723cULL, 0x000fe80000001854ULL, 0x0000008a008a7306ULL, 0x000fe40000200c00ULL,
0x0000004c2c0c723cULL, 0x000fec000000180cULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000541087667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054107e677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00016000737e7836ULL, 0x000fe20000000000ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009300937306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410934f7816ULL, 0x002fce000000008cULL,
0x0000008f008f7306ULL, 0x000e700000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce000000008fULL, 0x0000009200927306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105d5d7816ULL, 0x002fce0000000092ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008bULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008aULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x000000107d5c7824ULL, 0x000fe200078e027eULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc0000000089ULL,
0x0000008800887306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce0000000088ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000004e007b7306ULL, 0x0004e20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc000000007fULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054108e4e7816ULL, 0x004fe4000000008dULL,
0x000054107b6a7816ULL, 0x008fca000000006aULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x0000004e343c723cULL, 0x000fec000000183cULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x0000541069697816ULL, 0x002fce0000000086ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410906b7816ULL, 0x004fca000000006bULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x0000001071347824ULL, 0x000fc400078e0280ULL,
0x0000001072807824ULL, 0x000fc800078e0280ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x00000000802c783bULL, 0x0004e20000000200ULL, 0x0000000000200947ULL, 0x000fd80003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010794c7824ULL, 0x000fcc00078e027eULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x00000018ff897819ULL, 0x024fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d8c7816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001145fULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004d687824ULL, 0x008fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000006500917306ULL, 0x0005e20000200c00ULL, 0x00000018ff8a7819ULL, 0x000fc4000001145cULL,
0x00000018ff8b7819ULL, 0x000fe4000001145dULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x000088805c867816ULL, 0x000fe200000000ffULL, 0x00000064008f7306ULL, 0x0007e20000200c00ULL,
0x000001004c657824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001144dULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff7d7819ULL, 0x000fc40000011465ULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x000001005f647824ULL, 0x048fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001145cULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe40000011464ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff887819ULL, 0x000fe40000011468ULL,
0x00000018ff877819ULL, 0x000fe2000001145eULL, 0x0000005f00907306ULL, 0x0007e20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe4000001144eULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x0000008d008d7306ULL, 0x000f620000200c00ULL,
0x000001004e5f7824ULL, 0x048fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001144fULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc4000001145eULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000004d00807306ULL, 0x0007e20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x000088804f697816ULL, 0x000fca00000000ffULL,
0x0000005f00797306ULL, 0x0005e20000200c00ULL, 0x000001004f4d7824ULL, 0x008fce00078e00ffULL,
0x0000004c007b7306ULL, 0x0007e20000200c00ULL, 0x000100004f5f7824ULL, 0x006fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000004e00737306ULL, 0x000be20000200c00ULL,
0x00005410864c7816ULL, 0x008fe4000000008fULL, 0x00000018ff867819ULL, 0x000fca000001144dULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054108d4e7816ULL, 0x020fce000000008aULL,
0x0000008700877306ULL, 0x000ff00000200c00ULL, 0x0000007f007f7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054107b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541080677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fe20000001850ULL, 0x00005410736a7816ULL, 0x002fcc000000006aULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x000054108c4d7816ULL, 0x002fce0000000091ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000004c3454723cULL, 0x000fe20000001854ULL,
0x000054108e4f7816ULL, 0x004fcc0000000089ULL, 0x0000008b008b7306ULL, 0x000e620000200c00ULL,
0x0000004c2c0c723cULL, 0x000fee000000180cULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x00000008614d7c11ULL, 0x000fc4000f8e18ffULL,
0x000054105c5c7816ULL, 0x002fc8000000008bULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x0000004e2c10723cULL, 0x000fee0000001810ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105d5d7816ULL, 0x002fce0000000092ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc0000000087ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000005c2c14723cULL, 0x000fee0000001814ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x002fce000000007dULL,
0x0000008800887306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fce0000000088ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000000643448723cULL, 0x000fe20000001848ULL, 0x0000541068687816ULL, 0x004fcc0000000079ULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000642c1c723cULL, 0x000fee000000181cULL,
0x0000005f008a7306ULL, 0x0004e20000200c00ULL, 0x0000541069697816ULL, 0x002fe40000000086ULL,
0x00005410905f7816ULL, 0x004fca000000007fULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x000054108a6b7816ULL, 0x008fca000000006bULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x0000000263347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834367812ULL, 0x000fe200078ec0ffULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x01a6c8374d3479a7ULL, 0x0002aa000850003fULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x01a6983736ff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x01a6c8354d0075a7ULL, 0x004ea2000800017fULL,
0x0000000360367836ULL, 0x002fc80000000000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0036ULL,
0x0000000000600947ULL, 0x004fec0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x0000002c2e377210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001142dULL,
0x000000372c2c7211ULL, 0x000fca00078110ffULL, 0x000000ffff2d7224ULL, 0x000fca00000e062dULL,
0x000000022c2c7819ULL, 0x000fc8000000122dULL, 0x0000002c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6c8354d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff2c7224ULL, 0x000fce00078e0036ULL, 0x0000000107357836ULL, 0x000fe40000000000ULL,
0x0000000359597836ULL, 0x000fc60000000000ULL, 0x000000623500720cULL, 0x000fda0003f06070ULL,
0x0000000800180947ULL, 0x000fea0003800000ULL, 0x00000002072d7836ULL, 0x000fe20000000000ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000010035357824ULL, 0x000fc600078e025bULL,
0x000000622d00720cULL, 0x000fe20003f06070ULL, 0x00000004812d7c24ULL, 0x010fe2000f8e02ffULL,
0x00000020352f7812ULL, 0x000fc600078ec0ffULL, 0x000000402d2d7824ULL, 0x000fe400078e00ffULL,
0x000000015a377824ULL, 0x000fcc00078e022fULL, 0x0000000400048947ULL, 0x000fea0003800000ULL,
0x00000035762e7248ULL, 0x000fe20007fe0000ULL, 0x00000010632f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff367819ULL, 0x000fc60000011609ULL, 0x000000012e2e7824ULL, 0x000fe200078e0a35ULL,
0x000000102f357812ULL, 0x000fe200078ec0ffULL, 0x00000004364c7836ULL, 0x000fe40000000000ULL,
0x00000008364d7836ULL, 0x000fe20000000000ULL, 0x0000002e35347248ULL, 0x000fe20007fe0000ULL,
0x0000000c364e7836ULL, 0x000fe20000000000ULL, 0x00009000ff2e7b82ULL, 0x000e620000000a00ULL,
0x000000014c5c7824ULL, 0x100fe400078e0235ULL, 0x0000000134347824ULL, 0x000fc400078e0a35ULL,
0x000000014d5e7824ULL, 0x140fe400078e0235ULL, 0x000000085c667824ULL, 0x000fe200078e00ffULL,
0x000000343600720cULL, 0x0c0fe20003f86070ULL, 0x0000000136367824ULL, 0x100fe200078e0235ULL,
0x000000344c00720cULL, 0x080fe20003f66070ULL, 0x000000014e647824ULL, 0x000fe200078e0235ULL,
0x000000344d00720cULL, 0x080fe20003f46070ULL, 0x00000001364c7824ULL, 0x000fe200078e0209ULL,
0x000000344e00720cULL, 0x000fe20003f06070ULL, 0x00000008365d7824ULL, 0x000fc400078e00ffULL,
0x000000015c4d7824ULL, 0x000fe400078e0209ULL, 0x00000001364e7824ULL, 0x100fe200078e0237ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee24cULL, 0x000000015c367824ULL, 0x100fe200078e0237ULL,
0xfffffff8665f7812ULL, 0x000fe200078ee24dULL, 0x000000015e347824ULL, 0x040fe200078e0237ULL,
0x0000002e2d597211ULL, 0x042fe200078a38ffULL, 0x000000015e357824ULL, 0x040fe400078e0209ULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x0000002f2d2d7211ULL, 0x000fe200028f3cffULL,
0x00000001644c7824ULL, 0x000fc400078e0237ULL, 0x00000001644d7824ULL, 0x000fe200078e0209ULL,
0xfffffff85e657812ULL, 0x000fe200078ee235ULL, 0x000000804e4e7825ULL, 0x000fc800078e00ffULL,
0x0000000864647824ULL, 0x000fe200078e00ffULL, 0x0000006d4e2e7212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff864677812ULL, 0x000fe200078ee24dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x080fe400078efcffULL,
0x0000002e592e7210ULL, 0x000fe20007fbe0ffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000005936367210ULL, 0x000fe40007fde0ffULL, 0x0000006d34347212ULL, 0x080fe200078efcffULL,
0x000000014f2f7824ULL, 0x100fe200028e062dULL, 0x0000006d4c4c7212ULL, 0x000fe200078efcffULL,
0x0000000137377824ULL, 0x000fe200030e062dULL, 0x0000005934347210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027eULL, 0x000000594c4c7210ULL, 0x000fe20007fde0ffULL,
0x000000105f5f7824ULL, 0x000fc400078e027eULL, 0x0000001065657824ULL, 0x100fe200078e027eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e5d7faeULL, 0x0003e2000e101c46ULL,
0x0000000135357824ULL, 0x100fe400028e062dULL, 0x0000001067677824ULL, 0x000fe200078e027eULL,
0x00000000365f7faeULL, 0x0003e2000d901c46ULL, 0x000000014d4d7824ULL, 0x000fc600030e062dULL,
0x0000000034657faeULL, 0x0003e8000d101c46ULL, 0x000000004c677faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000010632e7824ULL, 0x000fca00078e00ffULL,
0x000000102e2e7812ULL, 0x000fc800078ec0ffULL, 0x0000002e09367211ULL, 0x000fe400078fe8ffULL,
0x00009000ff2e7b82ULL, 0x000e660000000a00ULL, 0x0000000136347824ULL, 0x040fe400078e0209ULL,
0x0000000836597824ULL, 0x000fe400078e00ffULL, 0x00000004364c7836ULL, 0x000fe40000000000ULL,
0x00000008365c7836ULL, 0x000fe20000000000ULL, 0xfffffff859597812ULL, 0x000fe200078ee234ULL,
0x0000000c365e7836ULL, 0x000fc40000000000ULL, 0x0000000136347824ULL, 0x100fe400078e0237ULL,
0x000000014c367824ULL, 0x040fe400078e0237ULL, 0x000000014c4d7824ULL, 0x040fe400078e0209ULL,
0x000000084c647824ULL, 0x000fe400078e00ffULL, 0x000000015c4c7824ULL, 0x100fe400078e0237ULL,
0x000000015e4e7824ULL, 0x000fe200078e0237ULL, 0x0000002e2d5d7211ULL, 0x042fe200078038ffULL,
0x000000015c377824ULL, 0x140fe200078e0209ULL, 0xfffffff8645f7812ULL, 0x000fe200078ee24dULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000002f2d2d7211ULL, 0x000fe200000f3cffULL,
0x000000015e4f7824ULL, 0x000fc400078e0209ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff85c657812ULL, 0x000fc600078ee237ULL, 0x000000085e5e7824ULL, 0x000fe200078e00ffULL,
0x0000006d342e7212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff85e677812ULL, 0x000fe200078ee24fULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000002e5d2e7210ULL, 0x000fe40007f1e0ffULL, 0x0000006d36347212ULL, 0x080fe200078efcffULL,
0x000000804e4e7825ULL, 0x000fe200078e00ffULL, 0x0000006d4c367212ULL, 0x000fc600078efcffULL,
0x00000001352f7824ULL, 0x100fe200000e062dULL, 0x0000006d4e4c7212ULL, 0x000fe200078efcffULL,
0x0000001059597824ULL, 0x100fe200078e027eULL, 0x000000345d347210ULL, 0x000fe20007f1e0ffULL,
0x000000105f5f7824ULL, 0x100fe200078e027eULL, 0x000000365d367210ULL, 0x000fe20007f5e0ffULL,
0x0000001065657824ULL, 0x100fe200078e027eULL, 0x0000004c5d4c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001067677824ULL, 0x000fe200078e027eULL, 0x0000002d37357210ULL, 0x000fe200007fe4ffULL,
0x000000014d377824ULL, 0x100fe200010e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e597faeULL, 0x0003e2000b901c46ULL, 0x000000014f4d7824ULL, 0x000fc600018e062dULL,
0x00000000345f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036657faeULL, 0x0003e8000b901c46ULL,
0x000000004c677faeULL, 0x0003e4000b901c46ULL, 0x000000046e597836ULL, 0x002fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff2e7b82ULL, 0x000e620000000a00ULL,
0x00000001082d7824ULL, 0x000fc800078e0259ULL, 0x000000042d2e7825ULL, 0x002fca00078e002eULL,
0x000000062e817981ULL, 0x000324000c1e1900ULL, 0x00000008632e7824ULL, 0x002fe200078e00ffULL,
0x00000008602d7c11ULL, 0x000fe2000f8e28ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fe200078ec0ffULL, 0x00000010582d7824ULL, 0x000fe200078e022dULL,
0x000000082e367812ULL, 0x000fc600078ec0ffULL, 0x000000082f347c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000340472caULL, 0x000fda00000e0000ULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6a837342e79a7ULL, 0x0002a2000850003fULL,
0x00000001362d7824ULL, 0x000fc800078e022dULL, 0x01a668372d3679a7ULL, 0x0022e4000850003fULL,
0x000000ffff797224ULL, 0x006fce00078e002fULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a668372d0075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e4d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000004d34347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a668372d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000082c2c7c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0083ULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x0004a20000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x004fea0003800000ULL, 0x00000003602c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x0c0fe40003f14000ULL, 0x000000832e7e7209ULL, 0x000fe40007810000ULL,
0x000000632c00720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x00000008632cac11ULL, 0x000fe4000f8e38ffULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x0000002c706da210ULL, 0x000fca0007ffe06dULL, 0x01a4007e6d00a388ULL, 0x0003ec0000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000837e2c7221ULL, 0x000fe20000010100ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x0000002c00357308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x004fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x000000542c547220ULL, 0x044fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x004fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x008ea400000e0000ULL,
0x000000562c567220ULL, 0x044fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x0000000c2c0c7220ULL, 0x044fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000ea400000e0000ULL, 0x0000000e2c0e7220ULL, 0x044fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x0000002e7e2c0221ULL, 0x004fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6b0852f0075a7ULL, 0x000ea20008000148ULL, 0x000000082f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x004fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b085370075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000004ff2d7819ULL, 0x000fe20000011609ULL, 0x00000003606e7836ULL, 0x000fe20000000000ULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x000000086c357824ULL, 0x000fe400078e00ffULL,
0x00000004582d7824ULL, 0x000fe200078e022dULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x00000004632f7824ULL, 0x000fe200078e00ffULL, 0x000000086e6e7c11ULL, 0x000fe2000f8e60ffULL,
0x000000016c2c7824ULL, 0x000fe400078e022dULL, 0x0000000878377824ULL, 0x000fc400078e00ffULL,
0x00000001782e7824ULL, 0x000fe200078e022dULL, 0xfffffff8352d7812ULL, 0x000fe200078ee22cULL,
0x000120006e6e7836ULL, 0x000fe20000000000ULL, 0x000000042f2c7812ULL, 0x000fe200078ec0ffULL,
0x000000106f4c7824ULL, 0x000fe200078e027aULL, 0xfffffff8372f7812ULL, 0x000fe200078ee22eULL,
0x000000102d2d7824ULL, 0x000fe200078e026eULL, 0x000000022c2c7812ULL, 0x000fc600078efcffULL,
0x000000102f2f7824ULL, 0x000fe200078e026eULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002e7816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f052e057589ULL, 0x0004e800000e0000ULL, 0x00001f352e027589ULL, 0x00046800000e0000ULL,
0x00001f032e037589ULL, 0x00046800000e0000ULL, 0x00001f372e007589ULL, 0x00046400000e0000ULL,
0x000000002d5c783bULL, 0x000ae80000000200ULL, 0x000000002f34783bULL, 0x0044620000000200ULL,
0x0000000000200947ULL, 0x020fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000000000ULL,
0x000000035e5e7232ULL, 0x000fe40000000000ULL, 0x000000025d5d7232ULL, 0x080fe40000000000ULL,
0x000000025f5f7232ULL, 0x000fe40000000000ULL, 0x0000000534347232ULL, 0x080fe40000000000ULL,
0x0000000536367232ULL, 0x000fc40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x0000002c097b7211ULL, 0x000fe200078fe0ffULL, 0x000000086c2d7824ULL, 0x000fc800078e00ffULL,
0x000000016c6c7824ULL, 0x000fca00078e027bULL, 0xfffffff82d2d7812ULL, 0x000fca00078ee26cULL,
0x000000102d2d7824ULL, 0x000fcc00078e027aULL, 0x000000002d2c783bULL, 0x004ea20000004200ULL,
0x000001004c677824ULL, 0x060fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001144cULL,
0x000001004d687824ULL, 0x040fe200078e00ffULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011467ULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001144dULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000088804d677816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff807819ULL, 0x000fe40000011468ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c00877306ULL, 0x000be20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011469ULL, 0x000001002e837824ULL, 0x004fe200078e00ffULL,
0x000088804f697816ULL, 0x040fe200000000ffULL, 0x0000004d00867306ULL, 0x0005e20000200c00ULL,
0x000001004f4c7824ULL, 0x028fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe2000001142cULL,
0x000001002f8b7824ULL, 0x000fe200078e00ffULL, 0x000088802c6c7816ULL, 0x000fc400000000ffULL,
0x00000018ff887819ULL, 0x000fe4000001144cULL, 0x00000018ff4c7819ULL, 0x000fe2000001144eULL,
0x000100004f4d7824ULL, 0x004fe200078e00ffULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff7d7819ULL, 0x000fe4000001142eULL,
0x00000018ff4e7819ULL, 0x000fe2000001144dULL, 0x000001002c4d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe2000001142fULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802e707816ULL, 0x040fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x000088802f8a7816ULL, 0x040fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001142cULL,
0x000100002d2c7824ULL, 0x040fe200078e00ffULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000088802d6d7816ULL, 0x002fc400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001142dULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x0000541068687816ULL, 0x004fc40000000085ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x00000018ff857819ULL, 0x000fe4000001142fULL, 0x0000541087647816ULL, 0x000fe40000000064ULL,
0x0000541067677816ULL, 0x002fc60000000080ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541086657816ULL, 0x004fce0000000065ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000000643410723cULL, 0x000fee0000001810ULL, 0x0000004c004f7306ULL, 0x0005e20000200c00ULL,
0x000000645c3c723cULL, 0x000fe2000000183cULL, 0x0000541069697816ULL, 0x002fcc0000000088ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000001002d4c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000000683414723cULL, 0x000fe20000001814ULL,
0x0000007f002d7306ULL, 0x000fea0000200c00ULL, 0x000000685c40723cULL, 0x000fe60000001840ULL,
0x0000004c004c7306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x000054106d6d7816ULL, 0x002fce000000004cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000010714c7824ULL, 0x000fe200078e026eULL, 0x000054104f6a7816ULL, 0x004fcc000000006aULL,
0x0000008400847306ULL, 0x000ff00000200c00ULL, 0x0000006f006f7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541066667816ULL, 0x002fce0000000089ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00000066340c723cULL, 0x000fe2000000180cULL,
0x000054104e6b7816ULL, 0x004fcc000000006bULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x000000665c54723cULL, 0x000fee0000001854ULL, 0x0000002c002c7306ULL, 0x000ea20000200c00ULL,
0x0000006a3418723cULL, 0x000fe20000001818ULL, 0x000054106c6c7816ULL, 0x002fcc000000004dULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000006a5c44723cULL, 0x000fe20000001844ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x000054102c6f7816ULL, 0x004fca000000006fULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000006c341c723cULL, 0x000fec000000181cULL,
0x0000006c5c48723cULL, 0x000fe20000001848ULL, 0x0000008a007f7306ULL, 0x000fe20000200c00ULL,
0x0000541070707816ULL, 0x004fce0000000083ULL, 0x0000008b00807306ULL, 0x000eb00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054107f717816ULL, 0x004fce0000000080ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000000703430723cULL, 0x000fee0000001830ULL,
0x0000002e00867306ULL, 0x0004e20000200c00ULL, 0x000000705c28723cULL, 0x000fee0000001828ULL,
0x0000008500887306ULL, 0x000f620000200c00ULL, 0x00000010722e7824ULL, 0x004fe200078e026eULL,
0x000054102d6e7816ULL, 0x000fc40000000084ULL, 0x0000541086727816ULL, 0x008fc6000000007dULL,
0x000000002e2c783bULL, 0x000ea40000000200ULL, 0x0000006e3420723cULL, 0x000fe20000001820ULL,
0x0000541088737816ULL, 0x020fca0000000073ULL, 0x0000006e5c50723cULL, 0x000fec0000001850ULL,
0x000000725c24723cULL, 0x000fec0000001824ULL, 0x000000723434723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000034c4c7232ULL, 0x080fe40000000000ULL, 0x000000034e4e7232ULL, 0x000fe40000000000ULL,
0x000000024d4d7232ULL, 0x080fe40000000000ULL, 0x000000024f4f7232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x084fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000007c5c783bULL, 0x000e620000004200ULL, 0x00000001787b7824ULL, 0x040fe400078e027bULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0xfffffff8787b7812ULL, 0x000fe200078ee27bULL, 0x000001005c387824ULL, 0x042fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001145cULL, 0x000001005d397824ULL, 0x000fe200078e00ffULL,
0x000088805c677816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011438ULL, 0x000000107b387824ULL, 0x000fe200078e027aULL,
0x00000018ff807819ULL, 0x000fe20000011439ULL, 0x000001005e647824ULL, 0x040fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fe2000001145eULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000088805e727816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x000088805d7f7816ULL, 0x000fc400000000ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001145fULL,
0x0000005c007d7306ULL, 0x0007e20000200c00ULL, 0x000088805f737816ULL, 0x000fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000007c007c7306ULL, 0x000f620000200c00ULL, 0x000001005f5c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000100005f5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fce000001145fULL, 0x0000008000807306ULL, 0x000ef00000200c00ULL,
0x0000005c00787306ULL, 0x000fe20000200c00ULL, 0x00000018ff657819ULL, 0x002fe2000001143aULL,
0x000001003a837824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fc40000011438ULL,
0x0000888038697816ULL, 0x000fc600000000ffULL, 0x00000064007b7306ULL, 0x0003e20000200c00ULL,
0x0000888039687816ULL, 0x000fce00000000ffULL, 0x0000005e00707306ULL, 0x0007e20000200c00ULL,
0x00000018ff647819ULL, 0x002fce0000011439ULL, 0x00000065005c7306ULL, 0x0003e20000200c00ULL,
0x00000100385e7824ULL, 0x04cfe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000010039657824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011465ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000005d007a7306ULL, 0x0002f00000200c00ULL, 0x0000003800667306ULL, 0x000be20000200c00ULL,
0x00000018ff5d7819ULL, 0x002fce000001143bULL, 0x0000003900657306ULL, 0x0003e20000200c00ULL,
0x0000541067387816ULL, 0x020fe4000000007cULL, 0x00000018ff677819ULL, 0x000fca0000011483ULL,
0x0000007200727306ULL, 0x000f620000200c00ULL, 0x000054107f397816ULL, 0x002fce0000000080ULL,
0x000000384c54723cULL, 0x000fe20000001854ULL, 0x0000007300737306ULL, 0x000e6a0000200c00ULL,
0x000000382c0c723cULL, 0x000fe6000000180cULL, 0x0000005e006a7306ULL, 0x0003e80000200c00ULL,
0x000054107d387816ULL, 0x004fc4000000006eULL, 0x000054107a397816ULL, 0x008fe2000000006fULL,
0x000001003b7a7824ULL, 0x040fe200078e00ffULL, 0x000088803b6e7816ULL, 0x040fe200000000ffULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000088803a5e7816ULL, 0x042fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x000000384c3c723cULL, 0x000fe6000000183cULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000006400647306ULL, 0x000e640000200c00ULL, 0x000000382c10723cULL, 0x000fec0000001810ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541072387816ULL, 0x020fe2000000007bULL,
0x000100003b727824ULL, 0x000fe200078e00ffULL, 0x0000541073397816ULL, 0x000fc80000000078ULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007a003b7306ULL, 0x000ee40000200c00ULL,
0x000000384c40723cULL, 0x000fec0000001840ULL, 0x0000006d006d7306ULL, 0x000f620000200c00ULL,
0x000000382c14723cULL, 0x000fee0000001814ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541066387816ULL, 0x004fc4000000005fULL, 0x0000541065397816ULL, 0x002fe40000000064ULL,
0x000054106e5f7816ULL, 0x008fe2000000003bULL, 0x00000001ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000541070707816ULL, 0x020fe2000000006dULL, 0x0000007100717306ULL, 0x000e640000200c00ULL,
0x000000384c50723cULL, 0x000fec0000001850ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000382c20723cULL, 0x000fe20000001820ULL, 0x0000003b063879a7ULL, 0x000762000850003fULL,
0x0000541071717816ULL, 0x002fca000000006cULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000000860067c11ULL, 0x008fe2000f8e18ffULL, 0x000000702c18723cULL, 0x000fe20000001818ULL,
0x00005410696a7816ULL, 0x004fca000000006aULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x01a6a03b06ff79a7ULL, 0x000be2000850003fULL, 0x000000704c44723cULL, 0x000fec0000001844ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00005410686b7816ULL, 0x002fce000000006bULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x0000006a2c1c723cULL, 0x000fee000000181cULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000006a4c48723cULL, 0x000fe20000001848ULL,
0x000054105e5e7816ULL, 0x002fcc0000000067ULL, 0x0000003a006f7306ULL, 0x000e620000200c00ULL,
0x0000005e2c30723cULL, 0x000fee0000001830ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x0000005e4c28723cULL, 0x000fe20000001828ULL, 0x000054106f5c7816ULL, 0x002fc4000000005cULL,
0x00005410725d7816ULL, 0x004fce000000005dULL, 0x0000005c4c24723cULL, 0x000fec0000001824ULL,
0x0000005c2c2c723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff5c00a49947ULL, 0x020fde000383ffffULL, 0x000000ff6200720cULL, 0x000fe20003f05270ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0045ULL, 0x000000ffff457224ULL, 0x000fe400078e0044ULL,
0x000000ffff447224ULL, 0x000fe400078e0041ULL, 0x000000ffff417224ULL, 0x000fe400078e0040ULL,
0x000000ffff407224ULL, 0x000fe400078e003dULL, 0x000000ffff3d7224ULL, 0x000fc400078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000c42000047802ULL, 0x002fce0000000f00ULL, 0x000000b0005c7944ULL, 0x014fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008200037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000082ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x028ee2000c1e9900ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x0000001805077811ULL, 0x042fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x0000000805357811ULL, 0x040fe400078ff0ffULL,
0x0000001005377811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0900047589ULL, 0x000e6800000e0000ULL, 0x00001f3500067589ULL, 0x000ea800000e0000ULL,
0x00001f3700057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000000163637812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000505150723eULL, 0x000fc400000000ffULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000565757723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x000000424342723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fc400000000ffULL, 0x0000541057567816ULL, 0x140fe4000000003eULL,
0x0000763257577816ULL, 0x000fe4000000003eULL, 0x0000004a4b4a723eULL, 0x000fe400000000ffULL,
0x000000525325723eULL, 0x000fe400000000ffULL, 0x0000000800057811ULL, 0x04afe200078ff0ffULL,
0x000000015b5b7824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807367824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee203ULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x0000000805357824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fc400078ff8ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008093c7824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0xfffffff8353a7812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0x0000002a2b2a723eULL, 0x000fe200000000ffULL,
0x0000000403067836ULL, 0x000fe20000000000ULL, 0xfffffff809087812ULL, 0x000fe200078ee202ULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0x0000000863027c11ULL, 0x000fe2000f8e68ffULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fc400078ee203ULL,
0xfffffff809347812ULL, 0x000fe200078ee206ULL, 0x0000100061037824ULL, 0x100fe200078e0202ULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x000000105b5b7824ULL, 0x000fe200078e0202ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x0000000308077211ULL, 0x000fe200078e20ffULL, 0x0000001038377824ULL, 0x100fe200078e0203ULL,
0x0000003d4004723eULL, 0x000fe200000000ffULL, 0x000000103a397824ULL, 0x100fe200078e0203ULL,
0x000000262726723eULL, 0x000fe200000000ffULL, 0x000000103c3b7824ULL, 0x100fe200078e0203ULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x0000001034097824ULL, 0x100fe200078e0203ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x0000001036357824ULL, 0x000fe200078e0203ULL,
0x000000545503723eULL, 0x000fe200000000ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000000181918723eULL, 0x000fe200000000ffULL, 0x0000000106377824ULL, 0x040fe200078e0237ULL,
0x00005410033c7816ULL, 0x140fe20000000004ULL, 0x0000000106397824ULL, 0x040fe200078e0239ULL,
0x00007632033d7816ULL, 0x000fe20000000004ULL, 0x00000001063b7824ULL, 0x000fe200078e023bULL,
0x000000414403723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000454c04723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0000003c05007388ULL, 0x0003e20000000a00ULL, 0x0000000106357824ULL, 0x000fe200078e0235ULL,
0x0000541003067816ULL, 0x000fc40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x0000541048047816ULL, 0x140fe40000000050ULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0005e20000000a00ULL, 0x000000202120723eULL, 0x000fe400000000ffULL,
0x0000763248057816ULL, 0x002fe40000000050ULL, 0x000000303130723eULL, 0x000fc400000000ffULL,
0x0000000e0f0e723eULL, 0x000fe200000000ffULL, 0x0000000409007388ULL, 0x0003e20000000a00ULL,
0x000000161716723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x000000101106723eULL, 0x004fe400000000ffULL, 0x000000121307723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fc400000000ffULL, 0x00000022230f723eULL, 0x000fe400000000ffULL,
0x0000541028047816ULL, 0x142fe40000000024ULL, 0x0000763228057816ULL, 0x000fe40000000024ULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x0000000435007388ULL, 0x0003e20000000a00ULL, 0x00007632160d7816ULL, 0x000fc4000000001aULL,
0x000076321e217816ULL, 0x000fe2000000000fULL, 0x0000005637007388ULL, 0x000fe20000000a00ULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x000000ff6100720cULL, 0x000fe40003f05270ULL, 0x0000541042047816ULL, 0x142fe40000000046ULL,
0x0000763242057816ULL, 0x000fca0000000046ULL, 0x0004000408007388ULL, 0x0003e80000000a00ULL,
0x0004002409007388ULL, 0x000fe20000000a00ULL, 0x000054102a047816ULL, 0x142fe40000000026ULL,
0x000076322a057816ULL, 0x000fca0000000026ULL, 0x0004000435007388ULL, 0x0003e40000000a00ULL,
0x000054100c047816ULL, 0x142fe40000000006ULL, 0x000076320c057816ULL, 0x000fe40000000006ULL,
0x000054100e067816ULL, 0x140fe40000000007ULL, 0x000076320e077816ULL, 0x000fe20000000007ULL,
0x0000000439007388ULL, 0x0003e20000000a00ULL, 0x00005410160c7816ULL, 0x000fc4000000001aULL,
0x0000541014047816ULL, 0x142fe40000000018ULL, 0x0000763214057816ULL, 0x000fe40000000018ULL,
0x0000002c2d18723eULL, 0x000fc600000000ffULL, 0x0008000408007388ULL, 0x0003e40000000a00ULL,
0x000054101c047816ULL, 0x142fe40000000020ULL, 0x000076321c057816ULL, 0x000fe40000000020ULL,
0x000054101e207816ULL, 0x000fc6000000000fULL, 0x0008000409007388ULL, 0x0003e40000000a00ULL,
0x0000541030047816ULL, 0x142fe40000000018ULL, 0x0000763230057816ULL, 0x000fca0000000018ULL,
0x0008000435007388ULL, 0x000fe80000000a00ULL, 0x000000063b007388ULL, 0x000fe80000000a00ULL,
0x000c000c08007388ULL, 0x0003e80000000a00ULL, 0x000c002009007388ULL, 0x0005e20000000a00ULL,
0x0000541032087816ULL, 0x002fc40000000019ULL, 0x0000763232097816ULL, 0x004fca0000000019ULL,
0x000c000835007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000005b047984ULL, 0x000e680000000c00ULL, 0x000400005b107984ULL, 0x000ea80000000c00ULL,
0x000800005b187984ULL, 0x000ee80000000c00ULL, 0x000c00005b207984ULL, 0x000f680000000c00ULL,
0x001000005b0c7984ULL, 0x000ee80000000c00ULL, 0x001400005b147984ULL, 0x000f680000000c00ULL,
0x001800005b1c7984ULL, 0x000f680000000c00ULL, 0x001c00005b247984ULL, 0x000f620000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x004fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x008fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fe40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x020fc40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fe40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x0000000f07077230ULL, 0x000fe40000000000ULL, 0x0000000e06067230ULL, 0x000fe40000000000ULL,
0x0000000d05057230ULL, 0x000fc40000000000ULL, 0x0000000c04047230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x000fe40000000000ULL, 0x0000001612127230ULL, 0x000fe20000000000ULL,
0x000000045b007388ULL, 0x0003e20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x000400105b007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x000fe40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x000800185b007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fc40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x000c00205b007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff0c7819ULL, 0x000fc80000011600ULL, 0x0000000b0c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000ffff047224ULL, 0x002fe200078e00ffULL, 0x0000000800037d06ULL, 0x000e620008209000ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000700127812ULL, 0x000fca00078ec0ffULL, 0x0000000300037308ULL, 0x002e640000001000ULL,
0x0ffffffe03097836ULL, 0x002fe40000000000ULL, 0x000000010c037824ULL, 0x000fc800078e0200ULL,
0x0000000900057305ULL, 0x000e62000021f000ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x0000000705047227ULL, 0x000fc800078e0004ULL,
0x0000000175057824ULL, 0x000fc800078e020cULL, 0x0000000504067227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a06ULL, 0x0000000808077c24ULL, 0x000fe4000f8e0205ULL,
0x0000001003087824ULL, 0x000fe200078e0202ULL, 0x00000008ff037c12ULL, 0x000fe4000f8e33ffULL,
0x0000000807007c0cULL, 0x000fe4000bf06070ULL, 0x00000000080c7984ULL, 0x0002a40000000c00ULL,
0x0000002000087836ULL, 0x002fd20000000000ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x0000000106060836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x0000000106061836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fc8000f8e0205ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4410ULL, 0x0000000863057824ULL, 0x000fe200078e0212ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000004000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x0000006000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000008000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x000000a000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x000000c000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a06ULL, 0x000000e000007836ULL, 0x000fe40000000000ULL,
0x000000080c077c24ULL, 0x000fca000f8e0205ULL, 0x0000000807007c0cULL, 0x000fda000bf26070ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff808077812ULL, 0x000fca00078ef809ULL,
0x0000001007087824ULL, 0x000fca00078e0202ULL, 0x00000000080c7984ULL, 0x0002a20000000c00ULL,
0x0000000106062836ULL, 0x000fca0000000000ULL, 0x0000000603067207ULL, 0x000fe40004000000ULL,
0x00000003ff087819ULL, 0x002fc60000011600ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe2000f8e0205ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000175757824ULL, 0x000fe400078e0208ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x0000000b0800720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00000075040c7227ULL, 0x002fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a0cULL,
0x0000000100087824ULL, 0x000fe400078e0208ULL, 0x0000000804047c24ULL, 0x000fc6000f8e0275ULL,
0x0000000708057812ULL, 0x000fe400078ec0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff805057812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0202ULL, 0x0000000863637824ULL, 0x000fc800078e0200ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x000000010c0c1836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0000000005047984ULL, 0x000e760000000c00ULL,
0x000000010c0c2836ULL, 0x000fca0000000000ULL, 0x0000000c030c7207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a0cULL, 0x000000090c0c7c24ULL, 0x000fe4000f8e0277ULL,
0x0000000802757c24ULL, 0x000fc8000f8e0275ULL, 0x000000080c757c24ULL, 0x000fca000f8e0275ULL,
0x000000750a757210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000475027c11ULL, 0x000fc8000f8040ffULL, 0x0000000575037c11ULL, 0x000fc600080f4408ULL,
0x0000001063027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000746300720cULL, 0x000fe20003f06070ULL,
0x00009a00ff707b82ULL, 0x000e620000000a00ULL, 0xffffffff000d7802ULL, 0x000fd60000000f00ULL,
0x00009600ff078b82ULL, 0x000ea20000000800ULL, 0x0000000279068824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ee20000000a00ULL, 0x0000000670707981ULL, 0x002322000c1e9900ULL,
0x0000000706078224ULL, 0x004fe400078e0263ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x00000004070a8825ULL, 0x008fc800078e000aULL, 0x01a60006ff0679a7ULL, 0x000e620008500008ULL,
0x000000060a0d8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000004002027824ULL, 0x000fe400078e00ffULL, 0x0000004063517824ULL, 0x000fe400078e00ffULL,
0x0000004077007824ULL, 0x000fe400078e00ffULL, 0x0000000d02247224ULL, 0x004fcc00078e02ffULL,
0x0000000c002c0947ULL, 0x002fea0003800000ULL, 0x00009000ff107b82ULL, 0x000e620000000a00ULL,
0x00000003ff267819ULL, 0x000fe40000011609ULL, 0x0000005176087248ULL, 0x000fc60007fe0000ULL,
0x00000004260a7836ULL, 0x000fe40000000000ULL, 0x00000001080d7824ULL, 0x000fe400078e0a51ULL,
0x000000010a087824ULL, 0x140fe400078e0209ULL, 0x000000080a237824ULL, 0x040fe200078e00ffULL,
0x0000000d0a00720cULL, 0x080fe20003f86070ULL, 0x00000008260a7836ULL, 0x000fe40000000000ULL,
0x0000000c26127836ULL, 0x000fe20000000000ULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x0000004077777824ULL, 0x000fe200078e0226ULL, 0x0000000d0a00720cULL, 0x080fe20003f06070ULL,
0x00000001120c7824ULL, 0x040fe200078e0209ULL, 0x0000000d1200720cULL, 0x040fe20003f26070ULL,
0x0000000812277824ULL, 0x000fc400078e00ffULL, 0x000000010a087824ULL, 0x040fe400078e0209ULL,
0x000000080a257824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x00000080770a7825ULL, 0x000fe200078e00ffULL, 0x00000010240c7211ULL, 0x042fe400078438ffULL,
0xfffffff825257812ULL, 0x000fe200078ee208ULL, 0x0000000877107836ULL, 0x000fe20000000000ULL,
0x000000700a177812ULL, 0x000fe200078ef804ULL, 0x0000000c770a7836ULL, 0x000fe20000000000ULL,
0x0000001124087211ULL, 0x000fe200010f3cffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000170c167210ULL, 0x000fc60007f5e0ffULL, 0x00000004770e7836ULL, 0x000fe20000000000ULL,
0x00000070101b7812ULL, 0x000fe200078ef804ULL, 0x000000010b177824ULL, 0x000fe400010e0608ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000c1b1a7210ULL, 0x000fc60007f5e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700a1d7812ULL, 0x000fe400078ef804ULL,
0x00000008630a7c11ULL, 0x000fe2000f8e70ffULL, 0x00000001111b7824ULL, 0x100fe200010e0608ULL,
0x0000000c1d1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001477127836ULL, 0x000fe20000000000ULL,
0x000000700e197812ULL, 0x000fe200078ef804ULL, 0x0000001877147836ULL, 0x000fe40000000000ULL,
0x000000010b1d7824ULL, 0x000fe200010e0608ULL, 0x0000000c19187210ULL, 0x000fe20007f7e0ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000001260b7824ULL, 0x000fe200078e0209ULL,
0x00000070121f7812ULL, 0x000fe200078ef804ULL, 0x000020000a207836ULL, 0x000fe40000000000ULL,
0x00000010770e7836ULL, 0x000fe20000000000ULL, 0x000000070b227812ULL, 0x000fe200078ec0ffULL,
0x0000001c770a7836ULL, 0x000fe40000000000ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000010f197824ULL, 0x000fe200018e0608ULL, 0x0000007014117812ULL, 0x000fe200078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000c1f107210ULL, 0x000fe40007f7e0ffULL,
0x0000000c11127210ULL, 0x000fe20007fbe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700e217812ULL, 0x000fc600078ef804ULL, 0x00000014261e7836ULL, 0x000fe20000000000ULL,
0x000000700a1f7812ULL, 0x000fe200078ef804ULL, 0x0000000113117824ULL, 0x100fe200018e0608ULL,
0x0000000c210e7210ULL, 0x000fe20007f5e0ffULL, 0x000000011e0a7824ULL, 0x140fe200078e0209ULL,
0x0000000d1e00720cULL, 0x0c0fe20003f66070ULL, 0x000000081e2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f1e7210ULL, 0x000fe20007fde0ffULL, 0x0000001026147836ULL, 0x000fe20000000000ULL,
0x0ffffff822217812ULL, 0x000fe200078ef809ULL, 0x0000000115137824ULL, 0x100fe200028e0608ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL, 0x00000020770a7836ULL, 0x000fe20000000000ULL,
0x0000000d2600720cULL, 0x080fe20003fa6070ULL, 0x000000010f0f7824ULL, 0x000fe200010e0608ULL,
0x0000000d1400720cULL, 0x040fe20003f46070ULL, 0x0000000114157824ULL, 0x000fc400078e0209ULL,
0x000000010b1f7824ULL, 0x000fe400030e0608ULL, 0x0000000814147824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff814297812ULL, 0x000fe200078ee215ULL,
0x0000001826227836ULL, 0x000fe20000000000ULL, 0x000000700a2d7812ULL, 0x000fe200078ef804ULL,
0x0000001021217824ULL, 0x100fe400078e0220ULL, 0x0000001023237824ULL, 0x000fe400078e0220ULL,
0x0000002477147836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e2000e901c46ULL, 0x00000001220a7824ULL, 0x040fe200078e0209ULL,
0x0000000d2200720cULL, 0x040fe20003fa6070ULL, 0x00000008222f7824ULL, 0x000fe200078e00ffULL,
0x0000000018237faeULL, 0x0005e2000e101c46ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000001025257824ULL, 0x100fe400078e0220ULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x0000000c2d167210ULL, 0x002fe20007fde0ffULL, 0x0000001c26247836ULL, 0x000fe20000000000ULL,
0x00000070142d7812ULL, 0x000fe200078ef804ULL, 0x000000001a257faeULL, 0x000fe2000c101c46ULL,
0xfffffff82f197812ULL, 0x004fe200078ee20aULL, 0x00000028770a7836ULL, 0x000fe20000000000ULL,
0x0000000d2400720cULL, 0x000fe20003f86070ULL, 0x000000010b177824ULL, 0x000fe200030e0608ULL,
0x000000001c277faeULL, 0x0003e2000c901c46ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000c2d147210ULL, 0x000fc60007fde0ffULL, 0x0000001029297824ULL, 0x100fe200078e0220ULL,
0x000000700a237812ULL, 0x000fe200078ef804ULL, 0x0000000124217824ULL, 0x040fe400078e0209ULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x000000000e297faeULL, 0x0005e2000d101c46ULL,
0x000000102b2b7824ULL, 0x100fe400078e0220ULL, 0x0000002c771c7836ULL, 0x002fe20000000000ULL,
0xfffffff824217812ULL, 0x000fe200078ee221ULL, 0x0000001019197824ULL, 0x000fe200078e0220ULL,
0x00000000102b7faeULL, 0x000fe2000d901c46ULL, 0x0000002026187836ULL, 0x000fc40000000000ULL,
0x0000000115157824ULL, 0x000fe200030e0608ULL, 0x0000000c230a7210ULL, 0x000fe20007fde0ffULL,
0x0000002426247836ULL, 0x000fe20000000000ULL, 0x0000000012197faeULL, 0x0003e2000e901c46ULL,
0x000000801c0e7825ULL, 0x004fe200078e00ffULL, 0x0000000d1800720cULL, 0x080fe40003f06070ULL,
0x0000000d2400720cULL, 0x000fe20003f26070ULL, 0x0000000118227824ULL, 0x040fe400078e0209ULL,
0x00000008182d7824ULL, 0x000fc400078e00ffULL, 0x0000000124187824ULL, 0x040fe400078e0209ULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0x000000700e137812ULL, 0x002fe200078ef804ULL,
0x000000010b0b7824ULL, 0x000fe200030e0608ULL, 0xfffffff82d1b7812ULL, 0x000fe200078ee222ULL,
0x00000030770e7836ULL, 0x000fe20000000000ULL, 0x0000000c13127210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0xfffffff8251d7812ULL, 0x000fe200078ee218ULL,
0x000000101b1b7824ULL, 0x000fc400078e0220ULL, 0x000000010f137824ULL, 0x000fe200030e0608ULL,
0x000000001e217faeULL, 0x000fe2000e101c46ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x00000000161b7faeULL, 0x0003e2000c101c46ULL, 0x0000003026107836ULL, 0x000fe40000000000ULL,
0x000000101d1d7824ULL, 0x000fe400078e0220ULL, 0x0000002c261a7836ULL, 0x000fe20000000000ULL,
0x0000000d1000720cULL, 0x080fe20003f66070ULL, 0x0000003477117836ULL, 0x000fe20000000000ULL,
0x00000000141d7faeULL, 0x0005e2000c901c46ULL, 0x0000002826187836ULL, 0x000fe20000000000ULL,
0x0000000d1a00720cULL, 0x080fe20003f86070ULL, 0x00000034261c7836ULL, 0x000fe20000000000ULL,
0x000000700e177812ULL, 0x002fe200078ef804ULL, 0x00000001100e7824ULL, 0x000fe200078e0209ULL,
0x0000000d1800720cULL, 0x080fe20003fa6070ULL, 0x00000008101b7824ULL, 0x000fe200078e00ffULL,
0x0000000d1c00720cULL, 0x000fe20003f46070ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x0000000c17147210ULL, 0x004fc60007fde0ffULL, 0x000000011a157824ULL, 0x140fe200078e0209ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x0000007010177812ULL, 0x000fe200078ef804ULL, 0x0000003826227836ULL, 0x000fe40000000000ULL,
0x0000003c261e7836ULL, 0x000fe20000000000ULL, 0xfffffff81a197812ULL, 0x000fe200078ee215ULL,
0x00000038770e7836ULL, 0x000fe20000000000ULL, 0x0000000d2200720cULL, 0x080fe20003f26070ULL,
0x000000010f157824ULL, 0x000fe200030e0608ULL, 0x0000000d1e00720cULL, 0x000fe20003f06070ULL,
0x00000001180d7824ULL, 0x100fe200078e0209ULL, 0x0000000c17167210ULL, 0x000fe20007fde0ffULL,
0x000000011c107824ULL, 0x000fc400078e0209ULL, 0x000000081c1d7824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x000000700e1f7812ULL, 0x000fe200078ef804ULL,
0x0000003c77777836ULL, 0x000fe40000000000ULL, 0x0000000111177824ULL, 0x000fe200030e0608ULL,
0xfffffff8180d7812ULL, 0x000fe200078ee20dULL, 0x0000008077107825ULL, 0x000fe200078e00ffULL,
0x0000000c1f0e7210ULL, 0x000fc60007fde0ffULL, 0x0000000122187824ULL, 0x140fe200078e0209ULL,
0x0000007010237812ULL, 0x000fe200078ef804ULL, 0x0000000822217824ULL, 0x000fe400078e00ffULL,
0x000000011e097824ULL, 0x040fe400078e0209ULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8211f7812ULL, 0x000fe200078ee218ULL, 0x000000010f0f7824ULL, 0x000fe200030e0608ULL,
0x0000000c230c7210ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x100fe200078e0220ULL,
0xfffffff81e217812ULL, 0x000fe200078ee209ULL, 0x000000100d097824ULL, 0x000fc400078e0220ULL,
0x000000101b1b7824ULL, 0x100fe400078e0220ULL, 0x000000101d1d7824ULL, 0x100fe200078e0220ULL,
0x000000000a097faeULL, 0x0003e2000e901c46ULL, 0x000000101f1f7824ULL, 0x100fe400078e0220ULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x0000000012197faeULL, 0x0003e2000e101c46ULL,
0x00000001110d7824ULL, 0x000fc600030e0608ULL, 0x00000000141b7faeULL, 0x0003e8000d901c46ULL,
0x00000000161d7faeULL, 0x0003e8000d101c46ULL, 0x000000000e1f7faeULL, 0x0003e8000c901c46ULL,
0x000000000c217faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000001009107811ULL, 0x040fe400078fe8ffULL, 0x00000004090a7811ULL, 0x040fe400078fe8ffULL,
0x0000000c090e7811ULL, 0x040fe200078fe8ffULL, 0x0000000110117824ULL, 0x140fe200078e0209ULL,
0x0000001409127811ULL, 0x040fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x00000008090c7811ULL, 0x040fe200078fe8ffULL, 0x000000010a087824ULL, 0x140fe200078e0209ULL,
0x000000090e0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000080a0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff816117812ULL, 0x000fe200078ee211ULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x0000001c09167811ULL, 0x040fe200078fe8ffULL, 0x0000000112137824ULL, 0x140fe200078e0209ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0xfffffff8140f7812ULL, 0x000fe200078ee20fULL, 0x000000010c087824ULL, 0x140fe200078e0209ULL,
0x0000001809147811ULL, 0x040fe200078fe8ffULL, 0x000000080c0d7824ULL, 0x000fe200078e00ffULL,
0x00000034092a7811ULL, 0x040fe200078fe8ffULL, 0x0000000116177824ULL, 0x140fe200078e0209ULL,
0xfffffff818137812ULL, 0x000fe200078ee213ULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x0000002009187811ULL, 0x040fe200078fe8ffULL, 0x0000000814157824ULL, 0x040fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x0000000114087824ULL, 0x100fe200078e0209ULL,
0xfffffff81c177812ULL, 0x000fe200078ee217ULL, 0x000000012a217824ULL, 0x140fe200078e0209ULL,
0x00000028091c7811ULL, 0x040fe200078fe8ffULL, 0x000000082a267824ULL, 0x000fe200078e00ffULL,
0x00000024091a7811ULL, 0x040fe200078fe8ffULL, 0x0000000118197824ULL, 0x140fe200078e0209ULL,
0xfffffff815157812ULL, 0x000fe200078ee208ULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000011c087824ULL, 0x140fe200078e0209ULL,
0x00009000ff267b82ULL, 0x000e620000000a00ULL, 0x000000081c1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e197812ULL, 0x000fe200078ee219ULL, 0x000000011a1b7824ULL, 0x140fe200078e0209ULL,
0x0000002c091e7811ULL, 0x040fe200078fe8ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0x0000003009287811ULL, 0x040fe200078fe8ffULL, 0x00000001000c7824ULL, 0x000fe200078e020cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL, 0x000000011e1f7824ULL, 0x140fe200078e0209ULL,
0x0000000909087211ULL, 0x040fe200078fe8ffULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff8201b7812ULL, 0x000fe200078ee21bULL, 0x0000000128207824ULL, 0x140fe200078e0209ULL,
0x00000038092c7811ULL, 0x040fe200078fe8ffULL, 0x0000000828237824ULL, 0x000fe200078e00ffULL,
0x0000003c092e7811ULL, 0x000fe200078fe8ffULL, 0x0000000100107824ULL, 0x000fe200078e0210ULL,
0x0000000863257c11ULL, 0x000fe2000f8e70ffULL, 0x000000082c297824ULL, 0x000fe200078e00ffULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x00000001000a7824ULL, 0x000fe200078e020aULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x000000012c227824ULL, 0x100fe200078e0209ULL,
0xfffffff823207812ULL, 0x000fe200078ee220ULL, 0x000000012e237824ULL, 0x000fe200078e0209ULL,
0x0ffffff808087812ULL, 0x000fe200078ef809ULL, 0x0000200025307836ULL, 0x000fe20000000000ULL,
0x0000000009097211ULL, 0x000fe200078fe8ffULL, 0x00000001000e7824ULL, 0x000fe200078e020eULL,
0xfffffff829227812ULL, 0x000fe200078ee222ULL, 0x0000001008297824ULL, 0x000fe200078e0230ULL,
0x0000002624497211ULL, 0x002fe200078038ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0x00000027244b7211ULL, 0x000fe200000f3cffULL, 0x000000100d2d7824ULL, 0x000fe200078e0230ULL,
0x0000007008087812ULL, 0x000fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000000849087210ULL, 0x000fe20007f1e0ffULL, 0x0000001011317824ULL, 0x100fe200078e0230ULL,
0x000000700c0c7812ULL, 0x000fe200078ef804ULL, 0x000000100b2b7824ULL, 0x000fe400078e0230ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000100f2f7824ULL, 0x000fe200078e0230ULL,
0x0000007010107812ULL, 0x000fe200078ef804ULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fc600078ef804ULL,
0x0000000109097824ULL, 0x000fe200000e064bULL, 0x0000000c490c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100127824ULL, 0x040fe200078e0212ULL, 0x000000700e0e7812ULL, 0x000fe200078ef804ULL,
0x0000000100147824ULL, 0x040fe200078e0214ULL, 0x0000000a490a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000100167824ULL, 0x040fe200078e0216ULL, 0x0000000e490e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001013337824ULL, 0x000fe200078e0230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008297faeULL, 0x0003e2000b901c46ULL, 0x0000000100187824ULL, 0x000fc400078e0218ULL,
0x0000001015357824ULL, 0x000fe400078e0230ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000001017377824ULL, 0x000fe400078e0230ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000001019397824ULL, 0x000fe400078e0230ULL, 0x000000010d0d7824ULL, 0x000fe200000e064bULL,
0x0000001049107210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016247812ULL, 0x000fc600078ef804ULL,
0x000000082e327824ULL, 0x000fe200078e00ffULL, 0x0000007018267812ULL, 0x000fe200078ef804ULL,
0x0000001020417824ULL, 0x100fe200078e0230ULL, 0x0000007012207812ULL, 0x000fe200078ef804ULL,
0x0000001022457824ULL, 0x000fe200078e0230ULL, 0x0000007014227812ULL, 0x000fe200078ef804ULL,
0x0000000111117824ULL, 0x100fe200000e064bULL, 0xfffffff832237812ULL, 0x000fe200078ee223ULL,
0x000000010b0b7824ULL, 0x100fe200008e064bULL, 0x0000002049207210ULL, 0x000fe20007f1e0ffULL,
0x000000010f0f7824ULL, 0x000fe200010e064bULL, 0x0000002249227210ULL, 0x000fe20007f3e0ffULL,
0x0000000100127824ULL, 0x040fe200078e021aULL, 0x0000002449247210ULL, 0x000fe20007f5e0ffULL,
0x0000000100147824ULL, 0x040fe200078e021cULL, 0x0000002649267210ULL, 0x000fe20007f7e0ffULL,
0x0000001021437824ULL, 0x000fe200078e0230ULL, 0x000000000a2b7faeULL, 0x0003e2000b901c46ULL,
0x0000000100167824ULL, 0x000fc400078e021eULL, 0x0000001023477824ULL, 0x000fe200078e0230ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c46ULL, 0x0000000113217824ULL, 0x100fe400000e064bULL,
0x0000000100187824ULL, 0x040fe200078e0228ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115237824ULL, 0x000fe400008e064bULL, 0x00000001001a7824ULL, 0x000fe200078e022aULL,
0x0000000010317faeULL, 0x0003e2000b901c46ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000020337faeULL, 0x0003e2000b901c46ULL, 0x0000000117257824ULL, 0x100fe200010e064bULL,
0x0000007012127812ULL, 0x000fe200078ef804ULL, 0x00000001001c7824ULL, 0x000fe200078e022cULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001249127210ULL, 0x000fe40007f1e0ffULL, 0x0000000024377faeULL, 0x0003e2000b901c46ULL,
0x0000000119277824ULL, 0x000fe200018e064bULL, 0x0000007014147812ULL, 0x000fe200078ef804ULL,
0x00000001001e7824ULL, 0x000fc400078e022eULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001449147210ULL, 0x000fe20007f3e0ffULL, 0x0000000026397faeULL, 0x0003e4000b901c46ULL,
0x000000101b3b7824ULL, 0x000fe200078e0230ULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x0000001649167210ULL, 0x000fe20007f5e0ffULL,
0x000000101d3d7824ULL, 0x000fe200078e0230ULL, 0x0000007018187812ULL, 0x000fe200078ef804ULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x0000001849187210ULL, 0x000fe20007f7e0ffULL,
0x000000101f3f7824ULL, 0x000fe200078e0230ULL, 0x000000701a1a7812ULL, 0x000fe200078ef804ULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x0000001a491a7210ULL, 0x000fe20007f9e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fc600078ef804ULL,
0x0000000113137824ULL, 0x100fe200000e064bULL, 0x000000701e047812ULL, 0x000fe200078ef804ULL,
0x0000000115157824ULL, 0x100fe200008e064bULL, 0x0000001c491c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000117177824ULL, 0x100fe200010e064bULL, 0x00000004491e7210ULL, 0x000fe20007fde0ffULL,
0x0000000119197824ULL, 0x100fe200018e064bULL, 0x00000000123b7faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x100fe400020e064bULL, 0x000000011d1d7824ULL, 0x100fe200028e064bULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc600030e064bULL,
0x00000000163f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018417faeULL, 0x0003e8000b901c46ULL,
0x000000001a437faeULL, 0x0003e8000b901c46ULL, 0x000000001c457faeULL, 0x0003e8000b901c46ULL,
0x000000001e477faeULL, 0x0003e4000b901c46ULL, 0x00000004637f7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7d7424ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x000000747f00720cULL, 0x000fda0003f06070ULL,
0x00009600ff0b8b82ULL, 0x002e620000000800ULL, 0x0000000279048824ULL, 0x000fce00078e00ffULL,
0x00009200ff088b82ULL, 0x000ea20000000a00ULL, 0x0000000b040b8224ULL, 0x002fc800078e027fULL,
0x000000040b088825ULL, 0x004fca00078e0008ULL, 0x00000006087d8981ULL, 0x000322000c1e1900ULL,
0x0000001f04047890ULL, 0x000fc8000fffe03fULL, 0x000000053f047899ULL, 0x000fd80008011604ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x01a60007ff0075a7ULL, 0x000e620008000148ULL,
0x00000001765f7824ULL, 0x000fe400078e0a03ULL, 0x0000000405057c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x00008e00ff9a7b82ULL, 0x000ea40000000a00ULL,
0x00000004059a7825ULL, 0x004fe200078e009aULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004080b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e09ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000b04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x01a60007ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002063047824ULL, 0x002fc800078e0204ULL, 0x0000000104067836ULL, 0x000fe20000000000ULL,
0x00000004ff057819ULL, 0x000fc80000011604ULL, 0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000107097824ULL, 0x000fe400078e0206ULL,
0x0000000104087824ULL, 0x000fe400078e0207ULL, 0x00000010050a7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00a097812ULL, 0x000fe400078ee209ULL, 0x000001f00b087812ULL, 0x000fe200078ee208ULL,
0x0000000106067824ULL, 0x100fe200078e0207ULL, 0x0000000809097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x0000000808087c11ULL, 0x000fe2000f8e20ffULL,
0x0000001005077824ULL, 0x040fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000e620000000c00ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000f04047812ULL, 0x000fc400078ec0ffULL, 0x0000000008107984ULL, 0x000ea40000000c00ULL,
0x000001f005067812ULL, 0x000fe400078ee206ULL, 0x000001f007047812ULL, 0x000fe400078ee204ULL,
0x0000000806067c11ULL, 0x000fe4000f8e20ffULL, 0x0000000804047c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001408007388ULL, 0x0003e20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001809007388ULL, 0x000fe80000000c00ULL,
0x00000000060c7984ULL, 0x000ea80000000c00ULL, 0x0000000004107984ULL, 0x000ee20000000c00ULL,
0x00000001ff087424ULL, 0x002fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x004fc400078e000eULL,
0x000000ffff1e7224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00000010001c7202ULL, 0x008fe20000000f00ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c04007388ULL, 0x0003e80000000c00ULL, 0x0000000c06007388ULL, 0x0003e20000000c00ULL,
0x01a60008ff0879a7ULL, 0x000ea40008500008ULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a60009ff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x01a60009ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6200720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff047b82ULL, 0x000e620000000800ULL,
0x0000000000507919ULL, 0x000ea20000000000ULL, 0x3db504f370707820ULL, 0x010fe20000410000ULL,
0x00000100517b7836ULL, 0x000fe20000000000ULL, 0x0000000863527c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff035e7836ULL, 0x000fe20000000000ULL, 0x0000000863777c11ULL, 0x000fe2000f8e28ffULL,
0x00000009035d7836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff787224ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fc400078e00ffULL,
0x0000000479797224ULL, 0x002fce00078e02ffULL, 0x0000000278057836ULL, 0x000fe20000000000ULL,
0x00000001085c7812ULL, 0x000fe200078e0cffULL, 0x0000007d027d7224ULL, 0x010fc600078e02ffULL,
0x000000620500720cULL, 0x000fda0003f06070ULL, 0x0000000c003c8947ULL, 0x000fea0003800000ULL,
0x0000010078057824ULL, 0x000fe200078e027bULL, 0x00000003ff0b7819ULL, 0x004fe20000011650ULL,
0x00009000ff127b82ULL, 0x000e660000000a00ULL, 0x0000000576047248ULL, 0x000fe20007fe0000ULL,
0x000000040b097836ULL, 0x000fe40000000000ULL, 0x0000000c0b197836ULL, 0x000fe40000000000ULL,
0x0000000104047824ULL, 0x000fc400078e0a05ULL, 0x0000000109057824ULL, 0x140fe400078e0250ULL,
0x00000008090a7824ULL, 0x040fe200078e00ffULL, 0x000000040900720cULL, 0x080fe20003f26070ULL,
0x0000000119077824ULL, 0x140fe400078e0250ULL, 0x00000008190c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee205ULL, 0x000000100b1b7836ULL, 0x000fe40000000000ULL,
0x000000080b0d7836ULL, 0x000fe20000000000ULL, 0xfffffff80c217812ULL, 0x000fe200078ee207ULL,
0x000000011b057824ULL, 0x040fe200078e0250ULL, 0x000000041b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000081b0c7824ULL, 0x000fe200078e00ffULL, 0x000000040d00720cULL, 0x000fe20003f06070ULL,
0x0000001050077824ULL, 0x000fc400078e00ffULL, 0x00000001000e7824ULL, 0x000fe200078e0209ULL,
0xfffffff80c237812ULL, 0x000fe200078ee205ULL, 0x000000010d067824ULL, 0x000fe200078e0250ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x000000080d1f7824ULL, 0x000fe200078e00ffULL,
0x000000127d097211ULL, 0x002fe200078438ffULL, 0x000000140b257836ULL, 0x000fe40000000000ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc600078ee206ULL,
0x00000001000c7824ULL, 0x000fe200078e020bULL, 0x000000070e147212ULL, 0x000fe200078efcffULL,
0x0000000100107824ULL, 0x000fe400078e020dULL, 0x0000000125067824ULL, 0x040fe200078e0250ULL,
0x0000000914147210ULL, 0x000fe20007f7e0ffULL, 0x0000000825277824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee206ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000137d067211ULL, 0x000fe400010f3cffULL,
0x000000070c127212ULL, 0x080fe200078efcffULL, 0x000000180b297836ULL, 0x000fe20000000000ULL,
0x0000000710167212ULL, 0x000fe200078efcffULL, 0x000000010f157824ULL, 0x000fe200018e0606ULL,
0x0000001209127210ULL, 0x000fe20007f5e0ffULL, 0x000000010b0f7824ULL, 0x100fe200078e0250ULL,
0x0000000916167210ULL, 0x000fe20007f9e0ffULL, 0x00000001290a7824ULL, 0x000fe200078e0250ULL,
0x000000040b00720cULL, 0x000fe20003f66070ULL, 0x00000008292b7824ULL, 0x000fc400078e00ffULL,
0x00000001000c7824ULL, 0x040fe400078e0219ULL, 0x00000001000e7824ULL, 0x000fe200078e021bULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL, 0x0000001c0b2d7836ULL, 0x000fe40000000000ULL,
0x000000010d137824ULL, 0x100fe200010e0606ULL, 0x000000041900720cULL, 0x000fe20003f46070ULL,
0x0000000111177824ULL, 0x000fe200020e0606ULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x0ffffff811117812ULL, 0x000fe200078ef850ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000070c187212ULL, 0x000fc600078efcffULL,
0x000000012d057824ULL, 0x140fe200078e0250ULL, 0x000000070e0c7212ULL, 0x000fe200078efcffULL,
0x000000082d0a7824ULL, 0x000fe200078e00ffULL, 0x0000000918187210ULL, 0x000fe20007f9e0ffULL,
0x000000200b317836ULL, 0x000fe20000000000ULL, 0x000000090c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000001000e7824ULL, 0x000fe200078e0225ULL, 0xfffffff80a2f7812ULL, 0x000fe200078ee205ULL,
0x0000000131107824ULL, 0x000fe200078e0250ULL, 0x0000000863057c11ULL, 0x000fe2000f8e70ffULL,
0x0000000831337824ULL, 0x000fc400078e00ffULL, 0x000000010d197824ULL, 0x100fe200020e0606ULL,
0x000000042500720cULL, 0x000fe20003f86070ULL, 0x000020005c0a7824ULL, 0x000fe200078e0205ULL,
0xfffffff833337812ULL, 0x000fe200078ee210ULL, 0x000000010f0d7824ULL, 0x000fe400030e0606ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000020000a0a7836ULL, 0x000fe20000000000ULL,
0x000000070e1a7212ULL, 0x000fe200078efcffULL, 0x0000000100107824ULL, 0x000fe400078e0229ULL,
0x00000010111b7824ULL, 0x000fe200078e020aULL, 0x000000091a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000d901c46ULL, 0x00000001000e7824ULL, 0x000fe200078e022dULL,
0x0000000710107212ULL, 0x000fe200078efcffULL, 0x000000101d1d7824ULL, 0x000fe200078e020aULL,
0x000000042900720cULL, 0x000fe20003f66070ULL, 0x000000240b257836ULL, 0x000fc60000000000ULL,
0x00000000141d7faeULL, 0x0005e2000c901c46ULL, 0x00000001251c7824ULL, 0x000fe200078e0250ULL,
0x000000042d00720cULL, 0x000fe20003f26070ULL, 0x0000000825297824ULL, 0x000fe400078e00ffULL,
0x000000800e127825ULL, 0x002fc600078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee21cULL,
0x000000010f1b7824ULL, 0x000fe200030e0606ULL, 0x0000000712127212ULL, 0x000fe200078efcffULL,
0x00000001000e7824ULL, 0x000fe200078e0231ULL, 0x0000000910147210ULL, 0x004fe20007fde0ffULL,
0x000000101f1d7824ULL, 0x000fe400078e020aULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x0000000111157824ULL, 0x000fe200030e0606ULL,
0x0000000912127210ULL, 0x000fe20007fde0ffULL, 0x0000001021117824ULL, 0x000fe200078e020aULL,
0x000000043100720cULL, 0x080fe20003f06070ULL, 0x000000280b217836ULL, 0x000fe40000000000ULL,
0x0000002c0b2d7836ULL, 0x000fe20000000000ULL, 0x0000000018117faeULL, 0x0005e2000d101c46ULL,
0x0000000113137824ULL, 0x000fe200030e0606ULL, 0x000000042500720cULL, 0x000fe20003f46070ULL,
0x00000008211c7824ULL, 0x040fe200078e00ffULL, 0x000000070e167212ULL, 0x002fe200078efcffULL,
0x0000000121177824ULL, 0x000fc400078e0250ULL, 0x000000012d0e7824ULL, 0x040fe200078e0250ULL,
0x0000000916167210ULL, 0x000fe20007fde0ffULL, 0x000000082d1f7824ULL, 0x000fe400078e00ffULL,
0x0000000100107824ULL, 0x000fe200078e0225ULL, 0xfffffff81c257812ULL, 0x000fe200078ee217ULL,
0x00000010231d7824ULL, 0x000fe200078e020aULL, 0xfffffff81f237812ULL, 0x000fe200078ee20eULL,
0x000000010f177824ULL, 0x000fe400030e0606ULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x000000000c1d7faeULL, 0x0003e2000e901c46ULL, 0x000000042100720cULL, 0x000fc40003fa6070ULL,
0x0000000100107824ULL, 0x000fe200078e0221ULL, 0x000000070e187212ULL, 0x004fe200078efcffULL,
0x00000001000e7824ULL, 0x000fe400078e022dULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000918187210ULL, 0x000fc60007fde0ffULL, 0x00000010271f7824ULL, 0x000fe200078e020aULL,
0x00000007100c7212ULL, 0x002fe200078efcffULL, 0x000000010f197824ULL, 0x000fe400030e0606ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000090c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000001a1f7faeULL, 0x0003e2000e101c46ULL, 0x000000042d00720cULL, 0x000fe20003f86070ULL,
0x000000102b1d7824ULL, 0x000fe400078e020aULL, 0x000000300b0d7836ULL, 0x000fc40000000000ULL,
0x000000380b2b7836ULL, 0x000fe20000000000ULL, 0x00000000141d7faeULL, 0x0005e2000d901c46ULL,
0x000000080d1c7824ULL, 0x040fe200078e00ffULL, 0x000000040d00720cULL, 0x040fe20003f66070ULL,
0x0000000100107824ULL, 0x000fe200078e020dULL, 0x000000070e1a7212ULL, 0x002fe200078efcffULL,
0x000000010d1b7824ULL, 0x000fe400078e0250ULL, 0x00000001110d7824ULL, 0x000fe200030e0606ULL,
0x000000091a1a7210ULL, 0x000fe20007fde0ffULL, 0x000000102f1f7824ULL, 0x000fe200078e020aULL,
0xfffffff81c217812ULL, 0x000fe200078ee21bULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000121f7faeULL, 0x0003e2000c901c46ULL, 0x000000010f1b7824ULL, 0x000fe200030e0606ULL,
0x0000000710147212ULL, 0x004fe200078efcffULL, 0x000000340b0f7836ULL, 0x000fe40000000000ULL,
0x0000003c0b0b7836ULL, 0x000fe20000000000ULL, 0x0000000914147210ULL, 0x000fe20007fde0ffULL,
0x00000001000e7824ULL, 0x000fe200078e020fULL, 0x000000040f00720cULL, 0x040fe20003f26070ULL,
0x000000010f107824ULL, 0x040fe400078e0250ULL, 0x000000080f277824ULL, 0x000fc400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee210ULL,
0x0000000100107824ULL, 0x000fe200078e022bULL, 0x000000070e127212ULL, 0x002fe200078efcffULL,
0x0000000111157824ULL, 0x000fe400030e0606ULL, 0x00000010331d7824ULL, 0x000fe200078e020aULL,
0x0000000912127210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x00000010291f7824ULL, 0x000fe200078e020aULL,
0x0000000710107212ULL, 0x080fe200078efcffULL, 0x00000001000e7824ULL, 0x000fe200078e020bULL,
0x000000040b00720cULL, 0x080fe20003f06070ULL, 0x000000010f137824ULL, 0x000fe200030e0606ULL,
0x00000000181f7faeULL, 0x0005e2000d101c46ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000042b00720cULL, 0x040fe40003f46070ULL, 0x0000000910107210ULL, 0x000fe20007fde0ffULL,
0x000000012b047824ULL, 0x040fe200078e0250ULL, 0x000000500b167210ULL, 0x002fe20007ffe0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7212ULL, 0x000fe200078efcffULL,
0x000000080b1d7824ULL, 0x000fc400078e00ffULL, 0x0000000111117824ULL, 0x000fe200030e0606ULL,
0xfffffff82b197812ULL, 0x004fe200078ee204ULL, 0x0000001025077824ULL, 0x100fe200078e020aULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL, 0x00000010210b7824ULL, 0x100fe200078e020aULL,
0x000000090e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000001023097824ULL, 0x100fe200078e020aULL,
0x000000000c077faeULL, 0x0003e2000e901c46ULL, 0x0000001027177824ULL, 0x100fe400078e020aULL,
0x0000001019197824ULL, 0x100fe200078e020aULL, 0x000000001a097faeULL, 0x0003e2000e101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e020aULL, 0x000000010f0f7824ULL, 0x000fe200030e0606ULL,
0x00000000140b7faeULL, 0x0003e8000d901c46ULL, 0x0000000012177faeULL, 0x0003e8000c901c46ULL,
0x0000000010197faeULL, 0x0003e8000d101c46ULL, 0x000000000e1d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x0000001050137811ULL, 0x044fe400078fe8ffULL,
0x0000001c501d7811ULL, 0x040fe400078fe8ffULL, 0x00000004500d7811ULL, 0x040fe200078fe8ffULL,
0x0000000113067824ULL, 0x140fe200078e0250ULL, 0x0000002850317811ULL, 0x040fe200078fe8ffULL,
0x0000000813217824ULL, 0x000fe200078e00ffULL, 0x0000000c50117811ULL, 0x040fe200078fe8ffULL,
0x000000081d277824ULL, 0x000fe200078e00ffULL, 0x00000008500f7811ULL, 0x040fe200078fe8ffULL,
0x000000010d047824ULL, 0x100fe200078e0250ULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x000000011d067824ULL, 0x100fe200078e0250ULL, 0x0000003450377811ULL, 0x040fe200078fe8ffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0x0000001850177811ULL, 0x040fe200078fe8ffULL,
0x0000000831397824ULL, 0x040fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee206ULL,
0x0000000131067824ULL, 0x100fe200078e0250ULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x0000000111057824ULL, 0x140fe200078e0250ULL, 0x0000001450157811ULL, 0x040fe200078fe8ffULL,
0x00000008110a7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee206ULL,
0x000000010f047824ULL, 0x140fe200078e0250ULL, 0x0000003850497811ULL, 0x040fe200078fe8ffULL,
0x000000080f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a1f7812ULL, 0x000fe200078ee205ULL,
0x0000000137067824ULL, 0x140fe200078e0250ULL, 0x00000024502d7811ULL, 0x040fe200078fe8ffULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL,
0x0000000117057824ULL, 0x140fe200078e0250ULL, 0x00000020502b7811ULL, 0x040fe200078fe8ffULL,
0x00000008170a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL,
0x0000000115047824ULL, 0x140fe200078e0250ULL, 0x0000003050357811ULL, 0x040fe200078fe8ffULL,
0x0000000815237824ULL, 0x000fe200078e00ffULL, 0xfffffff80a257812ULL, 0x000fe200078ee205ULL,
0x0000000149067824ULL, 0x140fe200078e0250ULL, 0x0000002c50337811ULL, 0x040fe200078fe8ffULL,
0x0000000849417824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x000000012d057824ULL, 0x140fe200078e0250ULL, 0x0000003c504b7811ULL, 0x040fe200078fe8ffULL,
0x000000082d0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee206ULL,
0x000000012b047824ULL, 0x140fe200078e0250ULL, 0x00009000ff067b82ULL, 0x000e620000000a00ULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0xfffffff80a2f7812ULL, 0x000fe200078ee205ULL,
0x0000000135057824ULL, 0x140fe200078e0250ULL, 0x00000000500b7211ULL, 0x000fe200078fe8ffULL,
0x00000008350a7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee204ULL,
0x0000000133047824ULL, 0x000fc400078e0250ULL, 0x00000008333b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3d7812ULL, 0x000fe200078ee205ULL, 0x000000014b0a7824ULL, 0x000fe200078e0250ULL,
0x0000000863057c11ULL, 0x000fe2000f8e70ffULL, 0x000000084b437824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL, 0x00000001000d7824ULL, 0x000fe200078e020dULL,
0x0000005050047211ULL, 0x000fe200078fe8ffULL, 0x00000001000f7824ULL, 0x000fe200078e020fULL,
0xfffffff843437812ULL, 0x000fe200078ee20aULL, 0x00000010500a7824ULL, 0x000fe200078e00ffULL,
0x0000000704097812ULL, 0x000fe200078ec0ffULL, 0x000020005c047824ULL, 0x000fc400078e0205ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0ffffff809097812ULL, 0x000fe400078ef850ULL,
0x000000700a457812ULL, 0x000fe200078ec0ffULL, 0x00002000040c7836ULL, 0x000fe20000000000ULL,
0x000000067d477211ULL, 0x002fe200078038ffULL, 0x000000800b0a7825ULL, 0x000fc600078e00ffULL,
0x000000077d7d7211ULL, 0x000fe200000f3cffULL, 0x0000001009097824ULL, 0x100fe200078e020cULL,
0x000000450a067212ULL, 0x000fe200078efcffULL, 0x0000001019197824ULL, 0x100fe400078e020cULL,
0x000000101b1b7824ULL, 0x100fe200078e020cULL, 0x0000000647067210ULL, 0x000fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe400078e020cULL, 0x0000001021217824ULL, 0x100fe400078e020cULL,
0x0000001023237824ULL, 0x000fc400078e020cULL, 0x0000001025257824ULL, 0x100fe400078e020cULL,
0x0000001027277824ULL, 0x100fe400078e020cULL, 0x0000001029297824ULL, 0x100fe400078e020cULL,
0x000000102f047824ULL, 0x100fe400078e020cULL, 0x0000001039397824ULL, 0x100fe400078e020cULL,
0x000000103b3b7824ULL, 0x000fc400078e020cULL, 0x000000103d3d7824ULL, 0x100fe400078e020cULL,
0x000000103f3f7824ULL, 0x100fe400078e020cULL, 0x0000001041417824ULL, 0x100fe400078e020cULL,
0x0000001043437824ULL, 0x000fe400078e020cULL, 0x000000800d0c7825ULL, 0x000fc800078e00ffULL,
0x0000000100117824ULL, 0x000fe200078e0211ULL, 0x000000450c0a7212ULL, 0x080fe200078efcffULL,
0x0000000100137824ULL, 0x000fe200078e0213ULL, 0x000000450e0c7212ULL, 0x000fe200078efcffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x0000000a470a7210ULL, 0x000fc60007f3e0ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x00000045100e7212ULL, 0x000fc600078efcffULL,
0x000000010b077824ULL, 0x000fe200000e067dULL, 0x0000000c470c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100157824ULL, 0x000fe200078e0215ULL, 0x0000004512107212ULL, 0x000fe200078efcffULL,
0x0000000100177824ULL, 0x040fe200078e0217ULL, 0x0000000e470e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001001d7824ULL, 0x040fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000b901c46ULL, 0x00000001002b7824ULL, 0x000fe400078e022bULL,
0x0000008015147825ULL, 0x000fc800078e00ffULL, 0x000000010d0b7824ULL, 0x000fe200008e067dULL,
0x0000004514127212ULL, 0x000fe200078efcffULL, 0x0000008017167825ULL, 0x000fc600078e00ffULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000010f0d7824ULL, 0x100fe200000e067dULL,
0x0000001047107210ULL, 0x000fe20007f1e0ffULL, 0x000000801d1c7825ULL, 0x000fe200078e00ffULL,
0x0000004516147212ULL, 0x080fe400078efcffULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x000000802b2a7825ULL, 0x000fe200078e00ffULL, 0x000000451c167212ULL, 0x080fe400078efcffULL,
0x0000001447147210ULL, 0x000fe20007f3e0ffULL, 0x00000001110f7824ULL, 0x100fe200010e067dULL,
0x000000452a1c7212ULL, 0x000fe200078efcffULL, 0x0000000113117824ULL, 0x000fe200000e067dULL,
0x0000001247127210ULL, 0x000fe20007f1e0ffULL, 0x00000001002a7824ULL, 0x040fe200078e022dULL,
0x0000001647167210ULL, 0x000fe20007f5e0ffULL, 0x00000001002c7824ULL, 0x000fe200078e0231ULL,
0x0000001c471c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000115137824ULL, 0x100fe200000e067dULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000000117157824ULL, 0x000fc400008e067dULL,
0x000000011d177824ULL, 0x000fe200010e067dULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x00000001002e7824ULL, 0x040fe400078e0233ULL, 0x000000012b1d7824ULL, 0x000fe200018e067dULL,
0x0000000012237faeULL, 0x0003e2000b901c46ULL, 0x0000000100307824ULL, 0x040fe400078e0235ULL,
0x0000000100327824ULL, 0x000fe200078e0237ULL, 0x0000000014257faeULL, 0x0003e2000b901c46ULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000000016277faeULL, 0x0003e2000b901c46ULL,
0x0000000100347824ULL, 0x000fe200078e0249ULL, 0x000000452a2a7212ULL, 0x080fe200078efcffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000001c297faeULL, 0x0003e4000b901c46ULL,
0x0000002a472a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000100367824ULL, 0x000fe200078e024bULL,
0x000000452c2c7212ULL, 0x000fe200078efcffULL, 0x000000802e2e7825ULL, 0x000fc600078e00ffULL,
0x0000002c472c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000452e2e7212ULL, 0x000fc600078efcffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000004530307212ULL, 0x080fe400078efcffULL, 0x0000002e472e7210ULL, 0x000fe20007f5e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004532327212ULL, 0x080fe400078efcffULL,
0x0000003047307210ULL, 0x000fe20007f7e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004534347212ULL, 0x080fe400078efcffULL, 0x0000003247327210ULL, 0x000fe20007f9e0ffULL,
0x000000012b2b7824ULL, 0x100fe200000e067dULL, 0x0000004536367212ULL, 0x000fe200078efcffULL,
0x000000012d2d7824ULL, 0x100fe200008e067dULL, 0x0000003447347210ULL, 0x000fe20007fbe0ffULL,
0x000000012f2f7824ULL, 0x100fe200010e067dULL, 0x0000003647367210ULL, 0x000fe20007fde0ffULL,
0x0000000131317824ULL, 0x100fe200018e067dULL, 0x000000002a047faeULL, 0x0003e2000b901c46ULL,
0x0000000133337824ULL, 0x000fc400020e067dULL, 0x0000000135357824ULL, 0x100fe200028e067dULL,
0x000000002c397faeULL, 0x0003e2000b901c46ULL, 0x0000000137377824ULL, 0x000fc600030e067dULL,
0x000000002e3b7faeULL, 0x0003e8000b901c46ULL, 0x00000000303d7faeULL, 0x0003e8000b901c46ULL,
0x00000000323f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034417faeULL, 0x0003e8000b901c46ULL,
0x0000000036437faeULL, 0x0003e4000b901c46ULL, 0x000000047f7f7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7d7424ULL, 0x000fc600078e00ffULL,
0x000000747f00720cULL, 0x000fda0003f06070ULL, 0x00009200ff0a8b82ULL, 0x002e620000000a00ULL,
0x0000000279078824ULL, 0x000fe200078e027fULL, 0x00000008505b7812ULL, 0x040fe200078ec0ffULL,
0x0000002050717836ULL, 0x000fe20000000000ULL, 0xfffffff850097812ULL, 0x000fe200078ec0ffULL,
0x00002000085a7824ULL, 0x000fe200078e0205ULL, 0x00000004ff587819ULL, 0x000fe20000011650ULL,
0x000000ffff737224ULL, 0x000fe200078e00ffULL, 0x0000000750597812ULL, 0x000fe400078ec0ffULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000004070a8825ULL, 0x002fe200078e000aULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000060a7d8981ULL, 0x000322000c1e1900ULL, 0xfffffff871717812ULL, 0x000fc400078ec0ffULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x000000075b5b7812ULL, 0x000fe400078ef850ULL,
0x0000000000047805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fc4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000020005a5a7836ULL, 0x000fe20000000000ULL, 0x0000000709727812ULL, 0x000fe200078ef850ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000771717812ULL, 0x000fe400078ef850ULL,
0x000000105b537812ULL, 0x002fce00078efcffULL, 0x0000000172087824ULL, 0x140fe400078e0273ULL,
0x0000000872097824ULL, 0x000fe400078e00ffULL, 0x00000001710c7824ULL, 0x040fe400078e0273ULL,
0x00000008710d7824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x0000000273947824ULL, 0x000fe400078e0258ULL, 0x0000000871817824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x0000001009097824ULL, 0x000fc400078e025aULL,
0x00000010539f7824ULL, 0x000fe400078e00ffULL, 0x000000100d0d7824ULL, 0x000fe400078e025aULL,
0x000000000908783bULL, 0x000e680000000200ULL, 0x000000000d0c783bULL, 0x000ea20000000200ULL,
0x00000018ff4c7819ULL, 0x002fe20000011408ULL, 0x00010000084d7824ULL, 0x040fe200078e00ffULL,
0x00008880084e7816ULL, 0x040fe200000000ffULL, 0x0001000009547824ULL, 0x000fe200078e00ffULL,
0x0000000808087819ULL, 0x000fc400000006ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011409ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00008880096c7816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144dULL, 0x00000018ff6f7819ULL, 0x000fe2000001140aULL,
0x00000008004d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff097819ULL, 0x000fc40000011409ULL,
0x000088800a6e7816ULL, 0x040fe400000000ffULL, 0x00000018ff657819ULL, 0x000fe4000001140bULL,
0x000088800b647816ULL, 0x000fe200000000ffULL, 0x00000009009e7306ULL, 0x0007e20000200c00ULL,
0x000100000a087824ULL, 0x042fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x000001000a0a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x004fe4000001140cULL,
0x00000018ff087819ULL, 0x000fc40000011408ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x000100000b097824ULL, 0x048fe200078e00ffULL, 0x00000054009d7306ULL, 0x0003e20000200c00ULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x000088800c667816ULL, 0x000fe400000000ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000000a009c7306ULL, 0x0005e20000200c00ULL, 0x0000000872547824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc4000001140dULL, 0x000088800d687816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001140eULL, 0x0000000900997306ULL, 0x0003e20000200c00ULL,
0x00000001730a7836ULL, 0x004fe20000000000ULL, 0x00000018ff617819ULL, 0x000fe2000001140fULL,
0x0000000273737836ULL, 0x000fe20000000000ULL, 0x000088800e6a7816ULL, 0x000fe400000000ffULL,
0x000088800f607816ULL, 0x000fc400000000ffULL, 0x0000000b008e7306ULL, 0x0005e20000200c00ULL,
0x0000000172097824ULL, 0x102fe200078e020aULL, 0x000000087300780cULL, 0x000fe20003f05270ULL,
0x00000001710a7824ULL, 0x000fca00078e020aULL, 0x0000000800837306ULL, 0x0003e20000200c00ULL,
0xfffffff8540b7812ULL, 0x004fe200078ee209ULL, 0x000100000d097824ULL, 0x040fe200078e00ffULL,
0xfffffff881817812ULL, 0x000fe200078ee20aULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x000000100b0b7824ULL, 0x000fe200078e025aULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000100000c087824ULL, 0x042fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000000000b54783bULL, 0x000e620000000200ULL,
0x000001000c0c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x0000000d00987306ULL, 0x0005e20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000000c00907306ULL, 0x0007e20000200c00ULL, 0x000000105b0d7824ULL, 0x004fce00078e00ffULL,
0x0000000800977306ULL, 0x0005e20000200c00ULL, 0x000100000f0c7824ULL, 0x048fe400078e00ffULL,
0x000001000f0f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x0000000900957306ULL, 0x0007e20000200c00ULL, 0x000100000e087824ULL, 0x044fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x000001000e0e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff917819ULL, 0x000fe40000011408ULL, 0x0000000c00937306ULL, 0x0005e20000200c00ULL,
0x0000001081097824ULL, 0x008fe200078e025aULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0001000055857824ULL, 0x002fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011454ULL,
0x00008880548c7816ULL, 0x000fe200000000ffULL, 0x000000000908783bULL, 0x000e620000000200ULL,
0x00000018ff847819ULL, 0x000fe20000011455ULL, 0x000000015b0c7824ULL, 0x004fe200078e0294ULL,
0x0000888055887816ULL, 0x040fe200000000ffULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x0000010055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011456ULL,
0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL, 0x00010000540d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011455ULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0x000000080c0c7c11ULL, 0x000fe2000f8e20ffULL, 0x0001000056557824ULL, 0x000fe200078e00ffULL,
0x0000000e00967306ULL, 0x000fe20000200c00ULL, 0x00000018ff8f7819ULL, 0x000fe4000001140dULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff877819ULL, 0x000fc40000011455ULL,
0x0000888056867816ULL, 0x040fe200000000ffULL, 0x00000054008d7306ULL, 0x0007e20000200c00ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fca0000011457ULL, 0x0000000f00927306ULL, 0x000be20000200c00ULL,
0x0000000153547824ULL, 0x008fe400078e0294ULL, 0x0000000294947836ULL, 0x000fc60000000000ULL,
0xfffffff09f557812ULL, 0x000fe400078ee254ULL, 0x000054104e547816ULL, 0x004fe2000000004fULL,
0x000000000c0c783bULL, 0x020ea20000000200ULL, 0x00000008554e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x000054104d557816ULL, 0x000fe4000000004cULL,
0x00000018ff807819ULL, 0x002fe40000011408ULL, 0x000000004e4c783bULL, 0x000e620000000200ULL,
0x00000018ff7e7819ULL, 0x000fc40000011409ULL, 0x0000006d006d7306ULL, 0x000f620000200c00ULL,
0x00000018ff7c7819ULL, 0x000fe4000001140aULL, 0x00000018ff7a7819ULL, 0x000fe4000001140bULL,
0x000054106e6e7816ULL, 0x008fc60000000083ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x000054109e6d7816ULL, 0x020fce000000006dULL, 0x0000006500657306ULL, 0x000f620000200c00ULL,
0x000054109c6f7816ULL, 0x008fce000000006fULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x000000540c48723cULL, 0x004fe20000001848ULL, 0x000054108e657816ULL, 0x020fcc0000000065ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000006e0c40723cULL, 0x000fe20000001840ULL,
0x0000541090677816ULL, 0x008fcc0000000067ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x000000544c28723cULL, 0x002fe20000001828ULL, 0x0000541098697816ULL, 0x004fcc0000000069ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x0000006e4c20723cULL, 0x000fe20000001820ULL,
0x00005410966b7816ULL, 0x008fcc000000006bULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541092617816ULL, 0x002fce0000000061ULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x000054106c6c7816ULL, 0x004fce000000009dULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x00010000579d7824ULL, 0x000fe200078e00ffULL, 0x0000006c0c44723cULL, 0x000fe20000001844ULL,
0x0000541064647816ULL, 0x002fca0000000099ULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x00000018ff9d7819ULL, 0x000fe2000001149dULL, 0x0000006c4c24723cULL, 0x000fe20000001824ULL,
0x0000541066667816ULL, 0x004fca0000000097ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000000640c3c723cULL, 0x000fe2000000183cULL, 0x0000541068687816ULL, 0x002fcc0000000095ULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x000000660c38723cULL, 0x000fec0000001838ULL,
0x000000680c34723cULL, 0x000fe20000001834ULL, 0x0000006000607306ULL, 0x000eaa0000200c00ULL,
0x000000664c18723cULL, 0x000fe20000001818ULL, 0x000054106a6a7816ULL, 0x002fc40000000091ULL,
0x00000085008b7306ULL, 0x0003e60000200c00ULL, 0x000000644c1c723cULL, 0x000fe2000000181cULL,
0x0000541060607816ULL, 0x004fc80000000093ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff857819ULL, 0x002fe20000011456ULL, 0x0000006a0c30723cULL, 0x000fe20000001830ULL,
0x0000888057567816ULL, 0x040fe200000000ffULL, 0x0000010057577824ULL, 0x000fc800078e00ffULL,
0x0000005600837306ULL, 0x0003e20000200c00ULL, 0x000000600c2c723cULL, 0x000fe2000000182cULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x000000684c14723cULL, 0x000fe20000001814ULL,
0x00008880090c7816ULL, 0x000fe200000000ffULL, 0x000000105b0d7824ULL, 0x000fe200078e00ffULL,
0x0000888008567816ULL, 0x002fe200000000ffULL, 0x0000005700907306ULL, 0x000fe20000200c00ULL,
0x000088800a0e7816ULL, 0x000fe200000000ffULL, 0x000000ffff6c7224ULL, 0x000fe200078e000cULL,
0x0000006a4c10723cULL, 0x000fe20000001810ULL, 0x000000ffff917224ULL, 0x000fe200078e0056ULL,
0x000088800b687816ULL, 0x000fe200000000ffULL, 0x0001000008567824ULL, 0x000fc400078e00ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x000000604c04723cULL, 0x000fe20000001804ULL,
0x00010000090c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011408ULL,
0x000000015b087824ULL, 0x000fe200078e0294ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000000153947824ULL, 0x040fe200078e0294ULL, 0x0000005600927306ULL, 0x0003e20000200c00ULL,
0x000000ffff667224ULL, 0x000fe200078e000eULL, 0xfffffff00d087812ULL, 0x000fe200078ee208ULL,
0x00000010530d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x000001000b4c7824ULL, 0x000fe200078e00ffULL, 0x0000000808087c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff00d947812ULL, 0x000fe200078ee294ULL, 0x0000000c006d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe2000001144cULL, 0x000000000854783bULL, 0x0022ec0000000200ULL,
0x0000000900657306ULL, 0x000be20000200c00ULL, 0x00000008940c7c11ULL, 0x004fe2000f8e20ffULL,
0x000100000a087824ULL, 0x002fc400078e00ffULL, 0x000001000a0a7824ULL, 0x000fc600078e00ffULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x000100000b097824ULL, 0x020fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000006600667306ULL, 0x000fe60000200c00ULL, 0x00000018ff6b7819ULL, 0x000fca0000011409ULL,
0x0000000800677306ULL, 0x000eb00000200c00ULL, 0x0000000a00697306ULL, 0x000f620000200c00ULL,
0x0000541066667816ULL, 0x004fce0000000067ULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x0000541069677816ULL, 0x020fce000000007cULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000000665430723cULL, 0x008fe20000001830ULL, 0x000054108d097816ULL, 0x004fcc000000008aULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000000660c10723cULL, 0x002fee0000001810ULL,
0x0000008100817306ULL, 0x000e700000200c00ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x00005410904f7816ULL, 0x002fce0000000081ULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000007eULL,
0x0000008c008c7306ULL, 0x000ff00000200c00ULL, 0x0000008f008f7306ULL, 0x000e700000200c00ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x000054108c087816ULL, 0x002fce000000008fULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x000000085448723cULL, 0x000fe20000001848ULL,
0x00005410880a7816ULL, 0x004fcc000000008bULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000000080c28723cULL, 0x000fe20000001828ULL, 0x00005410890b7816ULL, 0x002fcc0000000084ULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x0000000a5444723cULL, 0x000fee0000001844ULL,
0x0000008500857306ULL, 0x000ea20000200c00ULL, 0x0000000a0c24723cULL, 0x000fe20000001824ULL,
0x00005410864c7816ULL, 0x002fcc0000000087ULL, 0x0000009d008e7306ULL, 0x000fe20000200c00ULL,
0x00005410854d7816ULL, 0x004fce0000000082ULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000004c5440723cULL, 0x000fee0000001840ULL, 0x0000009300937306ULL, 0x000ea20000200c00ULL,
0x0000004c0c20723cULL, 0x000fe20000001820ULL, 0x0000541091607816ULL, 0x002fcc0000000092ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x0000541093617816ULL, 0x004fce0000000080ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000605438723cULL, 0x000fe20000001838ULL,
0x000054106c647816ULL, 0x002fcc000000006dULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000000600c18723cULL, 0x000fee0000001818ULL, 0x0000004e006f7306ULL, 0x0004e20000200c00ULL,
0x000000645434723cULL, 0x000fe20000001834ULL, 0x0000541068687816ULL, 0x002fca000000006bULL,
0x000000640c14723cULL, 0x000fe20000001814ULL, 0x00005410834e7816ULL, 0x004fe4000000008eULL,
0x000054106f697816ULL, 0x008fca000000007aULL, 0x0000004e543c723cULL, 0x000fec000000183cULL,
0x00000068542c723cULL, 0x000fec000000182cULL, 0x0000004e0c1c723cULL, 0x000fec000000181cULL,
0x000000680c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00b80947ULL, 0x000fde000383ffffULL, 0x00000001ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000007048097220ULL, 0x080fe20000410000ULL, 0x0000007049497220ULL, 0x080fe20000410000ULL,
0x000000704a4a7220ULL, 0x080fe20000410000ULL, 0x000000704b4b7220ULL, 0x080fe20000410000ULL,
0x0000007044447220ULL, 0x080fe20000410000ULL, 0x01a6880f520e79a7ULL, 0x000262000850003fULL,
0x0000007045457220ULL, 0x080fe20000410000ULL, 0x0000007046467220ULL, 0x080fe20000410000ULL,
0x0000007047477220ULL, 0x080fe20000410000ULL, 0x0000007040407220ULL, 0x080fe20000410000ULL,
0x0000007041417220ULL, 0x080fe20000410000ULL, 0x0000007042427220ULL, 0x080fe20000410000ULL,
0x0000007043437220ULL, 0x080fe20000410000ULL, 0x000000703c3c7220ULL, 0x080fe20000410000ULL,
0x000000703d3d7220ULL, 0x080fe20000410000ULL, 0x000000703e3e7220ULL, 0x080fe20000410000ULL,
0x000000703f3f7220ULL, 0x080fe20000410000ULL, 0x0000007038387220ULL, 0x080fe20000410000ULL,
0x0000007039397220ULL, 0x080fe20000410000ULL, 0x000000703a3a7220ULL, 0x080fe20000410000ULL,
0x000000703b3b7220ULL, 0x080fe20000410000ULL, 0x0000007034347220ULL, 0x080fe20000410000ULL,
0x0000007035357220ULL, 0x080fe20000410000ULL, 0x0000007036367220ULL, 0x080fe20000410000ULL,
0x0000007037377220ULL, 0x080fe20000410000ULL, 0x0000007030307220ULL, 0x080fe20000410000ULL,
0x0000007031317220ULL, 0x080fe20000410000ULL, 0x0000007032327220ULL, 0x080fe20000410000ULL,
0x0000007033337220ULL, 0x080fe20000410000ULL, 0x000000702c2c7220ULL, 0x080fe20000410000ULL,
0x000000702d2d7220ULL, 0x080fe20000410000ULL, 0x000000702e2e7220ULL, 0x080fe20000410000ULL,
0x000000702f2f7220ULL, 0x080fe20000410000ULL, 0x00000070280b7220ULL, 0x080fe20000410000ULL,
0x0000007029297220ULL, 0x080fe20000410000ULL, 0x000000702a2a7220ULL, 0x080fe20000410000ULL,
0x000000702b2b7220ULL, 0x080fe20000410000ULL, 0x0000007024247220ULL, 0x080fe20000410000ULL,
0x0000007025257220ULL, 0x080fe20000410000ULL, 0x0000007026267220ULL, 0x080fe20000410000ULL,
0x0000007027277220ULL, 0x080fe20000410000ULL, 0x0000007020207220ULL, 0x080fe20000410000ULL,
0x0000007021217220ULL, 0x080fe20000410000ULL, 0x0000007022227220ULL, 0x080fe20000410000ULL,
0x0000007023237220ULL, 0x080fe20000410000ULL, 0x000000701c1c7220ULL, 0x080fe20000410000ULL,
0x000000701d1d7220ULL, 0x080fe20000410000ULL, 0x000000701e1e7220ULL, 0x080fe20000410000ULL,
0x000000701f1f7220ULL, 0x080fe20000410000ULL, 0x0000007018187220ULL, 0x080fe20000410000ULL,
0x0000007019197220ULL, 0x080fe20000410000ULL, 0x000000701a1a7220ULL, 0x080fe20000410000ULL,
0x000000701b1b7220ULL, 0x080fe20000410000ULL, 0x0000007014147220ULL, 0x080fe20000410000ULL,
0x0000007015157220ULL, 0x080fe20000410000ULL, 0x0000007016167220ULL, 0x080fe20000410000ULL,
0x0000007017177220ULL, 0x080fe20000410000ULL, 0x0000007010107220ULL, 0x080fe20000410000ULL,
0x0000007011117220ULL, 0x080fe20000410000ULL, 0x0000007012127220ULL, 0x080fe20000410000ULL,
0x0000007013137220ULL, 0x080fe20000410000ULL, 0x0000007004087220ULL, 0x080fe20000410000ULL,
0x00000070050a7220ULL, 0x080fe20000410000ULL, 0x00000070060c7220ULL, 0x080fe20000410000ULL,
0x00000070070d7220ULL, 0x002fce0000410000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x01a6880f520075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff287224ULL, 0x000fce00078e00ffULL, 0x000000102800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004064d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e07ULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000128287836ULL, 0x000fce0000000000ULL, 0x01a6880f520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000450047824ULL, 0x000fe200078e00ffULL,
0x0000000863057c11ULL, 0x000fe4000f8e38ffULL, 0x0000005f7800720cULL, 0x000fe40003f06070ULL,
0xfffffff004047812ULL, 0x000fca00078ec0ffULL, 0x00000001050e7824ULL, 0x000fca00078e0204ULL,
0x01a400000e047984ULL, 0x0002a20000000c00ULL, 0x0000002000648947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x0000000400487d06ULL, 0x000ee20008209000ULL, 0x00000075500f7211ULL, 0x000fe200078ff0ffULL,
0x0000010078b17824ULL, 0x000fe400078e0251ULL, 0x0000000250ae7824ULL, 0x000fe400078e00ffULL,
0x000000080f287836ULL, 0x000fc60000000000ULL, 0x00000006aeae7812ULL, 0x000fca00078ec0ffULL,
0x00000001aeaf7824ULL, 0x000fe200078e0203ULL, 0x0000004800487308ULL, 0x008ee40000001000ULL,
0x0ffffffe484e7836ULL, 0x008fcc0000000000ULL, 0x0000004e004d7305ULL, 0x000ee4000021f000ULL,
0x000000ffff4f7224ULL, 0x008fc800078e0a4dULL, 0x000000044f4f7c24ULL, 0x000fc8000f8e02ffULL,
0x0000004f4d567227ULL, 0x000fc800078e004cULL, 0x000000100f4d7836ULL, 0x000fe40000000000ULL,
0x00000028564c7227ULL, 0x000fc800078e00ffULL, 0x0000000f56487227ULL, 0x000fc800078e00ffULL,
0x000000ffff537224ULL, 0x000fe400078e0a4cULL, 0x000000ffff547224ULL, 0x000fe400078e0a48ULL,
0x000000180f4f7836ULL, 0x000fe40000000000ULL, 0x0000000453287c24ULL, 0x000fe4000f8e0228ULL,
0x00000004540f7c24ULL, 0x000fe4000f8e020fULL, 0x0000004d564e7227ULL, 0x000fe200078e00ffULL,
0x0000000428007c0cULL, 0x000fc4000bf06070ULL, 0x000000040f007c0cULL, 0x000fe2000bfa6070ULL,
0x0000004f56537227ULL, 0x000fc800078e00ffULL, 0x000000ffff567224ULL, 0x000fe400078e0a4eULL,
0x000000ffff547224ULL, 0x000fe400078e0a53ULL, 0x00000004564d7c24ULL, 0x000fe4000f8e024dULL,
0x00000004544f7c24ULL, 0x000fe4000f8e024fULL, 0x8000000428280c36ULL, 0x000fe20008000000ULL,
0x000000044d007c0cULL, 0x000fe2000bf46070ULL, 0x800000040f0f5c36ULL, 0x000fe20008000000ULL,
0x000000044f007c0cULL, 0x000fe2000bf66070ULL, 0x000000014c4c0836ULL, 0x000fe20000000000ULL,
0x0000000428007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000148485836ULL, 0x000fe20000000000ULL,
0x000000040f007c0cULL, 0x000fc4000bf86070ULL, 0x000000b176287248ULL, 0x000fca0007fe0000ULL,
0x800000044d4d2c36ULL, 0x000fe40008000000ULL, 0x800000044f4f3c36ULL, 0x000fe40008000000ULL,
0x0000000128b17824ULL, 0x000fe200078e0ab1ULL, 0x000000044d007c0cULL, 0x000fe2000bf26070ULL,
0x000000014c4c6836ULL, 0x000fe20000000000ULL, 0x000000044f007c0cULL, 0x000fe2000bf06070ULL,
0x0000000148484836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x000000015d287824ULL, 0x000fe200078e02aeULL, 0x00000004ff4f7c12ULL, 0x000fe2000f8e33ffULL,
0x000000ffff937224ULL, 0x000fe200078e0ab1ULL, 0x000000b1af00720cULL, 0x080fe20003f86070ULL,
0x000000014e4e2836ULL, 0x000fe20000000000ULL, 0x000000484f0f7207ULL, 0x040fe20007000000ULL,
0x0000000153533836ULL, 0x000fe20000000000ULL, 0x000000b12800720cULL, 0x000fe20003fa6070ULL,
0x000000014e4e1836ULL, 0x000fe20000000000ULL, 0x0000009328287246ULL, 0x000fe2000380005eULL,
0x0000000153530836ULL, 0x000fe20000000000ULL, 0x0000004c4f4d7207ULL, 0x000fc40007000000ULL,
0x0000000f5e0f7248ULL, 0x000fe40003fe0000ULL, 0x00000093af987246ULL, 0x000fe4000380005eULL,
0x00000004ff287819ULL, 0x000fe20000011628ULL, 0x000000050f8d7c24ULL, 0x000fe2000f8e02ffULL,
0x0000004d5e4d7248ULL, 0x000fe40003fe0000ULL, 0x000000ff98987207ULL, 0x000fe40002000000ULL,
0x000000ff28287207ULL, 0x000fe20002800000ULL, 0x000000054d877c24ULL, 0x000fe2000f8e02ffULL,
0x0000004e4f0f7207ULL, 0x000fc40007000000ULL, 0x0000008d984d7211ULL, 0x000fe200078fe0ffULL,
0x000000018d5b7824ULL, 0x000fe200078e0228ULL, 0x000000534f537207ULL, 0x000fe20007000000ULL,
0x0000000128577824ULL, 0x000fe200078e0287ULL, 0x0000000f5e0f7248ULL, 0x000fe20003fe0000ULL,
0x000000025b5a7825ULL, 0x000fe200078e009aULL, 0x000000535e537248ULL, 0x000fc60003fe0000ULL,
0x000000024d4c7825ULL, 0x000fe200078e009aULL, 0x000000065aad7981ULL, 0x0044e6000c1e9500ULL,
0x000000050f8b7c24ULL, 0x000fe2000f8e02ffULL, 0x000000064cac7981ULL, 0x000ae2000c1e9500ULL,
0x0000000553557c24ULL, 0x000fe2000f8e02ffULL, 0x00000087984f7211ULL, 0x000fe200078fe0ffULL,
0x0000000128657824ULL, 0x000fe200078e028bULL, 0x0000008b98617211ULL, 0x000fe200078fe0ffULL,
0x0000000257567825ULL, 0x000fe200078e009aULL, 0x00000010ae8c7812ULL, 0x000fc400078efcffULL,
0x00000055980f7211ULL, 0x000fe200078fe0ffULL, 0x000000024f4e7825ULL, 0x100fe400078e009aULL,
0x0000000656567981ULL, 0x000ee4000c1e9500ULL, 0x0000000265647825ULL, 0x100fe400078e009aULL,
0x000000064e4f7981ULL, 0x000ee4000c1e9500ULL, 0x0000000261607825ULL, 0x000fc800078e009aULL,
0x0000000128537824ULL, 0x000fe200078e0255ULL, 0x0000000660867981ULL, 0x000ee2000c1e9500ULL,
0x000000015d287824ULL, 0x000fe400078e028cULL, 0x000000020f5a7825ULL, 0x004fe400078e009aULL,
0x00000006640f7981ULL, 0x000ea2000c1e9500ULL, 0x0000009328487246ULL, 0x000fe2000380005eULL,
0x000000018c737824ULL, 0x000fe200078e0203ULL, 0x000000b12800720cULL, 0x080fe20003f26070ULL,
0x00000002534c7825ULL, 0x022fe200078e009aULL, 0x00000004ff487819ULL, 0x000fe20000011648ULL,
0x000000065a547981ULL, 0x000362000c1e9500ULL, 0x000000b17300720cULL, 0x000fc40003f06070ULL,
0x00000093739e7246ULL, 0x000fe2000380005eULL, 0x000000064c4d7981ULL, 0x000362000c1e9500ULL,
0x000000ff48487207ULL, 0x000fe40000800000ULL, 0x000000ff9e9e7207ULL, 0x000fc60000000000ULL,
0x00000001488f7824ULL, 0x000fe200078e0287ULL, 0x0000008d9e917211ULL, 0x040fe200078fe0ffULL,
0x000000018d5b7824ULL, 0x002fe200078e0248ULL, 0x000000879e6b7211ULL, 0x000fe200078fe0ffULL,
0x000000028f8e7825ULL, 0x000fe200078e009aULL, 0x00000020ae7a7812ULL, 0x000fc600078efcffULL,
0x0000000291907825ULL, 0x100fe400078e009aULL, 0x000000068e8e7981ULL, 0x000f64000c1e9500ULL,
0x000000025b5a7825ULL, 0x100fe400078e009aULL, 0x0000000690907981ULL, 0x000f64000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fe400078e009aULL, 0x000000065a717981ULL, 0x000364000c1e9500ULL,
0x0000000148677824ULL, 0x000fc400078e028bULL, 0x0000000148617824ULL, 0x000fe200078e0255ULL,
0x000000066a857981ULL, 0x000f62000c1e9500ULL, 0x000000015d487824ULL, 0x000fe200078e027aULL,
0x0000008b9e657211ULL, 0x000fe200078fe0ffULL, 0x000000017a697824ULL, 0x000fe200078e0203ULL,
0x000000559e537211ULL, 0x000fe400078fe0ffULL, 0x00000093484c7246ULL, 0x000fe2000380005eULL,
0x0000000267667825ULL, 0x100fe200078e009aULL, 0x000000b16900720cULL, 0x080fe40003f06070ULL,
0x0000009369a27246ULL, 0x000fe2000380005eULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x000000b14800720cULL, 0x000fe20003f26070ULL, 0x0000000666287981ULL, 0x000f62000c1e9500ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x0000000261607825ULL, 0x100fe200078e009aULL,
0x000000ffa2a27207ULL, 0x000fe20000000000ULL, 0x0000000664837981ULL, 0x000364000c1e9500ULL,
0x00000002535a7825ULL, 0x002fe200078e009aULL, 0x000000ff4c4c7207ULL, 0x000fe20000800000ULL,
0x00000006604e7981ULL, 0x000f62000c1e9500ULL, 0x00000087a26d7211ULL, 0x000fc600078fe0ffULL,
0x000000065a817981ULL, 0x000362000c1e9500ULL, 0x000000014c657824ULL, 0x000fe400078e0287ULL,
0x000000026d6c7825ULL, 0x000fc800078e009aULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x0000008da25b7211ULL, 0x042fe200078fe0ffULL, 0x000000066c6d7981ULL, 0x000f64000c1e9500ULL,
0x000000018d617824ULL, 0x000fe400078e024cULL, 0x00000006647e7981ULL, 0x000364000c1e9500ULL,
0x0000000261607825ULL, 0x100fe200078e009aULL, 0x0000008ba2677211ULL, 0x040fe400078fe0ffULL,
0x00000055a2537211ULL, 0x000fe200078fe0ffULL, 0x000000025b5a7825ULL, 0x000fe200078e009aULL,
0x0000000660807981ULL, 0x000366000c1e9500ULL, 0x000000014c897824ULL, 0x040fe200078e028bULL,
0x000000065a6f7981ULL, 0x000362000c1e9500ULL, 0x000000014c577824ULL, 0x000fe200078e0255ULL,
0x00000030ae647812ULL, 0x002fe200078efcffULL, 0x0000000289887825ULL, 0x000fc800078e009aULL,
0x0000000267667825ULL, 0x100fe200078e009aULL, 0x0000000688487981ULL, 0x000f66000c1e9500ULL,
0x0000000257607825ULL, 0x100fe200078e009aULL, 0x00000006666b7981ULL, 0x000f66000c1e9500ULL,
0x00000002535a7825ULL, 0x000fe400078e009aULL, 0x0000000660537981ULL, 0x000364000c1e9500ULL,
0x000000015d4c7824ULL, 0x000fc400078e0264ULL, 0x000000065a7c7981ULL, 0x000362000c1e9500ULL,
0x0000000364577210ULL, 0x000fe40007ffe0ffULL, 0x000000934c587246ULL, 0x000fe4000380005eULL,
0x000000b15700720cULL, 0x080fe40003f06070ULL, 0x0000009357967246ULL, 0x000fe4000380005eULL,
0x000000b14c00720cULL, 0x000fe40003f26070ULL, 0x00000004ff587819ULL, 0x000fc40000011658ULL,
0x000000ff96967207ULL, 0x000fe40000000000ULL, 0x000000ff58587207ULL, 0x000fe40000800000ULL,
0x0000008b96617211ULL, 0x042fe400078fe0ffULL, 0x0000008d965b7211ULL, 0x000fe200078fe0ffULL,
0x000000018d937824ULL, 0x000fe400078e0258ULL, 0x0000000158897824ULL, 0x000fe400078e028bULL,
0x0000000261607825ULL, 0x000fc800078e009aULL, 0x0000000293927825ULL, 0x100fe400078e009aULL,
0x0000000660617981ULL, 0x000f64000c1e9500ULL, 0x000000025b5a7825ULL, 0x100fe400078e009aULL,
0x00000006926a7981ULL, 0x000f64000c1e9500ULL, 0x0000000289887825ULL, 0x000fe400078e009aULL,
0x000000065a677981ULL, 0x000364000c1e9500ULL, 0x0000000158957824ULL, 0x000fc400078e0287ULL,
0x00000006884c7981ULL, 0x000f62000c1e9500ULL, 0x0000008796877211ULL, 0x000fe200078fe0ffULL,
0x0000000295947825ULL, 0x000fc800078e009aULL, 0x00000002878a7825ULL, 0x000fe200078e009aULL,
0x0000000694687981ULL, 0x000f62000c1e9500ULL, 0x00000055965b7211ULL, 0x002fc600078fe0ffULL,
0x000000068a657981ULL, 0x000362000c1e9500ULL, 0x0000000158937824ULL, 0x000fe400078e0255ULL,
0x000000025b5a7825ULL, 0x000fc800078e009aULL, 0x0000000293927825ULL, 0x000fe400078e009aULL,
0x000000065a5b7981ULL, 0x000f68000c1e9500ULL, 0x0000000692667981ULL, 0x000362000c1e9500ULL,
0xfffffff098987812ULL, 0x000fe200078ec0ffULL, 0x00000001ff557424ULL, 0x000fc800078e00ffULL,
0x00000001b1987824ULL, 0x000fc800078e0298ULL, 0x00000001afc07824ULL, 0x000fe200078e0a98ULL,
0x00000001aeaa7812ULL, 0x000fc800078efcffULL, 0x000000c055ab7219ULL, 0x000fe200000006ffULL,
0x00000001aaa97824ULL, 0x000fe200078e0203ULL, 0x00000008aea87812ULL, 0x000fc600078efcffULL,
0x00000001a9be7824ULL, 0x000fe200078e0a98ULL, 0x00000009ae8a7812ULL, 0x002fe200078efcffULL,
0x00000001a8a67824ULL, 0x000fc600078e0203ULL, 0x000000be55a77219ULL, 0x000fe200000006ffULL,
0x000000018a877824ULL, 0x000fe400078e0203ULL, 0x00000001a6bc7824ULL, 0x100fe400078e0a98ULL,
0x0000000187987824ULL, 0x000fe200078e0a98ULL, 0x00000011ae887812ULL, 0x000fe400078efcffULL,
0xfffffff09e9e7812ULL, 0x000fe400078ec0ffULL, 0x000000bc55977219ULL, 0x000fc400000006ffULL,
0x0000009855987219ULL, 0x000fe200000006ffULL, 0x0000000188897824ULL, 0x000fe400078e0203ULL,
0x00000001b19e7824ULL, 0x000fe200078e029eULL, 0x00000018ae847812ULL, 0x000fc600078efcffULL,
0x0000000173ba7824ULL, 0x100fe400078e0a9eULL, 0x00000001899c7824ULL, 0x000fe200078e0a9eULL,
0x00000019ae827812ULL, 0x000fe400078efcffULL, 0x000000ba55997219ULL, 0x040fe400000006ffULL,
0x0000009c559c7219ULL, 0x000fe200000006ffULL, 0x00000001848b7824ULL, 0x100fe400078e0203ULL,
0x00000001828d7824ULL, 0x000fe200078e0203ULL, 0x00005410acac7816ULL, 0x008fc800000000adULL,
0x000000acabff7212ULL, 0x000fc800078ac0ffULL, 0x000000b1af00720cULL, 0x000fc80002fa1470ULL,
0x000000b1ae00720cULL, 0x000fe40002fa1070ULL, 0x000054104f567816ULL, 0x000fe40000000056ULL,
0xff80000009097808ULL, 0x000fe40002800000ULL, 0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL,
0x00000056abff7212ULL, 0x080fe4000784c0ffULL, 0x00000056a7ff7212ULL, 0x000fc400078ac0ffULL,
0x0000541086867816ULL, 0x004fc8000000000fULL, 0x00000086abff7212ULL, 0x000fe4000788c0ffULL,
0x000000b1af00720cULL, 0x0c0fe40001741470ULL, 0x000000b1af00720cULL, 0x080fe40002781470ULL,
0x000000b1a900720cULL, 0x0c0fe40000f21470ULL, 0x000000b1a900720cULL, 0x080fe40002fa1470ULL,
0x000000b1ae00720cULL, 0x000fc40001741070ULL, 0x000000b1ae00720cULL, 0x080fe40002781070ULL,
0x000000b1aa00720cULL, 0x0c0fe40000f21070ULL, 0x000000b1aa00720cULL, 0x000fe40002fa1070ULL,
0x0000541054547816ULL, 0x020fe4000000004dULL, 0xff8000004a4a7808ULL, 0x000fe40001000000ULL,
0xff8000000b0b7808ULL, 0x000fc40002000000ULL, 0xff80000049497808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002800000ULL, 0x000000ac97ff7212ULL, 0x000fe4000786c0ffULL,
0x00000054abff7212ULL, 0x000fe4000780c0ffULL, 0x00000086a7ff7212ULL, 0x040fe4000784c0ffULL,
0x00000054a7ff7212ULL, 0x000fc4000788c0ffULL, 0x0000005698ff7212ULL, 0x000fe4000782c0ffULL,
0x0000008697ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b1af00720cULL, 0x080fe40000701470ULL,
0x000000b1a900720cULL, 0x0c0fe40001741470ULL, 0x000000b1a900720cULL, 0x080fe40002781470ULL,
0x000000b1a600720cULL, 0x000fc40001f61470ULL, 0x000000b1a600720cULL, 0x080fe40002fa1470ULL,
0x000000b18700720cULL, 0x080fe40000f21470ULL, 0x000000b1ae00720cULL, 0x080fe40000701070ULL,
0x000000b1aa00720cULL, 0x0c0fe40001741070ULL, 0x000000b1aa00720cULL, 0x080fe40002781070ULL,
0x000000b1a800720cULL, 0x000fc40001f61070ULL, 0x000000b1a800720cULL, 0x080fe40002fa1070ULL,
0x000000b18a00720cULL, 0x000fe40000f21070ULL, 0x0000541090717816ULL, 0x000fe40000000071ULL,
0x0000541085857816ULL, 0x000fe4000000008eULL, 0xff8000002a2a7808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000047477808ULL, 0x000fe40000800000ULL, 0x0000005697ff7212ULL, 0x000fe4000780c0ffULL,
0x0000008698ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005497ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005498ff7212ULL, 0x000fe4000786c0ffULL, 0x000000719cff7212ULL, 0x000fe400078ac0ffULL,
0x0000008599ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018bb87824ULL, 0x100fe200078e0a9eULL,
0x000000b1a600720cULL, 0x0c0fe20000701470ULL, 0x000000018d9e7824ULL, 0x000fe200078e0a9eULL,
0x000000b1a600720cULL, 0x000fc40002781470ULL, 0x000000b18700720cULL, 0x0c0fe40001741470ULL,
0x000000b18700720cULL, 0x080fe40001f61470ULL, 0x000000b17300720cULL, 0x080fe40000f21470ULL,
0x000000b18900720cULL, 0x080fe40002fa1470ULL, 0xfffffff0a2a27812ULL, 0x000fe400078ec0ffULL,
0x000000b1a800720cULL, 0x000fc40000701070ULL, 0x000000b1a800720cULL, 0x080fe40002781070ULL,
0x000000b18a00720cULL, 0x0c0fe40001741070ULL, 0x000000b18a00720cULL, 0x080fe40001f61070ULL,
0x000000b18c00720cULL, 0x080fe40000f21070ULL, 0x000000b18800720cULL, 0x000fe40002fa1070ULL,
0x000000b8559d7219ULL, 0x000fc400000006ffULL, 0x0000009e559e7219ULL, 0x000fe400000006ffULL,
0x0000541083287816ULL, 0x000fe40000000028ULL, 0x00005410814e7816ULL, 0x000fe2000000004eULL,
0x00000001b1a27824ULL, 0x000fe200078e02a2ULL, 0xff80000046467808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fc40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40000800000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x0000007199ff7212ULL, 0x080fe4000780c0ffULL,
0x000000719dff7212ULL, 0x000fe4000788c0ffULL, 0x0000002899ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004e99ff7212ULL, 0x000fe4000786c0ffULL, 0x000000289cff7212ULL, 0x000fe4000782c0ffULL,
0x000000859eff7212ULL, 0x000fe200078ac0ffULL, 0x0000000169b67824ULL, 0x000fe200078e0aa2ULL,
0x000000b17300720cULL, 0x0c0fe40000701470ULL, 0x000000b17300720cULL, 0x0c0fe40001741470ULL,
0x000000b17300720cULL, 0x000fc40001f61470ULL, 0x000000b18900720cULL, 0x080fe40000f21470ULL,
0x000000b18b00720cULL, 0x080fe40002781470ULL, 0x000000b18d00720cULL, 0x080fe40002fa1470ULL,
0x00000021ae727812ULL, 0x000fe400078efcffULL, 0x000000b18c00720cULL, 0x0c0fe40000701070ULL,
0x000000b18c00720cULL, 0x000fc40001741070ULL, 0x000000b18c00720cULL, 0x080fe40001f61070ULL,
0x000000b18800720cULL, 0x080fe40000f21070ULL, 0x000000b18400720cULL, 0x080fe40002781070ULL,
0x000000b18200720cULL, 0x000fe40002fa1070ULL, 0x000000b6559f7219ULL, 0x000fe400000006ffULL,
0x000054106d6d7816ULL, 0x000fe2000000007eULL, 0x00000001728f7824ULL, 0x000fe200078e0203ULL,
0xff80000040407808ULL, 0x000fc40000000000ULL, 0xff80000020207808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff8000003c3c7808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x000000859cff7212ULL, 0x000fc4000780c0ffULL, 0x0000004e9cff7212ULL, 0x000fe4000784c0ffULL,
0x000000859dff7212ULL, 0x000fe4000786c0ffULL, 0x000000289eff7212ULL, 0x040fe4000782c0ffULL,
0x0000004e9eff7212ULL, 0x000fe4000788c0ffULL, 0x0000006d9fff7212ULL, 0x000fe200078ac0ffULL,
0x000000018fa07824ULL, 0x000fe200078e0aa2ULL, 0x000000b18900720cULL, 0x000fc40000701470ULL,
0x000000b18900720cULL, 0x080fe40001741470ULL, 0x000000b18b00720cULL, 0x080fe40001f61470ULL,
0x000000b18d00720cULL, 0x0c0fe40000f21470ULL, 0x000000b18d00720cULL, 0x080fe40002781470ULL,
0x000000b16900720cULL, 0x000fe40002fa1470ULL, 0x00000028ae6e7812ULL, 0x000fc400078efcffULL,
0x00000029ae6c7812ULL, 0x000fe400078efcffULL, 0x000000b18800720cULL, 0x0c0fe40000701070ULL,
0x000000b18800720cULL, 0x080fe40001741070ULL, 0x000000b18400720cULL, 0x080fe40001f61070ULL,
0x000000b18200720cULL, 0x0c0fe40000f21070ULL, 0x000000b18200720cULL, 0x000fc40002781070ULL,
0x000000b17a00720cULL, 0x000fe40002fa1070ULL, 0x000000a055a07219ULL, 0x000fe400000006ffULL,
0x000054106f6f7816ULL, 0x000fe40000000080ULL, 0x000054106b487816ULL, 0x000fe40000000048ULL,
0x000054107c537816ULL, 0x000fe20000000053ULL, 0x000000016e917824ULL, 0x100fe200078e0203ULL,
0xff80000043437808ULL, 0x000fe20000000000ULL, 0x000000016c927824ULL, 0x000fe200078e0203ULL,
0xff80000023237808ULL, 0x000fc40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0x000000ac98ff7212ULL, 0x000fe400078cc0ffULL,
0x000000289dff7212ULL, 0x000fc4000780c0ffULL, 0x0000004e9dff7212ULL, 0x000fe4000784c0ffULL,
0x0000006f9fff7212ULL, 0x040fe4000786c0ffULL, 0x000000489fff7212ULL, 0x0c0fe4000782c0ffULL,
0x000000539fff7212ULL, 0x000fe4000788c0ffULL, 0x00000048a0ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000191b47824ULL, 0x100fe200078e0aa2ULL, 0x000000b18700720cULL, 0x080fe200037c1470ULL,
0x0000000192a27824ULL, 0x000fe200078e0aa2ULL, 0x000000b18b00720cULL, 0x000fc40000701470ULL,
0x000000b18b00720cULL, 0x080fe40001741470ULL, 0x000000b16900720cULL, 0x0c0fe40001f61470ULL,
0x000000b16900720cULL, 0x0c0fe40000f21470ULL, 0x000000b16900720cULL, 0x080fe40002781470ULL,
0x000000b18f00720cULL, 0x000fe40002fa1470ULL, 0xfffffff096967812ULL, 0x000fc400078ec0ffULL,
0x000000b18a00720cULL, 0x080fe400037c1070ULL, 0x000000b18400720cULL, 0x0c0fe40000701070ULL,
0x000000b18400720cULL, 0x080fe40001741070ULL, 0x000000b17a00720cULL, 0x0c0fe40001f61070ULL,
0x000000b17a00720cULL, 0x0c0fe40000f21070ULL, 0x000000b17a00720cULL, 0x000fc40002781070ULL,
0x000000b17200720cULL, 0x000fe40002fa1070ULL, 0x000000b455a17219ULL, 0x040fe400000006ffULL,
0x000000a255a27219ULL, 0x000fe200000006ffULL, 0x00000001b1967824ULL, 0x000fe200078e0296ULL,
0xff80000045457808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fc40001000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fe40002800000ULL, 0x000000719eff7212ULL, 0x000fe400078cc0ffULL,
0x0000006fa0ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006fa1ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006da0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000053a0ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006da1ff7212ULL, 0x000fe4000788c0ffULL, 0x00000048a2ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000157b27824ULL, 0x000fe200078e0a96ULL, 0x000000b18d00720cULL, 0x000fc400037c1470ULL,
0x000000b18f00720cULL, 0x0c0fe40000701470ULL, 0x000000b18f00720cULL, 0x0c0fe40001f61470ULL,
0x000000b18f00720cULL, 0x080fe40000f21470ULL, 0x000000b19100720cULL, 0x0c0fe40001741470ULL,
0x000000b19100720cULL, 0x080fe40002781470ULL, 0x000000b19200720cULL, 0x000fc40002fa1470ULL,
0x00000031ae607812ULL, 0x040fe400078efcffULL, 0x00000038ae5a7812ULL, 0x040fe400078efcffULL,
0x00000039ae587812ULL, 0x000fe400078efcffULL, 0x000000b18200720cULL, 0x080fe400037c1070ULL,
0x000000b17200720cULL, 0x0c0fe40000701070ULL, 0x000000b17200720cULL, 0x000fc40001f61070ULL,
0x000000b17200720cULL, 0x080fe40000f21070ULL, 0x000000b16e00720cULL, 0x0c0fe40001741070ULL,
0x000000b16e00720cULL, 0x080fe40002781070ULL, 0x000000b16c00720cULL, 0x000fe40002fa1070ULL,
0x000000b255a37219ULL, 0x000fe400000006ffULL, 0x0000541067677816ULL, 0x000fc4000000006aULL,
0x00005410614c7816ULL, 0x000fe2000000004cULL, 0x0000000160937824ULL, 0x100fe200078e0203ULL,
0xff8000003d3d7808ULL, 0x000fe20003000000ULL, 0x000000015a947824ULL, 0x100fe200078e0203ULL,
0xff80000039397808ULL, 0x000fe20000000000ULL, 0x0000000158957824ULL, 0x000fe200078e0203ULL,
0xff8000003b3b7808ULL, 0x000fe40001800000ULL, 0xff8000001b1b7808ULL, 0x000fe40000800000ULL,
0xff80000034347808ULL, 0x000fc40001000000ULL, 0xff80000036367808ULL, 0x000fe40002000000ULL,
0xff80000015157808ULL, 0x000fe40002800000ULL, 0x0000006fa2ff7212ULL, 0x040fe400078cc0ffULL,
0x0000006da2ff7212ULL, 0x000fe4000780c0ffULL, 0x00000048a1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000053a1ff7212ULL, 0x000fc4000782c0ffULL, 0x00000053a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000067a3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004ca3ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000193a47824ULL, 0x100fe200078e0a96ULL, 0x000000b19100720cULL, 0x0c0fe20001f61470ULL,
0x0000000194b07824ULL, 0x100fe200078e0a96ULL, 0x000000b19100720cULL, 0x080fe20000f21470ULL,
0x0000000195967824ULL, 0x000fe200078e0a96ULL, 0x000000b19200720cULL, 0x000fc400037c1470ULL,
0x000000b19200720cULL, 0x0c0fe40000701470ULL, 0x000000b19200720cULL, 0x080fe40001741470ULL,
0x000000b15700720cULL, 0x0c0fe40002781470ULL, 0x000000b15700720cULL, 0x080fe40002fa1470ULL,
0x000000b16e00720cULL, 0x0c0fe40001f61070ULL, 0x000000b16e00720cULL, 0x000fc40000f21070ULL,
0x000000b16c00720cULL, 0x0c0fe400037c1070ULL, 0x000000b16c00720cULL, 0x0c0fe40000701070ULL,
0x000000b16c00720cULL, 0x080fe40001741070ULL, 0x000000b16400720cULL, 0x0c0fe40002781070ULL,
0x000000b16400720cULL, 0x000fe40002fa1070ULL, 0x000000a455a47219ULL, 0x000fc400000006ffULL,
0x000000b055a57219ULL, 0x040fe400000006ffULL, 0x0000009655967219ULL, 0x000fe400000006ffULL,
0x0000541065657816ULL, 0x000fe40000000068ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000035357808ULL, 0x000fc40003000000ULL,
0xff80000037377808ULL, 0x000fe40000000000ULL, 0xff80000017177808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000010107808ULL, 0x000fe40002800000ULL,
0x00000067a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000067a5ff7212ULL, 0x000fc4000782c0ffULL,
0x0000006796ff7212ULL, 0x000fe400078cc0ffULL, 0x00000065a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000065a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000065a5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004ca4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b15700720cULL, 0x000fc40000701470ULL,
0x000000b19300720cULL, 0x0c0fe40001f61470ULL, 0x000000b19300720cULL, 0x0c0fe40001741470ULL,
0x000000b19300720cULL, 0x080fe40002fa1470ULL, 0x000000b19400720cULL, 0x0c0fe40000f21470ULL,
0x000000b19500720cULL, 0x080fe400037c1470ULL, 0x000000b19400720cULL, 0x000fc40002781470ULL,
0x000000b16400720cULL, 0x080fe40000701070ULL, 0x000000b16000720cULL, 0x0c0fe40001f61070ULL,
0x000000b16000720cULL, 0x0c0fe40001741070ULL, 0x000000b16000720cULL, 0x080fe40002fa1070ULL,
0x000000b15a00720cULL, 0x080fe40000f21070ULL, 0x000000b15800720cULL, 0x000fc400037c1070ULL,
0x000000b15a00720cULL, 0x000fe40002781070ULL, 0x000054105b5b7816ULL, 0x000fe40000000066ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff80000031317808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000011117808ULL, 0x000fc40002800000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0x0000006596ff7212ULL, 0x040fe4000780c0ffULL,
0x0000004ca5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004c96ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005ba3ff7212ULL, 0x080fe400078ac0ffULL, 0x0000005ba4ff7212ULL, 0x080fe4000782c0ffULL,
0x0000005ba5ff7212ULL, 0x080fe400078cc0ffULL, 0x0000005b96ff7212ULL, 0x000fe4000788c0ffULL,
0x000000b15700720cULL, 0x080fe40002fa1470ULL, 0x000000b19300720cULL, 0x000fc40000f21470ULL,
0x000000b19400720cULL, 0x0c0fe40001f61470ULL, 0x000000b19400720cULL, 0x080fe400037c1470ULL,
0x000000b19500720cULL, 0x0c0fe40000701470ULL, 0x000000b19500720cULL, 0x0c0fe40001741470ULL,
0x000000b19500720cULL, 0x080fe40002781470ULL, 0x000000b16400720cULL, 0x000fc40002fa1070ULL,
0x000000b16000720cULL, 0x080fe40000f21070ULL, 0x000000b15800720cULL, 0x080fe40000701070ULL,
0x000000b15a00720cULL, 0x0c0fe40001f61070ULL, 0x000000b15a00720cULL, 0x080fe400037c1070ULL,
0x000000b15800720cULL, 0x0c0fe40001741070ULL, 0x000000b15800720cULL, 0x000fc40002781070ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000008087808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40001000000ULL, 0xff80000012127808ULL, 0x000fe40002800000ULL,
0xff80000013137808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fc40003000000ULL,
0xff8000000d0d7808ULL, 0x000fce0002000000ULL, 0x000000090400720bULL, 0x004fe20003f1e000ULL,
0x0000000178787836ULL, 0x000fe20000000000ULL, 0xfffffff8ff597812ULL, 0x000fe400078ee259ULL,
0x0000000409047208ULL, 0x000fc80004000000ULL, 0x000000490400720bULL, 0x000fc80003f1e000ULL,
0x00000004490f7208ULL, 0x000fc80004000000ULL, 0x000000440f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f44047208ULL, 0x000fc80004000000ULL, 0x000000450400720bULL, 0x000fc80003f1e000ULL,
0x00000004450f7208ULL, 0x000fc80004000000ULL, 0x000000400f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f40047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x00000004410f7208ULL, 0x000fc80004000000ULL, 0x0000003c0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f3c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d0f7208ULL, 0x000fc80004000000ULL, 0x000000380f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f38047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x00000004390f7208ULL, 0x000fc80004000000ULL, 0x000000340f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f34047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x00000004350f7208ULL, 0x000fc80004000000ULL, 0x000000300f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f30047208ULL, 0x000fc80004000000ULL, 0x000000310400720bULL, 0x000fc80003f1e000ULL,
0x00000004310f7208ULL, 0x000fc80004000000ULL, 0x0000002c0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2c047208ULL, 0x000fe40004000000ULL, 0x0000004a0500720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fc80003f3e000ULL, 0x000000042d0f7208ULL, 0x000fe40004800000ULL,
0x000000054a047208ULL, 0x000fc60004000000ULL, 0x0c401f000f287f89ULL, 0x000ee200000e0000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fc80004000000ULL,
0x000000460500720bULL, 0x000fc80003f1e000ULL, 0x0000000546047208ULL, 0x000fc80004000000ULL,
0x000000470400720bULL, 0x000fc80003f1e000ULL, 0x0000000447057208ULL, 0x000fe40004000000ULL,
0x000000280f00720bULL, 0x008fe40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f1e000ULL,
0x0000000f28487208ULL, 0x000fe40004800000ULL, 0x0000000542047208ULL, 0x000fc60004000000ULL,
0x0c201f00480f7f89ULL, 0x000ee200000e0000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fc80004000000ULL, 0x0000003e0500720bULL, 0x000fc80003f1e000ULL,
0x000000053e047208ULL, 0x000fc80004000000ULL, 0x0000003f0400720bULL, 0x000fc80003f1e000ULL,
0x000000043f057208ULL, 0x000fe40004000000ULL, 0x0000000f4800720bULL, 0x008fe40003f3e000ULL,
0x0000003a0500720bULL, 0x000fe40003f1e000ULL, 0x000000480f047208ULL, 0x000fe40004800000ULL,
0x000000053a287208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b044e7820ULL, 0x000fe20000410000ULL,
0x0000003b2800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b400f7823ULL, 0x100fe2000001084eULL,
0x000000283b057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3c4c7823ULL, 0x100fe2000001084eULL,
0x3fb8aa3b49487823ULL, 0x100fe2000001084eULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001084eULL,
0x000000360500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b44447823ULL, 0x100fe2000001084eULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001084eULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001084eULL,
0x0000000536287208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001084eULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001084eULL, 0x3fb8aa3b31317823ULL, 0x000fe2000001084eULL,
0x000000372800720bULL, 0x000fe20003f1e000ULL, 0x0000000900097308ULL, 0x000fe60000000800ULL,
0x0000002837057208ULL, 0x000fc80004000000ULL, 0x000000320500720bULL, 0x000fe20003f1e000ULL,
0x0000004800487308ULL, 0x000ee60000000800ULL, 0x0000000532287208ULL, 0x000fc80004000000ULL,
0x000000332800720bULL, 0x000fe20003f1e000ULL, 0x0000004400447308ULL, 0x000fe60000000800ULL,
0x0000002833057208ULL, 0x000fc80004000000ULL, 0x0000002e0500720bULL, 0x000fe20003f1e000ULL,
0x0000000f00287308ULL, 0x000be60000000800ULL, 0x000000052e407208ULL, 0x000fc80004000000ULL,
0x0000002f4000720bULL, 0x000fe20003f1e000ULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b380f7823ULL, 0x120fe2000001084eULL, 0x3fb8aa3b39387823ULL, 0x100fe2000001084eULL,
0x000000402f3c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b34397823ULL, 0x100fe2000001084eULL,
0x0000000b0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2c347823ULL, 0x000fe4000001084eULL,
0x0c401f003c497f89ULL, 0x000f6200000e0000ULL, 0x000000060b067208ULL, 0x000fe20004000000ULL,
0x0000004c00407308ULL, 0x0007e60000000800ULL, 0x000000290600720bULL, 0x000fc80003f1e000ULL,
0x0000000629057208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000240500720bULL, 0x000fc80003f1e000ULL, 0x0000000524067208ULL, 0x000fe20004000000ULL,
0x0000004100417308ULL, 0x000fe60000000800ULL, 0x000000250600720bULL, 0x000fe40003f1e000ULL,
0x000000493c00720bULL, 0x020fe40003f3e000ULL, 0x0000000625057208ULL, 0x000fe20004000000ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x0000003c49497208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b353c7823ULL, 0x100fe2000001084eULL, 0x000000200500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2d4e7823ULL, 0x000fc4000001084eULL, 0x0c201f00494c7f89ULL, 0x00ae6200000e0000ULL,
0x0000000520067208ULL, 0x000fe20004000000ULL, 0x0000003800387308ULL, 0x000fe60000000800ULL,
0x000000210600720bULL, 0x000fc80003f1e000ULL, 0x0000000621057208ULL, 0x000fe20004000000ULL,
0x0000003900397308ULL, 0x000fe60000000800ULL, 0x0000001c0500720bULL, 0x000fc80003f1e000ULL,
0x000000051c067208ULL, 0x000fe20004000000ULL, 0x0000003c003c7308ULL, 0x000fe60000000800ULL,
0x0000001d0600720bULL, 0x000fe40003f1e000ULL, 0x0000004c4900720bULL, 0x002fe40003f3e000ULL,
0x000000061d357208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000494c057208ULL, 0x000fc40004800000ULL, 0x000000183500720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b054c7820ULL, 0x000fe20000410000ULL, 0x0000003518067208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b4a2c7823ULL, 0x100fe2000001084cULL,
0x000000190600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b46467823ULL, 0x100fe2000001084cULL,
0x00000006192d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b47477823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe2000001084cULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000142d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b43437823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001084cULL,
0x0000002d14067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001084cULL, 0x0000004b002d7308ULL, 0x0002e20000000800ULL,
0x000000150600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001084cULL,
0x0000000615497208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084cULL,
0x0000002a0700720bULL, 0x000fe20003f1e000ULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x000000104900720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe2000001084cULL,
0x000000072a067208ULL, 0x000fc40004000000ULL, 0x00000049104a7208ULL, 0x000fe40004800000ULL,
0x0000002b0600720bULL, 0x000fe20003f1e000ULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x000000114a00720bULL, 0x000fe40003f3e000ULL, 0x000000062b077208ULL, 0x000fe40004000000ULL,
0x0000004a11497208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe20003f1e000ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x000000084900720bULL, 0x000fc40003f3e000ULL,
0x0000000726067208ULL, 0x000fe40004000000ULL, 0x0000004908497208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe20003f1e000ULL, 0x0000004700477308ULL, 0x000fe20000000800ULL,
0x0000000a4900720bULL, 0x000fe40003f3e000ULL, 0x0000000627077208ULL, 0x000fe40004000000ULL,
0x000000490a497208ULL, 0x000fc40004800000ULL, 0x000000220700720bULL, 0x000fe20003f1e000ULL,
0x0000004e00357308ULL, 0x000fe40000000800ULL, 0x0c401f00494a7f89ULL, 0x000f6200000e0000ULL,
0x0000000722067208ULL, 0x000fc80004000000ULL, 0x000000230600720bULL, 0x000fe20003f1e000ULL,
0x0000004200427308ULL, 0x000fe60000000800ULL, 0x0000000623077208ULL, 0x000fc80004000000ULL,
0x0000001e0700720bULL, 0x000fe20003f1e000ULL, 0x0000004300437308ULL, 0x000e660000000800ULL,
0x000000071e067208ULL, 0x000fc80004000000ULL, 0x0000001f0600720bULL, 0x000fe20003f1e000ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x0000004a4900720bULL, 0x020fe40003f3e000ULL,
0x000000061f077208ULL, 0x000fe40004000000ULL, 0x000000494a497208ULL, 0x000fe40004800000ULL,
0x0000001a0700720bULL, 0x000fe20003f1e000ULL, 0x0000003b003b7308ULL, 0x000fe40000000800ULL,
0x0c201f00494a7f89ULL, 0x000f6200000e0000ULL, 0x000000071a067208ULL, 0x000fc80004000000ULL,
0x0000001b0600720bULL, 0x000fe20003f1e000ULL, 0x0000003600367308ULL, 0x000fe60000000800ULL,
0x000000061b077208ULL, 0x000fc80004000000ULL, 0x000000160700720bULL, 0x000fe20003f1e000ULL,
0x0000003700377308ULL, 0x000fe60000000800ULL, 0x0000000716067208ULL, 0x000fc80004000000ULL,
0x000000170600720bULL, 0x000fe20003f1e000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000004a4900720bULL, 0x020fe40003f3e000ULL, 0x0000000617077208ULL, 0x000fe40004000000ULL,
0x000000494a067208ULL, 0x000fe40004800000ULL, 0x000000120700720bULL, 0x000fe20003f1e000ULL,
0x0000003300337308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b06537820ULL, 0x000fe20000410000ULL,
0x00000007124a7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010853ULL,
0x000000134a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b144d7823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010853ULL, 0x0000000b00557308ULL, 0x000be20000000800ULL,
0x0000004a13077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b10497823ULL, 0x100fe20000010853ULL,
0x0000000c0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b194b7823ULL, 0x102fe20000010853ULL,
0x3fb8aa3b114c7823ULL, 0x100fe20000010853ULL, 0x0000002900567308ULL, 0x000fe20000000800ULL,
0x000000070c4a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b180b7823ULL, 0x120fe20000010853ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010853ULL,
0x0000000d4a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b084f7823ULL, 0x100fe20000010853ULL,
0x000000094808723eULL, 0x000fe200000000ffULL, 0x0000002400577308ULL, 0x000fe20000000800ULL,
0x0000004a0d4a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b0a547823ULL, 0x100fe20000010853ULL,
0x0000002c2d09723eULL, 0x008fe200000000ffULL, 0x3c003c00ff2c7424ULL, 0x000fe200078e00ffULL,
0x00000044450a723eULL, 0x000fe200000000ffULL, 0x0c401f004a077f89ULL, 0x000e6200000e0000ULL,
0x3c003c00ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000002500587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b154e7823ULL, 0x000fe20000010853ULL, 0x00000003ff537819ULL, 0x000fe20000011650ULL,
0x0000001059457836ULL, 0x000fc60000000000ULL, 0x0000001c00297308ULL, 0x0007f00000000800ULL,
0x0000001d005a7308ULL, 0x000be20000000800ULL, 0x00000028411c723eULL, 0x008fe400000000ffULL,
0x000000074a00720bULL, 0x002fca0003f1e000ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000042431d723eULL, 0x020fe200000000ffULL, 0x0000000859437836ULL, 0x000fe20000000000ULL,
0x0000004a07077208ULL, 0x000fc60004000000ULL, 0x0000000843417824ULL, 0x000fe400078e00ffULL,
0x0c201f0007187f89ULL, 0x000e6200000e0000ULL, 0x0000000b004a7308ULL, 0x0007f00000000800ULL,
0x0000002100217308ULL, 0x000f620000000800ULL, 0x00000046470b723eULL, 0x008fe200000000ffULL,
0x0000001859477836ULL, 0x000fcc0000000000ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000180700720bULL, 0x002fce0003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x000000202120723eULL, 0x020fe400000000ffULL, 0x0000000718077208ULL, 0x000fe40004000000ULL,
0x000000555618723eULL, 0x000fe200000000ffULL, 0x0000000845557824ULL, 0x000fe200078e00ffULL,
0x0000000350ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b07147820ULL, 0x000fe20000410000ULL,
0x0000004e004e7308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010814ULL,
0x0000002b00107308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fc40000010814ULL, 0x0000002a00197308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b1f2b7823ULL, 0x102fe20000010814ULL, 0x0000003e3f1f723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b1b3e7823ULL, 0x000fca0000010814ULL, 0x0000002600117308ULL, 0x000fe20000000800ULL,
0x000000191019723eULL, 0x008fce00000000ffULL, 0x0000002700607308ULL, 0x0002e20000000800ULL,
0x0000000450107810ULL, 0x000fc80007ffe053ULL, 0x0000000710107812ULL, 0x000fc600078ec0ffULL,
0x0000001e002a7308ULL, 0x000be20000000800ULL, 0x0000002c0824723cULL, 0x002fe200000018ffULL,
0xfffffff841447812ULL, 0x000fe400078ee210ULL, 0xfffffff855467812ULL, 0x000fe400078ee210ULL,
0x00000011601b723eULL, 0x008fe400000000ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x000000403d1e723eULL, 0x020fe200000000ffULL, 0x0000000859117824ULL, 0x000fca00078e00ffULL,
0xfffffff811427812ULL, 0x000fe200078ee210ULL, 0x0000002300647308ULL, 0x0003e20000000800ULL,
0x0000003a3b11723eULL, 0x000fe200000000ffULL, 0x000000ffff3a7224ULL, 0x000fe400078e001cULL,
0x000000ffff3b7224ULL, 0x000fc800078e001eULL, 0x0000002200157308ULL, 0x0007620000000800ULL,
0x3fb8aa3b1a237823ULL, 0x002fe20000010814ULL, 0x00000057581a723eULL, 0x000fe200000000ffULL,
0x0000002c1c24723cULL, 0x000fe20000001824ULL, 0x0000000847577824ULL, 0x000fc800078e00ffULL,
0x00000023003d7308ULL, 0x0003e20000000800ULL, 0x000000295a22723eULL, 0x008fe400000000ffULL,
0xfffffff857487812ULL, 0x000fe400078ee210ULL, 0x0000000f3810723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b130f7823ULL, 0x100fe20000010814ULL, 0x000000156421723eULL, 0x020fe200000000ffULL,
0x0000003e003e7308ULL, 0x000ee20000000800ULL, 0x0000002a2b23723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b12157823ULL, 0x000fe20000010814ULL, 0x0000002c1828723cULL, 0x000fe200000018ffULL,
0x000000393c12723eULL, 0x000fe200000000ffULL, 0x00000008433c7824ULL, 0x000fe200078e00ffULL,
0x000000363713723eULL, 0x000fe200000000ffULL, 0x000000ffff397224ULL, 0x000fe200078e000aULL,
0x00000016003f7308ULL, 0x000fe20000000800ULL, 0x000000303114723eULL, 0x000fe200000000ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e001dULL, 0x0000004a4b30723eULL, 0x000fc400000000ffULL,
0x0000002c1024723cULL, 0x000fe20000001824ULL, 0x0000003d3e31723eULL, 0x008fe400000000ffULL,
0x0000001700407308ULL, 0x000e620000000800ULL, 0x00000008453e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fca00078e0030ULL, 0x0000001500417308ULL, 0x0007e60000000800ULL,
0x0000002c2028723cULL, 0x000fea0000001828ULL, 0x0000003400347308ULL, 0x000f620000000800ULL,
0x000000323315723eULL, 0x008fe400000000ffULL, 0x0000004d4e32723eULL, 0x000fc400000000ffULL,
0x0000003f4033723eULL, 0x002fe200000000ffULL, 0x0000000847407824ULL, 0x000fe400078e00ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0032ULL,
0x000000343516723eULL, 0x020fcc00000000ffULL, 0x0000002f002f7308ULL, 0x000e660000000800ULL,
0x0000002c3028723cULL, 0x000fea0000001828ULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x0000002e2f17723eULL, 0x002fce00000000ffULL, 0x0000004c004c7308ULL, 0x000e620000000800ULL,
0x00000008592e7824ULL, 0x000fe200078e00ffULL, 0x00000008632f7c11ULL, 0x000fe2000f8e60ffULL,
0x0000002c1424723cULL, 0x000fe80000001824ULL, 0x000120002f2f7836ULL, 0x000fe20000000000ULL,
0x0000004f004f7308ULL, 0x000fe60000000800ULL, 0x0000001042427824ULL, 0x000fc400078e022fULL,
0x0000001044447824ULL, 0x100fe200078e022fULL, 0x000000494c34723eULL, 0x002fe400000000ffULL,
0x0000005400547308ULL, 0x000e620000000800ULL, 0x0000001046467824ULL, 0x100fe400078e022fULL,
0x0000001048487824ULL, 0x000fe400078e022fULL, 0x000000ffff1e7224ULL, 0x000fc600078e0034ULL,
0x0000000f00387308ULL, 0x0007660000000800ULL, 0x000000ffff257224ULL, 0x000fe200078e0026ULL,
0x0000004f5436723eULL, 0x002fc800000000ffULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x00000003530f7812ULL, 0x008fca00078ec0ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0250ULL,
0x000000413835723eULL, 0x020fe200000000ffULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x000000ffff387224ULL, 0x000fe400078e0008ULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe400078e0009ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL, 0x000000ffff0b7224ULL, 0x000fe200078e001fULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x000000ffff1f7224ULL, 0x000fe200078e0036ULL,
0xfffffff83e3e7812ULL, 0x000fc400078ee20fULL, 0xfffffff840407812ULL, 0x000fe200078ee20fULL,
0x000000103c3c7824ULL, 0x100fe200078e022fULL, 0x0000000c0d37723eULL, 0x002fe200000000ffULL,
0x000000102e0c7824ULL, 0x100fe400078e022fULL, 0x000000103e3e7824ULL, 0x100fe400078e022fULL,
0x0000001040407824ULL, 0x000fe200078e022fULL, 0x000000380c007844ULL, 0x000fe20000000200ULL,
0x0000002c3428723cULL, 0x000fe20000001828ULL, 0x000000ffff2e7224ULL, 0x000fc400078e0014ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff147224ULL, 0x000fe400078e0018ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fe200078e0013ULL,
0x0000002c42007844ULL, 0x000fe20000000200ULL, 0x000000ffff127224ULL, 0x000fc400078e0015ULL,
0x000000ffff137224ULL, 0x000fe200078e0017ULL, 0x000000083c007844ULL, 0x0003e20000000200ULL,
0x000000ffff157224ULL, 0x000fe400078e001aULL, 0x000000ffff167224ULL, 0x000fe200078e0020ULL,
0x0000001044007844ULL, 0x0007e20000000200ULL, 0x000000ffff177224ULL, 0x000fe400078e0022ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff197224ULL, 0x000fe200078e001bULL,
0x000000143e007844ULL, 0x0007e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0021ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x0000001c46007844ULL, 0x0007e20000000200ULL,
0x000000ffff207224ULL, 0x000fe400078e0031ULL, 0x000000ffff217224ULL, 0x000fe200078e0033ULL,
0x0000001840007844ULL, 0x0007e20000000200ULL, 0x000000ffff227224ULL, 0x000fe400078e0035ULL,
0x000000ffff237224ULL, 0x000fe400078e0037ULL, 0x000000ffff267224ULL, 0x000fc400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x0000002048007844ULL, 0x0007e20000000200ULL,
0x00000001ff087424ULL, 0x002fc600078e00ffULL, 0x01a000040e008388ULL, 0x0007e80000000c00ULL,
0x01a200240e008388ULL, 0x0007e20000000c00ULL, 0x000000627800720cULL, 0x000fe20003f06070ULL,
0x01a6080877ff79a7ULL, 0x000fe2000850003fULL, 0x01a6100877ff79a7ULL, 0x000fe2000850003fULL,
0x01a6180877ff79a7ULL, 0x000fe2000850003fULL, 0x01a6200877ff79a7ULL, 0x0003e4000850003fULL,
0x000000ffff087224ULL, 0x002fce00078e005cULL, 0xffffff9000348947ULL, 0x00cfea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000082027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe88023c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001118ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000017800ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018980ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000189c0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000189c0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000018fb8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018fb8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001118ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000017800ULL, 0x0000000000017800ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000018980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000189c0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 102664;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
