/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019cc0ULL, 0x0000000000019940ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017d40ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000017ec0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017f00ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017f50ULL, 0x0000000000000130ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000018080ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00017d4000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x005dbc0400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00017d4000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808708288080ULL,
0x8093082880808d08ULL, 0x0828808094082880ULL, 0x8080960828808095ULL, 0x9c08288080970828ULL,
0x288080a508288080ULL, 0x80ec08288080a708ULL, 0x08288080f0082880ULL, 0x8080f208288080f1ULL,
0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00017ec000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808d08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL,
0xa6082880809c0828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f1082880ULL,
0x8080a508288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b800000000ULL, 0x00017f0000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ec288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808d08288080ULL, 0x8094082880809308ULL,
0x0828808095082880ULL, 0x8080970828808096ULL, 0xa5082880809c0828ULL, 0x288080a708288080ULL,
0x80f008288080ec08ULL, 0x08288080f1082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028800000000ULL,
0x00017f5000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000e0ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000016ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000eb000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000170019c2804ULL, 0x000005a000000340ULL,
0x00002dd000002d20ULL, 0x0000305000002ee0ULL, 0x00003320000031c0ULL, 0x000037b000003770ULL,
0x000037f0000037c0ULL, 0x00005ab000005a20ULL, 0x00005d4000005bd0ULL, 0x0000601000005eb0ULL,
0x000064d000006490ULL, 0x00006510000064e0ULL, 0x000085b000008510ULL, 0x00008840000086d0ULL,
0x00008b10000089b0ULL, 0x00008fd000008f90ULL, 0x0000901000008fe0ULL, 0x0000b1b00000b110ULL,
0x0000b4300000b2c0ULL, 0x0000b7000000b5a0ULL, 0x0000bbc00000bb80ULL, 0x0000bc000000bbd0ULL,
0x0000d0800000d070ULL, 0x0000d0a00000d090ULL, 0x00015ac000015a80ULL, 0x00015ae000015ad0ULL,
0x00015b5000015b30ULL, 0x00015b8000015b70ULL, 0x00016f1000016ec0ULL, 0x00016fa000016f60ULL,
0x0001702000016fe0ULL, 0x000170c000017070ULL, 0x0001716000017110ULL, 0x00017200000171b0ULL,
0x0001729000017250ULL, 0x00017310000172d0ULL, 0x000173b000017360ULL, 0x0001745000017400ULL,
0x000174f0000174a0ULL, 0x0001758000017540ULL, 0x00017600000175c0ULL, 0x000176a000017650ULL,
0x00017740000176f0ULL, 0x000177e000017790ULL, 0x0001787000017830ULL, 0x000178f0000178b0ULL,
0x0001799000017940ULL, 0x00017a30000179e0ULL, 0x00017ae000017a80ULL, 0x00017ba000017b40ULL,
0x00017c6000017c00ULL, 0x00017d2000017cc0ULL, 0x0000043004403904ULL, 0x00012600000000ffULL,
0x00000470003f0100ULL, 0x000126080000000fULL, 0x000004f0003f0120ULL, 0x000126880000000fULL,
0x00000510003f0120ULL, 0x000126a80000000fULL, 0x00000530003f0120ULL, 0x000126c80000000fULL,
0x00000ec0003f0120ULL, 0x00012600000000ffULL, 0x000010c0003f0107ULL, 0x0000000400000002ULL,
0x00001170003f0102ULL, 0x0000000000000002ULL, 0x00001b80003f0101ULL, 0x00000000000000ffULL,
0x00001c0000040107ULL, 0x00000000000000ffULL, 0x00001c6000040101ULL, 0x000126c800000002ULL,
0x00001de0003f0101ULL, 0x000126cc00000019ULL, 0x00001fd0003f0105ULL, 0x000126cc00000019ULL,
0x00002910003f0105ULL, 0x000126b000000019ULL, 0x000029c0003f0107ULL, 0x000126b000000019ULL,
0x00002a20003f0101ULL, 0x0001260800000003ULL, 0x00002a40003f0101ULL, 0x0001260c00000003ULL,
0x00002c10003f0105ULL, 0x0001260c00000003ULL, 0x000034d0003f0105ULL, 0x000126ac00000019ULL,
0x000036a0003f0105ULL, 0x000126ac00000019ULL, 0x00004ba0003f0105ULL, 0x000000000000006cULL,
0x00004c00003f0101ULL, 0x0001268800000025ULL, 0x00004c30003f0101ULL, 0x0000000400000004ULL,
0x00004df0003f0105ULL, 0x0000000400000004ULL, 0x00005680003f0105ULL, 0x000126a8000000ffULL,
0x0000570000040107ULL, 0x000126a8000000ffULL, 0x0000576000040101ULL, 0x0001262800000003ULL,
0x00005780003f0101ULL, 0x0001262c00000003ULL, 0x00005950003f0105ULL, 0x0001262c00000003ULL,
0x00006200003f0105ULL, 0x000126b40000006cULL, 0x000063d0003f0105ULL, 0x000126b40000006cULL,
0x00007680003f0105ULL, 0x000000000000006eULL, 0x000076e0003f0101ULL, 0x0001269000000026ULL,
0x00007710003f0101ULL, 0x0000000400000004ULL, 0x000078d0003f0105ULL, 0x0000000400000004ULL,
0x00008120003f0105ULL, 0x000126b000000025ULL, 0x000081f0003f0107ULL, 0x000126b000000025ULL,
0x00008250003f0101ULL, 0x0001264800000003ULL, 0x00008270003f0101ULL, 0x0001264c00000003ULL,
0x00008440003f0105ULL, 0x0001264c00000003ULL, 0x00008d00003f0105ULL, 0x000126ac00000070ULL,
0x00008ed0003f0105ULL, 0x000126ac00000070ULL, 0x0000a1b0003f0105ULL, 0x0000000000000025ULL,
0x0000a210003f0101ULL, 0x000126980000001aULL, 0x0000a240003f0101ULL, 0x0000000400000025ULL,
0x0000a420003f0105ULL, 0x0000000400000025ULL, 0x0000ad70003f0105ULL, 0x000126a800000020ULL,
0x0000ae00003f0107ULL, 0x000126a800000020ULL, 0x0000ae60003f0101ULL, 0x0001266800000005ULL,
0x0000ae90003f0101ULL, 0x0001266c00000005ULL, 0x0000b060003f0105ULL, 0x0001266c00000005ULL,
0x0000b8e0003f0105ULL, 0x000126b40000001fULL, 0x0000bab0003f0105ULL, 0x000126b40000001fULL,
0x0000ce20003f0105ULL, 0x0000000000000004ULL, 0x0000cea0003f0101ULL, 0x0000000000000002ULL,
0x0000f0b0003f0101ULL, 0x00012600000000ffULL, 0x0000fd00003f0101ULL, 0x00012604000000ffULL,
0x0000ff10003f0105ULL, 0x00012604000000ffULL, 0x00010290003f0105ULL, 0x00012600000000ffULL,
0x000102c0003f0101ULL, 0x00012604000000ffULL, 0x00010480003f0105ULL, 0x00012604000000ffULL,
0x00012d20003f0105ULL, 0x0000000000000066ULL, 0x00012de0003f0101ULL, 0x0000000400000066ULL,
0x00012fb0003f0105ULL, 0x0000000400000066ULL, 0x00016d20003f0105ULL, 0x0000000000000069ULL,
0x00016d80003f0101ULL, 0x0000000800000069ULL, 0x00016de0003f0101ULL, 0x0000001000000069ULL,
0x00016e50003f0101ULL, 0x0000001800000069ULL, 0x00053803003f0101ULL, 0x0000dfa000301c04ULL,
0x0000e2700000dfd0ULL, 0x0000e6500000e460ULL, 0x0000ea300000e840ULL, 0x0000ee200000ec20ULL,
0x000104e00000efd0ULL, 0x0000040100016e90ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000334ULL,
0x0000001900000002ULL, 0x0000000000000264ULL, 0x0000001900000002ULL, 0x00000000000001a4ULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000310ULL, 0x0000001900000002ULL, 0x0000000000000240ULL,
0x0000001900000002ULL, 0x000000000000017dULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606130981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff167624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00005a00ff157624ULL, 0x000fc600078e00ffULL,
0x0000000000147919ULL, 0x000e620000002300ULL, 0x0000590015157a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff117819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff11117589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x008fc800078e0a05ULL,
0x0000040003007624ULL, 0x000fca00078e0216ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000307077227ULL, 0x000fe400078e0006ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000001007127227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x0000000005007224ULL, 0x000fca00078e0210ULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x0000010014037a24ULL, 0x002fe400078e0203ULL,
0x00001fff14147589ULL, 0x000e6400000e0000ULL, 0x00000000030f7a24ULL, 0x000fd000078e020aULL,
0x0000000100005824ULL, 0x000fe200078e0a05ULL, 0x0000000112125810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000050000720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000030f00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0f00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000112126810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x00000005ff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a12ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x0000000005107224ULL, 0x000fc400078e0210ULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x0000002010107824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff0ea424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x012688060f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe80000008a00ULL,
0x0124000e0f00a388ULL, 0x000fe80000004800ULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000113130824ULL, 0x004fe400078e0a02ULL, 0x00005800ff138624ULL, 0x000fc400078e00ffULL,
0x0000580004028a24ULL, 0x000fe400078e02ffULL, 0x00005a0013037a24ULL, 0x000fe400078e02ffULL,
0x00000015027b7224ULL, 0x000fe400078e02ffULL, 0x0000000103007824ULL, 0x040fe200078e0a10ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000100300720cULL, 0x000fe20003f26070ULL,
0x00005a0012187a24ULL, 0x000fe200078e027bULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff007a7207ULL, 0x000fe20000800000ULL, 0x0000000414007824ULL, 0x002fc600078e0211ULL,
0x000000207a00780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x00000000000f7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc8000001160fULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe03077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x00000001100c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07037227ULL, 0x000fc800078e0006ULL, 0x0000000110067824ULL, 0x000fe400078e020aULL,
0x0000000c030d7227ULL, 0x000fc800078e00ffULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a07ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x00005a0003037a24ULL, 0x000fe400078e0206ULL, 0x00005a0017087a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x000000007a037217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x000fe20004000000ULL, 0x000000010a007824ULL, 0x000fe200078e020fULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000030500720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000030900720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe400078e0a08ULL, 0x00005a000d067a24ULL, 0x000fe400078e0206ULL,
0x00005a00170c7a24ULL, 0x000fe400078e020cULL, 0x0000000118067824ULL, 0x040fe400078e0206ULL,
0x00000001180d7824ULL, 0x000fc400078e020cULL, 0x0000001507067224ULL, 0x080fe400078e0206ULL,
0x000000100f057824ULL, 0x000fe400078e00ffULL, 0x0000001508087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f005037812ULL, 0x000fc600078ec0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000306067212ULL, 0x000fc600078efcffULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000308037212ULL, 0x000fe200078efcffULL,
0x000000010b0a7824ULL, 0x040fe200078e020fULL, 0x0000600006067a10ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d007812ULL, 0x000fe400078ee200ULL,
0x0000600003087a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc400017fe4ffULL,
0x0000610009097a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x00000000000f7919ULL, 0x000eae0000000000ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x000000000f007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe03067810ULL, 0x002fe20007ffe0ffULL,
0x0000000110037824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x0000000110077824ULL, 0x000fe400078e020aULL, 0x0000000308057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006067a24ULL, 0x000fe400078e0203ULL,
0x00005a000c097a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x0000000108082810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff097a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000000108083810ULL, 0x000fe40007ffe0ffULL, 0x0000000509067207ULL, 0x000fe20004000000ULL,
0x000000100f057824ULL, 0x000fe200078e00ffULL, 0x0000000809087207ULL, 0x000fc60004000000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0a06ULL, 0x000000f0050b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a08ULL, 0x00005a000c037a24ULL, 0x000fe400078e0203ULL,
0x00005a000e077a24ULL, 0x000fe400078e0207ULL, 0x0000000118037824ULL, 0x040fe400078e0203ULL,
0x0000000118077824ULL, 0x000fc400078e0207ULL, 0x0000001506067224ULL, 0x080fe400078e0203ULL,
0x0000001508087224ULL, 0x000fe400078e0207ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fc600078efcffULL,
0x0000000100037824ULL, 0x100fe200078e020fULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a007824ULL, 0x000fe200078e020fULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c037812ULL, 0x000fe400078ee203ULL,
0x0000610007077a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00b007812ULL, 0x000fe200078ee200ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000037300ULL, 0x000e7000000e0000ULL,
0x0000000000077309ULL, 0x000ea20000000000ULL, 0x000000060300720cULL, 0x002fe20003f02070ULL,
0x00000004ff037424ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0a07ULL,
0x0000680004067625ULL, 0x000fd000078e0003ULL, 0x01260408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000003f0e0d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0e087810ULL, 0x002fc40007ffe0ffULL,
0x00000006ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0c7819ULL, 0x000fca0000011608ULL,
0x0000dfd000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011611ULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x0001268811027811ULL, 0x000fe400078e18ffULL,
0x03ffffff0b1a7812ULL, 0x000fc800078ec0ffULL, 0x0000000d1a00720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0000078624ULL, 0x000fe400078e0207ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x000000011a068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040902ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606008981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000004012097824ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011611ULL, 0x0000000002ff7f8cULL, 0x0003e8000c80043fULL,
0x000000200a847824ULL, 0x000fca00078e00ffULL, 0x0000002009087812ULL, 0x000fe200078ef884ULL,
0x0000590000137a24ULL, 0x004fe200078e02ffULL, 0x0000000111007812ULL, 0x000fc600078ec0ffULL,
0x0000004013237824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x000000840e077217ULL, 0x002fe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x100fe4000001160fULL, 0x0000640023217a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe200078e0a84ULL, 0x0000000402147810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0202ULL, 0x0000000802157810ULL, 0x000fe40007ffe0ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x0000000106137824ULL, 0x040fe200078e020fULL,
0x0000650023237a11ULL, 0x000fe200020f3cffULL, 0x0000000806167824ULL, 0x000fc400078e00ffULL,
0x0000000107077824ULL, 0x000fe400078e0a00ULL, 0x0000000108067824ULL, 0x000fe200078e0206ULL,
0xfffffff816137812ULL, 0x000fe400078ee213ULL, 0x0000000c02167810ULL, 0x000fe40007ffe0ffULL,
0x000000071400720cULL, 0x080fe20003f46070ULL, 0x0000000100147824ULL, 0x040fe200078e0214ULL,
0x000000071500720cULL, 0x080fe20003f26070ULL, 0x0000000100157824ULL, 0x000fe200078e0215ULL,
0x000000070200720cULL, 0x080fe20003f66070ULL, 0x0000000100177824ULL, 0x000fe200078e0216ULL,
0x000000071600720cULL, 0x000fe20003f06070ULL, 0x0000000114007824ULL, 0x000fc400078e020fULL,
0x00000008141b7824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x0000000108147824ULL, 0x000fe200078e0214ULL,
0x0000007006067812ULL, 0x000fe200078ef805ULL, 0x0000000108167824ULL, 0x040fe400078e0215ULL,
0x0000000108187824ULL, 0x000fe200078e0217ULL, 0x0000000621067210ULL, 0x000fe20007f9e0ffULL,
0x0000000115027824ULL, 0x140fe400078e020fULL, 0x00000008151d7824ULL, 0x000fe400078e00ffULL,
0x0000000117007824ULL, 0x000fc400078e020fULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee202ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x100fe400078ef805ULL, 0x0000e0000a007811ULL, 0x000fe200078e68ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc600078ef805ULL,
0x0000000107077824ULL, 0x000fe200020e0623ULL, 0x0000007018057812ULL, 0x000fe200078ef805ULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x0000002114147210ULL, 0x080fe20007f9e0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0x0000002116167210ULL, 0x080fe20007fbe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0200ULL, 0x0000002105187210ULL, 0x000fe20007fde0ffULL,
0x0000000115157824ULL, 0x100fe200020e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000d901c46ULL, 0x0000000117177824ULL, 0x000fc400028e0623ULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x00000000141b7faeULL, 0x0003e2000d101c46ULL,
0x0000000119197824ULL, 0x000fc600030e0623ULL, 0x00000000161d7faeULL, 0x0003e8000c901c46ULL,
0x00000000181f7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x002fe200078e00ffULL, 0x00006400231d7a11ULL, 0x000fe400078038ffULL,
0x0000e0000a1f7811ULL, 0x000fe400078e68ffULL, 0x000000000f007211ULL, 0x000fc400078fe8ffULL,
0x0000650023237a11ULL, 0x000fe400000f3cffULL, 0x0000000400137810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e020fULL, 0x0000000800157810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x0000000813167824ULL, 0x000fe400078e00ffULL,
0x0000000115147824ULL, 0x100fe200078e020fULL, 0xfffffff807027812ULL, 0x000fe200078ee202ULL,
0x0000000113077824ULL, 0x000fc400078e020fULL, 0x0000000815177824ULL, 0x000fe400078e00ffULL,
0x0000000108067824ULL, 0x000fe200078e0200ULL, 0xfffffff8161b7812ULL, 0x000fe200078ee207ULL,
0x0000000108167824ULL, 0x000fe200078e0215ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff8171c7812ULL, 0x000fc600078ee214ULL,
0x0000000108147824ULL, 0x000fe200078e0213ULL, 0x0000007006067812ULL, 0x000fe200078ef805ULL,
0x0000000108187824ULL, 0x000fe400078e0200ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000061d067210ULL, 0x000fc60007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x000fc600078ef805ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fc600078ef805ULL, 0x0000000100087824ULL, 0x000fe200078e020fULL,
0x0000007018057812ULL, 0x000fe200078ef805ULL, 0x0000000800137824ULL, 0x000fe200078e00ffULL,
0x000000161d167210ULL, 0x000fe20007f3e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0623ULL,
0x000000141d147210ULL, 0x000fe20007f1e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021fULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x000000101c137824ULL, 0x100fe200078e021fULL,
0x000000051d187210ULL, 0x000fe20007f5e0ffULL, 0x0000001002057824ULL, 0x000fc400078e021fULL,
0x0000000115157824ULL, 0x100fe400000e0623ULL, 0x0000000117177824ULL, 0x000fe200008e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x00000010081d7824ULL, 0x000fe400078e021fULL, 0x0000000119197824ULL, 0x000fe200010e0623ULL,
0x00000000141b7faeULL, 0x0003e8000b901c46ULL, 0x0000000016137faeULL, 0x0003e8000b901c46ULL,
0x00000000181d7faeULL, 0x0003e4000b901c46ULL, 0x000000011a087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006a00ff057624ULL, 0x002fc800078e00ffULL, 0x00006a0000057624ULL, 0x000fc800078e0205ULL,
0x0000000105227824ULL, 0x000fc800078e0208ULL, 0x0000660022227625ULL, 0x000fcc00078e0003ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000000080a027824ULL, 0x000fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff187f8cULL, 0x002e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000b1d000008947ULL, 0x000fea0003800000ULL, 0x0000000204077824ULL, 0x000fe200078e00ffULL,
0x000000010a797812ULL, 0x000fe200078ec0ffULL, 0x00006a00ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x00006a0007077624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x004fca00078e0008ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0000000411047824ULL, 0x000fca00078e00ffULL, 0xfffffff804197812ULL, 0x000fca00078ec0ffULL,
0x0126cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x000126c819047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c021c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1b7819ULL, 0x000fc8000001141dULL,
0x0000001c1b1b7211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x000000021b1b7819ULL, 0x000fc8000000121cULL, 0x0000001b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc00191c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011027824ULL, 0x000fe200078e00ffULL,
0x0000000106177810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe002037812ULL, 0x000fe200078ec0ffULL, 0x0000004022277824ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x000fc60003f26070ULL, 0x0000010006037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fc80007ffe0ffULL, 0x00000020191c7812ULL, 0x000fca00078ec0ffULL,
0x0000000109217824ULL, 0x000fe200078e021cULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x000000190e027217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe4000001160fULL,
0x000000701d297812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a19ULL,
0x000000041b1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b1c7824ULL, 0x000fe200078e0203ULL,
0x0000640027257a11ULL, 0x000fc400078a38ffULL, 0x0000000302027217ULL, 0x000fe20007800000ULL,
0x000000011c177824ULL, 0x040fe200078e020fULL, 0x0000650027277a11ULL, 0x000fe200028f3cffULL,
0x000000081c207824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a03ULL,
0xfffffff820177812ULL, 0x000fe400078ee217ULL, 0x000000081b207810ULL, 0x040fe40007ffe0ffULL,
0x000000021b00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c1b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000021e00720cULL, 0x0c0fe20003f66070ULL, 0x000000011e1e7824ULL, 0x100fe200078e0203ULL,
0x000000022000720cULL, 0x0c0fe20003f46070ULL, 0x0000000120207824ULL, 0x100fe200078e0203ULL,
0x000000021b00720cULL, 0x040fe20003f06070ULL, 0x000000011b227824ULL, 0x000fc400078e0203ULL,
0x000000011e037824ULL, 0x040fe400078e020fULL, 0x000000081e267824ULL, 0x000fe400078e00ffULL,
0x0000000121027824ULL, 0x040fe400078e021cULL, 0x00000001211c7824ULL, 0x000fe200078e021eULL,
0xfffffff826197812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002902027212ULL, 0x000fc600078efcffULL,
0x00000001201b7824ULL, 0x040fe200078e020fULL, 0x0000000225027210ULL, 0x000fe20007fbe0ffULL,
0x0000000820287824ULL, 0x000fe200078e00ffULL, 0x000000291c1c7212ULL, 0x000fe200078efcffULL,
0x00000001211e7824ULL, 0x040fe400078e0220ULL, 0x0000000121207824ULL, 0x000fe200078e0222ULL,
0xfffffff8281b7812ULL, 0x000fe200078ee21bULL, 0x0000000122237824ULL, 0x000fe400078e020fULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000291e1e7212ULL, 0x000fe200078efcffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff822237812ULL, 0x000fe200078ee223ULL, 0x0000000103037824ULL, 0x100fe200028e0627ULL,
0x000000251c1c7210ULL, 0x000fe40007fbe0ffULL, 0x0000002920207212ULL, 0x000fe400078efcffULL,
0x0000f0000a227811ULL, 0x000fe200078e68ffULL, 0x000000011d1d7824ULL, 0x000fe200028e0627ULL,
0x000000251e1e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002520207210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fc400078e0222ULL, 0x0000001019197824ULL, 0x100fe400078e0222ULL,
0x000000101b1b7824ULL, 0x100fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000e101c46ULL, 0x000000011f1f7824ULL, 0x100fe400028e0627ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x000000001c197faeULL, 0x0003e2000d901c46ULL,
0x0000000121217824ULL, 0x000fc600030e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000d101c46ULL,
0x0000000020237faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001002027812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x0000640027257a11ULL, 0x000fe400078038ffULL, 0x000000020f027211ULL, 0x000fe400078fe8ffULL,
0x000000701d237812ULL, 0x000fc400078ec0ffULL, 0x00000008021e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x140fe200078e020fULL, 0x00000004021c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000802207824ULL, 0x000fe200078e00ffULL, 0x0000650027277a11ULL, 0x000fe200000f3cffULL,
0x000000011e1b7824ULL, 0x100fe200078e020fULL, 0x0000f0000a267811ULL, 0x000fe200078e68ffULL,
0x000000011c197824ULL, 0x000fe200078e020fULL, 0xfffffff820177812ULL, 0x000fe200078ee203ULL,
0x000000081e207824ULL, 0x000fe400078e00ffULL, 0x0000000121037824ULL, 0x000fc400078e0202ULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0xfffffff8201b7812ULL, 0x000fe200078ee21bULL,
0x00000001211c7824ULL, 0x000fe200078e021cULL, 0x0000000c02207810ULL, 0x000fe20007ffe0ffULL,
0x0000008003027825ULL, 0x000fe200078e00ffULL, 0xfffffff822197812ULL, 0x000fc600078ee219ULL,
0x00000001211e7824ULL, 0x040fe200078e021eULL, 0x0000002302027212ULL, 0x000fe200078efcffULL,
0x0000000121217824ULL, 0x000fe400078e0220ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000225027210ULL, 0x000fc60007f1e0ffULL, 0x0000000120227824ULL, 0x000fe200078e020fULL,
0x000000231c1c7212ULL, 0x000fe200078efcffULL, 0x0000000820297824ULL, 0x000fe400078e00ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000008021207825ULL, 0x000fe200078e00ffULL, 0x000000231e1e7212ULL, 0x000fc600078efcffULL,
0x0000000103037824ULL, 0x100fe200000e0627ULL, 0x0000002320207212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x100fe200078e0226ULL, 0x0000001c251c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001019197824ULL, 0x100fe200078e0226ULL, 0x0000001e251e7210ULL, 0x000fe20007f5e0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0226ULL, 0x0000002025207210ULL, 0x000fe20007f7e0ffULL,
0x000000011d1d7824ULL, 0x100fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc400010e0627ULL,
0x0000001022237824ULL, 0x000fe200078e0226ULL, 0x000000001c197faeULL, 0x0003e2000b901c46ULL,
0x0000000121217824ULL, 0x000fc600018e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000b901c46ULL,
0x0000000020237faeULL, 0x0003e4000b901c46ULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0x00000001081c7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028197812ULL, 0x000fe400078ec0ffULL, 0x0000000d1c00720cULL, 0x000fe40003f06070ULL,
0x00000000190473c2ULL, 0x000e6200000e0000ULL, 0x0000001028027812ULL, 0x040fe400078ec0ffULL,
0xffffffe028037812ULL, 0x040fe400078ec0ffULL, 0x0000000828177812ULL, 0x000fcc00078ec0ffULL,
0x00000001071c8824ULL, 0x000fe400078e021cULL, 0x00000004ff1d8424ULL, 0x000fe200078e00ffULL,
0x0000000317037210ULL, 0x000fe40007ffe002ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066001c1c8625ULL, 0x000fca00078e001dULL, 0x000000061c228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000196e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080003207f8cULL, 0x000664000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x01260c0003177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c177210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e1dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001141eULL,
0x0000001702027211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e061eULL,
0x0000000202027819ULL, 0x000fc80000001217ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0003177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100f027824ULL, 0x000fe200078e00ffULL, 0x00000001ff787819ULL, 0x000fe2000001160fULL,
0x0000002011177824ULL, 0x000fe400078e00ffULL, 0xffffffffff857424ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc400078ec0ffULL, 0xffffff8017177812ULL, 0x000fe400078ec0ffULL,
0x0000000c78787812ULL, 0x000fc800078ec0ffULL, 0x0000001778177210ULL, 0x000fca0007ffe002ULL,
0x01200000171b7984ULL, 0x000e680000000800ULL, 0x01220000171d7984ULL, 0x0006a20000000800ULL,
0x0000001a1b00720bULL, 0x002fe20003f1d000ULL, 0x000141827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000177806ULL, 0x008fc800000e0100ULL, 0x000000ff1700720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e001aULL, 0x0000001fff877424ULL, 0x000fe400078e00ffULL,
0xffffffffff867424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000110b00720cULL, 0x000fe40003f05270ULL, 0x0000001a1b00720bULL, 0x000fe20003f54000ULL,
0x000141227f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x00000080111f8824ULL, 0x000fe200078e0202ULL, 0x0000001a1b237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000178208824ULL, 0x000fca00078e021fULL,
0x0124002320008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001a231a7221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL, 0x0000001a001a7308ULL, 0x000e640000000800ULL,
0x0000001a24247220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x000140627f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x00013f327f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x00013e027f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x00013ce27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c17ff7212ULL, 0x000fda00078030ffULL, 0x800000231b1b0221ULL, 0x000fe20000010000ULL,
0x00007610ff1e0816ULL, 0x000fc6000000001eULL, 0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL,
0x0000001b00000308ULL, 0x000e640000000800ULL, 0x000000001d1d0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000241d247221ULL, 0x004fc20000010000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0126ac0019177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141dULL, 0x0000001c17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000217177819ULL, 0x000fc8000000121cULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0019177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101e177816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff177819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000138d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1716137589ULL, 0x0002a400000e0000ULL,
0x0000000817277810ULL, 0x002fe20007ffe0ffULL, 0x000139027f007947ULL, 0x000fea000b800000ULL,
0x0000001017157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001817277810ULL, 0x002fe20007ffe0ffULL,
0x000139527f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000211257824ULL, 0x000fe200078e00ffULL,
0x000000080f187812ULL, 0x000fe200078ec0ffULL, 0x0000000411207824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000400111b7824ULL, 0x000fe200078e00ffULL,
0x00000004251e7812ULL, 0x000fe200078ec0ffULL, 0x00001000111c7824ULL, 0x000fe200078e00ffULL,
0x0000000718177812ULL, 0x000fe200078ef80fULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000001e0f1a7211ULL, 0x000fc400078fe0ffULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117187824ULL, 0x000fe200078e021aULL, 0x000000200f207211ULL, 0x000fe200078fe0ffULL,
0x0000000817277824ULL, 0x002fe200078e00ffULL, 0x0000a0001b217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x0000001017197812ULL, 0x000fc400078efcffULL,
0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001171c7824ULL, 0x000fe400078e0220ULL,
0x000000011a1a7824ULL, 0x000fe200078e0219ULL, 0x0000e0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8271b7812ULL, 0x000fe200078ee21cULL,
0x0000001018747824ULL, 0x000fc600078e0221ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x000000101b807824ULL, 0x000fe400078e021dULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x000000101a707824ULL, 0x000fcc00078e0221ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747232ULL, 0x086fe40000000000ULL,
0x0000001376767232ULL, 0x000fe40000000000ULL, 0x0000001475757232ULL, 0x088fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x080fe40000000000ULL,
0x0000001572727232ULL, 0x000fc40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000008080783bULL, 0x000ee20000004200ULL, 0x000000021e1e7812ULL, 0x000fe200078efcffULL,
0x000008e000007945ULL, 0x000fe20003800000ULL, 0xfffffff81f1c7812ULL, 0x000fe400078ee21cULL,
0x0000001e0f1e7211ULL, 0x000fc600078fe0ffULL, 0x000000101c7c7824ULL, 0x000fcc00078e021dULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x00000018ff1d7819ULL, 0x008fe20000011480ULL,
0x0000010082897824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe40000011481ULL,
0x0000001d002a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011483ULL,
0x00000018ff267819ULL, 0x000fe40000011482ULL, 0x00000018ff897819ULL, 0x000fc60000011489ULL,
0x0000001f006d7306ULL, 0x0003e20000200c00ULL, 0x00008880801d7816ULL, 0x048fe200000000ffULL,
0x000001007d917824ULL, 0x004fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe2000001147cULL,
0x000001007f977824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001147dULL,
0x00000018ff6c7819ULL, 0x000fe2000001147eULL, 0x00000029008f7306ULL, 0x0005e20000200c00ULL,
0x00000100801f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001147fULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x000088807d907816ULL, 0x040fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x0000002b00927306ULL, 0x0003e20000200c00ULL, 0x0000010081297824ULL, 0x004fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x000088807f957816ULL, 0x040fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x0000006c00967306ULL, 0x000fe20000200c00ULL, 0x00000018ff2b7819ULL, 0x002fe40000011429ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002b006c7306ULL, 0x0003f00000200c00ULL,
0x00000027008d7306ULL, 0x0005e20000200c00ULL, 0x00008880832b7816ULL, 0x002fce00000000ffULL,
0x0000008000297306ULL, 0x0002e20000200c00ULL, 0x0000888081277816ULL, 0x044fe200000000ffULL,
0x0001000081817824ULL, 0x000fca00078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000002b008c7306ULL, 0x0005e20000200c00ULL, 0x0000010083807824ULL, 0x042fe400078e00ffULL,
0x0001000083837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000026008b7306ULL, 0x000fe20000200c00ULL, 0x000001007c2b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x008fe4000000002aULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000001d001d7306ULL, 0x000ff00000200c00ULL,
0x0000001f00267306ULL, 0x0002b00000200c00ULL, 0x0000008800997306ULL, 0x000fe20000200c00ULL,
0x00008880821f7816ULL, 0x042fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008100887306ULL, 0x000fe20000200c00ULL,
0x000054101d267816ULL, 0x004fce0000000026ULL, 0x0000008000817306ULL, 0x000ff00000200c00ULL,
0x00000083008e7306ULL, 0x0003f00000200c00ULL, 0x0000002b00807306ULL, 0x0005e20000200c00ULL,
0x000001007e837824ULL, 0x002fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000089008a7306ULL, 0x0003e20000200c00ULL, 0x000088807e2b7816ULL, 0x044fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000002700277306ULL, 0x000ea20000200c00ULL, 0x000088807c897816ULL, 0x042fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007e001d7306ULL, 0x000e700000200c00ULL, 0x0000001f001f7306ULL, 0x000ee20000200c00ULL,
0x0000541027277816ULL, 0x004fce000000006cULL, 0x0000002b00937306ULL, 0x0005e20000200c00ULL,
0x000054101d967816ULL, 0x002fe20000000096ULL, 0x00000001171d7824ULL, 0x100fe200078e021eULL,
0x00000026742c723cULL, 0x000f62000000182cULL, 0x00000001191e7824ULL, 0x000fc800078e021eULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x00005410882b7816ULL, 0x004fe4000000006dULL,
0x000054101f6c7816ULL, 0x008fe2000000008aULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x000054108c6d7816ULL, 0x000fe20000000081ULL, 0x00000026704c723cULL, 0x000b64000000184cULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0xfffffff81f1e7812ULL, 0x000fe400078ee21eULL,
0x0000e0000a1f7811ULL, 0x000fc400078e68ffULL, 0x0000000119267824ULL, 0x060fe200078e0220ULL,
0x0000002a7430723cULL, 0x000f620000001830ULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x0000541082827816ULL, 0x002fc6000000008bULL,
0xfffffff827207812ULL, 0x000fe400078ee226ULL, 0x0000002a7050723cULL, 0x000b640000001850ULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x0000541089807816ULL, 0x004fc80000000080ULL,
0x00000008172a7824ULL, 0x020fe200078e00ffULL, 0x0000006c7434723cULL, 0x000f640000001834ULL,
0x0000007c007c7306ULL, 0x000ea40000200c00ULL, 0xfffffff82a1d7812ULL, 0x000fc800078ee21dULL,
0x0000006c7054723cULL, 0x000f640000001854ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541090817816ULL, 0x002fce0000000091ULL, 0x0000008300947306ULL, 0x0002e20000200c00ULL,
0x000054107c7c7816ULL, 0x004fe2000000008fULL, 0x00000080743c723cULL, 0x080f6c000000183cULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x000054108e837816ULL, 0x002fe2000000008dULL,
0x00000080705c723cULL, 0x000b62000000185cULL, 0x000054107d7d7816ULL, 0x008fca0000000092ULL,
0x0000009700987306ULL, 0x000e620000200c00ULL, 0x0000541093947816ULL, 0x000fe20000000094ULL,
0x000000827438723cULL, 0x000f640000001838ULL, 0x0000001020807824ULL, 0x020fc800078e021fULL,
0x0000007f00887306ULL, 0x000ea40000200c00ULL, 0x0000007c7440723cULL, 0x000f620000001840ULL,
0x0000541095957816ULL, 0x002fce0000000098ULL, 0x000000827058723cULL, 0x000f620000001858ULL,
0x0000541088977816ULL, 0x004fce0000000099ULL, 0x000000947444723cULL, 0x040f700000001844ULL,
0x000000967448723cULL, 0x000b6e0000001848ULL, 0x000000101d747824ULL, 0x120fe200078e0221ULL,
0x0000007c7060723cULL, 0x000f620000001860ULL, 0x000000101e217824ULL, 0x000fc800078e0221ULL,
0x000000007474783bULL, 0x000e660000000200ULL, 0x000000947064723cULL, 0x040f700000001864ULL,
0x000000967068723cULL, 0x000b640000001868ULL, 0x000000002170783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001374747232ULL, 0x082fe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008192a7824ULL, 0x000fe200078e00ffULL,
0x0000000226217810ULL, 0x004fe20007ffe0ffULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0xfffffff825257812ULL, 0x000fc400078ec0ffULL, 0xfffffff82a217812ULL, 0x000fca00078ee221ULL,
0x00000010217c7824ULL, 0x000fcc00078e021fULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000018ff267819ULL, 0x004fe40000011480ULL, 0x00000018ff277819ULL, 0x000fe40000011481ULL,
0x00000026002a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff297819ULL, 0x000fe40000011482ULL,
0x00000018ff2b7819ULL, 0x000fe40000011483ULL, 0x00008880838c7816ULL, 0x000fc600000000ffULL,
0x00000027006d7306ULL, 0x0003e20000200c00ULL, 0x0000888080267816ULL, 0x004fe200000000ffULL,
0x000001007c907824ULL, 0x008fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001147cULL,
0x000001007d917824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001147dULL,
0x000001007e967824ULL, 0x000fe200078e00ffULL, 0x000088807c8f7816ULL, 0x000fe200000000ffULL,
0x00000029008b7306ULL, 0x0005e20000200c00ULL, 0x0000010080277824ULL, 0x042fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001147eULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001147fULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000010081297824ULL, 0x004fe200078e00ffULL, 0x0000002b008d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x000088807e957816ULL, 0x040fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x000088807f977816ULL, 0x000fe400000000ffULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x0000006c00927306ULL, 0x0005e20000200c00ULL,
0x00008880812b7816ULL, 0x042fe200000000ffULL, 0x0001000081817824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fc40000011491ULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x00000018ff6c7819ULL, 0x004fe40000011429ULL, 0x00000018ff7e7819ULL, 0x000fca000001147eULL,
0x0000008000297306ULL, 0x0002b00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x0000010083807824ULL, 0x042fe400078e00ffULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008800937306ULL, 0x000fe20000200c00ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x004fca000000002aULL,
0x0000002b002b7306ULL, 0x000fe20000200c00ULL, 0x0000541026267816ULL, 0x008fce0000000027ULL,
0x0000006c006c7306ULL, 0x000e700000200c00ULL, 0x0000008100887306ULL, 0x000eb00000200c00ULL,
0x0000008000817306ULL, 0x0007e20000200c00ULL, 0x000054102b277816ULL, 0x002fce000000006cULL,
0x00000083008e7306ULL, 0x0003e20000200c00ULL, 0x000088807d807816ULL, 0x008fe200000000ffULL,
0x00000026742c723cULL, 0x000f62000000182cULL, 0x00005410882b7816ULL, 0x004fca000000006dULL,
0x0000008900987306ULL, 0x0005e20000200c00ULL, 0x000100007d837824ULL, 0x002fe200078e00ffULL,
0x0000002a7430723cULL, 0x000f680000001830ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000008a00997306ULL, 0x0003e20000200c00ULL, 0x0000888082897816ULL, 0x044fe200000000ffULL,
0x00000026704c723cULL, 0x040f6c000000184cULL, 0x0000007c007d7306ULL, 0x0004e20000200c00ULL,
0x00000100828a7824ULL, 0x042fe200078e00ffULL, 0x0000002a7050723cULL, 0x000f620000001850ULL,
0x0001000082827824ULL, 0x000fc600078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000001007f7c7824ULL, 0x044fe200078e00ffULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x000100007f7f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x000054107d927816ULL, 0x008fce0000000092ULL,
0x0000009000907306ULL, 0x000eb00000200c00ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x002fce000000008bULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x000054108f907816ULL, 0x004fce0000000090ULL, 0x0000008300947306ULL, 0x0004f00000200c00ULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x000054108e837816ULL, 0x004fe4000000008dULL,
0x0000541080917816ULL, 0x002fca0000000091ULL, 0x0000009600967306ULL, 0x000e620000200c00ULL,
0x0000541094937816ULL, 0x008fe20000000093ULL, 0x000000827438723cULL, 0x040f6c0000001838ULL,
0x0000009700977306ULL, 0x000fe40000200c00ULL, 0x00000090743c723cULL, 0x040f6c000000183cULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541095967816ULL, 0x002fe20000000096ULL,
0x000000927440723cULL, 0x000f6c0000001840ULL, 0x0000007e00297306ULL, 0x000e640000200c00ULL,
0x000000827058723cULL, 0x040f6c0000001858ULL, 0x0000007f00887306ULL, 0x000ee20000200c00ULL,
0x0000541097977816ULL, 0x004fe2000000007cULL, 0x00000090705c723cULL, 0x000f62000000185cULL,
0x0000541029987816ULL, 0x002fca0000000098ULL, 0x0000008900897306ULL, 0x000fe40000200c00ULL,
0x000000967444723cULL, 0x000f620000001844ULL, 0x0000541088997816ULL, 0x008fca0000000099ULL,
0x0000008a008a7306ULL, 0x000e640000200c00ULL, 0x000000927060723cULL, 0x000f6c0000001860ULL,
0x0000008c008c7306ULL, 0x000ea40000200c00ULL, 0x000000987448723cULL, 0x000f620000001848ULL,
0x00005410896c7816ULL, 0x002fce000000008aULL, 0x000000967064723cULL, 0x000f620000001864ULL,
0x000054108c6d7816ULL, 0x004fce0000000081ULL, 0x000000987068723cULL, 0x000f700000001868ULL,
0x0000006c7434723cULL, 0x080f700000001834ULL, 0x0000006c7054723cULL, 0x000b6e0000001854ULL,
0x000126c80a6c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006c6c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff297224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x000fc80000015200ULL, 0x0000040004257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e27ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010006257824ULL, 0x000fca00078e0225ULL, 0x0000008025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590022257a24ULL, 0x010fc600078e02ffULL, 0x0000002027227812ULL, 0x000fe200078ec0ffULL,
0x0000004025297824ULL, 0x000fc800078e00ffULL, 0x0000000109707824ULL, 0x000fe200078e0222ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000270e227217ULL, 0x000fe40007800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x00000003ff267819ULL, 0x000fe2000001160fULL,
0x0000000122227824ULL, 0x000fc600078e0a27ULL, 0x00000004262b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e0225ULL, 0x0000002225227217ULL, 0x000fe40007800000ULL,
0x00000008266c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001272a7824ULL, 0x040fe400078e020fULL,
0x00000008276d7824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x000fc600078e0a25ULL,
0xfffffff86d727812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x100fe200078e0225ULL,
0x0000000c266d7810ULL, 0x040fe40007ffe0ffULL, 0x000000222600720cULL, 0x080fe20003f86070ULL,
0x0000000127267824ULL, 0x000fe200078e0270ULL, 0x000000226c00720cULL, 0x0c0fe20003f46070ULL,
0x000000016c6c7824ULL, 0x100fe200078e0225ULL, 0x000000222b00720cULL, 0x080fe20003f66070ULL,
0x000000016d737824ULL, 0x040fe200078e0225ULL, 0x000000226d00720cULL, 0x000fe20003f06070ULL,
0x000000012a257824ULL, 0x000fc400078e020fULL, 0x000000082a747824ULL, 0x000fe400078e00ffULL,
0x000000016c2b7824ULL, 0x040fe400078e020fULL, 0x000000086c767824ULL, 0x000fe200078e00ffULL,
0xfffffff874227812ULL, 0x000fe200078ee225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000640029257a11ULL, 0x040fe400078a38ffULL, 0xfffffff876747812ULL, 0x000fe200078ee22bULL,
0x000000012a2a7824ULL, 0x100fe200078e0270ULL, 0x0000000226267212ULL, 0x000fe200078efcffULL,
0x000000016c6c7824ULL, 0x000fe200078e0270ULL, 0x0000650029297a11ULL, 0x000fe200028f3cffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fc60007fbe0ffULL,
0x0000000173707824ULL, 0x000fe200078e0270ULL, 0x000000022a2a7212ULL, 0x000fe200078efcffULL,
0x000000806c6c7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026c6c7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0629ULL,
0x000000252a2a7210ULL, 0x080fe20007fbe0ffULL, 0x0000000173757824ULL, 0x040fe200078e020fULL,
0x0000000270707212ULL, 0x000fe200078efcffULL, 0x0000000873767824ULL, 0x000fe400078e00ffULL,
0x000000012b2b7824ULL, 0x000fe200028e0629ULL, 0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL,
0x0000001074737824ULL, 0x100fe200078e021fULL, 0x0000002570707210ULL, 0x000fe20007fde0ffULL,
0x0000001072257824ULL, 0x000fe200078e021fULL, 0xfffffff876767812ULL, 0x000fe200078ee275ULL,
0x000000016d6d7824ULL, 0x000fc400028e0629ULL, 0x0000000171717824ULL, 0x000fe200030e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000e101c46ULL,
0x0000001022297824ULL, 0x100fe400078e021fULL, 0x0000001076757824ULL, 0x000fc600078e021fULL,
0x000000002a297faeULL, 0x0003e8000d901c46ULL, 0x000000006c737faeULL, 0x0003e8000d101c46ULL,
0x0000000070757faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fc800078ec0ffULL, 0x000000260f227211ULL, 0x000fc800078fe8ffULL,
0x0000000422277810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x040fe200078e020fULL,
0x0000000c226d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000822727824ULL, 0x040fe400078e00ffULL,
0x0000000122267824ULL, 0x100fe400078e0270ULL, 0x00000001272a7824ULL, 0x000fe200078e0270ULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000086d767824ULL, 0x000fe200078e00ffULL,
0x0000000822257810ULL, 0x000fe20007ffe0ffULL, 0x0000000127227824ULL, 0x000fc400078e020fULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x00000001256c7824ULL, 0x040fe400078e0270ULL,
0x00000001252b7824ULL, 0x100fe200078e020fULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x0000000825747824ULL, 0x000fe400078e00ffULL, 0x000000016d257824ULL, 0x000fe400078e020fULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fc400078ee22bULL,
0xfffffff876767812ULL, 0x000fe200078ee225ULL, 0x000000016d707824ULL, 0x000fe200078e0270ULL,
0x0000640029257a11ULL, 0x040fe200078038ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000226267212ULL, 0x000fe400078efcffULL, 0x0000650029297a11ULL, 0x000fe200000f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fe40007f1e0ffULL,
0x000000022a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026c6c7212ULL, 0x000fc400078efcffULL, 0x0000002a252a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x000fe200000e0629ULL, 0x0000000270707212ULL, 0x000fe200078efcffULL,
0x0000001074737824ULL, 0x000fe200078e021fULL, 0x0000006c256c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200010e0629ULL, 0x0000007025707210ULL, 0x000fe20007f7e0ffULL,
0x0000001072257824ULL, 0x000fe400078e021fULL, 0x000000016d6d7824ULL, 0x100fe400000e0629ULL,
0x0000000171717824ULL, 0x000fe200018e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c46ULL, 0x0000001022297824ULL, 0x000fc400078e021fULL,
0x0000001076757824ULL, 0x000fc600078e021fULL, 0x000000002a297faeULL, 0x0003e8000b901c46ULL,
0x000000006c737faeULL, 0x0003e8000b901c46ULL, 0x0000000070757faeULL, 0x0003e4000b901c46ULL,
0x00000000280473c2ULL, 0x000ea200000e0000ULL, 0x0000000208267810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d2600720cULL, 0x000fda0003f06070ULL,
0x0000000107268824ULL, 0x000fe400078e0226ULL, 0x00000004ff278424ULL, 0x000fe200078e00ffULL,
0xfffffff004047892ULL, 0x004fc6000f8ec03fULL, 0x0000660026268625ULL, 0x000fe200078e0027ULL,
0x000126a804057890ULL, 0x000fc8000fffe03fULL, 0x0000000626228981ULL, 0x000328000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a800ff2a7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800036c7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01262c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002011257824ULL, 0x000fca00078e00ffULL, 0xffffff8025257812ULL, 0x000fc800078ec0ffULL,
0x0000008002257810ULL, 0x000fca0007ffe025ULL, 0x0000000178257824ULL, 0x000fca00078e0225ULL,
0x0120000025287984ULL, 0x000e680000000800ULL, 0x0122000025297984ULL, 0x0006a20000000800ULL,
0x000000232800720bULL, 0x002fe20003f1d000ULL, 0x000117727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000010b267810ULL, 0x000fe40007ffe0ffULL,
0x000000232800720bULL, 0x000fe40003f54000ULL, 0x000000112600720cULL, 0x000fe20003f05270ULL,
0x000117327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400010e0100ULL,
0x0000008011278824ULL, 0x000fe200078e0202ULL, 0x0000002328258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000178268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0003e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002328267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500737308ULL, 0x000e640000000800ULL, 0x0000007324247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x000116627f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x000115327f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x000114027f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x000112e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002328237209ULL, 0x000fd60007810000ULL,
0x8000002328280221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800000308ULL, 0x000e640000000800ULL,
0x0000000029290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002429247221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000811287824ULL, 0x000fca00078e00ffULL, 0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028266d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09006d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000006d28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff297819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x00010ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f2916137589ULL, 0x0002a400000e0000ULL,
0x0000000829277810ULL, 0x002fe20007ffe0ffULL, 0x00010ed27f007947ULL, 0x000fea000b800000ULL,
0x0000001029157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001829277810ULL, 0x002fe20007ffe0ffULL,
0x00010f227f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000040011257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100011267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x0000b00025257810ULL, 0x000fe40007ffe0ffULL, 0x0000f00026267810ULL, 0x000fc60007ffe0ffULL,
0x0000001018707824ULL, 0x100fe400078e0225ULL, 0x000000101a6c7824ULL, 0x000fe400078e0225ULL,
0x000000101b7c7824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001370707232ULL, 0x086fe40000000000ULL, 0x0000001372727232ULL, 0x000fc40000000000ULL,
0x0000001471717232ULL, 0x088fe40000000000ULL, 0x0000001473737232ULL, 0x000fe40000000000ULL,
0x000000156c6c7232ULL, 0x080fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x000000101c747824ULL, 0x000fe200078e0226ULL, 0x0000081000007945ULL, 0x000fea0003800000ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x00000018ff267819ULL, 0x008fc4000001147cULL,
0x00000018ff277819ULL, 0x002fe4000001147dULL, 0x0000002600287306ULL, 0x0003e20000200c00ULL,
0x00000018ff297819ULL, 0x000fe4000001147eULL, 0x00000018ff807819ULL, 0x000fe2000001147fULL,
0x00000100758f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011474ULL,
0x00000100748e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011475ULL,
0x0000002700827306ULL, 0x0005e20000200c00ULL, 0x000088807c267816ULL, 0x002fe200000000ffULL,
0x0000010076957824ULL, 0x000fe200078e00ffULL, 0x00008880748d7816ULL, 0x040fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fc40000011476ULL,
0x00000018ff8a7819ULL, 0x000fe20000011477ULL, 0x0000002900897306ULL, 0x0003e20000200c00ULL,
0x000001007c277824ULL, 0x044fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x0000888076947816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000001007d297824ULL, 0x002fe200078e00ffULL,
0x00000080008c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff957819ULL, 0x000fc40000011495ULL,
0x0000888077977816ULL, 0x000fe400000000ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000008100907306ULL, 0x0005e20000200c00ULL,
0x000088807d807816ULL, 0x042fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fc80000011476ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000002600267306ULL, 0x000fe20000200c00ULL, 0x00000018ff817819ULL, 0x004fce0000011429ULL,
0x0000007c00297306ULL, 0x0002b00000200c00ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x000001007f7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000002700277306ULL, 0x000e620000200c00ULL, 0x0000541029287816ULL, 0x004fce0000000028ULL,
0x0000007c008b7306ULL, 0x0005e20000200c00ULL, 0x000054107d297816ULL, 0x008fce0000000082ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x00008880757c7816ULL, 0x044fe200000000ffULL,
0x0001000075757824ULL, 0x000fe200078e00ffULL, 0x0000541026267816ULL, 0x002fe20000000027ULL,
0x000000287030723cULL, 0x080f660000001830ULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000008100817306ULL, 0x000e680000200c00ULL, 0x000000286c50723cULL, 0x000b680000001850ULL,
0x0000008300927306ULL, 0x0005e60000200c00ULL, 0x000010001f287810ULL, 0x020fca0007ffe0ffULL,
0x0000008800967306ULL, 0x0007e20000200c00ULL, 0x000088807e837816ULL, 0x004fe200000000ffULL,
0x0000001020297824ULL, 0x000fe200078e0228ULL, 0x0000541080277816ULL, 0x002fca0000000081ULL,
0x0000008a00987306ULL, 0x0003e20000200c00ULL, 0x000001007e887824ULL, 0x048fe200078e00ffULL,
0x00000026702c723cULL, 0x000f62000000182cULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x0000007500937306ULL, 0x0005e20000200c00ULL,
0x000088807f8a7816ULL, 0x042fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x000000266c4c723cULL, 0x000f66000000184cULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000007400917306ULL, 0x0002e20000200c00ULL,
0x0001000077757824ULL, 0x004fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011475ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x0000010077747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000009500957306ULL, 0x000e620000200c00ULL,
0x0000541091907816ULL, 0x008fe40000000090ULL, 0x0000541093917816ULL, 0x000fca0000000092ULL,
0x0000009700977306ULL, 0x000fe40000200c00ULL, 0x000000907040723cULL, 0x080f6c0000001840ULL,
0x0000007400807306ULL, 0x000ea20000200c00ULL, 0x0000541094947816ULL, 0x002fe20000000095ULL,
0x000000906c60723cULL, 0x000f6c0000001860ULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x0000541097957816ULL, 0x004fce0000000080ULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x000000947044723cULL, 0x080f6e0000001844ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x0000541083747816ULL, 0x002fe20000000088ULL,
0x000000946c64723cULL, 0x000f6c0000001864ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x000054108a757816ULL, 0x004fce000000008bULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107e7e7816ULL, 0x008fe20000000089ULL, 0x000000747034723cULL, 0x080f6c0000001834ULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x000054107f7f7816ULL, 0x002fe2000000008cULL,
0x000000746c54723cULL, 0x000f6c0000001854ULL, 0x0000007c007c7306ULL, 0x000fe40000200c00ULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x000054108d8e7816ULL, 0x004fe2000000008eULL, 0x0000007e6c58723cULL, 0x000f6c0000001858ULL,
0x0000007600777306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x000054107c8f7816ULL, 0x002fc4000000008fULL, 0x0000541077967816ULL, 0x004fca0000000096ULL,
0x0000008e703c723cULL, 0x000f62000000183cULL, 0x000054107d977816ULL, 0x008fce0000000098ULL,
0x0000008e6c5c723cULL, 0x000f70000000185cULL, 0x000000967048723cULL, 0x080b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000966c68723cULL, 0x000b620000001868ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x00000000256c783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000001370707232ULL, 0x082fe40000000000ULL, 0x0000001372727232ULL, 0x000fe40000000000ULL,
0x0000001471717232ULL, 0x080fe40000000000ULL, 0x0000001473737232ULL, 0x000fc40000000000ULL,
0x000000156c6c7232ULL, 0x088fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000297c783bULL, 0x000ea20000004200ULL,
0x0000001021747824ULL, 0x000fcc00078e0228ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000018ff257819ULL, 0x004fe4000001147cULL, 0x00000018ff267819ULL, 0x000fe4000001147dULL,
0x0000002500807306ULL, 0x0005e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe4000001147fULL,
0x00000018ff277819ULL, 0x000fe2000001147eULL, 0x00000100748e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011475ULL, 0x0000010075917824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011474ULL, 0x0000002600887306ULL, 0x0007e20000200c00ULL,
0x000088807c257816ULL, 0x004fe200000000ffULL, 0x0000010076967824ULL, 0x000fe200078e00ffULL,
0x00008880748d7816ULL, 0x040fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fc40000011476ULL, 0x00000018ff8a7819ULL, 0x000fe20000011477ULL,
0x00000081008c7306ULL, 0x0005e20000200c00ULL, 0x000001007c267824ULL, 0x048fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe40000011491ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000001007d817824ULL, 0x004fe200078e00ffULL,
0x00000027008b7306ULL, 0x0005e20000200c00ULL, 0x00008880758f7816ULL, 0x040fe200000000ffULL,
0x0001000075757824ULL, 0x000fe200078e00ffULL, 0x0000888076957816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc40000011481ULL,
0x0000888077977816ULL, 0x000fe200000000ffULL, 0x0000008300937306ULL, 0x0007e20000200c00ULL,
0x000088807d277816ULL, 0x044fe400000000ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ff967819ULL, 0x000fe40000011496ULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000008200907306ULL, 0x000fe20000200c00ULL, 0x000100007d837824ULL, 0x008fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fc80000011476ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007c007d7306ULL, 0x0005f00000200c00ULL, 0x0000008100827306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000002700277306ULL, 0x000ea20000200c00ULL, 0x000088807f817816ULL, 0x048fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002500257306ULL, 0x000ff00000200c00ULL, 0x0000002600267306ULL, 0x000ee20000200c00ULL,
0x0000541027277816ULL, 0x004fce0000000082ULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541025267816ULL, 0x008fce0000000026ULL,
0x0000007400917306ULL, 0x0004e20000200c00ULL, 0x00000026702c723cULL, 0x082f6e000000182cULL,
0x0000008900987306ULL, 0x0003e20000200c00ULL, 0x0000010077747824ULL, 0x044fe200078e00ffULL,
0x000000266c4c723cULL, 0x000b62000000184cULL, 0x0001000077777824ULL, 0x000fc600078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000008a00997306ULL, 0x0005e20000200c00ULL,
0x000088807e897816ULL, 0x002fe400000000ffULL, 0x0000541091907816ULL, 0x008fca0000000090ULL,
0x0000007400827306ULL, 0x0003e20000200c00ULL, 0x000001007e8a7824ULL, 0x044fe400078e00ffULL,
0x000100007e7e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000054107d747816ULL, 0x002fe40000000080ULL, 0x00000018ff7d7819ULL, 0x000fe40000011477ULL,
0x0000541081777816ULL, 0x000fc6000000007cULL, 0x0000008900897306ULL, 0x000ff00000200c00ULL,
0x0000008a008a7306ULL, 0x000ff00000200c00ULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000007f007f7306ULL, 0x000eb00000200c00ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107e7e7816ULL, 0x002fce000000008bULL, 0x0000008e008e7306ULL, 0x000e620000200c00ULL,
0x000054107f7f7816ULL, 0x004fce000000008cULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x0000007e7038723cULL, 0x080f6e0000001838ULL, 0x0000009200927306ULL, 0x000ea20000200c00ULL,
0x000054108d8e7816ULL, 0x002fe2000000008eULL, 0x0000007e6c58723cULL, 0x000f6c0000001858ULL,
0x0000007500947306ULL, 0x0002f00000200c00ULL, 0x0000009500957306ULL, 0x000fe20000200c00ULL,
0x0000541083757816ULL, 0x002fc40000000088ULL, 0x000054108f8f7816ULL, 0x004fca0000000092ULL,
0x0000009600967306ULL, 0x000e620000200c00ULL, 0x0000541094917816ULL, 0x008fe20000000093ULL,
0x000000747030723cULL, 0x040f6c0000001830ULL, 0x0000009700977306ULL, 0x000ea40000200c00ULL,
0x0000008e703c723cULL, 0x040f6c000000183cULL, 0x0000007600257306ULL, 0x0006a20000200c00ULL,
0x0000541095967816ULL, 0x002fe20000000096ULL, 0x000000907040723cULL, 0x000f6c0000001840ULL,
0x0000007d007c7306ULL, 0x000e620000200c00ULL, 0x0000541089767816ULL, 0x008fe2000000008aULL,
0x000000746c50723cULL, 0x000f620000001850ULL, 0x0000541097977816ULL, 0x004fc40000000082ULL,
0x0000541025987816ULL, 0x000fe20000000098ULL, 0x0000000211257824ULL, 0x000fc800078e00ffULL,
0x000000767034723cULL, 0x000f640000001834ULL, 0xfffffff825267812ULL, 0x020fe400078ec0ffULL,
0x000054107c997816ULL, 0x002fc80000000099ULL, 0x000000967044723cULL, 0x040f700000001844ULL,
0x000000987048723cULL, 0x000f700000001848ULL, 0x000000766c54723cULL, 0x040f700000001854ULL,
0x0000008e6c5c723cULL, 0x040f70000000185cULL, 0x000000906c60723cULL, 0x040f700000001860ULL,
0x000000966c64723cULL, 0x040f700000001864ULL, 0x000000986c68723cULL, 0x000b6e0000001868ULL,
0x000126c80a6e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x00000400046d7984ULL, 0x000ea40000000800ULL,
0x800000006dff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c26717210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff6c7819ULL, 0x000fc8000001146dULL,
0x000000716c6c7211ULL, 0x000fca00078110ffULL, 0x000000ffff6d7224ULL, 0x000fca00000e066dULL,
0x000000026c6c7819ULL, 0x000fc8000000126dULL, 0x0000006c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400046d7984ULL, 0x000e640000000800ULL,
0x800000006dff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010006257824ULL, 0x000fca00078e0225ULL, 0x000000c025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590022257a24ULL, 0x010fc600078e02ffULL, 0x0000002027227812ULL, 0x000fe200078ec0ffULL,
0x0000004025737824ULL, 0x000fc800078e00ffULL, 0x0000000109707824ULL, 0x000fe200078e0222ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000270e227217ULL, 0x000fe40007800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x00000003ff267819ULL, 0x000fe2000001160fULL,
0x0000000122227824ULL, 0x000fc600078e0a27ULL, 0x00000004266d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e0225ULL, 0x0000002225227217ULL, 0x000fe40007800000ULL,
0x00000008266e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001276c7824ULL, 0x040fe200078e020fULL,
0x0000000c266f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827757824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x100fe400078e0a25ULL, 0x000000016f727824ULL, 0x100fe200078e0225ULL,
0xfffffff875757812ULL, 0x000fe200078ee26cULL, 0x000000016d6c7824ULL, 0x100fe200078e0225ULL,
0x000000222600720cULL, 0x080fe20003f86070ULL, 0x0000000127267824ULL, 0x000fe200078e0270ULL,
0x000000226e00720cULL, 0x0c0fe20003f46070ULL, 0x000000016e6e7824ULL, 0x000fe200078e0225ULL,
0x000000226d00720cULL, 0x080fe20003f66070ULL, 0x000000016c257824ULL, 0x040fe200078e020fULL,
0x000000226f00720cULL, 0x000fe20003f06070ULL, 0x000000086c747824ULL, 0x000fc400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff874777812ULL, 0x000fe200078ee225ULL,
0x000000016c6c7824ULL, 0x000fe200078e0270ULL, 0x0000640073257a11ULL, 0x040fe200078a38ffULL,
0x000000016e227824ULL, 0x000fe200078e020fULL, 0x0000000226267212ULL, 0x000fe200078efcffULL,
0x000000086e7d7824ULL, 0x000fe200078e00ffULL, 0x0000650073737a11ULL, 0x000fe200028f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fe40007fbe0ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee222ULL, 0x000000016e6e7824ULL, 0x100fe200078e0270ULL,
0x000000026c6c7212ULL, 0x000fe200078efcffULL, 0x0000000172707824ULL, 0x000fc400078e0270ULL,
0x000000806e6e7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e6e7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0673ULL,
0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL, 0x0000000172227824ULL, 0x000fe200078e020fULL,
0x0000000270707212ULL, 0x000fe200078efcffULL, 0x00000008727f7824ULL, 0x000fe400078e00ffULL,
0x000000016d6d7824ULL, 0x100fe200028e0673ULL, 0x000000256e6e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002570707210ULL, 0x000fe20007fde0ffULL, 0x0000001075257824ULL, 0x000fe200078e0228ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x000000016f6f7824ULL, 0x000fc400028e0673ULL,
0x0000000171717824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000e101c46ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107d757824ULL, 0x100fe400078e0228ULL, 0x000000107f777824ULL, 0x000fe200078e0228ULL,
0x000000006c737faeULL, 0x0003e8000d901c46ULL, 0x000000006e757faeULL, 0x0003e8000d101c46ULL,
0x0000000070777faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fe400078ec0ffULL, 0x0000640073757a11ULL, 0x000fc400078038ffULL,
0x000000260f227211ULL, 0x000fe400078fe8ffULL, 0x0000650073737a11ULL, 0x000fe400000f3cffULL,
0x0000000422277810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x140fe200078e020fULL,
0x00000008226d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008226c7824ULL, 0x040fe200078e00ffULL,
0x0000000c22717810ULL, 0x040fe20007ffe0ffULL, 0x0000000122267824ULL, 0x100fe400078e0270ULL,
0x0000000127227824ULL, 0x040fe200078e020fULL, 0xfffffff86c257812ULL, 0x000fe200078ee225ULL,
0x00000001276c7824ULL, 0x000fc400078e0270ULL, 0x0000000827777824ULL, 0x000fe400078e00ffULL,
0x000000016d6e7824ULL, 0x040fe400078e0270ULL, 0x000000016d6f7824ULL, 0x100fe200078e020fULL,
0xfffffff877777812ULL, 0x000fe200078ee222ULL, 0x000000086d727824ULL, 0x000fe400078e00ffULL,
0x00000001716d7824ULL, 0x040fe400078e020fULL, 0x0000000871747824ULL, 0x000fe200078e00ffULL,
0xfffffff8727d7812ULL, 0x000fe200078ee26fULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff8747f7812ULL, 0x000fe200078ee26dULL, 0x0000000171707824ULL, 0x000fe200078e0270ULL,
0x0000000226267212ULL, 0x000fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0x0000002675267210ULL, 0x000fe20007f1e0ffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x000000026c6c7212ULL, 0x000fc600078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e6e7212ULL, 0x000fe400078efcffULL, 0x0000006c756c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0673ULL, 0x0000000270707212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x100fe200078e0228ULL, 0x0000006e756e7210ULL, 0x000fe20007f1e0ffULL,
0x000000016d6d7824ULL, 0x100fe200010e0673ULL, 0x0000007075707210ULL, 0x000fe20007f7e0ffULL,
0x000000107d757824ULL, 0x000fe200078e0228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c46ULL, 0x000000016f6f7824ULL, 0x000fc400000e0673ULL,
0x0000000171717824ULL, 0x000fe400018e0673ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107f777824ULL, 0x000fc600078e0228ULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x000000006e757faeULL, 0x0003e8000b901c46ULL, 0x0000000070777faeULL, 0x0003e4000b901c46ULL,
0x0000000811257824ULL, 0x002fe200078e00ffULL, 0x0000000308267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x0000000d2600720cULL, 0x000fe40003f06070ULL, 0x00000000250473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000107268824ULL, 0x000fc400078e0226ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000660026268625ULL, 0x000fca00078e0027ULL,
0x0000000626228981ULL, 0x000522000c1e1900ULL, 0x000126b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0126b000256e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126480003707f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01264c0003257984ULL, 0x002e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146dULL, 0x0000006c25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000225257819ULL, 0x000fc8000000126cULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01264c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002011037824ULL, 0x008fca00078e00ffULL,
0xffffff8003037812ULL, 0x000fc800078ec0ffULL, 0x0000010002037810ULL, 0x000fca0007ffe003ULL,
0x0000000178037824ULL, 0x000fca00078e0203ULL, 0x0120000003707984ULL, 0x000e680000000800ULL,
0x0122000003717984ULL, 0x0006a20000000800ULL, 0x000000237000720bULL, 0x002fe20003f1d000ULL,
0x0000ef727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000078000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fd200078e0023ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000020b267810ULL, 0x000fe40007ffe0ffULL,
0x000000237000720bULL, 0x000fe40003f54000ULL, 0x000000112600720cULL, 0x000fe20003f05270ULL,
0x0000ef227f007947ULL, 0x000fd4000b800000ULL, 0x0000000000037806ULL, 0x000fc400010e0100ULL,
0x0000008011278824ULL, 0x000fe200078e0202ULL, 0x0000002370258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000178268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0003e20000000800ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002370267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff03ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500737308ULL, 0x000e640000000800ULL, 0x0000007324247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x0000ee527f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0003ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x0000ed227f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000003ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x0000ebf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000003ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x0000ead27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002370037209ULL, 0x000fd60007810000ULL,
0x8000000370700221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL, 0x0000007000000308ULL, 0x000e640000000800ULL,
0x0000000071710220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002471247221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000811237824ULL, 0x000fca00078e00ffULL, 0xfffffff023707812ULL, 0x000fca00078ec0ffULL,
0x0126ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001146dULL,
0x0000006c23237211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000223237819ULL, 0x000fc8000000126cULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025237816ULL, 0x000fc800000000ffULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x0000e6927f007947ULL, 0x000fea000b800000ULL, 0x00001f2316137589ULL, 0x0002a400000e0000ULL,
0x0000000823277810ULL, 0x002fe20007ffe0ffULL, 0x0000e6c27f007947ULL, 0x000fea000b800000ULL,
0x0000001023157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001823277810ULL, 0x002fe20007ffe0ffULL,
0x0000e7127f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000040011237824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100011257824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00023237812ULL, 0x000fc400078ec0ffULL, 0xffffe00025257812ULL, 0x000fe400078ec0ffULL,
0x0000c00023237810ULL, 0x000fe40007ffe0ffULL, 0x0000e00025257810ULL, 0x000fc60007ffe0ffULL,
0x0000001018187824ULL, 0x100fe400078e0223ULL, 0x000000101a1a7824ULL, 0x000fe400078e0223ULL,
0x000000101b807824ULL, 0x000fe200078e0225ULL, 0x000000001874783bULL, 0x0002e80000000200ULL,
0x000000001a70783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001374747232ULL, 0x08cfe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x080fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101c7c7824ULL, 0x000fe200078e0225ULL,
0x000000008080783bULL, 0x000e620000004200ULL, 0x0000082000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff1a7819ULL, 0x002fe20000011481ULL,
0x00010000838a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc40000011482ULL,
0x0000001a006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff267819ULL, 0x008fe2000001147cULL,
0x000100007d907824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001147dULL,
0x000001007e927824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011480ULL,
0x00000018ff257819ULL, 0x000fe20000011483ULL, 0x00000026008e7306ULL, 0x0007e20000200c00ULL,
0x00000100801a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001147fULL,
0x00000018ff2b7819ULL, 0x000fe4000001147eULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000001c00887306ULL, 0x0003e20000200c00ULL, 0x0000010081267824ULL, 0x008fe200078e00ffULL,
0x000088807c8c7816ULL, 0x000fe400000000ffULL, 0x000088807d8f7816ULL, 0x000fe400000000ffULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018002a7306ULL, 0x0007e20000200c00ULL,
0x00008880811c7816ULL, 0x042fe200000000ffULL, 0x0001000081817824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002700917306ULL, 0x000fe20000200c00ULL,
0x0000888080187816ULL, 0x048fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fc80000011490ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000002600277306ULL, 0x0002f00000200c00ULL,
0x00000025008b7306ULL, 0x000fe20000200c00ULL, 0x0000888083267816ULL, 0x002fce00000000ffULL,
0x0000006d00967306ULL, 0x0003e20000200c00ULL, 0x000054101c277816ULL, 0x008fe20000000027ULL,
0x000001007f1c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001a00257306ULL, 0x0007e20000200c00ULL, 0x00000100826d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000002600897306ULL, 0x0003e20000200c00ULL,
0x00008880821a7816ULL, 0x048fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000001007c267824ULL, 0x042fe400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002b00947306ULL, 0x000fe20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fce000001147cULL, 0x00000080002b7306ULL, 0x0002f00000200c00ULL,
0x00000026008d7306ULL, 0x0005e20000200c00ULL, 0x0000010083807824ULL, 0x002fca00078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008200837306ULL, 0x0002620000200c00ULL,
0x000088807e267816ULL, 0x044fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x000054102b2a7816ULL, 0x008fc8000000002aULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000002600937306ULL, 0x0005e20000200c00ULL, 0x000001007d827824ULL, 0x002fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000007c007d7306ULL, 0x0002e20000200c00ULL,
0x0000541018267816ULL, 0x004fe40000000025ULL, 0x0000541083887816ULL, 0x000fca0000000088ULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x000088807f7c7816ULL, 0x042fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fe200078e00ffULL, 0x00000026742c723cULL, 0x080f66000000182cULL,
0x000000ffff187224ULL, 0x000fe200078e007cULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000001a001a7306ULL, 0x000fe20000200c00ULL, 0x000054107d8e7816ULL, 0x008fe4000000008eULL,
0x00000026704c723cULL, 0x000f6a000000184cULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00005410812b7816ULL, 0x004fce000000006cULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x0000002a7430723cULL, 0x080f6e0000001830ULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x000054101a6c7816ULL, 0x002fe2000000006dULL, 0x0000002a7050723cULL, 0x000f6c0000001850ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x000054108c8c7816ULL, 0x004fce000000008dULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x00005410896d7816ULL, 0x008fe20000000080ULL,
0x0000001020807824ULL, 0x000fcc00078e021fULL, 0x0000009200927306ULL, 0x000ea20000200c00ULL,
0x0000006c7434723cULL, 0x080f6e0000001834ULL, 0x0000007e00957306ULL, 0x000ee20000200c00ULL,
0x000054108f8d7816ULL, 0x002fe20000000082ULL, 0x0000006c7054723cULL, 0x000f6c0000001854ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x0000541093927816ULL, 0x004fe20000000092ULL,
0x0000008c743c723cULL, 0x080f6c000000183cULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x0000541095947816ULL, 0x008fe20000000094ULL, 0x0000008c705c723cULL, 0x000f6c000000185cULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x000054108a897816ULL, 0x002fce000000008bULL,
0x0000001c00257306ULL, 0x000e620000200c00ULL, 0x00005410908f7816ULL, 0x004fe20000000091ULL,
0x000000887438723cULL, 0x040f6c0000001838ULL, 0x0000007f007f7306ULL, 0x000ea40000200c00ULL,
0x0000008e7440723cULL, 0x000f620000001840ULL, 0x0000541018937816ULL, 0x002fce0000000025ULL,
0x000000887058723cULL, 0x000f620000001858ULL, 0x000054107f957816ULL, 0x004fce0000000096ULL,
0x000000927444723cULL, 0x040f700000001844ULL, 0x000000947448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x0000008e7060723cULL, 0x000f620000001860ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000927064723cULL, 0x040f700000001864ULL, 0x000000947068723cULL, 0x000b640000001868ULL,
0x000000002370783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e021fULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff207819ULL, 0x004fe20000011483ULL,
0x00000100836d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe20000011481ULL,
0x00000100822b7824ULL, 0x000fe200078e00ffULL, 0x0000002000897306ULL, 0x0005e20000200c00ULL,
0x00000018ff187819ULL, 0x000fe40000011480ULL, 0x00000018ff257819ULL, 0x008fe2000001147eULL,
0x000001007e8f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc40000011482ULL,
0x00000018ff217819ULL, 0x000fe2000001147cULL, 0x0000001a00277306ULL, 0x0007e20000200c00ULL,
0x0000010081207824ULL, 0x004fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe4000001147dULL,
0x00000018ff2a7819ULL, 0x000fe4000001147fULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000001800267306ULL, 0x0005e20000200c00ULL, 0x00000100801a7824ULL, 0x008fe200078e00ffULL,
0x000088807c8b7816ULL, 0x000fc400000000ffULL, 0x000088807d8d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001c006c7306ULL, 0x0007e20000200c00ULL,
0x0000888080187816ULL, 0x044fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000002500927306ULL, 0x000fe20000200c00ULL,
0x00008880811c7816ULL, 0x048fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002000257306ULL, 0x0005f00000200c00ULL,
0x00000021008c7306ULL, 0x000fe20000200c00ULL, 0x0000888083207816ULL, 0x044fe200000000ffULL,
0x0001000083837824ULL, 0x000fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000001800187306ULL, 0x000ff00000200c00ULL, 0x0000001a00217306ULL, 0x000ff00000200c00ULL,
0x0000002000887306ULL, 0x0005f00000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x000001007c207824ULL, 0x004fc400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000023008e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fce000001147cULL, 0x0000008000237306ULL, 0x0004f00000200c00ULL,
0x0000002a00947306ULL, 0x0003e20000200c00ULL, 0x00000018ff807819ULL, 0x004fce000001146dULL,
0x00000081001a7306ULL, 0x000ea20000200c00ULL, 0x00008880822a7816ULL, 0x042fe200000000ffULL,
0x0001000082827824ULL, 0x000fe200078e00ffULL, 0x0000541023267816ULL, 0x008fc80000000026ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008000817306ULL, 0x000ff00000200c00ULL,
0x0000002000807306ULL, 0x0003e20000200c00ULL, 0x000054101a277816ULL, 0x004fce0000000027ULL,
0x00000082006d7306ULL, 0x0004e20000200c00ULL, 0x000088807e207816ULL, 0x042fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x000000267430723cULL, 0x080b680000001830ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x00000083008a7306ULL, 0x0002e20000200c00ULL,
0x000001007d827824ULL, 0x004fe400078e00ffULL, 0x000000267050723cULL, 0x000b660000001850ULL,
0x00000018ff827819ULL, 0x000fc40000011482ULL, 0x0000002000907306ULL, 0x0005e20000200c00ULL,
0x000100007d837824ULL, 0x002fe200078e00ffULL, 0x000054106d6c7816ULL, 0x008fc8000000006cULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000007c007d7306ULL, 0x0002e20000200c00ULL,
0x0000541018207816ULL, 0x004fe40000000021ULL, 0x000054101c217816ULL, 0x000fe20000000025ULL,
0x000001007f1c7824ULL, 0x040fe200078e00ffULL, 0x000054108a6d7816ULL, 0x000fe40000000089ULL,
0x000126c80a257811ULL, 0x000fe200078e18ffULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x000088807f7c7816ULL, 0x042fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x00000020742c723cULL, 0x000b64000000182cULL,
0x000000ffff187224ULL, 0x000fe200078e007cULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002b002b7306ULL, 0x000e620000200c00ULL, 0x000054107d8c7816ULL, 0x008fc6000000008cULL,
0x0000006c7438723cULL, 0x000b680000001838ULL, 0x0000008d008d7306ULL, 0x000fe80000200c00ULL,
0x00000020704c723cULL, 0x000b68000000184cULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000054102a2a7816ULL, 0x002fc4000000002bULL, 0x00005410882b7816ULL, 0x000fe20000000081ULL,
0x0000006c7058723cULL, 0x000b680000001858ULL, 0x0000007e00937306ULL, 0x000e680000200c00ULL,
0x0000002a7434723cULL, 0x000b680000001834ULL, 0x0000008b008b7306ULL, 0x000ee20000200c00ULL,
0x000054108d817816ULL, 0x004fc60000000082ULL, 0x0000002a7054723cULL, 0x000b680000001854ULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541093927816ULL, 0x002fce0000000092ULL,
0x0000008f008f7306ULL, 0x000e620000200c00ULL, 0x000054108b807816ULL, 0x008fce0000000080ULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x00005410838d7816ULL, 0x004fe2000000008eULL,
0x00000080743c723cULL, 0x040b6c000000183cULL, 0x0000001c00917306ULL, 0x000ea20000200c00ULL,
0x0000541090907816ULL, 0x002fe2000000008fULL, 0x0000008c7440723cULL, 0x000b6c0000001840ULL,
0x0000007f007f7306ULL, 0x000e640000200c00ULL, 0x00000080705c723cULL, 0x000b62000000185cULL,
0x0000541018917816ULL, 0x004fe20000000091ULL, 0x0000000211187824ULL, 0x000fcc00078e00ffULL,
0x0000008c7060723cULL, 0x000b620000001860ULL, 0xfffffff8181a7812ULL, 0x000fe400078ec0ffULL,
0x000054107f937816ULL, 0x002fca0000000094ULL, 0x000000907444723cULL, 0x040b700000001844ULL,
0x000000927448723cULL, 0x000b700000001848ULL, 0x000000907064723cULL, 0x040b700000001864ULL,
0x000000927068723cULL, 0x000b620000001868ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000252a7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012698001aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff187224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x0000040025237984ULL, 0x000e620000000800ULL, 0x000000030b1a7810ULL, 0x008fc40007ffe0ffULL,
0x8000000023ff7812ULL, 0x006fe2000780482bULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620237210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x000000231c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc80000001223ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040025237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106237810ULL, 0x000fe40007ffe0ffULL, 0x0000000308087810ULL, 0x000fe40007ffe0ffULL,
0x0000000c2300720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x0000000206217810ULL, 0x000fe20007ffe0ffULL, 0x0000010023237824ULL, 0x000fe400078e0284ULL,
0x0000590022227a24ULL, 0x010fe200078e02ffULL, 0x0000000c2100720cULL, 0x000fe40003f06070ULL,
0x0000002023087812ULL, 0x000fe200078ec0ffULL, 0x00000040226d7824ULL, 0x000fc800078e00ffULL,
0x00000001092a7824ULL, 0x000fcc00078e0208ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x000000230e087217ULL, 0x000fe20007800000ULL, 0x0000001011187824ULL, 0x000fc800078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a23ULL, 0x0000001018217812ULL, 0x000fe400078ec0ffULL,
0x00000003ff187819ULL, 0x000fe4000001160fULL, 0x0000000821087217ULL, 0x000fe40007800000ULL,
0x00000004181c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000818207810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x100fe200078e0a21ULL, 0x0000000c18257810ULL, 0x000fe20007ffe0ffULL,
0x000000011c227824ULL, 0x000fc400078e0221ULL, 0x0000000120237824ULL, 0x040fe200078e0221ULL,
0x000000082000720cULL, 0x080fe20003f46070ULL, 0x0000000122207824ULL, 0x000fe200078e020fULL,
0x000000081800720cULL, 0x080fe20003f86070ULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0x000000081c00720cULL, 0x080fe20003f66070ULL, 0x0000000118187824ULL, 0x100fe200078e0221ULL,
0x000000082500720cULL, 0x040fe20003f06070ULL, 0x0000000125217824ULL, 0x000fe200078e0221ULL,
0xfffffff82b087812ULL, 0x000fe200078ee220ULL, 0x00000001181c7824ULL, 0x000fc400078e020fULL,
0x0000000818277824ULL, 0x040fe400078e00ffULL, 0x0000000118207824ULL, 0x100fe400078e022aULL,
0x0000000123267824ULL, 0x000fe200078e022aULL, 0xfffffff8271c7812ULL, 0x000fe200078ee21cULL,
0x0000000123187824ULL, 0x040fe400078e020fULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x000fc400078e022aULL, 0x0000000121257824ULL, 0x000fe200078e020fULL,
0xfffffff823187812ULL, 0x000fe200078ee218ULL, 0x00000008216c7824ULL, 0x040fe400078e00ffULL,
0x00000001212a7824ULL, 0x000fe400078e022aULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee225ULL, 0x000064006d257a11ULL, 0x000fe200078a38ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000220207212ULL, 0x000fc400078efcffULL,
0x000065006d6d7a11ULL, 0x000fe200028f3cffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000222227212ULL, 0x000fe400078efcffULL, 0x0000002025207210ULL, 0x000fe20007fbe0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002522227210ULL, 0x080fe40007fde0ffULL,
0x0000000226267212ULL, 0x080fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200028e066dULL,
0x000000022a2a7212ULL, 0x000fe200078efcffULL, 0x0000000123237824ULL, 0x000fe200030e066dULL,
0x0000002526267210ULL, 0x080fe20007fbe0ffULL, 0x0000001008717824ULL, 0x100fe200078e021fULL,
0x000000252a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000101c257824ULL, 0x000fc400078e021fULL,
0x0000001018737824ULL, 0x000fe400078e021fULL, 0x0000000127277824ULL, 0x000fe200028e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000e101c46ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200030e066dULL,
0x0000000022717faeULL, 0x0003e8000d901c46ULL, 0x0000000026737faeULL, 0x0003e8000d101c46ULL,
0x000000002a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011087824ULL, 0x000fca00078e00ffULL, 0x0000001008087812ULL, 0x000fc800078ec0ffULL,
0x000000080f087211ULL, 0x000fc800078fe8ffULL, 0x00000004081c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108187824ULL, 0x140fe200078e020fULL, 0x0000000c08237810ULL, 0x040fe20007ffe0ffULL,
0x0000000808217824ULL, 0x040fe400078e00ffULL, 0x0000000108207824ULL, 0x100fe400078e022aULL,
0x000000011c227824ULL, 0x040fe200078e022aULL, 0xfffffff821187812ULL, 0x000fe200078ee218ULL,
0x000000081c277824ULL, 0x000fe200078e00ffULL, 0x0000000808217810ULL, 0x000fe20007ffe0ffULL,
0x000000011c087824ULL, 0x000fc400078e020fULL, 0x0000000123257824ULL, 0x140fe400078e020fULL,
0x00000008236c7824ULL, 0x000fe200078e00ffULL, 0xfffffff827087812ULL, 0x000fe200078ee208ULL,
0x0000000121267824ULL, 0x040fe400078e022aULL, 0x00000001211c7824ULL, 0x040fe200078e020fULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0x000064006d257a11ULL, 0x000fe200078038ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x00000001232a7824ULL, 0x000fe200078e022aULL,
0x0000000220207212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000065006d6d7a11ULL, 0x000fe400000f3cffULL, 0x0000002025207210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000222227212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000226267212ULL, 0x000fc600078efcffULL,
0x0000000121217824ULL, 0x000fe200000e066dULL, 0x000000022a2a7212ULL, 0x000fe200078efcffULL,
0x0000001008717824ULL, 0x100fe200078e021fULL, 0x0000002225227210ULL, 0x040fe20007f1e0ffULL,
0x000000101c737824ULL, 0x100fe200078e021fULL, 0x0000002625267210ULL, 0x040fe40007f5e0ffULL,
0x0000002a252a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001018257824ULL, 0x000fe400078e021fULL,
0x0000000123237824ULL, 0x000fc400000e066dULL, 0x0000000127277824ULL, 0x000fe200010e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000b901c46ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200018e066dULL,
0x0000000022717faeULL, 0x0003e8000b901c46ULL, 0x0000000026737faeULL, 0x0003e8000b901c46ULL,
0x000000002a1f7faeULL, 0x0003e4000b901c46ULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff227424ULL, 0x002fc400078e00ffULL,
0x0000000d0800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000107227824ULL, 0x000fe400078e0208ULL, 0x00000004ff237424ULL, 0x000fc800078e00ffULL,
0x0000660022227625ULL, 0x000fcc00078e0023ULL, 0x0000000622227981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000811187824ULL, 0x000fe400078e00ffULL,
0x000000020b057824ULL, 0x000fc600078e0279ULL, 0xfffffff018207812ULL, 0x040fe400078ec0ffULL,
0x0000000818187812ULL, 0x000fe400078ec0ffULL, 0x00000000200473c2ULL, 0x000ea600000e0000ULL,
0x0000001005057824ULL, 0x000fe400078e0018ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000126a804047890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a80020207f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800052a7f8cULL, 0x000662000c80043fULL, 0x000000ffff187224ULL, 0x004fc600078e0021ULL,
0x0000000000207805ULL, 0x000fc80000015200ULL, 0x01266c00051f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026201f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x0000001f1c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc8000000121fULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c00051f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000801a057824ULL, 0x008fc800078e0202ULL,
0x0000000178057824ULL, 0x000fca00078e0205ULL, 0x0120000005207984ULL, 0x000e680000000800ULL,
0x01220000051f7984ULL, 0x0004e20000000800ULL, 0x000000032000720bULL, 0x002fe20003f1d000ULL,
0x0000c6627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x004fc800000e0100ULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x000fd200078e0003ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000000030b1a7810ULL, 0x000fe40007ffe0ffULL,
0x000000032000720bULL, 0x000fe40003f54000ULL, 0x000000111a00720cULL, 0x000fe20003f05270ULL,
0x0000c6127f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x0000008011218824ULL, 0x000fe200078e0202ULL, 0x00000003201a7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000178218824ULL, 0x000fca00078e0221ULL,
0x0124001a21008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000031a027221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x0000000200037308ULL, 0x000e640000000800ULL,
0x0000000324247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x0000c5527f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262c2c7220ULL, 0x084fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x0000c4227f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262e2e7220ULL, 0x084fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x0000c2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264c4c7220ULL, 0x084fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x0000c1d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264e4e7220ULL, 0x084fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c05ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff1c7424ULL, 0x000fd800078e00ffULL,
0x000000201a020221ULL, 0x000fe20000010100ULL, 0x00007610ff1c0816ULL, 0x000fc6000000001cULL,
0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL, 0x0000000200000308ULL, 0x000e640000000800ULL,
0x000000001f1f0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000241f247221ULL, 0x008fc20000010000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0000000811057824ULL, 0x000fca00078e00ffULL, 0xfffffff0051f7812ULL, 0x000fca00078ec0ffULL,
0x0126b4001f057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002002207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e03ULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011421ULL,
0x0000002005057211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x0000000205057819ULL, 0x000fc80000001220ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000123237810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4001f057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101c027816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001160fULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x0000bd927f007947ULL, 0x000fea000b800000ULL,
0x00001f0302137589ULL, 0x0002a400000e0000ULL, 0x0000000803277810ULL, 0x002fe20007ffe0ffULL,
0x0000bdc27f007947ULL, 0x000fea000b800000ULL, 0x0000001003157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2702147589ULL, 0x0002ea00000e0000ULL, 0x00001f1502157589ULL, 0x0002a400000e0000ULL,
0x0000001803277810ULL, 0x002fe20007ffe0ffULL, 0x0000be127f007947ULL, 0x000fea000b800000ULL,
0x00001f2702167589ULL, 0x0002e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff027819ULL, 0x002fe2000001160fULL, 0x0000000817207824ULL, 0x000fe200078e00ffULL,
0x000000030b1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819267824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000479027824ULL, 0x000fe200078e0202ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x00000004111f7824ULL, 0x000fc400078e00ffULL,
0x0000000117037824ULL, 0x100fe400078e0202ULL, 0x0000000119057824ULL, 0x000fe200078e0202ULL,
0x000000041f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000101b747824ULL, 0x000fe200078e0228ULL,
0xfffffff820027812ULL, 0x000fe400078ee203ULL, 0x0000a0001c037811ULL, 0x000fe400078e60ffULL,
0xfffffff8261c7812ULL, 0x000fe400078ee205ULL, 0x000000021f207812ULL, 0x000fe200078efcffULL,
0x0000001002027824ULL, 0x000fc400078e0203ULL, 0x000000101c1c7824ULL, 0x000fc600078e0203ULL,
0x000000000270783bULL, 0x0002e80000000200ULL, 0x000000001c6c783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x08cfe40000000000ULL,
0x0000001372727232ULL, 0x000fe40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fc40000000000ULL, 0x000000156c6c7232ULL, 0x080fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200f027211ULL, 0x002fe200078fe0ffULL, 0x00000008171c7824ULL, 0x040fe200078e00ffULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e0203ULL,
0x0000082000007945ULL, 0x000fe20003800000ULL, 0x0000000117177824ULL, 0x000fca00078e0202ULL,
0xfffffff81c177812ULL, 0x000fca00078ee217ULL, 0x0000001017177824ULL, 0x000fca00078e0228ULL,
0x00000000177c783bULL, 0x0006a20000004200ULL, 0x00000018ff1c7819ULL, 0x002fe20000011475ULL,
0x0000010074177824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011476ULL,
0x00000100772b7824ULL, 0x000fe200078e00ffULL, 0x0000001c00237306ULL, 0x0003e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe40000011474ULL, 0x00000018ff207819ULL, 0x000fe40000011477ULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000001f00257306ULL, 0x0007e20000200c00ULL, 0x00008880751c7816ULL, 0x002fe400000000ffULL,
0x00000018ff217819ULL, 0x004fe2000001147cULL, 0x000001007f8b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe2000001147dULL, 0x00000100751f7824ULL, 0x048fe400078e00ffULL,
0x0000002100857306ULL, 0x0003e20000200c00ULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001147fULL, 0x000001007d837824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000005001b7306ULL, 0x0005e20000200c00ULL, 0x0000010076217824ULL, 0x002fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe4000001147eULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002600877306ULL, 0x000fe20000200c00ULL,
0x0000888074057816ULL, 0x044fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fc8000001148bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000007500267306ULL, 0x0003f00000200c00ULL, 0x0000002000807306ULL, 0x000fe20000200c00ULL,
0x000001007c757824ULL, 0x002fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001f001f7306ULL, 0x000ff00000200c00ULL,
0x0000002a008e7306ULL, 0x000ff00000200c00ULL, 0x0000000500057306ULL, 0x000ff00000200c00ULL,
0x0000001700207306ULL, 0x0002b00000200c00ULL, 0x00000021002a7306ULL, 0x0007e20000200c00ULL,
0x0000888076177816ULL, 0x042fe200000000ffULL, 0x0001000076767824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000002b00787306ULL, 0x0003e20000200c00ULL,
0x000088807c217816ULL, 0x048fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x0000541005207816ULL, 0x004fc80000000020ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x00000027008c7306ULL, 0x0005e20000200c00ULL, 0x000088807d2b7816ULL, 0x042fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000007500827306ULL, 0x0003e20000200c00ULL, 0x0000888077277816ULL, 0x044fe200000000ffULL,
0x0001000077777824ULL, 0x000fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000002100817306ULL, 0x0004e20000200c00ULL, 0x000088807f757816ULL, 0x042fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002b00867306ULL, 0x0003e20000200c00ULL, 0x000088807e217816ULL, 0x004fce00000000ffULL,
0x0000002100897306ULL, 0x0005e20000200c00ULL, 0x000001007e2b7824ULL, 0x042fe200078e00ffULL,
0x0000541081827816ULL, 0x008fe20000000082ULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x00000075008d7306ULL, 0x0003e20000200c00ULL, 0x000054101c217816ULL, 0x004fce000000001fULL,
0x0000008b001c7306ULL, 0x000ea20000200c00ULL, 0x0000541026757816ULL, 0x002fe20000000023ULL,
0x000000206c4c723cULL, 0x080f6c000000184cULL, 0x0000007400747306ULL, 0x000e640000200c00ULL,
0x00000020702c723cULL, 0x000f6c000000182cULL, 0x0000001700177306ULL, 0x000ee20000200c00ULL,
0x000054108d8b7816ULL, 0x004fce000000001cULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000541074747816ULL, 0x002fce000000001bULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00005410172a7816ULL, 0x008fe2000000002aULL, 0x000000746c50723cULL, 0x080f6c0000001850ULL,
0x0000007700777306ULL, 0x000ea40000200c00ULL, 0x000000747030723cULL, 0x000f6c0000001830ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000025ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000080ULL,
0x0000007d00887306ULL, 0x000ea20000200c00ULL, 0x0000541086837816ULL, 0x008fe20000000083ULL,
0x000000766c58723cULL, 0x040f6c0000001858ULL, 0x0000002b008a7306ULL, 0x0006a20000200c00ULL,
0x000054107c7c7816ULL, 0x002fe20000000085ULL, 0x000000826c5c723cULL, 0x000f6c000000185cULL,
0x0000007e00057306ULL, 0x000e620000200c00ULL, 0x00005410272b7816ULL, 0x008fe20000000078ULL,
0x000000767038723cULL, 0x000f620000001838ULL, 0x00005410887d7816ULL, 0x004fca0000000087ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x00005410898a7816ULL, 0x000fe2000000008aULL,
0x0000002a6c54723cULL, 0x000f620000001854ULL, 0x00005410058c7816ULL, 0x002fe2000000008cULL,
0x000000101d057824ULL, 0x000fcc00078e0203ULL, 0x0000007c6c60723cULL, 0x000f620000001860ULL,
0x000000001e1c783bULL, 0x000e620000000200ULL, 0x000054107f8d7816ULL, 0x004fcc000000008eULL,
0x0000008a6c64723cULL, 0x040f700000001864ULL, 0x0000008c6c68723cULL, 0x000b640000001868ULL,
0x00000000056c783bULL, 0x0204ec0000000200ULL, 0x0000002a7034723cULL, 0x040b700000001834ULL,
0x00000082703c723cULL, 0x040b70000000183cULL, 0x0000007c7040723cULL, 0x040b700000001840ULL,
0x0000008a7044723cULL, 0x040b700000001844ULL, 0x0000008c7048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x000000136c6c7232ULL, 0x08efe40000000000ULL, 0x000000136e6e7232ULL, 0x000fc40000000000ULL,
0x000000146d6d7232ULL, 0x080fe40000000000ULL, 0x000000146f6f7232ULL, 0x000fe40000000000ULL,
0x000000151c1c7232ULL, 0x080fe40000000000ULL, 0x000000151e1e7232ULL, 0x000fe40000000000ULL,
0x000000161d1d7232ULL, 0x080fe40000000000ULL, 0x000000161f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000000819037824ULL, 0x040fe200078e00ffULL,
0x000000002970783bULL, 0x020e620000004200ULL, 0x0000000119027824ULL, 0x000fca00078e0202ULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0228ULL,
0x000000000374783bULL, 0x0004e20000004200ULL, 0x00000018ff197819ULL, 0x002fe20000011472ULL,
0x0000010070037824ULL, 0x004fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe40000011470ULL,
0x00000018ff177819ULL, 0x000fe20000011471ULL, 0x0000001900257306ULL, 0x0003e20000200c00ULL,
0x00000018ff037819ULL, 0x000fe40000011403ULL, 0x00000018ff207819ULL, 0x000fca0000011473ULL,
0x0000000200057306ULL, 0x0005e20000200c00ULL, 0x0000010071197824ULL, 0x002fe200078e00ffULL,
0x00000018ff277819ULL, 0x008fe20000011477ULL, 0x0000010074297824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011476ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000017001b7306ULL, 0x0003e20000200c00ULL, 0x0000888070027816ULL, 0x044fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fc40000011475ULL,
0x00000018ff217819ULL, 0x000fe40000011474ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000002700867306ULL, 0x0005e20000200c00ULL, 0x0000888071177816ULL, 0x042fe200000000ffULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x00000020002b7306ULL, 0x000fe20000200c00ULL,
0x0000010073277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000000200027306ULL, 0x000ff00000200c00ULL, 0x0000000300037306ULL, 0x000e700000200c00ULL,
0x0000001700177306ULL, 0x000ff00000200c00ULL, 0x0000001900207306ULL, 0x0004e20000200c00ULL,
0x0000541002027816ULL, 0x002fce0000000003ULL, 0x0000002300817306ULL, 0x0003e20000200c00ULL,
0x0000888073197816ULL, 0x044fe200000000ffULL, 0x0001000073737824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000002600857306ULL, 0x000fe20000200c00ULL,
0x0000010072237824ULL, 0x002fe200078e00ffULL, 0x0000541017037816ULL, 0x008fe20000000020ULL,
0x0000010077177824ULL, 0x000fc600078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000007100267306ULL, 0x0003e20000200c00ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x000000026c2c723cULL, 0x080b6c000000182cULL, 0x00000027002a7306ULL, 0x0005e20000200c00ULL,
0x0000888075717816ULL, 0x042fe200000000ffULL, 0x000000021c4c723cULL, 0x000b6c000000184cULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0000010075277824ULL, 0x004fc400078e00ffULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011427ULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x00000021007e7306ULL, 0x0005e20000200c00ULL,
0x0000541070707816ULL, 0x002fce0000000005ULL, 0x0000002300287306ULL, 0x0003e20000200c00ULL,
0x0000888072217816ULL, 0x044fe200000000ffULL, 0x0001000072727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007500827306ULL, 0x0005e20000200c00ULL,
0x0000888074237816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000007300787306ULL, 0x0003e20000200c00ULL,
0x0000888077757816ULL, 0x044fe200000000ffULL, 0x0001000077777824ULL, 0x000fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x00000071007f7306ULL, 0x0005e20000200c00ULL,
0x0001000076737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000029007c7306ULL, 0x0003e20000200c00ULL, 0x0000010076717824ULL, 0x004fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007d00807306ULL, 0x000ea20000200c00ULL,
0x0000888076297816ULL, 0x002fce00000000ffULL, 0x0000007400277306ULL, 0x000e700000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107f7d7816ULL, 0x004fe40000000080ULL,
0x00005410827f7816ULL, 0x000fca0000000081ULL, 0x0000001700207306ULL, 0x000fe20000200c00ULL,
0x00005410277e7816ULL, 0x002fce000000007eULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x0000007e6c40723cULL, 0x080b6e0000001840ULL, 0x0000001900197306ULL, 0x000fe20000200c00ULL,
0x0000007e1c60723cULL, 0x000b6e0000001860ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x0000541021287816ULL, 0x002fce0000000028ULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000002900837306ULL, 0x0007e20000200c00ULL, 0x0000541072727816ULL, 0x004fce0000000025ULL,
0x0000007100767306ULL, 0x0004a20000200c00ULL, 0x0000541019297816ULL, 0x008fe4000000002aULL,
0x00005410237c7816ULL, 0x002fca000000007cULL, 0x0000007300747306ULL, 0x0002e20000200c00ULL,
0x0000541026717816ULL, 0x004fe2000000001bULL, 0x000000286c34723cULL, 0x040b6c0000001834ULL,
0x0000007700057306ULL, 0x0004a20000200c00ULL, 0x0000541078737816ULL, 0x002fe2000000002bULL,
0x000000706c30723cULL, 0x000b620000001830ULL, 0x0000541083767816ULL, 0x000fc40000000076ULL,
0x0000541074747816ULL, 0x008fe40000000085ULL, 0x0000541075777816ULL, 0x004fc60000000020ULL,
0x000000726c38723cULL, 0x000b620000001838ULL, 0x0000541005757816ULL, 0x000fce0000000086ULL,
0x0000007c6c3c723cULL, 0x040b70000000183cULL, 0x000000766c44723cULL, 0x040b700000001844ULL,
0x000000746c48723cULL, 0x000b700000001848ULL, 0x000000701c50723cULL, 0x040b700000001850ULL,
0x000000281c54723cULL, 0x040b700000001854ULL, 0x000000721c58723cULL, 0x040b700000001858ULL,
0x0000007c1c5c723cULL, 0x040b70000000185cULL, 0x000000761c64723cULL, 0x040b700000001864ULL,
0x000000741c68723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000004047f8cULL, 0x000e62000c80043fULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x000126a00b027811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000002ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff177224ULL, 0x002fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4ec000007947ULL, 0x000fea000383ffffULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cf7000047802ULL, 0x000fc40000000f00ULL,
0x0000add000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000001808057811ULL, 0x044fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x002fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000004400447220ULL, 0x040fe20000410000ULL,
0x0000004500457220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004e054e7220ULL, 0x044fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x040fe20000410000ULL,
0x0000005b055b7220ULL, 0x040fe20000410000ULL, 0x0000005e055e7220ULL, 0x040fe20000410000ULL,
0x0000005f055f7220ULL, 0x040fe20000410000ULL, 0x0000006205627220ULL, 0x040fe20000410000ULL,
0x0000006305637220ULL, 0x040fe20000410000ULL, 0x0000006605667220ULL, 0x040fe20000410000ULL,
0x0000006705677220ULL, 0x040fe20000410000ULL, 0x0000006a056a7220ULL, 0x040fe20000410000ULL,
0x0000006b056b7220ULL, 0x000fe20000410000ULL, 0x000000042e2e7220ULL, 0x088fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000442427220ULL, 0x080fe20000410000ULL,
0x0000000443437220ULL, 0x080fe20000410000ULL, 0x0000000446467220ULL, 0x080fe20000410000ULL,
0x0000000447477220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x080fe20000410000ULL, 0x0000000250507220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x0000000254547220ULL, 0x080fe20000410000ULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000258587220ULL, 0x080fe20000410000ULL,
0x0000000259597220ULL, 0x080fe20000410000ULL, 0x000000025c5c7220ULL, 0x080fe20000410000ULL,
0x000000025d5d7220ULL, 0x080fe20000410000ULL, 0x0000000260607220ULL, 0x080fe20000410000ULL,
0x0000000261617220ULL, 0x080fe20000410000ULL, 0x0000000264647220ULL, 0x080fe20000410000ULL,
0x0000000265657220ULL, 0x080fe20000410000ULL, 0x0000000268687220ULL, 0x080fe20000410000ULL,
0x0000000269697220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x004ea20000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fc400000000ffULL,
0x00000042431f723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fe400000000ffULL,
0x0000004a4b23723eULL, 0x000fe400000000ffULL, 0x0000004c4d4c723eULL, 0x000fe400000000ffULL,
0x0000000803057811ULL, 0x044fe200078ff0ffULL, 0x0000000184847824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x000fc400078ec0ffULL, 0x0000001803097811ULL, 0x000fe200078ff0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x040fe400078ff8ffULL,
0x0000001003057811ULL, 0x000fe200078ff0ffULL, 0x0000000809187824ULL, 0x002fe200078e00ffULL,
0xfffffff8070e7812ULL, 0x000fe400078ee202ULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x00000008050b7824ULL, 0x000fe200078e00ffULL, 0x0000000500047211ULL, 0x000fc400078ff8ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b167812ULL, 0x000fe200078ee204ULL, 0x0000200011047824ULL, 0x000fe200078e00ffULL,
0x0000000900057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe400078ee205ULL, 0x0000200004057812ULL, 0x000fc400078ee2ffULL,
0xfffffff809067812ULL, 0x040fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x000010000a077824ULL, 0x100fe200078e0205ULL, 0x0000000402047810ULL, 0x000fe20007ffe0ffULL,
0x0000001084847824ULL, 0x000fe200078e0205ULL, 0x0000000602097810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e0207ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL,
0x000000100e147824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x100fe200078e0207ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x100fe200078e0207ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x0000001006067824ULL, 0x100fe200078e0207ULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x0000001008087824ULL, 0x100fe200078e0207ULL, 0x00005410001c7816ULL, 0x100fe20000000002ULL,
0x000000100c0e7824ULL, 0x000fe200078e0207ULL, 0x00007632001d7816ULL, 0x000fe20000000002ULL,
0x0000000104077824ULL, 0x000fe200078e0209ULL, 0x000000343500723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x000fe200078e0206ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x00000001090c7824ULL, 0x000fe200078e0208ULL, 0x0000001c07007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x00000001090e7824ULL, 0x000fe200078e020eULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x0000000109147824ULL, 0x000fe200078e0214ULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x0000000109167824ULL, 0x040fe200078e0216ULL,
0x00005410361a7816ULL, 0x000fe2000000001bULL, 0x0000000109187824ULL, 0x000fe200078e0218ULL,
0x000000545554723eULL, 0x000fc400000000ffULL, 0x00000058592a723eULL, 0x000fe400000000ffULL,
0x00005410001c7816ULL, 0x142fe40000000002ULL, 0x00007632001d7816ULL, 0x000fe40000000002ULL,
0x000000444507723eULL, 0x000fe400000000ffULL, 0x00007632361b7816ULL, 0x000fe2000000001bULL,
0x0000001c0b007388ULL, 0x0003e20000000a00ULL, 0x000054103e1e7816ULL, 0x000fc4000000001fULL,
0x000076323e1f7816ULL, 0x000fe4000000001fULL, 0x0000541046227816ULL, 0x150fe40000000023ULL,
0x0000763246237816ULL, 0x000fe40000000023ULL, 0x0000763254097816ULL, 0x000fe4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe400000000ffULL, 0x00005410041c7816ULL, 0x002fc40000000006ULL,
0x00007632041d7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000001c0c007388ULL, 0x000fe20000000a00ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x000000606160723eULL, 0x000fe200000000ffULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x000000646564723eULL, 0x000fc400000000ffULL,
0x000000686932723eULL, 0x000fe400000000ffULL, 0x0000004e4f00723eULL, 0x000fe400000000ffULL,
0x0000763264157816ULL, 0x000fe40000000032ULL, 0x000000525302723eULL, 0x000fe400000000ffULL,
0x000000565704723eULL, 0x000fe400000000ffULL, 0x000054102e067816ULL, 0x002fc40000000017ULL,
0x000076322e077816ULL, 0x000fe40000000017ULL, 0x000000ff0a00720cULL, 0x000fc60003f05270ULL,
0x0000000614007388ULL, 0x0003e80000000a00ULL, 0x0004001a0b007388ULL, 0x000fe80000000a00ULL,
0x0004001e0c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x002fc60000000026ULL,
0x000400220e007388ULL, 0x000fe20000000a00ULL, 0x000076324c077816ULL, 0x000fe40000000026ULL,
0x0000541064147816ULL, 0x000fc60000000032ULL, 0x0000000616007388ULL, 0x0003e80000000a00ULL,
0x000800080b007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe400000000ffULL,
0x000000666707723eULL, 0x000fe400000000ffULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fc40000000060ULL, 0x0000763204197816ULL, 0x000fc60000000006ULL,
0x000800080c007388ULL, 0x0003e80000000a00ULL, 0x000800140e007388ULL, 0x0005e20000000a00ULL,
0x0000006a6b08723eULL, 0x002fe400000000ffULL, 0x0000541000147816ULL, 0x144fe40000000002ULL,
0x0000763200157816ULL, 0x000fe40000000002ULL, 0x0000005e5f00723eULL, 0x000fc400000000ffULL,
0x000000626302723eULL, 0x000fe200000000ffULL, 0x0000001418007388ULL, 0x0003e60000000a00ULL,
0x00005410002c7816ULL, 0x140fe40000000002ULL, 0x00007632002d7816ULL, 0x000fe40000000002ULL,
0x0000541004187816ULL, 0x002fe40000000006ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000c00180b007388ULL, 0x000fe80000000a00ULL,
0x000c002c0c007388ULL, 0x000fe80000000a00ULL, 0x000c00060e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000084147984ULL, 0x000e680000000c00ULL,
0x00040000841c7984ULL, 0x000ea80000000c00ULL, 0x0008000084247984ULL, 0x000ee80000000c00ULL,
0x000c0000842c7984ULL, 0x000ee80000000c00ULL, 0x0010000084187984ULL, 0x000ee80000000c00ULL,
0x0014000084207984ULL, 0x000ee80000000c00ULL, 0x0018000084287984ULL, 0x000ee80000000c00ULL,
0x001c000084307984ULL, 0x000ee20000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x000fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe40000000000ULL, 0x0000001915157230ULL, 0x000fc40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000001484007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001c84007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0008002484007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fc40000000000ULL, 0x000000302c2c7230ULL, 0x000fca0000000000ULL,
0x000c002c84007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011603ULL,
0x0000007a0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff157a12ULL, 0x000fe200078e33ffULL, 0x0000000110007824ULL, 0x000fe200078e0209ULL,
0x0000000111117812ULL, 0x000fc800078ec0ffULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL, 0x0000000109027824ULL, 0x000fca00078e0203ULL,
0x0000000800077305ULL, 0x000e62000021f000ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802027812ULL, 0x000fca00078ef803ULL, 0x0000001002027824ULL, 0x000fe400078e0205ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b07137227ULL, 0x000fe400078e0006ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000013047227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a04ULL,
0x0000000703027812ULL, 0x002fc600078ec0ffULL, 0x00005a0007067a24ULL, 0x000fca00078e0200ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000104041810ULL, 0x000fc80007ffe0ffULL,
0x0000000415077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b047210ULL, 0x000fe40007f3e0ffULL, 0x0000002003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0004067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0004077a11ULL, 0x000fe400008f4407ULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b077210ULL, 0x000fe40007f3e0ffULL,
0x0000004003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b077210ULL, 0x000fe40007f3e0ffULL, 0x0000006003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b077210ULL, 0x000fe40007f3e0ffULL,
0x0000008003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b077210ULL, 0x000fe40007f3e0ffULL, 0x000000a003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe200078e020fULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x00000003ff0f7819ULL, 0x000fe4000001160cULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fc800078240ffULL,
0x00005f0002077a11ULL, 0x000fe400008f4407ULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x000000010c0f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f027812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fc800078e0200ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b067210ULL, 0x000fe40007f3e0ffULL,
0x000000e003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0006027a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x00005f0006037a11ULL, 0x000fe200008f4407ULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x0000007a0d00720cULL, 0x000fe20003f26070ULL, 0x0000000110107824ULL, 0x000fe400078e020dULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001013037227ULL, 0x002fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x00005a0007027a24ULL, 0x000fc600078e0210ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0xfffffff80d027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001002057824ULL, 0x000fca00078e0205ULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000315037207ULL, 0x000fe20004000000ULL,
0x0000000811057824ULL, 0x002fc800078e0200ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0212ULL, 0x00005a0007107a24ULL, 0x000fc800078e0210ULL,
0x00005a0003107a24ULL, 0x000fca00078e0210ULL, 0x000000107b107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0010027a11ULL, 0x000fc800078040ffULL,
0x00005f0010037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000d1100720cULL, 0x000fe20003f06070ULL, 0xffffffffff007424ULL, 0x000fd800078e00ffULL,
0x00000002040a8824ULL, 0x000fc800078e00ffULL, 0x00006a000a0a8a24ULL, 0x000fc800078e0211ULL,
0x000066000a0a8625ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff647624ULL, 0x000fe200078e00ffULL, 0x000000060a008981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff657624ULL, 0x000fc600078e00ffULL, 0x01260000ff067f8cULL, 0x000e68000c80043fULL,
0x0000000664647981ULL, 0x000722000c1e9900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x00005800ff097624ULL, 0x000fe400078e00ffULL, 0x0000004016617824ULL, 0x000fe400078e00ffULL,
0x0000004011637824ULL, 0x000fe200078e00ffULL, 0x0000001f09097810ULL, 0x000fe20007ffe0ffULL,
0x0000004012607824ULL, 0x000fc600078e00ffULL, 0x00000005ff097819ULL, 0x000fe20000011609ULL,
0x00000061002b7224ULL, 0x004fe400078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x00afe4000001160fULL, 0x000064002b297a11ULL, 0x040fe400078038ffULL,
0x000000630e087217ULL, 0x000fe20007800000ULL, 0x0000004012207824ULL, 0x000fe200078e0227ULL,
0x000065002b2b7a11ULL, 0x000fe400000f3cffULL, 0x0000000f0f127211ULL, 0x000fe200078fe8ffULL,
0x00000080200a7825ULL, 0x040fe200078e00ffULL, 0x0000001020167810ULL, 0x000fc40007ffe0ffULL,
0x0000000820147810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a63ULL,
0x000000300a187812ULL, 0x100fe200078ef805ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000018200a7810ULL, 0x000fe40007ffe0ffULL, 0x0000001829187210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003016167812ULL, 0x000fe400078ef805ULL,
0x00000008271d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b197824ULL, 0x000fe200000e062bULL,
0x00000030141a7812ULL, 0x000fe200078ef805ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002916167210ULL, 0x000fc40007f5e0ffULL, 0x000000291a1a7210ULL, 0x080fe20007f3e0ffULL,
0x000000041d217824ULL, 0x000fe200078e00ffULL, 0x000000300a1c7812ULL, 0x000fe200078ef805ULL,
0x0000000117177824ULL, 0x100fe200010e062bULL, 0x0000000312127812ULL, 0x000fe200078ec0ffULL,
0x00000001151b7824ULL, 0x000fe200008e062bULL, 0x000000291c1c7210ULL, 0x000fe40007f5e0ffULL,
0x0000002020147810ULL, 0x000fe40007ffe0ffULL, 0x000000082700720cULL, 0x000fc40003f06070ULL,
0x00000028200a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000200011227811ULL, 0x000fe400078e68ffULL, 0x000000081d00720cULL, 0x000fe20003f26070ULL,
0x000000010b1d7824ULL, 0x000fe200010e062bULL, 0x0ffffffc120f7812ULL, 0x000fe200078ef80fULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000030141e7812ULL, 0x100fe400078ef805ULL,
0xfffffffc21217812ULL, 0x000fe200078ee212ULL, 0x000000100f0f7824ULL, 0x000fe200078e0222ULL,
0x000000300a0a7812ULL, 0x000fc400078ef805ULL, 0x000000291e1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001021217824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000180f7faeULL, 0x0003e2000c101c46ULL, 0x00000010272d7810ULL, 0x000fe40007ffe0ffULL,
0x00000001151f7824ULL, 0x000fe200018e062bULL, 0x0000002027157810ULL, 0x040fe20007ffe0ffULL,
0x000000001a217faeULL, 0x0005e2000c901c46ULL, 0x00000018272f7810ULL, 0x000fe40007ffe0ffULL,
0x0000003820147810ULL, 0x000fc40007ffe0ffULL, 0x0000002827237810ULL, 0x000fe40007ffe0ffULL,
0x000000290a187210ULL, 0x002fe20007fde0ffULL, 0x000000042d0f7824ULL, 0x000fe200078e00ffULL,
0x00000030200a7810ULL, 0x000fe40007ffe0ffULL, 0x0000003027257810ULL, 0x000fe20007ffe0ffULL,
0x000000010b197824ULL, 0x000fe200030e062bULL, 0x0000003827277810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000081500720cULL, 0x000fc40003f66070ULL,
0x000000082d00720cULL, 0x080fe20003fa6070ULL, 0x0000000415217824ULL, 0x004fe200078e00ffULL,
0x000000300a0a7812ULL, 0x000fe200078ef805ULL, 0x000000042f1b7824ULL, 0x000fe200078e00ffULL,
0x000000082300720cULL, 0x080fe20003f46070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000082f00720cULL, 0x080fe40003f86070ULL, 0x000000082500720cULL, 0x080fe20003f26070ULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x000000082700720cULL, 0x000fe20003f06070ULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x000000290a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x000fc400078ee212ULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee212ULL, 0x000000010b0b7824ULL, 0x000fe200030e062bULL,
0x0000003014147812ULL, 0x000fe200078ef805ULL, 0x000000100f0f7824ULL, 0x000fe200078e0222ULL,
0xfffffffc21217812ULL, 0x000fe200078ee212ULL, 0x000000101b1b7824ULL, 0x000fe200078e0222ULL,
0xfffffffc23237812ULL, 0x100fe400078ee212ULL, 0xfffffffc25057812ULL, 0x000fe200078ee212ULL,
0x0000001021217824ULL, 0x000fe200078e0222ULL, 0xfffffffc27257812ULL, 0x000fe200078ee212ULL,
0x0000001023237824ULL, 0x100fe200078e0222ULL, 0x0000002914147210ULL, 0x000fe20007fde0ffULL,
0x0000001005057824ULL, 0x100fe200078e0222ULL, 0x00000000160f7faeULL, 0x0003e2000e901c46ULL,
0x0000001025257824ULL, 0x000fc400078e0222ULL, 0x0000000115157824ULL, 0x000fe200030e062bULL,
0x000000001c1b7faeULL, 0x0003e8000e101c46ULL, 0x000000001e217faeULL, 0x0003e8000d901c46ULL,
0x0000000018237faeULL, 0x0003e8000d101c46ULL, 0x000000000a057faeULL, 0x0003e8000c901c46ULL,
0x0000000014257faeULL, 0x0003e2000c101c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x000000600f0a7211ULL, 0x04afe400078ff0ffULL, 0x000000300f197811ULL, 0x000fc400078ff0ffULL,
0x000000180f357811ULL, 0x040fe200078ff0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000f0f087211ULL, 0x040fe400078fe8ffULL, 0x000000200f157811ULL, 0x000fe200078ff0ffULL,
0x0000000419317824ULL, 0x000fe200078e00ffULL, 0x000000080f1d7811ULL, 0x000fe200078ff0ffULL,
0x0000000435257824ULL, 0x000fe200078e00ffULL, 0x000000100f1f7811ULL, 0x000fe200078ff0ffULL,
0x0000000415277824ULL, 0x000fe200078e00ffULL, 0x000000280f177811ULL, 0x000fe200078ff0ffULL,
0x000000041d217824ULL, 0x000fe200078e00ffULL, 0x000000380f1b7811ULL, 0x000fe200078ff0ffULL,
0x000000041f237824ULL, 0x000fe200078e00ffULL, 0x00000003081a7812ULL, 0x000fe200078ec0ffULL,
0x0000000417297824ULL, 0x000fe200078e00ffULL, 0x000064002b2f7a11ULL, 0x000fe200078038ffULL,
0x000000041b337824ULL, 0x000fe200078e00ffULL, 0x000000300a207812ULL, 0x000fe200078ef805ULL,
0x00000001601c7824ULL, 0x040fe200078e0219ULL, 0x00002000112d7811ULL, 0x000fe200078e68ffULL,
0x00000001601e7824ULL, 0x000fe200078e021bULL, 0xfffffffc310a7812ULL, 0x000fc400078ee21aULL,
0xfffffffc25147812ULL, 0x100fe400078ee21aULL, 0x0ffffffc1a0f7812ULL, 0x000fe400078ef80fULL,
0xfffffffc27167812ULL, 0x100fe200078ee21aULL, 0x0000001014257824ULL, 0x000fe200078e022dULL,
0xfffffffc21087812ULL, 0x100fe200078ee21aULL, 0x0000000160147824ULL, 0x000fe200078e021fULL,
0xfffffffc23127812ULL, 0x100fe200078ee21aULL, 0x0000001016277824ULL, 0x000fe200078e022dULL,
0xfffffffc29187812ULL, 0x100fe200078ee21aULL, 0x0000000160167824ULL, 0x000fe200078e0235ULL,
0x000065002b317a11ULL, 0x000fe200000f3cffULL, 0x000000100a2b7824ULL, 0x000fe200078e022dULL,
0xfffffffc331a7812ULL, 0x000fe200078ee21aULL, 0x00000001600a7824ULL, 0x000fe200078e021dULL,
0x000000202f207210ULL, 0x000fe20007f1e0ffULL, 0x000000100f337824ULL, 0x000fc400078e022dULL,
0x00000010080f7824ULL, 0x100fe400078e022dULL, 0x0000001012237824ULL, 0x100fe400078e022dULL,
0x0000001018297824ULL, 0x100fe400078e022dULL, 0x000000101a2d7824ULL, 0x000fe400078e022dULL,
0x000000010b217824ULL, 0x000fe400000e0631ULL, 0x0000000160187824ULL, 0x000fc400078e0215ULL,
0x00000001601a7824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020337faeULL, 0x0003e2000b901c46ULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fc600078ef805ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003014147812ULL, 0x100fe400078ef805ULL,
0x0000000a2f0a7210ULL, 0x040fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003016167812ULL, 0x100fe400078ef805ULL, 0x000000142f147210ULL, 0x040fe20007f3e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000003018187812ULL, 0x100fe400078ef805ULL,
0x000000162f167210ULL, 0x000fe20007f5e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000301a1a7812ULL, 0x000fc400078ef805ULL, 0x000000182f187210ULL, 0x040fe20007f7e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000301c1c7812ULL, 0x000fe400078ef805ULL,
0x0000001a2f1a7210ULL, 0x000fe20007f9e0ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0631ULL,
0x000000301e057812ULL, 0x000fe200078ef805ULL, 0x0000000115157824ULL, 0x100fe200008e0631ULL,
0x0000001c2f1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000117177824ULL, 0x100fe200010e0631ULL,
0x000000052f1e7210ULL, 0x000fe20007fde0ffULL, 0x0000000119197824ULL, 0x100fe200018e0631ULL,
0x000000000a0f7faeULL, 0x0003e2000b901c46ULL, 0x000000011b1b7824ULL, 0x000fc400020e0631ULL,
0x000000011d1d7824ULL, 0x100fe200028e0631ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x000000011f1f7824ULL, 0x000fc600030e0631ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000001a297faeULL, 0x0003e8000b901c46ULL,
0x000000001c2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e2d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x01260400ff057984ULL, 0x000e620000000800ULL, 0x0000000902027224ULL, 0x000fc400078e02ffULL,
0x000000010e0f7824ULL, 0x000fe400078e0a13ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x8000000005ff7812ULL, 0x002fe20007804807ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620002027625ULL, 0x000fe200078e0003ULL,
0x00000008ff0f7819ULL, 0x000fe2000001160fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140a087210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e0bULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011414ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0614ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x0000002011057824ULL, 0x002fca00078e0206ULL,
0x00000004ff067819ULL, 0x000fe40000011605ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL, 0x0000001f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001080b7824ULL, 0x040fe400078e0207ULL, 0x00000001050a7824ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0x0000001006127824ULL, 0x040fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001006157824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x100fe200078e0208ULL,
0x000001f0120b7812ULL, 0x000fe200078ee20bULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x000001f0150a7812ULL, 0x000fe200078ee20aULL, 0x0000001006087824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x000000000b147984ULL, 0x000e62000000cc00ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fc400078ec0ffULL,
0x000000000a187984ULL, 0x000ea4000000cc00ULL, 0x000001f006077812ULL, 0x000fe400078ee207ULL,
0x000001f008057812ULL, 0x000fe200078ee205ULL, 0x000000ffff1e7224ULL, 0x002fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1c7224ULL, 0x004fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fc400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fe200078e0017ULL, 0x0000001c0a007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff217224ULL, 0x000fca00078e001bULL,
0x000000200b007388ULL, 0x000fe8000000cc00ULL, 0x0000000007147984ULL, 0x000e68000000cc00ULL,
0x0000000005187984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002405007388ULL, 0x0003e8000000cc00ULL, 0x0000001407007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff147f8cULL, 0x002e62000c80043fULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x01260400ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x006fc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a06087210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140aULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060aULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000657919ULL, 0x000e620000000000ULL,
0x00006a0004127a24ULL, 0x000fe200078e02ffULL, 0x3db504f364647820ULL, 0x010fe20000410000ULL,
0x0000000209627824ULL, 0x000fe200078e00ffULL, 0x0001268811667811ULL, 0x000fe200078e18ffULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0xffffffff13677810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e00ffULL, 0x0000000913687810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6b7224ULL, 0x000fe200078e0011ULL, 0x0001260811697811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff6e7224ULL, 0x004fe200078e006cULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6d7224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x018fc4000001ff00ULL, 0x000000016d00780cULL, 0x040fe20003f25270ULL,
0x00000c0000007945ULL, 0x000fe20003800000ULL, 0x000000016a067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6f7224ULL, 0x000fe200078e006dULL, 0x000000016d057810ULL, 0x000fe20007ffe0ffULL,
0x00000061005e7224ULL, 0x030fe200078e02ffULL, 0x000000016e6c7812ULL, 0x000fc400078e0cffULL,
0x000000020500780cULL, 0x040fe20003f06070ULL, 0x000000ffff6d7224ULL, 0x000fe200078e0005ULL,
0x000000ff05047207ULL, 0x000fc60000800000ULL, 0x000000ffff061224ULL, 0x000fca00078e026aULL,
0x0000000106077810ULL, 0x000fc80007ffe0ffULL, 0x0000000c0700720cULL, 0x000fda0003f46070ULL,
0x000006000000a947ULL, 0x000fea0003800000ULL, 0x0000001065057824ULL, 0x002fe200078e00ffULL,
0x00000002ff707819ULL, 0x000fe40000011665ULL, 0x000064005e777a11ULL, 0x000fe400078238ffULL,
0x0000003005077812ULL, 0x000fe200078ec0ffULL, 0x0000010006057824ULL, 0x000fe200078e0263ULL,
0x00000008705b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000160517824ULL, 0x000fe200078e0270ULL,
0x0000001070717810ULL, 0x000fe20007ffe0ffULL, 0x0000004004067824ULL, 0x000fe200078e0207ULL,
0x000065005e797a11ULL, 0x000fe200008f3cffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000000050e547217ULL, 0x000fe20007800000ULL, 0x0000000160537824ULL, 0x000fe200078e025bULL,
0x0000001870747810ULL, 0x040fe20007ffe0ffULL, 0x0000008051507825ULL, 0x000fe200078e0006ULL,
0x0000002070767810ULL, 0x000fc40007ffe0ffULL, 0x0000002870787810ULL, 0x000fe20007ffe0ffULL,
0x0000008053527825ULL, 0x000fe200078e0006ULL, 0x0000007750567210ULL, 0x000fe40007f3e0ffULL,
0x0000006565507211ULL, 0x000fe200078fe8ffULL, 0x0000000160557824ULL, 0x000fe200078e0271ULL,
0x0000007752587210ULL, 0x000fe20007f5e0ffULL, 0x0000000154057824ULL, 0x000fe200078e0a05ULL,
0x0000000350727812ULL, 0x000fe200078ec0ffULL, 0x0000000151577824ULL, 0x000fe200008e0679ULL,
0x00000030707a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008055547825ULL, 0x000fe200078e0006ULL,
0x0ffffffc725f7812ULL, 0x000fc400078ef865ULL, 0x000000057400720cULL, 0x000fe20003fa6070ULL,
0x0000000160517824ULL, 0x000fe200078e0274ULL, 0x0000007754547210ULL, 0x000fe20007f3e0ffULL,
0x0000000153597824ULL, 0x000fe200010e0679ULL, 0x000000055b00720cULL, 0x000fe20003f46070ULL,
0x0000008051507825ULL, 0x000fc800078e0006ULL, 0x0000000160537824ULL, 0x000fe200078e0276ULL,
0x00000077505a7210ULL, 0x000fe20007f7e0ffULL, 0x00000002115e7824ULL, 0x000fe400078e026cULL,
0x0000008053527825ULL, 0x000fc600078e0006ULL, 0x000020005e5e7811ULL, 0x000fe200078e60ffULL,
0x0000000155557824ULL, 0x100fe200008e0679ULL, 0x000000057000720cULL, 0x000fe20003f26070ULL,
0x000000045b737824ULL, 0x000fe200078e00ffULL, 0x00000077525c7210ULL, 0x000fe20007f9e0ffULL,
0x00000001515b7824ULL, 0x100fe200018e0679ULL, 0x000000057100720cULL, 0x080fe20003f66070ULL,
0x000000105f517824ULL, 0x000fe200078e025eULL, 0x0000003870707810ULL, 0x000fe20007ffe0ffULL,
0x00000004715f7824ULL, 0x000fe400078e00ffULL, 0x00000001535d7824ULL, 0x000fe200020e0679ULL,
0xfffffffc73537812ULL, 0x000fe200078ee272ULL, 0x0000000160717824ULL, 0x040fe200078e0278ULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000056517faeULL, 0x0003e2000c901c46ULL, 0x0000000160737824ULL, 0x000fe200078e027aULL,
0x000000057600720cULL, 0x080fe20003f86070ULL, 0x0000001053537824ULL, 0x100fe200078e025eULL,
0x000000057000720cULL, 0x000fe20003f26070ULL, 0x000000105f5f7824ULL, 0x000fc400078e025eULL,
0x0000000160757824ULL, 0x000fe200078e0270ULL, 0x0000000058537faeULL, 0x0005e2000d101c46ULL,
0x000000057a00720cULL, 0x080fe20003f46070ULL, 0x0000008071507825ULL, 0x102fe400078e0006ULL,
0x00000000545f7faeULL, 0x0003e2000d901c46ULL, 0x000000057800720cULL, 0x000fe20003f66070ULL,
0x0000000474057824ULL, 0x000fe200078e00ffULL, 0x0000007750507210ULL, 0x000fe20007fde0ffULL,
0x0000000478577824ULL, 0x000fe400078e00ffULL, 0x0000008073527825ULL, 0x004fe200078e0006ULL,
0xfffffffc05057812ULL, 0x000fc400078ee272ULL, 0xfffffffc57577812ULL, 0x000fe200078ee272ULL,
0x0000000151517824ULL, 0x000fe200030e0679ULL, 0x0000007752527210ULL, 0x000fe20007fde0ffULL,
0x0000000476557824ULL, 0x002fe400078e00ffULL, 0x000000047a597824ULL, 0x000fe400078e00ffULL,
0x0000008075067825ULL, 0x000fe200078e0006ULL, 0xfffffffc55557812ULL, 0x100fe400078ee272ULL,
0xfffffffc59597812ULL, 0x000fe200078ee272ULL, 0x00000004705f7824ULL, 0x000fc400078e00ffULL,
0x0000000153537824ULL, 0x100fe200030e0679ULL, 0x0000007706067210ULL, 0x000fe20007fde0ffULL,
0x0000001005057824ULL, 0x000fe200078e025eULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee272ULL,
0x0000001055557824ULL, 0x100fe400078e025eULL, 0x0000001057577824ULL, 0x100fe200078e025eULL,
0x000000005a057faeULL, 0x0003e2000e901c46ULL, 0x0000001059597824ULL, 0x100fe400078e025eULL,
0x000000105f5f7824ULL, 0x000fe200078e025eULL, 0x000000005c557faeULL, 0x0003e2000e101c46ULL,
0x0000000107077824ULL, 0x000fc600030e0679ULL, 0x0000000050577faeULL, 0x0003e8000d901c46ULL,
0x0000000052597faeULL, 0x0003e8000d101c46ULL, 0x00000000065f7faeULL, 0x0003e2000c901c46ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x0000000211077824ULL, 0x000fe200078e026cULL,
0x0000000865517811ULL, 0x002fc400078ff0ffULL, 0x0000001065537811ULL, 0x040fe400078ff0ffULL,
0x0000001865557811ULL, 0x040fe400078ff0ffULL, 0x0000002065577811ULL, 0x000fe200078ff0ffULL,
0x00000004535f7824ULL, 0x000fe200078e00ffULL, 0x0000002865597811ULL, 0x000fe200078ff0ffULL,
0x0000000455717824ULL, 0x000fe200078e00ffULL, 0x00000030655b7811ULL, 0x000fe200078ff0ffULL,
0x0000000457737824ULL, 0x000fe200078e00ffULL, 0x00000038657d7811ULL, 0x000fe200078ff0ffULL,
0x0000000459757824ULL, 0x000fe200078e00ffULL, 0x0000006565057211ULL, 0x000fe200078fe8ffULL,
0x000000045b777824ULL, 0x000fe200078e00ffULL, 0x0000200007507811ULL, 0x000fe200078e60ffULL,
0x0000000451077824ULL, 0x000fe200078e00ffULL, 0x0000000305067812ULL, 0x000fe200078ec0ffULL,
0x000000047d797824ULL, 0x000fe200078e00ffULL, 0x000064005e7b7a11ULL, 0x000fe200078238ffULL,
0x0000000160517824ULL, 0x040fe200078e0251ULL, 0xfffffffc07077812ULL, 0x100fe200078ee206ULL,
0x0000000160537824ULL, 0x040fe200078e0253ULL, 0xfffffffc5f5f7812ULL, 0x100fe200078ee206ULL,
0x0000000160557824ULL, 0x040fe200078e0255ULL, 0xfffffffc71717812ULL, 0x100fe200078ee206ULL,
0x0000000160577824ULL, 0x040fe200078e0257ULL, 0xfffffffc73737812ULL, 0x100fe200078ee206ULL,
0x0000000160597824ULL, 0x040fe200078e0259ULL, 0xfffffffc75757812ULL, 0x100fe200078ee206ULL,
0x00000001605b7824ULL, 0x000fe200078e025bULL, 0x0ffffffc06057812ULL, 0x000fe200078ef865ULL,
0x00000001607d7824ULL, 0x000fe200078e027dULL, 0xfffffffc77777812ULL, 0x000fe200078ee206ULL,
0x000000105f5f7824ULL, 0x000fe200078e0250ULL, 0xfffffffc79797812ULL, 0x000fe200078ee206ULL,
0x0000001065067824ULL, 0x000fc400078e00ffULL, 0x00000010057f7824ULL, 0x100fe400078e0250ULL,
0x0000001007057824ULL, 0x100fe200078e0250ULL, 0x00000030065d7812ULL, 0x000fe200078ec0ffULL,
0x0000001071717824ULL, 0x100fe200078e0250ULL, 0x0000006065077211ULL, 0x000fe200078ff0ffULL,
0x0000001073737824ULL, 0x000fe400078e0250ULL, 0x00000040045c7824ULL, 0x000fe400078e025dULL,
0x000000ffff5d7224ULL, 0x000fc400078e00ffULL, 0x0000001075757824ULL, 0x100fe400078e0250ULL,
0x0000001077777824ULL, 0x100fe400078e0250ULL, 0x0000001079797824ULL, 0x000fe400078e0250ULL,
0x0000008007067825ULL, 0x000fc800078e005cULL, 0x0000008051507825ULL, 0x000fc800078e005cULL,
0x0000008053527825ULL, 0x000fe200078e005cULL, 0x0000007b50507210ULL, 0x000fc60007f5e0ffULL,
0x0000008055547825ULL, 0x000fe200078e005cULL, 0x0000007b52527210ULL, 0x000fc60007f7e0ffULL,
0x0000008057567825ULL, 0x000fe200078e005cULL, 0x0000007b54547210ULL, 0x000fc60007f9e0ffULL,
0x0000008059587825ULL, 0x000fc800078e005cULL, 0x000000805b5a7825ULL, 0x000fc800078e005cULL,
0x000000807d5c7825ULL, 0x000fe200078e005cULL, 0x000065005e7d7a11ULL, 0x000fe400008f3cffULL,
0x0000007b06067210ULL, 0x000fc60007f3e0ffULL, 0x0000000151517824ULL, 0x100fe200010e067dULL,
0x0000007b58587210ULL, 0x080fe20007f5e0ffULL, 0x0000000107077824ULL, 0x100fe200008e067dULL,
0x0000007b56567210ULL, 0x080fe20007f3e0ffULL, 0x0000000153537824ULL, 0x100fe200018e067dULL,
0x0000007b5a5a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000155557824ULL, 0x100fe200020e067dULL,
0x0000007b5c5c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000157577824ULL, 0x100fe200008e067dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067f7faeULL, 0x0003e2000b901c46ULL,
0x0000000159597824ULL, 0x000fc400010e067dULL, 0x000000015b5b7824ULL, 0x100fe200018e067dULL,
0x0000000050057faeULL, 0x0003e2000b901c46ULL, 0x000000015d5d7824ULL, 0x000fc600020e067dULL,
0x00000000525f7faeULL, 0x0003e8000b901c46ULL, 0x0000000054717faeULL, 0x0003e8000b901c46ULL,
0x0000000056737faeULL, 0x0003e8000b901c46ULL, 0x0000000058757faeULL, 0x0003e8000b901c46ULL,
0x000000005a777faeULL, 0x0003e8000b901c46ULL, 0x000000005c797faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010400780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000046b6b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x0000000d6b00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000212047824ULL, 0x000fe400078e026bULL, 0x00000004ff057424ULL, 0x002fc800078e00ffULL,
0x0000660004047625ULL, 0x000fca00078e0005ULL, 0x0000000604007981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000086f737824ULL, 0x002fe400078e00ffULL, 0x000000ffff807224ULL, 0x000fe400078e00ffULL,
0x00000010ff727424ULL, 0x000fe200078e00ffULL, 0x0000001273717810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x0000000273737810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff865047812ULL, 0x000fe200078ec0ffULL,
0x0000000211537824ULL, 0x020fe200078e026eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001707a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000704507812ULL, 0x000fe400078ef865ULL,
0x0000200053537811ULL, 0x000fe400078e60ffULL, 0x00000001ff517819ULL, 0x000fe20000011650ULL,
0x0000000450057824ULL, 0x040fe200078e00ffULL, 0x0000000765917812ULL, 0x000fe200078ec0ffULL,
0x0000000450507824ULL, 0x000fe400078e00ffULL, 0x0000000151047824ULL, 0x040fe400078e0270ULL,
0x0000000151517824ULL, 0x000fc600078e027aULL, 0xfffffffc05047812ULL, 0x000fe400078ee204ULL,
0xfffffffc50507812ULL, 0x000fc600078ee251ULL, 0x0000001004047824ULL, 0x100fe400078e0253ULL,
0x0000001050507824ULL, 0x000fc800078e0253ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000005058783bULL, 0x0004e40000000200ULL, 0x0000002065507810ULL, 0x004fc80007ffe0ffULL,
0xfffffff850507812ULL, 0x000fc800078ec0ffULL, 0x0000000750507812ULL, 0x000fca00078ef865ULL,
0x0000000450557824ULL, 0x000fe400078e00ffULL, 0x0001000004517824ULL, 0x042fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011404ULL, 0x0000010004547824ULL, 0x040fe200078e00ffULL,
0x0000888004527816ULL, 0x000fe200000000ffULL, 0x00010000055e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011451ULL, 0x00000001ff517819ULL, 0x000fe20000011650ULL,
0x0000005200927306ULL, 0x0003e20000200c00ULL, 0x00000018ff5d7819ULL, 0x000fc40000011454ULL,
0x00000018ff777819ULL, 0x008fe20000011458ULL, 0x0000000151047824ULL, 0x040fe200078e0270ULL,
0x0000888058787816ULL, 0x000fe200000000ffULL, 0x0000000151517824ULL, 0x000fe200078e027aULL,
0x00000018ff767819ULL, 0x000fe20000011459ULL, 0x0000005c00937306ULL, 0x0004e20000200c00ULL,
0xfffffffc55047812ULL, 0x000fe400078ee204ULL, 0x0000888005527816ULL, 0x002fe400000000ffULL,
0x00008880597b7816ULL, 0x000fe200000000ffULL, 0x0000001004047824ULL, 0x000fe200078e0253ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005200947306ULL, 0x0003e20000200c00ULL,
0x00010000065c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011405ULL,
0x000000000454783bULL, 0x0004e20000000200ULL, 0x0000010005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc40000011406ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000005d00957306ULL, 0x000fe20000200c00ULL, 0x0000000865527812ULL, 0x002fe200078ec0ffULL,
0x0001000007047824ULL, 0x004fe200078e00ffULL, 0x00008880068f7816ULL, 0x040fe200000000ffULL,
0x0000010006067824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x0000005c00967306ULL, 0x000fe20000200c00ULL,
0x00000018ff867819ULL, 0x000fc40000011407ULL, 0x00008880078b7816ULL, 0x040fe200000000ffULL,
0x0000010007077824ULL, 0x000fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x0000541092927816ULL, 0x008fe20000000093ULL, 0x00000004008e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff077819ULL, 0x000fe40000011407ULL, 0x00000018ff757819ULL, 0x000fe4000001145aULL,
0x000088805a7e7816ULL, 0x000fc400000000ffULL, 0x00000018ff747819ULL, 0x000fe2000001145bULL,
0x0000005e00977306ULL, 0x000fe20000200c00ULL, 0x0001000058047824ULL, 0x002fe200078e00ffULL,
0x0000000270707810ULL, 0x000fe20007ffe0ffULL, 0x0000010058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011404ULL, 0x0000000450047824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0001000059507824ULL, 0x040fe200078e00ffULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x0000010059597824ULL, 0x000fe200078e00ffULL,
0xfffffffc04047812ULL, 0x000fe200078ee251ULL, 0x000100005a517824ULL, 0x040fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011450ULL, 0x000001005a5a7824ULL, 0x000fe200078e00ffULL,
0x0000005265507211ULL, 0x000fe200078fe0ffULL, 0x0000001004047824ULL, 0x000fe200078e0253ULL,
0x00000058007a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff7d7819ULL, 0x000fe20000011459ULL,
0x0001000054987824ULL, 0x040fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011451ULL,
0x0000000191917824ULL, 0x000fe200078e0250ULL, 0x00000018ff827819ULL, 0x000fe2000001145aULL,
0x000000086f507824ULL, 0x040fe200078e0280ULL, 0x00008880545a7816ULL, 0x000fe200000000ffULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x0000000752587812ULL, 0x004fe200078ef865ULL,
0x000000086f527824ULL, 0x000fe200078e0272ULL, 0x0000541095937816ULL, 0x002fe20000000090ULL,
0x0000000191507824ULL, 0x040fe200078e0250ULL, 0x0000001058597812ULL, 0x040fe200078efcffULL,
0x0000001058537824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011455ULL,
0x0000000191527824ULL, 0x000fe200078e0252ULL, 0x0000000500997306ULL, 0x000fe20000200c00ULL,
0x00000010595d7824ULL, 0x000fe200078e00ffULL, 0xfffffff053507812ULL, 0x000fe200078ee250ULL,
0x0001000055957824ULL, 0x040fe200078e00ffULL, 0x00008880559a7816ULL, 0x000fe200000000ffULL,
0x0000001059597824ULL, 0x000fe200078e00ffULL, 0xfffffff05d527812ULL, 0x000fe200078ee252ULL,
0x00000010505c7824ULL, 0x000fe200078e00ffULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x00000018ff957819ULL, 0x000fe20000011495ULL, 0x000000ffff907224ULL, 0x000fe200078e009aULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x0000001052527824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x0000541094947816ULL, 0x000fc40000000097ULL,
0x00000006009b7306ULL, 0x000ea20000200c00ULL, 0x00000018ff897819ULL, 0x000fe20000011454ULL,
0x000000005250783bULL, 0x000ee20000000200ULL, 0x00000018ff877819ULL, 0x000fe20000011456ULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fc60000011457ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x00000007008d7306ULL, 0x0004640000200c00ULL, 0x000054109b977816ULL, 0x004fe40000000088ULL,
0x0000888057887816ULL, 0x000fc800000000ffULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000000000404783bULL, 0x000eae0000000200ULL, 0x0000008f008f7306ULL, 0x000ee20000200c00ULL,
0x000054108d8d7816ULL, 0x002fe20000000086ULL, 0x000000ffff867224ULL, 0x000fc400078e0088ULL,
0x0001000057887824ULL, 0x040fe200078e00ffULL, 0x000000925c4c723cULL, 0x080fe2000000184cULL,
0x0000010057577824ULL, 0x000fe400078e00ffULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000092502c723cULL, 0x008be6000000182cULL, 0x00000098009d7306ULL, 0x000e620000200c00ULL,
0x000054108f967816ULL, 0x000fc60000000096ULL, 0x0000010055927824ULL, 0x020fc800078e00ffULL,
0x0000009500557306ULL, 0x0007e20000200c00ULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x000000965c44723cULL, 0x080fec0000001844ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x0000541099957816ULL, 0x008fe2000000008cULL, 0x000000965024723cULL, 0x000f620000001824ULL,
0x00008880568c7816ULL, 0x000fc400000000ffULL, 0x00000018ff847819ULL, 0x004fe40000011404ULL,
0x00000018ff837819ULL, 0x000fe20000011405ULL, 0x0000008c00987306ULL, 0x0005e20000200c00ULL,
0x00000018ff817819ULL, 0x000fe20000011406ULL, 0x000000945c48723cULL, 0x080fec0000001848ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x000054108b8c7816ULL, 0x004fe2000000008eULL,
0x000000945028723cULL, 0x000bec0000001828ULL, 0x00000088008e7306ULL, 0x0003e20000200c00ULL,
0x0001000056947824ULL, 0x060fe200078e00ffULL, 0x0000008c5c40723cULL, 0x000f620000001840ULL,
0x0000010056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000054105a887816ULL, 0x002fe2000000009dULL, 0x0000008c5020723cULL, 0x000b6c0000001820ULL,
0x00000094008f7306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000009000907306ULL, 0x000eb00000200c00ULL,
0x0000009200937306ULL, 0x0006a20000200c00ULL, 0x0000541054897816ULL, 0x002fc40000000089ULL,
0x000088805b547816ULL, 0x000fca00000000ffULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x0000007391927210ULL, 0x148fe20007ffe080ULL, 0x000000885c3c723cULL, 0x080fe2000000183cULL,
0x0000007191807210ULL, 0x000fe20007ffe080ULL, 0x0000001058917824ULL, 0x000fe200078e00ffULL,
0x00005410908c7816ULL, 0x024fe20000000055ULL, 0x000000ffff557224ULL, 0x000fe200078e0054ULL,
0xfffffff059807812ULL, 0x000fe200078ee280ULL, 0x00000086008b7306ULL, 0x0004e20000200c00ULL,
0x00005410938d7816ULL, 0x000fe2000000008aULL, 0x000100005b547824ULL, 0x000fe200078e00ffULL,
0xfffffff091927812ULL, 0x000fe200078ee292ULL, 0x0000001080587824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011407ULL, 0x00000088501c723cULL, 0x000fe2000000181cULL,
0x00000018ff8a7819ULL, 0x000fe20000011454ULL, 0x00000057005a7306ULL, 0x000ee20000200c00ULL,
0x0000541098867816ULL, 0x004fe2000000008fULL, 0x0000001092547824ULL, 0x000fe200078e00ffULL,
0x0000541056877816ULL, 0x002fc60000000087ULL, 0x0000008c5c38723cULL, 0x040f620000001838ULL,
0x000054108b8e7816ULL, 0x008fe2000000008eULL, 0x0000007e007e7306ULL, 0x000fec0000200c00ULL,
0x000000865c34723cULL, 0x000fe20000001834ULL, 0x000054105a8f7816ULL, 0x000fe20000000085ULL,
0x0000007f007f7306ULL, 0x000e6c0000200c00ULL, 0x0000008c5018723cULL, 0x000f640000001818ULL,
0x0000007500757306ULL, 0x000fec0000200c00ULL, 0x0000008e5c30723cULL, 0x000be40000001830ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x000054107e7e7816ULL, 0x002fc8000000007fULL,
0x000001005b5d7824ULL, 0x020fe200078e00ffULL, 0x00008880045e7816ULL, 0x040fe200000000ffULL,
0x00010000045f7824ULL, 0x040fe200078e00ffULL, 0x000000865014723cULL, 0x040f620000001814ULL,
0x00000080005c7306ULL, 0x0003e20000200c00ULL, 0x0000010004047824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x0000008e5008723cULL, 0x000b620000001808ULL, 0x0000005500907306ULL, 0x0005e20000200c00ULL,
0x0000888005807816ULL, 0x002fc400000000ffULL, 0x00005410827f7816ULL, 0x004fe20000000075ULL,
0x0001000007757824ULL, 0x000fe400078e00ffULL, 0x0001000005517824ULL, 0x060fe200078e00ffULL,
0x0000888006527816ULL, 0x040fe200000000ffULL, 0x0000010005057824ULL, 0x000fe200078e00ffULL,
0x0000008a00917306ULL, 0x000e620000200c00ULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x000000ffff507224ULL, 0x000fe200078e0080ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0001000006537824ULL, 0x040fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000010006067824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fc40000011453ULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0xfffffff472807810ULL, 0x000fc60007ffe0ffULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x0000541090907816ULL, 0x002fce0000000091ULL,
0x0000000400857306ULL, 0x000fe20000200c00ULL, 0x0000007e5824723cULL, 0x008b6e0000001824ULL,
0x0000000500047306ULL, 0x0003e20000200c00ULL, 0x000054105d917816ULL, 0x000fce0000000074ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000888007057816ULL, 0x042fe200000000ffULL,
0x0000010007077824ULL, 0x000fe200078e00ffULL, 0x0000007e5444723cULL, 0x044b680000001844ULL,
0x00000018ff077819ULL, 0x000fe20000011407ULL, 0x0000005100517306ULL, 0x000e660000200c00ULL,
0x000000905440723cULL, 0x080b6a0000001840ULL, 0x0000008300837306ULL, 0x000ea60000200c00ULL,
0x000000905820723cULL, 0x000b6a0000001820ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541050507816ULL, 0x002fce0000000051ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541004517816ULL, 0x004fe40000000083ULL, 0x0000000472047810ULL, 0x000fc80007ffe0ffULL,
0x000000180400780cULL, 0x000fe20003f25270ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000505438723cULL, 0x000b620000001838ULL, 0x000000ffff727224ULL, 0x000fcc00078e0004ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x0000541078787816ULL, 0x002fe20000000079ULL,
0x000000505818723cULL, 0x000b6c0000001818ULL, 0x0000005200527306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x000054105e5e7816ULL, 0x004fce000000005fULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541052527816ULL, 0x002fce0000000053ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000054107a797816ULL, 0x004fce0000000077ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x00000078544c723cULL, 0x080b6e000000184cULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x00000078582c723cULL, 0x000b6e000000182cULL, 0x0000008400847306ULL, 0x000ee20000200c00ULL,
0x000054107b7c7816ULL, 0x002fce000000007cULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054107d7d7816ULL, 0x004fce0000000076ULL, 0x0000000600067306ULL, 0x000e620000200c00ULL,
0x00005410855f7816ULL, 0x008fe20000000084ULL, 0x0000007c5448723cULL, 0x080b6c0000001848ULL,
0x0000000500057306ULL, 0x000fe40000200c00ULL, 0x0000007c5828723cULL, 0x000b6c0000001828ULL,
0x0000007500747306ULL, 0x000ea20000200c00ULL, 0x0000541006537816ULL, 0x002fe20000000081ULL,
0x0000005e543c723cULL, 0x040b6c000000183cULL, 0x0000000700077306ULL, 0x000e640000200c00ULL,
0x000000525434723cULL, 0x000b620000001834ULL, 0x0000541005747816ULL, 0x004fce0000000074ULL,
0x0000005e581c723cULL, 0x000b62000000181cULL, 0x0000541007757816ULL, 0x002fce000000005cULL,
0x000000525814723cULL, 0x000b700000001814ULL, 0x000000745430723cULL, 0x080b700000001830ULL,
0x000000745808723cULL, 0x000b620000001808ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffeda000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e006cULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe00000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000644a4a7220ULL, 0x0a0fe20000410000ULL, 0x00000064445b7220ULL, 0x080fe20000410000ULL,
0x0000006446467220ULL, 0x080fe20000410000ULL, 0x0000006442427220ULL, 0x080fe20000410000ULL,
0x0000006443437220ULL, 0x080fe20000410000ULL, 0x000000643e3e7220ULL, 0x080fe20000410000ULL,
0x000000643a3a7220ULL, 0x080fe20000410000ULL, 0x000000644e047220ULL, 0x080fe20000410000ULL,
0x000000644f057220ULL, 0x080fe20000410000ULL, 0x000000644b067220ULL, 0x080fe20000410000ULL,
0x0000006438537220ULL, 0x080fe20000410000ULL, 0x000000643b447220ULL, 0x080fe20000410000ULL,
0x0000006433077220ULL, 0x080fe20000410000ULL, 0x0000006428287220ULL, 0x080fe20000410000ULL,
0x0000006420207220ULL, 0x080fe20000410000ULL, 0x0000006418187220ULL, 0x080fe20000410000ULL,
0x0000006419197220ULL, 0x080fe20000410000ULL, 0x0000006408087220ULL, 0x080fe20000410000ULL,
0x000000644c5d7220ULL, 0x080fe20000410000ULL, 0x00000064485c7220ULL, 0x080fe20000410000ULL,
0x000000643d547220ULL, 0x080fe20000410000ULL, 0x0000006439527220ULL, 0x080fe20000410000ULL,
0x000000642d387220ULL, 0x080fe20000410000ULL, 0x00000064293b7220ULL, 0x080fe20000410000ULL,
0x000000643c597220ULL, 0x080fe20000410000ULL, 0x000000643f487220ULL, 0x080fe20000410000ULL,
0x0000006434517220ULL, 0x080fe20000410000ULL, 0x0000006435507220ULL, 0x080fe20000410000ULL,
0x00000064304f7220ULL, 0x080fe20000410000ULL, 0x00000064324c7220ULL, 0x080fe20000410000ULL,
0x000000642c397220ULL, 0x080fe20000410000ULL, 0x000000642f2d7220ULL, 0x080fe20000410000ULL,
0x000000642b297220ULL, 0x080fe20000410000ULL, 0x00000064253d7220ULL, 0x080fe20000410000ULL,
0x000000644d557220ULL, 0x080fe20000410000ULL, 0x0000006449567220ULL, 0x080fe20000410000ULL,
0x0000006445577220ULL, 0x080fe20000410000ULL, 0x00000064405a7220ULL, 0x080fe20000410000ULL,
0x0000006441587220ULL, 0x080fe20000410000ULL, 0x00000064314e7220ULL, 0x080fe20000410000ULL,
0x000000642e2c7220ULL, 0x080fe20000410000ULL, 0x00000064243c7220ULL, 0x080fe20000410000ULL,
0x00000064213f7220ULL, 0x080fe20000410000ULL, 0x00000064222b7220ULL, 0x080fe20000410000ULL,
0x000000641e257220ULL, 0x080fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e004aULL,
0x0000006447477220ULL, 0x080fe20000410000ULL, 0x000000ffff307224ULL, 0x000fe200078e0046ULL,
0x0000006436367220ULL, 0x080fe20000410000ULL, 0x000000ffff327224ULL, 0x000fe200078e0042ULL,
0x0000006437377220ULL, 0x080fe20000410000ULL, 0x000000ffff347224ULL, 0x000fe200078e0043ULL,
0x000000642a2a7220ULL, 0x080fe20000410000ULL, 0x000000ffff337224ULL, 0x000fe200078e003eULL,
0x0000006426267220ULL, 0x080fe20000410000ULL, 0x000000ffff357224ULL, 0x000fe200078e003aULL,
0x0000006427247220ULL, 0x080fe20000410000ULL, 0x0000006423237220ULL, 0x080fe20000410000ULL,
0x000000641c407220ULL, 0x080fe20000410000ULL, 0x000000641d417220ULL, 0x080fe20000410000ULL,
0x000000641f1f7220ULL, 0x080fe20000410000ULL, 0x000000641a1e7220ULL, 0x080fe20000410000ULL,
0x000000641b1b7220ULL, 0x080fe20000410000ULL, 0x00000064144d7220ULL, 0x080fe20000410000ULL,
0x0000006415457220ULL, 0x080fe20000410000ULL, 0x0000006416167220ULL, 0x080fe20000410000ULL,
0x0000006417217220ULL, 0x080fe20000410000ULL, 0x0000006409497220ULL, 0x080fe20000410000ULL,
0x000000640a227220ULL, 0x080fe20000410000ULL, 0x000000640b0b7220ULL, 0x000fe20000410000ULL,
0x000000ffff2e7224ULL, 0x000fc400078e0004ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff317224ULL, 0x000fe400078e0006ULL, 0x000000ffff4a7224ULL, 0x000fe400078e0007ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0028ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff427224ULL, 0x000fc400078e0018ULL, 0x000000ffff437224ULL, 0x000fe400078e0019ULL,
0x000000ffff467224ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000066087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff287224ULL, 0x000fe400078e002cULL,
0x000000ffff2c7224ULL, 0x000fe400078e002dULL, 0x000000ffff277224ULL, 0x000fe400078e002aULL,
0x000000ffff2a7224ULL, 0x000fc400078e0026ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0024ULL,
0x000000ffff267224ULL, 0x000fe400078e0023ULL, 0x000000ffff247224ULL, 0x000fe400078e001fULL,
0x000000ffff1f7224ULL, 0x000fe400078e001bULL, 0x000000ffff207224ULL, 0x000fe400078e0016ULL,
0x000000ffff237224ULL, 0x000fc400078e000bULL, 0x0000000000047805ULL, 0x002fca0000015200ULL,
0x0000040066077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040066077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004651d7824ULL, 0x000fe200078e00ffULL, 0x0000000f6a00720cULL, 0x000fc80003f06070ULL,
0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL, 0x00000080111c7824ULL, 0x000fca00078e021cULL,
0x012400001c047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000010650a7211ULL, 0x040fe200078ff0ffULL, 0x00000002655f7824ULL, 0x000fc600078e00ffULL,
0x000000100a167810ULL, 0x000fe40007ffe0ffULL, 0x000000065f5f7812ULL, 0x000fca00078ec0ffULL,
0x000000015f6d7824ULL, 0x000fe200078e0213ULL, 0x0000000b000b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0b147810ULL, 0x008fcc0007ffe0ffULL, 0x0000001400097305ULL, 0x000ee4000021f000ULL,
0x000000ffff157224ULL, 0x008fc800078e0a09ULL, 0x00005a0015157a24ULL, 0x000fc800078e02ffULL,
0x0000001509197227ULL, 0x000fe200078e0008ULL, 0x000000080a097810ULL, 0x000fca0007ffe0ffULL,
0x0000000a19087227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL,
0x0000000919157227ULL, 0x000fc800078e00ffULL, 0x00005a000b0b7a24ULL, 0x000fe200078e020aULL,
0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe400078e0a15ULL,
0x0000001619177227ULL, 0x000fe200078e00ffULL, 0x00005a000b007a0cULL, 0x000fc60003f06070ULL,
0x0000000a19187227ULL, 0x000fc800078e00ffULL, 0x000000ffff197224ULL, 0x000fe400078e0a18ULL,
0x00005a0014147a24ULL, 0x000fe400078e0209ULL, 0x000000ffff097224ULL, 0x000fe400078e0a17ULL,
0x00005a0019197a24ULL, 0x000fe200078e020aULL, 0x00005a0014007a0cULL, 0x000fe20003fa6070ULL,
0x00005a0009167a24ULL, 0x000fe200078e0216ULL, 0x80005a000b0b0a10ULL, 0x000fe20007ffe0ffULL,
0x000001006a097824ULL, 0x000fe200078e0263ULL, 0x00005a0019007a0cULL, 0x000fc40003f66070ULL,
0x00005a0016007a0cULL, 0x000fe40003f26070ULL, 0x00005a000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000108080810ULL, 0x000fe40007ffe0ffULL, 0x000000090e5e7217ULL, 0x000fe40007800000ULL,
0x80005a0014145a10ULL, 0x000fe40007ffe0ffULL, 0x0000000115155810ULL, 0x000fe20007ffe0ffULL,
0x000000015e5e7824ULL, 0x000fe200078e0a09ULL, 0x80005a0019193a10ULL, 0x000fe20007ffe0ffULL,
0x0000000168097824ULL, 0x000fe200078e025fULL, 0x00005a0014007a0cULL, 0x000fe20003fc6070ULL,
0x000000016d0a7824ULL, 0x100fe200078e0a5eULL, 0x80005a0016161a10ULL, 0x000fe20007ffe0ffULL,
0x0000000109147824ULL, 0x000fe200078e0a5eULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a0019007a0cULL, 0x000fe40003f46070ULL, 0x00005a0016007a0cULL, 0x000fe40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a00ff167a12ULL, 0x000fe400078e33ffULL,
0x0000000118183810ULL, 0x000fe40007ffe0ffULL, 0x0000000816087207ULL, 0x000fc40006800000ULL,
0x0000000115156810ULL, 0x000fe40007ffe0ffULL, 0x0000000117171810ULL, 0x000fe40007ffe0ffULL,
0x0000005e6d00720cULL, 0x000fe40003fc6070ULL, 0x0000000a670a7217ULL, 0x000fe40003800000ULL,
0x0000000118182810ULL, 0x000fe40007ffe0ffULL, 0x0000005e0900720cULL, 0x000fc40003f06070ULL,
0x0000001467147217ULL, 0x040fe40003800000ULL, 0x0000000867097217ULL, 0x000fe40003800000ULL,
0x0000000117174810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0a7c7207ULL, 0x000fe20003000000ULL,
0x0000000962917224ULL, 0x000fe200078e02ffULL, 0x0000001816187207ULL, 0x040fe40006800000ULL,
0x00000015160a7207ULL, 0x000fc40006800000ULL, 0x00000004ff147819ULL, 0x000fe40000011614ULL,
0x0000001716087207ULL, 0x000fe40006800000ULL, 0x0000001867177217ULL, 0x040fe40003800000ULL,
0x0000000a670b7217ULL, 0x040fe40003800000ULL, 0x000000ff14147207ULL, 0x000fe20000000000ULL,
0x0000001762977224ULL, 0x000fe200078e02ffULL, 0x000000917c097211ULL, 0x000fe200078fe0ffULL,
0x0000000b62937224ULL, 0x000fe200078e02ffULL, 0x0000000867157217ULL, 0x000fe20003800000ULL,
0x00000001910b7824ULL, 0x000fe200078e0214ULL, 0x000000977c1b7211ULL, 0x000fe200078fe0ffULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x000000105f777812ULL, 0x000fc600078efcffULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x00000006086f7981ULL, 0x0046a6000c1e9500ULL,
0x0000001562957224ULL, 0x000fe200078e02ffULL, 0x000000060a6e7981ULL, 0x0002a2000c1e9500ULL,
0x0000000114717824ULL, 0x000fe200078e0293ULL, 0x000000937c157211ULL, 0x040fe200078fe0ffULL,
0x000000021b087825ULL, 0x008fe200078e0002ULL, 0x000000957c197211ULL, 0x000fc600078fe0ffULL,
0x00000001681b7824ULL, 0x000fe200078e0277ULL, 0x0000000608797981ULL, 0x0006a2000c1e9500ULL,
0x0000000114177824ULL, 0x000fe400078e0295ULL, 0x000000011b1a7824ULL, 0x000fe400078e0a5eULL,
0x0000000271707825ULL, 0x000fc800078e0002ULL, 0x0000000114737824ULL, 0x000fe200078e0297ULL,
0x0000001a67767217ULL, 0x000fe20003800000ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x0000000670707981ULL, 0x0006a6000c1e9500ULL, 0x0000000217167825ULL, 0x000fc800078e0002ULL,
0x00000002190a7825ULL, 0x002fe200078e0002ULL, 0x0000000616727981ULL, 0x0002a6000c1e9500ULL,
0x0000000177757824ULL, 0x000fe200078e0213ULL, 0x0000000614717981ULL, 0x0086a2000c1e9500ULL,
0x0000000273187825ULL, 0x000fe200078e0002ULL, 0x0000005e1b00720cULL, 0x080fe40003f26070ULL,
0x000000060a737981ULL, 0x0002a2000c1e9500ULL, 0x00000004ff767819ULL, 0x000fe20000011676ULL,
0x00000001751a7824ULL, 0x040fe200078e0a5eULL, 0x0000005e7500720cULL, 0x000fe20003f06070ULL,
0x0000000618747981ULL, 0x0002a2000c1e9500ULL, 0x000000ff76147207ULL, 0x008fc40000800000ULL,
0x0000001a671a7217ULL, 0x000fc60003800000ULL, 0x0000000114177824ULL, 0x002fe200078e0293ULL,
0x000000ff1a827207ULL, 0x000fe40000000000ULL, 0x000000205f817812ULL, 0x000fe200078efcffULL,
0x0000000217167825ULL, 0x000fe200078e0002ULL, 0x0000009182097211ULL, 0x040fe400078fe0ffULL,
0x0000009382157211ULL, 0x040fe200078fe0ffULL, 0x00000001910b7824ULL, 0x000fe200078e0214ULL,
0x0000000616787981ULL, 0x0002e2000c1e9500ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x00000097827d7211ULL, 0x000fc600078fe0ffULL, 0x00000001141b7824ULL, 0x040fe200078e0295ULL,
0x00000006087b7981ULL, 0x0002e2000c1e9500ULL, 0x00000001147f7824ULL, 0x000fe400078e0297ULL,
0x0000000168177824ULL, 0x002fe400078e0281ULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000215147825ULL, 0x000fe200078e0002ULL, 0x000000060a767981ULL, 0x0002e6000c1e9500ULL,
0x0000000117167824ULL, 0x000fe400078e0a5eULL, 0x000000027d087825ULL, 0x000fe400078e0002ULL,
0x00000006147d7981ULL, 0x0002e4000c1e9500ULL, 0x0000000181837824ULL, 0x000fe200078e0213ULL,
0x0000001667807217ULL, 0x000fe20003800000ULL, 0x000000027f0a7825ULL, 0x002fe200078e0002ULL,
0x0000009582197211ULL, 0x000fe200078fe0ffULL, 0x0000000608857981ULL, 0x0002e4000c1e9500ULL,
0x0000000183167824ULL, 0x000fe200078e0a5eULL, 0x0000005e1700720cULL, 0x000fc40003f26070ULL,
0x00000004ff807819ULL, 0x000fe20000011680ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x0000005e8300720cULL, 0x000fe20003f06070ULL, 0x000000060a7e7981ULL, 0x0002e2000c1e9500ULL,
0x0000001667167217ULL, 0x000fe20003800000ULL, 0x0000000219187825ULL, 0x000fe400078e0002ULL,
0x000000061a7a7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff16887207ULL, 0x000fc60000000000ULL,
0x00000006187f7981ULL, 0x0002e4000c1e9500ULL, 0x000000ff800a7207ULL, 0x002fca0000800000ULL,
0x000000010a877824ULL, 0x000fe400078e0293ULL, 0x0000000191097824ULL, 0x000fe200078e020aULL,
0x0000009388197211ULL, 0x040fe200078fe0ffULL, 0x0000000287867825ULL, 0x100fe200078e0002ULL,
0x00000091881b7211ULL, 0x040fe400078fe0ffULL, 0x00000097888b7211ULL, 0x000fe200078fe0ffULL,
0x0000000209087825ULL, 0x100fe400078e0002ULL, 0x0000000686867981ULL, 0x0002e4000c1e9500ULL,
0x0000000219187825ULL, 0x000fc400078e0002ULL, 0x0000000608807981ULL, 0x0002e4000c1e9500ULL,
0x000000021b1a7825ULL, 0x100fe200078e0002ULL, 0x0000009588157211ULL, 0x000fe200078fe0ffULL,
0x0000000618877981ULL, 0x0022e4000c1e9500ULL, 0x000000028b087825ULL, 0x000fe200078e0002ULL,
0x000000305f8b7812ULL, 0x000fe200078efcffULL, 0x000000061a897981ULL, 0x0002e4000c1e9500ULL,
0x000000010a177824ULL, 0x000fc400078e0295ULL, 0x000000010a0b7824ULL, 0x000fe200078e0297ULL,
0x0000000608db7981ULL, 0x0002e2000c1e9500ULL, 0x0000000217167825ULL, 0x000fc800078e0002ULL,
0x00000001681b7824ULL, 0x002fe200078e028bULL, 0x0000000616847981ULL, 0x0002e2000c1e9500ULL,
0x0000000215147825ULL, 0x000fc800078e0002ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x00000006148f7981ULL, 0x0002e6000c1e9500ULL, 0x000000011b1a7824ULL, 0x000fe200078e0a5eULL,
0x000000060a967981ULL, 0x0002e2000c1e9500ULL, 0x000000018b8d7824ULL, 0x000fc600078e0213ULL,
0x0000001a678a7217ULL, 0x000fe20003800000ULL, 0x000000018d1a7824ULL, 0x000fe200078e0a5eULL,
0x0000005e1b00720cULL, 0x080fe40003f26070ULL, 0x00000004ff8a7819ULL, 0x000fe4000001168aULL,
0x0000005e8d00720cULL, 0x000fe40003f06070ULL, 0x0000001a671a7217ULL, 0x000fe40003800000ULL,
0x000000ff8a8c7207ULL, 0x000fc40000800000ULL, 0x000000ff1a8a7207ULL, 0x000fc60000000000ULL,
0x0000000191197824ULL, 0x000fe200078e028cULL, 0x000000918a1b7211ULL, 0x000fe200078fe0ffULL,
0x000000018c157824ULL, 0x002fe200078e0295ULL, 0x000000958a177211ULL, 0x000fe200078fe0ffULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x00000006188e7981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x000000061ac17981ULL, 0x0002e6000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000000614947981ULL, 0x0002e2000c1e9500ULL, 0x000000938a0b7211ULL, 0x000fc600078fe0ffULL,
0x0000000616d97981ULL, 0x0002e2000c1e9500ULL, 0x000000018c097824ULL, 0x000fe400078e0293ULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad77981ULL, 0x0002e4000c1e9500ULL, 0x000000978a197211ULL, 0x002fe400078fe0ffULL,
0x0000000608927981ULL, 0x0002e2000c1e9500ULL, 0x000000018c1b7824ULL, 0x000fe400078e0297ULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000618dd7981ULL, 0x0002e8000c1e9500ULL, 0x000000061a987981ULL, 0x0002e4000c1e9500ULL,
0xfffffff07c097812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd57424ULL, 0x000fc800078e00ffULL,
0x000000015e087824ULL, 0x000fc800078e0209ULL, 0x000000016d097824ULL, 0x000fe200078e0a08ULL,
0x000000015f917812ULL, 0x000fc800078efcffULL, 0x00000009d5097219ULL, 0x000fe200000006ffULL,
0x00000001910b7824ULL, 0x000fe200078e0213ULL, 0xfffffff082157812ULL, 0x000fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000085f937812ULL, 0x040fe200078efcffULL,
0x000000015e167824ULL, 0x000fe200078e0215ULL, 0x000000095f957812ULL, 0x000fe400078efcffULL,
0x0000000ad5157219ULL, 0x000fe200000006ffULL, 0x0000000193177824ULL, 0x100fe400078e0213ULL,
0x00000001951b7824ULL, 0x000fe200078e0213ULL, 0xfffffff088197812ULL, 0x000fe200078ec0ffULL,
0x0000000117147824ULL, 0x100fe200078e0a08ULL, 0xfffffff08a977812ULL, 0x000fe200078ec0ffULL,
0x000000011b087824ULL, 0x000fe200078e0a08ULL, 0x000000115f9b7812ULL, 0x000fe200078efcffULL,
0x000000015e187824ULL, 0x040fe200078e0219ULL, 0x00000014d5197219ULL, 0x040fe200000006ffULL,
0x000000015e887824ULL, 0x000fe200078e0297ULL, 0x00000008d5977219ULL, 0x000fe200000006ffULL,
0x000000019b9d7824ULL, 0x000fc400078e0213ULL, 0x0000000175087824ULL, 0x100fe400078e0a16ULL,
0x000000019d0a7824ULL, 0x000fe200078e0a16ULL, 0x000054106f6e7816ULL, 0x004fc8000000006eULL,
0x0000006e09ff7212ULL, 0x000fc800078ac0ffULL, 0x0000005e6d00720cULL, 0x000fc80002fa1470ULL,
0x0000005e5f00720cULL, 0x000fe40002fa1070ULL, 0x0000006e15ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000005d5d7808ULL, 0x000fe40002800000ULL, 0x0000005e0b00720cULL, 0x000fc80000f21470ULL,
0x0000005e9100720cULL, 0x000fe40000f21070ULL, 0x0000541071707816ULL, 0x000fe40000000070ULL,
0x0000541073727816ULL, 0x000fe40000000072ULL, 0x0000007009ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007209ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007015ff7212ULL, 0x000fc400078ac0ffULL,
0x0000005e6d00720cULL, 0x0c0fe40001741470ULL, 0x0000005e6d00720cULL, 0x080fe40002781470ULL,
0x0000005e0b00720cULL, 0x080fe40002fa1470ULL, 0x0000005e5f00720cULL, 0x0c0fe40001741070ULL,
0x0000005e5f00720cULL, 0x080fe40002781070ULL, 0x0000005e9100720cULL, 0x000fc40002fa1070ULL,
0x0000541079747816ULL, 0x000fe40000000074ULL, 0xff8000002e2e7808ULL, 0x000fe40001000000ULL,
0xff80000039397808ULL, 0x000fe40002000000ULL, 0xff80000055557808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002800000ULL, 0x0000006e19ff7212ULL, 0x000fc4000786c0ffULL,
0x0000007409ff7212ULL, 0x000fe4000780c0ffULL, 0x0000007215ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007415ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007097ff7212ULL, 0x000fe4000782c0ffULL,
0x0000007219ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e6d00720cULL, 0x000fc40000701470ULL,
0x0000005e0b00720cULL, 0x0c0fe40001741470ULL, 0x0000005e0b00720cULL, 0x080fe40002781470ULL,
0x0000005e1700720cULL, 0x0c0fe40001f61470ULL, 0x0000005e1700720cULL, 0x080fe40002fa1470ULL,
0x0000005e1b00720cULL, 0x000fe40000f21470ULL, 0x000000185fa17812ULL, 0x000fc400078efcffULL,
0x000000195fa77812ULL, 0x040fe400078efcffULL, 0x0000005e5f00720cULL, 0x080fe40000701070ULL,
0x0000005e9100720cULL, 0x0c0fe40001741070ULL, 0x0000005e9100720cULL, 0x080fe40002781070ULL,
0x0000005e9300720cULL, 0x0c0fe40001f61070ULL, 0x0000005e9300720cULL, 0x000fc40002fa1070ULL,
0x0000005e9500720cULL, 0x000fe40000f21070ULL, 0x00000008d5997219ULL, 0x040fe400000006ffULL,
0x0000000ad59f7219ULL, 0x000fe400000006ffULL, 0x000054107b767816ULL, 0x008fe40000000076ULL,
0x000054107d787816ULL, 0x000fe20000000078ULL, 0x00000001a1a37824ULL, 0x100fe200078e0213ULL,
0xff80000028287808ULL, 0x000fe20000000000ULL, 0x00000001a7a97824ULL, 0x000fe200078e0213ULL,
0xff80000038387808ULL, 0x000fc40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff8000005c5c7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0x0000007019ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007297ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007419ff7212ULL, 0x080fe4000788c0ffULL,
0x0000007497ff7212ULL, 0x000fe4000786c0ffULL, 0x000000769fff7212ULL, 0x000fe400078ac0ffULL,
0x0000007899ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a3147824ULL, 0x100fe200078e0a16ULL,
0x0000005e1700720cULL, 0x080fe20000701470ULL, 0x00000001a9167824ULL, 0x000fe200078e0a16ULL,
0x0000005e1700720cULL, 0x000fc40002781470ULL, 0x0000005e1b00720cULL, 0x0c0fe40001741470ULL,
0x0000005e1b00720cULL, 0x080fe40001f61470ULL, 0x0000005e7500720cULL, 0x080fe40000f21470ULL,
0x0000005e9d00720cULL, 0x080fe40002fa1470ULL, 0x0000005e9300720cULL, 0x0c0fe40000701070ULL,
0x0000005e9300720cULL, 0x000fc40002781070ULL, 0x0000005e9500720cULL, 0x0c0fe40001741070ULL,
0x0000005e9500720cULL, 0x080fe40001f61070ULL, 0x0000005e7700720cULL, 0x080fe40000f21070ULL,
0x0000005e9b00720cULL, 0x000fe40002fa1070ULL, 0x00000014d5a57219ULL, 0x040fe400000006ffULL,
0x00000016d5ab7219ULL, 0x000fc400000006ffULL, 0x000054107f7a7816ULL, 0x000fe4000000007aULL,
0x00005410857e7816ULL, 0x000fe4000000007eULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fc40001800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000007699ff7212ULL, 0x080fe4000780c0ffULL,
0x00000076a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007a99ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007e99ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007a9fff7212ULL, 0x000fe4000782c0ffULL,
0x00000078abff7212ULL, 0x000fe200078ac0ffULL, 0x00000001831a7824ULL, 0x000fe200078e0a18ULL,
0x0000005e7500720cULL, 0x0c0fe40000701470ULL, 0x0000005e7500720cULL, 0x0c0fe40001741470ULL,
0x0000005e7500720cULL, 0x080fe40001f61470ULL, 0x0000005e9d00720cULL, 0x000fc40000f21470ULL,
0x0000005ea300720cULL, 0x080fe40002781470ULL, 0x0000005ea900720cULL, 0x080fe40002fa1470ULL,
0x000000215faf7812ULL, 0x000fe400078efcffULL, 0x0000005e7700720cULL, 0x0c0fe40000701070ULL,
0x0000005e7700720cULL, 0x0c0fe40001741070ULL, 0x0000005e7700720cULL, 0x000fc40001f61070ULL,
0x0000005e9b00720cULL, 0x080fe40000f21070ULL, 0x0000005ea100720cULL, 0x080fe40002781070ULL,
0x0000005ea700720cULL, 0x000fe40002fa1070ULL, 0x0000001ad5ad7219ULL, 0x000fe400000006ffULL,
0x0000541087867816ULL, 0x000fe20000000086ULL, 0x00000001afb17824ULL, 0x000fe200078e0213ULL,
0xff8000005b5b7808ULL, 0x000fc40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x000000789fff7212ULL, 0x000fc4000780c0ffULL, 0x0000007e9fff7212ULL, 0x000fe4000784c0ffULL,
0x00000078a5ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007aabff7212ULL, 0x040fe4000782c0ffULL,
0x0000007eabff7212ULL, 0x000fe4000788c0ffULL, 0x00000086adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b17c7824ULL, 0x000fe200078e0a18ULL, 0x0000005e9d00720cULL, 0x000fc40000701470ULL,
0x0000005e9d00720cULL, 0x080fe40001741470ULL, 0x0000005ea300720cULL, 0x080fe40001f61470ULL,
0x0000005ea900720cULL, 0x0c0fe40000f21470ULL, 0x0000005ea900720cULL, 0x080fe40002781470ULL,
0x0000005e8300720cULL, 0x000fe40002fa1470ULL, 0x000000285fb57812ULL, 0x000fc400078efcffULL,
0x000000295fbb7812ULL, 0x000fe400078efcffULL, 0x0000005e9b00720cULL, 0x0c0fe40000701070ULL,
0x0000005e9b00720cULL, 0x080fe40001741070ULL, 0x0000005ea100720cULL, 0x080fe40001f61070ULL,
0x0000005ea700720cULL, 0x0c0fe40000f21070ULL, 0x0000005ea700720cULL, 0x000fc40002781070ULL,
0x0000005e8100720cULL, 0x000fe40002fa1070ULL, 0x0000007cd5b37219ULL, 0x000fe400000006ffULL,
0x0000541089807816ULL, 0x000fe40000000080ULL, 0x000054108f847816ULL, 0x000fe40000000084ULL,
0x00005410db967816ULL, 0x000fe20000000096ULL, 0x00000001b5b77824ULL, 0x100fe200078e0213ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x00000001bbbd7824ULL, 0x000fe200078e0213ULL,
0xff8000002d2d7808ULL, 0x000fc40001000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000006e97ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007aa5ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007ea5ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080adff7212ULL, 0x040fe4000786c0ffULL, 0x00000084adff7212ULL, 0x040fe4000782c0ffULL,
0x00000096adff7212ULL, 0x000fe4000788c0ffULL, 0x00000084b3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b7827824ULL, 0x100fe200078e0a18ULL, 0x0000005e1b00720cULL, 0x080fe200037c1470ULL,
0x00000001bd187824ULL, 0x000fe200078e0a18ULL, 0x0000005ea300720cULL, 0x000fc40000701470ULL,
0x0000005ea300720cULL, 0x080fe40001741470ULL, 0x0000005e8300720cULL, 0x0c0fe40001f61470ULL,
0x0000005e8300720cULL, 0x0c0fe40000f21470ULL, 0x0000005e8300720cULL, 0x080fe40002781470ULL,
0x0000005eb100720cULL, 0x080fe40002fa1470ULL, 0x0000005e9500720cULL, 0x000fc400037c1070ULL,
0x0000005ea100720cULL, 0x0c0fe40000701070ULL, 0x0000005ea100720cULL, 0x080fe40001741070ULL,
0x0000005e8100720cULL, 0x0c0fe40001f61070ULL, 0x0000005e8100720cULL, 0x0c0fe40000f21070ULL,
0x0000005e8100720cULL, 0x080fe40002781070ULL, 0x0000005eaf00720cULL, 0x000fc40002fa1070ULL,
0x00000082d5b97219ULL, 0x040fe400000006ffULL, 0x00000018d5bf7219ULL, 0x000fe400000006ffULL,
0xff80000056567808ULL, 0x000fe40003000000ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fc40001800000ULL,
0xff80000040407808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x00000076abff7212ULL, 0x000fe400078cc0ffULL,
0x00000080b3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000080b9ff7212ULL, 0x000fc4000784c0ffULL,
0x00000086b3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000096b3ff7212ULL, 0x000fe4000782c0ffULL,
0x00000086b9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084bfff7212ULL, 0x000fe200078ac0ffULL,
0x000000018d8a7824ULL, 0x000fe200078e0a88ULL, 0x0000005ea900720cULL, 0x080fe400037c1470ULL,
0x0000005eb100720cULL, 0x000fc40000701470ULL, 0x0000005eb100720cULL, 0x0c0fe40001f61470ULL,
0x0000005eb100720cULL, 0x080fe40000f21470ULL, 0x0000005eb700720cULL, 0x0c0fe40001741470ULL,
0x0000005eb700720cULL, 0x080fe40002781470ULL, 0x0000005ebd00720cULL, 0x000fe40002fa1470ULL,
0x000000315fc57812ULL, 0x000fc400078efcffULL, 0x000000385fcb7812ULL, 0x040fe400078efcffULL,
0x000000395fd17812ULL, 0x000fe400078efcffULL, 0x0000005ea700720cULL, 0x080fe400037c1070ULL,
0x0000005eaf00720cULL, 0x0c0fe40000701070ULL, 0x0000005eaf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005eaf00720cULL, 0x000fc40000f21070ULL, 0x0000005eb500720cULL, 0x0c0fe40001741070ULL,
0x0000005eb500720cULL, 0x080fe40002781070ULL, 0x0000005ebb00720cULL, 0x000fe40002fa1070ULL,
0x0000008ad5c37219ULL, 0x000fe400000006ffULL, 0x00005410c18e7816ULL, 0x000fe4000000008eULL,
0x00005410d9947816ULL, 0x000fe20000000094ULL, 0x00000001c5c77824ULL, 0x100fe200078e0213ULL,
0xff80000058587808ULL, 0x000fe20003000000ULL, 0x00000001cbcd7824ULL, 0x100fe200078e0213ULL,
0xff80000054547808ULL, 0x000fe20000000000ULL, 0x00000001d1d37824ULL, 0x000fe200078e0213ULL,
0xff80000048487808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000043437808ULL, 0x000fe40002800000ULL, 0x00000080bfff7212ULL, 0x040fe400078cc0ffULL,
0x00000086bfff7212ULL, 0x000fc4000780c0ffULL, 0x00000084b9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000096b9ff7212ULL, 0x080fe4000782c0ffULL, 0x00000096bfff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ec3ff7212ULL, 0x040fe4000788c0ffULL, 0x00000094c3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c78c7824ULL, 0x100fe200078e0a88ULL, 0x0000005eb700720cULL, 0x080fe20001f61470ULL,
0x00000001cd907824ULL, 0x100fe200078e0a88ULL, 0x0000005eb700720cULL, 0x080fe20000f21470ULL,
0x00000001d3887824ULL, 0x000fe200078e0a88ULL, 0x0000005ebd00720cULL, 0x000fc400037c1470ULL,
0x0000005ebd00720cULL, 0x0c0fe40000701470ULL, 0x0000005ebd00720cULL, 0x080fe40001741470ULL,
0x0000005e8d00720cULL, 0x0c0fe40002781470ULL, 0x0000005e8d00720cULL, 0x000fe40002fa1470ULL,
0x0000008cd5c97219ULL, 0x040fe400000006ffULL, 0x00000090d5cf7219ULL, 0x000fc400000006ffULL,
0x0000005eb500720cULL, 0x0c0fe40001f61070ULL, 0x0000005eb500720cULL, 0x080fe40000f21070ULL,
0x0000005ebb00720cULL, 0x0c0fe400037c1070ULL, 0x0000005ebb00720cULL, 0x0c0fe40000701070ULL,
0x0000005ebb00720cULL, 0x080fe40001741070ULL, 0x0000005e8b00720cULL, 0x000fc40002781070ULL,
0x0000005e8b00720cULL, 0x000fe40002fa1070ULL, 0x00000088d5d57219ULL, 0x000fe400000006ffULL,
0x00005410d7927816ULL, 0x000fe40000000092ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fc40003000000ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x0000008ec9ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ecfff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ed5ff7212ULL, 0x000fe400078cc0ffULL, 0x00000092c3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000092c9ff7212ULL, 0x080fe4000784c0ffULL, 0x00000092cfff7212ULL, 0x000fe4000788c0ffULL,
0x00000094c9ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e8d00720cULL, 0x000fc40000701470ULL,
0x0000005ec700720cULL, 0x0c0fe40001f61470ULL, 0x0000005ec700720cULL, 0x0c0fe40001741470ULL,
0x0000005ec700720cULL, 0x080fe40002fa1470ULL, 0x0000005ecd00720cULL, 0x080fe40000f21470ULL,
0x0000005ed300720cULL, 0x080fe400037c1470ULL, 0x0000005ecd00720cULL, 0x000fc40002781470ULL,
0x0000005e8b00720cULL, 0x080fe40000701070ULL, 0x0000005ec500720cULL, 0x0c0fe40001f61070ULL,
0x0000005ec500720cULL, 0x0c0fe40001741070ULL, 0x0000005ec500720cULL, 0x080fe40002fa1070ULL,
0x0000005ecb00720cULL, 0x080fe40000f21070ULL, 0x0000005ed100720cULL, 0x000fc400037c1070ULL,
0x0000005ecb00720cULL, 0x000fe40002781070ULL, 0x00005410dd987816ULL, 0x000fe40000000098ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002000000ULL, 0x00000092d5ff7212ULL, 0x000fe4000780c0ffULL,
0x00000094cfff7212ULL, 0x080fe4000786c0ffULL, 0x00000094d5ff7212ULL, 0x000fc4000784c0ffULL,
0x00000098c3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000098c9ff7212ULL, 0x080fe4000782c0ffULL,
0x00000098cfff7212ULL, 0x080fe400078cc0ffULL, 0x00000098d5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005e8d00720cULL, 0x080fe40002fa1470ULL, 0x0000005ec700720cULL, 0x000fc40000f21470ULL,
0x0000005ecd00720cULL, 0x0c0fe40001f61470ULL, 0x0000005ecd00720cULL, 0x080fe400037c1470ULL,
0x0000005ed300720cULL, 0x0c0fe40000701470ULL, 0x0000005ed300720cULL, 0x0c0fe40001741470ULL,
0x0000005ed300720cULL, 0x080fe40002781470ULL, 0x0000005e8b00720cULL, 0x000fc40002fa1070ULL,
0x0000005ec500720cULL, 0x080fe40000f21070ULL, 0x0000005ed100720cULL, 0x080fe40000701070ULL,
0x0000005ecb00720cULL, 0x0c0fe40001f61070ULL, 0x0000005ecb00720cULL, 0x080fe400037c1070ULL,
0x0000005ed100720cULL, 0x0c0fe40001741070ULL, 0x0000005ed100720cULL, 0x000fc40002781070ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40003000000ULL,
0xff80000023237808ULL, 0x000fc40002000000ULL, 0x0000005d0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x0000002e0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280700720bULL, 0x000fe40003f7e000ULL, 0x000000045d047208ULL, 0x000fe40004000000ULL,
0x000000052e087208ULL, 0x000fc40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000728077208ULL, 0x000fe40005800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f3e000ULL,
0x0000002c0700720bULL, 0x000fc40003f7e000ULL, 0x0000000455097208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40005000000ULL, 0x000000084b087208ULL, 0x000fe40004800000ULL,
0x000000072c047208ULL, 0x000fe40005800000ULL, 0x0000005c0900720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fc40003f5e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000270400720bULL, 0x000fe40003f7e000ULL, 0x000000095c097208ULL, 0x000fe40004000000ULL,
0x000000053a067208ULL, 0x000fe40005000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x0000000427047208ULL, 0x000fc40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x0000003b0600720bULL, 0x000fe40003f5e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x000000290400720bULL, 0x000fe40003f7e000ULL, 0x00000009560a7208ULL, 0x000fe40004000000ULL,
0x000000063b077208ULL, 0x000fc40005000000ULL, 0x0000000831057208ULL, 0x000fe40004800000ULL,
0x0000000429097208ULL, 0x000fe40005800000ULL, 0x0000005b0a00720bULL, 0x000fe40003f1e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fc40003f7e000ULL, 0x0000000a5b0a7208ULL, 0x000fe40004000000ULL,
0x000000073c067208ULL, 0x000fe40005000000ULL, 0x0000000530047208ULL, 0x000fe40004800000ULL,
0x000000092a087208ULL, 0x000fe40005800000ULL, 0x000000570a00720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fc40003f5e000ULL, 0x000000470400720bULL, 0x000fe40003f3e000ULL,
0x0000002d0800720bULL, 0x000fe40003f7e000ULL, 0x0000000a57057208ULL, 0x000fe40004000000ULL,
0x000000063d097208ULL, 0x000fe40005000000ULL, 0x0000000447077208ULL, 0x000fe40004800000ULL,
0x000000082d087208ULL, 0x000fc40005800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0900720bULL, 0x000fe40003f5e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000002b0800720bULL, 0x000fe40003f7e000ULL, 0x000000055a057208ULL, 0x000fe40004000000ULL,
0x000000093e047208ULL, 0x000fc40005000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x000000082b097208ULL, 0x000fe40005800000ULL, 0x000000580500720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x000000260900720bULL, 0x000fc40003f7e000ULL, 0x0000000558067208ULL, 0x000fe40004000000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000000734087208ULL, 0x000fe40004800000ULL,
0x0000000926047208ULL, 0x000fe40005800000ULL, 0x000000590600720bULL, 0x000fe40003f1e000ULL,
0x000000400500720bULL, 0x000fc40003f5e000ULL, 0x000000330800720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f7e000ULL, 0x0000000659077208ULL, 0x000fe40004000000ULL,
0x0000000540067208ULL, 0x000fe40005000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x0000000425057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x000000480900720bULL, 0x000fe40003f3e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754047208ULL, 0x000fe40004000000ULL,
0x0000000948087208ULL, 0x000fc40004800000ULL, 0x0000000641077208ULL, 0x000fe40005000000ULL,
0x0000000524057208ULL, 0x000fe40005800000ULL, 0x000000530400720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x000000420700720bULL, 0x000fe40003f5e000ULL,
0x0000001e0500720bULL, 0x000fc40003f7e000ULL, 0x0000000453097208ULL, 0x000fe40004000000ULL,
0x00000008350b7208ULL, 0x000fe40004800000ULL, 0x0000000742047208ULL, 0x000fe40005000000ULL,
0x000000051e067208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fc40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fe40003f7e000ULL, 0x0000000952087208ULL, 0x000fe40004000000ULL,
0x0000000b440b7208ULL, 0x000fe40004800000ULL, 0x0000000443047208ULL, 0x000fe40005000000ULL,
0x000000061f057208ULL, 0x000fc40005800000ULL, 0x000000510800720bULL, 0x000fe40003f1e000ULL,
0x000000360b00720bULL, 0x000fe40003f3e000ULL, 0x0000004d0400720bULL, 0x000fe40003f5e000ULL,
0x000000200500720bULL, 0x000fe40003f7e000ULL, 0x0000000851077208ULL, 0x000fe40004000000ULL,
0x0000000b36067208ULL, 0x000fc40004800000ULL, 0x000000044d047208ULL, 0x000fe40005000000ULL,
0x0000000520087208ULL, 0x000fe40005800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000370600720bULL, 0x000fe40003f3e000ULL, 0x000000450400720bULL, 0x000fe40003f5e000ULL,
0x000000210800720bULL, 0x000fc40003f7e000ULL, 0x00000007500a7208ULL, 0x000fe40004000000ULL,
0x0000000637057208ULL, 0x000fe40004800000ULL, 0x0000000445077208ULL, 0x000fe40005000000ULL,
0x0000000821097208ULL, 0x000fe40005800000ULL, 0x0000004f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004c0500720bULL, 0x000fc40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f5e000ULL,
0x000000220900720bULL, 0x000fe40003f7e000ULL, 0x0000000a4f0b7208ULL, 0x000fe40004000000ULL,
0x000000054c057208ULL, 0x000fe40004800000ULL, 0x0000000746047208ULL, 0x000fe40005000000ULL,
0x0000000922067208ULL, 0x000fc40005800000ULL, 0x0000004e0b00720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fe40003f3e000ULL, 0x000000490400720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000b4e077208ULL, 0x000fe40004000000ULL,
0x000000054a0a7208ULL, 0x000fc40004800000ULL, 0x0000000449167208ULL, 0x000fe40005000000ULL,
0x0000000623157208ULL, 0x000fe20005800000ULL, 0x00001fe27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704177208ULL, 0x000fe20004000000ULL, 0x00001ff27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0015067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b06167820ULL, 0x000fe20000410000ULL,
0x00000002ff5f7819ULL, 0x000fe20000011665ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL, 0x0000005500097308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b59557823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL, 0x0000005d00087308ULL, 0x000e620000000800ULL,
0x000000085f197824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a077823ULL, 0x000fe20000010807ULL,
0x0000005c005c7308ULL, 0x000fe20000000800ULL, 0x000000085f707824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010816ULL,
0x0000000700597308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010816ULL,
0x0000005600157308ULL, 0x0006620000000800ULL, 0x0000000a0b077208ULL, 0x004fe20004000000ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010816ULL, 0x000000015f0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b49167823ULL, 0x000fe20000010816ULL, 0x000000025f0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000085f767824ULL, 0x000fe200078e00ffULL, 0xfffffff8196e7812ULL, 0x000fe200078ee20aULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b07567820ULL, 0x008fe20000410000ULL,
0xfffffff870707812ULL, 0x000fe200078ee20bULL, 0x000000085f1b7824ULL, 0x040fe200078e00ffULL,
0x000000045f0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010856ULL,
0x0000004b004b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b29297823ULL, 0x000fe20000010856ULL,
0x000000055f0b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xfffffff819747812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL,
0xfffffff876767812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010856ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010856ULL, 0x0000005c150a723eULL, 0x000fe200000000ffULL,
0x000000085f157824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010856ULL,
0x0000003100147308ULL, 0x000e620000000800ULL, 0x0000002e4b09723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b214b7823ULL, 0x000fe20000010856ULL, 0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL,
0x0000000365ff7812ULL, 0x000fc6000780c0ffULL, 0x00000058005d7308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002f140b723eULL, 0x002fe400000000ffULL,
0xffffffff5f147810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8155c7812ULL, 0x000fe200078ee214ULL,
0x0000002c00177308ULL, 0x000e700000000800ULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003800387308ULL, 0x000ea20000000800ULL, 0x000000281715723eULL, 0x002fce00000000ffULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000e620000000800ULL,
0x000000393814723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b20387823ULL, 0x000fcc0000010856ULL,
0x0000001600497308ULL, 0x0005f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000035f167810ULL, 0x004fc80007ffe0ffULL, 0xfffffff81b727812ULL, 0x000fe400078ee216ULL,
0x000000065f167810ULL, 0x000fe20007ffe0ffULL, 0x0000002900587308ULL, 0x000ea60000000800ULL,
0xfffffff81b787812ULL, 0x000fe400078ee216ULL, 0x0000003a3b16723eULL, 0x002fc600000000ffULL,
0x00000057005e7308ULL, 0x000ff00000000800ULL, 0x0000003400577308ULL, 0x0003e20000000800ULL,
0x000000275817723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1e277823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b22587823ULL, 0x000fca0000010856ULL, 0x0000003500317308ULL, 0x0005e20000000800ULL,
0x3c003c00ff347424ULL, 0x002fce00078e00ffULL, 0x0000005b005b7308ULL, 0x000e620000000800ULL,
0x3c003c00ff357424ULL, 0x004fce00078e00ffULL, 0x000000340818723cULL, 0x000f6200000018ffULL,
0x0000005a005a7308ULL, 0x000ea20000000800ULL, 0x0000005b5e20723eULL, 0x002fce00000000ffULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000105f5e7810ULL, 0x000fca0007ffe0ffULL,
0x000000085e2f7824ULL, 0x000fe400078e00ffULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x0000005a5d22723eULL, 0x004fe400000000ffULL, 0x000000085f5a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f5e7812ULL, 0x000fc600078ee25eULL, 0x0000003200327308ULL, 0x000eb00000000800ULL,
0x00000045004a7308ULL, 0x000fe20000000800ULL, 0x000000304721723eULL, 0x002fce00000000ffULL,
0x0000002a002c7308ULL, 0x000ff00000000800ULL, 0x0000002b00457308ULL, 0x0003f00000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000341428723cULL, 0x002f6e00000018ffULL,
0x0000003d003d7308ULL, 0x000e700000000800ULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000ef00000000800ULL,
0x00000026002e7308ULL, 0x0003f00000000800ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24267823ULL, 0x102fe20000010856ULL, 0x3fb8aa3b23567823ULL, 0x000fe20000010856ULL,
0x000000325723723eULL, 0x004fc400000000ffULL, 0x0000003c3d24723eULL, 0x000fc600000000ffULL,
0x0000005400547308ULL, 0x000e640000000800ULL, 0x000000342018723cULL, 0x020f6c0000001818ULL,
0x0000005300537308ULL, 0x000ff00000000800ULL, 0x0000005200527308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000004800487308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000eb00000000800ULL, 0x0000002500397308ULL, 0x0007f00000000800ULL,
0x00000026001e7308ULL, 0x0004a20000000800ULL, 0x0000002c2d25723eULL, 0x008fe200000000ffULL,
0x000000085a2d7824ULL, 0x000fe200078e00ffULL, 0x00000055542c723eULL, 0x002fc400000000ffULL,
0x00000031442f723eULL, 0x004fe400000000ffULL, 0xfffffff82d5a7812ULL, 0x000fe200078ee25aULL,
0x00000027003b7308ULL, 0x0003e20000000800ULL, 0x0000003e3f26723eULL, 0x000fe200000000ffULL,
0x000000085f3e7824ULL, 0x000fe200078e00ffULL, 0x00000033482d723eULL, 0x000fc800000000ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee25fULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x000000452e27723eULL, 0x002fe400000000ffULL, 0x00000053522e723eULL, 0x000fe400000000ffULL,
0x000000391e39723eULL, 0x000fe400000000ffULL, 0x000000185f5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000342428723cULL, 0x000f620000001828ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000085f7a7824ULL, 0x000fc800078e00ffULL, 0x000000342c18723cULL, 0x020f620000001818ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0xfffffff87a7a7812ULL, 0x000fce00078ee25fULL,
0x0000004300437308ULL, 0x000e700000000800ULL, 0x0000001f003c7308ULL, 0x0004f00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000042433a723eULL, 0x002fc400000000ffULL,
0x0000a000111f7811ULL, 0x004fca00078e60ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000003b3c3b723eULL, 0x008fe200000000ffULL, 0x000000103e3e7824ULL, 0x100fe400078e021fULL,
0x000000106e6e7824ULL, 0x100fe400078e021fULL, 0x0000001070707824ULL, 0x100fe400078e021fULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000001072727824ULL, 0x100fe400078e021fULL,
0x0000001074747824ULL, 0x000fc400078e021fULL, 0x0000001076767824ULL, 0x100fe400078e021fULL,
0x000000011d6e7824ULL, 0x040fe200078e026eULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x000000515030723eULL, 0x002fe200000000ffULL, 0x0000001078787824ULL, 0x100fe400078e021fULL,
0x000000011d707824ULL, 0x040fe400078e0270ULL, 0x000000105c5c7824ULL, 0x000fe400078e021fULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000011d727824ULL, 0x000fc400078e0272ULL,
0x000000105a5a7824ULL, 0x000fe400078e021fULL, 0x000000011d747824ULL, 0x040fe400078e0274ULL,
0x000000011d767824ULL, 0x040fe200078e0276ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000004f4e32723eULL, 0x004fe200000000ffULL, 0x000000011d787824ULL, 0x040fe400078e0278ULL,
0x000000011d5c7824ULL, 0x040fe400078e025cULL, 0x000000011d5a7824ULL, 0x000fc400078e025aULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x000000105e5e7824ULL, 0x100fe400078e021fULL,
0x000000107a7a7824ULL, 0x000fc800078e021fULL, 0x000000011d7a7824ULL, 0x000fe200078e027aULL,
0x00000038003d7308ULL, 0x0007e20000000800ULL, 0x000000363731723eULL, 0x002fe200000000ffULL,
0x000000013e377824ULL, 0x000fca00078e021dULL, 0x0000000837007388ULL, 0x000fe20000000800ULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x000000404138723eULL, 0x008fe400000000ffULL,
0x0000004c5933723eULL, 0x004fe200000000ffULL, 0x0000000a6e007388ULL, 0x000fe80000000800ULL,
0x000000343828723cULL, 0x080fe20000001828ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x0000002070007388ULL, 0x000fe80000000800ULL, 0x0000002272007388ULL, 0x000fe40000000800ULL,
0x000000343018723cULL, 0x020f620000001818ULL, 0x0000004b00507308ULL, 0x000ee20000000800ULL,
0x0000004d4a3c723eULL, 0x002fe200000000ffULL, 0x0000002c74007388ULL, 0x000fe80000000800ULL,
0x0000002e76007388ULL, 0x000fe40000000800ULL, 0x00000058003f7308ULL, 0x000fe20000000800ULL,
0x00000046493e723eULL, 0x004fe200000000ffULL, 0x0000003078007388ULL, 0x000fe80000000800ULL,
0x000000325c007388ULL, 0x000fe40000000800ULL, 0x0000005600567308ULL, 0x000e620000000800ULL,
0x0000003d503d723eULL, 0x008fe200000000ffULL, 0x000000095a007388ULL, 0x000fe20000000800ULL,
0x000000011d197824ULL, 0x020fc600078e025eULL, 0x0004000b6e007388ULL, 0x000fe80000000800ULL,
0x0004002170007388ULL, 0x000fe80000000800ULL, 0x0004002372007388ULL, 0x000fe20000000800ULL,
0x0000003f563f723eULL, 0x002fc600000000ffULL, 0x0004002d74007388ULL, 0x000fe80000000800ULL,
0x0004002f76007388ULL, 0x000fe20000000800ULL, 0x000000343c28723cULL, 0x000f660000001828ULL,
0x0004003178007388ULL, 0x000fe80000000800ULL, 0x000400335c007388ULL, 0x000fe80000000800ULL,
0x0000001419007388ULL, 0x0003e80000000800ULL, 0x000800166e007388ULL, 0x0005e80000000800ULL,
0x0008002470007388ULL, 0x0005e20000000800ULL, 0x000000ffff197224ULL, 0x002fc600078e001aULL,
0x0008002672007388ULL, 0x0005e20000000800ULL, 0x000000ffff1a7224ULL, 0x020fe400078e0028ULL,
0x000000ffff1b7224ULL, 0x000fe200078e002aULL, 0x0008003874007388ULL, 0x0005e80000000800ULL,
0x0008003a76007388ULL, 0x0005e80000000800ULL, 0x0008003c78007388ULL, 0x0005e80000000800ULL,
0x0008003e5c007388ULL, 0x0005e80000000800ULL, 0x000000157a007388ULL, 0x0005e80000000800ULL,
0x000c00176e007388ULL, 0x0005e80000000800ULL, 0x000c002570007388ULL, 0x0005e80000000800ULL,
0x000c002772007388ULL, 0x0005e80000000800ULL, 0x000c003974007388ULL, 0x0005e80000000800ULL,
0x000c003b76007388ULL, 0x0005e80000000800ULL, 0x000c003d78007388ULL, 0x0005e80000000800ULL,
0x000c003f5c007388ULL, 0x0005e80000000800ULL, 0x012000041c008388ULL, 0x0005e80000000c00ULL,
0x012200181c008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000069ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080069ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100069ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL, 0x0000180069ff7f8cULL, 0x0003e6000c80043fULL,
0x0000000c6a00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff971000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00016ed000267802ULL, 0x000fc40000000f00ULL,
0x0000108000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e0025ULL,
0xfffebe4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x00016f2000267802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xfffebea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016f7000257802ULL, 0x000fc40000000f00ULL,
0x00000f9000007944ULL, 0x014fea0003c00000ULL, 0xfffebf7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016fb000257802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x014fea0003c00000ULL, 0xfffec0a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016ff000257802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x014fea0003c00000ULL, 0xfffec1d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x0001703000257802ULL, 0x000fc40000000f00ULL,
0x00000ed000007944ULL, 0x014fea0003c00000ULL, 0xfffec2f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001708000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0017ULL, 0x00000e8000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffec6e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000170d000257802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001017277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001712000257802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffec69000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001717000257802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffec67000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x000171c000267802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffee85000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x0001721000267802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffee89000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001726000257802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x014fea0003c00000ULL,
0xfffee97000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000172a000257802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x014fea0003c00000ULL,
0xfffeeaa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000172e000257802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x014fea0003c00000ULL,
0xfffeebd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001732000257802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x014fea0003c00000ULL,
0xfffeecf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001737000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0029ULL,
0x00000b9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffef11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000173c000257802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001029277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001741000257802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffef0c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001746000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffef0a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x000174b000267802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xffff105000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x0001750000267802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0025ULL, 0xffff10a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x0001755000257802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x014fea0003c00000ULL, 0xffff118000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x0001759000257802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x014fea0003c00000ULL, 0xffff12b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x000175d000257802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x014fea0003c00000ULL, 0xffff13e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x0001761000257802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x014fea0003c00000ULL, 0xffff150000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001766000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0023ULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff192000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000176b000257802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001023277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001770000257802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff18d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001775000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff18b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe40004000000ULL,
0x000177a000267802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e0025ULL, 0xffff396000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x000177f000267802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0xffff39b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001784000257802ULL, 0x000fc40000000f00ULL, 0x000006c000007944ULL, 0x018fea0003c00000ULL,
0xffff3a8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001788000257802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x018fea0003c00000ULL,
0xffff3bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x000178c000257802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x018fea0003c00000ULL,
0xffff3ce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001790000257802ULL, 0x000fc40000000f00ULL, 0x0000060000007944ULL, 0x018fea0003c00000ULL,
0xffff3e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001795000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0003ULL,
0x000005b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff422000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x000179a000257802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001003277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x000179f000257802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xffff41d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00017a4000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xffff41b000007947ULL, 0x000fea000383ffffULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x00017a9000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdfe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e000aULL,
0x00017af000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x00017b5000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0015ULL, 0x00017bb000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b167208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0017ULL, 0x00017c1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000150b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00017c7000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000170b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x00017cd000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x00017d3000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffdeb000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe814002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000001900007348ULL, 0x000fe80003800000ULL,
0x0c000014070b7389ULL, 0x0002a200000e0018ULL, 0xfffe810008007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0x0000008600007348ULL, 0x000fe80003800000ULL,
0x00000000ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000002726267389ULL, 0x0002a600000e0087ULL,
0xfffe80b06c007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000008500007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000008525257212ULL, 0x000fe200078ec0ffULL,
0xfffe805026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000348ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000018080ULL, 0xe000001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019900ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019940ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000019cc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018278ULL,
0x0000000000018278ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019900ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000019cc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_86_cubin_len = 105888;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
