/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b9c0ULL, 0x000000000001b640ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000019a30ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000019bb0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000019bf0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000019c40ULL, 0x0000000000000140ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000019d80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00019a3000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x0064f80400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00019a3000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808708288080ULL,
0x8093082880808d08ULL, 0x0828808094082880ULL, 0x8080960828808095ULL, 0x9c08288080970828ULL,
0x288080a508288080ULL, 0x80ec08288080a708ULL, 0x08288080f0082880ULL, 0x8080f308288080f2ULL,
0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00019bb000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808d08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL,
0xa6082880809c0828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f2082880ULL,
0x8080a508288080f3ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b800000000ULL, 0x00019bf000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80ec288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808d08288080ULL, 0x8094082880809308ULL,
0x0828808095082880ULL, 0x8080970828808096ULL, 0xa5082880809c0828ULL, 0x288080a708288080ULL,
0x80f008288080ec08ULL, 0x08288080f2082880ULL, 0x8080a608288080f3ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028800000000ULL,
0x00019c4000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000e2ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000016ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000eb000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000170019c2804ULL, 0x000005a000000340ULL,
0x00002da000002d10ULL, 0x0000302000002eb0ULL, 0x000032f000003190ULL, 0x0000378000003740ULL,
0x000037c000003790ULL, 0x00005a80000059f0ULL, 0x00005d1000005ba0ULL, 0x00005fe000005e80ULL,
0x000064a000006460ULL, 0x000064e0000064b0ULL, 0x00008590000084f0ULL, 0x00008820000086b0ULL,
0x00008af000008990ULL, 0x00008fb000008f70ULL, 0x00008ff000008fc0ULL, 0x0000b1900000b0f0ULL,
0x0000b4100000b2a0ULL, 0x0000b6e00000b580ULL, 0x0000bba00000bb60ULL, 0x0000bbe00000bbb0ULL,
0x0000d0600000d050ULL, 0x0000d0800000d070ULL, 0x00017220000171e0ULL, 0x0001724000017230ULL,
0x000172b000017290ULL, 0x000172e0000172d0ULL, 0x000186a000018640ULL, 0x0001877000018710ULL,
0x00018830000187d0ULL, 0x00018910000188a0ULL, 0x000189f000018980ULL, 0x00018ab000018a50ULL,
0x00018b8000018b20ULL, 0x00018c4000018be0ULL, 0x00018d2000018cb0ULL, 0x00018e0000018d90ULL,
0x00018ec000018e60ULL, 0x00018f9000018f30ULL, 0x0001905000018ff0ULL, 0x00019130000190c0ULL,
0x00019210000191a0ULL, 0x000192d000019270ULL, 0x000193a000019340ULL, 0x0001946000019400ULL,
0x00019540000194d0ULL, 0x00019620000195b0ULL, 0x0001971000019690ULL, 0x0001981000019790ULL,
0x0001991000019890ULL, 0x00019a1000019990ULL, 0x0000043004403904ULL, 0x0001a600000000ffULL,
0x00000470003f0100ULL, 0x0001a6080000000fULL, 0x000004f0003f0120ULL, 0x0001a6880000000fULL,
0x00000510003f0120ULL, 0x0001a6a80000000fULL, 0x00000530003f0120ULL, 0x0001a6c80000000fULL,
0x00000ec0003f0120ULL, 0x0001a600000000ffULL, 0x000010c0003f0107ULL, 0x0000000400000002ULL,
0x00001170003f0102ULL, 0x0000000000000002ULL, 0x00001b80003f0101ULL, 0x00000000000000ffULL,
0x00001c0000040107ULL, 0x00000000000000ffULL, 0x00001c6000040101ULL, 0x0001a6c800000002ULL,
0x00001de0003f0101ULL, 0x0001a6cc00000019ULL, 0x00001fd0003f0105ULL, 0x0001a6cc00000019ULL,
0x00002910003f0105ULL, 0x0001a6b000000019ULL, 0x000029c0003f0107ULL, 0x0001a6b000000019ULL,
0x00002a20003f0101ULL, 0x0001a60800000003ULL, 0x00002a40003f0101ULL, 0x0001a60c00000003ULL,
0x00002c10003f0105ULL, 0x0001a60c00000003ULL, 0x000034a0003f0105ULL, 0x0001a6ac00000019ULL,
0x00003670003f0105ULL, 0x0001a6ac00000019ULL, 0x00004b70003f0105ULL, 0x000000000000006cULL,
0x00004bd0003f0101ULL, 0x0001a68800000025ULL, 0x00004c00003f0101ULL, 0x0000000400000004ULL,
0x00004dc0003f0105ULL, 0x0000000400000004ULL, 0x00005650003f0105ULL, 0x0001a6a8000000ffULL,
0x000056d000040107ULL, 0x0001a6a8000000ffULL, 0x0000573000040101ULL, 0x0001a62800000003ULL,
0x00005750003f0101ULL, 0x0001a62c00000003ULL, 0x00005920003f0105ULL, 0x0001a62c00000003ULL,
0x000061d0003f0105ULL, 0x0001a6b40000006cULL, 0x000063a0003f0105ULL, 0x0001a6b40000006cULL,
0x00007660003f0105ULL, 0x000000000000006eULL, 0x000076c0003f0101ULL, 0x0001a69000000026ULL,
0x000076f0003f0101ULL, 0x0000000400000004ULL, 0x000078b0003f0105ULL, 0x0000000400000004ULL,
0x00008100003f0105ULL, 0x0001a6b000000025ULL, 0x000081d0003f0107ULL, 0x0001a6b000000025ULL,
0x00008230003f0101ULL, 0x0001a64800000003ULL, 0x00008250003f0101ULL, 0x0001a64c00000003ULL,
0x00008420003f0105ULL, 0x0001a64c00000003ULL, 0x00008ce0003f0105ULL, 0x0001a6ac00000070ULL,
0x00008eb0003f0105ULL, 0x0001a6ac00000070ULL, 0x0000a190003f0105ULL, 0x0000000000000025ULL,
0x0000a1f0003f0101ULL, 0x0001a6980000001aULL, 0x0000a220003f0101ULL, 0x0000000400000025ULL,
0x0000a400003f0105ULL, 0x0000000400000025ULL, 0x0000ad50003f0105ULL, 0x0001a6a800000020ULL,
0x0000ade0003f0107ULL, 0x0001a6a800000020ULL, 0x0000ae40003f0101ULL, 0x0001a66800000005ULL,
0x0000ae70003f0101ULL, 0x0001a66c00000005ULL, 0x0000b040003f0105ULL, 0x0001a66c00000005ULL,
0x0000b8c0003f0105ULL, 0x0001a6b40000001fULL, 0x0000ba90003f0105ULL, 0x0001a6b40000001fULL,
0x0000ce00003f0105ULL, 0x0000000000000004ULL, 0x0000ce80003f0101ULL, 0x0000000000000002ULL,
0x0000f090003f0101ULL, 0x0001a600000000ffULL, 0x000109b0003f0101ULL, 0x0001a604000000ffULL,
0x00010bc0003f0105ULL, 0x0001a604000000ffULL, 0x00010f40003f0105ULL, 0x0001a600000000ffULL,
0x00010f70003f0101ULL, 0x0001a604000000ffULL, 0x00011130003f0105ULL, 0x0001a604000000ffULL,
0x000144d0003f0105ULL, 0x0000000000000067ULL, 0x00014560003f0101ULL, 0x0000000400000067ULL,
0x00014730003f0105ULL, 0x0000000400000067ULL, 0x00018480003f0105ULL, 0x0000000000000064ULL,
0x000184e0003f0101ULL, 0x0000000800000064ULL, 0x00018540003f0101ULL, 0x0000001000000064ULL,
0x000185b0003f0101ULL, 0x0000001800000064ULL, 0x00053803003f0101ULL, 0x0000df8000301c04ULL,
0x0000e2500000dfb0ULL, 0x0000e6300000e440ULL, 0x0000ea100000e820ULL, 0x0000ee000000ec00ULL,
0x000111900000efb0ULL, 0x0000040100018600ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000334ULL,
0x0000001900000002ULL, 0x0000000000000264ULL, 0x0000001900000002ULL, 0x00000000000001a4ULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000310ULL, 0x0000001900000002ULL, 0x0000000000000240ULL,
0x0000001900000002ULL, 0x000000000000017dULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606130981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff167624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00005a00ff157624ULL, 0x000fc600078e00ffULL,
0x0000000000147919ULL, 0x000e620000002300ULL, 0x0000590015157a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff117819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff11117589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x008fc800078e0a05ULL,
0x0000040003007624ULL, 0x000fca00078e0216ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000307077227ULL, 0x000fe400078e0006ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000001007127227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x0000000005007224ULL, 0x000fca00078e0210ULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x0000010014037a24ULL, 0x002fe400078e0203ULL,
0x00001fff14147589ULL, 0x000e6400000e0000ULL, 0x00000000030f7a24ULL, 0x000fd000078e020aULL,
0x0000000100005824ULL, 0x000fe200078e0a05ULL, 0x0000000112125810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000050000720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000030f00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0f00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000112126810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x00000005ff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01a60006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a12ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x01a608080f009388ULL, 0x000fe20000008a00ULL,
0x0000000005107224ULL, 0x000fc400078e0210ULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x0000002010107824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff0ea424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x01a688060f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x01a6a80a0f00d388ULL, 0x000fe80000008a00ULL,
0x01a4000e0f00a388ULL, 0x000fe80000004800ULL, 0x01a6c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000113130824ULL, 0x004fe400078e0a02ULL, 0x00005800ff138624ULL, 0x000fc400078e00ffULL,
0x0000580004028a24ULL, 0x000fe400078e02ffULL, 0x00005a0013037a24ULL, 0x000fe400078e02ffULL,
0x00000015027b7224ULL, 0x000fe400078e02ffULL, 0x0000000103007824ULL, 0x040fe200078e0a10ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000100300720cULL, 0x000fe20003f26070ULL,
0x00005a00120e7a24ULL, 0x000fe200078e027bULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff007a7207ULL, 0x000fe20000800000ULL, 0x0000000414007824ULL, 0x002fc600078e0211ULL,
0x000000207a00780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x00000000000f7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc8000001160fULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe03077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x00000001100c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07037227ULL, 0x000fc800078e0006ULL, 0x0000000110067824ULL, 0x000fe400078e020aULL,
0x0000000c030d7227ULL, 0x000fc800078e00ffULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a07ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x00005a0003037a24ULL, 0x000fe400078e0206ULL, 0x00005a0017087a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x000000007a037217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x040fe20004000000ULL, 0x000000100f037824ULL, 0x000fe200078e00ffULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000000500720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe200078e0a08ULL, 0x000000f003057812ULL, 0x000fe200078ec0ffULL,
0x00005a000d067a24ULL, 0x000fe400078e0206ULL, 0x00005a00170c7a24ULL, 0x000fe400078e020cULL,
0x000000010e067824ULL, 0x040fe400078e0206ULL, 0x000000010e0d7824ULL, 0x000fc400078e020cULL,
0x0000001507067224ULL, 0x080fe400078e0206ULL, 0x0000001508087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x000000010a007824ULL, 0x100fe200078e020fULL,
0x0000000508057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x0000600006067a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e020fULL,
0x0000600005087a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d007812ULL, 0x000fe400078ee200ULL, 0x0000610007077a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000610009097a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x00000000000f7919ULL, 0x000eae0000000000ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x000000000f007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe03067810ULL, 0x002fe20007ffe0ffULL,
0x0000000110037824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x0000000110077824ULL, 0x000fe400078e020aULL, 0x0000000308057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006067a24ULL, 0x000fe400078e0203ULL,
0x00005a000c097a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x0000000108082810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff067a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000000108083810ULL, 0x000fe40007ffe0ffULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000806087207ULL, 0x000fc60004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006037a24ULL, 0x000fe400078e0203ULL,
0x00005a000c077a24ULL, 0x000fe400078e0207ULL, 0x000000010e067824ULL, 0x040fe400078e0203ULL,
0x000000010e077824ULL, 0x000fc400078e0207ULL, 0x000000100f037824ULL, 0x000fe400078e00ffULL,
0x0000001505067224ULL, 0x080fe400078e0206ULL, 0x0000001508087224ULL, 0x000fe200078e0207ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fc600078efcffULL,
0x0000000100057824ULL, 0x100fe200078e020fULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a007824ULL, 0x000fe200078e020fULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x0000610007077a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00b007812ULL, 0x000fe200078ee200ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057300ULL, 0x000e7000000e0000ULL,
0x0000000000077309ULL, 0x000ea20000000000ULL, 0x000000060500720cULL, 0x002fe20003f02070ULL,
0x00000004ff057424ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0a07ULL,
0x0000680004067625ULL, 0x000fd000078e0005ULL, 0x01a60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000003f0e0d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0e007810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0c7819ULL, 0x000fca0000011600ULL,
0x0000dfb000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011611ULL,
0x00000003ff097424ULL, 0x000fe400078e00ffULL, 0xffffffffff137424ULL, 0x000fe200078e00ffULL,
0x03ffffff0b087812ULL, 0x002fc800078ec0ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000000204028824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0002078624ULL, 0x000fe200078e0207ULL, 0x0001a68811027811ULL, 0x000fc600078e18ffULL,
0x0000000108068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040902ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606138981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000004012097824ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011611ULL, 0x0000000002ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000111007812ULL, 0x000fc600078ec0ffULL, 0x000000200a847824ULL, 0x000fe400078e00ffULL,
0x0000590013147a24ULL, 0x004fc600078e02ffULL, 0x0000002009137812ULL, 0x000fe200078ef884ULL,
0x0000004014217824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x102fe2000001160fULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x000000840e077217ULL, 0x000fe40007800000ULL, 0x0000000402157810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0202ULL, 0x00006400211b7a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe400078e0a84ULL, 0x0000000106147824ULL, 0x040fe200078e020fULL,
0x0000650021217a11ULL, 0x000fe200020f3cffULL, 0x0000000806177824ULL, 0x000fe200078e00ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x0000000113067824ULL, 0x000fc600078e0206ULL,
0xfffffff8171a7812ULL, 0x000fe200078ee214ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000000802147810ULL, 0x040fe40007ffe0ffULL, 0x0000000c02177810ULL, 0x040fe40007ffe0ffULL,
0x000000070200720cULL, 0x080fe20003f66070ULL, 0x0000000100167824ULL, 0x000fe200078e0214ULL,
0x000000071400720cULL, 0x080fe20003f26070ULL, 0x0000000100027824ULL, 0x000fe200078e0215ULL,
0x000000071500720cULL, 0x080fe20003f46070ULL, 0x0000000116147824ULL, 0x040fe200078e020fULL,
0x000000071700720cULL, 0x000fe20003f06070ULL, 0x0000000816197824ULL, 0x000fc400078e00ffULL,
0x0000000100187824ULL, 0x000fe400078e0217ULL, 0x0000000102007824ULL, 0x040fe200078e020fULL,
0xfffffff8191c7812ULL, 0x000fe200078ee214ULL, 0x0000000802157824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff815007812ULL, 0x000fe200078ee200ULL,
0x0000000113147824ULL, 0x040fe200078e0202ULL, 0x0000007006067812ULL, 0x000fe200078ef803ULL,
0x0000000113167824ULL, 0x040fe400078e0216ULL, 0x0000000113197824ULL, 0x000fe200078e0218ULL,
0x000000061b067210ULL, 0x000fe20007f9e0ffULL, 0x0000000118027824ULL, 0x040fe400078e020fULL,
0x0000000818137824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee202ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014027812ULL, 0x000fc600078ef803ULL, 0x0000008019187825ULL, 0x000fe200078e00ffULL,
0x0000007016147812ULL, 0x000fc600078ef803ULL, 0x0000000107077824ULL, 0x000fe200020e0621ULL,
0x0000007018167812ULL, 0x000fe400078ef803ULL, 0x000160000a037811ULL, 0x000fe400078e68ffULL,
0x0000001b02027210ULL, 0x080fe40007f9e0ffULL, 0x0000001b14147210ULL, 0x080fe20007fbe0ffULL,
0x000000101a137824ULL, 0x100fe200078e0203ULL, 0x0000001b16167210ULL, 0x000fe20007fde0ffULL,
0x00000010001b7824ULL, 0x000fc400078e0203ULL, 0x000000101c1d7824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e2000d901c46ULL,
0x000000101e1f7824ULL, 0x000fe400078e0203ULL, 0x0000000115037824ULL, 0x100fe400020e0621ULL,
0x0000000117157824ULL, 0x100fe400028e0621ULL, 0x0000000119177824ULL, 0x000fe200030e0621ULL,
0x00000000021b7faeULL, 0x0003e8000d101c46ULL, 0x00000000141d7faeULL, 0x0003e8000c901c46ULL,
0x00000000161f7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x002fe200078e00ffULL, 0x00006400211d7a11ULL, 0x000fc400078038ffULL,
0x000160000a1f7811ULL, 0x000fe400078e68ffULL, 0x000000000f007211ULL, 0x000fe400078fe8ffULL,
0x0000650021217a11ULL, 0x000fe400000f3cffULL, 0x0000000800167810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x040fe200078e020fULL, 0x0000000400147810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x00000008161c7824ULL, 0x000fc400078e00ffULL,
0x0000000113067824ULL, 0x000fe200078e0200ULL, 0xfffffff8071a7812ULL, 0x000fe200078ee202ULL,
0x0000000116077824ULL, 0x100fe200078e020fULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000114027824ULL, 0x040fe400078e020fULL, 0x00000008141b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL, 0x0000000113147824ULL, 0x040fe200078e0214ULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x0000000113167824ULL, 0x040fe400078e0216ULL,
0x0000000113187824ULL, 0x000fe200078e0200ULL, 0x000000061d067210ULL, 0x000fe20007f1e0ffULL,
0x0000000100027824ULL, 0x040fe400078e020fULL, 0x0000000800137824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff813007812ULL, 0x000fe200078ee202ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007014027812ULL, 0x000fc600078ef803ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016147812ULL, 0x000fc600078ef803ULL,
0x0000000107077824ULL, 0x000fe200000e0621ULL, 0x0000007018037812ULL, 0x000fe200078ef803ULL,
0x000000101a137824ULL, 0x100fe200078e021fULL, 0x000000021d027210ULL, 0x000fe20007f1e0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021fULL, 0x000000141d147210ULL, 0x040fe40007f3e0ffULL,
0x000000031d167210ULL, 0x000fe20007f5e0ffULL, 0x0000000115037824ULL, 0x000fe200000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e2000b901c46ULL,
0x000000101c1d7824ULL, 0x000fc400078e021fULL, 0x0000000117157824ULL, 0x000fe200008e0621ULL,
0x00000000021b7faeULL, 0x0003e2000b901c46ULL, 0x00000010001f7824ULL, 0x000fe400078e021fULL,
0x0000000119177824ULL, 0x000fe200010e0621ULL, 0x00000000141d7faeULL, 0x0003e8000b901c46ULL,
0x00000000161f7faeULL, 0x0003e4000b901c46ULL, 0x0000000108087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006a00ff037624ULL, 0x002fc800078e00ffULL, 0x00006a0000037624ULL, 0x000fc800078e0203ULL,
0x0000000103227824ULL, 0x000fc800078e0208ULL, 0x0000660022227625ULL, 0x000fcc00078e0005ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000000080a027824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff187f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6c80002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000b1b000008947ULL, 0x000fea0003800000ULL, 0x0000000204077824ULL, 0x000fe200078e00ffULL,
0x000000010a797812ULL, 0x000fe200078ec0ffULL, 0x00006a00ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x00006a0007077624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x004fca00078e0008ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0000000411047824ULL, 0x000fca00078e00ffULL, 0xfffffff804197812ULL, 0x000fca00078ec0ffULL,
0x01a6cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x0001a6c819047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c021c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1b7819ULL, 0x000fc8000001141dULL,
0x0000001c1b1b7211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x000000021b1b7819ULL, 0x000fc8000000121cULL, 0x0000001b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc00191c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011027824ULL, 0x000fe200078e00ffULL,
0x0000000106177810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe002037812ULL, 0x000fe200078ec0ffULL, 0x0000004022277824ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x000fc60003f26070ULL, 0x0000010006037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fc80007ffe0ffULL, 0x00000020191c7812ULL, 0x000fca00078ec0ffULL,
0x0000000109217824ULL, 0x000fe200078e021cULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x000000190e027217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe4000001160fULL,
0x000000701d297812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a19ULL,
0x000000041b1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b1c7824ULL, 0x000fe200078e0203ULL,
0x0000640027257a11ULL, 0x000fc400078a38ffULL, 0x0000000302027217ULL, 0x000fe20007800000ULL,
0x000000011c177824ULL, 0x040fe200078e020fULL, 0x0000650027277a11ULL, 0x000fe200028f3cffULL,
0x000000081c207824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a03ULL,
0xfffffff820177812ULL, 0x000fe400078ee217ULL, 0x000000081b207810ULL, 0x040fe40007ffe0ffULL,
0x000000021b00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c1b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000021e00720cULL, 0x0c0fe20003f66070ULL, 0x000000011e1e7824ULL, 0x100fe200078e0203ULL,
0x000000022000720cULL, 0x0c0fe20003f46070ULL, 0x0000000120207824ULL, 0x100fe200078e0203ULL,
0x000000021b00720cULL, 0x040fe20003f06070ULL, 0x000000011b227824ULL, 0x000fc400078e0203ULL,
0x000000011e037824ULL, 0x040fe400078e020fULL, 0x000000081e267824ULL, 0x000fe400078e00ffULL,
0x0000000121027824ULL, 0x040fe400078e021cULL, 0x00000001211c7824ULL, 0x000fe200078e021eULL,
0xfffffff826197812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002902027212ULL, 0x000fc600078efcffULL,
0x00000001201b7824ULL, 0x040fe200078e020fULL, 0x0000000225027210ULL, 0x000fe20007fbe0ffULL,
0x0000000820287824ULL, 0x000fe200078e00ffULL, 0x000000291c1c7212ULL, 0x000fe200078efcffULL,
0x00000001211e7824ULL, 0x040fe400078e0220ULL, 0x0000000121207824ULL, 0x000fe200078e0222ULL,
0xfffffff8281b7812ULL, 0x000fe200078ee21bULL, 0x0000000122237824ULL, 0x000fe400078e020fULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000291e1e7212ULL, 0x000fe200078efcffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff822237812ULL, 0x000fe200078ee223ULL, 0x0000000103037824ULL, 0x100fe200028e0627ULL,
0x000000251c1c7210ULL, 0x000fe40007fbe0ffULL, 0x0000002920207212ULL, 0x000fe400078efcffULL,
0x000170000a227811ULL, 0x000fe200078e68ffULL, 0x000000011d1d7824ULL, 0x000fe200028e0627ULL,
0x000000251e1e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002520207210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fc400078e0222ULL, 0x0000001019197824ULL, 0x100fe400078e0222ULL,
0x000000101b1b7824ULL, 0x100fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000e101c46ULL, 0x000000011f1f7824ULL, 0x100fe400028e0627ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x000000001c197faeULL, 0x0003e2000d901c46ULL,
0x0000000121217824ULL, 0x000fc600030e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000d101c46ULL,
0x0000000020237faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001002027812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x0000640027257a11ULL, 0x000fe400078038ffULL, 0x000000020f027211ULL, 0x000fe400078fe8ffULL,
0x000000701d237812ULL, 0x000fc400078ec0ffULL, 0x00000008021e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x140fe200078e020fULL, 0x00000004021c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000802207824ULL, 0x000fe200078e00ffULL, 0x0000650027277a11ULL, 0x000fe200000f3cffULL,
0x000000011e1b7824ULL, 0x100fe200078e020fULL, 0x000170000a267811ULL, 0x000fe200078e68ffULL,
0x000000011c197824ULL, 0x000fe200078e020fULL, 0xfffffff820177812ULL, 0x000fe200078ee203ULL,
0x000000081e207824ULL, 0x000fe400078e00ffULL, 0x0000000121037824ULL, 0x000fc400078e0202ULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0xfffffff8201b7812ULL, 0x000fe200078ee21bULL,
0x00000001211c7824ULL, 0x000fe200078e021cULL, 0x0000000c02207810ULL, 0x000fe20007ffe0ffULL,
0x0000008003027825ULL, 0x000fe200078e00ffULL, 0xfffffff822197812ULL, 0x000fc600078ee219ULL,
0x00000001211e7824ULL, 0x040fe200078e021eULL, 0x0000002302027212ULL, 0x000fe200078efcffULL,
0x0000000121217824ULL, 0x000fe400078e0220ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000225027210ULL, 0x000fc60007f1e0ffULL, 0x0000000120227824ULL, 0x000fe200078e020fULL,
0x000000231c1c7212ULL, 0x000fe200078efcffULL, 0x0000000820297824ULL, 0x000fe400078e00ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000008021207825ULL, 0x000fe200078e00ffULL, 0x000000231e1e7212ULL, 0x000fc600078efcffULL,
0x0000000103037824ULL, 0x100fe200000e0627ULL, 0x0000002320207212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x100fe200078e0226ULL, 0x0000001c251c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001019197824ULL, 0x100fe200078e0226ULL, 0x0000001e251e7210ULL, 0x000fe20007f5e0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0226ULL, 0x0000002025207210ULL, 0x000fe20007f7e0ffULL,
0x000000011d1d7824ULL, 0x100fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc400010e0627ULL,
0x0000001022237824ULL, 0x000fe200078e0226ULL, 0x000000001c197faeULL, 0x0003e2000b901c46ULL,
0x0000000121217824ULL, 0x000fc600018e0627ULL, 0x000000001e1b7faeULL, 0x0003e8000b901c46ULL,
0x0000000020237faeULL, 0x0003e4000b901c46ULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0x00000001081c7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028197812ULL, 0x000fe400078ec0ffULL, 0x0000000d1c00720cULL, 0x000fe40003f06070ULL,
0x00000000190473c2ULL, 0x000e6200000e0000ULL, 0x0000001028027812ULL, 0x040fe400078ec0ffULL,
0xffffffe028037812ULL, 0x040fe400078ec0ffULL, 0x0000000828177812ULL, 0x000fcc00078ec0ffULL,
0x00000001071c8824ULL, 0x000fe400078e021cULL, 0x00000004ff1d8424ULL, 0x000fe200078e00ffULL,
0x0000000317037210ULL, 0x000fe40007ffe002ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066001c1c8625ULL, 0x000fca00078e001dULL, 0x000000061c228981ULL, 0x000522000c1e1900ULL,
0x0001a6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b000196e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080003207f8cULL, 0x000664000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x01a60c0003177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c177210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e1dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001141eULL,
0x0000001702027211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e061eULL,
0x0000000202027819ULL, 0x000fc80000001217ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0003177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100f027824ULL, 0x000fe200078e00ffULL, 0x00000001ff787819ULL, 0x000fe2000001160fULL,
0x0000002011177824ULL, 0x000fc600078e00ffULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0xffffff8017177812ULL, 0x000fe400078ec0ffULL, 0x0000000c78787812ULL, 0x000fc800078ec0ffULL,
0x0000001778177210ULL, 0x000fca0007ffe002ULL, 0x01a00000171b7984ULL, 0x000e680000000800ULL,
0x01a20000171d7984ULL, 0x0006a20000000800ULL, 0x0000001a1b00720bULL, 0x002fe20003f1d000ULL,
0x000159027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x008fc800000e0100ULL,
0x000000ff1700720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e001aULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000110b00720cULL, 0x000fe40003f05270ULL,
0x0000001a1b00720bULL, 0x000fe20003f54000ULL, 0x000158d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x000fc400010e0100ULL, 0x00000080111f8824ULL, 0x000fe200078e0202ULL,
0x0000001a1b237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000178208824ULL, 0x000fca00078e021fULL, 0x01a4002320008388ULL, 0x0003e20000000800ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001a231a7221ULL, 0x002fe20000010100ULL, 0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL,
0x0000001a001a7308ULL, 0x000e640000000800ULL, 0x0000001a24247220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x000158227f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x0000002644447220ULL, 0x080fe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x000157127f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x000fc40000410000ULL, 0x0000002646467220ULL, 0x080fe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x000156027f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x000fc40000410000ULL,
0x0000002664647220ULL, 0x080fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002668687220ULL, 0x080fe40000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x000155027f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x000fc40000410000ULL,
0x0000002666667220ULL, 0x080fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x000000266a6a7220ULL, 0x080fe40000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001c17ff7212ULL, 0x000fda00078030ffULL,
0x800000231b1b0221ULL, 0x000fe20000010000ULL, 0x00007610ff1e0816ULL, 0x000fc6000000001eULL,
0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL, 0x0000001b00000308ULL, 0x000e640000000800ULL,
0x000000001d1d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000241d247221ULL, 0x004fc40000010000ULL, 0x00000000001a7805ULL, 0x000fca0000015200ULL,
0x01a6ac0019177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001141dULL,
0x0000001c17177211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000217177819ULL, 0x000fc8000000121cULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0019177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101e177816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff1700720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff177819ULL, 0x000fe4000001160fULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x000151127f007947ULL, 0x000fea000b800000ULL,
0x00001f1716137589ULL, 0x0002a400000e0000ULL, 0x0000000817277810ULL, 0x000fe20007ffe0ffULL,
0x000151627f007947ULL, 0x000fea000b800000ULL, 0x0000001017157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x00066a00000e0000ULL, 0x00001f1516157589ULL, 0x0006a400000e0000ULL,
0x0000001817277810ULL, 0x008fe20007ffe0ffULL, 0x000151f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000211257824ULL, 0x000fe200078e00ffULL, 0x000000080f187812ULL, 0x000fe200078ec0ffULL,
0x0000000411207824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000400111b7824ULL, 0x000fe200078e00ffULL, 0x00000004251e7812ULL, 0x000fe200078ec0ffULL,
0x00001000111c7824ULL, 0x000fe200078e00ffULL, 0x0000000718177812ULL, 0x000fe200078ef80fULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x0000001e0f1a7211ULL, 0x000fc400078fe0ffULL,
0x0000000420207812ULL, 0x000fe200078ec0ffULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117187824ULL, 0x000fe200078e021aULL,
0x000000200f207211ULL, 0x000fe200078fe0ffULL, 0x0000000817277824ULL, 0x002fe200078e00ffULL,
0x000120001b217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819187812ULL, 0x000fe400078ee218ULL,
0x0000001017197812ULL, 0x000fc400078efcffULL, 0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001171c7824ULL, 0x000fe400078e0220ULL, 0x000000011a1a7824ULL, 0x000fe200078e0219ULL,
0x000160001d1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8271b7812ULL, 0x000fe200078ee21cULL, 0x0000001018747824ULL, 0x000fc600078e0221ULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL, 0x000000101b807824ULL, 0x000fe400078e021dULL,
0x000000007474783bULL, 0x000e640000000200ULL, 0x000000101a707824ULL, 0x000fcc00078e0221ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001374747232ULL, 0x086fe40000000000ULL, 0x0000001376767232ULL, 0x000fe40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fc40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000008080783bULL, 0x000ee20000004200ULL,
0x000000021e1e7812ULL, 0x000fe200078efcffULL, 0x000008e000007945ULL, 0x000fe20003800000ULL,
0xfffffff81f1c7812ULL, 0x000fe400078ee21cULL, 0x0000001e0f1e7211ULL, 0x000fc600078fe0ffULL,
0x000000101c7c7824ULL, 0x000fcc00078e021dULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000018ff1f7819ULL, 0x008fe40000011481ULL, 0x00000018ff1d7819ULL, 0x000fe40000011480ULL,
0x0000001f006d7306ULL, 0x0007e20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011483ULL,
0x00000018ff267819ULL, 0x000fca0000011482ULL, 0x0000001d002a7306ULL, 0x0003e20000200c00ULL,
0x00000100801f7824ULL, 0x008fe200078e00ffULL, 0x00000018ff297819ULL, 0x004fe2000001147cULL,
0x000001007d8d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001147dULL,
0x000001007e917824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001147eULL,
0x000001007f937824ULL, 0x000fe200078e00ffULL, 0x00000029008b7306ULL, 0x0005e20000200c00ULL,
0x00008880801d7816ULL, 0x042fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc4000001147fULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000002b008f7306ULL, 0x0003e20000200c00ULL,
0x0000010081297824ULL, 0x004fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff917819ULL, 0x000fe40000011491ULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x0000006c00947306ULL, 0x000fe20000200c00ULL, 0x00000018ff2b7819ULL, 0x002fce0000011429ULL,
0x0000002b006c7306ULL, 0x0003f00000200c00ULL, 0x00000027008a7306ULL, 0x0005e20000200c00ULL,
0x00008880832b7816ULL, 0x002fce00000000ffULL, 0x0000002b00897306ULL, 0x0003e20000200c00ULL,
0x0000888081277816ULL, 0x044fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002600877306ULL, 0x000fe20000200c00ULL,
0x000001007c2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000008500967306ULL, 0x0003f00000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x0000010082857824ULL, 0x002fca00078e00ffULL, 0x00000018ff857819ULL, 0x000fe40000011485ULL,
0x0000001f00267306ULL, 0x0002b00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x00008880821f7816ULL, 0x042fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000002b008c7306ULL, 0x0003e20000200c00ULL,
0x000054101d267816ULL, 0x004fce0000000026ULL, 0x0000008000297306ULL, 0x0004a20000200c00ULL,
0x000088807e2b7816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x0000541027277816ULL, 0x008fc8000000006cULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008100867306ULL, 0x0003e20000200c00ULL, 0x0000010083807824ULL, 0x044fe200078e00ffULL,
0x00000026742c723cULL, 0x000f62000000182cULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008d008e7306ULL, 0x0005e20000200c00ULL,
0x000088807c817816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x00000026704c723cULL, 0x000b62000000184cULL,
0x00005410292a7816ULL, 0x000fe4000000002aULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000008500887306ULL, 0x0003e20000200c00ULL, 0x000088807f8d7816ULL, 0x044fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fc400078e00ffULL, 0x0000000119267824ULL, 0x060fe400078e0220ULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000007e001d7306ULL, 0x000ea20000200c00ULL, 0x000088807d857816ULL, 0x042fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff827207812ULL, 0x000fc800078ee226ULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000001f001f7306ULL, 0x000e700000200c00ULL,
0x0000008d00957306ULL, 0x000fe20000200c00ULL, 0x000054101d947816ULL, 0x004fe20000000094ULL,
0x00000001171d7824ULL, 0x000fc400078e021eULL, 0x00000001191e7824ULL, 0x000fc800078e021eULL,
0x00000093006c7306ULL, 0x000ea20000200c00ULL, 0x000054101f887816ULL, 0x002fe20000000088ULL,
0x00000008191f7824ULL, 0x000fca00078e00ffULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000160000a1f7811ULL, 0x000fce00078e68ffULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x0000541095937816ULL, 0x004fce000000006cULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541089897816ULL, 0x002fe20000000080ULL,
0x0000001020807824ULL, 0x000fcc00078e021fULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541082827816ULL, 0x008fe20000000087ULL, 0x000000887434723cULL, 0x080f6c0000001834ULL,
0x0000008500857306ULL, 0x000ee20000200c00ULL, 0x0000541083837816ULL, 0x004fe2000000008aULL,
0x000000887054723cULL, 0x000f6c0000001854ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00005410818c7816ULL, 0x002fe2000000008cULL, 0x000000827438723cULL, 0x080f6c0000001838ULL,
0x0000007d00907306ULL, 0x000e620000200c00ULL, 0x00005410858d7816ULL, 0x008fe2000000008eULL,
0x000000827058723cULL, 0x000f6c0000001858ULL, 0x0000002b00927306ULL, 0x0007e20000200c00ULL,
0x000054107c7c7816ULL, 0x004fe2000000008bULL, 0x0000008c743c723cULL, 0x080f6c000000183cULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x00005410862b7816ULL, 0x008fe2000000006dULL,
0x0000008c705c723cULL, 0x000f62000000185cULL, 0x00005410907d7816ULL, 0x002fca000000008fULL,
0x0000007f007f7306ULL, 0x000e640000200c00ULL, 0x0000002a7430723cULL, 0x000f620000001830ULL,
0x0000541092927816ULL, 0x004fce0000000091ULL, 0x0000002a7050723cULL, 0x000b620000001850ULL,
0x000054107f957816ULL, 0x002fcc0000000096ULL, 0x00000008172a7824ULL, 0x020fe200078e00ffULL,
0x0000007c7440723cULL, 0x000f680000001840ULL, 0xfffffff82a1d7812ULL, 0x000fc800078ee21dULL,
0x000000927444723cULL, 0x040f700000001844ULL, 0x000000947448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0221ULL, 0x0000007c7060723cULL, 0x000f620000001860ULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000927064723cULL, 0x040f700000001864ULL, 0x000000947068723cULL, 0x000b640000001868ULL,
0x000000002170783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008192a7824ULL, 0x000fe200078e00ffULL, 0x0000000226217810ULL, 0x004fe20007ffe0ffULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff82a217812ULL, 0x000fca00078ee221ULL, 0x00000010217c7824ULL, 0x000fcc00078e021fULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff267819ULL, 0x004fe40000011480ULL,
0x00000018ff277819ULL, 0x000fe40000011481ULL, 0x00000026002a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff297819ULL, 0x000fe40000011482ULL, 0x00000018ff2b7819ULL, 0x000fe40000011483ULL,
0x00008880838a7816ULL, 0x000fc600000000ffULL, 0x00000027006d7306ULL, 0x0003e20000200c00ULL,
0x0000888080267816ULL, 0x004fe200000000ffULL, 0x000001007c8d7824ULL, 0x008fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001147fULL, 0x000001007d907824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001147cULL, 0x000001007e937824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001147eULL, 0x0000008700977306ULL, 0x0005e20000200c00ULL,
0x0000010080277824ULL, 0x042fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe2000001147dULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001148dULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002900897306ULL, 0x0003e20000200c00ULL,
0x0000010082877824ULL, 0x004fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x000088807d8f7816ULL, 0x000fe400000000ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000002b008b7306ULL, 0x0005e20000200c00ULL, 0x0000010081297824ULL, 0x002fe200078e00ffULL,
0x000088807f957816ULL, 0x000fc400000000ffULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x0000006c008e7306ULL, 0x0003e20000200c00ULL,
0x00008880812b7816ULL, 0x044fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000008700887306ULL, 0x0005e20000200c00ULL,
0x00000018ff6c7819ULL, 0x002fce0000011429ULL, 0x0000008000297306ULL, 0x0002e20000200c00ULL,
0x000088807c877816ULL, 0x044fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x0000010083807824ULL, 0x042fe400078e00ffULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000002700277306ULL, 0x000e620000200c00ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x008fca000000002aULL,
0x0000008600967306ULL, 0x000ff00000200c00ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000541026267816ULL, 0x002fce0000000027ULL, 0x0000006c006c7306ULL, 0x000e700000200c00ULL,
0x0000008100867306ULL, 0x000eb00000200c00ULL, 0x00000083008c7306ULL, 0x0007e20000200c00ULL,
0x000054102b277816ULL, 0x002fce000000006cULL, 0x0000008500917306ULL, 0x0003e20000200c00ULL,
0x000100007d837824ULL, 0x008fe200078e00ffULL, 0x00005410862b7816ULL, 0x004fe2000000006dULL,
0x00000026742c723cULL, 0x040f66000000182cULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000008000817306ULL, 0x000fe20000200c00ULL, 0x0000888082857816ULL, 0x042fe200000000ffULL,
0x0001000082827824ULL, 0x000fe200078e00ffULL, 0x0000002a7430723cULL, 0x000f680000001830ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000007c007d7306ULL, 0x0002a60000200c00ULL,
0x00000026704c723cULL, 0x000f6a000000184cULL, 0x0000008d00807306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x002fc400078e00ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x0000002a7050723cULL, 0x000f640000001850ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000088807e8d7816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x000054107d8e7816ULL, 0x004fc8000000008eULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008f008f7306ULL, 0x000ff00000200c00ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054108a6d7816ULL, 0x002fce0000000081ULL, 0x0000008200827306ULL, 0x000e700000200c00ULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000054108f817816ULL, 0x004fce0000000090ULL,
0x0000008300927306ULL, 0x0004e20000200c00ULL, 0x0000541082827816ULL, 0x002fce0000000089ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054108c837816ULL, 0x004fe4000000008bULL,
0x0000541087807816ULL, 0x008fca0000000080ULL, 0x0000009300947306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x000fe20000000091ULL, 0x000000827438723cULL, 0x040f6c0000001838ULL,
0x0000009500957306ULL, 0x000fe40000200c00ULL, 0x00000080743c723cULL, 0x040f6c000000183cULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000054108d947816ULL, 0x002fe20000000094ULL,
0x0000008e7440723cULL, 0x000f6c0000001840ULL, 0x0000007e00297306ULL, 0x000e640000200c00ULL,
0x000000827058723cULL, 0x040f6c0000001858ULL, 0x0000007f00867306ULL, 0x000ee20000200c00ULL,
0x0000541095957816ULL, 0x004fe2000000007cULL, 0x00000080705c723cULL, 0x000f62000000185cULL,
0x0000541029967816ULL, 0x002fca0000000096ULL, 0x0000008500857306ULL, 0x000e640000200c00ULL,
0x000000947444723cULL, 0x000f620000001844ULL, 0x0000541086977816ULL, 0x008fce0000000097ULL,
0x0000008e7060723cULL, 0x000f620000001860ULL, 0x00005410856c7816ULL, 0x002fce0000000088ULL,
0x000000967448723cULL, 0x000f700000001848ULL, 0x000000947064723cULL, 0x040f700000001864ULL,
0x000000967068723cULL, 0x000f700000001868ULL, 0x0000006c7434723cULL, 0x080f700000001834ULL,
0x0000006c7054723cULL, 0x000b6e0000001854ULL, 0x0001a6c80a6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff297224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x000fc80000015200ULL,
0x0000040004257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e27ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fca00078e00ffULL,
0xffffffe026257812ULL, 0x000fca00078ec0ffULL, 0x0000010006257824ULL, 0x000fca00078e0225ULL,
0x0000008025277810ULL, 0x000fe20007ffe0ffULL, 0x0000590022257a24ULL, 0x010fc600078e02ffULL,
0x0000002027227812ULL, 0x000fe200078ec0ffULL, 0x0000004025297824ULL, 0x000fc800078e00ffULL,
0x0000000109707824ULL, 0x000fe200078e0222ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000270e227217ULL, 0x000fe40007800000ULL, 0x0000001026257812ULL, 0x000fe400078ec0ffULL,
0x00000003ff267819ULL, 0x000fe2000001160fULL, 0x0000000122227824ULL, 0x000fc600078e0a27ULL,
0x00000004262b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000126277824ULL, 0x040fe200078e0225ULL,
0x0000002225227217ULL, 0x000fe40007800000ULL, 0x00000008266c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001272a7824ULL, 0x040fe400078e020fULL, 0x00000008276d7824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x000fc600078e0a25ULL, 0xfffffff86d727812ULL, 0x000fe200078ee22aULL,
0x000000012b2a7824ULL, 0x100fe200078e0225ULL, 0x0000000c266d7810ULL, 0x040fe40007ffe0ffULL,
0x000000222600720cULL, 0x080fe20003f86070ULL, 0x0000000127267824ULL, 0x000fe200078e0270ULL,
0x000000226c00720cULL, 0x0c0fe20003f46070ULL, 0x000000016c6c7824ULL, 0x100fe200078e0225ULL,
0x000000222b00720cULL, 0x080fe20003f66070ULL, 0x000000016d737824ULL, 0x040fe200078e0225ULL,
0x000000226d00720cULL, 0x000fe20003f06070ULL, 0x000000012a257824ULL, 0x000fc400078e020fULL,
0x000000082a747824ULL, 0x000fe400078e00ffULL, 0x000000016c2b7824ULL, 0x040fe400078e020fULL,
0x000000086c767824ULL, 0x000fe200078e00ffULL, 0xfffffff874227812ULL, 0x000fe200078ee225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640029257a11ULL, 0x040fe400078a38ffULL,
0xfffffff876747812ULL, 0x000fe200078ee22bULL, 0x000000012a2a7824ULL, 0x100fe200078e0270ULL,
0x0000000226267212ULL, 0x000fe200078efcffULL, 0x000000016c6c7824ULL, 0x000fe200078e0270ULL,
0x0000650029297a11ULL, 0x000fe200028f3cffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002625267210ULL, 0x000fc60007fbe0ffULL, 0x0000000173707824ULL, 0x000fe200078e0270ULL,
0x000000022a2a7212ULL, 0x000fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fc800078e00ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000026c6c7212ULL, 0x000fc600078efcffULL,
0x0000000127277824ULL, 0x000fe200028e0629ULL, 0x000000252a2a7210ULL, 0x080fe20007fbe0ffULL,
0x0000000173757824ULL, 0x040fe200078e020fULL, 0x0000000270707212ULL, 0x000fe200078efcffULL,
0x0000000873767824ULL, 0x000fe400078e00ffULL, 0x000000012b2b7824ULL, 0x000fe200028e0629ULL,
0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL, 0x0000001074737824ULL, 0x100fe200078e021fULL,
0x0000002570707210ULL, 0x000fe20007fde0ffULL, 0x0000001072257824ULL, 0x000fe200078e021fULL,
0xfffffff876767812ULL, 0x000fe200078ee275ULL, 0x000000016d6d7824ULL, 0x000fc400028e0629ULL,
0x0000000171717824ULL, 0x000fe200030e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000e101c46ULL, 0x0000001022297824ULL, 0x100fe400078e021fULL,
0x0000001076757824ULL, 0x000fc600078e021fULL, 0x000000002a297faeULL, 0x0003e8000d901c46ULL,
0x000000006c737faeULL, 0x0003e8000d101c46ULL, 0x0000000070757faeULL, 0x0003e2000c101c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001026267812ULL, 0x000fc800078ec0ffULL,
0x000000260f227211ULL, 0x000fc800078fe8ffULL, 0x0000000422277810ULL, 0x040fe20007ffe0ffULL,
0x0000000122257824ULL, 0x040fe200078e020fULL, 0x0000000c226d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000822727824ULL, 0x040fe400078e00ffULL, 0x0000000122267824ULL, 0x100fe400078e0270ULL,
0x00000001272a7824ULL, 0x000fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000086d767824ULL, 0x000fe200078e00ffULL, 0x0000000822257810ULL, 0x000fe20007ffe0ffULL,
0x0000000127227824ULL, 0x000fc400078e020fULL, 0x0000000827277824ULL, 0x000fe400078e00ffULL,
0x00000001256c7824ULL, 0x040fe400078e0270ULL, 0x00000001252b7824ULL, 0x100fe200078e020fULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x0000000825747824ULL, 0x000fe400078e00ffULL,
0x000000016d257824ULL, 0x000fe400078e020fULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fc400078ee22bULL, 0xfffffff876767812ULL, 0x000fe200078ee225ULL,
0x000000016d707824ULL, 0x000fe200078e0270ULL, 0x0000640029257a11ULL, 0x040fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000226267212ULL, 0x000fe400078efcffULL,
0x0000650029297a11ULL, 0x000fe200000f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002625267210ULL, 0x000fe40007f1e0ffULL, 0x000000022a2a7212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000026c6c7212ULL, 0x000fc400078efcffULL,
0x0000002a252a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200000e0629ULL,
0x0000000270707212ULL, 0x000fe200078efcffULL, 0x0000001074737824ULL, 0x000fe200078e021fULL,
0x0000006c256c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012b2b7824ULL, 0x000fe200010e0629ULL,
0x0000007025707210ULL, 0x000fe20007f7e0ffULL, 0x0000001072257824ULL, 0x000fe400078e021fULL,
0x000000016d6d7824ULL, 0x100fe400000e0629ULL, 0x0000000171717824ULL, 0x000fe200018e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c46ULL,
0x0000001022297824ULL, 0x000fc400078e021fULL, 0x0000001076757824ULL, 0x000fc600078e021fULL,
0x000000002a297faeULL, 0x0003e8000b901c46ULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x0000000070757faeULL, 0x0003e4000b901c46ULL, 0x00000000280473c2ULL, 0x000ea200000e0000ULL,
0x0000000208267810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0x0000000d2600720cULL, 0x000fda0003f06070ULL, 0x0000000107268824ULL, 0x000fe400078e0226ULL,
0x00000004ff278424ULL, 0x000fe200078e00ffULL, 0xfffffff004047892ULL, 0x004fc6000f8ec03fULL,
0x0000660026268625ULL, 0x000fe200078e0027ULL, 0x0001a6a804057890ULL, 0x000fc8000fffe03fULL,
0x0000000626228981ULL, 0x000328000c1e1900ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6a800ff2a7f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800036c7f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x002fc40000015200ULL, 0x01a62c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002011257824ULL, 0x000fca00078e00ffULL,
0xffffff8025257812ULL, 0x000fc800078ec0ffULL, 0x0000008002257810ULL, 0x000fca0007ffe025ULL,
0x0000000178257824ULL, 0x000fca00078e0225ULL, 0x01a0000025287984ULL, 0x000e680000000800ULL,
0x01a2000025297984ULL, 0x0006a20000000800ULL, 0x000000232800720bULL, 0x002fe20003f1d000ULL,
0x000130327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000707806ULL, 0x008fc800000e0100ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000010b267810ULL, 0x000fe40007ffe0ffULL, 0x000000232800720bULL, 0x000fe40003f54000ULL,
0x000000112600720cULL, 0x000fe20003f05270ULL, 0x000130027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000737806ULL, 0x000fc400010e0100ULL, 0x0000008011278824ULL, 0x000fe200078e0202ULL,
0x0000002328258209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000178268824ULL, 0x000fca00078e0227ULL, 0x01a4002526008388ULL, 0x0003e20000000800ULL,
0x000000ff7300720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002328267209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff73ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002326257221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500757308ULL, 0x000e640000000800ULL,
0x0000007524247220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x00012f427f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x0000002644447220ULL, 0x080fe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x00012e327f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x000fc40000410000ULL,
0x0000002646467220ULL, 0x080fe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x00012d227f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x000fc40000410000ULL, 0x0000002664647220ULL, 0x080fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002668687220ULL, 0x080fe40000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000073ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x00012c227f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x000fc40000410000ULL, 0x0000002666667220ULL, 0x080fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x000000266a6a7220ULL, 0x080fe40000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007370ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fe200078e00ffULL,
0x0000002328237209ULL, 0x000fd60007810000ULL, 0x8000002328280221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL,
0x0000002800000308ULL, 0x000e640000000800ULL, 0x0000000029290220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002429247221ULL, 0x004fc40000010000ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000000811287824ULL, 0x000fca00078e00ffULL,
0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028266d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09006d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000006d28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff297819ULL, 0x000fe4000001160fULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x000128027f007947ULL, 0x000fea000b800000ULL,
0x00001f2916137589ULL, 0x0002a400000e0000ULL, 0x0000000829277810ULL, 0x000fe20007ffe0ffULL,
0x000128527f007947ULL, 0x000fea000b800000ULL, 0x0000001029157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x00066a00000e0000ULL, 0x00001f1516157589ULL, 0x0006a400000e0000ULL,
0x0000001829277810ULL, 0x008fe20007ffe0ffULL, 0x000128e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0022e400000e0000ULL, 0x0000040011257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100011267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0001300025257810ULL, 0x000fe40007ffe0ffULL,
0x0001700026267810ULL, 0x000fc60007ffe0ffULL, 0x0000001018707824ULL, 0x100fe400078e0225ULL,
0x000000101a6c7824ULL, 0x000fe400078e0225ULL, 0x000000101b7c7824ULL, 0x000fe400078e0226ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x086fe40000000000ULL,
0x0000001372727232ULL, 0x000fc40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fe40000000000ULL, 0x000000156c6c7232ULL, 0x088fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101c747824ULL, 0x000fe200078e0226ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007474783bULL, 0x000ea20000004200ULL,
0x00000018ff267819ULL, 0x008fc4000001147cULL, 0x00000018ff277819ULL, 0x002fe4000001147dULL,
0x00000018ff297819ULL, 0x000fe2000001147eULL, 0x0000002600287306ULL, 0x0003e20000200c00ULL,
0x00000018ff807819ULL, 0x000fe2000001147fULL, 0x00000100748b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011476ULL, 0x00000100758d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011474ULL, 0x0000010076927824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011477ULL, 0x0000002700827306ULL, 0x0005e20000200c00ULL,
0x000088807c267816ULL, 0x002fc400000000ffULL, 0x00000018ff837819ULL, 0x000fe40000011475ULL,
0x00008880758e7816ULL, 0x040fe200000000ffULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000002900877306ULL, 0x0003e20000200c00ULL,
0x000001007c277824ULL, 0x044fe200078e00ffULL, 0x000088807f887816ULL, 0x000fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000080008a7306ULL, 0x0005e20000200c00ULL,
0x000001007d297824ULL, 0x042fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000018ff8f7819ULL, 0x000fe4000001148dULL, 0x0000888076917816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x0000008500947306ULL, 0x0003e20000200c00ULL,
0x000088807d807816ULL, 0x044fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x0000888077937816ULL, 0x000fe400000000ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x00000081008c7306ULL, 0x0005e20000200c00ULL,
0x000001007e857824ULL, 0x002fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc80000011476ULL,
0x00000018ff857819ULL, 0x000fe40000011485ULL, 0x0000008600957306ULL, 0x000fe20000200c00ULL,
0x00000018ff817819ULL, 0x004fce0000011429ULL, 0x0000007c00297306ULL, 0x0002b00000200c00ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x000001007f7c7824ULL, 0x042fe400078e00ffULL,
0x000100007f7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000008500867306ULL, 0x0003e20000200c00ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000541029287816ULL, 0x004fca0000000028ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x0000888074857816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x000054107d297816ULL, 0x008fc80000000082ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000002700277306ULL, 0x000e640000200c00ULL, 0x000000287030723cULL, 0x080f6c0000001830ULL,
0x0000008000807306ULL, 0x000fe40000200c00ULL, 0x000000286c50723cULL, 0x000b6c0000001850ULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000541026267816ULL, 0x002fc40000000027ULL,
0x000010001f287810ULL, 0x020fca0007ffe0ffULL, 0x0000008300907306ULL, 0x0003e20000200c00ULL,
0x0000001020297824ULL, 0x000fce00078e0228ULL, 0x0000007c00897306ULL, 0x000fe20000200c00ULL,
0x000088807e837816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x0000541080277816ULL, 0x004fc80000000081ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008b007c7306ULL, 0x000fe40000200c00ULL, 0x00000026702c723cULL, 0x080f6c000000182cULL,
0x00000074008d7306ULL, 0x0002a40000200c00ULL, 0x000000266c4c723cULL, 0x000f6c000000184cULL,
0x00000075008b7306ULL, 0x0006a20000200c00ULL, 0x0000010077747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0001000077757824ULL, 0x008fe200078e00ffULL, 0x000054108d8c7816ULL, 0x004fc8000000008cULL,
0x00000018ff7d7819ULL, 0x000fe40000011475ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000054108b8d7816ULL, 0x000fce0000000090ULL, 0x0000007e007e7306ULL, 0x000ea20000200c00ULL,
0x0000008c7040723cULL, 0x080f6e0000001840ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x0000541088757816ULL, 0x002fe20000000089ULL, 0x0000008c6c60723cULL, 0x000f6c0000001860ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000054107e7e7816ULL, 0x004fce0000000087ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000054107f7f7816ULL, 0x008fce000000008aULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x00005410857c7816ULL, 0x002fe2000000007cULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000009100917306ULL, 0x000fe40000200c00ULL,
0x0000007e6c58723cULL, 0x000f6c0000001858ULL, 0x0000009200927306ULL, 0x000e700000200c00ULL,
0x0000009300937306ULL, 0x000ff00000200c00ULL, 0x0000007400807306ULL, 0x0004e20000200c00ULL,
0x0000541091927816ULL, 0x002fce0000000092ULL, 0x0000007600777306ULL, 0x000e620000200c00ULL,
0x0000541083747816ULL, 0x004fce0000000086ULL, 0x0000007d00827306ULL, 0x0004a20000200c00ULL,
0x0000541093937816ULL, 0x008fe20000000080ULL, 0x000000747034723cULL, 0x000f620000001834ULL,
0x0000541077947816ULL, 0x002fe40000000094ULL, 0x000054108e7d7816ULL, 0x004fca000000008fULL,
0x000000927044723cULL, 0x000f620000001844ULL, 0x0000541082957816ULL, 0x000fce0000000095ULL,
0x0000007c703c723cULL, 0x040f70000000183cULL, 0x000000947048723cULL, 0x000b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000746c54723cULL, 0x000f620000001854ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007c6c5c723cULL, 0x040f70000000185cULL, 0x000000926c64723cULL, 0x040f700000001864ULL,
0x000000946c68723cULL, 0x000b640000001868ULL, 0x00000000256c783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001370707232ULL, 0x082fe40000000000ULL, 0x0000001372727232ULL, 0x000fc40000000000ULL,
0x0000001471717232ULL, 0x080fe40000000000ULL, 0x0000001473737232ULL, 0x000fe40000000000ULL,
0x000000156c6c7232ULL, 0x088fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001021747824ULL, 0x000fe200078e0228ULL,
0x00000000297c783bULL, 0x000eaa0000004200ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000018ff257819ULL, 0x004fe2000001147cULL, 0x000001007e887824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fc4000001147dULL, 0x0000002500807306ULL, 0x0005e20000200c00ULL,
0x00000018ff837819ULL, 0x008fe20000011475ULL, 0x00000100748b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001147fULL, 0x00000100758f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe2000001147eULL, 0x0000010076937824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011476ULL, 0x0000002600857306ULL, 0x0007e20000200c00ULL,
0x000088807c257816ULL, 0x004fe400000000ffULL, 0x00000018ff827819ULL, 0x000fc40000011474ULL,
0x00000018ff877819ULL, 0x000fe40000011477ULL, 0x00000018ff907819ULL, 0x000fe2000001148fULL,
0x0000008300917306ULL, 0x0005e20000200c00ULL, 0x000001007c267824ULL, 0x048fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00008880758d7816ULL, 0x040fe200000000ffULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000081008a7306ULL, 0x0007e20000200c00ULL,
0x000100007d837824ULL, 0x004fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x0000888077957816ULL, 0x000fe400000000ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000002700897306ULL, 0x0005e20000200c00ULL, 0x000001007d817824ULL, 0x008fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff817819ULL, 0x000fc40000011481ULL, 0x0000008600967306ULL, 0x000fe20000200c00ULL,
0x000088807d277816ULL, 0x004fe400000000ffULL, 0x00000018ff937819ULL, 0x000fca0000011493ULL,
0x0000007c007d7306ULL, 0x0005f00000200c00ULL, 0x0000008300867306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000082008e7306ULL, 0x000fe20000200c00ULL, 0x0000888074837816ULL, 0x048fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000008100827306ULL, 0x0005f00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x000088807f817816ULL, 0x044fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002500257306ULL, 0x000ff00000200c00ULL,
0x0000002600267306ULL, 0x000ea20000200c00ULL, 0x0000541027277816ULL, 0x008fce0000000082ULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541025267816ULL, 0x004fce0000000026ULL, 0x00000074008f7306ULL, 0x0004e20000200c00ULL,
0x00000026702c723cULL, 0x082f6e000000182cULL, 0x0000008700977306ULL, 0x0003e20000200c00ULL,
0x0000010077747824ULL, 0x044fe200078e00ffULL, 0x000000266c4c723cULL, 0x000b62000000184cULL,
0x0001000077777824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000008b008c7306ULL, 0x0005e20000200c00ULL, 0x000088807e877816ULL, 0x042fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x000054108f8e7816ULL, 0x008fc8000000008eULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000007400827306ULL, 0x0003e20000200c00ULL,
0x00008880768b7816ULL, 0x044fe200000000ffULL, 0x0001000076767824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000054107d747816ULL, 0x002fe40000000080ULL, 0x00000018ff7d7819ULL, 0x000fe40000011477ULL,
0x0000541081777816ULL, 0x000fc6000000007cULL, 0x0000008800887306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000eb00000200c00ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x000054107e7e7816ULL, 0x002fce0000000089ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054107f7f7816ULL, 0x004fce000000008aULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x00005410838c7816ULL, 0x008fe2000000008cULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000007500927306ULL, 0x0004e40000200c00ULL,
0x0000007e6c58723cULL, 0x000f6c0000001858ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541086757816ULL, 0x004fc40000000085ULL, 0x000054108d8d7816ULL, 0x002fca0000000090ULL,
0x0000009300947306ULL, 0x000e620000200c00ULL, 0x00005410928f7816ULL, 0x008fe20000000091ULL,
0x000000747030723cULL, 0x040f6c0000001830ULL, 0x0000009500957306ULL, 0x000ea40000200c00ULL,
0x0000008c703c723cULL, 0x040f6c000000183cULL, 0x0000007600257306ULL, 0x0006a20000200c00ULL,
0x000054108b947816ULL, 0x002fe20000000094ULL, 0x0000008e7040723cULL, 0x000f6c0000001840ULL,
0x0000007d007c7306ULL, 0x000e620000200c00ULL, 0x0000541087767816ULL, 0x008fe20000000088ULL,
0x000000746c50723cULL, 0x000f620000001850ULL, 0x0000541095957816ULL, 0x004fc40000000082ULL,
0x0000541025967816ULL, 0x000fe20000000096ULL, 0x0000000211257824ULL, 0x000fc800078e00ffULL,
0x000000767034723cULL, 0x000f640000001834ULL, 0xfffffff825267812ULL, 0x020fe400078ec0ffULL,
0x000054107c977816ULL, 0x002fc80000000097ULL, 0x000000947044723cULL, 0x040f700000001844ULL,
0x000000967048723cULL, 0x000f700000001848ULL, 0x000000766c54723cULL, 0x040f700000001854ULL,
0x0000008c6c5c723cULL, 0x040f70000000185cULL, 0x0000008e6c60723cULL, 0x040f700000001860ULL,
0x000000946c64723cULL, 0x040f700000001864ULL, 0x000000966c68723cULL, 0x000b6e0000001868ULL,
0x0001a6c80a6e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x00000400046d7984ULL, 0x000ea40000000800ULL,
0x800000006dff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c26717210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff6c7819ULL, 0x000fc8000001146dULL,
0x000000716c6c7211ULL, 0x000fca00078110ffULL, 0x000000ffff6d7224ULL, 0x000fca00000e066dULL,
0x000000026c6c7819ULL, 0x000fc8000000126dULL, 0x0000006c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400046d7984ULL, 0x000e640000000800ULL,
0x800000006dff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010006257824ULL, 0x000fca00078e0225ULL, 0x000000c025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590022257a24ULL, 0x010fc600078e02ffULL, 0x0000002027227812ULL, 0x000fe200078ec0ffULL,
0x0000004025737824ULL, 0x000fc800078e00ffULL, 0x0000000109707824ULL, 0x000fe200078e0222ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000270e227217ULL, 0x000fe40007800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x00000003ff267819ULL, 0x000fe2000001160fULL,
0x0000000122227824ULL, 0x000fc600078e0a27ULL, 0x00000004266d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e0225ULL, 0x0000002225227217ULL, 0x000fe40007800000ULL,
0x00000008266e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001276c7824ULL, 0x040fe200078e020fULL,
0x0000000c266f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827757824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x100fe400078e0a25ULL, 0x000000016f727824ULL, 0x100fe200078e0225ULL,
0xfffffff875757812ULL, 0x000fe200078ee26cULL, 0x000000016d6c7824ULL, 0x100fe200078e0225ULL,
0x000000222600720cULL, 0x080fe20003f86070ULL, 0x0000000127267824ULL, 0x000fe200078e0270ULL,
0x000000226e00720cULL, 0x0c0fe20003f46070ULL, 0x000000016e6e7824ULL, 0x000fe200078e0225ULL,
0x000000226d00720cULL, 0x080fe20003f66070ULL, 0x000000016c257824ULL, 0x040fe200078e020fULL,
0x000000226f00720cULL, 0x000fe20003f06070ULL, 0x000000086c747824ULL, 0x000fc400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff874777812ULL, 0x000fe200078ee225ULL,
0x000000016c6c7824ULL, 0x000fe200078e0270ULL, 0x0000640073257a11ULL, 0x040fe200078a38ffULL,
0x000000016e227824ULL, 0x000fe200078e020fULL, 0x0000000226267212ULL, 0x000fe200078efcffULL,
0x000000086e7d7824ULL, 0x000fe200078e00ffULL, 0x0000650073737a11ULL, 0x000fe200028f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fe40007fbe0ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee222ULL, 0x000000016e6e7824ULL, 0x100fe200078e0270ULL,
0x000000026c6c7212ULL, 0x000fe200078efcffULL, 0x0000000172707824ULL, 0x000fc400078e0270ULL,
0x000000806e6e7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e6e7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0673ULL,
0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL, 0x0000000172227824ULL, 0x000fe200078e020fULL,
0x0000000270707212ULL, 0x000fe200078efcffULL, 0x00000008727f7824ULL, 0x000fe400078e00ffULL,
0x000000016d6d7824ULL, 0x100fe200028e0673ULL, 0x000000256e6e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002570707210ULL, 0x000fe20007fde0ffULL, 0x0000001075257824ULL, 0x000fe200078e0228ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x000000016f6f7824ULL, 0x000fc400028e0673ULL,
0x0000000171717824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000e101c46ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107d757824ULL, 0x100fe400078e0228ULL, 0x000000107f777824ULL, 0x000fe200078e0228ULL,
0x000000006c737faeULL, 0x0003e8000d901c46ULL, 0x000000006e757faeULL, 0x0003e8000d101c46ULL,
0x0000000070777faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fe400078ec0ffULL, 0x0000640073757a11ULL, 0x000fc400078038ffULL,
0x000000260f227211ULL, 0x000fe400078fe8ffULL, 0x0000650073737a11ULL, 0x000fe400000f3cffULL,
0x0000000422277810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x140fe200078e020fULL,
0x00000008226d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008226c7824ULL, 0x040fe200078e00ffULL,
0x0000000c22717810ULL, 0x040fe20007ffe0ffULL, 0x0000000122267824ULL, 0x100fe400078e0270ULL,
0x0000000127227824ULL, 0x040fe200078e020fULL, 0xfffffff86c257812ULL, 0x000fe200078ee225ULL,
0x00000001276c7824ULL, 0x000fc400078e0270ULL, 0x0000000827777824ULL, 0x000fe400078e00ffULL,
0x000000016d6e7824ULL, 0x040fe400078e0270ULL, 0x000000016d6f7824ULL, 0x100fe200078e020fULL,
0xfffffff877777812ULL, 0x000fe200078ee222ULL, 0x000000086d727824ULL, 0x000fe400078e00ffULL,
0x00000001716d7824ULL, 0x040fe400078e020fULL, 0x0000000871747824ULL, 0x000fe200078e00ffULL,
0xfffffff8727d7812ULL, 0x000fe200078ee26fULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff8747f7812ULL, 0x000fe200078ee26dULL, 0x0000000171707824ULL, 0x000fe200078e0270ULL,
0x0000000226267212ULL, 0x000fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0x0000002675267210ULL, 0x000fe20007f1e0ffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x000000026c6c7212ULL, 0x000fc600078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e6e7212ULL, 0x000fe400078efcffULL, 0x0000006c756c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0673ULL, 0x0000000270707212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x100fe200078e0228ULL, 0x0000006e756e7210ULL, 0x000fe20007f1e0ffULL,
0x000000016d6d7824ULL, 0x100fe200010e0673ULL, 0x0000007075707210ULL, 0x000fe20007f7e0ffULL,
0x000000107d757824ULL, 0x000fe200078e0228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c46ULL, 0x000000016f6f7824ULL, 0x000fc400000e0673ULL,
0x0000000171717824ULL, 0x000fe400018e0673ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107f777824ULL, 0x000fc600078e0228ULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x000000006e757faeULL, 0x0003e8000b901c46ULL, 0x0000000070777faeULL, 0x0003e4000b901c46ULL,
0x0000000811257824ULL, 0x002fe200078e00ffULL, 0x0000000308267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x0000000d2600720cULL, 0x000fe40003f06070ULL, 0x00000000250473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000107268824ULL, 0x000fc400078e0226ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000660026268625ULL, 0x000fca00078e0027ULL,
0x0000000626228981ULL, 0x000522000c1e1900ULL, 0x0001a6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x01a6b000256e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480003707f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01a64c0003257984ULL, 0x002e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146dULL, 0x0000006c25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000225257819ULL, 0x000fc8000000126cULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002011037824ULL, 0x008fca00078e00ffULL,
0xffffff8003037812ULL, 0x000fc800078ec0ffULL, 0x0000010002037810ULL, 0x000fca0007ffe003ULL,
0x0000000178037824ULL, 0x000fca00078e0203ULL, 0x01a0000003707984ULL, 0x000e680000000800ULL,
0x01a2000003737984ULL, 0x0006a20000000800ULL, 0x000000237000720bULL, 0x002fe20003f1d000ULL,
0x000109427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000078000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fd200078e0023ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000020b267810ULL, 0x000fe40007ffe0ffULL,
0x000000237000720bULL, 0x000fe40003f54000ULL, 0x000000112600720cULL, 0x000fe20003f05270ULL,
0x000109027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000037806ULL, 0x000fc400010e0100ULL,
0x0000008011278824ULL, 0x000fe200078e0202ULL, 0x0000002370258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000178268824ULL, 0x000fca00078e0227ULL,
0x01a4002526008388ULL, 0x0003e20000000800ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002370267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff03ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500757308ULL, 0x000e640000000800ULL, 0x0000007524247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x000108427f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x0000002644447220ULL, 0x080fe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0003ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x000107327f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x000fc40000410000ULL, 0x0000002646467220ULL, 0x080fe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000003ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x000106227f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x000fc40000410000ULL,
0x0000002664647220ULL, 0x080fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002668687220ULL, 0x080fe40000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000003ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x000105227f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x000fc40000410000ULL,
0x0000002666667220ULL, 0x080fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x000000266a6a7220ULL, 0x080fe40000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002370037209ULL, 0x000fd60007810000ULL,
0x8000000370700221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL, 0x0000007000000308ULL, 0x000e640000000800ULL,
0x0000000073730220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002473247221ULL, 0x004fc40000010000ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0000000811237824ULL, 0x000fca00078e00ffULL, 0xfffffff023707812ULL, 0x000fca00078ec0ffULL,
0x01a6ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001146dULL,
0x0000006c23237211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000223237819ULL, 0x000fc8000000126cULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025237816ULL, 0x000fc800000000ffULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000101027f007947ULL, 0x000fea000b800000ULL, 0x00001f2316137589ULL, 0x0002a400000e0000ULL,
0x0000000823277810ULL, 0x000fe20007ffe0ffULL, 0x000101527f007947ULL, 0x000fea000b800000ULL,
0x0000001023157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x00066a00000e0000ULL,
0x00001f1516157589ULL, 0x0006a400000e0000ULL, 0x0000001823277810ULL, 0x008fe20007ffe0ffULL,
0x000101e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0022e400000e0000ULL,
0x0000040011237824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100011257824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00023237812ULL, 0x000fc400078ec0ffULL, 0xffffe00025257812ULL, 0x000fe400078ec0ffULL,
0x0001400023237810ULL, 0x000fe40007ffe0ffULL, 0x0001600025257810ULL, 0x000fc60007ffe0ffULL,
0x0000001018187824ULL, 0x100fe400078e0223ULL, 0x000000101a1a7824ULL, 0x000fe400078e0223ULL,
0x000000101b807824ULL, 0x000fe200078e0225ULL, 0x000000001874783bULL, 0x0002e80000000200ULL,
0x000000001a70783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001374747232ULL, 0x08cfe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x080fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101c7c7824ULL, 0x000fe200078e0225ULL,
0x000000008080783bULL, 0x000e620000004200ULL, 0x0000082000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff187819ULL, 0x002fc40000011480ULL,
0x00000018ff1a7819ULL, 0x000fe40000011481ULL, 0x00000018ff1c7819ULL, 0x000fe20000011482ULL,
0x00000018002a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff267819ULL, 0x008fe2000001147cULL,
0x000001007d8c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001147dULL,
0x000100007d8d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001147eULL,
0x000001007e8f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011483ULL,
0x00000026008a7306ULL, 0x0007e20000200c00ULL, 0x0000888080187816ULL, 0x002fc400000000ffULL,
0x000088807c897816ULL, 0x000fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001147fULL,
0x000088807d8b7816ULL, 0x000fe200000000ffULL, 0x0000001a006c7306ULL, 0x0003e20000200c00ULL,
0x0000010081267824ULL, 0x008fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000001c00857306ULL, 0x0007e20000200c00ULL, 0x00000100801a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0001000080807824ULL, 0x000fc600078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000027008e7306ULL, 0x000fe20000200c00ULL,
0x00008880811c7816ULL, 0x048fe200000000ffULL, 0x0001000081817824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc80000011480ULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000002600277306ULL, 0x0002f00000200c00ULL,
0x0000002b00927306ULL, 0x000fe20000200c00ULL, 0x0000888083267816ULL, 0x002fce00000000ffULL,
0x00000080002b7306ULL, 0x0002a20000200c00ULL, 0x000054101c277816ULL, 0x008fe20000000027ULL,
0x000001007f1c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000002500887306ULL, 0x000fe20000200c00ULL, 0x0000010083807824ULL, 0x042fe400078e00ffULL,
0x0001000083837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000002600867306ULL, 0x0003e20000200c00ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x000054102b2a7816ULL, 0x004fca000000002aULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000001007c267824ULL, 0x042fe400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000001a00257306ULL, 0x0002a20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fce000001147cULL, 0x0000008000877306ULL, 0x000fe20000200c00ULL,
0x00008880821a7816ULL, 0x002fce00000000ffULL, 0x0000006d00947306ULL, 0x0003f00000200c00ULL,
0x0000002600807306ULL, 0x0007e20000200c00ULL, 0x00000100826d7824ULL, 0x042fe400078e00ffULL,
0x0001000082827824ULL, 0x000fc600078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000007c007d7306ULL, 0x0002a20000200c00ULL, 0x000088807e267816ULL, 0x048fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc80000011482ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000002600907306ULL, 0x0005e20000200c00ULL,
0x000088807f7c7816ULL, 0x042fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541018267816ULL, 0x004fe20000000025ULL, 0x000000ffff187224ULL, 0x000fe200078e007cULL,
0x000054107d8a7816ULL, 0x000fca000000008aULL, 0x0000001a001a7306ULL, 0x000fe20000200c00ULL,
0x00000026742c723cULL, 0x080f6e000000182cULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x00005410812b7816ULL, 0x002fe2000000006cULL, 0x00000026704c723cULL, 0x000f6c000000184cULL,
0x0000008b008b7306ULL, 0x000fe40000200c00ULL, 0x0000002a7430723cULL, 0x080f6c0000001830ULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000054101a6c7816ULL, 0x004fe2000000006dULL,
0x0000002a7050723cULL, 0x000f620000001850ULL, 0x00005410866d7816ULL, 0x000fca0000000087ULL,
0x0000007e00937306ULL, 0x000ea40000200c00ULL, 0x0000006c7434723cULL, 0x080f6c0000001834ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x000054108b817816ULL, 0x002fe2000000008cULL,
0x0000006c7054723cULL, 0x000f6c0000001854ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x0000541093927816ULL, 0x004fce0000000092ULL, 0x0000008900897306ULL, 0x000ea20000200c00ULL,
0x0000541082827816ULL, 0x008fce0000000085ULL, 0x0000008d008d7306ULL, 0x000ee20000200c00ULL,
0x0000541083837816ULL, 0x002fce0000000088ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x0000541089807816ULL, 0x004fe20000000080ULL, 0x000000827438723cULL, 0x040f6c0000001838ULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x000054108d8b7816ULL, 0x008fe2000000008eULL,
0x00000080743c723cULL, 0x040f6c000000183cULL, 0x0000001c00917306ULL, 0x000ea20000200c00ULL,
0x0000541090907816ULL, 0x002fe2000000008fULL, 0x0000008a7440723cULL, 0x000f6c0000001840ULL,
0x0000007f007f7306ULL, 0x000e640000200c00ULL, 0x000000827058723cULL, 0x000f620000001858ULL,
0x0000541018917816ULL, 0x004fce0000000091ULL, 0x00000080705c723cULL, 0x000b62000000185cULL,
0x000054107f937816ULL, 0x002fcc0000000094ULL, 0x0000001020807824ULL, 0x020fe200078e021fULL,
0x000000907444723cULL, 0x040f700000001844ULL, 0x000000927448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x0000008a7060723cULL, 0x000f620000001860ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000907064723cULL, 0x040f700000001864ULL, 0x000000927068723cULL, 0x000b640000001868ULL,
0x000000002370783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e021fULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff207819ULL, 0x004fe20000011483ULL,
0x00000100822b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe20000011481ULL,
0x00000100836d7824ULL, 0x000fe200078e00ffULL, 0x0000002000867306ULL, 0x0005e20000200c00ULL,
0x00000018ff187819ULL, 0x000fe40000011480ULL, 0x00000018ff257819ULL, 0x008fe2000001147eULL,
0x000001007e8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc40000011482ULL,
0x00000018ff217819ULL, 0x000fe2000001147cULL, 0x0000001a00277306ULL, 0x0007e20000200c00ULL,
0x0000010081207824ULL, 0x004fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001147fULL,
0x00000018ff237819ULL, 0x000fe4000001147dULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000001800267306ULL, 0x0005e20000200c00ULL, 0x00000100801a7824ULL, 0x008fe200078e00ffULL,
0x000088807d897816ULL, 0x000fc400000000ffULL, 0x000088807f8d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001c006c7306ULL, 0x0007e20000200c00ULL,
0x0000888080187816ULL, 0x044fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000025008e7306ULL, 0x000fe20000200c00ULL,
0x00008880811c7816ULL, 0x048fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002000257306ULL, 0x0005f00000200c00ULL,
0x0000002100877306ULL, 0x000fe20000200c00ULL, 0x0000888083207816ULL, 0x044fe200000000ffULL,
0x0001000083837824ULL, 0x000fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000001800187306ULL, 0x000ff00000200c00ULL, 0x0000001a00217306ULL, 0x000eb00000200c00ULL,
0x0000002000857306ULL, 0x0007f00000200c00ULL, 0x0000001c001c7306ULL, 0x000e620000200c00ULL,
0x000001007c207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002a00907306ULL, 0x0007f00000200c00ULL, 0x0000002000887306ULL, 0x0003e20000200c00ULL,
0x00008880822a7816ULL, 0x048fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x00000023008a7306ULL, 0x000fe20000200c00ULL,
0x000088807e207816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008000237306ULL, 0x0002f00000200c00ULL,
0x00000020008c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff807819ULL, 0x002fce000001146dULL,
0x00000081001a7306ULL, 0x0002620000200c00ULL, 0x0000541018207816ULL, 0x004fe20000000021ULL,
0x000000ffff187224ULL, 0x000fe200078e008dULL, 0x000054101c217816ULL, 0x000fe20000000025ULL,
0x000001007f1c7824ULL, 0x000fe200078e00ffULL, 0x0000541023267816ULL, 0x008fe20000000026ULL,
0x000100007f7f7824ULL, 0x000fe200078e00ffULL, 0x0001a6c80a257811ULL, 0x000fe200078e18ffULL,
0x00000082006d7306ULL, 0x0004e20000200c00ULL, 0x000088807c817816ULL, 0x042fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x00000020742c723cULL, 0x000b62000000182cULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x000001007d827824ULL, 0x044fe200078e00ffULL, 0x000054101a277816ULL, 0x000fe20000000027ULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00000020704c723cULL, 0x000b64000000184cULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000002b002b7306ULL, 0x000e620000200c00ULL, 0x000054106d6c7816ULL, 0x008fc4000000006cULL,
0x000000267430723cULL, 0x080b6a0000001830ULL, 0x0000007e008f7306ULL, 0x000ea60000200c00ULL,
0x000000267050723cULL, 0x000b6a0000001850ULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x000054102a2a7816ULL, 0x002fce000000002bULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x000054108f8e7816ULL, 0x004fce000000008eULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00005410852b7816ULL, 0x008fce0000000080ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00005410836d7816ULL, 0x002fe20000000086ULL, 0x0000002a7434723cULL, 0x040b6c0000001834ULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541081887816ULL, 0x004fe20000000088ULL,
0x0000006c7438723cULL, 0x000b6c0000001838ULL, 0x0000007c007c7306ULL, 0x000ea40000200c00ULL,
0x0000002a7054723cULL, 0x040b6c0000001854ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541089897816ULL, 0x002fe20000000082ULL, 0x0000006c7058723cULL, 0x000b6c0000001858ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000054107c7c7816ULL, 0x004fe20000000087ULL,
0x00000088743c723cULL, 0x080b6c000000183cULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000054107d7d7816ULL, 0x008fe2000000008aULL, 0x00000088705c723cULL, 0x000b6c000000185cULL,
0x0000001c008d7306ULL, 0x000ea20000200c00ULL, 0x000054108c8c7816ULL, 0x002fe2000000008bULL,
0x0000007c7440723cULL, 0x080b6c0000001840ULL, 0x0000007f007f7306ULL, 0x000e640000200c00ULL,
0x0000007c7060723cULL, 0x000b620000001860ULL, 0x00005410188d7816ULL, 0x004fe2000000008dULL,
0x0000000211187824ULL, 0x000fca00078e00ffULL, 0xfffffff8181a7812ULL, 0x000fe200078ec0ffULL,
0x0000008c7444723cULL, 0x000b620000001844ULL, 0x000054107f8f7816ULL, 0x002fce0000000090ULL,
0x0000008e7448723cULL, 0x000b700000001848ULL, 0x0000008c7064723cULL, 0x040b700000001864ULL,
0x0000008e7068723cULL, 0x000b620000001868ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000252a7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a698001aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff187224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x0000040025237984ULL, 0x000e620000000800ULL, 0x000000030b1a7810ULL, 0x008fc40007ffe0ffULL,
0x8000000023ff7812ULL, 0x006fe2000780482bULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620237210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x000000231c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc80000001223ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040025237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106237810ULL, 0x000fe40007ffe0ffULL, 0x0000000308087810ULL, 0x000fe40007ffe0ffULL,
0x0000000c2300720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x0000000206217810ULL, 0x000fe20007ffe0ffULL, 0x0000010023237824ULL, 0x000fe400078e0284ULL,
0x0000590022227a24ULL, 0x010fe200078e02ffULL, 0x0000000c2100720cULL, 0x000fe40003f06070ULL,
0x0000002023087812ULL, 0x000fe200078ec0ffULL, 0x00000040226d7824ULL, 0x000fc800078e00ffULL,
0x00000001092a7824ULL, 0x000fcc00078e0208ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x000000230e087217ULL, 0x000fe20007800000ULL, 0x0000001011187824ULL, 0x000fc800078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a23ULL, 0x0000001018217812ULL, 0x000fe400078ec0ffULL,
0x00000003ff187819ULL, 0x000fe4000001160fULL, 0x0000000821087217ULL, 0x000fe40007800000ULL,
0x00000004181c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000818207810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x100fe200078e0a21ULL, 0x0000000c18257810ULL, 0x000fe20007ffe0ffULL,
0x000000011c227824ULL, 0x000fc400078e0221ULL, 0x0000000120237824ULL, 0x040fe200078e0221ULL,
0x000000082000720cULL, 0x080fe20003f46070ULL, 0x0000000122207824ULL, 0x000fe200078e020fULL,
0x000000081800720cULL, 0x080fe20003f86070ULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0x000000081c00720cULL, 0x080fe20003f66070ULL, 0x0000000118187824ULL, 0x100fe200078e0221ULL,
0x000000082500720cULL, 0x040fe20003f06070ULL, 0x0000000125217824ULL, 0x000fe200078e0221ULL,
0xfffffff82b087812ULL, 0x000fe200078ee220ULL, 0x00000001181c7824ULL, 0x000fc400078e020fULL,
0x0000000818277824ULL, 0x040fe400078e00ffULL, 0x0000000118207824ULL, 0x100fe400078e022aULL,
0x0000000123267824ULL, 0x000fe200078e022aULL, 0xfffffff8271c7812ULL, 0x000fe200078ee21cULL,
0x0000000123187824ULL, 0x040fe400078e020fULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x000fc400078e022aULL, 0x0000000121257824ULL, 0x000fe200078e020fULL,
0xfffffff823187812ULL, 0x000fe200078ee218ULL, 0x00000008216c7824ULL, 0x040fe400078e00ffULL,
0x00000001212a7824ULL, 0x000fe400078e022aULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee225ULL, 0x000064006d257a11ULL, 0x000fe200078a38ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000220207212ULL, 0x000fc400078efcffULL,
0x000065006d6d7a11ULL, 0x000fe200028f3cffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000222227212ULL, 0x000fe400078efcffULL, 0x0000002025207210ULL, 0x000fe20007fbe0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002522227210ULL, 0x080fe40007fde0ffULL,
0x0000000226267212ULL, 0x080fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200028e066dULL,
0x000000022a2a7212ULL, 0x000fe200078efcffULL, 0x0000000123237824ULL, 0x000fe200030e066dULL,
0x0000002526267210ULL, 0x080fe20007fbe0ffULL, 0x0000001008717824ULL, 0x100fe200078e021fULL,
0x000000252a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000101c257824ULL, 0x000fc400078e021fULL,
0x0000001018737824ULL, 0x000fe400078e021fULL, 0x0000000127277824ULL, 0x000fe200028e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000e101c46ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200030e066dULL,
0x0000000022717faeULL, 0x0003e8000d901c46ULL, 0x0000000026737faeULL, 0x0003e8000d101c46ULL,
0x000000002a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011087824ULL, 0x000fca00078e00ffULL, 0x0000001008087812ULL, 0x000fc800078ec0ffULL,
0x000000080f087211ULL, 0x000fc800078fe8ffULL, 0x00000004081c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108187824ULL, 0x140fe200078e020fULL, 0x0000000c08237810ULL, 0x040fe20007ffe0ffULL,
0x0000000808217824ULL, 0x040fe400078e00ffULL, 0x0000000108207824ULL, 0x100fe400078e022aULL,
0x000000011c227824ULL, 0x040fe200078e022aULL, 0xfffffff821187812ULL, 0x000fe200078ee218ULL,
0x000000081c277824ULL, 0x000fe200078e00ffULL, 0x0000000808217810ULL, 0x000fe20007ffe0ffULL,
0x000000011c087824ULL, 0x000fc400078e020fULL, 0x0000000123257824ULL, 0x140fe400078e020fULL,
0x00000008236c7824ULL, 0x000fe200078e00ffULL, 0xfffffff827087812ULL, 0x000fe200078ee208ULL,
0x0000000121267824ULL, 0x040fe400078e022aULL, 0x00000001211c7824ULL, 0x040fe200078e020fULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0x000064006d257a11ULL, 0x000fe200078038ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x00000001232a7824ULL, 0x000fe200078e022aULL,
0x0000000220207212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000065006d6d7a11ULL, 0x000fe400000f3cffULL, 0x0000002025207210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000222227212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000226267212ULL, 0x000fc600078efcffULL,
0x0000000121217824ULL, 0x000fe200000e066dULL, 0x000000022a2a7212ULL, 0x000fe200078efcffULL,
0x0000001008717824ULL, 0x100fe200078e021fULL, 0x0000002225227210ULL, 0x040fe20007f1e0ffULL,
0x000000101c737824ULL, 0x100fe200078e021fULL, 0x0000002625267210ULL, 0x040fe40007f5e0ffULL,
0x0000002a252a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001018257824ULL, 0x000fe400078e021fULL,
0x0000000123237824ULL, 0x000fc400000e066dULL, 0x0000000127277824ULL, 0x000fe200010e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000b901c46ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200018e066dULL,
0x0000000022717faeULL, 0x0003e8000b901c46ULL, 0x0000000026737faeULL, 0x0003e8000b901c46ULL,
0x000000002a1f7faeULL, 0x0003e4000b901c46ULL, 0x0000000405087810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff227424ULL, 0x002fc400078e00ffULL,
0x0000000d0800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000107227824ULL, 0x000fe400078e0208ULL, 0x00000004ff237424ULL, 0x000fc800078e00ffULL,
0x0000660022227625ULL, 0x000fcc00078e0023ULL, 0x0000000622227981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000811187824ULL, 0x000fe400078e00ffULL,
0x000000020b057824ULL, 0x000fc600078e0279ULL, 0xfffffff018207812ULL, 0x040fe400078ec0ffULL,
0x0000000818187812ULL, 0x000fe400078ec0ffULL, 0x00000000200473c2ULL, 0x000ea600000e0000ULL,
0x0000001005057824ULL, 0x000fe400078e0018ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001a6a804047890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6a80020207f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800052a7f8cULL, 0x000662000c80043fULL, 0x000000ffff187224ULL, 0x004fc600078e0021ULL,
0x0000000000207805ULL, 0x000fc80000015200ULL, 0x01a66c00051f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026201f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x0000001f1c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc8000000121fULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c00051f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000801a057824ULL, 0x008fc800078e0202ULL,
0x0000000178057824ULL, 0x000fca00078e0205ULL, 0x01a0000005207984ULL, 0x000e680000000800ULL,
0x01a20000051f7984ULL, 0x0004e20000000800ULL, 0x000000032000720bULL, 0x002fe20003f1d000ULL,
0x0000e1527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x004fc800000e0100ULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x000fd200078e0003ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000000030b1a7810ULL, 0x000fe40007ffe0ffULL,
0x000000032000720bULL, 0x000fe40003f54000ULL, 0x000000111a00720cULL, 0x000fe20003f05270ULL,
0x0000e1127f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x0000008011218824ULL, 0x000fe200078e0202ULL, 0x00000003201a7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000178218824ULL, 0x000fca00078e0221ULL,
0x01a4001a21008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000031a027221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x0000000200037308ULL, 0x000e640000000800ULL,
0x0000000324247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x0000e0627f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262c2c7220ULL, 0x084fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x000fc40000410000ULL, 0x0000002644447220ULL, 0x080fe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x0000df527f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262e2e7220ULL, 0x084fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x000fc40000410000ULL,
0x0000002646467220ULL, 0x080fe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x0000de427f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264c4c7220ULL, 0x084fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x000fc40000410000ULL, 0x0000002664647220ULL, 0x080fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002668687220ULL, 0x080fe40000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x0000dd427f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264e4e7220ULL, 0x084fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x000fc40000410000ULL, 0x0000002666667220ULL, 0x080fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x000000266a6a7220ULL, 0x080fe40000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c05ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff1c7424ULL, 0x000fd800078e00ffULL,
0x000000201a020221ULL, 0x000fe20000010100ULL, 0x00007610ff1c0816ULL, 0x000fc6000000001cULL,
0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL, 0x0000000200000308ULL, 0x000e640000000800ULL,
0x000000001f1f0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000241f247221ULL, 0x008fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x0000000811057824ULL, 0x000fca00078e00ffULL, 0xfffffff0051f7812ULL, 0x000fca00078ec0ffULL,
0x01a6b4001f057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002002207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e03ULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011421ULL,
0x0000002005057211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x0000000205057819ULL, 0x000fc80000001220ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000123237810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b4001f057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101c027816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001160fULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x0000d9227f007947ULL, 0x000fea000b800000ULL,
0x00001f0302137589ULL, 0x0002a400000e0000ULL, 0x0000000803277810ULL, 0x000fe20007ffe0ffULL,
0x0000d9727f007947ULL, 0x000fea000b800000ULL, 0x0000001003157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2702147589ULL, 0x00066a00000e0000ULL, 0x00001f1502157589ULL, 0x0006a400000e0000ULL,
0x0000001803277810ULL, 0x008fe20007ffe0ffULL, 0x0000da027f007947ULL, 0x000fea000b800000ULL,
0x00001f2702167589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff027819ULL, 0x00afe2000001160fULL, 0x0000000817207824ULL, 0x000fe200078e00ffULL,
0x000000030b1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819267824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000479027824ULL, 0x000fe200078e0202ULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x00000004111f7824ULL, 0x000fc400078e00ffULL,
0x0000000117037824ULL, 0x100fe400078e0202ULL, 0x0000000119057824ULL, 0x000fe200078e0202ULL,
0x000000041f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000101b747824ULL, 0x000fe200078e0228ULL,
0xfffffff820027812ULL, 0x000fe400078ee203ULL, 0x000120001c037811ULL, 0x000fe400078e60ffULL,
0xfffffff8261c7812ULL, 0x000fe400078ee205ULL, 0x000000021f207812ULL, 0x000fe200078efcffULL,
0x0000001002027824ULL, 0x000fc400078e0203ULL, 0x000000101c1c7824ULL, 0x000fc600078e0203ULL,
0x000000000270783bULL, 0x0002e80000000200ULL, 0x000000001c6c783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x08cfe40000000000ULL,
0x0000001372727232ULL, 0x000fe40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fc40000000000ULL, 0x000000156c6c7232ULL, 0x080fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200f027211ULL, 0x002fe200078fe0ffULL, 0x00000008171c7824ULL, 0x040fe200078e00ffULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e0203ULL,
0x0000082000007945ULL, 0x000fe20003800000ULL, 0x0000000117177824ULL, 0x000fca00078e0202ULL,
0xfffffff81c177812ULL, 0x000fca00078ee217ULL, 0x0000001017177824ULL, 0x000fca00078e0228ULL,
0x00000000177c783bULL, 0x0006a20000004200ULL, 0x00000018ff1c7819ULL, 0x002fe20000011475ULL,
0x0000010074177824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011476ULL,
0x00000100772b7824ULL, 0x000fe200078e00ffULL, 0x0000001c00237306ULL, 0x0003e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe40000011474ULL, 0x00000018ff207819ULL, 0x000fe40000011477ULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000001f00257306ULL, 0x0007e20000200c00ULL, 0x00008880751c7816ULL, 0x002fe400000000ffULL,
0x00000018ff217819ULL, 0x004fe2000001147cULL, 0x000001007f8b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe2000001147dULL, 0x00000100751f7824ULL, 0x048fe400078e00ffULL,
0x0000002100857306ULL, 0x0003e20000200c00ULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001147fULL, 0x000001007d837824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000005001b7306ULL, 0x0005e20000200c00ULL, 0x0000010076217824ULL, 0x002fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe4000001147eULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002600877306ULL, 0x000fe20000200c00ULL,
0x0000888074057816ULL, 0x044fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fc8000001148bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000007500267306ULL, 0x0003f00000200c00ULL, 0x0000002000807306ULL, 0x000fe20000200c00ULL,
0x000001007c757824ULL, 0x002fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001f001f7306ULL, 0x000ff00000200c00ULL,
0x0000002a008e7306ULL, 0x000ff00000200c00ULL, 0x0000000500057306ULL, 0x000ff00000200c00ULL,
0x0000001700207306ULL, 0x0002b00000200c00ULL, 0x00000021002a7306ULL, 0x0007e20000200c00ULL,
0x0000888076177816ULL, 0x042fe200000000ffULL, 0x0001000076767824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000002b00787306ULL, 0x0003e20000200c00ULL,
0x000088807c217816ULL, 0x048fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x0000541005207816ULL, 0x004fc80000000020ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x00000027008c7306ULL, 0x0005e20000200c00ULL, 0x000088807d2b7816ULL, 0x042fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000007500827306ULL, 0x0003e20000200c00ULL, 0x0000888077277816ULL, 0x044fe200000000ffULL,
0x0001000077777824ULL, 0x000fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000002100817306ULL, 0x0004e20000200c00ULL, 0x000088807f757816ULL, 0x042fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002b00867306ULL, 0x0003e20000200c00ULL, 0x000088807e217816ULL, 0x004fce00000000ffULL,
0x0000002100897306ULL, 0x0005e20000200c00ULL, 0x000001007e2b7824ULL, 0x042fe200078e00ffULL,
0x0000541081827816ULL, 0x008fe20000000082ULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x00000075008d7306ULL, 0x0003e20000200c00ULL, 0x000054101c217816ULL, 0x004fce000000001fULL,
0x0000008b001c7306ULL, 0x000ea20000200c00ULL, 0x0000541026757816ULL, 0x002fe20000000023ULL,
0x000000206c4c723cULL, 0x080f6c000000184cULL, 0x0000007400747306ULL, 0x000e640000200c00ULL,
0x00000020702c723cULL, 0x000f6c000000182cULL, 0x0000001700177306ULL, 0x000ee20000200c00ULL,
0x000054108d8b7816ULL, 0x004fce000000001cULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000541074747816ULL, 0x002fce000000001bULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00005410172a7816ULL, 0x008fe2000000002aULL, 0x000000746c50723cULL, 0x080f6c0000001850ULL,
0x0000007700777306ULL, 0x000ea40000200c00ULL, 0x000000747030723cULL, 0x000f6c0000001830ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000025ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000080ULL,
0x0000007d00887306ULL, 0x000ea20000200c00ULL, 0x0000541086837816ULL, 0x008fe20000000083ULL,
0x000000766c58723cULL, 0x040f6c0000001858ULL, 0x0000002b008a7306ULL, 0x0006a20000200c00ULL,
0x000054107c7c7816ULL, 0x002fe20000000085ULL, 0x000000826c5c723cULL, 0x000f6c000000185cULL,
0x0000007e00057306ULL, 0x000e620000200c00ULL, 0x00005410272b7816ULL, 0x008fe20000000078ULL,
0x000000767038723cULL, 0x000f620000001838ULL, 0x00005410887d7816ULL, 0x004fca0000000087ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x00005410898a7816ULL, 0x000fe2000000008aULL,
0x0000002a6c54723cULL, 0x000f620000001854ULL, 0x00005410058c7816ULL, 0x002fe2000000008cULL,
0x000000101d057824ULL, 0x000fcc00078e0203ULL, 0x0000007c6c60723cULL, 0x000f620000001860ULL,
0x000000001e1c783bULL, 0x000e620000000200ULL, 0x000054107f8d7816ULL, 0x004fcc000000008eULL,
0x0000008a6c64723cULL, 0x040f700000001864ULL, 0x0000008c6c68723cULL, 0x000b640000001868ULL,
0x00000000056c783bULL, 0x0204ec0000000200ULL, 0x0000002a7034723cULL, 0x040b700000001834ULL,
0x00000082703c723cULL, 0x040b70000000183cULL, 0x0000007c7040723cULL, 0x040b700000001840ULL,
0x0000008a7044723cULL, 0x040b700000001844ULL, 0x0000008c7048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x000000136c6c7232ULL, 0x08efe40000000000ULL, 0x000000136e6e7232ULL, 0x000fc40000000000ULL,
0x000000146d6d7232ULL, 0x080fe40000000000ULL, 0x000000146f6f7232ULL, 0x000fe40000000000ULL,
0x000000151c1c7232ULL, 0x080fe40000000000ULL, 0x000000151e1e7232ULL, 0x000fe40000000000ULL,
0x000000161d1d7232ULL, 0x080fe40000000000ULL, 0x000000161f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000000819037824ULL, 0x040fe200078e00ffULL,
0x000000002970783bULL, 0x020e620000004200ULL, 0x0000000119027824ULL, 0x000fca00078e0202ULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0228ULL,
0x000000000374783bULL, 0x0004e20000004200ULL, 0x00000018ff197819ULL, 0x002fe20000011472ULL,
0x0000010070037824ULL, 0x004fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe40000011470ULL,
0x00000018ff177819ULL, 0x000fe20000011471ULL, 0x0000001900257306ULL, 0x0003e20000200c00ULL,
0x00000018ff037819ULL, 0x000fe40000011403ULL, 0x00000018ff207819ULL, 0x000fca0000011473ULL,
0x0000000200057306ULL, 0x0005e20000200c00ULL, 0x0000010071197824ULL, 0x002fe200078e00ffULL,
0x00000018ff277819ULL, 0x008fe20000011477ULL, 0x0000010074297824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011476ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000017001b7306ULL, 0x0003e20000200c00ULL, 0x0000888070027816ULL, 0x044fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fc40000011475ULL,
0x00000018ff217819ULL, 0x000fe40000011474ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000002700867306ULL, 0x0005e20000200c00ULL, 0x0000888071177816ULL, 0x042fe200000000ffULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x00000020002b7306ULL, 0x000fe20000200c00ULL,
0x0000010073277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000000200027306ULL, 0x000ff00000200c00ULL, 0x0000000300037306ULL, 0x000e700000200c00ULL,
0x0000001700177306ULL, 0x000ff00000200c00ULL, 0x0000001900207306ULL, 0x0004e20000200c00ULL,
0x0000541002027816ULL, 0x002fce0000000003ULL, 0x0000002300817306ULL, 0x0003e20000200c00ULL,
0x0000888073197816ULL, 0x044fe200000000ffULL, 0x0001000073737824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000002600857306ULL, 0x000fe20000200c00ULL,
0x0000010072237824ULL, 0x002fe200078e00ffULL, 0x0000541017037816ULL, 0x008fe20000000020ULL,
0x0000010077177824ULL, 0x000fc600078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000007100267306ULL, 0x0003e20000200c00ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x000000026c2c723cULL, 0x080b6c000000182cULL, 0x00000027002a7306ULL, 0x0005e20000200c00ULL,
0x0000888075717816ULL, 0x042fe200000000ffULL, 0x000000021c4c723cULL, 0x000b6c000000184cULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0000010075277824ULL, 0x004fc400078e00ffULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011427ULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x00000021007e7306ULL, 0x0005e20000200c00ULL,
0x0000541070707816ULL, 0x002fce0000000005ULL, 0x0000002300287306ULL, 0x0003e20000200c00ULL,
0x0000888072217816ULL, 0x044fe200000000ffULL, 0x0001000072727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007500827306ULL, 0x0005e20000200c00ULL,
0x0000888074237816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000007300787306ULL, 0x0003e20000200c00ULL,
0x0000888077757816ULL, 0x044fe200000000ffULL, 0x0001000077777824ULL, 0x000fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x00000071007f7306ULL, 0x0005e20000200c00ULL,
0x0001000076737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000029007c7306ULL, 0x0003e20000200c00ULL, 0x0000010076717824ULL, 0x004fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007d00807306ULL, 0x000ea20000200c00ULL,
0x0000888076297816ULL, 0x002fce00000000ffULL, 0x0000007400277306ULL, 0x000e700000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107f7d7816ULL, 0x004fe40000000080ULL,
0x00005410827f7816ULL, 0x000fca0000000081ULL, 0x0000001700207306ULL, 0x000fe20000200c00ULL,
0x00005410277e7816ULL, 0x002fce000000007eULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x0000007e6c40723cULL, 0x080b6e0000001840ULL, 0x0000001900197306ULL, 0x000fe20000200c00ULL,
0x0000007e1c60723cULL, 0x000b6e0000001860ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x0000541021287816ULL, 0x002fce0000000028ULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000002900837306ULL, 0x0007e20000200c00ULL, 0x0000541072727816ULL, 0x004fce0000000025ULL,
0x0000007100767306ULL, 0x0004a20000200c00ULL, 0x0000541019297816ULL, 0x008fe4000000002aULL,
0x00005410237c7816ULL, 0x002fca000000007cULL, 0x0000007300747306ULL, 0x0002e20000200c00ULL,
0x0000541026717816ULL, 0x004fe2000000001bULL, 0x000000286c34723cULL, 0x040b6c0000001834ULL,
0x0000007700057306ULL, 0x0004a20000200c00ULL, 0x0000541078737816ULL, 0x002fe2000000002bULL,
0x000000706c30723cULL, 0x000b620000001830ULL, 0x0000541083767816ULL, 0x000fc40000000076ULL,
0x0000541074747816ULL, 0x008fe40000000085ULL, 0x0000541075777816ULL, 0x004fc60000000020ULL,
0x000000726c38723cULL, 0x000b620000001838ULL, 0x0000541005757816ULL, 0x000fce0000000086ULL,
0x0000007c6c3c723cULL, 0x040b70000000183cULL, 0x000000766c44723cULL, 0x040b700000001844ULL,
0x000000746c48723cULL, 0x000b700000001848ULL, 0x000000701c50723cULL, 0x040b700000001850ULL,
0x000000281c54723cULL, 0x040b700000001854ULL, 0x000000721c58723cULL, 0x040b700000001858ULL,
0x0000007c1c5c723cULL, 0x040b70000000185cULL, 0x000000761c64723cULL, 0x040b700000001864ULL,
0x000000741c68723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000004047f8cULL, 0x000e62000c80043fULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0001a6a00b027811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000002ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff177224ULL, 0x002fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4ee000007947ULL, 0x000fea000383ffffULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cf5000047802ULL, 0x000fc40000000f00ULL,
0x0000cae000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000001808057811ULL, 0x044fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x002fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x002fc40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000003400347220ULL, 0x040fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x000fc40000410000ULL,
0x0000003900397220ULL, 0x040fe40000410000ULL, 0x0000003c003c7220ULL, 0x040fe40000410000ULL,
0x0000003d003d7220ULL, 0x040fe40000410000ULL, 0x0000004000407220ULL, 0x040fe40000410000ULL,
0x0000004100417220ULL, 0x040fe40000410000ULL, 0x0000004400447220ULL, 0x000fc40000410000ULL,
0x0000004500457220ULL, 0x040fe40000410000ULL, 0x0000004800487220ULL, 0x040fe40000410000ULL,
0x0000004900497220ULL, 0x000fe40000410000ULL, 0x0000004e054e7220ULL, 0x044fe40000410000ULL,
0x0000004f054f7220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x000fc40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000005605567220ULL, 0x040fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005a055a7220ULL, 0x040fe40000410000ULL,
0x0000005b055b7220ULL, 0x040fe40000410000ULL, 0x0000005e055e7220ULL, 0x000fc40000410000ULL,
0x0000005f055f7220ULL, 0x040fe40000410000ULL, 0x0000006205627220ULL, 0x040fe40000410000ULL,
0x0000006305637220ULL, 0x040fe40000410000ULL, 0x0000006605667220ULL, 0x040fe40000410000ULL,
0x0000006705677220ULL, 0x040fe40000410000ULL, 0x0000006a056a7220ULL, 0x000fc40000410000ULL,
0x0000006b056b7220ULL, 0x000fe40000410000ULL, 0x000000042e2e7220ULL, 0x088fe40000410000ULL,
0x000000042f2f7220ULL, 0x080fe40000410000ULL, 0x0000000432327220ULL, 0x080fe40000410000ULL,
0x0000000433337220ULL, 0x080fe40000410000ULL, 0x0000000436367220ULL, 0x000fc40000410000ULL,
0x0000000437377220ULL, 0x080fe40000410000ULL, 0x000000043a3a7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x080fe40000410000ULL, 0x000000043e3e7220ULL, 0x080fe40000410000ULL,
0x000000043f3f7220ULL, 0x080fe40000410000ULL, 0x0000000442427220ULL, 0x000fc40000410000ULL,
0x0000000443437220ULL, 0x080fe40000410000ULL, 0x0000000446467220ULL, 0x080fe40000410000ULL,
0x0000000447477220ULL, 0x080fe40000410000ULL, 0x000000044a4a7220ULL, 0x080fe40000410000ULL,
0x000000044b4b7220ULL, 0x000fe40000410000ULL, 0x000000024c4c7220ULL, 0x000fc40000410000ULL,
0x000000024d4d7220ULL, 0x080fe40000410000ULL, 0x0000000250507220ULL, 0x080fe40000410000ULL,
0x0000000251517220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x080fe40000410000ULL, 0x0000000258587220ULL, 0x000fc40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x000000025c5c7220ULL, 0x080fe40000410000ULL,
0x000000025d5d7220ULL, 0x080fe40000410000ULL, 0x0000000260607220ULL, 0x080fe40000410000ULL,
0x0000000261617220ULL, 0x080fe40000410000ULL, 0x0000000264647220ULL, 0x000fc40000410000ULL,
0x0000000265657220ULL, 0x080fe40000410000ULL, 0x0000000268687220ULL, 0x080fe40000410000ULL,
0x0000000269697220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x004ea20000000000ULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fc400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x00000042431f723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fe400000000ffULL,
0x0000004a4b23723eULL, 0x000fe400000000ffULL, 0x0000004c4d4c723eULL, 0x000fc400000000ffULL,
0x0000000803057811ULL, 0x044fe200078ff0ffULL, 0x0000000184847824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x040fe400078ec0ffULL, 0x0000001803097811ULL, 0x000fe200078ff0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe400078ff8ffULL,
0x0000001003057811ULL, 0x000fe200078ff0ffULL, 0x0000000809187824ULL, 0x002fe200078e00ffULL,
0xfffffff8070e7812ULL, 0x000fc400078ee202ULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x00000008050b7824ULL, 0x000fe200078e00ffULL, 0x0000000500047211ULL, 0x040fe400078ff8ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b167812ULL, 0x000fe200078ee204ULL, 0x0000200011047824ULL, 0x000fe200078e00ffULL,
0x0000000900057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fc400078ee205ULL, 0x0000200004057812ULL, 0x000fe400078ee2ffULL,
0xfffffff809067812ULL, 0x040fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x000010000a077824ULL, 0x100fe200078e0205ULL, 0x0000000402047810ULL, 0x000fe20007ffe0ffULL,
0x0000001084847824ULL, 0x000fe200078e0205ULL, 0x0000000602097810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e0207ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL,
0x000000100e147824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x0000001016167824ULL, 0x100fe200078e0207ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x100fe200078e0207ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x0000001006067824ULL, 0x100fe200078e0207ULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x0000001008087824ULL, 0x100fe200078e0207ULL, 0x00005410001c7816ULL, 0x100fe20000000002ULL,
0x000000100c0e7824ULL, 0x000fe200078e0207ULL, 0x00007632001d7816ULL, 0x000fe20000000002ULL,
0x0000000104077824ULL, 0x000fe200078e0209ULL, 0x000000343500723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x000fe200078e0206ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x00000001090c7824ULL, 0x000fe200078e0208ULL, 0x0000001c07007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x00000001090e7824ULL, 0x000fe200078e020eULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x0000000109147824ULL, 0x000fe200078e0214ULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x0000000109167824ULL, 0x040fe200078e0216ULL,
0x00005410361a7816ULL, 0x000fe2000000001bULL, 0x0000000109187824ULL, 0x000fe200078e0218ULL,
0x000000545554723eULL, 0x000fc400000000ffULL, 0x00000058592a723eULL, 0x000fe400000000ffULL,
0x00005410001c7816ULL, 0x142fe40000000002ULL, 0x00007632001d7816ULL, 0x000fe40000000002ULL,
0x000000444507723eULL, 0x000fe400000000ffULL, 0x00007632361b7816ULL, 0x000fe2000000001bULL,
0x0000001c0b007388ULL, 0x0003e20000000a00ULL, 0x000054103e1e7816ULL, 0x000fc4000000001fULL,
0x000076323e1f7816ULL, 0x000fe4000000001fULL, 0x0000541046227816ULL, 0x150fe40000000023ULL,
0x0000763246237816ULL, 0x000fe40000000023ULL, 0x0000763254097816ULL, 0x000fe4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe400000000ffULL, 0x00005410041c7816ULL, 0x002fc40000000006ULL,
0x00007632041d7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000001c0c007388ULL, 0x000fe20000000a00ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x000000606160723eULL, 0x000fe200000000ffULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x000000646564723eULL, 0x000fc400000000ffULL,
0x000000686932723eULL, 0x000fe400000000ffULL, 0x0000004e4f00723eULL, 0x000fe400000000ffULL,
0x0000763264157816ULL, 0x000fe40000000032ULL, 0x000000525302723eULL, 0x000fe400000000ffULL,
0x000000565704723eULL, 0x000fe400000000ffULL, 0x000054102e067816ULL, 0x002fc40000000017ULL,
0x000076322e077816ULL, 0x000fe40000000017ULL, 0x000000ff0a00720cULL, 0x000fc60003f05270ULL,
0x0000000614007388ULL, 0x0003e80000000a00ULL, 0x0004001a0b007388ULL, 0x000fe80000000a00ULL,
0x0004001e0c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x002fc60000000026ULL,
0x000400220e007388ULL, 0x000fe20000000a00ULL, 0x000076324c077816ULL, 0x000fe40000000026ULL,
0x0000541064147816ULL, 0x000fc60000000032ULL, 0x0000000616007388ULL, 0x0003e80000000a00ULL,
0x000800080b007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe400000000ffULL,
0x000000666707723eULL, 0x000fe400000000ffULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fc40000000060ULL, 0x0000763204197816ULL, 0x000fc60000000006ULL,
0x000800080c007388ULL, 0x0003e80000000a00ULL, 0x000800140e007388ULL, 0x0005e20000000a00ULL,
0x0000006a6b08723eULL, 0x002fe400000000ffULL, 0x0000541000147816ULL, 0x144fe40000000002ULL,
0x0000763200157816ULL, 0x000fe40000000002ULL, 0x0000005e5f00723eULL, 0x000fc400000000ffULL,
0x000000626302723eULL, 0x000fe200000000ffULL, 0x0000001418007388ULL, 0x0003e60000000a00ULL,
0x00005410002c7816ULL, 0x140fe40000000002ULL, 0x00007632002d7816ULL, 0x000fe40000000002ULL,
0x0000541004187816ULL, 0x002fe40000000006ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000c00180b007388ULL, 0x000fe80000000a00ULL,
0x000c002c0c007388ULL, 0x000fe80000000a00ULL, 0x000c00060e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000084147984ULL, 0x000e680000000c00ULL,
0x00040000841c7984ULL, 0x000ea80000000c00ULL, 0x0008000084247984ULL, 0x000ee80000000c00ULL,
0x000c0000842c7984ULL, 0x000ee80000000c00ULL, 0x0010000084187984ULL, 0x000ee80000000c00ULL,
0x0014000084207984ULL, 0x000ee80000000c00ULL, 0x0018000084287984ULL, 0x000ee80000000c00ULL,
0x001c000084307984ULL, 0x000ee20000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x000fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe40000000000ULL, 0x0000001915157230ULL, 0x000fc40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000001484007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001c84007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0008002484007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fc40000000000ULL, 0x000000302c2c7230ULL, 0x000fca0000000000ULL,
0x000c002c84007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011603ULL,
0x0000007a0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff157a12ULL, 0x000fe200078e33ffULL, 0x0000000110007824ULL, 0x000fe200078e0209ULL,
0x0000000111117812ULL, 0x000fc800078ec0ffULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL, 0x0000000109027824ULL, 0x000fca00078e0203ULL,
0x0000000800077305ULL, 0x000e62000021f000ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802027812ULL, 0x000fca00078ef803ULL, 0x0000001002027824ULL, 0x000fe400078e0205ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b07137227ULL, 0x000fe400078e0006ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000013047227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a04ULL,
0x0000000703027812ULL, 0x002fc600078ec0ffULL, 0x00005a0007067a24ULL, 0x000fca00078e0200ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000104041810ULL, 0x000fc80007ffe0ffULL,
0x0000000415077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b047210ULL, 0x000fe40007f3e0ffULL, 0x0000002003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0004067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0004077a11ULL, 0x000fe400008f4407ULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b077210ULL, 0x000fe40007f3e0ffULL,
0x0000004003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b077210ULL, 0x000fe40007f3e0ffULL, 0x0000006003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b077210ULL, 0x000fe40007f3e0ffULL,
0x0000008003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x00000008110d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b077210ULL, 0x000fe40007f3e0ffULL, 0x000000a003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110027824ULL, 0x100fe200078e020fULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x00000003ff0f7819ULL, 0x000fe4000001160cULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008110d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x000000027b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fc800078240ffULL,
0x00005f0002077a11ULL, 0x000fe400008f4407ULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110007824ULL, 0x100fe400078e020fULL,
0x000000010c0f7824ULL, 0x000fe400078e020fULL, 0x0000000013067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f027812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d007a24ULL, 0x000fc800078e0200ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b067210ULL, 0x000fe40007f3e0ffULL,
0x000000e003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0006027a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x00005f0006037a11ULL, 0x000fe200008f4407ULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x0000007a0d00720cULL, 0x000fe20003f26070ULL, 0x0000000110107824ULL, 0x000fe400078e020dULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001013037227ULL, 0x002fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x00005a0007027a24ULL, 0x000fc600078e0210ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0xfffffff80d027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001002057824ULL, 0x000fca00078e0205ULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000315037207ULL, 0x000fe20004000000ULL,
0x0000000811057824ULL, 0x002fc800078e0200ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0212ULL, 0x00005a0007107a24ULL, 0x000fc800078e0210ULL,
0x00005a0003107a24ULL, 0x000fca00078e0210ULL, 0x000000107b107210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0010027a11ULL, 0x000fc800078040ffULL,
0x00005f0010037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000d1100720cULL, 0x000fe20003f06070ULL, 0xffffffffff157424ULL, 0x000fd800078e00ffULL,
0x0000000204088824ULL, 0x002fc800078e00ffULL, 0x00006a0008088a24ULL, 0x000fc800078e0211ULL,
0x0000660008088625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000608158981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0b7624ULL, 0x000fc600078e00ffULL, 0x01a60000ff067f8cULL, 0x000e68000c80043fULL,
0x000000060a697981ULL, 0x000722000c1e9900ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000004016007824ULL, 0x000fe400078e00ffULL, 0x00000040115d7824ULL, 0x000fe400078e00ffULL,
0x00000040125c7824ULL, 0x000fc400078e00ffULL, 0x0000001500297224ULL, 0x004fcc00078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x0000005d0e087217ULL, 0x00afe40007800000ULL,
0x00000003ff337819ULL, 0x000fe4000001160fULL, 0x00006400292f7a11ULL, 0x000fe200078438ffULL,
0x0000000108247824ULL, 0x000fe200078e0a5dULL, 0x0000000433097810ULL, 0x040fe20007ffe0ffULL,
0x0000004012127824ULL, 0x000fe200078e0233ULL, 0x00000008330a7810ULL, 0x000fe40007ffe0ffULL,
0x000000240900720cULL, 0x0c0fe20003f86070ULL, 0x0000000109087824ULL, 0x100fe200078e020fULL,
0x0000000c33147810ULL, 0x000fe20007ffe0ffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x000000240a00720cULL, 0x0c0fe20003f06070ULL, 0x000000010a097824ULL, 0x100fe200078e020fULL,
0x000000241400720cULL, 0x000fe20003f26070ULL, 0x000000080a287824ULL, 0x000fe200078e00ffULL,
0xfffffff80b267812ULL, 0x000fe200078ee208ULL, 0x0000000114157824ULL, 0x000fe200078e020fULL,
0x00000004120a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008142a7824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee209ULL, 0x0000008012087825ULL, 0x040fe200078e00ffULL,
0x0000000812147810ULL, 0x000fc40007ffe0ffULL, 0x0000650029317a11ULL, 0x000fe200010f3cffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000070081a7812ULL, 0x000fe400078ef803ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001a2f1a7210ULL, 0x000fe40007f5e0ffULL, 0x0000000c12087810ULL, 0x000fe40007ffe0ffULL,
0x0000007014147812ULL, 0x000fe200078ef803ULL, 0x00000001091b7824ULL, 0x000fe200010e0631ULL,
0x000000700a1c7812ULL, 0x000fe200078ef803ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000002f14147210ULL, 0x000fc40007f5e0ffULL, 0x0000002f1c1c7210ULL, 0x080fe40007f7e0ffULL,
0x00000070081e7812ULL, 0x000fe200078ef803ULL, 0x0000000115157824ULL, 0x100fe200010e0631ULL,
0x00000010120a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b1d7824ULL, 0x000fe200018e0631ULL,
0x0000002f1e1e7210ULL, 0x000fe40007f5e0ffULL, 0x0000001412167810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001812187810ULL, 0x000fc40007ffe0ffULL,
0x0000001c12087810ULL, 0x000fe20007ffe0ffULL, 0x00000001091f7824ULL, 0x000fe200010e0631ULL,
0x000000700a207812ULL, 0x000fe200078ef803ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000010330a7810ULL, 0x040fe40007ffe0ffULL, 0x0000002f20207210ULL, 0x000fe20007f7e0ffULL,
0x0000000133097824ULL, 0x040fe200078e020fULL, 0x0000007016167812ULL, 0x000fe200078ef803ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001433227810ULL, 0x000fc40007ffe0ffULL,
0x00000007092c7812ULL, 0x000fe200078ec0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe400078ef803ULL, 0x0000002f16167210ULL, 0x080fe20007fbe0ffULL,
0x000000010b217824ULL, 0x000fe200018e0631ULL, 0x0000002f18187210ULL, 0x000fe20007fde0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020fULL, 0x0000007008237812ULL, 0x000fe200078ef803ULL,
0x000000080a2e7824ULL, 0x040fe200078e00ffULL, 0x000000240a00720cULL, 0x080fe20003f46070ULL,
0x0000000122087824ULL, 0x100fe200078e020fULL, 0x0ffffff82c0a7812ULL, 0x000fe200078ef80fULL,
0x0000000822297824ULL, 0x040fe200078e00ffULL, 0x000000242200720cULL, 0x080fe20003f66070ULL,
0x0000000117177824ULL, 0x100fe200028e0631ULL, 0x000000243300720cULL, 0x000fe20003fa6070ULL,
0x0000000119197824ULL, 0x000fe200030e0631ULL, 0xfffffff82e2c7812ULL, 0x000fc400078ee20bULL,
0x0000002f23227210ULL, 0x080fe40007fde0ffULL, 0xfffffff8292e7812ULL, 0x000fe400078ee208ULL,
0x0000200011257811ULL, 0x000fe200078e70ffULL, 0x0000000109237824ULL, 0x000fe200030e0631ULL,
0x0000002012087810ULL, 0x000fe40007ffe0ffULL, 0x0000001c332b7810ULL, 0x040fe20007ffe0ffULL,
0x000000100a277824ULL, 0x100fe200078e0225ULL, 0x00000024120a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001026297824ULL, 0x000fe200078e0225ULL, 0x0000001833267810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a277faeULL, 0x0003e4000e901c46ULL, 0x000000242600720cULL, 0x080fe20003fa6070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000070082d7812ULL, 0x000fe200078ef803ULL,
0x000000001c297faeULL, 0x0005e2000e101c46ULL, 0x000000242b00720cULL, 0x000fe20003f86070ULL,
0x0000000126087824ULL, 0x000fe200078e020fULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x0000000826277824ULL, 0x002fe200078e00ffULL, 0x0000002f2d1a7210ULL, 0x000fe20007fde0ffULL,
0x000000012b267824ULL, 0x000fc400078e020fULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8271c7812ULL, 0x004fe200078ee208ULL, 0x00000001091b7824ULL, 0x000fe200030e0631ULL,
0x0000002812087810ULL, 0x000fe20007ffe0ffULL, 0x00000010281d7824ULL, 0x100fe200078e0225ULL,
0x0000002033287810ULL, 0x040fe20007ffe0ffULL, 0x000000102a277824ULL, 0x000fe200078e0225ULL,
0x0000002f0a0a7210ULL, 0x080fe20007fde0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000024332a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000141d7faeULL, 0x0003e2000c101c46ULL,
0x000000242800720cULL, 0x0c0fe20003f06070ULL, 0x0000000128297824ULL, 0x000fe200078e020fULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x0000000828307824ULL, 0x000fe200078e00ffULL,
0x000000001e277faeULL, 0x0005e2000c901c46ULL, 0x000000010b0b7824ULL, 0x000fe200030e0631ULL,
0x000000242a00720cULL, 0x040fe20003f26070ULL, 0x000000012a287824ULL, 0x040fe200078e020fULL,
0xfffffff82b267812ULL, 0x000fe200078ee226ULL, 0x000000082a157824ULL, 0x002fe200078e00ffULL,
0x0000002f08147210ULL, 0x000fe20007fde0ffULL, 0x000000102c1d7824ULL, 0x000fe200078e0225ULL,
0xfffffff830087812ULL, 0x000fc400078ee229ULL, 0xfffffff815287812ULL, 0x000fe200078ee228ULL,
0x0000000109157824ULL, 0x000fe200030e0631ULL, 0x00000000201d7faeULL, 0x0003e2000d101c46ULL,
0x000000102e097824ULL, 0x100fe200078e0225ULL, 0x00000030331e7810ULL, 0x044fe20007ffe0ffULL,
0x0000001008297824ULL, 0x100fe200078e0225ULL, 0x0000002c12087810ULL, 0x000fe20007ffe0ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0225ULL, 0x0000000016097faeULL, 0x0005e2000d901c46ULL,
0x0000001026277824ULL, 0x100fe200078e0225ULL, 0x00000028331c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010282b7824ULL, 0x000fe200078e0225ULL, 0x00000000181f7faeULL, 0x0007e2000e901c46ULL,
0x000000241e00720cULL, 0x000fc40003f66070ULL, 0x0000002c331d7810ULL, 0x002fe20007ffe0ffULL,
0x0000000022277faeULL, 0x0003e2000e101c46ULL, 0x000000241c00720cULL, 0x080fe40003fa6070ULL,
0x000000241d00720cULL, 0x000fe20003f86070ULL, 0x0000008008087825ULL, 0x004fe200078e00ffULL,
0x000000001a297faeULL, 0x0005e2000c101c46ULL, 0x0000003833217810ULL, 0x000fe40007ffe0ffULL,
0x000000011c197824ULL, 0x008fe200078e020fULL, 0x0000007008167812ULL, 0x000fe200078ef803ULL,
0x000000000a2b7faeULL, 0x0007e2000c901c46ULL, 0x0000003012087810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1c7824ULL, 0x000fe200078e00ffULL, 0x0000002f16167210ULL, 0x000fc40007fde0ffULL,
0x00000034331f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1a7824ULL, 0x004fe200078e020fULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL, 0x0000000109177824ULL, 0x000fe200030e0631ULL,
0x000000241f00720cULL, 0x080fe20003f46070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000034120a7810ULL, 0x008fe40007ffe0ffULL, 0x0000003c33227810ULL, 0x002fe20007ffe0ffULL,
0x000000081e1b7824ULL, 0x000fe200078e00ffULL, 0x0000007008187812ULL, 0x000fe200078ef803ULL,
0x000000011e087824ULL, 0x000fe200078e020fULL, 0x000000242100720cULL, 0x000fe20003f26070ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x0000002f18187210ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff81b207812ULL, 0x000fc400078ee208ULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee21aULL, 0x0000000109197824ULL, 0x000fe200030e0631ULL,
0x0000003812087810ULL, 0x000fe20007ffe0ffULL, 0x000000081f1b7824ULL, 0x040fe200078e00ffULL,
0x000000700a1a7812ULL, 0x000fe200078ef803ULL, 0x000000011f0a7824ULL, 0x100fe200078e020fULL,
0x0000003c121f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000002f1a1a7210ULL, 0x080fe40007fde0ffULL, 0xfffffff81b127812ULL, 0x000fe200078ee20aULL,
0x00000001211d7824ULL, 0x000fe200078e020fULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x000000010b1b7824ULL, 0x000fe200030e0631ULL, 0x000000242200720cULL, 0x000fe20003f06070ULL,
0x000000801f0a7825ULL, 0x000fe200078e00ffULL, 0x0000002f08087210ULL, 0x000fc60007fde0ffULL,
0x0000000821247824ULL, 0x000fe200078e00ffULL, 0x000000700a037812ULL, 0x000fe200078ef803ULL,
0x00000001220f7824ULL, 0x040fe400078e020fULL, 0x0000000822267824ULL, 0x000fe200078e00ffULL,
0xfffffff824227812ULL, 0x000fe200078ee21dULL, 0x0000000109097824ULL, 0x000fe200030e0631ULL,
0x0000002f030a7210ULL, 0x000fe20007fde0ffULL, 0x000000101c037824ULL, 0x000fe200078e0225ULL,
0xfffffff826247812ULL, 0x000fe200078ee20fULL, 0x000000101e0f7824ULL, 0x000fc400078e0225ULL,
0x00000010201d7824ULL, 0x100fe200078e0225ULL, 0x0000000014037faeULL, 0x0003e2000e901c46ULL,
0x00000010121f7824ULL, 0x100fe400078e0225ULL, 0x0000001022217824ULL, 0x100fe200078e0225ULL,
0x00000000160f7faeULL, 0x0003e2000e101c46ULL, 0x0000001024257824ULL, 0x000fe400078e0225ULL,
0x000000010b0b7824ULL, 0x000fe200030e0631ULL, 0x00000000181d7faeULL, 0x0003e8000d901c46ULL,
0x000000001a1f7faeULL, 0x0003e8000d101c46ULL, 0x0000000008217faeULL, 0x0003e8000c901c46ULL,
0x000000000a257faeULL, 0x0003e2000c101c46ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x000000040f0a7811ULL, 0x04afe400078fe8ffULL, 0x000000080f127811ULL, 0x000fc400078fe8ffULL,
0x000000100f187811ULL, 0x040fe200078fe8ffULL, 0x000000010a087824ULL, 0x140fe200078e020fULL,
0x0000000c0f157811ULL, 0x040fe200078fe8ffULL, 0x000000080a0b7824ULL, 0x000fe200078e00ffULL,
0x0000001c0f1d7811ULL, 0x040fe200078fe8ffULL, 0x0000000812197824ULL, 0x000fe200078e00ffULL,
0x000000200f267811ULL, 0x000fe200078fe8ffULL, 0x0000000118177824ULL, 0x100fe200078e020fULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL, 0x0000000112087824ULL, 0x100fe200078e020fULL,
0x000000180f1b7811ULL, 0x040fe200078fe8ffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x000000280f327811ULL, 0x000fe200078fe8ffULL, 0x0000000115097824ULL, 0x100fe200078e020fULL,
0xfffffff819147812ULL, 0x000fe200078ee208ULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x000000140f197811ULL, 0x000fe200078fe8ffULL, 0x000000011d1e7824ULL, 0x040fe200078e020fULL,
0xfffffff81a177812ULL, 0x000fe200078ee217ULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x0000000119087824ULL, 0x100fe200078e020fULL,
0x0000002c0f347811ULL, 0x000fe200078fe8ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x000000240f307811ULL, 0x000fe200078fe8ffULL, 0x000000011b097824ULL, 0x100fe200078e020fULL,
0xfffffff8211e7812ULL, 0x000fe200078ee21eULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee208ULL, 0x0000000126087824ULL, 0x040fe200078e020fULL,
0x000000300f367811ULL, 0x040fe200078fe8ffULL, 0x00000008261f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x0000000132217824ULL, 0x140fe200078e020fULL,
0x000000340f387811ULL, 0x000fe200078fe8ffULL, 0x0000000832227824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x0000000134087824ULL, 0x040fe200078e020fULL,
0x000000380f3a7811ULL, 0x040fe200078fe8ffULL, 0x0000000834237824ULL, 0x000fe200078e00ffULL,
0xfffffff822217812ULL, 0x000fe200078ee221ULL, 0x0000000130097824ULL, 0x140fe200078e020fULL,
0x0000003c0f3c7811ULL, 0x000fe200078fe8ffULL, 0x0000000830207824ULL, 0x000fe200078e00ffULL,
0xfffffff823227812ULL, 0x000fe200078ee208ULL, 0x0000000836287824ULL, 0x000fe200078e00ffULL,
0x0000000f0f087211ULL, 0x000fe200078fe8ffULL, 0x0000000138247824ULL, 0x000fe200078e020fULL,
0xfffffff820207812ULL, 0x000fe200078ee209ULL, 0x0000000136097824ULL, 0x100fe200078e020fULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000838257824ULL, 0x000fe200078e00ffULL,
0x00002000114d7811ULL, 0x000fe200078e70ffULL, 0x000000013c277824ULL, 0x000fe200078e020fULL,
0xfffffff828237812ULL, 0x000fe200078ee209ULL, 0x000000015c0a7824ULL, 0x000fe200078e020aULL,
0x0ffffff808097812ULL, 0x000fe200078ef80fULL, 0x0000001014337824ULL, 0x100fe200078e024dULL,
0x0000005c0f087211ULL, 0x000fe200078fe8ffULL, 0x0000001016357824ULL, 0x000fe200078e024dULL,
0xfffffff825247812ULL, 0x000fe200078ee224ULL, 0x000000013a257824ULL, 0x000fe200078e020fULL,
0x00006400294f7a11ULL, 0x000fe200078038ffULL, 0x00000010090f7824ULL, 0x000fc400078e024dULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000650029517a11ULL, 0x000fc600000f3cffULL,
0x000000015c147824ULL, 0x000fe400078e0212ULL, 0x000000101e3d7824ULL, 0x000fe200078e024dULL,
0x00000070081e7812ULL, 0x000fe200078ef803ULL, 0x000000015c167824ULL, 0x000fe400078e0215ULL,
0x000000100b317824ULL, 0x000fe200078e024dULL, 0x0000001e4f1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000001017377824ULL, 0x000fe400078e024dULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000083a287824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff828257812ULL, 0x000fe200078ee225ULL,
0x000000083c2a7824ULL, 0x000fe400078e00ffULL, 0x0000001020417824ULL, 0x000fe200078e024dULL,
0x000000700a207812ULL, 0x000fe200078ef803ULL, 0x0000001022457824ULL, 0x000fe200078e024dULL,
0x0000007014227812ULL, 0x000fe200078ef803ULL, 0x000000015c087824ULL, 0x000fe200078e0218ULL,
0xfffffff82a277812ULL, 0x000fe200078ee227ULL, 0x0000001024497824ULL, 0x000fe200078e024dULL,
0x0000007016247812ULL, 0x000fe200078ef803ULL, 0x000000101f3f7824ULL, 0x000fe200078e024dULL,
0x000000204f207210ULL, 0x000fe20007f3e0ffULL, 0x00000001091f7824ULL, 0x000fe200000e0651ULL,
0x000000224f227210ULL, 0x040fe20007f1e0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000244f247210ULL, 0x000fc40007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e0f7faeULL, 0x0003e2000b901c46ULL, 0x000000015c0a7824ULL, 0x000fe400078e0219ULL,
0x000000101a397824ULL, 0x100fe400078e024dULL, 0x000000101c3b7824ULL, 0x100fe400078e024dULL,
0x0000001021437824ULL, 0x100fe400078e024dULL, 0x0000001023477824ULL, 0x100fe400078e024dULL,
0x00000010254b7824ULL, 0x000fc400078e024dULL, 0x000000015c147824ULL, 0x000fe400078e021bULL,
0x00000010274d7824ULL, 0x000fe200078e024dULL, 0x0000007008277812ULL, 0x000fe200078ef803ULL,
0x000000015c167824ULL, 0x040fe400078e021dULL, 0x000000010b217824ULL, 0x100fe400008e0651ULL,
0x000000015c187824ULL, 0x000fe400078e0226ULL, 0x0000000115237824ULL, 0x100fe200000e0651ULL,
0x000000274f267210ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000020317faeULL, 0x0003e6000b901c46ULL, 0x0000000117257824ULL, 0x000fe200010e0651ULL,
0x000000700a287812ULL, 0x100fe200078ef803ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000022337faeULL, 0x0003e6000b901c46ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000070142a7812ULL, 0x100fe200078ef803ULL, 0x0000000024357faeULL, 0x0003e4000b901c46ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070162c7812ULL, 0x000fc400078ef803ULL,
0x0000002a4f2a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109277824ULL, 0x000fe200000e0651ULL,
0x00000070182e7812ULL, 0x000fe200078ef803ULL, 0x000000015c087824ULL, 0x040fe200078e0230ULL,
0x000000284f287210ULL, 0x040fe20007f1e0ffULL, 0x000000015c0a7824ULL, 0x040fe200078e0232ULL,
0x0000002c4f2c7210ULL, 0x040fe20007f5e0ffULL, 0x000000015c147824ULL, 0x040fe200078e0234ULL,
0x0000002e4f2e7210ULL, 0x000fe20007f7e0ffULL, 0x000000015c167824ULL, 0x000fe200078e0236ULL,
0x0000000026377faeULL, 0x0003e2000b901c46ULL, 0x000000010b297824ULL, 0x000fc400000e0651ULL,
0x000000015c187824ULL, 0x000fe400078e0238ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000028397faeULL, 0x0003e6000b901c46ULL, 0x00000001152b7824ULL, 0x000fe200008e0651ULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x000000015c1a7824ULL, 0x000fe400078e023aULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000084f087210ULL, 0x000fe20007f1e0ffULL,
0x000000002a3b7faeULL, 0x0003e4000b901c46ULL, 0x00000001172d7824ULL, 0x000fe200010e0651ULL,
0x000000700a0a7812ULL, 0x000fe200078ef803ULL, 0x000000015c1c7824ULL, 0x000fc400078e023cULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a4f0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000002c3d7faeULL, 0x0003e4000b901c46ULL, 0x00000001192f7824ULL, 0x000fe200018e0651ULL,
0x0000007014147812ULL, 0x000fe200078ef803ULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x000000144f147210ULL, 0x040fe20007f5e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x100fe200078ef803ULL, 0x000000002e3f7faeULL, 0x0003e4000b901c46ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018187812ULL, 0x100fe400078ef803ULL,
0x000000164f167210ULL, 0x000fe20007f7e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a1a7812ULL, 0x000fc400078ef803ULL, 0x000000184f187210ULL, 0x000fe20007f9e0ffULL,
0x0000000109097824ULL, 0x000fe200000e0651ULL, 0x000000701c037812ULL, 0x000fe200078ef803ULL,
0x000000010b0b7824ULL, 0x100fe200008e0651ULL, 0x0000001a4f1a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000115157824ULL, 0x100fe200010e0651ULL, 0x000000034f1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000117177824ULL, 0x100fe200018e0651ULL, 0x0000000008417faeULL, 0x0003e2000b901c46ULL,
0x0000000119197824ULL, 0x100fe400020e0651ULL, 0x000000011b1b7824ULL, 0x100fe200028e0651ULL,
0x000000000a437faeULL, 0x0003e2000b901c46ULL, 0x000000011d1d7824ULL, 0x000fc600030e0651ULL,
0x0000000014457faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x000000001a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c4d7faeULL, 0x0003e4000b901c46ULL, 0x0000000411127810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000d1200720cULL, 0x000fda0003f06070ULL, 0x0000000204038824ULL, 0x000fc800078e00ffULL,
0x00006a0003088a24ULL, 0x000fc800078e0212ULL, 0x0000660008088625ULL, 0x000fca00078e0005ULL,
0x00000006080f8981ULL, 0x000322000c1e1900ULL, 0x00005800ff037624ULL, 0x000fca00078e00ffULL,
0x0000001f03037810ULL, 0x000fc80007ffe0ffULL, 0x00000005ff1d7819ULL, 0x000fc40000011603ULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x01a60400ff037984ULL, 0x000e620000000800ULL,
0x0000001d02027224ULL, 0x000fe400078e02ffULL, 0x000000010e5e7824ULL, 0x000fe400078e0a13ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0005ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000002011057824ULL, 0x002fca00078e0206ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080a7824ULL, 0x040fe400078e0207ULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x00000010060b7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006147824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0x000001f00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f014097812ULL, 0x000fe200078ee209ULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000a147984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x0000000009187984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff227224ULL, 0x002fe400078e0014ULL, 0x000000ffff237224ULL, 0x000fe400078e0016ULL,
0x000000ffff207224ULL, 0x004fe400078e0018ULL, 0x000000ffff217224ULL, 0x000fc400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0015ULL, 0x000000ffff277224ULL, 0x000fe200078e0017ULL,
0x0000002009007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff247224ULL, 0x000fe400078e0019ULL,
0x000000ffff257224ULL, 0x000fca00078e001bULL, 0x000000240a007388ULL, 0x000fe8000000cc00ULL,
0x0000000007147984ULL, 0x000e68000000cc00ULL, 0x0000000005187984ULL, 0x000ea2000000cc00ULL,
0x000000ffff2b7224ULL, 0x002fe400078e0016ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff287224ULL, 0x004fe400078e0018ULL,
0x000000ffff297224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002805007388ULL, 0x0003e8000000cc00ULL,
0x0000001407007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff147224ULL, 0x002fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000005f7919ULL, 0x000e620000000000ULL, 0x00006a0004617a24ULL, 0x000fe200078e02ffULL,
0x000001005d687810ULL, 0x000fe20007ffe0ffULL, 0x000000021d607824ULL, 0x000fe200078e00ffULL,
0x0001a68811677811ULL, 0x000fe200078e18ffULL, 0x3db504f369697820ULL, 0x010fe20000410000ULL,
0xffffffff13667810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0x0000000913657810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x0001a60811647811ULL, 0x000fc400078e28ffULL, 0x0000000263057810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000f00237224ULL, 0x010fe200078e02ffULL,
0x000000016a627812ULL, 0x000fc400078e0cffULL, 0x0000000c0500720cULL, 0x000fda0003f06070ULL,
0x00000cd000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff1e7819ULL, 0x102fe2000001165fULL,
0x0000010063057824ULL, 0x000fe200078e0268ULL, 0x0000640023217a11ULL, 0x000fe200078438ffULL,
0x00000002111c7824ULL, 0x000fe200078e0262ULL, 0x000000041e067810ULL, 0x000fe40007ffe0ffULL,
0x000000050e047217ULL, 0x000fe40007800000ULL, 0x000000101e1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106077824ULL, 0x000fe200078e025fULL, 0x0000000c1e187810ULL, 0x000fe20007ffe0ffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x000000081e087810ULL, 0x000fe20007ffe0ffULL,
0x00000001040f7824ULL, 0x000fe200078e0a05ULL, 0x000000141e207810ULL, 0x000fe20007ffe0ffULL,
0x000000011a057824ULL, 0x000fe200078e025fULL, 0xfffffff80a1d7812ULL, 0x000fe200078ee207ULL,
0x000000081a0a7824ULL, 0x000fe200078e00ffULL, 0x000000181e227810ULL, 0x000fe20007ffe0ffULL,
0x0000000118047824ULL, 0x000fe200078e025fULL, 0x0000001c1e247810ULL, 0x000fe20007ffe0ffULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0xfffffff80a297812ULL, 0x000fe200078ee205ULL,
0x000000105f057824ULL, 0x000fe200078e00ffULL, 0x0000000f0600720cULL, 0x080fe20003f26070ULL,
0x0000000108097824ULL, 0x140fe200078e025fULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x0000000808147824ULL, 0x000fe200078e00ffULL, 0x0000007005257812ULL, 0x000fe200078ec0ffULL,
0x000000015c047824ULL, 0x000fe200078e021eULL, 0x0000000f0800720cULL, 0x000fe20003f06070ULL,
0x0000000120077824ULL, 0x000fe200078e025fULL, 0xfffffff8141f7812ULL, 0x000fe200078ee209ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000650023237a11ULL, 0x000fc400010f3cffULL,
0x000000201e267810ULL, 0x000fe20007ffe0ffULL, 0x0000000820147824ULL, 0x000fe200078e00ffULL,
0x00000025040a7212ULL, 0x000fe200078efcffULL, 0x000000015c067824ULL, 0x000fe200078e0206ULL,
0x0000000f1a00720cULL, 0x000fe20003fa6070ULL, 0x0000000122097824ULL, 0x000fe200078e025fULL,
0xfffffff8142b7812ULL, 0x000fe200078ee207ULL, 0x0000000822167824ULL, 0x000fe200078e00ffULL,
0x0000000a210a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001240b7824ULL, 0x000fe200078e025fULL,
0x000020001c1c7811ULL, 0x000fe200078e68ffULL, 0x0000000824047824ULL, 0x000fe200078e00ffULL,
0xfffffff8162d7812ULL, 0x000fe200078ee209ULL, 0x000000015c087824ULL, 0x000fc400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff8042f7812ULL, 0x000fc600078ee20bULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002506147212ULL, 0x000fc600078efcffULL,
0x000000015c047824ULL, 0x000fe200078e0218ULL, 0x0000002508167212ULL, 0x000fe200078efcffULL,
0x00000001050b7824ULL, 0x000fe200010e0623ULL, 0x0000002114147210ULL, 0x080fe20007f7e0ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fe40007f9e0ffULL,
0x0000000f1800720cULL, 0x000fe20003f46070ULL, 0x000000015c067824ULL, 0x000fe200078e021aULL,
0x0000002504187212ULL, 0x000fe200078efcffULL, 0x000000011e087824ULL, 0x000fc400078e025fULL,
0x0000000107157824ULL, 0x000fe200018e0623ULL, 0x0000000f1e00720cULL, 0x000fe20003f66070ULL,
0x0000000126197824ULL, 0x000fe200078e025fULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000826047824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff804317812ULL, 0x000fe200078ee219ULL, 0x0000000109177824ULL, 0x000fe200020e0623ULL,
0x0000002118187210ULL, 0x000fe20007f9e0ffULL, 0x000000015c047824ULL, 0x000fe200078e0220ULL,
0x00000025061a7212ULL, 0x000fe200078efcffULL, 0x000000015c067824ULL, 0x000fe200078e0222ULL,
0x0ffffff808097812ULL, 0x000fe200078ef85fULL, 0x0000000105197824ULL, 0x000fe200020e0623ULL,
0x000000211a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000000f2000720cULL, 0x000fc40003f86070ULL, 0x000000241e207810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x100fe200078e021cULL, 0x0000002504047212ULL, 0x000fe200078efcffULL,
0x00000001071b7824ULL, 0x000fe400030e0623ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000d901c46ULL,
0x0000000f2200720cULL, 0x000fe40003f66070ULL, 0x000000101d1d7824ULL, 0x000fe400078e021cULL,
0x000000015c087824ULL, 0x000fc400078e0224ULL, 0x0000000120227824ULL, 0x040fe200078e025fULL,
0x00000000141d7faeULL, 0x0005e2000c901c46ULL, 0x0000000820337824ULL, 0x000fe200078e00ffULL,
0x0000000f2400720cULL, 0x000fe40003f26070ULL, 0x00000021040a7210ULL, 0x002fe20007fde0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002506047212ULL, 0x080fe400078efcffULL,
0xfffffff833337812ULL, 0x000fe200078ee222ULL, 0x00000001050b7824ULL, 0x100fe200030e0623ULL,
0x0000002508087212ULL, 0x000fe200078efcffULL, 0x000000015c067824ULL, 0x000fe200078e0220ULL,
0x0000002104147210ULL, 0x084fe20007fde0ffULL, 0x000000015c047824ULL, 0x000fe200078e0226ULL,
0x000000281e227810ULL, 0x040fe20007ffe0ffULL, 0x000000101f1d7824ULL, 0x000fe200078e021cULL,
0x0000002c1e247810ULL, 0x000fe20007ffe0ffULL, 0x0000000107157824ULL, 0x000fe200030e0623ULL,
0x0000002108087210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x0000000f2600720cULL, 0x000fc40003f06070ULL,
0x0000001027077824ULL, 0x100fe400078e021cULL, 0x0000000109097824ULL, 0x000fe400030e0623ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0x0000000018077faeULL, 0x0005e2000d101c46ULL,
0x0000000f2000720cULL, 0x000fe20003f46070ULL, 0x0000000822207824ULL, 0x000fe200078e00ffULL,
0x0000002504167212ULL, 0x002fe200078efcffULL, 0x0000000122177824ULL, 0x100fe400078e025fULL,
0x0000000124047824ULL, 0x000fe200078e025fULL, 0x0000002116167210ULL, 0x000fe20007fde0ffULL,
0x00000010291d7824ULL, 0x000fe200078e021cULL, 0xfffffff820277812ULL, 0x000fc400078ee217ULL,
0xfffffff81f297812ULL, 0x000fe200078ee204ULL, 0x0000000105177824ULL, 0x000fe200030e0623ULL,
0x000000301e207810ULL, 0x000fe20007ffe0ffULL, 0x0000008006047825ULL, 0x000fe200078e00ffULL,
0x000000001a1d7faeULL, 0x0003e2000e901c46ULL, 0x0000000f2200720cULL, 0x000fe40003fa6070ULL,
0x000000015c067824ULL, 0x000fe200078e0222ULL, 0x0000002504187212ULL, 0x004fe200078efcffULL,
0x000000015c047824ULL, 0x000fe400078e0224ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002118187210ULL, 0x000fc60007fde0ffULL, 0x000000102b1f7824ULL, 0x100fe200078e021cULL,
0x0000002506067212ULL, 0x000fe200078efcffULL, 0x0000000105197824ULL, 0x000fe400030e0623ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x000000000a1f7faeULL, 0x0005e2000e101c46ULL,
0x0000000f2400720cULL, 0x000fe40003f86070ULL, 0x000000102d1d7824ULL, 0x002fe200078e021cULL,
0x00000025041a7212ULL, 0x000fe200078efcffULL, 0x00000001201b7824ULL, 0x000fe200078e025fULL,
0x000000341e047810ULL, 0x000fe20007ffe0ffULL, 0x0000000820227824ULL, 0x040fe200078e00ffULL,
0x00000000141d7faeULL, 0x0003e2000d901c46ULL, 0x0000000f2000720cULL, 0x000fc40003f66070ULL,
0x00000021060a7210ULL, 0x084fe20007fde0ffULL, 0x000000015c067824ULL, 0x000fe200078e0220ULL,
0xfffffff8222b7812ULL, 0x000fe200078ee21bULL, 0x000000102f1f7824ULL, 0x000fe200078e021cULL,
0x000000381e207810ULL, 0x000fe20007ffe0ffULL, 0x00000001070b7824ULL, 0x100fe200030e0623ULL,
0x000000211a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000000081f7faeULL, 0x0005e2000c901c46ULL, 0x0000000f0400720cULL, 0x000fe40003f26070ULL,
0x00000001051b7824ULL, 0x000fe200030e0623ULL, 0x0000002506147212ULL, 0x002fe200078efcffULL,
0x0000000104057824ULL, 0x000fe200078e025fULL, 0x0000003c1e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x000000015c047824ULL, 0x000fc400078e0204ULL, 0x00000010311d7824ULL, 0x000fe200078e021cULL,
0xfffffff8062d7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x000000015c067824ULL, 0x000fe200078e0220ULL,
0x0000002504087212ULL, 0x004fe200078efcffULL, 0x0000000107157824ULL, 0x000fe200030e0623ULL,
0x0000000f1e00720cULL, 0x000fe20003f06070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002108087210ULL, 0x000fc60007fde0ffULL, 0x00000010331f7824ULL, 0x000fe200078e021cULL,
0x0000002506067212ULL, 0x000fe200078efcffULL, 0x000000015c047824ULL, 0x000fe400078e021eULL,
0x0000000105097824ULL, 0x000fe200030e0623ULL, 0x00000000181f7faeULL, 0x0005e2000d101c46ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000000f2000720cULL, 0x000fe40003f46070ULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x00000001200f7824ULL, 0x000fe200078e025fULL,
0x0000002504047212ULL, 0x000fe200078efcffULL, 0x0000000820207824ULL, 0x000fc400078e00ffULL,
0x000000011e167824ULL, 0x042fe400078e025fULL, 0x000000081e177824ULL, 0x000fe200078e00ffULL,
0xfffffff8201f7812ULL, 0x004fe200078ee20fULL, 0x0000000107077824ULL, 0x000fe200030e0623ULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x00000010270f7824ULL, 0x000fe200078e021cULL,
0xfffffff817257812ULL, 0x000fe200078ee216ULL, 0x0000001029177824ULL, 0x100fe400078e021cULL,
0x000000102b197824ULL, 0x100fe200078e021cULL, 0x000000000a0f7faeULL, 0x0003e2000e901c46ULL,
0x000000102d1d7824ULL, 0x000fc400078e021cULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x000000001a177faeULL, 0x0003e2000e101c46ULL, 0x0000001025217824ULL, 0x000fe400078e021cULL,
0x0000000105057824ULL, 0x000fe200030e0623ULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x00000000081d7faeULL, 0x0003e8000c901c46ULL, 0x00000000061f7faeULL, 0x0003e8000d101c46ULL,
0x0000000004217faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x000000045f077811ULL, 0x042fe400078fe8ffULL, 0x000000085f087811ULL, 0x000fc400078fe8ffULL,
0x000000105f147811ULL, 0x000fe200078fe8ffULL, 0x0000000107047824ULL, 0x100fe200078e025fULL,
0x0000000c5f097811ULL, 0x000fe200078fe8ffULL, 0x00000008072d7824ULL, 0x000fe200078e00ffULL,
0x000000185f177811ULL, 0x040fe200078fe8ffULL, 0x00000008082f7824ULL, 0x000fe200078e00ffULL,
0x000000205f1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000114067824ULL, 0x100fe200078e025fULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL, 0x0000000108047824ULL, 0x100fe200078e025fULL,
0x0000001c5f197811ULL, 0x040fe200078fe8ffULL, 0x0000000814337824ULL, 0x000fe200078e00ffULL,
0x000000285f1f7811ULL, 0x000fe200078fe8ffULL, 0x0000000109057824ULL, 0x100fe200078e025fULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x0000000809187824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x0000000117047824ULL, 0x000fe200078e025fULL,
0x000000145f167811ULL, 0x000fe200078fe8ffULL, 0x0000000817377824ULL, 0x000fe200078e00ffULL,
0xfffffff818317812ULL, 0x000fe200078ee205ULL, 0x000000011b067824ULL, 0x100fe200078e025fULL,
0x000000305f247811ULL, 0x000fe200078fe8ffULL, 0x000000081b3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee204ULL, 0x0000000119057824ULL, 0x100fe200078e025fULL,
0x0000002c5f217811ULL, 0x000fe200078fe8ffULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee206ULL, 0x000000011f047824ULL, 0x000fe200078e025fULL,
0x000000245f1e7811ULL, 0x000fe200078fe8ffULL, 0x000000081f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff818397812ULL, 0x000fe200078ee205ULL, 0x00000001160a7824ULL, 0x140fe200078e025fULL,
0x000000385f277811ULL, 0x000fe200078fe8ffULL, 0x0000000816357824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL, 0x0000000124067824ULL, 0x140fe200078e025fULL,
0x0000005f5f047211ULL, 0x000fe200078fe8ffULL, 0x0000000824437824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20aULL, 0x0000000121057824ULL, 0x100fe200078e025fULL,
0x000000345f257811ULL, 0x000fe200078fe8ffULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee206ULL, 0x000000011e0a7824ULL, 0x000fe200078e025fULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000081e3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818417812ULL, 0x000fe200078ee205ULL, 0x0000000127067824ULL, 0x140fe200078e025fULL,
0x0ffffff8040f7812ULL, 0x100fe200078ef85fULL, 0x0000000827477824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20aULL, 0x0000000211057824ULL, 0x000fe200078e0262ULL,
0x0000003c5f297811ULL, 0x000fe200078fe8ffULL, 0x00000001250a7824ULL, 0x100fe200078e025fULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000825457824ULL, 0x000fe200078e00ffULL,
0x0000200005067811ULL, 0x000fe200078e68ffULL, 0x000000105f047824ULL, 0x040fe200078e00ffULL,
0x0000005c5f057211ULL, 0x000fe200078fe8ffULL, 0x0000000829497824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20aULL, 0x00000001290a7824ULL, 0x000fe200078e025fULL,
0x00000070044b7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e00ffULL,
0x00006400234d7a11ULL, 0x000fc400078038ffULL, 0xfffffff849497812ULL, 0x000fe200078ee20aULL,
0x000000015c087824ULL, 0x000fe200078e0208ULL, 0x0000004b04047212ULL, 0x000fe200078efcffULL,
0x000000015c0a7824ULL, 0x000fe200078e0209ULL, 0x00006500234f7a11ULL, 0x000fe200000f3cffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000044d047210ULL, 0x000fc60007f1e0ffULL,
0x000000015c147824ULL, 0x000fe200078e0214ULL, 0x0000004b08087212ULL, 0x000fe200078efcffULL,
0x000000015c077824ULL, 0x000fe400078e0207ULL, 0x000000100f0f7824ULL, 0x100fe400078e0206ULL,
0x000000102d2d7824ULL, 0x100fe400078e0206ULL, 0x000000102f2f7824ULL, 0x100fe400078e0206ULL,
0x0000001031317824ULL, 0x000fc400078e0206ULL, 0x0000001033337824ULL, 0x100fe400078e0206ULL,
0x0000001035357824ULL, 0x100fe400078e0206ULL, 0x0000001037377824ULL, 0x100fe400078e0206ULL,
0x0000001039397824ULL, 0x100fe400078e0206ULL, 0x000000103b3b7824ULL, 0x100fe400078e0206ULL,
0x000000103d3d7824ULL, 0x000fc400078e0206ULL, 0x000000103f3f7824ULL, 0x100fe400078e0206ULL,
0x0000001041417824ULL, 0x100fe400078e0206ULL, 0x0000001043437824ULL, 0x100fe400078e0206ULL,
0x0000001045457824ULL, 0x100fe400078e0206ULL, 0x0000001047477824ULL, 0x100fe400078e0206ULL,
0x0000001049497824ULL, 0x000fc400078e0206ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x0000004b14147212ULL, 0x000fc600078efcffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000004b06067212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e064fULL, 0x000000084d087210ULL, 0x040fe20007f1e0ffULL,
0x000000015c167824ULL, 0x000fe200078e0216ULL, 0x0000004b0a0a7212ULL, 0x000fe200078efcffULL,
0x000000015c187824ULL, 0x040fe200078e0217ULL, 0x000000064d067210ULL, 0x040fe20007f3e0ffULL,
0x000000015c1a7824ULL, 0x040fe200078e0219ULL, 0x0000000a4d0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000015c1c7824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004b16167212ULL, 0x000fc600078efcffULL,
0x0000000109097824ULL, 0x000fe200000e064fULL, 0x000000144d147210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004b18187212ULL, 0x000fc600078efcffULL,
0x000000015c1e7824ULL, 0x000fe200078e021eULL, 0x0000004b1a1a7212ULL, 0x000fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x000000015c207824ULL, 0x000fe200078e021fULL,
0x0000004b1c1c7212ULL, 0x000fe200078efcffULL, 0x000000015c227824ULL, 0x040fe400078e0221ULL,
0x000000015c247824ULL, 0x040fe200078e0224ULL, 0x0000001c4d1c7210ULL, 0x000fe20007f7e0ffULL,
0x000000015c267824ULL, 0x000fe400078e0225ULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x000000015c287824ULL, 0x000fe200078e0227ULL, 0x0000004b1e1e7212ULL, 0x000fe200078efcffULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x0000000115157824ULL, 0x000fe200000e064fULL,
0x000000164d167210ULL, 0x000fe20007f1e0ffULL, 0x000000015c2a7824ULL, 0x000fe200078e0229ULL,
0x0000004b20207212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x0000000107077824ULL, 0x100fe200008e064fULL, 0x000000184d187210ULL, 0x000fe20007f3e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000004b22227212ULL, 0x080fe400078efcffULL,
0x00000000062d7faeULL, 0x0003e2000b901c46ULL, 0x000000010b0b7824ULL, 0x100fe200010e064fULL,
0x0000001a4d1a7210ULL, 0x040fe20007f5e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004b24247212ULL, 0x080fe200078efcffULL, 0x00000000082f7faeULL, 0x0003e4000b901c46ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000004b26267212ULL, 0x080fe200078efcffULL,
0x000000000a317faeULL, 0x0003e4000b901c46ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000004b28287212ULL, 0x080fe200078efcffULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x000000264d267210ULL, 0x000fe20007f9e0ffULL, 0x0000000117177824ULL, 0x100fe200000e064fULL,
0x0000001e4d1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000119197824ULL, 0x100fe200008e064fULL,
0x000000204d207210ULL, 0x000fe20007f3e0ffULL, 0x000000011b1b7824ULL, 0x100fe200010e064fULL,
0x0000004b2a2a7212ULL, 0x000fe200078efcffULL, 0x000000011d1d7824ULL, 0x100fe200018e064fULL,
0x000000224d227210ULL, 0x000fe20007f5e0ffULL, 0x000000011f1f7824ULL, 0x100fe200000e064fULL,
0x000000244d247210ULL, 0x000fe20007f7e0ffULL, 0x0000000121217824ULL, 0x100fe200008e064fULL,
0x000000284d287210ULL, 0x040fe20007fbe0ffULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x0000002a4d2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000123237824ULL, 0x000fc400010e064fULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x0000000125257824ULL, 0x100fe400018e064fULL,
0x0000000127277824ULL, 0x100fe200020e064fULL, 0x000000001a397faeULL, 0x0003e2000b901c46ULL,
0x0000000129297824ULL, 0x100fe400028e064fULL, 0x000000012b2b7824ULL, 0x000fe200030e064fULL,
0x000000001c3b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e3d7faeULL, 0x0003e8000b901c46ULL,
0x00000000203f7faeULL, 0x0003e8000b901c46ULL, 0x0000000022417faeULL, 0x0003e8000b901c46ULL,
0x0000000024437faeULL, 0x0003e8000b901c46ULL, 0x0000000026457faeULL, 0x0003e8000b901c46ULL,
0x0000000028477faeULL, 0x0003e8000b901c46ULL, 0x000000002a497faeULL, 0x0003e4000b901c46ULL,
0x0000000412127810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0f7424ULL, 0x002fc400078e00ffULL, 0x0000000d1200720cULL, 0x000fe20003f06070ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fd4000001ff00ULL, 0x0000000261148824ULL, 0x000fe400078e0212ULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000660014148625ULL, 0x000fe200078e0015ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000006140f8981ULL, 0x000322000c1e1900ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff85f4c7812ULL, 0x020fe200078ec0ffULL, 0x0000000211827824ULL, 0x000fe200078e026aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016b857810ULL, 0x000fc40007ffe0ffULL,
0x000000074c507812ULL, 0x000fe400078ef85fULL, 0x0000200082827811ULL, 0x000fe400078e68ffULL,
0x000000085f847812ULL, 0x000fe200078ec0ffULL, 0x00000001504c7824ULL, 0x040fe200078e026bULL,
0x00000004ff887819ULL, 0x100fe2000001165fULL, 0x00000008504d7824ULL, 0x000fe200078e00ffULL,
0x0000000784847812ULL, 0x000fe200078ef85fULL, 0x0000000850517824ULL, 0x040fe400078e00ffULL,
0x0000000150507824ULL, 0x000fe200078e0285ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL,
0x000000026b887824ULL, 0x000fe200078e0288ULL, 0x0000001084837812ULL, 0x000fc400078efcffULL,
0xfffffff851517812ULL, 0x000fe200078ee250ULL, 0x000000104d4d7824ULL, 0x000fc800078e0282ULL,
0x0000001051517824ULL, 0x000fe400078e0282ULL, 0x000000004d4c783bULL, 0x000e680000000200ULL,
0x000000005150783bULL, 0x000ea20000000200ULL, 0x00000018ff547819ULL, 0x002fe2000001144cULL,
0x000100004c557824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001144dULL,
0x000100004d5a7824ULL, 0x040fe200078e00ffULL, 0x00000054008e7306ULL, 0x0003e20000200c00ULL,
0x000088804d597816ULL, 0x040fe200000000ffULL, 0x000001004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc40000011455ULL, 0x000088804c567816ULL, 0x040fe200000000ffULL,
0x000001004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x00000058008d7306ULL, 0x0007e20000200c00ULL, 0x000000205f547810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0xfffffff854547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001144fULL, 0x0000004d00927306ULL, 0x0003e20000200c00ULL,
0x00000007548a7812ULL, 0x000fe200078ef85fULL, 0x000100004e587824ULL, 0x008fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x004fc40000011450ULL, 0x000088804f867816ULL, 0x040fe200000000ffULL,
0x000000018a547824ULL, 0x000fe200078e026bULL, 0x0000888050707816ULL, 0x000fe200000000ffULL,
0x000000088a557824ULL, 0x000fe200078e00ffULL, 0x00000056008c7306ULL, 0x0004e20000200c00ULL,
0x000100004f4d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001144eULL,
0x000001004f4f7824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe400078ee254ULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000004c008f7306ULL, 0x0002e20000200c00ULL,
0x0000001055557824ULL, 0x000fe200078e0282ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x000000005554783bULL, 0x004ea20000000200ULL, 0x0000004d00897306ULL, 0x0007e20000200c00ULL,
0x000088804e4c7816ULL, 0x042fe200000000ffULL, 0x000001004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011451ULL, 0x0000888051737816ULL, 0x040fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004c00937306ULL, 0x0003e20000200c00ULL,
0x00010000514d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011453ULL,
0x0000010051517824ULL, 0x000fe200078e00ffULL, 0x0000888053797816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004f008b7306ULL, 0x0007e20000200c00ULL,
0x00010000504c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc40000011452ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000004d00767306ULL, 0x0003e20000200c00ULL, 0x00000010844f7824ULL, 0x008fe200078e00ffULL,
0x0000888052747816ULL, 0x000fe400000000ffULL, 0x000054108c8c7816ULL, 0x000fe4000000008dULL,
0x000054108f8d7816ULL, 0x000fe4000000008eULL, 0x0000004c00717306ULL, 0x0007e20000200c00ULL,
0x00000001834d7824ULL, 0x002fe200078e0288ULL, 0x000000026b6b7810ULL, 0x000fc40007ffe0ffULL,
0x00000018ff817819ULL, 0x004fc80000011454ULL, 0x0000005000727306ULL, 0x0003e20000200c00ULL,
0x00000001844c7824ULL, 0x008fe200078e0288ULL, 0x00000018ff7f7819ULL, 0x000fe40000011455ULL,
0x00000018ff7d7819ULL, 0x000fe40000011456ULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000005800947306ULL, 0x0004e20000200c00ULL, 0x0000001083507824ULL, 0x002fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc40000011457ULL, 0x0000000288887810ULL, 0x000fe40007ffe0ffULL,
0xfffffff0504d7812ULL, 0x000fe200078ee24dULL, 0x0001000053507824ULL, 0x000fe200078e00ffULL,
0x0000004e00957306ULL, 0x0003e20000200c00ULL, 0x000000104c587824ULL, 0x004fe200078e00ffULL,
0x000000086b00780cULL, 0x000fe20003f05270ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011450ULL, 0x0000010053537824ULL, 0x000fe200078e00ffULL,
0x0000888054507816ULL, 0x000fc400000000ffULL, 0x0000005900907306ULL, 0x000fe20000200c00ULL,
0x00010000524e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000010052527824ULL, 0x000fe200078e00ffULL, 0x0000541093947816ULL, 0x008fe40000000094ULL,
0x00000018ff777819ULL, 0x000fe4000001144eULL, 0x0000005a00917306ULL, 0x0002a20000200c00ULL,
0x000000004d4c783bULL, 0x000ee20000000200ULL, 0x00000018ff527819ULL, 0x000fcc0000011452ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x000000005858783bULL, 0x002e6e0000000200ULL,
0x0000005100757306ULL, 0x0005e40000200c00ULL, 0x0000541090907816ULL, 0x004fcc0000000091ULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0001000054517824ULL, 0x000fe200078e00ffULL,
0x0000541092917816ULL, 0x000fe20000000087ULL, 0x0001000056877824ULL, 0x000fe400078e00ffULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000005100977306ULL, 0x0003e20000200c00ULL,
0x0000541095957816ULL, 0x004fe20000000080ULL, 0x0000008c4c28723cULL, 0x008fe20000001828ULL,
0x0000888057807816ULL, 0x000fca00000000ffULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x0000010055517824ULL, 0x042fe200078e00ffULL, 0x0000008c5848723cULL, 0x040b6c0000001848ULL,
0x00000053007b7306ULL, 0x0003e40000200c00ULL, 0x000000905844723cULL, 0x040f6c0000001844ULL,
0x0000005000967306ULL, 0x0007e20000200c00ULL, 0x000000018a537824ULL, 0x042fe200078e0285ULL,
0x00000018ff857819ULL, 0x000fe20000011451ULL, 0x000000088a8a7824ULL, 0x000fe200078e00ffULL,
0x0000888056517816ULL, 0x040fe200000000ffULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x0000541086867816ULL, 0x004fe20000000089ULL, 0x000000945840723cULL, 0x000fe20000001840ULL,
0x0000005200787306ULL, 0x0003e20000200c00ULL, 0x0001000055507824ULL, 0x008fe200078e00ffULL,
0xfffffff88a537812ULL, 0x000fc400078ee253ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000001053537824ULL, 0x000fe200078e0282ULL,
0x00000085008a7306ULL, 0x000fe20000200c00ULL, 0x0000888055527816ULL, 0x002fe200000000ffULL,
0x000000ffff827224ULL, 0x000fe200078e0051ULL, 0x000000904c24723cULL, 0x040f6a0000001824ULL,
0x0000008700857306ULL, 0x0003e60000200c00ULL, 0x000000944c20723cULL, 0x000fea0000001820ULL,
0x00000052008e7306ULL, 0x000fe20000200c00ULL, 0x000054108b877816ULL, 0x002fe2000000007eULL,
0x000000ffff7e7224ULL, 0x000fc400078e0080ULL, 0x0001000057807824ULL, 0x040fe400078e00ffULL,
0x0000010057577824ULL, 0x000fe400078e00ffULL, 0x0000005000557306ULL, 0x0003e20000200c00ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000086583c723cULL, 0x000fe2000000183cULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000005350783bULL, 0x002e620000000200ULL, 0x000000864c1c723cULL, 0x000bec000000181cULL,
0x0000007f007f7306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000054108a7f7816ULL, 0x004fce000000007fULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x00000082008c7306ULL, 0x0202f00000200c00ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541054817816ULL, 0x004fc40000000081ULL,
0x00000018ff827819ULL, 0x002fca0000011450ULL, 0x0000007e00897306ULL, 0x0003e20000200c00ULL,
0x000054108c8c7816ULL, 0x008fe40000000085ULL, 0x00000018ff857819ULL, 0x000fca0000011453ULL,
0x0000008000867306ULL, 0x0004e20000200c00ULL, 0x000054108e7e7816ULL, 0x002fe20000000055ULL,
0x0000001084557824ULL, 0x000fe200078e00ffULL, 0x00005410568d7816ULL, 0x000fe2000000007dULL,
0x0000000184847824ULL, 0x100fe400078e0288ULL, 0x0000000183887824ULL, 0x040fe400078e0288ULL,
0x0000005700877306ULL, 0x0002620000200c00ULL, 0x0000001083837824ULL, 0x000fe200078e00ffULL,
0xfffffff055847812ULL, 0x000fe200078ee284ULL, 0x0000007e5834723cULL, 0x040fe20000001834ULL,
0x0000541096807816ULL, 0x004fe20000000097ULL, 0x00010000507d7824ULL, 0x000fe200078e00ffULL,
0xfffffff083887812ULL, 0x000fe200078ee288ULL, 0x0000001084547824ULL, 0x000fe200078e00ffULL,
0x0000541089867816ULL, 0x008fe20000000086ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x00000018ff837819ULL, 0x000fe20000011451ULL, 0x0000001088887824ULL, 0x000fe200078e00ffULL,
0x000000805838723cULL, 0x000fe20000001838ULL, 0x000000005454783bULL, 0x002e620000000200ULL,
0x00000018ff847819ULL, 0x000fc40000011452ULL, 0x0000541087877816ULL, 0x000fe2000000007cULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x00008880507c7816ULL, 0x040fe200000000ffULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x0000008c5830723cULL, 0x000f620000001830ULL,
0x00000018ff7d7819ULL, 0x000fc6000001147dULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541070707816ULL, 0x004fe40000000071ULL,
0x00000086582c723cULL, 0x000be4000000182cULL, 0x000000008858783bULL, 0x020ea60000000200ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541072717816ULL, 0x008fc4000000006dULL,
0x000000804c18723cULL, 0x000fe20000001818ULL, 0x00008880526d7816ULL, 0x000fc800000000ffULL,
0x0000008400847306ULL, 0x000fe60000200c00ULL, 0x0000007e4c14723cULL, 0x040bea0000001814ULL,
0x00000050007f7306ULL, 0x020fe40000200c00ULL, 0x00008880517e7816ULL, 0x040fe200000000ffULL,
0x0000008c4c08723cULL, 0x040f6a0000001808ULL, 0x0000007c007c7306ULL, 0x000fe60000200c00ULL,
0x000000864c04723cULL, 0x000b6a0000001804ULL, 0x0000007d007d7306ULL, 0x000ee40000200c00ULL,
0x00010000514d7824ULL, 0x020fe200078e00ffULL, 0x000000705448723cULL, 0x002f620000001848ULL,
0x000000ffff4c7224ULL, 0x000fc400078e007eULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c004e7306ULL, 0x0003e60000200c00ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000000705828723cULL, 0x004f680000001828ULL,
0x0000004d004f7306ULL, 0x0004a20000200c00ULL, 0x00005410734c7816ULL, 0x002fc40000000076ULL,
0x000054107c7c7816ULL, 0x008fca000000007dULL, 0x0000005100507306ULL, 0x0003e20000200c00ULL,
0x00005410754d7816ULL, 0x004fe2000000006cULL, 0x000000ffff6c7224ULL, 0x000fe400078e006dULL,
0x00010000526d7824ULL, 0x040fe400078e00ffULL, 0x0000010052527824ULL, 0x000fe400078e00ffULL,
0x0000004c5444723cULL, 0x000f620000001844ULL, 0x0001000053517824ULL, 0x002fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000004c5824723cULL, 0x000b620000001824ULL, 0x000054104e4e7816ULL, 0x000fe4000000004fULL,
0x0000006d006d7306ULL, 0x000e680000200c00ULL, 0x00008880534c7816ULL, 0x060fe200000000ffULL,
0x0000010053537824ULL, 0x000fc600078e00ffULL, 0x00000052004d7306ULL, 0x000ea40000200c00ULL,
0x00000018ff537819ULL, 0x000fcc0000011453ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x000054106c6c7816ULL, 0x002fce000000006dULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054104d6d7816ULL, 0x004fce0000000084ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078757816ULL, 0x008fe2000000006fULL, 0x0000006c5430723cULL, 0x080b6c0000001830ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x000054107b7b7816ULL, 0x002fe2000000006eULL,
0x0000006c5808723cULL, 0x000b6c0000001808ULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541074747816ULL, 0x004fce0000000077ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x000000745440723cULL, 0x080b6e0000001840ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x00005410797a7816ULL, 0x002fe2000000007aULL,
0x000000745820723cULL, 0x000b6c0000001820ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054107f7d7816ULL, 0x004fe20000000082ULL, 0x0000007a543c723cULL, 0x080b6c000000183cULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00005410504f7816ULL, 0x008fe20000000083ULL,
0x0000007a581c723cULL, 0x000b6c000000181cULL, 0x0000005100517306ULL, 0x000e640000200c00ULL,
0x0000007c5438723cULL, 0x040b6c0000001838ULL, 0x0000005300527306ULL, 0x000ea40000200c00ULL,
0x0000004e5434723cULL, 0x000b620000001834ULL, 0x000054104c4c7816ULL, 0x002fce0000000051ULL,
0x0000007c5818723cULL, 0x000b620000001818ULL, 0x00005410524d7816ULL, 0x004fce0000000085ULL,
0x0000004e5814723cULL, 0x000b700000001814ULL, 0x0000004c542c723cULL, 0x080b70000000182cULL,
0x0000004c5804723cULL, 0x000b620000001804ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffee1000007947ULL, 0x000fcc000383ffffULL, 0x0000006947477220ULL, 0x080fe40000410000ULL,
0x000000694a4a7220ULL, 0x000fc40000410000ULL, 0x0000006946467220ULL, 0x080fe40000410000ULL,
0x0000006942427220ULL, 0x0a0fe40000410000ULL, 0x0000006943437220ULL, 0x080fe40000410000ULL,
0x000000693e3e7220ULL, 0x080fe40000410000ULL, 0x000000693f3f7220ULL, 0x080fe40000410000ULL,
0x000000693a3a7220ULL, 0x000fc40000410000ULL, 0x000000692c4f7220ULL, 0x080fe40000410000ULL,
0x0000006944587220ULL, 0x080fe40000410000ULL, 0x0000006939547220ULL, 0x080fe40000410000ULL,
0x0000006935527220ULL, 0x080fe40000410000ULL, 0x000000692f2c7220ULL, 0x080fe40000410000ULL,
0x0000006924247220ULL, 0x000fc40000410000ULL, 0x000000691c1c7220ULL, 0x080fe40000410000ULL,
0x000000691d1d7220ULL, 0x080fe40000410000ULL, 0x0000006914147220ULL, 0x080fe40000410000ULL,
0x0000006915157220ULL, 0x080fe40000410000ULL, 0x0000006904047220ULL, 0x080fe40000410000ULL,
0x0000006948577220ULL, 0x000fc40000410000ULL, 0x0000006936357220ULL, 0x080fe40000410000ULL,
0x0000006937447220ULL, 0x080fe40000410000ULL, 0x0000006931507220ULL, 0x080fe40000410000ULL,
0x0000006928397220ULL, 0x080fe40000410000ULL, 0x000000693c6a7220ULL, 0x080fe40000410000ULL,
0x000000693d5a7220ULL, 0x000fc40000410000ULL, 0x00000069385b7220ULL, 0x080fe40000410000ULL,
0x000000693b487220ULL, 0x080fe40000410000ULL, 0x0000006934537220ULL, 0x080fe40000410000ULL,
0x0000006930517220ULL, 0x080fe40000410000ULL, 0x0000006932367220ULL, 0x080fe40000410000ULL,
0x0000006933377220ULL, 0x000fc40000410000ULL, 0x000000692d4e7220ULL, 0x080fe40000410000ULL,
0x000000692e4c7220ULL, 0x080fe40000410000ULL, 0x000000692a287220ULL, 0x080fe40000410000ULL,
0x000000ffff317224ULL, 0x000fe400078e0047ULL, 0x0000006949567220ULL, 0x080fe40000410000ULL,
0x0000006945557220ULL, 0x000fc40000410000ULL, 0x00000069406b7220ULL, 0x080fe40000410000ULL,
0x0000006941597220ULL, 0x080fe40000410000ULL, 0x0000006929387220ULL, 0x080fe40000410000ULL,
0x00000069253b7220ULL, 0x080fe40000410000ULL, 0x00000069203c7220ULL, 0x080fe40000410000ULL,
0x00000069213d7220ULL, 0x000fc40000410000ULL, 0x00000069222a7220ULL, 0x080fe40000410000ULL,
0x00000069232d7220ULL, 0x000fe40000410000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e004aULL,
0x000000ffff2f7224ULL, 0x000fe400078e0046ULL, 0x000000ffff307224ULL, 0x000fe400078e0042ULL,
0x000000ffff477224ULL, 0x000fc400078e0043ULL, 0x000000ffff327224ULL, 0x000fe400078e003eULL,
0x000000ffff347224ULL, 0x000fe400078e003fULL, 0x000000ffff337224ULL, 0x000fe400078e003aULL,
0x000000694b4b7220ULL, 0x080fe40000410000ULL, 0x000000692b2b7220ULL, 0x080fe40000410000ULL,
0x0000006926267220ULL, 0x000fc40000410000ULL, 0x0000006927297220ULL, 0x080fe40000410000ULL,
0x000000691e1e7220ULL, 0x080fe40000410000ULL, 0x000000691f1f7220ULL, 0x080fe40000410000ULL,
0x0000006918407220ULL, 0x080fe40000410000ULL, 0x0000006919417220ULL, 0x080fe40000410000ULL,
0x000000691a257220ULL, 0x000fc40000410000ULL, 0x000000691b1b7220ULL, 0x080fe40000410000ULL,
0x0000006916167220ULL, 0x080fe40000410000ULL, 0x0000006917177220ULL, 0x080fe40000410000ULL,
0x00000069084d7220ULL, 0x080fe40000410000ULL, 0x0000006909457220ULL, 0x080fe40000410000ULL,
0x000000690a207220ULL, 0x000fc40000410000ULL, 0x000000690b217220ULL, 0x080fe40000410000ULL,
0x0000006905497220ULL, 0x080fe40000410000ULL, 0x0000006906227220ULL, 0x080fe40000410000ULL,
0x0000006907237220ULL, 0x000fe40000410000ULL, 0x000000ffff4a7224ULL, 0x000fe400078e002cULL,
0x000000ffff3a7224ULL, 0x000fc400078e0024ULL, 0x000000ffff3e7224ULL, 0x000fe400078e001cULL,
0x000000ffff3f7224ULL, 0x000fe400078e001dULL, 0x000000ffff427224ULL, 0x000fe400078e0014ULL,
0x000000ffff437224ULL, 0x000fe400078e0015ULL, 0x000000ffff467224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000067087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2c7224ULL, 0x000fc400078e002bULL, 0x000000ffff277224ULL, 0x000fe400078e0026ULL,
0x000000ffff2b7224ULL, 0x000fe400078e001eULL, 0x000000ffff267224ULL, 0x000fe400078e001fULL,
0x000000ffff247224ULL, 0x000fe400078e001bULL, 0x000000ffff1e7224ULL, 0x000fe400078e0016ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0017ULL, 0x0000000000047805ULL, 0x002fca0000015200ULL,
0x0000040067077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040067077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000045f1d7824ULL, 0x000fe200078e00ffULL, 0x0000005e6300720cULL, 0x000fc80003f06070ULL,
0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL, 0x00000080111c7824ULL, 0x000fca00078e021cULL,
0x01a400001c047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000000105f0a7211ULL, 0x040fe200078ff0ffULL, 0x000000025f6d7824ULL, 0x000fc600078e00ffULL,
0x000000100a167810ULL, 0x000fe40007ffe0ffULL, 0x000000066d6d7812ULL, 0x000fca00078ec0ffULL,
0x000000016d6f7824ULL, 0x000fe200078e0213ULL, 0x0000000b000b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0b157810ULL, 0x008fcc0007ffe0ffULL, 0x0000001500097305ULL, 0x000ee4000021f000ULL,
0x000000ffff177224ULL, 0x008fc800078e0a09ULL, 0x00005a0017177a24ULL, 0x000fc800078e02ffULL,
0x0000001709197227ULL, 0x000fe200078e0008ULL, 0x000000080a097810ULL, 0x000fca0007ffe0ffULL,
0x0000000a19087227ULL, 0x000fc800078e00ffULL, 0x0000000919147227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x000000ffff187224ULL, 0x000fe400078e0a14ULL,
0x00005a000b0b7a24ULL, 0x000fe200078e020aULL, 0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL,
0x00005a0018157a24ULL, 0x000fe400078e0209ULL, 0x0000001619177227ULL, 0x000fe200078e00ffULL,
0x00005a000b007a0cULL, 0x000fe40003f06070ULL, 0x00005a0015007a0cULL, 0x000fe20003fa6070ULL,
0x000000ffff097224ULL, 0x000fc400078e0a17ULL, 0x0000000a19187227ULL, 0x000fc800078e00ffULL,
0x00005a0009167a24ULL, 0x000fe400078e0216ULL, 0x000000ffff197224ULL, 0x000fe400078e0a18ULL,
0x80005a000b0b0a10ULL, 0x000fe20007ffe0ffULL, 0x0000010063097824ULL, 0x000fe200078e025dULL,
0x00005a0016007a0cULL, 0x000fe20003f26070ULL, 0x00005a00190a7a24ULL, 0x000fe200078e020aULL,
0x80005a0015155a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000b007a0cULL, 0x000fe20003f46070ULL,
0x00000001650b7824ULL, 0x000fe200078e026dULL, 0x00005a000a007a0cULL, 0x000fc40003f66070ULL,
0x000000090e6c7217ULL, 0x000fe40007800000ULL, 0x00005a0015007a0cULL, 0x000fe40003fc6070ULL,
0x0000000108080810ULL, 0x000fe20007ffe0ffULL, 0x000000016c6c7824ULL, 0x000fe200078e0a09ULL,
0x80005a0016161a10ULL, 0x000fe40007ffe0ffULL, 0x0000000114145810ULL, 0x000fe20007ffe0ffULL,
0x000000016f097824ULL, 0x000fe200078e0a6cULL, 0x00005a0016007a0cULL, 0x000fc40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a00ff197a12ULL, 0x000fe400078e33ffULL,
0x0000006c0b00720cULL, 0x040fe20003f06070ULL, 0x000000010b0b7824ULL, 0x000fe200078e0a6cULL,
0x80005a000a0a3a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fe40007ffe0ffULL,
0x0000000114146810ULL, 0x000fc40007ffe0ffULL, 0x00000009667c7217ULL, 0x000fe40003800000ULL,
0x00005a000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000819097207ULL, 0x040fe40006800000ULL,
0x0000000b660b7217ULL, 0x040fe40003800000ULL, 0x0000001419157207ULL, 0x000fe40006800000ULL,
0x0000000966097217ULL, 0x000fc40003800000ULL, 0x0000000117171810ULL, 0x000fe40007ffe0ffULL,
0x0000006c6f00720cULL, 0x000fe20003fc6070ULL, 0x0000000960937224ULL, 0x000fe200078e02ffULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000001566157217ULL, 0x000fe40003800000ULL,
0x0000000118183810ULL, 0x000fe40007ffe0ffULL, 0x0000000117174810ULL, 0x000fe20007ffe0ffULL,
0x0000001560977224ULL, 0x000fe200078e02ffULL, 0x000000ff7c7c7207ULL, 0x000fc40003000000ULL,
0x000000ff0b147207ULL, 0x000fe40000000000ULL, 0x0000000118182810ULL, 0x000fe40007ffe0ffULL,
0x0000001719157207ULL, 0x000fe20006800000ULL, 0x00000001930b7824ULL, 0x000fe200078e0214ULL,
0x000000937c097211ULL, 0x000fe200078fe0ffULL, 0x0000000114177824ULL, 0x000fe200078e0297ULL,
0x0000001819197207ULL, 0x000fe20006800000ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x0000001566157217ULL, 0x000fc40003800000ULL, 0x0000001966197217ULL, 0x000fe20003800000ULL,
0x0000000209087825ULL, 0x100fe200078e0002ULL, 0x000000106d797812ULL, 0x000fe200078efcffULL,
0x000000060a6e7981ULL, 0x0046a4000c1e9500ULL, 0x0000001560997224ULL, 0x000fe400078e02ffULL,
0x0000000608717981ULL, 0x0002a2000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x000000977c157211ULL, 0x040fe400078fe0ffULL, 0x000000997c1b7211ULL, 0x000fe200078fe0ffULL,
0x00000019609b7224ULL, 0x000fe200078e02ffULL, 0x0000000616707981ULL, 0x0002a2000c1e9500ULL,
0x0000000114197824ULL, 0x000fc400078e0299ULL, 0x00000001657d7824ULL, 0x000fe200078e0279ULL,
0x0000009b7c737211ULL, 0x000fe200078fe0ffULL, 0x0000000114757824ULL, 0x000fe400078e029bULL,
0x0000000215147825ULL, 0x000fc800078e0002ULL, 0x0000000219187825ULL, 0x000fc800078e0002ULL,
0x000000021b0a7825ULL, 0x008fe200078e0002ULL, 0x0000000618727981ULL, 0x0006a6000c1e9500ULL,
0x000000017d177824ULL, 0x002fe400078e0a6cULL, 0x0000000179777824ULL, 0x000fe400078e0213ULL,
0x00000002751a7825ULL, 0x100fe200078e0002ULL, 0x0000001766167217ULL, 0x000fe20003800000ULL,
0x000000060a757981ULL, 0x0002a4000c1e9500ULL, 0x0000000273087825ULL, 0x000fc400078e0002ULL,
0x0000000614737981ULL, 0x0002a4000c1e9500ULL, 0x0000000177177824ULL, 0x000fe200078e0a6cULL,
0x0000006c7d00720cULL, 0x080fe20003f26070ULL, 0x000000061a747981ULL, 0x0006a2000c1e9500ULL,
0x00000004ff167819ULL, 0x000fe40000011616ULL, 0x0000006c7700720cULL, 0x000fe20003f06070ULL,
0x00000006087b7981ULL, 0x0006a2000c1e9500ULL, 0x0000001766177217ULL, 0x000fe40003800000ULL,
0x000000ff16147207ULL, 0x002fc40000800000ULL, 0x000000ff17847207ULL, 0x000fe40000000000ULL,
0x000000206d837812ULL, 0x000fe200078efcffULL, 0x0000000114177824ULL, 0x000fe200078e0297ULL,
0x0000009384097211ULL, 0x048fe200078fe0ffULL, 0x00000001930b7824ULL, 0x000fe200078e0214ULL,
0x0000009784157211ULL, 0x040fe200078fe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000009b847f7211ULL, 0x000fc600078fe0ffULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x0000000616787981ULL, 0x0002e6000c1e9500ULL, 0x0000000165897824ULL, 0x000fe200078e0283ULL,
0x00000006087d7981ULL, 0x0002e2000c1e9500ULL, 0x00000001141b7824ULL, 0x040fe400078e0299ULL,
0x0000000114817824ULL, 0x000fe400078e029bULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000215147825ULL, 0x000fe200078e0002ULL, 0x000000060a767981ULL, 0x0002e6000c1e9500ULL,
0x0000000189177824ULL, 0x002fe400078e0a6cULL, 0x000000027f087825ULL, 0x000fe400078e0002ULL,
0x00000006147f7981ULL, 0x0002e4000c1e9500ULL, 0x0000000183857824ULL, 0x000fe200078e0213ULL,
0x0000001766167217ULL, 0x000fc40003800000ULL, 0x0000009984197211ULL, 0x000fe200078fe0ffULL,
0x0000000185177824ULL, 0x000fe200078e0a6cULL, 0x0000006c8900720cULL, 0x080fe20003f26070ULL,
0x000000021b1a7825ULL, 0x000fe200078e0002ULL, 0x00000004ff167819ULL, 0x000fe20000011616ULL,
0x0000000608877981ULL, 0x0002e2000c1e9500ULL, 0x0000006c8500720cULL, 0x000fe20003f06070ULL,
0x0000000219187825ULL, 0x100fe200078e0002ULL, 0x0000001766177217ULL, 0x000fe20003800000ULL,
0x000000061a7a7981ULL, 0x0002e4000c1e9500ULL, 0x00000002810a7825ULL, 0x000fe200078e0002ULL,
0x000000ff16167207ULL, 0x000fe20000800000ULL, 0x0000000618817981ULL, 0x0002e2000c1e9500ULL,
0x000000ff178a7207ULL, 0x000fc60000000000ULL, 0x000000060a7e7981ULL, 0x0002e4000c1e9500ULL,
0x00000001161b7824ULL, 0x002fe200078e0297ULL, 0x000000978a197211ULL, 0x040fe200078fe0ffULL,
0x00000001930b7824ULL, 0x000fe200078e0216ULL, 0x0000009b8a8b7211ULL, 0x000fe200078fe0ffULL,
0x000000021b1a7825ULL, 0x000fc800078e0002ULL, 0x000000020b0a7825ULL, 0x100fe200078e0002ULL,
0x000000061a827981ULL, 0x0002e6000c1e9500ULL, 0x0000000219187825ULL, 0x000fe200078e0002ULL,
0x000000060a807981ULL, 0x0002e2000c1e9500ULL, 0x000000938a897211ULL, 0x000fe400078fe0ffULL,
0x000000306d8d7812ULL, 0x000fe200078efcffULL, 0x0000000116177824ULL, 0x000fe200078e0299ULL,
0x000000998a097211ULL, 0x000fe200078fe0ffULL, 0x000000028b0a7825ULL, 0x002fc400078e0002ULL,
0x00000006188b7981ULL, 0x0002e4000c1e9500ULL, 0x0000000116157824ULL, 0x000fe400078e029bULL,
0x0000000289887825ULL, 0x000fe200078e0002ULL, 0x000000060add7981ULL, 0x0002e6000c1e9500ULL,
0x0000000165957824ULL, 0x000fe400078e028dULL, 0x0000000217167825ULL, 0x100fe200078e0002ULL,
0x0000000688897981ULL, 0x0002e6000c1e9500ULL, 0x0000000209087825ULL, 0x100fe200078e0002ULL,
0x0000000616867981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e0002ULL,
0x0000000608917981ULL, 0x0002e6000c1e9500ULL, 0x00000001951b7824ULL, 0x000fe200078e0a6cULL,
0x0000000614887981ULL, 0x0022e2000c1e9500ULL, 0x000000018d8f7824ULL, 0x000fc600078e0213ULL,
0x0000001b661a7217ULL, 0x040fe20003800000ULL, 0x000000018f1b7824ULL, 0x000fe200078e0a6cULL,
0x0000006c9500720cULL, 0x080fe40003f26070ULL, 0x0000006c8f00720cULL, 0x000fe40003f06070ULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x0000001b661b7217ULL, 0x000fe40003800000ULL,
0x000000ff1a8e7207ULL, 0x000fc40000800000ULL, 0x000000ff1b8c7207ULL, 0x000fc60000000000ULL,
0x0000000193197824ULL, 0x000fe200078e028eULL, 0x000000938c1b7211ULL, 0x000fe200078fe0ffULL,
0x000000018e157824ULL, 0x002fe200078e0299ULL, 0x000000998c177211ULL, 0x000fe200078fe0ffULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x0000000618907981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x000000061ac37981ULL, 0x0002e6000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000000614967981ULL, 0x0002e2000c1e9500ULL, 0x000000978c0b7211ULL, 0x000fc600078fe0ffULL,
0x0000000616db7981ULL, 0x0002e2000c1e9500ULL, 0x000000018e097824ULL, 0x000fe400078e0297ULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad97981ULL, 0x0002e4000c1e9500ULL, 0x0000009b8c197211ULL, 0x002fe400078fe0ffULL,
0x0000000608947981ULL, 0x0002e2000c1e9500ULL, 0x000000018e1b7824ULL, 0x000fe400078e029bULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000618df7981ULL, 0x0002e8000c1e9500ULL, 0x000000061a987981ULL, 0x0002e4000c1e9500ULL,
0xfffffff07c097812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd77424ULL, 0x000fc800078e00ffULL,
0x000000016c087824ULL, 0x000fc800078e0209ULL, 0x000000016f097824ULL, 0x000fe200078e0a08ULL,
0x000000016d937812ULL, 0x000fc800078efcffULL, 0x00000009d7097219ULL, 0x000fe200000006ffULL,
0x00000001930b7824ULL, 0x000fe200078e0213ULL, 0xfffffff084157812ULL, 0x000fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000086d957812ULL, 0x040fe200078efcffULL,
0x000000016c167824ULL, 0x000fe200078e0215ULL, 0x000000096d977812ULL, 0x000fe400078efcffULL,
0x0000000ad7157219ULL, 0x000fe200000006ffULL, 0x0000000195177824ULL, 0x100fe400078e0213ULL,
0x00000001971b7824ULL, 0x000fe200078e0213ULL, 0xfffffff08a197812ULL, 0x000fe200078ec0ffULL,
0x0000000117147824ULL, 0x100fe200078e0a08ULL, 0xfffffff08c997812ULL, 0x000fe200078ec0ffULL,
0x000000011b087824ULL, 0x000fe200078e0a08ULL, 0x000000116d9d7812ULL, 0x000fe200078efcffULL,
0x000000016c187824ULL, 0x040fe200078e0219ULL, 0x00000014d7197219ULL, 0x040fe200000006ffULL,
0x000000016c8a7824ULL, 0x000fe200078e0299ULL, 0x00000008d7997219ULL, 0x000fe200000006ffULL,
0x000000019d9f7824ULL, 0x000fc400078e0213ULL, 0x0000000177087824ULL, 0x100fe400078e0a16ULL,
0x000000019f0a7824ULL, 0x000fe200078e0a16ULL, 0x00005410716e7816ULL, 0x004fc8000000006eULL,
0x0000006e09ff7212ULL, 0x000fc800078ac0ffULL, 0x0000006c6f00720cULL, 0x000fc80002fa1470ULL,
0x0000006c6d00720cULL, 0x000fe40002fa1070ULL, 0x0000006e15ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000006c0b00720cULL, 0x000fe40000f21470ULL,
0x0000541075727816ULL, 0x000fe40000000072ULL, 0x0000541073707816ULL, 0x000fc40000000070ULL,
0x0000007209ff7212ULL, 0x040fe4000788c0ffULL, 0x0000007009ff7212ULL, 0x080fe4000784c0ffULL,
0x0000007015ff7212ULL, 0x000fe400078ac0ffULL, 0x0000006c6f00720cULL, 0x0c0fe40001741470ULL,
0x0000006c6f00720cULL, 0x080fe40002781470ULL, 0x0000006c0b00720cULL, 0x000fc40002fa1470ULL,
0x0000006c6d00720cULL, 0x0c0fe40001741070ULL, 0x0000006c6d00720cULL, 0x080fe40002781070ULL,
0x0000006c9300720cULL, 0x0c0fe40000f21070ULL, 0x0000006c9300720cULL, 0x000fe40002fa1070ULL,
0x000054107b747816ULL, 0x000fe40000000074ULL, 0xff8000002e2e7808ULL, 0x000fc40001000000ULL,
0xff80000039397808ULL, 0x000fe40002000000ULL, 0xff80000056567808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002800000ULL, 0x0000006e19ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007409ff7212ULL, 0x000fe4000780c0ffULL, 0x0000007215ff7212ULL, 0x000fc4000784c0ffULL,
0x0000007415ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007099ff7212ULL, 0x000fe4000782c0ffULL,
0x0000007219ff7212ULL, 0x000fe400078ac0ffULL, 0x0000006c6f00720cULL, 0x080fe40000701470ULL,
0x0000006c0b00720cULL, 0x0c0fe40001741470ULL, 0x0000006c0b00720cULL, 0x000fc40002781470ULL,
0x0000006c1700720cULL, 0x0c0fe40001f61470ULL, 0x0000006c1700720cULL, 0x080fe40002fa1470ULL,
0x0000006c1b00720cULL, 0x080fe40000f21470ULL, 0x000000186da37812ULL, 0x040fe400078efcffULL,
0x000000196da97812ULL, 0x040fe400078efcffULL, 0x0000006c6d00720cULL, 0x000fc40000701070ULL,
0x0000006c9300720cULL, 0x0c0fe40001741070ULL, 0x0000006c9300720cULL, 0x080fe40002781070ULL,
0x0000006c9500720cULL, 0x0c0fe40001f61070ULL, 0x0000006c9500720cULL, 0x080fe40002fa1070ULL,
0x0000006c9700720cULL, 0x000fe40000f21070ULL, 0x00000008d79b7219ULL, 0x000fc400000006ffULL,
0x0000000ad7a17219ULL, 0x000fe400000006ffULL, 0x000054107d767816ULL, 0x008fe40000000076ULL,
0x000054107f787816ULL, 0x000fe20000000078ULL, 0x00000001a3a57824ULL, 0x100fe200078e0213ULL,
0xff80000028287808ULL, 0x000fe20000000000ULL, 0x00000001a9ab7824ULL, 0x000fe200078e0213ULL,
0xff80000038387808ULL, 0x000fe40001000000ULL, 0xff8000002c2c7808ULL, 0x000fc40002000000ULL,
0xff80000058587808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0x0000007019ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007299ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007419ff7212ULL, 0x000fc4000788c0ffULL,
0x0000007499ff7212ULL, 0x000fe4000786c0ffULL, 0x00000076a1ff7212ULL, 0x000fe400078ac0ffULL,
0x000000789bff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a5147824ULL, 0x100fe200078e0a16ULL,
0x0000006c1700720cULL, 0x080fe20000701470ULL, 0x00000001ab167824ULL, 0x000fe200078e0a16ULL,
0x0000006c1700720cULL, 0x080fe40002781470ULL, 0x0000006c1b00720cULL, 0x000fc40001741470ULL,
0x0000006c1b00720cULL, 0x080fe40001f61470ULL, 0x0000006c7700720cULL, 0x080fe40000f21470ULL,
0x0000006c9f00720cULL, 0x080fe40002fa1470ULL, 0x0000006c9500720cULL, 0x0c0fe40000701070ULL,
0x0000006c9500720cULL, 0x080fe40002781070ULL, 0x0000006c9700720cULL, 0x000fc40001741070ULL,
0x0000006c9700720cULL, 0x080fe40001f61070ULL, 0x0000006c7900720cULL, 0x080fe40000f21070ULL,
0x0000006c9d00720cULL, 0x000fe40002fa1070ULL, 0x00000014d7a77219ULL, 0x040fe400000006ffULL,
0x00000016d7ad7219ULL, 0x000fe400000006ffULL, 0x00005410817a7816ULL, 0x000fc4000000007aULL,
0x00005410877e7816ULL, 0x000fe4000000007eULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fc40000800000ULL,
0xff80000059597808ULL, 0x000fe40002800000ULL, 0x000000769bff7212ULL, 0x080fe4000780c0ffULL,
0x00000076a7ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007a9bff7212ULL, 0x040fe4000784c0ffULL,
0x0000007e9bff7212ULL, 0x000fe4000786c0ffULL, 0x0000007aa1ff7212ULL, 0x000fc4000782c0ffULL,
0x00000078adff7212ULL, 0x000fe200078ac0ffULL, 0x00000001851a7824ULL, 0x000fe200078e0a18ULL,
0x0000006c7700720cULL, 0x0c0fe40000701470ULL, 0x0000006c7700720cULL, 0x0c0fe40001741470ULL,
0x0000006c7700720cULL, 0x080fe40001f61470ULL, 0x0000006c9f00720cULL, 0x080fe40000f21470ULL,
0x0000006ca500720cULL, 0x000fc40002781470ULL, 0x0000006cab00720cULL, 0x080fe40002fa1470ULL,
0x000000216db17812ULL, 0x000fe400078efcffULL, 0x0000006c7900720cULL, 0x0c0fe40000701070ULL,
0x0000006c7900720cULL, 0x0c0fe40001741070ULL, 0x0000006c7900720cULL, 0x080fe40001f61070ULL,
0x0000006c9d00720cULL, 0x000fc40000f21070ULL, 0x0000006ca300720cULL, 0x080fe40002781070ULL,
0x0000006ca900720cULL, 0x000fe40002fa1070ULL, 0x0000001ad7af7219ULL, 0x000fe400000006ffULL,
0x000054108b827816ULL, 0x000fe20000000082ULL, 0x00000001b1b37824ULL, 0x000fe200078e0213ULL,
0xff8000006b6b7808ULL, 0x000fe40000000000ULL, 0xff8000003c3c7808ULL, 0x000fc40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000006a6a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x00000078a1ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007ea1ff7212ULL, 0x000fc4000784c0ffULL,
0x00000078a7ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007aadff7212ULL, 0x040fe4000782c0ffULL,
0x0000007eadff7212ULL, 0x000fe4000788c0ffULL, 0x00000082afff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b37c7824ULL, 0x000fe200078e0a18ULL, 0x0000006c9f00720cULL, 0x0c0fe40000701470ULL,
0x0000006c9f00720cULL, 0x000fc40001741470ULL, 0x0000006ca500720cULL, 0x080fe40001f61470ULL,
0x0000006cab00720cULL, 0x0c0fe40000f21470ULL, 0x0000006cab00720cULL, 0x080fe40002781470ULL,
0x0000006c8500720cULL, 0x000fe40002fa1470ULL, 0x000000286db77812ULL, 0x040fe400078efcffULL,
0x000000296dbd7812ULL, 0x000fc400078efcffULL, 0x0000006c9d00720cULL, 0x0c0fe40000701070ULL,
0x0000006c9d00720cULL, 0x080fe40001741070ULL, 0x0000006ca300720cULL, 0x080fe40001f61070ULL,
0x0000006ca900720cULL, 0x0c0fe40000f21070ULL, 0x0000006ca900720cULL, 0x080fe40002781070ULL,
0x0000006c8300720cULL, 0x000fc40002fa1070ULL, 0x0000007cd7b57219ULL, 0x000fe400000006ffULL,
0x0000541089807816ULL, 0x000fe40000000080ULL, 0x0000541091867816ULL, 0x000fe40000000086ULL,
0x00005410dd887816ULL, 0x000fe20000000088ULL, 0x00000001b7b97824ULL, 0x100fe200078e0213ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x00000001bdbf7824ULL, 0x000fe200078e0213ULL,
0xff8000002d2d7808ULL, 0x000fc40001000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000006e99ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007aa7ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007ea7ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080afff7212ULL, 0x040fe4000786c0ffULL, 0x00000086afff7212ULL, 0x040fe4000782c0ffULL,
0x00000088afff7212ULL, 0x000fe4000788c0ffULL, 0x00000086b5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b9847824ULL, 0x100fe200078e0a18ULL, 0x0000006c1b00720cULL, 0x080fe200037c1470ULL,
0x00000001bf187824ULL, 0x000fe200078e0a18ULL, 0x0000006ca500720cULL, 0x000fc40000701470ULL,
0x0000006ca500720cULL, 0x080fe40001741470ULL, 0x0000006c8500720cULL, 0x0c0fe40001f61470ULL,
0x0000006c8500720cULL, 0x0c0fe40000f21470ULL, 0x0000006c8500720cULL, 0x080fe40002781470ULL,
0x0000006cb300720cULL, 0x080fe40002fa1470ULL, 0x0000006c9700720cULL, 0x000fc400037c1070ULL,
0x0000006ca300720cULL, 0x0c0fe40000701070ULL, 0x0000006ca300720cULL, 0x080fe40001741070ULL,
0x0000006c8300720cULL, 0x0c0fe40001f61070ULL, 0x0000006c8300720cULL, 0x0c0fe40000f21070ULL,
0x0000006c8300720cULL, 0x080fe40002781070ULL, 0x0000006cb100720cULL, 0x000fc40002fa1070ULL,
0x00000084d7bb7219ULL, 0x040fe400000006ffULL, 0x00000018d7c17219ULL, 0x000fe400000006ffULL,
0xff80000055557808ULL, 0x000fe40003000000ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff8000005b5b7808ULL, 0x000fc40001800000ULL,
0xff80000040407808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x00000076adff7212ULL, 0x000fe400078cc0ffULL,
0x00000080b5ff7212ULL, 0x080fe4000780c0ffULL, 0x00000080bbff7212ULL, 0x000fc4000784c0ffULL,
0x00000082b5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000088b5ff7212ULL, 0x000fe4000782c0ffULL,
0x00000082bbff7212ULL, 0x000fe4000788c0ffULL, 0x00000086c1ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018f8c7824ULL, 0x000fe200078e0a8aULL, 0x0000006cab00720cULL, 0x080fe400037c1470ULL,
0x0000006cb300720cULL, 0x000fc40000701470ULL, 0x0000006cb300720cULL, 0x0c0fe40001f61470ULL,
0x0000006cb300720cULL, 0x080fe40000f21470ULL, 0x0000006cb900720cULL, 0x0c0fe40001741470ULL,
0x0000006cb900720cULL, 0x080fe40002781470ULL, 0x0000006cbf00720cULL, 0x000fe40002fa1470ULL,
0x000000316dc77812ULL, 0x000fc400078efcffULL, 0x000000386dcd7812ULL, 0x040fe400078efcffULL,
0x000000396dd37812ULL, 0x000fe400078efcffULL, 0x0000006ca900720cULL, 0x080fe400037c1070ULL,
0x0000006cb100720cULL, 0x0c0fe40000701070ULL, 0x0000006cb100720cULL, 0x0c0fe40001f61070ULL,
0x0000006cb100720cULL, 0x000fc40000f21070ULL, 0x0000006cb700720cULL, 0x0c0fe40001741070ULL,
0x0000006cb700720cULL, 0x080fe40002781070ULL, 0x0000006cbd00720cULL, 0x000fe40002fa1070ULL,
0x0000008cd7c57219ULL, 0x000fe400000006ffULL, 0x00005410c3907816ULL, 0x000fe40000000090ULL,
0x00005410db967816ULL, 0x000fe20000000096ULL, 0x00000001c7c97824ULL, 0x100fe200078e0213ULL,
0xff8000005a5a7808ULL, 0x000fe20003000000ULL, 0x00000001cdcf7824ULL, 0x100fe200078e0213ULL,
0xff80000054547808ULL, 0x000fe20000000000ULL, 0x00000001d3d57824ULL, 0x000fe200078e0213ULL,
0xff80000048487808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000043437808ULL, 0x000fe40002800000ULL, 0x00000080c1ff7212ULL, 0x040fe400078cc0ffULL,
0x00000082c1ff7212ULL, 0x000fc4000780c0ffULL, 0x00000086bbff7212ULL, 0x040fe4000786c0ffULL,
0x00000088bbff7212ULL, 0x080fe4000782c0ffULL, 0x00000088c1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000090c5ff7212ULL, 0x040fe4000788c0ffULL, 0x00000096c5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c98e7824ULL, 0x100fe200078e0a8aULL, 0x0000006cb900720cULL, 0x080fe20001f61470ULL,
0x00000001cf927824ULL, 0x100fe200078e0a8aULL, 0x0000006cb900720cULL, 0x080fe20000f21470ULL,
0x00000001d58a7824ULL, 0x000fe200078e0a8aULL, 0x0000006cbf00720cULL, 0x000fc400037c1470ULL,
0x0000006cbf00720cULL, 0x0c0fe40000701470ULL, 0x0000006cbf00720cULL, 0x080fe40001741470ULL,
0x0000006c8f00720cULL, 0x0c0fe40002781470ULL, 0x0000006c8f00720cULL, 0x000fe40002fa1470ULL,
0x0000008ed7cb7219ULL, 0x040fe400000006ffULL, 0x00000092d7d17219ULL, 0x000fc400000006ffULL,
0x0000006cb700720cULL, 0x0c0fe40001f61070ULL, 0x0000006cb700720cULL, 0x080fe40000f21070ULL,
0x0000006cbd00720cULL, 0x0c0fe400037c1070ULL, 0x0000006cbd00720cULL, 0x0c0fe40000701070ULL,
0x0000006cbd00720cULL, 0x080fe40001741070ULL, 0x0000006c8d00720cULL, 0x000fc40002781070ULL,
0x0000006c8d00720cULL, 0x000fe40002fa1070ULL, 0x0000008ad7d77219ULL, 0x000fe400000006ffULL,
0x00005410d9947816ULL, 0x000fe40000000094ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fc40003000000ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x00000090cbff7212ULL, 0x080fe4000786c0ffULL, 0x00000090d1ff7212ULL, 0x000fc4000782c0ffULL,
0x00000090d7ff7212ULL, 0x000fe400078cc0ffULL, 0x00000094c5ff7212ULL, 0x080fe4000780c0ffULL,
0x00000094cbff7212ULL, 0x080fe4000784c0ffULL, 0x00000094d1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000096cbff7212ULL, 0x000fe400078ac0ffULL, 0x0000006c8f00720cULL, 0x000fc40000701470ULL,
0x0000006cc900720cULL, 0x0c0fe40001f61470ULL, 0x0000006cc900720cULL, 0x0c0fe40001741470ULL,
0x0000006cc900720cULL, 0x080fe40002fa1470ULL, 0x0000006ccf00720cULL, 0x080fe40000f21470ULL,
0x0000006cd500720cULL, 0x080fe400037c1470ULL, 0x0000006ccf00720cULL, 0x000fc40002781470ULL,
0x0000006c8d00720cULL, 0x080fe40000701070ULL, 0x0000006cc700720cULL, 0x0c0fe40001f61070ULL,
0x0000006cc700720cULL, 0x0c0fe40001741070ULL, 0x0000006cc700720cULL, 0x080fe40002fa1070ULL,
0x0000006ccd00720cULL, 0x080fe40000f21070ULL, 0x0000006cd300720cULL, 0x000fc400037c1070ULL,
0x0000006ccd00720cULL, 0x000fe40002781070ULL, 0x00005410df987816ULL, 0x000fe40000000098ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002000000ULL, 0x00000094d7ff7212ULL, 0x000fe4000780c0ffULL,
0x00000096d1ff7212ULL, 0x080fe4000786c0ffULL, 0x00000096d7ff7212ULL, 0x000fc4000784c0ffULL,
0x00000098c5ff7212ULL, 0x080fe400078ac0ffULL, 0x00000098cbff7212ULL, 0x080fe4000782c0ffULL,
0x00000098d1ff7212ULL, 0x080fe400078cc0ffULL, 0x00000098d7ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006c8f00720cULL, 0x080fe40002fa1470ULL, 0x0000006cc900720cULL, 0x000fc40000f21470ULL,
0x0000006ccf00720cULL, 0x0c0fe40001f61470ULL, 0x0000006ccf00720cULL, 0x080fe400037c1470ULL,
0x0000006cd500720cULL, 0x0c0fe40000701470ULL, 0x0000006cd500720cULL, 0x0c0fe40001741470ULL,
0x0000006cd500720cULL, 0x080fe40002781470ULL, 0x0000006c8d00720cULL, 0x000fc40002fa1070ULL,
0x0000006cc700720cULL, 0x080fe40000f21070ULL, 0x0000006cd300720cULL, 0x080fe40000701070ULL,
0x0000006ccd00720cULL, 0x0c0fe40001f61070ULL, 0x0000006ccd00720cULL, 0x080fe400037c1070ULL,
0x0000006cd300720cULL, 0x0c0fe40001741070ULL, 0x0000006cd300720cULL, 0x000fc40002781070ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40003000000ULL,
0xff80000023237808ULL, 0x000fc40002000000ULL, 0x000000570400720bULL, 0x004fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fe40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280700720bULL, 0x000fe40003f7e000ULL, 0x0000000457097208ULL, 0x000fe40004000000ULL,
0x000000052e047208ULL, 0x000fc40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000728077208ULL, 0x000fe40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f5e000ULL, 0x0000004b0400720bULL, 0x000fe40003f3e000ULL,
0x0000002c0700720bULL, 0x000fc40003f7e000ULL, 0x0000000956097208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40005000000ULL, 0x000000044b047208ULL, 0x000fe40004800000ULL,
0x000000072c067208ULL, 0x000fe40005800000ULL, 0x000000580900720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fc40003f5e000ULL, 0x0000002f0400720bULL, 0x000fe40003f3e000ULL,
0x000000270600720bULL, 0x000fe40003f7e000ULL, 0x0000000958087208ULL, 0x000fe40004000000ULL,
0x000000053a0a7208ULL, 0x000fe40005000000ULL, 0x000000042f047208ULL, 0x000fe40004800000ULL,
0x0000000627067208ULL, 0x000fc40005800000ULL, 0x000000550800720bULL, 0x000fe40003f1e000ULL,
0x0000003b0a00720bULL, 0x000fe40003f5e000ULL, 0x000000310400720bULL, 0x000fe40003f3e000ULL,
0x000000290600720bULL, 0x000fe40003f7e000ULL, 0x0000000855087208ULL, 0x000fe40004000000ULL,
0x0000000a3b077208ULL, 0x000fc40005000000ULL, 0x0000000431057208ULL, 0x000fe40004800000ULL,
0x0000000629097208ULL, 0x000fe40005800000ULL, 0x0000006b0800720bULL, 0x000fe40003f1e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fc40003f7e000ULL, 0x000000086b087208ULL, 0x000fe40004000000ULL,
0x000000073c067208ULL, 0x000fe40005000000ULL, 0x0000000530047208ULL, 0x000fe40004800000ULL,
0x000000092a0a7208ULL, 0x000fe40005800000ULL, 0x000000590800720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fc40003f5e000ULL, 0x000000470400720bULL, 0x000fe40003f3e000ULL,
0x0000002d0a00720bULL, 0x000fe40003f7e000ULL, 0x0000000859057208ULL, 0x000fe40004000000ULL,
0x000000063d097208ULL, 0x000fe40005000000ULL, 0x0000000447077208ULL, 0x000fe40004800000ULL,
0x0000000a2d0a7208ULL, 0x000fc40005800000ULL, 0x0000006a0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0900720bULL, 0x000fe40003f5e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000002b0a00720bULL, 0x000fe40003f7e000ULL, 0x000000056a057208ULL, 0x000fe40004000000ULL,
0x000000093e047208ULL, 0x000fc40005000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x0000000a2b097208ULL, 0x000fe40005800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x000000260900720bULL, 0x000fc40003f7e000ULL, 0x000000055a067208ULL, 0x000fe40004000000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000000734087208ULL, 0x000fe40004800000ULL,
0x0000000926047208ULL, 0x000fe40005800000ULL, 0x0000005b0600720bULL, 0x000fe40003f1e000ULL,
0x000000400500720bULL, 0x000fc40003f5e000ULL, 0x000000330800720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f7e000ULL, 0x000000065b077208ULL, 0x000fe40004000000ULL,
0x0000000540067208ULL, 0x000fe40005000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x0000000425057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x000000480900720bULL, 0x000fe40003f3e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754047208ULL, 0x000fe40004000000ULL,
0x0000000948087208ULL, 0x000fc40004800000ULL, 0x0000000641077208ULL, 0x000fe40005000000ULL,
0x0000000524057208ULL, 0x000fe40005800000ULL, 0x000000530400720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x000000420700720bULL, 0x000fe40003f5e000ULL,
0x0000001e0500720bULL, 0x000fc40003f7e000ULL, 0x0000000453097208ULL, 0x000fe40004000000ULL,
0x00000008350b7208ULL, 0x000fe40004800000ULL, 0x0000000742047208ULL, 0x000fe40005000000ULL,
0x000000051e067208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fc40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fe40003f7e000ULL, 0x0000000952087208ULL, 0x000fe40004000000ULL,
0x0000000b440b7208ULL, 0x000fe40004800000ULL, 0x0000000443047208ULL, 0x000fe40005000000ULL,
0x000000061f057208ULL, 0x000fc40005800000ULL, 0x000000510800720bULL, 0x000fe40003f1e000ULL,
0x000000360b00720bULL, 0x000fe40003f3e000ULL, 0x0000004d0400720bULL, 0x000fe40003f5e000ULL,
0x000000200500720bULL, 0x000fe40003f7e000ULL, 0x0000000851077208ULL, 0x000fe40004000000ULL,
0x0000000b36067208ULL, 0x000fc40004800000ULL, 0x000000044d047208ULL, 0x000fe40005000000ULL,
0x0000000520087208ULL, 0x000fe40005800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000370600720bULL, 0x000fe40003f3e000ULL, 0x000000450400720bULL, 0x000fe40003f5e000ULL,
0x000000210800720bULL, 0x000fc40003f7e000ULL, 0x00000007500a7208ULL, 0x000fe40004000000ULL,
0x0000000637057208ULL, 0x000fe40004800000ULL, 0x0000000445077208ULL, 0x000fe40005000000ULL,
0x0000000821097208ULL, 0x000fe40005800000ULL, 0x0000004f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004c0500720bULL, 0x000fc40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f5e000ULL,
0x000000220900720bULL, 0x000fe40003f7e000ULL, 0x0000000a4f0b7208ULL, 0x000fe40004000000ULL,
0x000000054c057208ULL, 0x000fe40004800000ULL, 0x0000000746047208ULL, 0x000fe40005000000ULL,
0x0000000922067208ULL, 0x000fc40005800000ULL, 0x0000004e0b00720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fe40003f3e000ULL, 0x000000490400720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000b4e077208ULL, 0x000fe40004000000ULL,
0x000000054a0a7208ULL, 0x000fc40004800000ULL, 0x0000000449167208ULL, 0x000fe40005000000ULL,
0x0000000623157208ULL, 0x000fe20005800000ULL, 0x000024727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704177208ULL, 0x000fe20004000000ULL, 0x000024a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0015067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b06167820ULL, 0x000fe20000410000ULL,
0x00000002ff6d7819ULL, 0x000fe2000001165fULL, 0x3fb8aa3b55147823ULL, 0x100fe20000010807ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL,
0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x0000001400157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b58587823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b6b6b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b59597823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b6a6a7823ULL, 0x100fe20000010807ULL, 0x0000005600097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b5b557823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b54547823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b52527823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x0000005700087308ULL, 0x000e620000000800ULL,
0x3fb8aa3b4e4e7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b39397823ULL, 0x000fe40000010816ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x0000005a00577308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b31317823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b48487823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x0000003100147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4a077823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010816ULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe40000010816ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe40000010816ULL,
0x000000086d197824ULL, 0x040fe400078e00ffULL, 0x000000086d707824ULL, 0x000fe200078e00ffULL,
0x00000007005b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b3c3c7823ULL, 0x000fc40000010816ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe40000010816ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe40000010816ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010816ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000000a0b077208ULL, 0x004fe20004000000ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010816ULL,
0x000000016d0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b41417823ULL, 0x000fe20000010816ULL,
0x000000026d0b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b07567820ULL, 0x000fe20000410000ULL,
0xfffffff8196e7812ULL, 0x000fe200078ee20aULL, 0x0000003800387308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010816ULL, 0xfffffff870707812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL, 0x000000046d0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010856ULL, 0x000000056d0b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010856ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010856ULL, 0xfffffff819747812ULL, 0x000fe200078ee20aULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010816ULL, 0x00000058150a723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010816ULL, 0x0000002e4b09723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010816ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010816ULL, 0x000000035fff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b49167823ULL, 0x000fc40000010816ULL, 0x000000086d767824ULL, 0x040fe400078e00ffULL,
0x000000086d1b7824ULL, 0x040fe200078e00ffULL, 0x0000002c00177308ULL, 0x000e620000000800ULL,
0x000000086d157824ULL, 0x000fe200078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL, 0x0000002f140b723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010856ULL, 0xffffffff6d147810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010856ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x000fe20000010856ULL, 0xfffffff8157a7812ULL, 0x000fe200078ee214ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL, 0x000000393814723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b1f1f7823ULL, 0x000fc40000010856ULL, 0x3fb8aa3b20387823ULL, 0x100fe20000010856ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000281715723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b214b7823ULL, 0x000fcc0000010856ULL, 0x00000029005a7308ULL, 0x000e700000000800ULL,
0x0000001600497308ULL, 0x0005f00000000800ULL, 0x00000059006c7308ULL, 0x000fe20000000800ULL,
0x000000036d167810ULL, 0x004fc40007ffe0ffULL, 0x000000275a17723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b1e277823ULL, 0x000fe20000010856ULL, 0xfffffff81b727812ULL, 0x000fe200078ee216ULL,
0x3fb8aa3b225a7823ULL, 0x000fe20000010856ULL, 0x000000066d167810ULL, 0x000fe20007ffe0ffULL,
0x0000003400597308ULL, 0x0003e60000000800ULL, 0xfffffff81b787812ULL, 0x000fe400078ee216ULL,
0x0000003a3b16723eULL, 0x000fc600000000ffULL, 0x0000003500317308ULL, 0x0005e20000000800ULL,
0x3c003c00ff347424ULL, 0x002fce00078e00ffULL, 0x00000045004a7308ULL, 0x000fe20000000800ULL,
0x3c003c00ff357424ULL, 0x004fce00078e00ffULL, 0x0000002a002c7308ULL, 0x000fe20000000800ULL,
0x000000340818723cULL, 0x080f6e00000018ffULL, 0x0000002b00457308ULL, 0x0003f00000000800ULL,
0x0000006b006b7308ULL, 0x000ea20000000800ULL, 0x000000341428723cULL, 0x002f6e00000018ffULL,
0x0000006a006a7308ULL, 0x000e700000000800ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000006b6c20723eULL, 0x004fc400000000ffULL, 0x000000186d6c7810ULL, 0x000fca0007ffe0ffULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x0000006a5722723eULL, 0x002fe400000000ffULL,
0x000000106d6a7810ULL, 0x000fca0007ffe0ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000304721723eULL, 0x004fe400000000ffULL,
0x000000086d307810ULL, 0x000fca0007ffe0ffULL, 0x0000003d003d7308ULL, 0x000e700000000800ULL,
0x0000003e003e7308ULL, 0x000ff00000000800ULL, 0x0000003f003f7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000eb00000000800ULL, 0x0000002600587308ULL, 0x0006b00000000800ULL,
0x0000002500397308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b24267823ULL, 0x108fe20000010856ULL,
0x0000003c3d24723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b23567823ULL, 0x000fe20000010856ULL,
0x000000325923723eULL, 0x000fc800000000ffULL, 0x00000026001e7308ULL, 0x0002e20000000800ULL,
0x0000002c2d25723eULL, 0x004fe400000000ffULL, 0x00000034202c723cULL, 0x020b6a0000001818ULL,
0x00000027003b7308ULL, 0x0005e20000000800ULL, 0x0000003e3f26723eULL, 0x002fe200000000ffULL,
0x0000000830197824ULL, 0x020fc400078e00ffULL, 0x000000086a1b7824ULL, 0x000fe400078e00ffULL,
0x000000086c3f7824ULL, 0x000fe400078e00ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x000000455827723eULL, 0x004fe200000000ffULL, 0x000000086d3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff819587812ULL, 0x000fe400078ee230ULL, 0xfffffff81b6a7812ULL, 0x000fe400078ee26aULL,
0x000000391e39723eULL, 0x008fe200000000ffULL, 0x0000005400547308ULL, 0x000e620000000800ULL,
0x000000342428723cULL, 0x000f620000001828ULL, 0xfffffff83f6c7812ULL, 0x000fc400078ee26cULL,
0xfffffff83e3e7812ULL, 0x000fc800078ee26dULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005200527308ULL, 0x000ea20000000800ULL, 0x000000555418723eULL, 0x002fce00000000ffULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000004800487308ULL, 0x000e620000000800ULL,
0x00000053521a723eULL, 0x004fce00000000ffULL, 0x0000004400447308ULL, 0x000eb00000000800ULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000334819723eULL, 0x002fce00000000ffULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x00000031441b723eULL, 0x004fce00000000ffULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x00000034182c723cULL, 0x000f6e000000182cULL,
0x0000004300437308ULL, 0x000e700000000800ULL, 0x0000001f003c7308ULL, 0x0004f00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000042433a723eULL, 0x002fc400000000ffULL,
0x00012000111f7811ULL, 0x004fca00078e60ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000003b3c3b723eULL, 0x008fe200000000ffULL, 0x000000103e3e7824ULL, 0x100fe400078e021fULL,
0x000000106e6e7824ULL, 0x100fe400078e021fULL, 0x0000001070707824ULL, 0x100fe400078e021fULL,
0x00000038003d7308ULL, 0x0005e20000000800ULL, 0x0000001072727824ULL, 0x100fe400078e021fULL,
0x0000001074747824ULL, 0x000fc400078e021fULL, 0x0000001076767824ULL, 0x100fe400078e021fULL,
0x000000011d6e7824ULL, 0x000fe200078e026eULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000404138723eULL, 0x004fe200000000ffULL, 0x0000001078787824ULL, 0x100fe200078e021fULL,
0x000000515030723eULL, 0x002fe200000000ffULL, 0x000000011d707824ULL, 0x040fe400078e0270ULL,
0x000000107a7a7824ULL, 0x000fe400078e021fULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000343828723cULL, 0x020fe20000001828ULL, 0x000000011d727824ULL, 0x000fc400078e0272ULL,
0x0000001058587824ULL, 0x000fe400078e021fULL, 0x000000011d747824ULL, 0x040fe400078e0274ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x000000011d767824ULL, 0x040fe400078e0276ULL,
0x000000011d787824ULL, 0x040fe400078e0278ULL, 0x000000011d7a7824ULL, 0x040fe400078e027aULL,
0x000000011d587824ULL, 0x000fe200078e0258ULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x000000363731723eULL, 0x002fe200000000ffULL, 0x000000013e377824ULL, 0x000fc400078e021dULL,
0x000000106a6a7824ULL, 0x100fe400078e021fULL, 0x000000106c6c7824ULL, 0x000fe200078e021fULL,
0x0000000837007388ULL, 0x0003e20000000800ULL, 0x0000004c004c7308ULL, 0x000ee20000000800ULL,
0x000000011d1f7824ULL, 0x040fe400078e026aULL, 0x0000000a6e007388ULL, 0x0003e20000000800ULL,
0x000000011d6c7824ULL, 0x000fc600078e026cULL, 0x0000002070007388ULL, 0x0003e20000000800ULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x0000004f4e32723eULL, 0x004fe400000000ffULL,
0x0000002272007388ULL, 0x0005e80000000800ULL, 0x0000001874007388ULL, 0x0005e20000000800ULL,
0x0000004600467308ULL, 0x000ea20000000800ULL, 0x0000004c5b33723eULL, 0x008fc400000000ffULL,
0x0000001a76007388ULL, 0x0007e80000000800ULL, 0x0000003078007388ULL, 0x0007e20000000800ULL,
0x0000004b00507308ULL, 0x000ee20000000800ULL, 0x0000004d4a3c723eULL, 0x002fe200000000ffULL,
0x00000034302c723cULL, 0x000f62000000182cULL, 0x000000327a007388ULL, 0x0003e80000000800ULL,
0x0000000958007388ULL, 0x0003e20000000800ULL, 0x0000005a003f7308ULL, 0x000fe20000000800ULL,
0x00000046493e723eULL, 0x004fc400000000ffULL, 0x0004000b6e007388ULL, 0x0003e80000000800ULL,
0x0004002170007388ULL, 0x0003e20000000800ULL, 0x0000005600567308ULL, 0x000ea20000000800ULL,
0x0000003d503d723eULL, 0x008fe400000000ffULL, 0x0004002372007388ULL, 0x0003e80000000800ULL,
0x0004001974007388ULL, 0x0003e60000000800ULL, 0x000000ffff2d7224ULL, 0x020fe200078e002eULL,
0x0004001b76007388ULL, 0x0003e80000000800ULL, 0x0004003178007388ULL, 0x0003e20000000800ULL,
0x0000003f563f723eULL, 0x004fc600000000ffULL, 0x000400337a007388ULL, 0x0003e80000000800ULL,
0x000000343c28723cULL, 0x000f620000001828ULL, 0x000000141f007388ULL, 0x0003e80000000800ULL,
0x000800166e007388ULL, 0x0003e80000000800ULL, 0x0008002470007388ULL, 0x0003e80000000800ULL,
0x0008002672007388ULL, 0x0003e80000000800ULL, 0x0008003874007388ULL, 0x0003e80000000800ULL,
0x0008003a76007388ULL, 0x0003e60000000800ULL, 0x000000ffff2e7224ULL, 0x020fe200078e0028ULL,
0x0008003c78007388ULL, 0x0003e20000000800ULL, 0x000000ffff2f7224ULL, 0x000fc600078e002aULL,
0x0008003e7a007388ULL, 0x0003e80000000800ULL, 0x000000156c007388ULL, 0x0003e80000000800ULL,
0x000c00176e007388ULL, 0x0003e80000000800ULL, 0x000c002570007388ULL, 0x0003e80000000800ULL,
0x000c002772007388ULL, 0x0003e80000000800ULL, 0x000c003974007388ULL, 0x0003e80000000800ULL,
0x000c003b76007388ULL, 0x0003e80000000800ULL, 0x000c003d78007388ULL, 0x0003e80000000800ULL,
0x000c003f7a007388ULL, 0x0003e80000000800ULL, 0x01a000041c008388ULL, 0x0003e80000000c00ULL,
0x01a2002c1c008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080064ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100064ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000163637810ULL, 0x000fe20007ffe0ffULL, 0x0000180064ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc400078e0062ULL, 0x0000000c6300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff8c5000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001865000267802ULL, 0x000fc40000000f00ULL,
0x000015f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e0025ULL,
0xfffea6b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000186b000267802ULL, 0x000fc40000000f00ULL,
0x0000159000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0xfffea6e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001872000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000014d000007944ULL, 0x014fea0003c00000ULL,
0xfffea79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001878000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000147000007944ULL, 0x014fea0003c00000ULL,
0xfffea8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x000187e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000141000007944ULL, 0x014fea0003c00000ULL,
0xfffea9b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001884000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x014fea0003c00000ULL,
0xfffeaab000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000188b000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0017ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffeae8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001892000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000012d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001017277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001899000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000126000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffeadf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00018a0000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000011f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffeadb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00018a6000267802ULL, 0x000fc40000000f00ULL, 0x000011e000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffecf8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00018ac000267802ULL, 0x000fc40000000f00ULL, 0x0000118000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff737224ULL, 0x000fe200078e0025ULL, 0xfffecfb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00018b3000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000010c000007944ULL, 0x014fea0003c00000ULL, 0xfffed07000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00018b9000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000106000007944ULL, 0x014fea0003c00000ULL, 0xfffed18000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00018bf000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x014fea0003c00000ULL, 0xfffed29000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x00018c5000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x014fea0003c00000ULL, 0xfffed39000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00018cc000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0029ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000f3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffed79000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00018d3000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001029277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00018da000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffed70000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00018e1000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000de000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffed6c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00018e7000267802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xfffef67000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00018ed000267802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0025ULL,
0xfffef6b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0075ULL,
0x00018f4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000cb000007944ULL, 0x014fea0003c00000ULL,
0xfffef77000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0075ULL,
0x00018fa000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x014fea0003c00000ULL,
0xfffef88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0075ULL,
0x0001900000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000bf000007944ULL, 0x014fea0003c00000ULL,
0xfffef99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0075ULL,
0x0001906000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000b9000007944ULL, 0x014fea0003c00000ULL,
0xfffefa9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000190d000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe400078e0023ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000b2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffefe9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001914000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001023277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000191b000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000a4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffefe0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001922000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000009d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffefdc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x004fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001928000267802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e0025ULL, 0xffff1e6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000192e000267802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xffff1ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001935000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x018fea0003c00000ULL, 0xffff1f5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x000193b000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0xffff206000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001941000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000007e000007944ULL, 0x018fea0003c00000ULL, 0xffff217000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001947000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x018fea0003c00000ULL, 0xffff227000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x000194e000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0003ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff267000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001955000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001003277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x000195c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff25e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001963000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff25a000007947ULL, 0x000fea000383ffffULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x000196a000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e000aULL, 0x0001972000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fc400078e00ffULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x010fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0016ULL,
0x000197a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0015ULL,
0x0001982000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x000000160b167208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0017ULL,
0x000198a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000150b0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001992000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000170b047208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0016ULL,
0x000199a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x00019a2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000160b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd92000007947ULL, 0x000fea000383ffffULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002400008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000024027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe645002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001800007348ULL, 0x000fe80003800000ULL, 0x0c000014070b7389ULL, 0x0002a200000e000bULL,
0xfffe641008007950ULL, 0x000fea0003c3ffffULL, 0x0000006c00007348ULL, 0x000fe80003800000ULL,
0x0000002726267389ULL, 0x0002a200000e0071ULL, 0x00000000ff6d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x002fc800078e0025ULL, 0xfffe63c06c007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f45070ULL, 0x0000002700007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000002725257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe636026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000348ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019d80ULL, 0xe200001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b600ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b640ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b9c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019f78ULL,
0x0000000000019f78ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b600ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b9c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 113312;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
