/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014a48ULL, 0x00000000000146c8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000013020ULL,
0x0000000000000260ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013280ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001302000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x0001302000000000ULL, 0x0000026000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL, 0x0000001700081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000018000942804ULL,
0x000009f0000004b0ULL, 0x00002c4000002bd0ULL, 0x00002e5000002d10ULL, 0x000033e0000033d0ULL,
0x0000509000005030ULL, 0x000052d000005190ULL, 0x000056e0000056d0ULL, 0x000072c000007260ULL,
0x00007500000073c0ULL, 0x0000791000007900ULL, 0x0000956000009500ULL, 0x000097a000009660ULL,
0x00009bf000009be0ULL, 0x0000ad200000ad10ULL, 0x0001251000012460ULL, 0x000127c000012720ULL,
0x00012a5000012940ULL, 0x00012c0000012bb0ULL, 0x0000053004303904ULL, 0x00017600000000ffULL,
0x0000061000040100ULL, 0x0001760800000009ULL, 0x00000720003f0100ULL, 0x0001768800000009ULL,
0x00000860003f0100ULL, 0x000176a800000005ULL, 0x00000960003f0100ULL, 0x000176c800000004ULL,
0x00001090003f0100ULL, 0x000176000000000dULL, 0x00001210003f0107ULL, 0x0001768800000000ULL,
0x00001b20003f0101ULL, 0x0000000000000049ULL, 0x00001c2000040107ULL, 0x0000000000000049ULL,
0x00001ca000040101ULL, 0x0000002000000002ULL, 0x00001df0003f0101ULL, 0x000176c800000035ULL,
0x00001f70003f0109ULL, 0x000176c800000035ULL, 0x00002910003f0109ULL, 0x000176b000000056ULL,
0x00002950003f0107ULL, 0x000176b000000056ULL, 0x00002960003f0101ULL, 0x0001760800000052ULL,
0x00002980003f0101ULL, 0x0001760800000052ULL, 0x00002af0003f0109ULL, 0x0001760800000052ULL,
0x00003040003f0109ULL, 0x000176a800000036ULL, 0x000031b0003f0109ULL, 0x000176a800000036ULL,
0x000042c0003f0109ULL, 0x000176c800000034ULL, 0x000042e0003f0101ULL, 0x000176880000004eULL,
0x00004390003f0101ULL, 0x0000000000000004ULL, 0x00004500003f0109ULL, 0x0000000000000004ULL,
0x00004d80003f0109ULL, 0x000176a800000016ULL, 0x00004df0003f0107ULL, 0x000176a800000016ULL,
0x00004e00003f0101ULL, 0x0001762800000052ULL, 0x00004e20003f0101ULL, 0x0001762800000052ULL,
0x00004f90003f0109ULL, 0x0001762800000052ULL, 0x000054b0003f0109ULL, 0x000176b000000037ULL,
0x00005620003f0109ULL, 0x000176b000000037ULL, 0x00006550003f0109ULL, 0x000176c800000036ULL,
0x00006570003f0101ULL, 0x000176900000005aULL, 0x000065c0003f0101ULL, 0x0000000000000004ULL,
0x00006730003f0109ULL, 0x0000000000000004ULL, 0x00006fb0003f0109ULL, 0x000176b000000016ULL,
0x00007020003f0107ULL, 0x000176b000000016ULL, 0x00007030003f0101ULL, 0x0001764800000052ULL,
0x00007050003f0101ULL, 0x0001764800000052ULL, 0x000071c0003f0109ULL, 0x0001764800000052ULL,
0x000076e0003f0109ULL, 0x000176a800000037ULL, 0x00007850003f0109ULL, 0x000176a800000037ULL,
0x00008730003f0109ULL, 0x000176c800000034ULL, 0x00008750003f0101ULL, 0x000176980000003eULL,
0x00008800003f0101ULL, 0x0000000000000004ULL, 0x00008970003f0109ULL, 0x0000000000000004ULL,
0x00009280003f0109ULL, 0x000176a800000014ULL, 0x000092c0003f0107ULL, 0x000176a800000014ULL,
0x000092d0003f0101ULL, 0x0001766800000007ULL, 0x00009300003f0101ULL, 0x0001766800000007ULL,
0x00009470003f0109ULL, 0x0001766800000007ULL, 0x00009980003f0109ULL, 0x000176b000000037ULL,
0x00009af0003f0109ULL, 0x000176b000000037ULL, 0x0000a970003f0109ULL, 0x0000000000000004ULL,
0x0000a9f0003f0101ULL, 0x000176a000000004ULL, 0x0000bec0003f0101ULL, 0x000176000000000dULL,
0x0000d840003f0101ULL, 0x000176000000000dULL, 0x0000da00003f0109ULL, 0x000176000000000dULL,
0x0000dbe0003f0109ULL, 0x000176000000000dULL, 0x0000dc00003f0101ULL, 0x000176000000000dULL,
0x0000dd70003f0109ULL, 0x000176000000000dULL, 0x00010940003f0109ULL, 0x000176880000000bULL,
0x00010b10003f0101ULL, 0x000176880000000bULL, 0x00010c80003f0109ULL, 0x000176880000000bULL,
0x00012fb0003f0109ULL, 0x000176080000000fULL, 0x00012fd0003f0101ULL, 0x000176100000000fULL,
0x00012fe0003f0101ULL, 0x000176180000000fULL, 0x00012ff0003f0101ULL, 0x000176200000000fULL,
0x00053803003f0101ULL, 0x0000b58000201c04ULL, 0x0000b8700000b5b0ULL, 0x0000bc600000ba60ULL,
0x0000dda00000be10ULL, 0x000c050400013010ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x0000000000013020ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000077919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x000000ff0200720cULL, 0x004fca0003f45070ULL, 0x00008500ff027b82ULL, 0x000ea20000000800ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000f220000000a00ULL,
0x0000000107032836ULL, 0x008fe40000000000ULL, 0x0000000407082825ULL, 0x010fc800078e0004ULL,
0x0000000403042825ULL, 0x000fe200078e0004ULL, 0x0000000608062981ULL, 0x000728000c1e1900ULL,
0x0000000604032981ULL, 0x000b22000c1e1900ULL, 0x0000000200007306ULL, 0x004ea20000209000ULL,
0x00000400ff0c7b82ULL, 0x000f620000000800ULL, 0x000000ff0200720cULL, 0x000fe20003f65070ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x008ee60000002100ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe000a7836ULL, 0x004fcc0000000000ULL, 0x0000000a000b7305ULL, 0x000562000021f000ULL,
0x00000005ff407819ULL, 0x008fe20000011609ULL, 0x000000ffff0a7224ULL, 0x004fca00078e00ffULL,
0x00001fff40407589ULL, 0x000f2200000e0000ULL, 0x000000ffff0d7224ULL, 0x022fc800078e0a0bULL,
0x000000020d0d7224ULL, 0x000fc800078e02ffULL, 0x0000000d0b0b7227ULL, 0x000fe400078e000aULL,
0x00000000000d7919ULL, 0x000e680000002200ULL, 0x0000000c0b0b7227ULL, 0x000fe200078e00ffULL,
0x00000000000a7919ULL, 0x000ea60000002600ULL, 0x000000ffff057224ULL, 0x000fc800078e0a0bULL,
0x0000000502057224ULL, 0x000fe400078e020cULL, 0x00000000000c7919ULL, 0x000e660000002300ULL,
0x000000020500720cULL, 0x000fda0003f06070ULL, 0x0000000105050824ULL, 0x000fe400078e0a02ULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x000000020500720cULL, 0x000fda0003f26070ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000002ff0bb212ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000ee20000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047836ULL, 0x008fe40000000000ULL,
0x000000040c007c24ULL, 0x002fe2000f8e020dULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000050b087224ULL, 0x008fc800078e02ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a08ULL,
0x00008400ff08ab82ULL, 0x000e640000000800ULL, 0x0000000f05057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0209ULL, 0x0000000a05437227ULL, 0x004fc600078e00ffULL,
0x0000007f0400780cULL, 0x040fe20003fa4070ULL, 0x000000ffff057224ULL, 0x000fe200078e0a43ULL,
0x000000030400780cULL, 0x000fc60003f84070ULL, 0x000000050b007224ULL, 0x000fca00078e020aULL,
0x0000000b0000720cULL, 0x000fc60003f06070ULL, 0x00000000000ed919ULL, 0x000eb40000008800ULL,
0x0000000100000824ULL, 0x000fc400078e0a0bULL, 0x0000000143430836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0000000b0000720cULL, 0x000fda0003f26070ULL,
0x0000000143431836ULL, 0x000fe20000000000ULL, 0x0000000bff43b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff417224ULL, 0x000fc800078e0a43ULL, 0x000000410b417224ULL, 0x000fe400078e020aULL,
0xff317217ff0ad424ULL, 0x000fe400078e00ffULL, 0x0000000103002824ULL, 0x010fe200078e0a06ULL,
0x000004000003d802ULL, 0x000fc80000000f00ULL, 0x000006540e05d816ULL, 0x004fe20000000003ULL,
0x00008400ff00ab82ULL, 0x000ea20000000800ULL, 0x00001fff0c037589ULL, 0x00066600000e0000ULL,
0x000000040405d824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x002fec0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x010fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000f340000000000ULL, 0x01760008043f75b2ULL, 0x0009240008000100ULL,
0x0000000000007918ULL, 0x01cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404097c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000090812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01760804083f75b2ULL, 0x0009300008000100ULL, 0xfffffffd00e81947ULL, 0x01cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404097c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01768804083f75b2ULL, 0x0009300008000100ULL,
0xfffffffd00e81947ULL, 0x01cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0174000a0500d388ULL, 0x0007e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001041417824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404057c11ULL, 0x008fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0176a804093f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x008fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0176c804093f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000800047c24ULL, 0x004fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a41ULL, 0x000000410400720cULL, 0x000fe20003f06070ULL,
0x000000080706a224ULL, 0x002fc400078e02ffULL, 0x0000000802117c24ULL, 0x000fe2000f8e02ffULL,
0x00000010040f7446ULL, 0x000fe2000380000fULL, 0x0000000403047824ULL, 0x000fe400078e0240ULL,
0x00000011060e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x0000000204087824ULL, 0x000fe400078e00ffULL, 0x0000000843137c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c08947ULL, 0x000fea0003800000ULL,
0x0000000800097d06ULL, 0x000e620008209000ULL, 0x00000000000c7919ULL, 0x008ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ee60000008800ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe09057836ULL, 0x002fe20000000000ULL,
0x00000004ff0b7819ULL, 0x004fca000001160cULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x00000001080a7824ULL, 0x000fe400078e020bULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL,
0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d050d7227ULL, 0x000fc800078e0004ULL,
0x0000000141047824ULL, 0x000fc800078e020aULL, 0x000000040d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0dULL, 0x0000000809057c24ULL, 0x000fe2000f8e0204ULL,
0x000000080f097248ULL, 0x000fc80007fe0000ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x000000010d0d0836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x000000010d0d1836ULL, 0x000fe20000000000ULL,
0x00000008ff0dac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a0dULL,
0x0000000805047c24ULL, 0x000fe4000f8e0204ULL, 0x000000100c057824ULL, 0x000fe400078e00ffULL,
0x0000000113047824ULL, 0x000fc800078e0204ULL, 0x000000110d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000109047824ULL, 0x000fe400078e0a08ULL, 0x000001000d087825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fe400078ec0ffULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000010a047824ULL, 0x040fe200078e020cULL, 0x00000400000b7802ULL, 0x000fe20000000f00ULL,
0x000000100a117824ULL, 0x000fe200078e00ffULL, 0x0000000d08087212ULL, 0x000fc400078efcffULL,
0x00000654100d7816ULL, 0x008fe4000000000bULL, 0xfffffff011047812ULL, 0x000fe400078ee204ULL,
0x0000000408087c10ULL, 0x000fc6000ff3e0ffULL, 0x00000010040b7824ULL, 0x000fe200078e020dULL,
0x0000000509097c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x0000000800097d06ULL, 0x000e620008209000ULL, 0x00000000000c7919ULL, 0x008ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ee60000008800ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090b7836ULL, 0x002fe20000000000ULL,
0x000000080c0a7211ULL, 0x004fca00078fe0ffULL, 0x0000000b00057305ULL, 0x000e64000021f000ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d05057227ULL, 0x000fe200078e0004ULL, 0x00000400000d7802ULL, 0x000fc60000000f00ULL,
0x0000000141047824ULL, 0x000fe200078e020aULL, 0x00000654100d7816ULL, 0x008fc6000000000dULL,
0x0000000405057227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x0000000809087c24ULL, 0x000fca000f8e0204ULL, 0x0000000808007c0cULL, 0x000fda000bf06070ULL,
0x8000000808080c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fc60000000000ULL,
0x0000000808007c0cULL, 0x000fda000bf26070ULL, 0x0000000105051836ULL, 0x000fe20000000000ULL,
0x00000008ff05ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x0000000809047c24ULL, 0x000fc8000f8e0204ULL, 0x0000000113047824ULL, 0x000fc800078e0204ULL,
0x0000001105047224ULL, 0x000fe400078e0204ULL, 0x000000100c057824ULL, 0x000fe400078e00ffULL,
0x0000010004087825ULL, 0x000fc600078e00ffULL, 0x000000f0050b7812ULL, 0x000fe200078ec0ffULL,
0x000000010a047824ULL, 0x000fc600078e020cULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x000000100a0b7824ULL, 0x000fc600078e00ffULL, 0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff00b047812ULL, 0x000fe400078ee204ULL, 0x0000000509097c10ULL, 0x000fc600087fe4ffULL,
0x00000010040b7824ULL, 0x000fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e4000b901c46ULL, 0x000000000d0472caULL, 0x000fe200000e0000ULL,
0x00009400ff087b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001760004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000407087825ULL, 0x002fe200078e0008ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006083b7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000003f3b3a7836ULL, 0x004fe40000000000ULL,
0x000000ff3b037836ULL, 0x000fc60000000000ULL, 0x00000006ff3a7819ULL, 0x000fe4000001163aULL,
0x00000008ff397819ULL, 0x000fca0000011603ULL, 0x000000ac00308947ULL, 0x000fea0003800000ULL,
0x00000002ff0a7819ULL, 0x000fe20000011640ULL, 0x00000004ff137424ULL, 0x000fc600078e00ffULL,
0x03ffffff0a097812ULL, 0x000fc800078ec0ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x00009600ff0b8b82ULL, 0x000e620000000800ULL, 0x0000000207008824ULL, 0x000fce00078e00ffULL,
0x00009200ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000b00008224ULL, 0x002fc800078e020bULL,
0x00000001090b8824ULL, 0x000fe400078e0200ULL, 0x0000000840007824ULL, 0x000fe400078e020dULL,
0x000000040b108825ULL, 0x004fe400078e0010ULL, 0x0176881300ff79a7ULL, 0x0003e4000850003fULL,
0xffffffffff0b7424ULL, 0x000fcc00078e00ffULL, 0x00000006100b8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0300780cULL, 0x000fe40003f04070ULL, 0x00000001ff387819ULL, 0x000fe40000011640ULL,
0x0000000140007812ULL, 0x002fc600078ec0ffULL, 0x0000002038087824ULL, 0x000fe400078e00ffULL,
0x000000020b037224ULL, 0x004fe400078e02ffULL, 0x00000040430b7824ULL, 0x000fe400078e00ffULL,
0x00000040031b7824ULL, 0x000fc600078e00ffULL, 0x000000200b027812ULL, 0x000fe200078ef808ULL,
0x0000000400080947ULL, 0x000fec0003800000ULL, 0x000000083b037248ULL, 0x000fe20007fe0000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe2000001160cULL,
0x00009000ff1e7b82ULL, 0x000e640000000a00ULL, 0x0000000103037824ULL, 0x000fe400078e0a08ULL,
0x0000000104117824ULL, 0x000fe400078e0206ULL, 0x0000000406127836ULL, 0x000fe20000000000ULL,
0x0000000403037248ULL, 0x000fe20007fe0000ULL, 0x0000000111107824ULL, 0x000fc400078e020cULL,
0x0000000811137824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc600078e0a04ULL,
0xfffffff813167812ULL, 0x000fe200078ee210ULL, 0x0000000104137824ULL, 0x000fe200078e0212ULL,
0x000000031200720cULL, 0x080fe20003f46070ULL, 0x0000000806107836ULL, 0x000fe20000000000ULL,
0x000000030600720cULL, 0x080fe20003f66070ULL, 0x0000000c06127836ULL, 0x000fe40000000000ULL,
0x0000000104157824ULL, 0x000fe200078e0210ULL, 0x000000031000720cULL, 0x080fe20003f26070ULL,
0x0000000104177824ULL, 0x000fe200078e0212ULL, 0x000000031200720cULL, 0x000fe20003f06070ULL,
0x0000000102037824ULL, 0x000fc400078e0211ULL, 0x0000000113067824ULL, 0x040fe400078e020cULL,
0x0000000813197824ULL, 0x000fe400078e00ffULL, 0x0000000102107824ULL, 0x040fe400078e0213ULL,
0x0000000102127824ULL, 0x040fe200078e0215ULL, 0xfffffff819067812ULL, 0x000fe200078ee206ULL,
0x0000000102147824ULL, 0x000fe200078e0217ULL, 0x0000001e1b197211ULL, 0x002fe200078838ffULL,
0x0000008003027825ULL, 0x000fc600078e00ffULL, 0x0000001f1b1f7211ULL, 0x000fe200020f3cffULL,
0x0000000117117824ULL, 0x140fe200078e020cULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x00000008171a7824ULL, 0x000fe400078e00ffULL, 0x0000000115047824ULL, 0x040fe200078e020cULL,
0x0000000219027210ULL, 0x000fe20007f9e0ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff815187812ULL, 0x000fe200078ee204ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010177812ULL, 0x000fc600078ef805ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007012107812ULL, 0x000fc600078ef805ULL, 0x0000200038047824ULL, 0x000fe200078e020dULL,
0x0000007014127812ULL, 0x000fe200078ef805ULL, 0x0000000103037824ULL, 0x000fe200020e061fULL,
0x0000001910107210ULL, 0x000fe20007fbe0ffULL, 0x0001300004057836ULL, 0x000fe20000000000ULL,
0x0000001917047210ULL, 0x000fe40007f9e0ffULL, 0x0000001912127210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x100fe400078e0205ULL, 0x0000001006197824ULL, 0x000fc400078e0205ULL,
0x00000010181b7824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000d901c46ULL, 0x000000101a1d7824ULL, 0x000fe400078e0205ULL,
0x0000000111057824ULL, 0x100fe400020e061fULL, 0x0000000113117824ULL, 0x100fe400028e061fULL,
0x0000000115137824ULL, 0x000fe200030e061fULL, 0x0000000004197faeULL, 0x0003e8000d101c46ULL,
0x00000000101b7faeULL, 0x0003e8000c901c46ULL, 0x00000000121d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x000fe200078e00ffULL,
0x00009000ff187b82ULL, 0x000e680000000a00ULL, 0x000000030c037211ULL, 0x000fca00078fe8ffULL,
0x0000000103047824ULL, 0x140fe400078e020cULL, 0x0000000803137824ULL, 0x000fe400078e00ffULL,
0x0000000403117836ULL, 0x000fe40000000000ULL, 0x0000000c03157836ULL, 0x000fe20000000000ULL,
0xfffffff813067812ULL, 0x000fe200078ee204ULL, 0x0000000111107824ULL, 0x040fe400078e020cULL,
0x0000000811177824ULL, 0x000fc400078e00ffULL, 0x0000000803137836ULL, 0x000fe40000000000ULL,
0x0000000102047824ULL, 0x040fe200078e0203ULL, 0xfffffff817167812ULL, 0x000fe200078ee210ULL,
0x0000000102117824ULL, 0x040fe200078e0211ULL, 0x000000181b177211ULL, 0x042fe200078038ffULL,
0x0000000102127824ULL, 0x040fe400078e0213ULL, 0x0000000102147824ULL, 0x000fe200078e0215ULL,
0x000000191b1f7211ULL, 0x000fe200000f3cffULL, 0x0000008004027825ULL, 0x000fc800078e00ffULL,
0x0000000115107824ULL, 0x100fe200078e020cULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000000113047824ULL, 0x000fe400078e020cULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x0000000217027210ULL, 0x000fe20007f1e0ffULL, 0x0000000813137824ULL, 0x000fe400078e00ffULL,
0x0000200038197824ULL, 0x000fe200078e020dULL, 0xfffffff8151a7812ULL, 0x000fe200078ee210ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0xfffffff813187812ULL, 0x000fc600078ee204ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010047812ULL, 0x000fc600078ef805ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000007012107812ULL, 0x000fc600078ef805ULL,
0x0000000103037824ULL, 0x000fe200000e061fULL, 0x0000007014057812ULL, 0x000fe200078ef805ULL,
0x00013000191d7836ULL, 0x000fe20000000000ULL, 0x0000000417047210ULL, 0x000fe40007f1e0ffULL,
0x0000001017107210ULL, 0x000fe20007f3e0ffULL, 0x0000001016197824ULL, 0x100fe200078e021dULL,
0x0000000517127210ULL, 0x000fe20007f5e0ffULL, 0x0000001006177824ULL, 0x000fe400078e021dULL,
0x0000000111057824ULL, 0x000fc400000e061fULL, 0x00000010181b7824ULL, 0x000fe200078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e2000b901c46ULL,
0x0000000113117824ULL, 0x000fe400008e061fULL, 0x000000101a1d7824ULL, 0x000fe200078e021dULL,
0x0000000004197faeULL, 0x0003e2000b901c46ULL, 0x0000000115137824ULL, 0x000fc600010e061fULL,
0x00000000101b7faeULL, 0x0003e8000b901c46ULL, 0x00000000121d7faeULL, 0x0003e4000b901c46ULL,
0x0000000109097836ULL, 0x000fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a0900720cULL, 0x000fe20003f06070ULL, 0x000176a80d497836ULL, 0x000fe20000000000ULL,
0x00000000380472caULL, 0x000fd600000e0000ULL, 0x00009600ff058b82ULL, 0x002e620000000800ULL,
0x00000000490572caULL, 0x000fe200000e0000ULL, 0x0000000207048824ULL, 0x000fcc00078e00ffULL,
0x00009200ff028b82ULL, 0x000ea20000000a00ULL, 0x0000000404047899ULL, 0x000fca000800063fULL,
0x0000000504057290ULL, 0x000fe2000fffe03fULL, 0x0000000504048224ULL, 0x002fc800078e0205ULL,
0x0000000104058824ULL, 0x000fc800078e0209ULL, 0x0000000405028825ULL, 0x004fe200078e0002ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000602538981ULL, 0x000322000c1e1900ULL,
0x000000ff3900720cULL, 0x000fe20003f05270ULL, 0x00000001ff047424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x0000000838027824ULL, 0x002fe200078e0249ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000004494879a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00002004020279a7ULL, 0x0002e2000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000008c00b88947ULL, 0x000fec0003800000ULL,
0x00009600ff137b82ULL, 0x000f620000000800ULL, 0x00000004ff057e24ULL, 0x000fe4000f8e00ffULL,
0x000000200a027824ULL, 0x008fe400078e020dULL, 0x0000000207067824ULL, 0x000fe200078e00ffULL,
0x0000001005057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe400078e0003ULL,
0xff317217ff557424ULL, 0x000fe400078e00ffULL, 0x0000000102057824ULL, 0x000fc800078e0205ULL,
0x0000000800077824ULL, 0x000fe400078e0205ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x0000001306067224ULL, 0x022fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x000000ffff457224ULL, 0x000fce00078e0009ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000000440047824ULL, 0x000fca00078e00ffULL, 0xfffffff804047812ULL, 0x000fca00078ec0ffULL,
0x000000010d357824ULL, 0x000fc800078e0204ULL, 0x0176c834350075a7ULL, 0x000e62000800017fULL,
0x000176c835047836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176c834350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001040147824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000000105347836ULL, 0x000fc60000000000ULL,
0xffffffe014167812ULL, 0x000fe400078ec0ffULL, 0x000000393400720cULL, 0x000fe20003f26070ULL,
0x0000000453347c24ULL, 0x010fe4000f8e02ffULL, 0x0000010005167824ULL, 0x000fe400078e0216ULL,
0x0000004034347824ULL, 0x000fe400078e00ffULL, 0x0000004016157836ULL, 0x000fca0000000000ULL,
0x0000002015167812ULL, 0x000fca00078ec0ffULL, 0x000000010b467824ULL, 0x000fe200078e0216ULL,
0x0000000400109947ULL, 0x000fec0003800000ULL, 0x0000001014177812ULL, 0x000fe400078ec0ffULL,
0x000000153b147248ULL, 0x000fe40007fe0000ULL, 0x00000003ff377819ULL, 0x000fc6000001160cULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000137357824ULL, 0x100fe400078e0217ULL,
0x0000000c373c7836ULL, 0x000fe20000000000ULL, 0x0000001714167248ULL, 0x000fe20007fe0000ULL,
0x0000000135367824ULL, 0x040fe200078e020cULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x00000008353d7824ULL, 0x000fe400078e00ffULL, 0x0000000116167824ULL, 0x000fc400078e0a17ULL,
0x000000013c3f7824ULL, 0x140fe200078e0217ULL, 0xfffffff83d3e7812ULL, 0x000fe200078ee236ULL,
0x0000000437367836ULL, 0x000fe20000000000ULL, 0x000000163700720cULL, 0x080fe20003f86070ULL,
0x00000008373d7836ULL, 0x000fe20000000000ULL, 0x000000163c00720cULL, 0x080fe20003f06070ULL,
0x0000000136377824ULL, 0x140fe200078e0217ULL, 0x000000163600720cULL, 0x080fe20003f66070ULL,
0x000000100c367824ULL, 0x000fe200078e00ffULL, 0x000000163d00720cULL, 0x040fe20003f46070ULL,
0x000000013d3d7824ULL, 0x000fc400078e0217ULL, 0x0000000137167824ULL, 0x140fe400078e020cULL,
0x0000000837477824ULL, 0x000fe400078e00ffULL, 0x00000001463c7824ULL, 0x000fe400078e0235ULL,
0x000000013d177824ULL, 0x040fe200078e020cULL, 0xfffffff847427812ULL, 0x000fe200078ee216ULL,
0x000000083d447824ULL, 0x000fe200078e00ffULL, 0x0000007036477812ULL, 0x000fe200078ec0ffULL,
0x0000000146167824ULL, 0x000fc400078e023dULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fc600078ee217ULL, 0x0000000146377824ULL, 0x040fe400078e0237ULL,
0x0000000146357824ULL, 0x000fe400078e023fULL, 0x000000013f177824ULL, 0x040fe400078e020cULL,
0x000000083f467824ULL, 0x000fe200078e00ffULL, 0x00000014343f7211ULL, 0x002fe200078a38ffULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x000000473c147212ULL, 0x000fe400078efcffULL,
0x00000015344d7211ULL, 0x000fe200028f3cffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x000000143f147210ULL, 0x000fc40007fbe0ffULL, 0xfffffff8463c7812ULL, 0x000fe200078ee217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004736367212ULL, 0x080fe400078efcffULL,
0x0000004734347212ULL, 0x080fe200078efcffULL, 0x000000013d157824ULL, 0x000fe200028e064dULL,
0x0000003f36367210ULL, 0x000fe20007fbe0ffULL, 0x00002000383d7824ULL, 0x000fe200078e020dULL,
0x0000004716167212ULL, 0x000fe400078efcffULL, 0x0000003f34347210ULL, 0x000fe20007fde0ffULL,
0x000140003d3d7836ULL, 0x000fc40000000000ULL, 0x0000000137377824ULL, 0x000fe200028e064dULL,
0x0000003f16167210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3f7824ULL, 0x100fe400078e023dULL,
0x0000001042477824ULL, 0x100fe400078e023dULL, 0x00000010444b7824ULL, 0x000fe200078e023dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000e101c46ULL,
0x0000000117177824ULL, 0x000fe400028e064dULL, 0x000000103c3d7824ULL, 0x000fe200078e023dULL,
0x0000000036477faeULL, 0x0003e2000d901c46ULL, 0x0000000135357824ULL, 0x000fc600030e064dULL,
0x00000000164b7faeULL, 0x0003e8000d101c46ULL, 0x00000000343d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000dc7947ULL, 0x000fea0003800000ULL, 0x0000001014177812ULL, 0x000fe400078ec0ffULL,
0x00009000ff147b82ULL, 0x000e640000000a00ULL, 0x000000170c177211ULL, 0x000fca00078fe8ffULL,
0x0000000417357836ULL, 0x000fe40000000000ULL, 0x0000000117167824ULL, 0x140fe400078e020cULL,
0x0000000817377824ULL, 0x000fe400078e00ffULL, 0x0000000135367824ULL, 0x040fe400078e020cULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8373e7812ULL, 0x000fe200078ee216ULL,
0x0000000146167824ULL, 0x000fc400078e0217ULL, 0x0000000817377836ULL, 0x000fe20000000000ULL,
0xfffffff83d427812ULL, 0x000fe200078ee236ULL, 0x000000100c367824ULL, 0x000fe400078e00ffULL,
0x0000000c173d7836ULL, 0x000fe20000000000ULL, 0x00000014344b7211ULL, 0x002fe200078038ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007036477812ULL, 0x000fe400078ec0ffULL,
0x00000015344f7211ULL, 0x000fe200000f3cffULL, 0x0000000146357824ULL, 0x000fe200078e0235ULL,
0x0000004716147212ULL, 0x000fe200078efcffULL, 0x0000000146367824ULL, 0x000fc400078e0237ULL,
0x00000001463f7824ULL, 0x000fe200078e023dULL, 0x000000144b147210ULL, 0x000fe20007f1e0ffULL,
0x00000001373c7824ULL, 0x140fe400078e020cULL, 0x00000008374d7824ULL, 0x000fe400078e00ffULL,
0x000000013d377824ULL, 0x040fe400078e020cULL, 0x000000083d467824ULL, 0x000fe200078e00ffULL,
0xfffffff84d447812ULL, 0x000fe200078ee23cULL, 0x0000008035347825ULL, 0x000fc600078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004734167212ULL, 0x000fc600078efcffULL, 0x000000803f3c7825ULL, 0x000fe200078e00ffULL,
0x0000004736347212ULL, 0x000fc600078efcffULL, 0x0000000117157824ULL, 0x000fe200000e064fULL,
0x000000473c367212ULL, 0x000fe200078efcffULL, 0x0000200038177824ULL, 0x000fe200078e020dULL,
0x000000164b167210ULL, 0x000fe40007f1e0ffULL, 0x000000344b347210ULL, 0x000fe20007f5e0ffULL,
0x0001400017177836ULL, 0x000fe20000000000ULL, 0x000000364b367210ULL, 0x000fc60007f7e0ffULL,
0x000000103e3f7824ULL, 0x100fe400078e0217ULL, 0x0000001042477824ULL, 0x100fe400078e0217ULL,
0x00000010444b7824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000b901c46ULL, 0x00000010464d7824ULL, 0x000fe400078e0217ULL,
0x0000000135177824ULL, 0x100fe400000e064fULL, 0x0000000137357824ULL, 0x000fc400010e064fULL,
0x000000013d377824ULL, 0x000fe200018e064fULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e4000b901c46ULL,
0x0000000109177836ULL, 0x002fe40000000000ULL, 0xffffffffff4c7424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016347812ULL, 0x000fce00078ec0ffULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x000000010d567824ULL, 0x000fe400078e0234ULL, 0x0000000106178824ULL, 0x000fc600078e0217ULL,
0x00000000560472caULL, 0x000fe400000e0000ULL, 0xffffffe016347812ULL, 0x000fd600078ec0ffULL,
0x000176b004047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fe200078e0014ULL,
0x0000001016177812ULL, 0x000fc800078ec0ffULL, 0x0000000d17177210ULL, 0x000fe20007ffe034ULL,
0x00000006144c8981ULL, 0x000322000c1e1900ULL, 0x0000000816527812ULL, 0x000fe200078ec0ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000117527824ULL, 0x000fe200078e0252ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176b035565679a7ULL, 0x000664000850003fULL,
0x01760835523479a7ULL, 0x0086a4000850003fULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x01760835520075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01760835520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000100c447824ULL, 0x000fe200078e00ffULL,
0x00000001ff477819ULL, 0x000fe2000001160cULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000007044447812ULL, 0x000fe400078ec0ffULL,
0xffffff8014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c47477812ULL, 0x000fe400078ec0ffULL,
0x0000000d44147210ULL, 0x000fca0007ffe014ULL, 0x0000000114147824ULL, 0x000fca00078e0247ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000000fc8947ULL, 0x00cfea0003800000ULL,
0x000000400a00720cULL, 0x000fe40003f45270ULL, 0x000000551600720bULL, 0x0c0fe40003f14000ULL,
0x0000005516377209ULL, 0x000fd20007810000ULL, 0x000000804014a824ULL, 0x000fe400078e020dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x000000144714a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400371400a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000003755557221ULL, 0x000fe20000010000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b55557820ULL, 0x000fcc0000410000ULL,
0x0000005500557308ULL, 0x000e680000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fcc000001160cULL, 0x00001f1455147589ULL, 0x002e6400000e0000ULL,
0x0000001418187220ULL, 0x082fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x000fce0000410000ULL,
0x0000005554547220ULL, 0x002fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c147811ULL, 0x000fcc00078ff0ffULL, 0x00001f1455147589ULL, 0x000e6400000e0000ULL,
0x000000141a1a7220ULL, 0x082fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fd400078e0037ULL, 0x8000003716160221ULL, 0x100fe20000010000ULL,
0x000000ffff550224ULL, 0x000fe200078e0037ULL, 0x00007610ff340816ULL, 0x000fe40000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000e640000000800ULL,
0x0000000217170220ULL, 0x002fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d367824ULL, 0x000fc800078e0216ULL,
0x0176a849360075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a849360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x00000002404e7824ULL, 0x000fe200078e00ffULL, 0x000000070c5d7812ULL, 0x000fe200078ec0ffULL,
0x00000004404a7824ULL, 0x040fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x0000020040147824ULL, 0x000fe200078e00ffULL, 0x000000044e157812ULL, 0x000fe200078ec0ffULL,
0x00002000384f7824ULL, 0x000fe200078e020dULL, 0x000000085d5b7812ULL, 0x000fe400078ef80cULL,
0x000000150c427211ULL, 0x040fe200078fe0ffULL, 0x000130004f487836ULL, 0x000fe20000000000ULL,
0x000000080c5a7812ULL, 0x000fe200078ec0ffULL, 0x000000085b357824ULL, 0x040fe200078e00ffULL,
0x00000004ff5f7819ULL, 0x000fe2000001160cULL, 0x000000015b427824ULL, 0x000fe200078e0242ULL,
0x000000044a4a7812ULL, 0x000fc400078ec0ffULL, 0x0000005d5a177212ULL, 0x000fe400078efcffULL,
0xfffff80014147812ULL, 0x000fe200078ec0ffULL, 0x000000015f4a7824ULL, 0x000fe200078e024aULL,
0xfffffff835467812ULL, 0x000fe200078ee242ULL, 0x0000000817167824ULL, 0x040fe400078e00ffULL,
0x0000000117157824ULL, 0x000fe400078e024aULL, 0x000000010d4b7824ULL, 0x000fe400078e0214ULL,
0x0000000817347824ULL, 0x000fe200078e00ffULL, 0xfffffff816517812ULL, 0x000fe200078ee215ULL,
0x00000002154d7836ULL, 0x000fc40000000000ULL, 0x0000001046507824ULL, 0x000fe200078e024bULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160cULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011000005014783bULL, 0x0022e20000000200ULL,
0x00000010513c7824ULL, 0x000fe200078e0248ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0xfffffff8344d7812ULL, 0x000fe400078ee24dULL,
0x000000105a5d7812ULL, 0x000fc600078efe5dULL, 0x000000104d347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff6a7819ULL, 0x022fe2000001143dULL,
0x000001003d617824ULL, 0x040fe200078e00ffULL, 0x000088803d6e7816ULL, 0x040fe200000000ffULL,
0x000001003c5c7824ULL, 0x040fe200078e00ffULL, 0x000088803c637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff607819ULL, 0x008fe40000011434ULL, 0x0000888034647816ULL, 0x000fe400000000ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000005c00707306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff5e7819ULL, 0x000fe40000011435ULL,
0x0000888035627816ULL, 0x000fc400000000ffULL, 0x000088803e687816ULL, 0x040fe200000000ffULL,
0x0000003d00737306ULL, 0x0007e20000200c00ULL, 0x000001003e5c7824ULL, 0x042fe200078e00ffULL,
0x000088803f667816ULL, 0x000fe400000000ffULL, 0x00000018ff587819ULL, 0x000fe2000001143eULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000100343d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011436ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011437ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006100757306ULL, 0x000e620000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x00000018ff3e7819ULL, 0x000fc6000001143eULL,
0x0000005c006f7306ULL, 0x0007f00000200c00ULL, 0x0000003400677306ULL, 0x000be20000200c00ULL,
0x00000100355c7824ULL, 0x048fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000003c00717306ULL, 0x0007e20000200c00ULL,
0x0000010037347824ULL, 0x024fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x000001003f3c7824ULL, 0x048fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006a006a7306ULL, 0x000ee20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fce000001143fULL, 0x0000003500657306ULL, 0x0003f00000200c00ULL,
0x0000003400617306ULL, 0x000be20000200c00ULL, 0x000054106e357816ULL, 0x002fce0000000075ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000541063347816ULL, 0x020fce0000000070ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x0000003c006d7306ULL, 0x000a620000200c00ULL, 0x0000541071347816ULL, 0x004fe4000000006cULL,
0x0000541073357816ULL, 0x008fca000000006aULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00000100363c7824ULL, 0x020fe200078e00ffULL, 0x00000034142c723cULL, 0x000fe8000000182cULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x0000003d00697306ULL, 0x0004e20000200c00ULL,
0x0000541068347816ULL, 0x002fe4000000006fULL, 0x0000541066357816ULL, 0x000fc4000000006dULL,
0x00008880373c7816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fe400078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00008880363d7816ULL, 0x044fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x00000018ff377819ULL, 0x000fc60000011437ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000005c006b7306ULL, 0x000e640000200c00ULL, 0x0000541064347816ULL, 0x008fcc0000000069ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x0000541062357816ULL, 0x002fce000000006bULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541065357816ULL, 0x004fe4000000005eULL,
0x0000541067347816ULL, 0x002fca0000000060ULL, 0x00000072005c7306ULL, 0x000e620000200c00ULL,
0x0000000438607824ULL, 0x000fe200078e025fULL, 0x000000341420723cULL, 0x000fe80000001820ULL,
0x0000000260607810ULL, 0x000fe40007ffe05bULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x000000085b5b7824ULL, 0x000fca00078e00ffULL, 0xfffffff85b607812ULL, 0x000fe400078ee260ULL,
0x0000003e00637306ULL, 0x000fe20000200c00ULL, 0x000054103d347816ULL, 0x002fe4000000005cULL,
0x000054103c357816ULL, 0x004fca0000000061ULL, 0x0000005800587306ULL, 0x000e640000200c00ULL,
0x00000034141c723cULL, 0x000fec000000181cULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000000085d357824ULL, 0x000fe200078e00ffULL, 0x0000541063587816ULL, 0x002fcc0000000058ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000000014a347824ULL, 0x000fe400078e025dULL,
0x00000010604a7824ULL, 0x000fc600078e024bULL, 0xfffffff8354b7812ULL, 0x000fe400078ee234ULL,
0x0000005900597306ULL, 0x000fe60000200c00ULL, 0x000000104b3c7824ULL, 0x000fca00078e0248ULL,
0x0000003600367306ULL, 0x000e700000200c00ULL, 0x0000003f003e7306ULL, 0x000ea20000200c00ULL,
0x0000541036367816ULL, 0x002fce0000000049ULL, 0x00000037005e7306ULL, 0x000e620000200c00ULL,
0x000054103e597816ULL, 0x004fce0000000059ULL, 0x000000581428723cULL, 0x000fe20000001828ULL,
0x000054105e377816ULL, 0x002fce0000000053ULL, 0x000000361410723cULL, 0x000fe20000001810ULL,
0x011000004a14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000085d367824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL,
0x0000000234497836ULL, 0x000fc80000000000ULL, 0x000000010d4e7824ULL, 0x000fe200078e024eULL,
0xfffffff836497812ULL, 0x000fca00078ee249ULL, 0x0000001049347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff697819ULL, 0x008fe2000001143cULL,
0x000001003c5b7824ULL, 0x040fe200078e00ffULL, 0x000088803c6a7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001143dULL,
0x000001003d5c7824ULL, 0x040fe200078e00ffULL, 0x000088803d6b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5b7819ULL, 0x000fc4000001145bULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff617819ULL, 0x000fe2000001143eULL, 0x0000003c006c7306ULL, 0x0007e20000200c00ULL,
0x000088803e657816ULL, 0x000fe400000000ffULL, 0x00000018ff5a7819ULL, 0x022fe40000011434ULL,
0x00000018ff597819ULL, 0x000fc40000011435ULL, 0x00008880345d7816ULL, 0x000fe200000000ffULL,
0x0000005b006d7306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x000088803f647816ULL, 0x040fe400000000ffULL, 0x00000018ff607819ULL, 0x000fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000001003e5b7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc40000011437ULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000005c006e7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff537819ULL, 0x000fca0000011436ULL, 0x0000003d006f7306ULL, 0x0007e20000200c00ULL,
0x00008880355c7816ULL, 0x002fce00000000ffULL, 0x0000003c00677306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x04cfe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001143cULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fca00000000ffULL, 0x0000005b00667306ULL, 0x000ff00000200c00ULL,
0x0000003e00627306ULL, 0x000ff00000200c00ULL, 0x00000034005b7306ULL, 0x000bf00000200c00ULL,
0x00000035003e7306ULL, 0x0007e20000200c00ULL, 0x000054106a347816ULL, 0x020fe2000000006dULL,
0x00000100376a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000006500657306ULL, 0x000f620000200c00ULL, 0x000054106b357816ULL, 0x008fce000000006eULL,
0x0000006400647306ULL, 0x000ee20000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x000054106c347816ULL, 0x004fe20000000069ULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x000054106f357816ULL, 0x002fce0000000068ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000034142c723cULL, 0x000fee000000182cULL, 0x0000003f00637306ULL, 0x0002a20000200c00ULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x0000541065347816ULL, 0x020fc80000000066ULL,
0x00000018ff657819ULL, 0x000fe40000011435ULL, 0x0000541064357816ULL, 0x008fe20000000067ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00008880373f7816ULL, 0x042fe200000000ffULL,
0x0001000037377824ULL, 0x000fc800078e00ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003d005e7306ULL, 0x0002ea0000200c00ULL,
0x0000541062347816ULL, 0x004fe40000000061ULL, 0x0000541063357816ULL, 0x000fe20000000060ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000341428723cULL, 0x000fe20000001828ULL,
0x0000005f005f7306ULL, 0x000e6c0000200c00ULL, 0x000054105d347816ULL, 0x008fe4000000005eULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000054105c357816ULL, 0x002fce000000005fULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105b347816ULL, 0x004fe4000000005aULL,
0x000054103e357816ULL, 0x002fca0000000059ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x00000001ff597424ULL, 0x000fe200078e00ffULL, 0x000000341420723cULL, 0x000fec0000001820ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000000838347824ULL, 0x000fe200078e020dULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0176c859343479a7ULL, 0x00026e000850003fULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x017688594eff79a7ULL, 0x0003ee000850003fULL, 0x0000006a00367306ULL, 0x000eb00000200c00ULL,
0x0000006500647306ULL, 0x000ee20000200c00ULL, 0x000054103f3d7816ULL, 0x004fce0000000036ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x0000541064647816ULL, 0x008fe40000000053ULL, 0x0000541037657816ULL, 0x004fce0000000058ULL,
0x000000641410723cULL, 0x002fde0000001810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000044c3e7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe016147812ULL, 0x000fe400078ec0ffULL,
0x000000403e3e7824ULL, 0x000fc600078e00ffULL, 0x0000010005147824ULL, 0x000fc800078e0214ULL,
0x0000008014157836ULL, 0x000fca0000000000ULL, 0x0000002015147812ULL, 0x000fca00078ec0ffULL,
0x000000010b177824ULL, 0x000fe200078e0214ULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x0000001016377812ULL, 0x000fe400078ec0ffULL, 0x00000003ff167819ULL, 0x000fe4000001160cULL,
0x000000153b147248ULL, 0x000fc60007fe0000ULL, 0x0000000116367824ULL, 0x000fe400078e0237ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000136157824ULL, 0x040fe400078e020cULL,
0x0000000836347824ULL, 0x000fe200078e00ffULL, 0x0000001437147248ULL, 0x000fe20007fe0000ULL,
0x00000004163c7836ULL, 0x000fe40000000000ULL, 0x00000008163d7836ULL, 0x000fe20000000000ULL,
0xfffffff834537812ULL, 0x000fe200078ee215ULL, 0x0000000114147824ULL, 0x000fe200078e0a37ULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x0000000136367824ULL, 0x000fc600078e0217ULL,
0x000000143c00720cULL, 0x0c0fe20003f66070ULL, 0x000000013c3c7824ULL, 0x100fe200078e0237ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000c16167836ULL, 0x000fe20000000000ULL,
0x000000143d00720cULL, 0x0c0fe20003f46070ULL, 0x000000013d3d7824ULL, 0x100fe400078e0237ULL,
0x000000013c157824ULL, 0x000fe200078e020cULL, 0x000000141600720cULL, 0x000fe20003f06070ULL,
0x000000083c4c7824ULL, 0x000fe400078e00ffULL, 0x0000000116377824ULL, 0x000fc400078e0237ULL,
0x000000013c3c7824ULL, 0x100fe200078e0217ULL, 0xfffffff84c597812ULL, 0x000fe200078ee215ULL,
0x000000013d167824ULL, 0x100fe400078e0217ULL, 0x0000000137147824ULL, 0x040fe400078e0217ULL,
0x0000000137177824ULL, 0x140fe200078e020cULL, 0x000000343e3f7211ULL, 0x042fe200078a38ffULL,
0x00000008374e7824ULL, 0x000fe400078e00ffULL, 0x000000013d157824ULL, 0x040fe200078e020cULL,
0x000000353e5b7211ULL, 0x000fe200028f3cffULL, 0x000000083d4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e5f7812ULL, 0x000fe200078ee217ULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84c5d7812ULL, 0x000fe200078ee215ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004436347212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000443c367212ULL, 0x080fe400078efcffULL, 0x000000343f347210ULL, 0x000fe20007fbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003f36367210ULL, 0x000fe40007fde0ffULL,
0x0000004416167212ULL, 0x080fe200078efcffULL, 0x0000000137357824ULL, 0x100fe200028e065bULL,
0x0000004414147212ULL, 0x000fe200078efcffULL, 0x000000013d377824ULL, 0x000fe200030e065bULL,
0x0000003f16167210ULL, 0x000fe20007fbe0ffULL, 0x00000010533d7824ULL, 0x100fe200078e0248ULL,
0x0000003f14147210ULL, 0x000fe20007fde0ffULL, 0x00000010593f7824ULL, 0x000fc400078e0248ULL,
0x000000105d537824ULL, 0x100fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000343d7faeULL, 0x0003e2000e101c46ULL, 0x0000000117177824ULL, 0x100fe400028e065bULL,
0x000000105f597824ULL, 0x000fe200078e0248ULL, 0x00000000363f7faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e065bULL, 0x0000000016537faeULL, 0x0003e8000d101c46ULL,
0x0000000014597faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x00009000ff367b82ULL, 0x000e620000000a00ULL, 0x0000001016157812ULL, 0x000fc800078ec0ffULL,
0x000000150c157211ULL, 0x000fca00078fe8ffULL, 0x0000000115147824ULL, 0x040fe400078e020cULL,
0x00000008153f7824ULL, 0x040fe400078e00ffULL, 0x0000000415167836ULL, 0x000fe40000000000ULL,
0x0000000815357836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x0000000c153d7836ULL, 0x000fe40000000000ULL, 0x00000001153c7824ULL, 0x000fc400078e0217ULL,
0x0000000116347824ULL, 0x140fe400078e0217ULL, 0x0000000116157824ULL, 0x100fe200078e020cULL,
0x000000363e537211ULL, 0x002fe200078038ffULL, 0x00000008164c7824ULL, 0x000fe400078e00ffULL,
0x0000000135167824ULL, 0x100fe200078e0217ULL, 0x000000373e5b7211ULL, 0x000fe200000f3cffULL,
0x000000013d147824ULL, 0x000fe200078e0217ULL, 0xfffffff84c597812ULL, 0x000fe200078ee215ULL,
0x0000000135177824ULL, 0x000fc400078e020cULL, 0x00000008354e7824ULL, 0x000fe400078e00ffULL,
0x000000013d357824ULL, 0x040fe400078e020cULL, 0x000000083d587824ULL, 0x000fe200078e00ffULL,
0xfffffff84e5d7812ULL, 0x000fe200078ee217ULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff8585f7812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000443c367212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003653367210ULL, 0x000fe40007f1e0ffULL, 0x0000004434347212ULL, 0x080fe200078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004416167212ULL, 0x000fc600078efcffULL,
0x000000013d377824ULL, 0x100fe200000e065bULL, 0x0000004414147212ULL, 0x000fe200078efcffULL,
0x000000103f3d7824ULL, 0x100fe200078e0248ULL, 0x0000003453347210ULL, 0x000fe20007f1e0ffULL,
0x00000010593f7824ULL, 0x100fe200078e0248ULL, 0x0000001653167210ULL, 0x000fe20007f5e0ffULL,
0x000000105f597824ULL, 0x100fe200078e0248ULL, 0x0000001453147210ULL, 0x000fe20007f7e0ffULL,
0x0000000135357824ULL, 0x000fe200000e065bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000363d7faeULL, 0x0003e2000b901c46ULL, 0x000000105d537824ULL, 0x000fc400078e0248ULL,
0x0000000117177824ULL, 0x100fe200010e065bULL, 0x00000000343f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fc600018e065bULL, 0x0000000016537faeULL, 0x0003e8000b901c46ULL,
0x0000000014597faeULL, 0x0003e4000b901c46ULL, 0x0000000209177836ULL, 0x002fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d167824ULL, 0x000fe400078e0216ULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x0000000106178824ULL, 0x000fe400078e0217ULL, 0x00000000160472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000614538981ULL, 0x000322000c1e1900ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0176a817165879a7ULL, 0x0004e2000850003fULL,
0x01762817521479a7ULL, 0x002464000850003fULL, 0x0000000000167805ULL, 0x004fce0000015200ULL,
0x01762815520075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01762815520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x000000800d147810ULL, 0x000fc80007ffe014ULL, 0x0000001447147210ULL, 0x000fca0007ffe044ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000010a157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000804015a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154737a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160cULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x000140004f487836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x00000010514e7824ULL, 0x000fd800078e0248ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160cULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011800005014783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000004e3c783bULL, 0x000f620000004200ULL,
0x000000104d347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000f640000004200ULL,
0x00000018ff6a7819ULL, 0x022fe2000001143cULL, 0x000001003c5b7824ULL, 0x040fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001143dULL, 0x000001003d5c7824ULL, 0x040fe200078e00ffULL,
0x000088803c6b7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d6c7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5a7819ULL, 0x008fe40000011434ULL, 0x00008880345e7816ULL, 0x000fe200000000ffULL,
0x0000005b006e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff617819ULL, 0x000fe4000001143fULL, 0x000088803f657816ULL, 0x000fc400000000ffULL,
0x00000018ff577819ULL, 0x000fe20000011435ULL, 0x0000003c006d7306ULL, 0x0007e20000200c00ULL,
0x000001003e5b7824ULL, 0x042fe200078e00ffULL, 0x00008880355d7816ULL, 0x000fe400000000ffULL,
0x000088803e667816ULL, 0x040fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000003d00707306ULL, 0x0003e20000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011436ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000100343d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff567819ULL, 0x000fca0000011437ULL,
0x0000005c006f7306ULL, 0x000e700000200c00ULL, 0x0000005b00677306ULL, 0x000ff00000200c00ULL,
0x0000003c00687306ULL, 0x0007f00000200c00ULL, 0x00000034005b7306ULL, 0x000be20000200c00ULL,
0x00000100353c7824ULL, 0x008fc400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x0000010037347824ULL, 0x024fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003f00647306ULL, 0x000ff00000200c00ULL,
0x00000035005c7306ULL, 0x0003f00000200c00ULL, 0x00000034003f7306ULL, 0x0005e20000200c00ULL,
0x000054106c357816ULL, 0x002fce000000006fULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x000054106b347816ULL, 0x004fe2000000006eULL, 0x00010000376b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106d347816ULL, 0x000fe2000000006aULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541070357816ULL, 0x008fce0000000069ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000003e00637306ULL, 0x0007620000200c00ULL, 0x0000541066347816ULL, 0x002fe40000000067ULL,
0x0000541065357816ULL, 0x004fca0000000068ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000100363e7824ULL, 0x008fe200078e00ffULL, 0x000000341430723cULL, 0x000fe80000001830ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d005f7306ULL, 0x0002a20000200c00ULL,
0x0000541063347816ULL, 0x020fe40000000062ULL, 0x0000541064357816ULL, 0x000fca0000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00008880363d7816ULL, 0x042fe200000000ffULL,
0x000000341428723cULL, 0x000fe20000001828ULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x0000003c00607306ULL, 0x0002e20000200c00ULL, 0x000054105e347816ULL, 0x004fe4000000005fULL,
0x00000018ff367819ULL, 0x000fca0000011436ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x00008880373c7816ULL, 0x002fe400000000ffULL, 0x000054105d357816ULL, 0x008fca0000000060ULL,
0x0000005700577306ULL, 0x000e640000200c00ULL, 0x000000341424723cULL, 0x000fec0000001824ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000054105b347816ULL, 0x004fe4000000005aULL,
0x000054105c357816ULL, 0x002fca0000000057ULL, 0x0000003e003e7306ULL, 0x000e640000200c00ULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x000054103d347816ULL, 0x002fce000000003eULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054103c357816ULL, 0x004fce000000003fULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000034141c723cULL, 0x000fee000000181cULL, 0x0000003600377306ULL, 0x000e700000200c00ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541037347816ULL, 0x002fe2000000004cULL,
0x000000104b4c7824ULL, 0x000fe200078e0248ULL, 0x000054106b357816ULL, 0x004fce0000000056ULL,
0x000000341410723cULL, 0x000fe20000001810ULL, 0x011800004a14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000004c3c783bULL, 0x000ee20000004200ULL, 0x0000001049347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff6a7819ULL, 0x008fe2000001143cULL,
0x000001003c5c7824ULL, 0x040fe200078e00ffULL, 0x000088803c6b7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001143dULL,
0x000001003d5d7824ULL, 0x040fe200078e00ffULL, 0x000088803d6c7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fc4000001145cULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff617819ULL, 0x000fe2000001143fULL, 0x0000003c006d7306ULL, 0x0007e20000200c00ULL,
0x000088803f667816ULL, 0x000fe400000000ffULL, 0x00000018ff5b7819ULL, 0x022fe40000011434ULL,
0x00000018ff5a7819ULL, 0x000fc40000011435ULL, 0x00008880345e7816ULL, 0x000fe200000000ffULL,
0x0000005c006e7306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x000088803e677816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000001003e5c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc40000011436ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005d006f7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff577819ULL, 0x000fca0000011437ULL, 0x0000003d00707306ULL, 0x0007e20000200c00ULL,
0x00008880355d7816ULL, 0x002fce00000000ffULL, 0x0000003c00697306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x04cfe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143cULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fca00000000ffULL, 0x0000005c00687306ULL, 0x000ff00000200c00ULL,
0x0000003f00647306ULL, 0x000ff00000200c00ULL, 0x00000034005c7306ULL, 0x000bf00000200c00ULL,
0x00000035003f7306ULL, 0x0007e20000200c00ULL, 0x000054106b347816ULL, 0x020fe2000000006eULL,
0x00000100376b7824ULL, 0x000fcc00078e00ffULL, 0x0000006700677306ULL, 0x000f620000200c00ULL,
0x000054106c357816ULL, 0x008fce000000006fULL, 0x0000006600667306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106d347816ULL, 0x004fe2000000006aULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541070357816ULL, 0x002fc40000000063ULL,
0x00000018ff637819ULL, 0x000fca000001146bULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000034142c723cULL, 0x000fee000000182cULL, 0x0000003e00657306ULL, 0x0002a20000200c00ULL,
0x0000541067347816ULL, 0x020fe40000000068ULL, 0x0000541066357816ULL, 0x008fe20000000069ULL,
0x0001000037667824ULL, 0x000fc800078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00008880373e7816ULL, 0x002fe200000000ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x00000018ff667819ULL, 0x000fca0000011466ULL, 0x0000003d005f7306ULL, 0x0002e20000200c00ULL,
0x0000541065347816ULL, 0x004fe40000000062ULL, 0x0000541064357816ULL, 0x000fca0000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x042fe200078e00ffULL,
0x000000341428723cULL, 0x000fe20000001828ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x000054105e347816ULL, 0x008fe4000000005fULL, 0x00000018ff367819ULL, 0x000fca0000011436ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000054105d357816ULL, 0x002fce0000000060ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x00000002405d7824ULL, 0x000fe200078e00ffULL,
0x000000341424723cULL, 0x000fec0000001824ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054105c347816ULL, 0x004fe4000000005bULL, 0x000054103f357816ULL, 0x002fca000000005aULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0xfffffff85d5a7812ULL, 0x000fe200078ec0ffULL,
0x000000341420723cULL, 0x000fe80000001820ULL, 0x000000010d5a7824ULL, 0x000fe400078e025aULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000054103c347816ULL, 0x002fce000000003dULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x00000001ff3d7424ULL, 0x000fce00078e00ffULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000054103e357816ULL, 0x002fce0000000063ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00000034141c723cULL, 0x000fee000000181cULL,
0x0000003600377306ULL, 0x0002b00000200c00ULL, 0x0000006600667306ULL, 0x000ee20000200c00ULL,
0x0000000838367824ULL, 0x002fc800078e020dULL, 0x0176c83d363479a7ULL, 0x000262000850003fULL,
0x0000541037567816ULL, 0x004fe20000000056ULL, 0x0176903d5aff79a7ULL, 0x0005e2000850003fULL,
0x0000541066577816ULL, 0x008fce0000000057ULL, 0x000000561410723cULL, 0x000fde0000001810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001040147824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x00000004533e7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe014167812ULL, 0x000fe400078ec0ffULL, 0x000000403e3e7824ULL, 0x000fc600078e00ffULL,
0x0000010005167824ULL, 0x000fc800078e0216ULL, 0x000000c016177836ULL, 0x000fca0000000000ULL,
0x0000002017167812ULL, 0x000fca00078ec0ffULL, 0x000000010b167824ULL, 0x000fe200078e0216ULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x0000001014347812ULL, 0x000fe400078ec0ffULL,
0x000000173b147248ULL, 0x000fe40007fe0000ULL, 0x00000003ff357819ULL, 0x000fc6000001160cULL,
0x0000000114177824ULL, 0x000fe400078e0a17ULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000000135377824ULL, 0x000fe400078e0234ULL, 0x0000001734177248ULL, 0x000fe20007fe0000ULL,
0x00000004353c7836ULL, 0x000fe40000000000ULL, 0x0000000137367824ULL, 0x000fe400078e020cULL,
0x0000000117177824ULL, 0x000fc400078e0a34ULL, 0x0000000837537824ULL, 0x000fe400078e00ffULL,
0x00000008353d7836ULL, 0x004fe20000000000ULL, 0x000000173500720cULL, 0x080fe20003f86070ULL,
0x0000000c35567836ULL, 0x000fe20000000000ULL, 0xfffffff853537812ULL, 0x000fe200078ee236ULL,
0x000000013c357824ULL, 0x140fe200078e0234ULL, 0x000000173d00720cULL, 0x0c0fe20003f46070ULL,
0x000000013d3f7824ULL, 0x100fe200078e0234ULL, 0x000000173c00720cULL, 0x080fe20003f66070ULL,
0x00000001565d7824ULL, 0x040fe200078e0234ULL, 0x000000175600720cULL, 0x000fe20003f06070ULL,
0x0000000137367824ULL, 0x000fc400078e0216ULL, 0x0000000135347824ULL, 0x040fe200078e020cULL,
0x000000143e3d7211ULL, 0x002fe200078a38ffULL, 0x0000000835577824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee234ULL,
0x0000000135347824ULL, 0x000fe200078e0216ULL, 0x0000004436367212ULL, 0x000fe200078efcffULL,
0x000000013f177824ULL, 0x040fe400078e020cULL, 0x000000083f3c7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff83c5b7812ULL, 0x000fe200078ee217ULL,
0x000000013f147824ULL, 0x100fe200078e0216ULL, 0x000000153e3f7211ULL, 0x000fe200028f3cffULL,
0x000000015d167824ULL, 0x000fe200078e0216ULL, 0x000000363d367210ULL, 0x000fe20007fbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004434347212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004414147212ULL, 0x000fc600078efcffULL,
0x0000000137377824ULL, 0x100fe200028e063fULL, 0x0000003d34347210ULL, 0x000fe20007fbe0ffULL,
0x000000015d3c7824ULL, 0x040fe200078e020cULL, 0x0000004416167212ULL, 0x000fe200078efcffULL,
0x000000085d5d7824ULL, 0x000fe400078e00ffULL, 0x0000000135357824ULL, 0x100fe200028e063fULL,
0x0000003d14147210ULL, 0x000fe20007fbe0ffULL, 0x0000001053537824ULL, 0x100fe200078e0248ULL,
0x0000003d16167210ULL, 0x000fe20007fde0ffULL, 0x0000001057577824ULL, 0x100fe200078e0248ULL,
0xfffffff85d3d7812ULL, 0x000fe200078ee23cULL, 0x0000000115157824ULL, 0x000fe200028e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036537faeULL, 0x0003e2000e101c46ULL,
0x000000105b5b7824ULL, 0x000fc400078e0248ULL, 0x0000000117177824ULL, 0x000fe200030e063fULL,
0x0000000034577faeULL, 0x0003e2000d901c46ULL, 0x000000103d3d7824ULL, 0x000fc600078e0248ULL,
0x00000000145b7faeULL, 0x0003e8000d101c46ULL, 0x00000000163d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x00009000ff367b82ULL, 0x000e620000000a00ULL,
0x0000001014157812ULL, 0x000fc800078ec0ffULL, 0x000000150c157211ULL, 0x000fca00078fe8ffULL,
0x0000000115147824ULL, 0x040fe400078e020cULL, 0x00000008153f7824ULL, 0x040fe400078e00ffULL,
0x0000000415177836ULL, 0x000fe40000000000ULL, 0x0000000815357836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL, 0x0000000c153d7836ULL, 0x004fe40000000000ULL,
0x00000001153c7824ULL, 0x000fc400078e0216ULL, 0x0000000117147824ULL, 0x040fe400078e0216ULL,
0x0000000117157824ULL, 0x040fe200078e020cULL, 0x000000363e537211ULL, 0x042fe200078038ffULL,
0x0000000817567824ULL, 0x000fe400078e00ffULL, 0x0000000135177824ULL, 0x100fe200078e0216ULL,
0x000000373e577211ULL, 0x000fe200000f3cffULL, 0x000000013d347824ULL, 0x000fe200078e0216ULL,
0xfffffff8565b7812ULL, 0x000fe200078ee215ULL, 0x0000000135167824ULL, 0x000fc400078e020cULL,
0x00000008355d7824ULL, 0x000fe400078e00ffULL, 0x000000013d357824ULL, 0x040fe400078e020cULL,
0x000000083d5a7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee216ULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff85a5f7812ULL, 0x000fe200078ee235ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000443c367212ULL, 0x000fc600078efcffULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x0000003653367210ULL, 0x000fe40007f1e0ffULL,
0x0000004414147212ULL, 0x080fe200078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004416167212ULL, 0x080fe400078efcffULL, 0x0000001453147210ULL, 0x000fe20007f5e0ffULL,
0x000000013d377824ULL, 0x100fe200000e0657ULL, 0x0000004434347212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0248ULL, 0x0000001653167210ULL, 0x000fe20007f1e0ffULL,
0x0000000115157824ULL, 0x100fe200010e0657ULL, 0x0000003453347210ULL, 0x000fe20007f7e0ffULL,
0x000000105b5b7824ULL, 0x000fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000363f7faeULL, 0x0003e2000b901c46ULL, 0x0000000117177824ULL, 0x000fc400000e0657ULL,
0x000000105d5d7824ULL, 0x100fe200078e0248ULL, 0x00000000145b7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fe400018e0657ULL, 0x000000105f5f7824ULL, 0x000fe200078e0248ULL,
0x00000000165d7faeULL, 0x0003e8000b901c46ULL, 0x00000000345f7faeULL, 0x0003e4000b901c46ULL,
0x0000000309177836ULL, 0x002fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d167824ULL, 0x000fe400078e0216ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000106178824ULL, 0x000fe400078e0217ULL,
0x00000000160472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176b004047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x0000000614538981ULL, 0x000322000c1e1900ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0176b017165679a7ULL, 0x0004e2000850003fULL, 0x01764817521479a7ULL, 0x002464000850003fULL,
0x0000000000167805ULL, 0x004fce0000015200ULL, 0x01764815520075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003416377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01764815520075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x000001000d147810ULL, 0x000fc80007ffe014ULL,
0x0000001447147210ULL, 0x000fca0007ffe044ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000020a157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000804015a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154737a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160cULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080c147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176a859370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a859370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x000130004f527836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x00000010513c7824ULL, 0x000fd800078e0252ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160cULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000005014783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000104d347824ULL, 0x000fcc00078e0252ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff637819ULL, 0x022fe2000001143cULL,
0x000001003c587824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001143dULL,
0x000001003d597824ULL, 0x040fe200078e00ffULL, 0x000088803c667816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d697816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff517819ULL, 0x008fe40000011434ULL,
0x00008880345b7816ULL, 0x000fe200000000ffULL, 0x00000058006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5e7819ULL, 0x000fe4000001143fULL,
0x000088803f657816ULL, 0x000fc400000000ffULL, 0x00000018ff507819ULL, 0x000fe20000011435ULL,
0x0000003c006a7306ULL, 0x0007e20000200c00ULL, 0x000001003e587824ULL, 0x042fe200078e00ffULL,
0x00008880355a7816ULL, 0x000fe400000000ffULL, 0x000088803e647816ULL, 0x040fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003d006d7306ULL, 0x0003e20000200c00ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011436ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000100343d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff4f7819ULL, 0x000fca0000011437ULL, 0x00000059006c7306ULL, 0x000e700000200c00ULL,
0x0000005800677306ULL, 0x000ff00000200c00ULL, 0x0000003c00687306ULL, 0x0007f00000200c00ULL,
0x0000003400587306ULL, 0x000be20000200c00ULL, 0x00000100353c7824ULL, 0x008fc400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x0000010037347824ULL, 0x024fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003f00617306ULL, 0x000ff00000200c00ULL,
0x0000003500597306ULL, 0x0003f00000200c00ULL, 0x00000034003f7306ULL, 0x0005e20000200c00ULL,
0x0000541069357816ULL, 0x002fce000000006cULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x0000541066347816ULL, 0x004fce000000006bULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106a347816ULL, 0x000fe20000000063ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000054106d357816ULL, 0x008fce0000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000003e00607306ULL, 0x0007620000200c00ULL, 0x0000541064347816ULL, 0x002fe40000000067ULL,
0x0000541065357816ULL, 0x004fca0000000068ULL, 0x0000003d005c7306ULL, 0x0003e20000200c00ULL,
0x00008880373e7816ULL, 0x048fe200000000ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x000000341430723cULL, 0x000fe80000001830ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x00000100363d7824ULL, 0x002fe200078e00ffULL,
0x0000541060347816ULL, 0x020fe2000000005fULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000541061357816ULL, 0x000fc4000000005eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000000341428723cULL, 0x000fea0000001828ULL, 0x0000005d005d7306ULL, 0x000e640000200c00ULL,
0x000054105b347816ULL, 0x004fcc000000005cULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054105a357816ULL, 0x002fce000000005dULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000341424723cULL, 0x000fee0000001824ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x0000541058347816ULL, 0x004fce0000000051ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000541059357816ULL, 0x002fce0000000050ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x000000341420723cULL, 0x000fee0000001820ULL, 0x0000003e003e7306ULL, 0x000e700000200c00ULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000003700627306ULL, 0x000e620000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x0000541036367816ULL, 0x004fcc000000004dULL, 0x000000104b3c7824ULL, 0x000fe200078e0252ULL,
0x0000541062377816ULL, 0x002fce000000004fULL, 0x000000361410723cULL, 0x000fe20000001810ULL,
0x012000004a14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001049347824ULL, 0x000fcc00078e0252ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff5d7819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c597816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d507824ULL, 0x040fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff517819ULL, 0x000fe2000001143fULL, 0x0000004f00667306ULL, 0x0007e20000200c00ULL,
0x000088803f5f7816ULL, 0x000fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5b7819ULL, 0x000fe4000001143eULL, 0x000088803e5e7816ULL, 0x040fe200000000ffULL,
0x0000003c00627306ULL, 0x000be20000200c00ULL, 0x000001003e4f7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x022fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc40000011435ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000001003f3c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011437ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fc4000001143fULL,
0x00008880353f7816ULL, 0x000fe400000000ffULL, 0x0000888037677816ULL, 0x000fe400000000ffULL,
0x00000018ff497819ULL, 0x000fe20000011436ULL, 0x00000050006a7306ULL, 0x000eb00000200c00ULL,
0x0000003d00657306ULL, 0x0007f00000200c00ULL, 0x0000004f00617306ULL, 0x000be20000200c00ULL,
0x00000100343d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00687306ULL, 0x0007e20000200c00ULL, 0x00008880344f7816ULL, 0x060fe200000000ffULL,
0x0001000034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000005c005c7306ULL, 0x000f620000200c00ULL, 0x00000100353c7824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e00607306ULL, 0x000fe20000200c00ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x00000034003e7306ULL, 0x0003f00000200c00ULL,
0x0000003500507306ULL, 0x0005e20000200c00ULL, 0x0000541059347816ULL, 0x002fe20000000066ULL,
0x000000ffff597224ULL, 0x000fcc00078e0067ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x0000541063357816ULL, 0x004fe2000000006aULL, 0x0000010037637824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000000341418723cULL, 0x000fe20000001818ULL,
0x00000018ff377819ULL, 0x000fcc0000011437ULL, 0x0000541062347816ULL, 0x000fe2000000005dULL,
0x0000005b005b7306ULL, 0x000ee20000200c00ULL, 0x0000541065357816ULL, 0x020fce000000005cULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000006400647306ULL, 0x000f620000200c00ULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x000054105e347816ULL, 0x002fc80000000061ULL, 0x00000018ff5c7819ULL, 0x000fe40000011435ULL,
0x000054105f357816ULL, 0x004fe20000000068ULL, 0x0000004f004f7306ULL, 0x000fec0000200c00ULL,
0x000000341430723cULL, 0x000fe40000001830ULL, 0x0000003d00587306ULL, 0x0002aa0000200c00ULL,
0x0000541060347816ULL, 0x008fc4000000005bULL, 0x0000541064357816ULL, 0x020fe20000000051ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000341428723cULL, 0x000fe20000001828ULL,
0x0000005a005a7306ULL, 0x000e6c0000200c00ULL, 0x000054104f347816ULL, 0x004fe40000000058ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000054103f357816ULL, 0x002fce000000005aULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fe20000001824ULL,
0x000054103e3e7816ULL, 0x004fcc000000004bULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000000240347824ULL, 0x000fe200078e00ffULL, 0x00005410503f7816ULL, 0x002fcc000000004dULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000003e1420723cULL, 0x000fee0000001820ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0xfffffff8343e7812ULL, 0x000fe200078ec0ffULL,
0x0000000838347824ULL, 0x000fe200078e020dULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00000001ff3f7424ULL, 0x000fe400078e00ffULL,
0x000000010d3e7824ULL, 0x000fe400078e023eULL, 0x0176c83f343479a7ULL, 0x000266000850003fULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0176983f3eff79a7ULL, 0x0003ee000850003fULL,
0x0000006300367306ULL, 0x000eb00000200c00ULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x00005410593d7816ULL, 0x004fce0000000036ULL, 0x0000003700377306ULL, 0x000ea20000200c00ULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x000054105c5c7816ULL, 0x008fe40000000049ULL,
0x00005410375d7816ULL, 0x004fce000000004aULL, 0x0000005c1410723cULL, 0x002fde0000001810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000105157836ULL, 0x000fe40000000000ULL,
0x0000000309097836ULL, 0x000fc60000000000ULL, 0x000000391500720cULL, 0x000fda0003f06070ULL,
0x0000000800180947ULL, 0x000fea0003800000ULL, 0x0000000205147836ULL, 0x000fe20000000000ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000010015157824ULL, 0x000fe400078e0208ULL,
0x0000000453097c24ULL, 0x010fe2000f8e02ffULL, 0x000000391400720cULL, 0x000fe40003f06070ULL,
0x0000002015147812ULL, 0x000fe200078ec0ffULL, 0x0000004009097824ULL, 0x000fc800078e00ffULL,
0x000000010b177824ULL, 0x000fcc00078e0214ULL, 0x0000000400048947ULL, 0x000fea0003800000ULL,
0x000000153b147248ULL, 0x000fe20007fe0000ULL, 0x0000001040167824ULL, 0x000fe200078e00ffULL,
0x00000003ff347819ULL, 0x000fc6000001160cULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x0000001016357812ULL, 0x000fe200078ec0ffULL, 0x0000000434367836ULL, 0x000fe40000000000ULL,
0x00000008343c7836ULL, 0x000fe20000000000ULL, 0x0000001435167248ULL, 0x000fe20007fe0000ULL,
0x0000000136377824ULL, 0x100fe200078e0235ULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000000c343e7836ULL, 0x000fe40000000000ULL, 0x0000000116167824ULL, 0x000fc400078e0a35ULL,
0x000000013c3d7824ULL, 0x100fe400078e0235ULL, 0x00000008374b7824ULL, 0x040fe200078e00ffULL,
0x000000163400720cULL, 0x0c0fe20003f86070ULL, 0x0000000134347824ULL, 0x100fe200078e0235ULL,
0x000000163c00720cULL, 0x080fe20003f46070ULL, 0x00000001373c7824ULL, 0x100fe200078e020cULL,
0x000000163600720cULL, 0x080fe20003f66070ULL, 0x0000000134367824ULL, 0x000fe200078e020cULL,
0x000000163e00720cULL, 0x000fe20003f06070ULL, 0x0000000834497824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL, 0x000000013e3f7824ULL, 0x000fc400078e0235ULL,
0x000000013d357824ULL, 0x040fe200078e020cULL, 0xfffffff849497812ULL, 0x000fe200078ee236ULL,
0x000000083d3e7824ULL, 0x000fe400078e00ffULL, 0x00000001343c7824ULL, 0x100fe400078e0217ULL,
0x0000000137347824ULL, 0x100fe200078e0217ULL, 0xfffffff83e4d7812ULL, 0x000fe200078ee235ULL,
0x000000013d167824ULL, 0x100fe400078e0217ULL, 0x000000013f367824ULL, 0x000fc400078e0217ULL,
0x000000013f177824ULL, 0x040fe400078e020cULL, 0x000000083f4a7824ULL, 0x000fe200078e00ffULL,
0x00000014093f7211ULL, 0x002fe200078a38ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff84a4f7812ULL, 0x000fe200078ee217ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000443c147212ULL, 0x080fe400078efcffULL, 0x0000001509097211ULL, 0x000fe200028f3cffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004434347212ULL, 0x000fe400078efcffULL,
0x000000143f147210ULL, 0x000fe20007fbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003f34347210ULL, 0x000fc40007fde0ffULL, 0x0000004416167212ULL, 0x080fe200078efcffULL,
0x000000013d157824ULL, 0x100fe200028e0609ULL, 0x0000004436367212ULL, 0x000fe200078efcffULL,
0x0000000135357824ULL, 0x100fe200030e0609ULL, 0x0000003f16167210ULL, 0x000fe20007fbe0ffULL,
0x0000001049497824ULL, 0x100fe200078e0252ULL, 0x0000003f36367210ULL, 0x000fe20007fde0ffULL,
0x000000104b4b7824ULL, 0x100fe400078e0252ULL, 0x000000104d4d7824ULL, 0x000fe200078e0252ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014497faeULL, 0x0003e2000e101c46ULL,
0x0000000117177824ULL, 0x000fc400028e0609ULL, 0x000000104f4f7824ULL, 0x000fe200078e0252ULL,
0x00000000344b7faeULL, 0x0003e2000d901c46ULL, 0x0000000137377824ULL, 0x000fc600030e0609ULL,
0x00000000164d7faeULL, 0x0003e8000d101c46ULL, 0x00000000364f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001040147824ULL, 0x000fca00078e00ffULL,
0x0000001014157812ULL, 0x000fc800078ec0ffULL, 0x000000150c347211ULL, 0x000fe400078fe8ffULL,
0x00009000ff147b82ULL, 0x000e660000000a00ULL, 0x0000000134167824ULL, 0x040fe400078e020cULL,
0x00000008343f7824ULL, 0x000fe400078e00ffULL, 0x0000000434357836ULL, 0x000fe40000000000ULL,
0x00000008343d7836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x0000000c343e7836ULL, 0x000fc40000000000ULL, 0x0000000134167824ULL, 0x100fe400078e0217ULL,
0x0000000135347824ULL, 0x140fe400078e0217ULL, 0x0000000135377824ULL, 0x140fe400078e020cULL,
0x00000008354a7824ULL, 0x000fe400078e00ffULL, 0x000000013d367824ULL, 0x100fe400078e0217ULL,
0x000000013e3c7824ULL, 0x000fe200078e0217ULL, 0x0000001409497211ULL, 0x002fe200078038ffULL,
0x000000013d357824ULL, 0x040fe200078e020cULL, 0xfffffff84a4b7812ULL, 0x000fe200078ee237ULL,
0x000000083d507824ULL, 0x000fe200078e00ffULL, 0x0000001509097211ULL, 0x000fe200000f3cffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff8504d7812ULL, 0x000fe200078ee235ULL,
0x000000013e3d7824ULL, 0x000fe200078e020cULL, 0x0000004416147212ULL, 0x080fe200078efcffULL,
0x000000083e3e7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000001449147210ULL, 0x000fe40007f1e0ffULL, 0xfffffff83e4f7812ULL, 0x000fe200078ee23dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004434167212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004436347212ULL, 0x000fc600078efcffULL,
0x0000000117157824ULL, 0x100fe200000e0609ULL, 0x000000443c367212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0252ULL, 0x0000001649167210ULL, 0x000fe20007f1e0ffULL,
0x000000104b4b7824ULL, 0x100fe200078e0252ULL, 0x0000003449347210ULL, 0x000fe20007f5e0ffULL,
0x000000104d4d7824ULL, 0x000fe200078e0252ULL, 0x0000003649367210ULL, 0x000fe20007f7e0ffULL,
0x0000000135177824ULL, 0x100fe200000e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000b901c46ULL, 0x0000000137357824ULL, 0x000fc400010e0609ULL,
0x000000104f4f7824ULL, 0x000fe200078e0252ULL, 0x00000000164b7faeULL, 0x0003e2000b901c46ULL,
0x000000013d377824ULL, 0x000fc600018e0609ULL, 0x00000000344d7faeULL, 0x0003e8000b901c46ULL,
0x00000000364f7faeULL, 0x0003e4000b901c46ULL, 0x0000000445097836ULL, 0x000fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff147b82ULL, 0x002e620000000a00ULL,
0x0000000106177824ULL, 0x000fc800078e0209ULL, 0x0000000417147825ULL, 0x002fca00078e0014ULL,
0x0000000614537981ULL, 0x000324000c1e1900ULL, 0x0000000840147824ULL, 0x002fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fca00078ec0ffULL,
0x000000010d147824ULL, 0x000fca00078e0214ULL, 0x00000000140472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a834141479a7ULL, 0x0002a4000850003fULL, 0x01766834073479a7ULL, 0x0022e4000850003fULL,
0x000000ffff497224ULL, 0x006fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01766835070075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000800a157824ULL, 0x000fe400078e020dULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0x0000018044147810ULL, 0x000fca0007ffe015ULL,
0x0000000147147824ULL, 0x000fca00078e0214ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000030a157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000804015a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154747a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400144700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160cULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080c147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x0000000440167824ULL, 0x000fe200078e00ffULL, 0x000000080c357812ULL, 0x000fe200078ec0ffULL,
0x000008000a157824ULL, 0x000fe200078e020dULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000000416167812ULL, 0x000fe200078ec0ffULL, 0x0000001046157824ULL, 0x000fc600078e0215ULL,
0x0000000216457812ULL, 0x000fce00078efcffULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160cULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803177836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1714007589ULL, 0x0002e400000e0000ULL,
0x012800001514783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x088fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x0000000735447812ULL, 0x000fe200078ef80cULL, 0x000000004e3c783bULL, 0x000f620000004200ULL,
0x000000450c457211ULL, 0x040fe200078fe0ffULL, 0x0000000242647836ULL, 0x000fe20000000000ULL,
0x000000070c657812ULL, 0x000fe200078ec0ffULL, 0x0000000844357824ULL, 0x040fe400078e00ffULL,
0x0000000144347824ULL, 0x000fe200078e0245ULL, 0x0000000865657812ULL, 0x000fc800078ef80cULL,
0xfffffff835357812ULL, 0x000fe200078ee234ULL, 0x0000000865657824ULL, 0x000fc800078e00ffULL,
0x0000001035357824ULL, 0x000fe200078e0248ULL, 0xfffffff865647812ULL, 0x000fca00078ee264ULL,
0x000000003534783bULL, 0x000f640000004200ULL, 0x000001003c4e7824ULL, 0x068fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001143cULL, 0x000001003d4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c4d7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff5a7819ULL, 0x000fe2000001143dULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fc4000001143cULL,
0x00000018ff587819ULL, 0x000fe4000001143eULL, 0x000088803e3c7816ULL, 0x040fe200000000ffULL,
0x0000004e00627306ULL, 0x0007e20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff567819ULL, 0x000fe4000001143fULL,
0x00000018ff4b7819ULL, 0x004fe20000011435ULL, 0x0000004f00637306ULL, 0x0005e20000200c00ULL,
0x000001003e4e7824ULL, 0x048fe200078e00ffULL, 0x0000888035507816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fc40000011434ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000003d005f7306ULL, 0x0007e20000200c00ULL,
0x000001003f4f7824ULL, 0x044fe200078e00ffULL, 0x0000888034517816ULL, 0x040fe400000000ffULL,
0x000088803f5c7816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000004e005d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3d7819ULL, 0x008fe2000001143eULL, 0x00000100343e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fc40000011437ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x00000100354e7824ULL, 0x044fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011436ULL, 0x00000018ff577819ULL, 0x000fe4000001144eULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x00000035004e7306ULL, 0x000bf00000200c00ULL, 0x0000004f00617306ULL, 0x000fe20000200c00ULL,
0x0000010037357824ULL, 0x022fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000034004f7306ULL, 0x0003f00000200c00ULL, 0x0000005a005a7306ULL, 0x000f620000200c00ULL,
0x0000888037347816ULL, 0x042fe200000000ffULL, 0x0001000037377824ULL, 0x000fcc00078e00ffULL,
0x0000006000607306ULL, 0x000e700000200c00ULL, 0x0000003400427306ULL, 0x0007f00000200c00ULL,
0x0000003f005b7306ULL, 0x0003e20000200c00ULL, 0x000054104d347816ULL, 0x008fe20000000062ULL,
0x000000030a627836ULL, 0x000fcc0000000000ULL, 0x00000035004d7306ULL, 0x0005e20000200c00ULL,
0x00000100363f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003e00527306ULL, 0x0003e20000200c00ULL, 0x000054105e357816ULL, 0x004fe20000000063ULL,
0x0000080062637824ULL, 0x000fc800078e020dULL, 0x0000001064637824ULL, 0x000fe400078e0263ULL,
0x0000003c003c7306ULL, 0x000ea20000200c00ULL, 0x00008880363e7816ULL, 0x042fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000000341418723cULL, 0x000fe80000001818ULL,
0x00000018ff5e7819ULL, 0x000fe20000011436ULL, 0x0000005800587306ULL, 0x000fe40000200c00ULL,
0x000054105f357816ULL, 0x020fc4000000005aULL, 0x00000018ff5a7819ULL, 0x000fe40000011437ULL,
0x0000541060347816ULL, 0x000fe40000000059ULL, 0x0000003d003d7306ULL, 0x000e6a0000200c00ULL,
0x00000034142c723cULL, 0x000fe6000000182cULL, 0x0000005600567306ULL, 0x000ee80000200c00ULL,
0x000054103c347816ULL, 0x004fc4000000005dULL, 0x000054103d3c7816ULL, 0x002fe40000000058ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x000054105b3d7816ULL, 0x008fce0000000056ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000003c1428723cULL, 0x000fe20000001828ULL,
0x000054105c357816ULL, 0x002fcc0000000061ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000000341430723cULL, 0x000fee0000001830ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x011000006334783bULL, 0x0006e20000000200ULL, 0x000054103e3e7816ULL, 0x002fcc000000003fULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x00005410423f7816ULL, 0x000fe4000000004dULL,
0x000054104f4a7816ULL, 0x004fca000000004aULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000003e141c723cULL, 0x000fe2000000181cULL, 0x000054104e4b7816ULL, 0x002fcc000000004bULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000004a1420723cULL, 0x000fee0000001820ULL,
0x0000005100517306ULL, 0x000e700000200c00ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x00005410513c7816ULL, 0x002fce0000000052ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000005e00597306ULL, 0x000ea20000200c00ULL, 0x00005410503d7816ULL, 0x002fce0000000057ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000003c1424723cULL, 0x000fe20000001824ULL,
0x0000541059467816ULL, 0x004fe40000000046ULL, 0x000054105a477816ULL, 0x002fce0000000047ULL,
0x000000461410723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x008fde0003800000ULL, 0x0000000334347232ULL, 0x080fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x000000004c3c783bULL, 0x000e620000004200ULL,
0x0000001044447812ULL, 0x000fe200078efcffULL, 0x0000000105057836ULL, 0x000fc80000000000ULL,
0x0000000144457824ULL, 0x040fe400078e0245ULL, 0x0000000844447824ULL, 0x000fca00078e00ffULL,
0xfffffff844457812ULL, 0x000fe400078ee245ULL, 0x000088803c147816ULL, 0x042fe200000000ffULL,
0x000001003c157824ULL, 0x040fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001143cULL,
0x000001003d167824ULL, 0x000fe200078e00ffULL, 0x00000014004c7306ULL, 0x0003e20000200c00ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000001003e427824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc40000011416ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000015004d7306ULL, 0x0004e20000200c00ULL,
0x0000001045147824ULL, 0x002fe200078e0248ULL, 0x00000018ff477819ULL, 0x000fe4000001143eULL,
0x00000018ff467819ULL, 0x000fe4000001143fULL, 0x000088803e487816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000003c00587306ULL, 0x0003e20000200c00ULL,
0x000000001414783bULL, 0x004ea20000004200ULL, 0x000088803f507816ULL, 0x000fc400000000ffULL,
0x000088803d4e7816ULL, 0x040fe400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001143dULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000003e00567306ULL, 0x000bf00000200c00ULL, 0x0000003f00597306ULL, 0x0003e20000200c00ULL,
0x00000018ff447819ULL, 0x004fe20000011414ULL, 0x00000100143e7824ULL, 0x060fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011415ULL, 0x00000100153f7824ULL, 0x042fe200078e00ffULL,
0x00008880144f7816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000888015527816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010017607824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000003d005b7306ULL, 0x0005700000200c00ULL,
0x0000001400577306ULL, 0x0007e20000200c00ULL, 0x00000018ff3d7819ULL, 0x004fce0000011417ULL,
0x00000015005c7306ULL, 0x0005e20000200c00ULL, 0x000054104c147816ULL, 0x008fe4000000004dULL,
0x00000018ff4d7819ULL, 0x000fca0000011460ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054104e157816ULL, 0x004fce000000005dULL, 0x0000004200517306ULL, 0x0004e20000200c00ULL,
0x000000143418723cULL, 0x000fee0000001818ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x004fe40000011416ULL, 0x0000541058147816ULL, 0x002fc4000000004bULL,
0x000054105b157816ULL, 0x020fe2000000004aULL, 0x00010000174a7824ULL, 0x000fe400078e00ffULL,
0x0000003c005f7306ULL, 0x000e660000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x00000014342c723cULL, 0x000fe8000000182cULL, 0x0000004700477306ULL, 0x000ea60000200c00ULL,
0x0000541048147816ULL, 0x008fc40000000051ULL, 0x0000541050157816ULL, 0x002fc6000000005fULL,
0x00000042003c7306ULL, 0x0003e80000200c00ULL, 0x000000143430723cULL, 0x000fe20000001830ULL,
0x0000541056587816ULL, 0x004fc60000000047ULL, 0x0000003e005a7306ULL, 0x0005e20000200c00ULL,
0x0000010016427824ULL, 0x002fe400078e00ffULL, 0x00000001ff477424ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011442ULL, 0x00000047041479a7ULL, 0x0002e2000850003fULL,
0x0000888017427816ULL, 0x000fe200000000ffULL, 0x0000003f00617306ULL, 0x000fe20000200c00ULL,
0x00008880163e7816ULL, 0x044fe200000000ffULL, 0x0001000016167824ULL, 0x000fca00078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000000080a047824ULL, 0x002fc800078e020dULL, 0x0176a04704ff79a7ULL, 0x0003e6000850003fULL,
0x0000005e003f7306ULL, 0x000eb00000200c00ULL, 0x0000004600467306ULL, 0x000f620000200c00ULL,
0x000054103e3e7816ULL, 0x004fce000000003fULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x0000541059597816ULL, 0x020fce0000000046ULL, 0x0000004500457306ULL, 0x000f620000200c00ULL,
0x000000583428723cULL, 0x000fe20000001828ULL, 0x0000541057447816ULL, 0x004fcc0000000044ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000054105c457816ULL, 0x020fce0000000045ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000000443420723cULL, 0x000fee0000001820ULL,
0x0000005200527306ULL, 0x000f620000200c00ULL, 0x000054104f5a7816ULL, 0x004fce000000005aULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x00005410525b7816ULL, 0x020fce0000000061ULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x0000005a3424723cULL, 0x000fee0000001824ULL,
0x0000001600177306ULL, 0x000f620000200c00ULL, 0x00005410423f7816ULL, 0x004fce000000004dULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000003e341c723cULL, 0x000fe2000000181cULL,
0x00005410173c7816ULL, 0x020fe4000000003cULL, 0x000054104a3d7816ULL, 0x004fce000000003dULL,
0x0000003c3410723cULL, 0x000fee0000001810ULL, 0x000000ffff347224ULL, 0x008fe200078e0015ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff7000789947ULL, 0x002fde000383ffffULL,
0x000000ff3900720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000ac5000047802ULL, 0x002fce0000000f00ULL,
0x0000008000f47944ULL, 0x01cfea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005400037308ULL, 0x008ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000054ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001a051a7220ULL, 0x044fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x008ee20000000000ULL,
0x0000000140407812ULL, 0x000fe400078ec0ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00001000400d7824ULL, 0x000fe200078e020dULL,
0x0000001c1d1c723eULL, 0x000fc400000000ffULL, 0x000000101110723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000000121312723eULL, 0x000fc400000000ffULL, 0x00007632261d7816ULL, 0x000fe40000000022ULL,
0x000076321e217816ULL, 0x000fe40000000012ULL, 0x000000ff3800720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x108fe20000011603ULL, 0x0000000108087824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x040fe400078ec0ffULL, 0x0000000803077811ULL, 0x000fe200078ff0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe200078ff8ffULL,
0x0000001008087824ULL, 0x000fe200078e020dULL, 0x0000000700047211ULL, 0x002fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fc400078e00ffULL, 0x0000000805077824ULL, 0x040fe400078e00ffULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff809147812ULL, 0x000fe200078ee204ULL,
0x0000000805097824ULL, 0x000fe400078e00ffULL, 0x0000000402047836ULL, 0x000fe20000000000ULL,
0xfffffff807067812ULL, 0x000fe200078ee200ULL, 0x0000080038057824ULL, 0x000fe200078e020dULL,
0xfffffff807007812ULL, 0x000fe200078ee202ULL, 0x0000000602077836ULL, 0x000fe20000000000ULL,
0xfffffff8090a7812ULL, 0x000fe200078ee204ULL, 0x0000000803027824ULL, 0x000fc400078e00ffULL,
0x0000001000047824ULL, 0x100fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x000000181900723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x100fe200078e0205ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000002a2b19723eULL, 0x000fe200000000ffULL,
0x0000000104057824ULL, 0x000fe200078e0207ULL, 0x0000541000167816ULL, 0x040fe20000000002ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000763200177816ULL, 0x000fe20000000002ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000303100723eULL, 0x000fe200000000ffULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x0000001605007388ULL, 0x0003e20000000a00ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x0000541032187816ULL, 0x000fc40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x0000541000167816ULL, 0x142fe40000000002ULL,
0x0000763200177816ULL, 0x000fe40000000002ULL, 0x000076321c057816ULL, 0x000fe40000000010ULL,
0x0000001a1b00723eULL, 0x000fe200000000ffULL, 0x0000001606007388ULL, 0x0003e20000000a00ULL,
0x0000002e2f02723eULL, 0x000fc400000000ffULL, 0x0000541004167816ULL, 0x142fe40000000020ULL,
0x0000763204177816ULL, 0x000fe40000000020ULL, 0x000054101c047816ULL, 0x000fe40000000010ULL,
0x00005410261c7816ULL, 0x000fe20000000022ULL, 0x000000160a007388ULL, 0x000fe20000000a00ULL,
0x000054101e207816ULL, 0x000fc60000000012ULL, 0x000000040c007388ULL, 0x0003e40000000a00ULL,
0x0000541000047816ULL, 0x142fe40000000002ULL, 0x0000763200057816ULL, 0x000fca0000000002ULL,
0x0000000414007388ULL, 0x000fe80000000a00ULL, 0x0004001806007388ULL, 0x000fe80000000a00ULL,
0x0004001c0a007388ULL, 0x000fe80000000a00ULL, 0x000400200c007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000008107984ULL, 0x000e680000000c00ULL,
0x0004000008147984ULL, 0x000ee80000000c00ULL, 0x0008000008047984ULL, 0x000f680000000c00ULL,
0x000c000008187984ULL, 0x000f620000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000000713137230ULL, 0x024fe40000000000ULL,
0x0000000612127230ULL, 0x000fe40000000000ULL, 0x0000000511117230ULL, 0x000fe40000000000ULL,
0x0000000410107230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000001008007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001408007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fc80000011603ULL,
0x0000000f0200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000800067d06ULL, 0x000ea20008209000ULL, 0x0000000141007824ULL, 0x000fe200078e0202ULL,
0x00000008ff137c12ULL, 0x002fe2000f8e33ffULL, 0x0000000102027824ULL, 0x000fe200078e0203ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fe200078ef803ULL,
0x0000000600067308ULL, 0x004e680000001000ULL, 0x0000001002027824ULL, 0x000fe400078e020dULL,
0x0ffffffe06077836ULL, 0x002fc80000000000ULL, 0x0000000700057305ULL, 0x000e64000021f000ULL,
0x000000ffff097224ULL, 0x002fc800078e0a05ULL, 0x0000000809097c24ULL, 0x000fc8000f8e02ffULL,
0x0000000905117227ULL, 0x000fe400078e0004ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000011047227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000805057c24ULL, 0x000fca000f8e0200ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fca0000000000ULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000000904057c24ULL, 0x000fe4000f8e0243ULL,
0x0000000807007c24ULL, 0x000fe2000f8e0200ULL, 0x0000000703077812ULL, 0x000fc600078ec0ffULL,
0x0000000805057c24ULL, 0x000fe4000f8e0200ULL, 0x0000002003007836ULL, 0x000fe40000000000ULL,
0x0000000840077824ULL, 0x000fe200078e0207ULL, 0x000000050e057210ULL, 0x000fe40007f3e0ffULL,
0x00000003ff027819ULL, 0x002fc60000011600ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4406ULL,
0x0000000f0200720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000141047824ULL, 0x102fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x0000000411067227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a06ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef800ULL, 0x0000001002027824ULL, 0x000fe400078e020dULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x0000000613067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000000906057c24ULL, 0x000fe4000f8e0243ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000004003007836ULL, 0x000fe40000000000ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000840077824ULL, 0x000fe200078e0207ULL,
0x00000003ff027819ULL, 0x002fc40000011600ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4406ULL, 0x0000000f0200720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000141047824ULL, 0x102fe400078e0202ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x0000000411067227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a06ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0000000702057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805027812ULL, 0x000fca00078ef800ULL,
0x0000001002027824ULL, 0x000fe400078e020dULL, 0x0000000106062836ULL, 0x000fc60000000000ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x0000000613067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000000906057c24ULL, 0x000fe4000f8e0243ULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000006003007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000840037824ULL, 0x000fc600078e0207ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000001003027825ULL, 0x002fc600078e0004ULL, 0x0000000f0600720cULL, 0x000fe20003f26070ULL,
0x0000000141417824ULL, 0x000fe200078e0206ULL, 0x0000000802007986ULL, 0x0043f6000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000004111047227ULL, 0x000fe200078e00ffULL,
0x0000000700057812ULL, 0x000fc600078ec0ffULL, 0x000000ffff027224ULL, 0x002fe400078e0a04ULL,
0x0000000100067824ULL, 0x000fe400078e0206ULL, 0x0000000802027c24ULL, 0x000fe4000f8e0241ULL,
0x0000000840057824ULL, 0x000fe200078e0205ULL, 0x0000000706037812ULL, 0x000fe400078ec0ffULL,
0x0000000802007c0cULL, 0x000fda000bf26070ULL, 0x8000000802021c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000802007c0cULL, 0x000fe4000bf46070ULL,
0xfffffff803027812ULL, 0x000fca00078ef800ULL, 0x00000010020d7824ULL, 0x000fca00078e020dULL,
0x000000000d087984ULL, 0x000e620000000c00ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x0000000413047207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e0243ULL, 0x0000000802417c24ULL, 0x000fc8000f8e0241ULL,
0x0000000804417c24ULL, 0x000fca000f8e0241ULL, 0x000000410e417210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000441027c11ULL, 0x000fc8000f8040ffULL,
0x0000000541037c11ULL, 0x000fc600080f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000003a4000720cULL, 0x000fe20003f06070ULL, 0x00009a00ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fd200078e00ffULL,
0x00009600ff048b82ULL, 0x000ea20000000800ULL, 0x0000000207098824ULL, 0x000fce00078e00ffULL,
0x00009200ff0e8b82ULL, 0x000ee20000000a00ULL, 0x000000060a0a7981ULL, 0x002322000c1e9900ULL,
0x0000000409098224ULL, 0x004fc800078e0240ULL, 0x00000004090e8825ULL, 0x008fe400078e000eULL,
0x017600080d0879a7ULL, 0x000266000850003fULL, 0x000000060e318981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0300780cULL, 0x000fe20003f04070ULL, 0x0000004002027824ULL, 0x000fe400078e00ffULL,
0x0000004040047824ULL, 0x000fe400078e00ffULL, 0x0000004043037824ULL, 0x000fc400078e00ffULL,
0x0000003102317224ULL, 0x004fcc00078e02ffULL, 0x0000000c002c0947ULL, 0x002fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000a00ULL, 0x00000003ff1d7819ULL, 0x000fe4000001160cULL,
0x000000043b0b7248ULL, 0x000fc60007fe0000ULL, 0x000000041d0f7836ULL, 0x000fe40000000000ULL,
0x000000010b1c7824ULL, 0x000fe400078e0a04ULL, 0x000000010f0b7824ULL, 0x140fe400078e020cULL,
0x000000080f247824ULL, 0x040fe200078e00ffULL, 0x0000001c0f00720cULL, 0x080fe20003f86070ULL,
0x000000081d0f7836ULL, 0x000fe40000000000ULL, 0x0000000c1d117836ULL, 0x000fe20000000000ULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x0000004043437824ULL, 0x000fe200078e021dULL,
0x0000001c0f00720cULL, 0x0c0fe20003f06070ULL, 0x000000010f0b7824ULL, 0x000fe200078e020cULL,
0x0000001c1100720cULL, 0x000fe20003f26070ULL, 0x000000080f267824ULL, 0x000fc400078e00ffULL,
0x0000000111127824ULL, 0x000fe200078e020cULL, 0x0000001831187211ULL, 0x002fe200078438ffULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20bULL,
0x00000080430e7825ULL, 0x000fe200078e00ffULL, 0x00000019310b7211ULL, 0x000fe400010f3cffULL,
0xfffffff813287812ULL, 0x000fe200078ee212ULL, 0x0000000443107836ULL, 0x000fe20000000000ULL,
0x000000700e217812ULL, 0x000fe200078ef805ULL, 0x0000000843127836ULL, 0x000fc40000000000ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000002118207210ULL, 0x000fc60007f5e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070101f7812ULL, 0x000fc600078ef805ULL,
0x0000000c430e7836ULL, 0x000fe20000000000ULL, 0x0000007012157812ULL, 0x000fe200078ef805ULL,
0x000000010f217824ULL, 0x000fe200010e060bULL, 0x000000181f1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001815147210ULL, 0x000fc60007f5e0ffULL,
0x0000001043107836ULL, 0x000fe20000000000ULL, 0x000000700e1b7812ULL, 0x000fe200078ef805ULL,
0x0000001443167836ULL, 0x000fe40000000000ULL, 0x00000001111f7824ULL, 0x000fe400018e060bULL,
0x0000001843227836ULL, 0x000fe40000000000ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007010257812ULL, 0x000fc600078ef805ULL,
0x0000000113157824ULL, 0x000fe200010e060bULL, 0x000000181b1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000007016197812ULL, 0x000fc600078ef805ULL,
0x000000010f1b7824ULL, 0x000fe200010e060bULL, 0x0000007022137812ULL, 0x000fe200078ef805ULL,
0x0000001c43167836ULL, 0x000fe20000000000ULL, 0x0000001825127210ULL, 0x000fe20007f5e0ffULL,
0x000000141d257836ULL, 0x000fe20000000000ULL, 0x0000001819107210ULL, 0x000fe20007f7e0ffULL,
0x0000400040197824ULL, 0x000fe200078e020dULL, 0x00000018130e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000111137824ULL, 0x100fe400010e060bULL, 0x0000000117117824ULL, 0x000fe200018e060bULL,
0x0000001c2500720cULL, 0x000fe20003f66070ULL, 0x000000011d177824ULL, 0x000fc400078e020cULL,
0x00000001230f7824ULL, 0x000fe200028e060bULL, 0x0000001c1d00720cULL, 0x000fe20003fa6070ULL,
0x000000101d237836ULL, 0x000fe20000000000ULL, 0x0000000717297812ULL, 0x000fe200078ec0ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0ffffff8292c7812ULL, 0x000fe200078ef80cULL,
0x0000000123227824ULL, 0x140fe200078e020cULL, 0x0000007016277812ULL, 0x000fe200078ef805ULL,
0x00000008232b7824ULL, 0x040fe200078e00ffULL, 0x0000001c2300720cULL, 0x000fe20003f46070ULL,
0x0000100019197836ULL, 0x000fe20000000000ULL, 0x0000001827167210ULL, 0x000fe20007fde0ffULL,
0x0000000125237824ULL, 0x040fe200078e020cULL, 0xfffffff82b2a7812ULL, 0x000fe200078ee222ULL,
0x00000008252e7824ULL, 0x000fe400078e00ffULL, 0x000000102c277824ULL, 0x000fc400078e0219ULL,
0x0000002043227836ULL, 0x000fe20000000000ULL, 0xfffffff82e2c7812ULL, 0x000fe200078ee223ULL,
0x0000001024297824ULL, 0x000fe200078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000e901c46ULL, 0x0000002443247836ULL, 0x000fe40000000000ULL,
0x000000181d2b7836ULL, 0x000fe20000000000ULL, 0x000000001e297faeULL, 0x0005e2000e101c46ULL,
0x0000001c1d2f7836ULL, 0x000fe40000000000ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000001c2b00720cULL, 0x000fc40003fa6070ULL, 0x0000001c2f00720cULL, 0x000fe20003f86070ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000007022317812ULL, 0x000fc600078ef805ULL,
0x000000012b2d7824ULL, 0x140fe400078e020cULL, 0x000000082b2e7824ULL, 0x000fe200078e00ffULL,
0x00000070242b7812ULL, 0x000fe200078ef805ULL, 0x000000012f277824ULL, 0x042fe400078e020cULL,
0x000000082f1e7824ULL, 0x004fe200078e00ffULL, 0xfffffff82e247812ULL, 0x000fe200078ee22dULL,
0x0000000117177824ULL, 0x000fe200030e060bULL, 0x0000001831207210ULL, 0x000fe20007fde0ffULL,
0x000000201d297836ULL, 0x000fe20000000000ULL, 0xfffffff81e2e7812ULL, 0x000fe200078ee227ULL,
0x00000028431e7836ULL, 0x000fc40000000000ULL, 0x0000001026277824ULL, 0x000fe400078e0219ULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0x0000000014277faeULL, 0x0003e2000c101c46ULL,
0x0000000123217824ULL, 0x100fe200030e060bULL, 0x000000182b227210ULL, 0x000fe20007fde0ffULL,
0x0000000129267824ULL, 0x140fe200078e020cULL, 0x0000001c2900720cULL, 0x0c0fe20003f06070ULL,
0x00000008292d7824ULL, 0x000fe200078e00ffULL, 0x000000701e297812ULL, 0x000fe200078ef805ULL,
0x0000000125237824ULL, 0x000fe400030e060bULL, 0x0000001028257824ULL, 0x100fe200078e0219ULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000241d2b7836ULL, 0x000fe20000000000ULL,
0x0000001829147210ULL, 0x002fe20007fde0ffULL, 0x000000102e277824ULL, 0x000fe200078e0219ULL,
0x000000001a257faeULL, 0x0003e2000c901c46ULL, 0x000000012b1e7824ULL, 0x040fe200078e020cULL,
0x0000001c2b00720cULL, 0x000fe20003f26070ULL, 0x000000011f157824ULL, 0x000fc400030e060bULL,
0x000000102c1f7824ULL, 0x100fe400078e0219ULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x0000001026297824ULL, 0x100fe400078e0219ULL, 0x000000381d2d7836ULL, 0x000fe20000000000ULL,
0xfffffff82b1e7812ULL, 0x000fe200078ee21eULL, 0x000000102a1b7824ULL, 0x002fe400078e0219ULL,
0x0000002c431a7836ULL, 0x000fc40000000000ULL, 0x0000001024257824ULL, 0x100fe200078e0219ULL,
0x00000000121b7faeULL, 0x0003e2000d101c46ULL, 0x000000101e2b7824ULL, 0x000fe400078e0219ULL,
0x000000082d247824ULL, 0x000fe200078e00ffULL, 0x00000000101f7faeULL, 0x0005e8000d901c46ULL,
0x000000000e257faeULL, 0x0007e2000e901c46ULL, 0x0000002c1d1b7836ULL, 0x002fc60000000000ULL,
0x0000000016277faeULL, 0x0003e2000e101c46ULL, 0x000000281d137836ULL, 0x000fe40000000000ULL,
0x000000801a107825ULL, 0x004fe200078e00ffULL, 0x0000000020297faeULL, 0x0005e2000c101c46ULL,
0x0000001c1b00720cULL, 0x080fe40003f86070ULL, 0x000000301d1f7836ULL, 0x000fe20000000000ULL,
0x00000070100f7812ULL, 0x008fe200078ef805ULL, 0x0000003043107836ULL, 0x000fe20000000000ULL,
0x00000000222b7faeULL, 0x0007e2000c901c46ULL, 0x000000341d257836ULL, 0x000fe20000000000ULL,
0x000000180f0e7210ULL, 0x000fe20007fde0ffULL, 0x0000003c1d277836ULL, 0x002fe20000000000ULL,
0x0000001c1300720cULL, 0x080fe20003fa6070ULL, 0x000000011b1a7824ULL, 0x000fe200078e020cULL,
0x0000001c1f00720cULL, 0x080fe20003f66070ULL, 0x00000001110f7824ULL, 0x000fe200030e060bULL,
0x0000001c2500720cULL, 0x080fe20003f46070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001c2d00720cULL, 0x000fc40003f26070ULL, 0x0000001c2700720cULL, 0x000fe20003f06070ULL,
0x0000003443127836ULL, 0x000fe40000000000ULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0x00000070101b7812ULL, 0x000fe200078ef805ULL, 0x000000011f107824ULL, 0x100fe400078e020cULL,
0x0000000113177824ULL, 0x040fe200078e020cULL, 0x000000181b167210ULL, 0x000fe20007fde0ffULL,
0x00000008131c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1e7812ULL, 0x000fe200078ee21aULL,
0x000000081f1f7824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee217ULL, 0xfffffff81f207812ULL, 0x004fe200078ee210ULL,
0x0000003843107836ULL, 0x000fe20000000000ULL, 0x00000070121b7812ULL, 0x000fe200078ef805ULL,
0x0000000111177824ULL, 0x000fe400030e060bULL, 0x0000000125127824ULL, 0x040fe200078e020cULL,
0x000000181b1a7210ULL, 0x000fe20007fde0ffULL, 0x0000000825257824ULL, 0x000fc400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff825227812ULL, 0x008fe200078ee212ULL,
0x0000003c43437836ULL, 0x000fe20000000000ULL, 0x0000007010217812ULL, 0x000fe200078ef805ULL,
0x00000001131b7824ULL, 0x000fe400030e060bULL, 0x0000008043127825ULL, 0x000fe200078e00ffULL,
0x0000001821107210ULL, 0x000fc60007fde0ffULL, 0x000000012d1d7824ULL, 0x100fe200078e020cULL,
0x0000007012057812ULL, 0x000fe200078ef805ULL, 0x00000001271f7824ULL, 0x040fe400078e020cULL,
0x0000000827267824ULL, 0x000fe200078e00ffULL, 0xfffffff8240c7812ULL, 0x000fe200078ee21dULL,
0x0000000111117824ULL, 0x000fe200030e060bULL, 0x0000001805187210ULL, 0x000fe20007fde0ffULL,
0x000000101c057824ULL, 0x100fe200078e0219ULL, 0xfffffff826127812ULL, 0x000fe200078ee21fULL,
0x000000101e1d7824ULL, 0x000fc400078e0219ULL, 0x00000010201f7824ULL, 0x100fe200078e0219ULL,
0x0000000014057faeULL, 0x0003e2000e901c46ULL, 0x0000001022217824ULL, 0x100fe400078e0219ULL,
0x000000100c237824ULL, 0x100fe200078e0219ULL, 0x000000000e1d7faeULL, 0x0003e2000e101c46ULL,
0x0000001012257824ULL, 0x000fe400078e0219ULL, 0x0000000113197824ULL, 0x000fe200030e060bULL,
0x00000000161f7faeULL, 0x0003e8000d901c46ULL, 0x000000001a217faeULL, 0x0003e8000d101c46ULL,
0x0000000010237faeULL, 0x0003e8000c901c46ULL, 0x0000000018257faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x000000040c117811ULL, 0x040fe400078fe8ffULL,
0x0000000c0c157811ULL, 0x040fe400078fe8ffULL, 0x000000100c177811ULL, 0x040fe200078fe8ffULL,
0x00000001110b7824ULL, 0x140fe200078e020cULL, 0x000000140c167811ULL, 0x040fe200078fe8ffULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0x0000001c0c1d7811ULL, 0x040fe200078fe8ffULL,
0x0000000815257824ULL, 0x000fe200078e00ffULL, 0x000000200c1f7811ULL, 0x040fe200078fe8ffULL,
0x00000001170f7824ULL, 0x100fe200078e020cULL, 0xfffffff80e217812ULL, 0x000fe200078ee20bULL,
0x00000001150e7824ULL, 0x100fe200078e020cULL, 0x000000240c307811ULL, 0x040fe200078fe8ffULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0x000000080c137811ULL, 0x000fe200078fe8ffULL,
0x0000000116107824ULL, 0x140fe200078e020cULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x0000000816297824ULL, 0x000fe200078e00ffULL, 0xfffffff814277812ULL, 0x000fe200078ee20fULL,
0x000000011d0e7824ULL, 0x140fe200078e020cULL, 0x0000002c0c337811ULL, 0x040fe200078fe8ffULL,
0x000000081d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee210ULL,
0x000000011f0f7824ULL, 0x140fe200078e020cULL, 0x000000300c327811ULL, 0x040fe200078fe8ffULL,
0x000000081f147824ULL, 0x000fe200078e00ffULL, 0x000000180c1c7811ULL, 0x000fe200078fe8ffULL,
0x0000000130107824ULL, 0x140fe200078e020cULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL,
0x0000000830197824ULL, 0x000fe200078e00ffULL, 0xfffffff8142f7812ULL, 0x000fe200078ee20fULL,
0x00000001130b7824ULL, 0x140fe200078e020cULL, 0x000000280c367811ULL, 0x040fe200078fe8ffULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0xfffffff8192a7812ULL, 0x000fe200078ee210ULL,
0x00000001330e7824ULL, 0x140fe200078e020cULL, 0x000000340c2e7811ULL, 0x000fe200078fe8ffULL,
0x0000000833197824ULL, 0x000fe200078e00ffULL, 0xfffffff812237812ULL, 0x000fe200078ee20bULL,
0x00000001320f7824ULL, 0x100fe200078e020cULL, 0x0000003c0c347811ULL, 0x000fe200078fe8ffULL,
0x0000000832247824ULL, 0x000fe200078e00ffULL, 0xfffffff819267812ULL, 0x000fe200078ee20eULL,
0x000000011c0b7824ULL, 0x100fe200078e020cULL, 0x000000380c357811ULL, 0x000fe200078fe8ffULL,
0x000000081c127824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000000836287824ULL, 0x000fe200078e00ffULL, 0x00009000ff0e7b82ULL, 0x000e620000000a00ULL,
0x000000012e107824ULL, 0x100fe200078e020cULL, 0xfffffff8122b7812ULL, 0x000fe200078ee20bULL,
0x00000001360b7824ULL, 0x000fc400078e020cULL, 0x000000082e1b7824ULL, 0x000fe400078e00ffULL,
0x0000000134127824ULL, 0x140fe200078e020cULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x0000000835197824ULL, 0x040fe200078e00ffULL, 0xfffffff81b227812ULL, 0x000fe200078ee210ULL,
0x00000008341b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0b7211ULL, 0x000fe200078fe8ffULL,
0x0000000135107824ULL, 0x000fe400078e020cULL, 0x0000400040147824ULL, 0x000fe200078e020dULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103187824ULL, 0x000fe200078e0215ULL,
0xfffffff81b127812ULL, 0x000fe200078ee212ULL, 0x0000100014147836ULL, 0x000fe20000000000ULL,
0xfffffff819207812ULL, 0x000fe200078ee210ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000030c107211ULL, 0x000fc400078fe8ffULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef80cULL,
0x00000010120c7824ULL, 0x000fe200078e0214ULL, 0x0000000e312c7211ULL, 0x002fe200078038ffULL,
0x0000000103127824ULL, 0x000fe400078e0211ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000f31317211ULL, 0x000fc600000f3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0214ULL,
0x00000070101b7812ULL, 0x000fe200078ef805ULL, 0x0000001021217824ULL, 0x100fe400078e0214ULL,
0x0000001023237824ULL, 0x100fe200078e0214ULL, 0x0000001b2c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001025257824ULL, 0x100fe400078e0214ULL, 0x0000001027277824ULL, 0x100fe400078e0214ULL,
0x0000001029297824ULL, 0x000fc400078e0214ULL, 0x000000102b2b7824ULL, 0x100fe400078e0214ULL,
0x000000102d2d7824ULL, 0x100fe400078e0214ULL, 0x000000102f2f7824ULL, 0x100fe400078e0214ULL,
0x000000102a2a7824ULL, 0x100fe400078e0214ULL, 0x0000001028287824ULL, 0x100fe400078e0214ULL,
0x0000001026267824ULL, 0x000fc400078e0214ULL, 0x0000001024247824ULL, 0x100fe400078e0214ULL,
0x0000001022227824ULL, 0x100fe400078e0214ULL, 0x0000001020207824ULL, 0x000fe400078e0214ULL,
0x0000000103147824ULL, 0x000fe400078e0213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070120f7812ULL, 0x000fc600078ef805ULL,
0x00000001031a7824ULL, 0x040fe200078e0217ULL, 0x00000070141b7812ULL, 0x000fe200078ef805ULL,
0x00000001031c7824ULL, 0x000fe200078e021cULL, 0x0000000f2c107210ULL, 0x000fe20007f3e0ffULL,
0x00000001110f7824ULL, 0x000fe200000e0631ULL, 0x0000001b2c127210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018177812ULL, 0x000fe400078ef805ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000b901c46ULL,
0x00000001031e7824ULL, 0x040fe200078e021dULL, 0x000000172c147210ULL, 0x000fe20007f5e0ffULL,
0x00000001033c7824ULL, 0x000fe200078e021fULL, 0x000000701a177812ULL, 0x000fe200078ef805ULL,
0x0000000113117824ULL, 0x000fc400008e0631ULL, 0x0000000115137824ULL, 0x000fe400000e0631ULL,
0x0000000103187824ULL, 0x000fe200078e0216ULL, 0x000000172c167210ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000010217faeULL, 0x0003e6000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c3f7812ULL, 0x000fe200078ef805ULL,
0x0000000012237faeULL, 0x0003e4000b901c46ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000701e377812ULL, 0x000fc400078ef805ULL, 0x0000003f2c1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000011b177824ULL, 0x100fe200000e0631ULL, 0x000000703c1b7812ULL, 0x000fe200078ef805ULL,
0x0000000119157824ULL, 0x000fe200010e0631ULL, 0x000000372c1c7210ULL, 0x000fe20007f5e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001b2c1e7210ULL, 0x000fe40007f7e0ffULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x0000000103307824ULL, 0x040fe200078e0230ULL,
0x0000007018437812ULL, 0x000fe200078ef805ULL, 0x0000000103367824ULL, 0x040fe200078e0236ULL,
0x0000000016277faeULL, 0x0003e2000b901c46ULL, 0x0000000103377824ULL, 0x040fe200078e0233ULL,
0x000000432c187210ULL, 0x000fe20007f1e0ffULL, 0x00000001033c7824ULL, 0x000fc400078e0232ULL,
0x000000011d1b7824ULL, 0x000fe400008e0631ULL, 0x00000001033e7824ULL, 0x040fe400078e022eULL,
0x0000000103427824ULL, 0x040fe400078e0235ULL, 0x0000000103447824ULL, 0x000fe400078e0234ULL,
0x0000008030327825ULL, 0x000fc800078e00ffULL, 0x000000011f1d7824ULL, 0x000fe200010e0631ULL,
0x0000007032517812ULL, 0x000fe200078ef805ULL, 0x0000008036347825ULL, 0x000fc800078e00ffULL,
0x000000013d1f7824ULL, 0x000fe200018e0631ULL, 0x00000070344f7812ULL, 0x000fe200078ef805ULL,
0x0000008037367825ULL, 0x000fc600078e00ffULL, 0x0000004f2c347210ULL, 0x000fe20007f3e0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x00000070364d7812ULL, 0x000fc600078ef805ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000703c4b7812ULL, 0x000fe400078ef805ULL,
0x0000004d2c367210ULL, 0x000fe20007f5e0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x000000703e497812ULL, 0x000fe400078ef805ULL, 0x0000004b2c3c7210ULL, 0x000fe20007f7e0ffULL,
0x0000008044447825ULL, 0x000fe200078e00ffULL, 0x0000007042477812ULL, 0x000fe400078ef805ULL,
0x000000492c3e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000119197824ULL, 0x100fe200000e0631ULL,
0x000000512c327210ULL, 0x000fe20007f1e0ffULL, 0x0000000135357824ULL, 0x100fe200008e0631ULL,
0x0000007044057812ULL, 0x000fe200078ef805ULL, 0x0000000137377824ULL, 0x100fe200010e0631ULL,
0x000000472c427210ULL, 0x000fe20007fbe0ffULL, 0x0000000133337824ULL, 0x100fe200000e0631ULL,
0x000000052c307210ULL, 0x000fe20007fde0ffULL, 0x0000000018297faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc400018e0631ULL, 0x000000013f3f7824ULL, 0x100fe200020e0631ULL,
0x000000001a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000000143437824ULL, 0x100fe400028e0631ULL,
0x0000000145317824ULL, 0x000fe200030e0631ULL, 0x000000001c2d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e2f7faeULL, 0x0003e8000b901c46ULL, 0x00000000322a7faeULL, 0x0003e8000b901c46ULL,
0x0000000034287faeULL, 0x0003e8000b901c46ULL, 0x0000000036267faeULL, 0x0003e8000b901c46ULL,
0x000000003c247faeULL, 0x0003e8000b901c46ULL, 0x000000003e227faeULL, 0x0003e8000b901c46ULL,
0x0000000042207faeULL, 0x0003e8000b901c46ULL, 0x00000000300c7faeULL, 0x0003e4000b901c46ULL,
0x0000000440457836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff057424ULL, 0x002fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000003a4500720cULL, 0x000fda0003f06070ULL, 0x00009600ff0b8b82ULL, 0x000e620000000800ULL,
0x00000002070c8824ULL, 0x000fce00078e00ffULL, 0x00009200ff0e8b82ULL, 0x000ea20000000a00ULL,
0x0000000b0c0b8224ULL, 0x002fc800078e0245ULL, 0x000000040b0e8825ULL, 0x004fca00078e000eULL,
0x000000060e058981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000e7805ULL, 0x002fce0000015200ULL,
0x017600090d0075a7ULL, 0x000e62000800017fULL, 0x00000004060b7c24ULL, 0x000fe4000f8e02ffULL,
0x000000013b067824ULL, 0x000fca00078e0a00ULL, 0x00000008ff067819ULL, 0x000fe20000011606ULL,
0x00008e00ff747b82ULL, 0x000ea40000000a00ULL, 0x000000040b747825ULL, 0x004fe200078e0074ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x000000100e0c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0fULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011410ULL,
0x0000000c0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e0610ULL,
0x000000020b0b7819ULL, 0x000fc8000000120cULL, 0x0000000b0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x017600090d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002040087824ULL, 0x002fca00078e0209ULL,
0x00000003ff097819ULL, 0x000fc80000011608ULL, 0x1ffffffe090b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f08097812ULL, 0x000fc600078ec0ffULL, 0x00000001080b7824ULL, 0x000fe400078e020bULL,
0x00000010090c7824ULL, 0x000fe400078e00ffULL, 0x000000010b087836ULL, 0x000fe20000000000ULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010090e7824ULL, 0x000fc600078e00ffULL,
0x0000000f08097812ULL, 0x000fe400078ec0ffULL, 0x000000f00c087812ULL, 0x000fe400078ee20bULL,
0x000000f00e0c7812ULL, 0x000fc600078ee209ULL, 0x0000001008087824ULL, 0x100fe400078e020dULL,
0x000000100c0c7824ULL, 0x000fc600078e020dULL, 0x0000000008147984ULL, 0x000e680000000c00ULL,
0x000000000c107984ULL, 0x000ea20000000c00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001808007388ULL, 0x0003e20000000c00ULL,
0x00000001ff107424ULL, 0x000fc600078e00ffULL, 0x000000140c007388ULL, 0x0003e60000000c00ULL,
0x017600100d1079a7ULL, 0x0002a4000850003fULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x017600110d0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff127224ULL, 0x000fce00078e00ffULL, 0x000000101200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e080c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e09ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001140eULL, 0x0000000c0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060eULL, 0x000000020b0b7819ULL, 0x000fc8000000120cULL,
0x0000000b0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000112127836ULL, 0x000fce0000000000ULL, 0x017600110d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff0c7b82ULL, 0x000e620000000800ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x3db504f30a097820ULL, 0x010fe20000410000ULL,
0x00000100040a7836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x00000008400b7824ULL, 0x140fe400078e020dULL, 0x00000009000e7836ULL, 0x000fe40000000000ULL,
0x00000020400f7824ULL, 0x000fe400078e020dULL, 0x000000ffff437224ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x000fe400078e00ffULL, 0x0000000c07077224ULL, 0x002fe400078e02ffULL,
0xffffffff000c7836ULL, 0x000fce0000000000ULL, 0x0000000243127836ULL, 0x000fe20000000000ULL,
0x0000000110387812ULL, 0x000fe200078e0cffULL, 0x0000000502577224ULL, 0x010fc600078e02ffULL,
0x000000391200720cULL, 0x000fda0003f06070ULL, 0x0000000c003c8947ULL, 0x008fea0003800000ULL,
0x0000010043167824ULL, 0x000fe200078e020aULL, 0x00000003ff1f7819ULL, 0x004fe20000011608ULL,
0x00009000ff147b82ULL, 0x000e660000000a00ULL, 0x000000163b057248ULL, 0x000fe20007fe0000ULL,
0x000000081f137836ULL, 0x000fe40000000000ULL, 0x0000000c1f177836ULL, 0x000fe40000000000ULL,
0x000000041f117836ULL, 0x000fc40000000000ULL, 0x0000000113127824ULL, 0x040fe400078e0208ULL,
0x0000000813197824ULL, 0x000fe400078e00ffULL, 0x0000000105167824ULL, 0x000fe400078e0a16ULL,
0x0000000117187824ULL, 0x140fe200078e0208ULL, 0xfffffff819307812ULL, 0x000fe200078ee212ULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0x000000161300720cULL, 0x080fe20003f06070ULL,
0x0000000111057824ULL, 0x040fe200078e0208ULL, 0x000000161100720cULL, 0x040fe20003f26070ULL,
0x00000008112c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b327812ULL, 0x000fe200078ee218ULL,
0x000000101f257836ULL, 0x000fc40000000000ULL, 0x000000141f277836ULL, 0x000fe20000000000ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee205ULL, 0x0000000125287824ULL, 0x140fe200078e0208ULL,
0x000000162500720cULL, 0x040fe20003fa6070ULL, 0x0000000825197824ULL, 0x000fe400078e00ffULL,
0x0000000127267824ULL, 0x040fe400078e0208ULL, 0x00000008271b7824ULL, 0x000fe200078e00ffULL,
0xfffffff819287812ULL, 0x000fe200078ee228ULL, 0x0000001008057824ULL, 0x000fc400078e00ffULL,
0x0000000103187824ULL, 0x040fe200078e021fULL, 0xfffffff81b267812ULL, 0x000fe200078ee226ULL,
0x00000001031a7824ULL, 0x000fe200078e0211ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000000103227824ULL, 0x000fe200078e0213ULL, 0x0000001457137211ULL, 0x002fe200078438ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x0000001557127211ULL, 0x000fe200010f3cffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000518207212ULL, 0x000fc600078efcffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000000051a1c7212ULL, 0x080fe400078efcffULL,
0x0000002013207210ULL, 0x000fe20007f5e0ffULL, 0x0000001c1f2b7836ULL, 0x000fe20000000000ULL,
0x0000000522187212ULL, 0x000fe200078efcffULL, 0x000000181f297836ULL, 0x000fe20000000000ULL,
0x000000131c1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000012b117824ULL, 0x040fe200078e0208ULL,
0x0000001318187210ULL, 0x000fe20007f9e0ffULL, 0x000000082b227824ULL, 0x000fc400078e00ffULL,
0x00000001291e7824ULL, 0x140fe400078e0208ULL, 0x00000008291d7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000103147824ULL, 0x040fe400078e0217ULL,
0x0000000103247824ULL, 0x000fe200078e0225ULL, 0xfffffff81d1e7812ULL, 0x000fe200078ee21eULL,
0x000000011f1a7824ULL, 0x000fe400078e0208ULL, 0x0000400040117824ULL, 0x000fc400078e020dULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x0000000119217824ULL, 0x100fe200010e0612ULL, 0x000000161700720cULL, 0x080fe20003f46070ULL,
0x000000011b1d7824ULL, 0x100fe200018e0612ULL, 0x000000071a1b7812ULL, 0x000fe200078ec0ffULL,
0x000000201f317836ULL, 0x000fe20000000000ULL, 0x00000005141a7212ULL, 0x080fe200078efcffULL,
0x0000200038177824ULL, 0x000fe200078e0211ULL, 0x0000000524147212ULL, 0x000fe200078efcffULL,
0x0000000123197824ULL, 0x000fe200020e0612ULL, 0x0ffffff81b247812ULL, 0x000fe200078ef808ULL,
0x00000001312a7824ULL, 0x040fe200078e0208ULL, 0x000000131a1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000831237824ULL, 0x000fe200078e00ffULL, 0x0000001314147210ULL, 0x000fe20007fde0ffULL,
0x0000100017177836ULL, 0x000fe20000000000ULL, 0x000000161f00720cULL, 0x080fe20003f66070ULL,
0x00000001151b7824ULL, 0x000fe200020e0612ULL, 0xfffffff8232a7812ULL, 0x000fe200078ee22aULL,
0x0000001024237824ULL, 0x000fe200078e0217ULL, 0x000000162700720cULL, 0x000fe20003f86070ULL,
0x0000000103247824ULL, 0x000fc400078e0227ULL, 0x0000000125157824ULL, 0x000fe400030e0612ULL,
0x0000008024247825ULL, 0x000fc800078e00ffULL, 0x000000102c277824ULL, 0x000fe200078e0217ULL,
0x0000000524247212ULL, 0x000fe200078efcffULL, 0x00000001032c7824ULL, 0x040fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000d901c46ULL,
0x00000001032e7824ULL, 0x000fe200078e022bULL, 0x000000162900720cULL, 0x080fe20003f66070ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000001324247210ULL, 0x000fe20007fde0ffULL,
0x000000001c277faeULL, 0x0005e2000c901c46ULL, 0x000000162b00720cULL, 0x000fe20003f26070ULL,
0x000000241f297836ULL, 0x000fc40000000000ULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000052c207212ULL, 0x002fc600078efcffULL, 0x0000000129217824ULL, 0x040fe400078e0208ULL,
0x00000008292c7824ULL, 0x000fe400078e00ffULL, 0x0000000125257824ULL, 0x100fe200030e0612ULL,
0x0000001320207210ULL, 0x000fe20007fde0ffULL, 0x0000001030237824ULL, 0x100fe200078e0217ULL,
0x000000052e1c7212ULL, 0x004fe200078efcffULL, 0x0000001032277824ULL, 0x000fe200078e0217ULL,
0xfffffff82c307812ULL, 0x000fe200078ee221ULL, 0x000000012d217824ULL, 0x000fe200030e0612ULL,
0x000000131c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000001032c7824ULL, 0x000fe200078e0231ULL,
0x0000000018237faeULL, 0x0003e2000c101c46ULL, 0x000000163100720cULL, 0x000fe20003f06070ULL,
0x0000002c1f317836ULL, 0x000fc40000000000ULL, 0x000000012f1d7824ULL, 0x000fe200030e0612ULL,
0x000000001a277faeULL, 0x0005e2000d101c46ULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x000000162900720cULL, 0x000fc60003f46070ULL, 0x000000281f2f7836ULL, 0x000fe20000000000ULL,
0x000000052c2c7212ULL, 0x000fe200078efcffULL, 0x0000000103187824ULL, 0x002fe400078e0229ULL,
0x000000012f197824ULL, 0x140fe400078e0208ULL, 0x000000082f2e7824ULL, 0x000fe200078e00ffULL,
0x000000132c1a7210ULL, 0x004fe20007fde0ffULL, 0x0000000131297824ULL, 0x040fe400078e0208ULL,
0x0000000831327824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2c7812ULL, 0x000fe200078ee219ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff8322e7812ULL, 0x000fe200078ee229ULL,
0x0000001028237824ULL, 0x000fe400078e0217ULL, 0x0000000103287824ULL, 0x000fe400078e022fULL,
0x00000010262b7824ULL, 0x000fe200078e0217ULL, 0x0000000518267212ULL, 0x000fe200078efcffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000000014237faeULL, 0x0003e2000e901c46ULL,
0x000000162f00720cULL, 0x080fe40003fa6070ULL, 0x000000012d1b7824ULL, 0x000fe200030e0612ULL,
0x0000001326267210ULL, 0x000fe20007fde0ffULL, 0x00000000242b7faeULL, 0x0005e2000e101c46ULL,
0x0000000103187824ULL, 0x000fe200078e0231ULL, 0x000000163100720cULL, 0x000fc40003f86070ULL,
0x0000000119277824ULL, 0x000fe400030e0612ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000528147212ULL, 0x002fc600078efcffULL, 0x000000301f157836ULL, 0x000fe20000000000ULL,
0x0000001314147210ULL, 0x000fe20007fde0ffULL, 0x000000101e237824ULL, 0x000fe200078e0217ULL,
0x0000000518187212ULL, 0x000fe200078efcffULL, 0x0000000115247824ULL, 0x044fe400078e0208ULL,
0x0000000815257824ULL, 0x040fe200078e00ffULL, 0x0000000020237faeULL, 0x0003e2000d901c46ULL,
0x000000161500720cULL, 0x000fe20003f66070ULL, 0x00000001031e7824ULL, 0x000fe400078e0215ULL,
0xfffffff825247812ULL, 0x000fe200078ee224ULL, 0x0000000129157824ULL, 0x000fe200030e0612ULL,
0x0000001318187210ULL, 0x000fe20007fde0ffULL, 0x0000001022257824ULL, 0x000fc400078e0217ULL,
0x0000003c1f2b7836ULL, 0x000fe40000000000ULL, 0x0000000119197824ULL, 0x000fe200030e0612ULL,
0x000000001c257faeULL, 0x0005e2000c901c46ULL, 0x000000341f237836ULL, 0x002fe40000000000ULL,
0x000000801e207825ULL, 0x000fc600078e00ffULL, 0x000000162300720cULL, 0x0c0fe20003f26070ULL,
0x0000000123227824ULL, 0x040fe200078e0208ULL, 0x0000000520207212ULL, 0x000fe200078efcffULL,
0x0000000823297824ULL, 0x000fe400078e00ffULL, 0x00000001031e7824ULL, 0x000fe200078e0223ULL,
0x0000001320207210ULL, 0x000fe20007fde0ffULL, 0x000000102a237824ULL, 0x000fe200078e0217ULL,
0xfffffff829287812ULL, 0x000fe200078ee222ULL, 0x000000381f297836ULL, 0x000fe40000000000ULL,
0x000000801e1c7825ULL, 0x004fe200078e00ffULL, 0x000000001a237faeULL, 0x0003e2000c101c46ULL,
0x000000162b00720cULL, 0x000fc40003f06070ULL, 0x00000001031e7824ULL, 0x000fe200078e0229ULL,
0x000000051c1c7212ULL, 0x000fe200078efcffULL, 0x0000000121217824ULL, 0x000fe400030e0612ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000131c1c7210ULL, 0x000fc60007fde0ffULL,
0x0000000103227824ULL, 0x000fe200078e022bULL, 0x000000051e1e7212ULL, 0x000fe200078efcffULL,
0x0000001030257824ULL, 0x000fe400078e0217ULL, 0x00000080221a7825ULL, 0x002fc600078e00ffULL,
0x0000000026257faeULL, 0x0003e2000d101c46ULL, 0x000000011d1d7824ULL, 0x000fe200030e0612ULL,
0x000000131e1e7210ULL, 0x000fe20007fde0ffULL, 0x000000012b227824ULL, 0x100fe200078e0208ULL,
0x000000162900720cULL, 0x040fe20003f46070ULL, 0x0000000129237824ULL, 0x040fe200078e0208ULL,
0x000000051a167212ULL, 0x000fe200078efcffULL, 0x00000008292a7824ULL, 0x000fe400078e00ffULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x000000011f1f7824ULL, 0x000fe200030e0612ULL,
0xfffffff82a1a7812ULL, 0x000fe200078ee223ULL, 0x000000102c057824ULL, 0x100fe200078e0217ULL,
0xfffffff82b227812ULL, 0x000fe200078ee222ULL, 0x0000001024237824ULL, 0x100fe200078e0217ULL,
0x0000001316167210ULL, 0x000fe20007fde0ffULL, 0x000000102e137824ULL, 0x100fe200078e0217ULL,
0x0000000014057faeULL, 0x0005e2000e901c46ULL, 0x0000001028257824ULL, 0x002fc400078e0217ULL,
0x000000101a277824ULL, 0x100fe200078e0217ULL, 0x0000000018137faeULL, 0x0005e2000e101c46ULL,
0x0000001022297824ULL, 0x000fe400078e0217ULL, 0x000000011b177824ULL, 0x000fe200030e0612ULL,
0x0000000020237faeULL, 0x0005e8000d901c46ULL, 0x000000001c257faeULL, 0x0005e8000c901c46ULL,
0x000000001e277faeULL, 0x0005e8000d101c46ULL, 0x0000000016297faeULL, 0x0005e2000c101c46ULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x0000000408157811ULL, 0x044fe200078fe8ffULL,
0x00000010082f7824ULL, 0x040fe200078e00ffULL, 0x0000001008207811ULL, 0x040fe400078fe8ffULL,
0x0000001c081c7811ULL, 0x040fe200078fe8ffULL, 0x0000000115057824ULL, 0x140fe200078e0208ULL,
0x0000000c08187811ULL, 0x040fe200078fe8ffULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x0000002808297811ULL, 0x000fe200078fe8ffULL, 0x00000008204d7824ULL, 0x000fe200078e00ffULL,
0x0000000808177811ULL, 0x000fe200078fe8ffULL, 0x000000081c477824ULL, 0x000fe200078e00ffULL,
0xfffffff812537812ULL, 0x000fe200078ee205ULL, 0x0000000120127824ULL, 0x100fe200078e0208ULL,
0x00000018081e7811ULL, 0x000fe200078fe8ffULL, 0x0000000118117824ULL, 0x100fe200078e0208ULL,
0x0000003408277811ULL, 0x000fe200078fe8ffULL, 0x0000000818167824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee212ULL, 0x000000011c127824ULL, 0x100fe200078e0208ULL,
0x00000014081d7811ULL, 0x040fe200078fe8ffULL, 0x0000000829377824ULL, 0x000fe200078e00ffULL,
0xfffffff8164f7812ULL, 0x000fe200078ee211ULL, 0x0000000117057824ULL, 0x100fe200078e0208ULL,
0xfffffff847477812ULL, 0x000fe200078ee212ULL, 0x0000000129127824ULL, 0x100fe200078e0208ULL,
0x00000024082a7811ULL, 0x040fe200078fe8ffULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0x0000003808287811ULL, 0x000fe200078fe8ffULL, 0x000000011e117824ULL, 0x140fe200078e0208ULL,
0xfffffff837377812ULL, 0x000fe200078ee212ULL, 0x000000081e167824ULL, 0x000fe200078e00ffULL,
0xfffffff814517812ULL, 0x000fe200078ee205ULL, 0x0000000127127824ULL, 0x140fe200078e0208ULL,
0x00000020081f7811ULL, 0x040fe200078fe8ffULL, 0x0000000827337824ULL, 0x000fe200078e00ffULL,
0xfffffff816497812ULL, 0x000fe200078ee211ULL, 0x000000011d057824ULL, 0x140fe200078e0208ULL,
0x0000003008267811ULL, 0x000fe200078fe8ffULL, 0x000000081d147824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee212ULL, 0x000000012a117824ULL, 0x100fe200078e0208ULL,
0x0000002c08247811ULL, 0x000fe200078fe8ffULL, 0x000000082a167824ULL, 0x000fe200078e00ffULL,
0xfffffff8144b7812ULL, 0x000fe200078ee205ULL, 0x0000000128127824ULL, 0x100fe200078e0208ULL,
0x0000003c08257811ULL, 0x000fe200078fe8ffULL, 0x00000008281b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8163d7812ULL, 0x000fe200078ee211ULL, 0x000000011f057824ULL, 0x100fe200078e0208ULL,
0x000000702f2f7812ULL, 0x000fe200078ec0ffULL, 0x000000081f147824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL, 0x0000000126117824ULL, 0x140fe200078e0208ULL,
0x00009000ff127b82ULL, 0x000e620000000a00ULL, 0x0000000826167824ULL, 0x000fe200078e00ffULL,
0xfffffff8143f7812ULL, 0x000fe200078ee205ULL, 0x0000000124057824ULL, 0x000fc400078e0208ULL,
0x0000000824147824ULL, 0x000fe200078e00ffULL, 0xfffffff816197812ULL, 0x000fe200078ee211ULL,
0x0000400040117824ULL, 0x000fe400078e020dULL, 0x00000001251a7824ULL, 0x040fe200078e0208ULL,
0xfffffff814357812ULL, 0x000fe200078ee205ULL, 0x0000200038147824ULL, 0x000fe200078e0211ULL,
0x0000000808057211ULL, 0x040fe200078fe8ffULL, 0x0000000825217824ULL, 0x000fe400078e00ffULL,
0x0000100014167836ULL, 0x000fe20000000000ULL, 0x0000000308147211ULL, 0x000fe200078fe8ffULL,
0x0000000103177824ULL, 0x040fe200078e0217ULL, 0xfffffff821217812ULL, 0x000fe200078ee21aULL,
0x00000001031a7824ULL, 0x000fe200078e0215ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000101b327824ULL, 0x000fc400078e0216ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef808ULL, 0x00000012572d7211ULL, 0x042fe200078038ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000002f14127212ULL, 0x000fe400078efcffULL,
0x0000001357577211ULL, 0x000fe200000f3cffULL, 0x0000001005557824ULL, 0x100fe200078e0216ULL,
0x0000002f1a147212ULL, 0x000fe200078efcffULL, 0x0000001053537824ULL, 0x100fe200078e0216ULL,
0x000000122d127210ULL, 0x000fe20007f1e0ffULL, 0x0000001051517824ULL, 0x100fe200078e0216ULL,
0x000000142d147210ULL, 0x000fe20007f3e0ffULL, 0x000000104f4f7824ULL, 0x000fc400078e0216ULL,
0x000000104d4d7824ULL, 0x100fe400078e0216ULL, 0x000000104b4b7824ULL, 0x100fe400078e0216ULL,
0x0000001049497824ULL, 0x100fe400078e0216ULL, 0x0000001047477824ULL, 0x100fe400078e0216ULL,
0x000000103f3f7824ULL, 0x100fe400078e0216ULL, 0x000000103d3d7824ULL, 0x000fc400078e0216ULL,
0x0000001037377824ULL, 0x100fe400078e0216ULL, 0x0000001035357824ULL, 0x100fe400078e0216ULL,
0x0000001019347824ULL, 0x100fe400078e0216ULL, 0x0000001033337824ULL, 0x100fe400078e0216ULL,
0x0000001021057824ULL, 0x000fe400078e0216ULL, 0x0000008017167825ULL, 0x000fc800078e00ffULL,
0x0000000103207824ULL, 0x040fe200078e0220ULL, 0x0000002f16167212ULL, 0x080fe200078efcffULL,
0x0000000103187824ULL, 0x000fe400078e0218ULL, 0x0000000115137824ULL, 0x100fe200000e0657ULL,
0x000000162d167210ULL, 0x000fe20007f1e0ffULL, 0x000000011b157824ULL, 0x000fe400008e0657ULL,
0x00000080201a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012557faeULL, 0x0003e6000b901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000002f1a1a7212ULL, 0x080fe200078efcffULL, 0x0000000014537faeULL, 0x0003e4000b901c46ULL,
0x00000001031d7824ULL, 0x040fe200078e021dULL, 0x0000002f18187212ULL, 0x000fe200078efcffULL,
0x00000001031e7824ULL, 0x000fc400078e021eULL, 0x0000000103207824ULL, 0x040fe200078e021cULL,
0x000000182d187210ULL, 0x000fe20007f5e0ffULL, 0x0000000103227824ULL, 0x000fe400078e021fULL,
0x000000801d1c7825ULL, 0x000fc800078e00ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000002f1c1c7212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x000fe200000e0657ULL,
0x0000001a2d1a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000002f1e1e7212ULL, 0x080fe400078efcffULL, 0x0000000016517faeULL, 0x0003e2000b901c46ULL,
0x0000000103587824ULL, 0x000fe200078e022aULL, 0x0000002f20207212ULL, 0x000fe200078efcffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000001e2d1e7210ULL, 0x000fc60007f3e0ffULL,
0x00000001035a7824ULL, 0x040fe200078e0229ULL, 0x0000002f22227212ULL, 0x000fe200078efcffULL,
0x0000000103307824ULL, 0x040fe400078e0224ULL, 0x0000000103247824ULL, 0x040fe200078e0226ULL,
0x000000222d227210ULL, 0x000fe20007f7e0ffULL, 0x0000000103277824ULL, 0x040fe400078e0227ULL,
0x0000000103287824ULL, 0x040fe400078e0228ULL, 0x00000001032a7824ULL, 0x000fc400078e0225ULL,
0x0000008058587825ULL, 0x000fc800078e00ffULL, 0x000000805a5a7825ULL, 0x000fe200078e00ffULL,
0x0000002f582c7212ULL, 0x000fc600078efcffULL, 0x000000011b1b7824ULL, 0x000fe200000e0657ULL,
0x0000001c2d1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000002f5a2e7212ULL, 0x000fc600078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000002f30307212ULL, 0x000fc600078efcffULL, 0x0000000119197824ULL, 0x000fe200010e0657ULL,
0x000000202d207210ULL, 0x000fe20007f5e0ffULL, 0x0000008027267825ULL, 0x000fe200078e00ffULL,
0x0000002f24247212ULL, 0x080fe400078efcffULL, 0x00000000184f7faeULL, 0x0003e2000b901c46ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000002f26267212ULL, 0x080fe400078efcffULL,
0x000000001a4d7faeULL, 0x0003e2000b901c46ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002f28287212ULL, 0x000fc400078efcffULL, 0x000000262d267210ULL, 0x000fe20007f9e0ffULL,
0x000000011d1d7824ULL, 0x100fe200000e0657ULL, 0x0000002f2a2a7212ULL, 0x000fe200078efcffULL,
0x000000011f1f7824ULL, 0x100fe200008e0657ULL, 0x0000002c2d2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000121217824ULL, 0x100fe200010e0657ULL, 0x0000002e2d2e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000123237824ULL, 0x100fe200018e0657ULL, 0x000000302d307210ULL, 0x000fe20007f5e0ffULL,
0x000000001c4b7faeULL, 0x0003e2000b901c46ULL, 0x000000242d247210ULL, 0x000fe20007f7e0ffULL,
0x000000015b2f7824ULL, 0x100fe200008e0657ULL, 0x000000282d287210ULL, 0x000fe20007fbe0ffULL,
0x0000000131317824ULL, 0x100fe200010e0657ULL, 0x0000002a2d2a7210ULL, 0x000fe20007fde0ffULL,
0x00000001592d7824ULL, 0x100fe200000e0657ULL, 0x000000001e497faeULL, 0x0003e2000b901c46ULL,
0x0000000125257824ULL, 0x000fc400018e0657ULL, 0x0000000127277824ULL, 0x100fe200020e0657ULL,
0x0000000020477faeULL, 0x0003e2000b901c46ULL, 0x0000000129297824ULL, 0x100fe400028e0657ULL,
0x000000012b2b7824ULL, 0x000fe200030e0657ULL, 0x00000000223f7faeULL, 0x0003e8000b901c46ULL,
0x000000002c3d7faeULL, 0x0003e8000b901c46ULL, 0x000000002e377faeULL, 0x0003e8000b901c46ULL,
0x0000000030357faeULL, 0x0003e8000b901c46ULL, 0x0000000024347faeULL, 0x0003e8000b901c46ULL,
0x0000000026337faeULL, 0x0003e8000b901c46ULL, 0x0000000028327faeULL, 0x0003e8000b901c46ULL,
0x000000002a057faeULL, 0x0003e4000b901c46ULL, 0x0000000445457836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff057424ULL, 0x006fc600078e00ffULL,
0x0000003a4500720cULL, 0x000fda0003f06070ULL, 0x00009200ff128b82ULL, 0x000e620000000a00ULL,
0x0000000207158824ULL, 0x000fe400078e0245ULL, 0x0000200010467824ULL, 0x000fe400078e0211ULL,
0x0000002008107836ULL, 0x000fe20000000000ULL, 0xfffffff808117812ULL, 0x040fe400078ec0ffULL,
0x0000000708477812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x00000004ff447819ULL, 0x000fc40000011608ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000415128825ULL, 0x002fe200078e0012ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000612058981ULL, 0x000322000c1e1900ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000100046467836ULL, 0x000fe20000000000ULL, 0x0000000711487812ULL, 0x000fe400078ef808ULL,
0x0000000847497812ULL, 0x000fe400078ef808ULL, 0xfffffff810137812ULL, 0x002fc800078ec0ffULL,
0x0000000713427812ULL, 0x000fce00078ef808ULL, 0x0000000148107824ULL, 0x040fe400078e024bULL,
0x0000000848117824ULL, 0x000fe400078e00ffULL, 0x000000024b767824ULL, 0x000fc600078e0244ULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000000142107824ULL, 0x000fc800078e024bULL,
0x0000001011187824ULL, 0x000fe400078e0246ULL, 0x0000000842117824ULL, 0x000fc800078e00ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff811117812ULL, 0x000fca00078ee210ULL,
0x0000001011117824ULL, 0x000fcc00078e0246ULL, 0x000000001110783bULL, 0x000ea20000000200ULL,
0x00000018ff557819ULL, 0x002fe20000011418ULL, 0x00010000181c7824ULL, 0x040fe200078e00ffULL,
0x0000888018547816ULL, 0x040fe200000000ffULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011419ULL, 0x00010000191d7824ULL, 0x040fe200078e00ffULL,
0x00008880195b7816ULL, 0x040fe200000000ffULL, 0x0000010019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff5d7819ULL, 0x000fc4000001141bULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff667819ULL, 0x004fe40000011410ULL, 0x0000888010687816ULL, 0x000fe200000000ffULL,
0x0000001800627306ULL, 0x0002a20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fe40000011411ULL,
0x00008880116e7816ULL, 0x000fe400000000ffULL, 0x000088801b5f7816ULL, 0x000fc400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001141aULL, 0x0000001900587306ULL, 0x0007e20000200c00ULL,
0x000100001a187824ULL, 0x042fe200078e00ffULL, 0x000088801a597816ULL, 0x040fe200000000ffULL,
0x000001001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011413ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000888013607816ULL, 0x000fe200000000ffULL,
0x000100001b197824ULL, 0x048fe200078e00ffULL, 0x00000018005c7306ULL, 0x0003e20000200c00ULL,
0x000001001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000001900727306ULL, 0x0007e20000200c00ULL, 0x0001000010187824ULL, 0x042fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011412ULL, 0x00008880126c7816ULL, 0x000fc400000000ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0001000011197824ULL, 0x048fe200078e00ffULL,
0x0000001b00707306ULL, 0x0003e20000200c00ULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000010006b7306ULL, 0x0007e20000200c00ULL,
0x000000014b1b7836ULL, 0x002fe20000000000ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x000000024b4b7836ULL, 0x000fe20000000000ULL, 0x0000541062557816ULL, 0x004fc80000000055ULL,
0x0000001100717306ULL, 0x0003e20000200c00ULL, 0x0001000012107824ULL, 0x048fe200078e00ffULL,
0x000000084b00780cULL, 0x000fe20003f05270ULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001d005e7306ULL, 0x0005e20000200c00ULL,
0x0001000013117824ULL, 0x042fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000010013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000010006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff637819ULL, 0x000fe20000011413ULL,
0x0000001049137824ULL, 0x000fe400078e00ffULL, 0x00000008481d7824ULL, 0x004fc800078e00ffULL,
0x0000001a00617306ULL, 0x0005e20000200c00ULL, 0x0000000149107824ULL, 0x142fe200078e0276ULL,
0x0000000249767810ULL, 0x000fc80007ffe076ULL, 0xfffffff013107812ULL, 0x000fe400078ee210ULL,
0x00000012006d7306ULL, 0x000fe20000200c00ULL, 0x00000001481a7824ULL, 0x004fe400078e021bULL,
0x0000001010107824ULL, 0x000fe400078e020dULL, 0x00000001421b7824ULL, 0x000fe200078e021bULL,
0xfffffff81d1d7812ULL, 0x000fe400078ee21aULL, 0x0000001100677306ULL, 0x0003e60000200c00ULL,
0x000000101d1d7824ULL, 0x000fca00078e0246ULL, 0x0000001c00537306ULL, 0x0005e20000200c00ULL,
0x000000001010783bULL, 0x002e6e0000000200ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x000000001d1c783bULL, 0x004eae0000000200ULL, 0x0000001800777306ULL, 0x000be20000200c00ULL,
0x0000541054547816ULL, 0x008fce0000000053ULL, 0x0000001900737306ULL, 0x0007e20000200c00ULL,
0x0000000842187824ULL, 0x020fca00078e00ffULL, 0xfffffff8181b7812ULL, 0x000fe400078ee21bULL,
0x0000005700577306ULL, 0x000f660000200c00ULL, 0x000000101b1b7824ULL, 0x000fca00078e0246ULL,
0x0000005b005b7306ULL, 0x000f620000200c00ULL, 0x000000001b18783bULL, 0x008ee20000000200ULL,
0x00000054103c723cULL, 0x002fec000000183cULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000100001c547824ULL, 0x004fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001141cULL,
0x000088801c627816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000541058557816ULL, 0x020fe20000000057ULL,
0x000100001d587824ULL, 0x000fe200078e00ffULL, 0x0000005400697306ULL, 0x0005e20000200c00ULL,
0x00000018ff4d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff4f7819ULL, 0x000fc4000001141fULL, 0x00000018ff4e7819ULL, 0x000fe2000001141eULL,
0x0000005900597306ULL, 0x000f620000200c00ULL, 0x000054105b547816ULL, 0x004fe4000000005eULL,
0x000088801d5b7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc60000011458ULL, 0x0000001c00657306ULL, 0x0005e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000541034723cULL, 0x000fe20000001834ULL,
0x00000018ff507819ULL, 0x008fca0000011418ULL, 0x0000001d00647306ULL, 0x0003e20000200c00ULL,
0x000100001e1c7824ULL, 0x044fe200078e00ffULL, 0x000088801f557816ULL, 0x000fe400000000ffULL,
0x00000018ff517819ULL, 0x000fe40000011419ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x00005410611d7816ULL, 0x002fe2000000005aULL,
0x000100001f5a7824ULL, 0x040fe200078e00ffULL, 0x000088801e547816ULL, 0x040fe200000000ffULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe2000001141bULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe2000001141aULL,
0x0000005b00577306ULL, 0x000fe20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff5a7819ULL, 0x000fc6000001145aULL,
0x0000001c005b7306ULL, 0x000bf00000200c00ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00005410591c7816ULL, 0x020fe4000000005cULL, 0x00008880185c7816ULL, 0x000fca00000000ffULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x0000001c1030723cULL, 0x000fee0000001830ULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x00010000181c7824ULL, 0x000fe200078e00ffULL,
0x00005410701d7816ULL, 0x004fe2000000005dULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x00008880195d7816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001f005e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff187819ULL, 0x000fce0000011418ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000010491f7824ULL, 0x004fca00078e00ffULL,
0xfffffff01f767812ULL, 0x000fe200078ee276ULL, 0x00010000191f7824ULL, 0x040fe200078e00ffULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000010019197824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011419ULL, 0x0000001c00617306ULL, 0x000be20000200c00ULL,
0x000054106b197816ULL, 0x002fe40000000066ULL, 0x000088801a6b7816ULL, 0x000fca00000000ffULL,
0x0000001e00597306ULL, 0x0003e20000200c00ULL, 0x000054105f1c7816ULL, 0x020fe20000000072ULL,
0x000100001a727824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000018005f7306ULL, 0x0007e20000200c00ULL, 0x00000010761e7824ULL, 0x002fe200078e020dULL,
0x0000001c102c723cULL, 0x000fec000000182cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000541068187816ULL, 0x008fc40000000077ULL, 0x00000018ff687819ULL, 0x000fe4000001141fULL,
0x000000001e1c783bULL, 0x000e660000000200ULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x000000181028723cULL, 0x000fee0000001828ULL, 0x000054106e187816ULL, 0x004fe20000000073ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541071197816ULL, 0x000fce000000006aULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x000000181024723cULL, 0x000fee0000001824ULL,
0x0000006300637306ULL, 0x000f620000200c00ULL, 0x000001001a197824ULL, 0x000fe200078e00ffULL,
0x000054106c187816ULL, 0x008fc8000000006fULL, 0x00000018ff6a7819ULL, 0x000fe40000011419ULL,
0x000054106d197816ULL, 0x000fe20000000056ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000088801b567816ULL, 0x000fca00000000ffULL, 0x000000181020723cULL, 0x000fe40000001820ULL,
0x0000006200627306ULL, 0x000eea0000200c00ULL, 0x0000541060187816ULL, 0x004fe40000000067ULL,
0x0000541063197816ULL, 0x020fe2000000004aULL, 0x000000ffff4a7224ULL, 0x000fe200078e0056ULL,
0x0000004e004e7306ULL, 0x000eaa0000200c00ULL, 0x000000181014723cULL, 0x000fe60000001814ULL,
0x0000004f004f7306ULL, 0x000f680000200c00ULL, 0x000100001b117824ULL, 0x040fe200078e00ffULL,
0x0000541062107816ULL, 0x008fe20000000069ULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000541059597816ULL, 0x004fe2000000004eULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000018ff137819ULL, 0x000fc40000011411ULL, 0x0000541065117816ULL, 0x000fe4000000004cULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x000054105e4f7816ULL, 0x020fe2000000004fULL,
0x0000005800587306ULL, 0x000ee40000200c00ULL, 0x000000101c3c723cULL, 0x002fe2000000183cULL,
0x000054105f5f7816ULL, 0x004fca0000000050ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x00005410574c7816ULL, 0x008fce0000000058ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00005410644d7816ULL, 0x002fce000000004dULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x0000004c1c34723cULL, 0x000fee0000001834ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000541054587816ULL, 0x002fce000000005bULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000000581c30723cULL, 0x000fee0000001830ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x00005410554e7816ULL, 0x002fce000000005aULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000004e1c2c723cULL, 0x000fe2000000182cULL, 0x000054105c5e7816ULL, 0x004fcc0000000061ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000005e1c28723cULL, 0x000fee0000001828ULL,
0x0000007000667306ULL, 0x000ea20000200c00ULL, 0x000054105d507816ULL, 0x002fce0000000068ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541066517816ULL, 0x004fce0000000051ULL,
0x00000072001a7306ULL, 0x000e620000200c00ULL, 0x000000501c24723cULL, 0x000fee0000001824ULL,
0x0000006a006d7306ULL, 0x000fe20000200c00ULL, 0x000054106b1a7816ULL, 0x002fce000000001aULL,
0x0000004a00127306ULL, 0x000ff00000200c00ULL, 0x0000001300117306ULL, 0x000e700000200c00ULL,
0x0000001b00107306ULL, 0x0004e20000200c00ULL, 0x0000541012127816ULL, 0x002fc40000000011ULL,
0x000054106d1b7816ULL, 0x004fe40000000052ULL, 0x0000541010137816ULL, 0x008fca0000000053ULL,
0x0000001a1c20723cULL, 0x000fec0000001820ULL, 0x000000121c14723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000093c137220ULL, 0x080fe20000410000ULL,
0x00000009283c7220ULL, 0x080fe20000410000ULL, 0x0000000924427220ULL, 0x080fe20000410000ULL,
0x0000000925447220ULL, 0x080fe20000410000ULL, 0x0000000927287220ULL, 0x080fe20000410000ULL,
0x017688100b1079a7ULL, 0x000262000850003fULL, 0x0000000922247220ULL, 0x080fe20000410000ULL,
0x0000000923257220ULL, 0x080fe20000410000ULL, 0x000000093d3d7220ULL, 0x080fe20000410000ULL,
0x000000093e3e7220ULL, 0x080fe20000410000ULL, 0x000000093f3f7220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000936367220ULL, 0x080fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000930127220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c1a7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x0000000914227220ULL, 0x080fe20000410000ULL, 0x0000000915237220ULL, 0x080fe20000410000ULL,
0x00000009161b7220ULL, 0x080fe20000410000ULL, 0x0000000917277220ULL, 0x002fce0000410000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x017688110b0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614197210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001916167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x017688110b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000408107824ULL, 0x000fe200078e00ffULL, 0x000000064300720cULL, 0x000fe20003f06070ULL,
0x0000008040117824ULL, 0x000fc600078e020dULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000000111307824ULL, 0x000fca00078e0210ULL, 0x01740000301c7984ULL, 0x0002a20000000c00ULL,
0x0000001400248947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000000400157d06ULL, 0x000ee20008209000ULL,
0x00000100432c7824ULL, 0x000fe200078e0204ULL, 0x00000004ff007c0cULL, 0x000fe2000bf85070ULL,
0x0000000208497824ULL, 0x000fe200078e00ffULL, 0x00000004ff187c12ULL, 0x000fc8000f8e33ffULL,
0x0000000649497812ULL, 0x000fca00078ec0ffULL, 0x00000001494b7824ULL, 0x000fe200078e0200ULL,
0x0000001500157308ULL, 0x008ee40000001000ULL, 0x0ffffffe15167836ULL, 0x008fcc0000000000ULL,
0x0000001600117305ULL, 0x000ee4000021f000ULL, 0x000000ffff177224ULL, 0x008fc800078e0a11ULL,
0x0000000417177c24ULL, 0x000fc8000f8e02ffULL, 0x0000001711177227ULL, 0x000fe200078e0010ULL,
0x0000004108107211ULL, 0x000fca00078ff0ffULL, 0x0000001017147227ULL, 0x000fc800078e00ffULL,
0x000000ffff117224ULL, 0x000fc800078e0a14ULL, 0x0000000411117c24ULL, 0x000fe4000f8e0210ULL,
0x0000000810107836ULL, 0x000fc60000000000ULL, 0x0000000411007c0cULL, 0x000fe2000bf06070ULL,
0x0000001017177227ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fc800078e0a17ULL,
0x0000000415107c24ULL, 0x000fe4000f8e0210ULL, 0x000000010e157824ULL, 0x000fe400078e0249ULL,
0x8000000411110c36ULL, 0x000fe20008000000ULL, 0x0000000410007c0cULL, 0x000fe2000bf46070ULL,
0x0000000114140836ULL, 0x000fc60000000000ULL, 0x0000000411007c0cULL, 0x000fe4000bf26070ULL,
0x0000002c3b117248ULL, 0x000fca0007fe0000ULL, 0x00000001112c7824ULL, 0x000fe400078e0a2cULL,
0x8000000410102c36ULL, 0x000fe40008000000ULL, 0x000000ffff637224ULL, 0x000fe200078e0a2cULL,
0x0000002c1500720cULL, 0x000fe20003f66070ULL, 0x0000000114141836ULL, 0x000fe20000000000ULL,
0x0000000410007c0cULL, 0x000fe2000bf06070ULL, 0x0000000117172836ULL, 0x000fe20000000000ULL,
0x0000006315157246ULL, 0x000fe4000380000cULL, 0x0000001418117207ULL, 0x000fc40006000000ULL,
0x00000004ff157819ULL, 0x000fe40000011615ULL, 0x000000110c117248ULL, 0x000fe40003fe0000ULL,
0x000000ff15167207ULL, 0x000fe40001800000ULL, 0x0000002c4b00720cULL, 0x000fe20003f26070ULL,
0x0000000511657c24ULL, 0x000fe2000f8e02ffULL, 0x000000634b527246ULL, 0x000fe2000380000cULL,
0x0000000117170836ULL, 0x000fe40000000000ULL, 0x0000000165117824ULL, 0x000fe200078e0216ULL,
0x000000ff52527207ULL, 0x000fc40000800000ULL, 0x00000010494d7812ULL, 0x000fe200078efcffULL,
0x0000000211107825ULL, 0x100fe200078e0074ULL, 0x0000006552157211ULL, 0x000fe400078fe0ffULL,
0x0000001718177207ULL, 0x000fe40006000000ULL, 0x0000000610567981ULL, 0x0044e2000c1e9500ULL,
0x0000000215147825ULL, 0x000fe200078e0074ULL, 0x000000170c177248ULL, 0x000fc80003fe0000ULL,
0x0000000614617981ULL, 0x000ae2000c1e9500ULL, 0x000000010e117824ULL, 0x004fca00078e024dULL,
0x0000006311107246ULL, 0x000fe4000380000cULL, 0x0000002c1100720cULL, 0x000fe40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000517677c24ULL, 0x000fe2000f8e02ffULL,
0x0000002049537812ULL, 0x000fe400078efcffULL, 0x000000ff104a7207ULL, 0x000fe20000800000ULL,
0x000000014d4f7824ULL, 0x000fe200078e0200ULL, 0x0000006752197211ULL, 0x000fe200078fe0ffULL,
0x0000000116177824ULL, 0x000fc400078e0267ULL, 0x0000000165117824ULL, 0x000fe400078e024aULL,
0x000000010e577824ULL, 0x000fe200078e0253ULL, 0x0000002c4f00720cULL, 0x000fe20003f06070ULL,
0x0000000211107825ULL, 0x100fe200078e0074ULL, 0x000000634f467246ULL, 0x000fe4000380000cULL,
0x00000063574c7246ULL, 0x000fe2000380000cULL, 0x0000000217167825ULL, 0x000fc800078e0074ULL,
0x0000000219187825ULL, 0x000fe200078e0074ULL, 0x000000ff46467207ULL, 0x000fe20000000000ULL,
0x0000000610487981ULL, 0x0004e2000c1e9500ULL, 0x0000002c5700720cULL, 0x000fc60003f26070ULL,
0x0000000616547981ULL, 0x0004e2000c1e9500ULL, 0x0000006546157211ULL, 0x022fc600078fe0ffULL,
0x0000000618697981ULL, 0x000362000c1e9500ULL, 0x00000004ff107819ULL, 0x004fe2000001164cULL,
0x0000000153557824ULL, 0x000fe200078e0200ULL, 0x0000003049597812ULL, 0x000fe200078efcffULL,
0x000000014a177824ULL, 0x000fe200078e0267ULL, 0x000000ff10507207ULL, 0x000fe40000800000ULL,
0x0000006746197211ULL, 0x002fe200078fe0ffULL, 0x0000000215147825ULL, 0x100fe200078e0074ULL,
0x0000002c5500720cULL, 0x000fe40003f06070ULL, 0x00000063554c7246ULL, 0x000fe2000380000cULL,
0x0000000217167825ULL, 0x100fe200078e0074ULL, 0x0000000614517981ULL, 0x0002a6000c1e9500ULL,
0x0000000219187825ULL, 0x000fe200078e0074ULL, 0x000000ff4c4c7207ULL, 0x000fe20000000000ULL,
0x00000006164a7981ULL, 0x0002a4000c1e9500ULL, 0x0000000165117824ULL, 0x000fc400078e0250ULL,
0x000000010e6b7824ULL, 0x000fe200078e0259ULL, 0x0000000618577981ULL, 0x0002a2000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0074ULL, 0x000000654c157211ULL, 0x002fe400078fe0ffULL,
0x000000636b587246ULL, 0x000fe2000380000cULL, 0x00000001595d7824ULL, 0x000fe200078e0200ULL,
0x00000006104e7981ULL, 0x0002a2000c1e9500ULL, 0x0000000150177824ULL, 0x000fe200078e0267ULL,
0x000000674c197211ULL, 0x000fe200078fe0ffULL, 0x0000000215147825ULL, 0x000fe200078e0074ULL,
0x0000002c6b00720cULL, 0x000fc40003f26070ULL, 0x0000002c5d00720cULL, 0x000fe40003f06070ULL,
0x00000004ff107819ULL, 0x002fe20000011658ULL, 0x0000000217167825ULL, 0x100fe200078e0074ULL,
0x000000635d587246ULL, 0x000fe2000380000cULL, 0x00000006145b7981ULL, 0x0002a4000c1e9500ULL,
0x0000000219187825ULL, 0x000fe200078e0074ULL, 0x000000ff105a7207ULL, 0x000fe20000800000ULL,
0x0000000616507981ULL, 0x0002a2000c1e9500ULL, 0x000000ff58587207ULL, 0x000fc60000000000ULL,
0x00000006185f7981ULL, 0x0002a2000c1e9500ULL, 0x0000000165117824ULL, 0x000fe200078e025aULL,
0x0000006558157211ULL, 0x002fc600078fe0ffULL, 0x0000000211107825ULL, 0x000fc800078e0074ULL,
0x0000000215147825ULL, 0x000fe400078e0074ULL, 0x0000000610107981ULL, 0x0002a2000c1e9500ULL,
0x0000006758177211ULL, 0x000fc600078fe0ffULL, 0x0000000614157981ULL, 0x000ea2000c1e9500ULL,
0x000000015a197824ULL, 0x000fe400078e0267ULL, 0x0000000217167825ULL, 0x000fc800078e0074ULL,
0x0000000219187825ULL, 0x000fe400078e0074ULL, 0x0000000616167981ULL, 0x000ea8000c1e9500ULL,
0x0000000618197981ULL, 0x0002a2000c1e9500ULL, 0xfffffff052637812ULL, 0x000fe400078ec0ffULL,
0x0000000149117812ULL, 0x002fc600078efcffULL, 0x000000012c5a7824ULL, 0x000fe200078e0263ULL,
0x0000000949637812ULL, 0x000fe200078efcffULL, 0x00000001ff527424ULL, 0x000fe400078e00ffULL,
0x000000014b6b7824ULL, 0x000fe400078e0a5aULL, 0x0000000111657824ULL, 0x100fe400078e0200ULL,
0x0000000163677824ULL, 0x000fe200078e0200ULL, 0x0000006b526b7219ULL, 0x000fe200000006ffULL,
0x00000001656d7824ULL, 0x000fc400078e0a5aULL, 0x0000000167717824ULL, 0x000fc600078e0a5aULL,
0x0000006d526d7219ULL, 0x040fe400000006ffULL, 0x0000007152717219ULL, 0x000fe400000006ffULL,
0x00000018497b7812ULL, 0x000fca00078efcffULL, 0x000000017b187824ULL, 0x000fe200078e0200ULL,
0x00000011497d7812ULL, 0x040fe400078efcffULL, 0x0000001949797812ULL, 0x000fca00078efcffULL,
0x0000000179147824ULL, 0x000fe200078e0200ULL, 0x0000002149737812ULL, 0x000fe400078efcffULL,
0xfffffff058587812ULL, 0x000fc600078ec0ffULL, 0x0000000173777824ULL, 0x000fe400078e0200ULL,
0x000000012c607824ULL, 0x000fc800078e0258ULL, 0x000000015d6c7824ULL, 0x000fca00078e0a60ULL,
0x0000006c526c7219ULL, 0x000fe400000006ffULL, 0x0000541061567816ULL, 0x008fe40000000056ULL,
0x0000000849617812ULL, 0x000fca00078efcffULL, 0x0000000161177824ULL, 0x000fe200078e0200ULL,
0x000000566bff7212ULL, 0x000fc6000780c0ffULL, 0x00000001176f7824ULL, 0x000fe200078e0a5aULL,
0x0000002c4b00720cULL, 0x000fc80000701470ULL, 0x0000006f526f7219ULL, 0x000fe400000006ffULL,
0x000000566dff7212ULL, 0x080fe4000782c0ffULL, 0x000000566fff7212ULL, 0x080fe4000786c0ffULL,
0x0000005671ff7212ULL, 0x000fe4000788c0ffULL, 0x0000002c4900720cULL, 0x000fe400007a1070ULL,
0xfffffff046567812ULL, 0x000fc400078ec0ffULL, 0xff80000013137808ULL, 0x000fc60002800000ULL,
0x000000012c567824ULL, 0x000fc800078e0256ULL, 0x000000014f627824ULL, 0x000fe200078e0a56ULL,
0x0000541069547816ULL, 0x020fc80000000054ULL, 0x000000546bff7212ULL, 0x080fe4000784c0ffULL,
0x000000546fff7212ULL, 0x080fe400078cc0ffULL, 0x0000005471ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000118667824ULL, 0x000fe200078e0a56ULL, 0x0000002c4b00720cULL, 0x080fe40001741470ULL,
0x0000002c1700720cULL, 0x080fe400037c1470ULL, 0x0000002c6700720cULL, 0x000fc40002fa1470ULL,
0xfffffff04c5a7812ULL, 0x000fe400078ec0ffULL, 0x0000002c4900720cULL, 0x080fe40001741070ULL,
0x0000002c6100720cULL, 0x080fe400037c1070ULL, 0x0000002c6300720cULL, 0x000fe40002fa1070ULL,
0x0000006252627219ULL, 0x040fe400000006ffULL, 0x0000006652667219ULL, 0x000fc400000006ffULL,
0x0000541051517816ULL, 0x004fe40000000048ULL, 0x0000541057577816ULL, 0x000fe2000000004aULL,
0x000000012c5a7824ULL, 0x000fe200078e025aULL, 0x000000546dff7212ULL, 0x000fe2000780c0ffULL,
0x000000017d547824ULL, 0x000fe200078e0200ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fc40002800000ULL,
0x0000005162ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005762ff7212ULL, 0x080fe400078cc0ffULL,
0x0000005766ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000154647824ULL, 0x100fe200078e0a56ULL,
0x0000002c6500720cULL, 0x0c0fe20000f21470ULL, 0x0000000114687824ULL, 0x000fe200078e0a56ULL,
0x0000002c6500720cULL, 0x080fe20000701470ULL, 0x00000001556a7824ULL, 0x000fe200078e0a5aULL,
0x0000002c1700720cULL, 0x000fc40001f61470ULL, 0x0000002c6700720cULL, 0x080fe40002781470ULL,
0x0000002c4f00720cULL, 0x0c0fe40001741470ULL, 0x0000002c4f00720cULL, 0x080fe400037c1470ULL,
0x0000002c1800720cULL, 0x000fe40002fa1470ULL, 0x0000002849717812ULL, 0x040fe400078efcffULL,
0x00000029496f7812ULL, 0x000fc400078efcffULL, 0x0000002c1100720cULL, 0x0c0fe40000f21070ULL,
0x0000002c1100720cULL, 0x080fe40000701070ULL, 0x0000002c6100720cULL, 0x080fe40001f61070ULL,
0x0000002c6300720cULL, 0x080fe40002781070ULL, 0x0000002c4d00720cULL, 0x0c0fe40001741070ULL,
0x0000002c4d00720cULL, 0x000fc400037c1070ULL, 0x0000002c7b00720cULL, 0x000fe40002fa1070ULL,
0x0000006452647219ULL, 0x040fe400000006ffULL, 0x0000006852687219ULL, 0x040fe400000006ffULL,
0x0000006a526a7219ULL, 0x000fe400000006ffULL, 0x000054105b5b7816ULL, 0x000fe4000000004eULL,
0x000054105f5f7816ULL, 0x000fe20000000050ULL, 0x0000000171467824ULL, 0x100fe200078e0200ULL,
0xff8000003d3d7808ULL, 0x000fe20000800000ULL, 0x000000016f4c7824ULL, 0x000fe200078e0200ULL,
0xff8000003f3f7808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000012127808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000005164ff7212ULL, 0x000fc4000782c0ffULL, 0x0000005166ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005168ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005764ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005768ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005b6aff7212ULL, 0x040fe400078cc0ffULL,
0x0000005f6aff7212ULL, 0x000fe200078ac0ffULL, 0x0000000177707824ULL, 0x100fe200078e0a5aULL,
0x0000002c5400720cULL, 0x080fe20000f21470ULL, 0x0000000146727824ULL, 0x100fe200078e0a5aULL,
0x0000002c5400720cULL, 0x080fe20002781470ULL, 0x000000014c6e7824ULL, 0x000fe200078e0a5aULL,
0x0000002c1800720cULL, 0x000fc40000701470ULL, 0x0000002c1400720cULL, 0x0c0fe40001f61470ULL,
0x0000002c1400720cULL, 0x080fe40001741470ULL, 0x0000002c5500720cULL, 0x0c0fe400037c1470ULL,
0x0000002c5500720cULL, 0x000fe40002fa1470ULL, 0x00000031496d7812ULL, 0x040fe400078efcffULL,
0x00000038496b7812ULL, 0x000fc400078efcffULL, 0x0000003949697812ULL, 0x000fe400078efcffULL,
0x0000002c7d00720cULL, 0x0c0fe40000f21070ULL, 0x0000002c7d00720cULL, 0x080fe40002781070ULL,
0x0000002c7b00720cULL, 0x080fe40000701070ULL, 0x0000002c7900720cULL, 0x0c0fe40001f61070ULL,
0x0000002c7900720cULL, 0x000fc40001741070ULL, 0x0000002c5300720cULL, 0x0c0fe400037c1070ULL,
0x0000002c5300720cULL, 0x000fe40002fa1070ULL, 0x0000007052707219ULL, 0x040fe400000006ffULL,
0x0000007252727219ULL, 0x040fe400000006ffULL, 0x0000006e526e7219ULL, 0x000fe400000006ffULL,
0x0000541015157816ULL, 0x000fe20000000010ULL, 0x000000016d567824ULL, 0x100fe200078e0200ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x000000016b587824ULL, 0x100fe200078e0200ULL,
0xff80000033337808ULL, 0x000fe20002000000ULL, 0x00000001695a7824ULL, 0x000fe200078e0200ULL,
0xff8000001a1a7808ULL, 0x000fc40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff8000003c3c7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000005b70ff7212ULL, 0x080fe4000782c0ffULL,
0x0000005b72ff7212ULL, 0x000fc4000788c0ffULL, 0x0000005b6eff7212ULL, 0x000fe4000780c0ffULL,
0x0000005f70ff7212ULL, 0x080fe4000786c0ffULL, 0x0000005f72ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005f6eff7212ULL, 0x000fe400078cc0ffULL, 0x000000156cff7212ULL, 0x000fe200078ac0ffULL,
0x00000001565c7824ULL, 0x100fe200078e0a60ULL, 0x0000002c7700720cULL, 0x0c0fe20000f21470ULL,
0x00000001585e7824ULL, 0x100fe200078e0a60ULL, 0x0000002c7700720cULL, 0x080fe20001f61470ULL,
0x000000015a607824ULL, 0x000fe200078e0a60ULL, 0x0000002c4600720cULL, 0x000fc40002781470ULL,
0x0000002c4600720cULL, 0x080fe40001741470ULL, 0x0000002c4c00720cULL, 0x0c0fe40000701470ULL,
0x0000002c4c00720cULL, 0x080fe400037c1470ULL, 0x0000002c5d00720cULL, 0x080fe40002fa1470ULL,
0x0000002c7300720cULL, 0x0c0fe40000f21070ULL, 0x0000002c7300720cULL, 0x000fc40001f61070ULL,
0x0000002c7100720cULL, 0x0c0fe40002781070ULL, 0x0000002c7100720cULL, 0x080fe40001741070ULL,
0x0000002c6f00720cULL, 0x0c0fe40000701070ULL, 0x0000002c6f00720cULL, 0x080fe400037c1070ULL,
0x0000002c5900720cULL, 0x000fe40002fa1070ULL, 0x0000005c525c7219ULL, 0x000fc400000006ffULL,
0x0000005e525e7219ULL, 0x040fe400000006ffULL, 0x0000006052607219ULL, 0x000fe400000006ffULL,
0x0000541016197816ULL, 0x000fe40000000019ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fc40002000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000028287808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x000000155cff7212ULL, 0x080fe4000782c0ffULL, 0x000000155eff7212ULL, 0x000fc4000786c0ffULL,
0x0000001560ff7212ULL, 0x000fe4000788c0ffULL, 0x000000196cff7212ULL, 0x080fe4000784c0ffULL,
0x000000195cff7212ULL, 0x080fe4000780c0ffULL, 0x000000195eff7212ULL, 0x080fe400078cc0ffULL,
0x0000001960ff7212ULL, 0x000fe400078ac0ffULL, 0x0000002c5d00720cULL, 0x000fc40001741470ULL,
0x0000002c5600720cULL, 0x0c0fe40000f21470ULL, 0x0000002c5600720cULL, 0x080fe40000701470ULL,
0x0000002c5800720cULL, 0x0c0fe40001f61470ULL, 0x0000002c5800720cULL, 0x080fe400037c1470ULL,
0x0000002c5a00720cULL, 0x0c0fe40002781470ULL, 0x0000002c5a00720cULL, 0x000fc40002fa1470ULL,
0x0000002c5900720cULL, 0x080fe40001741070ULL, 0x0000002c6d00720cULL, 0x0c0fe40000f21070ULL,
0x0000002c6d00720cULL, 0x080fe40000701070ULL, 0x0000002c6b00720cULL, 0x0c0fe40001f61070ULL,
0x0000002c6b00720cULL, 0x080fe400037c1070ULL, 0x0000002c6900720cULL, 0x000fc40002781070ULL,
0x0000002c6900720cULL, 0x000fe40002fa1070ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fc40000000000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff80000027277808ULL, 0x000fce0002800000ULL,
0x000000131c00720bULL, 0x004fe20003f1e000ULL, 0x0000000143437836ULL, 0x000fe20000000000ULL,
0xfffffff8ff477812ULL, 0x000fe400078ee247ULL, 0x0000001c131c7208ULL, 0x000fc80004000000ULL,
0x0000003d1c00720bULL, 0x000fc80003f1e000ULL, 0x0000001c3d117208ULL, 0x000fc80004000000ULL,
0x000000341100720bULL, 0x000fc80003f1e000ULL, 0x0000001134107208ULL, 0x000fc80004000000ULL,
0x000000351000720bULL, 0x000fc80003f1e000ULL, 0x0000001035117208ULL, 0x000fc80004000000ULL,
0x000000121100720bULL, 0x000fc80003f1e000ULL, 0x0000001112107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x0000001031117208ULL, 0x000fc80004000000ULL,
0x0000001a1100720bULL, 0x000fc80003f1e000ULL, 0x000000111a107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d117208ULL, 0x000fc80004000000ULL,
0x0000003c1100720bULL, 0x000fc80003f1e000ULL, 0x000000113c107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029117208ULL, 0x000fc80004000000ULL,
0x000000421100720bULL, 0x000fc80003f1e000ULL, 0x0000001142117208ULL, 0x000fe40004000000ULL,
0x0000003e1d00720bULL, 0x000fe40003f1e000ULL, 0x000000441100720bULL, 0x000fe40003f3e000ULL,
0x0000001d3e107208ULL, 0x000fe40004000000ULL, 0x0000001144117208ULL, 0x000fe40004800000ULL,
0x0000003f1000720bULL, 0x000fc40003f1e000ULL, 0x000000201100720bULL, 0x000fc80003f3e000ULL,
0x0000001120147208ULL, 0x000fe40004800000ULL, 0x000000103f117208ULL, 0x000fe40004000000ULL,
0x000000211400720bULL, 0x000fe40003f3e000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x0000001421157208ULL, 0x000fe40004800000ULL, 0x0000001136107208ULL, 0x000fc40004000000ULL,
0x000000221500720bULL, 0x000fe40003f3e000ULL, 0x000000371000720bULL, 0x000fe40003f1e000ULL,
0x0000001522147208ULL, 0x000fe40004800000ULL, 0x0000001037117208ULL, 0x000fe40004000000ULL,
0x000000231400720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fc40003f1e000ULL,
0x0000001423147208ULL, 0x000fe40004800000ULL, 0x0000001132107208ULL, 0x000fc60004000000ULL,
0x0c401f0014157f89ULL, 0x000ea200000e0000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x0000001033117208ULL, 0x000fc80004000000ULL, 0x0000002e1100720bULL, 0x000fc80003f1e000ULL,
0x000000112e107208ULL, 0x000fc80004000000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f117208ULL, 0x000fe40004000000ULL, 0x000000151400720bULL, 0x004fe40003f3e000ULL,
0x0000002a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001415157208ULL, 0x000fe40004800000ULL,
0x000000112a107208ULL, 0x000fc60004000000ULL, 0x0c201f00152c7f89ULL, 0x000ea200000e0000ULL,
0x0000002b1000720bULL, 0x000fc80003f1e000ULL, 0x000000102b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126117208ULL, 0x000fc80004000000ULL,
0x000000281100720bULL, 0x000fc80003f1e000ULL, 0x0000001128117208ULL, 0x000fe40004000000ULL,
0x0000002c1500720bULL, 0x004fe40003f3e000ULL, 0x000000241100720bULL, 0x000fe40003f1e000ULL,
0x000000152c2c7208ULL, 0x000fe40004800000ULL, 0x0000001124107208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL, 0x000000251000720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b2d1c7823ULL, 0x100fe20000010814ULL, 0x0000001025107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010814ULL, 0x0000001b1000720bULL, 0x000fe20003f1e000ULL,
0x0000003500467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010814ULL, 0x000000101b107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b29197823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010814ULL, 0x000000271000720bULL, 0x000fe20003f1e000ULL,
0x0000003400157308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b3c187823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010814ULL, 0x0000001027107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b21297823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b221d7823ULL, 0x000fc60000010814ULL,
0x0c401f0010117f89ULL, 0x000f6200000e0000ULL, 0x0000003100487308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b23347823ULL, 0x004fce0000010814ULL, 0x0000001c004a7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b44317823ULL, 0x008fce0000010814ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b201c7823ULL, 0x004fe20000010814ULL, 0x000000111000720bULL, 0x022fcc0003f1e000ULL,
0x0000003d00167308ULL, 0x000e620000000800ULL, 0x0000001011107208ULL, 0x000fca0004000000ULL,
0x0c201f00102d7f89ULL, 0x000ea400000e0000ULL, 0x0000001200177308ULL, 0x0007f00000000800ULL,
0x0000001a003d7308ULL, 0x000f620000000800ULL, 0x000000154612723eULL, 0x008fce00000000ffULL,
0x00000042001a7308ULL, 0x0007e20000000800ULL, 0x0000002d1000720bULL, 0x004fce0003f1e000ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000102d2d7208ULL, 0x000fe40004000000ULL,
0x000000131610723eULL, 0x002fe400000000ffULL, 0x0000003d4a16723eULL, 0x020fe200000000ffULL,
0x3fb8aa3b2d357820ULL, 0x000fe40000410000ULL, 0x0000001900197308ULL, 0x000e640000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2e207823ULL, 0x100fe20000010835ULL, 0x3c003c00ff2e7424ULL, 0x000fe200078e00ffULL,
0x0000003e00117308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b26427823ULL, 0x108fe20000010835ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL,
0x0c401f001f267f89ULL, 0x000ee200000e0000ULL, 0x000000181918723eULL, 0x002fe200000000ffULL,
0x0000003f00147308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2f3e7823ULL, 0x004fe20000010835ULL,
0x3c003c00ff2f7424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b27277823ULL, 0x000fe40000010835ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000111411723eULL, 0x002fce00000000ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000174814723eULL, 0x000fe400000000ffULL,
0x000000261f00720bULL, 0x008fca0003f3e000ULL, 0x00000020003c7308ULL, 0x0005e20000000800ULL,
0x000000363713723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b367823ULL, 0x000fe40000010835ULL, 0x0c401f001e2b7f89ULL, 0x000e6200000e0000ULL,
0x0000002e1020723cULL, 0x004fe800000018ffULL, 0x0000003300337308ULL, 0x000eb00000000800ULL,
0x0000003e003f7308ULL, 0x000ee20000000800ULL, 0x000000323315723eULL, 0x004fce00000000ffULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000001f26327208ULL, 0x000fe20004800000ULL,
0x0000000847267824ULL, 0x000fe200078e00ffULL, 0x0000002b1e00720bULL, 0x002fe40003f1e000ULL,
0x0000003c3f17723eULL, 0x008fc600000000ffULL, 0x0000002a002a7308ULL, 0x000fe80000000800ULL,
0x0000002e1420723cULL, 0x000fe20000001820ULL, 0x0000001a311a723eULL, 0x004fc600000000ffULL,
0x0000003600377308ULL, 0x0002a20000000800ULL, 0x0000001e2b317208ULL, 0x000fce0004000000ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b367823ULL, 0x002fe20000010835ULL,
0x0000002a3719723eULL, 0x004fcc00000000ffULL, 0x0000002800337308ULL, 0x000e700000000800ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x00000042331b723eULL, 0x002fce00000000ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x0c201f0032337f89ULL, 0x000ea200000e0000ULL,
0x0000002e1820723cULL, 0x000fec0000001820ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000001d341e723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x0c201f0031347f89ULL, 0x000eee00000e0000ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000333200720bULL, 0x004fe40003f3e000ULL, 0x0000001c291c723eULL, 0x002fca00000000ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x0000000847297824ULL, 0x000fe400078e00ffULL,
0x000000ffff2a7224ULL, 0x000fca00078e001cULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000343100720bULL, 0x008fe40003f1e000ULL, 0x00000024251d723eULL, 0x002fca00000000ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000003ff247819ULL, 0x000fe20000011608ULL,
0x0000080040257824ULL, 0x000fc600078e020dULL, 0x0000000324247812ULL, 0x000fe200078ec0ffULL,
0x0001100025357836ULL, 0x000fe40000000000ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff127224ULL, 0x000fe400078e0015ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x00000036271f723eULL, 0x002fe200000000ffULL, 0x0000000847277836ULL, 0x000fe40000000000ULL,
0x0000000124477824ULL, 0x000fc400078e0247ULL, 0x0000000124287824ULL, 0x000fe400078e0227ULL,
0x0000002e1c20723cULL, 0x000fe20000001820ULL, 0xfffffff826247812ULL, 0x000fe200078ee247ULL,
0x0000000447267836ULL, 0x000fe40000000000ULL, 0x00000008272b7824ULL, 0x040fe400078e00ffULL,
0x00000008273c7824ULL, 0x000fe200078e00ffULL, 0xfffffff829267812ULL, 0x000fe200078ee226ULL,
0x0000000c47477836ULL, 0x000fe20000000000ULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x000000ffff277224ULL, 0x000fe200078e0016ULL, 0x00000031342e7208ULL, 0x000fe20004000000ULL,
0x000000ffff297224ULL, 0x000fe200078e001aULL, 0x0000000308ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001028367824ULL, 0x000fe200078e0235ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee247ULL,
0x000000ffff287224ULL, 0x000fe200078e0018ULL, 0x00000032332f7208ULL, 0x000fe20004800000ULL,
0x000000ffff2b7224ULL, 0x000fc400078e001eULL, 0x0000001024217824ULL, 0x100fe400078e0235ULL,
0x0000001026237824ULL, 0x000fe400078e0235ULL, 0x000000ffff247224ULL, 0x000fe400078e0010ULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x0000002421007844ULL, 0x0003e20000000200ULL,
0x000000ffff137224ULL, 0x000fc400078e0017ULL, 0x000000103c3c7824ULL, 0x000fe200078e0235ULL,
0x0000002823007844ULL, 0x000fe20000000200ULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff167224ULL, 0x000fe200078e001dULL, 0x0000001036007844ULL, 0x0005e20000000200ULL,
0x000000ffff177224ULL, 0x000fe400078e001fULL, 0x00000001ff187424ULL, 0x000fc600078e00ffULL,
0x000000143c007844ULL, 0x0007e20000000200ULL, 0x000000ffff217224ULL, 0x002fc600078e0022ULL,
0x0170002c30008388ULL, 0x0007e80000000c00ULL, 0x0172002030008388ULL, 0x0007e20000000a00ULL,
0x000000394300720cULL, 0x000fe20003f06070ULL, 0x017608180fff79a7ULL, 0x0007e2000850003fULL,
0x000000ffff107224ULL, 0x004fe200078e0038ULL, 0x017610180fff79a7ULL, 0x0007e2000850003fULL,
0x017618180fff79a7ULL, 0x0007e2000850003fULL, 0x017620180fff79a7ULL, 0x0007f0000850003fULL,
0xffffffac00988947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005400008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff54ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000054027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffecc02987950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006f8ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000950ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a30ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a84ULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001140ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000013280ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014400ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014450ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000014450ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014a48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014a48ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013280ULL, 0x0000000000013280ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014400ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014450ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 84888;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
