/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015250ULL, 0x0000000000014ed0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x00000000000132e0ULL,
0x0000000000000190ULL, 0x000b0022000004d2ULL, 0x0000000000013470ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x00000000000134b0ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000013500ULL, 0x0000000000000100ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000013600ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000132e000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x004b240400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080860828ULL, 0x2880808b08288080ULL,
0x808f082880808d08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL, 0x9908288080980828ULL,
0x288080a108288080ULL, 0x808508288080b308ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080859200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000132e000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808085ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080860828ULL,
0x2880808c08288080ULL, 0x808f082880808d08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL,
0x9908288080980828ULL, 0x288080a108288080ULL, 0x808808288080b308ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080889200ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL,
0x0001347000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080860828ULL, 0x2880808b08288080ULL, 0x808f082880808d08ULL,
0x0828808093082880ULL, 0x8080980828808094ULL, 0xa108288080990828ULL, 0x288080b308288080ULL,
0x8280162880809508ULL, 0x0000000003102880ULL, 0x8080959200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x000001e800000000ULL, 0x000134b000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8094288080950900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080860828ULL, 0x2880808d08288080ULL, 0x8093082880808f08ULL,
0x0828808095082880ULL, 0x8080990828808098ULL, 0xb308288080a10828ULL, 0x2880809408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808094ULL, 0x0000001cffffffffULL,
0x000002a800000000ULL, 0x0001350000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL,
0x0021f0000060000aULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL,
0x0011f00000500008ULL, 0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL,
0x0021f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL,
0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL,
0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000b70ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000003b000000300ULL, 0x000028f0000005a0ULL,
0x00002ab000002990ULL, 0x000030a000002c10ULL, 0x00003120000030d0ULL, 0x0000513000003170ULL,
0x000052f0000051c0ULL, 0x000058e000005450ULL, 0x0000596000005910ULL, 0x00007720000059b0ULL,
0x000078f0000077c0ULL, 0x00007ee000007a50ULL, 0x00007f6000007f10ULL, 0x00009db000007fb0ULL,
0x00009f8000009e50ULL, 0x0000a5700000a0e0ULL, 0x0000a5f00000a5a0ULL, 0x0000b8700000a640ULL,
0x00011be00000b880ULL, 0x00011c3000011c20ULL, 0x00011c5000011c40ULL, 0x00011cd000011cb0ULL,
0x0001292000011cf0ULL, 0x000129b000012960ULL, 0x00012a40000129f0ULL, 0x00012ae000012a90ULL,
0x00012b7000012b20ULL, 0x00012c0000012bb0ULL, 0x00012ca000012c50ULL, 0x00012d3000012ce0ULL,
0x00012dc000012d70ULL, 0x00012e6000012e10ULL, 0x00012ef000012ea0ULL, 0x00012f8000012f30ULL,
0x0001302000012fd0ULL, 0x000130e000013080ULL, 0x000131a000013140ULL, 0x0001326000013200ULL,
0x04403904000132c0ULL, 0x000000ff00000410ULL, 0x003f01000000f600ULL, 0x0000001100000450ULL,
0x003f01200000f608ULL, 0x00000011000004e0ULL, 0x003f01200000f688ULL, 0x0000001100000510ULL,
0x003f01200000f6a8ULL, 0x0000001100000530ULL, 0x003f01200000f6c8ULL, 0x000000ff00000b90ULL,
0x003f01070000f600ULL, 0x0000000800000d80ULL, 0x003f010200000004ULL, 0x0000000800000e30ULL,
0x003f010100000000ULL, 0x0000000500001670ULL, 0x003f01070000f6a8ULL, 0x00000005000017c0ULL,
0x003f01010000f6a8ULL, 0x0000000800001820ULL, 0x003f01010000f6c8ULL, 0x0000000b000019c0ULL,
0x003f01050000f6ccULL, 0x0000000b00001ba0ULL, 0x003f01050000f6ccULL, 0x00000011000024e0ULL,
0x003f01070000f6b0ULL, 0x0000001100002590ULL, 0x003f01010000f6b0ULL, 0x00000008000025f0ULL,
0x003f01010000f608ULL, 0x0000000800002610ULL, 0x003f01050000f60cULL, 0x00000008000027e0ULL,
0x003f01050000f60cULL, 0x0000001400002e00ULL, 0x003f01050000f6acULL, 0x0000001400002fd0ULL,
0x003f01050000f6acULL, 0x00000014000042a0ULL, 0x003f010100000000ULL, 0x0000005f00004300ULL,
0x003f01010000f688ULL, 0x0000000400004330ULL, 0x003f010500000004ULL, 0x00000004000044f0ULL,
0x003f010500000004ULL, 0x0000000b00004d40ULL, 0x003f01070000f6a8ULL, 0x0000000b00004e10ULL,
0x003f01010000f6a8ULL, 0x0000000800004e70ULL, 0x003f01010000f628ULL, 0x0000000800004e90ULL,
0x003f01050000f62cULL, 0x0000000800005060ULL, 0x003f01050000f62cULL, 0x0000003400005640ULL,
0x003f01050000f6b4ULL, 0x0000003400005810ULL, 0x003f01050000f6b4ULL, 0x0000000e00006890ULL,
0x003f010100000000ULL, 0x00000010000068f0ULL, 0x003f01010000f690ULL, 0x0000000400006920ULL,
0x003f010500000004ULL, 0x0000000400006ae0ULL, 0x003f010500000004ULL, 0x0000000b00007330ULL,
0x003f01070000f6b0ULL, 0x0000000b00007400ULL, 0x003f01010000f6b0ULL, 0x0000000800007460ULL,
0x003f01010000f648ULL, 0x0000000800007480ULL, 0x003f01050000f64cULL, 0x0000000800007650ULL,
0x003f01050000f64cULL, 0x0000001500007c40ULL, 0x003f01050000f6acULL, 0x0000001500007e10ULL,
0x003f01050000f6acULL, 0x0000000a00008ec0ULL, 0x003f010100000000ULL, 0x0000000c00008f20ULL,
0x003f01010000f698ULL, 0x0000000400008f50ULL, 0x003f010500000004ULL, 0x0000000400009110ULL,
0x003f010500000004ULL, 0x0000000a00009a20ULL, 0x003f01070000f6a8ULL, 0x0000000a00009ab0ULL,
0x003f01010000f6a8ULL, 0x0000000300009b10ULL, 0x003f01010000f668ULL, 0x0000000300009b30ULL,
0x003f01050000f66cULL, 0x0000000300009d00ULL, 0x003f01050000f66cULL, 0x0000000c0000a2d0ULL,
0x003f01050000f6b4ULL, 0x0000000c0000a4a0ULL, 0x003f01050000f6b4ULL, 0x000000040000b640ULL,
0x003f010100000000ULL, 0x0000000b0000b6c0ULL, 0x003f010100000000ULL, 0x000000ff0000ca40ULL,
0x003f01010000f600ULL, 0x000000ff0000d690ULL, 0x003f01050000f604ULL, 0x000000ff0000d8a0ULL,
0x003f01050000f604ULL, 0x000000ff0000dad0ULL, 0x003f01010000f600ULL, 0x000000ff0000db00ULL,
0x003f01050000f604ULL, 0x000000ff0000dcc0ULL, 0x003f01050000f604ULL, 0x000000740000ffa0ULL,
0x003f010100000000ULL, 0x0000007400010040ULL, 0x003f010500000004ULL, 0x0000007400010210ULL,
0x003f010500000004ULL, 0x0000007700012780ULL, 0x003f010100000000ULL, 0x00000077000127e0ULL,
0x003f010100000008ULL, 0x0000007700012840ULL, 0x003f010100000010ULL, 0x00000077000128b0ULL,
0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000c1200000c0f0ULL, 0x0000c5b00000c3c0ULL,
0x0000c9600000c7b0ULL, 0x000128f00000dd20ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000033cULL, 0x0000001b00000002ULL, 0x0000000000000284ULL, 0x0000001b00000002ULL,
0x00000000000001d4ULL, 0x0000001b00000002ULL, 0x000000000000010cULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000317ULL, 0x0000001b00000002ULL,
0x000000000000025cULL, 0x0000001b00000002ULL, 0x00000000000001b1ULL, 0x0000001b00000002ULL,
0x00000000000000e9ULL, 0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x00000006066c0981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff717624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000767919ULL, 0x000e680000002600ULL, 0x00000000000f7919ULL, 0x000e680000002300ULL,
0x00000000000b7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fcc0007ffe0ffULL, 0x0000000800097305ULL, 0x000864000021f000ULL,
0x000000ffff087224ULL, 0x010fe400078e00ffULL, 0x000000ffff057224ULL, 0x002fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x008fc800078e0a05ULL,
0x0000040002007624ULL, 0x000fca00078e0271ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705027224ULL, 0x008fc800078e02ffULL,
0x000000ffff097224ULL, 0x000fe400078e0a02ULL, 0x0000000000027919ULL, 0x000e640000002200ULL,
0x0000000907077227ULL, 0x000fcc00078e0006ULL, 0x0000007607727227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a72ULL, 0x0000000005007224ULL, 0x000fca00078e0276ULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x000001000f027a24ULL, 0x002fe400078e0202ULL,
0x00001fff0f0f7589ULL, 0x000fe400000e0000ULL, 0x0000000002117a24ULL, 0x000fca00078e020bULL,
0x000000ff1100720cULL, 0x000fc60003f65270ULL, 0x0000000100005824ULL, 0x000fe200078e0a05ULL,
0x0000000172725810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1100780cULL, 0x040fe40003f24070ULL,
0x000000050000720cULL, 0x000fe40003fc6070ULL, 0x00000005ff007819ULL, 0x000fe4000001160bULL,
0x0000007f1100780cULL, 0x040fe40003f44070ULL, 0x000000031100780cULL, 0x000fe20003fa4070ULL,
0x3fffff80ff06b424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff07b424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x0000000172726810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL,
0x00000005ff72c212ULL, 0x000fe200078e33ffULL, 0x00f60006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000011100780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ea424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fe200078e0a72ULL, 0x00f6080811009388ULL, 0x000fe20000008a00ULL,
0x3fffff80ff0ad424ULL, 0x000fc400078e00ffULL, 0x0000000205767224ULL, 0x000fe200078e0276ULL,
0x00f4000e1100a388ULL, 0x0009e20000004800ULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x0000001076767824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x00f688061100d388ULL, 0x000fe20000008a00ULL, 0x00005a00ff0e7624ULL, 0x010fc400078e00ffULL,
0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL, 0x00f6a80a1100d388ULL, 0x000fe20000008a00ULL,
0x000059000e0e7a24ULL, 0x000fc600078e02ffULL, 0x00f6c80c1100b388ULL, 0x000fe20000008a00ULL,
0x000000016c6c0824ULL, 0x004fe400078e0a03ULL, 0x00005800ff6c8624ULL, 0x000fe400078e00ffULL,
0x0000580004038a24ULL, 0x000fe400078e02ffULL, 0x00005a006c057a24ULL, 0x000fe400078e02ffULL,
0x0000000e03747224ULL, 0x000fe400078e02ffULL, 0x0000000105027824ULL, 0x040fe200078e0a76ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000760500720cULL, 0x000fe20003f26070ULL,
0x00005a0072107a24ULL, 0x000fe200078e0274ULL, 0x0000001002027817ULL, 0x000fc80003800000ULL,
0x000000ff02737207ULL, 0x000fe20000800000ULL, 0x000000040f027824ULL, 0x002fc600078e0200ULL,
0x000000107300780cULL, 0x000fe20003f05270ULL, 0x0000000202027824ULL, 0x000fd800078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x000e620000209000ULL,
0x0000000000417919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000500057308ULL, 0x002e620000001000ULL, 0x00000004ff097819ULL, 0x004fca0000011641ULL,
0x0000000102087824ULL, 0x000fe200078e0209ULL, 0x0ffffffe05067810ULL, 0x002fc60007ffe0ffULL,
0x0000000176057824ULL, 0x000fe200078e0208ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a07ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b070a7227ULL, 0x000fe200078e0006ULL,
0x0000000273077217ULL, 0x000fca0007800000ULL, 0x000000050a0a7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a0aULL, 0x0000000107027824ULL, 0x000fe400078e0a02ULL,
0x00005a000c067a24ULL, 0x000fca00078e0205ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000000108027824ULL, 0x040fe400078e0241ULL, 0x0000001008097824ULL, 0x000fca00078e00ffULL,
0xfffffff009027812ULL, 0x000fc600078ee202ULL, 0x000000010a0a1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0aaa12ULL, 0x000fe200078e33ffULL, 0x0000001002097824ULL, 0x000fc800078e00ffULL,
0x000000ffff067224ULL, 0x000fc800078e0a0aULL, 0x00005a0006057a24ULL, 0x000fc800078e0205ULL,
0x0000000110057824ULL, 0x000fc800078e0205ULL, 0x0000000e0a067224ULL, 0x000fe400078e0205ULL,
0x0000001041057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f0050b7812ULL, 0x000fc800078ec0ffULL, 0x0000000b060b7212ULL, 0x000fc800078efcffULL,
0x000060000b067a10ULL, 0x000fc80007f3e0ffULL, 0x0000610007077a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x0000000000417919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000800087308ULL, 0x002e620000001000ULL,
0x0000000241027211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe08077810ULL, 0x002fcc0007ffe0ffULL,
0x0000000700077305ULL, 0x000e64000021f000ULL, 0x000000ffff057224ULL, 0x002fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507067227ULL, 0x000fc800078e0006ULL,
0x0000000176057824ULL, 0x000fc800078e0202ULL, 0x0000000506067227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a06ULL, 0x00005a0008077a24ULL, 0x000fca00078e0205ULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f26070ULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a06ULL, 0x00005a0008057a24ULL, 0x000fe400078e0205ULL,
0x0000000102087824ULL, 0x000fe400078e0241ULL, 0x0000000110057824ULL, 0x000fc800078e0205ULL,
0x0000000e06067224ULL, 0x000fe400078e0205ULL, 0x0000001041057824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fc600078e00ffULL, 0x000000f005097812ULL, 0x000fc800078ec0ffULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x0000001002097824ULL, 0x000fc600078e00ffULL,
0x0000600006067a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0x0000610007077a10ULL, 0x000fc600007fe4ffULL, 0x0000001008097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e4000b901c46ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000000027806ULL, 0x000fe200038e0000ULL,
0x00000004ff657424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200067300ULL, 0x000e7000000e0000ULL, 0x0000000200087309ULL, 0x000ea20000000000ULL,
0x000000070600720cULL, 0x002fe20003f02070ULL, 0x0000680004067625ULL, 0x000fc800078e0065ULL,
0x000000ffff087224ULL, 0x004fd000078e0a08ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606687981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe40003f05270ULL,
0x0000003f68697810ULL, 0x044fe40007ffe0ffULL, 0x000000ff680a7810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff697819ULL, 0x000fe40000011669ULL, 0x00000008ff6b7819ULL, 0x000fca000001160aULL,
0x0000bca000008947ULL, 0x000fea0003800000ULL, 0x00000002ff717819ULL, 0x000fe20000011600ULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x0000f68800087811ULL, 0x002fe400078e18ffULL,
0x03ffffff71027812ULL, 0x000fc800078ec0ffULL, 0x000000690200720cULL, 0x000fda0003f06070ULL,
0x0000000204038824ULL, 0x000fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0003078624ULL, 0x000fe400078e0206ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000000102068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040908ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0065ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606038981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00000040726e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff6a7819ULL, 0x000fe20000011600ULL, 0x0000000008ff7f8cULL, 0x0007e8000c80043fULL,
0x000000206a757824ULL, 0x000fca00078e00ffULL, 0x000000206e097812ULL, 0x002fe200078ef875ULL,
0x00005900030a7a24ULL, 0x004fe200078e02ffULL, 0x0000000100037812ULL, 0x000fc600078ec0ffULL,
0x000000400a157824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000007568067217ULL, 0x008fe20007800000ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fe40000011641ULL, 0x0000640015117a11ULL, 0x000fe200078838ffULL,
0x0000000106067824ULL, 0x000fe200078e0a75ULL, 0x00000004080c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001070a7824ULL, 0x000fe200078e0208ULL, 0x0000000c080d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000706067217ULL, 0x000fe20007800000ULL, 0x000000010a0b7824ULL, 0x040fe200078e0241ULL,
0x0000650015157a11ULL, 0x000fe200020f3cffULL, 0x000000080a0e7824ULL, 0x000fc400078e00ffULL,
0x0000000106067824ULL, 0x000fe400078e0a07ULL, 0x0000000107167824ULL, 0x000fe200078e020dULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x00000008080b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001160f7824ULL, 0x000fe200078e0241ULL,
0x000000060c00720cULL, 0x080fe20003f46070ULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x000000060800720cULL, 0x080fe20003f66070ULL, 0x0000000107127824ULL, 0x000fe200078e020bULL,
0x000000060b00720cULL, 0x080fe20003f26070ULL, 0x000000010c077824ULL, 0x040fe200078e0241ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x000000080c107824ULL, 0x000fc400078e00ffULL,
0x0000000112087824ULL, 0x040fe400078e0241ULL, 0x00000008120b7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000800a067825ULL, 0x000fc600078e00ffULL,
0xfffffff80b147812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x040fe200078e020cULL,
0x0000007006067812ULL, 0x000fe200078ef805ULL, 0x00000001090a7824ULL, 0x040fe400078e0212ULL,
0x00000001090c7824ULL, 0x000fe200078e0216ULL, 0x0000000611067210ULL, 0x000fe20007f9e0ffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef805ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fc600078ef805ULL, 0x0000000816127824ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe200078ef805ULL, 0x0000000107077824ULL, 0x000fe200020e0615ULL,
0x0000b0006a057811ULL, 0x000fe400078e68ffULL, 0x0000001108087210ULL, 0x080fe40007f9e0ffULL,
0x000000110a0a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001014137824ULL, 0x000fe200078e0205ULL,
0xfffffff812127812ULL, 0x000fe200078ee20fULL, 0x000000100e0f7824ULL, 0x100fe200078e0205ULL,
0x000000110c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001010117824ULL, 0x000fc400078e0205ULL,
0x0000000109097824ULL, 0x100fe200020e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000d901c46ULL, 0x000000010b0b7824ULL, 0x000fe400028e0615ULL,
0x0000001012057824ULL, 0x000fe200078e0205ULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0615ULL, 0x000000000a137faeULL, 0x0003e8000c901c46ULL,
0x000000000c057faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x008fe200078e00ffULL, 0x0000640015137a11ULL, 0x000fe400078038ffULL,
0x0000b0006a177811ULL, 0x000fe400078e68ffULL, 0x0000000641067211ULL, 0x000fc400078fe8ffULL,
0x0000650015157a11ULL, 0x000fe400000f3cffULL, 0x0000000406087810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x140fe200078e0241ULL, 0x00000008060c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008060e7824ULL, 0x040fe200078e00ffULL, 0x0000000c06127810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x040fe400078e0241ULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000000109077824ULL, 0x000fc400078e0206ULL,
0x000000010c0b7824ULL, 0x000fe200078e0241ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x0000008007067825ULL, 0x000fc800078e00ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ef805ULL, 0x0000000109087824ULL, 0x040fe400078e0208ULL,
0x00000001090a7824ULL, 0x040fe200078e020cULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x00000001090c7824ULL, 0x000fe200078e0212ULL, 0x0000000613067210ULL, 0x000fe20007f1e0ffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef805ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fc600078ef805ULL, 0x0000000112117824ULL, 0x000fe200078e0241ULL,
0x000000700c057812ULL, 0x000fe200078ef805ULL, 0x0000000812127824ULL, 0x000fe200078e00ffULL,
0x0000000a130a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0615ULL,
0x0000000813087210ULL, 0x000fe20007f1e0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0217ULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0000001010117824ULL, 0x100fe200078e0217ULL,
0x00000005130c7210ULL, 0x000fe20007f5e0ffULL, 0x000000100e057824ULL, 0x000fc400078e0217ULL,
0x0000000109097824ULL, 0x100fe400000e0615ULL, 0x000000010b0b7824ULL, 0x000fe200008e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x0000001012137824ULL, 0x000fe400078e0217ULL, 0x000000010d0d7824ULL, 0x000fe200010e0615ULL,
0x00000000080f7faeULL, 0x0003e8000b901c46ULL, 0x000000000a117faeULL, 0x0003e8000b901c46ULL,
0x000000000c137faeULL, 0x0003e4000b901c46ULL, 0x0000000102027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000690200720cULL, 0x000fda0003f06070ULL,
0x0000000204058824ULL, 0x002fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0005058624ULL, 0x000fc800078e0206ULL, 0x0000000105068824ULL, 0x000fe400078e0202ULL,
0x000000106a057824ULL, 0x000fe400078e00ffULL, 0x0000660006068625ULL, 0x000fe400078e0065ULL,
0x00000000050473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000006060e8981ULL, 0x000522000c1e1900ULL, 0x000000ff6b00720cULL, 0x000fe20003f05270ULL,
0x000000086a087824ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6a800050c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80008067f8cULL, 0x000662000c80043fULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00009e3000008947ULL, 0x000fea0003800000ULL, 0x0000001005067812ULL, 0x00afe200078ec0ffULL,
0x00000002046f7824ULL, 0x000fc400078e00ffULL, 0x00006a00ff047624ULL, 0x000fe400078e00ffULL,
0x0000002071067824ULL, 0x000fe400078e0206ULL, 0x000000ffff087224ULL, 0x000fe400078e0007ULL,
0x00006a006f6f7624ULL, 0x000fe400078e0204ULL, 0x0000000803037824ULL, 0x000fe400078e0206ULL,
0xff317217ff0a7424ULL, 0x000fc400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x000000ffff6c7224ULL, 0x02afca00078e0002ULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x0000000400047824ULL, 0x000fca00078e00ffULL,
0xfffffff8040b7812ULL, 0x000fc800078ec0ffULL, 0x0000f6c80b047810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc000b0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012100f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x004fc80000011412ULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0612ULL, 0x000000020c0c7819ULL, 0x000fc8000000120fULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc000b0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001400c7810ULL, 0x004fe20007ffe0ffULL,
0x000059000e0e7a24ULL, 0x010fc600078e02ffULL, 0xffffffe0080b7812ULL, 0x000fe200078ec0ffULL,
0x000000400e3d7824ULL, 0x000fe200078e00ffULL, 0x0000006b0c00720cULL, 0x000fc60003f26070ULL,
0x00000100400b7824ULL, 0x000fca00078e020bULL, 0x000000400b0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000200f0b7812ULL, 0x000fca00078ec0ffULL, 0x000000016e117824ULL, 0x000fe200078e020bULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x00000010080b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f68087217ULL, 0x000fe40007800000ULL, 0x00000003ff107819ULL, 0x000fe40000011641ULL,
0x000064003d177a11ULL, 0x000fe200078a38ffULL, 0x0000000108087824ULL, 0x000fe200078e0a0fULL,
0x0000000810127810ULL, 0x040fe20007ffe0ffULL, 0x00000001100c7824ULL, 0x040fe200078e020bULL,
0x00000004100f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000b08087217ULL, 0x000fe20007800000ULL,
0x000000010c0e7824ULL, 0x040fe200078e0241ULL, 0x000065003d3d7a11ULL, 0x000fe200028f3cffULL,
0x000000080c137824ULL, 0x000fe400078e00ffULL, 0x0000000108087824ULL, 0x000fc600078e0a0bULL,
0xfffffff813167812ULL, 0x000fe400078ee20eULL, 0x0000000c100e7810ULL, 0x000fe40007ffe0ffULL,
0x000000081200720cULL, 0x0c0fe20003f46070ULL, 0x0000000112127824ULL, 0x100fe200078e020bULL,
0x000000081000720cULL, 0x080fe20003f86070ULL, 0x000000010f107824ULL, 0x140fe200078e020bULL,
0x000000080f00720cULL, 0x080fe20003f66070ULL, 0x00000010410f7824ULL, 0x000fe200078e00ffULL,
0x000000080e00720cULL, 0x040fe20003f06070ULL, 0x000000010e247824ULL, 0x000fc400078e020bULL,
0x00000001120b7824ULL, 0x140fe200078e0241ULL, 0x000000700f257812ULL, 0x000fe200078ec0ffULL,
0x0000000812147824ULL, 0x000fe400078e00ffULL, 0x00000001110e7824ULL, 0x000fe400078e020cULL,
0x0000000110087824ULL, 0x000fe200078e0241ULL, 0xfffffff8140c7812ULL, 0x000fe200078ee20bULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000111147824ULL, 0x000fe200078e0210ULL,
0x000000250e0e7212ULL, 0x080fe200078efcffULL, 0x0000000810137824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000e170e7210ULL, 0x000fe40007fbe0ffULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000000111107824ULL, 0x040fe200078e0212ULL,
0x0000002514147212ULL, 0x000fe200078efcffULL, 0x0000000111127824ULL, 0x000fc400078e0224ULL,
0x00000001240b7824ULL, 0x000fe400078e0241ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x0000002510107212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000010f0f7824ULL, 0x100fe200028e063dULL, 0x0000001714147210ULL, 0x000fe40007fbe0ffULL,
0x0000002512127212ULL, 0x000fe400078efcffULL, 0x0000c0006a0b7811ULL, 0x000fe200078e68ffULL,
0x0000000115157824ULL, 0x000fe200028e063dULL, 0x0000001710107210ULL, 0x080fe40007fbe0ffULL,
0x0000001712127210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x000fc400078e020bULL,
0x0000001008257824ULL, 0x100fe400078e020bULL, 0x000000100c277824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000e101c46ULL,
0x0000000111117824ULL, 0x000fe400028e063dULL, 0x00000010240b7824ULL, 0x000fe200078e020bULL,
0x0000000014257faeULL, 0x0003e2000d901c46ULL, 0x0000000113137824ULL, 0x000fc600030e063dULL,
0x0000000010277faeULL, 0x0003e8000d101c46ULL, 0x00000000120b7faeULL, 0x0003e2000c101c46ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001008087812ULL, 0x000fe400078ec0ffULL,
0x000064003d257a11ULL, 0x000fe400078038ffULL, 0x0000000841087211ULL, 0x000fe400078fe8ffULL,
0x000065003d3d7a11ULL, 0x000fc400000f3cffULL, 0x00000004080c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x140fe200078e0241ULL, 0x0000000808127810ULL, 0x040fe20007ffe0ffULL,
0x0000000808107824ULL, 0x000fe400078e00ffULL, 0x000000010c0e7824ULL, 0x040fe400078e0241ULL,
0x000000080c137824ULL, 0x000fe200078e00ffULL, 0xfffffff8100b7812ULL, 0x000fe200078ee20bULL,
0x00000001120f7824ULL, 0x040fe400078e0241ULL, 0x0000000812247824ULL, 0x000fe200078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee20eULL, 0x0000001041107824ULL, 0x000fc400078e00ffULL,
0x00000001110e7824ULL, 0x040fe200078e0208ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000000111127824ULL, 0x000fe200078e0212ULL, 0x0000000c08087810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007010177812ULL, 0x000fc600078ec0ffULL,
0x0000000111107824ULL, 0x040fe200078e020cULL, 0x000000170e0e7212ULL, 0x000fe200078efcffULL,
0x0000000111147824ULL, 0x000fe400078e0208ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000e250e7210ULL, 0x000fc60007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001710107212ULL, 0x000fc600078efcffULL, 0x00000001080c7824ULL, 0x000fe200078e0241ULL,
0x0000001712127212ULL, 0x080fe200078efcffULL, 0x0000000808277824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001225127210ULL, 0x000fe40007f5e0ffULL,
0xfffffff8270c7812ULL, 0x000fe200078ee20cULL, 0x000000010f0f7824ULL, 0x100fe200000e063dULL,
0x0000001714147212ULL, 0x000fe200078efcffULL, 0x0000000113137824ULL, 0x000fe200010e063dULL,
0x0000c0006a277811ULL, 0x000fc400078e68ffULL, 0x0000001025107210ULL, 0x040fe40007f1e0ffULL,
0x0000001425147210ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x100fe400078e0227ULL,
0x0000001016177824ULL, 0x000fe400078e0227ULL, 0x0000000111117824ULL, 0x000fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000b901c46ULL,
0x0000001024257824ULL, 0x100fe400078e0227ULL, 0x000000100c277824ULL, 0x000fe200078e0227ULL,
0x0000000010177faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e063dULL,
0x0000000012257faeULL, 0x0003e8000b901c46ULL, 0x0000000014277faeULL, 0x0003e4000b901c46ULL,
0x0000000800087824ULL, 0x000fe200078e00ffULL, 0x00000001020e7810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0xfffffff008117812ULL, 0x000fe400078ec0ffULL,
0x000000690e00720cULL, 0x000fe40003f06070ULL, 0x00000000110473c2ULL, 0x000e6200000e0000ULL,
0xffffffe0080b7812ULL, 0x040fe400078ec0ffULL, 0x0000001008107812ULL, 0x040fe400078ec0ffULL,
0x0000000808087812ULL, 0x000fcc00078ec0ffULL, 0x000000016f0e8824ULL, 0x000fe400078e020eULL,
0x00000004ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000b08087210ULL, 0x000fe40007ffe010ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000066000e0e8625ULL, 0x000fca00078e000fULL,
0x000000060e0c8981ULL, 0x000522000c1e1900ULL, 0x0000f6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b000110e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080008147f8cULL, 0x000664000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x00f60c00080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011413ULL, 0x000000120b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x000000020b0b7819ULL, 0x000fc80000001212ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c00080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001041567824ULL, 0x000fe200078e00ffULL,
0x00000001ff6d7819ULL, 0x000fe20000011641ULL, 0x00000020000b7824ULL, 0x000fe400078e00ffULL,
0xffffffffff777424ULL, 0x000fe200078e00ffULL, 0x0000007056567812ULL, 0x000fc400078ec0ffULL,
0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6d6d7812ULL, 0x000fc800078ec0ffULL,
0x0000000b6d0b7210ULL, 0x000fca0007ffe056ULL, 0x00f000000b117984ULL, 0x000e680000000800ULL,
0x00f200000b107984ULL, 0x0006a20000000800ULL, 0x0000000a1100720bULL, 0x002fe20003f1d000ULL,
0x000100127f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0b137812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001fff797424ULL, 0x000fc400078e00ffULL,
0xffffffffff787424ULL, 0x000fce00078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000007100720cULL, 0x000fe40003f05270ULL, 0x0000000a1100720bULL, 0x000fe20003f54000ULL,
0x0000ffb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000127806ULL, 0x000fc400010e0100ULL,
0x0000008000148824ULL, 0x000fe200078e0256ULL, 0x0000000a11157209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910120b7816ULL, 0x000fe200000000ffULL,
0x000000016d148824ULL, 0x000fca00078e0214ULL, 0x00f4001514008388ULL, 0x0003e20000000800ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000150a0b7221ULL, 0x002fe20000010000ULL, 0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00167308ULL, 0x000e640000000800ULL, 0x0000001609097220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011641ULL,
0x0000fee27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b160b7589ULL, 0x0002e400000e0000ULL,
0x0000000b30307220ULL, 0x08cfe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b34347220ULL, 0x080fe20000410000ULL, 0x0000000b35357220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008410b7811ULL, 0x000fe200078ff0ffULL,
0x0000fdc27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b160b7589ULL, 0x00066400000e0000ULL,
0x0000000b32327220ULL, 0x086fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000b36367220ULL, 0x080fe20000410000ULL, 0x0000000b37377220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe20007806012ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000a110a7209ULL, 0x000fd60007810000ULL,
0x8000000a11110221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100050308ULL, 0x000e640000000800ULL,
0x0000000510100220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000910097221ULL, 0x004fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000800127824ULL, 0x000fca00078e00ffULL, 0xfffffff012147812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0014127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0014127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011641ULL,
0x0000541006107816ULL, 0x000fe20000000006ULL, 0x0000f9727f007947ULL, 0x000fea000b800000ULL,
0x00001f0d10067589ULL, 0x0002a400000e0000ULL, 0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000f9a27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b10077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0010ULL, 0x0000313000157802ULL, 0x000fc40000000f00ULL,
0x0001038000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0010ULL,
0x0000318000157802ULL, 0x000fc40000000f00ULL, 0x0001033000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002005f7824ULL, 0x040fe200078e00ffULL,
0x00000007410b7812ULL, 0x04cfe200078ec0ffULL, 0x00000200004b7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000841487812ULL, 0x000fc400078ec0ffULL,
0x000000045f107812ULL, 0x002fe400078ec0ffULL, 0x000000080b597812ULL, 0x000fe400078ef841ULL,
0x0000001041107211ULL, 0x000fe400078fe0ffULL, 0xfffff8004b4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000859677824ULL, 0x040fe400078e00ffULL, 0x0000000159707824ULL, 0x000fca00078e0210ULL,
0xfffffff867677812ULL, 0x000fca00078ee270ULL, 0x0000001067677824ULL, 0x000fc800078e00ffULL,
0x0000000167507824ULL, 0x000fc400078e024bULL, 0x0000000400117824ULL, 0x000fe200078e00ffULL,
0x00000004ff647819ULL, 0x000fe40000011641ULL, 0x0000000b480d7212ULL, 0x040fe400078efcffULL,
0x0000000411117812ULL, 0x000fe400078ec0ffULL, 0x0000001048487812ULL, 0x000fe200078efe0bULL,
0x000000080d437824ULL, 0x000fe200078e00ffULL, 0x0000b0006a657811ULL, 0x000fe200078e68ffULL,
0x0000000164117824ULL, 0x000fe200078e0211ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ec0ffULL,
0x00000008484a7824ULL, 0x000fc400078e00ffULL, 0x000000010d107824ULL, 0x000fe400078e0211ULL,
0x00000001114f7824ULL, 0x000fe400078e0248ULL, 0x000000080d127824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee210ULL, 0x000000046a647824ULL, 0x000fe200078e0264ULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee24fULL, 0x0000000210497810ULL, 0x000fe20007ffe0ffULL,
0x0000001043247824ULL, 0x000fe200078e0265ULL, 0x0000000264647810ULL, 0x000fe20007ffe059ULL,
0x000000104a3c7824ULL, 0x000fe200078e0265ULL, 0xfffffff812497812ULL, 0x000fc600078ee249ULL,
0x000000002424783bULL, 0x000e640000004200ULL, 0x0000001049107824ULL, 0x000fe400078e0265ULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x0000010024117824ULL, 0x042fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011424ULL, 0x0001000024157824ULL, 0x040fe200078e00ffULL,
0x0000888024457816ULL, 0x000fe200000000ffULL, 0x0001000025177824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x004fc4000001143fULL, 0x00000018ff147819ULL, 0x000fe20000011411ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000000001010783bULL, 0x000e620000004200ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff477819ULL, 0x000fe40000011425ULL, 0x0000888025547816ULL, 0x000fe200000000ffULL,
0x00000016000d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff537819ULL, 0x000fc40000011426ULL,
0x0000888026627816ULL, 0x000fe400000000ffULL, 0x0000888027587816ULL, 0x000fe400000000ffULL,
0x00000018ff447819ULL, 0x000fe2000001143dULL, 0x0000001400247306ULL, 0x0007e20000200c00ULL,
0x0000010025167824ULL, 0x004fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe4000001143cULL,
0x000088803c557816ULL, 0x000fe400000000ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x00000015004d7306ULL, 0x0005e20000200c00ULL, 0x0000010026147824ULL, 0x048fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011427ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001143eULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000001600257306ULL, 0x000fe20000200c00ULL, 0x0000010027157824ULL, 0x044fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011415ULL, 0x00000017005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff5b7819ULL, 0x002fe40000011410ULL,
0x00000018ff5a7819ULL, 0x000fe40000011411ULL, 0x00000018ff4e7819ULL, 0x000fe20000011412ULL,
0x0000001400637306ULL, 0x0003e20000200c00ULL, 0x00000018ff517819ULL, 0x000fce0000011413ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x009000005014783bULL, 0x002e6e0000000200ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x0000541045247816ULL, 0x004fce0000000024ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000541054257816ULL, 0x008fce0000000025ULL,
0x00000026005e7306ULL, 0x0007e20000200c00ULL, 0x000088803d547816ULL, 0x000fce00000000ffULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000001003c267824ULL, 0x048fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000000614148232ULL, 0x082fe20000000000ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0000000616168232ULL, 0x000fe20000000000ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000000715158232ULL, 0x080fe40000000000ULL, 0x0000000717178232ULL, 0x000fc60000000000ULL,
0x0000006100617306ULL, 0x000e680000200c00ULL, 0x000000241430723cULL, 0x000b680000001830ULL,
0x0000003c005d7306ULL, 0x0007e60000200c00ULL, 0x000001003d247824ULL, 0x020fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe400078e00ffULL, 0x0000000848257824ULL, 0x000fe200078e00ffULL,
0x000000024f487810ULL, 0x000fe20007ffe0ffULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e3c7816ULL, 0x008fe400000000ffULL,
0xfffffff825487812ULL, 0x000fe400078ee248ULL, 0x000054105c257816ULL, 0x004fe20000000047ULL,
0x0000003d00577306ULL, 0x0005e20000200c00ULL, 0x00000018ff247819ULL, 0x000fce0000011424ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000001003f3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000002700607306ULL, 0x000eb00000200c00ULL,
0x0000003c00477306ULL, 0x0007f00000200c00ULL, 0x0000003d004f7306ULL, 0x0003e20000200c00ULL,
0x00005410623c7816ULL, 0x008fe20000000063ULL, 0x0000000859637824ULL, 0x000fc400078e00ffULL,
0x0001000012597824ULL, 0x000fc600078e00ffULL, 0xfffffff863647812ULL, 0x000fe200078ee264ULL,
0x0000005500457306ULL, 0x000fe20000200c00ULL, 0x00005410583d7816ULL, 0x002fe40000000061ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x00000010644b7824ULL, 0x000fc800078e024bULL,
0x0000002400557306ULL, 0x0003e20000200c00ULL, 0x0000003c1428723cULL, 0x000bee0000001828ULL,
0x00008880103d7816ULL, 0x020fe200000000ffULL, 0x0000002600467306ULL, 0x0007e20000200c00ULL,
0x000054104d247816ULL, 0x002fe2000000004cULL, 0x000001003e4c7824ULL, 0x000fe200078e00ffULL,
0x000054105e3c7816ULL, 0x000fe20000000053ULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144cULL, 0x0000003d00537306ULL, 0x0005e20000200c00ULL,
0x000088803f4c7816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000024142c723cULL, 0x040b62000000182cULL, 0x0000001048267824ULL, 0x008fe200078e0265ULL,
0x00000018ff5c7819ULL, 0x000fe4000001143eULL, 0x00000018ff627819ULL, 0x000fe2000001143fULL,
0x00000100103f7824ULL, 0x000fe200078e00ffULL, 0x00005410603d7816ULL, 0x004fe20000000052ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000888011607816ULL, 0x040fe200000000ffULL,
0x000000002624783bULL, 0x020e620000004200ULL, 0x00000018ff5e7819ULL, 0x000fe2000001143fULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000003c1438723cULL, 0x000b6c0000001838ULL, 0x0000005e00527306ULL, 0x0004e20000200c00ULL,
0x00000100113c7824ULL, 0x020fc400078e00ffULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff617819ULL, 0x000fe4000001143cULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00000100135e7824ULL, 0x004fcc00078e00ffULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x0000541053527816ULL, 0x008fce0000000052ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3e7819ULL, 0x002fe40000011424ULL,
0x0000541060537816ULL, 0x004fca0000000061ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x0000888012617816ULL, 0x040fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011425ULL,
0x00000018ff3d7819ULL, 0x000fe20000011427ULL, 0x000000521434723cULL, 0x000be20000001834ULL,
0x00000018ff3c7819ULL, 0x000fe20000011426ULL, 0x0000001100117306ULL, 0x000eaa0000200c00ULL,
0x0000010012527824ULL, 0x020fe200078e00ffULL, 0x0000888013537816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x0000006200587306ULL, 0x0007e20000200c00ULL,
0x0000541010107816ULL, 0x002fc4000000005bULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff607819ULL, 0x000fe40000011413ULL, 0x00008880245b7816ULL, 0x040fe200000000ffULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000018ff627819ULL, 0x008fe4000001145eULL,
0x0000541011117816ULL, 0x004fe2000000005aULL, 0x00000100245a7824ULL, 0x040fe400078e00ffULL,
0x0001000024247824ULL, 0x000fc400078e00ffULL, 0x0000006200127306ULL, 0x000e620000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x00000010141c723cULL, 0x000b62000000181cULL,
0x00000018ff247819ULL, 0x000fca0000011424ULL, 0x0000006100617306ULL, 0x000ff00000200c00ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000541053537816ULL, 0x002fe40000000012ULL,
0x009000004b10783bULL, 0x020e6a0000000200ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541061527816ULL, 0x004fce0000000052ULL, 0x00000059005e7306ULL, 0x000ea20000200c00ULL,
0x000000521418723cULL, 0x000b6e0000001818ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000888025537816ULL, 0x060fe200000000ffULL, 0x0000010025527824ULL, 0x000fcc00078e00ffULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc80000011452ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002400527306ULL, 0x0005e20000200c00ULL, 0x0000000610108232ULL, 0x082fe40000000000ULL,
0x0000000612128232ULL, 0x000fe40000000000ULL, 0x0000000711118232ULL, 0x000fc60000000000ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000054105e247816ULL, 0x004fe2000000004eULL,
0x0000000713138232ULL, 0x000fe20000000000ULL, 0x00008880265e7816ULL, 0x000fca00000000ffULL,
0x00000025004e7306ULL, 0x0007f00000200c00ULL, 0x0000004200427306ULL, 0x000ea20000200c00ULL,
0x0000541060257816ULL, 0x008fe20000000051ULL, 0x000000ffff517224ULL, 0x000fcc00078e005eULL,
0x000000241414723cULL, 0x000b620000001820ULL, 0x0000004400447306ULL, 0x000eec0000200c00ULL,
0x0000010026207824ULL, 0x020fe200078e00ffULL, 0x0000888027227816ULL, 0x000fe200000000ffULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x0000541054217816ULL, 0x002fe20000000055ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000541058257816ULL, 0x000fc6000000000dULL, 0x00000020005e7306ULL, 0x0003f00000200c00ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x0000541045207816ULL, 0x002fe20000000046ULL,
0x000000ffff457224ULL, 0x000fc400078e0022ULL, 0x0000010027227824ULL, 0x040fe400078e00ffULL,
0x0001000027277824ULL, 0x000fe400078e00ffULL, 0x000000201030723cULL, 0x000b620000001830ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000005b00597306ULL, 0x000fe20000200c00ULL,
0x00000018ff467819ULL, 0x000fc80000011427ULL, 0x000054105d207816ULL, 0x024fe40000000042ULL,
0x0000541057217816ULL, 0x008fe20000000044ULL, 0x0000000b000b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff447819ULL, 0x000fca0000011426ULL, 0x00000020102c723cULL, 0x040b64000000182cULL,
0x0000005c005c7306ULL, 0x000e6a0000200c00ULL, 0x0000541047207816ULL, 0x020fe4000000004dULL,
0x000054104c217816ULL, 0x000fe2000000004fULL, 0x0000003e003e7306ULL, 0x000eac0000200c00ULL,
0x000000201028723cULL, 0x000f640000001828ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054105c247816ULL, 0x002fce000000000bULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x00005410523e7816ULL, 0x004fe2000000003eULL, 0x000000241024723cULL, 0x000f6c0000001838ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000054104e3f7816ULL, 0x008fce000000003fULL,
0x00000061005b7306ULL, 0x000ea20000200c00ULL, 0x00005410595a7816ULL, 0x002fe2000000005aULL,
0x0000003e101c723cULL, 0x000f6c000000181cULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410535b7816ULL, 0x004fce000000005bULL,
0x0000002200427306ULL, 0x0002b00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000005a1020723cULL, 0x002f6e0000001834ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541045457816ULL, 0x004fce0000000042ULL, 0x0000004400477306ULL, 0x0002b00000200c00ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x0000541051447816ULL, 0x002fe4000000005eULL,
0x00005410473c7816ULL, 0x004fca000000003cULL, 0x000000441018723cULL, 0x000f620000001818ULL,
0x00005410463d7816ULL, 0x008fce000000003dULL, 0x0000003c1010723cULL, 0x000b6e0000001814ULL,
0x0000f6c86a147811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000014147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688005fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000167805ULL, 0x000fc80000015200ULL, 0x00000400040d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00afc40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003416347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011435ULL,
0x000000340d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000020d0d7819ULL, 0x000fc80000001234ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400040d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000147824ULL, 0x000fca00078e00ffULL, 0xffffffe0140b7812ULL, 0x000fca00078ec0ffULL,
0x00000100400b7824ULL, 0x000fca00078e020bULL, 0x000000800b157810ULL, 0x000fe20007ffe0ffULL,
0x000059000c0b7a24ULL, 0x010fc600078e02ffULL, 0x00000020150d7812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fc800078e00ffULL, 0x000000016e0d7824ULL, 0x000fe200078e020dULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x00000015680c7217ULL, 0x000fe40007800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x00000003ff147819ULL, 0x000fe20000011641ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a15ULL, 0x000064000b377a11ULL, 0x000fe400078a38ffULL,
0x0000000414347810ULL, 0x040fe20007ffe0ffULL, 0x0000000114167824ULL, 0x000fe200078e0217ULL,
0x0000000c170c7217ULL, 0x000fc40007800000ULL, 0x0000000c14357810ULL, 0x000fe20007ffe0ffULL,
0x0000000116157824ULL, 0x040fe200078e0241ULL, 0x000065000b397a11ULL, 0x000fe200028f3cffULL,
0x0000000816367824ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x100fe400078e0a17ULL,
0x00000001353c7824ULL, 0x000fe200078e0217ULL, 0xfffffff836367812ULL, 0x000fe400078ee215ULL,
0x0000000814157810ULL, 0x000fe20007ffe0ffULL, 0x000000013c0b7824ULL, 0x000fe200078e0241ULL,
0x0000000c1400720cULL, 0x080fe20003f86070ULL, 0x0000000116147824ULL, 0x000fe200078e020dULL,
0x0000000c3400720cULL, 0x0c0fe20003f66070ULL, 0x0000000134167824ULL, 0x100fe200078e0217ULL,
0x0000000c1500720cULL, 0x0c0fe20003f46070ULL, 0x0000000115347824ULL, 0x000fe200078e0217ULL,
0x0000000c3500720cULL, 0x000fe20003f06070ULL, 0x0000000116157824ULL, 0x000fc400078e0241ULL,
0x0000000816387824ULL, 0x000fe400078e00ffULL, 0x00000001340c7824ULL, 0x040fe400078e0241ULL,
0x0000000834177824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee215ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8173a7812ULL, 0x000fe200078ee20cULL,
0x0000000116167824ULL, 0x100fe200078e020dULL, 0x0000005614147212ULL, 0x000fe200078efcffULL,
0x0000000134347824ULL, 0x000fe400078e020dULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001437147210ULL, 0x000fc60007fbe0ffULL, 0x000000013c0c7824ULL, 0x000fe200078e020dULL,
0x0000005616167212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000005634347212ULL, 0x000fc600078efcffULL,
0x0000000115157824ULL, 0x000fe200028e0639ULL, 0x0000003716167210ULL, 0x000fe20007fbe0ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x000000560c0c7212ULL, 0x000fc600078efcffULL,
0x0000000117177824ULL, 0x000fe200028e0639ULL, 0x0000003734347210ULL, 0x080fe40007fbe0ffULL,
0x000000370c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001038377824ULL, 0x000fe200078e0265ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x00000010360b7824ULL, 0x000fe400078e0265ULL,
0x0000000135357824ULL, 0x100fe400028e0639ULL, 0x000000010d0d7824ULL, 0x000fe200030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000e101c46ULL,
0x000000103a397824ULL, 0x000fc400078e0265ULL, 0x000000103c3b7824ULL, 0x000fe200078e0265ULL,
0x0000000016377faeULL, 0x0003e8000d901c46ULL, 0x0000000034397faeULL, 0x0003e8000d101c46ULL,
0x000000000c3b7faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001014147812ULL, 0x000fe400078ec0ffULL, 0x000064000b377a11ULL, 0x000fc400078038ffULL,
0x00000014410c7211ULL, 0x000fe400078fe8ffULL, 0x000065000b397a11ULL, 0x000fe400000f3cffULL,
0x000000040c167810ULL, 0x040fe20007ffe0ffULL, 0x000000010c157824ULL, 0x040fe200078e0241ULL,
0x000000080c387810ULL, 0x040fe20007ffe0ffULL, 0x000000080c367824ULL, 0x040fe200078e00ffULL,
0x0000000c0c3a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008163c7824ULL, 0x000fe400078e00ffULL,
0x000000010c147824ULL, 0x000fe200078e020dULL, 0xfffffff836367812ULL, 0x000fe200078ee215ULL,
0x0000000116157824ULL, 0x000fc400078e0241ULL, 0x0000000116347824ULL, 0x100fe400078e020dULL,
0x0000000138167824ULL, 0x100fe400078e020dULL, 0x000000013a0c7824ULL, 0x000fe400078e020dULL,
0x00000001380d7824ULL, 0x040fe400078e0241ULL, 0x00000008383e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c387812ULL, 0x000fe200078ee215ULL, 0x000000013a177824ULL, 0x000fc400078e0241ULL,
0x000000083a427824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3a7812ULL, 0x000fe200078ee20dULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8423c7812ULL, 0x000fe200078ee217ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005614147212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001437147210ULL, 0x040fe40007f1e0ffULL,
0x0000005634347212ULL, 0x080fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000005616167212ULL, 0x000fe400078efcffULL, 0x0000003437347210ULL, 0x000fe20007f5e0ffULL,
0x0000000115157824ULL, 0x000fe200000e0639ULL, 0x000000560c0c7212ULL, 0x000fe200078efcffULL,
0x00000010360b7824ULL, 0x000fe200078e0265ULL, 0x0000001637167210ULL, 0x000fe20007f1e0ffULL,
0x0000000135357824ULL, 0x000fe200010e0639ULL, 0x0000000c370c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001038377824ULL, 0x000fe200078e0265ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140b7faeULL, 0x0003e2000b901c46ULL, 0x0000000117177824ULL, 0x000fc400000e0639ULL,
0x000000010d0d7824ULL, 0x000fe200018e0639ULL, 0x0000000034377faeULL, 0x0003e2000b901c46ULL,
0x000000103a397824ULL, 0x100fe400078e0265ULL, 0x000000103c3b7824ULL, 0x000fc600078e0265ULL,
0x0000000016397faeULL, 0x0003e8000b901c46ULL, 0x000000000c3b7faeULL, 0x0003e4000b901c46ULL,
0x00000008000b7824ULL, 0x002fe200078e00ffULL, 0x00000002020c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff427424ULL, 0x000fc600078e00ffULL, 0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000690c00720cULL, 0x000fe40003f06070ULL, 0x000000000b0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000016f0c8824ULL, 0x000fc400078e020cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000066000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c428981ULL, 0x000722000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x00f6a8000b0c7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280008147f8cULL, 0x0002a4000c80043fULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x00f62c00080b7984ULL, 0x002e640000000800ULL,
0x800000000bff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003416347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011435ULL, 0x000000340b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020b0b7819ULL, 0x000fc80000001234ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000b7824ULL, 0x000fca00078e00ffULL,
0xffffff800b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000008056147810ULL, 0x000fca0007ffe00bULL,
0x000000016d147824ULL, 0x000fca00078e0214ULL, 0x00f0000014177984ULL, 0x000e680000000800ULL,
0x00f2000014167984ULL, 0x0004e20000000800ULL, 0x0000000a1700720bULL, 0x002fe20003f1d000ULL,
0x0000d9927f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0b357812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001710b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1700720bULL, 0x000fe40003f54000ULL,
0x000000000b00720cULL, 0x000fe20003f05270ULL, 0x0000d9427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000347806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0256ULL,
0x0000000a170b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000016d368824ULL, 0x000fe200078e0214ULL, 0x0000991034147816ULL, 0x000fc800000000ffULL,
0x00f4000b36008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a170b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff34ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00367308ULL, 0x000e640000000800ULL, 0x0000003609097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011641ULL,
0x0000d8627f007947ULL, 0x000fea000b800000ULL, 0x00001f0b360b7589ULL, 0x0002a400000e0000ULL,
0x0000000b30307220ULL, 0x084fe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b10107220ULL, 0x080fe20000410000ULL, 0x0000000b11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008410b7811ULL, 0x000fe200078ff0ffULL,
0x0000d7427f007947ULL, 0x000fea000b800000ULL, 0x00001f0b360b7589ULL, 0x00046400000e0000ULL,
0x0000000b32327220ULL, 0x086fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x080fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b12127220ULL, 0x080fe20000410000ULL, 0x0000000b13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000a170a7209ULL, 0x000fd60007810000ULL,
0x8000000a17170221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700050308ULL, 0x000e640000000800ULL,
0x0000000516160220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000916097221ULL, 0x008fc20000010000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000000800167824ULL, 0x000fca00078e00ffULL, 0xfffffff016347812ULL, 0x000fca00078ec0ffULL,
0x00f6b40034177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40034177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011641ULL,
0x00005410060e7816ULL, 0x000fe20000000006ULL, 0x0000d2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e067589ULL, 0x0002a400000e0000ULL, 0x000000080f0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000d3227f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0e077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000eULL, 0x0000597000157802ULL, 0x000fc40000000f00ULL,
0x0000db4000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x000059c000157802ULL, 0x000fc40000000f00ULL, 0x0000daf000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100065517810ULL, 0x000fe20007ffe0ffULL, 0x009800005034783bULL, 0x000ee80000000200ULL,
0x0000001043587824ULL, 0x000fc400078e0251ULL, 0x0000001048147824ULL, 0x100fe400078e0251ULL,
0x00000010493c7824ULL, 0x100fe200078e0251ULL, 0x000000005844783bULL, 0x000ea20000004200ULL,
0x000000104a527824ULL, 0x000fc600078e0251ULL, 0x000000001414783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000005238783bULL, 0x000e620000004200ULL,
0x0000000634348232ULL, 0x08cfe40000000000ULL, 0x0000000636368232ULL, 0x000fc40000000000ULL,
0x0000000735358232ULL, 0x082fe40000000000ULL, 0x0000000737378232ULL, 0x000fe20000000000ULL,
0x00000100444c7824ULL, 0x040fe200078e00ffULL, 0x0000888045557816ULL, 0x040fe400000000ffULL,
0x00008880440f7816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144cULL,
0x00000100454c7824ULL, 0x000fe200078e00ffULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fc40000011444ULL, 0x00000018ff5e7819ULL, 0x000fe20000011445ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001144cULL,
0x00000018ff5c7819ULL, 0x000fe20000011446ULL, 0x0000000f00547306ULL, 0x000fe20000200c00ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff5b7819ULL, 0x000fe40000011447ULL,
0x00000018ff617819ULL, 0x000fc40000011417ULL, 0x0000888047637816ULL, 0x000fe200000000ffULL,
0x0000005d00607306ULL, 0x0002a20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe4000001143cULL,
0x00000018ff597819ULL, 0x000fe4000001143dULL, 0x00000018ff537819ULL, 0x000fe4000001143eULL,
0x00000018ff577819ULL, 0x000fe2000001143fULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x00010000445d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc40000011438ULL,
0x00000018ff4f7819ULL, 0x000fe40000011439ULL, 0x00000018ff0b7819ULL, 0x000fe4000001143aULL,
0x0000541055557816ULL, 0x004fe20000000060ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff607819ULL, 0x000fe4000001145dULL, 0x00008880465d7816ULL, 0x000fe400000000ffULL,
0x00000018ff0e7819ULL, 0x000fc4000001143bULL, 0x0000541054547816ULL, 0x008fe2000000004dULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x00000018ff4c7819ULL, 0x000fe40000011414ULL,
0x00000018ff0f7819ULL, 0x000fe40000011415ULL, 0x00000018ff4d7819ULL, 0x000fe20000011416ULL,
0x000000543430723cULL, 0x000be40000001830ULL, 0x0000005e005e7306ULL, 0x000fea0000200c00ULL,
0x0000010046547824ULL, 0x020fc400078e00ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x0000004500557306ULL, 0x0004e40000200c00ULL, 0x00000018ff547819ULL, 0x000fcc0000011454ULL,
0x0000005400627306ULL, 0x0003e20000200c00ULL, 0x00000018ff457819ULL, 0x004fe20000011446ULL,
0x000001003c467824ULL, 0x000fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000006100447306ULL, 0x000fe20000200c00ULL, 0x0000541060547816ULL, 0x002fe2000000005fULL,
0x00000100475f7824ULL, 0x000fe200078e00ffULL, 0x0000541055557816ULL, 0x008fe2000000005eULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x000088803c5e7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x00000054342c723cULL, 0x000be2000000182cULL, 0x00000018ff3c7819ULL, 0x000fca000001143cULL,
0x0000006300607306ULL, 0x000fe20000200c00ULL, 0x000088803d557816ULL, 0x060fe200000000ffULL,
0x000001003d547824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc800078e00ffULL,
0x0000005f00617306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000005b005b7306ULL, 0x000ff00000200c00ULL,
0x0000004500457306ULL, 0x000ff00000200c00ULL, 0x0000004700667306ULL, 0x0002b00000200c00ULL,
0x00000046005f7306ULL, 0x0007e20000200c00ULL, 0x0000541060477816ULL, 0x002fc40000000061ULL,
0x000088803e617816ULL, 0x000fe400000000ffULL, 0x000088803f607816ULL, 0x000fc600000000ffULL,
0x0000003d00647306ULL, 0x0005e20000200c00ULL, 0x000054105d467816ULL, 0x008fe40000000062ULL,
0x00000018ff5d7819ULL, 0x000fca0000011454ULL, 0x0000003c00547306ULL, 0x0003e20000200c00ULL,
0x00005410663d7816ULL, 0x004fe2000000005bULL, 0x000000463428723cULL, 0x000b620000001828ULL,
0x00000100395b7824ULL, 0x000fca00078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00005410453c7816ULL, 0x002fe2000000005cULL, 0x000001003f457824ULL, 0x040fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x000001003e467824ULL, 0x060fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011445ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000003c3424723cULL, 0x000be20000001824ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000888038457816ULL, 0x000fc400000000ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00000100383c7824ULL, 0x060fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x000fce0000011438ULL, 0x0000004600627306ULL, 0x000fe20000200c00ULL,
0x00005410553d7816ULL, 0x002fce000000005dULL, 0x0000006000607306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000ff00000200c00ULL, 0x0000005a005a7306ULL, 0x000e700000200c00ULL,
0x0000003e00467306ULL, 0x000ff00000200c00ULL, 0x0000003f00477306ULL, 0x0005e20000200c00ULL,
0x00005410545a7816ULL, 0x002fce000000005aULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00008880393f7816ULL, 0x044fe200000000ffULL, 0x0001000039397824ULL, 0x000fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x00000038003e7306ULL, 0x0005f00000200c00ULL,
0x0000003c005c7306ULL, 0x0007e20000200c00ULL, 0x000001003a387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003f00557306ULL, 0x0005e20000200c00ULL,
0x000054105e3c7816ULL, 0x008fce000000005fULL, 0x0000003c3420723cULL, 0x000b620000001820ULL,
0x0000005b005e7306ULL, 0x0007e20000200c00ULL, 0x000001003b3f7824ULL, 0x004fca00078e00ffULL,
0x000088803a3c7816ULL, 0x060fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000039005f7306ULL, 0x0005e20000200c00ULL, 0x000088803b5b7816ULL, 0x048fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143fULL,
0x00000018ff3f7819ULL, 0x000fc6000001143aULL, 0x00000038003d7306ULL, 0x0007e20000200c00ULL,
0x0000541060397816ULL, 0x004fe40000000063ULL, 0x0000888015607816ULL, 0x000fca00000000ffULL,
0x0000005b00547306ULL, 0x0003e20000200c00ULL, 0x0000541061387816ULL, 0x008fce0000000062ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x00005410645b7816ULL, 0x002fe40000000059ULL,
0x00000018ff597819ULL, 0x000fe4000001143bULL, 0x000000383438723cULL, 0x040be40000001818ULL,
0x009800004b18783bULL, 0x020e620000000200ULL, 0x0000005700577306ULL, 0x000eea0000200c00ULL,
0x0000005a341c723cULL, 0x000b66000000181cULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541046467816ULL, 0x004fe20000000053ULL, 0x0000010015537824ULL, 0x000fc400078e00ffULL,
0x00008880145a7816ULL, 0x060fe200000000ffULL, 0x00000100145b7824ULL, 0x040fe400078e00ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000541047477816ULL, 0x008fe20000000057ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff617819ULL, 0x000fe40000011453ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x000000463410723cULL, 0x000b620000001810ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005d005d7306ULL, 0x000eea0000200c00ULL,
0x0000010016357824ULL, 0x020fe200078e00ffULL, 0x0000888017377816ULL, 0x000fc400000000ffULL,
0x0000001400537306ULL, 0x0007e20000200c00ULL, 0x000054103c3c7816ULL, 0x004fe4000000003dULL,
0x0000888016347816ULL, 0x000fe200000000ffULL, 0x0000000618188232ULL, 0x082fe20000000000ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000000061a1a8232ULL, 0x000fe40000000000ULL,
0x0000001500367306ULL, 0x0003e20000200c00ULL, 0x0000000719198232ULL, 0x080fe20000000000ULL,
0x0000541045147816ULL, 0x008fe2000000005cULL, 0x000000071b1b8232ULL, 0x000fe20000000000ULL,
0x00005410543d7816ULL, 0x000fc8000000005dULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x0000541055157816ULL, 0x002fe4000000005eULL, 0x0000003c1828723cULL, 0x040f6a0000001828ULL,
0x0000005900597306ULL, 0x000fe60000200c00ULL, 0x000000141830723cULL, 0x000b6a0000001830ULL,
0x0000004c004c7306ULL, 0x000fe40000200c00ULL, 0x0000010017147824ULL, 0x020fc400078e00ffULL,
0x0001000017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011414ULL,
0x0001000016147824ULL, 0x000fe200078e00ffULL, 0x0000000f000f7306ULL, 0x000e620000200c00ULL,
0x00000018ff177819ULL, 0x000fc60000011417ULL, 0x00000018ff147819ULL, 0x000fc80000011414ULL,
0x0000005a005a7306ULL, 0x000ff00000200c00ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x00005410360f7816ULL, 0x002fce000000000fULL, 0x0000003400347306ULL, 0x000ff00000200c00ULL,
0x0000003500357306ULL, 0x000e620000200c00ULL, 0x000054105a5a7816ULL, 0x004fce000000005bULL,
0x0000004e004e7306ULL, 0x000eb00000200c00ULL, 0x0000004f004f7306ULL, 0x000ee20000200c00ULL,
0x0000541034347816ULL, 0x002fce0000000035ULL, 0x0000000b000b7306ULL, 0x000fe20000200c00ULL,
0x000054103e4e7816ULL, 0x004fce000000004eULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x000054105f4f7816ULL, 0x008fce000000004fULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000004e182c723cULL, 0x000f6e000000182cULL, 0x0000006100617306ULL, 0x000e700000200c00ULL,
0x0000003700377306ULL, 0x000ff00000200c00ULL, 0x0000001500167306ULL, 0x0004e20000200c00ULL,
0x00005410605b7816ULL, 0x002fce0000000061ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000541059157816ULL, 0x004fe2000000000eULL, 0x0000005a1820723cULL, 0x000f620000001820ULL,
0x00005410530e7816ULL, 0x000fca000000004cULL, 0x00000014003c7306ULL, 0x0002a20000200c00ULL,
0x0000541037357816ULL, 0x008fe20000000016ULL, 0x0000000e181c723cULL, 0x040b6c000000181cULL,
0x0000001700177306ULL, 0x000ee20000200c00ULL, 0x000054103f147816ULL, 0x002fe2000000000bULL,
0x00000002000b7824ULL, 0x000fe200078e00ffULL, 0x000000341838723cULL, 0x000f640000001838ULL,
0x000054103c0e7816ULL, 0x024fcc000000004dULL, 0x000000141824723cULL, 0x000f620000001824ULL,
0x00005410170f7816ULL, 0x008fce0000000044ULL, 0x0000000e1818723cULL, 0x000b6e0000001810ULL,
0x0000f6c86a0e7811ULL, 0x020fe400078e18ffULL, 0xfffffff80b107812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000000e0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900010ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc600078e00ffULL, 0x0000000000107805ULL, 0x004fc80000015200ULL,
0x0000040004137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x006fc4000780480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fca00078e00ffULL,
0xffffffe00e0b7812ULL, 0x000fca00078ec0ffULL, 0x00000100400b7824ULL, 0x000fca00078e020bULL,
0x000000c00b117810ULL, 0x000fe20007ffe0ffULL, 0x00005900420b7a24ULL, 0x010fc600078e02ffULL,
0x00000020110f7812ULL, 0x000fe200078ec0ffULL, 0x000000400b0b7824ULL, 0x000fc800078e00ffULL,
0x000000016e147824ULL, 0x000fe200078e020fULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000100e137812ULL, 0x000fe400078ec0ffULL, 0x00000011680e7217ULL, 0x000fe40007800000ULL,
0x00000003ff0f7819ULL, 0x000fe40000011641ULL, 0x000064000b177a11ULL, 0x000fe200078a38ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a11ULL, 0x000000040f127810ULL, 0x040fe20007ffe0ffULL,
0x000000010f107824ULL, 0x040fe200078e0213ULL, 0x0000000c0f157810ULL, 0x000fc40007ffe0ffULL,
0x0000000e130e7217ULL, 0x000fe20007800000ULL, 0x0000000110117824ULL, 0x040fe200078e0241ULL,
0x000065000b357a11ULL, 0x000fe200028f3cffULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x100fe400078e0a13ULL, 0x0000000115377824ULL, 0x000fe200078e0213ULL,
0xfffffff816167812ULL, 0x000fe400078ee211ULL, 0x000000080f117810ULL, 0x000fe20007ffe0ffULL,
0x00000001370b7824ULL, 0x000fe200078e0241ULL, 0x0000000e0f00720cULL, 0x080fe20003f86070ULL,
0x00000001100f7824ULL, 0x000fe200078e0214ULL, 0x0000000e1200720cULL, 0x0c0fe20003f66070ULL,
0x0000000112107824ULL, 0x100fe200078e0213ULL, 0x0000000e1100720cULL, 0x0c0fe20003f46070ULL,
0x0000000111127824ULL, 0x000fe200078e0213ULL, 0x0000000e1500720cULL, 0x000fe20003f06070ULL,
0x0000000110117824ULL, 0x000fc400078e0241ULL, 0x0000000810347824ULL, 0x000fe400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee211ULL,
0x0000000110107824ULL, 0x000fe200078e0214ULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x0000000112137824ULL, 0x040fe400078e0241ULL, 0x0000000812367824ULL, 0x000fe200078e00ffULL,
0x0000000e170e7210ULL, 0x000fe20007fbe0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee213ULL, 0x0000000112127824ULL, 0x100fe200078e0214ULL,
0x0000005610107212ULL, 0x000fe200078efcffULL, 0x0000000137147824ULL, 0x000fe400078e0214ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000005612127212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x000fe200028e0635ULL,
0x0000001710107210ULL, 0x000fe20007fbe0ffULL, 0x00000008373c7824ULL, 0x000fe200078e00ffULL,
0x0000005614147212ULL, 0x000fc600078efcffULL, 0x0000000111117824ULL, 0x000fe200028e0635ULL,
0x0000001712127210ULL, 0x080fe40007fbe0ffULL, 0x0000001714147210ULL, 0x000fe20007fde0ffULL,
0x0000001034177824ULL, 0x000fe200078e0251ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL,
0x00000010160b7824ULL, 0x000fe400078e0251ULL, 0x0000000113137824ULL, 0x100fe400028e0635ULL,
0x0000000115157824ULL, 0x000fe200030e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000e101c46ULL, 0x0000001036357824ULL, 0x000fc400078e0251ULL,
0x000000103c377824ULL, 0x000fe200078e0251ULL, 0x0000000010177faeULL, 0x0003e8000d901c46ULL,
0x0000000012357faeULL, 0x0003e8000d101c46ULL, 0x0000000014377faeULL, 0x0003e2000c101c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x000000100e0e7812ULL, 0x000fe400078ec0ffULL,
0x000064000b177a11ULL, 0x000fc400078038ffULL, 0x0000000e410f7211ULL, 0x000fe400078fe8ffULL,
0x000065000b357a11ULL, 0x000fe400000f3cffULL, 0x000000040f117810ULL, 0x040fe20007ffe0ffULL,
0x000000010f107824ULL, 0x140fe200078e0241ULL, 0x0000000c0f157810ULL, 0x040fe20007ffe0ffULL,
0x000000080f137824ULL, 0x040fe400078e00ffULL, 0x000000010f0e7824ULL, 0x000fe400078e0214ULL,
0x0000000811347824ULL, 0x000fe200078e00ffULL, 0xfffffff813167812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x000fe200078e0214ULL, 0x000000080f137810ULL, 0x000fe20007ffe0ffULL,
0x00000001110f7824ULL, 0x000fc400078e0241ULL, 0x00000008153c7824ULL, 0x000fe400078e00ffULL,
0x0000000113127824ULL, 0x040fe200078e0214ULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x0000000113117824ULL, 0x140fe400078e0241ULL, 0x0000000813367824ULL, 0x000fe400078e00ffULL,
0x0000000115137824ULL, 0x000fe400078e0241ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fc400078ee211ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000000115147824ULL, 0x000fe200078e0214ULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000e170e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005610107212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000005612127212ULL, 0x000fe400078efcffULL,
0x0000001017107210ULL, 0x000fe20007f5e0ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0635ULL,
0x0000005614147212ULL, 0x000fe200078efcffULL, 0x00000010160b7824ULL, 0x000fe200078e0251ULL,
0x0000001217127210ULL, 0x000fe20007f1e0ffULL, 0x0000000111117824ULL, 0x000fe200010e0635ULL,
0x0000001417147210ULL, 0x000fe20007f7e0ffULL, 0x0000001034177824ULL, 0x000fe200078e0251ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000b901c46ULL,
0x0000000113137824ULL, 0x000fc400000e0635ULL, 0x0000000115157824ULL, 0x000fe200018e0635ULL,
0x0000000010177faeULL, 0x0003e2000b901c46ULL, 0x0000001036357824ULL, 0x100fe400078e0251ULL,
0x000000103c377824ULL, 0x000fc600078e0251ULL, 0x0000000012357faeULL, 0x0003e8000b901c46ULL,
0x0000000014377faeULL, 0x0003e4000b901c46ULL, 0x00000008000b7824ULL, 0x002fe200078e00ffULL,
0x0000000302107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000691000720cULL, 0x000fe40003f06070ULL,
0x000000000b0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000016f108824ULL, 0x000fc400078e0210ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000660010108625ULL, 0x000fca00078e0011ULL, 0x00000006100e8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000b107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480008127f8cULL, 0x000664000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f64c00080b7984ULL, 0x002e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011417ULL,
0x000000160b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x000000020b0b7819ULL, 0x000fc80000001216ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000087824ULL, 0x008fca00078e00ffULL, 0xffffff80080b7812ULL, 0x000fc800078ec0ffULL,
0x0000010056087810ULL, 0x000fca0007ffe00bULL, 0x000000016d087824ULL, 0x000fca00078e0208ULL,
0x00f00000080f7984ULL, 0x000e680000000800ULL, 0x00f2000008127984ULL, 0x0006a20000000800ULL,
0x0000000a0f00720bULL, 0x002fe20003f1d000ULL, 0x0000b5627f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0b177812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e000aULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002710b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0f00720bULL, 0x000fe40003f54000ULL,
0x000000000b00720cULL, 0x000fe20003f05270ULL, 0x0000b5027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0256ULL,
0x0000000a0f0b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991008137816ULL, 0x000fe200000000ffULL, 0x000000016d148824ULL, 0x000fca00078e0214ULL,
0x00f4000b14008388ULL, 0x0003e20000000800ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a0f0b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00167308ULL, 0x000e640000000800ULL, 0x0000001609097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011641ULL,
0x0000b4227f007947ULL, 0x000fea000b800000ULL, 0x00001f0b160b7589ULL, 0x0002e400000e0000ULL,
0x0000000b30307220ULL, 0x08cfe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008410b7811ULL, 0x000fe200078ff0ffULL,
0x0000b3027f007947ULL, 0x000fea000b800000ULL, 0x00001f0b160b7589ULL, 0x00066400000e0000ULL,
0x0000000b32327220ULL, 0x086fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x080fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fe20007806008ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x0000000a0f087209ULL, 0x000fd60007810000ULL,
0x800000080f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff140816ULL, 0x000fc60000000014ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00050308ULL, 0x000e640000000800ULL,
0x0000000512120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000912097221ULL, 0x004fc20000010000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x00000008000f7824ULL, 0x000fca00078e00ffULL, 0xfffffff00f157812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00150f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120a127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0bULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00150f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910140a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011641ULL,
0x00005410060a7816ULL, 0x000fe20000000006ULL, 0x0000aeb27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0a067589ULL, 0x0002a400000e0000ULL, 0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000aee27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0a077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x00007f7000157802ULL, 0x000fc40000000f00ULL,
0x0000b54000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000aULL,
0x00007fc000157802ULL, 0x000fc40000000f00ULL, 0x0000b4f000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010434c7824ULL, 0x100fe200078e0265ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001049447824ULL, 0x000fc400078e0265ULL,
0x000000104a3c7824ULL, 0x100fe400078e0265ULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000001048147824ULL, 0x000fc600078e0265ULL, 0x000000004444783bULL, 0x000ea80000004200ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x000001004c347824ULL, 0x048fe200078e00ffULL, 0x000088804c5b7816ULL, 0x000fe200000000ffULL,
0x000100004d557824ULL, 0x040fe200078e00ffULL, 0x000088804d5d7816ULL, 0x040fe200000000ffULL,
0x000001004e577824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011434ULL,
0x000001004d347824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001144cULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff597819ULL, 0x000fc4000001144dULL,
0x00000018ff547819ULL, 0x000fe20000011434ULL, 0x000100004c347824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011455ULL, 0x00000018ff5e7819ULL, 0x000fe2000001144eULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x00000018ff537819ULL, 0x000fe40000011434ULL,
0x00a000005034783bULL, 0x0002e20000000200ULL, 0x00000018ff647819ULL, 0x000fe4000001144fULL,
0x000088804e557816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4a7819ULL, 0x004fe20000011444ULL,
0x000001004f507824ULL, 0x002fc400078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff497819ULL, 0x000fe40000011445ULL, 0x00000054004c7306ULL, 0x0002a20000200c00ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff437819ULL, 0x000fe40000011446ULL,
0x00000018ff487819ULL, 0x000fe40000011447ULL, 0x00000018ff137819ULL, 0x000fe2000001143cULL,
0x00000053004d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff547819ULL, 0x002fc40000011450ULL,
0x00000018ff427819ULL, 0x000fe4000001143dULL, 0x00000018ff0f7819ULL, 0x000fe4000001143eULL,
0x00000018ff127819ULL, 0x000fe2000001143fULL, 0x0000004e00667306ULL, 0x0007e20000200c00ULL,
0x000088804f537816ULL, 0x044fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe40000011414ULL, 0x00000018ff0a7819ULL, 0x000fc40000011415ULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054105b4e7816ULL, 0x008fe20000000060ULL, 0x0000000634348232ULL, 0x080fe20000000000ULL,
0x00008880445b7816ULL, 0x000fe200000000ffULL, 0x0000000636368232ULL, 0x000fe20000000000ULL,
0x0000888045607816ULL, 0x000fe200000000ffULL, 0x0000000735358232ULL, 0x080fe40000000000ULL,
0x0000004f00507306ULL, 0x0005e20000200c00ULL, 0x0000000737378232ULL, 0x000fe20000000000ULL,
0x00000018ff0d7819ULL, 0x000fc40000011416ULL, 0x00000018ff0c7819ULL, 0x000fc80000011417ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x000054105d4f7816ULL, 0x004fe2000000004cULL,
0x00000100445d7824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x0000004e3430723cULL, 0x000b620000001830ULL, 0x00000018ff447819ULL, 0x000fcc0000011444ULL,
0x00000100454e7824ULL, 0x060fe200078e00ffULL, 0x0000004400627306ULL, 0x0003e20000200c00ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00008880464f7816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000054104d447816ULL, 0x002fce000000005aULL,
0x00000045004d7306ULL, 0x0005f00000200c00ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000054105c457816ULL, 0x004fce0000000059ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x00000044342c723cULL, 0x000b6e000000182cULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000010047447824ULL, 0x020fe200078e00ffULL, 0x000088803c457816ULL, 0x000fc800000000ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004e00617306ULL, 0x0007f00000200c00ULL,
0x0000005b004c7306ULL, 0x0003e20000200c00ULL, 0x00000100464e7824ULL, 0x008fc400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x00008880475b7816ULL, 0x042fe200000000ffULL, 0x0001000047477824ULL, 0x000fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x00000046005a7306ULL, 0x0003f00000200c00ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541055467816ULL, 0x002fce0000000057ULL,
0x0000004700557306ULL, 0x0005f00000200c00ULL, 0x0000005d00637306ULL, 0x000fe20000200c00ULL,
0x0000541053477816ULL, 0x004fe40000000054ULL, 0x000088803d547816ULL, 0x000fca00000000ffULL,
0x00000044005d7306ULL, 0x0003e20000200c00ULL, 0x000000463428723cULL, 0x000bee0000001828ULL,
0x000001003d467824ULL, 0x020fe200078e00ffULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x000001003c447824ULL, 0x002fc400078e00ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004600577306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000003c005f7306ULL, 0x0007e20000200c00ULL, 0x000001003e467824ULL, 0x002fce00078e00ffULL,
0x0000004400537306ULL, 0x0003e20000200c00ULL, 0x00005410663c7816ULL, 0x008fce000000005eULL,
0x0000003d005e7306ULL, 0x0007e20000200c00ULL, 0x000088803e447816ULL, 0x042fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fcc00078e00ffULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00005410503d7816ULL, 0x008fce0000000064ULL, 0x0000003c3424723cULL, 0x000be20000001824ULL,
0x0000004900497306ULL, 0x000e6c0000200c00ULL, 0x000001003f3c7824ULL, 0x020fe200078e00ffULL,
0x00005410603d7816ULL, 0x004fe20000000061ULL, 0x0000004e005c7306ULL, 0x0005e20000200c00ULL,
0x0000010014617824ULL, 0x000fc400078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc6000001143cULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000004f00597306ULL, 0x0007e20000200c00ULL,
0x00000018ff4e7819ULL, 0x004fe40000011446ULL, 0x00000018ff467819ULL, 0x000fe4000001143eULL,
0x00008880143e7816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x000054104d4d7816ULL, 0x002fe20000000049ULL, 0x0000003c00507306ULL, 0x0003e20000200c00ULL,
0x000088803f4f7816ULL, 0x048fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000ffff607224ULL, 0x000fc600078e003eULL,
0x00000018ff477819ULL, 0x000fe2000001143fULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x000054104c3c7816ULL, 0x002fe40000000063ULL, 0x00005410624c7816ULL, 0x000fe4000000004aULL,
0x0000888015627816ULL, 0x000fc600000000ffULL, 0x0000003c343c723cULL, 0x040b620000001820ULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x00a000004b20783bULL, 0x02066c0000000200ULL,
0x0000004c341c723cULL, 0x000b62000000181cULL, 0x0000004800487306ULL, 0x000e6c0000200c00ULL,
0x00000100154d7824ULL, 0x020fc400078e00ffULL, 0x00000060004a7306ULL, 0x0005e20000200c00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0062ULL, 0x00000018ff4d7819ULL, 0x000fca000001144dULL,
0x00000014004b7306ULL, 0x0087e20000200c00ULL, 0x0001000015607824ULL, 0x004fe200078e00ffULL,
0x000054105b157816ULL, 0x000fe4000000005dULL, 0x00008880165b7816ULL, 0x000fc800000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541059147816ULL, 0x008fe4000000005cULL,
0x00000018ff597819ULL, 0x000fca0000011460ULL, 0x000000143438723cULL, 0x000b620000001838ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000000620208232ULL, 0x082fe40000000000ULL,
0x0000000622228232ULL, 0x000fe40000000000ULL, 0x0000000721218232ULL, 0x080fe20000000000ULL,
0x000054105a147816ULL, 0x020fe20000000043ULL, 0x0000000723238232ULL, 0x000fe20000000000ULL,
0x0000541055157816ULL, 0x000fe20000000048ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x000000ffff437224ULL, 0x000fca00078e005bULL, 0x000000143418723cULL, 0x000b640000001818ULL,
0x0000004200427306ULL, 0x000eea0000200c00ULL, 0x0000010016147824ULL, 0x020fe200078e00ffULL,
0x0000541054157816ULL, 0x004fe20000000057ULL, 0x0000010017377824ULL, 0x040fe200078e00ffULL,
0x0000888017367816ULL, 0x040fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x0000001200127306ULL, 0x000fe40000200c00ULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x00000018ff177819ULL, 0x000fc80000011417ULL, 0x0000001400357306ULL, 0x0005f00000200c00ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x0000541045147816ULL, 0x004fce0000000053ULL,
0x000000142030723cULL, 0x000b620000001830ULL, 0x0000006100497306ULL, 0x000eac0000200c00ULL,
0x000054105f147816ULL, 0x022fe40000000013ULL, 0x000054105e157816ULL, 0x008fe20000000042ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541047477816ULL, 0x000fca0000000012ULL,
0x00000014202c723cULL, 0x000b62000000182cULL, 0x000054104a127816ULL, 0x004fe20000000049ULL,
0x0000004d004d7306ULL, 0x000e6a0000200c00ULL, 0x00000018ff157819ULL, 0x020fc60000011437ULL,
0x0000000f000f7306ULL, 0x000ff00000200c00ULL, 0x0000000b000b7306ULL, 0x000ea20000200c00ULL,
0x000054104c137816ULL, 0x002fce000000004dULL, 0x0000000a000a7306ULL, 0x000fe20000200c00ULL,
0x00000012203c723cULL, 0x000b6e000000183cULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x000054104b127816ULL, 0x024fe2000000000bULL, 0x00000002000b7824ULL, 0x000fcc00078e00ffULL,
0x0000000c000c7306ULL, 0x000ff00000200c00ULL, 0x0000004400447306ULL, 0x000ff00000200c00ULL,
0x0000004e004e7306ULL, 0x000e700000200c00ULL, 0x0000004f004f7306ULL, 0x000eb00000200c00ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x00005410444e7816ULL, 0x002fce000000004eULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000054104f4f7816ULL, 0x004fce0000000050ULL,
0x0000004300347306ULL, 0x000ea20000200c00ULL, 0x0000541046467816ULL, 0x008fe2000000000fULL,
0x0000004e2028723cULL, 0x040b6c0000001828ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541059137816ULL, 0x002fe2000000000aULL, 0x000000462024723cULL, 0x000b620000001824ULL,
0x0000f6c86a0a7811ULL, 0x000fca00078e18ffULL, 0x0000001500157306ULL, 0x000e620000200c00ULL,
0x0000541034147816ULL, 0x004fe20000000035ULL, 0x00000012201c723cULL, 0x000b6c000000181cULL,
0x0000001600167306ULL, 0x000eb00000200c00ULL, 0x0000001700177306ULL, 0x000ee20000200c00ULL,
0x0000541036157816ULL, 0x002fc40000000015ULL, 0x0000541016167816ULL, 0x004fca000000000dULL,
0x000000142038723cULL, 0x000b620000001838ULL, 0x0000541017177816ULL, 0x008fe4000000000cULL,
0xfffffff80b0c7812ULL, 0x000fca00078ec0ffULL, 0x000000162018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000a0a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f698000cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0f7224ULL, 0x000fc600078e00ffULL,
0x00000000000c7805ULL, 0x004fc80000015200ULL, 0x0000040004137984ULL, 0x020ea40000000800ULL,
0x8000000013ff7812ULL, 0x006fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001400c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000302027810ULL, 0x000fe40007ffe0ffULL,
0x0000006b0c00720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x00000002400a7810ULL, 0x000fe20007ffe0ffULL, 0x000001000c0d7824ULL, 0x000fe400078e0275ULL,
0x000059000e027a24ULL, 0x010fe200078e02ffULL, 0x0000006b0a00720cULL, 0x000fe40003f06070ULL,
0x000000200d0b7812ULL, 0x000fe200078ec0ffULL, 0x0000004002027824ULL, 0x000fc800078e00ffULL,
0x000000016e0b7824ULL, 0x000fcc00078e020bULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000000d680a7217ULL, 0x000fe20007800000ULL, 0x00000010000c7824ULL, 0x000fc800078e00ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a0dULL, 0x000000100c0d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0c7819ULL, 0x000fe40000011641ULL, 0x0000000a0d0a7217ULL, 0x000fe40007800000ULL,
0x000000040c0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000080c0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0a0dULL, 0x0000000c0c137810ULL, 0x000fe20007ffe0ffULL,
0x000000010e127824ULL, 0x000fc400078e020dULL, 0x000000010f207824ULL, 0x100fe200078e020dULL,
0x0000000a0c00720cULL, 0x0c0fe20003f86070ULL, 0x000000010c0c7824ULL, 0x100fe200078e020dULL,
0x0000000a0e00720cULL, 0x080fe20003f66070ULL, 0x0000000113227824ULL, 0x000fe200078e020dULL,
0x0000000a0f00720cULL, 0x080fe20003f46070ULL, 0x000000010c0e7824ULL, 0x140fe200078e0241ULL,
0x0000000a1300720cULL, 0x000fe20003f06070ULL, 0x000000080c157824ULL, 0x000fe400078e00ffULL,
0x00000001120f7824ULL, 0x000fc400078e0241ULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff815147812ULL, 0x000fe200078ee20eULL, 0x00000001200e7824ULL, 0x000fe200078e020bULL,
0x0000640002157a11ULL, 0x000fe200078a38ffULL, 0x00000001200d7824ULL, 0x000fe200078e0241ULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0000650002177a11ULL, 0x000fe200028f3cffULL, 0x000000010c0c7824ULL, 0x100fe400078e020bULL,
0x00000001120a7824ULL, 0x000fe200078e020bULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x0000000122127824ULL, 0x000fc400078e020bULL, 0x00000001220f7824ULL, 0x040fe400078e0241ULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000560c0c7212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000560a0a7212ULL, 0x000fe400078efcffULL, 0x0000000c150c7210ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000150a0a7210ULL, 0x080fe40007fde0ffULL,
0x000000560e0e7212ULL, 0x080fe200078efcffULL, 0x000000010d0d7824ULL, 0x100fe200028e0617ULL,
0x0000005612127212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe200030e0617ULL,
0x000000150e0e7210ULL, 0x080fe20007fbe0ffULL, 0x0000001016217824ULL, 0x100fe200078e0265ULL,
0x0000001512127210ULL, 0x000fe20007fde0ffULL, 0x0000001014157824ULL, 0x000fc400078e0265ULL,
0x0000001020237824ULL, 0x000fe400078e0265ULL, 0x000000010f0f7824ULL, 0x000fe200028e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c157faeULL, 0x0003e2000e101c46ULL,
0x0000001022657824ULL, 0x000fe400078e0265ULL, 0x0000000113137824ULL, 0x000fe200030e0617ULL,
0x000000000a217faeULL, 0x0003e8000d901c46ULL, 0x000000000e237faeULL, 0x0003e8000d101c46ULL,
0x0000000012657faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000640002157a11ULL, 0x000fc800078038ffULL,
0x000000100a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000650002177a11ULL, 0x000fe400000f3cffULL,
0x0000000a410c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x040fe200078e0241ULL, 0x000000080c167810ULL, 0x040fe20007ffe0ffULL,
0x000000080c147824ULL, 0x040fe200078e00ffULL, 0x0000000c0c207810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0a7824ULL, 0x100fe400078e020bULL, 0x000000010e0c7824ULL, 0x000fe200078e020bULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000010e0d7824ULL, 0x040fe400078e0241ULL,
0x000000080e227824ULL, 0x000fc400078e00ffULL, 0x00000001160e7824ULL, 0x100fe400078e020bULL,
0x0000000120127824ULL, 0x000fe400078e020bULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x00000001160f7824ULL, 0x000fe200078e0241ULL, 0x000000560a0a7212ULL, 0x000fe200078efcffULL,
0x0000000816347824ULL, 0x000fe200078e00ffULL, 0xfffffff822167812ULL, 0x000fe200078ee20dULL,
0x0000000120137824ULL, 0x040fe200078e0241ULL, 0x0000000a150a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000820367824ULL, 0x000fe200078e00ffULL, 0xfffffff834207812ULL, 0x000fe200078ee20fULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff836227812ULL, 0x000fe200078ee213ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000560c0c7212ULL, 0x000fc600078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000560e0e7212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x000fe200000e0617ULL, 0x0000005612127212ULL, 0x000fe200078efcffULL,
0x0000001016217824ULL, 0x100fe200078e0265ULL, 0x0000000c150c7210ULL, 0x040fe20007f1e0ffULL,
0x0000001020237824ULL, 0x100fe200078e0265ULL, 0x0000000e150e7210ULL, 0x040fe40007f5e0ffULL,
0x0000001215127210ULL, 0x000fe20007f7e0ffULL, 0x0000001014157824ULL, 0x000fe400078e0265ULL,
0x000000010d0d7824ULL, 0x000fc400000e0617ULL, 0x000000010f0f7824ULL, 0x000fe200010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e2000b901c46ULL,
0x0000001022657824ULL, 0x000fe400078e0265ULL, 0x0000000113137824ULL, 0x000fe200018e0617ULL,
0x000000000c217faeULL, 0x0003e8000b901c46ULL, 0x000000000e237faeULL, 0x0003e8000b901c46ULL,
0x0000000012657faeULL, 0x0003e4000b901c46ULL, 0x000000046c027810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff0e7424ULL, 0x002fc400078e00ffULL,
0x000000690200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000016f0e7824ULL, 0x000fe400078e0202ULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000066000e0e7625ULL, 0x000fcc00078e000fULL, 0x000000060e0e7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008000a7824ULL, 0x000fca00078e00ffULL,
0xfffffff00a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000a0c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f66800030a7f8cULL, 0x004464000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00f66c00030f7984ULL, 0x002e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014120f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e13ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x008fc80000011414ULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0614ULL, 0x000000020c0c7819ULL, 0x000fc8000000120fULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c00030f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180710a7811ULL, 0x000fc800078e38ffULL,
0x0000000a6d0a7210ULL, 0x000fca0007ffe056ULL, 0x00f000000a0f7984ULL, 0x000e680000000800ULL,
0x00f200000a0c7984ULL, 0x0086a20000000800ULL, 0x000000080f00720bULL, 0x002fe20003f1d000ULL,
0x000090927f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0b137812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fd200078e0008ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000003710b7810ULL, 0x000fe40007ffe0ffULL,
0x000000080f00720bULL, 0x000fe40003f54000ULL, 0x000000000b00720cULL, 0x000fe20003f05270ULL,
0x000090327f007947ULL, 0x000fd4000b800000ULL, 0x00000000000a7806ULL, 0x000fc400010e0100ULL,
0x0000008000568824ULL, 0x000fe200078e0256ULL, 0x000000080f0b8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100a127816ULL, 0x000fe200000000ffULL,
0x000000016d568824ULL, 0x000fca00078e0256ULL, 0x00f4000b56008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080f0b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL, 0x000000080b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00127308ULL, 0x000e640000000800ULL,
0x0000001209097220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011641ULL, 0x00008f527f007947ULL, 0x000fea000b800000ULL,
0x00001f0b120b7589ULL, 0x0002e400000e0000ULL, 0x0000000b30307220ULL, 0x08cfe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b24247220ULL, 0x080fe20000410000ULL,
0x0000000b25257220ULL, 0x080fe20000410000ULL, 0x0000000b3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000b3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b38387220ULL, 0x080fe20000410000ULL,
0x0000000b39397220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008410b7811ULL, 0x000fe200078ff0ffULL, 0x00008e327f007947ULL, 0x000fea000b800000ULL,
0x00001f0b120b7589ULL, 0x00066400000e0000ULL, 0x0000000b32327220ULL, 0x086fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000b3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fe2000780600aULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x000000080f0a7209ULL, 0x000fd60007810000ULL, 0x8000000a0f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff0b0816ULL, 0x000fc6000000000bULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00050308ULL, 0x000e640000000800ULL, 0x000000050c0c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000090c097221ULL, 0x004fc20000010000ULL,
0x0000000000127805ULL, 0x008fcc0000015200ULL, 0x0000000800087824ULL, 0x000fca00078e00ffULL,
0xfffffff0080c7812ULL, 0x000fca00078ec0ffULL, 0x00f6b4000c0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014120f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e13ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011414ULL, 0x0000000f08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0614ULL, 0x0000000208087819ULL, 0x000fc8000000120fULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b4000c0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100b087816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011641ULL, 0x0000541006087816ULL, 0x000fe20000000006ULL,
0x000089e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0f08067589ULL, 0x0002a400000e0000ULL,
0x000000080f0b7810ULL, 0x000fe20007ffe0ffULL, 0x00008a127f007947ULL, 0x000fea000b800000ULL,
0x00001f0b08077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x0000a60000157802ULL, 0x000fc40000000f00ULL, 0x00008eb000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0000a65000157802ULL, 0x000fc40000000f00ULL,
0x00008e6000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000800714f7824ULL, 0x040fe200078e0267ULL,
0x0000000371207810ULL, 0x000fc40007ffe0ffULL, 0x000000005858783bULL, 0x000ee20000004200ULL,
0x00000008410c7812ULL, 0x000fc400078ec0ffULL, 0x0000000741647812ULL, 0x000fe200078ec0ffULL,
0x000000005214783bULL, 0x000ea20000004200ULL, 0x000000070c0f7812ULL, 0x102fe400078ef841ULL,
0x0000000864647812ULL, 0x000fe400078ef841ULL, 0x0000000270707810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0c7824ULL, 0x000fe400078e00ffULL, 0x0000010058087824ULL, 0x048fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe20000011458ULL, 0x00000100590b7824ULL, 0x004fe200078e00ffULL,
0x0000888058487816ULL, 0x040fe200000000ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fc40000011408ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fe4000001145bULL,
0x000088805b4b7816ULL, 0x000fe400000000ffULL, 0x00000018ff237819ULL, 0x000fe40000011458ULL,
0x00000018ff627819ULL, 0x000fe20000011459ULL, 0x00000008004c7306ULL, 0x0003e20000200c00ULL,
0x0000888059217816ULL, 0x040fe200000000ffULL, 0x0001000059597824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc4000001145aULL, 0x000088805a467816ULL, 0x040fe400000000ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000000b00477306ULL, 0x0005e20000200c00ULL,
0x000001005a087824ULL, 0x042fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011414ULL,
0x000100005a5a7824ULL, 0x000fe200078e00ffULL, 0x00008880145c7816ULL, 0x000fe400000000ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000005900637306ULL, 0x0003e20000200c00ULL,
0x000001005b0b7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe20000011415ULL,
0x000100005b5b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fc40000011416ULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000000800677306ULL, 0x0005e20000200c00ULL,
0x00000018ff587819ULL, 0x000fe4000001145bULL, 0x00000018ff597819ULL, 0x002fe4000001145aULL,
0x00000018ff437819ULL, 0x000fe40000011417ULL, 0x00008880155a7816ULL, 0x000fe200000000ffULL,
0x0000000b00667306ULL, 0x0003e20000200c00ULL, 0x0000010014087824ULL, 0x004fe200078e00ffULL,
0x0000888016537816ULL, 0x000fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000888017567816ULL, 0x000fc400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011408ULL,
0x0000000400087824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000100150b7824ULL, 0x042fe200078e00ffULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000000408087812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001140bULL, 0x0000000208087812ULL, 0x000fc400078efcffULL,
0x00000014005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000000841087211ULL, 0x000fca00078fe0ffULL, 0x000000010f0b7824ULL, 0x040fe200078e0208ULL,
0x00000015005f7306ULL, 0x000fe20000200c00ULL, 0x000000100f0f7812ULL, 0x000fc600078efcffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x00000100160b7824ULL, 0x040fe400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x000000100c0c7824ULL, 0x000fe200078e0251ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x000000010f087824ULL, 0x040fe200078e0208ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000000c34783bULL, 0x0004e40000004200ULL,
0x00000016006d7306ULL, 0x000fe40000200c00ULL, 0xfffffff80f087812ULL, 0x000fe200078ee208ULL,
0x00000100170c7824ULL, 0x004fc400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000001008087824ULL, 0x000fe200078e0251ULL,
0x0000541021217816ULL, 0x002fe40000000047ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x000000000810783bULL, 0x000e620000004200ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x00000017006c7306ULL, 0x0005f00000200c00ULL, 0x0000006200627306ULL, 0x000e700000200c00ULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x0000010034147824ULL, 0x008fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011435ULL, 0x0000010035547824ULL, 0x040fe200078e00ffULL,
0x0000888035517816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011414ULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x00a800004f14783bULL, 0x0044e20000000200ULL, 0x00000018ff497819ULL, 0x000fe40000011434ULL,
0x0000888034527816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000008644f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff447819ULL, 0x000fe40000011436ULL, 0xfffffff84f4f7812ULL, 0x000fe400078ee270ULL,
0x0000003500647306ULL, 0x0005e20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000008020707824ULL, 0x000fe200078e024fULL, 0x0000541048207816ULL, 0x000fe2000000004cULL,
0x00000100364c7824ULL, 0x040fe200078e00ffULL, 0x00008880364f7816ULL, 0x040fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000900070707811ULL, 0x000fe200078e20ffULL,
0x0000010037357824ULL, 0x004fe200078e00ffULL, 0x0000003400657306ULL, 0x0005e20000200c00ULL,
0x00000018ff0f7819ULL, 0x002fc40000011411ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff477819ULL, 0x000fe2000001144cULL,
0x0000004f00487306ULL, 0x000fe20000200c00ULL, 0x0000541023347816ULL, 0x004fe40000000022ULL,
0x00000018ff457819ULL, 0x000fe40000011437ULL, 0x00008880374c7816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000000614148232ULL, 0x088fe20000000000ULL,
0x00000035004f7306ULL, 0x0003e20000200c00ULL, 0x0000000616168232ULL, 0x000fe20000000000ULL,
0x00000018ff087819ULL, 0x000fe20000011413ULL, 0x0000000715158232ULL, 0x080fe20000000000ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000000717178232ULL, 0x000fc60000000000ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541063357816ULL, 0x002fc60000000062ULL,
0x000000201430723cULL, 0x040b640000001830ULL, 0x000000007020783bULL, 0x0202a40000000200ULL,
0x0000005900597306ULL, 0x000ee80000200c00ULL, 0x00000034142c723cULL, 0x000b62000000182cULL,
0x0000888010707816ULL, 0x002fc600000000ffULL, 0x0000005800587306ULL, 0x000e660000200c00ULL,
0x0000541046347816ULL, 0x020fe20000000067ULL, 0x0000010010677824ULL, 0x000fe200078e00ffULL,
0x000054104b357816ULL, 0x000fc60000000066ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc60000011467ULL, 0x000000341428723cULL, 0x000b680000001828ULL,
0x0000005b005b7306ULL, 0x000fe60000200c00ULL, 0x0000541059347816ULL, 0x028fe40000000061ULL,
0x0000541058357816ULL, 0x002fc60000000060ULL, 0x0000005a005a7306ULL, 0x000fe80000200c00ULL,
0x000000341424723cULL, 0x000b620000001824ULL, 0x0000000620208232ULL, 0x004fc60000000000ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000000622228232ULL, 0x000fe40000000000ULL,
0x0000010011347824ULL, 0x020fe200078e00ffULL, 0x0000000721218232ULL, 0x080fe40000000000ULL,
0x0000000723238232ULL, 0x000fe40000000000ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fce0000011434ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054105a357816ULL, 0x002fce000000005dULL, 0x0000000c00577306ULL, 0x0003f00000200c00ULL,
0x0000003400597306ULL, 0x0007e20000200c00ULL, 0x00000018ff0c7819ULL, 0x002fe20000011410ULL,
0x0001000010107824ULL, 0x000fca00078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000054105c347816ULL, 0x008fce000000005bULL,
0x0000000b00557306ULL, 0x0002e20000200c00ULL, 0x000000342030723cULL, 0x000bee0000001830ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x0001000011357824ULL, 0x020fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x002fcc0000011412ULL, 0x0000003600637306ULL, 0x0003f00000200c00ULL,
0x00000010005a7306ULL, 0x0007e20000200c00ULL, 0x0000888011367816ULL, 0x002fe400000000ffULL,
0x000054105f117816ULL, 0x004fc4000000004eULL, 0x00008880124e7816ULL, 0x000fe200000000ffULL,
0x000000ffff587224ULL, 0x000fe400078e0036ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000054105e107816ULL, 0x008fe4000000004dULL, 0x00000018ff4d7819ULL, 0x000fca0000011435ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00000010202c723cULL, 0x000bee000000182cULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000541053107816ULL, 0x020fe40000000055ULL,
0x0000541056117816ULL, 0x000fca0000000057ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000541052347816ULL, 0x002fe20000000050ULL, 0x000000102028723cULL, 0x000bec0000001828ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000010012107824ULL, 0x060fe400078e00ffULL,
0x0001000012127824ULL, 0x000fca00078e00ffULL, 0x0000004a004a7306ULL, 0x000ee20000200c00ULL,
0x0000541051357816ULL, 0x004fe40000000054ULL, 0x00000018ff517819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fc60000011412ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541065107816ULL, 0x002fce0000000049ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541064117816ULL, 0x008fce000000004aULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000010141c723cULL, 0x000bee000000181cULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000010013117824ULL, 0x020fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000003700627306ULL, 0x0004e20000200c00ULL, 0x0000541063447816ULL, 0x002fce0000000044ULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x000000341434723cULL, 0x004b6e000000183cULL,
0x00008880133c7816ULL, 0x060fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000054104c3d7816ULL, 0x000fe2000000004fULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x0000541062457816ULL, 0x008fe20000000045ULL, 0x000000ffff107224ULL, 0x000fe200078e003cULL,
0x00005410483c7816ULL, 0x000fc40000000047ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x000054106d427816ULL, 0x002fe20000000042ULL, 0x0000000c000c7306ULL, 0x000e640000200c00ULL,
0x0000003c143c723cULL, 0x040f6c0000001838ULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x000054106c437816ULL, 0x004fe20000000043ULL, 0x000000441414723cULL, 0x000b6c0000001818ULL,
0x0000007000467306ULL, 0x000fe20000200c00ULL, 0x000054105a4c7816ULL, 0x002fe2000000000cULL,
0x000000422038723cULL, 0x000b6c0000001824ULL, 0x0000004b004b7306ULL, 0x000e700000200c00ULL,
0x0000005800587306ULL, 0x000eb00000200c00ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x0000541046467816ULL, 0x002fce000000004bULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541058477816ULL, 0x004fce0000000059ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x000054104d4d7816ULL, 0x008fe2000000000fULL, 0x000000462034723cULL, 0x040b6c0000001834ULL,
0x0000001000107306ULL, 0x000fe40000200c00ULL, 0x0000004c201c723cULL, 0x000b6c000000181cULL,
0x0000001100117306ULL, 0x000ea20000200c00ULL, 0x000054104e187816ULL, 0x022fce0000000051ULL,
0x0000000b000b7306ULL, 0x000ff00000200c00ULL, 0x0000000800087306ULL, 0x000fe20000200c00ULL,
0x0000541010197816ULL, 0x004fce0000000011ULL, 0x0000001200127306ULL, 0x000e620000200c00ULL,
0x000000182018723cULL, 0x000b6e000000183cULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541012127816ULL, 0x002fe4000000000bULL, 0x0000541013137816ULL, 0x004fce0000000008ULL,
0x000000122020723cULL, 0x000b620000001814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000004107f8cULL, 0x0002a2000c80043fULL, 0x0000000140407810ULL, 0x000fe40007ffe0ffULL,
0x0000f6a0710b7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000bff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff087224ULL, 0x004fe200078e0011ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff627000007947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x008fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000009027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b79000057802ULL, 0x002fc40000000f00ULL,
0x00007b5000007944ULL, 0x034fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900047308ULL, 0x002e640000001000ULL, 0xbf80000004027423ULL, 0x002fc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ee8000c1e9900ULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000808057811ULL, 0x004fe200078ff0ffULL,
0x0000000403067220ULL, 0x008fca0000410000ULL, 0x00001f0706047589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000003004307220ULL, 0x042fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x060fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x000fe20000410000ULL, 0x0000003205327220ULL, 0x044fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x000fc20000410000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000100000077824ULL, 0x002fe200078e00ffULL, 0x0000001c1d1c723eULL, 0x000fc400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000181918723eULL, 0x020fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000003a3b15723eULL, 0x000fc400000000ffULL,
0x000000363736723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x000054102a147816ULL, 0x000fe40000000015ULL,
0x00000002ff067819ULL, 0x008fe40000011602ULL, 0x0000000202037812ULL, 0x000fc400078ec0ffULL,
0x0000000802087811ULL, 0x000fe200078ff0ffULL, 0x00000008060d7824ULL, 0x004fe200078e00ffULL,
0x0000000603047211ULL, 0x040fe400078ff8ffULL, 0x0000000803057211ULL, 0x000fe200078ff8ffULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0x0000000204037810ULL, 0x000fe20007ffe0ffULL,
0x0000000806087824ULL, 0x000fe200078e00ffULL, 0x000076322a157816ULL, 0x000fe40000000015ULL,
0xfffffff80a0f7812ULL, 0x000fe200078ee205ULL, 0x0000000806057824ULL, 0x000fe200078e00ffULL,
0xfffffff808097812ULL, 0x000fe200078ee203ULL, 0x00000008060a7824ULL, 0x000fe200078e00ffULL,
0x0000100007037812ULL, 0x000fe200078ee2ffULL, 0x0000000802067824ULL, 0x000fe200078e00ffULL,
0x0000000404077810ULL, 0x000fc40007ffe0ffULL, 0x0000000604087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff805057812ULL, 0x000fe200078ee204ULL, 0x000008006a047824ULL, 0x000fe200078e0203ULL,
0xfffffff80a0b7812ULL, 0x000fe400078ee207ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL,
0x000000100f107824ULL, 0x100fe200078e0204ULL, 0x0000000806077812ULL, 0x000fe200078ec0ffULL,
0x0000001005067824ULL, 0x100fe200078e0204ULL, 0x0000002c2d05723eULL, 0x000fe200000000ffULL,
0x00000010090a7824ULL, 0x100fe200078e0204ULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000000100b0c7824ULL, 0x000fc400078e0204ULL, 0x000000100d0e7824ULL, 0x010fe200078e0204ULL,
0x000000303104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000343506723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000541004127816ULL, 0x140fe20000000005ULL, 0x0000000107097824ULL, 0x040fe200078e020cULL,
0x0000763204137816ULL, 0x000fe20000000005ULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000282904723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000383905723eULL, 0x000fe200000000ffULL, 0x0000001208007388ULL, 0x0003e20000000a00ULL,
0x00000020210c723eULL, 0x000fc400000000ffULL, 0x00000022230d723eULL, 0x000fe400000000ffULL,
0x0000763218077816ULL, 0x000fe4000000000cULL, 0x0000541004127816ULL, 0x142fe40000000005ULL,
0x0000763204137816ULL, 0x000fe40000000005ULL, 0x000000323304723eULL, 0x000fe400000000ffULL,
0x0000002e2f05723eULL, 0x000fe200000000ffULL, 0x000000120a007388ULL, 0x0003e40000000a00ULL,
0x0000541006127816ULL, 0x002fc4000000001cULL, 0x0000763206137816ULL, 0x000fe4000000001cULL,
0x0000541018067816ULL, 0x000fe4000000000cULL, 0x000054101a0c7816ULL, 0x140fe2000000000dULL,
0x0000001209007388ULL, 0x000fe20000000a00ULL, 0x000076321a0d7816ULL, 0x000fc6000000000dULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541004067816ULL, 0x142fe40000000005ULL,
0x0000763204077816ULL, 0x000fe20000000005ULL, 0x0000000175047824ULL, 0x000fc800078e0202ULL,
0x0000000610007388ULL, 0x0003e20000000a00ULL, 0x0000001004047824ULL, 0x000fc600078e0203ULL,
0x000400140a007388ULL, 0x000fe20000000a00ULL, 0x0000541036067816ULL, 0x142fe4000000001eULL,
0x0000763236077816ULL, 0x000fca000000001eULL, 0x0004000609007388ULL, 0x000fe80000000a00ULL,
0x0004000c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004107984ULL, 0x000e680000000c00ULL, 0x0004000004187984ULL, 0x000ea80000000c00ULL,
0x0008000004147984ULL, 0x000ee80000000c00ULL, 0x000c0000041c7984ULL, 0x000ee20000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x004fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x008fe40000000000ULL, 0x0000001612127230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000001004007388ULL, 0x000fe20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001804007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011602ULL, 0x000000730900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff107a12ULL, 0x000fe400078e33ffULL,
0x00000001000f7812ULL, 0x000fe400078ec0ffULL, 0x0000002002007810ULL, 0x000fe40007ffe0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705117227ULL, 0x000fc800078e0004ULL,
0x0000000176047824ULL, 0x000fc800078e0209ULL, 0x0000000411077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005067a24ULL, 0x000fe400078e0204ULL,
0x0000000109057824ULL, 0x000fc600078e0202ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x0000000705057812ULL, 0x000fd600078ec0ffULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x0ffffff805067812ULL, 0x000fe400078ef802ULL, 0x00005a00ff007a0cULL, 0x000fc60003f05070ULL,
0x0000001006067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000107071810ULL, 0x000fc80007ffe0ffULL, 0x0000000710077207ULL, 0x000fe40004000000ULL,
0x0000000702067812ULL, 0x002fc600078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe400078e0272ULL, 0x00005a000d047a24ULL, 0x000fe200078e0204ULL,
0x00000003ff0d7819ULL, 0x000fe20000011600ULL, 0x000000080f077824ULL, 0x000fe400078e0206ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x0000000574057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000730d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe200078e020dULL,
0x00000040020c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x0000000411057227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007067a24ULL, 0x000fca00078e0204ULL,
0x00005a0006007a0cULL, 0x000fda0003f26070ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d067812ULL, 0x000fe400078ef800ULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe400078e0272ULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x000000080f077824ULL, 0x000fe400078e0200ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x0000000574057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x000000730d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176007824ULL, 0x100fe400078e020dULL, 0x000000010c0d7824ULL, 0x000fe400078e020dULL,
0x0000000011057227ULL, 0x002fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x0000000510057207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a05ULL, 0x0000590005057a24ULL, 0x000fe400078e0272ULL,
0x00005a0007007a24ULL, 0x000fe400078e0200ULL, 0x000000080f077824ULL, 0x000fe400078e020cULL,
0x00005a0005057a24ULL, 0x000fe200078e0200ULL, 0x0000006002007810ULL, 0x000fc80007ffe0ffULL,
0x0000000574057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff0d7819ULL, 0x000fc60000011600ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078240ffULL,
0x0000000176767824ULL, 0x000fc600078e020dULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x000000730d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007611057227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e0276ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0203ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005037a24ULL, 0x000fe400078e0272ULL, 0x00005a0007767a24ULL, 0x000fe400078e0276ULL,
0x000000080f057824ULL, 0x000fe400078e0200ULL, 0x00005a0003037a24ULL, 0x000fca00078e0276ULL,
0x0000000374037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000690000720cULL, 0x000fe20003f06070ULL,
0xffffffffff5e7424ULL, 0x000fd800078e00ffULL, 0x0000000204078824ULL, 0x000fc800078e00ffULL,
0x00006a0007088a24ULL, 0x002fc800078e0200ULL, 0x0000660008088625ULL, 0x000fe200078e0065ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff627624ULL, 0x000fe200078e00ffULL,
0x00000006085e8981ULL, 0x000ea2000c1e1900ULL, 0x00006f00ff637624ULL, 0x000fc600078e00ffULL,
0x00f60000ff067f8cULL, 0x000e68000c80043fULL, 0x0000000662627981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00005800ff707624ULL, 0x000fe400078e00ffULL,
0x0000004071717824ULL, 0x000fe400078e00ffULL, 0x0000004000757824ULL, 0x000fe200078e00ffULL,
0x0000001f70707810ULL, 0x000fe20007ffe0ffULL, 0x0000004072027824ULL, 0x000fc600078e00ffULL,
0x00000005ff707819ULL, 0x000fe20000011670ULL, 0x000000715e217224ULL, 0x004fe400078e02ffULL,
0x0000062000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011641ULL,
0x00006400211f7a11ULL, 0x000fe400078038ffULL, 0x000000081d0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000004072727824ULL, 0x000fe200078e021dULL, 0x0000650021217a11ULL, 0x000fe400000f3cffULL,
0x00000041410e7211ULL, 0x000fe200078fe8ffULL, 0x0000008072087825ULL, 0x040fe200078e00ffULL,
0x00000008720a7810ULL, 0x000fc40007ffe0ffULL, 0x00000010720c7810ULL, 0x000fe40007ffe0ffULL,
0x0000003008107812ULL, 0x100fe200078ef805ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000030e167812ULL, 0x000fe400078ec0ffULL, 0x000000101f107210ULL, 0x000fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a127812ULL, 0x000fe400078ef805ULL,
0x00000075680a7217ULL, 0x000fe20007800000ULL, 0x0000000109117824ULL, 0x000fe200000e0621ULL,
0x0000001f12127210ULL, 0x000fc40007f3e0ffULL, 0x0000100000187811ULL, 0x000fe200078e68ffULL,
0x000000010a147824ULL, 0x000fe200078e0a75ULL, 0x00000028720e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b137824ULL, 0x000fe200008e0621ULL, 0x0ffffffc16417812ULL, 0x000fe400078ef841ULL,
0x000000140f00720cULL, 0x0c0fe20003f26070ULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x000000141d00720cULL, 0x000fe20003f06070ULL, 0x0000001041417824ULL, 0x000fe200078e0218ULL,
0x000000300c087812ULL, 0x000fc400078ef805ULL, 0xfffffffc0f0f7812ULL, 0x000fe400078ee216ULL,
0x0000001f08087210ULL, 0x000fe40007f5e0ffULL, 0x00000020720c7810ULL, 0x040fe20007ffe0ffULL,
0x000000100f157824ULL, 0x000fe200078e0218ULL, 0x00000018720b7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000101d237810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010417faeULL, 0x0003e2000c101c46ULL,
0x000000181d257810ULL, 0x000fe20007ffe0ffULL, 0x000000010d097824ULL, 0x000fe200010e0621ULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x0000000012157faeULL, 0x0005e2000c901c46ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000201d177810ULL, 0x000fc40007ffe0ffULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x100fe400078ef805ULL, 0x0000003872107810ULL, 0x002fe20007ffe0ffULL,
0x0000000419277824ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe400078ef805ULL,
0x0000001f0e127210ULL, 0x084fe20007fde0ffULL, 0x0000000423157824ULL, 0x000fe200078e00ffULL,
0x00000030720e7810ULL, 0x000fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001f0c0c7210ULL, 0x000fc40007f7e0ffULL, 0x0000001f0a0a7210ULL, 0x080fe20007f5e0ffULL,
0x000000010f137824ULL, 0x000fe200030e0621ULL, 0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000381d1d7810ULL, 0x000fe40007ffe0ffULL,
0x000000142500720cULL, 0x0c0fe20003f86070ULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x000000010d0d7824ULL, 0x100fe200018e0621ULL,
0x000000142300720cULL, 0x080fe20003fa6070ULL, 0x0000000417237824ULL, 0x040fe200078e00ffULL,
0x000000141700720cULL, 0x080fe20003f66070ULL, 0x000000010b0b7824ULL, 0x000fe200010e0621ULL,
0x000000141d00720cULL, 0x080fe20003f06070ULL, 0x000000041b297824ULL, 0x000fe200078e00ffULL,
0x0000001f0e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0x000000141900720cULL, 0x000fc40003f46070ULL, 0xfffffffc15157812ULL, 0x100fe200078ee216ULL,
0x000000010f0f7824ULL, 0x000fe200030e0621ULL, 0x000000141b00720cULL, 0x000fe40003f26070ULL,
0xfffffffc25177812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x000fe200078e0218ULL,
0x0000003010107812ULL, 0x000fe400078ef805ULL, 0xfffffffc23197812ULL, 0x000fe200078ee216ULL,
0x0000001017177824ULL, 0x000fe200078e0218ULL, 0xfffffffc271b7812ULL, 0x100fe200078ee216ULL,
0x0000000008157faeULL, 0x0003e2000e901c46ULL, 0xfffffffc29057812ULL, 0x000fe200078ee216ULL,
0x0000001019197824ULL, 0x000fe200078e0218ULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee216ULL,
0x000000101b1b7824ULL, 0x100fe200078e0218ULL, 0x0000001f10107210ULL, 0x000fe20007fde0ffULL,
0x0000001005057824ULL, 0x100fe200078e0218ULL, 0x000000000a177faeULL, 0x0003e2000e101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e0218ULL, 0x0000000111117824ULL, 0x000fe200030e0621ULL,
0x000000000c197faeULL, 0x0003e8000d901c46ULL, 0x00000000121b7faeULL, 0x0003e8000d101c46ULL,
0x000000000e057faeULL, 0x0003e8000c901c46ULL, 0x00000000101d7faeULL, 0x0003e2000c101c46ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x0000000841177811ULL, 0x04afe400078ff0ffULL,
0x00000010410b7811ULL, 0x000fc400078ff0ffULL, 0x0000004141097211ULL, 0x000fe200078fe8ffULL,
0x0000000417197824ULL, 0x000fe200078e00ffULL, 0x00000018410d7811ULL, 0x000fe200078ff0ffULL,
0x000000040b1b7824ULL, 0x000fe200078e00ffULL, 0x00000020410f7811ULL, 0x040fe400078ff0ffULL,
0x0000002841117811ULL, 0x000fe200078ff0ffULL, 0x000000040d1d7824ULL, 0x000fe200078e00ffULL,
0x0000003041137811ULL, 0x000fe200078ff0ffULL, 0x000000040f1f7824ULL, 0x000fe200078e00ffULL,
0x0000003841157811ULL, 0x000fe200078ff0ffULL, 0x0000000411237824ULL, 0x000fe200078e00ffULL,
0x0000000309167812ULL, 0x000fe200078ec0ffULL, 0x0000000413297824ULL, 0x000fe200078e00ffULL,
0x0000000241087211ULL, 0x000fe200078ff0ffULL, 0x00000004152b7824ULL, 0x000fe200078e00ffULL,
0x0000100000257811ULL, 0x000fc400078e68ffULL, 0xfffffffc190a7812ULL, 0x100fe200078ee216ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b0c7812ULL, 0x100fe400078ee216ULL,
0xfffffffc1d0e7812ULL, 0x100fe200078ee216ULL, 0x000000100a197824ULL, 0x100fe200078e0225ULL,
0xfffffffc1f107812ULL, 0x100fe200078ee216ULL, 0x000000100c1b7824ULL, 0x000fe200078e0225ULL,
0x0000640021277a11ULL, 0x000fe200078038ffULL, 0x00000001020a7824ULL, 0x000fe200078e0217ULL,
0xfffffffc23127812ULL, 0x100fe200078ee216ULL, 0x000000100e1d7824ULL, 0x000fe200078e0225ULL,
0x0ffffffc16417812ULL, 0x000fe200078ef841ULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0xfffffffc29147812ULL, 0x100fe200078ee216ULL, 0x00000010101f7824ULL, 0x000fe200078e0225ULL,
0xfffffffc2b167812ULL, 0x000fe200078ee216ULL, 0x00000001020e7824ULL, 0x000fe200078e020dULL,
0x0000650021297a11ULL, 0x000fe200000f3cffULL, 0x0000001012217824ULL, 0x000fe200078e0225ULL,
0x0000003008087812ULL, 0x000fe200078ef805ULL, 0x0000000102107824ULL, 0x000fc400078e020fULL,
0x0000001041417824ULL, 0x100fe200078e0225ULL, 0x0000000827087210ULL, 0x000fe20007f1e0ffULL,
0x0000001014237824ULL, 0x000fe400078e0225ULL, 0x0000000102127824ULL, 0x000fe400078e0211ULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000001016257824ULL, 0x000fe200078e0225ULL,
0x000000300a0a7812ULL, 0x000fe200078ef805ULL, 0x0000000102147824ULL, 0x000fe400078e0213ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000000102167824ULL, 0x000fe200078e0215ULL,
0x000000300c0c7812ULL, 0x000fe200078ef805ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000c270c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x000fc600078ef805ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003010107812ULL, 0x100fe400078ef805ULL, 0x0000000e270e7210ULL, 0x040fe20007f5e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003012127812ULL, 0x100fe400078ef805ULL,
0x0000001027107210ULL, 0x040fe20007f7e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014147812ULL, 0x000fe400078ef805ULL, 0x0000001227127210ULL, 0x000fe20007f9e0ffULL,
0x0000000109097824ULL, 0x100fe200000e0629ULL, 0x0000000a270a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0d7824ULL, 0x000fe200008e0629ULL, 0x0000003016057812ULL, 0x000fe200078ef805ULL,
0x000000010f0f7824ULL, 0x100fe200010e0629ULL, 0x0000001427147210ULL, 0x000fe20007fbe0ffULL,
0x000000010b0b7824ULL, 0x100fe200000e0629ULL, 0x0000000527167210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x100fe200018e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008417faeULL, 0x0003e2000b901c46ULL, 0x0000000113137824ULL, 0x000fc400020e0629ULL,
0x0000000115157824ULL, 0x100fe200028e0629ULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x0000000117177824ULL, 0x000fc600030e0629ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x00f60400ff057984ULL, 0x000e620000000800ULL,
0x0000007003647224ULL, 0x000fc400078e02ffULL, 0x0000000168737824ULL, 0x000fe200078e0a6cULL,
0x8000000005ff7812ULL, 0x002fe20007804807ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620064647625ULL, 0x000fe200078e0065ULL, 0x00000008ff737819ULL, 0x000fe20000011673ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140bULL, 0x0000000a03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000203037819ULL, 0x000fc8000000120aULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000037824ULL, 0x002fca00078e0203ULL, 0x00000003ff057819ULL, 0x000fc80000011603ULL,
0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL, 0x0000000f03057812ULL, 0x000fc600078ec0ffULL,
0x0000000103067824ULL, 0x000fe400078e0206ULL, 0x0000001005087824ULL, 0x040fe400078e00ffULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f06037812ULL, 0x040fe400078ec0ffULL,
0x0000000106067810ULL, 0x000fe40007ffe0ffULL, 0x000000f008037812ULL, 0x000fe400078ee203ULL,
0x0000000f06067812ULL, 0x000fc600078ec0ffULL, 0x00000000030c7984ULL, 0x000e62000000cc00ULL,
0x000000f005067812ULL, 0x000fca00078ee206ULL, 0x0000000006087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001003007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff057224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x002fc80000015200ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6b00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00006a0004727a24ULL, 0x000fe200078e02ffULL, 0x3db504f362627820ULL, 0x010fe20000410000ULL,
0x0000000270707824ULL, 0x000fe200078e00ffULL, 0x0000f68800747811ULL, 0x000fe200078e18ffULL,
0x000000ffff5f7224ULL, 0x000fe200078e00ffULL, 0xffffffff6c6e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x000000096c6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e0000ULL, 0x0000f60800777811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0004ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x01cfc4000001ff00ULL, 0x000000010600780cULL, 0x040fe20003f25270ULL,
0x00000c0000007945ULL, 0x000fe20003800000ULL, 0x000000015f087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e0006ULL, 0x0000000106097810ULL, 0x000fe20007ffe0ffULL,
0x000000715e1e7224ULL, 0x030fc600078e02ffULL, 0x000000020900780cULL, 0x040fe20003f06070ULL,
0x000000ffff067224ULL, 0x000fe200078e0009ULL, 0x000000ff090b7207ULL, 0x000fc60000800000ULL,
0x000000ffff081224ULL, 0x000fca00078e025fULL, 0x0000000108047810ULL, 0x000fc80007ffe0ffULL,
0x0000006b0400720cULL, 0x000fe40003f46070ULL, 0x0000000107047812ULL, 0x000fd600078e0cffULL,
0x000006000000a947ULL, 0x000fea0003800000ULL, 0x0000001003097824ULL, 0x002fe200078e00ffULL,
0x00000002ff3c7819ULL, 0x000fe20000011603ULL, 0x00000100080f7824ULL, 0x000fe200078e0275ULL,
0x000064001e177a11ULL, 0x000fe200078238ffULL, 0x00000002001c7824ULL, 0x000fe200078e0204ULL,
0x00000030090c7812ULL, 0x000fe200078ec0ffULL, 0x00000001020d7824ULL, 0x000fe200078e023cULL,
0x000000103c3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x000000083c1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000400b087824ULL, 0x000fe200078e020cULL,
0x0000000f68147217ULL, 0x000fe20007800000ULL, 0x0000000102157824ULL, 0x000fe200078e023eULL,
0x000065001e167a11ULL, 0x000fe200008f3cffULL, 0x000000800d0c7825ULL, 0x000fe200078e0008ULL,
0x000000183c407810ULL, 0x000fc40007ffe0ffULL, 0x000000203c427810ULL, 0x000fe20007ffe0ffULL,
0x0000000102117824ULL, 0x000fe200078e021fULL, 0x000000170c0e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001141d7824ULL, 0x000fe200078e0a0fULL, 0x00000003030c7211ULL, 0x000fe200078fe8ffULL,
0x0000008015147825ULL, 0x000fe200078e0008ULL, 0x000010001c1c7811ULL, 0x000fe400078e60ffULL,
0x000000030c1e7812ULL, 0x000fe200078ec0ffULL, 0x000000010d0f7824ULL, 0x000fe200008e0616ULL,
0x0000001714147210ULL, 0x000fe20007f3e0ffULL, 0x00000001020d7824ULL, 0x000fe200078e0240ULL,
0x000000303c447810ULL, 0x000fe20007ffe0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000001d4000720cULL, 0x000fc60003fa6070ULL, 0x000000800d0c7825ULL, 0x000fe200078e0008ULL,
0x0000001710127210ULL, 0x000fc60007f5e0ffULL, 0x0000000115157824ULL, 0x100fe200008e0616ULL,
0x000000170c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000111137824ULL, 0x100fe200010e0616ULL,
0x0000001d3c00720cULL, 0x080fe20003f26070ULL, 0x000000041f3d7824ULL, 0x040fe200078e00ffULL,
0x0000001d1f00720cULL, 0x080fe20003f46070ULL, 0x000000010d0d7824ULL, 0x000fe200018e0616ULL,
0x0ffffffc1e1f7812ULL, 0x000fe200078ef803ULL, 0x000000043e3f7824ULL, 0x040fe200078e00ffULL,
0x0000001d3e00720cULL, 0x000fe20003f66070ULL, 0x0000000102117824ULL, 0x000fe200078e0242ULL,
0x000000283c3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e021cULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee21eULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0xfffffffc3f3f7812ULL, 0x000fc400078ee21eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1f7faeULL, 0x0003e2000c901c46ULL, 0x0000000102417824ULL, 0x000fe200078e023eULL,
0x0000001710107210ULL, 0x000fe20007f9e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e021cULL,
0x000000383c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000103f3f7824ULL, 0x000fe400078e021cULL,
0x0000000102437824ULL, 0x000fe200078e0244ULL, 0x00000000123d7faeULL, 0x0005e2000d101c46ULL,
0x0000000111117824ULL, 0x000fe200020e0616ULL, 0x0000001d4200720cULL, 0x080fe20003f86070ULL,
0x0000000102457824ULL, 0x000fe200078e023cULL, 0x00000000143f7faeULL, 0x0007e2000d901c46ULL,
0x00000080410e7825ULL, 0x002fe200078e0008ULL, 0x0000001d3e00720cULL, 0x000fc40003f66070ULL,
0x0000001d4400720cULL, 0x000fe20003f46070ULL, 0x000000043e1f7824ULL, 0x000fe200078e00ffULL,
0x000000170e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000008043127825ULL, 0x004fe200078e0008ULL,
0x0000001d3c00720cULL, 0x000fe40003f26070ULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee21eULL,
0x0000000440157824ULL, 0x008fe400078e00ffULL, 0x00000004421d7824ULL, 0x000fe400078e00ffULL,
0x000000010f0f7824ULL, 0x000fe200030e0616ULL, 0x0000001712127210ULL, 0x000fe20007fde0ffULL,
0x00000004443d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15157812ULL, 0x000fe200078ee21eULL,
0x0000008045087825ULL, 0x000fe200078e0008ULL, 0xfffffffc1d1d7812ULL, 0x000fc400078ee21eULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee21eULL, 0x000000043c3f7824ULL, 0x000fe400078e00ffULL,
0x0000000113137824ULL, 0x000fe200030e0616ULL, 0x0000001708087210ULL, 0x000fe20007fde0ffULL,
0x0000001015157824ULL, 0x000fe200078e021cULL, 0xfffffffc3f3f7812ULL, 0x000fe200078ee21eULL,
0x000000101d1d7824ULL, 0x100fe400078e021cULL, 0x000000101f177824ULL, 0x100fe200078e021cULL,
0x000000000c157faeULL, 0x0003e2000e901c46ULL, 0x000000103d1f7824ULL, 0x000fc400078e021cULL,
0x000000103f3d7824ULL, 0x000fe200078e021cULL, 0x00000000101d7faeULL, 0x0003e2000e101c46ULL,
0x0000000109097824ULL, 0x000fc600030e0616ULL, 0x000000000e177faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000d101c46ULL, 0x00000000083d7faeULL, 0x0003e2000c901c46ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x00000008030d7811ULL, 0x042fe200078ff0ffULL,
0x0000000200097824ULL, 0x000fe200078e0204ULL, 0x00000010030f7811ULL, 0x000fc400078ff0ffULL,
0x0000001803137811ULL, 0x000fe200078ff0ffULL, 0x000000040d3d7824ULL, 0x000fe200078e00ffULL,
0x00000020034d7811ULL, 0x000fe200078ff0ffULL, 0x000000040f3f7824ULL, 0x000fe200078e00ffULL,
0x00000028034f7811ULL, 0x000fe200078ff0ffULL, 0x0000000413417824ULL, 0x000fe200078e00ffULL,
0x0000003003517811ULL, 0x000fe200078ff0ffULL, 0x000000044d437824ULL, 0x000fe200078e00ffULL,
0x0000003803537811ULL, 0x000fe200078ff0ffULL, 0x000000044f457824ULL, 0x000fe200078e00ffULL,
0x0000000303087211ULL, 0x000fe200078fe8ffULL, 0x0000000451477824ULL, 0x000fe200078e00ffULL,
0x0000000203117211ULL, 0x000fe200078ff0ffULL, 0x0000000453497824ULL, 0x000fe200078e00ffULL,
0x0000000308087812ULL, 0x000fe200078ec0ffULL, 0x00000001021d7824ULL, 0x000fe200078e020fULL,
0x000064001e4b7a11ULL, 0x000fe200078238ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x100fe200078ee208ULL, 0x0000000102157824ULL, 0x040fe200078e020dULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee208ULL, 0x0000000102177824ULL, 0x040fe200078e0213ULL,
0xfffffffc41417812ULL, 0x100fe200078ee208ULL, 0x0000000102137824ULL, 0x040fe200078e024dULL,
0xfffffffc43437812ULL, 0x100fe200078ee208ULL, 0x00000001020d7824ULL, 0x040fe200078e024fULL,
0xfffffffc45457812ULL, 0x000fe200078ee208ULL, 0x0000000102537824ULL, 0x000fe200078e0253ULL,
0x0ffffffc081f7812ULL, 0x000fc400078ef803ULL, 0xfffffffc47477812ULL, 0x100fe400078ee208ULL,
0xfffffffc49497812ULL, 0x000fe200078ee208ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00001000090c7811ULL, 0x000fe200078e60ffULL, 0x0000000102097824ULL, 0x000fe200078e0251ULL,
0x000065001e4d7a11ULL, 0x000fe400008f3cffULL, 0x0000003008087812ULL, 0x000fe200078ec0ffULL,
0x000000101f1f7824ULL, 0x100fe400078e020cULL, 0x000000103d3d7824ULL, 0x000fc400078e020cULL,
0x000000400b0e7824ULL, 0x000fe400078e0208ULL, 0x000000103f3f7824ULL, 0x000fe400078e020cULL,
0x0000008011107825ULL, 0x000fc800078e000eULL, 0x0000008015147825ULL, 0x000fe200078e000eULL,
0x0000004b10107210ULL, 0x000fc60007f3e0ffULL, 0x000000801d1c7825ULL, 0x000fe200078e000eULL,
0x0000004b14147210ULL, 0x000fc60007f5e0ffULL, 0x0000008017167825ULL, 0x000fe200078e000eULL,
0x0000004b1c1c7210ULL, 0x000fc60007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e020cULL,
0x0000004b16167210ULL, 0x000fe20007f9e0ffULL, 0x0000001043437824ULL, 0x100fe400078e020cULL,
0x0000001045457824ULL, 0x100fe400078e020cULL, 0x0000001047477824ULL, 0x100fe400078e020cULL,
0x0000001049497824ULL, 0x000fe400078e020cULL, 0x0000008013127825ULL, 0x000fc800078e000eULL,
0x000000800d0c7825ULL, 0x000fc800078e000eULL, 0x0000008009087825ULL, 0x000fc800078e000eULL,
0x00000080530e7825ULL, 0x000fc800078e000eULL, 0x0000000111117824ULL, 0x100fe200008e064dULL,
0x0000004b12127210ULL, 0x080fe20007f3e0ffULL, 0x0000000115157824ULL, 0x100fe200010e064dULL,
0x0000004b0c0c7210ULL, 0x080fe20007f5e0ffULL, 0x000000011d1d7824ULL, 0x100fe200018e064dULL,
0x0000004b08087210ULL, 0x080fe20007f7e0ffULL, 0x0000000117177824ULL, 0x100fe200020e064dULL,
0x0000004b0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000113137824ULL, 0x100fe200008e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc400010e064dULL, 0x0000000109097824ULL, 0x100fe200018e064dULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x000000010f0f7824ULL, 0x000fc600020e064dULL,
0x000000001c3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016417faeULL, 0x0003e8000b901c46ULL,
0x0000000012437faeULL, 0x0003e8000b901c46ULL, 0x000000000c457faeULL, 0x0003e8000b901c46ULL,
0x0000000008477faeULL, 0x0003e8000b901c46ULL, 0x000000000e497faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b00780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000405057810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff5e7424ULL, 0x000fc600078e00ffULL,
0x000000690500720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000272087824ULL, 0x002fe400078e0205ULL, 0x00000004ff097424ULL, 0x000fc800078e00ffULL,
0x0000660008087625ULL, 0x000fca00078e0009ULL, 0x00000006085e7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020030c7810ULL, 0x042fe20007ffe0ffULL, 0x0000000200077824ULL, 0x000fe200078e0207ULL,
0xfffffff803087812ULL, 0x040fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000007030e7812ULL, 0x000fe400078ec0ffULL,
0x00000007080b7812ULL, 0x100fe400078ef803ULL, 0x000000070c0c7812ULL, 0x000fc400078ef803ULL,
0x0000100007077811ULL, 0x000fe400078e60ffULL, 0x000000080e087812ULL, 0x000fe400078ef803ULL,
0x00000001ff617819ULL, 0x000fe4000001160bULL, 0x00000001ff607819ULL, 0x000fe2000001160cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000001610d7824ULL, 0x000fe200078e0209ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000040b0e7824ULL, 0x000fe400078e00ffULL,
0x000000040c147824ULL, 0x000fc400078e00ffULL, 0x000000040a6a7824ULL, 0x000fe200078e0209ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001600d7824ULL, 0x000fe400078e0209ULL,
0x000000026a6a7824ULL, 0x000fe400078e00ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0207ULL,
0xfffffffc14147812ULL, 0x000fc800078ee20dULL, 0x000000000e10783bULL, 0x020e620000000200ULL,
0x0000001014147824ULL, 0x000fcc00078e0207ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00010000120f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011410ULL,
0x00010000100d7824ULL, 0x040fe200078e00ffULL, 0x0000888010427816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x00010000110e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011412ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00008880124a7816ULL, 0x040fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000000f006d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff537819ULL, 0x004fe40000011414ULL,
0x0000888014527816ULL, 0x040fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011411ULL,
0x00008880114e7816ULL, 0x040fe200000000ffULL, 0x0000001000787306ULL, 0x0004e20000200c00ULL,
0x00010000140f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011415ULL,
0x0000010014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011416ULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fc4000001140fULL,
0x00000012004b7306ULL, 0x0003e20000200c00ULL, 0x0000000109107810ULL, 0x004fe40007ffe0ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880155b7816ULL, 0x000fe200000000ffULL, 0x0000000f00637306ULL, 0x0005e20000200c00ULL,
0x000000040b127824ULL, 0x002fe200078e00ffULL, 0x0000888016587816ULL, 0x000fc400000000ffULL,
0x00000018ff507819ULL, 0x000fe40000011413ULL, 0x00008880134c7816ULL, 0x000fe400000000ffULL,
0x0000000e00547306ULL, 0x0003e20000200c00ULL, 0x00000001610f7824ULL, 0x104fe200078e0210ULL,
0x00000018ff457819ULL, 0x000fe20000011417ULL, 0x0000000160107824ULL, 0x000fe200078e0210ULL,
0x0000888017467816ULL, 0x000fe400000000ffULL, 0xfffffffc12127812ULL, 0x000fe200078ee20fULL,
0x00010000160f7824ULL, 0x040fe200078e00ffULL, 0x0000001400517306ULL, 0x0005e20000200c00ULL,
0x00010000130e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000001012127824ULL, 0x000fe200078e0207ULL, 0x0000000f00597306ULL, 0x0003e20000200c00ULL,
0x0000001008147824ULL, 0x004fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x00000000121c783bULL, 0x000ea20000000200ULL,
0x0000541078437816ULL, 0x008fe40000000043ULL, 0x0000000e00677306ULL, 0x0007e20000200c00ULL,
0x0000006a030f7211ULL, 0x002fe400078fe0ffULL, 0x000000026a6a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000209097810ULL, 0x000fe20007ffe0ffULL, 0x00000001080f7824ULL, 0x000fc400078e020fULL,
0x00000011004f7306ULL, 0x0003e20000200c00ULL, 0x00010000150e7824ULL, 0x008fe200078e00ffULL,
0x000000040900780cULL, 0x000fe20003f25270ULL, 0x0000010015157824ULL, 0x000fe200078e00ffULL,
0xfffffff0140f7812ULL, 0x000fe400078ee20fULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x000000040c117824ULL, 0x002fe200078e00ffULL,
0x0000000e005d7306ULL, 0x0003e20000200c00ULL, 0x000000100f0f7824ULL, 0x000fc600078e00ffULL,
0xfffffffc11107812ULL, 0x000fc800078ee210ULL, 0x00000015005c7306ULL, 0x000fe20000200c00ULL,
0x00010000170e7824ULL, 0x042fe400078e00ffULL, 0x0000010017177824ULL, 0x000fe400078e00ffULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x0000001600577306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x000fe40000011417ULL,
0x00000018ff407819ULL, 0x004fc4000001141cULL, 0x000088801c497816ULL, 0x000fe400000000ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001141dULL, 0x0000001300667306ULL, 0x0005e20000200c00ULL,
0x000000000f14783bULL, 0x002e620000000200ULL, 0x00000018ff3d7819ULL, 0x000fe4000001141fULL,
0x00000018ff3e7819ULL, 0x000fc8000001141eULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000000001010783bULL, 0x004eae0000000200ULL, 0x0000000d000d7306ULL, 0x000ef00000200c00ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x0000541042427816ULL, 0x008fce000000000dULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x000000421438723cULL, 0x002b6e0000001838ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x000100001c427824ULL, 0x060fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x004fe20000011411ULL, 0x000001001c1c7824ULL, 0x000fca00078e00ffULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x000054104f437816ULL, 0x000fe20000000041ULL,
0x000100001d417824ULL, 0x040fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801d4f7816ULL, 0x040fe200000000ffULL,
0x0000004d000f7306ULL, 0x000fe20000200c00ULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc40000011410ULL, 0x00000018ff0d7819ULL, 0x000fe40000011413ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000042004d7306ULL, 0x0007f00000200c00ULL,
0x0000001d00557306ULL, 0x0003e20000200c00ULL, 0x000054104e427816ULL, 0x008fc40000000054ULL,
0x00000018ff547819ULL, 0x000fe40000011441ULL, 0x000088801e417816ULL, 0x000fc600000000ffULL,
0x0000001c004e7306ULL, 0x0007e20000200c00ULL, 0x000000421434723cULL, 0x000be20000001834ULL,
0x000054104b1d7816ULL, 0x002fcc0000000044ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000100001e1c7824ULL, 0x048fe200078e00ffULL, 0x000088801f437816ULL, 0x020fe200000000ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001c00427306ULL, 0x0005f00000200c00ULL, 0x0000005300537306ULL, 0x000ee20000200c00ULL,
0x000054104a1c7816ULL, 0x004fce000000006dULL, 0x0000001c1430723cULL, 0x000b620000001830ULL,
0x0000005200527306ULL, 0x000eac0000200c00ULL, 0x000100001f1d7824ULL, 0x060fe200078e00ffULL,
0x000054104c1c7816ULL, 0x002fe20000000067ULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001e00447306ULL, 0x0003e20000200c00ULL, 0x0000541051537816ULL, 0x008fe20000000053ULL,
0x0001000010677824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff4b7819ULL, 0x000fe4000001141fULL, 0x0000006a031f7211ULL, 0x000fe200078fe0ffULL,
0x0000001d004a7306ULL, 0x0007e20000200c00ULL, 0x00008880101e7816ULL, 0x002fe400000000ffULL,
0x0000541052527816ULL, 0x004fe20000000063ULL, 0x00000001081f7824ULL, 0x000fe200078e021fULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000888011637816ULL, 0x000fe200000000ffULL,
0x0000001e004c7306ULL, 0x0003e20000200c00ULL, 0x00005410661d7816ULL, 0x008fe20000000050ULL,
0x0000001008667824ULL, 0x000fe200078e00ffULL, 0x000000521428723cULL, 0x000fe20000001828ULL,
0x0000010010507824ULL, 0x000fc600078e00ffULL, 0xfffffff0661f7812ULL, 0x000fe200078ee21fULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0001000011667824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000001c142c723cULL, 0x000b62000000182cULL,
0x000000101f1f7824ULL, 0x000fe400078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000005b005b7306ULL, 0x000ee40000200c00ULL, 0x000000001f1c783bULL, 0x022e6c0000000200ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000054105c537816ULL, 0x004fce000000005aULL,
0x0000000e00477306ULL, 0x0004a20000200c00ULL, 0x000054105b527816ULL, 0x008fe4000000005dULL,
0x00008880125b7816ULL, 0x000fca00000000ffULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x000000521424723cULL, 0x000b620000001824ULL, 0x00000018ff0e7819ULL, 0x004fcc0000011412ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541046467816ULL, 0x000fce0000000047ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x0000541057537816ULL, 0x028fce0000000056ULL,
0x0000004800487306ULL, 0x000ef00000200c00ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541058527816ULL, 0x004fce0000000059ULL, 0x0000004900497306ULL, 0x000ea20000200c00ULL,
0x0000541048477816ULL, 0x008fe20000000045ULL, 0x000000521420723cULL, 0x040b6c0000001820ULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x0001000012537824ULL, 0x020fe200078e00ffULL,
0x000000461418723cULL, 0x000b620000001818ULL, 0x000000ffff527224ULL, 0x000fc600078e005bULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x0000010012167824ULL, 0x020fe200078e00ffULL, 0x0000541049147816ULL, 0x004fe4000000004dULL,
0x000054104e157816ULL, 0x000fe40000000040ULL, 0x00000018ff177819ULL, 0x000fe40000011416ULL,
0x0000004100417306ULL, 0x000ea20000200c00ULL, 0x0000541055557816ULL, 0x008fe2000000003fULL,
0x00010000133f7824ULL, 0x040fe200078e00ffULL, 0x0000888013167816ULL, 0x040fe200000000ffULL,
0x000000141c38723cULL, 0x002b620000001838ULL, 0x0000010013137824ULL, 0x000fc400078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000006700107306ULL, 0x0002e40000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000541044157816ULL, 0x020fe4000000003eULL,
0x0000541041147816ULL, 0x004fe20000000042ULL, 0x0000010011677824ULL, 0x002fe200078e00ffULL,
0x0000000e000e7306ULL, 0x000fe80000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe20000011467ULL,
0x000000141c30723cULL, 0x000b620000001830ULL, 0x000054104c4c7816ULL, 0x008fc40000000010ULL,
0x0000006300517306ULL, 0x000ff00000200c00ULL, 0x0000006600117306ULL, 0x000e700000200c00ULL,
0x0000001700177306ULL, 0x000ff00000200c00ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541051107816ULL, 0x002fce0000000011ULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000004300437306ULL, 0x000eb00000200c00ULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x000054104f547816ULL, 0x002fce0000000054ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00005410434a7816ULL, 0x004fe2000000004aULL,
0x000000541c34723cULL, 0x000b6c0000001834ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000054104b4b7816ULL, 0x008fce000000003dULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00005410504d7816ULL, 0x002fe2000000003cULL, 0x0000004a1c2c723cULL, 0x040b6c000000182cULL,
0x0000005300127306ULL, 0x000e620000200c00ULL, 0x000054105a117816ULL, 0x004fe2000000000fULL,
0x0000004c1c28723cULL, 0x040b6c0000001828ULL, 0x0000001600167306ULL, 0x000fe40000200c00ULL,
0x000000101c24723cULL, 0x000b6c0000001824ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541052127816ULL, 0x002fce0000000012ULL, 0x0000001300147306ULL, 0x0202e20000200c00ULL,
0x0000541016167816ULL, 0x004fe4000000003fULL, 0x0000541017137816ULL, 0x002fe4000000000eULL,
0x0000541014177816ULL, 0x008fca000000000dULL, 0x000000121c20723cULL, 0x040b700000001820ULL,
0x000000161c18723cULL, 0x000b620000001818ULL, 0xfffff07000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff077224ULL, 0x000fe200078e0004ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe27000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006234347220ULL, 0x080fe20000410000ULL,
0x0000006230307220ULL, 0x080fe20000410000ULL, 0x0000006231317220ULL, 0x080fe20000410000ULL,
0x000000622c2c7220ULL, 0x080fe20000410000ULL, 0x000000622d2d7220ULL, 0x080fe20000410000ULL,
0x0000006239397220ULL, 0x080fe20000410000ULL, 0x0000006229067220ULL, 0x080fe20000410000ULL,
0x0000006224247220ULL, 0x080fe20000410000ULL, 0x0000006225257220ULL, 0x080fe20000410000ULL,
0x0000006220207220ULL, 0x0a0fe20000410000ULL, 0x0000006232087220ULL, 0x080fe20000410000ULL,
0x000000622f0a7220ULL, 0x080fe20000410000ULL, 0x000000622a0b7220ULL, 0x080fe20000410000ULL,
0x000000622b147220ULL, 0x080fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e0034ULL,
0x000000622e097220ULL, 0x080fe20000410000ULL, 0x0000006228327220ULL, 0x080fe20000410000ULL,
0x00000062261c7220ULL, 0x080fe20000410000ULL, 0x00000062271d7220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0030ULL, 0x0000006238157220ULL, 0x080fe20000410000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0031ULL, 0x000000623a1e7220ULL, 0x080fe20000410000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x000000623b167220ULL, 0x080fe20000410000ULL,
0x000000ffff347224ULL, 0x000fe200078e002dULL, 0x0000006235177220ULL, 0x080fe20000410000ULL,
0x00000062361f7220ULL, 0x080fe20000410000ULL, 0x0000006237377220ULL, 0x080fe20000410000ULL,
0x0000006233337220ULL, 0x080fe20000410000ULL, 0x00000062212e7220ULL, 0x080fe20000410000ULL,
0x00000062220c7220ULL, 0x080fe20000410000ULL, 0x00000062230d7220ULL, 0x080fe20000410000ULL,
0x0000006218267220ULL, 0x080fe20000410000ULL, 0x0000006219277220ULL, 0x080fe20000410000ULL,
0x000000621a1a7220ULL, 0x080fe20000410000ULL, 0x000000621b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff287224ULL, 0x000fc400078e0039ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0024ULL, 0x000000ffff317224ULL, 0x000fe400078e0025ULL,
0x000000ffff307224ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff217224ULL, 0x000fe400078e0033ULL,
0x000000ffff237224ULL, 0x000fc400078e0037ULL, 0x000000ffff227224ULL, 0x000fe400078e0008ULL,
0x000000ffff247224ULL, 0x000fe400078e0009ULL, 0x000000ffff337224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff187224ULL, 0x000fe400078e000cULL,
0x000000ffff197224ULL, 0x000fc400078e000dULL, 0x0000000000087805ULL, 0x002fca0000015200ULL,
0x00000400740b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400740b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403137824ULL, 0x000fe200078e00ffULL, 0x000000735f00720cULL, 0x000fc80003f06070ULL,
0xfffffff013077812ULL, 0x000fca00078ec0ffULL, 0x0000008000207824ULL, 0x000fca00078e0207ULL,
0x00f4000020087984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000e7b06ULL, 0x000ee20000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe20003f85070ULL, 0x0000000203357824ULL, 0x000fe200078e00ffULL,
0x00005a00ff107a12ULL, 0x000fc800078e33ffULL, 0x0000000635357812ULL, 0x000fca00078ec0ffULL,
0x0000000135377824ULL, 0x000fe200078e026cULL, 0x0000000e000e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0e077810ULL, 0x008fcc0007ffe0ffULL, 0x0000000700077305ULL, 0x000ee4000021f000ULL,
0x000000ffff0d7224ULL, 0x008fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d070f7227ULL, 0x000fe200078e0006ULL, 0x0000007603067211ULL, 0x000fca00078ff0ffULL,
0x000000060f0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a0cULL,
0x00005a000d0d7a24ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fc80007ffe0ffULL,
0x00005a000d007a0cULL, 0x000fe20003f06070ULL, 0x000000060f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a0fULL, 0x00005a0007067a24ULL, 0x000fe400078e0206ULL,
0x000001005f077824ULL, 0x000fe400078e0275ULL, 0x80005a000d0d0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x00005a000d007a0cULL, 0x000fe40003f26070ULL,
0x0000000768127217ULL, 0x000fc40007800000ULL, 0x000000010c0c0810ULL, 0x000fc60007ffe0ffULL,
0x0000000112127824ULL, 0x000fe400078e0a07ULL, 0x000000016f077824ULL, 0x000fe400078e0235ULL,
0x80005a0006062a10ULL, 0x000fe40007ffe0ffULL, 0x00000001070d7824ULL, 0x040fe200078e0a12ULL,
0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL, 0x000000120700720cULL, 0x000fe40003f66070ULL,
0x00005a0006007a0cULL, 0x000fc40003f06070ULL, 0x0000000c10077207ULL, 0x000fe40006000000ULL,
0x0000000d6e067217ULL, 0x040fe20003800000ULL, 0x00000001370d7824ULL, 0x040fe200078e0a12ULL,
0x000000076e077217ULL, 0x000fe40003800000ULL, 0x00000004ff067819ULL, 0x000fe40000011606ULL,
0x000000123700720cULL, 0x000fe20003f26070ULL, 0x00000007704f7224ULL, 0x000fe200078e02ffULL,
0x0000000d6e0d7217ULL, 0x000fc40003800000ULL, 0x000000ff060e7207ULL, 0x000fe40001800000ULL,
0x000000010f0f2810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0d447207ULL, 0x000fe20000800000ULL,
0x000000014f077824ULL, 0x000fe200078e020eULL, 0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL,
0x0000004f440d7211ULL, 0x000fe200078fe0ffULL, 0x0000000207067825ULL, 0x000fe200078e0064ULL,
0x0000000f100f7207ULL, 0x000fc40006000000ULL, 0x00000010353b7812ULL, 0x000fe200078efcffULL,
0x000000020d0c7825ULL, 0x000fe200078e0064ULL, 0x0000000f6e0f7217ULL, 0x000fe20003800000ULL,
0x0000000606487981ULL, 0x0046a8000c1e9500ULL, 0x000000060c4d7981ULL, 0x0002a2000c1e9500ULL,
0x0000000f70517224ULL, 0x000fe400078e02ffULL, 0x000000013b397824ULL, 0x000fc400078e026cULL,
0x000000010e0f7824ULL, 0x000fe200078e0251ULL, 0x00000020353d7812ULL, 0x000fe200078efcffULL,
0x000000016f077824ULL, 0x008fe200078e023bULL, 0x0000005144117211ULL, 0x000fe200078fe0ffULL,
0x000000020f0e7825ULL, 0x000fc800078e0064ULL, 0x00000001070d7824ULL, 0x142fe200078e0a12ULL,
0x000000120700720cULL, 0x080fe20003f26070ULL, 0x0000000139077824ULL, 0x040fe200078e0a12ULL,
0x000000060e427981ULL, 0x0002e2000c1e9500ULL, 0x000000123900720cULL, 0x000fe20003f06070ULL,
0x000000016f437824ULL, 0x000fe200078e023dULL, 0x0000000d6e0d7217ULL, 0x000fe20003800000ULL,
0x000000013d417824ULL, 0x000fe400078e026cULL, 0x0000000211107825ULL, 0x000fe200078e0064ULL,
0x00000004ff0d7819ULL, 0x000fc4000001160dULL, 0x000000076e077217ULL, 0x040fe40003800000ULL,
0x000000ff0d0e7207ULL, 0x002fe20000800000ULL, 0x0000000143457824ULL, 0x000fe200078e0a12ULL,
0x000000ff07367207ULL, 0x000fe20000000000ULL, 0x0000000610557981ULL, 0x0002e4000c1e9500ULL,
0x000000014f077824ULL, 0x000fe200078e020eULL, 0x000000456e3c7217ULL, 0x000fc60003800000ULL,
0x0000000207067825ULL, 0x000fe200078e0064ULL, 0x000000124300720cULL, 0x080fe40003f26070ULL,
0x00000004ff3c7819ULL, 0x000fe4000001163cULL, 0x0000000606387981ULL, 0x0002e2000c1e9500ULL,
0x000000124100720cULL, 0x040fe40003f06070ULL, 0x000000ff3c3e7207ULL, 0x000fe20000800000ULL,
0x0000000141077824ULL, 0x002fe200078e0a12ULL, 0x0000003035437812ULL, 0x000fc800078efcffULL,
0x000000076e077217ULL, 0x000fe20003800000ULL, 0x000000010e0f7824ULL, 0x000fe200078e0251ULL,
0x0000004f360d7211ULL, 0x040fe400078fe0ffULL, 0x0000005136117211ULL, 0x000fe400078fe0ffULL,
0x000000ff07407207ULL, 0x000fe20000000000ULL, 0x000000014f077824ULL, 0x000fe400078e023eULL,
0x000000016f537824ULL, 0x000fe400078e0243ULL, 0x000000020d0c7825ULL, 0x000fc800078e0064ULL,
0x000000020f0e7825ULL, 0x100fe200078e0064ULL, 0x000000060c3f7981ULL, 0x0002e6000c1e9500ULL,
0x0000000211107825ULL, 0x100fe200078e0064ULL, 0x000000060e3a7981ULL, 0x0002e6000c1e9500ULL,
0x0000000207067825ULL, 0x000fe200078e0064ULL, 0x0000000610457981ULL, 0x0002e6000c1e9500ULL,
0x00000001534b7824ULL, 0x000fe200078e0a12ULL, 0x00000006063c7981ULL, 0x0002e2000c1e9500ULL,
0x0000000143497824ULL, 0x000fe200078e026cULL, 0x0000004f400d7211ULL, 0x002fc400078fe0ffULL,
0x0000004b6e467217ULL, 0x000fe20003800000ULL, 0x000000013e0f7824ULL, 0x000fe200078e0251ULL,
0x0000005140117211ULL, 0x000fe200078fe0ffULL, 0x0000000149077824ULL, 0x000fe200078e0a12ULL,
0x000000125300720cULL, 0x080fe40003f26070ULL, 0x00000004ff467819ULL, 0x000fe20000011646ULL,
0x000000020d0c7825ULL, 0x100fe200078e0064ULL, 0x000000124900720cULL, 0x000fe40003f06070ULL,
0x000000076e077217ULL, 0x000fe20003800000ULL, 0x000000020f0e7825ULL, 0x100fe200078e0064ULL,
0x000000ff464a7207ULL, 0x000fe20000800000ULL, 0x000000060c477981ULL, 0x0002e4000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0064ULL, 0x000000ff07467207ULL, 0x000fe20000000000ULL,
0x000000060e3e7981ULL, 0x0002e8000c1e9500ULL, 0x00000006104b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014f077824ULL, 0x000fe200078e024aULL, 0x0000004f460d7211ULL, 0x002fc600078fe0ffULL,
0x0000000207067825ULL, 0x000fc800078e0064ULL, 0x000000020d0c7825ULL, 0x000fe400078e0064ULL,
0x0000000606067981ULL, 0x0002e2000c1e9500ULL, 0x00000051460f7211ULL, 0x000fc600078fe0ffULL,
0x000000060c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014a117824ULL, 0x000fe400078e0251ULL,
0x000000020f0e7825ULL, 0x000fc800078e0064ULL, 0x0000000211107825ULL, 0x000fe400078e0064ULL,
0x000000060e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000610117981ULL, 0x0002e2000c1e9500ULL,
0xfffffff044517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff447424ULL, 0x000fc800078e00ffULL,
0x00000001124a7824ULL, 0x000fc800078e0251ULL, 0x0000000137577824ULL, 0x000fe200078e0a4aULL,
0x0000000935077812ULL, 0x042fe400078efcffULL, 0x00000001354f7812ULL, 0x000fe400078efcffULL,
0x0000005744577219ULL, 0x000fe200000006ffULL, 0x00000001070f7824ULL, 0x100fe400078e026cULL,
0x000000014f537824ULL, 0x000fe400078e026cULL, 0x000000010f5d7824ULL, 0x100fe200078e0a4aULL,
0x0000001135797812ULL, 0x000fe200078efcffULL, 0x0000000153597824ULL, 0x000fe200078e0a4aULL,
0xfffffff036367812ULL, 0x000fc400078ec0ffULL, 0x00000018356d7812ULL, 0x000fe400078efcffULL,
0x0000005d445d7219ULL, 0x040fe200000006ffULL, 0x00000001790c7824ULL, 0x000fe200078e026cULL,
0x0000005944597219ULL, 0x000fe200000006ffULL, 0x0000000112367824ULL, 0x000fe200078e0236ULL,
0x0000001935677812ULL, 0x000fe400078efcffULL, 0xfffffff040407812ULL, 0x000fe200078ec0ffULL,
0x000000016d7d7824ULL, 0x100fe400078e026cULL, 0x00000001677b7824ULL, 0x000fc400078e026cULL,
0x00000001125c7824ULL, 0x000fe400078e0240ULL, 0x0000000139407824ULL, 0x100fe400078e0a36ULL,
0x000000017d507824ULL, 0x100fe400078e0a36ULL, 0x000000017b667824ULL, 0x000fe200078e0a36ULL,
0x0000004044407219ULL, 0x000fe200000006ffULL, 0x0000000141547824ULL, 0x000fe200078e0a5cULL,
0x0000002135617812ULL, 0x000fe400078efcffULL, 0xfffffff046467812ULL, 0x000fc400078ec0ffULL,
0x0000005444547219ULL, 0x000fe200000006ffULL, 0x0000000161637824ULL, 0x000fe400078e026cULL,
0x0000000112467824ULL, 0x000fe400078e0246ULL, 0x0000000163567824ULL, 0x000fe400078e0a5cULL,
0x00000001495a7824ULL, 0x000fc600078e0a46ULL, 0x0000005644567219ULL, 0x040fe400000006ffULL,
0x0000005a445a7219ULL, 0x000fe400000006ffULL, 0x000054104d487816ULL, 0x004fe40000000048ULL,
0x00000008354d7812ULL, 0x000fe400078efcffULL, 0x0000004857ff7212ULL, 0x000fc6000780c0ffULL,
0x000000014d517824ULL, 0x000fe200078e026cULL, 0x000000123700720cULL, 0x000fc60000701470ULL,
0x00000001515b7824ULL, 0x000fe200078e0a4aULL, 0x000000123500720cULL, 0x000fc800007a1070ULL,
0x0000005b445b7219ULL, 0x000fe400000006ffULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x0000541055427816ULL, 0x008fc80000000042ULL, 0x0000004257ff7212ULL, 0x080fe4000784c0ffULL,
0x000000425bff7212ULL, 0x080fe400078cc0ffULL, 0x000000425dff7212ULL, 0x080fe400078ac0ffULL,
0x0000004259ff7212ULL, 0x000fe2000780c0ffULL, 0x000000010c427824ULL, 0x000fe200078e0a36ULL,
0x000000123700720cULL, 0x080fe40001741470ULL, 0x000000125100720cULL, 0x000fc400037c1470ULL,
0x000000120f00720cULL, 0x000fe40002fa1470ULL, 0x0000004244367219ULL, 0x040fe400000006ffULL,
0x000000123500720cULL, 0x080fe40001741070ULL, 0x000000124d00720cULL, 0x080fe400037c1070ULL,
0x000000120700720cULL, 0x000fe40002fa1070ULL, 0x0000005044427219ULL, 0x000fc400000006ffULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0x0000004859ff7212ULL, 0x080fe4000782c0ffULL,
0x000000485bff7212ULL, 0x080fe4000786c0ffULL, 0x000000485dff7212ULL, 0x000fc4000788c0ffULL,
0x000054103f3f7816ULL, 0x000fc80000000038ULL, 0x0000003f40ff7212ULL, 0x000fe4000784c0ffULL,
0x0000541045457816ULL, 0x000fc8000000003aULL, 0x0000004540ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004542ff7212ULL, 0x000fe400078ac0ffULL, 0x000000125300720cULL, 0x0c0fe40000f21470ULL,
0x000000125300720cULL, 0x080fe40000701470ULL, 0x000000125100720cULL, 0x080fe40001f61470ULL,
0x000000120f00720cULL, 0x000fc40002781470ULL, 0x000000123900720cULL, 0x0c0fe40001741470ULL,
0x000000123900720cULL, 0x080fe400037c1470ULL, 0x000000127d00720cULL, 0x080fe40002fa1470ULL,
0x00000028355d7812ULL, 0x040fe400078efcffULL, 0x00000029355b7812ULL, 0x000fe400078efcffULL,
0x000000124f00720cULL, 0x000fc40000f21070ULL, 0x000000124f00720cULL, 0x080fe40000701070ULL,
0x000000124d00720cULL, 0x080fe40001f61070ULL, 0x000000120700720cULL, 0x080fe40002781070ULL,
0x000000123b00720cULL, 0x0c0fe40001741070ULL, 0x000000123b00720cULL, 0x080fe400037c1070ULL,
0x000000126d00720cULL, 0x000fc40002fa1070ULL, 0x0000006644507219ULL, 0x000fe400000006ffULL,
0x0000541047477816ULL, 0x000fe4000000003cULL, 0x000054104b4b7816ULL, 0x000fe2000000003eULL,
0x000000015d107824ULL, 0x100fe200078e026cULL, 0xff80000028287808ULL, 0x000fe20000800000ULL,
0x000000015b4e7824ULL, 0x000fe200078e026cULL, 0xff80000016167808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fc40001800000ULL, 0xff80000017177808ULL, 0x000fe40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0x0000003f36ff7212ULL, 0x080fe4000782c0ffULL,
0x0000003f42ff7212ULL, 0x000fc4000780c0ffULL, 0x0000003f50ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004536ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004550ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004754ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004b54ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000110607824ULL, 0x100fe200078e0a5cULL, 0x000000120c00720cULL, 0x080fe20000f21470ULL,
0x000000014e5c7824ULL, 0x000fe200078e0a5cULL, 0x000000120c00720cULL, 0x000fc40002781470ULL,
0x000000127d00720cULL, 0x080fe40000701470ULL, 0x000000127b00720cULL, 0x0c0fe40001f61470ULL,
0x000000127b00720cULL, 0x080fe40001741470ULL, 0x000000124100720cULL, 0x0c0fe400037c1470ULL,
0x000000124100720cULL, 0x000fe40002fa1470ULL, 0x0000003135597812ULL, 0x000fc400078efcffULL,
0x0000003835577812ULL, 0x040fe400078efcffULL, 0x0000003935557812ULL, 0x000fe400078efcffULL,
0x000000127900720cULL, 0x0c0fe40000f21070ULL, 0x000000127900720cULL, 0x080fe40002781070ULL,
0x000000126d00720cULL, 0x080fe40000701070ULL, 0x000000126700720cULL, 0x000fc40001f61070ULL,
0x000000126700720cULL, 0x080fe40001741070ULL, 0x000000123d00720cULL, 0x0c0fe400037c1070ULL,
0x000000123d00720cULL, 0x000fe40002fa1070ULL, 0x0000006044607219ULL, 0x040fe400000006ffULL,
0x0000005c445c7219ULL, 0x000fe400000006ffULL, 0x000054100d0d7816ULL, 0x000fe20000000006ULL,
0x00000001594c7824ULL, 0x100fe200078e026cULL, 0xff8000002a2a7808ULL, 0x000fe20000800000ULL,
0x00000001574a7824ULL, 0x100fe200078e026cULL, 0xff80000021217808ULL, 0x000fe20002000000ULL,
0x0000000155487824ULL, 0x000fe200078e026cULL, 0xff8000002b2b7808ULL, 0x000fc40000000000ULL,
0xff80000034347808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x0000004756ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004760ff7212ULL, 0x000fc4000788c0ffULL,
0x000000475cff7212ULL, 0x000fe4000780c0ffULL, 0x0000004b56ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b60ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5cff7212ULL, 0x000fe400078cc0ffULL,
0x0000000d5aff7212ULL, 0x000fe200078ac0ffULL, 0x000000014c587824ULL, 0x100fe200078e0a46ULL,
0x000000126300720cULL, 0x0c0fe20000f21470ULL, 0x000000014a527824ULL, 0x100fe200078e0a46ULL,
0x000000126300720cULL, 0x080fe20001f61470ULL, 0x0000000148467824ULL, 0x000fe200078e0a46ULL,
0x000000121000720cULL, 0x000fc40002781470ULL, 0x000000121000720cULL, 0x080fe40001741470ULL,
0x000000124e00720cULL, 0x0c0fe40000701470ULL, 0x000000124e00720cULL, 0x080fe400037c1470ULL,
0x000000124900720cULL, 0x080fe40002fa1470ULL, 0x000000126100720cULL, 0x0c0fe40000f21070ULL,
0x000000126100720cULL, 0x000fc40001f61070ULL, 0x000000125d00720cULL, 0x0c0fe40002781070ULL,
0x000000125d00720cULL, 0x080fe40001741070ULL, 0x000000125b00720cULL, 0x0c0fe40000701070ULL,
0x000000125b00720cULL, 0x080fe400037c1070ULL, 0x000000124300720cULL, 0x000fe40002fa1070ULL,
0x0000005844587219ULL, 0x000fc400000006ffULL, 0x0000005244527219ULL, 0x040fe400000006ffULL,
0x0000004644467219ULL, 0x000fe400000006ffULL, 0x000054100e117816ULL, 0x000fe40000000011ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fc40002000000ULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0x0000000d58ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000d52ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000d46ff7212ULL, 0x000fe4000788c0ffULL,
0x000000115aff7212ULL, 0x080fe4000784c0ffULL, 0x0000001158ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001152ff7212ULL, 0x080fe400078cc0ffULL, 0x0000001146ff7212ULL, 0x000fe400078ac0ffULL,
0x000000124900720cULL, 0x000fc40001741470ULL, 0x000000124c00720cULL, 0x0c0fe40000f21470ULL,
0x000000124c00720cULL, 0x080fe40000701470ULL, 0x000000124a00720cULL, 0x0c0fe40001f61470ULL,
0x000000124a00720cULL, 0x080fe400037c1470ULL, 0x000000124800720cULL, 0x0c0fe40002781470ULL,
0x000000124800720cULL, 0x000fc40002fa1470ULL, 0x000000124300720cULL, 0x080fe40001741070ULL,
0x000000125900720cULL, 0x0c0fe40000f21070ULL, 0x000000125900720cULL, 0x080fe40000701070ULL,
0x000000125700720cULL, 0x0c0fe40001f61070ULL, 0x000000125700720cULL, 0x080fe400037c1070ULL,
0x000000125500720cULL, 0x000fc40002781070ULL, 0x000000125500720cULL, 0x000fe40002fa1070ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000019197808ULL, 0x000fc40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fc40002800000ULL, 0x000000150800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000001e0900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000815077208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fc40003f1e000ULL,
0x000000160900720bULL, 0x000fe40003f3e000ULL, 0x0000000728067208ULL, 0x000fe40004000000ULL,
0x0000000916087208ULL, 0x000fe40004800000ULL, 0x000000290600720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fe40003f3e000ULL, 0x0000000629067208ULL, 0x000fc40004000000ULL,
0x000000081f087208ULL, 0x000fe40004800000ULL, 0x000000170600720bULL, 0x000fe40003f1e000ULL,
0x000000230800720bULL, 0x000fe40003f3e000ULL, 0x0000000617067208ULL, 0x000fe40004000000ULL,
0x0000000823077208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fc40003f1e000ULL,
0x000000220700720bULL, 0x000fe40003f3e000ULL, 0x000000062f097208ULL, 0x000fe40004000000ULL,
0x0000000722067208ULL, 0x000fe40004800000ULL, 0x0000002a0900720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fe40003f3e000ULL, 0x000000092a087208ULL, 0x000fc40004000000ULL,
0x0000000621077208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fe40003f3e000ULL, 0x000000082b097208ULL, 0x000fe40004000000ULL,
0x0000000724067208ULL, 0x000fe40004800000ULL, 0x000000340900720bULL, 0x000fc40003f1e000ULL,
0x000000330600720bULL, 0x000fe40003f3e000ULL, 0x0000000934097208ULL, 0x000fe40004000000ULL,
0x0000000633067208ULL, 0x000fe40004800000ULL, 0x000000320900720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fe40003f3e000ULL, 0x0000000932097208ULL, 0x000fc40004000000ULL,
0x0000000625077208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x000000140700720bULL, 0x000fe40003f3e000ULL, 0x000000092c067208ULL, 0x000fe40004000000ULL,
0x0000000714077208ULL, 0x000fe40004800000ULL, 0x0000002d0600720bULL, 0x000fc40003f1e000ULL,
0x0000001c0700720bULL, 0x000fe40003f3e000ULL, 0x000000062d067208ULL, 0x000fe40004000000ULL,
0x000000071c087208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x0000000631077208ULL, 0x000fc40004000000ULL,
0x000000081d097208ULL, 0x000fe40004800000ULL, 0x000000300700720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x0000000730077208ULL, 0x000fe40004000000ULL,
0x0000000918067208ULL, 0x000fe40004800000ULL, 0x0000002e0700720bULL, 0x000fc40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x000000072e077208ULL, 0x000fe40004000000ULL,
0x0000000619097208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fe40003f3e000ULL, 0x0000000726067208ULL, 0x000fc40004000000ULL,
0x000000091a087208ULL, 0x000fe40004800000ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fe40003f3e000ULL, 0x00000006270c7208ULL, 0x000fe40004000000ULL,
0x000000081b0e7208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f000c067f89ULL, 0x0004e400000e0000ULL, 0x000000060c00720bULL, 0x008fc80003f1e000ULL,
0x0000000c060f7208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f000e067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000e6800000e0000ULL,
0x0c401f000b0c7f89ULL, 0x006e6800000e0000ULL, 0x0c201f000f107f89ULL, 0x000ea200000e0000ULL,
0x000000060e00720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x000fe40003f3e000ULL,
0x0000000e06087208ULL, 0x000fe40004000000ULL, 0x0000000a07097208ULL, 0x000fe40004800000ULL,
0x0000000c0b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f0008117f89ULL, 0x000e6600000e0000ULL,
0x0000000b0c067208ULL, 0x000fe20004000000ULL, 0x0c201f0009127f89ULL, 0x000ee200000e0000ULL,
0x000000100f00720bULL, 0x004fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0004a200000e0000ULL,
0x0000000f10107208ULL, 0x000fe40004000000ULL, 0x000000110800720bULL, 0x002fe40003f3e000ULL,
0x000000120900720bULL, 0x008fe40003f5e000ULL, 0x0000000811117208ULL, 0x000fe40004800000ULL,
0x0000000912127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10087820ULL, 0x004fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000303ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b2b0f7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2d2b7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b112d7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2f0b7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2f7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b312c7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010808ULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL, 0x00000028000a7308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001082dULL, 0x000000070600720bULL, 0x000fc40003f3e000ULL,
0x0000002900097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b32287823ULL, 0x004fce0000010808ULL,
0x00000017000c7308ULL, 0x002e620000000800ULL, 0x3fb8aa3b30297823ULL, 0x000fce0000010808ULL,
0x0000000b000d7308ULL, 0x000ff00000000800ULL, 0x0000002a000e7308ULL, 0x0004700000000800ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2a7823ULL, 0x004fe20000010808ULL,
0x000000150a08723eULL, 0x008fc400000000ffULL, 0x000000090c0a723eULL, 0x002fc800000000ffULL,
0x00000016000b7308ULL, 0x000e620000000800ULL, 0x0000000d0e0c723eULL, 0x000fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x00000023002e7308ULL, 0x0004e20000000800ULL,
0x0000001e0b09723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b141e7823ULL, 0x000fcc000001082dULL,
0x0000002200307308ULL, 0x0003e20000000800ULL, 0x3c003c00ff237424ULL, 0x004fe200078e00ffULL,
0x0000001f2e0b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff227424ULL, 0x002fca00078e00ffULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b181f7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1a2e7823ULL, 0x000fe2000001082dULL, 0x000000220814723cULL, 0x000f6a00000018ffULL,
0x0000003400347308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000eb00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000000f340e723eULL, 0x002fc400000000ffULL,
0x00000002ff347819ULL, 0x000fc80000011603ULL, 0x0000000234327810ULL, 0x040fe20007ffe0ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x00000030210d723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b19217823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1b2d7823ULL, 0x000fe2000001082dULL,
0x0000000834357824ULL, 0x040fe200078e00ffULL, 0x0000000134307810ULL, 0x040fe20007ffe0ffULL,
0x0000000834317824ULL, 0x040fe200078e00ffULL, 0x0000000834397810ULL, 0x000fe20007ffe0ffULL,
0x0000002800287308ULL, 0x000fe60000000800ULL, 0xfffffff831317812ULL, 0x000fc400078ee230ULL,
0x00000024330f723eULL, 0x002fc600000000ffULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000000834337824ULL, 0x000fc600078e00ffULL, 0x000000220c18723cULL, 0x020b640000001814ULL,
0xfffffff833337812ULL, 0x000fe400078ee232ULL, 0x0000002b002b7308ULL, 0x000fe60000000800ULL,
0x0000000834167824ULL, 0x060fe200078e00ffULL, 0x0000000334147810ULL, 0x000fc80007ffe0ffULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x0000000434157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff835357812ULL, 0x000fe400078ee214ULL, 0xfffffff816377812ULL, 0x000fe400078ee215ULL,
0x000000282f14723eULL, 0x002fe200000000ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000000834287824ULL, 0x040fe400078e00ffULL, 0x00000008342f7824ULL, 0x000fca00078e00ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000002b2c16723eULL, 0x004fe200000000ffULL,
0x00000008392c7824ULL, 0x000fca00078e00ffULL, 0xfffffff82c397812ULL, 0x000fe200078ee239ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x000000251e15723eULL, 0x002fe200000000ffULL, 0x0000000834257824ULL, 0x040fe200078e00ffULL,
0xffffffff341e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x0000001c1d17723eULL, 0x004fce00000000ffULL,
0x0000002100247308ULL, 0x0002a20000000800ULL, 0x00000006341d7810ULL, 0x040fe40007ffe0ffULL,
0x00000005341c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8282b7812ULL, 0x000fe200078ee21dULL,
0x000000221418723cULL, 0x000f620000001818ULL, 0xfffffff825257812ULL, 0x000fe200078ee21cULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000834217824ULL, 0x002fca00078e00ffULL,
0xfffffff821217812ULL, 0x000fe400078ee234ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000001f241d723eULL, 0x004fe400000000ffULL, 0x0000000c13247812ULL, 0x000fe400078ec0ffULL,
0x0000000607137208ULL, 0x000fc60004800000ULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000292a1c723eULL, 0x002fce00000000ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x00000026271e723eULL, 0x004fe400000000ffULL, 0x0000900000267811ULL, 0x000fca00078e58ffULL,
0x0000001021217824ULL, 0x100fe400078e0226ULL, 0x0000001031317824ULL, 0x100fe400078e0226ULL,
0x0000001033337824ULL, 0x100fe400078e0226ULL, 0x0000001035357824ULL, 0x100fe200078e0226ULL,
0x0000002e2d1f723eULL, 0x002fe200000000ffULL, 0x0000001037377824ULL, 0x000fe400078e0226ULL,
0x0000000121217824ULL, 0x000fc400078e0224ULL, 0x0000001025257824ULL, 0x100fe400078e0226ULL,
0x000000221c18723cULL, 0x020f620000001818ULL, 0x0000000124317824ULL, 0x040fe200078e0231ULL,
0x0000000821007388ULL, 0x0003e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe400078e0226ULL,
0x0000000124337824ULL, 0x040fe200078e0233ULL, 0x0000000a31007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e0226ULL, 0x0000000124357824ULL, 0x000fe200078e0235ULL,
0x0000000c33007388ULL, 0x0003e20000000800ULL, 0x0000001039397824ULL, 0x000fc400078e0226ULL,
0x0000000124377824ULL, 0x040fe200078e0237ULL, 0x0000000e35007388ULL, 0x0003e20000000800ULL,
0x0000000124257824ULL, 0x040fe400078e0225ULL, 0x00000001242b7824ULL, 0x040fe200078e022bULL,
0x0000001437007388ULL, 0x0003e20000000800ULL, 0x00000001242f7824ULL, 0x040fe400078e022fULL,
0x0000000124247824ULL, 0x000fe200078e0239ULL, 0x0000001625007388ULL, 0x0003e40000000800ULL,
0x000000ffff197224ULL, 0x020fc400078e001aULL, 0x0000001c2b007388ULL, 0x0003e80000000800ULL,
0x0000001e2f007388ULL, 0x0003e80000000800ULL, 0x0000000924007388ULL, 0x0003e80000000800ULL,
0x0004000b31007388ULL, 0x0003e80000000800ULL, 0x0004000d33007388ULL, 0x0003e80000000800ULL,
0x0004000f35007388ULL, 0x0003e80000000800ULL, 0x0004001537007388ULL, 0x0003e80000000800ULL,
0x0004001725007388ULL, 0x0003e80000000800ULL, 0x0004001d2b007388ULL, 0x0003e80000000800ULL,
0x0004001f2f007388ULL, 0x0003e80000000800ULL, 0x00f0001020008388ULL, 0x0003e80000000c00ULL,
0x00f2001820008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080077ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100077ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000015f5f7810ULL, 0x000fe20007ffe0ffULL, 0x0000180077ff7f8cULL, 0x0003e6000c80043fULL,
0x0000006b5f00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb4f000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0x0001293000147802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x014fea0003c00000ULL, 0xfffeffc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x0001297000147802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff127224ULL, 0x000fe200078e000bULL,
0xffff001000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0x000129c000157802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x014fea0003c00000ULL,
0xffff00f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0x00012a0000157802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0xffff021000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0010ULL,
0x00012a5000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000dULL,
0x00000a6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000bULL,
0xffff064000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0010ULL,
0x00012aa000157802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000bULL, 0xffff062000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe40004000000ULL, 0x00012af000147802ULL, 0x000fc40000000f00ULL,
0x00000a1000007944ULL, 0x018fea0003c00000ULL, 0xffff264000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x00012b3000147802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e000bULL,
0xffff268000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0036ULL,
0x00012b8000157802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x018fea0003c00000ULL,
0xffff277000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0036ULL,
0x00012bc000157802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x01afea0003c00000ULL,
0xffff289000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x00012c1000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000fULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000bULL,
0xffff2cc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x00012c6000157802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000bULL, 0xffff2ca000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0x00012cb000147802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0xffff4a7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x00012cf000147802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e000bULL,
0xffff4ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0x00012d4000157802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x014fea0003c00000ULL,
0xffff4bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0x00012d8000157802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x016fea0003c00000ULL,
0xffff4cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000aULL,
0x00012dd000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000dULL,
0x000006e000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000bULL,
0xffff510000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e000aULL,
0x00012e2000157802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000bULL, 0xffff50e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0x00012e7000147802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x014fea0003c00000ULL, 0xffff6f4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x000fe40005000000ULL, 0x00012eb000147802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000bULL,
0xffff6f9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0012ULL,
0x00012f0000157802ULL, 0x000fc40000000f00ULL, 0x000005b000007944ULL, 0x014fea0003c00000ULL,
0xffff708000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0012ULL,
0x00012f4000157802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x016fea0003c00000ULL,
0xffff71a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x00012f9000157802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000fULL,
0x0000052000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000bULL,
0xffff75d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x00012fe000157802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000bULL, 0xffff75b000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0001303000087802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x006fe200078e000eULL,
0x0001309000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x010fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x000130f000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e070e7208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000bULL, 0x0001315000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000070b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000fULL, 0x000131b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b07067208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000070f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000eULL, 0x0001321000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000f07107208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x0001327000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e07117208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0006ULL, 0x000132d000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a07127208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x0180000009027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000900028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff09ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000009037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000900027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffecb9002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000d0c077389ULL, 0x0002a200000e0035ULL,
0xfffecb5008007950ULL, 0x000fea0003c3ffffULL, 0x0000007800007348ULL, 0x000fe80003800000ULL,
0x0000000b140b7389ULL, 0x0002a400000e0079ULL, 0x000000ffff147224ULL, 0x002fc400078e0015ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffecb0014007950ULL, 0x000fea0003c3ffffULL,
0x000000010b00780cULL, 0x000fe20003f45070ULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000007700007348ULL, 0x000ff60003800000ULL, 0x00000000000b7806ULL, 0x000fc800050e0100ULL,
0x000000770b0b7212ULL, 0x000fe200078ec0ffULL, 0xfffecaa014007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000350ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015d0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001670ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001674ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000013600ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014e80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014ed0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015250ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001670ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013810ULL, 0x0000000000013810ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015250ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 86832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
