/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000174d0ULL, 0x0000000000017150ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x00000000000154e0ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000015660ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x00000000000156a0ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x00000000000156f0ULL, 0x0000000000000110ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000015800ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000154e000000000ULL,
0x0000040400000000ULL, 0x810c000001d00400ULL, 0x00535c0400288080ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8808288080870828ULL, 0x2880808a08288080ULL,
0x808f082880808b08ULL, 0x0828808092082880ULL, 0x8080a10828808093ULL, 0xa408288080a30828ULL,
0x288080b408288080ULL, 0x80b908288080b508ULL, 0x08288080ba082880ULL, 0x8082801628808084ULL,
0x0000000000031028ULL, 0x2880808492000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x0000007000000000ULL, 0x000154e000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0x8608288080840828ULL, 0x2880808708288080ULL, 0x808a082880808808ULL, 0x082880808b082880ULL,
0x80808f082880808eULL, 0x9608288080920828ULL, 0x288080a108288080ULL, 0x80a408288080a308ULL,
0x08288080b4082880ULL, 0x8080b908288080b5ULL, 0x8c08288080ba0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000014000000000ULL, 0x0001566000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8708288080840828ULL, 0x2880808808288080ULL,
0x808b082880808a08ULL, 0x082880808f082880ULL, 0x8080930828808092ULL, 0xa108288080960828ULL,
0x288080a308288080ULL, 0x80b408288080a408ULL, 0x08288080b9082880ULL, 0x8080b508288080baULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b592ULL, 0x0000002cffffffffULL,
0x0000021000000000ULL, 0x000156a000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80b4288080b50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0x8708288080840828ULL, 0x2880808808288080ULL, 0x808b082880808a08ULL, 0x082880808f082880ULL,
0x8080930828808092ULL, 0xa108288080960828ULL, 0x288080a308288080ULL, 0x80b508288080a408ULL,
0x08288080b9082880ULL, 0x8080b408288080baULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080b492ULL, 0x0000001cffffffffULL, 0x000002e000000000ULL, 0x000156f000000000ULL,
0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0068016000000018ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x00000c9000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000034001342804ULL, 0x0000071000000380ULL, 0x00002bd000002b30ULL, 0x00002e5000002cf0ULL,
0x00003320000032f0ULL, 0x0000340000003390ULL, 0x000054d000005430ULL, 0x0000576000005600ULL,
0x00005c3000005c00ULL, 0x00005d1000005ca0ULL, 0x00007b9000007ae0ULL, 0x00007e2000007cc0ULL,
0x000082f0000082c0ULL, 0x000083d000008360ULL, 0x0000a2900000a1e0ULL, 0x0000a5200000a3c0ULL,
0x0000a9f00000a9c0ULL, 0x0000aad00000aa60ULL, 0x0000bd500000bd40ULL, 0x00013a8000013a40ULL,
0x00013aa000013a90ULL, 0x00013b1000013ab0ULL, 0x00013b5000013b30ULL, 0x00014800000147b0ULL,
0x000148d000014870ULL, 0x000149b000014940ULL, 0x00014a6000014a10ULL, 0x00014b3000014ad0ULL,
0x00014c1000014ba0ULL, 0x00014cc000014c70ULL, 0x00014d9000014d30ULL, 0x00014e7000014e00ULL,
0x00014f2000014ed0ULL, 0x00014ff000014f90ULL, 0x000150d000015060ULL, 0x000151c000015140ULL,
0x000152c000015240ULL, 0x000153c000015340ULL, 0x000154c000015440ULL, 0x0000063004403904ULL,
0x00017600000000ffULL, 0x00000660003f0100ULL, 0x000176080000000bULL, 0x00000690003f0120ULL,
0x000176880000000bULL, 0x000006f0003f0120ULL, 0x000176a80000000bULL, 0x00000700003f0120ULL,
0x000176c80000000bULL, 0x00000cd0003f0120ULL, 0x00017600000000ffULL, 0x00000e80003f0107ULL,
0x00000004000000ffULL, 0x00000f1000140102ULL, 0x00000000000000ffULL, 0x0000188000140101ULL,
0x000176a8000000ffULL, 0x0000191000040107ULL, 0x000176a8000000ffULL, 0x0000198000040101ULL,
0x000176c8000000ffULL, 0x00001bc0000a0101ULL, 0x000176cc000000ffULL, 0x00001db0000b0105ULL,
0x000176cc000000ffULL, 0x000026c0000b0105ULL, 0x000176b0000000ffULL, 0x000027c000180107ULL,
0x000176b0000000ffULL, 0x0000282000180101ULL, 0x0001760800000004ULL, 0x00002860003f0101ULL,
0x0001760c00000004ULL, 0x00002a30003f0105ULL, 0x0001760c00000004ULL, 0x00003050003f0105ULL,
0x000176ac00000012ULL, 0x00003220003f0105ULL, 0x000176ac00000012ULL, 0x00004570003f0105ULL,
0x00000000000000ffULL, 0x000045d0000b0101ULL, 0x0001768800000034ULL, 0x00004610003f0101ULL,
0x0000000400000003ULL, 0x000047d0003f0105ULL, 0x0000000400000003ULL, 0x00005040003f0105ULL,
0x000176a8000000ffULL, 0x000050e0000b0107ULL, 0x000176a8000000ffULL, 0x00005140000b0101ULL,
0x0001762800000004ULL, 0x00005180003f0101ULL, 0x0001762c00000004ULL, 0x00005350003f0105ULL,
0x0001762c00000004ULL, 0x00005960003f0105ULL, 0x000176b400000038ULL, 0x00005b30003f0105ULL,
0x000176b400000038ULL, 0x00006c20003f0105ULL, 0x00000000000000ffULL, 0x00006c80000c0101ULL,
0x00017690000000ffULL, 0x00006cc0000b0101ULL, 0x0000000400000003ULL, 0x00006e80003f0105ULL,
0x0000000400000003ULL, 0x000076f0003f0105ULL, 0x000176b0000000ffULL, 0x00007790000b0107ULL,
0x000176b0000000ffULL, 0x000077f0000b0101ULL, 0x0001764800000004ULL, 0x00007830003f0101ULL,
0x0001764c00000004ULL, 0x00007a00003f0105ULL, 0x0001764c00000004ULL, 0x00008020003f0105ULL,
0x000176ac00000034ULL, 0x000081f0003f0105ULL, 0x000176ac00000034ULL, 0x000092d0003f0105ULL,
0x00000000000000ffULL, 0x00009330000c0101ULL, 0x00017698000000ffULL, 0x00009370000b0101ULL,
0x0000000400000003ULL, 0x00009530003f0105ULL, 0x0000000400000003ULL, 0x00009e40003f0105ULL,
0x000176a8000000ffULL, 0x00009ec0000b0107ULL, 0x000176a8000000ffULL, 0x00009f20000b0101ULL,
0x00017668000000ffULL, 0x00009f60000a0101ULL, 0x0001766c000000ffULL, 0x0000a130000a0105ULL,
0x0001766c000000ffULL, 0x0000a720000a0105ULL, 0x000176b400000011ULL, 0x0000a8f0003f0105ULL,
0x000176b400000011ULL, 0x0000bb10003f0105ULL, 0x0000000000000003ULL, 0x0000bb80003f0101ULL,
0x00000000000000ffULL, 0x0000ced0000b0101ULL, 0x00017600000000ffULL, 0x0000e910003f0101ULL,
0x00017604000000ffULL, 0x0000eb30003f0105ULL, 0x00017604000000ffULL, 0x0000ed70003f0105ULL,
0x00017600000000ffULL, 0x0000edb0003f0101ULL, 0x00017604000000ffULL, 0x0000ef70003f0105ULL,
0x00017604000000ffULL, 0x00011c00003f0105ULL, 0x000000000000006dULL, 0x00011ea0003f0101ULL,
0x000000040000006dULL, 0x00012070003f0105ULL, 0x000000040000006dULL, 0x000145f0003f0105ULL,
0x0000000000000071ULL, 0x00014650003f0101ULL, 0x0000000800000071ULL, 0x000146b0003f0101ULL,
0x0000001000000071ULL, 0x00014720003f0101ULL, 0x0000001800000071ULL, 0x00053803003f0101ULL,
0x0000c5b000201c04ULL, 0x0000c8900000c5e0ULL, 0x0000cc800000ca80ULL, 0x0000efd00000ce30ULL,
0x0000040100014770ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000038cULL, 0x0000001b00000002ULL,
0x00000000000002bcULL, 0x0000001b00000002ULL, 0x00000000000001fcULL, 0x0000001b00000002ULL,
0x000000000000011cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x0000000000000368ULL, 0x0000001b00000002ULL, 0x0000000000000298ULL, 0x0000001b00000002ULL,
0x00000000000001d2ULL, 0x0000001b00000002ULL, 0x00000000000000f3ULL, 0x0000001b00000002ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000679c3ULL, 0x000e620000002700ULL,
0x00005c0000047ab9ULL, 0x000fe40000000a00ULL, 0x000000043f00728cULL, 0x000fe4000bf05070ULL,
0x00004600000e7ab9ULL, 0x000fe40000000a00ULL, 0x000000053f00728cULL, 0x000fe2000bf05300ULL,
0x0000590000067b06ULL, 0x000ea20000209000ULL, 0x0000580000107ab9ULL, 0x000fe40000000a00ULL,
0x00005c0000047ab9ULL, 0x000fc40000000a00ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000400080882ULL, 0x000fe40000000000ULL, 0x0000000106070890ULL, 0x002fe4000fffe03fULL,
0x00000008060a02a5ULL, 0x000fe4000f8e0004ULL, 0x00000008070402a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fc6000f8e00ffULL,
0x0000000e02000981ULL, 0x0002e8000c1e1900ULL, 0x0000000e04050981ULL, 0x0008e2000c1e1900ULL,
0x0000000600067308ULL, 0x004ea20000001000ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00000000000979c3ULL, 0x000e620000002600ULL, 0x000000113f00728cULL, 0x000fe2000bf65070ULL,
0x00000000000a7919ULL, 0x000e620000002300ULL, 0x00005a00000c7ab9ULL, 0x000fe20000000800ULL,
0x000000000000781cULL, 0x000fc40003f8f008ULL, 0x0000000000047919ULL, 0x010f220000002100ULL,
0x0ffffffe06077810ULL, 0x004fcc0007ffe0ffULL, 0x0000000700077305ULL, 0x000ea4000021f000ULL,
0x00000000070573c2ULL, 0x00446400000e0000ULL, 0x0000000000077919ULL, 0x004ea20000002200ULL,
0x800000053f077290ULL, 0x002fc8000fffe03fULL, 0x00000011070772a4ULL, 0x000fc8000f8e023fULL,
0x00000007050472a5ULL, 0x000fc6000f8e0004ULL, 0x0000040000077ab9ULL, 0x000fe40000000800ULL,
0x00000007050472a5ULL, 0x000fce000f8e003fULL, 0x0000000500087c82ULL, 0x000fe40008000000ULL,
0x0000003f08047290ULL, 0x000fc8000fffe13fULL, 0x00000011040472a4ULL, 0x000fc8000f8e0207ULL,
0x000000110400728cULL, 0x000fd6000bf26070ULL, 0x8000001104041290ULL, 0x000fe4000fffe03fULL,
0x0000000108081890ULL, 0x000fe4000fffe03fULL, 0x000000110400728cULL, 0x000fd6000bf46070ULL,
0x0000000108082890ULL, 0x000fe4000fffe03fULL, 0x000000113f08b292ULL, 0x000fc8000f8e333fULL,
0x0000003f0800728cULL, 0x000fca000bf65070ULL, 0x0000000800027d06ULL, 0x000e700008209000ULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02037810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff027819ULL, 0x010fc80000011604ULL, 0x0000000300037305ULL, 0x000e62000021f000ULL,
0x00001fff02067589ULL, 0x000f2200000e0000ULL, 0x00000000030573c2ULL, 0x00246400000e0000ULL,
0x000001000a037a24ULL, 0x004fcc00078e0207ULL, 0x00000000061273c2ULL, 0x01052200000e0000ULL,
0x00001fff0a0a7589ULL, 0x000f2200000e0000ULL, 0x00000000030b7a24ULL, 0x000fca00078e0204ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x000000030b00780cULL, 0x040fe40003f64070ULL,
0x0000007f0b00780cULL, 0x000fe20003f44070ULL, 0x00000005080472a4ULL, 0x002fc8000f8e023fULL,
0x0000003f04077290ULL, 0x000fc8000fffe13fULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x3fffff60ff06b424ULL, 0x004fe200078e00ffULL,
0x00000007050472a5ULL, 0x000fe2000f8e0004ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0xff317217ff0ca424ULL, 0x000fe200078e00ffULL, 0x00000009050472a5ULL, 0x000fce000f8e003fULL,
0x0000000500077c82ULL, 0x000fe40008000000ULL, 0x0000003f07047290ULL, 0x000fc8000fffe13fULL,
0x00000004080472a4ULL, 0x000fc8000f8e0209ULL, 0x000000080400728cULL, 0x000fd6000bf26070ULL,
0x0000000408041290ULL, 0x000fe4000fffe13fULL, 0x0000000107071890ULL, 0x000fe4000fffe03fULL,
0x000000080400728cULL, 0x000fd6000bf46070ULL, 0x0000000107072890ULL, 0x000fe4000fffe03fULL,
0x000000083f07b292ULL, 0x000fc8000f8e333fULL, 0x0000003f07057290ULL, 0x000fc8000fffe13fULL,
0x00000005080572a4ULL, 0x000fc8000f8e0209ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000000000b43c2ULL, 0x00886400000e0000ULL, 0x00000010060b82a4ULL, 0x002fe2000f8e023fULL,
0x0000000105050824ULL, 0x000fca00078e0a00ULL, 0x00000000050a03c2ULL, 0x0002a200000e0000ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x00000010000a8c82ULL, 0x004fe20008000000ULL,
0x000000120a007c11ULL, 0x010fe2000f8e10ffULL, 0x0000000c0a0872a4ULL, 0x000fc8000f8e023fULL,
0x0000000805047290ULL, 0x000fe2000fffe13fULL, 0x7fffffc0ff059424ULL, 0x002fe200078e00ffULL,
0x000000050800728cULL, 0x000fe4000bf26070ULL, 0x000000100400788cULL, 0x000fe4000bf41070ULL,
0x3fffff80ff028424ULL, 0x000fe200078e00ffULL, 0x000000110c0872a4ULL, 0x000fe2000f8e023fULL,
0x7fffff80ff038424ULL, 0x000fe200078e00ffULL, 0x0000001004097887ULL, 0x000fe40009000000ULL,
0x000000080b1372a4ULL, 0x000fc4000f8e023fULL, 0x01760002ff008388ULL, 0x0003e20000000a00ULL,
0x000000010b00780cULL, 0x000fe20003f04070ULL, 0x0000003f09097287ULL, 0x000fe40008800000ULL,
0x017608040b009388ULL, 0x000fe20000008a00ULL, 0x0000000c070472a4ULL, 0x000fe4000f8e0213ULL,
0x000000100900788cULL, 0x000fe2000bf05270ULL, 0x017688060b00b388ULL, 0x000fe20000008a00ULL,
0x3fffff80ff02b424ULL, 0x002fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0174000c0b00a388ULL, 0x000fe40000004800ULL, 0x3fffffc0ff088424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff098424ULL, 0x000fe200078e00ffULL, 0x0176a8020b00b388ULL, 0x000fe80000008a00ULL,
0x0176c8080b008388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000200037824ULL, 0x000fd800078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000007b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000000007308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fca0000011602ULL,
0x0000000103077824ULL, 0x000fe200078e0206ULL, 0x0ffffffe00047810ULL, 0x002fc80007ffe0ffULL,
0x0000000507007c10ULL, 0x000fe2000fffe0ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x004fc800078e0a05ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905057227ULL, 0x000fcc00078e0004ULL,
0x0000000005057227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x00005a0009047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f06070ULL,
0x80005a0004040a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0x0000000903047c17ULL, 0x000fca000f800000ULL,
0x0000000104037824ULL, 0x000fca00078e0a03ULL, 0x000000030600720cULL, 0x000fe20003f06070ULL,
0x0000000107037824ULL, 0x000fe200078e0202ULL, 0x0000000105051810ULL, 0x000fe20007ffe0ffULL,
0x0000001007067824ULL, 0x000fe200078e00ffULL, 0x00005a00ff05aa12ULL, 0x000fc800078e33ffULL,
0xfffffff006037812ULL, 0x000fe200078ee203ULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x00005a0009007a24ULL, 0x000fe400078e0200ULL, 0x0000001003037824ULL, 0x000fc600078e00ffULL,
0x0000000400007c10ULL, 0x000fca000fffe0ffULL, 0x0000000805057c24ULL, 0x000fe4000f8e0200ULL,
0x0000001002007824ULL, 0x000fe400078e00ffULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0x000000f000097812ULL, 0x000fc800078ec0ffULL, 0x0000000904097212ULL, 0x000fc800078efcffULL,
0x0000600009047a10ULL, 0x000fc80007f3e0ffULL, 0x0000610005057a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000c101c4eULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000302037211ULL, 0x004fc800078fe0ffULL, 0x0000000503007c10ULL, 0x040fe4000fffe0ffULL,
0x0ffffffe06077810ULL, 0x002fe20007ffe0ffULL, 0x0000000103067824ULL, 0x040fe400078e0202ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000000700057305ULL, 0x000e68000021f000ULL,
0xfffffff003067812ULL, 0x000fca00078ee206ULL, 0x0000001006037824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x002fc800078e0a05ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x0000000905097227ULL, 0x000fcc00078e0004ULL, 0x0000000009047227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x00005a0005057a24ULL, 0x000fca00078e0200ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff04aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x00005a0005007a24ULL, 0x000fca00078e0200ULL,
0x0000000400057c10ULL, 0x000fe2000fffe0ffULL, 0x0000001002007824ULL, 0x000fc800078e00ffULL,
0x0000000804057c24ULL, 0x000fe2000f8e0205ULL, 0x000000f000077812ULL, 0x000fc600078ec0ffULL,
0x0000010005047825ULL, 0x000fca00078e00ffULL, 0x0000000704047212ULL, 0x000fc800078efcffULL,
0x0000600004047a10ULL, 0x000fc80007f1e0ffULL, 0x0000610005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c4eULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000037806ULL, 0x000fc800038e0000ULL,
0x0000000300047300ULL, 0x000e7000000e0000ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff047224ULL, 0x004fd400078e0a06ULL, 0x01760404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000400047882ULL, 0x000fe40000000000ULL, 0x00006800000c7ab9ULL, 0x000fe40000000a00ULL,
0x00000004060c72a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff627e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff637e24ULL, 0x000fca000f8e00ffULL, 0x0000000e62627981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x00000000620873c2ULL, 0x004ea200000e0000ULL,
0x000000ff620a7810ULL, 0x000fc80007ffe0ffULL, 0x00000008ff727819ULL, 0x000fe2000001160aULL,
0x0000003f08087890ULL, 0x004fc8000fffe03fULL, 0x000000063f087899ULL, 0x000fe40008011608ULL,
0x0000c01000008947ULL, 0x000fea0003800000ULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x00000001120c7892ULL, 0x000fe4000f8ec03fULL, 0x0001768812147891ULL, 0x000fe4000f8e183fULL,
0x000000023f117899ULL, 0x000fe20008011612ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000403ffff798cULL, 0x0005e20008000014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x03ffffff110d7892ULL, 0x000fe2000f8ec03fULL, 0xffffffffff037424ULL, 0x004fe200078e00ffULL,
0x00006a00000b7ab9ULL, 0x000fe20000000800ULL, 0x00000000ffff7f8cULL, 0x000fe2000c800414ULL,
0x000000080d00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001060a8899ULL, 0x000fc8000800063fULL, 0x0000000b0a0a82a4ULL, 0x000fc8000f8e020bULL,
0x0000000a0d108290ULL, 0x000fc6000fffe03fULL, 0x00006600000a7ab9ULL, 0x000fe40000000a00ULL,
0x00000004100a82a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff047e24ULL, 0x002fe4000f8e00ffULL,
0x0000000bff057e24ULL, 0x000fca000f8e00ffULL, 0x0000000e04038981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000013f147899ULL, 0x000fe40008011612ULL,
0x0000000607167899ULL, 0x000fe4000800063fULL, 0x0000000514157899ULL, 0x000fc8000800063fULL,
0x00000020160a7892ULL, 0x000fe2000f8ef815ULL, 0x0000590003037a24ULL, 0x004fc800078e02ffULL,
0x00000040030f7824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x000000040c0b7899ULL, 0x000fe2000800063fULL, 0x00000003ff047819ULL, 0x000fe40000011602ULL,
0x0000001562037c17ULL, 0x000fe4000f800000ULL, 0x0000000404087810ULL, 0x040fe40007ffe0ffULL,
0x0000000b04057c10ULL, 0x000fe4000fffe0ffULL, 0x8000001503037c10ULL, 0x000fc6000fffe0ffULL,
0x0000000105067824ULL, 0x000fe200078e0202ULL, 0x0000000b03037c17ULL, 0x000fe2000f800000ULL,
0x0000000805077824ULL, 0x040fe200078e00ffULL, 0x0000000a05057c10ULL, 0x000fe4000fffe0ffULL,
0x8000000b03037c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff8070c7812ULL, 0x000fe400078ee206ULL,
0x0000000804067810ULL, 0x040fe40007ffe0ffULL, 0x000000030400720cULL, 0x000fc40003f66070ULL,
0x0000000c04047810ULL, 0x000fe40007ffe0ffULL, 0x0000000b06097c10ULL, 0x000fe4000fffe0ffULL,
0x000000030400720cULL, 0x0c0fe40003f06070ULL, 0x0000000b040b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000109047824ULL, 0x140fe200078e0202ULL, 0x0000000b08077c10ULL, 0x040fe2000fffe0ffULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0x000000030800720cULL, 0x080fe20003f46070ULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x000000030600720cULL, 0x000fe20003f26070ULL,
0x0000000107037824ULL, 0x000fe200078e0202ULL, 0xfffffff8110e7812ULL, 0x000fe200078ee204ULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0x0000000a07077c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b067824ULL, 0x000fe200078e0202ULL, 0x0000000a09097c10ULL, 0x000fe2000fffe0ffULL,
0x0000008005047825ULL, 0x000fe200078e00ffULL, 0x0000000a0b0b7c10ULL, 0x000fe2000fffe0ffULL,
0x00013000140b7891ULL, 0x000fe2000f8e683fULL, 0xfffffff8080d7812ULL, 0x000fe200078ee203ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0xfffffff813107812ULL, 0x000fc400078ee206ULL,
0x000064000f037a11ULL, 0x000fe200078838ffULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x100fe400078ef800ULL, 0x000065000f0f7a11ULL, 0x000fe200020f3cffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000000403047210ULL, 0x000fe40007fbe0ffULL,
0x0000007006067812ULL, 0x100fe400078ef800ULL, 0x0000007008087812ULL, 0x100fe200078ef800ULL,
0x0000000105057824ULL, 0x000fe200028e060fULL, 0x000000700a007812ULL, 0x000fc400078ef800ULL,
0x0000000306067210ULL, 0x080fe40007f9e0ffULL, 0x0000000308087210ULL, 0x080fe40007fbe0ffULL,
0x00000003000a7210ULL, 0x000fe20007fde0ffULL, 0x0000000107077824ULL, 0x100fe200020e060fULL,
0x0000000b0c037c11ULL, 0x000fe2000f8e20ffULL, 0x0000000109097824ULL, 0x100fe200028e060fULL,
0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010b0b7824ULL, 0x000fe200030e060fULL,
0x0000000b0e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000d901c4eULL, 0x0000000b10117c11ULL, 0x000fc6000f8e20ffULL,
0x00000000060d7faeULL, 0x0003e8000d101c4eULL, 0x00000000080f7faeULL, 0x0003e8000c901c4eULL,
0x000000000a117faeULL, 0x0003e2000c101c4eULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000040c0b7899ULL, 0x000fcc000800063fULL, 0x0000000b02037c11ULL, 0x000fe2000f8fe8ffULL,
0x00013000140b7891ULL, 0x000fc6000f8e683fULL, 0x0000000403057810ULL, 0x040fe20007ffe0ffULL,
0x0000000103047824ULL, 0x140fe200078e0202ULL, 0x0000000803077810ULL, 0x040fe20007ffe0ffULL,
0x0000000803097824ULL, 0x000fe400078e00ffULL, 0x00000008050d7824ULL, 0x000fe400078e00ffULL,
0x0000000107067824ULL, 0x000fe200078e0202ULL, 0xfffffff8090c7812ULL, 0x000fe200078ee204ULL,
0x0000000105047824ULL, 0x000fe200078e0202ULL, 0x0000000c03097810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fc600078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee204ULL,
0x0000000109087824ULL, 0x000fe200078e0202ULL, 0x0000000a03047c10ULL, 0x000fe2000fffe0ffULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee206ULL,
0x0000000a05067c10ULL, 0x000fe2000fffe0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe400078ee208ULL, 0x0000000a07087c10ULL, 0x000fe2000fffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a090a7c10ULL, 0x000fc4000fffe0ffULL,
0x000064000f037a11ULL, 0x040fe200078038ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x100fe400078ef800ULL, 0x000065000f0f7a11ULL, 0x000fe200000f3cffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000403047210ULL, 0x000fe40007f1e0ffULL,
0x0000007006067812ULL, 0x100fe400078ef800ULL, 0x0000007008087812ULL, 0x100fe200078ef800ULL,
0x0000000105057824ULL, 0x000fe200000e060fULL, 0x000000700a007812ULL, 0x000fc400078ef800ULL,
0x0000000603067210ULL, 0x040fe40007f3e0ffULL, 0x0000000803087210ULL, 0x040fe40007f1e0ffULL,
0x00000000030a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000107077824ULL, 0x100fe200008e060fULL,
0x0000000b0c037c11ULL, 0x000fe2000f8e20ffULL, 0x0000000109097824ULL, 0x100fe200000e060fULL,
0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010b0b7824ULL, 0x000fe200010e060fULL,
0x0000000b0e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c4eULL, 0x0000000b10117c11ULL, 0x000fc6000f8e20ffULL,
0x00000000060d7faeULL, 0x0003e8000b901c4eULL, 0x00000000080f7faeULL, 0x0003e8000b901c4eULL,
0x000000000a117faeULL, 0x0003e4000b901c4eULL, 0x000000010d0d7890ULL, 0x000fe2000fffe03fULL,
0xffffffffff057424ULL, 0x002fe200078e00ffULL, 0x00006a00000b7ab9ULL, 0x000fc40000000800ULL,
0x000000080d00728cULL, 0x000fe4000bf06070ULL, 0x0000000dff007e24ULL, 0x000fc8000f8e00ffULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00000001060a8899ULL, 0x000fc8000800063fULL,
0x0000000b0a0a82a4ULL, 0x000fc8000f8e020bULL, 0x00000000000d83c2ULL, 0x000e6200000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000d0a0d8290ULL, 0x002fc6000fffe03fULL,
0x00006600000a7ab9ULL, 0x000fe40000000a00ULL, 0x000000040d0a82a5ULL, 0x000fe4000f8e000aULL,
0x0000000414047899ULL, 0x000fc8000800063fULL, 0x0000000aff067e24ULL, 0x000fe2000f8e00ffULL,
0x000176a8040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000bff077e24ULL, 0x000fc6000f8e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000e06058981ULL, 0x000328000c1e1900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a0aULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a800ff067f8cULL, 0x002e62000c800404ULL,
0x00000003140a7899ULL, 0x000fe2000800063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff00000008000ULL,
0x0176c800ff087f8cULL, 0x000ea2000c80040aULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff047224ULL, 0x004fe200078e0009ULL,
0x0000a0f000008947ULL, 0x000fea0003800000ULL, 0x0000001004047892ULL, 0x000fe2000f8ec03fULL,
0x000000ffff097224ULL, 0x002fe200078e0007ULL, 0x0000000106067899ULL, 0x000fe2000800063fULL,
0xff317217ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000411047291ULL, 0x000fe2000f8e283fULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x00006a00000a7ab9ULL, 0x000fc40000000800ULL,
0x0000000a060672a4ULL, 0x000fe4000f8e020aULL, 0x000000040c0a7291ULL, 0x000fc6000f8e183fULL,
0x0000003f00047c82ULL, 0x000fc40008000000ULL, 0x000000ffff757224ULL, 0x002fce00078e0000ULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x00000002120b7899ULL, 0x000fc8000800063fULL,
0xfffffff80b0b7892ULL, 0x000fc8000f8ec03fULL, 0x000176c80b177890ULL, 0x000fca000fffe03fULL,
0x0176cc0bff037984ULL, 0x000e640008000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804804ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x00000017ff037e24ULL, 0x000fe2000f8e00ffULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140fULL,
0x0000000e03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x0000000203037819ULL, 0x000fc8000000120eULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc0bff037984ULL, 0x000e640008000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804804ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000017ff037e24ULL, 0x000fc4000f8e00ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004120c7899ULL, 0x000fe2000800063fULL, 0x0000590005057a24ULL, 0x010fe200078e02ffULL,
0x0000000104187890ULL, 0x000fe4000fffe03fULL, 0xffffffe00c0d7892ULL, 0x000fe2000f8ec03fULL,
0x0000004005357824ULL, 0x000fc600078e00ffULL, 0x0000000d040d7291ULL, 0x000fe2000f8e403fULL,
0x0000001872007c0cULL, 0x000fc6000bf23070ULL, 0x000000400d107890ULL, 0x000fc8000fffe03fULL,
0x00000020100d7892ULL, 0x000fc8000f8ec03fULL, 0x0000000d160d7290ULL, 0x000fe4000fffe03fULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x000fe20000011602ULL,
0x000000100c0c7892ULL, 0x000fe2000f8ec03fULL, 0x0000001062047c17ULL, 0x000fe4000f800000ULL,
0x000000040f117810ULL, 0x000fe40007ffe0ffULL, 0x8000001004047c10ULL, 0x000fe4000fffe0ffULL,
0x0000000c110d7c10ULL, 0x000fc4000fffe0ffULL, 0x0000000c04047c17ULL, 0x000fe4000f800000ULL,
0x0000000c0f057c10ULL, 0x000fe2000fffe0ffULL, 0x000000010d0c7824ULL, 0x140fe200078e0202ULL,
0x8000000c04047c10ULL, 0x000fe2000fffe0ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x0000000c0f217810ULL, 0x000fe20007ffe0ffULL, 0x00000001050b7824ULL, 0x000fe200078e0202ULL,
0x000000041100720cULL, 0x000fe20003f66070ULL, 0x00000008050e7824ULL, 0x000fe200078e00ffULL,
0xfffffff813117812ULL, 0x000fe200078ee20cULL, 0x00000010020c7824ULL, 0x000fe200078e00ffULL,
0x000000080f137810ULL, 0x000fc40007ffe0ffULL, 0x0000000d05057c10ULL, 0x000fe4000fffe0ffULL,
0x000000040f00720cULL, 0x080fe40003f86070ULL, 0x000000041300720cULL, 0x080fe40003f46070ULL,
0x000000042100720cULL, 0x000fe20003f06070ULL, 0x0000008005047825ULL, 0x000fe200078e00ffULL,
0x000000700c377812ULL, 0x000fe400078ec0ffULL, 0x0000000c130f7c10ULL, 0x000fc4000fffe0ffULL,
0x0000640035237a11ULL, 0x000fe400078a38ffULL, 0x0000000d0d0d7c10ULL, 0x000fe2000fffe0ffULL,
0x000000080f137824ULL, 0x040fe200078e00ffULL, 0x0000003704127212ULL, 0x000fe400078efcffULL,
0xfffffff80e0b7812ULL, 0x000fe200078ee20bULL, 0x000000010f0e7824ULL, 0x100fe200078e0202ULL,
0x0000000c21217c10ULL, 0x000fe2000fffe0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000650035357a11ULL, 0x000fe200028f3cffULL, 0x00014000140c7891ULL, 0x000fe2000f8e683fULL,
0x0000001223127210ULL, 0x000fe20007fbe0ffULL, 0x0000000121227824ULL, 0x000fe200078e0202ULL,
0x0000000d0f047c10ULL, 0x000fc4000fffe0ffULL, 0x0000000d210f7c10ULL, 0x040fe2000fffe0ffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0xfffffff813207812ULL, 0x000fe200078ee20eULL,
0x0000000105137824ULL, 0x000fe200028e0635ULL, 0x000000370c0c7212ULL, 0x000fe200078efcffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0xfffffff821227812ULL, 0x000fe400078ee222ULL,
0x000000230c0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000003704047212ULL, 0x000fc400078efcffULL, 0x0000000c0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010d0d7824ULL, 0x100fe200028e0635ULL, 0x000000370e0e7212ULL, 0x000fe400078efcffULL,
0x0000002304047210ULL, 0x080fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120b7faeULL, 0x0003e2000e101c4eULL, 0x000000230e0e7210ULL, 0x000fe40007fde0ffULL,
0x0000000c11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000105057824ULL, 0x100fe200028e0635ULL,
0x0000000c20217c11ULL, 0x000fe2000f8e20ffULL, 0x000000010f0f7824ULL, 0x000fe200030e0635ULL,
0x0000000c22237c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c117faeULL, 0x0003e8000d901c4eULL,
0x0000000004217faeULL, 0x0003e8000d101c4eULL, 0x000000000e237faeULL, 0x0003e2000c101c4eULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x000000100c0c7892ULL, 0x000fcc000f8ec03fULL,
0x0000000c02057c11ULL, 0x000fe2000f8fe8ffULL, 0x00014000140c7891ULL, 0x000fc6000f8e683fULL,
0x00000004050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105047824ULL, 0x140fe200078e0202ULL,
0x00000008050f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008050b7824ULL, 0x040fe200078e00ffULL,
0x0000000c05137810ULL, 0x000fe20007ffe0ffULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0x0000000d05057c10ULL, 0x000fe2000fffe0ffULL, 0x000000010f0c7824ULL, 0x000fe200078e0202ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL, 0x000000010d047824ULL, 0x040fe200078e0202ULL,
0x0000000d0d0d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000080f217824ULL, 0x040fe200078e00ffULL,
0x0000000d0f0f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee204ULL, 0x0000000113047824ULL, 0x000fe200078e0202ULL,
0xfffffff821207812ULL, 0x000fe200078ee20cULL, 0x00000010020c7824ULL, 0x000fe200078e00ffULL,
0x0000000d13137c10ULL, 0x000fe2000fffe0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff823227812ULL, 0x000fc400078ee204ULL, 0x000000700c217812ULL, 0x000fe200078ec0ffULL,
0x0000008005047825ULL, 0x000fe200078e00ffULL, 0x0000640035237a11ULL, 0x000fe400078038ffULL,
0x000000210e0e7212ULL, 0x080fe200078efcffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000002104047212ULL, 0x000fe400078efcffULL, 0x0000650035357a11ULL, 0x000fe200000f3cffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000000423047210ULL, 0x000fc40007f1e0ffULL,
0x000000210c0c7212ULL, 0x080fe400078efcffULL, 0x0000002112127212ULL, 0x000fe200078efcffULL,
0x0000000105057824ULL, 0x100fe200000e0635ULL, 0x0000000c230c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000e230e7210ULL, 0x040fe40007f1e0ffULL, 0x0000001223127210ULL, 0x000fe20007f7e0ffULL,
0x000000010d0d7824ULL, 0x100fe200010e0635ULL, 0x0000000c0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010f0f7824ULL, 0x100fe200000e0635ULL, 0x0000000c11117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000113137824ULL, 0x000fe200018e0635ULL, 0x0000000c20217c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000b901c4eULL,
0x0000000c22237c11ULL, 0x000fc6000f8e20ffULL, 0x000000000c117faeULL, 0x0003e8000b901c4eULL,
0x000000000e217faeULL, 0x0003e8000b901c4eULL, 0x0000000012237faeULL, 0x0003e4000b901c4eULL,
0x00000001000c7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff117424ULL, 0x000fc600078e00ffULL,
0x000000080c007c0cULL, 0x000fe2000bf06070ULL, 0x00000003120c7899ULL, 0x000fc8000800063fULL,
0xfffffff00c187892ULL, 0x000fc8000f8ec03fULL, 0x000176b018197890ULL, 0x000fc8000fffe03fULL,
0x000000060c0c8c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff0d8424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x000066000c0c8625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a19ULL, 0x0000000e0c118981ULL, 0x000322000c1e1900ULL,
0x000000100c107892ULL, 0x000fc4000f8ec03fULL, 0xffffffe00c0d7892ULL, 0x000fe4000f8ec03fULL,
0x000000080c0c7892ULL, 0x000fe4000f8ec03fULL, 0x00000010ff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff057e24ULL, 0x000fca000f8e00ffULL, 0x0000000c05047c10ULL, 0x000fe2000fffe004ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0176b000ff0c7f8cULL, 0x000e62000c800418ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760800040e7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff057224ULL, 0x002fe400078e000dULL,
0x000000ffff127224ULL, 0x004fc400078e000fULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x01760c00040b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804812ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001140fULL,
0x0000000e0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020b0b7819ULL, 0x000fc8000000120eULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c00040b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000005120c7899ULL, 0x000fe2000800063fULL, 0x00000010026e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff767819ULL, 0x000fe40000011602ULL, 0xffffff800c0c7892ULL, 0x000fe4000f8ec03fULL,
0x000000706e6e7812ULL, 0x000fc400078ec0ffULL, 0x0000000c76767812ULL, 0x000fc800078ec0ffULL,
0x0000000c760b7c10ULL, 0x000fca000fffe06eULL, 0x017000000b0d7984ULL, 0x000e680000000800ULL,
0x017200000b217984ULL, 0x0004e20000000800ULL, 0x0000000a0d00720bULL, 0x002fe20003f1d000ULL,
0x00011c527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff13127812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fd200078e000aULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x00000012ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a0d00720bULL, 0x000fc80003f54000ULL, 0x000000110f007c0cULL, 0x000fe2000bf05270ULL,
0x00011c027f007947ULL, 0x000fd0000b800000ULL, 0x00000000000b7806ULL, 0x000fc800010e0100ULL,
0x000000800f0f8824ULL, 0x000fe200078e026eULL, 0x0000000a0d0e7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100b0c7816ULL, 0x000fe200000000ffULL,
0x00000001760f8824ULL, 0x000fca00078e020fULL, 0x0174000e0f008388ULL, 0x0003e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000000e0a0c7221ULL, 0x002fe20000010000ULL, 0x000000ff0bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL,
0x0000000c000c7308ULL, 0x000e640000000800ULL, 0x0000000c10107220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011602ULL,
0x00011b427f007947ULL, 0x000fea000b800000ULL, 0x00001f130c137589ULL, 0x0002a400000e0000ULL,
0x0000001314147220ULL, 0x084fe40000410000ULL, 0x0000001315157220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001338387220ULL, 0x080fe40000410000ULL, 0x0000001339397220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x080fe40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802137811ULL, 0x000fe200078ff0ffULL,
0x00011a427f007947ULL, 0x000fea000b800000ULL, 0x00001f130c137589ULL, 0x00046400000e0000ULL,
0x0000001316167220ULL, 0x086fe40000410000ULL, 0x0000001317177220ULL, 0x080fe40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000133a3a7220ULL, 0x080fe40000410000ULL, 0x000000133b3b7220ULL, 0x080fe40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff12ff7812ULL, 0x000fe2000780600bULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000a0d0f7209ULL, 0x000fd60007810000ULL,
0x8000000f0d0d0221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00060308ULL, 0x000e640000000800ULL,
0x0000000621210220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001021107221ULL, 0x008fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x00000003120c7899ULL, 0x000fcc000800063fULL, 0x0000000cff127e24ULL, 0x000fca000f8e00ffULL,
0xfffffff012127812ULL, 0x000fca00078ec0ffULL, 0x0176ac00120c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a137210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x000000130c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00120c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100e097816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000006ff07723eULL, 0x000fe400000000ffULL,
0x00000002ff097819ULL, 0x000fe40000011602ULL, 0x00005410070a7816ULL, 0x000fe20000000007ULL,
0x000116027f007947ULL, 0x000fea000b800000ULL, 0x00001f090a077589ULL, 0x0002a400000e0000ULL,
0x0000000809137810ULL, 0x000fe20007ffe0ffULL, 0x000116527f007947ULL, 0x000fea000b800000ULL,
0x00001f130a087589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001009137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e000aULL,
0x000033a000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0001230000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001809137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e000aULL, 0x0000341000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0001229000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000012ff127e24ULL, 0x000fe2000f8e00ffULL, 0x00000007020c7812ULL, 0x040fe200078ec0ffULL,
0x00000009120c7899ULL, 0x000fe2000800063fULL, 0x0000000802137812ULL, 0x00cfe200078ec0ffULL,
0x0000000212127824ULL, 0x000fe200078e00ffULL, 0x000000080c647812ULL, 0x000fc600078ef802ULL,
0x0000000cff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000412097812ULL, 0x002fe200078ec0ffULL,
0x0000000864747824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000902097211ULL, 0x000fe400078fe0ffULL, 0xfffff8000e0e7812ULL, 0x000fc600078ec0ffULL,
0x0000000164737824ULL, 0x000fca00078e0209ULL, 0xfffffff874747812ULL, 0x000fca00078ee273ULL,
0x0000001074747824ULL, 0x000fc800078e00ffULL, 0x0000000174097824ULL, 0x000fc400078e020eULL,
0x00000002120b7899ULL, 0x000fe2000800063fULL, 0x00000004ff5b7819ULL, 0x000fe20000011602ULL,
0x0001300014107891ULL, 0x000fe2000f8e683fULL, 0x0000000c13347212ULL, 0x040fe200078efcffULL,
0x000000040b0b7892ULL, 0x000fe2000f8ec03fULL, 0x0000001013137812ULL, 0x000fe200078efe0cULL,
0x00000014ff787e24ULL, 0x000fe4000f8e00ffULL, 0x00000008340a7824ULL, 0x040fe400078e00ffULL,
0x0000000b5b0d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0x000176c8140b7891ULL, 0x000fe2000f8e183fULL, 0x0000000834377824ULL, 0x000fc400078e00ffULL,
0x0000000134357824ULL, 0x000fe400078e020dULL, 0x000000010d0d7824ULL, 0x000fc600078e0213ULL,
0xfffffff80a0a7812ULL, 0x000fe400078ee235ULL, 0xfffffff80c0b7812ULL, 0x000fe400078ee20dULL,
0x000000100a207c11ULL, 0x000fe4000f8e20ffULL, 0x000000100b3c7c11ULL, 0x000fe4000f8e20ffULL,
0x00000002350c7810ULL, 0x000fe40007ffe0ffULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0x000000020d0d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8370c7812ULL, 0x000fe200078ee20cULL,
0x000000003c3c783bULL, 0x000ea60000004200ULL, 0x000000100c347c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff657819ULL, 0x002fe20000011420ULL, 0x0000010020357824ULL, 0x040fe200078e00ffULL,
0x0000888020597816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x004fe2000001143cULL, 0x0000010021407824ULL, 0x000fe200078e00ffULL,
0x000088803c4b7816ULL, 0x000fe200000000ffULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff5a7819ULL, 0x000fe40000011435ULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x00000018ff467819ULL, 0x000fe4000001143dULL,
0x00000020006d7306ULL, 0x0005e20000200c00ULL, 0x000088803d4e7816ULL, 0x000fe400000000ffULL,
0x00000018ff437819ULL, 0x000fe4000001143eULL, 0x00000018ff447819ULL, 0x000fc4000001143fULL,
0x000088803e477816ULL, 0x000fe200000000ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000010022207824ULL, 0x004fe200078e00ffULL, 0x000088803f497816ULL, 0x000fe400000000ffULL,
0x0000888021587816ULL, 0x040fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe20000011421ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011422ULL, 0x00000018ff557819ULL, 0x000fe40000011423ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x00000020006a7306ULL, 0x0007e20000200c00ULL,
0x0000888022697816ULL, 0x040fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888023517816ULL, 0x000fc800000000ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000001003c207824ULL, 0x048fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x002fe20000011434ULL,
0x00000100345c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011420ULL,
0x0000000813207824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003d137824ULL, 0x040fe200078e00ffULL, 0x0000004000717306ULL, 0x0002e20000200c00ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145cULL,
0x00000100355c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00677306ULL, 0x0005e20000200c00ULL,
0x00000018ff577819ULL, 0x000fe20000011435ULL, 0x0000010023407824ULL, 0x002fe200078e00ffULL,
0x00008880345e7816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00008880355d7816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001145cULL, 0x00000013004f7306ULL, 0x0003e20000200c00ULL,
0x000001003e3c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000003d00667306ULL, 0x000fe20000200c00ULL, 0x000001003f137824ULL, 0x042fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8200d7812ULL, 0x000fe400078ee20dULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000003c00487306ULL, 0x0003e20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fe4000001143fULL,
0x00000018ff237819ULL, 0x000fc40000011423ULL, 0x000000100d207c11ULL, 0x000fe4000f8e20ffULL,
0x0000888036707816ULL, 0x040fe200000000ffULL, 0x00000034005c7306ULL, 0x0005e20000200c00ULL,
0x01100000093c783bULL, 0x002e620000000200ULL, 0x00000018ff507819ULL, 0x000fe40000011436ULL,
0x00000018ff527819ULL, 0x000fe40000011437ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000003500637306ULL, 0x0007e20000200c00ULL, 0x0000541059347816ULL, 0x004fe2000000005aULL,
0x0000010036597824ULL, 0x000fc400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011459ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541058357816ULL, 0x008fe40000000071ULL, 0x0000888037597816ULL, 0x000fe400000000ffULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x00000021006c7306ULL, 0x000eb00000200c00ULL,
0x0000006900697306ULL, 0x000ef00000200c00ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000000073c3c8232ULL, 0x002fc40000000000ULL, 0x000000073e3e8232ULL, 0x000fe40000000000ULL,
0x000000083d3d8232ULL, 0x080fe40000000000ULL, 0x000000083f3f8232ULL, 0x000fe20000000000ULL,
0x0000004000687306ULL, 0x000e6c0000200c00ULL, 0x000000343c14723cULL, 0x000b640000001814ULL,
0x0000007000587306ULL, 0x0003ea0000200c00ULL, 0x0000010037347824ULL, 0x020fc400078e00ffULL,
0x0000000478357824ULL, 0x000fe200078e025bULL, 0x0000002200537306ULL, 0x000fe20000200c00ULL,
0x0000000864707824ULL, 0x002fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000000235357810ULL, 0x000fc80007ffe064ULL,
0x0000002300617306ULL, 0x0003e20000200c00ULL, 0xfffffff870717812ULL, 0x000fe400078ee235ULL,
0x000054106c357816ULL, 0x004fe4000000004cULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000010710e7824ULL, 0x000fe400078e020eULL, 0x00000034005b7306ULL, 0x0005e20000200c00ULL,
0x000000002020783bULL, 0x002e6e0000004200ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x000054106d347816ULL, 0x004fce0000000065ULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x000000343c18723cULL, 0x000b6e0000001818ULL, 0x0000541069347816ULL, 0x028fe2000000006aULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541051357816ULL, 0x000fc40000000068ULL,
0x0000541053547816ULL, 0x000fe40000000054ULL, 0x0000541061557816ULL, 0x004fc60000000055ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x000000343c1c723cULL, 0x040f6e000000181cULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000000543c38723cULL, 0x000b620000001838ULL,
0x00000018ff417819ULL, 0x002fe20000011420ULL, 0x00000100206c7824ULL, 0x040fe200078e00ffULL,
0x00008880206d7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011421ULL, 0x0000010021617824ULL, 0x000fe200078e00ffULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x000054105e547816ULL, 0x024fe2000000005fULL,
0x000000ffff4c7224ULL, 0x000fe200078e006dULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000888021687816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011422ULL, 0x0000003600647306ULL, 0x000fe20000200c00ULL,
0x00000018ff517819ULL, 0x000fe2000001146cULL, 0x000000ffff537224ULL, 0x000fe200078e0068ULL,
0x00000018ff217819ULL, 0x000fca0000011421ULL, 0x0000003700657306ULL, 0x0005e20000200c00ULL,
0x000054105d557816ULL, 0x002fe40000000060ULL, 0x00000018ff5d7819ULL, 0x000fca0000011461ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x011000000e34783bULL, 0x004ea20000000200ULL,
0x000000543c24723cULL, 0x000bec0000001824ULL, 0x0000005700577306ULL, 0x000ef00000200c00ULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x000054105c547816ULL, 0x022fc40000000056ULL,
0x0000888022567816ULL, 0x000fca00000000ffULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541063557816ULL, 0x008fce0000000057ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x000000543c28723cULL, 0x000b620000001828ULL, 0x0000541064647816ULL, 0x004fe20000000050ULL,
0x000000ffff507224ULL, 0x000fca00078e0056ULL, 0x0000005900597306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fe20000000052ULL, 0x0000000734348232ULL, 0x080fe40000000000ULL,
0x0000000736368232ULL, 0x000fe40000000000ULL, 0x0000000835358232ULL, 0x080fe40000000000ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541058587816ULL, 0x008fe2000000005aULL,
0x000000643c30723cULL, 0x000fe20000001830ULL, 0x0000000837378232ULL, 0x000fca0000000000ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541059597816ULL, 0x004fce000000005bULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000000583c2c723cULL, 0x000b6e000000182cULL,
0x0000002000547306ULL, 0x0205e20000200c00ULL, 0x00008880233e7816ULL, 0x040fe200000000ffULL,
0x00000100233f7824ULL, 0x000fcc00078e00ffULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x0000010022207824ULL, 0x044fe400078e00ffULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000004600467306ULL, 0x000eb00000200c00ULL,
0x0000002100557306ULL, 0x0003f00000200c00ULL, 0x00000020003c7306ULL, 0x0005e20000200c00ULL,
0x000054104e217816ULL, 0x002fce000000004fULL, 0x00000013004a7306ULL, 0x0003e20000200c00ULL,
0x000054104b207816ULL, 0x004fce000000004dULL, 0x000000203414723cULL, 0x000b620000001814ULL,
0x00000018ff137819ULL, 0x002fe20000011423ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000004100417306ULL, 0x000e680000200c00ULL, 0x0000541067207816ULL, 0x028fe40000000045ULL,
0x0000541066217816ULL, 0x000fe40000000046ULL, 0x00000018ff457819ULL, 0x000fe2000001143fULL,
0x00000050003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fc40000011422ULL,
0x00000018ff467819ULL, 0x000fe20000011423ULL, 0x000000203418723cULL, 0x000b620000001818ULL,
0x0000541054547816ULL, 0x002fc60000000041ULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x000054103d3c7816ULL, 0x004fce000000003cULL,
0x0000004700477306ULL, 0x000e700000200c00ULL, 0x0000004900497306ULL, 0x000eb00000200c00ULL,
0x0000006f006f7306ULL, 0x000ee20000200c00ULL, 0x0000541047487816ULL, 0x002fce0000000048ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x0000541049497816ULL, 0x004fce000000004aULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x000054106f207816ULL, 0x028fe20000000043ULL,
0x00000048341c723cULL, 0x000f6c000000181cULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054106b217816ULL, 0x002fce0000000044ULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x004fe20000000042ULL, 0x000000203420723cULL, 0x040f6c0000001838ULL,
0x0000004c004c7306ULL, 0x000fe40000200c00ULL, 0x000000543428723cULL, 0x000f6c0000001828ULL,
0x0000005100517306ULL, 0x000e700000200c00ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x000054104c4c7816ULL, 0x002fce0000000051ULL,
0x0000003e003e7306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x00005410534d7816ULL, 0x004fce000000005dULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000004c3424723cULL, 0x000f6e0000001824ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000054103e3d7816ULL, 0x002fe40000000045ULL, 0x000054103f407816ULL, 0x004fca0000000040ULL,
0x0000003c342c723cULL, 0x000f62000000182cULL, 0x0000541046417816ULL, 0x008fce0000000013ULL,
0x000000403430723cULL, 0x000b6e0000001830ULL, 0xfffffff812347812ULL, 0x020fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x00000000ff127f8cULL, 0x000e62000c80040bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176880034ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff367224ULL, 0x000fc400078e00ffULL, 0x000000ffff397224ULL, 0x002fc400078e0013ULL,
0x0000000000127805ULL, 0x000fca0000015200ULL, 0x0000040003347984ULL, 0x004e640000000800ULL,
0x8000000034ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040003347984ULL, 0x000e640000000800ULL,
0x8000000034ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004120d7899ULL, 0x000fe2000800063fULL, 0x0000590011117a24ULL, 0x010fc600078e02ffULL,
0xffffffe00d0b7892ULL, 0x000fe2000f8ec03fULL, 0x00000040113b7824ULL, 0x000fc600078e00ffULL,
0x0000000b040b7291ULL, 0x000fc8000f8e403fULL, 0x000000800b0c7890ULL, 0x000fc8000fffe03fULL,
0x000000200c0b7892ULL, 0x000fc8000f8ec03fULL, 0x0000000b160b7290ULL, 0x000fe2000fffe03fULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000100d0d7892ULL, 0x000fe2000f8ec03fULL,
0x0000000c62117c17ULL, 0x000fe4000f800000ULL, 0x00000003ff127819ULL, 0x000fe40000011602ULL,
0x8000000c11117c10ULL, 0x000fe4000fffe0ffULL, 0x0000000d12137c10ULL, 0x000fe4000fffe0ffULL,
0x0000000d11117c17ULL, 0x000fc4000f800000ULL, 0x0000000812387810ULL, 0x040fe20007ffe0ffULL,
0x0000000113347824ULL, 0x040fe200078e0202ULL, 0x0000000412367810ULL, 0x000fe20007ffe0ffULL,
0x0000000813357824ULL, 0x000fe200078e00ffULL, 0x8000000d11117c10ULL, 0x000fe4000fffe0ffULL,
0x0000000d38377c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff8353a7812ULL, 0x000fe400078ee234ULL,
0x0000000d36357c10ULL, 0x040fe2000fffe0ffULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0x000000113600720cULL, 0x000fc40003f66070ULL, 0x000000111200720cULL, 0x0c0fe20003f86070ULL,
0x0000000135347824ULL, 0x140fe200078e0202ULL, 0x0000000c12367810ULL, 0x000fe20007ffe0ffULL,
0x0000000835397824ULL, 0x000fe200078e00ffULL, 0x0000000b13127c10ULL, 0x000fe2000fffe0ffULL,
0x0000000137137824ULL, 0x000fe200078e0202ULL, 0x000000113800720cULL, 0x000fe40003f46070ULL,
0xfffffff8393c7812ULL, 0x000fe400078ee234ULL, 0xfffffff83e3d7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b35347c10ULL, 0x000fc4000fffe0ffULL,
0x000000113600720cULL, 0x040fe40003f06070ULL, 0x0000000d363f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000064003b117a11ULL, 0x000fe400078a38ffULL,
0x0000006e12127212ULL, 0x000fe200078efcffULL, 0x000000013f3e7824ULL, 0x000fe200078e0202ULL,
0x0000000b37367c10ULL, 0x000fe4000fffe0ffULL, 0x0000000b3f387c10ULL, 0x040fe2000fffe0ffULL,
0x000000083f3f7824ULL, 0x000fe200078e00ffULL, 0x000065003b3b7a11ULL, 0x000fe200028f3cffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000001211127210ULL, 0x000fc40007fbe0ffULL,
0x0000006e34347212ULL, 0x080fe200078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000006e36367212ULL, 0x080fe400078efcffULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee23eULL,
0x0000000113137824ULL, 0x100fe200028e063bULL, 0x0000001134347210ULL, 0x080fe40007fbe0ffULL,
0x0000006e38387212ULL, 0x000fe400078efcffULL, 0x000000103d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000135357824ULL, 0x000fe200028e063bULL, 0x0000001136367210ULL, 0x000fc40007fbe0ffULL,
0x0000001138387210ULL, 0x000fe40007fde0ffULL, 0x000000103a117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000137377824ULL, 0x100fe200028e063bULL, 0x000000103e3f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000139397824ULL, 0x000fe200030e063bULL, 0x000000103c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e8000e101c4eULL,
0x00000000343b7faeULL, 0x0003e8000d901c4eULL, 0x00000000363d7faeULL, 0x0003e8000d101c4eULL,
0x00000000383f7faeULL, 0x0003e2000c101c4eULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x000000100d0d7892ULL, 0x000fcc000f8ec03fULL, 0x0000000d02117c11ULL, 0x000fc8000f8fe8ffULL,
0x0000000411137810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x140fe200078e0202ULL,
0x0000000811357810ULL, 0x040fe20007ffe0ffULL, 0x0000000811377824ULL, 0x000fe400078e00ffULL,
0x0000000113347824ULL, 0x040fe400078e0202ULL, 0x0000000813397824ULL, 0x000fe200078e00ffULL,
0xfffffff8373a7812ULL, 0x000fe200078ee212ULL, 0x0000000135367824ULL, 0x000fe200078e0202ULL,
0x0000000c11377810ULL, 0x000fe20007ffe0ffULL, 0x00000008353d7824ULL, 0x000fe200078e00ffULL,
0x0000000b11127c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff8393c7812ULL, 0x000fe200078ee234ULL,
0x0000000137387824ULL, 0x000fe200078e0202ULL, 0x0000000b13347c10ULL, 0x000fe2000fffe0ffULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee236ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b35367c10ULL, 0x000fe4000fffe0ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000000b37387c10ULL, 0x000fc4000fffe0ffULL, 0x000064003b117a11ULL, 0x040fe200078038ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006e12127212ULL, 0x000fe400078efcffULL,
0x000065003b3b7a11ULL, 0x000fe200000f3cffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000001211127210ULL, 0x000fe40007f1e0ffULL, 0x0000006e34347212ULL, 0x080fe400078efcffULL,
0x0000006e36367212ULL, 0x080fe200078efcffULL, 0x0000000113137824ULL, 0x000fe200000e063bULL,
0x0000006e38387212ULL, 0x000fc400078efcffULL, 0x0000003411347210ULL, 0x040fe40007f5e0ffULL,
0x0000003611367210ULL, 0x040fe40007f1e0ffULL, 0x0000003811387210ULL, 0x000fe20007f7e0ffULL,
0x0000000135357824ULL, 0x100fe200010e063bULL, 0x000000103a117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000137377824ULL, 0x100fe200000e063bULL, 0x000000103d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000139397824ULL, 0x000fe200018e063bULL, 0x000000103c3b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e2000b901c4eULL,
0x000000103f3f7c11ULL, 0x000fc6000f8e20ffULL, 0x00000000343b7faeULL, 0x0003e8000b901c4eULL,
0x00000000363d7faeULL, 0x0003e8000b901c4eULL, 0x00000000383f7faeULL, 0x0003e4000b901c4eULL,
0x0000000200347810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff127424ULL, 0x000fc600078e00ffULL,
0x0000000834007c0cULL, 0x000fe2000bf06070ULL, 0x00000003120b7899ULL, 0x000fc8000800063fULL,
0xfffffff00b0b7892ULL, 0x000fc8000f8ec03fULL, 0x000176a80b0c7890ULL, 0x000fc8000fffe03fULL,
0x0000000634348c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff358424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000660034348625ULL, 0x000fe200078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a0cULL, 0x0000000e34128981ULL, 0x000322000c1e1900ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800ff347f8cULL, 0x002e62000c80040bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280004367f8cULL, 0x000ea2000c80043fULL, 0x000000ffff117224ULL, 0x002fc400078e0035ULL,
0x000000ffff387224ULL, 0x004fc400078e0037ULL, 0x0000000000347805ULL, 0x000fca0000015200ULL,
0x01762c0004137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804838ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011437ULL,
0x0000003613137211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x0000000213137819ULL, 0x000fc80000001236ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000139397810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c0004137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804838ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000005120b7899ULL, 0x000fc8000800063fULL, 0xffffff800b0b7892ULL, 0x000fcc000f8ec03fULL,
0x0000000bff137e24ULL, 0x000fca000f8e00ffULL, 0x000000806e137810ULL, 0x000fca0007ffe013ULL,
0x0000000176137824ULL, 0x000fca00078e0213ULL, 0x0170000013387984ULL, 0x000e680000000800ULL,
0x0172000013397984ULL, 0x0004e20000000800ULL, 0x0000000f3800720bULL, 0x002fe20003f1d000ULL,
0x0000f5b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff133b7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff137424ULL, 0x000fd600078e00ffULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x00000001110b7890ULL, 0x000fe2000fffe03fULL, 0x00000012ff377e24ULL, 0x000fe2000f8e00ffULL,
0x0000000f3800720bULL, 0x000fc80003f54000ULL, 0x0000000b37007c0cULL, 0x000fe2000bf05270ULL,
0x0000f5627f007947ULL, 0x000fd0000b800000ULL, 0x00000000003a7806ULL, 0x000fc800010e0100ULL,
0x0000008037358824ULL, 0x000fe200078e026eULL, 0x0000000f38138209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099103a347816ULL, 0x000fe200000000ffULL,
0x0000000176368824ULL, 0x000fca00078e0235ULL, 0x0174001336008388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f38347209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff3aff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f34137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x00000013003d7308ULL, 0x000e640000000800ULL,
0x0000003d10107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011602ULL, 0x0000f4927f007947ULL, 0x000fea000b800000ULL,
0x00001f133d137589ULL, 0x0002a400000e0000ULL, 0x0000001314147220ULL, 0x084fe40000410000ULL,
0x0000001315157220ULL, 0x080fe40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x000fc40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x080fe40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x000fc40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x080fe40000410000ULL, 0x0000001330307220ULL, 0x080fe40000410000ULL,
0x0000001331317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802137811ULL, 0x000fe200078ff0ffULL, 0x0000f3927f007947ULL, 0x000fea000b800000ULL,
0x00001f133d137589ULL, 0x00046400000e0000ULL, 0x0000001316167220ULL, 0x086fe40000410000ULL,
0x0000001317177220ULL, 0x080fe40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x000fc40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x000fc40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x080fe40000410000ULL, 0x0000001332327220ULL, 0x080fe40000410000ULL,
0x0000001333337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fe2000780603aULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000f380f7209ULL, 0x000fd60007810000ULL, 0x8000000f38380221ULL, 0x000fe20000010000ULL,
0x00007610ff130816ULL, 0x000fc60000000013ULL, 0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL,
0x0000003800060308ULL, 0x000e640000000800ULL, 0x0000000639390220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001039107221ULL, 0x008fc40000010000ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x00000003120b7899ULL, 0x000fcc000800063fULL,
0x0000000bff387e24ULL, 0x000fca000f8e00ffULL, 0xfffffff038387812ULL, 0x000fca00078ec0ffULL,
0x0176b40038367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003936367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b40038367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991013057816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0500720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000006ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff387819ULL, 0x000fe40000011602ULL,
0x0000541005057816ULL, 0x000fe20000000005ULL, 0x0000ef527f007947ULL, 0x000fea000b800000ULL,
0x00001f3805077589ULL, 0x0002a400000e0000ULL, 0x0000000838137810ULL, 0x000fe20007ffe0ffULL,
0x0000efa27f007947ULL, 0x000fea000b800000ULL, 0x00001f1305087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001038137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0005ULL, 0x00005cb000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000f9f000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001838137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0005ULL,
0x00005d2000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000f98000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100010177890ULL, 0x000fe4000fffe03fULL, 0x00000001120b7899ULL, 0x000fe4000800063fULL,
0x000176c8140c7891ULL, 0x000fe4000f8e183fULL, 0x000000170a607c11ULL, 0x000fe2000f8e20ffULL,
0xfffffff80b0b7892ULL, 0x000fe2000f8ec03fULL, 0x000000170c407c11ULL, 0x000fe4000f8e20ffULL,
0x000000170b5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000006038783bULL, 0x002e620000004200ULL,
0x000000170d347c11ULL, 0x000fc6000f8e20ffULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000005f3c783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x00000018ff677819ULL, 0x002fe20000011438ULL, 0x00000100384c7824ULL, 0x040fe200078e00ffULL,
0x00008880384b7816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011439ULL, 0x00000100394d7824ULL, 0x040fe200078e00ffULL,
0x0000888039777816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000001003b4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x00000018ff547819ULL, 0x000fe4000001143aULL,
0x00000018ff557819ULL, 0x000fe4000001143bULL, 0x000088803a6a7816ULL, 0x000fe200000000ffULL,
0x0000003800717306ULL, 0x0003e20000200c00ULL, 0x00000018ff577819ULL, 0x008fe40000011440ULL,
0x00000018ff517819ULL, 0x000fe40000011441ULL, 0x00008880405c7816ULL, 0x000fc400000000ffULL,
0x00008880415b7816ULL, 0x040fe200000000ffULL, 0x0000003900707306ULL, 0x0007e20000200c00ULL,
0x000001003a387824ULL, 0x042fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x004fe4000001143cULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004c00687306ULL, 0x0002a20000200c00ULL,
0x0000010041397824ULL, 0x048fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc4000001143dULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800697306ULL, 0x0007e20000200c00ULL,
0x000088803b4c7816ULL, 0x042fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x000088803d4f7816ULL, 0x000fe400000000ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x00000039005e7306ULL, 0x0003e20000200c00ULL,
0x0000010040387824ULL, 0x048fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc40000011442ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003a00637306ULL, 0x000fe20000200c00ULL,
0x0000010043397824ULL, 0x002fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000888042567816ULL, 0x000fe400000000ffULL, 0x00000018ff587819ULL, 0x000fe40000011439ULL,
0x00000038005d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fc40000011443ULL,
0x0000888043537816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe4000001143eULL, 0x00000018ff467819ULL, 0x000fe2000001143fULL,
0x0000003b00597306ULL, 0x000fe20000200c00ULL, 0x0000010042387824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe40000011434ULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff057819ULL, 0x000fe40000011435ULL, 0x00000018ff5a7819ULL, 0x000fe40000011436ULL,
0x00000018ff447819ULL, 0x000fe20000011437ULL, 0x0000003800527306ULL, 0x0003f00000200c00ULL,
0x0000004d00787306ULL, 0x000ee20000200c00ULL, 0x011800000938783bULL, 0x002e6e0000000200ULL,
0x0000004c004d7306ULL, 0x0005f00000200c00ULL, 0x0000004000617306ULL, 0x0007e20000200c00ULL,
0x000088803c4c7816ULL, 0x004fce00000000ffULL, 0x0000004100647306ULL, 0x0005e20000200c00ULL,
0x000001003c407824ULL, 0x048fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003d417824ULL, 0x044fe200078e00ffULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000000738388232ULL, 0x082fe20000000000ULL,
0x0000003c006d7306ULL, 0x0003e20000200c00ULL, 0x000000073a3a8232ULL, 0x000fe40000000000ULL,
0x0000000839398232ULL, 0x080fe40000000000ULL, 0x000000083b3b8232ULL, 0x000fc60000000000ULL,
0x0000003d006c7306ULL, 0x0005e20000200c00ULL, 0x000054104b3c7816ULL, 0x002fce0000000068ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x00005410773d7816ULL, 0x004fce0000000078ULL,
0x0000003c3814723cULL, 0x000be20000001814ULL, 0x0000006a006a7306ULL, 0x000eac0000200c00ULL,
0x000001003f3c7824ULL, 0x020fe200078e00ffULL, 0x00005410703d7816ULL, 0x002fe2000000006fULL,
0x0000004e006b7306ULL, 0x000e620000200c00ULL, 0x00000100346f7824ULL, 0x000fc400078e00ffULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000003c004b7306ULL, 0x0007f00000200c00ULL,
0x0000004200657306ULL, 0x0003e20000200c00ULL, 0x00005410713c7816ULL, 0x008fce0000000067ULL,
0x00000040004e7306ULL, 0x0007e20000200c00ULL, 0x000001003e427824ULL, 0x042fe200078e00ffULL,
0x0000003c3818723cULL, 0x000bec0000001818ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000088803e407816ULL, 0x048fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000054106a3c7816ULL, 0x024fc40000000069ULL, 0x000054104d3d7816ULL, 0x000fe4000000006bULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x0000888035697816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fca000001146fULL,
0x0000004300667306ULL, 0x0007e20000200c00ULL, 0x0000541063547816ULL, 0x002fe20000000054ULL,
0x0000010035637824ULL, 0x040fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc800078e00ffULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x000088803f437816ULL, 0x048fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000541059557816ULL, 0x004fe20000000055ULL,
0x000000ffff597224ULL, 0x000fe200078e0069ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff777819ULL, 0x000fe2000001143fULL, 0x0000005b005b7306ULL, 0x000ea40000200c00ULL,
0x000000543820723cULL, 0x000bec0000001820ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x000054105c547816ULL, 0x022fce000000005dULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054105b557816ULL, 0x004fe4000000005eULL, 0x00000018ff5b7819ULL, 0x000fca0000011463ULL,
0x0000005800587306ULL, 0x000e620000200c00ULL, 0x0000541056527816ULL, 0x008fe20000000052ULL,
0x000000543824723cULL, 0x040fec0000001824ULL, 0x0000003e00687306ULL, 0x0005f00000200c00ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000003c383c723cULL, 0x044b62000000181cULL,
0x0000541053537816ULL, 0x002fe20000000058ULL, 0x011800000e1c783bULL, 0x020e6a0000000200ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x00000052382c723cULL, 0x000b6e000000182cULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000541064557816ULL, 0x008fc40000000051ULL,
0x0000888036537816ULL, 0x020fca00000000ffULL, 0x0000004100507306ULL, 0x0007f00000200c00ULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x00000018ff417819ULL, 0x008fe40000011442ULL,
0x0000888034427816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fc800078e00ffULL,
0x0000003500527306ULL, 0x0005e20000200c00ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000000071c1c8232ULL, 0x082fe40000000000ULL, 0x000000071e1e8232ULL, 0x000fe40000000000ULL,
0x000000081d1d8232ULL, 0x080fe40000000000ULL, 0x0000003400517306ULL, 0x0003e20000200c00ULL,
0x0000541066357816ULL, 0x004fe2000000004aULL, 0x000000081f1f8232ULL, 0x000fe20000000000ULL,
0x0000541061547816ULL, 0x000fca0000000057ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541065347816ULL, 0x002fe20000000049ULL, 0x000000543828723cULL, 0x000f620000001828ULL,
0x000000ffff497224ULL, 0x000fca00078e0053ULL, 0x0000004800487306ULL, 0x000e640000200c00ULL,
0x000000343830723cULL, 0x000b6c0000001830ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000010036347824ULL, 0x020fe200078e00ffULL, 0x00008880373a7816ULL, 0x040fe200000000ffULL,
0x00000100373b7824ULL, 0x000fc400078e00ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004100417306ULL, 0x000ea20000200c00ULL,
0x000054106c357816ULL, 0x002fe40000000048ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000003400387306ULL, 0x0007e20000200c00ULL, 0x0000541040407816ULL, 0x004fe40000000041ULL,
0x0000541043417816ULL, 0x002fca000000004bULL, 0x0000004900397306ULL, 0x000e620000200c00ULL,
0x000054106d347816ULL, 0x008fe20000000047ULL, 0x000000401c3c723cULL, 0x040f6c000000183cULL,
0x0000004500457306ULL, 0x000ea40000200c00ULL, 0x000000341c18723cULL, 0x000b6c0000001818ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000541039387816ULL, 0x002fe20000000038ULL,
0x0001000037347824ULL, 0x020fcc00078e00ffULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541068667816ULL, 0x004fe40000000045ULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000000500057306ULL, 0x000e700000200c00ULL, 0x0000004c004c7306ULL, 0x000eb00000200c00ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x0000541052357816ULL, 0x002fce0000000005ULL,
0x0000007700677306ULL, 0x000e620000200c00ULL, 0x000054104c4e7816ULL, 0x004fce000000004eULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000054104f4f7816ULL, 0x008fce0000000050ULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x0000541067677816ULL, 0x002fe20000000046ULL,
0x0000004e1c14723cULL, 0x040b6c0000001814ULL, 0x0000005900597306ULL, 0x000fe40000200c00ULL,
0x000000661c20723cULL, 0x000b6c0000001820ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x0000541042427816ULL, 0x004fce000000004dULL, 0x0000003a003a7306ULL, 0x000ff00000200c00ULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x0000541059437816ULL, 0x002fce000000005bULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000000421c24723cULL, 0x000b6e0000001824ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x000054103a397816ULL, 0x004fce000000003bULL,
0x0000003600377306ULL, 0x000e620000200c00ULL, 0x000000381c2c723cULL, 0x000b6e000000182cULL,
0x0000003400417306ULL, 0x0004e20000200c00ULL, 0x00005410375a7816ULL, 0x002fe4000000005aULL,
0x0000541051347816ULL, 0x004fc40000000013ULL, 0x00005410415b7816ULL, 0x008fca0000000044ULL,
0x000000341c28723cULL, 0x040b700000001828ULL, 0x0000005a1c1c723cULL, 0x000b620000001830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000ff307f8cULL, 0x020e62000c80040cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01769000ffff7f8cULL, 0x000fe2000c80040bULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x000000ffff347224ULL, 0x002fc400078e0031ULL, 0x0000000000307805ULL, 0x000fca0000015200ULL,
0x0000040003057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804834ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011433ULL, 0x0000003205057211ULL, 0x000fca00078110ffULL,
0x000000ffff327224ULL, 0x000fca00000e0633ULL, 0x0000000205057819ULL, 0x000fc80000001232ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040003057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804834ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004120d7899ULL, 0x000fe2000800063fULL,
0x0000590012127a24ULL, 0x010fc600078e02ffULL, 0xffffffe00d0b7892ULL, 0x000fe2000f8ec03fULL,
0x0000004012377824ULL, 0x000fc600078e00ffULL, 0x0000000b040b7291ULL, 0x000fc8000f8e403fULL,
0x000000c00b0c7890ULL, 0x000fc8000fffe03fULL, 0x000000200c0b7892ULL, 0x000fc8000f8ec03fULL,
0x0000000b160b7290ULL, 0x000fe2000fffe03fULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000100d0d7892ULL, 0x000fe2000f8ec03fULL, 0x0000000c62057c17ULL, 0x000fe4000f800000ULL,
0x00000003ff127819ULL, 0x000fe40000011602ULL, 0x8000000c05057c10ULL, 0x000fe4000fffe0ffULL,
0x0000000d12137c10ULL, 0x000fe4000fffe0ffULL, 0x0000000d05057c17ULL, 0x000fc4000f800000ULL,
0x0000000812347810ULL, 0x040fe20007ffe0ffULL, 0x0000000113307824ULL, 0x040fe200078e0202ULL,
0x0000000412327810ULL, 0x000fe20007ffe0ffULL, 0x0000000813317824ULL, 0x000fe200078e00ffULL,
0x8000000d05057c10ULL, 0x000fe4000fffe0ffULL, 0x0000000d34337c10ULL, 0x000fe4000fffe0ffULL,
0xfffffff831367812ULL, 0x000fe400078ee230ULL, 0x0000000d32317c10ULL, 0x040fe2000fffe0ffULL,
0x00000008333a7824ULL, 0x000fe200078e00ffULL, 0x000000053200720cULL, 0x000fc40003f66070ULL,
0x000000051200720cULL, 0x0c0fe20003f86070ULL, 0x0000000131307824ULL, 0x140fe200078e0202ULL,
0x0000000c12327810ULL, 0x000fe20007ffe0ffULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000000b13127c10ULL, 0x000fe2000fffe0ffULL, 0x0000000133137824ULL, 0x000fe200078e0202ULL,
0x000000053400720cULL, 0x000fe40003f46070ULL, 0xfffffff835387812ULL, 0x000fe400078ee230ULL,
0xfffffff83a397812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b31307c10ULL, 0x000fc4000fffe0ffULL, 0x000000053200720cULL, 0x040fe40003f06070ULL,
0x0000000d323b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000640037057a11ULL, 0x000fe400078a38ffULL, 0x0000006e12127212ULL, 0x000fe200078efcffULL,
0x000000013b3a7824ULL, 0x000fe200078e0202ULL, 0x0000000b33327c10ULL, 0x000fe4000fffe0ffULL,
0x0000000b3b347c10ULL, 0x040fe2000fffe0ffULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x0000650037377a11ULL, 0x000fe200028f3cffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000001205127210ULL, 0x000fc40007fbe0ffULL, 0x0000006e30307212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006e32327212ULL, 0x080fe400078efcffULL,
0xfffffff83b3a7812ULL, 0x000fe200078ee23aULL, 0x0000000113137824ULL, 0x100fe200028e0637ULL,
0x0000000530307210ULL, 0x080fe40007fbe0ffULL, 0x0000006e34347212ULL, 0x000fe400078efcffULL,
0x0000001739397c11ULL, 0x000fe2000f8e20ffULL, 0x0000000131317824ULL, 0x000fe200028e0637ULL,
0x0000000532327210ULL, 0x000fc40007fbe0ffULL, 0x0000000534347210ULL, 0x000fe40007fde0ffULL,
0x0000001736057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000133337824ULL, 0x100fe200028e0637ULL,
0x000000173a3b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000135357824ULL, 0x000fe200030e0637ULL,
0x0000001738377c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012057faeULL, 0x0003e8000e101c4eULL, 0x0000000030377faeULL, 0x0003e8000d901c4eULL,
0x0000000032397faeULL, 0x0003e8000d101c4eULL, 0x00000000343b7faeULL, 0x0003e2000c101c4eULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x000000100d0d7892ULL, 0x000fcc000f8ec03fULL,
0x0000000d02057c11ULL, 0x000fc8000f8fe8ffULL, 0x0000000405137810ULL, 0x040fe20007ffe0ffULL,
0x0000000105127824ULL, 0x140fe200078e0202ULL, 0x0000000805317810ULL, 0x040fe20007ffe0ffULL,
0x0000000805337824ULL, 0x000fe400078e00ffULL, 0x0000000113307824ULL, 0x040fe400078e0202ULL,
0x0000000813357824ULL, 0x000fe200078e00ffULL, 0xfffffff833367812ULL, 0x000fe200078ee212ULL,
0x0000000131327824ULL, 0x000fe200078e0202ULL, 0x0000000c05337810ULL, 0x000fe20007ffe0ffULL,
0x0000000831397824ULL, 0x000fe200078e00ffULL, 0x0000000b05127c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff835387812ULL, 0x000fe200078ee230ULL, 0x0000000133347824ULL, 0x000fe200078e0202ULL,
0x0000000b13307c10ULL, 0x000fe2000fffe0ffULL, 0x00000008333b7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee232ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b31327c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee234ULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000000b33347c10ULL, 0x000fc4000fffe0ffULL,
0x0000640037057a11ULL, 0x040fe200078038ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000006e12127212ULL, 0x000fe400078efcffULL, 0x0000650037377a11ULL, 0x000fe200000f3cffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000001205127210ULL, 0x000fe40007f1e0ffULL,
0x0000006e30307212ULL, 0x080fe400078efcffULL, 0x0000006e32327212ULL, 0x080fe200078efcffULL,
0x0000000113137824ULL, 0x000fe200000e0637ULL, 0x0000006e34347212ULL, 0x000fc400078efcffULL,
0x0000003005307210ULL, 0x040fe40007f5e0ffULL, 0x0000003205327210ULL, 0x040fe40007f1e0ffULL,
0x0000003405347210ULL, 0x000fe20007f7e0ffULL, 0x0000000131317824ULL, 0x100fe200010e0637ULL,
0x0000001736057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000133337824ULL, 0x100fe200000e0637ULL,
0x0000001739397c11ULL, 0x000fe2000f8e20ffULL, 0x0000000135357824ULL, 0x000fe200018e0637ULL,
0x0000001738377c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012057faeULL, 0x0003e2000b901c4eULL, 0x000000173b3b7c11ULL, 0x000fc6000f8e20ffULL,
0x0000000030377faeULL, 0x0003e8000b901c4eULL, 0x0000000032397faeULL, 0x0003e8000b901c4eULL,
0x00000000343b7faeULL, 0x0003e4000b901c4eULL, 0x0000000300127810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000812007c0cULL, 0x000fe2000bf06070ULL,
0x00000003120b7899ULL, 0x000fc8000800063fULL, 0xfffffff00b0b7892ULL, 0x000fc8000f8ec03fULL,
0x000176b00b0c7890ULL, 0x000fc8000fffe03fULL, 0x0000000612128c10ULL, 0x000fe2000fffe0ffULL,
0x00000004ff138424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000660012128625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a0cULL,
0x0000000e12058981ULL, 0x000322000c1e1900ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b000ff127f8cULL, 0x002e62000c80040bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480004307f8cULL, 0x000ea2000c80043fULL,
0x000000ffff127224ULL, 0x002fc400078e0013ULL, 0x000000ffff347224ULL, 0x004fc400078e0031ULL,
0x0000000000307805ULL, 0x000fca0000015200ULL, 0x01764c0004137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804834ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011433ULL, 0x0000003213137211ULL, 0x000fca00078110ffULL,
0x000000ffff327224ULL, 0x000fca00000e0633ULL, 0x0000000213137819ULL, 0x000fc80000001232ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000135357810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c0004137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804834ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000005120b7899ULL, 0x000fc8000800063fULL,
0xffffff800b0b7892ULL, 0x000fcc000f8ec03fULL, 0x0000000bff137e24ULL, 0x000fca000f8e00ffULL,
0x000001006e137810ULL, 0x000fca0007ffe013ULL, 0x0000000176137824ULL, 0x000fca00078e0213ULL,
0x0170000013307984ULL, 0x000e680000000800ULL, 0x0172000013317984ULL, 0x0004e20000000800ULL,
0x0000000f3000720bULL, 0x002fe20003f1d000ULL, 0x0000d1627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13337812ULL, 0x000fe2000780c0ffULL,
0x000004c000007945ULL, 0x000fe20003800000ULL, 0x00000001ff137424ULL, 0x000fe400078e00ffULL,
0x000000ffff047224ULL, 0x000fd200078e000fULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x00000002110b7890ULL, 0x000fe2000fffe03fULL, 0x00000012ff377e24ULL, 0x000fe2000f8e00ffULL,
0x0000000f3000720bULL, 0x000fc80003f54000ULL, 0x0000000b37007c0cULL, 0x000fe2000bf05270ULL,
0x0000d1027f007947ULL, 0x000fd0000b800000ULL, 0x0000000000047806ULL, 0x000fc800010e0100ULL,
0x0000008037358824ULL, 0x000fe200078e026eULL, 0x0000000f30138209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991004327816ULL, 0x000fe200000000ffULL,
0x0000000176348824ULL, 0x000fca00078e0235ULL, 0x0174001334008388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f30327209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff04ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f32137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300397308ULL, 0x000e640000000800ULL,
0x0000003910107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011602ULL, 0x0000d0327f007947ULL, 0x000fea000b800000ULL,
0x00001f1339137589ULL, 0x0002a400000e0000ULL, 0x0000001314147220ULL, 0x084fe40000410000ULL,
0x0000001315157220ULL, 0x080fe40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x000fc40000410000ULL, 0x000000133c3c7220ULL, 0x080fe40000410000ULL,
0x000000133d3d7220ULL, 0x080fe40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x000fc40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x080fe40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0004ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802137811ULL, 0x000fe200078ff0ffULL, 0x0000cf327f007947ULL, 0x000fea000b800000ULL,
0x00001f1339137589ULL, 0x00046400000e0000ULL, 0x0000001316167220ULL, 0x086fe40000410000ULL,
0x0000001317177220ULL, 0x080fe40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x080fe40000410000ULL, 0x000000133e3e7220ULL, 0x080fe40000410000ULL,
0x000000133f3f7220ULL, 0x000fc40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x000fc40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe20007806004ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000f30047209ULL, 0x000fd60007810000ULL, 0x8000000430300221ULL, 0x000fe20000010000ULL,
0x00007610ff130816ULL, 0x000fc60000000013ULL, 0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL,
0x0000003000060308ULL, 0x000e640000000800ULL, 0x0000000631310220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001031107221ULL, 0x008fc40000010000ULL,
0x0000000000307805ULL, 0x000fca0000015200ULL, 0x00000003120b7899ULL, 0x000fcc000800063fULL,
0x0000000bff347e24ULL, 0x000fca000f8e00ffULL, 0xfffffff034347812ULL, 0x000fca00078ec0ffULL,
0x0176ac0034327984ULL, 0x000e640000000800ULL, 0x8000000032ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011433ULL,
0x000000320f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x000000020f0f7819ULL, 0x000fc80000001232ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0034327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910130f7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff307819ULL, 0x000fe40000011602ULL,
0x00005410070f7816ULL, 0x000fe20000000007ULL, 0x0000caf27f007947ULL, 0x000fea000b800000ULL,
0x00001f300f077589ULL, 0x0002a400000e0000ULL, 0x0000000830137810ULL, 0x000fe20007ffe0ffULL,
0x0000cb427f007947ULL, 0x000fea000b800000ULL, 0x00001f130f087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001030137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e000fULL, 0x0000837000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000d33000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001830137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e000fULL,
0x000083e000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000d2c000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100a347c11ULL, 0x000fe2000f8e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000100c387c11ULL, 0x000fe2000f8e20ffULL,
0x00000001120b7899ULL, 0x000fe2000800063fULL, 0x000000100d307c11ULL, 0x002fe2000f8e20ffULL,
0x000176c8140c7891ULL, 0x000fe2000f8e183fULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x000000100b407c11ULL, 0x000fe2000f8e20ffULL, 0xfffffff80b0b7892ULL, 0x000fe4000f8ec03fULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000004040783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x00000100350f7824ULL, 0x00afe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011434ULL, 0x0000010036487824ULL, 0x000fe200078e00ffULL,
0x00008880340c7816ULL, 0x040fe200000000ffULL, 0x00000100340d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011438ULL, 0x00000018ff657819ULL, 0x000fe4000001140dULL,
0x00008880385d7816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011435ULL,
0x0000000f00787306ULL, 0x0003e20000200c00ULL, 0x00008880350d7816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff637819ULL, 0x000fc40000011437ULL, 0x0000888037497816ULL, 0x040fe200000000ffULL,
0x0000004800517306ULL, 0x0007e20000200c00ULL, 0x00000100370f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011436ULL, 0x00000018ff4b7819ULL, 0x000fe2000001140fULL,
0x00010000360f7824ULL, 0x000fe200078e00ffULL, 0x0000003400707306ULL, 0x000fe20000200c00ULL,
0x0000010038487824ULL, 0x008fe200078e00ffULL, 0x0000888036357816ULL, 0x000fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011439ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000004900347306ULL, 0x0003e20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe4000001143aULL,
0x00000018ff4c7819ULL, 0x000fe4000001143bULL, 0x000088803a587816ULL, 0x000fe400000000ffULL,
0x000088803b577816ULL, 0x000fe200000000ffULL, 0x0000004b00367306ULL, 0x0007e20000200c00ULL,
0x0000888039497816ULL, 0x002fc400000000ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff467819ULL, 0x004fe40000011440ULL, 0x00008880404e7816ULL, 0x000fe200000000ffULL,
0x00000038005c7306ULL, 0x0003e20000200c00ULL, 0x00000100394b7824ULL, 0x048fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011441ULL, 0x00000018ff4b7819ULL, 0x000fc4000001144bULL,
0x0000003700677306ULL, 0x0005e20000200c00ULL, 0x000001003b387824ULL, 0x042fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000888041507816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000039005b7306ULL, 0x000fe20000200c00ULL, 0x000001003a377824ULL, 0x044fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe2000001143bULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fc40000011442ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003800597306ULL, 0x0003e20000200c00ULL, 0x00000018ff647819ULL, 0x000fe4000001143aULL,
0x00000018ff457819ULL, 0x000fe40000011443ULL, 0x00000018ff137819ULL, 0x000fe40000011431ULL,
0x00000018ff0a7819ULL, 0x000fe20000011432ULL, 0x0000000c000c7306ULL, 0x000fe20000200c00ULL,
0x012000000938783bULL, 0x0022a20000000200ULL, 0x00000018ff0b7819ULL, 0x000fc40000011433ULL,
0x00000018ff117819ULL, 0x000fc80000011430ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x0000888042097816ULL, 0x002fce00000000ffULL, 0x0000000d000d7306ULL, 0x000e700000200c00ULL,
0x0000003700567306ULL, 0x0003e20000200c00ULL, 0x000054100c0c7816ULL, 0x008fce0000000065ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000010040377824ULL, 0x042fe200078e00ffULL,
0x000054100d0d7816ULL, 0x000fe20000000078ULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000000738388232ULL, 0x084fe20000000000ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000000073a3a8232ULL, 0x000fe40000000000ULL, 0x0000000839398232ULL, 0x080fe40000000000ULL,
0x000000083b3b8232ULL, 0x000fe20000000000ULL, 0x00000048005e7306ULL, 0x0005ec0000200c00ULL,
0x0000000c3814723cULL, 0x000be40000001814ULL, 0x0000003500357306ULL, 0x000ee20000200c00ULL,
0x0000010041487824ULL, 0x004fc400078e00ffULL, 0x0001000041417824ULL, 0x000fe400078e00ffULL,
0x00005410700c7816ULL, 0x020fe4000000006bULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x00000037004f7306ULL, 0x0005e20000200c00ULL, 0x000054106c0d7816ULL, 0x002fe4000000004dULL,
0x00000018ff417819ULL, 0x000fca0000011441ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000010042377824ULL, 0x044fe200078e00ffULL, 0x0000000c3818723cULL, 0x000be20000001818ULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00005410350c7816ULL, 0x028fe40000000051ULL,
0x00005410340d7816ULL, 0x000fe40000000036ULL, 0x00000018ff427819ULL, 0x000fc60000011442ULL,
0x0000000f00687306ULL, 0x000fe40000200c00ULL, 0x0000000c383c723cULL, 0x000b6c000000183cULL,
0x0000004800527306ULL, 0x000fe20000200c00ULL, 0x00008880310c7816ULL, 0x020fce00000000ffULL,
0x0000004000697306ULL, 0x0003f00000200c00ULL, 0x0000003700487306ULL, 0x0005e20000200c00ULL,
0x0000010043407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000888030377816ULL, 0x004fca00000000ffULL,
0x000000ffff4d7224ULL, 0x000fe400078e0037ULL, 0x00000049000f7306ULL, 0x0003e20000200c00ULL,
0x0000010030377824ULL, 0x000fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011437ULL,
0x0000004b00617306ULL, 0x000ea20000200c00ULL, 0x0000888043497816ULL, 0x042fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x012000000e34783bULL, 0x000e680000000200ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ee20000200c00ULL, 0x000054100f0d7816ULL, 0x004fce0000000061ULL,
0x0000004100667306ULL, 0x0005f00000200c00ULL, 0x00000040004b7306ULL, 0x0007e20000200c00ULL,
0x0000541067417816ULL, 0x004fce0000000063ULL, 0x00000042006a7306ULL, 0x000fe20000200c00ULL,
0x0000541068407816ULL, 0x008fe2000000005aULL, 0x000000ffff5a7224ULL, 0x000fe200078e000cULL,
0x000054105d0c7816ULL, 0x000fe2000000005eULL, 0x0000000734348232ULL, 0x082fe40000000000ULL,
0x0000000736368232ULL, 0x000fe40000000000ULL, 0x0000004300657306ULL, 0x0003e20000200c00ULL,
0x0000000835358232ULL, 0x080fe20000000000ULL, 0x0000000c380c723cULL, 0x000be20000001824ULL,
0x0000000837378232ULL, 0x000fca0000000000ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x0001000030247824ULL, 0x020fe200078e00ffULL, 0x000000403840723cULL, 0x002b6c0000001820ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x0000010031207824ULL, 0x020fe200078e00ffULL,
0x000054105b217816ULL, 0x000fc80000000054ULL, 0x00000018ff5d7819ULL, 0x000fe40000011420ULL,
0x000054105c207816ULL, 0x000fe20000000055ULL, 0x0000004a004a7306ULL, 0x000fec0000200c00ULL,
0x000000203820723cULL, 0x000be20000001828ULL, 0x0000541057257816ULL, 0x002fe20000000059ULL,
0x0000004c004c7306ULL, 0x000fea0000200c00ULL, 0x00000018ff287819ULL, 0x020fe20000011424ULL,
0x0001000031297824ULL, 0x000fe200078e00ffULL, 0x0000541058247816ULL, 0x000fe20000000056ULL,
0x0000006400647306ULL, 0x000fe60000200c00ULL, 0x00000018ff297819ULL, 0x000fc60000011429ULL,
0x000000243824723cULL, 0x000b64000000182cULL, 0x0000005300537306ULL, 0x000fea0000200c00ULL,
0x00008880322d7816ULL, 0x020fc600000000ffULL, 0x0000000900097306ULL, 0x000e700000200c00ULL,
0x0000004900497306ULL, 0x000eb00000200c00ULL, 0x0000002800317306ULL, 0x0007e20000200c00ULL,
0x0000541009487816ULL, 0x002fce0000000048ULL, 0x00000029002c7306ULL, 0x0003e20000200c00ULL,
0x0000541064287816ULL, 0x008fe4000000004aULL, 0x0000541049497816ULL, 0x004fca000000004bULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000541053297816ULL, 0x002fce000000004cULL,
0x000000283838723cULL, 0x000b62000000181cULL, 0x0000005d00307306ULL, 0x000fec0000200c00ULL,
0x00000100321c7824ULL, 0x060fe200078e00ffULL, 0x0000888033287816ULL, 0x040fe200000000ffULL,
0x00000100331d7824ULL, 0x040fe200078e00ffULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fc4000001141dULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000001c002e7306ULL, 0x0003f00000200c00ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x00000048341c723cULL, 0x002b6e000000183cULL, 0x0000004600467306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x000054104e4e7816ULL, 0x004fce000000004fULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x0000541069467816ULL, 0x002fce0000000046ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541066477816ULL, 0x008fce0000000047ULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x000054106a447816ULL, 0x004fe20000000044ULL,
0x000000463418723cULL, 0x000b6c0000001818ULL, 0x0000000a000a7306ULL, 0x000fe20000200c00ULL,
0x0000541065457816ULL, 0x002fce0000000045ULL, 0x0000000b000b7306ULL, 0x000ff00000200c00ULL,
0x0000005000507306ULL, 0x000e700000200c00ULL, 0x0000004d004d7306ULL, 0x000ff00000200c00ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00005410504f7816ULL, 0x002fce0000000052ULL,
0x0000002d002d7306ULL, 0x000e620000200c00ULL, 0x0000004e3414723cULL, 0x040b6e0000001814ULL,
0x00000028004a7306ULL, 0x0005f00000200c00ULL, 0x0000002f002f7306ULL, 0x000ee20000200c00ULL,
0x000054102d2e7816ULL, 0x002fe2000000002eULL, 0x000000443428723cULL, 0x004b6c0000001840ULL,
0x0000003200097306ULL, 0x0002b00000200c00ULL, 0x00000033003c7306ULL, 0x0204a20000200c00ULL,
0x000054104d327816ULL, 0x002fc40000000051ULL, 0x000054104a2f7816ULL, 0x008fe4000000002fULL,
0x00005410090a7816ULL, 0x004fe4000000000aULL, 0x000054105a337816ULL, 0x000fc60000000030ULL,
0x0000002e3424723cULL, 0x000b620000001824ULL, 0x0000541031307816ULL, 0x000fe40000000011ULL,
0x000054102c317816ULL, 0x000fe40000000013ULL, 0x000054103c0b7816ULL, 0x000fc6000000000bULL,
0x00000032340c723cULL, 0x040b70000000180cULL, 0x000000303420723cULL, 0x040b700000001820ULL,
0x0000000a3438723cULL, 0x000b620000001838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000ff0a7f8cULL, 0x020e62000c80040cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01769800ffff7f8cULL, 0x000fe2000c80040bULL,
0x000000ffff117224ULL, 0x000fc400078e00ffULL, 0x000000ffff2e7224ULL, 0x002fc400078e000bULL,
0x00000000000a7805ULL, 0x000fca0000015200ULL, 0x0000040003097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c0a2c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e0bULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001142dULL,
0x0000002c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x0000000209097819ULL, 0x000fc8000000122cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040003097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000300007810ULL, 0x000fca0007ffe0ffULL,
0x0000000c72007c0cULL, 0x000fda000bf03070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x00000002040d7890ULL, 0x000fe2000fffe03fULL, 0x0000590005057a24ULL, 0x010fe200078e02ffULL,
0x000000150c0c7291ULL, 0x000fc6000f8e403fULL, 0x0000004005097824ULL, 0x000fe200078e00ffULL,
0x0000000d72007c0cULL, 0x000fe2000bf03070ULL, 0x000000200c0b7892ULL, 0x000fc8000f8ec03fULL,
0x0000000b160b7290ULL, 0x000fd0000fffe03fULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x00000004120d7899ULL, 0x000fe2000800063fULL, 0x0000000c62007c17ULL, 0x000fe4000f800000ULL,
0x00000003ff057819ULL, 0x000fe20000011602ULL, 0x000000100d0d7892ULL, 0x000fe2000f8ec03fULL,
0x8000000c00007c10ULL, 0x000fe4000fffe0ffULL, 0x00000008052d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000405137810ULL, 0x040fe40007ffe0ffULL, 0x0000000d050b7c10ULL, 0x000fc4000fffe0ffULL,
0x0000000d00007c17ULL, 0x000fe4000f800000ULL, 0x0000000d2d2f7c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b0a7824ULL, 0x040fe200078e0202ULL, 0x8000000d00007c10ULL, 0x000fe2000fffe0ffULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x0000000c05317810ULL, 0x000fe20007ffe0ffULL,
0x000000082f2c7824ULL, 0x000fe200078e00ffULL, 0x000000001300720cULL, 0x000fe40003f66070ULL,
0xfffffff811117812ULL, 0x000fc400078ee20aULL, 0x0000000d13137c10ULL, 0x000fe4000fffe0ffULL,
0x0000000b0b0a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012f0b7824ULL, 0x100fe200078e0202ULL,
0x000000000500720cULL, 0x080fe20003f86070ULL, 0x0000000113057824ULL, 0x000fe200078e0202ULL,
0x000000002d00720cULL, 0x080fe20003f46070ULL, 0x0000000813327824ULL, 0x000fe200078e00ffULL,
0x000000003100720cULL, 0x000fe40003f06070ULL, 0xfffffff82c007812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000b132c7c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff832327812ULL, 0x000fe400078ee205ULL, 0x0000000d31137c10ULL, 0x000fe2000fffe0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000640009057a11ULL, 0x000fe400078a38ffULL,
0x0000006e0a0a7212ULL, 0x000fe200078efcffULL, 0x0000000113337824ULL, 0x000fe200078e0202ULL,
0x0000000b2f2e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000813347824ULL, 0x040fe200078e00ffULL,
0x0000000b13307c10ULL, 0x000fc4000fffe0ffULL, 0x0000650009097a11ULL, 0x000fe200028f3cffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000a050a7210ULL, 0x000fe40007fbe0ffULL,
0x0000006e2c2c7212ULL, 0x080fe200078efcffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000006e2e2e7212ULL, 0x000fe400078efcffULL, 0xfffffff834337812ULL, 0x000fe200078ee233ULL,
0x000000010b0b7824ULL, 0x000fe200028e0609ULL, 0x000000052c2c7210ULL, 0x000fc40007fbe0ffULL,
0x0000006e30307212ULL, 0x000fe400078efcffULL, 0x0000001011117c11ULL, 0x000fe2000f8e20ffULL,
0x000000012d2d7824ULL, 0x100fe200028e0609ULL, 0x000000052e2e7210ULL, 0x080fe40007fbe0ffULL,
0x0000000530307210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000e101c4eULL, 0x0000001032057c11ULL, 0x000fe2000f8e20ffULL,
0x000000012f2f7824ULL, 0x100fe200028e0609ULL, 0x0000001033337c11ULL, 0x000fe2000f8e20ffULL,
0x0000000131317824ULL, 0x000fe200030e0609ULL, 0x0000001000097c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c057faeULL, 0x0003e8000d901c4eULL, 0x000000002e097faeULL, 0x0003e8000d101c4eULL,
0x0000000030337faeULL, 0x0003e2000c101c4eULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000004120c7899ULL, 0x000fc8000800063fULL, 0x000000100c0c7892ULL, 0x000fcc000f8ec03fULL,
0x0000000c02057c11ULL, 0x000fc8000f8fe8ffULL, 0x0000000805137810ULL, 0x040fe20007ffe0ffULL,
0x0000000105007824ULL, 0x140fe200078e0202ULL, 0x00000004050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000805117824ULL, 0x040fe200078e00ffULL, 0x0000000c052d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001132c7824ULL, 0x000fe200078e0202ULL, 0x0000000b050a7c10ULL, 0x000fe2000fffe0ffULL,
0x00000008132f7824ULL, 0x000fe200078e00ffULL, 0xfffffff811007812ULL, 0x000fe200078ee200ULL,
0x000000010b117824ULL, 0x000fe200078e0202ULL, 0x0000640009057a11ULL, 0x000fe200078038ffULL,
0x000000080b307824ULL, 0x000fe200078e00ffULL, 0xfffffff82f327812ULL, 0x000fe200078ee22cULL,
0x000000012d2e7824ULL, 0x000fe200078e0202ULL, 0x0000000b0b2c7c10ULL, 0x000fe2000fffe0ffULL,
0x000000082d337824ULL, 0x040fe200078e00ffULL, 0xfffffff830117812ULL, 0x000fe200078ee211ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000b2d307c10ULL, 0x000fc4000fffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee22eULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000b132e7c10ULL, 0x000fe4000fffe0ffULL, 0x0000006e0a0a7212ULL, 0x000fe200078efcffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000650009097a11ULL, 0x000fe400000f3cffULL,
0x0000000a050a7210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006e2c2c7212ULL, 0x000fc400078efcffULL, 0x0000006e30307212ULL, 0x080fe200078efcffULL,
0x000000010b0b7824ULL, 0x100fe200000e0609ULL, 0x0000006e2e2e7212ULL, 0x000fe400078efcffULL,
0x0000002c052c7210ULL, 0x040fe40007f5e0ffULL, 0x0000002e052e7210ULL, 0x040fe40007f1e0ffULL,
0x0000003005307210ULL, 0x000fe20007f7e0ffULL, 0x000000012d2d7824ULL, 0x100fe200010e0609ULL,
0x0000001000057c11ULL, 0x000fe2000f8e20ffULL, 0x000000012f2f7824ULL, 0x100fe200000e0609ULL,
0x0000001011117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000131317824ULL, 0x000fe200018e0609ULL,
0x0000001032097c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e2000b901c4eULL, 0x0000001033337c11ULL, 0x000fc6000f8e20ffULL,
0x000000002c117faeULL, 0x0003e8000b901c4eULL, 0x000000002e097faeULL, 0x0003e8000b901c4eULL,
0x0000000030337faeULL, 0x0003e4000b901c4eULL, 0x0000000475007810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff057424ULL, 0x002fc400078e00ffULL,
0x0000000800007c0cULL, 0x000fda000bf06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000006000a7c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff0b7424ULL, 0x000fc800078e00ffULL,
0x000066000a0a7625ULL, 0x000fca00078e000bULL, 0x0000000e0a057981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000003120b7899ULL, 0x000fc8000800063fULL,
0xfffffff00b0b7892ULL, 0x000fc8000f8ec03fULL, 0x000176a80b0c7890ULL, 0x000fca000fffe03fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a0cULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800ff0a7f8cULL, 0x002e62000c80040bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01766800ff2c7f8cULL, 0x000ea2000c80040aULL, 0x000000ffff097224ULL, 0x002fe400078e000bULL,
0x000000ffff2e7224ULL, 0x004fc400078e002dULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x01766c0aff117984ULL, 0x000e640008000800ULL, 0x8000000011ff7812ULL, 0x002fc4000780482eULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c0a2c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e0bULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc8000001142dULL,
0x0000002c11117211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x0000000211117819ULL, 0x000fc8000000122cULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c0aff117984ULL, 0x000e640008000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780482eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180110b7891ULL, 0x000fcc000f8e383fULL, 0x0000000b760a7c10ULL, 0x000fca000fffe06eULL,
0x017000000a0b7984ULL, 0x000e680000000800ULL, 0x017200000a117984ULL, 0x0004e20000000800ULL,
0x000000040b00720bULL, 0x002fe20003f1d000ULL, 0x0000acc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff132d7812ULL, 0x000fe2000780c0ffULL,
0x000004c000007945ULL, 0x000fe20003800000ULL, 0x00000001ff137424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fd200078e0004ULL, 0x0000048000008947ULL, 0x000fea0003800000ULL,
0x00000003110b7890ULL, 0x000fe2000fffe03fULL, 0x00000012ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0x000000040b00720bULL, 0x000fc80003f54000ULL, 0x0000000b2f007c0cULL, 0x000fe2000bf05270ULL,
0x0000ac627f007947ULL, 0x000fd0000b800000ULL, 0x00000000000a7806ULL, 0x000fc800010e0100ULL,
0x000000802f2f8824ULL, 0x000fe200078e026eULL, 0x000000040b138209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100a2c7816ULL, 0x000fe200000000ffULL,
0x0000000176768824ULL, 0x000fca00078e022fULL, 0x0174001376008388ULL, 0x0003e20000000800ULL,
0x000000ff2c00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000040b137209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL, 0x0000000413137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x00000013002f7308ULL, 0x000e640000000800ULL,
0x0000002f10107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011602ULL, 0x0000ab927f007947ULL, 0x000fea000b800000ULL,
0x00001f132f137589ULL, 0x0002a400000e0000ULL, 0x0000001314147220ULL, 0x084fe40000410000ULL,
0x0000001315157220ULL, 0x080fe40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x000fc40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x080fe40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x000000130c0c7220ULL, 0x080fe40000410000ULL,
0x000000130d0d7220ULL, 0x000fc40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x080fe40000410000ULL, 0x0000001338387220ULL, 0x080fe40000410000ULL,
0x0000001339397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802137811ULL, 0x000fe200078ff0ffULL, 0x0000aa927f007947ULL, 0x000fea000b800000ULL,
0x00001f132f137589ULL, 0x00046400000e0000ULL, 0x0000001316167220ULL, 0x086fe40000410000ULL,
0x0000001317177220ULL, 0x080fe40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x000fc40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x080fe40000410000ULL, 0x000000130e0e7220ULL, 0x080fe40000410000ULL,
0x000000130f0f7220ULL, 0x080fe40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x000fc40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x000000133a3a7220ULL, 0x080fe40000410000ULL,
0x000000133b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2dff7812ULL, 0x000fe2000780600aULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x000000040b0a7209ULL, 0x000fd60007810000ULL, 0x8000000a0b0b0221ULL, 0x000fe20000010000ULL,
0x00007610ff130816ULL, 0x000fc60000000013ULL, 0x3fb8aa3b0b0b0820ULL, 0x000fc80000410000ULL,
0x0000000b00060308ULL, 0x000e640000000800ULL, 0x0000000611110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011107221ULL, 0x008fc40000010000ULL,
0x00000000002c7805ULL, 0x000fca0000015200ULL, 0x00000003120b7899ULL, 0x000fcc000800063fULL,
0x0000000bff117e24ULL, 0x000fca000f8e00ffULL, 0xfffffff011117812ULL, 0x000fca00078ec0ffULL,
0x0176b400110b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804812ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c0b7210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2e7824ULL, 0x000fe200000e0e2dULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001142eULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e062eULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b400110b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991013047816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000006ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011602ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x0000a6527f007947ULL, 0x000fea000b800000ULL,
0x00001f0b04077589ULL, 0x0002a400000e0000ULL, 0x000000080b137810ULL, 0x000fe20007ffe0ffULL,
0x0000a6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1304087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100b137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0004ULL, 0x0000aa7000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000ac3000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180b137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0004ULL,
0x0000aae000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000abc000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000011ff0b7e24ULL, 0x002fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x000008000b347824ULL, 0x040fe200078e0274ULL,
0x000000030b307810ULL, 0x000fc40007ffe0ffULL, 0x00000000602c783bULL, 0x000e620000004200ULL,
0x00000002120b7899ULL, 0x000fe2000800063fULL, 0x0000000273737810ULL, 0x000fe40007ffe0ffULL,
0x000000005f5c783bULL, 0x000ee20000004200ULL, 0x000000040b0b7892ULL, 0x000fc6000f8ec03fULL,
0x012800003434783bULL, 0x000ea20000000200ULL, 0x000000020b0b7892ULL, 0x000fe2000f8efc3fULL,
0x000001002c047824ULL, 0x00afe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe2000001142dULL,
0x000001002d0b7824ULL, 0x040fe200078e00ffULL, 0x000088802d497816ULL, 0x040fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x000100005c117824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000000734348232ULL, 0x084fe20000000000ULL, 0x00000018ff687819ULL, 0x000fe2000001142cULL,
0x0000000736368232ULL, 0x000fe20000000000ULL, 0x000088802c6c7816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001142eULL,
0x00000004006d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe2000001142fULL,
0x0000000835358232ULL, 0x080fe20000000000ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000000837378232ULL, 0x000fe20000000000ULL, 0x000088802e667816ULL, 0x000fc400000000ffULL,
0x000088802f4c7816ULL, 0x000fe200000000ffULL, 0x0000000b006e7306ULL, 0x0005e20000200c00ULL,
0x000001002e047824ULL, 0x002fe200078e00ffULL, 0x000088805c637816ULL, 0x000fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x000088805d607816ULL, 0x000fe400000000ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000002d006a7306ULL, 0x000fe20000200c00ULL,
0x000001002f0b7824ULL, 0x044fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc4000001145dULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000000400677306ULL, 0x0003e20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000018ff577819ULL, 0x000fe4000001145cULL,
0x00000018ff407819ULL, 0x000fe4000001145fULL, 0x000088805f547816ULL, 0x000fe200000000ffULL,
0x0000000b00697306ULL, 0x0005e20000200c00ULL, 0x000001005c047824ULL, 0x002fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x000088805e527816ULL, 0x000fe400000000ffULL,
0x00000018ff617819ULL, 0x000fe40000011404ULL, 0x0000000b02047c11ULL, 0x040fe2000f8fe0ffULL,
0x0000002c006b7306ULL, 0x0003e20000200c00ULL, 0x00000008020b7812ULL, 0x004fe200078ec0ffULL,
0x000176a0110b7891ULL, 0x000fe2000f8e183fULL, 0x00000018ff137819ULL, 0x000fe4000001145eULL,
0x000000070b2d7812ULL, 0x000fe200078ef802ULL, 0x000001005d0b7824ULL, 0x000fc400078e00ffULL,
0x0000002e00647306ULL, 0x000fe20000200c00ULL, 0x000100005d5d7824ULL, 0x000fe400078e00ffULL,
0x00000018ff127819ULL, 0x000fe2000001140bULL, 0x000000082d2c7824ULL, 0x042fe400078e00ffULL,
0x000000012d0b7824ULL, 0x140fe200078e0204ULL, 0x000000102d2d7812ULL, 0x000fe200078efcffULL,
0x0000002f00657306ULL, 0x0003e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe4000001145dULL,
0xfffffff82c0b7812ULL, 0x000fe200078ee20bULL, 0x000000012d047824ULL, 0x000fc400078e0204ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x000000170b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000006c006c7306ULL, 0x000fe60000200c00ULL, 0xfffffff82d047812ULL, 0x000fe200078ee204ULL,
0x000000000b3c783bULL, 0x0004e60000004200ULL, 0x0000001704047c11ULL, 0x000fe2000f8e20ffULL,
0x0000004900497306ULL, 0x000ee80000200c00ULL, 0x00000000042c783bULL, 0x002e620000004200ULL,
0x000001005f0b7824ULL, 0x004fc400078e00ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x0000006800687306ULL, 0x000ea40000200c00ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000018ff5d7819ULL, 0x000fc8000001145fULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000004c004c7306ULL, 0x000e700000200c00ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000001003c317824ULL, 0x008fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001143dULL,
0x000001003d327824ULL, 0x040fe200078e00ffULL, 0x000088803d507816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x00000018ff337819ULL, 0x000fe20000011432ULL,
0x000100003c327824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe4000001143eULL,
0x000088803e457816ULL, 0x000fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x00000031004f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe4000001143cULL,
0x000088803c517816ULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff427819ULL, 0x000fe2000001143fULL, 0x00000033003c7306ULL, 0x000fe20000200c00ULL,
0x0000000702317812ULL, 0x002fe400078ec0ffULL, 0x000088803f477816ULL, 0x000fe400000000ffULL,
0x0000000831317812ULL, 0x000fe400078ef802ULL, 0x000088802c5f7816ULL, 0x000fe200000000ffULL,
0x00000032004d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff047819ULL, 0x000fe2000001142eULL,
0x0000000831447824ULL, 0x000fc400078e00ffULL, 0x000001003e317824ULL, 0x040fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff844737812ULL, 0x000fe200078ee273ULL,
0x0000003d004e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x000fe40000011431ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000008030307824ULL, 0x000fc800078e0273ULL,
0x0000003e00447306ULL, 0x0005e20000200c00ULL, 0x0001100030317811ULL, 0x000fe200078e20ffULL,
0x000001003f307824ULL, 0x040fe400078e00ffULL, 0x000100003f3d7824ULL, 0x002fe200078e00ffULL,
0x00005410493f7816ULL, 0x000fe4000000006eULL, 0x00000018ff487819ULL, 0x000fe20000011430ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000003130783bULL, 0x000e620000000200ULL,
0x000054106c3e7816ULL, 0x004fc4000000006dULL, 0x00000018ff3d7819ULL, 0x000fc8000001143dULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x0000003e3414723cULL, 0x000b6e0000001814ULL,
0x000054106b3e7816ULL, 0x020fe20000000068ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054106a3f7816ULL, 0x000fe20000000043ULL, 0x000000ffff437224ULL, 0x000fc400078e005fULL,
0x000001002c5f7824ULL, 0x000fc800078e00ffULL, 0x0000003e3418723cULL, 0x000be20000001818ULL,
0x00000012005c7306ULL, 0x00046c0000200c00ULL, 0x00005410663e7816ULL, 0x020fe40000000067ULL,
0x000054104c3f7816ULL, 0x000fe20000000069ULL, 0x000001005e127824ULL, 0x044fe200078e00ffULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001145fULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000003e341c723cULL, 0x000b62000000181cULL, 0x0000000730308232ULL, 0x082fe20000000000ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000000732328232ULL, 0x000fe40000000000ULL, 0x0000000831318232ULL, 0x080fe20000000000ULL,
0x00005410643e7816ULL, 0x020fe2000000005bULL, 0x0000000833338232ULL, 0x000fe20000000000ULL,
0x00005410653f7816ULL, 0x008fc4000000005aULL, 0x0000001100597306ULL, 0x0003ea0000200c00ULL,
0x0000003e3428723cULL, 0x000b660000001828ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x002fe2000001142cULL, 0x000100002c2c7824ULL, 0x000fc400078e00ffULL,
0x00005410633e7816ULL, 0x020fe40000000061ULL, 0x00005410603f7816ULL, 0x000fe4000000005cULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fc8000001142cULL,
0x0000003e3014723cULL, 0x000be60000001814ULL, 0x0000001200537306ULL, 0x0002a80000200c00ULL,
0x000100002d3e7824ULL, 0x020fc800078e00ffULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x002fce000001142dULL, 0x0000000b00557306ULL, 0x0002e20000200c00ULL,
0x0000541052527816ULL, 0x004fce0000000053ULL, 0x0000003d00497306ULL, 0x0005e20000200c00ULL,
0x00000018ff0b7819ULL, 0x002fce000001142fULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000088802d3d7816ULL, 0x004fe400000000ffULL, 0x0000541054537816ULL, 0x008fc60000000055ULL,
0x000000ffff5a7224ULL, 0x000fe400078e003dULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000001002d3d7824ULL, 0x000fe200078e00ffULL, 0x00005410582d7816ULL, 0x000fe20000000056ULL,
0x00000052301c723cULL, 0x000be6000000181cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004a004a7306ULL, 0x000ea40000200c00ULL, 0x000001002e537824ULL, 0x020fcc00078e00ffULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x00005410503f7816ULL, 0x002fce000000003cULL,
0x0000002c005c7306ULL, 0x0003e20000200c00ULL, 0x000054104d4a7816ULL, 0x004fce000000004aULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410592c7816ULL, 0x002fe40000000057ULL,
0x000054104e4b7816ULL, 0x008fca000000004bULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000002c3018723cULL, 0x000bee0000001818ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff2d7819ULL, 0x020fe2000001143eULL, 0x0000004a3420723cULL, 0x000b620000001820ULL,
0x00005410513e7816ULL, 0x000fc4000000004fULL, 0x00000018ff4f7819ULL, 0x000fc60000011453ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000001002f4b7824ULL, 0x020fca00078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000003d005b7306ULL, 0x0005f00000200c00ULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x000088802e3d7816ULL, 0x044fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff527224ULL, 0x000fe200078e003dULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000004200427306ULL, 0x000ea20000200c00ULL,
0x0000003e343c723cULL, 0x000b6e000000180cULL, 0x000088802f0c7816ULL, 0x020fe200000000ffULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x00005410470d7816ULL, 0x002fe20000000048ULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x0000541044447816ULL, 0x008fe20000000041ULL,
0x000000ffff4a7224ULL, 0x000fe200078e000cULL, 0x00005410450c7816ULL, 0x000fc40000000046ULL,
0x0000541049457816ULL, 0x004fe20000000042ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fc6000001142fULL, 0x0000000c340c723cULL, 0x040f680000001824ULL,
0x0000005e005e7306ULL, 0x000e680000200c00ULL, 0x000000443434723cULL, 0x000b680000001838ULL,
0x0000005d005d7306ULL, 0x000eb00000200c00ULL, 0x0000001200127306ULL, 0x000fe20000200c00ULL,
0x000054105e387816ULL, 0x022fce0000000013ULL, 0x0000002d002d7306ULL, 0x000e620000200c00ULL,
0x000054105d397816ULL, 0x004fce0000000040ULL, 0x00000052002c7306ULL, 0x000fe20000200c00ULL,
0x000000383038723cULL, 0x000b6e0000001828ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000054102d297816ULL, 0x022fce0000000012ULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000004fULL,
0x0000001100117306ULL, 0x000eb00000200c00ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x000054104a2d7816ULL, 0x002fce000000004bULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000054105c287816ULL, 0x004fce0000000011ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000000283028723cULL, 0x000f6e0000001820ULL, 0x0000000400047306ULL, 0x000fe20000200c00ULL,
0x0000541043247816ULL, 0x002fce000000004cULL, 0x0000000b000b7306ULL, 0x000fe20000200c00ULL,
0x000054105a257816ULL, 0x004fce000000005bULL, 0x0000002e00417306ULL, 0x0002a20000200c00ULL,
0x000000243024723cULL, 0x040f6e000000183cULL, 0x0000004200427306ULL, 0x000ee20000200c00ULL,
0x0000002c302c723cULL, 0x002b6e000000180cULL, 0x00005410410c7816ULL, 0x024fc40000000004ULL,
0x00005410420d7816ULL, 0x008fce000000000bULL, 0x0000000c3030723cULL, 0x000b620000001834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd40000008000ULL, 0x00000000030c7f8cULL, 0x0202a2000c80043fULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff60000008000ULL,
0x00000000ffff7f8cULL, 0x000fe2000c80040bULL, 0x000000ffff047224ULL, 0x004fe200078e000dULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff5fb000007947ULL, 0x000fea000383ffffULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x000000ffff0b7224ULL, 0x000fd800078e0016ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000010007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000bc6000047802ULL, 0x000fc40000000f00ULL, 0x0000988000007944ULL, 0x012fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001000037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000010ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000e02037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x018fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000001400147220ULL, 0x042fe40000410000ULL, 0x0000001500157220ULL, 0x040fe40000410000ULL,
0x0000001800187220ULL, 0x040fe40000410000ULL, 0x0000001900197220ULL, 0x000fc40000410000ULL,
0x0000001c001c7220ULL, 0x040fe40000410000ULL, 0x0000001d001d7220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x040fe40000410000ULL, 0x0000003900397220ULL, 0x040fe40000410000ULL,
0x0000002400247220ULL, 0x040fe40000410000ULL, 0x0000002500257220ULL, 0x000fc40000410000ULL,
0x0000002800287220ULL, 0x040fe40000410000ULL, 0x0000002900297220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x000fc40000410000ULL,
0x0000000b040b7220ULL, 0x044fe40000410000ULL, 0x0000001704177220ULL, 0x040fe40000410000ULL,
0x0000001a041a7220ULL, 0x040fe40000410000ULL, 0x0000001b041b7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x000fc40000410000ULL,
0x0000003a043a7220ULL, 0x040fe40000410000ULL, 0x0000003b043b7220ULL, 0x040fe40000410000ULL,
0x0000002604267220ULL, 0x040fe40000410000ULL, 0x0000002704277220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002b042b7220ULL, 0x000fc40000410000ULL,
0x0000002e042e7220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000003204327220ULL, 0x040fe40000410000ULL, 0x0000003304337220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000c12047899ULL, 0x000fe2000800063fULL,
0x0000002c2d2c723eULL, 0x000fe400000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000100004047892ULL, 0x000fe2000f8ee23fULL, 0x000000303116723eULL, 0x000fc400000000ffULL,
0x0000003a3b3b723eULL, 0x000fe200000000ffULL, 0x0000000414067291ULL, 0x000fe2000f8e583fULL,
0x000000262726723eULL, 0x000fe400000000ffULL, 0x0000002a2b13723eULL, 0x000fe400000000ffULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x00000014ff007c0cULL, 0x000fe4000bf05270ULL,
0x00000002ff077819ULL, 0x006fc40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800057811ULL, 0x010fe200078ff0ffULL, 0x00000008070a7824ULL, 0x040fe200078e00ffULL,
0x0000000702037211ULL, 0x040fe200078ff8ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000000502047211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807057824ULL, 0x000fc600078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee204ULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff805067812ULL, 0x000fe200078ee202ULL, 0x0000000807027824ULL, 0x000fe200078e00ffULL,
0x0000000403057810ULL, 0x040fe40007ffe0ffULL, 0x0000000606067c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff802027812ULL, 0x000fe400078ee203ULL, 0x0000000603037810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80a077812ULL, 0x000fe400078ee205ULL, 0x0000000804057812ULL, 0x000fe400078ec0ffULL,
0x0000000602047c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff80c097812ULL, 0x000fe200078ee203ULL,
0x0000000105067824ULL, 0x000fe200078e0206ULL, 0x000000141502723eULL, 0x000fe200000000ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000181903723eULL, 0x000fc400000000ffULL,
0x00000006080c7c11ULL, 0x000fe4000f8e20ffULL, 0x00005410020e7816ULL, 0x140fe40000000003ULL,
0x00007632020f7816ULL, 0x000fe20000000003ULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x0000001c1d02723eULL, 0x000fe400000000ffULL, 0x000000383903723eULL, 0x000fe200000000ffULL,
0x0000000e04007388ULL, 0x0003e20000000a00ULL, 0x0000000607087c11ULL, 0x000fc4000f8e20ffULL,
0x00000006090a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000541026187816ULL, 0x140fe20000000013ULL,
0x0000000105087824ULL, 0x040fe200078e0208ULL, 0x0000763226197816ULL, 0x000fe20000000013ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x000000282905723eULL, 0x000fe400000000ffULL,
0x00005410020e7816ULL, 0x142fe40000000003ULL, 0x00007632020f7816ULL, 0x000fc40000000003ULL,
0x000000242504723eULL, 0x000fe400000000ffULL, 0x0000000b1702723eULL, 0x000fe200000000ffULL,
0x0000000e06007388ULL, 0x0003e20000000a00ULL, 0x0000001a1b03723eULL, 0x000fe400000000ffULL,
0x000000323317723eULL, 0x000fc800000000ffULL, 0x000054102e1a7816ULL, 0x140fe40000000017ULL,
0x000076322e1b7816ULL, 0x000fe40000000017ULL, 0x00005410040e7816ULL, 0x142fe40000000005ULL,
0x00007632040f7816ULL, 0x000fe40000000005ULL, 0x0000001e1f04723eULL, 0x000fc600000000ffULL,
0x0000000e08007388ULL, 0x0003e20000000a00ULL, 0x00005410043a7816ULL, 0x140fe4000000003bULL,
0x00007632043b7816ULL, 0x000fe4000000003bULL, 0x000054102c0e7816ULL, 0x142fe40000000016ULL,
0x000076322c0f7816ULL, 0x000fca0000000016ULL, 0x0000000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410020e7816ULL, 0x142fe40000000003ULL, 0x00007632020f7816ULL, 0x000fe40000000003ULL,
0x0000001500027c10ULL, 0x000fc6000fffe0ffULL, 0x0000000e0c007388ULL, 0x000fe80000000a00ULL,
0x0004003a06007388ULL, 0x000fe80000000a00ULL, 0x0004001808007388ULL, 0x000fe80000000a00ULL,
0x0004001a0a007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000004020c7984ULL, 0x000e68000800cc00ULL, 0x0004000402047984ULL, 0x000ea8000800cc00ULL,
0x0008000402107984ULL, 0x000ee8000800cc00ULL, 0x000c000402147984ULL, 0x000ee2000800cc00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff07077230ULL, 0x004fe40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fc40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001707077230ULL, 0x000fc40000000000ULL, 0x0000001606067230ULL, 0x000fe20000000000ULL,
0x0000000c02007988ULL, 0x000fe2000800cc04ULL, 0x0000001505057230ULL, 0x000fe40000000000ULL,
0x0000001404047230ULL, 0x000fca0000000000ULL, 0x0004000402007988ULL, 0x000fe8000800cc04ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011600ULL, 0x0000000905007c0cULL, 0x000fda000bf06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000047b06ULL, 0x000e620000209000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x00005a00ff107a12ULL, 0x000fe200078e33ffULL,
0x0000000112067892ULL, 0x000fcc000f8ec03fULL, 0x00000006ff117e24ULL, 0x000fe2000f8e00ffULL,
0x0000000400047308ULL, 0x002e640000001000ULL, 0x0ffffffe04067810ULL, 0x002fcc0007ffe0ffULL,
0x0000000600037305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007030d7227ULL, 0x000fe200078e0002ULL,
0x0000000505027c10ULL, 0x000fca000fffe0ffULL, 0x000000020d087227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a08ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000108080810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe20003f26070ULL,
0x0000000105037824ULL, 0x000fe200078e0200ULL, 0x00005a00ff007a0cULL, 0x000fc80003f05070ULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803047812ULL, 0x000fe200078ef800ULL,
0x00000007ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000108081810ULL, 0x000fc60007ffe0ffULL,
0x0000000404047984ULL, 0x000e62000800cc00ULL, 0x0000000810087207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a08ULL, 0x0000590008037a24ULL, 0x000fe400078e0203ULL,
0x00005a0009027a24ULL, 0x000fe200078e0202ULL, 0x0000000700097812ULL, 0x000fc600078ec0ffULL,
0x00005a0003027a24ULL, 0x000fe400078e0202ULL, 0x0000000811097824ULL, 0x000fc600078e0209ULL,
0x0000001302037c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4408ULL,
0x0000002000087810ULL, 0x000fc60007ffe0ffULL, 0x0000001009027825ULL, 0x000fe200078e0002ULL,
0x00000003ff0b7819ULL, 0x000fc80000011608ULL, 0x000000090b007c0cULL, 0x000fe2000bf26070ULL,
0x0000000402007986ULL, 0x0023d8000c101d0eULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000050b027c10ULL, 0x002fe2000fffe0ffULL, 0x00000001080b7824ULL, 0x000fe400078e020bULL,
0x00000007ff0a7e24ULL, 0x000fe4000f8e00ffULL, 0x000000020d037227ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200078e0a03ULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef808ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x00005a0005047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x000000040b047984ULL, 0x0002b6000800cc00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000310037207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e020aULL,
0x00005a0009027a24ULL, 0x000fe400078e0202ULL, 0x0000000811097824ULL, 0x000fe400078e0208ULL,
0x00005a0003027a24ULL, 0x000fca00078e0202ULL, 0x0000001302037c10ULL, 0x000fca000ff3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f440aULL, 0x00000040000a7810ULL, 0x000fc60007ffe0ffULL,
0x0000001009027825ULL, 0x000fe200078e0002ULL, 0x00000003ff0b7819ULL, 0x002fc8000001160aULL,
0x000000090b007c0cULL, 0x000fe2000bf26070ULL, 0x0000000402007986ULL, 0x0043d8000c101d0eULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000050b027c10ULL, 0x002fe2000fffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e020bULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x00000007ff087e24ULL, 0x000fe4000f8e00ffULL, 0x000000020d037227ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200078e0a03ULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef80aULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x00005a0005047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x000000040b047984ULL, 0x0002a4000800cc00ULL,
0x00000003ff0b7819ULL, 0x002fd20000011600ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000310037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0208ULL, 0x00005a0009027a24ULL, 0x000fe400078e0202ULL,
0x0000000811097824ULL, 0x000fe400078e020aULL, 0x00005a0003027a24ULL, 0x000fca00078e0202ULL,
0x0000001302037c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4408ULL,
0x000000090b007c0cULL, 0x040fe4000bf26070ULL, 0x000000050b087c10ULL, 0x000fe2000fffe0ffULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0043ea000c101d0eULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000080d027227ULL, 0x002fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x00000001000b7824ULL, 0x000fe400078e020bULL,
0x00005a0003037a24ULL, 0x000fc600078e0208ULL, 0x000000070b0b7812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0xfffffff80b0b7812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x000000040b0c7984ULL, 0x000e6c000800cc00ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe20003f46070ULL, 0x00000007ff037e24ULL, 0x000fd8000f8e00ffULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x0000000210027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e0203ULL,
0x00005a0005087a24ULL, 0x000fe400078e0208ULL, 0x0000000811057824ULL, 0x000fe400078e0200ULL,
0x00005a0003087a24ULL, 0x000fca00078e0208ULL, 0x0000001308087c10ULL, 0x000fca000ff1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0008027a11ULL, 0x000fc800078040ffULL,
0x00005f0008037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000081200728cULL, 0x000fe2000bf06070ULL,
0xffffffffff0b7424ULL, 0x000fe200078e00ffULL, 0x00006a00000c7ab9ULL, 0x000fe20000000800ULL,
0x00006e00ff067624ULL, 0x000fe200078e00ffULL, 0x01760000ff047f8cULL, 0x002e64000c80043fULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000106098899ULL, 0x000fc8000800063fULL,
0x0000000c090982a4ULL, 0x000fc6000f8e0212ULL, 0x00006600000c7ab9ULL, 0x000fe40000000a00ULL,
0x00000004090c82a5ULL, 0x000fe2000f8e000cULL, 0x00006f00ff077624ULL, 0x000fca00078e00ffULL,
0x0000000cff087e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e06037981ULL, 0x000522000c1e9900ULL,
0x0000000dff097e24ULL, 0x000fca000f8e00ffULL, 0x0000000e080b8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000000611117899ULL, 0x000fe4000800063fULL,
0x00000006120c7899ULL, 0x000fe4000800063fULL, 0x00000006070d7899ULL, 0x000fe4000800063fULL,
0x000000110b277c24ULL, 0x008fcc000f8e02ffULL, 0x00000ca000000947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x106fe20000011602ULL, 0x00000007ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c62147c17ULL, 0x000fe2000f800000ULL, 0x0000100012077891ULL, 0x000fe2000f8e703fULL,
0x0000000415077810ULL, 0x040fe40007ffe0ffULL, 0x8000000c14147c10ULL, 0x000fe4000fffe0ffULL,
0x0000000815097810ULL, 0x000fe20007ffe0ffULL, 0x0000000107047824ULL, 0x140fe200078e0202ULL,
0x000000140700720cULL, 0x0c0fe20003f86070ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x000000140900720cULL, 0x040fe20003f06070ULL, 0x0000000109067824ULL, 0x000fe200078e0202ULL,
0x0000640027087a11ULL, 0x000fe200078238ffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0xfffffff807207812ULL, 0x000fe200078ee204ULL, 0x000000400a097824ULL, 0x000fe200078e0215ULL,
0x0000000c150f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80b227812ULL, 0x000fe200078ee206ULL,
0x0000008009067825ULL, 0x040fe200078e00ffULL, 0x00000004090a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008090c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0202ULL,
0x00000070061d7812ULL, 0x000fe200078ef800ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000650027047a11ULL, 0x000fe400008f3cffULL, 0x0000001d081c7210ULL, 0x000fe20007f5e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000c09067810ULL, 0x000fc40007ffe0ffULL,
0x000000140f00720cULL, 0x040fe20003f26070ULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0x000000700a1f7812ULL, 0x000fe200078ef800ULL, 0x00000001071d7824ULL, 0x000fe200010e0604ULL,
0x000000700c0f7812ULL, 0x000fe200078ef800ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffff811247812ULL, 0x000fe400078ee20eULL, 0x000000081f1e7210ULL, 0x000fe40007f7e0ffULL,
0x00000014090e7810ULL, 0x000fc40007ffe0ffULL, 0x000000080f0a7210ULL, 0x080fe20007fbe0ffULL,
0x000000010b1f7824ULL, 0x000fe200018e0604ULL, 0x0000007006177812ULL, 0x000fe200078ef800ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001809187810ULL, 0x040fe40007ffe0ffULL,
0x0000001c091a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0b7824ULL, 0x000fe200028e0604ULL,
0x00000010090c7810ULL, 0x000fe20007ffe0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000817167210ULL, 0x000fc40007f5e0ffULL, 0x000000700e137812ULL, 0x100fe200078ef800ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018117812ULL, 0x000fe400078ef800ULL,
0x0000000813107210ULL, 0x080fe20007f7e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00000008110e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002009067810ULL, 0x000fe20007ffe0ffULL,
0x0000000107177824ULL, 0x000fe200010e0604ULL, 0x000000701a077812ULL, 0x000fe200078ef800ULL,
0x000000010f117824ULL, 0x000fe200018e0604ULL, 0x000000700c217812ULL, 0x000fe200078ef800ULL,
0x00000001190f7824ULL, 0x000fe200028e0604ULL, 0x00000008070c7210ULL, 0x080fe20007fde0ffULL,
0x0000000115077824ULL, 0x000fe200078e0202ULL, 0x0000000821127210ULL, 0x000fc40007f5e0ffULL,
0x0000001015197810ULL, 0x000fe40007ffe0ffULL, 0x0000000707217812ULL, 0x000fe200078ec0ffULL,
0x000000010d137824ULL, 0x100fe200010e0604ULL, 0x000000141900720cULL, 0x080fe20003f46070ULL,
0x000000011b0d7824ULL, 0x000fe200030e0604ULL, 0x00000014151b7810ULL, 0x040fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000141500720cULL, 0x080fe40003fa6070ULL,
0x000000141b00720cULL, 0x000fe20003f66070ULL, 0x00000001191a7824ULL, 0x100fe200078e0202ULL,
0x0ffffff821217812ULL, 0x000fe200078ef802ULL, 0x0000000819257824ULL, 0x000fe200078e00ffULL,
0x0000007006197812ULL, 0x000fe200078ef800ULL, 0x000000011b067824ULL, 0x000fe200078e0202ULL,
0x0000000721217c11ULL, 0x000fe2000f8e20ffULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000819187210ULL, 0x000fc40007fde0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000e901c4eULL,
0xfffffff81b267812ULL, 0x000fe200078ee206ULL, 0x0000000107197824ULL, 0x000fe200030e0604ULL,
0x0000002409067810ULL, 0x040fe40007ffe0ffULL, 0x00000028091a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000720237c11ULL, 0x000fe2000f8e20ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000001c15297810ULL, 0x000fc40007ffe0ffULL, 0x0000001815277810ULL, 0x000fe20007ffe0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x00000070062b7812ULL, 0x000fe200078ef800ULL,
0x000000001e237faeULL, 0x0005e2000e101c4eULL, 0x000000142900720cULL, 0x000fe20003f86070ULL,
0x0000000127207824ULL, 0x000fe200078e0202ULL, 0x000000701a217812ULL, 0x002fe200078ef800ULL,
0x00000001291a7824ULL, 0x000fe200078e0202ULL, 0x000000082b1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000142700720cULL, 0x040fe20003fa6070ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x0000000725257c11ULL, 0x000fe2000f8e20ffULL,
0x00000001071d7824ULL, 0x000fe200030e0604ULL, 0x0000000821067210ULL, 0x000fc40007fde0ffULL,
0xfffffff8291e7812ULL, 0x004fe400078ee21aULL, 0x0000002c091a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b077824ULL, 0x000fe200030e0604ULL, 0x00000007221f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000002015237810ULL, 0x000fe20007ffe0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000724217c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a1f7faeULL, 0x0003e2000c101c4eULL,
0x000000142300720cULL, 0x040fe20003f06070ULL, 0x0000000123227824ULL, 0x000fe200078e0202ULL,
0xfffffff827207812ULL, 0x000fe200078ee220ULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0x000000701a237812ULL, 0x000fe200078ef800ULL, 0x0000000016217faeULL, 0x0005e2000c901c4eULL,
0x0000002415277810ULL, 0x000fc40007ffe0ffULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000000012257faeULL, 0x0007e2000d101c4eULL, 0x000000142700720cULL, 0x040fe20003f26070ULL,
0x00000001271a7824ULL, 0x000fe200078e0202ULL, 0x00000008230a7210ULL, 0x002fe20007fde0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000071e1f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000003c15297810ULL, 0x000fe20007ffe0ffULL, 0x000000011b0b7824ULL, 0x000fe200030e0604ULL,
0x0000000726177c11ULL, 0x004fc4000f8e20ffULL, 0x00000007201b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000003009167810ULL, 0x000fe20007ffe0ffULL, 0x0000000010177faeULL, 0x0003e2000d901c4eULL,
0xfffffff8271a7812ULL, 0x000fe400078ee21aULL, 0x0000002815137810ULL, 0x048fe20007ffe0ffULL,
0x000000000e1b7faeULL, 0x0005e2000e901c4eULL, 0x0000000722217c11ULL, 0x000fe4000f8e20ffULL,
0x000000071a237c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c1f7faeULL, 0x0007e2000e101c4eULL,
0x0000002c15257810ULL, 0x000fc40007ffe0ffULL, 0x0000003415277810ULL, 0x040fe20007ffe0ffULL,
0x0000000018217faeULL, 0x0007e2000c101c4eULL, 0x0000003015177810ULL, 0x002fe40007ffe0ffULL,
0x000000141300720cULL, 0x080fe20003fa6070ULL, 0x00000080160e7825ULL, 0x004fe200078e00ffULL,
0x00000038151b7810ULL, 0x000fe20007ffe0ffULL, 0x000000001c237faeULL, 0x0003e2000c901c4eULL,
0x000000142500720cULL, 0x000fe20003f86070ULL, 0x0000000813157824ULL, 0x040fe200078e00ffULL,
0x000000700e117812ULL, 0x000fe200078ef800ULL, 0x00000001130e7824ULL, 0x000fe200078e0202ULL,
0x00000034090c7810ULL, 0x008fe20007ffe0ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0x0000000811107210ULL, 0x000fe20007fde0ffULL, 0x00000008271a7824ULL, 0x000fe200078e00ffULL,
0x000000141700720cULL, 0x080fe20003f66070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000142700720cULL, 0x000fc40003f46070ULL, 0x000000141b00720cULL, 0x080fe20003f26070ULL,
0x000000010f117824ULL, 0x000fe200030e0604ULL, 0x000000700c137812ULL, 0x000fe200078ef800ULL,
0x00000001250c7824ULL, 0x000fe200078e0202ULL, 0x00000038090f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x000000142900720cULL, 0x000fe40003f06070ULL,
0x0000000813127210ULL, 0x000fe40007fde0ffULL, 0xfffffff815147812ULL, 0x000fe200078ee20eULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff825167812ULL, 0x000fc400078ee20cULL,
0x0000003c090c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d137824ULL, 0x000fe200030e0604ULL,
0x000000700e0d7812ULL, 0x000fe200078ef800ULL, 0x0000000117097824ULL, 0x100fe400078e0202ULL,
0x0000000127157824ULL, 0x000fe200078e0202ULL, 0x000000080d0e7210ULL, 0x080fe20007fde0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff818177812ULL, 0x000fe400078ee209ULL,
0xfffffff81a187812ULL, 0x000fe200078ee215ULL, 0x000000010f0f7824ULL, 0x000fe200030e0604ULL,
0x000000700c157812ULL, 0x000fe200078ef800ULL, 0x000000011b097824ULL, 0x100fe200078e0202ULL,
0x0000000717177c11ULL, 0x000fe2000f8e20ffULL, 0x000000081b007824ULL, 0x000fe200078e00ffULL,
0x0000000815087210ULL, 0x000fe20007fde0ffULL, 0x0000000129027824ULL, 0x040fe200078e0202ULL,
0x0000000714157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff800007812ULL, 0x000fe200078ee209ULL, 0x000000010d097824ULL, 0x000fe200030e0604ULL,
0x00000007160d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006157faeULL, 0x0005e2000e901c4eULL,
0xfffffff829027812ULL, 0x000fc400078ee202ULL, 0x0000000718197c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a0d7faeULL, 0x0005e2000e101c4eULL, 0x00000007001b7c11ULL, 0x000fe4000f8e20ffULL,
0x00000007021d7c11ULL, 0x002fe2000f8e20ffULL, 0x0000000010177faeULL, 0x0005e8000d901c4eULL,
0x0000000012197faeULL, 0x0005e8000d101c4eULL, 0x000000000e1b7faeULL, 0x0005e8000c901c4eULL,
0x00000000081d7faeULL, 0x0005e2000c101c4eULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x0000000402077811ULL, 0x046fe200078fe8ffULL, 0x0000100012077891ULL, 0x000fe2000f8e703fULL,
0x0000000802097811ULL, 0x000fc400078fe8ffULL, 0x0000000c020b7811ULL, 0x040fe200078fe8ffULL,
0x0000000107237824ULL, 0x140fe200078e0202ULL, 0x00000010020d7811ULL, 0x040fe200078fe8ffULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0x0000001402177811ULL, 0x040fe200078fe8ffULL,
0x0000000109227824ULL, 0x140fe200078e0202ULL, 0x0000001802197811ULL, 0x000fe200078fe8ffULL,
0x00000008090f7824ULL, 0x000fe200078e00ffULL, 0xfffffff804237812ULL, 0x000fe200078ee223ULL,
0x000000010b217824ULL, 0x140fe200078e0202ULL, 0x0000001c02297811ULL, 0x040fe200078fe8ffULL,
0x000000080b047824ULL, 0x000fe200078e00ffULL, 0x00000028022f7811ULL, 0x000fe200078fe8ffULL,
0x000000010d207824ULL, 0x000fe200078e0202ULL, 0xfffffff80f227812ULL, 0x000fe200078ee222ULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0xfffffff804217812ULL, 0x000fe200078ee221ULL,
0x00000001171f7824ULL, 0x040fe200078e0202ULL, 0x00000020022b7811ULL, 0x040fe200078fe8ffULL,
0x0000000817047824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee220ULL,
0x00000001191e7824ULL, 0x140fe200078e0202ULL, 0x00000024022d7811ULL, 0x040fe200078fe8ffULL,
0x00000008190f7824ULL, 0x000fe200078e00ffULL, 0x0000002c02317811ULL, 0x000fe200078fe8ffULL,
0x00000001291d7824ULL, 0x040fe200078e0202ULL, 0xfffffff8041f7812ULL, 0x000fe200078ee21fULL,
0x0000000829067824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1e7812ULL, 0x000fe200078ee21eULL,
0x000000012f1a7824ULL, 0x140fe200078e0202ULL, 0x0000003002337811ULL, 0x000fe200078fe8ffULL,
0x000000082f117824ULL, 0x000fe200078e00ffULL, 0xfffffff8061d7812ULL, 0x000fe200078ee21dULL,
0x000000012b1c7824ULL, 0x040fe200078e0202ULL, 0x0000003802377811ULL, 0x040fe200078fe8ffULL,
0x000000082b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8111a7812ULL, 0x000fe200078ee21aULL,
0x000000012d1b7824ULL, 0x040fe200078e0202ULL, 0x0000003402357811ULL, 0x040fe200078fe8ffULL,
0x000000082d047824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee21cULL,
0x0000000131117824ULL, 0x140fe200078e0202ULL, 0x0000003c02397811ULL, 0x000fe200078fe8ffULL,
0x0000000831067824ULL, 0x000fe200078e00ffULL, 0xfffffff8041b7812ULL, 0x000fe200078ee21bULL,
0x0000000133047824ULL, 0x100fe200078e0202ULL, 0x0000000d090e7c10ULL, 0x000fe2000fffe0ffULL,
0x00000008330f7824ULL, 0x000fe200078e00ffULL, 0xfffffff806117812ULL, 0x000fe200078ee211ULL,
0x0000000137087824ULL, 0x100fe200078e0202ULL, 0x0000000202067211ULL, 0x000fe200078fe8ffULL,
0x0000000135107824ULL, 0x000fe200078e0202ULL, 0xfffffff80f047812ULL, 0x000fe200078ee204ULL,
0x00000008370f7824ULL, 0x000fe200078e00ffULL, 0x0000000706257812ULL, 0x000fe200078ec0ffULL,
0x0000000835137824ULL, 0x000fe200078e00ffULL, 0x0000000d02067c11ULL, 0x000fe2000f8fe8ffULL,
0x0000000139247824ULL, 0x100fe200078e0202ULL, 0x0ffffff825257812ULL, 0x000fc400078ef802ULL,
0xfffffff80f027812ULL, 0x000fe200078ee208ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000d07087c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff813107812ULL, 0x000fe200078ee210ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000640027267a11ULL, 0x000fe400078038ffULL,
0x0000000d0b127c10ULL, 0x000fe2000fffe0ffULL, 0x0000000839137824ULL, 0x000fe200078e00ffULL,
0x00000070060b7812ULL, 0x000fe200078ef800ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000650027277a11ULL, 0x000fc400000f3cffULL, 0xfffffff813247812ULL, 0x000fe200078ee224ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000d0d147c10ULL, 0x000fe4000fffe0ffULL,
0x00000070080d7812ULL, 0x100fe400078ef800ULL, 0x0000000b260c7210ULL, 0x000fe40007f1e0ffULL,
0x000000700e157812ULL, 0x100fe400078ef800ULL, 0x0000000d260a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001070d7824ULL, 0x000fe200000e0627ULL, 0x00000070120b7812ULL, 0x000fc400078ef800ULL,
0x0000001526087210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000b26067210ULL, 0x000fe40007f5e0ffULL, 0x0000000d19167c10ULL, 0x000fe2000fffe0ffULL,
0x00000001090b7824ULL, 0x100fe200008e0627ULL, 0x0000000d29187c10ULL, 0x000fe2000fffe0ffULL,
0x000000010f097824ULL, 0x100fe200000e0627ULL, 0x00000070140f7812ULL, 0x000fe200078ef800ULL,
0x0000000113077824ULL, 0x000fe200010e0627ULL, 0x0000000d2b287c10ULL, 0x000fe2000fffe0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000d17127c10ULL, 0x000fc4000fffe0ffULL,
0x0000000f260e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000070182b7812ULL, 0x100fe400078ef800ULL, 0x0000000d2f2a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x00000070163b7812ULL, 0x100fe400078ef800ULL,
0x0000002b26167210ULL, 0x000fe20007f5e0ffULL, 0x00000001150f7824ULL, 0x000fe200000e0627ULL,
0x0000007028157812ULL, 0x000fe200078ef800ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003b26147210ULL, 0x000fc40007f3e0ffULL, 0x0000001526187210ULL, 0x000fe20007f7e0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000d2d287c10ULL, 0x000fe4000fffe0ffULL,
0x0000000d312c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000117157824ULL, 0x100fe200008e0627ULL,
0x0000000d332e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000119177824ULL, 0x100fe200010e0627ULL,
0x0000000d35307c10ULL, 0x000fe2000fffe0ffULL, 0x0000000129197824ULL, 0x000fe200018e0627ULL,
0x0000000d37327c10ULL, 0x000fe2000fffe0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000000d39347c10ULL, 0x000fc4000fffe0ffULL, 0x00000070123d7812ULL, 0x100fe200078ef800ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000007028437812ULL, 0x100fe400078ef800ULL,
0x0000003d26127210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000702a417812ULL, 0x100fe400078ef800ULL, 0x000000702c3f7812ULL, 0x100fe200078ef800ULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000702e3d7812ULL, 0x000fc400078ef800ULL,
0x00000041262a7210ULL, 0x000fe20007f3e0ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x00000070303b7812ULL, 0x100fe400078ef800ULL, 0x0000003f262c7210ULL, 0x000fe20007f5e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007032397812ULL, 0x100fe400078ef800ULL,
0x0000003d262e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000113137824ULL, 0x100fe200000e0627ULL,
0x0000007034377812ULL, 0x000fe200078ef800ULL, 0x000000012b2b7824ULL, 0x100fe200008e0627ULL,
0x0000004326287210ULL, 0x040fe20007f1e0ffULL, 0x000000012d2d7824ULL, 0x100fe200010e0627ULL,
0x0000003b26307210ULL, 0x040fe20007f9e0ffULL, 0x000000012f2f7824ULL, 0x100fe200018e0627ULL,
0x0000003926327210ULL, 0x040fe20007fbe0ffULL, 0x0000000129297824ULL, 0x100fe200000e0627ULL,
0x0000003726267210ULL, 0x000fe20007fde0ffULL, 0x0000000131317824ULL, 0x100fe200020e0627ULL,
0x0000000725257c11ULL, 0x000fe2000f8e20ffULL, 0x0000000133337824ULL, 0x100fe200028e0627ULL,
0x0000000723237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000135277824ULL, 0x000fe200030e0627ULL,
0x0000000722357c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c257faeULL, 0x0003e2000b901c4eULL, 0x0000000721217c11ULL, 0x000fc4000f8e20ffULL,
0x0000000720377c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a237faeULL, 0x0005e2000b901c4eULL,
0x000000071f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000071e397c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008357faeULL, 0x0007e2000b901c4eULL, 0x000000071d1d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000071b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006217faeULL, 0x0007e2000b901c4eULL,
0x0000000711117c11ULL, 0x000fc4000f8e20ffULL, 0x00000007100d7c11ULL, 0x002fe2000f8e20ffULL,
0x000000000e377faeULL, 0x0003e2000b901c4eULL, 0x000000071c0b7c11ULL, 0x004fc6000f8e20ffULL,
0x00000000121f7faeULL, 0x0005e2000b901c4eULL, 0x0000000704097c11ULL, 0x008fe4000f8e20ffULL,
0x000000071a077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000014397faeULL, 0x0007e2000b901c4eULL,
0x00000007020f7c11ULL, 0x002fc6000f8e20ffULL, 0x00000000161d7faeULL, 0x0007e2000b901c4eULL,
0x0000000724137c11ULL, 0x004fc6000f8e20ffULL, 0x00000000180b7faeULL, 0x0007e8000b901c4eULL,
0x00000000281b7faeULL, 0x0007e8000b901c4eULL, 0x000000002a077faeULL, 0x0007e8000b901c4eULL,
0x000000002c117faeULL, 0x0007e8000b901c4eULL, 0x000000002e097faeULL, 0x0007e8000b901c4eULL,
0x00000000300d7faeULL, 0x0007e8000b901c4eULL, 0x00000000320f7faeULL, 0x0007e8000b901c4eULL,
0x0000000026137faeULL, 0x0007e4000b901c4eULL, 0x0000000412077890ULL, 0x000fe2000fffe03fULL,
0xffffffffff617424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000080700728cULL, 0x000fc4000bf06070ULL, 0x00000007ff5e7e24ULL, 0x000fc8000f8e00ffULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000106098899ULL, 0x000fc6000800063fULL,
0x00006a0000067ab9ULL, 0x000fca0000000800ULL, 0x000000005e0783c2ULL, 0x000e6200000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000006090982a4ULL, 0x002fc6000f8e0207ULL,
0x0000660000067ab9ULL, 0x000fe40000000a00ULL, 0x00000004090682a5ULL, 0x000fcc000f8e0006ULL,
0x00000006ff067e24ULL, 0x004fe4000f8e00ffULL, 0x00000007ff077e24ULL, 0x008fca000f8e00ffULL,
0x0000000e06618981ULL, 0x000322000c1e1900ULL, 0x0000580000067ab9ULL, 0x000fe40000000800ULL,
0x0000001f06067890ULL, 0x000fc8000fffe03fULL, 0x000000053f097899ULL, 0x000fca0008011606ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x01760400ff007984ULL, 0x000e620000000800ULL,
0x000000090b0b72a4ULL, 0x000fe2000f8e023fULL, 0x8000000a626b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000620000067ab9ULL, 0x000fe40000000a00ULL, 0x000000040b0672a5ULL, 0x000fe2000f8e0006ULL,
0x8000000000ff7812ULL, 0x002fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011409ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000102027810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000012ff607e24ULL, 0x000fc8000f8e00ffULL,
0x0000002060007824ULL, 0x002fca00078e0205ULL, 0x00000003ff027819ULL, 0x000fc80000011600ULL,
0x1ffffffe02057812ULL, 0x000fe400078ec0ffULL, 0x0000000f00027812ULL, 0x000fc600078ec0ffULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x0000001002077824ULL, 0x040fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x0000000f05007812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007007812ULL, 0x000fe400078ee200ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000000c7984ULL, 0x000e62000000cc00ULL,
0x000000f002057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001000007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff027224ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x01760400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000102027810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000777919ULL, 0x000e620000002700ULL, 0x0000000aff057e24ULL, 0x000fe2000f8e00ffULL,
0x00017688606d7811ULL, 0x040fe200078e18ffULL, 0x0000000cff6c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x00000009ff637e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff05047810ULL, 0x000fe20007ffe0ffULL, 0x3db504f303027820ULL, 0x010fe20000410000ULL,
0x0001760860717811ULL, 0x000fe200078e28ffULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x0000000905057810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001006c6c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000263637824ULL, 0x000fc400078e00ffULL,
0x00006a0077777a24ULL, 0x002fc400078e02ffULL, 0x0000000203097810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000001161617c24ULL, 0x010fe2000f8e02ffULL,
0x00000001075f7812ULL, 0x000fe400078e0cffULL, 0x000000720900720cULL, 0x000fda0003f06070ULL,
0x00000cd000008947ULL, 0x004fea0003800000ULL, 0x0000010003097824ULL, 0x000fe200078e026cULL,
0x00000003ff0d7819ULL, 0x004fc80000011600ULL, 0x00000009620a7217ULL, 0x000fe40007800000ULL,
0x000000040d0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000140d1f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a09ULL, 0x000000080d0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b067824ULL, 0x100fe200078e0200ULL, 0x0000000c0d177810ULL, 0x000fe20007ffe0ffULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x000000100d1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f097824ULL, 0x000fe200078e0200ULL, 0x0000000d0d0e7c10ULL, 0x000fe2000fffe0ffULL,
0x000000081f287824ULL, 0x000fe200078e00ffULL, 0xfffffff8111e7812ULL, 0x000fe200078ee206ULL,
0x000000010f087824ULL, 0x100fe200078e0200ULL, 0x000000180d217810ULL, 0x000fe20007ffe0ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x0000000117067824ULL, 0x000fe200078e0200ULL, 0x0000000d0b107c10ULL, 0x000fe2000fffe0ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0xfffffff813227812ULL, 0x000fe200078ee208ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000000a0f00720cULL, 0x000fe20003f06070ULL,
0x000000011b087824ULL, 0x000fe200078e0200ULL, 0x0000000d0f127c10ULL, 0x000fe2000fffe0ffULL,
0x000000081b137824ULL, 0x000fe200078e00ffULL, 0xfffffff811247812ULL, 0x000fe200078ee206ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007009097812ULL, 0x000fc400078ec0ffULL,
0xfffffff813267812ULL, 0x000fe200078ee208ULL, 0x00000001210c7824ULL, 0x000fe200078e0200ULL,
0x0000640061087a11ULL, 0x000fe200078438ffULL, 0x0000000821157824ULL, 0x000fe200078e00ffULL,
0x000000090e197212ULL, 0x080fe200078efcffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001c0d237810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8150c7812ULL, 0x000fe200078ee20cULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000910157212ULL, 0x000fc400078efcffULL,
0x0000650061067a11ULL, 0x000fe200010f3cffULL, 0x00000001231a7824ULL, 0x140fe200078e0200ULL,
0x0000001908187210ULL, 0x000fe20007f5e0ffULL, 0x00000008231d7824ULL, 0x000fe200078e00ffULL,
0x0000000a0b00720cULL, 0x000fe40003f26070ULL, 0x00000009120b7212ULL, 0x000fe200078efcffULL,
0x000000010d127824ULL, 0x000fe200078e0200ULL, 0x0000000815147210ULL, 0x000fe20007f7e0ffULL,
0x000000010f197824ULL, 0x000fe200010e0606ULL, 0x0000000d1b167c10ULL, 0x000fc4000fffe0ffULL,
0x0000000d17107c10ULL, 0x000fe2000fffe0ffULL, 0x0000000111157824ULL, 0x000fe200018e0606ULL,
0x000000080b0e7210ULL, 0x000fe20007f9e0ffULL, 0x00000002600b7824ULL, 0x000fe200078e025fULL,
0x0000000a1700720cULL, 0x080fe20003f46070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff81d1a7812ULL, 0x000fe400078ee21aULL, 0x00000007121d7812ULL, 0x000fe200078ec0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000a1b00720cULL, 0x000fc40003fa6070ULL,
0x000010000b0b7811ULL, 0x000fe200078e68ffULL, 0x00000001130f7824ULL, 0x000fe200020e0606ULL,
0x0000000916137212ULL, 0x080fe400078efcffULL, 0x00000009101b7212ULL, 0x000fe400078efcffULL,
0x0ffffff81d167812ULL, 0x000fe200078ef800ULL, 0x000000101e1d7824ULL, 0x100fe200078e020bULL,
0x0000000a0d00720cULL, 0x000fe40003f66070ULL, 0x000000081b127210ULL, 0x080fe20007f9e0ffULL,
0x00000010161b7824ULL, 0x000fe200078e020bULL, 0x0000000813107210ULL, 0x000fc40007fde0ffULL,
0x0000000d1f167c10ULL, 0x000fe2000fffe0ffULL, 0x0000000111137824ULL, 0x100fe200020e0606ULL,
0x000000200d257810ULL, 0x000fe20007ffe0ffULL, 0x0000000117117824ULL, 0x000fe200030e0606ULL,
0x0000000d211e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a1f00720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e2000d901c4eULL, 0x0000000a2100720cULL, 0x080fe20003f66070ULL,
0x00000001251c7824ULL, 0x040fe200078e0200ULL, 0x0000000916217212ULL, 0x000fe200078efcffULL,
0x0000000825277824ULL, 0x000fe200078e00ffULL, 0x0000000d23207c10ULL, 0x040fe2000fffe0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000000141d7faeULL, 0x0005e2000c901c4eULL,
0x0000000a2300720cULL, 0x000fc40003f26070ULL, 0xfffffff8271c7812ULL, 0x000fe400078ee21cULL,
0x0000000821187210ULL, 0x082fe20007fde0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000240d277810ULL, 0x000fe40007ffe0ffULL, 0x000000091e1b7212ULL, 0x080fe200078efcffULL,
0x0000000117197824ULL, 0x000fe400030e0606ULL, 0x0000000127237824ULL, 0x000fe200078e0200ULL,
0x000000081b167210ULL, 0x080fe20007fde0ffULL, 0x00000008271e7824ULL, 0x040fe200078e00ffULL,
0x0000000920157212ULL, 0x004fe200078efcffULL, 0x00000010221b7824ULL, 0x000fe200078e020bULL,
0x0000000d27207c10ULL, 0x000fe2000fffe0ffULL, 0x000000011f177824ULL, 0x000fe200030e0606ULL,
0xfffffff81e227812ULL, 0x000fe200078ee223ULL, 0x00000010241d7824ULL, 0x000fe200078e020bULL,
0x0000000815147210ULL, 0x000fe20007fde0ffULL, 0x000000000e1b7faeULL, 0x0003e2000c101c4eULL,
0x0000000d251e7c10ULL, 0x000fc4000fffe0ffULL, 0x0000002c0d237810ULL, 0x000fe20007ffe0ffULL,
0x0000000121157824ULL, 0x000fe200030e0606ULL, 0x000000280d217810ULL, 0x000fe20007ffe0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000000121d7faeULL, 0x0005e2000d101c4eULL,
0x0000000a2500720cULL, 0x080fe40003f06070ULL, 0x0000000821247824ULL, 0x000fe200078e00ffULL,
0x0000000a2700720cULL, 0x000fe20003f46070ULL, 0x00000001211b7824ULL, 0x102fe200078e0200ULL,
0x000000091e0f7212ULL, 0x000fe200078efcffULL, 0x00000001231e7824ULL, 0x000fc400078e0200ULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0x000000080f0e7210ULL, 0x000fe20007fde0ffULL,
0x0000008020127825ULL, 0x004fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe400078ee21bULL,
0x0000000d21207c10ULL, 0x000fe2000fffe0ffULL, 0x00000010261b7824ULL, 0x100fe200078e020bULL,
0xfffffff825267812ULL, 0x000fe200078ee21eULL, 0x000000011f0f7824ULL, 0x000fe200030e0606ULL,
0x00000009121f7212ULL, 0x000fe200078efcffULL, 0x00000010281d7824ULL, 0x000fe200078e020bULL,
0x00000000101b7faeULL, 0x0003e2000e901c4eULL, 0x0000000a2100720cULL, 0x000fe20003fa6070ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000081f1e7210ULL, 0x000fe20007fde0ffULL,
0x00000000181d7faeULL, 0x0005e2000e101c4eULL, 0x0000000a2300720cULL, 0x000fc40003f86070ULL,
0x0000000d23127c10ULL, 0x000fe2000fffe0ffULL, 0x00000001131f7824ULL, 0x000fe200030e0606ULL,
0x000000300d237810ULL, 0x000fe40007ffe0ffULL, 0x0000000920117212ULL, 0x002fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000000811107210ULL, 0x080fe20007fde0ffULL,
0x0000000123187824ULL, 0x044fe200078e0200ULL, 0x0000000912197212ULL, 0x000fe200078efcffULL,
0x00000008231d7824ULL, 0x040fe400078e00ffULL, 0x000000100c1b7824ULL, 0x100fe200078e020bULL,
0x0000000d230c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000121117824ULL, 0x000fe200030e0606ULL,
0xfffffff81d207812ULL, 0x000fe400078ee218ULL, 0x000000340d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000161b7faeULL, 0x0003e2000d901c4eULL, 0x0000000819127210ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x000fe200078e020bULL, 0x0000000a2300720cULL, 0x000fe20003f66070ULL,
0x000000011d187824ULL, 0x000fc400078e0200ULL, 0x000000081d217824ULL, 0x040fe200078e00ffULL,
0x0000000014197faeULL, 0x0005e2000c901c4eULL, 0x0000000a1d00720cULL, 0x000fe20003f26070ULL,
0x0000000113137824ULL, 0x000fe400030e0606ULL, 0xfffffff8211a7812ULL, 0x000fe200078ee218ULL,
0x000000800c167825ULL, 0x002fe200078e00ffULL, 0x0000000d1d0c7c10ULL, 0x000fe4000fffe0ffULL,
0x000000380d1d7810ULL, 0x040fe40007ffe0ffULL, 0x00000009161b7212ULL, 0x000fe200078efcffULL,
0x000000800c147825ULL, 0x004fe200078e00ffULL, 0x0000003c0d217810ULL, 0x000fc40007ffe0ffULL,
0x000000081b167210ULL, 0x080fe20007fde0ffULL, 0x000000101c1b7824ULL, 0x100fe200078e020bULL,
0x0000000d1d0c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001022197824ULL, 0x000fe200078e020bULL,
0x00000009140d7212ULL, 0x000fe200078efcffULL, 0x0000000117177824ULL, 0x100fe200030e0606ULL,
0x0000000d21187c10ULL, 0x000fe2000fffe0ffULL, 0x000000000e1b7faeULL, 0x0003e2000c101c4eULL,
0x000000080d147210ULL, 0x000fe20007fde0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a2100720cULL, 0x080fe20003f06070ULL, 0x000000001e197faeULL, 0x0005e2000d101c4eULL,
0x0000000a1d00720cULL, 0x000fe20003f46070ULL, 0x0000000115157824ULL, 0x000fc400030e0606ULL,
0x000000011d0a7824ULL, 0x040fe400078e0200ULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x000000090c1b7212ULL, 0x002fe200078efcffULL, 0x00000080180e7825ULL, 0x000fc600078e00ffULL,
0xfffffff81d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000121187824ULL, 0x000fe200078e0200ULL,
0x000000081b0c7210ULL, 0x080fe20007fde0ffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x000000090e097212ULL, 0x000fe200078efcffULL, 0x0000001024197824ULL, 0x104fe400078e020bULL,
0x000000010d0d7824ULL, 0x000fe200030e0606ULL, 0xfffffff821187812ULL, 0x000fe200078ee218ULL,
0x00000010261b7824ULL, 0x100fe200078e020bULL, 0x0000000809087210ULL, 0x000fe20007fde0ffULL,
0x00000010201d7824ULL, 0x100fe200078e020bULL, 0x0000000010197faeULL, 0x0003e2000e901c4eULL,
0x000000101a1f7824ULL, 0x000fc400078e020bULL, 0x000000100a217824ULL, 0x100fe200078e020bULL,
0x00000000121b7faeULL, 0x0003e2000e101c4eULL, 0x00000010180b7824ULL, 0x000fe400078e020bULL,
0x000000010f097824ULL, 0x000fe200030e0606ULL, 0x00000000161d7faeULL, 0x0003e8000d901c4eULL,
0x00000000141f7faeULL, 0x0003e8000c901c4eULL, 0x000000000c217faeULL, 0x0003e8000d101c4eULL,
0x00000000080b7faeULL, 0x0003e2000c101c4eULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x00000004000b7811ULL, 0x044fe200078fe8ffULL, 0x0000001000337824ULL, 0x040fe200078e00ffULL,
0x00000008000d7811ULL, 0x000fc400078fe8ffULL, 0x0000000c000f7811ULL, 0x040fe200078fe8ffULL,
0x000000010b067824ULL, 0x140fe200078e0200ULL, 0x0000001000117811ULL, 0x040fe200078fe8ffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x00000018003d7811ULL, 0x040fe200078fe8ffULL,
0x000000080d1f7824ULL, 0x000fe200078e00ffULL, 0x0000001c003f7811ULL, 0x040fe200078fe8ffULL,
0x000000010f087824ULL, 0x000fe200078e0200ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x000000010d067824ULL, 0x100fe200078e0200ULL, 0x0000002000417811ULL, 0x040fe200078fe8ffULL,
0x000000080f217824ULL, 0x000fe200078e00ffULL, 0x0000002800377811ULL, 0x040fe200078fe8ffULL,
0x0000000111097824ULL, 0x000fe200078e0200ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x00000008110c7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee208ULL,
0x000000013d067824ULL, 0x140fe200078e0200ULL, 0x0000002c00357811ULL, 0x000fe200078fe8ffULL,
0x000000083d277824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2b7812ULL, 0x000fe200078ee209ULL,
0x000000013f087824ULL, 0x040fe200078e0200ULL, 0x0000003000317811ULL, 0x040fe200078fe8ffULL,
0x000000083f257824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee206ULL,
0x0000000141097824ULL, 0x040fe200078e0200ULL, 0x0000001400137811ULL, 0x040fe200078fe8ffULL,
0x00000008410c7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x0000000137067824ULL, 0x140fe200078e0200ULL, 0x00000024002d7811ULL, 0x000fe200078fe8ffULL,
0x0000000837177824ULL, 0x000fe200078e00ffULL, 0xfffffff80c237812ULL, 0x000fe200078ee209ULL,
0x0000000135087824ULL, 0x040fe200078e0200ULL, 0x00000034002f7811ULL, 0x040fe200078fe8ffULL,
0x0000000835197824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee206ULL,
0x0000000131097824ULL, 0x040fe200078e0200ULL, 0x0000000000067211ULL, 0x040fe200078fe8ffULL,
0x00000008310c7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee208ULL,
0x00000001130a7824ULL, 0x040fe200078e0200ULL, 0x0000003800397811ULL, 0x000fe200078fe8ffULL,
0x0000000813297824ULL, 0x000fe200078e00ffULL, 0xfffffff80c437812ULL, 0x000fe200078ee209ULL,
0x0000000260087824ULL, 0x000fe200078e025fULL, 0x0000000706097812ULL, 0x000fe200078ec0ffULL,
0x000000082d157824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x000000012d0a7824ULL, 0x100fe200078e0200ULL, 0x0000100008247811ULL, 0x000fe200078e68ffULL,
0x000000082f457824ULL, 0x000fe200078e00ffULL, 0x0ffffff809097812ULL, 0x000fe200078ef800ULL,
0x0000000839477824ULL, 0x000fe200078e00ffULL, 0x0000000d00087c11ULL, 0x000fe2000f8fe8ffULL,
0x0000001017207824ULL, 0x000fe200078e0224ULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x000000012f0a7824ULL, 0x000fe200078e0200ULL, 0x0000007033337812ULL, 0x000fe200078ec0ffULL,
0x00000010091b7824ULL, 0x000fe200078e0224ULL, 0x0000000d0d147c10ULL, 0x000fe2000fffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fc400078ee20aULL,
0x0000640061267a11ULL, 0x000fe200078038ffULL, 0x00000001390a7824ULL, 0x000fe200078e0200ULL,
0x0000000d0b0b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001015227824ULL, 0x000fe200078e0224ULL,
0x0000000d0f167c10ULL, 0x000fe2000fffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000033080f7212ULL, 0x000fe400078efcffULL, 0xfffffff847477812ULL, 0x000fe200078ee20aULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000650061287a11ULL, 0x000fc400000f3cffULL,
0x0000000f260e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000d11107c10ULL, 0x000fe4000fffe0ffULL, 0x0000003314117212ULL, 0x080fe200078efcffULL,
0x00000001090f7824ULL, 0x000fe200000e0628ULL, 0x000000330a0d7212ULL, 0x000fe200078efcffULL,
0x00000010191e7824ULL, 0x100fe200078e0224ULL, 0x00000011260a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000003316197212ULL, 0x000fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000b901c4eULL,
0x0000000d13137c10ULL, 0x000fe2000fffe0ffULL, 0x00000010431c7824ULL, 0x100fe200078e0224ULL,
0x0000000d260c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x0000000d3f3c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x0000000d413e7c10ULL, 0x000fc4000fffe0ffULL, 0x0000001926087210ULL, 0x000fe20007f5e0ffULL,
0x000000010b0d7824ULL, 0x100fe200008e0628ULL, 0x0000003310197212ULL, 0x000fe200078efcffULL,
0x00000001150b7824ULL, 0x000fe200000e0628ULL, 0x0000000d3d147c10ULL, 0x000fe2000fffe0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000001926187210ULL, 0x000fe20007f1e0ffULL,
0x000000000c1d7faeULL, 0x0003e2000b901c4eULL, 0x0000003c003b7811ULL, 0x000fe200078fe8ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000333c417212ULL, 0x000fc400078efcffULL,
0x0000000d2d2e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000117097824ULL, 0x100fe200010e0628ULL,
0x0000003312177212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000333e437212ULL, 0x000fe400078efcffULL, 0x0000000d373a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000111197824ULL, 0x000fe200000e0628ULL, 0x0000000d35387c10ULL, 0x000fe2000fffe0ffULL,
0x000000013b067824ULL, 0x040fe200078e0200ULL, 0x0000001726167210ULL, 0x040fe20007f1e0ffULL,
0x000000083b497824ULL, 0x000fe200078e00ffULL, 0x0000000d31367c10ULL, 0x000fe2000fffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0224ULL, 0x0000004126127210ULL, 0x000fe20007f5e0ffULL,
0x0000000113177824ULL, 0x000fe200000e0628ULL, 0x0000000d2f347c10ULL, 0x000fe2000fffe0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000d39307c10ULL, 0x000fe2000fffe0ffULL,
0x000000000a1f7faeULL, 0x0003e2000b901c4eULL, 0x0000003314117212ULL, 0x000fe200078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004326107210ULL, 0x000fc40007f7e0ffULL,
0x0000000d3b2c7c10ULL, 0x000fe2000fffe0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000001126147210ULL, 0x000fe40007f3e0ffULL, 0xfffffff849497812ULL, 0x000fe200078ee206ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000003338417212ULL, 0x000fc600078efcffULL,
0x000000013d137824ULL, 0x000fe200010e0628ULL, 0x000000332e3d7212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003336437212ULL, 0x000fe400078efcffULL,
0x0000003d262e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000004126387210ULL, 0x000fc60007f5e0ffULL, 0x000000013f117824ULL, 0x000fe200018e0628ULL,
0x000000333a3f7212ULL, 0x000fe200078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000004326367210ULL, 0x000fc60007f7e0ffULL, 0x0000001021217824ULL, 0x100fe400078e0224ULL,
0x00000010451a7824ULL, 0x100fe200078e0224ULL, 0x0000003334457212ULL, 0x080fe200078efcffULL,
0x0000001047067824ULL, 0x100fe200078e0224ULL, 0x0000003330477212ULL, 0x080fe200078efcffULL,
0x000000102b2b7824ULL, 0x000fe200078e0224ULL, 0x000000332c337212ULL, 0x000fe200078efcffULL,
0x0000000115157824ULL, 0x000fe200008e0628ULL, 0x0000003f26327210ULL, 0x040fe20007f3e0ffULL,
0x0000001029297824ULL, 0x100fe200078e0224ULL, 0x0000004526347210ULL, 0x040fe20007f9e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x0000000008217faeULL, 0x0003e2000b901c4eULL,
0x0000001025257824ULL, 0x100fe200078e0224ULL, 0x0000004726307210ULL, 0x040fe20007fbe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0224ULL, 0x00000033262c7210ULL, 0x000fe20007fde0ffULL,
0x000000012f2f7824ULL, 0x100fe200000e0628ULL, 0x00000000182b7faeULL, 0x0003e2000b901c4eULL,
0x000000013b337824ULL, 0x000fc400008e0628ULL, 0x0000000139397824ULL, 0x100fe200010e0628ULL,
0x0000000016297faeULL, 0x0003e2000b901c4eULL, 0x0000000137377824ULL, 0x100fe400018e0628ULL,
0x0000000135357824ULL, 0x100fe200020e0628ULL, 0x0000000014277faeULL, 0x0003e2000b901c4eULL,
0x0000000131317824ULL, 0x000fe400028e0628ULL, 0x0000001049247824ULL, 0x000fe200078e0224ULL,
0x0000000012257faeULL, 0x0003e2000b901c4eULL, 0x000000012d2d7824ULL, 0x000fc600030e0628ULL,
0x0000000010237faeULL, 0x0003e8000b901c4eULL, 0x000000002e227faeULL, 0x0003e8000b901c4eULL,
0x0000000032207faeULL, 0x0003e8000b901c4eULL, 0x00000000381e7faeULL, 0x0003e8000b901c4eULL,
0x00000000361c7faeULL, 0x0003e8000b901c4eULL, 0x00000000341a7faeULL, 0x0003e8000b901c4eULL,
0x0000000030067faeULL, 0x0003e8000b901c4eULL, 0x000000002c247faeULL, 0x0003e4000b901c4eULL,
0x000000045e5e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x000000085e007c0cULL, 0x000fe4000bf06070ULL,
0x00000020000d7810ULL, 0x002fe20007ffe0ffULL, 0x0000000260077824ULL, 0x000fe200078e0207ULL,
0x00000007000f7812ULL, 0x040fe400078ec0ffULL, 0xfffffff8000b7812ULL, 0x000fce00078ec0ffULL,
0x0000000277088824ULL, 0x000fe400078e025eULL, 0x00000004ff098424ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000660008088625ULL, 0x000fe200078e0009ULL,
0x00000004ff677819ULL, 0x000fe20000011600ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000e08618981ULL, 0x000322000c1e1900ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000100007077811ULL, 0x000fe400078e68ffULL, 0x000000080f087812ULL, 0x102fe400078ef800ULL,
0x000000070b097812ULL, 0x100fe400078ef800ULL, 0x000000070d067812ULL, 0x000fc600078ef800ULL,
0x00000001090b7824ULL, 0x040fe200078e020aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008090c7824ULL, 0x060fe400078e00ffULL, 0x0000000809197824ULL, 0x000fc400078e00ffULL,
0x000000020a737824ULL, 0x000fe200078e0267ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x00000001060b7824ULL, 0x000fc800078e020aULL, 0x000000100c107824ULL, 0x000fe400078e0207ULL,
0x00000008060c7824ULL, 0x000fc800078e00ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0xfffffff80c0c7812ULL, 0x000fca00078ee20bULL, 0x000000100c0c7824ULL, 0x000fcc00078e0207ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x00000018ff4c7819ULL, 0x002fe20000011410ULL,
0x00010000100b7824ULL, 0x040fe200078e00ffULL, 0x0000888010747816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011411ULL,
0x0001000011187824ULL, 0x040fe200078e00ffULL, 0x00008880116e7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fc4000001140bULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff667819ULL, 0x000fe40000011412ULL,
0x0000888012687816ULL, 0x000fe200000000ffULL, 0x0000001000757306ULL, 0x0002e20000200c00ULL,
0x00000018ff557819ULL, 0x004fe4000001140cULL, 0x000088800c547816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011413ULL, 0x0000888013507816ULL, 0x040fe200000000ffULL,
0x0000000b00767306ULL, 0x0005e20000200c00ULL, 0x0001000013107824ULL, 0x042fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe4000001140eULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000011006f7306ULL, 0x0003e20000200c00ULL, 0x00010000120b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x000088800e527816ULL, 0x000fc400000000ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001000657306ULL, 0x0005e20000200c00ULL, 0x000000010a117810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff4f7819ULL, 0x000fe4000001140fULL,
0x000088800f4d7816ULL, 0x000fe200000000ffULL, 0x0000001200697306ULL, 0x0003e20000200c00ULL,
0x0000000109107824ULL, 0x004fe200078e0211ULL, 0x00000018ff577819ULL, 0x000fe2000001140dULL,
0x0000000106117824ULL, 0x000fe200078e0211ULL, 0x000088800d597816ULL, 0x000fc400000000ffULL,
0x000000020a0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b006a7306ULL, 0x0005e20000200c00ULL,
0xfffffff819127812ULL, 0x002fe200078ee210ULL, 0x000100000d107824ULL, 0x040fe200078e00ffULL,
0x000000080a00780cULL, 0x000fe20003f05270ULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e0207ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001300647306ULL, 0x000fe20000200c00ULL, 0x000100000c0b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x00000000121c783bULL, 0x000e620000000200ULL,
0x000001000c0c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000010005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000000c005c7306ULL, 0x0005f00000200c00ULL, 0x0000001800707306ULL, 0x0007e20000200c00ULL,
0x00000008060c7824ULL, 0x004fca00078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee211ULL,
0x0000007400747306ULL, 0x000ea60000200c00ULL, 0x000000100c187824ULL, 0x008fe400078e0207ULL,
0x000100000f0c7824ULL, 0x040fe400078e00ffULL, 0x000001000f0f7824ULL, 0x000fe200078e00ffULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000000001818783bULL, 0x000ee20000000200ULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000100001c107824ULL, 0x002fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001141cULL, 0x000100001d117824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001141dULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000000c00497306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe20000011411ULL,
0x0000001008117824ULL, 0x000fe200078e00ffULL, 0x000088801d427816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001141eULL,
0x000088801e457816ULL, 0x000fe200000000ffULL, 0x0000001000417306ULL, 0x0005e20000200c00ULL,
0x000088801c0c7816ULL, 0x042fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff3c7819ULL, 0x000fe4000001141fULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d00447306ULL, 0x0003e20000200c00ULL,
0x0000000108107824ULL, 0x144fe200078e0273ULL, 0x000088801f477816ULL, 0x000fe400000000ffULL,
0x0000000208737810ULL, 0x000fe40007ffe073ULL, 0xfffffff011107812ULL, 0x000fe400078ee210ULL,
0x0000001c00407306ULL, 0x0005e20000200c00ULL, 0x000100001f1d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001140fULL, 0x0000001010107824ULL, 0x000fc400078e00ffULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000100001e1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x008fe40000011418ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d004b7306ULL, 0x0005e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000001c00467306ULL, 0x0007e20000200c00ULL,
0x00005410751d7816ULL, 0x004fce000000004cULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410741c7816ULL, 0x008fce0000000076ULL, 0x0000006800687306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000001c1038723cULL, 0x002b6e0000001838ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054106e1c7816ULL, 0x020fe20000000070ULL,
0x0000001008707824ULL, 0x000fe200078e00ffULL, 0x000054106f1d7816ULL, 0x000fe2000000004aULL,
0x00010000186e7824ULL, 0x000fc600078e00ffULL, 0xfffffff070737812ULL, 0x000fe200078ee273ULL,
0x0000001e00487306ULL, 0x0007e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000001c1034723cULL, 0x000bec0000001834ULL, 0x0000000b005d7306ULL, 0x0003e20000200c00ULL,
0x00005410681c7816ULL, 0x024fc4000000006aULL, 0x00005410691d7816ULL, 0x000fe40000000066ULL,
0x00008880181e7816ULL, 0x008fc600000000ffULL, 0x0000001f004c7306ULL, 0x0005e20000200c00ULL,
0x000100000e0b7824ULL, 0x042fe200078e00ffULL, 0x0000001c1030723cULL, 0x000b620000001830ULL,
0x000001000e0e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001e004a7306ULL, 0x0003e20000200c00ULL, 0x00005410501c7816ULL, 0x020fe20000000065ULL,
0x00000100181f7824ULL, 0x004fe200078e00ffULL, 0x00005410641d7816ULL, 0x000fe2000000005bULL,
0x0001000019647824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x00000018ff667819ULL, 0x000fe2000001141fULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x00000010731e7824ULL, 0x002fe200078e00ffULL, 0x0000001c102c723cULL, 0x000b62000000182cULL,
0x0000888019657816ULL, 0x000fc400000000ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x000000001e1c783bULL, 0x020e620000000200ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x000000ffff5b7224ULL, 0x000fce00078e0065ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000054105c557816ULL, 0x004fe20000000055ULL, 0x00000100195c7824ULL, 0x000fcc00078e00ffULL,
0x0000000b00537306ULL, 0x0004620000200c00ULL, 0x0000541054547816ULL, 0x008fce000000005dULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000541028723cULL, 0x000b620000001828ULL,
0x00000018ff0b7819ULL, 0x004fcc000001141bULL, 0x0000000e00567306ULL, 0x0004e20000200c00ULL,
0x0000541052527816ULL, 0x002fce0000000053ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000018ff0e7819ULL, 0x004fce0000011419ULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541056537816ULL, 0x008fce0000000051ULL, 0x0000000d00587306ULL, 0x0004e20000200c00ULL,
0x000000521020723cULL, 0x000bee0000001820ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541059547816ULL, 0x022fe4000000005aULL, 0x00000018ff0d7819ULL, 0x004fca000001141aULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541058557816ULL, 0x008fce0000000057ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000541024723cULL, 0x000b6e0000001824ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054104d527816ULL, 0x002fe40000000049ULL,
0x000088801a557816ULL, 0x020fc400000000ffULL, 0x00000018ff547819ULL, 0x000fc6000001145cULL,
0x0000000c000c7306ULL, 0x000e620000200c00ULL, 0x000054104e537816ULL, 0x004fe2000000004fULL,
0x000000ffff517224ULL, 0x000fe400078e0055ULL, 0x000100001a557824ULL, 0x040fe400078e00ffULL,
0x000001001a1a7824ULL, 0x000fe400078e00ffULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000000521014723cULL, 0x000b640000001814ULL, 0x00000018ff1a7819ULL, 0x000fca000001141aULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x000054100c107816ULL, 0x022fe20000000041ULL,
0x000100001b137824ULL, 0x040fe200078e00ffULL, 0x0000541040117816ULL, 0x000fe4000000003fULL,
0x000088801b0c7816ULL, 0x040fe200000000ffULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011455ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x000000101c38723cULL, 0x000b620000001838ULL,
0x00000018ff1b7819ULL, 0x000fca000001141bULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x0000541045107816ULL, 0x024fe40000000046ULL, 0x0000541048117816ULL, 0x000fca000000003dULL,
0x0000003e003e7306ULL, 0x000ea40000200c00ULL, 0x000000101c30723cULL, 0x000b6c0000001830ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x0000541042427816ULL, 0x002fce0000000043ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x0000541044437816ULL, 0x004fe4000000003eULL,
0x000054104c117816ULL, 0x028fca000000003cULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x000000421c34723cULL, 0x000f620000001834ULL, 0x0000541047107816ULL, 0x002fcc000000004bULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000000101c2c723cULL, 0x000b6e000000182cULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000000b000b7306ULL, 0x000ff00000200c00ULL,
0x0000006e00187306ULL, 0x000e700000200c00ULL, 0x0000006600507306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x002fce0000000018ULL,
0x0000006400197306ULL, 0x000e620000200c00ULL, 0x00005410504b7816ULL, 0x004fce000000000fULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000004a1c28723cULL, 0x000b6e0000001828ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054105b107816ULL, 0x022fce0000000019ULL,
0x0000001200127306ULL, 0x000e620000200c00ULL, 0x0000541054117816ULL, 0x004fce000000000eULL,
0x0000001a001a7306ULL, 0x000ea20000200c00ULL, 0x000000101c24723cULL, 0x000b6e0000001824ULL,
0x0000000c003e7306ULL, 0x0003f00000200c00ULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x00005410510c7816ULL, 0x002fc40000000012ULL, 0x000054101a0d7816ULL, 0x004fca000000000dULL,
0x0000001b003c7306ULL, 0x000e640000200c00ULL, 0x0000000c1c20723cULL, 0x000b620000001820ULL,
0x000054103e3e7816ULL, 0x008fe40000000013ULL, 0x000054103c3f7816ULL, 0x002fce000000000bULL,
0x0000003e1c14723cULL, 0x000b620000001814ULL, 0xfffff0a000000947ULL, 0x000fce000383ffffULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x000000023a3a7220ULL, 0x080fe40000410000ULL, 0x000000023b3b7220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x00000002351f7220ULL, 0x020fc40000410000ULL,
0x0000000236367220ULL, 0x080fe40000410000ULL, 0x00000002371e7220ULL, 0x080fe40000410000ULL,
0x00000002301d7220ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006d067f8cULL, 0x000e62000c80043fULL, 0x0000000231317220ULL, 0x080fe40000410000ULL,
0x0000000220207220ULL, 0x080fe40000410000ULL, 0x0000000232087220ULL, 0x000fc40000410000ULL,
0x0000000233097220ULL, 0x080fe40000410000ULL, 0x000000022e0a7220ULL, 0x080fe40000410000ULL,
0x000000022f0b7220ULL, 0x080fe40000410000ULL, 0x000000022b0c7220ULL, 0x080fe40000410000ULL,
0x00000002260d7220ULL, 0x080fe40000410000ULL, 0x00000002220e7220ULL, 0x000fc40000410000ULL,
0x00000002292e7220ULL, 0x080fe40000410000ULL, 0x0000000221307220ULL, 0x080fe40000410000ULL,
0x000000022d357220ULL, 0x080fe40000410000ULL, 0x000000022c067220ULL, 0x082fe40000410000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0031ULL, 0x0000000228337220ULL, 0x000fc40000410000ULL,
0x000000022a297220ULL, 0x080fe40000410000ULL, 0x00000002242f7220ULL, 0x080fe40000410000ULL,
0x0000000225327220ULL, 0x080fe40000410000ULL, 0x00000002271c7220ULL, 0x080fe40000410000ULL,
0x0000000223187220ULL, 0x080fe40000410000ULL, 0x00000002152b7220ULL, 0x000fc40000410000ULL,
0x0000000216197220ULL, 0x080fe40000410000ULL, 0x00000002171a7220ULL, 0x080fe40000410000ULL,
0x000000ffff217224ULL, 0x000fe400078e0034ULL, 0x000000ffff317224ULL, 0x000fe400078e0020ULL,
0x00000002142a7220ULL, 0x000fe40000410000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0007ULL,
0x000000ffff257224ULL, 0x000fe400078e0038ULL, 0x000000ffff237224ULL, 0x000fe400078e0039ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0006ULL, 0x000000ffff247224ULL, 0x000fe400078e003aULL,
0x000000ffff227224ULL, 0x000fe400078e003bULL, 0x000000ffff207224ULL, 0x000fc400078e0036ULL,
0x000000ffff277224ULL, 0x000fe400078e0008ULL, 0x000000ffff267224ULL, 0x000fe400078e0009ULL,
0x000000ffff287224ULL, 0x000fe400078e000aULL, 0x000000ffff347224ULL, 0x000fe400078e000bULL,
0x000000ffff157224ULL, 0x000fe400078e000cULL, 0x000000ffff167224ULL, 0x000fc400078e000dULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x000004006d087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004006d087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004001b7824ULL, 0x000fe200078e00ffULL, 0x0000006b0300720cULL, 0x000fc80003f06070ULL,
0xfffffff01b077812ULL, 0x000fca00078ec0ffULL, 0x0000008060147824ULL, 0x000fca00078e0207ULL,
0x0174000014087984ULL, 0x0002a20000000c00ULL, 0x0000151000008947ULL, 0x000fea0003800000ULL,
0x00005a00000d7b06ULL, 0x000ee20000209000ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x0000000200367824ULL, 0x000fca00078e00ffULL, 0x0000000636367812ULL, 0x000fc800078ec0ffULL,
0x0000000a36377c10ULL, 0x040fe4000fffe0ffULL, 0x00000010363b7812ULL, 0x000fe200078efcffULL,
0x0000000d000d7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0d0f7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000f00077305ULL, 0x000664000021f000ULL, 0x00005a00ff0f7a12ULL, 0x008fe200078e33ffULL,
0x000000ffff117224ULL, 0x002fc800078e0a07ULL, 0x00005a0011117a24ULL, 0x000fc800078e02ffULL,
0x0000001107117227ULL, 0x000fe200078e0006ULL, 0x0000000500067c11ULL, 0x000fc8000f8ff0ffULL,
0x0000000806077810ULL, 0x000fe20007ffe0ffULL, 0x00000006110c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x00000007110e7227ULL, 0x000fc800078e00ffULL,
0x00005a000d067a24ULL, 0x000fe400078e0206ULL, 0x000000ffff107224ULL, 0x000fc600078e0a0eULL,
0x00005a0006007a0cULL, 0x000fe20003f06070ULL, 0x00005a00100d7a24ULL, 0x000fe200078e0207ULL,
0x0000000c03077c11ULL, 0x000fc8000f8e40ffULL, 0x00005a000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000762387217ULL, 0x000fca0007800000ULL, 0x80005a0006060a10ULL, 0x000fe20007ffe0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a07ULL, 0x000000010c0c0810ULL, 0x000fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0236ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a000d007a0cULL, 0x000fe20003f66070ULL, 0x00000001070d7824ULL, 0x040fe200078e0a38ULL,
0x000000380700720cULL, 0x000fc40003f86070ULL, 0x000000010e0e2810ULL, 0x000fc60007ffe0ffULL,
0x000000010c0c1810ULL, 0x000fc80007ffe0ffULL, 0x0000000c0f077207ULL, 0x000fe40004000000ULL,
0x0000000d040c7217ULL, 0x000fe20003800000ULL, 0x00000001370d7824ULL, 0x000fe200078e0a38ULL,
0x000000010e0e3810ULL, 0x000fe40007ffe0ffULL, 0x0000000704067217ULL, 0x000fe40003800000ULL,
0x00000004ff0c7819ULL, 0x000fe4000001160cULL, 0x0000000e0f077207ULL, 0x000fe20004000000ULL,
0x0000000663517224ULL, 0x000fe200078e02ffULL, 0x000000ff0c0c7207ULL, 0x000fe20002000000ULL,
0x0000000105437824ULL, 0x000fe200078e023bULL, 0x000000383700720cULL, 0x000fe20003f06070ULL,
0x00000006ff067e24ULL, 0x000fe2000f8e00ffULL, 0x0000000d040d7217ULL, 0x040fe20003800000ULL,
0x0000000151137824ULL, 0x000fe200078e020cULL, 0x00000007040e7217ULL, 0x000fe20003800000ULL,
0x00000007ff077e24ULL, 0x000fe2000f8e00ffULL, 0x000000ff0d3a7207ULL, 0x000fe20000000000ULL,
0x0000000143417824ULL, 0x000fc400078e0a38ULL, 0x0000000213127825ULL, 0x000fe200078e0006ULL,
0x000000513a0d7211ULL, 0x000fe400078fe0ffULL, 0x0000004104407217ULL, 0x000fe20003800000ULL,
0x0000000e634f7224ULL, 0x000fe200078e02ffULL, 0x0000000e12397981ULL, 0x0002e2000c1e9500ULL,
0x000000384300720cULL, 0x000fe40003f26070ULL, 0x000000010c0f7824ULL, 0x000fe200078e024fULL,
0x0000002036437812ULL, 0x000fe200078efcffULL, 0x000000020d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000a3b3d7c10ULL, 0x000fc4000fffe0ffULL, 0x0000004f3a117211ULL, 0x000fe400078fe0ffULL,
0x00000004ff127819ULL, 0x002fe20000011640ULL, 0x0000000e0c3c7981ULL, 0x0002e6000c1e9500ULL,
0x000000ff12127207ULL, 0x000fe20000800000ULL, 0x0000000105477824ULL, 0x000fe400078e0243ULL,
0x000000013d417824ULL, 0x100fe400078e0a38ULL, 0x00000001474b7824ULL, 0x000fc400078e0a38ULL,
0x00000001510d7824ULL, 0x002fe200078e0212ULL, 0x0000000a43457c10ULL, 0x000fe2000fffe0ffULL,
0x000000020f0e7825ULL, 0x000fe200078e0006ULL, 0x000000383d00720cULL, 0x000fc60003f06070ULL,
0x000000020d0c7825ULL, 0x100fe200078e0006ULL, 0x0000004104407217ULL, 0x040fe20003800000ULL,
0x0000000e0e3e7981ULL, 0x0042a2000c1e9500ULL, 0x0000004b044b7217ULL, 0x000fe20003800000ULL,
0x0000000211107825ULL, 0x000fe200078e0006ULL, 0x000000ff40407207ULL, 0x000fe20000000000ULL,
0x0000000e0c417981ULL, 0x0002a2000c1e9500ULL, 0x000000384700720cULL, 0x000fe40003f26070ULL,
0x00000004ff4b7819ULL, 0x000fe2000001164bULL, 0x0000000e103f7981ULL, 0x0002a2000c1e9500ULL,
0x0000003036477812ULL, 0x000fe200078efcffULL, 0x00000001450d7824ULL, 0x002fe200078e0a38ULL,
0x00000051400f7211ULL, 0x000fc400078fe0ffULL, 0x0000004f40137211ULL, 0x000fe200078fe0ffULL,
0x0000000112117824ULL, 0x000fe200078e024fULL, 0x000000384500720cULL, 0x000fe20003f06070ULL,
0x0000000105557824ULL, 0x000fe200078e0247ULL, 0x0000000d040d7217ULL, 0x000fe40003800000ULL,
0x000000ff4b467207ULL, 0x000fe20000800000ULL, 0x000000020f0e7825ULL, 0x000fe200078e0006ULL,
0x000000ff0d4a7207ULL, 0x000fc60000000000ULL, 0x0000000211107825ULL, 0x100fe200078e0006ULL,
0x0000000a474b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000e0e427981ULL, 0x0002a4000c1e9500ULL,
0x0000000213127825ULL, 0x000fe400078e0006ULL, 0x0000000e10447981ULL, 0x0002a4000c1e9500ULL,
0x00000001510d7824ULL, 0x000fe400078e0246ULL, 0x0000000155537824ULL, 0x000fe200078e0a38ULL,
0x0000000e12497981ULL, 0x0002a2000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fe200078e0006ULL,
0x000000514a0f7211ULL, 0x002fc400078fe0ffULL, 0x00000053044c7217ULL, 0x000fe20003800000ULL,
0x000000014b537824ULL, 0x000fe400078e0a38ULL, 0x0000000146117824ULL, 0x000fe400078e024fULL,
0x0000000e0c467981ULL, 0x0002a2000c1e9500ULL, 0x0000004f4a137211ULL, 0x000fe200078fe0ffULL,
0x000000020f0e7825ULL, 0x100fe200078e0006ULL, 0x000000385500720cULL, 0x080fe40003f26070ULL,
0x000000384b00720cULL, 0x000fe20003f06070ULL, 0x0000000213127825ULL, 0x000fe200078e0006ULL,
0x0000000e0e4d7981ULL, 0x0002a4000c1e9500ULL, 0x00000004ff0c7819ULL, 0x002fe2000001164cULL,
0x0000000211107825ULL, 0x000fe200078e0006ULL, 0x00000053044c7217ULL, 0x000fe20003800000ULL,
0x0000000e12137981ULL, 0x0002a2000c1e9500ULL, 0x000000ff0c4e7207ULL, 0x000fc40000800000ULL,
0x000000ff4c4c7207ULL, 0x000fe20000000000ULL, 0x0000000e10487981ULL, 0x0002a4000c1e9500ULL,
0x00000001510d7824ULL, 0x000fe200078e024eULL, 0x000000514c0f7211ULL, 0x000fc600078fe0ffULL,
0x000000020d0c7825ULL, 0x000fc800078e0006ULL, 0x000000020f0e7825ULL, 0x000fe400078e0006ULL,
0x0000000e0c0c7981ULL, 0x0002a4000c1e9500ULL, 0x000000014e117824ULL, 0x002fe400078e024fULL,
0x0000000e0e0f7981ULL, 0x0002a2000c1e9500ULL, 0x0000004f4c4f7211ULL, 0x000fe200078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0006ULL, 0x000000024f067825ULL, 0x000fe400078e0006ULL,
0x0000000e10107981ULL, 0x0002a8000c1e9500ULL, 0x0000000e064f7981ULL, 0x0002a2000c1e9500ULL,
0xfffffff03a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000000136737812ULL, 0x040fe400078efcffULL,
0x00000008366f7812ULL, 0x000fe200078efcffULL, 0x00000001383a7824ULL, 0x000fe200078e023aULL,
0x0000000936697812ULL, 0x000fe200078efcffULL, 0x00000001ff127424ULL, 0x000fe200078e00ffULL,
0x0000000a737b7c10ULL, 0x000fc4000fffe0ffULL, 0x0000000a6f797c10ULL, 0x000fe4000fffe0ffULL,
0x0000000a69757c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff040507812ULL, 0x000fe200078ec0ffULL,
0x0000000137407824ULL, 0x100fe200078e0a3aULL, 0xfffffff04a527812ULL, 0x000fe200078ec0ffULL,
0x000000017b4a7824ULL, 0x100fe200078e0a3aULL, 0xfffffff04c5a7812ULL, 0x000fe200078ec0ffULL,
0x00000001794c7824ULL, 0x100fe400078e0a3aULL, 0x00000001754e7824ULL, 0x000fe200078e0a3aULL,
0x00000040123a7219ULL, 0x000fc400000006ffULL, 0x0000004a12407219ULL, 0x000fe400000006ffULL,
0x0000001836597812ULL, 0x000fe400078efcffULL, 0x0000004c124a7219ULL, 0x040fe400000006ffULL,
0x0000004e124c7219ULL, 0x000fe200000006ffULL, 0x0000000138507824ULL, 0x000fe200078e0250ULL,
0x0000000a59657c10ULL, 0x000fc6000fffe0ffULL, 0x000000013d5c7824ULL, 0x100fe400078e0a50ULL,
0x0000000165667824ULL, 0x000fe200078e0a50ULL, 0x00000011365b7812ULL, 0x040fe400078efcffULL,
0x0000001936577812ULL, 0x000fe400078efcffULL, 0x0000005c125c7219ULL, 0x040fe400000006ffULL,
0x0000006612667219ULL, 0x000fe200000006ffULL, 0x0000000138527824ULL, 0x000fe200078e0252ULL,
0x0000000a5b677c10ULL, 0x000fc4000fffe0ffULL, 0x0000000a575d7c10ULL, 0x000fe2000fffe0ffULL,
0x00000001456a7824ULL, 0x000fe400078e0a52ULL, 0x0000000167647824ULL, 0x100fe400078e0a50ULL,
0x000000015d687824ULL, 0x000fe200078e0a50ULL, 0x0000002136557812ULL, 0x040fe400078efcffULL,
0x0000002836537812ULL, 0x040fe400078efcffULL, 0x0000002936517812ULL, 0x000fc400078efcffULL,
0x0000006412647219ULL, 0x040fe400000006ffULL, 0x0000006812687219ULL, 0x040fe400000006ffULL,
0x0000006a126a7219ULL, 0x000fe200000006ffULL, 0x00000001385a7824ULL, 0x000fe200078e025aULL,
0x0000000a550e7c10ULL, 0x002fe4000fffe0ffULL, 0x0000000a53067c10ULL, 0x000fe4000fffe0ffULL,
0x0000000a517d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000010e747824ULL, 0x000fc400078e0a52ULL,
0x0000000106707824ULL, 0x100fe400078e0a52ULL, 0x000000017d6e7824ULL, 0x000fe400078e0a52ULL,
0x000000014b587824ULL, 0x000fe200078e0a5aULL, 0x0000003136117812ULL, 0x040fe400078efcffULL,
0x00000038360d7812ULL, 0x040fe400078efcffULL, 0x0000003936077812ULL, 0x000fe400078efcffULL,
0x0000007412747219ULL, 0x000fc400000006ffULL, 0x0000007012707219ULL, 0x040fe400000006ffULL,
0x0000006e126e7219ULL, 0x040fe400000006ffULL, 0x0000005812587219ULL, 0x000fe400000006ffULL,
0x0000000a114e7c10ULL, 0x000fe4000fffe0ffULL, 0x0000000a0d507c10ULL, 0x000fe4000fffe0ffULL,
0x0000000a07527c10ULL, 0x000fe2000fffe0ffULL, 0x000000014e547824ULL, 0x000fc400078e0a5aULL,
0x0000000150567824ULL, 0x100fe400078e0a5aULL, 0x00000001525a7824ULL, 0x000fe200078e0a5aULL,
0x0000005412547219ULL, 0x040fe400000006ffULL, 0x0000005612567219ULL, 0x040fe400000006ffULL,
0x0000005a125a7219ULL, 0x000fe400000006ffULL, 0x000054103c397816ULL, 0x008fc80000000039ULL,
0x000000393aff7212ULL, 0x000fc8000780c0ffULL, 0x000000383700720cULL, 0x000fc800007a1470ULL,
0x000000383600720cULL, 0x000fc80002fa1070ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x000054103f3f7816ULL, 0x004fc8000000003eULL, 0x0000003f3aff7212ULL, 0x080fe4000784c0ffULL,
0x0000003f4aff7212ULL, 0x080fe400078cc0ffULL, 0x0000003f4cff7212ULL, 0x000fe400078ac0ffULL,
0x000000383700720cULL, 0x080fe40001741470ULL, 0x000000387900720cULL, 0x080fe400037c1470ULL,
0x000000387500720cULL, 0x000fc40002fa1470ULL, 0x000000383600720cULL, 0x080fe40001741070ULL,
0x000000386f00720cULL, 0x080fe400037c1070ULL, 0x000000386900720cULL, 0x000fe40002fa1070ULL,
0x0000541042417816ULL, 0x000fe40000000041ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fc40003000000ULL, 0xff8000001e1e7808ULL, 0x000fe40002800000ULL,
0x0000541049497816ULL, 0x000fe40000000044ULL, 0x0000003940ff7212ULL, 0x080fe4000782c0ffULL,
0x000000394aff7212ULL, 0x080fe4000786c0ffULL, 0x000000394cff7212ULL, 0x000fe4000788c0ffULL,
0x0000003f40ff7212ULL, 0x000fc4000780c0ffULL, 0x000000415cff7212ULL, 0x040fe4000784c0ffULL,
0x000000495cff7212ULL, 0x080fe400078cc0ffULL, 0x0000004966ff7212ULL, 0x000fe400078ac0ffULL,
0x000000387b00720cULL, 0x0c0fe40000f21470ULL, 0x000000387b00720cULL, 0x080fe40000701470ULL,
0x000000387900720cULL, 0x000fc40001f61470ULL, 0x000000387500720cULL, 0x080fe40002781470ULL,
0x000000383d00720cULL, 0x0c0fe40001741470ULL, 0x000000383d00720cULL, 0x080fe400037c1470ULL,
0x000000386500720cULL, 0x080fe40002fa1470ULL, 0x000000387300720cULL, 0x0c0fe40000f21070ULL,
0x000000387300720cULL, 0x000fc40000701070ULL, 0x000000386f00720cULL, 0x080fe40001f61070ULL,
0x000000386900720cULL, 0x080fe40002781070ULL, 0x000000383b00720cULL, 0x0c0fe40001741070ULL,
0x000000383b00720cULL, 0x080fe400037c1070ULL, 0x000000385900720cULL, 0x000fe40002fa1070ULL,
0x000054104d4d7816ULL, 0x000fc40000000046ULL, 0x0000541013137816ULL, 0x000fe40000000048ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff8000001d1d7808ULL, 0x000fc40001000000ULL, 0xff80000027277808ULL, 0x000fe40003000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x0000004164ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004166ff7212ULL, 0x080fe4000780c0ffULL, 0x0000004168ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004964ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004968ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004d6aff7212ULL, 0x040fe400078cc0ffULL, 0x000000136aff7212ULL, 0x000fe400078ac0ffULL,
0x000000386700720cULL, 0x0c0fe40000f21470ULL, 0x000000386700720cULL, 0x080fe40002781470ULL,
0x000000386500720cULL, 0x000fc40000701470ULL, 0x000000385d00720cULL, 0x0c0fe40001f61470ULL,
0x000000385d00720cULL, 0x080fe40001741470ULL, 0x000000384500720cULL, 0x0c0fe400037c1470ULL,
0x000000384500720cULL, 0x080fe40002fa1470ULL, 0x000000385b00720cULL, 0x0c0fe40000f21070ULL,
0x000000385b00720cULL, 0x000fc40002781070ULL, 0x000000385900720cULL, 0x080fe40000701070ULL,
0x000000385700720cULL, 0x0c0fe40001f61070ULL, 0x000000385700720cULL, 0x080fe40001741070ULL,
0x000000384300720cULL, 0x0c0fe400037c1070ULL, 0x000000384300720cULL, 0x000fe40002fa1070ULL,
0x000054100f0f7816ULL, 0x000fc4000000000cULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fc40003000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000004d74ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d70ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004d6eff7212ULL, 0x000fe4000780c0ffULL, 0x0000001374ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001370ff7212ULL, 0x000fc4000784c0ffULL, 0x000000136eff7212ULL, 0x000fe400078cc0ffULL,
0x0000000f58ff7212ULL, 0x000fe400078ac0ffULL, 0x000000380e00720cULL, 0x0c0fe40000f21470ULL,
0x000000380e00720cULL, 0x080fe40001f61470ULL, 0x000000380600720cULL, 0x0c0fe40002781470ULL,
0x000000380600720cULL, 0x000fc40001741470ULL, 0x000000387d00720cULL, 0x0c0fe40000701470ULL,
0x000000387d00720cULL, 0x080fe400037c1470ULL, 0x000000384b00720cULL, 0x080fe40002fa1470ULL,
0x000000385500720cULL, 0x0c0fe40000f21070ULL, 0x000000385500720cULL, 0x080fe40001f61070ULL,
0x000000385300720cULL, 0x000fc40002781070ULL, 0x000000385300720cULL, 0x080fe40001741070ULL,
0x000000385100720cULL, 0x0c0fe40000701070ULL, 0x000000385100720cULL, 0x080fe400037c1070ULL,
0x000000384700720cULL, 0x000fe40002fa1070ULL, 0x000054104f4f7816ULL, 0x000fe40000000010ULL,
0xff8000002e2e7808ULL, 0x000fc40000800000ULL, 0xff80000015157808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff8000001c1c7808ULL, 0x000fe40003000000ULL,
0xff80000031317808ULL, 0x000fc40002800000ULL, 0x0000000f54ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000f56ff7212ULL, 0x080fe4000786c0ffULL, 0x0000000f5aff7212ULL, 0x000fe4000788c0ffULL,
0x0000004f58ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004f54ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004f56ff7212ULL, 0x000fc400078cc0ffULL, 0x0000004f5aff7212ULL, 0x000fe400078ac0ffULL,
0x000000384b00720cULL, 0x080fe40001741470ULL, 0x000000384e00720cULL, 0x0c0fe40000f21470ULL,
0x000000384e00720cULL, 0x080fe40000701470ULL, 0x000000385000720cULL, 0x0c0fe40001f61470ULL,
0x000000385000720cULL, 0x000fc400037c1470ULL, 0x000000385200720cULL, 0x0c0fe40002781470ULL,
0x000000385200720cULL, 0x080fe40002fa1470ULL, 0x000000384700720cULL, 0x080fe40001741070ULL,
0x000000381100720cULL, 0x0c0fe40000f21070ULL, 0x000000381100720cULL, 0x080fe40000701070ULL,
0x000000380d00720cULL, 0x000fc40001f61070ULL, 0x000000380d00720cULL, 0x080fe400037c1070ULL,
0x000000380700720cULL, 0x0c0fe40002781070ULL, 0x000000380700720cULL, 0x000fe40002fa1070ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fc40002000000ULL, 0xff80000017177808ULL, 0x000fe40001000000ULL,
0xff80000018187808ULL, 0x000fe40000000000ULL, 0xff80000019197808ULL, 0x000fe40003000000ULL,
0xff8000001a1a7808ULL, 0x000fc40002800000ULL, 0x000000250800720bULL, 0x004fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000000825087208ULL, 0x000fc40004000000ULL,
0x0000000924097208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x000000220900720bULL, 0x000fe40003f3e000ULL, 0x0000000823087208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x000000210800720bULL, 0x000fc40003f1e000ULL,
0x000000200900720bULL, 0x000fe40003f3e000ULL, 0x0000000821087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x000000081f087208ULL, 0x000fc40004000000ULL,
0x000000091e067208ULL, 0x000fe40004800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x000000270600720bULL, 0x000fe40003f3e000ULL, 0x000000081d077208ULL, 0x000fe40004000000ULL,
0x0000000627097208ULL, 0x000fe40004800000ULL, 0x0000002c0700720bULL, 0x000fc40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x000000072c067208ULL, 0x000fe40004000000ULL,
0x0000000926097208ULL, 0x000fe40004800000ULL, 0x0000002d0600720bULL, 0x000fe40003f1e000ULL,
0x000000280900720bULL, 0x000fe40003f3e000ULL, 0x000000062d067208ULL, 0x000fc40004000000ULL,
0x0000000928097208ULL, 0x000fe40004800000ULL, 0x000000350600720bULL, 0x000fe40003f1e000ULL,
0x000000340900720bULL, 0x000fe40003f3e000ULL, 0x0000000635067208ULL, 0x000fe40004000000ULL,
0x0000000934087208ULL, 0x000fe40004800000ULL, 0x000000330600720bULL, 0x000fc40003f1e000ULL,
0x000000290800720bULL, 0x000fe40003f3e000ULL, 0x0000000633077208ULL, 0x000fe40004000000ULL,
0x0000000829087208ULL, 0x000fe40004800000ULL, 0x0000002e0700720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x000000072e067208ULL, 0x000fc40004000000ULL,
0x0000000815077208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe40003f1e000ULL,
0x000000160700720bULL, 0x000fe40003f3e000ULL, 0x000000062f097208ULL, 0x000fe40004000000ULL,
0x0000000716077208ULL, 0x000fe40004800000ULL, 0x000000320900720bULL, 0x000fc40003f1e000ULL,
0x0000001c0700720bULL, 0x000fe40003f3e000ULL, 0x0000000932067208ULL, 0x000fe40004000000ULL,
0x000000071c087208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x000000170800720bULL, 0x000fe40003f3e000ULL, 0x0000000631077208ULL, 0x000fc40004000000ULL,
0x0000000817097208ULL, 0x000fe40004800000ULL, 0x000000300700720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x0000000730077208ULL, 0x000fe40004000000ULL,
0x0000000918067208ULL, 0x000fe40004800000ULL, 0x0000002a0700720bULL, 0x000fc40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x000000072a087208ULL, 0x000fe40004000000ULL,
0x0000000619077208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0700720bULL, 0x000fe40003f3e000ULL, 0x000000082b0e7208ULL, 0x000fc40004000000ULL,
0x000000071a107208ULL, 0x000fe20004800000ULL, 0x000016c27f007947ULL, 0x000fec000b800000ULL,
0x0c401f000e067f89ULL, 0x0004e400000e0000ULL, 0x000000060e00720bULL, 0x008fc80003f1e000ULL,
0x0000000e06127208ULL, 0x000fe20004000000ULL, 0x000016f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0010067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000e6800000e0000ULL,
0x0c401f000b087f89ULL, 0x000ea800000e0000ULL, 0x0c201f0012097f89ULL, 0x000ea200000e0000ULL,
0x000000061000720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x002fe40003f3e000ULL,
0x00000010060c7208ULL, 0x000fe40004000000ULL, 0x0000000a070d7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x004fe20003f1e000ULL, 0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL,
0x0000000b08067208ULL, 0x000fe20004000000ULL, 0x0c201f000d0e7f89ULL, 0x000ea200000e0000ULL,
0x000000091200720bULL, 0x000fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0006e200000e0000ULL,
0x0000001209087208ULL, 0x000fe40004000000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000e0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c0f097208ULL, 0x000fe40004800000ULL,
0x0000000d0e0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0001100012047891ULL, 0x000fe2000f8e583fULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080cULL,
0x000000070600720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001080cULL,
0x0000001f00107308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080cULL, 0x00000025000d7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b091f7820ULL, 0x004fe40000410000ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL,
0x00000023000e7308ULL, 0x002e620000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe4000001081fULL, 0x3fb8aa3b2a257823ULL, 0x108fe4000001080cULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33337823ULL, 0x000fc4000001080cULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080cULL,
0x00000022000f7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b310b7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b2b2a7823ULL, 0x000fe4000001080cULL, 0x3fb8aa3b28137823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b292b7823ULL, 0x100fe2000001081fULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x3c003c00ff287424ULL, 0x000fe400078e00ffULL, 0x3c003c00ff297424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081fULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b34347823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081fULL, 0x0000001e00117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b18187823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe2000001081fULL,
0x0000002c00127308ULL, 0x0003f00000000800ULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b302c7823ULL, 0x002fe2000001080cULL, 0x0000000d0e0c723eULL, 0x000fc400000000ffULL,
0x000000240f0d723eULL, 0x004fe400000000ffULL, 0x00000021100e723eULL, 0x008fe400000000ffULL,
0x00000020110f723eULL, 0x000fe200000000ffULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x00000002ff307819ULL, 0x000fca0000011600ULL, 0x000000280c20723cULL, 0x000f6200000018ffULL,
0x0000001d1210723eULL, 0x000fe200000000ffULL, 0x0000003500367308ULL, 0x000e700000000800ULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x0000002d3612723eULL, 0x002fe200000000ffULL, 0x00000008302d7824ULL, 0x000fcc00078e00ffULL,
0x0000001300137308ULL, 0x000ff00000000800ULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x000000272611723eULL, 0x004fe200000000ffULL, 0x0000000830277824ULL, 0x040fe200078e00ffULL,
0x0000000430267810ULL, 0x000fca0007ffe0ffULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x000000133413723eULL, 0x002fce00000000ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000281020723cULL, 0x020f6e0000001820ULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e700000000800ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000001500247308ULL, 0x0004e20000000800ULL, 0x0000002f321e723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x0000000130157810ULL, 0x004fce0007ffe0ffULL,
0x0000001c00317308ULL, 0x0002a20000000800ULL, 0x0000002b241d723eULL, 0x008fe200000000ffULL,
0x00000008302b7824ULL, 0x040fe200078e00ffULL, 0x0000000330247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000332e1c723eULL, 0x002fe200000000ffULL, 0x00000008302e7824ULL, 0x000fe200078e00ffULL,
0x000000042d2d7c11ULL, 0x000fc8000f8e20ffULL, 0xfffffff82e157812ULL, 0x000fe200078ee215ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x00000016311f723eULL, 0x004fe400000000ffULL,
0xfffffff8272e7812ULL, 0x000fe400078ee226ULL, 0x0000000230167810ULL, 0x000fe40007ffe0ffULL,
0x0000000415157c11ULL, 0x000fe2000f8e20ffULL, 0x000000281c20723cULL, 0x020f620000001820ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee216ULL,
0x0000000c1b167812ULL, 0x000fe400078ec0ffULL, 0xffffffff301b7810ULL, 0x000fe40007ffe0ffULL,
0x000000252a26723eULL, 0x002fe200000000ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x00000008302a7824ULL, 0x000fe200078e00ffULL, 0x000000042b2b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000116157824ULL, 0x040fe400078e0215ULL, 0x00000001162d7824ULL, 0x000fe200078e022dULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee21bULL, 0x00000001162b7824ULL, 0x000fe200078e022bULL,
0x0000001700177308ULL, 0x000ff00000000800ULL, 0x0000001800187308ULL, 0x000ea20000000800ULL,
0x0000000b2c24723eULL, 0x002fe200000000ffULL, 0x00000008300b7824ULL, 0x040fe200078e00ffULL,
0x00000008302c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee230ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x000000082c2f7824ULL, 0x000fe400078e00ffULL,
0x000000040b0b7c11ULL, 0x000fc6000f8e20ffULL, 0xfffffff82f2c7812ULL, 0x000fe400078ee22cULL,
0x0000001a001a7308ULL, 0x000e620000000800ULL, 0x000000171825723eULL, 0x004fe200000000ffULL,
0x0000000830187824ULL, 0x040fe200078e00ffULL, 0x0000000530177810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fc600078e0216ULL, 0xfffffff818187812ULL, 0x000fe400078ee217ULL,
0x000000042e177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c0b007388ULL, 0x0005e80000000800ULL,
0x0000000116177824ULL, 0x000fe200078e0217ULL, 0x0000000e15007388ULL, 0x0007e20000000800ULL,
0x000000191a27723eULL, 0x002fe200000000ffULL, 0x00000008301a7824ULL, 0x040fe200078e00ffULL,
0x0000000630197810ULL, 0x000fe20007ffe0ffULL, 0x000000102b007388ULL, 0x0007e20000000800ULL,
0x000000042c0b7c11ULL, 0x004fc4000f8e20ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL,
0x000000282420723cULL, 0x020f620000001820ULL, 0x0000000418197c11ULL, 0x000fe2000f8e20ffULL,
0x000000122d007388ULL, 0x0007e20000000800ULL, 0x000000041a1b7c11ULL, 0x000fc6000f8e20ffULL,
0x0000000116197824ULL, 0x040fe200078e0219ULL, 0x0000001c17007388ULL, 0x0007e20000000800ULL,
0x00000001161b7824ULL, 0x000fc600078e021bULL, 0x0000001e19007388ULL, 0x0007e80000000800ULL,
0x000000241b007388ULL, 0x0007ea0000000800ULL, 0x000000042a217c11ULL, 0x020fca000f8e20ffULL,
0x0000000116217824ULL, 0x040fe400078e0221ULL, 0x0000000116167824ULL, 0x000fe200078e020bULL,
0x00000006070b7208ULL, 0x000fe20004800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0020ULL,
0x0000002621007388ULL, 0x0007e20000000800ULL, 0x000000ffff077224ULL, 0x000fc600078e0022ULL,
0x0000000d16007388ULL, 0x0007e80000000800ULL, 0x0004000f15007388ULL, 0x0007e80000000800ULL,
0x000400112b007388ULL, 0x0007e80000000800ULL, 0x000400132d007388ULL, 0x0007e80000000800ULL,
0x0004001d17007388ULL, 0x0007e80000000800ULL, 0x0004001f19007388ULL, 0x0007e80000000800ULL,
0x000400251b007388ULL, 0x0007e80000000800ULL, 0x0004002721007388ULL, 0x0007e80000000800ULL,
0x0170000814008388ULL, 0x0007e80000000c00ULL, 0x0172000614008388ULL, 0x0007e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080071ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000103037810ULL, 0x000fe20007ffe0ffULL,
0x0000180071ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff077224ULL, 0x008fc400078e005fULL,
0x000000720300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa96000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff137807ULL, 0x004fe20004000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x000147c000347802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x018fea0003c00000ULL,
0xfffee37000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x000fe20005000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001481000347802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0013ULL,
0xfffee3b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000cULL,
0x0001488000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000e2000007944ULL, 0x018fea0003c00000ULL,
0xfffee47000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000cULL,
0x000148e000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000dc000007944ULL, 0x01afea0003c00000ULL,
0xfffee57000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000aULL,
0x0001495000357802ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000d5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0013ULL,
0xfffee99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000aULL,
0x000149c000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0013ULL, 0xfffee95000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x004fe20004000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00014a2000347802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x018fea0003c00000ULL,
0xffff0a1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x000fe20005000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00014a7000347802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0013ULL,
0xffff0a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e003dULL,
0x00014ae000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x018fea0003c00000ULL,
0xffff0b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e003dULL,
0x00014b4000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x01afea0003c00000ULL,
0xffff0c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0005ULL,
0x00014bb000357802ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe400078e0038ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0013ULL,
0xffff104000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0005ULL,
0x00014c2000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000a8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0013ULL, 0xffff100000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x004fe20004000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00014c8000347802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x018fea0003c00000ULL,
0xffff2e6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x000fe20005000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00014cd000347802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0013ULL,
0xffff2eb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0039ULL,
0x00014d4000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0xffff2f8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0039ULL,
0x00014da000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000090000007944ULL, 0x01afea0003c00000ULL,
0xffff308000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000fULL,
0x00014e1000357802ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe400078e0030ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0013ULL,
0xffff34a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e000fULL,
0x00014e8000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0013ULL, 0xffff346000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x004fe20004000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00014ee000347802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x018fea0003c00000ULL,
0xffff530000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x000fe20005000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00014f3000347802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0013ULL,
0xffff535000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e002fULL,
0x00014fa000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000070000007944ULL, 0x018fea0003c00000ULL,
0xffff542000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e002fULL,
0x0001500000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x01afea0003c00000ULL,
0xffff552000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0004ULL,
0x0001507000357802ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0013ULL,
0xffff594000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0004ULL,
0x000150e000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0013ULL, 0xffff590000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x00015150000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0xffffe8e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x006fe200078e0010ULL,
0x000151d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x010fea0003c00000ULL, 0x000000071000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x00015250000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001007107208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000bULL, 0x000152d0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000070b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0012ULL, 0x00015350000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000b07067208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000071200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0010ULL, 0x000153d0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001207087208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000071000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e000aULL, 0x00015450000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001007097208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e0006ULL, 0x000154d0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe6d000007947ULL, 0x000fea000383ffffULL,
0x0180000010007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001000008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff10ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000010027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001000007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffea9a002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e077389ULL, 0x0002a200000e0007ULL, 0xfffea9600c007950ULL, 0x000fea0003c3ffffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0000001334137389ULL, 0x0002a400000e0037ULL,
0x000000ffff347224ULL, 0x002fc400078e0035ULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffea91034007950ULL, 0x000fea0003c3ffffULL, 0x000000011300780cULL, 0x000fe20003f45070ULL,
0x0000003500007348ULL, 0x000fd80003800000ULL, 0x0000000000137806ULL, 0x000fc800050e0100ULL,
0x0000003513137212ULL, 0x000fe200078ec0ffULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffea8b034007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003a0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d90ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e50ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001620ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001630ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016c0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016c4ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000015800ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017100ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017150ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000174d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015a40ULL, 0x0000000000015a40ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000174d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin_len = 95664;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
