/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011578ULL, 0x00000000000110f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x000000000000fda0ULL, 0x0000000000000260ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000010000ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000fda000000000ULL, 0x0000a40400000000ULL, 0x0400288080810c00ULL, 0x0000000000003eb8ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0000fda000000000ULL,
0x0000026000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x000812040000007fULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000eee000103104ULL, 0x0000ef000000eef0ULL, 0x00e429040000ef10ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500002a05000025ULL, 0x050000250500002aULL, 0x0500002505000025ULL, 0x0500003f0500003fULL,
0x0500003f0500003fULL, 0x0500003f0500003fULL, 0x0500003f0500003fULL, 0x0500003f0500003fULL,
0x00e428040500003fULL, 0x00000140000000e0ULL, 0x00001c6000001bc0ULL, 0x00001ce000001cc0ULL,
0x0000224000002210ULL, 0x0000369000003610ULL, 0x0000374000003700ULL, 0x00003a8000003a70ULL,
0x00004eb000004e30ULL, 0x00004f6000004f20ULL, 0x000052b0000052a0ULL, 0x00006640000065c0ULL,
0x000066f0000066b0ULL, 0x00006f6000006f30ULL, 0x00007a4000007a30ULL, 0x00009e9000009e60ULL,
0x0000a4d00000a4a0ULL, 0x0000e8100000e800ULL, 0x0000e8300000e820ULL, 0x0000e8800000e860ULL,
0x0000e8b00000e8a0ULL, 0x0000eef00000eed0ULL, 0x0000ef400000ef00ULL, 0x0000ef600000ef50ULL,
0x0000f9400000f8b0ULL, 0x0000fa000000f9a0ULL, 0x0000fad00000fa70ULL, 0x0000fb900000fb30ULL,
0x0000fcc00000fc20ULL, 0x04b039040000fd60ULL, 0x000000ff000002e0ULL, 0x000401000000f600ULL,
0x0000000a000003c0ULL, 0x003f01000000f608ULL, 0x0000000a000004d0ULL, 0x003f01000000f688ULL,
0x00000006000005f0ULL, 0x003f01000000f6a8ULL, 0x0000000300000700ULL, 0x003f01000000f6c8ULL,
0x00000002000008c0ULL, 0x003f01070000f600ULL, 0x0000000600000a90ULL, 0x003f01010000f688ULL,
0x000000ff000010b0ULL, 0x0006010700000000ULL, 0x000000ff00001100ULL, 0x0006010100000000ULL,
0x0000001a00001180ULL, 0x003f010100000020ULL, 0x0000005200001360ULL, 0x003f010500000000ULL,
0x00000054000015a0ULL, 0x003f01090000f6c8ULL, 0x000000ff000019a0ULL, 0x0006010700000000ULL,
0x000000ff00001a00ULL, 0x0006010100000000ULL, 0x0000003900001a40ULL, 0x003f010500000000ULL,
0x0000006200001a80ULL, 0x003f01010000f608ULL, 0x0000006200001a90ULL, 0x003f01090000f608ULL,
0x0000003900001f80ULL, 0x003f010900000000ULL, 0x0000004400003030ULL, 0x003f01010000f6c8ULL,
0x0000004600003050ULL, 0x003f01010000f688ULL, 0x0000005200003080ULL, 0x003f010500000000ULL,
0x0000005400003120ULL, 0x003f01090000f6c8ULL, 0x000000ff000034f0ULL, 0x0006010700000000ULL,
0x000000ff00003520ULL, 0x0006010100000000ULL, 0x0000005700003550ULL, 0x003f010500000000ULL,
0x0000006000003560ULL, 0x003f01010000f628ULL, 0x0000006200003570ULL, 0x003f01090000f628ULL,
0x00000011000039e0ULL, 0x003f01090000f6a8ULL, 0x00000044000048a0ULL, 0x003f01010000f6c8ULL,
0x00000046000048c0ULL, 0x003f01010000f690ULL, 0x00000052000048f0ULL, 0x003f010500000000ULL,
0x00000011000049f0ULL, 0x003f01090000f6a8ULL, 0x000000ff00004d10ULL, 0x0007010700000000ULL,
0x000000ff00004d50ULL, 0x0007010100000000ULL, 0x0000006100004d80ULL, 0x003f010500000000ULL,
0x0000006200004d90ULL, 0x003f01010000f648ULL, 0x0000006200004da0ULL, 0x003f01090000f648ULL,
0x00000011000051f0ULL, 0x003f01090000f6a8ULL, 0x0000004400006100ULL, 0x003f01010000f6c8ULL,
0x0000004600006110ULL, 0x003f01010000f698ULL, 0x0000005200006140ULL, 0x003f010500000000ULL,
0x0000005400006200ULL, 0x003f01090000f6c8ULL, 0x000000ff000064e0ULL, 0x0006010700000000ULL,
0x0000005a00006510ULL, 0x003f010100000000ULL, 0x0000005700006540ULL, 0x003f010500000000ULL,
0x0000006000006550ULL, 0x003f01010000f668ULL, 0x0000006000006560ULL, 0x003f01090000f668ULL,
0x0000004b00006980ULL, 0x003f01090000f6a8ULL, 0x00000044000077d0ULL, 0x003f01010000f6c8ULL,
0x0000004600007800ULL, 0x003f01010000f6a0ULL, 0x000000020000ad90ULL, 0x003f01010000f600ULL,
0x000000020000bc70ULL, 0x003f01090000f600ULL, 0x000000020000be20ULL, 0x003f01010000f600ULL,
0x000000020000be30ULL, 0x003f01090000f600ULL, 0x0000000a0000df50ULL, 0x003f01010000f688ULL,
0x0000000a0000e0d0ULL, 0x003f01090000f688ULL, 0x0000000b0000f250ULL, 0x003f01010000f608ULL,
0x0000000b0000f260ULL, 0x003f01010000f610ULL, 0x0000000b0000f270ULL, 0x003f01010000f618ULL,
0x0000000b0000f280ULL, 0x003f01010000f620ULL, 0x000000540000f2b0ULL, 0x003f01090000f6c8ULL,
0x000000620000f310ULL, 0x003f01090000f608ULL, 0x000000390000f370ULL, 0x003f010900000000ULL,
0x000000540000f3d0ULL, 0x003f01090000f6c8ULL, 0x000000620000f430ULL, 0x003f01090000f628ULL,
0x000000110000f490ULL, 0x003f01090000f6a8ULL, 0x000000110000f4f0ULL, 0x003f01090000f6a8ULL,
0x000000620000f550ULL, 0x003f01090000f648ULL, 0x000000110000f5b0ULL, 0x003f01090000f6a8ULL,
0x000000540000f610ULL, 0x003f01090000f6c8ULL, 0x000000600000f670ULL, 0x003f01090000f668ULL,
0x0000004b0000f6d0ULL, 0x003f01090000f6a8ULL, 0x000000020000f730ULL, 0x003f01090000f600ULL,
0x000000020000f790ULL, 0x003f01090000f600ULL, 0x0000000a0000f7f0ULL, 0x003f01090000f688ULL,
0x00141c0400053803ULL, 0x0000ad400000aae0ULL, 0x0000bef00000be50ULL, 0x000c05040000f2a0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000000f00080a04ULL,
0x0004360400580210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x000000000000fda0ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000c7919ULL, 0x000eae0000002300ULL,
0x00008400ff237b82ULL, 0x000ee20000000800ULL, 0x0000040000027802ULL, 0x000fe20000000f00ULL,
0x000002e000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x00000000000f7919ULL, 0x000f280000002100ULL, 0x00000000000479c3ULL, 0x000f620000002500ULL,
0x00000000000b7919ULL, 0x000f620000008800ULL, 0x0000000000177919ULL, 0x000eec0000002600ULL,
0x00008800ff047b82ULL, 0x000ee20000000a00ULL, 0x00000000000d7919ULL, 0x000eee0000002700ULL,
0x00008e00ff087b82ULL, 0x000ee20000000a00ULL, 0x000000010c007824ULL, 0x004fc400078e0203ULL,
0x00001fff0c0c7589ULL, 0x000fe400000e0000ULL, 0x0000008000037824ULL, 0x110fe200078e020fULL,
0x00000005ff0f7819ULL, 0x000fe2000001160fULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000006540b027816ULL, 0x022fe40000000002ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x00001fff0f0f7589ULL, 0x000e6200000e0000ULL, 0x000000ff0300720cULL, 0x000fc40003f05270ULL,
0x0000000f0300780cULL, 0x040fe40003f24070ULL, 0x000000030300780cULL, 0x040fe40003f64070ULL,
0x000000010300780cULL, 0x000fc80003f44070ULL, 0x000000000007c919ULL, 0x000f220000008800ULL,
0x000004000006c802ULL, 0x000fe20000000f00ULL, 0xff317217ff13c424ULL, 0x000fe400078e00ffULL,
0x000000040c0a7824ULL, 0x002fe200078e020fULL, 0x00000004ff117819ULL, 0x004fc60000011600ULL,
0x000000020a0b7824ULL, 0x000fc800078e00ffULL, 0x000000010b127824ULL, 0x040fe200078e0211ULL,
0x000000080b107848ULL, 0x000fe40007fe0000ULL, 0x00000654070ec816ULL, 0x010fe20000000006ULL,
0x0000000817067824ULL, 0x008fe400078e00ffULL, 0x0000000823077824ULL, 0x000fc800078e00ffULL,
0x0000000d07077224ULL, 0x000fe400078e0206ULL, 0x000000040306c824ULL, 0x000fe400078e020eULL,
0x00000004ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x0000000107077824ULL, 0x000fe200078e0212ULL,
0x0000000000240947ULL, 0x000fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00f60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x00000004030a7c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000000a0612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x00000004030a7c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x000000000a0612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00f400130600c388ULL, 0x0007e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000403067c11ULL, 0x008fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000060612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f6a804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f6c804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x00000000020472caULL, 0x002fe200000e0000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000000712037812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe400078e0a0bULL, 0x0000010007047825ULL, 0x000fe200078e0004ULL,
0x000000f00a077812ULL, 0x000fe200078ec0ffULL, 0x00008200000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000f03037812ULL, 0x000fe400078e7800ULL, 0x000000101100720cULL, 0x000fc40003f06070ULL,
0x0000000704067210ULL, 0x008fe20007f3e0ffULL, 0x0000001012037824ULL, 0x000fe200078e0203ULL,
0x0000f60004047890ULL, 0x000fc6000fffe03fULL, 0x000000ffff077224ULL, 0x000fe400008e0605ULL,
0x0000001003037824ULL, 0x000fe400078e0202ULL, 0x000000040d047825ULL, 0x000fc600078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c4aULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000a04047981ULL, 0x000ea2000c1e1900ULL, 0x00000300ff037b82ULL, 0x002e620000000800ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x00000000040972caULL, 0x004fda00000e0000ULL,
0x0000007f09047890ULL, 0x000fe4000fffe03fULL, 0x000000ff09057890ULL, 0x000fe4000fffe03fULL,
0x000000073f047899ULL, 0x000fe40008011604ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x000000a000f08947ULL, 0x002ff60003800000ULL, 0x00000003ff047819ULL, 0x000fe2000001160fULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe20000011600ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x01ffffff046d7812ULL, 0x000fca00078ec0ffULL,
0x000000020e6d7824ULL, 0x000fca00078e026dULL, 0x000000046d007c0cULL, 0x000fda000bf06070ULL,
0x00009000ff058b82ULL, 0x000e620000000800ULL, 0x000000020d048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000504048224ULL, 0x002fe400078e0205ULL,
0x000000080f057824ULL, 0x000fe400078e00ffULL, 0x000000016d078824ULL, 0x000fe400078e0204ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x0000000407108825ULL, 0x004fc800078e0010ULL,
0x0000000102067824ULL, 0x000fc800078e0205ULL, 0x00f6880906ff79a7ULL, 0x0003e2000850003fULL,
0x0000000a10048981ULL, 0x0004e2000c1e1900ULL, 0x000000010f077812ULL, 0x000fe200078ec0ffULL,
0x0000000412167836ULL, 0x040fe20000000000ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000c121c7836ULL, 0x000fe20000000000ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000001007137824ULL, 0x000fe400078e00ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x002fe2000001160fULL, 0x0000000113157824ULL, 0x000fc400078e0216ULL,
0x00000001130c7824ULL, 0x000fe200078e0212ULL, 0x00000000090672caULL, 0x000fe200000e0000ULL,
0x0000000815187824ULL, 0x040fe200078e00ffULL, 0x00000000150b7212ULL, 0x080fe200078e3cffULL,
0x000000080e117824ULL, 0x004fe200078e0209ULL, 0x000000000c087212ULL, 0x040fe200078e3cffULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x00000020110b7824ULL, 0x000fe400078e00ffULL, 0x000000010e067836ULL, 0x000fe20000000000ULL,
0xfffffff819107812ULL, 0x000fe200078ee208ULL, 0x0000000812197836ULL, 0x000fe20000000000ULL,
0x000000090b087c48ULL, 0x000fe2000ffe0000ULL, 0x00000001131e7824ULL, 0x000fe200078e021cULL,
0x0000000506007c0cULL, 0x000fe2000bf06070ULL, 0x0000008017067824ULL, 0x000fc400078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0bULL, 0x000000001e1f7212ULL, 0x080fe200078e3cffULL,
0x00000001131a7824ULL, 0x000fe200078e0219ULL, 0x00000060060b7812ULL, 0x000fe200078ef80bULL,
0x0000200009147824ULL, 0x000fe200078e0202ULL, 0x0000002008087807ULL, 0x000fe20000000000ULL,
0x000000081a207824ULL, 0x040fe200078e00ffULL, 0x000000001a1b7212ULL, 0x000fe200078e3cffULL,
0x000000010b117824ULL, 0x040fe200078e020cULL, 0x00000013080c7248ULL, 0x000fe20007fe0000ULL,
0x000000010b217824ULL, 0x000fc400078e021eULL, 0x000000010b177824ULL, 0x040fe400078e0215ULL,
0x000000010b1d7824ULL, 0x000fe200078e021aULL, 0xfffffff8201a7812ULL, 0x000fe200078ee21bULL,
0x000000081e1e7824ULL, 0x000fe400078e00ffULL, 0x0000b000140b7836ULL, 0x000fe40000000000ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a13ULL, 0xfffffff81e147812ULL, 0x000fe200078ee21fULL,
0x0000001010157824ULL, 0x000fc400078e020bULL, 0x00000010181b7824ULL, 0x100fe200078e020bULL,
0x0000000c1200720cULL, 0x080fe20003f26070ULL, 0x000000101a1f7824ULL, 0x000fe200078e020bULL,
0x0000000c1900720cULL, 0x080fe20003f66070ULL, 0x0000f6a8021a7836ULL, 0x000fe20000000000ULL,
0x000000700a197812ULL, 0x000fe400078ec0ffULL, 0x0000000c1600720cULL, 0x000fe40003f46070ULL,
0x000000001a0772caULL, 0x000fe200000e0000ULL, 0x00000008091a7824ULL, 0x000fd800078e021aULL,
0x0000000706067291ULL, 0x000fe2000f8e203fULL, 0x0000002304087224ULL, 0x008fe400078e02ffULL,
0x0000001014237824ULL, 0x000fe400078e020bULL, 0x0000008008087824ULL, 0x000fca00078e00ffULL,
0x0000001108117210ULL, 0x000fe40007f1e0ffULL, 0x0000001708177210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000c11187c11ULL, 0x040fe2000f8038ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000001d081d7210ULL, 0x000fe40007f9e0ffULL,
0x0000000d110b7c11ULL, 0x000fe400080f3c10ULL, 0x0000000c17107c11ULL, 0x000fe2000f8038ffULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0x0000002108087210ULL, 0x000fe40007fbe0ffULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000d17137c11ULL, 0x000fe400080f3c12ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x00000018190a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000000c1d127c11ULL, 0x000fe4000f8838ffULL,
0x0000000c08187c11ULL, 0x000fe2000f8a38ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000c1c00720cULL, 0x000fc40003f06070ULL, 0x0000001910107210ULL, 0x000fe40007fde0ffULL,
0x0000000d1d0c7c11ULL, 0x000fe2000a0f3c14ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000c901c4aULL, 0x0000000d08087c11ULL, 0x000fe2000a8f3c11ULL,
0x000000ffff117224ULL, 0x000fe200030e0613ULL, 0x0000001912127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000001918187210ULL, 0x000fe40007fbe0ffULL,
0x00000000101b7faeULL, 0x000fe2000d101c4aULL, 0x000000ffff137224ULL, 0x000fe200020e060cULL,
0x000000050e007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff197224ULL, 0x000fc400028e0608ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x00000000121f7faeULL, 0x0005e2000d901c4aULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x002fe4000001ff00ULL,
0x0000000018237faeULL, 0x0003e2000c101c4aULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x00000000001e7805ULL, 0x004fe4000001ff00ULL,
0x0000000000227805ULL, 0x002fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000035ff7679a7ULL, 0x000ea20008500006ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000020351a3479a7ULL, 0x0002e2000850003fULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x002fe2000001ff00ULL, 0x0000006400ac1947ULL, 0x000fec0003800000ULL,
0x00009000ff0a7b82ULL, 0x000e620000000800ULL, 0x000000020d0b7824ULL, 0x000fe400078e00ffULL,
0xff317217ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff737224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fe400078e00ffULL, 0x0000000a0b0b7224ULL, 0x002fce00078e020aULL,
0x000001000e567824ULL, 0x000fca00078e00ffULL, 0x0000000956007c0cULL, 0x000fda000bf06070ULL,
0x00000064007c0947ULL, 0x000fea0003800000ULL, 0x000000040f387824ULL, 0x000fe200078e00ffULL,
0x000000016d107812ULL, 0x000fe200078ec0ffULL, 0x000000010e0d7836ULL, 0x000fe20000000000ULL,
0x00008400000c7ab9ULL, 0x000fe20000000800ULL, 0x000000100f507824ULL, 0x000fe200078e00ffULL,
0xfffffff838097812ULL, 0x000fe200078ec0ffULL, 0x00000008733a7824ULL, 0x000fe200078e00ffULL,
0x000000050d007c0cULL, 0x000fe4000bf06070ULL, 0x000000011000780cULL, 0x000fe20003f65070ULL,
0x0000000102547824ULL, 0x000fe200078e0209ULL, 0x00000001ff097819ULL, 0x000fe2000001160fULL,
0x0000000c04107c24ULL, 0x000fe2000f8e02ffULL, 0x00000003ff4a7819ULL, 0x000fe20000011600ULL,
0x0000f6c854527836ULL, 0x000fe20000000000ULL, 0x0000001050507812ULL, 0x000fe200078ec0ffULL,
0x0000002009687824ULL, 0x000fe200078e0256ULL, 0x000000083a117812ULL, 0x000fe200078e0cffULL,
0x00000035520075a7ULL, 0x008e6200080c007fULL, 0x000000044a487836ULL, 0x000fe20000000000ULL,
0xffffffff03637811ULL, 0x000fe200078e08ffULL, 0x00000040680d7836ULL, 0x000fe20000000000ULL,
0x00000000110672caULL, 0x000fe200000e0000ULL, 0x000000084a477836ULL, 0x000fc40000000000ULL,
0x0000000c4a457836ULL, 0x000fe20000000000ULL, 0x000000090d047c48ULL, 0x000fe2000ffe0000ULL,
0x0000008010397824ULL, 0x000fe400078e00ffULL, 0x000000014a537824ULL, 0x100fe400078e0250ULL,
0x0000000104107824ULL, 0x000fe200078e0a0dULL, 0x0000006006047812ULL, 0x000fe200078ef80dULL,
0x0000000148517824ULL, 0x100fe200078e0250ULL, 0x0000000053757212ULL, 0x000fe200078e3cffULL,
0x00000001474f7824ULL, 0x000fc400078e0250ULL, 0x00000001454d7824ULL, 0x000fe200078e0250ULL,
0x00000000515d7212ULL, 0x080fe200078e3cffULL, 0x00000001040d7824ULL, 0x040fe200078e0253ULL,
0x000000004f6f7212ULL, 0x080fe200078e3cffULL, 0x0000000104117824ULL, 0x040fe200078e0251ULL,
0x000000004d557212ULL, 0x000fe200078e3cffULL, 0x0000000104127824ULL, 0x040fe200078e024fULL,
0x0000000d390d7210ULL, 0x000fe20007f9e0ffULL, 0x0000000104047824ULL, 0x000fe200078e024dULL,
0x0000001139117210ULL, 0x000fe20007fbe0ffULL, 0x0000000851367824ULL, 0x000fe200078e00ffULL,
0x0000001239127210ULL, 0x000fe20007f5e0ffULL, 0x000000084f3c7824ULL, 0x000fe200078e00ffULL,
0x0000000439397210ULL, 0x000fe20007f3e0ffULL, 0x0000000853047824ULL, 0x000fe200078e00ffULL,
0xfffffff8365d7812ULL, 0x000fe200078ee25dULL, 0x000000084d3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c6f7812ULL, 0x000fc400078ee26fULL, 0xfffffff804757812ULL, 0x000fe400078ee275ULL,
0xfffffff83e557812ULL, 0x000fe200078ee255ULL, 0x0000000000086947ULL, 0x002fec0003800000ULL,
0x00f6c835540075a7ULL, 0x000e6400080c017fULL, 0x000000dc003ce947ULL, 0x002fea0003800000ULL,
0x00000001633e7807ULL, 0x000fe20005800000ULL, 0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000ffff3c7224ULL, 0x000fe200020e06ffULL, 0x0000000e0d347c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff6b7224ULL, 0x000fe200078e006dULL, 0x0000000e11367c11ULL, 0x000fe2000f8838ffULL,
0x000000016d6d7824ULL, 0x000fe200078e023eULL, 0x0000000f0d137c11ULL, 0x000fe200098f3c3cULL,
0x000000ffff047224ULL, 0x000fe200028e06ffULL, 0x00000020100d7807ULL, 0x000fe20000000000ULL,
0x0000001000497824ULL, 0x000fe200078e00ffULL, 0x000000046d007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff357224ULL, 0x000fe200010e06ffULL, 0x0000000f11377c11ULL, 0x000fe2000a0f3c04ULL,
0x0000100073047824ULL, 0x000fe200078e00ffULL, 0x000000500d0d7248ULL, 0x000fe20007fe0000ULL,
0x0000200009707824ULL, 0x000fe200078e0202ULL, 0x0000000e123c7c11ULL, 0x000fc4000f8438ffULL,
0x0000007049497812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a50ULL,
0x0000100004117812ULL, 0x000fe400078e0cffULL, 0x0000000f12357c11ULL, 0x000fe400090f3c35ULL,
0x0000004934127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000000e39047c11ULL, 0x000fe4000f8238ffULL, 0xfffffff0054b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000000d4a00720cULL, 0x000fc40003f46070ULL,
0x0000b000706e7810ULL, 0x000fe40007ffe011ULL, 0x00008c00ff10bb82ULL, 0x000e620000000a00ULL,
0x0000000f39397c11ULL, 0x000fe400088f3c34ULL, 0x0000f6a802617810ULL, 0x000fe20007ffe04bULL,
0x0000001075677824ULL, 0x100fe200078e026eULL, 0x0000000d4800720cULL, 0x080fe20003f26070ULL,
0x000000105d667824ULL, 0x100fe200078e026eULL, 0x0000004936367210ULL, 0x000fe20007f9e0ffULL,
0x000000106f657824ULL, 0x100fe200078e026eULL, 0x00000000610772caULL, 0x000fe200000e0000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012677faeULL, 0x0007e2000d101c4aULL,
0x0000000d4700720cULL, 0x080fe20003f46070ULL, 0x000000ffff377224ULL, 0x000fe200020e0637ULL,
0x0000000d4500720cULL, 0x000fe20003f86070ULL, 0x0000001055647824ULL, 0x000fe200078e026eULL,
0x000000493c347210ULL, 0x000fc40007fbe0ffULL, 0x0000003e0b0db210ULL, 0x000fe20007ffe06bULL,
0x0000000036667faeULL, 0x0009e2000c901c4aULL, 0xffffffe005577812ULL, 0x040fe200078ec0ffULL,
0x000000ffff357224ULL, 0x000fe200028e0635ULL, 0x0000000805607812ULL, 0x000fe200078ec0ffULL,
0x0000000607067290ULL, 0x000fe2000fffe03fULL, 0x0000004904127210ULL, 0x008fe20007f3e0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x0000000034657faeULL, 0x0007e2000d101c4aULL,
0x000000040d10b825ULL, 0x002fe200078e0010ULL, 0x00000010050d7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0639ULL, 0x0000000a1004b981ULL, 0x000762000c1e1900ULL,
0x000000020d377210ULL, 0x010fc60007ffe057ULL, 0x0000000012647faeULL, 0x0007e2000e101c4aULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x00000001ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000000137627824ULL, 0x000fe400078e0260ULL,
0x0000000161397824ULL, 0x000fe200078e023aULL, 0x0000000000007918ULL, 0x008fcc0000000000ULL,
0x0000000dff7879a7ULL, 0x0002620008500006ULL, 0x000000200f127824ULL, 0x000fe200078e00ffULL,
0x00000001ff4c7819ULL, 0x000fc80000011600ULL, 0xffffff8012137812ULL, 0x000fe200078ec0ffULL,
0x00000077390075a7ULL, 0x004262000802007fULL, 0x0000000c4c4c7812ULL, 0x000fc600078ec0ffULL,
0x00000001024e7824ULL, 0x000fca00078e0213ULL, 0x0000004e4c5f7210ULL, 0x000fe20007ffe049ULL,
0x00f6080d621079a7ULL, 0x000ea4000850003fULL, 0x00f60811620075a7ULL, 0x004ea4000804017fULL,
0x000000d80018a947ULL, 0x006fea0003800000ULL, 0x00f000005f117984ULL, 0x000e620000000800ULL,
0x000010000f3d7824ULL, 0x000fe200078e00ffULL, 0x0000000800137812ULL, 0x000fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fe200078e00ffULL, 0x00f200005f5f7984ULL, 0x000ea20000000800ULL,
0x0000000438357812ULL, 0x000fe400078ec0ffULL, 0xffffe0003d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000007135a7812ULL, 0x000fe400078ec800ULL, 0x0000003500357211ULL, 0x000fe200078fe0ffULL,
0x0000000102127824ULL, 0x000fe200078e023dULL, 0x00000007135c7812ULL, 0x000fc400078ef800ULL,
0x000000355a597212ULL, 0x000fe200078e3cffULL, 0x0000100073127824ULL, 0x000fc800078e0212ULL,
0x0000b00012377836ULL, 0x000fe40000000000ULL, 0x000000085c3f7824ULL, 0x000fc800078e0259ULL,
0x000000103f387824ULL, 0x000fe200078e0237ULL, 0x000000081100720bULL, 0x002fda0003f5d000ULL,
0x0000000000107806ULL, 0x000fc800010e0100ULL, 0x0000ffff10367812ULL, 0x000fda000784c0ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000081100720bULL, 0x000fe40003f54000ULL,
0x0000001108437209ULL, 0x000fe40007810000ULL, 0x00000002ff137819ULL, 0x000fc60000011600ULL,
0x8000004308107221ULL, 0x000fe20000010000ULL, 0x00000002ff087819ULL, 0x000fe2000001160fULL,
0x0000000813347836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b10127820ULL, 0x000fe40000410000ULL,
0x0000000000107806ULL, 0x000fe400010e0100ULL, 0x0000001200417308ULL, 0x000e620000000800ULL,
0x0000000f0800720cULL, 0x000fe40003f45270ULL, 0x0000ffff103b7812ULL, 0x000fc800078e3cffULL,
0x0000003b36ff7212ULL, 0x000fce000786c0ffULL, 0x000000800f08a824ULL, 0x000fe200078e0202ULL,
0x00001f3441347589ULL, 0x002e6200000e0000ULL, 0x000000410c0c7220ULL, 0x000fc60000410000ULL,
0x00001f1341137589ULL, 0x0004e200000e0000ULL, 0x8000004311113221ULL, 0x000fe20000010000ULL,
0x000000084c08a210ULL, 0x000fc60007ffe049ULL, 0x3fb8aa3b11113820ULL, 0x000fe40000410000ULL,
0x00f400430800a388ULL, 0x0009e40000000800ULL, 0x00000011000a3308ULL, 0x000ee20000000800ULL,
0x00000001ff417807ULL, 0x004fe20001800000ULL, 0x000000ffff087224ULL, 0x010fe400078e0043ULL,
0x0000003417177220ULL, 0x082fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003427277220ULL, 0x080fe20000410000ULL, 0x0000003426267220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342b2b7220ULL, 0x080fe20000410000ULL, 0x000000342a2a7220ULL, 0x000fe20000410000ULL,
0x0000001315157220ULL, 0x088fe20000410000ULL, 0x0000001314147220ULL, 0x080fe20000410000ULL,
0x0000001325257220ULL, 0x080fe20000410000ULL, 0x0000001324247220ULL, 0x080fe20000410000ULL,
0x0000001321217220ULL, 0x080fe20000410000ULL, 0x0000001320207220ULL, 0x080fe20000410000ULL,
0x000000131d1d7220ULL, 0x080fe20000410000ULL, 0x000000131c1c7220ULL, 0x080fe20000410000ULL,
0x0000001319197220ULL, 0x080fe20000410000ULL, 0x0000001318187220ULL, 0x080fe20000410000ULL,
0x0000001331317220ULL, 0x080fe20000410000ULL, 0x0000001330307220ULL, 0x080fe20000410000ULL,
0x000000132d2d7220ULL, 0x080fe20000410000ULL, 0x000000132c2c7220ULL, 0x080fe20000410000ULL,
0x0000001329297220ULL, 0x080fe20000410000ULL, 0x0000001328287220ULL, 0x000fe20000410000ULL,
0x0000000a5f5f3220ULL, 0x000fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x00000077390075a7ULL, 0x000e64000802017fULL, 0x000000d000f49947ULL, 0x002fea0003800000ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x000000020f447824ULL, 0x040fe200078e00ffULL,
0x0000000700697812ULL, 0x000fe200078ec0ffULL, 0x000002000f107824ULL, 0x000fe200078e00ffULL,
0x0000991041467816ULL, 0x000fe200000000ffULL, 0x0000000235357836ULL, 0x000fe20000000000ULL,
0x0000000444117812ULL, 0x000fe200078ec0ffULL, 0x0000000c5f0c7221ULL, 0x000fe20000010000ULL,
0x0000000869697812ULL, 0x000fe200078ef800ULL, 0x000000ffff767224ULL, 0x000fe200078e0078ULL,
0x0000001100587211ULL, 0x000fc400078fe0ffULL, 0xfffff80010117812ULL, 0x000fe400078ec0ffULL,
0x0000000758107812ULL, 0x000fe200078e7869ULL, 0x0000000258587836ULL, 0x000fe20000000000ULL,
0x000000ff4600720cULL, 0x000fe20003f25270ULL, 0x0000000102407824ULL, 0x000fe200078e0211ULL,
0x000000355a5a7212ULL, 0x000fe200078e3cffULL, 0x0000000869437824ULL, 0x000fe200078e0210ULL,
0x0000000758587812ULL, 0x000fc600078e7869ULL, 0x0000001043437824ULL, 0x000fe400078e0240ULL,
0x0000000869697824ULL, 0x000fc600078e0258ULL, 0x009000004310783bULL, 0x000fe20000000200ULL,
0x0000001069407824ULL, 0x000fe400078e0240ULL, 0x0000010038427824ULL, 0x042fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe20000011438ULL, 0x0001000038417824ULL, 0x040fe200078e00ffULL,
0x0000888038347816ULL, 0x000fe200000000ffULL, 0x00000100396a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011442ULL, 0x00000002ff427819ULL, 0x000fe20000011600ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000000aff38723eULL, 0x000fc400000000ffULL,
0x00000018ff777819ULL, 0x000fe20000011441ULL, 0x0000000842417836ULL, 0x000fe20000000000ULL,
0x0000541038387816ULL, 0x000fe40000000038ULL, 0x00000018ff367819ULL, 0x000fe20000011439ULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x00008880395e7816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00001f42385b7589ULL, 0x000e6200000e0000ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x000088803b727816ULL, 0x000fe200000000ffULL,
0x00001f4138467589ULL, 0x000ea200000e0000ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x00000018ff6c7819ULL, 0x000fce000001143aULL,
0x0000007700777306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x0000005b10109232ULL, 0x082fe40000000000ULL, 0x0000005b12129232ULL, 0x000fc40000000000ULL,
0x0000004611119232ULL, 0x084fe20000000000ULL, 0x0000541077387816ULL, 0x008fe4000000003cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000004613139232ULL, 0x000fe40000000000ULL,
0x000000085c3c7824ULL, 0x000fc800078e025aULL, 0x000000103c377824ULL, 0x000fe200078e0237ULL,
0x0000541039397816ULL, 0x010fe20000000036ULL, 0x0000006a007b7306ULL, 0x0002ac0000200c00ULL,
0x00000038102c723cULL, 0x000fe4000000182cULL, 0x0000007100717306ULL, 0x000ee20000200c00ULL,
0x000088803a6a7816ULL, 0x002fc400000000ffULL, 0x000054105e357816ULL, 0x004fc6000000007bULL,
0x000000ffff5e7224ULL, 0x000fe400078e006aULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000001003a6a7824ULL, 0x040fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe2000001146aULL, 0x000001003b6a7824ULL, 0x040fe200078e00ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541034347816ULL, 0x008fe40000000071ULL,
0x00000018ff717819ULL, 0x000fe4000001143aULL, 0x00000018ff747819ULL, 0x000fe4000001146aULL,
0x00000018ff6a7819ULL, 0x000fe2000001143bULL, 0x0000003800397306ULL, 0x000e620000200c00ULL,
0x000000341028723cULL, 0x000fe20000001828ULL, 0x000000003734783bULL, 0x000ea20000004200ULL,
0x000100003b3b7824ULL, 0x000fca00078e00ffULL, 0x0000007400777306ULL, 0x000ee20000200c00ULL,
0x000054105e387816ULL, 0x002fce0000000039ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541072397816ULL, 0x008fce0000000077ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000000381030723cULL, 0x000fee0000001830ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x00000018ff387819ULL, 0x000fce000001143bULL, 0x0000003800397306ULL, 0x0002e20000200c00ULL,
0x00008880343b7816ULL, 0x044fe400000000ffULL, 0x00000018ff3a7819ULL, 0x000fe40000011434ULL,
0x00000018ff5e7819ULL, 0x000fe40000011435ULL, 0x0000888037727816ULL, 0x000fe200000000ffULL,
0x0000003b003b7306ULL, 0x000fe20000200c00ULL, 0x0000541071387816ULL, 0x002fe4000000006cULL,
0x0000541039397816ULL, 0x008fe2000000006aULL, 0x00000100346a7824ULL, 0x000fc800078e00ffULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x000000381018723cULL, 0x000fe60000001818ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005e005e7306ULL, 0x000fe40000200c00ULL,
0x0000010035397824ULL, 0x040fe200078e00ffULL, 0x0000888035387816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fc800078e00ffULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe40000011439ULL, 0x00000018ff357819ULL, 0x000fca0000011435ULL,
0x0000003800387306ULL, 0x000ff00000200c00ULL, 0x0000006c00777306ULL, 0x0004f00000200c00ULL,
0x0000003400397306ULL, 0x0003220000200c00ULL, 0x000000805c6c7811ULL, 0x004fca00078e18ffULL,
0x0000000159597824ULL, 0x000fe400078e026cULL, 0x0000003500717306ULL, 0x0006a20000200c00ULL,
0x000054103b347816ULL, 0x002fe2000000006aULL, 0x000000015a587824ULL, 0x000fe200078e026cULL,
0x00008880366a7816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541038357816ULL, 0x008fe20000000077ULL, 0x0000010036387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x00000034101c723cULL, 0x000fe2000000181cULL,
0x0000006a006a7306ULL, 0x000fec0000200c00ULL, 0x0000010037357824ULL, 0x000fe200078e00ffULL,
0x0000541039347816ULL, 0x010fe2000000003aULL, 0x0000003800777306ULL, 0x0002e20000200c00ULL,
0x0000100073397824ULL, 0x000fc400078e0270ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000b000395c7836ULL, 0x000fc60000000000ULL, 0x00000035007b7306ULL, 0x0005220000200c00ULL,
0x0000001059387824ULL, 0x002fcc00078e025cULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000541071357816ULL, 0x004fe4000000005eULL, 0x00000018ff5e7819ULL, 0x000fe20000011436ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fc60000011437ULL,
0x000000341020723cULL, 0x000fe20000001820ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000005e005e7306ULL, 0x000fea0000200c00ULL, 0x000054106a347816ULL, 0x008fe40000000077ULL,
0x0000541072357816ULL, 0x010fce000000007bULL, 0x000000341024723cULL, 0x000fe20000001824ULL,
0x0000007100357306ULL, 0x0003ec0000200c00ULL, 0x0001000037347824ULL, 0x000fe400078e00ffULL,
0x0000003600377306ULL, 0x000ea60000200c00ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x0000888039717816ULL, 0x002fc600000000ffULL, 0x0000003400727306ULL, 0x0004620000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe40000011439ULL, 0x00000018ff6a7819ULL, 0x000fe40000011438ULL,
0x00008880385a7816ULL, 0x000fe400000000ffULL, 0x00000018ff697819ULL, 0x000fe2000001143aULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541037347816ULL, 0x004fe2000000005eULL,
0x00000100395e7824ULL, 0x000fc400078e00ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x0000541072357816ULL, 0x002fc60000000035ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff727819ULL, 0x000fe4000001145eULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff5e7819ULL, 0x000fe2000001143bULL, 0x000000341010723cULL, 0x000fe20000001814ULL,
0x009000004014783bULL, 0x000e620000000200ULL, 0x0000007200727306ULL, 0x000fea0000200c00ULL,
0x0000001058347824ULL, 0x000fc400078e025cULL, 0x00000100385c7824ULL, 0x040fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0001000038387824ULL, 0x000fe400078e00ffULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900397306ULL, 0x000ef00000200c00ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000541039397816ULL, 0x008fce000000006cULL,
0x0000005c00777306ULL, 0x000ee20000200c00ULL, 0x000088803b6c7816ULL, 0x000fe200000000ffULL,
0x0000005b14149232ULL, 0x002fcc0000000000ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000005b16169232ULL, 0x000fe20000000000ULL, 0x00005410715b7816ULL, 0x000fe20000000072ULL,
0x0000004615159232ULL, 0x080fe40000000000ULL, 0x0000004617179232ULL, 0x000fe20000000000ULL,
0x000054105a5a7816ULL, 0x008fe40000000077ULL, 0x0000003800717306ULL, 0x000e620000200c00ULL,
0x00000018ff5c7819ULL, 0x004fe40000011434ULL, 0x00008880347b7816ULL, 0x000fc400000000ffULL,
0x0000005a1428723cULL, 0x000fe20000001828ULL, 0x00000018ff467819ULL, 0x000fe40000011436ULL,
0x0000006900697306ULL, 0x000fe80000200c00ULL, 0x000088803a5b7816ULL, 0x040fe400000000ffULL,
0x0000541071387816ULL, 0x002fe2000000006aULL, 0x000001003a6a7824ULL, 0x000fe200078e00ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fc60000011435ULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x00000038142c723cULL, 0x000fe6000000182cULL,
0x0000005b005b7306ULL, 0x000fe80000200c00ULL, 0x000001003b397824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc400078e00ffULL, 0x0000006a00387306ULL, 0x0002a20000200c00ULL,
0x00000018ff717819ULL, 0x000fe20000011439ULL, 0x000100003a397824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff3a7819ULL, 0x000fe40000011437ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000007100717306ULL, 0x000ee20000200c00ULL,
0x00008880356a7816ULL, 0x002fe400000000ffULL, 0x000054105b387816ULL, 0x004fca0000000038ULL,
0x0000003900727306ULL, 0x0006700000200c00ULL, 0x0000003b005b7306ULL, 0x000ea20000200c00ULL,
0x000054106c397816ULL, 0x008fe40000000071ULL, 0x0000888036717816ULL, 0x000fca00000000ffULL,
0x000000381430723cULL, 0x000fe20000001830ULL, 0x0000007b007b7306ULL, 0x000fec0000200c00ULL,
0x0000010034387824ULL, 0x040fe400078e00ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000010035397824ULL, 0x040fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000034003b7306ULL, 0x0003f00000200c00ULL, 0x00000038006c7306ULL, 0x0007e20000200c00ULL,
0x0000541072347816ULL, 0x002fc40000000069ULL, 0x00000018ff697819ULL, 0x000fe40000011435ULL,
0x000054105b357816ULL, 0x004fc6000000005eULL, 0x0000003900777306ULL, 0x000e620000200c00ULL,
0x0000888037387816ULL, 0x008fc600000000ffULL, 0x000000341418723cULL, 0x000fe80000001818ULL,
0x0000005c005c7306ULL, 0x000ea60000200c00ULL, 0x0000010036357824ULL, 0x040fe400078e00ffULL,
0x0000010037347824ULL, 0x040fe400078e00ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000069005b7306ULL, 0x000ef00000200c00ULL, 0x00000035005e7306ULL, 0x0003f00000200c00ULL,
0x0000003400697306ULL, 0x0009e20000200c00ULL, 0x000054106a357816ULL, 0x002fe20000000077ULL,
0x000000ffff777224ULL, 0x000fcc00078e0079ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000054107b347816ULL, 0x010fce000000006cULL, 0x0000003800387306ULL, 0x000f220000200c00ULL,
0x00000034141c723cULL, 0x000fee000000181cULL, 0x000054103b347816ULL, 0x004fe2000000005cULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000054105b357816ULL, 0x008fce000000005aULL,
0x0000003600397306ULL, 0x000ea20000200c00ULL, 0x000000341420723cULL, 0x000fee0000001820ULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0000541071347816ULL, 0x002fe4000000005eULL,
0x0000541038357816ULL, 0x010fe20000000069ULL, 0x000000ffff697224ULL, 0x000fe200078e0073ULL,
0x0000000173737812ULL, 0x000fc600078e0cffULL, 0x0000003700377306ULL, 0x000e640000200c00ULL,
0x000000341424723cULL, 0x000fee0000001824ULL, 0xfffffff844357812ULL, 0x000fe200078ec0ffULL,
0x0000000809447824ULL, 0x000fe200078e0202ULL, 0x0000541039347816ULL, 0x004fc60000000046ULL,
0x0000000102467824ULL, 0x000fe200078e0235ULL, 0x0000541037357816ULL, 0x002fce000000003aULL,
0x000000341414723cULL, 0x000fe20000001810ULL, 0x00f6c80d443479a7ULL, 0x00026c000850003fULL,
0x0000004056107836ULL, 0x000fe20000000000ULL, 0x00f6880d46ff79a7ULL, 0x0003e8000850003fULL,
0x0000000910007c0cULL, 0x000fda000bf26070ULL, 0x0000004400f01947ULL, 0x002fea0003800000ULL,
0x00000035520075a7ULL, 0x000e62000802007fULL, 0x0000008068137836ULL, 0x000fe40000000000ULL,
0x0000001009117824ULL, 0x000fe400078e00ffULL, 0x0000000c04717c24ULL, 0x020fe2000f8e02ffULL,
0x0000000913127c48ULL, 0x000fe4000ffe0000ULL, 0x0000001011107812ULL, 0x000fc600078ec0ffULL,
0x0000000112367824ULL, 0x000fe200078e0a13ULL, 0x0000000210577210ULL, 0x000fe40007ffe057ULL,
0x0000006006127812ULL, 0x000fe200078ef813ULL, 0x0000000000081947ULL, 0x002fec0003800000ULL,
0x00f6c835540075a7ULL, 0x000e64000802017fULL, 0x000000c000a49947ULL, 0x002fea0003800000ULL,
0x00000008695f7824ULL, 0x000fe200078e00ffULL, 0x0000f6a802117810ULL, 0x000fe20007ffe011ULL,
0x0000008071717824ULL, 0x000fe400078e00ffULL, 0x0000000151347824ULL, 0x100fe200078e0212ULL,
0x000000085f5a7812ULL, 0x000fe200078ec0ffULL, 0x0000000153107824ULL, 0x000fe200078e0212ULL,
0x00000000110672caULL, 0x000fe200000e0000ULL, 0x0000000160607824ULL, 0x000fe200078e0257ULL,
0x0000003471137210ULL, 0x000fe40007f5e0ffULL, 0x000000085a347812ULL, 0x000fc400078e3cffULL,
0x0000001071377210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x0000000e13107c11ULL, 0x000fe2000f8438ffULL, 0x0000000111577824ULL, 0x000fe200078e0234ULL,
0x000000005a0872caULL, 0x000fe200000e0000ULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x0000000f13117c11ULL, 0x000fe200090f3c38ULL, 0x000000014f347824ULL, 0x100fe200078e0212ULL,
0x0000002036137807ULL, 0x000fe20000000000ULL, 0x0000100069387824ULL, 0x000fe200078e00ffULL,
0x0000000e375c7c11ULL, 0x000fe2000f8238ffULL, 0x000000014d127824ULL, 0x000fe200078e0212ULL,
0x0000001350137248ULL, 0x000fc40007fe0000ULL, 0x0000000f37377c11ULL, 0x000fe400088f3c3aULL,
0x0000003471357210ULL, 0x000fe20007f3e0ffULL, 0x0000000113137824ULL, 0x000fe200078e0a50ULL,
0x0000100038727812ULL, 0x000fe200078ec0ffULL, 0x0000000806067290ULL, 0x000fe2000fffe03fULL,
0x0000000e353a7c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff367224ULL, 0x000fe200008e06ffULL,
0x000000134a00720cULL, 0x000fe40003f26070ULL, 0x0000b00070707810ULL, 0x000fc40007ffe072ULL,
0x0000000f35357c11ULL, 0x000fe400090f3c36ULL, 0x000000495c367210ULL, 0x000fe20007f5e0ffULL,
0x00000010755e7824ULL, 0x100fe200078e0270ULL, 0x0000001271397210ULL, 0x000fe20007f7e0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e0270ULL, 0x000000134800720cULL, 0x080fe20003f86070ULL,
0x000000ffff377224ULL, 0x000fe200010e0637ULL, 0x000000134500720cULL, 0x000fe20003f46070ULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x0000000e39127c11ULL, 0x000fe2000f8638ffULL,
0x000000106f5c7824ULL, 0x100fe200078e0270ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000365e7faeULL, 0x000fe2000c901c4aULL, 0x0000004910107210ULL, 0x000fe20007f3e0ffULL,
0x00000010555b7824ULL, 0x000fe200078e0270ULL, 0x0000000f39397c11ULL, 0x000fc400098f3c34ULL,
0x000000134700720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000493a347210ULL, 0x000fe40007fbe0ffULL, 0x0000004912127210ULL, 0x000fe40007f3e0ffULL,
0x00000000105d7faeULL, 0x000fe2000e101c4aULL, 0x000000ffff357224ULL, 0x000fe400028e0635ULL,
0x000000ffff137224ULL, 0x000fc800008e0639ULL, 0x00000000345c7faeULL, 0x000fe8000d901c4aULL,
0x00000000125b7faeULL, 0x0005e2000d101c4aULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000dff7679a7ULL, 0x0002620008500006ULL, 0x0000008049137810ULL, 0x004fca0007ffe04eULL,
0x000000014c137824ULL, 0x000fe200078e0213ULL, 0x00000079570075a7ULL, 0x000262000802007fULL,
0x00f6280d601079a7ULL, 0x000ea4000850003fULL, 0x00f62811620075a7ULL, 0x004ea4000804017fULL,
0x000000bc00a8a947ULL, 0x006fea0003800000ULL, 0x00f0000013117984ULL, 0x000e620000000800ULL,
0x0000100038387812ULL, 0x000fe200078e0cffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x00f2000013737984ULL, 0x0004a20000000800ULL, 0x0000000238387210ULL, 0x000fca0007ffe03dULL,
0x0000b000386a7836ULL, 0x000fc80000000000ULL, 0x000000103f557824ULL, 0x000fe200078e026aULL,
0x000000081100720bULL, 0x002fda0003f5d000ULL, 0x0000000000107806ULL, 0x000fc800010e0100ULL,
0x0000ffff10357812ULL, 0x000fda000784c0ffULL, 0x0000000000d8a947ULL, 0x004fea0003800000ULL,
0x000000081100720bULL, 0x000fe40003f54000ULL, 0x0000001108127209ULL, 0x000fca0007810000ULL,
0x8000001208107221ULL, 0x000fe20000010000ULL, 0x000000010f087811ULL, 0x000fc600078ff0ffULL,
0x3fb8aa3b10137820ULL, 0x000fe40000410000ULL, 0x0000000000107806ULL, 0x000fe400010e0100ULL,
0x0000000f0800720cULL, 0x000fe40003f45270ULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000ffff10107812ULL, 0x000fc800078e3cffULL, 0x0000001035ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff347807ULL, 0x000fe40001800000ULL, 0x000000800f10a824ULL, 0x000fe200078e0202ULL,
0x00001f4213087589ULL, 0x002e6800000e0000ULL, 0x000000104c35a210ULL, 0x000fe20007ffe049ULL,
0x000000130c0c7220ULL, 0x000fe20000410000ULL, 0x8000001211113221ULL, 0x100fe20000010000ULL,
0x00001f4113107589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b11113820ULL, 0x000fe20000410000ULL,
0x00f400123500a388ULL, 0x0007e60000000800ULL, 0x00000011000a3308ULL, 0x000f220000000800ULL,
0x0000000828287220ULL, 0x082fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000824247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x000fe20000410000ULL,
0x000000102a2a7220ULL, 0x084fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001016167220ULL, 0x080fe20000410000ULL, 0x0000001017177220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fc400078e0012ULL, 0x000000730a733220ULL, 0x018fce0000410000ULL,
0x0000000000141947ULL, 0x000fea0003800000ULL, 0x000000085f107812ULL, 0x000fe200078e0cffULL,
0x0000001009117824ULL, 0x000fc800078e0202ULL, 0x0000000110117824ULL, 0x000fc800078e0211ULL,
0x00f6a879110075a7ULL, 0x000e64000802017fULL, 0x000000b800a49947ULL, 0x002fea0003800000ULL,
0x000000005538783bULL, 0x000e620000004200ULL, 0x0000000aff6f723eULL, 0x000fe200000000ffULL,
0x000000103c6a7824ULL, 0x000fe200078e026aULL, 0x0000991034757816ULL, 0x000fe200000000ffULL,
0x0000000c730c7221ULL, 0x000fe20000010000ULL, 0x000054106f797816ULL, 0x000fe4000000006fULL,
0x000000ff7500720cULL, 0x000fc60003f25270ULL, 0x00001f42796f7589ULL, 0x000fe800000e0000ULL,
0x00001f4179747589ULL, 0x0005e200000e0000ULL, 0x0000010038107824ULL, 0x042fe200078e00ffULL,
0x0000888038357816ULL, 0x040fe200000000ffULL, 0x0000010039757824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011438ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011410ULL, 0x000001003b797824ULL, 0x004fe200078e00ffULL,
0x009800004310783bULL, 0x000e620000000200ULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fc40000011439ULL,
0x0000888039347816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000003400787306ULL, 0x0005f00000200c00ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x0000541035347816ULL, 0x004fe4000000006cULL, 0x00000018ff6c7819ULL, 0x000fca000001143aULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x0000006f10109232ULL, 0x002fe20000000000ULL,
0x0000541078357816ULL, 0x008fcc0000000075ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000006f12129232ULL, 0x000fe20000000000ULL, 0x000088803b787816ULL, 0x000fe200000000ffULL,
0x0000007411119232ULL, 0x080fe20000000000ULL, 0x00000018ff757819ULL, 0x000fe2000001143bULL,
0x0000007413139232ULL, 0x000fc60000000000ULL, 0x0000003800387306ULL, 0x000e680000200c00ULL,
0x000000341028723cULL, 0x000fe80000001828ULL, 0x0000003900397306ULL, 0x000ea60000200c00ULL,
0x0000541038347816ULL, 0x002fca0000000037ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000088803a387816ULL, 0x000fe400000000ffULL, 0x0000541039357816ULL, 0x004fca0000000036ULL,
0x0000003800387306ULL, 0x000fe40000200c00ULL, 0x00000034102c723cULL, 0x000fec000000182cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000001003a347824ULL, 0x040fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011434ULL, 0x000000006a34783bULL, 0x000e620000004200ULL,
0x00000018ff7a7819ULL, 0x000fe2000001143aULL, 0x000100003b3a7824ULL, 0x000fc600078e00ffULL,
0x0000003900397306ULL, 0x000ea40000200c00ULL, 0x00000018ff3a7819ULL, 0x000fcc000001143aULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541038387816ULL, 0x004fce0000000039ULL,
0x0000007a003b7306ULL, 0x000ea20000200c00ULL, 0x0000541078397816ULL, 0x000fce0000000079ULL,
0x0000003a003a7306ULL, 0x000ee20000200c00ULL, 0x000000381030723cULL, 0x000fee0000001830ULL,
0x000054103b387816ULL, 0x004fe2000000006cULL, 0x0000010035787824ULL, 0x042fe200078e00ffULL,
0x00008880356c7816ULL, 0x000fe200000000ffULL, 0x00000100343b7824ULL, 0x000fe200078e00ffULL,
0x000054103a397816ULL, 0x008fe20000000075ULL, 0x00000100377a7824ULL, 0x000fe200078e00ffULL,
0x00008880343a7816ULL, 0x000fc400000000ffULL, 0x00000018ff797819ULL, 0x000fe20000011478ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x000000381018723cULL, 0x000fe20000001818ULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff397819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011435ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003b00757306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000007900797306ULL, 0x000eb00000200c00ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000003800387306ULL, 0x000ff00000200c00ULL, 0x0000003400787306ULL, 0x0002f00000200c00ULL,
0x00000035003b7306ULL, 0x0005220000200c00ULL, 0x000054103a347816ULL, 0x002fc40000000075ULL,
0x00000018ff757819ULL, 0x000fca0000011436ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x000054106c357816ULL, 0x004fe20000000079ULL, 0x00000010596c7824ULL, 0x100fe400078e026eULL,
0x00000010586e7824ULL, 0x000fc800078e026eULL, 0x00000034101c723cULL, 0x000fe2000000181cULL,
0x0000007500757306ULL, 0x000fec0000200c00ULL, 0x0000541078347816ULL, 0x008fe40000000039ULL,
0x000054103b357816ULL, 0x010fe40000000038ULL, 0x00000018ff787819ULL, 0x000fe20000011437ULL,
0x000000006c38783bULL, 0x000e680000004200ULL, 0x000000341020723cULL, 0x000fe20000001820ULL,
0x0000007800787306ULL, 0x000fec0000200c00ULL, 0x0000010036357824ULL, 0x040fe200078e00ffULL,
0x0000888036347816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011435ULL, 0x0000888037357816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x00000018ff377819ULL, 0x000fc80000011437ULL,
0x0000007900797306ULL, 0x000eb00000200c00ULL, 0x0000003500357306ULL, 0x000ee20000200c00ULL,
0x0000541034347816ULL, 0x004fce0000000079ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x000088803a797816ULL, 0x002fe400000000ffULL, 0x0000541035357816ULL, 0x008fca000000007aULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x000001003b7a7824ULL, 0x000fe200078e00ffULL,
0x000000341024723cULL, 0x000fe80000001824ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000541036347816ULL, 0x004fe20000000075ULL,
0x0000010039367824ULL, 0x000fe200078e00ffULL, 0x0000541037357816ULL, 0x002fca0000000078ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000888039377816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011436ULL, 0x000000341010723cULL, 0x000fe20000001814ULL,
0x009800004014783bULL, 0x000e660000000200ULL, 0x0000003700377306ULL, 0x000fe60000200c00ULL,
0x0000010038357824ULL, 0x040fe200078e00ffULL, 0x0000888038347816ULL, 0x000fc800000000ffULL,
0x0000007500367306ULL, 0x0005e20000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x000088803b757816ULL, 0x004fce00000000ffULL,
0x0000003500357306ULL, 0x000eb00000200c00ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x0000541034347816ULL, 0x004fe20000000035ULL, 0x0000006f14149232ULL, 0x082fe20000000000ULL,
0x0000541037357816ULL, 0x000fe20000000036ULL, 0x0000006f16169232ULL, 0x000fe20000000000ULL,
0x00000018ff367819ULL, 0x000fe20000011438ULL, 0x0000007415159232ULL, 0x000fc40000000000ULL,
0x0001000038387824ULL, 0x000fe400078e00ffULL, 0x0000007417179232ULL, 0x000fe20000000000ULL,
0x00000018ff747819ULL, 0x000fe2000001143aULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff6f7819ULL, 0x000fe4000001143bULL,
0x000000341428723cULL, 0x000fe60000001828ULL, 0x0000003800357306ULL, 0x000e680000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011439ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x0000007400747306ULL, 0x000fe40000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000541035387816ULL, 0x002fc80000000036ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000001003a357824ULL, 0x040fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011435ULL, 0x0000003900397306ULL, 0x000e620000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe2000001143aULL, 0x000100003b3a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001143aULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000541039397816ULL, 0x002fce0000000034ULL, 0x0000007b003b7306ULL, 0x000e620000200c00ULL,
0x000000006e34783bULL, 0x000ee20000004200ULL, 0x00000038142c723cULL, 0x000fec000000182cULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541079387816ULL, 0x004fe40000000078ULL,
0x0000541075397816ULL, 0x000fca000000007aULL, 0x0000007c003a7306ULL, 0x000ea40000200c00ULL,
0x000000381430723cULL, 0x000fee0000001830ULL, 0x000054103b387816ULL, 0x002fe40000000074ULL,
0x000054103a397816ULL, 0x004fce000000006fULL, 0x000000381418723cULL, 0x000fe20000001818ULL,
0x0000010035787824ULL, 0x048fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x00000100346f7824ULL, 0x040fe200078e00ffULL, 0x00008880343b7816ULL, 0x040fe400000000ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011478ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff757819ULL, 0x000fe20000011435ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888036787816ULL, 0x000fe200000000ffULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011436ULL,
0x00000018ff387819ULL, 0x000fe20000011437ULL, 0x0000003b003b7306ULL, 0x000ff00000200c00ULL,
0x0000006f007c7306ULL, 0x0004f00000200c00ULL, 0x00000035007a7306ULL, 0x0003e20000200c00ULL,
0x00000100366f7824ULL, 0x004fc400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0000541074357816ULL, 0x002fe2000000007bULL, 0x0000010037747824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fc80000011436ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000007500757306ULL, 0x000ff00000200c00ULL, 0x0000003400797306ULL, 0x0006700000200c00ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x000054103b347816ULL, 0x008fc4000000007cULL,
0x00008880373b7816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fc800078e00ffULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000034141c723cULL, 0x000fec000000181cULL, 0x0000003b003b7306ULL, 0x000fe20000200c00ULL,
0x0000541079347816ULL, 0x002fe4000000003aULL, 0x000054107a357816ULL, 0x000fca0000000075ULL,
0x0000007400747306ULL, 0x000e640000200c00ULL, 0x000000341420723cULL, 0x000fec0000001820ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x0000541078347816ULL, 0x004fe4000000006fULL,
0x00000001696f7812ULL, 0x000fc400078ec0ffULL, 0x000054103b357816ULL, 0x002fc60000000074ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x000000ffff737224ULL, 0x000fc600078e006fULL,
0x000000341424723cULL, 0x000fe80000001824ULL, 0x0000003600367306ULL, 0x000e700000200c00ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000541036347816ULL, 0x002fc40000000039ULL,
0x0000541037357816ULL, 0x004fce0000000038ULL, 0x000000341414723cULL, 0x000fe20000001810ULL,
0x00f6c80d443479a7ULL, 0x00026c000850003fULL, 0x0000008056107836ULL, 0x000fe20000000000ULL,
0x00f6900d46ff79a7ULL, 0x0003e8000850003fULL, 0x0000000910007c0cULL, 0x000fda000bf26070ULL,
0x0000002c00d41947ULL, 0x002fea0003800000ULL, 0x00000035520075a7ULL, 0x000e62000804007fULL,
0x000000016b3e7824ULL, 0x000fe400078e023eULL, 0x000000c068117836ULL, 0x000fc60000000000ULL,
0x000000013e047812ULL, 0x000fc800078ec0ffULL, 0x000000010400780cULL, 0x000fe40003f25070ULL,
0x000000085a047812ULL, 0x000fe400078e3cffULL, 0x0000000163637807ULL, 0x000fe40004800000ULL,
0x00000000040872caULL, 0x000fe400000e0000ULL, 0x0000000911047c48ULL, 0x000fe2000ffe0000ULL,
0x000000013e6d7824ULL, 0x000fc800078e0263ULL, 0x0000000104107824ULL, 0x000fe200078e0a11ULL,
0x000000046d007c0cULL, 0x000fe4000bf26070ULL, 0x0000006006047812ULL, 0x000fe200078ef811ULL,
0x0000000000102947ULL, 0x002ff40003800000ULL, 0x000000040f117811ULL, 0x000fca00078ff8ffULL,
0x0000000811117824ULL, 0x000fc800078e0202ULL, 0x00f6a835110075a7ULL, 0x000e64000804017fULL,
0x000000a800b8a947ULL, 0x002fea0003800000ULL, 0x0000000153127824ULL, 0x100fe200078e0204ULL,
0x0000002010117807ULL, 0x000fe20000000000ULL, 0x0000000151347824ULL, 0x000fe200078e0204ULL,
0x000000630b639210ULL, 0x000fe20007ffe03eULL, 0x000000014f367824ULL, 0x100fe200078e0204ULL,
0x0000001271127210ULL, 0x000fe20007f5e0ffULL, 0x000000014d047824ULL, 0x000fe200078e0204ULL,
0x0000001150117248ULL, 0x000fe20007fe0000ULL, 0x0000000807077290ULL, 0x000fe2000fffe03fULL,
0x00000034713b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x0000000e12687c11ULL, 0x000fe2000f8038ffULL, 0x0000000111117824ULL, 0x000fe200078e0a50ULL,
0x0000003671357210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00008c00ff369b82ULL, 0x000e620000000a00ULL, 0x0000000e3b3a7c11ULL, 0x000fc4000f8438ffULL,
0x0000000471047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x0000000f12397c11ULL, 0x000fe400080f3c39ULL, 0x000000114a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x0000000f3b3b7c11ULL, 0x000fe400090f3c38ULL,
0x0000004968387210ULL, 0x000fe40007f5e0ffULL, 0x0000000e35347c11ULL, 0x000fc4000f8638ffULL,
0x0000000e04127c11ULL, 0x040fe2000f8838ffULL, 0x000000ffff397224ULL, 0x000fe200010e0639ULL,
0x0000000f35357c11ULL, 0x000fe400098f3c10ULL, 0x0000000f04137c11ULL, 0x000fe2000a0f3c13ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x000000493a107210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038677faeULL, 0x0005e2000c101c4aULL,
0x000000114800720cULL, 0x080fe20003f86070ULL, 0x0000000463369825ULL, 0x002fe200078e0036ULL,
0x000000114700720cULL, 0x000fc40003f66070ULL, 0x000000114500720cULL, 0x000fe20003f46070ULL,
0x000000ffff117224ULL, 0x000fe200028e063bULL, 0x0000004934347210ULL, 0x000fe20007f1e0ffULL,
0x0000000a36049981ULL, 0x000362000c1e1900ULL, 0x0000004912127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe400000e0635ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x0000000010667faeULL, 0x0003e8000e101c4aULL, 0x0000000034657faeULL, 0x0003e8000d901c4aULL,
0x0000000012647faeULL, 0x0003e2000d101c4aULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a47ULL, 0x0000000161617824ULL, 0x000fe200078e025aULL,
0x0000000000007918ULL, 0x004fcc0000000000ULL, 0x0000000dff7479a7ULL, 0x0004a20008500007ULL,
0x0000010049137810ULL, 0x002fca0007ffe04eULL, 0x000000014c137824ULL, 0x000fe200078e0213ULL,
0x00000077610075a7ULL, 0x0004a2000800007fULL, 0x00f6480d621079a7ULL, 0x000e64000850003fULL,
0x00f64811620075a7ULL, 0x002e64000802017fULL, 0x000000a400e49947ULL, 0x006fea0003800000ULL,
0x00f0000013117984ULL, 0x000e620000000800ULL, 0x00000002723d7210ULL, 0x000fe20007ffe03dULL,
0x00000001ff3a7424ULL, 0x000fe400078e00ffULL, 0x00f2000013617984ULL, 0x0004a40000000800ULL,
0x0000b0003d3d7836ULL, 0x000fc80000000000ULL, 0x000000103f347824ULL, 0x000fe200078e023dULL,
0x000000081100720bULL, 0x002fda0003f3d000ULL, 0x0000000000107806ULL, 0x000fc800008e0100ULL,
0x0000ffff10357812ULL, 0x000fda000782c0ffULL, 0x0000000000d89947ULL, 0x004fea0003800000ULL,
0x000000081100720bULL, 0x000fe40003f34000ULL, 0x0000001108127209ULL, 0x000fca0007810000ULL,
0x8000001208107221ULL, 0x000fe20000010000ULL, 0x000000020f087811ULL, 0x000fc600078ff0ffULL,
0x3fb8aa3b10137820ULL, 0x000fe40000410000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x0000000f0800720cULL, 0x000fe40003f25270ULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000ffff10107812ULL, 0x000fc800078e3cffULL, 0x0000001035ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff3a7807ULL, 0x000fe40001000000ULL, 0x000000800f109824ULL, 0x000fe200078e0202ULL,
0x00001f4213087589ULL, 0x002e6800000e0000ULL, 0x000000104c359210ULL, 0x000fe20007ffe049ULL,
0x000000130c0c7220ULL, 0x000fe20000410000ULL, 0x8000001211112221ULL, 0x100fe20000010000ULL,
0x00001f4113107589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b11112820ULL, 0x000fe20000410000ULL,
0x00f4001235009388ULL, 0x0007e60000000800ULL, 0x00000011000a2308ULL, 0x000f220000000800ULL,
0x0000000828287220ULL, 0x082fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000824247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x000fe20000410000ULL,
0x000000102a2a7220ULL, 0x084fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001016167220ULL, 0x080fe20000410000ULL, 0x0000001017177220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fc400078e0012ULL, 0x000000610a612220ULL, 0x018fce0000410000ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000085f107812ULL, 0x000fc800078ec0ffULL,
0x0000000210117210ULL, 0x000fc80007ffe04bULL, 0x00f6a877110075a7ULL, 0x000e64000800017fULL,
0x000000a000e88947ULL, 0x002fea0003800000ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000000aff62723eULL, 0x000fe200000000ffULL, 0x000000103c3c7824ULL, 0x000fe200078e023dULL,
0x000099103a647816ULL, 0x000fe200000000ffULL, 0x00a000004310783bULL, 0x000fe20000000200ULL,
0x0000541062777816ULL, 0x000fe20000000062ULL, 0x000000c056567836ULL, 0x000fe40000000000ULL,
0x0000000c610c7221ULL, 0x000fe20000010000ULL, 0x000000003c3c783bULL, 0x000ea80000004200ULL,
0x00001f4277637589ULL, 0x000ee800000e0000ULL, 0x00001f4177627589ULL, 0x0008a200000e0000ULL,
0x00000100343b7824ULL, 0x042fe200078e00ffULL, 0x00008880346b7816ULL, 0x000fe200000000ffULL,
0x00000100353a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011435ULL,
0x00000018ff727819ULL, 0x000fe4000001143bULL, 0x00008880353b7816ULL, 0x040fe200000000ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff737819ULL, 0x000fe2000001143aULL,
0x000000ffff3a7224ULL, 0x000fe200078e0064ULL, 0x00000018ff397819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011436ULL,
0x000000ff3a00720cULL, 0x000fe20003f05270ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x00010000343a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x010fc40000011435ULL,
0x00000018ff667819ULL, 0x000fe40000011437ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b003b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x004fe4000001143cULL,
0x00000018ff687819ULL, 0x000fe2000001143dULL, 0x0000006310108232ULL, 0x088fe20000000000ULL,
0x000088803d787816ULL, 0x000fe200000000ffULL, 0x0000006312128232ULL, 0x000fe20000000000ULL,
0x000054106b347816ULL, 0x002fe20000000072ULL, 0x0000007300767306ULL, 0x000e620000200c00ULL,
0x0000006211118232ULL, 0x080fe20000000000ULL, 0x0000888036727816ULL, 0x000fe200000000ffULL,
0x0000006213138232ULL, 0x000fe20000000000ULL, 0x00008880376b7816ULL, 0x000fc400000000ffULL,
0x00000018ff647819ULL, 0x000fe4000001143fULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x00000018ff657819ULL, 0x000fe4000001143eULL, 0x000054103b357816ULL, 0x002fca0000000076ULL,
0x0000003a003a7306ULL, 0x000e640000200c00ULL, 0x000000341028723cULL, 0x000fec0000001828ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x0000010036347824ULL, 0x000fe400078e00ffULL,
0x0000010037357824ULL, 0x000fca00078e00ffULL, 0x00000077003b7306ULL, 0x0004e20000200c00ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fcc0000011434ULL,
0x0000003400737306ULL, 0x0003e20000200c00ULL, 0x00000018ff777819ULL, 0x004fe20000011435ULL,
0x0001000036357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054103a347816ULL, 0x002fe20000000039ULL,
0x0000001059397824ULL, 0x100fe200078e0270ULL, 0x00000018ff597819ULL, 0x000fe20000011437ULL,
0x0000001058377824ULL, 0x000fe200078e0270ULL, 0x000088803c587816ULL, 0x040fe200000000ffULL,
0x000001003c707824ULL, 0x040fe400078e00ffULL, 0x0000003500767306ULL, 0x0007e20000200c00ULL,
0x000100003c3c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff707819ULL, 0x000fc60000011470ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054103b357816ULL, 0x008fe40000000038ULL, 0x000000003938783bULL, 0x000e6a0000004200ULL,
0x00000034102c723cULL, 0x000fe2000000182cULL, 0x0000006600667306ULL, 0x000fec0000200c00ULL,
0x0000541072347816ULL, 0x004fc40000000073ULL, 0x0000005900597306ULL, 0x000eb00000200c00ULL,
0x0000005800727306ULL, 0x0007e20000200c00ULL, 0x0000541059597816ULL, 0x004fce0000000066ULL,
0x0000007700367306ULL, 0x0005e20000200c00ULL, 0x0000541076587816ULL, 0x008fe20000000067ULL,
0x000001003d677824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc800078e00ffULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x00000018ff777819ULL, 0x004fe20000011467ULL,
0x000000581018723cULL, 0x000fe20000001818ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00008880387a7816ULL, 0x002fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe2000001143aULL,
0x0000007000737306ULL, 0x000fe20000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011438ULL,
0x00000018ff667819ULL, 0x000fc4000001143bULL, 0x000054106b357816ULL, 0x008fc60000000036ULL,
0x0000007800767306ULL, 0x000fe20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fc60000011439ULL,
0x000000341030723cULL, 0x000fe20000001830ULL, 0x000000003734783bULL, 0x000e660000004200ULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541076597816ULL, 0x004fce0000000077ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x0000003c003c7306ULL, 0x000eb00000200c00ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x000054103c3c7816ULL, 0x004fce0000000071ULL, 0x0000005800707306ULL, 0x0005e20000200c00ULL,
0x00000018ff777819ULL, 0x002fe40000011437ULL, 0x000054103d3d7816ULL, 0x008fca0000000068ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541072587816ULL, 0x004fe20000000073ULL,
0x000001003e727824ULL, 0x000fe200078e00ffULL, 0x000088803f687816ULL, 0x040fe200000000ffULL,
0x0000003c1020723cULL, 0x000fe60000001820ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000006400647306ULL, 0x000fe40000200c00ULL, 0x00000058101c723cULL, 0x000fe2000000181cULL,
0x000001003f3d7824ULL, 0x000fc400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fc600078e0068ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e587816ULL, 0x000fe400000000ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005800717306ULL, 0x0002a20000200c00ULL,
0x00000018ff597819ULL, 0x000fe40000011434ULL, 0x00000018ff687819ULL, 0x000fca0000011435ULL,
0x0000003c00737306ULL, 0x0005e20000200c00ULL, 0x00000018ff587819ULL, 0x002fce0000011436ULL,
0x0000003d00767306ULL, 0x000e620000200c00ULL, 0x00005410713c7816ULL, 0x004fe20000000072ULL,
0x000100003e717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x00005410733d7816ULL, 0x002fce0000000076ULL,
0x0000007100727306ULL, 0x0002a20000200c00ULL, 0x000088803a767816ULL, 0x000fe200000000ffULL,
0x0000003c1024723cULL, 0x000fec0000001824ULL, 0x00000077003e7306ULL, 0x0007e20000200c00ULL,
0x00000100393d7824ULL, 0x000fe400078e00ffULL, 0x00000100383c7824ULL, 0x000fca00078e00ffULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x002fe2000001143dULL,
0x00010000383d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x008fe4000001143cULL,
0x0000541072387816ULL, 0x004fe20000000065ULL, 0x0001000039657824ULL, 0x040fe200078e00ffULL,
0x00008880393c7816ULL, 0x000fe200000000ffULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000054103f397816ULL, 0x000fe40000000064ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x000088803b3f7816ULL, 0x000fe200000000ffULL,
0x000000381010723cULL, 0x000fe20000001814ULL, 0x00a000004014783bULL, 0x000e620000000200ULL,
0x0000007700777306ULL, 0x000eaa0000200c00ULL, 0x000001003a387824ULL, 0x000fc400078e00ffULL,
0x000001003b397824ULL, 0x040fe200078e00ffULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff647819ULL, 0x000fe4000001143aULL, 0x0000003800737306ULL, 0x0005e20000200c00ULL,
0x00008880343a7816ULL, 0x000fc400000000ffULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000003900727306ULL, 0x0007e20000200c00ULL, 0x000054107a387816ULL, 0x004fe20000000077ULL,
0x000000ffff777224ULL, 0x000fcc00078e0075ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000054103c397816ULL, 0x008fe20000000071ULL, 0x00000100343c7824ULL, 0x040fe400078e00ffULL,
0x0001000034347824ULL, 0x000fe400078e00ffULL, 0x0000006314148232ULL, 0x082fe40000000000ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000006316168232ULL, 0x000fe20000000000ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000006215158232ULL, 0x080fe20000000000ULL,
0x00000018ff717819ULL, 0x000fe2000001143cULL, 0x0000006217178232ULL, 0x000fe20000000000ULL,
0x0000888035627816ULL, 0x000fc400000000ffULL, 0x0000006500787306ULL, 0x000ea20000200c00ULL,
0x0000000956007c0cULL, 0x000fc6000bf06070ULL, 0x000000381428723cULL, 0x000fe80000001828ULL,
0x00000034003c7306ULL, 0x0003e60000200c00ULL, 0x0000010035387824ULL, 0x040fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x000054103d347816ULL, 0x002fe40000000070ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff657819ULL, 0x000fe40000011438ULL, 0x0000888036387816ULL, 0x000fe200000000ffULL,
0x0000003500397306ULL, 0x0005f00000200c00ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000541078357816ULL, 0x004fe2000000006bULL, 0x00010000376b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x00000034142c723cULL, 0x000fe2000000182cULL,
0x0000003b00637306ULL, 0x0005ec0000200c00ULL, 0x0000010037347824ULL, 0x000fe400078e00ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000100363b7824ULL, 0x004fc400078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011434ULL, 0x0001000036347824ULL, 0x000fe400078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143bULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00008880373b7816ULL, 0x000fca00000000ffULL,
0x0000006400647306ULL, 0x000eb00000200c00ULL, 0x0000003500367306ULL, 0x0003f00000200c00ULL,
0x0000003400377306ULL, 0x0007e20000200c00ULL, 0x000054103f357816ULL, 0x002fce0000000072ULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0000541076347816ULL, 0x008fe20000000073ULL,
0x000000ffff767224ULL, 0x000fe200078e0074ULL, 0x0000000169737812ULL, 0x000fca00078e0cffULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000341430723cULL, 0x000fee0000001830ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541064347816ULL, 0x004fe40000000067ULL,
0x0000541063357816ULL, 0x000fca0000000066ULL, 0x0000006500657306ULL, 0x000ea40000200c00ULL,
0x000000341418723cULL, 0x000fec0000001818ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x000054103a347816ULL, 0x002fe40000000071ULL, 0x0000541062357816ULL, 0x004fca0000000065ULL,
0x0000006800687306ULL, 0x000e640000200c00ULL, 0x00000034141c723cULL, 0x000fec000000181cULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x000054103c347816ULL, 0x008fe40000000059ULL,
0x0000541039357816ULL, 0x002fca0000000068ULL, 0x0000003d003d7306ULL, 0x000e640000200c00ULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000541038347816ULL, 0x002fce000000003dULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x000054103b357816ULL, 0x004fce0000000036ULL, 0x0000006b003f7306ULL, 0x000ea20000200c00ULL,
0x000000341424723cULL, 0x000fee0000001824ULL, 0x0000541037347816ULL, 0x002fe40000000058ULL,
0x000054103f357816ULL, 0x004fce000000003eULL, 0x000000341414723cULL, 0x000fe20000001810ULL,
0x00f6c80d443479a7ULL, 0x0002a2000850003fULL, 0x00f6980d46ff79a7ULL, 0x0003e2000850003fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000001400c00947ULL, 0x000fde0003800000ULL,
0x00000035520075a7ULL, 0x004ea2000800007fULL, 0x0000000103107824ULL, 0x000fe400078e020eULL,
0x0000001009137824ULL, 0x000fe400078e0202ULL, 0x0000000810117824ULL, 0x040fe400078e0209ULL,
0x0000000110127836ULL, 0x000fe20000000000ULL, 0x0000f6a85a5a7810ULL, 0x000fe20007ffe013ULL,
0x0000002011117824ULL, 0x000fe400078e00ffULL, 0x0000000c04137c24ULL, 0x020fe2000f8e02ffULL,
0x0000000512007c0cULL, 0x000fc4000bf26070ULL, 0x0000006006107812ULL, 0x000fe400078ef811ULL,
0x0000000911127c48ULL, 0x000fe2000ffe0000ULL, 0x0000000000080947ULL, 0x004ff00003800000ULL,
0x00f6c835540075a7ULL, 0x000ea4000800017fULL, 0x0000009000fc8947ULL, 0x004fea0003800000ULL,
0x0000000112127824ULL, 0x000fe400078e0a11ULL, 0x0000008013347824ULL, 0x000fe400078e00ffULL,
0x0000000151517824ULL, 0x100fe200078e0210ULL, 0x0000002012117807ULL, 0x000fe20000800000ULL,
0x0000000153537824ULL, 0x100fe400078e0210ULL, 0x000000014f4f7824ULL, 0x100fe200078e0210ULL,
0x0000005134517210ULL, 0x000fe20007f3e0ffULL, 0x000000014d107824ULL, 0x000fe200078e0210ULL,
0x0000005334537210ULL, 0x000fc40007f1e0ffULL, 0x0000004f344f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000001150117248ULL, 0x000fe20007fe0000ULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x0000000e513a7c11ULL, 0x000fe4000f8238ffULL,
0x0000001034377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x0000000e53367c11ULL, 0x000fe2000f8038ffULL, 0x0000000111117824ULL, 0x000fe200078e0a50ULL,
0x0000000e4f347c11ULL, 0x000fc4000f8438ffULL, 0x0000000f51397c11ULL, 0x000fe400088f3c12ULL,
0x0000000f53137c11ULL, 0x000fe200080f3c38ULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000004936127210ULL, 0x000fe40007fbe0ffULL, 0x0000000f4f357c11ULL, 0x000fe400090f3c10ULL,
0x000000114a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000114800720cULL, 0x000fc40003f26070ULL, 0x0000000e37367c11ULL, 0x000fe4000f8638ffULL,
0x000000114700720cULL, 0x080fe40003f06070ULL, 0x000000114500720cULL, 0x000fe40003fa6070ULL,
0x000000493a107210ULL, 0x000fe40007f9e0ffULL, 0x0000004934347210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000125e7faeULL, 0x0005e2000d101c4aULL,
0x0000000f37377c11ULL, 0x000fe200098f3c38ULL, 0x000000ffff117224ULL, 0x000fe200020e0639ULL,
0x0000004936367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fc600030e0635ULL,
0x00000000105d7faeULL, 0x0005e2000c901c4aULL, 0x000000ffff377224ULL, 0x000fc600018e0637ULL,
0x00000000345c7faeULL, 0x0005e8000c101c4aULL, 0x00000000365b7faeULL, 0x0005e2000e901c4aULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000d5a7679a7ULL, 0x0006e2000850003fULL,
0x0000018049137810ULL, 0x004fca0007ffe04eULL, 0x000000014c137824ULL, 0x000fe200078e0213ULL,
0x00000075570075a7ULL, 0x0006e2000800007fULL, 0x00f6680d601079a7ULL, 0x000ea4000850003fULL,
0x00f66811600075a7ULL, 0x004ea4000802017fULL, 0x00000090003c9947ULL, 0x00cfea0003800000ULL,
0x00f0000013117984ULL, 0x000ea20000000800ULL, 0x00000001ff517424ULL, 0x000fc600078e00ffULL,
0x00f2000013457984ULL, 0x0006e20000000800ULL, 0x000000081100720bULL, 0x004fda0003f3d000ULL,
0x0000000000107806ULL, 0x000fc800008e0100ULL, 0x0000ffff10347812ULL, 0x000fda000782c0ffULL,
0x0000000000d89947ULL, 0x008fea0003800000ULL, 0x000000081100720bULL, 0x000fe40003f34000ULL,
0x0000001108367209ULL, 0x000fca0007810000ULL, 0x8000003608107221ULL, 0x000fe20000010000ULL,
0x000000030f087811ULL, 0x000fc600078ff0ffULL, 0x3fb8aa3b10127820ULL, 0x000fe40000410000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x0000000f0800720cULL, 0x000fe20003f25270ULL,
0x0000001200137308ULL, 0x000ea20000000800ULL, 0x0000ffff10357812ULL, 0x000fc800078e3cffULL,
0x0000003534ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff517807ULL, 0x000fc60001000000ULL,
0x000000800f109824ULL, 0x000fe200078e0202ULL, 0x00001f4213087589ULL, 0x004ea200000e0000ULL,
0x000000130c0c7220ULL, 0x000fc60000410000ULL, 0x000000104c499210ULL, 0x000fe20007ffe049ULL,
0x8000003611112221ULL, 0x100fe20000010000ULL, 0x00001f4113107589ULL, 0x000ee600000e0000ULL,
0x3fb8aa3b11112820ULL, 0x000fe20000410000ULL, 0x00f4003649009388ULL, 0x0009e60000000800ULL,
0x00000011000a2308ULL, 0x000f620000000800ULL, 0x0000000828287220ULL, 0x084fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x000fe20000410000ULL, 0x000000102a2a7220ULL, 0x088fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001016167220ULL, 0x080fe20000410000ULL,
0x0000001017177220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0036ULL,
0x000000450a452220ULL, 0x030fce0000410000ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000085f5f7812ULL, 0x000fc800078e0cffULL, 0x000000025f4b7210ULL, 0x000fc80007ffe04bULL,
0x00f6a8754b0075a7ULL, 0x000ea4000800017fULL, 0x0000008c004c8947ULL, 0x004fea0003800000ULL,
0x000000005538783bULL, 0x000ea20000004200ULL, 0x0000991051517816ULL, 0x000fe200000000ffULL,
0x0000000c450c7221ULL, 0x000fe20000010000ULL, 0x0000000aff58723eULL, 0x000fe200000000ffULL,
0x000000006a3c783bULL, 0x000ee20000004200ULL, 0x000000ff5100720cULL, 0x000fc60003f05270ULL,
0x000000006c10783bULL, 0x0009680000004200ULL, 0x000000006e34783bULL, 0x000ee20000004200ULL,
0x00000018ff577819ULL, 0x004fe20000011438ULL, 0x0000010038527824ULL, 0x040fe200078e00ffULL,
0x00008880385a7816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011439ULL, 0x0000010039547824ULL, 0x040fe200078e00ffULL,
0x0000888039537816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff627819ULL, 0x008fe4000001143cULL, 0x000088803c6c7816ULL, 0x010fe200000000ffULL,
0x0000003800747306ULL, 0x0005e20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fe4000001143aULL,
0x00000018ff687819ULL, 0x000fe4000001143bULL, 0x000088803a707816ULL, 0x000fc400000000ffULL,
0x000088803b647816ULL, 0x040fe200000000ffULL, 0x0000003900757306ULL, 0x0007e20000200c00ULL,
0x000001003b387824ULL, 0x044fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x020fe40000011411ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005200597306ULL, 0x0005e20000200c00ULL,
0x000001003c397824ULL, 0x048fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fc4000001143fULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800737306ULL, 0x0007e20000200c00ULL,
0x000001003a527824ULL, 0x044fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803f5b7816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143dULL, 0x0000003900697306ULL, 0x0005e20000200c00ULL,
0x000001003d387824ULL, 0x008fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001143aULL,
0x000088803d677816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003c00657306ULL, 0x000fe20000200c00ULL,
0x000001003e397824ULL, 0x004fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff477819ULL, 0x000fe40000011410ULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x00000038006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff507819ULL, 0x000fe4000001143eULL, 0x000088803e617816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011412ULL,
0x0000003900607306ULL, 0x0007e20000200c00ULL, 0x000001003f387824ULL, 0x044fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011413ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005400567306ULL, 0x0005e20000200c00ULL, 0x0000010010397824ULL, 0x008fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4b7819ULL, 0x002fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000038005e7306ULL, 0x0003e20000200c00ULL,
0x0000888011547816ULL, 0x004fc400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011435ULL,
0x00000018ff4d7819ULL, 0x000fe40000011436ULL, 0x00000018ff4e7819ULL, 0x000fe20000011437ULL,
0x0000003a006e7306ULL, 0x000fe20000200c00ULL, 0x0000010011387824ULL, 0x042fe400078e00ffULL,
0x0001000011117824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011438ULL,
0x0000003b00717306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fce0000011411ULL,
0x00000039003c7306ULL, 0x0003f00000200c00ULL, 0x0000001100517306ULL, 0x0005e20000200c00ULL,
0x00a800004338783bULL, 0x002fee0000000200ULL, 0x0000003f005c7306ULL, 0x000fe20000200c00ULL,
0x0000541058117816ULL, 0x004fca0000000058ULL, 0x00001f4111587589ULL, 0x000e6400000e0000ULL,
0x00000055003f7306ULL, 0x0005f00000200c00ULL, 0x0000003d00667306ULL, 0x0007e20000200c00ULL,
0x00001f4211557589ULL, 0x00452e00000e0000ULL, 0x0000005300537306ULL, 0x000f620000200c00ULL,
0x00008880103d7816ULL, 0x048fe200000000ffULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000010013427824ULL, 0x004fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005200637306ULL, 0x000fe20000200c00ULL, 0x0000005839398232ULL, 0x082fe20000000000ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x000000583b3b8232ULL, 0x000fe20000000000ULL,
0x0000541053117816ULL, 0x020fc80000000056ULL, 0x0000001000527306ULL, 0x0003e20000200c00ULL,
0x0000005538388232ULL, 0x090fe40000000000ULL, 0x000000553a3a8232ULL, 0x000fca0000000000ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000010012107824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011410ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000054105a107816ULL, 0x000fe40000000059ULL, 0x0000888013597816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00008880345a7816ULL, 0x000fc600000000ffULL,
0x0000003e005f7306ULL, 0x000fe20000200c00ULL, 0x000000103828723cULL, 0x000fe20000001828ULL,
0x00000018ff137819ULL, 0x000fcc0000011413ULL, 0x00000054003e7306ULL, 0x0005e20000200c00ULL,
0x0000010034107824ULL, 0x040fe200078e00ffULL, 0x0000541075117816ULL, 0x002fe20000000072ULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011410ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0000888012547816ULL, 0x044fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541074107816ULL, 0x000fe40000000057ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000006400647306ULL, 0x000ea40000200c00ULL, 0x00000010382c723cULL, 0x000fec000000182cULL,
0x0000001200567306ULL, 0x0007f00000200c00ULL, 0x0000006b006b7306ULL, 0x000f220000200c00ULL,
0x0000888035127816ULL, 0x008fca00000000ffULL, 0x000000ffff727224ULL, 0x000fe400078e0012ULL,
0x0000006800687306ULL, 0x000ef00000200c00ULL, 0x0000005900537306ULL, 0x000ff00000200c00ULL,
0x0000001300597306ULL, 0x000bf00000200c00ULL, 0x0000004100577306ULL, 0x0005e20000200c00ULL,
0x00a800004010783bULL, 0x02036e0000000200ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541070407816ULL, 0x002fe20000000063ULL, 0x0000010035707824ULL, 0x000fe200078e00ffULL,
0x0000541064417816ULL, 0x004fe20000000073ULL, 0x000000ffff737224ULL, 0x000fc600078e006fULL,
0x00000018ff647819ULL, 0x000fe20000011470ULL, 0x0000006700677306ULL, 0x000e640000200c00ULL,
0x000000403830723cULL, 0x000fec0000001830ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x000054106e407816ULL, 0x010fc4000000006bULL, 0x0000541071417816ULL, 0x008fca0000000068ULL,
0x0000005d005d7306ULL, 0x000ee40000200c00ULL, 0x000000403818723cULL, 0x000fec0000001818ULL,
0x0000003400687306ULL, 0x0009e20000200c00ULL, 0x0001000035407824ULL, 0x000fe200078e00ffULL,
0x0000541067357816ULL, 0x002fe2000000006aULL, 0x0000005811118232ULL, 0x0a0fe20000000000ULL,
0x0000888036417816ULL, 0x000fe200000000ffULL, 0x0000005813138232ULL, 0x000fe20000000000ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000005510108232ULL, 0x080fe20000000000ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054106c347816ULL, 0x010fe20000000069ULL,
0x0000005512128232ULL, 0x000fcc0000000000ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x00000034381c723cULL, 0x000fee000000181cULL, 0x0000006100617306ULL, 0x000f220000200c00ULL,
0x0000541065347816ULL, 0x004fe40000000062ULL, 0x0000541066357816ULL, 0x008fca000000005dULL,
0x0000005b005b7306ULL, 0x000ea40000200c00ULL, 0x000000343820723cULL, 0x000fec0000001820ULL,
0x0000004000677306ULL, 0x0009e20000200c00ULL, 0x0000010036357824ULL, 0x040fe200078e00ffULL,
0x000054105f347816ULL, 0x002fe20000000050ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011435ULL, 0x00000041005d7306ULL, 0x0005e20000200c00ULL,
0x0000541061407816ULL, 0x010fe40000000060ULL, 0x000054105c357816ULL, 0x000fe4000000004fULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054105b417816ULL, 0x004fe2000000005eULL, 0x000000343814723cULL, 0x000fec0000001814ULL,
0x000000403824723cULL, 0x000fe20000001824ULL, 0x0000010037357824ULL, 0x000fe200078e00ffULL,
0x0000003d003d7306ULL, 0x000e680000200c00ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x0000888037417816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000004800487306ULL, 0x000ea80000200c00ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x000054103d3c7816ULL, 0x002fe4000000003cULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000054103e3d7816ULL, 0x000fc4000000003fULL, 0x0000541051517816ULL, 0x004fca0000000048ULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000003c1028723cULL, 0x000fe20000001828ULL,
0x0000541056587816ULL, 0x002fcc0000000049ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x0000541059597816ULL, 0x004fce000000004aULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000000581018723cULL, 0x000fe20000001818ULL, 0x0000541068667816ULL, 0x002fcc000000004bULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541067677816ULL, 0x004fce000000004cULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x000000661020723cULL, 0x000fee0000001820ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000e700000200c00ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x0000541053537816ULL, 0x002fce0000000042ULL, 0x0000007200637306ULL, 0x000fe20000200c00ULL,
0x000054105a5a7816ULL, 0x004fce0000000057ULL, 0x0000006400647306ULL, 0x000e700000200c00ULL,
0x0000005000407306ULL, 0x0004e20000200c00ULL, 0x00005410635b7816ULL, 0x002fce0000000064ULL,
0x0000004100347306ULL, 0x000fe20000200c00ULL, 0x0000541052507816ULL, 0x004fe40000000047ULL,
0x0000541054527816ULL, 0x000fe20000000043ULL, 0x0000005a101c723cULL, 0x000fe2000000181cULL,
0x000054105d407816ULL, 0x008fc60000000040ULL, 0x0000003500357306ULL, 0x000e640000200c00ULL,
0x00000050102c723cULL, 0x000fec000000182cULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x000000521030723cULL, 0x000fe20000001830ULL, 0x0000541034417816ULL, 0x002fcc0000000035ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x00f6c80d443479a7ULL, 0x000722000850003fULL,
0x000000401024723cULL, 0x000fe20000001824ULL, 0x0000541036367816ULL, 0x004fe2000000004dULL,
0x00f6a00d46ff79a7ULL, 0x0007e2000850003fULL, 0x0000541037377816ULL, 0x002fce000000004eULL,
0x000000361014723cULL, 0x008fde0000001814ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000001030e7824ULL, 0x000fca00078e020eULL, 0x000000050e007c0cULL, 0x000fda000bf06070ULL,
0xffffff98006c8947ULL, 0x03efea000383ffffULL, 0x00000000000b7919ULL, 0x000e620000002500ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0030ULL, 0x000000ffff3b7224ULL, 0x000fe400078e002cULL,
0x000000ffff347224ULL, 0x008fe400078e0031ULL, 0x000000ffff307224ULL, 0x000fe400078e002dULL,
0x000000ffff2c7224ULL, 0x000fe400078e0029ULL, 0x000000ffff397224ULL, 0x000fe200078e0028ULL,
0x000000050b007c0cULL, 0x002fda000bf06070ULL, 0x0000000000d40947ULL, 0x000fea0003800000ULL,
0x018000000c007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000797000047802ULL, 0x000fce0000000f00ULL,
0x00000084000c7944ULL, 0x004fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000c00057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc8000000000cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fce0000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff047b82ULL, 0x000f240000000a00ULL,
0x0000000a04057981ULL, 0x010f22000c1e9900ULL, 0x00000000000d7919ULL, 0x000f640000000000ULL,
0x00000002ff117819ULL, 0x020fe4000001160dULL, 0x000000080d0d7811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x01cfca0000410000ULL, 0x00001f1100067589ULL, 0x000ea800000e0000ULL,
0x00001f0d000d7589ULL, 0x000ee200000e0000ULL, 0x0000003906397220ULL, 0x044fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000003b063b7220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003d063d7220ULL, 0x040fe20000410000ULL,
0x0000003406347220ULL, 0x040fe20000410000ULL, 0x0000001806187220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x000fe20000410000ULL, 0x0000002a0d2a7220ULL, 0x048fe20000410000ULL,
0x0000002b0d2b7220ULL, 0x040fe20000410000ULL, 0x0000002e0d2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0d2f7220ULL, 0x040fe20000410000ULL, 0x000000320d327220ULL, 0x040fe20000410000ULL,
0x000000330d337220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x000000220d227220ULL, 0x040fe20000410000ULL,
0x000000230d237220ULL, 0x040fe20000410000ULL, 0x000000260d267220ULL, 0x040fe20000410000ULL,
0x000000270d277220ULL, 0x040fe20000410000ULL, 0x000000160d167220ULL, 0x040fe20000410000ULL,
0x000000170d177220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000100007027824ULL, 0x000fe200078e0202ULL, 0x000000181918723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001c1d1c723eULL, 0x000fe400000000ffULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fc400000000ffULL, 0x0000001a1b19723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x000000262726723eULL, 0x000fe400000000ffULL, 0x000000010300780cULL, 0x000fe40003f05270ULL,
0x0000000200047812ULL, 0x008fc400078ec0ffULL, 0x00000002ff297819ULL, 0x000fe40000011600ULL,
0x0000000204067811ULL, 0x040fe400078ff8ffULL, 0x00000001ff057819ULL, 0x000fe40000011604ULL,
0x00000004040e7811ULL, 0x000fe400078ff8ffULL, 0x0000000800377811ULL, 0x000fe400078ff0ffULL,
0x0000000604127811ULL, 0x000fc400078ff8ffULL, 0x00000007060a7812ULL, 0x000fe400078e7829ULL,
0x0000000705047812ULL, 0x000fe400078e7829ULL, 0x000000070e107812ULL, 0x000fe200078e7829ULL,
0x0000000829117824ULL, 0x040fe200078e020aULL, 0x0000000712287812ULL, 0x000fe200078e7829ULL,
0x00000008000a7824ULL, 0x000fe200078e00ffULL, 0x0000000705057812ULL, 0x000fe200078e7837ULL,
0x00000008290d7824ULL, 0x040fe200078e0204ULL, 0x0000000706067812ULL, 0x000fe200078e7837ULL,
0x0000000829137824ULL, 0x000fe200078e0210ULL, 0x000000070e0e7812ULL, 0x000fe200078e7837ULL,
0x00000008372d7824ULL, 0x040fe200078e0205ULL, 0x0000000712127812ULL, 0x000fe200078e7837ULL,
0x0000000837317824ULL, 0x040fe200078e0206ULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000837357824ULL, 0x000fe200078e020eULL, 0x000000392c04723eULL, 0x000fe200000000ffULL,
0x0000000829297824ULL, 0x000fe200078e0228ULL, 0x0000003b3005723eULL, 0x000fe200000000ffULL,
0x0000000837377824ULL, 0x000fe200078e0212ULL, 0x00000020210e723eULL, 0x000fe200000000ffULL,
0x0000080009067824ULL, 0x000fe200078e0202ULL, 0x0000541004387816ULL, 0x000fc40000000005ULL,
0x0000763204397816ULL, 0x000fe20000000005ULL, 0x000000100d0d7824ULL, 0x100fe200078e0206ULL,
0x000000141512723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0206ULL,
0x0000002e2f15723eULL, 0x000fe200000000ffULL, 0x0000001013137824ULL, 0x100fe400078e0206ULL,
0x000000102d2d7824ULL, 0x100fe200078e0206ULL, 0x000054102a147816ULL, 0x140fe20000000015ULL,
0x0000001031317824ULL, 0x100fe200078e0206ULL, 0x000076322a157816ULL, 0x000fe20000000015ULL,
0x0000001029297824ULL, 0x000fc400078e0206ULL, 0x0000001035357824ULL, 0x100fe400078e0206ULL,
0x0000001037377824ULL, 0x000fe400078e0206ULL, 0x000000010d0d7824ULL, 0x000fe400078e020aULL,
0x000000010a117824ULL, 0x040fe400078e0211ULL, 0x000000010a137824ULL, 0x040fe200078e0213ULL,
0x000000380d007388ULL, 0x0007e20000000a00ULL, 0x000000010a2d7824ULL, 0x000fc400078e022dULL,
0x000000010a317824ULL, 0x040fe400078e0231ULL, 0x000000010a297824ULL, 0x040fe400078e0229ULL,
0x000000010a357824ULL, 0x040fe400078e0235ULL, 0x000000010a377824ULL, 0x000fe200078e0237ULL,
0x0000003d340a723eULL, 0x000fe200000000ffULL, 0x00000020090d7824ULL, 0x008fc600078e0200ULL,
0x000054100a047816ULL, 0x140fe40000000018ULL, 0x000076320a057816ULL, 0x000fe20000000018ULL,
0x000000100d107824ULL, 0x000fe200078e0202ULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe20000000019ULL, 0x0000000411007388ULL, 0x0007e40000000a00ULL,
0x000054101c047816ULL, 0x148fe4000000000eULL, 0x000076321c057816ULL, 0x000fca000000000eULL,
0x0000000413007388ULL, 0x0007e40000000a00ULL, 0x0000541024047816ULL, 0x148fe40000000012ULL,
0x0000763224057816ULL, 0x000fe40000000012ULL, 0x000000161713723eULL, 0x000fc600000000ffULL,
0x0000000429007388ULL, 0x0007e20000000a00ULL, 0x0000541026127816ULL, 0x140fe40000000013ULL,
0x0000763226137816ULL, 0x000fe20000000013ULL, 0x000000142d007388ULL, 0x000fe80000000a00ULL,
0x0000001831007388ULL, 0x000fe20000000a00ULL, 0x000054101e047816ULL, 0x148fe40000000022ULL,
0x000076321e057816ULL, 0x000fca0000000022ULL, 0x0000000435007388ULL, 0x000fe80000000a00ULL,
0x0000001237007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000010147984ULL, 0x000ee80000000c00ULL, 0x00040000101c7984ULL, 0x000f280000000c00ULL,
0x0008000010187984ULL, 0x000f680000000c00ULL, 0x000c000010207984ULL, 0x000f620000000c00ULL,
0x200000ff17177230ULL, 0x008fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x010fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x020fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe40000000000ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x002fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000001410007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c10007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002400dc8947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ee20000002700ULL, 0x00008400ff0a7b82ULL, 0x000ee20000000800ULL,
0x000004000f1e7824ULL, 0x002fe200078e00ffULL, 0x0000000109ff7812ULL, 0x000fe2000780f80fULL,
0x0000000000117919ULL, 0x000ee20000002600ULL, 0x0000040000207802ULL, 0x000fe40000000f00ULL,
0x000004001e1e7812ULL, 0x000fe200078ee2ffULL, 0x0000000000157919ULL, 0x000e620000008800ULL,
0x00009200ff1f7b82ULL, 0x000f300000000800ULL, 0x00009800ff047b82ULL, 0x000f620000000a00ULL,
0x0000000a0e0e7224ULL, 0x008fc400078e0211ULL, 0x0000000010107984ULL, 0x000ee20000000c00ULL,
0x0000000a030a7224ULL, 0x000fe200078e02ffULL, 0x0000065415207816ULL, 0x002fe20000000020ULL,
0x000000030e1c7224ULL, 0x000fe400078e02ffULL, 0x0000001f0a1f7224ULL, 0x010fe400078e02ffULL,
0x000000011c187824ULL, 0x000fc600078e020bULL, 0x000007ff1f1d7811ULL, 0x040fe400078e40ffULL,
0x01ffffff1f1f7812ULL, 0x000fe400078ec0ffULL, 0x000000181d0b7211ULL, 0x000fca00078fa8ffULL,
0x000008000b0a7825ULL, 0x020fc600078e0004ULL, 0x0000001e0a167210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e060bULL, 0x000000ff0000720cULL, 0x000fe20000725670ULL,
0x000000100d167825ULL, 0x000fe200078e0016ULL, 0x0000000000380947ULL, 0x000ff60003800000ULL,
0x00009800ff147b82ULL, 0x000e620000000a00ULL, 0x0000001000197824ULL, 0x000fe200078e00ffULL,
0x00000001ff1a7819ULL, 0x000fe20000011600ULL, 0x00000001180d7824ULL, 0x000fc600078e021fULL,
0x0000007019197812ULL, 0x000fe400078ec0ffULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000080180a7825ULL, 0x002fc800078e0014ULL, 0x000000800d147825ULL, 0x000fe200078e0014ULL,
0x0000000a1a0a7210ULL, 0x140fe40007a1e019ULL, 0x000000141a147210ULL, 0x000fe40007c7e019ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x00000015ff157210ULL, 0x000fc60001fe84ffULL,
0x000000080a007986ULL, 0x0003e8000c10190aULL, 0x0000000c14007986ULL, 0x0003e4000c10190aULL,
0x0000001016007986ULL, 0x0087e2000c101d0aULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000004c1947ULL, 0x000fea0003800000ULL, 0x00009600ff0a7b82ULL, 0x002e620000000a00ULL,
0xffffffff030d7836ULL, 0x000fe40000000000ULL, 0x000000040e0a7825ULL, 0x002fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x0000000d0a0a79a8ULL, 0x000f2800099ee1caULL, 0x00000000ff00798fULL, 0x010fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000d0a00720cULL, 0x000fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000020087984ULL, 0x002e640000000000ULL, 0x000000ff0800720cULL, 0x002fda0003f05270ULL,
0x0000002000d08947ULL, 0x000fea0003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011600ULL, 0x000000011c0d7836ULL, 0x040fe40000000000ULL,
0x000000801c0a7825ULL, 0x100fe200078e0004ULL, 0x0000000c0c0e7812ULL, 0x000fe400078ec0ffULL,
0x00000070081b7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fc600078e0004ULL,
0x0000000a0e107210ULL, 0x148fe4000791e01bULL, 0x0000000c0e0a7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff117210ULL, 0x000fe400007e24ffULL, 0x0000000dff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000a10087981ULL, 0x000368000c1e1900ULL, 0x0000000a0a0b7981ULL, 0x000362000c1e1900ULL,
0x000000020300780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x000000021c0d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0004ULL,
0x0000000c0e0c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fcc00007e24ffULL,
0x0000000a0c0d7981ULL, 0x000362000c1e1900ULL, 0x000000040300780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x000000031c117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e0004ULL, 0x000000100e107210ULL, 0x000fc8000791e01bULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000a10137981ULL, 0x000362000c1e1900ULL,
0x000000040300780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x000000041c117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e0004ULL,
0x000000100e107210ULL, 0x000fc8000791e01bULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000a10157981ULL, 0x000362000c1e1900ULL, 0x000000060300780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x000000051c117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e0004ULL, 0x000000100e107210ULL, 0x000fc8000791e01bULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000a10177981ULL, 0x000362000c1e1900ULL,
0x000000060300780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000080300780cULL, 0x000fe20003f06070ULL, 0x000000061c117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e0004ULL, 0x000000100e107210ULL, 0x000fca0007a3e01bULL,
0x000000071c190836ULL, 0x000fe20000000000ULL, 0x00000011ff117210ULL, 0x000fc60000fe44ffULL,
0x0000008019040825ULL, 0x000fe400078e0004ULL, 0x0000000a10197981ULL, 0x000362000c1e1900ULL,
0x000000040e040210ULL, 0x000fc80007c7e01bULL, 0x00000005ff050210ULL, 0x000fca0001fe84ffULL,
0x0000000a041b0981ULL, 0x000368000c1e1900ULL, 0x0000000703047836ULL, 0x002fca0000000000ULL,
0x00000003ff0e7819ULL, 0x000fc80000011604ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009800ff047b82ULL, 0x000e620000000a00ULL,
0x000000ffff127224ULL, 0x008fe200078e001cULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff217224ULL, 0x020fe200078e0008ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000403007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050e007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x0000000804067890ULL, 0x000fe2000fffe03fULL, 0x0000002108087209ULL, 0x000fe20007810000ULL,
0x0000000104077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000812117836ULL, 0x000fc60000000000ULL, 0x000000700a217812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x002fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e021ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000a10217981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x0000000904067890ULL, 0x000fe2000fffe03fULL, 0x0000000b08087209ULL, 0x000fe20007810000ULL,
0x0000000204077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x00000009120b7836ULL, 0x000fc60000000000ULL, 0x000000700a117812ULL, 0x002fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0c0a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fcc0000fe64ffULL,
0x0000000a0a0b7981ULL, 0x000366000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a04067890ULL, 0x000fe2000fffe03fULL, 0x0000000d08087209ULL, 0x000fe20007810000ULL,
0x0000000304077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x0000000a120d7836ULL, 0x000fc60000000000ULL, 0x000000700a117812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0004ULL, 0x0000000c10107812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fcc0000fe64ffULL,
0x0000000a0c0d7981ULL, 0x000366000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b04067890ULL, 0x000fe2000fffe03fULL, 0x0000001308087209ULL, 0x000fe20007810000ULL,
0x0000000404077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000b12117836ULL, 0x000fc60000000000ULL, 0x000000700a137812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000a10137981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c04067890ULL, 0x000fe2000fffe03fULL, 0x0000001508087209ULL, 0x000fe20007810000ULL,
0x0000000504077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000c12117836ULL, 0x000fc60000000000ULL, 0x000000700a157812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000a10157981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d04067890ULL, 0x000fe2000fffe03fULL, 0x0000001708087209ULL, 0x000fe20007810000ULL,
0x0000000604077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000d12117836ULL, 0x000fc60000000000ULL, 0x000000700a177812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e017ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000a10177981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e04067890ULL, 0x000fe2000fffe03fULL, 0x0000001908087209ULL, 0x000fe20007810000ULL,
0x0000000704077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000e12117836ULL, 0x000fc60000000000ULL, 0x000000700a197812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e019ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000a10197981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f04067890ULL, 0x000fe2000fffe03fULL, 0x0000001b08087209ULL, 0x000fca0007810000ULL,
0x0000000603007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000f12117836ULL, 0x000fc60000000000ULL, 0x000000700a1b7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007a3e01bULL, 0x00000011ff117210ULL, 0x000fca0000fe44ffULL,
0x0000000a101b7981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x0000000812127836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000007919ULL, 0x000f240000000000ULL, 0x0000001000047824ULL, 0x012fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fc80000011600ULL, 0x0000007004057812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000200a057210ULL, 0x000fca0007ffe005ULL,
0x0000000805007388ULL, 0x0203e40000000800ULL, 0x00009800ff0c7b82ULL, 0x000f220000000a00ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000001090e7824ULL, 0x000fe200078e021cULL,
0x00000002ff087819ULL, 0x002fe2000001160fULL, 0x0000001000217824ULL, 0x040fe200078e00ffULL,
0x00000001ff227819ULL, 0x000fe20000011600ULL, 0x0000002000137836ULL, 0x008fe20000000000ULL,
0x0000000108087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x0000000e1d057211ULL, 0x000fe400078fa8ffULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000007021217812ULL, 0x000fe400078ec0ffULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000c22227812ULL, 0x000fe200078ec0ffULL, 0x00000200090a8824ULL, 0x140fe200078e0220ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000020009108824ULL, 0x000fe200078e0220ULL,
0x0000002022237210ULL, 0x000fe20007ffe021ULL, 0x00000100070b8824ULL, 0x040fe200078e020aULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000010007118824ULL, 0x000fe200078e0210ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000008008158824ULL, 0x000fe200078e020bULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000002000f0b7824ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000080005047825ULL, 0x010fe200078e000cULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x000008000b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008008178824ULL, 0x000fe200078e0211ULL,
0x0000001e04047210ULL, 0x000fe20007f3e0ffULL, 0x0000200009087824ULL, 0x000fe200078e0220ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x000000011f118824ULL, 0x000fe200078e020eULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000100007087824ULL, 0x000fe200078e0208ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000000030900720cULL, 0x000fe20003f26070ULL, 0x00000001080b7824ULL, 0x000fe200078e020bULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000000800e0e8825ULL, 0x000fe200078e000cULL,
0x0000000023237984ULL, 0x000e620000000800ULL, 0x00000000003e7805ULL, 0x000fc4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000080110c8825ULL, 0x000fe200078e000cULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001000117824ULL, 0x000fe400078e020bULL, 0x00000010130a7825ULL, 0x000fc800078e0004ULL,
0x0000001000047825ULL, 0x000fc800078e0004ULL, 0x00000010000c8825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x0007e6000b901c4aULL,
0x0000001000158824ULL, 0x040fe200078e0215ULL, 0x003800000a117faeULL, 0x0007e2000b901c4aULL,
0x00000010000e8825ULL, 0x000fc600078e000eULL, 0x045800000c158faeULL, 0x0007e2000b901c4aULL,
0x0000001000178824ULL, 0x000fca00078e0217ULL, 0x041800000e178faeULL, 0x0007e8000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800641947ULL, 0x000fea0003800000ULL,
0x00009800ff047b82ULL, 0x008ee20000000a00ULL, 0x00000003ff0a7819ULL, 0x000fe20000011600ULL,
0x00000200094c7824ULL, 0x000fe200078e0220ULL, 0xfffffff8ff0b7812ULL, 0x000fe200078ee200ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x000000030a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x00000002ff4b7819ULL, 0x000fe20000011600ULL,
0x000000080b0d7836ULL, 0x040fe20000000000ULL, 0x000000040a0c7812ULL, 0x000fe200078efcffULL,
0x000000080b467824ULL, 0x000fe200078e00ffULL, 0x000000070a457812ULL, 0x000fe200078e780bULL,
0x000000080d4a7824ULL, 0x000fe200078e00ffULL, 0x000000070a477812ULL, 0x000fe200078e780dULL,
0x00000100074c7824ULL, 0x000fe200078e024cULL, 0x000000070c0b7812ULL, 0x000fe200078e780bULL,
0x000000084b487836ULL, 0x000fe20000000000ULL, 0x000000070c0d7812ULL, 0x000fc400078e780dULL,
0x0000004645457212ULL, 0x000fe400078efcffULL, 0x0000004a47477212ULL, 0x000fe400078efcffULL,
0x000000460b467212ULL, 0x000fe400078efcffULL, 0x0000004a0d4a7212ULL, 0x008fce00078efcffULL,
0x0000000212497836ULL, 0x000fca0000000000ULL, 0x000000034900720cULL, 0x000fda0003f06070ULL,
0x00000000008c0947ULL, 0x000fea0003800000ULL, 0x000000011c107824ULL, 0x000fe200078e0249ULL,
0x000000070000780cULL, 0x040fe20003f24070ULL, 0x00000400490c7824ULL, 0x000fe400078e00ffULL,
0x0000002000197836ULL, 0x000fe20000000000ULL, 0x000000101d0b7211ULL, 0x000fe400078fa8ffULL,
0x000008000c0d7812ULL, 0x000fc600078ec0ffULL, 0x000008000b0a7825ULL, 0x000fc800078e0004ULL,
0x0000020009149824ULL, 0x140fe200078e0220ULL, 0x0000001e0a0e7210ULL, 0x000fe20007f1e0ffULL,
0x00000200090c9824ULL, 0x000fe200078e0220ULL, 0x00000001ff0a7819ULL, 0x000fe20000011649ULL,
0x00000100074c9824ULL, 0x000fe400078e0214ULL, 0x000000011f119824ULL, 0x000fe200078e0210ULL,
0x000000010a177812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe400000e060bULL,
0x00000001080d7824ULL, 0x000fc400078e020dULL, 0x0000008017159824ULL, 0x000fe400078e024cULL,
0x00000080100a9825ULL, 0x000fc800078e0004ULL, 0x00000100074c9824ULL, 0x000fe400078e020cULL,
0x0000008011109825ULL, 0x000fc800078e0004ULL, 0x0000001000137824ULL, 0x000fe400078e020dULL,
0x0000008017179824ULL, 0x000fe400078e024cULL, 0x00000010190c7825ULL, 0x000fc800078e000eULL,
0x00000010000e7825ULL, 0x000fc800078e000eULL, 0x0000001000109825ULL, 0x040fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e137faeULL, 0x0007e6000b901c4aULL,
0x0000001000159824ULL, 0x040fe200078e0215ULL, 0x003800000c137faeULL, 0x0007e2000b901c4aULL,
0x00000010000a9825ULL, 0x000fc600078e000aULL, 0x0458000010159faeULL, 0x0007e2000b901c4aULL,
0x0000001000179824ULL, 0x000fca00078e0217ULL, 0x041800000a179faeULL, 0x0007e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040120a7824ULL, 0x008fca00078e00ffULL,
0x000000800a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000004c210b7210ULL, 0x000fe20007ffe00aULL,
0x00000400120a7824ULL, 0x000fc800078e00ffULL, 0x00000001224d7824ULL, 0x000fe200078e020bULL,
0x000008000a0b7812ULL, 0x000fc800078ec0ffULL, 0x00000180080b7810ULL, 0x000fe20007ffe00bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180004d167984ULL, 0x000ee20000000800ULL,
0x0000001046107824ULL, 0x100fe400078e020bULL, 0x00000010450c7824ULL, 0x100fe200078e020bULL,
0x004580004d4e7984ULL, 0x000fe20000000800ULL, 0x0000001047147824ULL, 0x100fe400078e020bULL,
0x000000104a187824ULL, 0x000fe200078e020bULL, 0x000000001010783bULL, 0x000f280000000200ULL,
0x000000000c0c783bULL, 0x000f680000000200ULL, 0x000000001818783bULL, 0x000f620000000200ULL,
0x00000016230a7221ULL, 0x00afc60000010100ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x3fb8aa3b0a4f7820ULL, 0x000fe20000410000ULL, 0x30000011ff527230ULL, 0x010fca0000004100ULL,
0x0000004f004f7308ULL, 0x000ee20000000800ULL, 0x20000013ff517230ULL, 0x000fe40000004100ULL,
0x2000000cff0a7230ULL, 0x020fe40000004100ULL, 0x3000000cff0b7230ULL, 0x000fe40000004100ULL,
0x3000000eff4d7230ULL, 0x000fe40000004100ULL, 0x30000013ff547230ULL, 0x000fe40000004100ULL,
0x20000019ff597230ULL, 0x004fc40000004100ULL, 0x30000019ff587230ULL, 0x000fe40000004100ULL,
0x0000004e4f5a7220ULL, 0x008fe20000410000ULL, 0x20000011ff4f7230ULL, 0x000fe40000004100ULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x000000435a437221ULL, 0x000fe20000010000ULL,
0x00001f4b5a5c7589ULL, 0x000ea200000e0000ULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x2000000eff4e7230ULL, 0x000fe20000004100ULL, 0x00001f485a5d7589ULL, 0x000ee200000e0000ULL,
0x2000000dff0c7230ULL, 0x000fc40000004100ULL, 0x2000000fff0e7230ULL, 0x000fe40000004100ULL,
0x20000010ff507230ULL, 0x000fe40000004100ULL, 0x20000018ff577230ULL, 0x000fe40000004100ULL,
0x20000016ff567230ULL, 0x002fe40000004100ULL, 0x30000016ff557230ULL, 0x000fe40000004100ULL,
0x20000014ff137230ULL, 0x000fc40000004100ULL, 0x20000015ff537230ULL, 0x000fe40000004100ULL,
0x20000017ff167230ULL, 0x000fe40000004100ULL, 0x2000001aff197230ULL, 0x000fe40000004100ULL,
0x0000005c122d7223ULL, 0x084fe2000001002dULL, 0x000000ffff127224ULL, 0x000fe400078e0049ULL,
0x0000005c0a277223ULL, 0x000fe20000010027ULL, 0x2000001bff5b7230ULL, 0x000fc40000004100ULL,
0x0000005c0b267223ULL, 0x080fe20000010026ULL, 0x3000000dff0d7230ULL, 0x000fe20000004100ULL,
0x000000031200720cULL, 0x000fe20003f06070ULL, 0x3000000fff0f7230ULL, 0x000fe40000004100ULL,
0x0000005c0c257223ULL, 0x080fe20000010025ULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000005c0d247223ULL, 0x080fe20000010024ULL, 0x30000014ff147230ULL, 0x000fe40000004100ULL,
0x0000005c4e3f7223ULL, 0x000fe2000001003fULL, 0x30000015ff157230ULL, 0x000fc40000004100ULL,
0x0000005c4d3c7223ULL, 0x080fe2000001003cULL, 0x30000017ff177230ULL, 0x000fe40000004100ULL,
0x0000005c0e3b7223ULL, 0x080fe2000001003bULL, 0x30000018ff187230ULL, 0x000fe40000004100ULL,
0x0000005c0f387223ULL, 0x080fe20000010038ULL, 0x3000001aff1a7230ULL, 0x000fe40000004100ULL,
0x0000005c50377223ULL, 0x000fe20000010037ULL, 0x3000001bff1b7230ULL, 0x000fc40000004100ULL,
0x0000005c10357223ULL, 0x080fe20000010035ULL, 0x0000005c4f347223ULL, 0x080fe20000010034ULL,
0x0000005c52317223ULL, 0x080fe20000010031ULL, 0x0000005c11307223ULL, 0x080fe20000010030ULL,
0x0000005c512c7223ULL, 0x080fe2000001002cULL, 0x0000005c54297223ULL, 0x000fe20000010029ULL,
0x0000005d13287223ULL, 0x088fe20000010028ULL, 0x0000005d14417223ULL, 0x080fe20000010041ULL,
0x0000005d53407223ULL, 0x080fe20000010040ULL, 0x0000005d153e7223ULL, 0x080fe2000001003eULL,
0x0000005d563d7223ULL, 0x080fe2000001003dULL, 0x0000005d553a7223ULL, 0x080fe2000001003aULL,
0x0000005d16397223ULL, 0x080fe20000010039ULL, 0x0000005d17427223ULL, 0x080fe20000010042ULL,
0x0000005d57367223ULL, 0x080fe20000010036ULL, 0x0000005d18337223ULL, 0x080fe20000010033ULL,
0x0000005d59327223ULL, 0x080fe20000010032ULL, 0x0000005d582f7223ULL, 0x080fe2000001002fULL,
0x0000005d192e7223ULL, 0x080fe2000001002eULL, 0x0000005d1a2b7223ULL, 0x080fe2000001002bULL,
0x0000005d5b2a7223ULL, 0x080fe2000001002aULL, 0x0000005d1b447223ULL, 0x000fe20000010044ULL,
0xfffffff400f48947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001000037824ULL, 0x010fe200078e00ffULL,
0x00000001ff047819ULL, 0x008fe20000011600ULL, 0x0000498020007836ULL, 0x000fc60000000000ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000004007210ULL, 0x000fe20007ffe003ULL, 0x0000000000200947ULL, 0x000fec0003800000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x0000008009207824ULL, 0x000fe400078e0220ULL,
0x0000001003047824ULL, 0x008fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011603ULL,
0x0000007004037812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000002005207210ULL, 0x000fca0007ffe003ULL, 0x0049804320007388ULL, 0x0007e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000037984ULL, 0x000f280000000800ULL,
0x0000800000047984ULL, 0x000f620000000800ULL, 0x00000003ff037221ULL, 0x010fc80000010000ULL,
0x0000000403037221ULL, 0x020fc80000010000ULL, 0x0180000003047836ULL, 0x000fca0000000000ULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0003ULL, 0x0000a3f000047802ULL, 0x000fce0000000f00ULL,
0x00000058006c7944ULL, 0x00efea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000300047308ULL, 0x000f240000001000ULL,
0xbf80000003007423ULL, 0x010fc80000000004ULL, 0x800000ff00057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fce0000000004ULL, 0x0000000000007919ULL, 0x000f240000000000ULL,
0x00000002ff117819ULL, 0x110fe40000011600ULL, 0x00000008000b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff0a7819ULL, 0x000fe20000011600ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f1104087589ULL, 0x000f2200000e0000ULL, 0xfffffff8ff177812ULL, 0x000fc400078ee200ULL,
0x000000030a0a7812ULL, 0x000fe200078ec0ffULL, 0x00001f0b040b7589ULL, 0x000b6400000e0000ULL,
0x00000008171b7836ULL, 0x040fe20000000000ULL, 0x000000040a167812ULL, 0x000fe200078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0x000000070a197812ULL, 0x000fe400078e7817ULL, 0x000000070a1d7812ULL, 0x000fe200078e781bULL,
0x000000081b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000716177812ULL, 0x000fc400078e7817ULL,
0x00000007161b7812ULL, 0x000fe400078e781bULL, 0x0000001419197212ULL, 0x080fe400078efcffULL,
0x0000001417177212ULL, 0x000fe400078efcffULL, 0x0000000a1d1d7212ULL, 0x000fe200078efcffULL,
0x00000027080c7220ULL, 0x052fe20000410000ULL, 0x0000002608037220ULL, 0x040fe20000410000ULL,
0x00000025080d7220ULL, 0x040fe20000410000ULL, 0x0000002408247220ULL, 0x040fe20000410000ULL,
0x0000003f080e7220ULL, 0x040fe20000410000ULL, 0x0000003c08057220ULL, 0x040fe20000410000ULL,
0x0000003b080f7220ULL, 0x040fe20000410000ULL, 0x0000003808387220ULL, 0x040fe20000410000ULL,
0x0000003708107220ULL, 0x040fe20000410000ULL, 0x0000003508357220ULL, 0x040fe20000410000ULL,
0x0000003408117220ULL, 0x040fe20000410000ULL, 0x0000003108047220ULL, 0x060fe20000410000ULL,
0x0000003008127220ULL, 0x040fe20000410000ULL, 0x0000002d082d7220ULL, 0x040fe20000410000ULL,
0x0000002c08137220ULL, 0x040fe20000410000ULL, 0x0000002908087220ULL, 0x000fe20000410000ULL,
0x000000280b287220ULL, 0x048fe20000410000ULL, 0x000000410b417220ULL, 0x040fe20000410000ULL,
0x000000400b407220ULL, 0x040fe20000410000ULL, 0x0000003e0b157220ULL, 0x040fe20000410000ULL,
0x0000003d0b3d7220ULL, 0x040fe20000410000ULL, 0x0000003a0b3a7220ULL, 0x040fe20000410000ULL,
0x000000390b397220ULL, 0x040fe20000410000ULL, 0x000000420b427220ULL, 0x040fe20000410000ULL,
0x000000360b367220ULL, 0x040fe20000410000ULL, 0x000000330b337220ULL, 0x040fe20000410000ULL,
0x000000320b327220ULL, 0x040fe20000410000ULL, 0x0000002f0b2f7220ULL, 0x040fe20000410000ULL,
0x0000002e0b2e7220ULL, 0x040fe20000410000ULL, 0x0000002b0b2b7220ULL, 0x040fe20000410000ULL,
0x0000002a0b2a7220ULL, 0x040fe20000410000ULL, 0x000000440b0b7220ULL, 0x000fe20000410000ULL,
0x0000000a1b1b7212ULL, 0x000fe200078efcffULL, 0x00000010190a7824ULL, 0x100fe200078e0206ULL,
0x0000000c030c723eULL, 0x000fe200000000ffULL, 0x0000001017187824ULL, 0x100fe200078e0206ULL,
0x0000000d240d723eULL, 0x000fe200000000ffULL, 0x000000101d197824ULL, 0x100fe200078e0206ULL,
0x0000000e050e723eULL, 0x000fe200000000ffULL, 0x000000101b067824ULL, 0x000fe200078e0206ULL,
0x0000000f380f723eULL, 0x000fe200000000ffULL, 0x0000002009037824ULL, 0x000fe200078e0200ULL,
0x000000103510723eULL, 0x000fc400000000ffULL, 0x000000110411723eULL, 0x000fe200000000ffULL,
0x0000000c0a007844ULL, 0x000fe20000000200ULL, 0x000000122d12723eULL, 0x000fe200000000ffULL,
0x0000001003037824ULL, 0x000fe200078e0202ULL, 0x000000130813723eULL, 0x000fe400000000ffULL,
0x000000284114723eULL, 0x000fe400000000ffULL, 0x000000401515723eULL, 0x000fe200000000ffULL,
0x0000001018007844ULL, 0x000fe20000000200ULL, 0x0000003d3a16723eULL, 0x000fc400000000ffULL,
0x000000394217723eULL, 0x000fe400000000ffULL, 0x000000322f2d723eULL, 0x000fe400000000ffULL,
0x00000036332c723eULL, 0x000fe200000000ffULL, 0x0000001419007844ULL, 0x000fe20000000200ULL,
0x0000002e2b2e723eULL, 0x000fe400000000ffULL, 0x0000002a0b2f723eULL, 0x000fca00000000ffULL,
0x0000002c06007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000031c7984ULL, 0x000e680000000c00ULL, 0x0004000003247984ULL, 0x000ee80000000c00ULL,
0x0008000003207984ULL, 0x000f280000000c00ULL, 0x000c000003287984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x002fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x020fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001c03007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002403007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000127836ULL, 0x008fe20000000000ULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff047819ULL, 0x000fe20000011612ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000711037812ULL, 0x002fe400078e4800ULL, 0x0000000704057812ULL, 0x000fe400078e4812ULL,
0x0ffffff803037812ULL, 0x000fc400078ef800ULL, 0x0ffffff805057812ULL, 0x000fc600078ef812ULL,
0x0000001003037824ULL, 0x100fe400078e0202ULL, 0x0000001005057824ULL, 0x000fc600078e0202ULL,
0x0000000003087984ULL, 0x0003680000000c00ULL, 0x00000000050c7984ULL, 0x0003620000000c00ULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000806027824ULL, 0x048fe400078e00ffULL,
0x0000000806137824ULL, 0x000fc600078e00ffULL, 0xfffffff802027812ULL, 0x000fe200078ee211ULL,
0x0000000807117824ULL, 0x040fe200078e00ffULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x0000000807137824ULL, 0x000fe200078e00ffULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404067c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe20000000a00ULL,
0xfffffff811077812ULL, 0x000fe200078ee200ULL, 0x000000ffff037224ULL, 0x002fe200000e06ffULL,
0x0000000410027c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff057224ULL, 0x004fe200008e06ffULL,
0x0000000406047c11ULL, 0x000fc4000f8240ffULL, 0x0000000510037c11ULL, 0x000fe400080f4403ULL,
0x0000000506057c11ULL, 0x000fe400088f4405ULL, 0xfffffff813117812ULL, 0x000fe200078ee212ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x020fe8000c101d0aULL, 0x0000000c04007986ULL, 0x000fe2000c101d0aULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff057819ULL, 0x000fe2000001160fULL,
0x00009400ff147b82ULL, 0x000e620000000a00ULL, 0x00000001ff097424ULL, 0x000fc600078e00ffULL,
0x000000020e047824ULL, 0x000fe200078e0205ULL, 0x00f60009021079a7ULL, 0x0004a8000850003fULL,
0x0000000404007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff068b82ULL, 0x000ee20000000800ULL,
0x000000020d058824ULL, 0x000fe200078e00ffULL, 0x0000000a140b7981ULL, 0x00256c000c1e9900ULL,
0x00008c00ff128b82ULL, 0x000e620000000a00ULL, 0x0000000605058224ULL, 0x008fc800078e0204ULL,
0x0000000405128825ULL, 0x002fc800078e0012ULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000a12058981ULL, 0x000ee2000c1e1900ULL, 0x000000010e067836ULL, 0x000fca0000000000ULL,
0x0000000506007c0cULL, 0x000fe2000bf06070ULL, 0x000000400f077824ULL, 0x000fe400078e00ffULL,
0x0000008017067824ULL, 0x000fe400078e00ffULL, 0x000001000e177824ULL, 0x000fe400078e0207ULL,
0x0000008023087824ULL, 0x000fc600078e00ffULL, 0x0000004006317812ULL, 0x000fe200078ef817ULL,
0x00000008050c7224ULL, 0x008fe400078e02ffULL, 0x0000000400cc8947ULL, 0x004fea0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe20000011600ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000917127c48ULL, 0x000fe4000ffe0000ULL, 0x000000300a2f7812ULL, 0x000fe200078ec0ffULL,
0x000000012d137824ULL, 0x140fe400078e0231ULL, 0x000000082d1d7836ULL, 0x040fe40000000000ULL,
0x000000102d157836ULL, 0x000fe20000000000ULL, 0x000000130c1f7210ULL, 0x000fe20007f1e0ffULL,
0x000000011d137824ULL, 0x000fc400078e0231ULL, 0x0000000112187824ULL, 0x000fe400078e0a17ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x000000130c207210ULL, 0x000fe20007f3e0ffULL,
0x0000000131177824ULL, 0x000fe200078e0215ULL, 0x000000061f1a7c11ULL, 0x000fe2000f8038ffULL,
0x000000182d237836ULL, 0x000fe40000000000ULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x000000071f1f7c11ULL, 0x000fe200080f3c12ULL, 0x0000000131137824ULL, 0x000fe200078e0223ULL,
0x000000170c177210ULL, 0x000fe20007f5e0ffULL, 0x000000041d227824ULL, 0x000fe200078e00ffULL,
0x0000000620147c11ULL, 0x040fe2000f8038ffULL, 0x000000202d257836ULL, 0x000fe20000000000ULL,
0x000000130c137210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000000720207c11ULL, 0x000fe200080f3c19ULL, 0x0000000131277824ULL, 0x000fe200078e0225ULL,
0x0000000617167c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00000003ff197819ULL, 0x000fe20000011600ULL, 0x000000282d297836ULL, 0x000fe20000000000ULL,
0x0000000717177c11ULL, 0x000fe200088f3c12ULL, 0x000020000f127824ULL, 0x000fe200078e0202ULL,
0x0000000319197812ULL, 0x000fe200078e4800ULL, 0x000000302d2b7836ULL, 0x000fe20000000000ULL,
0x00000006131c7c11ULL, 0x000fe2000f8038ffULL, 0x00001000121b7836ULL, 0x000fe20000000000ULL,
0x0ffffffc190a7812ULL, 0x000fc400078ef800ULL, 0x00000007131e7c11ULL, 0x000fe400080f3c1eULL,
0x000000182d00720cULL, 0x0c0fe20003f06070ULL, 0x000000382d2d7836ULL, 0x000fe20000000000ULL,
0x000000181d00720cULL, 0x080fe20003f26070ULL, 0x000000100a1d7824ULL, 0x000fe200078e021bULL,
0x0000001a2f127210ULL, 0x000fe20007f7e0ffULL, 0x00000004151a7824ULL, 0x040fe200078e00ffULL,
0xfffffffc220a7812ULL, 0x000fe400078ee219ULL, 0x000000181500720cULL, 0x080fe20003f46070ULL,
0x000000ffff137224ULL, 0x000fe200018e061fULL, 0x0000002f16167210ULL, 0x000fe20007f9e0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e021bULL, 0x0000002f14147210ULL, 0x000fe20007f7e0ffULL,
0x00000004230a7824ULL, 0x040fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL,
0x000000ffff177224ULL, 0x000fe200020e0617ULL, 0x000000182300720cULL, 0x000fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200018e0620ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121d7faeULL, 0x0003e2000c101c4aULL, 0x000000101a217824ULL, 0x000fe200078e021bULL,
0x000000270c277210ULL, 0x000fc40007f1e0ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL,
0x00000000141f7faeULL, 0x0005e2000c901c4aULL, 0x000000182500720cULL, 0x080fe40003f66070ULL,
0x000000182b00720cULL, 0x080fe20003f26070ULL, 0x0000000016217faeULL, 0x0007e2000d101c4aULL,
0x000000182900720cULL, 0x080fe40003f46070ULL, 0x0000002f1c127210ULL, 0x002fe20007fbe0ffULL,
0x00000001311d7824ULL, 0x000fe400078e022bULL, 0x000000ffff147224ULL, 0x004fe200000e06ffULL,
0x000000182d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff137224ULL, 0x000fc400028e061eULL,
0x000000100a157824ULL, 0x000fe200078e021bULL, 0x0000000627167c11ULL, 0x008fe2000f8c38ffULL,
0x0000000131177824ULL, 0x040fe400078e0229ULL, 0x00000001311f7824ULL, 0x000fe200078e022dULL,
0x0000000727187c11ULL, 0x000fe2000b0f3c14ULL, 0x0000000012157faeULL, 0x0003e2000e101c4aULL,
0x000000170c1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000004250a7824ULL, 0x000fe200078e00ffULL,
0x0000001d0c1a7210ULL, 0x000fe20007f9e0ffULL, 0x000000042b147824ULL, 0x000fe200078e00ffULL,
0x0000001f0c177210ULL, 0x000fe20007fde0ffULL, 0x00000004290c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL, 0x000000042d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x000fc400078ee219ULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee219ULL,
0x000000ffff137224ULL, 0x002fe200028e06ffULL, 0xfffffffc1e127812ULL, 0x000fe200078ee219ULL,
0x000000100a1d7824ULL, 0x100fe200078e021bULL, 0x000000061c197c11ULL, 0x000fe2000f8a38ffULL,
0x000000100c1f7824ULL, 0x100fe400078e021bULL, 0x0000001014217824ULL, 0x000fe200078e021bULL,
0x000000071c1c7c11ULL, 0x000fe2000a8f3c13ULL, 0x00000010121b7824ULL, 0x000fe200078e021bULL,
0x0000002f16127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x000000061a167c11ULL, 0x000fe2000f8838ffULL, 0x000000ffff0a7224ULL, 0x000fc400030e06ffULL,
0x000000ffff137224ULL, 0x000fe200028e0618ULL, 0x0000002f19147210ULL, 0x000fe40007fbe0ffULL,
0x0000000617187c11ULL, 0x040fe4000f8c38ffULL, 0x000000071a0c7c11ULL, 0x000fe2000a0f3c15ULL,
0x000000ffff157224ULL, 0x000fe200028e061cULL, 0x0000002f16167210ULL, 0x000fe20007f9e0ffULL,
0x00000000121d7faeULL, 0x0003e2000d901c4aULL, 0x00000007170a7c11ULL, 0x000fe4000b0f3c0aULL,
0x0000002f18187210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e060cULL,
0x00000000141f7faeULL, 0x0003e6000d101c4aULL, 0x000000ffff197224ULL, 0x000fe200028e060aULL,
0x0000000016217faeULL, 0x0003e8000c901c4aULL, 0x00000000181b7faeULL, 0x0003e2000c101c4aULL,
0x00000004009c7947ULL, 0x000fea0003800000ULL, 0x0000003100137211ULL, 0x040fe200078ff0ffULL,
0x000020000f177824ULL, 0x000fe200078e0202ULL, 0x0000001800147811ULL, 0x040fe200078ff0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x000000130c137210ULL, 0x000fe20007f1e0ffULL,
0x00001000172f7836ULL, 0x000fe20000000000ULL, 0x0000002000167811ULL, 0x000fe200078ff0ffULL,
0x0000000131177824ULL, 0x000fe200078e0214ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x0000000613217c11ULL, 0x000fe2000f8038ffULL,
0x0000000416247824ULL, 0x000fe200078e00ffULL, 0x00000008001e7811ULL, 0x040fe200078ff0ffULL,
0x0000000131197824ULL, 0x000fe200078e0216ULL, 0x0000002800187811ULL, 0x000fe200078ff0ffULL,
0x0000000414227824ULL, 0x000fe200078e00ffULL, 0x0000000315237812ULL, 0x000fc400078e4800ULL,
0x0000001000127811ULL, 0x040fe200078ff0ffULL, 0x00000001311b7824ULL, 0x000fe200078e0218ULL,
0x00000030001a7811ULL, 0x000fe200078ff0ffULL, 0x0000000418267824ULL, 0x000fe200078e00ffULL,
0x00000038001c7811ULL, 0x000fe200078ff0ffULL, 0x0000000412207824ULL, 0x000fe200078e00ffULL,
0x00000007132c7c11ULL, 0x000fe200080f3c2cULL, 0x000000011e137824ULL, 0x040fe200078e0231ULL,
0xfffffffc24187812ULL, 0x000fe200078ee223ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000170c177210ULL, 0x000fe20007f1e0ffULL, 0x000000041a287824ULL, 0x000fe200078e00ffULL,
0x000000130c137210ULL, 0x000fe20007f7e0ffULL, 0x000000041c2a7824ULL, 0x000fe200078e00ffULL,
0x000000190c197210ULL, 0x000fe20007f3e0ffULL, 0x0000000131157824ULL, 0x040fe200078e0212ULL,
0xfffffffc1e127812ULL, 0x000fe200078ee223ULL, 0x00000001311d7824ULL, 0x000fe200078e021aULL,
0xfffffffc261a7812ULL, 0x000fe200078ee223ULL, 0x0000001018297824ULL, 0x100fe200078e022fULL,
0xfffffffc20147812ULL, 0x000fe200078ee223ULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x0000000617187c11ULL, 0x000fe2000f8038ffULL, 0x00000001311f7824ULL, 0x000fe200078e021cULL,
0xfffffffc22167812ULL, 0x000fe200078ee223ULL, 0x000000101a2b7824ULL, 0x100fe200078e022fULL,
0xfffffffc281c7812ULL, 0x000fe200078ee223ULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0xfffffffc2a1e7812ULL, 0x000fe200078ee223ULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0ffffffc23237812ULL, 0x000fe200078ef800ULL, 0x0000001016277824ULL, 0x100fe200078e022fULL,
0x000000150c157210ULL, 0x000fe20007f5e0ffULL, 0x0000001014257824ULL, 0x100fe200078e022fULL,
0x0000001b0c1b7210ULL, 0x000fe20007f7e0ffULL, 0x0000001023317824ULL, 0x100fe200078e022fULL,
0x0000000717247c11ULL, 0x000fe200080f3c24ULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00000006191a7c11ULL, 0x000fe2000f8238ffULL, 0x0000001012237824ULL, 0x100fe200078e022fULL,
0x000000300a177812ULL, 0x000fe200078ec0ffULL, 0x000000101c2d7824ULL, 0x100fe200078e022fULL,
0x0000001d0c1d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x0000001f0c1f7210ULL, 0x000fe20007fbe0ffULL, 0x000000101e2f7824ULL, 0x000fe200078e022fULL,
0x0000000615167c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x0000000613287c11ULL, 0x000fe2000f8c38ffULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x0000000719227c11ULL, 0x000fc400088f3c22ULL, 0x0000002117127210ULL, 0x000fe40007f1e0ffULL,
0x000000061b1c7c11ULL, 0x000fe4000f8238ffULL, 0x0000000715267c11ULL, 0x000fe400090f3c26ULL,
0x00000007132a7c11ULL, 0x000fe2000b0f3c2aULL, 0x000000ffff137224ULL, 0x000fe200000e062cULL,
0x000000061d1e7c11ULL, 0x000fe4000f8438ffULL, 0x000000061f207c11ULL, 0x000fc4000f8638ffULL,
0x000000071b217c11ULL, 0x000fe200088f3c14ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012317faeULL, 0x0003e2000b901c4aULL, 0x0000002817147210ULL, 0x000fe40007f1e0ffULL,
0x000000071d0c7c11ULL, 0x000fe400090f3c0cULL, 0x0000001617167210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e062aULL, 0x000000071f0a7c11ULL, 0x000fe400098f3c0aULL,
0x0000001817187210ULL, 0x000fc40007f5e0ffULL, 0x0000001a171a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000014237faeULL, 0x0003e2000b901c4aULL, 0x0000001c171c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0624ULL, 0x0000001e171e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e0622ULL, 0x0000002017207210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe400008e0626ULL, 0x000000ffff1d7224ULL, 0x000fe400020e0621ULL,
0x000000ffff1f7224ULL, 0x000fe200028e060cULL, 0x0000000016257faeULL, 0x0003e2000b901c4aULL,
0x000000ffff217224ULL, 0x000fc600000e060aULL, 0x0000000018277faeULL, 0x0003e8000b901c4aULL,
0x000000001a297faeULL, 0x0003e8000b901c4aULL, 0x000000001c2b7faeULL, 0x0003e8000b901c4aULL,
0x000000001e2d7faeULL, 0x0003e8000b901c4aULL, 0x00000000202f7faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00f60011020075a7ULL, 0x000ea2000800017fULL,
0x000000200f0a7824ULL, 0x000fc800078e0200ULL, 0x000000100a127824ULL, 0x002fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x1ffffffe0c137812ULL, 0x000fe400078ec0ffULL,
0x000000f012127812ULL, 0x000fe400078ec0ffULL, 0x0000000113157812ULL, 0x000fe400078efcffULL,
0x0000000713137812ULL, 0x000fe400078e780aULL, 0x0000000715157812ULL, 0x000fc600078e780aULL,
0x0000000113137824ULL, 0x000fe400078e0212ULL, 0x0000000112157824ULL, 0x000fe400078e0215ULL,
0x0000001013137824ULL, 0x000fe200078e0202ULL, 0x00000038007c8947ULL, 0x004fec0003800000ULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0x00000000131c7984ULL, 0x000e620000000c00ULL,
0x000000050e007c0cULL, 0x000fc6000bf26070ULL, 0x0000000015187984ULL, 0x000ea20000000c00ULL,
0x000000ffff207224ULL, 0x002fe400078e001cULL, 0x000000ffff1c7224ULL, 0x000fe400078e001dULL,
0x000000ffff217224ULL, 0x000fe400078e001eULL, 0x000000ffff1d7224ULL, 0x000fe400078e001fULL,
0x000000ffff227224ULL, 0x004fe400078e0018ULL, 0x000000ffff237224ULL, 0x000fc400078e001aULL,
0x000000ffff1e7224ULL, 0x000fe400078e0019ULL, 0x000000ffff1f7224ULL, 0x000fe200078e001bULL,
0x0000002013007388ULL, 0x0003e80000000c00ULL, 0x0000001c15007388ULL, 0x0003e20000000c00ULL,
0x00f60009021079a7ULL, 0x000ea4000850003fULL, 0x00f60011020075a7ULL, 0x004ea4000800017fULL,
0x0000003800508947ULL, 0x006fea0003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000900000077ab9ULL, 0x000fe20000000800ULL, 0x3db504f30b097820ULL, 0x020fe20000410000ULL,
0x000000080f0a7824ULL, 0x140fe200078e0202ULL, 0xffffffff05067890ULL, 0x000fe2000fffe03fULL,
0x000000200f0b7824ULL, 0x000fe400078e0202ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000070d0d7c24ULL, 0x000fce000f8e02ffULL, 0x000001000e3c7824ULL, 0x000fca00078e0207ULL,
0x000000093c007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fce000001ff00ULL,
0x000000013d127836ULL, 0x000fe40000000000ULL, 0x000000ffff437224ULL, 0x000fe400078e003dULL,
0x000000ffff3d7224ULL, 0x100fe200078e0012ULL, 0x00000001ff0c7819ULL, 0x000fe40000011612ULL,
0x000000021200780cULL, 0x040fe40003f06070ULL, 0x0000000112427812ULL, 0x000fe200078ec0ffULL,
0x000000030c0c7224ULL, 0x000fc800078e020eULL, 0x000000010c117836ULL, 0x040fe40000000000ULL,
0x000001000c447824ULL, 0x000fe200078e0207ULL, 0x00000001100c7812ULL, 0x000fe400078e0cffULL,
0x0000000511007c0cULL, 0x000fe2000bf26070ULL, 0x0000000805117224ULL, 0x020fe200078e02ffULL,
0x0000004044137812ULL, 0x000fca00078ec0ffULL, 0x00000001061f7824ULL, 0x000fcc00078e0213ULL,
0x0000000400b89947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x100fe20000011600ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000944137c48ULL, 0x000fe2000ffe0000ULL,
0x0000000442497824ULL, 0x000fe200078e00ffULL, 0x00000003ff457819ULL, 0x000fe20000011600ULL,
0x000000081e487836ULL, 0x040fe40000000000ULL, 0x000000101e507836ULL, 0x000fe20000000000ULL,
0xfffffffc49497812ULL, 0x000fe200078ee200ULL, 0x0000000148147824ULL, 0x100fe400078e021fULL,
0x000000011e127824ULL, 0x000fc400078e021fULL, 0x0000000150167824ULL, 0x000fe200078e021fULL,
0x0000001411147210ULL, 0x000fe20007f5e0ffULL, 0x000000181e517836ULL, 0x000fe20000000000ULL,
0x00000012111c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000113447824ULL, 0x000fe200078e0a44ULL,
0x0000001611167210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000000c14407c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x0000000c1c467c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x0000000d14417c11ULL, 0x000fe200090f3c17ULL, 0x0000000151147824ULL, 0x000fe200078e021fULL,
0x0000000c16127c11ULL, 0x000fe2000f8638ffULL, 0x000000201e527836ULL, 0x000fe20000000000ULL,
0x0000000d1c477c11ULL, 0x000fe200088f3c1dULL, 0x000000281e537836ULL, 0x000fe20000000000ULL,
0x0000000d16137c11ULL, 0x000fe200098f3c15ULL, 0x000000301e547836ULL, 0x040fe20000000000ULL,
0x000000441e00720cULL, 0x040fe20003f46070ULL, 0x000000381e557836ULL, 0x000fe20000000000ULL,
0x0000001411147210ULL, 0x000fe20007f3e0ffULL, 0x0000000152167824ULL, 0x000fc400078e021fULL,
0x00000001531c7824ULL, 0x100fe400078e021fULL, 0x00000001541e7824ULL, 0x100fe400078e021fULL,
0x00000001553e7824ULL, 0x000fe200078e021fULL, 0x00000016111f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x0000001c113f7210ULL, 0x000fe20007fde0ffULL,
0x0000001049467825ULL, 0x040fe200078e0046ULL, 0x0000001e111d7210ULL, 0x000fe40007f9e0ffULL,
0x0000000c14167c11ULL, 0x000fe2000f8238ffULL, 0x0000001049407825ULL, 0x000fe200078e0040ULL,
0x0000003e11157210ULL, 0x000fc40007f7e0ffULL, 0x00000000451c7212ULL, 0x000fe200078e3cffULL,
0x000020000f117824ULL, 0x000fe200078e0202ULL, 0x0000000d14177c11ULL, 0x000fe200088f3c17ULL,
0x00000004483e7824ULL, 0x000fe200078e00ffULL, 0x000000031c4f7812ULL, 0x000fe200078ec0ffULL,
0x000010000c147824ULL, 0x000fe200078e0211ULL, 0x000000444800720cULL, 0x080fe20003f26070ULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x0ffffffc4f4b7812ULL, 0x000fe200078ef800ULL,
0x0000100014487836ULL, 0x000fe20000000000ULL, 0xfffffffc3e4d7812ULL, 0x000fe200078ee24fULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x0000000c1f1e7c11ULL, 0x000fe2000f8a38ffULL,
0x000000104b4b7824ULL, 0x100fe200078e0248ULL, 0x000000445500720cULL, 0x000fe20003fc6070ULL,
0x000000104d4d7824ULL, 0x000fe200078e0248ULL, 0x0000000d1f1f7c11ULL, 0x000fe2000a8f3c1cULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000000c3f3e7c11ULL, 0x000fe2000f8a38ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x0000000c1d1c7c11ULL, 0x000fe2000f8638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464b7faeULL, 0x0003e2000d101c4aULL,
0x0000000c15147c11ULL, 0x000fe2000f8838ffULL, 0x0000001049127825ULL, 0x000fe200078e0012ULL,
0x0000000d3f3f7c11ULL, 0x000fe2000a8f3c4eULL, 0x00000000404d7faeULL, 0x0005e2000c901c4aULL,
0x0000000d1d1d7c11ULL, 0x000fe200098f3c4cULL, 0x0000001049167825ULL, 0x000fe200078e0016ULL,
0x0000000d15157c11ULL, 0x000fc4000a0f3c4aULL, 0x000000445000720cULL, 0x0c0fe20003f26070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x000000445100720cULL, 0x080fe20003f46070ULL,
0x0000000453467824ULL, 0x042fe200078e00ffULL, 0x000000445200720cULL, 0x0c0fe20003f66070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000445300720cULL, 0x080fe20003f86070ULL,
0x0000000455407824ULL, 0x004fe200078e00ffULL, 0x000000445400720cULL, 0x040fe20003fa6070ULL,
0x0000000451447824ULL, 0x000fe200078e00ffULL, 0xfffffffc50417812ULL, 0x000fe200078ee24fULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc524b7812ULL, 0x000fe200078ee24fULL,
0x00000010491e7825ULL, 0x000fe200078e001eULL, 0xfffffffc44477812ULL, 0x000fc400078ee24fULL,
0xfffffffc464d7812ULL, 0x000fe200078ee24fULL, 0x0000001041417824ULL, 0x100fe200078e0248ULL,
0xfffffffc54517812ULL, 0x000fe200078ee24fULL, 0x0000001047477824ULL, 0x100fe200078e0248ULL,
0xfffffffc40537812ULL, 0x000fe200078ee24fULL, 0x000000104b4b7824ULL, 0x100fe200078e0248ULL,
0x0000000012417faeULL, 0x0003e2000c901c4aULL, 0x000000104d4d7824ULL, 0x000fe400078e0248ULL,
0x00000010493e7825ULL, 0x000fe200078e003eULL, 0x0000000016477faeULL, 0x0003e6000d101c4aULL,
0x00000010514f7824ULL, 0x000fe200078e0248ULL, 0x000000001e4b7faeULL, 0x0003e2000d901c4aULL,
0x00000010491c7825ULL, 0x000fc600078e001cULL, 0x000000003e4d7faeULL, 0x0003e2000e101c4aULL,
0x0000001053517824ULL, 0x000fe400078e0248ULL, 0x0000001049147825ULL, 0x000fe200078e0014ULL,
0x000000001c4f7faeULL, 0x0003e8000e901c4aULL, 0x0000000014517faeULL, 0x0003e2000f101c4aULL,
0x0000000400887947ULL, 0x000fea0003800000ULL, 0x00000010004e7811ULL, 0x040fe200078ff0ffULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x00000008004c7811ULL, 0x000fe200078ff0ffULL,
0x0000000442577824ULL, 0x000fe200078e00ffULL, 0x0000001f00127211ULL, 0x000fe200078ff0ffULL,
0x000000014e167824ULL, 0x100fe200078e021fULL, 0x0000001800507811ULL, 0x000fe200078ff0ffULL,
0x000000014c147824ULL, 0x000fe200078e021fULL, 0x0000001211177210ULL, 0x000fe40007f3e0ffULL,
0x0000001611137210ULL, 0x000fc40007f7e0ffULL, 0x0000001411157210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x0000000c17407c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x0000000c13127c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000000c15167c11ULL, 0x000fe4000f8438ffULL,
0x0000000d13137c11ULL, 0x000fe200098f3c14ULL, 0x0000000150147824ULL, 0x000fe200078e021fULL,
0x0000002000527811ULL, 0x000fc400078ff0ffULL, 0x0000000d17417c11ULL, 0x000fe400088f3c1eULL,
0x0000003000567811ULL, 0x000fe400078ff0ffULL, 0x0000000d15177c11ULL, 0x000fe200090f3c1cULL,
0x00000001521c7824ULL, 0x100fe200078e021fULL, 0x0000002800547811ULL, 0x000fe200078ff0ffULL,
0x00000001563e7824ULL, 0x100fe200078e021fULL, 0x0000001411157210ULL, 0x000fe40007f3e0ffULL,
0x0000003800587811ULL, 0x000fe200078ff0ffULL, 0x00000001541e7824ULL, 0x100fe200078e021fULL,
0x0000001c113f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x0000000c15147c11ULL, 0x000fe2000f8638ffULL, 0x0000000158447824ULL, 0x000fe200078e021fULL,
0x0000003e111d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x0000001e111f7210ULL, 0x000fc40007fbe0ffULL, 0x0000000d15157c11ULL, 0x000fe200098f3c1cULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x0000000c3f3e7c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff487224ULL, 0x000fe200028e06ffULL, 0x0000000c1d1c7c11ULL, 0x000fe4000f8438ffULL,
0x00000003ff457819ULL, 0x000fe40000011600ULL, 0x0000000d3f3f7c11ULL, 0x000fe200098f3c4aULL,
0x000000044c4a7824ULL, 0x000fe200078e00ffULL, 0x0000004411447210ULL, 0x000fe20007f3e0ffULL,
0x000020000f117824ULL, 0x000fe200078e0202ULL, 0x0000000c1f1e7c11ULL, 0x000fe2000f8838ffULL,
0x000000044e4c7824ULL, 0x000fe200078e00ffULL, 0x0000000d1d1d7c11ULL, 0x000fe200090f3c46ULL,
0x00000004504e7824ULL, 0x000fe200078e00ffULL, 0x0000000045467212ULL, 0x000fe200078e3cffULL,
0x0000000452507824ULL, 0x000fe200078e00ffULL, 0x0000000d1f1f7c11ULL, 0x000fe2000a0f3c48ULL,
0x0000000454527824ULL, 0x000fe200078e00ffULL, 0x0000000346477812ULL, 0x000fe200078ec0ffULL,
0x000010000c487824ULL, 0x000fe200078e0211ULL, 0xfffffffc57577812ULL, 0x000fe200078ee200ULL,
0x0000000456547824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee247ULL,
0x0000000458567824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee247ULL,
0x0000100048557836ULL, 0x000fe20000000000ULL, 0x0ffffffc47487812ULL, 0x000fe200078ef800ULL,
0x0000001057407825ULL, 0x000fe200078e0040ULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee247ULL,
0xfffffffc50507812ULL, 0x000fe200078ee247ULL, 0x0000001048597824ULL, 0x100fe200078e0255ULL,
0xfffffffc52527812ULL, 0x000fe200078ee247ULL, 0x000000104a497824ULL, 0x000fe200078e0255ULL,
0xfffffffc54547812ULL, 0x000fe200078ee247ULL, 0x0000001057167825ULL, 0x040fe200078e0016ULL,
0xfffffffc56567812ULL, 0x000fe200078ee247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040597faeULL, 0x0003e4000b901c4aULL, 0x000000ffff477224ULL, 0x000fe200008e06ffULL,
0x0000000c44467c11ULL, 0x000fe2000f8238ffULL, 0x000000104c4b7824ULL, 0x000fe200078e0255ULL,
0x0000000016497faeULL, 0x0003e2000b901c4aULL, 0x0000001057127825ULL, 0x000fe200078e0012ULL,
0x0000000d44477c11ULL, 0x000fc600088f3c47ULL, 0x000000104e4d7824ULL, 0x000fe200078e0255ULL,
0x00000000124b7faeULL, 0x0003e2000b901c4aULL, 0x0000001057147825ULL, 0x000fc800078e0014ULL,
0x00000010504f7824ULL, 0x000fe200078e0255ULL, 0x00000000144d7faeULL, 0x0003e2000b901c4aULL,
0x00000010573e7825ULL, 0x000fc800078e003eULL, 0x0000001052517824ULL, 0x000fe200078e0255ULL,
0x000000003e4f7faeULL, 0x0003e2000b901c4aULL, 0x00000010571e7825ULL, 0x000fc800078e001eULL,
0x0000001054537824ULL, 0x000fe200078e0255ULL, 0x000000001e517faeULL, 0x0003e2000b901c4aULL,
0x00000010571c7825ULL, 0x000fc800078e001cULL, 0x0000001056557824ULL, 0x000fe200078e0255ULL,
0x000000001c537faeULL, 0x0003e2000b901c4aULL, 0x0000001057467825ULL, 0x000fca00078e0046ULL,
0x0000000046557faeULL, 0x0003e4000b901c4aULL, 0x000000ff4200720cULL, 0x000fda0003f25270ULL,
0x0000000000209947ULL, 0x000fea0003800000ULL, 0x0000000203047824ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000404007c0cULL, 0x000fda000bf26070ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x00008c00ff127b82ULL, 0x002e620000000a00ULL,
0x000000020d057824ULL, 0x000fc800078e0204ULL, 0x0000000405127825ULL, 0x002fca00078e0012ULL,
0x0000000a12057981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000157836ULL, 0x042fe20000000000ULL, 0xfffffff800137812ULL, 0x000fe200078ec0ffULL,
0x0000100010417824ULL, 0x000fe200078e0211ULL, 0x0000000700497812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ec0ffULL,
0x0000100041417836ULL, 0x000fe20000000000ULL, 0x0000000713427812ULL, 0x000fe400078ef800ULL,
0x0000000715447812ULL, 0x000fc400078ef800ULL, 0x00000001ff3f7819ULL, 0x000fe40000011642ULL,
0x00000001ff477819ULL, 0x000fe40000011644ULL, 0x0000000849407812ULL, 0x000fe400078ef800ULL,
0x000000033f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000000347477812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x0000003e3f117212ULL, 0x080fe200078e3cffULL,
0x0000000443617824ULL, 0x000fe200078e023eULL, 0x0000003e47157212ULL, 0x000fc600078e3cffULL,
0x0000000442107824ULL, 0x000fe400078e0211ULL, 0x0000000444147824ULL, 0x000fe400078e0215ULL,
0x0000001010107824ULL, 0x100fe400078e0241ULL, 0x0000001014147824ULL, 0x000fe400078e0241ULL,
0x0000000261617824ULL, 0x000fe400078e00ffULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff597819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x0000888010557816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x0000888011607816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fc40000011412ULL,
0x00008880125f7816ULL, 0x000fe400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x00000010005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff667819ULL, 0x004fe40000011415ULL,
0x00008880156c7816ULL, 0x000fc400000000ffULL, 0x00000018ff677819ULL, 0x000fe20000011414ULL,
0x00000011005d7306ULL, 0x0005e20000200c00ULL, 0x0001000012107824ULL, 0x002fe200078e00ffULL,
0x0000888014707816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011416ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x004fe200078e00ffULL,
0x0000001c00587306ULL, 0x000fe20000200c00ULL, 0x00000018ff467819ULL, 0x000fc40000011417ULL,
0x00008880166a7816ULL, 0x000fe400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000888017627816ULL, 0x000fe200000000ffULL, 0x0000001200777306ULL, 0x0003e20000200c00ULL,
0x00000018ff687819ULL, 0x000fe40000011413ULL, 0x0000888013727816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fc800078e00ffULL, 0x0000001100757306ULL, 0x0005e20000200c00ULL,
0x000000013e127836ULL, 0x042fe20000000000ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x000000023e3e7836ULL, 0x000fca0000000000ULL, 0x0000001d00797306ULL, 0x0003e20000200c00ULL,
0x000000123f117212ULL, 0x004fe400078e3cffULL, 0x000000043e00780cULL, 0x000fc60003f25270ULL,
0x00000004421c7824ULL, 0x000fe400078e0211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0x0000001000747306ULL, 0x0005e20000200c00ULL, 0x000000101c1c7824ULL, 0x000fe400078e0241ULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc60000011411ULL,
0x000000001c1c783bULL, 0x002e620000000200ULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0001000014107824ULL, 0x044fe200078e00ffULL, 0x0000001300737306ULL, 0x0005e20000200c00ULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000015006d7306ULL, 0x0007e20000200c00ULL,
0x0000001247137212ULL, 0x004fca00078e3cffULL, 0x0000000444127824ULL, 0x000fe400078e0213ULL,
0x00000014006e7306ULL, 0x0005e20000200c00ULL, 0x0000006100157211ULL, 0x008fe200078fe0ffULL,
0x0000001012127824ULL, 0x000fe400078e0241ULL, 0x0000000261617836ULL, 0x000fe20000000000ULL,
0x0000000715157812ULL, 0x000fc600078e7840ULL, 0x0000001000717306ULL, 0x0007e20000200c00ULL,
0x0001000017147824ULL, 0x044fe200078e00ffULL, 0x0000006100617211ULL, 0x000fe200078fe0ffULL,
0x0000010017177824ULL, 0x000fe400078e00ffULL, 0x0000001040157824ULL, 0x000fe200078e0215ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000016107824ULL, 0x048fe200078e00ffULL, 0x0000001400657306ULL, 0x0005e20000200c00ULL,
0x0000010016167824ULL, 0x000fc400078e00ffULL, 0x0000001015157824ULL, 0x000fe200078e0202ULL,
0x00000018ff6b7819ULL, 0x000fe20000011410ULL, 0x000100001d567824ULL, 0x002fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001700637306ULL, 0x000fe20000200c00ULL,
0x000100001c147824ULL, 0x004fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe4000001141cULL,
0x00000018ff517819ULL, 0x000fe4000001141dULL, 0x00000018ff547819ULL, 0x000fc40000011414ULL,
0x0000001600697306ULL, 0x0003e20000200c00ULL, 0x000088801c4b7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x000088801d527816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011456ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x000000001514783bULL, 0x002e620000000200ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff4f7819ULL, 0x000fe4000001141fULL, 0x000088801e767816ULL, 0x000fe400000000ffULL,
0x00000011006f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff507819ULL, 0x000fce000001141eULL,
0x0000001c00537306ULL, 0x0005e20000200c00ULL, 0x000000001210783bULL, 0x008eee0000000200ULL,
0x0000001d00567306ULL, 0x0009e20000200c00ULL, 0x00005410551c7816ULL, 0x004fe20000000058ULL,
0x000100001e587824ULL, 0x000fc400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x000054105e1d7816ULL, 0x010fe40000000059ULL, 0x000088801f597816ULL, 0x000fe400000000ffULL,
0x00000018ff1e7819ULL, 0x000fc6000001141eULL, 0x0000006000607306ULL, 0x000f220000200c00ULL,
0x0000001c1438723cULL, 0x002fee0000001838ULL, 0x000100001f1c7824ULL, 0x000fe200078e00ffULL,
0x000054105d1d7816ULL, 0x004fe2000000005cULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x000001001f1f7824ULL, 0x000fc400078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc6000001141cULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c005e7306ULL, 0x0009e20000200c00ULL,
0x00000018ff4e7819ULL, 0x008fe40000011410ULL, 0x00008880105d7816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011411ULL, 0x00000018ff4c7819ULL, 0x000fe20000011412ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x00005410601c7816ULL, 0x010fc40000000079ULL,
0x00000018ff4a7819ULL, 0x000fca0000011413ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x0000001c1434723cULL, 0x000fee0000001834ULL, 0x00010000101d7824ULL, 0x040fe200078e00ffULL,
0x0000007000707306ULL, 0x000f220000200c00ULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x000054105f1c7816ULL, 0x002fe20000000074ULL, 0x0000010011747824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc4000001141dULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000007600557306ULL, 0x0003e20000200c00ULL, 0x00000007611d7812ULL, 0x000fca00078e7840ULL,
0x00000010401d7824ULL, 0x000fe400078e021dULL, 0x0000001f005c7306ULL, 0x0005e20000200c00ULL,
0x0000888011767816ULL, 0x002fce00000000ffULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x00010000111f7824ULL, 0x004fe200078e00ffULL, 0x0000541073117816ULL, 0x000fe40000000068ULL,
0x00000018ff687819ULL, 0x000fc80000011474ULL, 0x0000001000617306ULL, 0x0007f00000200c00ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541072107816ULL, 0x008fce0000000075ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000010142c723cULL, 0x000fee000000182cULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x0000888012117816ULL, 0x000fe400000000ffULL,
0x0000541070107816ULL, 0x010fc60000000071ULL, 0x000000ffff707224ULL, 0x000fe200078e0011ULL,
0x000054106e117816ULL, 0x002fe20000000067ULL, 0x0000001e005b7306ULL, 0x0003e20000200c00ULL,
0x00010000126e7824ULL, 0x000fca00078e00ffULL, 0x000000101428723cULL, 0x000fe20000001828ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000000101d1e7824ULL, 0x002fe200078e0202ULL, 0x00005410771d7816ULL, 0x004fe40000000064ULL,
0x00000018ff647819ULL, 0x000fe4000001141fULL, 0x000054106c107816ULL, 0x008fe4000000006fULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054106d117816ULL, 0x000fe20000000066ULL,
0x0000001c1430723cULL, 0x000fe20000001830ULL, 0x000000001e1c783bULL, 0x000e6a0000000200ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000000101424723cULL, 0x000fee0000001824ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000010012117824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011411ULL, 0x0000006200627306ULL, 0x000ee20000200c00ULL,
0x000054106a107816ULL, 0x004fe4000000006bULL, 0x0000541069117816ULL, 0x000fe4000000005aULL,
0x00008880135a7816ULL, 0x000fc600000000ffULL, 0x0000004800487306ULL, 0x000fe40000200c00ULL,
0x000000101420723cULL, 0x000fec0000001820ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000541062107816ULL, 0x008fe40000000065ULL, 0x0000541063117816ULL, 0x000fe20000000046ULL,
0x000000ffff467224ULL, 0x000fc800078e005aULL, 0x0000005400547306ULL, 0x000ea40000200c00ULL,
0x000000101418723cULL, 0x000fec0000001818ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0001000013117824ULL, 0x000fca00078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x000054104b107816ULL, 0x004fe20000000054ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541053117816ULL, 0x000fce0000000048ULL, 0x000000101c38723cULL, 0x002fe20000001838ULL,
0x0000005100517306ULL, 0x000e6c0000200c00ULL, 0x0000010013107824ULL, 0x000fe200078e00ffULL,
0x0000541068657816ULL, 0x004fe2000000004dULL, 0x0000005000507306ULL, 0x000ea60000200c00ULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x0000541056537816ULL, 0x002fc60000000051ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000054105b5b7816ULL, 0x004fce0000000050ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000054105c117816ULL, 0x002fce000000004fULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541061617816ULL, 0x004fce000000004eULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000005200527306ULL, 0x000ff00000200c00ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x0000541052527816ULL, 0x002fce0000000057ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000521c34723cULL, 0x000fe20000001834ULL, 0x00005410555a7816ULL, 0x004fcc0000000058ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000005a1c30723cULL, 0x000fee0000001830ULL,
0x0000006000607306ULL, 0x000e700000200c00ULL, 0x00000076005f7306ULL, 0x000fe20000200c00ULL,
0x000054105d607816ULL, 0x002fce0000000060ULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x000000601c28723cULL, 0x000fee0000001828ULL, 0x0000007000677306ULL, 0x000fe20000200c00ULL,
0x000054105f647816ULL, 0x002fce0000000064ULL, 0x0000006e00127306ULL, 0x000e620000200c00ULL,
0x000000641c24723cULL, 0x000fee0000001824ULL, 0x0000006600697306ULL, 0x000ea20000200c00ULL,
0x0000541067687816ULL, 0x002fce0000000012ULL, 0x0000004600147306ULL, 0x000fe20000200c00ULL,
0x0000541069697816ULL, 0x004fce000000004cULL, 0x0000001500137306ULL, 0x000e620000200c00ULL,
0x000000681c20723cULL, 0x000fee0000001820ULL, 0x0000001000177306ULL, 0x0004e20000200c00ULL,
0x0000541014147816ULL, 0x002fe40000000013ULL, 0x0000541059107816ULL, 0x004fc4000000005eULL,
0x0000541017157816ULL, 0x008fca000000004aULL, 0x000000101c2c723cULL, 0x000fec000000182cULL,
0x000000141c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000301947ULL, 0x000fde000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0xffffffe000448947ULL, 0x000fec000383ffffULL, 0x00000001ff3e7424ULL, 0x000fe400078e00ffULL,
0x000000092d147220ULL, 0x080fe20000410000ULL, 0x0000000400127824ULL, 0x000fe400078e00ffULL,
0x0000000928167220ULL, 0x080fe20000410000ULL, 0x00f6883e0a1079a7ULL, 0x000e62000850003fULL,
0x000000800f137824ULL, 0x000fe400078e0202ULL, 0x0000000929177220ULL, 0x080fe20000410000ULL,
0xfffffff012127812ULL, 0x000fe200078ec0ffULL, 0x00000009241c7220ULL, 0x080fe20000410000ULL,
0x00000009251d7220ULL, 0x080fe20000410000ULL, 0x00000009262d7220ULL, 0x080fe20000410000ULL,
0x0000000938157220ULL, 0x080fe20000410000ULL, 0x0000000939397220ULL, 0x080fe20000410000ULL,
0x000000093a3a7220ULL, 0x080fe20000410000ULL, 0x000000093b3b7220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000936367220ULL, 0x080fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x00f688110a0075a7ULL, 0x002e62000800017fULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x0000000922257220ULL, 0x080fe20000410000ULL,
0x0000000923267220ULL, 0x000fe20000410000ULL, 0x0000000113247824ULL, 0x000fc400078e0212ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x000000091a287220ULL, 0x080fe20000410000ULL, 0x000000091b297220ULL, 0x000fe20000410000ULL,
0x0000001400988947ULL, 0x002fec0003800000ULL, 0x00f4000024107984ULL, 0x0002a20000000c00ULL,
0x000000060e007c0cULL, 0x000fda000bf05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002001a7824ULL, 0x000fe200078e00ffULL, 0x000000093c3c7c10ULL, 0x000fc8000fffe1ffULL,
0x000000061a1b7812ULL, 0x000fc800078ec0ffULL, 0x000000011b1f7812ULL, 0x040fe400078efcffULL,
0x000000081b237812ULL, 0x000fe400078efcffULL, 0x0000003c1f00720cULL, 0x080fe40003f26070ULL,
0x000000101b1f7812ULL, 0x000fe400078efcffULL, 0x0000003c2300720cULL, 0x080fe40003f06070ULL,
0x0000003c1f00720cULL, 0x000fc40003fc6070ULL, 0x000000111b237812ULL, 0x040fe400078efcffULL,
0x000000181b1f7812ULL, 0x040fe400078efcffULL, 0x0000003c1b00720cULL, 0x080fe40003f46070ULL,
0x0000003c2300720cULL, 0x080fe40003fa6070ULL, 0x0000003c1f00720cULL, 0x000fe40003f66070ULL,
0x000000091b3d7812ULL, 0x000fc400078efcffULL, 0x000000191b237812ULL, 0x040fe400078efcffULL,
0x000000201b1f7812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL,
0xff7fffff39397808ULL, 0x000fc40004800000ULL, 0x0000003c3d00720cULL, 0x080fe40003f86070ULL,
0x0000003c2300720cULL, 0x080fe40003f46070ULL, 0x0000003c1f00720cULL, 0x000fe40003f26070ULL,
0x000000211b237812ULL, 0x040fe400078efcffULL, 0x000000281b1f7812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fc40004000000ULL, 0xff7fffff34347808ULL, 0x000fe40004000000ULL,
0xff7fffff37377808ULL, 0x000fe40006000000ULL, 0xff7fffff35357808ULL, 0x000fe40006000000ULL,
0x0000003c2300720cULL, 0x080fe40003f06070ULL, 0x0000003c1f00720cULL, 0x000fe40003f86070ULL,
0x000000291b237812ULL, 0x000fc400078efcffULL, 0x000000301b1f7812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fe40007000000ULL, 0xff7fffff30307808ULL, 0x000fe40007000000ULL,
0xff7fffff33337808ULL, 0x000fe40006800000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0x0000003c2300720cULL, 0x000fc40003fc6070ULL, 0x0000003c1f00720cULL, 0x000fe40003fa6070ULL,
0x000000311b237812ULL, 0x040fe400078efcffULL, 0x000000381b1f7812ULL, 0x040fe400078efcffULL,
0x000000391b1b7812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff14147808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x0000003c2300720cULL, 0x080fe40003f66070ULL,
0x0000003c1f00720cULL, 0x000fc40003f46070ULL, 0x0000003c1b00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fc40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40006800000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff28287808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff29297808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fce0004800000ULL,
0x0000001510107209ULL, 0x004fe20007810000ULL, 0xffffffff00077882ULL, 0x000fe20000000000ULL,
0x0000003a111a7209ULL, 0x000fe40007810000ULL, 0x0000003910117209ULL, 0x000fe40007810000ULL,
0x0000003b1a1b7209ULL, 0x000fe40007810000ULL, 0x0000003411107209ULL, 0x000fe40007810000ULL,
0x000000361b1a7209ULL, 0x000fc40007810000ULL, 0x0000003510117209ULL, 0x000fe40007810000ULL,
0x000000371a1b7209ULL, 0x000fe40007810000ULL, 0x0000003011107209ULL, 0x000fe40007810000ULL,
0x000000321b1a7209ULL, 0x000fe40007810000ULL, 0x0000003110117209ULL, 0x000fe40007810000ULL,
0x000000331a1b7209ULL, 0x000fc40007810000ULL, 0x0000002c11117209ULL, 0x000fe40007810000ULL,
0x0000002e1b107209ULL, 0x000fe40007810000ULL, 0x0000001411117209ULL, 0x000fe40007810000ULL,
0x0000002f101b7209ULL, 0x000fe40007810000ULL, 0x0000001611107209ULL, 0x000fe40007810000ULL,
0x0000002a1b1a7209ULL, 0x000fc40007810000ULL, 0x0000001710117209ULL, 0x000fe40007810000ULL,
0x0000002b1a1a7209ULL, 0x000fe40007810000ULL, 0x0000001c11107209ULL, 0x000fe40007810000ULL,
0x0000002d1a1a7209ULL, 0x000fe40007810000ULL, 0x0000001d10117209ULL, 0x000fe40007810000ULL,
0x000000271a1a7209ULL, 0x000fc40007810000ULL, 0x0000002011107209ULL, 0x000fe40007810000ULL,
0x000000251a117209ULL, 0x000fe40007810000ULL, 0x00000021101b7209ULL, 0x000fe40007810000ULL,
0x0000002611117209ULL, 0x000fe40007810000ULL, 0x000000181b107209ULL, 0x000fe40007810000ULL,
0x00000028111a7209ULL, 0x000fc40007810000ULL, 0x0000001910107209ULL, 0x000fe40007810000ULL,
0x000000291a1a7209ULL, 0x000fe20007810000ULL, 0x0000001207147947ULL, 0x000fec000b800000ULL,
0x0c401f0010117f89ULL, 0x000e6800000e0000ULL, 0x0c401f001a1f7f89ULL, 0x000ea800000e0000ULL,
0x0c401f0012237f89ULL, 0x000ee800000e0000ULL, 0x0c401f0013387f89ULL, 0x000f2200000e0000ULL,
0x00000011101b7209ULL, 0x002fc40007810000ULL, 0x0000001f1a1f7209ULL, 0x004fc60007810000ULL,
0x0c201f001b1e7f89ULL, 0x000e6200000e0000ULL, 0x0000002312237209ULL, 0x008fc60007810000ULL,
0x0c201f001f227f89ULL, 0x000ea200000e0000ULL, 0x0000003813387209ULL, 0x010fc60007810000ULL,
0x0c201f00233c7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00383d7f89ULL, 0x00092200000e0000ULL,
0x0000001e1b107209ULL, 0x002fe40007810000ULL, 0x000000221f117209ULL, 0x004fe40007810000ULL,
0x0000003c23127209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b11467820ULL, 0x000fc60000410000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010846ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010813ULL, 0x00000039001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b19137823ULL, 0x000fe20000010813ULL, 0x00000017003c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b26267823ULL, 0x000fc40000010846ULL,
0x0000001800437308ULL, 0x000ff00000000800ULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000003600177308ULL, 0x000ff00000000800ULL,
0x0000003700187308ULL, 0x000e700000000800ULL, 0x0000001400237308ULL, 0x0005e20000000800ULL,
0x000000171817723eULL, 0x002fce00000000ffULL, 0x00000030001b7308ULL, 0x0003e20000000800ULL,
0x000000151a14723eULL, 0x004fe400000000ffULL, 0x0000003a3b15723eULL, 0x000fca00000000ffULL,
0x0000003100227308ULL, 0x0004e20000000800ULL, 0x3c003c00ff307424ULL, 0x002fce00078e00ffULL,
0x0000001600397308ULL, 0x0003e20000000800ULL, 0x3c003c00ff317424ULL, 0x004fe200078e00ffULL,
0x0000001b2218723eULL, 0x008fcc00000000ffULL, 0x0000001c003f7308ULL, 0x000fe20000000800ULL,
0x000000343516723eULL, 0x002fce00000000ffULL, 0x0000001d00407308ULL, 0x0003f00000000800ULL,
0x0000002000417308ULL, 0x000fe20000000800ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000030141c723cULL, 0x002fe400000018ffULL, 0x0000002c002c7308ULL, 0x000e700000000800ULL,
0x0000003200197308ULL, 0x000fe20000000800ULL, 0x0000002c231a723eULL, 0x002fce00000000ffULL,
0x0000003300207308ULL, 0x000e700000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000192019723eULL, 0x002fce00000000ffULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000002100427308ULL, 0x0005e20000000800ULL, 0x0000002e2f1b723eULL, 0x002fce00000000ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000301820723cULL, 0x004fee000000181cULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000393c1c723eULL, 0x000fe400000000ffULL,
0x0000003f401e723eULL, 0x000fca00000000ffULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000002a2b1d723eULL, 0x002fce00000000ffULL, 0x00000027002c7308ULL, 0x000e700000000800ULL,
0x0000001300447308ULL, 0x0004e20000000800ULL, 0x0000002d2c1f723eULL, 0x002fce00000000ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28137823ULL, 0x104fe20000010846ULL,
0x3fb8aa3b29467823ULL, 0x000fe40000010846ULL, 0x000000301c28723cULL, 0x000fe80000001820ULL,
0x0000002600267308ULL, 0x000e660000000800ULL, 0x000000414220723eULL, 0x000fc400000000ffULL,
0x000000434422723eULL, 0x008fc600000000ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000252621723eULL, 0x002fce00000000ffULL, 0x0000004600467308ULL, 0x000e620000000800ULL,
0x0000000fff267424ULL, 0x000fe200078e00ffULL, 0xfffffffc00257812ULL, 0x000fc800078ec0ffULL,
0x0000002526257219ULL, 0x000fe400000006ffULL, 0x000000134623723eULL, 0x002fe400000000ffULL,
0x0000003d38137209ULL, 0x010fca0007810000ULL, 0x000000302030723cULL, 0x000fde0000001828ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x001c1fff30287589ULL, 0x00026200000e0000ULL,
0x00000000002a7806ULL, 0x000fe200038e0100ULL, 0x00000000252673a1ULL, 0x000eb000000e8000ULL,
0x00000000250773c4ULL, 0x000ee20000004000ULL, 0x0000000000087886ULL, 0x000fc400038e0100ULL,
0x0000000825ff7c12ULL, 0x004fda000f804026ULL, 0x0000000e07248947ULL, 0x00afea000b800000ULL,
0x001c1fff32297589ULL, 0x0002a800000e0000ULL, 0x001c1fff2a2a7589ULL, 0x000ee800000e0000ULL,
0x001c1fff002b7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff497812ULL, 0x000fe200078ee249ULL,
0x000008000f277824ULL, 0x000fe200078e0202ULL, 0x00000003452e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff317224ULL, 0x000fe200078e0016ULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008492d7836ULL, 0x040fe20000000000ULL, 0x000000042e307812ULL, 0x000fe200078efcffULL,
0x0000000849257824ULL, 0x002fe200078e00ffULL, 0x000000072e267812ULL, 0x000fe200078e7849ULL,
0x0000900027277836ULL, 0x000fe20000000000ULL, 0x00000007302c7812ULL, 0x000fe200078e7849ULL,
0x000000ffff327224ULL, 0x000fe200078e0018ULL, 0x000000072e2e7812ULL, 0x000fe200078e782dULL,
0x000000ffff337224ULL, 0x000fe200078e001aULL, 0x0000000730307812ULL, 0x000fe200078e782dULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000002526267212ULL, 0x080fe200078efcffULL,
0x000000ffff2f7224ULL, 0x000fe200078e0022ULL, 0x000000252c2c7212ULL, 0x000fe200078efcffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0000002d2e2e7212ULL, 0x080fe200078efcffULL,
0x0000001026267824ULL, 0x100fe200078e0227ULL, 0x0000002d30307212ULL, 0x000fe200078efcffULL,
0x000000102c257824ULL, 0x000fc400078e0227ULL, 0x000000102e347824ULL, 0x100fe400078e0227ULL,
0x0000001030277824ULL, 0x000fe400078e0227ULL, 0x000000ffff307224ULL, 0x000fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff2c7224ULL, 0x000fe200078e001cULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000003026007844ULL, 0x0003e20000000200ULL,
0x000000ffff2d7224ULL, 0x000fc400078e001eULL, 0x000000ffff2e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff177224ULL, 0x000fe200078e001bULL,
0x0000002c25007844ULL, 0x0003e20000000200ULL, 0x000000ffff187224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x000fe200078e001fULL, 0x0000001434007844ULL, 0x0003e20000000200ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0021ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x00000001030e7824ULL, 0x000fc600078e020eULL, 0x0000001827007844ULL, 0x0003e80000000200ULL,
0x00f0001024008388ULL, 0x0003e80000000c00ULL, 0x00f2002824008388ULL, 0x01c3e20000000c00ULL,
0x000000050e007c0cULL, 0x000fe2000bf06070ULL, 0x00f6083e0bff79a7ULL, 0x0003e2000850003fULL,
0x00f6103e0bff79a7ULL, 0x0003e2000850003fULL, 0x00f6183e0bff79a7ULL, 0x0003e2000850003fULL,
0x00f6203e0bff79a7ULL, 0x0003f2000850003fULL, 0xffffffcc000c8947ULL, 0x022fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00f6c835540075a7ULL, 0x00026200080c017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000e95dULL, 0x000fea0003900000ULL,
0x00f6c8355400e5a7ULL, 0x000e6400080c007fULL, 0xfffffffc00ece947ULL, 0x002fea000383ffffULL,
0xffffff2000ac7947ULL, 0x004fea000383ffffULL, 0x00f60811620075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x00f608116200a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff2400d07947ULL, 0x020fea000383ffffULL, 0x00000077390075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00000077390095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff2800f47947ULL, 0x020fea000383ffffULL, 0x00f6c835540075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00f6c835540095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff3c00447947ULL, 0x000fea000383ffffULL, 0x00f62811620075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x00f628116200a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff4000407947ULL, 0x000fea000383ffffULL, 0x00f6a879110075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00f6a879110095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff4400447947ULL, 0x000fea000383ffffULL, 0x00f6a835110075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x00f6a8351100a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff5400307947ULL, 0x000fea000383ffffULL, 0x00f64811620075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00f64811620095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff5800047947ULL, 0x020fea000383ffffULL, 0x00f6a877110075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f6a877110085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff5c00007947ULL, 0x020fea000383ffffULL, 0x00f6c835540075a7ULL, 0x0004a2000800017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f6c835540085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff6800ec7947ULL, 0x002fea000383ffffULL, 0x00f66811600075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00f66811600095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff6c00ac7947ULL, 0x002fea000383ffffULL, 0x00f6a8754b0075a7ULL, 0x0004a2000800017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f6a8754b0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff70009c7947ULL, 0x002fea000383ffffULL, 0x00f60011020075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f60011020085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffc4006c7947ULL, 0x020fea000383ffffULL, 0x00f60011020075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f60011020085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffc400987947ULL, 0x020fea000383ffffULL, 0x00f688110a0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00f688110a0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe800507947ULL, 0x020fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe400078e0010ULL, 0x00000002ff417424ULL, 0x000fe400078e00ffULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fce00078e00ffULL,
0x000000003f087348ULL, 0x000fea0003c00000ULL, 0x0c000041403d7389ULL, 0x0006e40000000042ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff407224ULL, 0x002fe400078e001aULL, 0x00000002ff417424ULL, 0x000fe400078e00ffULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x004fce00078e003dULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0c000041403d7389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x00000011101b7209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e0012ULL,
0x000000ffff1f7224ULL, 0x000fce00078e003dULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0c000041403d7389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001f1a1f7209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e0013ULL,
0x000000ffff237224ULL, 0x000fce00078e003dULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0c000041403d7389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002312237209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e001bULL,
0x00000001ff417424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fce00078e003dULL,
0x000000003f087348ULL, 0x000fea0003c00000ULL, 0x0c000041403d7389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000003813387209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e001fULL, 0x000000ffff1e7224ULL, 0x000fce00078e003dULL,
0x000000003f087348ULL, 0x000fea0003c00000ULL, 0x0c000041403d7389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001e1b107209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0023ULL, 0x000000ffff227224ULL, 0x000fce00078e003dULL,
0x000000003f087348ULL, 0x000fea0003c00000ULL, 0x0c000041403d7389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000221f117209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0038ULL, 0x000000ffff3c7224ULL, 0x000fce00078e003dULL,
0x000000003f087348ULL, 0x000fea0003c00000ULL, 0x0c000041403d7389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000003c23127209ULL, 0x000fe20007810000ULL,
0xffffffec00487947ULL, 0x020fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff267424ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fce00078e0025ULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0000002b322b7389ULL, 0x0006e40000000026ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x004fe400078e002bULL, 0x000000ffff327224ULL, 0x002fe400078e002aULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff267424ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fce00078e0025ULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0000002b322b7389ULL, 0x0006e40000000026ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x004fe400078e002bULL, 0x000000ffff327224ULL, 0x002fe400078e0000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff267424ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fce00078e0025ULL, 0x000000003f087348ULL, 0x000fea0003c00000ULL,
0x0000002b322b7389ULL, 0x0006e40000000026ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff000747947ULL, 0x026fea000383ffffULL,
0x018000000c007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000c00008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000c057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000c00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xffffff00043c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000774ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000dccULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e20ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e68ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e70ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000010000ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000010e80ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000010e90ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000010e90ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000010e90ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000011578ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011578ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e68ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010000ULL, 0x0000000000010000ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000010e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010e90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 71368;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
