/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014390ULL, 0x0000000000013f10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000012630ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000127a0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000127e0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000012820ULL,
0x0000000000000160ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012980ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001263000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0048480400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9c08288080920828ULL, 0x2880809d08288080ULL, 0x80a608288080a408ULL, 0x08288080a8082880ULL,
0x8080aa08288080a9ULL, 0xb608288080ad0828ULL, 0x288080b908288080ULL, 0x80ef08288080ba08ULL,
0x08288080f1082880ULL, 0x8080860828808182ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001263000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8f082880808a0828ULL, 0x2880809308288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080a608288080a4ULL, 0xa908288080a80828ULL, 0x288080aa08288080ULL, 0x80b608288080ad08ULL,
0x08288080b9082880ULL, 0x8080f108288080efULL, 0x8808288081820828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x000127a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8a08288080880828ULL, 0x2880808f08288080ULL,
0x809d082880809308ULL, 0x082880809e082880ULL, 0x8080a4082880809fULL, 0xa808288080a60828ULL,
0x288080a908288080ULL, 0x80b608288080ad08ULL, 0x08288080b9082880ULL, 0x8080f108288080efULL,
0xaa08288081820828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080aa920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000020000000000ULL, 0x000127e000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8a08288080880828ULL, 0x2880808f08288080ULL, 0x809d082880809308ULL, 0x082880809e082880ULL,
0x8080a6082880809fULL, 0xa908288080a80828ULL, 0x288080aa08288080ULL, 0x80b608288080ad08ULL,
0x08288080b9082880ULL, 0x8080f108288080efULL, 0xa408288081820828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080a4920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x000002d000000000ULL, 0x0001282000000000ULL, 0x0000016000000000ULL, 0x0000000000000000ULL,
0x0000001200082f04ULL, 0x00081204000000a2ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x00010c9000000030ULL, 0x0001100000010ff0ULL,
0x0001118000011170ULL, 0x0160290400011190ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001602804ULL, 0x00001a0000000120ULL,
0x00001b5000001a90ULL, 0x00001f5000001b80ULL, 0x00001fe000001f80ULL, 0x00003a9000002040ULL,
0x00003bf000003b20ULL, 0x0000403000003d10ULL, 0x000040b000004050ULL, 0x0000599000004110ULL,
0x00005af000005a20ULL, 0x00005f2000005c10ULL, 0x00005fa000005f40ULL, 0x0000775000006000ULL,
0x000078b0000077e0ULL, 0x00007cf0000079d0ULL, 0x00007d7000007d10ULL, 0x0000906000007dd0ULL,
0x0000b6c000009070ULL, 0x0000bec00000b900ULL, 0x00010a300000bef0ULL, 0x00010a7000010a60ULL,
0x00010aa000010a80ULL, 0x00010ae000010ac0ULL, 0x0001116000010af0ULL, 0x000111d0000111c0ULL,
0x000118f0000111e0ULL, 0x000119b000011940ULL, 0x00011a9000011a20ULL, 0x00011b5000011b00ULL,
0x00011c0000011ba0ULL, 0x00011cd000011c70ULL, 0x00011d9000011d40ULL, 0x00011e4000011de0ULL,
0x00011f1000011eb0ULL, 0x00011fd000011f80ULL, 0x0001208000012020ULL, 0x00012150000120f0ULL,
0x00012210000121c0ULL, 0x000122c000012270ULL, 0x0001236000012310ULL, 0x00012400000123b0ULL,
0x000124c000012450ULL, 0x000125a000012540ULL, 0x04c0390400012600ULL, 0x000000ff00000220ULL,
0x003f01000000f600ULL, 0x00000003000002c0ULL, 0x003f01200000f608ULL, 0x0000000300000300ULL,
0x003f01200000f688ULL, 0x0000000300000380ULL, 0x003f01200000f6a8ULL, 0x00000003000003b0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000003400000630ULL,
0x003f01020000f68cULL, 0x00000034000006e0ULL, 0x003f01010000f688ULL, 0x000000ff00000c90ULL,
0x0004010700000000ULL, 0x000000ff00000d40ULL, 0x0004010100000000ULL, 0x0000003b00000da0ULL,
0x003f010100000020ULL, 0x0000005c00000ee0ULL, 0x003f010500000004ULL, 0x0000003b00000f50ULL,
0x003f010500000024ULL, 0x0000003b00000fd0ULL, 0x003f010500000024ULL, 0x0000004c000016d0ULL,
0x003f010700000000ULL, 0x0000004c000017c0ULL, 0x003f010100000000ULL, 0x0000002d000017d0ULL,
0x003f010500000004ULL, 0x0000005200001840ULL, 0x003f01010000f608ULL, 0x0000005200001860ULL,
0x003f01050000f60cULL, 0x0000002700001900ULL, 0x003f01050000f60cULL, 0x0000002d00001e40ULL,
0x003f010500000004ULL, 0x0000002d00001ec0ULL, 0x003f010500000004ULL, 0x0000003b00003130ULL,
0x003f010100000020ULL, 0x0000005d000031b0ULL, 0x003f01010000f688ULL, 0x0000005c00003200ULL,
0x003f010500000004ULL, 0x0000003b00003250ULL, 0x003f010500000024ULL, 0x0000003b000032d0ULL,
0x003f010500000024ULL, 0x0000005f00003800ULL, 0x003f010700000000ULL, 0x0000005f00003880ULL,
0x003f010100000000ULL, 0x0000006000003890ULL, 0x003f010500000004ULL, 0x0000006400003900ULL,
0x003f01010000f628ULL, 0x0000006400003920ULL, 0x003f01050000f62cULL, 0x00000024000039e0ULL,
0x003f01050000f62cULL, 0x0000002400003f00ULL, 0x003f01050000f6acULL, 0x0000002400003f80ULL,
0x003f01050000f6acULL, 0x0000003b00005040ULL, 0x003f010100000020ULL, 0x0000005d000050b0ULL,
0x003f01010000f690ULL, 0x0000005c000050f0ULL, 0x003f010500000004ULL, 0x0000003b00005140ULL,
0x003f010500000024ULL, 0x0000003b000051c0ULL, 0x003f010500000024ULL, 0x00000000000056f0ULL,
0x0005010700000000ULL, 0x0000000000005770ULL, 0x0005010100000000ULL, 0x0000004d00005780ULL,
0x0005010500000004ULL, 0x00000052000057f0ULL, 0x003f01010000f648ULL, 0x0000005200005810ULL,
0x003f01050000f64cULL, 0x00000026000058e0ULL, 0x003f01050000f64cULL, 0x0000002500005df0ULL,
0x003f01050000f6acULL, 0x0000002500005e70ULL, 0x003f01050000f6acULL, 0x0000003b00006f10ULL,
0x003f010100000020ULL, 0x0000005d00006f80ULL, 0x003f01010000f698ULL, 0x0000005c00006fe0ULL,
0x003f010500000004ULL, 0x0000003b00007030ULL, 0x003f010500000024ULL, 0x0000003b000070b0ULL,
0x003f010500000024ULL, 0x0000005f000074f0ULL, 0x003f010700000000ULL, 0x0000006a00007570ULL,
0x003f010100000000ULL, 0x0000006000007580ULL, 0x003f010500000004ULL, 0x00000064000075f0ULL,
0x003f01010000f668ULL, 0x0000006400007610ULL, 0x003f01050000f66cULL, 0x00000064000076a0ULL,
0x003f01050000f66cULL, 0x0000002400007bc0ULL, 0x003f01050000f6acULL, 0x0000002400007c40ULL,
0x003f01050000f6acULL, 0x0000003b00008c50ULL, 0x003f010100000020ULL, 0x0000005d00008cb0ULL,
0x003f01010000f6a0ULL, 0x000000ff0000cc40ULL, 0x003f01010000f600ULL, 0x000000ff0000da50ULL,
0x003f01050000f604ULL, 0x000000ff0000daf0ULL, 0x003f01050000f604ULL, 0x000000ff0000dd00ULL,
0x003f01010000f600ULL, 0x000000ff0000dd10ULL, 0x003f01050000f604ULL, 0x000000ff0000dda0ULL,
0x003f01050000f604ULL, 0x0000002e0000ff30ULL, 0x003f010100000000ULL, 0x0000002e0000ff70ULL,
0x003f010500000004ULL, 0x0000002e00010330ULL, 0x003f010500000004ULL, 0x0000003200011750ULL,
0x003f010100000000ULL, 0x00000032000117b0ULL, 0x003f010100000008ULL, 0x0000003200011810ULL,
0x003f010100000010ULL, 0x0000003200011880ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0000cb400000c8f0ULL, 0x0000deb00000de00ULL, 0x00000401000118c0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000038cULL, 0x0000001200000002ULL, 0x00000000000002bcULL, 0x0000001200000002ULL,
0x00000000000001ecULL, 0x0000001200000002ULL, 0x000000000000011cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000362ULL, 0x0000001200000002ULL,
0x0000000000000292ULL, 0x0000001200000002ULL, 0x00000000000001c2ULL, 0x0000001200000002ULL,
0x00000000000000f8ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x00005800ff287624ULL, 0x000fe200078e00ffULL, 0x0000000000127806ULL, 0x000fe200038e0000ULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000000828087824ULL, 0x000fe200078e00ffULL, 0x0000001200067300ULL, 0x000ee200000e0000ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x0000000000267919ULL, 0x000f240000002600ULL, 0x0000001200127309ULL, 0x000f640000000000ULL,
0x0000000000297919ULL, 0x000ee80000002700ULL, 0x0000000000327919ULL, 0x000f620000000000ULL,
0x00000005ff027819ULL, 0x002fc60000011603ULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x00001fff02027589ULL, 0x000fe200000e0000ULL, 0x000000010f007824ULL, 0x004fc600078e0200ULL,
0x00001fff0f0f7589ULL, 0x000ea200000e0000ULL, 0x0000008000037824ULL, 0x000fe400078e0203ULL,
0x0000000826007824ULL, 0x010fc600078e00ffULL, 0x000000ff0300720cULL, 0x040fe20003f45270ULL,
0x0000002908007224ULL, 0x008fe200078e0200ULL, 0x0000007f0300780cULL, 0x040fe20003f84070ULL,
0x00000010320e7824ULL, 0x020fe200078e00ffULL, 0x0000000f0300780cULL, 0x040fe40003f64070ULL,
0x000000030300780cULL, 0x000fe40003f24070ULL, 0x00000004ff117819ULL, 0x000fe40000011632ULL,
0x000000070600720cULL, 0x002fc40003f02070ULL, 0x000000f00e157812ULL, 0x000fe200078ec0ffULL,
0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL,
0x000000040f087824ULL, 0x004fe400078e0202ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0x00f60004ff00a388ULL, 0x0003e20000000a00ULL, 0x00000002080a7824ULL, 0x000fe200078e00ffULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x00f4000c0300c388ULL, 0x000fe20000004800ULL, 0x000000010a137824ULL, 0x040fe200078e0211ULL,
0x000000080a0b7817ULL, 0x000fe20007800000ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff089424ULL, 0x000fe400078e00ffULL, 0x0000000100047824ULL, 0x002fe200078e0213ULL,
0x00f608060300b388ULL, 0x0003e20000008a00ULL, 0x7fffff60ff099424ULL, 0x000fe400078e00ffULL,
0x000000010b007824ULL, 0x000fe400078e0a0aULL, 0x00005c0004047625ULL, 0x000fe200078e000dULL,
0x00f6880803009388ULL, 0x0005e40000008a00ULL, 0x000000001100720cULL, 0x000fe20003f66070ULL,
0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000713077812ULL, 0x002fe200078ec0ffULL, 0x3fffffc0ff0ca424ULL, 0x000fe200078e00ffULL,
0x0000001504067210ULL, 0x000fe20007f9e0ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x00f6a80a03009388ULL, 0x0003e20000008a00ULL, 0x0000000f07107812ULL, 0x000fe200078e7832ULL,
0x000000ffff007224ULL, 0x000fe400078e0a12ULL, 0x00f6c80c0300a388ULL, 0x0003e20000008a00ULL,
0x000000ffff077224ULL, 0x000fc400020e0605ULL, 0x0000001013107824ULL, 0x000fe400078e0210ULL,
0x00000004ff087424ULL, 0x004fe400078e00ffULL, 0x0000001010097824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000620029047625ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff307e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f03317810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03337810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff317819ULL, 0x000fe40000011631ULL, 0x00000008ff337819ULL, 0x000fca0000011633ULL,
0x0000c5e000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011602ULL,
0x0000000802347824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x01ffffff00057812ULL, 0x000fe200078ec0ffULL, 0xffffffffff357424ULL, 0x000fc800078e00ffULL,
0x0000000230547824ULL, 0x000fca00078e0205ULL, 0x000000315400720cULL, 0x000fda0003f06070ULL,
0x0000000229008824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640000058624ULL, 0x000fc800078e0205ULL, 0x0000000154058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0734ff738cULL, 0x0003e20000000000ULL,
0x0000600005048625ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604358981ULL, 0x0004e2000c1e1900ULL, 0x00000001ff3f7819ULL, 0x000fe20000011602ULL,
0x0000008026377824ULL, 0x000fe200078e00ffULL, 0x0000000102367812ULL, 0x000fe200078ec0ffULL,
0x00f6880034ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000130007810ULL, 0x000fe20007ffe0ffULL,
0x000020003f387824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x002fe20000011632ULL,
0x0000001036067824ULL, 0x000fe200078e00ffULL, 0x000000330000720cULL, 0x000fe20003f06070ULL,
0x0000000830057824ULL, 0x004fe200078e023fULL, 0x00000004070a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106097824ULL, 0x040fe200078e0207ULL, 0x00000008070c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002005007824ULL, 0x000fe200078e00ffULL, 0x0000000c07127810ULL, 0x000fe20007ffe0ffULL,
0x00000001060b7824ULL, 0x040fe200078e020aULL, 0x0000003209087212ULL, 0x040fe200078e3cffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000000003057217ULL, 0x000fe20007800000ULL,
0x000000080b0f7824ULL, 0x040fe200078e00ffULL, 0x000000320b047212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x040fe200078e0212ULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x0000000105057824ULL, 0x100fe200078e0a00ULL, 0x0000006037007812ULL, 0x000fe200078ef800ULL,
0x00000001060d7824ULL, 0x000fe200078e020cULL, 0xfffffff80f047812ULL, 0x000fe200078ee204ULL,
0x000000003f0473c2ULL, 0x000e6200000e0000ULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000000100097824ULL, 0x040fe200078e0209ULL, 0x000000320d107212ULL, 0x000fe200078e3cffULL,
0x00000001000f7824ULL, 0x040fe200078e020bULL, 0x0000000605057217ULL, 0x000fe20007800000ULL,
0x0000000100137824ULL, 0x040fe200078e020dULL, 0x0000003211147212ULL, 0x000fe200078e3cffULL,
0x0000000100157824ULL, 0x000fe200078e0211ULL, 0x0000b000380b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d177824ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000105057824ULL, 0x000fe200078e0a06ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000010080d7824ULL, 0x100fe200078e020bULL, 0xfffffff811147812ULL, 0x000fe200078ee214ULL,
0x0000001004117824ULL, 0x100fe200078e020bULL, 0x000000050c00720cULL, 0x080fe20003f26070ULL,
0x0000001010197824ULL, 0x100fe200078e020bULL, 0x000000050700720cULL, 0x080fe20003f66070ULL,
0x00000010141b7824ULL, 0x000fe200078e020bULL, 0x000000050a00720cULL, 0x080fe20003f46070ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x000000051200720cULL, 0x000fe20003f06070ULL,
0xff317217ff397424ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x0000f6a83f3b7811ULL, 0x000fe200078e18ffULL,
0x0000580035007a24ULL, 0x008fc800078e02ffULL, 0x0000008000007824ULL, 0x000fca00078e00ffULL,
0x0000000900097210ULL, 0x040fe40007f9e0ffULL, 0x0000000f000f7210ULL, 0x040fe40007fde0ffULL,
0x00005e00090c7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e000f077a11ULL, 0x000fe200078838ffULL, 0x000000ffff047224ULL, 0x000fe200030e06ffULL,
0x0000001300137210ULL, 0x000fe40007fde0ffULL, 0x00005f0009107a11ULL, 0x000fc400028f3c10ULL,
0x0000001500007210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005f000f0b7a11ULL, 0x000fe200020f3c04ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000700e0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200028e06ffULL,
0x00005e0013087a11ULL, 0x000fe400078838ffULL, 0x00005e00000a7a11ULL, 0x000fe400078c38ffULL,
0x0000000c0f047210ULL, 0x000fc40007fbe0ffULL, 0x00005f0013097a11ULL, 0x000fe400020f3c06ULL,
0x0000000f07067210ULL, 0x080fe20007f9e0ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00005f0000007a11ULL, 0x000fe200030f3c05ULL, 0x000000ffff057224ULL, 0x000fe200028e0610ULL,
0x0000000f08087210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e060bULL,
0x0000000f0a0a7210ULL, 0x000fe40007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0009e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc400028e0609ULL,
0x000000ffff0b7224ULL, 0x000fe200020e0600ULL, 0x0000000006117faeULL, 0x0003e8000d101c46ULL,
0x0000000008197faeULL, 0x0005e2000c901c46ULL, 0x000000333000720cULL, 0x000fc60003f26070ULL,
0x000000000a1b7faeULL, 0x0007e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000107805ULL, 0x002fc6000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000187805ULL, 0x004fe2000001ff00ULL, 0x00000000001a7805ULL, 0x008fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x010fec0000008000ULL,
0x00000000ff6a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003b247f8cULL, 0x0004e2000c80043fULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000203b5c7810ULL, 0x000fe20007ffe0ffULL,
0x00007ed000001947ULL, 0x000fea0003800000ULL, 0x00000002293c7824ULL, 0x004fe400078e00ffULL,
0x00006400ff177624ULL, 0x000fc400078e00ffULL, 0xff317217ff397424ULL, 0x000fe400078e00ffULL,
0x000064003c3c7624ULL, 0x000fe400078e0217ULL, 0x000000ffff4f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fe400078e00ffULL, 0x0000010030007824ULL, 0x000fca00078e00ffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x00007e0000000947ULL, 0x026fea0003800000ULL,
0x000004005c007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5b7224ULL, 0x000fe400078e0054ULL, 0x000000ffff3d7224ULL, 0x000fe200078e004fULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003b007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003b247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff5a7624ULL, 0x000fe200078e00ffULL, 0x0000000154007812ULL, 0x000fe200078ec0ffULL,
0x0000580035277a24ULL, 0x000fe200078e02ffULL, 0x00000003ff497819ULL, 0x000fe20000011632ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x000000010000780cULL, 0x000fc40003f05070ULL,
0xffffffff5a5a7811ULL, 0x000fc800078e08ffULL, 0x000000015a5a7807ULL, 0x000fca0004000000ULL,
0x0000000154547824ULL, 0x000fca00078e025aULL, 0x000000315400720cULL, 0x000fe20003f06070ULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x00000004494b7810ULL, 0x000fe20007ffe0ffULL,
0x00000100304a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff3f7819ULL, 0x000fe40000011602ULL,
0x0000001000267812ULL, 0x000fce00078ec0ffULL, 0x0000005a3c248210ULL, 0x000fe20007ffe05bULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0x0000000130007810ULL, 0x000fc60007ffe0ffULL,
0x0000600024248625ULL, 0x000fc800078e0025ULL, 0x000000014b437824ULL, 0x000fe200078e0226ULL,
0x0000000624358981ULL, 0x000562000c1e1900ULL, 0x000000330000720cULL, 0x000fe20003f06070ULL,
0x000000203f007824ULL, 0x000fe200078e024aULL, 0x00000008494d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000149417824ULL, 0x100fe200078e0226ULL, 0x0000003243627212ULL, 0x080fe200078e3cffULL,
0x00000080272b7824ULL, 0x000fe200078e00ffULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x000000014d457824ULL, 0x000fe200078e0226ULL, 0x0000000c49517810ULL, 0x000fe20007ffe0ffULL,
0x0000000843257824ULL, 0x004fe200078e00ffULL, 0x0000003241617212ULL, 0x080fe200078e3cffULL,
0x0000000845247824ULL, 0x040fe200078e00ffULL, 0x0000003245637212ULL, 0x000fe200078e3cffULL,
0x0000000841287824ULL, 0x000fe200078e00ffULL, 0xfffffff825627812ULL, 0x000fe200078ee262ULL,
0x0000000151477824ULL, 0x000fe200078e0226ULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x0000001032447824ULL, 0x000fe200078e00ffULL, 0xfffffff824637812ULL, 0x000fe200078ee263ULL,
0x000004e000007945ULL, 0x000fe20003800000ULL, 0xfffffff828617812ULL, 0x000fe200078ee261ULL,
0x0000000125257824ULL, 0x100fe200078e0a00ULL, 0x0000006037007812ULL, 0x000fe200078ef800ULL,
0x0000000847287824ULL, 0x040fe200078e00ffULL, 0x0000003247657212ULL, 0x000fc400078e3cffULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x0000000100247824ULL, 0x000fe200078e0241ULL,
0xfffffff828657812ULL, 0x000fe200078ee265ULL, 0x0000000100277824ULL, 0x040fe200078e0243ULL,
0x0000002625257217ULL, 0x000fe20007800000ULL, 0x0000000100287824ULL, 0x040fe200078e0245ULL,
0x000000242b247210ULL, 0x040fe20007f5e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0247ULL,
0x000000272b2d7210ULL, 0x040fe40007f7e0ffULL, 0x000000282b297210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005e00242e7a11ULL, 0x040fe200078438ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x000000002b2b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000125007824ULL, 0x000fe200078e0a26ULL, 0x00005f00242f7a11ULL, 0x000fe200010f3c2fULL,
0x000010004f247824ULL, 0x000fe200078e00ffULL, 0x00005e002d277a11ULL, 0x000fe200078438ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000000834527812ULL, 0x000fe200078ec0ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x0000100024247812ULL, 0x000fc400078e0cffULL,
0x00005f002d2d7a11ULL, 0x000fe400010f3c28ULL, 0x000000004900720cULL, 0x000fe20003f46070ULL,
0x000020003f257824ULL, 0x000fe200078e0224ULL, 0x00005e0029287a11ULL, 0x040fe400078638ffULL,
0x0000007044497812ULL, 0x000fe400078ec0ffULL, 0x00005f0029297a11ULL, 0x000fe400018f3c2cULL,
0x00005e002b2a7a11ULL, 0x000fc400078038ffULL, 0x000000492e247210ULL, 0x080fe20007f7e0ffULL,
0x000000084f2e7824ULL, 0x000fe200078e00ffULL, 0x0000b000252c7810ULL, 0x000fe40007ffe0ffULL,
0x00005f002b2b7a11ULL, 0x000fe200000f3c26ULL, 0x000000ffff257224ULL, 0x000fe200018e062fULL,
0x0000004927267210ULL, 0x080fe20007fbe0ffULL, 0x0000001061567824ULL, 0x100fe200078e022cULL,
0x000000004b00720cULL, 0x080fe20003f06070ULL, 0x0000001062577824ULL, 0x100fe200078e022cULL,
0x0000004928287210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024567faeULL, 0x0005e2000d101c46ULL,
0x000000004d00720cULL, 0x080fe20003f46070ULL, 0x0000001063587824ULL, 0x100fe200078e022cULL,
0x000000005100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0xfffffff034007812ULL, 0x000fe200078ec0ffULL, 0x0000001065597824ULL, 0x000fe200078e022cULL,
0x000000492a2a7210ULL, 0x000fc40007f9e0ffULL, 0x0000f6a8002d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000026577faeULL, 0x0007e2000c101c46ULL, 0x000000082e007812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x0000001034257812ULL, 0x044fe200078ec0ffULL,
0x0000000028587faeULL, 0x0005e2000d101c46ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000012d4c7824ULL, 0x000fe200078e0200ULL, 0xffffffe034007812ULL, 0x000fe200078ec0ffULL,
0x000000002a597faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000100277824ULL, 0x008fc800078e0225ULL, 0x0000000127527824ULL, 0x000fe400078e0252ULL,
0x000000004c0403c2ULL, 0x000ee40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012d2d7824ULL, 0x000fe200078e022eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000004c4c7f8cULL, 0x000ee8000c80043fULL, 0x000004002d007984ULL, 0x0008a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080052247f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x006fc6000784486bULL,
0x00f60c0052297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000000836277824ULL, 0x000fe400078e0227ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x004fe20003800000ULL,
0x00f60c0027297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002407824ULL, 0x000fe200078e00ffULL,
0x00000001ff427819ULL, 0x000fe40000011632ULL, 0x0000007044497812ULL, 0x000fe200078ec0ffULL,
0xffffffffff447424ULL, 0x000fe200078e00ffULL, 0xffffff8040407812ULL, 0x000fe400078ec0ffULL,
0x0000000c42427812ULL, 0x000fc800078ec0ffULL, 0x0000004042007210ULL, 0x000fca0007ffe049ULL,
0x00f0000000267984ULL, 0x000e680000000800ULL, 0x00f2000000277984ULL, 0x0005220000000800ULL,
0x000000392600720bULL, 0x002fe20003f1d000ULL, 0x0000fed27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x004fc800000e0100ULL, 0x0000ffff00297812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6c7424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe40000011602ULL,
0x000000392600720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x0000fe927f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000800225b824ULL, 0x000fe200078e0249ULL, 0x0000002639287209ULL, 0x040fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x000000014225b824ULL, 0x000fe400078e0225ULL,
0x8000002839247221ULL, 0x000fe20000010000ULL, 0x0000000029ff7212ULL, 0x000fc4000780c0ffULL,
0x00f400282500b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b24247820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fc60000011632ULL, 0x00000024006e7308ULL, 0x0002a20000000800ULL,
0x0000fe227f007947ULL, 0x000fea000b800000ULL, 0x00001f006e247589ULL, 0x0062a400000e0000ULL,
0x0000000800007810ULL, 0x002fe20007ffe0ffULL, 0x0000fe627f007947ULL, 0x000fea000b800000ULL,
0x00001f006e007589ULL, 0x00032400000e0000ULL, 0x8000002826260221ULL, 0x100fe20000010000ULL,
0x0000006e3a3a7220ULL, 0x000fe20000410000ULL, 0x0000000017177220ULL, 0x090fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26260820ULL, 0x000fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x00000026003e0308ULL, 0x000f220000000800ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x000fe20000410000ULL, 0x00000001ff6c7807ULL, 0x000fe20000000000ULL,
0x0000002415157220ULL, 0x084fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x000fe20000410000ULL,
0x000000ffff397224ULL, 0x000fe200078e0028ULL, 0x0000003e27270220ULL, 0x010fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003a273a7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x000004002d007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000524000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x000004002d247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003eff00723eULL, 0x000fe400000000ffULL,
0x00000002ff257819ULL, 0x000fc40000011632ULL, 0x00005410006e7816ULL, 0x002fe20000000000ULL,
0x0000fb027f007947ULL, 0x000fea000b800000ULL, 0x00001f256e5f7589ULL, 0x0002a400000e0000ULL,
0x0000000825467810ULL, 0x000fe20007ffe0ffULL, 0x0000fb427f007947ULL, 0x000fea000b800000ULL,
0x00001f466e007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010256f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff707424ULL, 0x000fe200078e00ffULL,
0x00001ff0002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x000107f000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018256f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff707424ULL, 0x000fe200078e00ffULL,
0x00002050002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x0001079000007944ULL, 0x03cfea0003c00000ULL, 0x00000002025d7824ULL, 0x000fe200078e00ffULL,
0x0000000732257812ULL, 0x002fe200078ec0ffULL, 0x00000200024b7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000045d837812ULL, 0x000fc400078ec0ffULL,
0x0000000825687812ULL, 0x000fe400078ef832ULL, 0x0000008332837211ULL, 0x000fe400078fe0ffULL,
0xfffff8004b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000000783257812ULL, 0x000fca00078e7868ULL,
0x0000000868487824ULL, 0x000fe200078e0225ULL, 0x0000000832257812ULL, 0x000fc600078ec0ffULL,
0x0000001048487824ULL, 0x000fe400078e024bULL, 0x0000000402247824ULL, 0x040fe200078e00ffULL,
0x00000007252d7812ULL, 0x140fe200078ec832ULL, 0x0000100002267824ULL, 0x000fe200078e00ffULL,
0x0000000725507812ULL, 0x000fe200078ef832ULL, 0x000010004f287824ULL, 0x040fe200078e0238ULL,
0x0000000424277812ULL, 0x000fe400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x00000027322c7211ULL, 0x000fe400078fe0ffULL, 0x0000008050707811ULL, 0x000fe200078e18ffULL,
0x000010004f267824ULL, 0x000fe200078e0226ULL, 0x0000002c2d537212ULL, 0x000fc400078e3cffULL,
0x0000b00028727810ULL, 0x000fe40007ffe0ffULL, 0x0000b000262e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000850517824ULL, 0x000fe200078e0253ULL, 0x000000022c2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000153537824ULL, 0x000fe200078e0270ULL, 0x000099106c947816ULL, 0x000fe200000000ffULL,
0x0000001051247824ULL, 0x000fe200078e022eULL, 0x0000002c2d557212ULL, 0x000fe200078e3cffULL,
0x0000001053287824ULL, 0x000fe200078e0272ULL, 0x000000ff9400720cULL, 0x000fc40003f05270ULL,
0x0000000283837810ULL, 0x000fe20007ffe0ffULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x0000000850507824ULL, 0x000fe400078e0255ULL, 0x0000000155557824ULL, 0x000fe200078e0270ULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x00000010502e7824ULL, 0x000fe200078e022eULL,
0x0000000783837812ULL, 0x000fe200078e7868ULL, 0x00000100242f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011424ULL, 0x00000100256d7824ULL, 0x000fe200078e00ffULL,
0x0000888024827816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001142fULL, 0x000001002a767824ULL, 0x010fe200078e00ffULL,
0x000000002e2c783bULL, 0x000e620000004200ULL, 0x00000018ff4e7819ULL, 0x004fe20000011428ULL,
0x0000006900897306ULL, 0x0005e20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff6e7819ULL, 0x000fe40000011425ULL, 0x00008880256a7816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000002400807306ULL, 0x0009e20000200c00ULL, 0x0000010027697824ULL, 0x004fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011476ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff697819ULL, 0x000fc40000011469ULL, 0x0000006a00887306ULL, 0x000fe20000200c00ULL,
0x0000010026247824ULL, 0x010fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011429ULL,
0x00000018ff5e7819ULL, 0x000fe4000001142aULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000069008f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff607819ULL, 0x000fe4000001142bULL,
0x000088802b767816ULL, 0x000fc400000000ffULL, 0x00000018ff667819ULL, 0x000fe40000011426ULL,
0x00000018ff677819ULL, 0x000fe20000011427ULL, 0x0000002400877306ULL, 0x0009e20000200c00ULL,
0x0000888028697816ULL, 0x004fe400000000ffULL, 0x00008880267e7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888027867816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x002fe2000001142cULL,
0x0000006d008b7306ULL, 0x0003e20000200c00ULL, 0x0000010028247824ULL, 0x050fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x000001002f6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011424ULL, 0x0000001055247824ULL, 0x000fe200078e0272ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x00000025008d7306ULL, 0x0005e20000200c00ULL,
0x00008880296d7816ULL, 0x002fe200000000ffULL, 0x000001002e927824ULL, 0x000fe200078e00ffULL,
0x000088802a727816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000088802c8a7816ULL, 0x000fc400000000ffULL, 0x00000018ff787819ULL, 0x000fe2000001142dULL,
0x0000002800737306ULL, 0x0003e20000200c00ULL, 0x0000010029257824ULL, 0x044fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000088802d8e7816ULL, 0x000fe400000000ffULL, 0x00000018ff707819ULL, 0x000fe40000011425ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000001002b287824ULL, 0x042fe200078e00ffULL,
0x0000002a007f7306ULL, 0x000fe20000200c00ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001142eULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000028007d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001142fULL, 0x00000018ff927819ULL, 0x000fca0000011492ULL,
0x0000002900757306ULL, 0x000fe20000200c00ULL, 0x000001002c287824ULL, 0x042fe400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011428ULL,
0x000001002d287824ULL, 0x040fe200078e00ffULL, 0x0000002b00817306ULL, 0x0003e20000200c00ULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff907819ULL, 0x000fe40000011428ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002600857306ULL, 0x000fe20000200c00ULL, 0x009000004828783bULL, 0x002e6e0000000200ULL,
0x0000002700847306ULL, 0x0005f00000200c00ULL, 0x0000008200827306ULL, 0x000f220000200c00ULL,
0x000000002424783bULL, 0x004eae0000004200ULL, 0x0000006b006b7306ULL, 0x000ef00000200c00ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000541082827816ULL, 0x010fce0000000089ULL,
0x0000002c00937306ULL, 0x0009e20000200c00ULL, 0x0000005f28288232ULL, 0x082fe40000000000ULL,
0x0000005f2a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000009000957306ULL, 0x000fe20000200c00ULL,
0x000088802f2c7816ULL, 0x050fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d00977306ULL, 0x0003e20000200c00ULL,
0x00000018ff7c7819ULL, 0x004fe40000011424ULL, 0x00000018ff7b7819ULL, 0x000fe40000011425ULL,
0x00000018ff797819ULL, 0x000fe40000011426ULL, 0x00000018ff7a7819ULL, 0x000fe20000011427ULL,
0x0000002c00907306ULL, 0x0005e20000200c00ULL, 0x00000018ff2d7819ULL, 0x002fce000001146cULL,
0x0000008c00917306ULL, 0x0003e20000200c00ULL, 0x00000008682c7824ULL, 0x004fe200078e0283ULL,
0x0000541088837816ULL, 0x000fc6000000008bULL, 0x000000102c4b7824ULL, 0x000fe200078e024bULL,
0x00005410802c7816ULL, 0x008fe4000000006bULL, 0x0000002d009b7306ULL, 0x0004e20000200c00ULL,
0x000088802e8c7816ULL, 0x042fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000082280c723cULL, 0x000fe8000000180cULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002f00687306ULL, 0x000fe20000200c00ULL, 0x00008880242d7816ULL, 0x004fca00000000ffULL,
0x000000ffff827224ULL, 0x000fe200078e002dULL, 0x000054108d2d7816ULL, 0x000fe2000000006eULL,
0x0000002e006c7306ULL, 0x0003e20000200c00ULL, 0x00008880256e7816ULL, 0x000fe400000000ffULL,
0x00005410908d7816ULL, 0x008fc6000000009bULL, 0x0000002c2804723cULL, 0x000fe40000001804ULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x00000100242e7824ULL, 0x042fe400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001142eULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x009000004b2c783bULL, 0x000ee20000000200ULL,
0x00000018ff247819ULL, 0x000fcc0000011424ULL, 0x0000007e007e7306ULL, 0x000f220000200c00ULL,
0x0000541085667816ULL, 0x004fce0000000066ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541084677816ULL, 0x002fce0000000067ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000000662808723cULL, 0x000fee0000001808ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0001000025667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000005f2c2c8232ULL, 0x088fe40000000000ULL,
0x0000005f2e2e8232ULL, 0x000fe20000000000ULL, 0x00000100265f7824ULL, 0x000fe200078e00ffULL,
0x000000002d2d8232ULL, 0x080fe40000000000ULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x0000008200887306ULL, 0x0009e20000200c00ULL, 0x0000888027007816ULL, 0x000fc400000000ffULL,
0x00000018ff5f7819ULL, 0x000fca000001145fULL, 0x0000002400677306ULL, 0x0007e20000200c00ULL,
0x000054107e827816ULL, 0x010fe20000000087ULL, 0x00000100257e7824ULL, 0x000fe200078e00ffULL,
0x0000541097257816ULL, 0x002fc80000000078ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x0000541093247816ULL, 0x008fce0000000074ULL,
0x0000008a008a7306ULL, 0x000ee20000200c00ULL, 0x00000024281c723cULL, 0x000fee000000181cULL,
0x0000008e008e7306ULL, 0x000f220000200c00ULL, 0x000054106c247816ULL, 0x004fe4000000006fULL,
0x0000541068257816ULL, 0x000fc40000000071ULL, 0x0000541086837816ULL, 0x002fc6000000008fULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x000054108a8a7816ULL, 0x008fe20000000091ULL,
0x000000242814723cULL, 0x040fec0000001814ULL, 0x0000009200997306ULL, 0x000e620000200c00ULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x000054108e8b7816ULL, 0x010fe20000000095ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x000000822820723cULL, 0x000fe40000001820ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00000018ff277819ULL, 0x000fc60000011427ULL, 0x0000008a2818723cULL, 0x000fe80000001818ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x000054108c8c7816ULL, 0x002fce0000000099ULL,
0x0000006b00897306ULL, 0x0002e20000200c00ULL, 0x0000008c2810723cULL, 0x000fee0000001810ULL,
0x0000004e004e7306ULL, 0x000f220000200c00ULL, 0x00008880266b7816ULL, 0x042fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00005410696a7816ULL, 0x004fc6000000006aULL,
0x000000ffff687224ULL, 0x000fe200078e006bULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000541088887816ULL, 0x008fce0000000089ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541073747816ULL, 0x010fce000000004eULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x0000541076737816ULL, 0x002fce000000007dULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541075757816ULL, 0x004fce0000000064ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000054107f5e7816ULL, 0x008fe2000000005eULL,
0x000000742c04723cULL, 0x000fec0000001804ULL, 0x0000007000707306ULL, 0x000e700000200c00ULL,
0x0000007200727306ULL, 0x000ff00000200c00ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000054106d6b7816ULL, 0x002fce0000000070ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x0000006a2c0c723cULL, 0x000fee000000180cULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x004fce0000000077ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410677c7816ULL, 0x002fe2000000007cULL, 0x000000722c20723cULL, 0x000fec0000001820ULL,
0x0000007a007a7306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000ff00000200c00ULL,
0x0000007e00837306ULL, 0x000e700000200c00ULL, 0x0000006600667306ULL, 0x000eb00000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054106e897816ULL, 0x002fce0000000083ULL,
0x0000005f00257306ULL, 0x0002e20000200c00ULL, 0x00005410667d7816ULL, 0x004fe2000000007bULL,
0x000000882c18723cULL, 0x040fec0000001818ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x00005410815f7816ULL, 0x002fe20000000060ULL, 0x0000007c2c1c723cULL, 0x040fec000000181cULL,
0x0000002400697306ULL, 0x000e620000200c00ULL, 0x0000541068687816ULL, 0x008fe20000000025ULL,
0x0000005e2c08723cULL, 0x000fec0000001808ULL, 0x0000002600267306ULL, 0x000eb00000200c00ULL,
0x0000002700277306ULL, 0x000ee20000200c00ULL, 0x0000541000697816ULL, 0x002fc40000000069ULL,
0x0000541026267816ULL, 0x004fca0000000079ULL, 0x000000682c10723cULL, 0x000fe20000001810ULL,
0x0000541027277816ULL, 0x008fce000000007aULL, 0x000000262c14723cULL, 0x000fe20000001814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003b247f8cULL, 0x0002a2000c80043fULL,
0xfffffff85d5d7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000404a007810ULL, 0x000fe20007ffe0ffULL, 0x00f688005dff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff6b7224ULL, 0x000fe200078e004dULL, 0x000000014f4f7812ULL, 0x000fe400078e0cffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x00005ae000000947ULL, 0x000fea0003800000ULL,
0x000004005c007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003b007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003b247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000130007810ULL, 0x000fe20007ffe0ffULL, 0x000000083d5e7824ULL, 0x040fe200078e00ffULL,
0x00000001ff3f7819ULL, 0x000fe20000011602ULL, 0x000010003d6a7824ULL, 0x000fe200078e00ffULL,
0x000000330000720cULL, 0x000fe20003f46070ULL, 0x0000580035287a24ULL, 0x020fe200078e02ffULL,
0x000000085e5f7812ULL, 0x000fe200078ec0ffULL, 0x000000103f007824ULL, 0x040fe200078e00ffULL,
0x000010006a267812ULL, 0x000fe200078ec0ffULL, 0x000000203f247824ULL, 0x000fe200078e024aULL,
0x000000085f257812ULL, 0x000fe200078e3cffULL, 0x00000080282b7824ULL, 0x000fe200078e00ffULL,
0x0000f6a800607810ULL, 0x000fe20007ffe0ffULL, 0x000020003f267824ULL, 0x000fe200078e0226ULL,
0x0000008024247810ULL, 0x000fe20007ffe0ffULL, 0x0000001002277824ULL, 0x000fe200078e00ffULL,
0x00000003ff4e7819ULL, 0x000fe20000011632ULL, 0x00000001605f7824ULL, 0x000fe200078e025fULL,
0x0000b00026267810ULL, 0x000fe20007ffe0ffULL, 0x0000000160607824ULL, 0x000fe200078e0225ULL,
0x0000002403257217ULL, 0x000fe20007800000ULL, 0x000000005f0473c2ULL, 0x000ea200000e0000ULL,
0x00000010272a7812ULL, 0x000fe200078ec0ffULL, 0x0000001061617824ULL, 0x000fe200078e0226ULL,
0x000000044e667810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x100fe200078e0a24ULL,
0x0000006037247812ULL, 0x000fe200078ef824ULL, 0x0000001062627824ULL, 0x100fe200078e0226ULL,
0x000000084e647810ULL, 0x000fe20007ffe0ffULL, 0x0000001063637824ULL, 0x100fe200078e0226ULL,
0x0000002025257807ULL, 0x000fe20001000000ULL, 0x0000001065657824ULL, 0x000fc400078e0226ULL,
0x0000000141267824ULL, 0x100fe200078e0224ULL, 0x000000252a257217ULL, 0x000fe20007800000ULL,
0x0000000143277824ULL, 0x100fe400078e0224ULL, 0x0000000145287824ULL, 0x100fe200078e0224ULL,
0x000000262b267210ULL, 0x000fe20007f1e0ffULL, 0x0000000147247824ULL, 0x000fe200078e0224ULL,
0x000000272b277210ULL, 0x040fe40007f5e0ffULL, 0x000000282b2d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005e00262c7a11ULL, 0x000fc400078038ffULL,
0x000000242b2b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005f00262e7a11ULL, 0x000fe200000f3c29ULL, 0x0000000125297824ULL, 0x000fe200078e0a2aULL,
0x00005e0027267a11ULL, 0x000fe200078038ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e002d287a11ULL, 0x040fe400078438ffULL, 0x000000296600720cULL, 0x000fe40003f66070ULL,
0x00005f002d2d7a11ULL, 0x000fc400010f3c24ULL, 0x000000492c247210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x00005f0027277a11ULL, 0x000fe400000f3c2aULL,
0x000000294e00720cULL, 0x040fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200028e062eULL,
0x00005e002b2a7a11ULL, 0x000fe400078838ffULL, 0x0000000c4e4e7810ULL, 0x000fe40007ffe0ffULL,
0x0000004928287210ULL, 0x000fc40007fbe0ffULL, 0x000000296400720cULL, 0x080fe40003f06070ULL,
0x00005f002b2b7a11ULL, 0x000fe400020f3c2cULL, 0x000000294e00720cULL, 0x000fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e062dULL, 0x0000004926267210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024617faeULL, 0x0007e2000d101c46ULL,
0x000000492a2a7210ULL, 0x000fe40007fbe0ffULL, 0x0000001000647812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x00000008342d7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e062bULL, 0xffffffe0342c7812ULL, 0x000fc400078ec0ffULL,
0x0000000026627faeULL, 0x0007e4000d901c46ULL, 0x0000002c2d647210ULL, 0x000fe40007ffe064ULL,
0x0000000028637faeULL, 0x0007e8000c101c46ULL, 0x000000002a657faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005f247f8cULL, 0x0084e8000c80043fULL, 0x0000040060297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280064267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc6000784484dULL,
0x00f62c00642b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x008fe200078e0025ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x0000001034247812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fc600078e00ffULL,
0x0000002c2d247210ULL, 0x000fe40007ffe024ULL, 0x0000000000257305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000250000735dULL, 0x010fe40003800000ULL,
0x00f62c0024257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008049257810ULL, 0x000fca0007ffe040ULL,
0x0000000142257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x000ee80000000800ULL,
0x00f2000025277984ULL, 0x0008620000000800ULL, 0x000000390000720bULL, 0x008fe20003f1d000ULL,
0x0000e0a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7b7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000102257811ULL, 0x000fe400078ff0ffULL, 0x000000390000720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x0000e0627f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000000039267209ULL, 0x040fe20007810000ULL,
0x00000080022bb824ULL, 0x000fe200078e0249ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe20000011632ULL, 0x00000001422bb824ULL, 0x000fe200078e022bULL,
0x8000002639257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400262b00b388ULL, 0x0007e60000000800ULL,
0x00000025006e7308ULL, 0x000f240000000800ULL, 0x0000006e3a3a7220ULL, 0x010fe20000410000ULL,
0x0000dfe27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e247589ULL, 0x00872400000e0000ULL,
0x000000240c0c7220ULL, 0x090fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x000fe20000410000ULL,
0x0000df227f007947ULL, 0x000fea000b800000ULL, 0x00001f466e247589ULL, 0x0008a400000e0000ULL,
0x0000000039397209ULL, 0x000fe20007810000ULL, 0x000000240e0e7220ULL, 0x084fe20000410000ULL,
0x00000001ff7b7807ULL, 0x000fe20000000000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x8000003900000221ULL, 0x000fe20000010000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x00000000003e0308ULL, 0x000ea20000000800ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x000fe20000410000ULL, 0x000000273e270220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003a273a7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000083d007824ULL, 0x000fe200078e00ffULL, 0xfffffff034257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x000364000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x020fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6f7819ULL, 0x008fe40000011632ULL,
0x0000003eff00723eULL, 0x000fe400000000ffULL, 0x000000186f247810ULL, 0x040fe40007ffe0ffULL,
0x000000106f257810ULL, 0x000fe40007ffe0ffULL, 0x00005410006e7816ULL, 0x010fe20000000000ULL,
0x0000dc727f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e6d7589ULL, 0x0002e400000e0000ULL,
0x0000dcb27f007947ULL, 0x000fea000b800000ULL, 0x00001f466e007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0025ULL,
0x000040c0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000e72000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0024ULL,
0x00004120002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000e6c000007944ULL, 0x01cfea0003c00000ULL,
0x000010003d257824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100002247824ULL, 0x000fc600078e00ffULL, 0x0000100025257812ULL, 0x000fe400078e0cffULL,
0xffffe00024247812ULL, 0x000fe400078ec0ffULL, 0x0000b00038667810ULL, 0x100fe40007ffe025ULL,
0x0000b00024687810ULL, 0x000fc60007ffe025ULL, 0x0000001053697824ULL, 0x000fe400078e0266ULL,
0x0000001051677824ULL, 0x100fe400078e0268ULL, 0x0000001050687824ULL, 0x000fe200078e0268ULL,
0x00000000692c783bULL, 0x000f620000004200ULL, 0x0000001055667824ULL, 0x000fc600078e0266ULL,
0x000000006728783bULL, 0x000f280000004200ULL, 0x00000000684c783bULL, 0x004ea80000004200ULL,
0x000000006624783bULL, 0x000ee20000004200ULL, 0x00000018ff747819ULL, 0x020fe4000001142dULL,
0x00000018ff6e7819ULL, 0x012fc4000001142cULL, 0x00000018ff7d7819ULL, 0x000fe20000011428ULL,
0x00000100287f7824ULL, 0x040fe200078e00ffULL, 0x00008880287e7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011429ULL,
0x0000010029847824ULL, 0x040fe200078e00ffULL, 0x0000888029817816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000007e00807306ULL, 0x0003e20000200c00ULL, 0x00000018ff797819ULL, 0x000fc4000001142aULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x00000018ff7a7819ULL, 0x000fe2000001142bULL, 0x0000002800827306ULL, 0x0009e20000200c00ULL,
0x000088802a7e7816ULL, 0x002fe400000000ffULL, 0x00000018ff777819ULL, 0x004fe4000001144cULL,
0x00000018ff767819ULL, 0x000fc4000001144fULL, 0x00000018ff757819ULL, 0x000fe2000001144eULL,
0x0000002900877306ULL, 0x0003e20000200c00ULL, 0x000001002a287824ULL, 0x050fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe4000001144dULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000001004c297824ULL, 0x002fe200078e00ffULL,
0x0000007f00837306ULL, 0x0003e20000200c00ULL, 0x00000018ff707819ULL, 0x000fc4000001142eULL,
0x00000018ff737819ULL, 0x000fe4000001142fULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff6f7819ULL, 0x008fe20000011424ULL, 0x0000008100857306ULL, 0x0005e20000200c00ULL,
0x000088802b7f7816ULL, 0x002fe400000000ffULL, 0x00000018ff727819ULL, 0x000fe40000011425ULL,
0x00000018ff6c7819ULL, 0x000fc40000011426ULL, 0x00000018ff717819ULL, 0x000fe20000011427ULL,
0x0000002a00887306ULL, 0x0003e20000200c00ULL, 0x000001002b817824ULL, 0x044fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000029008f7306ULL, 0x0005e20000200c00ULL, 0x000001004d2a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fc8000001142bULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002800897306ULL, 0x0003e20000200c00ULL, 0x000001004e297824ULL, 0x004fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b008d7306ULL, 0x0005e20000200c00ULL,
0x000088804c287816ULL, 0x042fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000002a00917306ULL, 0x0003e20000200c00ULL,
0x000088804f2b7816ULL, 0x004fce00000000ffULL, 0x00000028008c7306ULL, 0x0004e20000200c00ULL,
0x000001004f2a7824ULL, 0x042fe400078e00ffULL, 0x000100004f4f7824ULL, 0x000fca00078e00ffULL,
0x0000002900957306ULL, 0x0003e20000200c00ULL, 0x000088804e287816ULL, 0x044fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fcc00078e00ffULL, 0x0000002800927306ULL, 0x0005220000200c00ULL,
0x000001002c297824ULL, 0x002fe200078e00ffULL, 0x000054108c8c7816ULL, 0x008fcc000000008fULL,
0x0000004c008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff287819ULL, 0x004fe4000001144fULL,
0x00000018ff4f7819ULL, 0x000fe20000011429ULL, 0x000001002d297824ULL, 0x000fc800078e00ffULL,
0x0000002b00967306ULL, 0x000fe20000200c00ULL, 0x00000018ff4c7819ULL, 0x002fe4000001142aULL,
0x00000018ff2a7819ULL, 0x000fe4000001144eULL, 0x000088802c4e7816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x0000541092927816ULL, 0x010fe20000000095ULL,
0x0000004c00977306ULL, 0x0003e60000200c00ULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x0000002a00947306ULL, 0x000fe20000200c00ULL, 0x00000018ff4c7819ULL, 0x002fce0000011429ULL,
0x0000002800997306ULL, 0x0003f00000200c00ULL, 0x0000007e00867306ULL, 0x0005e20000200c00ULL,
0x009800004828783bULL, 0x002e6e0000000200ULL, 0x0000004c009b7306ULL, 0x0007e20000200c00ULL,
0x000088804d7e7816ULL, 0x044fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000007e00907306ULL, 0x0005e20000200c00ULL,
0x000099107b4c7816ULL, 0x008fc800000000ffULL, 0x000000ff4c00720cULL, 0x000fe40003f05270ULL,
0x00008880244c7816ULL, 0x000fe200000000ffULL, 0x0000008400847306ULL, 0x000ee20000200c00ULL,
0x000088802d7e7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000007d007d7306ULL, 0x000eb00000200c00ULL,
0x0000002d009d7306ULL, 0x0009e20000200c00ULL, 0x0000006d28288232ULL, 0x002fc40000000000ULL,
0x0000006d2a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x000001002f2d7824ULL, 0x010fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000081008b7306ULL, 0x000ff00000200c00ULL, 0x0000002c00817306ULL, 0x0009f00000200c00ULL,
0x0000007f008a7306ULL, 0x000be20000200c00ULL, 0x000088802f2c7816ULL, 0x050fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000004d00937306ULL, 0x0009e20000200c00ULL, 0x000088802e7f7816ULL, 0x020fce00000000ffULL,
0x0000002c009a7306ULL, 0x000be20000200c00ULL, 0x000001002e4d7824ULL, 0x050fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000002d009f7306ULL, 0x0007e20000200c00ULL, 0x00005410802c7816ULL, 0x020fe40000000083ULL,
0x00000018ff2e7819ULL, 0x000fca000001142eULL, 0x0000002e007b7306ULL, 0x0009e20000200c00ULL,
0x00005410852d7816ULL, 0x008fce0000000084ULL, 0x0000002c280c723cULL, 0x000fe2000000180cULL,
0x00000100242e7824ULL, 0x050fe200078e00ffULL, 0x0000004d00987306ULL, 0x0007e20000200c00ULL,
0x0001000024247824ULL, 0x000fc800078e00ffULL, 0x00005410822c7816ULL, 0x004fe4000000007dULL,
0x00005410872d7816ULL, 0x002fe2000000007cULL, 0x0000002f009c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4d7819ULL, 0x008fe4000001142eULL, 0x00008880257c7816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002c2804723cULL, 0x000fe40000001804ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x009800004b2c783bULL, 0x002e6e0000000200ULL,
0x0000007800787306ULL, 0x000ef00000200c00ULL, 0x0000004c00807306ULL, 0x0009f00000200c00ULL,
0x0000004d007d7306ULL, 0x000a620000200c00ULL, 0x00005410864c7816ULL, 0x010fc40000000089ULL,
0x000054108d897816ULL, 0x004fe4000000007aULL, 0x00005410938f7816ULL, 0x008fe40000000078ULL,
0x00005410908d7816ULL, 0x000fe20000000091ULL, 0x0000007900797306ULL, 0x000ea20000200c00ULL,
0x000054108a4d7816ULL, 0x020fe4000000008bULL, 0x0000541096937816ULL, 0x000fc60000000097ULL,
0x0000008c2818723cULL, 0x040fe40000001818ULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x0000006d2c2c8232ULL, 0x082fe20000000000ULL, 0x0000541080807816ULL, 0x000fe2000000007dULL,
0x0000006d2e2e8232ULL, 0x000fe20000000000ULL, 0x00000100266d7824ULL, 0x000fe200078e00ffULL,
0x000000002d2d8232ULL, 0x080fe20000000000ULL, 0x0000004c2820723cULL, 0x000fe20000001820ULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x0000541088887816ULL, 0x004fc40000000079ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x000000ffff4c7224ULL, 0x000fe200078e007cULL, 0x000000922810723cULL, 0x040fe20000001810ULL,
0x00000100257c7824ULL, 0x040fe200078e00ffULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x000054108e8e7816ULL, 0x008fe40000000077ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x000000882808723cULL, 0x000fe20000001808ULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x0000541094947816ULL, 0x002fcc0000000075ULL, 0x0000008e281c723cULL, 0x000fe2000000181cULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541099957816ULL, 0x004fe40000000076ULL,
0x000054109a997816ULL, 0x000fca000000009fULL, 0x0000004c00827306ULL, 0x000fe20000200c00ULL,
0x000000942814723cULL, 0x000fee0000001814ULL, 0x00000024004c7306ULL, 0x0005e20000200c00ULL,
0x0000010027287824ULL, 0x000fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002500777306ULL, 0x0009e20000200c00ULL, 0x0000888026247816ULL, 0x044fe200000000ffULL,
0x0001000026267824ULL, 0x000fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002400757306ULL, 0x0007e20000200c00ULL, 0x0000888027257816ULL, 0x010fce00000000ffULL,
0x0000002500297306ULL, 0x0003e20000200c00ULL, 0x0000541081247816ULL, 0x008fce000000006eULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000054109d257816ULL, 0x002fce0000000074ULL,
0x000000242c04723cULL, 0x000fe20000001804ULL, 0x0000007300737306ULL, 0x000e6c0000200c00ULL,
0x0001000027247824ULL, 0x000fe400078e00ffULL, 0x0000004e004e7306ULL, 0x000fe60000200c00ULL,
0x00000018ff2a7819ULL, 0x000fc40000011424ULL, 0x000054107b247816ULL, 0x004fc60000000070ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000054109c257816ULL, 0x002fce0000000073ULL,
0x0000007c004d7306ULL, 0x000e620000200c00ULL, 0x000000242c08723cULL, 0x000fee0000001808ULL,
0x0000006f006f7306ULL, 0x000ee20000200c00ULL, 0x000054104e4e7816ULL, 0x004fce000000004fULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0000541082817816ULL, 0x002fce000000004dULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000054104c4c7816ULL, 0x008fe2000000006fULL,
0x000000802c18723cULL, 0x000fec0000001818ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00005410774d7816ULL, 0x004fce0000000072ULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x0000004c2c1c723cULL, 0x000fee000000181cULL, 0x0000007f007f7306ULL, 0x000eb00000200c00ULL,
0x0000006d00007306ULL, 0x000ee20000200c00ULL, 0x000054107e4f7816ULL, 0x002fce000000009bULL,
0x0000002800287306ULL, 0x000e620000200c00ULL, 0x000054107f987816ULL, 0x004fe20000000098ULL,
0x0000004e2c0c723cULL, 0x040fec000000180cULL, 0x0000002600277306ULL, 0x000ea20000200c00ULL,
0x0000541075247816ULL, 0x008fe20000000000ULL, 0x000000982c20723cULL, 0x000fec0000001820ULL,
0x0000002a002a7306ULL, 0x000ee20000200c00ULL, 0x0000541029257816ULL, 0x002fc40000000028ULL,
0x00005410276c7816ULL, 0x004fca000000006cULL, 0x000000242c10723cULL, 0x000fe20000001810ULL,
0x000054102a6d7816ULL, 0x008fce0000000071ULL, 0x0000006c2c14723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003b247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000804a007810ULL, 0x000fe20007ffe0ffULL, 0x00f690005dff7f8cULL, 0x0007e2000c80043fULL,
0x000000013d4f7812ULL, 0x000fe400078ec0ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x00003bf000000947ULL, 0x000fea0003800000ULL, 0x000004005c007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003b007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x000024003b247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015b5b7824ULL, 0x000fe400078e025aULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x0000580035267a24ULL, 0x000fe200078e02ffULL,
0x000000015b247812ULL, 0x000fe200078ec0ffULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0xffffffff00007811ULL, 0x000fe400078e08ffULL, 0x000000012400780cULL, 0x000fc80003f05070ULL,
0x00000001005a7807ULL, 0x000fca0004000000ULL, 0x000000015b007824ULL, 0x000fe200078e025aULL,
0x00000001ff3f7819ULL, 0x000fc80000011602ULL, 0x000000310000720cULL, 0x000fe20003f06070ULL,
0x000000203f007824ULL, 0x000fca00078e024aULL, 0x000000c000007810ULL, 0x000fc80007ffe0ffULL,
0x0000000003277217ULL, 0x000fc60007800000ULL, 0x0000005a3c248210ULL, 0x000fe20007ffe05bULL,
0x00000004ff258424ULL, 0x000fe400078e00ffULL, 0x0000000127277824ULL, 0x100fe200078e0a00ULL,
0x0000006037007812ULL, 0x000fe200078ef800ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x0000000130287810ULL, 0x000fc60007ffe0ffULL, 0x00000080262b7824ULL, 0x000fe200078e00ffULL,
0x0000000624358981ULL, 0x000562000c1e1900ULL, 0x000000332800720cULL, 0x000fe20003f46070ULL,
0x0000001002287824ULL, 0x000fe200078e00ffULL, 0xfffffff034297812ULL, 0x000fe200078ec0ffULL,
0x0000000145267824ULL, 0x100fe200078e0200ULL, 0x000000085e4d7812ULL, 0x000fe400078ec0ffULL,
0x0000001028287812ULL, 0x000fe200078ec0ffULL, 0x00000000290573c2ULL, 0x00072200000e0000ULL,
0x0000002027277807ULL, 0x000fe20001000000ULL, 0x0000000141247824ULL, 0x104fe200078e0200ULL,
0x000000262b267210ULL, 0x000fe20007f7e0ffULL, 0x0000000143257824ULL, 0x100fe200078e0200ULL,
0x0000002728277217ULL, 0x000fe20007800000ULL, 0x0000000147007824ULL, 0x000fe200078e0200ULL,
0x000000242b247210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff297224ULL, 0x008fe200018e06ffULL,
0x000000252b257210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a28ULL,
0x000000002b2b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e06ffULL,
0x00005e00244c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x000000084d007812ULL, 0x000fc400078e3cffULL, 0x00005f00242f7a11ULL, 0x000fe200000f3c2fULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00000000000473c2ULL, 0x000ea200000e0000ULL,
0x00005e00252c7a11ULL, 0x000fe400078038ffULL, 0x00000003ff4e7819ULL, 0x000fe40000011632ULL,
0x00005e0026287a11ULL, 0x000fe200078438ffULL, 0x0000f6a805057890ULL, 0x010fe2000fffe03fULL,
0x00005e002b2a7a11ULL, 0x000fe400078638ffULL, 0x00005f00252d7a11ULL, 0x000fc400000f3c2eULL,
0x000000274e00720cULL, 0x000fe40003f06070ULL, 0x00005f0026297a11ULL, 0x000fe400010f3c29ULL,
0x00005f002b2b7a11ULL, 0x000fe400018f3c24ULL, 0x000000494c247210ULL, 0x000fe40007f5e0ffULL,
0x000000084e267810ULL, 0x040fe40007ffe0ffULL, 0x000000044e2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e062fULL, 0x0000000c4e4e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000405047290ULL, 0x004fe2000fffe03fULL, 0x000000272600720cULL, 0x000fc40003f66070ULL,
0x000000492c267210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0005e2000c101c46ULL, 0x000000272e00720cULL, 0x080fe40003f86070ULL,
0x000000274e00720cULL, 0x000fe20003f46070ULL, 0x000000ffff277224ULL, 0x000fe200028e062dULL,
0x0000004928287210ULL, 0x080fe40007f1e0ffULL, 0x000000492a2a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x000000ffff2b7224ULL, 0x000fe400028e062bULL,
0x0000000026577faeULL, 0x0007e8000e101c46ULL, 0x0000000028587faeULL, 0x0007e8000d901c46ULL,
0x000000002a597faeULL, 0x0007e8000d101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000567f8cULL, 0x0084e8000c800405ULL,
0x000004054d267984ULL, 0x0005220008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480052247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x010fc6000784486bULL, 0x00f64c0052277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe034267812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x004fe200078e00ffULL,
0x0000001034277812ULL, 0x040fe400078ec0ffULL, 0x0000000834287812ULL, 0x000fc800078ec0ffULL,
0x0000002628267210ULL, 0x000fe40007ffe027ULL, 0x0000000000277305ULL, 0x000524000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000270000735dULL, 0x010fe40003800000ULL,
0x00f64c0026277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010049257810ULL, 0x000fca0007ffe040ULL,
0x0000000142257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x004ea80000000800ULL,
0x00f2000025277984ULL, 0x0008620000000800ULL, 0x000000390000720bULL, 0x004fe20003f1d000ULL,
0x0000c3e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7f7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000202257811ULL, 0x000fe400078ff0ffULL, 0x000000390000720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x0000c3a27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000000039267209ULL, 0x040fe20007810000ULL,
0x00000080022bb824ULL, 0x000fe200078e0249ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe20000011632ULL, 0x00000001422bb824ULL, 0x000fe200078e022bULL,
0x8000002639257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400262b00b388ULL, 0x0005e60000000800ULL,
0x00000025006e7308ULL, 0x000f240000000800ULL, 0x0000006e3a3a7220ULL, 0x010fe20000410000ULL,
0x0000c3227f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e247589ULL, 0x00452400000e0000ULL,
0x000000240c0c7220ULL, 0x090fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x000fe20000410000ULL,
0x0000c2627f007947ULL, 0x000fea000b800000ULL, 0x00001f466e247589ULL, 0x0008a400000e0000ULL,
0x0000000039397209ULL, 0x000fe20007810000ULL, 0x000000240e0e7220ULL, 0x084fe20000410000ULL,
0x00000001ff7f7807ULL, 0x000fe20000000000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x8000003900000221ULL, 0x000fe20000010000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x00000000003e0308ULL, 0x000ea20000000800ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x000fe20000410000ULL, 0x000000273e270220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003a273a7221ULL, 0x002fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000085e257812ULL, 0x000fe400078ec0ffULL, 0xfffffff034007812ULL, 0x000fca00078ec0ffULL,
0x0000000100257824ULL, 0x000fca00078e0225ULL, 0x00f6ac0025007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x00f6ac0025247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff6f7819ULL, 0x000fe40000011632ULL, 0x0000003eff00723eULL, 0x000fe400000000ffULL,
0x000000186f247810ULL, 0x040fe40007ffe0ffULL, 0x000000106f257810ULL, 0x000fe40007ffe0ffULL,
0x00005410006e7816ULL, 0x010fe20000000000ULL, 0x0000bfc27f007947ULL, 0x000fea000b800000ULL,
0x00001f6f6e597589ULL, 0x0002a400000e0000ULL, 0x0000c0027f007947ULL, 0x000fea000b800000ULL,
0x00001f466e007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0025ULL, 0x00005fb0002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x0000c83000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e0024ULL, 0x00006010002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x0000c7d000007944ULL, 0x03cfea0003c00000ULL, 0x000010006a2d7812ULL, 0x000fe200078ec0ffULL,
0x00001000022c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000099107f7f7816ULL, 0x000fe400000000ffULL, 0x0000b00038247810ULL, 0x000fe40007ffe02dULL,
0xffffe0002c2c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff7f00720cULL, 0x000fe20003f05270ULL,
0x0000001053287824ULL, 0x100fe200078e0224ULL, 0x0000b0002c4c7810ULL, 0x000fe20007ffe02dULL,
0x0000001055247824ULL, 0x000fc800078e0224ULL, 0x00000010512c7824ULL, 0x100fe200078e024cULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x00000010504c7824ULL, 0x000fc600078e024cULL,
0x000000002424783bULL, 0x000fe80000004200ULL, 0x000000002c2c783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x004ea20000004200ULL, 0x00000018ff6c7819ULL, 0x010fe2000001142bULL,
0x00000100296d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011428ULL,
0x000001002a6f7824ULL, 0x002fe200078e00ffULL, 0x0000006c00507306ULL, 0x0003e20000200c00ULL,
0x00000018ff537819ULL, 0x000fc40000011429ULL, 0x00000018ff527819ULL, 0x000fe2000001142aULL,
0x000001002d837824ULL, 0x008fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001142cULL,
0x000100002f8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe2000001146fULL,
0x000001004c8d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x002fe2000001142dULL,
0x0000006b00827306ULL, 0x0003e20000200c00ULL, 0x000088802b6f7816ULL, 0x000fe200000000ffULL,
0x000100004d7f7824ULL, 0x040fe200078e00ffULL, 0x000088802a707816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001142eULL,
0x000001004d8f7824ULL, 0x000fe200078e00ffULL, 0x000088802e867816ULL, 0x000fe200000000ffULL,
0x0000006c00847306ULL, 0x0005e20000200c00ULL, 0x00008880286b7816ULL, 0x002fe200000000ffULL,
0x000001004e917824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000018ff807819ULL, 0x000fe4000001142fULL, 0x000088802f897816ULL, 0x000fe200000000ffULL,
0x0000002a007d7306ULL, 0x0003e20000200c00ULL, 0x00000100286c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x00000018ff6e7819ULL, 0x000fe4000001146cULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x00008880296c7816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000088802d2a7816ULL, 0x042fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001144cULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002800727306ULL, 0x0003e20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000088804c8c7816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001144dULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002900747306ULL, 0x0005e20000200c00ULL, 0x000001002b287824ULL, 0x042fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc4000001144eULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000010024297824ULL, 0x004fe200078e00ffULL,
0x00000028007a7306ULL, 0x0003e20000200c00ULL, 0x000088804d8e7816ULL, 0x000fe400000000ffULL,
0x000088804e907816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011429ULL, 0x000001002c297824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001144fULL, 0x0000002b007b7306ULL, 0x000fe20000200c00ULL,
0x0000010025287824ULL, 0x002fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001148dULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff787819ULL, 0x000fe40000011428ULL,
0x000088802c287816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x0000002d00857306ULL, 0x000fe20000200c00ULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x00000018ff2c7819ULL, 0x000fc4000001142cULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fe40000011424ULL, 0x0000888024797816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff6a7819ULL, 0x000fe20000011425ULL, 0x0000002c002b7306ULL, 0x0002a20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000888025777816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x000fe40000011427ULL, 0x00000018ff547819ULL, 0x000fe20000011426ULL,
0x0000002900297306ULL, 0x000ee20000200c00ULL, 0x000001002e2c7824ULL, 0x042fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001142cULL,
0x000001002f2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001142eULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x000054102b827816ULL, 0x004fe40000000082ULL,
0x00000018ff8a7819ULL, 0x000fe4000001142cULL, 0x00a00000482c783bULL, 0x000ea20000000200ULL,
0x0000541028287816ULL, 0x008fe40000000029ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000054102a297816ULL, 0x002fce0000000083ULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x0000541085837816ULL, 0x000fce0000000084ULL, 0x0000008900897306ULL, 0x000ff00000200c00ULL,
0x0000008a008a7306ULL, 0x000ee20000200c00ULL, 0x0000541086867816ULL, 0x002fce0000000087ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000000592c2c8232ULL, 0x084fe40000000000ULL,
0x000000592e2e8232ULL, 0x000fe40000000000ULL, 0x000000002d2d8232ULL, 0x000fc60000000000ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x0000541089877816ULL, 0x008fcc000000008aULL, 0x000000282c0c723cULL, 0x040fe2000000180cULL,
0x0000008100817306ULL, 0x000fec0000200c00ULL, 0x000001004f287824ULL, 0x000fe200078e00ffULL,
0x000000822c04723cULL, 0x000fe20000001804ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000054108b897816ULL, 0x002fca0000000080ULL, 0x00000018ff827819ULL, 0x000fe20000011428ULL,
0x000000862c20723cULL, 0x000fe20000001820ULL, 0x00a000004b28783bULL, 0x000e620000000200ULL,
0x0000004c004d7306ULL, 0x0007e20000200c00ULL, 0x0000541088887816ULL, 0x004fce0000000081ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000088804f4c7816ULL, 0x048fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe400078e00ffULL, 0x0001000025817824ULL, 0x000fe200078e00ffULL,
0x000000882c08723cULL, 0x000fe40000001808ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff817819ULL, 0x000fce0000011481ULL,
0x0000007f007f7306ULL, 0x000eb00000200c00ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000005928288232ULL, 0x002fce0000000000ULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x000054107f257816ULL, 0x004fe2000000007eULL, 0x000000592a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x0000888027007816ULL, 0x000fe200000000ffULL, 0x0000009000907306ULL, 0x000ff00000200c00ULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x000054108c8c7816ULL, 0x002fce000000008dULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x0000541090907816ULL, 0x004fce0000000091ULL, 0x0000008e008e7306ULL, 0x000ff00000200c00ULL,
0x0000008f008f7306ULL, 0x000e700000200c00ULL, 0x0000004c004c7306ULL, 0x000ff00000200c00ULL,
0x0000008200837306ULL, 0x000ea20000200c00ULL, 0x000054108e8d7816ULL, 0x002fce000000008fULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x0000008c2c18723cULL, 0x000fee0000001818ULL,
0x0000004f00807306ULL, 0x000ee20000200c00ULL, 0x000054104c917816ULL, 0x004fce0000000083ULL,
0x0000002400827306ULL, 0x0005e20000200c00ULL, 0x000054104e4e7816ULL, 0x002fe20000000073ULL,
0x000000902c10723cULL, 0x000fec0000001810ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000054104d247816ULL, 0x004fe4000000007cULL, 0x00005410804f7816ULL, 0x008fca0000000075ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x000000242c1c723cULL, 0x040fee000000181cULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000010026257824ULL, 0x040fe200078e00ffULL,
0x0000888026247816ULL, 0x040fe200000000ffULL, 0x0000004e2c14723cULL, 0x000fe20000001814ULL,
0x0001000026267824ULL, 0x000fc400078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff267819ULL, 0x000fce0000011426ULL,
0x00000024004c7306ULL, 0x0003f00000200c00ULL, 0x00000025002d7306ULL, 0x0004e20000200c00ULL,
0x000054106b247816ULL, 0x002fce000000006eULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000054106c257816ULL, 0x004fce000000006dULL, 0x00000024280c723cULL, 0x000fe2000000180cULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054104c4c7816ULL, 0x008fca000000002dULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x0000541074737816ULL, 0x002fe20000000053ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x000054107b537816ULL, 0x000fe40000000050ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000541082827816ULL, 0x004fe20000000055ULL,
0x0000005200527306ULL, 0x000eb00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x002fce0000000051ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054107d527816ULL, 0x004fe20000000052ULL, 0x000000722804723cULL, 0x040fec0000001804ULL,
0x0000005800587306ULL, 0x000fe40000200c00ULL, 0x000000522808723cULL, 0x000fec0000001808ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410706e7816ULL, 0x002fce0000000071ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054106f6f7816ULL, 0x004fce000000007aULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000006e2820723cULL, 0x000fee0000001820ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000541079767816ULL, 0x002fce0000000076ULL, 0x0000008100817306ULL, 0x000e700000200c00ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000078ULL,
0x00000024004d7306ULL, 0x000ea20000200c00ULL, 0x0000541081837816ULL, 0x002fe2000000006aULL,
0x000000762818723cULL, 0x040fec0000001818ULL, 0x0000002600257306ULL, 0x000e640000200c00ULL,
0x00000082281c723cULL, 0x000fec000000181cULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x00005410004d7816ULL, 0x004fc4000000004dULL, 0x0000541025547816ULL, 0x002fca0000000054ULL,
0x0000004c2810723cULL, 0x000fe20000001810ULL, 0x0000541027557816ULL, 0x008fce0000000058ULL,
0x000000542814723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003b247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c04a4a7810ULL, 0x000fe20007ffe0ffULL,
0x00f698005dff7f8cULL, 0x0007e2000c80043fULL, 0x000000015b547824ULL, 0x000fe200078e025aULL,
0x000000013d4f7812ULL, 0x000fe200078e0cffULL, 0x000000ffff6b7224ULL, 0x000fe200078e0057ULL,
0x000000034a00720cULL, 0x000fda0003f06070ULL, 0x00001d0000000947ULL, 0x000fea0003800000ULL,
0x000004005c007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003b007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003b247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000f6a83f2f7811ULL, 0x000fe200078e20ffULL, 0x0000580035267a24ULL, 0x020fe200078e02ffULL,
0x0000030030007a10ULL, 0x000fe20007ffe0ffULL, 0x000000005f0473c2ULL, 0x0004e200000e0000ULL,
0x00000001ff3f7819ULL, 0x000fe20000011602ULL, 0x0000008026287824ULL, 0x000fe200078e00ffULL,
0x000000085e6a7812ULL, 0x000fc600078ec0ffULL, 0x0000000800247824ULL, 0x040fe200078e023fULL,
0x0000000100007810ULL, 0x000fe20007ffe0ffULL, 0x000000012f6a7824ULL, 0x000fe400078e026aULL,
0x0000002024247824ULL, 0x000fe200078e00ffULL, 0x000000330000720cULL, 0x000fc80003f06070ULL,
0x0000002403257217ULL, 0x000fe40007800000ULL, 0x0000006037007812ULL, 0x000fc600078ef824ULL,
0x0000000125257824ULL, 0x000fe400078e0a24ULL, 0x0000001002247824ULL, 0x000fe400078e00ffULL,
0x0000000141417824ULL, 0x100fe200078e0200ULL, 0x0000002025257807ULL, 0x000fe20000000000ULL,
0x0000000143437824ULL, 0x100fe200078e0200ULL, 0x0000001024267812ULL, 0x000fe200078ec0ffULL,
0x0000000145457824ULL, 0x100fe200078e0200ULL, 0x0000004128417210ULL, 0x000fe20007f5e0ffULL,
0x0000000147007824ULL, 0x000fe200078e0200ULL, 0x0000002526257217ULL, 0x000fc40007800000ULL,
0x0000004328437210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005e00412c7a11ULL, 0x000fe400078038ffULL, 0x0000004528457210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x0000000028297210ULL, 0x000fe20007f9e0ffULL,
0x0000000125007824ULL, 0x000fe200078e0a26ULL, 0x00000003ff257819ULL, 0x000fe40000011632ULL,
0x00005f00412d7a11ULL, 0x000fe200000f3c24ULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005e0043267a11ULL, 0x000fc400078038ffULL, 0x00005e0045287a11ULL, 0x000fe400078438ffULL,
0x0000000825417810ULL, 0x040fe40007ffe0ffULL, 0x0000000425477810ULL, 0x000fe40007ffe0ffULL,
0x00005f0043277a11ULL, 0x000fe400000f3c2aULL, 0x0000004926267210ULL, 0x000fe40007fbe0ffULL,
0x00005f00452b7a11ULL, 0x000fc400010f3c24ULL, 0x000000004100720cULL, 0x080fe20003f06070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x000000492c247210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000000c25417810ULL, 0x040fe40007ffe0ffULL,
0x000000002500720cULL, 0x080fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200030e062dULL,
0x000000004700720cULL, 0x000fe40003f46070ULL, 0x00005e00292a7a11ULL, 0x000fc400078838ffULL,
0x000000004100720cULL, 0x000fe40003fa6070ULL, 0x0000004928287210ULL, 0x080fe40007fde0ffULL,
0x00005f0029007a11ULL, 0x000fe400020f3c2cULL, 0x000000492a2a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200030e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024617faeULL, 0x0009e6000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe200020e0600ULL,
0x0000000026627faeULL, 0x0009e8000d101c46ULL, 0x0000000028637faeULL, 0x0009e8000c101c46ULL,
0x000000002a657faeULL, 0x0009e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006a6a7f8cULL, 0x000ea8000c80043fULL,
0x0000040060277984ULL, 0x0107220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680064247f8cULL, 0x000fe2000c80043fULL,
0x8000000027ff7812ULL, 0x010fc60007844857ULL, 0x00f66c0064297984ULL, 0x000f240000000800ULL,
0x8000000029ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000964000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x000000260000735dULL, 0x020fe20003800000ULL,
0x00f66c0064277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018049257810ULL, 0x000fca0007ffe040ULL,
0x0000000142257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x000f280000000800ULL,
0x00f2000025277984ULL, 0x0002e20000000800ULL, 0x000000390000720bULL, 0x010fe20003f1d000ULL,
0x0000a8627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24267812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4a7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000302257811ULL, 0x000fe400078ff0ffULL, 0x000000390000720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x0000a8227f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000000039287209ULL, 0x040fe20007810000ULL,
0x000000800249b824ULL, 0x000fe200078e0249ULL, 0x0000ffff24297812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe20000011632ULL, 0x000000014249b824ULL, 0x000fe200078e0249ULL,
0x8000002839257221ULL, 0x000fe20000010000ULL, 0x0000002926ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400284900b388ULL, 0x0003e60000000800ULL,
0x00000025006e7308ULL, 0x000f240000000800ULL, 0x0000006e3a3a7220ULL, 0x010fe20000410000ULL,
0x0000a7a27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e247589ULL, 0x00232400000e0000ULL,
0x000000240c0c7220ULL, 0x090fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x000fe20000410000ULL,
0x0000a6e27f007947ULL, 0x000fea000b800000ULL, 0x00001f466e247589ULL, 0x00086400000e0000ULL,
0x8000002800000221ULL, 0x100fe20000010000ULL, 0x00000001ff4a7807ULL, 0x000fe20000000000ULL,
0x000000240e0e7220ULL, 0x082fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x00000000003e0308ULL, 0x000e620000000800ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x000fe20000410000ULL,
0x000000ffff397224ULL, 0x000fe200078e0028ULL, 0x000000273e270220ULL, 0x00afc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003a273a7221ULL, 0x008fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000083d007824ULL, 0x000fe200078e00ffULL, 0xfffffff034257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x008fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6f7819ULL, 0x000fe40000011632ULL,
0x0000003eff25723eULL, 0x000fe400000000ffULL, 0x000000186f007810ULL, 0x040fe40007ffe0ffULL,
0x000000106f247810ULL, 0x000fe40007ffe0ffULL, 0x00005410256e7816ULL, 0x010fe20000000025ULL,
0x0000a4327f007947ULL, 0x000fea000b800000ULL, 0x00001f6f6e417589ULL, 0x0002e400000e0000ULL,
0x0000a4727f007947ULL, 0x000fea000b800000ULL, 0x00001f466e467589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0024ULL,
0x00007d80002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000aa6000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e0000ULL,
0x00007de0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000aa0000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006724783bULL, 0x000f620000004200ULL,
0x000099104a4a7816ULL, 0x000fc600000000ffULL, 0x00000000682c783bULL, 0x000fe20000004200ULL,
0x000000ff4a00720cULL, 0x000fc60003f05270ULL, 0x000000006928783bULL, 0x000f280000004200ULL,
0x000000006664783bULL, 0x000ee20000004200ULL, 0x00000018ff007819ULL, 0x020fe20000011424ULL,
0x0000010024517824ULL, 0x040fe200078e00ffULL, 0x0000888024497816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011426ULL,
0x0000010025557824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000010026597824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x00000018ff567819ULL, 0x000fe20000011455ULL,
0x000001002a797824ULL, 0x010fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc40000011425ULL,
0x00000018ff437819ULL, 0x000fe40000011427ULL, 0x0000888025537816ULL, 0x000fe200000000ffULL,
0x0000002400557306ULL, 0x0009e20000200c00ULL, 0x00008880275f7816ULL, 0x000fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff4f7819ULL, 0x000fe4000001142cULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000005100527306ULL, 0x000aa20000200c00ULL, 0x0000010027247824ULL, 0x050fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001142dULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001142eULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x00000059005e7306ULL, 0x0009e20000200c00ULL,
0x0000888026517816ULL, 0x060fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x004fe4000001142fULL, 0x00000018ff477819ULL, 0x000fe40000011428ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400627306ULL, 0x0005e20000200c00ULL,
0x000001002c597824ULL, 0x010fe200078e00ffULL, 0x0000888028717816ULL, 0x002fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011429ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000002600617306ULL, 0x0003e20000200c00ULL, 0x000088802d247816ULL, 0x004fe400000000ffULL,
0x0000888029737816ULL, 0x000fe400000000ffULL, 0x00000018ff457819ULL, 0x000fe4000001142bULL,
0x0000541049527816ULL, 0x000fe20000000052ULL, 0x00000024006c7306ULL, 0x0005e20000200c00ULL,
0x000001002d267824ULL, 0x042fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001142aULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x000088802a787816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000002500587306ULL, 0x0003e20000200c00ULL, 0x000001002e247824ULL, 0x004fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002700687306ULL, 0x0005e20000200c00ULL,
0x000088802c257816ULL, 0x042fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fc80000011479ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000024006e7306ULL, 0x0003e20000200c00ULL, 0x000001002f277824ULL, 0x004fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002500697306ULL, 0x0005e20000200c00ULL,
0x0000010028247824ULL, 0x042fe400078e00ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011424ULL, 0x0000010029247824ULL, 0x040fe200078e00ffULL,
0x00000026006d7306ULL, 0x0003e20000200c00ULL, 0x000088802e257816ULL, 0x044fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011424ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x00000059006a7306ULL, 0x000fe20000200c00ULL,
0x000088802f267816ULL, 0x042fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc80000011429ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002500597306ULL, 0x000e700000200c00ULL, 0x00000026006f7306ULL, 0x000ff00000200c00ULL,
0x0000002700707306ULL, 0x0005220000200c00ULL, 0x00005410596e7816ULL, 0x002fce000000006eULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00a800004824783bULL, 0x0042ae0000000200ULL,
0x0000005600567306ULL, 0x000f620000200c00ULL, 0x000001002b487824ULL, 0x002fe200078e00ffULL,
0x000054106f6f7816ULL, 0x010fc80000000070ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000000000547306ULL, 0x0006700000200c00ULL, 0x0000004000577306ULL, 0x0008a20000200c00ULL,
0x0000541053537816ULL, 0x020fc40000000056ULL, 0x00000018ff007819ULL, 0x008fca0000011466ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000541055547816ULL, 0x002fe40000000054ULL,
0x00000018ff407819ULL, 0x010fca0000011464ULL, 0x0000002800747306ULL, 0x0003e20000200c00ULL,
0x0000004124248232ULL, 0x084fe20000000000ULL, 0x0000541058557816ULL, 0x000fe20000000057ULL,
0x0000004126268232ULL, 0x000fe40000000000ULL, 0x0000004625258232ULL, 0x080fe40000000000ULL,
0x0000004627278232ULL, 0x000fe20000000000ULL, 0x0000004200607306ULL, 0x0005220000200c00ULL,
0x000088802b287816ULL, 0x042fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00005410515e7816ULL, 0x008fc6000000005eULL, 0x00000052240c723cULL, 0x000fe4000000180cULL,
0x0000004300637306ULL, 0x0002e20000200c00ULL, 0x00000018ff427819ULL, 0x004fca0000011467ULL,
0x000000542404723cULL, 0x000fe40000001804ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541061607816ULL, 0x010fe40000000060ULL, 0x00000018ff437819ULL, 0x002fc60000011465ULL,
0x0000006e2410723cULL, 0x000fe40000001810ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x0000541068617816ULL, 0x008fce0000000063ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000000602408723cULL, 0x000fee0000001808ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000005f005f7306ULL, 0x000e700000200c00ULL, 0x0000002c002c7306ULL, 0x000eb00000200c00ULL,
0x0000002d002d7306ULL, 0x000ee20000200c00ULL, 0x000054105f5f7816ULL, 0x002fce0000000062ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fe2000000004fULL,
0x0000005e2420723cULL, 0x000fec0000001820ULL, 0x0000002f002f7306ULL, 0x000ea20000200c00ULL,
0x000054102d2d7816ULL, 0x008fce0000000050ULL, 0x0000002900777306ULL, 0x0007e20000200c00ULL,
0x000054102e2e7816ULL, 0x002fe2000000004dULL, 0x0000002c241c723cULL, 0x000fec000000181cULL,
0x00000028007a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff297819ULL, 0x008fe2000001142bULL,
0x00000100662c7824ULL, 0x000fe200078e00ffULL, 0x000054102f2f7816ULL, 0x004fc8000000004eULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000029007c7306ULL, 0x0005e20000200c00ULL,
0x0000888064287816ULL, 0x002fe200000000ffULL, 0x0000002e2414723cULL, 0x000fec0000001814ULL,
0x00000048007b7306ULL, 0x0003e20000200c00ULL, 0x0000010065297824ULL, 0x004fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011429ULL, 0x0000002800527306ULL, 0x0005e20000200c00ULL,
0x00a800004b48783bULL, 0x002e620000000200ULL, 0x000054106c297816ULL, 0x000fcc000000006dULL,
0x0000002a002b7306ULL, 0x0007e20000200c00ULL, 0x0000888065287816ULL, 0x044fe200000000ffULL,
0x0001000065657824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000002800547306ULL, 0x0005e20000200c00ULL, 0x00000100642a7824ULL, 0x048fe400078e00ffULL,
0x0001000064647824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000541069287816ULL, 0x004fce000000006aULL, 0x000000282418723cULL, 0x000fe20000001818ULL,
0x0000002a00537306ULL, 0x00052c0000200c00ULL, 0x0000888067247816ULL, 0x040fe200000000ffULL,
0x0000010067267824ULL, 0x040fe200078e00ffULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0001000067677824ULL, 0x000fe200078e00ffULL, 0x00008880662a7816ULL, 0x044fe200000000ffULL,
0x0001000066667824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000004148488232ULL, 0x082fe20000000000ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x000000414a4a8232ULL, 0x000fe20000000000ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054102b447816ULL, 0x008fe20000000044ULL,
0x0000004649498232ULL, 0x080fe20000000000ULL, 0x0000541052527816ULL, 0x010fe20000000053ULL,
0x000000464b4b8232ULL, 0x000fc80000000000ULL, 0x0000002a002a7306ULL, 0x000ff00000200c00ULL,
0x0000002c00257306ULL, 0x000ea20000200c00ULL, 0x0000541078787816ULL, 0x002fe40000000079ULL,
0x000054107a797816ULL, 0x000fca000000007bULL, 0x0000002400247306ULL, 0x000fe40000200c00ULL,
0x000000784820723cULL, 0x000fec0000001820ULL, 0x00000026002d7306ULL, 0x000e620000200c00ULL,
0x000054102a2a7816ULL, 0x004fce0000000025ULL, 0x0000004700477306ULL, 0x000eb00000200c00ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00005410242b7816ULL, 0x002fce000000002dULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541074747816ULL, 0x004fe20000000047ULL,
0x0000002a4810723cULL, 0x000fec0000001810ULL, 0x0000004000407306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000054107c457816ULL, 0x002fce0000000045ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x000000444808723cULL, 0x000fee0000001808ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000ff00000200c00ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000007500767306ULL, 0x0004e20000200c00ULL, 0x0000541071727816ULL, 0x002fce0000000072ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x0000541077757816ULL, 0x004fce000000004cULL,
0x0000006400297306ULL, 0x000ea20000200c00ULL, 0x0000541073737816ULL, 0x008fe20000000076ULL,
0x000000744804723cULL, 0x040fec0000001804ULL, 0x0000006500287306ULL, 0x000ee20000200c00ULL,
0x0000541054537816ULL, 0x002fe20000000051ULL, 0x00000072480c723cULL, 0x040fec000000180cULL,
0x0000006600277306ULL, 0x000e620000200c00ULL, 0x0000541029407816ULL, 0x004fe20000000040ULL,
0x000000524818723cULL, 0x000fec0000001818ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541028417816ULL, 0x008fc40000000043ULL, 0x0000541027247816ULL, 0x002fca0000000000ULL,
0x00000040481c723cULL, 0x000fe2000000181cULL, 0x0000541067257816ULL, 0x004fce0000000042ULL,
0x000000244814723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003b247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0005dff7f8cULL, 0x0007e2000c80043fULL,
0x000000015b547824ULL, 0x000fe200078e025aULL, 0x000000013d4f7812ULL, 0x000fe400078ec0ffULL,
0x0000030030307a10ULL, 0x008fc80007ffe0ffULL, 0x000000333000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff819000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0010ULL,
0x000000ffff297224ULL, 0x000fe400078e001fULL, 0x000000ffff327224ULL, 0x000fe400078e0016ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0014ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0012ULL,
0x000000ffff2a7224ULL, 0x000fc400078e001eULL, 0x000000ffff287224ULL, 0x000fe400078e001dULL,
0x000000ffff277224ULL, 0x000fe400078e001cULL, 0x000000ffff257224ULL, 0x008fe400078e001bULL,
0x000000ffff267224ULL, 0x000fe400078e001aULL, 0x000000ffff247224ULL, 0x000fe400078e0019ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0018ULL, 0x0000000433007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff107224ULL, 0x000fc400078e000eULL, 0x000000ffff317224ULL, 0x000fe400078e0017ULL,
0x000000ffff307224ULL, 0x000fe400078e0015ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0013ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000bULL,
0x000000ffff1c7224ULL, 0x000fc400078e000aULL, 0x000000ffff187224ULL, 0x000fe400078e0009ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0008ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0007ULL,
0x000000ffff167224ULL, 0x000fe400078e0006ULL, 0x000000ffff147224ULL, 0x000fe400078e0005ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0004ULL, 0x000000ffff127224ULL, 0x000fe400078e000fULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe200078e000cULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x018000003a007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00008f8000067802ULL, 0x000fe40000000f00ULL, 0x000096b000007944ULL, 0x022fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003a00037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000003aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x000fca00078e00ffULL,
0x0000000604057981ULL, 0x000f28000c1e9900ULL, 0x0000000000037919ULL, 0x000ee80000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x008fe40000011603ULL,
0x0000000808037811ULL, 0x004fe200078ff0ffULL, 0x0000000005067220ULL, 0x010fca0000410000ULL,
0x00001f0706007589ULL, 0x000ea800000e0000ULL, 0x00001f0306037589ULL, 0x000ee200000e0000ULL,
0x0000001900197220ULL, 0x044fe20000410000ULL, 0x0000000e000e7220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x000fe20000410000ULL,
0x0000001003107220ULL, 0x048fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002a032a7220ULL, 0x040fe20000410000ULL, 0x0000002903297220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x000fe20000410000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200037812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00000001ff047819ULL, 0x000fe40000011603ULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x0000000800177811ULL, 0x000fe400078ff0ffULL, 0x0000000203057811ULL, 0x040fe400078ff8ffULL,
0x00000006030b7811ULL, 0x000fc400078ff8ffULL, 0x0000000704037812ULL, 0x100fe400078e780fULL,
0x00000007080a7812ULL, 0x040fe400078e780fULL, 0x0000000708087812ULL, 0x000fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0203ULL, 0x0000000705067812ULL, 0x100fe200078e780fULL,
0x0000100036037824ULL, 0x000fe200078e00ffULL, 0x000000070b0c7812ULL, 0x000fe200078e780fULL,
0x0000000817157824ULL, 0x000fe200078e0208ULL, 0x0000000704047812ULL, 0x100fe200078e7817ULL,
0x0000000800087824ULL, 0x000fe200078e00ffULL, 0x0000000705057812ULL, 0x100fe200078e7817ULL,
0x000000080f097824ULL, 0x000fe200078e0206ULL, 0x000000070b0b7812ULL, 0x000fe200078e7817ULL,
0x000000080f0d7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000817117824ULL, 0x040fe200078e0204ULL, 0x0000001b1406723eULL, 0x000fe200000000ffULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x000000190e05723eULL, 0x000fe200000000ffULL,
0x000000080f0f7824ULL, 0x000fc400078e020cULL, 0x0000000817177824ULL, 0x000fe200078e020bULL,
0x0000763205197816ULL, 0x000fe20000000006ULL, 0x000008003f047824ULL, 0x000fc800078e0203ULL,
0x0000001007077824ULL, 0x100fe400078e0204ULL, 0x00000010090b7824ULL, 0x100fe400078e0204ULL,
0x000000100d0d7824ULL, 0x100fe400078e0204ULL, 0x0000001011117824ULL, 0x100fe400078e0204ULL,
0x0000001013137824ULL, 0x100fe400078e0204ULL, 0x000000100f0f7824ULL, 0x000fc400078e0204ULL,
0x0000001015157824ULL, 0x100fe400078e0204ULL, 0x0000001017177824ULL, 0x000fe400078e0204ULL,
0x0000000107097824ULL, 0x000fe200078e0208ULL, 0x000000202107723eULL, 0x000fe200000000ffULL,
0x00000001080b7824ULL, 0x040fe400078e020bULL, 0x00000001080d7824ULL, 0x040fe400078e020dULL,
0x0000000108117824ULL, 0x000fc400078e0211ULL, 0x0000000108137824ULL, 0x040fe400078e0213ULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001d1808723eULL, 0x000fe400000000ffULL,
0x0000541005187816ULL, 0x000fe40000000006ULL, 0x0000001f2405723eULL, 0x000fc400000000ffULL,
0x000000272806723eULL, 0x000fe200000000ffULL, 0x0000001809007388ULL, 0x0005e60000000a00ULL,
0x00005410050a7816ULL, 0x000fe40000000006ULL, 0x0000541007187816ULL, 0x144fe40000000008ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002b2c07723eULL, 0x000fc400000000ffULL,
0x0000002f3008723eULL, 0x000fe200000000ffULL, 0x000000180b007388ULL, 0x0005e40000000a00ULL,
0x00007632050b7816ULL, 0x004fe40000000006ULL, 0x000000101205723eULL, 0x000fe400000000ffULL,
0x000000161a06723eULL, 0x000fe200000000ffULL, 0x0000000a0d007388ULL, 0x0005e60000000a00ULL,
0x00005410050c7816ULL, 0x000fc40000000006ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x00007632050d7816ULL, 0x000fe40000000006ULL,
0x000000222307723eULL, 0x000fe200000000ffULL, 0x0000000a0f007388ULL, 0x0005e20000000a00ULL,
0x0000001c1e08723eULL, 0x000fe400000000ffULL, 0x000000262505723eULL, 0x000fe200000000ffULL,
0x0000000c11007388ULL, 0x0007e20000000a00ULL, 0x0000002a2906723eULL, 0x000fc800000000ffULL,
0x0000541005207816ULL, 0x140fe40000000006ULL, 0x0000763205217816ULL, 0x000fe20000000006ULL,
0x000000203f0a7824ULL, 0x004fe200078e0200ULL, 0x00005410070c7816ULL, 0x008fc60000000008ULL,
0x000000100a0b7824ULL, 0x000fe200078e0203ULL, 0x00007632070d7816ULL, 0x000fe40000000008ULL,
0x0000002e2d07723eULL, 0x000fe400000000ffULL, 0x000000323108723eULL, 0x000fe200000000ffULL,
0x0000000c13007388ULL, 0x000fe60000000a00ULL, 0x0000541007067816ULL, 0x140fe20000000008ULL,
0x0000002015007388ULL, 0x000fe20000000a00ULL, 0x0000763207077816ULL, 0x000fca0000000008ULL,
0x0000000617007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000b0c7984ULL, 0x000ea80000000c00ULL, 0x000800000b107984ULL, 0x000ee80000000c00ULL,
0x000400000b187984ULL, 0x000f280000000c00ULL, 0x000c00000b1c7984ULL, 0x000e620000000c00ULL,
0x200000ff0d0d7230ULL, 0x004fc40000000000ULL, 0x200000ff0f0f7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x008fe20000000000ULL, 0x00000300ff117624ULL, 0x000fe200078e00ffULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x000000011100780cULL, 0x000fe20003f05270ULL, 0x200000ff1b1b7230ULL, 0x010fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fc40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x000fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x002fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000000c0b007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x000400180b007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000580011057a24ULL, 0x000fe200078e02ffULL,
0x000000013fff7812ULL, 0x000fe2000780f802ULL, 0x00000800ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00006600050c7a24ULL, 0x002fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000000ff0000720cULL, 0x000fe20000725670ULL,
0x000000000b147984ULL, 0x0002e40000000c00ULL, 0x000007ff0c057811ULL, 0x000fe200078e40ffULL,
0x0000580010107a24ULL, 0x004fc400078e0207ULL, 0x0000040036077824ULL, 0x000fe400078e00ffULL,
0x0000030010067a24ULL, 0x000fca00078e02ffULL, 0x00000004060d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000d05087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000007080e7210ULL, 0x000fe40007f5e0ffULL, 0x01ffffff0c087812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e0609ULL, 0x000000100a0e7825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x000fe200078e0208ULL, 0x000000700a137812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b127812ULL, 0x000fe200078ec0ffULL, 0x00006c000d0a7625ULL, 0x000fc800078e0009ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0009ULL, 0x0000000a120a7210ULL, 0x000fc80007a1e013ULL,
0x0000000c120c7210ULL, 0x000fe40007c7e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x000000390a007986ULL, 0x0003e8000c101906ULL,
0x0000003a0c007986ULL, 0x0003e4000c101906ULL, 0x0000000000007941ULL, 0x00afea0003800000ULL,
0x000000140e007986ULL, 0x0003e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff11097810ULL, 0x000fc60007ffe0ffULL,
0x00006a00100a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000090a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x000000090a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff097984ULL, 0x000ee40000000000ULL, 0x000000ff0900720cULL, 0x008fda0003f05270ULL,
0x00002b9000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x00000001060c7810ULL, 0x004fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x002fe200078e00ffULL, 0x0000000c0a157812ULL, 0x000fe400078ec0ffULL,
0x0000007009137812ULL, 0x000fe200078ec0ffULL, 0x00006c00060a7625ULL, 0x000fc800078e000fULL,
0x00006c000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000c150c7210ULL, 0x000fe40007b5e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a097981ULL, 0x000368000c1e1900ULL,
0x000000060c0e7981ULL, 0x000362000c1e1900ULL, 0x000000021100780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081100780cULL, 0x002fe40003f06070ULL,
0x00000006060a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fe40007a3e013ULL, 0x00000007060c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fe400078e000fULL,
0x000000060a187981ULL, 0x000366000c1e1900ULL, 0x0000000c150c0210ULL, 0x000fc80007c7e013ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c0c0981ULL, 0x000368000c1e1900ULL,
0x00000007110a7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0d7819ULL, 0x000fc8000001160aULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x020fe400078e0009ULL,
0x000000081a0f7824ULL, 0x040fe200078e00ffULL, 0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000d1a00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080f0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001c09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000e09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c09097209ULL, 0x000fe40007810000ULL,
0x000003000f007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x002fe200078e020fULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010000c7824ULL, 0x004fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007a3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0c7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000010000a7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011600ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL,
0x000000010b0a7824ULL, 0x000fca00078e020aULL, 0x000000090a007388ULL, 0x0203e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000001000097824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x000000013f107824ULL, 0x000fe200078e0206ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000800ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000000138387824ULL, 0x000fe200078e0203ULL,
0x0000000c0b0c7812ULL, 0x004fe200078ec0ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000010050a7211ULL, 0x000fe200078fa8ffULL, 0x000010f000007945ULL, 0x000fe20003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011602ULL, 0x000000010c307824ULL, 0x000fe200078e0209ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000fULL,
0x000000010d097812ULL, 0x000fe200078ec0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000020000d7810ULL, 0x000fe20007ffe0ffULL, 0x000000023f0c8824ULL, 0x140fe200078e0236ULL,
0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000023f0e8824ULL, 0x040fe200078e0236ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000020002027824ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000020c158824ULL, 0x100fe200078e0209ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000020e178824ULL, 0x000fe200078e0209ULL,
0x0000080002097812ULL, 0x000fe200078ec0ffULL, 0x00000001080e8824ULL, 0x000fe200078e0210ULL,
0x0000000030307984ULL, 0x000e620000000800ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000003003f007a0cULL, 0x000fe20003f26070ULL, 0x0000000138097824ULL, 0x000fc400078e0209ULL,
0x00006c000e0e8625ULL, 0x000fc800078e000fULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x0000000815158824ULL, 0x100fe400078e0200ULL, 0x0000000817178824ULL, 0x000fe400078e0200ULL,
0x000000100d0c7825ULL, 0x000fe200078e000aULL, 0x0000458015158811ULL, 0x000fe400078e20ffULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x0000001000137824ULL, 0x040fe400078e0209ULL,
0x00000010000a7825ULL, 0x000fc800078e000aULL, 0x00000010000e8825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e6000b901c46ULL,
0x0000001000108825ULL, 0x000fe200078e0010ULL, 0x003800000c137faeULL, 0x0007e6000b901c46ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000000000e158faeULL, 0x0009e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fc400078e00ffULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000010178faeULL, 0x0003e2000b901c46ULL, 0x00000000000a7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e003fULL,
0x0000000232337810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00000001062e7824ULL, 0x100fe200078e0233ULL,
0x00000001ff287819ULL, 0x000fe20000011633ULL, 0x00000800ff347424ULL, 0x000fe200078e00ffULL,
0x0000002000397810ULL, 0x000fe20007ffe0ffULL, 0x00000400332a7824ULL, 0x000fe200078e00ffULL,
0x0000002e05297211ULL, 0x000fe400078fa8ffULL, 0x00000001282c7812ULL, 0x000fc600078ec0ffULL,
0x00006c0029287625ULL, 0x000fc800078e0034ULL, 0x000000023f2d9824ULL, 0x000fe200078e0236ULL,
0x0000000728287210ULL, 0x000fe20007f1e0ffULL, 0x00000001082b9824ULL, 0x000fe400078e022eULL,
0x000000022d3b9824ULL, 0x000fe200078e022cULL, 0x000008002a2d7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff349424ULL, 0x000fe400078e00ffULL, 0x000000023f379824ULL, 0x000fe400078e0236ULL,
0x00006c002b2a9625ULL, 0x000fc800078e0034ULL, 0x0000000237379824ULL, 0x000fe400078e022cULL,
0x00000080ff2f9424ULL, 0x000fe400078e00ffULL, 0x00000001382d7824ULL, 0x000fe400078e022dULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x00006c002e2e9625ULL, 0x000fc800078e002fULL,
0x0000001000357824ULL, 0x060fe400078e022dULL, 0x0000000837379824ULL, 0x000fe400078e0200ULL,
0x00000010002c9825ULL, 0x000fc600078e002aULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x000000083b3b9824ULL, 0x000fe400078e0200ULL, 0x00000010392a7825ULL, 0x000fc600078e0028ULL,
0x000041803b399811ULL, 0x000fe200078e20ffULL, 0x0000001000287825ULL, 0x000fc800078e0028ULL,
0x00000010002e9825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000028357faeULL, 0x0003e8000b901c46ULL, 0x003800002a357faeULL, 0x0003e8000b901c46ULL,
0x000000002c379faeULL, 0x0003e8000b901c46ULL, 0x000000002e399faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e0032ULL, 0x00000001ff2a7819ULL, 0x000fe20000011600ULL,
0x000000023f2b7824ULL, 0x000fe200078e0236ULL, 0x00000002ff357819ULL, 0x020fe20000011600ULL,
0x000000402d287824ULL, 0x000fe200078e00ffULL, 0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001000297824ULL, 0x000fe200078e00ffULL, 0x00000007353c7812ULL, 0x040fe200078ec0ffULL,
0x00000008352f7824ULL, 0x040fe200078e00ffULL, 0x0000008028287812ULL, 0x000fe200078ec0ffULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0x0000007029297812ULL, 0x000fc400078ec0ffULL,
0x00000035ff3e7212ULL, 0x000fe200078e33ffULL, 0x000001002b287824ULL, 0x000fc600078e0028ULL,
0xfffffff8373e7812ULL, 0x000fe400078ee23eULL, 0x000000282a2a7210ULL, 0x000fe20007ffe029ULL,
0x0000000835297824ULL, 0x000fe200078e00ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee23cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002a2b7984ULL, 0x000e620000000800ULL,
0x00000001292c7812ULL, 0x140fe400078ef63cULL, 0x00000002292e7812ULL, 0x140fe200078ef63cULL,
0x004580002a4e7984ULL, 0x0004e20000000800ULL, 0x0000000329327812ULL, 0x140fe400078ef63cULL,
0x0000000429347812ULL, 0x140fe400078ef63cULL, 0x00000005293a7812ULL, 0x140fe400078ef63cULL,
0x00000006293c7812ULL, 0x000fe200078ef63cULL, 0x000004002d297824ULL, 0x000fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x00000004002a7824ULL, 0x004fc600078e00ffULL,
0x0000080029297812ULL, 0x000fe200078ec0ffULL, 0x0000000837427824ULL, 0x040fe200078e00ffULL,
0x00000007372d7812ULL, 0x040fe200078ec0ffULL, 0x0000000837407824ULL, 0x040fe200078e00ffULL,
0x0000018038297810ULL, 0x000fe20007ffe029ULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x00000037ff4c7212ULL, 0x000fe400078e33ffULL, 0x0000000240447812ULL, 0x000fe200078ef62dULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000340467812ULL, 0x000fe200078ef62dULL,
0x000000103e3e7824ULL, 0x000fe200078e0229ULL, 0x0000000440487812ULL, 0x000fe200078ef62dULL,
0x000000102c2c7824ULL, 0x000fe200078e0229ULL, 0x00000005404a7812ULL, 0x000fe200078ef62dULL,
0x0000001032327824ULL, 0x100fe200078e0229ULL, 0xfffffff8394c7812ULL, 0x000fe200078ee24cULL,
0x000000102e2e7824ULL, 0x000fc400078e0229ULL, 0x000000103a3a7824ULL, 0x100fe400078e0229ULL,
0x0000001034347824ULL, 0x000fe200078e0229ULL, 0x0000002b302b7221ULL, 0x002fe20000010100ULL,
0x000000103c3c7824ULL, 0x100fe400078e0229ULL, 0x0000001044447824ULL, 0x100fe200078e0229ULL,
0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL, 0x0000000c2a2b7812ULL, 0x000fe200078ec0ffULL,
0x0000001046467824ULL, 0x000fe200078e0229ULL, 0xfffffff8422a7812ULL, 0x000fe200078ee22dULL,
0x0000001048487824ULL, 0x000fe200078e0229ULL, 0x0000000140427812ULL, 0x000fe200078ef62dULL,
0x0000000128287824ULL, 0x000fe200078e022bULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000012b3e7824ULL, 0x040fe200078e023eULL, 0x0000000640407812ULL, 0x000fe200078ef62dULL,
0x000000012b2c7824ULL, 0x000fc400078e022cULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b327824ULL, 0x040fe400078e0232ULL, 0x000000012b2e7824ULL, 0x040fe200078e022eULL,
0x000000003e3e7984ULL, 0x000ea20000000800ULL, 0x000000012b3a7824ULL, 0x040fe400078e023aULL,
0x000000012b347824ULL, 0x040fe200078e0234ULL, 0x000000002c2c7984ULL, 0x000fe20000000800ULL,
0x000000012b3c7824ULL, 0x000fe200078e023cULL, 0x0000004e2f507220ULL, 0x008fc40000410000ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000102a2a7824ULL, 0x100fe400078e0229ULL,
0x0000001042427824ULL, 0x000fe200078e0229ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x0000003150317221ULL, 0x000fe20000010000ULL,
0x000000012b427824ULL, 0x040fe200078e0242ULL, 0x000000003a3a7984ULL, 0x000fe20000000800ULL,
0x000000012b447824ULL, 0x040fe400078e0244ULL, 0x000000012b467824ULL, 0x000fe200078e0246ULL,
0x00001f35502d7589ULL, 0x000ee200000e0000ULL, 0x000000104a4a7824ULL, 0x000fc400078e0229ULL,
0x0000001040407824ULL, 0x100fe200078e0229ULL, 0x0000000034347984ULL, 0x000f220000000800ULL,
0x000000104c4c7824ULL, 0x000fe400078e0229ULL, 0x000000012b487824ULL, 0x040fe200078e0248ULL,
0x000000003c3c7984ULL, 0x000f220000000800ULL, 0x000000012b4a7824ULL, 0x040fe400078e024aULL,
0x000000012b407824ULL, 0x040fe200078e0240ULL, 0x000000002a2a7984ULL, 0x000f220000000800ULL,
0x000000012b4c7824ULL, 0x000fc600078e024cULL, 0x0000000042427984ULL, 0x000f220000000800ULL,
0x20000028ff4e7230ULL, 0x102fe40000004100ULL, 0x30000028ff2b7230ULL, 0x000fe20000004100ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x2000003eff287230ULL, 0x104fe40000004100ULL,
0x3000003eff2f7230ULL, 0x000fe20000004100ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x0000002d2b267223ULL, 0x088fe20000010026ULL, 0x0000002d28197223ULL, 0x080fe20000010019ULL,
0x2000002cff287230ULL, 0x100fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x3000002cff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2f187223ULL, 0x080fe20000010018ULL,
0x0000002d4e277223ULL, 0x080fe20000010027ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x0000002d28257223ULL, 0x080fe20000010025ULL, 0x20000032ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2b247223ULL, 0x000fe20000010024ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x3000002eff2f7230ULL, 0x000fc40000004100ULL, 0x0000002d28217223ULL, 0x080fe20000010021ULL,
0x000000004c4c7984ULL, 0x000fe20000000800ULL, 0x30000032ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2f227223ULL, 0x080fe20000010022ULL, 0x2000003aff287230ULL, 0x000fe20000004100ULL,
0x00001f3750297589ULL, 0x000ea200000e0000ULL, 0x2000002eff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b207223ULL, 0x080fe20000010020ULL, 0x30000034ff2f7230ULL, 0x010fe20000004100ULL,
0x0000002d281d7223ULL, 0x080fe2000001001dULL, 0x3000003aff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c237223ULL, 0x080fe20000010023ULL, 0x2000003cff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1e7223ULL, 0x080fe2000001001eULL, 0x20000034ff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b1c7223ULL, 0x080fe2000001001cULL, 0x3000003cff2f7230ULL, 0x000fe20000004100ULL,
0x0000002d281b7223ULL, 0x080fe2000001001bULL, 0x3000002aff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c1f7223ULL, 0x080fe2000001001fULL, 0x20000042ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1a7223ULL, 0x000fe2000001001aULL, 0x000000ffff327224ULL, 0x000fc400078e0033ULL,
0x2000002aff2c7230ULL, 0x000fe40000004100ULL, 0x20000044ff2a7230ULL, 0x102fe20000004100ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x30000044ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292b167223ULL, 0x084fe20000010016ULL, 0x0000002928157223ULL, 0x080fe20000010015ULL,
0x30000042ff2b7230ULL, 0x000fe20000004100ULL, 0x000000292a137223ULL, 0x080fe20000010013ULL,
0x20000046ff287230ULL, 0x000fe20000004100ULL, 0x000000292d127223ULL, 0x080fe20000010012ULL,
0x30000048ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292b147223ULL, 0x080fe20000010014ULL,
0x30000046ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002928117223ULL, 0x080fe20000010011ULL,
0x20000048ff287230ULL, 0x000fe20000004100ULL, 0x000000292d0e7223ULL, 0x080fe2000001000eULL,
0x2000004aff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b107223ULL, 0x080fe20000010010ULL,
0x3000004aff2b7230ULL, 0x000fe20000004100ULL, 0x00000029280f7223ULL, 0x080fe2000001000fULL,
0x20000040ff287230ULL, 0x100fe20000004100ULL, 0x000000292a0d7223ULL, 0x080fe2000001000dULL,
0x30000040ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292c177223ULL, 0x080fe20000010017ULL,
0x2000004cff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b0c7223ULL, 0x080fe2000001000cULL,
0x3000004cff2f7230ULL, 0x000fe20000004100ULL, 0x00000029280b7223ULL, 0x080fe2000001000bULL,
0x000000292d0a7223ULL, 0x080fe2000001000aULL, 0x000000292a097223ULL, 0x000fc40000010009ULL,
0x000000292f027223ULL, 0x000fe20000010002ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x0000001000057824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000100077824ULL, 0x000fe200078e0205ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000057824ULL, 0x002fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc80000011600ULL,
0x0000007005007812ULL, 0x000fe400078ec0ffULL, 0x0000000c06057812ULL, 0x000fc600078ec0ffULL,
0x000000803f007824ULL, 0x000fc800078e0200ULL, 0x0000000105007824ULL, 0x000fca00078e0200ULL,
0x0049803100007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800007007984ULL, 0x002e680000000800ULL,
0x004a000007057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0000ULL, 0x0000be1000067802ULL, 0x000fe40000000f00ULL,
0x0000682000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff057224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000067423ULL, 0x002fc80000000005ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff087819ULL, 0x004fe40000011600ULL, 0x0000000800287811ULL, 0x000fc600078ff0ffULL,
0x00001f0805067589ULL, 0x000ea200000e0000ULL, 0x00000028ff297212ULL, 0x000fe200078e33ffULL,
0x00000008282a7824ULL, 0x000fe400078e00ffULL, 0x00001f2805077589ULL, 0x00072600000e0000ULL,
0xfffffff82a297812ULL, 0x000fca00078ee229ULL, 0x0000001029297824ULL, 0x000fe200078e0204ULL,
0x00000008ff057212ULL, 0x008fe200078e33ffULL, 0x0000002706277220ULL, 0x044fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001806067220ULL, 0x000fe20000410000ULL, 0x0000000907097220ULL, 0x050fe20000410000ULL,
0x0000000207027220ULL, 0x040fe20000410000ULL, 0x0000000808187824ULL, 0x040fe200078e00ffULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x000fe20000410000ULL,
0x0000000708077812ULL, 0x000fc400078ec0ffULL, 0x000000212020723eULL, 0x000fe400000000ffULL,
0x000000090202723eULL, 0x000fe400000000ffULL, 0xfffffff8182b7812ULL, 0x000fe200078ee205ULL,
0x0000000808057824ULL, 0x000fe200078e00ffULL, 0x0000000b0a0a723eULL, 0x000fe400000000ffULL,
0x0000000728217812ULL, 0x000fe400078ec0ffULL, 0x0000000107097812ULL, 0x000fc400078e3cffULL,
0x0000000d0c0c723eULL, 0x000fe400000000ffULL, 0x00000002070b7812ULL, 0x040fe400078e3cffULL,
0x0000000f0e0e723eULL, 0x000fe400000000ffULL, 0x00000003070d7812ULL, 0x000fe400078e3cffULL,
0x000000131212723eULL, 0x000fe400000000ffULL, 0x000000111010723eULL, 0x000fc400000000ffULL,
0x00000004070f7812ULL, 0x040fe400078e3cffULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000000400237824ULL, 0x000fe200078e00ffULL, 0x0000000507117812ULL, 0x040fe400078e3cffULL,
0x0000000607137812ULL, 0x000fe200078e3cffULL, 0x0000000808077824ULL, 0x040fe200078e0209ULL,
0x0000000321187812ULL, 0x000fe200078e3cffULL, 0x0000000808097824ULL, 0x000fe200078e020bULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000828157824ULL, 0x000fe200078e00ffULL,
0xfffffff805057812ULL, 0x000fe200078ee208ULL, 0x00000008080b7824ULL, 0x000fe200078e020dULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x00000008080d7824ULL, 0x000fe200078e020fULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x00000008080f7824ULL, 0x000fe200078e0211ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x00000008281b7824ULL, 0x000fe200078e0218ULL,
0x0000000c23187812ULL, 0x000fe200078ec0ffULL, 0x0000000808117824ULL, 0x000fe200078e0213ULL,
0xfffffff815137812ULL, 0x000fe200078ee228ULL, 0x0000001005057824ULL, 0x100fe200078e0204ULL,
0x0000000121087812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x0000000221157812ULL, 0x000fe200078e3cffULL, 0x0000001009097824ULL, 0x100fe200078e0204ULL,
0x00000004211d7812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0204ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000000118057824ULL, 0x000fe200078e0205ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0204ULL,
0x00000005211f7812ULL, 0x000fe200078e3cffULL, 0x0000000828177824ULL, 0x000fe200078e0208ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0204ULL,
0x000000190606723eULL, 0x000fe200000000ffULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0x0000000621217812ULL, 0x000fe200078e3cffULL, 0x0000000828197824ULL, 0x000fe200078e0215ULL,
0x0000002605007388ULL, 0x000fe20000000800ULL, 0x0000001011117824ULL, 0x000fc400078e0204ULL,
0x0000000118097824ULL, 0x040fe200078e0209ULL, 0x0000002407007388ULL, 0x000fe20000000800ULL,
0x000000102b087824ULL, 0x100fe400078e0204ULL, 0x00000001180b7824ULL, 0x000fe200078e020bULL,
0x0000002209007388ULL, 0x000fe20000000800ULL, 0x00000008281d7824ULL, 0x000fe400078e021dULL,
0x0000001013157824ULL, 0x000fe200078e0204ULL, 0x000000200b007388ULL, 0x000fe20000000800ULL,
0x00000001180d7824ULL, 0x000fc400078e020dULL, 0x00000008281f7824ULL, 0x000fe400078e021fULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x0000001e0d007388ULL, 0x000fe20000000800ULL,
0x00000001180f7824ULL, 0x000fe400078e020fULL, 0x0000000828217824ULL, 0x000fe400078e0221ULL,
0x0000001019197824ULL, 0x000fe200078e0204ULL, 0x0000001c0f007388ULL, 0x000fe20000000800ULL,
0x0000000118117824ULL, 0x000fc400078e0211ULL, 0x000000101b1b7824ULL, 0x000fe400078e0204ULL,
0x0000000118137824ULL, 0x040fe200078e0208ULL, 0x0000001a11007388ULL, 0x000fe20000000800ULL,
0x000000101d1d7824ULL, 0x100fe400078e0204ULL, 0x0000000118157824ULL, 0x040fe200078e0215ULL,
0x0000000613007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x100fe400078e0204ULL,
0x0000000118177824ULL, 0x000fe200078e0217ULL, 0x0000001615007388ULL, 0x000fe20000000800ULL,
0x0000001021217824ULL, 0x000fc400078e0204ULL, 0x0000000118197824ULL, 0x040fe200078e0219ULL,
0x0000001417007388ULL, 0x000fe20000000800ULL, 0x00000001181b7824ULL, 0x040fe400078e021bULL,
0x00000001181d7824ULL, 0x040fe200078e021dULL, 0x0000001219007388ULL, 0x000fe20000000800ULL,
0x00000001181f7824ULL, 0x040fe400078e021fULL, 0x0000000118217824ULL, 0x040fe200078e0221ULL,
0x000000101b007388ULL, 0x000fe20000000800ULL, 0x0000000118297824ULL, 0x000fc400078e0229ULL,
0x000000203f047824ULL, 0x000fe200078e0200ULL, 0x0000000e1d007388ULL, 0x000fe60000000800ULL,
0x0000001004087824ULL, 0x000fe200078e0203ULL, 0x0000000c1f007388ULL, 0x000fe80000000800ULL,
0x0000000a21007388ULL, 0x000fe80000000800ULL, 0x0000000229007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000008047984ULL, 0x000ea80000000c00ULL,
0x0004000008247984ULL, 0x000ee80000000c00ULL, 0x0008000008147984ULL, 0x000f280000000c00ULL,
0x000c0000082c7984ULL, 0x000e620000000c00ULL, 0x200000ff07077230ULL, 0x004fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000001707077230ULL, 0x010fe40000000000ULL,
0x0000001606067230ULL, 0x000fe40000000000ULL, 0x0000001505057230ULL, 0x000fe40000000000ULL,
0x0000001404047230ULL, 0x000fe40000000000ULL, 0x0000002f27277230ULL, 0x002fc40000000000ULL,
0x0000002e26267230ULL, 0x000fe20000000000ULL, 0x0000000408007388ULL, 0x0003e20000000c00ULL,
0x0000002d25257230ULL, 0x000fe40000000000ULL, 0x0000002c24247230ULL, 0x000fca0000000000ULL,
0x0004002408007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff3f00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000137810ULL, 0x000fe20007ffe0ffULL, 0x0000000000077919ULL, 0x002e620000002600ULL,
0x00000003ff117819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff047819ULL, 0x100fe20000011613ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000711057812ULL, 0x100fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704067812ULL, 0x000fe400078e4813ULL, 0x0ffffff805027812ULL, 0x000fc400078ef800ULL,
0x0ffffff806067812ULL, 0x000fc600078ef813ULL, 0x0000001002027824ULL, 0x100fe400078e0203ULL,
0x0000001006067824ULL, 0x000fc600078e0203ULL, 0x0000000002087984ULL, 0x0008a80000000c00ULL,
0x00000000060c7984ULL, 0x0044a20000000c00ULL, 0x0000000807107824ULL, 0x042fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff810037812ULL, 0x000fc400078ee211ULL, 0xfffffff807047812ULL, 0x000fe200078ee204ULL,
0x0000000836077824ULL, 0x040fe200078e00ffULL, 0x0000000403037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0x0000000404057c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x010fe200078040ffULL, 0x000000ffff067224ULL, 0x004fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fc400078240ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4410ULL,
0x00005b0005057a11ULL, 0x000fe400008f4406ULL, 0xfffffff836117812ULL, 0x000fe200078ee213ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x000fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0xffffffffff257424ULL, 0x000fc800078e00ffULL, 0x0000000230247824ULL, 0x000fca00078e0205ULL,
0x000000312400720cULL, 0x000fda0003f06070ULL, 0x0000000229058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e0224ULL, 0x0000600006068625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606258981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082d7981ULL, 0x000762000c1e9900ULL,
0x0000000130007810ULL, 0x000fe20007ffe0ffULL, 0x0000004002277824ULL, 0x000fe400078e00ffULL,
0x0000008026267824ULL, 0x000fe200078e00ffULL, 0x000000330000720cULL, 0x000fe20003f06070ULL,
0x00000100300b7824ULL, 0x000fc400078e0227ULL, 0x0000008028287824ULL, 0x000fc600078e00ffULL,
0x0000004026167812ULL, 0x000fe200078ef80bULL, 0x0000002825217224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011632ULL,
0x0000000b03007217ULL, 0x000fe40007800000ULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d067824ULL, 0x140fe200078e0216ULL, 0x000000181d237810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000101d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000621137210ULL, 0x000fe20007f1e0ffULL, 0x0000000111067824ULL, 0x100fe200078e0216ULL,
0x000000300e1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117077824ULL, 0x000fe200078e0216ULL,
0x00000003ff0d7819ULL, 0x000fe20000011632ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e00130a7a11ULL, 0x000fe200078038ffULL, 0x00000004170e7824ULL, 0x000fe200078e00ffULL,
0x0000000721127210ULL, 0x000fc40007f3e0ffULL, 0x00005f0013137a11ULL, 0x000fe200000f3c08ULL,
0x0000000123087824ULL, 0x000fe200078e0216ULL, 0x0000000621067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x000000030d0d7812ULL, 0x000fe400078e4832ULL,
0x0000000821087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e00060c7a11ULL, 0x000fe400078038ffULL, 0x00005e00120b7a11ULL, 0x000fe200078238ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005e0008107a11ULL, 0x000fc400078438ffULL,
0x00005f0006157a11ULL, 0x000fe400000f3c15ULL, 0x00005f0008147a11ULL, 0x000fe200010f3c07ULL,
0x0000000411087824ULL, 0x000fe200078e00ffULL, 0x0000000a1f067210ULL, 0x000fe40007f7e0ffULL,
0x000000001d00720cULL, 0x000fe40003f06070ULL, 0xfffffffc080a7812ULL, 0x000fe200078ee20dULL,
0x000000ffff077224ULL, 0x000fe200018e0613ULL, 0x00001000020f7811ULL, 0x000fc400078e68ffULL,
0x0000001f0c087210ULL, 0x080fe40007f7e0ffULL, 0x0ffffffc0d327812ULL, 0x000fe200078ef832ULL,
0x000000100a137824ULL, 0x000fe200078e020fULL, 0x000000001700720cULL, 0x080fe40003f46070ULL,
0xfffffffc0e0c7812ULL, 0x000fe200078ee20dULL, 0x00000004230e7824ULL, 0x000fe200078e00ffULL,
0x000000201d177810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012127a11ULL, 0x000fe200008f3c09ULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0x000000001100720cULL, 0x080fe20003f26070ULL,
0x0000001032117824ULL, 0x100fe200078e020fULL, 0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000100c157824ULL, 0x000fe200078e020fULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x00000001160c7824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x000000ffff0b7224ULL, 0x000fe200020e0612ULL,
0x000000002300720cULL, 0x000fc40003f86070ULL, 0x0000000c21127210ULL, 0x000fe40007f1e0ffULL,
0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000008137faeULL, 0x0005e2000c901c46ULL,
0x00005e00120c7a11ULL, 0x000fe400078c38ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a157faeULL, 0x0007e2000d101c46ULL, 0x000000ffff077224ULL, 0x002fe200000e06ffULL,
0x0000001f10067210ULL, 0x000fe40007fbe0ffULL, 0x000000001700720cULL, 0x000fc40003f66070ULL,
0x00005f0012127a11ULL, 0x000fe200030f3c07ULL, 0x000000ffff077224ULL, 0x000fe200028e0614ULL,
0xfffffffc0e087812ULL, 0x004fe200078ee20dULL, 0x000000041d147824ULL, 0x000fe200078e00ffULL,
0x000000001900720cULL, 0x080fe40003f46070ULL, 0x000000001b00720cULL, 0x080fe20003f26070ULL,
0x0000001008097824ULL, 0x000fe200078e020fULL, 0x000000001d00720cULL, 0x000fe20003f06070ULL,
0x0000000116007824ULL, 0x040fe400078e0219ULL, 0x0000000116087824ULL, 0x040fe200078e021bULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x00000001160a7824ULL, 0x008fe200078e021dULL,
0x0000000021107210ULL, 0x000fe20007fbe0ffULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0x00000008210e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000419087824ULL, 0x000fe200078e00ffULL,
0x0000000a210b7210ULL, 0x000fe20007fde0ffULL, 0x000000041b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fc400078ee20dULL, 0xfffffffc08087812ULL, 0x100fe400078ee20dULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL, 0x000000ffff077224ULL, 0x002fe200028e06ffULL,
0xfffffffc14067812ULL, 0x000fe200078ee20dULL, 0x0000001000117824ULL, 0x100fe200078e020fULL,
0x00005e0010097a11ULL, 0x000fe200078a38ffULL, 0x0000001008137824ULL, 0x100fe400078e020fULL,
0x000000100a157824ULL, 0x000fe200078e020fULL, 0x00005f0010107a11ULL, 0x000fe200028f3c07ULL,
0x00000010060f7824ULL, 0x000fe200078e020fULL, 0x0000001f0c067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005e000e0a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e000b0c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200028e0612ULL, 0x0000001f09087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000e0d7a11ULL, 0x000fe400020f3c0dULL, 0x0000001f0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0610ULL, 0x00005f000b007a11ULL, 0x000fe200030f3c00ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400020e060dULL, 0x0000000008137faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc400028e0600ULL, 0x000000000a157faeULL, 0x0003e8000c901c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001632007211ULL, 0x04afe400078ff0ffULL, 0x0000000832177811ULL, 0x040fe400078ff0ffULL,
0x0000000021007210ULL, 0x000fe40007f1e0ffULL, 0x0000001032067811ULL, 0x000fc400078ff0ffULL,
0x0000001832087811ULL, 0x000fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0000207a11ULL, 0x000fe400078038ffULL, 0x00000028320c7811ULL, 0x000fe200078ff0ffULL,
0x0000000116097824ULL, 0x000fe200078e0208ULL, 0x00005f0000227a11ULL, 0x000fe200000f3c07ULL,
0x0000000117007824ULL, 0x000fe200078e0216ULL, 0x00000020320a7811ULL, 0x000fe200078ff0ffULL,
0x0000000116077824ULL, 0x040fe200078e0206ULL, 0x00000003ff157819ULL, 0x000fe20000011632ULL,
0x00000001160d7824ULL, 0x000fe200078e020cULL, 0x00000030320f7811ULL, 0x000fe200078ff0ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x00000000211e7210ULL, 0x000fe20007fde0ffULL,
0x00000001160b7824ULL, 0x000fe200078e020aULL, 0x0000000315157812ULL, 0x000fe200078e4832ULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000003832117811ULL, 0x000fe200078ff0ffULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0x0000000721137210ULL, 0x040fe20007fbe0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x00000009211a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000116107824ULL, 0x000fe200078e020fULL, 0x0000100002237811ULL, 0x000fe200078e68ffULL,
0x000000040f147824ULL, 0x000fe200078e00ffULL, 0xfffffffc08077812ULL, 0x000fe200078ee215ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000000b21187210ULL, 0x000fe20007f3e0ffULL,
0x0000000116127824ULL, 0x000fe200078e0211ULL, 0xfffffffc0c097812ULL, 0x100fe200078ee215ULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x00005e001e1c7a11ULL, 0x000fe200078c38ffULL,
0x0000000411167824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee215ULL,
0x00000010071b7824ULL, 0x000fe200078e0223ULL, 0xfffffffc0a087812ULL, 0x000fe200078ee215ULL,
0x00000010091f7824ULL, 0x000fe200078e0223ULL, 0xfffffffc140a7812ULL, 0x000fe200078ee215ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c0fULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001021107210ULL, 0x040fe20007f7e0ffULL,
0x0000001000177824ULL, 0x000fe200078e0223ULL, 0x0000001221127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0xfffffffc06067812ULL, 0x000fe200078ee215ULL,
0x00000010081d7824ULL, 0x000fe200078e0223ULL, 0x00005e00180f7a11ULL, 0x000fc400078238ffULL,
0x0ffffffc15327812ULL, 0x000fe200078ef832ULL, 0x0000001006197824ULL, 0x100fe200078e0223ULL,
0x00005e001a0c7a11ULL, 0x000fe400078038ffULL, 0x0000000d210d7210ULL, 0x000fe20007f5e0ffULL,
0x000000100a217824ULL, 0x000fe200078e0223ULL, 0xfffffffc160b7812ULL, 0x000fe200078ee215ULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x000000300e2b7812ULL, 0x000fe200078ec0ffULL,
0x00000010322f7824ULL, 0x100fe200078e0223ULL, 0x00005e00130a7a11ULL, 0x000fe200078a38ffULL,
0x000000100b237824ULL, 0x000fe200078e0223ULL, 0x00005f0018187a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e0012147a11ULL, 0x000fc400078638ffULL,
0x000000202b067210ULL, 0x000fe40007f1e0ffULL, 0x00005f00130b7a11ULL, 0x000fe400028f3c00ULL,
0x00005e000d117a11ULL, 0x040fe400078238ffULL, 0x00005e0010137a11ULL, 0x000fe400078438ffULL,
0x00005f0012007a11ULL, 0x000fe200018f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0622ULL,
0x00005f000d167a11ULL, 0x000fc400008f3c16ULL, 0x0000001c2b087210ULL, 0x040fe40007f1e0ffULL,
0x00005f0010157a11ULL, 0x000fe200010f3c15ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062f7faeULL, 0x0003e2000b901c46ULL, 0x0000000a2b0a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e061eULL, 0x0000000c2b0c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000f2b0e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000000112b107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061aULL,
0x000000132b127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0618ULL,
0x000000142b147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0616ULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400028e0615ULL,
0x000000ffff157224ULL, 0x000fe200000e0600ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000333000720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000002c7919ULL, 0x000e620000000000ULL,
0x3db504f32d2d7820ULL, 0x020fe20000410000ULL, 0x0000640029297a24ULL, 0x000fe200078e02ffULL,
0x0000f688022e7811ULL, 0x040fe200078e18ffULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0xffffffff332f7810ULL, 0x000fe40007ffe0ffULL, 0x0000f60802327811ULL, 0x000fe400078e28ffULL,
0x00000100302a7824ULL, 0x000fe200078e0227ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002a0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e0035ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000100347810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x0000000137357812ULL, 0x000fe200078e0cffULL, 0x0000002825477224ULL, 0x020fe200078e02ffULL,
0x00000001ff2b7819ULL, 0x000fc40000011634ULL, 0x000000023400780cULL, 0x040fe40003f06070ULL,
0x0000000134567812ULL, 0x000fe200078ec0ffULL, 0x000003002b367a24ULL, 0x000fe400078e0230ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0000ULL, 0x00000100363f7824ULL, 0x040fe200078e0227ULL,
0x0000000136387810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fc600078e0034ULL,
0x000000333800720cULL, 0x000fe40003f26070ULL, 0x000000403f397812ULL, 0x000fca00078ec0ffULL,
0x0000000126417824ULL, 0x000fcc00078e0239ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff427819ULL, 0x102fe2000001162cULL, 0x0000000456557824ULL, 0x000fe200078e00ffULL,
0x00000003ff497819ULL, 0x000fe4000001162cULL, 0x0000000842447810ULL, 0x040fe20007ffe0ffULL,
0x0000000142347824ULL, 0x140fe200078e0241ULL, 0x00000010424e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001842507810ULL, 0x000fe20007ffe0ffULL, 0x0000000144367824ULL, 0x100fe200078e0241ULL,
0x0000003447397210ULL, 0x000fe20007f3e0ffULL, 0x000000014e387824ULL, 0x000fe200078e0241ULL,
0x0000003f03347217ULL, 0x000fc40007800000ULL, 0x00000036473b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x0000003847367210ULL, 0x000fe20007f7e0ffULL,
0x0000000134347824ULL, 0x000fe200078e0a3fULL, 0x0000002842527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078438ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e00363c7a11ULL, 0x000fe200078638ffULL,
0x00000001523f7824ULL, 0x000fe200078e0241ULL, 0x00005e0039387a11ULL, 0x000fc400078238ffULL,
0x00005f00363d7a11ULL, 0x000fe200018f3c3dULL, 0x0000000150367824ULL, 0x100fe200078e0241ULL,
0x0000002042517810ULL, 0x040fe40007ffe0ffULL, 0x00005f003b3b7a11ULL, 0x000fe400010f3c3eULL,
0x00005f0039397a11ULL, 0x000fe200008f3c40ULL, 0x00000001513e7824ULL, 0x000fe200078e0241ULL,
0x0000003042537810ULL, 0x040fe40007ffe0ffULL, 0x000000344200720cULL, 0x000fc40003f46070ULL,
0x0000003842547810ULL, 0x000fe20007ffe0ffULL, 0x0000000153407824ULL, 0x100fe200078e0241ULL,
0x0000003647427210ULL, 0x040fe40007f3e0ffULL, 0x0000003f47437210ULL, 0x040fe20007fde0ffULL,
0x0000000154367824ULL, 0x000fe200078e0241ULL, 0x0000003e47417210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x00005e00423e7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x0000004047457210ULL, 0x000fc40007f9e0ffULL,
0x0000003647477210ULL, 0x000fe20007f7e0ffULL, 0x0000000202367824ULL, 0x000fe200078e0235ULL,
0x00005f00423f7a11ULL, 0x000fe200008f3c3fULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0x000000344400720cULL, 0x040fe20003f26070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00000003494f7812ULL, 0x100fe200078e482cULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x0000100036367811ULL, 0x000fe200078e60ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x0ffffffc4f4b7812ULL, 0x000fc400078ef82cULL, 0xfffffffc55497812ULL, 0x000fe400078ee22cULL,
0xfffffffc444d7812ULL, 0x000fe200078ee24fULL, 0x000000104b4b7824ULL, 0x000fe200078e0236ULL,
0x00005e0041407a11ULL, 0x000fe200078a38ffULL, 0x0000001049387825ULL, 0x000fe200078e0038ULL,
0x00005e0045447a11ULL, 0x000fe400078638ffULL, 0x00005f0041417a11ULL, 0x000fe200028f3c42ULL,
0x000000104d4d7824ULL, 0x000fe200078e0236ULL, 0x00005e0043427a11ULL, 0x000fe200078a38ffULL,
0x00000010493a7825ULL, 0x000fe200078e003aULL, 0x00005e0047467a11ULL, 0x000fe200078838ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000384b7faeULL, 0x0003e2000d101c46ULL,
0x00005f0043437a11ULL, 0x000fc400028f3c4cULL, 0x00005f0045457a11ULL, 0x000fe200018f3c4aULL,
0x000000003a4d7faeULL, 0x0005e2000c901c46ULL, 0x00005f0047477a11ULL, 0x000fe400020f3c48ULL,
0x000000344e00720cULL, 0x0c0fe20003f26070ULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x000000345000720cULL, 0x0c0fe20003f46070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x000000345100720cULL, 0x080fe20003f66070ULL, 0x0000000453387824ULL, 0x042fe200078e00ffULL,
0x000000345200720cULL, 0x0c0fe20003f86070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000345300720cULL, 0x080fe20003fa6070ULL, 0x00000010493a7825ULL, 0x004fe200078e003eULL,
0x000000345400720cULL, 0x000fc40003fc6070ULL, 0xfffffffc4e4b7812ULL, 0x100fe200078ee24fULL,
0x0000000451347824ULL, 0x000fe200078e00ffULL, 0xfffffffc504d7812ULL, 0x100fe200078ee24fULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc52517812ULL, 0x100fe200078ee24fULL,
0x000000104b4b7824ULL, 0x100fe200078e0236ULL, 0xfffffffc34397812ULL, 0x100fe200078ee24fULL,
0x000000104d4d7824ULL, 0x100fe200078e0236ULL, 0xfffffffc38537812ULL, 0x100fe200078ee24fULL,
0x0000001051517824ULL, 0x100fe200078e0236ULL, 0xfffffffc54557812ULL, 0x000fe200078ee24fULL,
0x00000010394f7824ULL, 0x000fc400078e0236ULL, 0x0000001049387825ULL, 0x000fc800078e003cULL,
0x00000010493c7825ULL, 0x040fe200078e0040ULL, 0x00000000384b7faeULL, 0x0003e6000c901c46ULL,
0x00000010493e7825ULL, 0x000fe200078e0042ULL, 0x000000003a4d7faeULL, 0x0003e6000d101c46ULL,
0x0000001053537824ULL, 0x000fe200078e0236ULL, 0x000000003c4f7faeULL, 0x0003e2000d901c46ULL,
0x0000001049407825ULL, 0x000fc600078e0044ULL, 0x000000003e517faeULL, 0x0003e2000e101c46ULL,
0x0000001055557824ULL, 0x000fe400078e0236ULL, 0x0000001049427825ULL, 0x000fe200078e0046ULL,
0x0000000040537faeULL, 0x0003e8000e901c46ULL, 0x0000000042557faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x000000082c3c7811ULL, 0x002fe200078ff0ffULL,
0x0000000456577824ULL, 0x000fe200078e00ffULL, 0x000000412c347211ULL, 0x000fc400078ff0ffULL,
0x00000003ff3d7819ULL, 0x000fe2000001162cULL, 0x000000013c367824ULL, 0x040fe200078e0241ULL,
0x0000003447347210ULL, 0x040fe20007f3e0ffULL, 0x000000043c487824ULL, 0x000fe200078e00ffULL,
0x000000182c3e7811ULL, 0x000fe400078ff0ffULL, 0x0000003647367210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0034387a11ULL, 0x000fe200078238ffULL,
0x000000043e4c7824ULL, 0x000fe200078e00ffULL, 0x000000202c407811ULL, 0x000fe200078ff0ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x00005e00363a7a11ULL, 0x000fc400078438ffULL,
0x00005f0034397a11ULL, 0x000fe200008f3c39ULL, 0x0000000202347824ULL, 0x000fe200078e0235ULL,
0x00005f00363b7a11ULL, 0x000fe200010f3c3bULL, 0x00000001403c7824ULL, 0x100fe200078e0241ULL,
0x000000102c367811ULL, 0x000fe200078ff0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000382c467811ULL, 0x000fe400078ff0ffULL, 0x000000033d437812ULL, 0x100fe200078e482cULL,
0x00000004364a7824ULL, 0x000fe200078e00ffULL, 0x0000100034557811ULL, 0x000fe200078e60ffULL,
0x0000000136347824ULL, 0x100fe200078e0241ULL, 0x000000282c427811ULL, 0x000fe200078ff0ffULL,
0x000000013e367824ULL, 0x100fe200078e0241ULL, 0x000000302c447811ULL, 0x000fe200078ff0ffULL,
0x00000001463f7824ULL, 0x040fe200078e0241ULL, 0xfffffffc57577812ULL, 0x000fe200078ee22cULL,
0x0000000446527824ULL, 0x000fe200078e00ffULL, 0xfffffffc48467812ULL, 0x000fe200078ee243ULL,
0x00000001423d7824ULL, 0x000fe200078e0241ULL, 0xfffffffc4a487812ULL, 0x100fe200078ee243ULL,
0x00000004424e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c4a7812ULL, 0x000fe200078ee243ULL,
0x00000001443e7824ULL, 0x000fe200078e0241ULL, 0xfffffffc404c7812ULL, 0x000fe200078ee243ULL,
0x0000000444507824ULL, 0x000fe200078e00ffULL, 0x0000003447427210ULL, 0x040fe20007f7e0ffULL,
0x000000104a4d7824ULL, 0x100fe200078e0255ULL, 0x0000003647407210ULL, 0x040fe20007f5e0ffULL,
0x00000010484b7824ULL, 0x000fe200078e0255ULL, 0x0000003f47347210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0xfffffffc4e4e7812ULL, 0x100fe200078ee243ULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0xfffffffc50507812ULL, 0x000fe200078ee243ULL,
0x0000001046497824ULL, 0x000fe200078e0255ULL, 0xfffffffc52527812ULL, 0x000fe200078ee243ULL,
0x0000001057387825ULL, 0x000fe200078e0038ULL, 0x0ffffffc43447812ULL, 0x000fc400078ef82cULL,
0x0000003c47417210ULL, 0x000fe20007f3e0ffULL, 0x00000010573a7825ULL, 0x000fe200078e003aULL,
0x0000003e47367210ULL, 0x040fe40007f9e0ffULL, 0x0000003d47437210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005e00403e7a11ULL, 0x000fe200078438ffULL,
0x0000001044597824ULL, 0x000fe200078e0255ULL, 0x00005e00423c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005f00403f7a11ULL, 0x000fe200010f3c3fULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00005f00423d7a11ULL, 0x000fe200030f3c45ULL,
0x000000ffff457224ULL, 0x000fe200020e06ffULL, 0x00005e0041407a11ULL, 0x000fe200078238ffULL,
0x00000010573e7825ULL, 0x000fe200078e003eULL, 0x00005e0043427a11ULL, 0x000fe200078438ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038597faeULL, 0x0003e2000b901c46ULL,
0x00005e0036447a11ULL, 0x000fe200078638ffULL, 0x00000010573c7825ULL, 0x000fe200078e003cULL,
0x00005e0034467a11ULL, 0x000fe200078838ffULL, 0x000000003a497faeULL, 0x0003e2000b901c46ULL,
0x00005f0041417a11ULL, 0x000fe200008f3c4aULL, 0x000000104c4f7824ULL, 0x100fe200078e0255ULL,
0x00005f0043437a11ULL, 0x000fe200010f3c48ULL, 0x000000104e517824ULL, 0x000fe200078e0255ULL,
0x00005f0036457a11ULL, 0x000fe200018f3c45ULL, 0x0000001057407825ULL, 0x040fe200078e0040ULL,
0x00005f0034477a11ULL, 0x000fe200020f3c47ULL, 0x000000003c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000001057427825ULL, 0x000fc400078e0042ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001050537824ULL, 0x000fe400078e0255ULL, 0x0000001057447825ULL, 0x040fe200078e0044ULL,
0x00000000404f7faeULL, 0x0003e6000b901c46ULL, 0x0000001052557824ULL, 0x000fe200078e0255ULL,
0x0000000042517faeULL, 0x0003e2000b901c46ULL, 0x0000001057467825ULL, 0x000fc600078e0046ULL,
0x0000000044537faeULL, 0x0003e8000b901c46ULL, 0x0000000046557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff257624ULL, 0x000fc800078e00ffULL, 0x0000000225247824ULL, 0x000fe400078e0224ULL,
0xffffffffff257424ULL, 0x000fc600078e00ffULL, 0x000000312400720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000229387824ULL, 0x002fe400078e0224ULL,
0x00000004ff397424ULL, 0x000fc800078e00ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x0000000638257981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000202c457810ULL, 0x002fe20007ffe0ffULL,
0x0000000202447824ULL, 0x000fe200078e0237ULL, 0xfffffff82c397812ULL, 0x040fe200078ec0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ec0ffULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x0000000739347812ULL, 0x100fe400078ef82cULL,
0x0000000745457812ULL, 0x000fe400078ef82cULL, 0x000000072c377812ULL, 0x000fc400078ec0ffULL,
0x00000001ff477819ULL, 0x000fe40000011634ULL, 0x00000001ff497819ULL, 0x000fe40000011645ULL,
0x0000100044447811ULL, 0x000fe400078e60ffULL, 0x0000000837377812ULL, 0x000fe400078ef82cULL,
0x0000000347477812ULL, 0x000fe400078ec0ffULL, 0x0000000349497812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003647397212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000036493c7212ULL, 0x000fc400078e3cffULL,
0x00000001364e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000434397824ULL, 0x000fe200078e0239ULL,
0x0000000236367810ULL, 0x000fe20007ffe0ffULL, 0x00000004453d7824ULL, 0x000fe400078e023cULL,
0x0000001039397824ULL, 0x100fe200078e0244ULL, 0x000000043600780cULL, 0x000fe20003f25270ULL,
0x000000103d3d7824ULL, 0x000fc800078e0244ULL, 0x000000003938783bULL, 0x000e680000000200ULL,
0x000000003d3c783bULL, 0x000ea20000000200ULL, 0x00000018ff427819ULL, 0x002fe2000001143aULL,
0x0001000039437824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011439ULL,
0x00000042005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4c7819ULL, 0x000fc4000001143bULL,
0x00000018ff407819ULL, 0x000fe40000011438ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff4b7819ULL, 0x004fe2000001143cULL, 0x0000004100587306ULL, 0x0005e20000200c00ULL,
0x0000888039427816ULL, 0x042fe200000000ffULL, 0x0000010039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001143dULL, 0x00000018ff487819ULL, 0x000fc4000001143eULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000004000547306ULL, 0x0003e20000200c00ULL,
0x0001000038417824ULL, 0x004fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc8000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003900597306ULL, 0x0005e20000200c00ULL,
0x0000888038407816ULL, 0x042fe200000000ffULL, 0x0000010038387824ULL, 0x000fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000004100537306ULL, 0x0003e20000200c00ULL,
0x000100003b397824ULL, 0x004fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000004000527306ULL, 0x0004e20000200c00ULL, 0x000088803b417816ULL, 0x042fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003800557306ULL, 0x0003220000200c00ULL, 0x000088803a407816ULL, 0x004fce00000000ffULL,
0x0000003b00617306ULL, 0x0005e20000200c00ULL, 0x000100003a387824ULL, 0x002fe200078e00ffULL,
0x0000541052527816ULL, 0x008fe20000000053ULL, 0x000001003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004200567306ULL, 0x000fe20000200c00ULL,
0x0000004e473b7212ULL, 0x084fe400078e3cffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000004e494e7212ULL, 0x000fe200078e3cffULL, 0x00000004343b7824ULL, 0x000fe200078e023bULL,
0x0000541055537816ULL, 0x010fe20000000054ULL, 0x0000004300577306ULL, 0x000e640000200c00ULL,
0x000000103b3b7824ULL, 0x000fc400078e0244ULL, 0x00000004454d7824ULL, 0x000fe400078e024eULL,
0x000100003f4e7824ULL, 0x000fe400078e00ffULL, 0x00000040005a7306ULL, 0x000fe60000200c00ULL,
0x00000018ff4e7819ULL, 0x000fca000001144eULL, 0x00000041005e7306ULL, 0x0005e20000200c00ULL,
0x0000541056567816ULL, 0x002fe40000000057ULL, 0x0000541059577816ULL, 0x000fca0000000058ULL,
0x00000038005b7306ULL, 0x0002e20000200c00ULL, 0x000000003b40783bULL, 0x004eae0000000200ULL,
0x0000003a005d7306ULL, 0x0008e20000200c00ULL, 0x000088803c387816ULL, 0x002fce00000000ffULL,
0x00000039005f7306ULL, 0x0002620000200c00ULL, 0x000100003c3a7824ULL, 0x010fe200078e00ffULL,
0x000054105a5a7816ULL, 0x008fe2000000005bULL, 0x000001003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003800607306ULL, 0x0007e20000200c00ULL,
0x000088803d397816ULL, 0x002fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000054105d5b7816ULL, 0x000fc6000000005cULL, 0x0000003a00637306ULL, 0x0003220000200c00ULL,
0x000100003d387824ULL, 0x048fe200078e00ffULL, 0x000054105e5e7816ULL, 0x000fe2000000005fULL,
0x000001003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900647306ULL, 0x0007e20000200c00ULL, 0x000000104d3a7824ULL, 0x002fe200078e0244ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0001000042767824ULL, 0x004fe200078e00ffULL,
0x0000888041707816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011443ULL,
0x0000003800657306ULL, 0x0002a20000200c00ULL, 0x000100003e397824ULL, 0x008fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fc40000011476ULL, 0x0000541060607816ULL, 0x010fe40000000063ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x0000003c00627306ULL, 0x0007e20000200c00ULL,
0x000000003a38783bULL, 0x002e6e0000000200ULL, 0x0000003d00677306ULL, 0x0009e20000200c00ULL,
0x000088803e3c7816ULL, 0x048fe200000000ffULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000541064647816ULL, 0x004fc80000000065ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003c00667306ULL, 0x0005e20000200c00ULL, 0x000088803f3d7816ULL, 0x050fe200000000ffULL,
0x000001003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003d00687306ULL, 0x0007e20000200c00ULL, 0x00000018ff3c7819ULL, 0x004fce0000011440ULL,
0x0000003c006e7306ULL, 0x0005e20000200c00ULL, 0x00008880403d7816ULL, 0x008fce00000000ffULL,
0x0000003e006b7306ULL, 0x0007e20000200c00ULL, 0x00010000403c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff507819ULL, 0x002fe20000011438ULL, 0x0000010040407824ULL, 0x000fe200078e00ffULL,
0x0000888039547816ULL, 0x000fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011439ULL,
0x00000018ff6c7819ULL, 0x000fe20000011440ULL, 0x0000004d00697306ULL, 0x0002a20000200c00ULL,
0x00000018ff3e7819ULL, 0x008fc40000011441ULL, 0x0000002b2c407211ULL, 0x000fe400078fe0ffULL,
0x000000042b2b7810ULL, 0x000fc60007ffe0ffULL, 0x0000003e00747306ULL, 0x0007e20000200c00ULL,
0x00000018ff4d7819ULL, 0x002fce0000011442ULL, 0x0000003f006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3e7819ULL, 0x008fe4000001143cULL, 0x00000007403c7812ULL, 0x040fe400078e7837ULL,
0x0000000240407810ULL, 0x000fe40007ffe0ffULL, 0x0000541066667816ULL, 0x004fe20000000069ULL,
0x00000010373c7824ULL, 0x000fe200078e023cULL, 0x0000003d006a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3f7819ULL, 0x002fc4000001143bULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000740407812ULL, 0x000fc800078e7837ULL, 0x0000004d00787306ULL, 0x000fe20000200c00ULL,
0x00010000413d7824ULL, 0x044fe400078e00ffULL, 0x0000010041417824ULL, 0x000fe400078e00ffULL,
0x0000001037407824ULL, 0x000fe200078e0240ULL, 0x00000018ff727819ULL, 0x000fe4000001143dULL,
0x0000003f004d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000001040407824ULL, 0x000fcc00078e00ffULL, 0x0000003e00717306ULL, 0x0002b00000200c00ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x000000003c3c783bULL, 0x002e6e0000000200ULL,
0x0000004b004b7306ULL, 0x000f220000200c00ULL, 0x000054106a6a7816ULL, 0x004fce0000000071ULL,
0x0000006c00737306ULL, 0x0005e20000200c00ULL, 0x00005410615f7816ULL, 0x008fe2000000004cULL,
0x000000ffff4c7224ULL, 0x000fe400078e0054ULL, 0x0001000039547824ULL, 0x000fc800078e00ffULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x00008880426c7816ULL, 0x044fe200000000ffULL,
0x0000010042427824ULL, 0x000fe200078e00ffULL, 0x0000541062617816ULL, 0x010fe4000000004bULL,
0x000088803a4b7816ULL, 0x000fe400000000ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x0000007200757306ULL, 0x0009e20000200c00ULL, 0x000000523c04723cULL, 0x002fe20000001804ULL,
0x0000541067657816ULL, 0x008fcc000000004aULL, 0x0000004100777306ULL, 0x0002e20000200c00ULL,
0x0000888043727816ULL, 0x010fe200000000ffULL, 0x0001000038527824ULL, 0x000fe200078e00ffULL,
0x000054106b677816ULL, 0x004fe20000000048ULL, 0x000000ffff487224ULL, 0x000fe200078e004bULL,
0x000000563c08723cULL, 0x040fe20000001808ULL, 0x000100003a4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x0001000043417824ULL, 0x002fe200078e00ffULL, 0x00005410736b7816ULL, 0x000fe2000000006eULL,
0x0000010043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000005a3c0c723cULL, 0x000fe2000000180cULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x0000004e006d7306ULL, 0x0003220000200c00ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000541077717816ULL, 0x008fe40000000074ULL, 0x0000005e3c10723cULL, 0x000fe60000001810ULL,
0x00000042007b7306ULL, 0x0007220000200c00ULL, 0x00000018ff4e7819ULL, 0x002fe2000001143aULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x000054106f697816ULL, 0x004fc40000000046ULL,
0x000000603c14723cULL, 0x040fe40000001814ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000007600797306ULL, 0x000fe20000200c00ULL, 0x0000888038427816ULL, 0x048fe200000000ffULL,
0x0000010038387824ULL, 0x000fe200078e00ffULL, 0x0000541068687816ULL, 0x010fe4000000006dULL,
0x000000643c18723cULL, 0x000fe40000001818ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x00000041007d7306ULL, 0x000fe20000200c00ULL, 0x000054107b6d7816ULL, 0x000fc80000000078ULL,
0x000000663c1c723cULL, 0x040fe6000000181cULL, 0x0000004300767306ULL, 0x000fea0000200c00ULL,
0x000000683c20723cULL, 0x000fe60000001820ULL, 0x0000004200537306ULL, 0x0003e80000200c00ULL,
0x000100003b3c7824ULL, 0x000fc800078e00ffULL, 0x0000003800557306ULL, 0x0005e20000200c00ULL,
0x000000004040783bULL, 0x002e620000000200ULL, 0x00000018ff3c7819ULL, 0x000fcc000001143cULL,
0x0000003a003d7306ULL, 0x0007e20000200c00ULL, 0x0000010039387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000001003b3a7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000005400397306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x00000038004a7306ULL, 0x0005e20000200c00ULL, 0x0000006a4004723cULL, 0x002fee0000001804ULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000088803b387816ULL, 0x004fce00000000ffULL,
0x0000005100517306ULL, 0x000eb00000200c00ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x0000541053527816ULL, 0x002fce0000000052ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541076737816ULL, 0x004fce0000000051ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541055537816ULL, 0x008fce0000000050ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x000000524014723cULL, 0x000fee0000001814ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x0000541070707816ULL, 0x002fce0000000075ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054106c6c7816ULL, 0x004fe20000000079ULL, 0x000000704008723cULL, 0x040fec0000001808ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x008fe2000000007dULL,
0x0000006c400c723cULL, 0x040fec000000180cULL, 0x00000038003e7306ULL, 0x0003e40000200c00ULL,
0x000000724010723cULL, 0x000fec0000001810ULL, 0x0000003c003b7306ULL, 0x000ea20000200c00ULL,
0x000054104c387816ULL, 0x002fc40000000039ULL, 0x000054104a397816ULL, 0x000fca000000004fULL,
0x0000003a003a7306ULL, 0x000e640000200c00ULL, 0x000000384018723cULL, 0x000fe20000001818ULL,
0x000054103e3e7816ULL, 0x004fcc000000003bULL, 0x0000541048387816ULL, 0x000fe4000000004bULL,
0x000054103d397816ULL, 0x000fe4000000004eULL, 0x000054103a3f7816ULL, 0x002fca000000004dULL,
0x00000038401c723cULL, 0x040ff0000000181cULL, 0x0000003e4020723cULL, 0x000fe20000001820ULL,
0xfffff0e000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff377224ULL, 0x000fe200078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002e367f8cULL, 0x000fe2000c80043fULL,
0x000000162d3e7220ULL, 0x040fe20000410000ULL, 0x000000062d347220ULL, 0x040fe20000410000ULL,
0x0000000a2d387220ULL, 0x040fe20000410000ULL, 0x000004002e2b7984ULL, 0x000e620000000800ULL,
0x0000000b2d397220ULL, 0x040fe20000410000ULL, 0x0000000e2d3a7220ULL, 0x040fe20000410000ULL,
0x0000001c2d167220ULL, 0x040fe20000410000ULL, 0x000000042d047220ULL, 0x040fe20000410000ULL,
0x000000052d057220ULL, 0x040fe20000410000ULL, 0x000000072d077220ULL, 0x040fe20000410000ULL,
0x000000082d087220ULL, 0x040fe20000410000ULL, 0x000000092d097220ULL, 0x040fe20000410000ULL,
0x0000000c2d007220ULL, 0x040fe20000410000ULL, 0x0000000d2d067220ULL, 0x040fe20000410000ULL,
0x0000000f2d3b7220ULL, 0x040fe20000410000ULL, 0x000000122d3c7220ULL, 0x040fe20000410000ULL,
0x000000132d3d7220ULL, 0x040fe20000410000ULL, 0x000000172d3f7220ULL, 0x040fe20000410000ULL,
0x0000001a2d407220ULL, 0x040fe20000410000ULL, 0x0000001b2d417220ULL, 0x040fe20000410000ULL,
0x0000001e2d1c7220ULL, 0x040fe20000410000ULL, 0x0000001f2d427220ULL, 0x040fe20000410000ULL,
0x000000142d127220ULL, 0x040fe20000410000ULL, 0x000000152d137220ULL, 0x040fe20000410000ULL,
0x000000182d147220ULL, 0x040fe20000410000ULL, 0x000000192d157220ULL, 0x040fe20000410000ULL,
0x0000001d2d177220ULL, 0x040fe20000410000ULL, 0x000000202d187220ULL, 0x040fe20000410000ULL,
0x000000212d197220ULL, 0x040fe20000410000ULL, 0x000000222d437220ULL, 0x040fe20000410000ULL,
0x000000232d447220ULL, 0x040fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0034ULL,
0x000000102d107220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0038ULL,
0x000000112d117220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0039ULL,
0x000000ffff1f7224ULL, 0x000fe400078e003aULL, 0x000000ffff0b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0005ULL, 0x800000002bff7812ULL, 0x002fe20007804837ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff207224ULL, 0x000fe400078e003bULL,
0x000000ffff217224ULL, 0x000fe400078e003cULL, 0x000000ffff227224ULL, 0x000fe400078e003dULL,
0x000000ffff237224ULL, 0x000fc400078e003eULL, 0x000000ffff2b7224ULL, 0x000fe400078e003fULL,
0x000000ffff347224ULL, 0x000fe400078e0040ULL, 0x000000ffff387224ULL, 0x000fe400078e0041ULL,
0x000000ffff397224ULL, 0x000fe400078e001cULL, 0x000000ffff3a7224ULL, 0x000fe200078e0042ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fc400078e0043ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0044ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004002e057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000042c1c7824ULL, 0x000fe200078e00ffULL, 0x0000002f3000720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000022c087824ULL, 0x000fe400078e00ffULL, 0x00000001032a7824ULL, 0x000fc600078e0a2aULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109377812ULL, 0x040fe400078efcffULL,
0x00000008093d7812ULL, 0x000fe400078efcffULL, 0x0000002a3700720cULL, 0x080fe40003f26070ULL,
0x0000001009377812ULL, 0x000fe400078efcffULL, 0x0000002a3d00720cULL, 0x080fe40003f06070ULL,
0x0000002a3700720cULL, 0x000fc40003fc6070ULL, 0x00000011093d7812ULL, 0x040fe400078efcffULL,
0x0000001809377812ULL, 0x040fe400078efcffULL, 0x0000002a0900720cULL, 0x080fe40003f46070ULL,
0x0000002a3d00720cULL, 0x080fe40003fa6070ULL, 0x0000002a3700720cULL, 0x000fe40003f66070ULL,
0x00000009093f7812ULL, 0x000fc400078efcffULL, 0x00000019093d7812ULL, 0x040fe400078efcffULL,
0x0000002009377812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000002a3f00720cULL, 0x080fe40003f86070ULL,
0x0000002a3d00720cULL, 0x080fe40003f46070ULL, 0x0000002a3700720cULL, 0x000fe40003f26070ULL,
0x00000021093d7812ULL, 0x040fe400078efcffULL, 0x0000002809377812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002a3d00720cULL, 0x080fe40003f06070ULL, 0x0000002a3700720cULL, 0x000fe40003f86070ULL,
0x00000029093d7812ULL, 0x000fc400078efcffULL, 0x0000003009377812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002a3d00720cULL, 0x000fc40003fc6070ULL, 0x0000002a3700720cULL, 0x000fe40003fa6070ULL,
0x00000031093d7812ULL, 0x040fe400078efcffULL, 0x0000003809377812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002a3d00720cULL, 0x080fe40003f66070ULL,
0x0000002a3700720cULL, 0x000fc40003f46070ULL, 0x0000002a0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff38387808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff39397808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff3b3b7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304047209ULL, 0x000fe40007810000ULL,
0x0000001308057209ULL, 0x000fe40007810000ULL, 0x0000002b04097209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000003409097209ULL, 0x000fc40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000003809047209ULL, 0x000fe40007810000ULL,
0x0000001605087209ULL, 0x000fe40007810000ULL, 0x0000003904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003b04057209ULL, 0x000fe40007810000ULL,
0x0000001908367209ULL, 0x000fe40007810000ULL, 0x0000003c053d7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0036047f89ULL, 0x0004e400000e0000ULL,
0x00000004363e7209ULL, 0x008fe20007810000ULL, 0x000017e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000e6200000e0000ULL, 0x000000043d087209ULL, 0x008fc60007810000ULL,
0x0c201f003e047f89ULL, 0x000ee200000e0000ULL, 0x0000000506097209ULL, 0x010fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000f2200000e0000ULL, 0x0000002a072a7209ULL, 0x002fc60007810000ULL,
0x0c201f0009367f89ULL, 0x004e6800000e0000ULL, 0x0c201f002a377f89ULL, 0x0004a200000e0000ULL,
0x000000043e047209ULL, 0x008fe40007810000ULL, 0x0000000508057209ULL, 0x010fe40007810000ULL,
0x0000003609067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3c003c00ff3e7424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff3f7424ULL, 0x002fe200078e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3c197823ULL, 0x000fc80000010819ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000000ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003e0840723cULL, 0x000fee00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003e0c40723cULL, 0x000fee0000001840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002b001a7308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc2c147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000003400347308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x00000038001b7308ULL, 0x000ea20000000800ULL,
0x000000231a11723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000341b13723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000003e1040723cULL, 0x000fec0000001840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x0000002a37077209ULL, 0x000fca0007810000ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000393a15723eULL, 0x002fe400000000ffULL,
0x0000003b1a17723eULL, 0x004fce00000000ffULL, 0x0000003e1440723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000131204008947ULL, 0x010fde000b800000ULL,
0x001c1fff40187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000133204008947ULL, 0x010fea000b800000ULL,
0x001c1fff42197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe4000001162cULL,
0x0000000c1c437812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x000000032cff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3c7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f2a7812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f347812ULL, 0x000fc400078ef61eULL,
0x000000041f367812ULL, 0x140fe400078ef61eULL, 0x000000051f387812ULL, 0x140fe400078ef61eULL,
0x000000061f3a7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000021d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233e7812ULL, 0x100fe400078ee21eULL, 0x000000011f407812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x000000102a207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x00000010362a7824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000103a367824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010403a7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010443d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001034227824ULL, 0x100fe400078e021dULL,
0x0000001038347824ULL, 0x100fe400078e021dULL, 0x00000001431f7824ULL, 0x000fe400078e021cULL,
0x000000103c387824ULL, 0x100fe400078e021dULL, 0x000000103e1c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010423c7824ULL, 0x000fc400078e021dULL,
0x00000010463e7824ULL, 0x100fe400078e021dULL, 0x00000010483f7824ULL, 0x100fe400078e021dULL,
0x000000104a407824ULL, 0x100fe400078e021dULL, 0x000000104c417824ULL, 0x000fe400078e021dULL,
0x00000001431d7824ULL, 0x040fe400078e021eULL, 0x0000000143217824ULL, 0x000fc400078e0220ULL,
0x0000000143237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x00000001432b7824ULL, 0x040fe400078e022aULL, 0x0000000143377824ULL, 0x040fe200078e0234ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000143397824ULL, 0x040fe400078e0236ULL,
0x00000001433b7824ULL, 0x040fe200078e0238ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001431c7824ULL, 0x000fc400078e021cULL, 0x00000001433a7824ULL, 0x040fe200078e023aULL,
0x000000102b007388ULL, 0x0007e20000000800ULL, 0x00000001433c7824ULL, 0x040fe400078e023cULL,
0x0000000143087824ULL, 0x042fe200078e023dULL, 0x0000001237007388ULL, 0x0007e20000000800ULL,
0x00000001433e7824ULL, 0x040fe400078e023eULL, 0x00000001431e7824ULL, 0x040fe200078e023fULL,
0x0000001439007388ULL, 0x0007e20000000800ULL, 0x0000000143407824ULL, 0x000fc400078e0240ULL,
0x0000000143207824ULL, 0x000fe200078e0241ULL, 0x000000163b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d3c007388ULL, 0x0007e80000000800ULL, 0x0000000f08007388ULL, 0x0007e80000000800ULL,
0x000000113e007388ULL, 0x0007e80000000800ULL, 0x000000131e007388ULL, 0x0007e80000000800ULL,
0x0000001540007388ULL, 0x0007e80000000800ULL, 0x0000001720007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000032ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080032ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100032ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030030307a10ULL, 0x000fe20007ffe0ffULL,
0x0000180032ff7f8cULL, 0x0003e6000c80043fULL, 0x000000333000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc5c000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x004fe40004000000ULL,
0x0001190000247802ULL, 0x000fe40000000f00ULL, 0x00000f2000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xffff00f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x0001195000247802ULL, 0x000fe40000000f00ULL,
0x00000ed000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0xffff013000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0000ULL,
0x000119c0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fc400078e00ffULL, 0x00000e2000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e004eULL, 0xffff018000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x000fe200078e0000ULL, 0x00011a30002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x00000db000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e004eULL,
0xffff014000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0025ULL,
0x00011aa0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x00000d4000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff5f7224ULL, 0x004fe200078e004eULL, 0xffff04a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0046ULL, 0x00011b10002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fc400078e00ffULL,
0x00000cd000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e004eULL,
0xffff046000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x010fe40004000000ULL,
0x00011b6000247802ULL, 0x000fc40000000f00ULL, 0x00000cc000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff1f2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x00011bb000247802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff1f6000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x008fe200078e00ffULL,
0x00011c10002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff717424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e004eULL,
0xffff1fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x00afe200078e0046ULL,
0x00011c80002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x00000b6000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e004eULL, 0xffff208000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x00011ce0002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x00000b0000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x004fe200078e004eULL, 0xffff234000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0046ULL, 0x00011d50002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x00000a9000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e004eULL,
0xffff22f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x010fe40004000000ULL,
0x00011da000247802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff3be000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x00011df000247802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff3c2000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x004fe200078e00ffULL,
0x00011e50002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff717424ULL, 0x000fc400078e00ffULL,
0x0000099000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e004eULL,
0xffff3c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x006fe200078e0046ULL,
0x00011ec0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000092000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e004eULL, 0xffff3d4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x00011f20002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x000008c000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff597224ULL, 0x004fe200078e004eULL, 0xffff3ff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0046ULL, 0x00011f90002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x0000085000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e004eULL,
0xffff3fa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x002fe40004000000ULL,
0x00011fe000247802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff576000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x0001203000247802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff57a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff707424ULL, 0x002fe200078e00ffULL,
0x00012090002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff717424ULL, 0x000fc400078e00ffULL,
0x0000075000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e004eULL,
0xffff581000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e0046ULL,
0x00012100002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x000006e000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e004eULL, 0xffff58c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff707424ULL, 0x000fe200078e00ffULL, 0x00012160002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff717424ULL, 0x000fe400078e00ffULL, 0x0000068000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff417224ULL, 0x004fe200078e004eULL, 0xffff5b8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e0046ULL, 0x000121d0002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff717424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e004eULL,
0xffff5b3000007947ULL, 0x000fea000383ffffULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0001222000087802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0037ULL, 0xffffe80000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x006fe200078e003dULL, 0x0001228000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x020fea0003c00000ULL,
0x000000373d407209ULL, 0x004fe20007810000ULL, 0x000000ffff367224ULL, 0x002fe200078e0006ULL,
0x000122d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000003706067209ULL, 0x004fe20007810000ULL,
0x000000ffff367224ULL, 0x002fe200078e0007ULL, 0x0001232000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x00000037072a7209ULL, 0x004fe20007810000ULL, 0x000000ffff367224ULL, 0x002fe200078e003eULL,
0x0001237000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000373e047209ULL, 0x004fe20007810000ULL,
0x000000ffff367224ULL, 0x002fe200078e0040ULL, 0x000123c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000003740057209ULL, 0x004fe20007810000ULL, 0x000000ffff367224ULL, 0x002fe200078e0006ULL,
0x0001241000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000003706067209ULL, 0x004fe20007810000ULL,
0x000000ffff367224ULL, 0x002fe200078e002aULL, 0x0001246000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x000fe200078e0040ULL,
0x000124d0002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff717224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e004eULL,
0xffffec8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e0042ULL,
0x00012550002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff717224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00ffULL,
0x000125b0002a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff707424ULL, 0x000fc400078e00ffULL,
0x000000ffff717224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e004eULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff717224ULL, 0x002fe200078e001dULL,
0x00012610002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e004eULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e004eULL,
0xffffebc000007947ULL, 0x000fea000383ffffULL, 0x018000003a007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003a00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fe4000780c0ffULL,
0x800000003a057812ULL, 0x000fd600078ec0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003a00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffed86006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000004200007348ULL, 0x000fe80003800000ULL,
0x0c00003736377389ULL, 0x0002a200000e003fULL, 0xfffed82008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000007100007348ULL, 0x000fe80003800000ULL,
0x0000006f6e4e7389ULL, 0x0002a200000e0070ULL, 0xfffed7e02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f05070ULL, 0x0000004400007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800040e0100ULL, 0x0000004425287212ULL, 0x000fe200078ec0ffULL,
0x00000000ff257424ULL, 0x000fc800078e00ffULL, 0xfffed78024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003a0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000980ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a10ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001290ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000012b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012c0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012e0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001370ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001378ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001388ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000012980ULL, 0xa200001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013f00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013f10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013f10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001370ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012b90ULL, 0x0000000000012b90ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014390ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 83056;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
