/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014590ULL, 0x0000000000014110ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000127e0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000012950ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000012990ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000129d0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000012b00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000127e000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0048b40400288080ULL, 0x0000000000000000ULL, 0x000000bcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9a08288080950828ULL, 0x2880809d08288080ULL, 0x80a0082880809e08ULL, 0x08288080a1082880ULL,
0x8080a608288080a4ULL, 0xa908288080a80828ULL, 0x288080aa08288080ULL, 0x80ac08288080ab08ULL,
0x08288080ae082880ULL, 0x8080b008288080afULL, 0xb508288080b40828ULL, 0x288080bb08288080ULL,
0x80d408288080bc08ULL, 0x08288080ec082880ULL, 0x80818508288080eeULL, 0x8016288080840828ULL,
0x0000000310288082ULL, 0x8084920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x000127e000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8e082880808b0828ULL, 0x2880809108288080ULL,
0x8093082880809208ULL, 0x082880809c082880ULL, 0x80809f082880809dULL, 0xa108288080a00828ULL,
0x288080a408288080ULL, 0x80a808288080a608ULL, 0x08288080a9082880ULL, 0x8080ab08288080aaULL,
0xb008288080ac0828ULL, 0x288080b408288080ULL, 0x80bc08288080b508ULL, 0x08288080d4082880ULL,
0x8080ee08288080ecULL, 0x8808288081850828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001295000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8b08288080880828ULL, 0x2880808e08288080ULL, 0x8092082880809108ULL,
0x0828808093082880ULL, 0x80809d082880809cULL, 0xa0082880809f0828ULL, 0x288080a108288080ULL,
0x80a608288080a408ULL, 0x08288080a9082880ULL, 0x8080ab08288080aaULL, 0xb008288080ac0828ULL,
0x288080b408288080ULL, 0x80bc08288080b508ULL, 0x08288080d4082880ULL, 0x8080ee08288080ecULL,
0xa808288081850828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a8920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000025800000000ULL, 0x0001299000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8b08288080880828ULL, 0x2880808e08288080ULL, 0x8092082880809108ULL, 0x0828808093082880ULL,
0x80809d082880809cULL, 0xa0082880809f0828ULL, 0x288080a108288080ULL, 0x80a608288080a408ULL,
0x08288080a8082880ULL, 0x8080ab08288080aaULL, 0xb008288080ac0828ULL, 0x288080b408288080ULL,
0x80bc08288080b508ULL, 0x08288080d4082880ULL, 0x8080ee08288080ecULL, 0xa908288081850828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a9920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000035000000000ULL, 0x000129d000000000ULL, 0x0000013000000000ULL,
0x0000140400000000ULL, 0x80a4288080a90900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000a1ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x0001102000010b90ULL, 0x000111a000011030ULL,
0x000111c0000111b0ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000020ffffffffULL, 0x0500002005000020ULL, 0xffffffff05000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x00000110000000f0ULL, 0x00001a9000001a00ULL,
0x00001b8000001b50ULL, 0x00001f8000001f50ULL, 0x0000204000001fe0ULL, 0x00003b2000003a90ULL,
0x00003d1000003bf0ULL, 0x0000405000004030ULL, 0x00004110000040b0ULL, 0x00005a2000005990ULL,
0x00005c1000005af0ULL, 0x00005f4000005f20ULL, 0x0000600000005fa0ULL, 0x000077e000007750ULL,
0x000079d0000078b0ULL, 0x00007d1000007cf0ULL, 0x00007dd000007d70ULL, 0x000090c0000090b0ULL,
0x0000b9200000b690ULL, 0x0000bf300000bf00ULL, 0x00010a9000010a60ULL, 0x00010ab000010aa0ULL,
0x00010af000010ad0ULL, 0x00010b2000010b10ULL, 0x000111f000011190ULL, 0x0001121000011200ULL,
0x0001199000011930ULL, 0x00011a7000011a00ULL, 0x00011b5000011ae0ULL, 0x00011c1000011bb0ULL,
0x00011ce000011c70ULL, 0x00011db000011d40ULL, 0x00011e7000011e10ULL, 0x00011f4000011ed0ULL,
0x0001201000011fa0ULL, 0x000120d000012070ULL, 0x000121a000012130ULL, 0x0001227000012200ULL,
0x00012360000122e0ULL, 0x00012440000123d0ULL, 0x00012520000124b0ULL, 0x0001260000012590ULL,
0x000126f000012670ULL, 0x000127b000012750ULL, 0x0000022004c03904ULL, 0x0000f600000000ffULL,
0x000002c0003f0100ULL, 0x0000f6080000000dULL, 0x00000300003f0120ULL, 0x0000f6880000000dULL,
0x00000380003f0120ULL, 0x0000f6a80000000dULL, 0x000003b0003f0120ULL, 0x0000f6c80000000dULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000630003f0107ULL, 0x0000f68c00000042ULL,
0x000006e0003f0102ULL, 0x0000f68800000042ULL, 0x00000cb0003f0101ULL, 0x00000000000000ffULL,
0x00000d4000040107ULL, 0x00000000000000ffULL, 0x00000da000040101ULL, 0x000000200000003aULL,
0x00000ef0003f0101ULL, 0x0000000400000064ULL, 0x00000f60003f0105ULL, 0x000000240000003aULL,
0x00000fe0003f0105ULL, 0x000000240000003aULL, 0x000016e0003f0105ULL, 0x000000000000002dULL,
0x000017d0003f0107ULL, 0x000000000000002dULL, 0x000017e0003f0101ULL, 0x0000000400000026ULL,
0x00001850003f0105ULL, 0x0000f60800000052ULL, 0x00001870003f0101ULL, 0x0000f60c00000052ULL,
0x00001910003f0105ULL, 0x0000f60c00000027ULL, 0x00001e40003f0105ULL, 0x0000000400000026ULL,
0x00001ec0003f0105ULL, 0x0000000400000026ULL, 0x00003130003f0105ULL, 0x000000200000003aULL,
0x000031b0003f0101ULL, 0x0000f6880000005cULL, 0x00003200003f0101ULL, 0x0000000400000064ULL,
0x00003250003f0105ULL, 0x000000240000003aULL, 0x000032d0003f0105ULL, 0x000000240000003aULL,
0x00003800003f0105ULL, 0x000000000000005eULL, 0x00003880003f0107ULL, 0x000000000000005eULL,
0x00003890003f0101ULL, 0x000000040000005fULL, 0x00003900003f0105ULL, 0x0000f62800000065ULL,
0x00003920003f0101ULL, 0x0000f62c00000065ULL, 0x000039e0003f0105ULL, 0x0000f62c00000025ULL,
0x00003f00003f0105ULL, 0x0000f6ac00000026ULL, 0x00003f80003f0105ULL, 0x0000f6ac00000026ULL,
0x00005040003f0105ULL, 0x000000200000003aULL, 0x000050b0003f0101ULL, 0x0000f6900000005cULL,
0x000050f0003f0101ULL, 0x0000000400000064ULL, 0x00005140003f0105ULL, 0x000000240000003aULL,
0x000051c0003f0105ULL, 0x000000240000003aULL, 0x000056f0003f0105ULL, 0x000000000000002cULL,
0x0000577000050107ULL, 0x000000000000002cULL, 0x0000578000050101ULL, 0x0000000400000053ULL,
0x000057f000050105ULL, 0x0000f64800000052ULL, 0x00005810003f0101ULL, 0x0000f64c00000052ULL,
0x000058e0003f0105ULL, 0x0000f64c00000028ULL, 0x00005df0003f0105ULL, 0x0000f6ac00000025ULL,
0x00005e70003f0105ULL, 0x0000f6ac00000025ULL, 0x00006f10003f0105ULL, 0x000000200000003aULL,
0x00006f80003f0101ULL, 0x0000f6980000005cULL, 0x00006fe0003f0101ULL, 0x0000000400000064ULL,
0x00007030003f0105ULL, 0x000000240000003aULL, 0x000070b0003f0105ULL, 0x000000240000003aULL,
0x000074f0003f0105ULL, 0x000000000000005eULL, 0x00007570003f0107ULL, 0x0000000000000068ULL,
0x00007580003f0101ULL, 0x000000040000005fULL, 0x000075f0003f0105ULL, 0x0000f66800000065ULL,
0x00007610003f0101ULL, 0x0000f66c00000065ULL, 0x000076a0003f0105ULL, 0x0000f66c00000065ULL,
0x00007bc0003f0105ULL, 0x0000f6ac00000026ULL, 0x00007c40003f0105ULL, 0x0000f6ac00000026ULL,
0x00008c60003f0105ULL, 0x000000200000003aULL, 0x00008cc0003f0101ULL, 0x0000f6a00000005cULL,
0x0000cc80003f0101ULL, 0x0000f600000000ffULL, 0x0000da90003f0101ULL, 0x0000f604000000ffULL,
0x0000db30003f0105ULL, 0x0000f604000000ffULL, 0x0000dd40003f0105ULL, 0x0000f600000000ffULL,
0x0000dd50003f0101ULL, 0x0000f604000000ffULL, 0x0000dde0003f0105ULL, 0x0000f604000000ffULL,
0x0000ff80003f0105ULL, 0x000000000000002bULL, 0x0000ffb0003f0101ULL, 0x000000040000002bULL,
0x00010380003f0105ULL, 0x000000040000002bULL, 0x00011780003f0105ULL, 0x000000000000002cULL,
0x000117e0003f0101ULL, 0x000000080000002cULL, 0x00011840003f0101ULL, 0x000000100000002cULL,
0x000118b0003f0101ULL, 0x000000180000002cULL, 0x00053803003f0101ULL, 0x0000c93000141c04ULL,
0x0000de400000cb80ULL, 0x000118f00000def0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000434ULL, 0x0000001200000002ULL, 0x000000000000033cULL, 0x0000001200000002ULL,
0x0000000000000244ULL, 0x0000001200000002ULL, 0x000000000000014cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000040aULL, 0x0000001200000002ULL,
0x0000000000000312ULL, 0x0000001200000002ULL, 0x000000000000021aULL, 0x0000001200000002ULL,
0x0000000000000125ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff277624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee200000e0000ULL, 0x00000100ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea80000002200ULL, 0x0000000000487919ULL, 0x000f220000000000ULL,
0x0000001200127309ULL, 0x000f660000000000ULL, 0x00000000003e7919ULL, 0x000ee80000002600ULL,
0x0000000000247919ULL, 0x000f620000002700ULL, 0x00000005ff477819ULL, 0x002fc6000001160dULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x00001fff47477589ULL, 0x000fe200000e0000ULL,
0x000000010c007824ULL, 0x004fc600078e0203ULL, 0x00001fff0c0c7589ULL, 0x000ea200000e0000ULL,
0x00000080000d7824ULL, 0x000fe200078e020dULL, 0x00000004ff0f7819ULL, 0x010fe20000011648ULL,
0x0000000827007824ULL, 0x000fe400078e00ffULL, 0x000000083e077824ULL, 0x008fe200078e00ffULL,
0x000000ff0d00720cULL, 0x040fe20003f45270ULL, 0x00000010480e7824ULL, 0x000fe200078e00ffULL,
0x0000007f0d00780cULL, 0x040fe20003f84070ULL, 0x0000002400007224ULL, 0x020fe200078e0207ULL,
0x0000000f0d00780cULL, 0x000fc40003f64070ULL, 0x000000030d00780cULL, 0x000fe40003f24070ULL,
0x000000050400720cULL, 0x002fe40003f02070ULL, 0x000000f00e137812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040c067824ULL, 0x004fe400078e0247ULL, 0xff317217ff0ac424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x0000000206087824ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f44070ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f4000a0d00c388ULL, 0x000fe20000004800ULL, 0x0000000108117824ULL, 0x040fe200078e020fULL,
0x0000000808097817ULL, 0x000fe20007800000ULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff069424ULL, 0x000fe400078e00ffULL, 0x0000000100027824ULL, 0x002fe200078e0211ULL,
0x00f608040d00b388ULL, 0x0003e20000008a00ULL, 0x7fffff60ff079424ULL, 0x000fe400078e00ffULL,
0x0000000109007824ULL, 0x000fe400078e0a08ULL, 0x00005c0002027625ULL, 0x000fe200078e000bULL,
0x00f688060d009388ULL, 0x0005e40000008a00ULL, 0x000000000f00720cULL, 0x000fe20003f66070ULL,
0x3fffff80ff089424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe200078e00ffULL,
0x0000000711057812ULL, 0x002fe200078ec0ffULL, 0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL,
0x0000001302047210ULL, 0x000fe20007f9e0ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6a8080d009388ULL, 0x0003e20000008a00ULL, 0x0000000f05107812ULL, 0x000fe200078e7848ULL,
0x000000ffff007224ULL, 0x000fe400078e0a12ULL, 0x00f6c80a0d00a388ULL, 0x0003e20000008a00ULL,
0x000000ffff057224ULL, 0x000fc400020e0603ULL, 0x0000001011107824ULL, 0x000fe400078e0210ULL,
0x00000004ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001010077824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000620024027625ULL, 0x000fca00078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602457981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x00000004ff467e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f45447810ULL, 0x004fc40007ffe0ffULL, 0x000000ff45437810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff447819ULL, 0x000fe40000011644ULL, 0x00000008ff437819ULL, 0x000fca0000011643ULL,
0x0000c62000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x002fe20000011647ULL,
0x0000000847427824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x01ffffff00537812ULL, 0x000fe200078ec0ffULL, 0xffffffffff417424ULL, 0x000fc800078e00ffULL,
0x0000000246537824ULL, 0x000fca00078e0253ULL, 0x000000445300720cULL, 0x000fda0003f06070ULL,
0x0000000224008824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640000008624ULL, 0x000fc800078e0203ULL, 0x0000000153008824ULL, 0x000fe200078e0200ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0542ff738cULL, 0x0003e20000000000ULL,
0x0000600000028625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602418981ULL, 0x0004e2000c1e1900ULL, 0x00000001ff3f7819ULL, 0x000fe20000011647ULL,
0x000000803e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000147407812ULL, 0x000fe200078ec0ffULL,
0x00f6880042ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000146007810ULL, 0x000fe20007ffe0ffULL,
0x000020003f3d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x002fe20000011648ULL,
0x0000001040047824ULL, 0x000fe200078e00ffULL, 0x000000430000720cULL, 0x000fe20003f06070ULL,
0x0000000846037824ULL, 0x004fe200078e023fULL, 0x0000000405087810ULL, 0x040fe20007ffe0ffULL,
0x0000000104077824ULL, 0x040fe200078e0205ULL, 0x00000008050a7810ULL, 0x000fe20007ffe0ffULL,
0x0000002003007824ULL, 0x000fe200078e00ffULL, 0x0000000c05107810ULL, 0x000fe20007ffe0ffULL,
0x0000000104097824ULL, 0x040fe200078e0208ULL, 0x0000004807067212ULL, 0x040fe200078e3cffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0x0000000045037217ULL, 0x000fe20007800000ULL,
0x00000008090d7824ULL, 0x040fe200078e00ffULL, 0x0000004809027212ULL, 0x080fe200078e3cffULL,
0x00000001040f7824ULL, 0x000fe200078e0210ULL, 0xfffffff80b067812ULL, 0x000fe200078ee206ULL,
0x0000000103037824ULL, 0x100fe200078e0a00ULL, 0x000000603e007812ULL, 0x000fe200078ef800ULL,
0x00000001040b7824ULL, 0x000fe200078e020aULL, 0xfffffff80d027812ULL, 0x000fe200078ee202ULL,
0x000000003f0473c2ULL, 0x000e6200000e0000ULL, 0x0000002003037807ULL, 0x000fe20000000000ULL,
0x0000000100077824ULL, 0x040fe200078e0207ULL, 0x000000480b0c7212ULL, 0x000fe200078e3cffULL,
0x00000001000d7824ULL, 0x040fe200078e0209ULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000100117824ULL, 0x040fe200078e020bULL, 0x000000480f127212ULL, 0x000fe200078e3cffULL,
0x0000000100157824ULL, 0x000fe200078e020fULL, 0x0000b0003d097810ULL, 0x000fe20007ffe0ffULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000103037824ULL, 0x000fe200078e0a04ULL, 0xfffffff8130c7812ULL, 0x000fe200078ee20cULL,
0x00000010060b7824ULL, 0x100fe200078e0209ULL, 0xfffffff80f127812ULL, 0x000fe200078ee212ULL,
0x00000010020f7824ULL, 0x100fe200078e0209ULL, 0x000000030a00720cULL, 0x080fe20003f26070ULL,
0x000000100c137824ULL, 0x100fe200078e0209ULL, 0x000000030500720cULL, 0x080fe20003f66070ULL,
0x0000001012177824ULL, 0x000fe200078e0209ULL, 0x000000030800720cULL, 0x080fe20003f46070ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x000000031000720cULL, 0x000fe20003f06070ULL,
0xff317217ff3c7424ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000f6a83f3a7811ULL, 0x000fe200078e18ffULL, 0x0000580041007a24ULL, 0x008fc800078e02ffULL,
0x0000008000007824ULL, 0x000fca00078e00ffULL, 0x0000000700077210ULL, 0x040fe40007f9e0ffULL,
0x0000000d000d7210ULL, 0x040fe40007fde0ffULL, 0x00005e00070a7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x00005e000d057a11ULL, 0x000fe200078838ffULL,
0x000000ffff027224ULL, 0x000fe200030e06ffULL, 0x0000001100117210ULL, 0x000fe40007fde0ffULL,
0x00005f00070c7a11ULL, 0x000fc400028f3c0cULL, 0x0000001500007210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200030e06ffULL, 0x00005f000d097a11ULL, 0x000fe200020f3c02ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000700e0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200028e06ffULL, 0x00005e0011067a11ULL, 0x000fe400078838ffULL,
0x00005e0000087a11ULL, 0x000fe400078c38ffULL, 0x0000000a0d027210ULL, 0x000fc40007fbe0ffULL,
0x00005f0011077a11ULL, 0x000fe400020f3c04ULL, 0x0000000d05047210ULL, 0x080fe40007f9e0ffULL,
0x00005f0000007a11ULL, 0x000fe200030f3c03ULL, 0x000000ffff037224ULL, 0x000fe200028e060cULL,
0x0000000d06067210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0609ULL,
0x0000000d08087210ULL, 0x000fe40007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0009e2000d901c46ULL, 0x000000ffff077224ULL, 0x000fc400028e0607ULL,
0x000000ffff097224ULL, 0x000fe200020e0600ULL, 0x00000000040f7faeULL, 0x0009e8000d101c46ULL,
0x0000000006137faeULL, 0x0009e2000c901c46ULL, 0x000000434600720cULL, 0x000fc60003f26070ULL,
0x0000000008177faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000167805ULL, 0x002fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x010fec0000008000ULL,
0x00000000ff687f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003a027f8cULL, 0x0004e2000c80043fULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000203a647810ULL, 0x000fe20007ffe0ffULL,
0x00007ee000001947ULL, 0x000fea0003800000ULL, 0x0000000224397824ULL, 0x004fe400078e00ffULL,
0x00006400ff007624ULL, 0x000fc400078e00ffULL, 0x000000ffff257224ULL, 0x008fe400078e0003ULL,
0x0000640039397624ULL, 0x000fe400078e0200ULL, 0xff317217ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0x0000010046007824ULL, 0x000fca00078e00ffULL, 0x000000450000720cULL, 0x000fda0003f06070ULL,
0x00007e0000000947ULL, 0x02afea0003800000ULL, 0x0000040064007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0053ULL,
0x000000ffff387224ULL, 0x000fe200078e004cULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003a007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000020000735dULL, 0x008fe40003800000ULL,
0x000024003a027984ULL, 0x000ea40000000800ULL, 0x8000000002ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff5b7624ULL, 0x000fe200078e00ffULL,
0x0000000153007812ULL, 0x000fe200078ec0ffULL, 0x0000580041267a24ULL, 0x000fc400078e02ffULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x000000010000780cULL, 0x000fe40003f05070ULL,
0xffffffff5b5b7811ULL, 0x000fc800078e08ffULL, 0x000000015b5b7807ULL, 0x000fca0004000000ULL,
0x0000000153537824ULL, 0x000fca00078e025bULL, 0x000000445300720cULL, 0x000fe20003f06070ULL,
0x0000001047007824ULL, 0x000fe200078e00ffULL, 0x00000001ff3f7819ULL, 0x000fe20000011647ULL,
0x0000010046367824ULL, 0x000fc600078e00ffULL, 0x0000001000027812ULL, 0x000fce00078ec0ffULL,
0x0000005b39248210ULL, 0x000fe20007ffe05aULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000000146007810ULL, 0x000fc60007ffe0ffULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x00000003ff297819ULL, 0x000fc80000011648ULL, 0x0000000624418981ULL, 0x000562000c1e1900ULL,
0x000000430000720cULL, 0x000fe20003f06070ULL, 0x000000203f007824ULL, 0x000fe200078e0236ULL,
0x0000000429497810ULL, 0x040fe20007ffe0ffULL, 0x0000000129377824ULL, 0x140fe200078e0202ULL,
0x00000008294b7810ULL, 0x000fe20007ffe0ffULL, 0x00000080262b7824ULL, 0x000fe200078e00ffULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x0000000837277824ULL, 0x040fe200078e00ffULL,
0x0000004837607212ULL, 0x000fe200078e3cffULL, 0x0000000149357824ULL, 0x100fe200078e0202ULL,
0x0000000045257217ULL, 0x004fe20007800000ULL, 0x000000014b347824ULL, 0x000fe200078e0202ULL,
0x0000000c294d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000835247824ULL, 0x000fe200078e00ffULL,
0xfffffff827607812ULL, 0x000fe200078ee260ULL, 0x0000000125257824ULL, 0x100fe200078e0a00ULL,
0x0000004835617212ULL, 0x080fe200078e3cffULL, 0x0000000834277824ULL, 0x000fe200078e00ffULL,
0x000000603e007812ULL, 0x000fe200078ef800ULL, 0x000000014d337824ULL, 0x000fe200078e0202ULL,
0x0000004834627212ULL, 0x000fe200078e3cffULL, 0x0000001048327824ULL, 0x000fe200078e00ffULL,
0xfffffff824617812ULL, 0x000fe200078ee261ULL, 0x0000000100247824ULL, 0x040fe200078e0237ULL,
0xfffffff827627812ULL, 0x000fe200078ee262ULL, 0x0000000100267824ULL, 0x040fe200078e0235ULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x0000000100277824ULL, 0x040fe200078e0234ULL,
0x000000242b247210ULL, 0x040fe20007f5e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0233ULL,
0x000000262b267210ULL, 0x000fe20007f7e0ffULL, 0x0000000833287824ULL, 0x000fe200078e00ffULL,
0x000000272b277210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0x000000002b2b7210ULL, 0x000fe20007f1e0ffULL, 0x000010004c007824ULL, 0x000fe200078e00ffULL,
0x00005e00242e7a11ULL, 0x000fe200078438ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e06ffULL,
0x0000000225257217ULL, 0x000fe20007800000ULL, 0x000003c000007945ULL, 0x000fe20003800000ULL,
0x0000004833637212ULL, 0x000fc400078e3cffULL, 0x0000100000007812ULL, 0x000fe200078e0cffULL,
0x0000000125027824ULL, 0x000fe200078e0a02ULL, 0x00005f00242f7a11ULL, 0x000fe200010f3c2fULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005e00262c7a11ULL, 0x000fe200078438ffULL,
0x000020003f007824ULL, 0x000fe200078e0200ULL, 0xfffffff828637812ULL, 0x000fe400078ee263ULL,
0x00005e0027287a11ULL, 0x000fe400078638ffULL, 0x00005f00262d7a11ULL, 0x000fe200010f3c2dULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x0000007032317812ULL, 0x000fc400078ec0ffULL,
0x000000022900720cULL, 0x080fe40003f46070ULL, 0x00005f0027297a11ULL, 0x000fe400018f3c24ULL,
0x00005e002b2a7a11ULL, 0x040fe400078038ffULL, 0x000000312e247210ULL, 0x080fe40007f7e0ffULL,
0x0000b00000007810ULL, 0x000fe40007ffe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200000f3c26ULL,
0x000000ffff257224ULL, 0x000fe200018e062fULL, 0x000000312c267210ULL, 0x080fe20007fbe0ffULL,
0x0000001060567824ULL, 0x100fe200078e0200ULL, 0x000000024900720cULL, 0x080fe20003f06070ULL,
0x000000084c2f7824ULL, 0x000fe200078e00ffULL, 0x0000003128287210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0005e2000d101c46ULL, 0x000000024b00720cULL, 0x080fe20003f46070ULL,
0x0000001061577824ULL, 0x100fe200078e0200ULL, 0x000000024d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0xfffffff042027812ULL, 0x000fe200078ec0ffULL,
0x0000001062587824ULL, 0x100fe200078e0200ULL, 0x000000312a2a7210ULL, 0x000fe20007f9e0ffULL,
0x0000001063597824ULL, 0x000fe200078e0200ULL, 0x0000f6a802027810ULL, 0x000fe20007ffe0ffULL,
0x0000000026577faeULL, 0x0007e2000c101c46ULL, 0x000000082f2d7812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0xffffffe042007812ULL, 0x040fe200078ec0ffULL,
0x0000000028587faeULL, 0x0009e2000d101c46ULL, 0x0000001042257812ULL, 0x004fe200078ec0ffULL,
0x00000001022d7824ULL, 0x000fe200078e022dULL, 0x0000000842527812ULL, 0x000fe200078ec0ffULL,
0x000000002a597faeULL, 0x0009e2000e901c46ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000100277824ULL, 0x008fc800078e0225ULL,
0x0000000127527824ULL, 0x000fca00078e0252ULL, 0x000000002d0403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000102267824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d4a7f8cULL, 0x0004e8000c80043fULL,
0x0000040026007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080052247f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x012fc60007844869ULL, 0x00f60c0052297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x0000000840277824ULL, 0x000fe400078e0227ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x000324000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x010fe20003800000ULL, 0x00f60c0027297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002047317824ULL, 0x000fe200078e00ffULL, 0x00000001ff307819ULL, 0x000fe40000011648ULL,
0x0000007032327812ULL, 0x000fe400078ec0ffULL, 0xffffff8031317812ULL, 0x000fe400078ec0ffULL,
0x0000000c30307812ULL, 0x000fc800078ec0ffULL, 0x0000003130007210ULL, 0x000fca0007ffe032ULL,
0x00f0000000277984ULL, 0x000e680000000800ULL, 0x00f2000000027984ULL, 0x0008a20000000800ULL,
0x0000003c2700720bULL, 0x002fe20003f1d000ULL, 0x0000ff027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x010fc800000e0100ULL, 0x0000ffff002a7812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff707424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x000fe40000011647ULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000470000720cULL, 0x000fe20003f65270ULL,
0x0000fed27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000804725b824ULL, 0x000fe200078e0232ULL, 0x000000273c2c7209ULL, 0x000fe40007810000ULL,
0x0000ffff00297812ULL, 0x000fe200078e3cffULL, 0x000000013025b824ULL, 0x000fe200078e0225ULL,
0x00000002ff007819ULL, 0x000fe20000011648ULL, 0x8000002c3c247221ULL, 0x000fe20000010000ULL,
0x000000292aff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002c2500b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL, 0x00000024004f7308ULL, 0x0003220000000800ULL,
0x0000fe727f007947ULL, 0x000fea000b800000ULL, 0x00001f004f247589ULL, 0x01232400000e0000ULL,
0x0000000800007810ULL, 0x002fe20007ffe0ffULL, 0x0000feb27f007947ULL, 0x000fea000b800000ULL,
0x00001f004f007589ULL, 0x00032400000e0000ULL, 0x8000002c27270221ULL, 0x000fe20000010000ULL,
0x00000001ff707807ULL, 0x000fe20000000000ULL, 0x0000004f3b3b7220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe40000410000ULL, 0x0000000023237220ULL, 0x090fe40000410000ULL,
0x0000002700030308ULL, 0x000f220000000800ULL, 0x0000000022227220ULL, 0x000fc40000410000ULL,
0x000000001f1f7220ULL, 0x080fe40000410000ULL, 0x000000001e1e7220ULL, 0x080fe40000410000ULL,
0x000000001b1b7220ULL, 0x080fe40000410000ULL, 0x000000001a1a7220ULL, 0x080fe40000410000ULL,
0x0000000017177220ULL, 0x080fe40000410000ULL, 0x0000000016167220ULL, 0x000fc40000410000ULL,
0x0000000013137220ULL, 0x080fe40000410000ULL, 0x0000000012127220ULL, 0x080fe40000410000ULL,
0x000000000f0f7220ULL, 0x080fe40000410000ULL, 0x000000000e0e7220ULL, 0x080fe40000410000ULL,
0x000000000b0b7220ULL, 0x080fe40000410000ULL, 0x000000000a0a7220ULL, 0x000fc40000410000ULL,
0x0000000007077220ULL, 0x080fe40000410000ULL, 0x0000000006067220ULL, 0x000fe40000410000ULL,
0x0000002421217220ULL, 0x080fe40000410000ULL, 0x0000002420207220ULL, 0x080fe40000410000ULL,
0x000000241d1d7220ULL, 0x080fe40000410000ULL, 0x000000241c1c7220ULL, 0x000fc40000410000ULL,
0x0000002419197220ULL, 0x080fe40000410000ULL, 0x0000002418187220ULL, 0x080fe40000410000ULL,
0x0000002415157220ULL, 0x080fe40000410000ULL, 0x0000002414147220ULL, 0x080fe40000410000ULL,
0x0000002411117220ULL, 0x080fe40000410000ULL, 0x0000002410107220ULL, 0x000fc40000410000ULL,
0x000000240d0d7220ULL, 0x080fe40000410000ULL, 0x000000240c0c7220ULL, 0x080fe40000410000ULL,
0x0000002409097220ULL, 0x080fe40000410000ULL, 0x0000002408087220ULL, 0x080fe40000410000ULL,
0x0000002405057220ULL, 0x080fe40000410000ULL, 0x0000002404047220ULL, 0x000fc40000410000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e002cULL, 0x0000000302020220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003b023b7221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0000040026007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x000524000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000020000735dULL, 0x010fe40003800000ULL,
0x0000040026027984ULL, 0x000ea40000000800ULL, 0x8000000002ff7812ULL, 0x004fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff247819ULL, 0x000fe40000011648ULL, 0x00005410004f7816ULL, 0x002fe20000000000ULL,
0x0000fb527f007947ULL, 0x000fea000b800000ULL, 0x00001f244f4d7589ULL, 0x0002a400000e0000ULL,
0x0000000824027810ULL, 0x000fe20007ffe0ffULL, 0x0000fb927f007947ULL, 0x000fea000b800000ULL,
0x00001f024f4e7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010246c7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6d7424ULL, 0x000fe200078e00ffULL,
0x00001ff000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x000109a000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018246c7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6d7424ULL, 0x000fe200078e00ffULL,
0x0000205000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6e7424ULL, 0x000fc400078e00ffULL,
0x0001094000007944ULL, 0x03cfea0003c00000ULL, 0x00000002475c7824ULL, 0x040fe200078e00ffULL,
0x0000000748677812ULL, 0x000fe200078ec0ffULL, 0x0000020047497824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000045c257812ULL, 0x000fc400078ec0ffULL,
0x0000000867677812ULL, 0x000fe400078ef848ULL, 0x0000002548807211ULL, 0x000fe400078fe0ffULL,
0xfffff80049497812ULL, 0x000fe400078ec0ffULL, 0x0000000780007812ULL, 0x000fe400078e7867ULL,
0x0000000848257812ULL, 0x000fc600078ec0ffULL, 0x0000000867007824ULL, 0x000fc800078e0200ULL,
0x0000001000007824ULL, 0x000fe400078e0249ULL, 0x0000000447247824ULL, 0x002fe200078e00ffULL,
0x00000007252d7812ULL, 0x100fe200078ec848ULL, 0x0000100047267824ULL, 0x000fe200078e00ffULL,
0x0000000725507812ULL, 0x000fe200078ef848ULL, 0x000010004c287824ULL, 0x000fe200078e023dULL,
0x0000000424277812ULL, 0x000fe400078ec0ffULL, 0xffffe00026297812ULL, 0x000fe400078ec0ffULL,
0x00000027482c7211ULL, 0x000fe400078fe0ffULL, 0x0000008050727811ULL, 0x000fe200078e18ffULL,
0x000010004c247824ULL, 0x000fe200078e0229ULL, 0x0000002c2d297212ULL, 0x000fc400078e3cffULL,
0x0000b000286f7810ULL, 0x000fe40007ffe0ffULL, 0x0000b000242e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000850517824ULL, 0x000fe200078e0229ULL, 0x000000022c2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129547824ULL, 0x000fe200078e0272ULL, 0x0000000280807810ULL, 0x000fe20007ffe0ffULL,
0x0000001051247824ULL, 0x000fe200078e022eULL, 0x0000002c2d557212ULL, 0x000fe200078e3cffULL,
0x0000001054287824ULL, 0x000fe200078e026fULL, 0x0000000780807812ULL, 0x000fc600078e7867ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x0000000850507824ULL, 0x000fe400078e0255ULL,
0x0000000155557824ULL, 0x000fe200078e0272ULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x00000010502e7824ULL, 0x000fe400078e022eULL, 0x0000000867807824ULL, 0x000fc800078e0280ULL,
0x0000001080497824ULL, 0x000fe400078e0249ULL, 0x00000100242f7824ULL, 0x046fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011424ULL, 0x00000100256a7824ULL, 0x000fe200078e00ffULL,
0x0000888024857816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001142fULL, 0x000001002a757824ULL, 0x010fe200078e00ffULL,
0x000000002e2c783bULL, 0x000e620000004200ULL, 0x00000018ff4f7819ULL, 0x000fe20000011428ULL,
0x0000006800887306ULL, 0x0005e20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff6b7819ULL, 0x000fe40000011425ULL, 0x0000888025697816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011426ULL,
0x0000002400817306ULL, 0x0009e20000200c00ULL, 0x0000010027687824ULL, 0x004fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011427ULL, 0x00008880267f7816ULL, 0x000fe400000000ffULL,
0x00000018ff687819ULL, 0x000fc40000011468ULL, 0x0000888027867816ULL, 0x040fe200000000ffULL,
0x0000010026247824ULL, 0x050fe200078e00ffULL, 0x0000006800877306ULL, 0x0005e20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff767819ULL, 0x000fe20000011475ULL,
0x0000006900897306ULL, 0x000fe20000200c00ULL, 0x0000888028687816ULL, 0x004fc400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011429ULL, 0x00000018ff5d7819ULL, 0x000fe4000001142aULL,
0x00000018ff5e7819ULL, 0x000fe2000001142bULL, 0x0000002400847306ULL, 0x0005e20000200c00ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x000001002e937824ULL, 0x002fe200078e00ffULL, 0x000088802a717816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000088802b757816ULL, 0x000fe200000000ffULL,
0x0000006a008a7306ULL, 0x0003220000200c00ULL, 0x0000010028247824ULL, 0x044fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe2000001142cULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x00000018ff697819ULL, 0x000fe20000011424ULL,
0x0000001055247824ULL, 0x000fe200078e026fULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x00000025008c7306ULL, 0x0005e20000200c00ULL, 0x00008880296a7816ULL, 0x002fe400000000ffULL,
0x000088802c8b7816ULL, 0x000fe400000000ffULL, 0x00000018ff777819ULL, 0x000fe4000001142dULL,
0x000088802d8f7816ULL, 0x000fe200000000ffULL, 0x0000002800727306ULL, 0x0003e20000200c00ULL,
0x0000010029257824ULL, 0x044fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001142eULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001142fULL,
0x00000018ff6f7819ULL, 0x000fe40000011425ULL, 0x0000002600827306ULL, 0x000fe20000200c00ULL,
0x000001002b287824ULL, 0x042fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002700837306ULL, 0x0003e20000200c00ULL,
0x00000018ff2b7819ULL, 0x000fc4000001142bULL, 0x0000541089897816ULL, 0x010fca000000008aULL,
0x00000028007c7306ULL, 0x0005e20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000004200ULL,
0x0000002900747306ULL, 0x000fe20000200c00ULL, 0x000001002c287824ULL, 0x044fe400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011428ULL,
0x000001002d287824ULL, 0x040fe200078e00ffULL, 0x0000002a007e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100002d2d7824ULL, 0x000fe400078e00ffULL,
0x00000018ff917819ULL, 0x000fc60000011428ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002b007d7306ULL, 0x0005f00000200c00ULL, 0x0000008500857306ULL, 0x000f220000200c00ULL,
0x009000000028783bULL, 0x004eae0000000200ULL, 0x0000009100927306ULL, 0x0007e20000200c00ULL,
0x00000018ff7b7819ULL, 0x002fc40000011424ULL, 0x00000018ff7a7819ULL, 0x000fe40000011425ULL,
0x00000018ff787819ULL, 0x000fe40000011426ULL, 0x00000018ff797819ULL, 0x000fe20000011427ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x0000991070917816ULL, 0x008fe200000000ffULL,
0x000001002f707824ULL, 0x000fe200078e00ffULL, 0x0000541085887816ULL, 0x010fe40000000088ULL,
0x000000ff9100720cULL, 0x000fc60003f05270ULL, 0x0000006b006b7306ULL, 0x000ef00000200c00ULL,
0x0000002c00907306ULL, 0x0009f00000200c00ULL, 0x0000008d008e7306ULL, 0x0003e20000200c00ULL,
0x000088802f2c7816ULL, 0x050fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x0000004d28288232ULL, 0x004fc40000000000ULL, 0x0000004d2a2a8232ULL, 0x000fe40000000000ULL,
0x0000004e29298232ULL, 0x080fe20000000000ULL, 0x0000002c00977306ULL, 0x0005e20000200c00ULL,
0x000088802e8d7816ULL, 0x042fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x0000004e2b2b8232ULL, 0x000fe20000000000ULL, 0x00000018ff2f7819ULL, 0x000fc6000001142fULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002d00947306ULL, 0x0003e20000200c00ULL,
0x00008880242c7816ULL, 0x004fe200000000ffULL, 0x000000882804723cULL, 0x000fe80000001804ULL,
0x000000ffff857224ULL, 0x000fe200078e002cULL, 0x00005410812c7816ULL, 0x000fe2000000006cULL,
0x0000002f00677306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x002fc40000011470ULL,
0x00008880256c7816ULL, 0x000fca00000000ffULL, 0x0000002d00987306ULL, 0x0006700000200c00ULL,
0x0000002e00707306ULL, 0x0005e20000200c00ULL, 0x000054108c2d7816ULL, 0x008fce000000006bULL,
0x0000002c2808723cULL, 0x000fe20000001808ULL, 0x00000100242e7824ULL, 0x044fe200078e00ffULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000541097977816ULL, 0x002fe40000000098ULL, 0x00000018ff6b7819ULL, 0x000fe4000001142eULL,
0x00900000492c783bULL, 0x000e620000000200ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000006500657306ULL, 0x000ef00000200c00ULL, 0x0000006600667306ULL, 0x000f220000200c00ULL,
0x000054107f847816ULL, 0x004fe20000000084ULL, 0x00000100257f7824ULL, 0x000fc400078e00ffULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000541082827816ULL, 0x008fca0000000065ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541083837816ULL, 0x010fce0000000066ULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000000822810723cULL, 0x000fe20000001810ULL, 0x0000004d2c2c8232ULL, 0x002fcc0000000000ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541090907816ULL, 0x004fe20000000073ULL,
0x0000004d2e2e8232ULL, 0x000fe20000000000ULL, 0x0000888026737816ULL, 0x040fe200000000ffULL,
0x00000100264d7824ULL, 0x040fe200078e00ffULL, 0x0000004e2d2d8232ULL, 0x080fe20000000000ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000004e2f2f8232ULL, 0x000fe20000000000ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541094917816ULL, 0x008fe40000000077ULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff267819ULL, 0x000fc60000011426ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000000902818723cULL, 0x000fee0000001818ULL,
0x0000008f008f7306ULL, 0x000eb00000200c00ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054108b8e7816ULL, 0x002fce000000008eULL, 0x0000009300967306ULL, 0x000e620000200c00ULL,
0x000054108f8f7816ULL, 0x004fce0000000092ULL, 0x0000008500807306ULL, 0x0005e20000200c00ULL,
0x0000008e2814723cULL, 0x000fee0000001814ULL, 0x0000002400667306ULL, 0x0007e20000200c00ULL,
0x0000541086857816ULL, 0x004fe40000000087ULL, 0x000054108d967816ULL, 0x002fca0000000096ULL,
0x0000002500657306ULL, 0x0003e20000200c00ULL, 0x0000541070247816ULL, 0x008fe2000000006dULL,
0x00000084280c723cULL, 0x040fec000000180cULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x0000541067257816ULL, 0x002fe2000000006eULL, 0x00000096281c723cULL, 0x000fe2000000181cULL,
0x000000ffff677224ULL, 0x000fca00078e0073ULL, 0x0000006800687306ULL, 0x000fe40000200c00ULL,
0x000000242820723cULL, 0x000fec0000001820ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x0000010027287824ULL, 0x040fe200078e00ffULL, 0x0000888027257816ULL, 0x040fe200000000ffULL,
0x0001000027297824ULL, 0x000fe200078e00ffULL, 0x0000541074737816ULL, 0x004fc4000000005fULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x0000541068687816ULL, 0x002fce0000000069ULL,
0x0000004f004f7306ULL, 0x000e700000200c00ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x0000541075757816ULL, 0x004fce000000007cULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541072727816ULL, 0x002fce000000004fULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000054107e7c7816ULL, 0x008fe2000000005dULL, 0x000000722c08723cULL, 0x000fec0000001808ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x000054107d7d7816ULL, 0x004fce000000005eULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000007c2c10723cULL, 0x000fee0000001810ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054106a697816ULL, 0x002fce000000006fULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x000000682c04723cULL, 0x000fee0000001804ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541071747816ULL, 0x004fce0000000076ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fe2000000007bULL,
0x000000742c0c723cULL, 0x000fec000000180cULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000006b006b7306ULL, 0x000e700000200c00ULL, 0x0000006c006c7306ULL, 0x000ff00000200c00ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0000541080807816ULL, 0x002fce000000006bULL,
0x00000067006d7306ULL, 0x0003f00000200c00ULL, 0x0000004d00247306ULL, 0x000ee20000200c00ULL,
0x000054106c817816ULL, 0x004fe4000000007fULL, 0x0000541065677816ULL, 0x002fca000000007aULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x000000802c14723cULL, 0x040fee0000001814ULL,
0x0000002800287306ULL, 0x000e620000200c00ULL, 0x000054106d247816ULL, 0x008fe20000000024ULL,
0x000000662c18723cULL, 0x000fec0000001818ULL, 0x0000002600277306ULL, 0x000eb00000200c00ULL,
0x00000029002a7306ULL, 0x000ee20000200c00ULL, 0x0000541025257816ULL, 0x002fc40000000028ULL,
0x0000541027787816ULL, 0x004fca0000000078ULL, 0x000000242c1c723cULL, 0x000fe2000000181cULL,
0x000054102a797816ULL, 0x008fce0000000079ULL, 0x000000782c20723cULL, 0x000fe20000001820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003a247f8cULL, 0x0002a2000c80043fULL,
0xfffffff85c5c7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004036247810ULL, 0x004fe20007ffe0ffULL, 0x00f688005cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff697224ULL, 0x000fe200078e004bULL, 0x000000014c4c7812ULL, 0x000fe400078e0cffULL,
0x000000452400720cULL, 0x000fda0003f06070ULL, 0x00005af000000947ULL, 0x000fea0003800000ULL,
0x0000040064247984ULL, 0x004ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003a247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400267305ULL, 0x0004e4000021f000ULL, 0x3fa0000024247823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x000024003a267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000146247810ULL, 0x000fe20007ffe0ffULL, 0x0000100038687824ULL, 0x040fe200078e00ffULL,
0x00000001ff3f7819ULL, 0x000fe20000011647ULL, 0x00000008385d7824ULL, 0x000fe200078e00ffULL,
0x000000432400720cULL, 0x000fe20003f46070ULL, 0x0000001047277824ULL, 0x000fe200078e00ffULL,
0x0000100068267812ULL, 0x000fe200078ec0ffULL, 0x000000203f247824ULL, 0x000fe200078e0236ULL,
0x000000085d5e7812ULL, 0x000fe200078ec0ffULL, 0x000000103f2c7824ULL, 0x000fe200078e00ffULL,
0x00000010272a7812ULL, 0x000fe200078ec0ffULL, 0x000020003f267824ULL, 0x000fe200078e0226ULL,
0x0000008024247810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a82c5f7810ULL, 0x000fe40007ffe0ffULL,
0x0000002445257217ULL, 0x000fe40007800000ULL, 0x000000085e287812ULL, 0x000fe200078e3cffULL,
0x000000015f5e7824ULL, 0x000fe200078e025eULL, 0x0000b00026267810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x100fe200078e0a24ULL, 0x000000603e247812ULL, 0x000fe200078ef824ULL,
0x000000015f5f7824ULL, 0x000fe200078e0228ULL, 0x00000003ff4e7819ULL, 0x000fe20000011648ULL,
0x0000580041287a24ULL, 0x020fe200078e02ffULL, 0x0000002025257807ULL, 0x000fe20001000000ULL,
0x0000001060607824ULL, 0x100fe200078e0226ULL, 0x000000005e0473c2ULL, 0x000ea200000e0000ULL,
0x0000001061617824ULL, 0x100fe200078e0226ULL, 0x000000252a257217ULL, 0x000fe20007800000ULL,
0x0000001062627824ULL, 0x100fe200078e0226ULL, 0x000000102c657812ULL, 0x000fe200078ec0ffULL,
0x0000001063637824ULL, 0x000fc400078e0226ULL, 0x00000080282d7824ULL, 0x000fe400078e00ffULL,
0x0000000137267824ULL, 0x100fe400078e0224ULL, 0x0000000135277824ULL, 0x100fe400078e0224ULL,
0x0000000134287824ULL, 0x100fe200078e0224ULL, 0x000000262d267210ULL, 0x000fe20007f1e0ffULL,
0x0000000133247824ULL, 0x000fe200078e0224ULL, 0x000000272d4c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000125297824ULL, 0x000fe200078e0a2aULL, 0x000000282d287210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e00264d7a11ULL, 0x040fe200078038ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x000000242d2d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005f0026267a11ULL, 0x000fc400000f3c27ULL,
0x00005e004c2f7a11ULL, 0x000fe400078038ffULL, 0x000000084e247810ULL, 0x040fe40007ffe0ffULL,
0x000000044e2a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f004c4c7a11ULL, 0x000fe400000f3c2bULL,
0x00005e0028277a11ULL, 0x000fe400078438ffULL, 0x000000292400720cULL, 0x000fc40003f06070ULL,
0x000000324d247210ULL, 0x000fe40007fbe0ffULL, 0x000000292a00720cULL, 0x080fe20003f66070ULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x00005f00282e7a11ULL, 0x000fe200010f3c25ULL,
0x000000ffff257224ULL, 0x000fe200028e0626ULL, 0x000000294e00720cULL, 0x040fe40003f46070ULL,
0x00005e002d2b7a11ULL, 0x000fe400078838ffULL, 0x0000000c4e4e7810ULL, 0x000fc40007ffe0ffULL,
0x0000003227287210ULL, 0x080fe40007fbe0ffULL, 0x00005f002d2d7a11ULL, 0x000fe400020f3c2aULL,
0x000000294e00720cULL, 0x000fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e062eULL,
0x000000322f267210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024607faeULL, 0x0007e2000d101c46ULL, 0x000000322b2a7210ULL, 0x000fe40007fbe0ffULL,
0x00000008422e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fc400030e064cULL,
0x000000ffff2b7224ULL, 0x000fe200028e062dULL, 0xffffffe0422d7812ULL, 0x000fe400078ec0ffULL,
0x0000000026617faeULL, 0x0007e4000d901c46ULL, 0x0000002d2e657210ULL, 0x000fe40007ffe065ULL,
0x0000000028627faeULL, 0x0007e8000c101c46ULL, 0x000000002a637faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005e247f8cULL, 0x0084e8000c80043fULL, 0x000004005f297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280065267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc6000784484bULL,
0x00f62c00652b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x008fe200078e0025ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x0000001042257812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff247424ULL, 0x000fc600078e00ffULL,
0x0000002d2e257210ULL, 0x000fe40007ffe025ULL, 0x0000002400287305ULL, 0x000724000021f000ULL,
0x3fa0000024247823ULL, 0x008fe200000100ffULL, 0x000000280000735dULL, 0x010fe20003800000ULL,
0x00f62c0025297984ULL, 0x000ee40000000800ULL, 0x8000000029ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008032257810ULL, 0x000fca0007ffe031ULL,
0x0000000130257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ee80000000800ULL,
0x00f2000025267984ULL, 0x0008620000000800ULL, 0x0000003c2700720bULL, 0x008fe20003f1d000ULL,
0x0000e0f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7a7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000147247811ULL, 0x000fe400078ff0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000472400720cULL, 0x000fe20003f65270ULL, 0x0000e0c27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c257209ULL, 0x000fe20007810000ULL,
0x000000804729b824ULL, 0x000fe200078e0232ULL, 0x00000002ff6c7819ULL, 0x000fc60000011648ULL,
0x00000001302cb824ULL, 0x000fe200078e0229ULL, 0x0000ffff24297812ULL, 0x000fe200078e3cffULL,
0x800000253c287221ULL, 0x000fc60000010000ULL, 0x00f400252c00b388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b28287820ULL, 0x000fe20000410000ULL, 0x000000292aff7212ULL, 0x000fc6000780c0ffULL,
0x00000028004f7308ULL, 0x000f240000000800ULL, 0x0000004f3b3b7220ULL, 0x010fe20000410000ULL,
0x0000e0527f007947ULL, 0x000fea000b800000ULL, 0x00001f6c4f247589ULL, 0x00872400000e0000ULL,
0x0000002404047220ULL, 0x090fe40000410000ULL, 0x0000002405057220ULL, 0x080fe40000410000ULL,
0x0000002408087220ULL, 0x080fe40000410000ULL, 0x0000002409097220ULL, 0x080fe40000410000ULL,
0x000000240c0c7220ULL, 0x000fc40000410000ULL, 0x000000240d0d7220ULL, 0x080fe40000410000ULL,
0x0000002410107220ULL, 0x080fe40000410000ULL, 0x0000002411117220ULL, 0x080fe40000410000ULL,
0x0000002414147220ULL, 0x080fe40000410000ULL, 0x0000002415157220ULL, 0x080fe40000410000ULL,
0x0000002418187220ULL, 0x000fc40000410000ULL, 0x0000002419197220ULL, 0x080fe40000410000ULL,
0x000000241c1c7220ULL, 0x080fe40000410000ULL, 0x000000241d1d7220ULL, 0x080fe40000410000ULL,
0x0000002420207220ULL, 0x080fe40000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000df927f007947ULL, 0x000fea000b800000ULL, 0x00001f024f247589ULL, 0x0008a400000e0000ULL,
0x000000273c3c7209ULL, 0x000fe20007810000ULL, 0x0000002406067220ULL, 0x084fe20000410000ULL,
0x00000001ff7a7807ULL, 0x000fe20000000000ULL, 0x0000002407077220ULL, 0x000fc40000410000ULL,
0x8000003c27270221ULL, 0x000fe40000010000ULL, 0x000000240a0a7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe40000410000ULL, 0x000000240b0b7220ULL, 0x080fe40000410000ULL,
0x0000002700030308ULL, 0x000ea20000000800ULL, 0x000000240e0e7220ULL, 0x080fe40000410000ULL,
0x000000240f0f7220ULL, 0x000fc40000410000ULL, 0x0000002412127220ULL, 0x080fe40000410000ULL,
0x0000002413137220ULL, 0x080fe40000410000ULL, 0x0000002416167220ULL, 0x080fe40000410000ULL,
0x0000002417177220ULL, 0x080fe40000410000ULL, 0x000000241a1a7220ULL, 0x080fe40000410000ULL,
0x000000241b1b7220ULL, 0x000fc40000410000ULL, 0x000000241e1e7220ULL, 0x080fe40000410000ULL,
0x000000241f1f7220ULL, 0x080fe40000410000ULL, 0x0000002422227220ULL, 0x080fe40000410000ULL,
0x0000002423237220ULL, 0x000fe40000410000ULL, 0x0000002603260220ULL, 0x006fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003b263b7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000838247824ULL, 0x000fe200078e00ffULL, 0xfffffff042257812ULL, 0x000fc800078ec0ffULL,
0x0000000824247812ULL, 0x000fca00078e0cffULL, 0x0000000125267824ULL, 0x000fca00078e0224ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x000364000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x020fe40003800000ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6c7819ULL, 0x008fe40000011648ULL,
0x00000003ff26723eULL, 0x000fe400000000ffULL, 0x000000186c247810ULL, 0x040fe40007ffe0ffULL,
0x000000106c257810ULL, 0x000fe40007ffe0ffULL, 0x00005410264f7816ULL, 0x010fe20000000026ULL,
0x0000dce27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c4f6b7589ULL, 0x0002e400000e0000ULL,
0x0000dd227f007947ULL, 0x000fea000b800000ULL, 0x00001f024f6a7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0025ULL,
0x000040c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000e8d000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0024ULL,
0x0000412000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000e87000007944ULL, 0x01cfea0003c00000ULL,
0x0000100038247824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100047257824ULL, 0x000fc600078e00ffULL, 0x0000100024247812ULL, 0x000fe400078e0cffULL,
0xffffe00025257812ULL, 0x000fc800078ec0ffULL, 0x0000b00025667810ULL, 0x100fe40007ffe024ULL,
0x0000b0003d247810ULL, 0x000fc60007ffe024ULL, 0x00000010514b7824ULL, 0x100fe400078e0266ULL,
0x0000001050667824ULL, 0x000fe400078e0266ULL, 0x0000001054677824ULL, 0x100fe200078e0224ULL,
0x000000004b28783bULL, 0x000f620000004200ULL, 0x00000010554a7824ULL, 0x000fc600078e0224ULL,
0x00000000664c783bULL, 0x012e680000004200ULL, 0x00000000672c783bULL, 0x004ea80000004200ULL,
0x000000004a24783bULL, 0x000f220000004200ULL, 0x00000018ff7c7819ULL, 0x020fe20000011428ULL,
0x00000100287e7824ULL, 0x040fe200078e00ffULL, 0x00008880287d7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe20000011429ULL,
0x0000010029837824ULL, 0x040fe200078e00ffULL, 0x0000888029827816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000007d007f7306ULL, 0x000be20000200c00ULL, 0x00000018ff787819ULL, 0x000fe2000001142aULL,
0x000001002b877824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff887819ULL, 0x000fe20000011487ULL,
0x0000002800817306ULL, 0x0007e20000200c00ULL, 0x000088802a7d7816ULL, 0x060fe400000000ffULL,
0x00000018ff797819ULL, 0x000fe4000001142bULL, 0x00000018ff767819ULL, 0x002fe4000001144cULL,
0x00000018ff757819ULL, 0x000fe2000001144fULL, 0x0000002900847306ULL, 0x0003e20000200c00ULL,
0x000001002a287824ULL, 0x048fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001144eULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc40000011483ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x000001004c297824ULL, 0x002fe200078e00ffULL, 0x0000007e00807306ULL, 0x0003e20000200c00ULL,
0x00000018ff737819ULL, 0x004fe4000001142dULL, 0x00000018ff6d7819ULL, 0x000fe4000001142cULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff777819ULL, 0x000fe2000001144dULL,
0x0000002a00877306ULL, 0x0005e20000200c00ULL, 0x000088802b7e7816ULL, 0x042fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc4000001142eULL,
0x00000018ff727819ULL, 0x000fe4000001142fULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x00000029008c7306ULL, 0x0003e20000200c00ULL, 0x000001004d2a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x010fe40000011424ULL, 0x00000018ff717819ULL, 0x000fe40000011425ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002800867306ULL, 0x0005e20000200c00ULL,
0x000001004e297824ULL, 0x002fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc40000011426ULL,
0x00000018ff707819ULL, 0x000fe40000011427ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002b008a7306ULL, 0x0003e20000200c00ULL, 0x000088804c287816ULL, 0x044fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000002a008e7306ULL, 0x0005e20000200c00ULL, 0x000088804f2b7816ULL, 0x002fce00000000ffULL,
0x00000028008b7306ULL, 0x0002e20000200c00ULL, 0x000001004f2a7824ULL, 0x044fe400078e00ffULL,
0x000100004f4f7824ULL, 0x000fca00078e00ffULL, 0x0000002900927306ULL, 0x0005e20000200c00ULL,
0x000088804e287816ULL, 0x042fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fcc00078e00ffULL,
0x0000002800917306ULL, 0x0003220000200c00ULL, 0x000001002c297824ULL, 0x004fe200078e00ffULL,
0x000054108b8c7816ULL, 0x008fcc000000008cULL, 0x0000004c008f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff287819ULL, 0x002fe4000001144fULL, 0x00000018ff4f7819ULL, 0x000fe20000011429ULL,
0x000001002d297824ULL, 0x000fc800078e00ffULL, 0x0000002b00937306ULL, 0x000fe20000200c00ULL,
0x00000018ff4c7819ULL, 0x004fe4000001142aULL, 0x00000018ff2a7819ULL, 0x000fe4000001144eULL,
0x000088802c4e7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x0000541091927816ULL, 0x010fe20000000092ULL, 0x0000004c00947306ULL, 0x0002a60000200c00ULL,
0x00000018ff2c7819ULL, 0x000fca000001142cULL, 0x0000002a00957306ULL, 0x000fe20000200c00ULL,
0x00000018ff4c7819ULL, 0x002fce0000011429ULL, 0x0000002800967306ULL, 0x0003e20000200c00ULL,
0x0000541093937816ULL, 0x004fce0000000094ULL, 0x0000007d00857306ULL, 0x0005e20000200c00ULL,
0x009800000028783bULL, 0x002e6e0000000200ULL, 0x0000004c009a7306ULL, 0x0007e20000200c00ULL,
0x000088804d7d7816ULL, 0x044fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000007d008d7306ULL, 0x0005220000200c00ULL,
0x000099107a4c7816ULL, 0x008fc800000000ffULL, 0x000000ff4c00720cULL, 0x000fe40003f05270ULL,
0x00008880244c7816ULL, 0x000fe200000000ffULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x000088802d7d7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x000054108d8d7816ULL, 0x010fce000000008eULL, 0x0000002d009c7306ULL, 0x0007e20000200c00ULL,
0x0000006b28288232ULL, 0x082fe40000000000ULL, 0x0000006b2a2a8232ULL, 0x000fe40000000000ULL,
0x0000006a29298232ULL, 0x080fe40000000000ULL, 0x0000006a2b2b8232ULL, 0x000fe20000000000ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000001002f2d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000008c2814723cULL, 0x040fe20000001814ULL,
0x0000007b007b7306ULL, 0x000fee0000200c00ULL, 0x00000092281c723cULL, 0x000fe2000000181cULL,
0x0000002c00987306ULL, 0x0003f00000200c00ULL, 0x0000007e00897306ULL, 0x0007e20000200c00ULL,
0x000088802f2c7816ULL, 0x042fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000004d00907306ULL, 0x0003e20000200c00ULL,
0x000088802e7e7816ULL, 0x008fce00000000ffULL, 0x0000002c009b7306ULL, 0x0007e20000200c00ULL,
0x000001002e4d7824ULL, 0x042fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000002d009e7306ULL, 0x0004620000200c00ULL,
0x000054107f2c7816ULL, 0x008fe40000000080ULL, 0x00000018ff2e7819ULL, 0x000fca000001142eULL,
0x0000002e007a7306ULL, 0x0007e20000200c00ULL, 0x00005410822d7816ULL, 0x004fce0000000083ULL,
0x0000002c2804723cULL, 0x000fe20000001804ULL, 0x00000100242e7824ULL, 0x048fe200078e00ffULL,
0x0000004d00977306ULL, 0x0005e20000200c00ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x000054109b7f7816ULL, 0x002fc6000000009eULL, 0x00005410812c7816ULL, 0x000fe4000000007cULL,
0x00005410842d7816ULL, 0x000fe2000000007bULL, 0x0000002f009d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4d7819ULL, 0x004fe4000001142eULL, 0x00008880257b7816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002c2808723cULL, 0x000fe40000001808ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x00980000492c783bULL, 0x002e6e0000000200ULL,
0x0000007800787306ULL, 0x000eb00000200c00ULL, 0x0000007900797306ULL, 0x000ef00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541087787816ULL, 0x004fce0000000078ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x000054108a797816ULL, 0x008fce0000000079ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000054108f767816ULL, 0x010fe20000000076ULL,
0x000000782810723cULL, 0x000fe20000001810ULL, 0x0000006b2c2c8232ULL, 0x082fe40000000000ULL,
0x0000006b2e2e8232ULL, 0x000fe20000000000ULL, 0x00000100266b7824ULL, 0x000fe200078e00ffULL,
0x0000006a2d2d8232ULL, 0x080fe20000000000ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x0000541090777816ULL, 0x004fe20000000077ULL, 0x0001000025787824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000006a2f2f8232ULL, 0x000fc60000000000ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000004c00807306ULL, 0x0005e20000200c00ULL,
0x0000541095747816ULL, 0x008fe20000000074ULL, 0x000000762818723cULL, 0x000fec0000001818ULL,
0x0000004d00817306ULL, 0x0007220000200c00ULL, 0x00005410854c7816ULL, 0x004fc40000000086ULL,
0x0000541096757816ULL, 0x002fca0000000075ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00005410894d7816ULL, 0x008fe20000000088ULL, 0x000000742820723cULL, 0x040fec0000001820ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541080807816ULL, 0x010fe20000000081ULL,
0x0000004c280c723cULL, 0x000fec000000180cULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000000ffff4c7224ULL, 0x000fe200078e007bULL, 0x0000888027287816ULL, 0x000fe200000000ffULL,
0x00000100257b7824ULL, 0x000fe200078e00ffULL, 0x0000541098987816ULL, 0x002fe2000000006dULL,
0x0000010027297824ULL, 0x000fc400078e00ffULL, 0x00010000272a7824ULL, 0x000fe200078e00ffULL,
0x0000002400257306ULL, 0x0002e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x000054107a7a7816ULL, 0x004fe2000000006fULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000888026247816ULL, 0x042fe200000000ffULL, 0x0001000026267824ULL, 0x000fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x00005410256e7816ULL, 0x008fce000000006eULL, 0x0000007300737306ULL, 0x000eb00000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000054104e4e7816ULL, 0x002fce000000004fULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054109c997816ULL, 0x004fce0000000073ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000982c08723cULL, 0x000fee0000001808ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007d007d7306ULL, 0x000e700000200c00ULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054107d4f7816ULL, 0x002fce000000009aULL, 0x0000007b004d7306ULL, 0x0002e20000200c00ULL,
0x000054107e7e7816ULL, 0x004fe20000000097ULL, 0x0000004e2c04723cULL, 0x040fec0000001804ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000054109d7b7816ULL, 0x002fe20000000072ULL,
0x0000007e2c0c723cULL, 0x040fec000000180cULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x000054104c817816ULL, 0x008fe2000000004dULL, 0x0000007a2c10723cULL, 0x040fec0000001810ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x00005410786f7816ULL, 0x004fe20000000071ULL,
0x000000802c14723cULL, 0x040fec0000001814ULL, 0x0000002800287306ULL, 0x000fe40000200c00ULL,
0x0000006e2c18723cULL, 0x000fec0000001818ULL, 0x0000002900297306ULL, 0x000ea20000200c00ULL,
0x0000541024247816ULL, 0x002fce000000006bULL, 0x0000002600277306ULL, 0x000e700000200c00ULL,
0x0000002a006d7306ULL, 0x000ee20000200c00ULL, 0x0000541028257816ULL, 0x004fe40000000029ULL,
0x00005410276c7816ULL, 0x002fca000000006cULL, 0x000000242c1c723cULL, 0x000fe2000000181cULL,
0x000054106d6d7816ULL, 0x008fce0000000070ULL, 0x0000006c2c20723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003a247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008036247810ULL, 0x004fe20007ffe0ffULL, 0x00f690005cff7f8cULL, 0x0005e2000c80043fULL,
0x00000001384c7812ULL, 0x000fe400078ec0ffULL, 0x000000452400720cULL, 0x000fda0003f06070ULL,
0x00003c0000000947ULL, 0x000fea0003800000ULL, 0x0000040064247984ULL, 0x004ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003a247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400267305ULL, 0x0004e4000021f000ULL,
0x3fa0000024247823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x000024003a267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015a5a7824ULL, 0x000fe400078e025bULL,
0x00000300ff247624ULL, 0x000fe400078e00ffULL, 0x0000580041287a24ULL, 0x000fe200078e02ffULL,
0x000000015a257812ULL, 0x000fe200078ec0ffULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0xffffffff24247811ULL, 0x000fe400078e08ffULL, 0x000000012500780cULL, 0x000fc80003f05070ULL,
0x00000001245b7807ULL, 0x000fca0004000000ULL, 0x000000015a257824ULL, 0x000fe200078e025bULL,
0x00000001ff3f7819ULL, 0x000fc80000011647ULL, 0x000000442500720cULL, 0x000fe20003f06070ULL,
0x000000203f267824ULL, 0x000fca00078e0236ULL, 0x000000c026267810ULL, 0x000fc80007ffe0ffULL,
0x0000002645277217ULL, 0x000fc60007800000ULL, 0x0000005b39248210ULL, 0x000fe20007ffe05aULL,
0x00000004ff258424ULL, 0x000fe400078e00ffULL, 0x0000000127277824ULL, 0x100fe200078e0a26ULL,
0x000000603e267812ULL, 0x000fe200078ef826ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x00000001462a7810ULL, 0x000fc60007ffe0ffULL, 0x0000008028297824ULL, 0x000fe200078e00ffULL,
0x0000000624418981ULL, 0x000562000c1e1900ULL, 0x000000432a00720cULL, 0x000fe20003f46070ULL,
0x00000010472a7824ULL, 0x000fe200078e00ffULL, 0xfffffff0422b7812ULL, 0x000fe200078ec0ffULL,
0x0000000134287824ULL, 0x100fe200078e0226ULL, 0x000000085d537812ULL, 0x000fe400078ec0ffULL,
0x000000102a2e7812ULL, 0x000fe200078ec0ffULL, 0x000000002b0573c2ULL, 0x000ee200000e0000ULL,
0x0000002027277807ULL, 0x000fe20001000000ULL, 0x0000000137247824ULL, 0x104fe200078e0226ULL,
0x00000008532c7812ULL, 0x000fe200078e3cffULL, 0x0000000135257824ULL, 0x100fe200078e0226ULL,
0x000000272e277217ULL, 0x000fe20007800000ULL, 0x0000000133267824ULL, 0x000fe200078e0226ULL,
0x0000002429247210ULL, 0x040fe20007f1e0ffULL, 0x000000002c0473c2ULL, 0x000ea200000e0000ULL,
0x00000025292a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a2eULL,
0x0000002829287210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e00244f7a11ULL, 0x000fe200078038ffULL, 0x000000ffff4d7224ULL, 0x000fe200010e06ffULL,
0x0000002629267210ULL, 0x000fc40007f9e0ffULL, 0x00005f00244c7a11ULL, 0x000fe200000f3c25ULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005e002a2f7a11ULL, 0x000fe200078038ffULL,
0x000000ffff2d7224ULL, 0x000fe200020e06ffULL, 0x00000003ff4e7819ULL, 0x000fe40000011648ULL,
0x00005e0028297a11ULL, 0x000fe200078438ffULL, 0x0000f6a805057890ULL, 0x008fe2000fffe03fULL,
0x00005e00262b7a11ULL, 0x000fe400078638ffULL, 0x00005f002a2a7a11ULL, 0x000fc400000f3c4dULL,
0x000000274e00720cULL, 0x000fe40003f06070ULL, 0x00005f00282e7a11ULL, 0x000fe200010f3c25ULL,
0x0000000405047290ULL, 0x004fe2000fffe03fULL, 0x00005f00262d7a11ULL, 0x000fe400018f3c2dULL,
0x000000324f247210ULL, 0x000fe40007f5e0ffULL, 0x000000084e267810ULL, 0x040fe40007ffe0ffULL,
0x000000044e287810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e064cULL,
0x0000000c4e4e7810ULL, 0x000fc40007ffe0ffULL, 0x000000272600720cULL, 0x080fe40003f66070ULL,
0x000000322f267210ULL, 0x080fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0005e2000c101c46ULL, 0x000000272800720cULL, 0x080fe40003f86070ULL,
0x000000274e00720cULL, 0x000fe20003f46070ULL, 0x000000ffff277224ULL, 0x000fe200028e062aULL,
0x0000003229287210ULL, 0x080fe40007f1e0ffULL, 0x000000322b2a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe400000e062eULL, 0x000000ffff2b7224ULL, 0x000fe400028e062dULL,
0x0000000026577faeULL, 0x0007e8000e101c46ULL, 0x0000000028587faeULL, 0x0007e8000d901c46ULL,
0x000000002a597faeULL, 0x0007e8000d101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002c567f8cULL, 0x0084e8000c800405ULL,
0x0000040553267984ULL, 0x0005220008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480052247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x010fc60007844869ULL, 0x00f64c0052277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe042277812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff267424ULL, 0x000fe200078e00ffULL,
0x0000001042287812ULL, 0x040fe400078ec0ffULL, 0x0000000842297812ULL, 0x000fc800078ec0ffULL,
0x0000002729287210ULL, 0x000fe40007ffe028ULL, 0x0000002600277305ULL, 0x000864000021f000ULL,
0x3fa0000026267823ULL, 0x010fe200000100ffULL, 0x000000270000735dULL, 0x002fe40003800000ULL,
0x00f64c0028277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010032257810ULL, 0x000fca0007ffe031ULL,
0x0000000130257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000f280000000800ULL,
0x00f2000025267984ULL, 0x0002a20000000800ULL, 0x0000003c2700720bULL, 0x010fe20003f1d000ULL,
0x0000c4527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7e7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000247247811ULL, 0x000fe400078ff0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000472400720cULL, 0x000fe20003f65270ULL, 0x0000c4227f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c257209ULL, 0x000fe20007810000ULL,
0x000000804729b824ULL, 0x000fe200078e0232ULL, 0x00000002ff6c7819ULL, 0x000fc60000011648ULL,
0x00000001302cb824ULL, 0x004fe200078e0229ULL, 0x0000ffff24297812ULL, 0x000fe200078e3cffULL,
0x800000253c287221ULL, 0x000fc60000010000ULL, 0x00f400252c00b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b28287820ULL, 0x000fe20000410000ULL, 0x000000292aff7212ULL, 0x000fc6000780c0ffULL,
0x00000028004f7308ULL, 0x000ea40000000800ULL, 0x0000004f3b3b7220ULL, 0x004fe20000410000ULL,
0x0000c3b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c4f247589ULL, 0x0022a400000e0000ULL,
0x0000002404047220ULL, 0x084fe40000410000ULL, 0x0000002405057220ULL, 0x080fe40000410000ULL,
0x0000002408087220ULL, 0x080fe40000410000ULL, 0x0000002409097220ULL, 0x080fe40000410000ULL,
0x000000240c0c7220ULL, 0x000fc40000410000ULL, 0x000000240d0d7220ULL, 0x080fe40000410000ULL,
0x0000002410107220ULL, 0x080fe40000410000ULL, 0x0000002411117220ULL, 0x080fe40000410000ULL,
0x0000002414147220ULL, 0x080fe40000410000ULL, 0x0000002415157220ULL, 0x080fe40000410000ULL,
0x0000002418187220ULL, 0x000fc40000410000ULL, 0x0000002419197220ULL, 0x080fe40000410000ULL,
0x000000241c1c7220ULL, 0x080fe40000410000ULL, 0x000000241d1d7220ULL, 0x080fe40000410000ULL,
0x0000002420207220ULL, 0x080fe40000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000c2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f024f247589ULL, 0x00052400000e0000ULL,
0x000000273c3c7209ULL, 0x000fe20007810000ULL, 0x0000002406067220ULL, 0x090fe20000410000ULL,
0x00000001ff7e7807ULL, 0x000fe20000000000ULL, 0x0000002407077220ULL, 0x000fc40000410000ULL,
0x8000003c27270221ULL, 0x000fe40000010000ULL, 0x000000240a0a7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe40000410000ULL, 0x000000240b0b7220ULL, 0x080fe40000410000ULL,
0x0000002700030308ULL, 0x000f220000000800ULL, 0x000000240e0e7220ULL, 0x080fe40000410000ULL,
0x000000240f0f7220ULL, 0x000fc40000410000ULL, 0x0000002412127220ULL, 0x080fe40000410000ULL,
0x0000002413137220ULL, 0x080fe40000410000ULL, 0x0000002416167220ULL, 0x080fe40000410000ULL,
0x0000002417177220ULL, 0x080fe40000410000ULL, 0x000000241a1a7220ULL, 0x080fe40000410000ULL,
0x000000241b1b7220ULL, 0x000fc40000410000ULL, 0x000000241e1e7220ULL, 0x080fe40000410000ULL,
0x000000241f1f7220ULL, 0x080fe40000410000ULL, 0x0000002422227220ULL, 0x080fe40000410000ULL,
0x0000002423237220ULL, 0x000fe40000410000ULL, 0x0000002603260220ULL, 0x010fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003b263b7221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000085d257812ULL, 0x000fe400078ec0ffULL, 0xfffffff042247812ULL, 0x000fca00078ec0ffULL,
0x0000000124257824ULL, 0x000fca00078e0225ULL, 0x00f6ac0025247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400267305ULL, 0x000524000021f000ULL, 0x3fa0000024247823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x010fe40003800000ULL, 0x00f6ac0025267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff6c7819ULL, 0x002fe40000011648ULL, 0x00000003ff26723eULL, 0x000fe400000000ffULL,
0x000000186c247810ULL, 0x040fe40007ffe0ffULL, 0x000000106c257810ULL, 0x000fe40007ffe0ffULL,
0x00005410264f7816ULL, 0x000fe20000000026ULL, 0x0000c0527f007947ULL, 0x000fea000b800000ULL,
0x00001f6c4f537589ULL, 0x0002a400000e0000ULL, 0x0000c0927f007947ULL, 0x000fea000b800000ULL,
0x00001f024f527589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0025ULL, 0x00005fb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x0000c9e000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0024ULL, 0x0000601000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x0000c98000007944ULL, 0x03cfea0003c00000ULL, 0x00001000684c7812ULL, 0x000fe200078ec0ffULL,
0x00001000472c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000099107e7e7816ULL, 0x000fe400000000ffULL, 0x0000b0003d247810ULL, 0x000fe40007ffe04cULL,
0xffffe0002c2d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff7e00720cULL, 0x000fe20003f05270ULL,
0x0000001054287824ULL, 0x000fe200078e0224ULL, 0x0000b0002d4c7810ULL, 0x000fe20007ffe04cULL,
0x0000001055247824ULL, 0x000fc800078e0224ULL, 0x00000010512c7824ULL, 0x100fe200078e024cULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x00000010504c7824ULL, 0x000fc600078e024cULL,
0x000000002424783bULL, 0x000fe80000004200ULL, 0x000000002c2c783bULL, 0x004ea80000004200ULL,
0x000000004c4c783bULL, 0x012e620000004200ULL, 0x00000018ff6b7819ULL, 0x000fe2000001142bULL,
0x00000100296c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011428ULL,
0x000001002a737824ULL, 0x000fe200078e00ffULL, 0x0000006b00507306ULL, 0x0009e20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011429ULL, 0x00000018ff547819ULL, 0x000fe2000001142aULL,
0x000001002d827824ULL, 0x004fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001142cULL,
0x000100002f8c7824ULL, 0x000fe200078e00ffULL, 0x000088802a727816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x010fe2000001142dULL,
0x0000006a00817306ULL, 0x0005e20000200c00ULL, 0x00000018ff757819ULL, 0x000fe20000011473ULL,
0x000100004d7e7824ULL, 0x002fe200078e00ffULL, 0x000088802b737816ULL, 0x000fe200000000ffULL,
0x000001004c8e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x000001004e907824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001142eULL,
0x0000006b00837306ULL, 0x0003e20000200c00ULL, 0x00008880286a7816ULL, 0x004fc400000000ffULL,
0x000088802e857816ULL, 0x000fe400000000ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001142fULL,
0x000088802f887816ULL, 0x000fe200000000ffULL, 0x0000002a007d7306ULL, 0x000fe20000200c00ULL,
0x00000100286b7824ULL, 0x042fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff6d7819ULL, 0x000fc4000001146bULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00008880296b7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001144cULL,
0x000088804c8d7816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x00000028006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7e7819ULL, 0x000fc4000001147eULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff7c7819ULL, 0x000fe4000001144dULL, 0x00000018ff6f7819ULL, 0x000fe2000001144eULL,
0x0000002900707306ULL, 0x0005e20000200c00ULL, 0x000001002b287824ULL, 0x042fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001144fULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000010024297824ULL, 0x004fe200078e00ffULL,
0x0000002800747306ULL, 0x0003e20000200c00ULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff597819ULL, 0x000fe40000011424ULL, 0x00000018ff767819ULL, 0x000fe20000011429ULL,
0x000001002c297824ULL, 0x000fe200078e00ffULL, 0x0000888024797816ULL, 0x040fe200000000ffULL,
0x0000002b007b7306ULL, 0x0005e20000200c00ULL, 0x0000010025287824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011425ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff787819ULL, 0x000fe40000011428ULL,
0x000088802c287816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x000088802d2b7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000888025777816ULL, 0x000fe200000000ffULL, 0x0000002c002a7306ULL, 0x0002a20000200c00ULL,
0x00000018ff587819ULL, 0x000fe40000011426ULL, 0x00000018ff687819ULL, 0x000fe40000011427ULL,
0x00000018ff6c7819ULL, 0x000fc6000001146cULL, 0x0000002d00847306ULL, 0x0009e20000200c00ULL,
0x000001002e2c7824ULL, 0x042fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001142cULL, 0x000001002f2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001142eULL, 0x0000002800287306ULL, 0x000e620000200c00ULL,
0x000054102a2a7816ULL, 0x004fe40000000081ULL, 0x00000018ff8a7819ULL, 0x000fe4000001142cULL,
0x00a00000002c783bULL, 0x010ea60000000200ULL, 0x0000002b002b7306ULL, 0x000f220000200c00ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000054102b297816ULL, 0x010fce0000000082ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410842b7816ULL, 0x000fce0000000083ULL, 0x0000008700897306ULL, 0x0003f00000200c00ULL,
0x0000008c008c7306ULL, 0x000f220000200c00ULL, 0x000088804d877816ULL, 0x002fe200000000ffULL,
0x000000532c2c8232ULL, 0x004fc40000000000ULL, 0x000000532e2e8232ULL, 0x000fe40000000000ULL,
0x000000522d2d8232ULL, 0x080fe40000000000ULL, 0x0000007e00917306ULL, 0x000fe20000200c00ULL,
0x000000522f2f8232ULL, 0x000fe20000000000ULL, 0x000054108c7f7816ULL, 0x010fcc000000007fULL,
0x000000282c04723cULL, 0x040fe20000001804ULL, 0x0000008a008b7306ULL, 0x0003ec0000200c00ULL,
0x000001004f287824ULL, 0x000fe200078e00ffULL, 0x0000002a2c08723cULL, 0x000fe20000001808ULL,
0x00000087008f7306ULL, 0x0005e20000200c00ULL, 0x000001004d8a7824ULL, 0x002fc400078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011428ULL, 0x00a000004928783bULL, 0x000e620000000200ULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x0000004c004d7306ULL, 0x0009e20000200c00ULL,
0x000088804e877816ULL, 0x044fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000007e00817306ULL, 0x0005e20000200c00ULL,
0x000088804f4c7816ULL, 0x050fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410897e7816ULL, 0x004fce0000000080ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x0000007e2c10723cULL, 0x000fee0000001810ULL, 0x0000008700927306ULL, 0x000fe20000200c00ULL,
0x00010000257f7824ULL, 0x000fe200078e00ffULL, 0x0000005328288232ULL, 0x002fc80000000000ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x000000532a2a8232ULL, 0x000fe20000000000ULL,
0x0000009000937306ULL, 0x000e620000200c00ULL, 0x0000541091257816ULL, 0x004fe2000000007cULL,
0x0000005229298232ULL, 0x080fe40000000000ULL, 0x000000522b2b8232ULL, 0x000fc80000000000ULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541092927816ULL, 0x002fce0000000093ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000008800887306ULL, 0x000eb00000200c00ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x0000541085867816ULL, 0x002fce0000000086ULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x0000541088877816ULL, 0x004fce000000008bULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x000000862c0c723cULL, 0x000fee000000180cULL,
0x0000004c004c7306ULL, 0x000f220000200c00ULL, 0x000054108d8e7816ULL, 0x002fce000000008eULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054108f8f7816ULL, 0x004fce000000008aULL,
0x0000004f007e7306ULL, 0x000ea20000200c00ULL, 0x000054104c937816ULL, 0x010fe20000000081ULL,
0x0000008e2c14723cULL, 0x040fec0000001814ULL, 0x0000002400807306ULL, 0x0009e20000200c00ULL,
0x000054104e4e7816ULL, 0x002fe2000000006fULL, 0x000000922c1c723cULL, 0x000fe2000000181cULL,
0x000054107e4f7816ULL, 0x004fca0000000071ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000054104d247816ULL, 0x010fe2000000007aULL, 0x0000004e2c20723cULL, 0x040fec0000001820ULL,
0x0000005900597306ULL, 0x000ea40000200c00ULL, 0x000000242c18723cULL, 0x000fec0000001818ULL,
0x0000005100517306ULL, 0x000f220000200c00ULL, 0x00005410706f7816ULL, 0x002fc40000000055ULL,
0x000054107b557816ULL, 0x000fe20000000050ULL, 0x0000010026257824ULL, 0x040fe200078e00ffULL,
0x0000888026247816ULL, 0x040fe200000000ffULL, 0x00000100272d7824ULL, 0x040fe200078e00ffULL,
0x00008880272c7816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x00010000272e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000541080807816ULL, 0x004fe40000000059ULL, 0x000054106e6e7816ULL, 0x010fe20000000051ULL,
0x0000002500257306ULL, 0x000e6c0000200c00ULL, 0x0000006e2808723cULL, 0x000fe40000001808ULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541024247816ULL, 0x002fce0000000025ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054107d547816ULL, 0x004fce0000000054ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000000542810723cULL, 0x000fee0000001810ULL, 0x0000006a006a7306ULL, 0x000ff00000200c00ULL,
0x0000006d006d7306ULL, 0x000e700000200c00ULL, 0x0000006b006b7306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000054106a6a7816ULL, 0x002fce000000006dULL,
0x0000007200727306ULL, 0x000ff00000200c00ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000054106b6b7816ULL, 0x004fce000000006cULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000006a2804723cULL, 0x000fee0000001804ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x0000541072727816ULL, 0x002fce0000000075ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541073737816ULL, 0x004fce0000000074ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000072280c723cULL, 0x000fee000000180cULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000541079767816ULL, 0x002fce0000000076ULL, 0x0000007f004c7306ULL, 0x000e700000200c00ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000078ULL,
0x0000002d002d7306ULL, 0x000ea20000200c00ULL, 0x000054104c817816ULL, 0x002fe20000000069ULL,
0x000000762814723cULL, 0x040fec0000001814ULL, 0x0000002600277306ULL, 0x000e640000200c00ULL,
0x000000802818723cULL, 0x000fec0000001818ULL, 0x0000002e002f7306ULL, 0x000f220000200c00ULL,
0x000054102c257816ULL, 0x004fc4000000002dULL, 0x0000541027587816ULL, 0x002fca0000000058ULL,
0x00000024281c723cULL, 0x000fe2000000181cULL, 0x000054102f597816ULL, 0x010fce0000000068ULL,
0x000000582820723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003a247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c036367810ULL, 0x000fe20007ffe0ffULL,
0x00f698005cff7f8cULL, 0x0009e2000c80043fULL, 0x000000015a537824ULL, 0x000fe200078e025bULL,
0x00000001384c7812ULL, 0x000fe200078e0cffULL, 0x000000ffff697224ULL, 0x008fe200078e0057ULL,
0x000000453600720cULL, 0x000fda0003f06070ULL, 0x00001d1000000947ULL, 0x000fea0003800000ULL,
0x0000040064247984ULL, 0x014ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003a247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400267305ULL, 0x0004e4000021f000ULL, 0x3fa0000024247823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x000024003a267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000f6a83f4d7811ULL, 0x000fe200078e20ffULL, 0x0000580041277a24ULL, 0x020fe200078e02ffULL,
0x0000030046247a10ULL, 0x000fe20007ffe0ffULL, 0x000000005e0473c2ULL, 0x0004e200000e0000ULL,
0x00000001ff3f7819ULL, 0x000fe20000011647ULL, 0x0000008027277824ULL, 0x000fe200078e00ffULL,
0x000000085d687812ULL, 0x000fc600078ec0ffULL, 0x0000000824257824ULL, 0x040fe200078e023fULL,
0x0000000124247810ULL, 0x000fe20007ffe0ffULL, 0x000000014d687824ULL, 0x000fe400078e0268ULL,
0x0000002025257824ULL, 0x000fe200078e00ffULL, 0x000000432400720cULL, 0x000fc80003f06070ULL,
0x0000002545267217ULL, 0x000fe40007800000ULL, 0x000000603e247812ULL, 0x000fc600078ef825ULL,
0x0000000126267824ULL, 0x000fe400078e0a25ULL, 0x0000001047257824ULL, 0x000fe400078e00ffULL,
0x0000000137377824ULL, 0x100fe200078e0224ULL, 0x0000002026267807ULL, 0x000fe20000000000ULL,
0x0000000135357824ULL, 0x100fe200078e0224ULL, 0x0000001025257812ULL, 0x000fe200078ec0ffULL,
0x0000000134347824ULL, 0x100fe200078e0224ULL, 0x0000003727377210ULL, 0x000fe20007f5e0ffULL,
0x0000000133247824ULL, 0x000fe200078e0224ULL, 0x0000002625267217ULL, 0x000fc40007800000ULL,
0x0000003527357210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x0000003427347210ULL, 0x000fe20007f5e0ffULL, 0x0000000126297824ULL, 0x000fe200078e0a25ULL,
0x00005e00372b7a11ULL, 0x000fe200078038ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00000003ff267819ULL, 0x000fe20000011648ULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x00000024272c7210ULL, 0x000fe40007f9e0ffULL, 0x00005f00372e7a11ULL, 0x000fc400000f3c2eULL,
0x00005e0035277a11ULL, 0x040fe200078038ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x00005e00342f7a11ULL, 0x000fe400078438ffULL, 0x0000000826247810ULL, 0x000fe40007ffe0ffULL,
0x00005f0035287a11ULL, 0x000fe400000f3c28ULL, 0x00005f00342a7a11ULL, 0x000fe400010f3c25ULL,
0x0000000426367810ULL, 0x000fc40007ffe0ffULL, 0x000000292400720cULL, 0x080fe40003f06070ULL,
0x000000292600720cULL, 0x0c0fe40003f66070ULL, 0x0000000c26347810ULL, 0x000fe40007ffe0ffULL,
0x000000322b247210ULL, 0x080fe40007fde0ffULL, 0x0000003227267210ULL, 0x080fe40007fbe0ffULL,
0x000000293600720cULL, 0x000fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200030e062eULL,
0x00005e002c2b7a11ULL, 0x000fe200078838ffULL, 0x000000ffff277224ULL, 0x000fe200028e0628ULL,
0x000000322f287210ULL, 0x000fc40007fde0ffULL, 0x000000293400720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024607faeULL, 0x0009e2000d901c46ULL,
0x00005f002c2c7a11ULL, 0x000fe200020f3c2dULL, 0x000000ffff297224ULL, 0x000fe200030e062aULL,
0x000000322b2a7210ULL, 0x000fc60007f9e0ffULL, 0x0000000026617faeULL, 0x0009e4000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe400020e062cULL, 0x0000000028627faeULL, 0x0009e8000c101c46ULL,
0x000000002a637faeULL, 0x0009e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000068687f8cULL, 0x000ea8000c80043fULL,
0x000004005f5f7984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680065247f8cULL, 0x010fe2000c80043fULL,
0x800000005fff7812ULL, 0x008fc60007844857ULL, 0x00f66c0065277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x008fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff267424ULL, 0x000fc800078e00ffULL, 0x0000002600277305ULL, 0x000724000021f000ULL,
0x3fa0000026267823ULL, 0x008fe200000100ffULL, 0x000000270000735dULL, 0x010fe40003800000ULL,
0x00f66c0065277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x008fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018032317810ULL, 0x000fca0007ffe031ULL,
0x0000000130317824ULL, 0x000fca00078e0231ULL, 0x00f0000031277984ULL, 0x000ee80000000800ULL,
0x00f2000031267984ULL, 0x0008620000000800ULL, 0x0000003c2700720bULL, 0x008fe20003f1d000ULL,
0x0000a8f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff537424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000347247811ULL, 0x000fe400078ff0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000472400720cULL, 0x000fe20003f65270ULL, 0x0000a8c27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c2b7209ULL, 0x000fe20007810000ULL,
0x000000804729b824ULL, 0x000fe200078e0232ULL, 0x00000002ff6c7819ULL, 0x000fc60000011648ULL,
0x000000013030b824ULL, 0x000fe200078e0229ULL, 0x0000ffff24297812ULL, 0x000fe200078e3cffULL,
0x8000002b3c257221ULL, 0x000fc60000010000ULL, 0x00f4002b3000b388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x000000292aff7212ULL, 0x000fc6000780c0ffULL,
0x00000025004f7308ULL, 0x000f240000000800ULL, 0x0000004f3b3b7220ULL, 0x010fe20000410000ULL,
0x0000a8527f007947ULL, 0x000fea000b800000ULL, 0x00001f6c4f247589ULL, 0x00872400000e0000ULL,
0x0000002404047220ULL, 0x090fe40000410000ULL, 0x0000002405057220ULL, 0x080fe40000410000ULL,
0x0000002408087220ULL, 0x080fe40000410000ULL, 0x0000002409097220ULL, 0x080fe40000410000ULL,
0x000000240c0c7220ULL, 0x000fc40000410000ULL, 0x000000240d0d7220ULL, 0x080fe40000410000ULL,
0x0000002410107220ULL, 0x080fe40000410000ULL, 0x0000002411117220ULL, 0x080fe40000410000ULL,
0x0000002414147220ULL, 0x080fe40000410000ULL, 0x0000002415157220ULL, 0x080fe40000410000ULL,
0x0000002418187220ULL, 0x000fc40000410000ULL, 0x0000002419197220ULL, 0x080fe40000410000ULL,
0x000000241c1c7220ULL, 0x080fe40000410000ULL, 0x000000241d1d7220ULL, 0x080fe40000410000ULL,
0x0000002420207220ULL, 0x080fe40000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000a7927f007947ULL, 0x000fea000b800000ULL, 0x00001f024f247589ULL, 0x0008e400000e0000ULL,
0x8000002b27270221ULL, 0x000fe20000010000ULL, 0x00000001ff537807ULL, 0x000fe20000000000ULL,
0x0000002406067220ULL, 0x008fc40000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe40000410000ULL,
0x0000002407077220ULL, 0x080fe40000410000ULL, 0x0000002700030308ULL, 0x000ee20000000800ULL,
0x000000240a0a7220ULL, 0x080fe40000410000ULL, 0x000000240b0b7220ULL, 0x080fe40000410000ULL,
0x000000240e0e7220ULL, 0x080fe40000410000ULL, 0x000000240f0f7220ULL, 0x000fc40000410000ULL,
0x0000002412127220ULL, 0x080fe40000410000ULL, 0x0000002413137220ULL, 0x080fe40000410000ULL,
0x0000002416167220ULL, 0x080fe40000410000ULL, 0x0000002417177220ULL, 0x080fe40000410000ULL,
0x000000241a1a7220ULL, 0x080fe40000410000ULL, 0x000000241b1b7220ULL, 0x000fc40000410000ULL,
0x000000241e1e7220ULL, 0x080fe40000410000ULL, 0x000000241f1f7220ULL, 0x080fe40000410000ULL,
0x0000002422227220ULL, 0x080fe40000410000ULL, 0x0000002423237220ULL, 0x000fe40000410000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e002bULL, 0x0000002603260220ULL, 0x00afc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003b263b7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000838247824ULL, 0x000fe200078e00ffULL, 0xfffffff042257812ULL, 0x000fc800078ec0ffULL,
0x0000000824247812ULL, 0x000fca00078e0cffULL, 0x0000000125267824ULL, 0x000fca00078e0224ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x0002e4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x008fe40003800000ULL,
0x00f6ac0026257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6c7819ULL, 0x000fe40000011648ULL,
0x00000003ff26723eULL, 0x000fe400000000ffULL, 0x000000186c247810ULL, 0x040fe40007ffe0ffULL,
0x000000106c257810ULL, 0x000fe40007ffe0ffULL, 0x00005410264f7816ULL, 0x010fe20000000026ULL,
0x0000a4e27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c4f357589ULL, 0x0002e400000e0000ULL,
0x0000a5227f007947ULL, 0x000fea000b800000ULL, 0x00001f024f027589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0025ULL,
0x00007d8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000ac1000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0024ULL,
0x00007de000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000abb000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004b28783bULL, 0x000f680000004200ULL,
0x000000006630783bULL, 0x000fe80000004200ULL, 0x00000000672c783bULL, 0x004ea80000004200ULL,
0x000000004a24783bULL, 0x000f220000004200ULL, 0x00000018ff347819ULL, 0x020fe20000011428ULL,
0x0000010028557824ULL, 0x040fe200078e00ffULL, 0x0000888028547816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fe2000001142aULL,
0x0000010029577824ULL, 0x040fe200078e00ffULL, 0x000088802a5f7816ULL, 0x040fe200000000ffULL,
0x000001002a607824ULL, 0x040fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011457ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe20000011429ULL,
0x000001002e797824ULL, 0x004fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001142bULL,
0x0000010030677824ULL, 0x000fe200078e00ffULL, 0x0000888029587816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x000088802b617816ULL, 0x000fe200000000ffULL,
0x0000002800577306ULL, 0x0005e20000200c00ULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff4d7819ULL, 0x000fe2000001142cULL, 0x0000002a00637306ULL, 0x000be20000200c00ULL,
0x000001002b287824ULL, 0x044fe200078e00ffULL, 0x000088802c717816ULL, 0x000fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001142dULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x00000100312a7824ULL, 0x020fe200078e00ffULL, 0x0000002800667306ULL, 0x0005e20000200c00ULL,
0x000088802d737816ULL, 0x000fe400000000ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001142eULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x000088802e787816ULL, 0x040fe200000000ffULL,
0x00000029005e7306ULL, 0x000be20000200c00ULL, 0x0000888031287816ULL, 0x004fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc40000011430ULL,
0x00000018ff527819ULL, 0x000fe20000011431ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x00000028006b7306ULL, 0x0005e20000200c00ULL,
0x0000888030297816ULL, 0x060fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x012fe40000011432ULL, 0x00000018ff507819ULL, 0x000fe40000011433ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000002b00687306ULL, 0x0003e20000200c00ULL,
0x0000010032287824ULL, 0x004fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000029006a7306ULL, 0x0005e20000200c00ULL, 0x00000100332b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000018ff4a7819ULL, 0x000fe40000011425ULL,
0x00000018ff2b7819ULL, 0x000fc4000001142bULL, 0x00000028006e7306ULL, 0x0003e20000200c00ULL,
0x0000888032297816ULL, 0x044fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fc80000011479ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002a006c7306ULL, 0x0005220000200c00ULL, 0x000001002c287824ULL, 0x042fe400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011428ULL,
0x000001002d287824ULL, 0x000fe200078e00ffULL, 0x00000029006d7306ULL, 0x000e620000200c00ULL,
0x00008880332a7816ULL, 0x004fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011428ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002a006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x000054106b6b7816ULL, 0x010fca000000006cULL, 0x0000002b00707306ULL, 0x0005220000200c00ULL,
0x000054106d6e7816ULL, 0x002fce000000006eULL, 0x0000007500767306ULL, 0x0003e20000200c00ULL,
0x00a800000028783bULL, 0x00456e0000000200ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x0000991053757816ULL, 0x002fe200000000ffULL, 0x000001002f007824ULL, 0x004fe200078e00ffULL,
0x000054106f6f7816ULL, 0x010fc40000000070ULL, 0x000000ff7500720cULL, 0x000fc60003f05270ULL,
0x0000005800587306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x008fce0000000055ULL, 0x0000002c00747306ULL, 0x0005e20000200c00ULL,
0x0000541058557816ULL, 0x002fe20000000059ULL, 0x0000003528288232ULL, 0x0a0fe20000000000ULL,
0x000088802f2c7816ULL, 0x004fe200000000ffULL, 0x000000352a2a8232ULL, 0x000fc80000000000ULL,
0x0000004c00657306ULL, 0x0003e20000200c00ULL, 0x0000000229298232ULL, 0x080fe40000000000ULL,
0x000000022b2b8232ULL, 0x000fca0000000000ULL, 0x0000002c00537306ULL, 0x0005e20000200c00ULL,
0x00000018ff4c7819ULL, 0x002fe2000001142fULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x000000542804723cULL, 0x040fe80000001804ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d00777306ULL, 0x0003e20000200c00ULL, 0x00008880242c7816ULL, 0x004fe400000000ffULL,
0x0000006e281c723cULL, 0x000fe6000000181cULL, 0x000000ffff547224ULL, 0x000fc400078e002cULL,
0x00000100242c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x002fe20000011400ULL,
0x0000002f007b7306ULL, 0x000fe60000200c00ULL, 0x00000018ff557819ULL, 0x000fca000001142cULL,
0x0000002d007a7306ULL, 0x000ff00000200c00ULL, 0x0000002e00007306ULL, 0x0003f00000200c00ULL,
0x0000003400567306ULL, 0x0004e20000200c00ULL, 0x00a80000492c783bULL, 0x002e6e0000000200ULL,
0x00000036005d7306ULL, 0x0009620000200c00ULL, 0x00000018ff347819ULL, 0x004fce0000011426ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000541057567816ULL, 0x008fe40000000056ULL,
0x00000018ff367819ULL, 0x010fe20000011424ULL, 0x0001000024247824ULL, 0x000fc800078e00ffULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000054105e577816ULL, 0x020fe4000000005dULL,
0x00000018ff247819ULL, 0x000fca0000011424ULL, 0x0000003000307306ULL, 0x000ea20000200c00ULL,
0x000000562808723cULL, 0x000fee0000001808ULL, 0x0000003100317306ULL, 0x000ee20000200c00ULL,
0x0000888025567816ULL, 0x040fe200000000ffULL, 0x0000010025577824ULL, 0x040fe200078e00ffULL,
0x000000352c2c8232ULL, 0x082fe20000000000ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x000000352e2e8232ULL, 0x000fc40000000000ULL, 0x000000022d2d8232ULL, 0x080fe20000000000ULL,
0x0000003700627306ULL, 0x0003220000200c00ULL, 0x0000541030307816ULL, 0x004fe20000000051ULL,
0x000000022f2f8232ULL, 0x000fe20000000000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000888027027816ULL, 0x000fe200000000ffULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000541031317816ULL, 0x008fc40000000052ULL,
0x00000018ff377819ULL, 0x002fca0000011427ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x0000541063627816ULL, 0x010fe20000000062ULL, 0x000000302818723cULL, 0x000fe20000001818ULL,
0x0000541068637816ULL, 0x000fca0000000065ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000010026307824ULL, 0x000fe200078e00ffULL, 0x000000622810723cULL, 0x000fe80000001810ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000006000607306ULL, 0x000e700000200c00ULL,
0x0000006100617306ULL, 0x000eb00000200c00ULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x000054105f607816ULL, 0x002fce0000000060ULL, 0x0000003200327306ULL, 0x000e620000200c00ULL,
0x0000541061617816ULL, 0x004fce0000000066ULL, 0x0000003300337306ULL, 0x000ea20000200c00ULL,
0x000054106a6a7816ULL, 0x008fe20000000067ULL, 0x00000060280c723cULL, 0x040fec000000180cULL,
0x0000002400497306ULL, 0x0007e20000200c00ULL, 0x0000541032327816ULL, 0x002fe2000000004fULL,
0x0000006a2814723cULL, 0x000fe20000001814ULL, 0x0000541033337816ULL, 0x004fca0000000050ULL,
0x0000002500317306ULL, 0x0003e20000200c00ULL, 0x0000888026247816ULL, 0x048fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x000000322820723cULL, 0x000fe80000001820ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400357306ULL, 0x0005e20000200c00ULL,
0x0001000027257824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011425ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000010027247824ULL, 0x004fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000004c004c7306ULL, 0x000e700000200c00ULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000054107b257816ULL, 0x002fce000000004cULL, 0x0000007900797306ULL, 0x000e700000200c00ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x0000541078787816ULL, 0x002fc40000000079ULL, 0x0000541053797816ULL, 0x000fca000000007aULL,
0x0000003000307306ULL, 0x000e640000200c00ULL, 0x000000782c0c723cULL, 0x000fec000000180cULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x0000541054547816ULL, 0x004fce0000000055ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541035307816ULL, 0x002fce0000000030ULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0000541074747816ULL, 0x008fce000000004dULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x0000541077757816ULL, 0x004fce000000004eULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x000000742c08723cULL, 0x000fee0000001808ULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000007200727306ULL, 0x000e700000200c00ULL,
0x0000007300737306ULL, 0x000eb00000200c00ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000541071727816ULL, 0x002fce0000000072ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x0000541073737816ULL, 0x004fce0000000076ULL, 0x0000000200027306ULL, 0x000fe20000200c00ULL,
0x000000722c04723cULL, 0x000fee0000001804ULL, 0x0000002400297306ULL, 0x0005e20000200c00ULL,
0x0000541056557816ULL, 0x002fce0000000057ULL, 0x0000002600277306ULL, 0x000e620000200c00ULL,
0x0000541000247816ULL, 0x004fe2000000004bULL, 0x000000542c14723cULL, 0x040fec0000001814ULL,
0x0000002800287306ULL, 0x000ea40000200c00ULL, 0x000000242c10723cULL, 0x000fe20000001810ULL,
0x0000541027347816ULL, 0x002fcc0000000034ULL, 0x0000541031257816ULL, 0x000fe4000000004aULL,
0x0000541049247816ULL, 0x000fe40000000036ULL, 0x0000541002317816ULL, 0x000fe40000000029ULL,
0x0000541028357816ULL, 0x004fc60000000037ULL, 0x000000242c18723cULL, 0x040ff00000001818ULL,
0x000000302c1c723cULL, 0x040ff0000000181cULL, 0x000000342c20723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003a247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0005cff7f8cULL, 0x0007e2000c80043fULL, 0x000000015a537824ULL, 0x000fe200078e025bULL,
0x00000001384c7812ULL, 0x000fc400078ec0ffULL, 0x0000030046467a10ULL, 0x014fc80007ffe0ffULL,
0x000000434600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff819000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff317224ULL, 0x000fe400078e0022ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0020ULL,
0x000000ffff2d7224ULL, 0x000fe400078e001eULL, 0x000000ffff2b7224ULL, 0x000fe400078e001cULL,
0x000000ffff277224ULL, 0x000fe400078e0018ULL, 0x000000ffff307224ULL, 0x000fc400078e0023ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0021ULL, 0x000000ffff2c7224ULL, 0x000fe400078e001fULL,
0x000000ffff2a7224ULL, 0x000fe400078e001dULL, 0x000000ffff287224ULL, 0x000fe400078e001bULL,
0x000000ffff297224ULL, 0x000fe400078e001aULL, 0x000000ffff267224ULL, 0x000fe200078e0019ULL,
0x0000000443007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff247224ULL, 0x000fc400078e0017ULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff207224ULL, 0x000fe400078e0013ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000fULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff257224ULL, 0x000fc400078e0016ULL,
0x000000ffff237224ULL, 0x000fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff197224ULL, 0x000fe400078e000cULL, 0x000000ffff1a7224ULL, 0x000fc400078e000bULL,
0x000000ffff1b7224ULL, 0x000fe400078e000aULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff157224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0007ULL,
0x000000ffff117224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0005ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0004ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x018000003b007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x00008fd000047802ULL, 0x000fe40000000f00ULL,
0x0000981000007944ULL, 0x02afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003b00007308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x00cfc8000000003bULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x010fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000000d000d7220ULL, 0x044fe40000410000ULL,
0x0000000f000f7220ULL, 0x040fe40000410000ULL, 0x0000001500157220ULL, 0x040fe40000410000ULL,
0x0000001700177220ULL, 0x000fc40000410000ULL, 0x0000001900197220ULL, 0x040fe40000410000ULL,
0x0000001800187220ULL, 0x040fe40000410000ULL, 0x0000001f001f7220ULL, 0x040fe40000410000ULL,
0x0000001e001e7220ULL, 0x040fe40000410000ULL, 0x0000002300237220ULL, 0x040fe40000410000ULL,
0x0000002200227220ULL, 0x000fc40000410000ULL, 0x0000002700277220ULL, 0x040fe40000410000ULL,
0x0000002600267220ULL, 0x040fe40000410000ULL, 0x0000002b002b7220ULL, 0x040fe40000410000ULL,
0x0000002a002a7220ULL, 0x040fe40000410000ULL, 0x0000002f002f7220ULL, 0x040fe40000410000ULL,
0x0000002e002e7220ULL, 0x000fc40000410000ULL, 0x0000001104117220ULL, 0x048fe40000410000ULL,
0x0000001304137220ULL, 0x040fe40000410000ULL, 0x0000001b041b7220ULL, 0x040fe40000410000ULL,
0x0000001a041a7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x000fc40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x000fc40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002c042c7220ULL, 0x040fe40000410000ULL, 0x0000003104317220ULL, 0x040fe40000410000ULL,
0x0000003004307220ULL, 0x000fe40000410000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x00cfc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000402077811ULL, 0x000fe400078ff8ffULL, 0x0000000800167811ULL, 0x000fe400078ff0ffULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x00000006020a7811ULL, 0x000fc400078ff8ffULL,
0x0000000703027812ULL, 0x100fe400078e780eULL, 0x0000000707097812ULL, 0x040fe400078e780eULL,
0x0000000707077812ULL, 0x000fe200078e7816ULL, 0x000000080e067824ULL, 0x000fe200078e0202ULL,
0x0000000703037812ULL, 0x000fe200078e7816ULL, 0x0000100040027824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e780eULL, 0x0000000816147824ULL, 0x000fe200078e0207ULL,
0x000000070a0b7812ULL, 0x000fe200078e780eULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e7816ULL, 0x0000000816107824ULL, 0x000fe200078e0203ULL,
0x000000070a0a7812ULL, 0x000fe200078e7816ULL, 0x000008003f037824ULL, 0x000fe200078e0202ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x000000080e087824ULL, 0x040fe200078e0205ULL,
0x000000151705723eULL, 0x000fe200000000ffULL, 0x000000080e0c7824ULL, 0x000fc400078e0209ULL,
0x0000000816127824ULL, 0x000fe200078e0204ULL, 0x0000000d0f04723eULL, 0x000fe200000000ffULL,
0x000000080e0e7824ULL, 0x000fe400078e020bULL, 0x0000000816167824ULL, 0x000fe400078e020aULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x00000010080a7824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x000fc400078e0203ULL, 0x0000001010107824ULL, 0x100fe400078e0203ULL,
0x0000001012127824ULL, 0x100fe400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001014147824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x000fe400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000191806723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000541004187816ULL, 0x140fe20000000005ULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x000000232204723eULL, 0x000fe200000000ffULL,
0x0000000107127824ULL, 0x040fe200078e0212ULL, 0x000000272605723eULL, 0x000fe200000000ffULL,
0x00000001070e7824ULL, 0x040fe200078e020eULL, 0x0000001808007388ULL, 0x0005e20000000a00ULL,
0x0000000107147824ULL, 0x000fc400078e0214ULL, 0x0000000107167824ULL, 0x000fe200078e0216ULL,
0x0000001f1e07723eULL, 0x000fe200000000ffULL, 0x000000203f0b7824ULL, 0x000fc600078e0200ULL,
0x0000763206097816ULL, 0x140fe40000000007ULL, 0x0000541006087816ULL, 0x004fe40000000007ULL,
0x0000002b2a06723eULL, 0x000fe400000000ffULL, 0x0000002f2e07723eULL, 0x000fe200000000ffULL,
0x000000080a007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x144fe20000000005ULL,
0x000000100b0a7824ULL, 0x000fe200078e0202ULL, 0x0000763204097816ULL, 0x000fc40000000005ULL,
0x000000111304723eULL, 0x000fe400000000ffULL, 0x0000001b1a05723eULL, 0x000fe200000000ffULL,
0x000000080c007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000001d1c06723eULL, 0x000fe400000000ffULL,
0x000000212007723eULL, 0x000fe200000000ffULL, 0x000000080e007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x004fc40000000005ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000000252404723eULL, 0x000fe400000000ffULL, 0x000000292805723eULL, 0x000fe200000000ffULL,
0x0000000810007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000002d2c06723eULL, 0x000fc400000000ffULL,
0x000000313007723eULL, 0x000fe200000000ffULL, 0x0000000812007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x144fe40000000005ULL, 0x0000763204097816ULL, 0x000fca0000000005ULL,
0x0000000814007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000816007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000400000a107984ULL, 0x000ea80000000c00ULL,
0x000c00000a187984ULL, 0x000ee80000000c00ULL, 0x000000000a047984ULL, 0x000f280000000c00ULL,
0x000800000a0c7984ULL, 0x000e620000000c00ULL, 0x200000ff10107230ULL, 0x004fc40000000000ULL,
0x200000ff13137230ULL, 0x000fe40000000000ULL, 0x0000001810107230ULL, 0x008fe20000000000ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff07077230ULL, 0x010fe40000000000ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fc40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x0000000f07077230ULL, 0x002fe40000000000ULL, 0x0000000e06067230ULL, 0x000fe40000000000ULL,
0x0000000d05057230ULL, 0x000fe40000000000ULL, 0x0000000c04047230ULL, 0x000fc40000000000ULL,
0x0000001b13137230ULL, 0x000fe40000000000ULL, 0x0000001a12127230ULL, 0x000fe20000000000ULL,
0x000000040a007388ULL, 0x0003e20000000c00ULL, 0x0000001911117230ULL, 0x000fca0000000000ULL,
0x000400100a007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f3000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ea20000002700ULL,
0x0000580018047a24ULL, 0x002fe200078e02ffULL, 0x000000013fff7812ULL, 0x000fe2000780f847ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x0000660004077a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x0000040040067824ULL, 0x000fe200078e00ffULL, 0x000000000a147984ULL, 0x0002e20000000c00ULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x000058000e0e7a24ULL, 0x004fe200078e0205ULL,
0x000007ff07057811ULL, 0x000fc400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x000003000e047a24ULL, 0x000fca00078e02ffULL, 0x0000000404107c10ULL, 0x000fc8000fffe0ffULL,
0x0000001005087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000006080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x000fe200078e0207ULL,
0x00000070080f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c09117812ULL, 0x000fe200078ec0ffULL,
0x00006c0010087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007a1e00fULL, 0x0000000a110a7210ULL, 0x000fe40007c7e00fULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000003c08007986ULL, 0x0003e8000c101906ULL, 0x0000003b0a007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x000000140c007986ULL, 0x0003e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff180b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000ee40000000000ULL,
0x000000ff0800720cULL, 0x008fda0003f05270ULL, 0x00002b8000008947ULL, 0x000fea0003800000ULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff177424ULL, 0x002fe200078e00ffULL, 0x00000001040a7810ULL, 0x004fe40007ffe0ffULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a190981ULL, 0x000368000c1e1900ULL, 0x0000000718087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x004fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e000cULL, 0x000000080b0e7824ULL, 0x040fe200078e00ffULL,
0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000a0b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e097810ULL, 0x040fe40007ffe0ffULL, 0x000000010e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e097810ULL, 0x042fe40007ffe0ffULL,
0x000000020e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000030e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e097810ULL, 0x042fe40007ffe0ffULL,
0x000000040e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000050e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e097810ULL, 0x042fe40007ffe0ffULL,
0x000000060e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000150c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000070e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000170c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e097810ULL, 0x002fe40007ffe0ffULL,
0x000000190c0c7209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e197812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007a3e019ULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x0000000608197981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000087824ULL, 0x006fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011600ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0208ULL,
0x0000000c09007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000097824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x000000013f107824ULL, 0x000fe200078e0204ULL, 0x00000002ff0c7819ULL, 0x000fe20000011647ULL,
0x00000800ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000070090a7812ULL, 0x004fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000020047477824ULL, 0x000fe200078e00ffULL, 0x0000001005087211ULL, 0x000fe200078fa8ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0202ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000010b307824ULL, 0x000fe200078e020aULL, 0x000000010c0a7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fe200078e000dULL, 0x0000109000007945ULL, 0x000fe20003800000ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000023f0b8824ULL, 0x140fe200078e0240ULL, 0x0000000608087210ULL, 0x000fe20007f3e0ffULL,
0x000000023f0d8824ULL, 0x000fe200078e0240ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000020b158824ULL, 0x100fe200078e020aULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000020d178824ULL, 0x000fe200078e020aULL, 0x00000800470a7812ULL, 0x000fe200078ec0ffULL,
0x00000001070e8824ULL, 0x000fe200078e0210ULL, 0x00000020000d7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x000000013d0b7824ULL, 0x000fe200078e020aULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000003003f007a0cULL, 0x000fe20003f26070ULL,
0x00006c000e0e8625ULL, 0x000fe200078e000fULL, 0x0000000000267805ULL, 0x000fc6000001ff00ULL,
0x00006c0010108625ULL, 0x000fc800078e0011ULL, 0x0000000815158824ULL, 0x100fe400078e0200ULL,
0x0000000817178824ULL, 0x000fe400078e0200ULL, 0x0000001000137824ULL, 0x040fe200078e020bULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00000010000a7825ULL, 0x000fe200078e0008ULL,
0x0000418017178811ULL, 0x000fc600078e20ffULL, 0x000000100d0c7825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000010000e8825ULL, 0x040fe200078e000eULL,
0x003800000c137faeULL, 0x0007e6000b901c46ULL, 0x0000001000108825ULL, 0x000fe200078e0010ULL,
0x000000000e158faeULL, 0x0009e6000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000010178faeULL, 0x0003e2000b901c46ULL, 0x00000000000a7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e003fULL,
0x0000000232337810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00000001042e7824ULL, 0x100fe200078e0233ULL,
0x00000001ff287819ULL, 0x000fe20000011633ULL, 0x00000800ff347424ULL, 0x000fe200078e00ffULL,
0x0000002000397810ULL, 0x000fe20007ffe0ffULL, 0x00000400332a7824ULL, 0x000fe200078e00ffULL,
0x0000002e05297211ULL, 0x000fe400078fa8ffULL, 0x00000001282c7812ULL, 0x000fc600078ec0ffULL,
0x00006c0029287625ULL, 0x000fc800078e0034ULL, 0x000000023f379824ULL, 0x140fe200078e0240ULL,
0x0000000628287210ULL, 0x000fe20007f1e0ffULL, 0x000000023f2d9824ULL, 0x000fe400078e0240ULL,
0x0000000237379824ULL, 0x100fe400078e022cULL, 0x000000022d3b9824ULL, 0x000fe200078e022cULL,
0x000008002a2c7812ULL, 0x000fe200078ec0ffULL, 0x00000001072b9824ULL, 0x000fe400078e022eULL,
0x00000080ff349424ULL, 0x000fc400078e00ffULL, 0x00000080ff2f9424ULL, 0x000fe400078e00ffULL,
0x00006c002b2a9625ULL, 0x000fc800078e0034ULL, 0x000000013d2d7824ULL, 0x000fe400078e022cULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x00006c002e2e9625ULL, 0x000fc800078e002fULL,
0x0000001000357824ULL, 0x040fe400078e022dULL, 0x0000000837379824ULL, 0x000fe400078e0200ULL,
0x00000010002c9825ULL, 0x000fc600078e002aULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x000000083b3b9824ULL, 0x000fe400078e0200ULL, 0x00000010392a7825ULL, 0x000fc600078e0028ULL,
0x000041803b399811ULL, 0x000fe200078e20ffULL, 0x0000001000287825ULL, 0x000fc800078e0028ULL,
0x00000010002e9825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000028357faeULL, 0x0003e8000b901c46ULL, 0x003800002a357faeULL, 0x0003e8000b901c46ULL,
0x000000002c379faeULL, 0x0003e8000b901c46ULL, 0x000000002e399faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e0032ULL, 0x00000001ff2a7819ULL, 0x000fe20000011600ULL,
0x000000023f2b7824ULL, 0x000fe200078e0240ULL, 0x00000002ff357819ULL, 0x000fe20000011600ULL,
0x000000402d287824ULL, 0x000fe200078e00ffULL, 0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001000297824ULL, 0x000fe200078e00ffULL, 0x0000000735387812ULL, 0x040fe200078ec0ffULL,
0x00000008352f7824ULL, 0x040fe200078e00ffULL, 0x0000008028287812ULL, 0x000fe200078ec0ffULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0x0000007029297812ULL, 0x000fc400078ec0ffULL,
0x00000035ff3a7212ULL, 0x000fe200078e33ffULL, 0x000001002b287824ULL, 0x000fc600078e0028ULL,
0xfffffff8373a7812ULL, 0x000fe400078ee23aULL, 0x000000282a2a7210ULL, 0x000fe20007ffe029ULL,
0x0000000835297824ULL, 0x000fe200078e00ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee238ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002a2b7984ULL, 0x000e620000000800ULL,
0x00000001292c7812ULL, 0x140fe400078ef638ULL, 0x00000002292e7812ULL, 0x140fe200078ef638ULL,
0x004580002a4c7984ULL, 0x0004e20000000800ULL, 0x0000000329327812ULL, 0x140fe400078ef638ULL,
0x0000000429347812ULL, 0x140fe400078ef638ULL, 0x0000000529367812ULL, 0x140fe400078ef638ULL,
0x0000000629387812ULL, 0x000fe200078ef638ULL, 0x000004002d297824ULL, 0x000fe200078e00ffULL,
0x0000000835377810ULL, 0x000fc80007ffe0ffULL, 0x00000800292a7812ULL, 0x004fe200078ec0ffULL,
0x00000008373e7824ULL, 0x040fe200078e00ffULL, 0x00000007372d7812ULL, 0x040fe200078ec0ffULL,
0x00000008373c7824ULL, 0x000fe200078e00ffULL, 0x000001803d297810ULL, 0x000fe20007ffe02aULL,
0x0000000837397824ULL, 0x000fe200078e00ffULL, 0xfffffff83e2a7812ULL, 0x100fe400078ee22dULL,
0x000000013c3e7812ULL, 0x000fe200078ef62dULL, 0x0000001028287824ULL, 0x000fe200078e0229ULL,
0x000000023c427812ULL, 0x000fe200078ef62dULL, 0x000000102c2c7824ULL, 0x000fe200078e0229ULL,
0x000000033c447812ULL, 0x000fe200078ef62dULL, 0x0000001032327824ULL, 0x000fe200078e0229ULL,
0x000000043c467812ULL, 0x000fe200078ef62dULL, 0x0000001036367824ULL, 0x000fe200078e0229ULL,
0x000000053c487812ULL, 0x000fe200078ef62dULL, 0x0000001034347824ULL, 0x000fe200078e0229ULL,
0x000000063c3c7812ULL, 0x000fe200078ef62dULL, 0x0000001038387824ULL, 0x100fe200078e0229ULL,
0x00000037ff4a7212ULL, 0x000fe200078e33ffULL, 0x000000102a2a7824ULL, 0x000fc400078e0229ULL,
0x0000002b302b7221ULL, 0x002fe20000010100ULL, 0xfffffff8394a7812ULL, 0x000fe200078ee24aULL,
0x000000103e3e7824ULL, 0x100fe400078e0229ULL, 0x3fb8aa3b2b2f7820ULL, 0x000fe40000410000ULL,
0x00000004002b7824ULL, 0x000fe400078e00ffULL, 0x0000001042427824ULL, 0x100fe400078e0229ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x0000000c2b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000001044447824ULL, 0x000fc400078e0229ULL, 0x000000103a3a7824ULL, 0x000fe400078e0229ULL,
0x0000000128287824ULL, 0x000fe400078e022bULL, 0x000000012b2c7824ULL, 0x040fe400078e022cULL,
0x000000012b327824ULL, 0x040fe400078e0232ULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b367824ULL, 0x040fe400078e0236ULL, 0x000000012b347824ULL, 0x000fe200078e0234ULL,
0x000000002c2c7984ULL, 0x000fe20000000800ULL, 0x0000004c2f507220ULL, 0x008fc40000410000ULL,
0x000000012b387824ULL, 0x040fe200078e0238ULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x000000012b2a7824ULL, 0x040fe400078e022aULL, 0x000000012b3e7824ULL, 0x040fe200078e023eULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x000000012b427824ULL, 0x040fe400078e0242ULL,
0x000000012b447824ULL, 0x000fe200078e0244ULL, 0x00001f35502d7589ULL, 0x000ea200000e0000ULL,
0x0000001046467824ULL, 0x000fc400078e0229ULL, 0x0000001048487824ULL, 0x100fe200078e0229ULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x000000012b3a7824ULL, 0x040fe400078e023aULL,
0x000000012b467824ULL, 0x040fe200078e0246ULL, 0x0000000038387984ULL, 0x000f220000000800ULL,
0x000000012b487824ULL, 0x000fe400078e0248ULL, 0x000000102e2e7824ULL, 0x100fe200078e0229ULL,
0x000000002a2a7984ULL, 0x000f220000000800ULL, 0x000000103c3c7824ULL, 0x000fc400078e0229ULL,
0x000000104a4a7824ULL, 0x000fe200078e0229ULL, 0x000000003e3e7984ULL, 0x000f220000000800ULL,
0x000000012b2e7824ULL, 0x040fe400078e022eULL, 0x000000012b3c7824ULL, 0x040fe200078e023cULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x000000012b4a7824ULL, 0x000fe400078e024aULL,
0x0000003150317221ULL, 0x000fe20000010000ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x20000028ff4c7230ULL, 0x002fc40000004100ULL, 0x30000028ff287230ULL, 0x000fe20000004100ULL,
0x000000003a3a7984ULL, 0x000e640000000800ULL, 0x0000002d4c277223ULL, 0x084fe40000010027ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000002d28267223ULL, 0x000fe20000010026ULL,
0x2000002cff287230ULL, 0x100fe40000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x3000002cff2c7230ULL, 0x000fc40000004100ULL, 0x0000002d28257223ULL, 0x080fe20000010025ULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x20000032ff287230ULL, 0x100fe20000004100ULL,
0x0000002d2c247223ULL, 0x080fe20000010024ULL, 0x30000032ff327230ULL, 0x000fe20000004100ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x20000034ff2c7230ULL, 0x008fe20000004100ULL,
0x0000002d28217223ULL, 0x080fe20000010021ULL, 0x20000036ff287230ULL, 0x000fe20000004100ULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x0000002d32207223ULL, 0x080fe20000010020ULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x0000002d2c1f7223ULL, 0x080fe2000001001fULL,
0x00001f3750297589ULL, 0x000ea200000e0000ULL, 0x0000002d281d7223ULL, 0x080fe2000001001dULL,
0x20000038ff287230ULL, 0x010fe20000004100ULL, 0x000000ffff327224ULL, 0x000fe200078e0033ULL,
0x2000002aff2c7230ULL, 0x100fe20000004100ULL, 0x0000002d341e7223ULL, 0x080fe2000001001eULL,
0x3000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000002d281b7223ULL, 0x000fe2000001001bULL,
0x2000003eff287230ULL, 0x000fe20000004100ULL, 0x0000030032007a0cULL, 0x000fe20003f06070ULL,
0x30000036ff367230ULL, 0x000fc40000004100ULL, 0x30000038ff387230ULL, 0x000fe40000004100ULL,
0x3000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000002d361c7223ULL, 0x080fe2000001001cULL,
0x2000003aff4e7230ULL, 0x102fe20000004100ULL, 0x0000002d381a7223ULL, 0x000fe2000001001aULL,
0x3000003aff3a7230ULL, 0x000fc60000004100ULL, 0x0000002d4e197223ULL, 0x080fe40000010019ULL,
0x0000002d3a187223ULL, 0x000fe40000010018ULL, 0x000000292a167223ULL, 0x084fe20000010016ULL,
0x20000042ff2a7230ULL, 0x000fe20000004100ULL, 0x0000002928157223ULL, 0x080fe20000010015ULL,
0x20000044ff287230ULL, 0x000fe20000004100ULL, 0x000000292c177223ULL, 0x080fe20000010017ULL,
0x2000002eff3a7230ULL, 0x000fe20000004100ULL, 0x000000292a137223ULL, 0x080fe20000010013ULL,
0x20000048ff2a7230ULL, 0x000fe20000004100ULL, 0x0000002928117223ULL, 0x000fe20000010011ULL,
0x20000046ff287230ULL, 0x000fe20000004100ULL, 0x0000002d3a237223ULL, 0x000fe20000010023ULL,
0x3000002eff2e7230ULL, 0x000fe20000004100ULL, 0x000000292a0d7223ULL, 0x080fe2000001000dULL,
0x2000004aff2a7230ULL, 0x000fe20000004100ULL, 0x00000029280f7223ULL, 0x000fe2000001000fULL,
0x2000003cff287230ULL, 0x000fe20000004100ULL, 0x0000002d2e227223ULL, 0x000fe20000010022ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x000000293e147223ULL, 0x080fe20000010014ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x00000029280b7223ULL, 0x080fe2000001000bULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000002942127223ULL, 0x080fe20000010012ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000002944107223ULL, 0x080fe20000010010ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000029460e7223ULL, 0x080fe2000001000eULL,
0x3000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000029480c7223ULL, 0x000fc4000001000cULL,
0x000000293c0a7223ULL, 0x080fe4000001000aULL, 0x000000292a097223ULL, 0x080fe40000010009ULL,
0x000000294a087223ULL, 0x000fe20000010008ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff4000720cULL, 0x000fe20003f05270ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c00057812ULL, 0x000fca00078ec0ffULL, 0x0000000105067824ULL, 0x000fe200078e0204ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004007812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc600078ec0ffULL,
0x000000803f007824ULL, 0x000fc800078e0200ULL, 0x0000000105007824ULL, 0x000fca00078e0200ULL,
0x0049803100007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800006007984ULL, 0x002e680000000800ULL,
0x004a000006057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0000ULL, 0x0000be5000047802ULL, 0x000fe40000000f00ULL,
0x0000699000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff077819ULL, 0x004fe40000011600ULL, 0x00000008003e7811ULL, 0x000fc600078ff0ffULL,
0x00001f0704057589ULL, 0x000ea200000e0000ULL, 0x0000003eff427212ULL, 0x000fe200078e33ffULL,
0x000000083e297824ULL, 0x000fe400078e00ffULL, 0x00001f3e04067589ULL, 0x00072600000e0000ULL,
0xfffffff829427812ULL, 0x000fca00078ee242ULL, 0x0000001042427824ULL, 0x000fe200078e0203ULL,
0x00000007ff047212ULL, 0x008fe200078e33ffULL, 0x0000002705277220ULL, 0x044fe40000410000ULL,
0x0000002605267220ULL, 0x040fe40000410000ULL, 0x0000002505257220ULL, 0x040fe40000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000002305237220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002105217220ULL, 0x040fe40000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000001d051d7220ULL, 0x000fc40000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000001905197220ULL, 0x040fe40000410000ULL,
0x0000001805187220ULL, 0x000fe20000410000ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000000807057824ULL, 0x000fc400078e00ffULL, 0x0000001706177220ULL, 0x010fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0xfffffff805447812ULL, 0x000fe200078ee204ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000000707057812ULL, 0x000fe200078ec0ffULL, 0x0000001406147220ULL, 0x000fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000000205287812ULL, 0x040fe200078e3cffULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x00000003052a7812ULL, 0x040fe200078e3cffULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x00000004052c7812ULL, 0x040fe200078e3cffULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x00000005052e7812ULL, 0x040fe200078e3cffULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000605307812ULL, 0x000fe200078e3cffULL, 0x0000000e060e7220ULL, 0x000fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x0000000d060d7220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000c060c7220ULL, 0x000fe20000410000ULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x000fe20000410000ULL,
0x000000073e0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000a060a7220ULL, 0x000fe20000410000ULL,
0x0000000d0c0c723eULL, 0x000fe200000000ffULL, 0x0000000906097220ULL, 0x040fe20000410000ULL,
0x000000050f0d7812ULL, 0x000fe200078e3cffULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0x0000000105087812ULL, 0x000fe200078e3cffULL, 0x0000000807047824ULL, 0x040fe200078e00ffULL,
0x0000000b0a0a723eULL, 0x000fe200000000ffULL, 0x0000000807287824ULL, 0x040fe200078e0228ULL,
0x000000090606723eULL, 0x000fe200000000ffULL, 0x000000083e097824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee207ULL, 0x0000000807087824ULL, 0x000fe200078e0208ULL,
0x000000010f057812ULL, 0x000fe200078e3cffULL, 0x00000008072a7824ULL, 0x000fe200078e022aULL,
0xfffffff809327812ULL, 0x000fe200078ee23eULL, 0x00000008072c7824ULL, 0x000fe200078e022cULL,
0x000000030f097812ULL, 0x000fe200078e3cffULL, 0x00000008072e7824ULL, 0x000fe200078e022eULL,
0x000000040f0b7812ULL, 0x000fe200078e3cffULL, 0x0000000807307824ULL, 0x000fe200078e0230ULL,
0x000000020f077812ULL, 0x040fe200078e3cffULL, 0x0000000400117824ULL, 0x000fe200078e00ffULL,
0x000000060f0f7812ULL, 0x000fe200078e3cffULL, 0x000000083e347824ULL, 0x000fe200078e0205ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x000000083e367824ULL, 0x040fe200078e0207ULL,
0x0000000c111d7812ULL, 0x000fe200078ec0ffULL, 0x000000083e387824ULL, 0x000fc400078e0209ULL,
0x000000083e3a7824ULL, 0x040fe400078e020bULL, 0x000000083e3c7824ULL, 0x040fe400078e020dULL,
0x000000083e3e7824ULL, 0x000fe400078e020fULL, 0x0000001004047824ULL, 0x100fe400078e0203ULL,
0x0000001044077824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x0000001028287824ULL, 0x100fe400078e0203ULL, 0x000000102a2a7824ULL, 0x100fe400078e0203ULL,
0x0000001032327824ULL, 0x100fe400078e0203ULL, 0x000000011d057824ULL, 0x000fe400078e0204ULL,
0x000000102c2c7824ULL, 0x100fe400078e0203ULL, 0x000000102e2e7824ULL, 0x100fe200078e0203ULL,
0x0000002605007388ULL, 0x0005e20000000800ULL, 0x0000001030307824ULL, 0x000fc400078e0203ULL,
0x0000001034347824ULL, 0x100fe400078e0203ULL, 0x0000001036367824ULL, 0x100fe400078e0203ULL,
0x0000001038387824ULL, 0x100fe400078e0203ULL, 0x000000103a3a7824ULL, 0x100fe400078e0203ULL,
0x000000103c3c7824ULL, 0x100fe400078e0203ULL, 0x000000103e3e7824ULL, 0x000fc400078e0203ULL,
0x000000011d117824ULL, 0x040fe400078e0207ULL, 0x000000011d037824ULL, 0x040fe400078e0208ULL,
0x000000011d077824ULL, 0x040fe400078e0228ULL, 0x000000011d097824ULL, 0x040fe200078e022aULL,
0x0000002403007388ULL, 0x0007e20000000800ULL, 0x000000011d0b7824ULL, 0x040fe400078e022cULL,
0x000000011d0d7824ULL, 0x040fe200078e022eULL, 0x0000002207007388ULL, 0x000fe20000000800ULL,
0x000000011d0f7824ULL, 0x000fc400078e0230ULL, 0x000000011d137824ULL, 0x040fe200078e0232ULL,
0x0000002009007388ULL, 0x000fe20000000800ULL, 0x000000011d157824ULL, 0x040fe400078e0234ULL,
0x000000011d057824ULL, 0x044fe200078e0236ULL, 0x0000001e0b007388ULL, 0x000fe20000000800ULL,
0x000000011d177824ULL, 0x040fe400078e0238ULL, 0x000000011d197824ULL, 0x040fe200078e023aULL,
0x0000001c0d007388ULL, 0x000fe20000000800ULL, 0x000000011d1f7824ULL, 0x000fc400078e0242ULL,
0x000000011d1b7824ULL, 0x040fe200078e023cULL, 0x0000001a0f007388ULL, 0x000fe20000000800ULL,
0x000000011d1d7824ULL, 0x000fe400078e023eULL, 0x000000203f217824ULL, 0x000fe200078e0200ULL,
0x0000001811007388ULL, 0x000fe60000000800ULL, 0x0000001021037824ULL, 0x008fe200078e0202ULL,
0x0000001613007388ULL, 0x000fe80000000800ULL, 0x0000001415007388ULL, 0x000fe80000000800ULL,
0x0000001205007388ULL, 0x000fe80000000800ULL, 0x0000001017007388ULL, 0x000fe80000000800ULL,
0x0000000e19007388ULL, 0x000fe80000000800ULL, 0x0000000c1b007388ULL, 0x000fe80000000800ULL,
0x0000000a1d007388ULL, 0x000fe80000000800ULL, 0x000000061f007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003207984ULL, 0x000ea80000000c00ULL,
0x0004000003287984ULL, 0x000ee80000000c00ULL, 0x0008000003247984ULL, 0x000f280000000c00ULL,
0x000c0000032c7984ULL, 0x000e620000000c00ULL, 0x200000ff23237230ULL, 0x004fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x008fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fc40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x010fe40000000000ULL,
0x0000002622227230ULL, 0x000fe40000000000ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x002fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0000002003007388ULL, 0x0003e20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fca0000000000ULL,
0x0004002803007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff3f00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000003ff077819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff047819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000707037812ULL, 0x100fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704057812ULL, 0x000fe400078e4811ULL, 0x0ffffff803037812ULL, 0x000fc400078ef800ULL,
0x0ffffff805057812ULL, 0x000fc600078ef811ULL, 0x0000001003037824ULL, 0x100fe400078e0202ULL,
0x0000001005057824ULL, 0x000fc600078e0202ULL, 0x0000000003087984ULL, 0x004ea80000000c00ULL,
0x00000000050c7984ULL, 0x0008a20000000c00ULL, 0x0000000806027824ULL, 0x042fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff802027812ULL, 0x000fc400078ee207ULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x0000000840137824ULL, 0x000fe200078e00ffULL, 0x0000000402077c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x0000000404067c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005a0007027a11ULL, 0x040fe200078040ffULL,
0x000000ffff057224ULL, 0x010fe200008e06ffULL, 0x00005a0006047a11ULL, 0x040fe400078240ffULL,
0x00005b0007037a11ULL, 0x000fe400000f4410ULL, 0xfffffff813077812ULL, 0x000fe400078ee200ULL,
0x00005b0006057a11ULL, 0x000fe400008f4405ULL, 0xfffffff840117812ULL, 0x000fe200078ee211ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x004fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x000fe20000011647ULL,
0xffffffffff007424ULL, 0x002fc800078e00ffULL, 0x0000000246037824ULL, 0x000fca00078e0203ULL,
0x000000440300720cULL, 0x000fda0003f06070ULL, 0x0000000224068824ULL, 0x000fc800078e00ffULL,
0x0000640006068a24ULL, 0x000fc800078e0203ULL, 0x0000600006068625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606008981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082a7981ULL, 0x000762000c1e9900ULL,
0x0000000146027810ULL, 0x000fe20007ffe0ffULL, 0x0000004047257824ULL, 0x000fe400078e00ffULL,
0x0000008027277824ULL, 0x000fe200078e00ffULL, 0x000000430200720cULL, 0x000fe20003f06070ULL,
0x000000803e027824ULL, 0x000fc400078e00ffULL, 0x00000100460b7824ULL, 0x000fca00078e0225ULL,
0x0000004002187812ULL, 0x000fe200078ef80bULL, 0x0000002700217224ULL, 0x004fc800078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011648ULL,
0x0000000b45067217ULL, 0x000fe40007800000ULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d077824ULL, 0x140fe200078e0218ULL, 0x000000181d237810ULL, 0x040fe20007ffe0ffULL,
0x00000001060c7824ULL, 0x000fe200078e0a0bULL, 0x000000101d177810ULL, 0x000fe20007ffe0ffULL,
0x0000000111067824ULL, 0x100fe200078e0218ULL, 0x0000000721077210ULL, 0x000fe20007f1e0ffULL,
0x0000000123087824ULL, 0x000fe200078e0218ULL, 0x000000300e1f7812ULL, 0x000fe200078ec0ffULL,
0x00000004170e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011648ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005e00070a7a11ULL, 0x000fc400078038ffULL,
0x0000000821087210ULL, 0x000fe40007f5e0ffULL, 0x00005f0007167a11ULL, 0x000fe200000f3c16ULL,
0x0000000117077824ULL, 0x000fe200078e0218ULL, 0x0000000621067210ULL, 0x000fe40007f1e0ffULL,
0x000000030d0d7812ULL, 0x000fe400078e4848ULL, 0x0000000721147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0006137a11ULL, 0x000fe200078038ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005e0008107a11ULL, 0x000fe200078438ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005f0006157a11ULL, 0x000fc400000f3c15ULL,
0x00005f0008127a11ULL, 0x000fe200010f3c07ULL, 0x0000000411087824ULL, 0x000fe200078e00ffULL,
0x0000000a1f067210ULL, 0x000fe40007f7e0ffULL, 0x00005e00140b7a11ULL, 0x040fe400078238ffULL,
0x0000000c1d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff077224ULL, 0x000fe200018e0616ULL,
0x00005f0014147a11ULL, 0x000fe200008f3c09ULL, 0x0000000423167824ULL, 0x000fe200078e00ffULL,
0xfffffffc080a7812ULL, 0x000fc400078ee20dULL, 0x00001000470f7811ULL, 0x000fe400078e68ffULL,
0x0000000c1100720cULL, 0x080fe40003f26070ULL, 0x0000001f13087210ULL, 0x000fe20007f7e0ffULL,
0x000000100a137824ULL, 0x000fe200078e020fULL, 0x0ffffffc0d487812ULL, 0x000fe400078ef848ULL,
0x0000000c1700720cULL, 0x000fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee20dULL, 0x0000001048117824ULL, 0x000fe200078e020fULL,
0x000000201d177810ULL, 0x000fc40007ffe0ffULL, 0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000100e157824ULL, 0x000fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x00000001180e7824ULL, 0x000fe200078e0217ULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0614ULL,
0x0000000008137faeULL, 0x0005e2000c901c46ULL, 0x0000000c2300720cULL, 0x000fe40003f86070ULL,
0x0000000e21147210ULL, 0x000fe20007f1e0ffULL, 0x000000000a157faeULL, 0x0007e2000d101c46ULL,
0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL, 0x00005e00140e7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x002fe200000e06ffULL, 0x0000001f10067210ULL, 0x000fe40007fbe0ffULL,
0x000000381d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc16087812ULL, 0x004fe400078ee20dULL,
0x00005f0014147a11ULL, 0x000fe200030f3c07ULL, 0x000000ffff077224ULL, 0x000fe200028e0612ULL,
0x0000000c1700720cULL, 0x080fe20003f66070ULL, 0x0000001008097824ULL, 0x000fe200078e020fULL,
0x0000000c1900720cULL, 0x080fe20003f46070ULL, 0x0000000118087824ULL, 0x040fe200078e0219ULL,
0x0000000c1b00720cULL, 0x080fe20003f26070ULL, 0x00000001180a7824ULL, 0x008fe200078e021bULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x0000000c1d00720cULL, 0x000fe20003f06070ULL,
0x000000041b0c7824ULL, 0x000fe200078e00ffULL, 0x0000000821127210ULL, 0x000fe20007fbe0ffULL,
0x0000000417087824ULL, 0x000fe200078e00ffULL, 0x0000000a21107210ULL, 0x000fe20007f9e0ffULL,
0x00000004190a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee20dULL,
0x000000041d167824ULL, 0x000fe200078e00ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee20dULL,
0x00000001180b7824ULL, 0x000fe200078e021dULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL,
0x000000ffff077224ULL, 0x002fe200028e06ffULL, 0xfffffffc16067812ULL, 0x000fe200078ee20dULL,
0x0000001008117824ULL, 0x100fe200078e020fULL, 0x00005e0012087a11ULL, 0x000fe200078a38ffULL,
0x000000100a137824ULL, 0x100fe200078e020fULL, 0x0000000b210b7210ULL, 0x000fe20007fde0ffULL,
0x000000100c157824ULL, 0x000fe200078e020fULL, 0x00005f0012127a11ULL, 0x000fe200028f3c07ULL,
0x00000010060f7824ULL, 0x000fe200078e020fULL, 0x0000001f0e067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e06ffULL, 0x00005e00100a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x00005e000b0c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200028e0614ULL, 0x0000001f08087210ULL, 0x000fc40007fbe0ffULL,
0x00005f0010107a11ULL, 0x000fe400020f3c09ULL, 0x0000001f0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0612ULL, 0x00005f000b0d7a11ULL, 0x000fe200030f3c0eULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400020e0610ULL, 0x0000000008137faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc400028e060dULL, 0x000000000a157faeULL, 0x0003e8000c901c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001848067211ULL, 0x04afe400078ff0ffULL, 0x0000000848177811ULL, 0x040fe400078ff0ffULL,
0x0000000621067210ULL, 0x000fe40007f1e0ffULL, 0x00000020480b7811ULL, 0x000fc400078ff0ffULL,
0x0000003048107811ULL, 0x000fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0006267a11ULL, 0x000fe200078038ffULL, 0x00000001180c7824ULL, 0x000fe200078e020bULL,
0x0000001848097811ULL, 0x000fe200078ff0ffULL, 0x0000000118117824ULL, 0x000fe200078e0210ULL,
0x00005f0006287a11ULL, 0x000fe200000f3c07ULL, 0x0000000117067824ULL, 0x000fe200078e0218ULL,
0x0000001048077811ULL, 0x000fe200078ff0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe20000011648ULL, 0x00000001180a7824ULL, 0x000fe200078e0209ULL,
0x00000028480d7811ULL, 0x000fe200078ff0ffULL, 0x0000000118087824ULL, 0x000fe200078e0207ULL,
0x0000003848127811ULL, 0x000fc400078ff0ffULL, 0x0000000621227210ULL, 0x000fe20007fde0ffULL,
0x00000001180f7824ULL, 0x040fe200078e020dULL, 0x0000000315157812ULL, 0x000fe200078e4848ULL,
0x0000000118137824ULL, 0x000fe200078e0212ULL, 0x0000000c211a7210ULL, 0x000fe20007f3e0ffULL,
0x000000040b0c7824ULL, 0x000fe200078e00ffULL, 0x0000100047237811ULL, 0x000fe200078e68ffULL,
0x000000040d147824ULL, 0x000fe200078e00ffULL, 0xfffffffc100b7812ULL, 0x000fe200078ee215ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00000008211e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000407087824ULL, 0x000fe200078e00ffULL, 0x0000000a211c7210ULL, 0x000fe20007f1e0ffULL,
0x00000004090a7824ULL, 0x000fe200078e00ffULL, 0x00005e0022207a11ULL, 0x000fe200078c38ffULL,
0x0000000417067824ULL, 0x000fe200078e00ffULL, 0x0000000f210f7210ULL, 0x040fe20007f5e0ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x0000001121117210ULL, 0x000fc40007f7e0ffULL,
0x0000001321137210ULL, 0x000fe20007f9e0ffULL, 0x000000100b217824ULL, 0x000fe200078e0223ULL,
0x00005f0022227a11ULL, 0x000fe200030f3c0dULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0xfffffffc08077812ULL, 0x100fe200078ee215ULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005e001c0d7a11ULL, 0x000fe200078038ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0xfffffffc0c097812ULL, 0x000fe200078ee215ULL, 0x0000001007197824ULL, 0x000fe200078e0223ULL,
0xfffffffc0a087812ULL, 0x100fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x00000010091d7824ULL, 0x000fe200078e0223ULL,
0xfffffffc140a7812ULL, 0x000fe200078ee215ULL, 0x00000010081b7824ULL, 0x000fe200078e0223ULL,
0x00005f001c1c7a11ULL, 0x000fe200000f3c0bULL, 0x0000001006177824ULL, 0x100fe200078e0223ULL,
0x000000300e0b7812ULL, 0x000fe200078ec0ffULL, 0x000000100a1f7824ULL, 0x000fe200078e0223ULL,
0x0ffffffc15487812ULL, 0x000fe200078ef848ULL, 0x000000ffff087224ULL, 0x000fe200020e06ffULL,
0xfffffffc120c7812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005e001a097a11ULL, 0x000fe200078238ffULL, 0x0000001048297824ULL, 0x100fe200078e0223ULL,
0x00005e001e0a7a11ULL, 0x000fe200078a38ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x000000260b067210ULL, 0x000fc40007f1e0ffULL, 0x00005e0013147a11ULL, 0x000fe400078638ffULL,
0x00005f001a1a7a11ULL, 0x000fe200008f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0628ULL,
0x00005e000f107a11ULL, 0x000fe400078238ffULL, 0x00005f001e1e7a11ULL, 0x000fe400028f3c15ULL,
0x00005e0011127a11ULL, 0x000fe200078438ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006297faeULL, 0x0003e2000b901c46ULL, 0x00005f0013157a11ULL, 0x000fc400018f3c08ULL,
0x000000200b087210ULL, 0x000fe40007f1e0ffULL, 0x00005f000f187a11ULL, 0x000fe400008f3c18ULL,
0x00005f0011167a11ULL, 0x000fe400010f3c16ULL, 0x0000000a0b0a7210ULL, 0x040fe40007f3e0ffULL,
0x0000000d0b0c7210ULL, 0x040fe40007f5e0ffULL, 0x000000090b0e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0622ULL, 0x000000100b107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061cULL, 0x000000120b127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e061aULL, 0x000000140b147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e061eULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc400020e0618ULL, 0x000000ffff137224ULL, 0x000fe200028e0616ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc600000e0615ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002047047824ULL, 0x002fc800078e0204ULL,
0x0000001004067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7804ULL,
0x0000000707077812ULL, 0x000fc600078e7804ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x000000070000735dULL, 0x004fe40003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000434600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000267919ULL, 0x000e620000000000ULL,
0x3db504f32a2a7820ULL, 0x020fe20000410000ULL, 0x0000f688472b7811ULL, 0x000fe200078e18ffULL,
0x0000640024247a24ULL, 0x000fe200078e02ffULL, 0xffffffff432d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000f608472c7811ULL, 0x000fe400078e28ffULL,
0x0000010046287824ULL, 0x000fe200078e0225ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000284500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e002eULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000129317810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x0000002700417224ULL, 0x020fc400078e02ffULL, 0x00000001ff2f7819ULL, 0x000fe40000011631ULL,
0x000000023100780cULL, 0x040fe40003f06070ULL, 0x0000000131597812ULL, 0x000fe200078ec0ffULL,
0x000003002f2e7a24ULL, 0x000fe400078e0246ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0029ULL,
0x000001002e3e7824ULL, 0x040fe200078e0225ULL, 0x000000012e327810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200078e0031ULL, 0x00000001302e7812ULL, 0x000fc400078e0cffULL,
0x000000433200720cULL, 0x000fe40003f26070ULL, 0x000000403e337812ULL, 0x000fca00078ec0ffULL,
0x00000001023d7824ULL, 0x000fcc00078e0233ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff407819ULL, 0x002fe20000011626ULL, 0x0000000459497824ULL, 0x000fe400078e00ffULL,
0x0000000247427824ULL, 0x000fe200078e022eULL, 0x00000010404e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000140317824ULL, 0x140fe200078e023dULL, 0x0000000840487810ULL, 0x040fe40007ffe0ffULL,
0x0000001840507810ULL, 0x000fe20007ffe0ffULL, 0x000000014e337824ULL, 0x100fe200078e023dULL,
0x0000003141397210ULL, 0x000fe20007f3e0ffULL, 0x0000000148327824ULL, 0x000fe200078e023dULL,
0x0000003e45317217ULL, 0x000fc40007800000ULL, 0x0000003341377210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x0000003241357210ULL, 0x000fe20007f5e0ffULL,
0x0000000131317824ULL, 0x000fe200078e0a3eULL, 0x00005e0039327a11ULL, 0x000fe200078238ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078638ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0035347a11ULL, 0x000fe400078438ffULL,
0x00005f0037377a11ULL, 0x000fe200018f3c38ULL, 0x0000000150387824ULL, 0x000fe200078e023dULL,
0x0000002040527810ULL, 0x000fc40007ffe0ffULL, 0x0000003040567810ULL, 0x000fe40007ffe0ffULL,
0x00005f0039337a11ULL, 0x000fe200008f3c3cULL, 0x0000000152397824ULL, 0x100fe200078e023dULL,
0x00005f0035357a11ULL, 0x000fe200010f3c3aULL, 0x00000001563b7824ULL, 0x100fe200078e023dULL,
0x0000002840547810ULL, 0x040fe40007ffe0ffULL, 0x000000314000720cULL, 0x040fe40003f46070ULL,
0x0000003840587810ULL, 0x000fe20007ffe0ffULL, 0x00000001543a7824ULL, 0x000fe200078e023dULL,
0x0000003841407210ULL, 0x000fc40007f3e0ffULL, 0x00000039413e7210ULL, 0x040fe20007fbe0ffULL,
0x00000001583c7824ULL, 0x000fe200078e023dULL, 0x0000003b413f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0040387a11ULL, 0x040fe400078238ffULL,
0x00000003ff3b7819ULL, 0x100fe20000011626ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005f0040397a11ULL, 0x000fe400008f3c39ULL, 0x000000314800720cULL, 0x040fe20003f26070ULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x000000033b4f7812ULL, 0x000fe200078e4826ULL,
0x000000ffff3b7224ULL, 0x000fe200028e06ffULL, 0x0000003a413d7210ULL, 0x000fc40007fde0ffULL,
0x0000003c41417210ULL, 0x000fe40007f7e0ffULL, 0x0000100042427811ULL, 0x000fe200078e60ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x0ffffffc4f4b7812ULL, 0x100fe400078ef826ULL,
0xfffffffc49497812ULL, 0x000fe400078ee226ULL, 0xfffffffc484d7812ULL, 0x000fe200078ee24fULL,
0x000000104b4b7824ULL, 0x000fe200078e0242ULL, 0x00005e003e3a7a11ULL, 0x040fe200078a38ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005e0041407a11ULL, 0x000fe200078838ffULL,
0x0000001049327825ULL, 0x000fe200078e0032ULL, 0x00005f003e3b7a11ULL, 0x000fc400028f3c3bULL,
0x00005e003f3e7a11ULL, 0x000fe200078638ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0242ULL,
0x00005e003d3c7a11ULL, 0x000fe200078a38ffULL, 0x0000001049347825ULL, 0x000fe200078e0034ULL,
0x00005f0041417a11ULL, 0x000fe200020f3c48ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324b7faeULL, 0x0003e2000d101c46ULL, 0x000000315400720cULL, 0x0c0fe20003f86070ULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x00005f003f3f7a11ULL, 0x000fe200018f3c4aULL,
0x00000000344d7faeULL, 0x0005e2000c901c46ULL, 0x000000314e00720cULL, 0x0c0fe20003f26070ULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x000000315000720cULL, 0x040fe20003f46070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x00005f003d3d7a11ULL, 0x000fc400028f3c4cULL,
0x000000315200720cULL, 0x0c0fe20003f66070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000315600720cULL, 0x0c0fe20003fa6070ULL, 0x0000000456567824ULL, 0x000fe200078e00ffULL,
0x000000315800720cULL, 0x040fe20003fc6070ULL, 0x0000000458587824ULL, 0x000fe200078e00ffULL,
0xfffffffc54337812ULL, 0x002fe200078ee24fULL, 0x0000001049347825ULL, 0x044fe200078e0038ULL,
0xfffffffc4e317812ULL, 0x100fe400078ee24fULL, 0xfffffffc504b7812ULL, 0x000fe200078ee24fULL,
0x0000001049387825ULL, 0x000fe200078e003cULL, 0xfffffffc524d7812ULL, 0x000fc400078ee24fULL,
0xfffffffc56517812ULL, 0x100fe200078ee24fULL, 0x0000001031317824ULL, 0x100fe200078e0242ULL,
0xfffffffc58537812ULL, 0x000fe200078ee24fULL, 0x00000010334f7824ULL, 0x000fe400078e0242ULL,
0x0000001049327825ULL, 0x000fc800078e0036ULL, 0x000000104b4b7824ULL, 0x100fe200078e0242ULL,
0x0000000032317faeULL, 0x0003e2000c901c46ULL, 0x000000104d4d7824ULL, 0x000fe400078e0242ULL,
0x0000001049367825ULL, 0x000fe200078e003aULL, 0x00000000344b7faeULL, 0x0003e6000d101c46ULL,
0x0000001051517824ULL, 0x000fe200078e0242ULL, 0x00000000364d7faeULL, 0x0003e2000d901c46ULL,
0x00000010493a7825ULL, 0x000fc600078e003eULL, 0x00000000384f7faeULL, 0x0003e2000e101c46ULL,
0x0000001053537824ULL, 0x000fe400078e0242ULL, 0x00000010493c7825ULL, 0x000fe200078e0040ULL,
0x000000003a517faeULL, 0x0003e8000e901c46ULL, 0x000000003c537faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008263a7811ULL, 0x042fe200078ff0ffULL,
0x0000000459557824ULL, 0x000fe200078e00ffULL, 0x0000003d26317211ULL, 0x000fc400078ff0ffULL,
0x00000003ff377819ULL, 0x000fe20000011626ULL, 0x000000013a327824ULL, 0x040fe200078e023dULL,
0x0000003141337210ULL, 0x040fe20007f3e0ffULL, 0x000000043a487824ULL, 0x000fe200078e00ffULL,
0x00000020263c7811ULL, 0x040fe400078ff0ffULL, 0x0000003241317210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0033327a11ULL, 0x000fe400078238ffULL,
0x0000003826427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0031347a11ULL, 0x000fc400078438ffULL, 0x00005f0033337a11ULL, 0x000fe200008f3c38ULL,
0x00000001423a7824ULL, 0x100fe200078e023dULL, 0x00005f0031357a11ULL, 0x000fe200010f3c36ULL,
0x0000000247317824ULL, 0x000fe200078e022eULL, 0x0000001026367811ULL, 0x000fe200078ff0ffULL,
0x0000000442527824ULL, 0x000fe200078e00ffULL, 0x0000001826387811ULL, 0x000fe400078ff0ffULL,
0x00000003373b7812ULL, 0x100fe200078e4826ULL, 0x00000004364a7824ULL, 0x000fe200078e00ffULL,
0x00000028263e7811ULL, 0x000fe200078ff0ffULL, 0x00000004384c7824ULL, 0x000fe200078e00ffULL,
0x0000003026407811ULL, 0x000fe200078ff0ffULL, 0x000000013c377824ULL, 0x100fe200078e023dULL,
0x0000100031537811ULL, 0x000fe200078e60ffULL, 0x0000000136317824ULL, 0x000fe200078e023dULL,
0xfffffffc48427812ULL, 0x100fe200078ee23bULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4a487812ULL, 0x000fe200078ee23bULL, 0x0000000138367824ULL, 0x000fe200078e023dULL,
0xfffffffc4c4a7812ULL, 0x100fe200078ee23bULL, 0x000000043e4e7824ULL, 0x000fe200078e00ffULL,
0x0000003141317210ULL, 0x040fe20007f7e0ffULL, 0x0000000440507824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c4c7812ULL, 0x000fe200078ee23bULL, 0x0000000140397824ULL, 0x100fe200078e023dULL,
0x00000036413c7210ULL, 0x000fe20007f5e0ffULL, 0x000000013e387824ULL, 0x000fe200078e023dULL,
0xfffffffc4e4e7812ULL, 0x100fe200078ee23bULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0xfffffffc50507812ULL, 0x000fe200078ee23bULL, 0x000000104c4d7824ULL, 0x000fe200078e0253ULL,
0xfffffffc52527812ULL, 0x000fe200078ee23bULL, 0x000000104a4b7824ULL, 0x100fe200078e0253ULL,
0x0ffffffc3b407812ULL, 0x000fe200078ef826ULL, 0x0000001048497824ULL, 0x100fe200078e0253ULL,
0x00000037413b7210ULL, 0x040fe20007f3e0ffULL, 0x000000104e4f7824ULL, 0x100fe200078e0253ULL,
0x00000039413f7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x00000038413d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e0031367a11ULL, 0x000fe200078c38ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x00005e003c387a11ULL, 0x000fe200078438ffULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x0000003a41417210ULL, 0x000fe20007fbe0ffULL, 0x0000001040577824ULL, 0x100fe200078e0253ULL,
0x00005f0031377a11ULL, 0x000fe200030f3c3eULL, 0x0000001042317824ULL, 0x000fe200078e0253ULL,
0x00005f003c397a11ULL, 0x000fe200010f3c39ULL, 0x000000ffff427224ULL, 0x000fe200028e06ffULL,
0xfffffffc55557812ULL, 0x000fe200078ee226ULL, 0x0000001050517824ULL, 0x100fe200078e0253ULL,
0x00005e003b3a7a11ULL, 0x000fe200078238ffULL, 0x0000001052537824ULL, 0x000fe200078e0253ULL,
0x00005e003d3c7a11ULL, 0x000fe200078438ffULL, 0x0000001055327825ULL, 0x000fe200078e0032ULL,
0x00005e003f3e7a11ULL, 0x000fc400078638ffULL, 0x00005e0041407a11ULL, 0x000fe200078838ffULL,
0x0000001055347825ULL, 0x000fe200078e0034ULL, 0x00005f003b3b7a11ULL, 0x000fe200008f3c4cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032577faeULL, 0x0003e2000b901c46ULL,
0x00005f003d3d7a11ULL, 0x000fe200010f3c4aULL, 0x0000001055367825ULL, 0x000fe200078e0036ULL,
0x00005f003f3f7a11ULL, 0x000fe200018f3c48ULL, 0x0000000034317faeULL, 0x0003e2000b901c46ULL,
0x00005f0041417a11ULL, 0x000fe200020f3c42ULL, 0x0000001055387825ULL, 0x040fe400078e0038ULL,
0x0000000036497faeULL, 0x0003e4000b901c46ULL, 0x00000010553a7825ULL, 0x000fc400078e003aULL,
0x00000000384b7faeULL, 0x0003e4000b901c46ULL, 0x00000010553c7825ULL, 0x040fe400078e003cULL,
0x000000003a4d7faeULL, 0x0003e4000b901c46ULL, 0x00000010553e7825ULL, 0x040fe400078e003eULL,
0x000000003c4f7faeULL, 0x0003e4000b901c46ULL, 0x0000001055407825ULL, 0x000fc400078e0040ULL,
0x000000003e517faeULL, 0x0003e8000b901c46ULL, 0x0000000040537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5900720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff007624ULL, 0x000fc800078e00ffULL, 0x0000000200037824ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x000000440300720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000224327824ULL, 0x002fe400078e0203ULL,
0x00000004ff337424ULL, 0x000fc800078e00ffULL, 0x0000600032327625ULL, 0x000fca00078e0033ULL,
0x0000000632007981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002026337810ULL, 0x042fe20007ffe0ffULL,
0x00000002473f7824ULL, 0x000fe200078e0230ULL, 0xfffffff826317812ULL, 0x040fe200078ec0ffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000007313c7812ULL, 0x100fe400078ef826ULL,
0x0000000733407812ULL, 0x000fe400078ef826ULL, 0x0000000726317812ULL, 0x000fc400078ec0ffULL,
0x00000001ff427819ULL, 0x000fe4000001163cULL, 0x00000001ff487819ULL, 0x000fe40000011640ULL,
0x000010003f3f7811ULL, 0x000fe400078e60ffULL, 0x00000008313e7812ULL, 0x000fe400078ef826ULL,
0x0000000342427812ULL, 0x000fe400078ec0ffULL, 0x0000000348487812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003d42317212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003d48357212ULL, 0x000fc400078e3cffULL,
0x000000013d4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000043c307824ULL, 0x000fe200078e0231ULL,
0x0000002f26537211ULL, 0x000fe200078fe0ffULL, 0x0000000440347824ULL, 0x000fe200078e0235ULL,
0x000000023d3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001030307824ULL, 0x100fe200078e023fULL,
0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001034347824ULL, 0x000fe200078e023fULL,
0x000000043d00780cULL, 0x000fc60003f25270ULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000018ff3a7819ULL, 0x002fe20000011432ULL,
0x00010000313b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011431ULL,
0x0000003a005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe20000011430ULL,
0x00010000374e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011433ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff4b7819ULL, 0x000fe20000011434ULL,
0x0000003900587306ULL, 0x0005e20000200c00ULL, 0x00008880313a7816ULL, 0x042fe200000000ffULL,
0x0000010031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011435ULL,
0x00000018ff497819ULL, 0x000fe40000011436ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000003800547306ULL, 0x0003e20000200c00ULL, 0x0001000030397824ULL, 0x004fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc40000011437ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000031005b7306ULL, 0x0005e20000200c00ULL,
0x0000888030387816ULL, 0x042fe200000000ffULL, 0x0000010030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003900557306ULL, 0x0003e20000200c00ULL,
0x0001000033317824ULL, 0x004fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003800527306ULL, 0x0005e20000200c00ULL, 0x0000888033397816ULL, 0x042fe200000000ffULL,
0x0000010033337824ULL, 0x000fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000003000577306ULL, 0x0003e20000200c00ULL, 0x0000888032387816ULL, 0x004fce00000000ffULL,
0x0000003300637306ULL, 0x0005e20000200c00ULL, 0x0001000032307824ULL, 0x042fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000038005a7306ULL, 0x0003e20000200c00ULL, 0x0000004d42337212ULL, 0x084fe400078e3cffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000004d484d7212ULL, 0x000fc600078e3cffULL,
0x00000032005f7306ULL, 0x0005e20000200c00ULL, 0x000000043c387824ULL, 0x002fc800078e0233ULL,
0x0000001038387824ULL, 0x000fc600078e023fULL, 0x00000030005d7306ULL, 0x0002e20000200c00ULL,
0x0001000034327824ULL, 0x004fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003a00567306ULL, 0x000fe20000200c00ULL, 0x0000888034307816ULL, 0x042fe200000000ffULL,
0x0000010034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003b00597306ULL, 0x000e620000200c00ULL, 0x000054105a5a7816ULL, 0x008fce000000005dULL,
0x00000039005e7306ULL, 0x0005f00000200c00ULL, 0x0000003100617306ULL, 0x0007220000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x0000541056567816ULL, 0x002fcc0000000059ULL,
0x0000003000607306ULL, 0x0003e20000200c00ULL, 0x0000888035317816ULL, 0x008fce00000000ffULL,
0x0000003200657306ULL, 0x0006a20000200c00ULL, 0x0001000035307824ULL, 0x042fe200078e00ffULL,
0x000054105e5e7816ULL, 0x010fe20000000061ULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100647306ULL, 0x0003e20000200c00ULL,
0x0000000440327824ULL, 0x008fe200078e024dULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000001032327824ULL, 0x000fc600078e023fULL, 0x0000003000677306ULL, 0x0007220000200c00ULL,
0x0001000036317824ULL, 0x002fe200078e00ffULL, 0x0000541060607816ULL, 0x004fc80000000065ULL,
0x00000018ff4d7819ULL, 0x000fe40000011431ULL, 0x0000003400627306ULL, 0x0003e20000200c00ULL,
0x000000003230783bULL, 0x008ea20000000200ULL, 0x0000888039727816ULL, 0x000fe200000000ffULL,
0x000100003a767824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe4000001143bULL,
0x000088803b7a7816ULL, 0x000fe400000000ffULL, 0x0000003500697306ULL, 0x0007e20000200c00ULL,
0x0000888036347816ULL, 0x042fe200000000ffULL, 0x0000010036367824ULL, 0x000fe200078e00ffULL,
0x0000541064647816ULL, 0x010fc40000000067ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400667306ULL, 0x0003e20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003600687306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011438ULL, 0x00000035006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff367819ULL, 0x008fce0000011439ULL, 0x0000003600747306ULL, 0x0007e20000200c00ULL,
0x0001000038357824ULL, 0x002fe200078e00ffULL, 0x00008880307d7816ULL, 0x004fe400000000ffULL,
0x00000018ff507819ULL, 0x000fe40000011430ULL, 0x00000018ff4f7819ULL, 0x000fe40000011431ULL,
0x0000003400707306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x008fe40000011435ULL,
0x0000000753357812ULL, 0x000fc400078e783eULL, 0x0000000253537810ULL, 0x000fc60007ffe0ffULL,
0x000000103e357824ULL, 0x000fe200078e0235ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000004d006b7306ULL, 0x0002a20000200c00ULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000000753537812ULL, 0x000fe200078e783eULL, 0x0000001035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000000103e537824ULL, 0x000fe200078e0253ULL,
0x00000037006c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff4d7819ULL, 0x002fce000001143aULL,
0x00000034006e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff377819ULL, 0x008fe40000011433ULL,
0x0000541066667816ULL, 0x004fca000000006bULL, 0x0000004d00787306ULL, 0x000fe20000200c00ULL,
0x0001000039347824ULL, 0x042fe400078e00ffULL, 0x0000010039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011434ULL, 0x00000037004d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x00000036006f7306ULL, 0x0002b00000200c00ULL,
0x0000003900757306ULL, 0x0007e20000200c00ULL, 0x000000003534783bULL, 0x002e6e0000000200ULL,
0x0000003800717306ULL, 0x0009220000200c00ULL, 0x000100003b397824ULL, 0x048fe200078e00ffULL,
0x000054106e6e7816ULL, 0x004fe2000000006fULL, 0x000001003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000088803a387816ULL, 0x050fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc8000001143bULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000003800777306ULL, 0x0007e20000200c00ULL, 0x00005410716f7816ULL, 0x000fce0000000070ULL,
0x00000039007b7306ULL, 0x0009e20000200c00ULL, 0x0000541052387816ULL, 0x008fce0000000055ULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x0000541057397816ULL, 0x010fe40000000054ULL,
0x000054105b577816ULL, 0x000fe40000000058ULL, 0x000054105f5b7816ULL, 0x000fe4000000005cULL,
0x00005410635f7816ULL, 0x004fe2000000004cULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000000383404723cULL, 0x042fee0000001804ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000000ffff387224ULL, 0x000fe200078e007dULL, 0x0000541062617816ULL, 0x008fe2000000004bULL,
0x000000563408723cULL, 0x000fe20000001808ULL, 0x00008880324b7816ULL, 0x000fc800000000ffULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x0000541069657816ULL, 0x004fe4000000004aULL,
0x0000888031567816ULL, 0x000fe200000000ffULL, 0x0000005a340c723cULL, 0x000fe8000000180cULL,
0x0000004e006d7306ULL, 0x0005220000200c00ULL, 0x0000541068677816ULL, 0x002fe20000000049ULL,
0x000000ffff497224ULL, 0x000fc400078e004bULL, 0x0000005e3410723cULL, 0x040fe20000001810ULL,
0x00010000324b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0056ULL,
0x0000003a00797306ULL, 0x0003e20000200c00ULL, 0x000054106c6b7816ULL, 0x008fe40000000041ULL,
0x00000018ff4e7819ULL, 0x004fe20000011432ULL, 0x000000603414723cULL, 0x000fe20000001814ULL,
0x00000018ff4b7819ULL, 0x000fc6000001144bULL, 0x0000003800547306ULL, 0x0005e20000200c00ULL,
0x00010000303a7824ULL, 0x002fe200078e00ffULL, 0x000054106a6a7816ULL, 0x010fe2000000006dULL,
0x0000010030307824ULL, 0x000fe200078e00ffULL, 0x000000643418723cULL, 0x040fe40000001818ULL,
0x00000018ff527819ULL, 0x000fe4000001143aULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000001053387824ULL, 0x004fe200078e00ffULL, 0x0000003b007c7306ULL, 0x0003e40000200c00ULL,
0x00000066341c723cULL, 0x040fec000000181cULL, 0x0000003000537306ULL, 0x0005e20000200c00ULL,
0x000000003838783bULL, 0x002e620000000200ULL, 0x0000006a3420723cULL, 0x000fec0000001820ULL,
0x0000005200557306ULL, 0x0007220000200c00ULL, 0x0000010031307824ULL, 0x004fe200078e00ffULL,
0x0000888033347816ULL, 0x040fe200000000ffULL, 0x0001000033367824ULL, 0x000fc400078e00ffULL,
0x0000010033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0001000031527824ULL, 0x008fe200078e00ffULL,
0x00000030004a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff337819ULL, 0x000fc60000011433ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000541054547816ULL, 0x010fe40000000055ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000010032307824ULL, 0x004fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000006e3804723cULL, 0x002fee0000001804ULL, 0x0000007300737306ULL, 0x000e700000200c00ULL,
0x0000007600767306ULL, 0x000eb00000200c00ULL, 0x0000007a007a7306ULL, 0x000ee20000200c00ULL,
0x0000541072727816ULL, 0x002fc40000000073ULL, 0x0000541075737816ULL, 0x000fca0000000074ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541077767816ULL, 0x004fe20000000076ULL,
0x000000723808723cULL, 0x000fe20000001808ULL, 0x0000541079777816ULL, 0x000fca0000000078ULL,
0x0000005200317306ULL, 0x000e620000200c00ULL, 0x000054107a7a7816ULL, 0x008fe2000000007bULL,
0x00000076380c723cULL, 0x000fec000000180cULL, 0x0000003000357306ULL, 0x0003f00000200c00ULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x000054104c307816ULL, 0x002fce0000000031ULL,
0x0000005000507306ULL, 0x000e700000200c00ULL, 0x0000004f004f7306ULL, 0x000ee20000200c00ULL,
0x000054107c7b7816ULL, 0x004fce0000000051ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541053557816ULL, 0x002fe20000000050ULL, 0x0000007a3810723cULL, 0x040fec0000001810ULL,
0x0000004b00327306ULL, 0x000e620000200c00ULL, 0x000054104a317816ULL, 0x008fe2000000004fULL,
0x000000543814723cULL, 0x040fec0000001814ULL, 0x0000003400347306ULL, 0x000fe40000200c00ULL,
0x000000303818723cULL, 0x000fec0000001818ULL, 0x0000003600377306ULL, 0x000ea20000200c00ULL,
0x0000541049327816ULL, 0x002fce0000000032ULL, 0x0000003300527306ULL, 0x0002e20000200c00ULL,
0x0000541034347816ULL, 0x004fe40000000037ULL, 0x0000541035337816ULL, 0x002fe4000000004eULL,
0x0000541052357816ULL, 0x008fca000000004dULL, 0x00000032381c723cULL, 0x040ff0000000181cULL,
0x000000343820723cULL, 0x000fe20000001820ULL, 0xfffff0d000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff307224ULL, 0x000fe200078e002eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe10000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002b307f8cULL, 0x000fe2000c80043fULL, 0x000000122a377220ULL, 0x000fc40000410000ULL,
0x000000132a387220ULL, 0x040fe20000410000ULL, 0x000004002b297984ULL, 0x000e620000000800ULL,
0x000000142a127220ULL, 0x040fe40000410000ULL, 0x000000152a137220ULL, 0x040fe40000410000ULL,
0x000000062a2f7220ULL, 0x040fe40000410000ULL, 0x000000072a327220ULL, 0x040fe40000410000ULL,
0x0000000a2a337220ULL, 0x000fc40000410000ULL, 0x0000000b2a347220ULL, 0x040fe40000410000ULL,
0x0000000e2a357220ULL, 0x040fe40000410000ULL, 0x000000182a147220ULL, 0x040fe40000410000ULL,
0x000000192a157220ULL, 0x040fe40000410000ULL, 0x000000042a047220ULL, 0x040fe40000410000ULL,
0x000000052a057220ULL, 0x000fc40000410000ULL, 0x000000082a087220ULL, 0x040fe40000410000ULL,
0x000000092a097220ULL, 0x040fe40000410000ULL, 0x0000000c2a067220ULL, 0x040fe40000410000ULL,
0x0000000d2a077220ULL, 0x040fe40000410000ULL, 0x0000000f2a367220ULL, 0x040fe40000410000ULL,
0x000000162a397220ULL, 0x000fc40000410000ULL, 0x000000172a3a7220ULL, 0x040fe40000410000ULL,
0x0000001a2a187220ULL, 0x040fe40000410000ULL, 0x0000001b2a197220ULL, 0x040fe20000410000ULL,
0x8000000029ff7812ULL, 0x002fe20007804831ULL, 0x0000001e2a3b7220ULL, 0x040fe40000410000ULL,
0x0000001f2a3c7220ULL, 0x040fe40000410000ULL, 0x0000001c2a167220ULL, 0x000fc40000410000ULL,
0x0000001d2a177220ULL, 0x040fe40000410000ULL, 0x000000202a1a7220ULL, 0x040fe40000410000ULL,
0x000000212a1b7220ULL, 0x040fe40000410000ULL, 0x000000222a3d7220ULL, 0x040fe40000410000ULL,
0x000000232a3e7220ULL, 0x000fe40000410000ULL, 0x000000ffff1c7224ULL, 0x000fc400078e002fULL,
0x000000ffff1d7224ULL, 0x000fe400078e0032ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0033ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff207224ULL, 0x000fe400078e0035ULL,
0x000000102a107220ULL, 0x040fe40000410000ULL, 0x000000112a117220ULL, 0x000fc40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0007ULL,
0x000000ffff217224ULL, 0x000fe400078e0036ULL, 0x000000ffff227224ULL, 0x000fe400078e0037ULL,
0x000000ffff237224ULL, 0x000fe400078e0038ULL, 0x000000ffff297224ULL, 0x000fe400078e0039ULL,
0x000000ffff2f7224ULL, 0x000fe400078e003aULL, 0x000000ffff327224ULL, 0x000fc400078e0018ULL,
0x000000ffff337224ULL, 0x000fe400078e0019ULL, 0x000000ffff347224ULL, 0x000fe400078e003bULL,
0x000000ffff357224ULL, 0x000fe200078e003cULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe400078e003dULL,
0x000000ffff377224ULL, 0x000fe200078e003eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x000004002b057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000426197824ULL, 0x000fe200078e00ffULL,
0x0000002d4600720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008047187824ULL, 0x000fca00078e0218ULL, 0x00f4000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000226087824ULL, 0x000fe400078e00ffULL,
0x0000000145287824ULL, 0x000fc600078e0a28ULL, 0x0000000608097812ULL, 0x000fc800078ec0ffULL,
0x0000000109317812ULL, 0x040fe400078efcffULL, 0x0000000809397812ULL, 0x000fe400078efcffULL,
0x000000283100720cULL, 0x080fe40003f26070ULL, 0x0000001009317812ULL, 0x000fe400078efcffULL,
0x000000283900720cULL, 0x080fe40003f06070ULL, 0x000000283100720cULL, 0x000fc40003fc6070ULL,
0x0000001109397812ULL, 0x040fe400078efcffULL, 0x0000001809317812ULL, 0x040fe400078efcffULL,
0x000000280900720cULL, 0x080fe40003f46070ULL, 0x000000283900720cULL, 0x080fe40003fa6070ULL,
0x000000283100720cULL, 0x000fe40003f66070ULL, 0x00000009093b7812ULL, 0x000fc400078efcffULL,
0x0000001909397812ULL, 0x040fe400078efcffULL, 0x0000002009317812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x000000283b00720cULL, 0x080fe40003f86070ULL, 0x000000283900720cULL, 0x080fe40003f46070ULL,
0x000000283100720cULL, 0x000fe40003f26070ULL, 0x0000002109397812ULL, 0x040fe400078efcffULL,
0x0000002809317812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x000000283900720cULL, 0x080fe40003f06070ULL,
0x000000283100720cULL, 0x000fe40003f86070ULL, 0x0000002909397812ULL, 0x000fc400078efcffULL,
0x0000003009317812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x000000283900720cULL, 0x000fc40003fc6070ULL,
0x000000283100720cULL, 0x000fe40003fa6070ULL, 0x0000003109397812ULL, 0x040fe400078efcffULL,
0x0000003809317812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff29297808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x000000283900720cULL, 0x080fe40003f66070ULL, 0x000000283100720cULL, 0x000fc40003f46070ULL,
0x000000280900720cULL, 0x000fe40003f26070ULL, 0xff7fffff2f2f7808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff32327808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff33337808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff34347808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff35357808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff36367808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff37377808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000000b04097209ULL, 0x004fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fc40007810000ULL, 0x0000000c09047209ULL, 0x000fe40007810000ULL,
0x0000001e05087209ULL, 0x000fe40007810000ULL, 0x0000000d04057209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x0000000e05047209ULL, 0x000fe40007810000ULL,
0x0000002009087209ULL, 0x000fc40007810000ULL, 0x0000000f04057209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fe40007810000ULL,
0x0000002209087209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x0000002308087209ULL, 0x000fc40007810000ULL, 0x0000001205047209ULL, 0x000fe40007810000ULL,
0x0000002908087209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fe40007810000ULL,
0x0000002f08097209ULL, 0x000fe40007810000ULL, 0x0000001405047209ULL, 0x000fe40007810000ULL,
0x0000003209087209ULL, 0x000fc40007810000ULL, 0x0000001504057209ULL, 0x000fe40007810000ULL,
0x0000003308097209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000003409087209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000003508097209ULL, 0x000fc40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000003609087209ULL, 0x000fe40007810000ULL, 0x0000001b04307209ULL, 0x000fe40007810000ULL,
0x0000003708387209ULL, 0x000fe20007810000ULL, 0x000018427f007947ULL, 0x000fea000b800000ULL,
0x0c401f0030047f89ULL, 0x0004e400000e0000ULL, 0x0000000430397209ULL, 0x008fe20007810000ULL,
0x000018827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007287f89ULL, 0x000e6200000e0000ULL,
0x0000000438087209ULL, 0x008fc60007810000ULL, 0x0c201f0039047f89ULL, 0x000ee200000e0000ULL,
0x0000000506097209ULL, 0x010fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000f2200000e0000ULL,
0x0000002807287209ULL, 0x002fc60007810000ULL, 0x0c201f0009307f89ULL, 0x004e6800000e0000ULL,
0x0c201f0028317f89ULL, 0x0004a200000e0000ULL, 0x0000000439047209ULL, 0x008fe40007810000ULL,
0x0000000508057209ULL, 0x010fe40007810000ULL, 0x0000003009067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b05307820ULL, 0x002fe20000410000ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc40000010830ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b11117823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b21217823ULL, 0x000fc40000010830ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010830ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b23237823ULL, 0x000fe40000010830ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000080908723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b15157823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b32327823ULL, 0x100fe40000010830ULL,
0x0000001d001d7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010830ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe40000010830ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL, 0x0000001e000b7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1b077823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b34347823ULL, 0x000fe20000010830ULL,
0x0000001f00387308ULL, 0x0008a20000000800ULL, 0x0000001c1d09723eULL, 0x002fe200000000ffULL,
0x3c003c00ff1e7424ULL, 0x008fc400078e00ffULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010830ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010830ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3c003c00ff1f7424ULL, 0x010fe400078e00ffULL, 0x3fb8aa3b37307823ULL, 0x000fe20000010830ULL,
0x0000000b380b723eULL, 0x004fc800000000ffULL, 0x0000000f000f7308ULL, 0x000e660000000800ULL,
0x0000001e0838723cULL, 0x000fea00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x004fce00000000ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000022230f723eULL, 0x004fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000001e0c38723cULL, 0x000fee0000001838ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002f001c7308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x004fe200000000ffULL,
0x0000000fff157424ULL, 0x000fe200078e00ffULL, 0xfffffffc26147812ULL, 0x000fc800078ec0ffULL,
0x0000001415207219ULL, 0x000fe200000006ffULL, 0x0000003200327308ULL, 0x000fe60000000800ULL,
0x00000000201d73a1ULL, 0x000ea200000e8000ULL, 0x00000000200473c4ULL, 0x000ee80000004000ULL,
0x0000003300337308ULL, 0x000f220000000800ULL, 0x000000291c11723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000323313723eULL, 0x010fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000000520ff7c12ULL, 0x004fe2000f80401dULL,
0x0000001e1038723cULL, 0x000fec0000001838ULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000000ffULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x0000001a0716723eULL, 0x004fe400000000ffULL, 0x0000002831077209ULL, 0x000fca0007810000ULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x00000030001b7308ULL, 0x000ea20000000800ULL,
0x000000343515723eULL, 0x002fe400000000ffULL, 0x000000361b17723eULL, 0x004fce00000000ffULL,
0x0000001e1438723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000149204008947ULL, 0x008fde000b800000ULL, 0x001c1fff381c7589ULL, 0x0002a400000e0000ULL,
0x00000000201b73a1ULL, 0x000ee200000e8000ULL, 0x00000000200473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000520ff7c12ULL, 0x008fda000f80401bULL,
0x000014b204008947ULL, 0x010fea000b800000ULL, 0x001c1fff3a1d7589ULL, 0x00072800000e0000ULL,
0x001c1fff011e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011626ULL, 0x0000000c193d7812ULL, 0x000fc400078ec0ffULL,
0x000000071a1b7812ULL, 0x040fe200078ec0ffULL, 0x000000081a287824ULL, 0x040fe200078e00ffULL,
0x0000001aff227212ULL, 0x000fe200078e33ffULL, 0x000000081a207824ULL, 0x00afe200078e00ffULL,
0x0000000326ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081a377824ULL, 0x040fe200078e00ffULL,
0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff828217812ULL, 0x100fe400078ee21bULL,
0x0000000120237812ULL, 0x100fe200078ef61bULL, 0x000000081a4f7824ULL, 0x000fe200078e00ffULL,
0x0000000220297812ULL, 0x100fe200078ef61bULL, 0x000000081a287824ULL, 0x000fe200078e00ffULL,
0x00000003202f7812ULL, 0x000fc400078ef61bULL, 0x0000000420317812ULL, 0x140fe400078ef61bULL,
0x0000000520337812ULL, 0x140fe400078ef61bULL, 0x0000000620357812ULL, 0x000fe200078ef61bULL,
0x000000081a207824ULL, 0x040fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe400078ee222ULL,
0x0000001aff227212ULL, 0x000fe400078e33ffULL, 0x000000071a1b7812ULL, 0x000fc400078ec0ffULL,
0x00009000471a7811ULL, 0x000fe400078e58ffULL, 0xfffffff828397812ULL, 0x100fe400078ee21bULL,
0x00000001203b7812ULL, 0x140fe200078ef61bULL, 0x0000001021197824ULL, 0x100fe200078e021aULL,
0x00000002203f7812ULL, 0x140fe200078ef61bULL, 0x0000001031287824ULL, 0x100fe200078e021aULL,
0x0000000320417812ULL, 0x040fe200078ef61bULL, 0x000000013d197824ULL, 0x000fe200078e0219ULL,
0x0000000420497812ULL, 0x140fe200078ef61bULL, 0x0000001035307824ULL, 0x100fe200078e021aULL,
0x00000005204b7812ULL, 0x140fe200078ef61bULL, 0x0000001037327824ULL, 0x100fe200078e021aULL,
0x00000006204d7812ULL, 0x000fe200078ef61bULL, 0x00000010231b7824ULL, 0x000fe200078e021aULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee222ULL, 0x0000001029207824ULL, 0x100fe200078e021aULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x000000102f227824ULL, 0x000fc400078e021aULL,
0x00000010332f7824ULL, 0x000fe400078e021aULL, 0x000000013d1b7824ULL, 0x040fe400078e021bULL,
0x000000013d217824ULL, 0x040fe400078e0220ULL, 0x000000013d237824ULL, 0x000fe200078e0222ULL,
0x0000000a1b007388ULL, 0x0007e20000000800ULL, 0x0000001039347824ULL, 0x000fe400078e021aULL,
0x000000013d297824ULL, 0x000fe200078e0228ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x000000103b357824ULL, 0x000fc400078e021aULL, 0x000000013d2f7824ULL, 0x000fe200078e022fULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x000000103f367824ULL, 0x000fe400078e021aULL,
0x000000013d317824ULL, 0x000fe200078e0230ULL, 0x0000001029007388ULL, 0x0007e20000000800ULL,
0x0000001041377824ULL, 0x000fe400078e021aULL, 0x000000013d337824ULL, 0x000fe200078e0232ULL,
0x000000122f007388ULL, 0x0007e20000000800ULL, 0x0000001049387824ULL, 0x000fc400078e021aULL,
0x000000104b397824ULL, 0x100fe200078e021aULL, 0x0000001431007388ULL, 0x0007e20000000800ULL,
0x000000104d3a7824ULL, 0x100fe400078e021aULL, 0x000000104f3b7824ULL, 0x000fe200078e021aULL,
0x0000001633007388ULL, 0x0007e20000000800ULL, 0x000000013d347824ULL, 0x040fe400078e0234ULL,
0x000000013d1a7824ULL, 0x040fe400078e0235ULL, 0x000000013d367824ULL, 0x040fe200078e0236ULL,
0x0000000934007388ULL, 0x0007e20000000800ULL, 0x000000013d087824ULL, 0x002fc400078e0237ULL,
0x000000013d387824ULL, 0x040fe200078e0238ULL, 0x0000000b1a007388ULL, 0x0007e20000000800ULL,
0x000000013d207824ULL, 0x040fe400078e0239ULL, 0x000000013d3a7824ULL, 0x040fe200078e023aULL,
0x0000000d36007388ULL, 0x0007e20000000800ULL, 0x000000013d227824ULL, 0x000fc600078e023bULL,
0x0000000f08007388ULL, 0x0007e80000000800ULL, 0x0000001138007388ULL, 0x0007e80000000800ULL,
0x0000001320007388ULL, 0x0007e80000000800ULL, 0x000000153a007388ULL, 0x0007e80000000800ULL,
0x0000001722007388ULL, 0x0007e80000000800ULL, 0x00f0000418008388ULL, 0x0007e80000000c00ULL,
0x00f2001c18008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002cff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002cff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030046467a10ULL, 0x000fe20007ffe0ffULL, 0x000018002cff7f8cULL, 0x0003e6000c80043fULL,
0x000000434600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc5d000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x010fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001194000297802ULL, 0x000fe40000000f00ULL, 0x0000109000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xffff00b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x000119a000297802ULL, 0x000fe40000000f00ULL, 0x0000103000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xffff00e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0000ULL, 0x00011a1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fc400078e00ffULL,
0x00000f8000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff013000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x000fe200078e0000ULL,
0x00011a8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x00000f1000007944ULL, 0x03cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002fULL, 0xffff00f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0024ULL, 0x00011af000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x00000ea000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff4d7224ULL, 0x004fe200078e002fULL,
0xffff045000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e0002ULL,
0x00011b6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff4e7224ULL, 0x004fe200078e002fULL, 0xffff041000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00011bc000297802ULL, 0x000fc40000000f00ULL, 0x00000e1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff1ec000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00011c2000297802ULL, 0x000fc40000000f00ULL, 0x00000db000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff1ef000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x008fe200078e00ffULL, 0x00011c8000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6e7424ULL, 0x000fc400078e00ffULL, 0x00000d1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff1f6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x00afe200078e0002ULL, 0x00011cf000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x00000ca000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff201000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x000fe200078e00ffULL,
0x00011d5000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x00000c4000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e002fULL,
0xffff22d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e0002ULL,
0x00011dc000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x00000bd000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff6a7224ULL, 0x004fe200078e002fULL, 0xffff228000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x002fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00011e2000297802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff3b6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00011e8000297802ULL, 0x000fc40000000f00ULL, 0x00000b5000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff3b9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x002fe200078e00ffULL, 0x00011ee000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6e7424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff3c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e0002ULL, 0x00011f5000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x00000a4000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff3cb000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x000fe200078e00ffULL,
0x00011fb000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x000009e000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff537224ULL, 0x004fe200078e002fULL,
0xffff3f6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e0002ULL,
0x0001202000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000097000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e002fULL, 0xffff3f1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001208000297802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff56c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x000120e000297802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff56f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x008fe200078e00ffULL, 0x0001214000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6e7424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002fULL, 0xffff576000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x00afe200078e0002ULL, 0x000121b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x000007e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002fULL,
0xffff581000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x000fe200078e00ffULL,
0x0001221000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6e7424ULL, 0x000fe400078e00ffULL,
0x0000078000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e002fULL,
0xffff5ad000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e0002ULL,
0x0001228000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6e7424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e002fULL, 0xffff5a8000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x000122f000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff3a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000066000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0031ULL,
0xffffe76000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0038ULL,
0x0001237000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x020fea0003c00000ULL, 0x0000003138387209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x000123e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fc400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0007ULL,
0x0001245000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000003107287209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0039ULL, 0x000124c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000003139047209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0038ULL,
0x0001253000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000003138057209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x000125a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000001fff3a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0028ULL,
0x0001261000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff3a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4f7224ULL, 0x000fe200078e0038ULL, 0x0001268000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff6c7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6e7224ULL, 0x000fe400078e0020ULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e002fULL, 0xffffeb0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4f7224ULL, 0x002fe200078e003aULL, 0x0001270000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff6c7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6e7224ULL, 0x000fe400078e0020ULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e00ffULL, 0x0001276000287802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff6e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x004fe400078e002fULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x002fe200078e0020ULL, 0x000127c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff6c7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e002fULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e002fULL, 0xffffea4000007947ULL, 0x000fea000383ffffULL,
0x018000003b007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003b00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3bff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003b057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003b00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffed6b004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c00003130317389ULL, 0x0002a200000e003aULL,
0xfffed67008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000006e00007348ULL, 0x000fe80003800000ULL, 0x0000006c4f2f7389ULL, 0x0002a200000e006dULL,
0xfffed63028007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f05070ULL,
0x0000002500007348ULL, 0x000fd80003800000ULL, 0x0000000000247806ULL, 0x000fc800040e0100ULL,
0x0000002524287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fe400078e0029ULL,
0x00000000ff257424ULL, 0x000fc800078e00ffULL, 0xfffed5c024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000458ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a38ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ac8ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000134cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001370ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013a0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001430ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001438ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001448ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000012b00ULL, 0xa100001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014100ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014110ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014590ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001430ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012cd0ULL, 0x0000000000012cd0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014590ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 83568;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
