/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012b90ULL, 0x0000000000012710ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000112b0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000011420ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000011460ULL, 0x0000000000000120ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000011580ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000112b000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0044040400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080aa0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080aa92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000112b000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080960828808081ULL, 0xaa08288080ac0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080aa920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x0001142000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080960828808081ULL, 0xac08288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080ac920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001146000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000a4ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x0001069000010110ULL, 0x00010710000106a0ULL,
0x0001073000010720ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500000fffffffffULL, 0x0500000f0500000fULL, 0xffffffff0500000fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x000000f0000000c0ULL,
0x00001950000018b0ULL, 0x00001a10000019e0ULL, 0x000025b0000024c0ULL, 0x0000382000003780ULL,
0x000038d0000038a0ULL, 0x00004320000042e0ULL, 0x000055a000005500ULL, 0x0000565000005620ULL,
0x00005e1000005ab0ULL, 0x00007150000070b0ULL, 0x000071f0000071c0ULL, 0x0000761000007600ULL,
0x0000874000008730ULL, 0x0000b1d00000b1b0ULL, 0x0000b6d00000b6a0ULL, 0x000100100000ffe0ULL,
0x0001003000010020ULL, 0x0001007000010050ULL, 0x000100a000010090ULL, 0x0001076000010700ULL,
0x0001078000010770ULL, 0x00010e4000010dc0ULL, 0x00010ef000010e90ULL, 0x00010f9000010f40ULL,
0x0001103000010fe0ULL, 0x000110d000011080ULL, 0x000111c000011140ULL, 0x0001128000011220ULL,
0x0000017003e03904ULL, 0x0000f600000000ffULL, 0x000001b0003f0100ULL, 0x0000f6080000000bULL,
0x000001e0003f0130ULL, 0x0000f6100000000bULL, 0x00000210003f0130ULL, 0x0000f6480000000bULL,
0x00000240003f0120ULL, 0x0000f6680000000bULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000044ULL, 0x00000750003f0102ULL, 0x0000f61000000044ULL,
0x00000ca0003f0101ULL, 0x00000000000000ffULL, 0x00000d2000040107ULL, 0x0000002000000009ULL,
0x00000ea0003f0101ULL, 0x0000002400000009ULL, 0x00000f50003f0106ULL, 0x0000002400000009ULL,
0x00000fe0003f0106ULL, 0x0000002400000009ULL, 0x00001640003f0106ULL, 0x0000000000000068ULL,
0x000016b000040107ULL, 0x000000040000001fULL, 0x000016d000040106ULL, 0x0000f60c00000012ULL,
0x000017d0003f0106ULL, 0x0000f60c00000012ULL, 0x00001c80003f0106ULL, 0x000000040000001fULL,
0x00001d2000040106ULL, 0x000000040000001fULL, 0x00002ee000040106ULL, 0x0000002000000009ULL,
0x00002f60003f0101ULL, 0x0000000000000018ULL, 0x00003010003f0101ULL, 0x0000002400000009ULL,
0x00003060003f0106ULL, 0x0000002400000009ULL, 0x000030f0003f0106ULL, 0x0000002400000009ULL,
0x00003550003f0106ULL, 0x00000000000000ffULL, 0x000035c000060107ULL, 0x000000040000005eULL,
0x000035e0003f0106ULL, 0x0000f61c00000012ULL, 0x000036e0003f0106ULL, 0x0000f61c00000012ULL,
0x00003ba0003f0106ULL, 0x0000f64c0000004aULL, 0x00003c50003f0106ULL, 0x0000f64c0000004aULL,
0x00004c40003f0106ULL, 0x0000002000000009ULL, 0x00004cd0003f0101ULL, 0x0000000000000018ULL,
0x00004d60003f0101ULL, 0x0000002400000009ULL, 0x00004dc0003f0106ULL, 0x0000002400000009ULL,
0x00004e50003f0106ULL, 0x0000002400000009ULL, 0x00005290003f0106ULL, 0x0000000000000068ULL,
0x0000530000040107ULL, 0x0000000400000020ULL, 0x00005320003f0106ULL, 0x0000f62c00000012ULL,
0x00005460003f0106ULL, 0x0000f62c00000012ULL, 0x000058f0003f0106ULL, 0x0000f64c00000018ULL,
0x000059d0003f0106ULL, 0x000000040000001aULL, 0x00006990003f0106ULL, 0x0000002000000009ULL,
0x00006a10003f0101ULL, 0x0000000000000018ULL, 0x00006ab0003f0101ULL, 0x0000002400000009ULL,
0x00006b00003f0106ULL, 0x0000002400000009ULL, 0x00006b90003f0106ULL, 0x0000002400000009ULL,
0x00006eb0003f0106ULL, 0x00000000000000ffULL, 0x00006f2000060107ULL, 0x000000040000005eULL,
0x00006f40003f0106ULL, 0x0000f63c00000012ULL, 0x00007020003f0106ULL, 0x0000f63c00000012ULL,
0x000074c0003f0106ULL, 0x0000f64c0000000dULL, 0x00007550003f0106ULL, 0x0000000400000061ULL,
0x00008450003f0106ULL, 0x0000002000000009ULL, 0x000084b0003f0101ULL, 0x0000f64000000012ULL,
0x0000d250003f0101ULL, 0x0000f604000000ffULL, 0x0000d2e0003f0106ULL, 0x0000f604000000ffULL,
0x0000d500003f0106ULL, 0x0000f600000000ffULL, 0x0000d510003f0101ULL, 0x0000f604000000ffULL,
0x0000d590003f0106ULL, 0x0000f604000000ffULL, 0x0000f500003f0106ULL, 0x0000f61400000034ULL,
0x0000f8c0003f0106ULL, 0x0000f61400000034ULL, 0x00010d00003f0106ULL, 0x0000f60800000034ULL,
0x00053803003f0101ULL, 0x0000c0c000141c04ULL, 0x0000d5e00000c510ULL, 0x00010d600000d6b0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff177624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x00000000004f7919ULL, 0x000ea80000002100ULL, 0x00000000000a7919ULL, 0x000ee80000002700ULL,
0x0000000000157919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000b7824ULL, 0x104fe200078e024fULL, 0x00000005ff4f7819ULL, 0x000fe2000001164fULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0b00720cULL, 0x040fe40003f05270ULL,
0x000000030b00780cULL, 0x040fe20003f44070ULL, 0x00001fff4f4f7589ULL, 0x000ea200000e0000ULL,
0x0000007f0b00780cULL, 0x040fe20003f24070ULL, 0x000062000a067625ULL, 0x008fe200078e0011ULL,
0x000000010b00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0ca424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0da424ULL, 0x000fe200078e00ffULL, 0x00f608040b00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6100c0b00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f648080b00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f400100b009388ULL, 0x0007e80000004800ULL,
0x00f6680e0b00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x01ce620000000000ULL,
0x000000044f047824ULL, 0x000fc400078e00ffULL, 0x0000001017037824ULL, 0x000fe400078e00ffULL,
0x0000001015027824ULL, 0x000fe400078e00ffULL, 0x00000100ff107424ULL, 0x000fe400078e00ffULL,
0x0000000a03027224ULL, 0x000fe200078e0202ULL, 0x000000040e097211ULL, 0x042fe200078fe0ffULL,
0x000000100e047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709057812ULL, 0x000fe400078ec0ffULL,
0x000000070b0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x000fe200078e0010ULL,
0x0000000f05087812ULL, 0x000fc600078e780eULL, 0x00005c000c047625ULL, 0x000fe200078e0010ULL,
0x0000000f0d0c7812ULL, 0x000fe400078e780eULL, 0x0000000f02027210ULL, 0x080fe20007f1e0ffULL,
0x0000001009087824ULL, 0x000fe200078e0208ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0c7824ULL, 0x000fe400078e020cULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001008097824ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008064c7981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff4e7e24ULL, 0x010fe2000f8e00ffULL, 0x0000007f4c4d7810ULL, 0x004fc40007ffe0ffULL,
0x000000ff4c477810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff4d7819ULL, 0x000fe4000001164dULL,
0x00000008ff477819ULL, 0x000fca0000011647ULL, 0x0000bfc000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001164fULL, 0x000000104f447824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x000fe200078e00ffULL, 0x01ffffff00037812ULL, 0x00afca00078ec0ffULL,
0x000000024e007824ULL, 0x000fca00078e0203ULL, 0x0000004d0000720cULL, 0x000fda0003f06070ULL,
0x000000020a028824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002038624ULL, 0x000fe400078e0203ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x0000000100038824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140744ff738cULL, 0x0003e20000000000ULL, 0x0000600003048625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000804028981ULL, 0x0004e2000c1e1900ULL,
0x00000001ff457819ULL, 0x000fe2000001164fULL, 0x00000080ff187424ULL, 0x000fe200078e00ffULL,
0x000000014e067810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000f220000000000ULL,
0x000000014f467812ULL, 0x000fe200078ec0ffULL, 0x00000000450473c2ULL, 0x000f6200000e0000ULL,
0x000000470600720cULL, 0x000fe20003f06070ULL, 0x00f6100044ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000084e047824ULL, 0x004fe200078e0245ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000001046087824ULL, 0x000fe200078e00ffULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000002004067824ULL, 0x000fe200078e00ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000064c057217ULL, 0x000fe20007800000ULL, 0x000000ffff397224ULL, 0x000fc800078e00ffULL,
0x0000000105057824ULL, 0x000fe200078e0a06ULL, 0x00000003ff097819ULL, 0x010fe20000011603ULL,
0x00000010031f7824ULL, 0x000fc600078e00ffULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000f64804047891ULL, 0x020fe2000f8e203fULL, 0x00000004090f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080c7824ULL, 0x040fe200078e0209ULL, 0x0000000c09147810ULL, 0x040fe40007ffe0ffULL,
0x0000000809137810ULL, 0x000fe20007ffe0ffULL, 0x0000000108107824ULL, 0x000fe200078e020fULL,
0x000000030c077212ULL, 0x0c2fe200078e3cffULL, 0x000000080c0e7824ULL, 0x000fe200078e00ffULL,
0x000000701f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000108167824ULL, 0x000fe200078e0214ULL,
0x0000000310047212ULL, 0x0c0fe200078e3cffULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee207ULL, 0x0000000108127824ULL, 0x000fe200078e0213ULL,
0x00000003160b7212ULL, 0x0c0fe200078e3cffULL, 0x00000008160e7824ULL, 0x000fe200078e00ffULL,
0x0000000805077217ULL, 0x000fe20007800000ULL, 0x0000000812197824ULL, 0x040fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee204ULL, 0x0000008015057824ULL, 0x000fe200078e00ffULL,
0x0000000312047212ULL, 0x000fc400078e3cffULL, 0xfffffff80e1b7812ULL, 0x000fe200078ee20bULL,
0x00000001070b7824ULL, 0x000fe200078e0a08ULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x0000200045047824ULL, 0x000fe200078e00ffULL, 0x0000006005067812ULL, 0x000fe200078ef806ULL,
0x0000008017077824ULL, 0x000fe200078e00ffULL, 0x0000000b0900720cULL, 0x000fe40003f46070ULL,
0x0000007f0c097812ULL, 0x000fe400078ec0ffULL, 0x0000b000040e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000b0f00720cULL, 0x080fe40003f26070ULL, 0x0000000b1300720cULL, 0x000fe20003f06070ULL,
0x000000100d157824ULL, 0x100fe200078e020eULL, 0x0000007f100d7812ULL, 0x000fe200078ec0ffULL,
0x0000001011177824ULL, 0x100fe200078e020eULL, 0x0000007f12117812ULL, 0x000fe200078ec0ffULL,
0x000000101b1d7824ULL, 0x100fe200078e020eULL, 0x0000007f161b7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x000fe400078e020eULL, 0x0000000702067224ULL, 0x008fc800078e0206ULL,
0x0000000106097824ULL, 0x040fe400078e0209ULL, 0x00000001060d7824ULL, 0x000fe400078e020dULL,
0x00005e0009087625ULL, 0x000fc800078e0018ULL, 0x00000001060e7824ULL, 0x000fe200078e0211ULL,
0x0000001f08127210ULL, 0x000fe20007f7e0ffULL, 0x0000000106107824ULL, 0x000fe400078e021bULL,
0x00005e000d0c7625ULL, 0x000fc800078e0018ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0018ULL,
0x0000001f0c0c7210ULL, 0x000fc60007f9e0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0018ULL,
0x0000001f0e0e7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0609ULL,
0x0000000b1400720cULL, 0x000fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000001f10107210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000d101c48ULL,
0xff317217ff067424ULL, 0x000fe200078e00ffULL, 0x0000f64845097811ULL, 0x000fe200078e18ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000000c177faeULL, 0x0003e2000c901c48ULL,
0x000000ffff087224ULL, 0x000fc600078e00ffULL, 0x000000000e197faeULL, 0x0003e2000c101c48ULL,
0x000000474e00720cULL, 0x000fc60003f06070ULL, 0x00000000101d7faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200009ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000077b000000947ULL, 0x000fea0003800000ULL, 0x000000020a0b7824ULL, 0x004fe200078e00ffULL,
0x00007610ff487816ULL, 0x000fe20000000048ULL, 0x00006400ff0a7624ULL, 0x000fe200078e00ffULL,
0x00007610ff4b7816ULL, 0x000fe2000000004bULL, 0xff317217ff067424ULL, 0x000fc400078e00ffULL,
0x000064000b0b7624ULL, 0x000fe200078e020aULL, 0x00007610ff0a7816ULL, 0x000fe2000000000aULL,
0x000000ffff497224ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0xffffffc0440d7812ULL, 0x002fca00078ec0ffULL, 0x000001004e0d7824ULL, 0x000fca00078e020dULL,
0x0000004c0d00720cULL, 0x000fda0003f06070ULL, 0x0000768000000947ULL, 0x020fea0003800000ULL,
0x00002400090d7984ULL, 0x000e620000000800ULL, 0x0000ffff480c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6a7224ULL, 0x000fc600078e0000ULL, 0x000088800c107816ULL, 0x000fe200000000ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0049ULL, 0x80000000100e7824ULL, 0x000fca00078e00ffULL,
0x800000000dff7812ULL, 0x002fe2000780480eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000076104b697816ULL, 0x000fe40000000069ULL, 0x00007610480d7816ULL, 0x000fe2000000000dULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00002400090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000010107824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x00002400090f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007804810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000300ff5f7624ULL, 0x000fe200078e00ffULL, 0x00000001000e7812ULL, 0x000fe200078ec0ffULL,
0x000001004e647824ULL, 0x000fe200078e00ffULL, 0x00000001ff457819ULL, 0x000fe4000001164fULL,
0x000000010e00780cULL, 0x000fe40003f05070ULL, 0xffffffff5f5f7811ULL, 0x000fe200078e08ffULL,
0x00000020450e7824ULL, 0x000fc600078e0264ULL, 0x000000015f5f7807ULL, 0x000fe40004000000ULL,
0x000000400e107810ULL, 0x000fc60007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e025fULL,
0x00000060050e7812ULL, 0x000fc800078ef810ULL, 0x0000004d0000720cULL, 0x000fe20003f06070ULL,
0x0000000702187224ULL, 0x000fe200078e020eULL, 0x00000003ff197819ULL, 0x000fe20000011603ULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x0000001044167812ULL, 0x000fe400078ec0ffULL,
0x0000000419517810ULL, 0x000fce0007ffe0ffULL, 0x0000005f0b0f8210ULL, 0x000fe20007ffe06aULL,
0x00000004ff128424ULL, 0x000fe200078e00ffULL, 0x000000104c117217ULL, 0x000fe20007800000ULL,
0x00000001511a7824ULL, 0x000fe400078e0216ULL, 0x000060000f0e8625ULL, 0x000fe200078e0012ULL,
0x000000014e127810ULL, 0x000fc60007ffe0ffULL, 0x0000000119147824ULL, 0x000fe200078e0216ULL,
0x000000080e028981ULL, 0x000362000c1e1900ULL, 0x000000031a5c7212ULL, 0x000fe200078e3cffULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x000000471200720cULL, 0x000fe20003f06070ULL,
0x00000008141c7824ULL, 0x040fe200078e00ffULL, 0x0000000314137212ULL, 0x000fe200078e3cffULL,
0x000000084f4a7824ULL, 0x000fe200078e00ffULL, 0x0000000819537810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000000c19557810ULL, 0x000fe20007ffe0ffULL,
0x000000081a0f7824ULL, 0x002fe200078e00ffULL, 0x0000007f140e7812ULL, 0x000fe200078ec0ffULL,
0x0000001003217824ULL, 0x000fe200078e00ffULL, 0xfffffff81c637812ULL, 0x000fe200078ee213ULL,
0x00000008491f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f5c7812ULL, 0x000fe200078ee25cULL,
0x0000000118107824ULL, 0x000fe200078e020eULL, 0x00000020110f7807ULL, 0x000fe20000000000ULL,
0x00000001531c7824ULL, 0x000fe200078e0216ULL, 0xfffffff04a4a7812ULL, 0x000fe200078ec0ffULL,
0x00005e0010107625ULL, 0x000fe200078e001dULL, 0x000000160f0f7217ULL, 0x000fc40007800000ULL,
0x0000007021237812ULL, 0x000fe200078ec0ffULL, 0x00000001551e7824ULL, 0x100fe200078e0216ULL,
0x000000081f687812ULL, 0x000fe200078e0cffULL, 0x000000081c127824ULL, 0x040fe200078e00ffULL,
0x000000004a0473c2ULL, 0x000e6200000e0000ULL, 0x000000010f167824ULL, 0x000fe200078e0a16ULL,
0x000000031c5b7212ULL, 0x000fe200078e3cffULL, 0x000000081e137824ULL, 0x000fe200078e00ffULL,
0x0000007f1a0f7812ULL, 0x000fe400078ec0ffULL, 0x0000002310147210ULL, 0x000fe20007f1e0ffULL,
0x0000100049107824ULL, 0x000fe200078e00ffULL, 0x00000000680573c2ULL, 0x000ea200000e0000ULL,
0x000000031e5a7212ULL, 0x000fc400078e3cffULL, 0xfffffff8125b7812ULL, 0x000fe200078ee25bULL,
0x0000000118127824ULL, 0x000fe200078e020fULL, 0xfffffff8135a7812ULL, 0x000fe200078ee25aULL,
0x000000ffff157224ULL, 0x000fe200000e0611ULL, 0x00001000101a7812ULL, 0x000fe200078e0cffULL,
0x00005e0012127625ULL, 0x000fe200078e001dULL, 0x0000007f1c107812ULL, 0x000fe400078ec0ffULL,
0x0000007f1e117812ULL, 0x000fe400078ec0ffULL, 0x000000161900720cULL, 0x080fe20003f06070ULL,
0x0000000118197824ULL, 0x000fe200078e0210ULL, 0x00000023121c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001181b7824ULL, 0x000fe200078e0211ULL, 0x000000165100720cULL, 0x080fe20003f26070ULL,
0x0000200045127824ULL, 0x000fe200078e021aULL, 0x000000165500720cULL, 0x000fe20003f66070ULL,
0x00005e0019187625ULL, 0x000fe200078e001dULL, 0x0000f64804047890ULL, 0x002fc4000fffe03fULL,
0x0000b00012127810ULL, 0x000fe20007ffe0ffULL, 0x00005e001b1a7625ULL, 0x000fe200078e001dULL,
0x0000002318187210ULL, 0x080fe20007f9e0ffULL, 0x0000000504057290ULL, 0x004fe4000fffe03fULL,
0x000000ffff1d7224ULL, 0x000fe200010e0613ULL, 0x000000165300720cULL, 0x000fe20003f46070ULL,
0x0000001063637824ULL, 0x100fe200078e0212ULL, 0x000000231a1a7210ULL, 0x000fe20007fbe0ffULL,
0x000000105c627824ULL, 0x100fe400078e0212ULL, 0x000000ffff197224ULL, 0x000fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014637faeULL, 0x0003e2000c101c48ULL,
0x000000105b617824ULL, 0x000fc400078e0212ULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x000000001c627faeULL, 0x0003e2000c901c48ULL, 0x000000105a607824ULL, 0x000fe400078e0212ULL,
0x000000044f127824ULL, 0x000fe200078e00ffULL, 0x0000000018617faeULL, 0x0003e8000d101c48ULL,
0x000000001a607faeULL, 0x0003e2000d901c48ULL, 0xfffffff012127812ULL, 0x000fc600078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004041f157984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c0012197984ULL, 0x000ee20000000800ULL,
0x0000ffff4b137812ULL, 0x000fe400078ec0ffULL, 0x0000ffff0a147812ULL, 0x000fe400078ec0ffULL,
0x0000888013207816ULL, 0x000fc400000000ffULL, 0x0000888014137816ULL, 0x000fc600000000ffULL,
0x8000000020147824ULL, 0x000fe400078e00ffULL, 0x8000000013167824ULL, 0x000fc600078e00ffULL,
0x8000000015ff7812ULL, 0x004fe40007804814ULL, 0x8000000019ff7812ULL, 0x008fe20007824816ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fe400078e00ffULL, 0x8000000013167824ULL, 0x000fe400078e00ffULL,
0x0000001400157305ULL, 0x0004e4000021f000ULL, 0x3fa0000014147823ULL, 0x004fe200000100ffULL,
0x000000150000735dULL, 0x008fe40003800000ULL, 0x00f60c0012157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fc40007824816ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000204f157824ULL, 0x000fe200078e00ffULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000001ff7f7424ULL, 0x000fe200078e00ffULL,
0x0000007021147812ULL, 0x000fe400078ec0ffULL, 0xffffff8015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c16167812ULL, 0x000fc800078ec0ffULL, 0x0000001516187210ULL, 0x000fca0007ffe014ULL,
0x00f0000018197984ULL, 0x000ea80000000800ULL, 0x00f20000181a7984ULL, 0x0007220000000800ULL,
0x000000061900720bULL, 0x004fda0003f3d000ULL, 0x00000000001b7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1b1b7812ULL, 0x000fda000782c0ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000061900720bULL, 0x018fe40003f34000ULL, 0x0000001906227209ULL, 0x000fe40007810000ULL,
0x00000002ff1d7819ULL, 0x000fc60000011603ULL, 0x8000002206187221ULL, 0x100fe20000010000ULL,
0x00000002ff067819ULL, 0x000fe4000001164fULL, 0x000000081d1e7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b181c7820ULL, 0x000fe40000410000ULL, 0x0000000000187806ULL, 0x000fe400008e0100ULL,
0x0000004f0600720cULL, 0x000fe20003f25270ULL, 0x0000001c00217308ULL, 0x000ea20000000800ULL,
0x0000ffff18187812ULL, 0x000fe200078e3cffULL, 0x000000ffff067224ULL, 0x000fc600078e0022ULL,
0x000000181bff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff7f7807ULL, 0x000fc60001000000ULL,
0x000000804f1b9824ULL, 0x000fc800078e0214ULL, 0x00000001161b9824ULL, 0x000fe200078e021bULL,
0x00001f1e211e7589ULL, 0x004ea200000e0000ULL, 0x8000002219192221ULL, 0x000fe20000010000ULL,
0x0000002108087220ULL, 0x000fe40000410000ULL, 0x00001f1d211d7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b19192820ULL, 0x000fc60000410000ULL, 0x00f400221b009388ULL, 0x0009e20000000800ULL,
0x0000001900172308ULL, 0x000e620000000800ULL, 0x0000001e27277220ULL, 0x084fe20000410000ULL,
0x0000001e26267220ULL, 0x080fe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e42427220ULL, 0x080fe20000410000ULL, 0x0000001e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001e37377220ULL, 0x080fe20000410000ULL,
0x0000001e36367220ULL, 0x080fe20000410000ULL, 0x0000001e33337220ULL, 0x080fe20000410000ULL,
0x0000001e32327220ULL, 0x080fe20000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001e2a2a7220ULL, 0x000fe20000410000ULL, 0x0000001d25257220ULL, 0x088fe20000410000ULL,
0x0000001d24247220ULL, 0x080fe20000410000ULL, 0x0000001d41417220ULL, 0x080fe20000410000ULL,
0x0000001d40407220ULL, 0x080fe20000410000ULL, 0x0000001d3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001d3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001d39397220ULL, 0x080fe20000410000ULL,
0x0000001d38387220ULL, 0x080fe20000410000ULL, 0x0000001d35357220ULL, 0x080fe20000410000ULL,
0x0000001d34347220ULL, 0x080fe20000410000ULL, 0x0000001d31317220ULL, 0x080fe20000410000ULL,
0x0000001d30307220ULL, 0x080fe20000410000ULL, 0x0000001d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001d29297220ULL, 0x080fe20000410000ULL,
0x0000001d28287220ULL, 0x000fe20000410000ULL, 0x000000171a1a2220ULL, 0x002fc80000410000ULL,
0x000000081a087221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x000004041f187984ULL, 0x000ea20008000800ULL, 0x8000000020197824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x004fe20007804819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000020207824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0004e4000021f000ULL,
0x3fa0000018187823ULL, 0x004fe200000100ffULL, 0x000000190000735dULL, 0x008fe40003800000ULL,
0x000004041f197984ULL, 0x000ea40008000800ULL, 0x8000000019ff7812ULL, 0x004fc40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000044f1a7824ULL, 0x000fe200078e00ffULL, 0x0000000803187812ULL, 0x000fe200078ec0ffULL,
0x000010004f197824ULL, 0x000fe200078e00ffULL, 0x0000000703847812ULL, 0x000fe200078ec0ffULL,
0x0000100049507824ULL, 0x000fe200078e0204ULL, 0x000000041a1a7812ULL, 0x000fe200078ec0ffULL,
0x000002004f987824ULL, 0x000fe200078e00ffULL, 0xffffe000191c7812ULL, 0x000fe400078ec0ffULL,
0x0000000718197812ULL, 0x140fe400078ec803ULL, 0x0000001a031a7211ULL, 0x000fe200078fe0ffULL,
0x00001000491c7824ULL, 0x000fe200078e021cULL, 0x0000000718187812ULL, 0x000fc400078ef803ULL,
0x0000001a19677212ULL, 0x000fe400078e3cffULL, 0x0000b0001c1b7810ULL, 0x000fe40007ffe0ffULL,
0x0000008018667811ULL, 0x040fe200078e18ffULL, 0x0000000818547824ULL, 0x000fe200078e0267ULL,
0x0000b00050507810ULL, 0x000fe40007ffe0ffULL, 0x000000021a1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010541c7824ULL, 0x000fe200078e021bULL, 0x0000000884847812ULL, 0x000fe200078ef803ULL,
0x0000000167677824ULL, 0x000fe200078e0266ULL, 0xfffff80098987812ULL, 0x000fc400078ec0ffULL,
0x00000002ff997819ULL, 0x000fe20000011603ULL, 0x000000001c1c783bULL, 0x002e620000004200ULL,
0x0000001067207824ULL, 0x000fcc00078e0250ULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x000001001c517824ULL, 0x042fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe2000001141cULL,
0x000001001d597824ULL, 0x000fe200078e00ffULL, 0x000088801c527816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe40000011451ULL,
0x0000001a19517212ULL, 0x000fe200078e3cffULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff557819ULL, 0x004fe20000011420ULL,
0x0000000818537824ULL, 0x000fe200078e0251ULL, 0x0000888020787816ULL, 0x000fe200000000ffULL,
0x0000000151667824ULL, 0x000fe200078e0266ULL, 0x00000018ff7a7819ULL, 0x000fe2000001141dULL,
0x00000010531b7824ULL, 0x000fe200078e021bULL, 0x0000001c00947306ULL, 0x0003e20000200c00ULL,
0x000088801d797816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x000000001b18783bULL, 0x000ea20000004200ULL,
0x00000018ff587819ULL, 0x000fc40000011421ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000001001e1c7824ULL, 0x002fe200078e00ffULL, 0x0000888021747816ULL, 0x000fe200000000ffULL,
0x0000005900967306ULL, 0x0003e20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011422ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff577819ULL, 0x000fe40000011423ULL,
0x0000888022727816ULL, 0x000fe200000000ffULL, 0x0000001c006c7306ULL, 0x0007e20000200c00ULL,
0x000001001f597824ULL, 0x002fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fc4000001141eULL,
0x00000018ff7c7819ULL, 0x000fe4000001141fULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000001d00957306ULL, 0x0003e20000200c00ULL, 0x00000100201c7824ULL, 0x008fe200078e00ffULL,
0x000088801e7b7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x000088801f6d7816ULL, 0x000fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe2000001141cULL, 0x00000010661c7824ULL, 0x000fe200078e0250ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x00000100211d7824ULL, 0x042fe200078e00ffULL,
0x0000005900927306ULL, 0x0003e20000200c00ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000010022507824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001141dULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000002000767306ULL, 0x0007e20000200c00ULL, 0x0000888023597816ULL, 0x002fe200000000ffULL,
0x000001001a807824ULL, 0x004fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff897819ULL, 0x000fe20000011418ULL,
0x0000002100737306ULL, 0x000fe20000200c00ULL, 0x0000010023207824ULL, 0x048fe200078e00ffULL,
0x00008880188f7816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005000717306ULL, 0x000fe20000200c00ULL, 0x00000018ff237819ULL, 0x000fc40000011423ULL,
0x00000018ff837819ULL, 0x000fe40000011419ULL, 0x0000888019827816ULL, 0x000fe400000000ffULL,
0x0000000899517810ULL, 0x000fe20007ffe0ffULL, 0x0000002000707306ULL, 0x0003e20000200c00ULL,
0x00000018ff877819ULL, 0x000fe40000011480ULL, 0x00000018ff7e7819ULL, 0x000fe4000001141aULL,
0x000088801a887816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001141bULL, 0x00000022006f7306ULL, 0x000fe20000200c00ULL,
0x0000010018207824ULL, 0x042fe200078e00ffULL, 0x000088801b817816ULL, 0x000fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fc4000001141aULL,
0x00000018ff8e7819ULL, 0x000fe20000011420ULL, 0x000000024f207824ULL, 0x000fe200078e00ffULL,
0x00000023006e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff8c7819ULL, 0x000fe40000011418ULL,
0x00000017ff18723eULL, 0x000fe400000000ffULL, 0x0000000420207812ULL, 0x000fe400078ec0ffULL,
0x00005410189a7816ULL, 0x000fe20000000018ULL, 0x0000001e00907306ULL, 0x000fe20000200c00ULL,
0x0000002003857211ULL, 0x000fe200078fe0ffULL, 0x0000010019207824ULL, 0x000fc400078e00ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x0000000785217812ULL, 0x040fe200078e7884ULL,
0x00001f519a807589ULL, 0x000fe200000e0000ULL, 0x00000018ff8d7819ULL, 0x000fe20000011420ULL,
0x0000001f00917306ULL, 0x0003e20000200c00ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000000884217824ULL, 0x000fe200078e0221ULL, 0x0000000285857810ULL, 0x000fe20007ffe0ffULL,
0x000001001b187824ULL, 0x000fe400078e00ffULL, 0x0000001021507824ULL, 0x000fc400078e0298ULL,
0x00000019008a7306ULL, 0x0005e20000200c00ULL, 0x000000001c1c783bULL, 0x002e620000004200ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000100001b1b7824ULL, 0x000fe400078e00ffULL,
0x009000005020783bULL, 0x000fe60000000200ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000099107f197816ULL, 0x004fe400000000ffULL, 0x00001f999a7f7589ULL, 0x0004e200000e0000ULL,
0x00000018ff1b7819ULL, 0x000fc4000001141bULL, 0x000000ff1900720cULL, 0x000fe40003f05270ULL,
0x0000009700977306ULL, 0x000fe20000200c00ULL, 0x0000000785197812ULL, 0x000fca00078e7884ULL,
0x0000000884997824ULL, 0x004fe400078e0219ULL, 0x0000007900797306ULL, 0x000eb00000200c00ULL,
0x0000007a007a7306ULL, 0x000ff00000200c00ULL, 0x0000007b007b7306ULL, 0x000f220000200c00ULL,
0x0000541079197816ULL, 0x004fc40000000096ULL, 0x00000018ff657819ULL, 0x002fe2000001141cULL,
0x0000007f20208232ULL, 0x088fe20000000000ULL, 0x000088801c9a7816ULL, 0x000fe200000000ffULL,
0x0000007f22228232ULL, 0x000fe40000000000ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000008021218232ULL, 0x080fe20000000000ULL, 0x00000018ff6b7819ULL, 0x000fe2000001141dULL,
0x0000008023238232ULL, 0x000fe20000000000ULL, 0x00000018ff5e7819ULL, 0x000fe2000001141eULL,
0x000000ffff797224ULL, 0x000fe200078e009aULL, 0x00000018ff5d7819ULL, 0x000fc4000001141fULL,
0x0000001800867306ULL, 0x0005e20000200c00ULL, 0x000054107b6c7816ULL, 0x010fce000000006cULL,
0x0000008b008b7306ULL, 0x000ee20000200c00ULL, 0x0000541052187816ULL, 0x004fe20000000097ULL,
0x0000001099527824ULL, 0x000fe200078e0298ULL, 0x000054106d6d7816ULL, 0x002fe20000000092ULL,
0x000001001d927824ULL, 0x000fc800078e00ffULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x000000182028723cULL, 0x040fee0000001828ULL, 0x0000541094187816ULL, 0x000fe20000000093ULL,
0x0000001a00857306ULL, 0x0005e20000200c00ULL, 0x0000541095197816ULL, 0x000fe2000000007aULL,
0x0000006c2030723cULL, 0x000fe20000001830ULL, 0x000088801d937816ULL, 0x000fca00000000ffULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x000001001c1a7824ULL, 0x004fe200078e00ffULL,
0x00000018202c723cULL, 0x040fe2000000182cULL, 0x00005410906c7816ULL, 0x008fe2000000008bULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00005410916d7816ULL, 0x002fe2000000007cULL,
0x000000ffff7b7224ULL, 0x000fe200078e0093ULL, 0x00000018ff7a7819ULL, 0x000fe2000001141aULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff7c7819ULL, 0x000fe20000011492ULL, 0x0000006c2034723cULL, 0x000fe80000001834ULL,
0x0000008200827306ULL, 0x000ff00000200c00ULL, 0x0000008d008d7306ULL, 0x000ea20000200c00ULL,
0x000054108f6c7816ULL, 0x002fce000000008eULL, 0x0000001b00847306ULL, 0x0003f00000200c00ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x009000005218783bULL, 0x002e620000000200ULL,
0x00005410826d7816ULL, 0x004fcc000000008dULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x0000006c2038723cULL, 0x000fee0000001838ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x000100001d6c7824ULL, 0x000fce00078e00ffULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x000054108a1d7816ULL, 0x004fce0000000083ULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x00005410816d7816ULL, 0x008fe20000000086ULL,
0x0000007f18188232ULL, 0x082fe20000000000ULL, 0x000088801e817816ULL, 0x000fe200000000ffULL,
0x0000007f1a1a8232ULL, 0x000fc40000000000ULL, 0x0000008019198232ULL, 0x080fe40000000000ULL,
0x0000001c00827306ULL, 0x0003e20000200c00ULL, 0x000000801b1b8232ULL, 0x000fce0000000000ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000054108c1c7816ULL, 0x002fce0000000089ULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x0000001c203c723cULL, 0x000fee000000183cULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001146cULL,
0x00005410851c7816ULL, 0x004fca000000007eULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x00005410886c7816ULL, 0x002fce0000000087ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000006c2040723cULL, 0x000fee0000001840ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000001001e6d7824ULL, 0x040fe400078e00ffULL, 0x000100001e1e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x000fc600078e0081ULL, 0x0000001d00867306ULL, 0x0007e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00005410841d7816ULL, 0x008fce000000007dULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x0000001c2024723cULL, 0x000fee0000001824ULL, 0x00005410781c7816ULL, 0x004fe20000000077ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00005410741d7816ULL, 0x002fc40000000075ULL,
0x000088801f207816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc6000001146dULL,
0x0000001c1828723cULL, 0x000fe20000001828ULL, 0x0000005600567306ULL, 0x000e6c0000200c00ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410731d7816ULL, 0x008fe20000000058ULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c006d7306ULL, 0x0007e20000200c00ULL,
0x000054106f567816ULL, 0x002fce0000000056ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x00005410761c7816ULL, 0x008fe20000000055ULL, 0x000001004e557824ULL, 0x000fe200078e00ffULL,
0x000054106e577816ULL, 0x004fca0000000057ULL, 0x0000001c182c723cULL, 0x000fe2000000182cULL,
0x0000001e001d7306ULL, 0x0004e20000200c00ULL, 0x0000541072587816ULL, 0x002fce0000000071ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000002ff1e7819ULL, 0x004fe2000001164fULL,
0x000000561834723cULL, 0x000fec0000001834ULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x000054101d1c7816ULL, 0x008fce000000005eULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x0000541059597816ULL, 0x002fce0000000070ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x004fe20000000065ULL, 0x000000581830723cULL, 0x000fec0000001830ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000541086837816ULL, 0x008fce000000006bULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x00000082183c723cULL, 0x000fee000000183cULL,
0x0000007b007b7306ULL, 0x000ff00000200c00ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00005410797a7816ULL, 0x002fce000000007aULL, 0x0000006c006c7306ULL, 0x000ff00000200c00ULL,
0x0000002100217306ULL, 0x000e620000200c00ULL, 0x000054107b7b7816ULL, 0x004fce000000007cULL,
0x0000002000207306ULL, 0x000ea20000200c00ULL, 0x0000007a1838723cULL, 0x000fee0000001838ULL,
0x0000001f00227306ULL, 0x000ee20000200c00ULL, 0x000054106c6c7816ULL, 0x002fe40000000021ULL,
0x000054106d6d7816ULL, 0x004fce0000000020ULL, 0x0000006c1840723cULL, 0x000fe20000001840ULL,
0x00005410221d7816ULL, 0x008fce000000005dULL, 0x0000001c1824723cULL, 0x000fee0000001824ULL,
0x0000f6101e187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200009ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000401e197824ULL, 0x000fe200078e0255ULL, 0x000000ff4bff7812ULL, 0x000fe2000780c0ffULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff48ff7812ULL, 0x000fc4000784c0ffULL,
0x0000004019197810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff6c7807ULL, 0x000fe40000000000ULL,
0x0000004c1900720cULL, 0x000fe40003f06070ULL, 0x000000014900780cULL, 0x000fe40003f25270ULL,
0x00000001ff657807ULL, 0x000fe40001000000ULL, 0x0000004b6c4b7207ULL, 0x000fc40004800000ULL,
0x0000761065487816ULL, 0x000fe40000000048ULL, 0x0000000149497812ULL, 0x000fc600078e0cffULL,
0x0000551000000947ULL, 0x000fea0003800000ULL, 0x0000240009197984ULL, 0x004ea20000000800ULL,
0x8000000065187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x004fe20007804818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000240009197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000651a7824ULL, 0x000fe400078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x0000240009197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fc4000780481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001ff457819ULL, 0x000fe2000001164fULL,
0x000000080c6b7824ULL, 0x000fe200078e00ffULL, 0x000000014e187810ULL, 0x000fe20007ffe0ffULL,
0x00005800021e7a24ULL, 0x020fe200078e02ffULL, 0x00000010441d7812ULL, 0x000fe200078ec0ffULL,
0x00000020451b7824ULL, 0x000fe200078e0264ULL, 0x000000471800720cULL, 0x000fe20003f06070ULL,
0x000010000c6d7824ULL, 0x000fe200078e00ffULL, 0x0000001d03187211ULL, 0x000fe200078fe8ffULL,
0x00000080ff237424ULL, 0x000fe200078e00ffULL, 0x000000801b1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000086b1a7812ULL, 0x000fe400078ec0ffULL, 0x0000001b4c1c7217ULL, 0x000fe40007800000ULL,
0x0000f648451f7811ULL, 0x000fe200078e20ffULL, 0x000000001a0773c2ULL, 0x0004e200000e0000ULL,
0x0000000318197212ULL, 0x000fe200078e3cffULL, 0x000000011c1c7824ULL, 0x100fe200078e0a1bULL,
0x00000060051b7812ULL, 0x000fe200078ef81bULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000086b5e7812ULL, 0x000fc400078e0cffULL, 0x000000201c1c7807ULL, 0x000fe20000000000ULL,
0x000000001f0673c2ULL, 0x0008e200000e0000ULL, 0x000000801e1b7824ULL, 0x000fe200078e021bULL,
0xfffffff8185d7812ULL, 0x000fe200078ee219ULL, 0x000000011f5e7824ULL, 0x000fe200078e025eULL,
0x0000001c1d1c7217ULL, 0x000fe20007800000ULL, 0x000000010e187824ULL, 0x000fe200078e021bULL,
0x00000003ff197819ULL, 0x000fe20000011603ULL, 0x000000010f1e7824ULL, 0x000fe200078e021bULL,
0x000010006d1a7812ULL, 0x004fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a1dULL,
0x0000000c191d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000419217810ULL, 0x000fe20007ffe0ffULL,
0x00002000451a7824ULL, 0x000fe200078e021aULL, 0x00000008191f7810ULL, 0x050fe40007ffe0ffULL,
0x0000001c1900720cULL, 0x080fe20003f66070ULL, 0x00005e0018187625ULL, 0x080fe200078e0023ULL,
0x0000001c2100720cULL, 0x080fe40003f46070ULL, 0x0000001c1f00720cULL, 0x080fe20003f26070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0023ULL, 0x0000001c1d00720cULL, 0x000fc40003f06070ULL,
0x0000001418187210ULL, 0x000fe20007f9e0ffULL, 0x00000001101c7824ULL, 0x100fe200078e021bULL,
0x0000b0001a207810ULL, 0x000fe20007ffe0ffULL, 0x00000001111b7824ULL, 0x000fe200078e021bULL,
0x0000000706067290ULL, 0x008fe2000fffe03fULL, 0x00005e001c1c7625ULL, 0x000fc800078e0023ULL,
0x00005e001b1a7625ULL, 0x000fe200078e0023ULL, 0x000000141c1c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x000000141e1e7210ULL, 0x080fe20007f9e0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e0220ULL, 0x000000141a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000105c5c7824ULL, 0x100fe400078e0220ULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000185d7faeULL, 0x0005e2000d901c48ULL,
0x000000105b5b7824ULL, 0x100fe400078e0220ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000001e5c7faeULL, 0x0005e2000d101c48ULL, 0x000000105a5a7824ULL, 0x000fc400078e0220ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x000000001c5b7faeULL, 0x0005e8000c901c48ULL,
0x000000001a5a7faeULL, 0x0005e8000c101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005e197984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c00121a7984ULL, 0x000f220000000800ULL, 0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL,
0x80000000131b7824ULL, 0x000fc600078e00ffULL, 0x000088804b187816ULL, 0x000fca00000000ffULL,
0x8000000018187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe40007804818ULL,
0x800000001aff7812ULL, 0x010fe2000782481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x000000044f127824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000131a7824ULL, 0x000fe200078e00ffULL,
0xfffffff012127812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f61c0012197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000008014197810ULL, 0x000fe20007ffe015ULL, 0x00000001ff777424ULL, 0x000fc800078e00ffULL,
0x0000000116197824ULL, 0x000fca00078e0219ULL, 0x00f00000191b7984ULL, 0x000ee80000000800ULL,
0x00f2000019187984ULL, 0x0008620000000800ULL, 0x000000061b00720bULL, 0x008fda0003f3d000ULL,
0x00000000001a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1a1e7812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000061b00720bULL, 0x012fe40003f34000ULL,
0x0000001b061c7209ULL, 0x0c0fe40007810000ULL, 0x000000014f1a7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff207819ULL, 0x000fe20000011603ULL, 0x8000001c06197221ULL, 0x040fe20000010000ULL,
0x0000001b06067209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b191d7820ULL, 0x000fe40000410000ULL,
0x0000000000197806ULL, 0x000fe400008e0100ULL, 0x0000004f1a00720cULL, 0x000fe40003f25270ULL,
0x0000ffff191f7812ULL, 0x000fe200078e3cffULL, 0x0000001d001d7308ULL, 0x000e660000000800ULL,
0x0000001f1eff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff777807ULL, 0x000fc60001000000ULL,
0x000000804f1f9824ULL, 0x000fc800078e0214ULL, 0x00000001161f9824ULL, 0x000fe200078e021fULL,
0x00001f201d197589ULL, 0x002e6200000e0000ULL, 0x8000001c1b1e2221ULL, 0x000fe20000010000ULL,
0x0000001d08087220ULL, 0x000fe40000410000ULL, 0x00001f511d1a7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1e1e2820ULL, 0x000fc60000410000ULL, 0x00f4001c1f009388ULL, 0x0009e20000000800ULL,
0x0000001e00172308ULL, 0x000f620000000800ULL, 0x0000001928287220ULL, 0x082fe20000410000ULL,
0x0000001929297220ULL, 0x080fe20000410000ULL, 0x000000192c2c7220ULL, 0x080fe20000410000ULL,
0x000000192d2d7220ULL, 0x080fe20000410000ULL, 0x0000001930307220ULL, 0x080fe20000410000ULL,
0x0000001931317220ULL, 0x080fe20000410000ULL, 0x0000001934347220ULL, 0x080fe20000410000ULL,
0x0000001935357220ULL, 0x080fe20000410000ULL, 0x0000001938387220ULL, 0x080fe20000410000ULL,
0x0000001939397220ULL, 0x080fe20000410000ULL, 0x000000193c3c7220ULL, 0x080fe20000410000ULL,
0x000000193d3d7220ULL, 0x080fe20000410000ULL, 0x0000001940407220ULL, 0x080fe20000410000ULL,
0x0000001941417220ULL, 0x080fe20000410000ULL, 0x0000001924247220ULL, 0x080fe20000410000ULL,
0x0000001925257220ULL, 0x000fe20000410000ULL, 0x0000001a2a2a7220ULL, 0x088fe20000410000ULL,
0x0000001a2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001a2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001a2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001a32327220ULL, 0x080fe20000410000ULL,
0x0000001a33337220ULL, 0x080fe20000410000ULL, 0x0000001a36367220ULL, 0x080fe20000410000ULL,
0x0000001a37377220ULL, 0x080fe20000410000ULL, 0x0000001a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001a42427220ULL, 0x080fe20000410000ULL,
0x0000001a43437220ULL, 0x080fe20000410000ULL, 0x0000001a26267220ULL, 0x080fe20000410000ULL,
0x0000001a27277220ULL, 0x000fe20000410000ULL, 0x0000001817182220ULL, 0x020fc80000410000ULL,
0x0000000818087221ULL, 0x012fe20000010000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x000000080c197824ULL, 0x040fe200078e00ffULL, 0x000000010c00780cULL, 0x000fc80003f05270ULL,
0x0000000819197812ULL, 0x000fe400078e0cffULL, 0x000000696c187207ULL, 0x000fc60004000000ULL,
0x000000014a4a7824ULL, 0x000fe200078e0219ULL, 0x0000ffff18187812ULL, 0x000fc800078ec0ffULL,
0x00f64c004a197984ULL, 0x000e620000000800ULL, 0x00008880181a7816ULL, 0x000fca00000000ffULL,
0x800000001a187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x002fe20007804818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001a1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00f64c004a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000780481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000010000c197824ULL, 0x000fe200078e00ffULL,
0x00000002ff877819ULL, 0x000fe20000011603ULL, 0x000010004f187824ULL, 0x000fc600078e00ffULL,
0x0000100019197812ULL, 0x000fe400078e0cffULL, 0xffffe00018187812ULL, 0x000fe400078ec0ffULL,
0x0000b00004567810ULL, 0x100fe40007ffe019ULL, 0x0000b00018587810ULL, 0x000fc60007ffe019ULL,
0x0000001067577824ULL, 0x000fe400078e0256ULL, 0x0000001054597824ULL, 0x100fe400078e0258ULL,
0x0000001053587824ULL, 0x000fe200078e0258ULL, 0x000000005718783bULL, 0x000e620000004200ULL,
0x0000001066567824ULL, 0x000fc600078e0256ULL, 0x000000005920783bULL, 0x000ee80000004200ULL,
0x000000005848783bULL, 0x000f280000004200ULL, 0x00000000561c783bULL, 0x000f620000004200ULL,
0x00000018ff757819ULL, 0x002fe40000011418ULL, 0x0000888018817816ULL, 0x000fc400000000ffULL,
0x00000018ff9c7819ULL, 0x008fe20000011420ULL, 0x0000010020767824ULL, 0x040fe200078e00ffULL,
0x00008880209f7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011421ULL, 0x0000010021787824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe20000011476ULL, 0x0000009c009c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000888021767816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x00000018ff967819ULL, 0x000fe20000011422ULL, 0x00000020009d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff857819ULL, 0x000fe40000011423ULL,
0x00008880229b7816ULL, 0x040fe400000000ffULL, 0x0000888023827816ULL, 0x000fe200000000ffULL,
0x00000021009e7306ULL, 0x0007e20000200c00ULL, 0x0000010022207824ULL, 0x042fe200078e00ffULL,
0x00000018ff907819ULL, 0x010fe20000011448ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888048957816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000007800a17306ULL, 0x0003e20000200c00ULL, 0x0000010049217824ULL, 0x008fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff747819ULL, 0x000fe40000011419ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020009a7306ULL, 0x0007e20000200c00ULL,
0x0000010023787824ULL, 0x002fe200078e00ffULL, 0x00008880197c7816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fc4000001144aULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000002100937306ULL, 0x0003e20000200c00ULL,
0x0000010048207824ULL, 0x048fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x000088804a8f7816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200977306ULL, 0x000fe20000200c00ULL,
0x000001004b217824ULL, 0x002fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc40000011448ULL,
0x00000018ff8b7819ULL, 0x000fe40000011449ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000947306ULL, 0x0003e20000200c00ULL, 0x00000018ff737819ULL, 0x000fe4000001141aULL,
0x0000888049867816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x000088801a7a7816ULL, 0x000fe400000000ffULL, 0x00000018ff837819ULL, 0x000fe2000001144bULL,
0x0000002300987306ULL, 0x000fe20000200c00ULL, 0x000001004a207824ULL, 0x042fe200078e00ffULL,
0x000088804b897816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001141bULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000021008c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff717819ULL, 0x020fe2000001141cULL,
0x00000020008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff707819ULL, 0x000fe4000001141dULL,
0x00000018ff6f7819ULL, 0x000fc4000001141eULL, 0x00000018ff6e7819ULL, 0x000fc6000001141fULL,
0x0000004800917306ULL, 0x0007e20000200c00ULL, 0x0000010018207824ULL, 0x042fe400078e00ffULL,
0x0001000018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011420ULL,
0x0000010019207824ULL, 0x040fe200078e00ffULL, 0x0000007800997306ULL, 0x0003e20000200c00ULL,
0x00000017ff48723eULL, 0x008fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff7f7819ULL, 0x000fe40000011420ULL,
0x009800005020783bULL, 0x000fe20000000200ULL, 0x00000018007e7306ULL, 0x0007e20000200c00ULL,
0x0000541048787816ULL, 0x002fe20000000048ULL, 0x000001001a487824ULL, 0x040fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x000100001a1a7824ULL, 0x000fc400078e00ffULL,
0x00001f8778877589ULL, 0x000e6200000e0000ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000009f009f7306ULL, 0x000fe20000200c00ULL, 0x0000991077187816ULL, 0x008fe200000000ffULL,
0x00001f5178887589ULL, 0x000ee200000e0000ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x000000ff1800720cULL, 0x000fe20003f05270ULL, 0x000001001b187824ULL, 0x000fe400078e00ffULL,
0x000000a000a07306ULL, 0x000fe60000200c00ULL, 0x00000018ff187819ULL, 0x000fca0000011418ULL,
0x0000007600767306ULL, 0x000f300000200c00ULL, 0x0000007d007d7306ULL, 0x000f620000200c00ULL,
0x0000008720208232ULL, 0x002fce0000000000ULL, 0x0000009b009b7306ULL, 0x000e620000200c00ULL,
0x0000008722228232ULL, 0x000fe40000000000ULL, 0x0000008821218232ULL, 0x088fe40000000000ULL,
0x0000008823238232ULL, 0x000fc60000000000ULL, 0x0000008200827306ULL, 0x000ef00000200c00ULL,
0x00000019007b7306ULL, 0x0009f00000200c00ULL, 0x0000001800777306ULL, 0x0005e20000200c00ULL,
0x0000541076197816ULL, 0x010fce00000000a1ULL, 0x0000009600967306ULL, 0x000f220000200c00ULL,
0x000054109f187816ULL, 0x004fce00000000a0ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x000000182028723cULL, 0x000fee0000001828ULL, 0x0000004a008d7306ULL, 0x0003e20000200c00ULL,
0x000054109d187816ULL, 0x000fe4000000009cULL, 0x000054109e197816ULL, 0x020fc4000000007dULL,
0x000088801d9c7816ULL, 0x000fc600000000ffULL, 0x0000004800797306ULL, 0x000be20000200c00ULL,
0x000088801b4a7816ULL, 0x042fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018202c723cULL, 0x000fe8000000182cULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x0000004900927306ULL, 0x0007e20000200c00ULL, 0x000088801c487816ULL, 0x020fca00000000ffULL,
0x000000ffff767224ULL, 0x000fe200078e0048ULL, 0x000054109b487816ULL, 0x000fe2000000009aULL,
0x0000001a00787306ULL, 0x0003e20000200c00ULL, 0x0000541082497816ULL, 0x008fe20000000099ULL,
0x000001001d997824ULL, 0x000fe400078e00ffULL, 0x000000ffff827224ULL, 0x000fc800078e009cULL,
0x0000009500957306ULL, 0x000ee20000200c00ULL, 0x000001001c1a7824ULL, 0x042fe200078e00ffULL,
0x000000482030723cULL, 0x000fe20000001830ULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001141aULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x0000541097487816ULL, 0x010fe40000000096ULL, 0x0000541098497816ULL, 0x004fe40000000085ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff857819ULL, 0x000fe20000011499ULL,
0x0000004b008a7306ULL, 0x000fe40000200c00ULL, 0x000000482034723cULL, 0x000fec0000001834ULL,
0x0000001b004b7306ULL, 0x0005e20000200c00ULL, 0x0000541095487816ULL, 0x008fc40000000094ULL,
0x0000541086497816ULL, 0x002fca0000000093ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x009800005218783bULL, 0x004e620000000200ULL, 0x000000482038723cULL, 0x000fec0000001838ULL,
0x0000008b008b7306ULL, 0x000ea20000200c00ULL, 0x000100001d487824ULL, 0x000fce00078e00ffULL,
0x0000008900897306ULL, 0x000ef00000200c00ULL, 0x0000008400847306ULL, 0x000f220000200c00ULL,
0x00005410921d7816ULL, 0x004fe4000000008bULL, 0x000088801e8b7816ULL, 0x000fca00000000ffULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000541089497816ULL, 0x008fce000000008cULL,
0x0000001c00867306ULL, 0x0005e20000200c00ULL, 0x0000008718188232ULL, 0x082fe40000000000ULL,
0x000000871a1a8232ULL, 0x000fe40000000000ULL, 0x0000008819198232ULL, 0x080fe40000000000ULL,
0x000000881b1b8232ULL, 0x000fe20000000000ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x00005410911c7816ULL, 0x004fe40000000090ULL, 0x000000010c00780cULL, 0x000fca0003f05270ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000001c203c723cULL, 0x000fee000000183cULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe40000011448ULL,
0x000054108d1c7816ULL, 0x010fc40000000084ULL, 0x000054108f487816ULL, 0x002fc6000000008eULL,
0x0000007c007c7306ULL, 0x000fe80000200c00ULL, 0x000000482040723cULL, 0x000fe80000001840ULL,
0x0000007f007f7306ULL, 0x000e660000200c00ULL, 0x000001001e497824ULL, 0x000fc400078e00ffULL,
0x000100001e1e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff487224ULL, 0x000fe200078e008bULL,
0x0000001d00897306ULL, 0x0007e40000200c00ULL, 0x00000018ff1e7819ULL, 0x000fcc000001141eULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054108a1d7816ULL, 0x008fce0000000083ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000001c2024723cULL, 0x000fee0000001824ULL,
0x00005410811c7816ULL, 0x004fe20000000080ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x000054107c1d7816ULL, 0x002fc4000000007fULL, 0x000088801f207816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fc60000011449ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x0000001c1828723cULL, 0x000fee0000001828ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0020ULL,
0x0000007300737306ULL, 0x000f220000200c00ULL, 0x000054107b1d7816ULL, 0x008fe20000000074ULL,
0x000001001f207824ULL, 0x000fc400078e00ffULL, 0x000100001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000001c00497306ULL, 0x0007e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000007200727306ULL, 0x000f620000200c00ULL,
0x000054107e1c7816ULL, 0x008fce0000000075ULL, 0x0000001c182c723cULL, 0x000fe2000000182cULL,
0x0000007600767306ULL, 0x000fec0000200c00ULL, 0x000054107a1c7816ULL, 0x004fe40000000079ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x000054104a1d7816ULL, 0x002fce0000000077ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x0000001c1830723cULL, 0x000fee0000001830ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x00005410781c7816ULL, 0x010fe40000000073ULL,
0x000054104b1d7816ULL, 0x020fca0000000072ULL, 0x0000007100717306ULL, 0x000ee40000200c00ULL,
0x0000001c1834723cULL, 0x000fec0000001834ULL, 0x0000007000707306ULL, 0x000f220000200c00ULL,
0x00005410761c7816ULL, 0x004fe4000000007dULL, 0x00005410821d7816ULL, 0x002fca0000000085ULL,
0x0000006f006f7306ULL, 0x000fe40000200c00ULL, 0x0000001c1838723cULL, 0x000fec0000001838ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00005410861c7816ULL, 0x008fe40000000071ULL,
0x00005410891d7816ULL, 0x010fca0000000070ULL, 0x0000004800487306ULL, 0x000fe40000200c00ULL,
0x0000001c183c723cULL, 0x000fec000000183cULL, 0x0000002100217306ULL, 0x000e700000200c00ULL,
0x0000002000207306ULL, 0x000eb00000200c00ULL, 0x0000001e001e7306ULL, 0x000ee20000200c00ULL,
0x0000541048487816ULL, 0x002fc40000000021ULL, 0x00000002ff217819ULL, 0x000fca000001164fULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x0000541049497816ULL, 0x004fe40000000020ULL,
0x000054101e1c7816ULL, 0x008fca000000006fULL, 0x000000481840723cULL, 0x000fe20000001840ULL,
0x000054101f1d7816ULL, 0x002fce000000006eULL, 0x0000001c1824723cULL, 0x000fee0000001824ULL,
0x0000f62021187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200009ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000696c6c7207ULL, 0x000fe20004000000ULL, 0x000000044e197824ULL, 0x000fe200078e0221ULL,
0x000000ff0dff7812ULL, 0x000fe2000780c0ffULL, 0x0000000018ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff6cff7812ULL, 0x000fc4000782c0ffULL, 0x0000008019197811ULL, 0x000fe400078e30ffULL,
0x00000001ff697807ULL, 0x000fe40000800000ULL, 0x0000004c1900720cULL, 0x000fe40003f26070ULL,
0x000000010c497812ULL, 0x000fe4000784c0ffULL, 0x00000001ff487807ULL, 0x000fe40004000000ULL,
0x0000006c694b7207ULL, 0x000fce0005000000ULL, 0x000037c000001947ULL, 0x000fea0003800000ULL,
0x0000240009197984ULL, 0x004ea20000000800ULL, 0x00000001ff187807ULL, 0x000fca0004000000ULL,
0x8000000018007824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x004fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000240009197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007824800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000018197824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000187305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000180000735dULL, 0x008fe40003800000ULL, 0x0000240009187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fc40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000016a007824ULL, 0x000fe400078e025fULL,
0x00000300ff187624ULL, 0x000fe400078e00ffULL, 0x00005800021c7a24ULL, 0x000fe200078e02ffULL,
0x0000000100197812ULL, 0x000fe200078ec0ffULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0xffffffff18187811ULL, 0x000fe400078e08ffULL, 0x000000011900780cULL, 0x000fc80003f25070ULL,
0x0000000118197807ULL, 0x000fca0004800000ULL, 0x0000000100007824ULL, 0x000fe200078e0219ULL,
0x00000001ff457819ULL, 0x000fc8000001164fULL, 0x0000004d0000720cULL, 0x000fe20003f26070ULL,
0x00000020451a7824ULL, 0x000fca00078e0264ULL, 0x000000c01a1a7810ULL, 0x000fce0007ffe0ffULL,
0x0000000100189824ULL, 0x000fe400078e020bULL, 0x00000004ff199424ULL, 0x000fe200078e00ffULL,
0x0000001a4c1d7217ULL, 0x000fc60007800000ULL, 0x0000600018189625ULL, 0x000fe200078e0019ULL,
0x000000014e1e7810ULL, 0x000fc60007ffe0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0a1aULL,
0x0000000818029981ULL, 0x000562000c1e1900ULL, 0x000000471e00720cULL, 0x000fe20003f26070ULL,
0x00000080ff497424ULL, 0x000fe200078e00ffULL, 0x00000060051b7812ULL, 0x000fe200078ef81aULL,
0x000000084f5f7824ULL, 0x000fe200078e00ffULL, 0x0000001044207812ULL, 0x000fe400078ec0ffULL,
0x000000201d1d7807ULL, 0x000fe20000800000ULL, 0x000000801c1c7824ULL, 0x000fe200078e021bULL,
0x00000003ff217819ULL, 0x000fc40000011603ULL, 0x0000001d201d7217ULL, 0x000fe20007800000ULL,
0x000000010e187824ULL, 0x104fe200078e021cULL, 0x00000004211f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1a7824ULL, 0x000fe200078e021cULL, 0x0000000821237810ULL, 0x000fe20007ffe0ffULL,
0x000000011d207824ULL, 0x000fe200078e0a20ULL, 0xfffffff05f5f7812ULL, 0x000fe200078ec0ffULL,
0x00000001101d7824ULL, 0x000fe400078e021cULL, 0x00005e0018187625ULL, 0x000fe200078e0049ULL,
0x000000202100720cULL, 0x000fc40003f46070ULL, 0x0000000c21217810ULL, 0x000fe20007ffe0ffULL,
0x00005e001a1a7625ULL, 0x000fe200078e0049ULL, 0x0000001418187210ULL, 0x000fc60007f3e0ffULL,
0x00000001111e7824ULL, 0x000fe200078e021cULL, 0x000000141a1a7210ULL, 0x000fe20007f7e0ffULL,
0x00005e001d1c7625ULL, 0x000fc800078e0049ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x000000141c1c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x000000201f00720cULL, 0x080fe20003f26070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0049ULL,
0x000000202300720cULL, 0x080fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018637faeULL, 0x0005e4000d101c48ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x000000202100720cULL, 0x000fe40003f86070ULL, 0x000000141e1e7210ULL, 0x000fc40007fbe0ffULL,
0x000000086b207812ULL, 0x000fe400078ec0ffULL, 0x0000f6485f217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e061fULL, 0x000000001a627faeULL, 0x0005e6000c901c48ULL,
0x0000000121207824ULL, 0x000fe200078e0220ULL, 0x000000001c617faeULL, 0x0005e8000d901c48ULL,
0x000000001e607faeULL, 0x0005e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040020197984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c00121a7984ULL, 0x000f220000000800ULL, 0x000000010cff7812ULL, 0x000fe2000782c0ffULL,
0x80000000131b7824ULL, 0x000fe200078e00ffULL, 0x000000086b617812ULL, 0x000fc400078e0cffULL,
0x0000006c69607207ULL, 0x000fc80004800000ULL, 0x0000ffff60187812ULL, 0x000fc800078ec0ffULL,
0x00008880181f7816ULL, 0x000fca00000000ffULL, 0x800000001f187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x008fe40007844818ULL, 0x800000001aff7812ULL, 0x010fe2000786481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000000121617824ULL, 0x000fe200078e0261ULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x000000044f127824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000131a7824ULL, 0x000fe200078e00ffULL,
0xfffffff012127812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f62c0012197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000786481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000010014197810ULL, 0x000fe20007ffe015ULL, 0x00000001ff7c7424ULL, 0x000fc800078e00ffULL,
0x0000000116197824ULL, 0x000fca00078e0219ULL, 0x00f00000191b7984ULL, 0x000ee80000000800ULL,
0x00f2000019187984ULL, 0x0008620000000800ULL, 0x000000061b00720bULL, 0x008fda0003f7d000ULL,
0x00000000001a7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1a1e7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000061b00720bULL, 0x012fe40003f74000ULL,
0x0000001b061c7209ULL, 0x0c0fe40007810000ULL, 0x000000024f1a7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff207819ULL, 0x004fe20000011603ULL, 0x8000001c06197221ULL, 0x040fe20000010000ULL,
0x0000001b06067209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b191d7820ULL, 0x000fe40000410000ULL,
0x0000000000197806ULL, 0x000fe400018e0100ULL, 0x0000004f1a00720cULL, 0x000fe40003f65270ULL,
0x0000ffff19217812ULL, 0x000fe200078e3cffULL, 0x0000001d001d7308ULL, 0x000e660000000800ULL,
0x000000211eff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff7c7807ULL, 0x000fc60002000000ULL,
0x000000804f21b824ULL, 0x000fc800078e0214ULL, 0x000000011621b824ULL, 0x000fe200078e0221ULL,
0x00001f201d197589ULL, 0x002e6200000e0000ULL, 0x8000001c1b1e4221ULL, 0x000fe20000010000ULL,
0x0000001d08087220ULL, 0x000fe40000410000ULL, 0x00001f511d1a7589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b1e1e4820ULL, 0x000fc60000410000ULL, 0x00f4001c2100b388ULL, 0x0007e20000000800ULL,
0x0000001e00174308ULL, 0x000f220000000800ULL, 0x0000001928287220ULL, 0x082fe20000410000ULL,
0x0000001929297220ULL, 0x080fe20000410000ULL, 0x000000192c2c7220ULL, 0x080fe20000410000ULL,
0x000000192d2d7220ULL, 0x080fe20000410000ULL, 0x0000001930307220ULL, 0x080fe20000410000ULL,
0x0000001931317220ULL, 0x080fe20000410000ULL, 0x0000001934347220ULL, 0x080fe20000410000ULL,
0x0000001935357220ULL, 0x080fe20000410000ULL, 0x0000001938387220ULL, 0x080fe20000410000ULL,
0x0000001939397220ULL, 0x080fe20000410000ULL, 0x000000193c3c7220ULL, 0x080fe20000410000ULL,
0x000000193d3d7220ULL, 0x080fe20000410000ULL, 0x0000001940407220ULL, 0x080fe20000410000ULL,
0x0000001941417220ULL, 0x080fe20000410000ULL, 0x0000001924247220ULL, 0x080fe20000410000ULL,
0x0000001925257220ULL, 0x000fe20000410000ULL, 0x0000001a2a2a7220ULL, 0x084fe20000410000ULL,
0x0000001a2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001a2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001a2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001a32327220ULL, 0x080fe20000410000ULL,
0x0000001a33337220ULL, 0x080fe20000410000ULL, 0x0000001a36367220ULL, 0x080fe20000410000ULL,
0x0000001a37377220ULL, 0x080fe20000410000ULL, 0x0000001a3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001a3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001a3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001a3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001a42427220ULL, 0x080fe20000410000ULL,
0x0000001a43437220ULL, 0x080fe20000410000ULL, 0x0000001a26267220ULL, 0x080fe20000410000ULL,
0x0000001a27277220ULL, 0x000fe20000410000ULL, 0x0000001817184220ULL, 0x010fc80000410000ULL,
0x0000000818087221ULL, 0x01afe20000010000ULL, 0x0000015000002947ULL, 0x000fea0003800000ULL,
0x000000086b187812ULL, 0x000fe200078ec0ffULL, 0x800000001f197824ULL, 0x000fc800078e00ffULL,
0x000000015f187824ULL, 0x000fcc00078e0218ULL, 0x00f64c0018187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x000000084f5f7824ULL, 0x000fe400078e00ffULL,
0x000000080c1a7824ULL, 0x000fe400078e00ffULL, 0x800000001f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff05f5f7812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff187424ULL, 0x000fe200078e00ffULL,
0x000000081a1a7812ULL, 0x000fc800078ec0ffULL, 0x0000f6481a1a7810ULL, 0x000fe40007ffe05fULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x000004001a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000010006d6d7812ULL, 0x000fe200078ec0ffULL,
0x000010004f207824ULL, 0x004fe200078e00ffULL, 0x00000017ff80723eULL, 0x000fc400000000ffULL,
0x0000b000041c7810ULL, 0x100fe40007ffe06dULL, 0xffffe00020207812ULL, 0x000fe400078ec0ffULL,
0x0000541080947816ULL, 0x000fe20000000080ULL, 0x0000001067187824ULL, 0x100fe200078e021cULL,
0x0000b00020487810ULL, 0x000fe20007ffe06dULL, 0x00000010661c7824ULL, 0x000fe200078e021cULL,
0x000099107c817816ULL, 0x000fe400000000ffULL, 0x00001f51947c7589ULL, 0x000fe200000e0000ULL,
0x0000001054207824ULL, 0x100fe200078e0248ULL, 0x000000ff8100720cULL, 0x000fe20003f45270ULL,
0x0000001053487824ULL, 0x000fe200078e0248ULL, 0x000000001818783bULL, 0x000e680000004200ULL,
0x000000001c1c783bULL, 0x000fe80000004200ULL, 0x000000002020783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000ea20000004200ULL, 0x00000018ff547819ULL, 0x002fe20000011418ULL,
0x00000100186a7824ULL, 0x040fe200078e00ffULL, 0x00008880187b7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011419ULL,
0x00000100196b7824ULL, 0x040fe200078e00ffULL, 0x0000888019747816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fc4000001146aULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x00000100487d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000010049807824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001141aULL, 0x0000001800797306ULL, 0x0003e20000200c00ULL,
0x000088801a757816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe4000001141bULL,
0x00000018ff927819ULL, 0x000fc40000011420ULL, 0x00000018ff8b7819ULL, 0x000fe20000011421ULL,
0x0000006a00767306ULL, 0x0005e20000200c00ULL, 0x000001001b187824ULL, 0x002fe200078e00ffULL,
0x0000888021827816ULL, 0x000fe400000000ffULL, 0x00000018ff867819ULL, 0x000fe40000011422ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000006b00777306ULL, 0x000fe20000200c00ULL,
0x000001001a6a7824ULL, 0x044fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011423ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00008880228f7816ULL, 0x000fc400000000ffULL,
0x00000018ff707819ULL, 0x000fe4000001146aULL, 0x0000001900727306ULL, 0x0003e20000200c00ULL,
0x000088801b6a7816ULL, 0x040fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00008880238e7816ULL, 0x000fe400000000ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x00000018006b7306ULL, 0x0005e20000200c00ULL,
0x000001001c197824ULL, 0x002fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fc4000001147dULL,
0x00000002ff7d7819ULL, 0x000fe40000011603ULL, 0x00000018ff6c7819ULL, 0x000fe20000011419ULL,
0x0000010020197824ULL, 0x040fe200078e00ffULL, 0x0000001a00737306ULL, 0x0003e20000200c00ULL,
0x000001001d187824ULL, 0x004fe200078e00ffULL, 0x00001f7d947d7589ULL, 0x0005e200000e0000ULL,
0x00000018ff7f7819ULL, 0x000fe40000011448ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff6e7819ULL, 0x000fe20000011418ULL, 0x0000001b00717306ULL, 0x0007e20000200c00ULL,
0x0000888020187816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000888048887816ULL, 0x000fe200000000ffULL, 0x00000100211a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011449ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000888049877816ULL, 0x000fe200000000ffULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00000018ff1b7819ULL, 0x008fe20000011420ULL, 0x0000010022207824ULL, 0x040fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001141aULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe20000011421ULL, 0x0000010023217824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011422ULL, 0x0000001900197306ULL, 0x000e620000200c00ULL,
0x00000018ff917819ULL, 0x000fe20000011421ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe20000011423ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000001004a947824ULL, 0x004fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000002000907306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x000fc40000011449ULL, 0x00000018ff787819ULL, 0x000fe4000001144bULL,
0x00000018ff7a7819ULL, 0x000fe4000001144aULL, 0x000088804a817816ULL, 0x000fe200000000ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00a000005020783bULL, 0x004ea20000000200ULL,
0x0000541018187816ULL, 0x002fe20000000019ULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe4000001141cULL, 0x000088801c6f7816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000009300937306ULL, 0x000e620000200c00ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff677819ULL, 0x000fe4000001141dULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801d6d7816ULL, 0x000fe200000000ffULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fe4000001141eULL,
0x00000018ff667819ULL, 0x000fca000001141fULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541082197816ULL, 0x002fce0000000093ULL, 0x0000001b001b7306ULL, 0x000e700000200c00ULL,
0x0000001a001a7306ULL, 0x000ee20000200c00ULL, 0x0000007d2020a232ULL, 0x084fe40000000000ULL,
0x0000007d2222a232ULL, 0x000fc40000000000ULL, 0x0000007c2121a232ULL, 0x080fe40000000000ULL,
0x0000007c2323a232ULL, 0x000fe20000000000ULL, 0x0000004800847306ULL, 0x0005ec0000200c00ULL,
0x000000182028723cULL, 0x000fe40000001828ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x000088804b487816ULL, 0x004fc800000000ffULL, 0x000054101b187816ULL, 0x002fe20000000092ULL,
0x000000ffff827224ULL, 0x000fe200078e0048ULL, 0x000054101a197816ULL, 0x008fe2000000008bULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000001004b487824ULL, 0x040fe400078e00ffULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x00a000005218783bULL, 0x000eae0000000200ULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000ff00000200c00ULL, 0x0000008d008d7306ULL, 0x000ef00000200c00ULL,
0x0000008c008c7306ULL, 0x000f300000200c00ULL, 0x0000004900837306ULL, 0x0003e20000200c00ULL,
0x0000007d1818a232ULL, 0x004fc40000000000ULL, 0x0000007d1a1aa232ULL, 0x000fe40000000000ULL,
0x0000007c1919a232ULL, 0x080fe40000000000ULL, 0x0000007c1b1ba232ULL, 0x000fe20000000000ULL,
0x00000048008b7306ULL, 0x0005e20000200c00ULL, 0x000054108e497816ULL, 0x002fce0000000091ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000054108f487816ULL, 0x004fce0000000090ULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x000000482030723cULL, 0x000fee0000001830ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054108d487816ULL, 0x008fe40000000086ULL,
0x000054108c497816ULL, 0x010fca0000000085ULL, 0x00000080008a7306ULL, 0x0004e40000200c00ULL,
0x000000482034723cULL, 0x000fec0000001834ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff497819ULL, 0x000fe4000001144bULL, 0x00000018ff807819ULL, 0x004fc40000011494ULL,
0x0000541088487816ULL, 0x002fc60000000089ULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000004900857306ULL, 0x0007f00000200c00ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x0000541087497816ULL, 0x008fce000000008aULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000000482038723cULL, 0x000fee0000001838ULL, 0x0000004a008f7306ULL, 0x0005e20000200c00ULL,
0x000100001d487824ULL, 0x000fe200078e00ffULL, 0x00005410831d7816ULL, 0x002fc4000000007eULL,
0x000088801e7e7816ULL, 0x000fc800000000ffULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x004fce0000011448ULL, 0x0000008000807306ULL, 0x000e700000200c00ULL,
0x0000008200827306ULL, 0x000eb00000200c00ULL, 0x0000001c004b7306ULL, 0x0007e20000200c00ULL,
0x0000541081487816ULL, 0x002fce0000000080ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x00005410841c7816ULL, 0x008fe4000000007fULL, 0x0000541082497816ULL, 0x004fca000000008bULL,
0x0000001c203c723cULL, 0x040fe2000000183cULL, 0x0000005400547306ULL, 0x000fec0000200c00ULL,
0x000054108f1c7816ULL, 0x000fe2000000007aULL, 0x000000482040723cULL, 0x040fe20000001840ULL,
0x00005410851d7816ULL, 0x000fe20000000078ULL, 0x0000006300637306ULL, 0x000eaa0000200c00ULL,
0x000001001e497824ULL, 0x040fe200078e00ffULL, 0x0000001c2024723cULL, 0x000fe20000001824ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x000000ffff487224ULL, 0x000fe200078e007eULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x000054107b1c7816ULL, 0x000fe40000000076ULL,
0x00005410741d7816ULL, 0x002fe20000000077ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x000088801f207816ULL, 0x000fca00000000ffULL, 0x0000001c1828723cULL, 0x000fe40000001828ULL,
0x0000006a006a7306ULL, 0x000eea0000200c00ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0020ULL,
0x00005410721d7816ULL, 0x004fe20000000063ULL, 0x000001001f207824ULL, 0x040fe200078e00ffULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000100001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001c00217306ULL, 0x0009f00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00005410791c7816ULL, 0x010fce0000000054ULL, 0x0000004a004a7306ULL, 0x000f220000200c00ULL,
0x0000001c182c723cULL, 0x000fee000000182cULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x00005410751c7816ULL, 0x002fe40000000070ULL, 0x000054106a1d7816ULL, 0x008fca000000006bULL,
0x0000004900497306ULL, 0x000e640000200c00ULL, 0x0000001c1830723cULL, 0x000fec0000001830ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000054104b1c7816ULL, 0x004fe40000000064ULL,
0x000054104a1d7816ULL, 0x010fca0000000067ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541048487816ULL, 0x002fe20000000049ULL, 0x0000001c183c723cULL, 0x000fec000000183cULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000541073627816ULL, 0x008fe40000000062ULL,
0x00000002ff1c7819ULL, 0x000fca000001164fULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541071637816ULL, 0x004fce0000000068ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000000621834723cULL, 0x000fee0000001834ULL, 0x0000006c006c7306ULL, 0x000e700000200c00ULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x000054106f6c7816ULL, 0x002fce000000006cULL, 0x0000002000207306ULL, 0x000e700000200c00ULL,
0x0000001e001e7306ULL, 0x000ee20000200c00ULL, 0x000054106d6d7816ULL, 0x004fce000000006eULL,
0x0000001f001f7306ULL, 0x000ea20000200c00ULL, 0x0000541021497816ULL, 0x002fe20000000020ULL,
0x0000006c1838723cULL, 0x000fe20000001838ULL, 0x000054101e1e7816ULL, 0x008fce0000000053ULL,
0x000000481840723cULL, 0x000fe20000001840ULL, 0x000054101f1f7816ULL, 0x004fce0000000066ULL,
0x0000001e1824723cULL, 0x000fee0000001824ULL, 0x0000f6301c187811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x0000200009ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000401c197824ULL, 0x000fe200078e0255ULL,
0x000000ff60ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000018ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff0dff7812ULL, 0x000fc4000786c0ffULL, 0x000000c019197810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff547807ULL, 0x000fe40001000000ULL, 0x0000004c1900720cULL, 0x000fe40003f46070ULL,
0x000000010c497812ULL, 0x000fe400078ec0ffULL, 0x00000001ff487807ULL, 0x000fe40001800000ULL,
0x00000054694b7207ULL, 0x000fc40004800000ULL, 0x0000000149497812ULL, 0x000fca00078e3cffULL,
0x00001a7000002947ULL, 0x000fea0003800000ULL, 0x00002400090d7984ULL, 0x004ea20000000800ULL,
0x8000000065187824ULL, 0x000fca00078e00ffULL, 0x800000000dff7812ULL, 0x004fe20007844818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x00002400090d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007844818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000065657824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00187305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x000000180000735dULL, 0x008fe40003800000ULL, 0x0000240009187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fc40007844865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000001ff457819ULL, 0x000fe2000001164fULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x000003004e187a10ULL, 0x000fe40007ffe0ffULL,
0x00000010441b7812ULL, 0x000fe400078ec0ffULL, 0x00000001181a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008180d7824ULL, 0x000fe200078e0245ULL, 0x00000003ff1d7819ULL, 0x000fe40000011603ULL,
0x000000471a00720cULL, 0x000fe20003f46070ULL, 0x000000200d0d7824ULL, 0x000fe200078e00ffULL,
0x000000041d1f7810ULL, 0x000fc80007ffe0ffULL, 0x0000000d4c1c7217ULL, 0x000fe40007800000ULL,
0x0000006005187812ULL, 0x000fc600078ef80dULL, 0x000000011c1c7824ULL, 0x000fe400078e0a0dULL,
0x00000007020d7224ULL, 0x020fc600078e0218ULL, 0x000000201c1c7807ULL, 0x000fe20001000000ULL,
0x000000010e187824ULL, 0x100fe400078e020dULL, 0x000000010f0f7824ULL, 0x000fe200078e020dULL,
0x0000001c1b1c7217ULL, 0x000fe20007800000ULL, 0x00005e0018187625ULL, 0x000fc800078e0021ULL,
0x0000000110107824ULL, 0x000fe200078e020dULL, 0x00000014181a7210ULL, 0x000fe20007f5e0ffULL,
0x000000011c1c7824ULL, 0x000fe400078e0a1bULL, 0x00005e000f0e7625ULL, 0x000fc600078e0021ULL,
0x0000001c1d00720cULL, 0x000fe20003f66070ULL, 0x0000000111187824ULL, 0x000fe200078e020dULL,
0x0000000c1d0d7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x080fe200078e0021ULL,
0x000000140e0e7210ULL, 0x080fe40007fbe0ffULL, 0x000000081d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e0619ULL, 0x0000001410107210ULL, 0x000fe20007f9e0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0021ULL, 0x0000001c1f00720cULL, 0x000fc40003f46070ULL,
0x0000001c1d00720cULL, 0x080fe20003fc6070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x0000001c0d00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff117224ULL, 0x000fe200020e0611ULL,
0x0000001418187210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5d7faeULL, 0x0005e8000d901c48ULL, 0x000000ffff197224ULL, 0x000fe400020e0619ULL,
0x000000000e5c7faeULL, 0x0005e8000d101c48ULL, 0x00000000105b7faeULL, 0x0005e8000f101c48ULL,
0x00000000185a7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005e5e7984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c00120e7984ULL, 0x004ea20000000800ULL, 0x0000005469697207ULL, 0x000fe20004800000ULL,
0x80000000130f7824ULL, 0x000fc600078e00ffULL, 0x0000ffff69117812ULL, 0x000fca00078ec0ffULL,
0x80000000110d7824ULL, 0x000fca00078e00ffULL, 0x800000005eff7812ULL, 0x008fe4000784480dULL,
0x800000000eff7812ULL, 0x004fe2000786480fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x8000000013137824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d000e7305ULL, 0x0004e4000021f000ULL,
0x3fa000000d0d7823ULL, 0x004fe200000100ffULL, 0x0000000e0000735dULL, 0x008fe40003800000ULL,
0x00f63c00120e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fc40007864813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000018014157810ULL, 0x000fca0007ffe015ULL, 0x0000000116157824ULL, 0x000fca00078e0215ULL,
0x00f00000150d7984ULL, 0x000ea80000000800ULL, 0x00f20000150f7984ULL, 0x0007220000000800ULL,
0x000000060d00720bULL, 0x004fda0003f7d000ULL, 0x00000000000e7806ULL, 0x000fc800018e0100ULL,
0x0000ffff0e137812ULL, 0x000fe2000786c0ffULL, 0x00000001ff0e7424ULL, 0x000fd800078e00ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000060d00720bULL, 0x018fe40003f74000ULL,
0x0000000d06157209ULL, 0x000fe40007810000ULL, 0x00000002ff197819ULL, 0x000fc60000011603ULL,
0x80000015060e7221ULL, 0x000fe20000010000ULL, 0x000000034f067811ULL, 0x000fc600078ff0ffULL,
0x3fb8aa3b0e107820ULL, 0x000fe40000410000ULL, 0x00000000000e7806ULL, 0x000fe400018e0100ULL,
0x0000004f0600720cULL, 0x000fe40003f65270ULL, 0x0000ffff0e0e7812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000ea60000000800ULL, 0x0000000e13ff7212ULL, 0x000fce000788c0ffULL,
0x000000804f13b824ULL, 0x000fc800078e0214ULL, 0x000000011616b824ULL, 0x000fe200078e0213ULL,
0x00001f1910067589ULL, 0x004ea200000e0000ULL, 0x800000150d0e4221ULL, 0x000fe20000010000ULL,
0x0000001008087220ULL, 0x000fe40000410000ULL, 0x00001f51100d7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b0e0e4820ULL, 0x000fc60000410000ULL, 0x00f400151600b388ULL, 0x0009e20000000800ULL,
0x0000000e00174308ULL, 0x000a640000000800ULL, 0x00000001ff0e7807ULL, 0x020fe20002000000ULL,
0x0000000628287220ULL, 0x084fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x000fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x088fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000d42427220ULL, 0x080fe20000410000ULL, 0x0000000d43437220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe200078e0015ULL, 0x0000000f170f4220ULL, 0x002fc80000410000ULL,
0x000000080f087221ULL, 0x018fe20000010000ULL, 0x0000011000002947ULL, 0x000fea0003800000ULL,
0x000000080c0d7824ULL, 0x000fca00078e00ffULL, 0x000000080d107812ULL, 0x000fca00078e0cffULL,
0x000000015f0d7824ULL, 0x000fe400078e0210ULL, 0x8000000011107824ULL, 0x000fc800078e00ffULL,
0x00f64c000d0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007844810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000011107824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d000f7305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x0000000f0000735dULL, 0x008fe40003800000ULL, 0x00000400610f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fc40007844810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000000591c783bULL, 0x000ea20000004200ULL,
0x00000017ff5b723eULL, 0x000fe400000000ffULL, 0x00000002ff617819ULL, 0x000fe20000011603ULL,
0x000000005820783bULL, 0x000ee20000004200ULL, 0x000054105b627816ULL, 0x000fc6000000005bULL,
0x000000005618783bULL, 0x0009e80000004200ULL, 0x000000005748783bULL, 0x000a680000004200ULL,
0x00001f6162617589ULL, 0x000fe800000e0000ULL, 0x00001f5162687589ULL, 0x000fe200000e0000ULL,
0x00000018ff6c7819ULL, 0x004fe2000001141cULL, 0x000001001c567824ULL, 0x050fe200078e00ffULL,
0x000088801c0f7816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe2000001141dULL, 0x000001001d597824ULL, 0x040fe200078e00ffULL,
0x000088801d777816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff6b7819ULL, 0x000fe4000001141eULL, 0x00000018ff6a7819ULL, 0x000fe2000001141fULL,
0x0000001c00797306ULL, 0x0005e20000200c00ULL, 0x00000018ff5a7819ULL, 0x008fe40000011421ULL,
0x000088801e6e7816ULL, 0x000fe400000000ffULL, 0x000088801f727816ULL, 0x000fc400000000ffULL,
0x00008880216f7816ULL, 0x000fe200000000ffULL, 0x0000001d007a7306ULL, 0x0007e20000200c00ULL,
0x000001001f1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00008880206d7816ULL, 0x040fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005600787306ULL, 0x0005220000200c00ULL,
0x00000100201d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x00000018ff5c7819ULL, 0x000fe20000011420ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00757306ULL, 0x0007e20000200c00ULL,
0x000001001e567824ULL, 0x044fe200078e00ffULL, 0x00000018ff577819ULL, 0x020fe20000011422ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011423ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x0000001d00707306ULL, 0x0005e20000200c00ULL,
0x00000100211c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00008880225d7816ULL, 0x040fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x00000100221d7824ULL, 0x044fe200078e00ffULL, 0x0000001c00767306ULL, 0x0005e20000200c00ULL,
0x00008880235f7816ULL, 0x000fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x00000059007c7306ULL, 0x000fe20000200c00ULL,
0x00000100231c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff117819ULL, 0x002fe2000001144aULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe4000001144bULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fc40000011423ULL, 0x000088804b5b7816ULL, 0x000fe400000000ffULL,
0x00000018ff0d7819ULL, 0x000fe40000011448ULL, 0x00000018ff107819ULL, 0x000fe20000011449ULL,
0x0000001c00607306ULL, 0x0005e20000200c00ULL, 0x00000100481d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011418ULL, 0x00000018ff157819ULL, 0x000fe40000011419ULL,
0x00000018ff167819ULL, 0x000fc4000001141aULL, 0x0000002100657306ULL, 0x0003e20000200c00ULL,
0x00000100491c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc8000001141bULL,
0x00000018ff597819ULL, 0x000fe4000001141cULL, 0x0000001e00747306ULL, 0x000fe20000200c00ULL,
0x00000018ff217819ULL, 0x002fce000001141dULL, 0x0000001f00737306ULL, 0x0003f00000200c00ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x00a80000501c783bULL, 0x0022ee0000000200ULL,
0x0000006c006c7306ULL, 0x000f620000200c00ULL, 0x000099100e507816ULL, 0x002fe200000000ffULL,
0x000001004b0e7824ULL, 0x000fc400078e00ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x000000ff5000720cULL, 0x000fe40003f45270ULL, 0x00000018ff507819ULL, 0x000fe2000001140eULL,
0x000100004a0e7824ULL, 0x000fe200078e00ffULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x00000018ff647819ULL, 0x000fe4000001144bULL, 0x00008880184b7816ULL, 0x000fe400000000ffULL,
0x00000018ff0e7819ULL, 0x000fc6000001140eULL, 0x0000006e006e7306ULL, 0x000ff00000200c00ULL,
0x0000000e00627306ULL, 0x0009f00000200c00ULL, 0x0000005600717306ULL, 0x0003620000200c00ULL,
0x000054100f0e7816ULL, 0x010fe20000000078ULL, 0x000000611c1ca232ULL, 0x088fe20000000000ULL,
0x00005410770f7816ULL, 0x004fe2000000007cULL, 0x000000611e1ea232ULL, 0x000fe20000000000ULL,
0x0000888019777816ULL, 0x000fe200000000ffULL, 0x000000681d1da232ULL, 0x000fc40000000000ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000000681f1fa232ULL, 0x000fe20000000000ULL,
0x0000888049567816ULL, 0x042fe200000000ffULL, 0x0001000049497824ULL, 0x000fca00078e00ffULL,
0x0000000e1c28723cULL, 0x000fe20000001828ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x00000018ff497819ULL, 0x000fca0000011449ULL, 0x00005410790e7816ULL, 0x020fe4000000006cULL,
0x0000006a006a7306ULL, 0x000ee20000200c00ULL, 0x000054107a0f7816ULL, 0x000fce0000000053ULL,
0x0000000e1c2c723cULL, 0x000fe2000000182cULL, 0x0000006d006d7306ULL, 0x000f2c0000200c00ULL,
0x000054106e0e7816ULL, 0x000fe20000000071ULL, 0x0000010019717824ULL, 0x000fe200078e00ffULL,
0x0000006f006f7306ULL, 0x000f620000200c00ULL, 0x00005410720f7816ULL, 0x004fe20000000075ULL,
0x000000ffff6e7224ULL, 0x000fcc00078e0077ULL, 0x0000000e1c30723cULL, 0x000fe20000001830ULL,
0x0000005c005c7306ULL, 0x000fec0000200c00ULL, 0x00005410740e7816ULL, 0x002fe4000000006bULL,
0x0000002000677306ULL, 0x0002a20000200c00ULL, 0x00005410730f7816ULL, 0x008fe2000000006aULL,
0x00010000196a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc80000011471ULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x0000888048207816ULL, 0x042fe200000000ffULL, 0x0000000e1c34723cULL, 0x000fe20000001834ULL,
0x0001000048487824ULL, 0x000fca00078e00ffULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x000054106d0e7816ULL, 0x010fe40000000070ULL, 0x000054106f0f7816ULL, 0x020fe40000000076ULL,
0x00000018ff487819ULL, 0x000fc60000011448ULL, 0x0000005800587306ULL, 0x000fe40000200c00ULL,
0x0000000e1c38723cULL, 0x000fec0000001838ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x00005410670e7816ULL, 0x004fe4000000005cULL, 0x00005410650f7816ULL, 0x008fca000000005aULL,
0x0000005f005f7306ULL, 0x000ea40000200c00ULL, 0x0000000e1c3c723cULL, 0x000fec000000183cULL,
0x0000002200667306ULL, 0x000ee20000200c00ULL, 0x000054105d5e7816ULL, 0x002fe4000000005eULL,
0x000088801a0f7816ULL, 0x000fca00000000ffULL, 0x0000002300637306ULL, 0x000e620000200c00ULL,
0x000054105f5f7816ULL, 0x004fce0000000060ULL, 0x0000005600227306ULL, 0x0005e20000200c00ULL,
0x0000541066667816ULL, 0x008fe20000000057ULL, 0x0000005e1c40723cULL, 0x000fec0000001840ULL,
0x0000005900237306ULL, 0x0007e20000200c00ULL, 0x000088804a567816ULL, 0x004fe400000000ffULL,
0x0000541063677816ULL, 0x002fca0000000058ULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x000001004a597824ULL, 0x008fe200078e00ffULL, 0x000000661c24723cULL, 0x000fe80000001824ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000050004a7306ULL, 0x0003e20000200c00ULL,
0x000001001b1d7824ULL, 0x040fe200078e00ffULL, 0x000088801b1c7816ULL, 0x040fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001000107306ULL, 0x000fe20000200c00ULL, 0x0000010018507824ULL, 0x042fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011450ULL, 0x00a800005250783bULL, 0x000e620000000200ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x00000018ff187819ULL, 0x000fce0000011418ULL,
0x0000004900497306ULL, 0x000ef00000200c00ULL, 0x0000001800197306ULL, 0x0009e20000200c00ULL,
0x0000541048487816ULL, 0x004fce000000000dULL, 0x0000001400147306ULL, 0x000ea20000200c00ULL,
0x000001001a187824ULL, 0x050fe200078e00ffULL, 0x0000541049497816ULL, 0x008fe20000000010ULL,
0x000100001a1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000000615050a232ULL, 0x002fe20000000000ULL, 0x0000541019147816ULL, 0x004fcc0000000014ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000000615252a232ULL, 0x000fe40000000000ULL,
0x000000685151a232ULL, 0x080fe40000000000ULL, 0x000000685353a232ULL, 0x000fc60000000000ULL,
0x0000002100217306ULL, 0x000e680000200c00ULL, 0x00000048502c723cULL, 0x000fe8000000182cULL,
0x0000006a000e7306ULL, 0x000eb00000200c00ULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x002fc40000000021ULL, 0x0000541022217816ULL, 0x000fca0000000023ULL,
0x0000001800187306ULL, 0x000e620000200c00ULL, 0x000054100e157816ULL, 0x004fe20000000015ULL,
0x000000205028723cULL, 0x040fec0000001828ULL, 0x0000001100117306ULL, 0x000ea40000200c00ULL,
0x00000014503c723cULL, 0x000fec000000183cULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x000054100f187816ULL, 0x002fce0000000018ULL, 0x0000001600167306ULL, 0x000fe20000200c00ULL,
0x0000541062627816ULL, 0x004fce0000000011ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000005600567306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000e700000200c00ULL,
0x0000005b005b7306ULL, 0x000eb00000200c00ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x0000541056567816ULL, 0x002fce0000000059ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000054105b577816ULL, 0x004fce000000004aULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000541064637816ULL, 0x008fe20000000013ULL, 0x000000565030723cULL, 0x040fec0000001830ULL,
0x0000006e006e7306ULL, 0x000fe40000200c00ULL, 0x000000625034723cULL, 0x000fec0000001834ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000054104b6a7816ULL, 0x002fce000000006cULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001d001d7306ULL, 0x000e620000200c00ULL,
0x000054106e6b7816ULL, 0x004fce000000006bULL, 0x0000001a000d7306ULL, 0x000ea20000200c00ULL,
0x0000006a5038723cULL, 0x000fee0000001838ULL, 0x0000001b00107306ULL, 0x000ee20000200c00ULL,
0x000054101c197816ULL, 0x002fe4000000001dULL, 0x000054100d0e7816ULL, 0x004fca0000000016ULL,
0x000000185040723cULL, 0x000fe20000001840ULL, 0x00005410100f7816ULL, 0x008fce0000000055ULL,
0x0000000e5024723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200009ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6400012ff7f8cULL, 0x0005e2000c80043fULL,
0x00009910690d7816ULL, 0x000fe400000000ffULL, 0x00000001ff487807ULL, 0x000fe40004000000ULL,
0x000000ff0d00720cULL, 0x000fe40003f45270ULL, 0x000000010c497812ULL, 0x000fe400078ec0ffULL,
0x00000001ff549807ULL, 0x000fc80001000000ULL, 0x00007610544b7816ULL, 0x000fe4000000004bULL,
0x000003004e4e7a10ULL, 0x004fe40007ffe0ffULL, 0x000000ff0aff7812ULL, 0x000fe4000780c0ffULL,
0x000000474e00720cULL, 0x000fe40003f26070ULL, 0x00000001ff0a7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff88e000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff117224ULL, 0x002fe400078e002bULL,
0x000000ffff1c7224ULL, 0x000fe200078e002aULL, 0x0000000447007c0cULL, 0x004fda000bf03070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000008007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0008ULL, 0x00008650002a7802ULL, 0x000fe40000000f00ULL,
0x00008c6000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000800037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000008ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x020fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000057919ULL, 0x006e680000000000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000809057811ULL, 0x004fe200078ff0ffULL,
0x00000000030a7220ULL, 0x018fca0000410000ULL, 0x00001f070a007589ULL, 0x000e6800000e0000ULL,
0x00001f050a057589ULL, 0x000ea200000e0000ULL, 0x0000002800287220ULL, 0x042fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000001c051c7220ULL, 0x044fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x000fc80000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000262726723eULL, 0x000fc600000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200027812ULL, 0x022fe200078ec0ffULL, 0x0000002045157824ULL, 0x100fe200078e0200ULL,
0x00000002ff107819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000402097811ULL, 0x000fe400078ff8ffULL, 0x0000000800187811ULL, 0x000fe400078ff0ffULL,
0x0000000202057811ULL, 0x000fc400078ff8ffULL, 0x00000006020d7811ULL, 0x000fe400078ff8ffULL,
0x0000000703027812ULL, 0x100fe400078e7810ULL, 0x00000007090b7812ULL, 0x040fe400078e7810ULL,
0x0000000709097812ULL, 0x000fe200078e7818ULL, 0x00000008100a7824ULL, 0x000fe200078e0202ULL,
0x0000000705077812ULL, 0x000fe200078e7810ULL, 0x0000100046027824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e7818ULL, 0x0000000818167824ULL, 0x000fe200078e0209ULL,
0x000000070d0f7812ULL, 0x000fe200078e7810ULL, 0x0000000800097824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e7818ULL, 0x0000000818127824ULL, 0x000fe200078e0203ULL,
0x000000070d0d7812ULL, 0x000fe200078e7818ULL, 0x00000008100c7824ULL, 0x040fe200078e0207ULL,
0x0000000809097812ULL, 0x000fe200078ec0ffULL, 0x00000008100e7824ULL, 0x000fe200078e020bULL,
0x0000002c2d07723eULL, 0x000fe200000000ffULL, 0x0000000818147824ULL, 0x000fe200078e0205ULL,
0x000000282905723eULL, 0x000fe200000000ffULL, 0x0000080045037824ULL, 0x000fc400078e0202ULL,
0x0000000810107824ULL, 0x000fe200078e020fULL, 0x00005410051a7816ULL, 0x040fe20000000007ULL,
0x0000000818187824ULL, 0x000fe200078e020dULL, 0x00007632051b7816ULL, 0x000fe20000000007ULL,
0x000000100a0a7824ULL, 0x100fe200078e0203ULL, 0x000000383905723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x0000003c3d07723eULL, 0x000fe200000000ffULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0x00007632050d7816ULL, 0x000fe20000000007ULL, 0x0000001014147824ULL, 0x000fc400078e0203ULL,
0x0000001010107824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x100fe400078e0203ULL,
0x0000001018187824ULL, 0x000fe400078e0203ULL, 0x000000010a0b7824ULL, 0x000fe200078e0209ULL,
0x00000034350a723eULL, 0x000fe200000000ffULL, 0x00000001090c7824ULL, 0x040fe400078e020cULL,
0x00000001090e7824ULL, 0x040fe200078e020eULL, 0x0000001a0b007388ULL, 0x0003e20000000a00ULL,
0x0000000109127824ULL, 0x000fc400078e0212ULL, 0x0000000109147824ULL, 0x040fe400078e0214ULL,
0x0000000109107824ULL, 0x040fe400078e0210ULL, 0x0000000109167824ULL, 0x040fe400078e0216ULL,
0x0000000109187824ULL, 0x000fe200078e0218ULL, 0x000000303109723eULL, 0x000fe200000000ffULL,
0x00000010150b7824ULL, 0x002fc600078e0202ULL, 0x00005410091a7816ULL, 0x140fe4000000000aULL,
0x00007632091b7816ULL, 0x000fe4000000000aULL, 0x000000404109723eULL, 0x000fe400000000ffULL,
0x00000024250a723eULL, 0x000fe200000000ffULL, 0x0000001a0c007388ULL, 0x0003e40000000a00ULL,
0x00005410050c7816ULL, 0x002fe40000000007ULL, 0x0000001c1105723eULL, 0x000fc400000000ffULL,
0x0000002e2f07723eULL, 0x000fe200000000ffULL, 0x0000000c0e007388ULL, 0x0003e40000000a00ULL,
0x00005410090c7816ULL, 0x142fe4000000000aULL, 0x00007632090d7816ULL, 0x000fe4000000000aULL,
0x000000323309723eULL, 0x000fe400000000ffULL, 0x00000036370a723eULL, 0x000fe200000000ffULL,
0x0000000c10007388ULL, 0x0003e40000000a00ULL, 0x00005410050c7816ULL, 0x002fc40000000007ULL,
0x00007632050d7816ULL, 0x000fe40000000007ULL, 0x0000003a3b05723eULL, 0x000fe400000000ffULL,
0x0000003e3f07723eULL, 0x000fe200000000ffULL, 0x0000000c12007388ULL, 0x0003e60000000a00ULL,
0x00005410051a7816ULL, 0x140fe40000000007ULL, 0x00007632051b7816ULL, 0x000fc40000000007ULL,
0x00005410090c7816ULL, 0x142fe4000000000aULL, 0x00007632090d7816ULL, 0x000fe4000000000aULL,
0x000000424309723eULL, 0x000fc600000000ffULL, 0x0000000c14007388ULL, 0x000fe20000000a00ULL,
0x0000763209177816ULL, 0x000fc60000000026ULL, 0x0000001a16007388ULL, 0x0003e40000000a00ULL,
0x0000541009167816ULL, 0x002fe20000000026ULL, 0x00000300ff1a7624ULL, 0x000fc800078e00ffULL,
0x0000001618007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000011a00780cULL, 0x000fca0003f05270ULL, 0x000000000b0c7984ULL, 0x000e680000000c00ULL,
0x000400000b1c7984ULL, 0x000ea80000000c00ULL, 0x000800000b107984ULL, 0x000ee80000000c00ULL,
0x000c00000b207984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x010fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000000c0b007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c0b007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000304000008947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000ea20000002700ULL,
0x000058001a057a24ULL, 0x000fe200078e02ffULL, 0x0000000145ff7812ULL, 0x000fe2000780f84fULL,
0x00001000ff117424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x0000660005097a24ULL, 0x000fe200078e02ffULL, 0x0000004015177810ULL, 0x000fc40007ffe0ffULL,
0x000000000b0c7984ULL, 0x0022e40000000c00ULL, 0x00000fff09057811ULL, 0x040fe400078e40ffULL,
0x000400000b1c7984ULL, 0x0003220000000c00ULL, 0x01ffffff09097812ULL, 0x000fe200078ec0ffULL,
0x0000580018187a24ULL, 0x004fe400078e0207ULL, 0x0000080046077824ULL, 0x000fe400078e00ffULL,
0x00000300180a7a24ULL, 0x000fca00078e02ffULL, 0x000000040a127c10ULL, 0x000fc8000fffe0ffULL,
0x0000001205107211ULL, 0x000fca00078fa0ffULL, 0x00006c0010107625ULL, 0x000fca00078e0011ULL,
0x0000000710107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000ff0000720cULL, 0x000fc60000725670ULL, 0x0000001015147825ULL, 0x000fc800078e0010ULL,
0x0000001017167825ULL, 0x000fe200078e0010ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x01afe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000000112137824ULL, 0x000fe200078e0209ULL,
0x0000007010197812ULL, 0x000fe400078ec0ffULL, 0x0000000c111b7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012107625ULL, 0x000fc800078e000bULL, 0x00006c0013127625ULL, 0x000fe200078e000bULL,
0x000000101b107210ULL, 0x000fc80007a1e019ULL, 0x000000121b127210ULL, 0x000fe40007c7e019ULL,
0x00000011ff117210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x0000000610007986ULL, 0x0003e8000c101908ULL, 0x0000000812007986ULL, 0x0003e4000c101908ULL,
0x0000000c14007986ULL, 0x01a3e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001c16007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x002fe200078e00ffULL,
0xffffffff1a0b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a00180c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b0c0c79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0c00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f05270ULL, 0x00002c7000008947ULL, 0x000fea0003800000ULL,
0x000000ff4f00720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000010a0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe20000011600ULL, 0x00000080ff197424ULL, 0x000fc600078e00ffULL,
0x00000070061b7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0c7625ULL, 0x000fe200078e0019ULL,
0x0000000c08087812ULL, 0x000fc600078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e0019ULL,
0x0000000c080c7210ULL, 0x000fc8000791e01bULL, 0x0000000e080e7210ULL, 0x000fe40007b5e01bULL,
0x0000000dff0d7210ULL, 0x000fe400007e24ffULL, 0x0000000fff0f7210ULL, 0x000fc600017e64ffULL,
0x000000080c067981ULL, 0x000368000c1e1900ULL, 0x000000080e0b7981ULL, 0x000362000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x000000020a0c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0019ULL,
0x0000000c080c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c117981ULL, 0x000362000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x000000030a0c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0019ULL, 0x0000000c080c7210ULL, 0x000fc8000791e01bULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c137981ULL, 0x000362000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x000000040a0c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0019ULL,
0x0000000c080c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c157981ULL, 0x000362000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000000050a0c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0019ULL, 0x0000000c080c7210ULL, 0x000fc8000791e01bULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c177981ULL, 0x000362000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe40003f06070ULL, 0x000000060a0c7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0019ULL, 0x0000000c080c7210ULL, 0x000fe40007a3e01bULL,
0x000000070a0e0810ULL, 0x000fe40007ffe0ffULL, 0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL,
0x00006c000e0e0625ULL, 0x000fe400078e0019ULL, 0x000000080c197981ULL, 0x000366000c1e1900ULL,
0x0000000e080e0210ULL, 0x000fc80007c7e01bULL, 0x0000000fff0f0210ULL, 0x000fcc0001fe84ffULL,
0x000000080e0f0981ULL, 0x000366000c1e1900ULL, 0x000000071a087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x020fe400078e0006ULL, 0x000000081b0e7824ULL, 0x040fe200078e00ffULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000000081b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000010e0c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000010a0c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x00000070101d7812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e01dULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e0d7810ULL, 0x042fe40007ffe0ffULL,
0x000000020e0c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000000b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000010a0c7824ULL, 0x000fe200078e020dULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007b3e00bULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c0b7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e0d7810ULL, 0x042fe40007ffe0ffULL, 0x000000030e0c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000010a0c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e0d7810ULL, 0x042fe40007ffe0ffULL,
0x000000040e0c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000010a0c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e0d7810ULL, 0x042fe40007ffe0ffULL, 0x000000050e0c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000010a0c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e015ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e0d7810ULL, 0x042fe40007ffe0ffULL,
0x000000060e0c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000010a0c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e017ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e0d7810ULL, 0x042fe40007ffe0ffULL, 0x000000070e0c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001906067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000010a0c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007010197812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e019ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e0d7810ULL, 0x002fe40007ffe0ffULL,
0x0000000f06067209ULL, 0x000fe40007810000ULL, 0x000003000d007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000010a0c7824ULL, 0x000fe200078e020dULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007a3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL,
0x000000080c0f7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000087824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x020fc80000011600ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e0208ULL,
0x000000060b007388ULL, 0x0005e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000145167824ULL, 0x000fe200078e020aULL, 0x00000001ff0b7819ULL, 0x004fe20000011600ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000002ff0d7819ULL, 0x002fe2000001164fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000016050c7211ULL, 0x000fe200078fa0ffULL,
0x00001000ff117424ULL, 0x000fe200078e00ffULL, 0x0000007006087812ULL, 0x000fe200078ec0ffULL,
0x000002004f4f7824ULL, 0x000fe200078e00ffULL, 0x0000000c0b0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0202ULL, 0x000000010d067812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e0011ULL, 0x0000004000117810ULL, 0x040fe20007ffe0ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000006000137810ULL, 0x000fe20007ffe0ffULL,
0x00000002450b8824ULL, 0x000fe200078e0246ULL, 0x000000070c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f087824ULL, 0x000fe200078e0208ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000002450f8824ULL, 0x000fe200078e0246ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000020b1b8824ULL, 0x100fe200078e0206ULL, 0x000008004f0b7812ULL, 0x000fe200078ec0ffULL,
0x000000020f1d8824ULL, 0x000fe200078e0206ULL, 0x00000020000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109148824ULL, 0x000fe200078e0216ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000008067984ULL, 0x0002a20000000800ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000030045007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000001040b7824ULL, 0x000fe200078e020bULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x000000100f0e7825ULL, 0x000fc800078e000cULL,
0x0000001011107825ULL, 0x000fc800078e000cULL, 0x0000001013127825ULL, 0x000fc800078e000cULL,
0x00006c0016168625ULL, 0x000fc800078e0017ULL, 0x000000081b1b8824ULL, 0x000fe400078e0200ULL,
0x0000001000197824ULL, 0x040fe400078e020bULL, 0x00000010000c7825ULL, 0x000fe200078e000cULL,
0x000045801b1b8811ULL, 0x000fc600078e20ffULL, 0x000000081d1d8824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c197faeULL, 0x0007e2000b901c48ULL,
0x0000001000148825ULL, 0x000fc600078e0014ULL, 0x000041801d1d8811ULL, 0x000fe200078e20ffULL,
0x0000001000168825ULL, 0x000fe200078e0016ULL, 0x003800000e197faeULL, 0x0009e6000b901c48ULL,
0x000000ffff087224ULL, 0x002fe200078e00ffULL, 0x0058000010197faeULL, 0x0003e2000b901c48ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0078000012197faeULL, 0x0007e8000b901c48ULL,
0x00000000141b8faeULL, 0x000be2000b901c48ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000161d8faeULL, 0x0009e2000b901c48ULL, 0x0000000000107805ULL, 0x002fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x020fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x004fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x000fca00078e0045ULL, 0x000000022e2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e002eULL, 0x00000002ff2c7819ULL, 0x002fe20000011600ULL,
0x0000000245417824ULL, 0x000fe200078e0246ULL, 0x000003002d007a0cULL, 0x000fe20003f06070ULL,
0x00000040432e7824ULL, 0x000fe200078e00ffULL, 0x000000072c487812ULL, 0x040fe200078ec0ffULL,
0x000000082c2f7824ULL, 0x040fe200078e00ffULL, 0x0000002cff4a7212ULL, 0x000fe200078e33ffULL,
0x000000082c2b7824ULL, 0x000fe200078e00ffULL, 0x000000802e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000082c317824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff82f3a7812ULL, 0x100fe200078ee248ULL, 0x0000001000497824ULL, 0x000fe200078e00ffULL,
0x000000012b3c7812ULL, 0x000fe200078ef648ULL, 0x0000010041417824ULL, 0x000fe200078e002eULL,
0x000000022b3e7812ULL, 0x000fc400078ef648ULL, 0x000000032b407812ULL, 0x140fe400078ef648ULL,
0x000000042b427812ULL, 0x140fe400078ef648ULL, 0x000000052b447812ULL, 0x140fe400078ef648ULL,
0x000000062b487812ULL, 0x000fe400078ef648ULL, 0xfffffff8314a7812ULL, 0x000fe400078ee24aULL,
0x000000082c2b7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x008fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x000000010a387824ULL, 0x100fe200078e022dULL,
0x00000001ff307819ULL, 0x000fe2000001162dULL, 0x00001000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002000337810ULL, 0x000fc40007ffe0ffULL, 0x00000038052e7211ULL, 0x000fe400078fa0ffULL,
0x0000000130317812ULL, 0x000fe200078ec0ffULL, 0x000004002d307824ULL, 0x000fe200078e00ffULL,
0x0000004000357810ULL, 0x000fe20007ffe0ffULL, 0x00006c002e2e7625ULL, 0x000fe200078e002fULL,
0x00000060003f7810ULL, 0x000fc60007ffe0ffULL, 0x0000000245329824ULL, 0x140fe200078e0246ULL,
0x000000072e2e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000245349824ULL, 0x000fe400078e0246ULL,
0x00000002323d9824ULL, 0x100fe400078e0231ULL, 0x0000000234479824ULL, 0x000fe200078e0231ULL,
0x0000080030317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2f7224ULL, 0x000fe400000e062fULL,
0x0000000109369824ULL, 0x000fc400078e0238ULL, 0x0000000104317824ULL, 0x000fe400078e0231ULL,
0x00000080ff379424ULL, 0x000fe400078e00ffULL, 0x00000080ff399424ULL, 0x000fe400078e00ffULL,
0x00000010003b7824ULL, 0x000fe400078e0231ULL, 0x00006c0036369625ULL, 0x000fc800078e0037ULL,
0x0000001000307825ULL, 0x000fc800078e002eULL, 0x0000001033327825ULL, 0x100fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000303b7faeULL, 0x0003e6000b901c48ULL,
0x0000001035347825ULL, 0x100fe200078e002eULL, 0x00380000323b7faeULL, 0x0003e6000b901c48ULL,
0x00006c0038389625ULL, 0x000fe200078e0039ULL, 0x00580000343b7faeULL, 0x0003e6000b901c48ULL,
0x000000103f2e7825ULL, 0x000fc800078e002eULL, 0x000000083d3d9824ULL, 0x100fe200078e0200ULL,
0x007800002e3b7faeULL, 0x0003e2000b901c48ULL, 0x00000008473f9824ULL, 0x000fe400078e0200ULL,
0x0000001000369825ULL, 0x040fe200078e0036ULL, 0x000045803d3d9811ULL, 0x000fe400078e20ffULL,
0x000041803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000001000389825ULL, 0x000fe400078e0038ULL,
0x00000000363d9faeULL, 0x0003e8000b901c48ULL, 0x00000000383f9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff307819ULL, 0x002fe20000011600ULL, 0x000000082b347824ULL, 0x040fe200078e00ffULL,
0x000000072b2f7812ULL, 0x040fe200078ec0ffULL, 0x000000082b327824ULL, 0x000fe200078e00ffULL,
0x0000007049507812ULL, 0x000fe200078ec0ffULL, 0x00000400432e7824ULL, 0x000fe200078e00ffULL,
0x0000000c30317812ULL, 0x000fc400078ec0ffULL, 0xfffffff834307812ULL, 0x100fe400078ee22fULL,
0x0000004131417210ULL, 0x000fe20007ffe050ULL, 0x000000082b317824ULL, 0x000fe200078e00ffULL,
0x0000000132347812ULL, 0x140fe400078ef62fULL, 0x0000000232367812ULL, 0x140fe400078ef62fULL,
0x0000000332387812ULL, 0x140fe400078ef62fULL, 0x00000004324c7812ULL, 0x000fc400078ef62fULL,
0x00000005324e7812ULL, 0x140fe400078ef62fULL, 0x0000000632327812ULL, 0x000fe200078ef62fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000008002e2f7812ULL, 0x000fe200078ec0ffULL,
0x0041800041337984ULL, 0x000e620000000800ULL, 0x00000004002e7824ULL, 0x000fe200078e00ffULL,
0x0000002bff507212ULL, 0x000fe400078e33ffULL, 0x00000180042f7810ULL, 0x000fe20007ffe02fULL,
0x0045800041527984ULL, 0x000ea20000000800ULL, 0xfffffff831507812ULL, 0x000fe400078ee250ULL,
0x0000000c2e317812ULL, 0x000fe200078ec0ffULL, 0x000000103e3e7824ULL, 0x000fc400078e022fULL,
0x0000001040407824ULL, 0x100fe400078e022fULL, 0x0000001042427824ULL, 0x100fe400078e022fULL,
0x0000001044447824ULL, 0x100fe400078e022fULL, 0x0000001048487824ULL, 0x100fe400078e022fULL,
0x00000001313e7824ULL, 0x000fe400078e023eULL, 0x000000104a4a7824ULL, 0x000fc400078e022fULL,
0x0000000131407824ULL, 0x040fe400078e0240ULL, 0x0000001030307824ULL, 0x100fe200078e022fULL,
0x000000003e3e7984ULL, 0x000ee20000000800ULL, 0x0000000131427824ULL, 0x040fe400078e0242ULL,
0x0000001034347824ULL, 0x100fe200078e022fULL, 0x0000000040407984ULL, 0x000f220000000800ULL,
0x0000000131447824ULL, 0x040fe400078e0244ULL, 0x0000001036367824ULL, 0x000fe200078e022fULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x0000000131487824ULL, 0x000fc400078e0248ULL,
0x0000001038387824ULL, 0x000fe200078e022fULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x00000001314a7824ULL, 0x040fe200078e024aULL, 0x0000003306337221ULL, 0x002fe20000010100ULL,
0x000000104c4c7824ULL, 0x100fe200078e022fULL, 0x0000000048487984ULL, 0x000e620000000800ULL,
0x0000000131307824ULL, 0x000fe200078e0230ULL, 0x3fb8aa3b33337820ULL, 0x000fe20000410000ULL,
0x000000104e4e7824ULL, 0x000fe200078e022fULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x0000000131347824ULL, 0x000fc400078e0234ULL, 0x0000001032327824ULL, 0x100fe200078e022fULL,
0x0000000030307984ULL, 0x000e620000000800ULL, 0x0000000131367824ULL, 0x040fe200078e0236ULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x000000103a3a7824ULL, 0x100fe200078e022fULL,
0x0000000034347984ULL, 0x000e620000000800ULL, 0x000000103c3c7824ULL, 0x100fe400078e022fULL,
0x0000001050507824ULL, 0x000fe200078e022fULL, 0x0000000036367984ULL, 0x000e620000000800ULL,
0x0000000131387824ULL, 0x000fc400078e0238ULL, 0x00000001314c7824ULL, 0x040fe400078e024cULL,
0x00000001314e7824ULL, 0x040fe400078e024eULL, 0x0000000131327824ULL, 0x000fe200078e0232ULL,
0x0000000038387984ULL, 0x000e620000000800ULL, 0x000000013a3a7824ULL, 0x000fe200078e0231ULL,
0x0000005233597220ULL, 0x004fe20000410000ULL, 0x00000001313c7824ULL, 0x040fe200078e023cULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x0000000131507824ULL, 0x000fe200078e0250ULL,
0x0000002a592a7221ULL, 0x000fe20000010000ULL, 0x2000003eff567230ULL, 0x108fe20000004100ULL,
0x000000004e4e7984ULL, 0x000ee20000000800ULL, 0x3000003eff357230ULL, 0x000fc40000004100ULL,
0x20000040ff3e7230ULL, 0x110fe20000004100ULL, 0x0000000032327984ULL, 0x000f220000000800ULL,
0x30000040ff377230ULL, 0x000fe40000004100ULL, 0x20000042ff407230ULL, 0x120fe20000004100ULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x30000042ff3f7230ULL, 0x000fe40000004100ULL,
0x20000044ff427230ULL, 0x100fe20000004100ULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x30000044ff417230ULL, 0x000fc40000004100ULL, 0x20000048ff447230ULL, 0x102fe20000004100ULL,
0x0000000050507984ULL, 0x000e620000000800ULL, 0x30000048ff437230ULL, 0x000fe40000004100ULL,
0x2000004aff487230ULL, 0x100fe40000004100ULL, 0x3000004aff477230ULL, 0x000fe40000004100ULL,
0x20000030ff4a7230ULL, 0x100fe40000004100ULL, 0x30000030ff497230ULL, 0x000fc40000004100ULL,
0x20000034ff307230ULL, 0x100fe40000004100ULL, 0x30000034ff4b7230ULL, 0x000fe40000004100ULL,
0x000000ffff2e7224ULL, 0x000fe400078e002dULL, 0x20000036ff347230ULL, 0x100fe40000004100ULL,
0x30000036ff4d7230ULL, 0x000fe20000004100ULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x20000038ff367230ULL, 0x000fc40000004100ULL, 0x30000038ff4f7230ULL, 0x000fe40000004100ULL,
0x2000004cff387230ULL, 0x104fe40000004100ULL, 0x3000004cff517230ULL, 0x000fe40000004100ULL,
0x2000004eff4c7230ULL, 0x108fe40000004100ULL, 0x3000004eff537230ULL, 0x000fe40000004100ULL,
0x20000032ff4e7230ULL, 0x010fc40000004100ULL, 0x30000032ff557230ULL, 0x000fe40000004100ULL,
0x2000003aff527230ULL, 0x120fe40000004100ULL, 0x3000003aff317230ULL, 0x000fe40000004100ULL,
0x2000003cff547230ULL, 0x100fe40000004100ULL, 0x3000003cff337230ULL, 0x000fe40000004100ULL,
0x20000050ff327230ULL, 0x002fc40000004100ULL, 0x30000050ff577230ULL, 0x000fe20000004100ULL,
0x00005bc27f007947ULL, 0x000fea000b800000ULL, 0x00001f2c592f7589ULL, 0x0002a400000e0000ULL,
0x00005c227f007947ULL, 0x000fea000b800000ULL, 0x00001f2b592b7589ULL, 0x00072400000e0000ULL,
0x0000002f52297223ULL, 0x084fe20000010029ULL, 0x0000002f31287223ULL, 0x080fe20000010028ULL,
0x0000002f54257223ULL, 0x080fe20000010025ULL, 0x0000002f33247223ULL, 0x080fe20000010024ULL,
0x0000002f56217223ULL, 0x080fe20000010021ULL, 0x0000002f35207223ULL, 0x080fe20000010020ULL,
0x0000002f3e1d7223ULL, 0x080fe2000001001dULL, 0x0000002f371c7223ULL, 0x080fe2000001001cULL,
0x0000002f40197223ULL, 0x080fe20000010019ULL, 0x0000002f3f187223ULL, 0x080fe20000010018ULL,
0x0000002f42157223ULL, 0x080fe20000010015ULL, 0x0000002f41147223ULL, 0x080fe20000010014ULL,
0x0000002f44117223ULL, 0x080fe20000010011ULL, 0x0000002f43107223ULL, 0x080fe20000010010ULL,
0x0000002f480d7223ULL, 0x080fe2000001000dULL, 0x0000002f470c7223ULL, 0x000fe2000001000cULL,
0x0000002b4a277223ULL, 0x090fe20000010027ULL, 0x0000002b49267223ULL, 0x080fe20000010026ULL,
0x0000002b30237223ULL, 0x080fe20000010023ULL, 0x0000002b4b227223ULL, 0x080fe20000010022ULL,
0x0000002b341f7223ULL, 0x080fe2000001001fULL, 0x0000002b4d1e7223ULL, 0x080fe2000001001eULL,
0x0000002b361b7223ULL, 0x080fe2000001001bULL, 0x0000002b4f1a7223ULL, 0x080fe2000001001aULL,
0x0000002b38177223ULL, 0x080fe20000010017ULL, 0x0000002b51167223ULL, 0x080fe20000010016ULL,
0x0000002b4c137223ULL, 0x080fe20000010013ULL, 0x0000002b53127223ULL, 0x080fe20000010012ULL,
0x0000002b4e0f7223ULL, 0x080fe2000001000fULL, 0x0000002b550e7223ULL, 0x080fe2000001000eULL,
0x0000002b320b7223ULL, 0x080fe2000001000bULL, 0x0000002b57087223ULL, 0x000fe20000010008ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x004ea20000000000ULL, 0x000000ff4600720cULL, 0x000fe20003f05270ULL,
0x0000001000047824ULL, 0x004fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c00057812ULL, 0x000fca00078ec0ffULL,
0x0000000105067824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000047824ULL, 0x004fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004007812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc600078ec0ffULL, 0x0000008045007824ULL, 0x000fc800078e0200ULL,
0x0000000105057824ULL, 0x000fca00078e0200ULL, 0x0049802a05007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800006007984ULL, 0x000f280000000800ULL,
0x004a000006057984ULL, 0x004ea20000000800ULL, 0x00000000ff007221ULL, 0x010fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0000ULL, 0x0000b5f0002a7802ULL, 0x000fe40000000f00ULL,
0x00005cc000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000ea40000001000ULL,
0xbf80000000047423ULL, 0x004fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff077819ULL, 0x004fe40000011600ULL, 0x00000008003e7811ULL, 0x000fc600078ff0ffULL,
0x00001f0704057589ULL, 0x002e6200000e0000ULL, 0x0000003eff407212ULL, 0x000fe200078e33ffULL,
0x000000083e097824ULL, 0x000fe400078e00ffULL, 0x00001f3e04067589ULL, 0x00052600000e0000ULL,
0xfffffff809407812ULL, 0x040fe400078ee240ULL, 0xfffffff809327812ULL, 0x000fc600078ee23eULL,
0x0000001040407824ULL, 0x100fe200078e0203ULL, 0x00000007ff047212ULL, 0x004fe200078e33ffULL,
0x0000001032327824ULL, 0x000fe200078e0203ULL, 0x0000002905297220ULL, 0x042fe20000410000ULL,
0x0000002805287220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000000c050c7220ULL, 0x000fe20000410000ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000f060f7220ULL, 0x050fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0xfffffff805427812ULL, 0x000fe200078ee204ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000000707057812ULL, 0x040fe200078ec0ffULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000000b060b7220ULL, 0x040fe20000410000ULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0x0000000105087812ULL, 0x000fc400078e3cffULL,
0x00000002050a7812ULL, 0x040fe400078e3cffULL, 0x00000003052a7812ULL, 0x000fe200078e3cffULL,
0x0000000807087824ULL, 0x000fe200078e0208ULL, 0x00000004052c7812ULL, 0x000fe200078e3cffULL,
0x00000008070a7824ULL, 0x000fe200078e020aULL, 0x00000005052e7812ULL, 0x000fe200078e3cffULL,
0x00000008072a7824ULL, 0x000fe200078e022aULL, 0x0000000605307812ULL, 0x000fe200078e3cffULL,
0x00000008072c7824ULL, 0x040fe200078e022cULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x00000008072e7824ULL, 0x040fe200078e022eULL, 0x000000073e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000807307824ULL, 0x000fe200078e0230ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000400117824ULL, 0x000fe200078e00ffULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x0000000b0606723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0xfffffff804047812ULL, 0x000fe200078ee207ULL,
0x000000102a2a7824ULL, 0x100fe200078e0203ULL, 0x000000010f057812ULL, 0x040fe200078e3cffULL,
0x000000102c2c7824ULL, 0x100fe200078e0203ULL, 0x000000020f077812ULL, 0x040fe200078e3cffULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x000000030f097812ULL, 0x040fe200078e3cffULL,
0x000000083e347824ULL, 0x040fe200078e0205ULL, 0x000000040f0b7812ULL, 0x040fe200078e3cffULL,
0x000000083e367824ULL, 0x040fe200078e0207ULL, 0x000000050f0d7812ULL, 0x040fe200078e3cffULL,
0x000000083e387824ULL, 0x040fe200078e0209ULL, 0x000000060f0f7812ULL, 0x000fe200078e3cffULL,
0x000000083e3a7824ULL, 0x000fe200078e020bULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x000000083e3c7824ULL, 0x040fe200078e020dULL, 0x0000000c111d7812ULL, 0x000fe200078ec0ffULL,
0x000000083e3e7824ULL, 0x000fe200078e020fULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000001042077824ULL, 0x100fe200078e0203ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x000000011d057824ULL, 0x040fe200078e0204ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x000000102e2e7824ULL, 0x100fe200078e0203ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000001030307824ULL, 0x100fe200078e0203ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x100fe200078e0203ULL, 0x0000002805007388ULL, 0x0003e20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e0203ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x0000001038387824ULL, 0x100fe200078e0203ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x000000103a3a7824ULL, 0x100fe200078e0203ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0203ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x000000103e3e7824ULL, 0x000fe200078e0203ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x000000011d117824ULL, 0x040fe200078e0207ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x000000011d037824ULL, 0x000fc400078e0208ULL, 0x000000011d077824ULL, 0x040fe400078e020aULL,
0x000000011d097824ULL, 0x040fe200078e022aULL, 0x0000002403007388ULL, 0x0005e20000000800ULL,
0x000000011d0b7824ULL, 0x040fe400078e022cULL, 0x000000011d0d7824ULL, 0x040fe200078e022eULL,
0x0000002007007388ULL, 0x000fe20000000800ULL, 0x000000011d0f7824ULL, 0x040fe400078e0230ULL,
0x000000011d137824ULL, 0x040fe200078e0232ULL, 0x0000001c09007388ULL, 0x000fe20000000800ULL,
0x000000011d157824ULL, 0x000fc400078e0234ULL, 0x000000011d057824ULL, 0x042fe200078e0236ULL,
0x000000180b007388ULL, 0x000fe20000000800ULL, 0x000000011d177824ULL, 0x040fe400078e0238ULL,
0x000000011d197824ULL, 0x040fe200078e023aULL, 0x000000140d007388ULL, 0x000fe20000000800ULL,
0x000000011d1f7824ULL, 0x040fe400078e0240ULL, 0x000000011d1b7824ULL, 0x040fe200078e023cULL,
0x000000100f007388ULL, 0x000fe20000000800ULL, 0x000000011d1d7824ULL, 0x000fc400078e023eULL,
0x0000002045217824ULL, 0x000fe200078e0200ULL, 0x0000000c11007388ULL, 0x000fe60000000800ULL,
0x0000001021037824ULL, 0x004fe200078e0202ULL, 0x0000002613007388ULL, 0x000fe80000000800ULL,
0x0000002215007388ULL, 0x000fe80000000800ULL, 0x0000001e05007388ULL, 0x000fe80000000800ULL,
0x0000001a17007388ULL, 0x000fe80000000800ULL, 0x0000001619007388ULL, 0x000fe80000000800ULL,
0x000000121b007388ULL, 0x000fe80000000800ULL, 0x0000000e1d007388ULL, 0x000fe80000000800ULL,
0x000000061f007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000003087984ULL, 0x000e680000000c00ULL, 0x0004000003247984ULL, 0x000ea80000000c00ULL,
0x0008000003207984ULL, 0x000f280000000c00ULL, 0x000c000003287984ULL, 0x000f620000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x004fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000230b0b7230ULL, 0x010fe40000000000ULL, 0x000000220a0a7230ULL, 0x000fe40000000000ULL,
0x0000002109097230ULL, 0x000fe40000000000ULL, 0x0000002008087230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x020fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000000803007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002403007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4500720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000ea20000002600ULL,
0x00000020001d7810ULL, 0x042fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x00000040001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x00000008461b7824ULL, 0x040fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe2000001161dULL, 0x00000008461a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fc4000001161fULL, 0x00000003ff177819ULL, 0x000fe40000011621ULL,
0x0000000715047812ULL, 0x000fe400078e481dULL, 0x0000000716067812ULL, 0x000fe400078e481fULL,
0x0000000717087812ULL, 0x000fe400078e4821ULL, 0x0ffffff804057812ULL, 0x000fe400078ef81dULL,
0x0ffffff806077812ULL, 0x000fe200078ef81fULL, 0x0000001018147824ULL, 0x004fe200078e00ffULL,
0x0ffffff808097812ULL, 0x000fe200078ef821ULL, 0x0000001005087824ULL, 0x100fe200078e0202ULL,
0x00000004050472a4ULL, 0x002fe2000f8e023fULL, 0x00000010070c7824ULL, 0x100fe200078e0202ULL,
0xfffffff014147812ULL, 0x000fe200078ee203ULL, 0x0000001009107824ULL, 0x000fe200078e0202ULL,
0x0000000703037812ULL, 0x100fe200078e4800ULL, 0x0000000008087984ULL, 0x000fe20000000c00ULL,
0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001018197824ULL, 0x040fe200078e00ffULL,
0x0ffffff803037812ULL, 0x100fe200078ef800ULL, 0x000000000c0c7984ULL, 0x000fe20000000c00ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x0000001018007824ULL, 0x000fe200078e00ffULL,
0xfffffff019167812ULL, 0x000fe200078ee216ULL, 0x0000001003037824ULL, 0x000fe200078e0202ULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0000000846027824ULL, 0x000fe200078e00ffULL,
0xfffffff000157812ULL, 0x000fe200078ee215ULL, 0x0000001018187824ULL, 0x000fe200078e00ffULL,
0x0000000003047984ULL, 0x0002a20000000c00ULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x0000000846467824ULL, 0x000fe200078e00ffULL, 0xfffffff8021d7812ULL, 0x000fc400078ee21dULL,
0xfffffff018177812ULL, 0x000fe400078ee217ULL, 0x00000004161a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x00005a0014027a11ULL, 0x040fe400078040ffULL,
0x0000000417007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005b0014037a11ULL, 0x000fe400000f4403ULL, 0x0000000415157c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a001a167a11ULL, 0x000fe200078240ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a0000187a11ULL, 0x000fc400078440ffULL,
0x00005b001a177a11ULL, 0x000fe200008f4417ULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a0015147a11ULL, 0x000fe400078040ffULL, 0xfffffff846217812ULL, 0x000fe200078ee221ULL,
0x000000101f167825ULL, 0x000fe200078e0016ULL, 0x00005b0015157a11ULL, 0x000fe400000f441cULL,
0x00005b0000197a11ULL, 0x000fc600010f4419ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d08ULL,
0x0000000814007986ULL, 0x000fe8000c101d08ULL, 0x0000000c16007986ULL, 0x000fe8000c101d08ULL,
0x0000001018007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x00afe2000001164fULL,
0x00006900ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe200078e00ffULL,
0x01ffffff03037812ULL, 0x000fe400078ec0ffULL, 0x0000000806337981ULL, 0x000366000c1e9900ULL,
0x000000024e327824ULL, 0x000fca00078e0203ULL, 0x0000004d3200720cULL, 0x000fe40003f06070ULL,
0x000000014e007810ULL, 0x000fd60007ffe0ffULL, 0x000000020a038824ULL, 0x000fc800078e00ffULL,
0x0000640003048a24ULL, 0x000fc800078e0232ULL, 0x0000600004048625ULL, 0x000fca00078e0011ULL,
0x0000000804308981ULL, 0x000362000c1e1900ULL, 0x000000470000720cULL, 0x000fe20003f06070ULL,
0x000000404f037824ULL, 0x000fe400078e00ffULL, 0x0000008015027824ULL, 0x000fe400078e00ffULL,
0x000001004e097824ULL, 0x000fe400078e0203ULL, 0x0000008017177824ULL, 0x000fc600078e00ffULL,
0x00000040020b7812ULL, 0x000fc600078ef809ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x002e620000000000ULL, 0x00000030170b7224ULL, 0x020fe200078e020bULL,
0x000010004f157811ULL, 0x000fe200078e68ffULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x00000002ff1f7819ULL, 0x102fe20000011611ULL, 0x0000001011217824ULL, 0x000fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe40000011611ULL, 0x0000007f1f007812ULL, 0x040fe400078ec0ffULL,
0x000000081f137810ULL, 0x000fc40007ffe0ffULL, 0x0000003021217812ULL, 0x000fe200078ec0ffULL,
0x000000010b007824ULL, 0x000fe200078e0200ULL, 0x000000101f257810ULL, 0x000fe40007ffe0ffULL,
0x0000007f13067812ULL, 0x000fe200078ec0ffULL, 0x00005e0000047625ULL, 0x000fe200078e0023ULL,
0x000000181f277810ULL, 0x000fe40007ffe0ffULL, 0x0000007f25087812ULL, 0x000fe200078ec0ffULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0x00000021040c7210ULL, 0x000fc40007f1e0ffULL,
0x0000007f27047812ULL, 0x000fe200078ec0ffULL, 0x000000010b087824ULL, 0x000fe200078e0208ULL,
0x000000094c007217ULL, 0x000fe20007800000ULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x000000201f197810ULL, 0x000fe40007ffe0ffULL, 0x0000000314147812ULL, 0x000fe200078e4811ULL,
0x000000010b047824ULL, 0x000fe200078e0204ULL, 0x000000281f1b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a09ULL, 0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0605ULL, 0x00000021060e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x0000007f19067812ULL, 0x000fc400078ec0ffULL,
0x000000002500720cULL, 0x080fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e0023ULL,
0x0000002108087210ULL, 0x080fe40007f3e0ffULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0x0000002104107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0ffffffc14047812ULL, 0x000fe200078ef811ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000001300720cULL, 0x080fe20003f26070ULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000000001f00720cULL, 0x000fc40003f06070ULL,
0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001004177824ULL, 0x000fe200078e0215ULL,
0x0000007f1b047812ULL, 0x000fe200078ec0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000002106127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0605ULL,
0x000000001b00720cULL, 0x080fe20003f46070ULL, 0x000000010b047824ULL, 0x000fe200078e0204ULL,
0xfffffffc13067812ULL, 0x000fe200078ee214ULL, 0x000000ffff137224ULL, 0x000fe200018e0607ULL,
0x000000001900720cULL, 0x080fe20003f66070ULL, 0x00005e0004047625ULL, 0x000fe200078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x000000001f00720cULL, 0x000fc40003f06070ULL, 0x0000001006077824ULL, 0x000fe200078e0215ULL,
0x0000007f1d067812ULL, 0x000fe200078ec0ffULL, 0x0000000425257824ULL, 0x000fe400078e00ffULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x000000000e077faeULL, 0x0005e2000c901c48ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x000000001d00720cULL, 0x000fe20003f26070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x00000021040c7210ULL, 0x002fe20007fde0ffULL,
0x000000010b047824ULL, 0x000fe200078e0206ULL, 0xfffffffc25007812ULL, 0x100fe200078ee214ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19167812ULL, 0x100fe200078ee214ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0xfffffffc1b187812ULL, 0x000fe200078ee214ULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0x0000007f1f0e7812ULL, 0x004fc400078ec0ffULL,
0xfffffffc1d1a7812ULL, 0x000fe200078ee214ULL, 0x000000041f1f7824ULL, 0x000fe200078e00ffULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x000000010b067824ULL, 0x000fe200078e020eULL,
0xfffffffc270e7812ULL, 0x100fe200078ee214ULL, 0x00000010000b7824ULL, 0x000fe200078e0215ULL,
0xfffffffc1f147812ULL, 0x000fe200078ee214ULL, 0x00005e0006067625ULL, 0x000fc600078e0023ULL,
0x00000000080b7faeULL, 0x0003e2000e901c48ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x000000100e0f7824ULL, 0x100fe400078e0215ULL,
0x0000001016177824ULL, 0x100fe400078e0215ULL, 0x0000001018197824ULL, 0x100fe200078e0215ULL,
0x00000000100f7faeULL, 0x0003e2000e101c48ULL, 0x000000101a1b7824ULL, 0x100fe400078e0215ULL,
0x0000001014157824ULL, 0x000fe200078e0215ULL, 0x0000000012177faeULL, 0x0003e2000d901c48ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x000000000c197faeULL, 0x0003e8000d101c48ULL,
0x00000000041b7faeULL, 0x0003e8000c901c48ULL, 0x0000000006157faeULL, 0x0003e2000c101c48ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x00000030170b7224ULL, 0x020fe200078e020bULL, 0x000010004f0d7811ULL, 0x000fe200078e68ffULL,
0x00000080ff157424ULL, 0x000fe200078e00ffULL, 0x00000002ff047819ULL, 0x002fc40000011600ULL,
0x00000003ff057819ULL, 0x000fe40000011600ULL, 0x00000020040f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002804117810ULL, 0x040fe40007ffe0ffULL, 0x0000003004137810ULL, 0x040fe40007ffe0ffULL,
0x0000003804177810ULL, 0x040fe40007ffe0ffULL, 0x0000007f0f127812ULL, 0x000fe200078ec0ffULL,
0x0000000413227824ULL, 0x000fe200078e00ffULL, 0x0000001004097810ULL, 0x040fe20007ffe0ffULL,
0x0000000417247824ULL, 0x000fe200078e00ffULL, 0x0000007f11167812ULL, 0x000fe200078ec0ffULL,
0x000000010b147824ULL, 0x000fe200078e0212ULL, 0x00000018040e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000409127824ULL, 0x000fe200078e00ffULL, 0x0000007f131a7812ULL, 0x000fe200078ec0ffULL,
0x000000010b187824ULL, 0x000fe200078e0216ULL, 0x0000007f04067812ULL, 0x000fe200078ec0ffULL,
0x000000040e167824ULL, 0x000fe200078e00ffULL, 0x0000007f171e7812ULL, 0x000fe200078ec0ffULL,
0x000000010b1c7824ULL, 0x040fe200078e021aULL, 0x0000000804087810ULL, 0x000fe20007ffe0ffULL,
0x000000010b047824ULL, 0x000fe200078e0206ULL, 0x0000000305077812ULL, 0x000fe200078e4800ULL,
0x000000010b207824ULL, 0x000fe200078e021eULL, 0x0000007f08067812ULL, 0x000fe200078ec0ffULL,
0x000000040f1a7824ULL, 0x000fe200078e00ffULL, 0x0000007f090c7812ULL, 0x000fe200078ec0ffULL,
0x00000004111e7824ULL, 0x000fe200078e00ffULL, 0x0000007f0e107812ULL, 0x000fe200078ec0ffULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0xfffffffc120e7812ULL, 0x100fe200078ee207ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0xfffffffc16127812ULL, 0x100fe200078ee207ULL,
0x000000010b067824ULL, 0x040fe200078e0206ULL, 0xfffffffc1a167812ULL, 0x100fe200078ee207ULL,
0x000000010b0c7824ULL, 0x040fe200078e020cULL, 0xfffffffc1e1a7812ULL, 0x100fe200078ee207ULL,
0x000000010b107824ULL, 0x000fe200078e0210ULL, 0xfffffffc08087812ULL, 0x000fe200078ee207ULL,
0x000000100e1b7824ULL, 0x000fe200078e020dULL, 0xfffffffc221e7812ULL, 0x000fe200078ee207ULL,
0x00000010121d7824ULL, 0x000fe200078e020dULL, 0x00000030050b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0015ULL, 0x0ffffffc07007812ULL, 0x000fc400078ef800ULL,
0xfffffffc24227812ULL, 0x000fe200078ee207ULL, 0x0000001008197824ULL, 0x100fe200078e020dULL,
0x0000000b04047210ULL, 0x000fe20007f1e0ffULL, 0x0000001000177824ULL, 0x100fe400078e020dULL,
0x00000010161f7824ULL, 0x100fe400078e020dULL, 0x000000101a217824ULL, 0x000fe400078e020dULL,
0x00005e000c087625ULL, 0x000fc800078e0015ULL, 0x000000101e237824ULL, 0x100fe200078e020dULL,
0x0000000b08087210ULL, 0x000fe20007f5e0ffULL, 0x0000001022257824ULL, 0x000fe400078e020dULL,
0x00005e00100c7625ULL, 0x000fc800078e0015ULL, 0x00005e0006067625ULL, 0x000fc800078e0015ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000000b0c0c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00140e7625ULL, 0x000fe200078e0015ULL, 0x0000000b06067210ULL, 0x000fe40007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x00005e0018107625ULL, 0x000fc800078e0015ULL, 0x00005e001c127625ULL, 0x000fc800078e0015ULL,
0x00005e0020147625ULL, 0x000fc800078e0015ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000b0e0e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000b10107210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000b12127210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000000b14147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000006197faeULL, 0x0003e2000b901c48ULL, 0x000000ffff137224ULL, 0x000fc400010e0613ULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x00000000081b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e8000b901c48ULL, 0x0000000012237faeULL, 0x0003e8000b901c48ULL,
0x0000000014257faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034f00780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x000000204f007824ULL, 0x004fc800078e0200ULL,
0x0000001000067824ULL, 0x002fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x0000000005107984ULL, 0x000e68000000cc00ULL,
0x00000000070c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001405007388ULL, 0x0003e8000000cc00ULL,
0x0000001007007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000474e00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000317919ULL, 0x000ea20000000000ULL,
0x3db504f333337820ULL, 0x000fe20000410000ULL, 0x000064000a357a24ULL, 0x000fe200078e02ffULL,
0xffffffff47377810ULL, 0x000fe20007ffe0ffULL, 0x000000104f347824ULL, 0x000fe200078e00ffULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x000001004e397824ULL, 0x000fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000394c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff087224ULL, 0x002fe200078e0036ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000001000a7810ULL, 0x000fe20007ffe0ffULL, 0x00000bd000007945ULL, 0x000fe20003800000ULL,
0x0000000108367812ULL, 0x000fc400078e0cffULL, 0x00000001ff097819ULL, 0x000fe4000001160aULL,
0x000000020a00780cULL, 0x040fe40003f06070ULL, 0x000000010a407812ULL, 0x000fe200078ec0ffULL,
0x0000030009247a24ULL, 0x000fe400078e024eULL, 0x000000ffff097224ULL, 0x000fe400078e0000ULL,
0x0000010024257824ULL, 0x040fe200078e0203ULL, 0x0000000124267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff007224ULL, 0x000fc600078e000aULL, 0x000000472600720cULL, 0x000fe40003f26070ULL,
0x00000040250b7812ULL, 0x000fca00078ec0ffULL, 0x00000001020b7824ULL, 0x000fcc00078e020bULL,
0x000005d000009947ULL, 0x020fea0003800000ULL, 0x00000002ff3b7819ULL, 0x004fe20000011631ULL,
0x0000000440247824ULL, 0x000fe200078e00ffULL, 0x000000254c0a7217ULL, 0x000fe20007800000ULL,
0x0000000430277c24ULL, 0x000fe2000f8e020bULL, 0x000000083b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000024f2c7824ULL, 0x000fe200078e0236ULL, 0xfffffffc243d7812ULL, 0x000fe200078ee231ULL,
0x000000010a267824ULL, 0x000fe200078e0a25ULL, 0x00000003ff0a7819ULL, 0x000fe20000011631ULL,
0x00000080ff517424ULL, 0x000fe200078e00ffULL, 0x0000007f3b247812ULL, 0x000fe200078ec0ffULL,
0x000000040b2f7824ULL, 0x040fe200078e00ffULL, 0x0000007f0b2e7812ULL, 0x000fc400078ec0ffULL,
0x000000030a3c7812ULL, 0x000fe200078e4831ULL, 0x00000001240a7824ULL, 0x100fe200078e0227ULL,
0x000000263b00720cULL, 0x080fe20003f26070ULL, 0x000000012e247824ULL, 0x000fe200078e0227ULL,
0x000000260b00720cULL, 0x000fe20003f46070ULL, 0x00005e000a0a7625ULL, 0x080fe200078e0051ULL,
0x000010002c2c7811ULL, 0x000fe400078e60ffULL, 0x0ffffffc3c2d7812ULL, 0x000fe200078ef831ULL,
0x00005e0024247625ULL, 0x000fe200078e0051ULL, 0xfffffffc2f2f7812ULL, 0x000fc400078ee23cULL,
0x000000103b3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e022cULL,
0x000000183b417810ULL, 0x000fe20007ffe0ffULL, 0x000000103d0a7825ULL, 0x000fe200078e000aULL,
0x000000203b437810ULL, 0x040fe40007ffe0ffULL, 0x000000283b457810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e022cULL, 0x000000303b497810ULL, 0x000fe20007ffe0ffULL,
0x000000103d247825ULL, 0x000fe200078e0024ULL, 0x000000383b3b7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2d7faeULL, 0x0003e2000c901c48ULL,
0x000000263f00720cULL, 0x000fc40003f26070ULL, 0x000000264300720cULL, 0x080fe20003f66070ULL,
0x00000000242f7faeULL, 0x0005e2000d101c48ULL, 0x000000264100720cULL, 0x080fe20003f46070ULL,
0x000000043b4b7824ULL, 0x000fe200078e00ffULL, 0x000000264500720cULL, 0x080fe40003f86070ULL,
0x000000264900720cULL, 0x080fe40003fa6070ULL, 0x000000263b00720cULL, 0x000fe40003fc6070ULL,
0x0000007f3f0a7812ULL, 0x042fe200078ec0ffULL, 0x000000043f3f7824ULL, 0x000fe200078e00ffULL,
0x0000007f43267812ULL, 0x040fe200078ec0ffULL, 0x0000000443437824ULL, 0x000fe200078e00ffULL,
0x0000007f41247812ULL, 0x044fe200078ec0ffULL, 0x0000000441417824ULL, 0x000fe200078e00ffULL,
0x0000007f452e7812ULL, 0x040fe200078ec0ffULL, 0x0000000445457824ULL, 0x000fe200078e00ffULL,
0x0000007f493a7812ULL, 0x040fe200078ec0ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0x0000007f3b3e7812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0227ULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee23cULL, 0x0000000124247824ULL, 0x100fe200078e0227ULL,
0xfffffffc41417812ULL, 0x100fe200078ee23cULL, 0x0000000126267824ULL, 0x100fe200078e0227ULL,
0xfffffffc43437812ULL, 0x100fe200078ee23cULL, 0x000000012e2d7824ULL, 0x100fe200078e0227ULL,
0xfffffffc45457812ULL, 0x100fe200078ee23cULL, 0x000000013a2e7824ULL, 0x000fe200078e0227ULL,
0xfffffffc49497812ULL, 0x100fe200078ee23cULL, 0x00005e000a0a7625ULL, 0x000fe200078e0051ULL,
0xfffffffc4b4b7812ULL, 0x000fc600078ee23cULL, 0x000000013e3a7824ULL, 0x000fe400078e0227ULL,
0x00005e0024247625ULL, 0x000fc800078e0051ULL, 0x000000103f3f7824ULL, 0x100fe400078e022cULL,
0x0000001041417824ULL, 0x100fe400078e022cULL, 0x0000001043437824ULL, 0x100fe400078e022cULL,
0x0000001045457824ULL, 0x100fe400078e022cULL, 0x0000001049497824ULL, 0x100fe400078e022cULL,
0x000000104b4b7824ULL, 0x000fc400078e022cULL, 0x00005e0026267625ULL, 0x000fc800078e0051ULL,
0x00005e002d2c7625ULL, 0x000fc800078e0051ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0051ULL,
0x00005e003a3a7625ULL, 0x000fc800078e0051ULL, 0x000000103d0a7825ULL, 0x000fc800078e000aULL,
0x000000103d247825ULL, 0x040fe200078e0024ULL, 0x000000000a3f7faeULL, 0x0003e6000c901c48ULL,
0x000000103d267825ULL, 0x040fe200078e0026ULL, 0x0000000024417faeULL, 0x0003e6000d101c48ULL,
0x000000103d2c7825ULL, 0x040fe200078e002cULL, 0x0000000026437faeULL, 0x0003e6000d901c48ULL,
0x000000103d2e7825ULL, 0x040fe200078e002eULL, 0x000000002c457faeULL, 0x0003e6000e101c48ULL,
0x000000103d3a7825ULL, 0x000fe200078e003aULL, 0x000000002e497faeULL, 0x0003e8000e901c48ULL,
0x000000003a4b7faeULL, 0x0003e2000f101c48ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff0a7819ULL, 0x004fe20000011631ULL, 0x00000004300b7c24ULL, 0x000fc4000f8e020bULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x000000080a257810ULL, 0x040fe40007ffe0ffULL,
0x000000100a277810ULL, 0x040fe40007ffe0ffULL, 0x000000180a2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000200a2f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000427457824ULL, 0x000fe200078e00ffULL,
0x000000280a3b7810ULL, 0x040fe20007ffe0ffULL, 0x000000042d497824ULL, 0x000fe200078e00ffULL,
0x000000300a3d7810ULL, 0x040fe20007ffe0ffULL, 0x000000042f4b7824ULL, 0x000fe200078e00ffULL,
0x000000380a437810ULL, 0x040fe20007ffe0ffULL, 0x000000043b517824ULL, 0x000fe200078e00ffULL,
0x0000007f0a247812ULL, 0x000fe200078ec0ffULL, 0x000000043d557824ULL, 0x000fe200078e00ffULL,
0x0000007f250a7812ULL, 0x000fe200078ec0ffULL, 0x0000000443577824ULL, 0x000fe200078e00ffULL,
0x0000007f27267812ULL, 0x000fe200078ec0ffULL, 0x0000000124247824ULL, 0x100fe200078e020bULL,
0x0000007f2d2c7812ULL, 0x000fe200078ec0ffULL, 0x000000010a2e7824ULL, 0x100fe200078e020bULL,
0x0000007f2f3e7812ULL, 0x000fe200078ec0ffULL, 0x00000001263a7824ULL, 0x100fe200078e020bULL,
0x0000007f3b427812ULL, 0x000fe200078ec0ffULL, 0x000000012c3c7824ULL, 0x100fe200078e020bULL,
0x0000007f3d447812ULL, 0x000fe200078ec0ffULL, 0x000000013e3e7824ULL, 0x100fe200078e020bULL,
0x0000007f43467812ULL, 0x000fe200078ec0ffULL, 0x0000000142427824ULL, 0x000fe200078e020bULL,
0x00000003ff0a7819ULL, 0x000fe20000011631ULL, 0x0000000144447824ULL, 0x000fc400078e020bULL,
0x0000000146467824ULL, 0x000fe400078e020bULL, 0x0000000440267824ULL, 0x000fe400078e00ffULL,
0x000000024f0b7824ULL, 0x000fc600078e0236ULL, 0xfffffffc26417812ULL, 0x100fe400078ee231ULL,
0x000010000b2c7811ULL, 0x000fe200078e60ffULL, 0x00000004250b7824ULL, 0x000fe200078e00ffULL,
0x000000030a267812ULL, 0x000fc800078e4831ULL, 0x0ffffffc26257812ULL, 0x000fe400078ef831ULL,
0xfffffffc0b277812ULL, 0x100fe200078ee226ULL, 0x00005e00240a7625ULL, 0x080fe200078e003fULL,
0xfffffffc452d7812ULL, 0x100fe400078ee226ULL, 0xfffffffc492f7812ULL, 0x000fe200078ee226ULL,
0x0000001025437824ULL, 0x000fe200078e022cULL, 0xfffffffc4b3b7812ULL, 0x000fe200078ee226ULL,
0x0000001027457824ULL, 0x000fe200078e022cULL, 0xfffffffc513d7812ULL, 0x100fe200078ee226ULL,
0x00005e002e247625ULL, 0x000fe200078e003fULL, 0xfffffffc55557812ULL, 0x000fc400078ee226ULL,
0xfffffffc57577812ULL, 0x000fe200078ee226ULL, 0x000000102d497824ULL, 0x100fe400078e022cULL,
0x000000102f4b7824ULL, 0x100fe400078e022cULL, 0x000000103b517824ULL, 0x100fe400078e022cULL,
0x000000103d537824ULL, 0x100fe400078e022cULL, 0x0000001055557824ULL, 0x100fe400078e022cULL,
0x0000001057577824ULL, 0x000fc400078e022cULL, 0x00005e003a267625ULL, 0x000fc800078e003fULL,
0x00005e003c2c7625ULL, 0x000fc800078e003fULL, 0x00005e003e2e7625ULL, 0x000fc800078e003fULL,
0x00005e00423a7625ULL, 0x000fc800078e003fULL, 0x00000010410a7825ULL, 0x000fc800078e000aULL,
0x00005e00443c7625ULL, 0x080fe200078e003fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a437faeULL, 0x0003e6000b901c48ULL, 0x00005e00463e7625ULL, 0x000fc800078e003fULL,
0x0000001041247825ULL, 0x000fc800078e0024ULL, 0x0000001041267825ULL, 0x040fe200078e0026ULL,
0x0000000024457faeULL, 0x0003e6000b901c48ULL, 0x00000010412c7825ULL, 0x040fe200078e002cULL,
0x0000000026497faeULL, 0x0003e6000b901c48ULL, 0x00000010412e7825ULL, 0x040fe200078e002eULL,
0x000000002c4b7faeULL, 0x0003e6000b901c48ULL, 0x00000010413a7825ULL, 0x040fe200078e003aULL,
0x000000002e517faeULL, 0x0003e6000b901c48ULL, 0x00000010413c7825ULL, 0x040fe200078e003cULL,
0x000000003a537faeULL, 0x0003e6000b901c48ULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0x000000003c557faeULL, 0x0003e8000b901c48ULL, 0x000000003e577faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4000720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff0b7624ULL, 0x002fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x000000020b327824ULL, 0x000fca00078e0232ULL, 0x0000004d3200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x00000002350a7824ULL, 0x000fe400078e0232ULL,
0x00000004ff0b7424ULL, 0x000fc800078e00ffULL, 0x000060000a0a7625ULL, 0x000fca00078e000bULL,
0x000000080a307981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002031407810ULL, 0x000fe20007ffe0ffULL,
0x000000024f3d7824ULL, 0x002fe200078e0208ULL, 0xfffffff8313e7812ULL, 0x000fe200078ec0ffULL,
0x0000000809427824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000000073e3e7812ULL, 0x100fe400078ef831ULL,
0x0000000740407812ULL, 0x000fe400078ef831ULL, 0x00000007313c7812ULL, 0x000fc400078ec0ffULL,
0x00000001ff3b7819ULL, 0x000fe4000001163eULL, 0x00000001ff3f7819ULL, 0x000fe40000011640ULL,
0x000010003d3d7811ULL, 0x000fe400078e60ffULL, 0x000000083c3c7812ULL, 0x000fe400078ef831ULL,
0x000000033b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000033f3f7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003a3b097212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003a3f257212ULL, 0x000fc400078e3cffULL,
0x00000042317b7211ULL, 0x000fe200078fe0ffULL, 0x000000043e087824ULL, 0x000fe200078e0209ULL,
0x0000000442427810ULL, 0x000fe20007ffe0ffULL, 0x0000000440247824ULL, 0x000fe400078e0225ULL,
0x0000001008087824ULL, 0x100fe400078e023dULL, 0x0000001024247824ULL, 0x000fc800078e023dULL,
0x000000000808783bULL, 0x000e680000000200ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000018ff6c7819ULL, 0x002fe20000011408ULL, 0x00010000082c7824ULL, 0x040fe200078e00ffULL,
0x0000888008717816ULL, 0x040fe200000000ffULL, 0x0000010008087824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011409ULL, 0x00010000092d7824ULL, 0x040fe200078e00ffULL,
0x0000888009727816ULL, 0x040fe200000000ffULL, 0x0000010009097824ULL, 0x000fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff697819ULL, 0x000fc4000001140aULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x000088800a6f7816ULL, 0x000fe400000000ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000000800777306ULL, 0x0003e20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff457819ULL, 0x004fe40000011424ULL, 0x00008880246b7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe20000011425ULL, 0x0000000900797306ULL, 0x0005e20000200c00ULL,
0x000100000a087824ULL, 0x042fe200078e00ffULL, 0x0000888025677816ULL, 0x000fe200000000ffULL,
0x000001000a0a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011426ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x000100000b097824ULL, 0x004fe200078e00ffULL, 0x0000002c007a7306ULL, 0x000fe20000200c00ULL,
0x0000888026637816ULL, 0x000fc400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011427ULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00008880275a7816ULL, 0x000fe200000000ffULL,
0x0000000a00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff447819ULL, 0x000fe4000001140bULL,
0x000088800b6d7816ULL, 0x040fe200000000ffULL, 0x000001000b0b7824ULL, 0x000fc800078e00ffULL,
0x0000000900747306ULL, 0x0005e20000200c00ULL, 0x000000013a0a7810ULL, 0x042fe40007ffe0ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x000000023a3a7810ULL, 0x000fc60007ffe0ffULL,
0x0000002d00757306ULL, 0x0003e20000200c00ULL, 0x0000000a3b097212ULL, 0x004fe400078e3cffULL,
0x000000043a00780cULL, 0x000fc60003f25270ULL, 0x000000043e2c7824ULL, 0x000fe400078e0209ULL,
0x0000000800767306ULL, 0x0005e20000200c00ULL, 0x0001000025097824ULL, 0x040fe400078e00ffULL,
0x000000102c2c7824ULL, 0x000fe400078e023dULL, 0x0000010025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000000b00737306ULL, 0x0007e20000200c00ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x0001000024087824ULL, 0x044fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000010024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000002500657306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000000a3f0b7212ULL, 0x008fca00078e3cffULL,
0x0000002400707306ULL, 0x0007e20000200c00ULL, 0x000000077b257812ULL, 0x044fe200078e783cULL,
0x00000004400a7824ULL, 0x000fe200078e020bULL, 0x000000027b7b7810ULL, 0x000fc60007ffe0ffULL,
0x000000103c257824ULL, 0x000fe200078e0225ULL, 0x000000077b7b7812ULL, 0x000fe200078e783cULL,
0x00000008006e7306ULL, 0x0005e20000200c00ULL, 0x0001000027247824ULL, 0x048fe400078e00ffULL,
0x0000010027277824ULL, 0x000fe400078e00ffULL, 0x0000001025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000100a0a7824ULL, 0x000fe200078e023dULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000026087824ULL, 0x044fe200078e00ffULL,
0x00000024005f7306ULL, 0x0003e20000200c00ULL, 0x0000010026267824ULL, 0x000fc400078e00ffULL,
0x000000103c7b7824ULL, 0x000fe200078e027bULL, 0x00000018ff647819ULL, 0x000fe40000011408ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027005e7306ULL, 0x000fe20000200c00ULL,
0x000100002c247824ULL, 0x002fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe4000001142cULL,
0x00000018ff487819ULL, 0x000fe4000001142dULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x0000002600667306ULL, 0x0003e20000200c00ULL, 0x000088802c537816ULL, 0x040fe200000000ffULL,
0x000001002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802d567816ULL, 0x040fe400000000ffULL,
0x00000018ff497819ULL, 0x000fe4000001142eULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000002400547306ULL, 0x0005e20000200c00ULL, 0x000100002d267824ULL, 0x042fe200078e00ffULL,
0x000088802e587816ULL, 0x000fe200000000ffULL, 0x000001002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001142fULL, 0x00000018ff577819ULL, 0x000fe40000011426ULL,
0x0000000900687306ULL, 0x0003e20000200c00ULL, 0x000000002524783bULL, 0x004fe20000000200ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x000088802f5d7816ULL, 0x000fc800000000ffULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000000000a08783bULL, 0x002e6e0000000200ULL,
0x0000002c00557306ULL, 0x0007f00000200c00ULL, 0x0000002d00597306ULL, 0x0009e20000200c00ULL,
0x000100002e2c7824ULL, 0x008fc400078e00ffULL, 0x000001002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000100002f2d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x00000018ff2f7819ULL, 0x000fce000001142fULL,
0x0000002c005b7306ULL, 0x0005e20000200c00ULL, 0x00000018ff4b7819ULL, 0x002fe40000011408ULL,
0x00000018ff507819ULL, 0x000fe40000011409ULL, 0x00000018ff517819ULL, 0x000fe4000001140aULL,
0x00000018ff527819ULL, 0x000fe2000001140bULL, 0x0000002d00607306ULL, 0x0003e20000200c00ULL,
0x00005410712c7816ULL, 0x004fce000000007aULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410772d7816ULL, 0x002fe2000000006cULL, 0x00010000086c7824ULL, 0x000fcc00078e00ffULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000002c2428723cULL, 0x000fee0000001828ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00005410722c7816ULL, 0x008fe40000000075ULL,
0x00005410792d7816ULL, 0x000fca000000006aULL, 0x0000004500457306ULL, 0x000ea40000200c00ULL,
0x0000002c2420723cULL, 0x000fec0000001820ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x000054106f2c7816ULL, 0x002fe40000000076ULL, 0x00005410782d7816ULL, 0x000fc40000000069ULL,
0x00000018ff6f7819ULL, 0x000fc6000001146cULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000541070457816ULL, 0x004fe20000000045ULL, 0x0000002c241c723cULL, 0x000fec000000181cULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x00005410732d7816ULL, 0x000fe40000000044ULL,
0x000054106b447816ULL, 0x008fca000000006eULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x000054106d2c7816ULL, 0x002fe20000000074ULL, 0x000000442404723cULL, 0x000fe20000001804ULL,
0x00008880096d7816ULL, 0x000fca00000000ffULL, 0x0000002e005c7306ULL, 0x0003e20000200c00ULL,
0x0000010009457824ULL, 0x000fe200078e00ffULL, 0x0000002c2418723cULL, 0x000fe80000001818ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004100417306ULL, 0x000f220000200c00ULL,
0x00008880082e7816ULL, 0x042fe200000000ffULL, 0x0000010008087824ULL, 0x000fca00078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000005a005a7306ULL, 0x000ff00000200c00ULL,
0x0000006f00697306ULL, 0x0003f00000200c00ULL, 0x00000008006c7306ULL, 0x0007e20000200c00ULL,
0x00010000096f7824ULL, 0x002fe200078e00ffULL, 0x0000541065097816ULL, 0x004fc80000000062ULL,
0x00000018ff447819ULL, 0x000fe4000001146fULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x0000541067087816ULL, 0x008fce0000000068ULL, 0x000000082414723cULL, 0x000fe20000001814ULL,
0x0000006300637306ULL, 0x000fec0000200c00ULL, 0x000088800a087816ULL, 0x000fe400000000ffULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000054105e097816ULL, 0x010fc40000000041ULL,
0x0000541066657816ULL, 0x002fe20000000043ULL, 0x000100000a437824ULL, 0x040fe400078e00ffULL,
0x000001000a0a7824ULL, 0x000fe400078e00ffULL, 0x0000002e006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff0a7819ULL, 0x000fca000001140aULL,
0x0000000800627306ULL, 0x0007e20000200c00ULL, 0x000000107b2e7824ULL, 0x002fe200078e00ffULL,
0x0000541063647816ULL, 0x004fcc0000000064ULL, 0x0000002f00617306ULL, 0x0003e20000200c00ULL,
0x000054105a087816ULL, 0x008fe2000000005fULL, 0x000000642410723cULL, 0x040fec0000001810ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000002e2c783bULL, 0x002e620000000200ULL,
0x00000008240c723cULL, 0x000fec000000180cULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000088800b087816ULL, 0x040fe200000000ffULL, 0x000100000b097824ULL, 0x000fc400078e00ffULL,
0x000001000b0b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fce000001140bULL,
0x0000004a004a7306ULL, 0x000f220000200c00ULL, 0x0000541056567816ULL, 0x004fce0000000057ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541059577816ULL, 0x008fce0000000048ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x0000541061617816ULL, 0x010fe2000000004aULL,
0x000000562c20723cULL, 0x002fe20000001820ULL, 0x000054106a4a7816ULL, 0x000fca0000000069ULL,
0x0000000800087306ULL, 0x000ff00000200c00ULL, 0x0000000900097306ULL, 0x000e620000200c00ULL,
0x0000541045457816ULL, 0x004fce0000000050ULL, 0x0000004600467306ULL, 0x000eb00000200c00ULL,
0x0000004900497306ULL, 0x000ee20000200c00ULL, 0x0000541008087816ULL, 0x002fce0000000009ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x0000541055557816ULL, 0x004fce0000000046ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054105c497816ULL, 0x008fce0000000049ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000054106c4b7816ULL, 0x002fce000000004bULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000004a2c04723cULL, 0x000fee0000001804ULL,
0x0000005800587306ULL, 0x000eb00000200c00ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x0000541053547816ULL, 0x002fce0000000054ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541058487816ULL, 0x004fe2000000005bULL, 0x000000542c28723cULL, 0x040fec0000001828ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x000054105d607816ULL, 0x008fe20000000060ULL,
0x000000482c1c723cULL, 0x040fec000000181cULL, 0x0000004300437306ULL, 0x000ea40000200c00ULL,
0x000000602c18723cULL, 0x000fec0000001818ULL, 0x0000000a000a7306ULL, 0x000ee20000200c00ULL,
0x000054106d447816ULL, 0x002fce0000000044ULL, 0x0000000b000b7306ULL, 0x000e620000200c00ULL,
0x0000541062507816ULL, 0x004fe20000000043ULL, 0x000000442c14723cULL, 0x000fe20000001814ULL,
0x000054100a517816ULL, 0x008fce0000000051ULL, 0x000000502c10723cULL, 0x000fe20000001810ULL,
0x000054100b097816ULL, 0x002fce0000000052ULL, 0x000000082c0c723cULL, 0x000fe2000000180cULL,
0xfffff10000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e0036ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe2f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140034097984ULL, 0x000e620000000800ULL, 0x0000ffff38007812ULL, 0x000fe200078ec0ffULL,
0x0000002833287220ULL, 0x040fe20000410000ULL, 0x0000002133257220ULL, 0x040fe20000410000ULL,
0x00000022330a7220ULL, 0x040fe20000410000ULL, 0x00008880002f7816ULL, 0x000fe200000000ffULL,
0x0000002933087220ULL, 0x040fe20000410000ULL, 0x0000002033277220ULL, 0x040fe20000410000ULL,
0x0000001f332c7220ULL, 0x040fe20000410000ULL, 0x0000001833227220ULL, 0x040fe20000410000ULL,
0x0000001933217220ULL, 0x000fe20000410000ULL, 0x800000002f007824ULL, 0x000fe200078e00ffULL,
0x0000001a33187220ULL, 0x040fe20000410000ULL, 0x0000001b33197220ULL, 0x040fe20000410000ULL,
0x0000000433207220ULL, 0x040fe20000410000ULL, 0x00000005331f7220ULL, 0x040fe20000410000ULL,
0x0000002a332a7220ULL, 0x040fe20000410000ULL, 0x0000002b332b7220ULL, 0x040fe20000410000ULL,
0x0000001e33267220ULL, 0x040fe20000410000ULL, 0x0000000633067220ULL, 0x040fe20000410000ULL,
0x0000000733077220ULL, 0x040fe20000410000ULL, 0x0000001633047220ULL, 0x040fe20000410000ULL,
0x0000001733057220ULL, 0x040fe20000410000ULL, 0x00000012332d7220ULL, 0x040fe20000410000ULL,
0x00000013332e7220ULL, 0x040fe20000410000ULL, 0x00000023330b7220ULL, 0x040fe20000410000ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x0000001c33247220ULL, 0x040fe20000410000ULL,
0x0000001d33237220ULL, 0x040fe20000410000ULL, 0x00000014331e7220ULL, 0x040fe20000410000ULL,
0x0000000d33177220ULL, 0x040fe20000410000ULL, 0x000000ffff287224ULL, 0x000fe200078e0008ULL,
0x00000015331d7220ULL, 0x040fe20000410000ULL, 0x00000010331c7220ULL, 0x040fe20000410000ULL,
0x00000011331b7220ULL, 0x040fe20000410000ULL, 0x0000000f330d7220ULL, 0x040fe20000410000ULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0000000c331a7220ULL, 0x040fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e0018ULL, 0x0000000e330e7220ULL, 0x000fe20000410000ULL,
0x8000000009ff7812ULL, 0x002fe20007804800ULL, 0x000000ffff137224ULL, 0x000fc400078e0019ULL,
0x000000ffff167224ULL, 0x000fe400078e002aULL, 0x000000ffff157224ULL, 0x000fe400078e002bULL,
0x000000ffff0a7224ULL, 0x000fe400078e0026ULL, 0x000000ffff097224ULL, 0x000fe400078e002cULL,
0x000000ffff127224ULL, 0x000fe400078e0006ULL, 0x000000ffff117224ULL, 0x000fc400078e0007ULL,
0x000000ffff107224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff187224ULL, 0x000fe400078e002dULL, 0x000000ffff0f7224ULL, 0x000fe200078e002eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002f2f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f6140034047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000431007824ULL, 0x000fe200078e00ffULL,
0x000000374e00720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff0000c7812ULL, 0x000fca00078ec0ffULL, 0x000000804f0c7824ULL, 0x000fca00078e020cULL,
0x00f400000c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000231267824ULL, 0x000fe400078e00ffULL, 0x000000014c397824ULL, 0x000fc600078e0a39ULL,
0x0000000626267812ULL, 0x000fc800078ec0ffULL, 0x00000001262a7812ULL, 0x040fe400078efcffULL,
0x00000008262c7812ULL, 0x000fe400078efcffULL, 0x000000392a00720cULL, 0x080fe40003f26070ULL,
0x00000010262a7812ULL, 0x000fe400078efcffULL, 0x000000392c00720cULL, 0x080fe40003f06070ULL,
0x000000392a00720cULL, 0x000fc40003fc6070ULL, 0x00000011262c7812ULL, 0x040fe400078efcffULL,
0x00000018262a7812ULL, 0x040fe400078efcffULL, 0x000000392600720cULL, 0x080fe40003f46070ULL,
0x000000392c00720cULL, 0x080fe40003fa6070ULL, 0x000000392a00720cULL, 0x000fe40003f66070ULL,
0x00000009262e7812ULL, 0x000fc400078efcffULL, 0x00000019262c7812ULL, 0x040fe400078efcffULL,
0x00000020262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005000000ULL,
0xff7fffff29297808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0xff7fffff28287808ULL, 0x000fc40004800000ULL, 0x000000392e00720cULL, 0x080fe40003f86070ULL,
0x000000392c00720cULL, 0x080fe40003f46070ULL, 0x000000392a00720cULL, 0x000fe40003f26070ULL,
0x00000021262c7812ULL, 0x040fe400078efcffULL, 0x00000028262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff14147808ULL, 0x000fc40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0x000000392c00720cULL, 0x080fe40003f06070ULL, 0x000000392a00720cULL, 0x000fe40003f86070ULL,
0x00000029262c7812ULL, 0x000fc400078efcffULL, 0x00000030262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0x000000392c00720cULL, 0x000fc40003fc6070ULL, 0x000000392a00720cULL, 0x000fe40003fa6070ULL,
0x00000031262c7812ULL, 0x040fe400078efcffULL, 0x00000038262a7812ULL, 0x040fe400078efcffULL,
0x0000003926267812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff22227808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff20207808ULL, 0x000fe40004800000ULL, 0x000000392c00720cULL, 0x080fe40003f66070ULL,
0x000000392a00720cULL, 0x000fc40003f46070ULL, 0x000000392600720cULL, 0x000fe40003f26070ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40006000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff19197808ULL, 0x000fc40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL,
0xff7fffff18187808ULL, 0x000fe40006800000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000029042b7209ULL, 0x004fe20007810000ULL,
0x0000001fff397424ULL, 0x000fe200078e00ffULL, 0x0000001605267209ULL, 0x000fe20007810000ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x000000282b047209ULL, 0x000fe40007810000ULL,
0x0000001526057209ULL, 0x000fc40007810000ULL, 0x0000002704047209ULL, 0x000fe40007810000ULL,
0x0000001405267209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x0000000b262b7209ULL, 0x000fe40007810000ULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x0000000a2b267209ULL, 0x000fc40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x00000009262b7209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fe40007810000ULL,
0x000000082b267209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x00000013262b7209ULL, 0x000fc40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x000000122b267209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x00000011262b7209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x000000102b267209ULL, 0x000fc40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x00000019262b7209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x000000182b267209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000000f262b7209ULL, 0x000fc40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000000e2b267209ULL, 0x000fe40007810000ULL, 0x00000017042c7209ULL, 0x000fe40007810000ULL,
0x0000000d262e7209ULL, 0x000fe20007810000ULL, 0x00000e927f007947ULL, 0x000fea000b800000ULL,
0x0c401f002c047f89ULL, 0x0004e400000e0000ULL, 0x000000042c2f7209ULL, 0x008fe20007810000ULL,
0x00000eb27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002e047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007267f89ULL, 0x000e6200000e0000ULL,
0x000000042e2a7209ULL, 0x008fc60007810000ULL, 0x0c201f002f047f89ULL, 0x000ee200000e0000ULL,
0x00000005062b7209ULL, 0x010fc60007810000ULL, 0x0c201f002a057f89ULL, 0x000f2200000e0000ULL,
0x0000002607267209ULL, 0x002fc60007810000ULL, 0x0c201f002b2c7f89ULL, 0x004e6800000e0000ULL,
0x0c201f00262d7f89ULL, 0x0004a200000e0000ULL, 0x000000042f047209ULL, 0x008fe40007810000ULL,
0x000000052a057209ULL, 0x010fe40007810000ULL, 0x0000002c2b067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b042a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052f7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000067886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001082fULL, 0x0000001b002e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0b1b7823ULL, 0x108fe2000001082fULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe2000001082aULL,
0x3fb8aa3b083a7823ULL, 0x102fe2000001082fULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0d0d7823ULL, 0x000fc8000001082fULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x00000025002c7308ULL, 0x000ee20000000800ULL,
0x000000292808723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b10297823ULL, 0x000fcc000001082fULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001b000b7308ULL, 0x0003300000000800ULL,
0x0000001a002b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b121b7823ULL, 0x002fce000001082fULL,
0x00000017002a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a1a7823ULL, 0x104fe2000001082fULL,
0x000000272c0a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b11277823ULL, 0x000fe2000001082fULL,
0x000000140b0b723eULL, 0x010fc800000000ffULL, 0x0000001d00077308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b09177823ULL, 0x002fe2000001082fULL, 0x000000161509723eULL, 0x000fcc00000000ffULL,
0x0000001c00257308ULL, 0x0003e20000000800ULL, 0x3c003c00ff1d7424ULL, 0x004fce00078e00ffULL,
0x0000001700397308ULL, 0x0005e20000000800ULL, 0x3c003c00ff1c7424ULL, 0x002fce00078e00ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000001c0814723cULL, 0x004fee00000018ffULL,
0x0000002300237308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x000000242310723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b18237823ULL, 0x000fcc000001082fULL, 0x0000001a001a7308ULL, 0x000e700000000800ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000222112723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b19217823ULL, 0x000fcc000001082fULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x0000001a3911723eULL, 0x002fce00000000ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x0000003a1313723eULL, 0x004fce00000000ffULL, 0x0000002700287308ULL, 0x000e620000000800ULL,
0x0000001c1014723cULL, 0x000fee0000001814ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000001b2819723eULL, 0x002fce00000000ffULL,
0x0000001e001e7308ULL, 0x000e700000000800ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000201f18723eULL, 0x004fce00000000ffULL, 0x0000002100227308ULL, 0x000ea20000000800ULL,
0x0000001e071a723eULL, 0x002fe400000000ffULL, 0xfffffffc31077812ULL, 0x000fca00078ec0ffULL,
0x0000000f00247308ULL, 0x000fe20000000800ULL, 0x00000029221b723eULL, 0x004fce00000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000001c183c723cULL, 0x000fee0000001814ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000fff147424ULL, 0x000fe200078e00ffULL,
0x0000002b2a16723eULL, 0x000fcc00000000ffULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x000000232415723eULL, 0x002fe400000000ffULL, 0x00000007140f7219ULL, 0x000fe400000006ffULL,
0x000000252e14723eULL, 0x000fe400000000ffULL, 0x000000000f1e73a1ULL, 0x000e6200000e8000ULL,
0x000000000f0573c4ULL, 0x000ee20000004000ULL, 0x000000262d077209ULL, 0x000fe40007810000ULL,
0x0000000e0d17723eULL, 0x004fce00000000ffULL, 0x0000001c143c723cULL, 0x000fe2000000183cULL,
0x000000060fff7c12ULL, 0x002fda000f80401eULL, 0x000009f205008947ULL, 0x008ff4000b800000ULL,
0x001c1fff3c1c7589ULL, 0x0002a400000e0000ULL, 0x000000000f0e73a1ULL, 0x000ee200000e8000ULL,
0x000000000f0573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x000000060fff7c12ULL, 0x008fda000f80400eULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff001f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011631ULL,
0x0000000c003d7812ULL, 0x002fc400078ec0ffULL, 0x000000070d0e7812ULL, 0x040fe200078ec0ffULL,
0x000000080d237824ULL, 0x040fe200078e00ffULL, 0x0000000dff217212ULL, 0x000fe200078e33ffULL,
0x000000080d0f7824ULL, 0x008fe200078e00ffULL, 0x0000000331ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080d2e7824ULL, 0x040fe200078e00ffULL, 0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee20eULL, 0x000000010f227812ULL, 0x100fe200078ef60eULL,
0x000000080d487824ULL, 0x000fe200078e00ffULL, 0x000000020f247812ULL, 0x100fe200078ef60eULL,
0x000000080d237824ULL, 0x000fe200078e00ffULL, 0x000000030f267812ULL, 0x000fc400078ef60eULL,
0x000000040f287812ULL, 0x140fe400078ef60eULL, 0x000000050f2a7812ULL, 0x140fe400078ef60eULL,
0x000000060f2c7812ULL, 0x000fe200078ef60eULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL, 0x0000000dff217212ULL, 0x000fe400078e33ffULL,
0x000000070d0e7812ULL, 0x000fc400078ec0ffULL, 0x000090004f0d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233a7812ULL, 0x100fe400078ee20eULL, 0xfffffff848487812ULL, 0x000fe200078ee221ULL,
0x0000001020007824ULL, 0x100fe200078e020dULL, 0x000000010f3c7812ULL, 0x140fe200078ef60eULL,
0x0000001024207824ULL, 0x100fe200078e020dULL, 0x000000020f3e7812ULL, 0x140fe200078ef60eULL,
0x0000001028247824ULL, 0x100fe200078e020dULL, 0x000000030f407812ULL, 0x140fe200078ef60eULL,
0x000000102c287824ULL, 0x100fe200078e020dULL, 0x000000040f427812ULL, 0x140fe200078ef60eULL,
0x000000103c2c7824ULL, 0x100fe200078e020dULL, 0x000000050f447812ULL, 0x140fe200078ef60eULL,
0x000000103e2d7824ULL, 0x100fe200078e020dULL, 0x000000060f467812ULL, 0x000fe200078ef60eULL,
0x00000010220e7824ULL, 0x000fc400078e020dULL, 0x0000001026227824ULL, 0x100fe400078e020dULL,
0x000000102a267824ULL, 0x100fe400078e020dULL, 0x000000013d0f7824ULL, 0x000fe400078e0200ULL,
0x000000102e2a7824ULL, 0x100fe400078e020dULL, 0x000000103a007824ULL, 0x100fe200078e020dULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x00000010402e7824ULL, 0x000fc400078e020dULL,
0x00000010422f7824ULL, 0x100fe400078e020dULL, 0x0000001044397824ULL, 0x100fe400078e020dULL,
0x00000010463a7824ULL, 0x100fe400078e020dULL, 0x00000010483b7824ULL, 0x000fe400078e020dULL,
0x000000013d0d7824ULL, 0x040fe400078e020eULL, 0x000000013d217824ULL, 0x000fc400078e0220ULL,
0x000000013d237824ULL, 0x040fe200078e0222ULL, 0x0000000a0d007388ULL, 0x0007e20000000800ULL,
0x000000013d257824ULL, 0x040fe400078e0224ULL, 0x000000013d277824ULL, 0x040fe200078e0226ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x000000013d297824ULL, 0x040fe400078e0228ULL,
0x000000013d2b7824ULL, 0x040fe200078e022aULL, 0x0000001223007388ULL, 0x0007e20000000800ULL,
0x000000013d007824ULL, 0x000fc400078e0200ULL, 0x000000013d2c7824ULL, 0x040fe200078e022cULL,
0x0000001825007388ULL, 0x0007e20000000800ULL, 0x000000013d0e7824ULL, 0x040fe400078e022dULL,
0x000000013d2e7824ULL, 0x040fe200078e022eULL, 0x0000001a27007388ULL, 0x0007e20000000800ULL,
0x000000013d087824ULL, 0x042fe400078e022fULL, 0x000000013d207824ULL, 0x040fe200078e0239ULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x000000013d3a7824ULL, 0x000fc400078e023aULL,
0x000000013d227824ULL, 0x000fe200078e023bULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x000000110e007388ULL, 0x0007e80000000800ULL, 0x000000132e007388ULL, 0x0007e80000000800ULL,
0x0000001908007388ULL, 0x0007e80000000800ULL, 0x0000001b20007388ULL, 0x0007e80000000800ULL,
0x000000153a007388ULL, 0x0007e80000000800ULL, 0x0000001722007388ULL, 0x0007e80000000800ULL,
0x00f000040c008388ULL, 0x0007e80000000c00ULL, 0x00f2001c0c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003004e4e7a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080034ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL,
0x000000474e00720cULL, 0x000fe40003f26070ULL, 0x00000001ff387807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc92000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002cULL,
0x00010dd0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0059ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3d7424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0039ULL,
0xffffa3d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x002fe200078e0059ULL,
0x00010e50002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e002bULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3d7424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e0039ULL,
0xffffa37000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2d7424ULL, 0x000fe200078e00ffULL,
0x00010ea0002a7802ULL, 0x000fe40000000f00ULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002dULL, 0xfffff13000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2c7224ULL, 0x006fe200078e002eULL, 0x00010f00002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x020fea0003c00000ULL,
0x0000002d2e2e7209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x00010f50002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2d7424ULL, 0x000fe400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002d06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0007ULL, 0x00010fa0002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002d07267209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e002fULL,
0x00010ff0002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002d2f047209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e002eULL, 0x00011040002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002d2e057209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x00011090002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002d06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0026ULL, 0x000110e0002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffeff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003cULL,
0x00011150002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe400078e000fULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0039ULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x002fe200078e003eULL,
0x000111d0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe400078e000fULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x002fe200078e00ffULL,
0x00011230002c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe400078e000fULL, 0x000000ffff1d7224ULL, 0x004fe400078e0039ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x002fe200078e000fULL,
0x00011290002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0039ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0039ULL,
0xfffff4e000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffeebe02a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0c00002d2c2d7389ULL, 0x0002a200000e0039ULL, 0xfffeeba02a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000003d00007348ULL, 0x000fe80003800000ULL,
0x0000003b3a397389ULL, 0x0002a200000e003cULL, 0xfffeeb602c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000011580ULL, 0xa400001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012700ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012710ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012710ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012b90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000117a0ULL, 0x00000000000117a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012b90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_89_cubin_len = 76912;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
