/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013990ULL, 0x0000000000013510ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000012250ULL, 0x0000000000000180ULL, 0x000e002200000106ULL, 0x00000000000123d0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000012410ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000012500ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001225000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0047ec0400288080ULL,
0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8016288080860828ULL,
0x0000000310288082ULL, 0x8086920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001225000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080840900ULL, 0x0900000010042880ULL, 0x2880808428808086ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0xae08288080920828ULL, 0x288080b008288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080b0ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x000123d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0xb008288080920828ULL, 0x288080ae08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080aeULL, 0x0000001cffffffffULL, 0x0000018000000000ULL,
0x0001241000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000c7ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000dULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00010fc000183104ULL, 0x0001154000011530ULL,
0x000115d0000115c0ULL, 0x00c02904000115e0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002405000024ULL, 0x0500002405000024ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000a000c02804ULL, 0x00001fd000000100ULL,
0x0000210000002070ULL, 0x000033f000002130ULL, 0x000051e000003420ULL, 0x0000532000005290ULL,
0x000063f000005360ULL, 0x000079a000006410ULL, 0x00007d60000079d0ULL, 0x0000a7b000007d70ULL,
0x0000aca00000a7d0ULL, 0x00010e900000acd0ULL, 0x00010ed000010ec0ULL, 0x00010f0000010ee0ULL,
0x00010f4000010f20ULL, 0x000115b000010f50ULL, 0x0001162000011610ULL, 0x00011c7000011630ULL,
0x00011d5000011ce0ULL, 0x00011e4000011dd0ULL, 0x00011f2000011eb0ULL, 0x0001200000011f90ULL,
0x000120e000012070ULL, 0x000121c000012160ULL, 0x0280390400012220ULL, 0x000000ff00000170ULL,
0x003f01000001b600ULL, 0x0000000f000001b0ULL, 0x003f01300001b608ULL, 0x0000000f000001e0ULL,
0x003f01300001b610ULL, 0x0000000f00000210ULL, 0x003f01200001b648ULL, 0x0000000f00000240ULL,
0x003f01200001b668ULL, 0x000000ff00000460ULL, 0x003f01070001b600ULL, 0x0000000c00000660ULL,
0x003f010200000004ULL, 0x0000000c00000710ULL, 0x003f010100000000ULL, 0x000000ff00001030ULL,
0x0005010700000000ULL, 0x0000000f000010b0ULL, 0x003f010100000020ULL, 0x0000005700001310ULL,
0x003f01060001b66cULL, 0x0000005700001390ULL, 0x003f01060001b66cULL, 0x0000005700001420ULL,
0x003f01060001b66cULL, 0x0000005000001d50ULL, 0x0005010700000000ULL, 0x0000000e00001dc0ULL,
0x0005010600000004ULL, 0x0000004a00001de0ULL, 0x003f01060001b60cULL, 0x0000001000001ef0ULL,
0x003f010600000004ULL, 0x0000000e000023c0ULL, 0x0005010600000004ULL, 0x0000000e00002460ULL,
0x0005010600000004ULL, 0x0000001d000044f0ULL, 0x003f010100000000ULL, 0x0000001c00004570ULL,
0x003f010100000000ULL, 0x0000005700004660ULL, 0x003f01060001b66cULL, 0x00000057000046b0ULL,
0x003f01060001b66cULL, 0x0000001d00004740ULL, 0x003f010600000004ULL, 0x000000ff00004f50ULL,
0x0005010700000000ULL, 0x0000000900004fc0ULL, 0x003f010600000004ULL, 0x0000002000004fe0ULL,
0x003f01060001b62cULL, 0x00000020000050f0ULL, 0x003f01060001b62cULL, 0x0000001c00005660ULL,
0x003f01060001b64cULL, 0x0000000900005710ULL, 0x003f010600000004ULL, 0x0000001000007630ULL,
0x003f010100000000ULL, 0x0000000e00007690ULL, 0x003f010100000000ULL, 0x000000ff0000d490ULL,
0x003f01060001b604ULL, 0x000000ff0000d5b0ULL, 0x003f01060001b604ULL, 0x000000ff0000d7d0ULL,
0x003f01010001b600ULL, 0x000000ff0000d7e0ULL, 0x003f01060001b604ULL, 0x000000ff0000d860ULL,
0x003f01060001b604ULL, 0x00000037000103c0ULL, 0x003f01060001b614ULL, 0x0000003700010790ULL,
0x003f01060001b614ULL, 0x0000003700011bb0ULL, 0x003f01010001b608ULL, 0x00141c0400053803ULL,
0x0000bb100000b6c0ULL, 0x0000d9800000d8b0ULL, 0x0000040100011c20ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001ecULL, 0x0000001100000002ULL, 0x000000000000016cULL, 0x0000001100000002ULL,
0x00000000000000d4ULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001c7ULL, 0x0000001100000002ULL, 0x0000000000000147ULL, 0x0000001100000002ULL,
0x00000000000000adULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x00000000000e7919ULL, 0x000ee80000002700ULL,
0x0000000000217919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc600078e0203ULL,
0x00001fff06067589ULL, 0x000e6200000e0000ULL, 0x00000080000f7824ULL, 0x104fe200078e0209ULL,
0x00000005ff1a7819ULL, 0x000fe20000011609ULL, 0x000062000e087625ULL, 0x008fc600078e0007ULL,
0x000000ff0f00720cULL, 0x040fe40003f05270ULL, 0x000000030f00780cULL, 0x040fe20003f44070ULL,
0x00001fff1a1a7589ULL, 0x000ea200000e0000ULL, 0x0000007f0f00780cULL, 0x040fe40003f24070ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0600720cULL, 0x002fe20003f05270ULL, 0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x01b608040f00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff0ca424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x01b6100a0f00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff009424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff10b424ULL, 0x000fe200078e00ffULL, 0x01b6480c0f00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff11b424ULL, 0x000fc600078e00ffULL, 0x01b400000f009388ULL, 0x0007e80000004800ULL,
0x01b668100f00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x01ce620000000000ULL,
0x000000041a007824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001021037824ULL, 0x000fc400078e00ffULL, 0x00000100ff117424ULL, 0x000fc600078e00ffULL,
0x000000050e037c24ULL, 0x000fe2000f8e0203ULL, 0x0000000010007211ULL, 0x042fe200078fe0ffULL,
0x0000001010047824ULL, 0x000fc600078e00ffULL, 0x00000002000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103027824ULL, 0x040fe200078e0200ULL, 0x0000000700057812ULL, 0x000fe400078ec0ffULL,
0x000000070a0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001030c7824ULL, 0x000fe200078e020aULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0002027625ULL, 0x080fe200078e0011ULL,
0x0000000f050b7812ULL, 0x100fe400078e7810ULL, 0x0000000f0d0d7812ULL, 0x000fe200078e7810ULL,
0x00005c000c047625ULL, 0x000fe200078e0011ULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x00000010000b7824ULL, 0x000fe200078e020bULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100a0d7824ULL, 0x000fe400078e020dULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000040d7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000808007981ULL, 0x01cea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x00000005ff5c7e24ULL, 0x008fe2000f8e00ffULL, 0x0000007f00027810ULL, 0x006fc40007ffe0ffULL,
0x000000ff00037810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff027819ULL, 0x000fe40000011602ULL,
0x00000008ff037819ULL, 0x000fca0000011603ULL, 0x0000b5c000008947ULL, 0x000fea0003800000ULL,
0x00000002ff047819ULL, 0x000fe2000001161aULL, 0xffffffffff0d7424ULL, 0x000fe200078e00ffULL,
0x0001b6101a0c7811ULL, 0x000fe400078e20ffULL, 0x01ffffff04057812ULL, 0x000fca00078ec0ffULL,
0x000000025c0b7824ULL, 0x000fca00078e0205ULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x000000020e048824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640004048624ULL, 0x000fe400078e0205ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x000000010b048824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000004050cff738cULL, 0x0003e20000000000ULL, 0x0000600004088625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000008080d8981ULL, 0x0004e2000c1e1900ULL,
0x00000300ff047624ULL, 0x000fe200078e00ffULL, 0x000000010b057812ULL, 0x002fe400078ec0ffULL,
0x000000015c107810ULL, 0x000fe20007ffe0ffULL, 0x000000000cff7f8cULL, 0x0003e2000c80043fULL,
0xffffffff04047811ULL, 0x000fc400078e08ffULL, 0x000000010500780cULL, 0x000fc80003f05070ULL,
0x0000000104057807ULL, 0x000fca0004000000ULL, 0x000000010b057824ULL, 0x000fca00078e0205ULL,
0x000000020500720cULL, 0x000fda0003f06070ULL, 0x000000020e068824ULL, 0x000fe400078e00ffULL,
0x00006400ff0b8624ULL, 0x000fc800078e00ffULL, 0x0000640006068624ULL, 0x000fc800078e020bULL,
0x00000001060a8824ULL, 0x000fe200078e0205ULL, 0x000000011a087812ULL, 0x004fe200078ec0ffULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x000060000a0a8625ULL, 0x000fe400078e0007ULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000002008117824ULL, 0x000fe400078e00ffULL,
0x000000080a068981ULL, 0x000962000c1e1900ULL, 0x000000031000720cULL, 0x000fe20003f06070ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x00000003ff127819ULL, 0x004fe20000011607ULL,
0x0000001007337824ULL, 0x000fc600078e00ffULL, 0x00000008121e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000111147824ULL, 0x040fe200078e0212ULL, 0x0000000412187810ULL, 0x040fe40007ffe0ffULL,
0x0000000c12227810ULL, 0x000fe20007ffe0ffULL, 0x0000000814107824ULL, 0x040fe200078e00ffULL,
0x0000000714097212ULL, 0x080fe200078e3cffULL, 0x0000000111207824ULL, 0x040fe200078e021eULL,
0x00000014122a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001111c7824ULL, 0x040fe200078e0218ULL,
0xfffffff8100b7812ULL, 0x010fe200078ee209ULL, 0x0000000820107824ULL, 0x040fe200078e00ffULL,
0x0000000720097212ULL, 0x080fe200078e3cffULL, 0x000000081c137824ULL, 0x040fe200078e00ffULL,
0x000000071c0a7212ULL, 0x080fe200078e3cffULL, 0x0000000111247824ULL, 0x040fe200078e0222ULL,
0xfffffff810157812ULL, 0x000fe200078ee209ULL, 0x00000001112c7824ULL, 0x000fe200078e022aULL,
0x00000001ff097819ULL, 0x000fe2000001161aULL, 0x0000000824177824ULL, 0x000fe200078e00ffULL,
0x0000001012267810ULL, 0x000fe20007ffe0ffULL, 0x000000082c1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20aULL, 0x000000045c0f7824ULL, 0x000fe200078e0209ULL,
0x00000007240a7212ULL, 0x080fe200078e3cffULL, 0x0000000111287824ULL, 0x000fe200078e0226ULL,
0x000000072c107212ULL, 0x080fe200078e3cffULL, 0x000000400f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20aULL, 0x0000000828197824ULL, 0x040fe200078e00ffULL,
0x00000007280a7212ULL, 0x000fe200078e3cffULL, 0x00000000090573c2ULL, 0x000ea200000e0000ULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee210ULL, 0x0000000f00107217ULL, 0x000fe40007800000ULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x00004000090a7824ULL, 0x000fe200078e00ffULL,
0x0000007f14147812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0fULL,
0x0000001c12327810ULL, 0x000fe40007ffe0ffULL, 0x000130000a167810ULL, 0x000fe40007ffe0ffULL,
0x0000004010107807ULL, 0x000fe20000000000ULL, 0x0000000111347824ULL, 0x000fe200078e0232ULL,
0x00000018122e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100b237824ULL, 0x100fe200078e0216ULL,
0x0000001110107217ULL, 0x000fe20007800000ULL, 0x00000080210b7824ULL, 0x000fe200078e00ffULL,
0x0000007f20207812ULL, 0x000fe200078ec0ffULL, 0x000000101b2d7824ULL, 0x100fe200078e0216ULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000001101b7824ULL, 0x000fe200078e0a11ULL,
0x000000400b107812ULL, 0x000fe200078ef80fULL, 0x0000001017297824ULL, 0x000fe200078e0216ULL,
0x0000007033337812ULL, 0x000fe200078ec0ffULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x0000001b1200720cULL, 0x000fe20003fa6070ULL, 0x0000000111307824ULL, 0x000fe200078e022eULL,
0x0000007f24247812ULL, 0x000fe200078ec0ffULL, 0x0000000834387824ULL, 0x040fe200078e00ffULL,
0x00000007341f7212ULL, 0x000fe200078e3cffULL, 0x0000001013257824ULL, 0x100fe200078e0216ULL,
0x0000001b1800720cULL, 0x000fe20003f86070ULL, 0x0000000830367824ULL, 0x040fe200078e00ffULL,
0x00000007301d7212ULL, 0x000fe200078e3cffULL, 0x00000010192b7824ULL, 0x100fe200078e0216ULL,
0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000001015277824ULL, 0x000fe200078e0216ULL,
0x0000007f28287812ULL, 0x000fe200078ec0ffULL, 0x0001b64805057891ULL, 0x004fe2000f8e203fULL,
0xfffffff8381f7812ULL, 0x000fc400078ee21fULL, 0x0000001b1e00720cULL, 0x000fe40003f66070ULL,
0x0000007f30307812ULL, 0x000fe200078ec0ffULL, 0x000000101f317824ULL, 0x000fe200078e0216ULL,
0xfffffff8361d7812ULL, 0x000fe400078ee21dULL, 0x0000007f34347812ULL, 0x000fc600078ec0ffULL,
0x000000101d2f7824ULL, 0x000fe400078e0216ULL, 0x000000040d0f7c24ULL, 0x008fc8000f8e0210ULL,
0x000000010f0c7824ULL, 0x042fe400078e0214ULL, 0x000000010f127824ULL, 0x000fe400078e0220ULL,
0x00005e000c0c7625ULL, 0x000fc800078e0017ULL, 0x000000010f107824ULL, 0x000fe200078e021cULL,
0x000000330c187210ULL, 0x000fe20007f1e0ffULL, 0x00005e0012127625ULL, 0x000fc800078e0017ULL,
0x00005e0010107625ULL, 0x000fe200078e0017ULL, 0x00000033121e7210ULL, 0x000fc60007f5e0ffULL,
0x000000010f247824ULL, 0x040fe200078e0224ULL, 0x00000033101c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe400000e060dULL, 0x000000010f2c7824ULL, 0x040fe400078e022cULL,
0x00005e00240c7625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000e901c48ULL, 0x0000001b2e00720cULL, 0x000fe40003fa6070ULL,
0x000000010f287824ULL, 0x040fe200078e0228ULL, 0x000000330c207210ULL, 0x000fe20007f1e0ffULL,
0x000000010f147824ULL, 0x000fc400078e0230ULL, 0x000000ffff1f7224ULL, 0x000fe400010e0613ULL,
0x000000ffff1d7224ULL, 0x000fe400008e0611ULL, 0x00005e002c127625ULL, 0x000fc600078e0017ULL,
0x000000001c257faeULL, 0x0003e2000e101c48ULL, 0x00005e0028107625ULL, 0x000fe200078e0017ULL,
0x0000003312127210ULL, 0x000fe40007f5e0ffULL, 0x0000001b3200720cULL, 0x000fe20003f86070ULL,
0x00005e0014147625ULL, 0x000fe200078e0017ULL, 0x0000003310107210ULL, 0x080fe20007f3e0ffULL,
0x000000001e277faeULL, 0x0003e4000d901c48ULL, 0x000000ffff217224ULL, 0x000fe200000e060dULL,
0x0000003314147210ULL, 0x000fe20007f1e0ffULL, 0x000000010f167824ULL, 0x000fe200078e0234ULL,
0x0001b648090f7811ULL, 0x000fe200078e18ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000001b2200720cULL, 0x080fe20003f46070ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001b2600720cULL, 0x080fe20003f26070ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001b2a00720cULL, 0x000fe20003f06070ULL, 0x00005e0016167625ULL, 0x000fc800078e0017ULL,
0xff317217ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000003316167210ULL, 0x000fc60007fde0ffULL,
0x0000000020297faeULL, 0x0003e4000d101c48ULL, 0x000000ffff177224ULL, 0x000fe400030e0617ULL,
0x00000000102b7faeULL, 0x0003e8000c901c48ULL, 0x00000000122d7faeULL, 0x0003e2000c101c48ULL,
0x000000035c00720cULL, 0x000fc60003f06070ULL, 0x00000000142f7faeULL, 0x0003e8000e901c48ULL,
0x0000000016317faeULL, 0x0003e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000020000fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x002fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000659000000947ULL, 0x000fea0003800000ULL,
0x000000020e127824ULL, 0x004fe200078e00ffULL, 0x00007610ff5a7816ULL, 0x000fe2000000005aULL,
0x00006400ff0f7624ULL, 0x000fe200078e00ffULL, 0x00007610ff587816ULL, 0x000fe20000000058ULL,
0xff317217ff0c7424ULL, 0x000fc400078e00ffULL, 0x0000640012127624ULL, 0x000fe200078e020fULL,
0x00007610ff0f7816ULL, 0x000fe2000000000fULL, 0x000000ffff5b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff477224ULL, 0x000fe400078e00ffULL, 0x000000201a0e7824ULL, 0x000fca00078e00ffULL,
0xffffffc00e117812ULL, 0x000fca00078ec0ffULL, 0x000001005c197824ULL, 0x000fca00078e0211ULL,
0x000000001900720cULL, 0x000fda0003f06070ULL, 0x0000645000000947ULL, 0x002fea0003800000ULL,
0x000000041a577824ULL, 0x000fe200078e00ffULL, 0x0000ffff5a0e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff597224ULL, 0x000fc600078e0005ULL, 0xfffffff857577812ULL, 0x000fe400078ec0ffULL,
0x000088800e107816ULL, 0x000fc600000000ffULL, 0x01b66c0057117984ULL, 0x000e640000000800ULL,
0x80000000100e7824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe2000780480eULL,
0x000000ffff117224ULL, 0x000fe200078e005bULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000761058137816ULL, 0x000fe40000000013ULL, 0x000076105a147816ULL, 0x000fe20000000014ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01b66c0057177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000010177824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01b66c0057107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000001050e7812ULL, 0x000fc800078ec0ffULL, 0x000000010e00780cULL, 0x000fe40003f05070ULL,
0x00000080190e7810ULL, 0x000fe40007ffe0ffULL, 0x00000001044e7807ULL, 0x000fca0004000000ULL,
0x0000000105177824ULL, 0x000fca00078e024eULL, 0x000000021700720cULL, 0x000fe40003f06070ULL,
0x000000400b177812ULL, 0x000fe200078ef80eULL, 0x000000201a4c7824ULL, 0x000fc800078e00ffULL,
0x0000000406187c24ULL, 0x020fe4000f8e0217ULL, 0xffffffffff067424ULL, 0x000fc800078e00ffULL,
0x0000004e12168210ULL, 0x000fe20007ffe005ULL, 0x00000004ff198424ULL, 0x000fe200078e00ffULL,
0x000000015c107810ULL, 0x000fc60007ffe0ffULL, 0x0000600016168625ULL, 0x000fe200078e0019ULL,
0x00000003ff497819ULL, 0x000fc80000011607ULL, 0x0000000816068981ULL, 0x000362000c1e1900ULL,
0x000000031000720cULL, 0x000fe20003f06070ULL, 0x00000080ff5e7424ULL, 0x000fe200078e00ffULL,
0x000000204c107812ULL, 0x000fe400078ec0ffULL, 0x00000004495d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000e00197217ULL, 0x000fe40007800000ULL, 0x0000000c49617810ULL, 0x000fe20007ffe0ffULL,
0x000000015d167824ULL, 0x002fe200078e0210ULL, 0x0000001049637810ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a0eULL, 0x00000008495f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001490e7824ULL, 0x140fe200078e0210ULL, 0x0000000716557212ULL, 0x0c0fe200078e3cffULL,
0x0000000816207824ULL, 0x000fe200078e00ffULL, 0x0000001449657810ULL, 0x000fe20007ffe0ffULL,
0x00000001611e7824ULL, 0x100fe200078e0210ULL, 0x000000070e567212ULL, 0x0c0fe200078e3cffULL,
0x000000080e177824ULL, 0x000fe200078e00ffULL, 0xfffffff820557812ULL, 0x000fe200078ee255ULL,
0x0000000163207824ULL, 0x100fe200078e0210ULL, 0x000000071e537212ULL, 0x0c0fe200078e3cffULL,
0x000000015f1c7824ULL, 0x000fe200078e0210ULL, 0xfffffff817567812ULL, 0x000fe200078ee256ULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x0000001849677810ULL, 0x000fe20007ffe0ffULL,
0x0000000820177824ULL, 0x040fe200078e00ffULL, 0x0000000720527212ULL, 0x080fe200078e3cffULL,
0x000000081c1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff822537812ULL, 0x000fe200078ee253ULL,
0x0000000165227824ULL, 0x100fe200078e0210ULL, 0x0000007f1c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000167247824ULL, 0x000fe200078e0210ULL, 0xfffffff817527812ULL, 0x000fe200078ee252ULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0x0000007f0e177812ULL, 0x000fe200078ec0ffULL,
0x00000001181d7824ULL, 0x000fe200078e021dULL, 0x0000007f1e1f7812ULL, 0x000fe200078ec0ffULL,
0x00000010070e7824ULL, 0x000fe200078e00ffULL, 0x0000007f22237812ULL, 0x000fe200078ec0ffULL,
0x0000000824487824ULL, 0x000fe200078e00ffULL, 0x000000071c547212ULL, 0x080fe200078e3cffULL,
0x00005e001d1c7625ULL, 0x000fe200078e005eULL, 0x0000000722517212ULL, 0x000fc400078e3cffULL,
0x0000007f24257812ULL, 0x000fe200078ec0ffULL, 0x00000001181f7824ULL, 0x000fe200078e021fULL,
0x00000007244f7212ULL, 0x000fe200078e3cffULL, 0x0000000118247824ULL, 0x000fe200078e0223ULL,
0x000000700e4b7812ULL, 0x000fe200078ec0ffULL, 0x00005e001f1e7625ULL, 0x080fe200078e005eULL,
0x0000001c49697810ULL, 0x000fe40007ffe0ffULL, 0xfffffff826517812ULL, 0x000fe200078ee251ULL,
0x0000000118267824ULL, 0x000fe200078e0225ULL, 0x0000004b1c1c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0024247625ULL, 0x000fe200078e005eULL, 0xfffffff8484f7812ULL, 0x000fc400078ee24fULL,
0xfffffff81b547812ULL, 0x000fe200078ee254ULL, 0x0000000169487824ULL, 0x100fe200078e0210ULL,
0x0000004019197807ULL, 0x000fe20000000000ULL, 0x0000000118177824ULL, 0x000fe200078e0217ULL,
0x0000007f161b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000007f20217812ULL, 0x000fe200078ec0ffULL, 0x00005e0017167625ULL, 0x000fe200078e005eULL,
0x0000004b1e207210ULL, 0x080fe40007f5e0ffULL, 0x0000004b241e7210ULL, 0x080fe20007f3e0ffULL,
0x000000081a247824ULL, 0x000fe200078e00ffULL, 0x0000007f48277812ULL, 0x000fe200078ec0ffULL,
0x00000001181b7824ULL, 0x000fe200078e021bULL, 0x0000001019197217ULL, 0x000fe20007800000ULL,
0x000000085b0e7824ULL, 0x000fe200078e00ffULL, 0x0000004b16167210ULL, 0x000fe20007f1e0ffULL,
0x0000000118217824ULL, 0x000fe200078e0221ULL, 0xfffffff0244a7812ULL, 0x000fe200078ec0ffULL,
0x0000000118277824ULL, 0x000fe200078e0227ULL, 0x000000080e507812ULL, 0x000fe200078e0cffULL,
0x0000000119107824ULL, 0x000fe200078e0a10ULL, 0x000000004a0573c2ULL, 0x000e6200000e0000ULL,
0x00005e001b187625ULL, 0x000fe200078e005eULL, 0x00000007484d7212ULL, 0x000fc400078e3cffULL,
0x000000104900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000004b18187210ULL, 0x080fe20007f1e0ffULL, 0x000020005b1b7824ULL, 0x000fe200078e00ffULL,
0x00000000500673c2ULL, 0x000ea200000e0000ULL, 0x00005e0021227625ULL, 0x000fe200078e005eULL,
0x000000105d00720cULL, 0x080fe40003f86070ULL, 0x000020001b1b7812ULL, 0x000fe200078e0cffULL,
0x0000000848487824ULL, 0x000fe200078e00ffULL, 0x000000105f00720cULL, 0x000fe20003f66070ULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x0000004b22227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e061fULL, 0xfffffff8484d7812ULL, 0x000fe200078ee24dULL,
0x000000ffff1f7224ULL, 0x000fe200008e0625ULL, 0x000130000a487810ULL, 0x000fe20007ffe01bULL,
0x00005e0026247625ULL, 0x000fe200078e005eULL, 0x000000106100720cULL, 0x000fc40003f46070ULL,
0x000000106300720cULL, 0x000fe20003f26070ULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x0000004b24247210ULL, 0x080fe20007f1e0ffULL, 0x00000010561b7824ULL, 0x100fe200078e0248ULL,
0x0001b64805057890ULL, 0x002fe2000fffe03fULL, 0x0000001055497824ULL, 0x100fe400078e0248ULL,
0x00005e0027267625ULL, 0x000fe200078e005eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161b7faeULL, 0x0003e2000e901c48ULL, 0x000000106700720cULL, 0x080fe20003fa6070ULL,
0x0000000605067290ULL, 0x004fe2000fffe03fULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000106500720cULL, 0x080fe20003f06070ULL, 0x0000000018497faeULL, 0x0005e2000e101c48ULL,
0x000000106900720cULL, 0x000fe20003f86070ULL, 0x00000010535d7824ULL, 0x100fe200078e0248ULL,
0x0000004b26267210ULL, 0x000fe20007fde0ffULL, 0x00000010544b7824ULL, 0x000fc400078e0248ULL,
0x00000010525f7824ULL, 0x100fe400078e0248ULL, 0x0000001051177824ULL, 0x102fe200078e0248ULL,
0x000000001c4b7faeULL, 0x0003e2000d901c48ULL, 0x000000104f1b7824ULL, 0x100fe400078e0248ULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x00000000205d7faeULL, 0x0003e2000d101c48ULL,
0x000000104d197824ULL, 0x004fc600078e0248ULL, 0x00000000225f7faeULL, 0x0003e8000c901c48ULL,
0x000000001e177faeULL, 0x0003e8000c101c48ULL, 0x00000000241b7faeULL, 0x0003e8000e901c48ULL,
0x0000000026197faeULL, 0x0003e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004050e177984ULL, 0x0022a20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01b60c004a197984ULL, 0x000ee20000000800ULL, 0x0000ffff58107812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0f167812ULL, 0x000fe400078ec0ffULL, 0x00008880101b7816ULL, 0x000fe400000000ffULL,
0x0000888016107816ULL, 0x000fc600000000ffULL, 0x800000001b167824ULL, 0x000fe400078e00ffULL,
0x8000000010187824ULL, 0x000fc600078e00ffULL, 0x8000000017ff7812ULL, 0x004fe40007804816ULL,
0x8000000019ff7812ULL, 0x008fe20007824818ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x8000000010177824ULL, 0x000fe200078e00ffULL,
0x0001b60809107811ULL, 0x000fe200078e20ffULL, 0x3e000000ff167424ULL, 0x000fc800078e00ffULL,
0x0000001600187305ULL, 0x0004e4000021f000ULL, 0x3fa0000016167823ULL, 0x004fe200000100ffULL,
0x000000180000735dULL, 0x008fe40003800000ULL, 0x0000040010187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fc40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000010071e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011607ULL, 0x00000001ff667424ULL, 0x000fc600078e00ffULL,
0x000000701e167812ULL, 0x000fe400078ec0ffULL, 0x0000000c10177812ULL, 0x000fc600078ec0ffULL,
0x0000008009107824ULL, 0x000fc800078e0216ULL, 0x0000000110107824ULL, 0x000fca00078e0217ULL,
0x01b0000010177984ULL, 0x000ea80000000800ULL, 0x01b2000010167984ULL, 0x0007220000000800ULL,
0x0000000c1700720bULL, 0x004fda0003f3d000ULL, 0x0000000000187806ULL, 0x000fc800008e0100ULL,
0x0000ffff181c7812ULL, 0x000fda000782c0ffULL, 0x000003a000009947ULL, 0x000fea0003800000ULL,
0x0000000c1700720bULL, 0x018fe40003f54000ULL, 0x000000170c1f7209ULL, 0x040fe40007810000ULL,
0x00000002ff187819ULL, 0x000fe40000011607ULL, 0x0000001a0900720cULL, 0x000fe20003f25270ULL,
0x8000001f0c107221ULL, 0x000fe20000010000ULL, 0x0000000818197810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x00000000000c7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0c1d7812ULL, 0x000fe200078e3cffULL, 0x0000001000107308ULL, 0x000ea60000000800ULL,
0x0000001d1cff7212ULL, 0x000fe4000784c0ffULL, 0x000000701e1d9812ULL, 0x000fe400078ec0ffULL,
0x00000001ff1c9819ULL, 0x000fe40000011607ULL, 0x00000001ff667807ULL, 0x000fe20001000000ULL,
0x000000801a0c9824ULL, 0x000fe200078e021dULL, 0x0000000c1c1d9812ULL, 0x000fe200078ec0ffULL,
0x00001f1910197589ULL, 0x004ea800000e0000ULL, 0x8000001f17172221ULL, 0x000fc40000010000ULL,
0x000000011d0c9824ULL, 0x000fe200078e020cULL, 0x00001f1810187589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b17172820ULL, 0x000fe40000410000ULL, 0x000000100d0d7220ULL, 0x000fe20000410000ULL,
0x01b4001f0c009388ULL, 0x0009e20000000800ULL, 0x0000001700152308ULL, 0x000e620000000800ULL,
0x000000ffff0c7224ULL, 0x010fe400078e001fULL, 0x0000001947477220ULL, 0x084fe40000410000ULL,
0x0000001946467220ULL, 0x000fc40000410000ULL, 0x000000193f3f7220ULL, 0x080fe40000410000ULL,
0x000000193e3e7220ULL, 0x080fe40000410000ULL, 0x0000001933337220ULL, 0x080fe40000410000ULL,
0x0000001932327220ULL, 0x080fe40000410000ULL, 0x000000192f2f7220ULL, 0x080fe40000410000ULL,
0x000000192e2e7220ULL, 0x000fc40000410000ULL, 0x000000192b2b7220ULL, 0x080fe40000410000ULL,
0x000000192a2a7220ULL, 0x080fe40000410000ULL, 0x0000001937377220ULL, 0x080fe40000410000ULL,
0x0000001936367220ULL, 0x080fe40000410000ULL, 0x000000193b3b7220ULL, 0x080fe40000410000ULL,
0x000000193a3a7220ULL, 0x000fc40000410000ULL, 0x0000001943437220ULL, 0x080fe40000410000ULL,
0x0000001942427220ULL, 0x000fe40000410000ULL, 0x0000001845457220ULL, 0x088fe40000410000ULL,
0x0000001844447220ULL, 0x080fe40000410000ULL, 0x000000183d3d7220ULL, 0x080fe40000410000ULL,
0x000000183c3c7220ULL, 0x000fc40000410000ULL, 0x0000001831317220ULL, 0x080fe40000410000ULL,
0x0000001830307220ULL, 0x080fe40000410000ULL, 0x000000182d2d7220ULL, 0x080fe40000410000ULL,
0x000000182c2c7220ULL, 0x080fe40000410000ULL, 0x0000001829297220ULL, 0x080fe40000410000ULL,
0x0000001828287220ULL, 0x000fc40000410000ULL, 0x0000001835357220ULL, 0x080fe40000410000ULL,
0x0000001834347220ULL, 0x080fe40000410000ULL, 0x0000001839397220ULL, 0x080fe40000410000ULL,
0x0000001838387220ULL, 0x080fe40000410000ULL, 0x0000001841417220ULL, 0x080fe40000410000ULL,
0x0000001840407220ULL, 0x000fc40000410000ULL, 0x0000001516162220ULL, 0x002fc80000410000ULL,
0x0000000d160d7221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x000004050e107984ULL, 0x000ea20008000800ULL, 0x800000001b177824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x004fe20007804817ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001b1b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000167305ULL, 0x0004e4000021f000ULL,
0x3fa0000010107823ULL, 0x004fe200000100ffULL, 0x000000160000735dULL, 0x008fe40003800000ULL,
0x000004050e167984ULL, 0x000ea40008000800ULL, 0x8000000016ff7812ULL, 0x004fc4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000041a0e7824ULL, 0x002fe200078e00ffULL, 0x0000000807507812ULL, 0x040fe400078ec0ffULL,
0x00000002ff6d7819ULL, 0x100fe40000011607ULL, 0x000000040e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000750187812ULL, 0x140fe400078ec807ULL, 0x0000000e07177211ULL, 0x000fe200078fe0ffULL,
0x000020005b0e7824ULL, 0x000fe200078e020aULL, 0x00000007506c7812ULL, 0x000fc400078ef807ULL,
0x00000017181b7212ULL, 0x000fe400078e3cffULL, 0x000130000e0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000806c167811ULL, 0x040fe200078e18ffULL, 0x000000086c197824ULL, 0x040fe200078e021bULL,
0x000001006c107811ULL, 0x000fe400078e18ffULL, 0x0000991066667816ULL, 0x000fe200000000ffULL,
0x0000001019197824ULL, 0x000fe400078e020eULL, 0x000000011b217824ULL, 0x040fe200078e0216ULL,
0x000000ff6600720cULL, 0x000fe20003f05270ULL, 0x000000011b257824ULL, 0x000fe200078e0210ULL,
0x00000000191c783bULL, 0x000e620000004200ULL, 0x0000001021217824ULL, 0x000fc400078e020eULL,
0x0000001025257824ULL, 0x000fc800078e020eULL, 0x000000002120783bULL, 0x000ea80000004200ULL,
0x000000002524783bULL, 0x000ee20000004200ULL, 0x000001001c197824ULL, 0x042fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe4000001141cULL, 0x000088801cc07816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fc40000011419ULL,
0x0000000217197810ULL, 0x000fe20007ffe0ffULL, 0x000000be00be7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001918197212ULL, 0x000fe200078e3cffULL,
0x000001001d187824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001141dULL,
0x00000018ff6a7819ULL, 0x000fe2000001141eULL, 0x000000086c177824ULL, 0x000fe200078e0219ULL,
0x0000001c00c17306ULL, 0x0003e20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fc4000001141fULL,
0x0000001017177824ULL, 0x000fe200078e020eULL, 0x000088801d657816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x000088801ebd7816ULL, 0x040fe400000000ffULL,
0x000000001748783bULL, 0x0008e20000004200ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x000088801f637816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000c000c07306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000001001f177824ULL, 0x050fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001d00bf7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ffa67819ULL, 0x004fe40000011420ULL, 0x00000018ff987819ULL, 0x000fe40000011421ULL,
0x00000018ff967819ULL, 0x000fe20000011422ULL, 0x0000001700ba7306ULL, 0x0003e20000200c00ULL,
0x00000018ff937819ULL, 0x000fc40000011423ULL, 0x0000888020aa7816ULL, 0x000fe400000000ffULL,
0x0000888021997816ULL, 0x000fe400000000ffULL, 0x0000888022a57816ULL, 0x000fe200000000ffULL,
0x0000001c00bc7306ULL, 0x000fe20000200c00ULL, 0x0000010020177824ULL, 0x042fe200078e00ffULL,
0x00008880239f7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x008fe40000011424ULL, 0x00000018ffab7819ULL, 0x000fe20000011417ULL,
0x0000000119177824ULL, 0x000fe200078e0216ULL, 0x0000001e00b77306ULL, 0x000fe20000200c00ULL,
0x0000010021167824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000001017177824ULL, 0x000fe200078e020eULL, 0x00000018ff8c7819ULL, 0x000fe20000011448ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000001f00627306ULL, 0x0003e20000200c00ULL, 0x0000888048bb7816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff757819ULL, 0x000fe40000011449ULL,
0x00000018ffae7819ULL, 0x000fe2000001144aULL, 0x0000001600ac7306ULL, 0x0005e20000200c00ULL,
0x00000000171c783bULL, 0x0022e20000004200ULL, 0x00000018ffad7819ULL, 0x000fc4000001144bULL,
0x0000888049747816ULL, 0x000fe400000000ffULL, 0x000088804ab47816ULL, 0x000fe400000000ffULL,
0x0000001800c47306ULL, 0x0009e20000200c00ULL, 0x0000000119177824ULL, 0x002fe200078e0210ULL,
0x000088804bb17816ULL, 0x000fe200000000ffULL, 0x0000010026107824ULL, 0x000fe200078e00ffULL,
0x0000888024877816ULL, 0x000fe200000000ffULL, 0x0000001017177824ULL, 0x000fe200078e020eULL,
0x00000018ff7f7819ULL, 0x000fe20000011425ULL, 0x00000100250e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000010023167824ULL, 0x044fe200078e00ffULL,
0x0000002000a97306ULL, 0x000fe20000200c00ULL, 0x0000010022187824ULL, 0x050fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x0000000e00897306ULL, 0x0003e20000200c00ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000888025867816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011426ULL, 0x0000001000807306ULL, 0x0005e20000200c00ULL,
0x00000100270e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fc40000011427ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x0000001600a47306ULL, 0x0003e20000200c00ULL, 0x0000010049107824ULL, 0x044fe200078e00ffULL,
0x00000018ff917819ULL, 0x008fe2000001141cULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x000088801ca27816ULL, 0x000fe400000000ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x0000000e00817306ULL, 0x0005e20000200c00ULL, 0x0000010024167824ULL, 0x042fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001141dULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000001000b97306ULL, 0x0003e20000200c00ULL, 0x00000100480e7824ULL, 0x044fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fc4000001141eULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x0000002100a77306ULL, 0x000fe20000200c00ULL, 0x000001004b107824ULL, 0x042fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001141fULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000000e00b87306ULL, 0x0003e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc4000001144bULL,
0x000088801d9d7816ULL, 0x000fe400000000ffULL, 0x000088801e977816ULL, 0x000fe400000000ffULL,
0x000088801f927816ULL, 0x000fe200000000ffULL, 0x00000022009b7306ULL, 0x000fe20000200c00ULL,
0x000001004a0e7824ULL, 0x002fe200078e00ffULL, 0x0000888026837816ULL, 0x000fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00008880277e7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000023009e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff277819ULL, 0x000fc60000011427ULL, 0x0000000e00b37306ULL, 0x0005e20000200c00ULL,
0x000000001720783bULL, 0x002e6e0000004200ULL, 0x00000016008a7306ULL, 0x0007e20000200c00ULL,
0x000001001c0e7824ULL, 0x044fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000001000b27306ULL, 0x0005e20000200c00ULL,
0x00000004ff167819ULL, 0x008fe40000011607ULL, 0x00000018ff1c7819ULL, 0x000fca000001141cULL,
0x0000000e00a17306ULL, 0x0007e20000200c00ULL, 0x000001001d107824ULL, 0x044fe400078e00ffULL,
0x000100001d1d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000004800b57306ULL, 0x000fe20000200c00ULL, 0x000001001e0e7824ULL, 0x048fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000001000a07306ULL, 0x0005e20000200c00ULL,
0x00000018ff697819ULL, 0x002fe20000011420ULL, 0x00000100207c7824ULL, 0x040fe200078e00ffULL,
0x00008880207d7816ULL, 0x040fe200000000ffULL, 0x0001000020767824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011421ULL, 0x00000100217b7824ULL, 0x040fe200078e00ffULL,
0x00008880217a7816ULL, 0x000fe200000000ffULL, 0x0000000e00947306ULL, 0x0003e20000200c00ULL,
0x000001001f107824ULL, 0x004fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011422ULL,
0x0001000021777824ULL, 0x000fe200078e00ffULL, 0x0000888022707816ULL, 0x040fe200000000ffULL,
0x0000010023217824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000001800a37306ULL, 0x0005e20000200c00ULL,
0x00000007070e7812ULL, 0x002fe200078ec0ffULL, 0x00000100226f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x000000080e177812ULL, 0x000fe200078ef807ULL, 0x0001000023737824ULL, 0x000fe200078e00ffULL,
0x00000004070e7811ULL, 0x000fe200078fe0ffULL, 0x0000001000957306ULL, 0x0003e20000200c00ULL,
0x0000000716167812ULL, 0x000fc400078e7817ULL, 0x0000000207187811ULL, 0x004fe400078fe0ffULL,
0x000000070e0e7812ULL, 0x100fe200078e7817ULL, 0x0000000817167824ULL, 0x000fe200078e0216ULL,
0x0000000718187812ULL, 0x100fe200078e7817ULL, 0x0000004900b67306ULL, 0x000fe20000200c00ULL,
0x0000000607107811ULL, 0x002fe200078fe0ffULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000000817187824ULL, 0x000fe200078e0218ULL,
0x0000000710107812ULL, 0x000fe200078e7817ULL, 0x0000080009487824ULL, 0x000fe200078e0216ULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000004a00af7306ULL, 0x000fe20000200c00ULL,
0x00000008170e7824ULL, 0x040fe200078e020eULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000000817107824ULL, 0x000fe200078e0210ULL, 0x00000015ff17723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011423ULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x0000004b00b07306ULL, 0x0003e20000200c00ULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0x00008880236e7816ULL, 0x000fe200000000ffULL,
0x0000080009c27824ULL, 0x040fe200078e0218ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000080009a87824ULL, 0x040fe200078e020eULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000080009887824ULL, 0x000fe200078e0210ULL, 0x0000002400857306ULL, 0x0005e20000200c00ULL,
0x011000004848783bULL, 0x002fe20000000200ULL, 0x00000001ff097819ULL, 0x000fc4000001161aULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000000209207824ULL, 0x000fe200078e025bULL, 0x0000002500847306ULL, 0x0003e20000200c00ULL,
0x000001806c247811ULL, 0x004fe400078e18ffULL, 0x000000086d6c7810ULL, 0x000fe40007ffe0ffULL,
0x0001300020207811ULL, 0x000fe200078e68ffULL, 0x000000011b5d7824ULL, 0x100fe200078e0224ULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x000000c300c37306ULL, 0x000ea20000200c00ULL,
0x0000541017257816ULL, 0x002fe20000000017ULL, 0x0000000119177824ULL, 0x000fe200078e0224ULL,
0x00000018ff737819ULL, 0x000fc60000011473ULL, 0x00001f6d256d7589ULL, 0x000e6200000e0000ULL,
0x0000001017247824ULL, 0x000fe200078e0220ULL, 0x0000006500657306ULL, 0x000ee40000200c00ULL,
0x00001f6c256c7589ULL, 0x000f2c00000e0000ULL, 0x0000006400647306ULL, 0x000eb00000200c00ULL,
0x0000001c009c7306ULL, 0x0005e20000200c00ULL, 0x0000006d48488232ULL, 0x002fce0000000000ULL,
0x0000002100717306ULL, 0x0007e20000200c00ULL, 0x000000105d1c7824ULL, 0x004fe200078e0220ULL,
0x0000006d4a4a8232ULL, 0x000fe20000000000ULL, 0x00005410c0207816ULL, 0x000fe200000000c3ULL,
0x0000006c49498232ULL, 0x090fe40000000000ULL, 0x0000006c4b4b8232ULL, 0x000fe40000000000ULL,
0x000000bd00bd7306ULL, 0x000e620000200c00ULL, 0x0000541065217816ULL, 0x008fce00000000c4ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x000000204840723cULL, 0x000fee0000001840ULL,
0x0000006a006a7306ULL, 0x000ee20000200c00ULL, 0x00005410c1207816ULL, 0x000fe400000000beULL,
0x00005410bf217816ULL, 0x000fca0000000064ULL, 0x0000006b006b7306ULL, 0x000f240000200c00ULL,
0x000000204838723cULL, 0x000fec0000001838ULL, 0x000000bb00bb7306ULL, 0x000f220000200c00ULL,
0x00005410bd207816ULL, 0x002fe400000000bcULL, 0x0000541063217816ULL, 0x004fc400000000baULL,
0x00005410b76a7816ULL, 0x008fc6000000006aULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x00005410626b7816ULL, 0x010fe2000000006bULL, 0x000000204834723cULL, 0x040fec0000001834ULL,
0x0000001d009a7306ULL, 0x000fe40000200c00ULL, 0x0000006a4828723cULL, 0x000fec0000001828ULL,
0x0000001e00907306ULL, 0x000fe20000200c00ULL, 0x00005410bb6a7816ULL, 0x000fc400000000b8ULL,
0x00005410746b7816ULL, 0x002fca00000000b9ULL, 0x0000001f008e7306ULL, 0x0003e40000200c00ULL,
0x0000006a482c723cULL, 0x000fec000000182cULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x000000001c1c783bULL, 0x002e6e0000004200ULL, 0x0000007500757306ULL, 0x000ef00000200c00ULL,
0x0000002200727306ULL, 0x0009e20000200c00ULL, 0x00005410b56a7816ULL, 0x004fce000000008cULL,
0x000000b400b47306ULL, 0x000ea20000200c00ULL, 0x01100000c220783bULL, 0x010f220000000200ULL,
0x00005410b66b7816ULL, 0x008fcc0000000075ULL, 0x000000b100b17306ULL, 0x000ee20000200c00ULL,
0x0000006a4830723cULL, 0x000fee0000001830ULL, 0x000000ae00ae7306ULL, 0x000f220000200c00ULL,
0x00005410b46a7816ULL, 0x004fe400000000b3ULL, 0x00000018ff677819ULL, 0x002fc4000001141cULL,
0x00000018ff667819ULL, 0x000fe4000001141dULL, 0x000088801c8c7816ULL, 0x040fe200000000ffULL,
0x000000ad00ad7306ULL, 0x000e620000200c00ULL, 0x00005410b16b7816ULL, 0x008fe200000000b2ULL,
0x000001001cb17824ULL, 0x040fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001141eULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc6000001141fULL,
0x000000aa00aa7306ULL, 0x000fe20000200c00ULL, 0x0000006a483c723cULL, 0x000fe2000000183cULL,
0x00000018ff1c7819ULL, 0x000fcc000001141cULL, 0x000000ab00ab7306ULL, 0x000fe20000200c00ULL,
0x00005410af6a7816ULL, 0x010fe200000000aeULL, 0x0000006d20208232ULL, 0x080fe20000000000ULL,
0x00005410b06b7816ULL, 0x002fe200000000adULL, 0x0000006d22228232ULL, 0x000fe20000000000ULL,
0x00000018ffad7819ULL, 0x000fe200000114b1ULL, 0x0000006c21218232ULL, 0x080fe40000000000ULL,
0x0000009900997306ULL, 0x000e620000200c00ULL, 0x0000006c23238232ULL, 0x000fe20000000000ULL,
0x0000006a4844723cULL, 0x000fec0000001844ULL, 0x000000a600a67306ULL, 0x000ea20000200c00ULL,
0x000088801d487816ULL, 0x040fe200000000ffULL, 0x000001001d4a7824ULL, 0x000fc400078e00ffULL,
0x000100001d1d7824ULL, 0x000fc800078e00ffULL, 0x0000009800987306ULL, 0x000ee20000200c00ULL,
0x0000541099497816ULL, 0x002fe400000000acULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff997819ULL, 0x000fc6000001144aULL, 0x00000048006a7306ULL, 0x0003f00000200c00ULL,
0x000000a500a57306ULL, 0x000f220000200c00ULL, 0x00005410aa487816ULL, 0x002fce00000000abULL,
0x0000009f009f7306ULL, 0x000e620000200c00ULL, 0x000000482040723cULL, 0x000fee0000001840ULL,
0x0000009600967306ULL, 0x000e620000200c00ULL, 0x00005410a9487816ULL, 0x004fe400000000a6ULL,
0x00005410a7497816ULL, 0x008fca0000000098ULL, 0x0000009300937306ULL, 0x000ea40000200c00ULL,
0x000000482038723cULL, 0x000fec0000001838ULL, 0x000000a200a27306ULL, 0x000ee20000200c00ULL,
0x00005410a5487816ULL, 0x010fe400000000a3ULL, 0x000054109f497816ULL, 0x002fc400000000a4ULL,
0x000088801ea37816ULL, 0x000fc600000000ffULL, 0x0000009d009d7306ULL, 0x000e640000200c00ULL,
0x000000482048723cULL, 0x000fe20000001834ULL, 0x01100000a834783bULL, 0x000f2a0000000200ULL,
0x0000001c00987306ULL, 0x0003f00000200c00ULL, 0x0000001d009f7306ULL, 0x0005e20000200c00ULL,
0x000054109b1c7816ULL, 0x002fe20000000096ULL, 0x000001001e967824ULL, 0x000fe200078e00ffULL,
0x000088801f9b7816ULL, 0x000fc800000000ffULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x000054109e1d7816ULL, 0x004fce0000000093ULL,
0x0000008f008f7306ULL, 0x000ea20000200c00ULL, 0x0000001c2028723cULL, 0x000fee0000001828ULL,
0x0000009700977306ULL, 0x000e620000200c00ULL, 0x00005410a21c7816ULL, 0x008fe400000000a1ULL,
0x000054109d1d7816ULL, 0x000fe200000000a0ULL, 0x0000006d34348232ULL, 0x010fc40000000000ULL,
0x0000006d36368232ULL, 0x000fe40000000000ULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x0000006c35358232ULL, 0x080fe20000000000ULL, 0x0000001c202c723cULL, 0x000fe2000000182cULL,
0x0000006c37378232ULL, 0x000fca0000000000ULL, 0x0000002600787306ULL, 0x000fe20000200c00ULL,
0x000054109c1c7816ULL, 0x002fe20000000091ULL, 0x000001001f917824ULL, 0x040fe200078e00ffULL,
0x000054109a1d7816ULL, 0x004fe2000000008fULL, 0x000000ffff8f7224ULL, 0x000fe400078e009bULL,
0x000100001f1f7824ULL, 0x000fe400078e00ffULL, 0x0000002700797306ULL, 0x0003e40000200c00ULL,
0x0000001c2030723cULL, 0x000fe20000001830ULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000000002424783bULL, 0x002e620000004200ULL,
0x00005410971c7816ULL, 0x000fe40000000094ULL, 0x00005410921d7816ULL, 0x008fc80000000095ULL,
0x0000008b008b7306ULL, 0x000ea60000200c00ULL, 0x0000001c203c723cULL, 0x000fea000000183cULL,
0x0000008700877306ULL, 0x000ee40000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe20000011491ULL,
0x000100001e917824ULL, 0x000fca00078e00ffULL, 0x0000008600867306ULL, 0x000f220000200c00ULL,
0x000054108e1d7816ULL, 0x004fe4000000008bULL, 0x00000018ff8e7819ULL, 0x000fca0000011491ULL,
0x0000001c001e7306ULL, 0x0005f00000200c00ULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x00005410901c7816ULL, 0x004fe4000000008dULL, 0x00000018ff627819ULL, 0x002fc40000011425ULL,
0x00000018ff637819ULL, 0x000fe40000011424ULL, 0x00000018ff747819ULL, 0x000fe20000011426ULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x0000001c2020723cULL, 0x000fe20000001844ULL,
0x00000018ff757819ULL, 0x000fcc0000011427ULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x00005410871c7816ULL, 0x008fe4000000008aULL, 0x00005410861d7816ULL, 0x010fe40000000089ULL,
0x0000888024447816ULL, 0x000fc600000000ffULL, 0x0000007e007e7306ULL, 0x000ee40000200c00ULL,
0x0000001c3440723cULL, 0x000fe20000001840ULL, 0x000000ffff867224ULL, 0x000fe400078e0044ULL,
0x0000010024447824ULL, 0x040fe400078e00ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000006100617306ULL, 0x000f220000200c00ULL, 0x00005410851c7816ULL, 0x000fe40000000082ULL,
0x00005410841d7816ULL, 0x002fc4000000007fULL, 0x00000018ff7f7819ULL, 0x000fe40000011444ULL,
0x011000008844783bULL, 0x000e620000000200ULL, 0x0000006000607306ULL, 0x000f220000200c00ULL,
0x0000888025827816ULL, 0x000fe200000000ffULL, 0x0000001c3438723cULL, 0x000fe20000001838ULL,
0x00000018ff247819ULL, 0x000fca0000011424ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x00005410831c7816ULL, 0x004fe20000000080ULL, 0x0000010025807824ULL, 0x040fe200078e00ffULL,
0x000054107e1d7816ULL, 0x008fe20000000081ULL, 0x0001000025257824ULL, 0x000fe400078e00ffULL,
0x000000ffff7e7224ULL, 0x000fe400078e0082ULL, 0x0000007c007c7306ULL, 0x000ea40000200c00ULL,
0x0000001c3448723cULL, 0x000fec0000001848ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410781c7816ULL, 0x010fc40000000061ULL, 0x00005410791d7816ULL, 0x000fe40000000060ULL,
0x00000018ff617819ULL, 0x000fc60000011480ULL, 0x0000007b007b7306ULL, 0x000ee40000200c00ULL,
0x0000001c3428723cULL, 0x000fe20000001828ULL, 0x0000006d44448232ULL, 0x002fca0000000000ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054107d1c7816ULL, 0x004fe2000000007cULL,
0x0000006d46468232ULL, 0x000fe40000000000ULL, 0x0000006c45458232ULL, 0x080fe40000000000ULL,
0x0000006c47478232ULL, 0x000fe40000000000ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000054107a1d7816ULL, 0x008fce000000007bULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000001c342c723cULL, 0x000fee000000182cULL, 0x0000007700777306ULL, 0x000eb00000200c00ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x00005410761c7816ULL, 0x002fce0000000069ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00005410771d7816ULL, 0x004fce0000000068ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541072727816ULL, 0x008fe2000000005fULL,
0x0000001c3430723cULL, 0x000fec0000001830ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe20000011425ULL, 0x0000010026257824ULL, 0x040fe200078e00ffULL,
0x00008880261c7816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x0000541070707816ULL, 0x002fce000000006fULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x000054106e717816ULL, 0x004fce0000000071ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000541073737816ULL, 0x008fe2000000005eULL, 0x00000070343c723cULL, 0x000fe2000000183cULL,
0x00008880275e7816ULL, 0x000fca00000000ffULL, 0x0000006400647306ULL, 0x000fe40000200c00ULL,
0x000000723420723cULL, 0x000fec0000001820ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x000054108f357816ULL, 0x002fe2000000001eULL, 0x00010000271e7824ULL, 0x000fc400078e00ffULL,
0x0000010027347824ULL, 0x000fc800078e00ffULL, 0x0000001f001f7306ULL, 0x000e620000200c00ULL,
0x00000018ff607819ULL, 0x000fce0000011434ULL, 0x0000006700677306ULL, 0x000eb00000200c00ULL,
0x00000025005f7306ULL, 0x0007e20000200c00ULL, 0x000054101f1f7816ULL, 0x002fce0000000064ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000018ff257819ULL, 0x008fe4000001141eULL,
0x000054108e1e7816ULL, 0x000fe40000000065ULL, 0x0000541098987816ULL, 0x004fc60000000067ULL,
0x0000009900997306ULL, 0x000e640000200c00ULL, 0x0000001e4428723cULL, 0x000fec0000001828ULL,
0x0000001d001d7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000054106a8d7816ULL, 0x002fce0000000099ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x000054109f997816ULL, 0x004fce0000000066ULL,
0x000000ad006b7306ULL, 0x000e620000200c00ULL, 0x000000984438723cULL, 0x000fee0000001838ULL,
0x000000a300937306ULL, 0x000ff00000200c00ULL, 0x0000009600967306ULL, 0x000ea20000200c00ULL,
0x000054108c8c7816ULL, 0x002fce000000006bULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x0000008c4440723cULL, 0x000fee0000001840ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541093347816ULL, 0x004fce0000000096ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x000000344434723cULL, 0x000fee0000001848ULL, 0x0000006100617306ULL, 0x000e700000200c00ULL,
0x0000002400247306ULL, 0x000eb00000200c00ULL, 0x0000001c001c7306ULL, 0x000ee20000200c00ULL,
0x000054107e617816ULL, 0x002fce0000000061ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541024247816ULL, 0x004fce0000000063ULL, 0x0000006000677306ULL, 0x0003e20000200c00ULL,
0x000054101c1c7816ULL, 0x008fce000000005fULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541086607816ULL, 0x002fce000000007fULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000060442c723cULL, 0x000fee000000182cULL, 0x0000002600277306ULL, 0x000e700000200c00ULL,
0x00000025001e7306ULL, 0x0004e20000200c00ULL, 0x0000541027747816ULL, 0x002fc40000000074ULL,
0x000054101d257816ULL, 0x004fe40000000062ULL, 0x000054105e1d7816ULL, 0x000fe40000000067ULL,
0x000054101e757816ULL, 0x008fc60000000075ULL, 0x000000244430723cULL, 0x040ff00000001830ULL,
0x0000001c443c723cULL, 0x040fee000000183cULL, 0x0001b610091c7811ULL, 0x040fe200078e20ffULL,
0x000000744444723cULL, 0x000fe20000001820ULL, 0x0001b668091d7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000001dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000045c1f7824ULL, 0x000fe200078e0209ULL,
0x000000ff58ff7812ULL, 0x000fe2000780c0ffULL, 0x000000001cff7f8cULL, 0x0005e2000c80043fULL,
0x00000001051e7812ULL, 0x000fc400078ec0ffULL, 0x000000801f1f7811ULL, 0x000fe400078e30ffULL,
0x00000001ff5e7807ULL, 0x000fe40000000000ULL, 0x000000001f00720cULL, 0x000fe40003f06070ULL,
0x000000011e00780cULL, 0x000fe40003f65070ULL, 0x000000ff5aff7812ULL, 0x000fe4000784c0ffULL,
0x00000001041e7807ULL, 0x000fc40005800000ULL, 0x000000015b00780cULL, 0x000fe40003f25270ULL,
0x00000001ff1c7807ULL, 0x004fe20001000000ULL, 0x0000000105057824ULL, 0x000fe200078e021eULL,
0x000000585e587207ULL, 0x000fe40004800000ULL, 0x000076101c5a7816ULL, 0x000fe4000000005aULL,
0x000000015b5b7812ULL, 0x000fe200078e0cffULL, 0x000030b000000947ULL, 0x000fea0003800000ULL,
0x01b66c00571e7984ULL, 0x000ea20000000800ULL, 0x800000001c057824ULL, 0x000fca00078e00ffULL,
0x800000001eff7812ULL, 0x004fe20007804805ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01b66c00571e7984ULL, 0x000ea40000000800ULL,
0x800000001eff7812ULL, 0x004fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001c1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff057424ULL, 0x000fc800078e00ffULL, 0x0000000500097305ULL, 0x0004e4000021f000ULL,
0x3fa0000005057823ULL, 0x004fe200000100ffULL, 0x000000090000735dULL, 0x008fe40003800000ULL,
0x000004001d097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000159597824ULL, 0x000fe200078e024eULL, 0x00000001ff237819ULL, 0x000fe4000001161aULL,
0x000003005c1e7a10ULL, 0x000fe40007ffe0ffULL, 0x0000000159057812ULL, 0x000fc600078ec0ffULL,
0x000000041e1f7824ULL, 0x000fe200078e0223ULL, 0x000000010500780cULL, 0x000fc60003f05070ULL,
0x000000401f1f7824ULL, 0x000fe200078e00ffULL, 0x00000001041c7807ULL, 0x000fc80004000000ULL,
0x000000400b097812ULL, 0x000fe200078ef81fULL, 0x0000000159057824ULL, 0x000fc800078e021cULL,
0x0000000406227c24ULL, 0x020fe2000f8e0209ULL, 0x000000020500720cULL, 0x000fe20003f06070ULL,
0x0000200011097824ULL, 0x040fe400078e00ffULL, 0x000000081a207824ULL, 0x000fe400078e00ffULL,
0x0000000811217824ULL, 0x000fe200078e00ffULL, 0x0000200009097812ULL, 0x000fe200078ec0ffULL,
0xffffffffff067424ULL, 0x000fcc00078e00ffULL, 0x00000001121c8824ULL, 0x000fe400078e0205ULL,
0x00000004ff1d8424ULL, 0x002fe200078e00ffULL, 0xfffffff020207812ULL, 0x000fc600078ec0ffULL,
0x000060001c1c8625ULL, 0x000fe200078e001dULL, 0x0000000821217812ULL, 0x000fe400078ec0ffULL,
0x000000011e1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000400023097824ULL, 0x000fe200078e0209ULL,
0x000000081c068981ULL, 0x000362000c1e1900ULL, 0x0001b64820247810ULL, 0x000fe20007ffe0ffULL,
0x00000000210673c2ULL, 0x0004e200000e0000ULL, 0x00000003ff257819ULL, 0x000fe20000011607ULL,
0x00000080ff737424ULL, 0x000fe200078e00ffULL, 0x000000204c4e7812ULL, 0x000fc400078ec0ffULL,
0x000000031e00720cULL, 0x000fe40003f06070ULL, 0x00013000091e7810ULL, 0x000fe20007ffe0ffULL,
0x00000000240573c2ULL, 0x0008e200000e0000ULL, 0x00000008211d7812ULL, 0x002fe200078e3cffULL,
0x0000001007217824ULL, 0x004fe200078e00ffULL, 0x0000001f001c7217ULL, 0x000fe20007800000ULL,
0x0000001056577824ULL, 0x000fe200078e021eULL, 0x0000001c25617810ULL, 0x040fe20007ffe0ffULL,
0x0000000124097824ULL, 0x000fe200078e021dULL, 0x0000001025637810ULL, 0x040fe20007ffe0ffULL,
0x00000001251d7824ULL, 0x140fe200078e024eULL, 0x0000001425697810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a1fULL, 0x0000000825497810ULL, 0x000fe20007ffe0ffULL,
0x0000000163247824ULL, 0x110fe200078e024eULL, 0x0000000c25677810ULL, 0x000fe20007ffe0ffULL,
0x0000000169237824ULL, 0x100fe200078e024eULL, 0x0000007f1d717812ULL, 0x000fe200078ec0ffULL,
0x00000001611d7824ULL, 0x100fe200078e024eULL, 0x0000001825657810ULL, 0x000fe20007ffe0ffULL,
0x0000000149487824ULL, 0x000fe200078e024eULL, 0x0000000425277810ULL, 0x000fe20007ffe0ffULL,
0x0000001055557824ULL, 0x100fe200078e021eULL, 0x000000401c1c7807ULL, 0x000fe20000000000ULL,
0x0000001054597824ULL, 0x100fe200078e021eULL, 0x0000007f1d1f7812ULL, 0x000fe200078ec0ffULL,
0x0000001053537824ULL, 0x100fe200078e021eULL, 0x0000001c4e1c7217ULL, 0x000fe20007800000ULL,
0x00000010525b7824ULL, 0x100fe200078e021eULL, 0x0000007f246b7812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x100fe200078e021eULL, 0x0000000605057290ULL, 0x008fe2000fffe03fULL,
0x000000104f4f7824ULL, 0x000fc400078e021eULL, 0x000000104d5f7824ULL, 0x000fe200078e021eULL,
0x0000007f234d7812ULL, 0x000fe200078ec0ffULL, 0x0000000167267824ULL, 0x100fe200078e024eULL,
0x0000007f48237812ULL, 0x000fe200078ec0ffULL, 0x00000001651e7824ULL, 0x100fe400078e024eULL,
0x00000001274a7824ULL, 0x000fe200078e024eULL, 0x0000007f266d7812ULL, 0x000fe200078ec0ffULL,
0x00000001711d7824ULL, 0x000fe200078e0222ULL, 0x0000007f1e4b7812ULL, 0x000fe200078ec0ffULL,
0x000000011c4e7824ULL, 0x000fe200078e0a4eULL, 0x0000007f4a6f7812ULL, 0x000fe200078ec0ffULL,
0x000000016b267824ULL, 0x000fe200078e0222ULL, 0x00000070216b7812ULL, 0x000fe200078ec0ffULL,
0x00005e001d1c7625ULL, 0x000fe200078e0073ULL, 0x0000004e2500720cULL, 0x000fc40003fa6070ULL,
0x0000004e4900720cULL, 0x080fe20003f66070ULL, 0x0000000123237824ULL, 0x100fe200078e0222ULL,
0x0000006b1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000016f1e7824ULL, 0x100fe200078e0222ULL,
0x0000004e2700720cULL, 0x000fe20003f86070ULL, 0x000000016d247824ULL, 0x100fe400078e0222ULL,
0x000000014d487824ULL, 0x100fe400078e0222ULL, 0x000000014b4a7824ULL, 0x100fe400078e0222ULL,
0x000000011f4c7824ULL, 0x000fc400078e0222ULL, 0x00005e0023227625ULL, 0x000fc800078e0073ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000006b22227210ULL, 0x000fe20007f1e0ffULL,
0x00005e001e1e7625ULL, 0x000fc600078e0073ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c577faeULL, 0x0003e2000e901c48ULL, 0x00005e0024247625ULL, 0x000fe200078e0073ULL,
0x0000006b1e1e7210ULL, 0x080fe40007f3e0ffULL, 0x0000004e6500720cULL, 0x000fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x0000006b24247210ULL, 0x000fe20007f1e0ffULL,
0x00005e0048487625ULL, 0x000fc800078e0073ULL, 0x00005e0026267625ULL, 0x000fe200078e0073ULL,
0x0000006b48487210ULL, 0x000fc60007f5e0ffULL, 0x00005e004a4a7625ULL, 0x000fc800078e0073ULL,
0x000000ffff1f7224ULL, 0x000fe200008e061fULL, 0x0000006b26267210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000006b4a4a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff497224ULL, 0x000fe200010e0649ULL, 0x0000004e6700720cULL, 0x080fe20003f46070ULL,
0x000000ffff277224ULL, 0x000fe200008e0627ULL, 0x0000004e6300720cULL, 0x080fe20003f26070ULL,
0x000000ffff4b7224ULL, 0x000fe200000e064bULL, 0x0000004e6900720cULL, 0x080fe20003f06070ULL,
0x00005e004c4c7625ULL, 0x000fe200078e0073ULL, 0x000000001e557faeULL, 0x0005e2000e101c48ULL,
0x0000004e6100720cULL, 0x000fc60003f86070ULL, 0x0000006b4c4c7210ULL, 0x000fe20007fde0ffULL,
0x0000000022597faeULL, 0x0005e8000d901c48ULL, 0x000000ffff4d7224ULL, 0x000fe200030e064dULL,
0x0000000024537faeULL, 0x0005e8000d101c48ULL, 0x00000000265b7faeULL, 0x0005e8000c901c48ULL,
0x0000000048517faeULL, 0x0005e8000c101c48ULL, 0x000000004a4f7faeULL, 0x0005e8000e901c48ULL,
0x000000004c5f7faeULL, 0x0005e8000e101c48ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000400091d7984ULL, 0x0002e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01b62c00201f7984ULL, 0x004ea20000000800ULL, 0x0000ffff58587812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0f1c7812ULL, 0x000fe400078ec0ffULL, 0x0000888058587816ULL, 0x000fe400000000ffULL,
0x000088801c227816ULL, 0x000fc600000000ffULL, 0x000000ffff1c7224ULL, 0x000fe400078e0058ULL,
0x80000000221e7824ULL, 0x000fe400078e00ffULL, 0x800000001c1c7824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x008fe4000780481cULL, 0x800000001fff7812ULL, 0x004fe2000782481eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x80000000221d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001e7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001e0000735dULL, 0x008fe40003800000ULL, 0x01b62c00201e7984ULL, 0x000ea40000000800ULL,
0x800000001eff7812ULL, 0x004fc4000782481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000401a1c7824ULL, 0x000fe200078e00ffULL,
0x00000070211f7812ULL, 0x000fe200078ec0ffULL, 0x00000001ffb87424ULL, 0x000fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe40000011607ULL, 0xffffff801c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1d1d7812ULL, 0x000fe400078ec0ffULL, 0x000001001f1c7810ULL, 0x000fca0007ffe01cULL,
0x000000011d1c7824ULL, 0x000fca00078e021cULL, 0x01b000001c1d7984ULL, 0x000ea80000000800ULL,
0x01b200001c1e7984ULL, 0x0007220000000800ULL, 0x0000000c1d00720bULL, 0x004fda0003f3d000ULL,
0x00000000001f7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1f207812ULL, 0x000fda000782c0ffULL,
0x000003b000009947ULL, 0x000fea0003800000ULL, 0x0000000c1d00720bULL, 0x018fe40003f54000ULL,
0x0000001d0c227209ULL, 0x000fe40007810000ULL, 0x000000021a1f7811ULL, 0x000fe400078ff8ffULL,
0x00000002ff237819ULL, 0x000fe20000011607ULL, 0x800000220c1c7221ULL, 0x000fe20000010000ULL,
0x0000001a1f00720cULL, 0x000fe40003f25270ULL, 0x0000000823257810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc40000410000ULL, 0x00000000000c7806ULL, 0x000fe400010e0100ULL,
0x0000001c00247308ULL, 0x0004e40000000800ULL, 0x0000ffff0c1f7812ULL, 0x000fc800078e3cffULL,
0x0000001f20ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007021219812ULL, 0x000fe400078ec0ffULL,
0x00000001ff1f9819ULL, 0x000fe40000011607ULL, 0x00000001ffb87807ULL, 0x000fe20001000000ULL,
0x000000801a1c9824ULL, 0x004fe200078e0221ULL, 0x0000000c1f1f9812ULL, 0x000fe200078ec0ffULL,
0x00001f23240c7589ULL, 0x008ea200000e0000ULL, 0x000000240d0d7220ULL, 0x000fc60000410000ULL,
0x000000011f1f9824ULL, 0x000fe400078e021cULL, 0x800000221d1d2221ULL, 0x000fe20000010000ULL,
0x00001f25241c7589ULL, 0x000ee600000e0000ULL, 0x3fb8aa3b1d1d2820ULL, 0x000fe20000410000ULL,
0x01b400221f009388ULL, 0x0009e60000000800ULL, 0x0000001d00152308ULL, 0x000e620000000800ULL,
0x0000000c40407220ULL, 0x004fc40000410000ULL, 0x0000000c41417220ULL, 0x080fe40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x080fe40000410000ULL, 0x0000000c35357220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x000fc40000410000ULL, 0x0000000c29297220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x000fc40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c44447220ULL, 0x080fe40000410000ULL, 0x0000000c45457220ULL, 0x000fe40000410000ULL,
0x0000001c42427220ULL, 0x088fe40000410000ULL, 0x0000001c43437220ULL, 0x080fe40000410000ULL,
0x0000001c3a3a7220ULL, 0x000fc40000410000ULL, 0x0000001c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001c36367220ULL, 0x080fe40000410000ULL, 0x0000001c37377220ULL, 0x080fe40000410000ULL,
0x0000001c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000001c2e2e7220ULL, 0x000fc40000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001c32327220ULL, 0x080fe40000410000ULL, 0x0000001c33337220ULL, 0x080fe40000410000ULL,
0x0000001c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000001c46467220ULL, 0x000fc40000410000ULL, 0x0000001c47477220ULL, 0x000fe40000410000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0022ULL, 0x0000001e151e2220ULL, 0x002fc80000410000ULL,
0x0000000d1e0d7221ULL, 0x018fe20000010000ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x00000008111c7824ULL, 0x040fe200078e00ffULL, 0x000000011100780cULL, 0x000fe20003f05270ULL,
0x000000081a1d7824ULL, 0x000fc600078e00ffULL, 0x000000081c1c7812ULL, 0x000fe400078e0cffULL,
0xfffffff01d1d7812ULL, 0x000fca00078ec0ffULL, 0x000000011d1c7824ULL, 0x000fe200078e021cULL,
0x000000135e1d7207ULL, 0x000fc80004000000ULL, 0x0000ffff1d1d7812ULL, 0x000fe200078ec0ffULL,
0x01b64c001c1c7984ULL, 0x000ea60000000800ULL, 0x000088801d1e7816ULL, 0x000fca00000000ffULL,
0x800000001e1d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x004fe2000780481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001d0000735dULL, 0x008fe40003800000ULL, 0x00000400091d7984ULL, 0x000ea40000000800ULL,
0x800000001dff7812ULL, 0x004fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00002000111c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x002fe4000001161aULL, 0x0000000750507812ULL, 0x000fe400078ef807ULL,
0x000020001c1c7812ULL, 0x000fe400078e0cffULL, 0x0000008050487811ULL, 0x040fe200078e18ffULL,
0x00000008501d7824ULL, 0x040fe200078e021bULL, 0x0000010050547811ULL, 0x000fe200078e18ffULL,
0x00004000091c7824ULL, 0x000fe200078e021cULL, 0x00009910b8b87816ULL, 0x000fe200000000ffULL,
0x0000000850217824ULL, 0x000fc400078e0219ULL, 0x000000011b247824ULL, 0x100fe200078e0248ULL,
0x000130001c587810ULL, 0x000fe20007ffe0ffULL, 0x0000000119487824ULL, 0x000fe200078e0248ULL,
0x000000ffb800720cULL, 0x000fe20003f05270ULL, 0x000000011b1b7824ULL, 0x000fe400078e0254ULL,
0x000000101d1c7824ULL, 0x100fe400078e0258ULL, 0x0000001021207824ULL, 0x100fe400078e0258ULL,
0x0000001024247824ULL, 0x000fc400078e0258ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x0000001048487824ULL, 0x100fe400078e0258ULL, 0x000000101b1b7824ULL, 0x100fe200078e0258ULL,
0x000000002020783bULL, 0x000fe20000004200ULL, 0x000000105d507824ULL, 0x000fe400078e0258ULL,
0x0000000119197824ULL, 0x000fe200078e0254ULL, 0x000000002424783bULL, 0x000fe60000004200ULL,
0x0000001019197824ULL, 0x100fe200078e0258ULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x0000001017587824ULL, 0x000fc600078e0258ULL, 0x000000001b4c783bULL, 0x000ea80000004200ULL,
0x000000005050783bULL, 0x000ee80000004200ULL, 0x000000001954783bULL, 0x000f280000004200ULL,
0x000000005858783bULL, 0x000ee20000004200ULL, 0x00000018ffb17819ULL, 0x002fe2000001141cULL,
0x000001001c697824ULL, 0x040fe200078e00ffULL, 0x000088801cb77816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe2000001141dULL,
0x000001001d6e7824ULL, 0x040fe200078e00ffULL, 0x000088801db47816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x000000b700b77306ULL, 0x000fe20000200c00ULL, 0x00000018ff697819ULL, 0x000fc40000011469ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ffa67819ULL, 0x000fe4000001141eULL,
0x00000018ffa47819ULL, 0x000fe2000001141fULL, 0x0000001c00b27306ULL, 0x0003e20000200c00ULL,
0x000088801eaf7816ULL, 0x000fe200000000ffULL, 0x000100004f6f7824ULL, 0x004fe200078e00ffULL,
0x000088801fac7816ULL, 0x000fe400000000ffULL, 0x00000018ff9d7819ULL, 0x000fc40000011420ULL,
0x00000018ff9c7819ULL, 0x000fe20000011421ULL, 0x0000001d00b37306ULL, 0x0005e20000200c00ULL,
0x000001001f1c7824ULL, 0x042fe200078e00ffULL, 0x0000888020aa7816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888021a57816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006900b67306ULL, 0x0002e20000200c00ULL,
0x00000100201d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001146eULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00ad7306ULL, 0x0005e20000200c00ULL,
0x000001001e697824ULL, 0x042fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe4000001144eULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000001d00a77306ULL, 0x0003e20000200c00ULL,
0x00000100211c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x000088804e727816ULL, 0x000fc400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e00ab7306ULL, 0x000fe20000200c00ULL,
0x00000100221d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff937819ULL, 0x000fe40000011422ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00a87306ULL, 0x0003e20000200c00ULL, 0x0000888022a17816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001144aULL,
0x000088804a817816ULL, 0x000fe400000000ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000001d00a07306ULL, 0x0005e20000200c00ULL, 0x00000100231c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe40000011424ULL, 0x00000018ff8c7819ULL, 0x000fe40000011425ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001f00a97306ULL, 0x000fe20000200c00ULL,
0x00000100241d7824ULL, 0x044fe200078e00ffULL, 0x0000888024997816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000888025967816ULL, 0x000fc400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c009f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff927819ULL, 0x000fe40000011423ULL, 0x00008880239e7816ULL, 0x040fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff687819ULL, 0x000fe2000001144fULL, 0x0000001d00987306ULL, 0x0005e20000200c00ULL,
0x00000100251c7824ULL, 0x002fe200078e00ffULL, 0x000088804f707816ULL, 0x000fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fc40000011423ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006900ae7306ULL, 0x0003e20000200c00ULL,
0x00000100261d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff837819ULL, 0x000fe40000011426ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00977306ULL, 0x0005e20000200c00ULL, 0x00000002ff697819ULL, 0x002fc40000011607ULL,
0x00000018ff827819ULL, 0x000fe40000011427ULL, 0x0000888026917816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00008880278e7816ULL, 0x040fe200000000ffULL,
0x0000001d00907306ULL, 0x0003e20000200c00ULL, 0x00000100271c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff607819ULL, 0x008fe20000011452ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000002000a27306ULL, 0x000fe20000200c00ULL, 0x00000100481d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff5f7819ULL, 0x000fe40000011453ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe40000011448ULL, 0x0000888048897816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001144bULL,
0x00000018ff6b7819ULL, 0x000fe2000001144cULL, 0x0000001d00887306ULL, 0x0005e20000200c00ULL,
0x00000100491c7824ULL, 0x002fe200078e00ffULL, 0x000088804b7e7816ULL, 0x000fe400000000ffULL,
0x000088804c7b7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000002100a37306ULL, 0x0003e20000200c00ULL, 0x000001004a1d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011449ULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc4000001144dULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00877306ULL, 0x0005e20000200c00ULL, 0x0000000869217810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000888049867816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000001d00807306ULL, 0x0003e20000200c00ULL, 0x000001004b1c7824ULL, 0x004fe200078e00ffULL,
0x000088804d767816ULL, 0x000fe200000000ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc40000011451ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000006e00b57306ULL, 0x0005e20000200c00ULL, 0x000001004c1d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c007f7306ULL, 0x0003e20000200c00ULL, 0x000100004e6e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001144cULL, 0x00000018ff627819ULL, 0x000fe40000011450ULL,
0x00000018ff667819ULL, 0x010fe40000011454ULL, 0x0000001d00787306ULL, 0x0005e20000200c00ULL,
0x000001004d1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011457ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011455ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x000000b400b47306ULL, 0x000e620000200c00ULL,
0x000001004e1d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ff717819ULL, 0x000fe4000001141dULL,
0x0000001c00797306ULL, 0x0005e20000200c00ULL, 0x00000018ff647819ULL, 0x000fe40000011456ULL,
0x00000018ff6f7819ULL, 0x000fc4000001146fULL, 0x00000018ff5d7819ULL, 0x000fe40000011458ULL,
0x00000018ff197819ULL, 0x000fe2000001145aULL, 0x000000b100b17306ULL, 0x000ee20000200c00ULL,
0x000004001a1c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe40000011459ULL,
0x00000018ff177819ULL, 0x000fe4000001145bULL, 0xfffff8001c1d7812ULL, 0x000fe200078ec0ffULL,
0x000001004f1c7824ULL, 0x000fe200078e00ffULL, 0x000000b000b07306ULL, 0x000ea40000200c00ULL,
0x000120001d1d7810ULL, 0x000fc40007ffe016ULL, 0x00000018ff737819ULL, 0x000fe4000001141cULL,
0x00000015ff16723eULL, 0x000fe400000000ffULL, 0x000000001d1c783bULL, 0x000fe20000000200ULL,
0x000000af00af7306ULL, 0x000fe20000200c00ULL, 0x0000541016207816ULL, 0x000fe20000000016ULL,
0x0000010050167824ULL, 0x000fc800078e00ffULL, 0x00001f6920697589ULL, 0x000f2400000e0000ULL,
0x000000ac00ac7306ULL, 0x000fe40000200c00ULL, 0x00001f21204e7589ULL, 0x0002ac00000e0000ULL,
0x000000a600a67306ULL, 0x000ea20000200c00ULL, 0x00005410b7207816ULL, 0x002fc400000000b6ULL,
0x00005410b4217816ULL, 0x000fca00000000b5ULL, 0x000000a400a47306ULL, 0x000e700000200c00ULL,
0x00000022009a7306ULL, 0x0003e20000200c00ULL, 0x000000691c1c8232ULL, 0x010fce0000000000ULL,
0x0000004a007d7306ULL, 0x0009e20000200c00ULL, 0x000000691e1e8232ULL, 0x000fe20000000000ULL,
0x0000888052227816ULL, 0x002fe200000000ffULL, 0x0000004e1d1d8232ULL, 0x084fe40000000000ULL,
0x0000004e1f1f8232ULL, 0x000fc60000000000ULL, 0x000000aa00aa7306ULL, 0x000e620000200c00ULL,
0x000000ffff4a7224ULL, 0x010fe400078e0022ULL, 0x0000010052227824ULL, 0x040fe200078e00ffULL,
0x000000201c40723cULL, 0x000fe20000001840ULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x000000a500a57306ULL, 0x000ea20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fe20000011422ULL,
0x0000080009227824ULL, 0x000fe200078e0218ULL, 0x00005410b2207816ULL, 0x008fe400000000b1ULL,
0x00005410b3217816ULL, 0x000fe400000000b0ULL, 0x0000888053187816ULL, 0x000fe200000000ffULL,
0x0000002400947306ULL, 0x0007e80000200c00ULL, 0x000000201c38723cULL, 0x000fe80000001838ULL,
0x0000002500957306ULL, 0x0009e20000200c00ULL, 0x00005410ab247816ULL, 0x008fc400000000a6ULL,
0x00005410af207816ULL, 0x000fe400000000aeULL, 0x00005410ac217816ULL, 0x000fc600000000adULL,
0x00000023009b7306ULL, 0x0007e20000200c00ULL, 0x00005410a9257816ULL, 0x010fc600000000a4ULL,
0x000000201c34723cULL, 0x040fe80000001834ULL, 0x0000009d009d7306ULL, 0x000fe20000200c00ULL,
0x012000002220783bULL, 0x008ee60000000200ULL, 0x000000241c28723cULL, 0x000fe80000001828ULL,
0x0000009c009c7306ULL, 0x000f260000200c00ULL, 0x00005410aa247816ULL, 0x002fc400000000a7ULL,
0x00005410a5257816ULL, 0x004fc600000000a8ULL, 0x000000a100a17306ULL, 0x000e680000200c00ULL,
0x000000241c2c723cULL, 0x000fe8000000182cULL, 0x0000009e009e7306ULL, 0x000ea60000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011452ULL, 0x00005410a3257816ULL, 0x010fe4000000009cULL,
0x0000888054527816ULL, 0x000fe200000000ffULL, 0x00000026008a7306ULL, 0x0009f00000200c00ULL,
0x00000027008b7306ULL, 0x0003e20000200c00ULL, 0x0000010053267824ULL, 0x010fe200078e00ffULL,
0x0000006920208232ULL, 0x008fc40000000000ULL, 0x0000006922228232ULL, 0x000fe40000000000ULL,
0x0000004e21218232ULL, 0x080fe20000000000ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000009300937306ULL, 0x000ee20000200c00ULL, 0x0001000053277824ULL, 0x002fe200078e00ffULL,
0x0000004e23238232ULL, 0x000fc80000000000ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002400537306ULL, 0x0003f00000200c00ULL, 0x0000009200927306ULL, 0x000f220000200c00ULL,
0x00005410a2247816ULL, 0x002fce000000009dULL, 0x000000241c30723cULL, 0x000fe20000001830ULL,
0x0000009900997306ULL, 0x000e6c0000200c00ULL, 0x00005410a1247816ULL, 0x000fe400000000a0ULL,
0x0000009600967306ULL, 0x000e620000200c00ULL, 0x000054109e257816ULL, 0x004fce000000009fULL,
0x000000241c3c723cULL, 0x000fe2000000183cULL, 0x0000008d008d7306ULL, 0x000eac0000200c00ULL,
0x000054109a247816ULL, 0x008fe40000000093ULL, 0x0000008c008c7306ULL, 0x000ee20000200c00ULL,
0x000054109b257816ULL, 0x010fc40000000092ULL, 0x0000888055927816ULL, 0x000fca00000000ffULL,
0x000000241c1c723cULL, 0x000fe20000001844ULL, 0x0000009100917306ULL, 0x000f2c0000200c00ULL,
0x0000541099247816ULL, 0x002fe20000000098ULL, 0x0000080009447824ULL, 0x000fe200078e020eULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x0000541096257816ULL, 0x000fe20000000097ULL,
0x0000010056467824ULL, 0x000fe200078e00ffULL, 0x0000888057477816ULL, 0x000fc800000000ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000004800857306ULL, 0x0003e20000200c00ULL,
0x000000242040723cULL, 0x000fee0000001840ULL, 0x0000004b007c7306ULL, 0x0009e20000200c00ULL,
0x00000018ff487819ULL, 0x002fc40000011416ULL, 0x0000888051167816ULL, 0x000fe400000000ffULL,
0x0000541094247816ULL, 0x004fe4000000008dULL, 0x0000541095257816ULL, 0x008fe2000000008cULL,
0x0000004c00747306ULL, 0x0003e20000200c00ULL, 0x00000100514b7824ULL, 0x010fca00078e00ffULL,
0x000000242038723cULL, 0x000fe20000001838ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x00010000514c7824ULL, 0x002fc800078e00ffULL,
0x0000541091247816ULL, 0x000fe40000000090ULL, 0x000054108e257816ULL, 0x000fe2000000008fULL,
0x0000002600517306ULL, 0x0003e20000200c00ULL, 0x00000018ff4c7819ULL, 0x000fca000001144cULL,
0x000000242034723cULL, 0x000fe40000001834ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x0000010054267824ULL, 0x042fe400078e00ffULL, 0x0001000054547824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000004900847306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x0000004d00757306ULL, 0x0007e20000200c00ULL,
0x0000888050497816ULL, 0x002fe400000000ffULL, 0x000054108b457816ULL, 0x004fca0000000082ULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x00010000504d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000002700507306ULL, 0x0005f00000200c00ULL,
0x0000008600867306ULL, 0x000ee20000200c00ULL, 0x0000010055277824ULL, 0x004fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002600937306ULL, 0x0005f00000200c00ULL,
0x0000002700977306ULL, 0x0009e20000200c00ULL, 0x0001000055267824ULL, 0x004fca00078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe40000011426ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x012000004424783bULL, 0x0108ae0000000200ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000054108a447816ULL, 0x010fce0000000083ULL, 0x000000442028723cULL, 0x000fe20000001828ULL,
0x0000008100817306ULL, 0x000fec0000200c00ULL, 0x0000541089447816ULL, 0x002fe40000000088ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000541086457816ULL, 0x008fce0000000087ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x00000044202c723cULL, 0x040fee000000182cULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x0000541085447816ULL, 0x004fe2000000007aULL,
0x0000006924248232ULL, 0x080fe20000000000ULL, 0x0000541084457816ULL, 0x000fe20000000077ULL,
0x000000ffff777224ULL, 0x000fe200078e0047ULL, 0x0000006926268232ULL, 0x000fe20000000000ULL,
0x0000010057477824ULL, 0x000fe200078e00ffULL, 0x0000004e25258232ULL, 0x080fe20000000000ULL,
0x000054107d6c7816ULL, 0x002fe2000000006cULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x000000442030723cULL, 0x000fe20000001830ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004e27278232ULL, 0x000fe20000000000ULL,
0x000054107c6d7816ULL, 0x008fc6000000006dULL, 0x0000541081447816ULL, 0x000fe40000000080ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054107e457816ULL, 0x000fe2000000007fULL,
0x0000006c201c723cULL, 0x040fec000000181cULL, 0x0000005400557306ULL, 0x0007e40000200c00ULL,
0x00000044203c723cULL, 0x000fec000000183cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0000888056547816ULL, 0x048fe200000000ffULL, 0x0001000056447824ULL, 0x000fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe20000011457ULL, 0x0000010059577824ULL, 0x000fe200078e00ffULL,
0x000054107b207816ULL, 0x002fc40000000078ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541076217816ULL, 0x004fe40000000079ULL,
0x0000888058457816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fc60000011457ULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x000000202440723cULL, 0x000fee0000001840ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000ffff207224ULL, 0x000fe200078e0045ULL,
0x000054106e6e7816ULL, 0x002fe20000000067ULL, 0x0000010058217824ULL, 0x000fc400078e00ffULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x0000000e000e7306ULL, 0x000e620000200c00ULL,
0x0000541055667816ULL, 0x004fe40000000066ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000006b006b7306ULL, 0x000eb00000200c00ULL, 0x0000006a006a7306ULL, 0x000ee20000200c00ULL,
0x000054100e677816ULL, 0x002fce0000000065ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541074747816ULL, 0x004fe2000000006bULL, 0x000000662430723cULL, 0x000fec0000001830ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541075757816ULL, 0x008fce000000006aULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000742438723cULL, 0x000fee0000001838ULL,
0x0000007200727306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541072727816ULL, 0x002fce0000000071ULL, 0x0000006f006f7306ULL, 0x000e700000200c00ULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x0000541070737816ULL, 0x004fce0000000073ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054106f6f7816ULL, 0x002fe20000000068ULL,
0x000000722434723cULL, 0x040fec0000001834ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541052967816ULL, 0x008fe20000000093ULL, 0x0000006e2428723cULL, 0x000fe20000001828ULL,
0x00000018ff527819ULL, 0x000fca0000011458ULL, 0x0000004600837306ULL, 0x000e620000200c00ULL,
0x0000541092977816ULL, 0x004fce0000000097ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000096242c723cULL, 0x000fee000000182cULL, 0x0000004700567306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x002fce0000000083ULL, 0x0000004400237306ULL, 0x0002f00000200c00ULL,
0x0000002200227306ULL, 0x000f220000200c00ULL, 0x0000080009447824ULL, 0x002fe200078e0210ULL,
0x0000541077557816ULL, 0x004fc40000000056ULL, 0x000088805a567816ULL, 0x000fc600000000ffULL,
0x012000004444783bULL, 0x000e620000000200ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541023647816ULL, 0x008fe20000000064ULL, 0x00000054243c723cULL, 0x000fe2000000183cULL,
0x000001005a237824ULL, 0x040fe400078e00ffULL, 0x000100005a5a7824ULL, 0x000fc600078e00ffULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x0000541022657816ULL, 0x010fe20000000063ULL,
0x000000ffff227224ULL, 0x000fe200078e0056ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x00000018ff5a7819ULL, 0x000fc6000001145aULL, 0x0000001600167306ULL, 0x000fe20000200c00ULL,
0x00000064241c723cULL, 0x000fee000000181cULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x000088805b247816ULL, 0x000fe400000000ffULL, 0x0000541049487816ULL, 0x004fca0000000048ULL,
0x0000001800187306ULL, 0x000ea20000200c00ULL, 0x0000006944448232ULL, 0x002fce0000000000ULL,
0x0000002000107306ULL, 0x0003e20000200c00ULL, 0x0000541016497816ULL, 0x008fe2000000004bULL,
0x000000ffff167224ULL, 0x000fe200078e0024ULL, 0x0000006946468232ULL, 0x000fe20000000000ULL,
0x000001005b247824ULL, 0x040fe200078e00ffULL, 0x0000004e45458232ULL, 0x080fe20000000000ULL,
0x000100005b5b7824ULL, 0x000fe200078e00ffULL, 0x0000004e47478232ULL, 0x000fe20000000000ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000888059207816ULL, 0x042fe200000000ffULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x000000484440723cULL, 0x000fe20000001840ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x00005410184b7816ULL, 0x004fce0000000051ULL, 0x0000004c004c7306ULL, 0x000eb00000200c00ULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x0000541053607816ULL, 0x002fce0000000060ULL,
0x0000002300237306ULL, 0x000e620000200c00ULL, 0x000054104c637816ULL, 0x004fce0000000061ULL,
0x0000006200627306ULL, 0x000ff00000200c00ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x0000541022227816ULL, 0x002fce0000000023ULL, 0x0000005d005d7306ULL, 0x000ff00000200c00ULL,
0x0000001b001b7306ULL, 0x000fe20000200c00ULL, 0x0000541050617816ULL, 0x004fce000000005fULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000604428723cULL, 0x000fee0000001828ULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000054104d627816ULL, 0x002fce0000000062ULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x000000624438723cULL, 0x000fee0000001838ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000054104a4a7816ULL, 0x004fce000000004fULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x0000541010567816ULL, 0x002fe20000000021ULL, 0x0000004a4434723cULL, 0x000fe20000001834ULL,
0x0001b66809107811ULL, 0x000fca00078e18ffULL, 0x0000005200527306ULL, 0x000e700000200c00ULL,
0x00000059000e7306ULL, 0x000ee20000200c00ULL, 0x0000541020577816ULL, 0x004fce0000000057ULL,
0x0000001600167306ULL, 0x000fe20000200c00ULL, 0x0000541052527816ULL, 0x002fe2000000005dULL,
0x00000056442c723cULL, 0x000fec000000182cULL, 0x0000002400257306ULL, 0x000e620000200c00ULL,
0x000054100e537816ULL, 0x008fe4000000001bULL, 0x0001b630090e7811ULL, 0x000fca00078e20ffULL,
0x0000001900197306ULL, 0x000fe20000200c00ULL, 0x000000524430723cULL, 0x000fee0000001830ULL,
0x0000001700177306ULL, 0x000fe20000200c00ULL, 0x0000541016237816ULL, 0x002fce0000000025ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x00000022443c723cULL, 0x000fee000000183cULL,
0x0000005b00187306ULL, 0x0004e20000200c00ULL, 0x000054105a167816ULL, 0x002fe40000000019ULL,
0x00000001115b7812ULL, 0x004fc4000782c0ffULL, 0x0000541018177816ULL, 0x008fce0000000017ULL,
0x000000164444723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000010ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000eff7f8cULL, 0x0005e2000c80043fULL,
0x000000011100780cULL, 0x000fc80003f05270ULL, 0x000000135e137207ULL, 0x000fe40004000000ULL,
0x000000ff14ff7812ULL, 0x000fe4000780c0ffULL, 0x000000ff13ff7812ULL, 0x000fe4000784c0ffULL,
0x00000001ff5a7807ULL, 0x000fe40004000000ULL, 0x00000001ff139807ULL, 0x000fc80001000000ULL,
0x0000761013587816ULL, 0x000fe40000000058ULL, 0x000003005c5c7a10ULL, 0x004fe40007ffe0ffULL,
0x000000ff0fff7812ULL, 0x000fe4000780c0ffULL, 0x000000035c00720cULL, 0x000fe40003f26070ULL,
0x00000001ff0f7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff9b0000007947ULL, 0x000fea000383ffffULL, 0x00000000000a7919ULL, 0x004ea20000000000ULL,
0x0000000209007824ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ee40000002500ULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x0000000200057812ULL, 0x000fe200078e0cffULL,
0x000000801a007824ULL, 0x000fc600078e00ffULL, 0x0000000105057812ULL, 0x000fe200078ef81aULL,
0x000000100a027824ULL, 0x004fe200078e00ffULL, 0x00000001ff047819ULL, 0x100fe4000001160aULL,
0x00000002ff0e7819ULL, 0x000fe4000001160aULL, 0x00000070020f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c04117812ULL, 0x000fe200078ec0ffULL, 0x0000008005047824ULL, 0x000fe200078e00ffULL,
0x0001b0000f027810ULL, 0x000fc40007ffe000ULL, 0x0001b2000f007810ULL, 0x040fe40007ffe000ULL,
0x0001b0000f067810ULL, 0x020fe20007ffe004ULL, 0x0000000111057824ULL, 0x000fe200078e0202ULL,
0x0001b2000f047810ULL, 0x000fe20007ffe004ULL, 0x0000000111027824ULL, 0x000fe200078e0200ULL,
0x0000000403007c0cULL, 0x008fe2000bf03070ULL, 0x0000000111067824ULL, 0x040fe200078e0206ULL,
0x0000000c05007388ULL, 0x000fe20000000800ULL, 0x0000000111047824ULL, 0x000fc600078e0204ULL,
0x0000000d02007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000006067984ULL, 0x000ea80000000800ULL, 0x0000000004047984ULL, 0x000ee20000000800ULL,
0x0000000c060b7209ULL, 0x004fca0007810000ULL, 0x0000000c0b007221ULL, 0x000fe40000010100ULL,
0x8000000b06067221ULL, 0x000fe40000010000ULL, 0x3fb8aa3b00077820ULL, 0x000fe40000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x3fb8aa3b06067820ULL, 0x000fc60000410000ULL,
0x0000000700077308ULL, 0x000f300000000800ULL, 0x0000000600037308ULL, 0x000ee20000000800ULL,
0x00001f0e07057589ULL, 0x010f2200000e0000ULL, 0x00000008000a7811ULL, 0x004fe200078ff0ffULL,
0x0000000304047220ULL, 0x008fc80000410000ULL, 0x00001f0a07027589ULL, 0x000ea200000e0000ULL,
0x0000000d070d7223ULL, 0x000fe40000010004ULL, 0x0000004005407220ULL, 0x050fe40000410000ULL,
0x0000004105417220ULL, 0x040fe40000410000ULL, 0x0000003805387220ULL, 0x040fe40000410000ULL,
0x0000003905397220ULL, 0x040fe40000410000ULL, 0x0000003405347220ULL, 0x000fc40000410000ULL,
0x0000003505357220ULL, 0x040fe40000410000ULL, 0x0000002805287220ULL, 0x040fe40000410000ULL,
0x0000002905297220ULL, 0x040fe40000410000ULL, 0x0000002c052c7220ULL, 0x040fe40000410000ULL,
0x0000002d052d7220ULL, 0x040fe40000410000ULL, 0x0000003005307220ULL, 0x000fc40000410000ULL,
0x0000003105317220ULL, 0x040fe40000410000ULL, 0x0000003c053c7220ULL, 0x040fe40000410000ULL,
0x0000003d053d7220ULL, 0x040fe40000410000ULL, 0x0000004405447220ULL, 0x040fe40000410000ULL,
0x0000004505457220ULL, 0x000fe40000410000ULL, 0x0000004202427220ULL, 0x004fc40000410000ULL,
0x0000004302437220ULL, 0x040fe40000410000ULL, 0x0000003a023a7220ULL, 0x040fe40000410000ULL,
0x0000003b023b7220ULL, 0x040fe40000410000ULL, 0x0000003602367220ULL, 0x040fe40000410000ULL,
0x0000003702377220ULL, 0x040fe40000410000ULL, 0x0000002a022a7220ULL, 0x000fc40000410000ULL,
0x0000002b022b7220ULL, 0x040fe40000410000ULL, 0x0000002e022e7220ULL, 0x040fe40000410000ULL,
0x0000002f022f7220ULL, 0x040fe40000410000ULL, 0x0000003202327220ULL, 0x040fe40000410000ULL,
0x0000003302337220ULL, 0x040fe40000410000ULL, 0x0000003e023e7220ULL, 0x000fc40000410000ULL,
0x0000003f023f7220ULL, 0x040fe40000410000ULL, 0x0000004602467220ULL, 0x040fe40000410000ULL,
0x0000004702477220ULL, 0x000fe20000410000ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000000d007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e000dULL,
0x00007c8000067802ULL, 0x000fe40000000f00ULL, 0x0000a5d000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x008fe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000d00047308ULL, 0x000ea40000001000ULL, 0xbf8000000d007423ULL, 0x004fc80000000004ULL,
0x800000ff00037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000002ff0c7819ULL, 0x008fe40000011600ULL,
0x00000008000a7811ULL, 0x000fe200078ff0ffULL, 0x0000000403057220ULL, 0x004fca0000410000ULL,
0x00001f0c05047589ULL, 0x000ea800000e0000ULL, 0x00001f0a05067589ULL, 0x000ee200000e0000ULL,
0x0000000440407220ULL, 0x084fe40000410000ULL, 0x0000000441417220ULL, 0x080fe40000410000ULL,
0x0000000438387220ULL, 0x080fe40000410000ULL, 0x0000000439397220ULL, 0x000fc40000410000ULL,
0x0000000434347220ULL, 0x080fe40000410000ULL, 0x0000000435357220ULL, 0x080fe40000410000ULL,
0x0000000428287220ULL, 0x080fe40000410000ULL, 0x0000000429297220ULL, 0x080fe40000410000ULL,
0x000000042c2c7220ULL, 0x080fe40000410000ULL, 0x000000042d2d7220ULL, 0x000fc40000410000ULL,
0x0000000430307220ULL, 0x080fe40000410000ULL, 0x0000000431317220ULL, 0x080fe40000410000ULL,
0x000000043c3c7220ULL, 0x080fe40000410000ULL, 0x000000043d3d7220ULL, 0x080fe40000410000ULL,
0x0000000444447220ULL, 0x080fe40000410000ULL, 0x0000000445457220ULL, 0x000fc40000410000ULL,
0x0000000642427220ULL, 0x088fe40000410000ULL, 0x0000000643437220ULL, 0x080fe40000410000ULL,
0x000000063a3a7220ULL, 0x080fe40000410000ULL, 0x000000063b3b7220ULL, 0x080fe40000410000ULL,
0x0000000636367220ULL, 0x080fe40000410000ULL, 0x0000000637377220ULL, 0x000fc40000410000ULL,
0x000000062a2a7220ULL, 0x080fe40000410000ULL, 0x000000062b2b7220ULL, 0x080fe40000410000ULL,
0x000000062e2e7220ULL, 0x080fe40000410000ULL, 0x000000062f2f7220ULL, 0x080fe40000410000ULL,
0x0000000632327220ULL, 0x080fe40000410000ULL, 0x0000000633337220ULL, 0x000fc40000410000ULL,
0x000000063e3e7220ULL, 0x080fe40000410000ULL, 0x000000063f3f7220ULL, 0x080fe40000410000ULL,
0x0000000646467220ULL, 0x080fe40000410000ULL, 0x0000000647477220ULL, 0x000fe40000410000ULL,
0x0000000200027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff107819ULL, 0x102fe20000011600ULL, 0x0000002009137824ULL, 0x000fe200078e0200ULL,
0x00000001ff037819ULL, 0x000fc40000011602ULL, 0x0000000202057811ULL, 0x040fe400078ff8ffULL,
0x0000000402077811ULL, 0x040fe400078ff8ffULL, 0x00000006020f7811ULL, 0x000fe400078ff8ffULL,
0x0000000703027812ULL, 0x100fe400078e7810ULL, 0x0000000705067812ULL, 0x040fe400078e7810ULL,
0x0000000705057812ULL, 0x000fe200078e780aULL, 0x0000000810047824ULL, 0x000fe200078e0202ULL,
0x00000007070c7812ULL, 0x100fe200078e7810ULL, 0x0000100008027824ULL, 0x000fe200078e00ffULL,
0x000000070f0e7812ULL, 0x000fe200078e7810ULL, 0x000000080a127824ULL, 0x000fe200078e0205ULL,
0x0000000703037812ULL, 0x000fe200078e780aULL, 0x0000000810067824ULL, 0x040fe200078e0206ULL,
0x0000000707077812ULL, 0x000fe200078e780aULL, 0x00000008100c7824ULL, 0x040fe200078e020cULL,
0x000000070f0f7812ULL, 0x000fe200078e780aULL, 0x00000008100e7824ULL, 0x000fe200078e020eULL,
0x000000404140723eULL, 0x000fe200000000ffULL, 0x0000000800057824ULL, 0x000fe200078e00ffULL,
0x000000383920723eULL, 0x000fe200000000ffULL, 0x000000080a107824ULL, 0x040fe200078e0203ULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x0000080009037824ULL, 0x000fe200078e0202ULL,
0x0000000805057812ULL, 0x000fe200078ec0ffULL, 0x000000080a147824ULL, 0x000fe200078e0207ULL,
0x0000541040187816ULL, 0x100fe20000000020ULL, 0x0000001004047824ULL, 0x000fe200078e0203ULL,
0x0000763240197816ULL, 0x000fe20000000020ULL, 0x000000080a0a7824ULL, 0x000fe200078e020fULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x000000303116723eULL, 0x000fe200000000ffULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0000001804007388ULL, 0x0003e20000000a00ULL, 0x0000001010107824ULL, 0x100fe200078e0203ULL,
0x0000003c3d3c723eULL, 0x000fe200000000ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0203ULL,
0x00000044451e723eULL, 0x000fe200000000ffULL, 0x0000001012127824ULL, 0x100fe200078e0203ULL,
0x000000424342723eULL, 0x000fe200000000ffULL, 0x0000001014147824ULL, 0x100fe200078e0203ULL,
0x0000003a3b21723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x0000000105067824ULL, 0x040fe200078e0206ULL,
0x0000541034047816ULL, 0x002fe20000000028ULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x0000002a2b1b723eULL, 0x000fe200000000ffULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x0000541042207816ULL, 0x140fe20000000021ULL, 0x00000001050e7824ULL, 0x040fe200078e020eULL,
0x0000763242217816ULL, 0x000fe20000000021ULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x0000002e2f2e723eULL, 0x000fe200000000ffULL, 0x0000000105147824ULL, 0x000fe200078e0214ULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x0000763234057816ULL, 0x000fe20000000028ULL, 0x0000001013077824ULL, 0x000fe200078e0202ULL,
0x0000003e3f3e723eULL, 0x000fc400000000ffULL, 0x00000046471f723eULL, 0x000fe200000000ffULL,
0x0000000406007388ULL, 0x0003e40000000a00ULL, 0x000054102c047816ULL, 0x142fe40000000016ULL,
0x000076322c057816ULL, 0x000fe40000000016ULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x000000040c007388ULL, 0x0003e40000000a00ULL,
0x000054103c047816ULL, 0x002fc4000000001eULL, 0x000076323c057816ULL, 0x000fca000000001eULL,
0x000000040e007388ULL, 0x0003e80000000a00ULL, 0x0000002010007388ULL, 0x000fe20000000a00ULL,
0x0000541036047816ULL, 0x142fe4000000001bULL, 0x0000763236057816ULL, 0x000fca000000001bULL,
0x0000000412007388ULL, 0x0003e80000000a00ULL, 0x0000001614007388ULL, 0x0005e20000000a00ULL,
0x000054103e047816ULL, 0x142fe4000000001fULL, 0x000076323e057816ULL, 0x000fe2000000001fULL,
0x00000300ff167624ULL, 0x004fc800078e00ffULL, 0x000000040a007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000011600780cULL, 0x000fca0003f05270ULL,
0x00000000071c7984ULL, 0x000e680000000c00ULL, 0x0004000007247984ULL, 0x000ea80000000c00ULL,
0x0008000007207984ULL, 0x000ee80000000c00ULL, 0x000c000007287984ULL, 0x000f220000000c00ULL,
0x200000ff1f1f7230ULL, 0x002fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x004fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x008fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x010fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001c07007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002407007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000303000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x000ea20000002700ULL, 0x0000580016047a24ULL, 0x000fe200078e02ffULL,
0x0000000109ff7812ULL, 0x000fe2000780f81aULL, 0x00001000ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x00006600040a7a24ULL, 0x000fe200078e02ffULL,
0x0000004013157810ULL, 0x000fe20007ffe0ffULL, 0x0000080008067824ULL, 0x000fe200078e00ffULL,
0x00000000071c7984ULL, 0x002e680000000c00ULL, 0x0004000007207984ULL, 0x0007240000000c00ULL,
0x01ffffff0a077812ULL, 0x008fe200078ec0ffULL, 0x000058000c0c7a24ULL, 0x004fe200078e0205ULL,
0x00000fff0a057811ULL, 0x000fc600078e40ffULL, 0x000003000c047a24ULL, 0x000fca00078e02ffULL,
0x0000000404107c10ULL, 0x000fc8000fffe0ffULL, 0x00000010050e7211ULL, 0x000fca00078fa0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e000fULL, 0x000000060e0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x0000001013127825ULL, 0x000fc800078e000eULL, 0x0000001015147825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x012fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011600ULL, 0x00000080ff0a7424ULL, 0x000fe400078e00ffULL,
0x0000000110117824ULL, 0x000fe200078e0207ULL, 0x000000700e177812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f187812ULL, 0x000fe200078ec0ffULL, 0x00006c00100e7625ULL, 0x000fc800078e000aULL,
0x00006c0011107625ULL, 0x000fe200078e000aULL, 0x0000000e180e7210ULL, 0x000fc80007a1e017ULL,
0x0000001018107210ULL, 0x000fe40007c7e017ULL, 0x0000000fff0f7210ULL, 0x000fe400007e44ffULL,
0x00000011ff117210ULL, 0x000fc60001fe84ffULL, 0x0000000b0e007986ULL, 0x0003e8000c101908ULL,
0x0000000d10007986ULL, 0x0003e4000c101908ULL, 0x0000001c12007986ULL, 0x0123e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000002014007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff160d7810ULL, 0x000fc60007ffe0ffULL,
0x00006a000c0a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ea400099ee1c8ULL,
0x0000000d0a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0a7984ULL, 0x000ee40000000000ULL, 0x000000ff0a00720cULL, 0x008fda0003f05270ULL,
0x00002c6000008947ULL, 0x000fea0003800000ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001040c7810ULL, 0x004fe40007ffe0ffULL, 0x000000700a197812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b107812ULL, 0x000fe200078ec0ffULL, 0x00006c00040a7625ULL, 0x000fc800078e000fULL,
0x00006c000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000a100a7210ULL, 0x000fc8000791e019ULL,
0x0000000c100c7210ULL, 0x000fe40007b5e019ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000080a0a7981ULL, 0x000568000c1e1900ULL,
0x000000080c117981ULL, 0x000562000c1e1900ULL, 0x000000021600780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040c7810ULL, 0x004fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c0b7981ULL, 0x000562000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040c7810ULL, 0x004fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c137981ULL, 0x002362000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c157981ULL, 0x000362000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c177981ULL, 0x000362000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081600780cULL, 0x002fe40003f06070ULL,
0x00000006040c7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fe40007a3e019ULL, 0x00000007040e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fca00078e000fULL,
0x0000000e100e0210ULL, 0x000fe40007c7e019ULL, 0x000000080c197981ULL, 0x000364000c1e1900ULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000080e1b0981ULL, 0x000368000c1e1900ULL,
0x00000007160c7810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff0e7819ULL, 0x000fc8000001160cULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x020fe400078e000aULL,
0x000000080f107824ULL, 0x040fe200078e00ffULL, 0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000000e0f00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008100d7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x00000070121d7812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e01dULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c1d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000002100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x000000110a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c117981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000000b0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e00bULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c0b7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000004100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x000000130a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c137981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x000000150a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012157812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e015ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c157981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000006100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x000000170a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012177812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012197812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e019ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f100d7810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x000003000d007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007a3e01bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000080c1b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x00000010000b7824ULL, 0x024fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x002fc80000011600ULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fca00078ec0ffULL,
0x000000010c0b7824ULL, 0x000fca00078e020bULL, 0x0000000a0b007388ULL, 0x0003e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000000109187824ULL, 0x000fe200078e0204ULL,
0x00000002ff0e7819ULL, 0x000fe2000001161aULL, 0x00000010000b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x004fe20000011600ULL, 0x00001000ff117424ULL, 0x000fe200078e00ffULL,
0x00000018050a7211ULL, 0x000fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000700b0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000c0c107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e0011ULL,
0x000000010e0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000004000117810ULL, 0x040fe20007ffe0ffULL, 0x00000002090c8824ULL, 0x140fe200078e0208ULL,
0x0000006000157810ULL, 0x000fe20007ffe0ffULL, 0x000008000e0e7824ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000001101a7824ULL, 0x000fe200078e020fULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000020c178824ULL, 0x100fe200078e020dULL,
0x000000060a0c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000209108824ULL, 0x040fe200078e0208ULL,
0x000008000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00002000090a7824ULL, 0x040fe200078e0202ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000002101f8824ULL, 0x000fe200078e020dULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060bULL,
0x00000020000b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0f7824ULL, 0x000fe200078e020fULL,
0x0000030009007a0cULL, 0x000fe20003f26070ULL, 0x0000000107128824ULL, 0x000fc400078e0218ULL,
0x00000080ff138424ULL, 0x000fe400078e00ffULL, 0x00000080ff198424ULL, 0x000fe400078e00ffULL,
0x00000010001b7824ULL, 0x000fe400078e020fULL, 0x00006c0012128625ULL, 0x000fc800078e0013ULL,
0x000000100b0e7825ULL, 0x100fe400078e000cULL, 0x000000001a0b7984ULL, 0x0002a40000000800ULL,
0x0000001011107825ULL, 0x000fc800078e000cULL, 0x0000001015147825ULL, 0x000fc800078e000cULL,
0x00006c0018188625ULL, 0x000fc800078e0019ULL, 0x00000008171d8824ULL, 0x000fe400078e0200ULL,
0x00000010000c7825ULL, 0x000fc600078e000cULL, 0x000045801d1d8811ULL, 0x000fe200078e20ffULL,
0x000000081f1f8824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c1b7faeULL, 0x0007e2000b901c48ULL, 0x0000001000168825ULL, 0x040fe400078e0012ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000041801f1f8811ULL, 0x000fe200078e20ffULL,
0x0000001000188825ULL, 0x000fe200078e0018ULL, 0x003800000e1b7faeULL, 0x0009e6000b901c48ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x00580000101b7faeULL, 0x000be2000b901c48ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x00780000141b7faeULL, 0x0007e8000b901c48ULL,
0x00000000161d8faeULL, 0x0005e2000b901c48ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000181f8faeULL, 0x0009e2000b901c48ULL, 0x0000000000107805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x004fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x010fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fca00078e0009ULL, 0x00000002302f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200078e0030ULL, 0x00000002ff2e7819ULL, 0x002fe20000011600ULL,
0x0000000209437824ULL, 0x000fe200078e0208ULL, 0x000003002f007a0cULL, 0x000fe20003f06070ULL,
0x0000004045307824ULL, 0x000fe200078e00ffULL, 0x000000072e487812ULL, 0x040fe200078ec0ffULL,
0x000000082e317824ULL, 0x040fe200078e00ffULL, 0x0000002eff4a7212ULL, 0x000fe200078e33ffULL,
0x000000082e2d7824ULL, 0x000fe200078e00ffULL, 0x0000008030307812ULL, 0x000fe200078ec0ffULL,
0x000000082e337824ULL, 0x008fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff8313c7812ULL, 0x100fe200078ee248ULL, 0x0000001000497824ULL, 0x000fe200078e00ffULL,
0x000000012d3e7812ULL, 0x000fe200078ef648ULL, 0x0000010043437824ULL, 0x000fe200078e0030ULL,
0x000000022d407812ULL, 0x000fc400078ef648ULL, 0x000000032d427812ULL, 0x140fe400078ef648ULL,
0x000000042d447812ULL, 0x140fe400078ef648ULL, 0x000000052d467812ULL, 0x140fe400078ef648ULL,
0x000000062d487812ULL, 0x000fe400078ef648ULL, 0xfffffff8334a7812ULL, 0x000fe400078ee24aULL,
0x000000082e2d7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00000001043a7824ULL, 0x100fe200078e022fULL,
0x00000001ff327819ULL, 0x000fe2000001162fULL, 0x00001000ff317424ULL, 0x000fe200078e00ffULL,
0x0000002000357810ULL, 0x000fc40007ffe0ffULL, 0x0000003a05307211ULL, 0x000fe400078fa0ffULL,
0x0000000132337812ULL, 0x000fe200078ec0ffULL, 0x000004002f327824ULL, 0x000fe200078e00ffULL,
0x0000004000377810ULL, 0x000fe20007ffe0ffULL, 0x00006c0030307625ULL, 0x000fe200078e0031ULL,
0x0000006000417810ULL, 0x000fc60007ffe0ffULL, 0x0000000209349824ULL, 0x140fe200078e0208ULL,
0x0000000630307210ULL, 0x000fe20007f1e0ffULL, 0x0000000209369824ULL, 0x000fe400078e0208ULL,
0x00000002343f9824ULL, 0x100fe400078e0233ULL, 0x0000000236479824ULL, 0x000fe200078e0233ULL,
0x0000080032337812ULL, 0x000fe200078ec0ffULL, 0x000000ffff317224ULL, 0x000fe400000e0631ULL,
0x0000000107389824ULL, 0x000fc400078e023aULL, 0x000000010a337824ULL, 0x000fe400078e0233ULL,
0x00000080ff399424ULL, 0x000fe400078e00ffULL, 0x00000080ff3b9424ULL, 0x000fe400078e00ffULL,
0x00000010003d7824ULL, 0x000fe400078e0233ULL, 0x00006c0038389625ULL, 0x000fc800078e0039ULL,
0x0000001000327825ULL, 0x000fc800078e0030ULL, 0x0000001035347825ULL, 0x100fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000323d7faeULL, 0x0003e6000b901c48ULL,
0x0000001037367825ULL, 0x100fe200078e0030ULL, 0x00380000343d7faeULL, 0x0003e6000b901c48ULL,
0x00006c003a3a9625ULL, 0x000fe200078e003bULL, 0x00580000363d7faeULL, 0x0003e6000b901c48ULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x000000083f3f9824ULL, 0x100fe200078e0200ULL,
0x00780000303d7faeULL, 0x0003e2000b901c48ULL, 0x0000000847419824ULL, 0x000fe400078e0200ULL,
0x0000001000389825ULL, 0x040fe200078e0038ULL, 0x000045803f3f9811ULL, 0x000fe400078e20ffULL,
0x0000418041419811ULL, 0x000fe200078e20ffULL, 0x00000010003a9825ULL, 0x000fe400078e003aULL,
0x00000000383f9faeULL, 0x0003e8000b901c48ULL, 0x000000003a419faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff327819ULL, 0x002fe20000011600ULL, 0x000000082d367824ULL, 0x000fe200078e00ffULL,
0x0000007049507812ULL, 0x000fe200078ec0ffULL, 0x000000082d347824ULL, 0x000fe200078e00ffULL,
0x0000000c32337812ULL, 0x000fe200078ec0ffULL, 0x0000040045307824ULL, 0x000fe200078e00ffULL,
0x000000072d317812ULL, 0x000fc400078ec0ffULL, 0x0000004333437210ULL, 0x000fe20007ffe050ULL,
0x000000082d337824ULL, 0x000fe200078e00ffULL, 0xfffffff836327812ULL, 0x100fe400078ee231ULL,
0x0000000134367812ULL, 0x140fe400078ef631ULL, 0x0000000234387812ULL, 0x140fe400078ef631ULL,
0x00000003343a7812ULL, 0x140fe400078ef631ULL, 0x00000004344c7812ULL, 0x000fc400078ef631ULL,
0x00000005344e7812ULL, 0x140fe400078ef631ULL, 0x0000000634347812ULL, 0x000fe200078ef631ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800043527984ULL, 0x000e620000000800ULL,
0x0000080030317812ULL, 0x000fe200078ec0ffULL, 0x0000000400307824ULL, 0x000fe200078e00ffULL,
0x0000002dff507212ULL, 0x000fe200078e33ffULL, 0x0045800043437984ULL, 0x000fe20000000800ULL,
0x000001800a317810ULL, 0x000fe40007ffe031ULL, 0xfffffff833507812ULL, 0x000fe400078ee250ULL,
0x0000000c30337812ULL, 0x000fe200078ec0ffULL, 0x000000103c3c7824ULL, 0x000fc400078e0231ULL,
0x0000001042427824ULL, 0x100fe400078e0231ULL, 0x0000001044447824ULL, 0x100fe400078e0231ULL,
0x0000001046467824ULL, 0x100fe400078e0231ULL, 0x0000001048487824ULL, 0x100fe400078e0231ULL,
0x0000001036367824ULL, 0x100fe400078e0231ULL, 0x0000001038387824ULL, 0x000fc400078e0231ULL,
0x000000103a3a7824ULL, 0x100fe400078e0231ULL, 0x000000104c4c7824ULL, 0x100fe400078e0231ULL,
0x000000104e4e7824ULL, 0x100fe400078e0231ULL, 0x0000001034347824ULL, 0x100fe400078e0231ULL,
0x000000104a4a7824ULL, 0x100fe400078e0231ULL, 0x0000001050507824ULL, 0x000fc400078e0231ULL,
0x000000103e3e7824ULL, 0x100fe400078e0231ULL, 0x0000001040407824ULL, 0x100fe400078e0231ULL,
0x0000001032327824ULL, 0x000fe400078e0231ULL, 0x000000013c3c7824ULL, 0x000fe400078e0233ULL,
0x0000000133427824ULL, 0x040fe400078e0242ULL, 0x0000000133447824ULL, 0x000fc400078e0244ULL,
0x0000000133467824ULL, 0x040fe200078e0246ULL, 0x000000003c3c7984ULL, 0x000ea20000000800ULL,
0x0000000133487824ULL, 0x040fe400078e0248ULL, 0x00000001334a7824ULL, 0x040fe200078e024aULL,
0x0000000042427984ULL, 0x000ee20000000800ULL, 0x0000000133367824ULL, 0x040fe400078e0236ULL,
0x0000000133387824ULL, 0x040fe200078e0238ULL, 0x0000000044447984ULL, 0x000f220000000800ULL,
0x00000001333a7824ULL, 0x000fc400078e023aULL, 0x00000001334c7824ULL, 0x040fe200078e024cULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x00000001334e7824ULL, 0x040fe400078e024eULL,
0x0000000133347824ULL, 0x040fe200078e0234ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x0000000133507824ULL, 0x040fe400078e0250ULL, 0x00000001333e7824ULL, 0x040fe200078e023eULL,
0x000000004a4a7984ULL, 0x000f620000000800ULL, 0x0000000133407824ULL, 0x000fc400078e0240ULL,
0x0000000133327824ULL, 0x000fe200078e0232ULL, 0x0000000036367984ULL, 0x000f620000000800ULL,
0x000000520b527221ULL, 0x002fe40000010100ULL, 0x000000ffff307224ULL, 0x000fe200078e002fULL,
0x0000000038387984ULL, 0x000e620000000800ULL, 0x3fb8aa3b52527820ULL, 0x000fc60000410000ULL,
0x000000003a3a7984ULL, 0x000e620000000800ULL, 0x0000030030007a0cULL, 0x000fe40003f06070ULL,
0x0000005200527308ULL, 0x000f220000000800ULL, 0x000000004c4c7984ULL, 0x000e680000000800ULL,
0x000000004e4e7984ULL, 0x000e620000000800ULL, 0x2000003cff547230ULL, 0x104fe40000004100ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000000034347984ULL, 0x000ea20000000800ULL,
0x20000042ff587230ULL, 0x008fc40000004100ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000000050507984ULL, 0x000ee20000000800ULL, 0x20000044ff5a7230ULL, 0x010fe20000004100ULL,
0x0000004352337220ULL, 0x000fe40000410000ULL, 0x000000003e3e7984ULL, 0x000f220000000800ULL,
0x20000046ff5c7230ULL, 0x020fe40000004100ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000040407984ULL, 0x000f620000000800ULL, 0x20000048ff5e7230ULL, 0x000fe20000004100ULL,
0x0000002c332c7221ULL, 0x000fe20000010000ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000000032327984ULL, 0x000f620000000800ULL, 0x2000004aff607230ULL, 0x000fc40000004100ULL,
0x30000048ff487230ULL, 0x000fe40000004100ULL, 0x20000036ff647230ULL, 0x000fe40000004100ULL,
0x3000004aff4a7230ULL, 0x000fe40000004100ULL, 0x20000038ff667230ULL, 0x002fe40000004100ULL,
0x30000036ff367230ULL, 0x000fe40000004100ULL, 0x2000003aff687230ULL, 0x000fc40000004100ULL,
0x30000038ff387230ULL, 0x000fe40000004100ULL, 0x2000004cff6a7230ULL, 0x000fe40000004100ULL,
0x3000003aff3a7230ULL, 0x000fe40000004100ULL, 0x2000004eff6c7230ULL, 0x000fe40000004100ULL,
0x3000004cff4c7230ULL, 0x000fe40000004100ULL, 0x20000034ff6e7230ULL, 0x004fc40000004100ULL,
0x3000004eff4e7230ULL, 0x000fe40000004100ULL, 0x20000050ff707230ULL, 0x008fe40000004100ULL,
0x30000034ff347230ULL, 0x000fe40000004100ULL, 0x2000003eff527230ULL, 0x110fe40000004100ULL,
0x3000003eff357230ULL, 0x000fe40000004100ULL, 0x20000040ff567230ULL, 0x020fc40000004100ULL,
0x30000040ff377230ULL, 0x000fe40000004100ULL, 0x20000032ff627230ULL, 0x100fe40000004100ULL,
0x30000032ff397230ULL, 0x000fe40000004100ULL, 0x30000050ff507230ULL, 0x000fe20000004100ULL,
0x000074827f007947ULL, 0x000fea000b800000ULL, 0x00001f2e33317589ULL, 0x0002a400000e0000ULL,
0x000074d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2d332d7589ULL, 0x00072400000e0000ULL,
0x00000031542b7223ULL, 0x084fe4000001002bULL, 0x000000313c2a7223ULL, 0x080fe4000001002aULL,
0x0000003152277223ULL, 0x000fc40000010027ULL, 0x0000003135267223ULL, 0x080fe40000010026ULL,
0x0000003156237223ULL, 0x080fe40000010023ULL, 0x0000003137227223ULL, 0x080fe40000010022ULL,
0x00000031581f7223ULL, 0x080fe4000001001fULL, 0x00000031421e7223ULL, 0x080fe4000001001eULL,
0x000000315a1b7223ULL, 0x000fc4000001001bULL, 0x00000031441a7223ULL, 0x080fe4000001001aULL,
0x000000315c177223ULL, 0x080fe40000010017ULL, 0x0000003146167223ULL, 0x080fe40000010016ULL,
0x000000315e137223ULL, 0x080fe40000010013ULL, 0x0000003148127223ULL, 0x080fe40000010012ULL,
0x00000031600f7223ULL, 0x000fc4000001000fULL, 0x000000314a0e7223ULL, 0x000fe4000001000eULL,
0x0000002d62297223ULL, 0x090fe40000010029ULL, 0x0000002d39287223ULL, 0x080fe40000010028ULL,
0x0000002d64257223ULL, 0x080fe40000010025ULL, 0x0000002d36247223ULL, 0x080fe40000010024ULL,
0x0000002d66217223ULL, 0x000fc40000010021ULL, 0x0000002d38207223ULL, 0x080fe40000010020ULL,
0x0000002d681d7223ULL, 0x080fe4000001001dULL, 0x0000002d3a1c7223ULL, 0x080fe4000001001cULL,
0x0000002d6a197223ULL, 0x080fe40000010019ULL, 0x0000002d4c187223ULL, 0x080fe40000010018ULL,
0x0000002d6c157223ULL, 0x000fc40000010015ULL, 0x0000002d4e147223ULL, 0x080fe40000010014ULL,
0x0000002d6e117223ULL, 0x080fe40000010011ULL, 0x0000002d34107223ULL, 0x080fe40000010010ULL,
0x0000002d700d7223ULL, 0x080fe4000001000dULL, 0x0000002d500c7223ULL, 0x000fe2000001000cULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x0000001000047824ULL, 0x004fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c00057812ULL, 0x000fca00078ec0ffULL,
0x0000000105067824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000047824ULL, 0x004fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c00057812ULL, 0x000fc600078ec0ffULL, 0x0000008009047824ULL, 0x000fc800078e0204ULL,
0x0000000104057824ULL, 0x000fca00078e0205ULL, 0x0049802c05007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800006007984ULL, 0x000f280000000800ULL,
0x004a000006057984ULL, 0x004ea20000000800ULL, 0x00000000ff007221ULL, 0x010fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0000ULL, 0x0000abf000067802ULL, 0x000fe40000000f00ULL,
0x0000766000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff047224ULL, 0x008fe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000ea40000001000ULL,
0xbf80000000047423ULL, 0x004fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff077819ULL, 0x004fe40000011600ULL, 0x0000000800407811ULL, 0x002fc600078ff0ffULL,
0x00001f0704057589ULL, 0x000e6200000e0000ULL, 0x00000040ff427212ULL, 0x000fe200078e33ffULL,
0x00000008400b7824ULL, 0x000fe400078e00ffULL, 0x00001f4004067589ULL, 0x00052600000e0000ULL,
0xfffffff80b427812ULL, 0x040fe400078ee242ULL, 0xfffffff80b347812ULL, 0x000fc600078ee240ULL,
0x0000001042427824ULL, 0x100fe200078e0203ULL, 0x00000007ff047212ULL, 0x004fe200078e33ffULL,
0x0000001034347824ULL, 0x000fe400078e0203ULL, 0x0000002b052b7220ULL, 0x042fe40000410000ULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002705277220ULL, 0x040fe40000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000002305237220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000001f051f7220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001705177220ULL, 0x000fc40000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000001305137220ULL, 0x040fe40000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000000f050f7220ULL, 0x040fe40000410000ULL,
0x0000000e050e7220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x0000000807057824ULL, 0x000fc400078e00ffULL, 0x0000001106117220ULL, 0x010fe20000410000ULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0xfffffff805447812ULL, 0x000fe200078ee204ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000000707057812ULL, 0x000fe200078ec0ffULL, 0x0000002806287220ULL, 0x000fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x00000001050a7812ULL, 0x040fe200078e3cffULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x00000003052c7812ULL, 0x040fe200078e3cffULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x00000004052e7812ULL, 0x040fe200078e3cffULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000000505307812ULL, 0x040fe200078e3cffULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000000605327812ULL, 0x000fe200078e3cffULL, 0x0000001c061c7220ULL, 0x000fe20000410000ULL,
0x0000000740117812ULL, 0x000fe200078ec0ffULL, 0x0000001906197220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000001806187220ULL, 0x040fe20000410000ULL,
0x00000003110b7812ULL, 0x040fe200078e3cffULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x00000005110f7812ULL, 0x000fe200078e3cffULL, 0x0000001406147220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000000d060d7220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000000c06067220ULL, 0x000fe20000410000ULL,
0x00000002050c7812ULL, 0x000fe200078e3cffULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x0000000111057812ULL, 0x000fe200078e3cffULL, 0x00000008070a7824ULL, 0x040fe200078e020aULL,
0x0000000d0606723eULL, 0x000fe200000000ffULL, 0x00000008070c7824ULL, 0x040fe200078e020cULL,
0xfffffff804047812ULL, 0x000fe200078ee207ULL, 0x00000008072c7824ULL, 0x000fe200078e022cULL,
0x00000004110d7812ULL, 0x000fe200078e3cffULL, 0x00000008072e7824ULL, 0x040fe200078e022eULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000807307824ULL, 0x040fe200078e0230ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000000807327824ULL, 0x000fe200078e0232ULL,
0x0000000211077812ULL, 0x040fe200078e3cffULL, 0x0000000400137824ULL, 0x000fe200078e00ffULL,
0x0000000611117812ULL, 0x000fe200078e3cffULL, 0x0000000840367824ULL, 0x000fe200078e0205ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000000840387824ULL, 0x040fe200078e0207ULL,
0x0000000c131f7812ULL, 0x000fe200078ec0ffULL, 0x00000008403a7824ULL, 0x000fc400078e020bULL,
0x00000008403c7824ULL, 0x040fe400078e020dULL, 0x00000008403e7824ULL, 0x040fe400078e020fULL,
0x0000000840407824ULL, 0x000fe400078e0211ULL, 0x0000001004047824ULL, 0x100fe400078e0203ULL,
0x0000001044077824ULL, 0x100fe400078e0203ULL, 0x000000100a0a7824ULL, 0x000fc400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x000000102c2c7824ULL, 0x100fe400078e0203ULL,
0x000000011f057824ULL, 0x000fe400078e0204ULL, 0x000000102e2e7824ULL, 0x100fe400078e0203ULL,
0x0000001030307824ULL, 0x100fe200078e0203ULL, 0x0000002a05007388ULL, 0x0003e20000000800ULL,
0x0000001032327824ULL, 0x000fc400078e0203ULL, 0x0000001036367824ULL, 0x100fe400078e0203ULL,
0x0000001038387824ULL, 0x100fe400078e0203ULL, 0x000000103a3a7824ULL, 0x100fe400078e0203ULL,
0x000000103c3c7824ULL, 0x100fe400078e0203ULL, 0x000000103e3e7824ULL, 0x100fe400078e0203ULL,
0x0000001040407824ULL, 0x000fc400078e0203ULL, 0x000000011f137824ULL, 0x040fe400078e0207ULL,
0x000000011f037824ULL, 0x040fe400078e020aULL, 0x000000011f077824ULL, 0x040fe400078e020cULL,
0x000000011f0b7824ULL, 0x040fe200078e022cULL, 0x0000002603007388ULL, 0x000fe20000000800ULL,
0x000000011f0d7824ULL, 0x040fe400078e022eULL, 0x000000011f0f7824ULL, 0x040fe200078e0230ULL,
0x0000002207007388ULL, 0x000fe20000000800ULL, 0x000000011f117824ULL, 0x000fc400078e0232ULL,
0x000000011f157824ULL, 0x040fe200078e0234ULL, 0x0000001e0b007388ULL, 0x000fe20000000800ULL,
0x000000011f177824ULL, 0x040fe400078e0236ULL, 0x000000011f057824ULL, 0x042fe200078e0238ULL,
0x0000001a0d007388ULL, 0x000fe20000000800ULL, 0x000000011f197824ULL, 0x040fe400078e023aULL,
0x000000011f1b7824ULL, 0x040fe200078e023cULL, 0x000000160f007388ULL, 0x000fe20000000800ULL,
0x000000011f217824ULL, 0x000fc400078e0242ULL, 0x000000011f1d7824ULL, 0x040fe200078e023eULL,
0x0000001211007388ULL, 0x000fe20000000800ULL, 0x000000011f1f7824ULL, 0x000fe400078e0240ULL,
0x0000002009237824ULL, 0x000fe200078e0200ULL, 0x0000000e13007388ULL, 0x000fe60000000800ULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0x0000002815007388ULL, 0x000fe80000000800ULL,
0x0000002417007388ULL, 0x000fe80000000800ULL, 0x0000002005007388ULL, 0x000fe80000000800ULL,
0x0000001c19007388ULL, 0x000fe80000000800ULL, 0x000000181b007388ULL, 0x000fe80000000800ULL,
0x000000141d007388ULL, 0x000fe80000000800ULL, 0x000000101f007388ULL, 0x000fe80000000800ULL,
0x0000000621007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000230c7984ULL, 0x000e680000000c00ULL, 0x0004000023287984ULL, 0x000ea80000000c00ULL,
0x0008000023247984ULL, 0x000f280000000c00ULL, 0x000c0000232c7984ULL, 0x000f620000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x004fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fc40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x000000270f0f7230ULL, 0x010fe40000000000ULL, 0x000000260e0e7230ULL, 0x000fe40000000000ULL,
0x000000250d0d7230ULL, 0x000fe40000000000ULL, 0x000000240c0c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x020fc40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0000000c23007388ULL, 0x0003e20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x0004002823007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000197919ULL, 0x000f220000002600ULL,
0x00000020001d7810ULL, 0x042fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x00000040001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x00000008081a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fe2000001161dULL, 0x00000008081b7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fe2000001161fULL, 0x00000008081e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff187819ULL, 0x000fc40000011621ULL, 0x000000070b067812ULL, 0x000fe400078e481fULL,
0x00000007180c7812ULL, 0x004fe400078e4821ULL, 0x0ffffff806077812ULL, 0x000fe400078ef81fULL,
0x0ffffff80c0d7812ULL, 0x000fe400078ef821ULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x0000001019047824ULL, 0x010fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000001007107824ULL, 0x100fe200078e0202ULL, 0x00000004050472a4ULL, 0x002fe2000f8e023fULL,
0x000000100d147824ULL, 0x000fe200078e0202ULL, 0xfffffff004097812ULL, 0x000fe200078ee203ULL,
0x0000001019237824ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x100fe200078e4800ULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x000000070a047812ULL, 0x100fe200078e481dULL,
0x00000010191a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff803037812ULL, 0x000fe200078ef800ULL,
0x0000000014147984ULL, 0x000fe20000000c00ULL, 0x0ffffff804057812ULL, 0x000fe200078ef81dULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000000409097c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001003037824ULL, 0x000fe200078e0202ULL, 0xfffffff0230a7812ULL, 0x000fe200078ee20aULL,
0x00000010050c7824ULL, 0x000fe200078e0202ULL, 0xfffffff01a0b7812ULL, 0x000fe200078ee20bULL,
0x0000000808027824ULL, 0x000fe200078e00ffULL, 0x0000000003047984ULL, 0x0002a20000000c00ULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0xfffffff019187812ULL, 0x000fc400078ee218ULL,
0x000000000c0c7984ULL, 0x000f220000000c00ULL, 0xfffffff8021d7812ULL, 0x000fe400078ee21dULL,
0x00005a0009027a11ULL, 0x000fe400078040ffULL, 0x000000040b0b7c10ULL, 0x000fe4000ff3e0ffULL,
0x00005b0009037a11ULL, 0x002fe400000f4400ULL, 0x000000040a097c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000000418007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a000b0a7a11ULL, 0x000fc400078240ffULL,
0xfffffff81e217812ULL, 0x000fe200078ee221ULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a0009087a11ULL, 0x040fe200078040ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x040fe400078440ffULL, 0x00005b0009097a11ULL, 0x000fe400000f441cULL,
0x00005b000b0b7a11ULL, 0x000fe400008f441aULL, 0x00005b0000197a11ULL, 0x000fe200010f4419ULL,
0x000000101d087825ULL, 0x000fc800078e0008ULL, 0x000000101f0a7825ULL, 0x000fc800078e000aULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d08ULL,
0x0000000c08007986ULL, 0x010fe8000c101d08ULL, 0x000000100a007986ULL, 0x000fe8000c101d08ULL,
0x0000001418007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff367624ULL, 0x000fe200078e00ffULL, 0x00000001ff1b7819ULL, 0x000fe2000001161aULL,
0x00006900ff377624ULL, 0x000fc400078e00ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x01ffffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000836367981ULL, 0x000366000c1e9900ULL,
0x000000025c1b7824ULL, 0x000fca00078e021bULL, 0x000000021b00720cULL, 0x000fe40003f06070ULL,
0x000000015c087810ULL, 0x000fd60007ffe0ffULL, 0x000000020e048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e021bULL, 0x0000600004048625ULL, 0x000fca00078e0007ULL,
0x0000000804068981ULL, 0x000362000c1e1900ULL, 0x000000030800720cULL, 0x000fe20003f06070ULL,
0x000000401a197824ULL, 0x000fe400078e00ffULL, 0x0000008021187824ULL, 0x000fe400078e00ffULL,
0x000001005c097824ULL, 0x000fe200078e0219ULL, 0x0000000704047899ULL, 0x000fc8000800063fULL,
0x00000040180b7812ULL, 0x000fc600078ef809ULL, 0x00000cb000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000000406067c24ULL, 0x020fe2000f8e020bULL,
0x0000000900057217ULL, 0x000fca0007800000ULL, 0x0000000105097824ULL, 0x000fe200078e0a09ULL,
0x00000003ff2d7819ULL, 0x002fc80000011604ULL, 0x000000042d0d7810ULL, 0x040fe40007ffe0ffULL,
0x000000102d157810ULL, 0x000fe40007ffe0ffULL, 0x000000040d087212ULL, 0x0c0fe200078e3cffULL,
0x000000080d0b7824ULL, 0x000fe200078e00ffULL, 0x000000082d0f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c2d137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80b247812ULL, 0x000fe200078ee208ULL,
0x00000008150b7824ULL, 0x040fe200078e00ffULL, 0x0000000415087212ULL, 0x080fe200078e3cffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x000000142d1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000813287824ULL, 0x000fe200078e00ffULL, 0x000000040f0a7212ULL, 0x000fc400078e3cffULL,
0x0000000413057212ULL, 0x080fe200078e3cffULL, 0x000000081d2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b2a7812ULL, 0x000fe200078ee208ULL, 0x00000080ff087424ULL, 0x000fe200078e00ffULL,
0x0000007f2d0b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff811267812ULL, 0x000fe200078ee20aULL,
0x00000010040a7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee205ULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0x000000041d057212ULL, 0x000fc400078e3cffULL,
0x000000090f00720cULL, 0x080fe40003fa6070ULL, 0x000000090d00720cULL, 0x080fe40003f86070ULL,
0x0000007f0f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000007f0d0d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee205ULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x000000700a057812ULL, 0x000fe200078ec0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0008ULL,
0x000000091300720cULL, 0x000fc40003f06070ULL, 0x0000007f13137812ULL, 0x000fe200078ec0ffULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x000000091500720cULL, 0x000fe20003f46070ULL,
0x00005e000f107625ULL, 0x080fe200078e0008ULL, 0x0000007f15157812ULL, 0x000fe400078ec0ffULL,
0x000000050a147210ULL, 0x080fe20007f3e0ffULL, 0x00005e000d0c7625ULL, 0x080fe200078e0008ULL,
0x0000000510107210ULL, 0x080fe40007f7e0ffULL, 0x000000182d277810ULL, 0x040fe20007ffe0ffULL,
0x0000000106137824ULL, 0x040fe200078e0213ULL, 0x0000001c2d2f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001060f7824ULL, 0x000fe200078e0215ULL, 0x0000007f271f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200008e060bULL, 0x000000050c167210ULL, 0x000fe20007f3e0ffULL,
0x00005e00130a7625ULL, 0x000fe200078e0008ULL, 0x000000072d217812ULL, 0x000fc400078e4804ULL,
0x000000202d297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x000000050a1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e060dULL,
0x0000007f1d0d7812ULL, 0x000fe200078ec0ffULL, 0x00005e000f127625ULL, 0x080fe200078e0008ULL,
0x000000091d00720cULL, 0x000fe40003f26070ULL, 0x000010001a0f7811ULL, 0x000fe200078e70ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e060bULL, 0x0000000512127210ULL, 0x000fe20007fde0ffULL,
0x00000001060b7824ULL, 0x040fe200078e020dULL, 0x000000092d00720cULL, 0x000fe20003f66070ULL,
0x00000001060d7824ULL, 0x000fe200078e021fULL, 0x0000007f2f1f7812ULL, 0x000fe200078ec0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0008ULL, 0x0000007f29237812ULL, 0x000fc400078ec0ffULL,
0x000000242d2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000050a1e7210ULL, 0x000fe20007fde0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0008ULL,
0x0ffffff8210a7812ULL, 0x000fc600078ef804ULL, 0x0000000106217824ULL, 0x000fe400078e021fULL,
0x000000ffff1f7224ULL, 0x000fe200030e060bULL, 0x000000050c207210ULL, 0x000fe20007fde0ffULL,
0x000000100a257824ULL, 0x000fe400078e020fULL, 0x00005e00210a7625ULL, 0x000fc600078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014257faeULL, 0x0003e2000d901c48ULL,
0x000000ffff217224ULL, 0x000fe200030e060dULL, 0x000000050a227210ULL, 0x000fe20007fde0ffULL,
0x0000000106237824ULL, 0x000fe200078e0223ULL, 0x000000092700720cULL, 0x040fe40003f66070ULL,
0x00000004270a7212ULL, 0x000fe200078e3cffULL, 0x00005e00230c7625ULL, 0x000fc800078e0008ULL,
0x000000ffff237224ULL, 0x000fe200030e060bULL, 0x0000007f2b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000050c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001026257824ULL, 0x002fe200078e020fULL, 0x000000042f157212ULL, 0x080fe200078e3cffULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0xfffffff8272e7812ULL, 0x000fe200078ee20aULL,
0x0000001024277824ULL, 0x000fe200078e020fULL, 0x0000000429247212ULL, 0x000fe200078e3cffULL,
0x00005e000b0a7625ULL, 0x000fc600078e0008ULL, 0x0000000016277faeULL, 0x0003e2000e101c48ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x000000050a147210ULL, 0x000fe20007fde0ffULL,
0x000000082f267824ULL, 0x000fe200078e00ffULL, 0x0000000010257faeULL, 0x0005e2000e901c48ULL,
0x000000092900720cULL, 0x0c0fe20003fa6070ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000000092f00720cULL, 0x080fe40003f86070ULL, 0xfffffff8260a7812ULL, 0x000fe200078ee215ULL,
0x000000ffff157224ULL, 0x000fe200030e060bULL, 0xfffffff829247812ULL, 0x000fe200078ee224ULL,
0x0000001028177824ULL, 0x102fe200078e020fULL, 0x000000092b00720cULL, 0x000fe20003fc6070ULL,
0x000000102a0b7824ULL, 0x100fe200078e020fULL, 0x000000282d107810ULL, 0x004fe20007ffe0ffULL,
0x000000102c117824ULL, 0x100fe200078e020fULL, 0x000000001c177faeULL, 0x0003e2000c101c48ULL,
0x000000102e257824ULL, 0x000fc400078e020fULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x00000000120b7faeULL, 0x0005e2000d101c48ULL, 0x000000100a277824ULL, 0x100fe200078e020fULL,
0x000000042b0a7212ULL, 0x000fe200078e3cffULL, 0x0000001024297824ULL, 0x000fe200078e020fULL,
0x000000001e117faeULL, 0x0007e2000c901c48ULL, 0x000000382d247810ULL, 0x000fe20007ffe0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000002c2d177810ULL, 0x042fe20007ffe0ffULL,
0x0000000020257faeULL, 0x0003e2000d901c48ULL, 0x000000302d1d7810ULL, 0x000fc40007ffe0ffULL,
0x00000004100b7212ULL, 0x004fe200078e3cffULL, 0x0000000022277faeULL, 0x0005e2000e101c48ULL,
0x000000342d127810ULL, 0x000fe20007ffe0ffULL, 0x00000008171c7824ULL, 0x000fe200078e00ffULL,
0x0000003c2d1f7810ULL, 0x008fe20007ffe0ffULL, 0x000000000c297faeULL, 0x0007e2000e901c48ULL,
0xfffffff816167812ULL, 0x000fe400078ee20bULL, 0x0000007f100b7812ULL, 0x000fe200078ec0ffULL,
0x0000000812207824ULL, 0x002fe200078e00ffULL, 0x000000091000720cULL, 0x000fc40003fa6070ULL,
0x000000091700720cULL, 0x080fe20003f86070ULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x000000091d00720cULL, 0x0c0fe40003f66070ULL, 0x000000091200720cULL, 0x080fe20003f46070ULL,
0x000000081d0d7824ULL, 0x008fe200078e00ffULL, 0x000000092400720cULL, 0x080fe40003f26070ULL,
0x000000091f00720cULL, 0x000fe40003f06070ULL, 0xfffffff82b0a7812ULL, 0x000fc400078ee20aULL,
0x0000000417097212ULL, 0x080fe400078e3cffULL, 0x000000041d0c7212ULL, 0x000fe400078e3cffULL,
0x0000007f17177812ULL, 0x000fe400078ec0ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x000000100a097824ULL, 0x000fe200078e020fULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee20cULL,
0x00005e000b0a7625ULL, 0x000fe200078e0008ULL, 0x0000007f1d1d7812ULL, 0x000fc400078ec0ffULL,
0x0000000014097faeULL, 0x0003e2000f101c48ULL, 0x00000001060d7824ULL, 0x000fe200078e0217ULL,
0x0000000412117212ULL, 0x000fe200078e3cffULL, 0x00000001061d7824ULL, 0x000fe200078e021dULL,
0x000000050a107210ULL, 0x000fe20007fde0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0008ULL,
0xfffffff820207812ULL, 0x000fc600078ee211ULL, 0x000000ffff117224ULL, 0x000fe400030e060bULL,
0x00005e001d0a7625ULL, 0x080fe200078e0008ULL, 0x0000007f12097812ULL, 0x002fe400078ec0ffULL,
0x000000050c127210ULL, 0x080fe20007fde0ffULL, 0x0000001020217824ULL, 0x000fe200078e020fULL,
0x0000007f24157812ULL, 0x000fe200078ec0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x0000007f1f1d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200030e060dULL,
0x000000050a147210ULL, 0x000fe20007fde0ffULL, 0x00005e00090c7625ULL, 0x000fc800078e0008ULL,
0x0000000106177824ULL, 0x000fe400078e0215ULL, 0x000000ffff157224ULL, 0x000fe200030e060bULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x00005e00170a7625ULL, 0x000fc800078e0008ULL,
0x0000000106097824ULL, 0x000fe200078e021dULL, 0x0000000424067212ULL, 0x0c0fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x000000041f047212ULL, 0x040fe200078e3cffULL,
0x0000000824177824ULL, 0x000fe200078e00ffULL, 0x000000050a0a7210ULL, 0x080fe20007fde0ffULL,
0x000000081f1f7824ULL, 0x000fe400078e00ffULL, 0x00005e0009087625ULL, 0x000fe200078e0008ULL,
0xfffffff817067812ULL, 0x000fe400078ee206ULL, 0xfffffff81f227812ULL, 0x004fe200078ee204ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000508047210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x000fc400078e020fULL, 0x000000101c1d7824ULL, 0x100fe400078e020fULL,
0x000000101e1f7824ULL, 0x100fe200078e020fULL, 0x0000000010177faeULL, 0x0003e2000e901c48ULL,
0x0000001006237824ULL, 0x100fe400078e020fULL, 0x00000010220f7824ULL, 0x000fe200078e020fULL,
0x00000000121d7faeULL, 0x0003e2000e101c48ULL, 0x000000ffff057224ULL, 0x000fc600030e0609ULL,
0x00000000141f7faeULL, 0x0003e8000d901c48ULL, 0x000000000c217faeULL, 0x0003e8000d101c48ULL,
0x000000000a237faeULL, 0x0003e8000c901c48ULL, 0x00000000040f7faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x0000000406067c24ULL, 0x020fc4000f8e020bULL, 0x00000080ff2a7424ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x002fc80000011604ULL, 0x00000008050f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001805257810ULL, 0x040fe40007ffe0ffULL, 0x00000004050d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0a7824ULL, 0x000fe200078e00ffULL, 0x00000010051d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000825107824ULL, 0x000fe200078e00ffULL, 0x000000040f097212ULL, 0x000fe200078e3cffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x0000000c05157810ULL, 0x000fe20007ffe0ffULL,
0x000000081d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a137812ULL, 0x000fc400078ee209ULL,
0x00000004250b7212ULL, 0x080fe200078e3cffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0x0000002805317810ULL, 0x000fe40007ffe0ffULL, 0x000000040d087212ULL, 0x080fe400078e3cffULL,
0x000000041d097212ULL, 0x000fe400078e3cffULL, 0x00000020052d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810277812ULL, 0x000fe200078ee20bULL, 0x0000000831107824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fc400078ee208ULL, 0x0000001405217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c1f7812ULL, 0x000fe200078ee209ULL, 0x000000082d0c7824ULL, 0x000fe200078e00ffULL,
0x0000001c05297810ULL, 0x000fe20007ffe0ffULL, 0x0000000821237824ULL, 0x000fe200078e00ffULL,
0x0000000415087212ULL, 0x080fe400078e3cffULL, 0x00000004310b7212ULL, 0x000fe200078e3cffULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x0000003805397810ULL, 0x000fc40007ffe0ffULL,
0x000000042d097212ULL, 0x080fe400078e3cffULL, 0x0000003005357810ULL, 0x000fe40007ffe0ffULL,
0xfffffff817177812ULL, 0x000fe400078ee208ULL, 0x00000024052f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810477812ULL, 0x000fe200078ee20bULL, 0x0000000839107824ULL, 0x000fe200078e00ffULL,
0x0000002c05337810ULL, 0x000fe20007ffe0ffULL, 0x000000082f437824ULL, 0x000fe200078e00ffULL,
0x00000004210a7212ULL, 0x000fc400078e3cffULL, 0x0000000429087212ULL, 0x080fe200078e3cffULL,
0x00000008334b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3f7812ULL, 0x000fe200078ee209ULL,
0x00000008350c7824ULL, 0x000fe200078e00ffULL, 0x00000004390b7212ULL, 0x080fe400078e3cffULL,
0x0000000435097212ULL, 0x000fe400078e3cffULL, 0xfffffff823237812ULL, 0x000fe400078ee20aULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee208ULL, 0x000000042f0a7212ULL, 0x080fe400078e3cffULL,
0x0000000433087212ULL, 0x000fe400078e3cffULL, 0xfffffff810577812ULL, 0x000fe400078ee20bULL,
0x0000003c053b7810ULL, 0x040fe40007ffe0ffULL, 0x0000003405377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c4f7812ULL, 0x000fe200078ee209ULL, 0x000000083b5b7824ULL, 0x000fe200078e00ffULL,
0x00000007050b7812ULL, 0x000fe200078e4804ULL, 0x0000000837537824ULL, 0x000fe200078e00ffULL,
0x0000007f05097812ULL, 0x000fc400078ec0ffULL, 0xfffffff843437812ULL, 0x000fe400078ee20aULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL, 0x0000001004087824ULL, 0x000fe200078e00ffULL,
0x00000004370a7212ULL, 0x000fe200078e3cffULL, 0x0000000106057824ULL, 0x000fe200078e0209ULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef804ULL, 0x0000007f0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000007f0f0f7812ULL, 0x000fc400078ec0ffULL, 0x000000043b047212ULL, 0x000fe200078e3cffULL,
0x0000000106097824ULL, 0x040fe200078e020dULL, 0x0000007f1d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001060d7824ULL, 0x000fe200078e020fULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee204ULL,
0x00005e0005047625ULL, 0x080fe200078e002aULL, 0x00000070080f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff853537812ULL, 0x000fe200078ee20aULL, 0x00005e0009087625ULL, 0x000fe200078e002aULL,
0x0000007f2f2f7812ULL, 0x000fc400078ec0ffULL, 0x0000000f04047210ULL, 0x080fe20007f1e0ffULL,
0x00000001061d7824ULL, 0x000fe200078e021dULL, 0x000010001a0a7811ULL, 0x000fe200078e70ffULL,
0x0000000106417824ULL, 0x040fe200078e022fULL, 0x0000007f2d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000007f31317812ULL, 0x000fe200078ec0ffULL,
0x00000010112f7824ULL, 0x100fe200078e020aULL, 0x0000007f33337812ULL, 0x000fe200078ec0ffULL,
0x00000001063d7824ULL, 0x040fe200078e022dULL, 0x0000007f35357812ULL, 0x000fe200078ec0ffULL,
0x0000000106457824ULL, 0x040fe200078e0231ULL, 0x0000007f37377812ULL, 0x000fe200078ec0ffULL,
0x0000000106497824ULL, 0x040fe200078e0233ULL, 0x0000007f39397812ULL, 0x000fe200078ec0ffULL,
0x00000001064d7824ULL, 0x040fe200078e0235ULL, 0x0000007f15157812ULL, 0x000fe200078ec0ffULL,
0x0000000106517824ULL, 0x040fe200078e0237ULL, 0x0000007f25257812ULL, 0x000fe200078ec0ffULL,
0x0000000106557824ULL, 0x000fe200078e0239ULL, 0x0000007f21217812ULL, 0x000fe200078ec0ffULL,
0x000000100b2d7824ULL, 0x100fe200078e020aULL, 0x0000007f3b597812ULL, 0x000fe200078ec0ffULL,
0x0000001013317824ULL, 0x100fe200078e020aULL, 0x0000000f08087210ULL, 0x000fe20007f1e0ffULL,
0x0000001017337824ULL, 0x100fe200078e020aULL, 0x0000007f29297812ULL, 0x000fe200078ec0ffULL,
0x000000101f357824ULL, 0x100fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042d7faeULL, 0x0003e2000b901c48ULL, 0x0000001023377824ULL, 0x000fc400078e020aULL,
0x0000001027397824ULL, 0x100fe400078e020aULL, 0x000000102b3b7824ULL, 0x100fe400078e020aULL,
0x000000103f3f7824ULL, 0x100fe400078e020aULL, 0x0000001043437824ULL, 0x100fe400078e020aULL,
0x0000001047477824ULL, 0x100fe400078e020aULL, 0x000000104b4b7824ULL, 0x000fc400078e020aULL,
0x000000104f4f7824ULL, 0x100fe400078e020aULL, 0x0000001053537824ULL, 0x100fe400078e020aULL,
0x0000001057577824ULL, 0x100fe400078e020aULL, 0x000000105b5b7824ULL, 0x000fe400078e020aULL,
0x00005e001d107625ULL, 0x000fc800078e002aULL, 0x0000000106157824ULL, 0x000fe400078e0215ULL,
0x00005e000d0a7625ULL, 0x000fc800078e002aULL, 0x0000000106257824ULL, 0x000fe200078e0225ULL,
0x0000000f0a0a7210ULL, 0x080fe20007f3e0ffULL, 0x0000000106217824ULL, 0x000fe400078e0221ULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000000f10107210ULL, 0x000fe20007f1e0ffULL,
0x00005e00150c7625ULL, 0x000fc600078e002aULL, 0x00000000082f7faeULL, 0x0003e2000b901c48ULL,
0x00005e0025147625ULL, 0x000fe200078e002aULL, 0x0000000f0c0c7210ULL, 0x000fc60007f5e0ffULL,
0x00005e0021127625ULL, 0x000fc800078e002aULL, 0x0000000106297824ULL, 0x000fe400078e0229ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000000f14147210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000000f12127210ULL, 0x000fe20007f3e0ffULL,
0x00005e003d1c7625ULL, 0x000fc600078e002aULL, 0x000000000a317faeULL, 0x0003e2000b901c48ULL,
0x00005e0029167625ULL, 0x000fc800078e002aULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000000f1c1c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000000f16167210ULL, 0x000fe20007f3e0ffULL, 0x00005e0049227625ULL, 0x000fc800078e002aULL,
0x00005e00411e7625ULL, 0x000fc800078e002aULL, 0x00005e0045207625ULL, 0x000fc800078e002aULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000000f22227210ULL, 0x080fe20007f1e0ffULL,
0x0000000106597824ULL, 0x000fe400078e0259ULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000000f1e1e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x0000000f20207210ULL, 0x000fe20007f5e0ffULL, 0x00005e004d247625ULL, 0x000fc600078e002aULL,
0x000000000c337faeULL, 0x0003e2000b901c48ULL, 0x00005e0051267625ULL, 0x000fc600078e002aULL,
0x0000000010357faeULL, 0x0003e2000b901c48ULL, 0x00005e0055287625ULL, 0x000fc600078e002aULL,
0x0000000012377faeULL, 0x0003e2000b901c48ULL, 0x00005e00592a7625ULL, 0x000fc600078e002aULL,
0x0000000014397faeULL, 0x0003e2000b901c48ULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x0000000f24247210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x0000000f26267210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000000f28287210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x0000000f2a2a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000163b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff277224ULL, 0x000fc400008e0627ULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x000000001c3f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff2b7224ULL, 0x000fc600018e062bULL,
0x000000001e437faeULL, 0x0003e8000b901c48ULL, 0x0000000020477faeULL, 0x0003e8000b901c48ULL,
0x00000000224b7faeULL, 0x0003e8000b901c48ULL, 0x00000000244f7faeULL, 0x0003e8000b901c48ULL,
0x0000000026537faeULL, 0x0003e8000b901c48ULL, 0x0000000028577faeULL, 0x0003e8000b901c48ULL,
0x000000002a5b7faeULL, 0x0003e4000b901c48ULL, 0x01b60400ff057984ULL, 0x002e620000000800ULL,
0x00000300ff047624ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x00000002041b7824ULL, 0x000fca00078e021bULL, 0x000000021b00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000020e347824ULL, 0x000fc800078e00ffULL,
0x0000640034347a24ULL, 0x000fc800078e021bULL, 0x0000600034347625ULL, 0x000fcc00078e0007ULL,
0x0000000834347981ULL, 0x000564000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x002fe2000780c0ffULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x008fe40003800000ULL, 0x01b60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000031a00780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000201a047824ULL, 0x002fc800078e0205ULL, 0x0000001004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7804ULL, 0x0000000707077812ULL, 0x000fc600078e7804ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x0000000005107984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ee2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x008fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0009ULL, 0x000000ffff137224ULL, 0x000fe200078e000bULL,
0x0000001405007388ULL, 0x0003e8000000cc00ULL, 0x0000001007007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01b60400ff047984ULL, 0x000ee40000000800ULL, 0x8000000004ff7812ULL, 0x008fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0022e4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x008fe40003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000035c00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000357919ULL, 0x004ea20000000000ULL, 0x3db504f336367820ULL, 0x000fe20000410000ULL,
0xffffffff03397810ULL, 0x000fe20007ffe0ffULL, 0x000064000e387a24ULL, 0x000fe200078e02ffULL,
0x00007610ff3a7816ULL, 0x000fe2000000003aULL, 0x000000101a377824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff057224ULL, 0x002fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x000001005c3d7824ULL, 0x000fe200078e0219ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003d0000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000003005c3c7a10ULL, 0x000fe20007ffe0ffULL,
0x000018b000007945ULL, 0x000fe20003800000ULL, 0x00000001053b7812ULL, 0x000fe400078e0cffULL,
0x000000013c047810ULL, 0x040fe20007ffe0ffULL, 0x000001003c097824ULL, 0x000fc600078e0219ULL,
0x000000030400720cULL, 0x000fe40003f06070ULL, 0x0000004009077812ULL, 0x000fca00078ec0ffULL,
0x0000000118077824ULL, 0x000fcc00078e0207ULL, 0x00000cb000008947ULL, 0x000fea0003800000ULL,
0x00000003ff227819ULL, 0x004fe20000011635ULL, 0x0000000434347c24ULL, 0x020fe2000f8e0207ULL,
0x0000000900047217ULL, 0x000fe20007800000ULL, 0x000000021a207824ULL, 0x000fe200078e023bULL,
0x00000008220a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000422087810ULL, 0x000fe20007ffe0ffULL,
0x0000000104077824ULL, 0x000fe200078e0a09ULL, 0x000000350a0b7212ULL, 0x0c0fe200078e3cffULL,
0x000000080a0e7824ULL, 0x000fe200078e00ffULL, 0x0000000c220c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000808237824ULL, 0x040fe200078e00ffULL, 0x0000003508067212ULL, 0x000fc400078e3cffULL,
0xfffffff80e257812ULL, 0x000fe200078ee20bULL, 0x000000080c277824ULL, 0x000fe200078e00ffULL,
0x00000010220e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001422167810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee206ULL, 0x000000080e297824ULL, 0x000fe200078e00ffULL,
0x000000350c047212ULL, 0x080fe200078e3cffULL, 0x0000000816107824ULL, 0x000fe200078e00ffULL,
0x000000350e067212ULL, 0x000fc400078e3cffULL, 0x0000007f22097812ULL, 0x000fe400078ec0ffULL,
0x00000035160b7212ULL, 0x000fe400078e3cffULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x0000001035047824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee206ULL,
0x00000080ff067424ULL, 0x000fe200078e00ffULL, 0xfffffff8102b7812ULL, 0x000fe200078ee20bULL,
0x0000000109097824ULL, 0x000fe200078e0234ULL, 0x0000007f0a0d7812ULL, 0x000fc400078ec0ffULL,
0x0000007f080b7812ULL, 0x040fe400078ec0ffULL, 0x000000070800720cULL, 0x080fe20003f86070ULL,
0x00005e0009087625ULL, 0x080fe200078e0006ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000007f0e137812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0234ULL,
0x000000070c00720cULL, 0x0c0fe20003f06070ULL, 0x000000010b0b7824ULL, 0x000fe200078e0234ULL,
0x0000007f0c0f7812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0006ULL,
0x000000070a00720cULL, 0x000fc40003fa6070ULL, 0x0000000408107210ULL, 0x000fe20007f3e0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0006ULL, 0x000000040c0c7210ULL, 0x080fe40007f7e0ffULL,
0x000000070e00720cULL, 0x000fe20003f46070ULL, 0x0000000113137824ULL, 0x000fe200078e0234ULL,
0x0000001822247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x000000040a127210ULL, 0x000fe20007f3e0ffULL, 0x00005e0013087625ULL, 0x000fe200078e0006ULL,
0x0000007f24177812ULL, 0x000fc400078ec0ffULL, 0x0000001c22267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e060dULL, 0x0000000408147210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0f7824ULL, 0x100fe200078e0234ULL, 0x0000007f261d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200008e060bULL, 0x0000007f160b7812ULL, 0x040fe200078ec0ffULL,
0x00005e000f0e7625ULL, 0x000fe200078e0006ULL, 0x000000071600720cULL, 0x000fe40003f26070ULL,
0x00000007221c7812ULL, 0x000fe200078e4835ULL, 0x000000ffff157224ULL, 0x000fe200018e0609ULL,
0x000000040e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000010b097824ULL, 0x100fe200078e0234ULL,
0x0000002022287810ULL, 0x000fe20007ffe0ffULL, 0x00000001170b7824ULL, 0x000fe200078e0234ULL,
0x0ffffff81c217812ULL, 0x000fe200078ef835ULL, 0x00005e0009087625ULL, 0x000fe200078e0006ULL,
0x0000007f281f7812ULL, 0x000fc400078ec0ffULL, 0x000000072200720cULL, 0x000fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000000408167210ULL, 0x000fe20007fde0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0006ULL, 0x00000024222a7810ULL, 0x000fe40007ffe0ffULL,
0x0000100020207811ULL, 0x000fe200078e68ffULL, 0x000000011d1d7824ULL, 0x000fe400078e0234ULL,
0x000000ffff177224ULL, 0x000fe200030e0609ULL, 0x000000040a1c7210ULL, 0x000fe20007fde0ffULL,
0x00005e001d087625ULL, 0x000fc800078e0006ULL, 0x000000ffff1d7224ULL, 0x000fe200030e060bULL,
0x00000004081e7210ULL, 0x000fe20007fde0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0234ULL,
0x0000003524087212ULL, 0x040fe200078e3cffULL, 0x00000008242d7824ULL, 0x000fe400078e00ffULL,
0x00005e001f0a7625ULL, 0x000fc600078e0006ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL,
0x000000ffff1f7224ULL, 0x000fe200030e0609ULL, 0x0000007f2a097812ULL, 0x000fe200078ec0ffULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x000000040a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x000fe400078e0220ULL, 0x0000000109097824ULL, 0x000fe200078e0234ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010217faeULL, 0x0003e2000d901c48ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000072400720cULL, 0x080fe20003f66070ULL,
0x00005e0009087625ULL, 0x000fe200078e0006ULL, 0x0000000012237faeULL, 0x0005e2000e101c48ULL,
0x000000072600720cULL, 0x000fc40003f86070ULL, 0x0000003528247212ULL, 0x080fe200078e3cffULL,
0x0000001025217824ULL, 0x102fe200078e0220ULL, 0x0000003526117212ULL, 0x040fe200078e3cffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x0000000408107210ULL, 0x000fe20007fde0ffULL,
0x0000000828257824ULL, 0x040fe200078e00ffULL, 0x000000000c217faeULL, 0x0003e2000e901c48ULL,
0x000000072800720cULL, 0x000fe20003fa6070ULL, 0x0000001027137824ULL, 0x004fe200078e0220ULL,
0xfffffff826237812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0xfffffff825257812ULL, 0x000fe200078ee224ULL, 0x0000001029097824ULL, 0x100fe200078e0220ULL,
0x000000000e137faeULL, 0x0005e2000c101c48ULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x0000003022127810ULL, 0x040fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe200078e0220ULL,
0x0000000014097faeULL, 0x0007e2000d101c48ULL, 0x000000102b0d7824ULL, 0x102fe200078e0220ULL,
0x00000028220c7810ULL, 0x040fe20007ffe0ffULL, 0x000000102d217824ULL, 0x000fe200078e0220ULL,
0x0000003822247810ULL, 0x000fc40007ffe0ffULL, 0x00000000160d7faeULL, 0x0003e2000c901c48ULL,
0x000000352a087212ULL, 0x000fe400078e3cffULL, 0x0000002c220e7810ULL, 0x004fe20007ffe0ffULL,
0x000000001c217faeULL, 0x0005e2000d901c48ULL, 0x000000072a00720cULL, 0x000fe40003fc6070ULL,
0x000000350c097212ULL, 0x008fe200078e3cffULL, 0x000000001e237faeULL, 0x0007e2000e101c48ULL,
0x0000003422147810ULL, 0x040fe40007ffe0ffULL, 0x0000003c22227810ULL, 0x000fe20007ffe0ffULL,
0x000000000a257faeULL, 0x0009e2000e901c48ULL, 0x000000082a0d7824ULL, 0x002fe200078e00ffULL,
0x000000070c00720cULL, 0x080fe20003fa6070ULL, 0x000000080e177824ULL, 0x040fe200078e00ffULL,
0x000000070e00720cULL, 0x080fe20003f86070ULL, 0x00000008121d7824ULL, 0x044fe200078e00ffULL,
0x000000071200720cULL, 0x080fe20003f66070ULL, 0x0000000824217824ULL, 0x000fe200078e00ffULL,
0x000000071400720cULL, 0x000fc40003f46070ULL, 0x000000072400720cULL, 0x080fe20003f26070ULL,
0x000000080c0a7824ULL, 0x010fe200078e00ffULL, 0x000000072200720cULL, 0x000fe40003f06070ULL,
0xfffffff80d077812ULL, 0x000fe400078ee208ULL, 0xfffffff80a157812ULL, 0x000fe400078ee209ULL,
0x0000007f0c097812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x000fe200078e0220ULL,
0x000000350e087212ULL, 0x000fc400078e3cffULL, 0x0000007f0e0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe200078e0234ULL, 0xfffffff817177812ULL, 0x000fe200078ee208ULL,
0x0000000010077faeULL, 0x0003e2000f101c48ULL, 0x00000035120a7212ULL, 0x0c0fe200078e3cffULL,
0x00005e0009087625ULL, 0x000fe200078e0006ULL, 0x0000007f120f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL, 0x000000010b0b7824ULL, 0x000fe200078e0234ULL,
0x00000035140d7212ULL, 0x040fe200078e3cffULL, 0x00000008140e7824ULL, 0x000fe200078e00ffULL,
0x00000004080c7210ULL, 0x000fe20007fde0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000007f24137812ULL, 0x000fc400078ec0ffULL, 0xfffffff80e1f7812ULL, 0x008fe200078ee20dULL,
0x000000010f0f7824ULL, 0x100fe200078e0234ULL, 0x0000007f14077812ULL, 0x002fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0609ULL, 0x000000040a0e7210ULL, 0x000fe20007fde0ffULL,
0x00005e000f087625ULL, 0x000fe200078e0006ULL, 0x0000007f22117812ULL, 0x000fe400078ec0ffULL,
0x0000003524127212ULL, 0x000fe200078e3cffULL, 0x0000000107077824ULL, 0x000fe400078e0234ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060bULL, 0x0000000408107210ULL, 0x000fe20007fde0ffULL,
0x00005e00070a7625ULL, 0x000fe200078e0006ULL, 0xfffffff821217812ULL, 0x000fc600078ee212ULL,
0x0000000113137824ULL, 0x100fe400078e0234ULL, 0x0000000111077824ULL, 0x000fe400078e0234ULL,
0x000000ffff117224ULL, 0x000fe200030e0609ULL, 0x000000040a0a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0013087625ULL, 0x000fe200078e0006ULL, 0x0000003522137212ULL, 0x000fc600078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000408087210ULL, 0x000fe20007fde0ffULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x00005e0007067625ULL, 0x000fc600078e0006ULL,
0xfffffff822237812ULL, 0x000fe200078ee213ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000406067210ULL, 0x000fe20007fde0ffULL, 0x0000001015137824ULL, 0x100fe400078e0220ULL,
0x0000001017157824ULL, 0x100fe400078e0220ULL, 0x000000101d177824ULL, 0x100fe200078e0220ULL,
0x000000000c137faeULL, 0x0003e2000e901c48ULL, 0x000000101f1d7824ULL, 0x100fe400078e0220ULL,
0x00000010211f7824ULL, 0x100fe200078e0220ULL, 0x000000000e157faeULL, 0x0003e2000e101c48ULL,
0x0000001023217824ULL, 0x000fc400078e0220ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000010177faeULL, 0x0003e8000d901c48ULL, 0x000000000a1d7faeULL, 0x0003e8000d101c48ULL,
0x00000000081f7faeULL, 0x0003e8000c901c48ULL, 0x0000000006217faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x004fe20000011635ULL,
0x0000000434077c24ULL, 0x020fc4000f8e0207ULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x0000000804107810ULL, 0x040fe40007ffe0ffULL, 0x00000004040c7810ULL, 0x000fe40007ffe0ffULL,
0x0000003510087212ULL, 0x0c0fe200078e3cffULL, 0x00000008100b7824ULL, 0x000fe200078e00ffULL,
0x0000000c04147810ULL, 0x000fe20007ffe0ffULL, 0x000000080c097824ULL, 0x000fe200078e00ffULL,
0x0000001804247810ULL, 0x000fe40007ffe0ffULL, 0x000000350c067212ULL, 0x000fc400078e3cffULL,
0xfffffff80b127812ULL, 0x000fe200078ee208ULL, 0x00000008140b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe200078ee206ULL, 0x00000008240f7824ULL, 0x000fe200078e00ffULL,
0x0000003514067212ULL, 0x080fe400078e3cffULL, 0x00000035240a7212ULL, 0x000fe400078e3cffULL,
0x0000001c04287810ULL, 0x040fe40007ffe0ffULL, 0x0000002804347810ULL, 0x000fc40007ffe0ffULL,
0x00000010041c7810ULL, 0x040fe40007ffe0ffULL, 0x0000001404207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b167812ULL, 0x000fe200078ee206ULL, 0x00000008280b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f267812ULL, 0x000fe200078ee20aULL, 0x00000008340f7824ULL, 0x000fe200078e00ffULL,
0x0000003528067212ULL, 0x080fe200078e3cffULL, 0x000000081c0d7824ULL, 0x000fe200078e00ffULL,
0x00000035340a7212ULL, 0x000fe200078e3cffULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0x0000002c04407810ULL, 0x000fc40007ffe0ffULL, 0x00000038044c7810ULL, 0x000fe40007ffe0ffULL,
0x000000351c087212ULL, 0x080fe400078e3cffULL, 0x00000020042c7810ULL, 0x040fe40007ffe0ffULL,
0x0000002404307810ULL, 0x000fe40007ffe0ffULL, 0x0000003520097212ULL, 0x000fe400078e3cffULL,
0xfffffff80b2a7812ULL, 0x000fe200078ee206ULL, 0x00000008400b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3e7812ULL, 0x000fe200078ee20aULL, 0x000000084c0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL, 0x000000082c0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x0000000830327824ULL, 0x000fe200078e00ffULL,
0x0000003404487810ULL, 0x000fc40007ffe0ffULL, 0x0000003540067212ULL, 0x080fe400078e3cffULL,
0x000000354c0a7212ULL, 0x080fe200078e3cffULL, 0x00000008484a7824ULL, 0x000fe200078e00ffULL,
0x000000352c087212ULL, 0x080fe400078e3cffULL, 0x0000003530097212ULL, 0x000fe400078e3cffULL,
0x0000003004447810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80b427812ULL, 0x000fc400078ee206ULL,
0xfffffff80f4e7812ULL, 0x000fe400078ee20aULL, 0xfffffff80d2e7812ULL, 0x000fe200078ee208ULL,
0x00000008440d7824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee209ULL,
0x0000007f04067812ULL, 0x040fe400078ec0ffULL, 0x00000007040a7812ULL, 0x000fe400078e4835ULL,
0x0000003548097212ULL, 0x000fe200078e3cffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x0000003c04047810ULL, 0x000fc40007ffe0ffULL, 0x0000003544087212ULL, 0x080fe400078e3cffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee209ULL, 0x000000021a097824ULL, 0x000fe200078e023bULL,
0x0000007f0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007f10107812ULL, 0x000fe400078ec0ffULL,
0x0000007f14147812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x100fe200078e0207ULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x100fe200078e0207ULL,
0x0000007f20207812ULL, 0x000fe200078ec0ffULL, 0x0000000114147824ULL, 0x100fe200078e0207ULL,
0x0000007f24247812ULL, 0x000fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x100fe200078e0207ULL,
0x0000007f28287812ULL, 0x000fe200078ec0ffULL, 0x0000000120207824ULL, 0x100fe200078e0207ULL,
0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000124247824ULL, 0x100fe200078e0207ULL,
0x0000007f30307812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x100fe200078e0207ULL,
0x0000007f34347812ULL, 0x000fe200078ec0ffULL, 0x000000012c2c7824ULL, 0x100fe200078e0207ULL,
0x0000007f40407812ULL, 0x000fe200078ec0ffULL, 0x0000000130307824ULL, 0x100fe200078e0207ULL,
0x0000007f44447812ULL, 0x000fe200078ec0ffULL, 0x0000000134347824ULL, 0x100fe200078e0207ULL,
0x0000007f48487812ULL, 0x000fe200078ec0ffULL, 0x0000000140407824ULL, 0x100fe200078e0207ULL,
0x0000007f4c4c7812ULL, 0x000fe200078ec0ffULL, 0x0000000144447824ULL, 0x100fe200078e0207ULL,
0x0000007f04507812ULL, 0x000fe200078ec0ffULL, 0x0000000148487824ULL, 0x100fe200078e0207ULL,
0x00000035040b7212ULL, 0x040fe200078e3cffULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0xfffffff80d467812ULL, 0x000fe200078ee208ULL, 0x0000001035087824ULL, 0x000fe200078e00ffULL,
0x0000100009097811ULL, 0x000fe200078e68ffULL, 0x000000014c4c7824ULL, 0x000fe200078e0207ULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef835ULL, 0x0000000150507824ULL, 0x000fe200078e0207ULL,
0xfffffff804047812ULL, 0x000fe200078ee20bULL, 0x00005e0006067625ULL, 0x000fe200078e0029ULL,
0x00000070082b7812ULL, 0x000fc600078ec0ffULL, 0x000000100a2d7824ULL, 0x100fe200078e0209ULL,
0x0000002b06067210ULL, 0x000fe20007f1e0ffULL, 0x000000100e2f7824ULL, 0x100fe400078e0209ULL,
0x0000001012317824ULL, 0x100fe400078e0209ULL, 0x0000001016337824ULL, 0x100fe400078e0209ULL,
0x000000101e3f7824ULL, 0x100fe400078e0209ULL, 0x0000001022417824ULL, 0x000fc400078e0209ULL,
0x0000001026437824ULL, 0x100fe400078e0209ULL, 0x000000102a457824ULL, 0x100fe400078e0209ULL,
0x000000102e477824ULL, 0x100fe400078e0209ULL, 0x0000001032497824ULL, 0x100fe400078e0209ULL,
0x000000103e4b7824ULL, 0x100fe400078e0209ULL, 0x00000010424d7824ULL, 0x000fc400078e0209ULL,
0x00000010464f7824ULL, 0x100fe400078e0209ULL, 0x000000104a517824ULL, 0x100fe400078e0209ULL,
0x000000104e537824ULL, 0x100fe400078e0209ULL, 0x0000001004557824ULL, 0x000fe400078e0209ULL,
0x00005e000c087625ULL, 0x000fc800078e0029ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000002b08087210ULL, 0x000fe20007f1e0ffULL, 0x00005e001c0e7625ULL, 0x000fc600078e0029ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062d7faeULL, 0x0003e2000b901c48ULL,
0x00005e00100a7625ULL, 0x000fc800078e0029ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000002b0e0e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0024127625ULL, 0x000fe200078e0029ULL,
0x0000002b0a0a7210ULL, 0x000fe40007f3e0ffULL, 0x00000000082f7faeULL, 0x0003e2000b901c48ULL,
0x00005e0020107625ULL, 0x000fc800078e0029ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000002b12127210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002b10107210ULL, 0x000fe20007f3e0ffULL, 0x00005e00140c7625ULL, 0x000fc600078e0029ULL,
0x000000000a317faeULL, 0x0003e2000b901c48ULL, 0x00005e002c167625ULL, 0x000fe200078e0029ULL,
0x0000002b0c0c7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0028147625ULL, 0x000fc800078e0029ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000002b16167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000002b14147210ULL, 0x000fe20007f3e0ffULL,
0x00005e0040207625ULL, 0x000fc800078e0029ULL, 0x00005e00301c7625ULL, 0x000fc800078e0029ULL,
0x00005e00341e7625ULL, 0x000fc800078e0029ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002b20207210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000002b1c1c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x0000002b1e1e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0044227625ULL, 0x000fc600078e0029ULL,
0x000000000c337faeULL, 0x0003e2000b901c48ULL, 0x00005e0048247625ULL, 0x000fc600078e0029ULL,
0x000000000e3f7faeULL, 0x0003e2000b901c48ULL, 0x00005e004c267625ULL, 0x000fc600078e0029ULL,
0x0000000010417faeULL, 0x0003e2000b901c48ULL, 0x00005e0050287625ULL, 0x000fc600078e0029ULL,
0x0000000012437faeULL, 0x0003e2000b901c48ULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000002b22227210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000002b24247210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x0000002b26267210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x0000002b28287210ULL, 0x000fe20007f7e0ffULL, 0x0000000014457faeULL, 0x0003e2000b901c48ULL,
0x000000ffff257224ULL, 0x000fc400008e0625ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000000016477faeULL, 0x0003e2000b901c48ULL, 0x000000ffff297224ULL, 0x000fc600018e0629ULL,
0x000000001c497faeULL, 0x0003e8000b901c48ULL, 0x000000001e4b7faeULL, 0x0003e8000b901c48ULL,
0x00000000204d7faeULL, 0x0003e8000b901c48ULL, 0x00000000224f7faeULL, 0x0003e8000b901c48ULL,
0x0000000024517faeULL, 0x0003e8000b901c48ULL, 0x0000000026537faeULL, 0x0003e8000b901c48ULL,
0x0000000028557faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff047624ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000002041b7824ULL, 0x000fca00078e021bULL,
0x000000021b00720cULL, 0x000fe40003f06070ULL, 0x00000020353e7810ULL, 0x040fe20007ffe0ffULL,
0x000000021a437824ULL, 0x002fe200078e0205ULL, 0x0000000735087812ULL, 0x040fe400078ec0ffULL,
0xfffffff835427812ULL, 0x000fce00078ec0ffULL, 0x0000000238068824ULL, 0x000fe400078e021bULL,
0x00000004ff078424ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000600006068625ULL, 0x000fe200078e0007ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0x0000000806348981ULL, 0x000362000c1e1900ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x002fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100043437811ULL, 0x000fe400078e68ffULL,
0x0000000808417812ULL, 0x100fe400078ef835ULL, 0x0000000742427812ULL, 0x100fe400078ef835ULL,
0x000000073e3e7812ULL, 0x000fe400078ef835ULL, 0x000000073f097812ULL, 0x040fe200078e7842ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000073f2d7812ULL, 0x040fe400078e783eULL,
0x000000013f477810ULL, 0x000fe20007ffe0ffULL, 0x0000000842087824ULL, 0x000fe200078e0209ULL,
0x00000040357a7211ULL, 0x000fe200078fe0ffULL, 0x000000083e2c7824ULL, 0x000fe200078e022dULL,
0x000000023f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001008087824ULL, 0x100fe200078e0243ULL,
0x0000000440407810ULL, 0x000fe20007ffe0ffULL, 0x000000102c2c7824ULL, 0x000fe200078e0243ULL,
0x000000083f00780cULL, 0x000fc60003f05270ULL, 0x000000000808783bULL, 0x000e680000000200ULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x00000018ff667819ULL, 0x002fe20000011409ULL,
0x0001000009317824ULL, 0x040fe200078e00ffULL, 0x0000888009707816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011408ULL,
0x0001000008307824ULL, 0x040fe200078e00ffULL, 0x00008880086f7816ULL, 0x040fe200000000ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000018ff657819ULL, 0x000fc4000001140aULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x000088800a6d7816ULL, 0x000fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000000900777306ULL, 0x0003e20000200c00ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff577819ULL, 0x004fe4000001142cULL,
0x000088802c677816ULL, 0x000fc400000000ffULL, 0x00000018ff567819ULL, 0x000fe2000001140bULL,
0x0000000800757306ULL, 0x0005e20000200c00ULL, 0x000100000b097824ULL, 0x042fe200078e00ffULL,
0x000088800b6b7816ULL, 0x040fe200000000ffULL, 0x000001000b0b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001142dULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000003000787306ULL, 0x000fe20000200c00ULL, 0x000100000a087824ULL, 0x044fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe2000001140bULL, 0x000001000a0a7824ULL, 0x000fe200078e00ffULL,
0x000088802d637816ULL, 0x000fc400000000ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x0000000900727306ULL, 0x0003e20000200c00ULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x00000018ff457819ULL, 0x000fe4000001142eULL, 0x00000018ff447819ULL, 0x000fe4000001142fULL,
0x000088802e617816ULL, 0x000fe200000000ffULL, 0x0000000a00767306ULL, 0x0005e20000200c00ULL,
0x0000000747097812ULL, 0x002fc400078e7842ULL, 0x0000000747477812ULL, 0x000fe400078e783eULL,
0x000088802f5a7816ULL, 0x000fc600000000ffULL, 0x0000003100737306ULL, 0x0003e20000200c00ULL,
0x00000008420a7824ULL, 0x004fe400078e0209ULL, 0x000100002d097824ULL, 0x040fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe400078e0243ULL, 0x000001002d2d7824ULL, 0x000fe200078e00ffULL,
0x0000000800747306ULL, 0x0005e20000200c00ULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x000000000a30783bULL, 0x002e640000000200ULL, 0x00000018ff2d7819ULL, 0x000fc8000001142dULL,
0x0000000b00717306ULL, 0x000fe20000200c00ULL, 0x000100002c087824ULL, 0x044fe400078e00ffULL,
0x000001002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002d00697306ULL, 0x000ff00000200c00ULL,
0x0000002c006e7306ULL, 0x0005f00000200c00ULL, 0x00000008006c7306ULL, 0x0007e20000200c00ULL,
0x000000083e2c7824ULL, 0x004fc800078e0247ULL, 0x000000102c0b7824ULL, 0x000fe400078e0243ULL,
0x000100002f2c7824ULL, 0x040fe200078e00ffULL, 0x00000009006a7306ULL, 0x000fe20000200c00ULL,
0x000100002e087824ULL, 0x048fe200078e00ffULL, 0x00000018ff467819ULL, 0x002fe20000011430ULL,
0x000001002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000001002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011431ULL,
0x00010000312d7824ULL, 0x000fe200078e00ffULL, 0x0000002c005d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fc4000001142eULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff547819ULL, 0x000fe4000001142dULL, 0x00008880304e7816ULL, 0x040fe200000000ffULL,
0x0000002e00647306ULL, 0x000fe20000200c00ULL, 0x00010000302c7824ULL, 0x042fe200078e00ffULL,
0x00008880314f7816ULL, 0x040fe200000000ffULL, 0x0000010030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011408ULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe2000001142cULL, 0x000000000b08783bULL, 0x000e620000000200ULL,
0x000000077a2c7812ULL, 0x000fe200078e7841ULL, 0x0000002f005f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff307819ULL, 0x000fc40000011430ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000010412c7824ULL, 0x000fe200078e022cULL, 0x00000018ff487819ULL, 0x000fe40000011432ULL,
0x0000888032527816ULL, 0x000fe200000000ffULL, 0x000000102c2c7824ULL, 0x000fe200078e00ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000027a7a7810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff497819ULL, 0x000fe40000011433ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000077a7a7812ULL, 0x000fc400078e7841ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000888033587816ULL, 0x000fe400000000ffULL, 0x00000010417a7824ULL, 0x000fca00078e027aULL,
0x0000003000537306ULL, 0x0009f00000200c00ULL, 0x0000003100507306ULL, 0x0007e20000200c00ULL,
0x0001000032307824ULL, 0x050fe400078e00ffULL, 0x0000010032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x002fc40000011408ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0001000033317824ULL, 0x048fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000010033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011409ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000597306ULL, 0x0007e20000200c00ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x00000018ff4d7819ULL, 0x000fe4000001140bULL, 0x00000018ff4c7819ULL, 0x000fc6000001140aULL,
0x00000031005b7306ULL, 0x0009e20000200c00ULL, 0x000054106f307816ULL, 0x008fce0000000078ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541075317816ULL, 0x010fe20000000068ULL,
0x0001000008687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x000000302c28723cULL, 0x004fee0000001828ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541070307816ULL, 0x002fc40000000073ULL,
0x0000541077317816ULL, 0x000fca0000000066ULL, 0x0000006b006b7306ULL, 0x000e640000200c00ULL,
0x000000302c24723cULL, 0x000fec0000001824ULL, 0x0000003200557306ULL, 0x0005e20000200c00ULL,
0x000054106d307816ULL, 0x008fe40000000074ULL, 0x0000541076317816ULL, 0x000fca0000000065ULL,
0x0000005700577306ULL, 0x000ee20000200c00ULL, 0x0000888008327816ULL, 0x044fe200000000ffULL,
0x000000302c20723cULL, 0x000fe20000001820ULL, 0x0000010008087824ULL, 0x000fca00078e00ffULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054106b307816ULL, 0x002fe40000000072ULL,
0x0000541071317816ULL, 0x000fe40000000056ULL, 0x00000018ff6d7819ULL, 0x000fe40000011408ULL,
0x0000888009087816ULL, 0x000fe200000000ffULL, 0x0000003200667306ULL, 0x0003e20000200c00ULL,
0x000054106e577816ULL, 0x008fe20000000057ULL, 0x000000302c1c723cULL, 0x000fec000000181cULL,
0x00000033005e7306ULL, 0x0007e20000200c00ULL, 0x000000107a327824ULL, 0x002fe200078e00ffULL,
0x0000541067567816ULL, 0x004fcc000000006cULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000000003230783bULL, 0x008e620000000200ULL, 0x000000562c04723cULL, 0x000fec0000001804ULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x0000010009567824ULL, 0x000fe200078e00ffULL,
0x000088800a577816ULL, 0x000fc800000000ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000004500457306ULL, 0x000ff00000200c00ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541069697816ULL, 0x004fce0000000060ULL, 0x0000006100617306ULL, 0x000ff00000200c00ULL,
0x0000006200627306ULL, 0x000eb00000200c00ULL, 0x0000005a005a7306ULL, 0x000ff00000200c00ULL,
0x0000006800657306ULL, 0x0007220000200c00ULL, 0x0000541061627816ULL, 0x004fe20000000062ULL,
0x000100000a617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0001000009687824ULL, 0x008fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541066667816ULL, 0x010fce0000000065ULL, 0x0000005100517306ULL, 0x000eb00000200c00ULL,
0x0000006800097306ULL, 0x0007f00000200c00ULL, 0x0000005600607306ULL, 0x0009e20000200c00ULL,
0x0000541063687816ULL, 0x008fc4000000006aULL, 0x0000541064637816ULL, 0x000fe20000000045ULL,
0x000000ffff457224ULL, 0x000fe200078e0057ULL, 0x000054105f577816ULL, 0x000fc60000000044ULL,
0x000000682c14723cULL, 0x040fe20000001814ULL, 0x000054105a567816ULL, 0x010fe2000000005dULL,
0x0000004800487306ULL, 0x000eec0000200c00ULL, 0x000000622c10723cULL, 0x040fe40000001810ULL,
0x0000004c004c7306ULL, 0x000fec0000200c00ULL, 0x000000562c0c723cULL, 0x000fe4000000180cULL,
0x0000000800087306ULL, 0x000f2a0000200c00ULL, 0x000054104e2c7816ULL, 0x004fe20000000051ULL,
0x000001000a2e7824ULL, 0x000fe200078e00ffULL, 0x00005410532d7816ULL, 0x000fe20000000046ULL,
0x000100000b2f7824ULL, 0x000fe200078e00ffULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000541055537816ULL, 0x008fc40000000048ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002c3028723cULL, 0x002fe20000001828ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000002e002d7306ULL, 0x000fe20000200c00ULL, 0x0000541008087816ULL, 0x010fc60000000009ULL,
0x000088800b2c7816ULL, 0x040fe200000000ffULL, 0x000001000b0b7824ULL, 0x000fc600078e00ffULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000541050477816ULL, 0x004fe40000000047ULL,
0x00000018ff0b7819ULL, 0x000fca000001140bULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000054105e497816ULL, 0x002fce0000000049ULL,
0x0000004d004d7306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541060097816ULL, 0x004fce000000004bULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000000083014723cULL, 0x000fee0000001814ULL, 0x0000005200527306ULL, 0x000eb00000200c00ULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x000054104f467816ULL, 0x002fce0000000054ULL,
0x0000006d006b7306ULL, 0x000e620000200c00ULL, 0x0000541052527816ULL, 0x004fe20000000059ULL,
0x000000463024723cULL, 0x040fec0000001824ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541058487816ULL, 0x008fe2000000005bULL, 0x000000523020723cULL, 0x040fec0000001820ULL,
0x00000061000a7306ULL, 0x000ea20000200c00ULL, 0x000054106b677816ULL, 0x002fe2000000004aULL,
0x00000048301c723cULL, 0x040fec000000181cULL, 0x0000002c002c7306ULL, 0x000fe40000200c00ULL,
0x000000663004723cULL, 0x000fec0000001804ULL, 0x0000002f002f7306ULL, 0x000e620000200c00ULL,
0x00005410450a7816ULL, 0x004fce000000000aULL, 0x0000000b002e7306ULL, 0x0004e20000200c00ULL,
0x000054102c2c7816ULL, 0x002fe4000000002fULL, 0x000054102d0b7816ULL, 0x004fe4000000004cULL,
0x000054102e2d7816ULL, 0x008fca000000004dULL, 0x0000000a3010723cULL, 0x040ff00000001810ULL,
0x0000002c300c723cULL, 0x000fe2000000180cULL, 0xfffff0f000000947ULL, 0x000fee000383ffffULL,
0x01b6140037097984ULL, 0x000e620000000800ULL, 0x0000002a36087220ULL, 0x000fc40000410000ULL,
0x00000025362a7220ULL, 0x040fe40000410000ULL, 0x0000000436257220ULL, 0x000fe20000410000ULL,
0x0000ffff3a047812ULL, 0x000fe200078ec0ffULL, 0x0000002b360a7220ULL, 0x040fe40000410000ULL,
0x00000026360b7220ULL, 0x000fe20000410000ULL, 0x0000888004337816ULL, 0x000fe200000000ffULL,
0x00000027362c7220ULL, 0x040fe40000410000ULL, 0x00000024362b7220ULL, 0x000fc40000410000ULL,
0x0000001c36277220ULL, 0x040fe40000410000ULL, 0x0000001d36267220ULL, 0x040fe40000410000ULL,
0x0000001e361e7220ULL, 0x040fe40000410000ULL, 0x8000000033047824ULL, 0x000fe400078e00ffULL,
0x0000001f361c7220ULL, 0x040fe40000410000ULL, 0x0000000536247220ULL, 0x000fc40000410000ULL,
0x00000017361d7220ULL, 0x040fe40000410000ULL, 0x00000022362e7220ULL, 0x040fe40000410000ULL,
0x0000002336307220ULL, 0x040fe40000410000ULL, 0x0000000636067220ULL, 0x040fe40000410000ULL,
0x0000000736077220ULL, 0x040fe40000410000ULL, 0x0000001636057220ULL, 0x000fc40000410000ULL,
0x0000001236317220ULL, 0x040fe20000410000ULL, 0x8000000009ff7812ULL, 0x002fe20007804804ULL,
0x0000001336327220ULL, 0x040fe40000410000ULL, 0x00000028362f7220ULL, 0x040fe40000410000ULL,
0x00000029362d7220ULL, 0x040fe40000410000ULL, 0x000000ffff167224ULL, 0x000fe400078e0008ULL,
0x0000002036297220ULL, 0x000fc40000410000ULL, 0x0000002136287220ULL, 0x040fe40000410000ULL,
0x0000001436237220ULL, 0x040fe40000410000ULL, 0x0000001536227220ULL, 0x040fe40000410000ULL,
0x000000ffff087224ULL, 0x000fe400078e001eULL, 0x0000001036217220ULL, 0x040fe40000410000ULL,
0x0000001136207220ULL, 0x000fc40000410000ULL, 0x0000000c361f7220ULL, 0x040fe40000410000ULL,
0x000000ffff157224ULL, 0x000fe400078e000aULL, 0x000000ffff147224ULL, 0x000fe400078e000bULL,
0x000000ffff137224ULL, 0x000fe400078e001cULL, 0x000000ffff1e7224ULL, 0x000fe400078e001dULL,
0x0000000d36177220ULL, 0x000fc40000410000ULL, 0x0000000e360e7220ULL, 0x040fe40000410000ULL,
0x0000000f360c7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e002cULL,
0x000000ffff0a7224ULL, 0x000fe400078e002eULL, 0x000000ffff097224ULL, 0x000fe400078e0030ULL,
0x000000ffff127224ULL, 0x000fc400078e0006ULL, 0x000000ffff117224ULL, 0x000fe400078e0007ULL,
0x000000ffff107224ULL, 0x000fe400078e0005ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0031ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0032ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000033067824ULL, 0x000fe400078e00ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01b6140037057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004350c7824ULL, 0x000fe200078e00ffULL, 0x000000395c00720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff00c0d7812ULL, 0x000fca00078ec0ffULL,
0x000000801a0d7824ULL, 0x000fca00078e020dULL, 0x01b400000d047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002352c7824ULL, 0x000fe400078e00ffULL,
0x00000001003d7824ULL, 0x000fc600078e0a3dULL, 0x000000062c2c7812ULL, 0x000fc800078ec0ffULL,
0x000000012c2e7812ULL, 0x040fe400078efcffULL, 0x000000082c307812ULL, 0x000fe400078efcffULL,
0x0000003d2e00720cULL, 0x080fe40003f26070ULL, 0x000000102c2e7812ULL, 0x000fe400078efcffULL,
0x0000003d3000720cULL, 0x080fe40003f06070ULL, 0x0000003d2e00720cULL, 0x000fc40003fc6070ULL,
0x000000112c307812ULL, 0x040fe400078efcffULL, 0x000000182c2e7812ULL, 0x040fe400078efcffULL,
0x0000003d2c00720cULL, 0x080fe40003f46070ULL, 0x0000003d3000720cULL, 0x080fe40003fa6070ULL,
0x0000003d2e00720cULL, 0x000fe40003f66070ULL, 0x000000092c327812ULL, 0x000fc400078efcffULL,
0x000000192c307812ULL, 0x040fe400078efcffULL, 0x000000202c2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40004800000ULL,
0x0000003d3200720cULL, 0x080fe40003f86070ULL, 0x0000003d3000720cULL, 0x080fe40003f46070ULL,
0x0000003d2e00720cULL, 0x000fe40003f26070ULL, 0x000000212c307812ULL, 0x040fe400078efcffULL,
0x000000282c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff14147808ULL, 0x000fc40004000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40006000000ULL, 0x0000003d3000720cULL, 0x080fe40003f06070ULL,
0x0000003d2e00720cULL, 0x000fe40003f86070ULL, 0x000000292c307812ULL, 0x000fc400078efcffULL,
0x000000302c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff29297808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff28287808ULL, 0x000fe40006800000ULL, 0x0000003d3000720cULL, 0x000fc40003fc6070ULL,
0x0000003d2e00720cULL, 0x000fe40003fa6070ULL, 0x000000312c307812ULL, 0x040fe400078efcffULL,
0x000000382c2e7812ULL, 0x040fe400078efcffULL, 0x000000392c2c7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff27277808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff26267808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff25257808ULL, 0x000fe40004800000ULL,
0x0000003d3000720cULL, 0x080fe40003f66070ULL, 0x0000003d2e00720cULL, 0x000fc40003f46070ULL,
0x0000003d2c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff24247808ULL, 0x000fe40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40006000000ULL,
0xff7fffff23237808ULL, 0x000fe40006000000ULL, 0xff7fffff1e1e7808ULL, 0x000fc40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL,
0xff7fffff20207808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002f04047209ULL, 0x004fe40007810000ULL, 0x00000016052c7209ULL, 0x000fe40007810000ULL,
0x0000002d04047209ULL, 0x000fe40007810000ULL, 0x000000152c057209ULL, 0x000fc40007810000ULL,
0x0000002b04317209ULL, 0x000fe40007810000ULL, 0x0000001405047209ULL, 0x000fe40007810000ULL,
0x0000002a312c7209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fe40007810000ULL,
0x000000292c317209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fc40007810000ULL,
0x00000028312c7209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000272c317209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x00000026312c7209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fc40007810000ULL,
0x000000252c317209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fe40007810000ULL,
0x00000024312c7209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x000000232c317209ULL, 0x000fe40007810000ULL, 0x0000001005057209ULL, 0x000fc40007810000ULL,
0x0000002231047209ULL, 0x000fe40007810000ULL, 0x0000001e052c7209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001d2c317209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001c312c7209ULL, 0x000fc40007810000ULL,
0x0000001f04047209ULL, 0x000fe40007810000ULL, 0x0000000f2c057209ULL, 0x000fe40007810000ULL,
0x00000017042e7209ULL, 0x000fe40007810000ULL, 0x0000000e05327209ULL, 0x000fe20007810000ULL,
0x00000e827f007947ULL, 0x000fea000b800000ULL, 0x0c401f002e047f89ULL, 0x0004e400000e0000ULL,
0x000000042e3d7209ULL, 0x008fe20007810000ULL, 0x00000ec27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072c7f89ULL, 0x000e6400000e0000ULL, 0x00000004322e7209ULL, 0x00efc40007810000ULL,
0x0c201f003d047f89ULL, 0x000e6200000e0000ULL, 0x0000000506307209ULL, 0x010fc60007810000ULL,
0x0c201f002e057f89ULL, 0x000ea200000e0000ULL, 0x0000002c072c7209ULL, 0x000fc60007810000ULL,
0x0c201f0030317f89ULL, 0x000ee800000e0000ULL, 0x0c201f002c337f89ULL, 0x00092200000e0000ULL,
0x000000043d047209ULL, 0x002fe40007810000ULL, 0x000000052e057209ULL, 0x004fe40007810000ULL,
0x0000003130067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b042e7820ULL, 0x002fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b05317820ULL, 0x000fe20000410000ULL,
0x0000000000067886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b20207823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL,
0x0000002000327308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b16167823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b15157823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b14147823ULL, 0x000fe20000010831ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b0b207823ULL, 0x002fe40000010831ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082eULL,
0x0000002d00307308ULL, 0x000e620000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b28287823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b22227823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b083d7823ULL, 0x100fe20000010831ULL, 0x0000002f3008723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b112f7823ULL, 0x100fe20000010831ULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b103f7823ULL, 0x100fe40000010831ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe40000010831ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fc60000010831ULL,
0x0000001500157308ULL, 0x000ff00000000800ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x00000020000b7308ULL, 0x0003300000000800ULL, 0x0000001f002d7308ULL, 0x0005e20000000800ULL,
0x3c003c00ff207424ULL, 0x002fce00078e00ffULL, 0x00000017002e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0a1f7823ULL, 0x104fe20000010831ULL, 0x0000002b2a0a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b122b7823ULL, 0x000fe20000010831ULL, 0x000000140b0b723eULL, 0x010fc800000000ffULL,
0x0000002100077308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b09177823ULL, 0x002fe20000010831ULL,
0x000000161509723eULL, 0x000fcc00000000ffULL, 0x00000017003e7308ULL, 0x0003e20000000800ULL,
0x3c003c00ff217424ULL, 0x004fce00078e00ffULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000200814723cULL, 0x002fee00000018ffULL, 0x0000002800287308ULL, 0x000e700000000800ULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000292810723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b1c287823ULL, 0x000fcc0000010831ULL,
0x0000001f001f7308ULL, 0x000e700000000800ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x000000272612723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1e267823ULL, 0x000fc40000010831ULL,
0x3fb8aa3b1d277823ULL, 0x000fc80000010831ULL, 0x00000013002a7308ULL, 0x000ea20000000800ULL,
0x0000001f3e11723eULL, 0x002fce00000000ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000003d2a13723eULL, 0x004fce00000000ffULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000201014723cULL, 0x000fee0000001814ULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x00000025241c723eULL, 0x002fce00000000ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002f00307308ULL, 0x000e620000000800ULL,
0x00000023221e723eULL, 0x004fce00000000ffULL, 0x0000003f003f7308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x0000002b301d723eULL, 0x002fce00000000ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x0000003f261f723eULL, 0x004fce00000000ffULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000201c40723cULL, 0x000fee0000001814ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc35147812ULL, 0x000fcc00078ec0ffULL, 0x0000000e000e7308ULL, 0x000ea20000000800ULL,
0x0000002d2e16723eULL, 0x000fe400000000ffULL, 0x0000001415247219ULL, 0x000fe400000006ffULL,
0x000000073214723eULL, 0x000fe400000000ffULL, 0x00000000242373a1ULL, 0x000ee200000e8000ULL,
0x00000000240573c4ULL, 0x000f220000004000ULL, 0x000000272815723eULL, 0x002fe400000000ffULL,
0x0000002c33077209ULL, 0x000fc40007810000ULL, 0x0000000f0e17723eULL, 0x004fce00000000ffULL,
0x000000201440723cULL, 0x000fe20000001840ULL, 0x0000000624ff7c12ULL, 0x008fda000f804023ULL,
0x00000ae205008947ULL, 0x010ff4000b800000ULL, 0x001c1fff40207589ULL, 0x0002a400000e0000ULL,
0x00000000240f73a1ULL, 0x000ee200000e8000ULL, 0x00000000240573c4ULL, 0x000f220000004000ULL,
0x0000000000067886ULL, 0x000fe400038e0100ULL, 0x0000000624ff7c12ULL, 0x008fda000f80400fULL,
0x00000b0205008947ULL, 0x010fea000b800000ULL, 0x001c1fff42217589ULL, 0x00072800000e0000ULL,
0x001c1fff01227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x0006a400000e0000ULL,
0x00000002ff0e7819ULL, 0x000fe40000011635ULL, 0x0000000c0c437812ULL, 0x000fc400078ec0ffULL,
0x000000070e0f7812ULL, 0x040fe200078ec0ffULL, 0x000000080e287824ULL, 0x040fe200078e00ffULL,
0x0000000eff267212ULL, 0x000fe200078e33ffULL, 0x000000080e247824ULL, 0x04afe200078e00ffULL,
0x0000000335ff7812ULL, 0x000fe2000780c0ffULL, 0x000000080e317824ULL, 0x040fe200078e00ffULL,
0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff828257812ULL, 0x100fe400078ee20fULL,
0x0000000124277812ULL, 0x100fe200078ef60fULL, 0x000000080e4d7824ULL, 0x000fe200078e00ffULL,
0x0000000224297812ULL, 0x100fe200078ef60fULL, 0x000000080e337824ULL, 0x000fe200078e00ffULL,
0x00000003242b7812ULL, 0x100fe200078ef60fULL, 0x000000080e3d7824ULL, 0x000fe200078e00ffULL,
0x00000004242d7812ULL, 0x000fc400078ef60fULL, 0x00000005242f7812ULL, 0x140fe400078ef60fULL,
0x00000006240f7812ULL, 0x000fe400078ef60fULL, 0xfffffff831317812ULL, 0x000fe400078ee226ULL,
0x0000000eff267212ULL, 0x000fe400078e33ffULL, 0x000000070e247812ULL, 0x000fe400078ec0ffULL,
0x000110001a0e7811ULL, 0x000fc400078e58ffULL, 0xfffffff833337812ULL, 0x100fe400078ee224ULL,
0x000000013d3f7812ULL, 0x000fe200078ef624ULL, 0x00000010250c7824ULL, 0x000fe200078e020eULL,
0x000000023d417812ULL, 0x000fe200078ef624ULL, 0x000000102b287824ULL, 0x000fe200078e020eULL,
0x000000033d457812ULL, 0x000fe200078ef624ULL, 0x000000100f2e7824ULL, 0x000fe200078e020eULL,
0x000000043d477812ULL, 0x000fe200078ef624ULL, 0x000000102d2a7824ULL, 0x000fe200078e020eULL,
0x000000053d497812ULL, 0x000fe200078ef624ULL, 0x00000001430f7824ULL, 0x000fe200078e020cULL,
0x000000063d4b7812ULL, 0x000fe200078ef624ULL, 0x0000001027247824ULL, 0x000fe200078e020eULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee226ULL, 0x0000001029267824ULL, 0x100fe200078e020eULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x000000102f2c7824ULL, 0x000fc400078e020eULL,
0x0000000143257824ULL, 0x040fe400078e0224ULL, 0x0000000143277824ULL, 0x000fe400078e0226ULL,
0x0000001031307824ULL, 0x000fe200078e020eULL, 0x0000000a25007388ULL, 0x0007e20000000800ULL,
0x0000000143297824ULL, 0x000fe400078e0228ULL, 0x00000010330c7824ULL, 0x000fe200078e020eULL,
0x0000001027007388ULL, 0x0007e20000000800ULL, 0x00000001432b7824ULL, 0x000fc400078e022aULL,
0x000000103f327824ULL, 0x000fe200078e020eULL, 0x0000001229007388ULL, 0x0007e20000000800ULL,
0x00000001432d7824ULL, 0x000fe400078e022cULL, 0x0000001041337824ULL, 0x000fe200078e020eULL,
0x0000001c2b007388ULL, 0x0007e20000000800ULL, 0x00000001432f7824ULL, 0x000fe400078e022eULL,
0x00000010453d7824ULL, 0x000fe200078e020eULL, 0x0000001e2d007388ULL, 0x0007e20000000800ULL,
0x0000000143317824ULL, 0x000fc400078e0230ULL, 0x00000010473e7824ULL, 0x000fe200078e020eULL,
0x000000142f007388ULL, 0x0007e20000000800ULL, 0x00000001430c7824ULL, 0x000fe400078e020cULL,
0x00000010493f7824ULL, 0x100fe200078e020eULL, 0x0000001631007388ULL, 0x0007e20000000800ULL,
0x000000104b407824ULL, 0x100fe400078e020eULL, 0x000000104d417824ULL, 0x000fe200078e020eULL,
0x000000090c007388ULL, 0x0007e20000000800ULL, 0x0000000143327824ULL, 0x000fc400078e0232ULL,
0x00000001430e7824ULL, 0x040fe400078e0233ULL, 0x0000000143087824ULL, 0x042fe200078e023dULL,
0x0000000b32007388ULL, 0x0007e20000000800ULL, 0x00000001433e7824ULL, 0x040fe400078e023eULL,
0x0000000143247824ULL, 0x040fe200078e023fULL, 0x000000110e007388ULL, 0x0007e20000000800ULL,
0x0000000143407824ULL, 0x040fe400078e0240ULL, 0x0000000143267824ULL, 0x000fe200078e0241ULL,
0x0000001308007388ULL, 0x0007e80000000800ULL, 0x0000001d3e007388ULL, 0x0007e80000000800ULL,
0x0000001f24007388ULL, 0x0007e80000000800ULL, 0x0000001540007388ULL, 0x0007e80000000800ULL,
0x0000001726007388ULL, 0x0007e80000000800ULL, 0x01b000040d008388ULL, 0x0007e80000000c00ULL,
0x01b200200d008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000033c00720cULL, 0x000fe20003f26070ULL, 0x01b6080037ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3aff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff5c7224ULL, 0x000fc400078e003cULL,
0x000000ffff057224ULL, 0x008fe200078e003bULL, 0x00000001ff3a7807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffbd3000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e002eULL,
0x00011c80002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000079000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff317224ULL, 0x004fe200078e0032ULL, 0xffff8b2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e002dULL, 0x00011cf0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e0032ULL,
0xffff8ad000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x00011d6000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xfffff12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x006fe200078e0032ULL, 0x00011de000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x000005f000007944ULL, 0x020fea0003c00000ULL,
0x0000003332327209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0006ULL,
0x00011e5000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0007ULL, 0x00011ec000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x00000033072c7209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e003dULL,
0x00011f3000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x000000333d047209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0032ULL, 0x00011fa000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000003332057209ULL, 0x004fe20007810000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0006ULL,
0x0001201000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e002cULL, 0x0001208000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0xffffef0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x000fe200078e0040ULL,
0x000120f0002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff3d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e0024ULL,
0x0000032000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0032ULL,
0xfffff4b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x002fe200078e0042ULL,
0x00012170002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e0024ULL,
0x000002a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e00ffULL,
0x000121d0002e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe400078e0024ULL, 0x000000ffff217224ULL, 0x004fe400078e0032ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff407224ULL, 0x002fe200078e0024ULL,
0x00012230002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0032ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0032ULL,
0xfffff3f000007947ULL, 0x000fea000383ffffULL, 0x0180000004007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004047812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x006fe400078e0006ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffedc3004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0c0000332e337389ULL, 0x0002a200000e003eULL,
0xfffedbf030007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0000003e33327389ULL, 0x0002a200000e003dULL,
0xfffedbb02e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000200ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000798ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000810ULL, 0x0000000000000500ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d30ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d60ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000dd8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000012500ULL, 0xc700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013500ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013510ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013510ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013990ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000dd0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012730ULL, 0x0000000000012730ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013500ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013990ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin_len = 80496;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
