/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019ac0ULL, 0x0000000000019740ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017b30ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000017cb0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017cf0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017d40ULL, 0x0000000000000140ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017e80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00017b3000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x005d380400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00017b3000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL, 0xaa08288080a80828ULL,
0x288080f108288080ULL, 0x808808288080f208ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080889200ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00017cb000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x8080a508288080a2ULL, 0xaa08288080a90828ULL, 0x288080f108288080ULL, 0x80a808288080f208ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080a89200ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x00017cf000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x8080a508288080a2ULL, 0xaa08288080a80828ULL, 0x288080f108288080ULL, 0x80a908288080f208ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080a99200ULL, 0x0000002cffffffffULL,
0x0000026000000000ULL, 0x00017d4000000000ULL, 0x0000014000000000ULL, 0x0000080400000000ULL,
0x80aa288080a90900ULL, 0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000d6ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x0000001600080a04ULL,
0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL,
0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x019c2804ffffffffULL, 0x0000034000000170ULL, 0x00002c80000005a0ULL, 0x00002e4000002d30ULL,
0x0000312000002fb0ULL, 0x0000370000003280ULL, 0x0000375000003740ULL, 0x0000597000003780ULL,
0x00005b2000005a00ULL, 0x00005e0000005c90ULL, 0x000063e000005f60ULL, 0x0000643000006420ULL,
0x0000844000006460ULL, 0x00008600000084e0ULL, 0x000088e000008770ULL, 0x00008ea000008a40ULL,
0x00008ef000008ee0ULL, 0x0000aed000008f20ULL, 0x0000b0800000af70ULL, 0x0000b3600000b1f0ULL,
0x0000b9400000b4c0ULL, 0x0000b9900000b980ULL, 0x0000ce300000b9c0ULL, 0x0000ce500000ce40ULL,
0x000158700000ce60ULL, 0x000158c0000158b0ULL, 0x00015920000158d0ULL, 0x0001596000015940ULL,
0x00016cb000015970ULL, 0x00016d5000016d00ULL, 0x00016dd000016d90ULL, 0x00016e6000016e10ULL,
0x00016f0000016eb0ULL, 0x00016fa000016f50ULL, 0x0001704000016ff0ULL, 0x000170c000017080ULL,
0x0001715000017100ULL, 0x000171f0000171a0ULL, 0x0001729000017240ULL, 0x00017330000172e0ULL,
0x000173b000017370ULL, 0x00017440000173f0ULL, 0x000174e000017490ULL, 0x0001758000017530ULL,
0x00017620000175d0ULL, 0x000176a000017660ULL, 0x00017730000176e0ULL, 0x000177d000017780ULL,
0x0001787000017820ULL, 0x00017930000178d0ULL, 0x000179f000017990ULL, 0x00017ab000017a50ULL,
0x0440390400017b10ULL, 0x000000ff00000430ULL, 0x003f010000012600ULL, 0x0000000f00000470ULL,
0x003f012000012608ULL, 0x0000000f000004f0ULL, 0x003f012000012688ULL, 0x0000000f00000510ULL,
0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL, 0x000000ff00000ed0ULL,
0x003f010700012600ULL, 0x00000002000010c0ULL, 0x003f010200000004ULL, 0x0000000200001170ULL,
0x003f010100000000ULL, 0x000000ff00001ae0ULL, 0x0004010700000000ULL, 0x000000ff00001b60ULL,
0x0004010100000000ULL, 0x0000000600001bc0ULL, 0x003f0101000126c8ULL, 0x0000000800001d50ULL,
0x003f0105000126ccULL, 0x0000000800001f30ULL, 0x003f0105000126ccULL, 0x0000000a00002870ULL,
0x003f0107000126b0ULL, 0x0000000a00002920ULL, 0x003f0101000126b0ULL, 0x0000002200002980ULL,
0x003f010100012608ULL, 0x00000022000029a0ULL, 0x003f01050001260cULL, 0x0000002200002b70ULL,
0x003f01050001260cULL, 0x0000000a00003430ULL, 0x003f0105000126acULL, 0x0000000a00003620ULL,
0x003f0105000126acULL, 0x0000006c00004b30ULL, 0x003f010100000000ULL, 0x0000002500004b90ULL,
0x003f010100012688ULL, 0x0000001300004bc0ULL, 0x003f010500000004ULL, 0x0000001300004d80ULL,
0x003f010500000004ULL, 0x0000001000005570ULL, 0x003f010700000000ULL, 0x0000001000005650ULL,
0x003f010100000000ULL, 0x00000022000056b0ULL, 0x003f010100012628ULL, 0x00000022000056d0ULL,
0x003f01050001262cULL, 0x00000022000058a0ULL, 0x003f01050001262cULL, 0x0000006e00006150ULL,
0x003f0105000126b4ULL, 0x0000006e00006320ULL, 0x003f0105000126b4ULL, 0x0000006e000075e0ULL,
0x003f010100000000ULL, 0x0000002800007640ULL, 0x003f010100012690ULL, 0x0000001300007670ULL,
0x003f010500000004ULL, 0x0000001300007830ULL, 0x003f010500000004ULL, 0x000000ff00008030ULL,
0x0004010700000008ULL, 0x0000002a00008120ULL, 0x003f0101000126b0ULL, 0x0000002200008180ULL,
0x003f010100012648ULL, 0x00000022000081a0ULL, 0x003f01050001264cULL, 0x0000002200008370ULL,
0x003f01050001264cULL, 0x0000001000008c10ULL, 0x003f010500000004ULL, 0x0000001000008de0ULL,
0x003f010500000004ULL, 0x000000130000a080ULL, 0x003f010100000000ULL, 0x000000020000a0e0ULL,
0x003f010100012698ULL, 0x000000130000a110ULL, 0x003f010500000004ULL, 0x000000130000a2d0ULL,
0x003f010500000004ULL, 0x000000ff0000ab30ULL, 0x0004010700000000ULL, 0x000000100000abc0ULL,
0x003f010100000000ULL, 0x000000060000ac20ULL, 0x003f010100012668ULL, 0x000000060000ac50ULL,
0x003f01050001266cULL, 0x000000060000ae20ULL, 0x003f01050001266cULL, 0x0000000a0000b6a0ULL,
0x003f0105000126b4ULL, 0x0000000a0000b870ULL, 0x003f0105000126b4ULL, 0x000000130000cbe0ULL,
0x003f010100000000ULL, 0x000000060000cc60ULL, 0x003f010100000000ULL, 0x000000ff0000ee80ULL,
0x003f010100012600ULL, 0x000000ff0000fae0ULL, 0x003f010500012604ULL, 0x000000ff0000fcf0ULL,
0x003f010500012604ULL, 0x000000ff00010070ULL, 0x003f010100012600ULL, 0x000000ff000100a0ULL,
0x003f010500012604ULL, 0x000000ff00010260ULL, 0x003f010500012604ULL, 0x0000006600012b10ULL,
0x003f010100000000ULL, 0x0000006600012bd0ULL, 0x003f010500000004ULL, 0x0000006600012da0ULL,
0x003f010500000004ULL, 0x0000006a00016b10ULL, 0x003f010100000000ULL, 0x0000006a00016b70ULL,
0x003f010100000008ULL, 0x0000006a00016bd0ULL, 0x003f010100000010ULL, 0x0000006a00016c40ULL,
0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000dd900000dd60ULL, 0x0000e2200000e030ULL,
0x0000e6000000e410ULL, 0x0000e9e00000e7f0ULL, 0x0000ed900000ebe0ULL, 0x00016c80000102c0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002fcULL, 0x0000001900000002ULL,
0x000000000000023cULL, 0x0000001900000002ULL, 0x000000000000018cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x00000000000002d9ULL, 0x0000001900000002ULL, 0x0000000000000219ULL, 0x0000001900000002ULL,
0x0000000000000169ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606190981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000001e7919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000e7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff1f7819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff1f1f7589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x008fc800078e0a05ULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000307077227ULL, 0x000fe400078e0006ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000001e07207227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a20ULL, 0x0000000005007224ULL, 0x000fca00078e021eULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x000001000e037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0e0e7589ULL, 0x000e6400000e0000ULL, 0x00000000030f7a24ULL, 0x000fd000078e020aULL,
0x0000000100005824ULL, 0x000fe200078e0a05ULL, 0x0000000120205810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000050000720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000030f00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0f00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000120206810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x00000005ff20c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a20ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x00000000051e7224ULL, 0x000fc400078e021eULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x000000201e1e7824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff12a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x012688060f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe80000008a00ULL,
0x012400120f00a388ULL, 0x000fe80000004800ULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000119190824ULL, 0x004fe400078e0a02ULL, 0x00005800ff198624ULL, 0x000fc400078e00ffULL,
0x0000580004028a24ULL, 0x000fe400078e02ffULL, 0x00005a0019037a24ULL, 0x000fe400078e02ffULL,
0x0000001102777224ULL, 0x000fe400078e02ffULL, 0x0000000103007824ULL, 0x040fe200078e0a1eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001e0300720cULL, 0x000fe20003f26070ULL,
0x00005a0020127a24ULL, 0x000fe200078e0277ULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff00767207ULL, 0x000fe20000800000ULL, 0x000000040e007824ULL, 0x002fc600078e021fULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x00000000001d7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc8000001161dULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe03077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x000000011e0c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07037227ULL, 0x000fc800078e0006ULL, 0x000000011e067824ULL, 0x000fe400078e020aULL,
0x0000000c030d7227ULL, 0x000fc800078e00ffULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a07ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL,
0x00005a0003037a24ULL, 0x000fe400078e0206ULL, 0x00005a000f087a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x0000000076037217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x040fe20004000000ULL, 0x000000101d037824ULL, 0x000fe200078e00ffULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000000500720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a08ULL, 0x000000f003057812ULL, 0x000fe200078ec0ffULL,
0x00005a000d067a24ULL, 0x000fe400078e0206ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000112067824ULL, 0x040fe400078e0206ULL, 0x00000001120d7824ULL, 0x000fc400078e020cULL,
0x0000001107067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x000000010a007824ULL, 0x100fe200078e021dULL,
0x0000000508057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x0000600006067a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e021dULL,
0x0000600005087a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d007812ULL, 0x000fe400078ee200ULL, 0x0000610007077a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000610009097a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x00000000001d7919ULL, 0x000eae0000000000ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x000000001d007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe03067810ULL, 0x002fe20007ffe0ffULL,
0x000000011e037824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x000000011e077824ULL, 0x000fe400078e020aULL, 0x0000000308057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006067a24ULL, 0x000fe400078e0203ULL,
0x00005a000c097a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x0000000108082810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff067a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000000108083810ULL, 0x000fe40007ffe0ffULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000806087207ULL, 0x000fc60004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006037a24ULL, 0x000fe400078e0203ULL,
0x00005a000c077a24ULL, 0x000fe400078e0207ULL, 0x0000000112067824ULL, 0x040fe400078e0203ULL,
0x0000000112077824ULL, 0x000fc400078e0207ULL, 0x000000101d037824ULL, 0x000fe400078e00ffULL,
0x0000001105067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe200078e0207ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fc600078efcffULL,
0x0000000100057824ULL, 0x100fe200078e021dULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a007824ULL, 0x000fe200078e021dULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x0000610007077a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00b007812ULL, 0x000fe200078ee200ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000057300ULL, 0x000e7000000e0000ULL, 0x0000000000077309ULL, 0x000ea20000000000ULL,
0x000000060500720cULL, 0x002fe20003f02070ULL, 0x000000ffff057224ULL, 0x004fc400078e0a07ULL,
0x0000680004067625ULL, 0x000fd400078e002dULL, 0x01260405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006061c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000007f1c1b7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1c057810ULL, 0x002fc40007ffe0ffULL,
0x00000007ff1b7819ULL, 0x000fe4000001161bULL, 0x00000008ff1a7819ULL, 0x000fca0000011605ULL,
0x0000dd9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe2000001161fULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x000126881f027811ULL, 0x000fe200078e18ffULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x01ffffff19197812ULL, 0x000fc800078ec0ffULL,
0x0000001b1900720cULL, 0x000fda0003f06070ULL, 0x0000000204008824ULL, 0x000fe400078e00ffULL,
0x00006a00ff078624ULL, 0x000fc800078e00ffULL, 0x00006a0000008624ULL, 0x000fc800078e0207ULL,
0x0000000119008824ULL, 0x000fe200078e0200ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040902ff738cULL, 0x0003e20000000000ULL, 0x0000660000068625ULL, 0x000fe200078e002dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606248981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000008020177824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001161fULL, 0x0000000002ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011f007812ULL, 0x000fc600078ec0ffULL, 0x0000002018807824ULL, 0x000fca00078e00ffULL,
0x0000006017057812ULL, 0x000fe200078ef880ULL, 0x0000590024087a24ULL, 0x004fc800078e02ffULL,
0x0000008008157824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x10afe2000001161dULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x000000801c077217ULL, 0x000fe40007800000ULL, 0x0000000402097810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0202ULL, 0x00006400150f7a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe400078e0a80ULL, 0x0000000106087824ULL, 0x040fe200078e021dULL,
0x0000650015157a11ULL, 0x000fe200020f3cffULL, 0x00000008060b7824ULL, 0x000fe200078e00ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x0000000105067824ULL, 0x000fc600078e0206ULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x0000000c020b7810ULL, 0x040fe40007ffe0ffULL,
0x000000070200720cULL, 0x080fe20003f66070ULL, 0x00000001000a7824ULL, 0x000fe200078e0208ULL,
0x000000070800720cULL, 0x080fe20003f26070ULL, 0x0000000100027824ULL, 0x000fe200078e0209ULL,
0x000000070900720cULL, 0x080fe20003f46070ULL, 0x000000010a087824ULL, 0x040fe200078e021dULL,
0x000000070b00720cULL, 0x000fe20003f06070ULL, 0x000000080a0d7824ULL, 0x000fc400078e00ffULL,
0x00000001000c7824ULL, 0x000fe400078e020bULL, 0x0000000102007824ULL, 0x040fe200078e021dULL,
0xfffffff80d107812ULL, 0x000fe200078ee208ULL, 0x0000000802097824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff809007812ULL, 0x000fe200078ee200ULL,
0x0000000105087824ULL, 0x040fe200078e0202ULL, 0x0000007006067812ULL, 0x000fe200078ef803ULL,
0x00000001050a7824ULL, 0x040fe400078e020aULL, 0x00000001050d7824ULL, 0x000fe200078e020cULL,
0x000000060f067210ULL, 0x000fe20007f9e0ffULL, 0x000000010c027824ULL, 0x040fe400078e021dULL,
0x000000080c057824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff805127812ULL, 0x000fe200078ee202ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008027812ULL, 0x000fc600078ef803ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef803ULL, 0x0000000107077824ULL, 0x000fe200020e0615ULL,
0x000000700c0a7812ULL, 0x000fe400078ef803ULL, 0x0000e00018037811ULL, 0x000fe400078e68ffULL,
0x0000000f02027210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e057824ULL, 0x100fe200078e0203ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0203ULL, 0x0000001010117824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000d901c46ULL,
0x0000001012137824ULL, 0x000fe400078e0203ULL, 0x0000000109037824ULL, 0x100fe400020e0615ULL,
0x000000010b097824ULL, 0x100fe400028e0615ULL, 0x000000010d0b7824ULL, 0x000fe200030e0615ULL,
0x00000000020f7faeULL, 0x0003e8000d101c46ULL, 0x0000000008117faeULL, 0x0003e8000c901c46ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x008fe200078e00ffULL, 0x0000640015117a11ULL, 0x000fc400078038ffULL,
0x0000e00018137811ULL, 0x000fe400078e68ffULL, 0x000000001d007211ULL, 0x000fe400078fe8ffULL,
0x0000650015157a11ULL, 0x000fe400000f3cffULL, 0x00000008000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x042fe200078e021dULL, 0x0000000400087810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080a107824ULL, 0x000fc400078e00ffULL,
0x0000000105067824ULL, 0x000fe200078e0200ULL, 0xfffffff8070e7812ULL, 0x000fe200078ee202ULL,
0x000000010a077824ULL, 0x100fe200078e021dULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000108027824ULL, 0x040fe400078e021dULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000000105087824ULL, 0x040fe200078e0208ULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x00000001050a7824ULL, 0x040fe400078e020aULL,
0x00000001050c7824ULL, 0x000fe200078e0200ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x0000000100027824ULL, 0x040fe400078e021dULL, 0x0000000800057824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff805007812ULL, 0x000fe200078ee202ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008027812ULL, 0x000fc600078ef803ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x000fc600078ef803ULL,
0x0000000107077824ULL, 0x000fe200000e0615ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x000000100e057824ULL, 0x100fe200078e0213ULL, 0x0000000211027210ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0213ULL, 0x0000000811087210ULL, 0x040fe40007f3e0ffULL,
0x00000003110a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000109037824ULL, 0x000fe200000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc400078e0213ULL, 0x000000010b097824ULL, 0x000fe200008e0615ULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x0000001000137824ULL, 0x000fe400078e0213ULL,
0x000000010d0b7824ULL, 0x000fe200010e0615ULL, 0x0000000008117faeULL, 0x0003e8000b901c46ULL,
0x000000000a137faeULL, 0x0003e4000b901c46ULL, 0x00000000180473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x0000000818067824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff027f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80006067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000b03000008947ULL, 0x000fea0003800000ULL, 0x0000000204167824ULL, 0x000fe200078e00ffULL,
0x00000002ff157819ULL, 0x000fe2000001161fULL, 0x00006a00ff057624ULL, 0x000fe200078e00ffULL,
0x0000000118757812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x00006a0016167624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x0000000000047805ULL, 0x01afca0000015200ULL,
0x000000041f067824ULL, 0x000fca00078e00ffULL, 0xfffffff806087812ULL, 0x000fc800078ec0ffULL,
0x000126c808137810ULL, 0x000fe20007ffe0ffULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f037824ULL, 0x000fe200078e00ffULL,
0x0000000114077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024297824ULL, 0x000fe200078e00ffULL,
0x0000001a0700720cULL, 0x000fc60003f46070ULL, 0x0000010014057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001170b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d087824ULL, 0x000fe200078e00ffULL,
0x000000051c037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161dULL,
0x0000007008277812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021dULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000640029257a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a247824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021dULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000650029297a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000027040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a250a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021dULL, 0x0000002706067212ULL, 0x000fe200078efcffULL,
0x0000000808227824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0224ULL,
0x0000002708087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0629ULL,
0x0000002506067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000f00018037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0629ULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x0000000124237824ULL, 0x000fe200078e021dULL,
0x0000002704047212ULL, 0x000fe200078efcffULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0629ULL, 0x0000002504047210ULL, 0x000fe20007fde0ffULL,
0x0000001012257824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee223ULL,
0x0000001010237824ULL, 0x000fc400078e0203ULL, 0x0000001022277824ULL, 0x100fe400078e0203ULL,
0x0000001024037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a237faeULL, 0x0003e2000e901c46ULL, 0x0000000105057824ULL, 0x000fc600030e0629ULL,
0x0000000006257faeULL, 0x0003e8000e101c46ULL, 0x0000000008277faeULL, 0x0003e8000d901c46ULL,
0x0000000004037faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d097824ULL, 0x000fe200078e00ffULL,
0x0000640029257a11ULL, 0x000fc400078038ffULL, 0x000000041d047211ULL, 0x000fe400078fe8ffULL,
0x0000007009237812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021dULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000650029297a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x040fe400078e021dULL, 0x0000000806107824ULL, 0x000fe200078e00ffULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000108077824ULL, 0x000fe200078e021dULL,
0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000808127824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fc400078e0204ULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x000000010b087824ULL, 0x040fe200078e0208ULL,
0x0000002304047212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe400078e020aULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000425047210ULL, 0x000fc60007f1e0ffULL,
0x000000010a227824ULL, 0x000fe200078e021dULL, 0x0000002306067212ULL, 0x000fe200078efcffULL,
0x000000080a277824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000002308087212ULL, 0x080fe400078efcffULL, 0x0000f00018277811ULL, 0x000fe200078e68ffULL,
0x0000000105057824ULL, 0x000fe200000e0629ULL, 0x000000230a0a7212ULL, 0x000fe400078efcffULL,
0x0000000625067210ULL, 0x000fe20007f1e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0227ULL,
0x0000000825087210ULL, 0x040fe20007f7e0ffULL, 0x0000001010237824ULL, 0x000fe200078e0227ULL,
0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x0000001012257824ULL, 0x000fc400078e0227ULL, 0x0000000109097824ULL, 0x000fe200018e0629ULL,
0x0000000006237faeULL, 0x0003e2000b901c46ULL, 0x0000001022277824ULL, 0x000fe400078e0227ULL,
0x000000010b0b7824ULL, 0x000fe200020e0629ULL, 0x0000000008257faeULL, 0x0003e8000b901c46ULL,
0x000000000a277faeULL, 0x0003e4000b901c46ULL, 0x000000081f037824ULL, 0x002fe200078e00ffULL,
0x0000000119047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001b0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000116048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660004048625ULL, 0x000fca00078e0005ULL, 0x0000000604248981ULL, 0x000522000c1e1900ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101d127824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe2000001161dULL,
0x000000201f037824ULL, 0x000fe400078e00ffULL, 0xffffffffff817424ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c74747812ULL, 0x000fc800078ec0ffULL, 0x0000000374037210ULL, 0x000fca0007ffe012ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003047984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x000140127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e0002ULL, 0x0000001fff837424ULL, 0x000fe400078e00ffULL,
0xffffffffff827424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001f1500720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f74000ULL,
0x00013fb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f078824ULL, 0x000fe200078e0212ULL, 0x0000000205237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174108824ULL, 0x000fca00078e0207ULL,
0x0124002310008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000223027221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000221217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x00013ef27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x00013dc27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x00013c927f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x00013b727f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fda00078030ffULL, 0x8000002305050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500110308ULL, 0x000e640000000800ULL, 0x0000001104040220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002104217221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x008fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e620000000800ULL,
0x000126a80a107810ULL, 0x000fe40007ffe0ffULL, 0x8000000005ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001161dULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000137327f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x000137627f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000137b27f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021f257824ULL, 0x000fe200078e00ffULL, 0x000000081d027812ULL, 0x000fe200078ec0ffULL,
0x000000041f067824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000000425007812ULL, 0x00afc400078ec0ffULL,
0x00000007020b7812ULL, 0x000fe200078ef81dULL, 0x000004001f027824ULL, 0x000fe200078e00ffULL,
0x000000001d047211ULL, 0x000fe400078fe0ffULL, 0x000000100b097812ULL, 0x040fe200078efcffULL,
0x000000080b037824ULL, 0x040fe200078e00ffULL, 0x0000000406067812ULL, 0x000fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e0204ULL, 0xfffff000027d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x000000061d027211ULL, 0x000fe200078fe0ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x000010001f037824ULL, 0x000fe200078e00ffULL, 0x0000a0007d7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fc400078ee208ULL,
0xffffe00003057812ULL, 0x000fe200078ec0ffULL, 0x000000010b037824ULL, 0x000fe400078e0202ULL,
0x000000100a6c7824ULL, 0x100fe200078e027dULL, 0x0000e00005057810ULL, 0x000fe20007ffe0ffULL,
0x0000001008287824ULL, 0x000fe200078e027dULL, 0xfffffff804077812ULL, 0x000fc600078ee203ULL,
0x000000006c6c783bULL, 0x000e640000000200ULL, 0x0000001007787824ULL, 0x000fe400078e0205ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x086fe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fe40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000080b717824ULL, 0x000fe200078e00ffULL,
0x0000000203067810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x0000000200007812ULL, 0x000fe200078efcffULL, 0x000008e000007945ULL, 0x000fe20003800000ULL,
0xfffffff871067812ULL, 0x000fc400078ee206ULL, 0x000000001d007211ULL, 0x000fc600078fe0ffULL,
0x0000001006707824ULL, 0x000fcc00078e0205ULL, 0x000000007070783bULL, 0x000ea20000004200ULL,
0x00000018ff7e7819ULL, 0x008fe4000001147bULL, 0x00000018ff037819ULL, 0x000fe40000011478ULL,
0x00000018ff047819ULL, 0x000fe20000011479ULL, 0x0000007e008a7306ULL, 0x0007e20000200c00ULL,
0x00000018ff057819ULL, 0x000fce000001147aULL, 0x00000003007c7306ULL, 0x0003e20000200c00ULL,
0x00000100797e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x004fe20000011470ULL,
0x00000100708c7824ULL, 0x040fe200078e00ffULL, 0x00008880708b7816ULL, 0x040fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000010072937824ULL, 0x000fe200078e00ffULL, 0x0000000400847306ULL, 0x0005e20000200c00ULL,
0x0000888078037816ULL, 0x002fe200000000ffULL, 0x00000100718d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fc40000011470ULL, 0x00000018ff857819ULL, 0x000fe40000011471ULL,
0x00000018ff867819ULL, 0x000fe20000011472ULL, 0x0000000500877306ULL, 0x0003e20000200c00ULL,
0x0000010078047824ULL, 0x044fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011473ULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x0000888073957816ULL, 0x000fe400000000ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007f008e7306ULL, 0x0005e20000200c00ULL, 0x0000888079057816ULL, 0x002fc400000000ffULL,
0x0000888072927816ULL, 0x040fe200000000ffULL, 0x0001000072727824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x0000000500057306ULL, 0x000fe20000200c00ULL, 0x00010000797f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff7f7819ULL, 0x000fc4000001147fULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000007800797306ULL, 0x0005f00000200c00ULL, 0x00000070008f7306ULL, 0x0006e20000200c00ULL,
0x000001007b787824ULL, 0x004fe200078e00ffULL, 0x0000541005057816ULL, 0x002fc8000000007eULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000000300037306ULL, 0x000fe20000200c00ULL,
0x0000010073707824ULL, 0x048fe400078e00ffULL, 0x0001000073737824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000000400047306ULL, 0x000e620000200c00ULL,
0x000054108f8e7816ULL, 0x000fce000000008eULL, 0x0000008500907306ULL, 0x0005f00000200c00ULL,
0x0000008600947306ULL, 0x0007e20000200c00ULL, 0x000088807a857816ULL, 0x004fe400000000ffULL,
0x0000541003047816ULL, 0x002fca0000000004ULL, 0x0000008800967306ULL, 0x0003e20000200c00ULL,
0x000001007a867824ULL, 0x048fe200078e00ffULL, 0x000000046c2c723cULL, 0x000f62000000182cULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x0000007800897306ULL, 0x0005e20000200c00ULL, 0x000088807b887816ULL, 0x042fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x00000004284c723cULL, 0x000b66000000184cULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x00000070007e7306ULL, 0x0003e20000200c00ULL, 0x0000888071787816ULL, 0x044fe200000000ffULL,
0x0001000071717824ULL, 0x000fc400078e00ffULL, 0x000000010b057824ULL, 0x120fe400078e0200ULL,
0x0000000109047824ULL, 0x000fe200078e0200ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x0000541079707816ULL, 0x002fe2000000007cULL,
0x0000000109007824ULL, 0x000fe200078e0202ULL, 0x00000018ff797819ULL, 0x000fca0000011473ULL,
0x0000009300937306ULL, 0x000e700000200c00ULL, 0x0000009500957306ULL, 0x000eb00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541092927816ULL, 0x002fce0000000093ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541095937816ULL, 0x004fce000000007eULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000000926c44723cULL, 0x080f6e0000001844ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x000000922864723cULL, 0x000f6e0000001864ULL,
0x0000007a007a7306ULL, 0x000eb00000200c00ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x0000541088737816ULL, 0x002fce0000000089ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000054107a7a7816ULL, 0x004fce0000000087ULL, 0x0000008c008c7306ULL, 0x000e620000200c00ULL,
0x000054107b7b7816ULL, 0x008fce000000008aULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000007a6c38723cULL, 0x080f6e0000001838ULL, 0x0000008d008d7306ULL, 0x000ea20000200c00ULL,
0x000054108b8c7816ULL, 0x002fe2000000008cULL, 0x0000007a2858723cULL, 0x000f6c0000001858ULL,
0x0000007100917306ULL, 0x0002f00000200c00ULL, 0x0000007200037306ULL, 0x0006e20000200c00ULL,
0x000054107f717816ULL, 0x002fc40000000084ULL, 0x00005410788d7816ULL, 0x004fca000000008dULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x0000541085727816ULL, 0x008fe20000000086ULL,
0x000000706c30723cULL, 0x000f620000001830ULL, 0x00005410918f7816ULL, 0x000fe40000000090ULL,
0x0000541003947816ULL, 0x000fe20000000094ULL, 0x0000000809037824ULL, 0x000fc800078e00ffULL,
0x000000726c34723cULL, 0x000f620000001834ULL, 0xfffffff803047812ULL, 0x000fe400078ee204ULL,
0x0000541079957816ULL, 0x002fca0000000096ULL, 0x0000008c6c3c723cULL, 0x000f62000000183cULL,
0x0000e00018037811ULL, 0x000fce00078e68ffULL, 0x0000008e6c40723cULL, 0x040f700000001840ULL,
0x000000946c48723cULL, 0x000b6e0000001848ULL, 0x000000080b6c7824ULL, 0x020fe200078e00ffULL,
0x000000702850723cULL, 0x000f620000001850ULL, 0x00000008096d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c057812ULL, 0x000fe400078ee205ULL, 0xfffffff86d027812ULL, 0x000fe400078ee200ULL,
0x000000722854723cULL, 0x040f620000001854ULL, 0x00000010056c7824ULL, 0x100fe400078e027dULL,
0x00000010047d7824ULL, 0x000fe400078e027dULL, 0x0000001002787824ULL, 0x000fe400078e0203ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000008c285c723cULL, 0x040f70000000185cULL,
0x0000008e2860723cULL, 0x040f700000001860ULL, 0x000000942868723cULL, 0x000b640000001868ULL,
0x000000007d28783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f6c6c7232ULL, 0x082fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809717824ULL, 0x000fe200078e00ffULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff871007812ULL, 0x000fca00078ee200ULL, 0x0000001000707824ULL, 0x000fcc00078e0203ULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x00000018ff7c7819ULL, 0x004fe40000011478ULL,
0x00000018ff7d7819ULL, 0x000fe40000011479ULL, 0x0000007c007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147aULL, 0x00000018ff847819ULL, 0x000fca000001147bULL,
0x0000007d00867306ULL, 0x0003e20000200c00ULL, 0x00008880787c7816ULL, 0x004fe200000000ffULL,
0x00000100708e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011470ULL,
0x00000100718f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011471ULL,
0x0000010073997824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011472ULL,
0x0000007f00897306ULL, 0x0005e20000200c00ULL, 0x00000100787d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00008880708d7816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00000084008c7306ULL, 0x0003e20000200c00ULL, 0x00008880797f7816ULL, 0x004fe400000000ffULL,
0x0000888072957816ULL, 0x000fe400000000ffULL, 0x0000888073977816ULL, 0x040fe200000000ffULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000008500907306ULL, 0x0005e20000200c00ULL, 0x0000010079847824ULL, 0x002fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fc4000001148eULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0001000079857824ULL, 0x004fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fc80000011499ULL,
0x00000018ff857819ULL, 0x000fe40000011485ULL, 0x0000007800797306ULL, 0x0003f00000200c00ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x000001007b787824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008700937306ULL, 0x0003f00000200c00ULL,
0x00000078008b7306ULL, 0x0007e20000200c00ULL, 0x000088807a877816ULL, 0x002fce00000000ffULL,
0x0000008800987306ULL, 0x0003e20000200c00ULL, 0x0000888071787816ULL, 0x048fe200000000ffULL,
0x0001000071717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000007800927306ULL, 0x0007e20000200c00ULL, 0x000001007a887824ULL, 0x042fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x0000008a009a7306ULL, 0x0003e20000200c00ULL, 0x0000010072787824ULL, 0x048fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0001000072727824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000007000917306ULL, 0x0004e20000200c00ULL, 0x000088807b8a7816ULL, 0x042fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007800967306ULL, 0x0003e20000200c00ULL, 0x000054107c707816ULL, 0x004fce000000007dULL,
0x00000099007c7306ULL, 0x000fe20000200c00ULL, 0x0000541079787816ULL, 0x002fe4000000007eULL,
0x00000018ff7e7819ULL, 0x000fe40000011473ULL, 0x0000541091907816ULL, 0x008fc60000000090ULL,
0x0000007f007f7306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000008700877306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x0000541085797816ULL, 0x002fce0000000086ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x000000782850723cULL, 0x080f6e0000001850ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x000000786c30723cULL, 0x000f6e0000001830ULL,
0x0000007b007b7306ULL, 0x000ee20000200c00ULL, 0x000054108a737816ULL, 0x002fce000000008bULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054107a7a7816ULL, 0x004fce0000000089ULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x000054107b7b7816ULL, 0x008fce000000008cULL,
0x0000008f008f7306ULL, 0x000ea20000200c00ULL, 0x0000007a2858723cULL, 0x080f6e0000001858ULL,
0x0000007100947306ULL, 0x0006a20000200c00ULL, 0x000054108d8e7816ULL, 0x002fe2000000008eULL,
0x0000007a6c38723cULL, 0x000f6c0000001838ULL, 0x0000009500957306ULL, 0x000e620000200c00ULL,
0x000054107f717816ULL, 0x008fc40000000084ULL, 0x00005410928f7816ULL, 0x004fca000000008fULL,
0x0000009700977306ULL, 0x000ea20000200c00ULL, 0x0000541094917816ULL, 0x000fe20000000093ULL,
0x00000070284c723cULL, 0x040f6c000000184cULL, 0x00000072007d7306ULL, 0x0006a20000200c00ULL,
0x0000541095967816ULL, 0x002fe20000000096ULL, 0x0000008e285c723cULL, 0x040f6c000000185cULL,
0x0000007e00997306ULL, 0x000e620000200c00ULL, 0x0000541087727816ULL, 0x008fe20000000088ULL,
0x000000902860723cULL, 0x000f620000001860ULL, 0x0000541097977816ULL, 0x004fc4000000007cULL,
0x000054107d987816ULL, 0x000fca0000000098ULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x0000541099997816ULL, 0x002fce000000009aULL, 0x000000962864723cULL, 0x040f700000001864ULL,
0x000000982868723cULL, 0x000f700000001868ULL, 0x000000706c2c723cULL, 0x040f70000000182cULL,
0x000000726c34723cULL, 0x040f700000001834ULL, 0x0000008e6c3c723cULL, 0x040f70000000183cULL,
0x000000906c40723cULL, 0x040f700000001840ULL, 0x000000966c44723cULL, 0x040f700000001844ULL,
0x000000986c48723cULL, 0x000b6e0000001848ULL, 0x000126c8186c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040013257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040013257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f257824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe025297812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x0000010014297824ULL, 0x000fca00078e0229ULL,
0x0000008029297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000117707824ULL, 0x000fe200078e0228ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000001025727812ULL, 0x000fe400078ec0ffULL, 0x000000291c257217ULL, 0x000fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe4000001161dULL, 0x0000640024717a11ULL, 0x000fe200078838ffULL,
0x0000000125257824ULL, 0x000fe200078e0a29ULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b287824ULL, 0x040fe200078e0272ULL, 0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002572257217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x040fe200078e021dULL,
0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828787824ULL, 0x000fe200078e00ffULL,
0x0000650024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a797824ULL, 0x000fe200078e0272ULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x00000001792a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7a7824ULL, 0x000fe200078e0272ULL, 0x00000012286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a6c7824ULL, 0x000fe200078e0270ULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x000000017b727824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x0000000172287824ULL, 0x000fe200078e0270ULL,
0x000000126c6c7212ULL, 0x000fe200078efcffULL, 0x00000001296f7824ULL, 0x000fe200028e0673ULL,
0x000000257b00720cULL, 0x000fe20003fa6070ULL, 0x0000000179707824ULL, 0x040fe400078e021dULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff879707812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x080fe20007fde0ffULL, 0x000000017a257824ULL, 0x100fe200078e021dULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000087a7a7824ULL, 0x000fe400078e00ffULL,
0x0000000172797824ULL, 0x040fe400078e021dULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001078257824ULL, 0x000fe200078e0203ULL,
0xfffffff87c787812ULL, 0x000fe200078ee279ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c46ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x000000002a717faeULL, 0x0003e8000d901c46ULL,
0x000000006c737faeULL, 0x0003e8000e101c46ULL, 0x0000000028797faeULL, 0x0003e2000e901c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001025287812ULL, 0x000fc800078ec0ffULL,
0x000000281d257211ULL, 0x000fc800078fe8ffULL, 0x00000004252b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000125297824ULL, 0x040fe200078e021dULL, 0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000825727824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x100fe400078e0270ULL,
0x000000012b2a7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000000012b257824ULL, 0x000fc400078e021dULL, 0x000000016d6f7824ULL, 0x100fe400078e021dULL,
0x00000001296c7824ULL, 0x040fe400078e0270ULL, 0x00000001292b7824ULL, 0x040fe400078e021dULL,
0x00000008297a7824ULL, 0x000fe400078e00ffULL, 0x000000086d7c7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0270ULL,
0xfffffff878707812ULL, 0x000fe200078ee225ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff87a787812ULL, 0x000fe400078ee22bULL, 0x0000640024257a11ULL, 0x000fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000650024717a11ULL, 0x000fc400000f3cffULL, 0x0000002825287210ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e0203ULL, 0x000000122a2a7212ULL, 0x080fe200078efcffULL,
0x000000107a797824ULL, 0x000fe200078e0203ULL, 0x000000126c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0671ULL, 0x000000126e6e7212ULL, 0x000fe400078efcffULL,
0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL, 0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL,
0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL, 0x000000012b2b7824ULL, 0x000fe400018e0671ULL,
0x0000001072257824ULL, 0x000fe400078e0203ULL, 0x000000016d6d7824ULL, 0x100fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000b901c46ULL, 0x0000001070717824ULL, 0x000fca00078e0203ULL,
0x000000002a717faeULL, 0x0003e8000b901c46ULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x000000006e797faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800226e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01262c0022257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c0022257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201f257824ULL, 0x000fca00078e00ffULL,
0xffffff8025257812ULL, 0x000fc800078ec0ffULL, 0x0000008012257810ULL, 0x000fca0007ffe025ULL,
0x0000000174257824ULL, 0x000fca00078e0225ULL, 0x01200000256e7984ULL, 0x000e680000000800ULL,
0x0122000025707984ULL, 0x0006a20000000800ULL, 0x000000236e00720bULL, 0x002fe20003f1d000ULL,
0x000116127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000115287810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x0000001f2800720cULL, 0x000fe20003f05270ULL, 0x000115d27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x000000236e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000236e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x000115027f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000113d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000112a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000111827f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6f7424ULL, 0x000fe200078e00ffULL,
0x000000236e237209ULL, 0x000fd60007810000ULL, 0x800000236e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff6f0816ULL, 0x000fc6000000006fULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000e640000000800ULL, 0x0000001170700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002170217221ULL, 0x004fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x000000081f257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106f257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x00010d427f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x00010d727f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x00010dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x000004001f257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000010001f267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0000b00025277810ULL, 0x000fe40007ffe0ffULL,
0x0000f00026257810ULL, 0x000fc60007ffe0ffULL, 0x000000100a707824ULL, 0x100fe400078e0227ULL,
0x0000001008287824ULL, 0x000fe400078e0227ULL, 0x00000010077c7824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707232ULL, 0x084fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x088fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x082fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001006787824ULL, 0x008fe200078e0225ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000018ff6e7819ULL, 0x008fc4000001147eULL, 0x00000018ff6f7819ULL, 0x000fe4000001147fULL,
0x0000006e008b7306ULL, 0x0007e20000200c00ULL, 0x00000018ff857819ULL, 0x010fe20000011478ULL,
0x0000010079917824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe4000001147cULL,
0x00000018ff267819ULL, 0x000fe4000001147dULL, 0x00000018ff867819ULL, 0x000fe20000011479ULL,
0x0000006f008e7306ULL, 0x0009e20000200c00ULL, 0x000088807d6e7816ULL, 0x008fc400000000ffULL,
0x00000018ff877819ULL, 0x000fe4000001147aULL, 0x00000018ff897819ULL, 0x000fe4000001147bULL,
0x00000018ff937819ULL, 0x000fe20000011491ULL, 0x0000008500907306ULL, 0x000fe20000200c00ULL,
0x000001007d6f7824ULL, 0x010fe200078e00ffULL, 0x0000888079927816ULL, 0x040fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x000088807b997816ULL, 0x000fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001146fULL, 0x0000006e00857306ULL, 0x0007e20000200c00ULL,
0x00000018ff797819ULL, 0x000fce0000011479ULL, 0x0000002500847306ULL, 0x0009e20000200c00ULL,
0x000001007e6e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000002600887306ULL, 0x0007e20000200c00ULL, 0x000088807c257816ULL, 0x010fce00000000ffULL,
0x0000008600947306ULL, 0x000fe20000200c00ULL, 0x000001007c267824ULL, 0x048fe400078e00ffULL,
0x000100007c7c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000006f00867306ULL, 0x0007e20000200c00ULL, 0x00000018ff7c7819ULL, 0x000fce000001147cULL,
0x0000006e008a7306ULL, 0x0009e20000200c00ULL, 0x000088807f6f7816ULL, 0x008fce00000000ffULL,
0x0000006f008c7306ULL, 0x0007e20000200c00ULL, 0x00008880786e7816ULL, 0x010fce00000000ffULL,
0x0000008700987306ULL, 0x0009e20000200c00ULL, 0x00000100786f7824ULL, 0x048fe400078e00ffULL,
0x0001000078787824ULL, 0x000fc600078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x000100007d877824ULL, 0x010fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fc80000011478ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000007c007d7306ULL, 0x0007f00000200c00ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x000001007f7c7824ULL, 0x008fc400078e00ffULL, 0x000100007f7f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007800917306ULL, 0x0007220000200c00ULL,
0x00000018ff7f7819ULL, 0x000fce000001147fULL, 0x00000089009a7306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x048fe400078e00ffULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007c008d7306ULL, 0x000fe20000200c00ULL,
0x000088807e897816ULL, 0x044fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x0000541091907816ULL, 0x010fc80000000090ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000006e008f7306ULL, 0x0005f00000200c00ULL, 0x0000006f007c7306ULL, 0x0007220000200c00ULL,
0x000088807a6e7816ULL, 0x004fce00000000ffULL, 0x0000006e00967306ULL, 0x0005e20000200c00ULL,
0x000001007a6f7824ULL, 0x048fe400078e00ffULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000009900997306ULL, 0x000fe20000200c00ULL, 0x00005410256e7816ULL, 0x004fe40000000026ULL,
0x000054108f7c7816ULL, 0x010fca000000007cULL, 0x0000007800267306ULL, 0x0005f00000200c00ULL,
0x0000006f00977306ULL, 0x0007220000200c00ULL, 0x000054107d787816ULL, 0x004fe40000000084ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147bULL, 0x000054108c7b7816ULL, 0x000fc6000000008dULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x00005410856f7816ULL, 0x008fce0000000086ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541096967816ULL, 0x010fe20000000097ULL,
0x0000006e702c723cULL, 0x000f62000000182cULL, 0x0000541099977816ULL, 0x000fca0000000026ULL,
0x0000007e007e7306ULL, 0x000ea40000200c00ULL, 0x000000967044723cULL, 0x000f6c0000001844ULL,
0x0000007f007f7306ULL, 0x000ee40000200c00ULL, 0x0000006e284c723cULL, 0x042f6c000000184cULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x000054107e7e7816ULL, 0x004fe2000000008bULL,
0x000000962864723cULL, 0x000f6c0000001864ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000054107f7f7816ULL, 0x008fce000000008eULL, 0x0000007900957306ULL, 0x0002a20000200c00ULL,
0x0000007e7038723cULL, 0x080f6e0000001838ULL, 0x0000007a00257306ULL, 0x0007220000200c00ULL,
0x0000541087797816ULL, 0x002fe20000000088ULL, 0x0000007e2858723cULL, 0x000f6c0000001858ULL,
0x0000007d00857306ULL, 0x0002620000200c00ULL, 0x00005410897a7816ULL, 0x008fe2000000008aULL,
0x000000787030723cULL, 0x000f620000001830ULL, 0x0000541095917816ULL, 0x004fc40000000094ULL,
0x0000541025987816ULL, 0x010fe40000000098ULL, 0x00005410927d7816ULL, 0x002fc60000000093ULL,
0x0000007a7034723cULL, 0x000f620000001834ULL, 0x0000100003257810ULL, 0x000fe40007ffe0ffULL,
0x0000541085997816ULL, 0x000fc6000000009aULL, 0x0000001002267824ULL, 0x000fe400078e0225ULL,
0x0000007c703c723cULL, 0x040f70000000183cULL, 0x000000907040723cULL, 0x040f700000001840ULL,
0x000000987048723cULL, 0x000b6e0000001848ULL, 0x0000001005707824ULL, 0x120fe200078e0227ULL,
0x000000782850723cULL, 0x000f620000001850ULL, 0x0000001004277824ULL, 0x000fc800078e0227ULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000007c285c723cULL, 0x040f70000000185cULL, 0x000000902860723cULL, 0x040f700000001860ULL,
0x000000982868723cULL, 0x000b640000001868ULL, 0x000000002728783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x082fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000267c783bULL, 0x000f220000004200ULL,
0x0000001000787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000ea40000004200ULL,
0x00000018ff277819ULL, 0x014fe4000001147cULL, 0x00000018ff6e7819ULL, 0x000fe4000001147dULL,
0x0000002700847306ULL, 0x0005e20000200c00ULL, 0x00000018ff857819ULL, 0x000fe4000001147fULL,
0x00000018ff6f7819ULL, 0x000fe2000001147eULL, 0x00000100788e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe20000011479ULL, 0x0000010079917824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011478ULL, 0x0000006e00887306ULL, 0x0009e20000200c00ULL,
0x000088807c277816ULL, 0x004fe200000000ffULL, 0x000001007a967824ULL, 0x000fe200078e00ffULL,
0x00008880788d7816ULL, 0x040fe200000000ffULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fc4000001147aULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x00000085008c7306ULL, 0x0005e20000200c00ULL, 0x000001007c6e7824ULL, 0x050fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe40000011491ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000001007d857824ULL, 0x004fe200078e00ffULL,
0x0000006f008b7306ULL, 0x0005e20000200c00ULL, 0x00008880798f7816ULL, 0x040fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x000088807a957816ULL, 0x040fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fc40000011485ULL,
0x000088807b977816ULL, 0x000fe200000000ffULL, 0x0000008700937306ULL, 0x0009e20000200c00ULL,
0x000088807d6f7816ULL, 0x044fe400000000ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ff967819ULL, 0x000fe40000011496ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008600907306ULL, 0x000fe20000200c00ULL, 0x000100007d877824ULL, 0x010fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc8000001147aULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000007c007d7306ULL, 0x0005f00000200c00ULL, 0x0000008500867306ULL, 0x0009e20000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x000088807f857816ULL, 0x050fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000002700277306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000f220000200c00ULL,
0x000054106f6f7816ULL, 0x004fce0000000086ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x00005410276e7816ULL, 0x010fce000000006eULL,
0x0000007800917306ULL, 0x0005220000200c00ULL, 0x0000006e702c723cULL, 0x082f6e000000182cULL,
0x0000008900987306ULL, 0x0003e20000200c00ULL, 0x000001007b787824ULL, 0x044fe200078e00ffULL,
0x0000006e284c723cULL, 0x008b62000000184cULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008a00997306ULL, 0x0005e20000200c00ULL,
0x000088807e897816ULL, 0x002fe400000000ffULL, 0x0000541091907816ULL, 0x010fe40000000090ULL,
0x000126c8186e7811ULL, 0x020fc600078e18ffULL, 0x0000007800867306ULL, 0x0003e20000200c00ULL,
0x000001007e8a7824ULL, 0x044fe400078e00ffULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054107d787816ULL, 0x002fe40000000084ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147bULL, 0x00005410857b7816ULL, 0x000fc6000000007cULL,
0x0000008900897306ULL, 0x000ff00000200c00ULL, 0x0000008a008a7306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000eb00000200c00ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054107e7e7816ULL, 0x002fce000000008bULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x000054107f7f7816ULL, 0x004fce000000008cULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000007e7038723cULL, 0x080f6e0000001838ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054108d8e7816ULL, 0x002fe2000000008eULL,
0x0000007e2858723cULL, 0x000f6c0000001858ULL, 0x0000007900947306ULL, 0x0002f00000200c00ULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x0000541087797816ULL, 0x002fc40000000088ULL,
0x000054108f8f7816ULL, 0x004fca0000000092ULL, 0x0000009600967306ULL, 0x000e620000200c00ULL,
0x0000541094917816ULL, 0x008fe20000000093ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000009700977306ULL, 0x000ea40000200c00ULL, 0x0000008e703c723cULL, 0x040f6c000000183cULL,
0x0000007a00277306ULL, 0x0007220000200c00ULL, 0x0000541095967816ULL, 0x002fe20000000096ULL,
0x000000907040723cULL, 0x000f6c0000001840ULL, 0x0000007d007c7306ULL, 0x000e620000200c00ULL,
0x00005410897a7816ULL, 0x008fe2000000008aULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000541097977816ULL, 0x004fc40000000086ULL, 0x0000541027987816ULL, 0x010fe20000000098ULL,
0x000000021f277824ULL, 0x000fc800078e00ffULL, 0x0000007a7034723cULL, 0x000f620000001834ULL,
0x000054107c997816ULL, 0x002fce0000000099ULL, 0x000000967044723cULL, 0x040f700000001844ULL,
0x000000987048723cULL, 0x000f700000001848ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000008e285c723cULL, 0x040f70000000185cULL, 0x000000902860723cULL, 0x040f700000001860ULL,
0x000000962864723cULL, 0x040f700000001864ULL, 0x000000982868723cULL, 0x000b6e0000001868ULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400132b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28717210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000712a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400132b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010014277824ULL, 0x000fca00078e0280ULL, 0x000000c027297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000117727824ULL, 0x000fe200078e0228ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x000000101f2a7824ULL, 0x000fe200078e00ffULL,
0x000000291c287217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161dULL,
0x000000102a737812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a29ULL,
0x00000004706e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008707c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000170787824ULL, 0x100fe200078e0273ULL, 0x0000002873287217ULL, 0x000fe20007800000ULL,
0x000000016e7a7824ULL, 0x000fe200078e0273ULL, 0x0000640024797a11ULL, 0x000fe200078038ffULL,
0x0000000178297824ULL, 0x000fc400078e0272ULL, 0x0000000128717824ULL, 0x100fe200078e0a73ULL,
0x00006500247b7a11ULL, 0x000fe200000f3cffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000c70247810ULL, 0x000fe40007ffe0ffULL, 0x000000716e00720cULL, 0x080fe20003f66070ULL,
0x000000017a2a7824ULL, 0x000fe200078e0272ULL, 0x00000012286e7212ULL, 0x000fe200078efcffULL,
0x000000017c7d7824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL,
0x000000717c00720cULL, 0x000fe20003f06070ULL, 0x000000017d287824ULL, 0x000fe200078e0272ULL,
0x000000122a707212ULL, 0x000fe200078efcffULL, 0x00000001247c7824ULL, 0x000fe400078e0273ULL,
0x00000001296f7824ULL, 0x000fe200028e067bULL, 0x0000007970707210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000712400720cULL, 0x000fc60003fa6070ULL,
0x000000017c2a7824ULL, 0x000fe200078e0272ULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000012b717824ULL, 0x000fe400030e067bULL, 0x0000000178247824ULL, 0x000fe200078e021dULL,
0x0000007928287210ULL, 0x000fe20007fde0ffULL, 0x0000000878737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff873247812ULL, 0x000fe200078ee224ULL,
0x000000017a727824ULL, 0x100fe200078e021dULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x000000087a7f7824ULL, 0x000fe400078e00ffULL, 0x000000017d737824ULL, 0x140fe400078e021dULL,
0x000000087d787824ULL, 0x000fe200078e00ffULL, 0xfffffff87f727812ULL, 0x000fe200078ee272ULL,
0x000000017c7a7824ULL, 0x040fe400078e021dULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x0000000129297824ULL, 0x000fe200030e067bULL,
0x000000792a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001024737824ULL, 0x100fe200078e0225ULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001072797824ULL, 0x000fc400078e0225ULL,
0x000000012b2b7824ULL, 0x000fe200030e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e737faeULL, 0x0003e2000e101c46ULL, 0x00000010787b7824ULL, 0x100fe400078e0225ULL,
0x000000107a7d7824ULL, 0x000fe200078e0225ULL, 0x0000000070797faeULL, 0x0003e8000d901c46ULL,
0x00000000287b7faeULL, 0x0003e8000c101c46ULL, 0x000000002a7d7faeULL, 0x0003e2000e901c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000101f287824ULL, 0x000fe200078e00ffULL,
0x0000640024737a11ULL, 0x000fc800078038ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000650024797a11ULL, 0x000fe400000f3cffULL, 0x000000281d297211ULL, 0x000fc800078fe8ffULL,
0x00000004292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x140fe200078e021dULL,
0x0000000c29717810ULL, 0x040fe20007ffe0ffULL, 0x00000008296f7824ULL, 0x040fe400078e00ffULL,
0x0000000129287824ULL, 0x000fe400078e0272ULL, 0x000000082b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x000fe200078e0272ULL,
0x00000008296f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fc400078e021dULL,
0x0000000171707824ULL, 0x100fe400078e0272ULL, 0x000000016f6e7824ULL, 0x040fe200078e0272ULL,
0xfffffff87a727812ULL, 0x000fe200078ee229ULL, 0x000000016f2b7824ULL, 0x140fe400078e021dULL,
0x000000086f7c7824ULL, 0x000fe400078e00ffULL, 0x00000001716f7824ULL, 0x040fe400078e021dULL,
0x00000008717e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000007328287210ULL, 0x080fe40007f1e0ffULL,
0x000000122a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126e6e7212ULL, 0x080fe400078efcffULL, 0x000000732a2a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0679ULL, 0x0000001270707212ULL, 0x000fe200078efcffULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200018e0679ULL, 0x0000007370707210ULL, 0x000fe20007f9e0ffULL,
0x0000001078737824ULL, 0x000fc400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0679ULL,
0x0000000171717824ULL, 0x000fe200020e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028737faeULL, 0x0003e2000b901c46ULL, 0x0000001072797824ULL, 0x100fe400078e0225ULL,
0x000000107c7d7824ULL, 0x000fc600078e0225ULL, 0x000000002a797faeULL, 0x0003e8000b901c46ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c46ULL, 0x00000000707d7faeULL, 0x0003e4000b901c46ULL,
0x0000000219197810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001b1900720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x0000000119288824ULL, 0x000fe400078e0216ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000660028288625ULL, 0x000fca00078e0029ULL, 0x0000000628248981ULL, 0x000322000c1e1900ULL,
0x000000081f2a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01264c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201f227824ULL, 0x000fca00078e00ffULL, 0xffffff8022297812ULL, 0x000fc800078ec0ffULL,
0x0000010012297810ULL, 0x000fca0007ffe029ULL, 0x0000000174297824ULL, 0x000fca00078e0229ULL,
0x0120000029707984ULL, 0x000e680000000800ULL, 0x0122000029727984ULL, 0x0004e20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x0000ee327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000215227810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f74000ULL,
0x0000001f2200720cULL, 0x000fe20003f05270ULL, 0x0000ede27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x0000002370288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x0000ed127f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x0000ebe27f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x0000eab27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x0000e9927f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff737424ULL, 0x000fe200078e00ffULL,
0x0000002370227209ULL, 0x000fd60007810000ULL, 0x8000002270700221ULL, 0x000fe20000010000ULL,
0x00007610ff730816ULL, 0x000fc60000000073ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x008fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991073237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000e5727f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x0000e5a27f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x0000e5f27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x000004001f237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000010077c7824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0000c00023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707232ULL, 0x08cfe40000000000ULL, 0x0000000f72727232ULL, 0x000fe40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x0000001006787824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000018ff087819ULL, 0x002fe2000001147dULL,
0x000100007f8c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001147eULL,
0x0000000800877306ULL, 0x0003e20000200c00ULL, 0x00000018ff067819ULL, 0x000fe4000001147cULL,
0x00000018ff857819ULL, 0x008fe20000011479ULL, 0x00000100788e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001147fULL, 0x000001007a947824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011478ULL, 0x0000006c00887306ULL, 0x0007e20000200c00ULL,
0x000001007c087824ULL, 0x002fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fc4000001147aULL,
0x00000018ff897819ULL, 0x000fe4000001147bULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000006000a7306ULL, 0x0003e20000200c00ULL, 0x000088807d6c7816ULL, 0x008fe400000000ffULL,
0x000088807f8a7816ULL, 0x000fe400000000ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000008500927306ULL, 0x000fe20000200c00ULL,
0x000088807c067816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fc80000011494ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000006d008d7306ULL, 0x000ff00000200c00ULL, 0x0000006c00857306ULL, 0x0003f00000200c00ULL,
0x00000008006d7306ULL, 0x0007e20000200c00ULL, 0x000001007e6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000008400907306ULL, 0x0003e20000200c00ULL,
0x000088807e087816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008600987306ULL, 0x0007e20000200c00ULL,
0x000001007d847824ULL, 0x002fca00078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x00000089009a7306ULL, 0x000fe20000200c00ULL, 0x000100007d867824ULL, 0x008fca00078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x0000000600067306ULL, 0x000ff00000200c00ULL,
0x0000007c007d7306ULL, 0x0003f00000200c00ULL, 0x0000006c00897306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007e007f7306ULL, 0x0002a20000200c00ULL, 0x00008880786c7816ULL, 0x048fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x00000100797e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000006c008f7306ULL, 0x0003e20000200c00ULL,
0x000054107f887816ULL, 0x004fce0000000088ULL, 0x0000007800917306ULL, 0x0004e20000200c00ULL,
0x000088807a6c7816ULL, 0x042fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000007c008b7306ULL, 0x0003e20000200c00ULL,
0x000088807b787816ULL, 0x004fce00000000ffULL, 0x0000007e00937306ULL, 0x0005e20000200c00ULL,
0x00008880797c7816ULL, 0x042fe200000000ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x0000541091907816ULL, 0x008fc80000000090ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000006c00967306ULL, 0x0003e20000200c00ULL, 0x000001007b7e7824ULL, 0x044fe400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000000800087306ULL, 0x000fe20000200c00ULL, 0x00005410066c7816ULL, 0x002fe2000000006dULL,
0x000000ffff067224ULL, 0x000fe200078e0078ULL, 0x000054107d787816ULL, 0x000fe4000000000aULL,
0x00000018ff0a7819ULL, 0x000fe4000001147bULL, 0x00005410856d7816ULL, 0x000fe20000000084ULL,
0x0000008e008e7306ULL, 0x000e6c0000200c00ULL, 0x0000006c702c723cULL, 0x080f64000000182cULL,
0x0000009400977306ULL, 0x000eac0000200c00ULL, 0x0000006c284c723cULL, 0x000f64000000184cULL,
0x0000007a00997306ULL, 0x0006a20000200c00ULL, 0x000054108f8e7816ULL, 0x002fce000000008eULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x00005410087a7816ULL, 0x008fe40000000089ULL,
0x0000541096967816ULL, 0x004fca0000000097ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x0000541099987816ULL, 0x000fce0000000098ULL, 0x0000008c008c7306ULL, 0x000eb00000200c00ULL,
0x0000007c007c7306ULL, 0x000ee20000200c00ULL, 0x000054108a7b7816ULL, 0x002fce000000008bULL,
0x0000007900957306ULL, 0x0002e20000200c00ULL, 0x000054108c897816ULL, 0x004fe2000000008dULL,
0x0000007a7034723cULL, 0x040f6c0000001834ULL, 0x0000000600067306ULL, 0x000fe20000200c00ULL,
0x0000541086797816ULL, 0x002fe20000000087ULL, 0x000000887038723cULL, 0x000f620000001838ULL,
0x000054107c8f7816ULL, 0x008fe20000000093ULL, 0x00000010027c7824ULL, 0x000fc800078e0203ULL,
0x0000007e007d7306ULL, 0x000e620000200c00ULL, 0x0000541095917816ULL, 0x000fe20000000092ULL,
0x000000787030723cULL, 0x040f6c0000001830ULL, 0x0000000a00857306ULL, 0x000ea40000200c00ULL,
0x0000008e703c723cULL, 0x000f62000000183cULL, 0x0000541006977816ULL, 0x002fce000000007dULL,
0x000000907040723cULL, 0x000f620000001840ULL, 0x0000541085997816ULL, 0x004fce000000009aULL,
0x000000967044723cULL, 0x040f700000001844ULL, 0x000000987048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0223ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004237824ULL, 0x000fc800078e0223ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x000000882858723cULL, 0x040f700000001858ULL,
0x0000008e285c723cULL, 0x040f70000000185cULL, 0x000000902860723cULL, 0x040f700000001860ULL,
0x000000962864723cULL, 0x040f700000001864ULL, 0x000000982828723cULL, 0x000b640000001868ULL,
0x000000002368783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f70707232ULL, 0x082fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x080fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d68687232ULL, 0x088fe40000000000ULL,
0x0000000d6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000c69697232ULL, 0x080fe40000000000ULL,
0x0000000c6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001000787824ULL, 0x000fe200078e0203ULL, 0x000000007c7c783bULL, 0x000e6a0000004200ULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x00000018ff0a7819ULL, 0x002fe2000001147fULL,
0x000001007e867824ULL, 0x000fe200078e00ffULL, 0x00000018ff007819ULL, 0x000fc4000001147cULL,
0x00000018ff027819ULL, 0x000fe2000001147dULL, 0x0000000a008a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff087819ULL, 0x000fe2000001147eULL, 0x00000100788c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011479ULL, 0x00000018ff6d7819ULL, 0x000fe4000001147aULL,
0x00000018ff237819ULL, 0x000fe20000011478ULL, 0x0000000000067306ULL, 0x0005e20000200c00ULL,
0x000001007d0a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fc4000001147bULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000000200847306ULL, 0x0003e20000200c00ULL, 0x000088807c007816ULL, 0x004fe400000000ffULL,
0x00000018ff8c7819ULL, 0x000fca000001148cULL, 0x0000000800887306ULL, 0x0005e20000200c00ULL,
0x000001007c027824ULL, 0x042fe400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff027819ULL, 0x000fe40000011402ULL, 0x0000006c00907306ULL, 0x0003e20000200c00ULL,
0x000088807d087816ULL, 0x004fe400000000ffULL, 0x00000018ff7c7819ULL, 0x000fca000001147cULL,
0x0000006d00947306ULL, 0x000fe20000200c00ULL, 0x000100007d6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000000800087306ULL, 0x000ff00000200c00ULL,
0x0000000a006d7306ULL, 0x0002b00000200c00ULL, 0x00000023008e7306ULL, 0x000fe20000200c00ULL,
0x000088807f0a7816ULL, 0x002fce00000000ffULL, 0x0000008500967306ULL, 0x000fe20000200c00ULL,
0x00005410086d7816ULL, 0x004fe2000000006dULL, 0x000001007b087824ULL, 0x000fca00078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000000000007306ULL, 0x000ff00000200c00ULL,
0x0000000200237306ULL, 0x0003f00000200c00ULL, 0x0000006c00857306ULL, 0x0005e20000200c00ULL,
0x000088807e027816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008600877306ULL, 0x0003e20000200c00ULL,
0x000100007f6c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000007c007d7306ULL, 0x0005e20000200c00ULL, 0x0000888078867816ULL, 0x042fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000006c008b7306ULL, 0x0003e20000200c00ULL, 0x000001007f7c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007e007f7306ULL, 0x0004e20000200c00ULL,
0x000088807a6c7816ULL, 0x002fce00000000ffULL, 0x0000007c00897306ULL, 0x0003e20000200c00ULL,
0x00000100797e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000078008f7306ULL, 0x0004a20000200c00ULL, 0x00008880797c7816ULL, 0x042fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x000054107f887816ULL, 0x008fc80000000088ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000008c008d7306ULL, 0x0003e20000200c00ULL,
0x000088807b787816ULL, 0x044fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fcc00078e00ffULL,
0x0000006c00927306ULL, 0x0005e20000200c00ULL, 0x000001007a8c7824ULL, 0x042fe200078e00ffULL,
0x000054108f8e7816ULL, 0x000fe2000000008eULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x00005410006c7816ULL, 0x004fe20000000023ULL,
0x000000ffff007224ULL, 0x000fe200078e0078ULL, 0x000054107d787816ULL, 0x000fe40000000006ULL,
0x00000018ff067819ULL, 0x000fc6000001147bULL, 0x0000000a000a7306ULL, 0x000e620000200c00ULL,
0x0000006c684c723cULL, 0x080b6e000000184cULL, 0x0000007900937306ULL, 0x0004e20000200c00ULL,
0x0000006c702c723cULL, 0x000b6e000000182cULL, 0x0000008600867306ULL, 0x000ee20000200c00ULL,
0x000054100a7b7816ULL, 0x002fc40000000089ULL, 0x0000541085797816ULL, 0x004fe40000000084ULL,
0x000054108b897816ULL, 0x000fc6000000008aULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x00005410938f7816ULL, 0x008fe20000000090ULL, 0x000000786850723cULL, 0x040b6c0000001850ULL,
0x0000007e00917306ULL, 0x000fe20000200c00ULL, 0x0000541086867816ULL, 0x000fe2000000008dULL,
0x000000886858723cULL, 0x040b6c0000001858ULL, 0x0000008c00957306ULL, 0x000e640000200c00ULL,
0x0000008e6860723cULL, 0x000b6c0000001860ULL, 0x0000000000007306ULL, 0x000fe40000200c00ULL,
0x000000787030723cULL, 0x040b6c0000001830ULL, 0x0000000800237306ULL, 0x000ea20000200c00ULL,
0x0000541092927816ULL, 0x002fe20000000095ULL, 0x000000887038723cULL, 0x040b6c0000001838ULL,
0x0000007a00977306ULL, 0x0002e40000200c00ULL, 0x0000008e7040723cULL, 0x000b6c0000001840ULL,
0x00000006007d7306ULL, 0x000ee20000200c00ULL, 0x00005410027a7816ULL, 0x002fc40000000087ULL,
0x000054107c877816ULL, 0x000fe40000000091ULL, 0x0000541000937816ULL, 0x004fe20000000023ULL,
0x000000021f007824ULL, 0x000fe200078e00ffULL, 0x0000541097947816ULL, 0x008fe20000000094ULL,
0x0000007a6854723cULL, 0x000b660000001854ULL, 0xfffffff800027812ULL, 0x000fe400078ec0ffULL,
0x000054107d957816ULL, 0x000fc60000000096ULL, 0x00000086685c723cULL, 0x040b70000000185cULL,
0x000000926864723cULL, 0x000b700000001864ULL, 0x0000007a7034723cULL, 0x040b700000001834ULL,
0x00000086703c723cULL, 0x040b70000000183cULL, 0x000000927044723cULL, 0x040b700000001844ULL,
0x000000947048723cULL, 0x080b700000001848ULL, 0x000000946868723cULL, 0x000b620000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000136c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc8000001142aULL,
0x0000002302027211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000202027819ULL, 0x000fc80000001223ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000114237810ULL, 0x000fc80007ffe0ffULL, 0x0000001a2300720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000214237810ULL, 0x000fe20007ffe0ffULL,
0x0000590024027a24ULL, 0x018fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x0000001a2300720cULL, 0x000fe20003f06070ULL, 0x0000008002067824ULL, 0x000fe200078e00ffULL,
0x0000006027007812ULL, 0x000fca00078ec0ffULL, 0x0000000117027824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271c007217ULL, 0x000fe20007800000ULL,
0x000000101f087824ULL, 0x000fe200078e00ffULL, 0x0000640006237a11ULL, 0x000fc600078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x00000010086d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff087819ULL, 0x000fe4000001161dULL, 0x000000006d007217ULL, 0x000fe40007800000ULL,
0x0000000408297810ULL, 0x040fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x100fe200078e026dULL,
0x0000650006277a11ULL, 0x000fe200000f3cffULL, 0x0000000100007824ULL, 0x100fe200078e0a6dULL,
0x0000000808067810ULL, 0x000fe20007ffe0ffULL, 0x000000010a287824ULL, 0x000fe200078e0202ULL,
0x0000000c08707810ULL, 0x000fe20007ffe0ffULL, 0x0000000129717824ULL, 0x040fe200078e026dULL,
0x000000002900720cULL, 0x080fe20003f86070ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000000800720cULL, 0x000fc40003fa6070ULL, 0x000000007000720cULL, 0x000fe20003f06070ULL,
0x00000001712a7824ULL, 0x000fe200078e0202ULL, 0x00000012286c7212ULL, 0x000fe200078efcffULL,
0x0000000106087824ULL, 0x040fe200078e026dULL, 0x000000000600720cULL, 0x000fe20003f66070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006c236c7210ULL, 0x000fc60007fde0ffULL,
0x0000000170727824ULL, 0x000fe200078e026dULL, 0x000000122a707212ULL, 0x000fe200078efcffULL,
0x0000000108287824ULL, 0x000fe400078e0202ULL, 0x0000000171007824ULL, 0x000fe400078e021dULL,
0x00000001296d7824ULL, 0x000fe200030e0627ULL, 0x0000002370707210ULL, 0x000fe20007fde0ffULL,
0x0000000871717824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff871007812ULL, 0x000fe200078ee200ULL, 0x000000010a067824ULL, 0x000fe200078e021dULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000080a737824ULL, 0x000fe400078e00ffULL,
0x00000001722a7824ULL, 0x000fe400078e0202ULL, 0x000000012b717824ULL, 0x000fe200030e0627ULL,
0xfffffff873067812ULL, 0x000fe200078ee206ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002328287210ULL, 0x000fc60007fde0ffULL, 0x00000001080a7824ULL, 0x100fe200078e021dULL,
0x000000122a027212ULL, 0x000fe200078efcffULL, 0x0000000808737824ULL, 0x000fe400078e00ffULL,
0x0000000172087824ULL, 0x040fe400078e021dULL, 0x0000000872797824ULL, 0x000fe200078e00ffULL,
0xfffffff8730a7812ULL, 0x000fe200078ee20aULL, 0x0000000129297824ULL, 0x000fe200030e0627ULL,
0x0000002302027210ULL, 0x000fe20007fde0ffULL, 0x0000001006237824ULL, 0x100fe200078e0203ULL,
0xfffffff879087812ULL, 0x000fe200078ee208ULL, 0x0000001000737824ULL, 0x000fc400078e0203ULL,
0x000000100a797824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c237faeULL, 0x0003e2000e901c46ULL, 0x00000010087b7824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fe200030e0627ULL, 0x0000000070737faeULL, 0x0003e8000e101c46ULL,
0x0000000028797faeULL, 0x0003e8000d901c46ULL, 0x00000000027b7faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000101f007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001d007211ULL, 0x000fc800078fe8ffULL,
0x00000004000a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100087824ULL, 0x040fe200078e021dULL,
0x0000000c00277810ULL, 0x040fe20007ffe0ffULL, 0x0000000800237824ULL, 0x040fe400078e00ffULL,
0x0000000100287824ULL, 0x100fe400078e0202ULL, 0x000000010a2a7824ULL, 0x000fe200078e0202ULL,
0xfffffff823087812ULL, 0x000fe200078ee208ULL, 0x0000000127707824ULL, 0x040fe200078e0202ULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000827727824ULL, 0x000fc400078e00ffULL,
0x000000010a007824ULL, 0x140fe400078e021dULL, 0x00000001236c7824ULL, 0x040fe400078e0202ULL,
0x0000000123027824ULL, 0x140fe400078e021dULL, 0x00000008236d7824ULL, 0x000fe400078e00ffULL,
0x0000000127237824ULL, 0x000fe400078e021dULL, 0x000000080a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee202ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fc400078ee223ULL, 0x0000640006237a11ULL, 0x000fe200078038ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b007812ULL, 0x000fe400078ee200ULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000650006277a11ULL, 0x000fe400000f3cffULL, 0x0000002823287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000122a027212ULL, 0x000fc400078efcffULL,
0x000000126c2a7212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0627ULL,
0x00000012706c7212ULL, 0x000fe200078efcffULL, 0x0000001000737824ULL, 0x100fe200078e0203ULL,
0x0000000223027210ULL, 0x040fe20007f1e0ffULL, 0x000000100a797824ULL, 0x100fe200078e0203ULL,
0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL, 0x00000010727b7824ULL, 0x100fe200078e0203ULL,
0x0000006c236c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fc400000e0627ULL, 0x000000016d2b7824ULL, 0x100fe200018e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028237faeULL, 0x0003e2000b901c46ULL,
0x00000001716d7824ULL, 0x000fc600020e0627ULL, 0x0000000002737faeULL, 0x0003e8000b901c46ULL,
0x000000002a797faeULL, 0x0003e8000b901c46ULL, 0x000000006c7b7faeULL, 0x0003e4000b901c46ULL,
0x000000081f007824ULL, 0x000fe400078e00ffULL, 0x0000000215067824ULL, 0x000fc600078e0275ULL,
0x0000000800037812ULL, 0x002fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000001006067824ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0082a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01266c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018015037811ULL, 0x000fc800078e38ffULL,
0x0000000374037210ULL, 0x000fca0007ffe012ULL, 0x0120000003237984ULL, 0x000e680000000800ULL,
0x0122000003067984ULL, 0x0084e20000000800ULL, 0x000000222300720bULL, 0x002fe20003f1d000ULL,
0x0000c6927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x004fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000315027810ULL, 0x000fe40007ffe0ffULL,
0x000000222300720bULL, 0x000fe40003f74000ULL, 0x0000001f0200720cULL, 0x000fe20003f05270ULL,
0x0000c6427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f278824ULL, 0x000fe200078e0212ULL, 0x0000002223027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174278824ULL, 0x000fca00078e0227ULL,
0x0124000227008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x0000c5827f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x0000c4527f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x0000c3227f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x0000c2027f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff087424ULL, 0x000fd800078e00ffULL,
0x0000002302230221ULL, 0x000fe20000010100ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc20000010000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x000000081f037824ULL, 0x000fca00078e00ffULL, 0xfffffff0030a7812ULL, 0x000fca00078ec0ffULL,
0x0126b4000a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002822067210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e23ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011428ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0628ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4000a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991008037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff067819ULL, 0x000fe4000001161dULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000bdc27f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000bdf27f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000be427f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff067819ULL, 0x002fe2000001161dULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000475067824ULL, 0x000fc400078e0206ULL,
0x0000001007707824ULL, 0x000fe400078e0225ULL, 0x000000010b037824ULL, 0x108fe400078e0206ULL,
0x0000000109087824ULL, 0x000fc600078e0206ULL, 0xfffffff80a067812ULL, 0x000fe200078ee203ULL,
0x000000041f0a7824ULL, 0x000fe200078e00ffULL, 0x0000d00015037811ULL, 0x000fe400078e60ffULL,
0xfffffff823087812ULL, 0x000fe400078ee208ULL, 0x000000040a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0x000000020a0a7812ULL, 0x000fc400078efcffULL, 0x00000000066c783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x08cfe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fe40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a1d087211ULL, 0x002fe200078fe0ffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fe20003800000ULL,
0x000000010b0b7824ULL, 0x000fca00078e0208ULL, 0xfffffff806067812ULL, 0x000fca00078ee20bULL,
0x0000001006067824ULL, 0x000fca00078e0225ULL, 0x000000000678783bULL, 0x0006a20000004200ULL,
0x00000018ff077819ULL, 0x002fe20000011470ULL, 0x00010000737e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe40000011471ULL, 0x00000007000a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff107819ULL, 0x000fe40000011472ULL, 0x0000888070067816ULL, 0x008fe400000000ffULL,
0x00000018ff127819ULL, 0x000fc40000011473ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000000b00227306ULL, 0x0007e20000200c00ULL, 0x0000010070077824ULL, 0x042fe400078e00ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x004fe20000011479ULL,
0x0000010078827824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001147aULL,
0x00000100710b7824ULL, 0x008fe200078e00ffULL, 0x0000002700867306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe20000011478ULL, 0x0001000079857824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x000001007a887824ULL, 0x000fe200078e00ffULL,
0x00000018ff077819ULL, 0x000fc40000011407ULL, 0x0000888078817816ULL, 0x000fe200000000ffULL,
0x00000074008a7306ULL, 0x0005e20000200c00ULL, 0x0000888072277816ULL, 0x002fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147bULL,
0x000088807a877816ULL, 0x040fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x00000010007c7306ULL, 0x0003e20000200c00ULL,
0x0000010072747824ULL, 0x044fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fc40000011485ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000012007f7306ULL, 0x0005e20000200c00ULL,
0x0000888071107816ULL, 0x042fe200000000ffULL, 0x0001000071717824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000002300847306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x004fc4000001140bULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000001200237306ULL, 0x0003f00000200c00ULL, 0x00000070000b7306ULL, 0x0004e20000200c00ULL,
0x0000888073127816ULL, 0x002fce00000000ffULL, 0x0000000600067306ULL, 0x000fe20000200c00ULL,
0x0000010073707824ULL, 0x004fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007200737306ULL, 0x0002a20000200c00ULL, 0x000054100b0a7816ULL, 0x008fce000000000aULL,
0x0000000700077306ULL, 0x000ee20000200c00ULL, 0x0000010079727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x00005410737c7816ULL, 0x004fce000000007cULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x0000541006067816ULL, 0x008fce0000000007ULL, 0x0000007d008b7306ULL, 0x000fe20000200c00ULL,
0x0000541010077816ULL, 0x002fce0000000023ULL, 0x00000070007d7306ULL, 0x0003e20000200c00ULL,
0x00005410710b7816ULL, 0x004fe20000000022ULL, 0x000000066c2c723cULL, 0x040f6c000000182cULL,
0x0000007200837306ULL, 0x0005e20000200c00ULL, 0x0000888079707816ULL, 0x002fe200000000ffULL,
0x0000000a6c30723cULL, 0x080f6c0000001830ULL, 0x0000007800797306ULL, 0x0002e20000200c00ULL,
0x000088807b727816ULL, 0x044fe200000000ffULL, 0x0000000a2850723cULL, 0x040b6c0000001850ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x000001007b787824ULL, 0x042fe200078e00ffULL,
0x00000006284c723cULL, 0x000b62000000184cULL, 0x000100007b7b7824ULL, 0x000fc400078e00ffULL,
0x00000010050a7824ULL, 0x020fe200078e0203ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x0000541079847816ULL, 0x008fe40000000084ULL,
0x0000541012237816ULL, 0x004fca000000007dULL, 0x0000007400747306ULL, 0x000eb00000200c00ULL,
0x0000007e007e7306ULL, 0x000ef00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541027227816ULL, 0x004fce0000000074ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000054107e7d7816ULL, 0x008fe2000000007fULL, 0x000000222854723cULL, 0x040f6c0000001854ULL,
0x0000007000707306ULL, 0x000ee40000200c00ULL, 0x0000007c2858723cULL, 0x000f6c0000001858ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000541081827816ULL, 0x004fe20000000082ULL,
0x000000226c34723cULL, 0x040f6c0000001834ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000541070837816ULL, 0x008fe20000000083ULL, 0x0000007c6c38723cULL, 0x000f6c0000001838ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x0000541085857816ULL, 0x002fe20000000086ULL,
0x00000082285c723cULL, 0x040f6c000000185cULL, 0x0000007200727306ULL, 0x000fe40000200c00ULL,
0x000000842860723cULL, 0x000f6c0000001860ULL, 0x0000007800897306ULL, 0x000e620000200c00ULL,
0x0000541087887816ULL, 0x004fe20000000088ULL, 0x000000826c3c723cULL, 0x040f6c000000183cULL,
0x0000007a00717306ULL, 0x000ea40000200c00ULL, 0x000000846c40723cULL, 0x000f6c0000001840ULL,
0x0000007b00107306ULL, 0x000ee20000200c00ULL, 0x0000541072897816ULL, 0x002fc40000000089ULL,
0x00005410718a7816ULL, 0x004fca000000008aULL, 0x000000882864723cULL, 0x000f620000001864ULL,
0x00005410108b7816ULL, 0x008fce000000008bULL, 0x000000886c44723cULL, 0x000f700000001844ULL,
0x0000008a2868723cULL, 0x080b640000001868ULL, 0x000000000a28783bULL, 0x0202ac0000000200ULL,
0x0000008a6c48723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f28287232ULL, 0x084fe40000000000ULL,
0x0000000f2a2a7232ULL, 0x000fc40000000000ULL, 0x0000000e29297232ULL, 0x080fe40000000000ULL,
0x0000000e2b2b7232ULL, 0x000fe40000000000ULL, 0x0000000d04047232ULL, 0x080fe40000000000ULL,
0x0000000d06067232ULL, 0x000fe40000000000ULL, 0x0000000c05057232ULL, 0x080fe40000000000ULL,
0x0000000c07077232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809037824ULL, 0x040fe200078e00ffULL, 0x00000000266c783bULL, 0x020ee20000004200ULL,
0x0000000109087824ULL, 0x000fca00078e0208ULL, 0xfffffff803087812ULL, 0x000fca00078ee208ULL,
0x0000001008087824ULL, 0x000fcc00078e0225ULL, 0x000000000808783bULL, 0x002e620000004200ULL,
0x00000018ff107819ULL, 0x008fe4000001146dULL, 0x00000018ff037819ULL, 0x000fe4000001146cULL,
0x0000001000277306ULL, 0x0007e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe4000001146eULL,
0x00000018ff237819ULL, 0x000fe4000001146fULL, 0x000088806f737816ULL, 0x000fc600000000ffULL,
0x0000000300127306ULL, 0x0005e20000200c00ULL, 0x000001006c107824ULL, 0x008fe200078e00ffULL,
0x00000018ff707819ULL, 0x002fe2000001140aULL, 0x0000010008797824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc8000001140bULL, 0x0000002200727306ULL, 0x0003e20000200c00ULL,
0x000088806c037816ULL, 0x044fe200000000ffULL, 0x000100006c6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000001000a827824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011409ULL, 0x00000018ff257819ULL, 0x000fe20000011408ULL,
0x0000002300747306ULL, 0x0005e20000200c00ULL, 0x000088806d227816ULL, 0x002fe400000000ffULL,
0x0000888008787816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001146cULL, 0x000088800a817816ULL, 0x040fe200000000ffULL,
0x0000007000847306ULL, 0x0003e20000200c00ULL, 0x000001006d237824ULL, 0x044fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x000100006d6d7824ULL, 0x000fe200078e00ffULL,
0x00008880097c7816ULL, 0x000fe200000000ffULL, 0x000100000a0a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007100867306ULL, 0x0005e20000200c00ULL,
0x000088806e707816ULL, 0x002fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x000001006e717824ULL, 0x044fe400078e00ffULL,
0x000100006e6e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000001000107306ULL, 0x000fe20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fce000001146eULL,
0x00000026007e7306ULL, 0x000ff00000200c00ULL, 0x0000006d00267306ULL, 0x000ff00000200c00ULL,
0x0000006e006d7306ULL, 0x0002b00000200c00ULL, 0x00000025007a7306ULL, 0x0007e20000200c00ULL,
0x00000100096e7824ULL, 0x002fc400078e00ffULL, 0x0001000009097824ULL, 0x000fc600078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000008007b7306ULL, 0x0002620000200c00ULL,
0x00000018ff257819ULL, 0x008fe40000011423ULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x000054106d727816ULL, 0x004fc60000000072ULL, 0x0000006c00237306ULL, 0x0005e20000200c00ULL,
0x0000541003087816ULL, 0x002fe20000000010ULL, 0x000001000b107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006e007d7306ULL, 0x0003e20000200c00ULL,
0x000001006f6c7824ULL, 0x004fe200078e00ffULL, 0x000054107b7a7816ULL, 0x000fe2000000007aULL,
0x000100006f6f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x000088800b6e7816ULL, 0x042fe200000000ffULL, 0x000100000b0b7824ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe200078e006eULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000002500257306ULL, 0x000ff00000200c00ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000007100717306ULL, 0x000e700000200c00ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0000541070707816ULL, 0x002fce0000000071ULL,
0x0000007800787306ULL, 0x000ff00000200c00ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541073717816ULL, 0x004fce000000006cULL, 0x0000000a00857306ULL, 0x000ea20000200c00ULL,
0x000000702834723cULL, 0x080b6e0000001834ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000541078787816ULL, 0x002fe20000000079ULL, 0x000000700454723cULL, 0x000b6c0000001854ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x0000541085847816ULL, 0x004fce0000000084ULL,
0x00000009007f7306ULL, 0x0004620000200c00ULL, 0x000054106f737816ULL, 0x008fce0000000074ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541022097816ULL, 0x004fe20000000025ULL,
0x000000722838723cULL, 0x040b620000001838ULL, 0x0000541023227816ULL, 0x000fe40000000012ULL,
0x0000541026237816ULL, 0x000fe40000000027ULL, 0x000054107c797816ULL, 0x002fe2000000007dULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x000054107f7b7816ULL, 0x000fe2000000007eULL,
0x00000008282c723cULL, 0x040b6c000000182cULL, 0x0000000300037306ULL, 0x000fe40000200c00ULL,
0x000000222830723cULL, 0x040b6c0000001830ULL, 0x0000001000107306ULL, 0x000ea20000200c00ULL,
0x0000541081827816ULL, 0x002fe20000000082ULL, 0x00000078283c723cULL, 0x040b6c000000183cULL,
0x0000000b000b7306ULL, 0x000e640000200c00ULL, 0x0000007a2840723cULL, 0x000b620000001840ULL,
0x0000541003837816ULL, 0x004fce0000000010ULL, 0x00000008044c723cULL, 0x000b62000000184cULL,
0x000054100b857816ULL, 0x002fce0000000086ULL, 0x000000822844723cULL, 0x040b700000001844ULL,
0x000000842848723cULL, 0x000b700000001848ULL, 0x000000220450723cULL, 0x040b700000001850ULL,
0x000000720458723cULL, 0x040b700000001858ULL, 0x00000078045c723cULL, 0x040b70000000185cULL,
0x0000007a0460723cULL, 0x040b700000001860ULL, 0x000000820464723cULL, 0x040b700000001864ULL,
0x000000840468723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000013047f8cULL, 0x0202a2000c80043fULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x000126a015067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x004fe200078e0005ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff507000007947ULL, 0x000fea000383ffffULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000021007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cd3000047802ULL, 0x000fc40000000f00ULL,
0x0000ae0000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000021ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000001808057811ULL, 0x042fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x004fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000004400447220ULL, 0x040fe20000410000ULL,
0x0000004500457220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004900497220ULL, 0x000fe20000410000ULL, 0x0000004e054e7220ULL, 0x044fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x040fe20000410000ULL,
0x0000005b055b7220ULL, 0x040fe20000410000ULL, 0x0000005e055e7220ULL, 0x040fe20000410000ULL,
0x0000005f055f7220ULL, 0x040fe20000410000ULL, 0x0000006205627220ULL, 0x040fe20000410000ULL,
0x0000006305637220ULL, 0x040fe20000410000ULL, 0x0000006605667220ULL, 0x040fe20000410000ULL,
0x0000006705677220ULL, 0x040fe20000410000ULL, 0x0000006a056a7220ULL, 0x040fe20000410000ULL,
0x0000006b056b7220ULL, 0x000fe20000410000ULL, 0x000000042e2e7220ULL, 0x088fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000442427220ULL, 0x080fe20000410000ULL,
0x0000000443437220ULL, 0x080fe20000410000ULL, 0x0000000446467220ULL, 0x080fe20000410000ULL,
0x0000000447477220ULL, 0x080fe20000410000ULL, 0x000000044a4a7220ULL, 0x080fe20000410000ULL,
0x000000044b4b7220ULL, 0x000fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x080fe20000410000ULL, 0x0000000250507220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x0000000254547220ULL, 0x080fe20000410000ULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000258587220ULL, 0x080fe20000410000ULL,
0x0000000259597220ULL, 0x080fe20000410000ULL, 0x000000025c5c7220ULL, 0x080fe20000410000ULL,
0x000000025d5d7220ULL, 0x080fe20000410000ULL, 0x0000000260607220ULL, 0x080fe20000410000ULL,
0x0000000261617220ULL, 0x080fe20000410000ULL, 0x0000000264647220ULL, 0x080fe20000410000ULL,
0x0000000265657220ULL, 0x080fe20000410000ULL, 0x0000000268687220ULL, 0x080fe20000410000ULL,
0x0000000269697220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fe400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fc400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe40000000017ULL, 0x00005410361a7816ULL, 0x000fe4000000001bULL,
0x0000000803057811ULL, 0x042fe200078ff0ffULL, 0x0000000180807824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x000fc400078ec0ffULL, 0x0000001803097811ULL, 0x000fe200078ff0ffULL,
0x0000000805077824ULL, 0x004fe200078e00ffULL, 0x0000000500027211ULL, 0x040fe400078ff8ffULL,
0x0000001003057811ULL, 0x000fe200078ff0ffULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0xfffffff8070c7812ULL, 0x000fe400078ee202ULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x00000008050b7824ULL, 0x000fe200078e00ffULL, 0x0000000500047211ULL, 0x000fc400078ff8ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee204ULL, 0x000020001f047824ULL, 0x000fe200078e00ffULL,
0x0000000900057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe400078ee205ULL, 0x0000200004057812ULL, 0x000fc400078ee2ffULL,
0xfffffff809067812ULL, 0x048fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x0000100018077824ULL, 0x100fe200078e0205ULL, 0x0000000402047810ULL, 0x000fe20007ffe0ffULL,
0x0000001080807824ULL, 0x000fe200078e0205ULL, 0x0000000602097810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e0207ULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL,
0x000000100c0e7824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x0000001010107824ULL, 0x100fe200078e0207ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x0000001012127824ULL, 0x100fe200078e0207ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x0000001006067824ULL, 0x000fe200078e0207ULL, 0x00007632361b7816ULL, 0x000fe2000000001bULL,
0x0000001008087824ULL, 0x100fe200078e0207ULL, 0x0000541000147816ULL, 0x100fe20000000002ULL,
0x000000100a0c7824ULL, 0x000fe200078e0207ULL, 0x0000763200157816ULL, 0x000fe20000000002ULL,
0x0000000104077824ULL, 0x000fe200078e0209ULL, 0x000000343500723eULL, 0x000fe200000000ffULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x000fe200078e0208ULL, 0x0000001407007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x00000001090e7824ULL, 0x000fe200078e020eULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0x000000464746723eULL, 0x000fe200000000ffULL, 0x0000000109127824ULL, 0x000fe200078e0212ULL,
0x0000004a4b23723eULL, 0x000fc400000000ffULL, 0x0000004c4d4c723eULL, 0x000fe400000000ffULL,
0x0000541000147816ULL, 0x142fe40000000002ULL, 0x0000763200157816ULL, 0x000fe40000000002ULL,
0x000000444507723eULL, 0x000fe400000000ffULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x000000140a007388ULL, 0x0003e20000000a00ULL, 0x000000545554723eULL, 0x000fc400000000ffULL,
0x00000058592a723eULL, 0x000fe400000000ffULL, 0x0000541046227816ULL, 0x140fe40000000023ULL,
0x0000763246237816ULL, 0x000fe40000000023ULL, 0x0000763254097816ULL, 0x000fe4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe400000000ffULL, 0x0000541004147816ULL, 0x002fc40000000006ULL,
0x0000763204157816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000140b007388ULL, 0x000fe20000000a00ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x000000606160723eULL, 0x000fe200000000ffULL,
0x000000060c007388ULL, 0x0003e20000000a00ULL, 0x000000646564723eULL, 0x000fc400000000ffULL,
0x000000686932723eULL, 0x000fe200000000ffULL, 0x000000160e007388ULL, 0x0005e20000000a00ULL,
0x0000004e4f00723eULL, 0x000fe400000000ffULL, 0x00007632640f7816ULL, 0x000fe20000000032ULL,
0x0004001a0a007388ULL, 0x000fe20000000a00ULL, 0x000000525302723eULL, 0x000fe400000000ffULL,
0x000000565704723eULL, 0x000fe400000000ffULL, 0x000054103e067816ULL, 0x002fc40000000042ULL,
0x000076323e077816ULL, 0x000fe40000000042ULL, 0x00005410640e7816ULL, 0x004fe40000000032ULL,
0x000000ff1800720cULL, 0x000fe20003f05270ULL, 0x000400060b007388ULL, 0x0003e80000000a00ULL,
0x000400220c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x002fc40000000026ULL,
0x000076324c077816ULL, 0x000fca0000000026ULL, 0x0000000610007388ULL, 0x0003e80000000a00ULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe400000000ffULL,
0x000000666707723eULL, 0x000fe400000000ffULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080b007388ULL, 0x0003e80000000a00ULL,
0x0008000e0c007388ULL, 0x0005e20000000a00ULL, 0x0000006a6b08723eULL, 0x002fe400000000ffULL,
0x00005410000e7816ULL, 0x144fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000005e5f00723eULL, 0x000fc400000000ffULL, 0x000000626302723eULL, 0x000fe200000000ffULL,
0x0000000e12007388ULL, 0x0003e40000000a00ULL, 0x00005410040e7816ULL, 0x142fe40000000006ULL,
0x00007632040f7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000c000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x002fc40000000002ULL, 0x00007632000f7816ULL, 0x000fca0000000002ULL,
0x000c000e0b007388ULL, 0x000fe80000000a00ULL, 0x000c00060c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000080107984ULL, 0x000e680000000c00ULL,
0x0004000080247984ULL, 0x010ea80000000c00ULL, 0x00080000802c7984ULL, 0x000ee80000000c00ULL,
0x000c000080087984ULL, 0x000ee80000000c00ULL, 0x0010000080147984ULL, 0x000ee80000000c00ULL,
0x0014000080287984ULL, 0x000ee80000000c00ULL, 0x0018000080307984ULL, 0x000ee80000000c00ULL,
0x001c000080347984ULL, 0x000ee20000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x008fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff0b0b7230ULL, 0x000fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fc40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fe40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001080007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0004002480007388ULL, 0x000fe20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fe40000000000ULL, 0x000000370b0b7230ULL, 0x000fe40000000000ULL,
0x000000360a0a7230ULL, 0x000fe20000000000ULL, 0x0008002c80007388ULL, 0x000fe20000000c00ULL,
0x0000003509097230ULL, 0x000fc40000000000ULL, 0x0000003408087230ULL, 0x000fca0000000000ULL,
0x000c000880007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011603ULL,
0x000000760900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff137a12ULL, 0x000fe200078e33ffULL, 0x000000011e007824ULL, 0x000fe200078e0209ULL,
0x000000011f1f7812ULL, 0x000fc800078ec0ffULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL, 0x0000000109027824ULL, 0x000fca00078e0203ULL,
0x0000000800077305ULL, 0x000e62000021f000ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802027812ULL, 0x000fca00078ef803ULL, 0x0000001002027824ULL, 0x000fe400078e0205ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b07117227ULL, 0x000fe400078e0006ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000011047227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a04ULL,
0x0000000703027812ULL, 0x002fc600078ec0ffULL, 0x00005a0007067a24ULL, 0x000fca00078e0200ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000104041810ULL, 0x000fc80007ffe0ffULL,
0x0000000413077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077047210ULL, 0x000fe40007f3e0ffULL, 0x0000002003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0004067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0004077a11ULL, 0x000fe400008f4407ULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277077210ULL, 0x000fe40007f3e0ffULL,
0x0000004003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077077210ULL, 0x000fe40007f3e0ffULL, 0x0000006003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277077210ULL, 0x000fe40007f3e0ffULL,
0x0000008003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077077210ULL, 0x000fe40007f3e0ffULL, 0x000000a003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe200078e020fULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x00000003ff0f7819ULL, 0x000fe4000001160cULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fc800078240ffULL,
0x00005f0002077a11ULL, 0x000fe400008f4407ULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x000000010c0f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f027812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fc800078e0200ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077067210ULL, 0x000fe40007f3e0ffULL,
0x000000e003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0006027a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x00005f0006037a11ULL, 0x000fe200008f4407ULL, 0x000000081f077824ULL, 0x000fe200078e020cULL,
0x000000760d00720cULL, 0x000fe20003f26070ULL, 0x000000011e1e7824ULL, 0x000fe400078e020dULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001e11037227ULL, 0x002fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x00005a0007027a24ULL, 0x000fc600078e021eULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0xfffffff80d027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001002057824ULL, 0x000fca00078e0205ULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000313037207ULL, 0x000fe20004000000ULL,
0x000000081f057824ULL, 0x002fc800078e0200ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0220ULL, 0x00005a00071e7a24ULL, 0x000fc800078e021eULL,
0x00005a00031e7a24ULL, 0x000fca00078e021eULL, 0x0000001e771e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e001e027a11ULL, 0x000fc800078040ffULL,
0x00005f001e037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe2000001161fULL, 0xffffffffff187424ULL, 0x000fc600078e00ffULL,
0x0000001b0000720cULL, 0x000fda0003f06070ULL, 0x0000000204078824ULL, 0x000fc800078e00ffULL,
0x00006a0007088a24ULL, 0x000fc800078e0200ULL, 0x0000660008088625ULL, 0x000fe200078e002dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff647624ULL, 0x000fe200078e00ffULL,
0x0000000608188981ULL, 0x000ea2000c1e1900ULL, 0x00006f00ff657624ULL, 0x000fc600078e00ffULL,
0x01260000ff067f8cULL, 0x000e68000c80043fULL, 0x0000000664647981ULL, 0x000722000c1e9900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x00005800ff057624ULL, 0x000fe400078e00ffULL,
0x0000008020607824ULL, 0x000fe400078e00ffULL, 0x000000401f637824ULL, 0x000fe200078e00ffULL,
0x0000001f05057810ULL, 0x000fe20007ffe0ffULL, 0x0000008010617824ULL, 0x000fc600078e00ffULL,
0x0000004060167812ULL, 0x000fe400078ef863ULL, 0x00000005ff057819ULL, 0x000fe20000011605ULL,
0x0000006118297224ULL, 0x004fe200078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x00afe4000001161dULL, 0x0000640029277a11ULL, 0x000fe400078038ffULL,
0x0000000825137810ULL, 0x040fe20007ffe0ffULL, 0x0000000116087824ULL, 0x000fe200078e0225ULL,
0x0000001025267810ULL, 0x000fc40007ffe0ffULL, 0x0000001825287810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000650029297a11ULL, 0x000fe400000f3cffULL,
0x0000002025217810ULL, 0x000fe20007ffe0ffULL, 0x00000001160a7824ULL, 0x000fe200078e0213ULL,
0x0000003008107812ULL, 0x000fe200078ef803ULL, 0x00000001160c7824ULL, 0x000fe200078e0226ULL,
0x000000631c087217ULL, 0x000fe20007800000ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001027107210ULL, 0x000fc40007f1e0ffULL, 0x0000001d1d127211ULL, 0x000fe200078fe8ffULL,
0x00000001160e7824ULL, 0x000fe200078e0228ULL, 0x000000300a0a7812ULL, 0x000fe200078ef803ULL,
0x0000000109117824ULL, 0x000fe200000e0629ULL, 0x0000000312207812ULL, 0x000fe200078ec0ffULL,
0x0000000116097824ULL, 0x000fe200078e0221ULL, 0x000000270a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002825237810ULL, 0x000fe40007ffe0ffULL,
0x000020001f227811ULL, 0x000fe200078e68ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x000fc400078ef803ULL, 0x0ffffffc201d7812ULL, 0x000fe200078ef81dULL,
0x0000000108157824ULL, 0x000fe200078e0a63ULL, 0x000000300e0e7812ULL, 0x000fe200078ef803ULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000270c0c7210ULL, 0x080fe40007f1e0ffULL,
0x0000003025247810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200008e0629ULL,
0x0000003008127812ULL, 0x000fe200078ef803ULL, 0x0000000116087824ULL, 0x000fe200078e0223ULL,
0x000000270e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000010d0d7824ULL, 0x100fe200000e0629ULL,
0x0000002712127210ULL, 0x000fe20007f5e0ffULL, 0x0000000413177824ULL, 0x000fe200078e00ffULL,
0x000000152500720cULL, 0x080fe20003f06070ULL, 0x000000010f0f7824ULL, 0x100fe200008e0629ULL,
0x000000151300720cULL, 0x000fe20003f26070ULL, 0x0000000109137824ULL, 0x000fe200010e0629ULL,
0xfffffffc17177812ULL, 0x000fe200078ee220ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000003825257810ULL, 0x000fc40007ffe0ffULL, 0x000000152600720cULL, 0x080fe20003fa6070ULL,
0x000000101d1d7824ULL, 0x100fe200078e0222ULL, 0x0000003008147812ULL, 0x000fe200078ef803ULL,
0x0000001017177824ULL, 0x000fe200078e0222ULL, 0x000000152800720cULL, 0x000fe20003f86070ULL,
0x0000000116087824ULL, 0x000fe200078e0224ULL, 0x0000002714147210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c101c46ULL,
0x000000152100720cULL, 0x080fe40003f66070ULL, 0x000000152300720cULL, 0x080fe20003f46070ULL,
0x000000000a177faeULL, 0x0005e2000c901c46ULL, 0x000000152400720cULL, 0x000fc40003f26070ULL,
0x000000152500720cULL, 0x000fe20003f06070ULL, 0x0000000109157824ULL, 0x000fe400030e0629ULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x0000000426117824ULL, 0x002fe200078e00ffULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x00000001160a7824ULL, 0x004fe400078e0225ULL,
0x0000000428177824ULL, 0x000fe200078e00ffULL, 0x0000002708087210ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc11117812ULL, 0x100fe400078ee220ULL,
0xfffffffc17177812ULL, 0x000fe200078ee220ULL, 0x00000004211d7824ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x0000000423217824ULL, 0x000fc400078e00ffULL,
0x0000000424237824ULL, 0x000fe200078e00ffULL, 0xfffffffc1d1d7812ULL, 0x100fe200078ee220ULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0xfffffffc21217812ULL, 0x100fe200078ee220ULL,
0x0000000109097824ULL, 0x000fe200030e0629ULL, 0xfffffffc23037812ULL, 0x000fe200078ee220ULL,
0x0000001011117824ULL, 0x000fe200078e0222ULL, 0xfffffffc25237812ULL, 0x000fe200078ee220ULL,
0x0000001017177824ULL, 0x100fe200078e0222ULL, 0x000000270a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0222ULL, 0x000000000c117faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x000fc400078e0222ULL, 0x0000001003037824ULL, 0x100fe200078e0222ULL,
0x000000000e177faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0222ULL,
0x000000010b0b7824ULL, 0x000fe200030e0629ULL, 0x00000000121d7faeULL, 0x0003e8000d901c46ULL,
0x0000000014217faeULL, 0x0003e8000d101c46ULL, 0x0000000008037faeULL, 0x0003e8000c901c46ULL,
0x000000000a237faeULL, 0x0003e2000c101c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x000000201d097811ULL, 0x04afe400078ff0ffULL, 0x000000161d087211ULL, 0x000fc400078ff0ffULL,
0x000000181d157811ULL, 0x040fe200078ff0ffULL, 0x0000000116107824ULL, 0x000fe200078e0209ULL,
0x000000381d0f7811ULL, 0x000fe200078ff0ffULL, 0x0000000409217824ULL, 0x000fe200078e00ffULL,
0x0000001d1d0a7211ULL, 0x040fe200078fe8ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000081d117811ULL, 0x040fe400078ff0ffULL, 0x000000101d137811ULL, 0x000fe200078ff0ffULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0x000000281d0b7811ULL, 0x040fe200078ff0ffULL,
0x00000001160e7824ULL, 0x000fe200078e0215ULL, 0x000000301d0d7811ULL, 0x000fe200078ff0ffULL,
0x000000040f277824ULL, 0x000fe200078e00ffULL, 0x000000030a207812ULL, 0x000fe200078ec0ffULL,
0x00000001160a7824ULL, 0x040fe200078e0211ULL, 0x00006400292f7a11ULL, 0x000fe200078038ffULL,
0x00000001160c7824ULL, 0x040fe200078e0213ULL, 0x000020001f227811ULL, 0x000fe200078e68ffULL,
0x0000000116127824ULL, 0x040fe200078e020bULL, 0x0000650029317a11ULL, 0x000fe200000f3cffULL,
0x0000000116147824ULL, 0x000fe200078e020dULL, 0x0ffffffc201d7812ULL, 0x000fe200078ef81dULL,
0x000000040d257824ULL, 0x000fc400078e00ffULL, 0x0000000116157824ULL, 0x000fe200078e020fULL,
0x0000003008167812ULL, 0x000fe200078ef803ULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0xfffffffc170f7812ULL, 0x100fe200078ee220ULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0xfffffffc27177812ULL, 0x100fe200078ee220ULL, 0x000000040b237824ULL, 0x000fe200078e00ffULL,
0xfffffffc25087812ULL, 0x000fe200078ee220ULL, 0x000000101d337824ULL, 0x100fe200078e0222ULL,
0x000000162f167210ULL, 0x000fe20007f1e0ffULL, 0x00000010172b7824ULL, 0x000fe200078e0222ULL,
0xfffffffc110b7812ULL, 0x000fe200078ee220ULL, 0x0000001008297824ULL, 0x000fe200078e0222ULL,
0xfffffffc130d7812ULL, 0x100fe200078ee220ULL, 0x0000000109177824ULL, 0x000fe200000e0631ULL,
0xfffffffc21117812ULL, 0x000fe200078ee220ULL, 0x000000100b1d7824ULL, 0x000fe200078e0222ULL,
0xfffffffc23137812ULL, 0x000fe200078ee220ULL, 0x000000800a087825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016337faeULL, 0x0003e6000b901c46ULL,
0x000000100d217824ULL, 0x000fe200078e0222ULL, 0x0000003008087812ULL, 0x000fe200078ef803ULL,
0x000000800c0a7825ULL, 0x000fc600078e00ffULL, 0x000000082f087210ULL, 0x000fe20007f1e0ffULL,
0x000000100f237824ULL, 0x000fe200078e0222ULL, 0x000000300a0a7812ULL, 0x000fe200078ef803ULL,
0x000000800e0c7825ULL, 0x000fc600078e00ffULL, 0x0000000a2f0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000001011257824ULL, 0x000fe200078e0222ULL, 0x000000300c0c7812ULL, 0x000fe200078ef803ULL,
0x00000080100e7825ULL, 0x000fc600078e00ffULL, 0x0000000c2f0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001013277824ULL, 0x000fe200078e0222ULL, 0x000000300e0e7812ULL, 0x000fe200078ef803ULL,
0x0000008012107825ULL, 0x000fc600078e00ffULL, 0x0000000e2f0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000008014127825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x000fc600078ef803ULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000003012127812ULL, 0x000fe400078ef803ULL,
0x000000102f107210ULL, 0x000fe20007f9e0ffULL, 0x0000000109097824ULL, 0x000fe200000e0631ULL,
0x0000003014037812ULL, 0x000fe200078ef803ULL, 0x000000010b0b7824ULL, 0x100fe200008e0631ULL,
0x000000122f127210ULL, 0x000fe20007fbe0ffULL, 0x000000010d0d7824ULL, 0x100fe200010e0631ULL,
0x000000032f147210ULL, 0x000fe20007fde0ffULL, 0x000000010f0f7824ULL, 0x100fe200018e0631ULL,
0x00000000081d7faeULL, 0x0003e2000b901c46ULL, 0x0000000111117824ULL, 0x000fc400020e0631ULL,
0x0000000113137824ULL, 0x100fe200028e0631ULL, 0x000000000a217faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fc600030e0631ULL, 0x000000000c237faeULL, 0x0003e8000b901c46ULL,
0x000000000e257faeULL, 0x0003e8000b901c46ULL, 0x0000000010277faeULL, 0x0003e8000b901c46ULL,
0x0000000012297faeULL, 0x0003e8000b901c46ULL, 0x00000000142b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01260400ff037984ULL, 0x000e620000000800ULL, 0x0000000502027224ULL, 0x000fc400078e02ffULL,
0x000000011c1d7824ULL, 0x000fe400078e0a19ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804807ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620002027625ULL, 0x000fe200078e002dULL,
0x00000008ff1d7819ULL, 0x000fe2000001161dULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x000000201f067824ULL, 0x002fca00078e0206ULL,
0x00000004ff077819ULL, 0x000fe40000011606ULL, 0x0000000106087810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe07097812ULL, 0x000fe400078ec0ffULL, 0x0000001f06077812ULL, 0x000fc600078ec0ffULL,
0x00000001090b7824ULL, 0x040fe400078e0208ULL, 0x00000001060a7824ULL, 0x000fe200078e0209ULL,
0x0000000809097810ULL, 0x000fe20007ffe0ffULL, 0x00000010070c7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010070d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0209ULL,
0x000001f00c0b7812ULL, 0x000fe200078ee20bULL, 0x0000000106067824ULL, 0x000fe200078e0209ULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000001007097824ULL, 0x040fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x000000000b0c7984ULL, 0x000e62000000cc00ULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fc400078ec0ffULL,
0x000000000a107984ULL, 0x000ea4000000cc00ULL, 0x000001f007087812ULL, 0x000fe400078ee208ULL,
0x000001f009067812ULL, 0x000fe200078ee206ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x000000140a007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fca00078e0013ULL,
0x000000200b007388ULL, 0x000fe8000000cc00ULL, 0x00000000080c7984ULL, 0x000e68000000cc00ULL,
0x0000000006107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002406007388ULL, 0x0003e8000000cc00ULL, 0x0000000c08007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x002fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x01260400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000657919ULL, 0x000e620000000000ULL,
0x00006a0004677a24ULL, 0x000fe200078e02ffULL, 0x3db504f364647820ULL, 0x010fe20000410000ULL,
0x0000000205627824ULL, 0x000fe200078e00ffULL, 0x000126881f667811ULL, 0x000fe200078e18ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e00ffULL, 0xffffffff19687810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x0000000919697810ULL, 0x000fe40007ffe0ffULL,
0x000126081f6a7811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x004fe200078e006eULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x018fc4000001ff00ULL,
0x000000016b00780cULL, 0x040fe20003f25270ULL, 0x00000c2000007945ULL, 0x000fe20003800000ULL,
0x000000016c047810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6d7224ULL, 0x000fe200078e006bULL,
0x000000016b057810ULL, 0x000fe20007ffe0ffULL, 0x0000006118727224ULL, 0x010fe200078e02ffULL,
0x00000001706e7812ULL, 0x000fc400078e0cffULL, 0x000000020500780cULL, 0x000fe20003f06070ULL,
0x000000ffff6b7224ULL, 0x000fc800078e0005ULL, 0x000000ffff041224ULL, 0x000fc800078e026cULL,
0x0000010004067824ULL, 0x040fe200078e0263ULL, 0x0000000104077810ULL, 0x000fe40007ffe0ffULL,
0x000000ff05047207ULL, 0x000fe40000800000ULL, 0x0000001a0700720cULL, 0x000fe40003f46070ULL,
0x0000004006077812ULL, 0x000fca00078ec0ffULL, 0x00000001605e7824ULL, 0x020fcc00078e0207ULL,
0x000005f00000a947ULL, 0x000fea0003800000ULL, 0x0000001065077824ULL, 0x002fe200078e00ffULL,
0x000000061c057217ULL, 0x000fe20007800000ULL, 0x000000021f5c7824ULL, 0x000fe200078e026eULL,
0x00000002ff747819ULL, 0x000fe40000011665ULL, 0x0000003007077812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a06ULL, 0x0000001874757810ULL, 0x040fe20007ffe0ffULL,
0x0000000174517824ULL, 0x140fe200078e025eULL, 0x00000008745a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004004067824ULL, 0x000fe200078e0207ULL, 0x0000640072717a11ULL, 0x000fe200078238ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000010745b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000175577824ULL, 0x000fe200078e025eULL, 0x0000650072737a11ULL, 0x000fe200008f3cffULL,
0x0000008051507825ULL, 0x000fe200078e0006ULL, 0x0000002074767810ULL, 0x000fc40007ffe0ffULL,
0x000020005c5c7811ULL, 0x000fe200078e60ffULL, 0x000000015a537824ULL, 0x000fe200078e025eULL,
0x0000007150587210ULL, 0x000fe20007f3e0ffULL, 0x0000008057567825ULL, 0x000fe200078e0006ULL,
0x0000006565507211ULL, 0x000fe400078fe8ffULL, 0x0000002874777810ULL, 0x000fe20007ffe0ffULL,
0x000000015e557824ULL, 0x000fe200078e025bULL, 0x0000000350727812ULL, 0x000fe200078ec0ffULL,
0x0000008053527825ULL, 0x000fe200078e0006ULL, 0x0000003074787810ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc725d7812ULL, 0x000fe200078ef865ULL, 0x0000000151597824ULL, 0x000fe200008e0673ULL,
0x0000007156567210ULL, 0x080fe20007f3e0ffULL, 0x0000000176517824ULL, 0x000fe200078e025eULL,
0x0000007152527210ULL, 0x000fe20007f5e0ffULL, 0x0000008055547825ULL, 0x000fe200078e0006ULL,
0x000000057500720cULL, 0x000fc60003fa6070ULL, 0x0000008051507825ULL, 0x000fe200078e0006ULL,
0x0000007154547210ULL, 0x000fc60007f7e0ffULL, 0x0000000157577824ULL, 0x100fe200008e0673ULL,
0x000000057400720cULL, 0x080fe20003f26070ULL, 0x0000000153537824ULL, 0x100fe200010e0673ULL,
0x000000055a00720cULL, 0x040fe20003f46070ULL, 0x000000045a5f7824ULL, 0x000fe200078e00ffULL,
0x00000071505a7210ULL, 0x000fe20007f9e0ffULL, 0x000000045b6f7824ULL, 0x000fe200078e00ffULL,
0x0000003874747810ULL, 0x000fe20007ffe0ffULL, 0x0000000155557824ULL, 0x100fe200018e0673ULL,
0x000000055b00720cULL, 0x080fe20003f66070ULL, 0x00000001515b7824ULL, 0x000fe200020e0673ULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee272ULL, 0x000000105d5d7824ULL, 0x000fe200078e025cULL,
0xfffffffc6f6f7812ULL, 0x000fe200078ee272ULL, 0x0000000177517824ULL, 0x000fe200078e025eULL,
0x000000057600720cULL, 0x080fe20003f86070ULL, 0x000000105f5f7824ULL, 0x000fe200078e025cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000585d7faeULL, 0x0003e2000c901c46ULL,
0x0000008051507825ULL, 0x000fe200078e0006ULL, 0x000000057400720cULL, 0x000fc40003f26070ULL,
0x00000000525f7faeULL, 0x0005e2000d101c46ULL, 0x000000106f6f7824ULL, 0x000fe200078e025cULL,
0x0000007150507210ULL, 0x000fe40007fde0ffULL, 0x000000057800720cULL, 0x0c0fe40003f46070ULL,
0x00000000546f7faeULL, 0x0007e2000d901c46ULL, 0x000000057700720cULL, 0x000fe20003f66070ULL,
0x0000000178597824ULL, 0x102fe400078e025eULL, 0x00000001745d7824ULL, 0x000fc400078e025eULL,
0x0000008059527825ULL, 0x004fc800078e0006ULL, 0x0000000475057824ULL, 0x000fe400078e00ffULL,
0x0000000476557824ULL, 0x008fe400078e00ffULL, 0x000000805d067825ULL, 0x000fe200078e0006ULL,
0xfffffffc05057812ULL, 0x100fe400078ee272ULL, 0xfffffffc55557812ULL, 0x000fe200078ee272ULL,
0x0000000151517824ULL, 0x000fe200030e0673ULL, 0x0000007152527210ULL, 0x000fe20007fde0ffULL,
0x0000000477597824ULL, 0x000fc400078e00ffULL, 0x00000004785d7824ULL, 0x000fe400078e00ffULL,
0x00000004745f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc59597812ULL, 0x100fe200078ee272ULL,
0x0000000153537824ULL, 0x000fe200030e0673ULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee272ULL,
0x0000001005057824ULL, 0x000fe200078e025cULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee272ULL,
0x0000001055557824ULL, 0x100fe200078e025cULL, 0x0000007106067210ULL, 0x000fe20007fde0ffULL,
0x0000001059597824ULL, 0x100fe200078e025cULL, 0x0000000056057faeULL, 0x0003e2000e901c46ULL,
0x000000105d5d7824ULL, 0x000fc400078e025cULL, 0x000000105f5f7824ULL, 0x000fe200078e025cULL,
0x000000005a557faeULL, 0x0003e2000e101c46ULL, 0x0000000107077824ULL, 0x000fc600030e0673ULL,
0x0000000050597faeULL, 0x0003e8000d901c46ULL, 0x00000000525d7faeULL, 0x0003e8000d101c46ULL,
0x00000000065f7faeULL, 0x0003e2000c901c46ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x000000021f077824ULL, 0x000fe200078e026eULL, 0x0000000865537811ULL, 0x042fe200078ff0ffULL,
0x0000001065057824ULL, 0x040fe200078e00ffULL, 0x0000001065557811ULL, 0x000fc400078ff0ffULL,
0x0000001865577811ULL, 0x000fe200078ff0ffULL, 0x0000000153517824ULL, 0x100fe200078e025eULL,
0x0000002065597811ULL, 0x000fe200078ff0ffULL, 0x00000004555f7824ULL, 0x000fe200078e00ffULL,
0x00000028655b7811ULL, 0x000fe200078ff0ffULL, 0x00000004576f7824ULL, 0x000fe200078e00ffULL,
0x0000200007797811ULL, 0x000fe200078e60ffULL, 0x0000000453077824ULL, 0x000fe200078e00ffULL,
0x00000030655d7811ULL, 0x000fe200078ff0ffULL, 0x0000000155537824ULL, 0x100fe200078e025eULL,
0x0000003865777811ULL, 0x000fe200078ff0ffULL, 0x0000000157557824ULL, 0x100fe200078e025eULL,
0x0000006565067211ULL, 0x000fe200078fe8ffULL, 0x0000000159577824ULL, 0x100fe200078e025eULL,
0x0000003005057812ULL, 0x000fe200078ec0ffULL, 0x0000000459717824ULL, 0x000fe200078e00ffULL,
0x0000000306067812ULL, 0x000fe200078ec0ffULL, 0x000000015b597824ULL, 0x040fe200078e025eULL,
0x00006400727b7a11ULL, 0x000fe200078238ffULL, 0x000000045b737824ULL, 0x000fe200078e00ffULL,
0xfffffffc07507812ULL, 0x000fe200078ee206ULL, 0x000000015d5b7824ULL, 0x000fe200078e025eULL,
0xfffffffc5f527812ULL, 0x100fe200078ee206ULL, 0x000000045d5d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f547812ULL, 0x100fe200078ee206ULL, 0x0000000477757824ULL, 0x000fe200078e00ffULL,
0xfffffffc71567812ULL, 0x100fe200078ee206ULL, 0x00000040045c7824ULL, 0x000fe200078e0205ULL,
0xfffffffc73587812ULL, 0x000fe200078ee206ULL, 0x0000000177777824ULL, 0x000fe200078e025eULL,
0xfffffffc5d5a7812ULL, 0x100fe200078ee206ULL, 0x000000ffff5d7224ULL, 0x000fe200078e00ffULL,
0xfffffffc75747812ULL, 0x000fe200078ee206ULL, 0x0000001050057824ULL, 0x000fe200078e0279ULL,
0x0ffffffc06067812ULL, 0x000fe200078ef865ULL, 0x00000010525f7824ULL, 0x100fe200078e0279ULL,
0x0000005e65077211ULL, 0x000fe200078ff0ffULL, 0x00000010546f7824ULL, 0x000fc400078e0279ULL,
0x00000010067d7824ULL, 0x000fe400078e0279ULL, 0x0000008007067825ULL, 0x000fc800078e005cULL,
0x0000001056717824ULL, 0x100fe400078e0279ULL, 0x0000001058737824ULL, 0x100fe400078e0279ULL,
0x000000105a757824ULL, 0x000fe400078e0279ULL, 0x0000008051507825ULL, 0x000fc800078e005cULL,
0x0000008053527825ULL, 0x000fe200078e005cULL, 0x0000007b50507210ULL, 0x000fc60007f5e0ffULL,
0x0000008055547825ULL, 0x000fe200078e005cULL, 0x0000007b52527210ULL, 0x000fc60007f7e0ffULL,
0x0000008057567825ULL, 0x000fe200078e005cULL, 0x0000007b54547210ULL, 0x000fc60007f9e0ffULL,
0x0000008059587825ULL, 0x000fc800078e005cULL, 0x000000805b5a7825ULL, 0x000fc800078e005cULL,
0x00000080775c7825ULL, 0x000fe200078e005cULL, 0x0000650072777a11ULL, 0x000fe400008f3cffULL,
0x0000007b06067210ULL, 0x080fe20007f3e0ffULL, 0x0000001074797824ULL, 0x000fe400078e0279ULL,
0x0000000151517824ULL, 0x100fe200010e0677ULL, 0x0000007b58587210ULL, 0x080fe20007f5e0ffULL,
0x0000000107077824ULL, 0x100fe200008e0677ULL, 0x0000007b56567210ULL, 0x080fe20007f3e0ffULL,
0x0000000153537824ULL, 0x100fe200018e0677ULL, 0x0000007b5a5a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000155557824ULL, 0x100fe200020e0677ULL, 0x0000007b5c5c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000157577824ULL, 0x100fe200008e0677ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067d7faeULL, 0x0003e2000b901c46ULL, 0x0000000159597824ULL, 0x000fc400010e0677ULL,
0x000000015b5b7824ULL, 0x100fe200018e0677ULL, 0x0000000050057faeULL, 0x0003e2000b901c46ULL,
0x000000015d5d7824ULL, 0x000fc600020e0677ULL, 0x00000000525f7faeULL, 0x0003e8000b901c46ULL,
0x00000000546f7faeULL, 0x0003e8000b901c46ULL, 0x0000000056717faeULL, 0x0003e8000b901c46ULL,
0x0000000058737faeULL, 0x0003e8000b901c46ULL, 0x000000005a757faeULL, 0x0003e8000b901c46ULL,
0x000000005c797faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff187424ULL, 0x000fc600078e00ffULL, 0x0000001b0000720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000267047824ULL, 0x000fe400078e0200ULL,
0x00000004ff057424ULL, 0x002fc800078e00ffULL, 0x0000660004047625ULL, 0x000fca00078e0005ULL,
0x0000000604187981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000086d737824ULL, 0x002fe400078e00ffULL,
0x000000ffff807224ULL, 0x000fe400078e00ffULL, 0x00000010ff727424ULL, 0x000fe200078e00ffULL,
0x0000001273717810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff6f7224ULL, 0x000fe200078e00ffULL,
0x0000000273737810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff865047812ULL, 0x000fe200078ec0ffULL, 0x000000021f517824ULL, 0x020fe200078e0270ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016f5f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000704507812ULL, 0x000fe400078ef865ULL, 0x0000200051517811ULL, 0x000fe400078e60ffULL,
0x00000001ff527819ULL, 0x000fe20000011650ULL, 0x0000000450057824ULL, 0x040fe200078e00ffULL,
0x0000000765917812ULL, 0x040fe200078ec0ffULL, 0x0000000450537824ULL, 0x000fe200078e00ffULL,
0x0000002065507810ULL, 0x000fe20007ffe0ffULL, 0x0000000152047824ULL, 0x040fe400078e026fULL,
0x0000000152527824ULL, 0x000fe200078e025fULL, 0xfffffff850507812ULL, 0x000fc400078ec0ffULL,
0xfffffffc05047812ULL, 0x000fe400078ee204ULL, 0xfffffffc53527812ULL, 0x000fe400078ee252ULL,
0x0000000750507812ULL, 0x000fe200078ef865ULL, 0x0000001004047824ULL, 0x100fe400078e0251ULL,
0x0000001052527824ULL, 0x000fe400078e0251ULL, 0x0000000450557824ULL, 0x000fe400078e00ffULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000005258783bULL, 0x0002a40000000200ULL,
0x0001000004527824ULL, 0x042fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011404ULL,
0x0000010004547824ULL, 0x040fe200078e00ffULL, 0x0000888004537816ULL, 0x000fe200000000ffULL,
0x00010000055e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011452ULL,
0x00000001ff527819ULL, 0x000fe20000011650ULL, 0x0000005300927306ULL, 0x0003e20000200c00ULL,
0x00000018ff8c7819ULL, 0x000fe40000011405ULL, 0x00000018ff5d7819ULL, 0x000fe20000011454ULL,
0x0000000152047824ULL, 0x040fe200078e026fULL, 0x00000018ff777819ULL, 0x004fe20000011458ULL,
0x0000000152527824ULL, 0x000fe200078e025fULL, 0x0000888058787816ULL, 0x000fe200000000ffULL,
0x0000005c00937306ULL, 0x0004e20000200c00ULL, 0xfffffffc55047812ULL, 0x000fc400078ee204ULL,
0x0000888005537816ULL, 0x042fe200000000ffULL, 0x0000010005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011459ULL, 0x0000001004047824ULL, 0x000fe200078e0251ULL,
0x00008880597b7816ULL, 0x000fe200000000ffULL, 0x0000005d00957306ULL, 0x000fe20000200c00ULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x00010000065c7824ULL, 0x004fe200078e00ffULL,
0x000000000454783bULL, 0x0002a20000000200ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff887819ULL, 0x000fc40000011406ULL, 0x0000000500997306ULL, 0x0007e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0001000007047824ULL, 0x002fe200078e00ffULL,
0x00008880068f7816ULL, 0x040fe200000000ffULL, 0x0000010006067824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011407ULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x0000000450057824ULL, 0x008fe200078e00ffULL, 0x0000005300947306ULL, 0x000fe20000200c00ULL,
0x0001000059507824ULL, 0x000fe200078e00ffULL, 0x00008880078b7816ULL, 0x000fe200000000ffULL,
0x0000010059597824ULL, 0x000fe200078e00ffULL, 0xfffffffc05527812ULL, 0x000fe200078ee252ULL,
0x0000010007077824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc40000011450ULL,
0x00000004008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7d7819ULL, 0x000fe40000011459ULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x00000018ff077819ULL, 0x000fe40000011407ULL,
0x0000541092927816ULL, 0x000fe20000000093ULL, 0x0000005c00967306ULL, 0x000fe20000200c00ULL,
0x0001000058047824ULL, 0x042fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe2000001145aULL,
0x0000010058587824ULL, 0x000fe200078e00ffULL, 0x000088805a7e7816ULL, 0x000fc400000000ffULL,
0x00000018ff797819ULL, 0x000fe20000011404ULL, 0x0000001052047824ULL, 0x000fe200078e0251ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x000100005a517824ULL, 0x040fe200078e00ffULL,
0x0000000865527812ULL, 0x040fe200078ec0ffULL, 0x0000005e00977306ULL, 0x000e620000200c00ULL,
0x000001005a5a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x004fe20000011455ULL,
0x0001000054987824ULL, 0x000fe200078e00ffULL, 0x0000005265507211ULL, 0x000fe400078fe0ffULL,
0x00000018ff7f7819ULL, 0x000fc40000011451ULL, 0x00000058007a7306ULL, 0x0005e20000200c00ULL,
0x0000000191917824ULL, 0x000fe200078e0250ULL, 0x00000018ff827819ULL, 0x000fe2000001145aULL,
0x000000086d507824ULL, 0x000fe200078e0280ULL, 0x00008880545a7816ULL, 0x000fe400000000ffULL,
0x00008880559a7816ULL, 0x000fe200000000ffULL, 0x0000000191507824ULL, 0x000fe200078e0250ULL,
0x0000009000907306ULL, 0x000ee20000200c00ULL, 0x0000000752587812ULL, 0x004fe200078ef865ULL,
0x000000086d527824ULL, 0x000fe200078e0272ULL, 0x00000018ff987819ULL, 0x000fc40000011498ULL,
0x0000001058597812ULL, 0x040fe200078efcffULL, 0x0000001058537824ULL, 0x000fe200078e00ffULL,
0x0000541094947816ULL, 0x002fe20000000097ULL, 0x0000000191527824ULL, 0x000fe200078e0252ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x00000010595d7824ULL, 0x000fe200078e00ffULL,
0xfffffff053507812ULL, 0x000fe200078ee250ULL, 0x0000001059597824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011454ULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0xfffffff05d527812ULL, 0x000fe200078ee252ULL, 0x00000010505c7824ULL, 0x000fe200078e00ffULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x0000541095937816ULL, 0x008fe20000000090ULL,
0x0001000055957824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011456ULL,
0x0000001052527824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x00000018ff857819ULL, 0x000fe20000011457ULL, 0x000000ffff907224ULL, 0x000fe200078e009aULL,
0x00000006009b7306ULL, 0x000ea20000200c00ULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x000000005250783bULL, 0x000ee20000000200ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff747819ULL, 0x000fe4000001145bULL, 0x000000026f6f7810ULL, 0x000fe20007ffe0ffULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x00000007008d7306ULL, 0x0004640000200c00ULL,
0x000054109b977816ULL, 0x004fc40000000088ULL, 0x0000888057887816ULL, 0x000fc800000000ffULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000000000404783bULL, 0x000eae0000000200ULL,
0x0000008f008f7306ULL, 0x000ee20000200c00ULL, 0x000054108d8d7816ULL, 0x002fe20000000086ULL,
0x000000ffff867224ULL, 0x000fc400078e0088ULL, 0x0001000057887824ULL, 0x040fe200078e00ffULL,
0x000000925c4c723cULL, 0x080fe2000000184cULL, 0x0000010057577824ULL, 0x000fe400078e00ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000092502c723cULL, 0x008be6000000182cULL,
0x00000098009d7306ULL, 0x000e620000200c00ULL, 0x000054108f967816ULL, 0x000fc60000000096ULL,
0x0000010055927824ULL, 0x020fc800078e00ffULL, 0x0000009500557306ULL, 0x0007e20000200c00ULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x000000965c44723cULL, 0x080fec0000001844ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541099957816ULL, 0x008fe2000000008cULL,
0x000000965024723cULL, 0x000f620000001824ULL, 0x00008880568c7816ULL, 0x000fc400000000ffULL,
0x00000018ff847819ULL, 0x004fe40000011404ULL, 0x00000018ff837819ULL, 0x000fe20000011405ULL,
0x0000008c00987306ULL, 0x0005e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011406ULL,
0x000000945c48723cULL, 0x080fec0000001848ULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x000054108b8c7816ULL, 0x004fe2000000008eULL, 0x000000945028723cULL, 0x000bec0000001828ULL,
0x00000088008e7306ULL, 0x0003e20000200c00ULL, 0x0001000056947824ULL, 0x060fe200078e00ffULL,
0x0000008c5c40723cULL, 0x000f620000001840ULL, 0x0000010056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff947819ULL, 0x000fe40000011494ULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054105a887816ULL, 0x002fe2000000009dULL,
0x0000008c5020723cULL, 0x000b6c0000001820ULL, 0x00000094008f7306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000ff00000200c00ULL, 0x0000005400547306ULL, 0x000e700000200c00ULL,
0x0000009000907306ULL, 0x000eb00000200c00ULL, 0x0000009200937306ULL, 0x0006a20000200c00ULL,
0x0000541054897816ULL, 0x002fc40000000089ULL, 0x000088805b547816ULL, 0x000fca00000000ffULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x0000007391927210ULL, 0x148fe20007ffe080ULL,
0x000000885c3c723cULL, 0x080fe2000000183cULL, 0x0000007191807210ULL, 0x000fe20007ffe080ULL,
0x0000001058917824ULL, 0x000fe200078e00ffULL, 0x00005410908c7816ULL, 0x024fe20000000055ULL,
0x000000ffff557224ULL, 0x000fe200078e0054ULL, 0xfffffff059807812ULL, 0x000fe200078ee280ULL,
0x00000086008b7306ULL, 0x0004e20000200c00ULL, 0x00005410938d7816ULL, 0x000fe2000000008aULL,
0x000100005b547824ULL, 0x000fe200078e00ffULL, 0xfffffff091927812ULL, 0x000fe200078ee292ULL,
0x0000001080587824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011407ULL,
0x000000885014723cULL, 0x000fe20000001814ULL, 0x00000018ff8a7819ULL, 0x000fe20000011454ULL,
0x00000057005a7306ULL, 0x000ee20000200c00ULL, 0x0000541098867816ULL, 0x004fe2000000008fULL,
0x0000001092547824ULL, 0x000fe200078e00ffULL, 0x0000541056877816ULL, 0x002fc60000000087ULL,
0x0000008c5c38723cULL, 0x040f620000001838ULL, 0x000054108b8e7816ULL, 0x008fe2000000008eULL,
0x0000007e007e7306ULL, 0x000fec0000200c00ULL, 0x000000865c34723cULL, 0x000fe20000001834ULL,
0x000054105a8f7816ULL, 0x000fe20000000085ULL, 0x0000007f007f7306ULL, 0x000e6c0000200c00ULL,
0x0000008c5010723cULL, 0x000f640000001810ULL, 0x0000007500757306ULL, 0x000fec0000200c00ULL,
0x0000008e5c30723cULL, 0x000be40000001830ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000054107e7e7816ULL, 0x002fc8000000007fULL, 0x000001005b5d7824ULL, 0x020fe200078e00ffULL,
0x00008880045e7816ULL, 0x040fe200000000ffULL, 0x00010000045f7824ULL, 0x040fe200078e00ffULL,
0x00000086500c723cULL, 0x040f62000000180cULL, 0x00000080005c7306ULL, 0x0003e20000200c00ULL,
0x0000010004047824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x000000005858783bULL, 0x000ee20000000200ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x0000008e5008723cULL, 0x000b620000001808ULL,
0x0000005500907306ULL, 0x0005e20000200c00ULL, 0x0000888005807816ULL, 0x002fc400000000ffULL,
0x00005410827f7816ULL, 0x004fe20000000075ULL, 0x0001000007757824ULL, 0x000fe400078e00ffULL,
0x0001000005517824ULL, 0x060fe200078e00ffULL, 0x0000888006527816ULL, 0x040fe200000000ffULL,
0x0000010005057824ULL, 0x000fe200078e00ffULL, 0x0000008a00917306ULL, 0x000e620000200c00ULL,
0x000000005454783bULL, 0x000ea20000000200ULL, 0x000000ffff507224ULL, 0x000fe200078e0080ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0001000006537824ULL, 0x040fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000010006067824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0xfffffff472807810ULL, 0x000fc60007ffe0ffULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x0000541090907816ULL, 0x002fce0000000091ULL, 0x0000000400857306ULL, 0x000fe20000200c00ULL,
0x0000007e5824723cULL, 0x008b6e0000001824ULL, 0x0000000500047306ULL, 0x0003e20000200c00ULL,
0x000054105d917816ULL, 0x000fce0000000074ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x0000888007057816ULL, 0x042fe200000000ffULL, 0x0000010007077824ULL, 0x000fe200078e00ffULL,
0x0000007e5444723cULL, 0x044b680000001844ULL, 0x00000018ff077819ULL, 0x000fe20000011407ULL,
0x0000005100517306ULL, 0x000e660000200c00ULL, 0x000000905440723cULL, 0x080b6a0000001840ULL,
0x0000008300837306ULL, 0x000ea60000200c00ULL, 0x000000905820723cULL, 0x000b6a0000001820ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000541050507816ULL, 0x002fce0000000051ULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x0000541004517816ULL, 0x004fe40000000083ULL,
0x0000000472047810ULL, 0x000fc80007ffe0ffULL, 0x000000180400780cULL, 0x000fe20003f25270ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000505438723cULL, 0x000b620000001838ULL,
0x000000ffff727224ULL, 0x000fcc00078e0004ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x0000541078787816ULL, 0x002fe20000000079ULL, 0x000000505810723cULL, 0x000b6c0000001810ULL,
0x0000005200527306ULL, 0x000ff00000200c00ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000054105e5e7816ULL, 0x004fce000000005fULL, 0x0000007700777306ULL, 0x000eb00000200c00ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541052527816ULL, 0x002fce0000000053ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000054107a797816ULL, 0x004fce0000000077ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x00000078544c723cULL, 0x080b6e000000184cULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x00000078582c723cULL, 0x000b6e000000182cULL,
0x0000008400847306ULL, 0x000ee20000200c00ULL, 0x000054107b7c7816ULL, 0x002fce000000007cULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000054107d7d7816ULL, 0x004fce0000000076ULL,
0x0000000600067306ULL, 0x000e620000200c00ULL, 0x00005410855f7816ULL, 0x008fe20000000084ULL,
0x0000007c5448723cULL, 0x080b6c0000001848ULL, 0x0000000500057306ULL, 0x000fe40000200c00ULL,
0x0000007c5828723cULL, 0x000b6c0000001828ULL, 0x0000007500747306ULL, 0x000ea20000200c00ULL,
0x0000541006537816ULL, 0x002fe20000000081ULL, 0x0000005e543c723cULL, 0x040b6c000000183cULL,
0x0000000700077306ULL, 0x000e640000200c00ULL, 0x000000525434723cULL, 0x000b620000001834ULL,
0x0000541005747816ULL, 0x004fce0000000074ULL, 0x0000005e5814723cULL, 0x000b620000001814ULL,
0x0000541007757816ULL, 0x002fce000000005cULL, 0x00000052580c723cULL, 0x000b70000000180cULL,
0x000000745430723cULL, 0x080b700000001830ULL, 0x000000745808723cULL, 0x000b620000001808ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffeda000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff707224ULL, 0x000fe200078e006eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffdfe000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000644a4a7220ULL, 0x0a0fe20000410000ULL,
0x00000064445b7220ULL, 0x080fe20000410000ULL, 0x0000006446467220ULL, 0x080fe20000410000ULL,
0x0000006442427220ULL, 0x080fe20000410000ULL, 0x0000006443437220ULL, 0x080fe20000410000ULL,
0x000000643e3e7220ULL, 0x080fe20000410000ULL, 0x000000643a3a7220ULL, 0x080fe20000410000ULL,
0x000000644e047220ULL, 0x080fe20000410000ULL, 0x000000644f057220ULL, 0x080fe20000410000ULL,
0x000000644b067220ULL, 0x080fe20000410000ULL, 0x0000006438537220ULL, 0x080fe20000410000ULL,
0x000000643b447220ULL, 0x080fe20000410000ULL, 0x0000006433077220ULL, 0x080fe20000410000ULL,
0x0000006428287220ULL, 0x080fe20000410000ULL, 0x0000006420207220ULL, 0x080fe20000410000ULL,
0x0000006410107220ULL, 0x080fe20000410000ULL, 0x0000006411117220ULL, 0x080fe20000410000ULL,
0x0000006408087220ULL, 0x080fe20000410000ULL, 0x000000644c5d7220ULL, 0x080fe20000410000ULL,
0x00000064485c7220ULL, 0x080fe20000410000ULL, 0x000000643d547220ULL, 0x080fe20000410000ULL,
0x0000006439527220ULL, 0x080fe20000410000ULL, 0x000000642d387220ULL, 0x080fe20000410000ULL,
0x00000064293b7220ULL, 0x080fe20000410000ULL, 0x000000643c597220ULL, 0x080fe20000410000ULL,
0x000000643f487220ULL, 0x080fe20000410000ULL, 0x0000006434517220ULL, 0x080fe20000410000ULL,
0x0000006435507220ULL, 0x080fe20000410000ULL, 0x00000064304f7220ULL, 0x080fe20000410000ULL,
0x00000064324c7220ULL, 0x080fe20000410000ULL, 0x000000642c397220ULL, 0x080fe20000410000ULL,
0x000000642f2d7220ULL, 0x080fe20000410000ULL, 0x000000642b297220ULL, 0x080fe20000410000ULL,
0x00000064253d7220ULL, 0x080fe20000410000ULL, 0x000000644d557220ULL, 0x080fe20000410000ULL,
0x0000006449567220ULL, 0x080fe20000410000ULL, 0x0000006445577220ULL, 0x080fe20000410000ULL,
0x00000064405a7220ULL, 0x080fe20000410000ULL, 0x0000006441587220ULL, 0x080fe20000410000ULL,
0x00000064314e7220ULL, 0x080fe20000410000ULL, 0x000000642e2c7220ULL, 0x080fe20000410000ULL,
0x00000064243c7220ULL, 0x080fe20000410000ULL, 0x00000064213f7220ULL, 0x080fe20000410000ULL,
0x00000064222b7220ULL, 0x080fe20000410000ULL, 0x0000006416257220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e004aULL, 0x0000006447477220ULL, 0x080fe20000410000ULL,
0x000000ffff307224ULL, 0x000fe200078e0046ULL, 0x0000006436367220ULL, 0x080fe20000410000ULL,
0x000000ffff327224ULL, 0x000fe200078e0042ULL, 0x0000006437377220ULL, 0x080fe20000410000ULL,
0x000000ffff347224ULL, 0x000fe200078e0043ULL, 0x000000642a2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff337224ULL, 0x000fe200078e003eULL, 0x0000006426267220ULL, 0x080fe20000410000ULL,
0x000000ffff357224ULL, 0x000fe200078e003aULL, 0x0000006427247220ULL, 0x080fe20000410000ULL,
0x0000006423237220ULL, 0x080fe20000410000ULL, 0x0000006414407220ULL, 0x080fe20000410000ULL,
0x0000006415417220ULL, 0x080fe20000410000ULL, 0x0000006417177220ULL, 0x080fe20000410000ULL,
0x0000006412167220ULL, 0x080fe20000410000ULL, 0x0000006413137220ULL, 0x080fe20000410000ULL,
0x000000640c4d7220ULL, 0x080fe20000410000ULL, 0x000000640d457220ULL, 0x080fe20000410000ULL,
0x000000640e0e7220ULL, 0x080fe20000410000ULL, 0x000000640f217220ULL, 0x080fe20000410000ULL,
0x0000006409497220ULL, 0x080fe20000410000ULL, 0x000000640a227220ULL, 0x080fe20000410000ULL,
0x000000640b0b7220ULL, 0x000fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fc400078e0004ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff317224ULL, 0x000fe400078e0006ULL,
0x000000ffff4a7224ULL, 0x000fe400078e0007ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0028ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0020ULL, 0x000000ffff427224ULL, 0x000fc400078e0010ULL,
0x000000ffff437224ULL, 0x000fe400078e0011ULL, 0x000000ffff467224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000066087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff287224ULL, 0x000fe400078e002cULL, 0x000000ffff2c7224ULL, 0x000fe400078e002dULL,
0x000000ffff277224ULL, 0x000fe400078e002aULL, 0x000000ffff2a7224ULL, 0x000fc400078e0026ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0024ULL, 0x000000ffff267224ULL, 0x000fe400078e0023ULL,
0x000000ffff247224ULL, 0x000fe400078e0017ULL, 0x000000ffff177224ULL, 0x000fe400078e0013ULL,
0x000000ffff207224ULL, 0x000fe400078e000eULL, 0x000000ffff237224ULL, 0x000fc400078e000bULL,
0x0000000000047805ULL, 0x002fca0000015200ULL, 0x0000040066077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040066077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000465157824ULL, 0x000fe200078e00ffULL,
0x0000001d6c00720cULL, 0x000fc80003f06070ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x000000801f147824ULL, 0x000fca00078e0214ULL, 0x0124000014047984ULL, 0x0002a20000000c00ULL,
0x000021f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000ee20000209000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x0000001e650a7211ULL, 0x040fe200078ff0ffULL,
0x00000002655f7824ULL, 0x000fc600078e00ffULL, 0x000000100a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000065f5f7812ULL, 0x000fca00078ec0ffULL, 0x000000015f6b7824ULL, 0x000fe200078e0219ULL,
0x0000000b000b7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0b0d7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000d00097305ULL, 0x000ee4000021f000ULL, 0x000000ffff0f7224ULL, 0x008fc800078e0a09ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f09117227ULL, 0x000fe200078e0008ULL,
0x000000080a097810ULL, 0x000fca0007ffe0ffULL, 0x00000009110c7227ULL, 0x000fc800078e00ffULL,
0x0000000a11087227ULL, 0x000fc800078e00ffULL, 0x000000ffff107224ULL, 0x000fe400078e0a0cULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x00005a00100d7a24ULL, 0x000fe400078e0209ULL,
0x00005a000b0b7a24ULL, 0x000fe200078e020aULL, 0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000e110f7227ULL, 0x000fe200078e00ffULL, 0x00005a000d007a0cULL, 0x000fe40003fa6070ULL,
0x00005a000b007a0cULL, 0x000fe20003f06070ULL, 0x0000000a11107227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fe400078e0a0fULL, 0x000000ffff117224ULL, 0x000fe400078e0a10ULL,
0x00005a00090e7a24ULL, 0x000fe400078e020eULL, 0x00005a00110a7a24ULL, 0x000fe200078e020aULL,
0x80005a000d0d5a10ULL, 0x000fe20007ffe0ffULL, 0x000001006c097824ULL, 0x000fe200078e0263ULL,
0x00005a000e007a0cULL, 0x000fe40003f26070ULL, 0x80005a000b0b0a10ULL, 0x000fc40007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fe40003f66070ULL, 0x00005a000d007a0cULL, 0x000fe40003fc6070ULL,
0x00005a000b007a0cULL, 0x000fe20003f46070ULL, 0x00000001690b7824ULL, 0x000fe200078e025fULL,
0x000000091c5e7217ULL, 0x000fe40007800000ULL, 0x000000010c0c5810ULL, 0x000fe40007ffe0ffULL,
0x80005a000e0e1a10ULL, 0x000fe20007ffe0ffULL, 0x000000015e5e7824ULL, 0x000fe200078e0a09ULL,
0x0000000108080810ULL, 0x000fc40007ffe0ffULL, 0x80005a000a0a3a10ULL, 0x000fe20007ffe0ffULL,
0x000000016b097824ULL, 0x100fe200078e0a5eULL, 0x0000005e0b00720cULL, 0x040fe20003f06070ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a5eULL, 0x00005a000e007a0cULL, 0x000fe40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a00ff117a12ULL, 0x000fe400078e33ffULL,
0x000000010c0c6810ULL, 0x000fc40007ffe0ffULL, 0x0000000108082810ULL, 0x000fe40007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fe40003f46070ULL, 0x00000009687d7217ULL, 0x040fe40003800000ULL,
0x0000000811097207ULL, 0x040fe40006800000ULL, 0x0000000b680b7217ULL, 0x000fe40003800000ULL,
0x0000000c110d7207ULL, 0x000fc40006800000ULL, 0x0000000968097217ULL, 0x040fe40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000000d680d7217ULL, 0x000fe20003800000ULL,
0x0000000962887224ULL, 0x040fe200078e02ffULL, 0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL,
0x0000005e6b00720cULL, 0x000fe20003fc6070ULL, 0x0000000d628a7224ULL, 0x000fe200078e02ffULL,
0x0000000110103810ULL, 0x000fc40007ffe0ffULL, 0x000000ff0b0b7207ULL, 0x000fe40000000000ULL,
0x000000010f0f4810ULL, 0x000fe40007ffe0ffULL, 0x000000ff7d7d7207ULL, 0x000fe20003000000ULL,
0x000000010b0d7824ULL, 0x000fe200078e028aULL, 0x0000000110102810ULL, 0x000fe20007ffe0ffULL,
0x0000000188097824ULL, 0x000fe200078e020bULL, 0x0000000f110f7207ULL, 0x000fe20006800000ULL,
0x000000020d0c7825ULL, 0x000fe200078e0002ULL, 0x000000887d717211ULL, 0x000fc400078fe0ffULL,
0x000000105f777812ULL, 0x000fe200078efcffULL, 0x0000000209087825ULL, 0x100fe200078e0002ULL,
0x0000001011117207ULL, 0x000fe20006800000ULL, 0x000000060c6f7981ULL, 0x0046a2000c1e9500ULL,
0x0000000f680f7217ULL, 0x040fe20003800000ULL, 0x0000000271707825ULL, 0x000fe200078e0002ULL,
0x0000001168117217ULL, 0x000fe20003800000ULL, 0x00000006086d7981ULL, 0x0002a4000c1e9500ULL,
0x0000000169797824ULL, 0x000fe400078e0277ULL, 0x0000000f628c7224ULL, 0x040fe200078e02ffULL,
0x0000008a7d0f7211ULL, 0x000fe200078fe0ffULL, 0x00000001790d7824ULL, 0x008fe200078e0a5eULL,
0x0000000670707981ULL, 0x0006a2000c1e9500ULL, 0x0000001162907224ULL, 0x000fc400078e02ffULL,
0x000000010b137824ULL, 0x000fe200078e028cULL, 0x0000008c7d117211ULL, 0x000fe200078fe0ffULL,
0x000000010b757824ULL, 0x000fe200078e0290ULL, 0x0000000d680c7217ULL, 0x000fe20003800000ULL,
0x000000020f0a7825ULL, 0x000fe200078e0002ULL, 0x0000005e7900720cULL, 0x000fc60003f26070ULL,
0x00000002130e7825ULL, 0x000fe200078e0002ULL, 0x00000004ff0c7819ULL, 0x000fe2000001160cULL,
0x000000060a727981ULL, 0x0006a4000c1e9500ULL, 0x0000000211087825ULL, 0x102fe400078e0002ULL,
0x000000060e717981ULL, 0x0082e4000c1e9500ULL, 0x0000000275127825ULL, 0x000fe400078e0002ULL,
0x0000000608747981ULL, 0x0002e4000c1e9500ULL, 0x0000000177757824ULL, 0x000fe200078e0219ULL,
0x000000ff0c0f7207ULL, 0x002fc60000800000ULL, 0x00000001750d7824ULL, 0x000fe200078e0a5eULL,
0x000000907d737211ULL, 0x000fe200078fe0ffULL, 0x00000001880b7824ULL, 0x000fe200078e020fULL,
0x0000005e7500720cULL, 0x000fc60003f06070ULL, 0x0000000273107825ULL, 0x100fe200078e0002ULL,
0x0000000d680d7217ULL, 0x000fe20003800000ULL, 0x0000000612737981ULL, 0x0002e4000c1e9500ULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x000000ff0d827207ULL, 0x000fe20000000000ULL,
0x0000000610767981ULL, 0x0002e4000c1e9500ULL, 0x000000010f817824ULL, 0x040fe400078e0290ULL,
0x000000060a787981ULL, 0x0002e2000c1e9500ULL, 0x000000010f7b7824ULL, 0x000fe200078e028aULL,
0x0000008882097211ULL, 0x000fc400078fe0ffULL, 0x0000008a820d7211ULL, 0x040fe400078fe0ffULL,
0x0000008c82137211ULL, 0x002fe200078fe0ffULL, 0x00000002810a7825ULL, 0x000fe200078e0002ULL,
0x000000205f817812ULL, 0x000fc600078efcffULL, 0x000000027b7a7825ULL, 0x000fe200078e0002ULL,
0x00000090827f7211ULL, 0x000fe200078fe0ffULL, 0x000000060a7e7981ULL, 0x0002e4000c1e9500ULL,
0x0000000169877824ULL, 0x000fe400078e0281ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000067a7a7981ULL, 0x0002e6000c1e9500ULL, 0x000000010f117824ULL, 0x000fe200078e028cULL,
0x0000000608797981ULL, 0x0002e2000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fc800078e0002ULL,
0x00000002130e7825ULL, 0x000fe200078e0002ULL, 0x000000060c7b7981ULL, 0x0022e6000c1e9500ULL,
0x0000000187137824ULL, 0x000fe400078e0a5eULL, 0x0000000181837824ULL, 0x000fc600078e0219ULL,
0x0000001368127217ULL, 0x040fe20003800000ULL, 0x0000000183137824ULL, 0x000fe200078e0a5eULL,
0x0000005e8700720cULL, 0x080fe40003f26070ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000211107825ULL, 0x100fe200078e0002ULL, 0x0000005e8300720cULL, 0x000fe40003f06070ULL,
0x0000001368137217ULL, 0x000fe20003800000ULL, 0x000000027f087825ULL, 0x000fe200078e0002ULL,
0x000000ff120b7207ULL, 0x000fe20000800000ULL, 0x00000006107c7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff13a17207ULL, 0x000fc60000000000ULL, 0x000000060e7f7981ULL, 0x0002e2000c1e9500ULL,
0x000000010b877824ULL, 0x000fc600078e028aULL, 0x0000000608857981ULL, 0x0002e4000c1e9500ULL,
0x0000008aa1117211ULL, 0x002fe200078fe0ffULL, 0x0000000287867825ULL, 0x000fe200078e0002ULL,
0x00000090a18b7211ULL, 0x000fc600078fe0ffULL, 0x0000000188097824ULL, 0x000fe200078e020bULL,
0x00000088a1137211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x100fe200078e0002ULL,
0x0000000686867981ULL, 0x0002e6000c1e9500ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x0000008ca10d7211ULL, 0x000fc800078fe0ffULL, 0x0000000608807981ULL, 0x0002e2000c1e9500ULL,
0x000000010b0f7824ULL, 0x000fc600078e028cULL, 0x0000000610877981ULL, 0x0022e2000c1e9500ULL,
0x0000000213127825ULL, 0x000fc800078e0002ULL, 0x000000028b087825ULL, 0x000fe200078e0002ULL,
0x000000305f8b7812ULL, 0x000fe200078efcffULL, 0x0000000612897981ULL, 0x0002e4000c1e9500ULL,
0x000000010b0b7824ULL, 0x000fe400078e0290ULL, 0x0000000169917824ULL, 0x000fe200078e028bULL,
0x0000000608d17981ULL, 0x0002e2000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fc800078e0002ULL,
0x000000020d0c7825ULL, 0x100fe200078e0002ULL, 0x000000060e847981ULL, 0x0002e6000c1e9500ULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x000000060c8f7981ULL, 0x0002e6000c1e9500ULL,
0x0000000191137824ULL, 0x002fe200078e0a5eULL, 0x000000060a9c7981ULL, 0x0002e2000c1e9500ULL,
0x000000018b8d7824ULL, 0x000fc600078e0219ULL, 0x0000001368127217ULL, 0x040fe20003800000ULL,
0x000000018d137824ULL, 0x000fe200078e0a5eULL, 0x0000005e9100720cULL, 0x080fe40003f26070ULL,
0x0000005e8d00720cULL, 0x000fe40003f06070ULL, 0x00000004ff127819ULL, 0x000fe40000011612ULL,
0x0000001368137217ULL, 0x000fe40003800000ULL, 0x000000ff12917207ULL, 0x000fc40000800000ULL,
0x000000ff13a37207ULL, 0x000fc60000000000ULL, 0x0000000188117824ULL, 0x000fe200078e0291ULL,
0x00000088a3137211ULL, 0x000fe200078fe0ffULL, 0x00000001910d7824ULL, 0x000fe200078e028cULL,
0x0000008ca30f7211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x000fc800078e0002ULL,
0x0000000213127825ULL, 0x100fe200078e0002ULL, 0x00000006108e7981ULL, 0x0002e6000c1e9500ULL,
0x000000020d0c7825ULL, 0x100fe200078e0002ULL, 0x0000000612b77981ULL, 0x0002e6000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e0002ULL, 0x000000060c9a7981ULL, 0x0002e4000c1e9500ULL,
0x0000008aa30b7211ULL, 0x002fc400078fe0ffULL, 0x000000060ecf7981ULL, 0x0002e2000c1e9500ULL,
0x0000000191097824ULL, 0x000fe400078e028aULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x000000060acd7981ULL, 0x0002e2000c1e9500ULL,
0x00000090a3117211ULL, 0x000fc600078fe0ffULL, 0x0000000608987981ULL, 0x0002e2000c1e9500ULL,
0x0000000191137824ULL, 0x000fe400078e0290ULL, 0x0000000211107825ULL, 0x000fc800078e0002ULL,
0x0000000213127825ULL, 0x000fe200078e0002ULL, 0x0000000610d37981ULL, 0x0002e8000c1e9500ULL,
0x00000006129e7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff07d7d7812ULL, 0x000fe400078ec0ffULL,
0x000000015f917812ULL, 0x040fe400078efcffULL, 0x000000085f937812ULL, 0x040fe200078efcffULL,
0x000000015e087824ULL, 0x002fe200078e027dULL, 0x000000095f957812ULL, 0x000fe200078efcffULL,
0x00000001ffcb7424ULL, 0x000fc400078e00ffULL, 0x00000001910b7824ULL, 0x100fe400078e0219ULL,
0x00000001930d7824ULL, 0x100fe400078e0219ULL, 0x00000001950f7824ULL, 0x000fe400078e0219ULL,
0x000000016b097824ULL, 0x100fe400078e0a08ULL, 0x000000010b0a7824ULL, 0x100fe400078e0a08ULL,
0x000000010d0c7824ULL, 0x000fc400078e0a08ULL, 0x000000010f0e7824ULL, 0x000fe200078e0a08ULL,
0x00000009cb087219ULL, 0x040fe400000006ffULL, 0x0000000acb0a7219ULL, 0x000fe400000006ffULL,
0x000000115f977812ULL, 0x000fe400078efcffULL, 0xfffffff082117812ULL, 0x000fe400078ec0ffULL,
0x0000000ccb0c7219ULL, 0x040fe400000006ffULL, 0x0000000ecb0e7219ULL, 0x000fe200000006ffULL,
0x0000000197137824ULL, 0x000fc400078e0219ULL, 0x000000015e107824ULL, 0x000fe200078e0211ULL,
0x000000185f997812ULL, 0x000fc600078efcffULL, 0x0000000175097824ULL, 0x100fe400078e0a10ULL,
0x0000000113117824ULL, 0x000fe200078e0a10ULL, 0x000000195f9d7812ULL, 0x000fe400078efcffULL,
0x00005410706d7816ULL, 0x004fc8000000006dULL, 0x0000006d08ff7212ULL, 0x000fc800078ac0ffULL,
0x0000005e6b00720cULL, 0x000fc80002fa1470ULL, 0x0000005e5f00720cULL, 0x000fe40002fa1070ULL,
0x00005410726f7816ULL, 0x000fe4000000006fULL, 0xff8000005d5d7808ULL, 0x000fe40002800000ULL,
0x0000541074717816ULL, 0x008fe40000000071ULL, 0x0000006d0aff7212ULL, 0x000fe4000782c0ffULL,
0x0000006f08ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007108ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006f0aff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e6b00720cULL, 0x0c0fe40001741470ULL,
0x0000005e6b00720cULL, 0x080fe40002781470ULL, 0x0000005e0b00720cULL, 0x0c0fe40000f21470ULL,
0x0000005e0b00720cULL, 0x000fc40002fa1470ULL, 0x0000005e5f00720cULL, 0x0c0fe40001741070ULL,
0x0000005e5f00720cULL, 0x080fe40002781070ULL, 0x0000005e9100720cULL, 0x0c0fe40000f21070ULL,
0x0000005e9100720cULL, 0x000fe40002fa1070ULL, 0x0000541076737816ULL, 0x000fe40000000073ULL,
0xff8000002e2e7808ULL, 0x000fc40001000000ULL, 0xff80000039397808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fe40002800000ULL,
0x0000006d0cff7212ULL, 0x000fe4000786c0ffULL, 0x0000007308ff7212ULL, 0x000fe4000780c0ffULL,
0x000000710aff7212ULL, 0x000fc4000784c0ffULL, 0x000000730aff7212ULL, 0x000fe4000788c0ffULL,
0x0000006f0eff7212ULL, 0x000fe4000782c0ffULL, 0x000000710cff7212ULL, 0x000fe400078ac0ffULL,
0x0000005e6b00720cULL, 0x080fe40000701470ULL, 0x0000005e0b00720cULL, 0x0c0fe40001741470ULL,
0x0000005e0b00720cULL, 0x000fc40002781470ULL, 0x0000005e0d00720cULL, 0x0c0fe40001f61470ULL,
0x0000005e0d00720cULL, 0x080fe40002fa1470ULL, 0x0000005e0f00720cULL, 0x080fe40000f21470ULL,
0x0000005e5f00720cULL, 0x080fe40000701070ULL, 0x0000005e9100720cULL, 0x0c0fe40001741070ULL,
0x0000005e9100720cULL, 0x000fc40002781070ULL, 0x0000005e9300720cULL, 0x0c0fe40001f61070ULL,
0x0000005e9300720cULL, 0x080fe40002fa1070ULL, 0x0000005e9500720cULL, 0x000fe40000f21070ULL,
0x00000009cb097219ULL, 0x040fe400000006ffULL, 0x00000011cb117219ULL, 0x000fe400000006ffULL,
0x0000541079787816ULL, 0x000fc40000000078ULL, 0x000054107b7a7816ULL, 0x000fe2000000007aULL,
0x00000001999b7824ULL, 0x100fe200078e0219ULL, 0xff80000028287808ULL, 0x000fe20000000000ULL,
0x000000019d9f7824ULL, 0x000fe200078e0219ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40002000000ULL, 0xff8000005c5c7808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fc40002800000ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0x0000006f0cff7212ULL, 0x000fe4000780c0ffULL, 0x000000710eff7212ULL, 0x000fe4000784c0ffULL,
0x000000730cff7212ULL, 0x080fe4000788c0ffULL, 0x000000730eff7212ULL, 0x000fe4000786c0ffULL,
0x0000007811ff7212ULL, 0x000fc400078ac0ffULL, 0x0000007a09ff7212ULL, 0x000fe2000782c0ffULL,
0x000000019b127824ULL, 0x100fe200078e0a10ULL, 0xfffffff0a1a17812ULL, 0x000fe200078ec0ffULL,
0x000000019f107824ULL, 0x000fe200078e0a10ULL, 0x0000005e0d00720cULL, 0x0c0fe40000701470ULL,
0x0000005e0d00720cULL, 0x080fe40002781470ULL, 0x0000005e0f00720cULL, 0x0c0fe40001741470ULL,
0x0000005e0f00720cULL, 0x000fc40001f61470ULL, 0x0000005e7500720cULL, 0x080fe40000f21470ULL,
0x0000005e1300720cULL, 0x080fe20002fa1470ULL, 0x000000015e827824ULL, 0x000fe200078e02a1ULL,
0x0000005e9300720cULL, 0x0c0fe40000701070ULL, 0x0000005e9300720cULL, 0x080fe40002781070ULL,
0x0000005e9500720cULL, 0x0c0fe40001741070ULL, 0x0000005e9500720cULL, 0x000fc40001f61070ULL,
0x0000005e7700720cULL, 0x080fe40000f21070ULL, 0x0000005e9700720cULL, 0x000fe40002fa1070ULL,
0x00000012cb7d7219ULL, 0x040fe400000006ffULL, 0x00000010cba17219ULL, 0x000fe400000006ffULL,
0x000054107f7c7816ULL, 0x000fe4000000007cULL, 0x00005410857e7816ULL, 0x000fc4000000007eULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff80000057577808ULL, 0x000fc40002800000ULL,
0x0000007809ff7212ULL, 0x080fe4000780c0ffULL, 0x000000787dff7212ULL, 0x000fe4000788c0ffULL,
0x0000007c09ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007e09ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007c11ff7212ULL, 0x000fe4000782c0ffULL, 0x0000007aa1ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000183887824ULL, 0x000fe200078e0a82ULL, 0xfffffff0a3a37812ULL, 0x000fc400078ec0ffULL,
0x0000005e7500720cULL, 0x0c0fe40000701470ULL, 0x0000005e7500720cULL, 0x0c0fe40001741470ULL,
0x0000005e7500720cULL, 0x080fe40001f61470ULL, 0x0000005e1300720cULL, 0x080fe40000f21470ULL,
0x0000005e9b00720cULL, 0x080fe40002781470ULL, 0x0000005e9f00720cULL, 0x000fe20002fa1470ULL,
0x000000015e907824ULL, 0x000fe200078e02a3ULL, 0x000000215fa57812ULL, 0x000fc400078efcffULL,
0x0000005e7700720cULL, 0x0c0fe40000701070ULL, 0x0000005e7700720cULL, 0x0c0fe40001741070ULL,
0x0000005e7700720cULL, 0x080fe40001f61070ULL, 0x0000005e9700720cULL, 0x080fe40000f21070ULL,
0x0000005e9900720cULL, 0x080fe40002781070ULL, 0x0000005e9d00720cULL, 0x000fc40002fa1070ULL,
0x00000088cba37219ULL, 0x000fe400000006ffULL, 0x0000541087867816ULL, 0x000fe20000000086ULL,
0x00000001a5a77824ULL, 0x000fe200078e0219ULL, 0xff8000005b5b7808ULL, 0x000fe40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff8000003d3d7808ULL, 0x000fc40000800000ULL, 0xff8000005a5a7808ULL, 0x000fe40002000000ULL,
0xff80000034347808ULL, 0x000fe40002800000ULL, 0x0000007a11ff7212ULL, 0x040fe4000780c0ffULL,
0x0000007e11ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007a7dff7212ULL, 0x000fe4000786c0ffULL,
0x0000007ca1ff7212ULL, 0x000fc4000782c0ffULL, 0x0000007ea1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000086a3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a78a7824ULL, 0x000fe200078e0a82ULL,
0x0000005e1300720cULL, 0x0c0fe40000701470ULL, 0x0000005e1300720cULL, 0x080fe40001741470ULL,
0x0000005e9b00720cULL, 0x080fe40001f61470ULL, 0x0000005e9f00720cULL, 0x000fc40000f21470ULL,
0x0000005e9f00720cULL, 0x080fe40002781470ULL, 0x0000005e8300720cULL, 0x080fe40002fa1470ULL,
0x000000285fab7812ULL, 0x040fe400078efcffULL, 0x000000295fb17812ULL, 0x000fe400078efcffULL,
0x0000005e9700720cULL, 0x0c0fe40000701070ULL, 0x0000005e9700720cULL, 0x000fc40001741070ULL,
0x0000005e9900720cULL, 0x080fe40001f61070ULL, 0x0000005e9d00720cULL, 0x0c0fe40000f21070ULL,
0x0000005e9d00720cULL, 0x080fe40002781070ULL, 0x0000005e8100720cULL, 0x000fe40002fa1070ULL,
0x0000008acba97219ULL, 0x000fe400000006ffULL, 0x0000541089807816ULL, 0x000fc40000000080ULL,
0x000054108f847816ULL, 0x000fe40000000084ULL, 0x00005410d19c7816ULL, 0x000fe2000000009cULL,
0x00000001abad7824ULL, 0x100fe200078e0219ULL, 0xff80000047477808ULL, 0x000fe20000000000ULL,
0x00000001b1b37824ULL, 0x000fe200078e0219ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40001800000ULL, 0xff8000003f3f7808ULL, 0x000fc40000800000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000006d0eff7212ULL, 0x000fe400078cc0ffULL, 0x0000007c7dff7212ULL, 0x040fe4000780c0ffULL,
0x0000007e7dff7212ULL, 0x000fe4000784c0ffULL, 0x00000080a3ff7212ULL, 0x000fc4000786c0ffULL,
0x00000084a3ff7212ULL, 0x040fe4000782c0ffULL, 0x0000009ca3ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084a9ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ad8c7824ULL, 0x100fe200078e0a82ULL,
0x0000005e0f00720cULL, 0x080fe200037c1470ULL, 0x00000001b3827824ULL, 0x000fe200078e0a82ULL,
0x0000005e9b00720cULL, 0x0c0fe40000701470ULL, 0x0000005e9b00720cULL, 0x000fc40001741470ULL,
0x0000005e8300720cULL, 0x0c0fe40001f61470ULL, 0x0000005e8300720cULL, 0x0c0fe40000f21470ULL,
0x0000005e8300720cULL, 0x080fe40002781470ULL, 0x0000005ea700720cULL, 0x080fe40002fa1470ULL,
0x0000005e9500720cULL, 0x080fe400037c1070ULL, 0x0000005e9900720cULL, 0x000fc40000701070ULL,
0x0000005e9900720cULL, 0x080fe40001741070ULL, 0x0000005e8100720cULL, 0x0c0fe40001f61070ULL,
0x0000005e8100720cULL, 0x0c0fe40000f21070ULL, 0x0000005e8100720cULL, 0x080fe40002781070ULL,
0x0000005ea500720cULL, 0x000fe40002fa1070ULL, 0x0000008ccbaf7219ULL, 0x000fc400000006ffULL,
0x00000082cbb57219ULL, 0x000fe400000006ffULL, 0xff80000056567808ULL, 0x000fe40003000000ULL,
0xff8000003e3e7808ULL, 0x000fe40000000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000059597808ULL, 0x000fe40001800000ULL, 0xff80000040407808ULL, 0x000fc40000800000ULL,
0xff80000025257808ULL, 0x000fe40002000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x00000078a1ff7212ULL, 0x000fe400078cc0ffULL, 0x00000080a9ff7212ULL, 0x080fe4000780c0ffULL,
0x00000080afff7212ULL, 0x000fe4000784c0ffULL, 0x00000086a9ff7212ULL, 0x000fc4000786c0ffULL,
0x0000009ca9ff7212ULL, 0x000fe4000782c0ffULL, 0x00000086afff7212ULL, 0x000fe4000788c0ffULL,
0x00000084b5ff7212ULL, 0x000fe200078ac0ffULL, 0x000000018d927824ULL, 0x000fe200078e0a90ULL,
0x0000005e9f00720cULL, 0x080fe400037c1470ULL, 0x0000005ea700720cULL, 0x0c0fe40000701470ULL,
0x0000005ea700720cULL, 0x000fc40001f61470ULL, 0x0000005ea700720cULL, 0x080fe40000f21470ULL,
0x0000005ead00720cULL, 0x0c0fe40001741470ULL, 0x0000005ead00720cULL, 0x080fe40002781470ULL,
0x0000005eb300720cULL, 0x000fe40002fa1470ULL, 0x000000315fbb7812ULL, 0x040fe400078efcffULL,
0x000000385fc17812ULL, 0x000fc400078efcffULL, 0x000000395fc77812ULL, 0x000fe400078efcffULL,
0x0000005e9d00720cULL, 0x080fe400037c1070ULL, 0x0000005ea500720cULL, 0x0c0fe40000701070ULL,
0x0000005ea500720cULL, 0x0c0fe40001f61070ULL, 0x0000005ea500720cULL, 0x080fe40000f21070ULL,
0x0000005eab00720cULL, 0x000fc40001741070ULL, 0x0000005eab00720cULL, 0x080fe40002781070ULL,
0x0000005eb100720cULL, 0x000fe40002fa1070ULL, 0x00000092cbb97219ULL, 0x000fe400000006ffULL,
0x00005410b78e7816ULL, 0x000fe4000000008eULL, 0x00005410cf9a7816ULL, 0x000fe2000000009aULL,
0x00000001bbbd7824ULL, 0x100fe200078e0219ULL, 0xff80000058587808ULL, 0x000fe20003000000ULL,
0x00000001c1c37824ULL, 0x100fe200078e0219ULL, 0xff80000054547808ULL, 0x000fe20000000000ULL,
0x00000001c7c97824ULL, 0x000fe200078e0219ULL, 0xff80000048487808ULL, 0x000fc40001800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000053537808ULL, 0x000fe40001000000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x00000080b5ff7212ULL, 0x040fe400078cc0ffULL, 0x00000086b5ff7212ULL, 0x000fc4000780c0ffULL,
0x00000084afff7212ULL, 0x040fe4000786c0ffULL, 0x0000009cafff7212ULL, 0x080fe4000782c0ffULL,
0x0000009cb5ff7212ULL, 0x000fe4000784c0ffULL, 0x0000008eb9ff7212ULL, 0x040fe4000788c0ffULL,
0x0000009ab9ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001bd947824ULL, 0x100fe200078e0a90ULL,
0x0000005ead00720cULL, 0x080fe20001f61470ULL, 0x00000001c3967824ULL, 0x100fe200078e0a90ULL,
0x0000005ead00720cULL, 0x080fe20000f21470ULL, 0x00000001c9907824ULL, 0x000fe200078e0a90ULL,
0x0000005eb300720cULL, 0x000fc400037c1470ULL, 0x0000005eb300720cULL, 0x0c0fe40000701470ULL,
0x0000005eb300720cULL, 0x080fe40001741470ULL, 0x0000005e8d00720cULL, 0x0c0fe40002781470ULL,
0x0000005e8d00720cULL, 0x000fe40002fa1470ULL, 0x00000094cbbf7219ULL, 0x040fe400000006ffULL,
0x00000096cbc57219ULL, 0x000fc400000006ffULL, 0x0000005eab00720cULL, 0x0c0fe40001f61070ULL,
0x0000005eab00720cULL, 0x080fe40000f21070ULL, 0x0000005eb100720cULL, 0x0c0fe400037c1070ULL,
0x0000005eb100720cULL, 0x0c0fe40000701070ULL, 0x0000005eb100720cULL, 0x080fe40001741070ULL,
0x0000005e8b00720cULL, 0x000fc40002781070ULL, 0x0000005e8b00720cULL, 0x000fe40002fa1070ULL,
0x00000090cbcb7219ULL, 0x000fe400000006ffULL, 0x00005410cd987816ULL, 0x000fe40000000098ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40000800000ULL,
0xff80000052527808ULL, 0x000fc40003000000ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000017177808ULL, 0x000fe40001000000ULL, 0xff80000051517808ULL, 0x000fe40002000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000008ebfff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ec5ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008ecbff7212ULL, 0x000fe400078cc0ffULL,
0x00000098b9ff7212ULL, 0x080fe4000780c0ffULL, 0x00000098bfff7212ULL, 0x080fe4000784c0ffULL,
0x00000098c5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000009abfff7212ULL, 0x000fe400078ac0ffULL,
0x0000005e8d00720cULL, 0x000fc40000701470ULL, 0x0000005ebd00720cULL, 0x0c0fe40001f61470ULL,
0x0000005ebd00720cULL, 0x0c0fe40001741470ULL, 0x0000005ebd00720cULL, 0x080fe40002fa1470ULL,
0x0000005ec300720cULL, 0x080fe40000f21470ULL, 0x0000005ec900720cULL, 0x080fe400037c1470ULL,
0x0000005ec300720cULL, 0x000fc40002781470ULL, 0x0000005e8b00720cULL, 0x080fe40000701070ULL,
0x0000005ebb00720cULL, 0x0c0fe40001f61070ULL, 0x0000005ebb00720cULL, 0x0c0fe40001741070ULL,
0x0000005ebb00720cULL, 0x080fe40002fa1070ULL, 0x0000005ec100720cULL, 0x080fe40000f21070ULL,
0x0000005ec700720cULL, 0x000fc400037c1070ULL, 0x0000005ec100720cULL, 0x000fe40002781070ULL,
0x00005410d39e7816ULL, 0x000fe4000000009eULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fc40002800000ULL, 0xff8000004f4f7808ULL, 0x000fe40000800000ULL,
0xff8000004e4e7808ULL, 0x000fe40003000000ULL, 0xff8000004c4c7808ULL, 0x000fe40002000000ULL,
0x00000098cbff7212ULL, 0x000fe4000780c0ffULL, 0x0000009ac5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000009acbff7212ULL, 0x000fc4000784c0ffULL, 0x0000009eb9ff7212ULL, 0x080fe400078ac0ffULL,
0x0000009ebfff7212ULL, 0x080fe4000782c0ffULL, 0x0000009ec5ff7212ULL, 0x080fe400078cc0ffULL,
0x0000009ecbff7212ULL, 0x000fe4000788c0ffULL, 0x0000005e8d00720cULL, 0x080fe40002fa1470ULL,
0x0000005ebd00720cULL, 0x000fc40000f21470ULL, 0x0000005ec300720cULL, 0x0c0fe40001f61470ULL,
0x0000005ec300720cULL, 0x080fe400037c1470ULL, 0x0000005ec900720cULL, 0x0c0fe40000701470ULL,
0x0000005ec900720cULL, 0x0c0fe40001741470ULL, 0x0000005ec900720cULL, 0x080fe40002781470ULL,
0x0000005e8b00720cULL, 0x000fc40002fa1070ULL, 0x0000005ebb00720cULL, 0x080fe40000f21070ULL,
0x0000005ec700720cULL, 0x080fe40000701070ULL, 0x0000005ec100720cULL, 0x0c0fe40001f61070ULL,
0x0000005ec100720cULL, 0x080fe400037c1070ULL, 0x0000005ec700720cULL, 0x0c0fe40001741070ULL,
0x0000005ec700720cULL, 0x000fc40002781070ULL, 0xff8000004a4a7808ULL, 0x000fe40000000000ULL,
0xff80000046467808ULL, 0x000fe40001800000ULL, 0xff80000049497808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fc40003000000ULL, 0xff80000023237808ULL, 0x000fc40002000000ULL,
0x0000005d0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff107424ULL, 0x000fe200078e00ffULL,
0x0000002e0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x000000390600720bULL, 0x000fe40003f5e000ULL, 0x000000280700720bULL, 0x000fe40003f7e000ULL,
0x000000045d047208ULL, 0x000fe40004000000ULL, 0x000000052e087208ULL, 0x000fc40004800000ULL,
0x0000000639057208ULL, 0x000fe40005000000ULL, 0x0000000728077208ULL, 0x000fe40005800000ULL,
0x000000550400720bULL, 0x000fe40003f1e000ULL, 0x000000380500720bULL, 0x000fe40003f5e000ULL,
0x0000004b0800720bULL, 0x000fe40003f3e000ULL, 0x0000002c0700720bULL, 0x000fc40003f7e000ULL,
0x0000000455097208ULL, 0x000fe40004000000ULL, 0x0000000538057208ULL, 0x000fe40005000000ULL,
0x000000084b087208ULL, 0x000fe40004800000ULL, 0x000000072c047208ULL, 0x000fe40005800000ULL,
0x0000005c0900720bULL, 0x000fe40003f1e000ULL, 0x0000003a0500720bULL, 0x000fc40003f5e000ULL,
0x0000002f0800720bULL, 0x000fe40003f3e000ULL, 0x000000270400720bULL, 0x000fe40003f7e000ULL,
0x000000095c097208ULL, 0x000fe40004000000ULL, 0x000000053a067208ULL, 0x000fe40005000000ULL,
0x000000082f087208ULL, 0x000fe40004800000ULL, 0x0000000427047208ULL, 0x000fc40005800000ULL,
0x000000560900720bULL, 0x000fe40003f1e000ULL, 0x0000003b0600720bULL, 0x000fe40003f5e000ULL,
0x000000310800720bULL, 0x000fe40003f3e000ULL, 0x000000290400720bULL, 0x000fe40003f7e000ULL,
0x00000009560a7208ULL, 0x000fe40004000000ULL, 0x000000063b077208ULL, 0x000fc40005000000ULL,
0x0000000831057208ULL, 0x000fe40004800000ULL, 0x0000000429097208ULL, 0x000fe40005800000ULL,
0x0000005b0a00720bULL, 0x000fe40003f1e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x000000300500720bULL, 0x000fe40003f3e000ULL, 0x0000002a0900720bULL, 0x000fc40003f7e000ULL,
0x0000000a5b0a7208ULL, 0x000fe40004000000ULL, 0x000000073c067208ULL, 0x000fe40005000000ULL,
0x0000000530047208ULL, 0x000fe40004800000ULL, 0x000000092a087208ULL, 0x000fe40005800000ULL,
0x000000570a00720bULL, 0x000fe40003f1e000ULL, 0x0000003d0600720bULL, 0x000fc40003f5e000ULL,
0x000000470400720bULL, 0x000fe40003f3e000ULL, 0x0000002d0800720bULL, 0x000fe40003f7e000ULL,
0x0000000a57057208ULL, 0x000fe40004000000ULL, 0x000000063d097208ULL, 0x000fe40005000000ULL,
0x0000000447077208ULL, 0x000fe40004800000ULL, 0x000000082d087208ULL, 0x000fc40005800000ULL,
0x0000005a0500720bULL, 0x000fe40003f1e000ULL, 0x0000003e0900720bULL, 0x000fe40003f5e000ULL,
0x000000320700720bULL, 0x000fe40003f3e000ULL, 0x0000002b0800720bULL, 0x000fe40003f7e000ULL,
0x000000055a057208ULL, 0x000fe40004000000ULL, 0x000000093e047208ULL, 0x000fc40005000000ULL,
0x0000000732077208ULL, 0x000fe40004800000ULL, 0x000000082b097208ULL, 0x000fe40005800000ULL,
0x000000580500720bULL, 0x000fe40003f1e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x000000340700720bULL, 0x000fe40003f3e000ULL, 0x000000260900720bULL, 0x000fc40003f7e000ULL,
0x0000000558067208ULL, 0x000fe40004000000ULL, 0x000000043f057208ULL, 0x000fe40005000000ULL,
0x0000000734087208ULL, 0x000fe40004800000ULL, 0x0000000926047208ULL, 0x000fe40005800000ULL,
0x000000590600720bULL, 0x000fe40003f1e000ULL, 0x000000400500720bULL, 0x000fc40003f5e000ULL,
0x000000330800720bULL, 0x000fe40003f3e000ULL, 0x000000250400720bULL, 0x000fe40003f7e000ULL,
0x0000000659077208ULL, 0x000fe40004000000ULL, 0x0000000540067208ULL, 0x000fe40005000000ULL,
0x0000000833097208ULL, 0x000fe40004800000ULL, 0x0000000425057208ULL, 0x000fc40005800000ULL,
0x000000540700720bULL, 0x000fe40003f1e000ULL, 0x000000480900720bULL, 0x000fe40003f3e000ULL,
0x000000410600720bULL, 0x000fe40003f5e000ULL, 0x000000240500720bULL, 0x000fe40003f7e000ULL,
0x0000000754047208ULL, 0x000fe40004000000ULL, 0x0000000948087208ULL, 0x000fc40004800000ULL,
0x0000000641077208ULL, 0x000fe40005000000ULL, 0x0000000524057208ULL, 0x000fe40005800000ULL,
0x000000530400720bULL, 0x000fe40003f1e000ULL, 0x000000350800720bULL, 0x000fe40003f3e000ULL,
0x000000420700720bULL, 0x000fe40003f5e000ULL, 0x000000160500720bULL, 0x000fc40003f7e000ULL,
0x0000000453097208ULL, 0x000fe40004000000ULL, 0x00000008350b7208ULL, 0x000fe40004800000ULL,
0x0000000742047208ULL, 0x000fe40005000000ULL, 0x0000000516067208ULL, 0x000fe40005800000ULL,
0x000000520900720bULL, 0x000fe40003f1e000ULL, 0x000000440b00720bULL, 0x000fc40003f3e000ULL,
0x000000430400720bULL, 0x000fe40003f5e000ULL, 0x000000170600720bULL, 0x000fe40003f7e000ULL,
0x0000000952087208ULL, 0x000fe40004000000ULL, 0x0000000b440b7208ULL, 0x000fe40004800000ULL,
0x0000000443047208ULL, 0x000fe40005000000ULL, 0x0000000617057208ULL, 0x000fc40005800000ULL,
0x000000510800720bULL, 0x000fe40003f1e000ULL, 0x000000360b00720bULL, 0x000fe40003f3e000ULL,
0x0000004d0400720bULL, 0x000fe40003f5e000ULL, 0x000000200500720bULL, 0x000fe40003f7e000ULL,
0x0000000851077208ULL, 0x000fe40004000000ULL, 0x0000000b36067208ULL, 0x000fc40004800000ULL,
0x000000044d047208ULL, 0x000fe40005000000ULL, 0x0000000520087208ULL, 0x000fe40005800000ULL,
0x000000500700720bULL, 0x000fe40003f1e000ULL, 0x000000370600720bULL, 0x000fe40003f3e000ULL,
0x000000450400720bULL, 0x000fe40003f5e000ULL, 0x000000210800720bULL, 0x000fc40003f7e000ULL,
0x00000007500a7208ULL, 0x000fe40004000000ULL, 0x0000000637057208ULL, 0x000fe40004800000ULL,
0x0000000445077208ULL, 0x000fe40005000000ULL, 0x0000000821097208ULL, 0x000fe40005800000ULL,
0x0000004f0a00720bULL, 0x000fe40003f1e000ULL, 0x0000004c0500720bULL, 0x000fc40003f3e000ULL,
0x000000460700720bULL, 0x000fe40003f5e000ULL, 0x000000220900720bULL, 0x000fe40003f7e000ULL,
0x0000000a4f0b7208ULL, 0x000fe40004000000ULL, 0x000000054c057208ULL, 0x000fe40004800000ULL,
0x0000000746047208ULL, 0x000fe40005000000ULL, 0x0000000922067208ULL, 0x000fc40005800000ULL,
0x0000004e0b00720bULL, 0x000fe40003f1e000ULL, 0x0000004a0500720bULL, 0x000fe40003f3e000ULL,
0x000000490400720bULL, 0x000fe40003f5e000ULL, 0x000000230600720bULL, 0x000fe40003f7e000ULL,
0x0000000b4e077208ULL, 0x000fe40004000000ULL, 0x000000054a0a7208ULL, 0x000fc40004800000ULL,
0x00000004490e7208ULL, 0x000fe40005000000ULL, 0x00000006230d7208ULL, 0x000fe20005800000ULL,
0x00001fe27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x000000040700720bULL, 0x008fc80003f1e000ULL, 0x00000007040f7208ULL, 0x000fe20004000000ULL,
0x00001ff27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000a047f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e057f89ULL, 0x000e6800000e0000ULL, 0x0c401f000d067f89ULL, 0x000ea200000e0000ULL,
0x000000040a00720bULL, 0x008fc40003f1e000ULL, 0x000000050e00720bULL, 0x002fe40003f3e000ULL,
0x0000000a04077208ULL, 0x004fe40004000000ULL, 0x0000000e05087208ULL, 0x000fe20004800000ULL,
0x0c201f000f047f89ULL, 0x000e6200000e0000ULL, 0x000000060d00720bULL, 0x000fc60003f1e000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x0000000d060a7208ULL, 0x000fc60004000000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL,
0x000000040f00720bULL, 0x002fe40003f1e000ULL, 0x0000000c0700720bULL, 0x004fe40003f3e000ULL,
0x0000000f04047208ULL, 0x000fc40004000000ULL, 0x000000090800720bULL, 0x008fe40003f5e000ULL,
0x000000070c057208ULL, 0x000fe40004800000ULL, 0x0000000809067208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x3fb8aa3b060e7820ULL, 0x000fe20000410000ULL, 0x00000002ff5f7819ULL, 0x000fe20000011665ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5d5d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5c5c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x0000005500097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b59557823ULL, 0x102fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000005d00087308ULL, 0x000e620000000800ULL, 0x000000085f117824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a077823ULL, 0x000fe20000010807ULL, 0x0000005c005c7308ULL, 0x000fe20000000800ULL,
0x000000085f727824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080eULL, 0x0000000700597308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b40407823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b43437823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL, 0x00000056000d7308ULL, 0x0006620000000800ULL,
0x0000000a0b077208ULL, 0x004fe20004000000ULL, 0x3fb8aa3b46467823ULL, 0x100fe2000001080eULL,
0x000000015f0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b490e7823ULL, 0x000fe2000001080eULL,
0x000000025f0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000085f787824ULL, 0x000fe200078e00ffULL,
0xfffffff811707812ULL, 0x000fe200078ee20aULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b07567820ULL, 0x008fe20000410000ULL, 0xfffffff872727812ULL, 0x000fe200078ee20bULL,
0x000000085f137824ULL, 0x040fe200078e00ffULL, 0x000000045f0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010856ULL, 0x0000004b004b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010856ULL, 0x000000055f0b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff811767812ULL, 0x000fe200078ee20aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL, 0xfffffff878787812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010856ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000080908723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010856ULL,
0x0000005c0d0a723eULL, 0x000fe200000000ffULL, 0x000000085f0d7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010856ULL, 0x00000031000c7308ULL, 0x000e620000000800ULL,
0x0000002e4b09723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b214b7823ULL, 0x000fe20000010856ULL,
0x0000000c15157812ULL, 0x000fc400078ec0ffULL, 0x0000000365ff7812ULL, 0x000fc6000780c0ffULL,
0x00000058005d7308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002f0c0b723eULL, 0x002fe400000000ffULL, 0xffffffff5f0c7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff80d5c7812ULL, 0x000fe200078ee20cULL, 0x0000002c000f7308ULL, 0x000e700000000800ULL,
0x0000003900397308ULL, 0x000ff00000000800ULL, 0x0000003800387308ULL, 0x000ea20000000800ULL,
0x000000280f0d723eULL, 0x002fce00000000ffULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000e620000000800ULL, 0x00000039380c723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b20387823ULL, 0x000fcc0000010856ULL, 0x0000000e00497308ULL, 0x0005f00000000800ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000035f0e7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff813747812ULL, 0x000fe400078ee20eULL, 0x000000065f0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000002900587308ULL, 0x000ea60000000800ULL, 0xfffffff8137a7812ULL, 0x000fe400078ee20eULL,
0x0000003a3b0e723eULL, 0x002fc600000000ffULL, 0x00000057005e7308ULL, 0x000ff00000000800ULL,
0x0000003400577308ULL, 0x0003e20000000800ULL, 0x00000027580f723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b16277823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b22587823ULL, 0x000fca0000010856ULL,
0x0000003500317308ULL, 0x0005e20000000800ULL, 0x3c003c00ff347424ULL, 0x002fce00078e00ffULL,
0x0000005b005b7308ULL, 0x000e620000000800ULL, 0x3c003c00ff357424ULL, 0x004fce00078e00ffULL,
0x000000340810723cULL, 0x000f6200000018ffULL, 0x0000005a005a7308ULL, 0x000ea20000000800ULL,
0x0000005b5e20723eULL, 0x002fce00000000ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000105f5e7810ULL, 0x000fca0007ffe0ffULL, 0x000000085e2f7824ULL, 0x000fe400078e00ffULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x0000005a5d22723eULL, 0x004fe400000000ffULL,
0x000000085f5a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82f5e7812ULL, 0x000fc600078ee25eULL,
0x0000003200327308ULL, 0x000eb00000000800ULL, 0x00000045004a7308ULL, 0x000fe20000000800ULL,
0x000000304721723eULL, 0x002fce00000000ffULL, 0x0000002a002c7308ULL, 0x000ff00000000800ULL,
0x0000002b00457308ULL, 0x0003f00000000800ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x000000340c28723cULL, 0x002f6e00000018ffULL, 0x0000003d003d7308ULL, 0x000e700000000800ULL,
0x0000003e003e7308ULL, 0x000ff00000000800ULL, 0x0000003f003f7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000ef00000000800ULL, 0x00000026002e7308ULL, 0x0003f00000000800ULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24267823ULL, 0x102fe20000010856ULL,
0x3fb8aa3b23567823ULL, 0x000fe20000010856ULL, 0x000000325723723eULL, 0x004fc400000000ffULL,
0x0000003c3d24723eULL, 0x000fc600000000ffULL, 0x0000005400547308ULL, 0x000e640000000800ULL,
0x000000342010723cULL, 0x020f6c0000001810ULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005200527308ULL, 0x000ff00000000800ULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x0000004800487308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000eb00000000800ULL,
0x0000002500397308ULL, 0x0007f00000000800ULL, 0x0000002600167308ULL, 0x0004a20000000800ULL,
0x0000002c2d25723eULL, 0x008fe200000000ffULL, 0x000000085a2d7824ULL, 0x000fe200078e00ffULL,
0x00000055542c723eULL, 0x002fc400000000ffULL, 0x00000031442f723eULL, 0x004fe400000000ffULL,
0xfffffff82d5a7812ULL, 0x000fe200078ee25aULL, 0x00000027003b7308ULL, 0x0003e20000000800ULL,
0x0000003e3f26723eULL, 0x000fe200000000ffULL, 0x000000085f3e7824ULL, 0x000fe200078e00ffULL,
0x00000033482d723eULL, 0x000fc800000000ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee25fULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000452e27723eULL, 0x002fe400000000ffULL,
0x00000053522e723eULL, 0x000fe400000000ffULL, 0x000000391639723eULL, 0x000fe400000000ffULL,
0x000000185f5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000342428723cULL, 0x000f620000001828ULL,
0x0000004100417308ULL, 0x000fe60000000800ULL, 0x000000085f7c7824ULL, 0x000fc800078e00ffULL,
0x000000342c10723cULL, 0x020f620000001810ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0xfffffff87c7c7812ULL, 0x000fce00078ee25fULL, 0x0000004300437308ULL, 0x000e700000000800ULL,
0x00000017003c7308ULL, 0x0004f00000000800ULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x00000042433a723eULL, 0x002fc400000000ffULL, 0x0000a0001f177811ULL, 0x004fca00078e60ffULL,
0x0000005000507308ULL, 0x000e620000000800ULL, 0x0000003b3c3b723eULL, 0x008fe200000000ffULL,
0x000000103e3e7824ULL, 0x100fe400078e0217ULL, 0x0000001070707824ULL, 0x100fe400078e0217ULL,
0x0000001072727824ULL, 0x100fe400078e0217ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x0000001074747824ULL, 0x100fe400078e0217ULL, 0x0000001076767824ULL, 0x000fc400078e0217ULL,
0x0000001078787824ULL, 0x100fe400078e0217ULL, 0x0000000115707824ULL, 0x040fe200078e0270ULL,
0x0000004e004e7308ULL, 0x000ea20000000800ULL, 0x000000515030723eULL, 0x002fe200000000ffULL,
0x000000107a7a7824ULL, 0x100fe400078e0217ULL, 0x0000000115727824ULL, 0x040fe400078e0272ULL,
0x000000105c5c7824ULL, 0x000fe400078e0217ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000000115747824ULL, 0x000fc400078e0274ULL, 0x000000105a5a7824ULL, 0x000fe400078e0217ULL,
0x0000000115767824ULL, 0x040fe400078e0276ULL, 0x0000000115787824ULL, 0x040fe200078e0278ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x0000004f4e32723eULL, 0x004fe200000000ffULL,
0x00000001157a7824ULL, 0x040fe400078e027aULL, 0x00000001155c7824ULL, 0x040fe400078e025cULL,
0x00000001155a7824ULL, 0x000fc400078e025aULL, 0x0000004c004c7308ULL, 0x000ea20000000800ULL,
0x000000105e5e7824ULL, 0x100fe400078e0217ULL, 0x000000107c7c7824ULL, 0x000fc800078e0217ULL,
0x00000001157c7824ULL, 0x000fe200078e027cULL, 0x00000038003d7308ULL, 0x0007e20000000800ULL,
0x000000363731723eULL, 0x002fe200000000ffULL, 0x000000013e377824ULL, 0x000fca00078e0215ULL,
0x0000000837007388ULL, 0x000fe20000000800ULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x000000404138723eULL, 0x008fe400000000ffULL, 0x0000004c5933723eULL, 0x004fe200000000ffULL,
0x0000000a70007388ULL, 0x000fe80000000800ULL, 0x000000343828723cULL, 0x080fe20000001828ULL,
0x0000004600467308ULL, 0x000ea20000000800ULL, 0x0000002072007388ULL, 0x000fe80000000800ULL,
0x0000002274007388ULL, 0x000fe40000000800ULL, 0x000000343010723cULL, 0x020f620000001810ULL,
0x0000004b00507308ULL, 0x000ee20000000800ULL, 0x0000004d4a3c723eULL, 0x002fe200000000ffULL,
0x0000002c76007388ULL, 0x000fe80000000800ULL, 0x0000002e78007388ULL, 0x000fe40000000800ULL,
0x00000058003f7308ULL, 0x000fe20000000800ULL, 0x00000046493e723eULL, 0x004fe200000000ffULL,
0x000000307a007388ULL, 0x000fe80000000800ULL, 0x000000325c007388ULL, 0x000fe40000000800ULL,
0x0000005600567308ULL, 0x000e620000000800ULL, 0x0000003d503d723eULL, 0x008fe200000000ffULL,
0x000000095a007388ULL, 0x000fe20000000800ULL, 0x0000000115117824ULL, 0x020fc600078e025eULL,
0x0004000b70007388ULL, 0x000fe80000000800ULL, 0x0004002172007388ULL, 0x000fe80000000800ULL,
0x0004002374007388ULL, 0x000fe20000000800ULL, 0x0000003f563f723eULL, 0x002fc600000000ffULL,
0x0004002d76007388ULL, 0x000fe80000000800ULL, 0x0004002f78007388ULL, 0x000fe20000000800ULL,
0x000000343c28723cULL, 0x000f660000001828ULL, 0x000400317a007388ULL, 0x000fe80000000800ULL,
0x000400335c007388ULL, 0x000fe80000000800ULL, 0x0000000c11007388ULL, 0x0003e80000000800ULL,
0x0008000e70007388ULL, 0x0005e80000000800ULL, 0x0008002472007388ULL, 0x0005e20000000800ULL,
0x000000ffff117224ULL, 0x002fc600078e0012ULL, 0x0008002674007388ULL, 0x0005e20000000800ULL,
0x000000ffff127224ULL, 0x020fe400078e0028ULL, 0x000000ffff137224ULL, 0x000fe200078e002aULL,
0x0008003876007388ULL, 0x0005e80000000800ULL, 0x0008003a78007388ULL, 0x0005e80000000800ULL,
0x0008003c7a007388ULL, 0x0005e80000000800ULL, 0x0008003e5c007388ULL, 0x0005e80000000800ULL,
0x0000000d7c007388ULL, 0x0005e80000000800ULL, 0x000c000f70007388ULL, 0x0005e80000000800ULL,
0x000c002572007388ULL, 0x0005e80000000800ULL, 0x000c002774007388ULL, 0x0005e80000000800ULL,
0x000c003976007388ULL, 0x0005e80000000800ULL, 0x000c003b78007388ULL, 0x0005e80000000800ULL,
0x000c003d7a007388ULL, 0x0005e80000000800ULL, 0x000c003f5c007388ULL, 0x0005e80000000800ULL,
0x0120000414008388ULL, 0x0005e80000000c00ULL, 0x0122001014008388ULL, 0x0005e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008006aff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010006aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL,
0x000018006aff7f8cULL, 0x0003e6000c80043fULL, 0x0000001a6c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff96f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x00016cc000297802ULL, 0x000fc40000000f00ULL, 0x0000108000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xfffebfb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x00016d1000297802ULL, 0x000fc40000000f00ULL,
0x0000103000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xfffec01000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00016d6000287802ULL, 0x000fc40000000f00ULL, 0x00000f9000007944ULL, 0x014fea0003c00000ULL,
0xfffec0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00016da000287802ULL, 0x000fc40000000f00ULL, 0x00000f5000007944ULL, 0x016fea0003c00000ULL,
0xfffec21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00016de000287802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x01efea0003c00000ULL,
0xfffec34000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00016e2000287802ULL, 0x000fc40000000f00ULL, 0x00000ed000007944ULL, 0x01efea0003c00000ULL,
0xfffec46000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00016e7000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x00000e8000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffec88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00016ec000287802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001003297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x00016f1000287802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffec83000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00016f6000287802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffec81000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe40004000000ULL, 0x00016fb000297802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff257224ULL, 0x000fe200078e0028ULL,
0xfffee9b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001700000297802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0028ULL, 0xfffee9f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001705000287802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x004fea0003c00000ULL, 0xfffeead000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001709000287802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x006fea0003c00000ULL, 0xfffeec0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x000170d000287802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x00efea0003c00000ULL, 0xfffeed3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001711000287802ULL, 0x000fc40000000f00ULL,
0x00000be000007944ULL, 0x00efea0003c00000ULL, 0xfffeee5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001716000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0025ULL, 0x00000b9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffef27000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000171b000287802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001720000287802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffef22000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001725000287802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffef20000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x000172a000297802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0028ULL, 0xffff119000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x000172f000297802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0028ULL,
0xffff11e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001734000287802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x018fea0003c00000ULL,
0xffff12c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001738000287802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x01afea0003c00000ULL,
0xffff13f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x000173c000287802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x01afea0003c00000ULL,
0xffff152000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001740000287802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x01afea0003c00000ULL,
0xffff164000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001745000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0023ULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff1a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000174a000287802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001023297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000174f000287802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff19f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001754000287802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff19d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x0001759000297802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xffff393000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x000175e000297802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xffff398000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001763000287802ULL, 0x000fc40000000f00ULL,
0x000006c000007944ULL, 0x018fea0003c00000ULL, 0xffff3a5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001767000287802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x01afea0003c00000ULL, 0xffff3b8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x000176b000287802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x01afea0003c00000ULL, 0xffff3cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x000176f000287802ULL, 0x000fc40000000f00ULL,
0x0000060000007944ULL, 0x01afea0003c00000ULL, 0xffff3dd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001774000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0006ULL, 0x000005b000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff41f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001779000287802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001006297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x000177e000287802ULL, 0x000fc40000000f00ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff41a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001783000287802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff418000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001788000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdfe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e000aULL, 0x000178e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x0001794000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000dULL,
0x000179a000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000fULL,
0x00017a0000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000d0b0a7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x00017a6000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000f0b047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x00017ac000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x00017b2000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdeb000007947ULL, 0x000fea000383ffffULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000021027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe835002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001100007348ULL, 0x000fe80003800000ULL, 0x0c00000c070b7389ULL, 0x0002a200000e0010ULL,
0xfffe831008007950ULL, 0x000fea0003c3ffffULL, 0x0000008200007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a200000e0083ULL, 0x00000000ff2b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2a7224ULL, 0x002fc800078e0028ULL, 0xfffe82c02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f65070ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0029ULL,
0x0000008100007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fce00078e00ffULL,
0x0000000000287806ULL, 0x000fc800058e0100ULL, 0x0000008128287212ULL, 0x000fe200078ec0ffULL,
0xfffe82502a007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000320ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c50ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d10ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015c0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001660ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001664ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017e80ULL, 0xd600001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019700ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019740ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000019ac0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001660ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000180a0ULL,
0x00000000000180a0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000019ac0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin_len = 105376;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
