/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b7c0ULL, 0x000000000001b440ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000019810ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000019990ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x00000000000199d0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000019a20ULL, 0x0000000000000160ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000019b80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001981000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x0064700400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001981000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL, 0xa808288080a70828ULL,
0x288080aa08288080ULL, 0x80f808288080f108ULL, 0x1628808088082880ULL, 0x0000031028808280ULL,
0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x0001999000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL,
0x082880808f082880ULL, 0x8080a508288080a2ULL, 0xa908288080a70828ULL, 0x288080aa08288080ULL,
0x80f808288080f108ULL, 0x16288080a8082880ULL, 0x0000031028808280ULL, 0xa892000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL, 0x000199d000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80aa288080a80900ULL, 0x0000000000002880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL, 0xa808288080a70828ULL,
0x288080aa08288080ULL, 0x80f808288080f108ULL, 0x16288080a9082880ULL, 0x0000031028808280ULL,
0xa992000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000027000000000ULL,
0x00019a2000000000ULL, 0x0000016000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL,
0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000e1ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL,
0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000016ULL,
0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000eb000043104ULL,
0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00000170019c2804ULL, 0x000005a000000340ULL, 0x00002d0000002c70ULL, 0x00002f8000002e10ULL,
0x00003250000030f0ULL, 0x00003710000036d0ULL, 0x0000375000003720ULL, 0x000059c000005930ULL,
0x00005c5000005ae0ULL, 0x00005f2000005dc0ULL, 0x000063e0000063a0ULL, 0x00006420000063f0ULL,
0x000084a000008400ULL, 0x00008730000085c0ULL, 0x00008a00000088a0ULL, 0x00008ea000008e60ULL,
0x00008ee000008eb0ULL, 0x0000af300000ae90ULL, 0x0000b1b00000b040ULL, 0x0000b4800000b320ULL,
0x0000b9400000b900ULL, 0x0000b9800000b950ULL, 0x0000ce000000cdf0ULL, 0x0000ce200000ce10ULL,
0x0001700000016fc0ULL, 0x0001702000017010ULL, 0x0001709000017070ULL, 0x000170c0000170b0ULL,
0x0001848000018420ULL, 0x00018550000184f0ULL, 0x00018610000185b0ULL, 0x000186f000018680ULL,
0x000187d000018760ULL, 0x0001889000018830ULL, 0x0001896000018900ULL, 0x00018a20000189c0ULL,
0x00018b0000018a90ULL, 0x00018be000018b70ULL, 0x00018ca000018c40ULL, 0x00018d7000018d10ULL,
0x00018e3000018dd0ULL, 0x00018f1000018ea0ULL, 0x00018ff000018f80ULL, 0x000190b000019050ULL,
0x0001918000019120ULL, 0x00019240000191e0ULL, 0x00019320000192b0ULL, 0x0001940000019390ULL,
0x000194f000019470ULL, 0x000195f000019570ULL, 0x000196f000019670ULL, 0x000197f000019770ULL,
0x0000043004403904ULL, 0x0001a600000000ffULL, 0x00000470003f0100ULL, 0x0001a6080000000fULL,
0x000004f0003f0120ULL, 0x0001a6880000000fULL, 0x00000510003f0120ULL, 0x0001a6a80000000fULL,
0x00000530003f0120ULL, 0x0001a6c80000000fULL, 0x00000ec0003f0120ULL, 0x0001a600000000ffULL,
0x000010c0003f0107ULL, 0x0000000400000002ULL, 0x00001170003f0102ULL, 0x0000000000000002ULL,
0x00001ae0003f0101ULL, 0x00000000000000ffULL, 0x00001b6000040107ULL, 0x00000000000000ffULL,
0x00001bc000040101ULL, 0x0000002000000006ULL, 0x00001d50003f0101ULL, 0x0001a6cc00000008ULL,
0x00001f30003f0105ULL, 0x0001a6cc00000008ULL, 0x00002870003f0105ULL, 0x0001a6b00000000aULL,
0x00002920003f0107ULL, 0x0001a6b00000000aULL, 0x00002980003f0101ULL, 0x0001a60800000022ULL,
0x000029a0003f0101ULL, 0x0001a60c00000022ULL, 0x00002b70003f0105ULL, 0x0001a60c00000022ULL,
0x00003400003f0105ULL, 0x0001a6ac0000000aULL, 0x000035f0003f0105ULL, 0x0001a6ac0000000aULL,
0x00004af0003f0105ULL, 0x000000000000006cULL, 0x00004b50003f0101ULL, 0x0001a68800000025ULL,
0x00004b80003f0101ULL, 0x0000000400000013ULL, 0x00004d40003f0105ULL, 0x0000000400000013ULL,
0x00005530003f0105ULL, 0x0000000000000010ULL, 0x00005610003f0107ULL, 0x0000000000000010ULL,
0x00005670003f0101ULL, 0x0001a62800000022ULL, 0x00005690003f0101ULL, 0x0001a62c00000022ULL,
0x00005860003f0105ULL, 0x0001a62c00000022ULL, 0x00006110003f0105ULL, 0x0001a6b40000006eULL,
0x000062e0003f0105ULL, 0x0001a6b40000006eULL, 0x000075a0003f0105ULL, 0x000000000000006eULL,
0x00007600003f0101ULL, 0x0001a69000000028ULL, 0x00007630003f0101ULL, 0x0000000400000013ULL,
0x000077f0003f0105ULL, 0x0000000400000013ULL, 0x00007ff0003f0105ULL, 0x00000008000000ffULL,
0x000080e000040107ULL, 0x0001a6b00000002aULL, 0x00008140003f0101ULL, 0x0001a64800000022ULL,
0x00008160003f0101ULL, 0x0001a64c00000022ULL, 0x00008330003f0105ULL, 0x0001a64c00000022ULL,
0x00008bd0003f0105ULL, 0x0000000400000010ULL, 0x00008da0003f0105ULL, 0x0000000400000010ULL,
0x0000a040003f0105ULL, 0x0000000000000013ULL, 0x0000a0a0003f0101ULL, 0x0001a69800000002ULL,
0x0000a0d0003f0101ULL, 0x0000000400000013ULL, 0x0000a290003f0105ULL, 0x0000000400000013ULL,
0x0000aaf0003f0105ULL, 0x00000000000000ffULL, 0x0000ab8000040107ULL, 0x0000000000000010ULL,
0x0000abe0003f0101ULL, 0x0001a66800000006ULL, 0x0000ac10003f0101ULL, 0x0001a66c00000006ULL,
0x0000ade0003f0105ULL, 0x0001a66c00000006ULL, 0x0000b660003f0105ULL, 0x0001a6b40000000aULL,
0x0000b830003f0105ULL, 0x0001a6b40000000aULL, 0x0000cba0003f0105ULL, 0x0000000000000013ULL,
0x0000cc20003f0101ULL, 0x0000000000000006ULL, 0x0000ee40003f0101ULL, 0x0001a600000000ffULL,
0x00010770003f0101ULL, 0x0001a604000000ffULL, 0x00010980003f0105ULL, 0x0001a604000000ffULL,
0x00010d00003f0105ULL, 0x0001a600000000ffULL, 0x00010d30003f0101ULL, 0x0001a604000000ffULL,
0x00010ef0003f0105ULL, 0x0001a604000000ffULL, 0x000142b0003f0105ULL, 0x0000000000000067ULL,
0x00014340003f0101ULL, 0x0000000400000067ULL, 0x00014510003f0105ULL, 0x0000000400000067ULL,
0x00018260003f0105ULL, 0x0000000000000064ULL, 0x000182c0003f0101ULL, 0x0000000800000064ULL,
0x00018320003f0101ULL, 0x0000001000000064ULL, 0x00018390003f0101ULL, 0x0000001800000064ULL,
0x00053803003f0101ULL, 0x0000dd2000301c04ULL, 0x0000dff00000dd50ULL, 0x0000e3d00000e1e0ULL,
0x0000e7b00000e5c0ULL, 0x0000eba00000e9a0ULL, 0x00010f500000ed50ULL, 0x00000401000183e0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000314ULL, 0x0000001900000002ULL, 0x000000000000024cULL,
0x0000001900000002ULL, 0x0000000000000194ULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x00000000000002eeULL,
0x0000001900000002ULL, 0x0000000000000226ULL, 0x0000001900000002ULL, 0x000000000000016eULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606190981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff187624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000001e7919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000e7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff1f7819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff1f1f7589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x008fc800078e0a05ULL,
0x0000040003007624ULL, 0x000fca00078e0218ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000307077227ULL, 0x000fe400078e0006ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000001e07207227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a20ULL, 0x0000000005007224ULL, 0x000fca00078e021eULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x000001000e037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0e0e7589ULL, 0x000e6400000e0000ULL, 0x00000000030f7a24ULL, 0x000fd000078e020aULL,
0x0000000100005824ULL, 0x000fe200078e0a05ULL, 0x0000000120205810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000050000720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000030f00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0f00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000120206810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x00000005ff20c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01a60006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a20ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x01a608080f009388ULL, 0x000fe20000008a00ULL,
0x00000000051e7224ULL, 0x000fc400078e021eULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x000000201e1e7824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff10a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x01a688060f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x01a6a80a0f00d388ULL, 0x000fe80000008a00ULL,
0x01a400100f00a388ULL, 0x000fe80000004800ULL, 0x01a6c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000119190824ULL, 0x004fe400078e0a02ULL, 0x00005800ff198624ULL, 0x000fc400078e00ffULL,
0x0000580004028a24ULL, 0x000fe400078e02ffULL, 0x00005a0019037a24ULL, 0x000fe400078e02ffULL,
0x0000001102777224ULL, 0x000fe400078e02ffULL, 0x0000000103007824ULL, 0x040fe200078e0a1eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001e0300720cULL, 0x000fe20003f26070ULL,
0x00005a0020107a24ULL, 0x000fe200078e0277ULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff00767207ULL, 0x000fe20000800000ULL, 0x000000040e007824ULL, 0x002fc600078e021fULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x00000000001d7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc8000001161dULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe03077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x000000011e0c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07037227ULL, 0x000fc800078e0006ULL, 0x000000011e067824ULL, 0x000fe400078e020aULL,
0x0000000c030d7227ULL, 0x000fc800078e00ffULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a07ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL,
0x00005a0003037a24ULL, 0x000fe400078e0206ULL, 0x00005a000f087a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x0000000076037217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x040fe20004000000ULL, 0x000000101d037824ULL, 0x000fe200078e00ffULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000000500720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a08ULL, 0x000000f003057812ULL, 0x000fe200078ec0ffULL,
0x00005a000d067a24ULL, 0x000fe400078e0206ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000110067824ULL, 0x040fe400078e0206ULL, 0x00000001100d7824ULL, 0x000fc400078e020cULL,
0x0000001107067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x000000010a007824ULL, 0x100fe200078e021dULL,
0x0000000508057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x0000600006067a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e021dULL,
0x0000600005087a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d007812ULL, 0x000fe400078ee200ULL, 0x0000610007077a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000610009097a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x00000000001d7919ULL, 0x000eae0000000000ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x000000001d007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe03067810ULL, 0x002fe20007ffe0ffULL,
0x000000011e037824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x000000011e077824ULL, 0x000fe400078e020aULL, 0x0000000308057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006067a24ULL, 0x000fe400078e0203ULL,
0x00005a000c097a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x0000000108082810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff067a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000000108083810ULL, 0x000fe40007ffe0ffULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000806087207ULL, 0x000fc60004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006037a24ULL, 0x000fe400078e0203ULL,
0x00005a000c077a24ULL, 0x000fe400078e0207ULL, 0x0000000110067824ULL, 0x040fe400078e0203ULL,
0x0000000110077824ULL, 0x000fc400078e0207ULL, 0x000000101d037824ULL, 0x000fe400078e00ffULL,
0x0000001105067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe200078e0207ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fc600078efcffULL,
0x0000000100057824ULL, 0x100fe200078e021dULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a007824ULL, 0x000fe200078e021dULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x0000610007077a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00b007812ULL, 0x000fe200078ee200ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057300ULL, 0x000e7000000e0000ULL,
0x0000000000077309ULL, 0x000ea20000000000ULL, 0x000000060500720cULL, 0x002fe20003f02070ULL,
0x00000004ff057424ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0a07ULL,
0x0000680004067625ULL, 0x000fd000078e0005ULL, 0x01a60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006061c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000007f1c1b7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1c007810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff1b7819ULL, 0x000fe4000001161bULL, 0x00000008ff1a7819ULL, 0x000fca0000011600ULL,
0x0000dd5000008947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe2000001161fULL,
0x00000003ff097424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x01ffffff19197812ULL, 0x000fc800078ec0ffULL, 0x0000001b1900720cULL, 0x000fda0003f06070ULL,
0x0000000204028824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0002068624ULL, 0x000fe200078e0207ULL, 0x0001a6881f027811ULL, 0x000fc600078e18ffULL,
0x0000000119068824ULL, 0x000fe200078e0206ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040902ff738cULL, 0x0005e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606248981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000008020177824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001161fULL, 0x0000000002ff7f8cULL, 0x0003e2000c80043fULL,
0x000000011f007812ULL, 0x000fc600078ec0ffULL, 0x0000002018807824ULL, 0x000fca00078e00ffULL,
0x0000006017057812ULL, 0x000fe200078ef880ULL, 0x0000590024087a24ULL, 0x00afc800078e02ffULL,
0x0000008008157824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x104fe2000001161dULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x000000801c077217ULL, 0x000fe40007800000ULL, 0x0000000402097810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0202ULL, 0x00006400150f7a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe400078e0a80ULL, 0x0000000106087824ULL, 0x040fe200078e021dULL,
0x0000650015157a11ULL, 0x000fe200020f3cffULL, 0x00000008060b7824ULL, 0x000fe200078e00ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x0000000105067824ULL, 0x000fc600078e0206ULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x0000000c020b7810ULL, 0x040fe40007ffe0ffULL,
0x000000070200720cULL, 0x080fe20003f66070ULL, 0x00000001000a7824ULL, 0x000fe200078e0208ULL,
0x000000070800720cULL, 0x080fe20003f26070ULL, 0x0000000100027824ULL, 0x000fe200078e0209ULL,
0x000000070900720cULL, 0x080fe20003f46070ULL, 0x000000010a087824ULL, 0x040fe200078e021dULL,
0x000000070b00720cULL, 0x000fe20003f06070ULL, 0x000000080a0d7824ULL, 0x000fc400078e00ffULL,
0x00000001000c7824ULL, 0x000fe400078e020bULL, 0x0000000102007824ULL, 0x040fe200078e021dULL,
0xfffffff80d107812ULL, 0x000fe200078ee208ULL, 0x0000000802097824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff809007812ULL, 0x000fe200078ee200ULL,
0x0000000105087824ULL, 0x040fe200078e0202ULL, 0x0000007006067812ULL, 0x000fe200078ef803ULL,
0x00000001050a7824ULL, 0x040fe400078e020aULL, 0x00000001050d7824ULL, 0x000fe200078e020cULL,
0x000000060f067210ULL, 0x000fe20007f9e0ffULL, 0x000000010c027824ULL, 0x040fe400078e021dULL,
0x000000080c057824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff805127812ULL, 0x000fe200078ee202ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008027812ULL, 0x000fc600078ef803ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef803ULL, 0x0000000107077824ULL, 0x000fe200020e0615ULL,
0x000000700c0a7812ULL, 0x000fe400078ef803ULL, 0x0001600018037811ULL, 0x000fe400078e68ffULL,
0x0000000f02027210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e057824ULL, 0x100fe200078e0203ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0203ULL, 0x0000001010117824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000d901c46ULL,
0x0000001012137824ULL, 0x000fe400078e0203ULL, 0x0000000109037824ULL, 0x100fe400020e0615ULL,
0x000000010b097824ULL, 0x100fe400028e0615ULL, 0x000000010d0b7824ULL, 0x000fe200030e0615ULL,
0x00000000020f7faeULL, 0x0003e8000d101c46ULL, 0x0000000008117faeULL, 0x0003e8000c901c46ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000640015117a11ULL, 0x000fc400078038ffULL,
0x0001600018137811ULL, 0x000fe400078e68ffULL, 0x000000001d007211ULL, 0x000fe400078fe8ffULL,
0x0000650015157a11ULL, 0x000fe400000f3cffULL, 0x00000008000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x044fe200078e021dULL, 0x0000000400087810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080a107824ULL, 0x000fc400078e00ffULL,
0x0000000105067824ULL, 0x000fe200078e0200ULL, 0xfffffff8070e7812ULL, 0x000fe200078ee202ULL,
0x000000010a077824ULL, 0x100fe200078e021dULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000108027824ULL, 0x040fe400078e021dULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000000105087824ULL, 0x040fe200078e0208ULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x00000001050a7824ULL, 0x040fe400078e020aULL,
0x00000001050c7824ULL, 0x000fe200078e0200ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x0000000100027824ULL, 0x040fe400078e021dULL, 0x0000000800057824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff805007812ULL, 0x000fe200078ee202ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008027812ULL, 0x000fc600078ef803ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x000fc600078ef803ULL,
0x0000000107077824ULL, 0x000fe200000e0615ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x000000100e057824ULL, 0x100fe200078e0213ULL, 0x0000000211027210ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0213ULL, 0x0000000811087210ULL, 0x040fe40007f3e0ffULL,
0x00000003110a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000109037824ULL, 0x000fe200000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc400078e0213ULL, 0x000000010b097824ULL, 0x000fe200008e0615ULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x0000001000137824ULL, 0x000fe400078e0213ULL,
0x000000010d0b7824ULL, 0x000fe200010e0615ULL, 0x0000000008117faeULL, 0x0003e8000b901c46ULL,
0x000000000a137faeULL, 0x0003e4000b901c46ULL, 0x00000000180473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0001a6a818067811ULL, 0x002fe200078e18ffULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff027f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200006067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000aff000008947ULL, 0x000fea0003800000ULL, 0x0000000204167824ULL, 0x000fe200078e00ffULL,
0x00000002ff157819ULL, 0x000fe2000001161fULL, 0x00006a00ff057624ULL, 0x000fe200078e00ffULL,
0x0000000118757812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x00006a0016167624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x0000000000047805ULL, 0x01afca0000015200ULL,
0x000000041f067824ULL, 0x000fca00078e00ffULL, 0xfffffff806087812ULL, 0x000fc800078ec0ffULL,
0x0001a6c808137810ULL, 0x000fe20007ffe0ffULL, 0x01a6cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f037824ULL, 0x000fe200078e00ffULL,
0x0000000114077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024297824ULL, 0x000fe200078e00ffULL,
0x0000001a0700720cULL, 0x000fc60003f46070ULL, 0x0000010014057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001170b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d087824ULL, 0x000fe200078e00ffULL,
0x000000051c037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161dULL,
0x0000007008277812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021dULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000640029257a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a247824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021dULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000650029297a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000027040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a250a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021dULL, 0x0000002706067212ULL, 0x000fe200078efcffULL,
0x0000000808227824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0224ULL,
0x0000002708087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0629ULL,
0x0000002506067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0001700018037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0629ULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x0000000124237824ULL, 0x000fe200078e021dULL,
0x0000002704047212ULL, 0x000fe200078efcffULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0629ULL, 0x0000002504047210ULL, 0x000fe20007fde0ffULL,
0x0000001012257824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee223ULL,
0x0000001010237824ULL, 0x000fc400078e0203ULL, 0x0000001022277824ULL, 0x100fe400078e0203ULL,
0x0000001024037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a237faeULL, 0x0003e2000e901c46ULL, 0x0000000105057824ULL, 0x000fc600030e0629ULL,
0x0000000006257faeULL, 0x0003e8000e101c46ULL, 0x0000000008277faeULL, 0x0003e8000d901c46ULL,
0x0000000004037faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d097824ULL, 0x000fe200078e00ffULL,
0x0000640029257a11ULL, 0x000fc400078038ffULL, 0x000000041d047211ULL, 0x000fe400078fe8ffULL,
0x0000007009237812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021dULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000650029297a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x040fe400078e021dULL, 0x0000000806107824ULL, 0x000fe200078e00ffULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x0000000108077824ULL, 0x000fe200078e021dULL,
0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000808127824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fc400078e0204ULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x000000010b087824ULL, 0x040fe200078e0208ULL,
0x0000002304047212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe400078e020aULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000425047210ULL, 0x000fc60007f1e0ffULL,
0x000000010a227824ULL, 0x000fe200078e021dULL, 0x0000002306067212ULL, 0x000fe200078efcffULL,
0x000000080a277824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000002308087212ULL, 0x080fe400078efcffULL, 0x0001700018277811ULL, 0x000fe200078e68ffULL,
0x0000000105057824ULL, 0x000fe200000e0629ULL, 0x000000230a0a7212ULL, 0x000fe400078efcffULL,
0x0000000625067210ULL, 0x000fe20007f1e0ffULL, 0x0000001003037824ULL, 0x100fe200078e0227ULL,
0x0000000825087210ULL, 0x040fe20007f7e0ffULL, 0x0000001010237824ULL, 0x000fe200078e0227ULL,
0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x0000001012257824ULL, 0x000fc400078e0227ULL, 0x0000000109097824ULL, 0x000fe200018e0629ULL,
0x0000000006237faeULL, 0x0003e2000b901c46ULL, 0x0000001022277824ULL, 0x000fe400078e0227ULL,
0x000000010b0b7824ULL, 0x000fe200020e0629ULL, 0x0000000008257faeULL, 0x0003e8000b901c46ULL,
0x000000000a277faeULL, 0x0003e4000b901c46ULL, 0x000000081f037824ULL, 0x002fe200078e00ffULL,
0x0000000119047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001b0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000116048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660004048625ULL, 0x000fca00078e0005ULL, 0x0000000604248981ULL, 0x000522000c1e1900ULL,
0x0001a6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01a60c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101d127824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe2000001161dULL,
0x000000201f037824ULL, 0x000fc600078e00ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fc800078ec0ffULL,
0x0000000374037210ULL, 0x000fca0007ffe012ULL, 0x01a0000003057984ULL, 0x000e680000000800ULL,
0x01a2000003047984ULL, 0x0006a20000000800ULL, 0x000000020500720bULL, 0x002fe20003f1d000ULL,
0x000157827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x008fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0002ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001f1500720cULL, 0x000fe40003f05270ULL,
0x000000020500720bULL, 0x000fe20003f74000ULL, 0x000157527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x000fc400018e0100ULL, 0x000000801f078824ULL, 0x000fe200078e0212ULL,
0x0000000205237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174108824ULL, 0x000fca00078e0207ULL, 0x01a4002310008388ULL, 0x0003e20000000800ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000223027221ULL, 0x002fe20000010100ULL, 0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL,
0x0000000200027308ULL, 0x000e640000000800ULL, 0x0000000221217220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161dULL,
0x000156a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe40000410000ULL, 0x000000292d2d7220ULL, 0x080fe40000410000ULL,
0x0000002930307220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x000fc40000410000ULL,
0x0000002934347220ULL, 0x080fe40000410000ULL, 0x0000002935357220ULL, 0x080fe40000410000ULL,
0x0000002938387220ULL, 0x080fe40000410000ULL, 0x0000002939397220ULL, 0x080fe40000410000ULL,
0x000000293c3c7220ULL, 0x080fe40000410000ULL, 0x000000293d3d7220ULL, 0x000fc40000410000ULL,
0x0000002940407220ULL, 0x080fe40000410000ULL, 0x0000002941417220ULL, 0x080fe40000410000ULL,
0x0000002944447220ULL, 0x080fe40000410000ULL, 0x0000002945457220ULL, 0x080fe40000410000ULL,
0x0000002948487220ULL, 0x080fe40000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081d297811ULL, 0x000fe200078ff0ffULL, 0x000155927f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x00066400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe40000410000ULL,
0x000000292f2f7220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x080fe40000410000ULL,
0x0000002933337220ULL, 0x080fe40000410000ULL, 0x0000002936367220ULL, 0x080fe40000410000ULL,
0x0000002937377220ULL, 0x000fc40000410000ULL, 0x000000293a3a7220ULL, 0x080fe40000410000ULL,
0x000000293b3b7220ULL, 0x080fe40000410000ULL, 0x000000293e3e7220ULL, 0x080fe40000410000ULL,
0x000000293f3f7220ULL, 0x080fe40000410000ULL, 0x0000002942427220ULL, 0x080fe40000410000ULL,
0x0000002943437220ULL, 0x000fc40000410000ULL, 0x0000002946467220ULL, 0x080fe40000410000ULL,
0x0000002947477220ULL, 0x080fe40000410000ULL, 0x000000294a4a7220ULL, 0x080fe40000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101d297811ULL, 0x000fe200078ff0ffULL,
0x000154827f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe40000410000ULL, 0x000000294d4d7220ULL, 0x080fe40000410000ULL,
0x0000002950507220ULL, 0x080fe40000410000ULL, 0x0000002951517220ULL, 0x080fe40000410000ULL,
0x0000002954547220ULL, 0x080fe40000410000ULL, 0x0000002955557220ULL, 0x000fc40000410000ULL,
0x0000002958587220ULL, 0x080fe40000410000ULL, 0x0000002959597220ULL, 0x080fe40000410000ULL,
0x000000295c5c7220ULL, 0x080fe40000410000ULL, 0x000000295d5d7220ULL, 0x080fe40000410000ULL,
0x0000002960607220ULL, 0x080fe40000410000ULL, 0x0000002961617220ULL, 0x000fc40000410000ULL,
0x0000002964647220ULL, 0x080fe40000410000ULL, 0x0000002965657220ULL, 0x080fe40000410000ULL,
0x0000002968687220ULL, 0x080fe40000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181d297811ULL, 0x000fe200078ff0ffULL,
0x000153827f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe40000410000ULL, 0x000000294f4f7220ULL, 0x080fe40000410000ULL,
0x0000002952527220ULL, 0x080fe40000410000ULL, 0x0000002953537220ULL, 0x080fe40000410000ULL,
0x0000002956567220ULL, 0x080fe40000410000ULL, 0x0000002957577220ULL, 0x000fc40000410000ULL,
0x000000295a5a7220ULL, 0x080fe40000410000ULL, 0x000000295b5b7220ULL, 0x080fe40000410000ULL,
0x000000295e5e7220ULL, 0x080fe40000410000ULL, 0x000000295f5f7220ULL, 0x080fe40000410000ULL,
0x0000002962627220ULL, 0x080fe40000410000ULL, 0x0000002963637220ULL, 0x000fc40000410000ULL,
0x0000002966667220ULL, 0x080fe40000410000ULL, 0x0000002967677220ULL, 0x080fe40000410000ULL,
0x000000296a6a7220ULL, 0x080fe40000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000803ff7212ULL, 0x000fda00078030ffULL,
0x8000002305050221ULL, 0x000fe20000010000ULL, 0x00007610ff060816ULL, 0x000fc60000000006ULL,
0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL, 0x0000000500110308ULL, 0x000e640000000800ULL,
0x0000001104040220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002104217221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x008fca0000015200ULL,
0x01a6ac000a057984ULL, 0x000e620000000800ULL, 0x0001a6a80a107810ULL, 0x000fe40007ffe0ffULL,
0x8000000005ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac000a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991006007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe4000001161dULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00014f627f007947ULL, 0x000fea000b800000ULL, 0x00001f03000f7589ULL, 0x0002a400000e0000ULL,
0x0000000803297810ULL, 0x000fe20007ffe0ffULL, 0x00014fb27f007947ULL, 0x000fea000b800000ULL,
0x00000010030d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f29000e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d000d7589ULL, 0x0006a400000e0000ULL, 0x0000001803297810ULL, 0x008fe20007ffe0ffULL,
0x000150427f007947ULL, 0x000fea000b800000ULL, 0x00001f29000c7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021f257824ULL, 0x000fe200078e00ffULL,
0x000000081d027812ULL, 0x000fe200078ec0ffULL, 0x000000041f067824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000000425007812ULL, 0x00afc400078ec0ffULL, 0x00000007020b7812ULL, 0x000fe200078ef81dULL,
0x000004001f027824ULL, 0x000fe200078e00ffULL, 0x000000001d047211ULL, 0x000fe400078fe0ffULL,
0x000000100b097812ULL, 0x040fe200078efcffULL, 0x000000080b037824ULL, 0x040fe200078e00ffULL,
0x0000000406067812ULL, 0x000fe200078ec0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e0204ULL,
0xfffff000027d7812ULL, 0x000fe200078ec0ffULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x000000061d027211ULL, 0x000fe200078fe0ffULL, 0x0000000809077824ULL, 0x000fe200078e00ffULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x000010001f037824ULL, 0x000fe200078e00ffULL,
0x000120007d7d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b047824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fc400078ee208ULL, 0xffffe00003057812ULL, 0x000fe200078ec0ffULL,
0x000000010b037824ULL, 0x000fe400078e0202ULL, 0x000000100a6c7824ULL, 0x100fe200078e027dULL,
0x0001600005057810ULL, 0x000fe20007ffe0ffULL, 0x0000001008287824ULL, 0x000fe200078e027dULL,
0xfffffff804077812ULL, 0x000fc600078ee203ULL, 0x000000006c6c783bULL, 0x000e640000000200ULL,
0x0000001007787824ULL, 0x000fe400078e0205ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7232ULL, 0x086fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fe40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fc40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000080b717824ULL, 0x000fe200078e00ffULL, 0x0000000203067810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000000200007812ULL, 0x000fe200078efcffULL,
0x000008d000007945ULL, 0x000fe20003800000ULL, 0xfffffff871067812ULL, 0x000fc400078ee206ULL,
0x000000001d007211ULL, 0x000fc600078fe0ffULL, 0x0000001006707824ULL, 0x000fcc00078e0205ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x00000018ff037819ULL, 0x008fe40000011478ULL,
0x00000018ff047819ULL, 0x000fe40000011479ULL, 0x00000003007c7306ULL, 0x0007e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe4000001147aULL, 0x00000018ff7e7819ULL, 0x000fe4000001147bULL,
0x000088807b857816ULL, 0x000fc600000000ffULL, 0x0000000400817306ULL, 0x0003e20000200c00ULL,
0x0000888078037816ULL, 0x008fe200000000ffULL, 0x00000100708a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011470ULL, 0x0000010072907824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011471ULL, 0x00000018ff837819ULL, 0x000fe20000011472ULL,
0x0000007f008c7306ULL, 0x0005e20000200c00ULL, 0x0000010078047824ULL, 0x042fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x0000888070897816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fc40000011404ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00010000797f7824ULL, 0x004fe200078e00ffULL, 0x0000000500867306ULL, 0x0003e20000200c00ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00008880718b7816ULL, 0x000fe400000000ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x00008880728f7816ULL, 0x040fe200000000ffULL,
0x0000007e00877306ULL, 0x0005e20000200c00ULL, 0x0000888079057816ULL, 0x002fe200000000ffULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x0000888073917816ULL, 0x000fc400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x00000082008d7306ULL, 0x000fe20000200c00ULL, 0x00000100797e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc80000011472ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007800797306ULL, 0x0003f00000200c00ULL, 0x0000008300927306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008400937306ULL, 0x0003e20000200c00ULL, 0x000088807a837816ULL, 0x004fce00000000ffULL,
0x0000007f00827306ULL, 0x0005e20000200c00ULL, 0x000001007a847824ULL, 0x042fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x000100007b7f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc8000001147aULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000000400047306ULL, 0x000e700000200c00ULL, 0x0000000500057306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x0000541003047816ULL, 0x002fce0000000004ULL,
0x0000008500857306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x0000541005057816ULL, 0x004fce000000007eULL, 0x0000007a007b7306ULL, 0x0004e20000200c00ULL,
0x000000046c2c723cULL, 0x080f6e000000182cULL, 0x0000007f00887306ULL, 0x000ee20000200c00ULL,
0x00000100717a7824ULL, 0x004fe200078e00ffULL, 0x0000541085857816ULL, 0x002fe20000000078ULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000004284c723cULL, 0x000b64000000184cULL,
0x00000018ff7a7819ULL, 0x000fc4000001147aULL, 0x00000070007f7306ULL, 0x0002a20000200c00ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x000054107b867816ULL, 0x008fe20000000086ULL,
0x000000010b057824ULL, 0x120fe400078e0200ULL, 0x0000000109047824ULL, 0x000fe400078e0200ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000010073707824ULL, 0x042fe200078e00ffULL,
0x0000541088877816ULL, 0x000fe20000000087ULL, 0x0001000073737824ULL, 0x000fc400078e00ffULL,
0x0000000109007824ULL, 0x000fe200078e0202ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x000054107f8c7816ULL, 0x004fe2000000008cULL, 0x000000866c38723cULL, 0x080f6c0000001838ULL,
0x0000008900897306ULL, 0x000fe40000200c00ULL, 0x000000862858723cULL, 0x000f6c0000001858ULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x0000541083847816ULL, 0x002fce0000000084ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000000846c34723cULL, 0x080f6e0000001834ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x00005410898a7816ULL, 0x004fe2000000008aULL,
0x000000842854723cULL, 0x000f6c0000001854ULL, 0x00000071008e7306ULL, 0x0004f00000200c00ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000541082717816ULL, 0x004fc40000000081ULL,
0x000054108b8b7816ULL, 0x002fca000000007aULL, 0x0000009000907306ULL, 0x000e620000200c00ULL,
0x000054108e8d7816ULL, 0x008fe2000000008dULL, 0x0000008a6c3c723cULL, 0x040f6c000000183cULL,
0x0000009100917306ULL, 0x000fe40000200c00ULL, 0x0000008c6c40723cULL, 0x000f6c0000001840ULL,
0x00000070007e7306ULL, 0x0004e20000200c00ULL, 0x000054108f907816ULL, 0x002fe20000000090ULL,
0x0000008a285c723cULL, 0x040f6c000000185cULL, 0x0000007200037306ULL, 0x000e620000200c00ULL,
0x0000541079707816ULL, 0x004fe2000000007cULL, 0x0000008c2860723cULL, 0x000f6c0000001860ULL,
0x0000007300787306ULL, 0x000ea20000200c00ULL, 0x0000541091917816ULL, 0x008fe2000000007eULL,
0x000000706c30723cULL, 0x000f620000001830ULL, 0x0000541003927816ULL, 0x002fe20000000092ULL,
0x0000000809037824ULL, 0x000fcc00078e00ffULL, 0x000000906c44723cULL, 0x000f620000001844ULL,
0xfffffff803047812ULL, 0x000fe400078ee204ULL, 0x0000541078937816ULL, 0x004fe40000000093ULL,
0x0001600018037811ULL, 0x000fc600078e68ffULL, 0x000000702850723cULL, 0x000f700000001850ULL,
0x000000926c48723cULL, 0x000b6e0000001848ULL, 0x000000080b6c7824ULL, 0x020fe200078e00ffULL,
0x000000902864723cULL, 0x000f620000001864ULL, 0x00000008096d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c057812ULL, 0x000fe400078ee205ULL, 0xfffffff86d027812ULL, 0x000fe400078ee200ULL,
0x000000922868723cULL, 0x000b620000001868ULL, 0x00000010056c7824ULL, 0x100fe400078e027dULL,
0x00000010047d7824ULL, 0x000fe400078e027dULL, 0x0000001002787824ULL, 0x000fe400078e0203ULL,
0x000000006c6c783bULL, 0x000e680000000200ULL, 0x000000007d28783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fce0003800000ULL, 0x0000000f6c6c7232ULL, 0x082fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809717824ULL, 0x000fe200078e00ffULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff871007812ULL, 0x000fca00078ee200ULL, 0x0000001000707824ULL, 0x000fcc00078e0203ULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x00000018ff7c7819ULL, 0x004fe40000011478ULL,
0x00000018ff7d7819ULL, 0x000fe40000011479ULL, 0x0000007c007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff817819ULL, 0x000fe4000001147bULL, 0x00000018ff7f7819ULL, 0x000fca000001147aULL,
0x0000007d00847306ULL, 0x0003e20000200c00ULL, 0x00008880787c7816ULL, 0x004fe200000000ffULL,
0x00000100708c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011471ULL,
0x00000100718d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011470ULL,
0x0000010073977824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011472ULL,
0x0000008100897306ULL, 0x0005e20000200c00ULL, 0x00000100787d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00008880708b7816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000010079817824ULL, 0x004fe200078e00ffULL, 0x0000007f00877306ULL, 0x0003e20000200c00ULL,
0x0000888073957816ULL, 0x040fe200000000ffULL, 0x0001000073737824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000008300917306ULL, 0x0005e20000200c00ULL,
0x00008880797f7816ULL, 0x002fc400000000ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff977819ULL, 0x000fc60000011497ULL, 0x00000082008e7306ULL, 0x000fe20000200c00ULL,
0x0001000079837824ULL, 0x004fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007800797306ULL, 0x0003f00000200c00ULL, 0x0000008100827306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000088807b817816ULL, 0x044fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007d007d7306ULL, 0x000e700000200c00ULL, 0x0000007800887306ULL, 0x0005f00000200c00ULL,
0x0000008500967306ULL, 0x0007e20000200c00ULL, 0x0000888071787816ULL, 0x044fe200000000ffULL,
0x0001000071717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000008600987306ULL, 0x0005e20000200c00ULL, 0x000088807a857816ULL, 0x008fce00000000ffULL,
0x0000007b008a7306ULL, 0x0007e20000200c00ULL, 0x000001007a867824ULL, 0x044fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x0000007800907306ULL, 0x0005e20000200c00ULL, 0x00008880727b7816ULL, 0x008fe400000000ffULL,
0x00000018ff7a7819ULL, 0x000fca000001147aULL, 0x0000007b00937306ULL, 0x0007e20000200c00ULL,
0x0000010072787824ULL, 0x044fe400078e00ffULL, 0x0001000072727824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000070008f7306ULL, 0x0002a20000200c00ULL, 0x00000018ff7b7819ULL, 0x008fce0000011473ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054107c707816ULL, 0x002fce000000007dULL,
0x00000097007c7306ULL, 0x000fe20000200c00ULL, 0x000054108f8e7816ULL, 0x004fce000000008eULL,
0x0000008300837306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000eb00000200c00ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541081737816ULL, 0x002fce0000000088ULL, 0x0000008c008c7306ULL, 0x000e620000200c00ULL,
0x000054107a7a7816ULL, 0x004fce0000000087ULL, 0x0000008d008d7306ULL, 0x000eb00000200c00ULL,
0x0000007100927306ULL, 0x0006a20000200c00ULL, 0x000054108b8c7816ULL, 0x002fce000000008cULL,
0x0000007800947306ULL, 0x0002620000200c00ULL, 0x000054107f717816ULL, 0x008fe40000000082ULL,
0x00005410908d7816ULL, 0x004fca000000008dULL, 0x0000009500957306ULL, 0x000ea20000200c00ULL,
0x0000541079787816ULL, 0x002fe2000000007eULL, 0x00000070284c723cULL, 0x000f62000000184cULL,
0x0000541083797816ULL, 0x000fe40000000084ULL, 0x00005410928f7816ULL, 0x000fc60000000091ULL,
0x00000072007d7306ULL, 0x0002e20000200c00ULL, 0x0000541093947816ULL, 0x000fe20000000094ULL,
0x000000782850723cULL, 0x040f6c0000001850ULL, 0x0000007b00977306ULL, 0x0006e20000200c00ULL,
0x0000541085727816ULL, 0x002fe20000000086ULL, 0x0000008c285c723cULL, 0x000f62000000185cULL,
0x0000541095957816ULL, 0x004fc4000000007cULL, 0x000054107d967816ULL, 0x008fe40000000096ULL,
0x000054108a7b7816ULL, 0x000fc60000000089ULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x0000541097977816ULL, 0x000fce0000000098ULL, 0x0000007a2858723cULL, 0x040f700000001858ULL,
0x0000008e2860723cULL, 0x040f700000001860ULL, 0x000000942864723cULL, 0x040f700000001864ULL,
0x000000962868723cULL, 0x000f700000001868ULL, 0x000000706c2c723cULL, 0x040f70000000182cULL,
0x000000786c30723cULL, 0x040f700000001830ULL, 0x000000726c34723cULL, 0x040f700000001834ULL,
0x0000007a6c38723cULL, 0x040f700000001838ULL, 0x0000008c6c3c723cULL, 0x040f70000000183cULL,
0x0000008e6c40723cULL, 0x040f700000001840ULL, 0x000000946c44723cULL, 0x040f700000001844ULL,
0x000000966c48723cULL, 0x000b6e0000001848ULL, 0x0001a6c8186c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040013257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040013257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f257824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe025297812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x0000010014297824ULL, 0x000fca00078e0229ULL,
0x0000008029297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000117707824ULL, 0x000fe200078e0228ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000001025727812ULL, 0x000fe400078ec0ffULL, 0x000000291c257217ULL, 0x000fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe4000001161dULL, 0x0000640024717a11ULL, 0x000fe200078838ffULL,
0x0000000125257824ULL, 0x000fe200078e0a29ULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b287824ULL, 0x040fe200078e0272ULL, 0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002572257217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x040fe200078e021dULL,
0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828787824ULL, 0x000fe200078e00ffULL,
0x0000650024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a797824ULL, 0x000fe200078e0272ULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x00000001792a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7a7824ULL, 0x000fe200078e0272ULL, 0x00000012286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a6c7824ULL, 0x000fe200078e0270ULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x000000017b727824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x0000000172287824ULL, 0x000fe200078e0270ULL,
0x000000126c6c7212ULL, 0x000fe200078efcffULL, 0x00000001296f7824ULL, 0x000fe200028e0673ULL,
0x000000257b00720cULL, 0x000fe20003fa6070ULL, 0x0000000179707824ULL, 0x040fe400078e021dULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff879707812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x080fe20007fde0ffULL, 0x000000017a257824ULL, 0x100fe200078e021dULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000087a7a7824ULL, 0x000fe400078e00ffULL,
0x0000000172797824ULL, 0x040fe400078e021dULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001078257824ULL, 0x000fe200078e0203ULL,
0xfffffff87c787812ULL, 0x000fe200078ee279ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c46ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x000000002a717faeULL, 0x0003e8000d901c46ULL,
0x000000006c737faeULL, 0x0003e8000e101c46ULL, 0x0000000028797faeULL, 0x0003e2000e901c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001025287812ULL, 0x000fc800078ec0ffULL,
0x000000281d257211ULL, 0x000fc800078fe8ffULL, 0x00000004252b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000125297824ULL, 0x040fe200078e021dULL, 0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000825727824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x100fe400078e0270ULL,
0x000000012b2a7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000000012b257824ULL, 0x000fc400078e021dULL, 0x000000016d6f7824ULL, 0x100fe400078e021dULL,
0x00000001296c7824ULL, 0x040fe400078e0270ULL, 0x00000001292b7824ULL, 0x040fe400078e021dULL,
0x00000008297a7824ULL, 0x000fe400078e00ffULL, 0x000000086d7c7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0270ULL,
0xfffffff878707812ULL, 0x000fe200078ee225ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff87a787812ULL, 0x000fe400078ee22bULL, 0x0000640024257a11ULL, 0x000fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000650024717a11ULL, 0x000fc400000f3cffULL, 0x0000002825287210ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e0203ULL, 0x000000122a2a7212ULL, 0x080fe200078efcffULL,
0x000000107a797824ULL, 0x000fe200078e0203ULL, 0x000000126c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0671ULL, 0x000000126e6e7212ULL, 0x000fe400078efcffULL,
0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL, 0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL,
0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL, 0x000000012b2b7824ULL, 0x000fe400018e0671ULL,
0x0000001072257824ULL, 0x000fe400078e0203ULL, 0x000000016d6d7824ULL, 0x100fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000b901c46ULL, 0x0000001070717824ULL, 0x000fca00078e0203ULL,
0x000000002a717faeULL, 0x0003e8000b901c46ULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x000000006e797faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800226e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01a62c0022257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0022257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201f257824ULL, 0x000fca00078e00ffULL,
0xffffff8025257812ULL, 0x000fc800078ec0ffULL, 0x0000008012257810ULL, 0x000fca0007ffe025ULL,
0x0000000174257824ULL, 0x000fca00078e0225ULL, 0x01a00000256e7984ULL, 0x000e680000000800ULL,
0x01a2000025727984ULL, 0x0006a20000000800ULL, 0x000000236e00720bULL, 0x002fe20003f1d000ULL,
0x00012ed27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000115287810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x0000001f2800720cULL, 0x000fe20003f05270ULL, 0x00012ea27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000787806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x000000236e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7800720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000236e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff78ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028007a7308ULL, 0x000e640000000800ULL,
0x0000007a21217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x00012de27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0078ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x00012cd27f007947ULL, 0x000fea000b800000ULL, 0x00001f297a297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000078ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x00012bc27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000078ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x00012ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007825ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6f7424ULL, 0x000fe200078e00ffULL,
0x000000236e237209ULL, 0x000fd60007810000ULL, 0x800000236e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff6f0816ULL, 0x000fc6000000006fULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x004fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x000000081f257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106f257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000126a27f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000126f27f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x000127827f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x000004001f257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000010001f267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0001300025277810ULL, 0x000fe40007ffe0ffULL,
0x0001700026257810ULL, 0x000fc60007ffe0ffULL, 0x000000100a707824ULL, 0x100fe400078e0227ULL,
0x0000001008287824ULL, 0x000fe400078e0227ULL, 0x00000010077c7824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707232ULL, 0x084fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x088fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x082fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001006787824ULL, 0x000fe200078e0225ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007878783bULL, 0x008ee20000004200ULL,
0x00000018ff6e7819ULL, 0x010fe2000001147eULL, 0x000001007f897824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001147fULL, 0x0000006e00877306ULL, 0x0009e20000200c00ULL,
0x00000018ff827819ULL, 0x008fe20000011478ULL, 0x00000100798f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe4000001147dULL, 0x00000018ff257819ULL, 0x000fe4000001147cULL,
0x00000018ff847819ULL, 0x000fe20000011479ULL, 0x0000006f008a7306ULL, 0x0007e20000200c00ULL,
0x000088807d6e7816ULL, 0x010fe400000000ffULL, 0x00000018ff867819ULL, 0x000fc4000001147bULL,
0x00000018ff907819ULL, 0x000fe4000001148fULL, 0x00000018ff857819ULL, 0x000fe2000001147aULL,
0x00000082008e7306ULL, 0x000fe20000200c00ULL, 0x000001007d6f7824ULL, 0x008fe200078e00ffULL,
0x000088807f887816ULL, 0x000fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x000088807b957816ULL, 0x000fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00008880798d7816ULL, 0x040fe200000000ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x0000006e00827306ULL, 0x0007e20000200c00ULL, 0x00000018ff7d7819ULL, 0x000fc4000001147dULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002600837306ULL, 0x0009e20000200c00ULL,
0x000001007e6e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fc80000011479ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000002500817306ULL, 0x0007e20000200c00ULL,
0x000001007c267824ULL, 0x010fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000008400917306ULL, 0x000fe20000200c00ULL, 0x000088807c257816ULL, 0x048fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000008600977306ULL, 0x000ff00000200c00ULL, 0x0000007d00847306ULL, 0x0007f00000200c00ULL,
0x0000006e00867306ULL, 0x0009e20000200c00ULL, 0x00000100787d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x00008880786e7816ULL, 0x050fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000002600267306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x00000078008f7306ULL, 0x0007300000200c00ULL,
0x0000006e008b7306ULL, 0x0005e20000200c00ULL, 0x000001007b787824ULL, 0x008fc400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008500967306ULL, 0x0007e20000200c00ULL, 0x000088807a6e7816ULL, 0x004fe400000000ffULL,
0x000054108f8e7816ULL, 0x010fca000000008eULL, 0x0000007d008c7306ULL, 0x0005220000200c00ULL,
0x000088807e857816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006e00937306ULL, 0x0007e20000200c00ULL,
0x000001007a7d7824ULL, 0x044fe400078e00ffULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00005410256e7816ULL, 0x008fe40000000026ULL,
0x000054108b8c7816ULL, 0x010fca000000008cULL, 0x0000007800267306ULL, 0x0007f00000200c00ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x000054107c787816ULL, 0x008fe40000000081ULL,
0x00000018ff7c7819ULL, 0x000fc4000001147bULL, 0x00005410826f7816ULL, 0x004fc6000000006fULL,
0x0000008800887306ULL, 0x000fe80000200c00ULL, 0x0000006e702c723cULL, 0x080f68000000182cULL,
0x0000008900897306ULL, 0x000ea80000200c00ULL, 0x0000006e284c723cULL, 0x002f68000000184cULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x00005410887b7816ULL, 0x004fce0000000089ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107e7e7816ULL, 0x002fce0000000087ULL, 0x0000009000907306ULL, 0x000e620000200c00ULL,
0x000054107f7f7816ULL, 0x008fce000000008aULL, 0x0000007900927306ULL, 0x0004e20000200c00ULL,
0x0000007e7038723cULL, 0x080f6e0000001838ULL, 0x0000007d00947306ULL, 0x000f220000200c00ULL,
0x0000541084797816ULL, 0x004fe20000000083ULL, 0x0000007e2858723cULL, 0x000f620000001858ULL,
0x000054108d8d7816ULL, 0x002fca0000000090ULL, 0x0000009500957306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x008fe20000000091ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000007a00257306ULL, 0x0004e20000200c00ULL, 0x0000541093947816ULL, 0x010fe20000000094ULL,
0x0000008c703c723cULL, 0x040f6c000000183cULL, 0x0000007c007c7306ULL, 0x000f220000200c00ULL,
0x00005410857a7816ULL, 0x004fe20000000086ULL, 0x0000008e7040723cULL, 0x000f620000001840ULL,
0x0000541095957816ULL, 0x002fc40000000026ULL, 0x0000541025967816ULL, 0x008fca0000000096ULL,
0x0000007a7034723cULL, 0x000f620000001834ULL, 0x0000100003257810ULL, 0x000fe40007ffe0ffULL,
0x000054107c977816ULL, 0x010fc60000000097ULL, 0x0000001002267824ULL, 0x000fe400078e0225ULL,
0x000000947044723cULL, 0x040f700000001844ULL, 0x000000967048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0227ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004277824ULL, 0x000fc800078e0227ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x0000008c285c723cULL, 0x040f70000000185cULL,
0x0000008e2860723cULL, 0x040f700000001860ULL, 0x000000942864723cULL, 0x040f700000001864ULL,
0x000000962868723cULL, 0x000b640000001868ULL, 0x000000002728783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x082fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000267c783bULL, 0x000f220000004200ULL,
0x0000001000787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000018ff6f7819ULL, 0x010fe2000001147eULL, 0x000001007f897824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe4000001147fULL, 0x00000018ff277819ULL, 0x004fe2000001147cULL,
0x0000006f00877306ULL, 0x0005e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe2000001147dULL,
0x00000100788b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011478ULL,
0x00000100798f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011479ULL,
0x000001007a937824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147aULL,
0x00000082008a7306ULL, 0x0009e20000200c00ULL, 0x000088807d6f7816ULL, 0x004fc400000000ffULL,
0x00000018ff907819ULL, 0x000fe4000001148fULL, 0x00000018ff887819ULL, 0x000fe4000001147bULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000002700817306ULL, 0x0005e20000200c00ULL,
0x000001007d827824ULL, 0x010fe200078e00ffULL, 0x000088807b957816ULL, 0x000fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00008880798d7816ULL, 0x040fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x0000006e00837306ULL, 0x0009e20000200c00ULL, 0x000088807c277816ULL, 0x044fe400000000ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x00000084008e7306ULL, 0x000fe20000200c00ULL,
0x000001007c6e7824ULL, 0x050fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000100007c7c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000007d00847306ULL, 0x0005f00000200c00ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00008880787d7816ULL, 0x044fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000008200827306ULL, 0x000eb00000200c00ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x00000078008f7306ULL, 0x0008e20000200c00ULL, 0x000054106f6f7816ULL, 0x004fce0000000082ULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x000001007b787824ULL, 0x050fe400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000054108f8e7816ULL, 0x008fce000000008eULL,
0x0000008500917306ULL, 0x0007f00000200c00ULL, 0x0000008600967306ULL, 0x0009e20000200c00ULL,
0x000088807e857816ULL, 0x008fe400000000ffULL, 0x00005410276e7816ULL, 0x004fca000000006eULL,
0x0000008800977306ULL, 0x0005e20000200c00ULL, 0x000001007e867824ULL, 0x050fe200078e00ffULL,
0x0000006e702c723cULL, 0x002f62000000182cULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x0000008b008c7306ULL, 0x0003e20000200c00ULL,
0x000088807f887816ULL, 0x044fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006e284c723cULL, 0x000b66000000184cULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000007800827306ULL, 0x0005e20000200c00ULL,
0x000088807a8b7816ULL, 0x042fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x0001a6c8186e7811ULL, 0x020fc800078e18ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x000054107c787816ULL, 0x004fe40000000081ULL,
0x00000018ff7c7819ULL, 0x000fca000001147bULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x00005410887b7816ULL, 0x002fce0000000089ULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x000054107e7e7816ULL, 0x004fce0000000087ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107f7f7816ULL, 0x008fce000000008aULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054107d8c7816ULL, 0x002fe2000000008cULL, 0x0000007e7038723cULL, 0x080f6c0000001838ULL,
0x0000007900927306ULL, 0x0002e40000200c00ULL, 0x0000007e2858723cULL, 0x000f6c0000001858ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000541084797816ULL, 0x002fc40000000083ULL,
0x000054108d8d7816ULL, 0x004fca0000000090ULL, 0x0000009300947306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x008fe20000000091ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000009500957306ULL, 0x000ea40000200c00ULL, 0x0000008c703c723cULL, 0x040f6c000000183cULL,
0x0000007a00277306ULL, 0x0007220000200c00ULL, 0x000054108b947816ULL, 0x002fe20000000094ULL,
0x0000008e7040723cULL, 0x000f6c0000001840ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x00005410857a7816ULL, 0x008fe20000000086ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000541095957816ULL, 0x004fc40000000082ULL, 0x0000541027967816ULL, 0x010fe20000000096ULL,
0x000000021f277824ULL, 0x000fc800078e00ffULL, 0x0000007a7034723cULL, 0x000f620000001834ULL,
0x000054107c977816ULL, 0x002fce0000000097ULL, 0x000000947044723cULL, 0x040f700000001844ULL,
0x000000967048723cULL, 0x000f700000001848ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000008c285c723cULL, 0x040f70000000185cULL, 0x0000008e2860723cULL, 0x040f700000001860ULL,
0x000000942864723cULL, 0x040f700000001864ULL, 0x000000962868723cULL, 0x000b6e0000001868ULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400132b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28717210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000712a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400132b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010014277824ULL, 0x000fca00078e0280ULL, 0x000000c027297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000117727824ULL, 0x000fe200078e0228ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x000000101f2a7824ULL, 0x000fe200078e00ffULL,
0x000000291c287217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161dULL,
0x000000102a737812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a29ULL,
0x00000004706e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008707c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000170787824ULL, 0x100fe200078e0273ULL, 0x0000002873287217ULL, 0x000fe20007800000ULL,
0x000000016e7a7824ULL, 0x000fe200078e0273ULL, 0x0000640024797a11ULL, 0x000fe200078038ffULL,
0x0000000178297824ULL, 0x000fc400078e0272ULL, 0x0000000128717824ULL, 0x100fe200078e0a73ULL,
0x00006500247b7a11ULL, 0x000fe200000f3cffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000c70247810ULL, 0x000fe40007ffe0ffULL, 0x000000716e00720cULL, 0x080fe20003f66070ULL,
0x000000017a2a7824ULL, 0x000fe200078e0272ULL, 0x00000012286e7212ULL, 0x000fe200078efcffULL,
0x000000017c7d7824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL,
0x000000717c00720cULL, 0x000fe20003f06070ULL, 0x000000017d287824ULL, 0x000fe200078e0272ULL,
0x000000122a707212ULL, 0x000fe200078efcffULL, 0x00000001247c7824ULL, 0x000fe400078e0273ULL,
0x00000001296f7824ULL, 0x000fe200028e067bULL, 0x0000007970707210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000712400720cULL, 0x000fc60003fa6070ULL,
0x000000017c2a7824ULL, 0x000fe200078e0272ULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000012b717824ULL, 0x000fe400030e067bULL, 0x0000000178247824ULL, 0x000fe200078e021dULL,
0x0000007928287210ULL, 0x000fe20007fde0ffULL, 0x0000000878737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff873247812ULL, 0x000fe200078ee224ULL,
0x000000017a727824ULL, 0x100fe200078e021dULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x000000087a7f7824ULL, 0x000fe400078e00ffULL, 0x000000017d737824ULL, 0x140fe400078e021dULL,
0x000000087d787824ULL, 0x000fe200078e00ffULL, 0xfffffff87f727812ULL, 0x000fe200078ee272ULL,
0x000000017c7a7824ULL, 0x040fe400078e021dULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x0000000129297824ULL, 0x000fe200030e067bULL,
0x000000792a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001024737824ULL, 0x100fe200078e0225ULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001072797824ULL, 0x000fc400078e0225ULL,
0x000000012b2b7824ULL, 0x000fe200030e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e737faeULL, 0x0003e2000e101c46ULL, 0x00000010787b7824ULL, 0x100fe400078e0225ULL,
0x000000107a7d7824ULL, 0x000fe200078e0225ULL, 0x0000000070797faeULL, 0x0003e8000d901c46ULL,
0x00000000287b7faeULL, 0x0003e8000c101c46ULL, 0x000000002a7d7faeULL, 0x0003e2000e901c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000101f287824ULL, 0x000fe200078e00ffULL,
0x0000640024737a11ULL, 0x000fc800078038ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000650024797a11ULL, 0x000fe400000f3cffULL, 0x000000281d297211ULL, 0x000fc800078fe8ffULL,
0x00000004292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x140fe200078e021dULL,
0x0000000c29717810ULL, 0x040fe20007ffe0ffULL, 0x00000008296f7824ULL, 0x040fe400078e00ffULL,
0x0000000129287824ULL, 0x000fe400078e0272ULL, 0x000000082b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x000fe200078e0272ULL,
0x00000008296f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fc400078e021dULL,
0x0000000171707824ULL, 0x100fe400078e0272ULL, 0x000000016f6e7824ULL, 0x040fe200078e0272ULL,
0xfffffff87a727812ULL, 0x000fe200078ee229ULL, 0x000000016f2b7824ULL, 0x140fe400078e021dULL,
0x000000086f7c7824ULL, 0x000fe400078e00ffULL, 0x00000001716f7824ULL, 0x040fe400078e021dULL,
0x00000008717e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000007328287210ULL, 0x080fe40007f1e0ffULL,
0x000000122a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126e6e7212ULL, 0x080fe400078efcffULL, 0x000000732a2a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0679ULL, 0x0000001270707212ULL, 0x000fe200078efcffULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200018e0679ULL, 0x0000007370707210ULL, 0x000fe20007f9e0ffULL,
0x0000001078737824ULL, 0x000fc400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0679ULL,
0x0000000171717824ULL, 0x000fe200020e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028737faeULL, 0x0003e2000b901c46ULL, 0x0000001072797824ULL, 0x100fe400078e0225ULL,
0x000000107c7d7824ULL, 0x000fc600078e0225ULL, 0x000000002a797faeULL, 0x0003e8000b901c46ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c46ULL, 0x00000000707d7faeULL, 0x0003e4000b901c46ULL,
0x0000000219197810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001b1900720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x0000000119288824ULL, 0x000fe400078e0216ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000660028288625ULL, 0x000fca00078e0029ULL, 0x0000000628248981ULL, 0x000322000c1e1900ULL,
0x000000081f2a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01a64c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a64c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201f227824ULL, 0x000fca00078e00ffULL, 0xffffff8022297812ULL, 0x000fc800078ec0ffULL,
0x0000010012297810ULL, 0x000fca0007ffe029ULL, 0x0000000174297824ULL, 0x000fca00078e0229ULL,
0x01a0000029727984ULL, 0x000e680000000800ULL, 0x01a2000029787984ULL, 0x0004e20000000800ULL,
0x000000237200720bULL, 0x002fe20003f1d000ULL, 0x000108127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff707424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000215227810ULL, 0x000fe40007ffe0ffULL, 0x000000237200720bULL, 0x000fe40003f74000ULL,
0x0000001f2200720cULL, 0x000fe20003f05270ULL, 0x000107d27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x0000002372288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002372287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028007a7308ULL, 0x000e640000000800ULL,
0x0000007a21217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x000107127f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000106027f007947ULL, 0x000fea000b800000ULL, 0x00001f297a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000104f27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000103f27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x0000002372227209ULL, 0x000fd60007810000ULL, 0x8000002272720221ULL, 0x000fe20000010000ULL,
0x00007610ff700816ULL, 0x000fc60000000070ULL, 0x3fb8aa3b72720820ULL, 0x000fc80000410000ULL,
0x0000007200110308ULL, 0x000e640000000800ULL, 0x0000001178780220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002178217221ULL, 0x008fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991070237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000fff27f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x000100427f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x000100d27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x000004001f237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000010077c7824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0001400023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707232ULL, 0x08cfe40000000000ULL, 0x0000000f72727232ULL, 0x000fe40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x0000001006787824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000018ff087819ULL, 0x002fe2000001147dULL,
0x000100007f887824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001147eULL,
0x0000000800847306ULL, 0x0003e20000200c00ULL, 0x00000018ff067819ULL, 0x000fe4000001147cULL,
0x00000018ff827819ULL, 0x008fe20000011479ULL, 0x00000100788a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001147fULL, 0x000001007a927824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011478ULL, 0x0000006c00867306ULL, 0x0007e20000200c00ULL,
0x000001007c087824ULL, 0x002fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc4000001147aULL,
0x00000018ff857819ULL, 0x000fe4000001147bULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000006000a7306ULL, 0x0003e20000200c00ULL, 0x000088807d6c7816ULL, 0x008fe400000000ffULL,
0x000088807f877816ULL, 0x000fe400000000ffULL, 0x00008880798e7816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000008200907306ULL, 0x000fe20000200c00ULL,
0x000088807c067816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000006d00897306ULL, 0x000ff00000200c00ULL,
0x0000006c00827306ULL, 0x0003f00000200c00ULL, 0x00000008006d7306ULL, 0x0007e20000200c00ULL,
0x000001007e6c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000081008c7306ULL, 0x0003e20000200c00ULL, 0x000088807e087816ULL, 0x048fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008300947306ULL, 0x0007e20000200c00ULL, 0x000001007d817824ULL, 0x002fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000008500967306ULL, 0x000fe20000200c00ULL,
0x000100007d837824ULL, 0x008fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000007c007d7306ULL, 0x0003f00000200c00ULL,
0x0000006c00857306ULL, 0x0007e20000200c00ULL, 0x000001007f7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007e007f7306ULL, 0x0002a20000200c00ULL,
0x00008880786c7816ULL, 0x048fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00000100797e7824ULL, 0x042fe400078e00ffULL, 0x0001000079797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000006c008b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000054107f867816ULL, 0x004fca0000000086ULL,
0x00000078008d7306ULL, 0x0004e20000200c00ULL, 0x000088807a6c7816ULL, 0x042fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007e008f7306ULL, 0x0003e20000200c00ULL, 0x000088807b787816ULL, 0x004fce00000000ffULL,
0x0000006c00937306ULL, 0x0005e20000200c00ULL, 0x000001007b7e7824ULL, 0x002fe200078e00ffULL,
0x000054108d8c7816ULL, 0x008fe2000000008cULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00005410066c7816ULL, 0x004fe2000000006dULL, 0x000000ffff067224ULL, 0x000fe200078e0078ULL,
0x000054107d787816ULL, 0x000fe4000000000aULL, 0x00000018ff0a7819ULL, 0x000fe4000001147bULL,
0x00005410826d7816ULL, 0x000fe20000000081ULL, 0x0000007c007c7306ULL, 0x000e6c0000200c00ULL,
0x0000006c702c723cULL, 0x080f64000000182cULL, 0x0000008a008a7306ULL, 0x000eac0000200c00ULL,
0x0000006c284c723cULL, 0x000f64000000184cULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x00005410877b7816ULL, 0x002fe2000000007cULL, 0x00000010027c7824ULL, 0x000fcc00078e0203ULL,
0x0000007a00957306ULL, 0x000e620000200c00ULL, 0x000054108b8a7816ULL, 0x004fce000000008aULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000541093927816ULL, 0x008fce0000000092ULL,
0x0000000800087306ULL, 0x000ea20000200c00ULL, 0x0000541095947816ULL, 0x002fce0000000094ULL,
0x0000008800887306ULL, 0x000e700000200c00ULL, 0x0000008e008e7306ULL, 0x000ee20000200c00ULL,
0x00005410087a7816ULL, 0x004fce0000000085ULL, 0x0000007900917306ULL, 0x0004e20000200c00ULL,
0x0000541088877816ULL, 0x002fe20000000089ULL, 0x0000007a7034723cULL, 0x040f6c0000001834ULL,
0x0000000600067306ULL, 0x000fe20000200c00ULL, 0x0000541083797816ULL, 0x004fe20000000084ULL,
0x000000867038723cULL, 0x000f620000001838ULL, 0x000054108e8b7816ULL, 0x008fca000000008fULL,
0x0000007e007d7306ULL, 0x000e620000200c00ULL, 0x00005410918d7816ULL, 0x000fe20000000090ULL,
0x000000787030723cULL, 0x040f6c0000001830ULL, 0x0000000a00817306ULL, 0x000ea40000200c00ULL,
0x0000008a703c723cULL, 0x000f62000000183cULL, 0x0000541006937816ULL, 0x002fce000000007dULL,
0x0000008c7040723cULL, 0x000f620000001840ULL, 0x0000541081957816ULL, 0x004fce0000000096ULL,
0x000000927044723cULL, 0x040f700000001844ULL, 0x000000947048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0223ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004237824ULL, 0x000fc800078e0223ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x000000862858723cULL, 0x040f700000001858ULL,
0x0000008a285c723cULL, 0x040f70000000185cULL, 0x0000008c2860723cULL, 0x040f700000001860ULL,
0x000000922864723cULL, 0x040f700000001864ULL, 0x000000942828723cULL, 0x000b640000001868ULL,
0x000000002368783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f70707232ULL, 0x082fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x080fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d68687232ULL, 0x088fe40000000000ULL,
0x0000000d6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000c69697232ULL, 0x080fe40000000000ULL,
0x0000000c6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001000787824ULL, 0x000fe200078e0203ULL, 0x000000007c7c783bULL, 0x000e6a0000004200ULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x00000018ff0a7819ULL, 0x002fe2000001147fULL,
0x000001007e837824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fc4000001147dULL,
0x00000018ff087819ULL, 0x000fe2000001147eULL, 0x0000000a00867306ULL, 0x0003e20000200c00ULL,
0x00000018ff6c7819ULL, 0x004fe20000011479ULL, 0x0000010078897824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe2000001147cULL, 0x000001007a8e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001147aULL, 0x00000018ff237819ULL, 0x000fe20000011478ULL,
0x0000000200817306ULL, 0x0005e20000200c00ULL, 0x000001007d0a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fc4000001147bULL, 0x0000888078887816ULL, 0x040fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000000800847306ULL, 0x0003e20000200c00ULL, 0x000001007c027824ULL, 0x004fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff027819ULL, 0x000fc40000011402ULL, 0x0000006c008c7306ULL, 0x0005e20000200c00ULL,
0x000088807d087816ULL, 0x002fe400000000ffULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff8e7819ULL, 0x000fc6000001148eULL, 0x0000000000067306ULL, 0x0003e20000200c00ULL,
0x000100007d6c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000006d00927306ULL, 0x000fe20000200c00ULL, 0x000088807c007816ULL, 0x042fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000000800087306ULL, 0x000ff00000200c00ULL, 0x0000000a006d7306ULL, 0x0002b00000200c00ULL,
0x00000023008a7306ULL, 0x000fe20000200c00ULL, 0x000088807f0a7816ULL, 0x002fce00000000ffULL,
0x0000000200237306ULL, 0x000fe20000200c00ULL, 0x00005410086d7816ULL, 0x004fe2000000006dULL,
0x000001007b087824ULL, 0x000fca00078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000000000007306ULL, 0x000ff00000200c00ULL, 0x0000006c00027306ULL, 0x0003f00000200c00ULL,
0x0000008200947306ULL, 0x0005e20000200c00ULL, 0x000100007f6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000007c007d7306ULL, 0x0003e20000200c00ULL,
0x000088807e827816ULL, 0x044fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006c00877306ULL, 0x0005e20000200c00ULL,
0x000001007f7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000078008b7306ULL, 0x0002e20000200c00ULL, 0x000088807a6c7816ULL, 0x044fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007c00857306ULL, 0x0005e20000200c00ULL, 0x000088807b787816ULL, 0x042fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007e007f7306ULL, 0x0002620000200c00ULL, 0x00008880797c7816ULL, 0x004fe400000000ffULL,
0x000054108b8a7816ULL, 0x008fca000000008aULL, 0x0000006c00907306ULL, 0x0005e20000200c00ULL,
0x00000100797e7824ULL, 0x042fe400078e00ffULL, 0x0001000079797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00005410006c7816ULL, 0x004fe20000000023ULL,
0x000000ffff007224ULL, 0x000fe200078e0078ULL, 0x000054107d787816ULL, 0x000fe40000000006ULL,
0x000054107f847816ULL, 0x000fc60000000084ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x0000006c684c723cULL, 0x080b6e000000184cULL, 0x0000000a000a7306ULL, 0x000ea20000200c00ULL,
0x0000006c702c723cULL, 0x000b6e000000182cULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x002fce0000000083ULL, 0x0000008900897306ULL, 0x000e620000200c00ULL,
0x000054100a837816ULL, 0x004fe40000000085ULL, 0x0000541087857816ULL, 0x000fca0000000086ULL,
0x0000008e00917306ULL, 0x000ea20000200c00ULL, 0x000000826854723cULL, 0x040b6e0000001854ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541088887816ULL, 0x002fe20000000089ULL,
0x000000846858723cULL, 0x000b6c0000001858ULL, 0x0000007e008d7306ULL, 0x000e620000200c00ULL,
0x0000541090907816ULL, 0x004fe20000000091ULL, 0x000000827034723cULL, 0x040b6c0000001834ULL,
0x00000079008f7306ULL, 0x0004e40000200c00ULL, 0x000000847038723cULL, 0x000b6c0000001838ULL,
0x0000007a00937306ULL, 0x000ee20000200c00ULL, 0x0000541002797816ULL, 0x004fc40000000081ULL,
0x000054107c897816ULL, 0x002fca000000008dULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000054108f8b7816ULL, 0x008fe2000000008cULL, 0x000000786850723cULL, 0x040b6c0000001850ULL,
0x0000000800237306ULL, 0x000e620000200c00ULL, 0x0000541093927816ULL, 0x000fe20000000092ULL,
0x00000088685c723cULL, 0x040b6c000000185cULL, 0x0000007b007b7306ULL, 0x000ea40000200c00ULL,
0x0000008a6860723cULL, 0x000b620000001860ULL, 0x0000541000917816ULL, 0x002fe20000000023ULL,
0x000000021f007824ULL, 0x000fcc00078e00ffULL, 0x000000787030723cULL, 0x000b620000001830ULL,
0xfffffff800027812ULL, 0x000fe400078ec0ffULL, 0x000054107b937816ULL, 0x004fca0000000094ULL,
0x000000906864723cULL, 0x000b700000001864ULL, 0x00000088703c723cULL, 0x040b70000000183cULL,
0x0000008a7040723cULL, 0x040b700000001840ULL, 0x000000907044723cULL, 0x040b700000001844ULL,
0x000000927048723cULL, 0x080b700000001848ULL, 0x000000926868723cULL, 0x000b620000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000136c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc8000001142aULL,
0x0000002302027211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000202027819ULL, 0x000fc80000001223ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000114237810ULL, 0x000fc80007ffe0ffULL, 0x0000001a2300720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000214237810ULL, 0x000fe20007ffe0ffULL,
0x0000590024027a24ULL, 0x018fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x0000001a2300720cULL, 0x000fe20003f06070ULL, 0x0000008002067824ULL, 0x000fe200078e00ffULL,
0x0000006027007812ULL, 0x000fca00078ec0ffULL, 0x0000000117027824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271c007217ULL, 0x000fe20007800000ULL,
0x000000101f087824ULL, 0x000fe200078e00ffULL, 0x0000640006237a11ULL, 0x000fc600078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x00000010086d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff087819ULL, 0x000fe4000001161dULL, 0x000000006d007217ULL, 0x000fe40007800000ULL,
0x0000000408297810ULL, 0x040fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x100fe200078e026dULL,
0x0000650006277a11ULL, 0x000fe200000f3cffULL, 0x0000000100007824ULL, 0x100fe200078e0a6dULL,
0x0000000808067810ULL, 0x000fe20007ffe0ffULL, 0x000000010a287824ULL, 0x000fe200078e0202ULL,
0x0000000c08707810ULL, 0x000fe20007ffe0ffULL, 0x0000000129717824ULL, 0x040fe200078e026dULL,
0x000000002900720cULL, 0x080fe20003f86070ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000000800720cULL, 0x000fc40003fa6070ULL, 0x000000007000720cULL, 0x000fe20003f06070ULL,
0x00000001712a7824ULL, 0x000fe200078e0202ULL, 0x00000012286c7212ULL, 0x000fe200078efcffULL,
0x0000000106087824ULL, 0x040fe200078e026dULL, 0x000000000600720cULL, 0x000fe20003f66070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006c236c7210ULL, 0x000fc60007fde0ffULL,
0x0000000170727824ULL, 0x000fe200078e026dULL, 0x000000122a707212ULL, 0x000fe200078efcffULL,
0x0000000108287824ULL, 0x000fe400078e0202ULL, 0x0000000171007824ULL, 0x000fe400078e021dULL,
0x00000001296d7824ULL, 0x000fe200030e0627ULL, 0x0000002370707210ULL, 0x000fe20007fde0ffULL,
0x0000000871717824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff871007812ULL, 0x000fe200078ee200ULL, 0x000000010a067824ULL, 0x000fe200078e021dULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000080a737824ULL, 0x000fe400078e00ffULL,
0x00000001722a7824ULL, 0x000fe400078e0202ULL, 0x000000012b717824ULL, 0x000fe200030e0627ULL,
0xfffffff873067812ULL, 0x000fe200078ee206ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002328287210ULL, 0x000fc60007fde0ffULL, 0x00000001080a7824ULL, 0x100fe200078e021dULL,
0x000000122a027212ULL, 0x000fe200078efcffULL, 0x0000000808737824ULL, 0x000fe400078e00ffULL,
0x0000000172087824ULL, 0x040fe400078e021dULL, 0x0000000872797824ULL, 0x000fe200078e00ffULL,
0xfffffff8730a7812ULL, 0x000fe200078ee20aULL, 0x0000000129297824ULL, 0x000fe200030e0627ULL,
0x0000002302027210ULL, 0x000fe20007fde0ffULL, 0x0000001006237824ULL, 0x100fe200078e0203ULL,
0xfffffff879087812ULL, 0x000fe200078ee208ULL, 0x0000001000737824ULL, 0x000fc400078e0203ULL,
0x000000100a797824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c237faeULL, 0x0003e2000e901c46ULL, 0x00000010087b7824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fe200030e0627ULL, 0x0000000070737faeULL, 0x0003e8000e101c46ULL,
0x0000000028797faeULL, 0x0003e8000d901c46ULL, 0x00000000027b7faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000101f007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001d007211ULL, 0x000fc800078fe8ffULL,
0x00000004000a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100087824ULL, 0x040fe200078e021dULL,
0x0000000c00277810ULL, 0x040fe20007ffe0ffULL, 0x0000000800237824ULL, 0x040fe400078e00ffULL,
0x0000000100287824ULL, 0x100fe400078e0202ULL, 0x000000010a2a7824ULL, 0x000fe200078e0202ULL,
0xfffffff823087812ULL, 0x000fe200078ee208ULL, 0x0000000127707824ULL, 0x040fe200078e0202ULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000827727824ULL, 0x000fc400078e00ffULL,
0x000000010a007824ULL, 0x140fe400078e021dULL, 0x00000001236c7824ULL, 0x040fe400078e0202ULL,
0x0000000123027824ULL, 0x140fe400078e021dULL, 0x00000008236d7824ULL, 0x000fe400078e00ffULL,
0x0000000127237824ULL, 0x000fe400078e021dULL, 0x000000080a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee202ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fc400078ee223ULL, 0x0000640006237a11ULL, 0x000fe200078038ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b007812ULL, 0x000fe400078ee200ULL,
0x0000001228287212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000650006277a11ULL, 0x000fe400000f3cffULL, 0x0000002823287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000122a027212ULL, 0x000fc400078efcffULL,
0x000000126c2a7212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0627ULL,
0x00000012706c7212ULL, 0x000fe200078efcffULL, 0x0000001000737824ULL, 0x100fe200078e0203ULL,
0x0000000223027210ULL, 0x040fe20007f1e0ffULL, 0x000000100a797824ULL, 0x100fe200078e0203ULL,
0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL, 0x00000010727b7824ULL, 0x100fe200078e0203ULL,
0x0000006c236c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fc400000e0627ULL, 0x000000016d2b7824ULL, 0x100fe200018e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028237faeULL, 0x0003e2000b901c46ULL,
0x00000001716d7824ULL, 0x000fc600020e0627ULL, 0x0000000002737faeULL, 0x0003e8000b901c46ULL,
0x000000002a797faeULL, 0x0003e8000b901c46ULL, 0x000000006c7b7faeULL, 0x0003e4000b901c46ULL,
0x000000081f007824ULL, 0x000fe400078e00ffULL, 0x0000000215067824ULL, 0x000fc600078e0275ULL,
0x0000000800037812ULL, 0x002fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000001006067824ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0082a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01a66c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018015037811ULL, 0x000fc800078e38ffULL,
0x0000000374037210ULL, 0x000fca0007ffe012ULL, 0x01a0000003237984ULL, 0x000e680000000800ULL,
0x01a2000003067984ULL, 0x0084e20000000800ULL, 0x000000222300720bULL, 0x002fe20003f1d000ULL,
0x0000e1927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x004fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000315027810ULL, 0x000fe40007ffe0ffULL,
0x000000222300720bULL, 0x000fe40003f74000ULL, 0x0000001f0200720cULL, 0x000fe20003f05270ULL,
0x0000e1527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f278824ULL, 0x000fe200078e0212ULL, 0x0000002223027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174278824ULL, 0x000fca00078e0227ULL,
0x01a4000227008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x0000e0a27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x0000df927f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x0000de827f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x0000dd827f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff087424ULL, 0x000fd800078e00ffULL,
0x0000002302230221ULL, 0x000fe20000010100ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc40000010000ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0x000000081f037824ULL, 0x000fca00078e00ffULL, 0xfffffff0030a7812ULL, 0x000fca00078ec0ffULL,
0x01a6b4000a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002822067210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e23ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011428ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0628ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b4000a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991008037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff067819ULL, 0x000fe4000001161dULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000d9627f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000d9b27f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000da427f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff067819ULL, 0x002fe2000001161dULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000475067824ULL, 0x000fc400078e0206ULL,
0x0000001007707824ULL, 0x000fe400078e0225ULL, 0x000000010b037824ULL, 0x108fe400078e0206ULL,
0x0000000109087824ULL, 0x000fc600078e0206ULL, 0xfffffff80a067812ULL, 0x000fe200078ee203ULL,
0x000000041f0a7824ULL, 0x000fe200078e00ffULL, 0x0001500015037811ULL, 0x000fe400078e60ffULL,
0xfffffff823087812ULL, 0x000fe400078ee208ULL, 0x000000040a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0x000000020a0a7812ULL, 0x000fc400078efcffULL, 0x00000000066c783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x08cfe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fe40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a1d087211ULL, 0x002fe200078fe0ffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fe20003800000ULL,
0x000000010b0b7824ULL, 0x000fca00078e0208ULL, 0xfffffff806067812ULL, 0x000fca00078ee20bULL,
0x0000001006067824ULL, 0x000fca00078e0225ULL, 0x000000000678783bULL, 0x0006a20000004200ULL,
0x00000018ff077819ULL, 0x002fe20000011470ULL, 0x00010000737e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe40000011471ULL, 0x00000007000a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff107819ULL, 0x000fe40000011472ULL, 0x0000888070067816ULL, 0x008fe400000000ffULL,
0x00000018ff127819ULL, 0x000fc40000011473ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000000b00227306ULL, 0x0007e20000200c00ULL, 0x0000010070077824ULL, 0x042fe400078e00ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x004fe20000011479ULL,
0x0000010078827824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001147aULL,
0x00000100710b7824ULL, 0x008fe200078e00ffULL, 0x0000002700867306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe20000011478ULL, 0x0001000079857824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x000001007a887824ULL, 0x000fe200078e00ffULL,
0x00000018ff077819ULL, 0x000fc40000011407ULL, 0x0000888078817816ULL, 0x000fe200000000ffULL,
0x00000074008a7306ULL, 0x0005e20000200c00ULL, 0x0000888072277816ULL, 0x002fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147bULL,
0x000088807a877816ULL, 0x040fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x00000010007c7306ULL, 0x0003e20000200c00ULL,
0x0000010072747824ULL, 0x044fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fc40000011485ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000012007f7306ULL, 0x0005e20000200c00ULL,
0x0000888071107816ULL, 0x042fe200000000ffULL, 0x0001000071717824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000002300847306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x004fc4000001140bULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000001200237306ULL, 0x0003f00000200c00ULL, 0x00000070000b7306ULL, 0x0004e20000200c00ULL,
0x0000888073127816ULL, 0x002fce00000000ffULL, 0x0000000600067306ULL, 0x000fe20000200c00ULL,
0x0000010073707824ULL, 0x004fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007200737306ULL, 0x0002a20000200c00ULL, 0x000054100b0a7816ULL, 0x008fce000000000aULL,
0x0000000700077306ULL, 0x000ee20000200c00ULL, 0x0000010079727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x00005410737c7816ULL, 0x004fce000000007cULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x0000541006067816ULL, 0x008fce0000000007ULL, 0x0000007d008b7306ULL, 0x000fe20000200c00ULL,
0x0000541010077816ULL, 0x002fce0000000023ULL, 0x00000070007d7306ULL, 0x0003e20000200c00ULL,
0x00005410710b7816ULL, 0x004fe20000000022ULL, 0x000000066c2c723cULL, 0x040f6c000000182cULL,
0x0000007200837306ULL, 0x0005e20000200c00ULL, 0x0000888079707816ULL, 0x002fe200000000ffULL,
0x0000000a6c30723cULL, 0x080f6c0000001830ULL, 0x0000007800797306ULL, 0x0002e20000200c00ULL,
0x000088807b727816ULL, 0x044fe200000000ffULL, 0x0000000a2850723cULL, 0x040b6c0000001850ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x000001007b787824ULL, 0x042fe200078e00ffULL,
0x00000006284c723cULL, 0x000b62000000184cULL, 0x000100007b7b7824ULL, 0x000fc400078e00ffULL,
0x00000010050a7824ULL, 0x020fe200078e0203ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x0000541079847816ULL, 0x008fe40000000084ULL,
0x0000541012237816ULL, 0x004fca000000007dULL, 0x0000007400747306ULL, 0x000eb00000200c00ULL,
0x0000007e007e7306ULL, 0x000ef00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541027227816ULL, 0x004fce0000000074ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000054107e7d7816ULL, 0x008fe2000000007fULL, 0x000000222854723cULL, 0x040f6c0000001854ULL,
0x0000007000707306ULL, 0x000ee40000200c00ULL, 0x0000007c2858723cULL, 0x000f6c0000001858ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000541081827816ULL, 0x004fe20000000082ULL,
0x000000226c34723cULL, 0x040f6c0000001834ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000541070837816ULL, 0x008fe20000000083ULL, 0x0000007c6c38723cULL, 0x000f6c0000001838ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x0000541085857816ULL, 0x002fe20000000086ULL,
0x00000082285c723cULL, 0x040f6c000000185cULL, 0x0000007200727306ULL, 0x000fe40000200c00ULL,
0x000000842860723cULL, 0x000f6c0000001860ULL, 0x0000007800897306ULL, 0x000e620000200c00ULL,
0x0000541087887816ULL, 0x004fe20000000088ULL, 0x000000826c3c723cULL, 0x040f6c000000183cULL,
0x0000007a00717306ULL, 0x000ea40000200c00ULL, 0x000000846c40723cULL, 0x000f6c0000001840ULL,
0x0000007b00107306ULL, 0x000ee20000200c00ULL, 0x0000541072897816ULL, 0x002fc40000000089ULL,
0x00005410718a7816ULL, 0x004fca000000008aULL, 0x000000882864723cULL, 0x000f620000001864ULL,
0x00005410108b7816ULL, 0x008fce000000008bULL, 0x000000886c44723cULL, 0x000f700000001844ULL,
0x0000008a2868723cULL, 0x080b640000001868ULL, 0x000000000a28783bULL, 0x0202ac0000000200ULL,
0x0000008a6c48723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f28287232ULL, 0x084fe40000000000ULL,
0x0000000f2a2a7232ULL, 0x000fc40000000000ULL, 0x0000000e29297232ULL, 0x080fe40000000000ULL,
0x0000000e2b2b7232ULL, 0x000fe40000000000ULL, 0x0000000d04047232ULL, 0x080fe40000000000ULL,
0x0000000d06067232ULL, 0x000fe40000000000ULL, 0x0000000c05057232ULL, 0x080fe40000000000ULL,
0x0000000c07077232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809037824ULL, 0x040fe200078e00ffULL, 0x00000000266c783bULL, 0x020ee20000004200ULL,
0x0000000109087824ULL, 0x000fca00078e0208ULL, 0xfffffff803087812ULL, 0x000fca00078ee208ULL,
0x0000001008087824ULL, 0x000fcc00078e0225ULL, 0x000000000808783bULL, 0x002e620000004200ULL,
0x00000018ff107819ULL, 0x008fe4000001146dULL, 0x00000018ff037819ULL, 0x000fe4000001146cULL,
0x0000001000277306ULL, 0x0007e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe4000001146eULL,
0x00000018ff237819ULL, 0x000fe4000001146fULL, 0x000088806f737816ULL, 0x000fc600000000ffULL,
0x0000000300127306ULL, 0x0005e20000200c00ULL, 0x000001006c107824ULL, 0x008fe200078e00ffULL,
0x00000018ff707819ULL, 0x002fe2000001140aULL, 0x0000010008797824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc8000001140bULL, 0x0000002200727306ULL, 0x0003e20000200c00ULL,
0x000088806c037816ULL, 0x044fe200000000ffULL, 0x000100006c6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000001000a827824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011409ULL, 0x00000018ff257819ULL, 0x000fe20000011408ULL,
0x0000002300747306ULL, 0x0005e20000200c00ULL, 0x000088806d227816ULL, 0x002fe400000000ffULL,
0x0000888008787816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001146cULL, 0x000088800a817816ULL, 0x040fe200000000ffULL,
0x0000007000847306ULL, 0x0003e20000200c00ULL, 0x000001006d237824ULL, 0x044fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x000100006d6d7824ULL, 0x000fe200078e00ffULL,
0x00008880097c7816ULL, 0x000fe200000000ffULL, 0x000100000a0a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007100867306ULL, 0x0005e20000200c00ULL,
0x000088806e707816ULL, 0x002fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x000001006e717824ULL, 0x044fe400078e00ffULL,
0x000100006e6e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000001000107306ULL, 0x000fe20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fce000001146eULL,
0x00000026007e7306ULL, 0x000ff00000200c00ULL, 0x0000006d00267306ULL, 0x000ff00000200c00ULL,
0x0000006e006d7306ULL, 0x0002b00000200c00ULL, 0x00000025007a7306ULL, 0x0007e20000200c00ULL,
0x00000100096e7824ULL, 0x002fc400078e00ffULL, 0x0001000009097824ULL, 0x000fc600078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000008007b7306ULL, 0x0002620000200c00ULL,
0x00000018ff257819ULL, 0x008fe40000011423ULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x000054106d727816ULL, 0x004fc60000000072ULL, 0x0000006c00237306ULL, 0x0005e20000200c00ULL,
0x0000541003087816ULL, 0x002fe20000000010ULL, 0x000001000b107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006e007d7306ULL, 0x0003e20000200c00ULL,
0x000001006f6c7824ULL, 0x004fe200078e00ffULL, 0x000054107b7a7816ULL, 0x000fe2000000007aULL,
0x000100006f6f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x000088800b6e7816ULL, 0x042fe200000000ffULL, 0x000100000b0b7824ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe200078e006eULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000002500257306ULL, 0x000ff00000200c00ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000007100717306ULL, 0x000e700000200c00ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0000541070707816ULL, 0x002fce0000000071ULL,
0x0000007800787306ULL, 0x000ff00000200c00ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541073717816ULL, 0x004fce000000006cULL, 0x0000000a00857306ULL, 0x000ea20000200c00ULL,
0x000000702834723cULL, 0x080b6e0000001834ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000541078787816ULL, 0x002fe20000000079ULL, 0x000000700454723cULL, 0x000b6c0000001854ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x0000541085847816ULL, 0x004fce0000000084ULL,
0x00000009007f7306ULL, 0x0004620000200c00ULL, 0x000054106f737816ULL, 0x008fce0000000074ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541022097816ULL, 0x004fe20000000025ULL,
0x000000722838723cULL, 0x040b620000001838ULL, 0x0000541023227816ULL, 0x000fe40000000012ULL,
0x0000541026237816ULL, 0x000fe40000000027ULL, 0x000054107c797816ULL, 0x002fe2000000007dULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x000054107f7b7816ULL, 0x000fe2000000007eULL,
0x00000008282c723cULL, 0x040b6c000000182cULL, 0x0000000300037306ULL, 0x000fe40000200c00ULL,
0x000000222830723cULL, 0x040b6c0000001830ULL, 0x0000001000107306ULL, 0x000ea20000200c00ULL,
0x0000541081827816ULL, 0x002fe20000000082ULL, 0x00000078283c723cULL, 0x040b6c000000183cULL,
0x0000000b000b7306ULL, 0x000e640000200c00ULL, 0x0000007a2840723cULL, 0x000b620000001840ULL,
0x0000541003837816ULL, 0x004fce0000000010ULL, 0x00000008044c723cULL, 0x000b62000000184cULL,
0x000054100b857816ULL, 0x002fce0000000086ULL, 0x000000822844723cULL, 0x040b700000001844ULL,
0x000000842848723cULL, 0x000b700000001848ULL, 0x000000220450723cULL, 0x040b700000001850ULL,
0x000000720458723cULL, 0x040b700000001858ULL, 0x00000078045c723cULL, 0x040b70000000185cULL,
0x0000007a0460723cULL, 0x040b700000001860ULL, 0x000000820464723cULL, 0x040b700000001864ULL,
0x000000840468723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000013047f8cULL, 0x0202a2000c80043fULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0001a6a015067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x004fe200078e0005ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff50b000007947ULL, 0x000fea000383ffffULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000021007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000ccf000047802ULL, 0x000fc40000000f00ULL,
0x0000cb2000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000021ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000087919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000001808057811ULL, 0x042fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x004fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x002fc40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000003400347220ULL, 0x040fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x000fc40000410000ULL,
0x0000003900397220ULL, 0x040fe40000410000ULL, 0x0000003c003c7220ULL, 0x040fe40000410000ULL,
0x0000003d003d7220ULL, 0x040fe40000410000ULL, 0x0000004000407220ULL, 0x040fe40000410000ULL,
0x0000004100417220ULL, 0x040fe40000410000ULL, 0x0000004400447220ULL, 0x000fc40000410000ULL,
0x0000004500457220ULL, 0x040fe40000410000ULL, 0x0000004800487220ULL, 0x040fe40000410000ULL,
0x0000004900497220ULL, 0x000fe40000410000ULL, 0x0000004e054e7220ULL, 0x044fe40000410000ULL,
0x0000004f054f7220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x000fc40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000005605567220ULL, 0x040fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005a055a7220ULL, 0x040fe40000410000ULL,
0x0000005b055b7220ULL, 0x040fe40000410000ULL, 0x0000005e055e7220ULL, 0x000fc40000410000ULL,
0x0000005f055f7220ULL, 0x040fe40000410000ULL, 0x0000006205627220ULL, 0x040fe40000410000ULL,
0x0000006305637220ULL, 0x040fe40000410000ULL, 0x0000006605667220ULL, 0x040fe40000410000ULL,
0x0000006705677220ULL, 0x040fe40000410000ULL, 0x0000006a056a7220ULL, 0x000fc40000410000ULL,
0x0000006b056b7220ULL, 0x000fe40000410000ULL, 0x000000042e2e7220ULL, 0x088fe40000410000ULL,
0x000000042f2f7220ULL, 0x080fe40000410000ULL, 0x0000000432327220ULL, 0x080fe40000410000ULL,
0x0000000433337220ULL, 0x080fe40000410000ULL, 0x0000000436367220ULL, 0x000fc40000410000ULL,
0x0000000437377220ULL, 0x080fe40000410000ULL, 0x000000043a3a7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x080fe40000410000ULL, 0x000000043e3e7220ULL, 0x080fe40000410000ULL,
0x000000043f3f7220ULL, 0x080fe40000410000ULL, 0x0000000442427220ULL, 0x000fc40000410000ULL,
0x0000000443437220ULL, 0x080fe40000410000ULL, 0x0000000446467220ULL, 0x080fe40000410000ULL,
0x0000000447477220ULL, 0x080fe40000410000ULL, 0x000000044a4a7220ULL, 0x080fe40000410000ULL,
0x000000044b4b7220ULL, 0x000fe40000410000ULL, 0x000000024c4c7220ULL, 0x000fc40000410000ULL,
0x000000024d4d7220ULL, 0x080fe40000410000ULL, 0x0000000250507220ULL, 0x080fe40000410000ULL,
0x0000000251517220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x080fe40000410000ULL, 0x0000000258587220ULL, 0x000fc40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x000000025c5c7220ULL, 0x080fe40000410000ULL,
0x000000025d5d7220ULL, 0x080fe40000410000ULL, 0x0000000260607220ULL, 0x080fe40000410000ULL,
0x0000000261617220ULL, 0x080fe40000410000ULL, 0x0000000264647220ULL, 0x000fc40000410000ULL,
0x0000000265657220ULL, 0x080fe40000410000ULL, 0x0000000268687220ULL, 0x080fe40000410000ULL,
0x0000000269697220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000363736723eULL, 0x000fc400000000ffULL,
0x0000003a3b1b723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe40000000017ULL, 0x00005410361a7816ULL, 0x000fc4000000001bULL,
0x0000000803057811ULL, 0x042fe200078ff0ffULL, 0x0000000180807824ULL, 0x000fe200078e0203ULL,
0x0000000203007812ULL, 0x040fe400078ec0ffULL, 0x0000001803097811ULL, 0x000fe200078ff0ffULL,
0x0000000805077824ULL, 0x004fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe400078ff8ffULL,
0x0000001003057811ULL, 0x000fe200078ff0ffULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0xfffffff8070c7812ULL, 0x000fc400078ee202ULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x00000008050b7824ULL, 0x000fe200078e00ffULL, 0x0000000500047211ULL, 0x040fe400078ff8ffULL,
0x0000000700027211ULL, 0x040fe200078ff8ffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee204ULL, 0x000020001f047824ULL, 0x000fe200078e00ffULL,
0x0000000900057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe20007ffe0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fc400078ee205ULL, 0x0000200004057812ULL, 0x000fe400078ee2ffULL,
0xfffffff809067812ULL, 0x048fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x0000100018077824ULL, 0x100fe200078e0205ULL, 0x0000000402047810ULL, 0x000fe20007ffe0ffULL,
0x0000001080807824ULL, 0x000fe200078e0205ULL, 0x0000000602097810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e0207ULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL,
0x000000100c0e7824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x0000001010107824ULL, 0x100fe200078e0207ULL, 0x0000002c2d00723eULL, 0x000fe200000000ffULL,
0x0000001012127824ULL, 0x100fe200078e0207ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x0000001006067824ULL, 0x000fe200078e0207ULL, 0x00007632361b7816ULL, 0x000fe2000000001bULL,
0x0000001008087824ULL, 0x100fe200078e0207ULL, 0x0000541000147816ULL, 0x100fe20000000002ULL,
0x000000100a0c7824ULL, 0x000fe200078e0207ULL, 0x0000763200157816ULL, 0x000fe20000000002ULL,
0x0000000104077824ULL, 0x000fe200078e0209ULL, 0x000000343500723eULL, 0x000fe200000000ffULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x000fe200078e0208ULL, 0x0000001407007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x00000001090e7824ULL, 0x000fe200078e020eULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x0000000109107824ULL, 0x000fe200078e0210ULL,
0x000000464746723eULL, 0x000fe200000000ffULL, 0x0000000109127824ULL, 0x000fe200078e0212ULL,
0x0000004a4b23723eULL, 0x000fc400000000ffULL, 0x0000004c4d4c723eULL, 0x000fe400000000ffULL,
0x0000541000147816ULL, 0x142fe40000000002ULL, 0x0000763200157816ULL, 0x000fe40000000002ULL,
0x000000444507723eULL, 0x000fe400000000ffULL, 0x000000505126723eULL, 0x000fe200000000ffULL,
0x000000140a007388ULL, 0x0003e20000000a00ULL, 0x000000545554723eULL, 0x000fc400000000ffULL,
0x00000058592a723eULL, 0x000fe400000000ffULL, 0x0000541046227816ULL, 0x140fe40000000023ULL,
0x0000763246237816ULL, 0x000fe40000000023ULL, 0x0000763254097816ULL, 0x000fe4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe400000000ffULL, 0x0000541004147816ULL, 0x002fc40000000006ULL,
0x0000763204157816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000140b007388ULL, 0x000fe20000000a00ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x000000606160723eULL, 0x000fe200000000ffULL,
0x000000060c007388ULL, 0x0003e20000000a00ULL, 0x000000646564723eULL, 0x000fc400000000ffULL,
0x000000686932723eULL, 0x000fe200000000ffULL, 0x000000160e007388ULL, 0x0005e20000000a00ULL,
0x0000004e4f00723eULL, 0x000fe400000000ffULL, 0x00007632640f7816ULL, 0x000fe20000000032ULL,
0x0004001a0a007388ULL, 0x000fe20000000a00ULL, 0x000000525302723eULL, 0x000fe400000000ffULL,
0x000000565704723eULL, 0x000fe400000000ffULL, 0x000054103e067816ULL, 0x002fc40000000042ULL,
0x000076323e077816ULL, 0x000fe40000000042ULL, 0x00005410640e7816ULL, 0x004fe40000000032ULL,
0x000000ff1800720cULL, 0x000fe20003f05270ULL, 0x000400060b007388ULL, 0x0003e80000000a00ULL,
0x000400220c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x002fc40000000026ULL,
0x000076324c077816ULL, 0x000fca0000000026ULL, 0x0000000610007388ULL, 0x0003e80000000a00ULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe400000000ffULL,
0x000000666707723eULL, 0x000fe400000000ffULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080b007388ULL, 0x0003e80000000a00ULL,
0x0008000e0c007388ULL, 0x0005e20000000a00ULL, 0x0000006a6b08723eULL, 0x002fe400000000ffULL,
0x00005410000e7816ULL, 0x144fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x0000005e5f00723eULL, 0x000fc400000000ffULL, 0x000000626302723eULL, 0x000fe200000000ffULL,
0x0000000e12007388ULL, 0x0003e40000000a00ULL, 0x00005410040e7816ULL, 0x142fe40000000006ULL,
0x00007632040f7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000c000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x002fc40000000002ULL, 0x00007632000f7816ULL, 0x000fca0000000002ULL,
0x000c000e0b007388ULL, 0x000fe80000000a00ULL, 0x000c00060c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000080107984ULL, 0x000e680000000c00ULL,
0x0004000080247984ULL, 0x010ea80000000c00ULL, 0x00080000802c7984ULL, 0x000ee80000000c00ULL,
0x000c000080087984ULL, 0x000ee80000000c00ULL, 0x0010000080147984ULL, 0x000ee80000000c00ULL,
0x0014000080287984ULL, 0x000ee80000000c00ULL, 0x0018000080307984ULL, 0x000ee80000000c00ULL,
0x001c000080347984ULL, 0x000ee20000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x008fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff0b0b7230ULL, 0x000fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fc40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fe40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001080007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0004002480007388ULL, 0x000fe20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fe40000000000ULL, 0x000000370b0b7230ULL, 0x000fe40000000000ULL,
0x000000360a0a7230ULL, 0x000fe20000000000ULL, 0x0008002c80007388ULL, 0x000fe20000000c00ULL,
0x0000003509097230ULL, 0x000fc40000000000ULL, 0x0000003408087230ULL, 0x000fca0000000000ULL,
0x000c000880007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011603ULL,
0x000000760900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff137a12ULL, 0x000fe200078e33ffULL, 0x000000011e007824ULL, 0x000fe200078e0209ULL,
0x000000011f1f7812ULL, 0x000fc800078ec0ffULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL, 0x0000000109027824ULL, 0x000fca00078e0203ULL,
0x0000000800077305ULL, 0x000e62000021f000ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802027812ULL, 0x000fca00078ef803ULL, 0x0000001002027824ULL, 0x000fe400078e0205ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b07117227ULL, 0x000fe400078e0006ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000011047227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a04ULL,
0x0000000703027812ULL, 0x002fc600078ec0ffULL, 0x00005a0007067a24ULL, 0x000fca00078e0200ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000104041810ULL, 0x000fc80007ffe0ffULL,
0x0000000413077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077047210ULL, 0x000fe40007f3e0ffULL, 0x0000002003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0004067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0004077a11ULL, 0x000fe400008f4407ULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277077210ULL, 0x000fe40007f3e0ffULL,
0x0000004003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077077210ULL, 0x000fe40007f3e0ffULL, 0x0000006003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277077210ULL, 0x000fe40007f3e0ffULL,
0x0000008003027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011602ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x00000001020f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0200ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fe400078e0200ULL,
0x000000081f0d7824ULL, 0x000fe400078e0202ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077077210ULL, 0x000fe40007f3e0ffULL, 0x000000a003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e027824ULL, 0x100fe200078e020fULL, 0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x00000003ff0f7819ULL, 0x000fe4000001160cULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x000000081f0d7824ULL, 0x000fe400078e0200ULL,
0x00005a0007027a24ULL, 0x000fca00078e0202ULL, 0x0000000277027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fc800078240ffULL,
0x00005f0002077a11ULL, 0x000fe400008f4407ULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e007824ULL, 0x100fe400078e020fULL,
0x000000010c0f7824ULL, 0x000fe400078e020fULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f027812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d007a24ULL, 0x000fc800078e0200ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077067210ULL, 0x000fe40007f3e0ffULL,
0x000000e003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0006027a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x00005f0006037a11ULL, 0x000fe200008f4407ULL, 0x000000081f077824ULL, 0x000fe200078e020cULL,
0x000000760d00720cULL, 0x000fe20003f26070ULL, 0x000000011e1e7824ULL, 0x000fe400078e020dULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001e11037227ULL, 0x002fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x00005a0007027a24ULL, 0x000fc600078e021eULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0xfffffff80d027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001002057824ULL, 0x000fca00078e0205ULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000313037207ULL, 0x000fe20004000000ULL,
0x000000081f057824ULL, 0x002fc800078e0200ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0220ULL, 0x00005a00071e7a24ULL, 0x000fc800078e021eULL,
0x00005a00031e7a24ULL, 0x000fca00078e021eULL, 0x0000001e771e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e001e027a11ULL, 0x000fc800078040ffULL,
0x00005f001e037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff5c7819ULL, 0x000fe2000001161fULL, 0xffffffffff0d7424ULL, 0x000fc600078e00ffULL,
0x0000001b5c00720cULL, 0x000fda0003f06070ULL, 0x0000000204078824ULL, 0x000fc800078e00ffULL,
0x00006a00070a8a24ULL, 0x000fc800078e025cULL, 0x000066000a0a8625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff687624ULL, 0x000fe200078e00ffULL,
0x000000060a0d8981ULL, 0x000ea2000c1e1900ULL, 0x00006f00ff697624ULL, 0x000fc600078e00ffULL,
0x01a60000ff067f8cULL, 0x000ee8000c80043fULL, 0x0000000668687981ULL, 0x000322000c1e9900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000008020007824ULL, 0x000fe400078e00ffULL,
0x000000401f097824ULL, 0x000fe400078e00ffULL, 0x0000008018187824ULL, 0x000fc600078e00ffULL,
0x0000004000087812ULL, 0x002fe200078ef809ULL, 0x0000000d18407224ULL, 0x004fc800078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff337819ULL, 0x008fe4000001161dULL,
0x0000640040357a11ULL, 0x000fe400078038ffULL, 0x0000000833137810ULL, 0x040fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0233ULL, 0x0000000433117810ULL, 0x040fe40007ffe0ffULL,
0x0000000c33177810ULL, 0x000fe20007ffe0ffULL, 0x00000001130c7824ULL, 0x100fe200078e021dULL,
0x00000010330f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008130d7824ULL, 0x000fe200078e00ffULL,
0x0000650040377a11ULL, 0x000fe200000f3cffULL, 0x00000001110b7824ULL, 0x100fe200078e021dULL,
0x0000001433237810ULL, 0x000fe20007ffe0ffULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0xfffffff80d2a7812ULL, 0x000fe200078ee20cULL, 0x00000001170d7824ULL, 0x040fe200078e021dULL,
0x000000091c0c7217ULL, 0x000fe20007800000ULL, 0x00000008172c7824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001c332b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee20dULL,
0x000000010c267824ULL, 0x000fe200078e0a09ULL, 0x000000700a147812ULL, 0x000fe200078ef803ULL,
0x00000001080c7824ULL, 0x000fe200078e0213ULL, 0x000020001f277811ULL, 0x000fe200078e70ffULL,
0x000000010f0a7824ULL, 0x000fe200078e021dULL, 0x0000001435147210ULL, 0x000fe20007f1e0ffULL,
0x000000080f157824ULL, 0x000fe200078e00ffULL, 0x000000261100720cULL, 0x080fe20003fa6070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000261300720cULL, 0x000fc40003f26070ULL,
0xfffffff8152e7812ULL, 0x000fe200078ee20aULL, 0x00000001080a7824ULL, 0x000fe200078e0211ULL,
0x000000700c207812ULL, 0x000fe200078ef803ULL, 0x000000010b157824ULL, 0x000fe200000e0637ULL,
0x000000260f00720cULL, 0x080fe20003f06070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003520207210ULL, 0x080fe40007f9e0ffULL, 0x000000261700720cULL, 0x000fe20003f46070ULL,
0x00000001080e7824ULL, 0x000fe200078e0217ULL, 0x000000700a167812ULL, 0x000fe200078ef803ULL,
0x0000000108107824ULL, 0x040fe200078e020fULL, 0x00000020332d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108127824ULL, 0x000fe200078e0223ULL, 0x0000003516167210ULL, 0x000fe20007f7e0ffULL,
0x000000010d217824ULL, 0x000fe200020e0637ULL, 0x00000018330d7810ULL, 0x040fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000024332f7810ULL, 0x000fc60007ffe0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fc600078ef803ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fc600078ef803ULL,
0x00000001080a7824ULL, 0x000fe200078e020dULL, 0x0000007012127812ULL, 0x000fe200078ef803ULL,
0x000000010b177824ULL, 0x000fe200018e0637ULL, 0x000000350e0e7210ULL, 0x080fe20007f7e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003510107210ULL, 0x080fe40007f9e0ffULL,
0x0000003512127210ULL, 0x080fe20007fde0ffULL, 0x00000001330c7824ULL, 0x000fe200078e021dULL,
0x000000700a227812ULL, 0x000fe200078ef803ULL, 0x000000010f0f7824ULL, 0x000fe200018e0637ULL,
0x000000262300720cULL, 0x0c0fe20003f66070ULL, 0x00000001230a7824ULL, 0x000fe200078e021dULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000111117824ULL, 0x100fe200020e0637ULL,
0x000000263300720cULL, 0x000fe20003f86070ULL, 0x0000000113137824ULL, 0x000fe200030e0637ULL,
0x0000003522227210ULL, 0x000fe20007fde0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x0ffffff80c247812ULL, 0x000fe200078ef81dULL, 0x00000001080c7824ULL, 0x000fc400078e022bULL,
0x000000080d257824ULL, 0x000fe200078e00ffULL, 0xfffffff823307812ULL, 0x000fe200078ee20aULL,
0x000000010b237824ULL, 0x000fe400030e0637ULL, 0x000000800c0a7825ULL, 0x000fc800078e00ffULL,
0x0000001024297824ULL, 0x000fe200078e0227ULL, 0x000000700a247812ULL, 0x000fe200078ef803ULL,
0x00000001080c7824ULL, 0x000fe400078e022dULL, 0x000000010d0a7824ULL, 0x040fe200078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014297faeULL, 0x0003e2000e101c46ULL,
0x000000260d00720cULL, 0x000fe20003f86070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000003524247210ULL, 0x000fe40007fde0ffULL, 0xfffffff825327812ULL, 0x000fe200078ee20aULL,
0x0000000108317824ULL, 0x000fe200078e022fULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x000000010b257824ULL, 0x000fc400030e0637ULL, 0x00000080310a7825ULL, 0x000fe200078e00ffULL,
0x000000350c0c7210ULL, 0x080fe40007fde0ffULL, 0x0000002833317810ULL, 0x000fe20007ffe0ffULL,
0x0000001028297824ULL, 0x002fe200078e0227ULL, 0x000000700a147812ULL, 0x000fe200078ef803ULL,
0x000000012b157824ULL, 0x040fe400078e021dULL, 0x000000082b287824ULL, 0x000fe200078e00ffULL,
0x0000000016297faeULL, 0x0003e2000e901c46ULL, 0x000000010d0d7824ULL, 0x000fe200030e0637ULL,
0x0000003514147210ULL, 0x000fe20007fde0ffULL, 0x00000001080a7824ULL, 0x000fe200078e0231ULL,
0x000000262b00720cULL, 0x000fe20003fa6070ULL, 0x000000102a2b7824ULL, 0x000fe200078e0227ULL,
0xfffffff828287812ULL, 0x000fe200078ee215ULL, 0x000000010b157824ULL, 0x000fc400030e0637ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000000202b7faeULL, 0x0005e2000c901c46ULL,
0x000000262d00720cULL, 0x080fe40003f26070ULL, 0x000000102c297824ULL, 0x002fe200078e0227ULL,
0x000000700a167812ULL, 0x000fe200078ef803ULL, 0x000000012f2a7824ULL, 0x100fe400078e021dULL,
0x000000012d177824ULL, 0x000fe200078e021dULL, 0x000000000e297faeULL, 0x0003e2000d101c46ULL,
0x000000262f00720cULL, 0x000fe20003f46070ULL, 0x000000082d2c7824ULL, 0x000fe200078e00ffULL,
0x0000003516167210ULL, 0x000fe20007fde0ffULL, 0x000000082f2f7824ULL, 0x000fc400078e00ffULL,
0x000000102e217824ULL, 0x004fe200078e0227ULL, 0xfffffff82c0a7812ULL, 0x000fe200078ee217ULL,
0x000000010b177824ULL, 0x000fe200030e0637ULL, 0xfffffff82f2a7812ULL, 0x000fe200078ee22aULL,
0x00000010300b7824ULL, 0x100fe200078e0227ULL, 0x0000002c332f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a2b7824ULL, 0x100fe200078e0227ULL, 0x0000000010217faeULL, 0x0005e2000c101c46ULL,
0x00000010320f7824ULL, 0x002fe400078e0227ULL, 0x00000001080a7824ULL, 0x000fe200078e022fULL,
0x00000000120b7faeULL, 0x0003e2000d901c46ULL, 0x0000001028297824ULL, 0x000fc400078e0227ULL,
0x000000102a2d7824ULL, 0x000fe200078e0227ULL, 0x00000000220f7faeULL, 0x0007e2000e101c46ULL,
0x000000262f00720cULL, 0x080fe40003f86070ULL, 0x0000003033217810ULL, 0x004fe20007ffe0ffULL,
0x0000000024297faeULL, 0x0005e2000e901c46ULL, 0x0000000131117824ULL, 0x140fe200078e021dULL,
0x000000263100720cULL, 0x080fe20003fa6070ULL, 0x000000800a0a7825ULL, 0x002fe200078e00ffULL,
0x0000003433137810ULL, 0x000fe20007ffe0ffULL, 0x000000000c2b7faeULL, 0x0003e2000c901c46ULL,
0x000000262100720cULL, 0x080fe20003f66070ULL, 0x000000012f127824ULL, 0x000fe200078e021dULL,
0x000000700a0e7812ULL, 0x000fe200078ef803ULL, 0x00000001080a7824ULL, 0x000fe200078e0221ULL,
0x0000003833237810ULL, 0x008fe20007ffe0ffULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x000000350e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000000142d7faeULL, 0x0007e2000d101c46ULL,
0x0000003c33337810ULL, 0x000fe20007ffe0ffULL, 0x0000000823247824ULL, 0x004fe200078e00ffULL,
0xfffffff82f207812ULL, 0x000fe200078ee212ULL, 0x000000010b0f7824ULL, 0x000fe200030e0637ULL,
0x000000261300720cULL, 0x080fe20003f46070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000262300720cULL, 0x000fc40003f26070ULL, 0x000000263300720cULL, 0x000fe20003f06070ULL,
0x00000001080c7824ULL, 0x002fe200078e0213ULL, 0x000000700a107812ULL, 0x000fe200078ef803ULL,
0x00000001210a7824ULL, 0x040fe400078e021dULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000003510107210ULL, 0x000fe20007fde0ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff821227812ULL, 0x000fe200078ee20aULL, 0x0000000831147824ULL, 0x008fe200078e00ffULL,
0x000000700c127812ULL, 0x000fe200078ef803ULL, 0x00000001080a7824ULL, 0x000fe400078e0223ULL,
0x00000001130c7824ULL, 0x000fe200078e021dULL, 0xfffffff814147812ULL, 0x000fe200078ee211ULL,
0x000000010b117824ULL, 0x000fe200030e0637ULL, 0x0000003512127210ULL, 0x000fe20007fde0ffULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000000108217824ULL, 0x000fe200078e0233ULL, 0xfffffff813087812ULL, 0x000fe200078ee20cULL,
0x000000010d137824ULL, 0x000fe200030e0637ULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x00000080210c7825ULL, 0x000fc600078e00ffULL, 0x000000350a0a7210ULL, 0x080fe20007fde0ffULL,
0x0000000123157824ULL, 0x000fe200078e021dULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x00000001331d7824ULL, 0x040fe400078e021dULL, 0x0000000833267824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee215ULL, 0x000000010b0b7824ULL, 0x000fe200030e0637ULL,
0x00000035030c7210ULL, 0x000fe20007fde0ffULL, 0x0000001014037824ULL, 0x000fe200078e0227ULL,
0xfffffff826267812ULL, 0x000fe200078ee21dULL, 0x0000001020157824ULL, 0x000fc400078e0227ULL,
0x00000010221d7824ULL, 0x100fe200078e0227ULL, 0x0000000016037faeULL, 0x0003e2000e901c46ULL,
0x0000001008217824ULL, 0x100fe400078e0227ULL, 0x0000001024237824ULL, 0x100fe200078e0227ULL,
0x000000000e157faeULL, 0x0003e2000e101c46ULL, 0x0000001026277824ULL, 0x000fe400078e0227ULL,
0x000000010d0d7824ULL, 0x000fe200030e0637ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x0000000012217faeULL, 0x0003e8000d101c46ULL, 0x000000000a237faeULL, 0x0003e8000c901c46ULL,
0x000000000c277faeULL, 0x0003e2000c101c46ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x000000041d0d7811ULL, 0x048fe400078fe8ffULL, 0x000000101d137811ULL, 0x000fc400078fe8ffULL,
0x0000000c1d117811ULL, 0x000fe200078fe8ffULL, 0x000000010d0a7824ULL, 0x100fe200078e021dULL,
0x000000081d0f7811ULL, 0x000fe200078fe8ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0x000000201d237811ULL, 0x000fe200078fe8ffULL, 0x0000000113147824ULL, 0x100fe200078e021dULL,
0x0000002c1d2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000813217824ULL, 0x000fe200078e00ffULL,
0xfffffff8150e7812ULL, 0x000fe200078ee20aULL, 0x00000001110c7824ULL, 0x100fe200078e021dULL,
0x000000141d157811ULL, 0x000fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0xfffffff821147812ULL, 0x000fe200078ee214ULL, 0x000000010f0b7824ULL, 0x100fe200078e021dULL,
0x0000001c1d217811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff817127812ULL, 0x000fe200078ee20cULL, 0x00000001150a7824ULL, 0x000fe200078e021dULL,
0x000000181d177811ULL, 0x000fe200078fe8ffULL, 0x0000000815257824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x00000001210c7824ULL, 0x100fe200078e021dULL,
0x000000301d2d7811ULL, 0x000fe200078fe8ffULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0xfffffff825167812ULL, 0x000fe200078ee20aULL, 0x00000001170b7824ULL, 0x100fe200078e021dULL,
0x000000241d257811ULL, 0x000fe200078fe8ffULL, 0x0000000817207824ULL, 0x000fe200078e00ffULL,
0xfffffff827227812ULL, 0x000fe200078ee20cULL, 0x0000000123247824ULL, 0x100fe200078e021dULL,
0x000000281d277811ULL, 0x000fe200078fe8ffULL, 0x00000001250a7824ULL, 0x040fe200078e021dULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x00000008252f7824ULL, 0x000fe200078e00ffULL,
0x000000381d307811ULL, 0x000fe200078fe8ffULL, 0x00000001270b7824ULL, 0x100fe200078e021dULL,
0x000020001f4f7811ULL, 0x000fe200078e70ffULL, 0x0000000827287824ULL, 0x000fe200078e00ffULL,
0xfffffff82f267812ULL, 0x000fe200078ee20aULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0x000000341d2f7811ULL, 0x000fe200078fe8ffULL, 0x000000012b0c7824ULL, 0x040fe200078e021dULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x000000082b317824ULL, 0x000fe200078e00ffULL,
0xfffffff829247812ULL, 0x000fe200078ee224ULL, 0x000000012d297824ULL, 0x000fe200078e021dULL,
0x0000001d1d0b7211ULL, 0x000fe200078fe8ffULL, 0x000000082d2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8312c7812ULL, 0x000fe200078ee20cULL, 0x000000082f427824ULL, 0x000fe200078e00ffULL,
0x0000003c1d317811ULL, 0x000fe200078fe8ffULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x000000012f0b7824ULL, 0x000fe200078e021dULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee229ULL, 0x0000000108297824ULL, 0x000fe200078e0221ULL,
0x000000081d0a7211ULL, 0x000fe200078fe8ffULL, 0x0000000130217824ULL, 0x100fe200078e021dULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef81dULL, 0x00000001080f7824ULL, 0x000fe200078e020fULL,
0x0000640040517a11ULL, 0x000fe200078038ffULL, 0x0000000108117824ULL, 0x000fc400078e0211ULL,
0x0000000108137824ULL, 0x000fe200078e0213ULL, 0x0000650040537a11ULL, 0x000fe200000f3cffULL,
0x0000000108157824ULL, 0x040fe400078e0215ULL, 0x0000000108177824ULL, 0x040fe400078e0217ULL,
0x00000001082a7824ULL, 0x040fe400078e0223ULL, 0x0000000108327824ULL, 0x040fe400078e0225ULL,
0x0000000108347824ULL, 0x000fc400078e0227ULL, 0x0000000108367824ULL, 0x040fe400078e022bULL,
0x0000000108387824ULL, 0x040fe400078e022dULL, 0x00000001083a7824ULL, 0x040fe400078e022fULL,
0x00000001083c7824ULL, 0x040fe400078e0230ULL, 0x00000001083e7824ULL, 0x000fe200078e0231ULL,
0xfffffff842087812ULL, 0x000fe200078ee20bULL, 0x00000001311d7824ULL, 0x000fc400078e021dULL,
0x0000000831447824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff844237812ULL, 0x000fe200078ee21dULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x000000100c1d7824ULL, 0x100fe400078e024fULL, 0x00000010203d7824ULL, 0x000fe200078e024fULL,
0x000000700a207812ULL, 0x000fe200078ef803ULL, 0x000000100e337824ULL, 0x000fe200078e024fULL,
0xfffffff830217812ULL, 0x000fe200078ee221ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000002051207210ULL, 0x000fc60007f1e0ffULL, 0x0000001010357824ULL, 0x000fe400078e024fULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x00000010223f7824ULL, 0x000fe200078e024fULL, 0x000000700c227812ULL, 0x000fe200078ef803ULL,
0x0000001024417824ULL, 0x000fe200078e024fULL, 0x000000700e247812ULL, 0x000fe200078ef803ULL,
0x0000001026437824ULL, 0x000fe200078e024fULL, 0x0000007010267812ULL, 0x000fe200078ef803ULL,
0x0000001012377824ULL, 0x100fe200078e024fULL, 0x0000002251227210ULL, 0x000fe20007f3e0ffULL,
0x00000010214d7824ULL, 0x000fe200078e024fULL, 0x0000002651267210ULL, 0x000fe20007f5e0ffULL,
0x0000008013127825ULL, 0x000fc800078e00ffULL, 0x000000010b217824ULL, 0x000fe200000e0653ULL,
0x0000002451247210ULL, 0x000fe20007f1e0ffULL, 0x0000001014397824ULL, 0x100fe400078e024fULL,
0x00000010163b7824ULL, 0x100fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000201d7faeULL, 0x0003e2000b901c46ULL, 0x0000001028457824ULL, 0x000fe200078e024fULL,
0x0000007012287812ULL, 0x000fe200078ef803ULL, 0x000000102c477824ULL, 0x100fe400078e024fULL,
0x000000102e497824ULL, 0x000fc400078e024fULL, 0x00000010084b7824ULL, 0x100fe400078e024fULL,
0x00000010234f7824ULL, 0x000fe400078e024fULL, 0x000000010d237824ULL, 0x000fe400008e0653ULL,
0x00000080150a7825ULL, 0x000fc600078e00ffULL, 0x0000000022337faeULL, 0x0003e2000b901c46ULL,
0x000000010f257824ULL, 0x000fe200000e0653ULL, 0x0000002851287210ULL, 0x000fe20007f1e0ffULL,
0x00000080170c7825ULL, 0x000fc600078e00ffULL, 0x0000000024357faeULL, 0x0003e2000b901c46ULL,
0x0000000111277824ULL, 0x000fe200010e0653ULL, 0x000000700c2c7812ULL, 0x000fe200078ef803ULL,
0x00000080290e7825ULL, 0x000fc600078e00ffULL, 0x0000002c512c7210ULL, 0x000fe20007f3e0ffULL,
0x000000802a107825ULL, 0x000fe200078e00ffULL, 0x000000700a2a7812ULL, 0x100fe200078ef803ULL,
0x0000000026377faeULL, 0x0003e2000b901c46ULL, 0x000000700e2e7812ULL, 0x000fe200078ef803ULL,
0x0000000113297824ULL, 0x000fe200000e0653ULL, 0x0000007010307812ULL, 0x000fe200078ef803ULL,
0x000000010d2d7824ULL, 0x100fe200008e0653ULL, 0x0000002a512a7210ULL, 0x040fe20007f1e0ffULL,
0x00000080340c7825ULL, 0x000fe200078e00ffULL, 0x0000002e512e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000028397faeULL, 0x0003e2000b901c46ULL, 0x0000003051307210ULL, 0x000fe20007f7e0ffULL,
0x000000010b2b7824ULL, 0x000fe200000e0653ULL, 0x000000700c0c7812ULL, 0x000fe200078ef803ULL,
0x00000080320a7825ULL, 0x000fc600078e00ffULL, 0x0000000c510c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f2f7824ULL, 0x000fe200010e0653ULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x0000000111317824ULL, 0x000fe200018e0653ULL, 0x000000002a3b7faeULL, 0x0003e2000b901c46ULL,
0x00000080360e7825ULL, 0x000fe200078e00ffULL, 0x0000000a510a7210ULL, 0x000fe40007f1e0ffULL,
0x000000002c3d7faeULL, 0x0003e2000b901c46ULL, 0x0000008038107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc400078ef803ULL, 0x000000002e3f7faeULL, 0x0003e2000b901c46ULL,
0x000000803a127825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef803ULL,
0x0000000e510e7210ULL, 0x040fe20007f5e0ffULL, 0x000000803c147825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x100fe200078ef803ULL, 0x0000000030417faeULL, 0x0003e2000b901c46ULL,
0x0000001051107210ULL, 0x000fe20007f7e0ffULL, 0x000000803e167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x000fc400078ef803ULL, 0x0000001251127210ULL, 0x000fe20007f9e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0653ULL, 0x0000007016037812ULL, 0x000fe200078ef803ULL,
0x000000010d0d7824ULL, 0x100fe200008e0653ULL, 0x0000001451147210ULL, 0x000fe20007fbe0ffULL,
0x000000010f0f7824ULL, 0x100fe200010e0653ULL, 0x0000000351167210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x100fe200018e0653ULL, 0x000000000a437faeULL, 0x0003e2000b901c46ULL,
0x0000000113137824ULL, 0x100fe400020e0653ULL, 0x0000000115157824ULL, 0x100fe200028e0653ULL,
0x000000000c457faeULL, 0x0003e2000b901c46ULL, 0x0000000117177824ULL, 0x000fc600030e0653ULL,
0x000000000e477faeULL, 0x0003e8000b901c46ULL, 0x0000000010497faeULL, 0x0003e8000b901c46ULL,
0x00000000124b7faeULL, 0x0003e8000b901c46ULL, 0x00000000144d7faeULL, 0x0003e8000b901c46ULL,
0x00000000164f7faeULL, 0x0003e4000b901c46ULL, 0x000000025c5c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff1d7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001b5c00720cULL, 0x000fda0003f06070ULL, 0x0000000204038824ULL, 0x000fc800078e00ffULL,
0x00006a00030a8a24ULL, 0x000fc800078e025cULL, 0x000066000a0a8625ULL, 0x000fca00078e0005ULL,
0x000000060a1d8981ULL, 0x000322000c1e1900ULL, 0x00005800ff037624ULL, 0x000fca00078e00ffULL,
0x0000001f03037810ULL, 0x000fc80007ffe0ffULL, 0x00000005ff157819ULL, 0x000fc40000011603ULL,
0x00000000000a7805ULL, 0x002fca0000015200ULL, 0x01a60400ff037984ULL, 0x000e620000000800ULL,
0x0000001502027224ULL, 0x000fe400078e02ffULL, 0x000000011c5d7824ULL, 0x000fe400078e0a19ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0005ULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a087210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140cULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060cULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x000000201f057824ULL, 0x002fca00078e0206ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080b7824ULL, 0x040fe400078e0207ULL,
0x00000001050a7824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x00000010060c7824ULL, 0x040fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000010060d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x100fe200078e0208ULL, 0x000001f00c0b7812ULL, 0x000fe200078ee20bULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000b0c7984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x000000000a107984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff227224ULL, 0x002fe400078e000cULL, 0x000000ffff237224ULL, 0x000fe400078e000eULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fc400078e0012ULL,
0x000000ffff267224ULL, 0x000fe400078e000dULL, 0x000000ffff277224ULL, 0x000fe200078e000fULL,
0x000000200a007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff247224ULL, 0x000fe400078e0011ULL,
0x000000ffff257224ULL, 0x000fca00078e0013ULL, 0x000000240b007388ULL, 0x000fe8000000cc00ULL,
0x00000000070c7984ULL, 0x000e68000000cc00ULL, 0x0000000005107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff2b7224ULL, 0x002fe400078e000eULL, 0x000000ffff2a7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff287224ULL, 0x004fe400078e0010ULL,
0x000000ffff297224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002805007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60000ff0c7f8cULL, 0x002e62000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01a60400ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a06087210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140aULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e060aULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000005f7919ULL, 0x000e620000000000ULL, 0x00000100095e7810ULL, 0x000fe20007ffe0ffULL,
0x00006a0004617a24ULL, 0x000fe200078e02ffULL, 0x0001a6881f677811ULL, 0x000fe200078e18ffULL,
0x0000000215607824ULL, 0x000fe200078e00ffULL, 0xffffffff19667810ULL, 0x040fe20007ffe0ffULL,
0x3db504f368687820ULL, 0x010fe20000410000ULL, 0x0000000919657810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0001a6081f647811ULL, 0x000fe200078e28ffULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000263057810ULL, 0x040fe20007ffe0ffULL,
0x0000010063697824ULL, 0x000fe200078e025eULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000001d182b7224ULL, 0x010fe200078e02ffULL, 0x0000001a0500720cULL, 0x000fc40003f06070ULL,
0x0000004069057812ULL, 0x000fe400078ec0ffULL, 0x000000016a627812ULL, 0x000fc600078e0cffULL,
0x0000000100047824ULL, 0x000fcc00078e0205ULL, 0x00000cc000008947ULL, 0x008fea0003800000ULL,
0x00000003ff227819ULL, 0x102fe2000001165fULL, 0x000000021f1d7824ULL, 0x000fe200078e0262ULL,
0x000064002b297a11ULL, 0x040fe400078038ffULL, 0x00000004220a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000122067824ULL, 0x040fe200078e0204ULL, 0x00000008220c7810ULL, 0x040fe40007ffe0ffULL,
0x0000001022127810ULL, 0x000fe20007ffe0ffULL, 0x000000010a057824ULL, 0x100fe200078e025fULL,
0x0000000c220e7810ULL, 0x000fe20007ffe0ffULL, 0x000000080a247824ULL, 0x000fe200078e00ffULL,
0x000000691c087217ULL, 0x000fe20007800000ULL, 0x000000010c077824ULL, 0x040fe200078e025fULL,
0x000065002b2b7a11ULL, 0x000fe200000f3cffULL, 0x000000080c267824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee205ULL, 0x000000105f057824ULL, 0x000fe200078e00ffULL,
0x0000001422207810ULL, 0x000fe20007ffe0ffULL, 0x0000000812097824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000070052d7812ULL, 0x000fc400078ec0ffULL, 0x00000018222e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e057824ULL, 0x100fe200078e025fULL, 0x0000002d06107212ULL, 0x000fe200078efcffULL,
0x0000000112067824ULL, 0x000fe200078e025fULL, 0x0000001c22307810ULL, 0x000fe20007ffe0ffULL,
0x000000080e287824ULL, 0x000fe200078e00ffULL, 0x0000001029107210ULL, 0x000fe20007f1e0ffULL,
0x00000008202c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8092a7812ULL, 0x000fe200078ee206ULL,
0x000000010a067824ULL, 0x100fe200078e0204ULL, 0xfffffff828287812ULL, 0x000fe200078ee205ULL,
0x0000000108057824ULL, 0x000fe200078e0a69ULL, 0x000020001d1d7811ULL, 0x000fe200078e68ffULL,
0x000000010c087824ULL, 0x000fe200078e0204ULL, 0x0000002022327810ULL, 0x000fe20007ffe0ffULL,
0x0000000107117824ULL, 0x000fe200000e062bULL, 0x000000050a00720cULL, 0x080fe20003fa6070ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000050c00720cULL, 0x000fc40003f26070ULL,
0x000000050e00720cULL, 0x080fe20003f46070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000051200720cULL, 0x000fe40003f06070ULL, 0x0000002422347810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0a7824ULL, 0x100fe200078e0204ULL, 0x0000002d08147212ULL, 0x080fe200078efcffULL,
0x00000001120c7824ULL, 0x100fe200078e0204ULL, 0x0000002d06127212ULL, 0x000fe200078efcffULL,
0x00000001200e7824ULL, 0x100fe200078e0204ULL, 0x0000002914147210ULL, 0x080fe20007f9e0ffULL,
0x000000012e067824ULL, 0x000fe200078e0204ULL, 0x0000002912127210ULL, 0x000fe20007f7e0ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002d0e0e7212ULL, 0x000fc600078efcffULL, 0x0000000107137824ULL, 0x000fe200018e062bULL,
0x0000002d0a0a7212ULL, 0x000fe200078efcffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0x000000290a0a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000109157824ULL, 0x000fe200020e062bULL,
0x000000290e0e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000122087824ULL, 0x000fe200078e025fULL,
0x0000002d06167212ULL, 0x000fe200078efcffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x100fe200020e062bULL,
0x000000052200720cULL, 0x000fe20003f86070ULL, 0x0000000130067824ULL, 0x000fe200078e0204ULL,
0x0000002d0c0c7212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe200018e062bULL,
0x0000002916167210ULL, 0x080fe20007fde0ffULL, 0x0000000120097824ULL, 0x100fe200078e025fULL,
0x0ffffff808087812ULL, 0x100fe200078ef85fULL, 0x000000012e217824ULL, 0x000fe200078e025fULL,
0x000000290c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000107177824ULL, 0x000fe200030e062bULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000001008237824ULL, 0x000fe400078e021dULL, 0x000000010d0d7824ULL, 0x000fe200018e062bULL,
0x000000052000720cULL, 0x000fe20003f66070ULL, 0x0000000132087824ULL, 0x000fe200078e0204ULL,
0x0000002d06207212ULL, 0x000fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010237faeULL, 0x0003e2000e101c46ULL, 0x000000052e00720cULL, 0x040fe20003f86070ULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002920207210ULL, 0x000fe20007fde0ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee221ULL,
0x0000000134067824ULL, 0x000fe200078e0204ULL, 0x0000002d08087212ULL, 0x000fe200078efcffULL,
0x0000000107217824ULL, 0x000fe400030e062bULL, 0x0000001024237824ULL, 0x002fe200078e021dULL,
0x0000002908087210ULL, 0x000fe20007fde0ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0x0000000012237faeULL, 0x0003e2000e901c46ULL, 0x000000053000720cULL, 0x040fe20003fa6070ULL,
0x0000000130117824ULL, 0x000fe200078e025fULL, 0x0000002d06107212ULL, 0x000fe200078efcffULL,
0x0000000830247824ULL, 0x000fe200078e00ffULL, 0x0000002822307810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200030e062bULL, 0x0000002910107210ULL, 0x000fe20007fde0ffULL,
0x0000001026257824ULL, 0x000fe200078e021dULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x0000000130067824ULL, 0x000fc400078e0204ULL, 0x0000000107117824ULL, 0x000fe200030e062bULL,
0x0000000014257faeULL, 0x0005e2000c901c46ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000053200720cULL, 0x000fc60003f26070ULL, 0x0000000132137824ULL, 0x002fe200078e025fULL,
0x0000002d06127212ULL, 0x000fe200078efcffULL, 0x0000000832327824ULL, 0x000fe400078e00ffULL,
0x0000001028237824ULL, 0x000fe200078e021dULL, 0x0000002912127210ULL, 0x000fe20007fde0ffULL,
0x0000000134267824ULL, 0x000fe200078e025fULL, 0xfffffff832067812ULL, 0x000fe200078ee213ULL,
0x000000102a157824ULL, 0x004fe200078e021dULL, 0x0000002c22147810ULL, 0x000fe20007ffe0ffULL,
0x0000000107137824ULL, 0x000fe200030e062bULL, 0x000000000a237faeULL, 0x0003e2000d101c46ULL,
0x000000102c077824ULL, 0x100fe200078e021dULL, 0x000000053400720cULL, 0x080fe20003f46070ULL,
0x0000001006257824ULL, 0x100fe200078e021dULL, 0x000000000c157faeULL, 0x0005e2000c101c46ULL,
0x0000000114067824ULL, 0x000fe200078e0204ULL, 0x0000003822287810ULL, 0x000fe20007ffe0ffULL,
0x0000000834277824ULL, 0x000fe200078e00ffULL, 0x000000000e077faeULL, 0x0007e2000d901c46ULL,
0x0000001024237824ULL, 0x102fe200078e021dULL, 0x0000003022247810ULL, 0x000fe20007ffe0ffULL,
0x000000102e0b7824ULL, 0x000fe200078e021dULL, 0xfffffff827267812ULL, 0x000fe200078ee226ULL,
0x00000001140d7824ULL, 0x004fe200078e025fULL, 0x000000052400720cULL, 0x000fc40003f66070ULL,
0x00000000160b7faeULL, 0x0003e2000e101c46ULL, 0x0000008006067825ULL, 0x008fe200078e00ffULL,
0x000000051400720cULL, 0x000fe40003f86070ULL, 0x0000000020237faeULL, 0x0005e2000e901c46ULL,
0x0000001026277824ULL, 0x000fe200078e021dULL, 0x0000002d060a7212ULL, 0x000fe200078efcffULL,
0x0000000124067824ULL, 0x000fe200078e0204ULL, 0x0000003422267810ULL, 0x000fe20007ffe0ffULL,
0x0000000008257faeULL, 0x0007e2000c901c46ULL, 0x000000290a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000008300e7824ULL, 0x000fe200078e00ffULL, 0x0000003c22227810ULL, 0x000fe20007ffe0ffULL,
0x0000000010277faeULL, 0x0009e2000d101c46ULL, 0x000000053000720cULL, 0x080fe20003fa6070ULL,
0x00000001070b7824ULL, 0x002fe200030e062bULL, 0x000000052600720cULL, 0x080fe20003f46070ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000052800720cULL, 0x000fc40003f26070ULL,
0x000000052200720cULL, 0x000fe20003f06070ULL, 0x0000000130057824ULL, 0x100fe200078e025fULL,
0x0000002d060c7212ULL, 0x000fe200078efcffULL, 0x0000000126087824ULL, 0x008fe400078e0204ULL,
0x0000000814107824ULL, 0x010fe200078e00ffULL, 0x000000290c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000000124067824ULL, 0x000fe200078e025fULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL,
0x00000008240f7824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee206ULL,
0x0000000128057824ULL, 0x100fe200078e0204ULL, 0x0000002d08087212ULL, 0x000fe200078efcffULL,
0x00000001070d7824ULL, 0x000fe400030e062bULL, 0x0000000122067824ULL, 0x000fe200078e0204ULL,
0x0000002908087210ULL, 0x000fe20007fde0ffULL, 0x0000000126077824ULL, 0x040fe400078e025fULL,
0x0000000826167824ULL, 0x000fe400078e00ffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002d04047212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x000fe200030e062bULL,
0x0000002904047210ULL, 0x000fe20007fde0ffULL, 0x00000001280f7824ULL, 0x100fe200078e025fULL,
0x0000002d06067212ULL, 0x000fe200078efcffULL, 0x0000000828207824ULL, 0x004fe400078e00ffULL,
0x0000000122117824ULL, 0x040fe400078e025fULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20fULL, 0x0000000105057824ULL, 0x000fe200030e062bULL,
0x0000002906067210ULL, 0x000fe20007fde0ffULL, 0x000000100e0f7824ULL, 0x000fe200078e021dULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000001010117824ULL, 0x000fc400078e021dULL,
0x0000001014157824ULL, 0x100fe200078e021dULL, 0x00000000120f7faeULL, 0x0003e2000e901c46ULL,
0x0000001016177824ULL, 0x100fe400078e021dULL, 0x0000001020217824ULL, 0x100fe200078e021dULL,
0x000000000a117faeULL, 0x0003e2000e101c46ULL, 0x00000010221d7824ULL, 0x000fe400078e021dULL,
0x0000000107077824ULL, 0x000fe200030e062bULL, 0x000000000c157faeULL, 0x0003e8000d901c46ULL,
0x0000000008177faeULL, 0x0003e8000d101c46ULL, 0x0000000004217faeULL, 0x0003e8000c901c46ULL,
0x00000000061d7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x000000045f067811ULL, 0x042fe400078fe8ffULL, 0x000000085f087811ULL, 0x000fc400078fe8ffULL,
0x000000105f0c7811ULL, 0x040fe200078fe8ffULL, 0x0000000106057824ULL, 0x140fe200078e025fULL,
0x0000000c5f0a7811ULL, 0x040fe200078fe8ffULL, 0x0000000806147824ULL, 0x000fe200078e00ffULL,
0x000000145f0e7811ULL, 0x040fe200078fe8ffULL, 0x0000000108077824ULL, 0x040fe200078e025fULL,
0x0000001c5f107811ULL, 0x040fe200078fe8ffULL, 0x0000000808167824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000010c057824ULL, 0x040fe200078e025fULL,
0x000000185f0f7811ULL, 0x040fe200078fe8ffULL, 0x000000080c227824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x000000010a097824ULL, 0x040fe200078e025fULL,
0x000000205f117811ULL, 0x040fe200078fe8ffULL, 0x000000080a207824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x000000010e077824ULL, 0x040fe200078e025fULL,
0x000000285f2e7811ULL, 0x040fe200078fe8ffULL, 0x000000080e247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee209ULL, 0x0000000110057824ULL, 0x040fe200078e025fULL,
0x000000245f2c7811ULL, 0x000fe200078fe8ffULL, 0x0000000810287824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000010f097824ULL, 0x000fe200078e025fULL,
0x0000002c5f307811ULL, 0x000fe200078fe8ffULL, 0x000000080f267824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee205ULL, 0x0000000111077824ULL, 0x000fe200078e025fULL,
0x000000345f347811ULL, 0x000fe200078fe8ffULL, 0x00000008112a7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x000000012e057824ULL, 0x040fe200078e025fULL,
0x000000305f327811ULL, 0x040fe200078fe8ffULL, 0x000000082e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee207ULL, 0x000000012c097824ULL, 0x040fe200078e025fULL,
0x000000385f367811ULL, 0x040fe200078fe8ffULL, 0x000000082c3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000130077824ULL, 0x040fe200078e025fULL,
0x0000003c5f387811ULL, 0x000fe200078fe8ffULL, 0x00000008303e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL, 0x0000000134057824ULL, 0x040fe200078e025fULL,
0x000064002b4d7a11ULL, 0x040fe200078038ffULL, 0x0000000834427824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL, 0x0000000132097824ULL, 0x040fe200078e025fULL,
0x000065002b4f7a11ULL, 0x000fe200000f3cffULL, 0x0000000832407824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee205ULL, 0x0000000136077824ULL, 0x040fe200078e025fULL,
0x0000005f5f057211ULL, 0x000fe200078fe8ffULL, 0x0000000836447824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee209ULL, 0x0000000138097824ULL, 0x040fe200078e025fULL,
0x0000000705127812ULL, 0x000fe200078ec0ffULL, 0x0000000838467824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee207ULL, 0x000000021f077824ULL, 0x000fe200078e0262ULL,
0x0ffffff812127812ULL, 0x000fe200078ef85fULL, 0x0000000106067824ULL, 0x100fe200078e0204ULL,
0xfffffff846467812ULL, 0x000fe200078ee209ULL, 0x0000000108087824ULL, 0x100fe200078e0204ULL,
0x0000200007077811ULL, 0x000fe200078e68ffULL, 0x000000010a0a7824ULL, 0x000fc400078e0204ULL,
0x000000010c0c7824ULL, 0x100fe400078e0204ULL, 0x000000010e0e7824ULL, 0x100fe400078e0204ULL,
0x000000010f0f7824ULL, 0x100fe400078e0204ULL, 0x0000000110107824ULL, 0x100fe400078e0204ULL,
0x0000000111117824ULL, 0x100fe400078e0204ULL, 0x000000012c2c7824ULL, 0x000fc400078e0204ULL,
0x000000012e2e7824ULL, 0x100fe400078e0204ULL, 0x0000000130307824ULL, 0x100fe400078e0204ULL,
0x0000000132327824ULL, 0x100fe400078e0204ULL, 0x0000000134347824ULL, 0x100fe400078e0204ULL,
0x0000000136367824ULL, 0x100fe400078e0204ULL, 0x0000000138387824ULL, 0x000fe200078e0204ULL,
0x000000045f047211ULL, 0x040fe200078fe8ffULL, 0x000000105f057824ULL, 0x000fc400078e00ffULL,
0x00000010121d7824ULL, 0x100fe400078e0207ULL, 0x00000010142d7824ULL, 0x000fe200078e0207ULL,
0x00000070054b7812ULL, 0x000fe200078ec0ffULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x00000010162f7824ULL, 0x100fe200078e0207ULL, 0x0000004b04127212ULL, 0x000fe200078efcffULL,
0x0000001020317824ULL, 0x100fe400078e0207ULL, 0x0000001022337824ULL, 0x100fe200078e0207ULL,
0x000000124d127210ULL, 0x000fe20007f1e0ffULL, 0x0000001024357824ULL, 0x100fe400078e0207ULL,
0x0000001026377824ULL, 0x100fe400078e0207ULL, 0x0000001028397824ULL, 0x000fc400078e0207ULL,
0x000000102a3b7824ULL, 0x100fe400078e0207ULL, 0x000000103a3d7824ULL, 0x100fe400078e0207ULL,
0x000000103c3f7824ULL, 0x100fe400078e0207ULL, 0x000000103e417824ULL, 0x100fe400078e0207ULL,
0x0000001040437824ULL, 0x100fe400078e0207ULL, 0x0000001042457824ULL, 0x000fc400078e0207ULL,
0x0000001044477824ULL, 0x100fe400078e0207ULL, 0x0000001046497824ULL, 0x000fe400078e0207ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000004b06147212ULL, 0x000fc600078efcffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000004b08167212ULL, 0x080fe400078efcffULL, 0x000000144d147210ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000004b0a207212ULL, 0x000fc600078efcffULL,
0x0000000105137824ULL, 0x100fe200000e064fULL, 0x000000164d167210ULL, 0x000fe20007f1e0ffULL,
0x0000000107157824ULL, 0x100fe200008e064fULL, 0x000000204d207210ULL, 0x000fe20007f5e0ffULL,
0x000000800e047825ULL, 0x000fe200078e00ffULL, 0x0000004b0c227212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121d7faeULL, 0x0003e4000b901c46ULL,
0x0000000109177824ULL, 0x100fe200000e064fULL, 0x000000224d227210ULL, 0x000fe20007f1e0ffULL,
0x000000800f067825ULL, 0x000fe200078e00ffULL, 0x0000004b04247212ULL, 0x080fe200078efcffULL,
0x00000000142d7faeULL, 0x0003e4000b901c46ULL, 0x000000010b217824ULL, 0x100fe200010e064fULL,
0x0000004b06267212ULL, 0x080fe200078efcffULL, 0x0000008010087825ULL, 0x000fe200078e00ffULL,
0x00000000162f7faeULL, 0x0003e4000b901c46ULL, 0x000000264d267210ULL, 0x000fe20007f3e0ffULL,
0x00000080110a7825ULL, 0x000fe200078e00ffULL, 0x0000004b08287212ULL, 0x080fe200078efcffULL,
0x0000000020317faeULL, 0x0003e4000b901c46ULL, 0x000000010d237824ULL, 0x100fe200000e064fULL,
0x0000004b0a2a7212ULL, 0x080fe200078efcffULL, 0x0000000107277824ULL, 0x100fe200008e064fULL,
0x000000244d247210ULL, 0x040fe20007f1e0ffULL, 0x000000802e067825ULL, 0x000fe200078e00ffULL,
0x000000284d287210ULL, 0x040fe20007f5e0ffULL, 0x0000000022337faeULL, 0x0003e2000b901c46ULL,
0x0000002a4d2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000105257824ULL, 0x000fe200000e064fULL,
0x0000004b06067212ULL, 0x000fe200078efcffULL, 0x000000802c047825ULL, 0x000fc600078e00ffULL,
0x000000064d067210ULL, 0x000fe20007f3e0ffULL, 0x0000000109297824ULL, 0x100fe200010e064fULL,
0x0000004b04047212ULL, 0x080fe200078efcffULL, 0x000000010b2b7824ULL, 0x000fe200018e064fULL,
0x0000000024357faeULL, 0x0003e2000b901c46ULL, 0x0000008030087825ULL, 0x000fe200078e00ffULL,
0x000000044d047210ULL, 0x000fe40007f1e0ffULL, 0x0000000026377faeULL, 0x0003e2000b901c46ULL,
0x00000080320a7825ULL, 0x000fe200078e00ffULL, 0x0000004b08087212ULL, 0x000fc400078efcffULL,
0x0000000028397faeULL, 0x0003e2000b901c46ULL, 0x00000080340c7825ULL, 0x000fe200078e00ffULL,
0x0000004b0a0a7212ULL, 0x080fe400078efcffULL, 0x000000084d087210ULL, 0x040fe20007f5e0ffULL,
0x00000080360e7825ULL, 0x000fe200078e00ffULL, 0x0000004b0c0c7212ULL, 0x080fe200078efcffULL,
0x000000002a3b7faeULL, 0x0003e2000b901c46ULL, 0x0000000a4d0a7210ULL, 0x000fe20007f7e0ffULL,
0x0000008038107825ULL, 0x000fe200078e00ffULL, 0x0000004b0e0e7212ULL, 0x000fc400078efcffULL,
0x0000000c4d0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000105057824ULL, 0x100fe200000e064fULL,
0x0000004b10107212ULL, 0x000fe200078efcffULL, 0x0000000107077824ULL, 0x100fe200008e064fULL,
0x0000000e4d0e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000109097824ULL, 0x100fe200010e064fULL,
0x000000104d107210ULL, 0x000fe20007fde0ffULL, 0x000000010b0b7824ULL, 0x100fe200018e064fULL,
0x00000000043d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x100fe400020e064fULL,
0x000000010f0f7824ULL, 0x100fe200028e064fULL, 0x00000000063f7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc600030e064fULL, 0x0000000008417faeULL, 0x0003e8000b901c46ULL,
0x000000000a437faeULL, 0x0003e8000b901c46ULL, 0x000000000c457faeULL, 0x0003e8000b901c46ULL,
0x000000000e477faeULL, 0x0003e8000b901c46ULL, 0x0000000010497faeULL, 0x0003e4000b901c46ULL,
0x000000025c5c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff1d7424ULL, 0x002fc400078e00ffULL, 0x0000001b5c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fd4000001ff00ULL, 0x00000002610c8824ULL, 0x000fe400078e025cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000066000c0c8625ULL, 0x000fe200078e000dULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000060c1d8981ULL, 0x000322000c1e1900ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x002fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff85f4c7812ULL, 0x020fe200078ec0ffULL, 0x000000021f827824ULL, 0x000fe200078e026aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016b857810ULL, 0x000fc40007ffe0ffULL,
0x000000074c507812ULL, 0x000fe400078ef85fULL, 0x0000200082827811ULL, 0x000fe400078e68ffULL,
0x000000085f847812ULL, 0x000fe200078ec0ffULL, 0x00000001504c7824ULL, 0x040fe200078e026bULL,
0x00000004ff887819ULL, 0x100fe2000001165fULL, 0x00000008504d7824ULL, 0x000fe200078e00ffULL,
0x0000000784847812ULL, 0x000fe200078ef85fULL, 0x0000000850517824ULL, 0x040fe400078e00ffULL,
0x0000000150507824ULL, 0x000fe200078e0285ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL,
0x000000026b887824ULL, 0x000fe200078e0288ULL, 0x0000001084837812ULL, 0x000fc400078efcffULL,
0xfffffff851517812ULL, 0x000fe200078ee250ULL, 0x000000104d4d7824ULL, 0x000fc800078e0282ULL,
0x0000001051517824ULL, 0x000fe400078e0282ULL, 0x000000004d4c783bULL, 0x000e680000000200ULL,
0x000000005150783bULL, 0x000ea20000000200ULL, 0x00000018ff547819ULL, 0x002fe2000001144cULL,
0x000100004c557824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001144dULL,
0x000100004d5a7824ULL, 0x040fe200078e00ffULL, 0x00000054008e7306ULL, 0x0003e20000200c00ULL,
0x000088804d597816ULL, 0x040fe200000000ffULL, 0x000001004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc40000011455ULL, 0x000088804c567816ULL, 0x040fe200000000ffULL,
0x000001004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x00000058008d7306ULL, 0x0007e20000200c00ULL, 0x000000205f547810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0xfffffff854547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001144fULL, 0x0000004d00927306ULL, 0x0003e20000200c00ULL,
0x00000007548a7812ULL, 0x000fe200078ef85fULL, 0x000100004e587824ULL, 0x008fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x004fc40000011450ULL, 0x000088804f867816ULL, 0x040fe200000000ffULL,
0x000000018a547824ULL, 0x000fe200078e026bULL, 0x0000888050707816ULL, 0x000fe200000000ffULL,
0x000000088a557824ULL, 0x000fe200078e00ffULL, 0x00000056008c7306ULL, 0x0004e20000200c00ULL,
0x000100004f4d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001144eULL,
0x000001004f4f7824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe400078ee254ULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000004c008f7306ULL, 0x0002e20000200c00ULL,
0x0000001055557824ULL, 0x000fe200078e0282ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x000000005554783bULL, 0x004ea20000000200ULL, 0x0000004d00897306ULL, 0x0007e20000200c00ULL,
0x000088804e4c7816ULL, 0x042fe200000000ffULL, 0x000001004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011451ULL, 0x0000888051737816ULL, 0x040fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004c00937306ULL, 0x0003e20000200c00ULL,
0x00010000514d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011453ULL,
0x0000010051517824ULL, 0x000fe200078e00ffULL, 0x0000888053797816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004f008b7306ULL, 0x0007e20000200c00ULL,
0x00010000504c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc40000011452ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000004d00767306ULL, 0x0003e20000200c00ULL, 0x00000010844f7824ULL, 0x008fe200078e00ffULL,
0x0000888052747816ULL, 0x000fe400000000ffULL, 0x000054108c8c7816ULL, 0x000fe4000000008dULL,
0x000054108f8d7816ULL, 0x000fe4000000008eULL, 0x0000004c00717306ULL, 0x0007e20000200c00ULL,
0x00000001834d7824ULL, 0x002fe200078e0288ULL, 0x000000026b6b7810ULL, 0x000fc40007ffe0ffULL,
0x00000018ff817819ULL, 0x004fc80000011454ULL, 0x0000005000727306ULL, 0x0003e20000200c00ULL,
0x00000001844c7824ULL, 0x008fe200078e0288ULL, 0x00000018ff7f7819ULL, 0x000fe40000011455ULL,
0x00000018ff7d7819ULL, 0x000fe40000011456ULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000005800947306ULL, 0x0004e20000200c00ULL, 0x0000001083507824ULL, 0x002fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc40000011457ULL, 0x0000000288887810ULL, 0x000fe40007ffe0ffULL,
0xfffffff0504d7812ULL, 0x000fe200078ee24dULL, 0x0001000053507824ULL, 0x000fe200078e00ffULL,
0x0000004e00957306ULL, 0x0003e20000200c00ULL, 0x000000104c587824ULL, 0x004fe200078e00ffULL,
0x000000086b00780cULL, 0x000fe20003f05270ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011450ULL, 0x0000010053537824ULL, 0x000fe200078e00ffULL,
0x0000888054507816ULL, 0x000fc400000000ffULL, 0x0000005900907306ULL, 0x000fe20000200c00ULL,
0x00010000524e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000010052527824ULL, 0x000fe200078e00ffULL, 0x0000541093947816ULL, 0x008fe40000000094ULL,
0x00000018ff777819ULL, 0x000fe4000001144eULL, 0x0000005a00917306ULL, 0x0002a20000200c00ULL,
0x000000004d4c783bULL, 0x000ee20000000200ULL, 0x00000018ff527819ULL, 0x000fcc0000011452ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x000000005858783bULL, 0x002e6e0000000200ULL,
0x0000005100757306ULL, 0x0005e40000200c00ULL, 0x0000541090907816ULL, 0x004fcc0000000091ULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0001000054517824ULL, 0x000fe200078e00ffULL,
0x0000541092917816ULL, 0x000fe20000000087ULL, 0x0001000056877824ULL, 0x000fe400078e00ffULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000005100977306ULL, 0x0003e20000200c00ULL,
0x0000541095957816ULL, 0x004fe20000000080ULL, 0x0000008c4c28723cULL, 0x008fe20000001828ULL,
0x0000888057807816ULL, 0x000fca00000000ffULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x0000010055517824ULL, 0x042fe200078e00ffULL, 0x0000008c5848723cULL, 0x040b6c0000001848ULL,
0x00000053007b7306ULL, 0x0003e40000200c00ULL, 0x000000905844723cULL, 0x040f6c0000001844ULL,
0x0000005000967306ULL, 0x0007e20000200c00ULL, 0x000000018a537824ULL, 0x042fe200078e0285ULL,
0x00000018ff857819ULL, 0x000fe20000011451ULL, 0x000000088a8a7824ULL, 0x000fe200078e00ffULL,
0x0000888056517816ULL, 0x040fe200000000ffULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x0000541086867816ULL, 0x004fe20000000089ULL, 0x000000945840723cULL, 0x000fe20000001840ULL,
0x0000005200787306ULL, 0x0003e20000200c00ULL, 0x0001000055507824ULL, 0x008fe200078e00ffULL,
0xfffffff88a537812ULL, 0x000fc400078ee253ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000001053537824ULL, 0x000fe200078e0282ULL,
0x00000085008a7306ULL, 0x000fe20000200c00ULL, 0x0000888055527816ULL, 0x002fe200000000ffULL,
0x000000ffff827224ULL, 0x000fe200078e0051ULL, 0x000000904c24723cULL, 0x040f6a0000001824ULL,
0x0000008700857306ULL, 0x0003e60000200c00ULL, 0x000000944c20723cULL, 0x000fea0000001820ULL,
0x00000052008e7306ULL, 0x000fe20000200c00ULL, 0x000054108b877816ULL, 0x002fe2000000007eULL,
0x000000ffff7e7224ULL, 0x000fc400078e0080ULL, 0x0001000057807824ULL, 0x040fe400078e00ffULL,
0x0000010057577824ULL, 0x000fe400078e00ffULL, 0x0000005000557306ULL, 0x0003e20000200c00ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000086583c723cULL, 0x000fe2000000183cULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000005350783bULL, 0x002e620000000200ULL, 0x000000864c14723cULL, 0x000bec0000001814ULL,
0x0000007f007f7306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000054108a7f7816ULL, 0x004fce000000007fULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x00000082008c7306ULL, 0x0202f00000200c00ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541054817816ULL, 0x004fc40000000081ULL,
0x00000018ff827819ULL, 0x002fca0000011450ULL, 0x0000007e00897306ULL, 0x0003e20000200c00ULL,
0x000054108c8c7816ULL, 0x008fe40000000085ULL, 0x00000018ff857819ULL, 0x000fca0000011453ULL,
0x0000008000867306ULL, 0x0004e20000200c00ULL, 0x000054108e7e7816ULL, 0x002fe20000000055ULL,
0x0000001084557824ULL, 0x000fe200078e00ffULL, 0x00005410568d7816ULL, 0x000fe2000000007dULL,
0x0000000184847824ULL, 0x100fe400078e0288ULL, 0x0000000183887824ULL, 0x040fe400078e0288ULL,
0x0000005700877306ULL, 0x0002620000200c00ULL, 0x0000001083837824ULL, 0x000fe200078e00ffULL,
0xfffffff055847812ULL, 0x000fe200078ee284ULL, 0x0000007e5834723cULL, 0x040fe20000001834ULL,
0x0000541096807816ULL, 0x004fe20000000097ULL, 0x00010000507d7824ULL, 0x000fe200078e00ffULL,
0xfffffff083887812ULL, 0x000fe200078ee288ULL, 0x0000001084547824ULL, 0x000fe200078e00ffULL,
0x0000541089867816ULL, 0x008fe20000000086ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x00000018ff837819ULL, 0x000fe20000011451ULL, 0x0000001088887824ULL, 0x000fe200078e00ffULL,
0x000000805838723cULL, 0x000fe20000001838ULL, 0x000000005454783bULL, 0x002e620000000200ULL,
0x00000018ff847819ULL, 0x000fc40000011452ULL, 0x0000541087877816ULL, 0x000fe2000000007cULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x00008880507c7816ULL, 0x040fe200000000ffULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x0000008c5830723cULL, 0x000f620000001830ULL,
0x00000018ff7d7819ULL, 0x000fc6000001147dULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541070707816ULL, 0x004fe40000000071ULL,
0x00000086582c723cULL, 0x000be4000000182cULL, 0x000000008858783bULL, 0x020ea60000000200ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541072717816ULL, 0x008fc4000000006dULL,
0x000000804c10723cULL, 0x000fe20000001810ULL, 0x00008880526d7816ULL, 0x000fc800000000ffULL,
0x0000008400847306ULL, 0x000fe60000200c00ULL, 0x0000007e4c0c723cULL, 0x040bea000000180cULL,
0x00000050007f7306ULL, 0x020fe40000200c00ULL, 0x00008880517e7816ULL, 0x040fe200000000ffULL,
0x0000008c4c08723cULL, 0x040f6a0000001808ULL, 0x0000007c007c7306ULL, 0x000fe60000200c00ULL,
0x000000864c04723cULL, 0x000b6a0000001804ULL, 0x0000007d007d7306ULL, 0x000ee40000200c00ULL,
0x00010000514d7824ULL, 0x020fe200078e00ffULL, 0x000000705448723cULL, 0x002f620000001848ULL,
0x000000ffff4c7224ULL, 0x000fc400078e007eULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c004e7306ULL, 0x0003e60000200c00ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000000705828723cULL, 0x004f680000001828ULL,
0x0000004d004f7306ULL, 0x0004a20000200c00ULL, 0x00005410734c7816ULL, 0x002fc40000000076ULL,
0x000054107c7c7816ULL, 0x008fca000000007dULL, 0x0000005100507306ULL, 0x0003e20000200c00ULL,
0x00005410754d7816ULL, 0x004fe2000000006cULL, 0x000000ffff6c7224ULL, 0x000fe400078e006dULL,
0x00010000526d7824ULL, 0x040fe400078e00ffULL, 0x0000010052527824ULL, 0x000fe400078e00ffULL,
0x0000004c5444723cULL, 0x000f620000001844ULL, 0x0001000053517824ULL, 0x002fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000004c5824723cULL, 0x000b620000001824ULL, 0x000054104e4e7816ULL, 0x000fe4000000004fULL,
0x0000006d006d7306ULL, 0x000e680000200c00ULL, 0x00008880534c7816ULL, 0x060fe200000000ffULL,
0x0000010053537824ULL, 0x000fc600078e00ffULL, 0x00000052004d7306ULL, 0x000ea40000200c00ULL,
0x00000018ff537819ULL, 0x000fcc0000011453ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x000054106c6c7816ULL, 0x002fce000000006dULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054104d6d7816ULL, 0x004fce0000000084ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078757816ULL, 0x008fe2000000006fULL, 0x0000006c5430723cULL, 0x080b6c0000001830ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x000054107b7b7816ULL, 0x002fe2000000006eULL,
0x0000006c5808723cULL, 0x000b6c0000001808ULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541074747816ULL, 0x004fce0000000077ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x000000745440723cULL, 0x080b6e0000001840ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x00005410797a7816ULL, 0x002fe2000000007aULL,
0x000000745820723cULL, 0x000b6c0000001820ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054107f7d7816ULL, 0x004fe20000000082ULL, 0x0000007a543c723cULL, 0x080b6c000000183cULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00005410504f7816ULL, 0x008fe20000000083ULL,
0x0000007a5814723cULL, 0x000b6c0000001814ULL, 0x0000005100517306ULL, 0x000e640000200c00ULL,
0x0000007c5438723cULL, 0x040b6c0000001838ULL, 0x0000005300527306ULL, 0x000ea40000200c00ULL,
0x0000004e5434723cULL, 0x000b620000001834ULL, 0x000054104c4c7816ULL, 0x002fce0000000051ULL,
0x0000007c5810723cULL, 0x000b620000001810ULL, 0x00005410524d7816ULL, 0x004fce0000000085ULL,
0x0000004e580c723cULL, 0x000b70000000180cULL, 0x0000004c542c723cULL, 0x080b70000000182cULL,
0x0000004c5804723cULL, 0x000b620000001804ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffee1000007947ULL, 0x000fcc000383ffffULL, 0x0000006847477220ULL, 0x080fe40000410000ULL,
0x000000684a4a7220ULL, 0x000fc40000410000ULL, 0x0000006846467220ULL, 0x080fe40000410000ULL,
0x0000006842427220ULL, 0x0a0fe40000410000ULL, 0x0000006843437220ULL, 0x080fe40000410000ULL,
0x000000683e3e7220ULL, 0x080fe40000410000ULL, 0x000000683f3f7220ULL, 0x080fe40000410000ULL,
0x000000683a3a7220ULL, 0x000fc40000410000ULL, 0x000000682c4f7220ULL, 0x080fe40000410000ULL,
0x00000068446a7220ULL, 0x080fe40000410000ULL, 0x0000006839547220ULL, 0x080fe40000410000ULL,
0x0000006835527220ULL, 0x080fe40000410000ULL, 0x000000682f2c7220ULL, 0x080fe40000410000ULL,
0x0000006824247220ULL, 0x000fc40000410000ULL, 0x0000006814147220ULL, 0x080fe40000410000ULL,
0x0000006815157220ULL, 0x080fe40000410000ULL, 0x000000680c0c7220ULL, 0x080fe40000410000ULL,
0x000000680d0d7220ULL, 0x080fe40000410000ULL, 0x0000006804047220ULL, 0x080fe40000410000ULL,
0x00000068486b7220ULL, 0x000fc40000410000ULL, 0x0000006836357220ULL, 0x080fe40000410000ULL,
0x0000006837447220ULL, 0x080fe40000410000ULL, 0x0000006831507220ULL, 0x080fe40000410000ULL,
0x0000006828397220ULL, 0x080fe40000410000ULL, 0x000000683c5a7220ULL, 0x080fe40000410000ULL,
0x000000683d587220ULL, 0x000fc40000410000ULL, 0x0000006838597220ULL, 0x080fe40000410000ULL,
0x000000683b487220ULL, 0x080fe40000410000ULL, 0x0000006834537220ULL, 0x080fe40000410000ULL,
0x0000006830517220ULL, 0x080fe40000410000ULL, 0x0000006832367220ULL, 0x080fe40000410000ULL,
0x0000006833377220ULL, 0x000fc40000410000ULL, 0x000000682d4e7220ULL, 0x080fe40000410000ULL,
0x000000682e4c7220ULL, 0x080fe40000410000ULL, 0x000000682a287220ULL, 0x080fe40000410000ULL,
0x000000ffff317224ULL, 0x000fe400078e0047ULL, 0x0000006849557220ULL, 0x080fe40000410000ULL,
0x0000006845567220ULL, 0x000fc40000410000ULL, 0x00000068405b7220ULL, 0x080fe40000410000ULL,
0x0000006841577220ULL, 0x080fe40000410000ULL, 0x0000006829387220ULL, 0x080fe40000410000ULL,
0x00000068253b7220ULL, 0x080fe40000410000ULL, 0x00000068203c7220ULL, 0x080fe40000410000ULL,
0x00000068213d7220ULL, 0x000fc40000410000ULL, 0x00000068222a7220ULL, 0x080fe40000410000ULL,
0x00000068232d7220ULL, 0x000fe40000410000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e004aULL,
0x000000ffff2f7224ULL, 0x000fe400078e0046ULL, 0x000000ffff307224ULL, 0x000fe400078e0042ULL,
0x000000ffff477224ULL, 0x000fc400078e0043ULL, 0x000000ffff327224ULL, 0x000fe400078e003eULL,
0x000000ffff347224ULL, 0x000fe400078e003fULL, 0x000000ffff337224ULL, 0x000fe400078e003aULL,
0x000000684b4b7220ULL, 0x080fe40000410000ULL, 0x000000682b2b7220ULL, 0x080fe40000410000ULL,
0x0000006826267220ULL, 0x000fc40000410000ULL, 0x0000006827297220ULL, 0x080fe40000410000ULL,
0x0000006816167220ULL, 0x080fe40000410000ULL, 0x0000006817177220ULL, 0x080fe40000410000ULL,
0x0000006810407220ULL, 0x080fe40000410000ULL, 0x0000006811417220ULL, 0x080fe40000410000ULL,
0x0000006812257220ULL, 0x000fc40000410000ULL, 0x0000006813137220ULL, 0x080fe40000410000ULL,
0x000000680e0e7220ULL, 0x080fe40000410000ULL, 0x000000680f0f7220ULL, 0x080fe40000410000ULL,
0x00000068084d7220ULL, 0x080fe40000410000ULL, 0x0000006809457220ULL, 0x080fe40000410000ULL,
0x000000680a207220ULL, 0x000fc40000410000ULL, 0x000000680b217220ULL, 0x080fe40000410000ULL,
0x0000006805497220ULL, 0x080fe40000410000ULL, 0x0000006806227220ULL, 0x080fe40000410000ULL,
0x0000006807237220ULL, 0x000fe40000410000ULL, 0x000000ffff4a7224ULL, 0x000fe400078e002cULL,
0x000000ffff3a7224ULL, 0x000fc400078e0024ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0014ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0015ULL, 0x000000ffff427224ULL, 0x000fe400078e000cULL,
0x000000ffff437224ULL, 0x000fe400078e000dULL, 0x000000ffff467224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000067087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2c7224ULL, 0x000fc400078e002bULL, 0x000000ffff277224ULL, 0x000fe400078e0026ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0016ULL, 0x000000ffff267224ULL, 0x000fe400078e0017ULL,
0x000000ffff247224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x000fe400078e000eULL,
0x000000ffff177224ULL, 0x000fc400078e000fULL, 0x0000000000047805ULL, 0x002fca0000015200ULL,
0x0000040067077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040067077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000045f157824ULL, 0x000fe200078e00ffULL, 0x0000005d6300720cULL, 0x000fc80003f06070ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x000000801f147824ULL, 0x000fca00078e0214ULL,
0x01a4000014047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000001e5f0a7211ULL, 0x040fe200078ff0ffULL, 0x000000025f6c7824ULL, 0x000fe200078e00ffULL,
0xffffff0069697810ULL, 0x000fe40007ffe0ffULL, 0x000000100a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000066c6c7812ULL, 0x000fca00078ec0ffULL, 0x000000016c6e7824ULL, 0x000fe200078e0219ULL,
0x0000000b000b7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0b0d7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000d00097305ULL, 0x000ee4000021f000ULL, 0x000000ffff0f7224ULL, 0x008fc800078e0a09ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f09117227ULL, 0x000fe200078e0008ULL,
0x000000080a087810ULL, 0x000fca0007ffe0ffULL, 0x00000008110c7227ULL, 0x000fc800078e00ffULL,
0x0000000a11097227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a09ULL, 0x00005a000d0d7a24ULL, 0x000fe200078e0208ULL,
0x000000691c087217ULL, 0x000fe20007800000ULL, 0x00005a000b0b7a24ULL, 0x000fe200078e020aULL,
0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e11107227ULL, 0x000fe200078e00ffULL,
0x00005a000d007a0cULL, 0x000fe40003fa6070ULL, 0x00005a000b007a0cULL, 0x000fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0a10ULL, 0x0000000a11117227ULL, 0x000fc800078e00ffULL,
0x00005a000f0e7a24ULL, 0x000fe400078e020eULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a11ULL,
0x80005a000d0d5a10ULL, 0x000fe20007ffe0ffULL, 0x0000000108697824ULL, 0x000fe200078e0a69ULL,
0x00005a000e007a0cULL, 0x000fe20003f26070ULL, 0x00005a000f0a7a24ULL, 0x000fe200078e020aULL,
0x80005a000b0b0a10ULL, 0x000fe20007ffe0ffULL, 0x0000000165087824ULL, 0x000fe200078e026cULL,
0x00005a000d007a0cULL, 0x000fc40003fc6070ULL, 0x00005a000b007a0cULL, 0x000fe20003f46070ULL,
0x000000016e0b7824ULL, 0x100fe200078e0a69ULL, 0x00005a000a007a0cULL, 0x000fe20003f66070ULL,
0x00000001080d7824ULL, 0x000fe200078e0a69ULL, 0x000000010c0c5810ULL, 0x000fe40007ffe0ffULL,
0x0000000109090810ULL, 0x000fe40007ffe0ffULL, 0x80005a000e0e1a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fc40003fa5070ULL, 0x00005a000e007a0cULL, 0x000fe40003f86070ULL,
0x00005a00ff0e7a12ULL, 0x000fe400078e33ffULL, 0x000000010c0c6810ULL, 0x000fe40007ffe0ffULL,
0x80005a000a0a3a10ULL, 0x000fe40007ffe0ffULL, 0x0000000109092810ULL, 0x000fe40007ffe0ffULL,
0x000000696e00720cULL, 0x000fc40003fc6070ULL, 0x0000000b660b7217ULL, 0x000fe40003800000ULL,
0x00005a000a007a0cULL, 0x000fe40003f46070ULL, 0x000000090e097207ULL, 0x000fe40006800000ULL,
0x000000ff0b7b7207ULL, 0x000fe40003000000ULL, 0x0000000d660d7217ULL, 0x000fe40003800000ULL,
0x0000000c0e0b7207ULL, 0x000fc40006800000ULL, 0x0000000966097217ULL, 0x000fe40003800000ULL,
0x0000000110101810ULL, 0x000fe40007ffe0ffULL, 0x000000690800720cULL, 0x000fe20003f06070ULL,
0x0000000960927224ULL, 0x000fe200078e02ffULL, 0x00000004ff0d7819ULL, 0x000fe4000001160dULL,
0x0000000b660f7217ULL, 0x000fe40003800000ULL, 0x0000000111113810ULL, 0x000fc40007ffe0ffULL,
0x0000000110104810ULL, 0x000fe20007ffe0ffULL, 0x0000000f60947224ULL, 0x000fe200078e02ffULL,
0x000000ff0d0b7207ULL, 0x000fe40000000000ULL, 0x0000000111112810ULL, 0x000fe40007ffe0ffULL,
0x000000100e0f7207ULL, 0x000fe20006800000ULL, 0x000000010b0d7824ULL, 0x000fe200078e0294ULL,
0x000000927b717211ULL, 0x000fe200078fe0ffULL, 0x0000000192097824ULL, 0x000fe200078e020bULL,
0x000000110e117207ULL, 0x000fe20006800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e0002ULL,
0x0000000f660f7217ULL, 0x000fc40003800000ULL, 0x000000106c787812ULL, 0x000fe200078efcffULL,
0x0000000271707825ULL, 0x100fe200078e0002ULL, 0x0000001166117217ULL, 0x000fe20003800000ULL,
0x000000060c6f7981ULL, 0x0046a4000c1e9500ULL, 0x0000000209087825ULL, 0x000fe400078e0002ULL,
0x0000000670707981ULL, 0x0002a4000c1e9500ULL, 0x0000000f60967224ULL, 0x040fe400078e02ffULL,
0x00000006086d7981ULL, 0x0002a2000c1e9500ULL, 0x0000001160987224ULL, 0x000fc400078e02ffULL,
0x00000001650c7824ULL, 0x008fe200078e0278ULL, 0x000000967b757211ULL, 0x000fe200078fe0ffULL,
0x000000010b117824ULL, 0x000fe200078e0296ULL, 0x000000947b0f7211ULL, 0x040fe200078fe0ffULL,
0x000000010c0d7824ULL, 0x000fe200078e0a69ULL, 0x000000987b137211ULL, 0x000fe200078fe0ffULL,
0x000000010b737824ULL, 0x000fe400078e0298ULL, 0x0000000275747825ULL, 0x000fe200078e0002ULL,
0x0000000d66127217ULL, 0x000fc60003800000ULL, 0x000000020f0a7825ULL, 0x000fc800078e0002ULL,
0x0000000211087825ULL, 0x102fe200078e0002ULL, 0x000000060a727981ULL, 0x0002e2000c1e9500ULL,
0x000000690c00720cULL, 0x080fe40003f26070ULL, 0x00000002130e7825ULL, 0x000fe200078e0002ULL,
0x0000000608717981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff127819ULL, 0x000fe40000011612ULL,
0x0000000178767824ULL, 0x000fe200078e0219ULL, 0x0000000674747981ULL, 0x0002e6000c1e9500ULL,
0x00000001760d7824ULL, 0x040fe200078e0a69ULL, 0x000000060e7a7981ULL, 0x0002e2000c1e9500ULL,
0x000000697600720cULL, 0x000fe20003f06070ULL, 0x0000000273107825ULL, 0x000fc400078e0002ULL,
0x0000000d660d7217ULL, 0x000fe40003800000ULL, 0x000000206c827812ULL, 0x000fe200078efcffULL,
0x0000000610737981ULL, 0x0002e4000c1e9500ULL, 0x000000ff120f7207ULL, 0x002fe40000800000ULL,
0x000000ff0d817207ULL, 0x000fc60000000000ULL, 0x000000010f0b7824ULL, 0x000fe200078e0294ULL,
0x00000092817d7211ULL, 0x000fc600078fe0ffULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x00000094817f7211ULL, 0x000fc600078fe0ffULL, 0x0000000192097824ULL, 0x000fe200078e020fULL,
0x000000060a777981ULL, 0x0002e2000c1e9500ULL, 0x000000027d7c7825ULL, 0x000fc800078e0002ULL,
0x000000027f7e7825ULL, 0x000fe200078e0002ULL, 0x00000096810d7211ULL, 0x000fe200078fe0ffULL,
0x000000067c7c7981ULL, 0x0002e4000c1e9500ULL, 0x00000001650a7824ULL, 0x002fe200078e0282ULL,
0x0000009881877211ULL, 0x000fe200078fe0ffULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000067e7e7981ULL, 0x0002e6000c1e9500ULL, 0x000000010a0b7824ULL, 0x000fe200078e0a69ULL,
0x0000000608757981ULL, 0x0002e2000c1e9500ULL, 0x0000000182847824ULL, 0x000fc600078e0219ULL,
0x0000000b66107217ULL, 0x000fe20003800000ULL, 0x00000001840b7824ULL, 0x000fe400078e0a69ULL,
0x000000010f117824ULL, 0x040fe400078e0296ULL, 0x000000010f137824ULL, 0x000fe400078e0298ULL,
0x000000020d0c7825ULL, 0x000fe200078e0002ULL, 0x000000690a00720cULL, 0x080fe40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000287867825ULL, 0x100fe200078e0002ULL,
0x000000698400720cULL, 0x000fe20003f06070ULL, 0x000000060c807981ULL, 0x0002e2000c1e9500ULL,
0x0000000b660b7217ULL, 0x000fe20003800000ULL, 0x00000002110e7825ULL, 0x000fc400078e0002ULL,
0x0000000686867981ULL, 0x0002e4000c1e9500ULL, 0x0000000213087825ULL, 0x002fe400078e0002ULL,
0x000000060e797981ULL, 0x0002e2000c1e9500ULL, 0x000000ff100d7207ULL, 0x000fc60000800000ULL,
0x00000006087d7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff0b877207ULL, 0x000fe20000000000ULL,
0x000000010d897824ULL, 0x000fc600078e0294ULL, 0x0000009487117211ULL, 0x040fe200078fe0ffULL,
0x0000000192097824ULL, 0x002fe200078e020dULL, 0x0000009887837211ULL, 0x000fe200078fe0ffULL,
0x0000000289887825ULL, 0x000fe200078e0002ULL, 0x0000009287137211ULL, 0x000fc600078fe0ffULL,
0x0000000209087825ULL, 0x100fe200078e0002ULL, 0x000000306c8c7812ULL, 0x000fe200078efcffULL,
0x0000000688887981ULL, 0x0002e4000c1e9500ULL, 0x0000000211107825ULL, 0x100fe400078e0002ULL,
0x00000006087f7981ULL, 0x0002e4000c1e9500ULL, 0x0000000213127825ULL, 0x000fe200078e0002ULL,
0x00000096870b7211ULL, 0x000fc600078fe0ffULL, 0x000000010d0f7824ULL, 0x000fe200078e0296ULL,
0x00000006128a7981ULL, 0x0002e4000c1e9500ULL, 0x0000000283087825ULL, 0x002fe400078e0002ULL,
0x0000000610837981ULL, 0x0002e4000c1e9500ULL, 0x000000010d857824ULL, 0x000fe400078e0298ULL,
0x000000020b0c7825ULL, 0x000fe200078e0002ULL, 0x0000000608dc7981ULL, 0x0002e6000c1e9500ULL,
0x0000000165127824ULL, 0x000fe200078e028cULL, 0x000000060c907981ULL, 0x0002e2000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fc800078e0002ULL, 0x00000002850a7825ULL, 0x000fe400078e0002ULL,
0x000000060e857981ULL, 0x0002e4000c1e9500ULL, 0x0000000112137824ULL, 0x000fe400078e0a69ULL,
0x000000018c8e7824ULL, 0x000fe200078e0219ULL, 0x000000060a957981ULL, 0x0002e4000c1e9500ULL,
0x0000001366897217ULL, 0x000fe20003800000ULL, 0x000000018e137824ULL, 0x000fe200078e0a69ULL,
0x000000691200720cULL, 0x000fc40003f26070ULL, 0x00000004ff897819ULL, 0x000fe40000011689ULL,
0x000000698e00720cULL, 0x000fe40003f06070ULL, 0x0000001366137217ULL, 0x000fe40003800000ULL,
0x000000ff898b7207ULL, 0x000fe40000800000ULL, 0x000000ff13897207ULL, 0x000fc60000000000ULL,
0x0000000192117824ULL, 0x002fe200078e028bULL, 0x0000009289137211ULL, 0x000fe200078fe0ffULL,
0x000000018b0d7824ULL, 0x000fe200078e0296ULL, 0x00000096890f7211ULL, 0x000fe200078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0002ULL, 0x0000000213127825ULL, 0x100fe200078e0002ULL,
0x00000006108d7981ULL, 0x0002e6000c1e9500ULL, 0x000000020d0c7825ULL, 0x100fe200078e0002ULL,
0x0000000612c27981ULL, 0x0002e6000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe200078e0002ULL,
0x000000060c937981ULL, 0x0002e2000c1e9500ULL, 0x00000094890b7211ULL, 0x000fc600078fe0ffULL,
0x000000060eda7981ULL, 0x0002e2000c1e9500ULL, 0x000000018b097824ULL, 0x000fe400078e0294ULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad87981ULL, 0x0002e4000c1e9500ULL, 0x0000009889117211ULL, 0x002fe400078fe0ffULL,
0x0000000608917981ULL, 0x0002e2000c1e9500ULL, 0x000000018b137824ULL, 0x000fe400078e0298ULL,
0x0000000211107825ULL, 0x000fc800078e0002ULL, 0x0000000213127825ULL, 0x000fe200078e0002ULL,
0x0000000610de7981ULL, 0x0002e8000c1e9500ULL, 0x0000000612977981ULL, 0x0002e4000c1e9500ULL,
0xfffffff07b087812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd67424ULL, 0x000fc800078e00ffULL,
0x0000000169097824ULL, 0x000fc800078e0208ULL, 0x000000016e087824ULL, 0x000fe200078e0a09ULL,
0x000000016c927812ULL, 0x000fc800078efcffULL, 0x00000008d6087219ULL, 0x000fe200000006ffULL,
0x00000001920a7824ULL, 0x000fe200078e0219ULL, 0xfffffff0810c7812ULL, 0x000fc600078ec0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0a09ULL, 0x000000086c947812ULL, 0x040fe200078efcffULL,
0x00000001690f7824ULL, 0x000fe200078e020cULL, 0x000000096c967812ULL, 0x000fe400078efcffULL,
0x0000000bd60c7219ULL, 0x000fe200000006ffULL, 0x00000001940e7824ULL, 0x100fe400078e0219ULL,
0x0000000196127824ULL, 0x000fe200078e0219ULL, 0xfffffff087107812ULL, 0x000fe200078ec0ffULL,
0x000000010e0d7824ULL, 0x100fe200078e0a09ULL, 0xfffffff089987812ULL, 0x000fe200078ec0ffULL,
0x0000000112097824ULL, 0x000fe200078e0a09ULL, 0x000000116c9c7812ULL, 0x000fe200078efcffULL,
0x0000000169117824ULL, 0x040fe200078e0210ULL, 0x0000000dd6107219ULL, 0x040fe200000006ffULL,
0x0000000169877824ULL, 0x000fe200078e0298ULL, 0x00000009d6987219ULL, 0x000fe200000006ffULL,
0x000000019c9e7824ULL, 0x000fc400078e0219ULL, 0x0000000176097824ULL, 0x100fe400078e0a0fULL,
0x000000019e0b7824ULL, 0x000fe200078e0a0fULL, 0x000000186ca27812ULL, 0x000fe400078efcffULL,
0x00005410706d7816ULL, 0x004fc8000000006dULL, 0x0000006d08ff7212ULL, 0x000fc800078ac0ffULL,
0x000000696e00720cULL, 0x000fc80002fa1470ULL, 0x000000696c00720cULL, 0x000fe40002fa1070ULL,
0x0000006d0cff7212ULL, 0x000fe4000782c0ffULL, 0xff8000006b6b7808ULL, 0x000fe40002800000ULL,
0x00005410726f7816ULL, 0x008fc8000000006fULL, 0x0000006f08ff7212ULL, 0x080fe4000784c0ffULL,
0x0000541074717816ULL, 0x000fe40000000071ULL, 0x0000006f0cff7212ULL, 0x000fe400078ac0ffULL,
0x0000007108ff7212ULL, 0x000fe4000788c0ffULL, 0x000000696e00720cULL, 0x0c0fe40001741470ULL,
0x000000696e00720cULL, 0x000fc40002781470ULL, 0x000000690a00720cULL, 0x0c0fe40000f21470ULL,
0x000000690a00720cULL, 0x080fe40002fa1470ULL, 0x000000696c00720cULL, 0x0c0fe40001741070ULL,
0x000000696c00720cULL, 0x080fe40002781070ULL, 0x000000699200720cULL, 0x0c0fe40000f21070ULL,
0x000000699200720cULL, 0x000fc40002fa1070ULL, 0x000054107a737816ULL, 0x000fe40000000073ULL,
0xff8000002e2e7808ULL, 0x000fe40001000000ULL, 0xff80000039397808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fe40002800000ULL,
0x0000006d10ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007308ff7212ULL, 0x000fe4000780c0ffULL,
0x000000710cff7212ULL, 0x040fe4000784c0ffULL, 0x000000730cff7212ULL, 0x000fe4000788c0ffULL,
0x0000006f98ff7212ULL, 0x000fe4000782c0ffULL, 0x0000007110ff7212ULL, 0x000fe400078ac0ffULL,
0x000000696e00720cULL, 0x000fc40000701470ULL, 0x000000690a00720cULL, 0x0c0fe40001741470ULL,
0x000000690a00720cULL, 0x080fe40002781470ULL, 0x000000690e00720cULL, 0x0c0fe40001f61470ULL,
0x000000690e00720cULL, 0x080fe40002fa1470ULL, 0x000000691200720cULL, 0x000fe40000f21470ULL,
0x000000196ca87812ULL, 0x000fc400078efcffULL, 0x000000696c00720cULL, 0x080fe40000701070ULL,
0x000000699200720cULL, 0x0c0fe40001741070ULL, 0x000000699200720cULL, 0x080fe40002781070ULL,
0x000000699400720cULL, 0x0c0fe40001f61070ULL, 0x000000699400720cULL, 0x080fe40002fa1070ULL,
0x000000699600720cULL, 0x000fc40000f21070ULL, 0x00000009d69a7219ULL, 0x040fe400000006ffULL,
0x0000000bd6a07219ULL, 0x000fe400000006ffULL, 0x000054107c757816ULL, 0x000fe40000000075ULL,
0x000054107e777816ULL, 0x000fe20000000077ULL, 0x00000001a2a47824ULL, 0x100fe200078e0219ULL,
0xff80000028287808ULL, 0x000fe20000000000ULL, 0x00000001a8aa7824ULL, 0x000fe200078e0219ULL,
0xff80000038387808ULL, 0x000fc40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff8000006a6a7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0x0000006f10ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007198ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007310ff7212ULL, 0x080fe4000788c0ffULL,
0x0000007398ff7212ULL, 0x000fe4000786c0ffULL, 0x00000075a0ff7212ULL, 0x000fe400078ac0ffULL,
0x000000779aff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a40d7824ULL, 0x100fe200078e0a0fULL,
0x000000690e00720cULL, 0x080fe20000701470ULL, 0x00000001aa0f7824ULL, 0x000fe200078e0a0fULL,
0x000000690e00720cULL, 0x000fc40002781470ULL, 0x000000691200720cULL, 0x0c0fe40001741470ULL,
0x000000691200720cULL, 0x080fe40001f61470ULL, 0x000000697600720cULL, 0x080fe40000f21470ULL,
0x000000699e00720cULL, 0x080fe40002fa1470ULL, 0x000000699400720cULL, 0x0c0fe40000701070ULL,
0x000000699400720cULL, 0x000fc40002781070ULL, 0x000000699600720cULL, 0x0c0fe40001741070ULL,
0x000000699600720cULL, 0x080fe40001f61070ULL, 0x000000697800720cULL, 0x080fe40000f21070ULL,
0x000000699c00720cULL, 0x000fe40002fa1070ULL, 0x0000000dd6a67219ULL, 0x040fe400000006ffULL,
0x0000000fd6ac7219ULL, 0x000fc400000006ffULL, 0x0000541080797816ULL, 0x000fe40000000079ULL,
0x00005410867d7816ULL, 0x000fe4000000007dULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fc40001800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x000000759aff7212ULL, 0x080fe4000780c0ffULL,
0x00000075a6ff7212ULL, 0x000fe4000788c0ffULL, 0x000000799aff7212ULL, 0x040fe4000784c0ffULL,
0x0000007d9aff7212ULL, 0x000fc4000786c0ffULL, 0x00000079a0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000077acff7212ULL, 0x000fe200078ac0ffULL, 0x0000000184137824ULL, 0x000fe200078e0a11ULL,
0x000000697600720cULL, 0x0c0fe40000701470ULL, 0x000000697600720cULL, 0x0c0fe40001741470ULL,
0x000000697600720cULL, 0x080fe40001f61470ULL, 0x000000699e00720cULL, 0x000fc40000f21470ULL,
0x00000069a400720cULL, 0x080fe40002781470ULL, 0x00000069aa00720cULL, 0x080fe40002fa1470ULL,
0x000000216cb07812ULL, 0x000fe400078efcffULL, 0x000000697800720cULL, 0x0c0fe40000701070ULL,
0x000000697800720cULL, 0x0c0fe40001741070ULL, 0x000000697800720cULL, 0x000fc40001f61070ULL,
0x000000699c00720cULL, 0x080fe40000f21070ULL, 0x00000069a200720cULL, 0x080fe40002781070ULL,
0x00000069a800720cULL, 0x000fe40002fa1070ULL, 0x00000013d6ae7219ULL, 0x000fe400000006ffULL,
0x0000541083837816ULL, 0x000fe20000000088ULL, 0x00000001b0b27824ULL, 0x000fe200078e0219ULL,
0xff8000005b5b7808ULL, 0x000fc40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x00000077a0ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007da0ff7212ULL, 0x000fe4000784c0ffULL,
0x00000077a6ff7212ULL, 0x000fe4000786c0ffULL, 0x00000079acff7212ULL, 0x040fe4000782c0ffULL,
0x0000007dacff7212ULL, 0x000fe4000788c0ffULL, 0x00000083aeff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b27b7824ULL, 0x000fe200078e0a11ULL, 0x000000699e00720cULL, 0x000fc40000701470ULL,
0x000000699e00720cULL, 0x080fe40001741470ULL, 0x00000069a400720cULL, 0x080fe40001f61470ULL,
0x00000069aa00720cULL, 0x0c0fe40000f21470ULL, 0x00000069aa00720cULL, 0x080fe40002781470ULL,
0x000000698400720cULL, 0x000fe40002fa1470ULL, 0x000000286cb67812ULL, 0x000fc400078efcffULL,
0x000000296cbc7812ULL, 0x000fe400078efcffULL, 0x000000699c00720cULL, 0x0c0fe40000701070ULL,
0x000000699c00720cULL, 0x080fe40001741070ULL, 0x00000069a200720cULL, 0x080fe40001f61070ULL,
0x00000069a800720cULL, 0x0c0fe40000f21070ULL, 0x00000069a800720cULL, 0x000fc40002781070ULL,
0x000000698200720cULL, 0x000fe40002fa1070ULL, 0x0000007bd6b47219ULL, 0x000fe400000006ffULL,
0x000054108a7f7816ULL, 0x000fe4000000007fULL, 0x0000541090857816ULL, 0x000fe40000000085ULL,
0x00005410dc957816ULL, 0x000fe20000000095ULL, 0x00000001b6b87824ULL, 0x100fe200078e0219ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x00000001bcbe7824ULL, 0x000fe200078e0219ULL,
0xff8000002d2d7808ULL, 0x000fc40001000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000006d98ff7212ULL, 0x000fe400078cc0ffULL,
0x00000079a6ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007da6ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007faeff7212ULL, 0x040fe4000786c0ffULL, 0x00000085aeff7212ULL, 0x040fe4000782c0ffULL,
0x00000095aeff7212ULL, 0x000fe4000788c0ffULL, 0x00000085b4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b8817824ULL, 0x100fe200078e0a11ULL, 0x000000691200720cULL, 0x080fe200037c1470ULL,
0x00000001be117824ULL, 0x000fe200078e0a11ULL, 0x00000069a400720cULL, 0x000fc40000701470ULL,
0x00000069a400720cULL, 0x080fe40001741470ULL, 0x000000698400720cULL, 0x0c0fe40001f61470ULL,
0x000000698400720cULL, 0x0c0fe40000f21470ULL, 0x000000698400720cULL, 0x080fe40002781470ULL,
0x00000069b200720cULL, 0x080fe40002fa1470ULL, 0x000000699600720cULL, 0x000fc400037c1070ULL,
0x00000069a200720cULL, 0x0c0fe40000701070ULL, 0x00000069a200720cULL, 0x080fe40001741070ULL,
0x000000698200720cULL, 0x0c0fe40001f61070ULL, 0x000000698200720cULL, 0x0c0fe40000f21070ULL,
0x000000698200720cULL, 0x080fe40002781070ULL, 0x00000069b000720cULL, 0x000fc40002fa1070ULL,
0x00000081d6ba7219ULL, 0x040fe400000006ffULL, 0x00000011d6c07219ULL, 0x000fe400000006ffULL,
0xff80000056567808ULL, 0x000fe40003000000ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fc40001800000ULL,
0xff80000040407808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x00000075acff7212ULL, 0x000fe400078cc0ffULL,
0x0000007fb4ff7212ULL, 0x080fe4000780c0ffULL, 0x0000007fbaff7212ULL, 0x000fc4000784c0ffULL,
0x00000083b4ff7212ULL, 0x040fe4000786c0ffULL, 0x00000095b4ff7212ULL, 0x000fe4000782c0ffULL,
0x00000083baff7212ULL, 0x000fe4000788c0ffULL, 0x00000085c0ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018e897824ULL, 0x000fe200078e0a87ULL, 0x00000069aa00720cULL, 0x080fe400037c1470ULL,
0x00000069b200720cULL, 0x000fc40000701470ULL, 0x00000069b200720cULL, 0x0c0fe40001f61470ULL,
0x00000069b200720cULL, 0x080fe40000f21470ULL, 0x00000069b800720cULL, 0x0c0fe40001741470ULL,
0x00000069b800720cULL, 0x080fe40002781470ULL, 0x00000069be00720cULL, 0x000fe40002fa1470ULL,
0x000000316cc67812ULL, 0x000fc400078efcffULL, 0x000000386ccc7812ULL, 0x040fe400078efcffULL,
0x000000396cd27812ULL, 0x000fe400078efcffULL, 0x00000069a800720cULL, 0x080fe400037c1070ULL,
0x00000069b000720cULL, 0x0c0fe40000701070ULL, 0x00000069b000720cULL, 0x0c0fe40001f61070ULL,
0x00000069b000720cULL, 0x000fc40000f21070ULL, 0x00000069b600720cULL, 0x0c0fe40001741070ULL,
0x00000069b600720cULL, 0x080fe40002781070ULL, 0x00000069bc00720cULL, 0x000fe40002fa1070ULL,
0x00000089d6c47219ULL, 0x000fe400000006ffULL, 0x00005410c28d7816ULL, 0x000fe4000000008dULL,
0x00005410da937816ULL, 0x000fe20000000093ULL, 0x00000001c6c87824ULL, 0x100fe200078e0219ULL,
0xff80000058587808ULL, 0x000fe20003000000ULL, 0x00000001ccce7824ULL, 0x100fe200078e0219ULL,
0xff80000054547808ULL, 0x000fe20000000000ULL, 0x00000001d2d47824ULL, 0x000fe200078e0219ULL,
0xff80000048487808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000043437808ULL, 0x000fe40002800000ULL, 0x0000007fc0ff7212ULL, 0x040fe400078cc0ffULL,
0x00000083c0ff7212ULL, 0x000fc4000780c0ffULL, 0x00000085baff7212ULL, 0x040fe4000786c0ffULL,
0x00000095baff7212ULL, 0x080fe4000782c0ffULL, 0x00000095c0ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008dc4ff7212ULL, 0x040fe4000788c0ffULL, 0x00000093c4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c88b7824ULL, 0x100fe200078e0a87ULL, 0x00000069b800720cULL, 0x080fe20001f61470ULL,
0x00000001ce8f7824ULL, 0x100fe200078e0a87ULL, 0x00000069b800720cULL, 0x080fe20000f21470ULL,
0x00000001d4877824ULL, 0x000fe200078e0a87ULL, 0x00000069be00720cULL, 0x000fc400037c1470ULL,
0x00000069be00720cULL, 0x0c0fe40000701470ULL, 0x00000069be00720cULL, 0x080fe40001741470ULL,
0x000000698e00720cULL, 0x0c0fe40002781470ULL, 0x000000698e00720cULL, 0x000fe40002fa1470ULL,
0x0000008bd6ca7219ULL, 0x040fe400000006ffULL, 0x0000008fd6d07219ULL, 0x000fc400000006ffULL,
0x00000069b600720cULL, 0x0c0fe40001f61070ULL, 0x00000069b600720cULL, 0x080fe40000f21070ULL,
0x00000069bc00720cULL, 0x0c0fe400037c1070ULL, 0x00000069bc00720cULL, 0x0c0fe40000701070ULL,
0x00000069bc00720cULL, 0x080fe40001741070ULL, 0x000000698c00720cULL, 0x000fc40002781070ULL,
0x000000698c00720cULL, 0x000fe40002fa1070ULL, 0x00000087d6d67219ULL, 0x000fe400000006ffULL,
0x00005410d8917816ULL, 0x000fe40000000091ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fc40003000000ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000017177808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x0000008dcaff7212ULL, 0x080fe4000786c0ffULL, 0x0000008dd0ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008dd6ff7212ULL, 0x000fe400078cc0ffULL, 0x00000091c4ff7212ULL, 0x080fe4000780c0ffULL,
0x00000091caff7212ULL, 0x080fe4000784c0ffULL, 0x00000091d0ff7212ULL, 0x000fe4000788c0ffULL,
0x00000093caff7212ULL, 0x000fe400078ac0ffULL, 0x000000698e00720cULL, 0x000fc40000701470ULL,
0x00000069c800720cULL, 0x0c0fe40001f61470ULL, 0x00000069c800720cULL, 0x0c0fe40001741470ULL,
0x00000069c800720cULL, 0x080fe40002fa1470ULL, 0x00000069ce00720cULL, 0x080fe40000f21470ULL,
0x00000069d400720cULL, 0x080fe400037c1470ULL, 0x00000069ce00720cULL, 0x000fc40002781470ULL,
0x000000698c00720cULL, 0x080fe40000701070ULL, 0x00000069c600720cULL, 0x0c0fe40001f61070ULL,
0x00000069c600720cULL, 0x0c0fe40001741070ULL, 0x00000069c600720cULL, 0x080fe40002fa1070ULL,
0x00000069cc00720cULL, 0x080fe40000f21070ULL, 0x00000069d200720cULL, 0x000fc400037c1070ULL,
0x00000069cc00720cULL, 0x000fe40002781070ULL, 0x00005410de977816ULL, 0x000fe40000000097ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002000000ULL, 0x00000091d6ff7212ULL, 0x000fe4000780c0ffULL,
0x00000093d0ff7212ULL, 0x080fe4000786c0ffULL, 0x00000093d6ff7212ULL, 0x000fc4000784c0ffULL,
0x00000097c4ff7212ULL, 0x080fe400078ac0ffULL, 0x00000097caff7212ULL, 0x080fe4000782c0ffULL,
0x00000097d0ff7212ULL, 0x080fe400078cc0ffULL, 0x00000097d6ff7212ULL, 0x000fe4000788c0ffULL,
0x000000698e00720cULL, 0x080fe40002fa1470ULL, 0x00000069c800720cULL, 0x000fc40000f21470ULL,
0x00000069ce00720cULL, 0x0c0fe40001f61470ULL, 0x00000069ce00720cULL, 0x080fe400037c1470ULL,
0x00000069d400720cULL, 0x0c0fe40000701470ULL, 0x00000069d400720cULL, 0x0c0fe40001741470ULL,
0x00000069d400720cULL, 0x080fe40002781470ULL, 0x000000698c00720cULL, 0x000fc40002fa1070ULL,
0x00000069c600720cULL, 0x080fe40000f21070ULL, 0x00000069d200720cULL, 0x080fe40000701070ULL,
0x00000069cc00720cULL, 0x0c0fe40001f61070ULL, 0x00000069cc00720cULL, 0x080fe400037c1070ULL,
0x00000069d200720cULL, 0x0c0fe40001741070ULL, 0x00000069d200720cULL, 0x000fc40002781070ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40003000000ULL,
0xff80000023237808ULL, 0x000fc40002000000ULL, 0x0000006b0400720bULL, 0x004fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fe40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280700720bULL, 0x000fe40003f7e000ULL, 0x000000046b047208ULL, 0x000fe40004000000ULL,
0x000000052e087208ULL, 0x000fc40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000728077208ULL, 0x000fe40005800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f3e000ULL,
0x0000002c0700720bULL, 0x000fc40003f7e000ULL, 0x0000000455097208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40005000000ULL, 0x000000084b087208ULL, 0x000fe40004800000ULL,
0x000000072c047208ULL, 0x000fe40005800000ULL, 0x0000006a0900720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fc40003f5e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000270400720bULL, 0x000fe40003f7e000ULL, 0x000000096a097208ULL, 0x000fe40004000000ULL,
0x000000053a067208ULL, 0x000fe40005000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x0000000427047208ULL, 0x000fc40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x0000003b0600720bULL, 0x000fe40003f5e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x000000290400720bULL, 0x000fe40003f7e000ULL, 0x00000009560a7208ULL, 0x000fe40004000000ULL,
0x000000063b077208ULL, 0x000fc40005000000ULL, 0x0000000831057208ULL, 0x000fe40004800000ULL,
0x0000000429097208ULL, 0x000fe40005800000ULL, 0x0000005b0a00720bULL, 0x000fe40003f1e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fc40003f7e000ULL, 0x0000000a5b0a7208ULL, 0x000fe40004000000ULL,
0x000000073c067208ULL, 0x000fe40005000000ULL, 0x0000000530047208ULL, 0x000fe40004800000ULL,
0x000000092a087208ULL, 0x000fe40005800000ULL, 0x000000570a00720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fc40003f5e000ULL, 0x000000470400720bULL, 0x000fe40003f3e000ULL,
0x0000002d0800720bULL, 0x000fe40003f7e000ULL, 0x0000000a57057208ULL, 0x000fe40004000000ULL,
0x000000063d097208ULL, 0x000fe40005000000ULL, 0x0000000447077208ULL, 0x000fe40004800000ULL,
0x000000082d087208ULL, 0x000fc40005800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0900720bULL, 0x000fe40003f5e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000002b0800720bULL, 0x000fe40003f7e000ULL, 0x000000055a057208ULL, 0x000fe40004000000ULL,
0x000000093e047208ULL, 0x000fc40005000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x000000082b097208ULL, 0x000fe40005800000ULL, 0x000000580500720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x000000260900720bULL, 0x000fc40003f7e000ULL, 0x0000000558067208ULL, 0x000fe40004000000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000000734087208ULL, 0x000fe40004800000ULL,
0x0000000926047208ULL, 0x000fe40005800000ULL, 0x000000590600720bULL, 0x000fe40003f1e000ULL,
0x000000400500720bULL, 0x000fc40003f5e000ULL, 0x000000330800720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f7e000ULL, 0x0000000659077208ULL, 0x000fe40004000000ULL,
0x0000000540067208ULL, 0x000fe40005000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x0000000425057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x000000480900720bULL, 0x000fe40003f3e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754047208ULL, 0x000fe40004000000ULL,
0x0000000948087208ULL, 0x000fc40004800000ULL, 0x0000000641077208ULL, 0x000fe40005000000ULL,
0x0000000524057208ULL, 0x000fe40005800000ULL, 0x000000530400720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x000000420700720bULL, 0x000fe40003f5e000ULL,
0x000000160500720bULL, 0x000fc40003f7e000ULL, 0x0000000453097208ULL, 0x000fe40004000000ULL,
0x00000008350b7208ULL, 0x000fe40004800000ULL, 0x0000000742047208ULL, 0x000fe40005000000ULL,
0x0000000516067208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fc40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x000000170600720bULL, 0x000fe40003f7e000ULL, 0x0000000952087208ULL, 0x000fe40004000000ULL,
0x0000000b440b7208ULL, 0x000fe40004800000ULL, 0x0000000443047208ULL, 0x000fe40005000000ULL,
0x0000000617057208ULL, 0x000fc40005800000ULL, 0x000000510800720bULL, 0x000fe40003f1e000ULL,
0x000000360b00720bULL, 0x000fe40003f3e000ULL, 0x0000004d0400720bULL, 0x000fe40003f5e000ULL,
0x000000200500720bULL, 0x000fe40003f7e000ULL, 0x0000000851077208ULL, 0x000fe40004000000ULL,
0x0000000b36067208ULL, 0x000fc40004800000ULL, 0x000000044d047208ULL, 0x000fe40005000000ULL,
0x0000000520087208ULL, 0x000fe40005800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000370600720bULL, 0x000fe40003f3e000ULL, 0x000000450400720bULL, 0x000fe40003f5e000ULL,
0x000000210800720bULL, 0x000fc40003f7e000ULL, 0x00000007500a7208ULL, 0x000fe40004000000ULL,
0x0000000637057208ULL, 0x000fe40004800000ULL, 0x0000000445077208ULL, 0x000fe40005000000ULL,
0x0000000821097208ULL, 0x000fe40005800000ULL, 0x0000004f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004c0500720bULL, 0x000fc40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f5e000ULL,
0x000000220900720bULL, 0x000fe40003f7e000ULL, 0x0000000a4f0b7208ULL, 0x000fe40004000000ULL,
0x000000054c057208ULL, 0x000fe40004800000ULL, 0x0000000746047208ULL, 0x000fe40005000000ULL,
0x0000000922067208ULL, 0x000fc40005800000ULL, 0x0000004e0b00720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fe40003f3e000ULL, 0x000000490400720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000b4e077208ULL, 0x000fe40004000000ULL,
0x000000054a0a7208ULL, 0x000fc40004800000ULL, 0x00000004490e7208ULL, 0x000fe40005000000ULL,
0x00000006230d7208ULL, 0x000fe20005800000ULL, 0x000024727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x00000007040f7208ULL, 0x000fe20004000000ULL, 0x000024a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e057f89ULL, 0x000e6800000e0000ULL,
0x0c401f000d067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000050e00720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000000e05087208ULL, 0x000fe20004800000ULL, 0x0c201f000f047f89ULL, 0x000e6200000e0000ULL,
0x000000060d00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL,
0x0000000d060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000040f00720bULL, 0x002fe40003f1e000ULL,
0x0000000c0700720bULL, 0x004fe40003f3e000ULL, 0x0000000f04047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x000000070c057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b060e7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b6b6b7823ULL, 0x000fc40000010807ULL,
0x0000005500097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b6a6a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b56567823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL, 0x0000006b00087308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b58587823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b59557823ULL, 0x102fe40000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL,
0x0000006a006a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b53537823ULL, 0x000fe20000010807ULL,
0x00000002ff6b7819ULL, 0x004fe2000001165fULL, 0x3fb8aa3b52527823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x00000056000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x000000080908723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b4e4e7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe40000410000ULL, 0x000000086b117824ULL, 0x000fe200078e00ffULL,
0x0000005800697308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x0000004b004b7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b35357823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4a077823ULL, 0x000fe20000010807ULL,
0x00000031000c7308ULL, 0x000ea20000000800ULL, 0x000000086b707824ULL, 0x000fe200078e00ffULL,
0x0000002e4b09723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b39397823ULL, 0x000fc4000001080eULL,
0x3fb8aa3b38387823ULL, 0x100fe4000001080eULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080eULL,
0x0000000700597308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe4000001080eULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe4000001080eULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe4000001080eULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080eULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000000a0b077208ULL, 0x002fe20004000000ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080eULL,
0x000000016b0a7810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b40407823ULL, 0x000fe2000001080eULL,
0x000000026b0b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b07567820ULL, 0x000fe20000410000ULL,
0xfffffff8116e7812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b41417823ULL, 0x000fe2000001080eULL,
0xfffffff870707812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL,
0x000000046b0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010856ULL,
0x000000056b0b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001080eULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x3fb8aa3b43437823ULL, 0x000fe2000001080eULL,
0xfffffff811747812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080eULL,
0x0000006a0d0a723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL,
0x000000035fff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b46467823ULL, 0x000fe2000001080eULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fc40000010856ULL,
0x3fb8aa3b490e7823ULL, 0x000fe4000001080eULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010856ULL,
0x000000086b767824ULL, 0x040fe200078e00ffULL, 0x0000002c000f7308ULL, 0x000ee20000000800ULL,
0x000000086b137824ULL, 0x040fe400078e00ffULL, 0x000000086b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL,
0x0000002f0c0b723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010856ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0xffffffff6b0c7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc40000010856ULL, 0x3fb8aa3b26267823ULL, 0x000fe20000010856ULL,
0xfffffff80d6a7812ULL, 0x000fe200078ee20cULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL,
0x00000039380c723eULL, 0x002fe200000000ffULL, 0x0000003b003b7308ULL, 0x000e620000000800ULL,
0x000000280f0d723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010856ULL,
0x3fb8aa3b20387823ULL, 0x100fe40000010856ULL, 0x3fb8aa3b214b7823ULL, 0x000fc40000010856ULL,
0x0000000e00497308ULL, 0x0005f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000036b0e7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff813727812ULL, 0x000fe400078ee20eULL,
0x000000066b0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000002900587308ULL, 0x000ea60000000800ULL,
0xfffffff813787812ULL, 0x000fe400078ee20eULL, 0x0000003a3b0e723eULL, 0x002fc600000000ffULL,
0x00000057006c7308ULL, 0x000ff00000000800ULL, 0x0000003400577308ULL, 0x0003e20000000800ULL,
0x00000027580f723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b16277823ULL, 0x000fc40000010856ULL,
0x3fb8aa3b22587823ULL, 0x000fc80000010856ULL, 0x0000003500317308ULL, 0x0005e20000000800ULL,
0x3c003c00ff347424ULL, 0x002fce00078e00ffULL, 0x0000005b005b7308ULL, 0x000e620000000800ULL,
0x3c003c00ff357424ULL, 0x004fce00078e00ffULL, 0x000000340810723cULL, 0x000f6200000018ffULL,
0x0000005a005a7308ULL, 0x000ea20000000800ULL, 0x0000005b6c20723eULL, 0x002fce00000000ffULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000106b6c7810ULL, 0x000fca0007ffe0ffULL,
0x000000086c2f7824ULL, 0x000fe400078e00ffULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x0000005a6922723eULL, 0x004fe400000000ffULL, 0x000000086b5a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f6c7812ULL, 0x000fc600078ee26cULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x00000045004a7308ULL, 0x000fe20000000800ULL, 0x000000304721723eULL, 0x002fce00000000ffULL,
0x0000002a002c7308ULL, 0x000ff00000000800ULL, 0x0000002b00457308ULL, 0x0003f00000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000340c28723cULL, 0x002f6e00000018ffULL,
0x0000003d003d7308ULL, 0x000e700000000800ULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000eb00000000800ULL,
0x00000026002e7308ULL, 0x0007f00000000800ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24267823ULL, 0x108fe20000010856ULL, 0x0000003c3d24723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b23567823ULL, 0x000fe20000010856ULL, 0x000000325723723eULL, 0x000fc800000000ffULL,
0x0000005400547308ULL, 0x000e660000000800ULL, 0x000000342010723cULL, 0x020f6a0000001810ULL,
0x0000005300537308ULL, 0x000ff00000000800ULL, 0x0000005200527308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000004800487308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000ef00000000800ULL, 0x0000002500397308ULL, 0x0005f00000000800ULL,
0x0000002600167308ULL, 0x0006e20000000800ULL, 0x0000002c2d25723eULL, 0x004fe200000000ffULL,
0x000000085a2d7824ULL, 0x000fe200078e00ffULL, 0x00000055542c723eULL, 0x002fc400000000ffULL,
0x00000031442f723eULL, 0x008fe400000000ffULL, 0xfffffff82d5a7812ULL, 0x000fe200078ee25aULL,
0x00000027003b7308ULL, 0x0003e20000000800ULL, 0x0000003e3f26723eULL, 0x000fe200000000ffULL,
0x000000086b3e7824ULL, 0x000fe200078e00ffULL, 0x00000033482d723eULL, 0x000fc800000000ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee26bULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x000000452e27723eULL, 0x002fe400000000ffULL, 0x00000053522e723eULL, 0x000fe400000000ffULL,
0x000000391639723eULL, 0x000fe400000000ffULL, 0x000000186b6b7810ULL, 0x000fe20007ffe0ffULL,
0x000000342428723cULL, 0x000f620000001828ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000086b7a7824ULL, 0x000fc800078e00ffULL, 0x000000342c10723cULL, 0x020f620000001810ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0xfffffff87a7a7812ULL, 0x000fce00078ee26bULL,
0x0000004300437308ULL, 0x000e700000000800ULL, 0x00000017003c7308ULL, 0x0004f00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000042433a723eULL, 0x002fc400000000ffULL,
0x000120001f177811ULL, 0x004fca00078e60ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000003b3c3b723eULL, 0x008fe200000000ffULL, 0x000000103e3e7824ULL, 0x100fe400078e0217ULL,
0x000000106e6e7824ULL, 0x100fe400078e0217ULL, 0x0000001070707824ULL, 0x100fe400078e0217ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000001072727824ULL, 0x100fe400078e0217ULL,
0x0000001074747824ULL, 0x000fc400078e0217ULL, 0x0000001076767824ULL, 0x100fe400078e0217ULL,
0x00000001156e7824ULL, 0x040fe200078e026eULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x000000515030723eULL, 0x002fe200000000ffULL, 0x0000001078787824ULL, 0x100fe400078e0217ULL,
0x0000000115707824ULL, 0x040fe400078e0270ULL, 0x000000106a6a7824ULL, 0x000fe400078e0217ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000000115727824ULL, 0x000fc400078e0272ULL,
0x000000105a5a7824ULL, 0x000fe400078e0217ULL, 0x0000000115747824ULL, 0x040fe400078e0274ULL,
0x0000000115767824ULL, 0x040fe200078e0276ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000004f4e32723eULL, 0x004fe200000000ffULL, 0x0000000115787824ULL, 0x040fe400078e0278ULL,
0x00000001156a7824ULL, 0x040fe400078e026aULL, 0x00000001155a7824ULL, 0x000fc400078e025aULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x000000106c6c7824ULL, 0x100fe400078e0217ULL,
0x000000107a7a7824ULL, 0x000fc800078e0217ULL, 0x00000001157a7824ULL, 0x000fe200078e027aULL,
0x00000038003d7308ULL, 0x0007e20000000800ULL, 0x000000363731723eULL, 0x002fe200000000ffULL,
0x000000013e377824ULL, 0x000fca00078e0215ULL, 0x0000000837007388ULL, 0x000fe20000000800ULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x000000404138723eULL, 0x008fe400000000ffULL,
0x0000004c5933723eULL, 0x004fe200000000ffULL, 0x0000000a6e007388ULL, 0x000fe80000000800ULL,
0x000000343828723cULL, 0x080fe20000001828ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x0000002070007388ULL, 0x000fe80000000800ULL, 0x0000002272007388ULL, 0x000fe40000000800ULL,
0x000000343010723cULL, 0x020f620000001810ULL, 0x0000004b00507308ULL, 0x000ee20000000800ULL,
0x0000004d4a3c723eULL, 0x002fe200000000ffULL, 0x0000002c74007388ULL, 0x000fe80000000800ULL,
0x0000002e76007388ULL, 0x000fe40000000800ULL, 0x00000058003f7308ULL, 0x000fe20000000800ULL,
0x00000046493e723eULL, 0x004fe200000000ffULL, 0x0000003078007388ULL, 0x000fe80000000800ULL,
0x000000326a007388ULL, 0x000fe40000000800ULL, 0x0000005600567308ULL, 0x000e620000000800ULL,
0x0000003d503d723eULL, 0x008fe200000000ffULL, 0x000000095a007388ULL, 0x000fe20000000800ULL,
0x0000000115117824ULL, 0x020fc600078e026cULL, 0x0004000b6e007388ULL, 0x000fe80000000800ULL,
0x0004002170007388ULL, 0x000fe80000000800ULL, 0x0004002372007388ULL, 0x000fe20000000800ULL,
0x0000003f563f723eULL, 0x002fc600000000ffULL, 0x0004002d74007388ULL, 0x000fe80000000800ULL,
0x0004002f76007388ULL, 0x000fe20000000800ULL, 0x000000343c28723cULL, 0x000f660000001828ULL,
0x0004003178007388ULL, 0x000fe80000000800ULL, 0x000400336a007388ULL, 0x000fe80000000800ULL,
0x0000000c11007388ULL, 0x0003e80000000800ULL, 0x0008000e6e007388ULL, 0x0005e80000000800ULL,
0x0008002470007388ULL, 0x0005e20000000800ULL, 0x000000ffff117224ULL, 0x002fc600078e0012ULL,
0x0008002672007388ULL, 0x0005e20000000800ULL, 0x000000ffff127224ULL, 0x020fe400078e0028ULL,
0x000000ffff137224ULL, 0x000fe200078e002aULL, 0x0008003874007388ULL, 0x0005e80000000800ULL,
0x0008003a76007388ULL, 0x0005e80000000800ULL, 0x0008003c78007388ULL, 0x0005e80000000800ULL,
0x0008003e6a007388ULL, 0x0005e80000000800ULL, 0x0000000d7a007388ULL, 0x0005e80000000800ULL,
0x000c000f6e007388ULL, 0x0005e80000000800ULL, 0x000c002570007388ULL, 0x0005e80000000800ULL,
0x000c002772007388ULL, 0x0005e80000000800ULL, 0x000c003974007388ULL, 0x0005e80000000800ULL,
0x000c003b76007388ULL, 0x0005e80000000800ULL, 0x000c003d78007388ULL, 0x0005e80000000800ULL,
0x000c003f6a007388ULL, 0x0005e80000000800ULL, 0x01a0000414008388ULL, 0x0005e80000000c00ULL,
0x01a2001014008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080064ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100064ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000163637810ULL, 0x000fe20007ffe0ffULL, 0x0000180064ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff6a7224ULL, 0x004fc400078e0062ULL, 0x0000001a6300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff8c3000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001843000297802ULL, 0x000fc40000000f00ULL,
0x000015f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xfffea83000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001849000297802ULL, 0x000fc40000000f00ULL,
0x0000159000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xfffea86000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001850000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000014d000007944ULL, 0x014fea0003c00000ULL,
0xfffea91000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001856000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000147000007944ULL, 0x016fea0003c00000ULL,
0xfffeaa2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x000185c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000141000007944ULL, 0x01efea0003c00000ULL,
0xfffeab3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001862000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x01efea0003c00000ULL,
0xfffeac3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001869000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffeb03000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001870000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000012d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001003297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001877000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000126000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffeafa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x000187e000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000011f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffeaf6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001884000297802ULL, 0x000fc40000000f00ULL, 0x000011e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0xfffed0e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000188a000297802ULL, 0x000fc40000000f00ULL, 0x0000118000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff787224ULL, 0x000fe200078e0028ULL, 0xfffed11000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x0001891000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000010c000007944ULL, 0x004fea0003c00000ULL, 0xfffed1d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x0001897000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000106000007944ULL, 0x006fea0003c00000ULL, 0xfffed2e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x000189d000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x00efea0003c00000ULL, 0xfffed3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x00018a3000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x00efea0003c00000ULL, 0xfffed4f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00018aa000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0025ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000f3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffed8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00018b1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00018b8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffed86000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00018bf000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000de000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffed82000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00018c5000297802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0028ULL,
0xfffef7a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00018cb000297802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0028ULL,
0xfffef7e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x00018d2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000cb000007944ULL, 0x018fea0003c00000ULL,
0xfffef8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x00018d8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x01afea0003c00000ULL,
0xfffef9b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x00018de000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000bf000007944ULL, 0x01afea0003c00000ULL,
0xfffefac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x00018e4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b9000007944ULL, 0x01afea0003c00000ULL,
0xfffefbc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00018eb000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0023ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffeffa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00018f2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001023297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00018f9000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000a4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffeff1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001900000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000009d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffefed000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001906000297802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xffff1e2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000190c000297802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xffff1e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001913000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x018fea0003c00000ULL, 0xffff1f1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001919000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x01afea0003c00000ULL, 0xffff202000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x000191f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000007e000007944ULL, 0x01afea0003c00000ULL, 0xffff213000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001925000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x01afea0003c00000ULL, 0xffff223000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x000192c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff263000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001933000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001006297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x000193a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff25a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001941000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff256000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001948000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e000aULL, 0x0001950000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fc400078e00ffULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x010fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x0001958000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000dULL,
0x0001960000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000fULL,
0x0001968000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000d0b0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001970000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000f0b047208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x0001978000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001980000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff107424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd92000007947ULL, 0x000fea000383ffffULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000021027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe667002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001000007348ULL, 0x000fe80003800000ULL, 0x0c00000c070b7389ULL, 0x0002a200000e000bULL,
0xfffe663008007950ULL, 0x000fea0003c3ffffULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a400000e0070ULL, 0x000000ffff2a7224ULL, 0x002fc400078e0028ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffe65e02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f65070ULL, 0x0000002a00007348ULL, 0x000fe80003800000ULL,
0x00000000ff2b7424ULL, 0x000fd000078e00ffULL, 0x0000000000287806ULL, 0x000fc800058e0100ULL,
0x0000002a28287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fc800078e0029ULL,
0xfffe65702a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c68ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d28ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001678ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000167cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019b80ULL, 0xe100001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b400ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b440ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b7c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019d88ULL,
0x0000000000019d88ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b400ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b7c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 112800;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
