/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000149c8ULL, 0x0000000000014648ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000012fb0ULL,
0x0000000000000250ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013200ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012fb000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00012fb000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x000823040000007fULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL, 0x0000001700081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000039000942804ULL,
0x000009f0000004a0ULL, 0x00002bd000002b50ULL, 0x00002de000002ca0ULL, 0x0000335000003340ULL,
0x00004f9000004f30ULL, 0x000051d000005090ULL, 0x000055e0000055d0ULL, 0x0000718000007120ULL,
0x000073c000007280ULL, 0x000077d0000077c0ULL, 0x000093c000009360ULL, 0x00009600000094c0ULL,
0x00009af000009ae0ULL, 0x0000ac600000ac50ULL, 0x000124a0000123f0ULL, 0x00012750000126b0ULL,
0x000129f000012910ULL, 0x00012d4000012b10ULL, 0x0000053004303904ULL, 0x00017600000000ffULL,
0x0000061000040100ULL, 0x0001760800000008ULL, 0x00000720003f0100ULL, 0x0001768800000008ULL,
0x00000860003f0100ULL, 0x000176a800000002ULL, 0x00000960003f0100ULL, 0x000176c800000006ULL,
0x000010b0003f0100ULL, 0x00017600000000ffULL, 0x0000123000080107ULL, 0x0001768800000003ULL,
0x00001b60003f0101ULL, 0x00000000000000ffULL, 0x00001b9000040107ULL, 0x00000000000000ffULL,
0x00001c1000040101ULL, 0x0000002000000002ULL, 0x00001d60003f0101ULL, 0x000176c800000017ULL,
0x00001ef000080109ULL, 0x000176c800000035ULL, 0x00002800003f0109ULL, 0x000176b000000034ULL,
0x000028d000080107ULL, 0x000176b000000054ULL, 0x000028e0003f0101ULL, 0x000176080000004dULL,
0x00002900003f0101ULL, 0x000176080000004dULL, 0x00002a70003f0109ULL, 0x000176080000004dULL,
0x00002fa0003f0109ULL, 0x000176a80000003cULL, 0x0000312000080109ULL, 0x000176a800000036ULL,
0x00004270003f0109ULL, 0x000176c800000034ULL, 0x000042a0003f0101ULL, 0x0001768800000053ULL,
0x000042f000080101ULL, 0x0000000000000046ULL, 0x00004460003f0109ULL, 0x0000000000000046ULL,
0x00004c90003f0109ULL, 0x000176a800000014ULL, 0x00004ce000080107ULL, 0x000176a800000056ULL,
0x00004cf0003f0101ULL, 0x000176280000004dULL, 0x00004d10003f0101ULL, 0x000176280000004dULL,
0x00004e80003f0109ULL, 0x000176280000004dULL, 0x000053a0003f0109ULL, 0x000176b000000017ULL,
0x0000552000080109ULL, 0x000176b000000037ULL, 0x000063f0003f0109ULL, 0x000176c800000034ULL,
0x00006410003f0101ULL, 0x000176900000003eULL, 0x000064b000080101ULL, 0x0000000000000046ULL,
0x00006620003f0109ULL, 0x0000000000000046ULL, 0x00006e10003f0109ULL, 0x00000008000000ffULL,
0x00006ed000040107ULL, 0x0000000800000054ULL, 0x00006ee0003f0101ULL, 0x000176480000004dULL,
0x00006f00003f0101ULL, 0x000176480000004dULL, 0x00007070003f0109ULL, 0x000176480000004dULL,
0x00007590003f0109ULL, 0x000176a800000017ULL, 0x0000771000080109ULL, 0x000176a800000037ULL,
0x00008620003f0109ULL, 0x000176c800000034ULL, 0x00008650003f0101ULL, 0x0001769800000037ULL,
0x00008740003f0101ULL, 0x0000000000000046ULL, 0x000088b0003f0109ULL, 0x0000000000000046ULL,
0x000090e0003f0109ULL, 0x00000000000000ffULL, 0x0000913000040107ULL, 0x000176a800000048ULL,
0x00009140003f0101ULL, 0x0001766800000006ULL, 0x00009160003f0101ULL, 0x0001766800000006ULL,
0x000092d0003f0109ULL, 0x0001766800000006ULL, 0x000097c0003f0109ULL, 0x000176b00000003dULL,
0x00009970003f0109ULL, 0x000176b00000003dULL, 0x0000a960003f0109ULL, 0x000176a800000014ULL,
0x0000a9e0003f0101ULL, 0x000176a000000014ULL, 0x0000be10003f0101ULL, 0x00017600000000ffULL,
0x0000d7a000080101ULL, 0x00017600000000ffULL, 0x0000d96000080109ULL, 0x00017600000000ffULL,
0x0000db4000080109ULL, 0x00017600000000ffULL, 0x0000db6000080101ULL, 0x00017600000000ffULL,
0x0000dcd000080109ULL, 0x00017600000000ffULL, 0x000108d000080109ULL, 0x0001768800000036ULL,
0x00010aa0003f0101ULL, 0x0001768800000036ULL, 0x00010c10003f0109ULL, 0x0001768800000036ULL,
0x00012f50003f0109ULL, 0x000176080000003cULL, 0x00012f60003f0101ULL, 0x000176100000003cULL,
0x00012f70003f0101ULL, 0x000176180000003cULL, 0x00012f80003f0101ULL, 0x000176200000003cULL,
0x00053803003f0101ULL, 0x0000b4c000201c04ULL, 0x0000b7b00000b4f0ULL, 0x0000bba00000b9a0ULL,
0x0000dd000000bd50ULL, 0x000c050400012fa0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x0000000000012fb0ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000357919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000135072836ULL, 0x008fe20000000000ULL, 0x0000000000087306ULL, 0x010eec0000209000ULL,
0x00000400ff0a7b82ULL, 0x000f220000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x0000000000407919ULL, 0x000f6c0000002100ULL, 0x00008400ff0cab82ULL, 0x000f220000000800ULL,
0x0000000435042825ULL, 0x004fc800078e0002ULL, 0x0000000407022825ULL, 0x000fe400078e0002ULL,
0x0000000604042981ULL, 0x000ea8000c1e1900ULL, 0x0000000602092981ULL, 0x0008a2000c1e1900ULL,
0x0000000800087308ULL, 0x008ee20000001000ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000043000007945ULL, 0x000fe20003800000ULL, 0x0ffffffe08067836ULL, 0x008fc40000000000ULL,
0x0000000000087919ULL, 0x000ee60000002600ULL, 0x0000000600077305ULL, 0x000964000021f000ULL,
0x000000ffff067224ULL, 0x012fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x020fc800078e0a07ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fe400078e0006ULL,
0x00000000000b7919ULL, 0x000e680000002200ULL, 0x0000000a07077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000000300037224ULL, 0x000fe400078e020aULL,
0x00000000000a7919ULL, 0x000e660000002300ULL, 0x000000000300720cULL, 0x000fda0003f06070ULL,
0x0000000103030824ULL, 0x000fe400078e0a00ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000000300720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000000ff07b212ULL, 0x000fc800078e33ffULL, 0x0000000700057306ULL, 0x000f220000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f65070ULL, 0x0000000500057308ULL, 0x010f240000001000ULL,
0x0ffffffe05027836ULL, 0x010fcc0000000000ULL, 0x0000000200037305ULL, 0x000964000021f000ULL,
0x000000ffff027224ULL, 0x010fe400078e00ffULL, 0x0000000307067224ULL, 0x020fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d03037227ULL, 0x000fcc00078e0002ULL,
0x0000000803437227ULL, 0x008fc800078e00ffULL, 0x000000040a037c24ULL, 0x002fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe400078e0a43ULL,
0x0000000403067c24ULL, 0x100fe2000f8e0240ULL, 0x00000005ff407819ULL, 0x000fe20000011640ULL,
0x0000000207027224ULL, 0x000fc600078e0208ULL, 0x0000007f0600780cULL, 0x000fe40003fa4070ULL,
0x000000070200720cULL, 0x000fe20003f06070ULL, 0x00001fff40407589ULL, 0x000e6200000e0000ULL,
0x000000030600780cULL, 0x000fd20003f84070ULL, 0x000000000005d919ULL, 0x000ee40000008800ULL,
0x0000000102020824ULL, 0x000fe400078e0a07ULL, 0x0000000143430836ULL, 0x000fe20000000000ULL,
0x000000ff0600720cULL, 0x000fe40003f05270ULL, 0x000000070200720cULL, 0x000fe40003f26070ULL,
0x000004000002d802ULL, 0x000fd60000000f00ULL, 0x0000000143431836ULL, 0x000fe20000000000ULL,
0x00000007ff43b212ULL, 0x000fe400078e33ffULL, 0x0000000f0600780cULL, 0x040fe40003f24070ULL,
0x000000010600780cULL, 0x000fe20003f64070ULL, 0x000000ffff417224ULL, 0x000fc800078e0a43ULL,
0x0000004107417224ULL, 0x000fe400078e0208ULL, 0xff317217ff07d424ULL, 0x000fe400078e00ffULL,
0x0000000109032824ULL, 0x004fe200078e0a04ULL, 0x000006540509d816ULL, 0x008fe40000000002ULL,
0x00001fff0a057589ULL, 0x0004e600000e0000ULL, 0x00008400ff03ab82ULL, 0x000e620000000800ULL,
0x000000040602d824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x002fec0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x010fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000f340000000000ULL, 0x01760008043f75b2ULL, 0x0009240008000100ULL,
0x0000000000007918ULL, 0x01cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000406087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01760804083f75b2ULL, 0x0009300008000100ULL, 0xfffffffd00e81947ULL, 0x01cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000406087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01768804083f75b2ULL, 0x0009300008000100ULL,
0xfffffffd00e81947ULL, 0x01cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400070200d388ULL, 0x0005e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001041417824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000406027c11ULL, 0x004fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176a804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000406067c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000060912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176c804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000803027c24ULL, 0x006fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a41ULL, 0x000000410200720cULL, 0x000fe20003f06070ULL,
0x0000000c3504a224ULL, 0x000fc400078e02ffULL, 0x0000000800117c24ULL, 0x000fe2000f8e02ffULL,
0x00000010020f7446ULL, 0x000fe2000380000fULL, 0x0000000405027824ULL, 0x008fe400078e0240ULL,
0x00000011040e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x0000000202087824ULL, 0x000fe400078e00ffULL, 0x0000000843137c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c48947ULL, 0x000fea0003800000ULL,
0x0000000800027d06ULL, 0x000e620008209000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000157919ULL, 0x000ee80000008800ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02067836ULL, 0x002fe20000000000ULL, 0x00000004ff097819ULL, 0x004fca000001160dULL,
0x0000000600077305ULL, 0x0002a2000021f000ULL, 0x00000001080a7824ULL, 0x000fc800078e0209ULL,
0x0000000141027824ULL, 0x000fe400078e020aULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x004fc800078e0a07ULL, 0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000b07077227ULL, 0x000fcc00078e0006ULL, 0x00000002070b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a0bULL, 0x0000000807067c24ULL, 0x000fca000f8e0202ULL,
0x0000000806007c0cULL, 0x000fda000bf06070ULL, 0x8000000806060c36ULL, 0x000fe40008000000ULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x0000000806007c0cULL, 0x000fe4000bf26070ULL,
0x0000040000067802ULL, 0x000fc80000000f00ULL, 0x0000065415157816ULL, 0x008fce0000000006ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000008ff0bac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a0bULL, 0x0000000807027c24ULL, 0x000fe2000f8e0202ULL,
0x000000080f077248ULL, 0x000fe40007fe0000ULL, 0x00000000150872caULL, 0x000fe200000e0000ULL,
0x0000000113027824ULL, 0x000fe400078e0202ULL, 0x0000000107087824ULL, 0x000fe400078e0a08ULL,
0x000000110b067224ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe200078e00ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f0020b7812ULL, 0x000fe200078ec0ffULL, 0x000000010a087824ULL, 0x040fe400078e020dULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x0000000b060b7212ULL, 0x000fc800078efcffULL,
0x000000040b067c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0x0000000507077c10ULL, 0x000fe40008ffe4ffULL, 0x0000000808097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c46ULL,
0x0000000000b07947ULL, 0x000fea0003800000ULL, 0x0000000800097d06ULL, 0x000e620008209000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090a7836ULL, 0x002fe20000000000ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x000000080d087211ULL, 0x004fc600078fe0ffULL,
0x0000000a00077305ULL, 0x0002a4000021f000ULL, 0x0000000141027824ULL, 0x000fe200078e0208ULL,
0x00000000000a7919ULL, 0x002e620000008800ULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a07ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b070b7227ULL, 0x000fcc00078e0006ULL,
0x000000020b067227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0202ULL, 0x000006540a097816ULL, 0x002fc80000000009ULL,
0x0000000807007c0cULL, 0x000fda000bf06070ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x0000000106060836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf26070ULL,
0x0000000106061836ULL, 0x000fe20000000000ULL, 0x00000008ff06ac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x0000000807027c24ULL, 0x000fe2000f8e0202ULL,
0x00000000090872caULL, 0x000fe200000e0000ULL, 0x0000000108097824ULL, 0x000fe400078e020dULL,
0x0000000113077824ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe400078e00ffULL,
0x0000001106077224ULL, 0x000fe400078e0207ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x000000f0020b7812ULL, 0x000fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fc600078e00ffULL,
0xfffffff008097812ULL, 0x000fe400078ee209ULL, 0x0000000b06067212ULL, 0x000fe400078efcffULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000406067c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000507077c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c46ULL, 0x0001760008047890ULL, 0x000fe2000fffe03fULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000435067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000006063a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x0000007f3a3b7836ULL, 0x004fe40000000000ULL, 0x000000ff3a087836ULL, 0x000fc60000000000ULL,
0x00000007ff3b7819ULL, 0x000fe4000001163bULL, 0x00000008ff387819ULL, 0x000fca0000011608ULL,
0x000000a800fc8947ULL, 0x000fea0003800000ULL, 0x00000003ff0c7819ULL, 0x000fe20000011640ULL,
0xffffffffff4f7424ULL, 0x000fc600078e00ffULL, 0x01ffffff0c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000003b0c00720cULL, 0x000fda0003f06070ULL, 0x00009600ff068b82ULL, 0x000e620000000800ULL,
0x0000000235038824ULL, 0x000fce00078e00ffULL, 0x00009200ff048b82ULL, 0x000ea20000000a00ULL,
0x0000000603038224ULL, 0x002fe400078e0206ULL, 0x00000004ff067424ULL, 0x000fe400078e00ffULL,
0x000000010c078824ULL, 0x000fe200078e0203ULL, 0x0000000840037c11ULL, 0x000fc6000f8e18ffULL,
0x0000000407048825ULL, 0x004fe200078e0004ULL, 0x0176880603ff79a7ULL, 0x0003e8000850003fULL,
0x00000006044f8981ULL, 0x000e62000c1e1900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x00000080430a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff397819ULL, 0x000fe40000011640ULL,
0x0000000140097812ULL, 0x000fc600078ec0ffULL, 0x00000020390b7824ULL, 0x000fe400078e00ffULL,
0x000000004f037224ULL, 0x002fc600078e02ffULL, 0x000000600a007812ULL, 0x000fe200078ef80bULL,
0x0000008003137824ULL, 0x000fe200078e00ffULL, 0x0000000400080947ULL, 0x000fec0003800000ULL,
0x0000000b3a047248ULL, 0x000fe20007fe0000ULL, 0x0000001009037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe2000001160dULL, 0x00009000ff1c7b82ULL, 0x000e640000000a00ULL,
0x0000000104047824ULL, 0x000fe400078e0a0bULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x0000000405107836ULL, 0x000fe20000000000ULL, 0x0000000304047248ULL, 0x000fe20007fe0000ULL,
0x0000000106077824ULL, 0x000fc400078e020dULL, 0x0000000806087824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000000c05117836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x000000041000720cULL, 0x080fe20003f46070ULL, 0x0000000103107824ULL, 0x000fe200078e0210ULL,
0x000000040500720cULL, 0x080fe40003f66070ULL, 0x000000040700720cULL, 0x080fe20003f26070ULL,
0x0000000103077824ULL, 0x000fe200078e0207ULL, 0x000000041100720cULL, 0x000fe20003f06070ULL,
0x0000000110057824ULL, 0x040fe200078e020dULL, 0x0000001c13177211ULL, 0x002fe200078838ffULL,
0x0000000810147824ULL, 0x000fc400078e00ffULL, 0x0000000103037824ULL, 0x000fe200078e0211ULL,
0x0000001d131d7211ULL, 0x000fe200020f3cffULL, 0x0000000100047824ULL, 0x040fe200078e0206ULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000100067824ULL, 0x040fe400078e0210ULL,
0x0000000100107824ULL, 0x040fe400078e0207ULL, 0x0000000100127824ULL, 0x000fe400078e0203ULL,
0x0000000107007824ULL, 0x000fc400078e020dULL, 0x0000000807117824ULL, 0x000fe400078e00ffULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff811167812ULL, 0x000fe200078ee200ULL,
0x0000000103077824ULL, 0x040fe200078e020dULL, 0x0000007004047812ULL, 0x000fe200078ef802ULL,
0x0000000803187824ULL, 0x000fe200078e00ffULL, 0x0000000839007c11ULL, 0x000fe2000f8e68ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000417047210ULL, 0x000fe40007f9e0ffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007006157812ULL, 0x000fe400078ef802ULL,
0x0000007010067812ULL, 0x000fe200078ef802ULL, 0x0000000105057824ULL, 0x000fe200020e061dULL,
0x0000007012107812ULL, 0x000fe200078ef802ULL, 0x0001300000037836ULL, 0x000fe20000000000ULL,
0x0000001715027210ULL, 0x000fe40007f9e0ffULL, 0x0000001706067210ULL, 0x000fe20007fbe0ffULL,
0x0000001008157824ULL, 0x100fe200078e0203ULL, 0x0000001710107210ULL, 0x000fe20007fde0ffULL,
0x0000001014177824ULL, 0x000fc400078e0203ULL, 0x0000001016197824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000d901c46ULL,
0x00000010181b7824ULL, 0x000fe400078e0203ULL, 0x0000000107037824ULL, 0x100fe400020e061dULL,
0x0000000111077824ULL, 0x100fe400028e061dULL, 0x0000000113117824ULL, 0x000fe200030e061dULL,
0x0000000002177faeULL, 0x0003e8000d101c46ULL, 0x0000000006197faeULL, 0x0003e8000c901c46ULL,
0x00000000101b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001009047824ULL, 0x000fe200078e00ffULL, 0x00009000ff147b82ULL, 0x000e680000000a00ULL,
0x000000040d037211ULL, 0x000fca00078fe8ffULL, 0x0000000103047824ULL, 0x140fe400078e020dULL,
0x0000000803077824ULL, 0x000fe400078e00ffULL, 0x0000000403057836ULL, 0x000fe40000000000ULL,
0x0000000c03117836ULL, 0x000fe20000000000ULL, 0xfffffff807087812ULL, 0x000fe200078ee204ULL,
0x0000000105067824ULL, 0x040fe400078e020dULL, 0x0000000805177824ULL, 0x000fc400078e00ffULL,
0x0000000803077836ULL, 0x000fe40000000000ULL, 0x0000000100047824ULL, 0x040fe200078e0203ULL,
0xfffffff817037812ULL, 0x000fe200078ee206ULL, 0x0000000100067824ULL, 0x040fe200078e0205ULL,
0x0000001413177211ULL, 0x042fe200078038ffULL, 0x0000000100107824ULL, 0x040fe400078e0207ULL,
0x0000000100127824ULL, 0x000fe200078e0211ULL, 0x00000015131d7211ULL, 0x000fe200000f3cffULL,
0x0000000107007824ULL, 0x000fc400078e020dULL, 0x0000000807197824ULL, 0x000fe400078e00ffULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff819007812ULL, 0x000fe200078ee200ULL,
0x0000000111077824ULL, 0x040fe200078e020dULL, 0x0000007004047812ULL, 0x000fe200078ef802ULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000417047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff816147812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000839167c11ULL, 0x000fc6000f8e68ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007006157812ULL, 0x000fe400078ef802ULL,
0x0000007010067812ULL, 0x000fe200078ef802ULL, 0x0000000105057824ULL, 0x000fe200000e061dULL,
0x0000007012107812ULL, 0x000fe200078ef802ULL, 0x00013000161b7836ULL, 0x000fe20000000000ULL,
0x0000001517027210ULL, 0x000fe40007f1e0ffULL, 0x0000000617067210ULL, 0x000fe20007f3e0ffULL,
0x0000001008157824ULL, 0x100fe200078e021bULL, 0x0000001017107210ULL, 0x000fe20007f5e0ffULL,
0x0000001003177824ULL, 0x000fc400078e021bULL, 0x0000000107037824ULL, 0x000fe200000e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000b901c46ULL,
0x0000001000197824ULL, 0x000fe400078e021bULL, 0x0000000111077824ULL, 0x000fe200008e061dULL,
0x0000000002177faeULL, 0x0003e2000b901c46ULL, 0x00000010141b7824ULL, 0x000fe400078e021bULL,
0x0000000113117824ULL, 0x000fe200010e061dULL, 0x0000000006197faeULL, 0x0003e8000b901c46ULL,
0x00000000101b7faeULL, 0x0003e4000b901c46ULL, 0x00000008ff087e24ULL, 0x000fe2000f8e00ffULL,
0x00000000390472caULL, 0x000fe200000e0000ULL, 0x00000001ff037424ULL, 0x002fe200078e00ffULL,
0x000000ff3800720cULL, 0x000fe20003f05270ULL, 0x000176a808087836ULL, 0x000fe20000000000ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000080572caULL, 0x000fc400000e0000ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x0000000839027824ULL, 0x000fe400078e0208ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff4879a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000008c00988947ULL, 0x000fec0003800000ULL, 0x00009600ff047b82ULL, 0x000ee20000000800ULL,
0x00000002ff077819ULL, 0x000fe20000011640ULL, 0x0000000840027824ULL, 0x002fe200078e00ffULL,
0x0000000139007812ULL, 0x000fe200078ec0ffULL, 0x0000000235357824ULL, 0x000fe200078e00ffULL,
0x0000000807057c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff347224ULL, 0x000fe200078e0003ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0xff317217ff517424ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fc400078e0205ULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x0000000102067824ULL, 0x000fe400078e0205ULL, 0x0000000435057224ULL, 0x008fe400078e0204ULL,
0x000000ffff047224ULL, 0x000fce00078e00ffULL, 0x0000000000147805ULL, 0x010fce0000015200ULL,
0x0000000440167824ULL, 0x000fca00078e00ffULL, 0xfffffff816177812ULL, 0x000fc800078ec0ffULL,
0x0176c834170075a7ULL, 0x000e620008000148ULL, 0x0000000817357c36ULL, 0x000fc80008000000ULL,
0x000176c835467836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176c834350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001040147824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000104177836ULL, 0x000fe40000000000ULL,
0x000000054f347c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe014157812ULL, 0x000fe400078ec0ffULL,
0x000000381700720cULL, 0x000fe20003f26070ULL, 0x0000008034347824ULL, 0x000fe400078e00ffULL,
0x0000010004157824ULL, 0x000fc800078e0215ULL, 0x0000004015357836ULL, 0x000fca0000000000ULL,
0x0000006035157812ULL, 0x000fca00078ec0ffULL, 0x000000010a377824ULL, 0x000fe200078e0215ULL,
0x0000000400109947ULL, 0x000fec0003800000ULL, 0x0000001014177812ULL, 0x000fe400078ec0ffULL,
0x000000353a147248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3c7819ULL, 0x000fc6000001160dULL,
0x0000000114147824ULL, 0x000fe400078e0a35ULL, 0x000000043c427836ULL, 0x000fe40000000000ULL,
0x000000013c367824ULL, 0x000fe200078e0217ULL, 0x0000001714167248ULL, 0x000fe20007fe0000ULL,
0x000000083c487836ULL, 0x004fe20000000000ULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000000136357824ULL, 0x000fe400078e020dULL, 0x0000000116167824ULL, 0x000fc400078e0a17ULL,
0x00000008363e7824ULL, 0x000fc600078e00ffULL, 0x000000163c00720cULL, 0x080fe20003f86070ULL,
0x0000000c3c3c7836ULL, 0x000fe20000000000ULL, 0x000000164200720cULL, 0x0c0fe20003f66070ULL,
0x0000000142427824ULL, 0x100fe200078e0217ULL, 0x000000164800720cULL, 0x0c0fe20003f46070ULL,
0x0000000148487824ULL, 0x000fe200078e0217ULL, 0x000000163c00720cULL, 0x000fe20003f06070ULL,
0x0000000142167824ULL, 0x040fe200078e020dULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL,
0x00000008423d7824ULL, 0x000fe400078e00ffULL, 0x000000013c4c7824ULL, 0x000fc400078e0217ULL,
0x000000100d357824ULL, 0x000fe200078e00ffULL, 0xfffffff83d447812ULL, 0x000fe200078ee216ULL,
0x00000001373c7824ULL, 0x000fe200078e0236ULL, 0x00000014343f7211ULL, 0x002fe200078a38ffULL,
0x0000000148177824ULL, 0x040fe200078e020dULL, 0x0000007035457812ULL, 0x000fe200078ec0ffULL,
0x00000008484a7824ULL, 0x000fe200078e00ffULL, 0x00000015344b7211ULL, 0x000fe200028f3cffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee217ULL,
0x0000000137367824ULL, 0x040fe200078e0242ULL, 0x000000453c147212ULL, 0x000fe200078efcffULL,
0x0000000137167824ULL, 0x040fe400078e0248ULL, 0x0000000137357824ULL, 0x000fe200078e024cULL,
0x000000143f147210ULL, 0x000fe20007fbe0ffULL, 0x000000014c177824ULL, 0x040fe400078e020dULL,
0x000000084c4c7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84c3c7812ULL, 0x000fe200078ee217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004536367212ULL, 0x000fc600078efcffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x0000004516167212ULL, 0x000fc600078efcffULL, 0x000000013d157824ULL, 0x100fe200028e064bULL,
0x00000008393d7c11ULL, 0x000fe4000f8e68ffULL, 0x0000003f36367210ULL, 0x000fe40007fbe0ffULL,
0x0000004534347212ULL, 0x000fe200078efcffULL, 0x000140003d3d7836ULL, 0x000fe40000000000ULL,
0x0000000137377824ULL, 0x000fe200028e064bULL, 0x0000003f16167210ULL, 0x000fe20007fbe0ffULL,
0x0000001044457824ULL, 0x100fe200078e023dULL, 0x0000003f34347210ULL, 0x000fe20007fde0ffULL,
0x000000103e3f7824ULL, 0x000fc400078e023dULL, 0x000000104a477824ULL, 0x000fe400078e023dULL,
0x0000000117177824ULL, 0x000fe200028e064bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000e101c46ULL, 0x000000103c3d7824ULL, 0x000fe400078e023dULL,
0x0000000135357824ULL, 0x000fe200030e064bULL, 0x0000000036457faeULL, 0x0003e8000d901c46ULL,
0x0000000016477faeULL, 0x0003e8000d101c46ULL, 0x00000000343d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000dc7947ULL, 0x000fea0003800000ULL, 0x0000001014167812ULL, 0x000fe400078ec0ffULL,
0x00009000ff147b82ULL, 0x000e640000000a00ULL, 0x000000160d167211ULL, 0x000fca00078fe8ffULL,
0x0000000416367836ULL, 0x000fe40000000000ULL, 0x0000000116177824ULL, 0x140fe400078e020dULL,
0x00000008163e7824ULL, 0x000fe400078e00ffULL, 0x0000000136357824ULL, 0x040fe400078e020dULL,
0x0000000836427824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL,
0x0000000137177824ULL, 0x000fc400078e0216ULL, 0x00000008163c7836ULL, 0x000fe20000000000ULL,
0xfffffff842427812ULL, 0x000fe200078ee235ULL, 0x000000100d357824ULL, 0x000fe400078e00ffULL,
0x0000000c16447836ULL, 0x000fe20000000000ULL, 0x0000001434457211ULL, 0x042fe200078038ffULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x00000070353f7812ULL, 0x000fe400078ec0ffULL,
0x00000015344d7211ULL, 0x000fe200000f3cffULL, 0x0000000137357824ULL, 0x040fe200078e0236ULL,
0x0000003f16147212ULL, 0x000fe200078efcffULL, 0x0000000137367824ULL, 0x000fc400078e023cULL,
0x00000001373d7824ULL, 0x000fe200078e0244ULL, 0x0000001445147210ULL, 0x000fe20007f1e0ffULL,
0x000000013c377824ULL, 0x140fe400078e020dULL, 0x000000083c487824ULL, 0x004fe400078e00ffULL,
0x00000001443c7824ULL, 0x040fe400078e020dULL, 0x0000000844477824ULL, 0x000fe200078e00ffULL,
0xfffffff848447812ULL, 0x000fe200078ee237ULL, 0x0000008035347825ULL, 0x000fc600078e00ffULL,
0xfffffff847487812ULL, 0x000fe200078ee23cULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003f34167212ULL, 0x000fc600078efcffULL, 0x000000803d3c7825ULL, 0x000fe200078e00ffULL,
0x0000003f36347212ULL, 0x000fc600078efcffULL, 0x0000000117157824ULL, 0x000fe200000e064dULL,
0x0000000839177c11ULL, 0x000fe4000f8e68ffULL, 0x0000003f3c367212ULL, 0x000fe400078efcffULL,
0x0000001645167210ULL, 0x000fe20007f1e0ffULL, 0x0001400017177836ULL, 0x000fe20000000000ULL,
0x0000003445347210ULL, 0x000fe40007f5e0ffULL, 0x0000003645367210ULL, 0x000fe20007f7e0ffULL,
0x000000103e3f7824ULL, 0x000fc400078e0217ULL, 0x0000001042457824ULL, 0x100fe400078e0217ULL,
0x0000001044477824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000b901c46ULL, 0x00000010484b7824ULL, 0x000fe400078e0217ULL,
0x0000000135177824ULL, 0x100fe400000e064dULL, 0x0000000137357824ULL, 0x100fe400010e064dULL,
0x000000013d377824ULL, 0x000fe200018e064dULL, 0x0000000016457faeULL, 0x0003e8000b901c46ULL,
0x0000000034477faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e4000b901c46ULL,
0x000000010c167836ULL, 0x002fe40000000000ULL, 0xffffffffff527424ULL, 0x000fc600078e00ffULL,
0x0000003b1600720cULL, 0x000fe20003f06070ULL, 0x00000008403c7824ULL, 0x000fca00078e00ffULL,
0xfffffff03c347812ULL, 0x000fca00078ec0ffULL, 0x0000000834547c36ULL, 0x000fe40008000000ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000105178824ULL, 0x000fe200078e0216ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000540572caULL, 0x000fda00000e0000ULL,
0x000176b005057890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a45ULL, 0x0000000614528981ULL, 0x000322000c1e1900ULL,
0xffffffe03c167812ULL, 0x040fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x000000103c177812ULL, 0x040fe400078ec0ffULL, 0x000000083c4d7812ULL, 0x000fe400078ec0ffULL,
0x0000000817167c10ULL, 0x000fca000fffe016ULL, 0x00000001164d7824ULL, 0x000fe200078e024dULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0176b035545479a7ULL, 0x0002a4000850003fULL,
0x017608354d3479a7ULL, 0x0022e4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x017608354d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017608354d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000100d427824ULL, 0x000fe200078e00ffULL,
0x00000001ff457819ULL, 0x000fe2000001160dULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000007042427812ULL, 0x000fe400078ec0ffULL,
0xffffff8014157812ULL, 0x000fe400078ec0ffULL, 0x0000000c45457812ULL, 0x000fe400078ec0ffULL,
0x0000000842147c10ULL, 0x000fca000fffe015ULL, 0x0000000114147824ULL, 0x000fca00078e0245ULL,
0x0170000014167984ULL, 0x000ee80000000800ULL, 0x0172000014177984ULL, 0x000b620000000800ULL,
0x000000511600720bULL, 0x008fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000000fc8947ULL, 0x026fea0003800000ULL,
0x000000400700720cULL, 0x000fe40003f45270ULL, 0x000000511600720bULL, 0x000fd60003f14000ULL,
0x000000084015ac11ULL, 0x000fe4000f8e38ffULL, 0x000000511614a209ULL, 0x000fe40007810000ULL,
0x000000154515a210ULL, 0x000fe40007ffe042ULL, 0x0000000000367806ULL, 0x000fc600000e0100ULL,
0x017400141500a388ULL, 0x0003e20000000800ULL, 0x0000991036347816ULL, 0x000fc800000000ffULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001418187220ULL, 0x082fe20000410000ULL,
0x0000001419197220ULL, 0x080fe20000410000ULL, 0x000000142c2c7220ULL, 0x080fe20000410000ULL,
0x000000142d2d7220ULL, 0x080fe20000410000ULL, 0x0000001430307220ULL, 0x080fe20000410000ULL,
0x0000001431317220ULL, 0x080fe20000410000ULL, 0x0000001428287220ULL, 0x080fe20000410000ULL,
0x0000001429297220ULL, 0x080fe20000410000ULL, 0x0000001424247220ULL, 0x080fe20000410000ULL,
0x0000001425257220ULL, 0x080fe20000410000ULL, 0x0000001420207220ULL, 0x080fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x000000141c1c7220ULL, 0x080fe20000410000ULL,
0x000000141d1d7220ULL, 0x080fe20000410000ULL, 0x0000001410107220ULL, 0x080fe20000410000ULL,
0x0000001411117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x000000141a1a7220ULL, 0x082fe20000410000ULL,
0x000000141b1b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000141e1e7220ULL, 0x080fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806036ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0xfffffff03c3c7812ULL, 0x000fc800078ec0ffULL,
0x0176a8493c0075a7ULL, 0x000e620008000148ULL, 0x000000083c367c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176a849360075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000020040147824ULL, 0x000fe200078e00ffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x0000000240537824ULL, 0x040fe200078e00ffULL, 0x000000070d5a7812ULL, 0x000fe200078ec0ffULL,
0x0000000440177824ULL, 0x000fe200078e00ffULL, 0xfffff800144f7812ULL, 0x000fe400078ec0ffULL,
0x0000000453147812ULL, 0x000fe400078ec0ffULL, 0x00000004ff5e7819ULL, 0x000fe2000001160dULL,
0x000000084f4f7c36ULL, 0x000fe20008000000ULL, 0x0000000417177812ULL, 0x000fc400078ec0ffULL,
0x000000ff1500720cULL, 0x000fe40003f05270ULL, 0x000000085a5b7812ULL, 0x000fe200078ef80dULL,
0x000000015e4a7824ULL, 0x000fe200078e0217ULL, 0x000000140d147211ULL, 0x040fe400078fe0ffULL,
0x000000080d597812ULL, 0x000fe200078ec0ffULL, 0x000000085b177824ULL, 0x000fe200078e00ffULL,
0x0000000839497c11ULL, 0x000fe2000f8e68ffULL, 0x000000015b447824ULL, 0x000fe200078e0214ULL,
0x0000005a59157212ULL, 0x000fc600078efcffULL, 0x0001300049477836ULL, 0x000fe20000000000ULL,
0xfffffff817147812ULL, 0x000fe200078ee244ULL, 0x0000000815357824ULL, 0x040fe400078e00ffULL,
0x0000000115167824ULL, 0x040fe400078e024aULL, 0x0000000815377824ULL, 0x000fe400078e00ffULL,
0x00000002164c7836ULL, 0x000fe20000000000ULL, 0xfffffff8354e7812ULL, 0x000fe200078ee216ULL,
0x00000010144b7824ULL, 0x000fe200078e024fULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011000004b14783bULL, 0x0022e20000000200ULL, 0x000000104e3c7824ULL, 0x000fe200078e0247ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0xfffffff8374c7812ULL, 0x000fe200078ee24cULL, 0x00000004395e7824ULL, 0x000fe200078e025eULL,
0x0000001059597812ULL, 0x000fc600078efe5aULL, 0x000000104c347824ULL, 0x000fe200078e0247ULL,
0x000000025e5e7810ULL, 0x000fe20007ffe05bULL, 0x000000085b5b7824ULL, 0x000fc800078e00ffULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0xfffffff85b5e7812ULL, 0x000fca00078ee25eULL,
0x000000105e4f7824ULL, 0x000fe200078e024fULL, 0x00000018ff6b7819ULL, 0x022fe2000001143dULL,
0x000001003d5d7824ULL, 0x040fe200078e00ffULL, 0x000088803d6e7816ULL, 0x040fe200000000ffULL,
0x000001003c5c7824ULL, 0x040fe200078e00ffULL, 0x000088803c6d7816ULL, 0x000fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff607819ULL, 0x008fe40000011434ULL,
0x0000888034647816ULL, 0x000fe200000000ffULL, 0x0000005c00707306ULL, 0x0003e20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011435ULL, 0x0000888035637816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003d00727306ULL, 0x0007e20000200c00ULL,
0x000001003e5c7824ULL, 0x042fe200078e00ffULL, 0x000088803e697816ULL, 0x000fc400000000ffULL,
0x000088803f677816ULL, 0x000fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00000100343d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001143eULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011436ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff567819ULL, 0x000fe40000011437ULL, 0x00000018ff587819ULL, 0x000fe2000001143fULL,
0x0000005d00717306ULL, 0x000e700000200c00ULL, 0x0000005c006a7306ULL, 0x0007f00000200c00ULL,
0x0000003400617306ULL, 0x000be20000200c00ULL, 0x00000100355c7824ULL, 0x008fc400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000010037347824ULL, 0x024fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe80000200c00ULL, 0x00000018ff347819ULL, 0x000fc80000011434ULL,
0x0000003c006f7306ULL, 0x0004f00000200c00ULL, 0x0000003500627306ULL, 0x0003e20000200c00ULL,
0x000001003f3c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000034005d7306ULL, 0x0005e20000200c00ULL, 0x000054106e357816ULL, 0x002fce0000000071ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x000054106d347816ULL, 0x004fce0000000070ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x0000003c00687306ULL, 0x0005620000200c00ULL, 0x0001000036357824ULL, 0x000fe200078e00ffULL,
0x000054106f347816ULL, 0x008fc8000000006cULL, 0x00000018ff6c7819ULL, 0x000fe40000011435ULL,
0x0000541072357816ULL, 0x000fe2000000006bULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00000100363c7824ULL, 0x004fe400078e00ffULL, 0x000100003f6b7824ULL, 0x000fc600078e00ffULL,
0x00000034142c723cULL, 0x000fe2000000182cULL, 0x00000018ff737819ULL, 0x000fe2000001143cULL,
0x0000003d00657306ULL, 0x0004e20000200c00ULL, 0x00008880373c7816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x0000541069347816ULL, 0x002fe4000000006aULL,
0x0000541067357816ULL, 0x020fe20000000068ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00008880363d7816ULL, 0x004fca00000000ffULL, 0x000000341430723cULL, 0x000fe40000001830ULL,
0x0000005c00667306ULL, 0x000e6a0000200c00ULL, 0x0000541064347816ULL, 0x008fc60000000065ULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x0000541063357816ULL, 0x002fce0000000066ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541061347816ULL, 0x004fe40000000060ULL,
0x0000541062357816ULL, 0x002fca000000005fULL, 0x00000073005c7306ULL, 0x000e640000200c00ULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x000054103d347816ULL, 0x002fce000000005cULL, 0x0000003e00367306ULL, 0x0003e20000200c00ULL,
0x000054103c357816ULL, 0x004fce000000005dULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x00010000373e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x00000034141c723cULL, 0x000fe2000000181cULL, 0x0000004800487306ULL, 0x000fec0000200c00ULL,
0x0000000859347824ULL, 0x000fe200078e00ffULL, 0x0000541036367816ULL, 0x004fe20000000057ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000014a577824ULL, 0x000fca00078e0259ULL,
0xfffffff8344a7812ULL, 0x000fe400078ee257ULL, 0x0000005800587306ULL, 0x000fe60000200c00ULL,
0x000000104a3c7824ULL, 0x000fca00078e0247ULL, 0x0000006c003f7306ULL, 0x000e700000200c00ULL,
0x0000006b00377306ULL, 0x000ea20000200c00ULL, 0x000054103f347816ULL, 0x002fce0000000048ULL,
0x0000003e005f7306ULL, 0x000e620000200c00ULL, 0x0000541037377816ULL, 0x004fce0000000058ULL,
0x000000361428723cULL, 0x000fe20000001828ULL, 0x000054105f357816ULL, 0x002fce0000000056ULL,
0x000000341410723cULL, 0x000fe20000001810ULL, 0x011000004f14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ec0ffULL, 0x0000000257487836ULL, 0x000fca0000000000ULL,
0xfffffff859487812ULL, 0x000fca00078ee248ULL, 0x0000001048347824ULL, 0x000fcc00078e0247ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff657819ULL, 0x008fe2000001143cULL,
0x000001003c5a7824ULL, 0x040fe200078e00ffULL, 0x000088803c677816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001143dULL,
0x000001003d5b7824ULL, 0x040fe200078e00ffULL, 0x000088803d6b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fc4000001145aULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5f7819ULL, 0x000fe2000001143fULL, 0x0000003c006a7306ULL, 0x0007e20000200c00ULL,
0x000088803f637816ULL, 0x000fe400000000ffULL, 0x00000018ff597819ULL, 0x022fe40000011434ULL,
0x00000018ff587819ULL, 0x000fc40000011435ULL, 0x00008880345c7816ULL, 0x000fe200000000ffULL,
0x0000005a006c7306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x000088803e667816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143eULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000001003e5a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc40000011436ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000005b006e7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff577819ULL, 0x000fca0000011437ULL, 0x0000003d006d7306ULL, 0x0007e20000200c00ULL,
0x00008880355b7816ULL, 0x002fce00000000ffULL, 0x0000003c00687306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x04cfe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001143cULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fca00000000ffULL, 0x0000005a00697306ULL, 0x000ff00000200c00ULL,
0x0000003f00627306ULL, 0x000ff00000200c00ULL, 0x00000034005a7306ULL, 0x000bf00000200c00ULL,
0x00000035003f7306ULL, 0x0007e20000200c00ULL, 0x0000541067347816ULL, 0x020fe2000000006cULL,
0x0000010037677824ULL, 0x000fcc00078e00ffULL, 0x0000006600667306ULL, 0x000f620000200c00ULL,
0x000054106b357816ULL, 0x008fce000000006eULL, 0x0000006300637306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106a347816ULL, 0x004fe20000000065ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054106d357816ULL, 0x002fc40000000064ULL,
0x00000018ff657819ULL, 0x000fca0000011467ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000034142c723cULL, 0x000fee000000182cULL, 0x0000003e00617306ULL, 0x0002a20000200c00ULL,
0x0000541066347816ULL, 0x020fe40000000069ULL, 0x0000541063357816ULL, 0x008fe20000000068ULL,
0x0001000037637824ULL, 0x000fc800078e00ffULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00008880373e7816ULL, 0x002fe200000000ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x00000018ff637819ULL, 0x000fca0000011463ULL, 0x0000003d005d7306ULL, 0x0002e20000200c00ULL,
0x0000541061347816ULL, 0x004fe40000000060ULL, 0x0000541062357816ULL, 0x000fca000000005fULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x042fe200078e00ffULL,
0x000000341428723cULL, 0x000fe20000001828ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000054105c347816ULL, 0x008fca000000005dULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000054105b357816ULL, 0x002fce000000005eULL,
0x0000005800587306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105a347816ULL, 0x004fe40000000059ULL,
0x000054103f357816ULL, 0x002fca0000000058ULL, 0x0000003d003d7306ULL, 0x000e640000200c00ULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000000839347c11ULL, 0x000fe4000f8e18ffULL, 0x000054103c3c7816ULL, 0x002fca000000003dULL,
0x0000005700577306ULL, 0x000ff00000200c00ULL, 0x0000003e003e7306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000e700000200c00ULL, 0x0000003600377306ULL, 0x0004e20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce0000000065ULL, 0x00000063005c7306ULL, 0x000e620000200c00ULL,
0x00000001ff367424ULL, 0x004fc800078e00ffULL, 0x0176c836343479a7ULL, 0x0004a2000850003fULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x0000541037567816ULL, 0x008fe20000000056ULL,
0x0176883653ff79a7ULL, 0x0007e20008500008ULL, 0x000054105c577816ULL, 0x002fce0000000057ULL,
0x000000561410723cULL, 0x000fde0000001810ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035460075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x008fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035460075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001040147824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe40000000800ULL,
0x0000000552527c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe014157812ULL, 0x000fe400078ec0ffULL,
0x0000008052537824ULL, 0x008fc600078e00ffULL, 0x0000010004157824ULL, 0x000fc800078e0215ULL,
0x0000008015177836ULL, 0x000fca0000000000ULL, 0x0000006017157812ULL, 0x000fca00078ec0ffULL,
0x000000010a157824ULL, 0x000fe200078e0215ULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x0000001014377812ULL, 0x000fe200078ec0ffULL, 0x00009000ff347b82ULL, 0x000e620000000a00ULL,
0x000000173a147248ULL, 0x000fe40007fe0000ULL, 0x00000003ff167819ULL, 0x000fc6000001160dULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000116367824ULL, 0x000fe400078e0237ULL,
0x00000004163c7836ULL, 0x000fe20000000000ULL, 0x0000001437147248ULL, 0x000fe20007fe0000ULL,
0x0000000136177824ULL, 0x040fe400078e020dULL, 0x00000008363e7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fc400078e0a37ULL, 0x0000000c163d7836ULL, 0x000fe20000000000ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL, 0x0000000816177836ULL, 0x000fe20000000000ULL,
0x000000143c00720cULL, 0x0c0fe20003f66070ULL, 0x000000013c3c7824ULL, 0x100fe200078e0237ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000117567824ULL, 0x040fe200078e0237ULL,
0x000000141700720cULL, 0x080fe20003f46070ULL, 0x000000013c167824ULL, 0x040fe200078e020dULL,
0x000000143d00720cULL, 0x000fe20003f06070ULL, 0x000000083c3f7824ULL, 0x000fc400078e00ffULL,
0x000000013d587824ULL, 0x000fe400078e0237ULL, 0x0000000136367824ULL, 0x100fe200078e0215ULL,
0xfffffff83f527812ULL, 0x000fe200078ee216ULL, 0x000000013c3c7824ULL, 0x100fe200078e0215ULL,
0x00000034533f7211ULL, 0x042fe200078a38ffULL, 0x0000000156167824ULL, 0x100fe400078e0215ULL,
0x0000000158147824ULL, 0x040fe200078e0215ULL, 0x0000003553597211ULL, 0x000fe200028f3cffULL,
0x0000000158177824ULL, 0x000fc400078e020dULL, 0x0000000156157824ULL, 0x000fe400078e020dULL,
0x0000000858587824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee217ULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0x0000004236347212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff856567812ULL, 0x000fe200078ee215ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000423c367212ULL, 0x080fe400078efcffULL, 0x000000343f347210ULL, 0x000fe20007fbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003f36367210ULL, 0x000fe40007fde0ffULL,
0x0000004216167212ULL, 0x080fe200078efcffULL, 0x0000000137357824ULL, 0x100fe200028e0659ULL,
0x0000004214147212ULL, 0x000fe200078efcffULL, 0x000000013d377824ULL, 0x000fe200030e0659ULL,
0x0000003f16167210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3d7824ULL, 0x100fe200078e0247ULL,
0x0000003f14147210ULL, 0x000fe20007fde0ffULL, 0x00000010523f7824ULL, 0x000fc400078e0247ULL,
0x0000001056577824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000343d7faeULL, 0x0003e2000e101c46ULL, 0x0000000117177824ULL, 0x000fe400028e0659ULL,
0x0000001058477824ULL, 0x000fe200078e0247ULL, 0x00000000363f7faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e0659ULL, 0x0000000016577faeULL, 0x0003e8000d101c46ULL,
0x0000000014477faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x00009000ff167b82ULL, 0x000e620000000a00ULL, 0x0000001014147812ULL, 0x000fc800078ec0ffULL,
0x000000140d147211ULL, 0x000fca00078fe8ffULL, 0x0000000114347824ULL, 0x040fe400078e020dULL,
0x0000000814357824ULL, 0x040fe400078e00ffULL, 0x0000000c14587836ULL, 0x000fe40000000000ULL,
0x0000000414527836ULL, 0x000fe20000000000ULL, 0xfffffff8353e7812ULL, 0x000fe200078ee234ULL,
0x00000001143c7824ULL, 0x000fe400078e0215ULL, 0x0000000814567836ULL, 0x000fc40000000000ULL,
0x0000000158147824ULL, 0x040fe400078e0215ULL, 0x0000000158377824ULL, 0x000fe200078e020dULL,
0x00000016533f7211ULL, 0x042fe200078038ffULL, 0x0000000152367824ULL, 0x040fe400078e0215ULL,
0x0000000152357824ULL, 0x000fe200078e020dULL, 0x0000001753597211ULL, 0x000fe200000f3cffULL,
0x0000000156347824ULL, 0x000fe400078e0215ULL, 0x0000000858587824ULL, 0x000fc400078e00ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee237ULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0x000000423c167212ULL, 0x080fe200078efcffULL,
0x0000000156157824ULL, 0x040fe400078e020dULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0xfffffff852527812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000163f167210ULL, 0x000fe40007f1e0ffULL, 0xfffffff856567812ULL, 0x000fe200078ee215ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004236367212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004234347212ULL, 0x000fc600078efcffULL,
0x000000013d177824ULL, 0x000fe200000e0659ULL, 0x0000004214147212ULL, 0x000fe200078efcffULL,
0x000000103e3d7824ULL, 0x100fe200078e0247ULL, 0x000000363f367210ULL, 0x000fe20007f1e0ffULL,
0x0000001056577824ULL, 0x100fe200078e0247ULL, 0x000000343f347210ULL, 0x000fe40007f5e0ffULL,
0x000000143f147210ULL, 0x000fe20007f7e0ffULL, 0x00000010523f7824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163d7faeULL, 0x0003e2000b901c46ULL,
0x0000000137377824ULL, 0x000fc400000e0659ULL, 0x0000000135357824ULL, 0x000fe400010e0659ULL,
0x0000001058477824ULL, 0x000fe200078e0247ULL, 0x00000000363f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fc600018e0659ULL, 0x0000000034577faeULL, 0x0003e8000b901c46ULL,
0x0000000014477faeULL, 0x0003e4000b901c46ULL, 0x0000000840147824ULL, 0x002fe400078e00ffULL,
0x00000001ff167424ULL, 0x000fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fca00078ec0ffULL,
0x0000000814567c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000000560572caULL, 0x000fda00000e0000ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176a816565679a7ULL, 0x0002a4000850003fULL, 0x017628164d1679a7ULL, 0x0022e4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x017628174d0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003414377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017628174d0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008015147810ULL, 0x000fc80007ffe014ULL, 0x0000001445147210ULL, 0x000fca0007ffe042ULL,
0x0170000014167984ULL, 0x000ee80000000800ULL, 0x0172000014177984ULL, 0x0009220000000800ULL,
0x000000511600720bULL, 0x008fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x016fea0003800000ULL,
0x0000000107157836ULL, 0x000fe20000000000ULL, 0x000000511600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000084015ac11ULL, 0x000fe4000f8e38ffULL, 0x000000511614a209ULL, 0x000fe40007810000ULL,
0x000000154537a210ULL, 0x000fe40007ffe042ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005116147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005114147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160dULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001550507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005116517209ULL, 0x000fd60007810000ULL, 0x8000005116160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe20000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016177812ULL, 0x000fc800078ec0ffULL,
0x0176b055170075a7ULL, 0x000ea20008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b055370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0001400049477836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x000000104e3c7824ULL, 0x000fd800078e0247ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011800004b14783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x000000104c347824ULL, 0x000fcc00078e0247ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x00000018ff657819ULL, 0x010fe2000001143cULL, 0x000001003c597824ULL, 0x040fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001143dULL, 0x000001003d5a7824ULL, 0x040fe200078e00ffULL,
0x000088803c677816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff587819ULL, 0x022fe40000011434ULL, 0x00008880345c7816ULL, 0x000fe200000000ffULL,
0x00000059006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff5f7819ULL, 0x000fe4000001143fULL, 0x000088803f637816ULL, 0x000fc400000000ffULL,
0x00000018ff557819ULL, 0x000fe20000011435ULL, 0x0000003c006a7306ULL, 0x0009e20000200c00ULL,
0x000001003e597824ULL, 0x042fe200078e00ffULL, 0x00008880355b7816ULL, 0x000fe400000000ffULL,
0x000088803e667816ULL, 0x040fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000003d006d7306ULL, 0x0003e20000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011436ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000100343d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff547819ULL, 0x000fca0000011437ULL,
0x0000005a006e7306ULL, 0x000e700000200c00ULL, 0x0000005900697306ULL, 0x000ff00000200c00ULL,
0x0000003c00687306ULL, 0x0009f00000200c00ULL, 0x0000003400597306ULL, 0x000be20000200c00ULL,
0x00000100353c7824ULL, 0x010fc400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x0000010037347824ULL, 0x028fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003f00627306ULL, 0x000ff00000200c00ULL,
0x00000035005a7306ULL, 0x0003f00000200c00ULL, 0x00000034003f7306ULL, 0x0007e20000200c00ULL,
0x000054106b357816ULL, 0x002fce000000006eULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000541067347816ULL, 0x008fe2000000006cULL, 0x0001000037677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006300637306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106a347816ULL, 0x000fe20000000065ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054106d357816ULL, 0x010fce0000000064ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000003e00617306ULL, 0x0009620000200c00ULL, 0x0000541066347816ULL, 0x002fe40000000069ULL,
0x0000541063357816ULL, 0x008fca0000000068ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000100363e7824ULL, 0x010fe200078e00ffULL, 0x000000341430723cULL, 0x000fe80000001830ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d005d7306ULL, 0x0002e20000200c00ULL,
0x0000541061347816ULL, 0x024fe40000000060ULL, 0x0000541062357816ULL, 0x000fca000000005fULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00008880363d7816ULL, 0x042fe200000000ffULL,
0x000000341428723cULL, 0x000fe20000001828ULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x0000003c005e7306ULL, 0x0002a20000200c00ULL, 0x000054105c347816ULL, 0x008fe4000000005dULL,
0x00000018ff367819ULL, 0x000fca0000011436ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x00008880373c7816ULL, 0x002fe400000000ffULL, 0x000054105b357816ULL, 0x004fca000000005eULL,
0x0000005500557306ULL, 0x000e640000200c00ULL, 0x000000341424723cULL, 0x000fec0000001824ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541059347816ULL, 0x008fe40000000058ULL,
0x000054105a357816ULL, 0x002fca0000000055ULL, 0x0000003e003e7306ULL, 0x000e640000200c00ULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x000054103d347816ULL, 0x002fce000000003eULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000054103c357816ULL, 0x004fce000000003fULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000000104a3c7824ULL, 0x000fe200078e0247ULL, 0x00000034141c723cULL, 0x000fec000000181cULL,
0x0000003600377306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541037347816ULL, 0x002fc40000000052ULL, 0x0000541067357816ULL, 0x004fce0000000054ULL,
0x000000341410723cULL, 0x000fe20000001810ULL, 0x011800004f14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000001048347824ULL, 0x000fcc00078e0247ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x00000018ff627819ULL, 0x008fe2000001143cULL,
0x000001003c597824ULL, 0x040fe200078e00ffULL, 0x000088803c587816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe2000001143dULL,
0x000001003d5a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000088803d677816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001145aULL, 0x00000018ff5e7819ULL, 0x000fe2000001143eULL,
0x0000005900697306ULL, 0x0007e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5d7819ULL, 0x000fe4000001143fULL, 0x000088803e637816ULL, 0x040fe400000000ffULL,
0x000088803f647816ULL, 0x000fe200000000ffULL, 0x0000003c00657306ULL, 0x000be20000200c00ULL,
0x000001003e597824ULL, 0x048fe200078e00ffULL, 0x00000018ff557819ULL, 0x010fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011435ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x000001003f3c7824ULL, 0x062fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011436ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff527819ULL, 0x000fe40000011437ULL,
0x00008880376c7816ULL, 0x000fc600000000ffULL, 0x0000005a006a7306ULL, 0x0003300000200c00ULL,
0x0000003d00687306ULL, 0x000be20000200c00ULL, 0x00008880345a7816ULL, 0x002fce00000000ffULL,
0x0000005900667306ULL, 0x0003e20000200c00ULL, 0x00000100343d7824ULL, 0x064fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c006b7306ULL, 0x0005e20000200c00ULL, 0x0000888035597816ULL, 0x002fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x00000100353c7824ULL, 0x044fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003e005f7306ULL, 0x000fe20000200c00ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000003f00607306ULL, 0x000ff00000200c00ULL, 0x00000034003e7306ULL, 0x0007f00000200c00ULL,
0x00000035003f7306ULL, 0x0009e20000200c00ULL, 0x0000541058347816ULL, 0x008fe20000000069ULL,
0x000000ffff587224ULL, 0x000fcc00078e006cULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x0000541067357816ULL, 0x010fe2000000006aULL, 0x0000010037677824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc800078e00ffULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fe20000001818ULL, 0x00000018ff377819ULL, 0x000fcc0000011437ULL,
0x0000541065347816ULL, 0x000fe20000000062ULL, 0x0000005e005e7306ULL, 0x000f220000200c00ULL,
0x0000541068357816ULL, 0x002fe40000000061ULL, 0x00000018ff617819ULL, 0x000fca0000011467ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000541063347816ULL, 0x004fe20000000066ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541064357816ULL, 0x008fce000000006bULL, 0x0000003d005b7306ULL, 0x0004e20000200c00ULL,
0x000000341430723cULL, 0x000fee0000001830ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000054105f347816ULL, 0x010fe2000000005eULL, 0x00000100363d7824ULL, 0x004fe200078e00ffULL,
0x0000541060357816ULL, 0x002fe2000000005dULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x000000341428723cULL, 0x000fec0000001828ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054105a347816ULL, 0x008fc4000000005bULL,
0x0000541059357816ULL, 0x002fca000000005cULL, 0x0000005400547306ULL, 0x000e640000200c00ULL,
0x000000341424723cULL, 0x000fec0000001824ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103e347816ULL, 0x004fe40000000055ULL, 0x000054103f357816ULL, 0x002fca0000000054ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000001ff3f7424ULL, 0x000fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000000240357824ULL, 0x000fe200078e00ffULL, 0x0000000839347c11ULL, 0x000fcc000f8e18ffULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x002fe4000000003dULL,
0xfffffff8353e7812ULL, 0x000fe400078ec0ffULL, 0x0176c83f343479a7ULL, 0x000e66000850003fULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0176903f3eff79a7ULL, 0x0005ee0008500008ULL,
0x0000006100617306ULL, 0x000ef00000200c00ULL, 0x0000003600367306ULL, 0x000f220000200c00ULL,
0x00005410583d7816ULL, 0x008fce0000000061ULL, 0x0000003700377306ULL, 0x000ee20000200c00ULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x0000541036367816ULL, 0x010fe4000000004fULL,
0x0000541037377816ULL, 0x008fce0000000052ULL, 0x000000361410723cULL, 0x000fee0000001810ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x00000035460075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035460075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010004527824ULL, 0x000fc800078e020bULL, 0x000000c052177836ULL, 0x000fca0000000000ULL,
0x0000006017157812ULL, 0x000fca00078ec0ffULL, 0x000000010a377824ULL, 0x000fe200078e0215ULL,
0x0000000400049947ULL, 0x000fec0003800000ULL, 0x000000173a147248ULL, 0x000fe20007fe0000ULL,
0x0000001040157824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160dULL,
0x0000000114147824ULL, 0x000fe200078e0a17ULL, 0x0000001015177812ULL, 0x000fe200078ec0ffULL,
0x0000000434357836ULL, 0x000fe40000000000ULL, 0x00000008343c7836ULL, 0x000fe20000000000ULL,
0x0000001417167248ULL, 0x000fe20007fe0000ULL, 0x0000000c343d7836ULL, 0x000fe20000000000ULL,
0x00009000ff147b82ULL, 0x000e620000000a00ULL, 0x0000000135367824ULL, 0x100fe400078e0217ULL,
0x0000000116167824ULL, 0x000fc400078e0a17ULL, 0x000000013d5a7824ULL, 0x100fe400078e0217ULL,
0x0000000836547824ULL, 0x000fe200078e00ffULL, 0x000000163400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x000fe200078e0217ULL, 0x000000163500720cULL, 0x080fe40003f66070ULL,
0x000000163c00720cULL, 0x080fe20003f46070ULL, 0x0000000834357824ULL, 0x040fe200078e00ffULL,
0x000000163d00720cULL, 0x000fe20003f06070ULL, 0x0000000134167824ULL, 0x000fc400078e020dULL,
0x0000000134347824ULL, 0x000fe400078e0237ULL, 0x000000013c3c7824ULL, 0x000fe200078e0217ULL,
0xfffffff8353e7812ULL, 0x000fe200078ee216ULL, 0x0000000136177824ULL, 0x000fe400078e020dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000014533f7211ULL, 0x042fe400078a38ffULL,
0xfffffff854547812ULL, 0x000fe200078ee217ULL, 0x0000000136167824ULL, 0x000fe200078e0237ULL,
0x0000004234147212ULL, 0x000fe200078efcffULL, 0x000000013c3d7824ULL, 0x000fe200078e020dULL,
0x0000001553537211ULL, 0x000fe200028f3cffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003f14147210ULL, 0x000fc60007fbe0ffULL, 0x000000083c587824ULL, 0x000fe200078e00ffULL,
0x0000004216167212ULL, 0x000fe200078efcffULL, 0x000000013c367824ULL, 0x100fe400078e0237ULL,
0x000000015a3c7824ULL, 0x000fe200078e0237ULL, 0xfffffff858587812ULL, 0x000fe200078ee23dULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004236347212ULL, 0x000fc600078efcffULL, 0x0000000135157824ULL, 0x000fe200028e0653ULL,
0x0000003f16167210ULL, 0x000fe20007fbe0ffULL, 0x000000015a357824ULL, 0x000fe200078e020dULL,
0x000000423c367212ULL, 0x000fe200078efcffULL, 0x000000085a3c7824ULL, 0x000fe400078e00ffULL,
0x0000000117177824ULL, 0x000fe200028e0653ULL, 0x0000003f34347210ULL, 0x000fe20007fbe0ffULL,
0x00000010584f7824ULL, 0x100fe200078e0247ULL, 0x0000003f36367210ULL, 0x000fe20007fde0ffULL,
0x000000103e3f7824ULL, 0x000fe200078e0247ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee235ULL,
0x0000000137357824ULL, 0x000fc400028e0653ULL, 0x000000013d377824ULL, 0x000fe200030e0653ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143f7faeULL, 0x0003e2000e101c46ULL,
0x00000010543d7824ULL, 0x100fe400078e0247ULL, 0x000000103c537824ULL, 0x000fc600078e0247ULL,
0x00000000163d7faeULL, 0x0003e8000d901c46ULL, 0x00000000344f7faeULL, 0x0003e8000d101c46ULL,
0x0000000036537faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001040147824ULL, 0x000fe200078e00ffULL, 0x00009000ff167b82ULL, 0x000e680000000a00ULL,
0x0000001014147812ULL, 0x000fc800078ec0ffULL, 0x000000140d147211ULL, 0x000fca00078fe8ffULL,
0x0000000114157824ULL, 0x040fe400078e020dULL, 0x00000008143e7824ULL, 0x040fe400078e00ffULL,
0x00000004143c7836ULL, 0x000fe40000000000ULL, 0x0000000814547836ULL, 0x000fe20000000000ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee215ULL, 0x0000000c14587836ULL, 0x000fe40000000000ULL,
0x0000000114347824ULL, 0x100fe200078e0237ULL, 0x00000016533f7211ULL, 0x002fe200078038ffULL,
0x000000013c367824ULL, 0x000fc400078e0237ULL, 0x000000013c157824ULL, 0x040fe200078e020dULL,
0x0000001753537211ULL, 0x000fe200000f3cffULL, 0x000000083c5a7824ULL, 0x000fe400078e00ffULL,
0x00000001543c7824ULL, 0x100fe400078e0237ULL, 0x0000000158147824ULL, 0x000fe400078e0237ULL,
0x0000000154377824ULL, 0x140fe400078e020dULL, 0x00000008545c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a547812ULL, 0x000fe200078ee215ULL, 0x00000001583d7824ULL, 0x000fc400078e020dULL,
0x00000008585e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c587812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5a7812ULL, 0x000fe200078ee23dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004234167212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000003f16167210ULL, 0x000fe40007f1e0ffULL,
0x0000004236347212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000423c367212ULL, 0x080fe400078efcffULL, 0x0000003f34347210ULL, 0x000fe20007f5e0ffULL,
0x0000000135177824ULL, 0x000fe200000e0653ULL, 0x0000004214147212ULL, 0x000fe200078efcffULL,
0x00000010584f7824ULL, 0x000fe200078e0247ULL, 0x0000003f36367210ULL, 0x000fe20007f1e0ffULL,
0x0000000137357824ULL, 0x000fe200010e0653ULL, 0x0000003f14147210ULL, 0x000fe20007f7e0ffULL,
0x000000103e3f7824ULL, 0x000fc400078e0247ULL, 0x000000013d377824ULL, 0x000fe400000e0653ULL,
0x00000010543d7824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163f7faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fe400018e0653ULL,
0x000000105a537824ULL, 0x000fe200078e0247ULL, 0x00000000343d7faeULL, 0x0003e8000b901c46ULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014537faeULL, 0x0003e4000b901c46ULL,
0x000000020c0c7836ULL, 0x000fe20000000000ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff4f7424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000003b0c00720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a45ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x000000010c178824ULL, 0x000fe400078e0205ULL,
0x0000000840167824ULL, 0x000fc400078e00ffULL, 0x0000000417148825ULL, 0x002fca00078e0014ULL,
0x00000006144f8981ULL, 0x000322000c1e1900ULL, 0xfffffff016177812ULL, 0x000fe200078ec0ffULL,
0x00000001ff167424ULL, 0x000fc800078e00ffULL, 0x0000000108547824ULL, 0x000fe200078e0217ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000816545479a7ULL, 0x0004e2000850003fULL,
0x017648164d1479a7ULL, 0x002464000850003fULL, 0x0000000000167805ULL, 0x004fce0000015200ULL,
0x017648154d0075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648154d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0004a20000000800ULL, 0x000000511600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x0000000207157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000084015ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154537a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176a857170075a7ULL, 0x000e620008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a857370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x0001300049497836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104e3c7824ULL, 0x000fd800078e0249ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000004b14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000104c347824ULL, 0x000fcc00078e0249ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x00000018ff5d7819ULL, 0x022fe2000001143cULL,
0x000001003c567824ULL, 0x040fe200078e00ffULL, 0x000088803c537816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d577824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x000088803d647816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff5b7819ULL, 0x000fe2000001143eULL,
0x0000005600667306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5a7819ULL, 0x000fe4000001143fULL, 0x000088803e5e7816ULL, 0x000fc400000000ffULL,
0x000088803f5f7816ULL, 0x040fe200000000ffULL, 0x0000003c00627306ULL, 0x000be20000200c00ULL,
0x000001003e567824ULL, 0x042fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x008fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011435ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000001003f3c7824ULL, 0x064fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000888037697816ULL, 0x000fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4c7819ULL, 0x000fe40000011436ULL,
0x00000018ff4d7819ULL, 0x000fc60000011437ULL, 0x0000005700677306ULL, 0x0004f00000200c00ULL,
0x0000003d00657306ULL, 0x000be20000200c00ULL, 0x0000888034577816ULL, 0x004fce00000000ffULL,
0x0000005600617306ULL, 0x0005e20000200c00ULL, 0x00000100343d7824ULL, 0x060fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00687306ULL, 0x000be20000200c00ULL, 0x0000888035567816ULL, 0x004fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000003e00607306ULL, 0x000fe20000200c00ULL,
0x00000100353c7824ULL, 0x060fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003f00637306ULL, 0x000fe20000200c00ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000005c005c7306ULL, 0x000eb00000200c00ULL, 0x00000034003e7306ULL, 0x0003f00000200c00ULL,
0x00000035003f7306ULL, 0x0007e20000200c00ULL, 0x0000541053347816ULL, 0x002fe20000000066ULL,
0x000000ffff537224ULL, 0x000fcc00078e0069ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x0000541064357816ULL, 0x008fce0000000067ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x0000010037357824ULL, 0x000fe200078e00ffULL,
0x0000541062347816ULL, 0x000fe2000000005dULL, 0x0000005b005b7306ULL, 0x000f660000200c00ULL,
0x00000018ff5d7819ULL, 0x000fc40000011435ULL, 0x0000541065357816ULL, 0x004fe2000000005cULL,
0x00010000365c7824ULL, 0x000fe400078e00ffULL, 0x0000005a005a7306ULL, 0x000ea60000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x00000034142c723cULL, 0x000fe8000000182cULL,
0x0000005700577306ULL, 0x000fe60000200c00ULL, 0x000054105e347816ULL, 0x002fe20000000061ULL,
0x00010000375e7824ULL, 0x000fe200078e00ffULL, 0x000054105f357816ULL, 0x008fc60000000068ULL,
0x0000003d00587306ULL, 0x0002e20000200c00ULL, 0x00000018ff5e7819ULL, 0x000fc6000001145eULL,
0x000000341430723cULL, 0x000fe80000001830ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000100363d7824ULL, 0x002fe400078e00ffULL, 0x0000541060347816ULL, 0x020fe4000000005bULL,
0x0000541063357816ULL, 0x004fe4000000005aULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005900597306ULL, 0x000e680000200c00ULL, 0x000000341428723cULL, 0x000fe80000001828ULL,
0x0000004b004b7306ULL, 0x000ea60000200c00ULL, 0x0000541057347816ULL, 0x008fc40000000058ULL,
0x000000070d587812ULL, 0x000fe400078ec0ffULL, 0x0000541056357816ULL, 0x002fe20000000059ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000000858587812ULL, 0x000fca00078ef80dULL,
0x000000341424723cULL, 0x000fe20000001824ULL, 0x000054103e3e7816ULL, 0x004fe2000000004bULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000002444b7836ULL, 0x000fe40000000000ULL,
0x0000000858587824ULL, 0x000fe400078e00ffULL, 0x0000020040347824ULL, 0x000fc600078e00ffULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0xfffffff8584b7812ULL, 0x000fe400078ee24bULL,
0xfffff80034347812ULL, 0x000fe400078ec0ffULL, 0x000054103c3c7816ULL, 0x002fc6000000003dULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000000834347c36ULL, 0x000fc80008000000ULL,
0x000000104b347824ULL, 0x000fe200078e0234ULL, 0x000054103f3f7816ULL, 0x004fe4000000004eULL,
0x0000004d004d7306ULL, 0x000fea0000200c00ULL, 0x0000003e1420723cULL, 0x000fe60000001820ULL,
0x0000005300537306ULL, 0x000ff00000200c00ULL, 0x0000005d00367306ULL, 0x000e700000200c00ULL,
0x0000005c00377306ULL, 0x000ea20000200c00ULL, 0x00005410533d7816ULL, 0x002fce0000000036ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x00005410374c7816ULL, 0x004fcc000000004cULL, 0x000000104a3c7824ULL, 0x000fe200078e0249ULL,
0x000054105e4d7816ULL, 0x002fce000000004dULL, 0x0000004c1410723cULL, 0x000fe20000001810ULL,
0x012000003414783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x084fe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000001048347824ULL, 0x002fcc00078e0249ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x00000018ff5b7819ULL, 0x008fe2000001143cULL, 0x000001003c4e7824ULL, 0x040fe200078e00ffULL,
0x000088803c597816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d637816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011453ULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x0000004e00647306ULL, 0x0007e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff587819ULL, 0x000fe4000001143fULL,
0x000088803e5d7816ULL, 0x040fe400000000ffULL, 0x000088803f5e7816ULL, 0x000fe200000000ffULL,
0x0000003c00627306ULL, 0x000be20000200c00ULL, 0x000001003e4e7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x002fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc40000011435ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000001003f3c7824ULL, 0x064fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888037687816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff4a7819ULL, 0x000fe40000011437ULL, 0x00000018ff487819ULL, 0x000fc60000011436ULL,
0x0000005300667306ULL, 0x0004f00000200c00ULL, 0x0000003d00657306ULL, 0x000be20000200c00ULL,
0x0000888034537816ULL, 0x004fce00000000ffULL, 0x0000004e00607306ULL, 0x0005e20000200c00ULL,
0x00000100343d7824ULL, 0x060fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00677306ULL, 0x000be20000200c00ULL,
0x00008880354e7816ULL, 0x004fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x00000100353c7824ULL, 0x060fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e005f7306ULL, 0x000fe20000200c00ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003f00617306ULL, 0x000ff00000200c00ULL,
0x00000034003f7306ULL, 0x0003f00000200c00ULL, 0x00000035003e7306ULL, 0x0007e20000200c00ULL,
0x0000541059347816ULL, 0x002fe20000000064ULL, 0x000000ffff597224ULL, 0x000fcc00078e0068ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000541063357816ULL, 0x008fe20000000066ULL,
0x0000010037637824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x0000541062347816ULL, 0x000fe2000000005bULL,
0x0000005a005a7306ULL, 0x000f620000200c00ULL, 0x0000541065357816ULL, 0x004fce000000005cULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x000054105d347816ULL, 0x002fe20000000060ULL,
0x0000005300537306ULL, 0x000fe60000200c00ULL, 0x00000018ff5b7819ULL, 0x000fc40000011435ULL,
0x000054105e357816ULL, 0x008fc60000000067ULL, 0x0000003d00567306ULL, 0x0002e80000200c00ULL,
0x000000341430723cULL, 0x000fe80000001830ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x00000100363d7824ULL, 0x002fe400078e00ffULL, 0x000054105f347816ULL, 0x020fc4000000005aULL,
0x0000541061357816ULL, 0x004fe40000000058ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011437ULL,
0x0000000807377c11ULL, 0x000fe2000f8e18ffULL, 0x000000341428723cULL, 0x000fe80000001828ULL,
0x0000004d004d7306ULL, 0x000ea60000200c00ULL, 0x0000541053347816ULL, 0x008fc40000000056ULL,
0x000054104e357816ULL, 0x002fc60000000057ULL, 0x0000003c003c7306ULL, 0x000fe80000200c00ULL,
0x000000341424723cULL, 0x000fe20000001824ULL, 0x000054103e4d7816ULL, 0x004fc6000000004dULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000001ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000000839347c11ULL, 0x000fca000f8e18ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0176c83e343479a7ULL, 0x000ea2000850003fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000006300367306ULL, 0x000e620000200c00ULL, 0x0176983e37ff79a7ULL, 0x0007ee000850003fULL,
0x0000004c004c7306ULL, 0x000f620000200c00ULL, 0x00005410593d7816ULL, 0x002fce0000000036ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x000054103f4c7816ULL, 0x020fcc000000004cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000004c1420723cULL, 0x000fee0000001820ULL, 0x0000005b005b7306ULL, 0x000e700000200c00ULL,
0x0000005800537306ULL, 0x000ee20000200c00ULL, 0x000054105b367816ULL, 0x002fc40000000048ULL,
0x0000541053377816ULL, 0x008fce000000004aULL, 0x000000361410723cULL, 0x004fde0000001810ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035460075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035460075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000104157836ULL, 0x000fca0000000000ULL,
0x000000381500720cULL, 0x000fda0003f06070ULL, 0x0000000400f80947ULL, 0x000fea0003800000ULL,
0x0000000204157836ULL, 0x000fe20000000000ULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000010052177836ULL, 0x000fe40000000000ULL, 0x000000054f3e7c24ULL, 0x010fe2000f8e02ffULL,
0x000000381500720cULL, 0x000fe40003f06070ULL, 0x0000006017157812ULL, 0x000fe200078ec0ffULL,
0x000000803e3e7824ULL, 0x000fc800078e00ffULL, 0x000000010a3c7824ULL, 0x000fcc00078e0215ULL,
0x0000000400048947ULL, 0x000fea0003800000ULL, 0x000000173a147248ULL, 0x000fe20007fe0000ULL,
0x0000001040157824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160dULL,
0x00009000ff347b82ULL, 0x000e640000000a00ULL, 0x0000000114147824ULL, 0x000fe200078e0a17ULL,
0x0000001015157812ULL, 0x000fe200078ec0ffULL, 0x0000000416177836ULL, 0x000fe40000000000ULL,
0x0000000816367836ULL, 0x000fe20000000000ULL, 0x0000001415147248ULL, 0x000fe20007fe0000ULL,
0x0000000117377824ULL, 0x000fc400078e0215ULL, 0x00000001363d7824ULL, 0x100fe400078e0215ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000c163f7836ULL, 0x000fe40000000000ULL,
0x00000008374d7824ULL, 0x040fe200078e00ffULL, 0x000000143600720cULL, 0x080fe20003f46070ULL,
0x0000000137367824ULL, 0x000fe200078e020dULL, 0x000000141600720cULL, 0x0c0fe20003f86070ULL,
0x0000000116167824ULL, 0x100fe200078e0215ULL, 0x000000141700720cULL, 0x080fe20003f66070ULL,
0x000000013f4a7824ULL, 0x040fe200078e0215ULL, 0xfffffff84d487812ULL, 0x000fe200078ee236ULL,
0x0000000116177824ULL, 0x040fe200078e020dULL, 0x000000143f00720cULL, 0x000fe20003f06070ULL,
0x0000000816467824ULL, 0x000fe200078e00ffULL, 0x000000343e3f7211ULL, 0x002fe200078a38ffULL,
0x0000000116367824ULL, 0x000fc400078e023cULL, 0x0000000137167824ULL, 0x100fe200078e023cULL,
0xfffffff846467812ULL, 0x000fe200078ee217ULL, 0x000000013d147824ULL, 0x040fe200078e023cULL,
0x000000353e4d7211ULL, 0x000fe200028f3cffULL, 0x000000013d157824ULL, 0x040fe400078e020dULL,
0x000000083d4c7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000014a3d7824ULL, 0x000fe200078e020dULL, 0x0000004236347212ULL, 0x000fe200078efcffULL,
0x000000084a4e7824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000343f347210ULL, 0x000fc60007fbe0ffULL, 0x000000014a3c7824ULL, 0x000fe200078e023cULL,
0xfffffff84c4a7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff84e4c7812ULL, 0x000fe400078ee23dULL, 0x0000004216167212ULL, 0x080fe200078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004214147212ULL, 0x080fe400078efcffULL,
0x0000003f16167210ULL, 0x000fe20007fde0ffULL, 0x0000000137357824ULL, 0x000fe200028e064dULL,
0x000000423c367212ULL, 0x000fe200078efcffULL, 0x0000001048537824ULL, 0x000fe200078e0249ULL,
0x0000003f14147210ULL, 0x000fe20007fbe0ffULL, 0x0000000117177824ULL, 0x000fe200030e064dULL,
0x0000003f36367210ULL, 0x000fe20007fde0ffULL, 0x00000010463f7824ULL, 0x000fc400078e0249ULL,
0x000000104a577824ULL, 0x000fe400078e0249ULL, 0x0000000115157824ULL, 0x000fe200028e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000e101c46ULL,
0x000000104c497824ULL, 0x000fe400078e0249ULL, 0x000000013d377824ULL, 0x000fe200030e064dULL,
0x0000000016537faeULL, 0x0003e8000d901c46ULL, 0x0000000014577faeULL, 0x0003e8000d101c46ULL,
0x0000000036497faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001040147824ULL, 0x000fca00078e00ffULL, 0x0000001014147812ULL, 0x000fc800078ec0ffULL,
0x000000140d177211ULL, 0x000fe400078fe8ffULL, 0x00009000ff147b82ULL, 0x000e660000000a00ULL,
0x0000000117167824ULL, 0x040fe400078e020dULL, 0x0000000817377824ULL, 0x040fe400078e00ffULL,
0x0000000417357836ULL, 0x000fe40000000000ULL, 0x00000008173d7836ULL, 0x000fe20000000000ULL,
0xfffffff837467812ULL, 0x000fe200078ee216ULL, 0x0000000117167824ULL, 0x000fc400078e023cULL,
0x0000000c17177836ULL, 0x000fe40000000000ULL, 0x0000000135347824ULL, 0x140fe400078e023cULL,
0x0000000135377824ULL, 0x140fe400078e020dULL, 0x0000000835487824ULL, 0x000fe400078e00ffULL,
0x000000013d367824ULL, 0x140fe400078e023cULL, 0x000000013d357824ULL, 0x140fe200078e020dULL,
0x000000143e3f7211ULL, 0x042fe200078038ffULL, 0x000000083d4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee237ULL, 0x00000001173c7824ULL, 0x040fe200078e023cULL,
0x000000153e4d7211ULL, 0x000fe200000f3cffULL, 0x00000001173d7824ULL, 0x040fe200078e020dULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL, 0x00000008174c7824ULL, 0x000fc400078e00ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee23dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004216147212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x000fe40007f1e0ffULL,
0x0000004234167212ULL, 0x080fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004236347212ULL, 0x000fc600078efcffULL, 0x0000000117157824ULL, 0x000fe200000e064dULL,
0x000000423c367212ULL, 0x000fe200078efcffULL, 0x0000001048537824ULL, 0x100fe200078e0249ULL,
0x000000163f167210ULL, 0x000fe20007f1e0ffULL, 0x000000104a577824ULL, 0x100fe200078e0249ULL,
0x000000343f347210ULL, 0x000fe40007f5e0ffULL, 0x000000363f367210ULL, 0x000fe20007f7e0ffULL,
0x00000010463f7824ULL, 0x000fe400078e0249ULL, 0x0000000135177824ULL, 0x000fc400000e064dULL,
0x0000000137357824ULL, 0x000fe200010e064dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143f7faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fe400078e0249ULL,
0x000000013d377824ULL, 0x000fe200018e064dULL, 0x0000000016537faeULL, 0x0003e8000b901c46ULL,
0x0000000034577faeULL, 0x0003e8000b901c46ULL, 0x0000000036497faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000839487c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a835484879a7ULL, 0x0002a4000850003fULL,
0x01766835063479a7ULL, 0x0022e4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01766835060075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835060075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000000807157c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0x0000018042147810ULL, 0x000fca0007ffe015ULL,
0x0000000145147824ULL, 0x000fca00078e0214ULL, 0x0170000014167984ULL, 0x000ee80000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000511600720bULL, 0x008fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x026fea0003800000ULL, 0x0000000307157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000084015ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154545a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400144500a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fe20000010000ULL,
0x00000008393d7c11ULL, 0x000fce000f8e20ffULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0176b0553d0075a7ULL, 0x000e62000800017fULL, 0x0000000440167824ULL, 0x000fe400078e00ffULL,
0x0000000409357824ULL, 0x000fc600078e00ffULL, 0x0000000416167812ULL, 0x000fca00078ec0ffULL,
0x0000000216367836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x0176b0553d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000070d467812ULL, 0x040fe200078ec0ffULL,
0x00000003075c7836ULL, 0x000fe20000000000ULL, 0x000000080d457812ULL, 0x040fe400078ec0ffULL,
0x0000991034157816ULL, 0x000fe400000000ffULL, 0x000000350d487211ULL, 0x000fe400078fe0ffULL,
0x0000000846147812ULL, 0x000fe400078ef80dULL, 0x0000004645357212ULL, 0x000fc400078efcffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0x000000085c5c7c11ULL, 0x000fe2000f8e58ffULL, 0x0000000135147824ULL, 0x040fe400078e0248ULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0xfffffff817157812ULL, 0x000fc800078ee244ULL,
0xfffffff837167812ULL, 0x000fe200078ee214ULL, 0x0000001015147824ULL, 0x000fc800078e025cULL,
0x00000010163c7824ULL, 0x000fe200078e0247ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff167819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000816347836ULL, 0x000fe20000000000ULL, 0x0000541000157816ULL, 0x000fca0000000000ULL,
0x00001f1615037589ULL, 0x0002a800000e0000ULL, 0x00001f3415007589ULL, 0x0002e400000e0000ULL,
0x011000001414783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x088fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000360d427211ULL, 0x000fe200078fe0ffULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x0000000135347824ULL, 0x040fe400078e0242ULL, 0x0000000835357824ULL, 0x000fca00078e00ffULL,
0xfffffff835347812ULL, 0x000fca00078ee234ULL, 0x0000001034347824ULL, 0x000fcc00078e0247ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x000001003d527824ULL, 0x068fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001143dULL, 0x000001003c4e7824ULL, 0x040fe200078e00ffULL,
0x000088803d627816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x00000018ff577819ULL, 0x000fe2000001143cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000088803c5f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc4000001143fULL,
0x000088803f607816ULL, 0x040fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000005200677306ULL, 0x0007e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff667819ULL, 0x000fe4000001143cULL, 0x00000018ff5a7819ULL, 0x000fe4000001143eULL,
0x000088803e3c7816ULL, 0x000fe200000000ffULL, 0x0000004e00647306ULL, 0x000be20000200c00ULL,
0x000001003f527824ULL, 0x048fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x004fe20000011434ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000888034567816ULL, 0x000fc400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011435ULL, 0x0000003d00637306ULL, 0x0005e20000200c00ULL,
0x000001003e4e7824ULL, 0x062fe200078e00ffULL, 0x0000888035547816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x004fe2000001143fULL,
0x00000100343f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011436ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fc40000011437ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x00000018ff347819ULL, 0x000fce0000011434ULL, 0x0000003e005d7306ULL, 0x0005f00000200c00ULL,
0x0000003400557306ULL, 0x0007e20000200c00ULL, 0x00000100353e7824ULL, 0x044fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001143eULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000010037347824ULL, 0x008fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880363e7816ULL, 0x000fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006600667306ULL, 0x000eb00000200c00ULL,
0x0000005200657306ULL, 0x000ff00000200c00ULL, 0x0000003500527306ULL, 0x0003f00000200c00ULL,
0x0000003400537306ULL, 0x0007e20000200c00ULL, 0x0000541062357816ULL, 0x002fce0000000067ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105f347816ULL, 0x008fce0000000064ULL,
0x0000004e00617306ULL, 0x0002e20000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x0000005a005a7306ULL, 0x000f620000200c00ULL, 0x00008880374e7816ULL, 0x042fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000541066347816ULL, 0x004fc40000000057ULL,
0x0000541063357816ULL, 0x000fc6000000005eULL, 0x0000005800587306ULL, 0x000fe80000200c00ULL,
0x00000034142c723cULL, 0x000fe8000000182cULL, 0x0000003d003d7306ULL, 0x000e660000200c00ULL,
0x000054103c347816ULL, 0x008fc40000000061ULL, 0x000054105d3c7816ULL, 0x020fc6000000005aULL,
0x0000003f00597306ULL, 0x0005e20000200c00ULL, 0x000054103d3d7816ULL, 0x002fce0000000058ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x00000100363f7824ULL, 0x044fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003c1428723cULL, 0x000fe20000001828ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe20000011436ULL, 0x000000104b367824ULL, 0x000fe200078e025cULL,
0x00000018ff4b7819ULL, 0x000fc60000011437ULL, 0x00005410563c7816ULL, 0x002fe40000000059ULL,
0x0000005b005b7306ULL, 0x000e700000200c00ULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x00005410543d7816ULL, 0x002fce000000005bULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000003c1424723cULL, 0x000fe20000001824ULL, 0x0000541060357816ULL, 0x004fcc0000000065ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000000341430723cULL, 0x000fee0000001830ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x011000003634783bULL, 0x000ee20000000200ULL,
0x000054103e3e7816ULL, 0x002fcc000000003fULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x00005410554c7816ULL, 0x004fce000000004cULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x00005410524d7816ULL, 0x002fce000000004dULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000004c1420723cULL, 0x000fee0000001820ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000005f00577306ULL, 0x000ea20000200c00ULL, 0x000054104e3f7816ULL, 0x002fce0000000053ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x0000003e141c723cULL, 0x000fe2000000181cULL,
0x00005410573c7816ULL, 0x004fe40000000044ULL, 0x000054104b3d7816ULL, 0x002fce000000004aULL,
0x0000003c1410723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x008fde0003800000ULL, 0x0000000334347232ULL, 0x080fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x0000001045457812ULL, 0x000fe200078efe46ULL,
0x0000000104047836ULL, 0x000fc80000000000ULL, 0x0000000145487824ULL, 0x040fe400078e0248ULL,
0x0000000845157824ULL, 0x040fe400078e00ffULL, 0x0000000145427824ULL, 0x040fe400078e0242ULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0xfffffff815487812ULL, 0x000fc800078ee248ULL,
0xfffffff845427812ULL, 0x000fe200078ee242ULL, 0x00000010483c7824ULL, 0x000fc800078e0247ULL,
0x0000001042147824ULL, 0x000fe400078e0247ULL, 0x000000003c3c783bULL, 0x000e680000004200ULL,
0x000000001414783bULL, 0x000ea20000004200ULL, 0x00000018ff4a7819ULL, 0x002fe2000001143cULL,
0x000001003c4c7824ULL, 0x040fe200078e00ffULL, 0x000088803c4d7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001143dULL,
0x000001003d4e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000001003e527824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x000088803d567816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x00000100165e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc40000011452ULL,
0x00000018ff487819ULL, 0x000fe2000001143eULL, 0x0000003c005b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff477819ULL, 0x000fe4000001143fULL, 0x000088803f527816ULL, 0x040fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff457819ULL, 0x000fe20000011414ULL,
0x0000004c00547306ULL, 0x0004e20000200c00ULL, 0x000001003f3c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011415ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc40000011416ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000088803e4c7816ULL, 0x044fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001143fULL,
0x00008880153f7816ULL, 0x000fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe2000001143eULL,
0x0000004e005f7306ULL, 0x000e620000200c00ULL, 0x00008880143e7816ULL, 0x000fc400000000ffULL,
0x0000888017607816ULL, 0x000fe400000000ffULL, 0x00000018ff447819ULL, 0x000fe40000011417ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000003d005c7306ULL, 0x0005f00000200c00ULL,
0x0000003c005d7306ULL, 0x000be20000200c00ULL, 0x00000100143d7824ULL, 0x004fc400078e00ffULL,
0x0001000014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000100153c7824ULL, 0x060fe200078e00ffULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000004b004b7306ULL, 0x000f700000200c00ULL, 0x00000014004e7306ULL, 0x0007f00000200c00ULL,
0x0000001500577306ULL, 0x0003e20000200c00ULL, 0x000054104d147816ULL, 0x008fe20000000054ULL,
0x000000ffff4d7224ULL, 0x000fcc00078e0060ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541056157816ULL, 0x002fce000000005fULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000000143418723cULL, 0x000fee0000001818ULL, 0x0000005200527306ULL, 0x000ee20000200c00ULL,
0x0000010017157824ULL, 0x000fe200078e00ffULL, 0x000054105b147816ULL, 0x004fc8000000004aULL,
0x00000018ff4a7819ULL, 0x000fe40000011415ULL, 0x000054105c157816ULL, 0x020fe2000000004bULL,
0x0000004800487306ULL, 0x000fec0000200c00ULL, 0x00000014342c723cULL, 0x000fe4000000182cULL,
0x0000005900597306ULL, 0x000eaa0000200c00ULL, 0x000054104c147816ULL, 0x002fc40000000055ULL,
0x0000541052157816ULL, 0x008fe2000000005dULL, 0x0000004700477306ULL, 0x000fec0000200c00ULL,
0x000000143430723cULL, 0x000fe40000001830ULL, 0x0000005a005a7306ULL, 0x000e6a0000200c00ULL,
0x0001000017157824ULL, 0x000fe200078e00ffULL, 0x0000541059147816ULL, 0x004fc40000000048ULL,
0x0000003e003e7306ULL, 0x000fe40000200c00ULL, 0x00000018ff487819ULL, 0x000fe40000011415ULL,
0x000054105a157816ULL, 0x002fc80000000047ULL, 0x0000003d00537306ULL, 0x0002a60000200c00ULL,
0x000000143428723cULL, 0x000fea0000001828ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x00008880163d7816ULL, 0x042fe200000000ffULL, 0x0001000016167824ULL, 0x000fc400078e00ffULL,
0x0000000439147836ULL, 0x000fe20000000000ULL, 0x000054103e3e7816ULL, 0x004fc60000000053ULL,
0x0000003c00587306ULL, 0x000e620000200c00ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000000814147c11ULL, 0x000fca000f8e18ffULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000054103f3f7816ULL, 0x002fce0000000058ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000003e3424723cULL, 0x000fee0000001824ULL, 0x0000005e003c7306ULL, 0x000e620000200c00ULL,
0x00000001ff3f7424ULL, 0x000fce00078e00ffULL, 0x0000001600177306ULL, 0x000ea20000200c00ULL,
0x0176a83f141479a7ULL, 0x000ee2000850003fULL, 0x000054103d3c7816ULL, 0x002fcc000000003cULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541017167816ULL, 0x004fce0000000042ULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x000054104e567816ULL, 0x002fce0000000045ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000000807147c11ULL, 0x008fc8000f8e18ffULL,
0x0176a03f14ff79a7ULL, 0x0003e2000850003fULL, 0x0000541057577816ULL, 0x004fe40000000046ULL,
0x0000004d004d7306ULL, 0x000fea0000200c00ULL, 0x000000563420723cULL, 0x000fe60000001820ULL,
0x0000004a004a7306ULL, 0x000eb00000200c00ULL, 0x0000004800477306ULL, 0x000ee20000200c00ULL,
0x000054104d3d7816ULL, 0x004fce000000004aULL, 0x0000003c341c723cULL, 0x000fe2000000181cULL,
0x0000541047177816ULL, 0x008fce0000000044ULL, 0x000000163410723cULL, 0x000fee0000001810ULL,
0x000000ffff347224ULL, 0x000fe200078e0015ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff7000a09947ULL, 0x002fde000383ffffULL, 0x000000ff3800720cULL, 0x000fe20003f05270ULL,
0x000000ffff347224ULL, 0x000fe400078e0025ULL, 0x000000ffff257224ULL, 0x000fe400078e0024ULL,
0x000000ffff247224ULL, 0x000fe400078e001bULL, 0x000000ffff167224ULL, 0x000fe400078e001aULL,
0x000000ffff1b7224ULL, 0x000fc800078e0019ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000ab9000047802ULL, 0x000fce0000000f00ULL,
0x0000008400087944ULL, 0x016fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005000037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000050ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001605167220ULL, 0x044fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000202120723eULL, 0x000fe400000000ffULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000101110723eULL, 0x000fc400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000000121312723eULL, 0x000fe400000000ffULL, 0x000000ff3900720cULL, 0x000fc40003f05270ULL,
0x00000002ff057819ULL, 0x108fe20000011600ULL, 0x000000010b0b7824ULL, 0x000fe200078e0200ULL,
0x0000000200027812ULL, 0x042fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe400078e00ffULL,
0x0000000805077824ULL, 0x000fc400078e00ffULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff80d147812ULL, 0x000fe200078ee204ULL, 0x0000000805047824ULL, 0x040fe400078e00ffULL,
0x00000008050d7824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x0000000403067836ULL, 0x000fe20000000000ULL, 0x0000000809027c11ULL, 0x000fe2000f8e60ffULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee206ULL,
0x0000080039037824ULL, 0x100fe200078e0202ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100b0b7824ULL, 0x000fe200078e0202ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001014197824ULL, 0x100fe200078e0203ULL, 0x000054101e147816ULL, 0x000fe20000000012ULL,
0x00000010080d7824ULL, 0x000fc400078e0203ULL, 0x000000100a157824ULL, 0x100fe400078e0203ULL,
0x000000100c177824ULL, 0x000fe200078e0203ULL, 0x000000181b03723eULL, 0x000fe200000000ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000253405723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x040fe200078e0219ULL, 0x00005410031a7816ULL, 0x140fe20000000004ULL,
0x00000001060d7824ULL, 0x040fe200078e020dULL, 0x00007632031b7816ULL, 0x000fe20000000004ULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x000000303103723eULL, 0x000fe200000000ffULL,
0x0000000106177824ULL, 0x000fe200078e0217ULL, 0x000000282904723eULL, 0x000fe200000000ffULL,
0x0000001a07007388ULL, 0x0003e20000000a00ULL, 0x0000002a2b19723eULL, 0x000fc400000000ffULL,
0x0000541003067816ULL, 0x040fe40000000004ULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x00005410260c7816ULL, 0x000fe40000000022ULL,
0x0000763203077816ULL, 0x002fe40000000004ULL, 0x000000162403723eULL, 0x000fc400000000ffULL,
0x0000002e2f04723eULL, 0x000fe200000000ffULL, 0x000000060d007388ULL, 0x0003e40000000a00ULL,
0x0000541005067816ULL, 0x142fe40000000020ULL, 0x0000763205077816ULL, 0x000fca0000000020ULL,
0x0000000615007388ULL, 0x0003e40000000a00ULL, 0x000054101c067816ULL, 0x142fe40000000010ULL,
0x000076321c077816ULL, 0x000fca0000000010ULL, 0x0000000617007388ULL, 0x0003e40000000a00ULL,
0x0000541003067816ULL, 0x142fe40000000004ULL, 0x0000763203077816ULL, 0x000fca0000000004ULL,
0x0000000608007388ULL, 0x000fe80000000a00ULL, 0x000400180d007388ULL, 0x0003e40000000a00ULL,
0x00007632260d7816ULL, 0x002fca0000000022ULL, 0x0004000c15007388ULL, 0x0003e40000000a00ULL,
0x000076321e157816ULL, 0x002fca0000000012ULL, 0x0004001417007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000b047984ULL, 0x000e680000000c00ULL,
0x000400000b187984ULL, 0x000ee80000000c00ULL, 0x000800000b107984ULL, 0x000f680000000c00ULL,
0x000c00000b1c7984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x008fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x024fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x000000040b007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fca0000000000ULL,
0x000400180b007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x002fc80000011600ULL,
0x0000000f0600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x00000008ff0b7c12ULL, 0x000fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe080a7836ULL, 0x002fcc0000000000ULL,
0x0000000a00057305ULL, 0x0002a4000021f000ULL, 0x00000007000a7812ULL, 0x002fe200078ec0ffULL,
0x000000ffff037224ULL, 0x004fc800078e0a05ULL, 0x0000000803037c24ULL, 0x000fc8000f8e02ffULL,
0x00000003050c7227ULL, 0x000fc800078e0004ULL, 0x0000000141037824ULL, 0x000fc800078e0206ULL,
0x000000030c077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x0000000804057c24ULL, 0x000fe4000f8e0203ULL, 0x0000000106047824ULL, 0x000fc600078e0200ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000006107984ULL, 0x0002a40000000c00ULL,
0x000000070b047207ULL, 0x000fca0004000000ULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e0243ULL, 0x0000000808037c24ULL, 0x000fe4000f8e0203ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000804037c24ULL, 0x000fca000f8e0203ULL,
0x000000030e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f4408ULL,
0x0000000809037824ULL, 0x000fe200078e020aULL, 0x00000003ff087819ULL, 0x000fc60000011606ULL,
0x0000001003047825ULL, 0x000fe200078e0004ULL, 0x0000000f0800720cULL, 0x000fc80003f26070ULL,
0x0000001004007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000141037824ULL, 0x100fe400078e0208ULL, 0x0000000106087824ULL, 0x000fe400078e0208ULL,
0x000000030c047227ULL, 0x002fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a04ULL,
0x000000080a057c24ULL, 0x000fca000f8e0203ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000104041836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0000000708057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001005077824ULL, 0x000fe400078e0202ULL, 0x0000000104042836ULL, 0x000fc60000000000ULL,
0x0000000007107984ULL, 0x0002a40000000c00ULL, 0x000000040b047207ULL, 0x000fca0004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0243ULL,
0x0000000808037c24ULL, 0x000fe4000f8e0203ULL, 0x0000004000077836ULL, 0x002fe40000000000ULL,
0x0000000804037c24ULL, 0x000fca000f8e0203ULL, 0x000000030e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000000403047c11ULL, 0x000fc8000f8240ffULL,
0x0000000503057c11ULL, 0x000fe200088f4408ULL, 0x0000000809037824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fc60000011607ULL, 0x0000001003047825ULL, 0x000fe200078e0004ULL,
0x0000000f0600720cULL, 0x000fc80003f26070ULL, 0x0000001004007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000141037824ULL, 0x100fe400078e0206ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x000000030c047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x0000006000007836ULL, 0x000fe40000000000ULL, 0x0000000808057c24ULL, 0x000fca000f8e0203ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006107984ULL, 0x0002a20000000c00ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x000000040b047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011600ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0243ULL,
0x0000000808037c24ULL, 0x000fe2000f8e0203ULL, 0x0000000707087812ULL, 0x000fe200078ec0ffULL,
0x0000000141417824ULL, 0x000fe400078e0206ULL, 0x0000000804037c24ULL, 0x000fca000f8e0203ULL,
0x000000030e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f440aULL,
0x0000000809037824ULL, 0x000fe200078e0208ULL, 0x0000000f0600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000410c087227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a08ULL, 0x0000000100067824ULL, 0x000fe400078e0206ULL,
0x0000000804037c24ULL, 0x000fca000f8e0241ULL, 0x0000000803007c0cULL, 0x000fda000bf26070ULL,
0x8000000803031c36ULL, 0x000fe40008000000ULL, 0x0000000108081836ULL, 0x000fc60000000000ULL,
0x0000000803007c0cULL, 0x000fe4000bf46070ULL, 0x0000000706037812ULL, 0x000fc800078ec0ffULL,
0xfffffff803037812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe400078e0202ULL, 0x0000000108082836ULL, 0x000fe40000000000ULL,
0x0000000809097824ULL, 0x000fe400078e0200ULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x000000080b087207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a08ULL,
0x0000000908087c24ULL, 0x000fe4000f8e0243ULL, 0x0000000802417c24ULL, 0x000fc8000f8e0241ULL,
0x0000000808417c24ULL, 0x000fca000f8e0241ULL, 0x000000410e417210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000441027c11ULL, 0x000fc8000f8040ffULL,
0x0000000541037c11ULL, 0x000fc600080f4408ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7819ULL, 0x000fe20000011640ULL, 0x00009a00ff107b82ULL, 0x000e620000000a00ULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000003b0c00720cULL, 0x000fda0003f06070ULL,
0x00009600ff068b82ULL, 0x000ea20000000800ULL, 0x0000000235058824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ee20000000a00ULL, 0x0000000610347981ULL, 0x002322000c1e9900ULL,
0x0000000605058224ULL, 0x004fe400078e020cULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x00000004050a8825ULL, 0x008fc800078e000aULL, 0x01760006ff0679a7ULL, 0x000e620008500008ULL,
0x000000060a318981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000008043437824ULL, 0x000fe400078e00ffULL, 0x0000004040087824ULL, 0x000fe400078e00ffULL,
0x0000008000007824ULL, 0x000fc600078e00ffULL, 0x00000040430e7812ULL, 0x000fe200078ef808ULL,
0x0000003100317224ULL, 0x004fc800078e02ffULL, 0x0000000c002c0947ULL, 0x002fea0003800000ULL,
0x00009000ff107b82ULL, 0x000e620000000a00ULL, 0x00000003ff1c7819ULL, 0x000fe4000001160dULL,
0x000000083a1d7248ULL, 0x000fc60007fe0000ULL, 0x000000041c127836ULL, 0x000fe40000000000ULL,
0x000000081c167836ULL, 0x000fe40000000000ULL, 0x0000000112057824ULL, 0x140fe400078e020dULL,
0x0000000812227824ULL, 0x000fe400078e00ffULL, 0x000000010e0a7824ULL, 0x000fe400078e021cULL,
0x0000000116097824ULL, 0x040fe200078e020dULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x0000000816247824ULL, 0x000fc400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x000000101c147836ULL, 0x000fe20000000000ULL,
0x0000001031057211ULL, 0x002fe200078038ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a08ULL,
0x000000700a1e7812ULL, 0x000fe200078ef802ULL, 0x00000001140a7824ULL, 0x040fe200078e020dULL,
0x0000001131097211ULL, 0x000fe200000f3cffULL, 0x0000000814117824ULL, 0x000fe200078e00ffULL,
0x0000001e051e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010e107824ULL, 0x000fe200078e0216ULL,
0x0000001d1200720cULL, 0x080fe20003fa6070ULL, 0x0000000c1c187836ULL, 0x000fe20000000000ULL,
0xfffffff811287812ULL, 0x000fe200078ee20aULL, 0x000000010e0a7824ULL, 0x000fe200078e0212ULL,
0x0000001d1600720cULL, 0x080fe20003f26070ULL, 0x000000010b1f7824ULL, 0x000fe200000e0609ULL,
0x0000001d1800720cULL, 0x080fe20003f46070ULL, 0x000000141c2a7836ULL, 0x000fe20000000000ULL,
0x0000001d1400720cULL, 0x000fe20003f06070ULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700a1a7812ULL, 0x000fc600078ef802ULL,
0x000000010e127824ULL, 0x040fe200078e0218ULL, 0x000000051a1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010e207824ULL, 0x000fe400078e022aULL, 0x00000001180f7824ULL, 0x040fe400078e020dULL,
0x0000000818267824ULL, 0x000fe400078e00ffULL, 0x000000010e187824ULL, 0x000fe200078e0214ULL,
0x0000007010147812ULL, 0x000fe200078ef802ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fc400078ee20fULL, 0x0000000514147210ULL, 0x000fe20007f9e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000007012167812ULL, 0x000fe400078ef802ULL,
0x00000008400f7c11ULL, 0x000fe2000f8e70ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000070200a7812ULL, 0x000fc600078ef802ULL, 0x000000010b1b7824ULL, 0x100fe200018e0609ULL,
0x0000000516167210ULL, 0x000fe20007f7e0ffULL, 0x0000000111157824ULL, 0x000fe200020e0609ULL,
0x0000007018107812ULL, 0x000fe200078ef802ULL, 0x000000011c187824ULL, 0x000fe200078e020dULL,
0x000000050a0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000181c207836ULL, 0x000fe40000000000ULL,
0x0000000113177824ULL, 0x100fe200018e0609ULL, 0x0000000510107210ULL, 0x000fe20007f7e0ffULL,
0x000000010e127824ULL, 0x000fe200078e0220ULL, 0x00000007182c7812ULL, 0x000fe200078ec0ffULL,
0x00000001210b7824ULL, 0x000fe200020e0609ULL, 0x0000001d1c00720cULL, 0x000fe20003f86070ULL,
0x0000001c1c2e7836ULL, 0x000fe20000000000ULL, 0x0ffffff82c2c7812ULL, 0x000fe200078ef80dULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000012a187824ULL, 0x040fe200078e020dULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x000000082a217824ULL, 0x040fe400078e00ffULL,
0x0000000119117824ULL, 0x000fe200018e0609ULL, 0x0000001d2a00720cULL, 0x000fe20003f66070ULL,
0x000010000f0f7836ULL, 0x000fe20000000000ULL, 0xfffffff8212a7812ULL, 0x000fe200078ee218ULL,
0x000000010e197824ULL, 0x000fe200078e022eULL, 0x0000000512127210ULL, 0x000fe20007fde0ffULL,
0x000000201c307836ULL, 0x000fc40000000000ULL, 0x000000102c237824ULL, 0x000fe400078e020fULL,
0x0000008019187825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000e101c46ULL, 0x000000010e217824ULL, 0x000fe200078e0230ULL,
0x0000001d2000720cULL, 0x040fe20003f86070ULL, 0x000000241c327836ULL, 0x000fe20000000000ULL,
0x0000007018187812ULL, 0x000fe200078ef802ULL, 0x0000000120257824ULL, 0x040fe400078e020dULL,
0x00000008202c7824ULL, 0x000fe400078e00ffULL, 0x0000008021207825ULL, 0x000fc600078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee225ULL, 0x0000000113137824ULL, 0x000fe200030e0609ULL,
0x0000000518187210ULL, 0x000fe20007fde0ffULL, 0x000000010e277824ULL, 0x000fe200078e0232ULL,
0x00000070201e7812ULL, 0x002fe200078ef802ULL, 0x0000001022257824ULL, 0x000fe400078e020fULL,
0x0000008027227825ULL, 0x000fc600078e00ffULL, 0x000000001a257faeULL, 0x0003e2000e901c46ULL,
0x0000000119197824ULL, 0x000fe200030e0609ULL, 0x000000051e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000012e277824ULL, 0x040fe200078e020dULL, 0x0000007022207812ULL, 0x000fe200078ef802ULL,
0x000000082e227824ULL, 0x040fe200078e00ffULL, 0x0000001d2e00720cULL, 0x000fe20003fa6070ULL,
0x00000001211f7824ULL, 0x000fe200030e0609ULL, 0x0000000520207210ULL, 0x000fe20007fde0ffULL,
0x000000281c2e7836ULL, 0x000fe20000000000ULL, 0xfffffff822227812ULL, 0x000fe200078ee227ULL,
0x0000001024277824ULL, 0x000fc400078e020fULL, 0x0000000123217824ULL, 0x000fe400030e0609ULL,
0x0000001026237824ULL, 0x000fe200078e020fULL, 0x0000000014277faeULL, 0x0005e2000c901c46ULL,
0x0000000132257824ULL, 0x102fe200078e020dULL, 0x0000001d3000720cULL, 0x0c0fe20003f26070ULL,
0x0000000130247824ULL, 0x000fe200078e020dULL, 0x0000000016237faeULL, 0x0003e2000d101c46ULL,
0x0000001d3200720cULL, 0x040fe20003f46070ULL, 0x0000000832327824ULL, 0x000fe400078e00ffULL,
0x0000000830297824ULL, 0x000fc400078e00ffULL, 0x000000010e1a7824ULL, 0x000fe200078e022eULL,
0xfffffff832147812ULL, 0x004fe200078ee225ULL, 0x0000001028157824ULL, 0x000fe200078e020fULL,
0xfffffff829247812ULL, 0x000fe200078ee224ULL, 0x000000801a1a7825ULL, 0x000fc600078e00ffULL,
0x0000000010157faeULL, 0x0005e2000c101c46ULL, 0x0000002c1c167836ULL, 0x002fe20000000000ULL,
0x000000701a1a7812ULL, 0x000fe200078ef802ULL, 0x000000102a177824ULL, 0x100fe400078e020fULL,
0x0000001014297824ULL, 0x100fe200078e020fULL, 0x000000051a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000001022257824ULL, 0x000fe200078e020fULL, 0x000000000a177faeULL, 0x0003e2000d901c46ULL,
0x000000010e147824ULL, 0x000fe400078e0216ULL, 0x000000301c227836ULL, 0x000fc40000000000ULL,
0x000000102c237824ULL, 0x100fe400078e020fULL, 0x000000010e107824ULL, 0x004fe200078e0222ULL,
0x0000001d2200720cULL, 0x080fe20003f66070ULL, 0x0000001024277824ULL, 0x000fe200078e020fULL,
0x0000000012237faeULL, 0x0005e2000e101c46ULL, 0x000000341c247836ULL, 0x000fe20000000000ULL,
0x0000001d1600720cULL, 0x080fe20003f86070ULL, 0x00000080140a7825ULL, 0x002fe200078e00ffULL,
0x0000000018257faeULL, 0x0003e2000e901c46ULL, 0x0000001d2e00720cULL, 0x000fc40003fa6070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef802ULL,
0x000000001e277faeULL, 0x0007e4000c901c46ULL, 0x000000011b1b7824ULL, 0x000fe200030e0609ULL,
0x000000050a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000010e127824ULL, 0x004fe200078e0224ULL,
0x0000007010147812ULL, 0x000fe200078ef802ULL, 0x0000000122107824ULL, 0x040fe200078e020dULL,
0x0000000020297faeULL, 0x0005e2000d101c46ULL, 0x0000000822197824ULL, 0x002fe200078e00ffULL,
0x0000001d2400720cULL, 0x000fe20003f46070ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8191e7812ULL, 0x008fe200078ee210ULL, 0x000000381c267836ULL, 0x000fe40000000000ULL,
0x0000003c1c287836ULL, 0x000fe40000000000ULL, 0x000000010b0b7824ULL, 0x000fe200030e0609ULL,
0x0000000514147210ULL, 0x000fe20007fde0ffULL, 0x000000012e157824ULL, 0x100fe200078e020dULL,
0x0000001d2800720cULL, 0x080fe20003f06070ULL, 0x000000082e187824ULL, 0x000fe200078e00ffULL,
0x0000001d2600720cULL, 0x000fe20003f26070ULL, 0x0000000116177824ULL, 0x000fc400078e020dULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0x0000007012167812ULL, 0x000fe200078ef802ULL,
0x000000010e107824ULL, 0x000fe200078e0226ULL, 0xfffffff818187812ULL, 0x000fe200078ee215ULL,
0x0000000111157824ULL, 0x000fe200030e0609ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x0000000124127824ULL, 0x040fe200078e020dULL, 0x0000000516167210ULL, 0x000fe20007fde0ffULL,
0x0000000824177824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff817207812ULL, 0x004fe200078ee212ULL, 0x000000010e197824ULL, 0x000fe200078e0228ULL,
0x0000007010107812ULL, 0x000fe200078ef802ULL, 0x0000000113177824ULL, 0x000fe400030e0609ULL,
0x0000008019127825ULL, 0x000fe200078e00ffULL, 0x0000000510107210ULL, 0x000fc60007fde0ffULL,
0x00000001260e7824ULL, 0x140fe200078e020dULL, 0x0000007012227812ULL, 0x000fe200078ef802ULL,
0x0000000826197824ULL, 0x000fe400078e00ffULL, 0x00000001280d7824ULL, 0x040fe400078e020dULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0xfffffff819027812ULL, 0x000fe200078ee20eULL,
0x0000000111117824ULL, 0x000fe200030e0609ULL, 0x00000005220e7210ULL, 0x000fe20007fde0ffULL,
0x0000001018057824ULL, 0x100fe200078e020fULL, 0xfffffff828127812ULL, 0x000fe200078ee20dULL,
0x000000101c0d7824ULL, 0x000fc400078e020fULL, 0x000000101e197824ULL, 0x100fe200078e020fULL,
0x000000001a057faeULL, 0x0003e2000e901c46ULL, 0x00000010201d7824ULL, 0x100fe400078e020fULL,
0x00000010021f7824ULL, 0x100fe200078e020fULL, 0x000000000a0d7faeULL, 0x0003e2000e101c46ULL,
0x0000001012217824ULL, 0x000fe400078e020fULL, 0x00000001130f7824ULL, 0x000fe200030e0609ULL,
0x0000000014197faeULL, 0x0003e8000d901c46ULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x00000000101f7faeULL, 0x0003e8000c901c46ULL, 0x000000000e217faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x000000080d137811ULL, 0x040fe400078fe8ffULL,
0x0000000c0d147811ULL, 0x040fe400078fe8ffULL, 0x000000100d157811ULL, 0x000fe200078fe8ffULL,
0x00000001130a7824ULL, 0x100fe200078e020dULL, 0x000000040d097811ULL, 0x000fe200078fe8ffULL,
0x00000008131f7824ULL, 0x000fe200078e00ffULL, 0x000000180d197811ULL, 0x040fe200078fe8ffULL,
0x00000001140b7824ULL, 0x140fe200078e020dULL, 0x0000001c0d1b7811ULL, 0x000fe200078fe8ffULL,
0x0000000814107824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x00000001150f7824ULL, 0x100fe200078e020dULL, 0x000000140d177811ULL, 0x000fe200078fe8ffULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee20bULL,
0x0000000109057824ULL, 0x100fe200078e020dULL, 0x000000280d327811ULL, 0x000fe200078fe8ffULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fe200078ee20fULL,
0x00000001190a7824ULL, 0x100fe200078e020dULL, 0x0000002c0d307811ULL, 0x000fe200078fe8ffULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x000000011b0b7824ULL, 0x100fe200078e020dULL, 0x000000240d337811ULL, 0x000fe200078fe8ffULL,
0x000000081b167824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x0000000117057824ULL, 0x100fe200078e020dULL, 0x000000200d1d7811ULL, 0x000fe200078fe8ffULL,
0x0000000817107824ULL, 0x000fe200078e00ffULL, 0xfffffff816297812ULL, 0x000fe200078ee20bULL,
0x00000001320a7824ULL, 0x140fe200078e020dULL, 0x000000300d2f7811ULL, 0x040fe200078fe8ffULL,
0x0000000832117824ULL, 0x000fe200078e00ffULL, 0xfffffff810257812ULL, 0x000fe200078ee205ULL,
0x00000001300b7824ULL, 0x140fe200078e020dULL, 0x000000340d267811ULL, 0x000fe200078fe8ffULL,
0x0000000830227824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee20aULL,
0x0000000133057824ULL, 0x100fe200078e020dULL, 0x000000380d287811ULL, 0x000fe200078fe8ffULL,
0x00000008331e7824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20bULL,
0x000000011d0f7824ULL, 0x040fe200078e020dULL, 0x00009000ff0a7b82ULL, 0x000e620000000a00ULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL,
0x000000082f247824ULL, 0x000fe200078e00ffULL, 0x0000000d0d057211ULL, 0x000fe200078fe8ffULL,
0x000000010e117824ULL, 0x040fe200078e0209ULL, 0xfffffff8182b7812ULL, 0x000fe200078ee20fULL,
0x000000012f0f7824ULL, 0x000fe200078e020dULL, 0x0000003c0d2d7811ULL, 0x000fe200078fe8ffULL,
0x000000010e167824ULL, 0x040fe200078e0215ULL, 0x0000000705107812ULL, 0x000fe200078ec0ffULL,
0x000000010e137824ULL, 0x040fe200078e0213ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x000000010e147824ULL, 0x040fe200078e0214ULL, 0x0000000e0d0f7211ULL, 0x000fe200078fe8ffULL,
0x000000010e187824ULL, 0x040fe200078e0217ULL, 0x0ffffff810057812ULL, 0x000fe200078ef80dULL,
0x000000010e1a7824ULL, 0x000fe200078e0219ULL, 0x0000000840377c11ULL, 0x000fe2000f8e70ffULL,
0x000000010e1c7824ULL, 0x000fc400078e021bULL, 0x000000010e367824ULL, 0x040fe400078e021dULL,
0x000000010e337824ULL, 0x040fe400078e0233ULL, 0x000000010e327824ULL, 0x040fe400078e0232ULL,
0x000000010e307824ULL, 0x040fe400078e0230ULL, 0x000000010e2f7824ULL, 0x040fe400078e022fULL,
0x000000010e2e7824ULL, 0x000fc400078e0226ULL, 0x0000000126097824ULL, 0x100fe400078e020dULL,
0x000000010e2a7824ULL, 0x000fe400078e0228ULL, 0x0000000128157824ULL, 0x000fe400078e020dULL,
0x000000010e2c7824ULL, 0x000fe400078e022dULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000828287824ULL, 0x000fc400078e00ffULL, 0x000000012d0d7824ULL, 0x040fe200078e020dULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x000000082d0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff828157812ULL, 0x000fe200078ee215ULL, 0x0000100037107836ULL, 0x000fe20000000000ULL,
0x0000000a31097211ULL, 0x042fe200078038ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff80e2d7812ULL, 0x000fe400078ee20dULL, 0x0000000b31317211ULL, 0x000fe200000f3cffULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000001005057824ULL, 0x100fe200078e0210ULL,
0x000000700e0a7812ULL, 0x000fe200078ef802ULL, 0x00000010120d7824ULL, 0x100fe400078e0210ULL,
0x000000101f1f7824ULL, 0x100fe200078e0210ULL, 0x0000000a090a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe400078e0210ULL, 0x0000001023237824ULL, 0x100fe400078e0210ULL,
0x0000001025257824ULL, 0x000fc400078e0210ULL, 0x0000001027277824ULL, 0x100fe400078e0210ULL,
0x0000001029297824ULL, 0x100fe400078e0210ULL, 0x000000102b2b7824ULL, 0x100fe400078e0210ULL,
0x000000101e1e7824ULL, 0x100fe400078e0210ULL, 0x0000001020207824ULL, 0x100fe400078e0210ULL,
0x0000001022227824ULL, 0x000fc400078e0210ULL, 0x0000001024247824ULL, 0x100fe400078e0210ULL,
0x0000001026267824ULL, 0x100fe400078e0210ULL, 0x0000001015287824ULL, 0x100fe400078e0210ULL,
0x000000102d2d7824ULL, 0x000fe400078e0210ULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x00000070100e7812ULL, 0x000fc600078ef802ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000007012107812ULL, 0x000fe400078ef802ULL,
0x0000000e090e7210ULL, 0x000fe20007f3e0ffULL, 0x000000010f0b7824ULL, 0x100fe200000e0631ULL,
0x0000001009107210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007014127812ULL, 0x000fe400078ef802ULL, 0x0000007016147812ULL, 0x000fe200078ef802ULL,
0x00000001110f7824ULL, 0x100fe200008e0631ULL, 0x0000001209127210ULL, 0x000fe20007f5e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018167812ULL, 0x000fe200078ef802ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e4000b901c46ULL,
0x0000000113117824ULL, 0x100fe200000e0631ULL, 0x0000001409147210ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000701a187812ULL, 0x000fe200078ef802ULL,
0x000000000e0d7faeULL, 0x0003e4000b901c46ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000701c1a7812ULL, 0x000fe200078ef802ULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x0000001809187210ULL, 0x000fe20007f3e0ffULL, 0x0000000115137824ULL, 0x100fe200010e0631ULL,
0x00000070361c7812ULL, 0x000fe200078ef802ULL, 0x0000000117157824ULL, 0x100fe200000e0631ULL,
0x0000001609167210ULL, 0x000fe20007f1e0ffULL, 0x00000080303c7825ULL, 0x000fe200078e00ffULL,
0x0000001a091a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x0000001c091c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000119177824ULL, 0x100fe200000e0631ULL,
0x000000703c3c7812ULL, 0x000fe200078ef802ULL, 0x000000011b197824ULL, 0x100fe200008e0631ULL,
0x0000000014237faeULL, 0x0003e2000b901c46ULL, 0x000000011d1b7824ULL, 0x100fe200010e0631ULL,
0x0000003c093c7210ULL, 0x000fe20007f5e0ffULL, 0x00000001371d7824ULL, 0x000fe200018e0631ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x0000008033367825ULL, 0x000fc600078e00ffULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000007036367812ULL, 0x000fe400078ef802ULL, 0x000000001a297faeULL, 0x0003e2000b901c46ULL,
0x000000802f3e7825ULL, 0x000fe200078e00ffULL, 0x0000007032327812ULL, 0x000fe400078ef802ULL,
0x0000003609367210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000703e3e7812ULL, 0x000fe200078ef802ULL, 0x000000001c2b7faeULL, 0x0003e2000b901c46ULL,
0x0000003209327210ULL, 0x000fe20007f3e0ffULL, 0x000000802a447825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x000fc400078ef802ULL, 0x0000003e093e7210ULL, 0x000fe20007f7e0ffULL,
0x000000802c467825ULL, 0x000fe200078e00ffULL, 0x0000007044447812ULL, 0x000fe400078ef802ULL,
0x0000002e092e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000137377824ULL, 0x100fe200000e0631ULL,
0x0000007046027812ULL, 0x000fe200078ef802ULL, 0x0000000133337824ULL, 0x100fe200008e0631ULL,
0x0000004409447210ULL, 0x000fe20007fbe0ffULL, 0x000000013d3d7824ULL, 0x100fe200010e0631ULL,
0x0000000209307210ULL, 0x000fe20007fde0ffULL, 0x000000013f3f7824ULL, 0x100fe200018e0631ULL,
0x00000000361e7faeULL, 0x0003e2000b901c46ULL, 0x000000012f2f7824ULL, 0x000fc400020e0631ULL,
0x0000000145457824ULL, 0x100fe200028e0631ULL, 0x0000000032207faeULL, 0x0003e2000b901c46ULL,
0x0000000147317824ULL, 0x000fc600030e0631ULL, 0x000000003c227faeULL, 0x0003e8000b901c46ULL,
0x000000003e247faeULL, 0x0003e8000b901c46ULL, 0x000000002e267faeULL, 0x0003e8000b901c46ULL,
0x0000000044287faeULL, 0x0003e8000b901c46ULL, 0x00000000302d7faeULL, 0x0003e4000b901c46ULL,
0x000000020c027836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000840000047ab9ULL, 0x000fc60000000800ULL, 0x0000003b0200720cULL, 0x000fda0003f06070ULL,
0x00009600ff058b82ULL, 0x002e620000000800ULL, 0x0000000235098824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000509098224ULL, 0x002fe400078e0202ULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x00000004090a8825ULL, 0x004fca00078e000aULL,
0x000000060a058981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01760007ff0075a7ULL, 0x000e620008000148ULL, 0x0000000404097c24ULL, 0x000fe4000f8e02ffULL,
0x000000013a047824ULL, 0x000fca00078e0a03ULL, 0x00000008ff047819ULL, 0x000fe20000011604ULL,
0x00008e00ff767b82ULL, 0x000ea40000000a00ULL, 0x0000000409767825ULL, 0x004fe200078e0076ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001140dULL,
0x0000000c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000209097819ULL, 0x000fc8000000120cULL, 0x000000090000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01760007ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002040067824ULL, 0x002fca00078e0207ULL,
0x00000003ff077819ULL, 0x000fc80000011606ULL, 0x1ffffffe07097812ULL, 0x000fe400078ec0ffULL,
0x0000000f06077812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x00000010070a7824ULL, 0x000fe400078e00ffULL, 0x0000000109067836ULL, 0x000fe20000000000ULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x000fc600078e00ffULL,
0x0000000f06067812ULL, 0x000fe400078ec0ffULL, 0x000000f00a097812ULL, 0x000fe400078ee209ULL,
0x000000f007067812ULL, 0x000fe400078ee206ULL, 0x0000000809097c11ULL, 0x000fe4000f8e20ffULL,
0x0000000806067c11ULL, 0x000fc6000f8e20ffULL, 0x0000000009107984ULL, 0x000e680000000c00ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x0003e20000000c00ULL,
0x00000001ff0c7424ULL, 0x000fc600078e00ffULL, 0x0000001006007388ULL, 0x0003e60000000c00ULL,
0x0176000cff0c79a7ULL, 0x000ea40008500008ULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x0176000dff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001140bULL, 0x0000000a09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000209097819ULL, 0x000fc8000000120aULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x0176000dff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff0a7b82ULL, 0x000e620000000800ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x0000010008077836ULL, 0x000fe40000000000ULL,
0x3db504f334347820ULL, 0x010fe20000410000ULL, 0x0000000840367c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff03377836ULL, 0x000fe20000000000ULL, 0x00000008403c7c11ULL, 0x000fe2000f8e28ffULL,
0x0000000903397836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff3d7224ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fe400078e00ffULL,
0x0000000a35357224ULL, 0x002fce00078e02ffULL, 0x000000023d097836ULL, 0x004fe20000000000ULL,
0x00000001203e7812ULL, 0x000fe200078e0cffULL, 0x000001003d3f7824ULL, 0x000fe400078e0207ULL,
0x00000005000a7224ULL, 0x010fe200078e02ffULL, 0x000000380900720cULL, 0x000fe40003f06070ULL,
0x000000403f087812ULL, 0x000fca00078ec0ffULL, 0x0000000143057824ULL, 0x000fcc00078e0208ULL,
0x0000000c00388947ULL, 0x000fea0003800000ULL, 0x00009000ff0e7b82ULL, 0x000e620000000a00ULL,
0x00000003ff0d7819ULL, 0x104fe20000011606ULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x0000003f3a1a7248ULL, 0x000fe40007fe0000ULL, 0x0000000840217c11ULL, 0x000fe2000f8e70ffULL,
0x000000040d117836ULL, 0x000fe20000000000ULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000080d137836ULL, 0x000fe40000000000ULL, 0x0000000111087824ULL, 0x000fc400078e0206ULL,
0x0000000811097824ULL, 0x000fe400078e00ffULL, 0x000000010d0b7824ULL, 0x000fe400078e0205ULL,
0x0000000113247824ULL, 0x140fe200078e0206ULL, 0xfffffff809287812ULL, 0x000fe200078ee208ULL,
0x0000000813157824ULL, 0x000fe400078e00ffULL, 0x000000011a1a7824ULL, 0x000fe400078e0a3fULL,
0x000000140d1f7836ULL, 0x000fe20000000000ULL, 0xfffffff815247812ULL, 0x000fe200078ee224ULL,
0x000000100d157836ULL, 0x000fe20000000000ULL, 0x0000000e0a097211ULL, 0x042fe200078038ffULL,
0x000000011f1c7824ULL, 0x000fe200078e0205ULL, 0x0000001a1100720cULL, 0x080fe20003fa6070ULL,
0x0000000115227824ULL, 0x000fe200078e0206ULL, 0x0000000f0a087211ULL, 0x000fe200000f3cffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000001a1300720cULL, 0x000fc60003f26070ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x0000000c0a187212ULL, 0x000fe200078efcffULL,
0x0000000c0d0f7836ULL, 0x000fe40000000000ULL, 0x00000001110a7824ULL, 0x000fe200078e0205ULL,
0x0000001809187210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0e7824ULL, 0x040fe200078e0206ULL,
0xfffffff819227812ULL, 0x000fe200078ee222ULL, 0x000000080f177824ULL, 0x040fe200078e00ffULL,
0x0000001a0f00720cULL, 0x080fe20003f46070ULL, 0x000000010b197824ULL, 0x000fe200000e0608ULL,
0x0000001a1500720cULL, 0x000fe20003f06070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff8172a7812ULL, 0x000fc600078ee20eULL, 0x000000010f107824ULL, 0x100fe200078e0205ULL,
0x0000000c0a0a7212ULL, 0x000fe200078efcffULL, 0x00000001130e7824ULL, 0x000fe400078e0205ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000090a0a7210ULL, 0x000fc60007f7e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000c10147212ULL, 0x000fc600078efcffULL,
0x0000000115127824ULL, 0x000fe200078e0205ULL, 0x0000000c0e167212ULL, 0x000fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x0000000916167210ULL, 0x000fe20007f9e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000c1c0e7212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x100fe200018e0608ULL, 0x0000000914147210ULL, 0x000fe20007f7e0ffULL,
0x000000180d257836ULL, 0x000fe20000000000ULL, 0x0000000c12107212ULL, 0x000fe200078efcffULL,
0x000000010f177824ULL, 0x100fe400020e0608ULL, 0x0000000111157824ULL, 0x000fe200018e0608ULL,
0x000000090e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d1c7824ULL, 0x000fe200078e0206ULL,
0x0000000910107210ULL, 0x000fe20007f9e0ffULL, 0x0000000125127824ULL, 0x000fc400078e0205ULL,
0x000000011d0f7824ULL, 0x100fe200018e0608ULL, 0x000000071c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001c0d297836ULL, 0x000fe20000000000ULL, 0x0000001a1f00720cULL, 0x080fe20003f66070ULL,
0x0000000113117824ULL, 0x000fe200020e0608ULL, 0x0ffffff81d1e7812ULL, 0x000fe200078ef806ULL,
0x000020003e1b7824ULL, 0x000fe200078e0221ULL, 0x0000001a0d00720cULL, 0x000fe20003f86070ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000011f237824ULL, 0x040fe200078e0206ULL,
0x0000000c12127212ULL, 0x000fe200078efcffULL, 0x000000081f2c7824ULL, 0x000fe400078e00ffULL,
0x00000001291c7824ULL, 0x000fe200078e0205ULL, 0x0000000912127210ULL, 0x000fe20007fde0ffULL,
0x000010001b1b7836ULL, 0x000fe20000000000ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee223ULL,
0x000000200d2b7836ULL, 0x000fe40000000000ULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x000000101e237824ULL, 0x000fe200078e021bULL, 0x0000000c1c1c7212ULL, 0x000fe200078efcffULL,
0x000000240d2d7836ULL, 0x000fe40000000000ULL, 0x000000012b1e7824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e2000e101c46ULL,
0x0000000125277824ULL, 0x040fe200078e0206ULL, 0x0000001a2500720cULL, 0x040fe20003f86070ULL,
0x00000008252e7824ULL, 0x000fe400078e00ffULL, 0x000000012d267824ULL, 0x000fc400078e0205ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fc600078ee227ULL,
0x0000000113137824ULL, 0x000fe200030e0608ULL, 0x000000091c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c1e187212ULL, 0x002fc600078efcffULL,
0x000000011d1d7824ULL, 0x000fe200030e0608ULL, 0x0000000c261e7212ULL, 0x000fe200078efcffULL,
0x0000000129257824ULL, 0x040fe200078e0206ULL, 0x0000000918187210ULL, 0x000fe20007fde0ffULL,
0x0000000829267824ULL, 0x000fe400078e00ffULL, 0x0000001028237824ULL, 0x100fe400078e021bULL,
0x000000011f197824ULL, 0x000fe200030e0608ULL, 0xfffffff826267812ULL, 0x000fe200078ee225ULL,
0x0000001024257824ULL, 0x000fe200078e021bULL, 0x000000091e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000000a237faeULL, 0x0003e2000e901c46ULL, 0x000000012b247824ULL, 0x000fe200078e0206ULL,
0x0000001a2900720cULL, 0x080fe20003fa6070ULL, 0x000000082d287824ULL, 0x000fe200078e00ffULL,
0x0000000016257faeULL, 0x0005e2000c901c46ULL, 0x00000001271f7824ULL, 0x000fe200030e0608ULL,
0x0000001a2b00720cULL, 0x000fe20003f26070ULL, 0x000000012d277824ULL, 0x000fc400078e0206ULL,
0x000000280d2f7836ULL, 0x000fe40000000000ULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x000000102a237824ULL, 0x002fe400078e021bULL, 0x000000012f0a7824ULL, 0x000fe200078e0205ULL,
0xfffffff82b247812ULL, 0x000fe200078ee224ULL, 0x0000001022177824ULL, 0x104fe200078e021bULL,
0x0000000014237faeULL, 0x0003e2000d101c46ULL, 0x0000002c0d2b7836ULL, 0x000fe20000000000ULL,
0x0000001a2d00720cULL, 0x000fe20003f46070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000010177faeULL, 0x0005e6000c101c46ULL, 0x000000340d2d7836ULL, 0x000fe20000000000ULL,
0x0000000c0a0a7212ULL, 0x000fe200078efcffULL, 0x0000001026257824ULL, 0x000fc400078e021bULL,
0x0000003c0d317836ULL, 0x000fe20000000000ULL, 0xfffffff828147812ULL, 0x002fe200078ee227ULL,
0x000000102c157824ULL, 0x100fe200078e021bULL, 0x000000090a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000102e237824ULL, 0x100fe200078e021bULL, 0x0000001a3100720cULL, 0x080fe20003f06070ULL,
0x0000001014297824ULL, 0x000fe200078e021bULL, 0x000000000e157faeULL, 0x0003e2000d901c46ULL,
0x000000012b147824ULL, 0x100fe400078e0205ULL, 0x000000300d177836ULL, 0x004fe20000000000ULL,
0x0000000012237faeULL, 0x0005e2000e101c46ULL, 0x000000010b0b7824ULL, 0x000fe200030e0608ULL,
0x0000001a2b00720cULL, 0x080fe20003f86070ULL, 0x0000000117107824ULL, 0x000fe200078e0205ULL,
0x000000001c257faeULL, 0x0007e2000e901c46ULL, 0x0000001024277824ULL, 0x000fe200078e021bULL,
0x0000001a2f00720cULL, 0x080fe20003fa6070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001a1700720cULL, 0x000fc40003f66070ULL, 0x0000000018277faeULL, 0x0009e2000c901c46ULL,
0x00000080140e7825ULL, 0x002fe200078e00ffULL, 0x0000000c10107212ULL, 0x080fe400078efcffULL,
0x000000001e297faeULL, 0x0003e2000d101c46ULL, 0x000000012d127824ULL, 0x044fe200078e0205ULL,
0x0000000c0e0e7212ULL, 0x000fe200078efcffULL, 0x000000380d237836ULL, 0x000fe20000000000ULL,
0x0000001a2d00720cULL, 0x080fe20003f46070ULL, 0x000000012b147824ULL, 0x040fe200078e0206ULL,
0x000000090e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000001a2300720cULL, 0x000fe20003f26070ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff82b1a7812ULL, 0x000fe200078ee214ULL, 0x000000010f0f7824ULL, 0x000fe200030e0608ULL,
0x0000000910107210ULL, 0x000fe20007fde0ffULL, 0x0000000117157824ULL, 0x140fe200078e0206ULL,
0x0000000c12167212ULL, 0x000fe200078efcffULL, 0x00000008171c7824ULL, 0x008fe400078e00ffULL,
0x0000000123147824ULL, 0x000fe400078e0205ULL, 0x000000012f0d7824ULL, 0x040fe200078e0206ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x000000082f187824ULL, 0x010fc400078e00ffULL,
0x0000000111117824ULL, 0x000fe200030e0608ULL, 0x0000000916167210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fc600078ee20dULL,
0x0000000131127824ULL, 0x000fe200078e0205ULL, 0x0000000c14147212ULL, 0x000fe200078efcffULL,
0x000000012d0d7824ULL, 0x040fe400078e0206ULL, 0x000000082d1e7824ULL, 0x002fe400078e00ffULL,
0x0000000113177824ULL, 0x000fe200030e0608ULL, 0x0000000914147210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fc600078ee20dULL,
0x0000000123057824ULL, 0x140fe200078e0206ULL, 0x0000000c120c7212ULL, 0x000fe200078efcffULL,
0x0000000823227824ULL, 0x000fe400078e00ffULL, 0x00000001310d7824ULL, 0x040fe400078e0206ULL,
0x0000000831247824ULL, 0x000fe200078e00ffULL, 0xfffffff822127812ULL, 0x000fe200078ee205ULL,
0x0000000115157824ULL, 0x000fe200030e0608ULL, 0x000000090c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001018057824ULL, 0x100fe200078e021bULL, 0xfffffff824227812ULL, 0x000fe200078ee20dULL,
0x000000101a097824ULL, 0x000fc400078e021bULL, 0x000000101c197824ULL, 0x100fe200078e021bULL,
0x000000000a057faeULL, 0x0003e2000e901c46ULL, 0x000000101e1d7824ULL, 0x100fe400078e021bULL,
0x00000010121f7824ULL, 0x100fe200078e021bULL, 0x000000000e097faeULL, 0x0003e2000e101c46ULL,
0x00000010221b7824ULL, 0x000fe400078e021bULL, 0x00000001130d7824ULL, 0x000fe200030e0608ULL,
0x0000000010197faeULL, 0x0003e8000d901c46ULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x00000000141f7faeULL, 0x0003e8000c901c46ULL, 0x000000000c1b7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x00000008060c7811ULL, 0x044fe200078fe8ffULL,
0x00009000ff547b82ULL, 0x000e620000000a00ULL, 0x0000001406127811ULL, 0x040fe200078fe8ffULL,
0x0000001006577824ULL, 0x040fe200078e00ffULL, 0x00000004060b7811ULL, 0x000fe200078fe8ffULL,
0x000000010c097824ULL, 0x100fe200078e0206ULL, 0x0000001806147811ULL, 0x000fe200078fe8ffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x0000000c060e7811ULL, 0x000fe200078fe8ffULL,
0x00000001120d7824ULL, 0x100fe200078e0206ULL, 0x0000002806267811ULL, 0x000fe200078fe8ffULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0xfffffff8104f7812ULL, 0x000fe200078ee209ULL,
0x000000010b087824ULL, 0x140fe200078e0206ULL, 0x0000001006107811ULL, 0x000fe200078fe8ffULL,
0x000000080b517824ULL, 0x000fe200078e00ffULL, 0xfffffff8180d7812ULL, 0x000fe200078ee20dULL,
0x00000001140f7824ULL, 0x100fe200078e0206ULL, 0x0000002006187811ULL, 0x000fe200078fe8ffULL,
0x0000000110097824ULL, 0x140fe200078e0206ULL, 0xfffffff851517812ULL, 0x000fe200078ee208ULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x0000002406287811ULL, 0x000fe200078fe8ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x0000003006227811ULL, 0x000fe200078fe8ffULL,
0x000000010e087824ULL, 0x140fe200078e0206ULL, 0xfffffff8164b7812ULL, 0x000fe200078ee209ULL,
0x000000080e4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a0f7812ULL, 0x000fe200078ee20fULL,
0x0000000118097824ULL, 0x100fe200078e0206ULL, 0x0000001c06167811ULL, 0x000fe200078fe8ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee208ULL,
0x0000000126137824ULL, 0x100fe200078e0206ULL, 0x0000002c06247811ULL, 0x000fe200078fe8ffULL,
0x00000008261e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a337812ULL, 0x000fe200078ee209ULL,
0x0000000116087824ULL, 0x100fe200078e0206ULL, 0x00000034061a7811ULL, 0x000fe200078fe8ffULL,
0x0000000816457824ULL, 0x000fe200078e00ffULL, 0xfffffff81e137812ULL, 0x000fe200078ee213ULL,
0x0000000128117824ULL, 0x100fe200078e0206ULL, 0x0000003c061b7811ULL, 0x000fe200078fe8ffULL,
0x00000008281c7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee208ULL,
0x0000000122097824ULL, 0x100fe200078e0206ULL, 0x0000000840217c11ULL, 0x000fe2000f8e70ffULL,
0x00000008221e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c117812ULL, 0x000fe200078ee211ULL,
0x0000000124087824ULL, 0x100fe200078e0206ULL, 0x00000038061c7811ULL, 0x000fe200078fe8ffULL,
0x00000008242d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e157812ULL, 0x000fe200078ee209ULL,
0x000000011a177824ULL, 0x100fe200078e0206ULL, 0x0000000606097211ULL, 0x000fe200078fe8ffULL,
0x000000081a2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL,
0x000000011c197824ULL, 0x000fe200078e0206ULL, 0x0000000506087211ULL, 0x000fe200078fe8ffULL,
0x000000081c2c7824ULL, 0x000fe200078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0205ULL, 0x0000007057577812ULL, 0x000fe200078ec0ffULL,
0x000000010c0c7824ULL, 0x100fe200078e0205ULL, 0x0ffffff809537812ULL, 0x000fe200078ef806ULL,
0x000000010e0e7824ULL, 0x100fe200078e0205ULL, 0x000000540a2e7211ULL, 0x002fe200078038ffULL,
0x0000000110107824ULL, 0x100fe200078e0205ULL, 0xfffffff82c197812ULL, 0x000fe200078ee219ULL,
0x0000000112127824ULL, 0x100fe200078e0205ULL, 0x000000550a557211ULL, 0x000fe200000f3cffULL,
0x0000000114147824ULL, 0x100fe200078e0205ULL, 0xfffffff82a177812ULL, 0x000fe200078ee217ULL,
0x0000000116167824ULL, 0x000fc400078e0205ULL, 0x0000000118187824ULL, 0x100fe400078e0205ULL,
0x0000000128287824ULL, 0x100fe400078e0205ULL, 0x0000000126267824ULL, 0x100fe400078e0205ULL,
0x0000000124247824ULL, 0x100fe400078e0205ULL, 0x0000000122227824ULL, 0x100fe400078e0205ULL,
0x000000011a1a7824ULL, 0x000fc400078e0205ULL, 0x000000011c1c7824ULL, 0x100fe400078e0205ULL,
0x000000011b1e7824ULL, 0x000fe400078e0205ULL, 0x000020003e057824ULL, 0x000fe400078e0221ULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x0000100005307836ULL, 0x000fe40000000000ULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x00000010132f7824ULL, 0x100fe200078e0230ULL,
0x0000005708137212ULL, 0x000fe200078efcffULL, 0x000000100d497824ULL, 0x000fe400078e0230ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000132e087210ULL, 0x000fc60007f1e0ffULL,
0x000000100f477824ULL, 0x100fe400078e0230ULL, 0x00000010152c7824ULL, 0x000fe200078e0230ULL,
0x000000570c157212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000001011317824ULL, 0x000fe200078e0230ULL, 0x000000570e137212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x000000132e0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000011b1d7824ULL, 0x040fe400078e0206ULL, 0x000000081b2a7824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200000e0655ULL, 0x000000152e0c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010172b7824ULL, 0x000fe200078e0230ULL, 0x000000570a177212ULL, 0x080fe200078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005710157212ULL, 0x000fc400078efcffULL,
0xfffffff82a1d7812ULL, 0x000fe200078ee21dULL, 0x00000010192a7824ULL, 0x000fe200078e0230ULL,
0x000000172e0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0655ULL,
0x000000152e107210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000005712237212ULL, 0x000fc600078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000057181b7212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000057141f7212ULL, 0x080fe400078efcffULL, 0x0000001b2e187210ULL, 0x000fe20007f7e0ffULL,
0x000000101d057824ULL, 0x000fe200078e0230ULL, 0x00000057161d7212ULL, 0x000fe200078efcffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x0000000111117824ULL, 0x000fe200000e0655ULL,
0x000000232e127210ULL, 0x000fe20007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000005728637212ULL, 0x000fc600078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000005726617212ULL, 0x000fc600078efcffULL, 0x000000010b0b7824ULL, 0x100fe200008e0655ULL,
0x0000001f2e147210ULL, 0x000fe20007f3e0ffULL, 0x000000010f0f7824ULL, 0x000fe200010e0655ULL,
0x0000001d2e167210ULL, 0x000fe20007f5e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x00000057245f7212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x00000057225d7212ULL, 0x000fc600078efcffULL, 0x0000001053537824ULL, 0x000fe200078e0230ULL,
0x000000571a5b7212ULL, 0x000fe200078efcffULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008537faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x100fe200078e0230ULL, 0x000000571c597212ULL, 0x080fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000005b2e1a7210ULL, 0x000fe40007f9e0ffULL,
0x000000000a517faeULL, 0x0003e2000b901c46ULL, 0x000000104f4f7824ULL, 0x100fe200078e0230ULL,
0x000000571e577212ULL, 0x000fe200078efcffULL, 0x000000104d4d7824ULL, 0x100fe200078e0230ULL,
0x000000592e1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000113137824ULL, 0x100fe200000e0655ULL,
0x000000632e287210ULL, 0x000fe20007f1e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e0230ULL,
0x000000000c4f7faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x100fe200008e0655ULL,
0x000000612e267210ULL, 0x000fe20007f3e0ffULL, 0x0000000117177824ULL, 0x100fe200010e0655ULL,
0x0000005f2e247210ULL, 0x000fe20007f5e0ffULL, 0x0000000119197824ULL, 0x100fe200018e0655ULL,
0x0000005d2e227210ULL, 0x000fe20007f7e0ffULL, 0x0000001045457824ULL, 0x100fe200078e0230ULL,
0x000000000e4d7faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x000fe200078e0230ULL,
0x000000572e1e7210ULL, 0x000fe20007fde0ffULL, 0x0000000129297824ULL, 0x100fe200000e0655ULL,
0x00000000104b7faeULL, 0x0003e2000b901c46ULL, 0x0000000127277824ULL, 0x000fc400008e0655ULL,
0x000000102d2d7824ULL, 0x000fe200078e0230ULL, 0x0000000012497faeULL, 0x0003e2000b901c46ULL,
0x0000000125257824ULL, 0x100fe400010e0655ULL, 0x0000000123237824ULL, 0x100fe200018e0655ULL,
0x0000000014477faeULL, 0x0003e2000b901c46ULL, 0x000000011b1b7824ULL, 0x100fe400020e0655ULL,
0x000000011d1d7824ULL, 0x100fe200028e0655ULL, 0x0000000016457faeULL, 0x0003e2000b901c46ULL,
0x000000011f1f7824ULL, 0x000fc600030e0655ULL, 0x0000000018337faeULL, 0x0003e8000b901c46ULL,
0x0000000028317faeULL, 0x0003e8000b901c46ULL, 0x00000000262f7faeULL, 0x0003e8000b901c46ULL,
0x00000000242d7faeULL, 0x0003e8000b901c46ULL, 0x00000000222c7faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c2a7faeULL, 0x0003e8000b901c46ULL,
0x000000001e057faeULL, 0x0003e4000b901c46ULL, 0x0000000202027836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff057424ULL, 0x002fc600078e00ffULL,
0x0000003b0200720cULL, 0x000fda0003f06070ULL, 0x00009200ff088b82ULL, 0x000e620000000a00ULL,
0x00000002350b8824ULL, 0x000fe400078e0202ULL, 0x00000020060a7836ULL, 0x000fe20000000000ULL,
0xfffffff806477812ULL, 0x000fe200078ec0ffULL, 0x0000200020467824ULL, 0x000fe200078e0221ULL,
0x0000000706457812ULL, 0x000fe200078ec0ffULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x00000004ff447819ULL, 0x000fe40000011606ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000040b088825ULL, 0x002fe200078e0008ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000608058981ULL, 0x000322000c1e1900ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000100046467836ULL, 0x000fe20000000000ULL, 0x0000000747477812ULL, 0x000fe400078ef806ULL,
0x0000000845487812ULL, 0x000fe400078ef806ULL, 0xfffffff80a097812ULL, 0x002fc800078ec0ffULL,
0x0000000709427812ULL, 0x000fce00078ef806ULL, 0x0000000147087824ULL, 0x140fe400078e0249ULL,
0x0000000847097824ULL, 0x000fe400078e00ffULL, 0x00000001420c7824ULL, 0x040fe400078e0249ULL,
0x00000008420d7824ULL, 0x040fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x0000000249737824ULL, 0x000fe400078e0244ULL, 0x00000008424b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x0000001009097824ULL, 0x000fc800078e0246ULL,
0x000000100d0d7824ULL, 0x000fe400078e0246ULL, 0x000000000908783bULL, 0x000e680000000200ULL,
0x000000000d0c783bULL, 0x000ea20000000200ULL, 0x00000018ff557819ULL, 0x002fe20000011408ULL,
0x0001000008147824ULL, 0x040fe200078e00ffULL, 0x0000888008547816ULL, 0x040fe200000000ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011409ULL,
0x0001000009157824ULL, 0x040fe200078e00ffULL, 0x00008880095a7816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fc4000001140aULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x000088800a667816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe2000001140bULL, 0x00000008005c7306ULL, 0x0002e20000200c00ULL,
0x000088800b647816ULL, 0x000fe400000000ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff6a7819ULL, 0x004fc4000001140cULL, 0x000088800c687816ULL, 0x000fe200000000ffULL,
0x0000000900597306ULL, 0x0005e20000200c00ULL, 0x000100000a087824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001140dULL, 0x000001000a0a7824ULL, 0x000fe200078e00ffULL,
0x000088800d6d7816ULL, 0x000fe400000000ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x000100000b097824ULL, 0x044fe200078e00ffULL,
0x0000000800757306ULL, 0x0003e20000200c00ULL, 0x000001000b0b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc4000001140eULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000000a00617306ULL, 0x0005e20000200c00ULL,
0x000100000c087824ULL, 0x042fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001140fULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x000088800e6b7816ULL, 0x000fe400000000ffULL,
0x00000018ff087819ULL, 0x000fc40000011408ULL, 0x00000014004d7306ULL, 0x0003e20000200c00ULL,
0x00000001490a7836ULL, 0x004fe20000000000ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000000249497836ULL, 0x000fe20000000000ULL, 0x000088800f5e7816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000000900657306ULL, 0x0005e20000200c00ULL,
0x0000000847147824ULL, 0x002fe200078e00ffULL, 0x000054105c557816ULL, 0x008fc40000000055ULL,
0x000000084900780cULL, 0x000fc80003f05270ULL, 0x0000000b00747306ULL, 0x0003e20000200c00ULL,
0x0000000147097824ULL, 0x104fe400078e020aULL, 0x00000001420a7824ULL, 0x000fca00078e020aULL,
0x0000000c006f7306ULL, 0x0005e20000200c00ULL, 0xfffffff8140b7812ULL, 0x002fe200078ee209ULL,
0x000100000d097824ULL, 0x040fe400078e00ffULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x000000100b0b7824ULL, 0x000fe200078e0246ULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000000800717306ULL, 0x0003e20000200c00ULL, 0x000100000f0c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000001000f0f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000000d00707306ULL, 0x0005e20000200c00ULL,
0x000100000e087824ULL, 0x042fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x000001000e0e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011408ULL,
0x0000000c00637306ULL, 0x0003e20000200c00ULL, 0x00000010480d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fcc000001140eULL, 0x00000015005b7306ULL, 0x0005e20000200c00ULL,
0x00000001480c7824ULL, 0x142fe200078e0273ULL, 0x0000000248737810ULL, 0x000fc80007ffe073ULL,
0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL, 0x0000000e006c7306ULL, 0x000fe20000200c00ULL,
0x000000000b14783bULL, 0x004e620000000200ULL, 0x000000080c0c7c11ULL, 0x000fcc000f8e20ffULL,
0x0000000f005d7306ULL, 0x0005f00000200c00ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x000000000c0c783bULL, 0x004eae0000000200ULL, 0x0000000900727306ULL, 0x000be20000200c00ULL,
0x0000541054547816ULL, 0x008fce000000004dULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0xfffffff84b097812ULL, 0x020fca00078ee20aULL, 0x0000001009097824ULL, 0x000fe400078e0246ULL,
0x0000005800587306ULL, 0x000f620000200c00ULL, 0x00000018ff4b7819ULL, 0x002fe20000011414ULL,
0x0001000014567824ULL, 0x040fe200078e00ffULL, 0x00008880145f7816ULL, 0x040fe200000000ffULL,
0x000000000908783bULL, 0x000e620000000200ULL, 0x0000010014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011415ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff517819ULL, 0x000fc40000011417ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff527819ULL, 0x000fe40000011416ULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000001400627306ULL, 0x0007e20000200c00ULL, 0x000000540c30723cULL, 0x004fee0000001830ULL,
0x0000888015547816ULL, 0x040fe200000000ffULL, 0x0001000015557824ULL, 0x040fe200078e00ffULL,
0x000054105a147816ULL, 0x008fe2000000005bULL, 0x0000010015157824ULL, 0x000fe200078e00ffULL,
0x0000006600667306ULL, 0x000ea40000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff5a7819ULL, 0x000fe40000011415ULL, 0x0000541059157816ULL, 0x020fe40000000058ULL,
0x0000005f004d7306ULL, 0x000fe20000200c00ULL, 0x0000888016597816ULL, 0x000fc800000000ffULL,
0x000000140c2c723cULL, 0x000fe6000000182cULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x00000018ff507819ULL, 0x002fe40000011408ULL, 0x00000018ff4f7819ULL, 0x000fe20000011409ULL,
0x0001000016147824ULL, 0x040fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001140aULL,
0x0001000017157824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001140bULL,
0x0000005a00587306ULL, 0x0003e20000200c00ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fc80000011415ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x00000014005c7306ULL, 0x0005e20000200c00ULL,
0x00008880175a7816ULL, 0x042fe200000000ffULL, 0x0000010017177824ULL, 0x000fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x00000015005f7306ULL, 0x0003e20000200c00ULL,
0x0000541066147816ULL, 0x004fce0000000075ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541061157816ULL, 0x002fe40000000060ULL, 0x0000888008617816ULL, 0x000fca00000000ffULL,
0x000000140c28723cULL, 0x000fe20000001828ULL, 0x0000006a006a7306ULL, 0x000e6c0000200c00ULL,
0x0001000008147824ULL, 0x040fe400078e00ffULL, 0x0000001700607306ULL, 0x000be20000200c00ULL,
0x0000010008087824ULL, 0x000fc400078e00ffULL, 0x00000018ff147819ULL, 0x000fc60000011414ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000001400667306ULL, 0x0007e20000200c00ULL,
0x0001000009177824ULL, 0x020fce00078e00ffULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541064147816ULL, 0x008fe40000000065ULL, 0x0000888009647816ULL, 0x040fe200000000ffULL,
0x0000010009097824ULL, 0x000fc800078e00ffULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x00000018ff097819ULL, 0x000fce0000011409ULL, 0x0000000800657306ULL, 0x0005f00000200c00ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541068087816ULL, 0x004fe40000000071ULL,
0x000088800a717816ULL, 0x000fca00000000ffULL, 0x0000000900687306ULL, 0x0003f00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000054106f097816ULL, 0x002fe2000000006aULL,
0x000100000a6f7824ULL, 0x000fc400078e00ffULL, 0x000001000a0a7824ULL, 0x000fe400078e00ffULL,
0x000000ffff6a7224ULL, 0x000fe400078e0071ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000000080c20723cULL, 0x000fe20000001820ULL, 0x00000018ff0a7819ULL, 0x000fcc000001140aULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x000054106d087816ULL, 0x008fe40000000072ULL,
0x0000541070097816ULL, 0x000fe40000000069ULL, 0x00000018ff697819ULL, 0x000fc6000001146fULL,
0x0000004a004a7306ULL, 0x000fe40000200c00ULL, 0x000000080c1c723cULL, 0x000fe2000000181cULL,
0x0000541074157816ULL, 0x002fca0000000067ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x000054106b087816ULL, 0x000fe4000000006eULL, 0x000054106c097816ULL, 0x000fe40000000057ULL,
0x00000018ff677819ULL, 0x000fe20000011417ULL, 0x000000140c24723cULL, 0x000fe20000001824ULL,
0x000088800b6b7816ULL, 0x000fe200000000ffULL, 0x00000016005b7306ULL, 0x0005e80000200c00ULL,
0x000000080c18723cULL, 0x000fe80000001818ULL, 0x0000005200527306ULL, 0x000ee20000200c00ULL,
0x0000001048167824ULL, 0x004fc400078e00ffULL, 0x000054105e087816ULL, 0x002fe40000000063ULL,
0x000054105d097816ULL, 0x000fe2000000004aULL, 0x000000ffff4a7224ULL, 0x000fe200078e006bULL,
0xfffffff016737812ULL, 0x000fe200078ee273ULL, 0x0000005000507306ULL, 0x000fe60000200c00ULL,
0x0000000873167c11ULL, 0x000fe2000f8e20ffULL, 0x000000080c10723cULL, 0x000fe20000001810ULL,
0x000054105b5d7816ULL, 0x008fc60000000052ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000000001614783bULL, 0x000e640000000200ULL, 0x000100000b097824ULL, 0x040fe400078e00ffULL,
0x000001000b0b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fce000001140bULL,
0x0000005500557306ULL, 0x000eb00000200c00ULL, 0x0000004a00087306ULL, 0x0007e20000200c00ULL,
0x0000541054547816ULL, 0x004fce0000000055ULL, 0x0000000900097306ULL, 0x000ea20000200c00ULL,
0x000054104d4a7816ULL, 0x008fce0000000056ULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x0000541008087816ULL, 0x004fce0000000009ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x00005410624b7816ULL, 0x008fce000000004bULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x0000004a1430723cULL, 0x002fe20000001830ULL, 0x0000541058557816ULL, 0x004fcc0000000053ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x00000054142c723cULL, 0x000fe2000000182cULL,
0x00005410605b7816ULL, 0x008fcc0000000051ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000e700000200c00ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x00005410595c7816ULL, 0x002fce000000005cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000005c1428723cULL, 0x000fe20000001828ULL,
0x000054105a5a7816ULL, 0x004fcc000000005fULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005a1424723cULL, 0x000fee0000001824ULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x002fce0000000067ULL,
0x0000006900697306ULL, 0x000e700000200c00ULL, 0x0000000a00577306ULL, 0x0004e20000200c00ULL,
0x000054106a567816ULL, 0x002fce0000000069ULL, 0x0000000b000d7306ULL, 0x0003620000200c00ULL,
0x00005410610a7816ULL, 0x004fe40000000066ULL, 0x0000541057577816ULL, 0x008fe4000000004eULL,
0x00005410650b7816ULL, 0x002fe40000000050ULL, 0x0000541068657816ULL, 0x000fc6000000004fULL,
0x000000561418723cULL, 0x000fe20000001818ULL, 0x000054100d097816ULL, 0x020fca000000004cULL,
0x0000000a1420723cULL, 0x000fec0000001820ULL, 0x00000064141c723cULL, 0x000fec000000181cULL,
0x000000081410723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000280947ULL, 0x000fde000383ffffULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x00000034300b7220ULL, 0x080fe20000410000ULL, 0x0000003420307220ULL, 0x080fe20000410000ULL,
0x0000003421427220ULL, 0x080fe20000410000ULL, 0x000000341e207220ULL, 0x080fe20000410000ULL,
0x000000341f217220ULL, 0x080fe20000410000ULL, 0x01768809360879a7ULL, 0x000262000850003fULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x080fe20000410000ULL, 0x00000034280a7220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x000000342a2a7220ULL, 0x080fe20000410000ULL,
0x000000342b2b7220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x080fe20000410000ULL, 0x0000003426267220ULL, 0x080fe20000410000ULL,
0x0000003427277220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x00000034101e7220ULL, 0x080fe20000410000ULL,
0x00000034111f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x002fce0000410000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x01768809360075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff107224ULL, 0x000fce00078e00ffULL, 0x000000101000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000110107836ULL, 0x000fce0000000000ULL, 0x01768809360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000406087824ULL, 0x000fe200078e00ffULL,
0x0000000840097c11ULL, 0x000fe4000f8e38ffULL, 0x000000043d00720cULL, 0x000fe40003f06070ULL,
0xfffffff008087812ULL, 0x000fca00078ec0ffULL, 0x0000000109287824ULL, 0x000fca00078e0208ULL,
0x0174000028147984ULL, 0x0002a20000000c00ULL, 0x0000001400248947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000004000c7d06ULL, 0x000ee20008209000ULL, 0xffffff003f3f7836ULL, 0x000fe20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bf85070ULL, 0x0000000206447824ULL, 0x000fe200078e00ffULL,
0x00000004ff107c12ULL, 0x000fc8000f8e33ffULL, 0x0000000644447812ULL, 0x000fca00078ec0ffULL,
0x0000000144467824ULL, 0x000fe200078e0203ULL, 0x0000000c000c7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0c0e7836ULL, 0x008fcc0000000000ULL, 0x0000000e00097305ULL, 0x000ee4000021f000ULL,
0x000000ffff0d7224ULL, 0x008fc800078e0a09ULL, 0x000000040d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d090f7227ULL, 0x000fe200078e0008ULL, 0x0000004106087211ULL, 0x000fca00078ff0ffULL,
0x000000080f097227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a09ULL,
0x000000040d0c7c24ULL, 0x000fe4000f8e0208ULL, 0x0000000808087836ULL, 0x000fc60000000000ULL,
0x000000040c007c0cULL, 0x000fe2000bf06070ULL, 0x000000080f0e7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a0eULL, 0x000000040d0d7c24ULL, 0x000fe2000f8e0208ULL,
0x0000003f3a087248ULL, 0x000fc60007fe0000ULL, 0x800000040c0c0c36ULL, 0x000fe20008000000ULL,
0x000000040d007c0cULL, 0x000fe2000bf46070ULL, 0x00000001083f7824ULL, 0x000fe400078e0a3fULL,
0x0000000109090836ULL, 0x000fe20000000000ULL, 0x000000040c007c0cULL, 0x000fe2000bf26070ULL,
0x00000001390c7824ULL, 0x000fe400078e0244ULL, 0x000000ffff5e7224ULL, 0x000fc600078e0a3fULL,
0x0000003f0c00720cULL, 0x000fe40003f66070ULL, 0x0000005e0c0c7246ULL, 0x000fe20003800037ULL,
0x800000040d0d2c36ULL, 0x000fe20008000000ULL, 0x0000005e46557246ULL, 0x000fe20003800037ULL,
0x000000010e0e2836ULL, 0x000fe20000000000ULL, 0x00000004ff0c7819ULL, 0x000fe2000001160cULL,
0x0000000109091836ULL, 0x000fe20000000000ULL, 0x000000040d007c0cULL, 0x000fe4000bf06070ULL,
0x000000ff0c0f7207ULL, 0x000fc40001800000ULL, 0x0000000910087207ULL, 0x000fe40006000000ULL,
0x0000003f4600720cULL, 0x000fe40003f26070ULL, 0x0000000837087248ULL, 0x000fe40003fe0000ULL,
0x000000ff55557207ULL, 0x000fc60000800000ULL, 0x0000000508607c24ULL, 0x000fe4000f8e02ffULL,
0x000000010e0e0836ULL, 0x000fe40000000000ULL, 0x0000000160097824ULL, 0x000fe200078e020fULL,
0x00000060550d7211ULL, 0x000fe400078fe0ffULL, 0x00000010444a7812ULL, 0x000fe200078efcffULL,
0x0000000209087825ULL, 0x000fe200078e0076ULL, 0x0000000e100e7207ULL, 0x000fc60006000000ULL,
0x000000020d0c7825ULL, 0x000fe200078e0076ULL, 0x0000000608597981ULL, 0x0044e2000c1e9500ULL,
0x0000000e370e7248ULL, 0x000fc60003fe0000ULL, 0x000000060c5c7981ULL, 0x000ae4000c1e9500ULL,
0x000000050e627c24ULL, 0x000fe4000f8e02ffULL, 0x0000000139087824ULL, 0x004fc600078e024aULL,
0x0000006255117211ULL, 0x000fe200078fe0ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0262ULL,
0x0000005e08097246ULL, 0x000fc60003800037ULL, 0x000000020f0e7825ULL, 0x000fe200078e0076ULL,
0x0000003f0800720cULL, 0x080fe40003f26070ULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x0000000211107825ULL, 0x000fe200078e0076ULL, 0x00000020444e7812ULL, 0x000fe200078efcffULL,
0x000000060e537981ULL, 0x0004e2000c1e9500ULL, 0x000000ff094b7207ULL, 0x000fe20000800000ULL,
0x000000014a487824ULL, 0x000fe400078e0203ULL, 0x0000000139527824ULL, 0x000fe200078e024eULL,
0x0000000610647981ULL, 0x0004e2000c1e9500ULL, 0x0000000160097824ULL, 0x000fe200078e024bULL,
0x0000003f4800720cULL, 0x000fc40003f06070ULL, 0x0000005e48477246ULL, 0x000fe20003800037ULL,
0x0000000209087825ULL, 0x000fe200078e0076ULL, 0x0000005e524d7246ULL, 0x000fe40003800037ULL,
0x000000ff47477207ULL, 0x000fe40000000000ULL, 0x0000000608497981ULL, 0x0004e2000c1e9500ULL,
0x0000003f5200720cULL, 0x000fe20003f26070ULL, 0x000000014e507824ULL, 0x000fe200078e0203ULL,
0x00000060470d7211ULL, 0x022fe200078fe0ffULL, 0x000000014b0f7824ULL, 0x004fe200078e0262ULL,
0x0000006247117211ULL, 0x000fc400078fe0ffULL, 0x00000004ff087819ULL, 0x000fe2000001164dULL,
0x000000020d0c7825ULL, 0x100fe200078e0076ULL, 0x0000003044547812ULL, 0x000fe400078efcffULL,
0x000000ff08517207ULL, 0x000fe20000800000ULL, 0x000000020f0e7825ULL, 0x100fe200078e0076ULL,
0x0000003f5000720cULL, 0x000fe20003f06070ULL, 0x000000060c4c7981ULL, 0x0002a2000c1e9500ULL,
0x0000005e504d7246ULL, 0x000fe20003800037ULL, 0x0000000211107825ULL, 0x000fe400078e0076ULL,
0x000000060e4b7981ULL, 0x000aa4000c1e9500ULL, 0x0000000160097824ULL, 0x000fc400078e0251ULL,
0x0000000139667824ULL, 0x000fe200078e0254ULL, 0x000000ff4d4d7207ULL, 0x000fe20000000000ULL,
0x0000000610527981ULL, 0x000aa2000c1e9500ULL, 0x0000000209087825ULL, 0x000fe400078e0076ULL,
0x0000005e66577246ULL, 0x000fe40003800037ULL, 0x0000000154587824ULL, 0x000fe200078e0203ULL,
0x000000604d0d7211ULL, 0x002fe200078fe0ffULL, 0x00000001510f7824ULL, 0x020fe200078e0262ULL,
0x00000006084f7981ULL, 0x000362000c1e9500ULL, 0x000000624d117211ULL, 0x000fc400078fe0ffULL,
0x000000020d0c7825ULL, 0x100fe200078e0076ULL, 0x0000003f6600720cULL, 0x080fe40003f26070ULL,
0x0000003f5800720cULL, 0x000fe20003f06070ULL, 0x000000020f0e7825ULL, 0x000fe200078e0076ULL,
0x000000060c567981ULL, 0x000364000c1e9500ULL, 0x00000004ff087819ULL, 0x002fe20000011657ULL,
0x0000000211107825ULL, 0x000fe200078e0076ULL, 0x0000005e58577246ULL, 0x000fe20003800037ULL,
0x000000060e517981ULL, 0x000362000c1e9500ULL, 0x000000ff085b7207ULL, 0x000fc40000800000ULL,
0x000000ff57577207ULL, 0x000fe20000000000ULL, 0x00000006105a7981ULL, 0x000364000c1e9500ULL,
0x0000000160097824ULL, 0x000fe200078e025bULL, 0x00000060570d7211ULL, 0x000fc600078fe0ffULL,
0x0000000209087825ULL, 0x000fc800078e0076ULL, 0x000000020d0c7825ULL, 0x000fe400078e0076ULL,
0x0000000608087981ULL, 0x000364000c1e9500ULL, 0x00000062570f7211ULL, 0x002fe400078fe0ffULL,
0x000000060c0d7981ULL, 0x000362000c1e9500ULL, 0x000000015b117824ULL, 0x000fe400078e0262ULL,
0x000000020f0e7825ULL, 0x000fc800078e0076ULL, 0x0000000211107825ULL, 0x000fe400078e0076ULL,
0x000000060e0e7981ULL, 0x000f68000c1e9500ULL, 0x0000000610117981ULL, 0x000362000c1e9500ULL,
0xfffffff055607812ULL, 0x000fe200078ec0ffULL, 0x00000001ff557424ULL, 0x000fc800078e00ffULL,
0x000000013f097824ULL, 0x000fc800078e0260ULL, 0x0000000146667824ULL, 0x000fe200078e0a09ULL,
0x00000001445e7812ULL, 0x040fe400078efcffULL, 0x00000009440c7812ULL, 0x002fe400078efcffULL,
0x0000006655667219ULL, 0x000fe200000006ffULL, 0x000000015e627824ULL, 0x100fe400078e0203ULL,
0x000000010c107824ULL, 0x000fe400078e0203ULL, 0x0000000162687824ULL, 0x000fc400078e0a09ULL,
0x00000001106c7824ULL, 0x000fc600078e0a09ULL, 0x0000006855687219ULL, 0x040fe400000006ffULL,
0x0000006c556c7219ULL, 0x000fe400000006ffULL, 0x00000011447a7812ULL, 0x040fe400078efcffULL,
0x0000001844787812ULL, 0x040fe400078efcffULL, 0xfffffff04d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000001944747812ULL, 0x000fc400078efcffULL, 0xfffffff057577812ULL, 0x000fe200078ec0ffULL,
0x000000017a0f7824ULL, 0x000fe400078e0203ULL, 0x000000013f6f7824ULL, 0x040fe400078e024dULL,
0x00000001747c7824ULL, 0x000fe400078e0203ULL, 0x000000013f637824ULL, 0x000fe400078e0257ULL,
0x0000000150717824ULL, 0x000fe200078e0a6fULL, 0x00000021446e7812ULL, 0x000fca00078efcffULL,
0x000000016e727824ULL, 0x000fe400078e0203ULL, 0x0000000158697824ULL, 0x000fe400078e0a63ULL,
0x00000001726b7824ULL, 0x000fc600078e0a6fULL, 0x0000006955697219ULL, 0x040fe400000006ffULL,
0x0000006b556b7219ULL, 0x000fe400000006ffULL, 0x000054105c597816ULL, 0x008fe40000000059ULL,
0x00000008445c7812ULL, 0x000fe400078efcffULL, 0x0000005966ff7212ULL, 0x000fc6000780c0ffULL,
0x000000015c607824ULL, 0x000fe200078e0203ULL, 0x0000003f4600720cULL, 0x000fc60000701470ULL,
0x00000001606a7824ULL, 0x000fe200078e0a09ULL, 0x0000003f4400720cULL, 0x000fc800007a1070ULL,
0x0000006a556a7219ULL, 0x000fe400000006ffULL, 0xff8000000b0b7808ULL, 0x000fe40002800000ULL,
0x0000541064537816ULL, 0x000fc80000000053ULL, 0x0000005366ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005368ff7212ULL, 0x080fe4000780c0ffULL, 0x000000536aff7212ULL, 0x080fe400078cc0ffULL,
0x000000536cff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff047537812ULL, 0x000fe200078ec0ffULL,
0x0000000178097824ULL, 0x000fc800078e0203ULL, 0x000000013f537824ULL, 0x000fe200078e0253ULL,
0x0000005968ff7212ULL, 0x080fe4000782c0ffULL, 0x000000596aff7212ULL, 0x080fe2000786c0ffULL,
0x00000001484d7824ULL, 0x100fe200078e0a53ULL, 0x000000596cff7212ULL, 0x000fe2000788c0ffULL,
0x000000010f577824ULL, 0x100fe200078e0a53ULL, 0x0000003f4600720cULL, 0x080fe20001741470ULL,
0x0000000109597824ULL, 0x100fe200078e0a53ULL, 0x0000003f6000720cULL, 0x080fe400037c1470ULL,
0x0000003f1000720cULL, 0x000fe20002fa1470ULL, 0x000000017c617824ULL, 0x000fe200078e0a53ULL,
0x0000004d55537219ULL, 0x000fc400000006ffULL, 0x00000057554d7219ULL, 0x040fe400000006ffULL,
0x0000003f4400720cULL, 0x080fe40001741070ULL, 0x0000003f5c00720cULL, 0x080fe400037c1070ULL,
0x0000003f0c00720cULL, 0x000fe40002fa1070ULL, 0x0000005955577219ULL, 0x000fe400000006ffULL,
0x000054104c4c7816ULL, 0x004fc40000000049ULL, 0x0000541052527816ULL, 0x000fe4000000004bULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000004c53ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005253ff7212ULL, 0x000fc400078cc0ffULL, 0x0000005257ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003f6200720cULL, 0x0c0fe40000f21470ULL, 0x0000003f6200720cULL, 0x080fe40000701470ULL,
0x0000003f6000720cULL, 0x080fe40001f61470ULL, 0x0000003f1000720cULL, 0x080fe40002781470ULL,
0x0000003f4800720cULL, 0x000fc40001741470ULL, 0x0000003f4800720cULL, 0x080fe400037c1470ULL,
0x0000003f0900720cULL, 0x080fe40002fa1470ULL, 0x00000028446c7812ULL, 0x040fe400078efcffULL,
0x00000029446a7812ULL, 0x000fe400078efcffULL, 0x0000003f5e00720cULL, 0x0c0fe40000f21070ULL,
0x0000003f5e00720cULL, 0x000fc40000701070ULL, 0x0000003f5c00720cULL, 0x080fe40001f61070ULL,
0x0000003f0c00720cULL, 0x080fe40002781070ULL, 0x0000003f4a00720cULL, 0x0c0fe40001741070ULL,
0x0000003f4a00720cULL, 0x080fe400037c1070ULL, 0x0000003f7800720cULL, 0x000fe40002fa1070ULL,
0x0000006155617219ULL, 0x000fc400000006ffULL, 0x0000007155597219ULL, 0x000fe400000006ffULL,
0x0000541056567816ULL, 0x020fe4000000004fULL, 0x000054105a5a7816ULL, 0x000fe20000000051ULL,
0x000000016c707824ULL, 0x100fe200078e0203ULL, 0xff80000031317808ULL, 0x000fe20000800000ULL,
0x000000016a477824ULL, 0x000fe200078e0203ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff8000002c2c7808ULL, 0x000fc40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff8000000a0a7808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000004c4dff7212ULL, 0x080fe4000782c0ffULL,
0x0000004c57ff7212ULL, 0x000fc4000780c0ffULL, 0x0000004c61ff7212ULL, 0x000fe4000786c0ffULL,
0x000000524dff7212ULL, 0x080fe4000788c0ffULL, 0x0000005261ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005659ff7212ULL, 0x040fe400078cc0ffULL, 0x0000005a59ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001706d7824ULL, 0x100fe200078e0a6fULL, 0x0000003f0f00720cULL, 0x080fe20000f21470ULL,
0x00000001476f7824ULL, 0x000fe200078e0a6fULL, 0x0000003f0f00720cULL, 0x000fc40002781470ULL,
0x0000003f0900720cULL, 0x080fe40000701470ULL, 0x0000003f7c00720cULL, 0x0c0fe40001f61470ULL,
0x0000003f7c00720cULL, 0x080fe40001741470ULL, 0x0000003f5000720cULL, 0x0c0fe400037c1470ULL,
0x0000003f5000720cULL, 0x000fe40002fa1470ULL, 0x0000003144687812ULL, 0x000fc400078efcffULL,
0x0000003844667812ULL, 0x040fe400078efcffULL, 0x0000003944647812ULL, 0x000fe400078efcffULL,
0x0000003f7a00720cULL, 0x0c0fe40000f21070ULL, 0x0000003f7a00720cULL, 0x080fe40002781070ULL,
0x0000003f7800720cULL, 0x080fe40000701070ULL, 0x0000003f7400720cULL, 0x000fc40001f61070ULL,
0x0000003f7400720cULL, 0x080fe40001741070ULL, 0x0000003f4e00720cULL, 0x0c0fe400037c1070ULL,
0x0000003f4e00720cULL, 0x000fe40002fa1070ULL, 0x0000006d556d7219ULL, 0x040fe400000006ffULL,
0x0000006f556f7219ULL, 0x000fe400000006ffULL, 0x000054100d087816ULL, 0x000fe20000000008ULL,
0x00000001685f7824ULL, 0x100fe200078e0203ULL, 0xff80000029297808ULL, 0x000fe20000800000ULL,
0x00000001665d7824ULL, 0x100fe200078e0203ULL, 0xff8000002b2b7808ULL, 0x000fe20002000000ULL,
0x00000001645b7824ULL, 0x000fe200078e0203ULL, 0xff80000024247808ULL, 0x000fc40000000000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40003000000ULL, 0xff80000022227808ULL, 0x000fe40002800000ULL,
0x000000566bff7212ULL, 0x080fe4000782c0ffULL, 0x000000566dff7212ULL, 0x000fc4000788c0ffULL,
0x000000566fff7212ULL, 0x000fe4000780c0ffULL, 0x0000005a6bff7212ULL, 0x080fe4000786c0ffULL,
0x0000005a6dff7212ULL, 0x080fe4000784c0ffULL, 0x0000005a6fff7212ULL, 0x000fe400078cc0ffULL,
0x0000000869ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015f677824ULL, 0x100fe200078e0a63ULL,
0x0000003f7200720cULL, 0x0c0fe20000f21470ULL, 0x000000015d657824ULL, 0x100fe200078e0a63ULL,
0x0000003f7200720cULL, 0x080fe20001f61470ULL, 0x000000015b637824ULL, 0x000fe200078e0a63ULL,
0x0000003f7000720cULL, 0x000fc40002781470ULL, 0x0000003f7000720cULL, 0x080fe40001741470ULL,
0x0000003f4700720cULL, 0x0c0fe40000701470ULL, 0x0000003f4700720cULL, 0x080fe400037c1470ULL,
0x0000003f5800720cULL, 0x080fe40002fa1470ULL, 0x0000003f6e00720cULL, 0x0c0fe40000f21070ULL,
0x0000003f6e00720cULL, 0x000fc40001f61070ULL, 0x0000003f6c00720cULL, 0x0c0fe40002781070ULL,
0x0000003f6c00720cULL, 0x080fe40001741070ULL, 0x0000003f6a00720cULL, 0x0c0fe40000701070ULL,
0x0000003f6a00720cULL, 0x080fe400037c1070ULL, 0x0000003f5400720cULL, 0x000fe40002fa1070ULL,
0x0000006755677219ULL, 0x000fc400000006ffULL, 0x0000006555657219ULL, 0x040fe400000006ffULL,
0x0000006355637219ULL, 0x000fe400000006ffULL, 0x000054100e0e7816ULL, 0x000fe40000000011ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff80000023237808ULL, 0x000fe40001800000ULL,
0xff8000001c1c7808ULL, 0x000fc40002000000ULL, 0xff80000020207808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40000000000ULL, 0xff80000021217808ULL, 0x000fe40003000000ULL,
0xff80000018187808ULL, 0x000fe40002800000ULL, 0x0000000867ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000865ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000863ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000e69ff7212ULL, 0x080fe4000784c0ffULL, 0x0000000e67ff7212ULL, 0x080fe4000780c0ffULL,
0x0000000e65ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000e63ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003f5800720cULL, 0x000fc40001741470ULL, 0x0000003f5f00720cULL, 0x0c0fe40000f21470ULL,
0x0000003f5f00720cULL, 0x080fe40000701470ULL, 0x0000003f5d00720cULL, 0x0c0fe40001f61470ULL,
0x0000003f5d00720cULL, 0x080fe400037c1470ULL, 0x0000003f5b00720cULL, 0x0c0fe40002781470ULL,
0x0000003f5b00720cULL, 0x000fc40002fa1470ULL, 0x0000003f5400720cULL, 0x080fe40001741070ULL,
0x0000003f6800720cULL, 0x0c0fe40000f21070ULL, 0x0000003f6800720cULL, 0x080fe40000701070ULL,
0x0000003f6600720cULL, 0x0c0fe40001f61070ULL, 0x0000003f6600720cULL, 0x080fe400037c1070ULL,
0x0000003f6400720cULL, 0x000fc40002781070ULL, 0x0000003f6400720cULL, 0x000fe40002fa1070ULL,
0xff80000019197808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff8000001a1a7808ULL, 0x000fe40001000000ULL,
0xff8000001b1b7808ULL, 0x000fc40000000000ULL, 0xff80000012127808ULL, 0x000fe40003000000ULL,
0xff80000013137808ULL, 0x000fce0002800000ULL, 0x0000000b1400720bULL, 0x004fe20003f1e000ULL,
0x000000013d3d7836ULL, 0x000fe20000000000ULL, 0xfffffff8ff457812ULL, 0x000fe400078ee245ULL,
0x000000140b147208ULL, 0x000fc80004000000ULL, 0x000000311400720bULL, 0x000fc80003f1e000ULL,
0x0000001431097208ULL, 0x000fc80004000000ULL, 0x0000002c0900720bULL, 0x000fc80003f1e000ULL,
0x000000092c087208ULL, 0x000fc80004000000ULL, 0x0000002d0800720bULL, 0x000fc80003f1e000ULL,
0x000000082d097208ULL, 0x000fc80004000000ULL, 0x0000000a0900720bULL, 0x000fc80003f1e000ULL,
0x000000090a087208ULL, 0x000fc80004000000ULL, 0x000000290800720bULL, 0x000fc80003f1e000ULL,
0x0000000829097208ULL, 0x000fc80004000000ULL, 0x000000240900720bULL, 0x000fc80003f1e000ULL,
0x0000000924087208ULL, 0x000fc80004000000ULL, 0x000000250800720bULL, 0x000fc80003f1e000ULL,
0x0000000825097208ULL, 0x000fc80004000000ULL, 0x000000300900720bULL, 0x000fc80003f1e000ULL,
0x0000000930097208ULL, 0x000fc80004000000ULL, 0x000000420900720bULL, 0x000fc80003f1e000ULL,
0x0000000942097208ULL, 0x000fc80004000000ULL, 0x0000001c0900720bULL, 0x000fc80003f1e000ULL,
0x000000091c087208ULL, 0x000fe40004000000ULL, 0x000000321500720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fc80003f3e000ULL, 0x000000081d097208ULL, 0x000fe40004800000ULL,
0x0000001532087208ULL, 0x000fe40004000000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x000000330800720bULL, 0x000fe40003f1e000ULL, 0x00000009180c7208ULL, 0x000fe40004800000ULL,
0x0000000833097208ULL, 0x000fc40004000000ULL, 0x000000190c00720bULL, 0x000fe40003f3e000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000c190d7208ULL, 0x000fe40004800000ULL,
0x000000092e087208ULL, 0x000fe40004000000ULL, 0x0000001e0d00720bULL, 0x000fe40003f3e000ULL,
0x0000002f0800720bULL, 0x000fc40003f1e000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004800000ULL,
0x000000082f097208ULL, 0x000fe40004000000ULL, 0x0000001f0c00720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x0000000c1f0c7208ULL, 0x000fe40004800000ULL,
0x000000092a087208ULL, 0x000fc60004000000ULL, 0x0c401f000c0d7f89ULL, 0x000ea200000e0000ULL,
0x0000002b0800720bULL, 0x000fc80003f1e000ULL, 0x000000082b097208ULL, 0x000fc80004000000ULL,
0x000000260900720bULL, 0x000fc80003f1e000ULL, 0x0000000926087208ULL, 0x000fc80004000000ULL,
0x000000270800720bULL, 0x000fc80003f1e000ULL, 0x0000000827097208ULL, 0x000fe40004000000ULL,
0x0000000d0c00720bULL, 0x004fe40003f3e000ULL, 0x000000220900720bULL, 0x000fe40003f1e000ULL,
0x0000000c0d0d7208ULL, 0x000fe40004800000ULL, 0x0000000922087208ULL, 0x000fc60004000000ULL,
0x0c201f000d147f89ULL, 0x000ea200000e0000ULL, 0x000000230800720bULL, 0x000fc80003f1e000ULL,
0x0000000823097208ULL, 0x000fc80004000000ULL, 0x000000200900720bULL, 0x000fc80003f1e000ULL,
0x0000000920087208ULL, 0x000fc80004000000ULL, 0x000000210800720bULL, 0x000fc80003f1e000ULL,
0x0000000821097208ULL, 0x000fe40004000000ULL, 0x000000140d00720bULL, 0x004fe40003f3e000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x0000000d14147208ULL, 0x000fe40004800000ULL,
0x000000091a087208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b140c7820ULL, 0x000fe20000410000ULL,
0x0000001b0800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001080cULL,
0x000000081b097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL,
0x000000120900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL,
0x0000002900447308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe2000001080cULL,
0x0000000912087208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080cULL,
0x000000130800720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30107823ULL, 0x100fe2000001080cULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c297823ULL, 0x104fe2000001080cULL,
0x0000000813087208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b42117823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b18187823ULL, 0x000fc6000001080cULL, 0x0c401f0008097f89ULL, 0x000ea200000e0000ULL,
0x00000031000e7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d000d7308ULL, 0x0007620000000800ULL, 0x000000090800720bULL, 0x004fce0003f1e000ULL,
0x0000000a000f7308ULL, 0x000be20000000800ULL, 0x3fb8aa3b192d7823ULL, 0x108fe2000001080cULL,
0x3fb8aa3b1e197823ULL, 0x100fe2000001080cULL, 0x0000000809087208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1f0c7823ULL, 0x000fc8000001080cULL, 0x0c201f0008157f89ULL, 0x000ea200000e0000ULL,
0x0000002400317308ULL, 0x0007e20000000800ULL, 0x0000002c0d0a723eULL, 0x022fce00000000ffULL,
0x0000002500467308ULL, 0x0003620000000800ULL, 0x3c003c00ff247424ULL, 0x008fce00078e00ffULL,
0x0000001d00307308ULL, 0x000fe20000000800ULL, 0x3c003c00ff257424ULL, 0x002fe200078e00ffULL,
0x000000150800720bULL, 0x004fcc0003f1e000ULL, 0x0000000c00427308ULL, 0x0003e20000000800ULL,
0x0000000815157208ULL, 0x000fe40004000000ULL, 0x0000000b0e08723eULL, 0x000fe400000000ffULL,
0x00000031460e723eULL, 0x020fe200000000ffULL, 0x3fb8aa3b153f7820ULL, 0x000fe20000410000ULL,
0x0000000f440c723eULL, 0x002fe200000000ffULL, 0x0000001000107308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083fULL,
0x0000003200097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b202c7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001083fULL, 0x0c401f0017207f89ULL, 0x000e6200000e0000ULL,
0x00000033001c7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fce000001083fULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000091c09723eULL, 0x004fce00000000ffULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x000000201700720bULL, 0x002fce0003f3e000ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000001720177208ULL, 0x000fe40004800000ULL,
0x00000003ff207819ULL, 0x000fe40000011606ULL, 0x0000002e2f0b723eULL, 0x004fc600000000ffULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b212e7823ULL, 0x000fe2000001083fULL,
0x0000000320207812ULL, 0x000fe200078ec0ffULL, 0x0c401f0016217f89ULL, 0x000ea200000e0000ULL,
0x00000024081c723cULL, 0x000fe800000018ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x0000002a2b0d723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x000000211600720bULL, 0x004fe40003f1e000ULL,
0x00000026270f723eULL, 0x002fca00000000ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x3fb8aa3b12277823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b133f7823ULL, 0x000fe2000001083fULL,
0x0000001621167208ULL, 0x000fe40004000000ULL, 0x0000000840217c11ULL, 0x000fe2000f8e58ffULL,
0x000000240c1c723cULL, 0x000fe2000000181cULL, 0x000000101110723eULL, 0x008fe200000000ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000293012723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0c201f0016297f89ULL, 0x000eae00000e0000ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000222311723eULL, 0x002fce00000000ffULL,
0x0000002e002b7308ULL, 0x0002e20000000800ULL, 0x0000000845237836ULL, 0x000fe40000000000ULL,
0x0000000845227824ULL, 0x000fca00078e00ffULL, 0x0000001900197308ULL, 0x000f620000000800ULL,
0x000000291600720bULL, 0x004fe20003f1e000ULL, 0x00000008232e7824ULL, 0x002fc600078e00ffULL,
0x0000001629167208ULL, 0x000fe40004000000ULL, 0x0000002c2b13723eULL, 0x008fe200000000ffULL,
0x0000001a00267308ULL, 0x000be20000000800ULL, 0x00000008232b7824ULL, 0x000fe200078e00ffULL,
0x0000000306ff7812ULL, 0x000fc8000780c0ffULL, 0x00000024101c723cULL, 0x000fe4000000181cULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x00000019421a723eULL, 0x020fce00000000ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000261b19723eULL, 0x002fce00000000ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000000120267824ULL, 0x000fe400078e0223ULL,
0x000000ffff237224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe200078e0019ULL,
0xfffffff82b267812ULL, 0x000fe200078ee226ULL, 0x00011000212b7836ULL, 0x000fe20000000000ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x00000010262c7824ULL, 0x000fc400078e022bULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0x000000182d18723eULL, 0x002fe400000000ffULL, 0x0000003f002a7308ULL, 0x000e620000000800ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0013ULL, 0x000000ffff267224ULL, 0x000fe200078e0018ULL,
0x000000272a1b723eULL, 0x002fe200000000ffULL, 0x0000000845277824ULL, 0x000fe200078e00ffULL,
0x0c201f00172a7f89ULL, 0x000e6200000e0000ULL, 0x0000000120457824ULL, 0x000fc800078e0245ULL,
0x00000024181c723cULL, 0x000fe2000000181cULL, 0xfffffff822207812ULL, 0x000fe200078ee245ULL,
0x0000000445227836ULL, 0x000fe40000000000ULL, 0x0000000c45457836ULL, 0x000fc60000000000ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x000000ffff247224ULL, 0x000fe200078e0010ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee245ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff277224ULL, 0x000fe400078e001aULL, 0x000000102e2e7824ULL, 0x000fe200078e022bULL,
0x0000002a1700720bULL, 0x002fca0003f3e000ULL, 0x00000010201d7824ULL, 0x100fe400078e022bULL,
0x00000010221f7824ULL, 0x000fe200078e022bULL, 0x000000172a177208ULL, 0x000fe20004800000ULL,
0x000000ffff207224ULL, 0x000fe400078e0008ULL, 0x000000ffff227224ULL, 0x000fe400078e000cULL,
0x000000ffff087224ULL, 0x000fe400078e0009ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0x000000201d007844ULL, 0x0003e20000000200ULL, 0x000000ffff0b7224ULL, 0x000fc400078e000fULL,
0x000000ffff0c7224ULL, 0x000fe200078e0011ULL, 0x000000241f007844ULL, 0x0005e20000000200ULL,
0x000000ffff0f7224ULL, 0x000fe400078e001bULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000082c007844ULL, 0x0005e80000000200ULL, 0x0000000c2e007844ULL, 0x0005e20000000200ULL,
0x000000ffff1d7224ULL, 0x002fc600078e001eULL, 0x0170001428008388ULL, 0x0005e20000000c00ULL,
0x000000ffff207224ULL, 0x000fc600078e003eULL, 0x0172001c28008388ULL, 0x0005e20000000a00ULL,
0x000000383d00720cULL, 0x000fe20003f06070ULL, 0x017608113cff79a7ULL, 0x0005e2000850003fULL,
0x017610113cff79a7ULL, 0x0005e2000850003fULL, 0x017618113cff79a7ULL, 0x0005e2000850003fULL,
0x017620113cff79a7ULL, 0x0005f2000850003fULL, 0xffffffac008c8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000050007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000005000008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff50ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000050027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005000007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffecc02b47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006f8ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000950ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a30ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a84ULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001140ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000013200ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014380ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x00000000000143d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000143d0ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000149c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000149c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013200ULL, 0x0000000000013200ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014380ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000143d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 84760;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
