/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015250ULL, 0x0000000000014ed0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000013260ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x00000000000133e0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000013420ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000013470ULL, 0x0000000000000110ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000013580ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001326000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x004b040400288080ULL, 0x0000000000000000ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880808608288080ULL,
0x808d082880808708ULL, 0x082880808e082880ULL, 0x808090082880808fULL, 0x9308288080920828ULL,
0x2880809408288080ULL, 0x8097082880809508ULL, 0x08288080b3082880ULL, 0x8080c808288080c2ULL,
0x8016288080840828ULL, 0x0000000310288082ULL, 0x8084920000000000ULL, 0x0000000022002880ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001326000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880808608288080ULL,
0x808c082880808708ULL, 0x082880808e082880ULL, 0x808090082880808fULL, 0x9208288080910828ULL,
0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808097082880ULL, 0x8080b308288080a1ULL,
0xc808288080c20828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000015000000000ULL, 0x000133e000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8508288080820828ULL, 0x2880808608288080ULL, 0x808d082880808708ULL, 0x082880808e082880ULL,
0x808090082880808fULL, 0x9308288080920828ULL, 0x2880809408288080ULL, 0x8097082880809508ULL,
0x08288080a1082880ULL, 0x8080c208288080b3ULL, 0x9108288080c80828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808091920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000022000000000ULL, 0x0001342000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8090288080910900ULL, 0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8508288080820828ULL, 0x2880808608288080ULL, 0x808e082880808708ULL, 0x082880808f082880ULL,
0x8080920828808091ULL, 0x9408288080930828ULL, 0x2880809508288080ULL, 0x80a1082880809708ULL,
0x08288080b3082880ULL, 0x8080c808288080c2ULL, 0x8016288080900828ULL, 0x0000000310288082ULL,
0x8090920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000030000000000ULL,
0x0001347000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000018ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x00000b7000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000003c001342804ULL, 0x000005c000000490ULL, 0x000028f000002840ULL,
0x00002b8000002a20ULL, 0x0000303000003000ULL, 0x000030d000003080ULL, 0x000050b000005010ULL,
0x00005340000051e0ULL, 0x00005800000057d0ULL, 0x000058a000005850ULL, 0x0000769000007600ULL,
0x00007920000077c0ULL, 0x00007de000007db0ULL, 0x00007e8000007e30ULL, 0x00009ce000009c40ULL,
0x00009f7000009e10ULL, 0x0000a4900000a460ULL, 0x0000a5300000a4e0ULL, 0x0000b8000000b7f0ULL,
0x00011ba000011b60ULL, 0x00011bc000011bb0ULL, 0x00011c3000011bd0ULL, 0x00011c7000011c50ULL,
0x000128e0000128a0ULL, 0x0001297000012930ULL, 0x00012a10000129c0ULL, 0x00012aa000012a60ULL,
0x00012b3000012af0ULL, 0x00012bd000012b80ULL, 0x00012c6000012c20ULL, 0x00012cf000012cb0ULL,
0x00012d9000012d40ULL, 0x00012e2000012de0ULL, 0x00012eb000012e70ULL, 0x00012f5000012f00ULL,
0x0001300000012fa0ULL, 0x000130c000013060ULL, 0x0001318000013120ULL, 0x00013240000131e0ULL,
0x0000042004403904ULL, 0x0000f600000000ffULL, 0x00000460003f0100ULL, 0x0000f60800000011ULL,
0x00000500003f0120ULL, 0x0000f68800000011ULL, 0x00000520003f0120ULL, 0x0000f6a800000011ULL,
0x00000530003f0120ULL, 0x0000f6c800000011ULL, 0x00000bd0003f0120ULL, 0x0000f600000000ffULL,
0x00000d80003f0107ULL, 0x0000000400000002ULL, 0x00000e30003f0102ULL, 0x0000000000000002ULL,
0x00001620003f0101ULL, 0x0000f6a800000072ULL, 0x00001730003f0107ULL, 0x0000f6a800000072ULL,
0x00001790003f0101ULL, 0x0000f6c800000006ULL, 0x00001910003f0101ULL, 0x0000f6cc00000005ULL,
0x00001af0003f0105ULL, 0x0000f6cc00000005ULL, 0x00002460003f0105ULL, 0x0000f6b0000000ffULL,
0x000024e000050107ULL, 0x0000f6b0000000ffULL, 0x0000254000050101ULL, 0x0000f60800000009ULL,
0x00002560003f0101ULL, 0x0000f60c00000009ULL, 0x00002730003f0105ULL, 0x0000f60c00000009ULL,
0x00002d60003f0105ULL, 0x0000f6ac00000024ULL, 0x00002f30003f0105ULL, 0x0000f6ac00000024ULL,
0x000041f0003f0105ULL, 0x000000000000000cULL, 0x00004250003f0101ULL, 0x0000f68800000060ULL,
0x00004280003f0101ULL, 0x000000040000000aULL, 0x00004440003f0105ULL, 0x000000040000000aULL,
0x00004c60003f0105ULL, 0x0000f6a800000005ULL, 0x00004cf0003f0107ULL, 0x0000f6a800000005ULL,
0x00004d50003f0101ULL, 0x0000f62800000009ULL, 0x00004d70003f0101ULL, 0x0000f62c00000009ULL,
0x00004f40003f0105ULL, 0x0000f62c00000009ULL, 0x00005530003f0105ULL, 0x0000f6b400000036ULL,
0x00005700003f0105ULL, 0x0000f6b400000036ULL, 0x00006790003f0105ULL, 0x0000000000000010ULL,
0x000067f0003f0101ULL, 0x0000f69000000012ULL, 0x00006820003f0101ULL, 0x000000040000000aULL,
0x000069e0003f0105ULL, 0x000000040000000aULL, 0x000071e0003f0105ULL, 0x0000f6b000000072ULL,
0x000072e0003f0107ULL, 0x0000f6b00000000dULL, 0x00007340003f0101ULL, 0x0000f64800000009ULL,
0x00007360003f0101ULL, 0x0000f64c00000009ULL, 0x00007530003f0105ULL, 0x0000f64c00000009ULL,
0x00007b10003f0105ULL, 0x0000f6ac00000013ULL, 0x00007ce0003f0105ULL, 0x0000f6ac00000013ULL,
0x00008dd0003f0105ULL, 0x000000000000000eULL, 0x00008e30003f0101ULL, 0x000000000000000dULL,
0x00008e60003f0101ULL, 0x000000040000000aULL, 0x00009020003f0105ULL, 0x000000040000000aULL,
0x00009850003f0105ULL, 0x00000000000000ffULL, 0x0000993000040107ULL, 0x0000f6a800000072ULL,
0x00009990003f0101ULL, 0x0000f6680000000aULL, 0x000099c0003f0101ULL, 0x0000f66c0000000aULL,
0x00009b90003f0105ULL, 0x0000f66c0000000aULL, 0x0000a140003f0105ULL, 0x0000f6b400000072ULL,
0x0000a370003f0105ULL, 0x0000f6b400000072ULL, 0x0000b5c0003f0105ULL, 0x0000000000000002ULL,
0x0000b640003f0101ULL, 0x0000000000000005ULL, 0x0000c9a0003f0101ULL, 0x0000f600000000ffULL,
0x0000d600003f0101ULL, 0x0000f604000000ffULL, 0x0000d810003f0105ULL, 0x0000f604000000ffULL,
0x0000da40003f0105ULL, 0x0000f600000000ffULL, 0x0000da70003f0101ULL, 0x0000f604000000ffULL,
0x0000dc30003f0105ULL, 0x0000f604000000ffULL, 0x0000ff20003f0105ULL, 0x0000000000000074ULL,
0x0000ffc0003f0101ULL, 0x0000000400000074ULL, 0x00010190003f0105ULL, 0x0000000400000074ULL,
0x00012700003f0105ULL, 0x0000000000000077ULL, 0x00012760003f0101ULL, 0x0000000800000077ULL,
0x000127c0003f0101ULL, 0x0000001000000077ULL, 0x00012830003f0101ULL, 0x0000001800000077ULL,
0x00053803003f0101ULL, 0x0000c05000201c04ULL, 0x0000c3100000c080ULL, 0x0000c7000000c500ULL,
0x0000dc900000c8b0ULL, 0x0000040100012870ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003b4ULL,
0x0000001b00000002ULL, 0x00000000000002dcULL, 0x0000001b00000002ULL, 0x000000000000020cULL,
0x0000001b00000002ULL, 0x0000000000000124ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x000000000000038dULL, 0x0000001b00000002ULL, 0x00000000000002b2ULL,
0x0000001b00000002ULL, 0x00000000000001e7ULL, 0x0000001b00000002ULL, 0x00000000000000fdULL,
0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000087ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff060424ULL, 0x000fe200078e00ffULL,
0x0000000105020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0006ULL,
0x00005c0005060625ULL, 0x000fe200078e0006ULL, 0x0000000802690981ULL, 0x0002aa000c1e1900ULL,
0x0000000806060981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff0a7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000767919ULL, 0x000e620000002600ULL, 0x00005a00ff137624ULL, 0x000fc800078e00ffULL,
0x0000590013137a24ULL, 0x000fe200078e02ffULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fcc0007ffe0ffULL, 0x0000000800097305ULL, 0x000864000021f000ULL,
0x000000ffff087224ULL, 0x010fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090b7a27ULL, 0x000fe400078e00ffULL, 0x0000000000097919ULL, 0x000e640000002200ULL,
0x000000ffff037224ULL, 0x000fc800078e0a0bULL, 0x0000040003007624ULL, 0x000fca00078e020aULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0bba12ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000f220000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00027810ULL, 0x010fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000864000021f000ULL, 0x000000ffff027224ULL, 0x010fe400078e00ffULL,
0x000000030b047224ULL, 0x002fc800078e02ffULL, 0x000000ffff077224ULL, 0x008fe400078e0a04ULL,
0x0000000000047919ULL, 0x000e640000002300ULL, 0x0000000703037227ULL, 0x000fe400078e0002ULL,
0x0000000000077919ULL, 0x000ee80000002100ULL, 0x0000007603717227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a71ULL, 0x000000000b007224ULL, 0x000fca00078e0276ULL,
0x0000000b0000720cULL, 0x000fe20003fa6070ULL, 0x0000010004027a24ULL, 0x002fc800078e0209ULL,
0x0000000002117a24ULL, 0x008fca00078e0207ULL, 0x000000ff1100720cULL, 0x000fc60003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0bULL, 0x0000000171715810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1100780cULL, 0x040fe40003f24070ULL, 0x0000000b0000720cULL, 0x000fe40003fc6070ULL,
0x00000005ff007819ULL, 0x000fe40000011607ULL, 0x000000031100780cULL, 0x040fe40003fa4070ULL,
0x0000007f1100780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL, 0x0000000171716810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x0000000bff71c212ULL, 0x000fe200078e33ffULL,
0x00f60002ff00b388ULL, 0x0003e20000000a00ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x7fffff80ff0dd424ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0a71ULL,
0x00f6080811009388ULL, 0x000fe20000008a00ULL, 0xff317217ff10a424ULL, 0x000fc400078e00ffULL,
0x0000000c0b767224ULL, 0x000fe400078e0276ULL, 0x00001fff040b7589ULL, 0x000ee200000e0000ULL,
0x3fffff60ff02d424ULL, 0x002fe400078e00ffULL, 0x0000001076767824ULL, 0x000fe200078e00ffULL,
0x00f400101100a388ULL, 0x000fe20000004800ULL, 0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL,
0x00f688021100d388ULL, 0x0007e20000008a00ULL, 0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL,
0x00f6a80c1100d388ULL, 0x000fe80000008a00ULL, 0x00f6c80e1100b388ULL, 0x000fe20000008a00ULL,
0x000000040b027824ULL, 0x008fc800078e0200ULL, 0x0000000202097824ULL, 0x000fe400078e00ffULL,
0x0000000169690824ULL, 0x004fe400078e0a06ULL, 0x00005800ff698624ULL, 0x000fe400078e00ffULL,
0x0000580005068a24ULL, 0x000fe400078e02ffULL, 0x00005a0069077a24ULL, 0x000fe400078e02ffULL,
0x0000001306757224ULL, 0x000fc400078e02ffULL, 0x0000000107047824ULL, 0x040fe200078e0a76ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000760700720cULL, 0x000fe20003f26070ULL,
0x00005a0071117a24ULL, 0x000fe200078e0275ULL, 0x0000001004047817ULL, 0x000fc80003800000ULL,
0x000000ff04747207ULL, 0x000fc80000800000ULL, 0x000000107400780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000077b06ULL, 0x000e620000209000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000700077308ULL, 0x002e620000001000ULL,
0x00000004ff087819ULL, 0x004fca0000011604ULL, 0x00000001090d7824ULL, 0x000fe200078e0208ULL,
0x0ffffffe07037810ULL, 0x002fcc0007ffe0ffULL, 0x0000000300037305ULL, 0x000e64000021f000ULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a03ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f030f7227ULL, 0x000fc800078e0002ULL, 0x0000000176027824ULL, 0x000fc800078e020dULL,
0x000000020f0f7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0fULL,
0x00005a0007037a24ULL, 0x000fe400078e0202ULL, 0x0000001004077824ULL, 0x000fc600078e00ffULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0faa12ULL, 0x000fca00078e33ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0fULL, 0x00005a0003027a24ULL, 0x000fc800078e0202ULL,
0x00000001110c7824ULL, 0x000fe200078e0202ULL, 0x0000000974027217ULL, 0x000fc60007800000ULL,
0x000000130f037224ULL, 0x000fe200078e020cULL, 0x000000f0070f7812ULL, 0x000fe200078ec0ffULL,
0x0000000102097824ULL, 0x000fe400078e0a09ULL, 0x0000010003027825ULL, 0x000fc600078e00ffULL,
0x000000090800720cULL, 0x000fe20003f06070ULL, 0x000000010d087824ULL, 0x040fe200078e0204ULL,
0x0000000f020f7212ULL, 0x000fe200078efcffULL, 0x000000100d0d7824ULL, 0x000fc600078e00ffULL,
0x000060000f027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00d087812ULL, 0x000fe400078ee208ULL,
0x0000610003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001008097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000c101c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000077b06ULL, 0x000e620000209000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000700077308ULL, 0x002e620000001000ULL,
0x0000000904097211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe07087810ULL, 0x002fca0007ffe0ffULL,
0x0000000800037305ULL, 0x0002a4000021f000ULL, 0x0000000109087824ULL, 0x002fe400078e0204ULL,
0x000000ffff0d7224ULL, 0x004fc800078e0a03ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d03037227ULL, 0x000fc800078e0002ULL, 0x0000000176027824ULL, 0x000fe400078e0209ULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x0000000203037227ULL, 0x000fc600078e00ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x000000ffff077224ULL, 0x000fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fe400078e0202ULL, 0x0000001008097824ULL, 0x000fc600078e00ffULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f26070ULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff03aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000001004077824ULL, 0x000fe400078e00ffULL, 0x0000000111027824ULL, 0x000fc600078e0202ULL,
0x000000f0070d7812ULL, 0x000fe200078ec0ffULL, 0x0000001303027224ULL, 0x000fc800078e0202ULL,
0x0000010002027825ULL, 0x000fca00078e00ffULL, 0x0000000d02027212ULL, 0x000fc800078efcffULL,
0x0000600002027a10ULL, 0x000fc80007f1e0ffULL, 0x0000610003037a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000000000027806ULL, 0x002fe200038e0000ULL,
0x00000004ff627424ULL, 0x000fc600078e00ffULL, 0x0000000200037300ULL, 0x000ea200000e0000ULL,
0x0000680005647625ULL, 0x000fce00078e0062ULL, 0x0000000200097309ULL, 0x000e620000000000ULL,
0x000000080300720cULL, 0x004fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff037224ULL, 0x002fd400078e0a09ULL, 0x00f60403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000864647981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x0000007f646b7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff640b7810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff6b7819ULL, 0x000fe4000001166bULL, 0x00000008ff687819ULL, 0x000fca000001160bULL,
0x0000bbf000008947ULL, 0x000fea0003800000ULL, 0x00000003ff557819ULL, 0x000fe20000011600ULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0x01ffffff55557812ULL, 0x000fc800078ec0ffULL,
0x0000006b5500720cULL, 0x000fda0003f06070ULL, 0x0000000205028824ULL, 0x000fe400078e00ffULL,
0x00006a00ff038624ULL, 0x002fc800078e00ffULL, 0x00006a0002068624ULL, 0x000fe200078e0203ULL,
0x0000f68800027811ULL, 0x000fe200078e18ffULL, 0x00000003ff037424ULL, 0x000fe400078e00ffULL,
0x0000000155638824ULL, 0x000fe200078e0206ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040302ff738cULL, 0x0003e20000000000ULL, 0x0000660063628625ULL, 0x000fe200078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000008620c8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0b00780cULL, 0x000fe20003f04070ULL, 0x00000080716a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff447819ULL, 0x000fe20000011600ULL, 0x0000000002ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000100737812ULL, 0x000fc600078ec0ffULL, 0x0000002044777824ULL, 0x000fca00078e00ffULL,
0x000000606a067812ULL, 0x000fe200078ef877ULL, 0x000059000c037a24ULL, 0x006fc800078e02ffULL,
0x0000008003197824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000007764027217ULL, 0x008fe20007800000ULL, 0x0000001073037824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fe40000011604ULL, 0x0000640019177a11ULL, 0x000fe200078838ffULL,
0x0000000102027824ULL, 0x000fe200078e0a77ULL, 0x00000004080b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fe200078e0208ULL, 0x0000000c080e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000302027217ULL, 0x000fe20007800000ULL, 0x00000001090a7824ULL, 0x000fe200078e0204ULL,
0x0000650019197a11ULL, 0x000fe200020f3cffULL, 0x00000008090d7824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a03ULL, 0x0000000103157824ULL, 0x000fe200078e020eULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20aULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x00000008080a7810ULL, 0x000fe40007ffe0ffULL, 0x000000020b00720cULL, 0x080fe20003f46070ULL,
0x00000001030b7824ULL, 0x040fe200078e020bULL, 0x000000020a00720cULL, 0x080fe20003f26070ULL,
0x00000001030f7824ULL, 0x000fe200078e020aULL, 0x000000020800720cULL, 0x080fe20003f66070ULL,
0x000000010b037824ULL, 0x040fe200078e0204ULL, 0x000000020e00720cULL, 0x000fe20003f06070ULL,
0x000000080b0a7824ULL, 0x000fc400078e00ffULL, 0x000000010f087824ULL, 0x040fe400078e0204ULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff80a117812ULL, 0x000fe200078ee203ULL,
0x0000008009027825ULL, 0x000fc600078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x0000000106087824ULL, 0x000fe200078e020bULL, 0x0000007002027812ULL, 0x000fe200078ef807ULL,
0x00000001060a7824ULL, 0x040fe400078e020fULL, 0x00000001060e7824ULL, 0x000fe200078e0215ULL,
0x0000000217027210ULL, 0x000fe20007f9e0ffULL, 0x0000000115067824ULL, 0x040fe400078e0204ULL,
0x0000000815157824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee206ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008067812ULL, 0x000fc600078ef807ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef807ULL, 0x0000000103037824ULL, 0x000fe200020e0619ULL,
0x000000700e077812ULL, 0x000fe400078ef807ULL, 0x0000b000440e7811ULL, 0x000fe400078e68ffULL,
0x0000001706067210ULL, 0x080fe40007f9e0ffULL, 0x0000001708087210ULL, 0x080fe20007fbe0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e020eULL, 0x00000017070a7210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x000fc400078e020eULL, 0x0000000109077824ULL, 0x100fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000d901c48ULL,
0x0000001013137824ULL, 0x100fe400078e020eULL, 0x000000010b097824ULL, 0x100fe200028e0619ULL,
0x0000000006117faeULL, 0x0003e2000d101c48ULL, 0x0000001015157824ULL, 0x000fe400078e020eULL,
0x000000010f0b7824ULL, 0x000fe200030e0619ULL, 0x0000000008137faeULL, 0x0003e8000c901c48ULL,
0x000000000a157faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001073037824ULL, 0x008fe200078e00ffULL, 0x0000640019117a11ULL, 0x000fc400078038ffULL,
0x0000b00044157811ULL, 0x000fe400078e68ffULL, 0x0000000304037211ULL, 0x000fe400078fe8ffULL,
0x0000650019197a11ULL, 0x000fe400000f3cffULL, 0x0000000403097810ULL, 0x040fe20007ffe0ffULL,
0x0000000103027824ULL, 0x140fe200078e0204ULL, 0x00000008030b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008030d7824ULL, 0x000fe400078e00ffULL, 0x0000000109087824ULL, 0x000fc400078e0204ULL,
0x00000008090f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee202ULL,
0x0000000106027824ULL, 0x000fe400078e0203ULL, 0x000000010b0a7824ULL, 0x000fe200078e0204ULL,
0xfffffff80f107812ULL, 0x000fe200078ee208ULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x0000000c030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008002027825ULL, 0x000fc600078e00ffULL,
0xfffffff813127812ULL, 0x000fe200078ee20aULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x0000007002027812ULL, 0x000fe200078ef807ULL, 0x00000001060b7824ULL, 0x040fe400078e020bULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x0000000211027210ULL, 0x000fe20007f1e0ffULL,
0x000000010f067824ULL, 0x040fe400078e0204ULL, 0x000000080f137824ULL, 0x000fe400078e00ffULL,
0x0000008009087825ULL, 0x000fc600078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee206ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008067812ULL, 0x000fc600078ef807ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x000fc600078ef807ULL,
0x0000000103037824ULL, 0x000fe200000e0619ULL, 0x000000700e077812ULL, 0x000fe200078ef807ULL,
0x000000100d0d7824ULL, 0x100fe200078e0215ULL, 0x0000000611067210ULL, 0x040fe20007f1e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0215ULL, 0x0000000811087210ULL, 0x040fe40007f3e0ffULL,
0x00000007110a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001010117824ULL, 0x000fe200078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c48ULL,
0x0000000109077824ULL, 0x000fc400000e0619ULL, 0x000000010b097824ULL, 0x000fe400008e0619ULL,
0x0000001014157824ULL, 0x000fe200078e0215ULL, 0x0000000006117faeULL, 0x0003e2000b901c48ULL,
0x000000010f0b7824ULL, 0x000fc600010e0619ULL, 0x0000000008137faeULL, 0x0003e8000b901c48ULL,
0x000000000a157faeULL, 0x0003e4000b901c48ULL, 0x0000001044727824ULL, 0x000fe200078e00ffULL,
0x000000ff6800720cULL, 0x000fe20003f05270ULL, 0x0000000844067824ULL, 0x002fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000720473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800720e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80006067f8cULL, 0x000ee2000c80043fULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00009e4000008947ULL, 0x000fea0003800000ULL,
0x00000002056c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff6d7819ULL, 0x000fe20000011600ULL,
0x00006a00ff057624ULL, 0x000fc400078e00ffULL, 0x000000ffff0e7224ULL, 0x004fe400078e000fULL,
0x000000ffff027224ULL, 0x008fe400078e0007ULL, 0x00006a006c6c7624ULL, 0x000fe400078e0205ULL,
0xff317217ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x0000000000107805ULL, 0x038fca0000015200ULL,
0x0000000400057824ULL, 0x000fca00078e00ffULL, 0xfffffff805057812ULL, 0x000fc800078ec0ffULL,
0x0000f6c8050a7810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc0005097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804802ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011413ULL,
0x0000001209097211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000209097819ULL, 0x000fc80000001212ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0005097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804802ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x000000010b057810ULL, 0x000fe20007ffe0ffULL, 0x000059000c0c7a24ULL, 0x000fc600078e02ffULL,
0xffffffe002107812ULL, 0x000fe200078ec0ffULL, 0x000000800c3b7824ULL, 0x000fe200078e00ffULL,
0x000000680500720cULL, 0x000fc60003f26070ULL, 0x000001000b107824ULL, 0x000fca00078e0210ULL,
0x0000004010097810ULL, 0x000fc80007ffe0ffULL, 0x0000006009057812ULL, 0x000fca00078ec0ffULL,
0x000000016a3a7824ULL, 0x000fe200078e0205ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001002057812ULL, 0x000fe400078ec0ffULL, 0x0000000964027217ULL, 0x000fe40007800000ULL,
0x00000003ff0d7819ULL, 0x000fc60000011604ULL, 0x0000000102027824ULL, 0x000fe200078e0a09ULL,
0x000000040d117810ULL, 0x040fe20007ffe0ffULL, 0x000000010d097824ULL, 0x000fc600078e0205ULL,
0x0000000502027217ULL, 0x000fe20007800000ULL, 0x00000001090c7824ULL, 0x040fe400078e0204ULL,
0x0000000809137824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a05ULL,
0xfffffff813267812ULL, 0x000fe200078ee20cULL, 0x000000013a0c7824ULL, 0x000fe200078e0209ULL,
0x000000080d137810ULL, 0x040fe40007ffe0ffULL, 0x000000020d00720cULL, 0x0c0fe40003f86070ULL,
0x0000000c0d0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000021100720cULL, 0x0c0fe20003f66070ULL,
0x0000000111117824ULL, 0x100fe200078e0205ULL, 0x000000020d00720cULL, 0x0c0fe20003f06070ULL,
0x000000010d277824ULL, 0x000fe200078e0205ULL, 0x000000021300720cULL, 0x000fe20003f46070ULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x000064003b097a11ULL, 0x000fe200078a38ffULL,
0x0000000111027824ULL, 0x000fc400078e0204ULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0x000000700d397812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000065003b3b7a11ULL, 0x000fe400028f3cffULL, 0xfffffff825027812ULL, 0x000fe200078ee202ULL,
0x000000013a247824ULL, 0x000fe200078e0211ULL, 0x000000390c0c7212ULL, 0x000fe200078efcffULL,
0x0000000113137824ULL, 0x000fe400078e0205ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000000c090c7210ULL, 0x000fc60007fbe0ffULL, 0x0000000113057824ULL, 0x040fe200078e0204ULL,
0x0000003924247212ULL, 0x000fe200078efcffULL, 0x0000000813387824ULL, 0x000fe400078e00ffULL,
0x000000013a107824ULL, 0x040fe400078e0213ULL, 0x000000013a127824ULL, 0x000fe200078e0227ULL,
0xfffffff838387812ULL, 0x000fe200078ee205ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000127057824ULL, 0x040fe200078e0204ULL, 0x0000003910107212ULL, 0x000fe200078efcffULL,
0x00000008273a7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL, 0x000000010d0d7824ULL, 0x100fe200028e063bULL,
0x0000000924247210ULL, 0x000fe40007fbe0ffULL, 0x0000003912127212ULL, 0x000fe400078efcffULL,
0x0000c00044057811ULL, 0x000fe200078e68ffULL, 0x0000000125257824ULL, 0x000fe200028e063bULL,
0x0000000910107210ULL, 0x080fe40007fbe0ffULL, 0x0000000912127210ULL, 0x000fe20007fde0ffULL,
0x0000001026097824ULL, 0x000fc400078e0205ULL, 0x0000001002277824ULL, 0x100fe400078e0205ULL,
0x0000001038397824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0005e2000e101c48ULL, 0x0000000111117824ULL, 0x000fe400028e063bULL,
0x000000103a057824ULL, 0x000fe200078e0205ULL, 0x0000000024277faeULL, 0x0005e2000d901c48ULL,
0x0000000113137824ULL, 0x000fc600030e063bULL, 0x0000000010397faeULL, 0x0005e8000d101c48ULL,
0x0000000012057faeULL, 0x0005e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001002057812ULL, 0x000fe200078ec0ffULL, 0x0000001004107824ULL, 0x040fe200078e00ffULL,
0x000064003b3d7a11ULL, 0x000fe400078038ffULL, 0x0000000504057211ULL, 0x000fe400078fe8ffULL,
0x0000007010397812ULL, 0x000fc400078ec0ffULL, 0x0000000405097810ULL, 0x040fe20007ffe0ffULL,
0x0000000105027824ULL, 0x140fe200078e0204ULL, 0x0000000805117810ULL, 0x040fe20007ffe0ffULL,
0x00000008050d7824ULL, 0x000fe200078e00ffULL, 0x000065003b3b7a11ULL, 0x000fe200000f3cffULL,
0x00000001090c7824ULL, 0x040fe400078e0204ULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xfffffff80d027812ULL, 0x000fe200078ee202ULL, 0x00000001110d7824ULL, 0x040fe400078e0204ULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0xfffffff813267812ULL, 0x000fe200078ee20cULL,
0x000000013a0c7824ULL, 0x040fe200078e0205ULL, 0x0000000c05057810ULL, 0x000fe20007ffe0ffULL,
0x000000013a107824ULL, 0x000fe200078e0209ULL, 0xfffffff812277812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000013a127824ULL, 0x000fe200078e0211ULL,
0x000000390c0c7212ULL, 0x000fe200078efcffULL, 0x000000013a247824ULL, 0x000fe400078e0205ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000c3d0c7210ULL, 0x000fc60007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003910107212ULL, 0x000fc600078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000003912127212ULL, 0x000fc600078efcffULL,
0x0000000105097824ULL, 0x040fe200078e0204ULL, 0x0000003924247212ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000c00044397811ULL, 0x000fe200078e68ffULL,
0x000000010d0d7824ULL, 0x000fe200000e063bULL, 0x000000103d107210ULL, 0x040fe40007f1e0ffULL,
0x000000123d127210ULL, 0x040fe20007f5e0ffULL, 0x0000001002057824ULL, 0x000fe200078e0239ULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x0000001026097824ULL, 0x000fe200078e0239ULL,
0x000000243d247210ULL, 0x000fe20007f7e0ffULL, 0x0000000111117824ULL, 0x000fe200000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0005e2000b901c48ULL,
0x0000001027277824ULL, 0x000fc400078e0239ULL, 0x0000000113137824ULL, 0x000fe200010e063bULL,
0x0000000010097faeULL, 0x0005e2000b901c48ULL, 0x0000001038397824ULL, 0x000fe400078e0239ULL,
0x0000000125257824ULL, 0x000fe200018e063bULL, 0x0000000012277faeULL, 0x0005e8000b901c48ULL,
0x0000000024397faeULL, 0x0005e4000b901c48ULL, 0x00000008000c7824ULL, 0x004fe200078e00ffULL,
0x0000000155107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff057424ULL, 0x000fc400078e00ffULL,
0x000000000c0573c2ULL, 0x000ea200000e0000ULL, 0x0000006b1000720cULL, 0x000fe40003f06070ULL,
0x000000100c027812ULL, 0x040fe400078ec0ffULL, 0xffffffe00c097812ULL, 0x040fe400078ec0ffULL,
0x000000080c0d7812ULL, 0x000fce00078ec0ffULL, 0x000000016c108824ULL, 0x000fe400078e0210ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x004fc6000f8ec03fULL,
0x0000660010108625ULL, 0x000fe200078e0011ULL, 0x0000f6b005067890ULL, 0x000fe2000fffe03fULL,
0x000000090d097210ULL, 0x000fc60007ffe002ULL, 0x0000000810058981ULL, 0x000528000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b000ff127f8cULL, 0x000ee2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080009267f8cULL, 0x0002a4000c80043fULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x00f60c00090d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fc40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024100d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125247824ULL, 0x000fe200000e0e11ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011424ULL,
0x0000000d02027211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e0624ULL,
0x0000000202027819ULL, 0x000fc8000000120dULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c00090d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001004567824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe20000011604ULL,
0x0000002000027824ULL, 0x000fe400078e00ffULL, 0xffffffffff787424ULL, 0x000fe200078e00ffULL,
0x0000007056567812ULL, 0x000fc400078ec0ffULL, 0xffffff80020d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c70707812ULL, 0x000fc800078ec0ffULL, 0x0000000d700d7210ULL, 0x000fca0007ffe056ULL,
0x00f000000d247984ULL, 0x000ea80000000800ULL, 0x00f200000d257984ULL, 0x0002e20000000800ULL,
0x0000000f2400720bULL, 0x004fe20003f1d000ULL, 0x000100427f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x002fc800000e0100ULL, 0x0000ffff0d277812ULL, 0x000fe2000780c0ffULL,
0x000004c000007945ULL, 0x000fe20003800000ULL, 0x00000001ff267424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fc400078e000fULL, 0x0000001fff7a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff797424ULL, 0x000fca00078e00ffULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000006d00720cULL, 0x000fe40003f05270ULL, 0x0000000f2400720bULL, 0x000fe20003f54000ULL,
0x0000ffd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x000fc400010e0100ULL,
0x0000008000118824ULL, 0x000fe200078e0256ULL, 0x0000000f240d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000170108824ULL, 0x000fe200078e0211ULL,
0x0000991002117816ULL, 0x000fc800000000ffULL, 0x00f4000d10008388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f24107209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff02ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f100d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00267308ULL, 0x000e640000000800ULL,
0x0000002603037220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011604ULL, 0x0000fef27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d260d7589ULL, 0x0002a400000e0000ULL, 0x0000000d30307220ULL, 0x084fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d34347220ULL, 0x080fe20000410000ULL,
0x0000000d35357220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0002ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040d7811ULL, 0x000fe200078ff0ffULL, 0x0000fdd27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d260d7589ULL, 0x00046400000e0000ULL, 0x0000000d32327220ULL, 0x086fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d36367220ULL, 0x080fe20000410000ULL,
0x0000000d37377220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff27ff7812ULL, 0x000fe20007806002ULL, 0x00000001ff267424ULL, 0x000fe200078e00ffULL,
0x0000000f24027209ULL, 0x000fd60007810000ULL, 0x8000000224240221ULL, 0x000fe20000010000ULL,
0x00007610ff260816ULL, 0x000fc60000000026ULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x0000002400080308ULL, 0x000e640000000800ULL, 0x0000000825250220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000325037221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0xfffffff00c247812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00240d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c100f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e11ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00240d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910260c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011604ULL,
0x00005410060c7816ULL, 0x000fe20000000006ULL, 0x0000f9927f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0c077589ULL, 0x0002a400000e0000ULL, 0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000f9c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000309000117802ULL, 0x000fc40000000f00ULL,
0x0001039000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x000030e000117802ULL, 0x000fc40000000f00ULL, 0x0001034000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200607824ULL, 0x000fe200078e00ffULL,
0x00000007040d7812ULL, 0x00cfe200078ec0ffULL, 0x0000020000457824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000804487812ULL, 0x000fc400078ec0ffULL,
0x00000004600f7812ULL, 0x002fe400078ec0ffULL, 0x000000080d597812ULL, 0x000fe400078ef804ULL,
0x0000000f040c7211ULL, 0x000fe400078fe0ffULL, 0xfffff80045457812ULL, 0x000fe200078ec0ffULL,
0x00000008594e7824ULL, 0x040fe400078e00ffULL, 0x0000000159577824ULL, 0x000fca00078e020cULL,
0xfffffff84e4e7812ULL, 0x000fca00078ee257ULL, 0x000000104e4e7824ULL, 0x000fc400078e0245ULL,
0x00000004000f7824ULL, 0x000fe200078e00ffULL, 0x00000004ff667819ULL, 0x000fe40000011604ULL,
0x0000000d480c7212ULL, 0x000fe400078efcffULL, 0x000000040f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000b00044697811ULL, 0x000fe200078e68ffULL, 0x000000080c477824ULL, 0x000fe200078e00ffULL,
0x0000001048487812ULL, 0x000fe200078efe0dULL, 0x00000001660f7824ULL, 0x000fe200078e020fULL,
0xfffffff860607812ULL, 0x000fe200078ec0ffULL, 0x000000080c0d7824ULL, 0x000fc400078e00ffULL,
0x000000010c0e7824ULL, 0x000fe400078e020fULL, 0x00000008484d7824ULL, 0x040fe400078e00ffULL,
0x000000010f4c7824ULL, 0x000fe200078e0248ULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x00000008485d7824ULL, 0x000fe200078e00ffULL, 0x000000020e467810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL, 0x0000001047247824ULL, 0x000fe200078e0269ULL,
0xfffffff80d467812ULL, 0x000fc400078ee246ULL, 0x000000024c4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000104d3c7824ULL, 0x100fe400078e0269ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x00000010460c7824ULL, 0x000fe200078e0269ULL, 0xfffffff85d4c7812ULL, 0x000fe400078ee24cULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x00000100240d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011424ULL, 0x0001000024397824ULL, 0x040fe200078e00ffULL,
0x00008880244f7816ULL, 0x000fe200000000ffULL, 0x00000100253a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc4000001140dULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x000000000c0c783bULL, 0x000e620000004200ULL, 0x0000003800247306ULL, 0x0007e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff497819ULL, 0x000fe40000011425ULL,
0x0000888025537816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x004fe2000001143cULL, 0x00000039004b7306ULL, 0x0005e20000200c00ULL,
0x0000010026387824ULL, 0x008fe200078e00ffULL, 0x000088803c427816ULL, 0x000fc400000000ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003a00587306ULL, 0x000fe20000200c00ULL, 0x0000010027397824ULL, 0x004fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011426ULL, 0x00000018ff517819ULL, 0x000fe40000011427ULL,
0x00000018ff637819ULL, 0x000fc40000011439ULL, 0x0000003800657306ULL, 0x0005e20000200c00ULL,
0x00008880265c7816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888027627816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe4000001143dULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x009000004e38783bULL, 0x004ea20000000200ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x000088803d487816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fe4000001143eULL, 0x00000025006e7306ULL, 0x0007e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe4000001143fULL, 0x00000018ff5b7819ULL, 0x002fe4000001140cULL,
0x00000018ff5a7819ULL, 0x000fe4000001140dULL, 0x00000018ff527819ULL, 0x000fe2000001140eULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x000001003c257824ULL, 0x048fe200078e00ffULL,
0x000054104f247816ULL, 0x000fe20000000024ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc4000001140fULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000004900497306ULL, 0x000ee20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000002500437306ULL, 0x0003f00000200c00ULL, 0x0000004a004a7306ULL, 0x000ee20000200c00ULL,
0x000001003d257824ULL, 0x042fe200078e00ffULL, 0x0000000738388232ULL, 0x084fe20000000000ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000000073a3a8232ULL, 0x000fc40000000000ULL,
0x00000018ff4f7819ULL, 0x000fe20000011425ULL, 0x0000000639398232ULL, 0x080fe20000000000ULL,
0x0000541053257816ULL, 0x000fe20000000058ULL, 0x000000063b3b8232ULL, 0x000fe20000000000ULL,
0x0000003c005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fca000001143dULL,
0x000000243830723cULL, 0x000be40000001830ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000088803e3c7816ULL, 0x002fc800000000ffULL, 0x000054106e257816ULL, 0x028fe20000000049ULL,
0x000000ffff497224ULL, 0x000fe200078e003cULL, 0x000054104b247816ULL, 0x000fe2000000004aULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000001003e3c7824ULL, 0x040fe200078e00ffULL,
0x000088803f4a7816ULL, 0x000fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000024382c723cULL, 0x000b62000000182cULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000006200627306ULL, 0x000ff00000200c00ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000002600617306ULL, 0x0002b00000200c00ULL, 0x00000027005f7306ULL, 0x0006e20000200c00ULL,
0x000000104c267824ULL, 0x002fce00078e0269ULL, 0x0000003d00587306ULL, 0x0003e20000200c00ULL,
0x0000541061507816ULL, 0x004fe20000000050ULL, 0x000001000c617824ULL, 0x000fe200078e00ffULL,
0x000000002624783bULL, 0x028ea80000004200ULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000003e005d7306ULL, 0x0007e20000200c00ULL, 0x000001003f3d7824ULL, 0x002fe200078e00ffULL,
0x000054105f517816ULL, 0x000fe20000000051ULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe4000001143dULL, 0x00000018ff677819ULL, 0x000fe2000001143fULL,
0x000000503834723cULL, 0x000b620000001834ULL, 0x000054105c3e7816ULL, 0x008fe20000000065ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00005410623f7816ULL, 0x000fc80000000063ULL,
0x000001000d507824ULL, 0x060fe200078e00ffULL, 0x000088800d517816ULL, 0x040fe200000000ffULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000003e3828723cULL, 0x000b620000001828ULL,
0x0000006100627306ULL, 0x000fe20000200c00ULL, 0x00000018ff637819ULL, 0x000fca0000011450ULL,
0x000088800c3e7816ULL, 0x060fe200000000ffULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x0000005100517306ULL, 0x000fe80000200c00ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff3d7819ULL, 0x004fe40000011424ULL, 0x0000003e005f7306ULL, 0x0002a20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fce0000011425ULL, 0x00000063006e7306ULL, 0x0006a20000200c00ULL,
0x00000018ff3e7819ULL, 0x002fce0000011427ULL, 0x0000000c00507306ULL, 0x0005e20000200c00ULL,
0x000088800e637816ULL, 0x008fce00000000ffULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000054105f0c7816ULL, 0x004fe20000000062ULL, 0x0000000444627824ULL, 0x000fe200078e0266ULL,
0x00000018ff5f7819ULL, 0x000fe4000001140dULL, 0x00005410510d7816ULL, 0x000fe4000000006eULL,
0x0000000262627810ULL, 0x000fe20007ffe059ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000088800f517816ULL, 0x000fc400000000ffULL,
0x0000000c3820723cULL, 0x000be20000001820ULL, 0xfffffff8597c7812ULL, 0x000fe400078ee262ULL,
0x0000888024597816ULL, 0x000fe400000000ffULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000000107c457824ULL, 0x000fe400078e0245ULL, 0x000001000e0d7824ULL, 0x020fe400078e00ffULL,
0x000001000f0c7824ULL, 0x000fc400078e00ffULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff627819ULL, 0x000fca000001140fULL,
0x0000000d006e7306ULL, 0x0002b00000200c00ULL, 0x0000000c00667306ULL, 0x0006a20000200c00ULL,
0x000054105f0d7816ULL, 0x002fe2000000005aULL, 0x00000100245a7824ULL, 0x000fc400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000000e00617306ULL, 0x0003e20000200c00ULL, 0x00005410500c7816ULL, 0x008fe4000000005bULL,
0x0000541063507816ULL, 0x004fe4000000006eULL, 0x00008880255b7816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000000c381c723cULL, 0x000b62000000181cULL,
0x0000541051517816ULL, 0x000fe20000000066ULL, 0x00900000450c783bULL, 0x022e620000000200ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0000888026637816ULL, 0x000fc800000000ffULL,
0x000000503818723cULL, 0x000b660000001818ULL, 0x0000005400547306ULL, 0x000fe80000200c00ULL,
0x0000010025507824ULL, 0x060fe400078e00ffULL, 0x0001000025257824ULL, 0x000fe400078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fc40000011450ULL,
0x00000018ff257819ULL, 0x000fca0000011425ULL, 0x0000004200427306ULL, 0x000eb00000200c00ULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x000000070c0c8232ULL, 0x002fce0000000000ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x0000541042427816ULL, 0x004fe20000000043ULL,
0x000000070e0e8232ULL, 0x000fe40000000000ULL, 0x000000060d0d8232ULL, 0x080fe40000000000ULL,
0x000000060f0f8232ULL, 0x000fe40000000000ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054105e407816ULL, 0x008fce0000000040ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x0000541058417816ULL, 0x002fce0000000041ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x000000400c2c723cULL, 0x000fee000000182cULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0000541048437816ULL, 0x004fce000000004fULL, 0x00000067005c7306ULL, 0x000ea20000200c00ULL,
0x000054105d107816ULL, 0x002fe20000000010ULL, 0x000000420c30723cULL, 0x000fec0000001830ULL,
0x0000002400507306ULL, 0x0003f00000200c00ULL, 0x0000002500517306ULL, 0x0007e20000200c00ULL,
0x0000541061247816ULL, 0x002fe20000000052ULL, 0x000000ffff527224ULL, 0x000fe200078e0063ULL,
0x000054105c117816ULL, 0x004fca0000000011ULL, 0x0000003c004b7306ULL, 0x0003e20000200c00ULL,
0x0000541062257816ULL, 0x008fce0000000054ULL, 0x000000243814723cULL, 0x000b620000001814ULL,
0x00000018ff3c7819ULL, 0x002fe20000011426ULL, 0x0000003d003d7306ULL, 0x000e6a0000200c00ULL,
0x0000010026397824ULL, 0x060fe200078e00ffULL, 0x00008880273a7816ULL, 0x040fe200000000ffULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x0000005200387306ULL, 0x000fe20000200c00ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fc40000011424ULL,
0x00000018ff407819ULL, 0x000fe40000011426ULL, 0x00000018ff427819ULL, 0x000fe20000011427ULL,
0x0000003900397306ULL, 0x000ea20000200c00ULL, 0x000000100c24723cULL, 0x000b620000001834ULL,
0x0000541050507816ULL, 0x002fcc000000003dULL, 0x0000004900497306ULL, 0x000e700000200c00ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541038387816ULL, 0x004fce0000000039ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541049527816ULL, 0x002fce000000004bULL,
0x0000003f003f7306ULL, 0x000e700000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054104a537816ULL, 0x004fce0000000053ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541051517816ULL, 0x002fe2000000003fULL, 0x000000520c28723cULL, 0x040f6c0000001828ULL,
0x0000005900597306ULL, 0x000fe40000200c00ULL, 0x000000500c1c723cULL, 0x000f6c000000181cULL,
0x0000005a005a7306ULL, 0x000e700000200c00ULL, 0x0000005b005b7306ULL, 0x000ff00000200c00ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x00005410595a7816ULL, 0x002fce000000005aULL,
0x0000003a003a7306ULL, 0x000ff00000200c00ULL, 0x0000003b003b7306ULL, 0x000e620000200c00ULL,
0x000054105b5b7816ULL, 0x004fce000000005fULL, 0x0000004000417306ULL, 0x000ea20000200c00ULL,
0x0000005a0c20723cULL, 0x000f6e0000001820ULL, 0x0000004200117306ULL, 0x020ee20000200c00ULL,
0x000054103a397816ULL, 0x002fe4000000003bULL, 0x00005410413c7816ULL, 0x004fca000000003cULL,
0x000000380c18723cULL, 0x000f620000001818ULL, 0x00005410113d7816ULL, 0x008fce000000003eULL,
0x0000003c0c14723cULL, 0x000b6e0000001814ULL, 0x0000f6c8440c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000c0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6880060ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff347224ULL, 0x000fc600078e00ffULL, 0x00000000000e7805ULL, 0x000fc80000015200ULL,
0x000004000a117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00afc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e357210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000003510107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fca00078e00ffULL,
0xffffffe00e0c7812ULL, 0x000fca00078ec0ffULL, 0x000001000b0c7824ULL, 0x000fca00078e020cULL,
0x000000800c0d7810ULL, 0x000fe20007ffe0ffULL, 0x00005900050c7a24ULL, 0x010fc600078e02ffULL,
0x000000600d057812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7824ULL, 0x000fc800078e00ffULL,
0x000000016a117824ULL, 0x000fe200078e0205ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x000000100e107812ULL, 0x000fe400078ec0ffULL, 0x0000000d64057217ULL, 0x000fe40007800000ULL,
0x00000003ff0e7819ULL, 0x000fc60000011604ULL, 0x0000000105057824ULL, 0x000fe200078e0a0dULL,
0x000000040e347810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0d7824ULL, 0x040fe200078e0210ULL,
0x0000000c0e357810ULL, 0x000fe40007ffe0ffULL, 0x0000000510057217ULL, 0x000fe20007800000ULL,
0x000000010d0f7824ULL, 0x040fe400078e0204ULL, 0x000000080d387824ULL, 0x000fe400078e00ffULL,
0x0000000105057824ULL, 0x000fc400078e0a10ULL, 0x0000000135397824ULL, 0x000fe200078e0210ULL,
0xfffffff838387812ULL, 0x000fe400078ee20fULL, 0x000000080e0f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001393b7824ULL, 0x000fe200078e0204ULL, 0x000000050e00720cULL, 0x080fe20003f86070ULL,
0x000000010d0e7824ULL, 0x000fe200078e0211ULL, 0x000000053400720cULL, 0x0c0fe20003f66070ULL,
0x000000010f367824ULL, 0x140fe200078e0210ULL, 0x000000050f00720cULL, 0x080fe20003f46070ULL,
0x0000000134347824ULL, 0x000fe200078e0210ULL, 0x000000053500720cULL, 0x000fe20003f06070ULL,
0x0000000136057824ULL, 0x000fc400078e0204ULL, 0x00000008363c7824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x00000001340d7824ULL, 0x000fe200078e0204ULL, 0x000064000c057a11ULL, 0x000fe200078a38ffULL,
0x00000008343a7824ULL, 0x000fe200078e00ffULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x0000000134347824ULL, 0x100fe400078e0211ULL, 0x0000000136367824ULL, 0x000fe200078e0211ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20dULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000065000c0d7a11ULL, 0x000fc400028f3cffULL, 0x0000000e050e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000139107824ULL, 0x000fe200078e0211ULL, 0x0000005634347212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000005636367212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x000fe200028e060dULL,
0x0000000534347210ULL, 0x080fe20007fbe0ffULL, 0x00000008393e7824ULL, 0x000fe200078e00ffULL,
0x0000005610107212ULL, 0x000fe200078efcffULL, 0x000000103c397824ULL, 0x000fe400078e0269ULL,
0x0000000135357824ULL, 0x000fe200028e060dULL, 0x0000000536367210ULL, 0x080fe40007fbe0ffULL,
0x0000000510107210ULL, 0x000fe20007fde0ffULL, 0x0000001038057824ULL, 0x000fe200078e0269ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL, 0x0000000137377824ULL, 0x000fc400028e060dULL,
0x0000000111117824ULL, 0x000fe200030e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e057faeULL, 0x0003e2000e101c48ULL, 0x000000103a0d7824ULL, 0x100fe400078e0269ULL,
0x000000103e3b7824ULL, 0x000fc600078e0269ULL, 0x00000000340d7faeULL, 0x0003e8000d901c48ULL,
0x0000000036397faeULL, 0x0003e8000d101c48ULL, 0x00000000103b7faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x000000100e057812ULL, 0x000fc800078ec0ffULL,
0x0000000504057211ULL, 0x000fc800078fe8ffULL, 0x00000004050e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001050d7824ULL, 0x140fe200078e0204ULL, 0x0000000c05357810ULL, 0x040fe20007ffe0ffULL,
0x0000000805387824ULL, 0x040fe400078e00ffULL, 0x0000000105107824ULL, 0x140fe400078e0211ULL,
0x000000010e347824ULL, 0x000fe200078e0211ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x000000080e3a7824ULL, 0x040fe200078e00ffULL, 0x00000008050d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e057824ULL, 0x000fc400078e0204ULL, 0x00000001350e7824ULL, 0x100fe400078e0211ULL,
0x000000010d367824ULL, 0x040fe200078e0211ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x000000010d0f7824ULL, 0x040fe200078e0204ULL, 0x000064000c057a11ULL, 0x000fe200078038ffULL,
0x000000080d3c7824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x00000001350d7824ULL, 0x040fe200078e0204ULL,
0x0000005610107212ULL, 0x000fe200078efcffULL, 0x00000008353e7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000065000c0d7a11ULL, 0x000fe400000f3cffULL,
0x0000001005107210ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000005634347212ULL, 0x080fe400078efcffULL, 0x0000005636367212ULL, 0x080fe200078efcffULL,
0x0000000111117824ULL, 0x000fe200000e060dULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x000000103c397824ULL, 0x100fe200078e0269ULL, 0x0000003405347210ULL, 0x040fe20007f5e0ffULL,
0x000000103e3b7824ULL, 0x000fe200078e0269ULL, 0x0000003605367210ULL, 0x000fc40007f1e0ffULL,
0x0000000e050e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000135357824ULL, 0x000fe400010e060dULL,
0x0000001038057824ULL, 0x000fe400078e0269ULL, 0x0000000137377824ULL, 0x100fe400000e060dULL,
0x000000010f0f7824ULL, 0x000fe200018e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010057faeULL, 0x0003e2000b901c48ULL, 0x000000103a0d7824ULL, 0x000fca00078e0269ULL,
0x00000000340d7faeULL, 0x0003e8000b901c48ULL, 0x0000000036397faeULL, 0x0003e8000b901c48ULL,
0x000000000e3b7faeULL, 0x0003e4000b901c48ULL, 0x0000000800057824ULL, 0x002fca00078e00ffULL,
0xfffffff005057812ULL, 0x000fc800078ec0ffULL, 0x00000000050573c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a805057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800050e7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280009107f8cULL, 0x0002a4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0x00f62c0009057984ULL, 0x002e640000000800ULL,
0x8000000005ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011437ULL, 0x0000003605057211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000205057819ULL, 0x000fc80000001236ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c0009057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000057824ULL, 0x000fca00078e00ffULL,
0xffffff8005057812ULL, 0x000fc800078ec0ffULL, 0x0000008056057810ULL, 0x000fca0007ffe005ULL,
0x0000000170057824ULL, 0x000fca00078e0205ULL, 0x00f0000005357984ULL, 0x000e680000000800ULL,
0x00f2000005347984ULL, 0x0004e20000000800ULL, 0x000000023500720bULL, 0x002fe20003f1d000ULL,
0x0000da327f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d367812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fd200078e0002ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000016d057810ULL, 0x000fe40007ffe0ffULL,
0x000000023500720bULL, 0x000fe40003f54000ULL, 0x000000000500720cULL, 0x000fe20003f05270ULL,
0x0000d9d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000057806ULL, 0x000fc400010e0100ULL,
0x0000008000118824ULL, 0x000fe200078e0256ULL, 0x00000002350d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991005107816ULL, 0x000fe200000000ffULL,
0x0000000170388824ULL, 0x000fca00078e0211ULL, 0x00f4000d38008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000002350d7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff05ff7812ULL, 0x000fc6000780c0ffULL, 0x000000020d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00387308ULL, 0x000e640000000800ULL,
0x0000003803037220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011604ULL, 0x0000d8f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d380d7589ULL, 0x0002a400000e0000ULL, 0x0000000d30307220ULL, 0x084fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0005ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040d7811ULL, 0x000fe200078ff0ffULL, 0x0000d7d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d380d7589ULL, 0x00046400000e0000ULL, 0x0000000d32327220ULL, 0x086fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff36ff7812ULL, 0x000fe20007806005ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000235057209ULL, 0x000fd60007810000ULL, 0x8000000535350221ULL, 0x000fe20000010000ULL,
0x00007610ff0d0816ULL, 0x000fc6000000000dULL, 0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL,
0x0000003500080308ULL, 0x000e640000000800ULL, 0x0000000834340220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000334037221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000800027824ULL, 0x000fca00078e00ffULL,
0xfffffff002367812ULL, 0x000fca00078ec0ffULL, 0x00f6b40036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003410377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e11ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011435ULL, 0x0000003702027211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000202027819ULL, 0x000fc80000001235ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b40036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100d027816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000008ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe40000011604ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x0000d3827f007947ULL, 0x000fea000b800000ULL, 0x00001f1302077589ULL, 0x0002a400000e0000ULL,
0x00000008130d7810ULL, 0x000fe20007ffe0ffULL, 0x0000d3b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d02067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010130d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0002ULL,
0x0000586000117802ULL, 0x000fc40000000f00ULL, 0x0000dbc000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018130d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0002ULL, 0x000058b000117802ULL, 0x000fc40000000f00ULL,
0x0000db7000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100069027810ULL, 0x00afe20007ffe0ffULL,
0x009800004e3c783bULL, 0x000e680000000200ULL, 0x0000001047407824ULL, 0x000fc400078e0202ULL,
0x0000001046107824ULL, 0x100fe400078e0202ULL, 0x000000104d387824ULL, 0x100fe400078e0202ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x000000104c347824ULL, 0x000fc600078e0202ULL,
0x000000001010783bULL, 0x000f280000004200ULL, 0x000000003838783bULL, 0x000ea80000004200ULL,
0x000000003434783bULL, 0x000ea40000004200ULL, 0x000000073c3c8232ULL, 0x006fc40000000000ULL,
0x000000073e3e8232ULL, 0x000fe40000000000ULL, 0x000000063d3d8232ULL, 0x080fe40000000000ULL,
0x000000063f3f8232ULL, 0x000fe20000000000ULL, 0x00000100405b7824ULL, 0x048fe200078e00ffULL,
0x00008880405a7816ULL, 0x000fe200000000ffULL, 0x0000010041607824ULL, 0x040fe200078e00ffULL,
0x00008880415e7816ULL, 0x040fe200000000ffULL, 0x0001000041617824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000010010657824ULL, 0x010fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff597819ULL, 0x000fc40000011441ULL, 0x00000018ff5f7819ULL, 0x000fe20000011440ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000888042637816ULL, 0x000fe200000000ffULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff5d7819ULL, 0x000fe40000011442ULL,
0x00000018ff587819ULL, 0x000fc40000011410ULL, 0x00000018ff547819ULL, 0x000fe20000011411ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000888011677816ULL, 0x000fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011443ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff517819ULL, 0x000fe20000011439ULL, 0x0000006000417306ULL, 0x000ea20000200c00ULL,
0x00000018ff527819ULL, 0x000fc40000011412ULL, 0x00000018ff537819ULL, 0x000fe40000011413ULL,
0x00000018ff507819ULL, 0x000fe40000011438ULL, 0x00000018ff0d7819ULL, 0x000fe2000001143aULL,
0x0000004000667306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x000fe4000001143bULL,
0x00000018ff4a7819ULL, 0x000fe40000011434ULL, 0x00000018ff497819ULL, 0x000fc40000011435ULL,
0x00000018ff4f7819ULL, 0x000fe20000011436ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000054105a407816ULL, 0x002fe2000000005bULL, 0x00000100425b7824ULL, 0x000fe200078e00ffULL,
0x000054105e417816ULL, 0x004fe20000000041ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00008880435e7816ULL, 0x000fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x000000403c30723cULL, 0x000be20000001830ULL, 0x00000018ff4b7819ULL, 0x000fca0000011437ULL,
0x0000006100627306ULL, 0x000e620000200c00ULL, 0x0000010043407824ULL, 0x060fe200078e00ffULL,
0x0000888010417816ULL, 0x040fe200000000ffULL, 0x0001000010107824ULL, 0x000fe400078e00ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000063005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff437819ULL, 0x000fca0000011443ULL, 0x0000004000617306ULL, 0x0007f00000200c00ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x0000541066407816ULL, 0x008fce000000005fULL,
0x00000041005f7306ULL, 0x0003f00000200c00ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x0000541062417816ULL, 0x002fce0000000059ULL, 0x000000403c2c723cULL, 0x000be2000000182cULL,
0x0000004200637306ULL, 0x000fec0000200c00ULL, 0x0000010011407824ULL, 0x060fe200078e00ffULL,
0x0000888012417816ULL, 0x000fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000001000427306ULL, 0x0005e40000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff117819ULL, 0x000fc80000011411ULL, 0x0000001100597306ULL, 0x0007e20000200c00ULL,
0x000054105a107816ULL, 0x004fce000000005bULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054105e117816ULL, 0x008fe40000000061ULL, 0x0000888013617816ULL, 0x000fca00000000ffULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000000103c28723cULL, 0x000b6e0000001828ULL,
0x0000004300607306ULL, 0x0002a20000200c00ULL, 0x0000010013107824ULL, 0x020fe400078e00ffULL,
0x0000010038117824ULL, 0x000fc400078e00ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000041005a7306ULL, 0x0007e20000200c00ULL,
0x0000010012437824ULL, 0x042fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000001000627306ULL, 0x0003e20000200c00ULL, 0x00000018ff417819ULL, 0x008fe40000011411ULL,
0x0000541060117816ULL, 0x004fe4000000005cULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x000088803b5c7816ULL, 0x000fe200000000ffULL, 0x0000006500667306ULL, 0x0005e20000200c00ULL,
0x0000541063107816ULL, 0x002fc4000000005dULL, 0x00008880395d7816ULL, 0x000fca00000000ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000000103c24723cULL, 0x000bee0000001824ULL,
0x00000040006e7306ULL, 0x0002e20000200c00ULL, 0x0000010039107824ULL, 0x060fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc400078e00ffULL, 0x000001003a117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff657819ULL, 0x004fe20000011439ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011411ULL,
0x0000888038407816ULL, 0x042fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x0000541067117816ULL, 0x008fc6000000006eULL, 0x0000001000607306ULL, 0x0003e20000200c00ULL,
0x00000018ff637819ULL, 0x000fe40000011438ULL, 0x000088803a387816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541042587816ULL, 0x004fc60000000058ULL,
0x00000012005e7306ULL, 0x000fe20000200c00ULL, 0x000054105f107816ULL, 0x002fe40000000066ULL,
0x00000018ff3a7819ULL, 0x000fca000001143aULL, 0x000000103c20723cULL, 0x000b620000001820ULL,
0x00000013005b7306ULL, 0x000fec0000200c00ULL, 0x000001003b107824ULL, 0x060fe200078e00ffULL,
0x0000888034117816ULL, 0x000fe200000000ffULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000100003b3b7824ULL, 0x000fc400078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000000ffff427224ULL, 0x000fe400078e0011ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000010005f7306ULL, 0x0005f00000200c00ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x009800004510783bULL, 0x004ea20000000200ULL, 0x0000541059597816ULL, 0x002fe20000000054ULL,
0x0000010034547824ULL, 0x000fc400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000000583c1c723cULL, 0x000f62000000181cULL,
0x00000018ff347819ULL, 0x000fcc0000011434ULL, 0x0000005200527306ULL, 0x000e700000200c00ULL,
0x0000005300537306ULL, 0x000ef00000200c00ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x000054105e527816ULL, 0x002fce0000000052ULL, 0x0000003900397306ULL, 0x000e620000200c00ULL,
0x000054105b537816ULL, 0x008fe20000000053ULL, 0x0000000710108232ULL, 0x084fe40000000000ULL,
0x0000000712128232ULL, 0x000fe40000000000ULL, 0x0000000611118232ULL, 0x080fe40000000000ULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x000000523c14723cULL, 0x000fe20000001814ULL,
0x0000000613138232ULL, 0x000fcc0000000000ULL, 0x0000003a00677306ULL, 0x0007e20000200c00ULL,
0x0000541038387816ULL, 0x002fce0000000039ULL, 0x0000003b00667306ULL, 0x0003e20000200c00ULL,
0x00000018ff3a7819ULL, 0x008fe20000011454ULL, 0x0000010035547824ULL, 0x000fe200078e00ffULL,
0x000054105c397816ULL, 0x004fc8000000005fULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000003a00457306ULL, 0x0005e20000200c00ULL, 0x00008880353b7816ULL, 0x042fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x000000381028723cULL, 0x000fe80000001828ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054105a3a7816ULL, 0x004fce0000000043ULL, 0x0000003b00437306ULL, 0x0003f00000200c00ULL,
0x0000004100417306ULL, 0x000ea20000200c00ULL, 0x00005410613b7816ULL, 0x002fce0000000062ULL,
0x0000003a3c18723cULL, 0x000b620000001818ULL, 0x0000005000507306ULL, 0x000fec0000200c00ULL,
0x00000100363b7824ULL, 0x060fe200078e00ffULL, 0x00008880363a7816ULL, 0x040fe200000000ffULL,
0x00000100373d7824ULL, 0x040fe200078e00ffULL, 0x00008880373c7816ULL, 0x040fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x00000018ff397819ULL, 0x000fe40000011437ULL, 0x0000541040407816ULL, 0x004fc60000000041ULL,
0x0000003b003b7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x000054103a3a7816ULL, 0x002fce000000003bULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000541066377816ULL, 0x002fce0000000048ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000006300637306ULL, 0x000eb00000200c00ULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000054105d417816ULL, 0x002fce0000000060ULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x0000541063507816ULL, 0x004fe20000000050ULL,
0x000000401030723cULL, 0x000f6c0000001830ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000541065517816ULL, 0x008fce0000000051ULL, 0x0000003400347306ULL, 0x000ee20000200c00ULL,
0x0000541042427816ULL, 0x002fe20000000045ULL, 0x00000050102c723cULL, 0x000f6c000000182cULL,
0x0000003500357306ULL, 0x000e620000200c00ULL, 0x0000541043437816ULL, 0x004fce0000000054ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541034347816ULL, 0x008fe2000000004aULL,
0x000000421020723cULL, 0x000f6c0000001820ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x0000541035357816ULL, 0x002fce0000000049ULL, 0x0000003600387306ULL, 0x0002e20000200c00ULL,
0x00000034101c723cULL, 0x000f6e000000181cULL, 0x00000039003e7306ULL, 0x000f220000200c00ULL,
0x0000541067367816ULL, 0x002fe2000000000dULL, 0x00000002000d7824ULL, 0x000fe200078e00ffULL,
0x000054103c3b7816ULL, 0x004fc4000000003dULL, 0x0000541038387816ULL, 0x008fc6000000004fULL,
0x000000361024723cULL, 0x000f620000001824ULL, 0x000054103e397816ULL, 0x010fce000000004bULL,
0x0000003a1018723cULL, 0x040f700000001818ULL, 0x000000381014723cULL, 0x000b6e0000001814ULL,
0x0000f6c844107811ULL, 0x020fc400078e18ffULL, 0xfffffff80d127812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900012ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0d7224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x004fc80000015200ULL,
0x000004000a357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001000b127824ULL, 0x000fca00078e0277ULL,
0x000000c012107810ULL, 0x000fc80007ffe0ffULL, 0x00000060100d7812ULL, 0x000fca00078ec0ffULL,
0x000000016a137824ULL, 0x000fe200078e020dULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x00000010640d7217ULL, 0x000fe20007800000ULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x000064000c3b7a11ULL, 0x000fc600078a38ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a10ULL,
0x0000001011107812ULL, 0x000fe400078ec0ffULL, 0x00000003ff117819ULL, 0x000fe40000011604ULL,
0x0000000d100d7217ULL, 0x000fe40007800000ULL, 0x0000000411347810ULL, 0x040fe40007ffe0ffULL,
0x0000000811357810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a10ULL,
0x0000000c11367810ULL, 0x000fc40007ffe0ffULL, 0x000065000c3d7a11ULL, 0x000fe400028f3cffULL,
0x0000000d1100720cULL, 0x0c0fe20003f86070ULL, 0x0000000111117824ULL, 0x100fe200078e0210ULL,
0x0000000d3400720cULL, 0x0c0fe20003f66070ULL, 0x0000000134347824ULL, 0x100fe200078e0210ULL,
0x0000000d3500720cULL, 0x0c0fe20003f46070ULL, 0x0000000135357824ULL, 0x100fe200078e0210ULL,
0x0000000d3600720cULL, 0x040fe20003f06070ULL, 0x0000000136387824ULL, 0x000fe400078e0210ULL,
0x00000001110d7824ULL, 0x000fc400078e0204ULL, 0x0000000811367824ULL, 0x040fe400078e00ffULL,
0x0000000111107824ULL, 0x000fe400078e0213ULL, 0x0000000134117824ULL, 0x100fe200078e0204ULL,
0xfffffff836397812ULL, 0x000fe200078ee20dULL, 0x00000008343a7824ULL, 0x000fe400078e00ffULL,
0x00000001350d7824ULL, 0x040fe400078e0204ULL, 0x0000000835367824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff836417812ULL, 0x000fe200078ee20dULL, 0x0000000134347824ULL, 0x100fe200078e0213ULL,
0x0000005610107212ULL, 0x000fe200078efcffULL, 0x0000000135367824ULL, 0x000fe400078e0213ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003b10107210ULL, 0x000fc60007fbe0ffULL,
0x00000001380d7824ULL, 0x000fe200078e0213ULL, 0x0000005634347212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000005636367212ULL, 0x000fc600078efcffULL, 0x0000000111117824ULL, 0x100fe200028e063dULL,
0x0000003b34347210ULL, 0x080fe20007fbe0ffULL, 0x0000000138137824ULL, 0x000fe200078e0204ULL,
0x000000560c0c7212ULL, 0x000fe200078efcffULL, 0x0000000838387824ULL, 0x000fe400078e00ffULL,
0x0000000135357824ULL, 0x000fe200028e063dULL, 0x0000003b36367210ULL, 0x080fe40007fbe0ffULL,
0x0000003b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010413b7824ULL, 0x100fe200078e0202ULL,
0xfffffff838437812ULL, 0x000fe200078ee213ULL, 0x0000001039137824ULL, 0x000fc400078e0202ULL,
0x000000103f397824ULL, 0x100fe400078e0202ULL, 0x0000000137377824ULL, 0x100fe200028e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000e101c48ULL,
0x000000010d0d7824ULL, 0x000fe400030e063dULL, 0x00000010433d7824ULL, 0x000fe200078e0202ULL,
0x0000000034397faeULL, 0x0003e8000d901c48ULL, 0x00000000363b7faeULL, 0x0003e8000d101c48ULL,
0x000000000c3d7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000d7824ULL, 0x000fca00078e00ffULL, 0x000000100d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000d040d7211ULL, 0x000fc800078fe8ffULL, 0x000000040d117810ULL, 0x040fe20007ffe0ffULL,
0x000000010d107824ULL, 0x040fe200078e0204ULL, 0x000000080d357810ULL, 0x040fe20007ffe0ffULL,
0x000000080d3b7824ULL, 0x040fe200078e00ffULL, 0x0000000c0d377810ULL, 0x040fe20007ffe0ffULL,
0x000000010d367824ULL, 0x100fe400078e0213ULL, 0x0000000111387824ULL, 0x100fe200078e0213ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000135347824ULL, 0x100fe400078e0213ULL,
0x0000000137107824ULL, 0x000fc400078e0213ULL, 0x0000000137137824ULL, 0x140fe400078e0204ULL,
0x00000008373e7824ULL, 0x000fe400078e00ffULL, 0x00000001110d7824ULL, 0x140fe400078e0204ULL,
0x00000008113a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e437812ULL, 0x000fe200078ee213ULL,
0x0000000135117824ULL, 0x040fe200078e0204ULL, 0x000064000c137a11ULL, 0x000fe200078038ffULL,
0x00000008353c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3f7812ULL, 0x000fe200078ee20dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000065000c3d7a11ULL, 0x000fc400000f3cffULL,
0xfffffff83c417812ULL, 0x000fe200078ee211ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x00000056360d7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005638367212ULL, 0x080fe400078efcffULL, 0x000000130d0c7210ULL, 0x080fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000005634347212ULL, 0x080fe400078efcffULL,
0x0000001336367210ULL, 0x080fe20007f5e0ffULL, 0x00000001370d7824ULL, 0x100fe200000e063dULL,
0x0000005610107212ULL, 0x000fe400078efcffULL, 0x0000001334347210ULL, 0x080fe20007f1e0ffULL,
0x0000000139377824ULL, 0x000fe200010e063dULL, 0x0000001310107210ULL, 0x000fe20007f7e0ffULL,
0x000000103b137824ULL, 0x000fc400078e0202ULL, 0x000000103f397824ULL, 0x100fe400078e0202ULL,
0x0000000135357824ULL, 0x100fe200000e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fe400018e063dULL,
0x00000010413b7824ULL, 0x100fe200078e0202ULL, 0x0000000036397faeULL, 0x0003e2000b901c48ULL,
0x00000010433d7824ULL, 0x000fc600078e0202ULL, 0x00000000343b7faeULL, 0x0003e8000b901c48ULL,
0x00000000103d7faeULL, 0x0003e4000b901c48ULL, 0x00000000720573c2ULL, 0x000ea200000e0000ULL,
0x0000000255557810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0c7424ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000006b5500720cULL, 0x000fda0003f06070ULL,
0x0000000155108824ULL, 0x000fe400078e026cULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x0000f6b005057890ULL, 0x004fc6000fffe03fULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x00000008100c8981ULL, 0x000322000c1e1900ULL, 0x00000008000d7824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a05ULL, 0xfffffff00d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b0000d347f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480009107f8cULL, 0x0022a4000c80043fULL, 0x0000000000367805ULL, 0x000fc40000015200ULL,
0x00f64c00090d7984ULL, 0x004ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003836387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e37ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011439ULL,
0x000000380d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x000000020d0d7819ULL, 0x000fc80000001238ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00090d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000097824ULL, 0x002fca00078e00ffULL, 0xffffff8009097812ULL, 0x000fc800078ec0ffULL,
0x0000010056097810ULL, 0x000fca0007ffe009ULL, 0x0000000170097824ULL, 0x000fca00078e0209ULL,
0x00f0000009367984ULL, 0x000e680000000800ULL, 0x00f2000009137984ULL, 0x0004e20000000800ULL,
0x000000053600720bULL, 0x002fe20003f1d000ULL, 0x0000b6027f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d387812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff097424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000026d097810ULL, 0x000fe40007ffe0ffULL,
0x000000053600720bULL, 0x000fe40003f54000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000b5b27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000097806ULL, 0x000fc400010e0100ULL,
0x0000008000118824ULL, 0x000fe200078e0256ULL, 0x00000005360d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991009107816ULL, 0x000fe200000000ffULL,
0x00000001703a8824ULL, 0x000fca00078e0211ULL, 0x00f4000d3a008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000536107209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL, 0x00000005100d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d003a7308ULL, 0x000e640000000800ULL,
0x0000003a03037220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011604ULL, 0x0000b4d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d3a0d7589ULL, 0x0002a400000e0000ULL, 0x0000000d30307220ULL, 0x084fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040d7811ULL, 0x000fe200078ff0ffULL, 0x0000b3b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d3a0d7589ULL, 0x00046400000e0000ULL, 0x0000000d32327220ULL, 0x086fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff38ff7812ULL, 0x000fe20007806009ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000000536057209ULL, 0x000fd60007810000ULL, 0x8000000536360221ULL, 0x000fe20000010000ULL,
0x00007610ff090816ULL, 0x000fc60000000009ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600080308ULL, 0x000e640000000800ULL, 0x0000000813130220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000313037221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x00000008000d7824ULL, 0x000fca00078e00ffULL,
0xfffffff00d137812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00130d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003610367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e11ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011437ULL, 0x000000360d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x000000020d0d7819ULL, 0x000fc80000001236ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00130d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991009097816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011604ULL, 0x0000541006097816ULL, 0x000fe20000000006ULL,
0x0000af627f007947ULL, 0x000fea000b800000ULL, 0x00001f0e09077589ULL, 0x0002a400000e0000ULL,
0x000000080e0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000af927f007947ULL, 0x000fea000b800000ULL,
0x00001f0d09067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100e0d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0009ULL,
0x00007e4000117802ULL, 0x000fc40000000f00ULL, 0x0000b5e000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180e0d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0009ULL, 0x00007e9000117802ULL, 0x000fc40000000f00ULL,
0x0000b59000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010473c7824ULL, 0x100fe200078e0269ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001046487824ULL, 0x000fc400078e0269ULL, 0x000000104c387824ULL, 0x100fe400078e0269ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x000000104d407824ULL, 0x000fc600078e0269ULL,
0x000000004848783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x00000018ff507819ULL, 0x008fe2000001143cULL,
0x000001003c4c7824ULL, 0x040fe200078e00ffULL, 0x000088803c547816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001143dULL,
0x000001003d517824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000100003f5a7824ULL, 0x000fe200078e00ffULL, 0x000088803d587816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004c00597306ULL, 0x0007e20000200c00ULL, 0x00000018ff097819ULL, 0x002fe2000001143eULL,
0x00000100485c7824ULL, 0x004fe200078e00ffULL, 0x000088803e677816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff5b7819ULL, 0x000fe20000011451ULL,
0x0000003c00527306ULL, 0x0003e20000200c00ULL, 0x000001003e4c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f617816ULL, 0x040fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001144cULL,
0x0000003d00517306ULL, 0x0005e20000200c00ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001143eULL, 0x00000018ff607819ULL, 0x000fe4000001145cULL,
0x00000018ff6f7819ULL, 0x000fe4000001143cULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x00a000004e3c783bULL, 0x0044e20000000200ULL, 0x00000018ff477819ULL, 0x000fe40000011449ULL,
0x00008880495c7816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fc40000011448ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00000100494e7824ULL, 0x044fe200078e00ffULL,
0x00008880485d7816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000018ff637819ULL, 0x000fe2000001144eULL,
0x00010000484e7824ULL, 0x000fe200078e00ffULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541054487816ULL, 0x002fe40000000059ULL, 0x00000018ff547819ULL, 0x000fc40000011449ULL,
0x00000018ff367819ULL, 0x000fe40000011440ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00000018ff377819ULL, 0x000fe40000011441ULL,
0x00000018ff467819ULL, 0x000fe4000001144aULL, 0x00000018ff457819ULL, 0x000fe4000001144bULL,
0x00000018ff107819ULL, 0x000fe20000011442ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0000541058497816ULL, 0x004fc4000000005bULL, 0x000088804a5b7816ULL, 0x000fe400000000ffULL,
0x000088804b587816ULL, 0x000fe400000000ffULL, 0x00000018ff117819ULL, 0x000fe20000011443ULL,
0x0000005a00667306ULL, 0x000fe20000200c00ULL, 0x000000073c3c8232ULL, 0x088fe20000000000ULL,
0x00000018ff0e7819ULL, 0x000fe20000011438ULL, 0x000000073e3e8232ULL, 0x000fe20000000000ULL,
0x00000018ff0d7819ULL, 0x000fe20000011439ULL, 0x000000063d3d8232ULL, 0x080fe20000000000ULL,
0x00000018ff137819ULL, 0x000fe2000001143aULL, 0x000000063f3f8232ULL, 0x000fe20000000000ULL,
0x0000000900097306ULL, 0x000fe20000200c00ULL, 0x00000018ff0f7819ULL, 0x000fca000001143bULL,
0x000000483c30723cULL, 0x000be40000001830ULL, 0x0000004c004c7306ULL, 0x000eaa0000200c00ULL,
0x000001004a487824ULL, 0x060fe400078e00ffULL, 0x000001004b497824ULL, 0x040fe200078e00ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fc40000011449ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000004800597306ULL, 0x0003e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fce000001144bULL,
0x00000049005a7306ULL, 0x0007e20000200c00ULL, 0x0000541052487816ULL, 0x002fce0000000050ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541051497816ULL, 0x008fe4000000004dULL,
0x00008880404d7816ULL, 0x000fe400000000ffULL, 0x0000888041517816ULL, 0x000fc600000000ffULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000000483c2c723cULL, 0x000b6e000000182cULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000010040487824ULL, 0x060fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc400078e00ffULL, 0x0000010041497824ULL, 0x040fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff527819ULL, 0x000fe40000011449ULL, 0x0000888042497816ULL, 0x000fc600000000ffULL,
0x0000004e00627306ULL, 0x0005f00000200c00ULL, 0x0000004800507306ULL, 0x0007e20000200c00ULL,
0x000054104c4e7816ULL, 0x004fe20000000009ULL, 0x0000010043097824ULL, 0x000fe200078e00ffULL,
0x00005410664f7816ULL, 0x002fc8000000004fULL, 0x00000018ff4c7819ULL, 0x000fe20000011409ULL,
0x0000004000657306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x008fe20000011441ULL,
0x0000004e3c24723cULL, 0x000b620000001824ULL, 0x0000541061417816ULL, 0x000fe4000000006fULL,
0x0000000704097812ULL, 0x000fc600078ec0ffULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000541067407816ULL, 0x002fe4000000006eULL, 0x00008880384e7816ULL, 0x020fca00000000ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000000403c28723cULL, 0x000bee0000001828ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000000809417812ULL, 0x020fe200078ef804ULL,
0x0000010042407824ULL, 0x040fe200078e00ffULL, 0x0000000257097810ULL, 0x000fe20007ffe0ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x00000018ff427819ULL, 0x000fce0000011442ULL,
0x0000005300537306ULL, 0x000eb00000200c00ULL, 0x0000004800617306ULL, 0x0007f00000200c00ULL,
0x0000004a005e7306ULL, 0x0003e20000200c00ULL, 0x0000000841487824ULL, 0x008fc400078e00ffULL,
0x0000020000417824ULL, 0x000fc600078e00ffULL, 0xfffffff848097812ULL, 0x000fe200078ee209ULL,
0x000000ffff487224ULL, 0x000fe200078e004eULL, 0x0000004b005f7306ULL, 0x000fe20000200c00ULL,
0x00008880434a7816ULL, 0x042fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0xfffff800414e7812ULL, 0x000fe400078ec0ffULL, 0x000054105c417816ULL, 0x000fe40000000063ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000040004b7306ULL, 0x0003e20000200c00ULL,
0x00000010094f7824ULL, 0x000fe200078e024eULL, 0x00005410624e7816ULL, 0x004fc40000000053ULL,
0x0000888039627816ULL, 0x000fc800000000ffULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054105d407816ULL, 0x002fce0000000060ULL, 0x0000004200607306ULL, 0x0003f00000200c00ULL,
0x00000043005d7306ULL, 0x0005e20000200c00ULL, 0x0000010038427824ULL, 0x042fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011442ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000000403c40723cULL, 0x004be40000001820ULL,
0x00a000004f20783bULL, 0x0202aa0000000200ULL, 0x0000004600467306ULL, 0x000ef00000200c00ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410544f7816ULL, 0x002fe20000000047ULL,
0x0000010039477824ULL, 0x000fc400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x0000004e3c1c723cULL, 0x000b62000000181cULL, 0x000054105e467816ULL, 0x008fcc0000000046ULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x00000018ff4e7819ULL, 0x020fe40000011438ULL,
0x00000018ff4f7819ULL, 0x000fca0000011439ULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x000054105b387816ULL, 0x002fe20000000059ULL, 0x0000000720208232ULL, 0x084fe40000000000ULL,
0x0000000722228232ULL, 0x000fe40000000000ULL, 0x0000000621218232ULL, 0x080fe40000000000ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x0000541058397816ULL, 0x008fe2000000005aULL,
0x0000000623238232ULL, 0x000fe20000000000ULL, 0x000001003a587824ULL, 0x000fca00078e00ffULL,
0x00000047005c7306ULL, 0x0005e20000200c00ULL, 0x0000541065367816ULL, 0x000fe20000000036ULL,
0x000000383c18723cULL, 0x000b620000001818ULL, 0x0000541061377816ULL, 0x002fca0000000037ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x000054105f477816ULL, 0x004fe40000000045ULL,
0x000088803a397816ULL, 0x020fe200000000ffULL, 0x00000036202c723cULL, 0x000fe8000000182cULL,
0x0000001100117306ULL, 0x000ea80000200c00ULL, 0x000000463c14723cULL, 0x000b680000001814ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000541060107816ULL, 0x002fc40000000010ULL,
0x000001003b3e7824ULL, 0x060fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe40000011458ULL,
0x000088803b3d7816ULL, 0x000fe400000000ffULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fe2000001143eULL, 0x000100003a3e7824ULL, 0x000fe200078e00ffULL,
0x000054105d117816ULL, 0x004fe20000000011ULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x000000102024723cULL, 0x000b6c0000001824ULL,
0x0000004d004d7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x000054104d507816ULL, 0x002fce0000000050ULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x0000541051517816ULL, 0x004fce0000000052ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000000502030723cULL, 0x000f6e0000001830ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x000054104a377816ULL, 0x002fce000000004cULL, 0x0000006200547306ULL, 0x000ff00000200c00ULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x0000541048487816ULL, 0x004fce0000000053ULL,
0x0000004f00387306ULL, 0x000eb00000200c00ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x000054104e4e7816ULL, 0x002fce000000000eULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x00005410384f7816ULL, 0x004fe4000000000dULL, 0x0000f6986d0d7811ULL, 0x000fca00078e18ffULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000004e201c723cULL, 0x000f6e000000181cULL,
0x00000036003a7306ULL, 0x0004e20000200c00ULL, 0x00005410393c7816ULL, 0x002fce000000003cULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x0000541049367816ULL, 0x004fe4000000004bULL,
0x0000541054497816ULL, 0x000fe4000000005cULL, 0x000054103d3d7816ULL, 0x008fc6000000003aULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x000000362028723cULL, 0x040f6e0000001828ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x000000482040723cULL, 0x040f6e0000001840ULL,
0x0000003b00107306ULL, 0x020ea20000200c00ULL, 0x0000003c2018723cULL, 0x000f620000001818ULL,
0x000054103e0e7816ULL, 0x002fc40000000013ULL, 0x00005410100f7816ULL, 0x004fce000000000fULL,
0x0000000e2014723cULL, 0x000b6e0000001814ULL, 0x0000f6c8440e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000000e0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000dff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff137224ULL, 0x000fc600078e00ffULL, 0x0000000000107805ULL, 0x000fc80000015200ULL,
0x000004000a0d7984ULL, 0x004ea40000000800ULL, 0x800000000dff7812ULL, 0x006fc4000780480fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002010207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e11ULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011421ULL, 0x000000200d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x000000020d0d7819ULL, 0x000fc80000001220ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b0d7810ULL, 0x000fc80007ffe0ffULL,
0x000000680d00720cULL, 0x000fda0003f06070ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL, 0x000059000c0a7a24ULL, 0x010fe200078e02ffULL,
0x0000010012127810ULL, 0x000fe40007ffe0ffULL, 0x000000680d00720cULL, 0x000fe20003f06070ULL,
0x000000800a0a7824ULL, 0x000fe200078e00ffULL, 0x00000060120d7812ULL, 0x000fca00078ec0ffULL,
0x000000016a0f7824ULL, 0x000fcc00078e020dULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x00000012640d7217ULL, 0x000fe20007800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc60000011604ULL, 0x000000010d0d7824ULL, 0x000fe200078e0a12ULL,
0x000000100e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000410117810ULL, 0x000fe40007ffe0ffULL,
0x0000000d0e0d7217ULL, 0x000fe40007800000ULL, 0x0000000810137810ULL, 0x040fe20007ffe0ffULL,
0x0000000111127824ULL, 0x100fe200078e020eULL, 0x0000000c10207810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fc400078e0a0eULL, 0x0000000113217824ULL, 0x100fe400078e020eULL,
0x0000000120237824ULL, 0x100fe200078e020eULL, 0x0000000d1000720cULL, 0x0c0fe20003f86070ULL,
0x0000000110107824ULL, 0x000fe200078e020eULL, 0x0000000d1100720cULL, 0x080fe20003f66070ULL,
0x0000000812367824ULL, 0x000fe200078e00ffULL, 0x0000000d2000720cULL, 0x080fe20003f06070ULL,
0x0000000110117824ULL, 0x040fe200078e0204ULL, 0x0000000d1300720cULL, 0x000fe20003f46070ULL,
0x0000000810227824ULL, 0x000fc400078e00ffULL, 0x0000000110207824ULL, 0x100fe400078e020fULL,
0x0000000112107824ULL, 0x000fe200078e020fULL, 0xfffffff822227812ULL, 0x000fe200078ee211ULL,
0x0000000112137824ULL, 0x100fe400078e0204ULL, 0x00000001210d7824ULL, 0x040fe400078e0204ULL,
0x0000000821387824ULL, 0x040fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee213ULL,
0x00000001210e7824ULL, 0x000fc400078e020fULL, 0x0000000123127824ULL, 0x040fe200078e020fULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x00000001230f7824ULL, 0x040fe200078e0204ULL,
0x000064000a0d7a11ULL, 0x000fe200078a38ffULL, 0x00000008233a7824ULL, 0x000fe400078e00ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000065000a237a11ULL, 0x000fe400028f3cffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000005620207212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000005610107212ULL, 0x000fe400078efcffULL, 0x000000200d207210ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000d10107210ULL, 0x080fe40007fde0ffULL,
0x000000560e0e7212ULL, 0x080fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200028e0623ULL,
0x0000005612127212ULL, 0x000fe200078efcffULL, 0x0000000111117824ULL, 0x000fe200030e0623ULL,
0x0000000d0e0e7210ULL, 0x080fe20007fbe0ffULL, 0x0000001036377824ULL, 0x100fe200078e0269ULL,
0x0000000d12127210ULL, 0x000fe20007fde0ffULL, 0x00000010220d7824ULL, 0x000fc400078e0269ULL,
0x0000001038397824ULL, 0x000fe400078e0269ULL, 0x000000010f0f7824ULL, 0x000fe200028e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000200d7faeULL, 0x0003e2000e101c48ULL,
0x000000103a697824ULL, 0x000fe400078e0269ULL, 0x0000000113137824ULL, 0x000fe200030e0623ULL,
0x0000000010377faeULL, 0x0003e8000d901c48ULL, 0x000000000e397faeULL, 0x0003e8000d101c48ULL,
0x0000000012697faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000d7824ULL, 0x000fca00078e00ffULL, 0x000000100d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000d040d7211ULL, 0x000fc800078fe8ffULL, 0x000000040d117810ULL, 0x040fe20007ffe0ffULL,
0x000000010d107824ULL, 0x040fe200078e0204ULL, 0x0000000c0d217810ULL, 0x040fe20007ffe0ffULL,
0x000000080d137824ULL, 0x040fe400078e00ffULL, 0x000000010d0e7824ULL, 0x100fe400078e020fULL,
0x0000000811367824ULL, 0x000fe200078e00ffULL, 0xfffffff813227812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x000fe200078e020fULL, 0x000000080d137810ULL, 0x000fe20007ffe0ffULL,
0x00000001110d7824ULL, 0x000fc400078e0204ULL, 0x0000000121207824ULL, 0x100fe400078e020fULL,
0x0000000113127824ULL, 0x040fe200078e020fULL, 0xfffffff836367812ULL, 0x000fe200078ee20dULL,
0x0000000113117824ULL, 0x140fe200078e0204ULL, 0x000064000a0d7a11ULL, 0x000fe200078038ffULL,
0x0000000813387824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000065000a237a11ULL, 0x000fe400000f3cffULL, 0xfffffff838387812ULL, 0x000fe200078ee211ULL,
0x0000000121137824ULL, 0x040fe200078e0204ULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x00000008213a7824ULL, 0x000fc400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000e0d0e7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005610107212ULL, 0x000fc600078efcffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000005612127212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200000e0623ULL, 0x0000005620207212ULL, 0x000fe200078efcffULL,
0x0000001036377824ULL, 0x100fe200078e0269ULL, 0x000000100d107210ULL, 0x040fe20007f1e0ffULL,
0x0000001038397824ULL, 0x100fe200078e0269ULL, 0x000000120d127210ULL, 0x040fe40007f5e0ffULL,
0x000000200d207210ULL, 0x000fe20007f7e0ffULL, 0x00000010220d7824ULL, 0x000fe400078e0269ULL,
0x0000000111117824ULL, 0x000fc400000e0623ULL, 0x0000000113137824ULL, 0x000fe200010e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000b901c48ULL,
0x000000103a697824ULL, 0x000fe400078e0269ULL, 0x0000000121217824ULL, 0x000fe200018e0623ULL,
0x0000000010377faeULL, 0x0003e8000b901c48ULL, 0x0000000012397faeULL, 0x0003e8000b901c48ULL,
0x0000000020697faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000010440a7824ULL, 0x000fc400078e00ffULL, 0x00000008000d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x000000100a0a7812ULL, 0x000fe400078ee2ffULL,
0x000000080d0d7812ULL, 0x000fc600078ec0ffULL, 0x000000206d0a7824ULL, 0x000fc800078e020aULL,
0x000000010d0a7824ULL, 0x000fe200078e020aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800720e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668000a107f8cULL, 0x000662000c80043fULL,
0x000000ffff0e7224ULL, 0x004fc600078e000fULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x00f66c000a0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002012207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e13ULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011421ULL,
0x000000200d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000020d0d7819ULL, 0x000fc80000001220ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c000a0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806d0d7811ULL, 0x000fc800078e38ffULL, 0x0000000d700d7210ULL, 0x000fca0007ffe056ULL,
0x00f000000d0a7984ULL, 0x008e680000000800ULL, 0x00f200000d127984ULL, 0x0004e20000000800ULL,
0x000000050a00720bULL, 0x002fe20003f1d000ULL, 0x000091827f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d207812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e0005ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000036d0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000050a00720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x000091227f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x0000008000118824ULL, 0x000fe200078e0256ULL,
0x000000050a0d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100f107816ULL, 0x000fe200000000ffULL, 0x0000000170708824ULL, 0x000fca00078e0211ULL,
0x00f4000d70008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000050a107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL,
0x00000005100d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00227308ULL, 0x000e640000000800ULL, 0x0000002203037220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011604ULL,
0x000090427f007947ULL, 0x000fea000b800000ULL, 0x00001f0d220d7589ULL, 0x0002a400000e0000ULL,
0x0000000d30307220ULL, 0x084fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d40407220ULL, 0x080fe20000410000ULL, 0x0000000d41417220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040d7811ULL, 0x000fe200078ff0ffULL,
0x00008f227f007947ULL, 0x000fea000b800000ULL, 0x00001f0d220d7589ULL, 0x00046400000e0000ULL,
0x0000000d32327220ULL, 0x086fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d42427220ULL, 0x080fe20000410000ULL, 0x0000000d43437220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff20ff7812ULL, 0x000fe2000780600fULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000050a0f7209ULL, 0x000fd60007810000ULL,
0x8000000f0a0a0221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00080308ULL, 0x000e640000000800ULL,
0x0000000812120220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000312037221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6b40072137984ULL, 0x000e620000000800ULL, 0x0000000400057824ULL, 0x000fe400078e00ffULL,
0x00000004730a7824ULL, 0x000fc600078e00ffULL, 0x0000000405207812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc600078e00ffULL, 0x0000000220207810ULL, 0x000fe40007ffe0ffULL,
0x8000000013ff7812ULL, 0x002fe20007804835ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff137224ULL, 0x000fe200078e0020ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210217210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000002112127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b40072137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff137224ULL, 0x000fc400078e0020ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d057816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0500720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000008ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff127819ULL, 0x000fe40000011604ULL,
0x0000541005057816ULL, 0x000fe20000000005ULL, 0x00008a727f007947ULL, 0x000fea000b800000ULL,
0x00001f1205077589ULL, 0x0002a400000e0000ULL, 0x00000008120d7810ULL, 0x000fe20007ffe0ffULL,
0x00008aa27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d05067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010120d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0005ULL, 0x0000a4f000117802ULL, 0x000fc40000000f00ULL,
0x00008f3000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018120d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0005ULL,
0x0000a54000117802ULL, 0x000fc40000000f00ULL, 0x00008ee000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000704127812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000036d4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000812057812ULL, 0x008fe400078ef804ULL, 0x0000000804117812ULL, 0x000fe200078ec0ffULL,
0x000008004b4b7824ULL, 0x000fe400078e00ffULL, 0x00000008054a7824ULL, 0x000fca00078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fca00078ee257ULL, 0x000000104a4a7824ULL, 0x000fc400078e024bULL,
0x0000000a04107211ULL, 0x040fe400078fe0ffULL, 0x00000012110d7212ULL, 0x044fe400078efcffULL,
0x0000001304137211ULL, 0x000fe400078fe0ffULL, 0x0000001011127812ULL, 0x000fe200078efe12ULL,
0x000000010d057824ULL, 0x040fe400078e0210ULL, 0x000000080d0a7824ULL, 0x000fe400078e00ffULL,
0x0000000812117824ULL, 0x000fc600078e00ffULL, 0xfffffff80a057812ULL, 0x000fe200078ee205ULL,
0x000000010d0a7824ULL, 0x040fe400078e0213ULL, 0x000000080d0d7824ULL, 0x000fe400078e00ffULL,
0x0000001005057824ULL, 0x000fc600078e0202ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20aULL,
0x00000001120a7824ULL, 0x000fe200078e0210ULL, 0x000000000520783bULL, 0x0002a60000004200ULL,
0x000000100d0d7824ULL, 0x000fe200078e0202ULL, 0xfffffff811117812ULL, 0x000fc800078ee20aULL,
0x000000000d38783bULL, 0x000ee20000004200ULL, 0x0000001011117824ULL, 0x000fe400078e0202ULL,
0x0000000112057824ULL, 0x042fe400078e0213ULL, 0x0000000812127824ULL, 0x000fe200078e00ffULL,
0x000000001134783bULL, 0x000e680000004200ULL, 0xfffffff812057812ULL, 0x000fca00078ee205ULL,
0x0000001005057824ULL, 0x000fca00078e0202ULL, 0x000000000510783bULL, 0x000e620000004200ULL,
0x00000018ff6e7819ULL, 0x004fe20000011420ULL, 0x0000010020477824ULL, 0x040fe200078e00ffULL,
0x0000888020617816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011421ULL, 0x0000010021487824ULL, 0x040fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011447ULL, 0x0000010022497824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000888021477816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011422ULL, 0x00000018ff537819ULL, 0x000fe40000011423ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000002000707306ULL, 0x0005e20000200c00ULL,
0x0000888022657816ULL, 0x040fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888023637816ULL, 0x040fe400000000ffULL, 0x00000018ff4e7819ULL, 0x008fe40000011438ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x00000021006f7306ULL, 0x0007e20000200c00ULL,
0x0000010023207824ULL, 0x044fe200078e00ffULL, 0x00008880385a7816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc40000011448ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000010038217824ULL, 0x048fe200078e00ffULL, 0x0000002000677306ULL, 0x0005e20000200c00ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011439ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000888039597816ULL, 0x000fc400000000ffULL,
0x00000021005b7306ULL, 0x0007e20000200c00ULL, 0x0000010039207824ULL, 0x044fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe4000001143aULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000022005f7306ULL, 0x000fe20000200c00ULL, 0x000001003a217824ULL, 0x008fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x000088803a517816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011421ULL,
0x00000020005c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff467819ULL, 0x000fe4000001143bULL,
0x000088803b4f7816ULL, 0x040fe200000000ffULL, 0x0000002300567306ULL, 0x0007e20000200c00ULL,
0x000001003b207824ULL, 0x044fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x002fe20000011434ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc40000011436ULL,
0x00000018ff547819ULL, 0x000fe40000011420ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x009000004a20783bULL, 0x008ea20000000200ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff3f7819ULL, 0x000fe40000011435ULL, 0x00000018ff3d7819ULL, 0x000fe40000011437ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000018ff0d7819ULL, 0x000fc40000011412ULL,
0x00000018ff0a7819ULL, 0x000fe40000011413ULL, 0x00000018ff027819ULL, 0x000fe40000011410ULL,
0x00000018ff057819ULL, 0x000fe20000011411ULL, 0x0000004800607306ULL, 0x000ef00000200c00ULL,
0x0000003800587306ULL, 0x0003f00000200c00ULL, 0x0000003900577306ULL, 0x0005e20000200c00ULL,
0x0000010034387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000888035397816ULL, 0x004fe200000000ffULL,
0x0000000720208232ULL, 0x080fe40000000000ULL, 0x0000000722228232ULL, 0x000fe40000000000ULL,
0x0000000621218232ULL, 0x080fe40000000000ULL, 0x0000003800487306ULL, 0x0005e20000200c00ULL,
0x0000000623238232ULL, 0x000fce0000000000ULL, 0x00000039004a7306ULL, 0x0007e20000200c00ULL,
0x0000541061387816ULL, 0x004fce0000000078ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000541047397816ULL, 0x008fce0000000060ULL, 0x000000382030723cULL, 0x000b620000001830ULL,
0x0000003a005e7306ULL, 0x0007ec0000200c00ULL, 0x0000010037387824ULL, 0x020fe400078e00ffULL,
0x0000004900667306ULL, 0x0003e20000200c00ULL, 0x00000100353a7824ULL, 0x008fc400078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011438ULL, 0x0001000036387824ULL, 0x000fe400078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x0000888034497816ULL, 0x042fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff357819ULL, 0x000fc40000011435ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000006300637306ULL, 0x000e700000200c00ULL, 0x0000003b005d7306ULL, 0x0003f00000200c00ULL,
0x0000003a004c7306ULL, 0x0005e20000200c00ULL, 0x00000100363b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003800607306ULL, 0x0003e20000200c00ULL,
0x00008880363a7816ULL, 0x004fce00000000ffULL, 0x0000003900367306ULL, 0x0005e20000200c00ULL,
0x0000541070387816ULL, 0x002fce000000006eULL, 0x0000003400627306ULL, 0x000fe20000200c00ULL,
0x000054106f397816ULL, 0x004fce0000000069ULL, 0x0000003a00347306ULL, 0x0003e20000200c00ULL,
0x00000038202c723cULL, 0x000b6e000000182cULL, 0x0000541065387816ULL, 0x028fe20000000066ULL,
0x0000003b00477306ULL, 0x0004e20000200c00ULL, 0x00008880103a7816ULL, 0x002fc400000000ffULL,
0x0000541063397816ULL, 0x000fe40000000067ULL, 0x0000888011637816ULL, 0x000fe200000000ffULL,
0x000000ffff697224ULL, 0x000fe400078e003aULL, 0x00000010093a7824ULL, 0x000fe200078e024bULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x00000100103b7824ULL, 0x004fe200078e00ffULL,
0x000000382028723cULL, 0x000b680000001828ULL, 0x00000018ff4b7819ULL, 0x000fc4000001143bULL,
0x009000003a38783bULL, 0x020ea20000000200ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x0000541034347816ULL, 0x008fe40000000047ULL, 0x000054105f527816ULL, 0x002fca0000000052ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x00000100115f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x0000541056537816ULL, 0x000fe20000000053ULL, 0x000000ffff567224ULL, 0x000fcc00078e0063ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000522024723cULL, 0x000b6e0000001824ULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x000054105a527816ULL, 0x022fe4000000005bULL,
0x0000541059537816ULL, 0x008fe2000000005cULL, 0x0001000010597824ULL, 0x000fe200078e00ffULL,
0x0000000738388232ULL, 0x004fc60000000000ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000000073a3a8232ULL, 0x000fe20000000000ULL, 0x000000522040723cULL, 0x000be20000001840ULL,
0x0000000639398232ULL, 0x080fe20000000000ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x000000063b3b8232ULL, 0x000fc60000000000ULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x0000541058527816ULL, 0x020fe4000000004eULL, 0x0000541057537816ULL, 0x000fe2000000004dULL,
0x00010000114d7824ULL, 0x000fc800078e00ffULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000054105e5c7816ULL, 0x002fe20000000045ULL, 0x00000052201c723cULL, 0x000f62000000181cULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000054105d5d7816ULL, 0x004fce0000000046ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000005c2014723cULL, 0x000fee0000001814ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x00005410514e7816ULL, 0x002fce0000000050ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000054104f4f7816ULL, 0x004fce0000000054ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000004e2018723cULL, 0x000b620000001818ULL, 0x0000541049487816ULL, 0x002fcc0000000048ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054104a497816ULL, 0x000fe4000000004cULL,
0x0000888013217816ULL, 0x020fe200000000ffULL, 0x0000010012207824ULL, 0x040fe200078e00ffULL,
0x00008880124e7816ULL, 0x000fc600000000ffULL, 0x0000003500617306ULL, 0x0002e20000200c00ULL,
0x000000483830723cULL, 0x000b620000001830ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00005410623e7816ULL, 0x004fe2000000003eULL, 0x000000ffff457224ULL, 0x000fe200078e004eULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x000000ffff487224ULL, 0x020fe200078e0021ULL, 0x0000888037357816ULL, 0x002fe200000000ffULL,
0x0000010013217824ULL, 0x000fe200078e00ffULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0001000037377824ULL, 0x000fc400078e00ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00005410613f7816ULL, 0x008fe4000000003fULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x00000018ff137819ULL, 0x000fc60000011413ULL, 0x0000003e382c723cULL, 0x000b68000000182cULL,
0x0000003d003d7306ULL, 0x000ff00000200c00ULL, 0x0000000200027306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x002fc40000000036ULL, 0x0000541060367816ULL, 0x000fca000000003cULL,
0x0000000500057306ULL, 0x000fe20000200c00ULL, 0x000000343828723cULL, 0x000b6e0000001828ULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000000a000a7306ULL, 0x000ff00000200c00ULL,
0x0000003700377306ULL, 0x000e700000200c00ULL, 0x0000006900097306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541037377816ULL, 0x002fce000000003dULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000363834723cULL, 0x000b6e0000001824ULL,
0x0000005f00107306ULL, 0x000ff00000200c00ULL, 0x0000005900117306ULL, 0x000e700000200c00ULL,
0x0000004d004d7306ULL, 0x000eb00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00005410114c7816ULL, 0x002fc40000000002ULL, 0x0000000444027810ULL, 0x000fc80007ffe0ffULL,
0x0000f6a802027811ULL, 0x000fe200078e18ffULL, 0x0000002000467306ULL, 0x0002e20000200c00ULL,
0x000054104d4d7816ULL, 0x004fce0000000005ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x0000541009207816ULL, 0x002fe2000000004bULL, 0x0000004c381c723cULL, 0x000b6c000000181cULL,
0x00000021003f7306ULL, 0x0202a20000200c00ULL, 0x0000541045467816ULL, 0x008fce0000000046ULL,
0x0000001200127306ULL, 0x000ee20000200c00ULL, 0x0000541056217816ULL, 0x002fce0000000010ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x0000541048477816ULL, 0x004fe2000000003fULL,
0x000000203820723cULL, 0x000b620000001840ULL, 0x0000541012127816ULL, 0x008fce000000000dULL,
0x000000463818723cULL, 0x000b620000001818ULL, 0x0000541013137816ULL, 0x002fce000000000aULL,
0x000000123814723cULL, 0x000b620000001814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000002107f8cULL, 0x0002a2000c80043fULL, 0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL,
0x0000f6a06d057811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000005ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff027224ULL, 0x006fe200078e0011ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff625000007947ULL, 0x000fea000383ffffULL,
0x000000ff6800720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b71000047802ULL, 0x000fc40000000f00ULL,
0x00007b5000007944ULL, 0x03efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000003ULL,
0x800000ff02057221ULL, 0x008fc80000010100ULL, 0x0000000500007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003000307220ULL, 0x042fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x060fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x000fe20000410000ULL, 0x0000003204327220ULL, 0x044fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000001c1d1c723eULL, 0x000fc400000000ffULL, 0x000000181918723eULL, 0x020fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fc400000000ffULL,
0x00000016170d723eULL, 0x000fe400000000ffULL, 0x000000ff4400720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x00afe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x010fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x004fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000100073037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080044057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000076321a097816ULL, 0x000fe2000000000dULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000541002107816ULL, 0x040fe20000000004ULL, 0x0000000107087824ULL, 0x040fe200078e0208ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000282902723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000343504723eULL, 0x000fe200000000ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x0000000107077824ULL, 0x000fe200078e020cULL, 0x000000202105723eULL, 0x000fc400000000ffULL,
0x00000014150c723eULL, 0x000fe400000000ffULL, 0x000000363715723eULL, 0x000fe400000000ffULL,
0x0000541018127816ULL, 0x140fe4000000000cULL, 0x0000763218137816ULL, 0x000fe4000000000cULL,
0x0000541002107816ULL, 0x142fe40000000004ULL, 0x0000763202117816ULL, 0x000fc40000000004ULL,
0x000000323302723eULL, 0x000fe400000000ffULL, 0x0000002e2f04723eULL, 0x000fe200000000ffULL,
0x0000001008007388ULL, 0x0003e20000000a00ULL, 0x000054102a147816ULL, 0x140fe40000000015ULL,
0x000076322a157816ULL, 0x000fe40000000015ULL, 0x0000541005107816ULL, 0x142fe4000000001cULL,
0x0000763205117816ULL, 0x000fca000000001cULL, 0x000000100a007388ULL, 0x0003e80000000a00ULL,
0x0000001207007388ULL, 0x0005e20000000a00ULL, 0x0000001e1f11723eULL, 0x002fe400000000ffULL,
0x0000541002127816ULL, 0x144fe40000000004ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x0000000177027824ULL, 0x000fe200078e0200ULL, 0x0000541022047816ULL, 0x000fc40000000011ULL,
0x0000763222057816ULL, 0x000fe20000000011ULL, 0x000000120e007388ULL, 0x000fe20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x0004001408007388ULL, 0x0003e80000000a00ULL,
0x000400040a007388ULL, 0x000fe20000000a00ULL, 0x000054101a087816ULL, 0x002fca000000000dULL,
0x0004000807007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x0008000002107984ULL, 0x000ee80000000c00ULL, 0x000c000002187984ULL, 0x000ee20000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c02007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x000000740900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000176027824ULL, 0x000fe200078e0209ULL, 0x00005a00ff107a12ULL, 0x000fe400078e33ffULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff077224ULL, 0x004fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007050f7227ULL, 0x000fc800078e0004ULL,
0x0000000109047824ULL, 0x000fe400078e0200ULL, 0x000000020f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000710047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000590004057a24ULL, 0x000fe400078e0271ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000873077824ULL, 0x000fe400078e020eULL, 0x00005a0005027a24ULL, 0x000fca00078e0202ULL,
0x0000000275057210ULL, 0x000fe40007f3e0ffULL, 0x0000002000027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000740d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e020dULL, 0x00000001020d7824ULL, 0x000fe400078e020dULL,
0x000000040f057227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007067a24ULL, 0x000fca00078e0204ULL,
0x00005a0006007a0cULL, 0x000fda0003f26070ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d067812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001006067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x00000005100c7207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a0cULL, 0x000059000c057a24ULL, 0x000fe200078e0271ULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000873077824ULL, 0x000fe200078e0202ULL, 0x00000003ff0d7819ULL, 0x000fe2000001160cULL,
0x00005a0005047a24ULL, 0x000fca00078e0204ULL, 0x0000000475057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x000000740d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176027824ULL, 0x100fe200078e020dULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0d7824ULL, 0x000fe400078e020dULL,
0x000000020f057227ULL, 0x002fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef80cULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001004067824ULL, 0x000fc400078e0203ULL,
0x0000000176767824ULL, 0x000fc600078e020dULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x0000000510047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e0271ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x0000000873077824ULL, 0x000fe400078e020cULL,
0x00005a0005027a24ULL, 0x000fca00078e0202ULL, 0x0000000275027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005e0002047a11ULL, 0x000fc800078240ffULL,
0x00005f0002057a11ULL, 0x000fe400008f4405ULL, 0x000000740d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000760f087227ULL, 0x002fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a08ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x00005a0005027a24ULL, 0x000fc600078e0276ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000108081810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0xfffffff80d027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fe400078e0203ULL, 0x0000000873737824ULL, 0x000fc800078e0200ULL,
0x0000000108082810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e660000000c00ULL,
0x0000000810087207ULL, 0x000fca0004000000ULL, 0x000000ffff037224ULL, 0x000fe400078e0a08ULL,
0x0000590008717a24ULL, 0x000fe400078e0271ULL, 0x00005a0003767a24ULL, 0x000fc800078e0276ULL,
0x00005a0071767a24ULL, 0x000fca00078e0276ULL, 0x0000007675767210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0076027a11ULL, 0x000fc800078040ffULL,
0x00005f0076037a11ULL, 0x000fca00000f4403ULL, 0x0000001073027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff027819ULL, 0x000fe20000011600ULL, 0xffffffffff037424ULL, 0x002fc600078e00ffULL,
0x0000006b0200720cULL, 0x000fda0003f06070ULL, 0x00000002050d8824ULL, 0x000fc800078e00ffULL,
0x00006a000d0d8a24ULL, 0x000fc800078e0202ULL, 0x000066000d0c8625ULL, 0x000fe200078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL,
0x000000080c038981ULL, 0x000ea2000c1e1900ULL, 0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff087f8cULL, 0x000e68000c80043fULL, 0x000000080e617981ULL, 0x000722000c1e9900ULL,
0x000001ff0b00780cULL, 0x000fe20003f04070ULL, 0x00005800ff0b7624ULL, 0x000fe400078e00ffULL,
0x00000080716c7824ULL, 0x000fe400078e00ffULL, 0x0000004000757824ULL, 0x000fe200078e00ffULL,
0x0000001f0b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000800a717824ULL, 0x000fc600078e00ffULL,
0x000000406c1b7812ULL, 0x000fe400078ef875ULL, 0x00000005ff0b7819ULL, 0x000fe2000001160bULL,
0x0000007103277224ULL, 0x004fe200078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x00afe40000011604ULL, 0x0000640027257a11ULL, 0x000fe400078038ffULL,
0x000000081e187810ULL, 0x040fe20007ffe0ffULL, 0x000000011b0c7824ULL, 0x000fe200078e021eULL,
0x000000181e227810ULL, 0x000fc40007ffe0ffULL, 0x000000101e207810ULL, 0x040fe20007ffe0ffULL,
0x000000011b0e7824ULL, 0x000fe200078e0218ULL, 0x0000650027277a11ULL, 0x000fe200000f3cffULL,
0x000000011b127824ULL, 0x000fe200078e0222ULL, 0x000000281e1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000075640a7217ULL, 0x000fe40007800000ULL,
0x00001000001f7811ULL, 0x000fe200078e68ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000300e167812ULL, 0x000fc400078ef807ULL, 0x000000201e1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000030120e7812ULL, 0x000fe400078ef807ULL,
0x0000002516167210ULL, 0x000fe20007f3e0ffULL, 0x000000011b107824ULL, 0x000fe200078e0220ULL,
0x0000000404127211ULL, 0x000fe200078fe8ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a75ULL,
0x000000300c147812ULL, 0x000fe200078ef807ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000003121d7812ULL, 0x000fc400078ec0ffULL, 0x0000001425147210ULL, 0x000fe20007f1e0ffULL,
0x000000010f177824ULL, 0x000fe200008e0627ULL, 0x000000250e0e7210ULL, 0x080fe20007f3e0ffULL,
0x0000000418127824ULL, 0x000fe200078e00ffULL, 0x00000030100c7812ULL, 0x000fe200078ef807ULL,
0x000000010d157824ULL, 0x100fe200000e0627ULL, 0x0ffffffc1d047812ULL, 0x000fe200078ef804ULL,
0x00000001130f7824ULL, 0x000fe200008e0627ULL, 0xfffffffc12127812ULL, 0x000fe200078ee21dULL,
0x000000011b137824ULL, 0x040fe200078e021cULL, 0x000000250c0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000011b107824ULL, 0x000fe200078e021aULL, 0x0000000a1800720cULL, 0x080fe20003f26070ULL,
0x0000001012237824ULL, 0x000fe200078e021fULL, 0x0000000a2000720cULL, 0x080fe20003fa6070ULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000000a2200720cULL, 0x000fc40003f86070ULL,
0x0000000a1a00720cULL, 0x080fe20003f66070ULL, 0x00000001110d7824ULL, 0x000fe200000e0627ULL,
0x0000000a1e00720cULL, 0x080fe20003f06070ULL, 0x0000001004217824ULL, 0x000fe200078e021fULL,
0x0000003012187812ULL, 0x100fe200078ef807ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000301e047810ULL, 0x000fe40007ffe0ffULL, 0x0000002518187210ULL, 0x080fe20007fde0ffULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x000fe200078ef807ULL,
0x000000011b127824ULL, 0x000fe200078e0204ULL, 0x000000381e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113197824ULL, 0x000fe200030e0627ULL, 0x0000002510107210ULL, 0x000fe20007f5e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014217faeULL, 0x0003e2000c101c48ULL, 0x0000000a1e00720cULL, 0x000fc40003f06070ULL,
0x0000000111117824ULL, 0x000fe200010e0627ULL, 0x0000000016237faeULL, 0x0005e2000c901c48ULL,
0x0000003012127812ULL, 0x000fe400078ef807ULL, 0x0000000a1c00720cULL, 0x080fe40003f46070ULL,
0x0000000a0400720cULL, 0x000fe20003f26070ULL, 0x00000004220a7824ULL, 0x000fe200078e00ffULL,
0x0000002512127210ULL, 0x000fe20007fde0ffULL, 0x000000011b147824ULL, 0x002fe400078e021eULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee21dULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee21dULL,
0x000000041a167824ULL, 0x004fe200078e00ffULL, 0x0000003014077812ULL, 0x000fe200078ef807ULL,
0x000000041c1a7824ULL, 0x000fe400078e00ffULL, 0x00000004041c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc20047812ULL, 0x000fe200078ee21dULL, 0x0000000113137824ULL, 0x000fe200030e0627ULL,
0xfffffffc16167812ULL, 0x000fe200078ee21dULL, 0x000000100a177824ULL, 0x000fe200078e021fULL,
0xfffffffc1a1a7812ULL, 0x000fc400078ee21dULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee21dULL,
0x00000010161b7824ULL, 0x100fe200078e021fULL, 0x0000002507147210ULL, 0x000fe20007fde0ffULL,
0x0000001004077824ULL, 0x100fe400078e021fULL, 0x000000101a1d7824ULL, 0x100fe400078e021fULL,
0x000000101c217824ULL, 0x100fe200078e021fULL, 0x000000000c077faeULL, 0x0003e2000e901c48ULL,
0x000000101e1f7824ULL, 0x000fe400078e021fULL, 0x0000000115157824ULL, 0x000fe200030e0627ULL,
0x000000000e177faeULL, 0x0003e8000e101c48ULL, 0x00000000101b7faeULL, 0x0003e8000d901c48ULL,
0x00000000181d7faeULL, 0x0003e8000d101c48ULL, 0x0000000012217faeULL, 0x0003e8000c901c48ULL,
0x00000000141f7faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000001804127811ULL, 0x04afe400078ff0ffULL, 0x0000002004147811ULL, 0x000fc400078ff0ffULL,
0x0000000804107811ULL, 0x040fe200078ff0ffULL, 0x000000011b137824ULL, 0x040fe200078e0212ULL,
0x0000002804167811ULL, 0x000fe200078ff0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x00000004040d7211ULL, 0x040fe200078fe8ffULL, 0x000000011b157824ULL, 0x040fe200078e0214ULL,
0x00000010040a7811ULL, 0x040fe200078ff0ffULL, 0x000000011b0e7824ULL, 0x040fe200078e0210ULL,
0x0000003004187811ULL, 0x000fe200078ff0ffULL, 0x00000004101c7824ULL, 0x000fe200078e00ffULL,
0x00000038041a7811ULL, 0x000fe200078ff0ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x0000001b040c7211ULL, 0x000fe200078ff0ffULL, 0x000000011b177824ULL, 0x000fe200078e0216ULL,
0x000000030d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000011b107824ULL, 0x040fe200078e020aULL,
0x0000100000297811ULL, 0x000fe200078e68ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0xfffffffc120f7812ULL, 0x100fe200078ee21dULL, 0x000000011b197824ULL, 0x000fe200078e0218ULL,
0xfffffffc14117812ULL, 0x100fe200078ee21dULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16127812ULL, 0x100fe200078ee21dULL, 0x00000004181e7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc1d187812ULL, 0x000fe200078ef804ULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0x00006400272b7a11ULL, 0x000fe200078038ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c047812ULL, 0x100fe200078ee21dULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x000fc400078ee21dULL, 0xfffffffc1e147812ULL, 0x000fe200078ee21dULL,
0x000000100f217824ULL, 0x000fe200078e0229ULL, 0xfffffffc1a167812ULL, 0x000fe200078ee21dULL,
0x0000001011237824ULL, 0x000fe200078e0229ULL, 0x000000300c0c7812ULL, 0x000fe200078ef807ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00006500272d7a11ULL, 0x000fe400000f3cffULL,
0x0000000c2b0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001012257824ULL, 0x000fe200078e0229ULL,
0x000000300e0e7812ULL, 0x000fe200078ef807ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x00000010182f7824ULL, 0x000fe200078e0229ULL, 0x0000003010107812ULL, 0x000fe200078ef807ULL,
0x00000010041d7824ULL, 0x100fe400078e0229ULL, 0x000000100a1f7824ULL, 0x100fe200078e0229ULL,
0x000000102b107210ULL, 0x000fe20007f3e0ffULL, 0x0000001014277824ULL, 0x000fe400078e0229ULL,
0x0000008013127825ULL, 0x000fc800078e00ffULL, 0x0000001016297824ULL, 0x000fe200078e0229ULL,
0x0000003012127812ULL, 0x000fe200078ef807ULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0x000000122b127210ULL, 0x000fe20007f5e0ffULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000003014147812ULL, 0x000fc600078ef807ULL, 0x0000008019187825ULL, 0x000fe200078e00ffULL,
0x0000003016167812ULL, 0x100fe400078ef807ULL, 0x000000142b147210ULL, 0x000fe20007f7e0ffULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x0000003018187812ULL, 0x000fe400078ef807ULL,
0x000000162b167210ULL, 0x000fe20007f9e0ffULL, 0x000000010d0d7824ULL, 0x100fe200000e062dULL,
0x0000000e2b0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111117824ULL, 0x000fe200008e062dULL,
0x000000301a077812ULL, 0x000fe200078ef807ULL, 0x0000000113137824ULL, 0x100fe200010e062dULL,
0x000000182b187210ULL, 0x000fe20007fbe0ffULL, 0x000000010f0f7824ULL, 0x100fe200000e062dULL,
0x000000072b1a7210ULL, 0x000fe20007fde0ffULL, 0x0000000115157824ULL, 0x100fe200018e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2f7faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x000fc400020e062dULL, 0x0000000119197824ULL, 0x100fe200028e062dULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x000000011b1b7824ULL, 0x000fc600030e062dULL,
0x00000000101f7faeULL, 0x0003e8000b901c48ULL, 0x0000000012217faeULL, 0x0003e8000b901c48ULL,
0x0000000014237faeULL, 0x0003e8000b901c48ULL, 0x0000000016257faeULL, 0x0003e8000b901c48ULL,
0x0000000018277faeULL, 0x0003e8000b901c48ULL, 0x000000001a297faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x00f60400ff077984ULL, 0x000e620000000800ULL, 0x0000000b06637224ULL, 0x000fc400078e02ffULL,
0x0000000164737824ULL, 0x000fe400078e0a69ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x8000000007ff7812ULL, 0x002fe20007804809ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620063627625ULL, 0x000fe200078e0062ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x000000060c0f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0dULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011407ULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000204047819ULL, 0x000fc80000001207ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002000047824ULL, 0x002fca00078e0207ULL,
0x00000003ff067819ULL, 0x000fc80000011604ULL, 0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000000f04067812ULL, 0x000fc600078ec0ffULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x0000001006097824ULL, 0x040fe400078e00ffULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f07047812ULL, 0x040fe400078ec0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0x000000f009047812ULL, 0x000fe400078ee204ULL, 0x0000000f07077812ULL, 0x000fc600078ec0ffULL,
0x0000000004107984ULL, 0x000e62000000cc00ULL, 0x000000f006077812ULL, 0x000fca00078ee207ULL,
0x00000000070c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001404007388ULL, 0x0003e8000000cc00ULL,
0x0000001007007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x002fc80000015200ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6800720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00006a0005727a24ULL, 0x000fe200078e02ffULL,
0x3db504f361617820ULL, 0x010fe20000410000ULL, 0x000000020b707824ULL, 0x000fe200078e00ffULL,
0x0000f68800747811ULL, 0x040fe200078e18ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e00ffULL,
0xffffffff696e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x00000009696f7810ULL, 0x000fe40007ffe0ffULL, 0x0000f60800777811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x01cfc4000001ff00ULL, 0x000000010600780cULL, 0x000fe20003f25270ULL,
0x00000c2000007945ULL, 0x000fe20003800000ULL, 0x000000015e087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e0006ULL, 0x00000001060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000007103097224ULL, 0x010fc600078e02ffULL, 0x000000020b00780cULL, 0x000fe20003f06070ULL,
0x000000ffff067224ULL, 0x000fc800078e000bULL, 0x000000ffff081224ULL, 0x000fc800078e025eULL,
0x00000100083c7824ULL, 0x040fe200078e0275ULL, 0x0000000108057810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0b087207ULL, 0x000fe40000800000ULL, 0x000000680500720cULL, 0x000fe40003f46070ULL,
0x000000403c1d7812ULL, 0x020fe400078ec0ffULL, 0x0000000107057812ULL, 0x000fc600078e0cffULL,
0x000000016c1d7824ULL, 0x000fcc00078e021dULL, 0x000005f00000a947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x002fe200078e00ffULL, 0x00000002ff1e7819ULL, 0x000fe20000011604ULL,
0x00000002001c7824ULL, 0x000fe200078e0205ULL, 0x0000003c640b7217ULL, 0x000fe40007800000ULL,
0x000000300c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000011e117824ULL, 0x040fe200078e021dULL,
0x000000101e3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b3c7824ULL, 0x000fe200078e0a3cULL,
0x000000181e407810ULL, 0x000fe20007ffe0ffULL, 0x00000040080c7824ULL, 0x000fe200078e020dULL,
0x00006400090b7a11ULL, 0x040fe200078238ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000000081e1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013e177824ULL, 0x000fe200078e021dULL,
0x0000650009097a11ULL, 0x000fe200008f3cffULL, 0x0000008011107825ULL, 0x000fe200078e000cULL,
0x000000201e427810ULL, 0x000fc40007ffe0ffULL, 0x000010001c1c7811ULL, 0x000fe200078e60ffULL,
0x0000008017167825ULL, 0x000fe200078e000cULL, 0x0000000b10147210ULL, 0x080fe40007f3e0ffULL,
0x0000000404107211ULL, 0x000fe200078fe8ffULL, 0x00000001400f7824ULL, 0x100fe200078e021dULL,
0x0000000b16167210ULL, 0x000fe20007f7e0ffULL, 0x000000011f137824ULL, 0x000fe200078e021dULL,
0x0000000310437812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x000000381e457810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc433d7812ULL, 0x000fe200078ef804ULL,
0x0000008013127825ULL, 0x000fe200078e000cULL, 0x0000003c4000720cULL, 0x000fc60003fa6070ULL,
0x0000000111157824ULL, 0x100fe200008e0609ULL, 0x0000000b0e0e7210ULL, 0x080fe20007f3e0ffULL,
0x0000000117177824ULL, 0x100fe200018e0609ULL, 0x0000003c3e00720cULL, 0x0c0fe20003f66070ULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000b12127210ULL, 0x000fe20007f5e0ffULL,
0x000000010f0f7824ULL, 0x000fe200008e0609ULL, 0x0000003c1e00720cULL, 0x080fe20003f26070ULL,
0x000000041f447824ULL, 0x000fe200078e00ffULL, 0xfffffffc3e417812ULL, 0x000fe200078ee243ULL,
0x0000000113137824ULL, 0x000fe200010e0609ULL, 0x0000003c1f00720cULL, 0x000fe20003f46070ULL,
0x0000000142117824ULL, 0x000fe200078e021dULL, 0x000000281e3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000103d3d7824ULL, 0x000fe200078e021cULL, 0xfffffffc443f7812ULL, 0x000fe200078ee243ULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0x000000301e447810ULL, 0x000fc60007ffe0ffULL,
0x000000013e1f7824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000c901c48ULL, 0x000000103f3f7824ULL, 0x000fe200078e021cULL,
0x0000000b10107210ULL, 0x000fe20007f9e0ffULL, 0x000000801f1e7825ULL, 0x000fe200078e000cULL,
0x0000003c4500720cULL, 0x080fe40003f26070ULL, 0x00000000123f7faeULL, 0x0005e2000d101c48ULL,
0x0000001041417824ULL, 0x000fe200078e021cULL, 0x0000003c4400720cULL, 0x080fe20003f46070ULL,
0x0000000111117824ULL, 0x000fe200020e0609ULL, 0x0000003c4200720cULL, 0x080fe20003f86070ULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000000016417faeULL, 0x0007e2000d901c48ULL,
0x0000000144157824ULL, 0x102fe200078e021dULL, 0x0000003c3e00720cULL, 0x000fe20003f66070ULL,
0x00000001451d7824ULL, 0x000fc400078e021dULL, 0x0000008015147825ULL, 0x000fe200078e000cULL,
0x0000000b1e127210ULL, 0x004fc60007fde0ffULL, 0x0000000442427824ULL, 0x000fe400078e00ffULL,
0x000000011f137824ULL, 0x000fe200030e0609ULL, 0x0000000b14147210ULL, 0x080fe20007fde0ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc40177812ULL, 0x008fe200078ee243ULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x000000801d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc421d7812ULL, 0x100fe400078ee243ULL, 0xfffffffc3e1f7812ULL, 0x100fe200078ee243ULL,
0x0000000445167824ULL, 0x000fe200078e00ffULL, 0xfffffffc443d7812ULL, 0x000fe200078ee243ULL,
0x0000000115157824ULL, 0x000fe200030e0609ULL, 0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e021cULL, 0xfffffffc16437812ULL, 0x000fe200078ee243ULL,
0x000000101d1d7824ULL, 0x000fc400078e021cULL, 0x000000101f0b7824ULL, 0x100fe200078e021cULL,
0x000000000e177faeULL, 0x0003e2000e901c48ULL, 0x000000103d1f7824ULL, 0x100fe400078e021cULL,
0x00000010433d7824ULL, 0x000fe200078e021cULL, 0x00000000101d7faeULL, 0x0003e2000e101c48ULL,
0x000000010d0d7824ULL, 0x000fc600030e0609ULL, 0x00000000120b7faeULL, 0x0003e8000d901c48ULL,
0x00000000141f7faeULL, 0x0003e8000d101c48ULL, 0x000000000c3d7faeULL, 0x0003e2000c901c48ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x00000004040c7211ULL, 0x002fe200078fe8ffULL,
0x00000002000d7824ULL, 0x000fe200078e0205ULL, 0x00000008040e7811ULL, 0x040fe200078ff0ffULL,
0x00000010040b7824ULL, 0x040fe200078e00ffULL, 0x0000001004107811ULL, 0x000fc400078ff0ffULL,
0x0000001804127811ULL, 0x000fe200078ff0ffULL, 0x000000010e137824ULL, 0x100fe200078e021dULL,
0x0000002004147811ULL, 0x000fe200078ff0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000002804167811ULL, 0x000fe200078ff0ffULL, 0x0000000110157824ULL, 0x100fe200078e021dULL,
0x00000030041c7811ULL, 0x000fe200078ff0ffULL, 0x0000000112177824ULL, 0x100fe200078e021dULL,
0x00000038041e7811ULL, 0x000fe200078ff0ffULL, 0x00000001161f7824ULL, 0x100fe200078e021dULL,
0x000000030c0f7812ULL, 0x000fe200078ec0ffULL, 0x000000011c457824ULL, 0x100fe200078e021dULL,
0x000010000d0c7811ULL, 0x000fe200078e60ffULL, 0x00000001140d7824ULL, 0x000fe200078e021dULL,
0x000000300b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e3d7812ULL, 0x100fe200078ee20fULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000001d04117211ULL, 0x000fe200078ff0ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc103f7812ULL, 0x100fe200078ee20fULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0xfffffffc12417812ULL, 0x100fe200078ee20fULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14437812ULL, 0x100fe200078ee20fULL, 0x000000041e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16477812ULL, 0x000fe200078ee20fULL, 0x00000040080e7824ULL, 0x000fe200078e020bULL,
0xfffffffc1c4b7812ULL, 0x100fe200078ee20fULL, 0x000000103d0b7824ULL, 0x100fe200078e020cULL,
0xfffffffc3c4d7812ULL, 0x000fe200078ee20fULL, 0x000000103f3d7824ULL, 0x000fe200078e020cULL,
0x0ffffffc0f0f7812ULL, 0x000fe200078ef804ULL, 0x00000010413f7824ULL, 0x000fc400078e020cULL,
0x0000001043417824ULL, 0x100fe400078e020cULL, 0x000000100f4f7824ULL, 0x100fe400078e020cULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x0000001047437824ULL, 0x100fe400078e020cULL,
0x000000104b477824ULL, 0x100fe400078e020cULL, 0x000000104d4b7824ULL, 0x000fe200078e020cULL,
0x00006400094d7a11ULL, 0x000fe200078238ffULL, 0x0000008011107825ULL, 0x000fc600078e000eULL,
0x0000650009097a11ULL, 0x000fe200008f3cffULL, 0x0000008013127825ULL, 0x000fe200078e000eULL,
0x0000004d10107210ULL, 0x000fc60007f3e0ffULL, 0x0000008015147825ULL, 0x000fe200078e000eULL,
0x0000004d12127210ULL, 0x000fc60007f5e0ffULL, 0x0000008017167825ULL, 0x000fe200078e000eULL,
0x0000004d14147210ULL, 0x000fc60007f7e0ffULL, 0x000000011e497824ULL, 0x000fe200078e021dULL,
0x0000004d16167210ULL, 0x000fe20007f9e0ffULL, 0x000000800d1c7825ULL, 0x000fc800078e000eULL,
0x000000801f1e7825ULL, 0x000fc800078e000eULL, 0x00000080450c7825ULL, 0x000fc800078e000eULL,
0x00000080490e7825ULL, 0x000fc800078e000eULL, 0x0000000111117824ULL, 0x100fe200008e0609ULL,
0x0000004d1c1c7210ULL, 0x080fe20007f3e0ffULL, 0x0000000113137824ULL, 0x100fe200010e0609ULL,
0x0000004d1e1e7210ULL, 0x080fe20007f5e0ffULL, 0x0000000115157824ULL, 0x100fe200018e0609ULL,
0x0000004d0c0c7210ULL, 0x080fe20007f7e0ffULL, 0x0000000117177824ULL, 0x100fe200020e0609ULL,
0x0000004d0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000011d1d7824ULL, 0x100fe200008e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000104f7faeULL, 0x0003e2000b901c48ULL,
0x000000011f1f7824ULL, 0x000fc400010e0609ULL, 0x000000010d0d7824ULL, 0x100fe200018e0609ULL,
0x00000000120b7faeULL, 0x0003e2000b901c48ULL, 0x000000010f0f7824ULL, 0x000fc600020e0609ULL,
0x00000000143d7faeULL, 0x0003e8000b901c48ULL, 0x00000000163f7faeULL, 0x0003e8000b901c48ULL,
0x000000001c417faeULL, 0x0003e8000b901c48ULL, 0x000000001e437faeULL, 0x0003e8000b901c48ULL,
0x000000000c477faeULL, 0x0003e8000b901c48ULL, 0x000000000e4b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010800780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000202027810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000006b0200720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000272087824ULL, 0x000fe400078e0202ULL, 0x00000004ff097424ULL, 0x000fc800078e00ffULL,
0x0000660008087625ULL, 0x000fca00078e0009ULL, 0x0000000808037981ULL, 0x000524000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002004097810ULL, 0x004fe20007ffe0ffULL, 0x0000000200087824ULL, 0x000fe200078e0207ULL,
0xfffffff8040b7812ULL, 0x042fe400078ec0ffULL, 0xfffffff809077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000007040d7812ULL, 0x000fe400078ec0ffULL,
0x000000070b0b7812ULL, 0x100fe400078ef804ULL, 0x00000007070c7812ULL, 0x000fc400078ef804ULL,
0x0000100008077811ULL, 0x000fe400078e60ffULL, 0x000000080d087812ULL, 0x000fe400078ef804ULL,
0x00000001ff607819ULL, 0x000fe4000001160bULL, 0x00000001ff5f7819ULL, 0x000fe2000001160cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000001600d7824ULL, 0x000fe200078e0209ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000040b0e7824ULL, 0x000fe400078e00ffULL,
0x000000040c147824ULL, 0x000fc400078e00ffULL, 0x000000040a6a7824ULL, 0x000fe200078e0209ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee20dULL, 0x000000015f0d7824ULL, 0x000fe400078e0209ULL,
0x000000026a6a7824ULL, 0x000fe400078e00ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0207ULL,
0xfffffffc14147812ULL, 0x000fc800078ee20dULL, 0x000000000e10783bULL, 0x020e620000000200ULL,
0x0000001014147824ULL, 0x000fcc00078e0207ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00010000120f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011410ULL,
0x00010000100d7824ULL, 0x040fe200078e00ffULL, 0x0000888010427816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x00010000110e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011412ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00008880124a7816ULL, 0x040fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000000f006d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff537819ULL, 0x004fe40000011414ULL,
0x0000888014527816ULL, 0x040fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011411ULL,
0x00008880114e7816ULL, 0x040fe200000000ffULL, 0x0000001000787306ULL, 0x0004e20000200c00ULL,
0x00010000140f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011415ULL,
0x0000010014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011416ULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fc4000001140fULL,
0x00000012004b7306ULL, 0x0003e20000200c00ULL, 0x0000000109107810ULL, 0x004fe40007ffe0ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880155b7816ULL, 0x000fe200000000ffULL, 0x0000000f00657306ULL, 0x0005e20000200c00ULL,
0x000000040b127824ULL, 0x002fe200078e00ffULL, 0x0000888016587816ULL, 0x000fc400000000ffULL,
0x00000018ff507819ULL, 0x000fe40000011413ULL, 0x00008880134c7816ULL, 0x000fe400000000ffULL,
0x0000000e00547306ULL, 0x0003e20000200c00ULL, 0x00000001600f7824ULL, 0x104fe200078e0210ULL,
0x00000018ff457819ULL, 0x000fe20000011417ULL, 0x000000015f107824ULL, 0x000fe200078e0210ULL,
0x0000888017467816ULL, 0x000fe400000000ffULL, 0xfffffffc12127812ULL, 0x000fe200078ee20fULL,
0x00010000160f7824ULL, 0x040fe200078e00ffULL, 0x0000001400517306ULL, 0x0005e20000200c00ULL,
0x00010000130e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000001012127824ULL, 0x000fe200078e0207ULL, 0x0000000f00597306ULL, 0x0003e20000200c00ULL,
0x0000001008147824ULL, 0x004fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x00000000121c783bULL, 0x000ea20000000200ULL,
0x0000541078437816ULL, 0x008fe40000000043ULL, 0x0000000e00677306ULL, 0x0007e20000200c00ULL,
0x0000006a040f7211ULL, 0x002fe400078fe0ffULL, 0x0000000209097810ULL, 0x000fc60007ffe0ffULL,
0x00000001080f7824ULL, 0x000fe200078e020fULL, 0x000000040900780cULL, 0x000fe20003f25270ULL,
0x00000011004f7306ULL, 0x0003e20000200c00ULL, 0x00010000150e7824ULL, 0x048fe400078e00ffULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0xfffffff0140f7812ULL, 0x000fe400078ee20fULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000000040c117824ULL, 0x002fe200078e00ffULL, 0x0000000e005d7306ULL, 0x0003e20000200c00ULL,
0x000000100f0f7824ULL, 0x000fc600078e00ffULL, 0xfffffffc11107812ULL, 0x000fc800078ee210ULL,
0x00000015005c7306ULL, 0x000fe20000200c00ULL, 0x00010000170e7824ULL, 0x042fe400078e00ffULL,
0x0000010017177824ULL, 0x000fe400078e00ffULL, 0x0000001010107824ULL, 0x000fe200078e0207ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000001600577306ULL, 0x0003e20000200c00ULL,
0x00000018ff487819ULL, 0x000fe40000011417ULL, 0x00000018ff407819ULL, 0x004fc4000001141cULL,
0x000088801c497816ULL, 0x000fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001141dULL,
0x0000001300667306ULL, 0x0005e20000200c00ULL, 0x000000000f14783bULL, 0x002e620000000200ULL,
0x00000018ff3d7819ULL, 0x000fe4000001141fULL, 0x00000018ff3e7819ULL, 0x000fc8000001141eULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000001010783bULL, 0x004eae0000000200ULL,
0x0000000d000d7306ULL, 0x000ef00000200c00ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000541042427816ULL, 0x008fce000000000dULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x000000421438723cULL, 0x002b6e0000001838ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x000100001c427824ULL, 0x060fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x004fe20000011411ULL,
0x000001001c1c7824ULL, 0x000fca00078e00ffULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000054104f437816ULL, 0x000fe20000000041ULL, 0x000100001d417824ULL, 0x040fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000088801d4f7816ULL, 0x040fe200000000ffULL, 0x0000004d000f7306ULL, 0x000fe20000200c00ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc40000011410ULL,
0x00000018ff0d7819ULL, 0x000fe40000011413ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000042004d7306ULL, 0x0007f00000200c00ULL, 0x0000001d00557306ULL, 0x0003e20000200c00ULL,
0x000054104e427816ULL, 0x008fc40000000054ULL, 0x00000018ff547819ULL, 0x000fe40000011441ULL,
0x000088801e417816ULL, 0x000fc600000000ffULL, 0x0000001c004e7306ULL, 0x0007e20000200c00ULL,
0x000000421434723cULL, 0x000be20000001834ULL, 0x000054104b1d7816ULL, 0x002fcc0000000044ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000100001e1c7824ULL, 0x048fe200078e00ffULL,
0x000088801f437816ULL, 0x020fe200000000ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000001c00427306ULL, 0x0005f00000200c00ULL,
0x0000005300537306ULL, 0x000ee20000200c00ULL, 0x000054104a1c7816ULL, 0x004fce000000006dULL,
0x0000001c1430723cULL, 0x000b620000001830ULL, 0x0000005200527306ULL, 0x000eac0000200c00ULL,
0x000100001f1d7824ULL, 0x060fe200078e00ffULL, 0x000054104c1c7816ULL, 0x002fe20000000067ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000001e00447306ULL, 0x0003e20000200c00ULL,
0x0000541051537816ULL, 0x008fe20000000053ULL, 0x0001000010677824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001141dULL, 0x000000026a1d7810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001141fULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000001d041f7211ULL, 0x000fe400078fe0ffULL, 0x00005410661d7816ULL, 0x000fe20000000050ULL,
0x0000001008667824ULL, 0x000fe200078e00ffULL, 0x00008880101e7816ULL, 0x002fe200000000ffULL,
0x00000001081f7824ULL, 0x000fe200078e021fULL, 0x0000541052527816ULL, 0x004fe20000000065ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000001c142c723cULL, 0x000b62000000182cULL, 0xfffffff0661f7812ULL, 0x000fe200078ee21fULL,
0x0000010010507824ULL, 0x000fe200078e00ffULL, 0x0000888011657816ULL, 0x040fe200000000ffULL,
0x0001000011667824ULL, 0x000fc400078e00ffULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001e004c7306ULL, 0x0005e20000200c00ULL, 0x000000521428723cULL, 0x000b620000001828ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff667819ULL, 0x000fc80000011466ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000001f1c783bULL, 0x024ea20000000200ULL,
0x000054105b527816ULL, 0x002fe4000000005dULL, 0x000054105c537816ULL, 0x000fe4000000005aULL,
0x00008880125b7816ULL, 0x000fe400000000ffULL, 0x0000000e00477306ULL, 0x0002e60000200c00ULL,
0x000000521424723cULL, 0x000b6a0000001824ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x00000018ff0e7819ULL, 0x002fce0000011412ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541046467816ULL, 0x008fce0000000047ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x0000541057537816ULL, 0x020fce0000000056ULL, 0x0000004800487306ULL, 0x000ef00000200c00ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000541058527816ULL, 0x002fce0000000059ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000541048477816ULL, 0x008fe20000000045ULL,
0x000000521420723cULL, 0x040b6c0000001820ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x0001000012537824ULL, 0x020fe200078e00ffULL, 0x000000461418723cULL, 0x000b620000001818ULL,
0x000000ffff527224ULL, 0x000fc600078e005bULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000010012167824ULL, 0x020fe200078e00ffULL,
0x0000541049147816ULL, 0x002fe4000000004dULL, 0x000054104e157816ULL, 0x000fe40000000040ULL,
0x00000018ff177819ULL, 0x000fe40000011416ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000541055557816ULL, 0x008fe2000000003fULL, 0x00010000133f7824ULL, 0x040fe200078e00ffULL,
0x0000888013167816ULL, 0x040fe200000000ffULL, 0x000000141c38723cULL, 0x004b620000001838ULL,
0x0000010013137824ULL, 0x000fc400078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000006700107306ULL, 0x0004e40000200c00ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000541044157816ULL, 0x020fe4000000003eULL, 0x0000541041147816ULL, 0x002fe20000000042ULL,
0x0000010011677824ULL, 0x004fe200078e00ffULL, 0x0000000e000e7306ULL, 0x000fe80000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe20000011467ULL, 0x000000141c30723cULL, 0x000b620000001830ULL,
0x000054104c4c7816ULL, 0x008fc40000000010ULL, 0x0000006500517306ULL, 0x000ff00000200c00ULL,
0x0000006600117306ULL, 0x000e700000200c00ULL, 0x0000001700177306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541051107816ULL, 0x002fce0000000011ULL,
0x0000003c003c7306ULL, 0x000ff00000200c00ULL, 0x0000000d000d7306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000005400547306ULL, 0x000e700000200c00ULL,
0x0000004300437306ULL, 0x000ff00000200c00ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000054104f547816ULL, 0x002fce0000000054ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000541c34723cULL, 0x000b6e0000001834ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x00005410434a7816ULL, 0x004fce000000004aULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000054104b4b7816ULL, 0x002fce000000003dULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00005410504d7816ULL, 0x008fe2000000003cULL, 0x0000004a1c2c723cULL, 0x040b6c000000182cULL,
0x0000005300127306ULL, 0x000e620000200c00ULL, 0x000054105a117816ULL, 0x004fe2000000000fULL,
0x0000004c1c28723cULL, 0x040b6c0000001828ULL, 0x0000001600167306ULL, 0x000fe40000200c00ULL,
0x000000101c24723cULL, 0x000b6c0000001824ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541052127816ULL, 0x002fce0000000012ULL, 0x0000001300147306ULL, 0x0202e20000200c00ULL,
0x0000541016167816ULL, 0x004fe4000000003fULL, 0x0000541017137816ULL, 0x002fe4000000000eULL,
0x0000541014177816ULL, 0x008fca000000000dULL, 0x000000121c20723cULL, 0x040b700000001820ULL,
0x000000161c18723cULL, 0x000b620000001818ULL, 0xfffff07000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe25000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006134347220ULL, 0x080fe20000410000ULL,
0x0000006130307220ULL, 0x080fe20000410000ULL, 0x0000006131317220ULL, 0x080fe20000410000ULL,
0x000000612c2c7220ULL, 0x080fe20000410000ULL, 0x000000612d2d7220ULL, 0x080fe20000410000ULL,
0x0000006139397220ULL, 0x080fe20000410000ULL, 0x0000006129067220ULL, 0x080fe20000410000ULL,
0x0000006124247220ULL, 0x080fe20000410000ULL, 0x0000006125257220ULL, 0x080fe20000410000ULL,
0x0000006120207220ULL, 0x0a0fe20000410000ULL, 0x0000006132087220ULL, 0x080fe20000410000ULL,
0x000000612f0a7220ULL, 0x080fe20000410000ULL, 0x000000612a0b7220ULL, 0x080fe20000410000ULL,
0x000000612b147220ULL, 0x080fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e0034ULL,
0x000000612e097220ULL, 0x080fe20000410000ULL, 0x0000006128327220ULL, 0x080fe20000410000ULL,
0x00000061261c7220ULL, 0x080fe20000410000ULL, 0x00000061271d7220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0030ULL, 0x0000006138157220ULL, 0x080fe20000410000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0031ULL, 0x000000613a1e7220ULL, 0x080fe20000410000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x000000613b167220ULL, 0x080fe20000410000ULL,
0x000000ffff347224ULL, 0x000fe200078e002dULL, 0x0000006135177220ULL, 0x080fe20000410000ULL,
0x00000061361f7220ULL, 0x080fe20000410000ULL, 0x0000006137377220ULL, 0x080fe20000410000ULL,
0x0000006133337220ULL, 0x080fe20000410000ULL, 0x00000061212e7220ULL, 0x080fe20000410000ULL,
0x00000061220c7220ULL, 0x080fe20000410000ULL, 0x00000061230d7220ULL, 0x080fe20000410000ULL,
0x0000006118267220ULL, 0x080fe20000410000ULL, 0x0000006119277220ULL, 0x080fe20000410000ULL,
0x000000611a1a7220ULL, 0x080fe20000410000ULL, 0x000000611b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff287224ULL, 0x000fc400078e0039ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0024ULL, 0x000000ffff317224ULL, 0x000fe400078e0025ULL,
0x000000ffff307224ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff217224ULL, 0x000fe400078e0033ULL,
0x000000ffff237224ULL, 0x000fc400078e0037ULL, 0x000000ffff227224ULL, 0x000fe400078e0008ULL,
0x000000ffff247224ULL, 0x000fe400078e0009ULL, 0x000000ffff337224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff187224ULL, 0x000fe400078e000cULL,
0x000000ffff197224ULL, 0x000fc400078e000dULL, 0x0000000000087805ULL, 0x002fca0000015200ULL,
0x00000400740b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400740b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000404137824ULL, 0x000fe200078e00ffULL, 0x000000735e00720cULL, 0x000fc80003f06070ULL,
0xfffffff013077812ULL, 0x000fca00078ec0ffULL, 0x0000008000207824ULL, 0x000fca00078e0207ULL,
0x00f4000020087984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000e7b06ULL, 0x000ee20000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe20003f85070ULL, 0x0000000204357824ULL, 0x000fe200078e00ffULL,
0x00005a00ff107a12ULL, 0x000fc800078e33ffULL, 0x0000000635357812ULL, 0x000fca00078ec0ffULL,
0x0000000135377824ULL, 0x000fe200078e0269ULL, 0x0000000e000e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0e077810ULL, 0x008fcc0007ffe0ffULL, 0x0000000700077305ULL, 0x000ee4000021f000ULL,
0x000000ffff0d7224ULL, 0x008fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d070f7227ULL, 0x000fe200078e0006ULL, 0x0000007604067211ULL, 0x000fca00078ff0ffULL,
0x000000060f0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a0cULL,
0x00005a000d0d7a24ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fc80007ffe0ffULL,
0x00005a000d007a0cULL, 0x000fe20003f06070ULL, 0x000000060f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a0fULL, 0x00005a0007067a24ULL, 0x000fe400078e0206ULL,
0x000001005e077824ULL, 0x000fe400078e0275ULL, 0x80005a000d0d0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x00005a000d007a0cULL, 0x000fe40003f26070ULL,
0x0000000764127217ULL, 0x000fc40007800000ULL, 0x000000010c0c0810ULL, 0x000fc60007ffe0ffULL,
0x0000000112127824ULL, 0x000fe400078e0a07ULL, 0x000000016f077824ULL, 0x000fe400078e0235ULL,
0x80005a0006062a10ULL, 0x000fe40007ffe0ffULL, 0x00000001070d7824ULL, 0x040fe200078e0a12ULL,
0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL, 0x000000120700720cULL, 0x000fe40003f66070ULL,
0x00005a0006007a0cULL, 0x000fc40003f06070ULL, 0x0000000c10077207ULL, 0x000fe40006000000ULL,
0x0000000d6e067217ULL, 0x040fe20003800000ULL, 0x00000001370d7824ULL, 0x040fe200078e0a12ULL,
0x000000076e077217ULL, 0x000fe40003800000ULL, 0x00000004ff067819ULL, 0x000fe40000011606ULL,
0x000000123700720cULL, 0x000fe20003f26070ULL, 0x00000007704b7224ULL, 0x000fe200078e02ffULL,
0x0000000d6e0d7217ULL, 0x000fc40003800000ULL, 0x000000ff060e7207ULL, 0x000fe40001800000ULL,
0x000000010f0f2810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0d487207ULL, 0x000fe20000800000ULL,
0x000000014b077824ULL, 0x000fe200078e020eULL, 0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL,
0x0000004b480d7211ULL, 0x000fe200078fe0ffULL, 0x0000000207067825ULL, 0x000fe200078e0062ULL,
0x0000000f100f7207ULL, 0x000fc40006000000ULL, 0x0000001035367812ULL, 0x000fe200078efcffULL,
0x000000020d0c7825ULL, 0x000fe200078e0062ULL, 0x0000000f6e0f7217ULL, 0x000fe20003800000ULL,
0x0000000806497981ULL, 0x0046a8000c1e9500ULL, 0x000000080c4c7981ULL, 0x0002a2000c1e9500ULL,
0x0000000f704d7224ULL, 0x000fe400078e02ffULL, 0x0000000136397824ULL, 0x000fc400078e0269ULL,
0x000000010e0f7824ULL, 0x000fe200078e024dULL, 0x0000002035387812ULL, 0x000fe200078efcffULL,
0x000000016f077824ULL, 0x008fe200078e0236ULL, 0x0000004d48117211ULL, 0x000fe200078fe0ffULL,
0x000000020f0e7825ULL, 0x000fc800078e0062ULL, 0x00000001070d7824ULL, 0x142fe200078e0a12ULL,
0x000000120700720cULL, 0x080fe20003f26070ULL, 0x0000000139077824ULL, 0x040fe200078e0a12ULL,
0x000000080e467981ULL, 0x0002e2000c1e9500ULL, 0x000000123900720cULL, 0x000fe20003f06070ULL,
0x000000016f3f7824ULL, 0x000fe200078e0238ULL, 0x0000000d6e0d7217ULL, 0x000fe20003800000ULL,
0x00000001383d7824ULL, 0x000fe400078e0269ULL, 0x0000000211107825ULL, 0x000fe200078e0062ULL,
0x00000004ff0d7819ULL, 0x000fc4000001160dULL, 0x000000076e077217ULL, 0x040fe40003800000ULL,
0x000000ff0d0e7207ULL, 0x002fe20000800000ULL, 0x000000013f417824ULL, 0x000fe200078e0a12ULL,
0x000000ff073a7207ULL, 0x000fe20000000000ULL, 0x0000000810517981ULL, 0x0002e4000c1e9500ULL,
0x000000014b077824ULL, 0x000fe200078e020eULL, 0x000000416e407217ULL, 0x000fc60003800000ULL,
0x0000000207067825ULL, 0x000fe200078e0062ULL, 0x000000123f00720cULL, 0x080fe40003f26070ULL,
0x00000004ff407819ULL, 0x000fe40000011640ULL, 0x00000008063b7981ULL, 0x0002e2000c1e9500ULL,
0x000000123d00720cULL, 0x040fe40003f06070ULL, 0x000000ff40427207ULL, 0x000fe20000800000ULL,
0x000000013d077824ULL, 0x002fe200078e0a12ULL, 0x00000030353f7812ULL, 0x000fc800078efcffULL,
0x000000076e077217ULL, 0x000fe20003800000ULL, 0x000000010e0f7824ULL, 0x000fe200078e024dULL,
0x0000004b3a0d7211ULL, 0x040fe400078fe0ffULL, 0x0000004d3a117211ULL, 0x000fe400078fe0ffULL,
0x000000ff07447207ULL, 0x000fe20000000000ULL, 0x000000014b077824ULL, 0x000fe400078e0242ULL,
0x000000016f4f7824ULL, 0x000fe400078e023fULL, 0x000000020d0c7825ULL, 0x000fc800078e0062ULL,
0x000000020f0e7825ULL, 0x100fe200078e0062ULL, 0x000000080c3c7981ULL, 0x0002e6000c1e9500ULL,
0x0000000211107825ULL, 0x100fe200078e0062ULL, 0x000000080e3e7981ULL, 0x0002e6000c1e9500ULL,
0x0000000207067825ULL, 0x000fe200078e0062ULL, 0x0000000810417981ULL, 0x0002e6000c1e9500ULL,
0x000000014f477824ULL, 0x000fe200078e0a12ULL, 0x0000000806407981ULL, 0x0002e2000c1e9500ULL,
0x000000013f457824ULL, 0x000fe200078e0269ULL, 0x0000004b440d7211ULL, 0x002fc400078fe0ffULL,
0x000000476e4a7217ULL, 0x000fe20003800000ULL, 0x00000001420f7824ULL, 0x000fe200078e024dULL,
0x0000004d44117211ULL, 0x000fe200078fe0ffULL, 0x0000000145077824ULL, 0x000fe200078e0a12ULL,
0x000000124f00720cULL, 0x080fe40003f26070ULL, 0x00000004ff4a7819ULL, 0x000fe2000001164aULL,
0x000000020d0c7825ULL, 0x100fe200078e0062ULL, 0x000000124500720cULL, 0x000fe40003f06070ULL,
0x000000076e077217ULL, 0x000fe20003800000ULL, 0x000000020f0e7825ULL, 0x100fe200078e0062ULL,
0x000000ff4a4e7207ULL, 0x000fe20000800000ULL, 0x000000080c437981ULL, 0x0002e4000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0062ULL, 0x000000ff074a7207ULL, 0x000fe20000000000ULL,
0x000000080e427981ULL, 0x0002e8000c1e9500ULL, 0x0000000810477981ULL, 0x0002e2000c1e9500ULL,
0x000000014b077824ULL, 0x000fe200078e024eULL, 0x0000004b4a0d7211ULL, 0x002fc600078fe0ffULL,
0x0000000207067825ULL, 0x000fc800078e0062ULL, 0x000000020d0c7825ULL, 0x000fe400078e0062ULL,
0x0000000806067981ULL, 0x0002e2000c1e9500ULL, 0x0000004d4a0f7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014e117824ULL, 0x000fe400078e024dULL,
0x000000020f0e7825ULL, 0x000fc800078e0062ULL, 0x0000000211107825ULL, 0x000fe400078e0062ULL,
0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000810117981ULL, 0x0002e2000c1e9500ULL,
0xfffffff0484d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff487424ULL, 0x000fc800078e00ffULL,
0x00000001124e7824ULL, 0x000fc800078e024dULL, 0x0000000137537824ULL, 0x000fe200078e0a4eULL,
0x0000000935077812ULL, 0x002fc800078efcffULL, 0x0000005348537219ULL, 0x000fe200000006ffULL,
0x00000001070f7824ULL, 0x000fc800078e0269ULL, 0x000000010f597824ULL, 0x000fe200078e0a4eULL,
0x00000001354b7812ULL, 0x040fe400078efcffULL, 0x0000001835657812ULL, 0x000fe400078efcffULL,
0xfffffff03a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000005948597219ULL, 0x000fe200000006ffULL,
0x000000014b4f7824ULL, 0x100fe200078e0269ULL, 0x0000001135677812ULL, 0x000fe200078efcffULL,
0x0000000165797824ULL, 0x000fe200078e0269ULL, 0x00000019355f7812ULL, 0x000fe200078efcffULL,
0x00000001123a7824ULL, 0x000fc400078e023aULL, 0x000000014f557824ULL, 0x000fe400078e0a4eULL,
0x00000001677b7824ULL, 0x100fe400078e0269ULL, 0x000000015f6d7824ULL, 0x000fe400078e0269ULL,
0x0000000139107824ULL, 0x100fe400078e0a3aULL, 0x0000000179507824ULL, 0x100fe200078e0a3aULL,
0xfffffff044447812ULL, 0x000fe200078ec0ffULL, 0x000000017b0c7824ULL, 0x100fe200078e0a3aULL,
0x0000005548557219ULL, 0x040fe200000006ffULL, 0x000000016d667824ULL, 0x000fe200078e0a3aULL,
0x0000001048107219ULL, 0x000fc400000006ffULL, 0x00000050483a7219ULL, 0x000fe200000006ffULL,
0x0000000112447824ULL, 0x000fc800078e0244ULL, 0x000000013d547824ULL, 0x000fe200078e0a44ULL,
0x00000021355b7812ULL, 0x000fe400078efcffULL, 0xfffffff04a4a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c480c7219ULL, 0x040fe400000006ffULL, 0x0000006648507219ULL, 0x040fe400000006ffULL,
0x0000005448547219ULL, 0x000fe200000006ffULL, 0x000000015b5d7824ULL, 0x000fc400078e0269ULL,
0x00000001126a7824ULL, 0x000fe400078e024aULL, 0x000000015d567824ULL, 0x000fe400078e0a44ULL,
0x00000001455a7824ULL, 0x000fc600078e0a6aULL, 0x0000005648567219ULL, 0x040fe400000006ffULL,
0x0000005a485a7219ULL, 0x000fe400000006ffULL, 0x000054104c4c7816ULL, 0x004fe40000000049ULL,
0x0000000835497812ULL, 0x000fe400078efcffULL, 0x0000004c53ff7212ULL, 0x000fc6000780c0ffULL,
0x00000001494d7824ULL, 0x000fe200078e0269ULL, 0x000000123700720cULL, 0x000fc60000701470ULL,
0x000000014d577824ULL, 0x000fe200078e0a4eULL, 0x000000123500720cULL, 0x000fc800007a1070ULL,
0x0000005748577219ULL, 0x000fe400000006ffULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x0000541051467816ULL, 0x008fc80000000046ULL, 0x0000004653ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004657ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004659ff7212ULL, 0x000fe400078ac0ffULL,
0x000000123700720cULL, 0x080fe40001741470ULL, 0x000000124d00720cULL, 0x080fe400037c1470ULL,
0x000000120f00720cULL, 0x000fc40002fa1470ULL, 0x000000123500720cULL, 0x080fe40001741070ULL,
0x000000124900720cULL, 0x080fe400037c1070ULL, 0x000000120700720cULL, 0x000fe40002fa1070ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fc40002800000ULL, 0x0000004c55ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004c57ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004c59ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004655ff7212ULL, 0x000fe4000780c0ffULL, 0x000054103c3b7816ULL, 0x000fc8000000003bULL,
0x0000003b10ff7212ULL, 0x000fe4000784c0ffULL, 0x0000541041417816ULL, 0x000fc8000000003eULL,
0x0000004110ff7212ULL, 0x080fe400078cc0ffULL, 0x000000413aff7212ULL, 0x000fe400078ac0ffULL,
0x000000124f00720cULL, 0x0c0fe40000f21470ULL, 0x000000124f00720cULL, 0x080fe40000701470ULL,
0x000000124d00720cULL, 0x080fe40001f61470ULL, 0x000000120f00720cULL, 0x000fc40002781470ULL,
0x000000123900720cULL, 0x0c0fe40001741470ULL, 0x000000123900720cULL, 0x080fe400037c1470ULL,
0x000000127900720cULL, 0x080fe40002fa1470ULL, 0x0000002835597812ULL, 0x040fe400078efcffULL,
0x0000002935577812ULL, 0x000fe400078efcffULL, 0x000000124b00720cULL, 0x000fc40000f21070ULL,
0x000000124b00720cULL, 0x080fe40000701070ULL, 0x000000124900720cULL, 0x080fe40001f61070ULL,
0x000000120700720cULL, 0x080fe40002781070ULL, 0x000000123600720cULL, 0x0c0fe40001741070ULL,
0x000000123600720cULL, 0x080fe400037c1070ULL, 0x000000126500720cULL, 0x000fc40002fa1070ULL,
0x0000541043437816ULL, 0x000fe40000000040ULL, 0x0000541047477816ULL, 0x000fe20000000042ULL,
0x00000001597d7824ULL, 0x100fe200078e0269ULL, 0xff80000028287808ULL, 0x000fe20000800000ULL,
0x00000001574e7824ULL, 0x000fe200078e0269ULL, 0xff80000016167808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000017177808ULL, 0x000fc40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0x0000003b0cff7212ULL, 0x080fe4000782c0ffULL,
0x0000003b3aff7212ULL, 0x080fe4000780c0ffULL, 0x0000003b50ff7212ULL, 0x000fc4000786c0ffULL,
0x000000410cff7212ULL, 0x080fe4000788c0ffULL, 0x0000004150ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004354ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004754ff7212ULL, 0x000fe200078ac0ffULL,
0x000000017d607824ULL, 0x100fe200078e0a44ULL, 0x000000127b00720cULL, 0x0c0fe20000f21470ULL,
0x000000014e5c7824ULL, 0x000fe200078e0a44ULL, 0x000000127b00720cULL, 0x000fc40002781470ULL,
0x000000127900720cULL, 0x080fe40000701470ULL, 0x000000126d00720cULL, 0x0c0fe40001f61470ULL,
0x000000126d00720cULL, 0x080fe40001741470ULL, 0x000000123d00720cULL, 0x0c0fe400037c1470ULL,
0x000000123d00720cULL, 0x000fe40002fa1470ULL, 0x0000003135557812ULL, 0x000fc400078efcffULL,
0x0000003835537812ULL, 0x040fe400078efcffULL, 0x0000003935517812ULL, 0x000fe400078efcffULL,
0x000000126700720cULL, 0x0c0fe40000f21070ULL, 0x000000126700720cULL, 0x080fe40002781070ULL,
0x000000126500720cULL, 0x080fe40000701070ULL, 0x000000125f00720cULL, 0x000fc40001f61070ULL,
0x000000125f00720cULL, 0x080fe40001741070ULL, 0x000000123800720cULL, 0x0c0fe400037c1070ULL,
0x000000123800720cULL, 0x000fe40002fa1070ULL, 0x0000006048607219ULL, 0x040fe400000006ffULL,
0x0000005c485c7219ULL, 0x000fe400000006ffULL, 0x000054100d0d7816ULL, 0x000fe20000000006ULL,
0x00000001554c7824ULL, 0x100fe200078e0269ULL, 0xff8000002a2a7808ULL, 0x000fe20000800000ULL,
0x00000001534a7824ULL, 0x100fe200078e0269ULL, 0xff80000021217808ULL, 0x000fe20002000000ULL,
0x0000000151467824ULL, 0x000fe200078e0269ULL, 0xff8000002b2b7808ULL, 0x000fc40000000000ULL,
0xff80000034347808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x0000004356ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004360ff7212ULL, 0x000fc4000788c0ffULL,
0x000000435cff7212ULL, 0x000fe4000780c0ffULL, 0x0000004756ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004760ff7212ULL, 0x080fe4000784c0ffULL, 0x000000475cff7212ULL, 0x000fe400078cc0ffULL,
0x0000000d5aff7212ULL, 0x000fe200078ac0ffULL, 0x000000014c587824ULL, 0x100fe200078e0a6aULL,
0x000000125d00720cULL, 0x0c0fe20000f21470ULL, 0x000000014a527824ULL, 0x100fe200078e0a6aULL,
0x000000125d00720cULL, 0x080fe20001f61470ULL, 0x0000000146447824ULL, 0x000fe200078e0a6aULL,
0x000000127d00720cULL, 0x000fc40002781470ULL, 0x000000127d00720cULL, 0x080fe40001741470ULL,
0x000000124e00720cULL, 0x0c0fe40000701470ULL, 0x000000124e00720cULL, 0x080fe400037c1470ULL,
0x000000124500720cULL, 0x080fe40002fa1470ULL, 0x000000125b00720cULL, 0x0c0fe40000f21070ULL,
0x000000125b00720cULL, 0x000fc40001f61070ULL, 0x000000125900720cULL, 0x0c0fe40002781070ULL,
0x000000125900720cULL, 0x080fe40001741070ULL, 0x000000125700720cULL, 0x0c0fe40000701070ULL,
0x000000125700720cULL, 0x080fe400037c1070ULL, 0x000000123f00720cULL, 0x000fe40002fa1070ULL,
0x0000005848587219ULL, 0x000fc400000006ffULL, 0x0000005248527219ULL, 0x040fe400000006ffULL,
0x0000004448447219ULL, 0x000fe400000006ffULL, 0x000054100e117816ULL, 0x000fe40000000011ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fc40002000000ULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0x0000000d58ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000d52ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000d44ff7212ULL, 0x000fe4000788c0ffULL,
0x000000115aff7212ULL, 0x080fe4000784c0ffULL, 0x0000001158ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001152ff7212ULL, 0x080fe400078cc0ffULL, 0x0000001144ff7212ULL, 0x000fe400078ac0ffULL,
0x000000124500720cULL, 0x000fc40001741470ULL, 0x000000124c00720cULL, 0x0c0fe40000f21470ULL,
0x000000124c00720cULL, 0x080fe40000701470ULL, 0x000000124a00720cULL, 0x0c0fe40001f61470ULL,
0x000000124a00720cULL, 0x080fe400037c1470ULL, 0x000000124600720cULL, 0x0c0fe40002781470ULL,
0x000000124600720cULL, 0x000fc40002fa1470ULL, 0x000000123f00720cULL, 0x080fe40001741070ULL,
0x000000125500720cULL, 0x0c0fe40000f21070ULL, 0x000000125500720cULL, 0x080fe40000701070ULL,
0x000000125300720cULL, 0x0c0fe40001f61070ULL, 0x000000125300720cULL, 0x080fe400037c1070ULL,
0x000000125100720cULL, 0x000fc40002781070ULL, 0x000000125100720cULL, 0x000fe40002fa1070ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000019197808ULL, 0x000fc40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fc40002800000ULL, 0x000000150800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000001e0900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000815077208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fc40003f1e000ULL,
0x000000160900720bULL, 0x000fe40003f3e000ULL, 0x0000000728067208ULL, 0x000fe40004000000ULL,
0x0000000916087208ULL, 0x000fe40004800000ULL, 0x000000290600720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fe40003f3e000ULL, 0x0000000629067208ULL, 0x000fc40004000000ULL,
0x000000081f087208ULL, 0x000fe40004800000ULL, 0x000000170600720bULL, 0x000fe40003f1e000ULL,
0x000000230800720bULL, 0x000fe40003f3e000ULL, 0x0000000617067208ULL, 0x000fe40004000000ULL,
0x0000000823077208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fc40003f1e000ULL,
0x000000220700720bULL, 0x000fe40003f3e000ULL, 0x000000062f097208ULL, 0x000fe40004000000ULL,
0x0000000722067208ULL, 0x000fe40004800000ULL, 0x0000002a0900720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fe40003f3e000ULL, 0x000000092a087208ULL, 0x000fc40004000000ULL,
0x0000000621077208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fe40003f3e000ULL, 0x000000082b097208ULL, 0x000fe40004000000ULL,
0x0000000724067208ULL, 0x000fe40004800000ULL, 0x000000340900720bULL, 0x000fc40003f1e000ULL,
0x000000330600720bULL, 0x000fe40003f3e000ULL, 0x0000000934097208ULL, 0x000fe40004000000ULL,
0x0000000633067208ULL, 0x000fe40004800000ULL, 0x000000320900720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fe40003f3e000ULL, 0x0000000932097208ULL, 0x000fc40004000000ULL,
0x0000000625077208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x000000140700720bULL, 0x000fe40003f3e000ULL, 0x000000092c067208ULL, 0x000fe40004000000ULL,
0x0000000714077208ULL, 0x000fe40004800000ULL, 0x0000002d0600720bULL, 0x000fc40003f1e000ULL,
0x0000001c0700720bULL, 0x000fe40003f3e000ULL, 0x000000062d067208ULL, 0x000fe40004000000ULL,
0x000000071c087208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x0000000631077208ULL, 0x000fc40004000000ULL,
0x000000081d097208ULL, 0x000fe40004800000ULL, 0x000000300700720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x0000000730077208ULL, 0x000fe40004000000ULL,
0x0000000918067208ULL, 0x000fe40004800000ULL, 0x0000002e0700720bULL, 0x000fc40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x000000072e077208ULL, 0x000fe40004000000ULL,
0x0000000619097208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fe40003f3e000ULL, 0x0000000726067208ULL, 0x000fc40004000000ULL,
0x000000091a087208ULL, 0x000fe40004800000ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fe40003f3e000ULL, 0x00000006270c7208ULL, 0x000fe40004000000ULL,
0x000000081b0e7208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f000c067f89ULL, 0x0004e400000e0000ULL, 0x000000060c00720bULL, 0x008fc80003f1e000ULL,
0x0000000c060f7208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f000e067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000e6800000e0000ULL,
0x0c401f000b0c7f89ULL, 0x006e6800000e0000ULL, 0x0c201f000f107f89ULL, 0x000ea200000e0000ULL,
0x000000060e00720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x000fe40003f3e000ULL,
0x0000000e06087208ULL, 0x000fe40004000000ULL, 0x0000000a07097208ULL, 0x000fe40004800000ULL,
0x0000000c0b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f0008117f89ULL, 0x000e6600000e0000ULL,
0x0000000b0c067208ULL, 0x000fe20004000000ULL, 0x0c201f0009127f89ULL, 0x000ee200000e0000ULL,
0x000000100f00720bULL, 0x004fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0004a200000e0000ULL,
0x0000000f10107208ULL, 0x000fe40004000000ULL, 0x000000110800720bULL, 0x002fe40003f3e000ULL,
0x000000120900720bULL, 0x008fe40003f5e000ULL, 0x0000000811117208ULL, 0x000fe40004800000ULL,
0x0000000912127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10087820ULL, 0x004fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000304ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b2b0f7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2d2b7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b112d7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2f0b7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2f7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b312c7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010808ULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL, 0x00000028000a7308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001082dULL, 0x000000070600720bULL, 0x000fc40003f3e000ULL,
0x0000002900097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b32287823ULL, 0x004fce0000010808ULL,
0x00000017000c7308ULL, 0x002e620000000800ULL, 0x3fb8aa3b30297823ULL, 0x000fce0000010808ULL,
0x0000000b000d7308ULL, 0x000ff00000000800ULL, 0x0000002a000e7308ULL, 0x0004700000000800ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2a7823ULL, 0x004fe20000010808ULL,
0x000000150a08723eULL, 0x008fc400000000ffULL, 0x000000090c0a723eULL, 0x002fc800000000ffULL,
0x00000016000b7308ULL, 0x000e620000000800ULL, 0x0000000d0e0c723eULL, 0x000fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x00000023002e7308ULL, 0x0004e20000000800ULL,
0x0000001e0b09723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b141e7823ULL, 0x000fcc000001082dULL,
0x0000002200307308ULL, 0x0003e20000000800ULL, 0x3c003c00ff237424ULL, 0x004fe200078e00ffULL,
0x0000001f2e0b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff227424ULL, 0x002fca00078e00ffULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b181f7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1a2e7823ULL, 0x000fe2000001082dULL, 0x000000220814723cULL, 0x000f6a00000018ffULL,
0x0000003400347308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000eb00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000000f340e723eULL, 0x002fc400000000ffULL,
0x00000002ff347819ULL, 0x000fc80000011604ULL, 0x0000000234327810ULL, 0x040fe20007ffe0ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x00000030210d723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b19217823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1b2d7823ULL, 0x000fe2000001082dULL,
0x0000000834357824ULL, 0x040fe200078e00ffULL, 0x0000000134307810ULL, 0x040fe20007ffe0ffULL,
0x0000000834317824ULL, 0x040fe200078e00ffULL, 0x0000000834397810ULL, 0x000fe20007ffe0ffULL,
0x0000002800287308ULL, 0x000fe60000000800ULL, 0xfffffff831317812ULL, 0x000fc400078ee230ULL,
0x00000024330f723eULL, 0x002fc600000000ffULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000000834337824ULL, 0x000fc600078e00ffULL, 0x000000220c18723cULL, 0x020b640000001814ULL,
0xfffffff833337812ULL, 0x000fe400078ee232ULL, 0x0000002b002b7308ULL, 0x000fe60000000800ULL,
0x0000000834167824ULL, 0x060fe200078e00ffULL, 0x0000000334147810ULL, 0x000fc80007ffe0ffULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x0000000434157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff835357812ULL, 0x000fe400078ee214ULL, 0xfffffff816377812ULL, 0x000fe400078ee215ULL,
0x000000282f14723eULL, 0x002fe200000000ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000000834287824ULL, 0x040fe400078e00ffULL, 0x00000008342f7824ULL, 0x000fca00078e00ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000002b2c16723eULL, 0x004fe200000000ffULL,
0x00000008392c7824ULL, 0x000fca00078e00ffULL, 0xfffffff82c397812ULL, 0x000fe200078ee239ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x000000251e15723eULL, 0x002fe200000000ffULL, 0x0000000834257824ULL, 0x040fe200078e00ffULL,
0xffffffff341e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x0000001c1d17723eULL, 0x004fce00000000ffULL,
0x0000002100247308ULL, 0x0002a20000000800ULL, 0x00000006341d7810ULL, 0x040fe40007ffe0ffULL,
0x00000005341c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8282b7812ULL, 0x000fe200078ee21dULL,
0x000000221418723cULL, 0x000f620000001818ULL, 0xfffffff825257812ULL, 0x000fe200078ee21cULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000834217824ULL, 0x002fca00078e00ffULL,
0xfffffff821217812ULL, 0x000fe400078ee234ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000001f241d723eULL, 0x004fe400000000ffULL, 0x0000000c13247812ULL, 0x000fe400078ec0ffULL,
0x0000000607137208ULL, 0x000fc60004800000ULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000292a1c723eULL, 0x002fce00000000ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x00000026271e723eULL, 0x004fe400000000ffULL, 0x0000900000267811ULL, 0x000fca00078e58ffULL,
0x0000001021217824ULL, 0x100fe400078e0226ULL, 0x0000001031317824ULL, 0x100fe400078e0226ULL,
0x0000001033337824ULL, 0x100fe400078e0226ULL, 0x0000001035357824ULL, 0x100fe200078e0226ULL,
0x0000002e2d1f723eULL, 0x002fe200000000ffULL, 0x0000001037377824ULL, 0x000fe400078e0226ULL,
0x0000000121217824ULL, 0x000fc400078e0224ULL, 0x0000001025257824ULL, 0x100fe400078e0226ULL,
0x000000221c18723cULL, 0x020f620000001818ULL, 0x0000000124317824ULL, 0x040fe200078e0231ULL,
0x0000000821007388ULL, 0x0003e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe400078e0226ULL,
0x0000000124337824ULL, 0x040fe200078e0233ULL, 0x0000000a31007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e0226ULL, 0x0000000124357824ULL, 0x000fe200078e0235ULL,
0x0000000c33007388ULL, 0x0003e20000000800ULL, 0x0000001039397824ULL, 0x000fc400078e0226ULL,
0x0000000124377824ULL, 0x040fe200078e0237ULL, 0x0000000e35007388ULL, 0x0003e20000000800ULL,
0x0000000124257824ULL, 0x040fe400078e0225ULL, 0x00000001242b7824ULL, 0x040fe200078e022bULL,
0x0000001437007388ULL, 0x0003e20000000800ULL, 0x00000001242f7824ULL, 0x040fe400078e022fULL,
0x0000000124247824ULL, 0x000fe200078e0239ULL, 0x0000001625007388ULL, 0x0003e40000000800ULL,
0x000000ffff197224ULL, 0x020fc400078e001aULL, 0x0000001c2b007388ULL, 0x0003e80000000800ULL,
0x0000001e2f007388ULL, 0x0003e80000000800ULL, 0x0000000924007388ULL, 0x0003e80000000800ULL,
0x0004000b31007388ULL, 0x0003e80000000800ULL, 0x0004000d33007388ULL, 0x0003e80000000800ULL,
0x0004000f35007388ULL, 0x0003e80000000800ULL, 0x0004001537007388ULL, 0x0003e80000000800ULL,
0x0004001725007388ULL, 0x0003e80000000800ULL, 0x0004001d2b007388ULL, 0x0003e80000000800ULL,
0x0004001f2f007388ULL, 0x0003e80000000800ULL, 0x00f0001020008388ULL, 0x0003e80000000c00ULL,
0x00f2001820008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080077ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100077ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000015e5e7810ULL, 0x000fe20007ffe0ffULL, 0x0000180077ff7f8cULL, 0x0003e6000c80043fULL,
0x000000685e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb4d000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0d7807ULL, 0x002fe40004000000ULL, 0x000128b000107802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x018fea0003c00000ULL, 0xfffeff9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x000128f000107802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e000dULL,
0xfffefff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0026ULL,
0x0001294000117802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x018fea0003c00000ULL,
0xffff00e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0026ULL,
0x0001298000117802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x01afea0003c00000ULL,
0xffff020000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x000129d000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x00000a5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000dULL,
0xffff062000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x00012a2000117802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000dULL, 0xffff060000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x00012a7000107802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x008fea0003c00000ULL, 0xffff25a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x00012ab000107802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e000dULL,
0xffff25f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0038ULL,
0x00012b0000117802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x008fea0003c00000ULL,
0xffff26e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0038ULL,
0x00012b4000117802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x00afea0003c00000ULL,
0xffff280000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0002ULL,
0x00012b9000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0013ULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000dULL,
0xffff2c3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0002ULL,
0x00012be000117802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000dULL, 0xffff2c1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x00012c3000107802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0xffff49d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x00012c7000107802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e000dULL,
0xffff4a1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e003aULL,
0x00012cc000117802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x018fea0003c00000ULL,
0xffff4b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e003aULL,
0x00012d0000117802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x01afea0003c00000ULL,
0xffff4c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0009ULL,
0x00012d5000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e000eULL,
0x000006d000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000dULL,
0xffff505000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0009ULL,
0x00012da000117802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000dULL, 0xffff503000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x00012df000107802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x018fea0003c00000ULL, 0xffff6e5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x00012e3000107802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000dULL,
0xffff6ea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0022ULL,
0x00012e8000117802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x018fea0003c00000ULL,
0xffff6f9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0022ULL,
0x00012ec000117802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x01afea0003c00000ULL,
0xffff70b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0005ULL,
0x00012f1000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0012ULL,
0x0000051000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000dULL,
0xffff754000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0005ULL,
0x00012f6000117802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000dULL, 0xffff752000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x00012fb000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x006fe200078e000eULL,
0x0001301000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x0001307000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e070e7208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000bULL, 0x000130d000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000070b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000fULL, 0x0001313000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b07067208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000070f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000eULL, 0x0001319000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000f07107208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x000131f000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e07117208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0006ULL, 0x0001325000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a07127208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000300008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x006fc800078e00ffULL, 0xfffecc2002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000d0c077389ULL, 0x0002a200000e0035ULL, 0xfffecbe008007950ULL, 0x000fea0003c3ffffULL,
0x0000007900007348ULL, 0x000fe80003800000ULL, 0x0000000d100d7389ULL, 0x0002a400000e007aULL,
0x000000ffff107224ULL, 0x002fc400078e0011ULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffecb9010007950ULL, 0x000fea0003c3ffffULL, 0x000000010d00780cULL, 0x000fe20003f45070ULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000007800007348ULL, 0x000ff60003800000ULL,
0x00000000000d7806ULL, 0x000fc800050e0100ULL, 0x000000780d0d7212ULL, 0x000fe200078ec0ffULL,
0xfffecb3010007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003c8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e78ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001648ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001658ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016e8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016ecULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000013580ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014e80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014ed0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015250ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016e8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013798ULL, 0x0000000000013798ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015250ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_86_cubin_len = 86832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
