/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016e50ULL, 0x0000000000016ad0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000014f20ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x00000000000150a0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x00000000000150e0ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000015130ULL, 0x0000000000000150ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000015280ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00014f2000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x0052340400288080ULL, 0x0000000000000000ULL,
0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080830828808081ULL, 0xa608288080970828ULL, 0x288080a908288080ULL,
0x80ac08288080ab08ULL, 0x08288080b4082880ULL, 0x8080c108288080b5ULL, 0x8016288080840828ULL,
0x0000000310288082ULL, 0x8084920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL,
0x0000007000000000ULL, 0x00014f2000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0xa608288080970828ULL, 0x288080a908288080ULL, 0x80ac08288080ab08ULL, 0x08288080b4082880ULL,
0x8080c108288080b5ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL, 0x000150a000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0xa608288080970828ULL, 0x288080a908288080ULL, 0x80ac08288080ab08ULL, 0x08288080b4082880ULL,
0x8080c108288080b5ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080c192ULL,
0x0000002cffffffffULL, 0x000001c000000000ULL, 0x000150e000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80b4288080c10900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080830828808081ULL, 0xa608288080970828ULL, 0x288080a908288080ULL, 0x80ac08288080ab08ULL,
0x08288080b4082880ULL, 0x8080b508288080c1ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080b592ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL, 0x0001513000000000ULL,
0x0000015000000000ULL, 0x0000080400000000ULL, 0x80b4288080b50900ULL, 0x0000000000002880ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000018ULL, 0x000c170400681903ULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b7000043104ULL, 0xffffffff01342904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002f001342804ULL, 0x000005a000000450ULL,
0x000028c000002830ULL, 0x00002b50000029f0ULL, 0x0000300000002fd0ULL, 0x000030e000003070ULL,
0x000050b000005020ULL, 0x00005340000051e0ULL, 0x00005800000057d0ULL, 0x000058e000005870ULL,
0x000076e000007640ULL, 0x0000797000007810ULL, 0x00007e3000007e00ULL, 0x00007f1000007ea0ULL,
0x00009d8000009ce0ULL, 0x0000a01000009eb0ULL, 0x0000a5300000a500ULL, 0x0000a6100000a5a0ULL,
0x0000b8e00000b8d0ULL, 0x000134d000013490ULL, 0x000134f0000134e0ULL, 0x0001356000013500ULL,
0x000135a000013580ULL, 0x00014240000141f0ULL, 0x00014310000142b0ULL, 0x000143f000014380ULL,
0x000144a000014450ULL, 0x0001457000014510ULL, 0x00014650000145e0ULL, 0x00014700000146b0ULL,
0x000147d000014770ULL, 0x000148b000014840ULL, 0x0001496000014910ULL, 0x00014a30000149d0ULL,
0x00014b1000014aa0ULL, 0x00014c0000014b80ULL, 0x00014d0000014c80ULL, 0x00014e0000014d80ULL,
0x00014f0000014e80ULL, 0x000003e004403904ULL, 0x00017600000000ffULL, 0x00000410003f0100ULL,
0x0001760800000011ULL, 0x00000500003f0120ULL, 0x0001768800000011ULL, 0x00000520003f0120ULL,
0x000176a800000011ULL, 0x00000530003f0120ULL, 0x000176c800000011ULL, 0x00000b90003f0120ULL,
0x00017600000000ffULL, 0x00000d80003f0107ULL, 0x0000000400000007ULL, 0x00000e30003f0102ULL,
0x0000000000000007ULL, 0x00001620003f0101ULL, 0x000176a800000075ULL, 0x00001730003f0107ULL,
0x000176a800000075ULL, 0x00001790003f0101ULL, 0x000176c800000006ULL, 0x00001900003f0101ULL,
0x000176cc00000011ULL, 0x00001af0003f0105ULL, 0x000176cc00000011ULL, 0x00002460003f0105ULL,
0x000176b0000000ffULL, 0x000024e000050107ULL, 0x000176b0000000ffULL, 0x0000254000050101ULL,
0x0001760800000008ULL, 0x00002560003f0101ULL, 0x0001760c00000008ULL, 0x00002730003f0105ULL,
0x0001760c00000008ULL, 0x00002d30003f0105ULL, 0x000176ac00000016ULL, 0x00002f00003f0105ULL,
0x000176ac00000016ULL, 0x00004200003f0105ULL, 0x0000000000000012ULL, 0x00004260003f0101ULL,
0x0001768800000060ULL, 0x00004290003f0101ULL, 0x0000000400000007ULL, 0x00004450003f0105ULL,
0x0000000400000007ULL, 0x00004c70003f0105ULL, 0x000176a800000011ULL, 0x00004d00003f0107ULL,
0x000176a800000011ULL, 0x00004d60003f0101ULL, 0x0001762800000008ULL, 0x00004d80003f0101ULL,
0x0001762c00000008ULL, 0x00004f50003f0105ULL, 0x0001762c00000008ULL, 0x00005530003f0105ULL,
0x000176b40000003bULL, 0x00005700003f0105ULL, 0x000176b40000003bULL, 0x000067d0003f0105ULL,
0x0000000000000034ULL, 0x00006830003f0101ULL, 0x0001769000000036ULL, 0x00006860003f0101ULL,
0x0000000400000007ULL, 0x00006a20003f0105ULL, 0x0000000400000007ULL, 0x00007220003f0105ULL,
0x000176b000000075ULL, 0x00007320003f0107ULL, 0x000176b00000000eULL, 0x00007380003f0101ULL,
0x0001764800000008ULL, 0x000073a0003f0101ULL, 0x0001764c00000008ULL, 0x00007570003f0105ULL,
0x0001764c00000008ULL, 0x00007b60003f0105ULL, 0x000176ac0000003bULL, 0x00007d30003f0105ULL,
0x000176ac0000003bULL, 0x00008e70003f0105ULL, 0x0000000000000026ULL, 0x00008ed0003f0101ULL,
0x0000000000000012ULL, 0x00008f00003f0101ULL, 0x0000000400000007ULL, 0x000090c0003f0105ULL,
0x0000000400000007ULL, 0x000098f0003f0105ULL, 0x00000000000000ffULL, 0x000099d000040107ULL,
0x000176a800000075ULL, 0x00009a30003f0101ULL, 0x0001766800000007ULL, 0x00009a60003f0101ULL,
0x0001766c00000007ULL, 0x00009c30003f0105ULL, 0x0001766c00000007ULL, 0x0000a1e0003f0105ULL,
0x000176b400000075ULL, 0x0000a410003f0105ULL, 0x000176b400000075ULL, 0x0000b6a0003f0105ULL,
0x000000000000000cULL, 0x0000b720003f0101ULL, 0x0000000000000007ULL, 0x0000ca80003f0101ULL,
0x00017600000000ffULL, 0x0000e3b0003f0101ULL, 0x00017604000000ffULL, 0x0000e5c0003f0105ULL,
0x00017604000000ffULL, 0x0000e7f0003f0105ULL, 0x00017600000000ffULL, 0x0000e820003f0101ULL,
0x00017604000000ffULL, 0x0000e9e0003f0105ULL, 0x00017604000000ffULL, 0x00011870003f0105ULL,
0x0000000000000073ULL, 0x00011910003f0101ULL, 0x0000000400000073ULL, 0x00011ae0003f0105ULL,
0x0000000400000073ULL, 0x00014030003f0105ULL, 0x0000000000000075ULL, 0x00014090003f0101ULL,
0x0000000800000075ULL, 0x000140f0003f0101ULL, 0x0000001000000075ULL, 0x00014160003f0101ULL,
0x0000001800000075ULL, 0x00053803003f0101ULL, 0x0000c13000201c04ULL, 0x0000c3f00000c160ULL,
0x0000c7e00000c5e0ULL, 0x0000ea400000c990ULL, 0x00000401000141b0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002ecULL, 0x0000001b00000002ULL, 0x0000000000000244ULL, 0x0000001b00000002ULL,
0x00000000000001acULL, 0x0000001b00000002ULL, 0x00000000000000fcULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000002c8ULL, 0x0000001b00000002ULL,
0x0000000000000220ULL, 0x0000001b00000002ULL, 0x0000000000000185ULL, 0x0000001b00000002ULL,
0x00000000000000d5ULL, 0x0000001b00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000777919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000087ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000177020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0077040625ULL, 0x000fe200078e0004ULL, 0x0000000802000981ULL, 0x0002a8000c1e1900ULL,
0x0000000804070981ULL, 0x0006a2000c1e1900ULL, 0x0000590000067b06ULL, 0x000f220000209000ULL,
0x00005900ff767624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000747919ULL, 0x000e680000002600ULL, 0x00000000000f7919ULL, 0x000e620000002300ULL,
0x0000000600067308ULL, 0x010f240000001000ULL, 0x0ffffffe06087810ULL, 0x010fc40007ffe0ffULL,
0x0000000000067919ULL, 0x000f280000002100ULL, 0x0000000800097305ULL, 0x0002e4000021f000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fe400078e0008ULL,
0x0000000000087919ULL, 0x000e680000002200ULL, 0x0000040009097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x0000040003027624ULL, 0x000fca00078e0276ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900047306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f85070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027810ULL, 0x008fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000664000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x0000000309057224ULL, 0x002fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a05ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007403737227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a73ULL, 0x0000000309027224ULL, 0x000fe400078e0274ULL,
0x000001000f037a24ULL, 0x000fe400078e0208ULL, 0x00001fff0f0f7589ULL, 0x000fe200000e0000ULL,
0x000000090200720cULL, 0x000fe20003fa6070ULL, 0x0000000003117a24ULL, 0x110fe200078e0206ULL,
0x00000005ff067819ULL, 0x000fc80000011606ULL, 0x000000ff1100720cULL, 0x040fe40003f65270ULL,
0x0000000f1100780cULL, 0x040fe40003f24070ULL, 0x0000007f1100780cULL, 0x000fc60003f44070ULL,
0x0000000102025824ULL, 0x000fe200078e0a09ULL, 0x0000000173735810ULL, 0x000fe40007ffe0ffULL,
0x000000031100780cULL, 0x000fe40003fa4070ULL, 0x000000090200720cULL, 0x000fe20003fc6070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x01760002ff00b388ULL, 0x000fe20000000a00ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0xff317217ff0ea424ULL, 0x000fe400078e00ffULL, 0x0176080411009388ULL, 0x000fe20000008a00ULL,
0x0000000173736810ULL, 0x000fe20007ffe0ffULL, 0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL,
0x00000009ff73c212ULL, 0x000fe200078e33ffULL, 0x00001fff06027589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff0bd424ULL, 0x000fc600078e00ffULL, 0x000000ffff087224ULL, 0x000fe200078e0a73ULL,
0x0174000e1100a388ULL, 0x0007e20000004800ULL, 0x3fffffc0ff0cb424ULL, 0x000fe400078e00ffULL,
0x0000000809747224ULL, 0x000fe400078e0274ULL, 0x3fffff60ff08d424ULL, 0x000fe400078e00ffULL,
0x0000001074747824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff09d424ULL, 0x000fc400078e00ffULL,
0x00005a00ff0e7624ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL,
0x017688081100d388ULL, 0x000fe20000008a00ULL, 0x000059000e0e7a24ULL, 0x000fc600078e02ffULL,
0x0176a80a1100d388ULL, 0x000fe80000008a00ULL, 0x0176c80c1100b388ULL, 0x000fe20000008a00ULL,
0x0000000100000824ULL, 0x004fe400078e0a07ULL, 0x00005800ff008624ULL, 0x000fe400078e00ffULL,
0x0000580077078a24ULL, 0x000fe400078e02ffULL, 0x00005a0000037a24ULL, 0x000fc400078e02ffULL,
0x0000000e07797224ULL, 0x000fe400078e02ffULL, 0x0000000103047824ULL, 0x040fe200078e0a74ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000740300720cULL, 0x000fe20003f26070ULL,
0x000000040f037824ULL, 0x002fe200078e0202ULL, 0x0000001004047817ULL, 0x000fe20003800000ULL,
0x00005a0073117a24ULL, 0x000fc400078e0279ULL, 0x0000000203087824ULL, 0x000fe200078e00ffULL,
0x000000ff04787207ULL, 0x000fc80000800000ULL, 0x000000107800780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x00000004ff097819ULL, 0x004fca0000011603ULL, 0x00000001080a7824ULL, 0x000fe200078e0209ULL,
0x0ffffffe06057810ULL, 0x002fe20007ffe0ffULL, 0x0000001003067824ULL, 0x000fca00078e00ffULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b050b7227ULL, 0x000fc800078e0004ULL,
0x0000000174047824ULL, 0x000fc800078e020aULL, 0x000000040b0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a0bULL, 0x00005a000d057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0bULL, 0x00005a0005047a24ULL, 0x000fe200078e0204ULL,
0x0000000878057217ULL, 0x000fc60007800000ULL, 0x0000000111047824ULL, 0x000fe400078e0204ULL,
0x0000000105087824ULL, 0x000fe400078e0a08ULL, 0x0000000e0b047224ULL, 0x000fe200078e0204ULL,
0x000000f0060b7812ULL, 0x000fe400078ec0ffULL, 0x000000080900720cULL, 0x000fe20003f06070ULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x000000010a087824ULL, 0x000fe200078e0203ULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x000000100a097824ULL, 0x000fc600078e00ffULL,
0x000060000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0x0000610005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001008097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000803087211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe060a7810ULL, 0x002fca0007ffe0ffULL,
0x0000000a00057305ULL, 0x000e64000021f000ULL, 0x000000ffff097224ULL, 0x002fc800078e0a05ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905057227ULL, 0x000fc800078e0004ULL,
0x0000000174047824ULL, 0x000fc800078e0208ULL, 0x0000000405057227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a05ULL, 0x00005a0009067a24ULL, 0x000fca00078e0204ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe20003f26070ULL,
0x0000001003067824ULL, 0x000fca00078e00ffULL, 0x000000f0060b7812ULL, 0x000fce00078ec0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff05aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a05ULL, 0x00005a0009047a24ULL, 0x000fe400078e0204ULL,
0x0000000108097824ULL, 0x040fe400078e0203ULL, 0x0000000111047824ULL, 0x000fe400078e0204ULL,
0x0000001008087824ULL, 0x000fe400078e00ffULL, 0x0000000e05047224ULL, 0x000fc600078e0204ULL,
0xfffffff008097812ULL, 0x000fe200078ee209ULL, 0x0000010004047825ULL, 0x000fc800078e00ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000000b04047212ULL, 0x000fc800078efcffULL,
0x0000600004047a10ULL, 0x000fc80007f1e0ffULL, 0x0000610005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c48ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000087806ULL, 0x000fe200038e0000ULL,
0x00000004ff427424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000800047300ULL, 0x000e7000000e0000ULL, 0x0000000800097309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x0000680077047625ULL, 0x000fc800078e0042ULL,
0x000000ffff097224ULL, 0x004fd000078e0a09ULL, 0x01760409ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000804697981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe40003f05270ULL,
0x0000007f69727810ULL, 0x044fe40007ffe0ffULL, 0x000000ff690a7810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff727819ULL, 0x000fe40000011672ULL, 0x00000008ff6d7819ULL, 0x000fca000001160aULL,
0x0000bcd000008947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fe20000011602ULL,
0x00000003ff087424ULL, 0x000fe200078e00ffULL, 0x0001768802077811ULL, 0x000fe400078e18ffULL,
0x01ffffff04047812ULL, 0x000fc800078ec0ffULL, 0x000000720400720cULL, 0x000fda0003f06070ULL,
0x0000000277008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x000fc800078e00ffULL,
0x00006a0000058624ULL, 0x000fe400078e0205ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000104058824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040807ff738cULL, 0x0005e20000000000ULL, 0x0000660005428625ULL, 0x000fe200078e0042ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000842008981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00000080736e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe20000011602ULL, 0x0000000007ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000102767812ULL, 0x000fc600078ec0ffULL, 0x00000020057a7824ULL, 0x000fca00078e00ffULL,
0x000000606e0a7812ULL, 0x000fe200078ef87aULL, 0x0000590000087a24ULL, 0x00cfc800078e02ffULL,
0x0000008008197824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000007a69077217ULL, 0x002fe20007800000ULL, 0x0000001076087824ULL, 0x000fe200078e00ffULL,
0x00000003ff097819ULL, 0x000fe40000011603ULL, 0x0000640019137a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe200078e0a7aULL, 0x00000004090d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x000fe200078e0209ULL, 0x0000000c090e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000807077217ULL, 0x000fe20007800000ULL, 0x000000010b0c7824ULL, 0x000fe200078e0203ULL,
0x0000650019197a11ULL, 0x000fe200020f3cffULL, 0x000000080b0f7824ULL, 0x000fc400078e00ffULL,
0x0000000107077824ULL, 0x000fc600078e0a08ULL, 0xfffffff80f107812ULL, 0x000fe200078ee20cULL,
0x00000001080f7824ULL, 0x040fe200078e020eULL, 0x00000008090c7810ULL, 0x000fe40007ffe0ffULL,
0x000000070d00720cULL, 0x080fe20003f46070ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000070c00720cULL, 0x080fe20003f26070ULL, 0x00000001080c7824ULL, 0x000fe200078e020cULL,
0x000000070900720cULL, 0x080fe20003f66070ULL, 0x000000010d087824ULL, 0x040fe200078e0203ULL,
0x000000070e00720cULL, 0x000fe20003f06070ULL, 0x000000080d117824ULL, 0x000fc400078e00ffULL,
0x000000010a097824ULL, 0x000fe400078e020bULL, 0x000000010c0b7824ULL, 0x040fe200078e0203ULL,
0xfffffff811127812ULL, 0x000fe200078ee208ULL, 0x000000080c147824ULL, 0x000fe400078e00ffULL,
0x0000008009087825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000010a0b7824ULL, 0x000fe200078e020dULL, 0x0000007008087812ULL, 0x000fe200078ef806ULL,
0x000000010a0c7824ULL, 0x040fe400078e020cULL, 0x000000010a0e7824ULL, 0x000fe200078e020fULL,
0x0000000813087210ULL, 0x000fe20007f9e0ffULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x000000010f077824ULL, 0x040fe200078e0203ULL, 0x000000700a117812ULL, 0x000fe200078ef806ULL,
0x000000080f167824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0a7812ULL, 0x100fe400078ef806ULL, 0x0001300005077811ULL, 0x000fe200078e68ffULL,
0x0000000109097824ULL, 0x000fe200020e0619ULL, 0x000000700e0c7812ULL, 0x000fe400078ef806ULL,
0x0000001311067210ULL, 0x080fe20007f9e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0207ULL,
0x000000130a0a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001014157824ULL, 0x100fe200078e0207ULL,
0x000000130c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001012137824ULL, 0x100fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000d901c48ULL,
0x0000001016177824ULL, 0x000fc400078e0207ULL, 0x000000010b077824ULL, 0x100fe400020e0619ULL,
0x000000010d0b7824ULL, 0x100fe400028e0619ULL, 0x000000010f0d7824ULL, 0x000fe200030e0619ULL,
0x0000000006137faeULL, 0x0003e8000d101c48ULL, 0x000000000a157faeULL, 0x0003e8000c901c48ULL,
0x000000000c177faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001076087824ULL, 0x002fe200078e00ffULL, 0x0000640019137a11ULL, 0x000fc400078038ffULL,
0x0001300005177811ULL, 0x000fe400078e68ffULL, 0x0000000803077211ULL, 0x000fe400078fe8ffULL,
0x0000650019197a11ULL, 0x000fe400000f3cffULL, 0x00000004070b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000107087824ULL, 0x040fe200078e0203ULL, 0x00000008070c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fe400078e00ffULL, 0x000000080b127824ULL, 0x000fc400078e00ffULL,
0x000000010c0d7824ULL, 0x100fe200078e0203ULL, 0xfffffff809107812ULL, 0x000fe200078ee208ULL,
0x000000010b097824ULL, 0x000fe400078e0203ULL, 0x000000010a087824ULL, 0x000fe200078e0207ULL,
0x0000000c07077810ULL, 0x000fe20007ffe0ffULL, 0x000000080c147824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000010a0b7824ULL, 0x000fe200078e020bULL,
0x0000007008087812ULL, 0x000fe200078ef806ULL, 0x000000010a0c7824ULL, 0x040fe400078e020cULL,
0x000000010a0e7824ULL, 0x000fe200078e0207ULL, 0x0000000813087210ULL, 0x000fe20007f1e0ffULL,
0x0000000107117824ULL, 0x040fe400078e0203ULL, 0x0000000807167824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff816077812ULL, 0x000fe200078ee211ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a117812ULL, 0x000fc600078ef806ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0a7812ULL, 0x000fc600078ef806ULL,
0x0000000109097824ULL, 0x000fe200000e0619ULL, 0x000000700e0c7812ULL, 0x000fe200078ef806ULL,
0x0000001014157824ULL, 0x100fe200078e0217ULL, 0x0000001113067210ULL, 0x040fe20007f1e0ffULL,
0x0000001010117824ULL, 0x100fe200078e0217ULL, 0x0000000a130a7210ULL, 0x040fe40007f3e0ffULL,
0x0000000c130c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000b901c48ULL,
0x0000001007177824ULL, 0x000fc400078e0217ULL, 0x000000010b077824ULL, 0x100fe400000e0619ULL,
0x000000010d0b7824ULL, 0x100fe400008e0619ULL, 0x000000010f0d7824ULL, 0x000fe200010e0619ULL,
0x0000000006137faeULL, 0x0003e8000b901c48ULL, 0x000000000a157faeULL, 0x0003e8000b901c48ULL,
0x000000000c177faeULL, 0x0003e4000b901c48ULL, 0x0000001005757824ULL, 0x000fe200078e00ffULL,
0x000000ff6d00720cULL, 0x000fe20003f05270ULL, 0x0000000805067824ULL, 0x002fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000000750473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000176a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80075127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176c80006067f8cULL, 0x000ee2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00009f2000008947ULL, 0x000fea0003800000ULL,
0x00000002776f7824ULL, 0x000fe200078e00ffULL, 0x00000002ff707819ULL, 0x000fe20000011602ULL,
0x00006a00ff067624ULL, 0x008fc400078e00ffULL, 0x000000ffff127224ULL, 0x004fe400078e0013ULL,
0x00006a006f6f7624ULL, 0x000fe400078e0206ULL, 0x000000ffff087224ULL, 0x000fe400078e0007ULL,
0xff317217ff137424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc400078e00ffULL, 0x00000000000c7805ULL, 0x034fca0000015200ULL,
0x0000000402077824ULL, 0x000fca00078e00ffULL, 0xfffffff807117812ULL, 0x000fca00078ec0ffULL,
0x0176cc0011077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007804808ULL,
0x000176c811077810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000150e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc00110f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x00000001060c7810ULL, 0x000fe20007ffe0ffULL, 0x0000590000007a24ULL, 0x000fc600078e02ffULL,
0xffffffe0080d7812ULL, 0x000fe200078ec0ffULL, 0x0000008000417824ULL, 0x000fe200078e00ffULL,
0x0000006d0c00720cULL, 0x000fc60003f26070ULL, 0x00000100060d7824ULL, 0x000fca00078e020dULL,
0x000000400d0e7810ULL, 0x000fc80007ffe0ffULL, 0x000000600e0d7812ULL, 0x000fca00078ec0ffULL,
0x000000016e0f7824ULL, 0x000fe200078e020dULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000000e69007217ULL, 0x000fe40007800000ULL, 0x00000010080d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff147819ULL, 0x000fe20000011603ULL, 0x0000000100007824ULL, 0x000fe200078e0a0eULL,
0x0000640041377a11ULL, 0x000fe400078a38ffULL, 0x00000004140e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114087824ULL, 0x000fe200078e020dULL, 0x0000000d00007217ULL, 0x000fc40007800000ULL,
0x0000000c14157810ULL, 0x000fe20007ffe0ffULL, 0x00000001080c7824ULL, 0x040fe200078e0203ULL,
0x0000650041417a11ULL, 0x000fe200028f3cffULL, 0x0000000808117824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x100fe400078e0a0dULL, 0x0000000115247824ULL, 0x000fe200078e020dULL,
0xfffffff811117812ULL, 0x000fe400078ee20cULL, 0x00000008140c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000824357824ULL, 0x000fe200078e00ffULL, 0x000000001400720cULL, 0x000fc40003f86070ULL,
0x000000000e00720cULL, 0x080fe20003f66070ULL, 0x000000010c147824ULL, 0x140fe200078e020dULL,
0x000000000c00720cULL, 0x080fe20003f46070ULL, 0x000000010e0e7824ULL, 0x000fe200078e020dULL,
0x000000001500720cULL, 0x000fe20003f06070ULL, 0x00000001140d7824ULL, 0x040fe400078e0203ULL,
0x0000000814167824ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe400078e00ffULL,
0x000000010f0c7824ULL, 0x040fe200078e0208ULL, 0xfffffff816277812ULL, 0x000fe200078ee20dULL,
0x000000010f167824ULL, 0x000fe200078e020eULL, 0x0000007015437812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000430c0c7212ULL, 0x000fc600078efcffULL, 0x000000010e007824ULL, 0x040fe200078e0203ULL,
0x0000000c370c7210ULL, 0x000fe20007fbe0ffULL, 0x000000080e257824ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fe200078efcffULL, 0x000000010f0e7824ULL, 0x040fe400078e0214ULL,
0x000000010f147824ULL, 0x000fe200078e0224ULL, 0xfffffff825257812ULL, 0x000fe200078ee200ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000124007824ULL, 0x000fe200078e0203ULL,
0x000000430e0e7212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee200ULL, 0x000000010d0d7824ULL, 0x100fe200028e0641ULL,
0x0000003716167210ULL, 0x000fe40007fbe0ffULL, 0x0000004314147212ULL, 0x000fe400078efcffULL,
0x0001400005007811ULL, 0x000fe200078e68ffULL, 0x0000000117177824ULL, 0x000fe200028e0641ULL,
0x000000370e0e7210ULL, 0x080fe40007fbe0ffULL, 0x0000003714147210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x000fc400078e0200ULL, 0x0000001025257824ULL, 0x100fe400078e0200ULL,
0x0000001027277824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0005e2000e101c48ULL, 0x000000010f0f7824ULL, 0x100fe400028e0641ULL,
0x0000001035357824ULL, 0x000fe200078e0200ULL, 0x0000000016257faeULL, 0x0005e2000d901c48ULL,
0x0000000115157824ULL, 0x000fc600030e0641ULL, 0x000000000e277faeULL, 0x0005e8000d101c48ULL,
0x0000000014357faeULL, 0x0005e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001008007812ULL, 0x000fe400078ec0ffULL, 0x0000640041277a11ULL, 0x000fe400078038ffULL,
0x0000000003007211ULL, 0x000fe400078fe8ffULL, 0x0000650041417a11ULL, 0x000fc400000f3cffULL,
0x00000004000e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100087824ULL, 0x140fe200078e0203ULL,
0x0000000800147810ULL, 0x040fe20007ffe0ffULL, 0x00000008000d7824ULL, 0x000fe200078e00ffULL,
0x0001400005357811ULL, 0x000fe200078e68ffULL, 0x000000010e0c7824ULL, 0x140fe400078e0203ULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x00000001140d7824ULL, 0x040fe400078e0203ULL, 0x0000000814267824ULL, 0x000fe200078e00ffULL,
0xfffffff811247812ULL, 0x000fe200078ee20cULL, 0x0000001003117824ULL, 0x000fc400078e00ffULL,
0x000000010f0c7824ULL, 0x040fe200078e0200ULL, 0xfffffff826267812ULL, 0x000fe200078ee20dULL,
0x000000010f0e7824ULL, 0x000fe200078e020eULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000007011257812ULL, 0x000fc600078ec0ffULL,
0x000000010f147824ULL, 0x040fe200078e0214ULL, 0x000000250c0c7212ULL, 0x000fe200078efcffULL,
0x000000010f167824ULL, 0x000fe400078e0200ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c270c7210ULL, 0x000fc60007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000250e0e7212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000002514147212ULL, 0x000fc600078efcffULL, 0x0000000100117824ULL, 0x000fe200078e0203ULL,
0x0000002516167212ULL, 0x000fe200078efcffULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000001427147210ULL, 0x000fe20007f5e0ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0641ULL,
0x0000000e270e7210ULL, 0x040fe20007f1e0ffULL, 0x0000001024257824ULL, 0x000fe200078e0235ULL,
0xfffffff800007812ULL, 0x000fe200078ee211ULL, 0x0000001008117824ULL, 0x000fe200078e0235ULL,
0x0000001627167210ULL, 0x000fe20007f7e0ffULL, 0x000000010f0f7824ULL, 0x000fc400000e0641ULL,
0x0000001026277824ULL, 0x000fe200078e0235ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0005e2000b901c48ULL, 0x0000000115157824ULL, 0x000fe400010e0641ULL,
0x0000001000357824ULL, 0x000fe200078e0235ULL, 0x000000000e257faeULL, 0x0005e2000b901c48ULL,
0x0000000117177824ULL, 0x000fc600018e0641ULL, 0x0000000014277faeULL, 0x0005e8000b901c48ULL,
0x0000000016357faeULL, 0x0005e4000b901c48ULL, 0x0000000802007824ULL, 0x000fe200078e00ffULL,
0x00000001040c7810ULL, 0x004fe20007ffe0ffULL, 0xffffffffff0e7424ULL, 0x000fe400078e00ffULL,
0x00000000000573c2ULL, 0x000ea200000e0000ULL, 0x000000720c00720cULL, 0x000fe40003f06070ULL,
0x00000010000f7812ULL, 0x000fc400078ec0ffULL, 0xffffffe000087812ULL, 0x040fe400078ec0ffULL,
0x0000000800117812ULL, 0x000fce00078ec0ffULL, 0x000000016f0c8824ULL, 0x000fe400078e020cULL,
0x00000004ff0d8424ULL, 0x000fe200078e00ffULL, 0xfffffff005057892ULL, 0x004fc6000f8ec03fULL,
0x000066000c0c8625ULL, 0x000fe200078e000dULL, 0x000176b005067890ULL, 0x000fe2000fffe03fULL,
0x0000000811087210ULL, 0x000fc60007ffe00fULL, 0x000000080c0e8981ULL, 0x000528000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b000ff367f8cULL, 0x000ee2000c800405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176080008167f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x004fc40000015200ULL,
0x01760c00080f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140c147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0dULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011415ULL,
0x000000140f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x000000020f0f7819ULL, 0x000fc80000001214ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c00080f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001003517824ULL, 0x000fe200078e00ffULL, 0x00000001ff717819ULL, 0x000fe20000011603ULL,
0x00000020020c7824ULL, 0x000fc600078e00ffULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0xffffff800c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c71717812ULL, 0x000fc800078ec0ffULL,
0x0000000c710c7210ULL, 0x000fca0007ffe051ULL, 0x017000000c147984ULL, 0x000ea80000000800ULL,
0x017200000c0d7984ULL, 0x0002e20000000800ULL, 0x000000131400720bULL, 0x004fe20003f1d000ULL,
0x000119927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x002fc800000e0100ULL,
0x0000ffff40157812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fd200078e0013ULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000027000720cULL, 0x000fe40003f05270ULL,
0x000000131400720bULL, 0x000fe20003f54000ULL, 0x000119527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x000fc400010e0100ULL, 0x0000008002168824ULL, 0x000fe200078e0251ULL,
0x00000013140f8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100c117816ULL, 0x000fe200000000ffULL, 0x0000000171168824ULL, 0x000fca00078e0216ULL,
0x0174000f16008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001314167209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL,
0x00000013160f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fcc0000410000ULL,
0x0000000f000f7308ULL, 0x000e640000000800ULL, 0x0000000f10107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x000fe20000011603ULL,
0x000118827f007947ULL, 0x000fea000b800000ULL, 0x00001f340f407589ULL, 0x0002a400000e0000ULL,
0x000000401c1c7220ULL, 0x084fe40000410000ULL, 0x000000401d1d7220ULL, 0x080fe40000410000ULL,
0x000000402c2c7220ULL, 0x080fe40000410000ULL, 0x000000402d2d7220ULL, 0x000fc40000410000ULL,
0x0000004018187220ULL, 0x080fe40000410000ULL, 0x0000004019197220ULL, 0x080fe40000410000ULL,
0x000000403c3c7220ULL, 0x080fe40000410000ULL, 0x000000403d3d7220ULL, 0x080fe40000410000ULL,
0x0000004028287220ULL, 0x080fe40000410000ULL, 0x0000004029297220ULL, 0x000fc40000410000ULL,
0x0000004030307220ULL, 0x080fe40000410000ULL, 0x0000004031317220ULL, 0x080fe40000410000ULL,
0x0000004020207220ULL, 0x080fe40000410000ULL, 0x0000004021217220ULL, 0x080fe40000410000ULL,
0x0000004038387220ULL, 0x080fe40000410000ULL, 0x0000004039397220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803347811ULL, 0x002fe200078ff0ffULL,
0x000117827f007947ULL, 0x000fea000b800000ULL, 0x00001f340f407589ULL, 0x0002a400000e0000ULL,
0x000000401e1e7220ULL, 0x084fe40000410000ULL, 0x000000401f1f7220ULL, 0x080fe40000410000ULL,
0x000000402e2e7220ULL, 0x080fe40000410000ULL, 0x000000402f2f7220ULL, 0x080fe40000410000ULL,
0x000000401a1a7220ULL, 0x080fe40000410000ULL, 0x000000401b1b7220ULL, 0x000fc40000410000ULL,
0x000000403e3e7220ULL, 0x080fe40000410000ULL, 0x000000403f3f7220ULL, 0x080fe40000410000ULL,
0x000000402a2a7220ULL, 0x080fe40000410000ULL, 0x000000402b2b7220ULL, 0x080fe40000410000ULL,
0x0000004032327220ULL, 0x080fe40000410000ULL, 0x0000004033337220ULL, 0x000fc40000410000ULL,
0x0000004022227220ULL, 0x080fe40000410000ULL, 0x0000004023237220ULL, 0x080fe40000410000ULL,
0x000000403a3a7220ULL, 0x080fe40000410000ULL, 0x000000403b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780600cULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000013140f7209ULL, 0x000fd60007810000ULL,
0x8000000f14140221ULL, 0x000fe20000010000ULL, 0x00007610ff110816ULL, 0x000fc60000000011ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400090308ULL, 0x000e640000000800ULL,
0x000000090d0d0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107221ULL, 0x008fc40000010000ULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0xfffffff000167812ULL, 0x000fca00078ec0ffULL, 0x0176ac0016137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804812ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c137210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011414ULL, 0x0000001300007211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0614ULL, 0x0000000200007819ULL, 0x000fc80000001213ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0016137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991011007816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000113627f007947ULL, 0x000fea000b800000ULL, 0x00001f0d000a7589ULL, 0x0002a400000e0000ULL,
0x000000080d347810ULL, 0x000fe20007ffe0ffULL, 0x000113b27f007947ULL, 0x000fea000b800000ULL,
0x00001f34000b7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0000ULL,
0x0000308000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0001206000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0000ULL, 0x000030f000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x004fc400078e00ffULL,
0x00011ff000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000202607824ULL, 0x040fe200078e00ffULL, 0x00000007030c7812ULL, 0x040fe200078ec0ffULL,
0x00000200025e7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000803497812ULL, 0x040fe400078ec0ffULL, 0x0000000460127812ULL, 0x000fe400078ec0ffULL,
0x000000080c007812ULL, 0x00afe400078ef803ULL, 0x00000012030d7211ULL, 0x000fc400078fe0ffULL,
0xfffff8005e5e7812ULL, 0x000fe200078ec0ffULL, 0x0000000800117824ULL, 0x040fe400078e00ffULL,
0x0000000100527824ULL, 0x000fca00078e020dULL, 0xfffffff8110d7812ULL, 0x000fca00078ee252ULL,
0x000000100d4e7824ULL, 0x000fc600078e025eULL, 0x0000000402127824ULL, 0x000fe200078e00ffULL,
0x00000004ff777819ULL, 0x000fe20000011603ULL, 0x011000004e40783bULL, 0x004e620000000200ULL,
0x0000000c490d7212ULL, 0x000fe400078efcffULL, 0x0000000412127812ULL, 0x000fe400078ec0ffULL,
0x00013000056b7811ULL, 0x000fe200078e68ffULL, 0x000000080d487824ULL, 0x000fe200078e00ffULL,
0x0000001049497812ULL, 0x000fe200078efe0cULL, 0x0000000177127824ULL, 0x000fe200078e0212ULL,
0xfffffff860607812ULL, 0x000fe200078ec0ffULL, 0x000000080d147824ULL, 0x000fc400078e00ffULL,
0x000000010d137824ULL, 0x000fe400078e0212ULL, 0x00000008490c7824ULL, 0x000fe400078e00ffULL,
0x00000001124b7824ULL, 0x000fe200078e0249ULL, 0xfffffff848487812ULL, 0x000fe200078ee213ULL,
0x0000000405777824ULL, 0x000fe200078e0277ULL, 0x00000002130d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee24bULL, 0x0000001048247824ULL, 0x000fe200078e026bULL,
0xfffffff8140d7812ULL, 0x000fc400078ee20dULL, 0x0000000277777810ULL, 0x000fe20007ffe000ULL,
0x000000100c447824ULL, 0x100fe400078e026bULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000100d147824ULL, 0x000fe400078e026bULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x000000004444783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x000ee20000004200ULL,
0xfffffff800777812ULL, 0x000fe200078ee277ULL, 0x0000000a40408232ULL, 0x002fc40000000000ULL,
0x0000000a42428232ULL, 0x000fe40000000000ULL, 0x0000001077007824ULL, 0x000fe200078e025eULL,
0x0000000b41418232ULL, 0x080fe40000000000ULL, 0x0000000b43438232ULL, 0x000fe20000000000ULL,
0x0000010024137824ULL, 0x044fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011424ULL,
0x0000010025347824ULL, 0x000fe200078e00ffULL, 0x00008880244c7816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000888026567816ULL, 0x000fe400000000ffULL,
0x0000888027577816ULL, 0x000fe400000000ffULL, 0x00000018ff647819ULL, 0x000fe20000011425ULL,
0x00000013004d7306ULL, 0x0003e20000200c00ULL, 0x00008880255d7816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc40000011426ULL,
0x00000018ff4a7819ULL, 0x008fe40000011445ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000002400667306ULL, 0x0005e20000200c00ULL, 0x0000010026137824ULL, 0x042fe200078e00ffULL,
0x0000888045537816ULL, 0x000fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011427ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000003400687306ULL, 0x000fe20000200c00ULL, 0x0000010027247824ULL, 0x044fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc40000011444ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00008880444f7816ULL, 0x000fe400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011446ULL,
0x00000018ff5b7819ULL, 0x000fe20000011414ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x00000018ff5c7819ULL, 0x000fc40000011415ULL, 0x00000018ff557819ULL, 0x000fe40000011416ULL,
0x00000018ff587819ULL, 0x000fe40000011417ULL, 0x00000018ff127819ULL, 0x000fe20000011447ULL,
0x0000005700577306ULL, 0x000ff00000200c00ULL, 0x0000002400347306ULL, 0x0004e20000200c00ULL,
0x0000541056567816ULL, 0x002fce0000000013ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x0000010044247824ULL, 0x044fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000541057577816ULL, 0x008fe40000000034ULL, 0x00000018ff447819ULL, 0x000fca0000011444ULL,
0x0000002500677306ULL, 0x0007e20000200c00ULL, 0x000000564018723cULL, 0x000bee0000001818ULL,
0x0000002600627306ULL, 0x0003e20000200c00ULL, 0x0000010045257824ULL, 0x048fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc400078e00ffULL, 0x0000010014567824ULL, 0x020fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000010015577824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000000849267824ULL, 0x002fe200078e00ffULL,
0x000000024b497810ULL, 0x000fe20007ffe0ffULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x00008880464b7816ULL, 0x000fe400000000ffULL, 0xfffffff826497812ULL, 0x000fe400078ee249ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff6c7819ULL, 0x000fe20000011457ULL,
0x0000002400507306ULL, 0x0007e20000200c00ULL, 0x0000001049267824ULL, 0x000fce00078e026bULL,
0x0000002500547306ULL, 0x0005e20000200c00ULL, 0x000054104c247816ULL, 0x008fe4000000004dULL,
0x00008880474d7816ULL, 0x000fca00000000ffULL, 0x0000004500597306ULL, 0x0007e20000200c00ULL,
0x000054105d257816ULL, 0x004fce0000000068ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000010047457824ULL, 0x048fe200078e00ffULL, 0x00000024401c723cULL, 0x000b62000000181cULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011445ULL,
0x0001000046457824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fc60000011447ULL, 0x00000018ff5d7819ULL, 0x000fe40000011445ULL,
0x0000541067457816ULL, 0x002fe40000000064ULL, 0x0000002700637306ULL, 0x0002a20000200c00ULL,
0x0000888014677816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fca00078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000044005a7306ULL, 0x0007e20000200c00ULL,
0x000000002624783bULL, 0x022e6e0000004200ULL, 0x00000056006a7306ULL, 0x0005e20000200c00ULL,
0x0000010046447824ULL, 0x008fe200078e00ffULL, 0x0000541063577816ULL, 0x004fc4000000005fULL,
0x0000888016637816ULL, 0x000fe400000000ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006800467306ULL, 0x0005e20000200c00ULL, 0x0000541062567816ULL, 0x000fe40000000061ULL,
0x00008880175f7816ULL, 0x000fca00000000ffULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0000888015687816ULL, 0x044fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000056403c723cULL, 0x000be8000000183cULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000006800687306ULL, 0x000fe40000200c00ULL, 0x0000010016567824ULL, 0x020fc400078e00ffULL,
0x0001000016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00008880245e7816ULL, 0x002fe400000000ffULL, 0x00000018ff137819ULL, 0x000fe40000011426ULL,
0x00000018ff347819ULL, 0x000fe20000011427ULL, 0x00000044004c7306ULL, 0x0003f00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541066447816ULL, 0x002fce0000000065ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000044402c723cULL, 0x000b6e000000182cULL,
0x0000001400667306ULL, 0x0003e20000200c00ULL, 0x00000018ff447819ULL, 0x020fe40000011424ULL,
0x00000018ff457819ULL, 0x000fca0000011425ULL, 0x0000001500577306ULL, 0x0004e20000200c00ULL,
0x0000010017147824ULL, 0x042fe400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541068157816ULL, 0x004fe4000000006cULL, 0x00000018ff627819ULL, 0x000fca0000011417ULL,
0x0000001400657306ULL, 0x0003e20000200c00ULL, 0x0000541057577816ULL, 0x008fe2000000005cULL,
0x00000100245c7824ULL, 0x040fe400078e00ffULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000005600647306ULL, 0x0004e20000200c00ULL,
0x0000541067147816ULL, 0x002fce000000006aULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000541066567816ULL, 0x004fe2000000005bULL, 0x000000144028723cULL, 0x040b6c0000001828ULL,
0x0000001600617306ULL, 0x0005e40000200c00ULL, 0x000000564030723cULL, 0x000b6c0000001830ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x011000000014783bULL, 0x024ea20000000200ULL,
0x0000010025567824ULL, 0x040fe200078e00ffULL, 0x0000888025577816ULL, 0x000fc800000000ffULL,
0x00000018ff667819ULL, 0x000fe20000011456ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000018ff567819ULL, 0x000fe40000011424ULL, 0x0000541063247816ULL, 0x008fe20000000064ULL,
0x0001000025637824ULL, 0x000fe200078e00ffULL, 0x000054105f257816ULL, 0x002fc60000000065ULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe40000011463ULL,
0x0000888026637816ULL, 0x000fe200000000ffULL, 0x000000244020723cULL, 0x000b680000001820ULL,
0x0000004f004f7306ULL, 0x000fe60000200c00ULL, 0x0000541061247816ULL, 0x020fe20000000055ULL,
0x000000ffff557224ULL, 0x000fe200078e0063ULL, 0x0000541062257816ULL, 0x002fc60000000058ULL,
0x0000005300537306ULL, 0x000e680000200c00ULL, 0x000000244038723cULL, 0x000b680000001838ULL,
0x0000003500357306ULL, 0x000ee20000200c00ULL, 0x0000000a14148232ULL, 0x084fe40000000000ULL,
0x0000000a16168232ULL, 0x000fe20000000000ULL, 0x0000010026247824ULL, 0x020fe200078e00ffULL,
0x0000000b15158232ULL, 0x000fe20000000000ULL, 0x0000888027427816ULL, 0x000fc400000000ffULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000000b17178232ULL, 0x000fe20000000000ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000541053257816ULL, 0x002fc80000000054ULL, 0x0000002400417306ULL, 0x0003e20000200c00ULL,
0x000054105a587816ULL, 0x008fe40000000035ULL, 0x00000018ff437819ULL, 0x000fca0000011426ULL,
0x0000001200127306ULL, 0x000fe20000200c00ULL, 0x000054104f247816ULL, 0x002fe40000000050ULL,
0x0000541059597816ULL, 0x004fca000000004aULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x00000024141c723cULL, 0x040b6e000000181cULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000010027257824ULL, 0x060fe200078e00ffULL, 0x00000058142c723cULL, 0x000b62000000182cULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011425ULL,
0x00000018ff4a7819ULL, 0x000fe20000011427ULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x000054104d4d7816ULL, 0x002fe40000000046ULL, 0x0000541047257816ULL, 0x004fca0000000012ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000176c805127811ULL, 0x000fce00078e18ffULL,
0x0000005e005b7306ULL, 0x000ff00000200c00ULL, 0x0000005500407306ULL, 0x000ea20000200c00ULL,
0x000054105d247816ULL, 0x002fce0000000011ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000241424723cULL, 0x000b6e000000183cULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541040407816ULL, 0x004fce0000000041ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x000054104b4c7816ULL, 0x002fce000000004cULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x0000004c1418723cULL, 0x000b6e0000001818ULL, 0x0000005700577306ULL, 0x000ff00000200c00ULL,
0x00000066005e7306ULL, 0x000ea20000200c00ULL, 0x000054105b5c7816ULL, 0x002fce000000005cULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x00005410575d7816ULL, 0x004fce000000005eULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541056447816ULL, 0x002fe20000000044ULL, 0x0000005c1428723cULL, 0x000b6c0000001828ULL,
0x0000003500357306ULL, 0x000e620000200c00ULL, 0x000054105f457816ULL, 0x008fce0000000045ULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x000000441430723cULL, 0x000b6e0000001830ULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x0000541042417816ULL, 0x002fce0000000035ULL,
0x0000004300467306ULL, 0x000e620000200c00ULL, 0x000000401420723cULL, 0x000b6e0000001820ULL,
0x0000004a00477306ULL, 0x000ea20000200c00ULL, 0x0000541046467816ULL, 0x002fe40000000013ULL,
0x0000541047477816ULL, 0x004fce0000000034ULL, 0x000000461414723cULL, 0x000b620000001838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176880060ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff117224ULL, 0x000fc600078e00ffULL,
0x0000000000347805ULL, 0x000fc80000015200ULL, 0x0000040007397984ULL, 0x020ee40000000800ULL,
0x8000000039ff7812ULL, 0x00afe40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040007397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002137824ULL, 0x000fe400078e00ffULL, 0x000059000e0e7a24ULL, 0x010fc600078e02ffULL,
0xffffffe013117812ULL, 0x000fe200078ec0ffULL, 0x000000800e0e7824ULL, 0x000fc800078e00ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000008011127810ULL, 0x000fc80007ffe0ffULL,
0x0000006012117812ULL, 0x000fca00078ec0ffULL, 0x000000016e3a7824ULL, 0x000fe200078e0211ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000001269117217ULL, 0x000fe40007800000ULL,
0x0000001013347812ULL, 0x000fe400078ec0ffULL, 0x00000003ff137819ULL, 0x000fe20000011603ULL,
0x0000000111117824ULL, 0x000fc600078e0a12ULL, 0x0000000413387810ULL, 0x040fe20007ffe0ffULL,
0x0000000113127824ULL, 0x140fe200078e0234ULL, 0x0000001134117217ULL, 0x000fe40007800000ULL,
0x0000000c13397810ULL, 0x000fe20007ffe0ffULL, 0x0000000112357824ULL, 0x040fe400078e0203ULL,
0x00000008123c7824ULL, 0x040fe400078e00ffULL, 0x0000000111117824ULL, 0x000fe400078e0a34ULL,
0x0000000112127824ULL, 0x000fe200078e023aULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee235ULL,
0x00000001393f7824ULL, 0x000fe200078e0234ULL, 0x0000000813357810ULL, 0x000fc40007ffe0ffULL,
0x000000113800720cULL, 0x0c0fe20003f66070ULL, 0x0000000138387824ULL, 0x100fe200078e0234ULL,
0x000000111300720cULL, 0x080fe20003f86070ULL, 0x000000013f417824ULL, 0x100fe200078e0203ULL,
0x000000113500720cULL, 0x0c0fe20003f46070ULL, 0x0000000135357824ULL, 0x000fe200078e0234ULL,
0x000000113900720cULL, 0x000fe20003f06070ULL, 0x0000000138137824ULL, 0x140fe400078e0203ULL,
0x00000008383e7824ULL, 0x000fe400078e00ffULL, 0x0000000135117824ULL, 0x000fc400078e0203ULL,
0x0000000835407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee211ULL,
0x0000000138347824ULL, 0x100fe200078e023aULL, 0x000064000e117a11ULL, 0x000fe200078a38ffULL,
0x0000000135387824ULL, 0x100fe200078e023aULL, 0x0000005112127212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000065000e3d7a11ULL, 0x000fe400028f3cffULL,
0x0000001211127210ULL, 0x000fe20007fbe0ffULL, 0x000000013f3a7824ULL, 0x000fe200078e023aULL,
0x0000005134347212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005138387212ULL, 0x000fc600078efcffULL,
0x0000000113137824ULL, 0x000fe200028e063dULL, 0x0000001134347210ULL, 0x000fe20007fbe0ffULL,
0x000000083f427824ULL, 0x000fe200078e00ffULL, 0x000000513a3a7212ULL, 0x000fe200078efcffULL,
0x00000010403f7824ULL, 0x000fe400078e026bULL, 0x0000000135357824ULL, 0x000fe200028e063dULL,
0x0000001138387210ULL, 0x080fe40007fbe0ffULL, 0x000000113a3a7210ULL, 0x000fe20007fde0ffULL,
0x000000103c117824ULL, 0x000fe200078e026bULL, 0xfffffff842427812ULL, 0x000fe200078ee241ULL,
0x0000000139397824ULL, 0x000fc400028e063dULL, 0x000000013b3b7824ULL, 0x000fe200030e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e2000e101c48ULL,
0x000000103e3d7824ULL, 0x100fe400078e026bULL, 0x0000001042417824ULL, 0x000fc600078e026bULL,
0x00000000343d7faeULL, 0x0003e8000d901c48ULL, 0x00000000383f7faeULL, 0x0003e8000d101c48ULL,
0x000000003a417faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001013127812ULL, 0x000fc800078ec0ffULL, 0x0000001203117211ULL, 0x000fc800078fe8ffULL,
0x0000000411347810ULL, 0x040fe20007ffe0ffULL, 0x0000000111137824ULL, 0x040fe200078e0203ULL,
0x0000000c11357810ULL, 0x040fe20007ffe0ffULL, 0x00000008113e7824ULL, 0x040fe400078e00ffULL,
0x0000000111127824ULL, 0x140fe400078e023aULL, 0x00000001343c7824ULL, 0x000fe200078e023aULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000000834407824ULL, 0x040fe200078e00ffULL,
0x0000000811137810ULL, 0x000fe20007ffe0ffULL, 0x0000000134117824ULL, 0x000fc400078e0203ULL,
0x0000000135397824ULL, 0x000fe400078e0203ULL, 0x0000000113387824ULL, 0x040fe200078e023aULL,
0xfffffff840407812ULL, 0x000fe200078ee211ULL, 0x0000000113347824ULL, 0x040fe200078e0203ULL,
0x000064000e117a11ULL, 0x040fe200078038ffULL, 0x00000008133b7824ULL, 0x000fe400078e00ffULL,
0x0000000835447824ULL, 0x000fe200078e00ffULL, 0x000065000e3f7a11ULL, 0x000fe200000f3cffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83b427812ULL, 0x000fc400078ee234ULL,
0xfffffff844447812ULL, 0x000fe200078ee239ULL, 0x00000001353a7824ULL, 0x000fe200078e023aULL,
0x0000005112347212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0x0000003411347210ULL, 0x000fe20007f1e0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000513c127212ULL, 0x000fc600078efcffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005138387212ULL, 0x080fe400078efcffULL, 0x0000001211127210ULL, 0x000fe20007f5e0ffULL,
0x0000000113357824ULL, 0x000fe200000e063fULL, 0x000000513a3a7212ULL, 0x000fe200078efcffULL,
0x0000001044417824ULL, 0x000fe200078e026bULL, 0x0000003811387210ULL, 0x000fe20007f1e0ffULL,
0x000000013d137824ULL, 0x000fe200010e063fULL, 0x0000003a113a7210ULL, 0x000fe20007f7e0ffULL,
0x000000103e117824ULL, 0x000fc400078e026bULL, 0x0000000139397824ULL, 0x100fe400000e063fULL,
0x000000013b3b7824ULL, 0x000fe200018e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034117faeULL, 0x0003e2000b901c48ULL, 0x00000010403d7824ULL, 0x100fe400078e026bULL,
0x00000010423f7824ULL, 0x000fc600078e026bULL, 0x00000000123d7faeULL, 0x0003e8000b901c48ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e4000b901c48ULL,
0x0000000802117824ULL, 0x002fca00078e00ffULL, 0xfffffff011117812ULL, 0x000fc800078ec0ffULL,
0x00000000110573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000176a805057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80011127f8cULL, 0x0002e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280008347f8cULL, 0x0002a4000c80043fULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01762c0008117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x006fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc8000001143bULL,
0x0000003a11117211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000211117819ULL, 0x000fc8000000123aULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c0008117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002117824ULL, 0x000fca00078e00ffULL, 0xffffff8011347812ULL, 0x000fc800078ec0ffULL,
0x0000008051347810ULL, 0x000fca0007ffe034ULL, 0x0000000171347824ULL, 0x000fca00078e0234ULL,
0x0170000034387984ULL, 0x000e680000000800ULL, 0x0172000034117984ULL, 0x0004e20000000800ULL,
0x0000000f3800720bULL, 0x002fe20003f1d000ULL, 0x0000f4027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x004fc800000e0100ULL, 0x0000ffff403c7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000170357810ULL, 0x000fe40007ffe0ffULL,
0x0000000f3800720bULL, 0x000fe40003f54000ULL, 0x000000023500720cULL, 0x000fe20003f05270ULL,
0x0000f3c27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000397806ULL, 0x000fc400010e0100ULL,
0x00000080023a8824ULL, 0x000fe200078e0251ULL, 0x0000000f38348209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991039357816ULL, 0x000fe200000000ffULL,
0x00000001713b8824ULL, 0x000fca00078e023aULL, 0x017400343b008388ULL, 0x0003e20000000800ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f38347209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff39ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f34347221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003b7308ULL, 0x000e640000000800ULL,
0x0000003b10107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011603ULL, 0x0000f2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x000000401c1c7220ULL, 0x084fe40000410000ULL,
0x000000401d1d7220ULL, 0x080fe40000410000ULL, 0x000000402c2c7220ULL, 0x080fe40000410000ULL,
0x000000402d2d7220ULL, 0x000fc40000410000ULL, 0x0000004018187220ULL, 0x080fe40000410000ULL,
0x0000004019197220ULL, 0x080fe40000410000ULL, 0x0000004024247220ULL, 0x080fe40000410000ULL,
0x0000004025257220ULL, 0x080fe40000410000ULL, 0x0000004028287220ULL, 0x080fe40000410000ULL,
0x0000004029297220ULL, 0x000fc40000410000ULL, 0x0000004030307220ULL, 0x080fe40000410000ULL,
0x0000004031317220ULL, 0x080fe40000410000ULL, 0x0000004020207220ULL, 0x080fe40000410000ULL,
0x0000004021217220ULL, 0x080fe40000410000ULL, 0x0000004014147220ULL, 0x080fe40000410000ULL,
0x0000004015157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803347811ULL, 0x002fe200078ff0ffULL, 0x0000f1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x000000401e1e7220ULL, 0x084fe40000410000ULL,
0x000000401f1f7220ULL, 0x080fe40000410000ULL, 0x000000402e2e7220ULL, 0x080fe40000410000ULL,
0x000000402f2f7220ULL, 0x080fe40000410000ULL, 0x000000401a1a7220ULL, 0x080fe40000410000ULL,
0x000000401b1b7220ULL, 0x000fc40000410000ULL, 0x0000004026267220ULL, 0x080fe40000410000ULL,
0x0000004027277220ULL, 0x080fe40000410000ULL, 0x000000402a2a7220ULL, 0x080fe40000410000ULL,
0x000000402b2b7220ULL, 0x080fe40000410000ULL, 0x0000004032327220ULL, 0x080fe40000410000ULL,
0x0000004033337220ULL, 0x000fc40000410000ULL, 0x0000004022227220ULL, 0x080fe40000410000ULL,
0x0000004023237220ULL, 0x080fe40000410000ULL, 0x0000004016167220ULL, 0x080fe40000410000ULL,
0x0000004017177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe20007806039ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000f380f7209ULL, 0x000fd60007810000ULL, 0x8000000f38380221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL,
0x0000003800090308ULL, 0x000e640000000800ULL, 0x0000000911110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011107221ULL, 0x008fc40000010000ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x0000000802117824ULL, 0x000fca00078e00ffULL,
0xfffffff0113b7812ULL, 0x000fca00078ec0ffULL, 0x0176b4003b117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003834387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e35ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011439ULL, 0x0000003811117211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000211117819ULL, 0x000fc80000001238ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b4003b117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103a117816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000009ff0a723eULL, 0x000fe400000000ffULL,
0x00000002ff367819ULL, 0x000fe40000011603ULL, 0x000054100a117816ULL, 0x000fe2000000000aULL,
0x0000edc27f007947ULL, 0x000fea000b800000ULL, 0x00001f36110a7589ULL, 0x0002a400000e0000ULL,
0x0000000836347810ULL, 0x000fe20007ffe0ffULL, 0x0000ee127f007947ULL, 0x000fea000b800000ULL,
0x00001f34110b7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001036347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x0000588000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000f86000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001836347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0011ULL, 0x000058f000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x004fc400078e00ffULL,
0x0000f7f000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000010006b117810ULL, 0x00afca0007ffe0ffULL,
0x0000001048387824ULL, 0x100fe400078e0211ULL, 0x000000100d3c7824ULL, 0x100fe400078e0211ULL,
0x000000100c407824ULL, 0x104fe400078e0211ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000001049447824ULL, 0x000fc600078e0211ULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x0000010038347824ULL, 0x042fe200078e00ffULL, 0x00008880385f7816ULL, 0x000fe200000000ffULL,
0x00010000395a7824ULL, 0x040fe200078e00ffULL, 0x0000888039607816ULL, 0x000fc400000000ffULL,
0x00000018ff587819ULL, 0x000fe20000011434ULL, 0x0001000038347824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011438ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff5b7819ULL, 0x000fe40000011439ULL, 0x00000018ff5d7819ULL, 0x000fe20000011434ULL,
0x0000010039347824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145aULL,
0x000088803a5a7816ULL, 0x000fe200000000ffULL, 0x0000005800387306ULL, 0x0002e20000200c00ULL,
0x00000018ff597819ULL, 0x000fc40000011434ULL, 0x011800004e34783bULL, 0x000f220000000200ULL,
0x00000018ff677819ULL, 0x000fe4000001143aULL, 0x00000018ff647819ULL, 0x000fe4000001143bULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000001003a587824ULL, 0x042fe200078e00ffULL,
0x00000018ff547819ULL, 0x004fe20000011441ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe4000001143cULL, 0x00000018ff627819ULL, 0x000fc40000011458ULL,
0x0000005900397306ULL, 0x0002a20000200c00ULL, 0x000054105f387816ULL, 0x008fe40000000038ULL,
0x000088803b587816ULL, 0x040fe400000000ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000088803c5f7816ULL, 0x000fe200000000ffULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000001003b597824ULL, 0x042fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe2000001143dULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc4000001143eULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000541060397816ULL, 0x004fe20000000039ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x000001003c607824ULL, 0x040fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe2000001143fULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011442ULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000000a34348232ULL, 0x090fe20000000000ULL,
0x00000018ff537819ULL, 0x000fe20000011440ULL, 0x0000000a36368232ULL, 0x000fe20000000000ULL,
0x00000018ff4d7819ULL, 0x000fe20000011443ULL, 0x0000000b35358232ULL, 0x080fe20000000000ULL,
0x00000018ff4b7819ULL, 0x000fe20000011444ULL, 0x0000000b37378232ULL, 0x000fe20000000000ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x00000018ff4a7819ULL, 0x000fc40000011445ULL,
0x00000018ff507819ULL, 0x000fe40000011446ULL, 0x00000018ff4f7819ULL, 0x000fe20000011447ULL,
0x00000038341c723cULL, 0x000be4000000181cULL, 0x0000005a005a7306ULL, 0x000fea0000200c00ULL,
0x000001003d387824ULL, 0x020fe200078e00ffULL, 0x000054105e397816ULL, 0x002fc4000000005bULL,
0x0000006200627306ULL, 0x000fe40000200c00ULL, 0x00000018ff387819ULL, 0x000fcc0000011438ULL,
0x0000003800657306ULL, 0x0003f00000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054105d387816ULL, 0x002fe2000000005cULL, 0x000001003e5d7824ULL, 0x040fe200078e00ffULL,
0x000088803e5c7816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145dULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00000038342c723cULL, 0x000be2000000182cULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x000088803f5d7816ULL, 0x000fc800000000ffULL, 0x000001003f387824ULL, 0x060fe200078e00ffULL,
0x0000003a006c7306ULL, 0x000fe20000200c00ULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005f003a7306ULL, 0x000fe20000200c00ULL, 0x0000541058397816ULL, 0x002fe40000000059ULL,
0x0000888041597816ULL, 0x000fca00000000ffULL, 0x00000038005f7306ULL, 0x0003f00000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054105a387816ULL, 0x002fce0000000062ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000000383418723cULL, 0x000b6e0000001818ULL,
0x0000003b006a7306ULL, 0x0002e20000200c00ULL, 0x0000010041387824ULL, 0x060fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff397819ULL, 0x000fe20000011441ULL, 0x0000006000637306ULL, 0x000f220000200c00ULL,
0x000088803d3b7816ULL, 0x042fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x00000038005a7306ULL, 0x0005f00000200c00ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x000054106c387816ULL, 0x004fce0000000067ULL,
0x0000003900677306ULL, 0x0007f00000200c00ULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x000054106a397816ULL, 0x008fce0000000064ULL, 0x000000383424723cULL, 0x000b620000001824ULL,
0x00000100403c7824ULL, 0x004fe200078e00ffULL, 0x0000006100617306ULL, 0x000ea80000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000010043387824ULL, 0x020fc600078e00ffULL,
0x0000005700577306ULL, 0x000fe40000200c00ULL, 0x00000018ff397819ULL, 0x000fe20000011438ULL,
0x0001000042387824ULL, 0x000fca00078e00ffULL, 0x0000003d00607306ULL, 0x0006620000200c00ULL,
0x00000018ff647819ULL, 0x000fe40000011438ULL, 0x000054103a387816ULL, 0x010fca0000000063ULL,
0x0000005c005b7306ULL, 0x000fe20000200c00ULL, 0x00008880403d7816ULL, 0x048fe200000000ffULL,
0x0001000040407824ULL, 0x000fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000003e005c7306ULL, 0x0007f00000200c00ULL, 0x0000003c00587306ULL, 0x0009e20000200c00ULL,
0x00000100423e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003f00627306ULL, 0x0007e20000200c00ULL, 0x00008880423c7816ULL, 0x010fce00000000ffULL,
0x0000003900427306ULL, 0x0003e20000200c00ULL, 0x00008880443f7816ULL, 0x008fce00000000ffULL,
0x0000003e00417306ULL, 0x0005e20000200c00ULL, 0x000054103b397816ULL, 0x002fce0000000065ULL,
0x000000383428723cULL, 0x000b620000001828ULL, 0x00005410663e7816ULL, 0x004fe20000000061ULL,
0x011800000038783bULL, 0x0202a20000000200ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000010044617824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000003f00007306ULL, 0x0023e20000200c00ULL,
0x00000018ff447819ULL, 0x000fce0000011444ULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x00005410603f7816ULL, 0x002fe40000000057ULL, 0x0000888045577816ULL, 0x000fca00000000ffULL,
0x0000003e3430723cULL, 0x000b620000001830ULL, 0x0000005500557306ULL, 0x000e6c0000200c00ULL,
0x00000100453e7824ULL, 0x020fe200078e00ffULL, 0x000054105d3f7816ULL, 0x008fe2000000005fULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0001000045457824ULL, 0x000fc400078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc6000001143eULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000000a38388232ULL, 0x084fe20000000000ULL, 0x0000003e00607306ULL, 0x0005e20000200c00ULL,
0x0000000a3a3a8232ULL, 0x000fe40000000000ULL, 0x0000000b39398232ULL, 0x080fe40000000000ULL,
0x0000000b3b3b8232ULL, 0x000fc60000000000ULL, 0x0000004000687306ULL, 0x0009e20000200c00ULL,
0x000054105b3e7816ULL, 0x004fe4000000005eULL, 0x00008880465b7816ULL, 0x000fca00000000ffULL,
0x0000003e3420723cULL, 0x000b620000001820ULL, 0x0000888043407816ULL, 0x050fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x0000003d003d7306ULL, 0x000ea80000200c00ULL,
0x000054105c3e7816ULL, 0x022fe20000000055ULL, 0x000000ffff557224ULL, 0x000fe200078e005bULL,
0x00005410623f7816ULL, 0x008fe40000000056ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x00000018ff437819ULL, 0x000fc80000011443ULL, 0x0000003e3414723cULL, 0x000b660000001814ULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x000054103d587816ULL, 0x004fc60000000058ULL,
0x0000010046357824ULL, 0x060fe200078e00ffULL, 0x0000888047367816ULL, 0x040fe200000000ffULL,
0x0000010047377824ULL, 0x040fe400078e00ffULL, 0x0000004300637306ULL, 0x000fe20000200c00ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000054103c3c7816ULL, 0x002fe40000000041ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x00005410403d7816ULL, 0x008fc40000000042ULL,
0x00000018ff477819ULL, 0x000fca0000011447ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000003c3818723cULL, 0x000b6e0000001818ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541068667816ULL, 0x002fce0000000053ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0000541067677816ULL, 0x004fce0000000054ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00000066382c723cULL, 0x000f6e000000182cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00005410634d7816ULL, 0x002fce000000004dULL, 0x0000005900597306ULL, 0x000e700000200c00ULL,
0x0000006400647306ULL, 0x000eb00000200c00ULL, 0x0000006100437306ULL, 0x000ee20000200c00ULL,
0x0000541059597816ULL, 0x002fce000000005aULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x00005410644c7816ULL, 0x004fe2000000004cULL, 0x00000058381c723cULL, 0x040f6c000000181cULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x0000541000567816ULL, 0x008fe20000000043ULL,
0x0000004c3824723cULL, 0x000f620000001824ULL, 0x0000000202007824ULL, 0x000fca00078e00ffULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x0000541057577816ULL, 0x002fce0000000060ULL,
0x0000005500347306ULL, 0x000fe20000200c00ULL, 0x0000541044447816ULL, 0x004fe2000000004bULL,
0x000000563828723cULL, 0x000f6c0000001828ULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x0000541045457816ULL, 0x008fce000000004aULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000443830723cULL, 0x000f6e0000001830ULL, 0x0000003700377306ULL, 0x000ea20000200c00ULL,
0x0000541034347816ULL, 0x002fce0000000035ULL, 0x0000005000507306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000541036357816ULL, 0x004fe40000000037ULL,
0xfffffff800367812ULL, 0x000fca00078ec0ffULL, 0x00000046003d7306ULL, 0x020e620000200c00ULL,
0x000000343820723cULL, 0x000b6e0000001820ULL, 0x00000047003c7306ULL, 0x000ea20000200c00ULL,
0x000054103d347816ULL, 0x022fe40000000050ULL, 0x000054103c357816ULL, 0x004fce000000004fULL,
0x000000343814723cULL, 0x000b6e0000001814ULL, 0x000176c805347811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000034347f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900036ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff007224ULL, 0x000fc600078e00ffULL, 0x0000000000367805ULL, 0x004fc80000015200ULL,
0x0000040007397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x006fc40007804835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038363b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e37ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000100007810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040007397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010006367824ULL, 0x000fca00078e027aULL,
0x000000c036347810ULL, 0x000fc80007ffe0ffULL, 0x0000006034357812ULL, 0x000fca00078ec0ffULL,
0x000000016e3c7824ULL, 0x000fe200078e0235ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000003469007217ULL, 0x000fe20007800000ULL, 0x0000001002357824ULL, 0x000fc800078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a34ULL, 0x0000001035357812ULL, 0x000fe400078ec0ffULL,
0x00000003ff347819ULL, 0x000fe40000011603ULL, 0x0000000035007217ULL, 0x000fe40007800000ULL,
0x0000000434377810ULL, 0x040fe40007ffe0ffULL, 0x0000000834387810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a35ULL, 0x0000000c34397810ULL, 0x000fc60007ffe0ffULL,
0x00000001383a7824ULL, 0x100fe200078e0235ULL, 0x000000003400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x100fe200078e0235ULL, 0x000000003700720cULL, 0x0c0fe20003f66070ULL,
0x0000000137377824ULL, 0x100fe200078e0235ULL, 0x000000003800720cULL, 0x080fe20003f46070ULL,
0x0000000139417824ULL, 0x040fe200078e0235ULL, 0x000000003900720cULL, 0x000fe20003f06070ULL,
0x0000000134007824ULL, 0x040fe400078e0203ULL, 0x0000000834397824ULL, 0x000fc400078e00ffULL,
0x0000000137357824ULL, 0x140fe400078e0203ULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0xfffffff839007812ULL, 0x000fe200078ee200ULL, 0x0000000134347824ULL, 0x000fe400078e023cULL,
0x000000013a397824ULL, 0x000fe200078e0203ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL,
0x000000083a407824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee239ULL, 0x0000000137387824ULL, 0x100fe200078e023cULL,
0x000064000e377a11ULL, 0x000fe200078a38ffULL, 0x000000013a3a7824ULL, 0x100fe200078e023cULL,
0x0000005134347212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000065000e3f7a11ULL, 0x000fe400028f3cffULL, 0x0000003734347210ULL, 0x000fe20007fbe0ffULL,
0x00000001413c7824ULL, 0x000fe200078e023cULL, 0x0000005138387212ULL, 0x000fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fc800078e00ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000513a3a7212ULL, 0x000fc600078efcffULL, 0x0000000135357824ULL, 0x000fe200028e063fULL,
0x0000003738387210ULL, 0x000fe20007fbe0ffULL, 0x00000001410e7824ULL, 0x040fe200078e0203ULL,
0x000000513c3c7212ULL, 0x000fe200078efcffULL, 0x0000000841417824ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x000fe200028e063fULL, 0x000000373a3a7210ULL, 0x080fe40007fbe0ffULL,
0x000000373c3c7210ULL, 0x000fe20007fde0ffULL, 0x0000001000377824ULL, 0x000fe200078e0211ULL,
0xfffffff8410e7812ULL, 0x000fe200078ee20eULL, 0x000000013b3b7824ULL, 0x000fc400028e063fULL,
0x000000013d3d7824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e2000e101c48ULL, 0x000000103e3f7824ULL, 0x100fe400078e0211ULL,
0x0000001040417824ULL, 0x100fe400078e0211ULL, 0x000000100e437824ULL, 0x000fe200078e0211ULL,
0x00000000383f7faeULL, 0x0003e8000d901c48ULL, 0x000000003a417faeULL, 0x0003e8000d101c48ULL,
0x000000003c437faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002007824ULL, 0x000fca00078e00ffULL, 0x0000001000007812ULL, 0x000fc800078ec0ffULL,
0x0000000003007211ULL, 0x000fc800078fe8ffULL, 0x0000000400377810ULL, 0x040fe20007ffe0ffULL,
0x0000000100357824ULL, 0x040fe200078e0203ULL, 0x0000000c00387810ULL, 0x040fe20007ffe0ffULL,
0x0000000800407824ULL, 0x040fe400078e00ffULL, 0x0000000100347824ULL, 0x100fe400078e023cULL,
0x00000001373e7824ULL, 0x040fe200078e023cULL, 0xfffffff840407812ULL, 0x000fe200078ee235ULL,
0x00000008373b7824ULL, 0x040fe200078e00ffULL, 0x0000000800357810ULL, 0x000fe20007ffe0ffULL,
0x0000000137007824ULL, 0x000fc400078e0203ULL, 0x0000000138397824ULL, 0x100fe400078e0203ULL,
0x0000000135377824ULL, 0x000fe200078e0203ULL, 0xfffffff83b007812ULL, 0x000fe200078ee200ULL,
0x0000000835427824ULL, 0x040fe400078e00ffULL, 0x00000001353a7824ULL, 0x100fe400078e023cULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe400078ee237ULL,
0x000064000e377a11ULL, 0x000fe200078038ffULL, 0x00000001383c7824ULL, 0x000fc400078e023cULL,
0x0000000838447824ULL, 0x000fe200078e00ffULL, 0x0000005134387212ULL, 0x000fe200078efcffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000065000e417a11ULL, 0x000fe400000f3cffULL,
0x0000003738387210ULL, 0x000fe20007f1e0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x000000513e347212ULL, 0x080fe400078efcffULL, 0xfffffff844447812ULL, 0x000fe200078ee239ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x000000513a3a7212ULL, 0x000fc400078efcffULL,
0x0000003734347210ULL, 0x000fe20007f5e0ffULL, 0x0000000135397824ULL, 0x000fe200000e0641ULL,
0x000000513c3c7212ULL, 0x000fe200078efcffULL, 0x0000001044437824ULL, 0x000fe200078e0211ULL,
0x000000373a3a7210ULL, 0x080fe20007f1e0ffULL, 0x000000013f357824ULL, 0x000fe200010e0641ULL,
0x000000373c3c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001040377824ULL, 0x000fe400078e0211ULL,
0x000000013b3b7824ULL, 0x100fe400000e0641ULL, 0x000000013d3d7824ULL, 0x000fe200018e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000b901c48ULL,
0x00000010003f7824ULL, 0x000fc400078e0211ULL, 0x0000001042417824ULL, 0x000fc600078e0211ULL,
0x00000000343f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e8000b901c48ULL,
0x000000003c437faeULL, 0x0003e4000b901c48ULL, 0x00000000750573c2ULL, 0x000ea200000e0000ULL,
0x0000000204047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff007424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000720400720cULL, 0x000fda0003f06070ULL,
0x0000000104348824ULL, 0x000fe400078e026fULL, 0x00000004ff358424ULL, 0x000fe200078e00ffULL,
0x000176b005057890ULL, 0x004fc6000fffe03fULL, 0x0000660034348625ULL, 0x000fca00078e0035ULL,
0x0000000834008981ULL, 0x000322000c1e1900ULL, 0x00000008020e7824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a05ULL, 0xfffffff00e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b0000e387f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176480008347f8cULL, 0x0022a4000c80043fULL, 0x00000000003a7805ULL, 0x000fc40000015200ULL,
0x01764c0008377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x006fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fcc0000015200ULL, 0x0000003c3a377210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3c7824ULL, 0x000fe200000e0e3bULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001143cULL,
0x000000370e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e063cULL,
0x000000020e0e7819ULL, 0x000fc80000001237ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c0008377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002087824ULL, 0x000fca00078e00ffULL, 0xffffff8008087812ULL, 0x000fc800078ec0ffULL,
0x0000010051087810ULL, 0x000fca0007ffe008ULL, 0x0000000171087824ULL, 0x000fca00078e0208ULL,
0x01700000080e7984ULL, 0x000e680000000800ULL, 0x0172000008377984ULL, 0x0004e20000000800ULL,
0x0000000f0e00720bULL, 0x002fe20003f1d000ULL, 0x0000d0427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x004fc800000e0100ULL, 0x0000ffff403b7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e000fULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000270357810ULL, 0x000fe40007ffe0ffULL, 0x0000000f0e00720bULL, 0x000fe40003f54000ULL,
0x000000023500720cULL, 0x000fe20003f05270ULL, 0x0000cff27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x00000080023a8824ULL, 0x000fe200078e0251ULL,
0x0000000f0e348209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991008357816ULL, 0x000fe200000000ffULL, 0x00000001713d8824ULL, 0x000fca00078e023aULL,
0x017400343d008388ULL, 0x0003e20000000800ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000f0e347209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000f34347221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000e640000000800ULL, 0x0000003d10107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x000fe20000011603ULL,
0x0000cf227f007947ULL, 0x000fea000b800000ULL, 0x00001f343d407589ULL, 0x0002a400000e0000ULL,
0x000000401c1c7220ULL, 0x084fe40000410000ULL, 0x000000401d1d7220ULL, 0x080fe40000410000ULL,
0x000000402c2c7220ULL, 0x080fe40000410000ULL, 0x000000402d2d7220ULL, 0x000fc40000410000ULL,
0x0000004018187220ULL, 0x080fe40000410000ULL, 0x0000004019197220ULL, 0x080fe40000410000ULL,
0x0000004024247220ULL, 0x080fe40000410000ULL, 0x0000004025257220ULL, 0x080fe40000410000ULL,
0x0000004028287220ULL, 0x080fe40000410000ULL, 0x0000004029297220ULL, 0x000fc40000410000ULL,
0x0000004030307220ULL, 0x080fe40000410000ULL, 0x0000004031317220ULL, 0x080fe40000410000ULL,
0x0000004020207220ULL, 0x080fe40000410000ULL, 0x0000004021217220ULL, 0x080fe40000410000ULL,
0x0000004014147220ULL, 0x080fe40000410000ULL, 0x0000004015157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803347811ULL, 0x002fe200078ff0ffULL,
0x0000ce227f007947ULL, 0x000fea000b800000ULL, 0x00001f343d407589ULL, 0x0002a400000e0000ULL,
0x000000401e1e7220ULL, 0x084fe40000410000ULL, 0x000000401f1f7220ULL, 0x080fe40000410000ULL,
0x000000402e2e7220ULL, 0x080fe40000410000ULL, 0x000000402f2f7220ULL, 0x080fe40000410000ULL,
0x000000401a1a7220ULL, 0x080fe40000410000ULL, 0x000000401b1b7220ULL, 0x000fc40000410000ULL,
0x0000004026267220ULL, 0x080fe40000410000ULL, 0x0000004027277220ULL, 0x080fe40000410000ULL,
0x000000402a2a7220ULL, 0x080fe40000410000ULL, 0x000000402b2b7220ULL, 0x080fe40000410000ULL,
0x0000004032327220ULL, 0x080fe40000410000ULL, 0x0000004033337220ULL, 0x000fc40000410000ULL,
0x0000004022227220ULL, 0x080fe40000410000ULL, 0x0000004023237220ULL, 0x080fe40000410000ULL,
0x0000004016167220ULL, 0x080fe40000410000ULL, 0x0000004017177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806008ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000f0e087209ULL, 0x000fd60007810000ULL,
0x800000080e0e0221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00090308ULL, 0x000e640000000800ULL,
0x0000000937370220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001037107221ULL, 0x008fc40000010000ULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0x0000000802347824ULL, 0x000fca00078e00ffULL, 0xfffffff0343b7812ULL, 0x000fca00078ec0ffULL,
0x0176ac003b357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x000000340e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e0fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac003b357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a0e7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000009ff0a723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011603ULL,
0x000054100a0e7816ULL, 0x000fe2000000000aULL, 0x0000c9f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e0a7589ULL, 0x0002a400000e0000ULL, 0x000000080f347810ULL, 0x000fe20007ffe0ffULL,
0x0000ca427f007947ULL, 0x000fea000b800000ULL, 0x00001f340e0b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e000eULL, 0x00007eb000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000d23000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x00007f2000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x004fc400078e00ffULL, 0x0000d1c000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010483c7824ULL, 0x100fe200078e026bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000100d447824ULL, 0x100fe400078e026bULL,
0x000000100c407824ULL, 0x104fe400078e026bULL, 0x000000003c3c783bULL, 0x000ea20000004200ULL,
0x00000010490c7824ULL, 0x000fc600078e026bULL, 0x000000004444783bULL, 0x000ee80000004200ULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x000000000c0c783bULL, 0x00ae620000004200ULL,
0x00000018ff597819ULL, 0x004fe2000001143cULL, 0x000001003c4c7824ULL, 0x040fe200078e00ffULL,
0x000088803c507816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe2000001143dULL, 0x000001003d547824ULL, 0x040fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000010046567824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000088803d577816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011454ULL, 0x00000018ff377819ULL, 0x000fe4000001143eULL,
0x00000018ff617819ULL, 0x000fe2000001143fULL, 0x0000003c00657306ULL, 0x0005e20000200c00ULL,
0x000088803e547816ULL, 0x000fe400000000ffULL, 0x000088803f557816ULL, 0x040fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff4f7819ULL, 0x000fe20000011444ULL,
0x0000004c00637306ULL, 0x0006620000200c00ULL, 0x000001003f3c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011445ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00008880445f7816ULL, 0x000fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003d00627306ULL, 0x0005e20000200c00ULL, 0x000001003e4c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00008880455b7816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe4000001144cULL,
0x0000003c004c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x00000100443d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011446ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fc40000011447ULL,
0x00000018ff667819ULL, 0x000fe2000001143dULL, 0x0000003e00677306ULL, 0x000fe20000200c00ULL,
0x00000100453c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x0000888046587816ULL, 0x040fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001143cULL,
0x0000003f00647306ULL, 0x0005e20000200c00ULL, 0x00000018ff457819ULL, 0x000fc40000011445ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff497819ULL, 0x000fe40000011441ULL,
0x00000018ff487819ULL, 0x000fe20000011440ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x012000004e3c783bULL, 0x0044e20000000200ULL, 0x00000018ff3b7819ULL, 0x000fe40000011443ULL,
0x00000018ff3a7819ULL, 0x000fe40000011442ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x00008880474e7816ULL, 0x004fe400000000ffULL,
0x00000018ff137819ULL, 0x002fe4000001140cULL, 0x00000018ff127819ULL, 0x000fe4000001140dULL,
0x00000018ff357819ULL, 0x000fe2000001140eULL, 0x00000044005c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x000fce000001140fULL, 0x00000045005d7306ULL, 0x0007e20000200c00ULL,
0x0000541050447816ULL, 0x002fe20000000063ULL, 0x0000010047507824ULL, 0x040fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000541057457816ULL, 0x008fe4000000005aULL,
0x00000018ff477819ULL, 0x000fca0000011447ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x0000000a3c3c8232ULL, 0x080fe40000000000ULL, 0x0000000a3e3e8232ULL, 0x000fe40000000000ULL,
0x0000000b3d3d8232ULL, 0x080fe40000000000ULL, 0x0000000b3f3f8232ULL, 0x000fe20000000000ULL,
0x0000004600637306ULL, 0x0005ec0000200c00ULL, 0x000000443c1c723cULL, 0x000be4000000181cULL,
0x0000004700607306ULL, 0x0007e20000200c00ULL, 0x0000888041467816ULL, 0x004fc800000000ffULL,
0x0000010040447824ULL, 0x020fe200078e00ffULL, 0x0000541062457816ULL, 0x002fe40000000053ULL,
0x0000004e00577306ULL, 0x0003e20000200c00ULL, 0x0000010041477824ULL, 0x048fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x00008880404e7816ULL, 0x042fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc80000011441ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006800687306ULL, 0x000e700000200c00ULL, 0x0000005500557306ULL, 0x000eb00000200c00ULL,
0x00000050005a7306ULL, 0x000ee20000200c00ULL, 0x0000541054547816ULL, 0x002fce0000000068ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x0000541055557816ULL, 0x004fce000000004cULL,
0x0000004400507306ULL, 0x0005e20000200c00ULL, 0x000000543c18723cULL, 0x000be20000001818ULL,
0x0000541057577816ULL, 0x008fcc000000005aULL, 0x0000003700377306ULL, 0x000ee20000200c00ULL,
0x0000541065447816ULL, 0x004fe40000000059ULL, 0x000088800c557816ULL, 0x020fca00000000ffULL,
0x0000004100627306ULL, 0x0005e20000200c00ULL, 0x000000443c2c723cULL, 0x000b6e000000182cULL,
0x0000004000657306ULL, 0x0003e20000200c00ULL, 0x0000010043417824ULL, 0x004fe200078e00ffULL,
0x0000000703447812ULL, 0x020fc400078ec0ffULL, 0x0000888042457816ULL, 0x040fe400000000ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004700597306ULL, 0x0005e20000200c00ULL,
0x0000010042407824ULL, 0x002fe200078e00ffULL, 0x0000000844447812ULL, 0x000fe200078ef803ULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0x00000041004c7306ULL, 0x0003e20000200c00ULL,
0x0000888043477816ULL, 0x044fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fca0000011442ULL, 0x0000004600537306ULL, 0x000fe20000200c00ULL,
0x0000541064417816ULL, 0x002fe40000000061ULL, 0x00000018ff617819ULL, 0x000fe20000011443ULL,
0x0000020002437824ULL, 0x000fc800078e00ffULL, 0x0000004000467306ULL, 0x0007e20000200c00ULL,
0xfffff80043687812ULL, 0x000fce00078ec0ffULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000541067407816ULL, 0x008fe40000000037ULL, 0x0000000252377810ULL, 0x000fc80007ffe0ffULL,
0xfffffff844377812ULL, 0x000fe200078ee237ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x000000ffff447224ULL, 0x000fc600078e0055ULL, 0x0000001037557824ULL, 0x000fc800078e0268ULL,
0x0000005b005b7306ULL, 0x000ff00000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105f547816ULL, 0x002fe20000000066ULL, 0x000001000c5f7824ULL, 0x000fc400078e00ffULL,
0x000100000c0c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001145fULL,
0x0000004200647306ULL, 0x0003e20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000000403c40723cULL, 0x002b640000001824ULL,
0x012000005524783bULL, 0x02046a0000000200ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x000054105b557816ULL, 0x004fe4000000005eULL, 0x000088800d5e7816ULL, 0x000fca00000000ffULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000000543c28723cULL, 0x000bee0000001828ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000001000d547824ULL, 0x020fe200078e00ffULL,
0x000054105d557816ULL, 0x008fe2000000004dULL, 0x000100000d0d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000018ff0d7819ULL, 0x000fce000001140dULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x0000000a24248232ULL, 0x082fe40000000000ULL, 0x0000000a26268232ULL, 0x000fe40000000000ULL,
0x0000000b25258232ULL, 0x000fc60000000000ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x0000000b27278232ULL, 0x000fce0000000000ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x0000541058567816ULL, 0x004fce0000000056ULL, 0x00000054005f7306ULL, 0x0005e20000200c00ULL,
0x0000541065487816ULL, 0x002fe20000000048ULL, 0x000000563c20723cULL, 0x000fec0000001820ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x000054105c547816ULL, 0x004fe2000000004fULL,
0x000001000e4f7824ULL, 0x000fe200078e00ffULL, 0x0000541062497816ULL, 0x008fca0000000049ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x000000543c30723cULL, 0x000b6e0000001830ULL,
0x0000000c004d7306ULL, 0x0007e20000200c00ULL, 0x000088800e557816ULL, 0x060fe200000000ffULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x0000541045467816ULL, 0x002fe20000000046ULL,
0x00000048242c723cULL, 0x000fe8000000182cULL, 0x0000000d00547306ULL, 0x0003e20000200c00ULL,
0x00005410630c7816ULL, 0x008fe2000000004bULL, 0x000000ffff4b7224ULL, 0x000fe200078e0055ULL,
0x0000541047477816ULL, 0x004fca000000004cULL, 0x0000003a003a7306ULL, 0x000ea20000200c00ULL,
0x00005410600d7816ULL, 0x002fe2000000004aULL, 0x000000462418723cULL, 0x000fec0000001818ULL,
0x0000003b003b7306ULL, 0x000fe40000200c00ULL, 0x0000000c3c14723cULL, 0x000b6c0000001814ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x000088800f3e7816ULL, 0x060fe200000000ffULL,
0x000001000f0c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001144fULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fc4000001140eULL,
0x00000018ff487819ULL, 0x000fe2000001140cULL, 0x0000004b003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff457819ULL, 0x000fe4000001140fULL, 0x00005410643a7816ULL, 0x004fe4000000003aULL,
0x00005410534f7816ULL, 0x000fc60000000059ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x00005410613b7816ULL, 0x002fce000000003bULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x0000003a240c723cULL, 0x000b6e0000001840ULL, 0x0000001200127306ULL, 0x000ee20000200c00ULL,
0x000054103c3c7816ULL, 0x004fce000000003dULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x000054104d3a7816ULL, 0x022fce0000000013ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x00005410543b7816ULL, 0x008fe40000000012ULL, 0x0001769870127811ULL, 0x000fca00078e18ffULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x0000003a2430723cULL, 0x000f6e0000001830ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x00000066005b7306ULL, 0x000ea20000200c00ULL,
0x000054104e4e7816ULL, 0x002fce0000000050ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000004e241c723cULL, 0x000f6e000000181cULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x004fce000000005bULL, 0x0000004800497306ULL, 0x000e700000200c00ULL,
0x0000003f00467306ULL, 0x000eb00000200c00ULL, 0x0000004500477306ULL, 0x0006e20000200c00ULL,
0x000054103e3d7816ULL, 0x002fc40000000049ULL, 0x0000541046467816ULL, 0x004fca0000000035ULL,
0x0000003c2420723cULL, 0x000f620000001820ULL, 0x000054105e457816ULL, 0x008fe4000000005fULL,
0x0000541047477816ULL, 0x000fca0000000034ULL, 0x000000442428723cULL, 0x040f700000001828ULL,
0x000000462414723cULL, 0x000b6e0000001814ULL, 0x000176c805267811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000026267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000012ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff347224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x004fc80000015200ULL,
0x0000040007257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc40007804827ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000002412357210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e13ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000003524247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040007257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000106127810ULL, 0x000fc80007ffe0ffULL,
0x0000006d1200720cULL, 0x000fda0003f06070ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x0000000206127810ULL, 0x000fe20007ffe0ffULL, 0x0000590000077a24ULL, 0x010fe200078e02ffULL,
0x0000010036367810ULL, 0x000fe40007ffe0ffULL, 0x0000006d1200720cULL, 0x000fe20003f06070ULL,
0x0000008007077824ULL, 0x000fe200078e00ffULL, 0x0000006036137812ULL, 0x000fca00078ec0ffULL,
0x000000016e137824ULL, 0x000fcc00078e0213ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000003669127217ULL, 0x000fe20007800000ULL, 0x0000001002247824ULL, 0x000fc800078e00ffULL,
0x0000000112127824ULL, 0x000fe200078e0a36ULL, 0x0000001024257812ULL, 0x000fe400078ec0ffULL,
0x00000003ff247819ULL, 0x000fe40000011603ULL, 0x0000001225127217ULL, 0x000fe40007800000ULL,
0x0000000424267810ULL, 0x040fe40007ffe0ffULL, 0x0000000824277810ULL, 0x000fe20007ffe0ffULL,
0x0000000112127824ULL, 0x100fe200078e0a25ULL, 0x0000000c24357810ULL, 0x000fe20007ffe0ffULL,
0x0000000126347824ULL, 0x000fc400078e0225ULL, 0x00000001273c7824ULL, 0x140fe200078e0225ULL,
0x000000122400720cULL, 0x0c0fe20003f86070ULL, 0x0000000124247824ULL, 0x000fe200078e0225ULL,
0x000000122600720cULL, 0x080fe20003f66070ULL, 0x00000008343a7824ULL, 0x000fe200078e00ffULL,
0x000000122700720cULL, 0x080fe20003f46070ULL, 0x0000000124267824ULL, 0x140fe200078e0203ULL,
0x000000123500720cULL, 0x000fe20003f06070ULL, 0x00000008243b7824ULL, 0x000fe400078e00ffULL,
0x0000000134277824ULL, 0x000fc400078e0203ULL, 0x00000001353e7824ULL, 0x000fe200078e0225ULL,
0xfffffff83b367812ULL, 0x000fe200078ee226ULL, 0x0000000124267824ULL, 0x000fe200078e0213ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee227ULL, 0x0000000134347824ULL, 0x100fe200078e0213ULL,
0x00006400073b7a11ULL, 0x040fe200078a38ffULL, 0x000000013c127824ULL, 0x100fe400078e0213ULL,
0x000000013e247824ULL, 0x040fe200078e0213ULL, 0x0000650007077a11ULL, 0x000fe200028f3cffULL,
0x000000013e137824ULL, 0x000fc400078e0203ULL, 0x000000013c257824ULL, 0x000fe400078e0203ULL,
0x000000083e3e7824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000005126267212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee225ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000005134347212ULL, 0x000fe400078efcffULL, 0x000000263b267210ULL, 0x000fe20007fbe0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000003b34347210ULL, 0x000fe40007fde0ffULL,
0x0000005112127212ULL, 0x080fe200078efcffULL, 0x0000000127277824ULL, 0x100fe200028e0607ULL,
0x0000005124247212ULL, 0x000fe200078efcffULL, 0x0000000135357824ULL, 0x000fe200030e0607ULL,
0x0000003b12127210ULL, 0x080fe20007fbe0ffULL, 0x000000103a3d7824ULL, 0x100fe200078e026bULL,
0x0000003b24247210ULL, 0x000fe20007fde0ffULL, 0x00000010363b7824ULL, 0x000fc400078e026bULL,
0x000000103c3f7824ULL, 0x000fe400078e026bULL, 0x0000000113137824ULL, 0x000fe200028e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263b7faeULL, 0x0003e2000e101c48ULL,
0x000000103e6b7824ULL, 0x000fe400078e026bULL, 0x0000000125257824ULL, 0x000fe200030e0607ULL,
0x00000000343d7faeULL, 0x0003e8000d901c48ULL, 0x00000000123f7faeULL, 0x0003e8000d101c48ULL,
0x00000000246b7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002127824ULL, 0x000fe200078e00ffULL, 0x00006400073b7a11ULL, 0x000fc800078038ffULL,
0x0000001012127812ULL, 0x000fe400078ec0ffULL, 0x0000650007077a11ULL, 0x000fe400000f3cffULL,
0x0000001203127211ULL, 0x000fc800078fe8ffULL, 0x0000000412267810ULL, 0x040fe20007ffe0ffULL,
0x0000000112247824ULL, 0x040fe200078e0203ULL, 0x00000008123a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000812257824ULL, 0x040fe200078e00ffULL, 0x0000000c123c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000112347824ULL, 0x100fe400078e0213ULL, 0x0000000126127824ULL, 0x040fe200078e0213ULL,
0xfffffff825367812ULL, 0x000fe200078ee224ULL, 0x0000000126257824ULL, 0x040fe400078e0203ULL,
0x00000008263e7824ULL, 0x000fc400078e00ffULL, 0x000000013a267824ULL, 0x100fe400078e0213ULL,
0x000000013c247824ULL, 0x000fe400078e0213ULL, 0x000000013a137824ULL, 0x040fe400078e0203ULL,
0x000000083a407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3a7812ULL, 0x000fe200078ee225ULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000013c277824ULL, 0x000fe200078e0203ULL,
0x0000005134347212ULL, 0x080fe200078efcffULL, 0x000000083c427824ULL, 0x000fe200078e00ffULL,
0xfffffff8403c7812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000343b347210ULL, 0x000fe40007f1e0ffULL, 0xfffffff8423e7812ULL, 0x000fe200078ee227ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000005112127212ULL, 0x000fc600078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000005126267212ULL, 0x000fc600078efcffULL,
0x0000000135357824ULL, 0x000fe200000e0607ULL, 0x0000005124247212ULL, 0x000fe200078efcffULL,
0x000000103a3d7824ULL, 0x100fe200078e026bULL, 0x000000123b127210ULL, 0x040fe20007f1e0ffULL,
0x000000103c3f7824ULL, 0x100fe200078e026bULL, 0x000000263b267210ULL, 0x040fe40007f5e0ffULL,
0x000000243b247210ULL, 0x000fe20007f7e0ffULL, 0x00000010363b7824ULL, 0x000fe400078e026bULL,
0x0000000113137824ULL, 0x000fc400000e0607ULL, 0x0000000127277824ULL, 0x000fe200010e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343b7faeULL, 0x0003e2000b901c48ULL,
0x000000103e6b7824ULL, 0x000fe400078e026bULL, 0x0000000125257824ULL, 0x000fe200018e0607ULL,
0x00000000123d7faeULL, 0x0003e8000b901c48ULL, 0x00000000263f7faeULL, 0x0003e8000b901c48ULL,
0x00000000246b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001005077824ULL, 0x000fc400078e00ffULL, 0x0000000802127824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001007077812ULL, 0x000fe400078ee2ffULL,
0x0000000812127812ULL, 0x000fc600078ec0ffULL, 0x0000002070077824ULL, 0x000fc800078e0207ULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80075127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176680007347f8cULL, 0x000662000c80043fULL,
0x000000ffff127224ULL, 0x004fc600078e0013ULL, 0x0000000000247805ULL, 0x000fc80000015200ULL,
0x01766c0007137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011427ULL,
0x0000002613137211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000213137819ULL, 0x000fc80000001226ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c0007137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018070247811ULL, 0x000fc800078e38ffULL, 0x0000002471247210ULL, 0x000fca0007ffe051ULL,
0x0170000024077984ULL, 0x008e680000000800ULL, 0x0172000024257984ULL, 0x0004e20000000800ULL,
0x000000080700720bULL, 0x002fe20003f1d000ULL, 0x0000ac027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x004fc800000e0100ULL, 0x0000ffff40367812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fd200078e0008ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000370137810ULL, 0x000fe40007ffe0ffULL, 0x000000080700720bULL, 0x000fe40003f54000ULL,
0x000000021300720cULL, 0x000fe20003f05270ULL, 0x0000abb27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000137806ULL, 0x000fc400010e0100ULL, 0x0000008002268824ULL, 0x000fe200078e0251ULL,
0x0000000807248209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000171718824ULL, 0x000fe200078e0226ULL, 0x0000991013267816ULL, 0x000fc800000000ffULL,
0x0174002471008388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000807277209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff13ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000827247221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x0000002400277308ULL, 0x000e640000000800ULL, 0x0000002710107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x000fe20000011603ULL,
0x0000aae27f007947ULL, 0x000fea000b800000ULL, 0x00001f3427407589ULL, 0x0002a400000e0000ULL,
0x000000401c1c7220ULL, 0x084fe40000410000ULL, 0x000000401d1d7220ULL, 0x080fe40000410000ULL,
0x000000402c2c7220ULL, 0x080fe40000410000ULL, 0x000000402d2d7220ULL, 0x000fc40000410000ULL,
0x0000004018187220ULL, 0x080fe40000410000ULL, 0x0000004019197220ULL, 0x080fe40000410000ULL,
0x000000400c0c7220ULL, 0x080fe40000410000ULL, 0x000000400d0d7220ULL, 0x080fe40000410000ULL,
0x0000004028287220ULL, 0x080fe40000410000ULL, 0x0000004029297220ULL, 0x000fc40000410000ULL,
0x0000004030307220ULL, 0x080fe40000410000ULL, 0x0000004031317220ULL, 0x080fe40000410000ULL,
0x0000004020207220ULL, 0x080fe40000410000ULL, 0x0000004021217220ULL, 0x080fe40000410000ULL,
0x0000004014147220ULL, 0x080fe40000410000ULL, 0x0000004015157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0013ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803347811ULL, 0x002fe200078ff0ffULL,
0x0000a9e27f007947ULL, 0x000fea000b800000ULL, 0x00001f3427407589ULL, 0x0002a400000e0000ULL,
0x000000401e1e7220ULL, 0x084fe40000410000ULL, 0x000000401f1f7220ULL, 0x080fe40000410000ULL,
0x000000402e2e7220ULL, 0x080fe40000410000ULL, 0x000000402f2f7220ULL, 0x080fe40000410000ULL,
0x000000401a1a7220ULL, 0x080fe40000410000ULL, 0x000000401b1b7220ULL, 0x000fc40000410000ULL,
0x000000400e0e7220ULL, 0x080fe40000410000ULL, 0x000000400f0f7220ULL, 0x080fe40000410000ULL,
0x000000402a2a7220ULL, 0x080fe40000410000ULL, 0x000000402b2b7220ULL, 0x080fe40000410000ULL,
0x0000004032327220ULL, 0x080fe40000410000ULL, 0x0000004033337220ULL, 0x000fc40000410000ULL,
0x0000004022227220ULL, 0x080fe40000410000ULL, 0x0000004023237220ULL, 0x080fe40000410000ULL,
0x0000004016167220ULL, 0x080fe40000410000ULL, 0x0000004017177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806013ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000000807137209ULL, 0x000fd60007810000ULL,
0x8000001307070221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b07070820ULL, 0x000fc80000410000ULL, 0x0000000700090308ULL, 0x000e640000000800ULL,
0x0000000925250220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001025107221ULL, 0x008fc40000010000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x0176b40075277984ULL, 0x000e620000000800ULL, 0x0000000402077824ULL, 0x000fe400078e00ffULL,
0x0000000476087824ULL, 0x000fc600078e00ffULL, 0x0000000407357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e00ffULL, 0x0000000235357810ULL, 0x000fe40007ffe0ffULL,
0x8000000027ff7812ULL, 0x002fe20007804839ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e0035ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026243b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000003b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000107077810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176b40075277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff267224ULL, 0x000fc400078e0035ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991034077816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000009ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff247819ULL, 0x000fe40000011603ULL,
0x0000541007077816ULL, 0x000fe20000000007ULL, 0x0000a5527f007947ULL, 0x000fea000b800000ULL,
0x00001f24070a7589ULL, 0x0002a400000e0000ULL, 0x0000000824347810ULL, 0x000fe20007ffe0ffULL,
0x0000a5a27f007947ULL, 0x000fea000b800000ULL, 0x00001f34070b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001024347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0007ULL, 0x0000a5b000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000ab3000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001824347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0007ULL,
0x0000a62000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x004fc400078e00ffULL, 0x0000aac000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000703357812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000003704b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000835077812ULL, 0x00afe400078ef803ULL, 0x0000000803347812ULL, 0x000fe200078ec0ffULL,
0x000008004b4b7824ULL, 0x000fe400078e00ffULL, 0x0000000807077824ULL, 0x000fca00078e00ffULL,
0xfffffff8074a7812ULL, 0x000fca00078ee252ULL, 0x000000104a4a7824ULL, 0x000fc400078e024bULL,
0x0000000803257211ULL, 0x040fe400078fe0ffULL, 0x0000003534247212ULL, 0x040fe400078efcffULL,
0x0000002603277211ULL, 0x000fe400078fe0ffULL, 0x0000001034347812ULL, 0x000fe200078efe35ULL,
0x0000000124077824ULL, 0x040fe400078e0225ULL, 0x0000000824087824ULL, 0x000fe400078e00ffULL,
0x0000000834267824ULL, 0x000fc600078e00ffULL, 0xfffffff808087812ULL, 0x000fe200078ee207ULL,
0x0000000124077824ULL, 0x040fe400078e0227ULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000001008087824ULL, 0x000fc600078e0211ULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x0000000134077824ULL, 0x000fe200078e0225ULL, 0x00000000083c783bULL, 0x0002e60000004200ULL,
0x0000001024247824ULL, 0x000fe200078e0211ULL, 0xfffffff826267812ULL, 0x000fe200078ee207ULL,
0x0000000134077824ULL, 0x000fc600078e0227ULL, 0x000000002440783bULL, 0x004ea20000004200ULL,
0x0000001026267824ULL, 0x000fe400078e0211ULL, 0x0000000834087824ULL, 0x002fc600078e00ffULL,
0x000000002638783bULL, 0x000e640000004200ULL, 0xfffffff808087812ULL, 0x000fca00078ee207ULL,
0x0000001008087824ULL, 0x000fca00078e0211ULL, 0x000000000824783bULL, 0x000e620000004200ULL,
0x00000018ff5e7819ULL, 0x008fe2000001143cULL, 0x000001003c487824ULL, 0x040fe200078e00ffULL,
0x000088803c607816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001143dULL, 0x000001003d497824ULL, 0x040fe200078e00ffULL,
0x000088803d5f7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x00000018ff487819ULL, 0x000fc40000011448ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff547819ULL, 0x000fe4000001143eULL, 0x00000018ff557819ULL, 0x000fe2000001143fULL,
0x0000003c006a7306ULL, 0x0007e20000200c00ULL, 0x000088803e647816ULL, 0x000fe400000000ffULL,
0x000088803f637816ULL, 0x000fe400000000ffULL, 0x00000018ff507819ULL, 0x004fc40000011440ULL,
0x00008880405b7816ULL, 0x040fe200000000ffULL, 0x0000003d00687306ULL, 0x0005e20000200c00ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe20000011441ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011442ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000048006b7306ULL, 0x0006620000200c00ULL,
0x00000100403d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00008880415a7816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x000001003e487824ULL, 0x008fe200078e00ffULL, 0x0000888042537816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003d005c7306ULL, 0x0007e20000200c00ULL,
0x00000100413c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x002fc40000011438ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00617306ULL, 0x000fe20000200c00ULL,
0x00000100423d7824ULL, 0x048fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011439ULL,
0x00000018ff527819ULL, 0x000fe4000001143dULL, 0x0000003c005d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x00000018ff477819ULL, 0x000fe40000011443ULL,
0x0000888043517816ULL, 0x040fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000003f00577306ULL, 0x0005e20000200c00ULL, 0x00000100433c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe2000001143aULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x00000018ff567819ULL, 0x000fc4000001143cULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x011000004a3c783bULL, 0x004e620000000200ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff077819ULL, 0x000fe40000011426ULL,
0x00000018ff087819ULL, 0x000fe40000011427ULL, 0x00000049006c7306ULL, 0x0004e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe40000011424ULL, 0x00000018ff347819ULL, 0x000fca0000011425ULL,
0x0000004000597306ULL, 0x0007e20000200c00ULL, 0x0000888038497816ULL, 0x004fce00000000ffULL,
0x0000004100587306ULL, 0x0005e20000200c00ULL, 0x0000010038407824ULL, 0x048fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000042004d7306ULL, 0x0007e20000200c00ULL, 0x0000888039417816ULL, 0x004fe400000000ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000003800627306ULL, 0x0005e20000200c00ULL,
0x0000010039427824ULL, 0x048fe200078e00ffULL, 0x0000000a3c3c8232ULL, 0x082fe20000000000ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x0000000a3e3e8232ULL, 0x000fe40000000000ULL,
0x0000000b3d3d8232ULL, 0x080fe20000000000ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000000b3f3f8232ULL, 0x000fe20000000000ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541060387816ULL, 0x004fce000000006bULL,
0x0000003900607306ULL, 0x0003f00000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054105f397816ULL, 0x002fce000000006cULL, 0x000000383c1c723cULL, 0x000b62000000181cULL,
0x0000006400647306ULL, 0x000fec0000200c00ULL, 0x000001003b387824ULL, 0x020fe200078e00ffULL,
0x0000541068397816ULL, 0x004fe20000000067ULL, 0x0000004800657306ULL, 0x000e660000200c00ULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000006300637306ULL, 0x000eb00000200c00ULL,
0x0000004000487306ULL, 0x0007f00000200c00ULL, 0x00000041004a7306ULL, 0x0003e20000200c00ULL,
0x000088803a407816ULL, 0x008fce00000000ffULL, 0x00000043004e7306ULL, 0x000fe20000200c00ULL,
0x000001003a417824ULL, 0x042fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fca00078e00ffULL,
0x0000003800437306ULL, 0x0003e20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe4000001143aULL,
0x00008880243a7816ULL, 0x000fca00000000ffULL, 0x00000042004c7306ULL, 0x0007e20000200c00ULL,
0x000054106a387816ULL, 0x002fe2000000005eULL, 0x000000ffff677224ULL, 0x000fe400078e003aULL,
0x00000010373a7824ULL, 0x000fe400078e024bULL, 0x00000100244b7824ULL, 0x000fe400078e00ffULL,
0x000000383c2c723cULL, 0x000b62000000182cULL, 0x00000018ff427819ULL, 0x008fe20000011441ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000088803b417816ULL, 0x040fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fc4000001144bULL,
0x0000541064387816ULL, 0x020fe40000000065ULL, 0x0000541063397816ULL, 0x004fe20000000066ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000888025637816ULL, 0x000fc600000000ffULL, 0x000000383c18723cULL, 0x000b640000001818ULL,
0x0000003b005e7306ULL, 0x0007e20000200c00ULL, 0x0000541061547816ULL, 0x002fe20000000054ULL,
0x0000010025617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x011000003a38783bULL, 0x028ee20000000200ULL,
0x0000541057557816ULL, 0x004fe20000000055ULL, 0x000000ffff577224ULL, 0x000fca00078e0063ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000000543c0c723cULL, 0x000b6e000000180cULL,
0x0000005000507306ULL, 0x000ee20000200c00ULL, 0x000054105b547816ULL, 0x022fce000000005cULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000054105a557816ULL, 0x004fe2000000005dULL,
0x00010000245a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x000000543c28723cULL, 0x000b6e0000001828ULL,
0x0000004700477306ULL, 0x000ea20000200c00ULL, 0x0000541059547816ULL, 0x028fe20000000050ULL,
0x0000000a38388232ULL, 0x080fe20000000000ULL, 0x0000541058557816ULL, 0x002fe2000000004fULL,
0x0000000a3a3a8232ULL, 0x000fe20000000000ULL, 0x00010000254f7824ULL, 0x000fe200078e00ffULL,
0x0000000b39398232ULL, 0x000fc40000000000ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054104d467816ULL, 0x004fe20000000046ULL, 0x0000000b3b3b8232ULL, 0x000fe20000000000ULL,
0x000000543c30723cULL, 0x000f620000001830ULL, 0x00000018ff4f7819ULL, 0x000fc8000001144fULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x000054104e477816ULL, 0x000fce0000000047ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000463c14723cULL, 0x000fee0000001814ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x0000541053507816ULL, 0x002fce0000000052ULL,
0x0000004900497306ULL, 0x000e700000200c00ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000541051517816ULL, 0x004fce0000000056ULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000541049487816ULL, 0x002fe20000000048ULL, 0x000000503c20723cULL, 0x000b620000001820ULL,
0x000054104a497816ULL, 0x000fe4000000004cULL, 0x0000541062447816ULL, 0x008fc80000000044ULL,
0x00000100263c7824ULL, 0x060fe200078e00ffULL, 0x00008880273d7816ULL, 0x000fe200000000ffULL,
0x00000048381c723cULL, 0x000b62000000181cULL, 0x0000888026507816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0000541060457816ULL, 0x004fe20000000045ULL,
0x000000ffff4d7224ULL, 0x000fe200078e0050ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x000000ffff487224ULL, 0x020fc400078e003dULL, 0x00000100273d7824ULL, 0x040fe400078e00ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000044382c723cULL, 0x000b62000000182cULL,
0x0000004d00467306ULL, 0x000fe60000200c00ULL, 0x00000018ff277819ULL, 0x000fc60000011427ULL,
0x00000018ff447819ULL, 0x020fe4000001143dULL, 0x0000003c00477306ULL, 0x000e700000200c00ULL,
0x0000003600367306ULL, 0x000eb00000200c00ULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0000541046467816ULL, 0x002fce0000000047ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000054105e3d7816ULL, 0x004fce0000000036ULL, 0x0000004000407306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000e700000200c00ULL, 0x0000004100417306ULL, 0x000eb00000200c00ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x0000541040407816ULL, 0x002fce0000000042ULL,
0x0000006700377306ULL, 0x000fe20000200c00ULL, 0x0000541041417816ULL, 0x004fce0000000043ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000054105f3c7816ULL, 0x008fe20000000035ULL,
0x000000403818723cULL, 0x040f6c0000001818ULL, 0x0000005700577306ULL, 0x000fe40000200c00ULL,
0x0000003c383c723cULL, 0x000b6c000000180cULL, 0x0000006100247306ULL, 0x000ea20000200c00ULL,
0x0000541037567816ULL, 0x002fc4000000004bULL, 0x00000004050c7810ULL, 0x020fc80007ffe0ffULL,
0x000176a80c0c7811ULL, 0x000fe200078e18ffULL, 0x0000005a00257306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x0000541057577816ULL, 0x004fce0000000024ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00005410254e7816ULL, 0x002fe20000000011ULL,
0x000000563828723cULL, 0x000b6c0000001828ULL, 0x0000004400457306ULL, 0x000e620000200c00ULL,
0x000054104f4f7816ULL, 0x008fce0000000034ULL, 0x0000000700077306ULL, 0x000fe20000200c00ULL,
0x0000004e3830723cULL, 0x000b6e0000001830ULL, 0x0000000800087306ULL, 0x000fe20000200c00ULL,
0x0000541048477816ULL, 0x002fce0000000045ULL, 0x0000002600267306ULL, 0x000e620000200c00ULL,
0x000000463820723cULL, 0x000b6e0000001820ULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x0000541026267816ULL, 0x002fe40000000007ULL, 0x0000541027277816ULL, 0x004fce0000000008ULL,
0x000000263838723cULL, 0x000b620000001814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x0000000106067810ULL, 0x000fe40007ffe0ffULL,
0x000176a070077811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff087224ULL, 0x002fe200078e000dULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff617000007947ULL, 0x000fea000383ffffULL,
0x000000ff6d00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000010007810ULL, 0x010fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b7f000047802ULL, 0x000fc40000000f00ULL,
0x0000973000007944ULL, 0x02efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001000037308ULL, 0x000f240000001000ULL, 0xbf80000003007423ULL, 0x010fc80000000010ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000087919ULL, 0x000ee40000000000ULL,
0x00000002ff077819ULL, 0x00efc40000011604ULL, 0x0000000808097811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x010fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0906047589ULL, 0x000ea200000e0000ULL, 0x0000001c001c7220ULL, 0x042fe40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x000fc40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000003c003c7220ULL, 0x040fe40000410000ULL,
0x0000003d003d7220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x060fe40000410000ULL,
0x0000002900297220ULL, 0x000fc40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x000fc40000410000ULL, 0x0000001e041e7220ULL, 0x044fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000003e043e7220ULL, 0x040fe40000410000ULL,
0x0000003f043f7220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000303130723eULL, 0x020fe400000000ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001a1b1a723eULL, 0x000fc400000000ffULL,
0x0000003e3f0d723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x000076321a0f7816ULL, 0x000fe4000000000dULL, 0x000000323315723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fe400000000ffULL, 0x000000ff0500720cULL, 0x000fc40003f05270ULL,
0x0000000203007812ULL, 0x052fe400078ec0ffULL, 0x0000000803097811ULL, 0x000fe400078ff0ffULL,
0x00000002ff077819ULL, 0x00cfe40000011603ULL, 0x0000000900047211ULL, 0x040fe200078ff8ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000000700027211ULL, 0x000fe200078ff8ffULL,
0x00000008070b7824ULL, 0x040fe400078e00ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8090e7812ULL, 0x000fe200078ee204ULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0xfffffff80b087812ULL, 0x000fe200078ee200ULL,
0x0000100076007824ULL, 0x000fe200078e00ffULL, 0x0000000402067810ULL, 0x040fe40007ffe0ffULL,
0xfffffff809047812ULL, 0x000fe200078ee202ULL, 0x0000080005077824ULL, 0x000fe200078e0200ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0a7812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e0207ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0207ULL,
0x0000001c1d02723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0207ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x000000100c0c7824ULL, 0x000fc400078e0207ULL,
0x0000000106077824ULL, 0x000fe200078e0209ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x0000000109087824ULL, 0x040fe200078e0208ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x000000181902723eULL, 0x000fe200000000ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x0000003c3d04723eULL, 0x000fe200000000ffULL,
0x0000001007007388ULL, 0x0003e20000000a00ULL, 0x000000282906723eULL, 0x000fe200000000ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x0000541002127816ULL, 0x000fc40000000004ULL,
0x0000763202137816ULL, 0x000fe40000000004ULL, 0x0000001e1f02723eULL, 0x000fe400000000ffULL,
0x0000002e2f04723eULL, 0x000fe200000000ffULL, 0x0000001208007388ULL, 0x0005e20000000a00ULL,
0x000076322a097816ULL, 0x000fe40000000015ULL, 0x000000383910723eULL, 0x002fe400000000ffULL,
0x0000003a3b11723eULL, 0x000fc400000000ffULL, 0x0000763220077816ULL, 0x000fe40000000010ULL,
0x0000541006127816ULL, 0x144fe40000000030ULL, 0x0000763206137816ULL, 0x000fe40000000030ULL,
0x0000541020067816ULL, 0x000fc60000000010ULL, 0x000000120a007388ULL, 0x0003e80000000a00ULL,
0x000000060c007388ULL, 0x0005e20000000a00ULL, 0x0000541002127816ULL, 0x142fe40000000004ULL,
0x0000763202137816ULL, 0x000fe20000000004ULL, 0x000000017a077824ULL, 0x004fc800078e0203ULL,
0x000000120e007388ULL, 0x0003e20000000a00ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000054101a0e7816ULL, 0x002fca000000000dULL, 0x0004000e08007388ULL, 0x0003e40000000a00ULL,
0x000054102a087816ULL, 0x002fe40000000015ULL, 0x00005410220e7816ULL, 0x140fe40000000011ULL,
0x00007632220f7816ULL, 0x000fe20000000011ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000007107984ULL, 0x000e680000000c00ULL, 0x0004000007187984ULL, 0x000ea80000000c00ULL,
0x0008000007147984ULL, 0x000ee80000000c00ULL, 0x000c0000071c7984ULL, 0x000ee20000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x004fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x008fe40000000000ULL, 0x0000001612127230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000001007007388ULL, 0x000fe20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001807007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x000000780900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000174027824ULL, 0x000fe200078e0209ULL, 0x00005a00ff107a12ULL, 0x000fcc00078e33ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x004fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x0000000705117227ULL, 0x000fc800078e0004ULL, 0x0000000109047824ULL, 0x000fe400078e0203ULL,
0x0000000211077227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0ffffff804057812ULL, 0x000fe400078ef803ULL, 0x00005a00ff007a0cULL, 0x000fc60003f05070ULL,
0x0000001005067824ULL, 0x000fca00078e0200ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000107071810ULL, 0x000fc80007ffe0ffULL, 0x0000000710047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e0273ULL,
0x00005a0007027a24ULL, 0x000fe200078e0202ULL, 0x0000000703077812ULL, 0x000fc600078ec0ffULL,
0x00005a0005027a24ULL, 0x000fe400078e0202ULL, 0x0000000876077824ULL, 0x000fc600078e0207ULL,
0x0000000279057210ULL, 0x000fe40007f3e0ffULL, 0x0000002003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000780d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000174047824ULL, 0x102fe400078e020dULL, 0x00000001020d7824ULL, 0x000fe400078e020dULL,
0x0000000411057227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef802ULL,
0x00005a0007067a24ULL, 0x000fc800078e0204ULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x00005a0006007a0cULL, 0x000fca0003f26070ULL, 0x000000000d0c7984ULL, 0x000e700000000c00ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fc40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0273ULL, 0x0000004003067810ULL, 0x000fe20007ffe0ffULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x00000003ff097819ULL, 0x000fe20000011606ULL, 0x00005a0005047a24ULL, 0x000fe400078e0204ULL,
0x0000000876077824ULL, 0x000fc600078e0207ULL, 0x0000000479057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4408ULL, 0x000000780900720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000174027824ULL, 0x100fe400078e0209ULL,
0x0000000106097824ULL, 0x000fe400078e0209ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a04ULL,
0x0ffffff809097812ULL, 0x000fe200078ef806ULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x00005a0005007a0cULL, 0x000fca0003f26070ULL,
0x0000000009087984ULL, 0x000e700000000c00ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fc40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000410047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe200078e0273ULL,
0x0000006003047810ULL, 0x000fe20007ffe0ffULL, 0x00005a0007027a24ULL, 0x000fc800078e0202ULL,
0x00005a0005027a24ULL, 0x000fe200078e0202ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x0000000279077210ULL, 0x000fe20007f3e0ffULL, 0x0000000876057824ULL, 0x000fc800078e0205ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007027a11ULL, 0x000fc800078240ffULL,
0x00005f0007037a11ULL, 0x000fe400008f440cULL, 0x00000003ff077819ULL, 0x000fc60000011604ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x000000780700720cULL, 0x000fc60003f26070ULL,
0x0000000174747824ULL, 0x000fe200078e0207ULL, 0x0000000802007986ULL, 0x0023f2000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007411027227ULL, 0x002fe200078e00ffULL,
0x0000000704057812ULL, 0x000fc600078ec0ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x00005a0003037a24ULL, 0x000fe400078e0274ULL,
0x0000000876057824ULL, 0x000fe200078e0205ULL, 0x0000000707077812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0xfffffff807077812ULL, 0x000fca00078ef804ULL,
0x0000001007077824ULL, 0x000fca00078e0200ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fda0003f46070ULL, 0x0000000102022810ULL, 0x000fc80007ffe0ffULL,
0x0000000210027207ULL, 0x000fca0004000000ULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x0000590002737a24ULL, 0x000fe400078e0273ULL, 0x00005a0003747a24ULL, 0x000fc800078e0274ULL,
0x00005a0073747a24ULL, 0x000fca00078e0274ULL, 0x0000007479747210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0074027a11ULL, 0x000fc800078040ffULL,
0x00005f0074037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff097819ULL, 0x002fe20000011602ULL, 0xffffffffff3d7424ULL, 0x000fc600078e00ffULL,
0x000000720900720cULL, 0x000fda0003f06070ULL, 0x0000000277048824ULL, 0x000fc800078e00ffULL,
0x00006a00040d8a24ULL, 0x000fc800078e0209ULL, 0x000066000d0c8625ULL, 0x000fe200078e0042ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL,
0x000000080c3d8981ULL, 0x000ea2000c1e1900ULL, 0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL,
0x01760000ff047f8cULL, 0x000e68000c80043fULL, 0x000000080e087981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x00000080736e7824ULL, 0x000fe400078e00ffULL,
0x0000004002717824ULL, 0x000fe400078e00ffULL, 0x0000008076767824ULL, 0x000fc600078e00ffULL,
0x000000406e0a7812ULL, 0x000fe200078ef871ULL, 0x0000003d763d7224ULL, 0x004fc800078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x10afe40000011603ULL,
0x000064003d127a11ULL, 0x000fe400078038ffULL, 0x000000081c167810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0c7824ULL, 0x000fe200078e021cULL, 0x000000041c107810ULL, 0x040fe40007ffe0ffULL,
0x000000101c147810ULL, 0x000fe20007ffe0ffULL, 0x00000001160d7824ULL, 0x100fe200078e0203ULL,
0x0000000c1c187810ULL, 0x000fe20007ffe0ffULL, 0x0000000816247824ULL, 0x000fe200078e00ffULL,
0x00000071690e7217ULL, 0x000fe20007800000ULL, 0x00000001100b7824ULL, 0x000fe200078e0203ULL,
0x000000141c2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000810227824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001c1c2e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20bULL,
0x0000000814117824ULL, 0x000fe200078e00ffULL, 0x000000700c1f7812ULL, 0x000fe200078ef806ULL,
0x00000001140c7824ULL, 0x100fe200078e0203ULL, 0x000065003d0b7a11ULL, 0x000fe200000f3cffULL,
0x00000001180f7824ULL, 0x000fe200078e0203ULL, 0x0000001f121e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000818267824ULL, 0x000fe200078e00ffULL, 0xfffffff811287812ULL, 0x000fe200078ee20cULL,
0x000000010a0c7824ULL, 0x000fe200078e0210ULL, 0x0000100002137811ULL, 0x000fe200078e70ffULL,
0x000000010d1f7824ULL, 0x000fe200000e060bULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x000000010e1d7824ULL, 0x000fe200078e0a71ULL, 0x000000201c307810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000241c327810ULL, 0x000fc40007ffe0ffULL,
0x0000001d1000720cULL, 0x080fe20003fa6070ULL, 0x000000010a0e7824ULL, 0x000fe200078e0216ULL,
0x000000700c1b7812ULL, 0x000fe200078ef806ULL, 0x000000010a107824ULL, 0x000fe200078e0218ULL,
0x0000001d1800720cULL, 0x080fe20003f46070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000121b1a7210ULL, 0x000fe40007f7e0ffULL, 0x0000001d1400720cULL, 0x080fe20003f06070ULL,
0x000000010a207824ULL, 0x000fe200078e022aULL, 0x000000700e157812ULL, 0x000fe200078ef806ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001d1600720cULL, 0x000fc60003f26070ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000007010177812ULL, 0x000fc600078ef806ULL,
0x000000010a187824ULL, 0x000fe200078e0214ULL, 0x0000001215147210ULL, 0x080fe20007f9e0ffULL,
0x000000010d1b7824ULL, 0x100fe200018e060bULL, 0x00000070200d7812ULL, 0x100fe200078ef806ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000181c207810ULL, 0x000fe40007ffe0ffULL,
0x0000001217167210ULL, 0x080fe20007f7e0ffULL, 0x000000010f157824ULL, 0x100fe200020e060bULL,
0x00000070180f7812ULL, 0x000fe200078ef806ULL, 0x000000010a107824ULL, 0x000fe200078e0220ULL,
0x000000120d0c7210ULL, 0x080fe20007fde0ffULL, 0x0000000111177824ULL, 0x000fe200018e060bULL,
0x000000120f0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000011c187824ULL, 0x000fe200078e0203ULL,
0x0000001d2a00720cULL, 0x000fe20003f66070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000007182c7812ULL, 0x000fe200078ec0ffULL, 0x00000001190f7824ULL, 0x100fe200020e060bULL,
0x0000001d1c00720cULL, 0x000fe20003f86070ULL, 0x00000001210d7824ULL, 0x000fe200030e060bULL,
0x0000007010197812ULL, 0x000fe200078ef806ULL, 0x000000012a187824ULL, 0x100fe200078e0203ULL,
0x0ffffff82c2c7812ULL, 0x000fe200078ef803ULL, 0x000000082a217824ULL, 0x000fe200078e00ffULL,
0x0000001219107210ULL, 0x000fe20007fde0ffULL, 0x000000010a197824ULL, 0x000fe400078e022eULL,
0x000000102c237824ULL, 0x000fe200078e0213ULL, 0xfffffff8212a7812ULL, 0x000fe200078ee218ULL,
0x0000008019187825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000e101c48ULL, 0x000000010a217824ULL, 0x000fe200078e0230ULL,
0x0000001d2000720cULL, 0x040fe20003f86070ULL, 0x0000000120257824ULL, 0x000fe200078e0203ULL,
0x0000007018297812ULL, 0x000fe200078ef806ULL, 0x00000008202c7824ULL, 0x000fe400078e00ffULL,
0x0000008021207825ULL, 0x000fc600078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee225ULL,
0x0000000111117824ULL, 0x000fe200030e060bULL, 0x0000001229187210ULL, 0x000fe20007fde0ffULL,
0x000000010a277824ULL, 0x000fe200078e0232ULL, 0x00000070201f7812ULL, 0x002fe200078ef806ULL,
0x0000001022257824ULL, 0x000fe400078e0213ULL, 0x0000008027227825ULL, 0x000fc600078e00ffULL,
0x000000001a257faeULL, 0x0003e2000e901c48ULL, 0x0000000119197824ULL, 0x000fe200030e060bULL,
0x000000121f1e7210ULL, 0x080fe20007fde0ffULL, 0x000000012e277824ULL, 0x000fe200078e0203ULL,
0x0000007022297812ULL, 0x000fe200078ef806ULL, 0x000000082e227824ULL, 0x040fe200078e00ffULL,
0x0000001d2e00720cULL, 0x000fe20003fa6070ULL, 0x00000001211f7824ULL, 0x000fe200030e060bULL,
0x0000001229207210ULL, 0x000fe20007fde0ffULL, 0x00000008302b7824ULL, 0x000fe200078e00ffULL,
0x000000281c2e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee227ULL,
0x0000001024277824ULL, 0x000fe400078e0213ULL, 0x0000000123217824ULL, 0x000fe400030e060bULL,
0x0000001026237824ULL, 0x000fe200078e0213ULL, 0x0000000014277faeULL, 0x0005e2000c901c48ULL,
0x000000010a1a7824ULL, 0x002fe200078e022eULL, 0x0000001d3000720cULL, 0x080fe20003f26070ULL,
0x0000000132257824ULL, 0x040fe200078e0203ULL, 0x0000000016237faeULL, 0x0003e2000d101c48ULL,
0x0000001d3200720cULL, 0x000fe20003f46070ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000381c267810ULL, 0x000fc60007ffe0ffULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x000000701a297812ULL, 0x000fe200078ef806ULL, 0x0000001028157824ULL, 0x004fe200078e0213ULL,
0x0000003c1c287810ULL, 0x000fe20007ffe0ffULL, 0x0000000130247824ULL, 0x000fe200078e0203ULL,
0xfffffff832147812ULL, 0x000fe200078ee225ULL, 0x000000102a177824ULL, 0x102fe200078e0213ULL,
0x0000002c1c167810ULL, 0x000fe20007ffe0ffULL, 0x000000000e157faeULL, 0x0003e2000c101c48ULL,
0x00000012291a7210ULL, 0x000fe20007fde0ffULL, 0x0000001014297824ULL, 0x100fe200078e0213ULL,
0xfffffff82b247812ULL, 0x000fe200078ee224ULL, 0x000000010a147824ULL, 0x000fe200078e0216ULL,
0x000000000c177faeULL, 0x0005e2000d901c48ULL, 0x0000001022257824ULL, 0x100fe200078e0213ULL,
0x000000301c227810ULL, 0x000fe20007ffe0ffULL, 0x000000102c237824ULL, 0x100fe200078e0213ULL,
0x0000001d2800720cULL, 0x080fe20003f06070ULL, 0x0000001024277824ULL, 0x000fe200078e0213ULL,
0x000000341c247810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0e7824ULL, 0x002fe200078e0222ULL,
0x0000000010237faeULL, 0x0003e2000e101c48ULL, 0x000000011b1b7824ULL, 0x000fe200030e060bULL,
0x0000001d1600720cULL, 0x0c0fe20003f86070ULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x0000000018257faeULL, 0x0007e2000e901c48ULL, 0x00000080140c7825ULL, 0x004fe200078e00ffULL,
0x0000001d2e00720cULL, 0x000fc40003fa6070ULL, 0x000000001e277faeULL, 0x0005e2000c901c48ULL,
0x0000000116177824ULL, 0x100fe200078e0203ULL, 0x000000700c0f7812ULL, 0x000fe200078ef806ULL,
0x000000012e157824ULL, 0x000fe200078e0203ULL, 0x0000000020297faeULL, 0x0005e2000d101c48ULL,
0x000000010a107824ULL, 0x002fe200078e0224ULL, 0x000000120f0c7210ULL, 0x000fe20007fde0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001d2200720cULL, 0x080fe40003f66070ULL,
0x0000001d2400720cULL, 0x000fe20003f46070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e197812ULL, 0x008fc400078ef806ULL, 0x0000001d2600720cULL, 0x000fe20003f26070ULL,
0x00000001220e7824ULL, 0x000fe200078e0203ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x00000008221d7824ULL, 0x000fe200078e00ffULL, 0x0000007010177812ULL, 0x000fe200078ef806ULL,
0x000000010d0d7824ULL, 0x000fe200030e060bULL, 0x0000001219147210ULL, 0x080fe20007fde0ffULL,
0x000000082e187824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1e7812ULL, 0x004fe200078ee20eULL,
0x000000010a0e7824ULL, 0x000fe400078e0226ULL, 0x0000000124107824ULL, 0x000fe200078e0203ULL,
0xfffffff818187812ULL, 0x000fe200078ee215ULL, 0x000000010f157824ULL, 0x000fe200030e060bULL,
0x0000001217167210ULL, 0x000fe20007fde0ffULL, 0x0000000824197824ULL, 0x000fc400078e00ffULL,
0x000000010a1d7824ULL, 0x000fe400078e0228ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8190a7812ULL, 0x000fc600078ee210ULL, 0x0000000111177824ULL, 0x000fe400030e060bULL,
0x000000801d107825ULL, 0x000fe200078e00ffULL, 0x000000700e1d7812ULL, 0x000fc600078ef806ULL,
0x0000000126197824ULL, 0x100fe200078e0203ULL, 0x000000121d0e7210ULL, 0x080fe20007fde0ffULL,
0x0000000128037824ULL, 0x000fe200078e0203ULL, 0x00000070101d7812ULL, 0x000fe200078ef806ULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x000000010f0f7824ULL, 0x000fe200030e060bULL, 0xfffffff826067812ULL, 0x000fe200078ee219ULL,
0x000000101c197824ULL, 0x000fe200078e0213ULL, 0xfffffff828107812ULL, 0x000fe200078ee203ULL,
0x0000001018037824ULL, 0x100fe200078e0213ULL, 0x000000121d127210ULL, 0x000fe20007fde0ffULL,
0x000000101e1d7824ULL, 0x000fc400078e0213ULL, 0x000000100a1f7824ULL, 0x100fe200078e0213ULL,
0x000000001a037faeULL, 0x0003e2000e901c48ULL, 0x0000001006217824ULL, 0x100fe400078e0213ULL,
0x0000001010237824ULL, 0x000fe200078e0213ULL, 0x000000000c197faeULL, 0x0003e2000e101c48ULL,
0x0000000111137824ULL, 0x000fc600030e060bULL, 0x00000000141d7faeULL, 0x0003e8000d901c48ULL,
0x00000000161f7faeULL, 0x0003e8000d101c48ULL, 0x000000000e217faeULL, 0x0003e8000c901c48ULL,
0x0000000012237faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x00000008030e7811ULL, 0x04afe400078fe8ffULL, 0x0000000c030f7811ULL, 0x000fc400078fe8ffULL,
0x0000001803157811ULL, 0x040fe200078fe8ffULL, 0x000000010e0c7824ULL, 0x140fe200078e0203ULL,
0x00000004030d7811ULL, 0x040fe200078fe8ffULL, 0x000000080e217824ULL, 0x000fe200078e00ffULL,
0x0000001003117811ULL, 0x000fe200078fe8ffULL, 0x000000010f107824ULL, 0x100fe200078e0203ULL,
0x0000001c03177811ULL, 0x000fe200078fe8ffULL, 0x000000080f237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x00000001150c7824ULL, 0x100fe200078e0203ULL,
0x0000002803307811ULL, 0x000fe200078fe8ffULL, 0x0000000815297824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x000000010d0b7824ULL, 0x100fe200078e0203ULL,
0x0000001403137811ULL, 0x000fe200078fe8ffULL, 0x000000080d147824ULL, 0x000fe200078e00ffULL,
0x0000002003197811ULL, 0x000fe200078fe8ffULL, 0x0000000111127824ULL, 0x100fe200078e0203ULL,
0x0000002c03327811ULL, 0x000fe200078fe8ffULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x0000000117107824ULL, 0x040fe200078e0203ULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20bULL, 0x00000008172b7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee212ULL, 0x00000001300c7824ULL, 0x140fe200078e0203ULL,
0x00000024032e7811ULL, 0x000fe200078fe8ffULL, 0x00000008301b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x00000001130b7824ULL, 0x100fe200078e0203ULL,
0x0000003003347811ULL, 0x000fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1e7812ULL, 0x000fe200078ee20cULL, 0x0000000119127824ULL, 0x000fe200078e0203ULL,
0x00000003030c7211ULL, 0x000fe200078fe8ffULL, 0x00000008192d7824ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fe200078ee20bULL, 0x0000000132107824ULL, 0x140fe200078e0203ULL,
0x00000034031b7811ULL, 0x000fe200078fe8ffULL, 0x00000008321d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL, 0x000000012e0b7824ULL, 0x140fe200078e0203ULL,
0x0000003c03247811ULL, 0x000fe200078fe8ffULL, 0x000000082e1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee210ULL, 0x0000000134127824ULL, 0x040fe200078e0203ULL,
0x00000038031d7811ULL, 0x000fe200078fe8ffULL, 0x00000008342f7824ULL, 0x000fe200078e00ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010a107824ULL, 0x000fe200078e020fULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x000000011b0f7824ULL, 0x000fe200078e0203ULL,
0xfffffff82f227812ULL, 0x000fe200078ee212ULL, 0x000000010a127824ULL, 0x000fe200078e0211ULL,
0x0000000a030b7211ULL, 0x000fe200078fe8ffULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0x0ffffff80c0c7812ULL, 0x100fe200078ef803ULL, 0x000000011d117824ULL, 0x040fe200078e0203ULL,
0x00001000022a7811ULL, 0x000fe200078e70ffULL, 0x000000081d287824ULL, 0x000fe200078e00ffULL,
0xfffffff8260f7812ULL, 0x000fe200078ee20fULL, 0x000000010a367824ULL, 0x000fc400078e0224ULL,
0x0000000124037824ULL, 0x000fe200078e0203ULL, 0xfffffff828117812ULL, 0x000fe200078ee211ULL,
0x0000000824247824ULL, 0x000fe400078e00ffULL, 0x000000010a0d7824ULL, 0x040fe400078e020dULL,
0x000000010a0e7824ULL, 0x000fe200078e020eULL, 0xfffffff824287812ULL, 0x000fe200078ee203ULL,
0x000000010a147824ULL, 0x040fe200078e0213ULL, 0x000064003d037a11ULL, 0x000fe200078038ffULL,
0x000000010a167824ULL, 0x000fc400078e0215ULL, 0x000000010a187824ULL, 0x040fe200078e0217ULL,
0x000065003d3d7a11ULL, 0x000fe200000f3cffULL, 0x000000010a1a7824ULL, 0x040fe400078e0219ULL,
0x000000010a2e7824ULL, 0x040fe400078e022eULL, 0x000000010a307824ULL, 0x040fe400078e0230ULL,
0x000000010a327824ULL, 0x040fe400078e0232ULL, 0x000000010a347824ULL, 0x000fc400078e0234ULL,
0x000000010a3a7824ULL, 0x040fe400078e021bULL, 0x000000010a387824ULL, 0x000fe400078e021dULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000100f247824ULL, 0x000fe200078e022aULL,
0x000000700a0a7812ULL, 0x000fe200078ef806ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000a030a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100c1d7824ULL, 0x000fe200078e022aULL,
0x000000700e0e7812ULL, 0x000fe200078ef806ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000001011267824ULL, 0x000fe200078e022aULL, 0x0000007012127812ULL, 0x000fe200078ef806ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef806ULL, 0x000000010b0b7824ULL, 0x100fe200000e063dULL,
0x0000000e030e7210ULL, 0x040fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x100fe400078ef806ULL, 0x0000000c030c7210ULL, 0x040fe20007f3e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001003107210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1d7faeULL, 0x0003e2000b901c48ULL,
0x0000007014147812ULL, 0x100fe200078ef806ULL, 0x000000010f0f7824ULL, 0x000fe200000e063dULL,
0x0000001203127210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fc600078ef806ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fc600078ef806ULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000701a1a7812ULL, 0x000fc600078ef806ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x100fe400078ef806ULL, 0x0000001a031a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000113137824ULL, 0x000fe200000e063dULL, 0x0000001403147210ULL, 0x000fe20007f1e0ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000007030307812ULL, 0x000fc600078ef806ULL,
0x000000010d0d7824ULL, 0x000fe200008e063dULL, 0x0000001603167210ULL, 0x000fe20007f3e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007032327812ULL, 0x000fc600078ef806ULL,
0x0000000111117824ULL, 0x000fe200010e063dULL, 0x0000001803187210ULL, 0x000fe20007f5e0ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000007034347812ULL, 0x000fc600078ef806ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000703a3a7812ULL, 0x000fc600078ef806ULL,
0x000000101f1f7824ULL, 0x000fe200078e022aULL, 0x0000007038387812ULL, 0x000fe200078ef806ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000003a033a7210ULL, 0x000fe40007f9e0ffULL,
0x000000000c1f7faeULL, 0x0003e2000b901c48ULL, 0x0000001021217824ULL, 0x000fe200078e022aULL,
0x0000007036067812ULL, 0x000fe200078ef806ULL, 0x0000001023237824ULL, 0x100fe200078e022aULL,
0x0000003803387210ULL, 0x000fe20007fbe0ffULL, 0x0000000115157824ULL, 0x100fe200000e063dULL,
0x0000002e032e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001025257824ULL, 0x100fe200078e022aULL,
0x000000000e217faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x100fe200008e063dULL,
0x0000003003307210ULL, 0x000fe20007f3e0ffULL, 0x0000001027277824ULL, 0x100fe200078e022aULL,
0x0000000010237faeULL, 0x0003e2000b901c48ULL, 0x0000000119197824ULL, 0x100fe200010e063dULL,
0x0000003203327210ULL, 0x000fe20007f5e0ffULL, 0x0000001029297824ULL, 0x100fe200078e022aULL,
0x0000000012257faeULL, 0x0003e2000b901c48ULL, 0x000000011b1b7824ULL, 0x000fe200018e063dULL,
0x0000003403347210ULL, 0x000fe20007f7e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e022aULL,
0x0000000603367210ULL, 0x000fe20007fde0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e022aULL,
0x0000000014277faeULL, 0x0003e2000b901c48ULL, 0x000000101c1c7824ULL, 0x000fc400078e022aULL,
0x000000012f2f7824ULL, 0x100fe200000e063dULL, 0x0000000016297faeULL, 0x0003e2000b901c48ULL,
0x000000101e1e7824ULL, 0x100fe400078e022aULL, 0x0000000131317824ULL, 0x100fe200008e063dULL,
0x00000000182b7faeULL, 0x0003e2000b901c48ULL, 0x0000001020207824ULL, 0x100fe400078e022aULL,
0x0000000133337824ULL, 0x000fe200010e063dULL, 0x000000001a2d7faeULL, 0x0003e2000b901c48ULL,
0x0000001022227824ULL, 0x000fc400078e022aULL, 0x0000000135357824ULL, 0x100fe200018e063dULL,
0x000000002e1c7faeULL, 0x0003e2000b901c48ULL, 0x000000013b3b7824ULL, 0x100fe400020e063dULL,
0x0000000139397824ULL, 0x100fe200028e063dULL, 0x00000000301e7faeULL, 0x0003e2000b901c48ULL,
0x0000001028287824ULL, 0x000fe400078e022aULL, 0x0000000137377824ULL, 0x000fe200030e063dULL,
0x0000000032207faeULL, 0x0003e8000b901c48ULL, 0x0000000034227faeULL, 0x0003e8000b901c48ULL,
0x000000003a247faeULL, 0x0003e8000b901c48ULL, 0x0000000038267faeULL, 0x0003e8000b901c48ULL,
0x0000000036287faeULL, 0x0003e4000b901c48ULL, 0x0000000209627810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff677424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000726200720cULL, 0x000fda0003f06070ULL, 0x00000002770b8824ULL, 0x002fc800078e00ffULL,
0x00006a000b0b8a24ULL, 0x000fc800078e0262ULL, 0x000066000b0a8625ULL, 0x000fca00078e0042ULL,
0x000000080a678981ULL, 0x000322000c1e1900ULL, 0x00005800ff037624ULL, 0x000fca00078e00ffULL,
0x0000001f03037810ULL, 0x000fc80007ffe0ffULL, 0x00000005ff687819ULL, 0x000fc40000011603ULL,
0x00000000000a7805ULL, 0x002fca0000015200ULL, 0x01760400ff037984ULL, 0x000e620000000800ULL,
0x0000006807437224ULL, 0x000fe400078e02ffULL, 0x0000000169707824ULL, 0x000fe400078e0a00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620043427625ULL, 0x000fe200078e0042ULL, 0x00000008ff707819ULL, 0x000fe20000011670ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x000000060a067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e0bULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002002037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04067812ULL, 0x000fe400078ec0ffULL, 0x0000000f03047812ULL, 0x000fc600078ec0ffULL,
0x0000000103067824ULL, 0x000fe400078e0206ULL, 0x00000010040a7824ULL, 0x040fe400078e00ffULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x0000000f06037812ULL, 0x040fe400078ec0ffULL,
0x0000000106067810ULL, 0x000fe40007ffe0ffULL, 0x000000f00a037812ULL, 0x000fe400078ee203ULL,
0x0000000f06067812ULL, 0x000fc600078ec0ffULL, 0x0000000003107984ULL, 0x000e62000000cc00ULL,
0x000000f005067812ULL, 0x000fca00078ee206ULL, 0x00000000060c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001403007388ULL, 0x0003e8000000cc00ULL, 0x0000001006007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff097224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01760400ff037984ULL, 0x002e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6d00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000010071717810ULL, 0x000fe20007ffe0ffULL, 0x00006a0077777a24ULL, 0x000fe200078e02ffULL,
0x0001768802737811ULL, 0x000fe200078e18ffULL, 0x0000000268687824ULL, 0x000fe200078e00ffULL,
0xffffffff00057810ULL, 0x000fe20007ffe0ffULL, 0x3db504f308047820ULL, 0x010fe20000410000ULL,
0x0000000900617810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e00ffULL,
0x0001760802757811ULL, 0x000fe200078e28ffULL, 0x000000ffff1f7224ULL, 0x000fc600078e00ffULL,
0x000000025e067810ULL, 0x040fe20007ffe0ffULL, 0x000001005e607824ULL, 0x000fe200078e0271ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000006776677224ULL, 0x010fe200078e02ffULL,
0x0000006d0600720cULL, 0x000fc40003f06070ULL, 0x0000004060077812ULL, 0x000fe400078ec0ffULL,
0x000000011f637812ULL, 0x000fc600078e0cffULL, 0x000000016e067824ULL, 0x000fcc00078e0207ULL,
0x00000cc000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff187819ULL, 0x102fe20000011603ULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x00006400670a7a11ULL, 0x000fe400078038ffULL,
0x00000008180e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000118087824ULL, 0x040fe200078e0206ULL,
0x00000004180c7810ULL, 0x000fe40007ffe0ffULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000010e1e7824ULL, 0x140fe200078e0203ULL, 0x00000060691b7217ULL, 0x000fe20007800000ULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000001018127810ULL, 0x000fe20007ffe0ffULL,
0x000000010c077824ULL, 0x000fe200078e0203ULL, 0x0000000c18107810ULL, 0x000fe20007ffe0ffULL,
0x000000080c247824ULL, 0x000fe200078e00ffULL, 0xfffffff8091e7812ULL, 0x000fe200078ee21eULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000001418207810ULL, 0x000fc40007ffe0ffULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000011b1b7824ULL, 0x000fe200078e0a60ULL,
0x0000000b08177212ULL, 0x000fe200078efcffULL, 0x000000010c087824ULL, 0x000fe200078e0206ULL,
0x0000650067077a11ULL, 0x000fe200000f3cffULL, 0x00000001121a7824ULL, 0x100fe200078e0203ULL,
0x000000170a167210ULL, 0x000fe20007f1e0ffULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x0000001b0c00720cULL, 0x080fe20003fa6070ULL, 0x00000001100d7824ULL, 0x000fe200078e0203ULL,
0x0000001b0e00720cULL, 0x080fe20003f26070ULL, 0x0000000109177824ULL, 0x000fe200000e0607ULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee21aULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000001b1000720cULL, 0x000fc40003f46070ULL, 0x0000001b1200720cULL, 0x000fe20003f06070ULL,
0x0000000810267824ULL, 0x000fe200078e00ffULL, 0x0000000b08157212ULL, 0x080fe200078efcffULL,
0x000000010e0c7824ULL, 0x100fe200078e0206ULL, 0x0000001818227810ULL, 0x000fe20007ffe0ffULL,
0x00000001100e7824ULL, 0x000fe200078e0206ULL, 0xfffffff826267812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000a15087210ULL, 0x000fe40007f7e0ffULL,
0x0000001c182c7810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000b0c137212ULL, 0x000fc400078efcffULL, 0x00000020182e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112107824ULL, 0x100fe200078e0206ULL, 0x0000000b0e157212ULL, 0x000fe200078efcffULL,
0x00000001201c7824ULL, 0x000fe200078e0206ULL, 0x0000000a13127210ULL, 0x000fe20007f9e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000002418307810ULL, 0x000fc60007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200018e0607ULL, 0x0000000a15147210ULL, 0x000fe20007f7e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000b10197212ULL, 0x000fc600078efcffULL,
0x000000010f157824ULL, 0x100fe200018e0607ULL, 0x0000000a190e7210ULL, 0x080fe20007f7e0ffULL,
0x000000010d137824ULL, 0x000fe200020e0607ULL, 0x0000000b1c0d7212ULL, 0x000fe200078efcffULL,
0x0000000122107824ULL, 0x000fe400078e0206ULL, 0x00000001181c7824ULL, 0x000fe200078e0203ULL,
0x0000000a0d0c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001110f7824ULL, 0x000fe200018e0607ULL,
0x0000001b2000720cULL, 0x000fe20003f66070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000071c1c7812ULL, 0x000fc600078ec0ffULL, 0x000000011d0d7824ULL, 0x000fe200020e0607ULL,
0x0000000b101d7212ULL, 0x000fe200078efcffULL, 0x0000000120217824ULL, 0x100fe200078e0203ULL,
0x0000001b1800720cULL, 0x000fe20003f86070ULL, 0x0000000820287824ULL, 0x000fe200078e00ffULL,
0x0ffffff81c207812ULL, 0x000fe200078ef803ULL, 0x0000000202197824ULL, 0x000fe200078e0263ULL,
0x0000000a1d107210ULL, 0x000fe20007fde0ffULL, 0x000000012c1c7824ULL, 0x000fe200078e0206ULL,
0xfffffff828287812ULL, 0x000fe200078ee221ULL, 0x0000000122257824ULL, 0x000fe200078e0203ULL,
0x0000100019197811ULL, 0x000fe200078e68ffULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000001020237824ULL, 0x000fe200078e0219ULL, 0x0000000b1c217212ULL, 0x000fe200078efcffULL,
0x000000012e207824ULL, 0x000fe400078e0206ULL, 0x0000000111117824ULL, 0x000fe200030e0607ULL,
0x0000000a211c7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000e101c48ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000001b2200720cULL, 0x000fc60003f86070ULL, 0x00000008222a7824ULL, 0x000fe400078e00ffULL,
0x0000000130227824ULL, 0x000fe400078e0206ULL, 0x000000011d1d7824ULL, 0x000fe200030e0607ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee225ULL, 0x0000001024257824ULL, 0x000fe200078e0219ULL,
0x0000000b20177212ULL, 0x002fe200078efcffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0x0000000a17167210ULL, 0x080fe20007fde0ffULL, 0x0000000008257faeULL, 0x0003e2000e901c48ULL,
0x0000000b22277212ULL, 0x000fe200078efcffULL, 0x000000012c247824ULL, 0x040fe200078e0203ULL,
0x0000001b2c00720cULL, 0x0c0fe20003fa6070ULL, 0x0000000121177824ULL, 0x000fe200030e0607ULL,
0x0000000a27207210ULL, 0x000fe20007fde0ffULL, 0x000000082c297824ULL, 0x000fe200078e00ffULL,
0x00000028182c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101e277824ULL, 0x000fe400078e0219ULL,
0x0000000123217824ULL, 0x000fe200030e0607ULL, 0xfffffff829247812ULL, 0x000fe200078ee224ULL,
0x0000001026237824ULL, 0x000fe200078e0219ULL, 0x0000000012277faeULL, 0x0005e2000c901c48ULL,
0x000000012c087824ULL, 0x002fe200078e0206ULL, 0x0000001b2e00720cULL, 0x0c0fe20003f26070ULL,
0x000000012e1e7824ULL, 0x000fe200078e0203ULL, 0x0000000014237faeULL, 0x0003e2000d101c48ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000001b3000720cULL, 0x000fc60003f46070ULL,
0x000000082e297824ULL, 0x000fe200078e00ffULL, 0x0000000b08257212ULL, 0x000fe200078efcffULL,
0x0000000130227824ULL, 0x000fe400078e0203ULL, 0x000000101a137824ULL, 0x104fe200078e0219ULL,
0xfffffff8291e7812ULL, 0x000fe200078ee21eULL, 0x00000008302b7824ULL, 0x000fe200078e00ffULL,
0x0000002c18147810ULL, 0x002fe20007ffe0ffULL, 0x0000001028157824ULL, 0x100fe200078e0219ULL,
0x000000000e137faeULL, 0x0003e2000c101c48ULL, 0x00000030181a7810ULL, 0x000fe20007ffe0ffULL,
0x000000102a237824ULL, 0x100fe200078e0219ULL, 0x0000000a25087210ULL, 0x080fe20007fde0ffULL,
0x0000000114127824ULL, 0x000fe200078e0206ULL, 0x000000000c157faeULL, 0x0005e2000d901c48ULL,
0x000000101e277824ULL, 0x000fe200078e0219ULL, 0xfffffff82b227812ULL, 0x000fe200078ee222ULL,
0x0000000109097824ULL, 0x000fe200030e0607ULL, 0x00000034181e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001024257824ULL, 0x100fe200078e0219ULL, 0x0000000010237faeULL, 0x0007e2000e101c48ULL,
0x000000011a0e7824ULL, 0x102fe200078e0206ULL, 0x0000003c18247810ULL, 0x000fe20007ffe0ffULL,
0x0000001022297824ULL, 0x000fe200078e0219ULL, 0x000000001c257faeULL, 0x0003e2000e901c48ULL,
0x0000003818227810ULL, 0x000fe20007ffe0ffULL, 0x00000080120c7825ULL, 0x004fe200078e00ffULL,
0x0000001b2c00720cULL, 0x080fe20003fa6070ULL, 0x0000000016277faeULL, 0x0005e2000c901c48ULL,
0x0000001b1400720cULL, 0x000fe20003f86070ULL, 0x000000012c127824ULL, 0x100fe200078e0203ULL,
0x0000000b0c0f7212ULL, 0x000fe200078efcffULL, 0x000000011e107824ULL, 0x008fe200078e0206ULL,
0x0000000020297faeULL, 0x0007e2000d101c48ULL, 0x0000000114157824ULL, 0x000fe200078e0203ULL,
0x0000000a0f0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001b1a00720cULL, 0x000fc40003f66070ULL, 0x0000001b1e00720cULL, 0x000fe20003f46070ULL,
0x000000082c177824ULL, 0x004fe200078e00ffULL, 0x0000000b0e137212ULL, 0x000fe200078efcffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0x0000001b2200720cULL, 0x080fe20003f26070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001b2400720cULL, 0x000fe40003f06070ULL,
0xfffffff817167812ULL, 0x000fe200078ee212ULL, 0x000000010d0d7824ULL, 0x000fe200030e0607ULL,
0x0000000a130e7210ULL, 0x000fe20007fde0ffULL, 0x000000011a147824ULL, 0x000fe200078e0203ULL,
0xfffffff818187812ULL, 0x000fe200078ee215ULL, 0x000000081a1b7824ULL, 0x000fe200078e00ffULL,
0x0000000b10157212ULL, 0x000fe200078efcffULL, 0x0000000122127824ULL, 0x000fc400078e0206ULL,
0x000000011e177824ULL, 0x040fe200078e0203ULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee214ULL,
0x000000010f0f7824ULL, 0x000fe200030e0607ULL, 0x0000000a15147210ULL, 0x000fe20007fde0ffULL,
0x000000081e1e7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000124107824ULL, 0x000fe200078e0206ULL, 0xfffffff81e067812ULL, 0x000fe200078ee217ULL,
0x0000000111157824ULL, 0x000fe200030e0607ULL, 0x0000000b12177212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000a17127210ULL, 0x080fe20007fde0ffULL,
0x00000001221b7824ULL, 0x100fe200078e0203ULL, 0x0000000b100b7212ULL, 0x000fe200078efcffULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x00000001241c7824ULL, 0x042fe400078e0203ULL,
0x00000008241d7824ULL, 0x000fe200078e00ffULL, 0xfffffff822107812ULL, 0x000fe200078ee21bULL,
0x0000000113137824ULL, 0x000fe200030e0607ULL, 0x0000000a0b0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x100fe200078e0219ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL,
0x00000010181b7824ULL, 0x000fc400078e0219ULL, 0x000000101a1d7824ULL, 0x100fe200078e0219ULL,
0x0000000008177faeULL, 0x0003e2000e901c48ULL, 0x0000001006217824ULL, 0x108fe400078e0219ULL,
0x0000001010237824ULL, 0x100fe200078e0219ULL, 0x000000000c1b7faeULL, 0x0003e2000e101c48ULL,
0x000000101c197824ULL, 0x000fe400078e0219ULL, 0x00000001110b7824ULL, 0x000fe200030e0607ULL,
0x000000000e1d7faeULL, 0x0003e8000d901c48ULL, 0x0000000014217faeULL, 0x0003e8000d101c48ULL,
0x0000000012237faeULL, 0x0003e8000c901c48ULL, 0x000000000a197faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000403087811ULL, 0x042fe200078fe8ffULL,
0x0000001003477824ULL, 0x040fe200078e00ffULL, 0x00000008030a7811ULL, 0x000fc400078fe8ffULL,
0x0000000c030c7811ULL, 0x040fe200078fe8ffULL, 0x0000000108077824ULL, 0x140fe200078e0203ULL,
0x00000010030e7811ULL, 0x040fe200078fe8ffULL, 0x0000000808287824ULL, 0x000fe200078e00ffULL,
0x0000001403107811ULL, 0x040fe200078fe8ffULL, 0x000000010a097824ULL, 0x040fe200078e0203ULL,
0x0000001803127811ULL, 0x040fe200078fe8ffULL, 0x000000080a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee207ULL, 0x000000010c0b7824ULL, 0x040fe200078e0203ULL,
0x0000001c03147811ULL, 0x040fe200078fe8ffULL, 0x000000080c2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x000000010e077824ULL, 0x040fe200078e0203ULL,
0x0000002003167811ULL, 0x040fe200078fe8ffULL, 0x000000080e307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20bULL, 0x0000000110097824ULL, 0x040fe200078e0203ULL,
0x0000002403267811ULL, 0x040fe200078fe8ffULL, 0x0000000810327824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee207ULL, 0x00000001120b7824ULL, 0x040fe200078e0203ULL,
0x0000002803247811ULL, 0x040fe200078fe8ffULL, 0x0000000812347824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee209ULL, 0x0000000114077824ULL, 0x040fe200078e0203ULL,
0x0000002c03227811ULL, 0x040fe200078fe8ffULL, 0x0000000814367824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee20bULL, 0x0000000116097824ULL, 0x040fe200078e0203ULL,
0x0000003003207811ULL, 0x040fe200078fe8ffULL, 0x0000000816387824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x00000001260b7824ULL, 0x040fe200078e0203ULL,
0x0000003403187811ULL, 0x040fe200078fe8ffULL, 0x00000008263a7824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x0000000124077824ULL, 0x040fe200078e0203ULL,
0x00000038031a7811ULL, 0x040fe200078fe8ffULL, 0x00000008243c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL, 0x0000000122097824ULL, 0x040fe200078e0203ULL,
0x0000003c031c7811ULL, 0x000fe200078fe8ffULL, 0x00000008223e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x00000001200b7824ULL, 0x040fe200078e0203ULL,
0x0000007047477812ULL, 0x000fe200078ec0ffULL, 0x0000000820407824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee209ULL, 0x0000000118077824ULL, 0x040fe200078e0203ULL,
0x00006400672c7a11ULL, 0x040fe200078038ffULL, 0x0000000818447824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee20bULL, 0x000000011a097824ULL, 0x040fe200078e0203ULL,
0x0000650067457a11ULL, 0x000fe200000f3cffULL, 0x000000081a467824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee207ULL, 0x000000011c0b7824ULL, 0x040fe200078e0203ULL,
0x0000000303077211ULL, 0x000fe200078fe8ffULL, 0x000000081c487824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee209ULL, 0x0000000108087824ULL, 0x100fe200078e0206ULL,
0x00000007071e7812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0206ULL,
0xfffffff848487812ULL, 0x000fe200078ee20bULL, 0x000000010c0c7824ULL, 0x100fe200078e0206ULL,
0x0ffffff81e1e7812ULL, 0x000fe200078ef803ULL, 0x000000010e0e7824ULL, 0x000fc400078e0206ULL,
0x0000000110107824ULL, 0x100fe400078e0206ULL, 0x0000000112127824ULL, 0x100fe400078e0206ULL,
0x0000000114147824ULL, 0x100fe400078e0206ULL, 0x0000000116167824ULL, 0x100fe400078e0206ULL,
0x0000000126267824ULL, 0x100fe400078e0206ULL, 0x0000000124247824ULL, 0x000fc400078e0206ULL,
0x0000000122227824ULL, 0x100fe400078e0206ULL, 0x0000000120207824ULL, 0x100fe400078e0206ULL,
0x0000000118187824ULL, 0x100fe400078e0206ULL, 0x000000011a1a7824ULL, 0x100fe400078e0206ULL,
0x000000011c1c7824ULL, 0x000fe200078e0206ULL, 0x0000000603067211ULL, 0x000fe200078fe8ffULL,
0x0000000202097824ULL, 0x000fc400078e0263ULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x0000100009097811ULL, 0x000fe200078e68ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000470a137212ULL, 0x000fc600078efcffULL, 0x000000101e417824ULL, 0x100fe200078e0209ULL,
0x0000004706117212ULL, 0x000fe200078efcffULL, 0x00000010283f7824ULL, 0x100fe400078e0209ULL,
0x000000102a3d7824ULL, 0x000fe200078e0209ULL, 0x000000112c067210ULL, 0x000fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000102e3b7824ULL, 0x100fe200078e0209ULL,
0x000000470c117212ULL, 0x000fe200078efcffULL, 0x0000001030397824ULL, 0x100fe400078e0209ULL,
0x0000001032377824ULL, 0x100fe200078e0209ULL, 0x000000112c0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001034357824ULL, 0x100fe400078e0209ULL, 0x0000001036337824ULL, 0x100fe400078e0209ULL,
0x0000001038317824ULL, 0x000fc400078e0209ULL, 0x000000103a2f7824ULL, 0x100fe400078e0209ULL,
0x000000103c2d7824ULL, 0x100fe400078e0209ULL, 0x000000103e2b7824ULL, 0x100fe400078e0209ULL,
0x00000010402a7824ULL, 0x100fe400078e0209ULL, 0x0000001044297824ULL, 0x100fe400078e0209ULL,
0x0000001046287824ULL, 0x000fc400078e0209ULL, 0x00000010481e7824ULL, 0x000fe400078e0209ULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004708157212ULL, 0x000fc600078efcffULL, 0x0000000107077824ULL, 0x100fe200000e0645ULL,
0x000000132c0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000470e137212ULL, 0x000fe400078efcffULL, 0x000000152c087210ULL, 0x040fe20007f3e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0645ULL, 0x000000132c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004710217212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006417faeULL, 0x0003e4000b901c48ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004716197212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000047121d7212ULL, 0x000fe400078efcffULL,
0x000000192c167210ULL, 0x000fe20007f7e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x00000047141b7212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x000fe200000e0645ULL,
0x000000212c107210ULL, 0x000fe20007f1e0ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000004726537212ULL, 0x000fc600078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000004724517212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x100fe200008e0645ULL,
0x0000001d2c127210ULL, 0x040fe20007f3e0ffULL, 0x000000010d0d7824ULL, 0x100fe200010e0645ULL,
0x0000001b2c147210ULL, 0x000fe20007f5e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x00000047224f7212ULL, 0x080fe200078efcffULL, 0x00000000083f7faeULL, 0x0003e4000b901c48ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000047204d7212ULL, 0x080fe200078efcffULL,
0x000000000a3d7faeULL, 0x0003e4000b901c48ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x00000047184b7212ULL, 0x080fe200078efcffULL, 0x000000000c3b7faeULL, 0x0003e4000b901c48ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000471a497212ULL, 0x000fe200078efcffULL,
0x000000000e397faeULL, 0x0003e2000b901c48ULL, 0x0000004b2c187210ULL, 0x040fe20007f9e0ffULL,
0x0000000111117824ULL, 0x100fe200000e0645ULL, 0x000000532c267210ULL, 0x040fe20007f1e0ffULL,
0x0000000113137824ULL, 0x100fe200008e0645ULL, 0x000000512c247210ULL, 0x000fe20007f3e0ffULL,
0x0000000115157824ULL, 0x100fe200010e0645ULL, 0x000000471c477212ULL, 0x000fe200078efcffULL,
0x0000000117177824ULL, 0x100fe200018e0645ULL, 0x0000004f2c227210ULL, 0x040fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0645ULL, 0x0000004d2c207210ULL, 0x040fe20007f7e0ffULL,
0x0000000125257824ULL, 0x100fe200008e0645ULL, 0x000000492c1a7210ULL, 0x040fe20007fbe0ffULL,
0x0000000010377faeULL, 0x0003e2000b901c48ULL, 0x000000472c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000123237824ULL, 0x000fc400010e0645ULL, 0x0000000012357faeULL, 0x0003e2000b901c48ULL,
0x0000000121217824ULL, 0x100fe400018e0645ULL, 0x0000000119197824ULL, 0x100fe200020e0645ULL,
0x0000000014337faeULL, 0x0003e2000b901c48ULL, 0x000000011b1b7824ULL, 0x100fe400028e0645ULL,
0x000000011d1d7824ULL, 0x000fe200030e0645ULL, 0x0000000016317faeULL, 0x0003e8000b901c48ULL,
0x00000000262f7faeULL, 0x0003e8000b901c48ULL, 0x00000000242d7faeULL, 0x0003e8000b901c48ULL,
0x00000000222b7faeULL, 0x0003e8000b901c48ULL, 0x00000000202a7faeULL, 0x0003e8000b901c48ULL,
0x0000000018297faeULL, 0x0003e8000b901c48ULL, 0x000000001a287faeULL, 0x0003e8000b901c48ULL,
0x000000001c1e7faeULL, 0x0003e4000b901c48ULL, 0x0000000262627810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff677424ULL, 0x000fc400078e00ffULL,
0x000000726200720cULL, 0x000fe40003f06070ULL, 0x0000002003097810ULL, 0x002fe20007ffe0ffULL,
0x0000000202087824ULL, 0x000fd400078e021fULL, 0x0000000277068824ULL, 0x000fe400078e0262ULL,
0x00000004ff078424ULL, 0x000fc800078e00ffULL, 0x0000660006068625ULL, 0x000fe200078e0007ULL,
0x00000007030e7812ULL, 0x040fe400078ec0ffULL, 0xfffffff8030c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000806678981ULL, 0x000322000c1e1900ULL,
0x00000004ff6f7819ULL, 0x000fe20000011603ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0xfffffff809067812ULL, 0x002fe200078ec0ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000100008077811ULL, 0x000fe200078e68ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000080e087812ULL, 0x100fe400078ef803ULL, 0x000000070c097812ULL, 0x100fe400078ef803ULL,
0x0000000706067812ULL, 0x000fc600078ef803ULL, 0x00000001090b7824ULL, 0x140fe200078e020aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008090c7824ULL, 0x040fe400078e00ffULL,
0x0000000809197824ULL, 0x000fe400078e00ffULL, 0x000000020a6a7824ULL, 0x000fe200078e026fULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x00000001060b7824ULL, 0x000fc400078e020aULL,
0x0000001008797824ULL, 0x000fe400078e00ffULL, 0x000000100c107824ULL, 0x000fe400078e0207ULL,
0x00000008060c7824ULL, 0x000fc800078e00ffULL, 0x000000001010783bULL, 0x020e620000000200ULL,
0xfffffff80c0c7812ULL, 0x000fca00078ee20bULL, 0x000000100c0c7824ULL, 0x000fcc00078e0207ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x00010000100b7824ULL, 0x042fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011410ULL, 0x0001000011187824ULL, 0x040fe200078e00ffULL,
0x0000888010447816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x00000018ff467819ULL, 0x000fe20000011411ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000888011477816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff4b7819ULL, 0x000fe40000011412ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000000b00417306ULL, 0x0003e20000200c00ULL, 0x00008880124d7816ULL, 0x000fe400000000ffULL,
0x00000018ff567819ULL, 0x004fe4000001140eULL, 0x000088800e597816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe2000001140cULL, 0x00000010004c7306ULL, 0x0004e20000200c00ULL,
0x00010000120b7824ULL, 0x002fe200078e00ffULL, 0x000088800c547816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011413ULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000001100487306ULL, 0x0003e20000200c00ULL,
0x0001000013107824ULL, 0x044fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000888013647816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000b006c7306ULL, 0x0005e20000200c00ULL,
0x000000010a117810ULL, 0x002fc40007ffe0ffULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x000054104c457816ULL, 0x008fe20000000045ULL,
0x0000001000667306ULL, 0x0003e20000200c00ULL, 0x000100000c0b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001140dULL, 0x000001000c0c7824ULL, 0x000fe200078e00ffULL,
0x000088800d5b7816ULL, 0x000fe400000000ffULL, 0x00000018ff0b7819ULL, 0x000fc4000001140bULL,
0x00000012006b7306ULL, 0x0005e20000200c00ULL, 0x0000000109107824ULL, 0x102fe200078e0211ULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000000106117824ULL, 0x000fe200078e0211ULL,
0x00000018ff507819ULL, 0x000fe4000001140fULL, 0x000088800f4e7816ULL, 0x000fe400000000ffULL,
0x0000000b00537306ULL, 0x0003e20000200c00ULL, 0xfffffff819127812ULL, 0x004fe200078ee210ULL,
0x000100000d107824ULL, 0x040fe200078e00ffULL, 0x000000020a0a7810ULL, 0x000fe20007ffe0ffULL,
0x000001000d0d7824ULL, 0x000fc400078e00ffULL, 0x0000001012127824ULL, 0x000fe200078e0207ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000c005f7306ULL, 0x0005e20000200c00ULL,
0x000100000e0b7824ULL, 0x042fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x000001000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000000121c783bULL, 0x000e620000000200ULL,
0x000000080a00780cULL, 0x000fe40003f05270ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x00000010005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x00000008060c7824ULL, 0x004fca00078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee211ULL,
0x0000000b00587306ULL, 0x0005f00000200c00ULL, 0x0000000e00577306ULL, 0x0007e20000200c00ULL,
0x00000001080b7824ULL, 0x144fe200078e026aULL, 0x00000002086a7810ULL, 0x000fc80007ffe06aULL,
0xfffffff0796a7812ULL, 0x000fe400078ee26aULL, 0x0000001300657306ULL, 0x0005e20000200c00ULL,
0x00000010080e7824ULL, 0x008fca00078e00ffULL, 0xfffffff00e0b7812ULL, 0x000fe400078ee20bULL,
0x0000004400447306ULL, 0x000ee60000200c00ULL, 0x000000100b107824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x002fe2000001141cULL, 0x000100001c407824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001141dULL, 0x0000001800497306ULL, 0x0003e20000200c00ULL,
0x000000001010783bULL, 0x004ea20000000200ULL, 0x00000018ff3d7819ULL, 0x000fc4000001141eULL,
0x00000018ff3c7819ULL, 0x000fe4000001141fULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x000000100c187824ULL, 0x002fe200078e0207ULL,
0x0000541044447816ULL, 0x008fe20000000041ULL, 0x000100000f0c7824ULL, 0x000fe200078e00ffULL,
0x000088801d417816ULL, 0x000fe200000000ffULL, 0x000001000f0f7824ULL, 0x000fe400078e00ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x00000018ff0c7819ULL, 0x000fc4000001140cULL, 0x00000018ff0f7819ULL, 0x000fca000001140fULL,
0x0000000c004a7306ULL, 0x0007f00000200c00ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000088801c0c7816ULL, 0x048fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000000441038723cULL, 0x004b6e0000001838ULL, 0x000100001d447824ULL, 0x060fe200078e00ffULL,
0x0000001c00517306ULL, 0x0005e20000200c00ULL, 0x000001001d1d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff457819ULL, 0x000fe4000001141dULL,
0x00005410481d7816ULL, 0x000fe20000000046ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x00005410471c7816ULL, 0x004fe40000000049ULL, 0x000088801e467816ULL, 0x000fe400000000ffULL,
0x000088801f497816ULL, 0x000fc400000000ffULL, 0x00000018ff0b7819ULL, 0x002fe2000001141bULL,
0x0000001c1034723cULL, 0x000be20000001834ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x00000018ff0e7819ULL, 0x000fca0000011419ULL, 0x000100001e1c7824ULL, 0x060fe200078e00ffULL,
0x000054105f557816ULL, 0x008fe20000000055ULL, 0x000100001f1d7824ULL, 0x040fe200078e00ffULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x00000100195f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000001c00477306ULL, 0x0007e20000200c00ULL,
0x0000541054547816ULL, 0x002fc40000000053ULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000001d004c7306ULL, 0x0003e20000200c00ULL, 0x000054104d1c7816ULL, 0x008fe2000000006cULL,
0x000000541028723cULL, 0x000fec0000001828ULL, 0x0000005200527306ULL, 0x000ee20000200c00ULL,
0x000054106b1d7816ULL, 0x002fe4000000004bULL, 0x00008880184b7816ULL, 0x000fca00000000ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000001c1030723cULL, 0x000b6e0000001830ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x00010000181c7824ULL, 0x060fe400078e00ffULL,
0x00000100181d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001141cULL,
0x0000000d005c7306ULL, 0x0002620000200c00ULL, 0x00005410641c7816ULL, 0x004fe20000000066ULL,
0x0001000019667824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001141dULL,
0x00005410651d7816ULL, 0x008fe40000000052ULL, 0x0000888019657816ULL, 0x000fe200000000ffULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000054105b547816ULL, 0x002fc4000000005dULL,
0x00000018ff0d7819ULL, 0x000fe2000001141aULL, 0x0000001c102c723cULL, 0x000f62000000182cULL,
0x000088801a5b7816ULL, 0x000fe400000000ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000054105c557816ULL, 0x000fe4000000005aULL,
0x00000018ff5a7819ULL, 0x000fca000001145fULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000000541024723cULL, 0x000bee0000001824ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x0000541059547816ULL, 0x022fe40000000058ULL, 0x0000541057557816ULL, 0x000fca0000000056ULL,
0x0000000f004f7306ULL, 0x0002e40000200c00ULL, 0x000000541020723cULL, 0x000b6c0000001820ULL,
0x0000001e00487306ULL, 0x0007e20000200c00ULL, 0x000054104e4e7816ULL, 0x004fe2000000004aULL,
0x000100001a557824ULL, 0x060fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x002fe20000011418ULL,
0x000001001a1a7824ULL, 0x000fc400078e00ffULL, 0x000000ffff547224ULL, 0x000fe400078e005bULL,
0x0000001f004d7306ULL, 0x0003e20000200c00ULL, 0x000000106a1e7824ULL, 0x008fe200078e00ffULL,
0x000054104f4f7816ULL, 0x000fcc0000000050ULL, 0x0000000c000c7306ULL, 0x000fe20000200c00ULL,
0x000000001e1c783bULL, 0x002e620000000200ULL, 0x0000004e1014723cULL, 0x000b6c0000001814ULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x000088801b117816ULL, 0x060fe200000000ffULL,
0x000100001b127824ULL, 0x040fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011455ULL,
0x000001001b1b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fce000001141bULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x000054100c507816ULL, 0x004fe40000000040ULL,
0x00000018ff0c7819ULL, 0x000fca000001141aULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000054104d4d7816ULL, 0x008fce000000003cULL, 0x0000006b00187306ULL, 0x000ff00000200c00ULL,
0x0000006400527306ULL, 0x000eb00000200c00ULL, 0x0000004600467306ULL, 0x000ef00000200c00ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000541052137816ULL, 0x004fce000000000fULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541046467816ULL, 0x008fce0000000047ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x0000541051517816ULL, 0x002fce000000003fULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000000501c38723cULL, 0x000f6e0000001838ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x0000541048477816ULL, 0x004fce000000003dULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000000461c30723cULL, 0x000f6e0000001830ULL,
0x0000004100417306ULL, 0x000ff00000200c00ULL, 0x0000004400447306ULL, 0x000e700000200c00ULL,
0x0000004500457306ULL, 0x000eb00000200c00ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x0000541041447816ULL, 0x002fce0000000044ULL, 0x0000006500537306ULL, 0x000fe20000200c00ULL,
0x0000541045457816ULL, 0x004fce000000003eULL, 0x0000006600197306ULL, 0x000fe20000200c00ULL,
0x00005410494c7816ULL, 0x008fe2000000004cULL, 0x000000441c34723cULL, 0x040f6c0000001834ULL,
0x0000005a005a7306ULL, 0x000fe40000200c00ULL, 0x0000004c1c2c723cULL, 0x000f6c000000182cULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000001000107306ULL, 0x000e700000200c00ULL,
0x0000000c000c7306ULL, 0x000eb00000200c00ULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0000541054547816ULL, 0x002fce0000000010ULL, 0x00000012001a7306ULL, 0x0002e20000200c00ULL,
0x000054100c557816ULL, 0x004fce000000000dULL, 0x0000001b003c7306ULL, 0x000ea20000200c00ULL,
0x000054104b127816ULL, 0x002fe20000000018ULL, 0x000000541c20723cULL, 0x000f620000001820ULL,
0x00005410111a7816ULL, 0x008fce000000001aULL, 0x000000121c28723cULL, 0x000b620000001828ULL,
0x000054103c1b7816ULL, 0x004fcc000000000bULL, 0x0000541053127816ULL, 0x020fe40000000019ULL,
0x000054105a137816ULL, 0x000fe2000000000eULL, 0x0000001a1c14723cULL, 0x040b700000001814ULL,
0x000000121c24723cULL, 0x000b620000001824ULL, 0xfffff0b000000947ULL, 0x000fce000383ffffULL,
0x0000000434347220ULL, 0x080fe40000410000ULL, 0x0000000430307220ULL, 0x000fc40000410000ULL,
0x0000000431317220ULL, 0x080fe40000410000ULL, 0x000000042c2c7220ULL, 0x080fe40000410000ULL,
0x000000042d2d7220ULL, 0x080fe40000410000ULL, 0x0000000438387220ULL, 0x080fe40000410000ULL,
0x0000000439397220ULL, 0x080fe40000410000ULL, 0x0000000435357220ULL, 0x000fc40000410000ULL,
0x0000000429067220ULL, 0x080fe40000410000ULL, 0x0000000424247220ULL, 0x0a0fe40000410000ULL,
0x0000000425257220ULL, 0x080fe40000410000ULL, 0x0000000420207220ULL, 0x080fe40000410000ULL,
0x0000000432087220ULL, 0x080fe40000410000ULL, 0x000000042f0a7220ULL, 0x000fc40000410000ULL,
0x000000042a0b7220ULL, 0x080fe40000410000ULL, 0x000000042b0c7220ULL, 0x080fe40000410000ULL,
0x00000004271d7220ULL, 0x080fe40000410000ULL, 0x000000ffff297224ULL, 0x000fe400078e0034ULL,
0x000000042e097220ULL, 0x080fe40000410000ULL, 0x0000000428327220ULL, 0x000fc40000410000ULL,
0x00000004261c7220ULL, 0x080fe40000410000ULL, 0x0000000415277220ULL, 0x080fe40000410000ULL,
0x00000004171b7220ULL, 0x000fe40000410000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2b7224ULL, 0x000fc400078e002cULL,
0x000000ffff347224ULL, 0x000fe400078e002dULL, 0x000000043a1e7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x080fe40000410000ULL, 0x00000004361f7220ULL, 0x080fe40000410000ULL,
0x0000000437377220ULL, 0x080fe40000410000ULL, 0x0000000433337220ULL, 0x000fc40000410000ULL,
0x00000004212e7220ULL, 0x080fe40000410000ULL, 0x0000000422187220ULL, 0x080fe40000410000ULL,
0x0000000423197220ULL, 0x080fe40000410000ULL, 0x0000000414267220ULL, 0x080fe40000410000ULL,
0x00000004161a7220ULL, 0x000fe40000410000ULL, 0x000000ffff157224ULL, 0x000fc400078e0038ULL,
0x000000ffff287224ULL, 0x000fe400078e0039ULL, 0x000000ffff177224ULL, 0x000fe400078e0035ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0024ULL,
0x000000ffff317224ULL, 0x000fe400078e0025ULL, 0x000000ffff307224ULL, 0x000fe200078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000073067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff217224ULL, 0x000fc400078e0033ULL, 0x000000ffff167224ULL, 0x000fe400078e003bULL,
0x000000ffff237224ULL, 0x000fe400078e0037ULL, 0x000000ffff227224ULL, 0x000fe400078e0008ULL,
0x000000ffff247224ULL, 0x000fe400078e0009ULL, 0x000000ffff337224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fc400078e000bULL, 0x000000ffff147224ULL, 0x000fc400078e000cULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x00000400730b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400730b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403137824ULL, 0x000fe200078e00ffULL,
0x000000705e00720cULL, 0x000fc80003f06070ULL, 0xfffffff013077812ULL, 0x000fca00078ec0ffULL,
0x0000008002207824ULL, 0x000fca00078e0207ULL, 0x0174000020087984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000d7b06ULL, 0x000ee20000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0xffffff0060127810ULL, 0x000fe20007ffe0ffULL,
0x0000000203357824ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f85070ULL,
0x00005a00ff107a12ULL, 0x000fe400078e33ffULL, 0x0000000635357812ULL, 0x000fca00078ec0ffULL,
0x0000000135377824ULL, 0x000fe200078e0200ULL, 0x0000000d000d7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0d0e7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000e00077305ULL, 0x000ee4000021f000ULL,
0x000000ffff0f7224ULL, 0x008fc800078e0a07ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f070f7227ULL, 0x000fe200078e0006ULL, 0x0000007403067211ULL, 0x000fca00078ff0ffULL,
0x000000060f0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0cULL,
0x00005a0007077a24ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fc80007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fe20003f06070ULL, 0x000000060f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a0fULL, 0x00005a000d0d7a24ULL, 0x000fc800078e0206ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000d007a0cULL, 0x000fe40003f46070ULL,
0x00005a0007007a0cULL, 0x000fe40003f26070ULL, 0x0000001269077217ULL, 0x000fe40007800000ULL,
0x000000010c0c0810ULL, 0x000fc60007ffe0ffULL, 0x0000000107127824ULL, 0x000fe400078e0a12ULL,
0x0000000161077824ULL, 0x000fe400078e0235ULL, 0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107067824ULL, 0x040fe200078e0a12ULL, 0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL,
0x000000120700720cULL, 0x000fe40003f66070ULL, 0x0000000c100c7207ULL, 0x000fc40006000000ULL,
0x00005a000d007a0cULL, 0x000fe40003f06070ULL, 0x0000000605077217ULL, 0x000fe20003800000ULL,
0x0000000137067824ULL, 0x000fe200078e0a12ULL, 0x0000000c05517217ULL, 0x000fe40003800000ULL,
0x00000004ff077819ULL, 0x000fe40000011607ULL, 0x000000010f0f2810ULL, 0x000fe20007ffe0ffULL,
0x0000005168517224ULL, 0x000fe200078e02ffULL, 0x000000ff070e7207ULL, 0x000fc40001800000ULL,
0x000000123700720cULL, 0x000fe40003f26070ULL, 0x0000000605067217ULL, 0x000fe20003800000ULL,
0x0000000151077824ULL, 0x000fe200078e020eULL, 0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL,
0x000000ff06467207ULL, 0x000fe20000800000ULL, 0x0000000207067825ULL, 0x000fe200078e0042ULL,
0x0000000f10107207ULL, 0x000fe40006000000ULL, 0x00000010353b7812ULL, 0x000fc400078efcffULL,
0x00000051460d7211ULL, 0x000fe200078fe0ffULL, 0x00000008064a7981ULL, 0x0046a2000c1e9500ULL,
0x0000001005537217ULL, 0x000fc60003800000ULL, 0x000000020d0c7825ULL, 0x000fc800078e0042ULL,
0x0000000161077824ULL, 0x008fe200078e023bULL, 0x000000080c4f7981ULL, 0x0006a2000c1e9500ULL,
0x0000005368537224ULL, 0x000fe400078e02ffULL, 0x0000000107067824ULL, 0x000fe400078e0a12ULL,
0x000000010e0f7824ULL, 0x000fe200078e0253ULL, 0x00000020353d7812ULL, 0x000fe200078efcffULL,
0x000000013b397824ULL, 0x000fe200078e0200ULL, 0x00000006050c7217ULL, 0x008fe20003800000ULL,
0x000000020f0e7825ULL, 0x000fe200078e0042ULL, 0x000000120700720cULL, 0x000fc40003f26070ULL,
0x00000004ff0c7819ULL, 0x000fe2000001160cULL, 0x0000000139067824ULL, 0x000fe200078e0a12ULL,
0x0000005346117211ULL, 0x000fe200078fe0ffULL, 0x000000080e447981ULL, 0x0006a2000c1e9500ULL,
0x0000000161457824ULL, 0x000fe200078e023dULL, 0x000000123900720cULL, 0x000fe40003f06070ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x0000000605067217ULL, 0x000fe40003800000ULL,
0x000000ff0c0e7207ULL, 0x008fe20000800000ULL, 0x00000001453c7824ULL, 0x000fe200078e0a12ULL,
0x0000000810577981ULL, 0x0006a6000c1e9500ULL, 0x0000000151077824ULL, 0x000fe200078e020eULL,
0x000000ff06367207ULL, 0x000fc40000000000ULL, 0x0000003c053c7217ULL, 0x000fe20003800000ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x000000124500720cULL, 0x080fe40003f26070ULL,
0x00000004ff3c7819ULL, 0x000fe2000001163cULL, 0x000000013d417824ULL, 0x000fe200078e0200ULL,
0x0000000806387981ULL, 0x0002a2000c1e9500ULL, 0x0000003035457812ULL, 0x000fe400078efcffULL,
0x000000ff3c3e7207ULL, 0x000fe20000800000ULL, 0x000000010e0f7824ULL, 0x000fe200078e0253ULL,
0x00000051360d7211ULL, 0x040fe200078fe0ffULL, 0x0000000141067824ULL, 0x002fe200078e0a12ULL,
0x0000005336117211ULL, 0x008fe200078fe0ffULL, 0x0000000151077824ULL, 0x000fe200078e023eULL,
0x000000124100720cULL, 0x000fc40003f06070ULL, 0x0000000605067217ULL, 0x000fe20003800000ULL,
0x0000000161557824ULL, 0x000fe400078e0245ULL, 0x000000020d0c7825ULL, 0x000fe200078e0042ULL,
0x000000ff06407207ULL, 0x000fc60000000000ULL, 0x000000020f0e7825ULL, 0x100fe200078e0042ULL,
0x000000080c3f7981ULL, 0x0002e6000c1e9500ULL, 0x0000000211107825ULL, 0x100fe200078e0042ULL,
0x000000080e3a7981ULL, 0x0002e6000c1e9500ULL, 0x0000000207067825ULL, 0x000fe200078e0042ULL,
0x0000000810477981ULL, 0x0002e6000c1e9500ULL, 0x0000000155487824ULL, 0x000fe200078e0a12ULL,
0x00000008063c7981ULL, 0x0002e2000c1e9500ULL, 0x00000001454b7824ULL, 0x000fe200078e0200ULL,
0x00000051400d7211ULL, 0x002fc400078fe0ffULL, 0x0000004805487217ULL, 0x000fe20003800000ULL,
0x000000013e0f7824ULL, 0x000fe200078e0253ULL, 0x0000005340117211ULL, 0x000fe200078fe0ffULL,
0x000000014b067824ULL, 0x000fe200078e0a12ULL, 0x000000125500720cULL, 0x080fe40003f26070ULL,
0x00000004ff487819ULL, 0x000fe20000011648ULL, 0x000000020d0c7825ULL, 0x100fe200078e0042ULL,
0x000000124b00720cULL, 0x000fe40003f06070ULL, 0x0000000605067217ULL, 0x000fe20003800000ULL,
0x000000020f0e7825ULL, 0x100fe200078e0042ULL, 0x000000ff484c7207ULL, 0x000fe20000800000ULL,
0x000000080c497981ULL, 0x0002e4000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e0042ULL,
0x000000ff06487207ULL, 0x000fe20000000000ULL, 0x000000080e3e7981ULL, 0x0002e8000c1e9500ULL,
0x00000008104d7981ULL, 0x0002e2000c1e9500ULL, 0x0000000151077824ULL, 0x000fe200078e024cULL,
0x00000051480d7211ULL, 0x002fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fc800078e0042ULL,
0x000000020d0c7825ULL, 0x000fe400078e0042ULL, 0x0000000806067981ULL, 0x0002e2000c1e9500ULL,
0x00000053480f7211ULL, 0x000fc600078fe0ffULL, 0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014c117824ULL, 0x000fe400078e0253ULL, 0x000000020f0e7825ULL, 0x000fc800078e0042ULL,
0x0000000211107825ULL, 0x000fe400078e0042ULL, 0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000810117981ULL, 0x0002e2000c1e9500ULL, 0xfffffff046537812ULL, 0x000fe200078ec0ffULL,
0x00000001ff467424ULL, 0x000fc800078e00ffULL, 0x00000001124c7824ULL, 0x000fc800078e0253ULL,
0x0000000137597824ULL, 0x000fe200078e0a4cULL, 0x0000000135517812ULL, 0x040fe400078efcffULL,
0x0000000935077812ULL, 0x002fe400078efcffULL, 0x0000005946597219ULL, 0x000fe200000006ffULL,
0x0000000151557824ULL, 0x100fe400078e0200ULL, 0x00000001070f7824ULL, 0x000fe400078e0200ULL,
0x00000001555b7824ULL, 0x000fc400078e0a4cULL, 0x000000010f5f7824ULL, 0x000fc600078e0a4cULL,
0x0000005b465b7219ULL, 0x040fe400000006ffULL, 0x0000005f465f7219ULL, 0x000fe400000006ffULL,
0x00000011357b7812ULL, 0x040fe400078efcffULL, 0x0000001835797812ULL, 0x040fe400078efcffULL,
0xfffffff040407812ULL, 0x000fe400078ec0ffULL, 0x00000019356f7812ULL, 0x000fc400078efcffULL,
0xfffffff048487812ULL, 0x000fe200078ec0ffULL, 0x000000017b107824ULL, 0x100fe400078e0200ULL,
0x00000001790c7824ULL, 0x000fe400078e0200ULL, 0x0000000112647824ULL, 0x000fe400078e0240ULL,
0x000000016f7d7824ULL, 0x000fe400078e0200ULL, 0x0000000141587824ULL, 0x000fe200078e0a64ULL,
0x0000002135657812ULL, 0x000fc800078efcffULL, 0x0000005846587219ULL, 0x000fe200000006ffULL,
0x00000001656b7824ULL, 0x000fc800078e0200ULL, 0x000000016b5a7824ULL, 0x000fca00078e0a64ULL,
0x0000005a465a7219ULL, 0x000fe400000006ffULL, 0x000054104f4a7816ULL, 0x004fe4000000004aULL,
0x00000008354f7812ULL, 0x000fe400078efcffULL, 0x0000004a59ff7212ULL, 0x000fc6000780c0ffULL,
0x000000014f537824ULL, 0x000fe200078e0200ULL, 0x000000123700720cULL, 0x000fc60000701470ULL,
0x00000001535d7824ULL, 0x000fe200078e0a4cULL, 0x000000123500720cULL, 0x000fc800007a1070ULL,
0x0000005d465d7219ULL, 0x000fe400000006ffULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x0000541057447816ULL, 0x000fc80000000044ULL, 0x0000004459ff7212ULL, 0x080fe4000784c0ffULL,
0x000000445bff7212ULL, 0x080fe4000780c0ffULL, 0x000000445dff7212ULL, 0x080fe400078cc0ffULL,
0x000000445fff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff036447812ULL, 0x000fe400078ec0ffULL,
0x0000004a5bff7212ULL, 0x000fc6000782c0ffULL, 0x0000000112447824ULL, 0x040fe200078e0244ULL,
0x0000004a5dff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a5fff7212ULL, 0x000fe2000788c0ffULL,
0x00000001124a7824ULL, 0x000fe400078e0248ULL, 0x0000000139407824ULL, 0x100fe200078e0a44ULL,
0x000000123700720cULL, 0x080fe20001741470ULL, 0x0000000110487824ULL, 0x100fe200078e0a44ULL,
0x000000125300720cULL, 0x080fe200037c1470ULL, 0x000000010c547824ULL, 0x100fe200078e0a44ULL,
0x000000120f00720cULL, 0x000fe20002fa1470ULL, 0x000000017d6a7824ULL, 0x000fe200078e0a44ULL,
0x0000004046447219ULL, 0x000fc400000006ffULL, 0x0000004846407219ULL, 0x040fe400000006ffULL,
0x000000123500720cULL, 0x080fe40001741070ULL, 0x000000124f00720cULL, 0x080fe400037c1070ULL,
0x000000120700720cULL, 0x000fe40002fa1070ULL, 0x0000005446487219ULL, 0x000fe400000006ffULL,
0x000054103f3f7816ULL, 0x008fc40000000038ULL, 0x0000541047477816ULL, 0x000fe4000000003aULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0x0000003f44ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004744ff7212ULL, 0x000fc400078cc0ffULL, 0x0000004748ff7212ULL, 0x000fe400078ac0ffULL,
0x000000125500720cULL, 0x0c0fe40000f21470ULL, 0x000000125500720cULL, 0x080fe40000701470ULL,
0x000000125300720cULL, 0x080fe40001f61470ULL, 0x000000120f00720cULL, 0x080fe40002781470ULL,
0x000000123900720cULL, 0x000fc40001741470ULL, 0x000000123900720cULL, 0x080fe400037c1470ULL,
0x000000120c00720cULL, 0x080fe40002fa1470ULL, 0x00000028355f7812ULL, 0x040fe400078efcffULL,
0x00000029355d7812ULL, 0x000fe400078efcffULL, 0x000000125100720cULL, 0x0c0fe40000f21070ULL,
0x000000125100720cULL, 0x000fc40000701070ULL, 0x000000124f00720cULL, 0x080fe40001f61070ULL,
0x000000120700720cULL, 0x080fe40002781070ULL, 0x000000123b00720cULL, 0x0c0fe40001741070ULL,
0x000000123b00720cULL, 0x080fe400037c1070ULL, 0x000000127900720cULL, 0x000fe40002fa1070ULL,
0x0000006a46547219ULL, 0x000fc400000006ffULL, 0x0000541049497816ULL, 0x000fe4000000003cULL,
0x000054104d4d7816ULL, 0x000fe2000000003eULL, 0x000000015f367824ULL, 0x100fe200078e0200ULL,
0xff80000028287808ULL, 0x000fe20000800000ULL, 0x000000015d527824ULL, 0x000fe200078e0200ULL,
0xff80000016167808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000017177808ULL, 0x000fc40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x0000003f40ff7212ULL, 0x080fe4000782c0ffULL, 0x0000003f48ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003f54ff7212ULL, 0x000fc4000786c0ffULL, 0x0000004740ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004754ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004958ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004d58ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000136667824ULL, 0x100fe200078e0a64ULL,
0x000000121000720cULL, 0x080fe20000f21470ULL, 0x0000000152647824ULL, 0x000fe200078e0a64ULL,
0x000000121000720cULL, 0x080fe20002781470ULL, 0x000000014b607824ULL, 0x000fe200078e0a4aULL,
0x000000120c00720cULL, 0x000fc40000701470ULL, 0x000000127d00720cULL, 0x0c0fe40001f61470ULL,
0x000000127d00720cULL, 0x080fe40001741470ULL, 0x000000124100720cULL, 0x0c0fe400037c1470ULL,
0x000000124100720cULL, 0x000fe40002fa1470ULL, 0x00000031355b7812ULL, 0x040fe400078efcffULL,
0x0000003835597812ULL, 0x000fc400078efcffULL, 0x0000003935577812ULL, 0x000fe400078efcffULL,
0x000000127b00720cULL, 0x0c0fe40000f21070ULL, 0x000000127b00720cULL, 0x080fe40002781070ULL,
0x000000127900720cULL, 0x080fe40000701070ULL, 0x000000126f00720cULL, 0x0c0fe40001f61070ULL,
0x000000126f00720cULL, 0x000fc40001741070ULL, 0x000000123d00720cULL, 0x0c0fe400037c1070ULL,
0x000000123d00720cULL, 0x000fe40002fa1070ULL, 0x0000006646667219ULL, 0x040fe400000006ffULL,
0x0000006446647219ULL, 0x040fe400000006ffULL, 0x0000006046607219ULL, 0x000fe400000006ffULL,
0x000054100d0d7816ULL, 0x000fe20000000006ULL, 0x000000015b507824ULL, 0x100fe200078e0200ULL,
0xff8000002a2a7808ULL, 0x000fe20000800000ULL, 0x00000001594e7824ULL, 0x100fe200078e0200ULL,
0xff80000021217808ULL, 0x000fe20002000000ULL, 0x00000001574c7824ULL, 0x000fe200078e0200ULL,
0xff8000002b2b7808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0x000000495aff7212ULL, 0x080fe4000782c0ffULL,
0x0000004966ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004964ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004d5aff7212ULL, 0x080fe4000786c0ffULL, 0x0000004d66ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004d64ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000d60ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001505c7824ULL, 0x100fe200078e0a4aULL, 0x000000126b00720cULL, 0x0c0fe20000f21470ULL,
0x000000014e567824ULL, 0x100fe200078e0a4aULL, 0x000000126b00720cULL, 0x080fe20001f61470ULL,
0x000000014c4a7824ULL, 0x000fe200078e0a4aULL, 0x000000123600720cULL, 0x000fc40002781470ULL,
0x000000123600720cULL, 0x080fe40001741470ULL, 0x000000125200720cULL, 0x0c0fe40000701470ULL,
0x000000125200720cULL, 0x080fe400037c1470ULL, 0x000000124b00720cULL, 0x080fe40002fa1470ULL,
0x000000126500720cULL, 0x0c0fe40000f21070ULL, 0x000000126500720cULL, 0x000fc40001f61070ULL,
0x000000125f00720cULL, 0x0c0fe40002781070ULL, 0x000000125f00720cULL, 0x080fe40001741070ULL,
0x000000125d00720cULL, 0x0c0fe40000701070ULL, 0x000000125d00720cULL, 0x080fe400037c1070ULL,
0x000000124500720cULL, 0x000fe40002fa1070ULL, 0x0000005c465c7219ULL, 0x000fc400000006ffULL,
0x0000005646567219ULL, 0x040fe400000006ffULL, 0x0000004a464a7219ULL, 0x000fe400000006ffULL,
0x000054100e117816ULL, 0x000fe40000000011ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fc40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40000000000ULL,
0xff8000001d1d7808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0x0000000d5cff7212ULL, 0x080fe4000782c0ffULL, 0x0000000d56ff7212ULL, 0x000fc4000786c0ffULL,
0x0000000d4aff7212ULL, 0x000fe4000788c0ffULL, 0x0000001160ff7212ULL, 0x080fe4000784c0ffULL,
0x000000115cff7212ULL, 0x080fe4000780c0ffULL, 0x0000001156ff7212ULL, 0x080fe400078cc0ffULL,
0x000000114aff7212ULL, 0x000fe400078ac0ffULL, 0x000000124b00720cULL, 0x000fc40001741470ULL,
0x000000125000720cULL, 0x0c0fe40000f21470ULL, 0x000000125000720cULL, 0x080fe40000701470ULL,
0x000000124e00720cULL, 0x0c0fe40001f61470ULL, 0x000000124e00720cULL, 0x080fe400037c1470ULL,
0x000000124c00720cULL, 0x0c0fe40002781470ULL, 0x000000124c00720cULL, 0x000fc40002fa1470ULL,
0x000000124500720cULL, 0x080fe40001741070ULL, 0x000000125b00720cULL, 0x0c0fe40000f21070ULL,
0x000000125b00720cULL, 0x080fe40000701070ULL, 0x000000125900720cULL, 0x0c0fe40001f61070ULL,
0x000000125900720cULL, 0x080fe400037c1070ULL, 0x000000125700720cULL, 0x000fc40002781070ULL,
0x000000125700720cULL, 0x000fe40002fa1070ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff80000019197808ULL, 0x000fc40000000000ULL,
0xff8000001a1a7808ULL, 0x000fe40003000000ULL, 0xff8000001b1b7808ULL, 0x000fc40002800000ULL,
0x000000150800720bULL, 0x004fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000815077208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000728067208ULL, 0x000fe40004000000ULL, 0x0000000916087208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000629067208ULL, 0x000fc40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000170600720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000617067208ULL, 0x000fe40004000000ULL, 0x0000000823077208ULL, 0x000fe40004800000ULL,
0x0000002f0600720bULL, 0x000fc40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x000000062f097208ULL, 0x000fe40004000000ULL, 0x0000000722067208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fe40003f3e000ULL,
0x000000092a087208ULL, 0x000fc40004000000ULL, 0x0000000621077208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fe40003f1e000ULL, 0x000000240700720bULL, 0x000fe40003f3e000ULL,
0x000000082b097208ULL, 0x000fe40004000000ULL, 0x0000000724067208ULL, 0x000fe40004800000ULL,
0x000000340900720bULL, 0x000fc40003f1e000ULL, 0x000000330600720bULL, 0x000fe40003f3e000ULL,
0x0000000934097208ULL, 0x000fe40004000000ULL, 0x0000000633067208ULL, 0x000fe40004800000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x000000250600720bULL, 0x000fe40003f3e000ULL,
0x0000000932097208ULL, 0x000fc40004000000ULL, 0x0000000625077208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x000000140700720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x0000000714077208ULL, 0x000fe40004800000ULL,
0x0000002d0600720bULL, 0x000fc40003f1e000ULL, 0x0000001c0700720bULL, 0x000fe40003f3e000ULL,
0x000000062d067208ULL, 0x000fe40004000000ULL, 0x000000071c087208ULL, 0x000fe40004800000ULL,
0x000000310600720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x0000000631077208ULL, 0x000fc40004000000ULL, 0x000000081d097208ULL, 0x000fe40004800000ULL,
0x000000300700720bULL, 0x000fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x0000000730077208ULL, 0x000fe40004000000ULL, 0x0000000918067208ULL, 0x000fe40004800000ULL,
0x0000002e0700720bULL, 0x000fc40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000072e077208ULL, 0x000fe40004000000ULL, 0x0000000619097208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fe40003f1e000ULL, 0x0000001a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000726067208ULL, 0x000fc40004000000ULL, 0x000000091a087208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x0000001b0800720bULL, 0x000fe40003f3e000ULL,
0x00000006270c7208ULL, 0x000fe40004000000ULL, 0x000000081b0e7208ULL, 0x000fe20004800000ULL,
0x000016b27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000c067f89ULL, 0x0004e400000e0000ULL,
0x000000060c00720bULL, 0x008fc80003f1e000ULL, 0x0000000c060f7208ULL, 0x000fe20004000000ULL,
0x000016e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000e067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b0c7f89ULL, 0x006e6800000e0000ULL,
0x0c201f000f107f89ULL, 0x000ea200000e0000ULL, 0x000000060e00720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x000fe40003f3e000ULL, 0x0000000e06087208ULL, 0x000fe40004000000ULL,
0x0000000a07097208ULL, 0x000fe40004800000ULL, 0x0000000c0b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f0008117f89ULL, 0x000e6600000e0000ULL, 0x0000000b0c067208ULL, 0x000fe20004000000ULL,
0x0c201f0009127f89ULL, 0x000ee200000e0000ULL, 0x000000100f00720bULL, 0x004fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0004a200000e0000ULL, 0x0000000f10107208ULL, 0x000fe40004000000ULL,
0x000000110800720bULL, 0x002fe40003f3e000ULL, 0x000000120900720bULL, 0x008fe40003f5e000ULL,
0x0000000811117208ULL, 0x000fe40004800000ULL, 0x0000000912127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10087820ULL, 0x004fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000303ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b2b0f7823ULL, 0x100fe20000010808ULL,
0x000000070600720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2d2b7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b112d7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b2f0b7823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010808ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082dULL,
0x00000028000a7308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b2c2f7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b22227823ULL, 0x000fe4000001082dULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010808ULL, 0x0000002900097308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b32287823ULL, 0x104fe40000010808ULL, 0x3fb8aa3b312c7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b26267823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010808ULL,
0x00000017000c7308ULL, 0x002e620000000800ULL, 0x3fb8aa3b30297823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001082dULL, 0x0000000b000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc6000001082dULL, 0x0000002a000e7308ULL, 0x0004700000000800ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2a7823ULL, 0x004fe20000010808ULL,
0x000000150a08723eULL, 0x008fc400000000ffULL, 0x000000090c0a723eULL, 0x002fc800000000ffULL,
0x00000016000b7308ULL, 0x000e620000000800ULL, 0x0000000d0e0c723eULL, 0x000fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x00000023002e7308ULL, 0x0004e20000000800ULL,
0x0000001e0b09723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b141e7823ULL, 0x000fcc000001082dULL,
0x0000002200307308ULL, 0x0003e20000000800ULL, 0x3c003c00ff237424ULL, 0x004fe200078e00ffULL,
0x0000001f2e0b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff227424ULL, 0x002fca00078e00ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x3fb8aa3b181f7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b1a2e7823ULL, 0x000fe2000001082dULL, 0x000000220814723cULL, 0x000f6800000018ffULL,
0x0000002100217308ULL, 0x000eb00000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000000f340e723eULL, 0x002fc400000000ffULL, 0x00000002ff347819ULL, 0x000fc80000011603ULL,
0x0000000234327810ULL, 0x040fe20007ffe0ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x00000030210d723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b19217823ULL, 0x100fe2000001082dULL,
0x0000000134307810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b1b2d7823ULL, 0x000fe2000001082dULL,
0x0000000834397810ULL, 0x040fe20007ffe0ffULL, 0x0000000834357824ULL, 0x040fe400078e00ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000000834317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fe400078ee230ULL, 0x00000024330f723eULL, 0x002fe200000000ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000000834337824ULL, 0x000fca00078e00ffULL,
0x000000220c18723cULL, 0x020b620000001814ULL, 0xfffffff833337812ULL, 0x000fe200078ee232ULL,
0x0000002b002b7308ULL, 0x000fea0000000800ULL, 0x0000000834167824ULL, 0x060fe200078e00ffULL,
0x0000000334147810ULL, 0x040fe40007ffe0ffULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x0000000434157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff835357812ULL, 0x000fe400078ee214ULL,
0xfffffff816377812ULL, 0x000fe400078ee215ULL, 0x000000282f14723eULL, 0x002fe200000000ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000000834287824ULL, 0x040fe400078e00ffULL,
0x00000008342f7824ULL, 0x000fca00078e00ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x0000002b2c16723eULL, 0x004fe200000000ffULL, 0x00000008392c7824ULL, 0x000fca00078e00ffULL,
0xfffffff82c397812ULL, 0x000fe200078ee239ULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x000000251e15723eULL, 0x002fe200000000ffULL,
0x0000000834257824ULL, 0x040fe200078e00ffULL, 0xffffffff341e7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x0000001c1d17723eULL, 0x004fce00000000ffULL, 0x0000002100247308ULL, 0x0002a20000000800ULL,
0x00000006341d7810ULL, 0x040fe40007ffe0ffULL, 0x00000005341c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8282b7812ULL, 0x000fe200078ee21dULL, 0x000000221418723cULL, 0x000f620000001818ULL,
0xfffffff825257812ULL, 0x000fe200078ee21cULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x0000000834217824ULL, 0x002fca00078e00ffULL, 0xfffffff821217812ULL, 0x000fe400078ee234ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x0000001f241d723eULL, 0x004fe400000000ffULL,
0x0000000c13247812ULL, 0x000fe400078ec0ffULL, 0x0000000607137208ULL, 0x000fc60004800000ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000292a1c723eULL, 0x002fce00000000ffULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x00000026271e723eULL, 0x004fe400000000ffULL,
0x0001100002267811ULL, 0x000fca00078e58ffULL, 0x0000001021217824ULL, 0x100fe400078e0226ULL,
0x0000001031317824ULL, 0x100fe400078e0226ULL, 0x0000001033337824ULL, 0x100fe400078e0226ULL,
0x0000001035357824ULL, 0x100fe200078e0226ULL, 0x0000002e2d1f723eULL, 0x002fe200000000ffULL,
0x0000001037377824ULL, 0x000fe400078e0226ULL, 0x0000000121217824ULL, 0x000fc400078e0224ULL,
0x0000001025257824ULL, 0x100fe400078e0226ULL, 0x000000221c18723cULL, 0x020f620000001818ULL,
0x0000000124317824ULL, 0x040fe200078e0231ULL, 0x0000000821007388ULL, 0x0003e20000000800ULL,
0x000000102b2b7824ULL, 0x100fe400078e0226ULL, 0x0000000124337824ULL, 0x040fe200078e0233ULL,
0x0000000a31007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe400078e0226ULL,
0x0000000124357824ULL, 0x000fe200078e0235ULL, 0x0000000c33007388ULL, 0x0003e20000000800ULL,
0x0000001039397824ULL, 0x000fc400078e0226ULL, 0x0000000124377824ULL, 0x040fe200078e0237ULL,
0x0000000e35007388ULL, 0x0003e20000000800ULL, 0x0000000124257824ULL, 0x040fe400078e0225ULL,
0x00000001242b7824ULL, 0x040fe200078e022bULL, 0x0000001437007388ULL, 0x0003e20000000800ULL,
0x00000001242f7824ULL, 0x040fe400078e022fULL, 0x0000000124247824ULL, 0x000fe200078e0239ULL,
0x0000001625007388ULL, 0x0003e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x0000001c2b007388ULL, 0x0003e80000000800ULL, 0x0000001e2f007388ULL, 0x0003e80000000800ULL,
0x0000000924007388ULL, 0x0003e80000000800ULL, 0x0004000b31007388ULL, 0x0003e80000000800ULL,
0x0004000d33007388ULL, 0x0003e80000000800ULL, 0x0004000f35007388ULL, 0x0003e80000000800ULL,
0x0004001537007388ULL, 0x0003e80000000800ULL, 0x0004001725007388ULL, 0x0003e80000000800ULL,
0x0004001d2b007388ULL, 0x0003e80000000800ULL, 0x0004001f2f007388ULL, 0x0003e80000000800ULL,
0x0170001020008388ULL, 0x0003e80000000c00ULL, 0x0172001820008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000075ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080075ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100075ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000015e5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000180075ff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff1f7224ULL, 0x002fe200078e0063ULL,
0x0000006d5e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffa95000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff347807ULL, 0x002fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0001420000357802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x018fea0003c00000ULL,
0xfffee63000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001425000357802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0040ULL,
0xfffee66000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000fULL,
0x000142c000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000e2000007944ULL, 0x018fea0003c00000ULL,
0xfffee73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000fULL,
0x0001432000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000dc000007944ULL, 0x018fea0003c00000ULL,
0xfffee83000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0000ULL,
0x0001439000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e000dULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000d5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0040ULL,
0xfffeec3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0000ULL,
0x0001440000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0040ULL, 0xfffeebf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0001446000357802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0xffff0bc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x000144b000357802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff397224ULL, 0x000fe200078e0040ULL,
0xffff0bf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x0001452000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x008fea0003c00000ULL,
0xffff0cc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x0001458000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x008fea0003c00000ULL,
0xffff0dc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x000145f000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e0036ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0040ULL,
0xffff11d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x0001466000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000a8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0040ULL, 0xffff119000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x000146c000357802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x018fea0003c00000ULL,
0xffff2f8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001471000357802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0040ULL,
0xffff2fc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003dULL,
0x0001478000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0xffff309000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003dULL,
0x000147e000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000090000007944ULL, 0x018fea0003c00000ULL,
0xffff319000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x0001485000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e000fULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0040ULL,
0xffff35a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x000148c000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0040ULL, 0xffff356000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0001492000357802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x018fea0003c00000ULL,
0xffff53c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001497000357802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0040ULL,
0xffff540000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0027ULL,
0x000149e000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000070000007944ULL, 0x018fea0003c00000ULL,
0xffff54d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0027ULL,
0x00014a4000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x018fea0003c00000ULL,
0xffff55d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0007ULL,
0x00014ab000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e0024ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0040ULL,
0xffff5a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0007ULL,
0x00014b2000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0040ULL, 0xffff5a0000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x00014b9000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0xffffe8f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x006fe200078e000eULL,
0x00014c1000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x010fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x00014c9000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e070e7208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000bULL, 0x00014d1000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a070a7208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000070b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000fULL, 0x00014d9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b07067208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000070f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000eULL, 0x00014e1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000f07107208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000070e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x00014e9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e07117208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000070a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0006ULL, 0x00014f1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a07127208ULL, 0x000fe20004000000ULL,
0x0000001fff077424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe6e000007947ULL, 0x000fea000383ffffULL,
0x0180000010007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001000008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff10ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000010027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001000007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffeaf6002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000d0c077389ULL, 0x0002a200000e0007ULL, 0xfffeaf2008007950ULL, 0x000fea0003c3ffffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0000003435407389ULL, 0x0002a400000e0043ULL,
0x000000ffff347224ULL, 0x002fc400078e0041ULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffeaed034007950ULL, 0x000fea0003c3ffffULL, 0x000000013400780cULL, 0x000fe20003f45070ULL,
0x000000ffff347224ULL, 0x000fe200078e0035ULL, 0x0000004100007348ULL, 0x000fe80003800000ULL,
0x00000000ff357424ULL, 0x000fce00078e00ffULL, 0x0000000000407806ULL, 0x000fc800050e0100ULL,
0x0000004140407212ULL, 0x000fe200078ec0ffULL, 0xfffeae6034007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000310ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d00ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001590ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015a0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001630ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001634ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000015280ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016a80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016ad0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016e50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001630ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015450ULL, 0x0000000000015450ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 94000;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
