/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000010870ULL, 0x00000000000103f0ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x000000000000f050ULL, 0x0000000000000230ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x000000000000f280ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000f05000000000ULL, 0x0000740400000000ULL, 0x0400288080810c00ULL, 0x0000000000003b94ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080860828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808089920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006800000000ULL, 0x0000f05000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL,
0x808c288080860900ULL, 0x0900000004042880ULL, 0x2880808628808089ULL, 0x0000000e00082f04ULL,
0x000812040000007fULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000eULL, 0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00801b0380005003ULL, 0x0000e19000103104ULL, 0x0000e1b00000e1a0ULL,
0x00e429040000e1c0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002a05000021ULL, 0x050000210500002aULL, 0x0500002105000021ULL,
0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL,
0x0500003c0500003cULL, 0x00e428040500003cULL, 0x00000130000000d0ULL, 0x000018f000001850ULL,
0x0000198000001960ULL, 0x00001ed000001df0ULL, 0x00003360000032e0ULL, 0x00003410000033d0ULL,
0x0000382000003760ULL, 0x000049e000004960ULL, 0x00004a9000004a50ULL, 0x00004e2000004e10ULL,
0x0000606000005fe0ULL, 0x00006110000060d0ULL, 0x0000645000006440ULL, 0x0000745000007440ULL,
0x000098a000009870ULL, 0x00009ee000009eb0ULL, 0x0000dac00000dab0ULL, 0x0000dae00000dad0ULL,
0x0000db300000db10ULL, 0x0000db600000db50ULL, 0x0000e1a00000e180ULL, 0x0000e1f00000e1b0ULL,
0x0000e2100000e200ULL, 0x0000ebf00000eb60ULL, 0x0000ecb00000ec50ULL, 0x0000ed800000ed20ULL,
0x0000ee400000ede0ULL, 0x0000ef700000eed0ULL, 0x04b039040000f010ULL, 0x000000ff00000220ULL,
0x000401000000f600ULL, 0x0000000900000300ULL, 0x003f01000000f608ULL, 0x0000000900000410ULL,
0x003f01000000f688ULL, 0x0000000300000530ULL, 0x003f01000000f6a8ULL, 0x0000000200000640ULL,
0x003f01000000f6c8ULL, 0x00000002000008b0ULL, 0x003f01070000f600ULL, 0x0000000800000aa0ULL,
0x003f01010000f688ULL, 0x000000ff00000f10ULL, 0x0004010700000000ULL, 0x000000ff00000f60ULL,
0x0004010100000000ULL, 0x0000001a00000fe0ULL, 0x003f010100000020ULL, 0x00000051000011a0ULL,
0x003f010500000000ULL, 0x00000053000013a0ULL, 0x003f01090000f6c8ULL, 0x000000ff00001630ULL,
0x0004010700000000ULL, 0x000000ff00001670ULL, 0x0004010100000000ULL, 0x0000001b000016d0ULL,
0x003f010500000000ULL, 0x0000004f00001710ULL, 0x003f01010000f608ULL, 0x0000006600001720ULL,
0x003f01090000f608ULL, 0x0000001b00001c10ULL, 0x003f010900000000ULL, 0x0000004900002cd0ULL,
0x003f01010000f6c8ULL, 0x0000004b00002cf0ULL, 0x003f01010000f688ULL, 0x0000005100002d20ULL,
0x003f010500000000ULL, 0x0000005300002df0ULL, 0x003f01090000f6c8ULL, 0x000000ff000031c0ULL,
0x0004010700000000ULL, 0x000000ff000031f0ULL, 0x0004010100000000ULL, 0x000000ff00003220ULL,
0x0005010500000000ULL, 0x0000004f00003230ULL, 0x003f01010000f628ULL, 0x0000006600003240ULL,
0x003f01090000f628ULL, 0x00000021000036a0ULL, 0x003f01090000f6a8ULL, 0x0000004900004570ULL,
0x003f01010000f6c8ULL, 0x0000004b000045a0ULL, 0x003f01010000f690ULL, 0x00000051000045d0ULL,
0x003f010500000000ULL, 0x0000001b00004680ULL, 0x003f01090000f6a8ULL, 0x000000ff00004850ULL,
0x0005010700000000ULL, 0x000000ff00004880ULL, 0x0005010100000000ULL, 0x000000ff000048b0ULL,
0x0004010500000000ULL, 0x0000004f000048c0ULL, 0x003f01010000f648ULL, 0x00000066000048d0ULL,
0x003f01090000f648ULL, 0x0000001900004d20ULL, 0x003f01090000f6a8ULL, 0x0000004900005bf0ULL,
0x003f01010000f6c8ULL, 0x0000004b00005c10ULL, 0x003f01010000f698ULL, 0x0000005100005c50ULL,
0x003f010500000000ULL, 0x0000005300005d10ULL, 0x003f01090000f6c8ULL, 0x000000ff00005f00ULL,
0x0004010700000000ULL, 0x0000005700005f30ULL, 0x003f010100000000ULL, 0x000000ff00005f60ULL,
0x0005010500000000ULL, 0x0000004f00005f70ULL, 0x003f01010000f668ULL, 0x0000004f00005f80ULL,
0x003f01090000f668ULL, 0x00000019000063b0ULL, 0x003f01090000f6a8ULL, 0x00000049000071a0ULL,
0x003f01010000f6c8ULL, 0x0000004b000071e0ULL, 0x003f01010000f6a0ULL, 0x000000020000a800ULL,
0x003f01010000f600ULL, 0x000000020000b2e0ULL, 0x003f01090000f600ULL, 0x000000020000b490ULL,
0x003f01010000f600ULL, 0x000000020000b4a0ULL, 0x003f01090000f600ULL, 0x000000090000d200ULL,
0x003f01010000f688ULL, 0x000000090000d380ULL, 0x003f01090000f688ULL, 0x0000000a0000e500ULL,
0x003f01010000f608ULL, 0x0000000a0000e510ULL, 0x003f01010000f610ULL, 0x0000000a0000e520ULL,
0x003f01010000f618ULL, 0x0000000a0000e530ULL, 0x003f01010000f620ULL, 0x000000530000e560ULL,
0x003f01090000f6c8ULL, 0x000000660000e5c0ULL, 0x003f01090000f608ULL, 0x0000001b0000e620ULL,
0x003f010900000000ULL, 0x000000530000e680ULL, 0x003f01090000f6c8ULL, 0x000000660000e6e0ULL,
0x003f01090000f628ULL, 0x000000210000e740ULL, 0x003f01090000f6a8ULL, 0x0000001b0000e7a0ULL,
0x003f01090000f6a8ULL, 0x000000660000e800ULL, 0x003f01090000f648ULL, 0x000000190000e860ULL,
0x003f01090000f6a8ULL, 0x000000530000e8c0ULL, 0x003f01090000f6c8ULL, 0x0000004f0000e920ULL,
0x003f01090000f668ULL, 0x000000190000e980ULL, 0x003f01090000f6a8ULL, 0x000000020000e9e0ULL,
0x003f01090000f600ULL, 0x000000020000ea40ULL, 0x003f01090000f600ULL, 0x000000090000eaa0ULL,
0x003f01090000f688ULL, 0x00141c0400053803ULL, 0x0000a7500000a4f0ULL, 0x0000b5400000b4c0ULL,
0x000c05040000e550ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0050190300000000ULL,
0x0000000f00080a04ULL, 0x0004360400500210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000d4ULL, 0x0000000e00000002ULL, 0x000000000000f050ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000aaULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000087919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000023000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000000000f7919ULL, 0x000f2a0000002100ULL,
0x00008400ff127b82ULL, 0x000f620000000800ULL, 0x00000000000d7919ULL, 0x000f620000002700ULL,
0x0000000000077919ULL, 0x000f6c0000008800ULL, 0x00008800ff047b82ULL, 0x000f700000000a00ULL,
0x00000000000679c3ULL, 0x000f620000002600ULL, 0x00000004ff0e7e24ULL, 0x008fc4000f8e00ffULL,
0x0000000108007824ULL, 0x004fe400078e0203ULL, 0x00001fff08087589ULL, 0x000f6400000e0000ULL,
0x0000008000027824ULL, 0x110fe200078e020fULL, 0x00000005ff0f7819ULL, 0x000fe2000001160fULL,
0x0000000000007919ULL, 0x000f660000000000ULL, 0x0000007f0200780cULL, 0x040fe40003f84070ULL,
0x000000ff0200720cULL, 0x040fe20003f05270ULL, 0x00001fff0f0f7589ULL, 0x000f6200000e0000ULL,
0x0000000f0200780cULL, 0x000fc40003f24070ULL, 0x000000030200780cULL, 0x040fe40003f64070ULL,
0x000000010200780cULL, 0x000fca0003f44070ULL, 0x000000000006c919ULL, 0x000ea20000008800ULL,
0x000004000003c802ULL, 0x000fc80000000f00ULL, 0x000006540603c816ULL, 0x004fe20000000003ULL,
0xff317217ff06c424ULL, 0x000fc800078e00ffULL, 0x000000040203c824ULL, 0x000fe200078e0203ULL,
0x0000000000240947ULL, 0x022fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00f60008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402097c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090712caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f60804073f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402097c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000090712caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f68804073f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00f400060300c388ULL, 0x0007e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x008fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000030712caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f6a804073f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000020712caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f6c804073f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000408027824ULL, 0x000fe200078e020fULL, 0x0000000306047899ULL, 0x002fe2000800063fULL,
0x0000040000067802ULL, 0x008fe20000000f00ULL, 0x0000000812037824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011600ULL, 0x0000000202097824ULL, 0x000fe200078e00ffULL,
0x0000065407027816ULL, 0x000fe20000000006ULL, 0x0000000000007b1dULL, 0x004fe20000010000ULL,
0x0000000403037e24ULL, 0x000fe4000f8e020dULL, 0x00000008090a7848ULL, 0x040fe20007fe0000ULL,
0x0000000109107824ULL, 0x000fe200078e020bULL, 0x00000000020472caULL, 0x000fe200000e0000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000820000087ab9ULL, 0x000fe20000000a00ULL,
0x000000010a0a7824ULL, 0x000fe200078e0a09ULL, 0x0000000710097812ULL, 0x000fe200078ec0ffULL,
0x0000000103037824ULL, 0x000fe200078e0210ULL, 0x00008c00ff067b82ULL, 0x000e640000000a00ULL,
0x0000000f09097812ULL, 0x000fe200078e7800ULL, 0x0000010003047825ULL, 0x000fe200078e0004ULL,
0x000000f00c037812ULL, 0x000fc400078ec0ffULL, 0x0000000a0b00720cULL, 0x000fe20003f06070ULL,
0x0000001010097824ULL, 0x000fe200078e0209ULL, 0x0000000304047210ULL, 0x000fe20007f3e0ffULL,
0x0000f60004047890ULL, 0x000fe4000fffe03fULL, 0x0000001009097824ULL, 0x000fe400078e0202ULL,
0x000000ffff057224ULL, 0x000fcc00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0005e2000c101c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x000000040d067825ULL, 0x002fe200078e0006ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000806037981ULL, 0x000ee2000c1e1900ULL, 0x00000300ff047b82ULL, 0x004e620000000800ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x000000ff03057836ULL, 0x008fca0000000000ULL,
0x00000008ff057819ULL, 0x000fce0000011605ULL, 0x0000009c00808947ULL, 0x002fea0003800000ULL,
0x000000020d067824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fe20000011600ULL,
0x0000000612077c36ULL, 0x000fe20008000000ULL, 0x00000001ff0b7819ULL, 0x000fe2000001160fULL,
0x000000100f097824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000010e087836ULL, 0x000fe20000000000ULL, 0x000000700c277812ULL, 0x000fe200078ec0ffULL,
0x0000001206067224ULL, 0x000fe200078e0207ULL, 0x0000001009077812ULL, 0x000fe200078ec0ffULL,
0x000000080f097824ULL, 0x000fe200078e00ffULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x0000000410167836ULL, 0x000fe20000000000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000004ff157424ULL, 0x000fc400078e00ffULL, 0x0000000107177824ULL, 0x000fe400078e0216ULL,
0x0000000102087824ULL, 0x000fe400078e0209ULL, 0x000000080e137824ULL, 0x000fe200078e020bULL,
0x00000000170d7212ULL, 0x080fe200078e3cffULL, 0x0000000107117824ULL, 0x000fe200078e0210ULL,
0x00f6881508ff79a7ULL, 0x0003e2000850003fULL, 0x0000000817187824ULL, 0x000fe400078e00ffULL,
0x0000000811197824ULL, 0x040fe200078e00ffULL, 0x00000000110a7212ULL, 0x000fe200078e3cffULL,
0x0000000c101c7836ULL, 0x040fe20000000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee20dULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0xfffffff819127812ULL, 0x000fe200078ee20aULL,
0x0000000810197836ULL, 0x000fc40000000000ULL, 0x0000002013087824ULL, 0x002fe400078e00ffULL,
0x00000001071b7824ULL, 0x000fe400078e0219ULL, 0x000020000b137824ULL, 0x000fe200078e0202ULL,
0x00000008030d7248ULL, 0x000fe20007fe0000ULL, 0x00008a00ff147b82ULL, 0x000e620000000a00ULL,
0x000000081b217824ULL, 0x040fe200078e00ffULL, 0x000000001b1a7212ULL, 0x080fe200078e3cffULL,
0x00000001071d7824ULL, 0x000fe400078e021cULL, 0x000000010d0d7824ULL, 0x100fe200078e0a08ULL,
0xfffffff8211a7812ULL, 0x000fe200078ee21aULL, 0x0000000406087c24ULL, 0x000fe2000f8e0208ULL,
0x000000001d1e7212ULL, 0x000fe200078e3cffULL, 0x0000b00013137836ULL, 0x000fe20000000000ULL,
0x000000200d0a7807ULL, 0x000fe20000000000ULL, 0x0000000108117824ULL, 0x040fe200078e0211ULL,
0x000000000b0472caULL, 0x000fe200000e0000ULL, 0x0000000108237824ULL, 0x000fe200078e021dULL,
0x000000070a0a7248ULL, 0x000fe20007fe0000ULL, 0x000000081d1d7824ULL, 0x000fc400078e00ffULL,
0x000000101a217824ULL, 0x000fe400078e0213ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a07ULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee21eULL, 0x0000f6a8021a7836ULL, 0x000fe40000000000ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000000a1000720cULL, 0x080fe20003f46070ULL,
0x0000008011107825ULL, 0x002fe200078e0014ULL, 0x000000001a0572caULL, 0x000fe400000e0000ULL,
0x0000000a1600720cULL, 0x080fe20003f26070ULL, 0x00000001081f7824ULL, 0x000fe200078e021bULL,
0x0000002710107210ULL, 0x000fe20007f7e0ffULL, 0x00000010121b7824ULL, 0x100fe200078e0213ULL,
0x0000000a1900720cULL, 0x000fe20003f06070ULL, 0x00000010181d7824ULL, 0x000fc400078e0213ULL,
0x000000101e257824ULL, 0x000fe400078e0213ULL, 0x00000080170c7825ULL, 0x100fe200078e0014ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe4000f8e203fULL,
0x000000801f127825ULL, 0x000fe200078e0014ULL, 0x000000270c0c7210ULL, 0x000fc60007f9e0ffULL,
0x0000008023147825ULL, 0x000fe200078e0014ULL, 0x0000002712127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000000a1c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x0000002714187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101b7faeULL, 0x0003e2000d101c48ULL, 0x00000001ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200030e0615ULL,
0x000000000c1d7faeULL, 0x000fe2000c901c48ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000012217faeULL, 0x0005e2000c101c48ULL, 0x000000050e00720cULL, 0x000fe20003f06070ULL,
0x000000080b1a7824ULL, 0x000fc400078e021aULL, 0x0000000018257faeULL, 0x0007e2000d901c48ULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000127805ULL, 0x004fe4000001ff00ULL,
0x0000000000247805ULL, 0x008fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001fff6e79a7ULL, 0x0002a20008500004ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000201f1a1c79a7ULL, 0x0002e2000850003fULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000006000a00947ULL, 0x000fec0003800000ULL,
0xff317217ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff6c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000001000e547824ULL, 0x000fca00078e00ffULL,
0x000000035400720cULL, 0x000fda0003f06070ULL, 0x00000060007c0947ULL, 0x000fea0003800000ULL,
0x000000040f1a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe2000001160fULL,
0x000000010e0c7836ULL, 0x000fe20000000000ULL, 0x00000003ff4e7819ULL, 0x000fe20000011600ULL,
0x00008a00ff6a7b82ULL, 0x000e620000000a00ULL, 0xfffffff81a537812ULL, 0x000fe200078ec0ffULL,
0x000000100b3d7824ULL, 0x000fe200078e00ffULL, 0x000000050c00720cULL, 0x000fe20003f06070ULL,
0x000000086c0c7824ULL, 0x000fe200078e00ffULL, 0x00008e0000077ab9ULL, 0x000fe20000000800ULL,
0x0000000102537824ULL, 0x040fe200078e0253ULL, 0x0000f6a8021b7810ULL, 0x000fe20007ffe03dULL,
0x00000001071f7824ULL, 0x000fe200078e024eULL, 0x000000080c197812ULL, 0x000fe200078e0cffULL,
0x0000f6c853517836ULL, 0x000fe20000000000ULL, 0x000000001b0472caULL, 0x000fe200000e0000ULL,
0x000000044e4c7836ULL, 0x000fe20000000000ULL, 0x000000001f187212ULL, 0x000fe200078e3cffULL,
0x0000001d510075a7ULL, 0x008ee2000802007fULL, 0x000000200b677824ULL, 0x000fe200078e0254ULL,
0x00000000190572caULL, 0x000fe200000e0000ULL, 0x000000081f437824ULL, 0x000fc400078e00ffULL,
0x0000000107217824ULL, 0x000fe400078e024cULL, 0x000000011b1b7824ULL, 0x000fe200078e020cULL,
0xfffffff843437812ULL, 0x000fe200078ee218ULL, 0x000000084e4a7836ULL, 0x040fe20000000000ULL,
0x0000000021187212ULL, 0x000fe200078e3cffULL, 0x00000040670c7836ULL, 0x000fe40000000000ULL,
0x0000000821417824ULL, 0x000fe400078e00ffULL, 0x0000000107237824ULL, 0x000fe200078e024aULL,
0x0000000c03197248ULL, 0x000fe20007fe0000ULL, 0x0000000c4e487836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee218ULL, 0x0000000823457824ULL, 0x040fe200078e00ffULL,
0x0000000023187212ULL, 0x000fe200078e3cffULL, 0x00000001073f7824ULL, 0x000fc400078e0248ULL,
0x00000001191e7824ULL, 0x100fe200078e0a0cULL, 0xfffffff845457812ULL, 0x000fe200078ee218ULL,
0x00000007060c7c24ULL, 0x000fe2000f8e020cULL, 0x000000003f187212ULL, 0x040fe200078e3cffULL,
0x000000083f477824ULL, 0x000fe400078e00ffULL, 0x00000010004d7824ULL, 0x000fe400078e00ffULL,
0x000000011f197824ULL, 0x100fe200078e020cULL, 0xfffffff847477812ULL, 0x000fe200078ee218ULL,
0x00000001211f7824ULL, 0x100fe200078e020cULL, 0x000000704d4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000123217824ULL, 0x000fc400078e020cULL, 0x000000013f3f7824ULL, 0x000fe400078e020cULL,
0x0000008019187825ULL, 0x002fe200078e006aULL, 0x0000000000081947ULL, 0x008fec0003800000ULL,
0x00f6c81d530075a7ULL, 0x000e64000802017fULL, 0x000000d000689947ULL, 0x002fea0003800000ULL,
0x000000201e1e7807ULL, 0x000fe20000000000ULL, 0x000000801f1c7825ULL, 0x000fe200078e006aULL,
0x0000004d18187210ULL, 0x000fe20007f3e0ffULL, 0x0000000504047290ULL, 0x000fe2000fffe03fULL,
0x0000001e071e7248ULL, 0x000fe20007fe0000ULL, 0x000010006c0c7824ULL, 0x000fe200078e00ffULL,
0x0000004d1c1c7210ULL, 0x000fe20007f5e0ffULL, 0x000020000b697824ULL, 0x000fe200078e0202ULL,
0x0000000809667812ULL, 0x000fe200078ec0ffULL, 0x000000011e237824ULL, 0x000fe200078e0a07ULL,
0x000010000c0c7812ULL, 0x000fe200078e0cffULL, 0x000000ffff197224ULL, 0x000fc400008e0619ULL,
0x00000080211e7825ULL, 0x000fe200078e006aULL, 0x000000234e00720cULL, 0x080fe40003f26070ULL,
0x000000234a00720cULL, 0x080fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x000000234c00720cULL, 0x080fe20003f46070ULL, 0x000000803f207825ULL, 0x000fe200078e006aULL,
0x0000b00069607810ULL, 0x000fe40007ffe00cULL, 0x000000234800720cULL, 0x000fe20003f86070ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000004d1e227210ULL, 0x000fe20007fbe0ffULL,
0x0000001043437824ULL, 0x100fe200078e0260ULL, 0x0000004d201e7210ULL, 0x000fe20007fde0ffULL,
0x0000001041427824ULL, 0x100fe200078e0260ULL, 0x000000103d207812ULL, 0x000fe200078ec0ffULL,
0x000000ffff237224ULL, 0x000fe200028e061fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018437faeULL, 0x000fe2000c901c48ULL, 0x0000001045417824ULL, 0x000fc400078e0260ULL,
0x000000ffff1f7224ULL, 0x000fe200030e0621ULL, 0x000000001c427faeULL, 0x0007e2000d101c48ULL,
0x0000001047407824ULL, 0x000fe200078e0260ULL, 0xffffffe009217812ULL, 0x000fe400078ec0ffULL,
0x0000000022417faeULL, 0x0007e6000d901c48ULL, 0x0000000102217824ULL, 0x000fe200078e0221ULL,
0x000000001e407faeULL, 0x0007e2000e101c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000021664f7210ULL, 0x0c0fe20007ffe020ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000cff7279a7ULL, 0x0002620008500004ULL,
0x00000010091c7812ULL, 0x008fe400078ec0ffULL, 0x00000001ff507819ULL, 0x000fe40000011600ULL,
0x0000002166667210ULL, 0x000fe20007ffe01cULL, 0x000000200f1c7824ULL, 0x000fe200078e00ffULL,
0x0000000c50507812ULL, 0x000fe200078ec0ffULL, 0x0000006f1b0075a7ULL, 0x004266000802007fULL,
0xffffff801c1d7812ULL, 0x000fca00078ec0ffULL, 0x0000000102527824ULL, 0x000fca00078e021dULL,
0x0000005250557210ULL, 0x000fe20007ffe04dULL, 0x00f6080c4f1879a7ULL, 0x000ee4000850003fULL,
0x00f60819660075a7ULL, 0x008ee4000804017fULL, 0x000000cc00a0a947ULL, 0x00efea0003800000ULL,
0x00f00000551d7984ULL, 0x000e620000000800ULL, 0x000010000f657824ULL, 0x000fe200078e00ffULL,
0x0000000800197812ULL, 0x000fe200078ec0ffULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x00f2000055557984ULL, 0x000ea20000000800ULL, 0x000000041a1f7812ULL, 0x000fe400078ec0ffULL,
0xffffe00065657812ULL, 0x000fe400078ec0ffULL, 0x0000000719207812ULL, 0x000fe400078ec800ULL,
0x0000001f001f7211ULL, 0x000fe200078fe0ffULL, 0x0000000102217824ULL, 0x000fe200078e0265ULL,
0x0000000719747812ULL, 0x000fc400078ef800ULL, 0x0000001f20197212ULL, 0x000fe200078e3cffULL,
0x000010006c217824ULL, 0x000fc800078e0221ULL, 0x0000b00021217836ULL, 0x000fe40000000000ULL,
0x0000000874647824ULL, 0x000fc800078e0219ULL, 0x00000010643c7824ULL, 0x000fe200078e0221ULL,
0x000000081d00720bULL, 0x002fda0003f5d000ULL, 0x0000000000187806ULL, 0x000fc800010e0100ULL,
0x0000ffff18227812ULL, 0x000fda000784c0ffULL, 0x0000000000e0a947ULL, 0x004fea0003800000ULL,
0x000000081d00720bULL, 0x000fe40003f54000ULL, 0x0000001d083d7209ULL, 0x000fe40007810000ULL,
0x00000002ff1c7819ULL, 0x000fc60000011600ULL, 0x8000003d08187221ULL, 0x000fe20000010000ULL,
0x00000002ff087819ULL, 0x000fe2000001160fULL, 0x000000081c1e7836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b181a7820ULL, 0x000fe40000410000ULL, 0x0000000000187806ULL, 0x000fe400010e0100ULL,
0x0000001a003f7308ULL, 0x000e620000000800ULL, 0x0000000f0800720cULL, 0x000fe40003f45270ULL,
0x0000ffff18237812ULL, 0x000fc800078e3cffULL, 0x0000002322ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff567807ULL, 0x000fc60001800000ULL, 0x000000800f08a824ULL, 0x000fe200078e0202ULL,
0x00001f1e3f1e7589ULL, 0x002e6200000e0000ULL, 0x0000003f0a0a7220ULL, 0x000fc60000410000ULL,
0x00001f1c3f1c7589ULL, 0x000ea200000e0000ULL, 0x8000003d1d1d3221ULL, 0x000fe20000010000ULL,
0x000000085008a210ULL, 0x000fc60007ffe04dULL, 0x3fb8aa3b1d1d3820ULL, 0x000fe40000410000ULL,
0x00f4003d0800a388ULL, 0x0007e40000000800ULL, 0x0000001d000d3308ULL, 0x000f220000000800ULL,
0x000000ffff087224ULL, 0x008fe400078e003dULL, 0x0000001e17177220ULL, 0x082fe20000410000ULL,
0x0000001e16167220ULL, 0x080fe20000410000ULL, 0x0000001e13137220ULL, 0x080fe20000410000ULL,
0x0000001e12127220ULL, 0x080fe20000410000ULL, 0x0000001e27277220ULL, 0x080fe20000410000ULL,
0x0000001e26267220ULL, 0x080fe20000410000ULL, 0x0000001e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001e33337220ULL, 0x080fe20000410000ULL,
0x0000001e32327220ULL, 0x080fe20000410000ULL, 0x0000001e37377220ULL, 0x080fe20000410000ULL,
0x0000001e36367220ULL, 0x000fe20000410000ULL, 0x0000001c15157220ULL, 0x084fe20000410000ULL,
0x0000001c14147220ULL, 0x080fe20000410000ULL, 0x0000001c11117220ULL, 0x080fe20000410000ULL,
0x0000001c10107220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c28287220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x000fe20000410000ULL, 0x0000000d55553220ULL, 0x010fce0000410000ULL,
0x0000000000081947ULL, 0x000fea0003800000ULL, 0x0000006f1b0075a7ULL, 0x000e64000802017fULL,
0x000000c8007c9947ULL, 0x002fea0003800000ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x000000021f617836ULL, 0x000fe20000000000ULL, 0x00000007006f7812ULL, 0x000fe200078ec0ffULL,
0x000000020f497824ULL, 0x040fe200078e00ffULL, 0x00000002ff457819ULL, 0x000fe20000011600ULL,
0x000002000f187824ULL, 0x000fe200078e00ffULL, 0x0000006120617212ULL, 0x000fe200078e3cffULL,
0x000010006c5e7824ULL, 0x000fe200078e0269ULL, 0x00000004491b7812ULL, 0x000fe200078ec0ffULL,
0x0000000845447836ULL, 0x000fe20000000000ULL, 0x000000086f6f7812ULL, 0x000fe200078ef800ULL,
0x0000000874637824ULL, 0x000fe200078e0261ULL, 0x0000001b006e7211ULL, 0x000fe200078fe0ffULL,
0x0000b0005e5e7836ULL, 0x000fe20000000000ULL, 0x0000008074747811ULL, 0x000fe200078e18ffULL,
0x00000010631c7824ULL, 0x000fe200078e0221ULL, 0xfffff80018217812ULL, 0x000fe200078ec0ffULL,
0x0000000a550a7221ULL, 0x000fe20000010000ULL, 0x000000076e187812ULL, 0x000fe200078e786fULL,
0x0000000119627824ULL, 0x000fe200078e0274ULL, 0x0000000dff59723eULL, 0x000fe200000000ffULL,
0x0000000102467824ULL, 0x000fe200078e0221ULL, 0x0000991056567816ULL, 0x000fe200000000ffULL,
0x000000086f477824ULL, 0x000fe200078e0218ULL, 0x0000541059687816ULL, 0x000fe20000000059ULL,
0x000000001c1c783bULL, 0x000ea20000004200ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x0000001047477824ULL, 0x000fc400078e0246ULL, 0x00001f4568597589ULL, 0x000fe200000e0000ULL,
0x0000000161617824ULL, 0x000fe400078e0274ULL, 0x0000001062217824ULL, 0x000fe200078e025eULL,
0x009000004718783bULL, 0x000ee20000000200ULL, 0x000000026e6e7836ULL, 0x000fca0000000000ULL,
0x000000076e6e7812ULL, 0x000fe200078e786fULL, 0x000001003c207824ULL, 0x042fe200078e00ffULL,
0x000088803c577816ULL, 0x040fe200000000ffULL, 0x000001003d5a7824ULL, 0x040fe200078e00ffULL,
0x000088803d5b7816ULL, 0x000fe200000000ffULL, 0x000000086f6f7824ULL, 0x000fe200078e026eULL,
0x00000018ff587819ULL, 0x000fe40000011420ULL, 0x00000018ff757819ULL, 0x000fe2000001145aULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00001f44685a7589ULL, 0x000e6200000e0000ULL,
0x00000018ff5f7819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143eULL, 0x000000002120783bULL, 0x000f220000004200ULL,
0x0000005800587306ULL, 0x000f620000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000106f467824ULL, 0x000fe200078e0246ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff4b7819ULL, 0x000fc6000001143fULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x004fe4000001141cULL, 0x00000018ff707819ULL, 0x000fe4000001141dULL,
0x000088801c747816ULL, 0x000fe400000000ffULL, 0x0000541057567816ULL, 0x020fe20000000058ULL,
0x0000007500767306ULL, 0x000ea20000200c00ULL, 0x0000005918189232ULL, 0x088fe20000000000ULL,
0x00000018ff777819ULL, 0x000fe2000001141fULL, 0x000000591a1a9232ULL, 0x000fe20000000000ULL,
0x00000018ff6d7819ULL, 0x000fe2000001141eULL, 0x0000005a19199232ULL, 0x002fc40000000000ULL,
0x0000005a1b1b9232ULL, 0x000fe20000000000ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000054105b577816ULL, 0x004fce0000000076ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000000561834723cULL, 0x000fe20000001834ULL, 0x00000018ff587819ULL, 0x010fcc0000011420ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x00000018ff5b7819ULL, 0x000fe40000011421ULL,
0x00008880236e7816ULL, 0x000fe200000000ffULL, 0x000001003e577824ULL, 0x040fe200078e00ffULL,
0x000088803e567816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe400078e00ffULL,
0x0000003d00767306ULL, 0x000ea20000200c00ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x000054103c3c7816ULL, 0x002fca000000005fULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe2000001143eULL, 0x00000010613e7824ULL, 0x000fe200078e025eULL,
0x00005410763d7816ULL, 0x004fca000000005dULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000088803f5d7816ULL, 0x040fe200000000ffULL, 0x0000003c1830723cULL, 0x000fec0000001830ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000001003f3c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fca00078e005dULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff5d7819ULL, 0x000fc80000011422ULL, 0x0000003d003d7306ULL, 0x000ff00000200c00ULL,
0x0000003c00767306ULL, 0x0002b00000200c00ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00005410563c7816ULL, 0x002fe20000000057ULL, 0x000001001c577824ULL, 0x040fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe2000001143fULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000054103d3d7816ULL, 0x004fc60000000076ULL, 0x00000056005e7306ULL, 0x0003e20000200c00ULL,
0x000088801d767816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000003c1838723cULL, 0x000fe20000001838ULL,
0x000000003e3c783bULL, 0x000ea20000004200ULL, 0x0000007700687306ULL, 0x0007e20000200c00ULL,
0x000054105f567816ULL, 0x002fe2000000005cULL, 0x000001001d5c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011423ULL, 0x000100001d1d7824ULL, 0x000fc800078e00ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff777819ULL, 0x008fca000001145cULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000001c001c7306ULL, 0x000e700000200c00ULL, 0x0000001d001d7306ULL, 0x000ee20000200c00ULL,
0x000054101c1c7816ULL, 0x002fce0000000071ULL, 0x0000005700757306ULL, 0x0003e20000200c00ULL,
0x000001001e717824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x004fc8000001143dULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000054105e577816ULL, 0x002fe4000000004bULL, 0x000054101d1d7816ULL, 0x008fe40000000070ULL,
0x00000018ff5e7819ULL, 0x000fc6000001143cULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x00000056182c723cULL, 0x000fec000000182cULL, 0x0000001c1824723cULL, 0x000fe20000001824ULL,
0x00000077004b7306ULL, 0x0002e20000200c00ULL, 0x0000541074567816ULL, 0x004fe40000000075ULL,
0x000088801f747816ULL, 0x000fc600000000ffULL, 0x000001001f1c7824ULL, 0x040fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e0074ULL, 0x0000007100707306ULL, 0x0005e20000200c00ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000888021777816ULL, 0x002fe400000000ffULL, 0x0000541076577816ULL, 0x008fe4000000004bULL,
0x0000001d001d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x004fc4000001141fULL,
0x00008880201f7816ULL, 0x000fe400000000ffULL, 0x000000561828723cULL, 0x000fe20000001828ULL,
0x00000018ff4b7819ULL, 0x000fe4000001143eULL, 0x0000001c00767306ULL, 0x000e680000200c00ULL,
0x000088801e577816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc4000001143fULL, 0x0000006d006d7306ULL, 0x000fe40000200c00ULL,
0x00000018ff747819ULL, 0x000fe2000001141eULL, 0x00000100201e7824ULL, 0x040fe400078e00ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x000054101d1d7816ULL, 0x002fe40000000076ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff207819ULL, 0x000fca0000011420ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00005410571c7816ULL, 0x002fce0000000070ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x0000888022577816ULL, 0x040fe200000000ffULL, 0x0000001c1810723cULL, 0x000fec0000001810ULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x00000100211c7824ULL, 0x000fe400078e00ffULL,
0x00000100221d7824ULL, 0x000fca00078e00ffULL, 0x0000001e001e7306ULL, 0x000ea20000200c00ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000001c007a7306ULL, 0x0007f00000200c00ULL,
0x0000001d00707306ULL, 0x0003e20000200c00ULL, 0x00000100231c7824ULL, 0x008fc400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x00005410711d7816ULL, 0x002fe40000000068ULL,
0x000088803d687816ULL, 0x000fe400000000ffULL, 0x00000018ff237819ULL, 0x000fc60000011423ULL,
0x0000001c006f7306ULL, 0x0003f00000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00005410741c7816ULL, 0x002fe4000000006dULL, 0x000088803c747816ULL, 0x000fca00000000ffULL,
0x0000001c1818723cULL, 0x000fe20000001814ULL, 0x009000004614783bULL, 0x000e620000000200ULL,
0x0000005b005b7306ULL, 0x000fea0000200c00ULL, 0x000001003d1d7824ULL, 0x040fe400078e00ffULL,
0x000001003c1c7824ULL, 0x040fe200078e00ffULL, 0x0000002000757306ULL, 0x0009e20000200c00ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc8000001141cULL,
0x0000001d006d7306ULL, 0x000be20000200c00ULL, 0x00000018ff207819ULL, 0x010fe40000011422ULL,
0x000088803f227816ULL, 0x000fca00000000ffULL, 0x0000001c00717306ULL, 0x0005e20000200c00ULL,
0x000001003e1d7824ULL, 0x020fce00078e00ffULL, 0x0000002100767306ULL, 0x0009620000200c00ULL,
0x000054101f1c7816ULL, 0x004fe4000000001eULL, 0x00000018ff1e7819ULL, 0x000fe4000001141dULL,
0x00005410771d7816ULL, 0x008fe2000000007aULL, 0x0000005914149232ULL, 0x082fe40000000000ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x0000005916169232ULL, 0x000fe20000000000ULL,
0x00000018ff217819ULL, 0x010fe2000001143dULL, 0x0000005a15159232ULL, 0x080fe20000000000ULL,
0x000088803e1f7816ULL, 0x000fe200000000ffULL, 0x0000005a17179232ULL, 0x000fc40000000000ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000006e006e7306ULL, 0x000ea80000200c00ULL,
0x0000001c1434723cULL, 0x000fe80000001834ULL, 0x0000005d005d7306ULL, 0x000fe60000200c00ULL,
0x000001003f1c7824ULL, 0x040fe200078e00ffULL, 0x00005410761d7816ULL, 0x020fe2000000005bULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000001c003d7306ULL, 0x0007f00000200c00ULL, 0x0000002000207306ULL, 0x000f220000200c00ULL,
0x00005410751c7816ULL, 0x008fce0000000058ULL, 0x0000002300787306ULL, 0x0007620000200c00ULL,
0x0000001c1430723cULL, 0x000fee0000001830ULL, 0x00005410571c7816ULL, 0x002fe20000000070ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000054106e1d7816ULL, 0x004fe2000000006fULL,
0x000000ffff6e7224ULL, 0x000fe200078e0072ULL, 0x00000018ff237819ULL, 0x008fe2000001143cULL,
0x000000ffff6f7224ULL, 0x000fe200078e0073ULL, 0x00000018ff3c7819ULL, 0x000fc6000001143eULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000001c1438723cULL, 0x000fee0000001838ULL,
0x00005410201c7816ULL, 0x010fe2000000005dULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00005410781d7816ULL, 0x020fe2000000005fULL, 0x000000ffff5d7224ULL, 0x000fe200078e006cULL,
0x000000016c6c7812ULL, 0x000fca00078e0cffULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000001c142c723cULL, 0x000fee000000182cULL, 0x0000002300237306ULL, 0x000ee20000200c00ULL,
0x00005410741c7816ULL, 0x002fe40000000071ULL, 0x00005410681d7816ULL, 0x004fca000000006dULL,
0x0000002100217306ULL, 0x000e640000200c00ULL, 0x0000001c1428723cULL, 0x000fec0000001828ULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x00005410231c7816ULL, 0x008fe4000000005eULL,
0x00005410211d7816ULL, 0x002fca000000005cULL, 0x0000001e001e7306ULL, 0x000e640000200c00ULL,
0x0000001c1424723cULL, 0x000fec0000001824ULL, 0x0000002200227306ULL, 0x000ea20000200c00ULL,
0x000054101f1c7816ULL, 0x002fce000000001eULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00005410221d7816ULL, 0x004fce000000003dULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x0000001c1410723cULL, 0x000fee0000001810ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0xfffffff8491d7812ULL, 0x000fe200078ec0ffULL, 0x000000080b497824ULL, 0x000fe200078e0202ULL,
0x000054103c1c7816ULL, 0x002fca000000004bULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x00000001024b7824ULL, 0x000fe200078e021dULL, 0x000054103f1d7816ULL, 0x002fce0000000056ULL,
0x0000001c1414723cULL, 0x000fe20000001818ULL, 0x00f6c80c491c79a7ULL, 0x00026c000850003fULL,
0x0000004054187836ULL, 0x000fe20000000000ULL, 0x00f6880c4bff79a7ULL, 0x0003e8000850003fULL,
0x000000031800720cULL, 0x000fda0003f26070ULL, 0x0000004400541947ULL, 0x002fea0003800000ULL,
0x0000001d510075a7ULL, 0x000e62000802007fULL, 0x0000000700197211ULL, 0x040fe200078fe8ffULL,
0x00000080671a7836ULL, 0x000fe20000000000ULL, 0x0000000400187811ULL, 0x040fe400078fe8ffULL,
0x0000000019207212ULL, 0x040fe200078e3cffULL, 0x00000008191b7824ULL, 0x000fe400078e00ffULL,
0x0000000107197824ULL, 0x000fe200078e0218ULL, 0x0000000800187811ULL, 0x000fe400078fe8ffULL,
0xfffffff81b207812ULL, 0x000fc400078ee220ULL, 0x00000000195a7212ULL, 0x040fe200078e3cffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x0000001a031b7248ULL, 0x000fe20007fe0000ULL,
0x0000000000081947ULL, 0x002fec0003800000ULL, 0x00f6c81d530075a7ULL, 0x000e64000802017fULL,
0x000000b8001c9947ULL, 0x002fea0003800000ULL, 0xfffffff8195a7812ULL, 0x000fe200078ee25aULL,
0x0000000107197824ULL, 0x000fe200078e0218ULL, 0x0000000c00187811ULL, 0x000fe200078fe8ffULL,
0x0000000706237c24ULL, 0x100fe4000f8e021aULL, 0x000000011b217824ULL, 0x000fe200078e0a1aULL,
0x00000000191a7212ULL, 0x040fe200078e3cffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000004c23197210ULL, 0x100fe20007ffe007ULL, 0x000000085d5c7824ULL, 0x000fe200078e00ffULL,
0x0000004e231b7210ULL, 0x000fe20007ffe007ULL, 0x000010005d3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee21aULL, 0x00000001071d7824ULL, 0x000fe200078e0218ULL,
0x000000085c577812ULL, 0x000fe200078ec0ffULL, 0x0000008019187825ULL, 0x000fe200078e006aULL,
0x000010003c3f7812ULL, 0x000fc400078ec0ffULL, 0x000000001d1f7212ULL, 0x000fe200078e3cffULL,
0x000000801b1a7825ULL, 0x000fe200078e006aULL, 0x0000004d181c7210ULL, 0x000fe40007f5e0ffULL,
0x0000002021187807ULL, 0x000fe20000000000ULL, 0x000000081d587824ULL, 0x000fe200078e00ffULL,
0x00000008571d7812ULL, 0x000fe200078e3cffULL, 0x000000100b217824ULL, 0x000fe200078e0202ULL,
0x0000004d1a1e7210ULL, 0x000fe40007f3e0ffULL, 0x000000001d0672caULL, 0x000fe200000e0000ULL,
0x000000ffff1d7224ULL, 0x000fe200010e0619ULL, 0xfffffff858587812ULL, 0x000fe200078ee21fULL,
0x000000ffff1f7224ULL, 0x000fe200008e061bULL, 0x0000001807187248ULL, 0x000fe20007fe0000ULL,
0x0000f6a8215e7836ULL, 0x000fe20000000000ULL, 0x0000004a23197210ULL, 0x000fc40007ffe007ULL,
0x00000048231b7210ULL, 0x100fe20007ffe007ULL, 0x0000000118237824ULL, 0x000fe200078e0a07ULL,
0x000000005e0572caULL, 0x000fe200000e0000ULL, 0x0000008019187825ULL, 0x100fe200078e006aULL,
0x00000000570472caULL, 0x000fe400000e0000ULL, 0x000000234e00720cULL, 0x080fe20003f26070ULL,
0x000000801b1a7825ULL, 0x000fe200078e006aULL, 0x0000004d18187210ULL, 0x000fe40007f7e0ffULL,
0x000000234c00720cULL, 0x000fc40003f46070ULL, 0x0000004d1a1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x000000234a00720cULL, 0x080fe40003f66070ULL,
0x0000b00069697810ULL, 0x000fe20007ffe03fULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x000000234800720cULL, 0x000fe20003f86070ULL, 0x0000000405047290ULL, 0x000fe4000fffe03fULL,
0x00000010205b7824ULL, 0x100fe200078e0269ULL, 0x0000000605057290ULL, 0x000fe2000fffe03fULL,
0x000000105a5a7824ULL, 0x000fc400078e0269ULL, 0x0000001022597824ULL, 0x100fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e5b7faeULL, 0x000fe2000c901c48ULL,
0x0000001058587824ULL, 0x000fc600078e0269ULL, 0x000000001c5a7faeULL, 0x000fe8000d101c48ULL,
0x0000000018597faeULL, 0x000fe8000d901c48ULL, 0x000000001a587faeULL, 0x0003e2000e101c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000cff6e79a7ULL, 0x0004a20008500004ULL,
0x000000804d1b7810ULL, 0x002fca0007ffe052ULL, 0x00000001501b7824ULL, 0x000fe200078e021bULL,
0x00000073ff0075a7ULL, 0x0004a20008020045ULL, 0x00f6280c4f1879a7ULL, 0x000e64000850003fULL,
0x00f62819660075a7ULL, 0x002e64000804017fULL, 0x000000b40020a947ULL, 0x006fea0003800000ULL,
0x00f000001b197984ULL, 0x000e620000000800ULL, 0x000010003c1a7812ULL, 0x000fe200078e0cffULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x00f200001b3e7984ULL, 0x0004a20000000800ULL,
0x000000021a1a7210ULL, 0x000fca0007ffe065ULL, 0x0000b0001a557836ULL, 0x000fc80000000000ULL,
0x0000001064567824ULL, 0x000fe200078e0255ULL, 0x000000081900720bULL, 0x002fda0003f5d000ULL,
0x0000000000187806ULL, 0x000fc800010e0100ULL, 0x0000ffff181c7812ULL, 0x000fda000784c0ffULL,
0x0000000000d8a947ULL, 0x004fea0003800000ULL, 0x000000081900720bULL, 0x000fe40003f54000ULL,
0x00000019081a7209ULL, 0x000fca0007810000ULL, 0x8000001a08187221ULL, 0x000fe20000010000ULL,
0x000000010f087811ULL, 0x000fc600078ff0ffULL, 0x3fb8aa3b181b7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400010e0100ULL, 0x0000000f0800720cULL, 0x000fe40003f45270ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000ffff181d7812ULL, 0x000fc800078e3cffULL,
0x0000001d1cff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff3c7807ULL, 0x000fe40001800000ULL,
0x000000800f18a824ULL, 0x000fe200078e0202ULL, 0x00001f451b087589ULL, 0x002e6800000e0000ULL,
0x00000018501da210ULL, 0x000fe20007ffe04dULL, 0x0000001b0a0a7220ULL, 0x000fe20000410000ULL,
0x8000001a19193221ULL, 0x100fe20000010000ULL, 0x00001f441b187589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b19193820ULL, 0x000fe20000410000ULL, 0x00f4001a1d00a388ULL, 0x0007e60000000800ULL,
0x00000019000d3308ULL, 0x000f220000000800ULL, 0x0000000834347220ULL, 0x082fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000810107220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x000fe20000410000ULL, 0x0000001836367220ULL, 0x084fe20000410000ULL,
0x0000001837377220ULL, 0x080fe20000410000ULL, 0x0000001832327220ULL, 0x080fe20000410000ULL,
0x0000001833337220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000182e2e7220ULL, 0x080fe20000410000ULL,
0x000000182f2f7220ULL, 0x080fe20000410000ULL, 0x000000182a2a7220ULL, 0x080fe20000410000ULL,
0x000000182b2b7220ULL, 0x080fe20000410000ULL, 0x0000001826267220ULL, 0x080fe20000410000ULL,
0x0000001827277220ULL, 0x080fe20000410000ULL, 0x0000001812127220ULL, 0x080fe20000410000ULL,
0x0000001813137220ULL, 0x080fe20000410000ULL, 0x0000001816167220ULL, 0x080fe20000410000ULL,
0x0000001817177220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e001aULL,
0x0000003e0d3e3220ULL, 0x018fce0000410000ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x000000085c187812ULL, 0x000fca00078e0cffULL, 0x0000000121217824ULL, 0x000fc800078e0218ULL,
0x00f6a873210075a7ULL, 0x000e64000802017fULL, 0x000000b000209947ULL, 0x002fea0003800000ULL,
0x00000000561c783bULL, 0x000e620000004200ULL, 0x0000000dff6c723eULL, 0x000fe200000000ffULL,
0x0000001063557824ULL, 0x000fe200078e0255ULL, 0x000099103c6d7816ULL, 0x000fe200000000ffULL,
0x009800004718783bULL, 0x000fe20000000200ULL, 0x000054106c767816ULL, 0x000fe2000000006cULL,
0x0000000a3e0a7221ULL, 0x000fe40000010000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e006dULL,
0x000000005520783bULL, 0x000fe80000004200ULL, 0x000000ff6c00720cULL, 0x000fe20003f25270ULL,
0x00001f45766d7589ULL, 0x000ea200000e0000ULL, 0x000001001c687824ULL, 0x002fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe2000001141cULL, 0x000001001d6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fd0000001141dULL, 0x0000006d18189232ULL, 0x084fe20000000000ULL,
0x000088801c3d7816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d747816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe20000011468ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00001f4476687589ULL, 0x000e6200000e0000ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000006d1a1a9232ULL, 0x000fe20000000000ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff757819ULL, 0x000fe4000001146cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001141eULL, 0x00000018ff5f7819ULL, 0x000fe4000001141fULL,
0x00000018ff707819ULL, 0x000fe40000011420ULL, 0x00000018ff6c7819ULL, 0x000fe20000011421ULL,
0x0000001c001c7306ULL, 0x000eb00000200c00ULL, 0x0000001d001d7306ULL, 0x000ee20000200c00ULL,
0x0000006819199232ULL, 0x002fc40000000000ULL, 0x000000681b1b9232ULL, 0x000fe20000000000ULL,
0x000054101c1c7816ULL, 0x004fc80000000073ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000088801e737816ULL, 0x000fe400000000ffULL, 0x000054101d1d7816ULL, 0x008fca0000000072ULL,
0x0000003c003c7306ULL, 0x000e640000200c00ULL, 0x0000001c1830723cULL, 0x000fec0000001830ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000088801f1d7816ULL, 0x000fe400000000ffULL,
0x000054103d3c7816ULL, 0x002fca000000003cULL, 0x0000007500757306ULL, 0x000e700000200c00ULL,
0x0000007300727306ULL, 0x0005e20000200c00ULL, 0x00005410743d7816ULL, 0x002fe20000000075ULL,
0x000001001e747824ULL, 0x000fcc00078e00ffULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x000100001e1e7824ULL, 0x000fe400078e00ffULL, 0x0000010020737824ULL, 0x004fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe20000011474ULL, 0x000001001f747824ULL, 0x040fe200078e00ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c00757306ULL, 0x000e620000200c00ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff767819ULL, 0x000fc40000011474ULL, 0x00000018ff747819ULL, 0x000fe4000001141eULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00008880201e7816ULL, 0x000fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011422ULL,
0x00000018ff3c7819ULL, 0x000fe40000011423ULL, 0x00005410721c7816ULL, 0x002fe20000000075ULL,
0x0000007600767306ULL, 0x000e700000200c00ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000054101d1d7816ULL, 0x002fce0000000076ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000001c1838723cULL, 0x000fee0000001838ULL, 0x0000001f00727306ULL, 0x000e620000200c00ULL,
0x00000100211c7824ULL, 0x040fe200078e00ffULL, 0x00008880211d7816ULL, 0x000fcc00000000ffULL,
0x0000001e001e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff767819ULL, 0x000fe2000001141cULL,
0x00010000201c7824ULL, 0x000fcc00078e00ffULL, 0x0000001d001f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff757819ULL, 0x000fe4000001141cULL, 0x00005410741c7816ULL, 0x004fe20000000071ULL,
0x0001000021717824ULL, 0x000fc800078e00ffULL, 0x0000007600207306ULL, 0x000ea20000200c00ULL,
0x00005410721d7816ULL, 0x002fe2000000005fULL, 0x00000010625f7824ULL, 0x100fe200078e0260ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000001061607824ULL, 0x000fe200078e0260ULL,
0x0000888023727816ULL, 0x000fc600000000ffULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x0000001c182c723cULL, 0x000fee000000182cULL, 0x0000007500217306ULL, 0x0007e20000200c00ULL,
0x000054101f1d7816ULL, 0x004fe20000000020ULL, 0x0000010022207824ULL, 0x000fe200078e00ffULL,
0x000054101e1c7816ULL, 0x002fca0000000073ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000010023757824ULL, 0x048fe200078e00ffULL, 0x0000888022737816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000001c1828723cULL, 0x000fe20000001828ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x000000005f1c783bULL, 0x000ea20000004200ULL,
0x00000018ff237819ULL, 0x000fca0000011423ULL, 0x0000007100717306ULL, 0x000ef00000200c00ULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000002000747306ULL, 0x0003300000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000541021207816ULL, 0x002fc40000000070ULL,
0x0000541071217816ULL, 0x008fca000000006cULL, 0x0000007500757306ULL, 0x000e640000200c00ULL,
0x000000201824723cULL, 0x000fe20000001824ULL, 0x000088801d6c7816ULL, 0x004fe400000000ffULL,
0x00000018ff707819ULL, 0x000fe4000001141cULL, 0x00000018ff717819ULL, 0x000fe2000001141fULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541073207816ULL, 0x010fe20000000074ULL,
0x000001001d747824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fc4000001141dULL,
0x0000541072217816ULL, 0x002fc60000000075ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff727819ULL, 0x000fe2000001141eULL,
0x000000201810723cULL, 0x000fe80000001810ULL, 0x0000002200227306ULL, 0x000e700000200c00ULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541022207816ULL, 0x002fe2000000003dULL,
0x000001001c3d7824ULL, 0x000fcc00078e00ffULL, 0x0000006c00757306ULL, 0x000fe20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000541023217816ULL, 0x004fe4000000003cULL,
0x000088801c3c7816ULL, 0x000fc600000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x000000201818723cULL, 0x000fe20000001814ULL,
0x009800004614783bULL, 0x000e660000000200ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000000006020783bULL, 0x000eae0000004200ULL,
0x0000003d003d7306ULL, 0x000ef00000200c00ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x008fce000000003dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00005410753d7816ULL, 0x000fce0000000074ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000006d14149232ULL, 0x082fe40000000000ULL, 0x0000006d16169232ULL, 0x000fca0000000000ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000006815159232ULL, 0x080fe20000000000ULL,
0x0000888020757816ULL, 0x004fe200000000ffULL, 0x0000006817179232ULL, 0x000fe20000000000ULL,
0x00000018ff6d7819ULL, 0x000fe40000011420ULL, 0x00000018ff6c7819ULL, 0x000fe40000011421ULL,
0x00000018ff687819ULL, 0x000fe40000011422ULL, 0x0000003c1434723cULL, 0x000fe20000001834ULL,
0x0000006d006d7306ULL, 0x000fec0000200c00ULL, 0x000100001d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe20000011423ULL, 0x0000001c001d7306ULL, 0x000e660000200c00ULL,
0x00000018ff747819ULL, 0x000fc4000001143dULL, 0x000088801e3d7816ULL, 0x000fc600000000ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000054101d1c7816ULL, 0x002fce0000000070ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000001001e1d7824ULL, 0x040fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe4000001141dULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00005410741d7816ULL, 0x002fca0000000073ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x000088801f737816ULL, 0x040fe200000000ffULL, 0x0000001c1430723cULL, 0x000fec0000001830ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000001001f1c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x000fca00078e0073ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000100001f737824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc8000001141cULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000001d001d7306ULL, 0x000ff00000200c00ULL,
0x0000001c00747306ULL, 0x0002b00000200c00ULL, 0x0000001e001f7306ULL, 0x0007220000200c00ULL,
0x000054103d1c7816ULL, 0x002fe20000000070ULL, 0x00000100203d7824ULL, 0x000fc400078e00ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x000054101d1d7816ULL, 0x004fc60000000074ULL,
0x0000007300767306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000888021747816ULL, 0x040fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000001c1438723cULL, 0x000fe20000001838ULL, 0x00008880221e7816ULL, 0x008fe200000000ffULL,
0x0000007500707306ULL, 0x000fea0000200c00ULL, 0x00000100211c7824ULL, 0x000fc400078e00ffULL,
0x00000100221d7824ULL, 0x000fe200078e00ffULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc8000001141cULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000001c00757306ULL, 0x0009f00000200c00ULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x000054101f1c7816ULL, 0x010fc40000000072ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141dULL, 0x00005410761d7816ULL, 0x002fe40000000071ULL,
0x0000888023717816ULL, 0x040fe200000000ffULL, 0x0000002000207306ULL, 0x000e680000200c00ULL,
0x0000001c142c723cULL, 0x000fe8000000182cULL, 0x0000002100737306ULL, 0x0007260000200c00ULL,
0x00000100231c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141cULL,
0x00010000221c7824ULL, 0x000fe200078e00ffULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0001000023217824ULL, 0x008fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000001d00227306ULL, 0x0005f00000200c00ULL,
0x0000001c00237306ULL, 0x0007e20000200c00ULL, 0x00005410741d7816ULL, 0x004fce0000000075ULL,
0x0000001f001f7306ULL, 0x000ea20000200c00ULL, 0x00005410701c7816ULL, 0x008fce000000003dULL,
0x0000007100717306ULL, 0x000ee20000200c00ULL, 0x0000001c1428723cULL, 0x000fee0000001828ULL,
0x00005410201c7816ULL, 0x002fe2000000006dULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x00005410731d7816ULL, 0x010fce000000006cULL, 0x0000001c1424723cULL, 0x000fee0000001824ULL,
0x000054101e1c7816ULL, 0x004fe4000000001fULL, 0x00005410711d7816ULL, 0x008fce0000000022ULL,
0x0000001c1410723cULL, 0x000fee0000001810ULL, 0x00005410231c7816ULL, 0x000fe40000000068ULL,
0x00005410211d7816ULL, 0x002fe4000000003cULL, 0x000000015d687812ULL, 0x000fca00078ec0ffULL,
0x0000001c1414723cULL, 0x000fe20000001818ULL, 0x00f6c80c491c79a7ULL, 0x000262000850003fULL,
0x000000ffff6c7224ULL, 0x000fca00078e0068ULL, 0x0000008054187836ULL, 0x000fe20000000000ULL,
0x00f6900c4bff79a7ULL, 0x0003e8000850003fULL, 0x000000031800720cULL, 0x000fda0003f26070ULL,
0x0000002c00281947ULL, 0x002fea0003800000ULL, 0x0000001d510075a7ULL, 0x000e62000802007fULL,
0x000000c067677836ULL, 0x000fc80000000000ULL, 0x00000007061a7c24ULL, 0x000fe2000f8e0267ULL,
0x0000006703187248ULL, 0x000fc80007fe0000ULL, 0x0000004e1a197210ULL, 0x000fe20007ffe007ULL,
0x0000000118187824ULL, 0x000fca00078e0a67ULL, 0x00000020181e7807ULL, 0x000fe20000000000ULL,
0x0000008019187825ULL, 0x000fe200078e006aULL, 0x0000000000101947ULL, 0x002fec0003800000ULL,
0x000000040f1b7811ULL, 0x000fca00078ff8ffULL, 0x000000081b1b7824ULL, 0x000fc800078e0202ULL,
0x00f6a81d1b0075a7ULL, 0x000e64000800017fULL, 0x000000a000408947ULL, 0x002fea0003800000ULL,
0x0000001e071c7248ULL, 0x000fe40007fe0000ULL, 0x0000004c1a1d7210ULL, 0x100fe40007ffe007ULL,
0x0000004d181e7210ULL, 0x000fe20007f1e0ffULL, 0x000000011c217824ULL, 0x100fe200078e0a07ULL,
0x0000004a1a1b7210ULL, 0x040fe20007ffe007ULL, 0x000000801d1c7825ULL, 0x000fe200078e006aULL,
0x000000481a237210ULL, 0x000fe40007ffe007ULL, 0x000000214c00720cULL, 0x080fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e0619ULL, 0x000000214e00720cULL, 0x080fe20003f06070ULL,
0x000000801b1a7825ULL, 0x000fe200078e006aULL, 0x000000214a00720cULL, 0x000fc40003f46070ULL,
0x000000214800720cULL, 0x000fe20003f66070ULL, 0x0000008023187825ULL, 0x000fe200078e006aULL,
0x0000004d1c1c7210ULL, 0x000fe40007f9e0ffULL, 0x0000004d1a1a7210ULL, 0x000fe40007fbe0ffULL,
0x0000004d18187210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1d7224ULL, 0x000fe400020e061dULL,
0x000000ffff1b7224ULL, 0x000fe200028e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e437faeULL, 0x000fe2000c101c48ULL, 0x000000ffff197224ULL, 0x000fc600030e0619ULL,
0x000000001c427faeULL, 0x000fe8000c901c48ULL, 0x000000001a417faeULL, 0x0003e8000d101c48ULL,
0x0000000018407faeULL, 0x0003e2000d901c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000cff7079a7ULL, 0x0004a20008500005ULL, 0x000001004d1b7810ULL, 0x002fca0007ffe052ULL,
0x00000001501b7824ULL, 0x000fe200078e021bULL, 0x0000006fff0075a7ULL, 0x0004a20008000044ULL,
0x00f6480c4f1879a7ULL, 0x000e64000850003fULL, 0x00f64819660075a7ULL, 0x002e64000802017fULL,
0x0000009c00c49947ULL, 0x006fea0003800000ULL, 0x00f000001b197984ULL, 0x000e620000000800ULL,
0x000000023f3f7210ULL, 0x000fe20007ffe065ULL, 0x00000001ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000b0003f3f7836ULL, 0x000fc80000000000ULL, 0x0000001064407824ULL, 0x000fe400078e023fULL,
0x00f200001b647984ULL, 0x0004a20000000800ULL, 0x000000081900720bULL, 0x002fda0003f3d000ULL,
0x0000000000187806ULL, 0x000fc800008e0100ULL, 0x0000ffff181d7812ULL, 0x000fda000782c0ffULL,
0x0000000000d89947ULL, 0x004fea0003800000ULL, 0x000000081900720bULL, 0x000fe40003f34000ULL,
0x00000019081e7209ULL, 0x000fca0007810000ULL, 0x8000001e08187221ULL, 0x000fe20000010000ULL,
0x000000020f087811ULL, 0x000fc600078ff0ffULL, 0x3fb8aa3b181a7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400008e0100ULL, 0x0000000f0800720cULL, 0x000fe20003f25270ULL,
0x0000001a001b7308ULL, 0x000e620000000800ULL, 0x0000ffff18187812ULL, 0x000fc800078e3cffULL,
0x000000181dff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff1c7807ULL, 0x000fc60001000000ULL,
0x000000800f189824ULL, 0x000fe200078e0202ULL, 0x00001f451b087589ULL, 0x002e6200000e0000ULL,
0x0000001b0a0a7220ULL, 0x000fc60000410000ULL, 0x00000018501d9210ULL, 0x000fe20007ffe04dULL,
0x8000001e19192221ULL, 0x100fe20000010000ULL, 0x00001f441b187589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b19192820ULL, 0x000fe20000410000ULL, 0x00f4001e1d009388ULL, 0x0007e60000000800ULL,
0x00000019000d2308ULL, 0x000f220000000800ULL, 0x0000000834347220ULL, 0x082fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000810107220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x000fe20000410000ULL, 0x0000001836367220ULL, 0x084fe20000410000ULL,
0x0000001837377220ULL, 0x080fe20000410000ULL, 0x0000001832327220ULL, 0x080fe20000410000ULL,
0x0000001833337220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000182e2e7220ULL, 0x080fe20000410000ULL,
0x000000182f2f7220ULL, 0x080fe20000410000ULL, 0x000000182a2a7220ULL, 0x080fe20000410000ULL,
0x000000182b2b7220ULL, 0x080fe20000410000ULL, 0x0000001826267220ULL, 0x080fe20000410000ULL,
0x0000001827277220ULL, 0x080fe20000410000ULL, 0x0000001812127220ULL, 0x080fe20000410000ULL,
0x0000001813137220ULL, 0x080fe20000410000ULL, 0x0000001816167220ULL, 0x080fe20000410000ULL,
0x0000001817177220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e001eULL,
0x000000640d642220ULL, 0x018fce0000410000ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0xfffffff009187812ULL, 0x000fc800078ec0ffULL, 0x0000000257197210ULL, 0x000fc80007ffe018ULL,
0x00f6a86f190075a7ULL, 0x000e64000800017fULL, 0x0000009800c88947ULL, 0x002fea0003800000ULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000001062187824ULL, 0x000fe200078e0269ULL,
0x000099101c1c7816ULL, 0x000fe200000000ffULL, 0x00000010633f7824ULL, 0x000fe200078e023fULL,
0x00a000004720783bULL, 0x000fe20000000200ULL, 0x0000000dff63723eULL, 0x000fe200000000ffULL,
0x0000001061617824ULL, 0x000fe200078e0269ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000001818783bULL, 0x000fe20000004200ULL, 0x0000541063747816ULL, 0x000fe20000000063ULL,
0x000000c054547836ULL, 0x000fc40000000000ULL, 0x0000000a640a7221ULL, 0x000fe20000010000ULL,
0x000000003f3c783bULL, 0x000fe80000004200ULL, 0x00001f4574637589ULL, 0x000ea800000e0000ULL,
0x00001f4474667589ULL, 0x000ee200000e0000ULL, 0x00000018ff1d7819ULL, 0x002fe20000011440ULL,
0x00000100401f7824ULL, 0x040fe200078e00ffULL, 0x00008880401e7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x0000888041657816ULL, 0x040fe200000000ffULL,
0x00000100411c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000001d001d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006320208232ULL, 0x084fe20000000000ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000006322228232ULL, 0x000fe20000000000ULL, 0x00000018ff677819ULL, 0x000fe20000011441ULL,
0x0001000041417824ULL, 0x000fc400078e00ffULL, 0x0000006621218232ULL, 0x088fe20000000000ULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x0000006623238232ULL, 0x000fe20000000000ULL,
0x00000018ff777819ULL, 0x000fe4000001141aULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000888042757816ULL, 0x000fe400000000ffULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011442ULL, 0x00000018ff727819ULL, 0x000fe40000011443ULL,
0x00000018ff6f7819ULL, 0x000fe4000001143cULL, 0x0000541040407816ULL, 0x002fe2000000001dULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe4000001143dULL,
0x00000018ff6c7819ULL, 0x000fe4000001143fULL, 0x00000018ff627819ULL, 0x000fc40000011418ULL,
0x00008880187c7816ULL, 0x000fe200000000ffULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fe4000001143eULL, 0x00000018ff697819ULL, 0x000fca0000011419ULL,
0x0000001c00767306ULL, 0x0002b00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054101e1c7816ULL, 0x002fe4000000001fULL, 0x00005410651d7816ULL, 0x004fca0000000076ULL,
0x0000004100747306ULL, 0x000e620000200c00ULL, 0x0000888043767816ULL, 0x040fe200000000ffULL,
0x0000001c2034723cULL, 0x000fe20000001834ULL, 0x00000000611c783bULL, 0x0004ea0000004200ULL,
0x0000007700657306ULL, 0x0009e20000200c00ULL, 0x0000541074417816ULL, 0x002fe20000000067ULL,
0x0000010043617824ULL, 0x004fcc00078e00ffULL, 0x0000007500747306ULL, 0x0007e20000200c00ULL,
0x0000010042677824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x010fe20000011461ULL, 0x000000402030723cULL, 0x000fe60000001830ULL,
0x0000007600767306ULL, 0x000fe80000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011467ULL,
0x00000018ff677819ULL, 0x000fe4000001141bULL, 0x0000004000417306ULL, 0x000e700000200c00ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x00000018ff757819ULL, 0x008fc4000001141dULL,
0x0000541074407816ULL, 0x002fca0000000041ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff747819ULL, 0x000fe40000011442ULL, 0x00000018ff617819ULL, 0x000fe4000001141cULL,
0x00000018ff427819ULL, 0x000fe4000001141eULL, 0x0000541076417816ULL, 0x004fe20000000077ULL,
0x0000007200727306ULL, 0x000fec0000200c00ULL, 0x000000402038723cULL, 0x000fe40000001838ULL,
0x0000007400747306ULL, 0x000e6a0000200c00ULL, 0x0001000043407824ULL, 0x000fc600078e00ffULL,
0x0000007500437306ULL, 0x0005e40000200c00ULL, 0x00000018ff407819ULL, 0x000fcc0000011440ULL,
0x0000004000417306ULL, 0x0002e20000200c00ULL, 0x000088803d757816ULL, 0x004fce00000000ffULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541074407816ULL, 0x002fe20000000073ULL,
0x000001003c747824ULL, 0x040fe200078e00ffULL, 0x000088803c737816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000541041417816ULL, 0x008fc60000000072ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x00000040202c723cULL, 0x000fe8000000182cULL,
0x0000007300727306ULL, 0x0003e60000200c00ULL, 0x000001003d407824ULL, 0x000fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x0000007400417306ULL, 0x000fe20000200c00ULL,
0x00000018ff777819ULL, 0x000fe40000011440ULL, 0x00000018ff737819ULL, 0x002fe4000001143dULL,
0x00000018ff407819ULL, 0x000fc6000001141fULL, 0x0000007700787306ULL, 0x0002b00000200c00ULL,
0x0000003c00767306ULL, 0x0007e20000200c00ULL, 0x000088803e777816ULL, 0x002fe400000000ffULL,
0x00005410753d7816ULL, 0x004fca0000000078ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00005410723c7816ULL, 0x008fe40000000041ULL, 0x000088803f417816ULL, 0x000fca00000000ffULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000003c2028723cULL, 0x000fee0000001828ULL,
0x000001003e3d7824ULL, 0x000fe200078e00ffULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000001003f3c7824ULL, 0x000fc400078e00ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00747306ULL, 0x0003e20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff3e7819ULL, 0x000fca000001143eULL,
0x0000003c00727306ULL, 0x0005e20000200c00ULL, 0x00005410733d7816ULL, 0x002fce000000006eULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x00005410763c7816ULL, 0x004fe4000000006fULL,
0x000088801c767816ULL, 0x000fca00000000ffULL, 0x0000003c2024723cULL, 0x000fe20000001824ULL,
0x0000003f00737306ULL, 0x0005ec0000200c00ULL, 0x00000100183c7824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00000100193f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018006f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe40000011419ULL,
0x0000541041197816ULL, 0x002fca0000000072ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000541077187816ULL, 0x004fe40000000074ULL, 0x000088801a747816ULL, 0x000fca00000000ffULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000000182010723cULL, 0x000fee0000001810ULL,
0x000001001a197824ULL, 0x000fe200078e00ffULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x000001001b187824ULL, 0x000fc400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001900417306ULL, 0x0003e20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fce000001141aULL,
0x0000001800727306ULL, 0x0005e20000200c00ULL, 0x0000541073197816ULL, 0x002fe4000000006cULL,
0x000088801d6c7816ULL, 0x000fca00000000ffULL, 0x0000003c00757306ULL, 0x0003e20000200c00ULL,
0x000054103e187816ULL, 0x004fce000000006dULL, 0x000000182020723cULL, 0x000fe20000001814ULL,
0x00a000004614783bULL, 0x000ea20000000200ULL, 0x0000003d003d7306ULL, 0x000fea0000200c00ULL,
0x000001001d197824ULL, 0x040fe400078e00ffULL, 0x000001001c187824ULL, 0x040fe200078e00ffULL,
0x0000003f007a7306ULL, 0x0007220000200c00ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff3c7819ULL, 0x002fe4000001141cULL,
0x00000019006d7306ULL, 0x0003e20000200c00ULL, 0x000088801b3f7816ULL, 0x048fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc8000001141dULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0000001a003e7306ULL, 0x0007e20000200c00ULL,
0x000001001e197824ULL, 0x002fce00078e00ffULL, 0x0000001800737306ULL, 0x0003e20000200c00ULL,
0x00000018ff1a7819ULL, 0x008fe40000011419ULL, 0x000054103d197816ULL, 0x010fe4000000007aULL,
0x000088801f3d7816ULL, 0x000fe200000000ffULL, 0x0000006314148232ULL, 0x084fe40000000000ULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000054107c187816ULL, 0x002fe20000000075ULL,
0x0000006316168232ULL, 0x000fc40000000000ULL, 0x0000006615158232ULL, 0x080fe40000000000ULL,
0x0000006617178232ULL, 0x000fe20000000000ULL, 0x000000035400720cULL, 0x000fe20003f06070ULL,
0x0000006900697306ULL, 0x000fea0000200c00ULL, 0x000000181434723cULL, 0x000fe60000001834ULL,
0x0000006e006e7306ULL, 0x000e680000200c00ULL, 0x000001001f187824ULL, 0x000fc400078e00ffULL,
0x000100001f1f7824ULL, 0x000fe400078e00ffULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x00000018ff197819ULL, 0x000fe20000011418ULL, 0x000100001e187824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc8000001141fULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000003f003f7306ULL, 0x000f300000200c00ULL, 0x0000001b00787306ULL, 0x000bf00000200c00ULL,
0x00000018001d7306ULL, 0x0005e20000200c00ULL, 0x000088801e1b7816ULL, 0x020fce00000000ffULL,
0x00000019001e7306ULL, 0x0003e20000200c00ULL, 0x000054106f187816ULL, 0x004fe20000000062ULL,
0x000000ffff6f7224ULL, 0x000fcc00078e0071ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054106e197816ULL, 0x002fe20000000069ULL, 0x000000ffff6e7224ULL, 0x000fcc00078e0070ULL,
0x000000181430723cULL, 0x000fe20000001830ULL, 0x0000007600767306ULL, 0x000e6c0000200c00ULL,
0x0000541074187816ULL, 0x008fe40000000041ULL, 0x000054103f197816ULL, 0x010fe20000000072ULL,
0x0000006c006c7306ULL, 0x000eec0000200c00ULL, 0x000000181438723cULL, 0x000fe40000001838ULL,
0x0000006100617306ULL, 0x000fea0000200c00ULL, 0x000054103e187816ULL, 0x000fc40000000065ULL,
0x0000541078197816ULL, 0x004fe20000000067ULL, 0x0000003c003c7306ULL, 0x000eac0000200c00ULL,
0x00000018142c723cULL, 0x000fe4000000182cULL, 0x0000001c001c7306ULL, 0x000f2a0000200c00ULL,
0x0000541076187816ULL, 0x002fc40000000073ULL, 0x000054106c197816ULL, 0x008fe2000000006dULL,
0x0000001b001b7306ULL, 0x000fe20000200c00ULL, 0x000000015d6c7812ULL, 0x000fca00078e0cffULL,
0x000000181428723cULL, 0x000fe40000001828ULL, 0x0000001a001a7306ULL, 0x000e6a0000200c00ULL,
0x000054103c187816ULL, 0x004fe40000000061ULL, 0x000054101c197816ULL, 0x010fe20000000043ULL,
0x0000003d003d7306ULL, 0x000eac0000200c00ULL, 0x000000181424723cULL, 0x000fe40000001824ULL,
0x0000004200427306ULL, 0x000eea0000200c00ULL, 0x000054101b187816ULL, 0x002fc4000000001aULL,
0x000054103d197816ULL, 0x004fe2000000001eULL, 0x0000004000407306ULL, 0x000fec0000200c00ULL,
0x000000181410723cULL, 0x000fe40000001810ULL, 0x0000001f001f7306ULL, 0x000e6a0000200c00ULL,
0x000054101d187816ULL, 0x008fc40000000042ULL, 0x00f6c80c491c79a7ULL, 0x0004e2000850003fULL,
0x000054101f197816ULL, 0x002fe20000000040ULL, 0x00f6980c4bff79a7ULL, 0x0005ec000850003fULL,
0x000000181414723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000001400880947ULL, 0x000fde0003800000ULL, 0x0000001d510075a7ULL, 0x008e62000800007fULL,
0x0000000104187824ULL, 0x000fc800078e020eULL, 0x0000000818197824ULL, 0x040fe400078e020bULL,
0x0000000118187836ULL, 0x000fe40000000000ULL, 0x0000002019197824ULL, 0x000fc600078e00ffULL,
0x000000051800720cULL, 0x000fe20003f26070ULL, 0x00000007061a7c24ULL, 0x000fe2000f8e0219ULL,
0x00000019031e7248ULL, 0x000fca0007fe0000ULL, 0x000000011e1e7824ULL, 0x000fe200078e0a19ULL,
0x0000004e1a197210ULL, 0x000fc80007ffe007ULL, 0x000000201e1e7807ULL, 0x000fe20000800000ULL,
0x0000000000080947ULL, 0x002fec0003800000ULL, 0x00f6c81d530075a7ULL, 0x000e64000800017fULL,
0x0000008800e48947ULL, 0x002fea0003800000ULL, 0x0000008019187825ULL, 0x000fe200078e006aULL,
0x0000001e071e7248ULL, 0x000fe40007fe0000ULL, 0x0000004c1a1b7210ULL, 0x000fe20007ffe007ULL,
0x000000015e577824ULL, 0x000fe200078e0257ULL, 0x0000004a1a1d7210ULL, 0x100fe20007ffe007ULL,
0x000000011e1f7824ULL, 0x100fe200078e0a07ULL, 0x0000004d18187210ULL, 0x000fe40007f3e0ffULL,
0x000000481a217210ULL, 0x000fe20007ffe007ULL, 0x000000801b1a7825ULL, 0x000fe200078e006aULL,
0x0000001f4e00720cULL, 0x000fc40003f06070ULL, 0x0000001f4a00720cULL, 0x080fe20003f46070ULL,
0x000000801d1c7825ULL, 0x000fe200078e006aULL, 0x0000001f4800720cULL, 0x080fe40003f66070ULL,
0x0000004d1a1a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000001f4c00720cULL, 0x000fe20003f26070ULL, 0x00000080216a7825ULL, 0x000fe200078e006aULL,
0x0000004d1c1c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x0000004d6a1e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000185b7faeULL, 0x0003e6000c101c48ULL,
0x000000ffff1f7224ULL, 0x000fe400030e066bULL, 0x000000001a5a7faeULL, 0x0003e8000c901c48ULL,
0x000000001c597faeULL, 0x0003e8000d101c48ULL, 0x000000001e587faeULL, 0x0003e2000d901c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000c576e79a7ULL, 0x0006e2000850003fULL,
0x000001804d1b7810ULL, 0x002fca0007ffe052ULL, 0x00000001501b7824ULL, 0x000fe200078e021bULL,
0x00000071ff0075a7ULL, 0x0006e20008000045ULL, 0x00f6680c4f1879a7ULL, 0x000e64000850003fULL,
0x00f668194f0075a7ULL, 0x002e64000802017fULL, 0x0000008800609947ULL, 0x00afea0003800000ULL,
0x00f000001b197984ULL, 0x000e620000000800ULL, 0x00000001ff537424ULL, 0x000fc600078e00ffULL,
0x00f200001b407984ULL, 0x0006e20000000800ULL, 0x000000081900720bULL, 0x002fda0003f3d000ULL,
0x0000000000187806ULL, 0x000fc800008e0100ULL, 0x0000ffff181c7812ULL, 0x000fda000782c0ffULL,
0x0000000000d89947ULL, 0x008fea0003800000ULL, 0x000000081900720bULL, 0x000fe40003f34000ULL,
0x00000019081e7209ULL, 0x000fca0007810000ULL, 0x8000001e08187221ULL, 0x000fe20000010000ULL,
0x000000030f087811ULL, 0x000fc600078ff0ffULL, 0x3fb8aa3b181a7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400008e0100ULL, 0x0000000f0800720cULL, 0x000fe20003f25270ULL,
0x0000001a001b7308ULL, 0x000e620000000800ULL, 0x0000ffff181d7812ULL, 0x000fc800078e3cffULL,
0x0000001d1cff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff537807ULL, 0x000fc60001000000ULL,
0x000000800f189824ULL, 0x000fe200078e0202ULL, 0x00001f451b087589ULL, 0x002e6200000e0000ULL,
0x0000001b0a0a7220ULL, 0x000fc60000410000ULL, 0x00000018504d9210ULL, 0x000fe20007ffe04dULL,
0x8000001e19192221ULL, 0x100fe20000010000ULL, 0x00001f441b187589ULL, 0x000ee600000e0000ULL,
0x3fb8aa3b19192820ULL, 0x000fe20000410000ULL, 0x00f4001e4d009388ULL, 0x0009e60000000800ULL,
0x00000019000d2308ULL, 0x000f620000000800ULL, 0x0000000834347220ULL, 0x082fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000810107220ULL, 0x080fe20000410000ULL,
0x0000000811117220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x000fe20000410000ULL, 0x0000001836367220ULL, 0x088fe20000410000ULL,
0x0000001837377220ULL, 0x080fe20000410000ULL, 0x0000001832327220ULL, 0x080fe20000410000ULL,
0x0000001833337220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000182e2e7220ULL, 0x080fe20000410000ULL,
0x000000182f2f7220ULL, 0x080fe20000410000ULL, 0x000000182a2a7220ULL, 0x080fe20000410000ULL,
0x000000182b2b7220ULL, 0x080fe20000410000ULL, 0x0000001826267220ULL, 0x080fe20000410000ULL,
0x0000001827277220ULL, 0x080fe20000410000ULL, 0x0000001812127220ULL, 0x080fe20000410000ULL,
0x0000001813137220ULL, 0x080fe20000410000ULL, 0x0000001816167220ULL, 0x080fe20000410000ULL,
0x0000001817177220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e001eULL,
0x000000400d402220ULL, 0x030fce0000410000ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000085c197812ULL, 0x000fe400078e0cffULL, 0xfffffff009187812ULL, 0x000fc800078ec0ffULL,
0x0000000219197210ULL, 0x000fc80007ffe018ULL, 0x00f6a871190075a7ULL, 0x000e64000800017fULL,
0x00000084006c8947ULL, 0x002fea0003800000ULL, 0x000000005620783bULL, 0x000e620000004200ULL,
0x0000000dff57723eULL, 0x000fe200000000ffULL, 0x0000000a400a7221ULL, 0x000fe40000010000ULL,
0x00000000553c783bULL, 0x0007e20000004200ULL, 0x0000541057797816ULL, 0x000fc60000000057ULL,
0x000000005f18783bULL, 0x000f280000004200ULL, 0x00000000601c783bULL, 0x000f680000004200ULL,
0x00001f4579577589ULL, 0x000fe800000e0000ULL, 0x00001f4479587589ULL, 0x0009e200000e0000ULL,
0x00000018ff597819ULL, 0x002fe20000011420ULL, 0x0000010020517824ULL, 0x040fe200078e00ffULL,
0x0000888020757816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011421ULL, 0x0000010021527824ULL, 0x040fe200078e00ffULL,
0x0000888021557816ULL, 0x048fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000001001b447824ULL, 0x010fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fc40000011421ULL, 0x00000018ff6d7819ULL, 0x000fe40000011422ULL,
0x0000888022747816ULL, 0x000fe200000000ffULL, 0x0000002000787306ULL, 0x0003e20000200c00ULL,
0x00000018ff627819ULL, 0x000fe4000001143cULL, 0x00000018ff507819ULL, 0x000fe4000001143eULL,
0x000088803c6c7816ULL, 0x000fe400000000ffULL, 0x000088803e617816ULL, 0x000fe200000000ffULL,
0x0000002100767306ULL, 0x0007e20000200c00ULL, 0x0000010023207824ULL, 0x002fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fc40000011423ULL, 0x0000888023647816ULL, 0x040fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005100567306ULL, 0x0003220000200c00ULL, 0x000001003c217824ULL, 0x048fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143dULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x0000002000717306ULL, 0x0007e20000200c00ULL, 0x0000010022517824ULL, 0x042fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x000088803d697816ULL, 0x040fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011418ULL,
0x00000021006b7306ULL, 0x0003e20000200c00ULL, 0x000001003d207824ULL, 0x048fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200727306ULL, 0x0007e20000200c00ULL, 0x000001003e217824ULL, 0x042fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011419ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020006a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010019227824ULL, 0x008fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc40000011451ULL,
0x00000018ff437819ULL, 0x000fe4000001141aULL, 0x00000018ff547819ULL, 0x000fe20000011422ULL,
0x0000002100607306ULL, 0x0007e20000200c00ULL, 0x000001003f207824ULL, 0x002fe200078e00ffULL,
0x000088801a777816ULL, 0x000fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe4000001141bULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000003c00677306ULL, 0x000fe20000200c00ULL,
0x0000010018217824ULL, 0x008fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x020fc4000001141cULL,
0x00000018ff4f7819ULL, 0x000fe4000001143fULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020005e7306ULL, 0x0003e20000200c00ULL, 0x000088803f5b7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001141dULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003e005f7306ULL, 0x000fe20000200c00ULL, 0x0000888019207816ULL, 0x042fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc4000001141eULL,
0x00000018ff4e7819ULL, 0x000fe4000001141fULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000002300707306ULL, 0x000ff00000200c00ULL, 0x00000021003c7306ULL, 0x000ff00000200c00ULL,
0x00000020003e7306ULL, 0x0003f00000200c00ULL, 0x0000003d00667306ULL, 0x0007e20000200c00ULL,
0x00a800004720783bULL, 0x00236e0000000200ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00008880183d7816ULL, 0x048fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x0000991053477816ULL, 0x002fc800000000ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x00000052005a7306ULL, 0x000e620000200c00ULL, 0x000000ff4700720cULL, 0x000fce0003f05270ULL,
0x0000001800527306ULL, 0x0007f00000200c00ULL, 0x0000005100737306ULL, 0x000fe20000200c00ULL,
0x000001001a187824ULL, 0x048fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000001900517306ULL, 0x0007e20000200c00ULL,
0x0000005720208232ULL, 0x0a0fe20000000000ULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0000005722228232ULL, 0x000fe40000000000ULL, 0x0000005821218232ULL, 0x080fe40000000000ULL,
0x0000005823238232ULL, 0x000fe20000000000ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000088801b197816ULL, 0x048fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0000006300637306ULL, 0x000ef00000200c00ULL,
0x0000001800537306ULL, 0x0009f00000200c00ULL, 0x0000001900457306ULL, 0x0003e20000200c00ULL,
0x0000541075187816ULL, 0x010fe20000000056ULL, 0x000001001d757824ULL, 0x000fcc00078e00ffULL,
0x0000007400747306ULL, 0x000f220000200c00ULL, 0x0000541055197816ULL, 0x002fe4000000005aULL,
0x000088801c5a7816ULL, 0x000fca00000000ffULL, 0x000000182034723cULL, 0x000fe20000001834ULL,
0x0000006400647306ULL, 0x000e6c0000200c00ULL, 0x000001001c187824ULL, 0x000fe200078e00ffULL,
0x0000541076197816ULL, 0x008fe20000000063ULL, 0x0000001a00567306ULL, 0x0007e20000200c00ULL,
0x000100001c1c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011418ULL,
0x0000541078187816ULL, 0x000fe40000000059ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000006d006d7306ULL, 0x000f620000200c00ULL, 0x000088801d1a7816ULL, 0x008fc600000000ffULL,
0x000000182030723cULL, 0x000fe40000001830ULL, 0x000000ffff637224ULL, 0x000fe400078e001aULL,
0x0000006500657306ULL, 0x000ef00000200c00ULL, 0x0000001b00557306ULL, 0x0003f00000200c00ULL,
0x0000004700597306ULL, 0x0007e20000200c00ULL, 0x00a800004618783bULL, 0x00686e0000000200ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541074467816ULL, 0x010fc40000000073ULL,
0x0000541064477816ULL, 0x008fe40000000071ULL, 0x00000018ff647819ULL, 0x000fc60000011475ULL,
0x0000006900697306ULL, 0x000ea40000200c00ULL, 0x000000462038723cULL, 0x000fec0000001838ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x0000541072467816ULL, 0x020fe4000000006dULL,
0x0000541070477816ULL, 0x000fca0000000065ULL, 0x0000005d005d7306ULL, 0x000f240000200c00ULL,
0x00000046202c723cULL, 0x000fec000000182cULL, 0x0000001c00657306ULL, 0x000be20000200c00ULL,
0x000100001d467824ULL, 0x000fe200078e00ffULL, 0x00005410691d7816ULL, 0x004fe2000000006aULL,
0x0000005718188232ULL, 0x082fe20000000000ULL, 0x000088801e477816ULL, 0x000fe200000000ffULL,
0x000000571a1a8232ULL, 0x000fe20000000000ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000005819198232ULL, 0x080fe20000000000ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x000054106c1c7816ULL, 0x020fe2000000006bULL, 0x000000581b1b8232ULL, 0x000fc40000000000ULL,
0x000000ffff6c7224ULL, 0x000fc800078e0068ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000001c2028723cULL, 0x000fee0000001828ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00005410671c7816ULL, 0x008fe40000000062ULL, 0x00005410661d7816ULL, 0x010fca000000005dULL,
0x0000005b005b7306ULL, 0x000fe40000200c00ULL, 0x0000001c2024723cULL, 0x000fec0000001824ULL,
0x0000003f005c7306ULL, 0x000ea20000200c00ULL, 0x000001001e1d7824ULL, 0x040fe200078e00ffULL,
0x000054105f1c7816ULL, 0x002fe20000000050ULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff507819ULL, 0x000fe4000001141dULL, 0x0000004600697306ULL, 0x0003e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x000054105c1d7816ULL, 0x004fca000000004fULL,
0x00000047005d7306ULL, 0x0005e20000200c00ULL, 0x0000541061467816ULL, 0x002fe20000000060ULL,
0x0000001c2014723cULL, 0x000fec0000001814ULL, 0x00000054003f7306ULL, 0x000fe20000200c00ULL,
0x000054105b477816ULL, 0x004fe2000000005eULL, 0x000001001f1d7824ULL, 0x000fcc00078e00ffULL,
0x000000462010723cULL, 0x000fe20000001810ULL, 0x0000007700547306ULL, 0x000fe20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fca000001141dULL, 0x000100001f217824ULL, 0x040fe200078e00ffULL,
0x000088801f477816ULL, 0x000fe200000000ffULL, 0x0000004400447306ULL, 0x000e660000200c00ULL,
0x00000018ff217819ULL, 0x000fca0000011421ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x00005410451f7816ULL, 0x002fce0000000044ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054103d3c7816ULL, 0x004fce000000003cULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x000054103e3d7816ULL, 0x000fce000000003fULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000541051517816ULL, 0x002fcc0000000042ULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x002fce0000000048ULL, 0x0000004c004c7306ULL, 0x000ff00000200c00ULL,
0x0000004d004d7306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000005a005a7306ULL, 0x000e700000200c00ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000054105a5a7816ULL, 0x002fce0000000059ULL, 0x0000006400647306ULL, 0x000e700000200c00ULL,
0x0000005000467306ULL, 0x0004e20000200c00ULL, 0x00005410635b7816ULL, 0x002fce0000000064ULL,
0x00000047001c7306ULL, 0x000fe20000200c00ULL, 0x0000541052507816ULL, 0x004fe20000000041ULL,
0x0000005a1828723cULL, 0x000fe20000001828ULL, 0x000054105d467816ULL, 0x008fca0000000046ULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x000000501830723cULL, 0x000fee0000001830ULL,
0x0000001e00207306ULL, 0x0004e20000200c00ULL, 0x000054101c477816ULL, 0x002fce000000001dULL,
0x0000002100217306ULL, 0x000e620000200c00ULL, 0x00005410541e7816ULL, 0x004fe20000000053ULL,
0x00f6c80c491c79a7ULL, 0x0004a2000850003fULL, 0x0000541056547816ULL, 0x000fe20000000043ULL,
0x000000461810723cULL, 0x000fe20000001810ULL, 0x0000541020207816ULL, 0x008fe2000000004dULL,
0x00f6a00c4bff79a7ULL, 0x0005e8000850003fULL, 0x0000001e1838723cULL, 0x000fe20000001838ULL,
0x0000541021217816ULL, 0x002fca000000004eULL, 0x00000054182c723cULL, 0x000fe2000000182cULL,
0x00005410651e7816ULL, 0x000fe4000000004aULL, 0x00005410691f7816ULL, 0x000fc6000000004cULL,
0x000000201814723cULL, 0x000fec0000001814ULL, 0x0000001e1824723cULL, 0x004fde0000001824ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000001040e7824ULL, 0x000fca00078e020eULL,
0x000000050e00720cULL, 0x000fda0003f06070ULL, 0xffffff9c006c8947ULL, 0x00efea000383ffffULL,
0x0000000000037919ULL, 0x000f220000002500ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0038ULL,
0x000000ffff387224ULL, 0x000fe200078e0030ULL, 0x000000050300720cULL, 0x010fe40003f06070ULL,
0x000000010f057812ULL, 0x000fd600078ec0ffULL, 0x0000000000d80947ULL, 0x000fea0003800000ULL,
0x018000000a007836ULL, 0x000fe20000000000ULL, 0x000000c000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000737000097802ULL, 0x000fce0000000f00ULL,
0x0000007c00387944ULL, 0x00efea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e000cULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000a00077308ULL, 0x000f240000001000ULL,
0xbf80000007007423ULL, 0x010fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000007007223ULL, 0x000fce0000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009200ff067b82ULL, 0x000f240000000a00ULL, 0x0000000806077981ULL, 0x010f22000c1e9900ULL,
0x00000000000d7919ULL, 0x000f640000000000ULL, 0x00000002ff097819ULL, 0x020fe4000001160dULL,
0x000000080d0d7811ULL, 0x000fe200078ff0ffULL, 0x0000000007007220ULL, 0x010fca0000410000ULL,
0x00001f0900097589ULL, 0x000f2800000e0000ULL, 0x00001f0d000d7589ULL, 0x000f6200000e0000ULL,
0x0000003409347220ULL, 0x050fe20000410000ULL, 0x0000003509357220ULL, 0x040fe20000410000ULL,
0x0000003809387220ULL, 0x040fe20000410000ULL, 0x0000003109317220ULL, 0x040fe20000410000ULL,
0x0000003c093c7220ULL, 0x040fe20000410000ULL, 0x0000003909397220ULL, 0x040fe20000410000ULL,
0x0000002c092c7220ULL, 0x040fe20000410000ULL, 0x0000002d092d7220ULL, 0x040fe20000410000ULL,
0x0000002809287220ULL, 0x040fe20000410000ULL, 0x0000002909297220ULL, 0x040fe20000410000ULL,
0x0000002409247220ULL, 0x040fe20000410000ULL, 0x0000002509257220ULL, 0x040fe20000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x000fe20000410000ULL,
0x000000360d367220ULL, 0x060fe20000410000ULL, 0x000000370d377220ULL, 0x040fe20000410000ULL,
0x000000320d327220ULL, 0x040fe20000410000ULL, 0x000000330d337220ULL, 0x040fe20000410000ULL,
0x0000003a0d3a7220ULL, 0x040fe20000410000ULL, 0x0000003b0d3b7220ULL, 0x040fe20000410000ULL,
0x0000002e0d2e7220ULL, 0x040fe20000410000ULL, 0x0000002f0d2f7220ULL, 0x040fe20000410000ULL,
0x0000002a0d2a7220ULL, 0x040fe20000410000ULL, 0x0000002b0d2b7220ULL, 0x040fe20000410000ULL,
0x000000260d267220ULL, 0x040fe20000410000ULL, 0x000000270d277220ULL, 0x040fe20000410000ULL,
0x000000120d127220ULL, 0x040fe20000410000ULL, 0x000000130d137220ULL, 0x040fe20000410000ULL,
0x000000160d167220ULL, 0x040fe20000410000ULL, 0x000000170d177220ULL, 0x000fce0000410000ULL,
0x00000000001c7919ULL, 0x008ee20000000000ULL, 0x0000002c2d2c723eULL, 0x000fe400000000ffULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000101110723eULL, 0x000fe400000000ffULL,
0x000000141514723eULL, 0x000fe400000000ffULL, 0x000000363736723eULL, 0x000fc400000000ffULL,
0x0000003a3b3a723eULL, 0x000fe400000000ffULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000262715723eULL, 0x000fe400000000ffULL,
0x000000121312723eULL, 0x000fe400000000ffULL, 0x000000010400780cULL, 0x000fc40003f05270ULL,
0x000000021c007812ULL, 0x008fe400078ec0ffULL, 0x00000002ff1b7819ULL, 0x000fe4000001161cULL,
0x00000001ff067819ULL, 0x000fe40000011600ULL, 0x0000000200077811ULL, 0x000fe400078ff8ffULL,
0x000000081c307811ULL, 0x000fe400078ff0ffULL, 0x00000004000d7811ULL, 0x000fc400078ff8ffULL,
0x0000000600197811ULL, 0x000fe400078ff8ffULL, 0x0000000706007812ULL, 0x000fe400078e781bULL,
0x0000000707097812ULL, 0x000fe400078e781bULL, 0x0000000707077812ULL, 0x000fe200078e7830ULL,
0x000000081b0c7824ULL, 0x000fe200078e0200ULL, 0x000000070d187812ULL, 0x000fe200078e781bULL,
0x0000100005007824ULL, 0x000fe200078e0202ULL, 0x00000007191a7812ULL, 0x002fe200078e781bULL,
0x0000000830207824ULL, 0x000fe200078e0207ULL, 0x0000000706067812ULL, 0x000fe200078e7830ULL,
0x000000081c077824ULL, 0x000fe200078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078e7830ULL,
0x000000081b0e7824ULL, 0x000fe200078e0209ULL, 0x0000000719197812ULL, 0x000fe200078e7830ULL,
0x00000008301e7824ULL, 0x040fe200078e0206ULL, 0x0000000807077812ULL, 0x000fe200078ec0ffULL,
0x0000000830227824ULL, 0x040fe200078e020dULL, 0x000000343502723eULL, 0x000fe200000000ffULL,
0x000000081b187824ULL, 0x000fe200078e0218ULL, 0x000000383106723eULL, 0x000fe200000000ffULL,
0x000000081b1a7824ULL, 0x000fe200078e021aULL, 0x00000032331b723eULL, 0x000fe200000000ffULL,
0x0000000830307824ULL, 0x000fe200078e0219ULL, 0x0000541002347816ULL, 0x040fe20000000006ULL,
0x000008000b1d7824ULL, 0x040fe200078e0200ULL, 0x0000763202357816ULL, 0x000fe20000000006ULL,
0x000000200b0d7824ULL, 0x000fe200078e021cULL, 0x000000161709723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fc400078e021dULL, 0x000000100e0e7824ULL, 0x100fe400078e021dULL,
0x0000001018187824ULL, 0x100fe400078e021dULL, 0x000000101e1e7824ULL, 0x100fe400078e021dULL,
0x0000001020207824ULL, 0x100fe400078e021dULL, 0x000000101a1a7824ULL, 0x100fe400078e021dULL,
0x0000001022227824ULL, 0x000fc400078e021dULL, 0x0000001030307824ULL, 0x000fe400078e021dULL,
0x000000010c0c7824ULL, 0x000fe400078e0207ULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x0000000107187824ULL, 0x040fe200078e0218ULL, 0x000000340c007388ULL, 0x000fe20000000a00ULL,
0x00000001071e7824ULL, 0x040fe400078e021eULL, 0x0000000107207824ULL, 0x000fc400078e0220ULL,
0x00000001071a7824ULL, 0x040fe400078e021aULL, 0x0000000107227824ULL, 0x040fe400078e0222ULL,
0x0000000107307824ULL, 0x000fe200078e0230ULL, 0x0000003c3907723eULL, 0x000fc800000000ffULL,
0x0000541007067816ULL, 0x140fe4000000002cULL, 0x0000763207077816ULL, 0x000fca000000002cULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541028067816ULL, 0x142fe40000000024ULL,
0x0000763228077816ULL, 0x000fca0000000024ULL, 0x0000000618007388ULL, 0x0003e40000000a00ULL,
0x0000541010067816ULL, 0x142fe40000000014ULL, 0x0000763210077816ULL, 0x000fe20000000014ULL,
0x000000100d107824ULL, 0x000fc800078e0200ULL, 0x000000061a007388ULL, 0x0003e40000000a00ULL,
0x00005410361a7816ULL, 0x142fe4000000001bULL, 0x00007632361b7816ULL, 0x000fe4000000001bULL,
0x000054103a067816ULL, 0x140fe4000000002eULL, 0x000076323a077816ULL, 0x000fe2000000002eULL,
0x0000001a1e007388ULL, 0x000fe80000000a00ULL, 0x0000000620007388ULL, 0x0003e40000000a00ULL,
0x000054102a067816ULL, 0x002fc40000000015ULL, 0x000076322a077816ULL, 0x000fca0000000015ULL,
0x0000000622007388ULL, 0x0003e40000000a00ULL, 0x0000541012067816ULL, 0x142fe40000000009ULL,
0x0000763212077816ULL, 0x000fca0000000009ULL, 0x0000000630007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000010147984ULL, 0x000e680000000c00ULL,
0x0004000010247984ULL, 0x000ee80000000c00ULL, 0x0008000010187984ULL, 0x000f280000000c00ULL,
0x000c000010287984ULL, 0x000f620000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe40000000000ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x020fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001410007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002410007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000002400dc8947ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000ee20000002700ULL,
0x00008400ff117b82ULL, 0x000ee20000000800ULL, 0x000004000f207824ULL, 0x000fe200078e00ffULL,
0x000000010bff7812ULL, 0x000fe2000780f80fULL, 0x0000000000027919ULL, 0x000ee20000002600ULL,
0x0000040000227802ULL, 0x000fe40000000f00ULL, 0x0000040020207812ULL, 0x000fe200078ee2ffULL,
0x0000000000177919ULL, 0x002e620000008800ULL, 0x00009000ff217b82ULL, 0x000f300000000800ULL,
0x00009600ff067b82ULL, 0x000f620000000a00ULL, 0x0000001109097224ULL, 0x008fc400078e0202ULL,
0x0000001104027224ULL, 0x000fe400078e02ffULL, 0x0000000010107984ULL, 0x000ee20000000c00ULL,
0x00000004091e7224ULL, 0x000fe200078e02ffULL, 0x0000065417227816ULL, 0x002fe20000000022ULL,
0x0000002102217224ULL, 0x010fe400078e02ffULL, 0x000000011e0e7824ULL, 0x000fc600078e0203ULL,
0x000007ff211f7811ULL, 0x040fe400078e40ffULL, 0x01ffffff21217812ULL, 0x000fe400078ec0ffULL,
0x0000000e1f037211ULL, 0x000fca00078fa8ffULL, 0x0000080003027825ULL, 0x020fc600078e0006ULL,
0x0000002002147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0603ULL,
0x000000ff1c00720cULL, 0x000fe20000725670ULL, 0x000000100d147825ULL, 0x000fe200078e0014ULL,
0x0000000000380947ULL, 0x000ff60003800000ULL, 0x00009600ff0c7b82ULL, 0x000e620000000a00ULL,
0x000000010e177824ULL, 0x000fe200078e0221ULL, 0x00000001ff187819ULL, 0x000fe2000001161cULL,
0x000000101c167824ULL, 0x000fc600078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x000000800e027825ULL, 0x002fc800078e000cULL, 0x00000080170c7825ULL, 0x000fe200078e000cULL,
0x0000007016177812ULL, 0x000fc800078ec0ffULL, 0x0000000218027210ULL, 0x140fe40007a1e017ULL,
0x0000000c180c7210ULL, 0x000fe40007c7e017ULL, 0x00000003ff037210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x0000000802007986ULL, 0x0003e8000c101908ULL,
0x0000000a0c007986ULL, 0x0003e4000c101908ULL, 0x0000001014007986ULL, 0x0087e2000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009400ff027b82ULL, 0x002e620000000a00ULL, 0xffffffff040d7836ULL, 0x000fe40000000000ULL,
0x0000000409027825ULL, 0x002fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x0000000d020279a8ULL, 0x000f2800099ee1c8ULL,
0x00000000ff00798fULL, 0x010fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000d0200720cULL, 0x000fc80003f05270ULL, 0x00000001ff087807ULL, 0x000fca0000000000ULL,
0x00000008ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000022027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x0000002000d08947ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x000000101c087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe2000001161cULL,
0x000000011e097836ULL, 0x040fe40000000000ULL, 0x000000801e027825ULL, 0x100fe200078e0006ULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fc600078e0006ULL, 0x000000020a0c7210ULL, 0x140fe4000791e019ULL,
0x000000080a087210ULL, 0x000fe40007b5e019ULL, 0x00000003ff0d7210ULL, 0x000fe400007e24ffULL,
0x00000009ff097210ULL, 0x000fc600017e64ffULL, 0x000000080c027981ULL, 0x000368000c1e1900ULL,
0x0000000808037981ULL, 0x000362000c1e1900ULL, 0x000000020400780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x000000021e097836ULL, 0x000fc80000000000ULL,
0x0000008009087825ULL, 0x000fc600078e0006ULL, 0x000000080a087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fcc00007e24ffULL, 0x0000000808097981ULL, 0x000362000c1e1900ULL,
0x000000040400780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x000000031e0d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c0a0c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c117981ULL, 0x008362000c1e1900ULL, 0x000000040400780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x000000041e0d7836ULL, 0x000fc80000000000ULL,
0x000000800d0c7825ULL, 0x000fc600078e0006ULL, 0x0000000c0a0c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c137981ULL, 0x000362000c1e1900ULL,
0x000000060400780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x000000051e0d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c0a0c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c157981ULL, 0x000362000c1e1900ULL, 0x000000060400780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000080400780cULL, 0x000fe20003f06070ULL,
0x000000061e0d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c0a0c7210ULL, 0x000fca0007a3e019ULL, 0x000000071e170836ULL, 0x000fe20000000000ULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x0000008017060825ULL, 0x000fe400078e0006ULL,
0x000000080c177981ULL, 0x000362000c1e1900ULL, 0x000000060a060210ULL, 0x000fc80007c7e019ULL,
0x00000007ff070210ULL, 0x000fca0001fe84ffULL, 0x0000000806190981ULL, 0x000368000c1e1900ULL,
0x0000000704067836ULL, 0x002fca0000000000ULL, 0x00000003ff0a7819ULL, 0x000fc80000011606ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009600ff067b82ULL, 0x000e620000000a00ULL, 0x000000ffff0e7224ULL, 0x000fe200078e001eULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x020fe200078e0002ULL,
0x0000003f00057c82ULL, 0x000fcc0008000000ULL, 0x0000000404007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x000000050a007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804067890ULL, 0x000fe2000fffe03fULL,
0x0000001b02027209ULL, 0x000fe20007810000ULL, 0x0000000104077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x000000080e0d7836ULL, 0x000fc60000000000ULL,
0x00000070081b7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x002fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e01bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c1b7981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904067890ULL, 0x000fe2000fffe03fULL,
0x0000000302027209ULL, 0x000fe20007810000ULL, 0x0000000204077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c037824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe2000001161cULL, 0x000000090e0d7836ULL, 0x002fc60000000000ULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000000c080c7210ULL, 0x000fc80007b3e003ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c037981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04067890ULL, 0x000fe2000fffe03fULL,
0x0000000902027209ULL, 0x000fe20007810000ULL, 0x0000000304077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x002fe2000001161cULL, 0x0000000a0e097836ULL, 0x000fc60000000000ULL,
0x00000070080d7812ULL, 0x000fe200078ec0ffULL, 0x0000008009087825ULL, 0x000fe200078e0006ULL,
0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fcc0000fe64ffULL, 0x0000000808097981ULL, 0x000366000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04067890ULL, 0x000fe2000fffe03fULL,
0x0000001102027209ULL, 0x000fe20007810000ULL, 0x0000000404077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x0000000b0e0d7836ULL, 0x000fc60000000000ULL,
0x0000007008117812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c117981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04067890ULL, 0x000fe2000fffe03fULL,
0x0000001302027209ULL, 0x000fe20007810000ULL, 0x0000000504077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x0000000c0e0d7836ULL, 0x000fc60000000000ULL,
0x0000007008137812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c137981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04067890ULL, 0x000fe2000fffe03fULL,
0x0000001502027209ULL, 0x000fe20007810000ULL, 0x0000000604077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x0000000d0e0d7836ULL, 0x000fc60000000000ULL,
0x0000007008157812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e015ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c157981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04067890ULL, 0x000fe2000fffe03fULL,
0x0000001702027209ULL, 0x000fe20007810000ULL, 0x0000000704077890ULL, 0x000fc8000fffe03fULL,
0x0000000604007c0cULL, 0x040fe4000bf23070ULL, 0x0000000704007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x0000000e0e0d7836ULL, 0x000fc60000000000ULL,
0x0000007008177812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c177981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04067890ULL, 0x000fe2000fffe03fULL,
0x0000001902027209ULL, 0x000fca0007810000ULL, 0x0000000604007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101c087824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x008fe2000001161cULL, 0x0000000f0e0d7836ULL, 0x000fc60000000000ULL,
0x0000007008197812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007a3e019ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000080c197981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x000000080e0e7836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x00000000001c7919ULL, 0x000f240000000000ULL,
0x000000101c037824ULL, 0x030fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fc8000001161cULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ec0ffULL,
0x0000002206037210ULL, 0x000fca0007ffe003ULL, 0x0000000203007388ULL, 0x0003e40000000800ULL,
0x00009600ff087b82ULL, 0x000f220000000a00ULL, 0x000000071c00780cULL, 0x040fe20003f04070ULL,
0x000000010b0c7824ULL, 0x000fe200078e021eULL, 0x00000002ff067819ULL, 0x000fe2000001160fULL,
0x000000101c237824ULL, 0x040fe200078e00ffULL, 0x00000001ff247819ULL, 0x000fe2000001161cULL,
0x000000201c117836ULL, 0x008fe20000000000ULL, 0x0000000106067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x0000000c1f037211ULL, 0x002fe400078fa8ffULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x0000007023237812ULL, 0x000fe400078ec0ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000c24247812ULL, 0x000fe200078ec0ffULL,
0x000002000b0a8824ULL, 0x140fe200078e0222ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000002000b0e8824ULL, 0x000fe200078e0222ULL, 0x0000002224257210ULL, 0x000fe20007ffe023ULL,
0x0000010005078824ULL, 0x000fe200078e020aULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000020000b0a7824ULL, 0x000fe200078e0222ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000008006138824ULL, 0x000fe200078e0207ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000002000f077824ULL, 0x000fe200078e00ffULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000080003027825ULL, 0x010fe200078e0008ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000080007077812ULL, 0x000fe200078ec0ffULL,
0x00000100050d8824ULL, 0x040fe200078e020eULL, 0x0000002002027210ULL, 0x000fe20007f3e0ffULL,
0x00001000050a7824ULL, 0x000fe200078e020aULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000001210f8824ULL, 0x000fe200078e020cULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000008006158824ULL, 0x000fe200078e020dULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000010a077824ULL, 0x000fe200078e0207ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200008e0603ULL, 0x000000040b00720cULL, 0x000fe20003f26070ULL,
0x000000800c0c8825ULL, 0x000fe200078e0008ULL, 0x0000000025257984ULL, 0x000e620000000800ULL,
0x0000000000407805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000800f088825ULL, 0x000fe200078e0008ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000101c0f7824ULL, 0x000fe400078e0207ULL,
0x0000001011067825ULL, 0x000fc800078e0002ULL, 0x000000101c027825ULL, 0x000fc800078e0002ULL,
0x000000101c088825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000020f7faeULL, 0x0007e6000b901c48ULL, 0x000000101c138824ULL, 0x040fe200078e0213ULL,
0x00380000060f7faeULL, 0x0007e2000b901c48ULL, 0x000000101c0c8825ULL, 0x000fc600078e000cULL,
0x0458000008138faeULL, 0x0007e2000b901c48ULL, 0x000000101c158824ULL, 0x000fca00078e0215ULL,
0x041800000c158faeULL, 0x0007e8000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800641947ULL, 0x000fea0003800000ULL, 0x00009600ff027b82ULL, 0x008ee20000000a00ULL,
0x00000003ff067819ULL, 0x000fe2000001161cULL, 0x000002000b4e7824ULL, 0x000fe200078e0222ULL,
0xfffffff8ff077812ULL, 0x000fe200078ee21cULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x0000000306067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000bULL,
0x00000002ff4d7819ULL, 0x000fe2000001161cULL, 0x0000000807097836ULL, 0x040fe20000000000ULL,
0x0000000406087812ULL, 0x000fe200078efcffULL, 0x0000000807487824ULL, 0x000fe200078e00ffULL,
0x0000000706477812ULL, 0x000fe200078e7807ULL, 0x00000008094c7824ULL, 0x000fe200078e00ffULL,
0x0000000706497812ULL, 0x000fe200078e7809ULL, 0x00000100054e7824ULL, 0x000fe200078e024eULL,
0x0000000708077812ULL, 0x000fe200078e7807ULL, 0x000000084d4a7836ULL, 0x000fe20000000000ULL,
0x0000000708097812ULL, 0x000fc400078e7809ULL, 0x0000004847477212ULL, 0x000fe400078efcffULL,
0x0000004c49497212ULL, 0x000fe400078efcffULL, 0x0000004807487212ULL, 0x000fe400078efcffULL,
0x0000004c094c7212ULL, 0x008fce00078efcffULL, 0x00000002114b7836ULL, 0x000fca0000000000ULL,
0x000000044b00720cULL, 0x000fda0003f06070ULL, 0x00000000008c0947ULL, 0x000fea0003800000ULL,
0x000000011e0e7824ULL, 0x000fe200078e024bULL, 0x000000071c00780cULL, 0x040fe20003f24070ULL,
0x000004004b087824ULL, 0x000fe400078e00ffULL, 0x000000201c197836ULL, 0x000fe20000000000ULL,
0x0000000e1f077211ULL, 0x000fe400078fa8ffULL, 0x0000080008097812ULL, 0x000fc600078ec0ffULL,
0x0000080007067825ULL, 0x000fc800078e0002ULL, 0x000002000b109824ULL, 0x140fe200078e0222ULL,
0x00000020060c7210ULL, 0x000fe20007f1e0ffULL, 0x000002000b089824ULL, 0x000fe200078e0222ULL,
0x00000001ff067819ULL, 0x000fe2000001164bULL, 0x00000100054e9824ULL, 0x000fe400078e0210ULL,
0x00000001210f9824ULL, 0x000fe200078e020eULL, 0x0000000106177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe400000e0607ULL, 0x000000010a097824ULL, 0x000fc400078e0209ULL,
0x0000008017159824ULL, 0x000fe400078e024eULL, 0x000000800e069825ULL, 0x000fc800078e0002ULL,
0x00000100054e9824ULL, 0x000fe400078e0208ULL, 0x000000800f0e9825ULL, 0x000fc800078e0002ULL,
0x000000101c137824ULL, 0x000fe400078e0209ULL, 0x0000008017179824ULL, 0x000fe400078e024eULL,
0x0000001019087825ULL, 0x000fc800078e000cULL, 0x000000101c0c7825ULL, 0x000fc800078e000cULL,
0x000000101c0e9825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c137faeULL, 0x0007e6000b901c48ULL, 0x000000101c159824ULL, 0x040fe200078e0215ULL,
0x0038000008137faeULL, 0x0007e2000b901c48ULL, 0x000000101c069825ULL, 0x000fc600078e0006ULL,
0x045800000e159faeULL, 0x0007e2000b901c48ULL, 0x000000101c179824ULL, 0x000fca00078e0217ULL,
0x0418000006179faeULL, 0x0007e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004011067824ULL, 0x008fca00078e00ffULL, 0x0000008006067812ULL, 0x000fc800078ec0ffULL,
0x0000004e23077210ULL, 0x000fe20007ffe006ULL, 0x0000040011067824ULL, 0x000fc800078e00ffULL,
0x0000000124087824ULL, 0x000fe200078e0207ULL, 0x0000080006077812ULL, 0x000fc800078ec0ffULL,
0x000001800a077810ULL, 0x000fe20007ffe007ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800008167984ULL, 0x000ee20000000800ULL, 0x0000001048107824ULL, 0x100fe400078e0207ULL,
0x00000010470c7824ULL, 0x100fe200078e0207ULL, 0x0045800008507984ULL, 0x000fe20000000800ULL,
0x0000001049147824ULL, 0x100fe400078e0207ULL, 0x000000104c187824ULL, 0x000fe200078e0207ULL,
0x000000001010783bULL, 0x000f280000000200ULL, 0x000000000c0c783bULL, 0x000f680000000200ULL,
0x000000001818783bULL, 0x000f620000000200ULL, 0x0000001625067221ULL, 0x00afc60000010100ULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x3fb8aa3b064f7820ULL, 0x000fe20000410000ULL,
0x30000011ff527230ULL, 0x010fca0000004100ULL, 0x0000004f004f7308ULL, 0x000ee20000000800ULL,
0x20000013ff517230ULL, 0x000fe40000004100ULL, 0x2000000cff067230ULL, 0x020fe40000004100ULL,
0x3000000cff077230ULL, 0x000fe40000004100ULL, 0x2000000eff0c7230ULL, 0x000fe40000004100ULL,
0x3000000eff097230ULL, 0x000fe40000004100ULL, 0x30000013ff547230ULL, 0x000fc40000004100ULL,
0x20000019ff597230ULL, 0x004fe40000004100ULL, 0x000000504f5a7220ULL, 0x008fe20000410000ULL,
0x20000011ff4f7230ULL, 0x000fe40000004100ULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x000000455a457221ULL, 0x000fe20000010000ULL, 0x00001f4d5a5c7589ULL, 0x000ea200000e0000ULL,
0x30000019ff587230ULL, 0x000fe40000004100ULL, 0x2000000dff087230ULL, 0x000fe20000004100ULL,
0x00001f4a5a5d7589ULL, 0x000ee200000e0000ULL, 0x2000000fff0e7230ULL, 0x000fc40000004100ULL,
0x20000010ff507230ULL, 0x000fe40000004100ULL, 0x20000018ff577230ULL, 0x000fe40000004100ULL,
0x2000001aff197230ULL, 0x000fe40000004100ULL, 0x20000016ff567230ULL, 0x002fe40000004100ULL,
0x30000016ff557230ULL, 0x000fe40000004100ULL, 0x20000014ff137230ULL, 0x000fc40000004100ULL,
0x20000015ff537230ULL, 0x000fe40000004100ULL, 0x20000017ff167230ULL, 0x000fe40000004100ULL,
0x2000001bff5b7230ULL, 0x000fe40000004100ULL, 0x0000005c11327223ULL, 0x084fe20000010032ULL,
0x000000ffff117224ULL, 0x000fe400078e004bULL, 0x0000005c06297223ULL, 0x000fe20000010029ULL,
0x3000000dff0d7230ULL, 0x000fc40000004100ULL, 0x0000005c07287223ULL, 0x000fe20000010028ULL,
0x3000000fff0f7230ULL, 0x000fe20000004100ULL, 0x000000041100720cULL, 0x000fe20003f06070ULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000005c08277223ULL, 0x080fe20000010027ULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000005c0d267223ULL, 0x080fe20000010026ULL,
0x30000014ff147230ULL, 0x000fe40000004100ULL, 0x0000005c0c417223ULL, 0x000fe20000010041ULL,
0x30000015ff157230ULL, 0x000fc40000004100ULL, 0x0000005c093e7223ULL, 0x080fe2000001003eULL,
0x30000017ff177230ULL, 0x000fe40000004100ULL, 0x0000005c0e3d7223ULL, 0x080fe2000001003dULL,
0x30000018ff187230ULL, 0x000fe40000004100ULL, 0x0000005c0f3a7223ULL, 0x080fe2000001003aULL,
0x3000001aff1a7230ULL, 0x000fe40000004100ULL, 0x0000005c50397223ULL, 0x000fe20000010039ULL,
0x3000001bff1b7230ULL, 0x000fc40000004100ULL, 0x0000005c10377223ULL, 0x080fe20000010037ULL,
0x0000005c4f367223ULL, 0x080fe20000010036ULL, 0x0000005c52337223ULL, 0x080fe20000010033ULL,
0x0000005c122f7223ULL, 0x080fe2000001002fULL, 0x0000005c512e7223ULL, 0x080fe2000001002eULL,
0x0000005c542b7223ULL, 0x000fe2000001002bULL, 0x0000005d132a7223ULL, 0x088fe2000001002aULL,
0x0000005d14437223ULL, 0x080fe20000010043ULL, 0x0000005d53427223ULL, 0x080fe20000010042ULL,
0x0000005d15407223ULL, 0x080fe20000010040ULL, 0x0000005d563f7223ULL, 0x080fe2000001003fULL,
0x0000005d553c7223ULL, 0x080fe2000001003cULL, 0x0000005d163b7223ULL, 0x080fe2000001003bULL,
0x0000005d17447223ULL, 0x080fe20000010044ULL, 0x0000005d57387223ULL, 0x080fe20000010038ULL,
0x0000005d18357223ULL, 0x080fe20000010035ULL, 0x0000005d59347223ULL, 0x080fe20000010034ULL,
0x0000005d58317223ULL, 0x080fe20000010031ULL, 0x0000005d19307223ULL, 0x080fe20000010030ULL,
0x0000005d1a2d7223ULL, 0x080fe2000001002dULL, 0x0000005d5b2c7223ULL, 0x080fe2000001002cULL,
0x0000005d1b467223ULL, 0x000fe20000010046ULL, 0xfffffff400f48947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x008ee20000000000ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x008fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe20000011602ULL,
0x0000498022027836ULL, 0x000fc60000000000ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000000204027210ULL, 0x000fe20007ffe003ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x000000800b227824ULL, 0x000fe400078e0222ULL, 0x0000001003047824ULL, 0x008fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011603ULL, 0x0000007004037812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000002206227210ULL, 0x000fca0007ffe003ULL,
0x0049804522007388ULL, 0x0007e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002037984ULL, 0x000f280000000800ULL, 0x0000800002047984ULL, 0x000f620000000800ULL,
0x00000003ff037221ULL, 0x010fc80000010000ULL, 0x0000000403037221ULL, 0x020fc80000010000ULL,
0x0180000003047836ULL, 0x000fca0000000000ULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0003ULL,
0x00009e0000097802ULL, 0x000fce0000000f00ULL, 0x0000005000947944ULL, 0x00efea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e000cULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000300027308ULL, 0x000f240000001000ULL, 0xbf80000003047423ULL, 0x010fc80000000002ULL,
0x800000ff04077221ULL, 0x000fc80000010100ULL, 0x0000000702027223ULL, 0x000fce0000000002ULL,
0x00000000001c7919ULL, 0x000f240000000000ULL, 0x00000002ff117819ULL, 0x110fe4000001161cULL,
0x000000081c097811ULL, 0x000fe400078ff0ffULL, 0x00000003ff067819ULL, 0x000fe2000001161cULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f1102047589ULL, 0x000f2200000e0000ULL,
0xfffffff8ff177812ULL, 0x000fc400078ee21cULL, 0x0000000306067812ULL, 0x000fe200078ec0ffULL,
0x00001f0902097589ULL, 0x000b6400000e0000ULL, 0x00000008171b7836ULL, 0x040fe20000000000ULL,
0x00000004060a7812ULL, 0x002fe200078efcffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000817087824ULL, 0x000fe200078e00ffULL, 0x0000000706197812ULL, 0x000fe200078e7817ULL,
0x000000081b147824ULL, 0x000fe200078e00ffULL, 0x00000007061f7812ULL, 0x000fe400078e781bULL,
0x000000070a177812ULL, 0x000fc400078e7817ULL, 0x000000070a1b7812ULL, 0x000fe400078e781bULL,
0x0000000819067212ULL, 0x000fe400078efcffULL, 0x000000141f0a7212ULL, 0x000fe400078efcffULL,
0x0000000817087212ULL, 0x000fe200078efcffULL, 0x0000001006067824ULL, 0x100fe400078e021dULL,
0x00000029040c7220ULL, 0x050fe20000410000ULL, 0x0000002804037220ULL, 0x040fe20000410000ULL,
0x00000027040d7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x00000041040e7220ULL, 0x040fe20000410000ULL, 0x0000003e04077220ULL, 0x040fe20000410000ULL,
0x0000003d040f7220ULL, 0x040fe20000410000ULL, 0x0000003a043a7220ULL, 0x040fe20000410000ULL,
0x0000003904107220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003604117220ULL, 0x040fe20000410000ULL, 0x0000003304027220ULL, 0x060fe20000410000ULL,
0x0000003204127220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002e04137220ULL, 0x040fe20000410000ULL, 0x0000002b04047220ULL, 0x000fe20000410000ULL,
0x000000141b147212ULL, 0x000fe200078efcffULL, 0x0000002a092a7220ULL, 0x048fe20000410000ULL,
0x0000004309437220ULL, 0x040fe20000410000ULL, 0x0000004209427220ULL, 0x040fe20000410000ULL,
0x0000004009157220ULL, 0x040fe20000410000ULL, 0x0000003f093f7220ULL, 0x040fe20000410000ULL,
0x0000003c093c7220ULL, 0x040fe20000410000ULL, 0x0000003b093b7220ULL, 0x040fe20000410000ULL,
0x0000004409447220ULL, 0x040fe20000410000ULL, 0x0000003809387220ULL, 0x040fe20000410000ULL,
0x0000003509357220ULL, 0x040fe20000410000ULL, 0x0000003409347220ULL, 0x040fe20000410000ULL,
0x0000003109317220ULL, 0x040fe20000410000ULL, 0x0000003009307220ULL, 0x040fe20000410000ULL,
0x0000002d092d7220ULL, 0x040fe20000410000ULL, 0x0000002c092c7220ULL, 0x040fe20000410000ULL,
0x0000004609097220ULL, 0x000fe20000410000ULL, 0x000000100a0a7824ULL, 0x100fe200078e021dULL,
0x0000000c030c723eULL, 0x000fe200000000ffULL, 0x0000001008087824ULL, 0x100fe200078e021dULL,
0x0000000d260d723eULL, 0x000fe200000000ffULL, 0x00000010141d7824ULL, 0x000fe200078e021dULL,
0x0000000e070e723eULL, 0x000fe200000000ffULL, 0x000000200b037824ULL, 0x000fe200078e021cULL,
0x0000000f3a0f723eULL, 0x000fc400000000ffULL, 0x000000103710723eULL, 0x000fe200000000ffULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x000000110211723eULL, 0x000fe200000000ffULL,
0x0000000c06007844ULL, 0x000fe20000000200ULL, 0x000000122f12723eULL, 0x000fe400000000ffULL,
0x000000130413723eULL, 0x000fe400000000ffULL, 0x0000002a4314723eULL, 0x000fe400000000ffULL,
0x000000421515723eULL, 0x000fe200000000ffULL, 0x0000001008007844ULL, 0x000fe20000000200ULL,
0x0000003f3c16723eULL, 0x000fc400000000ffULL, 0x0000003b4417723eULL, 0x000fe400000000ffULL,
0x000000383538723eULL, 0x000fe400000000ffULL, 0x000000343139723eULL, 0x000fe200000000ffULL,
0x000000140a007844ULL, 0x000fe20000000200ULL, 0x000000302d3a723eULL, 0x000fe400000000ffULL,
0x0000002c093b723eULL, 0x000fca00000000ffULL, 0x000000381d007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003187984ULL, 0x000e680000000c00ULL,
0x0004000003247984ULL, 0x000ee80000000c00ULL, 0x0008000003207984ULL, 0x000f280000000c00ULL,
0x000c000003287984ULL, 0x000f620000000c00ULL, 0x200000ff1b1b7230ULL, 0x002fc40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x000000231b1b7230ULL, 0x010fe40000000000ULL,
0x000000221a1a7230ULL, 0x000fe40000000000ULL, 0x0000002119197230ULL, 0x000fe40000000000ULL,
0x0000002018187230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x020fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001803007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002403007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000f220000002600ULL, 0x000000201c137836ULL, 0x008fe20000000000ULL,
0x00000003ff117819ULL, 0x000fe2000001161cULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000805107824ULL, 0x002fe200078e00ffULL,
0x00000003ff027819ULL, 0x000fe20000011613ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000711037812ULL, 0x000fe400078e481cULL, 0x0000000702047812ULL, 0x000fc400078e4813ULL,
0x0ffffff803037812ULL, 0x000fe400078ef81cULL, 0x0ffffff804077812ULL, 0x000fc600078ef813ULL,
0x0000001003037824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fc600078e0200ULL,
0x0000000003087984ULL, 0x000e680000000c00ULL, 0x00000000070c7984ULL, 0x000a620000000c00ULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x0000000806007824ULL, 0x050fe400078e00ffULL,
0x0000000806157824ULL, 0x000fc600078e00ffULL, 0xfffffff800007812ULL, 0x000fe400078ee211ULL,
0xfffffff815027812ULL, 0x000fe200078ee202ULL, 0x0000000805157824ULL, 0x000fe200078e00ffULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff815077812ULL, 0x020fe200078ee21cULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000406027c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000000400047c11ULL, 0x000fc4000f8240ffULL,
0x0000000506037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe400088f4411ULL,
0xfffffff810117812ULL, 0x000fe200078ee213ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d08ULL,
0x0000000c04007986ULL, 0x004fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009200ff107b82ULL, 0x000e620000000a00ULL, 0x000000010e067836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x00000008100a7981ULL, 0x002366000c1e9900ULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x000000020d0d7824ULL, 0x000fe400078e00ffULL,
0x000000400f077824ULL, 0x000fe400078e00ffULL, 0x00000001ff0b7424ULL, 0x000fc400078e00ffULL,
0x000001000e1d7824ULL, 0x000fe400078e0207ULL, 0x000000060d067e24ULL, 0x000fe2000f8e0212ULL,
0x00f6000b020879a7ULL, 0x0002a6000850003fULL, 0x0000000406277c24ULL, 0x000fe2000f8e021dULL,
0x00000004006c8947ULL, 0x000fec0003800000ULL, 0x00008a00ff107b82ULL, 0x002e620000000a00ULL,
0x00000002ff2a7819ULL, 0x100fe40000011600ULL, 0x000000300c297812ULL, 0x000fe400078ec0ffULL,
0x0000001d03167248ULL, 0x000fe20007fe0000ULL, 0x000000012a0d7824ULL, 0x040fe200078e0227ULL,
0x00000003ff1f7819ULL, 0x000fe20000011600ULL, 0x000000102a207836ULL, 0x040fe40000000000ULL,
0x000000082a1c7836ULL, 0x000fe20000000000ULL, 0x000000031f1f7812ULL, 0x000fe200078e4800ULL,
0x0000000127157824ULL, 0x000fc400078e0220ULL, 0x000000011c137824ULL, 0x000fe400078e0227ULL,
0x000000182a227836ULL, 0x000fe40000000000ULL, 0x00000001161d7824ULL, 0x000fe400078e0a1dULL,
0x0000000127177824ULL, 0x000fe400078e0222ULL, 0x000000202a247836ULL, 0x000fe20000000000ULL,
0x0000001d2000720cULL, 0x080fe20003fa6070ULL, 0x000000800d0c7825ULL, 0x002fe200078e0010ULL,
0x0000001d2200720cULL, 0x000fc40003f86070ULL, 0x0000001d2400720cULL, 0x000fe20003f66070ULL,
0x0000008015147825ULL, 0x000fe200078e0010ULL, 0x000000290c187210ULL, 0x000fc60007f1e0ffULL,
0x0000008013127825ULL, 0x000fc800078e0010ULL, 0x000000ffff197224ULL, 0x000fe200000e060dULL,
0x00000029140c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008017167825ULL, 0x000fe200078e0010ULL,
0x00000029121a7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0615ULL,
0x0000001d2a00720cULL, 0x000fe20003f06070ULL, 0x0000000127157824ULL, 0x000fe400078e0224ULL,
0x000000ffff1b7224ULL, 0x000fe200008e0613ULL, 0x0000002916127210ULL, 0x000fe20007f3e0ffULL,
0x000020000f167824ULL, 0x000fe400078e0202ULL, 0x0000008015147825ULL, 0x000fc800078e0010ULL,
0x000000ffff137224ULL, 0x000fe200008e0617ULL, 0x0ffffffc1f177812ULL, 0x000fe200078ef800ULL,
0x00001000161e7836ULL, 0x000fe20000000000ULL, 0x0000002914167210ULL, 0x000fe20007f5e0ffULL,
0x000000282a267836ULL, 0x000fe20000000000ULL, 0x0000001d1c00720cULL, 0x0c0fe20003f26070ULL,
0x000000041c1c7824ULL, 0x000fe400078e00ffULL, 0x0000001017217824ULL, 0x000fe400078e021eULL,
0x000000ffff177224ULL, 0x000fe200010e0615ULL, 0xfffffffc1c237812ULL, 0x000fe200078ee21fULL,
0x0000000127157824ULL, 0x000fe200078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0003e2000c101c48ULL, 0x000000302a287836ULL, 0x000fe20000000000ULL,
0x0000001d2600720cULL, 0x000fe20003f46070ULL, 0x0000008015147825ULL, 0x000fc800078e0010ULL,
0x0000001023237824ULL, 0x000fe200078e021eULL, 0x00000029141c7210ULL, 0x000fe20007fde0ffULL,
0x000000382a2a7836ULL, 0x000fe40000000000ULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x000000001a237faeULL, 0x0007e2000c901c48ULL, 0x0000001d2800720cULL, 0x080fe20003f26070ULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x0000001d2a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff1d7224ULL, 0x000fe200030e0615ULL, 0xfffffffc20197812ULL, 0x002fe200078ee21fULL,
0x0000000127157824ULL, 0x000fc400078e0228ULL, 0x0000000127277824ULL, 0x000fe400078e022aULL,
0x0000008015147825ULL, 0x000fe200078e0010ULL, 0xfffffffc221b7812ULL, 0x008fc600078ee21fULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x0000002914147210ULL, 0x000fe20007fde0ffULL,
0x0000000426267824ULL, 0x000fe400078e00ffULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0xfffffffc24217812ULL, 0x000fe200078ee21fULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc26237812ULL, 0x000fe200078ee21fULL, 0x0000008027107825ULL, 0x000fe200078e0010ULL,
0xfffffffc28257812ULL, 0x000fe400078ee21fULL, 0xfffffffc2a1f7812ULL, 0x000fe200078ee21fULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000002910107210ULL, 0x000fe20007fde0ffULL,
0x0000001019197824ULL, 0x000fc400078e021eULL, 0x000000101b1b7824ULL, 0x100fe400078e021eULL,
0x0000001021217824ULL, 0x100fe200078e021eULL, 0x000000000c197faeULL, 0x0003e2000e901c48ULL,
0x0000001023237824ULL, 0x100fe400078e021eULL, 0x0000001025257824ULL, 0x100fe200078e021eULL,
0x00000000121b7faeULL, 0x0003e2000e101c48ULL, 0x000000101f1f7824ULL, 0x000fe400078e021eULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000000016217faeULL, 0x0003e8000d901c48ULL,
0x000000001c237faeULL, 0x0003e8000d101c48ULL, 0x0000000014257faeULL, 0x0003e8000c901c48ULL,
0x00000000101f7faeULL, 0x0003e2000c101c48ULL, 0x00000004003c7947ULL, 0x000fea0003800000ULL,
0x00008a00ff107b82ULL, 0x002e620000000a00ULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x000020000f157824ULL, 0x000fe200078e0202ULL, 0x0000000800187811ULL, 0x040fe400078ff0ffULL,
0x00000010000d7811ULL, 0x040fe200078ff0ffULL, 0x00001000152d7836ULL, 0x000fe20000000000ULL,
0x0000001800127811ULL, 0x000fe400078ff0ffULL, 0x00000003131d7812ULL, 0x000fe200078e4800ULL,
0x0000000118137824ULL, 0x000fe200078e0227ULL, 0x0000002000147811ULL, 0x000fe200078ff0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000002800167811ULL, 0x040fe200078ff0ffULL,
0x000000040d1a7824ULL, 0x000fe200078e00ffULL, 0x00000030001c7811ULL, 0x000fe200078ff0ffULL,
0x00000004121e7824ULL, 0x000fe200078e00ffULL, 0x00000038001f7811ULL, 0x040fe200078ff0ffULL,
0x0000000127157824ULL, 0x040fe200078e020dULL, 0x0ffffffc1d217812ULL, 0x000fe200078ef800ULL,
0x0000000127177824ULL, 0x040fe200078e0212ULL, 0xfffffffc18127812ULL, 0x000fe200078ee21dULL,
0x0000000127197824ULL, 0x040fe200078e0214ULL, 0x00000027000d7211ULL, 0x000fe200078ff0ffULL,
0x0000000414207824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a147812ULL, 0x000fe200078ee21dULL,
0x00000001271b7824ULL, 0x000fe200078e0216ULL, 0x000000300c2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000416227824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e167812ULL, 0x000fe200078ee21dULL,
0x000000041c247824ULL, 0x000fe200078e00ffULL, 0xfffffffc20187812ULL, 0x000fe200078ee21dULL,
0x000000041f267824ULL, 0x000fe200078e00ffULL, 0xfffffffc221a7812ULL, 0x000fe200078ee21dULL,
0x00000001272b7824ULL, 0x000fe200078e021fULL, 0xfffffffc241e7812ULL, 0x000fe200078ee21dULL,
0x0000001021317824ULL, 0x100fe200078e022dULL, 0xfffffffc26207812ULL, 0x000fe200078ee21dULL,
0x00000010121f7824ULL, 0x000fc400078e022dULL, 0x000000800d0c7825ULL, 0x002fc800078e0010ULL,
0x0000001014217824ULL, 0x000fe200078e022dULL, 0x0000002f0c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000008013127825ULL, 0x000fc800078e0010ULL, 0x0000001016237824ULL, 0x000fe200078e022dULL,
0x0000002f12127210ULL, 0x000fe20007f3e0ffULL, 0x0000008015147825ULL, 0x000fc800078e0010ULL,
0x0000008017167825ULL, 0x000fe200078e0010ULL, 0x0000002f14147210ULL, 0x000fc60007f5e0ffULL,
0x00000001271d7824ULL, 0x000fe200078e021cULL, 0x0000002f16167210ULL, 0x000fe20007f7e0ffULL,
0x0000001018257824ULL, 0x100fe400078e022dULL, 0x000000101a277824ULL, 0x000fe400078e022dULL,
0x0000008019187825ULL, 0x000fc800078e0010ULL, 0x000000801b1a7825ULL, 0x000fc800078e0010ULL,
0x000000801d1c7825ULL, 0x000fc800078e0010ULL, 0x000000802b107825ULL, 0x000fc800078e0010ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000002f18187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000002f1a1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x0000002f1c1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x0000002f10107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c317faeULL, 0x0003e2000b901c48ULL, 0x000000ffff1b7224ULL, 0x000fc400008e061bULL,
0x000000101e297824ULL, 0x000fe200078e022dULL, 0x00000000121f7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff1d7224ULL, 0x000fe400010e061dULL, 0x00000010202d7824ULL, 0x000fe200078e022dULL,
0x0000000014217faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc600018e0611ULL,
0x0000000016237faeULL, 0x0003e8000b901c48ULL, 0x0000000018257faeULL, 0x0003e8000b901c48ULL,
0x000000001a277faeULL, 0x0003e8000b901c48ULL, 0x000000001c297faeULL, 0x0003e8000b901c48ULL,
0x00000000102d7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00f60009020075a7ULL, 0x004ea2000800017fULL, 0x000000200f0c7824ULL, 0x002fc800078e0200ULL,
0x000000100c107824ULL, 0x000fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x000fc8000001160cULL,
0x1ffffffe0d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000f010107812ULL, 0x000fe400078ec0ffULL,
0x000000010d117812ULL, 0x000fe400078efcffULL, 0x000000070d0d7812ULL, 0x000fe400078e780cULL,
0x0000000711117812ULL, 0x000fc600078e780cULL, 0x000000010d0d7824ULL, 0x000fe400078e0210ULL,
0x0000000110117824ULL, 0x000fe400078e0211ULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x00000034008c8947ULL, 0x004fec0003800000ULL, 0x0000001011117824ULL, 0x000fe200078e0202ULL,
0x000000000d187984ULL, 0x000e620000000c00ULL, 0x000000050e00720cULL, 0x000fc60003f26070ULL,
0x0000000011147984ULL, 0x000ea20000000c00ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x000000ffff1e7224ULL, 0x004fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0016ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0017ULL, 0x0000001c0d007388ULL, 0x0003e80000000c00ULL,
0x0000001811007388ULL, 0x0003e20000000c00ULL, 0x00f6000b020879a7ULL, 0x000ea4000850003fULL,
0x00f60009020075a7ULL, 0x004ea4000800017fULL, 0x0000003400608947ULL, 0x006fea0003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x3db504f30a087820ULL, 0x020fe20000410000ULL,
0x000000080f097824ULL, 0x100fe400078e0202ULL, 0xffffffff050b7836ULL, 0x000fe40000000000ULL,
0x000000200f0a7824ULL, 0x000fe400078e0202ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000001000e3c7824ULL, 0x000fca00078e0207ULL, 0x0000003c0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fce000001ff00ULL, 0x000000010d117836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff427224ULL, 0x000fe400078e000dULL,
0x000000ffff0d7224ULL, 0x100fe200078e0011ULL, 0x00000001ff137819ULL, 0x000fe40000011611ULL,
0x000000021100780cULL, 0x040fe40003f06070ULL, 0x0000000111147812ULL, 0x000fe200078ec0ffULL,
0x00000004130c7224ULL, 0x000fc800078e020eULL, 0x000000010c127836ULL, 0x040fe40000000000ULL,
0x000001000c1e7824ULL, 0x000fe200078e0207ULL, 0x00000001100c7812ULL, 0x000fe400078e0cffULL,
0x000000051200720cULL, 0x000fe20003f26070ULL, 0x0000000406157c24ULL, 0x000fd8000f8e021eULL,
0x0000000400589947ULL, 0x000fea0003800000ULL, 0x00008a00ff127b82ULL, 0x000e620000000a00ULL,
0x0000001e03117248ULL, 0x000fe20007fe0000ULL, 0x0000000414177824ULL, 0x000fe200078e00ffULL,
0x00000002ff3e7819ULL, 0x100fe40000011600ULL, 0x00000003ff417819ULL, 0x000fe20000011600ULL,
0x00000001111e7824ULL, 0x000fe200078e0a1eULL, 0xfffffffc17147812ULL, 0x000fe200078ee200ULL,
0x000020000f117824ULL, 0x000fe200078e0202ULL, 0x0000000041167212ULL, 0x000fe200078e3cffULL,
0x000000083e1f7836ULL, 0x040fe20000000000ULL, 0x0000001e3e00720cULL, 0x080fe20003f26070ULL,
0x000010000c1c7824ULL, 0x000fe200078e0211ULL, 0x0000000316437812ULL, 0x000fe200078ec0ffULL,
0x000000013e177824ULL, 0x100fe200078e0215ULL, 0x0000001e1f00720cULL, 0x040fe20003f46070ULL,
0x000000041f447824ULL, 0x040fe200078e00ffULL, 0x0ffffffc43407812ULL, 0x000fe200078ef800ULL,
0x000000011f1d7824ULL, 0x000fc400078e0215ULL, 0x000010001c1f7836ULL, 0x000fe20000000000ULL,
0xfffffffc44447812ULL, 0x000fe200078ee243ULL, 0x000000203e457836ULL, 0x000fe40000000000ULL,
0x0000008017167825ULL, 0x002fc600078e0012ULL, 0x0000001e4500720cULL, 0x000fe20003f66070ULL,
0x000000801d1c7825ULL, 0x000fc800078e0012ULL, 0x0000001014167825ULL, 0x000fc800078e0016ULL,
0x00000010403d7824ULL, 0x100fe400078e021fULL, 0x00000010443f7824ULL, 0x000fe400078e021fULL,
0x00000010141c7825ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163d7faeULL, 0x0003e6000c901c48ULL, 0x000000103e407836ULL, 0x040fe20000000000ULL,
0x000000001c3f7faeULL, 0x0005e2000d101c48ULL, 0x000000183e447836ULL, 0x000fc40000000000ULL,
0x000000283e467836ULL, 0x000fe20000000000ULL, 0x0000001e4000720cULL, 0x080fe20003f26070ULL,
0x000000303e477836ULL, 0x000fe20000000000ULL, 0x0000001e4400720cULL, 0x080fe20003f46070ULL,
0x000000383e3e7836ULL, 0x000fe20000000000ULL, 0x0000001e4600720cULL, 0x080fe20003f86070ULL,
0x0000000440167824ULL, 0x042fe200078e00ffULL, 0x0000001e4700720cULL, 0x080fe20003fa6070ULL,
0x0000000140177824ULL, 0x100fe200078e0215ULL, 0x0000001e3e00720cULL, 0x000fe20003fc6070ULL,
0x00000001453f7824ULL, 0x044fe200078e0215ULL, 0xfffffffc16167812ULL, 0x000fe200078ee243ULL,
0x00000004451e7824ULL, 0x000fc400078e00ffULL, 0x00000001441d7824ULL, 0x140fe400078e0215ULL,
0x00000004441c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee243ULL,
0x0000000146457824ULL, 0x040fe400078e0215ULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee243ULL, 0x0000000447407824ULL, 0x000fe400078e00ffULL,
0x000000043e447824ULL, 0x000fc400078e00ffULL, 0x000000013e4d7824ULL, 0x100fe200078e0215ULL,
0xfffffffc463e7812ULL, 0x000fe200078ee243ULL, 0x0000000147497824ULL, 0x000fe200078e0215ULL,
0xfffffffc40407812ULL, 0x000fe200078ee243ULL, 0x0000001016157824ULL, 0x100fe200078e021fULL,
0xfffffffc44447812ULL, 0x000fe200078ee243ULL, 0x000000101c3d7824ULL, 0x000fe400078e021fULL,
0x0000008017167825ULL, 0x000fc800078e0012ULL, 0x000000101e437824ULL, 0x100fe400078e021fULL,
0x000000103e477824ULL, 0x100fe400078e021fULL, 0x00000010404b7824ULL, 0x100fe400078e021fULL,
0x00000010444f7824ULL, 0x000fe400078e021fULL, 0x000000801d1c7825ULL, 0x000fc800078e0012ULL,
0x000000803f1e7825ULL, 0x000fc800078e0012ULL, 0x00000080453e7825ULL, 0x000fc800078e0012ULL,
0x0000008049447825ULL, 0x000fc800078e0012ULL, 0x000000804d127825ULL, 0x000fc800078e0012ULL,
0x0000001014167825ULL, 0x000fc800078e0016ULL, 0x00000010141c7825ULL, 0x040fe200078e001cULL,
0x0000000016157faeULL, 0x0003e6000c901c48ULL, 0x00000010141e7825ULL, 0x040fe200078e001eULL,
0x000000001c3d7faeULL, 0x0003e6000d101c48ULL, 0x00000010143e7825ULL, 0x040fe200078e003eULL,
0x000000001e437faeULL, 0x0003e6000d901c48ULL, 0x0000001014447825ULL, 0x040fe200078e0044ULL,
0x000000003e477faeULL, 0x0003e6000e101c48ULL, 0x0000001014127825ULL, 0x000fe200078e0012ULL,
0x00000000444b7faeULL, 0x0003e8000e901c48ULL, 0x00000000124f7faeULL, 0x0003e2000f101c48ULL,
0x0000000400287947ULL, 0x000fea0003800000ULL, 0x0000000414597824ULL, 0x000fe200078e00ffULL,
0x0000000800147811ULL, 0x040fe200078ff0ffULL, 0x00008a00ff127b82ULL, 0x000e620000000a00ULL,
0x00000003ff417819ULL, 0x000fe20000011600ULL, 0x000020000f117824ULL, 0x000fe200078e0202ULL,
0x00000018001c7811ULL, 0x000fe200078ff0ffULL, 0x0000000114177824ULL, 0x100fe200078e0215ULL,
0x00000020001e7811ULL, 0x000fe200078ff0ffULL, 0x0000000414467824ULL, 0x000fe200078e00ffULL,
0x00000028003e7811ULL, 0x000fe200078ff0ffULL, 0x000000011c1f7824ULL, 0x100fe200078e0215ULL,
0x0000001000167811ULL, 0x000fe200078ff0ffULL, 0x000000011e3f7824ULL, 0x100fe200078e0215ULL,
0x0000003000407811ULL, 0x000fe200078ff0ffULL, 0x000000013e457824ULL, 0x000fe200078e0215ULL,
0x0000003800447811ULL, 0x000fe200078ff0ffULL, 0x0000000416487824ULL, 0x000fe200078e00ffULL,
0x0000000041147212ULL, 0x000fe200078e3cffULL, 0x000000041c1c7824ULL, 0x000fc400078e00ffULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x00000003143d7812ULL, 0x000fe200078ec0ffULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x0000000440147824ULL, 0x000fe200078e00ffULL,
0xfffffffc46437812ULL, 0x000fe200078ee23dULL, 0x00000004444a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc48497812ULL, 0x000fe200078ee23dULL, 0x00000001161d7824ULL, 0x000fe200078e0215ULL,
0xfffffffc1c4b7812ULL, 0x000fe200078ee23dULL, 0x000010000c167824ULL, 0x000fe200078e0211ULL,
0xfffffffc1e4d7812ULL, 0x000fe200078ee23dULL, 0x0000000140477824ULL, 0x100fe200078e0215ULL,
0xfffffffc3e4f7812ULL, 0x000fe200078ee23dULL, 0x0000100016167836ULL, 0x000fe20000000000ULL,
0xfffffffc14537812ULL, 0x000fe200078ee23dULL, 0x0000000144517824ULL, 0x000fe200078e0215ULL,
0xfffffffc4a557812ULL, 0x000fe200078ee23dULL, 0x000000801d1c7825ULL, 0x002fe200078e0012ULL,
0x0ffffffc3d3d7812ULL, 0x000fc400078ef800ULL, 0x0000001500157211ULL, 0x000fe200078ff0ffULL,
0x000000801f1e7825ULL, 0x000fc800078e0012ULL, 0x000000103d577824ULL, 0x100fe400078e0216ULL,
0x00000010433d7824ULL, 0x100fe400078e0216ULL, 0x0000001049437824ULL, 0x100fe400078e0216ULL,
0x000000104b497824ULL, 0x100fe400078e0216ULL, 0x000000104d4b7824ULL, 0x100fe400078e0216ULL,
0x000000104f4d7824ULL, 0x000fc400078e0216ULL, 0x00000010534f7824ULL, 0x100fe400078e0216ULL,
0x0000001055537824ULL, 0x000fe200078e0216ULL, 0xfffffffc59557812ULL, 0x000fe200078ee200ULL,
0x0000008015147825ULL, 0x000fc800078e0012ULL, 0x0000008017167825ULL, 0x000fc800078e0012ULL,
0x000000803f3e7825ULL, 0x000fc800078e0012ULL, 0x0000008045447825ULL, 0x000fc800078e0012ULL,
0x0000008047467825ULL, 0x000fc800078e0012ULL, 0x0000001055147825ULL, 0x000fc800078e0014ULL,
0x0000008051127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e6000b901c48ULL, 0x0000001055167825ULL, 0x000fc800078e0016ULL,
0x00000010551c7825ULL, 0x040fe200078e001cULL, 0x00000000163d7faeULL, 0x0003e6000b901c48ULL,
0x00000010551e7825ULL, 0x040fe200078e001eULL, 0x000000001c437faeULL, 0x0003e6000b901c48ULL,
0x00000010553e7825ULL, 0x040fe200078e003eULL, 0x000000001e497faeULL, 0x0003e6000b901c48ULL,
0x0000001055447825ULL, 0x040fe200078e0044ULL, 0x000000003e4b7faeULL, 0x0003e6000b901c48ULL,
0x0000001055467825ULL, 0x040fe200078e0046ULL, 0x00000000444d7faeULL, 0x0003e6000b901c48ULL,
0x0000001055127825ULL, 0x000fe200078e0012ULL, 0x00000000464f7faeULL, 0x0003e8000b901c48ULL,
0x0000000012537faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000137836ULL, 0x042fe20000000000ULL, 0xfffffff800437812ULL, 0x000fe200078ec0ffULL,
0x0000100010407824ULL, 0x000fe200078e0211ULL, 0x0000000700457812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ec0ffULL,
0x0000100040407836ULL, 0x000fe20000000000ULL, 0x0000000743437812ULL, 0x000fe400078ef800ULL,
0x0000000713447812ULL, 0x000fc400078ef800ULL, 0x00000001ff3e7819ULL, 0x000fe40000011643ULL,
0x00000001ff467819ULL, 0x000fe40000011644ULL, 0x00000008453f7812ULL, 0x000fe400078ef800ULL,
0x000000033e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000000346467812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x0000003d3e107212ULL, 0x080fe200078e3cffULL,
0x000000013d497836ULL, 0x000fe20000000000ULL, 0x0000003d46157212ULL, 0x000fe200078e3cffULL,
0x0000000442777824ULL, 0x000fe400078e023dULL, 0x0000000443117824ULL, 0x000fe400078e0210ULL,
0x0000000444157824ULL, 0x000fe400078e0215ULL, 0x0000001011117824ULL, 0x100fe400078e0240ULL,
0x0000001015157824ULL, 0x000fc400078e0240ULL, 0x0000000277777824ULL, 0x000fe400078e00ffULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x000000023d3d7836ULL, 0x000fc60000000000ULL,
0x000000001514783bULL, 0x000ea40000000200ULL, 0x000000043d00780cULL, 0x000fe40003f25270ULL,
0x00000018ff567819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x00008880105a7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115d7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff637819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880125e7816ULL, 0x000fe400000000ffULL, 0x00000018ff677819ULL, 0x000fe20000011413ULL,
0x00000010005f7306ULL, 0x0002e20000200c00ULL, 0x0000888013727816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff687819ULL, 0x004fe20000011414ULL, 0x00000011005c7306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146e7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c00797306ULL, 0x000fe20000200c00ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00008880156c7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200747306ULL, 0x0003e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011416ULL,
0x00000018ff477819ULL, 0x000fe40000011417ULL, 0x0000888016667816ULL, 0x000fe400000000ffULL,
0x0000888017617816ULL, 0x000fe200000000ffULL, 0x0000001300707306ULL, 0x0005e20000200c00ULL,
0x000000493e127212ULL, 0x002fc400078e3cffULL, 0x0000004946497212ULL, 0x000fca00078e3cffULL,
0x0000001d00607306ULL, 0x0003e20000200c00ULL, 0x0000000443137824ULL, 0x004fe400078e0212ULL,
0x0000000444497824ULL, 0x000fe400078e0249ULL, 0x0000001013137824ULL, 0x100fe400078e0240ULL,
0x0000001049127824ULL, 0x000fe200078e0240ULL, 0x0000001000757306ULL, 0x0005e40000200c00ULL,
0x00000000131c783bULL, 0x002e6c0000000200ULL, 0x0000001100737306ULL, 0x0009e20000200c00ULL,
0x0001000014107824ULL, 0x004fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000015117824ULL, 0x050fe200078e00ffULL, 0x0000001000717306ULL, 0x0005e20000200c00ULL,
0x0000010015157824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000014006f7306ULL, 0x0009e20000200c00ULL,
0x0001000016107824ULL, 0x044fe400078e00ffULL, 0x0000010016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011410ULL, 0x00000015006a7306ULL, 0x000fe20000200c00ULL,
0x0001000017147824ULL, 0x050fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000001600697306ULL, 0x000fe20000200c00ULL,
0x00000018ff487819ULL, 0x002fe4000001141cULL, 0x000088801c4a7816ULL, 0x000fe400000000ffULL,
0x00000018ff507819ULL, 0x000fe4000001141dULL, 0x000088801d517816ULL, 0x000fe200000000ffULL,
0x0000001400647306ULL, 0x0003e20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fc4000001141eULL,
0x000088801e527816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fc6000001141fULL,
0x0000001700627306ULL, 0x000fe20000200c00ULL, 0x000100001c147824ULL, 0x042fe400078e00ffULL,
0x000001001c1c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011414ULL,
0x0000007700147211ULL, 0x000fe200078fe0ffULL, 0x00000011006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000000277777836ULL, 0x000fe20000000000ULL,
0x0000000714147812ULL, 0x000fca00078e783fULL, 0x000000103f157824ULL, 0x000fe200078e0214ULL,
0x000000001210783bULL, 0x002e620000000200ULL, 0x000100001d147824ULL, 0x000fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000001015157824ULL, 0x000fe400078e0202ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc60000011414ULL,
0x000000001514783bULL, 0x000f220000000200ULL, 0x0000001c00557306ULL, 0x000be20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fce000001141dULL, 0x0000001d00577306ULL, 0x0007e20000200c00ULL,
0x000100001e1c7824ULL, 0x060fe400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000054105f1d7816ULL, 0x008fe40000000056ULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x0000001c00597306ULL, 0x0005e20000200c00ULL, 0x00000018ff4d7819ULL, 0x002fce0000011410ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000054105a1c7816ULL, 0x004fe40000000079ULL,
0x000088801f5a7816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011411ULL,
0x00000018ff4b7819ULL, 0x000fe20000011412ULL, 0x0000001c1438723cULL, 0x010fe20000001838ULL,
0x0000001e00567306ULL, 0x0005e20000200c00ULL, 0x00000018ff497819ULL, 0x000fca0000011413ULL,
0x000100001f1d7824ULL, 0x000fe200078e00ffULL, 0x000054105d1c7816ULL, 0x002fe20000000060ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00008880101e7816ULL, 0x044fe200000000ffULL,
0x0000010010607824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000001d005f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fce000001141fULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105c1d7816ULL, 0x002fe2000000005bULL,
0x00010000105c7824ULL, 0x000fe200078e00ffULL, 0x0000007700107211ULL, 0x000fc800078fe0ffULL,
0x0000000710107812ULL, 0x000fe200078e783fULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000001c1434723cULL, 0x000fe20000001834ULL, 0x00000018ff5c7819ULL, 0x000fcc000001145cULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x00008880111c7816ULL, 0x000fe200000000ffULL,
0x000000103f1d7824ULL, 0x000fc800078e0210ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0x000054105e1c7816ULL, 0x004fe20000000075ULL, 0x0000001e005b7306ULL, 0x0005f00000200c00ULL,
0x0000006e006e7306ULL, 0x000f220000200c00ULL, 0x000000101d1e7824ULL, 0x004fe200078e0202ULL,
0x00005410741d7816ULL, 0x000fe20000000063ULL, 0x0000010011747824ULL, 0x000fca00078e00ffULL,
0x0000001f005d7306ULL, 0x0005e20000200c00ULL, 0x0000001c1430723cULL, 0x000fee0000001830ULL,
0x0000006800687306ULL, 0x000f620000200c00ULL, 0x00010000111f7824ULL, 0x004fe200078e00ffULL,
0x0000541070117816ULL, 0x002fc40000000067ULL, 0x00000018ff677819ULL, 0x000fe40000011474ULL,
0x00000018ff637819ULL, 0x000fe4000001141fULL, 0x00000010005e7306ULL, 0x0007e20000200c00ULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000541072107816ULL, 0x008fce0000000073ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00000010142c723cULL, 0x000fee000000182cULL, 0x0000888012117816ULL, 0x000fe200000000ffULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000054106e107816ULL, 0x010fc60000000071ULL,
0x000000ffff6e7224ULL, 0x000fe200078e0011ULL, 0x000054106f117816ULL, 0x020fe20000000068ULL,
0x00010000126f7824ULL, 0x040fe400078e00ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000010012127824ULL, 0x000fc600078e00ffULL, 0x000000101428723cULL, 0x000fe40000001828ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000006b006b7306ULL, 0x000ee60000200c00ULL,
0x000054106c107816ULL, 0x004fe4000000006dULL, 0x000054106a117816ULL, 0x000fe40000000065ULL,
0x00000018ff657819ULL, 0x000fe2000001146fULL, 0x0000004700477306ULL, 0x000fe80000200c00ULL,
0x000000101424723cULL, 0x000fe80000001824ULL, 0x0000006100617306ULL, 0x000ea60000200c00ULL,
0x0000541066107816ULL, 0x008fc4000000006bULL, 0x0000541069117816ULL, 0x000fe40000000058ULL,
0x0000888013587816ULL, 0x000fe200000000ffULL, 0x0000004800487306ULL, 0x000fe80000200c00ULL,
0x000000101420723cULL, 0x000fe80000001820ULL, 0x0000004a004a7306ULL, 0x000fe60000200c00ULL,
0x0000541061107816ULL, 0x004fc40000000064ULL, 0x0000541062117816ULL, 0x000fe20000000047ULL,
0x000000ffff477224ULL, 0x000fe400078e0058ULL, 0x0000005300537306ULL, 0x000ea80000200c00ULL,
0x000000101418723cULL, 0x000fe80000001818ULL, 0x0000004e004e7306ULL, 0x000ee60000200c00ULL,
0x0001000013117824ULL, 0x000fc400078e00ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x000054104a107816ULL, 0x004fe40000000053ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541055117816ULL, 0x000fe40000000048ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x000054105d177816ULL, 0x008fe2000000004eULL,
0x0000005000507306ULL, 0x000ee40000200c00ULL, 0x000000101c38723cULL, 0x002fe20000001838ULL,
0x000054105a167816ULL, 0x004fca000000005fULL, 0x0000004f004f7306ULL, 0x000e640000200c00ULL,
0x000000161c2c723cULL, 0x000fe2000000182cULL, 0x0000541057557816ULL, 0x008fca0000000050ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541056537816ULL, 0x002fce000000004fULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x0000541051547816ULL, 0x002fce0000000054ULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x000000541c34723cULL, 0x000fe20000001834ULL, 0x0000541052527816ULL, 0x004fcc0000000059ULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x000000521c30723cULL, 0x000fe20000001830ULL,
0x000054105b5c7816ULL, 0x002fcc000000005cULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x00005410605d7816ULL, 0x004fce000000004dULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000005c1c28723cULL, 0x000fe20000001828ULL, 0x000054105e5e7816ULL, 0x002fcc0000000063ULL,
0x0000006e00687306ULL, 0x000fe20000200c00ULL, 0x00005410675f7816ULL, 0x004fce000000004cULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0000005e1c24723cULL, 0x000fee0000001824ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x00005410684a7816ULL, 0x002fce0000000065ULL,
0x0000004700147306ULL, 0x000fe20000200c00ULL, 0x00005410124b7816ULL, 0x004fce000000004bULL,
0x0000001500117306ULL, 0x000e620000200c00ULL, 0x0000004a1c20723cULL, 0x000fee0000001820ULL,
0x0000001300107306ULL, 0x000ea20000200c00ULL, 0x0000541014147816ULL, 0x002fe40000000011ULL,
0x0000541010157816ULL, 0x004fce0000000049ULL, 0x000000141c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c1947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0xffffffe4002c8947ULL, 0x000fec000383ffffULL,
0x00000001ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000000824147220ULL, 0x080fe20000410000ULL,
0x0000000400127824ULL, 0x000fe400078e00ffULL, 0x0000000820167220ULL, 0x080fe20000410000ULL,
0x00f6880d091079a7ULL, 0x000e62000850003fULL, 0x000000800f137824ULL, 0x000fe400078e0202ULL,
0x0000000821177220ULL, 0x080fe20000410000ULL, 0xfffffff012127812ULL, 0x000fe200078ec0ffULL,
0x0000000838157220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x000000083a3a7220ULL, 0x080fe20000410000ULL, 0x000000083b3b7220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000836367220ULL, 0x080fe20000410000ULL, 0x0000000837377220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x0000000833337220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x00f68811090075a7ULL, 0x002e62000800017fULL, 0x0000000825257220ULL, 0x080fe20000410000ULL,
0x0000000826267220ULL, 0x080fe20000410000ULL, 0x0000000827277220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000823237220ULL, 0x000fe20000410000ULL,
0x0000000113207824ULL, 0x000fc400078e0212ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081a217220ULL, 0x080fe20000410000ULL,
0x000000081b247220ULL, 0x000fe20000410000ULL, 0x0000001400988947ULL, 0x002fec0003800000ULL,
0x00f4000020107984ULL, 0x0002a20000000c00ULL, 0x0000000b0e00720cULL, 0x000fda0003f05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x00000002001a7824ULL, 0x000fe400078e00ffULL,
0x00000001033c7824ULL, 0x000fc600078e0a3cULL, 0x000000061a1b7812ULL, 0x000fc800078ec0ffULL,
0x000000011b1d7812ULL, 0x040fe400078efcffULL, 0x000000081b1f7812ULL, 0x000fe400078efcffULL,
0x0000003c1d00720cULL, 0x080fe40003f26070ULL, 0x000000101b1d7812ULL, 0x000fe400078efcffULL,
0x0000003c1f00720cULL, 0x080fe40003f06070ULL, 0x0000003c1d00720cULL, 0x000fc40003fc6070ULL,
0x000000111b1f7812ULL, 0x040fe400078efcffULL, 0x000000181b1d7812ULL, 0x040fe400078efcffULL,
0x0000003c1b00720cULL, 0x080fe40003f46070ULL, 0x0000003c1f00720cULL, 0x080fe40003fa6070ULL,
0x0000003c1d00720cULL, 0x000fe40003f66070ULL, 0x000000091b3d7812ULL, 0x000fc400078efcffULL,
0x000000191b1f7812ULL, 0x040fe400078efcffULL, 0x000000201b1d7812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x0000003c3d00720cULL, 0x080fe40003f86070ULL, 0x0000003c1f00720cULL, 0x080fe40003f46070ULL,
0x0000003c1d00720cULL, 0x000fe40003f26070ULL, 0x000000211b1f7812ULL, 0x040fe400078efcffULL,
0x000000281b1d7812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x0000003c1f00720cULL, 0x080fe40003f06070ULL,
0x0000003c1d00720cULL, 0x000fe40003f86070ULL, 0x000000291b1f7812ULL, 0x000fc400078efcffULL,
0x000000301b1d7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x0000003c1f00720cULL, 0x000fc40003fc6070ULL,
0x0000003c1d00720cULL, 0x000fe40003fa6070ULL, 0x000000311b1f7812ULL, 0x040fe400078efcffULL,
0x000000381b1d7812ULL, 0x040fe400078efcffULL, 0x000000391b1b7812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fe40004800000ULL,
0x0000003c1f00720cULL, 0x080fe40003f66070ULL, 0x0000003c1d00720cULL, 0x000fc40003f46070ULL,
0x0000003c1b00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff21217808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x0000001510107209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000003a111a7209ULL, 0x000fe40007810000ULL,
0x0000003910117209ULL, 0x000fe40007810000ULL, 0x0000003b1a1b7209ULL, 0x000fe40007810000ULL,
0x0000003411107209ULL, 0x000fe40007810000ULL, 0x000000361b1a7209ULL, 0x000fc40007810000ULL,
0x0000003510117209ULL, 0x000fe40007810000ULL, 0x000000371a1b7209ULL, 0x000fe40007810000ULL,
0x0000003011107209ULL, 0x000fe40007810000ULL, 0x000000321b1a7209ULL, 0x000fe40007810000ULL,
0x0000003110117209ULL, 0x000fe40007810000ULL, 0x000000331a1b7209ULL, 0x000fc40007810000ULL,
0x0000002c11107209ULL, 0x000fe40007810000ULL, 0x0000002e1b1a7209ULL, 0x000fe40007810000ULL,
0x0000002d10117209ULL, 0x000fe40007810000ULL, 0x0000002f1a1b7209ULL, 0x000fe40007810000ULL,
0x0000002811107209ULL, 0x000fe40007810000ULL, 0x0000002a1b1a7209ULL, 0x000fc40007810000ULL,
0x0000002910117209ULL, 0x000fe40007810000ULL, 0x0000002b1a1b7209ULL, 0x000fe40007810000ULL,
0x0000001411107209ULL, 0x000fe40007810000ULL, 0x000000261b1a7209ULL, 0x000fe40007810000ULL,
0x0000002510117209ULL, 0x000fe40007810000ULL, 0x000000271a1b7209ULL, 0x000fc40007810000ULL,
0x0000001611107209ULL, 0x000fe40007810000ULL, 0x000000221b1a7209ULL, 0x000fe40007810000ULL,
0x0000001710117209ULL, 0x000fe40007810000ULL, 0x000000231a1a7209ULL, 0x000fe40007810000ULL,
0x0000001811107209ULL, 0x000fe40007810000ULL, 0x000000211a117209ULL, 0x000fc40007810000ULL,
0x0000001910107209ULL, 0x000fe40007810000ULL, 0x0000002411117209ULL, 0x000fe20007810000ULL,
0x0000001204147947ULL, 0x000fec000b800000ULL, 0x0c401f00101b7f89ULL, 0x000e6800000e0000ULL,
0x0c401f00111a7f89ULL, 0x000ea800000e0000ULL, 0x0c401f00121d7f89ULL, 0x000ee800000e0000ULL,
0x0c401f0013387f89ULL, 0x000f2200000e0000ULL, 0x0000001b101b7209ULL, 0x002fc40007810000ULL,
0x0000001a111a7209ULL, 0x004fc60007810000ULL, 0x0c201f001b1c7f89ULL, 0x000e6200000e0000ULL,
0x0000001d121d7209ULL, 0x008fc60007810000ULL, 0x0c201f001a1f7f89ULL, 0x000ea200000e0000ULL,
0x0000003813387209ULL, 0x010fc60007810000ULL, 0x0c201f001d1e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f00383d7f89ULL, 0x00092200000e0000ULL, 0x0000001c1b107209ULL, 0x002fe40007810000ULL,
0x0000001f1a117209ULL, 0x004fe40007810000ULL, 0x0000001e1d127209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b101a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b11447820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b18187823ULL, 0x000fe2000001081aULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010844ULL, 0x3fb8aa3b39397823ULL, 0x000fe2000001081aULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010844ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081aULL,
0x00000039001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x000fe2000001081aULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe20000010844ULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001081aULL,
0x0000001700407308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b21217823ULL, 0x000fc40000010844ULL, 0x0000001800427308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000003600177308ULL, 0x000ff00000000800ULL, 0x0000003700187308ULL, 0x000e700000000800ULL,
0x00000014003e7308ULL, 0x0005e20000000800ULL, 0x000000171817723eULL, 0x002fce00000000ffULL,
0x0000002c001e7308ULL, 0x0003e20000000800ULL, 0x000000151c14723eULL, 0x004fe400000000ffULL,
0x0000003a3b15723eULL, 0x000fca00000000ffULL, 0x0000002d00137308ULL, 0x0004e20000000800ULL,
0x3c003c00ff2c7424ULL, 0x002fce00078e00ffULL, 0x00000016003f7308ULL, 0x0003620000000800ULL,
0x3c003c00ff2d7424ULL, 0x004fe200078e00ffULL, 0x0000001e131e723eULL, 0x008fcc00000000ffULL,
0x0000001900437308ULL, 0x0005e20000000800ULL, 0x000000343516723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b2b347823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b24447823ULL, 0x000fe20000010844ULL,
0xfffffffc00137812ULL, 0x000fe400078ec0ffULL, 0x0000003f4024723eULL, 0x020fe400000000ffULL,
0x0000002800397308ULL, 0x000fe20000000800ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002c1418723cULL, 0x004fe400000018ffULL, 0x00000032001d7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x0000003300287308ULL, 0x000ea20000000800ULL, 0x00000030311c723eULL, 0x002fce00000000ffULL,
0x0000002e001f7308ULL, 0x000fe20000000800ULL, 0x0000001d281d723eULL, 0x004fce00000000ffULL,
0x0000002f00327308ULL, 0x000e700000000800ULL, 0x00000029003c7308ULL, 0x000ea20000000800ULL,
0x0000001f321f723eULL, 0x002fce00000000ffULL, 0x0000002a00337308ULL, 0x0003f00000000800ULL,
0x0000002500257308ULL, 0x000ee20000000800ULL, 0x0000002c1c28723cULL, 0x002fee0000001818ULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x000000393c18723eULL, 0x004fc400000000ffULL,
0x0000003e251a723eULL, 0x008fca00000000ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000333419723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x00000026271b723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000424326723eULL, 0x000fe200000000ffULL,
0x0000002c1828723cULL, 0x000fec0000001828ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000222325723eULL, 0x002fce00000000ffULL, 0x0000004400447308ULL, 0x000e620000000800ULL,
0x0000000fff227424ULL, 0x000fe200078e00ffULL, 0x000000214427723eULL, 0x002fc800000000ffULL,
0x0000001322217219ULL, 0x000fe400000006ffULL, 0x0000003d38137209ULL, 0x010fe40007810000ULL,
0x0000002c242c723cULL, 0x000fde0000001828ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff2c287589ULL, 0x00026200000e0000ULL, 0x00000000002a7806ULL, 0x000fe200038e0100ULL,
0x00000000212273a1ULL, 0x000eb000000e8000ULL, 0x00000000210473c4ULL, 0x000ee20000004000ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000521ff7c12ULL, 0x004fda000f804022ULL,
0x0000000e04248947ULL, 0x00afea000b800000ULL, 0x001c1fff2e297589ULL, 0x0002a800000e0000ULL,
0x001c1fff2a2a7589ULL, 0x000ee800000e0000ULL, 0x001c1fff002b7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff457812ULL, 0x000fe200078ee245ULL, 0x000008000f237824ULL, 0x000fe200078e0202ULL,
0x00000003412e7812ULL, 0x002fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0014ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x00000008452d7836ULL, 0x040fe20000000000ULL,
0x000000042e307812ULL, 0x000fe200078efcffULL, 0x0000000845217824ULL, 0x000fe200078e00ffULL,
0x000000072e227812ULL, 0x000fe200078e7845ULL, 0x0000900023237836ULL, 0x000fe20000000000ULL,
0x00000007302c7812ULL, 0x000fe200078e7845ULL, 0x000000ffff357224ULL, 0x000fe200078e0016ULL,
0x000000072e2e7812ULL, 0x000fe200078e782dULL, 0x000000ffff367224ULL, 0x000fe200078e001cULL,
0x0000000730307812ULL, 0x000fe200078e782dULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000002122227212ULL, 0x080fe200078efcffULL, 0x000000ffff377224ULL, 0x000fe200078e001eULL,
0x000000212c2c7212ULL, 0x000fe200078efcffULL, 0x000000ffff387224ULL, 0x000fe200078e0018ULL,
0x0000002d2e2e7212ULL, 0x080fe200078efcffULL, 0x0000001022227824ULL, 0x000fe200078e0223ULL,
0x0000002d30307212ULL, 0x000fe200078efcffULL, 0x000000ffff147224ULL, 0x000fc400078e0015ULL,
0x000000102c2c7824ULL, 0x000fe200078e0223ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000003422007844ULL, 0x0003e20000000200ULL, 0x000000ffff397224ULL, 0x000fe400078e001aULL,
0x000000ffff3a7224ULL, 0x000fe400078e0024ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0026ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x000000382c007844ULL, 0x0003e20000000200ULL, 0x000000102e2e7824ULL, 0x000fe400078e0223ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe400078e001fULL,
0x000000ffff197224ULL, 0x000fc400078e001bULL, 0x0000001030307824ULL, 0x000fe200078e0223ULL,
0x000000142e007844ULL, 0x0003e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0027ULL, 0x00000001040e7824ULL, 0x000fc600078e020eULL,
0x0000001830007844ULL, 0x0003e80000000200ULL, 0x00f0001020008388ULL, 0x0003e80000000c00ULL,
0x00f2002820008388ULL, 0x01c3e20000000c00ULL, 0x000000050e00720cULL, 0x000fe20003f06070ULL,
0x00f6080d0aff79a7ULL, 0x0003e2000850003fULL, 0x00f6100d0aff79a7ULL, 0x0003e2000850003fULL,
0x00f6180d0aff79a7ULL, 0x0003e2000850003fULL, 0x00f6200d0aff79a7ULL, 0x0003f2000850003fULL,
0xffffffcc00f48947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00f6c81d530075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6c81d530095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2c00807947ULL, 0x004fea000383ffffULL,
0x00f60819660075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00f608196600a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff3000487947ULL, 0x000fea000383ffffULL,
0x0000006f1b0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x0000006f1b0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff34006c7947ULL, 0x000fea000383ffffULL,
0x00f6c81d530075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6c81d530095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4400cc7947ULL, 0x000fea000383ffffULL,
0x00f62819660075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00f628196600a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff4800c87947ULL, 0x000fea000383ffffULL,
0x00f6a873210075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6a873210095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4c00c87947ULL, 0x000fea000383ffffULL,
0x00f6a81d1b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6a81d1b0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff5c00a87947ULL, 0x000fea000383ffffULL,
0x00f64819660075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f64819660095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff6000247947ULL, 0x000fea000383ffffULL,
0x00f6a86f190075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6a86f190085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff6400207947ULL, 0x000fea000383ffffULL,
0x00f6c81d530075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6c81d530085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff7400047947ULL, 0x004fea000383ffffULL,
0x00f668194f0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f668194f0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff7400887947ULL, 0x004fea000383ffffULL,
0x00f6a871190075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6a871190085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff78007c7947ULL, 0x004fea000383ffffULL,
0x00f60009020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f60009020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffc8005c7947ULL, 0x020fea000383ffffULL,
0x00f60009020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f60009020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffc800887947ULL, 0x020fea000383ffffULL,
0x00f68811090075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f68811090085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffe800507947ULL, 0x000fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0010ULL,
0x00000002ff3e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fce00078e00ffULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3f3d7389ULL, 0x0006e40000000043ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0011ULL,
0x00000002ff3e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x004fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3f3d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001b101b7209ULL, 0x000fe20007810000ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3f3d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001a111a7209ULL, 0x000fe20007810000ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0013ULL, 0x000000ffff1d7224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3f3d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001d121d7209ULL, 0x000fe20007810000ULL,
0x000000ffff3f7224ULL, 0x000fe400078e001bULL, 0x00000001ff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3f3d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003813387209ULL, 0x000fe20007810000ULL, 0x000000ffff3f7224ULL, 0x000fe400078e001aULL,
0x000000ffff1c7224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3f3d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001c1b107209ULL, 0x000fe20007810000ULL, 0x000000ffff3f7224ULL, 0x000fe400078e001dULL,
0x000000ffff1f7224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3f3d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001f1a117209ULL, 0x000fe20007810000ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0038ULL,
0x000000ffff1e7224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3f3d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001e1d127209ULL, 0x000fe20007810000ULL, 0xffffffec00487947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff237424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e0021ULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000023ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x004fe400078e002bULL,
0x000000ffff2e7224ULL, 0x002fe400078e002aULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff237424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e0021ULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000023ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x004fe400078e002bULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff237424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e0021ULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000023ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff000747947ULL, 0x006fea000383ffffULL, 0x018000000a067836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000006077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000a00068308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff067807ULL, 0x004fc80004000000ULL, 0x0000000607ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff067807ULL, 0x000fc80000000000ULL, 0x0000000607ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000a077812ULL, 0x000fd600078ec0ffULL, 0x0080000007060812ULL, 0x000fe200078efcffULL,
0x000000ffff068224ULL, 0x000fe200078e0007ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000a00067308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x00cfe400078e0006ULL, 0x000000ffff067224ULL, 0x000fe400078e0009ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xffffff0c06887950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x0000000000000100ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000638ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000680ULL, 0x0000000000000774ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000e48ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e90ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e98ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x000000000000f280ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010180ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000010190ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010190ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000010190ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000010870ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010870ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000f280ULL,
0x000000000000f280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000010180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010190ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin_len = 68032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
