/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013610ULL, 0x0000000000013190ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000117c0ULL, 0x0000000000000190ULL,
0x000e002200000106ULL, 0x0000000000011950ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000011990ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000119d0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000011b00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000117c000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0044ac0400288080ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9808288080820828ULL, 0x2880809908288080ULL, 0x809d082880809a08ULL, 0x082880809e082880ULL,
0x8080a0082880809fULL, 0xa808288080a60828ULL, 0x288080a908288080ULL, 0x80ae08288080aa08ULL,
0x08288080af082880ULL, 0x8080b408288080b3ULL, 0xb608288080b50828ULL, 0x288080bc08288080ULL,
0x80be08288080bd08ULL, 0x08288080c0082880ULL, 0x8080d108288080c2ULL, 0xe308288080df0828ULL,
0x288080f508288080ULL, 0x8280162880808608ULL, 0x0000000003102880ULL, 0x8080869200000000ULL,
0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000117c000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808086ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8b08288080820828ULL,
0x2880808e08288080ULL, 0x8098082880808f08ULL, 0x0828808099082880ULL, 0x80809d082880809aULL,
0x9f082880809e0828ULL, 0x288080a008288080ULL, 0x80a808288080a608ULL, 0x08288080a9082880ULL,
0x8080b308288080aaULL, 0xb508288080b40828ULL, 0x288080b608288080ULL, 0x80be08288080bd08ULL,
0x08288080c0082880ULL, 0x8080d108288080c2ULL, 0xe308288080df0828ULL, 0x288080f508288080ULL,
0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000018800000000ULL, 0x0001195000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080820828ULL,
0x2880808b08288080ULL, 0x808f082880808e08ULL, 0x0828808098082880ULL, 0x80809a0828808099ULL,
0x9e082880809d0828ULL, 0x2880809f08288080ULL, 0x80a608288080a008ULL, 0x08288080a8082880ULL,
0x8080aa08288080a9ULL, 0xb508288080b30828ULL, 0x288080b608288080ULL, 0x80bd08288080bc08ULL,
0x08288080be082880ULL, 0x8080c208288080c0ULL, 0xdf08288080d10828ULL, 0x288080e308288080ULL,
0x80b408288080f508ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b49200ULL,
0x0000001cffffffffULL, 0x0000028800000000ULL, 0x0001199000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080820828ULL,
0x2880808b08288080ULL, 0x808f082880808e08ULL, 0x0828808098082880ULL, 0x80809a0828808099ULL,
0x9e082880809d0828ULL, 0x2880809f08288080ULL, 0x80a608288080a008ULL, 0x08288080a8082880ULL,
0x8080aa08288080a9ULL, 0xb408288080b30828ULL, 0x288080b508288080ULL, 0x80be08288080b608ULL,
0x08288080c0082880ULL, 0x8080d108288080c2ULL, 0xe308288080df0828ULL, 0x288080f508288080ULL,
0x828016288080bd08ULL, 0x0000000003102880ULL, 0x8080bd9200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000038800000000ULL, 0x000119d000000000ULL, 0x0000013000000000ULL,
0x0000180400000000ULL, 0x80b4288080bd0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x0008120400000098ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0000ff1000000020ULL, 0x0001016000010130ULL, 0x000102c0000102b0ULL,
0x01602904000102d0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010001602804ULL, 0x000016c000000120ULL, 0x0000181000001750ULL,
0x00001c1000001840ULL, 0x00001ca000001c40ULL, 0x0000375000001d00ULL, 0x000038b0000037e0ULL,
0x00003cf0000039d0ULL, 0x00003d7000003d10ULL, 0x000053f000003dd0ULL, 0x0000555000005480ULL,
0x0000598000005670ULL, 0x00005a00000059a0ULL, 0x000070a000005a60ULL, 0x0000720000007130ULL,
0x0000764000007320ULL, 0x000076c000007660ULL, 0x0000892000007720ULL, 0x0000af7000008930ULL,
0x0000b7700000b1b0ULL, 0x0000fb700000b7a0ULL, 0x0000fbb00000fba0ULL, 0x0000fbe00000fbc0ULL,
0x0000fc200000fc00ULL, 0x000102a00000fc30ULL, 0x0001031000010300ULL, 0x00010a3000010320ULL,
0x00010af000010a80ULL, 0x00010bd000010b60ULL, 0x00010c9000010c40ULL, 0x00010d5000010ce0ULL,
0x00010e3000010dd0ULL, 0x00010ef000010ea0ULL, 0x00010fb000010f40ULL, 0x0001109000011030ULL,
0x0001115000011100ULL, 0x00011200000111a0ULL, 0x000112d000011270ULL, 0x000113a000011340ULL,
0x0001145000011400ULL, 0x000114f0000114a0ULL, 0x0001159000011540ULL, 0x00011650000115e0ULL,
0x00011730000116d0ULL, 0x04c0390400011790ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL,
0x0000000b00000290ULL, 0x003f01200000f608ULL, 0x0000000b000002d0ULL, 0x003f01200000f688ULL,
0x0000000b00000360ULL, 0x003f01200000f6a8ULL, 0x0000000b000003a0ULL, 0x003f01200000f6c8ULL,
0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000002d00000740ULL, 0x003f01020000f68cULL,
0x0000002d00000a00ULL, 0x003f01010000f688ULL, 0x000000ff00000b20ULL, 0x0004010700000000ULL,
0x000000ff00000bd0ULL, 0x0004010100000000ULL, 0x0000002800000c30ULL, 0x003f010100000020ULL,
0x0000005b00000d50ULL, 0x003f010500000004ULL, 0x0000002800000db0ULL, 0x003f010500000024ULL,
0x0000002800000e30ULL, 0x003f010500000024ULL, 0x0000004800001390ULL, 0x003f010700000000ULL,
0x0000004800001460ULL, 0x003f010100000000ULL, 0x0000003a00001470ULL, 0x003f010500000004ULL,
0x00000030000014e0ULL, 0x003f01010000f608ULL, 0x0000003000001500ULL, 0x003f01050000f60cULL,
0x00000034000015c0ULL, 0x003f01050000f60cULL, 0x0000003a00001b00ULL, 0x003f010500000004ULL,
0x0000003a00001b80ULL, 0x003f010500000004ULL, 0x0000002800002de0ULL, 0x003f010100000020ULL,
0x0000004d00002e60ULL, 0x003f01010000f688ULL, 0x0000005b00002eb0ULL, 0x003f010500000004ULL,
0x0000002800002f00ULL, 0x003f010500000024ULL, 0x0000002800002f80ULL, 0x003f010500000024ULL,
0x00000057000034a0ULL, 0x003f010700000000ULL, 0x0000005700003520ULL, 0x003f010100000000ULL,
0x0000005d00003530ULL, 0x003f010500000004ULL, 0x00000030000035a0ULL, 0x003f01010000f628ULL,
0x00000030000035c0ULL, 0x003f01050000f62cULL, 0x00000034000036a0ULL, 0x003f01050000f62cULL,
0x0000003400003bc0ULL, 0x003f01050000f6acULL, 0x0000003400003c40ULL, 0x003f01050000f6acULL,
0x0000002800004d00ULL, 0x003f010100000020ULL, 0x0000004d00004d70ULL, 0x003f01010000f690ULL,
0x0000005b00004db0ULL, 0x003f010500000004ULL, 0x0000002800004e00ULL, 0x003f010500000024ULL,
0x0000002800004e80ULL, 0x003f010500000024ULL, 0x0000005d00005190ULL, 0x003f010700000000ULL,
0x0000005d00005210ULL, 0x003f010100000000ULL, 0x0000005700005220ULL, 0x003f010500000004ULL,
0x0000003000005290ULL, 0x003f01010000f648ULL, 0x00000030000052b0ULL, 0x003f01050000f64cULL,
0x0000003000005340ULL, 0x003f01050000f64cULL, 0x0000003500005850ULL, 0x003f01050000f6acULL,
0x00000035000058d0ULL, 0x003f01050000f6acULL, 0x0000002800006970ULL, 0x003f010100000020ULL,
0x0000004d000069e0ULL, 0x003f01010000f698ULL, 0x0000005b00006a30ULL, 0x003f010500000004ULL,
0x0000002800006a80ULL, 0x003f010500000024ULL, 0x0000002800006b00ULL, 0x003f010500000024ULL,
0x0000005700006e40ULL, 0x003f010700000000ULL, 0x0000006000006ec0ULL, 0x003f010100000000ULL,
0x0000005d00006ed0ULL, 0x003f010500000004ULL, 0x0000003000006f40ULL, 0x003f01010000f668ULL,
0x0000003000006f60ULL, 0x003f01050000f66cULL, 0x0000003000006ff0ULL, 0x003f01050000f66cULL,
0x0000003000007510ULL, 0x003f01050000f6acULL, 0x0000003000007590ULL, 0x003f01050000f6acULL,
0x00000028000085b0ULL, 0x003f010100000020ULL, 0x0000004d00008610ULL, 0x003f01010000f6a0ULL,
0x000000ff0000c490ULL, 0x003f01010000f600ULL, 0x000000ff0000cf80ULL, 0x003f01050000f604ULL,
0x000000ff0000d020ULL, 0x003f01050000f604ULL, 0x000000ff0000d230ULL, 0x003f01010000f600ULL,
0x000000ff0000d240ULL, 0x003f01050000f604ULL, 0x000000ff0000d2d0ULL, 0x003f01050000f604ULL,
0x0000002a0000f070ULL, 0x003f010100000000ULL, 0x0000002a0000f0b0ULL, 0x003f010500000004ULL,
0x0000002a0000f470ULL, 0x003f010500000004ULL, 0x0000002b00010890ULL, 0x003f010100000000ULL,
0x0000002b000108f0ULL, 0x003f010100000008ULL, 0x0000002b00010950ULL, 0x003f010100000010ULL,
0x0000002b000109c0ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL, 0x0000c3e00000c190ULL,
0x0000d3d00000d330ULL, 0x0000040100010a00ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000474ULL,
0x0000001200000002ULL, 0x0000000000000374ULL, 0x0000001200000002ULL, 0x0000000000000274ULL,
0x0000001200000002ULL, 0x000000000000015cULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x000000000000044cULL, 0x0000001200000002ULL, 0x0000000000000351ULL,
0x0000001200000002ULL, 0x000000000000024cULL, 0x0000001200000002ULL, 0x0000000000000134ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000a7919ULL, 0x000ea20000002300ULL,
0x0000001000047300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000100ff137424ULL, 0x000fc600078e00ffULL,
0x0000000000317919ULL, 0x000f220000000000ULL, 0x0000001000107309ULL, 0x000f660000000000ULL,
0x0000000000277919ULL, 0x000ee80000002600ULL, 0x0000000000057919ULL, 0x000f620000000000ULL,
0x00000005ff257819ULL, 0x002fc6000001160bULL, 0x00000000002f7919ULL, 0x000e680000002700ULL,
0x00001fff25257589ULL, 0x000fe200000e0000ULL, 0x000000010a007824ULL, 0x004fc600078e0203ULL,
0x00001fff0a0a7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe200078e020bULL,
0x00000004ff0d7819ULL, 0x010fe20000011631ULL, 0x00000010310c7824ULL, 0x000fe400078e00ffULL,
0x0000000827007824ULL, 0x008fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f45270ULL,
0x0000000f0b00780cULL, 0x040fe40003f64070ULL, 0x000000030b00780cULL, 0x000fc40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x000000050400720cULL, 0x020fe20003f02070ULL,
0x0000002f07007224ULL, 0x002fe200078e0200ULL, 0x000000f00c117812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040a067824ULL, 0x004fe400078e0225ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000100027824ULL, 0x002fe400078e020fULL,
0x0000000109007824ULL, 0x000fe200078e0a08ULL, 0x00f688060b009388ULL, 0x0003e20000008a00ULL,
0xff317217ff0ec424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL,
0x000000000d00720cULL, 0x000fe20003f66070ULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f4000e0b00c388ULL, 0x0007e20000004800ULL, 0x3fffff80ff049424ULL, 0x004fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0013ULL,
0x00f6a8040b009388ULL, 0x0005e20000008a00ULL, 0x000000ffff067224ULL, 0x002fe200078e0a10ULL,
0x000000070f0e7812ULL, 0x008fe200078ec0ffULL, 0x00000004ff007424ULL, 0x000fe200078e00ffULL,
0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000f0e0e7812ULL, 0x000fe400078e7831ULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x000060002f047625ULL, 0x004fc800078e0000ULL, 0x000000100f0e7824ULL, 0x000fe400078e020eULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100e077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604247981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x00000004ff037e24ULL, 0x00afe2000f8e00ffULL,
0x000000ff24027810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff027819ULL, 0x000fce0000011602ULL,
0x0000bea000008947ULL, 0x000fea0003800000ULL, 0x00000010252e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff117819ULL, 0x000fe20000011631ULL, 0x000000022f2f7824ULL, 0x000fe200078e00ffULL,
0x0000580027007a10ULL, 0x000fe20007ffe0ffULL, 0x00000008252d7824ULL, 0x000fe200078e00ffULL,
0x000000102e2e7812ULL, 0x000fe200078ec0ffULL, 0x00000003ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000103057810ULL, 0x000fe20007ffe0ffULL, 0x000058002f2f7a24ULL, 0x000fe200078e0200ULL,
0x00000001ff467819ULL, 0x000fe20000011625ULL, 0x000000012e047824ULL, 0x000fe200078e0211ULL,
0x000000020500720cULL, 0x000fc40003f06070ULL, 0x0000000411157810ULL, 0x000fe20007ffe0ffULL,
0x0000000803057824ULL, 0x000fe200078e0246ULL, 0x0000003104007212ULL, 0x040fe200078e3cffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x000000012e087824ULL, 0x000fe200078e0215ULL,
0x0000000c111d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002005007824ULL, 0x000fe200078e00ffULL,
0x0000000811197810ULL, 0x000fe20007ffe0ffULL, 0x0000000808097824ULL, 0x040fe200078e00ffULL,
0x0000003108067212ULL, 0x080fe200078e3cffULL, 0x000000012e0b7824ULL, 0x000fe200078e021dULL,
0x0000000024057217ULL, 0x000fe20007800000ULL, 0x000000012e0a7824ULL, 0x000fe200078e0219ULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x00002000462c7824ULL, 0x000fe200078e00ffULL,
0x000000310b0d7212ULL, 0x080fe200078e3cffULL, 0x0000000105067824ULL, 0x100fe200078e0a00ULL,
0x00f68c0e2dff738cULL, 0x0003e20000000000ULL, 0x000062002f007a24ULL, 0x000fe200078e0200ULL,
0x000000310a057212ULL, 0x040fe200078e3cffULL, 0x000000080b127824ULL, 0x000fe200078e00ffULL,
0x00000000460473c2ULL, 0x0004e200000e0000ULL, 0x000000080a107824ULL, 0x000fe200078e00ffULL,
0x000000700c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000100047824ULL, 0x000fe200078e0204ULL,
0xfffffff8120d7812ULL, 0x000fe200078ee20dULL, 0x0000000100087824ULL, 0x000fc400078e0208ULL,
0x00000001000a7824ULL, 0x040fe400078e020aULL, 0x00000001000e7824ULL, 0x002fe200078e020bULL,
0x0000b0002c007810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0xfffffff8100b7812ULL, 0x000fc600078ee205ULL, 0x00005e0004047625ULL, 0x000fc800078e0021ULL,
0x000000100d1f7824ULL, 0x100fe200078e0200ULL, 0x00000020060d7807ULL, 0x000fe20000000000ULL,
0x0000001007137824ULL, 0x100fe200078e0200ULL, 0x0000000f04047210ULL, 0x000fe20007f1e0ffULL,
0x0000001009177824ULL, 0x000fe200078e0200ULL, 0x0000002e0d0d7217ULL, 0x000fe20007800000ULL,
0x00005e0008067625ULL, 0x000fc800078e0021ULL, 0x000000100b1b7824ULL, 0x000fe400078e0200ULL,
0x00005e000a087625ULL, 0x000fc800078e0021ULL, 0x00005e000e0a7625ULL, 0x000fe200078e0021ULL,
0x0000000f08087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000f060c7210ULL, 0x080fe20007f1e0ffULL, 0x000000010d007824ULL, 0x000fe200078e0a2eULL,
0x0000000f0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x000000001100720cULL, 0x080fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0x000000001500720cULL, 0x080fe40003f26070ULL,
0x000000001900720cULL, 0x000fc40003f46070ULL, 0x000000001d00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f688002dff7f8cULL, 0x0003e2000c80043fULL, 0x00000001252b7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff2a7424ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0005e2000c101c46ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000000c177faeULL, 0x0007e2000c901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000f6a846287811ULL, 0x000fc400078e18ffULL,
0x00000000081b7faeULL, 0x0009e8000d101c46ULL, 0x000000000e1f7faeULL, 0x000be2000d901c46ULL,
0x0000000000047805ULL, 0x004fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000087805ULL, 0x010fe2000001ff00ULL,
0x00000000000e7805ULL, 0x020fe4000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x00000000ff607f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200028267f8cULL, 0x0004e2000c80043fULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000020285b7810ULL, 0x000fe20007ffe0ffULL, 0x000079a000000947ULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x00cfe400078e0027ULL, 0xff317217ff2a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000010003277824ULL, 0x000fca00078e00ffULL, 0x000000242700720cULL, 0x000fda0003f06070ULL,
0x000078f000000947ULL, 0x006fea0003800000ULL, 0x000004005b007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e004bULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240028007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000307305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000300000735dULL, 0x008fe40003800000ULL, 0x0000240028307984ULL, 0x000ea40000000800ULL,
0x8000000030ff7812ULL, 0x004fc40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000010004b007824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe20000011625ULL,
0x0000010003447824ULL, 0x000fe200078e00ffULL, 0x00000003ff3b7819ULL, 0x000fe20000011631ULL,
0x00000010313e7824ULL, 0x000fe200078e00ffULL, 0x0000100000357812ULL, 0x000fe200078e0cffULL,
0x0000002046007824ULL, 0x000fe200078e0244ULL, 0x0000000103337810ULL, 0x000fe20007ffe0ffULL,
0x000000012e327824ULL, 0x000fe200078e023bULL, 0x000000083b437810ULL, 0x000fe20007ffe0ffULL,
0x0000200046357824ULL, 0x000fe200078e0235ULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x0000000832377824ULL, 0x000fe200078e00ffULL, 0x000000023300720cULL, 0x000fe20003f06070ULL,
0x000000012e367824ULL, 0x000fe200078e0243ULL, 0x000000043b417810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff3d7424ULL, 0x000fe200078e00ffULL, 0x0000000024337217ULL, 0x000fe20007800000ULL,
0x00000008365f7824ULL, 0x000fe200078e00ffULL, 0x0000003132307212ULL, 0x080fe200078e3cffULL,
0x000000012e347824ULL, 0x040fe200078e0241ULL, 0x0000000c3b457810ULL, 0x000fe20007ffe0ffULL,
0x0000000133337824ULL, 0x000fe200078e0a00ULL, 0xfffffff837377812ULL, 0x000fe200078ee230ULL,
0x000062002f007a24ULL, 0x000fe200078e0200ULL, 0x0000b00035607810ULL, 0x002fe20007ffe0ffULL,
0x000000012e397824ULL, 0x000fe200078e0245ULL, 0x0000003136387212ULL, 0x080fe200078e3cffULL,
0x00000008344f7824ULL, 0x040fe200078e00ffULL, 0x0000003134307212ULL, 0x080fe200078e3cffULL,
0x0000000132327824ULL, 0x000fe200078e0200ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee238ULL,
0x00000010374e7824ULL, 0x000fe200078e0260ULL, 0x0000002033377807ULL, 0x000fe20000000000ULL,
0x0000000134347824ULL, 0x100fe200078e0200ULL, 0x0000003139387212ULL, 0x040fe200078e3cffULL,
0x00000001393a7824ULL, 0x040fe200078e0200ULL, 0x000000703e3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000372e377217ULL, 0x000fe20007800000ULL,
0x00005e0032327625ULL, 0x080fe200078e003dULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee230ULL,
0x0000030000007945ULL, 0x000fe20003800000ULL, 0xfffffff839397812ULL, 0x000fe200078ee238ULL,
0x00005e0034347625ULL, 0x000fc800078e003dULL, 0x0000000136307824ULL, 0x000fe200078e0200ULL,
0x0000003f32367210ULL, 0x080fe20007f1e0ffULL, 0x0000000137007824ULL, 0x000fe200078e0a2eULL,
0x0000003f34387210ULL, 0x000fe20007f5e0ffULL, 0x000000104f4f7824ULL, 0x100fe400078e0260ULL,
0x000000105f5f7824ULL, 0x100fe200078e0260ULL, 0x000000004300720cULL, 0x080fe20003f66070ULL,
0x0000001039607824ULL, 0x000fe200078e0260ULL, 0x000000004500720cULL, 0x080fe20003f86070ULL,
0x000000ffff377224ULL, 0x000fe200000e0633ULL, 0x000000003b00720cULL, 0x080fe20003f06070ULL,
0x000000ffff397224ULL, 0x000fe200010e0635ULL, 0x000000004100720cULL, 0x000fe20003f46070ULL,
0x00005e0030327625ULL, 0x000fe200078e003dULL, 0xffffffe02d007812ULL, 0x000fc600078ec0ffULL,
0x00005e003a347625ULL, 0x000fe200078e003dULL, 0x0000003f32327210ULL, 0x080fe40007fbe0ffULL,
0x000000082d3a7812ULL, 0x000fe200078ec0ffULL, 0x000000084b3d7824ULL, 0x000fe200078e00ffULL,
0x0000003f34347210ULL, 0x000fe20007fde0ffULL, 0x0000001046307824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000364e7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x000000083d3b7812ULL, 0x000fe200078e0cffULL,
0x000000ffff357224ULL, 0x000fe200030e0635ULL, 0x0000f6a8303c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000384f7faeULL, 0x0003e2000d101c46ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x000000013c487824ULL, 0x000fe200078e023bULL, 0x00000000325f7faeULL, 0x0003e2000d901c46ULL,
0x00000010303b7812ULL, 0x000fc600078ec0ffULL, 0x0000000034607faeULL, 0x0003e2000e101c46ULL,
0x000000003a307210ULL, 0x000fc60007ffe03bULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000480403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013c3a7824ULL, 0x000fe200078e023dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000048487f8cULL, 0x000ea8000c80043fULL, 0x000004003a347984ULL, 0x0022e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080030327f8cULL, 0x000fe2000c80043fULL, 0x8000000034ff7812ULL, 0x008fc60007844861ULL,
0x00f60c0030357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x008fe40007804833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x000000102d357812ULL, 0x000fca00078ec0ffULL,
0x0000000100347824ULL, 0x000fe400078e0235ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x000000082b347824ULL, 0x000fe400078e0234ULL, 0x0000000000357305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000350000735dULL, 0x010fe40003800000ULL,
0x00f60c0034357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x008fc40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002025337824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fe20000011631ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x000000703e327812ULL, 0x000fe400078ec0ffULL, 0xffffff8033337812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fc800078ec0ffULL, 0x0000003338007210ULL, 0x000fca0007ffe032ULL,
0x00f0000000377984ULL, 0x000ee80000000800ULL, 0x00f2000000367984ULL, 0x0008620000000800ULL,
0x0000002a3700720bULL, 0x008fe20003f1d000ULL, 0x0000f3527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x010fc800000e0100ULL, 0x0000ffff003b7812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6c7424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x000fe40000011625ULL,
0x0000002a3700720bULL, 0x000fe40003f14000ULL, 0x000000250000720cULL, 0x000fe20003f65270ULL,
0x0000f3127f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000802535b824ULL, 0x000fe200078e0232ULL, 0x000000372a427209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x000000013835b824ULL, 0x000fe400078e0235ULL,
0x800000422a2a7221ULL, 0x000fe20000010000ULL, 0x000000003bff7212ULL, 0x000fc4000780c0ffULL,
0x00f400423500b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2a2a7820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fc60000011631ULL, 0x0000002a003d7308ULL, 0x0007220000000800ULL,
0x0000f2a27f007947ULL, 0x000fea000b800000ULL, 0x00001f003d2a7589ULL, 0x01872400000e0000ULL,
0x0000000800007810ULL, 0x008fe20007ffe0ffULL, 0x0000f2e27f007947ULL, 0x000fea000b800000ULL,
0x00001f003d007589ULL, 0x00072400000e0000ULL, 0x8000004237370221ULL, 0x100fe20000010000ULL,
0x0000002a05057220ULL, 0x090fe20000410000ULL, 0x0000002a04047220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b37370820ULL, 0x000fe20000410000ULL,
0x0000002a08087220ULL, 0x080fe20000410000ULL, 0x0000002a0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002a0c0c7220ULL, 0x080fe20000410000ULL, 0x0000003700260308ULL, 0x000f220000000800ULL,
0x0000002a11117220ULL, 0x080fe20000410000ULL, 0x0000002a10107220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x000fe20000410000ULL,
0x0000003d29297220ULL, 0x000fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x000fe20000410000ULL, 0x00000001ff6c7807ULL, 0x000fe20000000000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0042ULL, 0x0000002636360220ULL, 0x012fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002936297221ULL, 0x002fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x000004003a007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000347305ULL, 0x000324000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000340000735dULL, 0x010fe40003800000ULL,
0x000004003a347984ULL, 0x000e640000000800ULL, 0x8000000034ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000026ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff367819ULL, 0x000fc40000011631ULL, 0x00005410003d7816ULL, 0x008fe20000000000ULL,
0x0000ef827f007947ULL, 0x000fea000b800000ULL, 0x00001f363d517589ULL, 0x0002e400000e0000ULL,
0x00000008363a7810ULL, 0x000fe20007ffe0ffULL, 0x0000efc27f007947ULL, 0x000fea000b800000ULL,
0x00001f3a3d007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010363e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x00001cb000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000fce000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018363e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x00001d1000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000fc8000007944ULL, 0x01cfea0003c00000ULL, 0x00000002254d7824ULL, 0x000fe200078e00ffULL,
0x00000007316e7812ULL, 0x000fe200078ec0ffULL, 0x0000020025457824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000044d347812ULL, 0x000fc400078ec0ffULL,
0x000000086e6e7812ULL, 0x000fe400078ef831ULL, 0x0000003431737211ULL, 0x000fe400078fe0ffULL,
0xfffff80045457812ULL, 0x000fe400078ec0ffULL, 0x0000000773357812ULL, 0x000fe400078e786eULL,
0x0000000831347812ULL, 0x000fc600078ec0ffULL, 0x000000086e367824ULL, 0x002fc800078e0235ULL,
0x00000010363b7824ULL, 0x000fe400078e0245ULL, 0x0000000425357824ULL, 0x040fe200078e00ffULL,
0x00000007343d7812ULL, 0x150fe200078ec831ULL, 0x0000100025377824ULL, 0x000fe200078e00ffULL,
0x0000000734477812ULL, 0x000fe200078ef831ULL, 0x000010004b407824ULL, 0x000fe200078e022cULL,
0x0000000435367812ULL, 0x000fe400078ec0ffULL, 0xffffe000373e7812ULL, 0x000fe400078ec0ffULL,
0x00000036313c7211ULL, 0x004fe400078fe0ffULL, 0x00000080475d7811ULL, 0x000fe200078e18ffULL,
0x000010004b347824ULL, 0x000fe200078e023eULL, 0x0000003c3d3e7212ULL, 0x000fc400078e3cffULL,
0x0000b000405c7810ULL, 0x000fe40007ffe0ffULL, 0x0000b000343f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008474c7824ULL, 0x000fe200078e023eULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013e537824ULL, 0x000fe200078e025dULL, 0x0000000273737810ULL, 0x000fe20007ffe0ffULL,
0x000000104c347824ULL, 0x000fe200078e023fULL, 0x000099106c897816ULL, 0x000fe200000000ffULL,
0x0000001053407824ULL, 0x000fc600078e025cULL, 0x000000ff8900720cULL, 0x000fe20003f05270ULL,
0x000000003434783bULL, 0x000e680000004200ULL, 0x000000004040783bULL, 0x000ea20000004200ULL,
0x0000010034547824ULL, 0x042fe200078e00ffULL, 0x00008880343e7816ULL, 0x040fe200000000ffULL,
0x00000100355a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011454ULL,
0x0000003e00747306ULL, 0x0003e20000200c00ULL, 0x0000003c3d547212ULL, 0x000fe200078e3cffULL,
0x0000010042637824ULL, 0x004fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff707819ULL, 0x000fe20000011435ULL, 0x0000000847477824ULL, 0x000fe200078e0254ULL,
0x0000888035597816ULL, 0x000fe200000000ffULL, 0x0000005800757306ULL, 0x0005220000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x00000010473f7824ULL, 0x000fe200078e023fULL,
0x00000018ff4a7819ULL, 0x000fe20000011440ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011436ULL, 0x0000000154547824ULL, 0x000fe200078e025dULL,
0x00000018ff577819ULL, 0x000fe20000011437ULL, 0x000000003f3c783bULL, 0x002e620000004200ULL,
0x0000010036587824ULL, 0x004fe200078e00ffULL, 0x0000003400767306ULL, 0x0005e20000200c00ULL,
0x00000018ff357819ULL, 0x000fc40000011435ULL, 0x00000018ff657819ULL, 0x000fe40000011463ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff557819ULL, 0x000fe20000011441ULL,
0x0000005900777306ULL, 0x000be20000200c00ULL, 0x0000888036347816ULL, 0x044fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011442ULL,
0x00000018ff527819ULL, 0x000fc40000011443ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x00000034007a7306ULL, 0x0005e20000200c00ULL, 0x0000888037597816ULL, 0x020fe400000000ffULL,
0x0000888043637816ULL, 0x000fe400000000ffULL, 0x0000541074747816ULL, 0x010fc60000000075ULL,
0x00000058007b7306ULL, 0x0009e20000200c00ULL, 0x0000010040347824ULL, 0x004fce00078e00ffULL,
0x0000005a00787306ULL, 0x0005620000200c00ULL, 0x0000888040587816ULL, 0x050fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x002fe2000001143dULL,
0x000001003e877824ULL, 0x000fc800078e00ffULL, 0x00000059007c7306ULL, 0x0003e20000200c00ULL,
0x00000100375a7824ULL, 0x044fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x000088803d837816ULL, 0x000fe200000000ffULL,
0x000001003f6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000003500797306ULL, 0x0005e20000200c00ULL, 0x00000018ff597819ULL, 0x002fe20000011434ULL,
0x0000001054347824ULL, 0x000fe200078e025cULL, 0x00000018ff377819ULL, 0x000fc40000011437ULL,
0x00008880425c7816ULL, 0x040fe200000000ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001143cULL, 0x0000004000617306ULL, 0x0003e20000200c00ULL,
0x0000010041357824ULL, 0x004fe200078e00ffULL, 0x000088803c807816ULL, 0x000fe400000000ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff5d7819ULL, 0x000fe40000011435ULL,
0x00000036007d7306ULL, 0x000fe20000200c00ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe2000001143eULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fc4000001143fULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000037007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x000088803e867816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000005a007f7306ULL, 0x0005220000200c00ULL, 0x000000003434783bULL, 0x002e620000004200ULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x0000541077757816ULL, 0x020fe40000000078ULL,
0x000054107a7a7816ULL, 0x000fe4000000007bULL, 0x00000040006a7306ULL, 0x000be20000200c00ULL,
0x00008880415a7816ULL, 0x044fe200000000ffULL, 0x0001000041417824ULL, 0x000fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x00000042006b7306ULL, 0x000fe20000200c00ULL,
0x000001003c407824ULL, 0x020fe200078e00ffULL, 0x000054107c7b7816ULL, 0x010fe2000000007fULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011440ULL,
0x000001003d407824ULL, 0x040fe200078e00ffULL, 0x00000041005e7306ULL, 0x000fe20000200c00ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff847819ULL, 0x000fe40000011440ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000043006d7306ULL, 0x0005f00000200c00ULL, 0x0000003d00857306ULL, 0x0009e20000200c00ULL,
0x009000003b40783bULL, 0x004ea20000000200ULL, 0x00000018ff687819ULL, 0x002fc40000011434ULL,
0x00000018ff697819ULL, 0x000fe40000011435ULL, 0x00000018ff667819ULL, 0x000fe40000011436ULL,
0x0000003c00827306ULL, 0x0003e20000200c00ULL, 0x00000007733d7812ULL, 0x010fe400078e786eULL,
0x00000018ff677819ULL, 0x000fc60000011437ULL, 0x000000086e6e7824ULL, 0x000fe400078e023dULL,
0x0000003e00737306ULL, 0x000fe20000200c00ULL, 0x000088803f3c7816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe400078e00ffULL, 0x000000106e457824ULL, 0x000fc600078e0245ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003c00887306ULL, 0x0003f00000200c00ULL,
0x0000003f008b7306ULL, 0x0009e20000200c00ULL, 0x00000100343c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001143cULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x00900000453c783bULL, 0x010f220000000200ULL, 0x0000005140408232ULL, 0x08cfe40000000000ULL,
0x0000005142428232ULL, 0x000fe40000000000ULL, 0x0000000041418232ULL, 0x080fe40000000000ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x0000000043438232ULL, 0x000fce0000000000ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541076767816ULL, 0x002fe2000000006fULL,
0x000000744020723cULL, 0x040fec0000001820ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x0000541079777816ULL, 0x004fe20000000070ULL, 0x0000010035747824ULL, 0x040fe200078e00ffULL,
0x0000888035707816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007a4018723cULL, 0x000fe40000001818ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000054107d567816ULL, 0x008fc40000000056ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000076401c723cULL, 0x000fe6000000181cULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x000054107e577816ULL, 0x002fe20000000057ULL,
0x000000513c3c8232ULL, 0x090fe40000000000ULL, 0x000000513e3e8232ULL, 0x000fe20000000000ULL,
0x0000010036517824ULL, 0x000fe200078e00ffULL, 0x000000003d3d8232ULL, 0x000fc40000000000ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000000564014723cULL, 0x000fe20000001814ULL,
0x000000003f3f8232ULL, 0x000fe20000000000ULL, 0x0000888037007816ULL, 0x000fe400000000ffULL,
0x00000018ff517819ULL, 0x000fc60000011451ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x0000541080807816ULL, 0x004fce0000000081ULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x0000541083817816ULL, 0x002fce0000000084ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000804010723cULL, 0x000fee0000001810ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000541086867816ULL, 0x004fce0000000087ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541082827816ULL, 0x002fce0000000071ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541085837816ULL, 0x008fce0000000072ULL,
0x0000006c00897306ULL, 0x0002a20000200c00ULL, 0x00000082400c723cULL, 0x000fee000000180cULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x00008880346c7816ULL, 0x042fe200000000ffULL,
0x0001000034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x0000541088877816ULL, 0x004fce0000000089ULL,
0x0000003400577306ULL, 0x0005e20000200c00ULL, 0x000000864008723cULL, 0x000fee0000001808ULL,
0x0000003500567306ULL, 0x0009e20000200c00ULL, 0x0000541073347816ULL, 0x004fce0000000062ULL,
0x0000006e006f7306ULL, 0x0005e20000200c00ULL, 0x000054108b357816ULL, 0x010fce0000000064ULL,
0x000000344004723cULL, 0x000fe20000001804ULL, 0x00008880366e7816ULL, 0x044fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000005800587306ULL, 0x000fe60000200c00ULL,
0x000000ffff627224ULL, 0x000fe200078e006eULL, 0x0000541061347816ULL, 0x008fe2000000004aULL,
0x0000010037407824ULL, 0x040fe200078e00ffULL, 0x000054105e357816ULL, 0x002fe20000000055ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x000000343c1c723cULL, 0x000fe8000000181cULL,
0x0000005a005a7306ULL, 0x000ff00000200c00ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000541058587816ULL, 0x002fce0000000059ULL, 0x0000005200527306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x000054105a597816ULL, 0x004fce000000005dULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x000000583c20723cULL, 0x000fee0000001820ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410635d7816ULL, 0x002fce000000006aULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000054106b507816ULL, 0x004fce0000000050ULL,
0x0000006800687306ULL, 0x000eb00000200c00ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000065ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541057687816ULL, 0x004fe20000000068ULL, 0x0000005c3c18723cULL, 0x000fec0000001818ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541056697816ULL, 0x008fce0000000069ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000000683c0c723cULL, 0x000fee000000180cULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000007400757306ULL, 0x000ea20000200c00ULL,
0x000054106c6c7816ULL, 0x002fce000000006fULL, 0x0000006200627306ULL, 0x000ff00000200c00ULL,
0x0000005100417306ULL, 0x0002f00000200c00ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000054106d517816ULL, 0x002fc40000000052ULL, 0x00005410706d7816ULL, 0x004fca0000000075ULL,
0x0000004000437306ULL, 0x000e620000200c00ULL, 0x0000541062627816ULL, 0x008fe20000000041ULL,
0x000000503c14723cULL, 0x040fec0000001814ULL, 0x0000003600357306ULL, 0x000ea40000200c00ULL,
0x0000006c3c10723cULL, 0x000fec0000001810ULL, 0x0000003700347306ULL, 0x000ee20000200c00ULL,
0x0000541000637816ULL, 0x002fc40000000043ULL, 0x0000541035667816ULL, 0x004fca0000000066ULL,
0x000000623c08723cULL, 0x000fe20000001808ULL, 0x0000541034677816ULL, 0x008fce0000000067ULL,
0x000000663c04723cULL, 0x000fe20000001804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200028347f8cULL, 0x0002a2000c80043fULL, 0xfffffff84d4d7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004044377810ULL, 0x000fe20007ffe0ffULL,
0x00f688004dff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff617224ULL, 0x000fe200078e0049ULL,
0x000000014b4b7812ULL, 0x000fe400078e0cffULL, 0x000000243700720cULL, 0x000fda0003f06070ULL,
0x0000579000000947ULL, 0x000fea0003800000ULL, 0x000004005b007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240028007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000347305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000340000735dULL, 0x008fe40003800000ULL,
0x0000240028347984ULL, 0x000ea40000000800ULL, 0x8000000034ff7812ULL, 0x004fc40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000431357811ULL, 0x000fe200078fe8ffULL,
0x00000080ff517424ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe20000011625ULL,
0x0000100027627824ULL, 0x000fe200078e00ffULL, 0x0000002e31007211ULL, 0x000fe200078fe8ffULL,
0x000000012e347824ULL, 0x000fe200078e0235ULL, 0x0000000103377810ULL, 0x000fe20007ffe0ffULL,
0x0000002046367824ULL, 0x000fe200078e0244ULL, 0x0000003100357212ULL, 0x0c0fe200078e3cffULL,
0x0000000800587824ULL, 0x000fe200078e00ffULL, 0x0000003134007212ULL, 0x040fe200078e3cffULL,
0x0000000834597824ULL, 0x000fe200078e00ffULL, 0x0000008036347810ULL, 0x000fc40007ffe0ffULL,
0xfffffff858587812ULL, 0x000fe400078ee235ULL, 0x0000000831357811ULL, 0x000fe200078fe8ffULL,
0x000062002f417a24ULL, 0x100fe200078e0234ULL, 0x00000034243d7217ULL, 0x000fe40007800000ULL,
0x00000003ff437819ULL, 0x000fe40000011631ULL, 0x000000023700720cULL, 0x000fe20003f06070ULL,
0x000000013d3d7824ULL, 0x000fe200078e0a34ULL, 0xfffffff859597812ULL, 0x000fe200078ee200ULL,
0x000000012e007824ULL, 0x000fe200078e0235ULL, 0x0000000c31377811ULL, 0x000fc400078fe8ffULL,
0x00000004434b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000800557824ULL, 0x000fe200078e00ffULL,
0x0000004341347210ULL, 0x140fe20007ffe02eULL, 0x000000012e367824ULL, 0x000fe200078e0237ULL,
0x00000031003c7212ULL, 0x000fe400078e3cffULL, 0x0000004b41377210ULL, 0x000fe20007ffe02eULL,
0x00005e0034347625ULL, 0x000fe200078e0051ULL, 0x000000203d3d7807ULL, 0x000fe40000000000ULL,
0x0000003136007212ULL, 0x040fe200078e3cffULL, 0x00000008363f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8555a7812ULL, 0x000fe200078ee23cULL, 0x00005e0037367625ULL, 0x000fe200078e0051ULL,
0x0000003d2e3d7217ULL, 0x000fc40007800000ULL, 0x00000032343c7210ULL, 0x080fe20007f1e0ffULL,
0x0000000827557824ULL, 0x000fe200078e00ffULL, 0x00000032363e7210ULL, 0x000fe20007f5e0ffULL,
0x000000013d407824ULL, 0x000fe200078e0a2eULL, 0x0000f6a846567811ULL, 0x000fe200078e20ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0635ULL, 0x00000008555d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff83f007812ULL, 0x000fe200078ee200ULL, 0x000000ffff3f7224ULL, 0x000fe200010e0637ULL,
0x0000100062357812ULL, 0x000fe200078ec0ffULL, 0x0000000156577824ULL, 0x000fe200078e025dULL,
0x0000000843377810ULL, 0x000fc40007ffe0ffULL, 0x000000404300720cULL, 0x0c0fe20003f06070ULL,
0x0000200046357824ULL, 0x000fe200078e0235ULL, 0x0000000c43437810ULL, 0x000fe20007ffe0ffULL,
0x00000000570473c2ULL, 0x000ea200000e0000ULL, 0x0000003741347210ULL, 0x140fe40007ffe02eULL,
0x0000004341367210ULL, 0x000fe40007ffe02eULL, 0x0000b00035417810ULL, 0x000fe20007ffe0ffULL,
0x00005e0034347625ULL, 0x000fe200078e0051ULL, 0x000000403700720cULL, 0x000fc40003f66070ULL,
0x000000404b00720cULL, 0x080fe20003f46070ULL, 0x00005e0036367625ULL, 0x000fe200078e0051ULL,
0x000000404300720cULL, 0x000fe40003f86070ULL, 0x0000003234347210ULL, 0x080fe20007fbe0ffULL,
0x0000001058587824ULL, 0x100fe200078e0241ULL, 0x0000003236367210ULL, 0x000fe20007fde0ffULL,
0x0000001059597824ULL, 0x100fe200078e0241ULL, 0x000000085d5d7812ULL, 0x000fe200078e3cffULL,
0x000000105a5a7824ULL, 0x000fe200078e0241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c587faeULL, 0x0007e2000c101c46ULL, 0x000000ffff357224ULL, 0x000fc400028e0635ULL,
0x00000010005c7824ULL, 0x000fe200078e0241ULL, 0x000000003e597faeULL, 0x0007e2000d101c46ULL,
0x000000ffff377224ULL, 0x000fe400030e0637ULL, 0x00000001565d7824ULL, 0x000fe200078e025dULL,
0x00000000345a7faeULL, 0x0007e8000d901c46ULL, 0x00000000365c7faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000057347f8cULL, 0x0084e8000c80043fULL, 0x000004005d3d7984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280030367f8cULL, 0x000fe2000c80043fULL, 0x800000003dff7812ULL, 0x010fc60007844849ULL,
0x00f62c00303f7984ULL, 0x000f240000000800ULL, 0x800000003fff7812ULL, 0x010fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff617224ULL, 0x008fe200078e0035ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe02d347812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x000000102d357812ULL, 0x040fe400078ec0ffULL, 0x000000082d3c7812ULL, 0x000fc800078ec0ffULL,
0x000000343c347210ULL, 0x000fe40007ffe035ULL, 0x0000000000357305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000350000735dULL, 0x010fe40003800000ULL,
0x00f62c0034357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x008fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008032357810ULL, 0x000fca0007ffe033ULL,
0x0000000138357824ULL, 0x000fca00078e0235ULL, 0x00f0000035377984ULL, 0x000ee80000000800ULL,
0x00f2000035007984ULL, 0x0008620000000800ULL, 0x0000002a3700720bULL, 0x008fe20003f1d000ULL,
0x0000d5227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x010fc800000e0100ULL,
0x0000ffff343e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff727424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000125347811ULL, 0x000fe400078ff0ffULL, 0x0000002a3700720bULL, 0x000fe40003f14000ULL,
0x000000253400720cULL, 0x000fe20003f65270ULL, 0x0000d4e27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x000000372a357209ULL, 0x000fe20007810000ULL,
0x00000080253db824ULL, 0x000fc800078e0232ULL, 0x800000352a367221ULL, 0x000fe20000010000ULL,
0x00000001383cb824ULL, 0x000fe200078e023dULL, 0x0000ffff343d7812ULL, 0x000fe400078e3cffULL,
0x3fb8aa3b36367820ULL, 0x000fe40000410000ULL, 0x00f400353c00b388ULL, 0x0007e20000000800ULL,
0x0000003d3eff7212ULL, 0x000fe4000780c0ffULL, 0x00000002ff3e7819ULL, 0x000fe20000011631ULL,
0x0000003600367308ULL, 0x000f240000000800ULL, 0x0000003629297220ULL, 0x010fe20000410000ULL,
0x0000d4627f007947ULL, 0x000fea000b800000ULL, 0x00001f3e36347589ULL, 0x00872400000e0000ULL,
0x0000003420207220ULL, 0x090fe20000410000ULL, 0x0000003421217220ULL, 0x080fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x000000341d1d7220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x000000340c0c7220ULL, 0x080fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x0000003404047220ULL, 0x080fe20000410000ULL, 0x0000003405057220ULL, 0x000fe20000410000ULL,
0x0000d3b27f007947ULL, 0x000fea000b800000ULL, 0x00001f3a36347589ULL, 0x0008a400000e0000ULL,
0x000000372a2a7209ULL, 0x000fe20007810000ULL, 0x0000003422227220ULL, 0x084fe20000410000ULL,
0x00000001ff727807ULL, 0x000fe20000000000ULL, 0x0000003423237220ULL, 0x080fe20000410000ULL,
0x000000341e1e7220ULL, 0x080fe20000410000ULL, 0x8000002a37370221ULL, 0x000fe20000010000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b37370820ULL, 0x000fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x0000003700260308ULL, 0x000ea20000000800ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x000000340e0e7220ULL, 0x080fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x000000340a0a7220ULL, 0x080fe20000410000ULL,
0x000000340b0b7220ULL, 0x080fe20000410000ULL, 0x0000003406067220ULL, 0x080fe20000410000ULL,
0x0000003407077220ULL, 0x000fe20000410000ULL, 0x0000000026000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000002900297221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000827007824ULL, 0x000fe200078e00ffULL, 0xfffffff02d357812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000100347824ULL, 0x000fca00078e0235ULL,
0x00f6ac0034357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000357305ULL, 0x000364000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000350000735dULL, 0x020fe40003800000ULL,
0x00f6ac0034357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fc40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff3e7819ULL, 0x008fe40000011631ULL,
0x00000026ff00723eULL, 0x000fe400000000ffULL, 0x000000183e367810ULL, 0x050fe40007ffe0ffULL,
0x000000103e377810ULL, 0x000fe40007ffe0ffULL, 0x00005410003d7816ULL, 0x000fe20000000000ULL,
0x0000d1127f007947ULL, 0x000fea000b800000ULL, 0x00001f3e3d637589ULL, 0x0002e400000e0000ULL,
0x0000d1527f007947ULL, 0x000fea000b800000ULL, 0x00001f3a3d007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e0037ULL,
0x00003d8000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000dc1000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e0036ULL,
0x00003de000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000dbb000007944ULL, 0x01cfea0003c00000ULL,
0x0000100027357824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100025347824ULL, 0x000fe200078e00ffULL, 0x0000991072727816ULL, 0x000fe400000000ffULL,
0x0000100035357812ULL, 0x000fe400078e0cffULL, 0xffffe00034347812ULL, 0x000fc400078ec0ffULL,
0x000000ff7200720cULL, 0x000fe40003f05270ULL, 0x0000b00034527810ULL, 0x100fe40007ffe035ULL,
0x0000b0002c357810ULL, 0x000fc60007ffe035ULL, 0x000000104c5e7824ULL, 0x100fe400078e0252ULL,
0x0000001047527824ULL, 0x000fe400078e0252ULL, 0x0000001053517824ULL, 0x100fe200078e0235ULL,
0x000000005e3c783bULL, 0x016e620000004200ULL, 0x0000001054507824ULL, 0x000fc600078e0235ULL,
0x000000005248783bULL, 0x000fe80000004200ULL, 0x000000005140783bULL, 0x000ea80000004200ULL,
0x000000005034783bULL, 0x000f220000004200ULL, 0x00000018ff737819ULL, 0x002fe2000001143cULL,
0x000001003c767824ULL, 0x040fe200078e00ffULL, 0x000088803c757816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001143dULL,
0x000001003d797824ULL, 0x040fe200078e00ffULL, 0x000088803d777816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe2000001143eULL,
0x0000010042907824ULL, 0x004fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000088803e7c7816ULL, 0x040fe200000000ffULL,
0x0000003c00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff717819ULL, 0x000fe4000001143fULL,
0x000088803f7e7816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011448ULL,
0x00000018ff6c7819ULL, 0x000fe2000001144aULL, 0x0000003d007b7306ULL, 0x0005e20000200c00ULL,
0x000001003e3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc40000011440ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000079007a7306ULL, 0x0003e20000200c00ULL,
0x00000100483d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff6a7819ULL, 0x000fe40000011441ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c007d7306ULL, 0x0005e20000200c00ULL, 0x000001003f797824ULL, 0x002fe200078e00ffULL,
0x00008880418d7816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc40000011449ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000003d00837306ULL, 0x0003e20000200c00ULL, 0x00008880483c7816ULL, 0x044fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff6d7819ULL, 0x000fe4000001144bULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000003c00827306ULL, 0x0005620000200c00ULL, 0x000088804a3d7816ULL, 0x002fc400000000ffULL,
0x00000018ff667819ULL, 0x000fe40000011442ULL, 0x00000018ff697819ULL, 0x000fe40000011443ULL,
0x00000018ff657819ULL, 0x010fe20000011434ULL, 0x0000003e007f7306ULL, 0x0003e20000200c00ULL,
0x00010000493c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011435ULL,
0x00000018ff647819ULL, 0x000fe40000011436ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000003d00877306ULL, 0x0005e20000200c00ULL, 0x00000100493e7824ULL, 0x002fe200078e00ffULL,
0x0000541082827816ULL, 0x020fe40000000083ULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003f00807306ULL, 0x0003e20000200c00ULL,
0x00000100403d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc80000011437ULL,
0x00000018ff8b7819ULL, 0x000fe2000001143dULL, 0x00000100413d7824ULL, 0x040fe200078e00ffULL,
0x0000003c00867306ULL, 0x0005e20000200c00ULL, 0x000001004a3f7824ULL, 0x042fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001143dULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000007900817306ULL, 0x0003e20000200c00ULL, 0x000100004b3c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00857306ULL, 0x0005e20000200c00ULL,
0x0000888049797816ULL, 0x002fce00000000ffULL, 0x0000007900847306ULL, 0x0003220000200c00ULL,
0x000088804b3e7816ULL, 0x004fce00000000ffULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x0000888040797816ULL, 0x042fe200000000ffULL, 0x0001000040407824ULL, 0x000fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000003f00887306ULL, 0x000e620000200c00ULL,
0x0000541084837816ULL, 0x010fce0000000085ULL, 0x0000003e00897306ULL, 0x000fe20000200c00ULL,
0x0000541075767816ULL, 0x004fce0000000076ULL, 0x0000003c008a7306ULL, 0x0005e20000200c00ULL,
0x0000541087887816ULL, 0x002fce0000000088ULL, 0x0000004800497306ULL, 0x0003e20000200c00ULL,
0x009800003b3c783bULL, 0x004eae0000000200ULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x000001004b487824ULL, 0x002fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x0000004a004b7306ULL, 0x000ff00000200c00ULL, 0x00000040004a7306ULL, 0x0003e20000200c00ULL,
0x0000541078787816ULL, 0x010fce0000000073ULL, 0x00000079008c7306ULL, 0x0009e20000200c00ULL,
0x0000888043407816ULL, 0x002fce00000000ffULL, 0x00000041008f7306ULL, 0x0003e20000200c00ULL,
0x0000888042797816ULL, 0x050fe200000000ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x000000633c3c8232ULL, 0x08cfe40000000000ULL, 0x000000633e3e8232ULL, 0x000fe40000000000ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000004000727306ULL, 0x0005e20000200c00ULL,
0x0000010043417824ULL, 0x042fe200078e00ffULL, 0x000000003d3d8232ULL, 0x080fe20000000000ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x000000003f3f8232ULL, 0x000fc40000000000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000004200937306ULL, 0x000fe20000200c00ULL, 0x0000888034407816ULL, 0x044fe200000000ffULL,
0x000000823c10723cULL, 0x000fe80000001810ULL, 0x000000ffff757224ULL, 0x000fe400078e0040ULL,
0x0000010034407824ULL, 0x040fe200078e00ffULL, 0x0000004100957306ULL, 0x000fe20000200c00ULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011440ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004300927306ULL, 0x0003f00000200c00ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x009800004540783bULL, 0x002e6e0000000200ULL,
0x0000007000707306ULL, 0x000ef00000200c00ULL, 0x0000007100717306ULL, 0x000f220000200c00ULL,
0x0000541077777816ULL, 0x004fce000000007aULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x000000763c20723cULL, 0x000fe20000001820ULL, 0x000054107f707816ULL, 0x008fcc0000000070ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541080717816ULL, 0x010fe20000000071ULL,
0x0000010035777824ULL, 0x040fe200078e00ffULL, 0x0000888035767816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x000000703c14723cULL, 0x000fe20000001814ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000000041418232ULL, 0x082fe20000000000ULL,
0x000054107c7c7816ULL, 0x004fe2000000007dULL, 0x0000000043438232ULL, 0x000fe20000000000ULL,
0x0000888037007816ULL, 0x000fe200000000ffULL, 0x0000006340408232ULL, 0x080fe20000000000ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000006342428232ULL, 0x000fce0000000000ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00005410496e7816ULL, 0x008fce000000006eULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x00005410866f7816ULL, 0x002fce000000006fULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x000054104b6c7816ULL, 0x004fe2000000006cULL,
0x0000006e3c0c723cULL, 0x000fec000000180cULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x000054108a6d7816ULL, 0x008fce000000006dULL, 0x0000007900917306ULL, 0x0007e20000200c00ULL,
0x000054107e7d7816ULL, 0x002fe20000000081ULL, 0x0000006c3c04723cULL, 0x040fec0000001804ULL,
0x0000003400707306ULL, 0x0003e20000200c00ULL, 0x000054107b797816ULL, 0x008fe20000000074ULL,
0x0000007c3c18723cULL, 0x000fe20000001818ULL, 0x0000541089897816ULL, 0x004fe20000000048ULL,
0x0000010036487824ULL, 0x000fc800078e00ffULL, 0x0000003500717306ULL, 0x0005e20000200c00ULL,
0x0000888036347816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000000783c1c723cULL, 0x000fe2000000181cULL, 0x00000018ff487819ULL, 0x000fc60000011448ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400497306ULL, 0x0003e20000200c00ULL,
0x0001000037357824ULL, 0x044fe400078e00ffULL, 0x000000883c08723cULL, 0x000fea0000001808ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x0000010037347824ULL, 0x002fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc80000011435ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000009000907306ULL, 0x000e700000200c00ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x0000541070707816ULL, 0x004fce0000000065ULL, 0x0000007300747306ULL, 0x000ea20000200c00ULL,
0x0000541091907816ULL, 0x002fe40000000090ULL, 0x0000541072917816ULL, 0x000fca0000000095ULL,
0x0000004800487306ULL, 0x000e640000200c00ULL, 0x000000904018723cULL, 0x000fec0000001818ULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x0000541075747816ULL, 0x004fce0000000074ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x0000541049487816ULL, 0x002fce0000000048ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x008fce000000006bULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x000054108f4b7816ULL, 0x004fce000000006aULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000004a401c723cULL, 0x000fee000000181cULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541092357816ULL, 0x002fce0000000069ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541071717816ULL, 0x004fce0000000068ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x00000070400c723cULL, 0x000fee000000180cULL,
0x0000008d008d7306ULL, 0x000ff00000200c00ULL, 0x0000008e008e7306ULL, 0x000ea20000200c00ULL,
0x000054108c8c7816ULL, 0x002fce000000008bULL, 0x0000007600767306ULL, 0x000ff00000200c00ULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x000054108d8d7816ULL, 0x004fce000000008eULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000008c4020723cULL, 0x000fee0000001820ULL,
0x00000034003d7306ULL, 0x0004e20000200c00ULL, 0x0000541076757816ULL, 0x002fce0000000077ULL,
0x0000003600377306ULL, 0x000e620000200c00ULL, 0x0000541093347816ULL, 0x004fe20000000066ULL,
0x000000744010723cULL, 0x040fec0000001810ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000541000497816ULL, 0x008fe2000000003dULL, 0x000000344014723cULL, 0x000fe20000001814ULL,
0x0000541037647816ULL, 0x002fce0000000064ULL, 0x000000484008723cULL, 0x000fe20000001808ULL,
0x000054103c657816ULL, 0x004fce0000000067ULL, 0x000000644004723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200028347f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008044377810ULL, 0x000fe20007ffe0ffULL, 0x00f690004dff7f8cULL, 0x0007e2000c80043fULL,
0x00000001274b7812ULL, 0x000fe400078ec0ffULL, 0x000000243700720cULL, 0x000fda0003f06070ULL,
0x0000389000000947ULL, 0x000fea0003800000ULL, 0x000004005b007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240028007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000347305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000340000735dULL, 0x008fe40003800000ULL,
0x0000240028347984ULL, 0x000ea40000000800ULL, 0x8000000034ff7812ULL, 0x004fc40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff467819ULL, 0x000fe20000011625ULL,
0x00000080ff637424ULL, 0x000fe200078e00ffULL, 0x00000003ff417819ULL, 0x000fe20000011631ULL,
0x000000005d0473c2ULL, 0x000ea200000e0000ULL, 0x00000001033d7810ULL, 0x000fe20007ffe0ffULL,
0x0000002046007824ULL, 0x000fe200078e0244ULL, 0x0000000441497810ULL, 0x000fe40007ffe0ffULL,
0x000000023d00720cULL, 0x000fe40003f06070ULL, 0x000000c000007810ULL, 0x000fc40007ffe0ffULL,
0x00000008414b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000024357217ULL, 0x000fe20007800000ULL,
0x000062002f377a24ULL, 0x000fe200078e0200ULL, 0x0000000c41437810ULL, 0x000fc60007ffe0ffULL,
0x0000000135007824ULL, 0x000fe200078e0a00ULL, 0x0000004137347210ULL, 0x140fe40007ffe02eULL,
0x0000004b37367210ULL, 0x140fe40007ffe02eULL, 0x00000020003d7807ULL, 0x000fe20000000000ULL,
0x00005e0034347625ULL, 0x000fe200078e0063ULL, 0x00000043373c7210ULL, 0x000fe40007ffe02eULL,
0x0000003d2e3d7217ULL, 0x000fe40007800000ULL, 0x00000032343e7210ULL, 0x000fc40007f1e0ffULL,
0x0000004937347210ULL, 0x100fe20007ffe02eULL, 0x000000013d007824ULL, 0x000fe400078e0a2eULL,
0x000000ffff3f7224ULL, 0x000fe400000e0635ULL, 0x00005e0034347625ULL, 0x080fe200078e0063ULL,
0x000000004100720cULL, 0x080fe40003f46070ULL, 0x000000004900720cULL, 0x000fe20003f06070ULL,
0x00005e0036367625ULL, 0x000fe200078e0063ULL, 0x0000003234347210ULL, 0x000fc40007f7e0ffULL,
0x000000004300720cULL, 0x000fe20003f86070ULL, 0x00005e003c3c7625ULL, 0x000fe200078e0063ULL,
0x0000003236367210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff357224ULL, 0x000fe200018e0635ULL,
0x000000004b00720cULL, 0x000fe20003f66070ULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x000000323c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e4e7faeULL, 0x0007e8000d101c46ULL, 0x000000ffff3d7224ULL, 0x000fe200030e063dULL,
0x00000000344f7faeULL, 0x0007ea000c101c46ULL, 0x00000000365f7faeULL, 0x0007e8000d901c46ULL,
0x000000003c607faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005d4e7f8cULL, 0x0084e8000c80043fULL,
0x0000040057007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480030347f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x010fc60007844861ULL, 0x00f64c0030377984ULL, 0x000f240000000800ULL,
0x8000000037ff7812ULL, 0x010fe40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000367305ULL, 0x000964000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x000000360000735dULL, 0x020fe20003800000ULL,
0x00f64c0030377984ULL, 0x000f240000000800ULL, 0x8000000037ff7812ULL, 0x010fc40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010032357810ULL, 0x000fca0007ffe033ULL,
0x0000000138357824ULL, 0x000fca00078e0235ULL, 0x00f0000035377984ULL, 0x000f280000000800ULL,
0x00f2000035007984ULL, 0x0002a20000000800ULL, 0x0000002a3700720bULL, 0x010fe20003f1d000ULL,
0x0000bae27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x002fc800000e0100ULL,
0x0000ffff343e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff777424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000225347811ULL, 0x000fe400078ff0ffULL, 0x0000002a3700720bULL, 0x000fe40003f14000ULL,
0x000000253400720cULL, 0x000fe20003f65270ULL, 0x0000baa27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x000000372a357209ULL, 0x000fe20007810000ULL,
0x00000080253db824ULL, 0x000fc800078e0232ULL, 0x800000352a367221ULL, 0x000fe20000010000ULL,
0x00000001383cb824ULL, 0x000fe200078e023dULL, 0x0000ffff343d7812ULL, 0x000fe400078e3cffULL,
0x3fb8aa3b36367820ULL, 0x000fe40000410000ULL, 0x00f400353c00b388ULL, 0x0003e20000000800ULL,
0x0000003d3eff7212ULL, 0x000fe4000780c0ffULL, 0x00000002ff3e7819ULL, 0x000fe20000011631ULL,
0x0000003600367308ULL, 0x000f240000000800ULL, 0x0000003629297220ULL, 0x010fe20000410000ULL,
0x0000ba227f007947ULL, 0x000fea000b800000ULL, 0x00001f3e36347589ULL, 0x00232400000e0000ULL,
0x0000003420207220ULL, 0x090fe20000410000ULL, 0x0000003421217220ULL, 0x080fe20000410000ULL,
0x000000341c1c7220ULL, 0x080fe20000410000ULL, 0x000000341d1d7220ULL, 0x080fe20000410000ULL,
0x0000003418187220ULL, 0x080fe20000410000ULL, 0x0000003419197220ULL, 0x080fe20000410000ULL,
0x0000003414147220ULL, 0x080fe20000410000ULL, 0x0000003415157220ULL, 0x080fe20000410000ULL,
0x0000003410107220ULL, 0x080fe20000410000ULL, 0x0000003411117220ULL, 0x080fe20000410000ULL,
0x000000340c0c7220ULL, 0x080fe20000410000ULL, 0x000000340d0d7220ULL, 0x080fe20000410000ULL,
0x0000003408087220ULL, 0x080fe20000410000ULL, 0x0000003409097220ULL, 0x080fe20000410000ULL,
0x0000003404047220ULL, 0x080fe20000410000ULL, 0x0000003405057220ULL, 0x000fe20000410000ULL,
0x0000b9727f007947ULL, 0x000fea000b800000ULL, 0x00001f3a36347589ULL, 0x00086400000e0000ULL,
0x000000372a2a7209ULL, 0x000fe20007810000ULL, 0x0000003422227220ULL, 0x082fe20000410000ULL,
0x00000001ff777807ULL, 0x000fe20000000000ULL, 0x0000003423237220ULL, 0x080fe20000410000ULL,
0x000000341e1e7220ULL, 0x080fe20000410000ULL, 0x8000002a37370221ULL, 0x000fe20000010000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b37370820ULL, 0x000fe20000410000ULL,
0x0000003416167220ULL, 0x080fe20000410000ULL, 0x0000003417177220ULL, 0x080fe20000410000ULL,
0x0000003412127220ULL, 0x080fe20000410000ULL, 0x0000003700260308ULL, 0x000e620000000800ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x000000340e0e7220ULL, 0x080fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x000000340a0a7220ULL, 0x080fe20000410000ULL,
0x000000340b0b7220ULL, 0x080fe20000410000ULL, 0x0000003406067220ULL, 0x080fe20000410000ULL,
0x0000003407077220ULL, 0x000fe20000410000ULL, 0x0000000026000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000002900297221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000855357812ULL, 0x000fe400078ec0ffULL, 0xfffffff02d007812ULL, 0x000fca00078ec0ffULL,
0x0000000100357824ULL, 0x000fca00078e0235ULL, 0x00f6ac0035007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000347305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000340000735dULL, 0x004fe40003800000ULL, 0x00f6ac0035347984ULL, 0x000e640000000800ULL,
0x8000000034ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe40000011631ULL, 0x00000026ff00723eULL, 0x000fe400000000ffULL,
0x000000183e367810ULL, 0x050fe40007ffe0ffULL, 0x000000103e377810ULL, 0x000fe40007ffe0ffULL,
0x00005410003d7816ULL, 0x000fe20000000000ULL, 0x0000b6e27f007947ULL, 0x000fea000b800000ULL,
0x00001f3e3d5f7589ULL, 0x0002a400000e0000ULL, 0x0000b7227f007947ULL, 0x000fea000b800000ULL,
0x00001f3a3d007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e0037ULL, 0x00005a1000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000bf8000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e0036ULL, 0x00005a7000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000bf2000007944ULL, 0x01cfea0003c00000ULL, 0x0000100062417812ULL, 0x000fe200078ec0ffULL,
0x0000100025407824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000991077777816ULL, 0x000fe400000000ffULL, 0x0000b0002c347810ULL, 0x000fe40007ffe041ULL,
0xffffe00040407812ULL, 0x000fc400078ec0ffULL, 0x000000ff7700720cULL, 0x000fe20003f05270ULL,
0x00000010533c7824ULL, 0x104fe200078e0234ULL, 0x0000b00040487810ULL, 0x000fe20007ffe041ULL,
0x0000001054347824ULL, 0x000fc800078e0234ULL, 0x000000104c407824ULL, 0x100fe200078e0248ULL,
0x000000003c3c783bULL, 0x010e620000004200ULL, 0x0000001047487824ULL, 0x000fc600078e0248ULL,
0x000000003434783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000ea80000004200ULL,
0x000000004848783bULL, 0x000f220000004200ULL, 0x00000018ff657819ULL, 0x002fe2000001143fULL,
0x000001003d677824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001143cULL,
0x000001003e6d7824ULL, 0x000fe200078e00ffULL, 0x0000006500477306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fc4000001143dULL, 0x000088803d667816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x004fe20000011440ULL,
0x00000100417c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe2000001143eULL,
0x0001000043857824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x002fe20000011441ULL,
0x00000064007b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0001000049777824ULL, 0x010fe200078e00ffULL, 0x000088803e6a7816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146dULL,
0x0000010048877824ULL, 0x000fe200078e00ffULL, 0x000088803f6d7816ULL, 0x000fe200000000ffULL,
0x00000065007d7306ULL, 0x0005e20000200c00ULL, 0x000088803c647816ULL, 0x002fe200000000ffULL,
0x0000010049887824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000001004a8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fc40000011442ULL,
0x00008880427f7816ULL, 0x000fe200000000ffULL, 0x0000003d006b7306ULL, 0x0003e20000200c00ULL,
0x000001003c657824ULL, 0x044fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe20000011443ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000888043837816ULL, 0x000fe400000000ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000100343d7824ULL, 0x002fe200078e00ffULL, 0x0000003e00727306ULL, 0x000fe20000200c00ULL,
0x00000018ff707819ULL, 0x000fc40000011448ULL, 0x0000888048867816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe2000001143dULL,
0x00000100403d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000003c00697306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff717819ULL, 0x000fc40000011449ULL,
0x00000018ff687819ULL, 0x000fe2000001144aULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001144bULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff857819ULL, 0x000fc40000011485ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x00000018ff617819ULL, 0x000fe20000011434ULL, 0x0000003c006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff637819ULL, 0x000fe40000011435ULL, 0x0000888034737816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035757816ULL, 0x000fc400000000ffULL,
0x00000018ff607819ULL, 0x000fe20000011436ULL, 0x0000003f00747306ULL, 0x0005e20000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff787819ULL, 0x000fe4000001143cULL, 0x00008880403c7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00008880413f7816ULL, 0x044fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000077008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff357819ULL, 0x000fc40000011435ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff627819ULL, 0x000fe20000011437ULL,
0x00000040003e7306ULL, 0x0002a20000200c00ULL, 0x00000018ff677819ULL, 0x000fce0000011467ULL,
0x00000041007e7306ULL, 0x0009e20000200c00ULL, 0x0000010042407824ULL, 0x042fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011440ULL,
0x0000010043407824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011442ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x000054103e3e7816ULL, 0x004fe2000000007bULL,
0x000100004b7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011440ULL,
0x00a000003b40783bULL, 0x010ea40000000200ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000003f003f7306ULL, 0x000f220000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000008100827306ULL, 0x0003e20000200c00ULL, 0x000054103f3d7816ULL, 0x010fce000000007cULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054107e3f7816ULL, 0x000fe4000000007dULL,
0x0000888049817816ULL, 0x002fca00000000ffULL, 0x0000008100897306ULL, 0x0003f00000200c00ULL,
0x0000004800497306ULL, 0x0009e20000200c00ULL, 0x000088804a817816ULL, 0x042fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000005f40408232ULL, 0x004fc40000000000ULL,
0x0000005f42428232ULL, 0x000fe40000000000ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000000041418232ULL, 0x080fe20000000000ULL, 0x000088804b487816ULL, 0x050fe200000000ffULL,
0x0000000043438232ULL, 0x000fe20000000000ULL, 0x0000006c006c7306ULL, 0x000fec0000200c00ULL,
0x0000003c4020723cULL, 0x040fe40000001820ULL, 0x0000004800487306ULL, 0x000fea0000200c00ULL,
0x000001004b3c7824ULL, 0x000fe200078e00ffULL, 0x0000003e401c723cULL, 0x000fe4000000181cULL,
0x0000004a004b7306ULL, 0x000fe40000200c00ULL, 0x00000018ff777819ULL, 0x000fc4000001143cULL,
0x00a00000453c783bULL, 0x000e680000000200ULL, 0x0000007700777306ULL, 0x000eb00000200c00ULL,
0x0000007b007b7306ULL, 0x000ff00000200c00ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x00005410488d7816ULL, 0x004fce0000000077ULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x0000005f3c3c8232ULL, 0x082fe40000000000ULL,
0x0000005f3e3e8232ULL, 0x000fca0000000000ULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x000000003d3d8232ULL, 0x080fe40000000000ULL, 0x000000003f3f8232ULL, 0x000fca0000000000ULL,
0x0000007900797306ULL, 0x000eb00000200c00ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x0000541086867816ULL, 0x002fce0000000087ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541082827816ULL, 0x004fce0000000079ULL, 0x0000007100717306ULL, 0x000eb00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541049707816ULL, 0x002fe40000000070ULL,
0x0000888036497816ULL, 0x000fca00000000ffULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x000054108a717816ULL, 0x004fce0000000071ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x00000070400c723cULL, 0x000fee000000180cULL, 0x0000008800887306ULL, 0x000f220000200c00ULL,
0x000054107f807816ULL, 0x002fce0000000080ULL, 0x00000081008c7306ULL, 0x0003f00000200c00ULL,
0x0000008b008b7306ULL, 0x000f620000200c00ULL, 0x0000541083817816ULL, 0x002fe40000000084ULL,
0x0000541085837816ULL, 0x004fc4000000007aULL, 0x0000541089877816ULL, 0x010fc60000000088ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000000804018723cULL, 0x040fee0000001818ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000054108c8c7816ULL, 0x020fe2000000008bULL,
0x000000824014723cULL, 0x040fec0000001814ULL, 0x00000034004a7306ULL, 0x0005e40000200c00ULL,
0x000000864010723cULL, 0x040fec0000001810ULL, 0x0000003500487306ULL, 0x0009e20000200c00ULL,
0x000054104b347816ULL, 0x004fe20000000068ULL, 0x0000008c4008723cULL, 0x000fe20000001808ULL,
0x00000100364b7824ULL, 0x000fc400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000054107b357816ULL, 0x010fe4000000006cULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff367819ULL, 0x000fc60000011436ULL,
0x000000344004723cULL, 0x000fe20000001804ULL, 0x0000006100617306ULL, 0x000eac0000200c00ULL,
0x0000888037347816ULL, 0x040fe200000000ffULL, 0x0000010037407824ULL, 0x000fe200078e00ffULL,
0x000054106b357816ULL, 0x002fe20000000054ULL, 0x0000006400647306ULL, 0x000fe60000200c00ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x000054104a4a7816ULL, 0x004fc60000000061ULL,
0x0000003400417306ULL, 0x0003f00000200c00ULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x0000541069347816ULL, 0x002fce000000004cULL, 0x000000343c1c723cULL, 0x000fe2000000181cULL,
0x0000006300637306ULL, 0x000fec0000200c00ULL, 0x0001000037347824ULL, 0x000fe200078e00ffULL,
0x0000541074357816ULL, 0x000fe20000000047ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541064647816ULL, 0x004fc40000000065ULL, 0x00000018ff427819ULL, 0x000fe40000011434ULL,
0x0000541072347816ULL, 0x000fc60000000053ULL, 0x0000006200627306ULL, 0x000fe80000200c00ULL,
0x000000343c14723cULL, 0x000fe80000001814ULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000006700677306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000ff00000200c00ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541066657816ULL, 0x002fce0000000067ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x000000643c20723cULL, 0x000fee0000001820ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054106a6a7816ULL, 0x004fce000000006fULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054106d6b7816ULL, 0x002fce000000006eULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000006a3c18723cULL, 0x000fee0000001818ULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x0000541073747816ULL, 0x004fce0000000076ULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000004b00007306ULL, 0x0005220000200c00ULL,
0x0000541075757816ULL, 0x002fce0000000078ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x00005410484b7816ULL, 0x004fe20000000063ULL, 0x000000743c10723cULL, 0x040fec0000001810ULL,
0x0000003600377306ULL, 0x000ea20000200c00ULL, 0x0000541049347816ULL, 0x010fe20000000000ULL,
0x0000004a3c0c723cULL, 0x000fec000000180cULL, 0x0000004200437306ULL, 0x000f220000200c00ULL,
0x0000541041357816ULL, 0x002fc40000000040ULL, 0x0000541037607816ULL, 0x004fca0000000060ULL,
0x000000343c08723cULL, 0x000fe20000001808ULL, 0x0000541043617816ULL, 0x010fce0000000062ULL,
0x000000603c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200028347f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c044377810ULL, 0x000fe20007ffe0ffULL,
0x00f698004dff7f8cULL, 0x0009e2000c80043fULL, 0x00000001274b7812ULL, 0x000fe200078e0cffULL,
0x000000ffff617224ULL, 0x008fe200078e004fULL, 0x000000243700720cULL, 0x000fda0003f06070ULL,
0x00001c1000000947ULL, 0x000fea0003800000ULL, 0x000004005b007984ULL, 0x010ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240028007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000347305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000340000735dULL, 0x008fe40003800000ULL,
0x0000240028347984ULL, 0x000ea40000000800ULL, 0x8000000034ff7812ULL, 0x004fc40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff467819ULL, 0x000fe20000011625ULL,
0x00000080ff437424ULL, 0x000fe200078e00ffULL, 0x0000030003357a10ULL, 0x000fe20007ffe0ffULL,
0x00000000570473c2ULL, 0x0004e200000e0000ULL, 0x00000003ff407819ULL, 0x000fe40000011631ULL,
0x0000000135377810ULL, 0x040fe20007ffe0ffULL, 0x0000000835007824ULL, 0x000fe200078e0246ULL,
0x0000000440427810ULL, 0x000fe40007ffe0ffULL, 0x000000023700720cULL, 0x000fe20003f06070ULL,
0x0000002000007824ULL, 0x000fe200078e00ffULL, 0x0000000c40447810ULL, 0x000fc40007ffe0ffULL,
0x0000000855557812ULL, 0x000fe200078ec0ffULL, 0x000062002f3f7a24ULL, 0x000fe200078e0200ULL,
0x00000000243d7217ULL, 0x000fc60007800000ULL, 0x0000000156607824ULL, 0x000fe200078e0255ULL,
0x000000403f347210ULL, 0x000fe20007ffe02eULL, 0x000000013d3d7824ULL, 0x000fe200078e0a00ULL,
0x000000423f367210ULL, 0x000fe40007ffe02eULL, 0x0000000840007810ULL, 0x000fe20007ffe0ffULL,
0x00005e0034347625ULL, 0x000fe200078e0043ULL, 0x000000203d417807ULL, 0x000fc60000000000ULL,
0x00005e0036367625ULL, 0x000fe200078e0043ULL, 0x000000412e417217ULL, 0x000fe40007800000ULL,
0x00000032343c7210ULL, 0x080fe40007f5e0ffULL, 0x00000032363e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000141417824ULL, 0x100fe200078e0a2eULL, 0x000000003f347210ULL, 0x140fe20007ffe02eULL,
0x000000ffff3d7224ULL, 0x000fe200010e0635ULL, 0x000000443f367210ULL, 0x000fe20007ffe02eULL,
0x000000ffff3f7224ULL, 0x000fe200000e0637ULL, 0x000000414000720cULL, 0x000fe20003f06070ULL,
0x00005e0034347625ULL, 0x000fe200078e0043ULL, 0x000000414200720cULL, 0x000fc40003f46070ULL,
0x000000410000720cULL, 0x000fe20003f66070ULL, 0x00005e0036367625ULL, 0x000fe200078e0043ULL,
0x000000414400720cULL, 0x000fe40003f86070ULL, 0x0000003234347210ULL, 0x080fe40007fbe0ffULL,
0x0000003236367210ULL, 0x000fc60007fde0ffULL, 0x000000ffff357224ULL, 0x000fe200028e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c587faeULL, 0x0009e2000c101c46ULL,
0x000000ffff377224ULL, 0x000fc600030e0637ULL, 0x000000003e597faeULL, 0x0009e8000d101c46ULL,
0x00000000345a7faeULL, 0x0009e8000d901c46ULL, 0x00000000365c7faeULL, 0x0009e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000060607f8cULL, 0x000ea8000c80043fULL, 0x000004005d5d7984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680030347f8cULL, 0x010fe2000c80043fULL, 0x800000005dff7812ULL, 0x008fc6000784484fULL,
0x00f66c0030377984ULL, 0x000ee40000000800ULL, 0x8000000037ff7812ULL, 0x008fe40007804835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000367305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000360000735dULL, 0x010fe20003800000ULL, 0x00f66c0030377984ULL, 0x000ee40000000800ULL,
0x8000000037ff7812ULL, 0x008fc40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018032337810ULL, 0x000fca0007ffe033ULL, 0x0000000138337824ULL, 0x000fca00078e0233ULL,
0x00f0000033377984ULL, 0x000ee80000000800ULL, 0x00f2000033007984ULL, 0x0008620000000800ULL,
0x0000002a3700720bULL, 0x008fe20003f1d000ULL, 0x0000a0927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x010fc800000e0100ULL, 0x0000ffff30337812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff537424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000325307811ULL, 0x000fe400078ff0ffULL,
0x0000002a3700720bULL, 0x000fe40003f14000ULL, 0x000000253000720cULL, 0x000fe20003f65270ULL,
0x0000a0527f007947ULL, 0x000ff4000b800000ULL, 0x0000000000307806ULL, 0x000fe400000e0100ULL,
0x000000372a367209ULL, 0x000fe20007810000ULL, 0x000000802535b824ULL, 0x000fe200078e0232ULL,
0x0000ffff30307812ULL, 0x000fe400078e3cffULL, 0x00000002ff3e7819ULL, 0x000fe20000011631ULL,
0x000000013835b824ULL, 0x000fe200078e0235ULL, 0x800000362a2a7221ULL, 0x000fe20000010000ULL,
0x0000003033ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b2a2a7820ULL, 0x000fe20000410000ULL,
0x00f400363500b388ULL, 0x0007e60000000800ULL, 0x0000002a003d7308ULL, 0x000f240000000800ULL,
0x0000003d29297220ULL, 0x010fe20000410000ULL, 0x00009fd27f007947ULL, 0x000fea000b800000ULL,
0x00001f3e3d2a7589ULL, 0x00872400000e0000ULL, 0x0000002a20207220ULL, 0x090fe20000410000ULL,
0x0000002a21217220ULL, 0x080fe20000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a10107220ULL, 0x080fe20000410000ULL,
0x0000002a11117220ULL, 0x080fe20000410000ULL, 0x0000002a0c0c7220ULL, 0x080fe20000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002a08087220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x0000002a04047220ULL, 0x080fe20000410000ULL,
0x0000002a05057220ULL, 0x000fe20000410000ULL, 0x00009f127f007947ULL, 0x000fea000b800000ULL,
0x00001f3a3d2a7589ULL, 0x0008e400000e0000ULL, 0x8000003637370221ULL, 0x100fe20000010000ULL,
0x0000002a22227220ULL, 0x088fe20000410000ULL, 0x0000002a23237220ULL, 0x080fe20000410000ULL,
0x0000002a1e1e7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b37370820ULL, 0x000fe20000410000ULL,
0x0000002a1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002a1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003700260308ULL, 0x000ee20000000800ULL,
0x0000002a16167220ULL, 0x080fe20000410000ULL, 0x0000002a17177220ULL, 0x080fe20000410000ULL,
0x0000002a12127220ULL, 0x080fe20000410000ULL, 0x0000002a13137220ULL, 0x080fe20000410000ULL,
0x0000002a0e0e7220ULL, 0x080fe20000410000ULL, 0x0000002a0f0f7220ULL, 0x080fe20000410000ULL,
0x0000002a0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002a0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002a06067220ULL, 0x080fe20000410000ULL, 0x0000002a07077220ULL, 0x000fe20000410000ULL,
0x00000001ff537807ULL, 0x000fe20000000000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0036ULL,
0x0000000026000220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000002900297221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff02d337812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100307824ULL, 0x000fca00078e0233ULL, 0x00f6ac0030337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000327305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x008fe20003800000ULL, 0x00f6ac0030337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc4000780484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe40000011631ULL, 0x00000026ff00723eULL, 0x000fe400000000ffULL,
0x000000183e307810ULL, 0x040fe40007ffe0ffULL, 0x000000103e327810ULL, 0x000fe40007ffe0ffULL,
0x00005410003d7816ULL, 0x010fe20000000000ULL, 0x00009c627f007947ULL, 0x000fea000b800000ULL,
0x00001f3e3d337589ULL, 0x0002e400000e0000ULL, 0x00009ca27f007947ULL, 0x000fea000b800000ULL,
0x00001f3a3d007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e0032ULL, 0x000076d000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000a2c000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e0030ULL, 0x0000773000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000a26000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005e5c783bULL, 0x000f620000004200ULL, 0x0000991053537816ULL, 0x000fc600000000ffULL,
0x000000005240783bULL, 0x0023220000004200ULL, 0x000000ff5300720cULL, 0x000fc60003f05270ULL,
0x00000000513c783bULL, 0x0145280000004200ULL, 0x000000005034783bULL, 0x0006a20000004200ULL,
0x00000018ff397819ULL, 0x020fe2000001145fULL, 0x000001005d527824ULL, 0x002fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe4000001145eULL, 0x0000003900627306ULL, 0x0003e20000200c00ULL,
0x00000018ff307819ULL, 0x000fc4000001145cULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x000088805d3a7816ULL, 0x000fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe20000011440ULL,
0x0000003800607306ULL, 0x000be20000200c00ULL, 0x000001005c397824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011442ULL, 0x00000018ff4c7819ULL, 0x000fe40000011443ULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x0000005200597306ULL, 0x0003e20000200c00ULL,
0x000088805c387816ULL, 0x060fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x004fe40000011441ULL, 0x0000888041667816ULL, 0x000fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000003900557306ULL, 0x0005e20000200c00ULL,
0x000001005f527824ULL, 0x002fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x010fc4000001143cULL,
0x00000018ff4b7819ULL, 0x000fe4000001143dULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000003800507306ULL, 0x0083e20000200c00ULL, 0x000001005e397824ULL, 0x004fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe4000001143eULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x0000003a00567306ULL, 0x0005e20000200c00ULL, 0x000088805e387816ULL, 0x042fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe4000001143fULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000003900637306ULL, 0x0003e20000200c00ULL, 0x000088805f3a7816ULL, 0x004fe400000000ffULL,
0x00000018ff477819ULL, 0x000fc40000011435ULL, 0x00000018ff447819ULL, 0x000fc60000011437ULL,
0x00000038005a7306ULL, 0x0005e20000200c00ULL, 0x0000888040397816ULL, 0x002fce00000000ffULL,
0x0000003900647306ULL, 0x0003e20000200c00ULL, 0x000100005f387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005c00577306ULL, 0x000fe20000200c00ULL,
0x0000010042397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a005c7306ULL, 0x0003f00000200c00ULL, 0x0000003800677306ULL, 0x0005e20000200c00ULL,
0x00000100403a7824ULL, 0x002fc400078e00ffULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000005200657306ULL, 0x0003e20000200c00ULL,
0x0000888042387816ULL, 0x044fe200000000ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc80000011440ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x00000039006d7306ULL, 0x0005e20000200c00ULL, 0x0000010041527824ULL, 0x042fe400078e00ffULL,
0x0001000041417824ULL, 0x000fca00078e00ffULL, 0x00000038006a7306ULL, 0x0002e20000200c00ULL,
0x000001003c397824ULL, 0x004fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc80000011441ULL,
0x00000018ff6c7819ULL, 0x000fe20000011439ULL, 0x000001003d397824ULL, 0x000fe200078e00ffULL,
0x0000005e005f7306ULL, 0x0005e20000200c00ULL, 0x0001000043387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003a00697306ULL, 0x0003220000200c00ULL,
0x00000018ff5e7819ULL, 0x004fe40000011452ULL, 0x000054106a6a7816ULL, 0x008fca000000006dULL,
0x0000004000527306ULL, 0x0005e20000200c00ULL, 0x00008880433a7816ULL, 0x002fce00000000ffULL,
0x0000005e006b7306ULL, 0x000fe20000200c00ULL, 0x0000010043407824ULL, 0x004fe200078e00ffULL,
0x0000541064647816ULL, 0x010fc80000000069ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004200437306ULL, 0x0003f00000200c00ULL, 0x0000003a005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x002fce0000011439ULL, 0x0000003800717306ULL, 0x0003f00000200c00ULL,
0x0000004100687306ULL, 0x0005e20000200c00ULL, 0x00a800003b38783bULL, 0x002e6e0000000200ULL,
0x00000040006f7306ULL, 0x0007e20000200c00ULL, 0x000088803c417816ULL, 0x044fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006c00737306ULL, 0x000fe20000200c00ULL, 0x000088803d407816ULL, 0x048fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c00757306ULL, 0x0005f00000200c00ULL, 0x0000003d006c7306ULL, 0x0007e20000200c00ULL,
0x000088803f3c7816ULL, 0x004fce00000000ffULL, 0x0000003c00747306ULL, 0x0005e20000200c00ULL,
0x0000003338388232ULL, 0x082fe20000000000ULL, 0x00005410563d7816ULL, 0x008fe20000000059ULL,
0x000000333a3a8232ULL, 0x000fe40000000000ULL, 0x0000000039398232ULL, 0x080fe40000000000ULL,
0x000000003b3b8232ULL, 0x000fe20000000000ULL, 0x00000041006e7306ULL, 0x0002e20000200c00ULL,
0x00005410503c7816ULL, 0x004fe40000000055ULL, 0x0000888035507816ULL, 0x000fca00000000ffULL,
0x0000004000707306ULL, 0x0005e20000200c00ULL, 0x000001003e417824ULL, 0x042fe200078e00ffULL,
0x0000003c3820723cULL, 0x000fe80000001820ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004200777306ULL, 0x0003e20000200c00ULL, 0x000088803e407816ULL, 0x044fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000054106e6e7816ULL, 0x008fe20000000073ULL,
0x00000100343c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003000547306ULL, 0x0004e20000200c00ULL, 0x000001003f427824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003200587306ULL, 0x0003e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff307819ULL, 0x004fca0000011436ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000541057547816ULL, 0x008fe40000000054ULL, 0x00000018ff327819ULL, 0x002fca0000011434ULL,
0x0000004100797306ULL, 0x0003f00000200c00ULL, 0x0000003e00537306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x002fe4000001143cULL, 0x000054105d557816ULL, 0x004fca0000000058ULL,
0x0000003f00767306ULL, 0x0003e40000200c00ULL, 0x00000054381c723cULL, 0x000fec000000181cULL,
0x0000004000727306ULL, 0x0004e20000200c00ULL, 0x00a80000453c783bULL, 0x002e6e0000000200ULL,
0x00000042007b7306ULL, 0x000f220000200c00ULL, 0x0000888034407816ULL, 0x044fe200000000ffULL,
0x0001000034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000004000427306ULL, 0x0005e20000200c00ULL, 0x0000541072727816ULL, 0x008fce0000000079ULL,
0x0000004100557306ULL, 0x0007620000200c00ULL, 0x000054105a407816ULL, 0x004fe40000000063ULL,
0x0000541074737816ULL, 0x010fca000000007bULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x000054105c417816ULL, 0x008fce0000000065ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000000403818723cULL, 0x000fe20000001818ULL, 0x000000333c3c8232ULL, 0x082fe20000000000ULL,
0x0000541042427816ULL, 0x020fe20000000055ULL, 0x000000333e3e8232ULL, 0x000fe20000000000ULL,
0x0000010036337824ULL, 0x000fe200078e00ffULL, 0x000000003d3d8232ULL, 0x080fe40000000000ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000000ffff407224ULL, 0x000fe200078e0050ULL,
0x0000541067417816ULL, 0x000fe20000000062ULL, 0x0000010035507824ULL, 0x000fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x000000003f3f8232ULL, 0x000fe20000000000ULL,
0x0000888037007816ULL, 0x000fc400000000ffULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000541066657816ULL, 0x004fe4000000006bULL,
0x000054105e6b7816ULL, 0x000fe4000000006fULL, 0x00005410706f7816ULL, 0x000fe20000000077ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x0000541068517816ULL, 0x002fe20000000051ULL,
0x000000643810723cULL, 0x040fec0000001810ULL, 0x0000004000547306ULL, 0x0003e20000200c00ULL,
0x00005410434e7816ULL, 0x008fe2000000004eULL, 0x0000006a3808723cULL, 0x000fec0000001808ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x000054105f407816ULL, 0x002fe20000000060ULL,
0x0000006e3c20723cULL, 0x000fec0000001820ULL, 0x0000004700477306ULL, 0x000fe40000200c00ULL,
0x000000403814723cULL, 0x000fec0000001814ULL, 0x0000005000417306ULL, 0x0002e20000200c00ULL,
0x0001000035407824ULL, 0x000fe200078e00ffULL, 0x000000723c18723cULL, 0x000fe80000001818ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x0000003400357306ULL, 0x0009620000200c00ULL,
0x0000541052507816ULL, 0x002fe4000000004fULL, 0x00005410714f7816ULL, 0x004fca000000004cULL,
0x00000050380c723cULL, 0x000fe2000000180cULL, 0x0000888036347816ULL, 0x050fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541054437816ULL, 0x008fc60000000041ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000004e3804723cULL, 0x000fe20000001804ULL, 0x0000541035327816ULL, 0x020fe40000000032ULL,
0x0000003300397306ULL, 0x0003e80000200c00ULL, 0x0000010037387824ULL, 0x040fe200078e00ffULL,
0x000000423c10723cULL, 0x000fe60000001810ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x0001000037337824ULL, 0x002fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc80000011438ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000004b004b7306ULL, 0x000e700000200c00ULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x00005410754a7816ULL, 0x004fce000000004aULL,
0x0000004900497306ULL, 0x000ea20000200c00ULL, 0x000054106c4b7816ULL, 0x002fce000000004bULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x0000541053487816ULL, 0x008fe20000000048ULL,
0x0000004a3c1c723cULL, 0x000fec000000181cULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541076497816ULL, 0x004fce0000000049ULL, 0x0000003400347306ULL, 0x000e620000200c00ULL,
0x000000483c14723cULL, 0x000fee0000001814ULL, 0x0000000000007306ULL, 0x000ff00000200c00ULL,
0x00000038003b7306ULL, 0x000ea20000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000039ULL,
0x0000003600377306ULL, 0x000e700000200c00ULL, 0x0000003300457306ULL, 0x0007220000200c00ULL,
0x0000541000357816ULL, 0x004fce000000003bULL, 0x000000343c08723cULL, 0x000fe20000001808ULL,
0x0000541040337816ULL, 0x008fce0000000047ULL, 0x000000323c0c723cULL, 0x000fee000000180cULL,
0x0000541037327816ULL, 0x002fe40000000030ULL, 0x0000541045337816ULL, 0x010fce0000000044ULL,
0x000000323c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200028327f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0004dff7f8cULL, 0x0007e2000c80043fULL,
0x00000001274b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff357224ULL, 0x004fe400078e0033ULL,
0x0000030003037a10ULL, 0x018fc80007ffe0ffULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff86a000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff337224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe400078e0017ULL, 0x000000ffff327224ULL, 0x000fe400078e0007ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff307224ULL, 0x000fe400078e0005ULL,
0x000000ffff397224ULL, 0x000fc400078e0004ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000bULL,
0x000000ffff377224ULL, 0x000fe400078e000aULL, 0x000000ffff287224ULL, 0x002fe400078e0009ULL,
0x000000ffff357224ULL, 0x000fe400078e0008ULL, 0x000000ffff267224ULL, 0x008fe400078e000fULL,
0x000000ffff247224ULL, 0x000fe200078e000dULL, 0x0000000402007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff317224ULL, 0x000fc400078e000cULL, 0x000000ffff2f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0011ULL, 0x000000ffff277224ULL, 0x000fe400078e0016ULL,
0x000000ffff177224ULL, 0x000fc800078e0015ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000029007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000883000067802ULL, 0x000fe40000000f00ULL,
0x00008f9000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000029ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000077919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000807047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000002000207220ULL, 0x044fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001700177220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x000fe20000410000ULL,
0x0000002204227220ULL, 0x048fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x0000000400067811ULL, 0x000fe400078ff8ffULL,
0x0000000803157811ULL, 0x000fe400078ff0ffULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000704057812ULL, 0x000fc400078e780dULL, 0x0000000706087812ULL, 0x040fe400078e780dULL,
0x0000000706067812ULL, 0x000fe200078e7815ULL, 0x000000080d097824ULL, 0x000fe200078e0205ULL,
0x00000006000a7811ULL, 0x000fe200078ff8ffULL, 0x000010002b057824ULL, 0x000fe200078e00ffULL,
0x0000000702007812ULL, 0x100fe200078e780dULL, 0x0000000815137824ULL, 0x000fe200078e0206ULL,
0x000000070a0c7812ULL, 0x000fe200078e780dULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x100fe200078e7815ULL, 0x000000080d077824ULL, 0x040fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078e7815ULL, 0x0000080046007824ULL, 0x000fe200078e0205ULL,
0x000000070a0a7812ULL, 0x000fe200078e7815ULL, 0x000000080d0b7824ULL, 0x000fe200078e0208ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x00000008150f7824ULL, 0x000fe200078e0202ULL,
0x000000202102723eULL, 0x000fe200000000ffULL, 0x0000000815117824ULL, 0x000fe200078e0204ULL,
0x0000001c1d04723eULL, 0x000fe200000000ffULL, 0x000000080d0d7824ULL, 0x000fc400078e020cULL,
0x0000000815157824ULL, 0x000fe200078e020aULL, 0x0000541002167816ULL, 0x000fe20000000004ULL,
0x0000001007077824ULL, 0x100fe400078e0200ULL, 0x0000001009097824ULL, 0x100fe400078e0200ULL,
0x000000100b0b7824ULL, 0x100fe400078e0200ULL, 0x000000100f0f7824ULL, 0x100fe400078e0200ULL,
0x0000001011117824ULL, 0x000fc400078e0200ULL, 0x000000100d0d7824ULL, 0x100fe400078e0200ULL,
0x0000001013137824ULL, 0x100fe400078e0200ULL, 0x0000001015157824ULL, 0x000fe400078e0200ULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x000000141707723eULL, 0x000fe200000000ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x0000763202177816ULL, 0x000fe20000000004ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x000000102d02723eULL, 0x000fe200000000ffULL,
0x00000001060f7824ULL, 0x000fe200078e020fULL, 0x000000312404723eULL, 0x000fe200000000ffULL,
0x0000000106117824ULL, 0x040fe200078e0211ULL, 0x0000001608007388ULL, 0x0005e20000000a00ULL,
0x00000001060d7824ULL, 0x000fc400078e020dULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x000000181906723eULL, 0x000fe200000000ffULL,
0x00000020460a7824ULL, 0x000fe400078e0203ULL, 0x00000300ff147624ULL, 0x000fe200078e00ffULL,
0x0000541006167816ULL, 0x144fe40000000007ULL, 0x0000763206177816ULL, 0x000fe40000000007ULL,
0x0000541002087816ULL, 0x000fc40000000004ULL, 0x000000352806723eULL, 0x000fe200000000ffULL,
0x0000001609007388ULL, 0x0005e20000000a00ULL, 0x000000393007723eULL, 0x000fe400000000ffULL,
0x000000011400780cULL, 0x000fe40003f05270ULL, 0x0000763202097816ULL, 0x004fe40000000004ULL,
0x000000222302723eULL, 0x000fe400000000ffULL, 0x0000001e1f04723eULL, 0x000fe200000000ffULL,
0x000000080b007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fe20000000007ULL,
0x000000100a0b7824ULL, 0x000fe200078e0205ULL, 0x0000763206097816ULL, 0x000fc40000000007ULL,
0x0000001a1b06723eULL, 0x000fe400000000ffULL, 0x000000270e07723eULL, 0x000fe200000000ffULL,
0x000000080d007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x144fe40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x000000122f02723eULL, 0x000fe400000000ffULL,
0x000000332604723eULL, 0x000fe200000000ffULL, 0x000000080f007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fc40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x000000372e06723eULL, 0x000fe400000000ffULL, 0x0000003b3207723eULL, 0x000fe200000000ffULL,
0x0000000811007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x144fe40000000004ULL,
0x0000763202097816ULL, 0x000fca0000000004ULL, 0x0000000813007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fca0000000007ULL,
0x0000000815007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000b0c7984ULL, 0x000ea80000000c00ULL, 0x000400000b1c7984ULL, 0x000ee80000000c00ULL,
0x000800000b187984ULL, 0x000f280000000c00ULL, 0x000c00000b207984ULL, 0x000f620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b0f0f7230ULL, 0x010fe40000000000ULL, 0x0000001a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000190d0d7230ULL, 0x000fe40000000000ULL, 0x000000180c0c7230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x020fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000000c0b007388ULL, 0x0005e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c0b007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f2000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x004ea20000002700ULL, 0x0000580014027a24ULL, 0x000fe200078e02ffULL,
0x0000000146ff7812ULL, 0x000fe2000780f825ULL, 0x00000800ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x0000640002067a24ULL, 0x000fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000004002b047824ULL, 0x000fe200078e00ffULL,
0x000000000b107984ULL, 0x0007220000000c00ULL, 0x000000ff0300720cULL, 0x000fc40000725670ULL,
0x000007ff06027811ULL, 0x040fe400078e40ffULL, 0x01ffffff06067812ULL, 0x000fe200078ec0ffULL,
0x000058000e0e7a24ULL, 0x004fc800078e0207ULL, 0x000003000e077a24ULL, 0x000fca00078e02ffULL,
0x00000004070f7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000f02087211ULL, 0x000fca00078fa8ffULL,
0x00006a0008087625ULL, 0x000fca00078e0009ULL, 0x00000004080c7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fc800010e0609ULL, 0x000000100a0c7825ULL, 0x000fe200078e000cULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x018fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000010f0a7824ULL, 0x000fe200078e0206ULL, 0x0000007008157812ULL, 0x000fe400078ec0ffULL,
0x0000000c09167812ULL, 0x000fe200078ec0ffULL, 0x00006a000f087625ULL, 0x000fc800078e000bULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000816087210ULL, 0x000fc80007a1e015ULL,
0x0000000a160a7210ULL, 0x000fe40007c7e015ULL, 0x00000009ff097210ULL, 0x000fe400007e44ffULL,
0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL, 0x0000002a08007986ULL, 0x0005e8000c101906ULL,
0x000000290a007986ULL, 0x0005e4000c101906ULL, 0x0000000000007941ULL, 0x018fea0003800000ULL,
0x000000100c007986ULL, 0x0007e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x004fe200078e00ffULL, 0xffffffff140b7810ULL, 0x000fc60007ffe0ffULL,
0x000068000e087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0800720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0a7807ULL, 0x000fca0000000000ULL, 0x0000000aff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x004ea40000000000ULL, 0x000000ff0800720cULL, 0x004fda0003f05270ULL,
0x00002b7000008947ULL, 0x000fea0003800000ULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x00000001070a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007008197812ULL, 0x000fe400078ec0ffULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0007087625ULL, 0x000fc800078e0017ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x00000006080c7981ULL, 0x008568000c1e1900ULL,
0x000000060a0d7981ULL, 0x000562000c1e1900ULL, 0x000000021400780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000207087810ULL, 0x004fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000562000c1e1900ULL,
0x000000041400780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000307087810ULL, 0x004fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000562000c1e1900ULL, 0x000000041400780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000407087810ULL, 0x004fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000562000c1e1900ULL,
0x000000061400780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000507087810ULL, 0x004fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000562000c1e1900ULL, 0x000000061400780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081400780cULL, 0x004fe40003f06070ULL,
0x0000000607087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fe40007a3e019ULL, 0x00000007070a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000566000c1e1900ULL, 0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000566000c1e1900ULL,
0x0000000714087810ULL, 0x004fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e000cULL,
0x00000008190e7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x024fea0003800000ULL, 0x000000080e087810ULL, 0x040fe40007ffe0ffULL,
0x000000010e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001b0c0c7209ULL, 0x008fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x00000070101b7812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000568000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090e087810ULL, 0x044fe40007ffe0ffULL, 0x000000020e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000568000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e087810ULL, 0x044fe40007ffe0ffULL,
0x000000030e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000568000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e087810ULL, 0x044fe40007ffe0ffULL, 0x000000040e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000568000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e087810ULL, 0x044fe40007ffe0ffULL,
0x000000050e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000130c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000568000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e087810ULL, 0x044fe40007ffe0ffULL, 0x000000060e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000150c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000568000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e087810ULL, 0x044fe40007ffe0ffULL,
0x000000070e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000170c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000568000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e087810ULL, 0x004fe40007ffe0ffULL, 0x0000000b0c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000568000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x0000001003087824ULL, 0x014fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000109097824ULL, 0x000fca00078e0208ULL, 0x0000000c09007388ULL, 0x0205e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003097824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x0000000146117824ULL, 0x008fe200078e0207ULL,
0x00000002ff0c7819ULL, 0x000fe20000011625ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000070090a7812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000020025257824ULL, 0x000fe200078e00ffULL,
0x0000001102087211ULL, 0x000fe200078fa8ffULL, 0x000000012c327824ULL, 0x000fe200078e0205ULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x000000010b2a7824ULL, 0x000fe200078e020aULL,
0x000000010c0a7812ULL, 0x000fe200078ec0ffULL, 0x00000002460b8824ULL, 0x100fe200078e022bULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00006a0008087625ULL, 0x000fe200078e000dULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000020b0c8824ULL, 0x100fe200078e020aULL,
0x00000800250b7812ULL, 0x000fe200078ec0ffULL, 0x00000002460d8824ULL, 0x000fe200078e022bULL,
0x0000000408087210ULL, 0x000fe20007f3e0ffULL, 0x00000001060e8824ULL, 0x000fe200078e0211ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000080ff108424ULL, 0x000fe200078e00ffULL,
0x000000002a2a7984ULL, 0x000ea20000000800ULL, 0x000000020d128824ULL, 0x000fe200078e020aULL,
0x00000020030d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001320a7824ULL, 0x000fe200078e020bULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000030046007a0cULL, 0x000fe20003f26070ULL, 0x00006a000e0e8625ULL, 0x000fe200078e000fULL,
0x0000000000267805ULL, 0x000fc6000001ff00ULL, 0x00006a0011108625ULL, 0x000fc800078e0010ULL,
0x000000080c158824ULL, 0x100fe400078e0203ULL, 0x0000000812128824ULL, 0x000fe400078e0203ULL,
0x0000001003137824ULL, 0x000fe200078e020aULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000010030a7825ULL, 0x000fe200078e0008ULL, 0x0000418012178811ULL, 0x000fc600078e20ffULL,
0x000000100d0c7825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0007e2000b901c46ULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x00000010030e8825ULL, 0x040fe200078e000eULL, 0x003800000c137faeULL, 0x0009e6000b901c46ULL,
0x0000001003108825ULL, 0x000fe200078e0010ULL, 0x000000000e158faeULL, 0x000be6000b901c46ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000000010178faeULL, 0x0003e2000b901c46ULL,
0x00000000000a7805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x004fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fca00078e0046ULL, 0x0000000234367810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030036007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x0000000107317824ULL, 0x100fe200078e0236ULL, 0x00000001ff287819ULL, 0x000fe20000011636ULL,
0x00000800ff307424ULL, 0x000fe200078e00ffULL, 0x0000002003397810ULL, 0x000fe20007ffe0ffULL,
0x00000400362c7824ULL, 0x000fe200078e00ffULL, 0x0000003102297211ULL, 0x000fe400078fa8ffULL,
0x00000001282e7812ULL, 0x000fc600078ec0ffULL, 0x00006a0029287625ULL, 0x000fc800078e0030ULL,
0x00000002462f9824ULL, 0x000fe200078e022bULL, 0x0000000428287210ULL, 0x000fe20007f1e0ffULL,
0x00000001062d9824ULL, 0x000fe400078e0231ULL, 0x000000022f389824ULL, 0x100fe200078e022eULL,
0x000008002c2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000246359824ULL, 0x000fe400078e022bULL,
0x00000080ff309424ULL, 0x000fe400078e00ffULL, 0x00000002353c9824ULL, 0x000fc400078e022eULL,
0x00006a002d2c9625ULL, 0x000fc800078e0030ULL, 0x00000080ff3a9424ULL, 0x000fe400078e00ffULL,
0x00000001322e7824ULL, 0x000fe400078e022fULL, 0x000000ffff297224ULL, 0x000fe400000e0629ULL,
0x00006a0031309625ULL, 0x000fc800078e003aULL, 0x0000001003357824ULL, 0x040fe400078e022eULL,
0x0000000838379824ULL, 0x000fe400078e0203ULL, 0x00000010032e9825ULL, 0x000fc600078e002cULL,
0x0000458037379811ULL, 0x000fe200078e20ffULL, 0x000000083c3c9824ULL, 0x000fe400078e0203ULL,
0x00000010392c7825ULL, 0x000fc600078e0028ULL, 0x000041803c399811ULL, 0x000fe200078e20ffULL,
0x0000001003287825ULL, 0x000fc800078e0028ULL, 0x0000001003309825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000028357faeULL, 0x0003e8000b901c46ULL,
0x003800002c357faeULL, 0x0003e8000b901c46ULL, 0x000000002e379faeULL, 0x0003e8000b901c46ULL,
0x0000000030399faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0034ULL,
0x00000001ff2c7819ULL, 0x000fe20000011603ULL, 0x00000002462d7824ULL, 0x000fe200078e022bULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000402f287824ULL, 0x000fe200078e00ffULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000001003297824ULL, 0x000fe200078e00ffULL,
0x00000007353c7812ULL, 0x040fe200078ec0ffULL, 0x0000000835317824ULL, 0x040fe200078e00ffULL,
0x0000008028287812ULL, 0x000fe200078ec0ffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x0000007029297812ULL, 0x000fc400078ec0ffULL, 0x00000035ff3e7212ULL, 0x000fe200078e33ffULL,
0x000001002d287824ULL, 0x000fc600078e0028ULL, 0xfffffff8373e7812ULL, 0x000fe400078ee23eULL,
0x000000282c2c7210ULL, 0x000fe20007ffe029ULL, 0x0000000835297824ULL, 0x000fe200078e00ffULL,
0xfffffff831287812ULL, 0x000fe200078ee23cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002c2d7984ULL, 0x000e620000000800ULL, 0x00000001292e7812ULL, 0x140fe400078ef63cULL,
0x0000000229307812ULL, 0x140fe200078ef63cULL, 0x004580002c507984ULL, 0x0004e20000000800ULL,
0x0000000329347812ULL, 0x140fe400078ef63cULL, 0x0000000429387812ULL, 0x140fe400078ef63cULL,
0x00000005293a7812ULL, 0x140fe400078ef63cULL, 0x00000006293c7812ULL, 0x000fe200078ef63cULL,
0x000004002f297824ULL, 0x000fe200078e00ffULL, 0x0000000835377810ULL, 0x000fe20007ffe0ffULL,
0x00000004032c7824ULL, 0x004fc600078e00ffULL, 0x0000080029297812ULL, 0x000fe200078ec0ffULL,
0x0000000837427824ULL, 0x040fe200078e00ffULL, 0x00000007372f7812ULL, 0x040fe200078ec0ffULL,
0x0000000837407824ULL, 0x040fe200078e00ffULL, 0x0000018032297810ULL, 0x000fe20007ffe029ULL,
0x0000000837397824ULL, 0x000fe200078e00ffULL, 0x00000037ff4e7212ULL, 0x000fe400078e33ffULL,
0x0000000240447812ULL, 0x000fe200078ef62fULL, 0x0000001028287824ULL, 0x000fe200078e0229ULL,
0x0000000340487812ULL, 0x000fe200078ef62fULL, 0x000000103e3e7824ULL, 0x000fe200078e0229ULL,
0x00000004404a7812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x000fe200078e0229ULL,
0x00000005404c7812ULL, 0x000fe200078ef62fULL, 0x0000001034347824ULL, 0x100fe200078e0229ULL,
0xfffffff8394e7812ULL, 0x000fe200078ee24eULL, 0x0000001030307824ULL, 0x000fc400078e0229ULL,
0x000000103a3a7824ULL, 0x100fe400078e0229ULL, 0x0000001038387824ULL, 0x000fe200078e0229ULL,
0x0000002d2a2d7221ULL, 0x002fe20000010100ULL, 0x000000103c3c7824ULL, 0x100fe400078e0229ULL,
0x0000001044447824ULL, 0x100fe200078e0229ULL, 0x3fb8aa3b2d317820ULL, 0x000fe20000410000ULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000001048487824ULL, 0x000fe200078e0229ULL,
0xfffffff8422c7812ULL, 0x000fe200078ee22fULL, 0x000000104a4a7824ULL, 0x000fe200078e0229ULL,
0x0000000140427812ULL, 0x000fe200078ef62fULL, 0x0000000128287824ULL, 0x000fe200078e022dULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x000000012d3e7824ULL, 0x040fe200078e023eULL,
0x0000000640407812ULL, 0x000fe200078ef62fULL, 0x000000012d2e7824ULL, 0x000fc400078e022eULL,
0x0000000028287984ULL, 0x000e620000000800ULL, 0x000000012d347824ULL, 0x040fe400078e0234ULL,
0x000000012d307824ULL, 0x040fe200078e0230ULL, 0x000000003e3e7984ULL, 0x000ea20000000800ULL,
0x000000012d3a7824ULL, 0x040fe400078e023aULL, 0x000000012d387824ULL, 0x040fe200078e0238ULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x000000012d3c7824ULL, 0x000fe200078e023cULL,
0x0000005031527220ULL, 0x008fc40000410000ULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x000000102c2c7824ULL, 0x100fe400078e0229ULL, 0x0000001042427824ULL, 0x000fe200078e0229ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x000000012d2c7824ULL, 0x040fe200078e022cULL,
0x0000003352337221ULL, 0x000fe20000010000ULL, 0x000000012d427824ULL, 0x040fe200078e0242ULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x000000012d447824ULL, 0x040fe400078e0244ULL,
0x000000012d487824ULL, 0x000fe200078e0248ULL, 0x00001f35522f7589ULL, 0x000ee200000e0000ULL,
0x000000104c4c7824ULL, 0x000fc400078e0229ULL, 0x0000001040407824ULL, 0x100fe200078e0229ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000104e4e7824ULL, 0x000fe400078e0229ULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x000000012d4c7824ULL, 0x040fe400078e024cULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x000000002c2c7984ULL, 0x000f620000000800ULL, 0x000000012d4e7824ULL, 0x000fc600078e024eULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x20000028ff507230ULL, 0x102fe40000004100ULL,
0x30000028ff2d7230ULL, 0x000fe20000004100ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x2000003eff287230ULL, 0x104fe40000004100ULL, 0x3000003eff317230ULL, 0x000fe20000004100ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x0000002f2d267223ULL, 0x088fe20000010026ULL,
0x0000002f28197223ULL, 0x080fe20000010019ULL, 0x2000002eff287230ULL, 0x100fe20000004100ULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x3000002eff2d7230ULL, 0x000fe20000004100ULL,
0x0000002f31187223ULL, 0x080fe20000010018ULL, 0x0000002f50277223ULL, 0x080fe20000010027ULL,
0x000000004c4c7984ULL, 0x000fe20000000800ULL, 0x0000002f28257223ULL, 0x080fe20000010025ULL,
0x20000034ff287230ULL, 0x000fe20000004100ULL, 0x0000002f2d247223ULL, 0x000fe20000010024ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x30000030ff317230ULL, 0x000fc40000004100ULL,
0x0000002f28217223ULL, 0x080fe20000010021ULL, 0x000000004e4e7984ULL, 0x000fe20000000800ULL,
0x30000034ff2d7230ULL, 0x000fe20000004100ULL, 0x0000002f31227223ULL, 0x080fe20000010022ULL,
0x2000003aff287230ULL, 0x000fe20000004100ULL, 0x00001f3752297589ULL, 0x000ea200000e0000ULL,
0x20000030ff2e7230ULL, 0x000fe20000004100ULL, 0x0000002f2d207223ULL, 0x080fe20000010020ULL,
0x30000038ff317230ULL, 0x010fe20000004100ULL, 0x0000002f281d7223ULL, 0x080fe2000001001dULL,
0x3000003aff2d7230ULL, 0x000fe20000004100ULL, 0x0000002f2e237223ULL, 0x080fe20000010023ULL,
0x2000003cff287230ULL, 0x020fe20000004100ULL, 0x0000002f311e7223ULL, 0x080fe2000001001eULL,
0x20000038ff2e7230ULL, 0x000fe20000004100ULL, 0x0000002f2d1c7223ULL, 0x080fe2000001001cULL,
0x3000003cff317230ULL, 0x000fe20000004100ULL, 0x0000002f281b7223ULL, 0x080fe2000001001bULL,
0x3000002cff2d7230ULL, 0x000fe20000004100ULL, 0x0000002f2e1f7223ULL, 0x080fe2000001001fULL,
0x20000042ff287230ULL, 0x000fe20000004100ULL, 0x0000002f311a7223ULL, 0x000fe2000001001aULL,
0x000000ffff347224ULL, 0x000fc400078e0036ULL, 0x2000002cff2e7230ULL, 0x000fe40000004100ULL,
0x20000044ff2c7230ULL, 0x102fe20000004100ULL, 0x0000030034007a0cULL, 0x000fe20003f06070ULL,
0x30000044ff2f7230ULL, 0x000fe20000004100ULL, 0x000000292d167223ULL, 0x084fe20000010016ULL,
0x0000002928157223ULL, 0x080fe20000010015ULL, 0x30000042ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292c137223ULL, 0x080fe20000010013ULL, 0x20000048ff287230ULL, 0x000fe20000004100ULL,
0x000000292f127223ULL, 0x080fe20000010012ULL, 0x3000004aff2f7230ULL, 0x000fe20000004100ULL,
0x000000292d147223ULL, 0x080fe20000010014ULL, 0x30000048ff2d7230ULL, 0x000fe20000004100ULL,
0x0000002928117223ULL, 0x080fe20000010011ULL, 0x2000004aff287230ULL, 0x000fe20000004100ULL,
0x000000292f0e7223ULL, 0x080fe2000001000eULL, 0x2000004cff2c7230ULL, 0x100fe20000004100ULL,
0x000000292d107223ULL, 0x080fe20000010010ULL, 0x3000004cff2d7230ULL, 0x000fe20000004100ULL,
0x00000029280f7223ULL, 0x080fe2000001000fULL, 0x20000040ff287230ULL, 0x100fe20000004100ULL,
0x000000292c0d7223ULL, 0x080fe2000001000dULL, 0x30000040ff2f7230ULL, 0x000fe20000004100ULL,
0x000000292e177223ULL, 0x080fe20000010017ULL, 0x2000004eff2c7230ULL, 0x100fe20000004100ULL,
0x000000292d0c7223ULL, 0x080fe2000001000cULL, 0x3000004eff317230ULL, 0x000fe20000004100ULL,
0x00000029280b7223ULL, 0x080fe2000001000bULL, 0x000000292f0a7223ULL, 0x080fe2000001000aULL,
0x000000292c097223ULL, 0x000fc40000010009ULL, 0x0000002931087223ULL, 0x000fe20000010008ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x004fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff2b00720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fca00078ec0ffULL,
0x0000000102047824ULL, 0x000fe200078e0203ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02077812ULL, 0x000fc600078ec0ffULL, 0x0000008046027824ULL, 0x000fc800078e0203ULL,
0x0000000107027824ULL, 0x000fca00078e0202ULL, 0x0049803302007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0049800004027984ULL, 0x002e680000000800ULL, 0x004a000004037984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000302027221ULL, 0x004fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e0002ULL,
0x0000b6c000067802ULL, 0x000fe40000000f00ULL, 0x0000610000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403047223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008032f7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff2d7819ULL, 0x000fe40000011603ULL,
0x0000002fff297212ULL, 0x002fe200078e33ffULL, 0x00001f2f04067589ULL, 0x000e6200000e0000ULL,
0x000000082f2e7824ULL, 0x000fc400078e00ffULL, 0x000000082d317824ULL, 0x000fe200078e00ffULL,
0x00001f2d04027589ULL, 0x0004e400000e0000ULL, 0x0000002dff047212ULL, 0x004fc800078e33ffULL,
0xfffffff831317812ULL, 0x000fe400078ee204ULL, 0x000000072d047812ULL, 0x040fe200078ec0ffULL,
0x0000001706177220ULL, 0x042fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x0000000c060c7220ULL, 0x040fe20000410000ULL,
0x0000000b060b7220ULL, 0x040fe20000410000ULL, 0x0000000a060a7220ULL, 0x040fe20000410000ULL,
0x0000000906097220ULL, 0x000fe20000410000ULL, 0x0000002702277220ULL, 0x048fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x040fe20000410000ULL,
0x0000002202227220ULL, 0x040fe20000410000ULL, 0x0000002102217220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000001f021f7220ULL, 0x040fe20000410000ULL,
0x0000001e021e7220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001b021b7220ULL, 0x040fe20000410000ULL,
0x0000001a021a7220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x000fe20000410000ULL,
0x0000000806067220ULL, 0x000fe20000410000ULL, 0x0000001802027220ULL, 0x000fe20000410000ULL,
0x000000082d087824ULL, 0x000fe200078e00ffULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x000000082f187824ULL, 0x000fe200078e00ffULL, 0x0000000304287812ULL, 0x000fe200078e3cffULL,
0x0000000403257824ULL, 0x000fe200078e00ffULL, 0xfffffff808077812ULL, 0x000fc400078ee22dULL,
0xfffffff818297812ULL, 0x000fe400078ee229ULL, 0x0000000104087812ULL, 0x040fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0200ULL, 0x0000000204187812ULL, 0x040fe200078e3cffULL,
0x0000001029297824ULL, 0x000fe200078e0200ULL, 0x00000004042a7812ULL, 0x040fe400078e3cffULL,
0x00000005042c7812ULL, 0x040fe400078e3cffULL, 0x0000000604047812ULL, 0x000fc400078e3cffULL,
0x000000232222723eULL, 0x000fe400000000ffULL, 0x000000090606723eULL, 0x000fe200000000ffULL,
0x000000082d097824ULL, 0x000fe200078e0208ULL, 0x000000072f237812ULL, 0x000fe400078ec0ffULL,
0x0000000d0c0c723eULL, 0x000fe200000000ffULL, 0x000000082d0d7824ULL, 0x040fe200078e0228ULL,
0x0000000b0a0a723eULL, 0x000fe200000000ffULL, 0x000000082d0b7824ULL, 0x040fe200078e0218ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x000000082d137824ULL, 0x040fe200078e0204ULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x000000082d0f7824ULL, 0x000fe200078e022aULL,
0x0000000c25287812ULL, 0x000fe200078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x000000082d117824ULL, 0x000fe200078e022cULL,
0x0000000123047812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0x0000000223087812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000000128077824ULL, 0x000fe200078e0207ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000000323187812ULL, 0x000fe200078e3cffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000000128097824ULL, 0x000fe200078e0209ULL,
0xfffffff82e157812ULL, 0x000fe200078ee22fULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x00000004231b7812ULL, 0x000fe200078e3cffULL, 0x00000001280b7824ULL, 0x000fe200078e020bULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x00000001280d7824ULL, 0x000fe200078e020dULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x000000082f177824ULL, 0x000fe200078e0204ULL,
0x0000000523217812ULL, 0x000fe200078e3cffULL, 0x0000001031047824ULL, 0x000fe200078e0200ULL,
0x000000190202723eULL, 0x000fe200000000ffULL, 0x000000082f197824ULL, 0x000fe200078e0208ULL,
0x0000000623237812ULL, 0x000fe200078e3cffULL, 0x0000001015087824ULL, 0x000fe200078e0200ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x000000082f1d7824ULL, 0x040fe200078e0218ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x000000082f1f7824ULL, 0x000fe200078e021bULL,
0x0000002607007388ULL, 0x000fe20000000800ULL, 0x00000001280f7824ULL, 0x000fc400078e020fULL,
0x000000082f217824ULL, 0x000fe200078e0221ULL, 0x0000002409007388ULL, 0x000fe20000000800ULL,
0x0000001017187824ULL, 0x100fe400078e0200ULL, 0x0000000128117824ULL, 0x040fe200078e0211ULL,
0x000000220b007388ULL, 0x000fe20000000800ULL, 0x000000082f237824ULL, 0x000fe400078e0223ULL,
0x00000010191b7824ULL, 0x000fe200078e0200ULL, 0x000000200d007388ULL, 0x000fe20000000800ULL,
0x0000000128137824ULL, 0x000fc400078e0213ULL, 0x000000101d1d7824ULL, 0x000fe200078e0200ULL,
0x0000001e0f007388ULL, 0x000fe20000000800ULL, 0x0000000128157824ULL, 0x040fe400078e0204ULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x0000001c11007388ULL, 0x000fe20000000800ULL,
0x0000000128177824ULL, 0x040fe400078e0208ULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x0000001a13007388ULL, 0x000fe20000000800ULL, 0x0000000128197824ULL, 0x000fc400078e0218ULL,
0x0000001023237824ULL, 0x000fe200078e0200ULL, 0x0000000215007388ULL, 0x000fe20000000800ULL,
0x00000001281b7824ULL, 0x040fe400078e021bULL, 0x00000001281d7824ULL, 0x040fe200078e021dULL,
0x0000001617007388ULL, 0x000fe20000000800ULL, 0x00000001281f7824ULL, 0x040fe400078e021fULL,
0x0000000128217824ULL, 0x040fe200078e0221ULL, 0x0000001419007388ULL, 0x000fe20000000800ULL,
0x0000000128237824ULL, 0x000fc400078e0223ULL, 0x0000000128297824ULL, 0x000fe200078e0229ULL,
0x000000121b007388ULL, 0x000fe20000000800ULL, 0x0000002046007824ULL, 0x000fc600078e0203ULL,
0x000000101d007388ULL, 0x000fe20000000800ULL, 0x0000001000007824ULL, 0x000fc600078e0205ULL,
0x0000000e1f007388ULL, 0x000fe80000000800ULL, 0x0000000c21007388ULL, 0x000fe80000000800ULL,
0x0000000a23007388ULL, 0x000fe80000000800ULL, 0x0000000629007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000247984ULL, 0x000e680000000c00ULL,
0x00040000002c7984ULL, 0x000ea80000000c00ULL, 0x0008000000147984ULL, 0x000ee80000000c00ULL,
0x000c000000187984ULL, 0x000f220000000c00ULL, 0x200000ff27277230ULL, 0x002fc40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000001727277230ULL, 0x008fe40000000000ULL,
0x0000001626267230ULL, 0x000fe40000000000ULL, 0x0000001525257230ULL, 0x000fe40000000000ULL,
0x0000001424247230ULL, 0x000fe40000000000ULL, 0x0000001b2f2f7230ULL, 0x010fc40000000000ULL,
0x0000001a2e2e7230ULL, 0x000fe20000000000ULL, 0x0000002400007388ULL, 0x0003e20000000c00ULL,
0x000000192d2d7230ULL, 0x000fe40000000000ULL, 0x000000182c2c7230ULL, 0x000fca0000000000ULL,
0x0004002c00007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4600720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x008fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000ee20000002600ULL,
0x00000003ff107819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000710007812ULL, 0x002fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704027812ULL, 0x000fe200078e4811ULL, 0x000000082b127824ULL, 0x000fe200078e00ffULL,
0x0ffffff800007812ULL, 0x000fc400078ef803ULL, 0x0ffffff802027812ULL, 0x100fe400078ef811ULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x0000001000007824ULL, 0x100fe400078e0205ULL,
0x0000001002057824ULL, 0x000fc600078e0205ULL, 0x0000000000087984ULL, 0x0042a80000000c00ULL,
0x00000000050c7984ULL, 0x000aa20000000c00ULL, 0x0000000806077824ULL, 0x048fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x000000082b007824ULL, 0x002fe200078e00ffULL, 0xfffffff807027812ULL, 0x000fc400078ee210ULL,
0xfffffff813047812ULL, 0x000fe400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x020fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fc400078240ffULL,
0x00005b0010057a11ULL, 0x000fe400000f4405ULL, 0x00005b0002077a11ULL, 0x000fc600008f4407ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x004fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604297981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000103077810ULL, 0x000fe20007ffe0ffULL,
0x000000022f007824ULL, 0x000fe200078e00ffULL, 0x00f60000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004025267824ULL, 0x000fe200078e00ffULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x0000580000277a24ULL, 0x000fe400078e0227ULL, 0x00000100030b7824ULL, 0x000fc800078e0226ULL,
0x00006200271a7a24ULL, 0x000fcc00078e020bULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x000fe20000011631ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x000000300c1f7812ULL, 0x000fe400078ec0ffULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d067824ULL, 0x140fe200078e021aULL, 0x000000101d237810ULL, 0x040fe40007ffe0ffULL,
0x000000181d2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111087824ULL, 0x000fe200078e021aULL,
0x000000201d177810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000000b24007217ULL, 0x000fc40007800000ULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x0000001f060e7210ULL, 0x080fe40007f1e0ffULL,
0x00000003ff147819ULL, 0x100fe20000011631ULL, 0x00000001230a7824ULL, 0x100fe200078e021aULL,
0x0000001f08087210ULL, 0x000fe20007f3e0ffULL, 0x000000012b0c7824ULL, 0x000fe200078e021aULL,
0x0000000314147812ULL, 0x000fe200078e4831ULL, 0x000000011a067824ULL, 0x000fe200078e0217ULL,
0x0000100025167811ULL, 0x000fe200078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x0ffffffc14317812ULL, 0x000fe200078ef831ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0021ULL,
0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x000000002300720cULL, 0x080fe40003fa6070ULL,
0x000000002b00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x0000001f0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0021ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001f0c0c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001f06107210ULL, 0x000fe20007f5e0ffULL,
0x000000011a067824ULL, 0x000fe200078e0219ULL, 0x000000001d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000001100720cULL, 0x0c0fe20003f26070ULL,
0x0000000411137824ULL, 0x000fe200078e00ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x000000001900720cULL, 0x000fe20003f46070ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0xfffffffc13137812ULL, 0x000fc600078ee214ULL,
0x0000001031317824ULL, 0x100fe200078e0216ULL, 0x0000001f06127210ULL, 0x000fe20007fde0ffULL,
0x0000001013157824ULL, 0x000fe400078e0216ULL, 0x000000011a067824ULL, 0x000fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e317faeULL, 0x0005e2000c101c46ULL,
0x000000ffff137224ULL, 0x000fe200030e0607ULL, 0x000000001d00720cULL, 0x080fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x0000000008157faeULL, 0x0007e2000c901c46ULL,
0x000000001b00720cULL, 0x000fc40003f26070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x0000001f06067210ULL, 0x000fe20007fde0ffULL, 0x0000000419197824ULL, 0x000fe400078e00ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x100fe200078ee214ULL,
0x00000004230f7824ULL, 0x004fe200078e00ffULL, 0xfffffffc19197812ULL, 0x100fe200078ee214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0xfffffffc1b1b7812ULL, 0x100fe200078ee214ULL,
0x000000042b157824ULL, 0x008fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee214ULL,
0x000000011a087824ULL, 0x000fc400078e021dULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc15157812ULL, 0x000fe200078ee214ULL, 0x00005e0008087625ULL, 0x000fc600078e0021ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee214ULL, 0x000000100f0f7824ULL, 0x100fe200078e0216ULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x0000001015157824ULL, 0x100fe400078e0216ULL,
0x0000001017177824ULL, 0x100fe200078e0216ULL, 0x000000000a0f7faeULL, 0x0005e2000e901c46ULL,
0x0000001019197824ULL, 0x100fe400078e0216ULL, 0x000000101b1b7824ULL, 0x100fe200078e0216ULL,
0x000000000c157faeULL, 0x0005e2000e101c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e0216ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000010177faeULL, 0x0005e8000d901c46ULL,
0x0000000012197faeULL, 0x0005e8000d101c46ULL, 0x00000000061b7faeULL, 0x0005e8000c901c46ULL,
0x00000000081d7faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001031077811ULL, 0x040fe200078ff0ffULL, 0x00000080ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000001a31067211ULL, 0x000fc400078ff0ffULL, 0x00000003ff007819ULL, 0x000fe20000011631ULL,
0x000000011a087824ULL, 0x000fe200078e0207ULL, 0x00000008310f7811ULL, 0x000fe200078ff0ffULL,
0x0000000407137824ULL, 0x000fe200078e00ffULL, 0x00000020310b7811ULL, 0x040fe200078ff0ffULL,
0x00005e0006067625ULL, 0x000fe200078e002bULL, 0x000000300c2d7812ULL, 0x000fe400078ec0ffULL,
0x0000001831097811ULL, 0x000fe200078ff0ffULL, 0x000000040f117824ULL, 0x040fe200078e00ffULL,
0x00000003001c7812ULL, 0x000fe200078e4831ULL, 0x000000010f007824ULL, 0x000fe200078e021aULL,
0x00000028310c7811ULL, 0x040fe200078ff0ffULL, 0x000000011a0f7824ULL, 0x000fe200078e020bULL,
0x00000030310d7811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000002d06107210ULL, 0x000fe20007f1e0ffULL, 0x000000011a0a7824ULL, 0x040fe200078e0209ULL,
0x00000038310e7811ULL, 0x000fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b127812ULL, 0x000fe200078ee21cULL, 0x000000011a167824ULL, 0x000fe200078e020cULL,
0x0000100025237811ULL, 0x000fe200078e68ffULL, 0x000000040c157824ULL, 0x000fe200078e00ffULL,
0xfffffffc110c7812ULL, 0x000fe200078ee21cULL, 0x000000011a187824ULL, 0x000fe200078e020dULL,
0x0ffffffc1c317812ULL, 0x000fe200078ef831ULL, 0x000000ffff117224ULL, 0x000fc400000e0607ULL,
0x000000011a1a7824ULL, 0x000fe400078e020eULL, 0x000000040e197824ULL, 0x000fe200078e00ffULL,
0xfffffffc090e7812ULL, 0x000fe200078ee21cULL, 0x00005e0000067625ULL, 0x000fc800078e002bULL,
0x000000040d177824ULL, 0x000fe200078e00ffULL, 0xfffffffc130d7812ULL, 0x100fe200078ee21cULL,
0x00005e0008087625ULL, 0x000fe200078e002bULL, 0xfffffffc15137812ULL, 0x100fe400078ee21cULL,
0xfffffffc17157812ULL, 0x100fe200078ee21cULL, 0x00000010121d7824ULL, 0x100fe200078e0223ULL,
0x0000002d06127210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e002bULL,
0x0000002d08147210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc191c7812ULL, 0x000fe200078ee21cULL,
0x00000010131f7824ULL, 0x000fc400078e0223ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x0000002d0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015217824ULL, 0x000fe400078e0223ULL,
0x000000ffff157224ULL, 0x000fe400008e0609ULL, 0x00005e000f067625ULL, 0x000fc800078e002bULL,
0x000000100c177824ULL, 0x100fe400078e0223ULL, 0x000000100d197824ULL, 0x000fe400078e0223ULL,
0x00005e0016087625ULL, 0x000fc800078e002bULL, 0x000000100e1b7824ULL, 0x000fe200078e0223ULL,
0x0000002d08087210ULL, 0x000fe20007f3e0ffULL, 0x00005e00180c7625ULL, 0x000fc800078e002bULL,
0x00005e001a0e7625ULL, 0x000fe200078e002bULL, 0x0000002d0c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002d06067210ULL, 0x080fe20007f1e0ffULL,
0x0000001031317824ULL, 0x000fe200078e0223ULL, 0x0000002d0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x000000101c237824ULL, 0x000fe200078e0223ULL,
0x0000000012177faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x0000000014197faeULL, 0x0005e8000b901c46ULL, 0x000000000a1b7faeULL, 0x0005e8000b901c46ULL,
0x00000000061d7faeULL, 0x0005e8000b901c46ULL, 0x00000000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c217faeULL, 0x0005e8000b901c46ULL, 0x000000000e237faeULL, 0x0005e4000b901c46ULL,
0x00f60400ff077984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x006fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002025007824ULL, 0x002fc800078e0200ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff047f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000287919ULL, 0x000e620000000000ULL, 0x3db504f329297820ULL, 0x020fe20000410000ULL,
0x0000f688252a7811ULL, 0x040fe200078e18ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0xffffffff022c7810ULL, 0x000fe40007ffe0ffULL, 0x0000f608252b7811ULL, 0x000fe400078e28ffULL,
0x00000100032d7824ULL, 0x008fe200078e0226ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002d2400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e002eULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x00000001002f7810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fc400078e0000ULL, 0x00000001ff2e7819ULL, 0x100fe2000001162fULL,
0x000000ffff007224ULL, 0x000fe200078e002fULL, 0x000000022f00780cULL, 0x040fe40003f06070ULL,
0x000000012f307812ULL, 0x000fe200078ec0ffULL, 0x000003002e317a24ULL, 0x000fe200078e0203ULL,
0x00000001402e7812ULL, 0x000fc600078e0cffULL, 0x0000010031327824ULL, 0x040fe200078e0226ULL,
0x0000000131337810ULL, 0x000fc60007ffe0ffULL, 0x0000620027397a24ULL, 0x000fe200078e0232ULL,
0x000000023300720cULL, 0x000fda0003f26070ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x00000032242f7217ULL, 0x000fe20007800000ULL, 0x00000004303d7824ULL, 0x000fe200078e00ffULL,
0x00000002ff347819ULL, 0x002fe20000011628ULL, 0x00000002253c7824ULL, 0x000fe200078e022eULL,
0x00000003ff317819ULL, 0x000fe20000011628ULL, 0x000000012f2f7824ULL, 0x000fe200078e0a32ULL,
0x0000000834367810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff3b7424ULL, 0x000fe200078e00ffULL,
0x00000003313f7812ULL, 0x100fe200078e4828ULL, 0x0000000134307824ULL, 0x100fe200078e0239ULL,
0x0000002f3600720cULL, 0x0c0fe20003f46070ULL, 0x0000000136327824ULL, 0x000fe200078e0239ULL,
0x0000002f3400720cULL, 0x000fe20003f26070ULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee228ULL, 0x00005e0030307625ULL, 0x000fe200078e003bULL,
0x000010003c3c7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc3f357812ULL, 0x000fe200078ef828ULL,
0x00005e0032327625ULL, 0x000fe200078e003bULL, 0xfffffffc36377812ULL, 0x000fe400078ee23fULL,
0x0000001034367810ULL, 0x040fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e023cULL,
0x0000001834387810ULL, 0x040fe20007ffe0ffULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x00000020343a7810ULL, 0x040fe40007ffe0ffULL, 0x00000028343e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001037377824ULL, 0x000fe200078e023cULL, 0x0000003034447810ULL, 0x040fe20007ffe0ffULL,
0x000000103d327825ULL, 0x000fe200078e0032ULL, 0x0000003834467810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030357faeULL, 0x0003e2000c901c46ULL,
0x0000002f3600720cULL, 0x0c0fe20003f26070ULL, 0x0000000436487824ULL, 0x000fe200078e00ffULL,
0x0000002f3a00720cULL, 0x080fe20003f66070ULL, 0x0000000032377faeULL, 0x0005e2000d101c46ULL,
0x0000002f3800720cULL, 0x0c0fe20003f46070ULL, 0x00000004384a7824ULL, 0x000fe200078e00ffULL,
0x0000002f3e00720cULL, 0x080fe20003f86070ULL, 0x000000013a347824ULL, 0x100fe200078e0239ULL,
0x0000002f4400720cULL, 0x080fe20003fa6070ULL, 0x000000043a4c7824ULL, 0x000fe200078e00ffULL,
0x0000002f4600720cULL, 0x000fe20003fc6070ULL, 0x0000000136307824ULL, 0x002fe200078e0239ULL,
0xfffffffc482f7812ULL, 0x000fe200078ee23fULL, 0x000000013e367824ULL, 0x000fe200078e0239ULL,
0xfffffffc4a417812ULL, 0x000fe200078ee23fULL, 0x0000000138327824ULL, 0x004fe200078e0239ULL,
0xfffffffc4c437812ULL, 0x000fe200078ee23fULL, 0x0000000144387824ULL, 0x000fc400078e0239ULL,
0x00000001463a7824ULL, 0x000fe400078e0239ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x00005e0030307625ULL, 0x000fc600078e003bULL, 0xfffffffc3e457812ULL, 0x000fe200078ee23fULL,
0x00005e0032327625ULL, 0x000fc800078e003bULL, 0x00005e0034347625ULL, 0x000fc800078e003bULL,
0x00005e0036367625ULL, 0x000fc800078e003bULL, 0x00005e0038387625ULL, 0x000fc800078e003bULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x00005e003a3a7625ULL, 0x000fc600078e003bULL,
0xfffffffc44477812ULL, 0x000fe200078ee23fULL, 0x0000000446467824ULL, 0x000fe400078e00ffULL,
0x000000103d307825ULL, 0x000fc600078e0030ULL, 0xfffffffc46497812ULL, 0x000fe200078ee23fULL,
0x000000103d327825ULL, 0x000fc800078e0032ULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d367825ULL, 0x000fc800078e0036ULL, 0x000000103d387825ULL, 0x000fc800078e0038ULL,
0x000000103d3a7825ULL, 0x000fc800078e003aULL, 0x000000102f2f7824ULL, 0x100fe400078e023cULL,
0x00000010413d7824ULL, 0x100fe400078e023cULL, 0x00000010433f7824ULL, 0x100fe200078e023cULL,
0x00000000302f7faeULL, 0x0003e2000c901c46ULL, 0x0000001045417824ULL, 0x100fe400078e023cULL,
0x0000001047437824ULL, 0x100fe200078e023cULL, 0x00000000323d7faeULL, 0x0003e2000d101c46ULL,
0x0000001049457824ULL, 0x000fc600078e023cULL, 0x00000000343f7faeULL, 0x0003e8000d901c46ULL,
0x0000000036417faeULL, 0x0003e8000e101c46ULL, 0x0000000038437faeULL, 0x0003e8000e901c46ULL,
0x000000003a457faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000225327824ULL, 0x000fe200078e022eULL, 0x0000000828347811ULL, 0x002fe200078ff0ffULL,
0x00000004302f7824ULL, 0x000fe200078e00ffULL, 0x0000001028367811ULL, 0x040fe200078ff0ffULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001828387811ULL, 0x000fe200078ff0ffULL,
0x0000000434487824ULL, 0x000fe200078e00ffULL, 0x00000020283a7811ULL, 0x000fe200078ff0ffULL,
0x00000004364a7824ULL, 0x000fe200078e00ffULL, 0x00000028283c7811ULL, 0x000fe200078ff0ffULL,
0x00000004384c7824ULL, 0x000fe200078e00ffULL, 0x0000100032447811ULL, 0x000fe200078e60ffULL,
0x0000000134327824ULL, 0x100fe200078e0239ULL, 0x00000030283e7811ULL, 0x000fe200078ff0ffULL,
0x0000000136347824ULL, 0x100fe200078e0239ULL, 0x0000003828467811ULL, 0x000fe200078ff0ffULL,
0x0000000138367824ULL, 0x100fe200078e0239ULL, 0x00000003ff317819ULL, 0x100fe20000011628ULL,
0x000000013a387824ULL, 0x100fe200078e0239ULL, 0x0000003928307211ULL, 0x000fe200078ff0ffULL,
0x000000043a4e7824ULL, 0x000fe200078e00ffULL, 0x0000000331337812ULL, 0x100fe200078e4828ULL,
0x000000013c3a7824ULL, 0x040fe200078e0239ULL, 0xfffffffc2f2f7812ULL, 0x000fe200078ee228ULL,
0x000000043c507824ULL, 0x000fe200078e00ffULL, 0xfffffffc48437812ULL, 0x000fe200078ee233ULL,
0x000000013e3c7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4a457812ULL, 0x100fe200078ee233ULL,
0x000000043e527824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c477812ULL, 0x000fe200078ee233ULL,
0x00000001463e7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4e497812ULL, 0x100fe200078ee233ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc504b7812ULL, 0x100fe200078ee233ULL,
0x00005e0030307625ULL, 0x000fe200078e003fULL, 0xfffffffc524f7812ULL, 0x000fc400078ee233ULL,
0xfffffffc46517812ULL, 0x000fe200078ee233ULL, 0x00005e0034347625ULL, 0x000fe200078e003fULL,
0x0ffffffc33417812ULL, 0x000fc600078ef828ULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0036367625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x000000102f307825ULL, 0x000fc800078e0030ULL,
0x000000102f327825ULL, 0x000fc800078e0032ULL, 0x000000102f347825ULL, 0x000fc800078e0034ULL,
0x000000102f367825ULL, 0x000fc800078e0036ULL, 0x000000102f387825ULL, 0x000fc800078e0038ULL,
0x000000102f3a7825ULL, 0x000fc800078e003aULL, 0x000000102f3c7825ULL, 0x000fc800078e003cULL,
0x000000102f3e7825ULL, 0x000fc800078e003eULL, 0x00000010414d7824ULL, 0x100fe400078e0244ULL,
0x00000010432f7824ULL, 0x100fe400078e0244ULL, 0x0000001045417824ULL, 0x100fe200078e0244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304d7faeULL, 0x0003e2000b901c46ULL,
0x0000001047437824ULL, 0x100fe400078e0244ULL, 0x0000001049457824ULL, 0x100fe200078e0244ULL,
0x00000000322f7faeULL, 0x0003e2000b901c46ULL, 0x000000104b477824ULL, 0x000fc400078e0244ULL,
0x000000104f497824ULL, 0x100fe200078e0244ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x00000010514b7824ULL, 0x000fc600078e0244ULL, 0x0000000036437faeULL, 0x0003e8000b901c46ULL,
0x0000000038457faeULL, 0x0003e8000b901c46ULL, 0x000000003a477faeULL, 0x0003e8000b901c46ULL,
0x000000003c497faeULL, 0x0003e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002028317810ULL, 0x042fe20007ffe0ffULL, 0x00000002253f7824ULL, 0x000fe200078e0240ULL,
0xfffffff8283d7812ULL, 0x000fe200078ec0ffULL, 0x00000008422f7824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000000073d3d7812ULL, 0x000fc400078ef828ULL, 0x0000000731407812ULL, 0x000fe400078ef828ULL,
0x0000000728337812ULL, 0x000fe400078ec0ffULL, 0x00000001ff417819ULL, 0x000fe4000001163dULL,
0x00000001ff437819ULL, 0x000fe40000011640ULL, 0x000010003f3f7811ULL, 0x000fe400078e60ffULL,
0x00000008333e7812ULL, 0x000fc400078ef828ULL, 0x0000000341417812ULL, 0x000fe400078ec0ffULL,
0x0000000343437812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003c41307212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003c43357212ULL, 0x000fe400078e3cffULL, 0x000000013c487810ULL, 0x040fe20007ffe0ffULL,
0x000000043d307824ULL, 0x000fe200078e0230ULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000440347824ULL, 0x000fc400078e0235ULL, 0x0000001030307824ULL, 0x100fe200078e023fULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x0000001034347824ULL, 0x000fc800078e023fULL,
0x000000003030783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x00000018ff387819ULL, 0x002fe20000011430ULL, 0x00010000313b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011431ULL, 0x00000038004c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe20000011432ULL, 0x0001000037497824ULL, 0x004fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fc40000011433ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff467819ULL, 0x000fe20000011434ULL, 0x0000003900507306ULL, 0x0005e20000200c00ULL,
0x0000888030387816ULL, 0x042fe400000000ffULL, 0x00000018ff457819ULL, 0x000fe40000011435ULL,
0x00000018ff447819ULL, 0x000fe40000011436ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000003a00547306ULL, 0x0003e20000200c00ULL, 0x0001000030397824ULL, 0x044fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011437ULL, 0x0000010030307824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x00000038004a7306ULL, 0x0005e20000200c00ULL, 0x00008880313a7816ULL, 0x042fe200000000ffULL,
0x0000010031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000030004d7306ULL, 0x0003e20000200c00ULL, 0x0000888032387816ULL, 0x004fce00000000ffULL,
0x00000039004b7306ULL, 0x0004e20000200c00ULL, 0x0001000032307824ULL, 0x042fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100517306ULL, 0x0003e20000200c00ULL, 0x0000888033397816ULL, 0x004fe400000000ffULL,
0x00000018ff327819ULL, 0x000fca0000011432ULL, 0x0000003200557306ULL, 0x0005e20000200c00ULL,
0x0001000033317824ULL, 0x042fe200078e00ffULL, 0x000054104a4a7816ULL, 0x008fe2000000004bULL,
0x0000010033337824ULL, 0x000fe200078e00ffULL, 0x000054104d4b7816ULL, 0x000fe4000000004cULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0001000034327824ULL, 0x004fe200078e00ffULL, 0x0000003800527306ULL, 0x0003e80000200c00ULL,
0x00000018ff327819ULL, 0x000fc80000011432ULL, 0x0000003000537306ULL, 0x0004e20000200c00ULL,
0x0000004841387212ULL, 0x002fca00078e3cffULL, 0x000000043d387824ULL, 0x000fe400078e0238ULL,
0x0000003300587306ULL, 0x0003e20000200c00ULL, 0x0000888034307816ULL, 0x004fe200000000ffULL,
0x0000001038387824ULL, 0x000fe400078e023fULL, 0x0000010034347824ULL, 0x000fc800078e00ffULL,
0x0000003100577306ULL, 0x0005e20000200c00ULL, 0x0000004843337212ULL, 0x002fe400078e3cffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541052527816ULL, 0x008fe40000000053ULL,
0x0000541055537816ULL, 0x000fe20000000054ULL, 0x0000003000597306ULL, 0x0003e20000200c00ULL,
0x0000888035317816ULL, 0x004fce00000000ffULL, 0x00000032005a7306ULL, 0x0004e20000200c00ULL,
0x0001000035307824ULL, 0x042fe400078e00ffULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031005c7306ULL, 0x0003e20000200c00ULL,
0x0000000440327824ULL, 0x004fe200078e0233ULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000001032327824ULL, 0x000fc600078e023fULL, 0x0000003a004e7306ULL, 0x000fe20000200c00ULL,
0x0001000036317824ULL, 0x002fe200078e00ffULL, 0x00005410595a7816ULL, 0x008fc8000000005aULL,
0x00000018ff487819ULL, 0x000fe40000011431ULL, 0x0000003b004f7306ULL, 0x000e700000200c00ULL,
0x0000003900567306ULL, 0x0004f00000200c00ULL, 0x00000030005d7306ULL, 0x0009620000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x000054104e4e7816ULL, 0x002fc4000000004fULL,
0x00005410514f7816ULL, 0x000fc80000000050ULL, 0x00000034005b7306ULL, 0x0003e20000200c00ULL,
0x000000003230783bULL, 0x010f220000000200ULL, 0x0000541056567816ULL, 0x008fcc0000000057ULL,
0x00000035005e7306ULL, 0x0007e20000200c00ULL, 0x0000888036347816ULL, 0x042fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x000054105c5c7816ULL, 0x020fc8000000005dULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000004900637306ULL, 0x000fe20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003500627306ULL, 0x0004700000200c00ULL,
0x0000003600617306ULL, 0x0007e20000200c00ULL, 0x00000018ff357819ULL, 0x004fe2000001143bULL,
0x000100003a6e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000003500727306ULL, 0x0005e20000200c00ULL, 0x00000018ff497819ULL, 0x010fe40000011430ULL,
0x00000018ff367819ULL, 0x008fe40000011439ULL, 0x00000018ff6a7819ULL, 0x000fe40000011433ULL,
0x00000018ff687819ULL, 0x000fe20000011432ULL, 0x0000004900747306ULL, 0x0007e20000200c00ULL,
0x0001000038357824ULL, 0x004fe200078e00ffULL, 0x0000541062627816ULL, 0x002fc40000000063ULL,
0x00008880314c7816ULL, 0x000fc800000000ffULL, 0x00000034005f7306ULL, 0x0003e20000200c00ULL,
0x0000002f28497211ULL, 0x008fe400078fe0ffULL, 0x000000042f2f7810ULL, 0x000fca0007ffe0ffULL,
0x00000036006c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff347819ULL, 0x002fce0000011438ULL,
0x0000003400667306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x004fe40000011435ULL,
0x0000000749357812ULL, 0x040fe400078e783eULL, 0x0000000249497810ULL, 0x000fc60007ffe0ffULL,
0x000000103e357824ULL, 0x000fe200078e0235ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000004800607306ULL, 0x0002a20000200c00ULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000000749497812ULL, 0x000fe200078e783eULL, 0x0000001035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000000103e497824ULL, 0x000fe200078e0249ULL,
0x0000003700657306ULL, 0x0007e20000200c00ULL, 0x00000018ff487819ULL, 0x002fce000001143aULL,
0x0000003400647306ULL, 0x0003e20000200c00ULL, 0x00000018ff377819ULL, 0x008fe40000011431ULL,
0x000054105f607816ULL, 0x004fca0000000060ULL, 0x0000004800707306ULL, 0x000fe20000200c00ULL,
0x0001000039347824ULL, 0x002fce00078e00ffULL, 0x0000006a00487306ULL, 0x0003f00000200c00ULL,
0x0000003700767306ULL, 0x000fe20000200c00ULL, 0x00000018ff6a7819ULL, 0x002fce0000011434ULL,
0x0000003600677306ULL, 0x0002b00000200c00ULL, 0x0000006800777306ULL, 0x0007e20000200c00ULL,
0x000000003534783bULL, 0x002e6e0000000200ULL, 0x0000004700477306ULL, 0x000f220000200c00ULL,
0x0000888039687816ULL, 0x048fe200000000ffULL, 0x0000010039397824ULL, 0x000fe200078e00ffULL,
0x0000541064647816ULL, 0x004fc80000000067ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000004600467306ULL, 0x000eb00000200c00ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x0000541058577816ULL, 0x010fe20000000047ULL, 0x000000ffff477224ULL, 0x000fc400078e004cULL,
0x00010000314c7824ULL, 0x040fe400078e00ffULL, 0x0000010031317824ULL, 0x000fe400078e00ffULL,
0x0000004400447306ULL, 0x000f220000200c00ULL, 0x000054105b5b7816ULL, 0x004fe40000000046ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff4c7819ULL, 0x000fc6000001144cULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000004a3404723cULL, 0x002fe20000001804ULL,
0x000054105e5d7816ULL, 0x008fcc0000000045ULL, 0x0000003800697306ULL, 0x0002e20000200c00ULL,
0x0000541061617816ULL, 0x010fe20000000044ULL, 0x0000004e3408723cULL, 0x000fe20000001808ULL,
0x0001000032447824ULL, 0x000fca00078e00ffULL, 0x0000006a006b7306ULL, 0x0009e20000200c00ULL,
0x000088803a387816ULL, 0x042fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541065637816ULL, 0x004fe20000000042ULL, 0x00000052340c723cULL, 0x040fe2000000180cULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000039006d7306ULL, 0x0002a20000200c00ULL, 0x000088803b6a7816ULL, 0x010fe400000000ffULL,
0x0000541069657816ULL, 0x008fe20000000066ULL, 0x000000563410723cULL, 0x000fe80000001810ULL,
0x00000038006f7306ULL, 0x0007e20000200c00ULL, 0x000100003b397824ULL, 0x002fc400078e00ffULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000005a3414723cULL, 0x040fe40000001814ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00717306ULL, 0x0003e20000200c00ULL,
0x0000888030387816ULL, 0x008fe400000000ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005c3418723cULL, 0x000fe20000001818ULL, 0x000054106d697816ULL, 0x004fc6000000006cULL,
0x00000038004b7306ULL, 0x0005e20000200c00ULL, 0x00010000303a7824ULL, 0x042fe400078e00ffULL,
0x0000010030307824ULL, 0x000fe200078e00ffULL, 0x00000060341c723cULL, 0x000fe4000000181cULL,
0x00000018ff4a7819ULL, 0x000fe4000001143aULL, 0x0000003900737306ULL, 0x000fe20000200c00ULL,
0x0000001049387824ULL, 0x004fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011430ULL,
0x000000623420723cULL, 0x000fe80000001820ULL, 0x0000003b00757306ULL, 0x0003e60000200c00ULL,
0x0000010033377824ULL, 0x040fe200078e00ffULL, 0x0000888033347816ULL, 0x040fe200000000ffULL,
0x0001000033367824ULL, 0x000fc600078e00ffULL, 0x0000003000497306ULL, 0x0005e20000200c00ULL,
0x000000003838783bULL, 0x002e620000000200ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000018ff367819ULL, 0x000fc80000011436ULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x0000888032307816ULL, 0x044fe200000000ffULL, 0x0000010032327824ULL, 0x000fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000006e006e7306ULL, 0x000eb00000200c00ULL,
0x0000004a004a7306ULL, 0x000f220000200c00ULL, 0x0000541068687816ULL, 0x008fc4000000006bULL,
0x00005410756b7816ULL, 0x000fca0000000072ULL, 0x0000003100317306ULL, 0x000ee20000200c00ULL,
0x000054106f6e7816ULL, 0x004fe4000000006eULL, 0x00005410716f7816ULL, 0x000fca0000000070ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x000054104b4a7816ULL, 0x010fe2000000004aULL,
0x000000643804723cULL, 0x002fe20000001804ULL, 0x00005410494b7816ULL, 0x000fca0000000074ULL,
0x0000004400357306ULL, 0x000e620000200c00ULL, 0x00005410314d7816ULL, 0x008fe20000000076ULL,
0x000000683808723cULL, 0x040fec0000001808ULL, 0x0000006a006a7306ULL, 0x000ea40000200c00ULL,
0x0000006e380c723cULL, 0x040fec000000180cULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541030307816ULL, 0x002fe20000000035ULL, 0x0000004a3814723cULL, 0x000fec0000001814ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x000054106a6a7816ULL, 0x004fce0000000073ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x0000006a3810723cULL, 0x000fee0000001810ULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x00005410474c7816ULL, 0x002fce000000004cULL,
0x0000003600337306ULL, 0x000e620000200c00ULL, 0x0000541032317816ULL, 0x004fe20000000077ULL,
0x0000004c3818723cULL, 0x040fec0000001818ULL, 0x0000003700377306ULL, 0x000ea40000200c00ULL,
0x00000030381c723cULL, 0x000fe2000000181cULL, 0x0000541034347816ULL, 0x002fc40000000033ULL,
0x0000541037357816ULL, 0x004fce0000000048ULL, 0x000000343820723cULL, 0x000fe20000001820ULL,
0xfffff0f000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff407224ULL, 0x000fe200078e002eULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe4f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002a307f8cULL, 0x000fe2000c80043fULL,
0x0000001629397220ULL, 0x040fe20000410000ULL, 0x0000000629327220ULL, 0x040fe20000410000ULL,
0x0000000a29337220ULL, 0x040fe20000410000ULL, 0x000004002a2f7984ULL, 0x000e620000000800ULL,
0x0000000b29347220ULL, 0x040fe20000410000ULL, 0x0000000e29357220ULL, 0x040fe20000410000ULL,
0x0000001c29167220ULL, 0x040fe20000410000ULL, 0x0000000429047220ULL, 0x040fe20000410000ULL,
0x0000000529057220ULL, 0x040fe20000410000ULL, 0x0000000729077220ULL, 0x040fe20000410000ULL,
0x0000000829087220ULL, 0x040fe20000410000ULL, 0x0000000929097220ULL, 0x040fe20000410000ULL,
0x0000000c29007220ULL, 0x040fe20000410000ULL, 0x0000000d29067220ULL, 0x040fe20000410000ULL,
0x0000000f29367220ULL, 0x040fe20000410000ULL, 0x0000001229377220ULL, 0x040fe20000410000ULL,
0x0000001329387220ULL, 0x040fe20000410000ULL, 0x00000017293a7220ULL, 0x040fe20000410000ULL,
0x0000001a293b7220ULL, 0x040fe20000410000ULL, 0x0000001b293c7220ULL, 0x040fe20000410000ULL,
0x0000001e291c7220ULL, 0x040fe20000410000ULL, 0x0000001f293d7220ULL, 0x040fe20000410000ULL,
0x0000001429127220ULL, 0x040fe20000410000ULL, 0x0000001529137220ULL, 0x040fe20000410000ULL,
0x0000001829147220ULL, 0x040fe20000410000ULL, 0x0000001929157220ULL, 0x040fe20000410000ULL,
0x0000001d29177220ULL, 0x040fe20000410000ULL, 0x0000002029187220ULL, 0x040fe20000410000ULL,
0x0000002129197220ULL, 0x040fe20000410000ULL, 0x00000022293e7220ULL, 0x040fe20000410000ULL,
0x00000023293f7220ULL, 0x040fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0032ULL,
0x0000001029107220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0033ULL,
0x0000001129117220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0034ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0035ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0005ULL, 0x800000002fff7812ULL, 0x002fe20007804831ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff207224ULL, 0x000fe400078e0036ULL,
0x000000ffff217224ULL, 0x000fe400078e0037ULL, 0x000000ffff227224ULL, 0x000fe400078e0038ULL,
0x000000ffff237224ULL, 0x000fc400078e0039ULL, 0x000000ffff2f7224ULL, 0x000fe400078e003aULL,
0x000000ffff327224ULL, 0x000fe400078e003bULL, 0x000000ffff337224ULL, 0x000fe400078e003cULL,
0x000000ffff347224ULL, 0x000fe400078e001cULL, 0x000000ffff357224ULL, 0x000fe200078e003dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fc400078e003eULL, 0x000000ffff377224ULL, 0x000fe200078e003fULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004002a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004281c7824ULL, 0x000fe200078e00ffULL, 0x0000002c0300720cULL, 0x000fc80003f05270ULL,
0xfffffff01c007812ULL, 0x000fca00078ec0ffULL, 0x0000008025007824ULL, 0x000fca00078e0200ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000228087824ULL, 0x000fe400078e00ffULL, 0x00000001242d7824ULL, 0x000fc600078e0a2dULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108307812ULL, 0x040fe400078efcffULL,
0x0000000808387812ULL, 0x000fe400078efcffULL, 0x0000002d3000720cULL, 0x080fe40003f26070ULL,
0x0000001008307812ULL, 0x000fe400078efcffULL, 0x0000002d3800720cULL, 0x080fe40003f06070ULL,
0x0000002d3000720cULL, 0x000fc40003fc6070ULL, 0x0000001108387812ULL, 0x040fe400078efcffULL,
0x0000001808307812ULL, 0x040fe400078efcffULL, 0x0000002d0800720cULL, 0x080fe40003f46070ULL,
0x0000002d3800720cULL, 0x080fe40003fa6070ULL, 0x0000002d3000720cULL, 0x000fe40003f66070ULL,
0x00000009083a7812ULL, 0x000fc400078efcffULL, 0x0000001908387812ULL, 0x040fe400078efcffULL,
0x0000002008307812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000002d3a00720cULL, 0x080fe40003f86070ULL,
0x0000002d3800720cULL, 0x080fe40003f46070ULL, 0x0000002d3000720cULL, 0x000fe40003f26070ULL,
0x0000002108387812ULL, 0x040fe400078efcffULL, 0x0000002808307812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002d3800720cULL, 0x080fe40003f06070ULL, 0x0000002d3000720cULL, 0x000fe40003f86070ULL,
0x0000002908387812ULL, 0x000fc400078efcffULL, 0x0000003008307812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002d3800720cULL, 0x000fc40003fc6070ULL, 0x0000002d3000720cULL, 0x000fe40003fa6070ULL,
0x0000003108387812ULL, 0x040fe400078efcffULL, 0x0000003808307812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002d3800720cULL, 0x080fe40003f66070ULL,
0x0000002d3000720cULL, 0x000fc40003f46070ULL, 0x0000002d0800720cULL, 0x000fe40003f26070ULL,
0xff7fffff2f2f7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff32327808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff33337808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff34347808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff35357808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff36367808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff37377808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff3c7424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304047209ULL, 0x000fe40007810000ULL,
0x0000001308057209ULL, 0x000fe40007810000ULL, 0x0000002f04097209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000003209087209ULL, 0x000fc40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000003308097209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000003409087209ULL, 0x000fe40007810000ULL,
0x0000001704057209ULL, 0x000fe40007810000ULL, 0x0000003508097209ULL, 0x000fc40007810000ULL,
0x0000001805047209ULL, 0x000fe40007810000ULL, 0x0000003609087209ULL, 0x000fe40007810000ULL,
0x0000001904057209ULL, 0x000fe40007810000ULL, 0x0000003708317209ULL, 0x000fe20007810000ULL,
0x000018027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x0000000405397209ULL, 0x008fe20007810000ULL, 0x000018327f007947ULL, 0x000fea000b800000ULL,
0x0c401f0031047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0007307f89ULL, 0x000f2200000e0000ULL, 0x0000000431087209ULL, 0x008fc60007810000ULL,
0x0c201f0039047f89ULL, 0x000ee200000e0000ULL, 0x0000000506097209ULL, 0x004fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ea200000e0000ULL, 0x0000003007307209ULL, 0x010fc60007810000ULL,
0x0c201f0009387f89ULL, 0x002e6800000e0000ULL, 0x0c201f00302d7f89ULL, 0x00092200000e0000ULL,
0x0000000439047209ULL, 0x008fe40007810000ULL, 0x0000000508057209ULL, 0x004fe40007810000ULL,
0x0000003809067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05387820ULL, 0x002fe20000410000ULL, 0x3c003c00ff3a7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010838ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3c003c00ff3b7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010838ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010838ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f620000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000000ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x020fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003a083c723cULL, 0x000fee00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003a0c3c723cULL, 0x000fee000000183cULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002f001a7308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc28147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000003200327308ULL, 0x000fe60000000800ULL, 0x000000001d0473c4ULL, 0x000eea0000004000ULL,
0x0000003300337308ULL, 0x000f620000000800ULL, 0x000000231a11723eULL, 0x002fc400000000ffULL,
0x000000001d1a73a1ULL, 0x000e6a00000e8000ULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000323313723eULL, 0x020fce00000000ffULL, 0x0000001700177308ULL, 0x000f620000000800ULL,
0x0000003a103c723cULL, 0x000fee000000183cULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x000000051dff7c12ULL, 0x002fce000f80401aULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x000000161714723eULL, 0x020fce00000000ffULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000f620000000800ULL, 0x000000180716723eULL, 0x002fe400000000ffULL,
0x000000302d077209ULL, 0x014fca0007810000ULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000343515723eULL, 0x020fe400000000ffULL,
0x000000363717723eULL, 0x002fce00000000ffULL, 0x0000003a1438723cULL, 0x000fe2000000183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000136204008947ULL, 0x008fde000b800000ULL,
0x001c1fff38187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000138204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011628ULL,
0x0000000c1c3b7812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x0000000328ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3a7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4a7824ULL, 0x000fe200078e00ffULL, 0x000000021f307812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f327812ULL, 0x000fc400078ef61eULL,
0x000000041f347812ULL, 0x140fe400078ef61eULL, 0x000000051f367812ULL, 0x140fe400078ef61eULL,
0x000000061f387812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000251d7811ULL, 0x000fe400078e58ffULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee221ULL, 0xfffffff8233c7812ULL, 0x100fe200078ee21eULL,
0x00000010201c7824ULL, 0x100fe200078e021dULL, 0x000000011f3e7812ULL, 0x140fe200078ef61eULL,
0x0000001030207824ULL, 0x100fe200078e021dULL, 0x000000021f407812ULL, 0x140fe200078ef61eULL,
0x00000010342d7824ULL, 0x100fe200078e021dULL, 0x000000031f427812ULL, 0x140fe200078ef61eULL,
0x00000010362f7824ULL, 0x100fe200078e021dULL, 0x000000041f447812ULL, 0x140fe200078ef61eULL,
0x0000001038307824ULL, 0x100fe200078e021dULL, 0x000000051f467812ULL, 0x140fe200078ef61eULL,
0x000000103e347824ULL, 0x100fe200078e021dULL, 0x000000061f487812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001032227824ULL, 0x100fe400078e021dULL,
0x000000103a327824ULL, 0x100fe400078e021dULL, 0x000000013b1f7824ULL, 0x000fe400078e021cULL,
0x000000103c1c7824ULL, 0x100fe400078e021dULL, 0x0000001040357824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x0000001042367824ULL, 0x000fc400078e021dULL,
0x0000001044377824ULL, 0x100fe400078e021dULL, 0x0000001046387824ULL, 0x100fe400078e021dULL,
0x0000001048397824ULL, 0x100fe400078e021dULL, 0x000000104a3a7824ULL, 0x000fe400078e021dULL,
0x000000013b1d7824ULL, 0x040fe400078e021eULL, 0x000000013b217824ULL, 0x000fc400078e0220ULL,
0x000000013b237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x000000013b2d7824ULL, 0x040fe400078e022dULL, 0x000000013b2f7824ULL, 0x040fe200078e022fULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000013b317824ULL, 0x040fe400078e0230ULL,
0x000000013b337824ULL, 0x040fe200078e0232ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x000000013b1c7824ULL, 0x000fc400078e021cULL, 0x000000013b347824ULL, 0x040fe200078e0234ULL,
0x000000102d007388ULL, 0x0007e20000000800ULL, 0x000000013b1e7824ULL, 0x040fe400078e0235ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x000000013b087824ULL, 0x042fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x0000001431007388ULL, 0x0007e20000000800ULL, 0x000000013b207824ULL, 0x000fc400078e0239ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000001633007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b34007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f36007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001338007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x000000173a007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002bff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002bff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x000018002bff7f8cULL, 0x0003e6000c80043fULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc9a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff347807ULL, 0x010fe40004000000ULL,
0x00010a40003d7802ULL, 0x000fe40000000f00ULL, 0x00000f9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e003cULL, 0xffff0c7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe40004000000ULL, 0x00010a90003d7802ULL, 0x000fe40000000f00ULL,
0x00000f4000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e003cULL,
0xffff0cb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0000ULL,
0x00010b0000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000e9000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e003cULL, 0xffff0d0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e0000ULL, 0x00010b7000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x00000e2000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003cULL,
0xffff0cc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0036ULL,
0x00010be000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x00000db000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e003cULL, 0xffff102000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e003aULL, 0x00010c5000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000d4000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003cULL,
0xffff0fe000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x010fe40004000000ULL,
0x00010ca0003d7802ULL, 0x000fc40000000f00ULL, 0x00000d3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e003cULL, 0xffff2aa000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe40004000000ULL, 0x00010cf0003d7802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e003cULL,
0xffff2ae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3d7224ULL, 0x008fe200078e0036ULL,
0x00010d6000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x00000c3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003cULL, 0xffff2b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3d7224ULL, 0x002fe200078e0036ULL, 0x00010de000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x008fe400078e003aULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x00000bb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003cULL, 0xffff2be000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x00010e4000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e003cULL, 0xffff2ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e003aULL, 0x00010eb000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x00000ae000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003cULL,
0xffff2e5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x002fe40004000000ULL,
0x00010f00003d7802ULL, 0x000fe40000000f00ULL, 0x00000ad000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e003cULL, 0xffff44e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe40004000000ULL, 0x00010f50003d7802ULL, 0x000fe40000000f00ULL,
0x00000a8000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e003cULL,
0xffff452000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3d7224ULL, 0x002fe200078e0036ULL,
0x00010fc000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000009d000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003cULL, 0xffff458000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3d7224ULL, 0x002fe200078e0036ULL, 0x0001104000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fc400078e003aULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000095000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003cULL, 0xffff462000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x000110a000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x000008f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff5f7224ULL, 0x004fe200078e003cULL, 0xffff48d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e003aULL, 0x0001111000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000088000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003cULL,
0xffff488000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x010fe40004000000ULL,
0x00011160003d7802ULL, 0x000fc40000000f00ULL, 0x0000087000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0xffff5f3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe40004000000ULL, 0x000111b0003d7802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e003cULL,
0xffff5f7000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x008fe200078e00ffULL,
0x0001121000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e003cULL,
0xffff5fe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x00afe200078e003aULL,
0x0001128000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e003cULL, 0xffff609000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x000112e000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x000006b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e003cULL, 0xffff635000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e003aULL, 0x0001135000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003cULL,
0xffff630000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0005ULL,
0x000113b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x000fc400078e00ffULL,
0x000005a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002dULL,
0xffffe7b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0031ULL,
0x0001141000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fc400078e00ffULL,
0x0000054000007944ULL, 0x004fea0003c00000ULL, 0x0000002d313a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x0001146000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fc400078e00ffULL, 0x000004f000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0007ULL,
0x000114b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002d07307209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0039ULL, 0x0001150000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000002d39047209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e003aULL,
0x0001155000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x0000002d3a057209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x000115a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0030ULL,
0x000115f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0xffffe67000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3d7224ULL, 0x000fe200078e0038ULL, 0x0001166000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff407224ULL, 0x000fe400078e001dULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e003cULL, 0xffffec3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3d7224ULL, 0x002fe200078e003aULL, 0x000116e000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff407224ULL, 0x000fe400078e001dULL, 0x000002b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x002fe200078e00ffULL, 0x0001174000347802ULL, 0x000fe20000000f00ULL,
0x00001c1fff3f7424ULL, 0x000fc400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e003cULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff407224ULL, 0x002fe200078e001dULL, 0x000117a000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e003cULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e003cULL, 0xffffeb7000007947ULL, 0x000fea000383ffffULL,
0x0180000029027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000002900028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff29ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000029037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002900027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffee6b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c0000382d2d7389ULL, 0x0002a200000e003bULL,
0xfffee67008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0000003e3d3c7389ULL, 0x0002a200000e003fULL,
0xfffee63034007950ULL, 0x000fea0003c3ffffULL, 0x000000013400780cULL, 0x000fe20003f05070ULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x00000000ff357424ULL, 0x000fd000078e00ffULL,
0x0000000000347806ULL, 0x000fc800040e0100ULL, 0x00000039343c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff347224ULL, 0x000fc800078e003dULL, 0xfffee5c034007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000498ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a78ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b08ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001388ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000013a8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013b8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013d8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001468ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001470ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001480ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000011b00ULL, 0x9800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013180ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013190ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013190ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001468ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011d18ULL, 0x0000000000011d18ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013610ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin_len = 79600;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
