/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013490ULL, 0x0000000000013010ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000011720ULL, 0x0000000000000190ULL,
0x000e002200000106ULL, 0x00000000000118b0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000118f0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000011930ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000011a80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001172000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0044880400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8093082880808a08ULL, 0x0828808098082880ULL,
0x80809c0828808099ULL, 0xca082880809d0828ULL, 0x288080f608288080ULL, 0x8280162880808708ULL,
0x0000000003102880ULL, 0x8080879200000000ULL, 0x0000000000220028ULL, 0x00000044ffffffffULL,
0x0000007000000000ULL, 0x0001172000000000ULL, 0x0000019000000000ULL, 0x0000480400000000ULL,
0x8082288080830900ULL, 0x0900000010042880ULL, 0x2880808428808082ULL, 0x8087090000000404ULL,
0x0000288080822880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8091082880808a08ULL, 0x0828808093082880ULL, 0x8080990828808098ULL,
0xca082880809d0828ULL, 0x288080f608288080ULL, 0x8280162880809c08ULL, 0x0000000003102880ULL,
0x80809c9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000014800000000ULL,
0x000118b000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL, 0x8091082880808a08ULL,
0x0828808093082880ULL, 0x80809c0828808099ULL, 0xca082880809d0828ULL, 0x288080f608288080ULL,
0x8280162880809808ULL, 0x0000000003102880ULL, 0x8080989200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x000001f800000000ULL, 0x000118f000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8091082880808a08ULL, 0x0828808093082880ULL, 0x8080990828808098ULL,
0xca082880809c0828ULL, 0x288080f608288080ULL, 0x8280162880809d08ULL, 0x0000000003102880ULL,
0x80809d9200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000002a800000000ULL,
0x0001193000000000ULL, 0x0000015000000000ULL, 0x0000140400000000ULL, 0x80982880809d0900ULL,
0x0000000000002880ULL, 0x0000001200082f04ULL, 0x0008120400000098ULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL, 0x0048000700000000ULL,
0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL,
0x000100500000fb50ULL, 0x0001016000010070ULL, 0x0001018000010170ULL, 0xffffffff01602904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000024ffffffffULL,
0x0500002405000024ULL, 0xffffffff05000024ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01602804ffffffffULL,
0x00000110000000f0ULL, 0x00001740000016b0ULL, 0x0000183000001800ULL, 0x00001c3000001c00ULL,
0x00001cf000001c90ULL, 0x000037d000003740ULL, 0x000039c0000038a0ULL, 0x00003d0000003ce0ULL,
0x00003dc000003d60ULL, 0x000054a000005410ULL, 0x0000569000005570ULL, 0x000059c0000059a0ULL,
0x00005a8000005a20ULL, 0x00007180000070f0ULL, 0x0000737000007250ULL, 0x000076b000007690ULL,
0x0000777000007710ULL, 0x0000889000008880ULL, 0x0000af200000ade0ULL, 0x0000b7100000b6e0ULL,
0x0000fa500000fa20ULL, 0x0000fa700000fa60ULL, 0x0000fab00000fa90ULL, 0x0000fae00000fad0ULL,
0x000101b000010150ULL, 0x000101d0000101c0ULL, 0x00010950000108f0ULL, 0x00010a30000109c0ULL,
0x00010b0000010a90ULL, 0x00010bc000010b60ULL, 0x00010c8000010c20ULL, 0x00010d4000010cd0ULL,
0x00010e0000010da0ULL, 0x00010ec000010e60ULL, 0x00010f8000010f10ULL, 0x0001104000010fe0ULL,
0x00011100000110a0ULL, 0x000111c000011150ULL, 0x000112b000011230ULL, 0x0001139000011320ULL,
0x0001147000011400ULL, 0x00011550000114e0ULL, 0x00011640000115c0ULL, 0x00011700000116a0ULL,
0x000001f004c03904ULL, 0x0000f600000000ffULL, 0x00000270003f0100ULL, 0x0000f6080000000bULL,
0x000002c0003f0120ULL, 0x0000f6880000000bULL, 0x00000360003f0120ULL, 0x0000f6a80000000bULL,
0x00000390003f0120ULL, 0x0000f6c80000000bULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x000006c0003f0107ULL, 0x0000f68c00000007ULL, 0x00000a00003f0102ULL, 0x0000f68800000007ULL,
0x00000b40003f0101ULL, 0x00000000000000ffULL, 0x00000bd000040107ULL, 0x00000000000000ffULL,
0x00000c3000040101ULL, 0x000000200000000cULL, 0x00000d50003f0101ULL, 0x000000040000000dULL,
0x00000db0003f0105ULL, 0x000000240000000cULL, 0x00000e30003f0105ULL, 0x000000240000000cULL,
0x00001390003f0105ULL, 0x0000000000000048ULL, 0x00001460003f0107ULL, 0x0000000000000048ULL,
0x00001470003f0101ULL, 0x000000040000001cULL, 0x000014e0003f0105ULL, 0x0000f60800000010ULL,
0x00001500003f0101ULL, 0x0000f60c00000010ULL, 0x000015c0003f0105ULL, 0x0000f60c00000016ULL,
0x00001af0003f0105ULL, 0x000000040000001cULL, 0x00001b70003f0105ULL, 0x000000040000001cULL,
0x00002de0003f0105ULL, 0x000000200000000cULL, 0x00002e60003f0101ULL, 0x0000f6880000005eULL,
0x00002eb0003f0101ULL, 0x000000040000000dULL, 0x00002f00003f0105ULL, 0x000000240000000cULL,
0x00002f80003f0105ULL, 0x000000240000000cULL, 0x000034a0003f0105ULL, 0x0000000000000050ULL,
0x00003520003f0107ULL, 0x0000000000000050ULL, 0x00003530003f0101ULL, 0x000000040000004fULL,
0x000035a0003f0105ULL, 0x0000f62800000010ULL, 0x000035c0003f0101ULL, 0x0000f62c00000010ULL,
0x00003690003f0105ULL, 0x0000f62c0000001bULL, 0x00003bb0003f0105ULL, 0x0000f6ac0000001aULL,
0x00003c30003f0105ULL, 0x0000f6ac0000001aULL, 0x00004d20003f0105ULL, 0x000000200000000cULL,
0x00004d90003f0101ULL, 0x0000f6900000005eULL, 0x00004dd0003f0101ULL, 0x000000040000000dULL,
0x00004e20003f0105ULL, 0x000000240000000cULL, 0x00004ea0003f0105ULL, 0x000000240000000cULL,
0x000051b0003f0105ULL, 0x000000000000004fULL, 0x00005230003f0107ULL, 0x000000000000004fULL,
0x00005240003f0101ULL, 0x0000000400000050ULL, 0x000052b0003f0105ULL, 0x0000f64800000010ULL,
0x000052d0003f0101ULL, 0x0000f64c00000010ULL, 0x00005360003f0105ULL, 0x0000f64c00000010ULL,
0x00005870003f0105ULL, 0x0000f6ac00000019ULL, 0x000058f0003f0105ULL, 0x0000f6ac00000019ULL,
0x000069c0003f0105ULL, 0x000000200000000cULL, 0x00006a30003f0101ULL, 0x0000f6980000005eULL,
0x00006a80003f0101ULL, 0x000000040000000dULL, 0x00006ad0003f0105ULL, 0x000000240000000cULL,
0x00006b50003f0105ULL, 0x000000240000000cULL, 0x00006e90003f0105ULL, 0x0000000000000050ULL,
0x00006f10003f0107ULL, 0x0000000000000062ULL, 0x00006f20003f0101ULL, 0x000000040000004fULL,
0x00006f90003f0105ULL, 0x0000f66800000010ULL, 0x00006fb0003f0101ULL, 0x0000f66c00000010ULL,
0x00007040003f0105ULL, 0x0000f66c00000010ULL, 0x00007560003f0105ULL, 0x0000f6ac00000010ULL,
0x000075e0003f0105ULL, 0x0000f6ac00000010ULL, 0x00008610003f0105ULL, 0x000000200000000cULL,
0x00008670003f0101ULL, 0x0000f6a00000005eULL, 0x0000c400003f0101ULL, 0x0000f600000000ffULL,
0x0000cef0003f0101ULL, 0x0000f604000000ffULL, 0x0000cf90003f0105ULL, 0x0000f604000000ffULL,
0x0000d1a0003f0105ULL, 0x0000f600000000ffULL, 0x0000d1b0003f0101ULL, 0x0000f604000000ffULL,
0x0000d240003f0105ULL, 0x0000f604000000ffULL, 0x0000efe0003f0105ULL, 0x0000000000000033ULL,
0x0000f010003f0101ULL, 0x0000000400000033ULL, 0x0000f340003f0105ULL, 0x0000000400000033ULL,
0x00010740003f0105ULL, 0x0000000000000034ULL, 0x000107a0003f0101ULL, 0x0000000800000034ULL,
0x00010800003f0101ULL, 0x0000001000000034ULL, 0x00010870003f0101ULL, 0x0000001800000034ULL,
0x00053803003f0101ULL, 0x0000c10000141c04ULL, 0x0000d2a00000c350ULL, 0x000108b00000d340ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000344ULL, 0x0000001200000002ULL,
0x0000000000000294ULL, 0x0000001200000002ULL, 0x00000000000001e4ULL, 0x0000001200000002ULL,
0x000000000000010cULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x000000000000031cULL, 0x0000001200000002ULL, 0x000000000000026cULL, 0x0000001200000002ULL,
0x00000000000001bcULL, 0x0000001200000002ULL, 0x00000000000000e4ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001400047300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff157424ULL, 0x000fc600078e00ffULL,
0x0000000000307919ULL, 0x000f220000002600ULL, 0x0000001400147309ULL, 0x000f660000000000ULL,
0x0000000000127919ULL, 0x000ee80000002700ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x00000005ff447819ULL, 0x002fcc000001160bULL, 0x00001fff44447589ULL, 0x000fe200000e0000ULL,
0x000000010d007824ULL, 0x004fc600078e0200ULL, 0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL,
0x00000080000b7824ULL, 0x000fc600078e020bULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000830067824ULL, 0x010fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f45270ULL,
0x0000000f0b00780cULL, 0x000fe20003f64070ULL, 0x0000001207087224ULL, 0x008fe200078e0206ULL,
0x000000030b00780cULL, 0x040fe40003f24070ULL, 0x0000007f0b00780cULL, 0x000fe40003f84070ULL,
0x000000050400720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL, 0x000000040d067824ULL, 0x002fe400078e0244ULL,
0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010b00780cULL, 0x000fe20003f44070ULL, 0x0000000206097824ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x004fe20000011600ULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x040fe20007800000ULL,
0x00000001090f7824ULL, 0x000fe200078e020cULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000108027824ULL, 0x002fe200078e020fULL,
0x000000070f117812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x00f688060b009388ULL, 0x000be20000008a00ULL, 0xff317217ff10c424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f400100b00c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff049424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fe200078e0015ULL,
0x00f6a8040b009388ULL, 0x0005e40000008a00ULL, 0x000000f00e137812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x020fe200078e0a14ULL, 0x00f6c8080b00a388ULL, 0x0007e20000008a00ULL,
0x0000000f11107812ULL, 0x002fc600078e7800ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001302027210ULL, 0x000fe20007f9e0ffULL, 0x000000100f107824ULL, 0x000fe400078e0210ULL,
0x00000004ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x0000001010077824ULL, 0x000fe400078e00ffULL, 0x0000600012047625ULL, 0x004fc600078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0007e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0007e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604027981ULL, 0x008ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff467e24ULL, 0x002fe2000f8e00ffULL,
0x000000ff02037810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff037819ULL, 0x000fce0000011603ULL,
0x0000be1000008947ULL, 0x000fea0003800000ULL, 0x0000580030057a10ULL, 0x000fe20007ffe0ffULL,
0x0000000212047824ULL, 0x000fe200078e00ffULL, 0x0000000146067810ULL, 0x000fe20007ffe0ffULL,
0x0000001044077824ULL, 0x000fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x0000580004047a24ULL, 0x000fe200078e0205ULL, 0x000000030600720cULL, 0x000fe20003f06070ULL,
0x00000003ff127424ULL, 0x000fe200078e00ffULL, 0x0000001007057812ULL, 0x000fe200078ec0ffULL,
0x0000000844077824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc40000011644ULL,
0x0000000415167810ULL, 0x000fe20007ffe0ffULL, 0x00000001050a7824ULL, 0x000fe400078e0215ULL,
0x0000000846097824ULL, 0x000fe400078e0206ULL, 0x000000080a0b7824ULL, 0x040fe200078e00ffULL,
0x000000000a087212ULL, 0x000fe200078e3cffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001050d7824ULL, 0x000fe200078e0216ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL,
0x0000002009097824ULL, 0x000fe200078e00ffULL, 0x0000000815187810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000000d0c7212ULL, 0x080fe200078e3cffULL,
0x00f68c1207ff738cULL, 0x0003e20000000000ULL, 0x0000000902087217ULL, 0x000fe20007800000ULL,
0x0000000105107824ULL, 0x000fe200078e0218ULL, 0x0000000c151a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff1e7424ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL,
0x00000001080c7824ULL, 0x100fe200078e0a09ULL, 0x00000000060473c2ULL, 0x0004e200000e0000ULL,
0x0000000105137824ULL, 0x000fe200078e021aULL, 0x000000700e1f7812ULL, 0x000fe200078ec0ffULL,
0x0000620004097a24ULL, 0x000fe200078e0209ULL, 0x0000000010127212ULL, 0x082fe200078e3cffULL,
0x0000200006087824ULL, 0x000fe200078e00ffULL, 0x0000000013147212ULL, 0x000fe200078e3cffULL,
0x0000000810177824ULL, 0x000fc400078e00ffULL, 0x0000000109117824ULL, 0x040fe200078e0210ULL,
0x0000b00008107810ULL, 0x000fe20007ffe0ffULL, 0x00000001091c7824ULL, 0x000fe400078e0213ULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x00000001090a7824ULL, 0x040fe400078e020aULL,
0x00000001090d7824ULL, 0x000fe200078e020dULL, 0xfffffff817097812ULL, 0x000fe200078ee212ULL,
0x000000100b177824ULL, 0x000fe200078e0210ULL, 0xfffffff813137812ULL, 0x000fe200078ee214ULL,
0x00005e000a0a7625ULL, 0x000fe200078e001eULL, 0x000000200c147807ULL, 0x000fc60000000000ULL,
0x000000100f197824ULL, 0x100fe200078e0210ULL, 0x0000001f0a127210ULL, 0x000fe20007f1e0ffULL,
0x00000010091b7824ULL, 0x100fe200078e0210ULL, 0x0000000514147217ULL, 0x000fe20007800000ULL,
0x00000010131d7824ULL, 0x000fe400078e0210ULL, 0x00005e00110e7625ULL, 0x000fc800078e001eULL,
0x00005e000d0c7625ULL, 0x000fe200078e001eULL, 0x0000001f0e0e7210ULL, 0x000fc60007f3e0ffULL,
0x00005e001c107625ULL, 0x000fc800078e001eULL, 0x000000ffff137224ULL, 0x000fe200000e060bULL,
0x0000001f0c0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a05ULL,
0x0000001f10107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe400008e060fULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000141500720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000141600720cULL, 0x080fe40003f26070ULL,
0x000000141800720cULL, 0x000fc40003f46070ULL, 0x000000141a00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f6880007ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000144097812ULL, 0x000fe200078ec0ffULL,
0xff317217ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000c101c46ULL,
0x000000034600720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000000c197faeULL, 0x0005e2000c901c46ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000000e1b7faeULL, 0x0003e2000d101c46ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a8060c7811ULL, 0x004fc600078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff627f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000020000c0e7f8cULL, 0x0022e2000c80043fULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000200c0d7810ULL, 0x000fe20007ffe0ffULL, 0x00007a0000000947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x00afe400078e000fULL, 0xff317217ff0a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x00000100460f7824ULL, 0x000fca00078e00ffULL, 0x000000020f00720cULL, 0x000fda0003f06070ULL,
0x0000795000000947ULL, 0x006fea0003800000ULL, 0x000004000d067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e004bULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024000c067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000f7305ULL, 0x0002e4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x008fe20003800000ULL, 0x000024000c107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x00000100460f7824ULL, 0x040fe200078e00ffULL,
0x0000000146107810ULL, 0x000fe20007ffe0ffULL, 0x000010004b117824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe20000011644ULL, 0x0000000105127824ULL, 0x000fe200078e021dULL,
0x000000031000720cULL, 0x000fe20003f06070ULL, 0x00000010001f7824ULL, 0x000fe200078e00ffULL,
0x000000041d207810ULL, 0x040fe20007ffe0ffULL, 0x0000000812167824ULL, 0x040fe200078e00ffULL,
0x0000000012137212ULL, 0x080fe200078e3cffULL, 0x0000002006107824ULL, 0x000fe200078e020fULL,
0x0000000c1d237810ULL, 0x000fe20007ffe0ffULL, 0x0000000105157824ULL, 0x000fe200078e0220ULL,
0xfffffff8165b7812ULL, 0x000fe200078ee213ULL, 0x00000080ff1e7424ULL, 0x000fe200078e00ffULL,
0x0000100011137812ULL, 0x000fe200078e0cffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0x0000004010117810ULL, 0x000fe20007ffe0ffULL, 0x0000000105197824ULL, 0x000fe200078e0223ULL,
0x0000000015167212ULL, 0x000fe200078e3cffULL, 0x0000200006137824ULL, 0x000fe200078e0213ULL,
0x0000001102107217ULL, 0x000fe20007800000ULL, 0x0000043000007945ULL, 0x000fe20003800000ULL,
0x000000081d227810ULL, 0x000fc40007ffe0ffULL, 0xfffffff817177812ULL, 0x000fe200078ee216ULL,
0x0000000110107824ULL, 0x100fe200078e0a11ULL, 0x0000000019167212ULL, 0x080fe200078e3cffULL,
0x0000620004117a24ULL, 0x000fe200078e0211ULL, 0x000000701f217812ULL, 0x000fe200078ec0ffULL,
0x00000001051b7824ULL, 0x000fe200078e0222ULL, 0x0000b00013587810ULL, 0x000fe20007ffe0ffULL,
0x00000001191c7824ULL, 0x140fe400078e0211ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x000000001b187212ULL, 0x000fe200078e3cffULL, 0x0000000112127824ULL, 0x000fc400078e0211ULL,
0x000000081b597824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee216ULL,
0x0000000115157824ULL, 0x100fe200078e0211ULL, 0x0000002010167807ULL, 0x000fe20000000000ULL,
0x000000011b1b7824ULL, 0x000fe200078e0211ULL, 0xfffffff859597812ULL, 0x000fe200078ee218ULL,
0x00005e0012107625ULL, 0x000fe200078e001eULL, 0x00000016051a7217ULL, 0x000fc60007800000ULL,
0x00005e0015127625ULL, 0x080fe200078e001eULL, 0x0000002110167210ULL, 0x080fe40007f1e0ffULL,
0x0000000807157812ULL, 0x000fe200078ec0ffULL, 0x00000010175a7824ULL, 0x000fe200078e0258ULL,
0x0000002112187210ULL, 0x000fe20007f5e0ffULL, 0x000000011a1a7824ULL, 0x000fe400078e0a05ULL,
0x000000ffff177224ULL, 0x000fe400000e0611ULL, 0x00005e001b107625ULL, 0x000fe200078e001eULL,
0x0000001a1d00720cULL, 0x000fc40003f06070ULL, 0x0000001a2200720cULL, 0x080fe20003f66070ULL,
0x000000105b5b7824ULL, 0x100fe200078e0258ULL, 0x0000001a2300720cULL, 0x080fe20003f86070ULL,
0x0000001059597824ULL, 0x100fe400078e0258ULL, 0x0000001019587824ULL, 0x000fe400078e0258ULL,
0x000000ffff197224ULL, 0x000fe200010e0613ULL, 0x0000001a2000720cULL, 0x000fe20003f46070ULL,
0x00005e001c127625ULL, 0x000fe200078e001eULL, 0x00000021101a7210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000165b7faeULL, 0x0003e2000c101c46ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x000000084b1d7824ULL, 0x000fe200078e00ffULL,
0x0000002112127210ULL, 0x000fe20007fde0ffULL, 0x0000001006107824ULL, 0x000fc400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e0611ULL, 0x000000081d117812ULL, 0x000fe200078e0cffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000f6a8101c7810ULL, 0x040fe20007ffe0ffULL,
0x00000000185a7faeULL, 0x0003e2000d101c46ULL, 0x0000001010107812ULL, 0x000fc600078ec0ffULL,
0x000000011c487824ULL, 0x000fe200078e0211ULL, 0x000000001a597faeULL, 0x0003e2000d901c46ULL,
0xffffffe007117812ULL, 0x000fc600078ec0ffULL, 0x0000000012587faeULL, 0x0003e2000e101c46ULL,
0x0000001115107210ULL, 0x000fc60007ffe010ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000480403c2ULL, 0x000ee40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011c1c7824ULL, 0x000fe200078e021dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000048487f8cULL, 0x000ee8000c80043fULL, 0x000004001c167984ULL, 0x0023220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080010127f8cULL, 0x000fe2000c80043fULL, 0x8000000016ff7812ULL, 0x014fc60007844863ULL,
0x00f60c0010157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x0000001007167812ULL, 0x000fca00078ec0ffULL,
0x0000000111167824ULL, 0x000fe400078e0216ULL, 0x3e000000ff117424ULL, 0x000fe400078e00ffULL,
0x0000000809167824ULL, 0x000fe400078e0216ULL, 0x0000001100157305ULL, 0x000524000021f000ULL,
0x3fa0000011117823ULL, 0x004fe200000100ffULL, 0x000000150000735dULL, 0x010fe40003800000ULL,
0x00f60c0016157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002044127824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe40000011600ULL, 0x000000701f117812ULL, 0x000fe400078ec0ffULL,
0xffffff8012127812ULL, 0x000fe400078ec0ffULL, 0x0000000c13137812ULL, 0x000fc800078ec0ffULL,
0x0000001213157210ULL, 0x000fca0007ffe011ULL, 0x00f00000151b7984ULL, 0x000ea80000000800ULL,
0x00f2000015167984ULL, 0x0008620000000800ULL, 0x0000000a1b00720bULL, 0x004fe20003f1d000ULL,
0x0000f2127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x010fc800000e0100ULL,
0x0000ffff151e7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff157819ULL, 0x000fe40000011644ULL, 0x0000000a1b00720bULL, 0x000fe40003f14000ULL,
0x000000441500720cULL, 0x000fe20003f65270ULL, 0x0000f1e27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000157806ULL, 0x000fe400000e0100ULL, 0x000000804418b824ULL, 0x000fe200078e0211ULL,
0x0000001b0a1d7209ULL, 0x040fe40007810000ULL, 0x0000ffff15157812ULL, 0x000fe200078e3cffULL,
0x000000011318b824ULL, 0x000fe400078e0218ULL, 0x8000001d0a0a7221ULL, 0x000fe20000010000ULL,
0x000000151eff7212ULL, 0x000fc4000780c0ffULL, 0x00f4001d1800b388ULL, 0x0005e20000000800ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fe20000410000ULL, 0x00000002ff157819ULL, 0x000fc60000011600ULL,
0x0000000a005f7308ULL, 0x0005220000000800ULL, 0x0000f1827f007947ULL, 0x000fea000b800000ULL,
0x00001f155f0a7589ULL, 0x01452400000e0000ULL, 0x0000000815157810ULL, 0x004fe20007ffe0ffULL,
0x0000f1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f155f237589ULL, 0x00052400000e0000ULL,
0x8000001d1b1b0221ULL, 0x000fe20000010000ULL, 0x00000001ff177807ULL, 0x000fe20000000000ULL,
0x0000000a25257220ULL, 0x090fe40000410000ULL, 0x3fb8aa3b1b1b0820ULL, 0x000fe40000410000ULL,
0x0000000a24247220ULL, 0x080fe40000410000ULL, 0x0000001b00140308ULL, 0x000f220000000800ULL,
0x0000000a41417220ULL, 0x000fc40000410000ULL, 0x0000000a40407220ULL, 0x080fe40000410000ULL,
0x0000000a3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000a3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000a39397220ULL, 0x080fe40000410000ULL, 0x0000000a38387220ULL, 0x080fe40000410000ULL,
0x0000000a35357220ULL, 0x000fc40000410000ULL, 0x0000000a34347220ULL, 0x080fe40000410000ULL,
0x0000000a31317220ULL, 0x080fe40000410000ULL, 0x0000000a30307220ULL, 0x080fe40000410000ULL,
0x0000000a2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000a2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000a29297220ULL, 0x000fc40000410000ULL, 0x0000000a28287220ULL, 0x000fe40000410000ULL,
0x0000005f0b0b7220ULL, 0x000fe40000410000ULL, 0x0000002327277220ULL, 0x084fe40000410000ULL,
0x0000002326267220ULL, 0x080fe40000410000ULL, 0x0000002343437220ULL, 0x080fe40000410000ULL,
0x0000002342427220ULL, 0x000fc40000410000ULL, 0x000000233f3f7220ULL, 0x080fe40000410000ULL,
0x000000233e3e7220ULL, 0x080fe40000410000ULL, 0x000000233b3b7220ULL, 0x080fe40000410000ULL,
0x000000233a3a7220ULL, 0x080fe40000410000ULL, 0x0000002337377220ULL, 0x080fe40000410000ULL,
0x0000002336367220ULL, 0x000fc40000410000ULL, 0x0000002333337220ULL, 0x080fe40000410000ULL,
0x0000002332327220ULL, 0x080fe40000410000ULL, 0x000000232f2f7220ULL, 0x080fe40000410000ULL,
0x000000232e2e7220ULL, 0x080fe40000410000ULL, 0x000000232b2b7220ULL, 0x080fe40000410000ULL,
0x000000232a2a7220ULL, 0x000fc40000410000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e001dULL,
0x0000001416160220ULL, 0x012fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000b160b7221ULL, 0x002fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004001c167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fe40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff157424ULL, 0x000fc800078e00ffULL,
0x0000001500167305ULL, 0x0002a4000021f000ULL, 0x3fa0000015157823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x000004001c167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000014ff15723eULL, 0x000fe400000000ffULL, 0x00000002ff167819ULL, 0x000fe40000011600ULL,
0x00005410155f7816ULL, 0x000fe20000000015ULL, 0x0000ee527f007947ULL, 0x000fea000b800000ULL,
0x00001f165f4f7589ULL, 0x0002a400000e0000ULL, 0x0000000816157810ULL, 0x000fe20007ffe0ffULL,
0x0000ee927f007947ULL, 0x000fea000b800000ULL, 0x00001f155f507589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000010164a7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff1a7424ULL, 0x000fe200078e00ffULL, 0x00001ca000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x0000fc5000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000018164a7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff1a7424ULL, 0x000fe200078e00ffULL, 0x00001d0000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x0000fbf000007944ULL, 0x01cfea0003c00000ULL,
0x00000002445e7824ULL, 0x000fe200078e00ffULL, 0x0000000700197812ULL, 0x000fe200078ec0ffULL,
0x00000200444c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000045e6d7812ULL, 0x000fc400078ec0ffULL, 0x00000008196c7812ULL, 0x000fe400078ef800ULL,
0x0000006d006d7211ULL, 0x000fe400078fe0ffULL, 0xfffff8004c4c7812ULL, 0x000fe400078ec0ffULL,
0x000000076d197812ULL, 0x000fca00078e786cULL, 0x000000086c1b7824ULL, 0x000fe200078e0219ULL,
0x0000000800197812ULL, 0x000fc600078ec0ffULL, 0x000000101b167824ULL, 0x002fe400078e024cULL,
0x0000000444187824ULL, 0x040fe200078e00ffULL, 0x0000991017177816ULL, 0x000fe200000000ffULL,
0x00001000441a7824ULL, 0x000fe200078e00ffULL, 0x000000026d6d7810ULL, 0x000fe20007ffe0ffULL,
0x000010004b547824ULL, 0x000fe200078e0208ULL, 0x00000004181b7812ULL, 0x000fe400078ec0ffULL,
0xffffe0001a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000000719187812ULL, 0x000fe400078ec800ULL,
0x0000001b001b7211ULL, 0x000fe200078fe0ffULL, 0x000010004b1c7824ULL, 0x000fe200078e021aULL,
0x0000000719197812ULL, 0x000fc400078ef800ULL, 0x0000001b181a7212ULL, 0x000fe400078e3cffULL,
0x0000b0001c4d7810ULL, 0x000fe40007ffe0ffULL, 0x0000008019537811ULL, 0x040fe200078e18ffULL,
0x0000000819577824ULL, 0x000fe200078e021aULL, 0x0000b00054547810ULL, 0x000fe40007ffe0ffULL,
0x000000021b1b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010571c7824ULL, 0x000fe200078e024dULL,
0x000000076d6d7812ULL, 0x000fe200078e786cULL, 0x000000011a5d7824ULL, 0x000fe200078e0253ULL,
0x0000001b185c7212ULL, 0x000fc600078e3cffULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x000000105d207824ULL, 0x000fe400078e0254ULL, 0x0000000819567824ULL, 0x000fe400078e025cULL,
0x000000015c5c7824ULL, 0x000fe400078e0253ULL, 0x000000002020783bULL, 0x004ea20000004200ULL,
0x0000001056187824ULL, 0x000fe400078e024dULL, 0x000001001c1a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001141cULL, 0x000001001f527824ULL, 0x000fe200078e00ffULL,
0x000088801c837816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001141aULL, 0x000001001d4d7824ULL, 0x000fe200078e00ffULL,
0x000000001818783bULL, 0x000e620000004200ULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000010022617824ULL, 0x004fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x00000018ff457819ULL, 0x000fc40000011420ULL,
0x00000018ff6e7819ULL, 0x000fe4000001141dULL, 0x000088801d897816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011461ULL,
0x0000001c00847306ULL, 0x0005e20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fe40000011421ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff477819ULL, 0x000fc40000011422ULL,
0x00000018ff4a7819ULL, 0x000fe20000011423ULL, 0x0000005200867306ULL, 0x000be20000200c00ULL,
0x000001001e1c7824ULL, 0x004fe200078e00ffULL, 0x0000888021557816ULL, 0x000fe400000000ffULL,
0x00008880225f7816ULL, 0x050fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d00877306ULL, 0x0005e20000200c00ULL,
0x0000888020527816ULL, 0x020fc400000000ffULL, 0x0000888023617816ULL, 0x000fe400000000ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000001c00857306ULL, 0x0009e20000200c00ULL, 0x00000100211d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001141eULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe2000001141fULL, 0x000001001a6f7824ULL, 0x002fe200078e00ffULL,
0x000088801e827816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x00000100201c7824ULL, 0x050fe200078e00ffULL,
0x0000005500537306ULL, 0x000fe20000200c00ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x000088801f517816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100557306ULL, 0x000fe20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff727819ULL, 0x000fe40000011418ULL, 0x00008880187c7816ULL, 0x000fe400000000ffULL,
0x00008880197b7816ULL, 0x000fe200000000ffULL, 0x0000002000607306ULL, 0x0003e20000200c00ULL,
0x00000018ff707819ULL, 0x000fc40000011419ULL, 0x00000018ff6b7819ULL, 0x000fe4000001141aULL,
0x000088801a737816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe2000001146fULL, 0x0000002200667306ULL, 0x000fe20000200c00ULL,
0x0000010023207824ULL, 0x042fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001141bULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x000088801b6f7816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000004d008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fce000001141aULL,
0x0000002000647306ULL, 0x0003f00000200c00ULL, 0x0000002300677306ULL, 0x0005e20000200c00ULL,
0x0000010018207824ULL, 0x042fe400078e00ffULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011420ULL, 0x0000010019207824ULL, 0x040fe200078e00ffULL,
0x00000051004d7306ULL, 0x0003220000200c00ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0001000019197824ULL, 0x000fe400078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011420ULL,
0x009000001620783bULL, 0x004ea20000000200ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001e007f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x002fe2000001141cULL,
0x000000105c1c7824ULL, 0x000fe200078e0254ULL, 0x00000018ff547819ULL, 0x000fca000001141dULL,
0x0000001f00807306ULL, 0x0003e20000200c00ULL, 0x000054104d4d7816ULL, 0x010fce0000000086ULL,
0x0000001800777306ULL, 0x0009e20000200c00ULL, 0x000000001c1c783bULL, 0x002e6e0000004200ULL,
0x0000008200827306ULL, 0x000f620000200c00ULL, 0x000000ffff187224ULL, 0x010fe400078e0017ULL,
0x000001001b177824ULL, 0x000fc400078e00ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000000ff1800720cULL, 0x000fe40003f05270ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fce000001141bULL,
0x0000007900797306ULL, 0x000fe40000200c00ULL, 0x0000004f20208232ULL, 0x084fe40000000000ULL,
0x0000004f22228232ULL, 0x000fe40000000000ULL, 0x0000005021218232ULL, 0x080fe40000000000ULL,
0x0000001700767306ULL, 0x0005e20000200c00ULL, 0x0000005023238232ULL, 0x000fce0000000000ULL,
0x0000008800887306ULL, 0x000f220000200c00ULL, 0x000000086c177824ULL, 0x004fe200078e026dULL,
0x00000018ff657819ULL, 0x002fe4000001141cULL, 0x000088801c6c7816ULL, 0x000fe200000000ffULL,
0x0000001017177824ULL, 0x000fe200078e024cULL, 0x00005410824c7816ULL, 0x020fe40000000085ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x00000018ff697819ULL, 0x000fe4000001141dULL,
0x00000018ff637819ULL, 0x000fc4000001141eULL, 0x0000004c2030723cULL, 0x000fe20000001830ULL,
0x00000018ff687819ULL, 0x000fe4000001141fULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541083187816ULL, 0x010fc60000000088ULL, 0x000054107f4c7816ULL, 0x000fe4000000007aULL,
0x00005410804d7816ULL, 0x000fe40000000079ULL, 0x0000007d007d7306ULL, 0x000e6a0000200c00ULL,
0x0000004c2034723cULL, 0x000fe60000001834ULL, 0x0000007b007b7306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x000054107c4c7816ULL, 0x002fce000000007dULL,
0x0000008100817306ULL, 0x000e700000200c00ULL, 0x0000006e006e7306ULL, 0x000f220000200c00ULL,
0x000054107b4d7816ULL, 0x004fce000000007eULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000004c2038723cULL, 0x000fee0000001838ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000100001d4c7824ULL, 0x000fce00078e00ffULL, 0x0000001900757306ULL, 0x0005700000200c00ULL,
0x0000001a00787306ULL, 0x0007e20000200c00ULL, 0x0000541089197816ULL, 0x004fce000000008aULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000001001c1a7824ULL, 0x048fe200078e00ffULL,
0x000000182028723cULL, 0x000fe20000001828ULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001141aULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000541084187816ULL, 0x002fe20000000081ULL,
0x000001001d817824ULL, 0x000fe200078e00ffULL, 0x0000541087197816ULL, 0x010fe4000000006eULL,
0x000088801d6e7816ULL, 0x000fe200000000ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00005410751d7816ULL, 0x020fc40000000070ULL, 0x00000018ff707819ULL, 0x000fe2000001144cULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x00000018ff797819ULL, 0x000fc60000011481ULL,
0x0000007400747306ULL, 0x000e700000200c00ULL, 0x0000006f006f7306ULL, 0x000eb00000200c00ULL,
0x0000001b00717306ULL, 0x0007220000200c00ULL, 0x00005410734c7816ULL, 0x002fce0000000074ULL,
0x0000001c007a7306ULL, 0x0003e20000200c00ULL, 0x009000001718783bULL, 0x008ee20000000200ULL,
0x000054106f4d7816ULL, 0x004fe40000000076ULL, 0x000088801e6f7816ULL, 0x000fc800000000ffULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x00005410771c7816ULL, 0x002fe20000000072ULL,
0x0000004c2040723cULL, 0x040fec0000001840ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000001001e4d7824ULL, 0x040fe200078e00ffULL, 0x0000001c203c723cULL, 0x000fe2000000183cULL,
0x000100001e1e7824ULL, 0x000fc400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e006fULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410781c7816ULL, 0x000fe4000000006bULL,
0x00005410711d7816ULL, 0x010fe4000000006aULL, 0x0000541053537816ULL, 0x004fe40000000054ULL,
0x0000541060547816ULL, 0x002fe20000000045ULL, 0x0000006d006d7306ULL, 0x000e640000200c00ULL,
0x0000001c2024723cULL, 0x000fec0000001824ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000088801f1c7816ULL, 0x040fe200000000ffULL, 0x000001001f1d7824ULL, 0x040fe200078e00ffULL,
0x0000004f18188232ULL, 0x088fe20000000000ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000004f1a1a8232ULL, 0x000fc40000000000ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000004d004d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000005019198232ULL, 0x080fe20000000000ULL, 0x000054106c6c7816ULL, 0x002fe2000000006dULL,
0x000000501b1b8232ULL, 0x000fc80000000000ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x000054104c4c7816ULL, 0x004fce000000004dULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x0000541055557816ULL, 0x002fce000000004eULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x008fe20000000047ULL,
0x00000054182c723cULL, 0x000fec000000182cULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x0000541067677816ULL, 0x004fce000000004aULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000000661834723cULL, 0x000fee0000001834ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x0000541052527816ULL, 0x002fce0000000051ULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x000000521828723cULL, 0x000fee0000001828ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x000054105f607816ULL, 0x004fce0000000062ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541061617816ULL, 0x002fce0000000064ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000054107a7a7816ULL, 0x008fe20000000065ULL, 0x000000601830723cULL, 0x000fec0000001830ULL,
0x0000006800687306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000ff00000200c00ULL,
0x0000007900797306ULL, 0x000e700000200c00ULL, 0x0000007000707306ULL, 0x000eb00000200c00ULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x000054106e6d7816ULL, 0x002fce0000000079ULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x00005410707b7816ULL, 0x004fe20000000069ULL,
0x0000006c1838723cULL, 0x040fec0000001838ULL, 0x0000001e001e7306ULL, 0x000ea40000200c00ULL,
0x0000007a183c723cULL, 0x000fec000000183cULL, 0x0000001f001f7306ULL, 0x000ee20000200c00ULL,
0x000054101c4d7816ULL, 0x002fc4000000001dULL, 0x000054101e1e7816ULL, 0x004fca0000000063ULL,
0x0000004c1840723cULL, 0x000fe20000001840ULL, 0x000054101f1f7816ULL, 0x008fce0000000068ULL,
0x0000001e1824723cULL, 0x000fe20000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020000c187f8cULL, 0x0002a2000c80043fULL, 0xfffffff85e5e7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000400f1b7810ULL, 0x000fe20007ffe0ffULL,
0x00f688005eff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff637224ULL, 0x000fe200078e0049ULL,
0x000000014b4b7812ULL, 0x000fe400078e0cffULL, 0x000000021b00720cULL, 0x000fda0003f06070ULL,
0x000057f000000947ULL, 0x000fea0003800000ULL, 0x000004000d067984ULL, 0x008ee40000000800ULL,
0x8000000006ff7812ULL, 0x00cfe40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024000c067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600187305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000180000735dULL, 0x008fe40003800000ULL,
0x000024000c187984ULL, 0x000ea40000000800ULL, 0x8000000018ff7812ULL, 0x004fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000400187811ULL, 0x040fe200078fe8ffULL,
0x00000080ff457424ULL, 0x000fe200078e00ffULL, 0x0000000500197211ULL, 0x000fe200078fe8ffULL,
0x000000080e557824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe20000011644ULL,
0x00000001051b7824ULL, 0x000fe200078e0218ULL, 0x00000000191a7212ULL, 0x0c0fe200078e3cffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x00000001461c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002006197824ULL, 0x000fe200078e020fULL, 0x000000001b187212ULL, 0x040fe200078e3cffULL,
0x000000081b537824ULL, 0x000fe200078e00ffULL, 0x000000031c00720cULL, 0x000fe20003f06070ULL,
0x000010000e647824ULL, 0x000fe200078e00ffULL, 0x00000080191b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff853537812ULL, 0x000fe400078ee218ULL, 0x0000000800187811ULL, 0x000fe200078fe8ffULL,
0x00006200041e7a24ULL, 0x100fe200078e021bULL, 0xfffffff81d547812ULL, 0x000fe400078ee21aULL,
0x0000001b021c7217ULL, 0x000fe20007800000ULL, 0x0000000105197824ULL, 0x000fe200078e0218ULL,
0x00000003ff217819ULL, 0x000fe40000011600ULL, 0x0000000c001a7811ULL, 0x000fe200078fe8ffULL,
0x000000011c187824ULL, 0x000fe200078e0a1bULL, 0x0000000421237810ULL, 0x000fe20007ffe0ffULL,
0x0000000819527824ULL, 0x040fe200078e00ffULL, 0x00000000191d7212ULL, 0x000fe200078e3cffULL,
0x00000001051b7824ULL, 0x000fe200078e021aULL, 0x000000211e1a7210ULL, 0x000fc40007ffe005ULL,
0x000000231e1f7210ULL, 0x100fe20007ffe005ULL, 0x000000081b517824ULL, 0x040fe200078e00ffULL,
0x0000002018207807ULL, 0x000fe20000000000ULL, 0x00005e001a187625ULL, 0x080fe200078e0045ULL,
0x000000001b1c7212ULL, 0x000fe400078e3cffULL, 0x0000002005207217ULL, 0x000fe20007800000ULL,
0x00005e001f1a7625ULL, 0x000fe200078e0045ULL, 0x0000f6a8064c7811ULL, 0x000fe400078e20ffULL,
0x00000008554f7812ULL, 0x000fe200078ec0ffULL, 0x0000000120207824ULL, 0x000fe200078e0a05ULL,
0x000000111a1a7210ULL, 0x000fc40007f5e0ffULL, 0xfffffff852527812ULL, 0x000fe200078ee21dULL,
0x000000014c507824ULL, 0x000fe200078e024fULL, 0x00001000641d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000202300720cULL, 0x000fe20003f46070ULL,
0x00000000500473c2ULL, 0x000ea200000e0000ULL, 0x00000008211f7810ULL, 0x040fe20007ffe0ffULL,
0x00002000061d7824ULL, 0x000fe200078e021dULL, 0x0000001118187210ULL, 0x000fe40007f1e0ffULL,
0x0000000c21237810ULL, 0x000fc40007ffe0ffULL, 0xfffffff851517812ULL, 0x000fe200078ee21cULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x0000001f1e1c7210ULL, 0x140fe40007ffe005ULL,
0x000000231e1e7210ULL, 0x000fe40007ffe005ULL, 0x000000202100720cULL, 0x080fe40003f06070ULL,
0x0000b0001d217810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0045ULL,
0x000000201f00720cULL, 0x000fc40003f66070ULL, 0x000000202300720cULL, 0x000fe20003f86070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0045ULL, 0x000000111c1c7210ULL, 0x080fe40007fbe0ffULL,
0x000000084f4f7812ULL, 0x000fe200078e3cffULL, 0x0000001054547824ULL, 0x100fe200078e0221ULL,
0x000000111e1e7210ULL, 0x000fe20007fde0ffULL, 0x0000001053537824ULL, 0x100fe400078e0221ULL,
0x0000001052527824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018547faeULL, 0x0007e2000c101c46ULL, 0x000000ffff1d7224ULL, 0x000fc400028e061dULL,
0x0000001051517824ULL, 0x000fe200078e0221ULL, 0x000000001a537faeULL, 0x0007e2000d101c46ULL,
0x000000ffff1f7224ULL, 0x000fe400030e061fULL, 0x000000014c4f7824ULL, 0x000fe200078e024fULL,
0x000000001c527faeULL, 0x0007e8000d901c46ULL, 0x000000001e517faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000050627f8cULL, 0x000528000c80043fULL, 0x000004004f1b7984ULL, 0x0084e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280010187f8cULL, 0x000fe2000c80043fULL, 0x800000001bff7812ULL, 0x008fc60007844849ULL,
0x00f62c00101d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x008fe40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe0071b7812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff1a7424ULL, 0x000fe200078e00ffULL, 0x00000010071c7812ULL, 0x040fe400078ec0ffULL,
0x00000008071d7812ULL, 0x000fc800078ec0ffULL, 0x0000001b1d1b7210ULL, 0x000fe40007ffe01cULL,
0x0000001a001c7305ULL, 0x000764000021f000ULL, 0x3fa000001a1a7823ULL, 0x008fe200000100ffULL,
0x0000001c0000735dULL, 0x020fe20003800000ULL, 0x00f62c001b1d7984ULL, 0x000ee40000000800ULL,
0x800000001dff7812ULL, 0x008fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008011187810ULL, 0x000fca0007ffe012ULL, 0x0000000113187824ULL, 0x000fca00078e0218ULL,
0x00f00000181b7984ULL, 0x000ee80000000800ULL, 0x00f20000181c7984ULL, 0x0002a20000000800ULL,
0x0000000a1b00720bULL, 0x008fe20003f1d000ULL, 0x0000d3f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x002fc800000e0100ULL, 0x0000ffff181e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6b7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000144197811ULL, 0x000fe400078ff0ffULL,
0x0000000a1b00720bULL, 0x000fe40003f14000ULL, 0x000000441900720cULL, 0x000fe20003f65270ULL,
0x0000d3c27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000187806ULL, 0x000fe400000e0100ULL,
0x0000001b0a197209ULL, 0x000fe20007810000ULL, 0x000000804420b824ULL, 0x000fe200078e0211ULL,
0x0000ffff181d7812ULL, 0x000fe400078e3cffULL, 0x00000002ff4a7819ULL, 0x000fe20000011600ULL,
0x000000011320b824ULL, 0x000fe200078e0220ULL, 0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL,
0x800000190a1a7221ULL, 0x000fc60000010000ULL, 0x00f400192000b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fc80000410000ULL, 0x0000001a005f7308ULL, 0x000ee40000000800ULL,
0x0000005f0b0b7220ULL, 0x008fe20000410000ULL, 0x0000d3527f007947ULL, 0x000fea000b800000ULL,
0x00001f4a5f237589ULL, 0x0022e400000e0000ULL, 0x0000002328287220ULL, 0x08cfe40000410000ULL,
0x0000002329297220ULL, 0x080fe40000410000ULL, 0x000000232c2c7220ULL, 0x080fe40000410000ULL,
0x000000232d2d7220ULL, 0x080fe40000410000ULL, 0x0000002330307220ULL, 0x000fc40000410000ULL,
0x0000002331317220ULL, 0x080fe40000410000ULL, 0x0000002334347220ULL, 0x080fe40000410000ULL,
0x0000002335357220ULL, 0x080fe40000410000ULL, 0x0000002338387220ULL, 0x080fe40000410000ULL,
0x0000002339397220ULL, 0x080fe40000410000ULL, 0x000000233c3c7220ULL, 0x000fc40000410000ULL,
0x000000233d3d7220ULL, 0x080fe40000410000ULL, 0x0000002340407220ULL, 0x080fe40000410000ULL,
0x0000002341417220ULL, 0x080fe40000410000ULL, 0x0000002324247220ULL, 0x080fe40000410000ULL,
0x0000002325257220ULL, 0x000fe20000410000ULL, 0x0000d2827f007947ULL, 0x000fea000b800000ULL,
0x00001f155f237589ULL, 0x0004e400000e0000ULL, 0x0000001b0a0a7209ULL, 0x000fe20007810000ULL,
0x000000232a2a7220ULL, 0x08cfe20000410000ULL, 0x00000001ff6b7807ULL, 0x000fe20000000000ULL,
0x000000232b2b7220ULL, 0x000fc40000410000ULL, 0x8000000a1b1b0221ULL, 0x000fe40000010000ULL,
0x000000232e2e7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b1b1b0820ULL, 0x000fe40000410000ULL,
0x000000232f2f7220ULL, 0x080fe40000410000ULL, 0x0000001b00140308ULL, 0x000ea20000000800ULL,
0x0000002332327220ULL, 0x080fe40000410000ULL, 0x0000002333337220ULL, 0x000fc40000410000ULL,
0x0000002336367220ULL, 0x080fe40000410000ULL, 0x0000002337377220ULL, 0x080fe40000410000ULL,
0x000000233a3a7220ULL, 0x080fe40000410000ULL, 0x000000233b3b7220ULL, 0x080fe40000410000ULL,
0x000000233e3e7220ULL, 0x080fe40000410000ULL, 0x000000233f3f7220ULL, 0x000fc40000410000ULL,
0x0000002342427220ULL, 0x080fe40000410000ULL, 0x0000002343437220ULL, 0x080fe40000410000ULL,
0x0000002326267220ULL, 0x080fe40000410000ULL, 0x0000002327277220ULL, 0x000fe40000410000ULL,
0x0000001c141c0220ULL, 0x004fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000000b1c0b7221ULL, 0x004fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000080e187824ULL, 0x000fe200078e00ffULL,
0xfffffff007197812ULL, 0x000fc800078ec0ffULL, 0x0000000818187812ULL, 0x000fca00078e0cffULL,
0x00000001181a7824ULL, 0x002fca00078e0219ULL, 0x00f6ac001a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x00f6ac001a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc40007804849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff4a7819ULL, 0x002fe40000011600ULL, 0x00000014ff18723eULL, 0x000fe400000000ffULL,
0x000000184a1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000104a1c7810ULL, 0x000fe40007ffe0ffULL,
0x00005410185f7816ULL, 0x000fe20000000018ULL, 0x0000cfc27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a5f697589ULL, 0x0002a400000e0000ULL, 0x0000d0027f007947ULL, 0x000fea000b800000ULL,
0x00001f155f6a7589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4a7224ULL, 0x002fe200078e001cULL, 0x00003d7000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000db8000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4a7224ULL, 0x002fe200078e001bULL, 0x00003dd000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000db2000007944ULL, 0x01cfea0003c00000ULL, 0x000010000e197824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100044187824ULL, 0x000fc600078e00ffULL,
0x0000100019197812ULL, 0x000fe400078e0cffULL, 0xffffe00018187812ULL, 0x000fe400078ec0ffULL,
0x0000b00008477810ULL, 0x100fe40007ffe019ULL, 0x0000b000184d7810ULL, 0x000fc60007ffe019ULL,
0x000000105d457824ULL, 0x000fe400078e0247ULL, 0x00000010574e7824ULL, 0x100fe400078e024dULL,
0x00000010564d7824ULL, 0x000fe200078e024dULL, 0x000000004518783bULL, 0x002e620000004200ULL,
0x000000105c477824ULL, 0x000fc600078e0247ULL, 0x000000004e20783bULL, 0x004ea80000004200ULL,
0x000000004d48783bULL, 0x000f680000004200ULL, 0x00000000471c783bULL, 0x000ee20000004200ULL,
0x00000018ff607819ULL, 0x002fe40000011418ULL, 0x00000018ff687819ULL, 0x000fc40000011419ULL,
0x00000018ff8e7819ULL, 0x004fe20000011420ULL, 0x00000100206c7824ULL, 0x040fe200078e00ffULL,
0x0000888020767816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011421ULL, 0x00000100216d7824ULL, 0x040fe200078e00ffULL,
0x0000888021927816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x00000018ff7c7819ULL, 0x020fc40000011449ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00008880497e7816ULL, 0x000fe400000000ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000002000917306ULL, 0x0003e20000200c00ULL, 0x00000018ff887819ULL, 0x000fe40000011422ULL,
0x00000018ff7d7819ULL, 0x000fe40000011423ULL, 0x00008880228c7816ULL, 0x000fc400000000ffULL,
0x0000888023787816ULL, 0x000fe200000000ffULL, 0x0000002100907306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe2000001144bULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x000088804b7a7816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000006c00937306ULL, 0x0003e20000200c00ULL,
0x0000010049217824ULL, 0x044fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc40000011448ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020008d7306ULL, 0x0005e20000200c00ULL,
0x00000100236c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x0000888048897816ULL, 0x040fe400000000ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000002100877306ULL, 0x0003e20000200c00ULL,
0x0000010048207824ULL, 0x044fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000004900857306ULL, 0x000fe20000200c00ULL,
0x000001004b217824ULL, 0x042fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe2000001144aULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x000088804a827816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000867306ULL, 0x0003e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff627819ULL, 0x010fe4000001141aULL, 0x00000018ff677819ULL, 0x000fe2000001141bULL,
0x00000022008b7306ULL, 0x000fe20000200c00ULL, 0x000001004a207824ULL, 0x042fe200078e00ffULL,
0x00000018ff617819ULL, 0x008fe2000001141cULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001141dULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x00000023008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff5f7819ULL, 0x000fe4000001141eULL, 0x00000018ff657819ULL, 0x000fc6000001141fULL,
0x0000002000817306ULL, 0x0003f00000200c00ULL, 0x00000021007f7306ULL, 0x0005e20000200c00ULL,
0x0000010018207824ULL, 0x002fca00078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011420ULL,
0x0000010019207824ULL, 0x000fe200078e00ffULL, 0x0000006c008f7306ULL, 0x0003e80000200c00ULL,
0x00000018ff737819ULL, 0x000fe40000011420ULL, 0x009800001620783bULL, 0x004ea40000000200ULL,
0x0000004b007b7306ULL, 0x0007e20000200c00ULL, 0x00008880186c7816ULL, 0x042fe200000000ffULL,
0x0001000018187824ULL, 0x000fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x000099106b4b7816ULL, 0x008fe400000000ffULL,
0x000088801b6b7816ULL, 0x000fe400000000ffULL, 0x000000ff4b00720cULL, 0x000fc60003f05270ULL,
0x0000006d00957306ULL, 0x0002f00000200c00ULL, 0x0000004800847306ULL, 0x0009e20000200c00ULL,
0x000088801a6d7816ULL, 0x002fce00000000ffULL, 0x00000018006f7306ULL, 0x0003e20000200c00ULL,
0x0000888019487816ULL, 0x050fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x0000006920208232ULL, 0x004fc80000000000ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000001001b187824ULL, 0x042fe200078e00ffULL,
0x0000006922228232ULL, 0x000fe20000000000ULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000006a21218232ULL, 0x080fe40000000000ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000006a23238232ULL, 0x000fe20000000000ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00000018ff1b7819ULL, 0x000fce000001141bULL, 0x0000004a00807306ULL, 0x0003f00000200c00ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x000001001a4a7824ULL, 0x042fe400078e00ffULL,
0x000100001a1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000018ff1a7819ULL, 0x000fce000001141aULL,
0x0000001900717306ULL, 0x0007f00000200c00ULL, 0x0000001800707306ULL, 0x0005e20000200c00ULL,
0x0000541092197816ULL, 0x008fe40000000095ULL, 0x00005410784b7816ULL, 0x002fca000000008fULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x0000541076187816ULL, 0x004fce0000000093ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x000000182028723cULL, 0x000fee0000001828ULL,
0x0000004a006e7306ULL, 0x0007e20000200c00ULL, 0x0000541091187816ULL, 0x000fe4000000008eULL,
0x0000541090197816ULL, 0x000fc40000000079ULL, 0x000088801d8e7816ULL, 0x000fc600000000ffULL,
0x0000001a00757306ULL, 0x0009e20000200c00ULL, 0x000088801c4a7816ULL, 0x008fe200000000ffULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x000000ffff787224ULL, 0x000fc600078e008eULL,
0x000000ffff767224ULL, 0x000fe200078e004aULL, 0x000054108c4a7816ULL, 0x000fe2000000008dULL,
0x0000008900897306ULL, 0x000ee20000200c00ULL, 0x000001001c1a7824ULL, 0x050fe400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x000001001d8c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe2000001141aULL, 0x0000004a2030723cULL, 0x000fe20000001830ULL,
0x0000007e007e7306ULL, 0x000f220000200c00ULL, 0x00000018ff1c7819ULL, 0x000fca000001141cULL,
0x000054108b4a7816ULL, 0x002fe40000000088ULL, 0x0000001b00747306ULL, 0x0003e20000200c00ULL,
0x000054108a4b7816ULL, 0x004fe4000000007dULL, 0x00000018ff7d7819ULL, 0x000fca000001148cULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x009800001718783bULL, 0x002e620000000200ULL,
0x0000004a2034723cULL, 0x000fec0000001834ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00005410894a7816ULL, 0x008fe40000000086ULL, 0x000054107e4b7816ULL, 0x010fca0000000087ULL,
0x0000007a007a7306ULL, 0x000ee40000200c00ULL, 0x0000004a2038723cULL, 0x000fec0000001838ULL,
0x0000007700777306ULL, 0x000f220000200c00ULL, 0x000100001d4a7824ULL, 0x000fe200078e00ffULL,
0x00005410851d7816ULL, 0x004fcc000000007cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000054107a4b7816ULL, 0x008fe4000000007fULL, 0x000088801e7a7816ULL, 0x000fca00000000ffULL,
0x0000001c007e7306ULL, 0x0005e20000200c00ULL, 0x0000006918188232ULL, 0x082fe40000000000ULL,
0x000000691a1a8232ULL, 0x000fe40000000000ULL, 0x0000006a19198232ULL, 0x080fe40000000000ULL,
0x0000006a1b1b8232ULL, 0x000fe20000000000ULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x00005410841c7816ULL, 0x004fce0000000083ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000001c203c723cULL, 0x000fee000000183cULL, 0x0000004900497306ULL, 0x000ea20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001144aULL, 0x00005410801c7816ULL, 0x010fc40000000077ULL,
0x00005410824a7816ULL, 0x002fc60000000081ULL, 0x0000004800487306ULL, 0x000fe80000200c00ULL,
0x0000004a2040723cULL, 0x000fe80000001840ULL, 0x0000007300737306ULL, 0x000e660000200c00ULL,
0x000001001e4b7824ULL, 0x000fc400078e00ffULL, 0x000100001e1e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e007aULL, 0x0000001d007f7306ULL, 0x0007e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054107b1d7816ULL, 0x008fce0000000072ULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x0000001c2024723cULL, 0x000fee0000001824ULL,
0x000054106c1c7816ULL, 0x004fe20000000049ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x00005410481d7816ULL, 0x002fc40000000073ULL, 0x000088801f207816ULL, 0x000fca00000000ffULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x0000001c1828723cULL, 0x000fee0000001828ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410711d7816ULL, 0x008fe20000000068ULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c00217306ULL, 0x0007f00000200c00ULL,
0x0000004b004b7306ULL, 0x000f220000200c00ULL, 0x000054106f1c7816ULL, 0x008fce0000000060ULL,
0x0000001c182c723cULL, 0x000fe2000000182cULL, 0x0000006100617306ULL, 0x000eec0000200c00ULL,
0x00005410751c7816ULL, 0x004fe40000000062ULL, 0x00005410741d7816ULL, 0x002fe20000000067ULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x000054104a4a7816ULL, 0x010fca000000004bULL,
0x0000001c1834723cULL, 0x000fe20000001834ULL, 0x000054107e7e7816ULL, 0x008fe20000000061ULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x000054107f7f7816ULL, 0x002fce0000000066ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000007e183c723cULL, 0x000fee000000183cULL, 0x0000006b006b7306ULL, 0x000eb00000200c00ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x000054106d6a7816ULL, 0x002fce000000006eULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054106b6b7816ULL, 0x004fce0000000070ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000006a1830723cULL, 0x000fee0000001830ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000079ULL,
0x0000002000207306ULL, 0x000e700000200c00ULL, 0x0000001e001e7306ULL, 0x000ee20000200c00ULL,
0x0000541078777816ULL, 0x004fce000000007dULL, 0x0000001f001c7306ULL, 0x000ea20000200c00ULL,
0x00005410214b7816ULL, 0x002fe20000000020ULL, 0x000000761838723cULL, 0x000fe20000001838ULL,
0x000054101e1e7816ULL, 0x008fce000000005fULL, 0x0000004a1840723cULL, 0x000fe20000001840ULL,
0x000054101c1f7816ULL, 0x004fce0000000065ULL, 0x0000001e1824723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020000c187f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000800f1b7810ULL, 0x000fe20007ffe0ffULL, 0x00f690005eff7f8cULL, 0x0007e2000c80043fULL,
0x000000010e4b7812ULL, 0x000fe400078ec0ffULL, 0x000000021b00720cULL, 0x000fda0003f06070ULL,
0x000038d000000947ULL, 0x000fea0003800000ULL, 0x000004000d067984ULL, 0x008ee40000000800ULL,
0x8000000006ff7812ULL, 0x00cfe40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024000c067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600187305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000180000735dULL, 0x008fe40003800000ULL,
0x000024000c187984ULL, 0x000ea40000000800ULL, 0x8000000018ff7812ULL, 0x004fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff067819ULL, 0x000fe20000011644ULL,
0x00000080ff227424ULL, 0x000fe200078e00ffULL, 0x00000003ff1f7819ULL, 0x000fe20000011600ULL,
0x000000004f0473c2ULL, 0x000ea200000e0000ULL, 0x00000001461a7810ULL, 0x000fe20007ffe0ffULL,
0x0000002006197824ULL, 0x000fe200078e020fULL, 0x000000041f237810ULL, 0x000fe40007ffe0ffULL,
0x000000031a00720cULL, 0x000fe40003f06070ULL, 0x000000c019197810ULL, 0x000fc40007ffe0ffULL,
0x000000081f497810ULL, 0x040fe40007ffe0ffULL, 0x0000001902187217ULL, 0x000fe20007800000ULL,
0x00006200041c7a24ULL, 0x000fe200078e0219ULL, 0x0000000c1f217810ULL, 0x000fc60007ffe0ffULL,
0x00000001181a7824ULL, 0x000fe200078e0a19ULL, 0x0000001f1c1b7210ULL, 0x140fe40007ffe005ULL,
0x000000491c1d7210ULL, 0x100fe40007ffe005ULL, 0x000000201a1a7807ULL, 0x000fe20000000000ULL,
0x00005e001b187625ULL, 0x000fe200078e0022ULL, 0x000000231c1b7210ULL, 0x000fe40007ffe005ULL,
0x0000001a051e7217ULL, 0x000fe40007800000ULL, 0x0000001118187210ULL, 0x000fe20007f1e0ffULL,
0x00005e001b1a7625ULL, 0x000fc800078e0022ULL, 0x000000011e207824ULL, 0x100fe200078e0a05ULL,
0x000000211c1e7210ULL, 0x000fe20007ffe005ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x000000111a1a7210ULL, 0x080fe20007f7e0ffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0022ULL,
0x000000201f00720cULL, 0x080fe40003f46070ULL, 0x000000202300720cULL, 0x000fe20003f06070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0022ULL, 0x000000202100720cULL, 0x080fe40003f86070ULL,
0x000000111c1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x000000204900720cULL, 0x000fc40003f66070ULL, 0x000000111e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1d7224ULL, 0x000fe400028e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000185b7faeULL, 0x0007e4000d101c46ULL, 0x000000ffff1f7224ULL, 0x000fe400030e061fULL,
0x000000001a5a7faeULL, 0x0007e8000c101c46ULL, 0x000000001c597faeULL, 0x0007e8000d901c46ULL,
0x000000001e587faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000004f747f8cULL, 0x000528000c80043fULL,
0x00000400501a7984ULL, 0x0084e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480010187f8cULL, 0x000fe2000c80043fULL,
0x800000001aff7812ULL, 0x008fc60007844863ULL, 0x00f64c00101b7984ULL, 0x000ee40000000800ULL,
0x800000001bff7812ULL, 0x008fe40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff1a7424ULL, 0x000fc800078e00ffULL, 0x0000001a001b7305ULL, 0x000764000021f000ULL,
0x3fa000001a1a7823ULL, 0x008fe200000100ffULL, 0x0000001b0000735dULL, 0x020fe40003800000ULL,
0x00f64c00101b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x008fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010011187810ULL, 0x000fca0007ffe012ULL,
0x0000000113187824ULL, 0x000fca00078e0218ULL, 0x00f00000181b7984ULL, 0x000ee80000000800ULL,
0x00f20000181c7984ULL, 0x0002a20000000800ULL, 0x0000000a1b00720bULL, 0x008fe20003f1d000ULL,
0x0000b9627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x002fc800000e0100ULL,
0x0000ffff181e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff777424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000244197811ULL, 0x000fe400078ff0ffULL, 0x0000000a1b00720bULL, 0x000fe40003f14000ULL,
0x000000441900720cULL, 0x000fe20003f65270ULL, 0x0000b9327f007947ULL, 0x000ff4000b800000ULL,
0x0000000000187806ULL, 0x000fe400000e0100ULL, 0x0000001b0a197209ULL, 0x000fe20007810000ULL,
0x000000804420b824ULL, 0x000fe200078e0211ULL, 0x0000ffff181d7812ULL, 0x000fe400078e3cffULL,
0x00000002ff4a7819ULL, 0x000fe20000011600ULL, 0x000000011320b824ULL, 0x000fe200078e0220ULL,
0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL, 0x800000190a1a7221ULL, 0x000fc60000010000ULL,
0x00f400192000b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1a1a7820ULL, 0x000fc80000410000ULL,
0x0000001a005f7308ULL, 0x000ee40000000800ULL, 0x0000005f0b0b7220ULL, 0x008fe20000410000ULL,
0x0000b8c27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a5f237589ULL, 0x0022e400000e0000ULL,
0x0000002328287220ULL, 0x08cfe40000410000ULL, 0x0000002329297220ULL, 0x080fe40000410000ULL,
0x000000232c2c7220ULL, 0x080fe40000410000ULL, 0x000000232d2d7220ULL, 0x080fe40000410000ULL,
0x0000002330307220ULL, 0x000fc40000410000ULL, 0x0000002331317220ULL, 0x080fe40000410000ULL,
0x0000002334347220ULL, 0x080fe40000410000ULL, 0x0000002335357220ULL, 0x080fe40000410000ULL,
0x0000002338387220ULL, 0x080fe40000410000ULL, 0x0000002339397220ULL, 0x080fe40000410000ULL,
0x000000233c3c7220ULL, 0x000fc40000410000ULL, 0x000000233d3d7220ULL, 0x080fe40000410000ULL,
0x0000002340407220ULL, 0x080fe40000410000ULL, 0x0000002341417220ULL, 0x080fe40000410000ULL,
0x0000002324247220ULL, 0x080fe40000410000ULL, 0x0000002325257220ULL, 0x000fe20000410000ULL,
0x0000b7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f155f237589ULL, 0x0004e400000e0000ULL,
0x0000001b0a0a7209ULL, 0x000fe20007810000ULL, 0x000000232a2a7220ULL, 0x08cfe20000410000ULL,
0x00000001ff777807ULL, 0x000fe20000000000ULL, 0x000000232b2b7220ULL, 0x000fc40000410000ULL,
0x8000000a1b1b0221ULL, 0x000fe40000010000ULL, 0x000000232e2e7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b1b1b0820ULL, 0x000fe40000410000ULL, 0x000000232f2f7220ULL, 0x080fe40000410000ULL,
0x0000001b00140308ULL, 0x000ea20000000800ULL, 0x0000002332327220ULL, 0x080fe40000410000ULL,
0x0000002333337220ULL, 0x000fc40000410000ULL, 0x0000002336367220ULL, 0x080fe40000410000ULL,
0x0000002337377220ULL, 0x080fe40000410000ULL, 0x000000233a3a7220ULL, 0x080fe40000410000ULL,
0x000000233b3b7220ULL, 0x080fe40000410000ULL, 0x000000233e3e7220ULL, 0x080fe40000410000ULL,
0x000000233f3f7220ULL, 0x000fc40000410000ULL, 0x0000002342427220ULL, 0x080fe40000410000ULL,
0x0000002343437220ULL, 0x080fe40000410000ULL, 0x0000002326267220ULL, 0x080fe40000410000ULL,
0x0000002327277220ULL, 0x000fe40000410000ULL, 0x0000001c141c0220ULL, 0x004fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000000b1c0b7221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000855197812ULL, 0x000fe400078ec0ffULL, 0xfffffff007187812ULL, 0x000fca00078ec0ffULL,
0x0000000118197824ULL, 0x000fca00078e0219ULL, 0x00f6ac0019187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fe40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x00000018001a7305ULL, 0x0022a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x0000001a0000735dULL, 0x004fe40003800000ULL, 0x00f6ac00191a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fc40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff4a7819ULL, 0x002fe40000011600ULL, 0x00000014ff18723eULL, 0x000fe400000000ffULL,
0x000000184a1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000104a1c7810ULL, 0x000fe40007ffe0ffULL,
0x00005410185f7816ULL, 0x000fe20000000018ULL, 0x0000b5427f007947ULL, 0x000fea000b800000ULL,
0x00001f4a5f5b7589ULL, 0x0002a400000e0000ULL, 0x0000b5827f007947ULL, 0x000fea000b800000ULL,
0x00001f155f587589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4a7224ULL, 0x002fe200078e001cULL, 0x00005a3000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000bec000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4a7224ULL, 0x002fe200078e001bULL, 0x00005a9000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000be6000007944ULL, 0x01cfea0003c00000ULL, 0x0000100064217812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100044207824ULL, 0x000fe200078e00ffULL,
0x0000991077777816ULL, 0x000fe400000000ffULL, 0x0000b000081c7810ULL, 0x000fe40007ffe021ULL,
0xffffe00020207812ULL, 0x000fc400078ec0ffULL, 0x000000ff7700720cULL, 0x000fe20003f05270ULL,
0x000000105d187824ULL, 0x100fe200078e021cULL, 0x0000b00020487810ULL, 0x000fe20007ffe021ULL,
0x000000105c1c7824ULL, 0x000fc800078e021cULL, 0x000000001818783bULL, 0x002e620000004200ULL,
0x0000001057207824ULL, 0x100fe400078e0248ULL, 0x0000001056487824ULL, 0x000fe200078e0248ULL,
0x000000001c1c783bULL, 0x000fe80000004200ULL, 0x000000002020783bULL, 0x004ea80000004200ULL,
0x000000004848783bULL, 0x000f620000004200ULL, 0x00000018ff577819ULL, 0x002fe20000011418ULL,
0x00000100185c7824ULL, 0x040fe200078e00ffULL, 0x00008880185f7816ULL, 0x048fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011419ULL,
0x0000010019647824ULL, 0x040fe200078e00ffULL, 0x0000888019617816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001001a657824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001141bULL,
0x0001000023787824ULL, 0x004fe200078e00ffULL, 0x0000001800687306ULL, 0x0003e20000200c00ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x00000100487a7824ULL, 0x020fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011465ULL, 0x00000100497d7824ULL, 0x000fe200078e00ffULL,
0x000088801b657816ULL, 0x000fc400000000ffULL, 0x00000018ff827819ULL, 0x000fe20000011420ULL,
0x0000001900677306ULL, 0x0005e20000200c00ULL, 0x000001001b187824ULL, 0x042fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001141aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088801a667816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x000001001c197824ULL, 0x004fe200078e00ffULL, 0x00000018006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x00000018ff837819ULL, 0x000fe40000011421ULL,
0x00000018ff707819ULL, 0x000fe20000011419ULL, 0x0000010020197824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011422ULL, 0x0000001b006e7306ULL, 0x0005e20000200c00ULL,
0x000001001d187824ULL, 0x002fe200078e00ffULL, 0x0000888021797816ULL, 0x000fe400000000ffULL,
0x0000888022847816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x000fc40000011418ULL,
0x0000888020187816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000001a006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe40000011423ULL,
0x0000888023857816ULL, 0x000fe400000000ffULL, 0x00000018ff1b7819ULL, 0x004fe20000011420ULL,
0x0000010022207824ULL, 0x040fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00000100211a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011420ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011422ULL,
0x0000010023207824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fc4000001141aULL,
0x00000018ff1a7819ULL, 0x000fe20000011421ULL, 0x0000001900197306ULL, 0x000e620000200c00ULL,
0x00000018ff887819ULL, 0x000fe40000011420ULL, 0x00a000001620783bULL, 0x000ea20000000200ULL,
0x00000018ff767819ULL, 0x000fe40000011448ULL, 0x00008880487f7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fe200078e00ffULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00000018ff817819ULL, 0x000fc4000001147dULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff737819ULL, 0x000fe20000011449ULL,
0x0000008a008a7306ULL, 0x000ee20000200c00ULL, 0x0000541018187816ULL, 0x002fe40000000019ULL,
0x00008880497e7816ULL, 0x040fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc4000001147aULL, 0x00000018ff717819ULL, 0x000fe2000001144aULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff6f7819ULL, 0x000fe4000001144bULL, 0x000088804a777816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001141cULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000541079197816ULL, 0x008fc4000000008aULL, 0x000088801c6b7816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe4000001141dULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001b001b7306ULL, 0x000e620000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000005b20208232ULL, 0x084fe20000000000ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000005b22228232ULL, 0x000fe20000000000ULL,
0x000088801d6d7816ULL, 0x000fe200000000ffULL, 0x0000005821218232ULL, 0x000fc40000000000ULL,
0x0000001a001a7306ULL, 0x000ea20000200c00ULL, 0x0000005823238232ULL, 0x000fe20000000000ULL,
0x00000018ff567819ULL, 0x000fe4000001141eULL, 0x00000018ff607819ULL, 0x000fc8000001141fULL,
0x00000048007d7306ULL, 0x0007e20000200c00ULL, 0x000000182028723cULL, 0x000fee0000001828ULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000088804b487816ULL, 0x008fe400000000ffULL,
0x000054101b187816ULL, 0x002fc40000000082ULL, 0x000054101a197816ULL, 0x004fe20000000083ULL,
0x000000ffff797224ULL, 0x000fe400078e0048ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000001004b487824ULL, 0x040fe400078e00ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018202c723cULL, 0x000fe2000000182cULL, 0x00a000001718783bULL, 0x000e620000000200ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fce000001144bULL, 0x0000008800887306ULL, 0x000eb00000200c00ULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000007b007b7306ULL, 0x000ff00000200c00ULL,
0x0000008900897306ULL, 0x000ee20000200c00ULL, 0x0000005b18188232ULL, 0x002fc40000000000ULL,
0x0000005b1a1a8232ULL, 0x000fca0000000000ULL, 0x0000007800867306ULL, 0x0003620000200c00ULL,
0x0000005819198232ULL, 0x080fe40000000000ULL, 0x000000581b1b8232ULL, 0x000fca0000000000ULL,
0x0000007a00807306ULL, 0x000fe20000200c00ULL, 0x000001004a787824ULL, 0x042fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000049007a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fce000001144aULL,
0x0000004800827306ULL, 0x0003e20000200c00ULL, 0x0000541085497816ULL, 0x004fce0000000088ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0000541084487816ULL, 0x002fce0000000087ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x000000482030723cULL, 0x000fee0000001830ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x0000541089487816ULL, 0x008fe4000000007cULL,
0x0000541086497816ULL, 0x020fca000000007bULL, 0x0000007600767306ULL, 0x000fe40000200c00ULL,
0x000000482034723cULL, 0x000fec0000001834ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x000054107f487816ULL, 0x004fe40000000080ULL, 0x000054107e497816ULL, 0x002fca0000000081ULL,
0x0000007100717306ULL, 0x000fe40000200c00ULL, 0x000000482038723cULL, 0x000fec0000001838ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000100001d487824ULL, 0x000fe200078e00ffULL,
0x000054107a1d7816ULL, 0x008fc40000000073ULL, 0x000088801e737816ULL, 0x000fc800000000ffULL,
0x0000004a00847306ULL, 0x000e700000200c00ULL, 0x0000004b007c7306ULL, 0x000ff00000200c00ULL,
0x0000001c004a7306ULL, 0x0005f00000200c00ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000054107d1c7816ULL, 0x004fce0000000076ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000001c203c723cULL, 0x000fee000000183cULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe40000011448ULL, 0x00005410841c7816ULL, 0x002fca0000000071ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x0000541077487816ULL, 0x004fce0000000078ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x0000541079497816ULL, 0x008fce0000000082ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000000482040723cULL, 0x000fee0000001840ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000001001e497824ULL, 0x040fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc400078e00ffULL, 0x000000ffff487224ULL, 0x000fe200078e0073ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000001d004b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x000054107c1d7816ULL, 0x008fce000000006fULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x0000001c2024723cULL, 0x000fee0000001824ULL, 0x000054105f1c7816ULL, 0x002fe2000000005cULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00005410611d7816ULL, 0x004fc40000000064ULL,
0x000088801f207816ULL, 0x000fca00000000ffULL, 0x0000001c1828723cULL, 0x000fe20000001828ULL,
0x0000004800487306ULL, 0x000fec0000200c00ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0020ULL,
0x00005410671d7816ULL, 0x008fe2000000005aULL, 0x000001001f207824ULL, 0x000fe200078e00ffULL,
0x0000004900497306ULL, 0x000e680000200c00ULL, 0x00000018ff207819ULL, 0x000fc80000011420ULL,
0x0000001c00217306ULL, 0x0005f00000200c00ULL, 0x0000006300637306ULL, 0x000ee20000200c00ULL,
0x00005410681c7816ULL, 0x004fe40000000057ULL, 0x0000541048487816ULL, 0x002fca0000000049ULL,
0x0000001c182c723cULL, 0x000fe2000000182cULL, 0x0000005d005d7306ULL, 0x000e6c0000200c00ULL,
0x000100001f1c7824ULL, 0x000fe200078e00ffULL, 0x000054106e1d7816ULL, 0x008fe20000000063ULL,
0x0000006200627306ULL, 0x000ea60000200c00ULL, 0x00000018ff227819ULL, 0x000fc4000001141cULL,
0x000054106c1c7816ULL, 0x000fc60000000059ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000054104a4a7816ULL, 0x002fc6000000005dULL, 0x0000001c1834723cULL, 0x000fe80000001834ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054104b4b7816ULL, 0x004fce0000000062ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000004a183c723cULL, 0x000fee000000183cULL,
0x0000006900697306ULL, 0x000e700000200c00ULL, 0x0000006500657306ULL, 0x000eb00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541066647816ULL, 0x002fce0000000069ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x0000541065657816ULL, 0x004fce000000006aULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000641830723cULL, 0x000fee0000001830ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054106b6c7816ULL, 0x002fce0000000070ULL,
0x0000002000207306ULL, 0x000e700000200c00ULL, 0x0000001e001f7306ULL, 0x000ee20000200c00ULL,
0x000054106d6d7816ULL, 0x004fce0000000072ULL, 0x0000002200577306ULL, 0x000ea20000200c00ULL,
0x0000541021497816ULL, 0x002fe20000000020ULL, 0x0000006c1838723cULL, 0x000fe20000001838ULL,
0x000054101f567816ULL, 0x008fce0000000056ULL, 0x000000481840723cULL, 0x000fe20000001840ULL,
0x0000541057577816ULL, 0x004fce0000000060ULL, 0x000000561824723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020000c187f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c00f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00f698005eff7f8cULL, 0x0007e2000c80043fULL,
0x000000010e4b7812ULL, 0x000fe200078e0cffULL, 0x000000ffff637224ULL, 0x010fe200078e0075ULL,
0x000000020f00720cULL, 0x000fda0003f06070ULL, 0x00001c2000000947ULL, 0x000fea0003800000ULL,
0x000004000d067984ULL, 0x008ee40000000800ULL, 0x8000000006ff7812ULL, 0x00cfe40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024000c067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x004fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000f7305ULL, 0x0004e4000021f000ULL, 0x3fa0000006067823ULL, 0x004fe200000100ffULL,
0x0000000f0000735dULL, 0x008fe20003800000ULL, 0x000024000c187984ULL, 0x000ea40000000800ULL,
0x8000000018ff7812ULL, 0x004fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff067819ULL, 0x000fe20000011644ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x00000300460f7a10ULL, 0x000fe20007ffe0ffULL, 0x00000000500473c2ULL, 0x0004e200000e0000ULL,
0x00000003ff227819ULL, 0x000fe40000011600ULL, 0x000000010f1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f1b7824ULL, 0x000fe200078e0206ULL, 0x0000000422487810ULL, 0x000fe40007ffe0ffULL,
0x000000031a00720cULL, 0x000fe20003f06070ULL, 0x000000201b1b7824ULL, 0x000fe200078e00ffULL,
0x00000008224a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c22567810ULL, 0x000fe20007ffe0ffULL,
0x0000620004207a24ULL, 0x000fe200078e021bULL, 0x0000001b021c7217ULL, 0x000fe40007800000ULL,
0x0000000855557812ULL, 0x000fe400078ec0ffULL, 0x0000002220187210ULL, 0x000fe20007ffe005ULL,
0x000000011c1b7824ULL, 0x000fe200078e0a1bULL, 0x00000048201a7210ULL, 0x000fe20007ffe005ULL,
0x000000014c627824ULL, 0x000fe400078e0255ULL, 0x00005e0018187625ULL, 0x000fca00078e0021ULL,
0x00000011181c7210ULL, 0x000fe40007f5e0ffULL, 0x000000201b187807ULL, 0x000fe20000000000ULL,
0x00005e001a1a7625ULL, 0x000fc600078e0021ULL, 0x0000001805187217ULL, 0x000fe20007800000ULL,
0x000000ffff1d7224ULL, 0x000fe200010e0619ULL, 0x000000111a1e7210ULL, 0x000fe40007f1e0ffULL,
0x00000056201a7210ULL, 0x100fe20007ffe005ULL, 0x00000001180f7824ULL, 0x100fe200078e0a05ULL,
0x0000004a20187210ULL, 0x000fe20007ffe005ULL, 0x000000ffff1f7224ULL, 0x000fe400000e061bULL,
0x00005e001a1a7625ULL, 0x000fe200078e0021ULL, 0x0000000f2200720cULL, 0x000fc40003f06070ULL,
0x0000000f4800720cULL, 0x000fe20003f46070ULL, 0x00005e0018187625ULL, 0x000fe200078e0021ULL,
0x0000000f4a00720cULL, 0x080fe40003f66070ULL, 0x0000000f5600720cULL, 0x000fe40003f86070ULL,
0x0000001118187210ULL, 0x080fe40007fbe0ffULL, 0x000000111a1a7210ULL, 0x000fc60007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c547faeULL, 0x0009e2000c101c46ULL, 0x000000ffff1b7224ULL, 0x000fc600030e061bULL,
0x000000001e537faeULL, 0x0009e8000d101c46ULL, 0x0000000018527faeULL, 0x0009e8000d901c46ULL,
0x000000001a517faeULL, 0x0009e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000062627f8cULL, 0x000ea8000c80043fULL,
0x000004004f4f7984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680010187f8cULL, 0x010fe2000c80043fULL,
0x800000004fff7812ULL, 0x008fc60007844875ULL, 0x00f66c00100f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x008fe40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f001a7305ULL, 0x000724000021f000ULL,
0x3fa000000f0f7823ULL, 0x008fe200000100ffULL, 0x0000001a0000735dULL, 0x010fe20003800000ULL,
0x00f66c00101b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x008fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018011127810ULL, 0x000fca0007ffe012ULL,
0x0000000113127824ULL, 0x000fca00078e0212ULL, 0x00f00000120f7984ULL, 0x000ee80000000800ULL,
0x00f2000012107984ULL, 0x0008620000000800ULL, 0x0000000a0f00720bULL, 0x008fe20003f1d000ULL,
0x00009ec27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000127806ULL, 0x010fc800000e0100ULL,
0x0000ffff121b7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff577424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000344197811ULL, 0x000fe400078ff0ffULL, 0x0000000a0f00720bULL, 0x000fe40003f14000ULL,
0x000000441900720cULL, 0x000fe20003f65270ULL, 0x00009e927f007947ULL, 0x000ff4000b800000ULL,
0x0000000000127806ULL, 0x000fe400000e0100ULL, 0x0000000f0a1c7209ULL, 0x000fe20007810000ULL,
0x000000804418b824ULL, 0x000fe200078e0211ULL, 0x0000ffff12127812ULL, 0x000fe400078e3cffULL,
0x00000002ff4a7819ULL, 0x000fe20000011600ULL, 0x000000011313b824ULL, 0x000fe200078e0218ULL,
0x000000121bff7212ULL, 0x000fe2000780c0ffULL, 0x8000001c0a0a7221ULL, 0x000fc60000010000ULL,
0x00f4001c1300b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a005f7308ULL, 0x000f240000000800ULL, 0x0000005f0b0b7220ULL, 0x010fe20000410000ULL,
0x00009e227f007947ULL, 0x000fea000b800000ULL, 0x00001f4a5f237589ULL, 0x00872400000e0000ULL,
0x0000002328287220ULL, 0x094fe40000410000ULL, 0x0000002329297220ULL, 0x080fe40000410000ULL,
0x000000232c2c7220ULL, 0x080fe40000410000ULL, 0x000000232d2d7220ULL, 0x080fe40000410000ULL,
0x0000002330307220ULL, 0x000fc40000410000ULL, 0x0000002331317220ULL, 0x080fe40000410000ULL,
0x0000002334347220ULL, 0x080fe40000410000ULL, 0x0000002335357220ULL, 0x080fe40000410000ULL,
0x0000002338387220ULL, 0x080fe40000410000ULL, 0x0000002339397220ULL, 0x080fe40000410000ULL,
0x000000233c3c7220ULL, 0x000fc40000410000ULL, 0x000000233d3d7220ULL, 0x080fe40000410000ULL,
0x0000002340407220ULL, 0x080fe40000410000ULL, 0x0000002341417220ULL, 0x080fe40000410000ULL,
0x0000002324247220ULL, 0x080fe40000410000ULL, 0x0000002325257220ULL, 0x000fe20000410000ULL,
0x00009d527f007947ULL, 0x000fea000b800000ULL, 0x00001f155f237589ULL, 0x00052400000e0000ULL,
0x8000001c0f0f0221ULL, 0x000fe20000010000ULL, 0x00000001ff577807ULL, 0x000fe20000000000ULL,
0x000000232a2a7220ULL, 0x014fc40000410000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fe40000410000ULL,
0x000000232b2b7220ULL, 0x080fe40000410000ULL, 0x0000000f00140308ULL, 0x000ea20000000800ULL,
0x000000232e2e7220ULL, 0x080fe40000410000ULL, 0x000000232f2f7220ULL, 0x080fe40000410000ULL,
0x0000002332327220ULL, 0x080fe40000410000ULL, 0x0000002333337220ULL, 0x000fc40000410000ULL,
0x0000002336367220ULL, 0x080fe40000410000ULL, 0x0000002337377220ULL, 0x080fe40000410000ULL,
0x000000233a3a7220ULL, 0x080fe40000410000ULL, 0x000000233b3b7220ULL, 0x080fe40000410000ULL,
0x000000233e3e7220ULL, 0x080fe40000410000ULL, 0x000000233f3f7220ULL, 0x000fc40000410000ULL,
0x0000002342427220ULL, 0x080fe40000410000ULL, 0x0000002343437220ULL, 0x080fe40000410000ULL,
0x0000002326267220ULL, 0x080fe40000410000ULL, 0x0000002327277220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e001cULL, 0x0000001014100220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000b100b7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff007107812ULL, 0x000fc800078ec0ffULL,
0x000000080f0f7812ULL, 0x000fca00078e0cffULL, 0x000000010f107824ULL, 0x000fca00078e0210ULL,
0x00f6ac00100f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00117305ULL, 0x000324000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x010fe40003800000ULL,
0x00f6ac0010117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff4a7819ULL, 0x008fe40000011600ULL,
0x00000014ff0f723eULL, 0x000fe400000000ffULL, 0x000000184a107810ULL, 0x040fe40007ffe0ffULL,
0x000000104a117810ULL, 0x000fe40007ffe0ffULL, 0x000054100f5f7816ULL, 0x000fe2000000000fULL,
0x00009a927f007947ULL, 0x000fea000b800000ULL, 0x00001f4a5f0f7589ULL, 0x0002e400000e0000ULL,
0x00009ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f155f487589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4a7224ULL, 0x002fe200078e0011ULL,
0x0000772000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff1a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x0000a1d000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4a7224ULL, 0x002fe200078e0010ULL,
0x0000778000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff1a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x0000a17000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004e18783bULL, 0x002e680000004200ULL,
0x000000004d1c783bULL, 0x000f680000004200ULL, 0x000000004520783bULL, 0x004ea80000004200ULL,
0x000000004710783bULL, 0x000f240000004200ULL, 0x00000018ff5f7819ULL, 0x012fe20000011418ULL,
0x00000100184e7824ULL, 0x040fe200078e00ffULL, 0x0000888018727816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011419ULL,
0x0000010019507824ULL, 0x040fe200078e00ffULL, 0x0000888019747816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff5a7819ULL, 0x000fe4000001141aULL,
0x00000018ff597819ULL, 0x000fe2000001141bULL, 0x0000001800767306ULL, 0x0003e20000200c00ULL,
0x000088801a667816ULL, 0x000fe400000000ffULL, 0x000088801b6c7816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x020fc4000001141dULL, 0x000088801d657816ULL, 0x000fe200000000ffULL,
0x0000001900787306ULL, 0x0009e20000200c00ULL, 0x000001001b187824ULL, 0x042fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe2000001141cULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088801c647816ULL, 0x040fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000004e00737306ULL, 0x0003620000200c00ULL, 0x000001001c197824ULL, 0x050fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001800717306ULL, 0x0009e20000200c00ULL, 0x000001001a4e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x004fe40000011420ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000001900677306ULL, 0x0003e20000200c00ULL, 0x000001001d187824ULL, 0x050fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x0000888020517816ULL, 0x000fc400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000004e006d7306ULL, 0x000fe20000200c00ULL, 0x000001001e197824ULL, 0x002fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff4d7819ULL, 0x000fe40000011421ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000001800707306ULL, 0x0003e20000200c00ULL,
0x00000018ff497819ULL, 0x000fc40000011422ULL, 0x00000018ff4f7819ULL, 0x000fe4000001141eULL,
0x000088801e607816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe2000001141fULL, 0x00000019005d7306ULL, 0x0005e20000200c00ULL,
0x000001001f187824ULL, 0x042fe200078e00ffULL, 0x000088801f5b7816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x0000001a006f7306ULL, 0x000fe20000200c00ULL,
0x0000010020197824ULL, 0x044fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011411ULL,
0x00000018ff4e7819ULL, 0x000fe40000011419ULL, 0x0000001800627306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011420ULL, 0x0000888022207816ULL, 0x000fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011423ULL, 0x00000018ff157819ULL, 0x000fe20000011412ULL,
0x0000001b006e7306ULL, 0x0005e20000200c00ULL, 0x0000010021187824ULL, 0x002fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011413ULL, 0x00000018ff477819ULL, 0x000fe40000011410ULL,
0x00000018ff537819ULL, 0x000fe40000011418ULL, 0x0000001d006b7306ULL, 0x0003e20000200c00ULL,
0x00a800001618783bULL, 0x00452e0000000200ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00009910571d7816ULL, 0x002fc400000000ffULL, 0x0000888023167816ULL, 0x004fe400000000ffULL,
0x000000ff1d00720cULL, 0x000fc60003f05270ULL, 0x0000005000757306ULL, 0x0002a20000200c00ULL,
0x000000ffff577224ULL, 0x000fe400078e0016ULL, 0x0000010023167824ULL, 0x040fe400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x0000001c00687306ULL, 0x0007e20000200c00ULL,
0x0000888021507816ULL, 0x042fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe20000011416ULL, 0x0001000022167824ULL, 0x040fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff567819ULL, 0x000fe20000011421ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x00000100221c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fc80000011416ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x0000000f18188232ULL, 0x090fe40000000000ULL,
0x0000000f1a1a8232ULL, 0x000fe40000000000ULL, 0x0000004819198232ULL, 0x080fe40000000000ULL,
0x000000481b1b8232ULL, 0x000fe20000000000ULL, 0x0000001c00217306ULL, 0x000bf00000200c00ULL,
0x0000001d00227306ULL, 0x0005e20000200c00ULL, 0x00005410721c7816ULL, 0x020fce0000000073ULL,
0x0000001e006a7306ULL, 0x0009e20000200c00ULL, 0x00005410741d7816ULL, 0x004fce0000000075ULL,
0x0000001c1828723cULL, 0x000fe20000001828ULL, 0x00008880101e7816ULL, 0x010fe200000000ffULL,
0x0000001f00697306ULL, 0x0005e80000200c00ULL, 0x000000ffff727224ULL, 0x000fe200078e001eULL,
0x00005410761c7816ULL, 0x002fe4000000005fULL, 0x00005410781d7816ULL, 0x008fe20000000061ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000888011617816ULL, 0x000fca00000000ffULL,
0x0000001c182c723cULL, 0x000fe2000000182cULL, 0x00a80000171c783bULL, 0x0042a20000000200ULL,
0x0000006c006c7306ULL, 0x000e700000200c00ULL, 0x00000016005c7306ULL, 0x0007f00000200c00ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000010010167824ULL, 0x008fe200078e00ffULL,
0x000054106c177816ULL, 0x002fc80000000071ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x0000000f1c1c8232ULL, 0x004fce0000000000ULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x0000000f1e1e8232ULL, 0x000fe20000000000ULL, 0x00000100120f7824ULL, 0x000fe200078e00ffULL,
0x000000481d1d8232ULL, 0x080fe40000000000ULL, 0x000000481f1f8232ULL, 0x000fe40000000000ULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x00000016005f7306ULL, 0x0007e20000200c00ULL,
0x0000541064647816ULL, 0x002fce0000000067ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x0000541066167816ULL, 0x008fe2000000006dULL, 0x0000010011667824ULL, 0x000fe200078e00ffULL,
0x0000541065657816ULL, 0x004fe20000000070ULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000000161830723cULL, 0x000fe20000001830ULL, 0x00000018ff117819ULL, 0x000fcc0000011411ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000054106f167816ULL, 0x000fe2000000005aULL,
0x000000641838723cULL, 0x000fe20000001838ULL, 0x000054106e177816ULL, 0x000fca0000000059ULL,
0x0000004f004f7306ULL, 0x000f220000200c00ULL, 0x000054106b657816ULL, 0x002fe20000000058ULL,
0x000000161834723cULL, 0x000fe20000001834ULL, 0x0000541069697816ULL, 0x004fca0000000052ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000888012177816ULL, 0x000fe200000000ffULL,
0x0001000010167824ULL, 0x000fe200078e00ffULL, 0x0000541068647816ULL, 0x008fe20000000055ULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000054106a687816ULL, 0x010fe2000000004fULL,
0x00000064183c723cULL, 0x000fe2000000183cULL, 0x00000018ff127819ULL, 0x000fca0000011412ULL,
0x0000001100587306ULL, 0x0007e20000200c00ULL, 0x00005410605a7816ULL, 0x002fe2000000005dULL,
0x000000681824723cULL, 0x000fec0000001824ULL, 0x0000001700527306ULL, 0x0003e20000200c00ULL,
0x0000888013117816ULL, 0x008fe400000000ffULL, 0x000054105b5b7816ULL, 0x004fca0000000062ULL,
0x0000002000207306ULL, 0x000ea20000200c00ULL, 0x0000010013177824ULL, 0x042fe200078e00ffULL,
0x0000005a1840723cULL, 0x000fe20000001840ULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541020207816ULL, 0x004fce0000000021ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000005700577306ULL, 0x000eb00000200c00ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410504f7816ULL, 0x002fce0000000053ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541057217816ULL, 0x004fce0000000022ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000000201c30723cULL, 0x000fee0000001830ULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054105c227816ULL, 0x002fce0000000049ULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000001500157306ULL, 0x000ff00000200c00ULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000005100517306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000005400547306ULL, 0x000eb00000200c00ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x00005410514e7816ULL, 0x002fce000000004eULL, 0x0000002300237306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x004fe20000000045ULL, 0x0000004e1c28723cULL, 0x000fec0000001828ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0000541056557816ULL, 0x008fce000000004dULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000541023237816ULL, 0x002fe2000000004cULL,
0x000000541c2c723cULL, 0x040fec000000182cULL, 0x0000006600107306ULL, 0x000e620000200c00ULL,
0x0000541072607816ULL, 0x004fe2000000005fULL, 0x000000221c34723cULL, 0x000fec0000001834ULL,
0x0000001600167306ULL, 0x000eb00000200c00ULL, 0x0000000f000f7306ULL, 0x000ee20000200c00ULL,
0x0000541061617816ULL, 0x002fce0000000010ULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0000541016167816ULL, 0x004fe20000000047ULL, 0x000000601c38723cULL, 0x000fec0000001838ULL,
0x0000001700187306ULL, 0x0002a20000200c00ULL, 0x0000541052527816ULL, 0x008fce000000000fULL,
0x0000001200127306ULL, 0x000ee20000200c00ULL, 0x0000541058177816ULL, 0x002fce000000004bULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x0000541011537816ULL, 0x004fe20000000018ULL,
0x000000161c3c723cULL, 0x000fe2000000183cULL, 0x0000541012127816ULL, 0x008fce0000000015ULL,
0x000000521c40723cULL, 0x000fe20000001840ULL, 0x0000541013137816ULL, 0x002fce000000004aULL,
0x000000121c24723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020000c107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0005eff7f8cULL, 0x0007e2000c80043fULL,
0x000000010e4b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x004fe400078e0011ULL,
0x0000030046467a10ULL, 0x008fc80007ffe0ffULL, 0x000000034600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff864000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x002e640000002500ULL, 0x0000000403007c0cULL, 0x002fda000bf03070ULL,
0x0000039000000947ULL, 0x000fea0003800000ULL, 0x018000000b007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e000bULL, 0x0000879000077802ULL, 0x000fe40000000f00ULL,
0x00008f9000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000000bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000f620000000000ULL, 0x00000002ff0c7819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x020fe200078ff0ffULL, 0x0000000003057220ULL, 0x010fca0000410000ULL,
0x00001f0c05007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000f2200000e0000ULL,
0x0000002800287220ULL, 0x042fe40000410000ULL, 0x0000002900297220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x000fc40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe40000410000ULL, 0x0000003500357220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x040fe40000410000ULL, 0x0000003900397220ULL, 0x000fc40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000004000407220ULL, 0x040fe40000410000ULL, 0x0000004100417220ULL, 0x040fe40000410000ULL,
0x0000002400247220ULL, 0x040fe40000410000ULL, 0x0000002500257220ULL, 0x000fc40000410000ULL,
0x0000002a042a7220ULL, 0x050fe40000410000ULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000002e042e7220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000003204327220ULL, 0x040fe40000410000ULL, 0x0000003304337220ULL, 0x000fc40000410000ULL,
0x0000003604367220ULL, 0x040fe40000410000ULL, 0x0000003704377220ULL, 0x040fe40000410000ULL,
0x0000003a043a7220ULL, 0x040fe40000410000ULL, 0x0000003b043b7220ULL, 0x040fe40000410000ULL,
0x0000003e043e7220ULL, 0x040fe40000410000ULL, 0x0000003f043f7220ULL, 0x000fc40000410000ULL,
0x0000004204427220ULL, 0x040fe40000410000ULL, 0x0000004304437220ULL, 0x040fe40000410000ULL,
0x0000002604267220ULL, 0x040fe40000410000ULL, 0x0000002704277220ULL, 0x000fc80000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000262726723eULL, 0x000fc600000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x042fe400078ec0ffULL,
0x00000002ff137819ULL, 0x000fe40000011603ULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x00000004000c7811ULL, 0x000fe400078ff8ffULL, 0x00000008031b7811ULL, 0x000fe400078ff0ffULL,
0x00000001ff027819ULL, 0x000fc40000011600ULL, 0x0000000704057812ULL, 0x100fe400078e7813ULL,
0x00000006000f7811ULL, 0x008fe400078ff8ffULL, 0x000000070c0e7812ULL, 0x040fe200078e7813ULL,
0x00000008130d7824ULL, 0x000fe200078e0205ULL, 0x000000070c0c7812ULL, 0x000fe200078e781bULL,
0x0000100009057824ULL, 0x000fe200078e00ffULL, 0x0000000702007812ULL, 0x140fe200078e7813ULL,
0x0000000813117824ULL, 0x000fe200078e020eULL, 0x000000070f107812ULL, 0x000fe200078e7813ULL,
0x000000081b197824ULL, 0x004fe200078e020cULL, 0x0000000702027812ULL, 0x100fe200078e781bULL,
0x00000008030c7824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x100fe200078e781bULL,
0x0000000813077824ULL, 0x000fe200078e0200ULL, 0x000000070f0f7812ULL, 0x000fe200078e781bULL,
0x000000081b157824ULL, 0x040fe200078e0202ULL, 0x000000080c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000081b177824ULL, 0x000fe200078e0204ULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x0000080006007824ULL, 0x000fe200078e0205ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000000813137824ULL, 0x000fc400078e0210ULL, 0x000000081b1b7824ULL, 0x000fe200078e020fULL,
0x00005410021c7816ULL, 0x040fe20000000004ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x00007632021d7816ULL, 0x000fe20000000004ULL, 0x000000100d0f7824ULL, 0x100fe200078e0200ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x100fe400078e0200ULL,
0x0000001017177824ULL, 0x000fe200078e0200ULL, 0x00005410020e7816ULL, 0x000fe20000000004ULL,
0x0000001013137824ULL, 0x000fc400078e0200ULL, 0x0000001019197824ULL, 0x100fe400078e0200ULL,
0x000000101b1b7824ULL, 0x000fe400078e0200ULL, 0x00000001070d7824ULL, 0x000fe200078e020cULL,
0x000000303107723eULL, 0x000fe200000000ffULL, 0x000000010c0f7824ULL, 0x040fe400078e020fULL,
0x000000010c117824ULL, 0x040fe200078e0211ULL, 0x0000001c0d007388ULL, 0x0003e20000000a00ULL,
0x000000010c157824ULL, 0x000fc400078e0215ULL, 0x000000010c177824ULL, 0x040fe400078e0217ULL,
0x000000010c137824ULL, 0x040fe400078e0213ULL, 0x000000010c197824ULL, 0x040fe400078e0219ULL,
0x000000010c1b7824ULL, 0x000fe200078e021bULL, 0x00000034350c723eULL, 0x000fc800000000ffULL,
0x00005410071c7816ULL, 0x142fe4000000000cULL, 0x00007632071d7816ULL, 0x000fe4000000000cULL,
0x000000404107723eULL, 0x000fe400000000ffULL, 0x00000024250c723eULL, 0x000fe200000000ffULL,
0x0000001c0f007388ULL, 0x0003e40000000a00ULL, 0x00007632020f7816ULL, 0x002fe40000000004ULL,
0x0000002a2b02723eULL, 0x000fc400000000ffULL, 0x0000002e2f04723eULL, 0x000fe200000000ffULL,
0x0000000e11007388ULL, 0x0003e60000000a00ULL, 0x0000541002107816ULL, 0x040fe40000000004ULL,
0x00005410070e7816ULL, 0x142fe4000000000cULL, 0x00007632070f7816ULL, 0x000fe4000000000cULL,
0x0000763202117816ULL, 0x000fc40000000004ULL, 0x000000323307723eULL, 0x000fe200000000ffULL,
0x0000000e13007388ULL, 0x0003e20000000a00ULL, 0x00000036370c723eULL, 0x000fe400000000ffULL,
0x0000003a3b02723eULL, 0x000fe200000000ffULL, 0x0000001015007388ULL, 0x0005e20000000a00ULL,
0x0000003e3f04723eULL, 0x000fc800000000ffULL, 0x00007632020d7816ULL, 0x000fe20000000004ULL,
0x00000020060e7824ULL, 0x002fe200078e0203ULL, 0x0000541007107816ULL, 0x004fc6000000000cULL,
0x000000100e0f7824ULL, 0x000fe200078e0205ULL, 0x0000763207117816ULL, 0x000fe4000000000cULL,
0x00005410020c7816ULL, 0x000fe40000000004ULL, 0x000000424307723eULL, 0x000fe200000000ffULL,
0x0000001017007388ULL, 0x000fe80000000a00ULL, 0x0000000c19007388ULL, 0x0003e40000000a00ULL,
0x00005410070c7816ULL, 0x002fc40000000026ULL, 0x00007632070d7816ULL, 0x000fca0000000026ULL,
0x0000000c1b007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000f107984ULL, 0x000e680000000c00ULL, 0x000800000f147984ULL, 0x000ea80000000c00ULL,
0x000400000f1c7984ULL, 0x000ee80000000c00ULL, 0x000c00000f207984ULL, 0x000f220000000c00ULL,
0x200000ff12127230ULL, 0x002fc40000000000ULL, 0x200000ff13137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x004fe20000000000ULL, 0x00000300ff167624ULL, 0x000fe200078e00ffULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x000000011600780cULL, 0x000fe20003f05270ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fc40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x000000100f007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c0f007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f3000008947ULL, 0x000fea0003800000ULL,
0x0000000000147919ULL, 0x000ea20000002700ULL, 0x0000580016027a24ULL, 0x000fe200078e02ffULL,
0x0000000106ff7812ULL, 0x000fe2000780f844ULL, 0x00000800ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x0000640002107a24ULL, 0x002fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x0000040009047824ULL, 0x000fe200078e00ffULL,
0x000000000f187984ULL, 0x0002e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc40000725670ULL,
0x000007ff10027811ULL, 0x000fe200078e40ffULL, 0x0000580014147a24ULL, 0x004fc800078e0207ULL,
0x0000030014077a24ULL, 0x000fca00078e02ffULL, 0x0000000407117c10ULL, 0x000fc8000fffe0ffULL,
0x00000011020c7211ULL, 0x000fca00078fa8ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e000dULL,
0x000000040c127210ULL, 0x000fe40007f5e0ffULL, 0x01ffffff100c7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff137224ULL, 0x000fc800010e060dULL, 0x000000100e127825ULL, 0x000fe200078e0012ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010030e7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000000111107824ULL, 0x000fe200078e020cULL, 0x000000700e157812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f177812ULL, 0x000fe200078ec0ffULL, 0x00006a00110e7625ULL, 0x000fc800078e000dULL,
0x00006a0010107625ULL, 0x000fe200078e000dULL, 0x0000000e170e7210ULL, 0x000fc80007a1e015ULL,
0x0000001017107210ULL, 0x000fe40007c7e015ULL, 0x0000000fff0f7210ULL, 0x000fe400007e44ffULL,
0x00000011ff117210ULL, 0x000fc60001fe84ffULL, 0x0000000a0e007986ULL, 0x0003e8000c101906ULL,
0x0000000b10007986ULL, 0x0003e4000c101906ULL, 0x0000000000007941ULL, 0x00afea0003800000ULL,
0x0000001812007986ULL, 0x0003e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff160d7810ULL, 0x000fc60007ffe0ffULL,
0x00006800140a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x0000000d0a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0e7807ULL, 0x000fca0000000000ULL, 0x0000000eff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0a7984ULL, 0x000ee40000000000ULL, 0x000000ff0a00720cULL, 0x008fda0003f05270ULL,
0x00002b8000008947ULL, 0x000fea0003800000ULL, 0x000000ff4400720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001070e7810ULL, 0x004fe40007ffe0ffULL, 0x000000700a197812ULL, 0x002fe400078ec0ffULL,
0x0000000c0b127812ULL, 0x000fe200078ec0ffULL, 0x00006a00070a7625ULL, 0x000fc800078e0011ULL,
0x00006a000e0e7625ULL, 0x000fe200078e0011ULL, 0x0000000a120a7210ULL, 0x000fc8000791e019ULL,
0x0000000e120e7210ULL, 0x000fe40007b5e019ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x000000060a0a7981ULL, 0x000368000c1e1900ULL,
0x000000060e0d7981ULL, 0x000362000c1e1900ULL, 0x000000021600780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002070e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fc8000791e019ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e0b7981ULL, 0x000362000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003070e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0011ULL,
0x0000000e120e7210ULL, 0x000fc8000791e019ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e137981ULL, 0x000362000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004070e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fc8000791e019ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e157981ULL, 0x000362000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005070e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0011ULL,
0x0000000e120e7210ULL, 0x000fc8000791e019ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e177981ULL, 0x000362000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081600780cULL, 0x002fe40003f06070ULL,
0x00000006070e7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0011ULL,
0x0000000e120e7210ULL, 0x000fe40007a3e019ULL, 0x0000000707100810ULL, 0x000fe40007ffe0ffULL,
0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL, 0x00006a0010100625ULL, 0x000fca00078e0011ULL,
0x0000001012100210ULL, 0x000fe40007c7e019ULL, 0x000000060e197981ULL, 0x000364000c1e1900ULL,
0x00000011ff110210ULL, 0x000fca0001fe84ffULL, 0x00000006101b0981ULL, 0x000368000c1e1900ULL,
0x00000007160e7810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff107819ULL, 0x000fc8000001160eULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x020fe400078e000aULL,
0x0000000811127824ULL, 0x040fe200078e00ffULL, 0x0000000111117810ULL, 0x000fc80007ffe0ffULL,
0x0000030012007a0cULL, 0x000fe40003f26070ULL, 0x000000101100720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008120e7810ULL, 0x040fe40007ffe0ffULL,
0x00000001120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x00000070141d7812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e01dULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e1d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000002120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e00dULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e0d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000003120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000000b0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007b3e00bULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e0b7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000004120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x000000130a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e013ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e137981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000005120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000150a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014157812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e157981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000006120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x000000170a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014177812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e017ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000007120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014197812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e019ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f120e7810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x000003000e007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x00000070121b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007a3e01bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL, 0x000000060e1b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x00000010030b7824ULL, 0x024fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0e7812ULL, 0x002fca00078ec0ffULL,
0x000000010e0b7824ULL, 0x000fca00078e020bULL, 0x0000000a0b007388ULL, 0x0003e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x00000010030b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x004fe20000011603ULL, 0x0000000106137824ULL, 0x000fe200078e0207ULL,
0x00000002ff0f7819ULL, 0x000fe20000011644ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000700b0d7812ULL, 0x000fe200078ec0ffULL, 0x00000800ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000020044447824ULL, 0x000fe200078e00ffULL,
0x00000013020a7211ULL, 0x000fe200078fa8ffULL, 0x0000000108087824ULL, 0x000fe200078e0205ULL,
0x0000002003157810ULL, 0x000fe20007ffe0ffULL, 0x000000010e1a7824ULL, 0x000fe200078e020dULL,
0x000000010f0d7812ULL, 0x000fe200078ec0ffULL, 0x00000002060e8824ULL, 0x140fe200078e0209ULL,
0x000010a000007945ULL, 0x000fe20003800000ULL, 0x0000000206108824ULL, 0x000fe200078e0209ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00006a000a0a7625ULL, 0x000fe200078e0011ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000020e148824ULL, 0x100fe200078e020dULL,
0x000000040a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000210188824ULL, 0x000fe200078e020dULL,
0x00000800440d7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0e8824ULL, 0x000fe200078e0213ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000080ff128424ULL, 0x000fc400078e00ffULL,
0x0000000108107824ULL, 0x000fe400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000030006007a0cULL, 0x000fe20003f26070ULL, 0x00006a000e0e8625ULL, 0x000fc800078e000fULL,
0x00006a0013128625ULL, 0x000fc800078e0012ULL, 0x00000008141d8824ULL, 0x100fe400078e0203ULL,
0x00000008181f8824ULL, 0x000fe400078e0203ULL, 0x00000010031b7824ULL, 0x000fe200078e0210ULL,
0x000045801d1d8811ULL, 0x000fe200078e20ffULL, 0x0000001003107825ULL, 0x000fe200078e000aULL,
0x000041801f1f8811ULL, 0x000fc600078e20ffULL, 0x0000001015147825ULL, 0x000fe400078e000aULL,
0x000000001a0a7984ULL, 0x0002a40000000800ULL, 0x0000001003168825ULL, 0x040fe400078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000101b7faeULL, 0x0007e2000b901c46ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000001003188825ULL, 0x000fe400078e0012ULL,
0x00380000141b7faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e00ffULL, 0x00000000161d8faeULL, 0x000be2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x00000000181f8faeULL, 0x000be2000b901c46ULL, 0x0000000000107805ULL, 0x008fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x00000000001a7805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x020fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fca00078e0006ULL,
0x000000022d2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x000003002e007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000107377824ULL, 0x100fe200078e022eULL,
0x00000001ff2f7819ULL, 0x000fe2000001162eULL, 0x00000800ff317424ULL, 0x000fe200078e00ffULL,
0x0000002003397810ULL, 0x000fe20007ffe0ffULL, 0x000004002e327824ULL, 0x000fe200078e00ffULL,
0x0000003702307211ULL, 0x000fe400078fa8ffULL, 0x000000012f2f7812ULL, 0x000fc600078ec0ffULL,
0x00006a0030307625ULL, 0x000fc800078e0031ULL, 0x0000000206389824ULL, 0x100fe200078e0209ULL,
0x0000000430307210ULL, 0x000fe20007f1e0ffULL, 0x0000000206369824ULL, 0x000fe400078e0209ULL,
0x0000000238389824ULL, 0x100fe400078e022fULL, 0x00000002363a9824ULL, 0x000fe200078e022fULL,
0x00000800322f7812ULL, 0x000fe200078ec0ffULL, 0x000000010c339824ULL, 0x000fe400078e0237ULL,
0x00000080ff349424ULL, 0x000fc400078e00ffULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00006a0033329625ULL, 0x000fc800078e0034ULL, 0x0000000108347824ULL, 0x000fe400078e022fULL,
0x000000ffff317224ULL, 0x000fe400000e0631ULL, 0x00006a0037369625ULL, 0x000fc800078e0036ULL,
0x00000010032f7824ULL, 0x040fe400078e0234ULL, 0x0000000838389824ULL, 0x000fe400078e0203ULL,
0x0000001003349825ULL, 0x000fc800078e0032ULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x0000001039327825ULL, 0x100fe200078e0030ULL, 0x0000458038399811ULL, 0x000fe400078e20ffULL,
0x000041803a3b9811ULL, 0x000fe200078e20ffULL, 0x0000001003307825ULL, 0x000fc800078e0030ULL,
0x0000001003369825ULL, 0x000fe200078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000302f7faeULL, 0x0003e8000b901c46ULL, 0x00380000322f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034399faeULL, 0x0003e8000b901c46ULL, 0x00000000363b9faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff327224ULL, 0x002fe200078e002dULL, 0x00000001ff317819ULL, 0x000fe20000011603ULL,
0x0000000206307824ULL, 0x000fe200078e0209ULL, 0x00000002ff387819ULL, 0x000fe20000011603ULL,
0x00000040322d7824ULL, 0x000fe200078e00ffULL, 0x0000000c31317812ULL, 0x000fe200078ec0ffULL,
0x00000010032f7824ULL, 0x000fe200078e00ffULL, 0x0000000738347812ULL, 0x040fe200078ec0ffULL,
0x0000000838367824ULL, 0x000fe200078e00ffULL, 0x000000802d2d7812ULL, 0x000fc400078ec0ffULL,
0x00000038ff3d7212ULL, 0x000fe400078e33ffULL, 0x00000008383a7810ULL, 0x000fe20007ffe0ffULL,
0x00000100302d7824ULL, 0x000fe200078e002dULL, 0x000000702f307812ULL, 0x000fe200078ec0ffULL,
0x00000008382f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8363d7812ULL, 0x000fe200078ee23dULL,
0x000000083a417824ULL, 0x000fe200078e00ffULL, 0x0000002d31307210ULL, 0x000fe20007ffe030ULL,
0x00000008382d7824ULL, 0x000fe200078e00ffULL, 0x000000012f317812ULL, 0x000fe200078ef634ULL,
0x000000083a3f7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000303b7984ULL, 0x000e620000000800ULL, 0x000000022f337812ULL, 0x140fe200078ef634ULL,
0x000000083a3c7824ULL, 0x000fe200078e00ffULL, 0x000000032f357812ULL, 0x140fe200078ef634ULL,
0x00458000304d7984ULL, 0x0002e20000000800ULL, 0x000000042f377812ULL, 0x140fe400078ef634ULL,
0x000000052f397812ULL, 0x100fe400078ef634ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee234ULL,
0x0000003aff4b7212ULL, 0x000fc800078e33ffULL, 0xfffffff83c4b7812ULL, 0x000fe200078ee24bULL,
0x0000003b0a307221ULL, 0x006fe20000010100ULL, 0x000000062f3b7812ULL, 0x000fe200078ef634ULL,
0x00000400322f7824ULL, 0x000fe200078e00ffULL, 0x000000073a347812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b30367820ULL, 0x000fe40000410000ULL, 0x0000000403307824ULL, 0x000fe200078e00ffULL,
0x000008002f2f7812ULL, 0x000fe400078ec0ffULL, 0x000000023f437812ULL, 0x000fe200078ef634ULL,
0x0000003600367308ULL, 0x000ee20000000800ULL, 0x0000000c30327812ULL, 0x000fc400078ec0ffULL,
0x0000018008307810ULL, 0x000fe40007ffe02fULL, 0xfffffff8412f7812ULL, 0x100fe400078ee234ULL,
0x000000013f417812ULL, 0x000fe200078ef634ULL, 0x000000102d2d7824ULL, 0x000fe200078e0230ULL,
0x000000033f457812ULL, 0x000fe200078ef634ULL, 0x0000001031317824ULL, 0x000fe200078e0230ULL,
0x000000043f477812ULL, 0x000fe200078ef634ULL, 0x000000012d2d7824ULL, 0x000fe200078e0232ULL,
0x000000053f497812ULL, 0x140fe200078ef634ULL, 0x0000000132317824ULL, 0x000fe200078e0231ULL,
0x000000063f3f7812ULL, 0x000fe200078ef634ULL, 0x0000001035357824ULL, 0x000fc400078e0230ULL,
0x000000002d2d7984ULL, 0x000e620000000800ULL, 0x0000001039397824ULL, 0x100fe400078e0230ULL,
0x0000000132357824ULL, 0x040fe200078e0235ULL, 0x0000000031317984ULL, 0x000fe20000000800ULL,
0x0000000132397824ULL, 0x000fe400078e0239ULL, 0x000000103b3b7824ULL, 0x000fe400078e0230ULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x0000004d364d7220ULL, 0x008fc40000410000ULL,
0x00000001323b7824ULL, 0x040fe200078e023bULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000001041417824ULL, 0x100fe400078e0230ULL, 0x0000001037377824ULL, 0x100fe200078e0230ULL,
0x00001f384d347589ULL, 0x000ea200000e0000ULL, 0x0000000132417824ULL, 0x040fe400078e0241ULL,
0x0000000132377824ULL, 0x000fe200078e0237ULL, 0x000000003b3b7984ULL, 0x000fe20000000800ULL,
0x0000001045457824ULL, 0x000fc400078e0230ULL, 0x000000102f2f7824ULL, 0x100fe200078e0230ULL,
0x0000000041417984ULL, 0x000fe20000000800ULL, 0x0000000132457824ULL, 0x040fe400078e0245ULL,
0x00000001322f7824ULL, 0x000fe200078e022fULL, 0x0000000037377984ULL, 0x000ee20000000800ULL,
0x000000103d3d7824ULL, 0x100fe400078e0230ULL, 0x0000001033337824ULL, 0x100fe200078e0230ULL,
0x0000000045457984ULL, 0x000fe20000000800ULL, 0x0000001043437824ULL, 0x000fc400078e0230ULL,
0x0000001047477824ULL, 0x100fe200078e0230ULL, 0x000000002f2f7984ULL, 0x000f220000000800ULL,
0x0000001049497824ULL, 0x100fe400078e0230ULL, 0x000000103f3f7824ULL, 0x100fe400078e0230ULL,
0x000000104b4b7824ULL, 0x000fe400078e0230ULL, 0x00000001323d7824ULL, 0x040fe200078e023dULL,
0x00001f3a4d307589ULL, 0x000f6200000e0000ULL, 0x0000000132337824ULL, 0x000fc400078e0233ULL,
0x0000000132437824ULL, 0x040fe400078e0243ULL, 0x0000000132477824ULL, 0x040fe200078e0247ULL,
0x000000003d3d7984ULL, 0x000f620000000800ULL, 0x0000000132497824ULL, 0x040fe400078e0249ULL,
0x00000001323f7824ULL, 0x040fe200078e023fULL, 0x0000000043437984ULL, 0x000f620000000800ULL,
0x00000001324b7824ULL, 0x000fe200078e024bULL, 0x2000002dff327230ULL, 0x102fe20000004100ULL,
0x0000002c4d2c7221ULL, 0x000fe20000010000ULL, 0x3000002dff2d7230ULL, 0x000fe20000004100ULL,
0x0000000047477984ULL, 0x000e640000000800ULL, 0x00000034322b7223ULL, 0x004fc4000001002bULL,
0x000000342d2a7223ULL, 0x000fe2000001002aULL, 0x20000031ff2d7230ULL, 0x100fe20000004100ULL,
0x0000000033337984ULL, 0x000ea20000000800ULL, 0x30000031ff317230ULL, 0x000fc60000004100ULL,
0x000000342d277223ULL, 0x080fe20000010027ULL, 0x20000035ff2d7230ULL, 0x000fe20000004100ULL,
0x0000000049497984ULL, 0x000ea20000000800ULL, 0x0000003431267223ULL, 0x080fe20000010026ULL,
0x20000037ff317230ULL, 0x008fe40000004100ULL, 0x000000003f3f7984ULL, 0x000ee20000000800ULL,
0x000000342d1f7223ULL, 0x080fe2000001001fULL, 0x20000039ff2d7230ULL, 0x000fe20000004100ULL,
0x00000034311b7223ULL, 0x000fe2000001001bULL, 0x000000004b4b7984ULL, 0x000ee20000000800ULL,
0x2000002fff317230ULL, 0x010fc40000004100ULL, 0x000000342d177223ULL, 0x000fe20000010017ULL,
0x2000003bff2d7230ULL, 0x000fe40000004100ULL, 0x3000002fff2f7230ULL, 0x000fe20000004100ULL,
0x0000003031297223ULL, 0x020fe20000010029ULL, 0x30000035ff357230ULL, 0x000fe20000004100ULL,
0x000000342d137223ULL, 0x000fe20000010013ULL, 0x20000041ff2d7230ULL, 0x000fe20000004100ULL,
0x000000302f287223ULL, 0x000fe20000010028ULL, 0x2000003dff367230ULL, 0x100fe20000004100ULL,
0x00000034351e7223ULL, 0x000fe2000001001eULL, 0x3000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000302d257223ULL, 0x000fe20000010025ULL, 0x20000045ff2d7230ULL, 0x000fe20000004100ULL,
0x00000034360f7223ULL, 0x080fe2000001000fULL, 0x20000043ff2f7230ULL, 0x000fe20000004100ULL,
0x000000343d0e7223ULL, 0x000fe2000001000eULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x000000302d1d7223ULL, 0x080fe2000001001dULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x000000ffff2d7224ULL, 0x000fe200078e002eULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x000000302f217223ULL, 0x000fe20000010021ULL, 0x20000047ff2f7230ULL, 0x002fe20000004100ULL,
0x00000034371a7223ULL, 0x080fe2000001001aULL, 0x000003002d007a0cULL, 0x000fe20003f06070ULL,
0x20000033ff327230ULL, 0x104fe20000004100ULL, 0x0000003439167223ULL, 0x000fe20000010016ULL,
0x30000033ff337230ULL, 0x000fe20000004100ULL, 0x000000302f197223ULL, 0x000fe20000010019ULL,
0x20000049ff317230ULL, 0x000fe20000004100ULL, 0x0000003432237223ULL, 0x080fe20000010023ULL,
0x30000041ff417230ULL, 0x000fe20000004100ULL, 0x0000003433227223ULL, 0x080fe20000010022ULL,
0x2000003fff2e7230ULL, 0x008fe20000004100ULL, 0x000000343b127223ULL, 0x000fe20000010012ULL,
0x30000043ff437230ULL, 0x000fe20000004100ULL, 0x0000003041247223ULL, 0x080fe20000010024ULL,
0x2000004bff2f7230ULL, 0x000fe20000004100ULL, 0x0000003031157223ULL, 0x080fe20000010015ULL,
0x30000045ff457230ULL, 0x000fe20000004100ULL, 0x0000003043207223ULL, 0x080fe20000010020ULL,
0x30000047ff477230ULL, 0x000fe20000004100ULL, 0x000000302e117223ULL, 0x080fe20000010011ULL,
0x30000049ff497230ULL, 0x000fe20000004100ULL, 0x00000030451c7223ULL, 0x080fe2000001001cULL,
0x3000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000003047187223ULL, 0x080fe20000010018ULL,
0x3000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000003049147223ULL, 0x000fc40000010014ULL,
0x000000303f107223ULL, 0x080fe40000010010ULL, 0x000000302f0d7223ULL, 0x080fe4000001000dULL,
0x000000304b0b7223ULL, 0x000fe2000001000bULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fc600078ec0ffULL,
0x0000008006027824ULL, 0x000fc800078e0203ULL, 0x0000000107037824ULL, 0x000fca00078e0202ULL,
0x0049802c03007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0049800004027984ULL, 0x000ee80000000800ULL,
0x004a000004037984ULL, 0x002e620000000800ULL, 0x00000002ff027221ULL, 0x008fc80000010000ULL,
0x0000000302027221ULL, 0x002fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e0002ULL, 0x0000b63000077802ULL, 0x000fe40000000f00ULL,
0x000060f000007944ULL, 0x004fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803317811ULL, 0x002fe400078ff0ffULL,
0x00000002ff2f7819ULL, 0x000fe40000011603ULL, 0x00000031ff2d7212ULL, 0x000fe200078e33ffULL,
0x00001f3104087589ULL, 0x000e6200000e0000ULL, 0x00000008310a7824ULL, 0x004fc400078e00ffULL,
0x000000082f337824ULL, 0x000fe200078e00ffULL, 0x00001f2f04027589ULL, 0x0004e200000e0000ULL,
0x0000000831307824ULL, 0x000fe200078e00ffULL, 0xfffffff80a2d7812ULL, 0x000fe200078ee22dULL,
0x000000082f0a7824ULL, 0x000fc800078e00ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0200ULL,
0xfffffff80a077812ULL, 0x000fe400078ee22fULL, 0x0000002fff047212ULL, 0x004fc600078e33ffULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0xfffffff833337812ULL, 0x000fe400078ee204ULL,
0x000000072f047812ULL, 0x000fe200078ec0ffULL, 0x0000002508257220ULL, 0x002fc60000410000ULL,
0x00000001040a7812ULL, 0x000fe200078e3cffULL, 0x0000002408247220ULL, 0x000fe20000410000ULL,
0x00000002040c7812ULL, 0x000fe200078e3cffULL, 0x0000002302237220ULL, 0x008fe20000410000ULL,
0x00000004042c7812ULL, 0x000fe200078e3cffULL, 0x0000002202227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002b022b7220ULL, 0x000fe20000410000ULL,
0x00000005042e7812ULL, 0x000fe200078e3cffULL, 0x0000002a022a7220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000002702277220ULL, 0x040fe20000410000ULL,
0x0000000731237812ULL, 0x000fe200078ec0ffULL, 0x0000002602267220ULL, 0x000fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x0000001f021f7220ULL, 0x000fc40000410000ULL,
0x0000001e021e7220ULL, 0x000fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000001b021b7220ULL, 0x040fe40000410000ULL, 0x0000001a021a7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001702177220ULL, 0x040fe40000410000ULL,
0x0000001602167220ULL, 0x000fe20000410000ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000001302137220ULL, 0x000fc40000410000ULL, 0x0000001202127220ULL, 0x000fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000000f020f7220ULL, 0x000fe20000410000ULL,
0xfffffff830177812ULL, 0x000fe200078ee231ULL, 0x0000002908297220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000002808287220ULL, 0x040fe40000410000ULL,
0x0000002108217220ULL, 0x040fe40000410000ULL, 0x0000002008207220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000001d081d7220ULL, 0x000fc40000410000ULL,
0x0000001c081c7220ULL, 0x000fe20000410000ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000001908197220ULL, 0x040fe20000410000ULL, 0x0000000523217812ULL, 0x000fe200078e3cffULL,
0x0000001808187220ULL, 0x000fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001508157220ULL, 0x040fe40000410000ULL, 0x0000001408147220ULL, 0x000fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000001108117220ULL, 0x000fc40000410000ULL,
0x0000001008107220ULL, 0x000fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000000d080d7220ULL, 0x000fe40000410000ULL, 0x0000000e02027220ULL, 0x000fe20000410000ULL,
0x00000003040e7812ULL, 0x000fe200078e3cffULL, 0x0000000b08087220ULL, 0x000fe20000410000ULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x0000000403257824ULL, 0x000fe200078e00ffULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x000000082f0b7824ULL, 0x040fe200078e020aULL,
0x0000000d0808723eULL, 0x000fe200000000ffULL, 0x000000082f0d7824ULL, 0x040fe200078e020cULL,
0x0000000f0202723eULL, 0x000fe200000000ffULL, 0x000000082f117824ULL, 0x000fe200078e022cULL,
0x0000000c252c7812ULL, 0x000fe200078ec0ffULL, 0x000000082f0f7824ULL, 0x000fe200078e020eULL,
0x00000002230a7812ULL, 0x000fe200078e3cffULL, 0x000000082f157824ULL, 0x000fe200078e0204ULL,
0x0000000123047812ULL, 0x000fe200078e3cffULL, 0x000000082f137824ULL, 0x000fe200078e022eULL,
0x00000003230c7812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0x00000004230e7812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000000623237812ULL, 0x000fe200078e3cffULL, 0x000000100f0f7824ULL, 0x000fc400078e0200ULL,
0x000000012c077824ULL, 0x040fe400078e0207ULL, 0x0000001011117824ULL, 0x000fe400078e0200ULL,
0x0000000831197824ULL, 0x000fe200078e0204ULL, 0x0000002a07007388ULL, 0x0003e20000000800ULL,
0x0000001013137824ULL, 0x000fe400078e0200ULL, 0x000000012c0b7824ULL, 0x000fe400078e020bULL,
0x00000008311b7824ULL, 0x000fc400078e020aULL, 0x0000001015157824ULL, 0x000fe200078e0200ULL,
0x000000260b007388ULL, 0x000fe20000000800ULL, 0x000000012c0d7824ULL, 0x040fe400078e020dULL,
0x00000008311d7824ULL, 0x000fe400078e020cULL, 0x0000001033047824ULL, 0x000fe200078e0200ULL,
0x000000220d007388ULL, 0x000fe20000000800ULL, 0x000000012c0f7824ULL, 0x000fe400078e020fULL,
0x00000008311f7824ULL, 0x000fc400078e020eULL, 0x00000010170a7824ULL, 0x100fe200078e0200ULL,
0x0000001e0f007388ULL, 0x000fe20000000800ULL, 0x000000012c117824ULL, 0x040fe400078e0211ULL,
0x0000000831217824ULL, 0x000fe400078e0221ULL, 0x00000010190c7824ULL, 0x000fe200078e0200ULL,
0x0000001a11007388ULL, 0x000fe20000000800ULL, 0x000000012c137824ULL, 0x000fe400078e0213ULL,
0x0000000831237824ULL, 0x000fc400078e0223ULL, 0x000000101b0e7824ULL, 0x100fe200078e0200ULL,
0x0000001613007388ULL, 0x000fe20000000800ULL, 0x000000012c157824ULL, 0x040fe400078e0215ULL,
0x000000101d1d7824ULL, 0x000fe400078e0200ULL, 0x000000012c177824ULL, 0x040fe200078e0204ULL,
0x0000001215007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x000fe400078e0200ULL,
0x000000012c197824ULL, 0x000fe200078e020aULL, 0x0000000217007388ULL, 0x000fe20000000800ULL,
0x0000001021217824ULL, 0x000fc400078e0200ULL, 0x000000012c1b7824ULL, 0x040fe200078e020cULL,
0x0000002819007388ULL, 0x000fe20000000800ULL, 0x0000001023237824ULL, 0x000fe400078e0200ULL,
0x000000012c077824ULL, 0x042fe200078e020eULL, 0x000000241b007388ULL, 0x000fe20000000800ULL,
0x000000012c1d7824ULL, 0x040fe400078e021dULL, 0x000000012c1f7824ULL, 0x040fe200078e021fULL,
0x0000002007007388ULL, 0x000fe20000000800ULL, 0x000000012c217824ULL, 0x000fc400078e0221ULL,
0x000000012c237824ULL, 0x040fe200078e0223ULL, 0x0000001c1d007388ULL, 0x000fe20000000800ULL,
0x000000012c2d7824ULL, 0x000fe400078e022dULL, 0x0000002006007824ULL, 0x000fe200078e0203ULL,
0x000000181f007388ULL, 0x000fe60000000800ULL, 0x0000001000007824ULL, 0x000fe200078e0205ULL,
0x0000001421007388ULL, 0x000fe80000000800ULL, 0x0000001023007388ULL, 0x000fe80000000800ULL,
0x000000082d007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000000c7984ULL, 0x000e680000000c00ULL, 0x0004000000287984ULL, 0x000ea80000000c00ULL,
0x0008000000247984ULL, 0x000ee80000000c00ULL, 0x000c000000307984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x004fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fc40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x000000270f0f7230ULL, 0x008fe40000000000ULL, 0x000000260e0e7230ULL, 0x000fe40000000000ULL,
0x000000250d0d7230ULL, 0x000fe40000000000ULL, 0x000000240c0c7230ULL, 0x000fe40000000000ULL,
0x000000332b2b7230ULL, 0x010fc40000000000ULL, 0x000000322a2a7230ULL, 0x000fe20000000000ULL,
0x0000000c00007388ULL, 0x0003e20000000c00ULL, 0x0000003129297230ULL, 0x000fe40000000000ULL,
0x0000003028287230ULL, 0x000fca0000000000ULL, 0x0004002800007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000020030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x00000003ff087819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x00000003ff047819ULL, 0x000fe2000001160bULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000708007812ULL, 0x002fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704027812ULL, 0x000fe200078e480bULL,
0x00000008090a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fc400078ef803ULL,
0x0ffffff802027812ULL, 0x000fc600078ef80bULL, 0x0000001000007824ULL, 0x100fe400078e0205ULL,
0x0000001002057824ULL, 0x000fc600078e0205ULL, 0x00000000000c7984ULL, 0x0042a80000000c00ULL,
0x0000000005107984ULL, 0x000aa20000000c00ULL, 0x0000000806077824ULL, 0x048fe400078e00ffULL,
0x0000000806157824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000809007824ULL, 0x002fe200078e00ffULL, 0xfffffff807027812ULL, 0x000fc400078ee208ULL,
0xfffffff815047812ULL, 0x000fe400078ee204ULL, 0x0000000402087c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x020fe200000e06ffULL, 0x00005a0008047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fc400078240ffULL,
0x00005b0008057a11ULL, 0x000fe400000f4405ULL, 0x00005b0002077a11ULL, 0x000fe400008f4407ULL,
0xfffffff80a097812ULL, 0x000fe200078ee20bULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001009047825ULL, 0x000fe200078e0006ULL, 0x0000000c02007986ULL, 0x004fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff327624ULL, 0x000fe400078e00ffULL, 0x00006700ff337624ULL, 0x000fca00078e00ffULL,
0x0000000632327981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000146067810ULL, 0x000fe20007ffe0ffULL, 0x0000000212077824ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x000ea2000c80043fULL, 0x0000004044317824ULL, 0x000fe200078e00ffULL,
0x000000030600720cULL, 0x000fe20003f06070ULL, 0x0000580007307a24ULL, 0x000fe400078e0230ULL,
0x0000010046137824ULL, 0x000fc800078e0231ULL, 0x00006200301f7a24ULL, 0x000fcc00078e0213ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff187819ULL, 0x000fe20000011600ULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x000000300e1d7812ULL, 0x000fe400078ec0ffULL,
0x0000000818107810ULL, 0x040fe20007ffe0ffULL, 0x0000000118067824ULL, 0x140fe200078e021fULL,
0x00000018181c7810ULL, 0x040fe40007ffe0ffULL, 0x00000010181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110087824ULL, 0x000fe200078e021fULL, 0x0000002018147810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x00000013020a7217ULL, 0x000fc40007800000ULL,
0x00000003ff157819ULL, 0x100fe20000011600ULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x0000001d060e7210ULL, 0x080fe40007f1e0ffULL, 0x0000000315157812ULL, 0x000fe200078e4800ULL,
0x000000011c0c7824ULL, 0x100fe200078e021fULL, 0x0000001d08087210ULL, 0x000fe20007f3e0ffULL,
0x000000011a0b7824ULL, 0x000fe200078e021fULL, 0x0000100044177811ULL, 0x000fe200078e68ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x0000002818167810ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc15007812ULL, 0x000fe200078ef800ULL, 0x000000011f067824ULL, 0x000fe400078e0214ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001d0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010a137824ULL, 0x000fe400078e0a13ULL, 0x00005e000b0a7625ULL, 0x000fc600078e0021ULL,
0x000000131a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x0000001d0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x000000131c00720cULL, 0x080fe40003f86070ULL, 0x000000131400720cULL, 0x080fe20003f66070ULL,
0x0000000410127824ULL, 0x040fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000131000720cULL, 0x000fe20003f26070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000001d06107210ULL, 0x000fe20007f5e0ffULL, 0x0000001000197824ULL, 0x000fe200078e0217ULL,
0xfffffffc12067812ULL, 0x000fe200078ee215ULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x000000131800720cULL, 0x0c0fe20003f06070ULL, 0x000000ffff117224ULL, 0x000fe200010e0607ULL,
0x0000003018007810ULL, 0x000fe20007ffe0ffULL, 0x00000010061b7824ULL, 0x000fe200078e0217ULL,
0x0000003818187810ULL, 0x000fe20007ffe0ffULL, 0x000000011f067824ULL, 0x000fe200078e0216ULL,
0x000000131600720cULL, 0x000fe20003f46070ULL, 0x0000000414147824ULL, 0x000fc400078e00ffULL,
0x00005e0006067625ULL, 0x000fc600078e0021ULL, 0xfffffffc14147812ULL, 0x000fe200078ee215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e197faeULL, 0x0007e2000c101c46ULL,
0x0000001d06127210ULL, 0x000fe20007fde0ffULL, 0x000000011f067824ULL, 0x000fe200078e0200ULL,
0x000000131800720cULL, 0x080fe20003f06070ULL, 0x00000000081b7faeULL, 0x0009e2000c901c46ULL,
0x000000130000720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe400030e0607ULL,
0x00005e0006067625ULL, 0x000fc800078e0021ULL, 0x000000041c0e7824ULL, 0x008fe200078e00ffULL,
0x0000001d06067210ULL, 0x000fe20007fde0ffULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x000000011f087824ULL, 0x010fe200078e0218ULL, 0xfffffffc0e0e7812ULL, 0x100fe200078ee215ULL,
0x00000004001c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a007812ULL, 0x100fe200078ee215ULL,
0x00000004181e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x100fe200078ee215ULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0xfffffffc1c187812ULL, 0x000fc400078ee215ULL,
0xfffffffc1e1a7812ULL, 0x000fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001d08087210ULL, 0x000fe20007fde0ffULL, 0x00000010000f7824ULL, 0x100fe400078e0217ULL,
0x000000100e157824ULL, 0x100fe400078e0217ULL, 0x0000001014197824ULL, 0x100fe200078e0217ULL,
0x000000000a0f7faeULL, 0x0007e2000e901c46ULL, 0x00000010161b7824ULL, 0x100fe400078e0217ULL,
0x00000010181d7824ULL, 0x100fe200078e0217ULL, 0x000000000c157faeULL, 0x0007e2000e101c46ULL,
0x000000101a177824ULL, 0x000fc400078e0217ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000010197faeULL, 0x0007e8000d901c46ULL, 0x00000000121b7faeULL, 0x0007e8000d101c46ULL,
0x00000000061d7faeULL, 0x0007e8000c901c46ULL, 0x0000000008177faeULL, 0x0007e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff257424ULL, 0x000fe200078e00ffULL, 0x0000001000077811ULL, 0x000fc400078ff0ffULL,
0x0000001f00067211ULL, 0x000fe400078ff0ffULL, 0x000000300e277812ULL, 0x000fe200078ec0ffULL,
0x00000004071c7824ULL, 0x000fe200078e00ffULL, 0x0000000309157812ULL, 0x000fe200078e4800ULL,
0x000000011f097824ULL, 0x040fe200078e0207ULL, 0x00000008000e7811ULL, 0x000fe200078ff0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x0000003800107811ULL, 0x040fe400078ff0ffULL,
0x00000028000d7811ULL, 0x000fe200078ff0ffULL, 0x000000040e127824ULL, 0x000fe200078e00ffULL,
0x00000018000a7811ULL, 0x040fe200078ff0ffULL, 0x000000011f1a7824ULL, 0x000fe200078e0210ULL,
0x00000030000f7811ULL, 0x000fe200078ff0ffULL, 0x0000000410247824ULL, 0x000fe200078e00ffULL,
0x0000002706107210ULL, 0x000fe20007f1e0ffULL, 0x000000040d207824ULL, 0x000fe200078e00ffULL,
0x00000020000c7811ULL, 0x000fe200078ff0ffULL, 0x000000010e087824ULL, 0x000fe200078e021fULL,
0x0ffffffc15147812ULL, 0x000fe200078ef800ULL, 0x000000011f0b7824ULL, 0x000fe200078e020aULL,
0xfffffffc12007812ULL, 0x100fe200078ee215ULL, 0x000000040f227824ULL, 0x000fe200078e00ffULL,
0xfffffffc20127812ULL, 0x000fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0x0000100044237811ULL, 0x000fe200078e68ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc22137812ULL, 0x000fe200078ee215ULL, 0x000000040c1e7824ULL, 0x000fc400078e00ffULL,
0x00005e0008067625ULL, 0x000fc800078e0025ULL, 0x00005e0009087625ULL, 0x000fc800078e0025ULL,
0x000000011f0e7824ULL, 0x040fe200078e020cULL, 0xfffffffc1c0c7812ULL, 0x000fe200078ee215ULL,
0x000000011f167824ULL, 0x040fe200078e020dULL, 0xfffffffc0a0d7812ULL, 0x000fe200078ee215ULL,
0x000000011f187824ULL, 0x000fe200078e020fULL, 0xfffffffc1e0f7812ULL, 0x000fe200078ee215ULL,
0x00000010121f7824ULL, 0x000fe200078e0223ULL, 0x0000002706127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0025ULL, 0xfffffffc24157812ULL, 0x000fc600078ee215ULL,
0x0000001014297824ULL, 0x100fe200078e0223ULL, 0x0000002708147210ULL, 0x000fe20007f3e0ffULL,
0x0000001013217824ULL, 0x100fe400078e0223ULL, 0x0000001000177824ULL, 0x100fe200078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0007e2000b901c46ULL,
0x000000100c197824ULL, 0x100fe400078e0223ULL, 0x000000100d1b7824ULL, 0x100fe400078e0223ULL,
0x000000100f1d7824ULL, 0x000fc400078e0223ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015237824ULL, 0x000fe400078e0223ULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000000012177faeULL, 0x0007e2000b901c46ULL,
0x00005e000e067625ULL, 0x000fc600078e0025ULL, 0x0000000014197faeULL, 0x0007e2000b901c46ULL,
0x00005e0016087625ULL, 0x000fc800078e0025ULL, 0x00005e00180c7625ULL, 0x000fe200078e0025ULL,
0x0000002708087210ULL, 0x000fc60007f3e0ffULL, 0x00005e001a0e7625ULL, 0x000fe200078e0025ULL,
0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002706067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000270e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000000a1b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x00000000061d7faeULL, 0x0007e8000b901c46ULL,
0x00000000081f7faeULL, 0x0007e8000b901c46ULL, 0x000000000c217faeULL, 0x0007e8000b901c46ULL,
0x000000000e237faeULL, 0x0007e4000b901c46ULL, 0x00f60400ff077984ULL, 0x008ee80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x00cfc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000060000735dULL, 0x008fe20003800000ULL, 0x00f60400ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x0000002044007824ULL, 0x004fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000ea8000000cc00ULL,
0x0000000007087984ULL, 0x000ee2000000cc00ULL, 0x000000ffff107224ULL, 0x004fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x008fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0005e8000000cc00ULL,
0x0000000c07007388ULL, 0x0005e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x004fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000060000735dULL, 0x008fe20003800000ULL,
0x00f60400ff077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000034600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x3db504f332327820ULL, 0x020fe20000410000ULL, 0x0000f68844337811ULL, 0x042fe200078e18ffULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0xffffffff03357810ULL, 0x000fe40007ffe0ffULL,
0x0000f60844347811ULL, 0x000fe400078e28ffULL, 0x0000010046397824ULL, 0x000fe200078e0231ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000390200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0037ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x00000001361e7810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000011d377812ULL, 0x000fc400078e0cffULL,
0x00000001ff1f7819ULL, 0x000fe4000001161eULL, 0x000000021e00780cULL, 0x000fc60003f06070ULL,
0x000003001f1c7a24ULL, 0x000fe200078e0246ULL, 0x000000011e1f7812ULL, 0x000fc600078ec0ffULL,
0x000001001c297824ULL, 0x040fe200078e0231ULL, 0x000000011c287810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe400078e0036ULL, 0x000000ffff367224ULL, 0x000fe200078e001eULL,
0x000000032800720cULL, 0x000fe20003f26070ULL, 0x00006200302f7a24ULL, 0x000fd800078e0229ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x000000041f3d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff1f7819ULL, 0x104fe20000011600ULL, 0x0000000244387824ULL, 0x000fe200078e0237ULL,
0x00000029021e7217ULL, 0x000fe20007800000ULL, 0x00000080ff3b7424ULL, 0x000fe200078e00ffULL,
0x00000002ff2c7819ULL, 0x100fe40000011600ULL, 0x000000031f3f7812ULL, 0x100fe200078e4800ULL,
0x000000011e2a7824ULL, 0x000fe200078e0a29ULL, 0x000000082c1f7810ULL, 0x040fe20007ffe0ffULL,
0x000000012c1e7824ULL, 0x000fe200078e022fULL, 0xfffffffc3d3d7812ULL, 0x000fc400078ee200ULL,
0x0000002a2c00720cULL, 0x080fe20003f26070ULL, 0x000000011f287824ULL, 0x040fe200078e022fULL,
0x0000002a1f00720cULL, 0x040fe20003f46070ULL, 0x000000041f2e7824ULL, 0x000fe200078e00ffULL,
0x0000100038387811ULL, 0x000fe200078e60ffULL, 0x00005e001e1e7625ULL, 0x080fe200078e003bULL,
0x0ffffffc3f2b7812ULL, 0x000fe400078ef800ULL, 0xfffffffc2e2d7812ULL, 0x000fe200078ee23fULL,
0x00005e0028287625ULL, 0x000fe200078e003bULL, 0x000000102c2e7810ULL, 0x000fc40007ffe0ffULL,
0x000000182c3a7810ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0238ULL,
0x000000202c3c7810ULL, 0x040fe20007ffe0ffULL, 0x000000103d1e7825ULL, 0x000fe200078e001eULL,
0x000000282c3e7810ULL, 0x040fe40007ffe0ffULL, 0x000000302c407810ULL, 0x040fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0238ULL, 0x000000382c417810ULL, 0x000fe20007ffe0ffULL,
0x000000103d287825ULL, 0x000fe200078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e2b7faeULL, 0x0003e2000c901c46ULL, 0x0000002a2e00720cULL, 0x000fc40003f26070ULL,
0x0000002a3c00720cULL, 0x080fe20003f66070ULL, 0x00000000282d7faeULL, 0x0005e2000d101c46ULL,
0x0000002a3a00720cULL, 0x080fe20003f46070ULL, 0x000000042e427824ULL, 0x000fe200078e00ffULL,
0x0000002a3e00720cULL, 0x080fe20003f86070ULL, 0x000000043a487824ULL, 0x000fe200078e00ffULL,
0x0000002a4000720cULL, 0x080fe20003fa6070ULL, 0x000000013e2c7824ULL, 0x100fe200078e022fULL,
0x0000002a4100720cULL, 0x000fe20003fc6070ULL, 0x000000012e1e7824ULL, 0x002fe200078e022fULL,
0xfffffffc48437812ULL, 0x000fe200078ee23fULL, 0x000000013c2a7824ULL, 0x000fc400078e022fULL,
0x000000013a287824ULL, 0x104fe400078e022fULL, 0x00000001402e7824ULL, 0x100fe400078e022fULL,
0x00000001413a7824ULL, 0x000fe400078e022fULL, 0x000000043c3c7824ULL, 0x000fe400078e00ffULL,
0x00005e001e1e7625ULL, 0x000fc600078e003bULL, 0xfffffffc3c457812ULL, 0x000fe200078ee23fULL,
0x00005e0028287625ULL, 0x000fc800078e003bULL, 0x00005e002a2a7625ULL, 0x000fc800078e003bULL,
0x00005e002c2c7625ULL, 0x000fc800078e003bULL, 0x00005e002e2e7625ULL, 0x000fc800078e003bULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x00005e003a3a7625ULL, 0x000fc600078e003bULL,
0xfffffffc3e477812ULL, 0x100fe200078ee23fULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x00000004414a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc42417812ULL, 0x000fe200078ee23fULL,
0x000000103d1e7825ULL, 0x040fe200078e001eULL, 0xfffffffc40497812ULL, 0x100fe400078ee23fULL,
0xfffffffc4a4b7812ULL, 0x000fe200078ee23fULL, 0x000000103d287825ULL, 0x000fc800078e0028ULL,
0x000000103d2a7825ULL, 0x000fc800078e002aULL, 0x000000103d2c7825ULL, 0x000fc800078e002cULL,
0x000000103d2e7825ULL, 0x000fc800078e002eULL, 0x000000103d3a7825ULL, 0x000fc800078e003aULL,
0x00000010413d7824ULL, 0x100fe400078e0238ULL, 0x00000010433f7824ULL, 0x100fe400078e0238ULL,
0x0000001045417824ULL, 0x100fe200078e0238ULL, 0x000000001e3d7faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e0238ULL, 0x0000001049457824ULL, 0x100fe200078e0238ULL,
0x00000000283f7faeULL, 0x0003e2000d101c46ULL, 0x000000104b477824ULL, 0x000fc600078e0238ULL,
0x000000002a417faeULL, 0x0003e8000d901c46ULL, 0x000000002c437faeULL, 0x0003e8000e101c46ULL,
0x000000002e457faeULL, 0x0003e8000e901c46ULL, 0x000000003a477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000244287824ULL, 0x000fe200078e0237ULL,
0x00000008002a7811ULL, 0x044fe200078ff0ffULL, 0x000000041f417824ULL, 0x000fe200078e00ffULL,
0x00000010002c7811ULL, 0x040fe200078ff0ffULL, 0x00000080ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000018002e7811ULL, 0x000fe200078ff0ffULL, 0x000000042a427824ULL, 0x000fe200078e00ffULL,
0x00000003ff1f7819ULL, 0x000fe20000011600ULL, 0x000000042c487824ULL, 0x000fe200078e00ffULL,
0x0000002000387811ULL, 0x000fe200078ff0ffULL, 0x000000042e4a7824ULL, 0x000fe200078e00ffULL,
0x00000028003c7811ULL, 0x000fc400078ff0ffULL, 0x00000030003e7811ULL, 0x000fe400078ff0ffULL,
0x00001000284d7811ULL, 0x000fe200078e60ffULL, 0x000000012a287824ULL, 0x100fe200078e022fULL,
0x0000003800407811ULL, 0x000fe200078ff0ffULL, 0x000000012c2a7824ULL, 0x100fe200078e022fULL,
0x000000031f297812ULL, 0x100fe200078e4800ULL, 0x000000012e2c7824ULL, 0x100fe200078e022fULL,
0x0000002f001e7211ULL, 0x000fe200078ff0ffULL, 0x00000001382e7824ULL, 0x100fe200078e022fULL,
0xfffffffc41417812ULL, 0x000fe200078ee200ULL, 0x000000013c3a7824ULL, 0x000fc400078e022fULL,
0x000000043c4c7824ULL, 0x000fe400078e00ffULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x000000013e3c7824ULL, 0x000fe200078e022fULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee229ULL,
0x000000043e4e7824ULL, 0x000fe400078e00ffULL, 0x00000001403e7824ULL, 0x040fe400078e022fULL,
0x0000000440507824ULL, 0x000fe200078e00ffULL, 0xfffffffc42407812ULL, 0x100fe200078ee229ULL,
0x00005e001e1e7625ULL, 0x000fe200078e003fULL, 0xfffffffc48427812ULL, 0x000fc400078ee229ULL,
0xfffffffc4a487812ULL, 0x100fe200078ee229ULL, 0x00005e002a2a7625ULL, 0x080fe200078e003fULL,
0xfffffffc384a7812ULL, 0x100fe400078ee229ULL, 0xfffffffc4e4e7812ULL, 0x100fe200078ee229ULL,
0x00005e002c2c7625ULL, 0x080fe200078e003fULL, 0xfffffffc50507812ULL, 0x000fe400078ee229ULL,
0x0ffffffc29387812ULL, 0x000fe200078ef800ULL, 0x00005e0028287625ULL, 0x000fc800078e003fULL,
0x00005e002e2e7625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x00000010411e7825ULL, 0x000fc800078e001eULL, 0x0000001041287825ULL, 0x000fc800078e0028ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x00000010412c7825ULL, 0x000fc800078e002cULL,
0x00000010412e7825ULL, 0x000fc800078e002eULL, 0x00000010413a7825ULL, 0x000fc800078e003aULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x00000010413e7825ULL, 0x000fc800078e003eULL,
0x00000010384f7824ULL, 0x100fe400078e024dULL, 0x0000001040417824ULL, 0x100fe400078e024dULL,
0x0000001042437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e4f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x0000000028417faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x000000002a437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000002c457faeULL, 0x0003e8000b901c46ULL, 0x000000002e477faeULL, 0x0003e8000b901c46ULL,
0x000000003a497faeULL, 0x0003e8000b901c46ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020001f7810ULL, 0x002fe20007ffe0ffULL,
0x00000002443c7824ULL, 0x000fe200078e021dULL, 0xfffffff8001d7812ULL, 0x000fe200078ec0ffULL,
0x000000081c3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000000071d3e7812ULL, 0x000fc400078ef800ULL,
0x000000071f407812ULL, 0x000fe400078ef800ULL, 0x0000000700297812ULL, 0x000fe400078ec0ffULL,
0x00000001ff3b7819ULL, 0x000fe4000001163eULL, 0x00000001ff3d7819ULL, 0x000fe40000011640ULL,
0x000010003c3c7811ULL, 0x000fe400078e60ffULL, 0x00000008293a7812ULL, 0x000fc400078ef800ULL,
0x000000033b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000033d3d7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000383b1d7212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000383d297212ULL, 0x000fe400078e3cffULL,
0x0000003f00757211ULL, 0x000fe200078fe0ffULL, 0x000000043e1d7824ULL, 0x000fe200078e021dULL,
0x000000043f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000440297824ULL, 0x000fc400078e0229ULL,
0x000000101d1d7824ULL, 0x100fe400078e023cULL, 0x0000001029297824ULL, 0x000fc800078e023cULL,
0x000000001d1c783bULL, 0x000e680000000200ULL, 0x000000002928783bULL, 0x000ea20000000200ULL,
0x00000018ff667819ULL, 0x002fe2000001141cULL, 0x000100001c2c7824ULL, 0x040fe200078e00ffULL,
0x000088801c6d7816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe2000001141dULL, 0x000100001d2d7824ULL, 0x040fe200078e00ffULL,
0x000088801d6e7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff617819ULL, 0x000fc4000001141eULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x000088801e6b7816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe2000001141fULL,
0x0000001c00737306ULL, 0x0003e20000200c00ULL, 0x000088801f697816ULL, 0x000fe400000000ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff557819ULL, 0x004fe20000011428ULL, 0x0000001d00787306ULL, 0x0005e20000200c00ULL,
0x000100001e1c7824ULL, 0x002fe200078e00ffULL, 0x0000888028657816ULL, 0x000fe200000000ffULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011429ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000100001f1d7824ULL, 0x044fe200078e00ffULL, 0x0000002c00767306ULL, 0x000fe20000200c00ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888029647816ULL, 0x000fc400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001e00747306ULL, 0x0003e20000200c00ULL, 0x00000018ff4d7819ULL, 0x000fe4000001142aULL,
0x000088802a5f7816ULL, 0x000fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe4000001142bULL,
0x000088802b597816ULL, 0x000fe200000000ffULL, 0x0000001d00707306ULL, 0x0005e20000200c00ULL,
0x00000001381e7810ULL, 0x002fc40007ffe0ffULL, 0x0000000238387810ULL, 0x000fe40007ffe0ffULL,
0x0000001e3d437212ULL, 0x080fe400078e3cffULL, 0x000000043800780cULL, 0x000fe20003f25270ULL,
0x0000001f006f7306ULL, 0x0003e20000200c00ULL, 0x0000001e3b1d7212ULL, 0x004fe200078e3cffULL,
0x0000000440437824ULL, 0x000fc800078e0243ULL, 0x00000010431e7824ULL, 0x100fe400078e023cULL,
0x0000002d00717306ULL, 0x0005e20000200c00ULL, 0x000000043e1f7824ULL, 0x002fe400078e021dULL,
0x00010000291d7824ULL, 0x000fe400078e00ffULL, 0x000000101f1f7824ULL, 0x000fe400078e023cULL,
0x0000010029297824ULL, 0x000fe200078e00ffULL, 0x0000001c00727306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000001f2c783bULL, 0x004ea40000000200ULL,
0x00000018ff297819ULL, 0x000fc80000011429ULL, 0x0000002900687306ULL, 0x0007e20000200c00ULL,
0x00010000281c7824ULL, 0x042fe400078e00ffULL, 0x0000010028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000001d00677306ULL, 0x000fe20000200c00ULL, 0x0000000775297812ULL, 0x048fe400078e783aULL,
0x0000000275757810ULL, 0x000fc60007ffe0ffULL, 0x000000103a297824ULL, 0x040fe200078e0229ULL,
0x0000000775757812ULL, 0x000fe200078e783aULL, 0x00000028006c7306ULL, 0x0003e40000200c00ULL,
0x0000001029297824ULL, 0x000fe400078e00ffULL, 0x000000103a757824ULL, 0x000fc800078e0275ULL,
0x0000001c006a7306ULL, 0x0007e20000200c00ULL, 0x000100002b287824ULL, 0x042fe400078e00ffULL,
0x000001002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a1c7824ULL, 0x048fe200078e00ffULL,
0x00000028005a7306ULL, 0x0003e20000200c00ULL, 0x000001002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x004fe4000001142cULL, 0x00000018ff4b7819ULL, 0x000fe4000001142dULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x0000002b005c7306ULL, 0x000fe20000200c00ULL,
0x000100002c287824ULL, 0x042fe200078e00ffULL, 0x000088802c437816ULL, 0x040fe200000000ffULL,
0x000001002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802d4e7816ULL, 0x000fe400000000ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002a00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff607819ULL, 0x000fe4000001141cULL, 0x000000001e1c783bULL, 0x000ea20000000200ULL,
0x00000018ff2c7819ULL, 0x000fc4000001142cULL, 0x00000018ff4a7819ULL, 0x000fe4000001142eULL,
0x0000002800507306ULL, 0x0007e20000200c00ULL, 0x000100002d2a7824ULL, 0x042fe200078e00ffULL,
0x000088802e517816ULL, 0x000fe200000000ffULL, 0x000001002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe4000001142fULL, 0x00000018ff537819ULL, 0x000fe4000001142aULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x000000002928783bULL, 0x008ee20000000200ULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x000088802f567816ULL, 0x000fc800000000ffULL,
0x0000002c004f7306ULL, 0x0009f00000200c00ULL, 0x0000002d00527306ULL, 0x000be20000200c00ULL,
0x000100002e2c7824ULL, 0x050fe400078e00ffULL, 0x000001002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000100002f2d7824ULL, 0x060fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x004fe4000001141fULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fc4000001142fULL, 0x00000018ff487819ULL, 0x000fe4000001141cULL,
0x00000018ff477819ULL, 0x000fe4000001141dULL, 0x00000018ff457819ULL, 0x000fe2000001141eULL,
0x0000002c00587306ULL, 0x0003f00000200c00ULL, 0x0000002d005d7306ULL, 0x0009e20000200c00ULL,
0x000054106d2c7816ULL, 0x002fce0000000076ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00005410732d7816ULL, 0x010fe20000000066ULL, 0x000100001c667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x0000002c2824723cULL, 0x008fee0000001824ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054106e2c7816ULL, 0x004fc40000000071ULL, 0x00005410782d7816ULL, 0x000fca0000000063ULL,
0x0000006900697306ULL, 0x000ea40000200c00ULL, 0x0000002c2820723cULL, 0x000fec0000001820ULL,
0x0000002e00577306ULL, 0x0007e20000200c00ULL, 0x000054106b2c7816ULL, 0x002fe40000000072ULL,
0x00005410742d7816ULL, 0x000fca0000000061ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000088801c2e7816ULL, 0x008fe200000000ffULL, 0x0000002c2818723cULL, 0x000fec0000001818ULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x00005410692c7816ULL, 0x004fe20000000070ULL,
0x000100001d697824ULL, 0x000fe200078e00ffULL, 0x000054106f2d7816ULL, 0x000fc80000000054ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000002f005e7306ULL, 0x0005e20000200c00ULL,
0x000054106c557816ULL, 0x002fe20000000055ULL, 0x0000002c2814723cULL, 0x000fec0000001814ULL,
0x0000002e00637306ULL, 0x0003e20000200c00ULL, 0x000001001c2f7824ULL, 0x004fe200078e00ffULL,
0x0000541065547816ULL, 0x008fc8000000006aULL, 0x00000018ff617819ULL, 0x000fe4000001142fULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x00000010752e7824ULL, 0x002fe200078e00ffULL,
0x000000542810723cULL, 0x000fea0000001810ULL, 0x000000002e2c783bULL, 0x000e620000000200ULL,
0x0000006400647306ULL, 0x000ee20000200c00ULL, 0x000001001d547824ULL, 0x000fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000004d004d7306ULL, 0x000f220000200c00ULL,
0x0000541068657816ULL, 0x004fe4000000005bULL, 0x000088801e5b7816ULL, 0x000fca00000000ffULL,
0x0000004100417306ULL, 0x000ea20000200c00ULL, 0x0000541064647816ULL, 0x008fce0000000067ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000064280c723cULL, 0x000fe2000000180cULL,
0x0000541062557816ULL, 0x010fe2000000004dULL, 0x000000ffff4d7224ULL, 0x000fca00078e005bULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054105c5b7816ULL, 0x004fce0000000041ULL,
0x0000005900597306ULL, 0x000eb00000200c00ULL, 0x0000004c004c7306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000ee20000200c00ULL, 0x00005410595a7816ULL, 0x004fce000000005aULL,
0x0000005400647306ULL, 0x0005e20000200c00ULL, 0x0000005a2804723cULL, 0x000fee0000001804ULL,
0x00000066001c7306ULL, 0x0009620000200c00ULL, 0x000054105f547816ULL, 0x004fce0000000060ULL,
0x000000542808723cULL, 0x000fe20000001808ULL, 0x000088801d667816ULL, 0x010fe200000000ffULL,
0x0000004a004a7306ULL, 0x000eaa0000200c00ULL, 0x0000541043287816ULL, 0x008fe20000000050ULL,
0x000001001e2a7824ULL, 0x040fe200078e00ffULL, 0x000054104f297816ULL, 0x000fe2000000004cULL,
0x000100001e557824ULL, 0x000fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x0000541063607816ULL, 0x020fc4000000001cULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x000000282c24723cULL, 0x002fe20000001824ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x0000541057597816ULL, 0x004fc6000000004aULL,
0x000100001f297824ULL, 0x040fe200078e00ffULL, 0x000088801f287816ULL, 0x040fe200000000ffULL,
0x000001001f1f7824ULL, 0x000fe400078e00ffULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00005410524f7816ULL, 0x008fc6000000004bULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x000054105e577816ULL, 0x002fce0000000049ULL, 0x0000002900297306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000eb00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541064677816ULL, 0x004fce0000000047ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000eb00000200c00ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x000054104e4e7816ULL, 0x002fce0000000053ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x0000541051587816ULL, 0x004fe20000000058ULL,
0x0000004e2c20723cULL, 0x040fec0000001820ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x008fe2000000005dULL, 0x000000582c18723cULL, 0x040fec0000001818ULL,
0x00000069001d7306ULL, 0x000ea20000200c00ULL, 0x0000541061617816ULL, 0x002fe20000000048ULL,
0x000000562c14723cULL, 0x040fec0000001814ULL, 0x0000004d004d7306ULL, 0x000fe40000200c00ULL,
0x000000602c10723cULL, 0x000fec0000001810ULL, 0x00000055001e7306ULL, 0x000e620000200c00ULL,
0x0000541066667816ULL, 0x004fce000000001dULL, 0x0000002a002a7306ULL, 0x000ea20000200c00ULL,
0x000000662c0c723cULL, 0x000fee000000180cULL, 0x0000001f002b7306ULL, 0x0004e20000200c00ULL,
0x000054104d1e7816ULL, 0x002fe4000000001eULL, 0x000054102a1f7816ULL, 0x004fc40000000045ULL,
0x000054102b297816ULL, 0x008fca0000000042ULL, 0x0000001e2c08723cULL, 0x040ff00000001808ULL,
0x000000282c04723cULL, 0x000fe20000001804ULL, 0xfffff0f000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0037ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe4f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000331c7f8cULL, 0x000fe2000c80043fULL, 0x00000025322b7220ULL, 0x000fc40000410000ULL,
0x0000002132297220ULL, 0x040fe20000410000ULL, 0x00000400331f7984ULL, 0x000e620000000800ULL,
0x0000001432257220ULL, 0x040fe40000410000ULL, 0x0000000832087220ULL, 0x040fe40000410000ULL,
0x0000001632167220ULL, 0x040fe40000410000ULL, 0x0000001732147220ULL, 0x040fe40000410000ULL,
0x0000000c32217220ULL, 0x000fc40000410000ULL, 0x0000002632287220ULL, 0x040fe40000410000ULL,
0x00000027322c7220ULL, 0x040fe40000410000ULL, 0x00000022322e7220ULL, 0x040fe40000410000ULL,
0x00000023322f7220ULL, 0x040fe40000410000ULL, 0x0000001a32367220ULL, 0x040fe40000410000ULL,
0x0000001b32387220ULL, 0x000fc40000410000ULL, 0x0000000f320f7220ULL, 0x040fe40000410000ULL,
0x0000000b320c7220ULL, 0x040fe40000410000ULL, 0x00000024322d7220ULL, 0x040fe40000410000ULL,
0x0000001132227220ULL, 0x040fe40000410000ULL, 0x0000001532247220ULL, 0x040fe40000410000ULL,
0x0000001032237220ULL, 0x000fc40000410000ULL, 0x0000001332117220ULL, 0x040fe40000410000ULL,
0x00000020322a7220ULL, 0x040fe40000410000ULL, 0x0000001832277220ULL, 0x040fe20000410000ULL,
0x800000001fff7812ULL, 0x002fe2000780481dULL, 0x000000ffff1f7224ULL, 0x000fe400078e0008ULL,
0x0000001932267220ULL, 0x040fe40000410000ULL, 0x0000000e32107220ULL, 0x000fc40000410000ULL,
0x00000009321e7220ULL, 0x040fe40000410000ULL, 0x0000000a32157220ULL, 0x040fe40000410000ULL,
0x000000ffff087224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0014ULL,
0x0000001232127220ULL, 0x040fe40000410000ULL, 0x0000000d32207220ULL, 0x000fc40000410000ULL,
0x00000004321b7220ULL, 0x040fe40000410000ULL, 0x0000000532197220ULL, 0x040fe40000410000ULL,
0x0000000632067220ULL, 0x040fe40000410000ULL, 0x00000007320e7220ULL, 0x000fe40000410000ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0028ULL, 0x000000ffff187224ULL, 0x000fc400078e002cULL,
0x000000ffff177224ULL, 0x000fe400078e002eULL, 0x000000ffff0b7224ULL, 0x000fe400078e002fULL,
0x000000ffff0a7224ULL, 0x000fe400078e0036ULL, 0x000000ffff097224ULL, 0x000fe400078e0038ULL,
0x000000ffff167224ULL, 0x000fe400078e000fULL, 0x000000ffff147224ULL, 0x000fe200078e000cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0006ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0000040033057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004000c7824ULL, 0x000fe200078e00ffULL,
0x000000354600720cULL, 0x000fc80003f05270ULL, 0xfffffff00c0d7812ULL, 0x000fca00078ec0ffULL,
0x00000080440d7824ULL, 0x000fca00078e020dULL, 0x00f400000d047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002001c7824ULL, 0x000fe400078e00ffULL,
0x0000000102397824ULL, 0x000fc600078e0a39ULL, 0x000000061c1c7812ULL, 0x000fc800078ec0ffULL,
0x000000011c287812ULL, 0x040fe400078efcffULL, 0x000000081c2c7812ULL, 0x000fe400078efcffULL,
0x000000392800720cULL, 0x080fe40003f26070ULL, 0x000000101c287812ULL, 0x000fe400078efcffULL,
0x000000392c00720cULL, 0x080fe40003f06070ULL, 0x000000392800720cULL, 0x000fc40003fc6070ULL,
0x000000111c2c7812ULL, 0x040fe400078efcffULL, 0x000000181c287812ULL, 0x040fe400078efcffULL,
0x000000391c00720cULL, 0x080fe40003f46070ULL, 0x000000392c00720cULL, 0x080fe40003fa6070ULL,
0x000000392800720cULL, 0x000fe40003f66070ULL, 0x000000091c2e7812ULL, 0x000fc400078efcffULL,
0x000000191c2c7812ULL, 0x040fe400078efcffULL, 0x000000201c287812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40004800000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40004800000ULL,
0x000000392e00720cULL, 0x080fe40003f86070ULL, 0x000000392c00720cULL, 0x080fe40003f46070ULL,
0x000000392800720cULL, 0x000fe40003f26070ULL, 0x000000211c2c7812ULL, 0x040fe400078efcffULL,
0x000000281c287812ULL, 0x000fe400078efcffULL, 0xff7fffff17177808ULL, 0x000fc40004000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff29297808ULL, 0x000fe40006000000ULL, 0x000000392c00720cULL, 0x080fe40003f06070ULL,
0x000000392800720cULL, 0x000fe40003f86070ULL, 0x000000291c2c7812ULL, 0x000fc400078efcffULL,
0x000000301c287812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff26267808ULL, 0x000fe40006800000ULL, 0x000000392c00720cULL, 0x000fc40003fc6070ULL,
0x000000392800720cULL, 0x000fe40003fa6070ULL, 0x000000311c2c7812ULL, 0x040fe400078efcffULL,
0x000000381c287812ULL, 0x040fe400078efcffULL, 0x000000391c1c7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff25257808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff24247808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0x000000392c00720cULL, 0x080fe40003f66070ULL, 0x000000392800720cULL, 0x000fc40003f46070ULL,
0x000000391c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff22227808ULL, 0x000fe40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40006000000ULL,
0xff7fffff21217808ULL, 0x000fe40006000000ULL, 0xff7fffff16167808ULL, 0x000fc40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40006800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006800000ULL, 0xff7fffff14147808ULL, 0x000fe40005800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000002d04047209ULL, 0x004fe40007810000ULL,
0x0000001a051d7209ULL, 0x000fe40007810000ULL, 0x0000002b04057209ULL, 0x000fe40007810000ULL,
0x000000181d047209ULL, 0x000fc40007810000ULL, 0x0000002a051c7209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x000000291c1c7209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x000000271c1d7209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fc40007810000ULL, 0x000000261d1c7209ULL, 0x000fe40007810000ULL,
0x0000000904057209ULL, 0x000fe40007810000ULL, 0x000000251c1d7209ULL, 0x000fe40007810000ULL,
0x0000000805047209ULL, 0x000fe40007810000ULL, 0x000000241d1c7209ULL, 0x000fe40007810000ULL,
0x0000001304057209ULL, 0x000fc40007810000ULL, 0x000000231c1d7209ULL, 0x000fe40007810000ULL,
0x0000001205047209ULL, 0x000fe40007810000ULL, 0x000000221d1c7209ULL, 0x000fe40007810000ULL,
0x0000001104057209ULL, 0x000fe40007810000ULL, 0x000000211c1d7209ULL, 0x000fe40007810000ULL,
0x0000001005057209ULL, 0x000fc40007810000ULL, 0x000000201d047209ULL, 0x000fe40007810000ULL,
0x00000016051c7209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x000000151c1d7209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x000000141d1c7209ULL, 0x000fc40007810000ULL, 0x0000001b04047209ULL, 0x000fe40007810000ULL,
0x0000000f1c057209ULL, 0x000fe40007810000ULL, 0x00000019042c7209ULL, 0x000fe40007810000ULL,
0x0000000e052e7209ULL, 0x000fe20007810000ULL, 0x000017d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002c047f89ULL, 0x0004e400000e0000ULL, 0x000000042c367209ULL, 0x008fe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f002e047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007287f89ULL, 0x000f6200000e0000ULL,
0x000000042e1c7209ULL, 0x008fc60007810000ULL, 0x0c201f0036047f89ULL, 0x000ee200000e0000ULL,
0x00000005061d7209ULL, 0x010fc60007810000ULL, 0x0c201f001c057f89ULL, 0x000f2200000e0000ULL,
0x0000002807287209ULL, 0x020fc60007810000ULL, 0x0c201f001d2c7f89ULL, 0x006e6800000e0000ULL,
0x0c201f00282f7f89ULL, 0x0004a200000e0000ULL, 0x0000000436047209ULL, 0x008fe40007810000ULL,
0x000000051c057209ULL, 0x010fe40007810000ULL, 0x0000002c1d067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b041c7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b051d7820ULL, 0x000fe20000410000ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fc4000001081cULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081cULL,
0x0000002b002c7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001081cULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081cULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081cULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc4000001081cULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe4000001081cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe4000001081cULL,
0x3fb8aa3b19197823ULL, 0x000fe2000001081cULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b0b1c7823ULL, 0x000fc4000001081dULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081dULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b08387823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b0e0e7823ULL, 0x000fe2000001081dULL, 0x00000018002b7308ULL, 0x000fe20000000800ULL,
0x0000002d2c08723eULL, 0x002fce00000000ffULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000001c001c7308ULL, 0x000e700000000800ULL, 0x0000001b00077308ULL, 0x0007f00000000800ULL,
0x00000019002e7308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b0a1b7823ULL, 0x108fe2000001081dULL,
0x0000002a290a723eULL, 0x000fe200000000ffULL, 0x3c003c00ff2a7424ULL, 0x000fe200078e00ffULL,
0x000000171c0b723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b12177823ULL, 0x000fc4000001081dULL,
0x3fb8aa3b111c7823ULL, 0x100fe2000001081dULL, 0x0000001b00367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b09197823ULL, 0x110fe2000001081dULL, 0x0000001a2b09723eULL, 0x000fe200000000ffULL,
0x3c003c00ff2b7424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b10297823ULL, 0x000fc6000001081dULL,
0x0000001900397308ULL, 0x0002f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000002a0818723cULL, 0x002fee00000018ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000363911723eULL, 0x008fce00000000ffULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ee20000000800ULL, 0x000000272610723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b14267823ULL, 0x000fcc000001081dULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000252412723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b16247823ULL, 0x000fc4000001081dULL, 0x3fb8aa3b15257823ULL, 0x000fe4000001081dULL,
0x0000000fff1d7424ULL, 0x000fe400078e00ffULL, 0x0000001700177308ULL, 0x000fe20000000800ULL,
0x000000381313723eULL, 0x002fce00000000ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x0000002a1018723cULL, 0x000fee0000001818ULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x000000171c15723eULL, 0x002fc400000000ffULL,
0xfffffffc001c7812ULL, 0x000fca00078ec0ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x000000232214723eULL, 0x008fce00000000ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000ee20000000800ULL,
0x000000212016723eULL, 0x002fce00000000ffULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000292417723eULL, 0x008fce00000000ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x0000001c1d247219ULL, 0x000fc800000006ffULL, 0x00000000242173a1ULL, 0x000ee200000e8000ULL,
0x0000002a1418723cULL, 0x000fe20000001818ULL, 0x00000000240473c4ULL, 0x000f220000004000ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000f620000000800ULL,
0x0000001f1e1c723eULL, 0x002fc400000000ffULL, 0x000000072e1e723eULL, 0x000fe400000000ffULL,
0x000000282f077209ULL, 0x004fc60007810000ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000524ff7c12ULL, 0x008fce000f804021ULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x00000025261d723eULL, 0x020fe400000000ffULL, 0x0000000f0e1f723eULL, 0x002fce00000000ffULL,
0x0000002a1c38723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000142204008947ULL, 0x010fde000b800000ULL, 0x001c1fff38207589ULL, 0x0002a400000e0000ULL,
0x00000000240f73a1ULL, 0x000ee200000e8000ULL, 0x00000000240473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000524ff7c12ULL, 0x008fda000f80400fULL,
0x0000144204008947ULL, 0x010fea000b800000ULL, 0x001c1fff3a217589ULL, 0x00072800000e0000ULL,
0x001c1fff01227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x0006a400000e0000ULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x0000000c0c3d7812ULL, 0x000fc400078ec0ffULL,
0x000000070e0f7812ULL, 0x040fe200078ec0ffULL, 0x000000080e247824ULL, 0x04afe200078e00ffULL,
0x0000000eff1a7212ULL, 0x000fe200078e33ffULL, 0x000000080e187824ULL, 0x000fe200078e00ffULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x000000080e2d7824ULL, 0x040fe200078e00ffULL,
0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824197812ULL, 0x100fe400078ee20fULL,
0x00000001181b7812ULL, 0x100fe200078ef60fULL, 0x000000080e497824ULL, 0x000fe200078e00ffULL,
0x0000000218257812ULL, 0x100fe200078ef60fULL, 0x000000080e2f7824ULL, 0x000fe200078e00ffULL,
0x0000000318277812ULL, 0x100fe200078ef60fULL, 0x000000080e397824ULL, 0x000fe200078e00ffULL,
0x0000000418297812ULL, 0x000fc400078ef60fULL, 0x00000005182b7812ULL, 0x140fe400078ef60fULL,
0x00000006180f7812ULL, 0x000fe400078ef60fULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee21aULL,
0x0000000eff1a7212ULL, 0x000fe400078e33ffULL, 0x000000070e187812ULL, 0x000fe400078ec0ffULL,
0x00009000440e7811ULL, 0x000fc400078e58ffULL, 0xfffffff82f2f7812ULL, 0x100fe400078ee218ULL,
0x00000001393b7812ULL, 0x000fe200078ef618ULL, 0x00000010190c7824ULL, 0x000fe200078e020eULL,
0x00000002393f7812ULL, 0x000fe200078ef618ULL, 0x0000001027247824ULL, 0x000fe200078e020eULL,
0x0000000339417812ULL, 0x000fe200078ef618ULL, 0x000000100f2a7824ULL, 0x000fe200078e020eULL,
0x0000000439437812ULL, 0x000fe200078ef618ULL, 0x0000001029267824ULL, 0x000fe200078e020eULL,
0x0000000539457812ULL, 0x000fe200078ef618ULL, 0x000000013d0f7824ULL, 0x000fe200078e020cULL,
0x0000000639477812ULL, 0x000fe200078ef618ULL, 0x000000101b187824ULL, 0x000fe200078e020eULL,
0xfffffff849497812ULL, 0x000fe200078ee21aULL, 0x00000010251a7824ULL, 0x100fe200078e020eULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x000000102b287824ULL, 0x000fc400078e020eULL,
0x000000013d197824ULL, 0x040fe400078e0218ULL, 0x000000013d1b7824ULL, 0x000fe400078e021aULL,
0x000000102d2c7824ULL, 0x000fe200078e020eULL, 0x0000000a19007388ULL, 0x0007e20000000800ULL,
0x000000013d257824ULL, 0x000fe400078e0224ULL, 0x000000102f0c7824ULL, 0x000fe200078e020eULL,
0x000000101b007388ULL, 0x0007e20000000800ULL, 0x000000013d277824ULL, 0x000fc400078e0226ULL,
0x000000103b2e7824ULL, 0x000fe200078e020eULL, 0x0000001225007388ULL, 0x0007e20000000800ULL,
0x000000013d297824ULL, 0x000fe400078e0228ULL, 0x000000103f2f7824ULL, 0x000fe200078e020eULL,
0x0000001427007388ULL, 0x0007e20000000800ULL, 0x000000013d2b7824ULL, 0x000fe400078e022aULL,
0x0000001041367824ULL, 0x000fe200078e020eULL, 0x0000001629007388ULL, 0x0007e20000000800ULL,
0x000000013d2d7824ULL, 0x000fc400078e022cULL, 0x0000001043387824ULL, 0x000fe200078e020eULL,
0x0000001c2b007388ULL, 0x0007e20000000800ULL, 0x000000013d0c7824ULL, 0x000fe400078e020cULL,
0x0000001045397824ULL, 0x100fe200078e020eULL, 0x0000001e2d007388ULL, 0x0007e20000000800ULL,
0x00000010473a7824ULL, 0x100fe400078e020eULL, 0x00000010493b7824ULL, 0x000fe200078e020eULL,
0x000000090c007388ULL, 0x0007e20000000800ULL, 0x000000013d2e7824ULL, 0x000fc400078e022eULL,
0x000000013d0e7824ULL, 0x040fe400078e022fULL, 0x000000013d367824ULL, 0x040fe200078e0236ULL,
0x0000000b2e007388ULL, 0x0007e20000000800ULL, 0x000000013d387824ULL, 0x040fe400078e0238ULL,
0x000000013d087824ULL, 0x042fe200078e0239ULL, 0x000000110e007388ULL, 0x0007e20000000800ULL,
0x000000013d3a7824ULL, 0x040fe400078e023aULL, 0x000000013d187824ULL, 0x000fe200078e023bULL,
0x0000001336007388ULL, 0x0007e80000000800ULL, 0x0000001538007388ULL, 0x0007e80000000800ULL,
0x0000001708007388ULL, 0x0007e80000000800ULL, 0x0000001d3a007388ULL, 0x0007e80000000800ULL,
0x0000001f18007388ULL, 0x0007e80000000800ULL, 0x00f000040d008388ULL, 0x0007e80000000c00ULL,
0x00f200200d008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000034ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080034ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100034ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030046467a10ULL, 0x000fe20007ffe0ffULL, 0x0000180034ff7f8cULL, 0x0003e6000c80043fULL,
0x000000034600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffca6000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff187807ULL, 0x010fe20004000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00010900001d7802ULL, 0x000fe40000000f00ULL, 0x0000103000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e001aULL, 0xffff0da000007947ULL, 0x000fea000383ffffULL,
0x00000001ff187807ULL, 0x000fe20004000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00010960001d7802ULL, 0x000fe40000000f00ULL, 0x00000fd000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e001aULL, 0xffff0dd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0015ULL, 0x000109d000187802ULL, 0x004fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0023ULL,
0xffff0e2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x002fe200078e0015ULL,
0x00010a4000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff1a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x00000eb000007944ULL, 0x018fea0003c00000ULL,
0xffff0df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4a7224ULL, 0x000fe200078e0016ULL,
0x00010aa000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff1a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x00000e5000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff4f7224ULL, 0x004fe200078e0023ULL, 0xffff115000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x00010b1000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x00000de000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff507224ULL, 0x004fe200078e0023ULL,
0xffff111000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x002fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00010b70001d7802ULL, 0x000fc40000000f00ULL,
0x00000dc000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e001aULL,
0xffff2bc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00010bd0001d7802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e001aULL,
0xffff2bf000007947ULL, 0x000fea000383ffffULL, 0x0000001fff1a7424ULL, 0x002fe200078e00ffULL,
0x00010c3000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff617424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x014fea0003c00000ULL, 0xffff2c7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x00010c9000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x00000c6000007944ULL, 0x010fea0003c00000ULL, 0xffff2d3000007947ULL, 0x000fea000383ffffULL,
0x0000001fff1a7424ULL, 0x000fe200078e00ffULL, 0x00010ce000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x00000c1000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e0023ULL, 0xffff2ff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x00010d5000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x00000ba000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e0023ULL,
0xffff2fa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x002fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00010db0001d7802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e001aULL,
0xffff465000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00010e10001d7802ULL, 0x000fc40000000f00ULL,
0x00000b2000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e001aULL,
0xffff468000007947ULL, 0x000fea000383ffffULL, 0x0000001fff1a7424ULL, 0x002fe200078e00ffULL,
0x00010e7000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff617424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x014fea0003c00000ULL, 0xffff470000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x00010ed000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x00000a2000007944ULL, 0x010fea0003c00000ULL, 0xffff47c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff1a7424ULL, 0x000fe200078e00ffULL, 0x00010f2000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x000009d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff5b7224ULL, 0x004fe200078e0023ULL, 0xffff4a7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x00010f9000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000096000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff587224ULL, 0x004fe200078e0023ULL,
0xffff4a2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x010fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00010ff0001d7802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff127224ULL, 0x000fe200078e001aULL,
0xffff60f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff187807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00011050001d7802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff127224ULL, 0x000fe200078e001aULL,
0xffff612000007947ULL, 0x000fea000383ffffULL, 0x0000001fff1a7424ULL, 0x008fe200078e00ffULL,
0x000110b000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff617424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0xffff61a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x00afe200078e0015ULL, 0x0001111000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x000007e000007944ULL, 0x000fea0003c00000ULL, 0xffff626000007947ULL, 0x000fea000383ffffULL,
0x0000001fff1a7424ULL, 0x000fe200078e00ffULL, 0x0001116000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff617424ULL, 0x000fe400078e00ffULL, 0x0000079000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0023ULL, 0xffff652000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4a7224ULL, 0x002fe200078e0015ULL, 0x000111d000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff1a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff487224ULL, 0x004fe200078e0023ULL,
0xffff64d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2f7424ULL, 0x000fe200078e00ffULL,
0x00011240001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff387424ULL, 0x000fc400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002fULL, 0xffffe7d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2c7224ULL, 0x006fe200078e002eULL, 0x000112c0001c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x000005f000007944ULL, 0x000fea0003c00000ULL,
0x0000002f2e2e7209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x00011330001c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x0000002f06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0007ULL, 0x000113a0001c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x0000002f07287209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0036ULL,
0x00011410001c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002f36047209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e002eULL, 0x00011480001c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002f2e057209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x000114f0001c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x0000002f06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0028ULL, 0x00011560001c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0xffffe5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5f7224ULL, 0x000fe200078e0038ULL,
0x000115d000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff1a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff617224ULL, 0x000fe400078e0024ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xffffeb7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5f7224ULL, 0x002fe200078e003aULL,
0x0001165000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff617224ULL, 0x000fe400078e0024ULL,
0x000002a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4a7224ULL, 0x002fe200078e00ffULL,
0x000116b000187802ULL, 0x000fe20000000f00ULL, 0x00001c1fff1a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff617224ULL, 0x000fe400078e0024ULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff617224ULL, 0x002fe200078e0024ULL,
0x0001171000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff4a7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0023ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0xffffeac000007947ULL, 0x000fea000383ffffULL,
0x0180000003027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000300028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff457807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000245ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000003037812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000245ff7212ULL, 0x000fda000780c0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0007ULL, 0x00000000ff037424ULL, 0x002fc800078e00ffULL,
0xfffee75002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00002f2c2f7389ULL, 0x0002a200000e0038ULL,
0xfffee7101c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000006100007348ULL, 0x000fe80003800000ULL, 0x0000004a5f237389ULL, 0x0002a200000e001aULL,
0xfffee6d018007950ULL, 0x000fea0003c3ffffULL, 0x000000011800780cULL, 0x000fe20003f05070ULL,
0x0000001900007348ULL, 0x000fd80003800000ULL, 0x0000000000187806ULL, 0x000fc800040e0100ULL,
0x00000019181a7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe400078e001dULL,
0x00000000ff197424ULL, 0x000fc800078e00ffULL, 0xfffee66018007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000368ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000948ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009d8ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000125cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001290ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012b0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001340ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001348ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001358ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000011a80ULL, 0x9800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013010ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013490ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001340ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011cc0ULL, 0x0000000000011cc0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013490ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 79216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
