/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012510ULL, 0x0000000000012090ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000010bf0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x0000000000010d80ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000010dc0ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000010f00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00010bf000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0042580400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x84082880809d0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00010bf000000000ULL, 0x0000019000000000ULL,
0x00005c0400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8908288080840828ULL, 0x2880809d08288080ULL, 0x80b108288080b008ULL,
0x1628808090082880ULL, 0x0000031028808280ULL, 0x9092000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000010000000000ULL, 0x00010d8000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8908288080840828ULL,
0x2880809d08288080ULL, 0x80b108288080b008ULL, 0x1628808090082880ULL, 0x0000031028808280ULL,
0x9092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000019000000000ULL,
0x00010dc000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x000812040000009bULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x0000ff300000fa30ULL, 0x000100500000ff40ULL,
0x0001007000010060ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002dffffffffULL, 0x0500002d0500002dULL, 0xffffffff0500002dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x000000e0000000b0ULL,
0x000016c000001620ULL, 0x0000178000001740ULL, 0x000022f0000021a0ULL, 0x00003660000035c0ULL,
0x00003710000036e0ULL, 0x00003f1000003ed0ULL, 0x0000522000005180ULL, 0x000052d0000052a0ULL,
0x00005db000005d90ULL, 0x00006dc000006d30ULL, 0x00006e7000006e30ULL, 0x000072a000007290ULL,
0x000083d0000083c0ULL, 0x0000ae400000ae20ULL, 0x0000b3500000b320ULL, 0x0000f9400000f910ULL,
0x0000f9600000f950ULL, 0x0000f9a00000f970ULL, 0x0000f9e00000f9c0ULL, 0x000100a000010040ULL,
0x000100c0000100b0ULL, 0x0001078000010700ULL, 0x00010830000107d0ULL, 0x000108d000010880ULL,
0x0001097000010920ULL, 0x00010a10000109c0ULL, 0x00010b0000010a80ULL, 0x00010bc000010b60ULL,
0x0000016003e03904ULL, 0x0000f600000000ffULL, 0x000001a0003f0100ULL, 0x0000f6080000000fULL,
0x000001d0003f0130ULL, 0x0000f6100000000fULL, 0x00000200003f0130ULL, 0x0000f6480000000fULL,
0x00000230003f0120ULL, 0x0000f6680000000fULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x000006f0003f0107ULL, 0x0000f6140000000cULL, 0x00000a40003f0102ULL, 0x0000f6100000000cULL,
0x00000b80003f0101ULL, 0x00000000000000ffULL, 0x00000c1000040107ULL, 0x0000002000000005ULL,
0x00000d60003f0101ULL, 0x0000002400000005ULL, 0x00000e00003f0106ULL, 0x0000002400000005ULL,
0x00000e90003f0106ULL, 0x0000002400000005ULL, 0x000013b0003f0106ULL, 0x000000000000005fULL,
0x0000142000060107ULL, 0x0000000400000011ULL, 0x0000144000060106ULL, 0x0000f60c00000002ULL,
0x00001540003f0106ULL, 0x0000f60c00000002ULL, 0x000019f0003f0106ULL, 0x0000000400000011ULL,
0x00001a9000060106ULL, 0x0000000400000011ULL, 0x00002c5000060106ULL, 0x0000002000000005ULL,
0x00002cd0003f0101ULL, 0x0000000000000010ULL, 0x00002d80003f0101ULL, 0x0000002400000005ULL,
0x00002dd0003f0106ULL, 0x0000002400000005ULL, 0x00002e60003f0106ULL, 0x0000002400000005ULL,
0x00003380003f0106ULL, 0x00000000000000ffULL, 0x000033f000050107ULL, 0x0000000400000056ULL,
0x00003410003f0106ULL, 0x0000f61c00000002ULL, 0x00003520003f0106ULL, 0x0000f61c00000002ULL,
0x000039e0003f0106ULL, 0x0000f64c00000012ULL, 0x00003a70003f0106ULL, 0x0000f64c00000012ULL,
0x00004a20003f0106ULL, 0x0000002000000005ULL, 0x00004aa0003f0101ULL, 0x0000000000000010ULL,
0x00004b30003f0101ULL, 0x0000002400000005ULL, 0x00004b90003f0106ULL, 0x0000002400000005ULL,
0x00004c20003f0106ULL, 0x0000002400000005ULL, 0x00004f30003f0106ULL, 0x000000000000005fULL,
0x00004fa000060107ULL, 0x0000f64c00000018ULL, 0x00004fc0003f0106ULL, 0x0000f62c00000002ULL,
0x000050e0003f0106ULL, 0x0000f62c00000002ULL, 0x000055b0003f0106ULL, 0x0000f64c00000012ULL,
0x00005660003f0106ULL, 0x0000f64c00000012ULL, 0x00006620003f0106ULL, 0x0000002000000005ULL,
0x000066a0003f0101ULL, 0x0000000000000010ULL, 0x00006740003f0101ULL, 0x0000002400000005ULL,
0x00006790003f0106ULL, 0x0000002400000005ULL, 0x00006820003f0106ULL, 0x0000002400000005ULL,
0x00006b20003f0106ULL, 0x00000000000000ffULL, 0x00006b9000050107ULL, 0x0000000400000056ULL,
0x00006bb0003f0106ULL, 0x0000f63c00000002ULL, 0x00006c90003f0106ULL, 0x0000f63c00000002ULL,
0x00007150003f0106ULL, 0x0000f64c00000012ULL, 0x000071e0003f0106ULL, 0x0000f64c00000012ULL,
0x00008100003f0106ULL, 0x0000002000000005ULL, 0x00008160003f0101ULL, 0x0000f64000000002ULL,
0x0000cd10003f0101ULL, 0x0000f604000000ffULL, 0x0000cda0003f0106ULL, 0x0000f604000000ffULL,
0x0000cfc0003f0106ULL, 0x0000f600000000ffULL, 0x0000cfd0003f0101ULL, 0x0000f604000000ffULL,
0x0000d050003f0106ULL, 0x0000f604000000ffULL, 0x0000edb0003f0106ULL, 0x0000f61400000005ULL,
0x0000f1f0003f0106ULL, 0x0000f61400000005ULL, 0x00010640003f0106ULL, 0x0000f60800000005ULL,
0x00053803003f0101ULL, 0x0000bd4000141c04ULL, 0x0000d0a00000c190ULL, 0x000106a00000d140ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000020cULL, 0x0000001100000002ULL,
0x000000000000017cULL, 0x0000001100000002ULL, 0x00000000000000dcULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001e6ULL, 0x0000001100000002ULL,
0x0000000000000156ULL, 0x0000001100000002ULL, 0x00000000000000b2ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000417919ULL, 0x000ea80000002100ULL,
0x0000000000107919ULL, 0x000ee80000002700ULL, 0x0000000000117919ULL, 0x000f220000002600ULL,
0x0000000106007824ULL, 0x002fc800078e0203ULL, 0x00000080000f7824ULL, 0x104fe200078e0241ULL,
0x00000005ff417819ULL, 0x000fe20000011641ULL, 0x00001fff06007589ULL, 0x00066600000e0000ULL,
0x000000ff0f00720cULL, 0x040fe40003f05270ULL, 0x000000030f00780cULL, 0x040fe20003f44070ULL,
0x00001fff41417589ULL, 0x000ea200000e0000ULL, 0x0000007f0f00780cULL, 0x040fe20003f24070ULL,
0x0000600010067625ULL, 0x008fe200078e0007ULL, 0x000000010f00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL,
0x00f60002ff008388ULL, 0x0007e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f608040f00a388ULL, 0x0007e2000000ca00ULL, 0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f6100a0f00a388ULL, 0x0007e2000000ca00ULL,
0xff317217ff0e9424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x00f648080f00a388ULL, 0x0007e20000008a00ULL, 0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL,
0x00f4000e0f009388ULL, 0x0007e80000004800ULL, 0x00f6680c0f00b388ULL, 0x0007e80000008a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000027000000947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x01ce620000000000ULL, 0x0000000441047824ULL, 0x000fc400078e00ffULL,
0x00005800ff027624ULL, 0x000fe400078e00ffULL, 0x0000001011037824ULL, 0x000fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x00000100ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000001002027224ULL, 0x000fe200078e0203ULL, 0x000000040d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709087812ULL, 0x000fe400078ec0ffULL,
0x000000070b0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000102057824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000cULL,
0x0000000f08087812ULL, 0x100fe400078e780dULL, 0x0000000f0a0a7812ULL, 0x000fe200078e780dULL,
0x00005c0005047625ULL, 0x000fe200078e000cULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009087824ULL, 0x000fe200078e0208ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0a7824ULL, 0x000fe400078e020aULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001008097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806407981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff427e24ULL, 0x010fe2000f8e00ffULL, 0x000000ff400f7810ULL, 0x00cfc80007ffe0ffULL,
0x00000008ff0f7819ULL, 0x000fce000001160fULL, 0x0000bc6000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ea20000000000ULL, 0x0000580011007a10ULL, 0x000fe20007ffe0ffULL,
0x00000002100b7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011641ULL,
0x00000010410c7824ULL, 0x000fe400078e00ffULL, 0x000058000b0b7a24ULL, 0x000fe200078e0200ULL,
0x0000000142007810ULL, 0x000fe20007ffe0ffULL, 0x00000003ff117424ULL, 0x000fe200078e00ffULL,
0x000000100c097812ULL, 0x000fe400078ec0ffULL, 0x0000000f0000720cULL, 0x000fe20003f06070ULL,
0x0000000842007824ULL, 0x000fe200078e020aULL, 0x00000003ff0d7819ULL, 0x004fc8000001160eULL,
0x000000040d147810ULL, 0x000fe20007ffe0ffULL, 0x0000000109057824ULL, 0x000fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000805037824ULL, 0x040fe200078e00ffULL,
0x0000000e05027212ULL, 0x080fe200078e3cffULL, 0x0000000109077824ULL, 0x000fe200078e0214ULL,
0x000000080d167810ULL, 0x000fe20007ffe0ffULL, 0x0000002000007824ULL, 0x000fe200078e00ffULL,
0xfffffff803067812ULL, 0x000fe200078ee202ULL, 0x0000000807137824ULL, 0x040fe200078e00ffULL,
0x0000000e07047212ULL, 0x000fe200078e3cffULL, 0x00f614110cff738cULL, 0x0003e20000000000ULL,
0x0000000040037217ULL, 0x000fe20007800000ULL, 0x000020000a087824ULL, 0x000fe200078e00ffULL,
0x0000000c0d187810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff1c7424ULL, 0x000fe200078e00ffULL,
0xfffffff813107812ULL, 0x000fe200078ee204ULL, 0x0000000103047824ULL, 0x100fe200078e0a00ULL,
0x000000000a0473c2ULL, 0x0004e200000e0000ULL, 0x000062000b007a24ULL, 0x000fc400078e0200ULL,
0x0000000109037824ULL, 0x040fe400078e0216ULL, 0x0000000109137824ULL, 0x000fe400078e0218ULL,
0x0000000100027824ULL, 0x000fe200078e0205ULL, 0x0000b00008057810ULL, 0x000fe20007ffe0ffULL,
0x0000000100077824ULL, 0x040fe400078e0207ULL, 0x0000000100117824ULL, 0x042fe400078e0203ULL,
0x0000000100127824ULL, 0x000fe200078e0213ULL, 0x0000000e03007212ULL, 0x0c0fe200078e3cffULL,
0x0000000803157824ULL, 0x000fe200078e00ffULL, 0x0000000e13037212ULL, 0x040fe200078e3cffULL,
0x00000008131a7824ULL, 0x000fc400078e00ffULL, 0x000000100e137824ULL, 0x000fe200078e00ffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x0000001006157824ULL, 0x000fe200078e0205ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x000fe200078e001cULL,
0x0000007013137812ULL, 0x000fc600078ec0ffULL, 0x0000001000197824ULL, 0x100fe200078e0205ULL,
0x0000002004007807ULL, 0x000fe20000000000ULL, 0x0000001010177824ULL, 0x100fe200078e0205ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x000000101a1b7824ULL, 0x000fe200078e0205ULL,
0x0000000900007217ULL, 0x000fe20007800000ULL, 0x00005e0007047625ULL, 0x000fc800078e001cULL,
0x00005e0011067625ULL, 0x000fc800078e001cULL, 0x00005e0012107625ULL, 0x000fe200078e001cULL,
0x0000001306127210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001304047210ULL, 0x080fe20007f1e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a09ULL,
0x0000001310107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe400008e0607ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000000d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000001400720cULL, 0x080fe40003f26070ULL,
0x000000001600720cULL, 0x000fc40003f46070ULL, 0x000000001800720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f64804047891ULL, 0x000fe2000f8e203fULL,
0x00f610000cff7f8cULL, 0x0003e2000c80043fULL, 0x00000001410d7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff077424ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002157faeULL, 0x0003e2000c101c48ULL,
0x0000000f4200720cULL, 0x000fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000004177faeULL, 0x0005e2000c901c48ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000012197faeULL, 0x0003e2000d101c48ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00000000101b7faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6480a057811ULL, 0x004fc600078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200005ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000757000000947ULL, 0x000fea0003800000ULL,
0xff317217ff077424ULL, 0x004fe200078e00ffULL, 0x00007610ff3d7816ULL, 0x000fe2000000003dULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0x00007610ff3c7816ULL, 0x000fe2000000003cULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x00007610ff047816ULL, 0x000fc40000000004ULL,
0xffffffc00c037812ULL, 0x002fca00078ec0ffULL, 0x0000010042037824ULL, 0x000fca00078e0203ULL,
0x000000400300720cULL, 0x000fda0003f06070ULL, 0x0000747000000947ULL, 0x000fea0003800000ULL,
0x0000240005037984ULL, 0x000e620000000800ULL, 0x0000ffff3d027812ULL, 0x000fc800078ec0ffULL,
0x00008880020a7816ULL, 0x000fca00000000ffULL, 0x800000000a027824ULL, 0x000fca00078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804802ULL, 0x000000ffff037224ULL, 0x000fe200078e003fULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x000076103c607816ULL, 0x000fe40000000060ULL,
0x000076103d487816ULL, 0x000fe20000000048ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000240005117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804802ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000a117824ULL, 0x000fe400078e00ffULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe40003800000ULL, 0x00002400050a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003ff197819ULL, 0x000fe2000001160eULL,
0x00000100425b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011641ULL,
0x00000004191a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109157824ULL, 0x000fe200078e0219ULL,
0x0000000819447810ULL, 0x000fe20007ffe0ffULL, 0x000000200a027824ULL, 0x000fe200078e025bULL,
0x0000000142107810ULL, 0x000fe20007ffe0ffULL, 0x00000008155a7824ULL, 0x040fe200078e00ffULL,
0x0000000e15117212ULL, 0x000fe200078e3cffULL, 0x0000000109177824ULL, 0x040fe200078e021aULL,
0x0000004002027810ULL, 0x000fe20007ffe0ffULL, 0x00000001091b7824ULL, 0x000fe200078e0244ULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee211ULL, 0x0000000817137824ULL, 0x000fe200078e00ffULL,
0x0000000240117217ULL, 0x000fe20007800000ULL, 0x000000081b587824ULL, 0x000fe200078e00ffULL,
0x0000000e17127212ULL, 0x080fe200078e3cffULL, 0x000000000a0673c2ULL, 0x000e6200000e0000ULL,
0x0000000f1000720cULL, 0x000fe20003f06070ULL, 0x0000000111107824ULL, 0x100fe200078e0a02ULL,
0x0000000c19457810ULL, 0x000fe20007ffe0ffULL, 0x000062000b027a24ULL, 0x000fe200078e0202ULL,
0x0000000e1b117212ULL, 0x000fc400078e3cffULL, 0xfffffff8133e7812ULL, 0x000fe200078ee212ULL,
0x000010003f137824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee211ULL,
0x0000000109437824ULL, 0x000fe200078e0245ULL, 0x0000002010107807ULL, 0x000fe20000000000ULL,
0x000000083f117824ULL, 0x000fe200078e00ffULL, 0x0000100013137812ULL, 0x000fe200078e0cffULL,
0x0000000843477824ULL, 0x040fe200078e00ffULL, 0x0000000e43467212ULL, 0x000fe200078e3cffULL,
0x0000000115127824ULL, 0x100fe200078e0202ULL, 0x00000008115f7812ULL, 0x000fe200078e0cffULL,
0x0000000117147824ULL, 0x100fe200078e0202ULL, 0x0000001009107217ULL, 0x000fe20007800000ULL,
0x000000011b167824ULL, 0x100fe200078e0202ULL, 0x000000005f0473c2ULL, 0x000ea200000e0000ULL,
0x0000000143187824ULL, 0x000fe200078e0202ULL, 0xfffffff847027812ULL, 0x000fe200078ee246ULL,
0x000020000a137824ULL, 0x000fe200078e0213ULL, 0x0000f64806067891ULL, 0x002fe2000f8e203fULL,
0x00000080ff1b7424ULL, 0x000fc400078e00ffULL, 0x000000100e467824ULL, 0x000fe200078e00ffULL,
0x0000b00013577810ULL, 0x000fe20007ffe0ffULL, 0x00005e0012127625ULL, 0x000fc600078e001bULL,
0x0000007046437812ULL, 0x000fe200078ec0ffULL, 0x00005e0014147625ULL, 0x000fc600078e001bULL,
0x0000004312127210ULL, 0x080fe20007f1e0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x0000004314147210ULL, 0x000fe20007f7e0ffULL, 0x00005e0016167625ULL, 0x000fc600078e001bULL,
0x000000101a00720cULL, 0x080fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x000000101900720cULL, 0x080fe20003f06070ULL, 0x00005e0018187625ULL, 0x000fe200078e001bULL,
0x000000104400720cULL, 0x080fe20003f46070ULL, 0x0000000406047290ULL, 0x004fe2000fffe03fULL,
0x0000004316167210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x000000104500720cULL, 0x000fe20003f66070ULL, 0x000000105a5a7824ULL, 0x100fe200078e0257ULL,
0x0000004318187210ULL, 0x000fe20007fbe0ffULL, 0x000000103e597824ULL, 0x000fc400078e0257ULL,
0x0000001058587824ULL, 0x000fe400078e0257ULL, 0x000000ffff177224ULL, 0x000fe200020e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000125a7faeULL, 0x0003e2000c101c48ULL,
0x0000001002577824ULL, 0x000fe400078e0257ULL, 0x000000ffff197224ULL, 0x000fe200028e0619ULL,
0x0000000014597faeULL, 0x0003e2000c901c48ULL, 0x0000000441027824ULL, 0x000fc600078e00ffULL,
0x0000000016587faeULL, 0x0003e4000d101c48ULL, 0xfffffff002027812ULL, 0x000fe400078ec0ffULL,
0x0000000018577faeULL, 0x0003e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040611137984ULL, 0x0022a20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f60c0002157984ULL, 0x000ee20000000800ULL, 0x0000ffff3c107812ULL, 0x000fc400078ec0ffULL,
0x0000ffff04127812ULL, 0x000fe400078ec0ffULL, 0x0000888010177816ULL, 0x000fe400000000ffULL,
0x0000888012477816ULL, 0x000fc600000000ffULL, 0x8000000017107824ULL, 0x000fe400078e00ffULL,
0x8000000047127824ULL, 0x000fc600078e00ffULL, 0x8000000013ff7812ULL, 0x004fe40007804810ULL,
0x8000000015ff7812ULL, 0x008fe20007824812ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x8000000047137824ULL, 0x000fe400078e00ffULL, 0x0000001000127305ULL, 0x0004e4000021f000ULL,
0x3fa0000010107823ULL, 0x004fe200000100ffULL, 0x000000120000735dULL, 0x008fe40003800000ULL,
0x00f60c0002127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fc40007824813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000020414b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff497819ULL, 0x000fe2000001160eULL,
0x00000001ff727424ULL, 0x000fe200078e00ffULL, 0x0000007046467812ULL, 0x000fe400078ec0ffULL,
0xffffff804b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c49497812ULL, 0x000fc800078ec0ffULL,
0x0000004b49107210ULL, 0x000fca0007ffe046ULL, 0x00f0000010127984ULL, 0x000ea80000000800ULL,
0x00f2000010137984ULL, 0x0007220000000800ULL, 0x000000071200720bULL, 0x004fda0003f3d000ULL,
0x0000000000147806ULL, 0x000fc800008e0100ULL, 0x0000ffff14187812ULL, 0x000fda000782c0ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000071200720bULL, 0x018fe40003f34000ULL,
0x0000001207197209ULL, 0x000fe40007810000ULL, 0x00000002ff157819ULL, 0x000fc6000001160eULL,
0x8000001907107221ULL, 0x000fe20000010000ULL, 0x0000000815167810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b10147820ULL, 0x000fe20000410000ULL, 0x00000002ff107819ULL, 0x000fe40000011641ULL,
0x0000000000077806ULL, 0x000fe200008e0100ULL, 0x00000014001b7308ULL, 0x000ea20000000800ULL,
0x000000411000720cULL, 0x000fe40003f25270ULL, 0x0000ffff07077812ULL, 0x000fc800078e3cffULL,
0x0000000718ff7212ULL, 0x000fe2000784c0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0019ULL,
0x00000001ff727807ULL, 0x000fc60001000000ULL, 0x0000008041109824ULL, 0x000fe200078e0246ULL,
0x00001f161b167589ULL, 0x004ea200000e0000ULL, 0x0000001b06067220ULL, 0x000fe40000410000ULL,
0x0000000149109824ULL, 0x000fe400078e0210ULL, 0x8000001912122221ULL, 0x000fe20000010000ULL,
0x00001f151b157589ULL, 0x000ee600000e0000ULL, 0x3fb8aa3b12122820ULL, 0x000fe20000410000ULL,
0x00f4001910009388ULL, 0x0009e60000000800ULL, 0x0000001200002308ULL, 0x000f620000000800ULL,
0x000000161f1f7220ULL, 0x084fe20000410000ULL, 0x000000161e1e7220ULL, 0x080fe20000410000ULL,
0x000000163b3b7220ULL, 0x080fe20000410000ULL, 0x000000163a3a7220ULL, 0x080fe20000410000ULL,
0x0000001637377220ULL, 0x080fe20000410000ULL, 0x0000001636367220ULL, 0x080fe20000410000ULL,
0x0000001633337220ULL, 0x080fe20000410000ULL, 0x0000001632327220ULL, 0x080fe20000410000ULL,
0x000000162f2f7220ULL, 0x080fe20000410000ULL, 0x000000162e2e7220ULL, 0x080fe20000410000ULL,
0x000000162b2b7220ULL, 0x080fe20000410000ULL, 0x000000162a2a7220ULL, 0x080fe20000410000ULL,
0x0000001627277220ULL, 0x080fe20000410000ULL, 0x0000001626267220ULL, 0x080fe20000410000ULL,
0x0000001623237220ULL, 0x080fe20000410000ULL, 0x0000001622227220ULL, 0x000fe20000410000ULL,
0x000000151d1d7220ULL, 0x088fe20000410000ULL, 0x000000151c1c7220ULL, 0x080fe20000410000ULL,
0x0000001539397220ULL, 0x080fe20000410000ULL, 0x0000001538387220ULL, 0x080fe20000410000ULL,
0x0000001535357220ULL, 0x080fe20000410000ULL, 0x0000001534347220ULL, 0x080fe20000410000ULL,
0x0000001531317220ULL, 0x080fe20000410000ULL, 0x0000001530307220ULL, 0x080fe20000410000ULL,
0x000000152d2d7220ULL, 0x080fe20000410000ULL, 0x000000152c2c7220ULL, 0x080fe20000410000ULL,
0x0000001529297220ULL, 0x080fe20000410000ULL, 0x0000001528287220ULL, 0x080fe20000410000ULL,
0x0000001525257220ULL, 0x080fe20000410000ULL, 0x0000001524247220ULL, 0x080fe20000410000ULL,
0x0000001521217220ULL, 0x080fe20000410000ULL, 0x0000001520207220ULL, 0x000fe20000410000ULL,
0x0000000013132220ULL, 0x020fc80000410000ULL, 0x0000000613067221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000040611107984ULL, 0x000ea20008000800ULL,
0x8000000017137824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x004fe20007804813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000017177824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000127305ULL, 0x0004e4000021f000ULL, 0x3fa0000010107823ULL, 0x004fe200000100ffULL,
0x000000120000735dULL, 0x008fe40003800000ULL, 0x0000040611127984ULL, 0x000ea40008000800ULL,
0x8000000012ff7812ULL, 0x004fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000441137824ULL, 0x040fe200078e00ffULL,
0x000000080e117812ULL, 0x042fe200078ec0ffULL, 0x0000100041107824ULL, 0x000fe200078e00ffULL,
0x000000070e757812ULL, 0x000fe200078ec0ffULL, 0x000010003f447824ULL, 0x000fe200078e0208ULL,
0x0000000413137812ULL, 0x000fe200078ec0ffULL, 0x00000200418a7824ULL, 0x000fe200078e00ffULL,
0xffffe00010127812ULL, 0x000fe400078ec0ffULL, 0x0000000711107812ULL, 0x000fe400078ec80eULL,
0x000000130e137211ULL, 0x000fe200078fe0ffULL, 0x000010003f127824ULL, 0x000fe200078e0212ULL,
0x0000000711117812ULL, 0x000fc400078ef80eULL, 0x00000013105e7212ULL, 0x000fe400078e3cffULL,
0x0000b00012437810ULL, 0x000fe40007ffe0ffULL, 0x00000080115d7811ULL, 0x040fe200078e18ffULL,
0x00000008114e7824ULL, 0x000fe200078e025eULL, 0x0000b00044447810ULL, 0x000fe40007ffe0ffULL,
0x0000000213137810ULL, 0x000fe20007ffe0ffULL, 0x000000104e147824ULL, 0x000fe200078e0243ULL,
0x0000000875757812ULL, 0x000fe200078ef80eULL, 0x000000015e5e7824ULL, 0x000fe200078e025dULL,
0xfffff8008a8a7812ULL, 0x000fc400078ec0ffULL, 0x00000002ff8e7819ULL, 0x000fe2000001160eULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x000000105e187824ULL, 0x000fcc00078e0244ULL,
0x000000001818783bULL, 0x000ea20000004200ULL, 0x0000010014127824ULL, 0x042fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011414ULL, 0x0000010015457824ULL, 0x000fe200078e00ffULL,
0x00008880146a7816ULL, 0x000fe200000000ffULL, 0x00000100164f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011412ULL, 0x0001000014127824ULL, 0x000fe200078e00ffULL,
0x0000001310147212ULL, 0x000fe200078e3cffULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc40000011415ULL, 0x00000018ff877819ULL, 0x000fe20000011412ULL,
0x00000008114c7824ULL, 0x000fe200078e0214ULL, 0x0000888015117816ULL, 0x040fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x004fe20000011418ULL,
0x000000104c107824ULL, 0x000fe200078e0243ULL, 0x00008880186b7816ULL, 0x000fe200000000ffULL,
0x000000ffff437224ULL, 0x000fe200078e0011ULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x00000001145d7824ULL, 0x000fe200078e025dULL, 0x00000018ff4d7819ULL, 0x000fe20000011419ULL,
0x000000001010783bULL, 0x000e620000004200ULL, 0x0000001500867306ULL, 0x0005e20000200c00ULL,
0x0000888019647816ULL, 0x000fe200000000ffULL, 0x000000105d147824ULL, 0x000fe200078e0244ULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x000001001a447824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001141aULL, 0x00000018ff3e7819ULL, 0x000fe2000001141bULL,
0x0000004500887306ULL, 0x0007e20000200c00ULL, 0x0000010018157824ULL, 0x004fe200078e00ffULL,
0x000088801a677816ULL, 0x000fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x000088801b567816ULL, 0x000fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011415ULL, 0x0000010019157824ULL, 0x040fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011416ULL, 0x0000010017457824ULL, 0x008fe200078e00ffULL,
0x0000001800667306ULL, 0x0005e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fc40000011417ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000888016857816ULL, 0x040fe200000000ffULL, 0x0000001900627306ULL, 0x000fe20000200c00ULL,
0x000001001b187824ULL, 0x004fe200078e00ffULL, 0x0000888017517816ULL, 0x000fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000045006c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1b7819ULL, 0x000fc4000001141bULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x00000100117e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x00010000117d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe20000011410ULL,
0x0000001800637306ULL, 0x0003e20000200c00ULL, 0x0000888010817816ULL, 0x000fe200000000ffULL,
0x0000010012787824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011415ULL,
0x00000018ff447819ULL, 0x000fc40000011444ULL, 0x00000018ff767819ULL, 0x000fe20000011411ULL,
0x0000001a00657306ULL, 0x000fe20000200c00ULL, 0x0000010010187824ULL, 0x042fe200078e00ffULL,
0x0000888011717816ULL, 0x000fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011412ULL, 0x0000010013117824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011418ULL, 0x0000000241187824ULL, 0x000fe200078e00ffULL,
0x0000001b00617306ULL, 0x000fe20000200c00ULL, 0x00000018ff7f7819ULL, 0x000fc40000011410ULL,
0x00000000ff10723eULL, 0x000fe400000000ffULL, 0x0000000418197812ULL, 0x000fe400078ec0ffULL,
0x0000541010797816ULL, 0x000fe20000000010ULL, 0x0000001600837306ULL, 0x000fe20000200c00ULL,
0x000000190e8c7211ULL, 0x000fe400078fe0ffULL, 0x0000991072107816ULL, 0x000fe200000000ffULL,
0x00001f8e79737589ULL, 0x000fe200000e0000ULL, 0x000000078c187812ULL, 0x000fc400078e7875ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x0000001700827306ULL, 0x0003e20000200c00ULL,
0x00000018ff777819ULL, 0x000fe20000011411ULL, 0x0000000875457824ULL, 0x000fe200078e0218ULL,
0x00008880127b7816ULL, 0x040fe200000000ffULL, 0x0001000012117824ULL, 0x000fe200078e00ffULL,
0x000000028c127810ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x000fe200078e028aULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x00000044005c7306ULL, 0x0005e20000200c00ULL,
0x000000001414783bULL, 0x002e620000004200ULL, 0x0001000013107824ULL, 0x000fe200078e00ffULL,
0x0000000712127812ULL, 0x000fc400078e7875ULL, 0x009000004518783bULL, 0x000ee20000000200ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000000088e447810ULL, 0x004fe40007ffe0ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff6e7819ULL, 0x000fe20000011413ULL, 0x00001f4479727589ULL, 0x000ea200000e0000ULL,
0x0000888013747816ULL, 0x000fe200000000ffULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x0000000875137824ULL, 0x000fe200078e0212ULL, 0x00000018ff7e7819ULL, 0x000fc4000001147eULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000004300437306ULL, 0x000ff00000200c00ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000888014127816ULL, 0x002fc400000000ffULL,
0x00000018ff547819ULL, 0x000fe20000011414ULL, 0x0000007318188232ULL, 0x088fe20000000000ULL,
0x00000018ff537819ULL, 0x000fe20000011415ULL, 0x000000731a1a8232ULL, 0x000fe40000000000ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000007219198232ULL, 0x084fe20000000000ULL,
0x00000018ff527819ULL, 0x000fe20000011416ULL, 0x000000721b1b8232ULL, 0x000fca0000000000ULL,
0x0000004f00507306ULL, 0x0002b00000200c00ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x00000018ff4f7819ULL, 0x002fce0000011417ULL, 0x0000001100797306ULL, 0x0003e20000200c00ULL,
0x0000541085507816ULL, 0x004fce0000000050ULL, 0x0000001000757306ULL, 0x0005e20000200c00ULL,
0x0000541043117816ULL, 0x002fe20000000088ULL, 0x0000001013437824ULL, 0x000fe200078e028aULL,
0x0000541051517816ULL, 0x008fca000000006cULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x000054106a107816ULL, 0x004fe20000000089ULL, 0x000000ffff6a7224ULL, 0x000fe200078e0012ULL,
0x000000501828723cULL, 0x040fe20000001828ULL, 0x0000010014127824ULL, 0x040fe400078e00ffULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x0000006f006f7306ULL, 0x000ea60000200c00ULL,
0x000000101820723cULL, 0x000fe20000001820ULL, 0x00000018ff147819ULL, 0x000fc80000011414ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541083507816ULL, 0x002fe4000000007cULL,
0x0000541087107816ULL, 0x000fe40000000084ULL, 0x0000541086117816ULL, 0x000fe4000000006dULL,
0x00000018ff6d7819ULL, 0x000fe20000011412ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541082517816ULL, 0x004fe4000000006fULL, 0x0000888015847816ULL, 0x000fe200000000ffULL,
0x000000101824723cULL, 0x000fe20000001824ULL, 0x009000004310783bULL, 0x000ea60000000200ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000ffff6c7224ULL, 0x000fc400078e0084ULL,
0x0000010015847824ULL, 0x000fe200078e00ffULL, 0x00000050182c723cULL, 0x000fe8000000182cULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe40000011484ULL,
0x0000541081507816ULL, 0x002fca0000000080ULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541071517816ULL, 0x008fce000000007eULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000000501830723cULL, 0x000fe20000001830ULL,
0x0000007310108232ULL, 0x084fe40000000000ULL, 0x0000007312128232ULL, 0x000fc80000000000ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0001000015507824ULL, 0x000fe200078e00ffULL,
0x0000007211118232ULL, 0x080fe40000000000ULL, 0x0000007213138232ULL, 0x000fc80000000000ULL,
0x0000007400747306ULL, 0x000ff00000200c00ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000054107d157816ULL, 0x002fe40000000076ULL, 0x0000888016767816ULL, 0x000fca00000000ffULL,
0x0000007000707306ULL, 0x000e700000200c00ULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x0000541074517816ULL, 0x004fce0000000077ULL, 0x0000001400717306ULL, 0x0005f00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000054107f147816ULL, 0x004fce000000007aULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000000141834723cULL, 0x000fee0000001834ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011450ULL,
0x0000541079147816ULL, 0x002fca0000000070ULL, 0x0000006900697306ULL, 0x000e700000200c00ULL,
0x0000001500747306ULL, 0x0007f00000200c00ULL, 0x0000005500557306ULL, 0x000f220000200c00ULL,
0x0000541075157816ULL, 0x008fce000000006eULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x00000014181c723cULL, 0x000fee000000181cULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000054106b147816ULL, 0x004fe40000000068ULL, 0x0000541064157816ULL, 0x002fca0000000069ULL,
0x0000007800787306ULL, 0x000e640000200c00ULL, 0x000000141020723cULL, 0x000fec0000001820ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000541066147816ULL, 0x010fe40000000055ULL,
0x0000541062157816ULL, 0x008fca000000004dULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x000054107b507816ULL, 0x002fe20000000078ULL, 0x000000141024723cULL, 0x000fec0000001824ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x004fe2000000005cULL,
0x000000501838723cULL, 0x000fe20000001838ULL, 0x0000541056157816ULL, 0x008fca0000000063ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x0000010016517824ULL, 0x040fe200078e00ffULL,
0x0000888017187816ULL, 0x040fe200000000ffULL, 0x00000100171a7824ULL, 0x000fe400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x000000141028723cULL, 0x000fe20000001828ULL,
0x000000ffff507224ULL, 0x000fe200078e0076ULL, 0x00000018ff197819ULL, 0x000fe20000011451ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fc4000001141aULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0001000017147824ULL, 0x000fe200078e00ffULL,
0x0000541061157816ULL, 0x002fc6000000003eULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00000018ff1b7819ULL, 0x000fe40000011414ULL, 0x0000541065147816ULL, 0x000fca000000004aULL,
0x0000006c006c7306ULL, 0x000fe40000200c00ULL, 0x00000014102c723cULL, 0x000fec000000182cULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x000054106a147816ULL, 0x002fce000000006dULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000001a00517306ULL, 0x000fe20000200c00ULL,
0x000054106c157816ULL, 0x004fce000000006fULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000541074557816ULL, 0x002fe20000000053ULL, 0x000000141030723cULL, 0x000fec0000001830ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000002ff157819ULL, 0x000fce0000011641ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000541071547816ULL, 0x004fce0000000054ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000000541034723cULL, 0x000fee0000001834ULL,
0x0000001900197306ULL, 0x000e700000200c00ULL, 0x0000001800187306ULL, 0x000eb00000200c00ULL,
0x0000001600177306ULL, 0x000ee20000200c00ULL, 0x0000541050507816ULL, 0x002fce0000000019ULL,
0x0000001b001a7306ULL, 0x000e620000200c00ULL, 0x0000541018517816ULL, 0x004fe40000000051ULL,
0x0000541017527816ULL, 0x008fca0000000052ULL, 0x000000501038723cULL, 0x000fe20000001838ULL,
0x000054101a537816ULL, 0x002fcc000000004fULL, 0x0000010042507824ULL, 0x000fe200078e00ffULL,
0x00000052101c723cULL, 0x000fee000000181cULL, 0x0000f61015107811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x0000200005ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004015117824ULL, 0x000fe200078e0250ULL,
0x000000ff3cff7812ULL, 0x000fe2000782c0ffULL, 0x0000000010ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff3dff7812ULL, 0x000fc4000784c0ffULL, 0x0000004011117810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff197807ULL, 0x000fe40000800000ULL, 0x000000401100720cULL, 0x000fe40003f26070ULL,
0x000000013f00780cULL, 0x040fe40003f05270ULL, 0x00000001ff5c7807ULL, 0x000fe40001000000ULL,
0x000000013f3f7812ULL, 0x000fc400078e0cffULL, 0x0000003c193c7207ULL, 0x000fe40004000000ULL,
0x000076105c3d7816ULL, 0x000fc6000000003dULL, 0x0000545000001947ULL, 0x000fea0003800000ULL,
0x0000240005117984ULL, 0x004ea20000000800ULL, 0x800000005c0a7824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x004fe2000782480aULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000240005117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe4000782480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0a7424ULL, 0x000fe400078e00ffULL,
0x800000005c117824ULL, 0x000fe400078e00ffULL, 0x0000000a00107305ULL, 0x0004e4000021f000ULL,
0x3fa000000a0a7823ULL, 0x004fe200000100ffULL, 0x000000100000735dULL, 0x008fe40003800000ULL,
0x0000240005107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001420a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000803617824ULL, 0x040fe200078e00ffULL,
0x000000090e117211ULL, 0x040fe200078fe8ffULL, 0x00000080ff4d7424ULL, 0x000fe200078e00ffULL,
0x000000040e107811ULL, 0x000fe200078fe8ffULL, 0x0000100003627824ULL, 0x000fe200078e00ffULL,
0x0000000f0a00720cULL, 0x000fe20003f26070ULL, 0x0000000811147824ULL, 0x040fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011641ULL, 0x0000000e11557212ULL, 0x000fe200078e3cffULL,
0x0000000109117824ULL, 0x000fe200078e0210ULL, 0x0000000861127812ULL, 0x000fe200078ec0ffULL,
0x000000200a137824ULL, 0x000fe200078e025bULL, 0x00000003ff1b7819ULL, 0x000fc4000001160eULL,
0x0000000e11107212ULL, 0x040fe200078e3cffULL, 0x0000000811117824ULL, 0x000fe200078e00ffULL,
0x0000008013137810ULL, 0x000fe20007ffe0ffULL, 0x00000000120773c2ULL, 0x0004e200000e0000ULL,
0xfffffff814557812ULL, 0x000fe400078ee255ULL, 0xfffffff811547812ULL, 0x000fe200078ee210ULL,
0x000062000b187a24ULL, 0x000fe200078e0213ULL, 0x000000080e107811ULL, 0x000fe400078fe8ffULL,
0x0000001340147217ULL, 0x000fc40007800000ULL, 0x0000000c0e127811ULL, 0x004fe200078fe8ffULL,
0x0000000109117824ULL, 0x000fe200078e0210ULL, 0x000000041b3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114167824ULL, 0x000fe200078e0a13ULL, 0x0000f6480a157811ULL, 0x000fe200078e20ffULL,
0x0000000109137824ULL, 0x000fe200078e0212ULL, 0x0000000861567812ULL, 0x000fe200078e0cffULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0x0000003f18107210ULL, 0x140fe20007ffe009ULL,
0x00000000150573c2ULL, 0x0004e200000e0000ULL, 0x0000001b18127210ULL, 0x000fe20007ffe009ULL,
0x0000000115567824ULL, 0x000fe200078e0256ULL, 0x0000000e13147212ULL, 0x0c0fe200078e3cffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000000c1b3d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0012127625ULL, 0x000fe200078e004dULL, 0x0000000e11157212ULL, 0x004fc600078e3cffULL,
0x00005e0010107625ULL, 0x000fe200078e004dULL, 0xfffffff817527812ULL, 0x000fe400078ee214ULL,
0xfffffff81a537812ULL, 0x000fe400078ee215ULL, 0x00000020161a7807ULL, 0x000fe40000800000ULL,
0x0000004610147210ULL, 0x080fe40007f5e0ffULL, 0x0000004612167210ULL, 0x000fe40007f3e0ffULL,
0x0000001a091a7217ULL, 0x000fe20007800000ULL, 0x000000ffff157224ULL, 0x000fe200010e0611ULL,
0x0000100062117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0613ULL,
0x000000081b137810ULL, 0x000fe20007ffe0ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0a09ULL,
0x0000003d18107210ULL, 0x000fe20007ffe009ULL, 0x000020000a117824ULL, 0x000fe200078e0211ULL,
0x0000001318127210ULL, 0x000fe20007ffe009ULL, 0x0000000705057290ULL, 0x008fe2000fffe03fULL,
0x0000001a1300720cULL, 0x000fc40003f66070ULL, 0x0000001a1b00720cULL, 0x080fe20003f26070ULL,
0x00005e0012127625ULL, 0x080fe200078e004dULL, 0x0000b00011187810ULL, 0x000fe40007ffe0ffULL,
0x0000001a3f00720cULL, 0x080fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fe200078e004dULL,
0x0000001a3d00720cULL, 0x000fe40003f86070ULL, 0x0000004612127210ULL, 0x080fe20007fbe0ffULL,
0x0000001055557824ULL, 0x100fe200078e0218ULL, 0x0000004610107210ULL, 0x000fe20007fde0ffULL,
0x0000001054547824ULL, 0x000fc400078e0218ULL, 0x0000001053537824ULL, 0x100fe200078e0218ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016557faeULL, 0x0005e2000c901c48ULL,
0x000000ffff137224ULL, 0x000fe400028e0613ULL, 0x0000001052527824ULL, 0x000fe200078e0218ULL,
0x0000000014547faeULL, 0x0005e2000d101c48ULL, 0x000000ffff117224ULL, 0x000fc600030e0611ULL,
0x0000000012537faeULL, 0x0005e8000d901c48ULL, 0x0000000010527faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040056117984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f61c0002127984ULL, 0x000f220000000800ULL,
0x0000006019607207ULL, 0x000fe20004000000ULL, 0x8000000047137824ULL, 0x000fc600078e00ffULL,
0x0000ffff60107812ULL, 0x000fc800078ec0ffULL, 0x0000888010177816ULL, 0x000fca00000000ffULL,
0x8000000017107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x008fe40007804810ULL,
0x8000000012ff7812ULL, 0x010fe20007824813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000441027824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000047127824ULL, 0x000fe200078e00ffULL,
0xfffffff002027812ULL, 0x000fe400078ec0ffULL, 0x0000001000117305ULL, 0x000724000021f000ULL,
0x3fa0000010107823ULL, 0x008fe200000100ffULL, 0x000000110000735dULL, 0x010fe40003800000ULL,
0x00f61c0002117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x008fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000008046107810ULL, 0x000fe20007ffe04bULL, 0x00000001ff6c7424ULL, 0x000fc800078e00ffULL,
0x0000000149107824ULL, 0x000fca00078e0210ULL, 0x00f0000010127984ULL, 0x000ee80000000800ULL,
0x00f2000010117984ULL, 0x0008620000000800ULL, 0x000000071200720bULL, 0x008fda0003f3d000ULL,
0x0000000000137806ULL, 0x000fc800008e0100ULL, 0x0000ffff13167812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000071200720bULL, 0x012fe40003f34000ULL,
0x0000001207147209ULL, 0x000fe40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001160eULL,
0x8000001407107221ULL, 0x040fe20000010000ULL, 0x0000001207077209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL, 0x0000000141107811ULL, 0x000fe400078ff0ffULL,
0x0000000000137806ULL, 0x000fe400008e0100ULL, 0x000000411000720cULL, 0x000fe20003f25270ULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x0000ffff13137812ULL, 0x000fc800078e3cffULL,
0x0000001316ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff6c7807ULL, 0x000fc60001000000ULL,
0x0000008041189824ULL, 0x000fc800078e0246ULL, 0x0000000149199824ULL, 0x000fe200078e0218ULL,
0x00001f1a15107589ULL, 0x002e6200000e0000ULL, 0x8000001412162221ULL, 0x000fe20000010000ULL,
0x0000001506067220ULL, 0x000fe40000410000ULL, 0x00001f4415137589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b16162820ULL, 0x000fc60000410000ULL, 0x00f4001419009388ULL, 0x0009e20000000800ULL,
0x0000001600002308ULL, 0x000f620000000800ULL, 0x0000001020207220ULL, 0x082fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x000fe20000410000ULL, 0x0000001322227220ULL, 0x088fe20000410000ULL,
0x0000001323237220ULL, 0x080fe20000410000ULL, 0x0000001326267220ULL, 0x080fe20000410000ULL,
0x0000001327277220ULL, 0x080fe20000410000ULL, 0x000000132a2a7220ULL, 0x080fe20000410000ULL,
0x000000132b2b7220ULL, 0x080fe20000410000ULL, 0x000000132e2e7220ULL, 0x080fe20000410000ULL,
0x000000132f2f7220ULL, 0x080fe20000410000ULL, 0x0000001332327220ULL, 0x080fe20000410000ULL,
0x0000001333337220ULL, 0x080fe20000410000ULL, 0x0000001336367220ULL, 0x080fe20000410000ULL,
0x0000001337377220ULL, 0x080fe20000410000ULL, 0x000000133a3a7220ULL, 0x080fe20000410000ULL,
0x000000133b3b7220ULL, 0x080fe20000410000ULL, 0x000000131e1e7220ULL, 0x080fe20000410000ULL,
0x000000131f1f7220ULL, 0x000fe20000410000ULL, 0x0000001100112220ULL, 0x020fc80000410000ULL,
0x0000000611067221ULL, 0x012fe20000010000ULL, 0x0000013000000947ULL, 0x000fea0003800000ULL,
0x0000000803107824ULL, 0x000fe400078e00ffULL, 0x0000000841117824ULL, 0x000fc600078e00ffULL,
0x0000000810107812ULL, 0x000fe400078e0cffULL, 0xfffffff011117812ULL, 0x000fca00078ec0ffULL,
0x0000000110127824ULL, 0x000fe400078e0211ULL, 0x8000000017117824ULL, 0x000fc600078e00ffULL,
0x00f64c0012107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000017147824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002e4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x008fe40003800000ULL, 0x00f64c0012117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000100003117824ULL, 0x000fe400078e00ffULL,
0x0000100041107824ULL, 0x000fc600078e00ffULL, 0x0000100011117812ULL, 0x000fe400078e0cffULL,
0xffffe00010107812ULL, 0x000fe400078ec0ffULL, 0x0000b000084a7810ULL, 0x100fe40007ffe011ULL,
0x0000b000104f7810ULL, 0x000fc60007ffe011ULL, 0x000000105e4d7824ULL, 0x100fe400078e024aULL,
0x000000104e517824ULL, 0x100fe400078e024fULL, 0x000000104c4f7824ULL, 0x000fe200078e024fULL,
0x000000004d10783bULL, 0x000e620000004200ULL, 0x000000105d4a7824ULL, 0x000fc600078e024aULL,
0x000000005118783bULL, 0x000ee80000004200ULL, 0x000000004f3c783bULL, 0x000f280000004200ULL,
0x000000004a14783bULL, 0x000f620000004200ULL, 0x00000018ff6a7819ULL, 0x002fe20000011410ULL,
0x0000010010757824ULL, 0x040fe200078e00ffULL, 0x0000888010767816ULL, 0x040fe200000000ffULL,
0x0001000010737824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x008fe20000011418ULL,
0x00000100186b7824ULL, 0x040fe200078e00ffULL, 0x0000888018937816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011419ULL,
0x00000100196d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001146bULL,
0x000001003c877824ULL, 0x050fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001003d8a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000100003c887824ULL, 0x000fe200078e00ffULL, 0x0000001800947306ULL, 0x0003e20000200c00ULL,
0x00000018ff897819ULL, 0x000fe2000001141aULL, 0x000100003d857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001141bULL, 0x0000010011747824ULL, 0x000fe200078e00ffULL,
0x00008880196b7816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x000088801a927816ULL, 0x040fe200000000ffULL, 0x0000006d00967306ULL, 0x0007e20000200c00ULL,
0x000001001a187824ULL, 0x042fe200078e00ffULL, 0x000088801b777816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0001000011707824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001003f827824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000001001b6d7824ULL, 0x048fe200078e00ffULL, 0x0000001900917306ULL, 0x000fe20000200c00ULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000000ff10723eULL, 0x000fe200000000ffULL,
0x000100003f7e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001143cULL,
0x00000100126e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x000001003e817824ULL, 0x040fe200078e00ffULL, 0x00000018008d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff807819ULL, 0x000fe2000001143dULL, 0x000100003e847824ULL, 0x000fe200078e00ffULL,
0x000088803c8c7816ULL, 0x000fc400000000ffULL, 0x000088803d7b7816ULL, 0x000fe400000000ffULL,
0x00000002ff3c7819ULL, 0x000fe2000001160eULL, 0x0000001a008e7306ULL, 0x000fe20000200c00ULL,
0x00005410103d7816ULL, 0x000fe40000000010ULL, 0x00000018ff697819ULL, 0x000fe40000011411ULL,
0x0000888011717816ULL, 0x000fe200000000ffULL, 0x00001f3c3d7d7589ULL, 0x000fe200000e0000ULL,
0x000099106c117816ULL, 0x000fe200000000ffULL, 0x0000001b008b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x00001f443d7c7589ULL, 0x000fe200000e0000ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x00000100136c7824ULL, 0x040fe200078e00ffULL,
0x0000888013107816ULL, 0x000fc400000000ffULL, 0x00000018ff787819ULL, 0x000fe2000001143fULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x009800004518783bULL, 0x002e620000000200ULL,
0x000088803f7f7816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe40000011412ULL,
0x00008880126f7816ULL, 0x000fe400000000ffULL, 0x0000009800987306ULL, 0x000fe20000200c00ULL,
0x00000018ff877819ULL, 0x000fc40000011487ULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x00000018ff797819ULL, 0x000fe4000001143eULL, 0x000088803e867816ULL, 0x000fe200000000ffULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x00000018ff677819ULL, 0x000fe20000011413ULL,
0x00010000133e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000018ff667819ULL, 0x020fe40000011414ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000054106b117816ULL, 0x008fc40000000096ULL, 0x00000018ff657819ULL, 0x000fe40000011415ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000009200927306ULL, 0x000ee20000200c00ULL, 0x0000007d18188232ULL, 0x082fe20000000000ULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000007d1a1a8232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000007c19198232ULL, 0x080fe20000000000ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000007c1b1b8232ULL, 0x000fe20000000000ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000018ff6c7819ULL, 0x000fc4000001146cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff647819ULL, 0x000fe40000011416ULL,
0x00000018ff637819ULL, 0x000fe20000011417ULL, 0x0000006d00907306ULL, 0x0003220000200c00ULL,
0x00005410923c7816ULL, 0x008fe2000000008dULL, 0x00000100158d7824ULL, 0x000fcc00078e00ffULL,
0x00000010003f7306ULL, 0x0007e20000200c00ULL, 0x00010000126d7824ULL, 0x002fe200078e00ffULL,
0x0000888014127816ULL, 0x000fc800000000ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000000ffff6b7224ULL, 0x000fe200078e0012ULL, 0x0000008900897306ULL, 0x000e620000200c00ULL,
0x0000541093107816ULL, 0x008fe20000000098ULL, 0x0000010014127824ULL, 0x040fe200078e00ffULL,
0x00005410773d7816ULL, 0x010fe20000000090ULL, 0x0001000014147824ULL, 0x000fc800078e00ffULL,
0x0000007a007a7306ULL, 0x000ee20000200c00ULL, 0x000000101820723cULL, 0x000fe20000001820ULL,
0x00000018ff147819ULL, 0x000fcc0000011414ULL, 0x0000541094107816ULL, 0x000fe2000000008fULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x0000541091117816ULL, 0x000fe20000000072ULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x00000018ff727819ULL, 0x000fe40000011412ULL,
0x00008880158f7816ULL, 0x000fc600000000ffULL, 0x0000008700877306ULL, 0x000f220000200c00ULL,
0x000054108e3c7816ULL, 0x002fe20000000089ULL, 0x000000101824723cULL, 0x040fe20000001824ULL,
0x009800004310783bULL, 0x000e620000000200ULL, 0x000054108b3d7816ULL, 0x008fe4000000007aULL,
0x00000018ff7a7819ULL, 0x000fe4000001148dULL, 0x0000007b007b7306ULL, 0x000fe60000200c00ULL,
0x0000003c182c723cULL, 0x000fea000000182cULL, 0x0000008a008a7306ULL, 0x000ee40000200c00ULL,
0x000054108c3c7816ULL, 0x010fcc0000000087ULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000054107b3d7816ULL, 0x008fce000000008aULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x0000007d10108232ULL, 0x082fe40000000000ULL, 0x0000007d12128232ULL, 0x000fe40000000000ULL,
0x0000007c11118232ULL, 0x080fe40000000000ULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x00010000153c7824ULL, 0x000fe200078e00ffULL, 0x0000007c13138232ULL, 0x000fcc0000000000ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541085157816ULL, 0x002fe40000000080ULL, 0x00000018ff807819ULL, 0x000fca000001143cULL,
0x0000008400847306ULL, 0x000e700000200c00ULL, 0x0000007e007e7306ULL, 0x000ef00000200c00ULL,
0x00000014007b7306ULL, 0x0009f00000200c00ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541088147816ULL, 0x010fce0000000083ULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x000000141834723cULL, 0x000fee0000001834ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541084147816ULL, 0x002fe40000000079ULL, 0x000054107e157816ULL, 0x008fca0000000078ULL,
0x0000007400747306ULL, 0x000e640000200c00ULL, 0x00000014181c723cULL, 0x000fec000000181cULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541076147816ULL, 0x010fce0000000075ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000541071157816ULL, 0x002fce0000000074ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x000000141020723cULL, 0x000fee0000001820ULL,
0x0000007000707306ULL, 0x000ef00000200c00ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x0000541073147816ULL, 0x002fce000000006aULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541070157816ULL, 0x008fce0000000069ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000000141024723cULL, 0x000fee0000001824ULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x00005410863c7816ULL, 0x002fce0000000081ULL, 0x0000006f006f7306ULL, 0x000ff00000200c00ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x000054107f3d7816ULL, 0x008fe40000000082ULL,
0x00008880167f7816ULL, 0x000fca00000000ffULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x0000003c1838723cULL, 0x000fee0000001838ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000054106f147816ULL, 0x002fe2000000006eULL, 0x00000100163d7824ULL, 0x000fe200078e00ffULL,
0x0000888017187816ULL, 0x040fe200000000ffULL, 0x00000100171a7824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe2000001143dULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054103f157816ULL, 0x008fe4000000006cULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff167819ULL, 0x000fc60000011416ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x000000141028723cULL, 0x000fee0000001828ULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x0001000017147824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011414ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000054106d147816ULL, 0x002fce0000000068ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000054103e157816ULL, 0x008fce0000000067ULL, 0x0000008f00777306ULL, 0x000fe20000200c00ULL,
0x00000014102c723cULL, 0x000fee000000182cULL, 0x0000007a007a7306ULL, 0x000ee20000200c00ULL,
0x000054106b147816ULL, 0x002fce0000000072ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000541077157816ULL, 0x008fce000000007aULL,
0x0000008000807306ULL, 0x000ee20000200c00ULL, 0x000000141030723cULL, 0x000fee0000001830ULL,
0x0000007f003c7306ULL, 0x000fe20000200c00ULL, 0x000054107b147816ULL, 0x002fce0000000066ULL,
0x0000001900197306ULL, 0x000e620000200c00ULL, 0x0000541080157816ULL, 0x008fce0000000065ULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x000000141034723cULL, 0x000fee0000001834ULL,
0x0000001a001b7306ULL, 0x000ee20000200c00ULL, 0x000054103c147816ULL, 0x002fe40000000019ULL,
0x00000002ff197819ULL, 0x000fca0000011641ULL, 0x0000006400647306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000541018157816ULL, 0x008fce000000001bULL,
0x0000001600177306ULL, 0x000e620000200c00ULL, 0x000000141038723cULL, 0x000fee0000001838ULL,
0x0000003d001a7306ULL, 0x000ee20000200c00ULL, 0x0000541017147816ULL, 0x002fe40000000064ULL,
0x000054101a157816ULL, 0x008fce0000000063ULL, 0x00000014101c723cULL, 0x000fee000000181cULL,
0x0000f62019107811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200005ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000442117824ULL, 0x000fe200078e0219ULL, 0x000000ff60ff7812ULL, 0x000fe2000782c0ffULL,
0x0000000010ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ff48ff7812ULL, 0x000fc4000780c0ffULL,
0x0000008011117811ULL, 0x000fe400078e30ffULL, 0x00000001ff637807ULL, 0x000fe40000800000ULL,
0x000000401100720cULL, 0x000fe40003f26070ULL, 0x00000001033f7812ULL, 0x000fe4000784c0ffULL,
0x00000001ff3d7807ULL, 0x000fe40004000000ULL, 0x00000060633c7207ULL, 0x000fce0005000000ULL,
0x000036a000001947ULL, 0x000fea0003800000ULL, 0x0000240005117984ULL, 0x008ee20000000800ULL,
0x00000001ff107807ULL, 0x000fca0004000000ULL, 0x80000000100a7824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x008fe2000782480aULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000240005117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x008fe4000782480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000010117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a00107305ULL, 0x000724000021f000ULL,
0x3fa000000a0a7823ULL, 0x008fe200000100ffULL, 0x000000100000735dULL, 0x010fe40003800000ULL,
0x0000240005107984ULL, 0x000ee40000000800ULL, 0x8000000010ff7812ULL, 0x008fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff0a7819ULL, 0x000fe20000011641ULL, 0x00000080ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000000142147810ULL, 0x000fe40007ffe0ffULL, 0x00000003ff197819ULL, 0x000fe2000001160eULL,
0x000000200a107824ULL, 0x000fe200078e025bULL, 0x0000000f1400720cULL, 0x000fe40003f26070ULL,
0x00000004193f7810ULL, 0x000fe40007ffe0ffULL, 0x000000c010107810ULL, 0x000fc40007ffe0ffULL,
0x00000008193d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001040117217ULL, 0x000fe20007800000ULL,
0x000062000b127a24ULL, 0x000fe200078e0210ULL, 0x0000000c191b7810ULL, 0x000fc60007ffe0ffULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x0000001912107210ULL, 0x140fe40007ffe009ULL,
0x0000003f12157210ULL, 0x100fe40007ffe009ULL, 0x0000002011147807ULL, 0x000fe20000800000ULL,
0x00005e0010107625ULL, 0x000fe200078e001aULL, 0x0000003d12137210ULL, 0x000fe40007ffe009ULL,
0x0000001409187217ULL, 0x000fe20007800000ULL, 0x00005e0015147625ULL, 0x000fe200078e001aULL,
0x0000004610167210ULL, 0x000fc40007f3e0ffULL, 0x0000001b12107210ULL, 0x100fe20007ffe009ULL,
0x0000000118187824ULL, 0x000fe200078e0a09ULL, 0x0000004614147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400008e0611ULL, 0x00005e0013127625ULL, 0x000fe200078e001aULL,
0x000000181900720cULL, 0x080fe40003f46070ULL, 0x000000183f00720cULL, 0x000fe20003f26070ULL,
0x00005e0010107625ULL, 0x000fe200078e001aULL, 0x000000181b00720cULL, 0x000fc40003f86070ULL,
0x0000004612127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x000000183d00720cULL, 0x000fe40003f66070ULL, 0x0000004610107210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000000861197812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000165a7faeULL, 0x0007e4000d101c48ULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x0000000014597faeULL, 0x0007e2000c901c48ULL,
0x000000100a187824ULL, 0x000fc600078e0219ULL, 0x0000000012587faeULL, 0x0007e8000d901c48ULL,
0x0000000010577faeULL, 0x0007e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f64c0018117984ULL, 0x0087220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c0002127984ULL, 0x000f620000000800ULL, 0x0000000103ff7812ULL, 0x000fe2000782c0ffULL,
0x8000000047137824ULL, 0x000fc600078e00ffULL, 0x0000006063577207ULL, 0x000fc80004800000ULL,
0x0000ffff57107812ULL, 0x000fc800078ec0ffULL, 0x0000888010107816ULL, 0x000fca00000000ffULL,
0x8000000010107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x010fe40007844810ULL,
0x8000000012ff7812ULL, 0x020fe20007864813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x0000000441027824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000047127824ULL, 0x000fe200078e00ffULL,
0xfffffff002027812ULL, 0x000fe400078ec0ffULL, 0x0000001000117305ULL, 0x000964000021f000ULL,
0x3fa0000010107823ULL, 0x010fe200000100ffULL, 0x000000110000735dULL, 0x020fe40003800000ULL,
0x00f62c0002117984ULL, 0x000f240000000800ULL, 0x8000000011ff7812ULL, 0x010fc40007864812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000010046107810ULL, 0x000fe20007ffe04bULL, 0x00000001ff727424ULL, 0x000fc800078e00ffULL,
0x0000000149107824ULL, 0x000fca00078e0210ULL, 0x00f0000010127984ULL, 0x000f280000000800ULL,
0x00f2000010117984ULL, 0x0002a20000000800ULL, 0x000000071200720bULL, 0x010fda0003f7d000ULL,
0x0000000000137806ULL, 0x000fc800018e0100ULL, 0x0000ffff13167812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000071200720bULL, 0x006fe40003f74000ULL,
0x0000001207147209ULL, 0x000fe40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001160eULL,
0x8000001407107221ULL, 0x040fe20000010000ULL, 0x0000001207077209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL, 0x0000000241107811ULL, 0x000fe400078ff0ffULL,
0x0000000000137806ULL, 0x000fe400018e0100ULL, 0x000000411000720cULL, 0x000fe20003f65270ULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x0000ffff13137812ULL, 0x000fc800078e3cffULL,
0x0000001316ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff727807ULL, 0x000fc60002000000ULL,
0x000000804118b824ULL, 0x008fc800078e0246ULL, 0x000000014917b824ULL, 0x000fe200078e0218ULL,
0x00001f1a15107589ULL, 0x002e6200000e0000ULL, 0x8000001412164221ULL, 0x000fe20000010000ULL,
0x0000001506067220ULL, 0x000fe40000410000ULL, 0x00001f4415137589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b16164820ULL, 0x000fc60000410000ULL, 0x00f400141700b388ULL, 0x0007e20000000800ULL,
0x0000001600004308ULL, 0x000f220000000800ULL, 0x0000001020207220ULL, 0x082fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x000fe20000410000ULL, 0x0000001322227220ULL, 0x084fe20000410000ULL,
0x0000001323237220ULL, 0x080fe20000410000ULL, 0x0000001326267220ULL, 0x080fe20000410000ULL,
0x0000001327277220ULL, 0x080fe20000410000ULL, 0x000000132a2a7220ULL, 0x080fe20000410000ULL,
0x000000132b2b7220ULL, 0x080fe20000410000ULL, 0x000000132e2e7220ULL, 0x080fe20000410000ULL,
0x000000132f2f7220ULL, 0x080fe20000410000ULL, 0x0000001332327220ULL, 0x080fe20000410000ULL,
0x0000001333337220ULL, 0x080fe20000410000ULL, 0x0000001336367220ULL, 0x080fe20000410000ULL,
0x0000001337377220ULL, 0x080fe20000410000ULL, 0x000000133a3a7220ULL, 0x080fe20000410000ULL,
0x000000133b3b7220ULL, 0x080fe20000410000ULL, 0x000000131e1e7220ULL, 0x080fe20000410000ULL,
0x000000131f1f7220ULL, 0x000fe20000410000ULL, 0x0000001100114220ULL, 0x010fc80000410000ULL,
0x0000000611067221ULL, 0x00efe20000010000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x0000000841107824ULL, 0x000fe200078e00ffULL, 0x0000000861127812ULL, 0x000fc400078ec0ffULL,
0x0000000103ff7812ULL, 0x000fe4000784c0ffULL, 0xfffffff010117812ULL, 0x000fe400078ec0ffULL,
0x0000006063607207ULL, 0x000fc60005000000ULL, 0x0000000112127824ULL, 0x000fe200078e0211ULL,
0x0000ffff60607812ULL, 0x000fc800078ec0ffULL, 0x00f64c0012117984ULL, 0x000e620000000800ULL,
0x0000888060137816ULL, 0x000fca00000000ffULL, 0x8000000013107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000013147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x00f64c0012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00001000623d7812ULL, 0x000fe200078ec0ffULL, 0x0000100041187824ULL, 0x000fe200078e00ffULL,
0x00000002ff7a7819ULL, 0x000fe4000001160eULL, 0x0000b00008147810ULL, 0x100fe40007ffe03dULL,
0xffffe00018187812ULL, 0x000fe400078ec0ffULL, 0x0000991072767816ULL, 0x000fe200000000ffULL,
0x000000105e107824ULL, 0x100fe200078e0214ULL, 0x0000b000183d7810ULL, 0x000fe20007ffe03dULL,
0x000000105d147824ULL, 0x000fe200078e0214ULL, 0x000000ff7600720cULL, 0x000fc60003f45270ULL,
0x000000001010783bULL, 0x000e620000004200ULL, 0x000000104e187824ULL, 0x100fe400078e023dULL,
0x000000104c3d7824ULL, 0x000fe200078e023dULL, 0x000000001414783bULL, 0x000fe80000004200ULL,
0x000000001818783bULL, 0x000fe80000004200ULL, 0x000000003d3c783bULL, 0x000ea20000004200ULL,
0x00000018ff647819ULL, 0x002fe20000011410ULL, 0x00000100105d7824ULL, 0x040fe200078e00ffULL,
0x00008880106f7816ULL, 0x040fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011411ULL, 0x00000100115e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x00008880116b7816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011413ULL,
0x000001003c7f7824ULL, 0x004fe200078e00ffULL, 0x0000888013627816ULL, 0x000fe200000000ffULL,
0x00000010006d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x000100003d797824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011412ULL,
0x000001003e767824ULL, 0x000fe200078e00ffULL, 0x0000888012697816ULL, 0x000fc400000000ffULL,
0x00000018ff887819ULL, 0x000fe20000011418ULL, 0x0000005d006e7306ULL, 0x0005e20000200c00ULL,
0x0000010013107824ULL, 0x042fe200078e00ffULL, 0x0000888018787816ULL, 0x000fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011419ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000011006a7306ULL, 0x0003e20000200c00ULL,
0x00000100125d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001141aULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000001000677306ULL, 0x0005e20000200c00ULL,
0x0000010014117824ULL, 0x002fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff7b7819ULL, 0x000fe4000001141bULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000005d00687306ULL, 0x0003e20000200c00ULL, 0x0000010015107824ULL, 0x004fe200078e00ffULL,
0x000088801a877816ULL, 0x000fc400000000ffULL, 0x000088801b847816ULL, 0x040fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe4000001143cULL, 0x0000001300657306ULL, 0x0005e20000200c00ULL,
0x00000018ff5d7819ULL, 0x002fe20000011410ULL, 0x0000010018107824ULL, 0x000fe200078e00ffULL,
0x000088803c807816ULL, 0x000fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001200667306ULL, 0x0003e20000200c00ULL,
0x00000018ff137819ULL, 0x004fe20000011418ULL, 0x000001001b187824ULL, 0x040fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001143cULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088803e3c7816ULL, 0x000fc400000000ffULL, 0x00000018ff857819ULL, 0x000fe20000011418ULL,
0x00000011005f7306ULL, 0x0005e20000200c00ULL, 0x0000010019127824ULL, 0x002fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe4000001141bULL, 0x000088803d7d7816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011412ULL, 0x0000001000897306ULL, 0x0003e20000200c00ULL,
0x0000888019117816ULL, 0x044fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fc4000001143dULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000018ff127819ULL, 0x000fe20000011419ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000001001a107824ULL, 0x042fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe2000001143eULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff837819ULL, 0x000fe2000001141aULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x00a000004518783bULL, 0x000fe20000000200ULL, 0x00000018ff597819ULL, 0x000fc40000011414ULL,
0x0000888014607816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000001000867306ULL, 0x0003e20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff587819ULL, 0x000fe40000011415ULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x00000000ff10723eULL, 0x002fc400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011416ULL, 0x0000541010777816ULL, 0x000fe20000000010ULL,
0x000001003d107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011417ULL,
0x0000008800887306ULL, 0x000fe40000200c00ULL, 0x00001f7a77737589ULL, 0x000e6200000e0000ULL,
0x00000018ff107819ULL, 0x000fc60000011410ULL, 0x00001f4477727589ULL, 0x00072400000e0000ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541011117816ULL, 0x004fce000000008aULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x000000ffff777224ULL, 0x008fe200078e003cULL,
0x000088803f3c7816ULL, 0x000fcc00000000ffULL, 0x0000001200127306ULL, 0x000fe20000200c00ULL,
0x000000731818a232ULL, 0x082fe40000000000ULL, 0x000000731a1aa232ULL, 0x000fe40000000000ULL,
0x000000721919a232ULL, 0x010fc60000000000ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000000721b1ba232ULL, 0x000fce0000000000ULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x00000010007e7306ULL, 0x0005f00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541078107816ULL, 0x004fe20000000089ULL,
0x000000ffff787224ULL, 0x000fe200078e003cULL, 0x00005410843d7816ULL, 0x002fe20000000085ULL,
0x000001003f3c7824ULL, 0x000fc400078e00ffULL, 0x000100003f3f7824ULL, 0x000fe400078e00ffULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000101820723cULL, 0x000fe20000001820ULL, 0x00000018ff3f7819ULL, 0x000fca000001143fULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541013107816ULL, 0x000fe40000000088ULL,
0x0000541012117816ULL, 0x000fca0000000081ULL, 0x0000008200827306ULL, 0x000ea40000200c00ULL,
0x000000101824723cULL, 0x000fe20000001824ULL, 0x00a000004310783bULL, 0x000eea0000000200ULL,
0x0000003c00817306ULL, 0x0009f00000200c00ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x00005410873c7816ULL, 0x010fce0000000086ULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x0000003c1828723cULL, 0x000fee0000001828ULL, 0x0000007d007d7306ULL, 0x000f620000200c00ULL,
0x00005410833c7816ULL, 0x002fe4000000007cULL, 0x00005410823d7816ULL, 0x004fca000000007bULL,
0x0000007500757306ULL, 0x000fe40000200c00ULL, 0x0000003c182c723cULL, 0x000fe2000000182cULL,
0x000000731010a232ULL, 0x088fe40000000000ULL, 0x000000731212a232ULL, 0x000fe40000000000ULL,
0x000000721111a232ULL, 0x080fe20000000000ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00005410803c7816ULL, 0x010fe2000000007fULL, 0x000000721313a232ULL, 0x000fe20000000000ULL,
0x000054107d3d7816ULL, 0x020fca000000007eULL, 0x0000008b007a7306ULL, 0x000fe40000200c00ULL,
0x0000003c1830723cULL, 0x000fec0000001830ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x00010000153c7824ULL, 0x000fce00078e00ffULL, 0x0000007100717306ULL, 0x000ff00000200c00ULL,
0x0000007000707306ULL, 0x000ff00000200c00ULL, 0x0000003e00847306ULL, 0x000eb00000200c00ULL,
0x0000003f007b7306ULL, 0x000ef00000200c00ULL, 0x0000005e006c7306ULL, 0x0009f00000200c00ULL,
0x00000014003e7306ULL, 0x000be20000200c00ULL, 0x00008880155e7816ULL, 0x010fc400000000ffULL,
0x0000541079157816ULL, 0x002fe40000000074ULL, 0x0000888016747816ULL, 0x000fc600000000ffULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x000054107a147816ULL, 0x020fce0000000075ULL,
0x0000006b006b7306ULL, 0x000f220000200c00ULL, 0x000000141834723cULL, 0x000fee0000001834ULL,
0x00000018ff157819ULL, 0x000fe2000001143cULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541084147816ULL, 0x004fce0000000071ULL, 0x00000015003f7306ULL, 0x0007f00000200c00ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x000054107b157816ULL, 0x008fce0000000070ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00000014181c723cULL, 0x000fee000000181cULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0x000054106f147816ULL, 0x002fe4000000006eULL,
0x000054106b157816ULL, 0x010fca000000006cULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x00005410773c7816ULL, 0x004fe20000000076ULL, 0x000000141020723cULL, 0x000fec0000001820ULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000054106d147816ULL, 0x000fe40000000064ULL,
0x000054106a157816ULL, 0x000fc40000000061ULL, 0x00005410783d7816ULL, 0x008fc60000000081ULL,
0x0000005b005b7306ULL, 0x000ee40000200c00ULL, 0x000000141024723cULL, 0x000fec0000001824ULL,
0x0000005a005a7306ULL, 0x000f220000200c00ULL, 0x0000541069147816ULL, 0x002fe20000000068ULL,
0x0000003c1838723cULL, 0x000fe20000001838ULL, 0x0000541062157816ULL, 0x004fca0000000067ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x00000100163d7824ULL, 0x040fe200078e00ffULL,
0x000000141028723cULL, 0x000fe20000001828ULL, 0x00000100171a7824ULL, 0x040fe200078e00ffULL,
0x0000888017187816ULL, 0x040fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe2000001143dULL, 0x000000ffff3c7224ULL, 0x000fe200078e0074ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0001000017147824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff3d7819ULL, 0x000fe40000011414ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000541066147816ULL, 0x008fe4000000005bULL, 0x0000541065157816ULL, 0x010fca000000005aULL,
0x0000005900597306ULL, 0x000ee40000200c00ULL, 0x00000014102c723cULL, 0x000fec000000182cULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x0000541060147816ULL, 0x002fe4000000005fULL,
0x000054105e157816ULL, 0x004fca000000005dULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000054103e3e7816ULL, 0x008fe20000000059ULL, 0x000000141030723cULL, 0x000fec0000001830ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000054103f3f7816ULL, 0x010fce0000000058ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000003e1034723cULL, 0x000fee0000001834ULL,
0x0000001900197306ULL, 0x000e700000200c00ULL, 0x0000001800187306ULL, 0x000ff00000200c00ULL,
0x0000001a001b7306ULL, 0x0002b00000200c00ULL, 0x0000001600177306ULL, 0x000ee20000200c00ULL,
0x000054103c1a7816ULL, 0x002fc40000000019ULL, 0x00000002ff197819ULL, 0x000fca0000011641ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00005410181b7816ULL, 0x004fe4000000001bULL,
0x0000541017147816ULL, 0x008fca000000004eULL, 0x0000001a1038723cULL, 0x000fe20000001838ULL,
0x000054103d157816ULL, 0x002fce000000004cULL, 0x00000014101c723cULL, 0x000fee000000181cULL,
0x0000f63019107811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200005ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004019117824ULL, 0x000fe200078e0250ULL, 0x000000ff57ff7812ULL, 0x000fe2000784c0ffULL,
0x0000000010ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff48ff7812ULL, 0x000fc4000786c0ffULL,
0x000000c011117810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff487807ULL, 0x000fe40001000000ULL,
0x000000401100720cULL, 0x000fe40003f46070ULL, 0x00000001033f7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff3d7807ULL, 0x000fe40001800000ULL, 0x00000048633c7207ULL, 0x000fc40004800000ULL,
0x000000013f3f7812ULL, 0x000fca00078e3cffULL, 0x00001a9000002947ULL, 0x000fea0003800000ULL,
0x00002400050a7984ULL, 0x004ea20000000800ULL, 0x800000005c117824ULL, 0x000fca00078e00ffULL,
0x800000000aff7812ULL, 0x004fe20007844811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x00002400050a7984ULL, 0x000ea40000000800ULL,
0x800000000aff7812ULL, 0x004fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000005c117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a00107305ULL, 0x0004e4000021f000ULL,
0x3fa000000a0a7823ULL, 0x004fe200000100ffULL, 0x000000100000735dULL, 0x008fe40003800000ULL,
0x0000240005107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff0a7819ULL, 0x000fe20000011641ULL, 0x00000080ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000030042117a10ULL, 0x000fe40007ffe0ffULL, 0x00000003ff177819ULL, 0x000fe4000001160eULL,
0x0000000111127810ULL, 0x040fe20007ffe0ffULL, 0x0000000811107824ULL, 0x000fe200078e020aULL,
0x0000000417197810ULL, 0x040fe40007ffe0ffULL, 0x0000000f1200720cULL, 0x000fe20003f46070ULL,
0x0000002010107824ULL, 0x000fe200078e00ffULL, 0x00000008171b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c173d7810ULL, 0x000fe20007ffe0ffULL, 0x000062000b167a24ULL, 0x000fe200078e0210ULL,
0x0000001040117217ULL, 0x000fc80007800000ULL, 0x0000001916137210ULL, 0x140fe20007ffe009ULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x0000001716107210ULL, 0x140fe40007ffe009ULL,
0x0000001b16157210ULL, 0x100fe40007ffe009ULL, 0x0000002011127807ULL, 0x000fe20001000000ULL,
0x00005e0010107625ULL, 0x000fe200078e001aULL, 0x0000003d16167210ULL, 0x000fe40007ffe009ULL,
0x0000001209147217ULL, 0x000fe20007800000ULL, 0x00005e0013127625ULL, 0x000fe200078e001aULL,
0x0000004610107210ULL, 0x000fc60007f5e0ffULL, 0x0000000114187824ULL, 0x000fe200078e0a09ULL,
0x0000004612127210ULL, 0x000fe20007f9e0ffULL, 0x00005e0015147625ULL, 0x000fc600078e001aULL,
0x000000181900720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x0000004614147210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x000000181700720cULL, 0x000fe20003f46070ULL, 0x00005e0016167625ULL, 0x000fe200078e001aULL,
0x000000181b00720cULL, 0x000fc60003f86070ULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x000000183d00720cULL, 0x000fe40003fa6070ULL, 0x0000004616167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010557faeULL, 0x0005e8000d101c48ULL, 0x0000000012547faeULL, 0x0005e8000d901c48ULL,
0x0000000014537faeULL, 0x0005e8000e101c48ULL, 0x0000000016527faeULL, 0x0005e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040056117984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f63c0002127984ULL, 0x000f220000000800ULL,
0x0000004863637207ULL, 0x000fe20004800000ULL, 0x8000000047137824ULL, 0x000fc600078e00ffULL,
0x0000ffff63147812ULL, 0x000fca00078ec0ffULL, 0x8000000014107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x008fe40007844810ULL, 0x8000000012ff7812ULL, 0x010fe20007864813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000003947ULL, 0x000fea0003800000ULL,
0x8000000047127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x000724000021f000ULL, 0x3fa0000010107823ULL, 0x008fe200000100ffULL,
0x000000110000735dULL, 0x010fe40003800000ULL, 0x00f63c0002117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x008fc40007864812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x0000018046107810ULL, 0x000fe20007ffe04bULL,
0x00000001ff557424ULL, 0x000fc800078e00ffULL, 0x0000000149107824ULL, 0x000fca00078e0210ULL,
0x00f0000010127984ULL, 0x000ee80000000800ULL, 0x00f2000010117984ULL, 0x0008620000000800ULL,
0x000000071200720bULL, 0x008fda0003f7d000ULL, 0x0000000000137806ULL, 0x000fc800018e0100ULL,
0x0000ffff13157812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000071200720bULL, 0x012fe40003f74000ULL, 0x0000001207177209ULL, 0x000fe40007810000ULL,
0x00000002ff187819ULL, 0x000fc6000001160eULL, 0x8000001707107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL, 0x0000000341107811ULL, 0x000fe400078ff0ffULL,
0x0000000000077806ULL, 0x000fe400018e0100ULL, 0x000000411000720cULL, 0x000fe20003f65270ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000ffff07167812ULL, 0x000fc800078e3cffULL,
0x0000001615ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff557807ULL, 0x000fc60002000000ULL,
0x000000804146b824ULL, 0x000fe200078e0246ULL, 0x00001f1813077589ULL, 0x002e6600000e0000ULL,
0x000000014946b824ULL, 0x000fe400078e0246ULL, 0x8000001712124221ULL, 0x000fe20000010000ULL,
0x0000001306067220ULL, 0x000fe20000410000ULL, 0x00001f4413107589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b12124820ULL, 0x000fc40000410000ULL, 0x00f400174600b388ULL, 0x0009e40000000800ULL,
0x0000001200004308ULL, 0x000f620000000800ULL, 0x0000000720207220ULL, 0x082fe20000410000ULL,
0x0000000721217220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x080fe20000410000ULL, 0x0000000730307220ULL, 0x080fe20000410000ULL,
0x0000000731317220ULL, 0x080fe20000410000ULL, 0x0000000734347220ULL, 0x080fe20000410000ULL,
0x0000000735357220ULL, 0x080fe20000410000ULL, 0x0000000738387220ULL, 0x080fe20000410000ULL,
0x0000000739397220ULL, 0x080fe20000410000ULL, 0x000000071c1c7220ULL, 0x080fe20000410000ULL,
0x000000071d1d7220ULL, 0x000fe20000410000ULL, 0x0000001022227220ULL, 0x088fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x000fe20000410000ULL, 0x000000ffff077224ULL, 0x000fe200078e0017ULL,
0x0000001100114220ULL, 0x020fc80000410000ULL, 0x0000000611067221ULL, 0x012fe20000010000ULL,
0x0000013000002947ULL, 0x000fea0003800000ULL, 0x0000000803107824ULL, 0x000fe400078e00ffULL,
0x0000000841117824ULL, 0x000fc600078e00ffULL, 0x0000000810107812ULL, 0x000fe400078e0cffULL,
0xfffffff011117812ULL, 0x000fca00078ec0ffULL, 0x0000000110127824ULL, 0x000fe400078e0211ULL,
0x8000000014117824ULL, 0x000fc600078e00ffULL, 0x00f64c0012107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000014147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002e4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x008fe40003800000ULL,
0x00f64c0012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000005118783bULL, 0x000e620000004200ULL, 0x00000000ff58723eULL, 0x000fe400000000ffULL,
0x00000002ff597819ULL, 0x000fe2000001160eULL, 0x000000004f3c783bULL, 0x000ee20000004200ULL,
0x0000541058587816ULL, 0x000fc60000000058ULL, 0x000000004d10783bULL, 0x000f280000004200ULL,
0x000000004a14783bULL, 0x000aa80000004200ULL, 0x00001f5958597589ULL, 0x000fe800000e0000ULL,
0x00001f44585c7589ULL, 0x000fe200000e0000ULL, 0x00000018ff727819ULL, 0x002fe20000011418ULL,
0x0000010018517824ULL, 0x040fe200078e00ffULL, 0x0000888018777816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011419ULL,
0x0000010019527824ULL, 0x040fe200078e00ffULL, 0x00008880195a7816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000018ff517819ULL, 0x000fc40000011451ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff6e7819ULL, 0x000fe4000001141aULL,
0x00000018ff6d7819ULL, 0x000fe2000001141bULL, 0x0000001800737306ULL, 0x0003e20000200c00ULL,
0x00000018ff647819ULL, 0x008fe4000001143cULL, 0x000088801a717816ULL, 0x000fe400000000ffULL,
0x000088801b577816ULL, 0x000fc400000000ffULL, 0x000088803c6c7816ULL, 0x040fe200000000ffULL,
0x0000001900747306ULL, 0x0007e20000200c00ULL, 0x000001001b187824ULL, 0x042fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001143dULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088803d697816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000005100767306ULL, 0x0003e20000200c00ULL, 0x000001003c197824ULL, 0x048fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x010fc40000011411ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001800667306ULL, 0x0007e20000200c00ULL, 0x000001001a517824ULL, 0x042fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011410ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000019006b7306ULL, 0x0003e20000200c00ULL, 0x000001003d187824ULL, 0x048fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000003c00677306ULL, 0x000fe20000200c00ULL, 0x000001003e197824ULL, 0x002fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff507819ULL, 0x000fe4000001143eULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc4000001143fULL, 0x000088803e627816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f5b7816ULL, 0x040fe400000000ffULL,
0x00000018ff4a7819ULL, 0x020fe20000011412ULL, 0x0000001900617306ULL, 0x0007e20000200c00ULL,
0x000001003f187824ULL, 0x042fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011413ULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x0000001a006f7306ULL, 0x000fe20000200c00ULL,
0x0000010010197824ULL, 0x008fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff497819ULL, 0x004fe40000011414ULL, 0x00000018ff3c7819ULL, 0x000fe40000011419ULL,
0x0000001800607306ULL, 0x0003e20000200c00ULL, 0x0000888014787816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fc40000011415ULL, 0x00000018ff467819ULL, 0x000fe40000011416ULL,
0x00000018ff4b7819ULL, 0x000fe20000011417ULL, 0x0000001b00707306ULL, 0x0005e20000200c00ULL,
0x0000010011187824ULL, 0x002fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011418ULL,
0x0000005100567306ULL, 0x0003e20000200c00ULL, 0x00a800004518783bULL, 0x0044ee0000000200ULL,
0x0000003d00687306ULL, 0x0009e20000200c00ULL, 0x0000888011517816ULL, 0x042fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000888013457816ULL, 0x004fc800000000ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00008880103d7816ULL, 0x050fe200000000ffULL, 0x0001000010107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001100537306ULL, 0x0003f00000200c00ULL,
0x0000005200757306ULL, 0x000ea20000200c00ULL, 0x0000991055117816ULL, 0x002fc800000000ffULL,
0x000000ff1100720cULL, 0x000fc60003f45270ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x0000005700577306ULL, 0x000f220000200c00ULL, 0x000054105a117816ULL, 0x004fe20000000075ULL,
0x000000591818a232ULL, 0x088fe20000000000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0078ULL,
0x000000591a1aa232ULL, 0x000fc40000000000ULL, 0x0000005c1919a232ULL, 0x080fe40000000000ULL,
0x0000001000527306ULL, 0x0005e20000200c00ULL, 0x0000005c1b1ba232ULL, 0x000fe20000000000ULL,
0x0000541071567816ULL, 0x002fe20000000056ULL, 0x0000010015717824ULL, 0x000fca00078e00ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000010013107824ULL, 0x004fe200078e00ffULL,
0x0000541057577816ULL, 0x010fe20000000066ULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x000000561828723cULL, 0x000fe20000001828ULL, 0x00000018ff137819ULL, 0x000fcc0000011413ULL,
0x0000006e006e7306ULL, 0x000e700000200c00ULL, 0x0000006d006d7306ULL, 0x000eb00000200c00ULL,
0x0000003e005f7306ULL, 0x000fe20000200c00ULL, 0x000054106f567816ULL, 0x002fce000000006eULL,
0x0000003f005e7306ULL, 0x000fe20000200c00ULL, 0x0000541070577816ULL, 0x004fce000000006dULL,
0x00000051003e7306ULL, 0x0003e20000200c00ULL, 0x00000056182c723cULL, 0x000fee000000182cULL,
0x00000054003f7306ULL, 0x0005e20000200c00ULL, 0x0000888012517816ULL, 0x002fce00000000ffULL,
0x0000001000447306ULL, 0x0003e20000200c00ULL, 0x0000010012547824ULL, 0x044fe400078e00ffULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0000541077107816ULL, 0x002fe40000000076ULL,
0x00000018ff127819ULL, 0x000fca0000011412ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000000101820723cULL, 0x000fee0000001820ULL, 0x0000541073107816ULL, 0x000fe20000000072ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541074117816ULL, 0x000fc40000000065ULL,
0x000054106c567816ULL, 0x004fe4000000006bULL, 0x0000888015727816ULL, 0x000fe400000000ffULL,
0x0000541069577816ULL, 0x002fe2000000006aULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x000000101824723cULL, 0x000fe20000001824ULL, 0x000000ffff667224ULL, 0x000fcc00078e0072ULL,
0x0000001200557306ULL, 0x0005e20000200c00ULL, 0x000000561830723cULL, 0x000fee0000001830ULL,
0x0000001300587306ULL, 0x0007e20000200c00ULL, 0x0000010014127824ULL, 0x044fe400078e00ffULL,
0x0001000014147824ULL, 0x000fc400078e00ffULL, 0x0001000015567824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011412ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x00a800004310783bULL, 0x0087220000000200ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000541068157816ULL, 0x002fe4000000005dULL, 0x00008880165d7816ULL, 0x000fe400000000ffULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x00000018ff437819ULL, 0x008fce0000011471ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000054105b577816ULL, 0x004fce0000000060ULL,
0x0000006200627306ULL, 0x000e700000200c00ULL, 0x00000014006a7306ULL, 0x0005f00000200c00ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x004fe20000000064ULL,
0x000000591010a232ULL, 0x010fc40000000000ULL, 0x000000591212a232ULL, 0x000fe40000000000ULL,
0x0000005c1111a232ULL, 0x080fe40000000000ULL, 0x000000141834723cULL, 0x000fe20000001834ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000005c1313a232ULL, 0x000fca0000000000ULL,
0x00000018ff157819ULL, 0x000fe40000011456ULL, 0x0000541062567816ULL, 0x002fe20000000061ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x000054105f147816ULL, 0x000fe20000000050ULL,
0x0000010016507824ULL, 0x040fe400078e00ffULL, 0x0001000016167824ULL, 0x000fe400078e00ffULL,
0x000000561838723cULL, 0x000fe40000001838ULL, 0x00000015005b7306ULL, 0x0005e20000200c00ULL,
0x00000018ff167819ULL, 0x000fce0000011416ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054105e157816ULL, 0x004fe2000000004fULL, 0x000000ffff4f7224ULL, 0x000fcc00078e005dULL,
0x00000014181c723cULL, 0x000fe2000000181cULL, 0x0000004d004d7306ULL, 0x000eac0000200c00ULL,
0x0000010017187824ULL, 0x040fe200078e00ffULL, 0x0000888017157816ULL, 0x040fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000541045197816ULL, 0x002fe20000000044ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff147819ULL, 0x000fe40000011450ULL, 0x00000018ff1b7819ULL, 0x000fe40000011417ULL,
0x0000541058177816ULL, 0x004fe2000000004dULL, 0x00000018001a7306ULL, 0x0005f00000200c00ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541051187816ULL, 0x004fc40000000054ULL,
0x0000541052527816ULL, 0x002fca0000000047ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x000000181028723cULL, 0x000fee0000001828ULL, 0x0000005a005a7306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000054103d3c7816ULL, 0x002fc4000000003cULL,
0x000054103e3d7816ULL, 0x000fca000000003fULL, 0x0000004e004e7306ULL, 0x000e640000200c00ULL,
0x0000003c1020723cULL, 0x000fec0000001820ULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x0000541053537816ULL, 0x002fce000000004eULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000521024723cULL, 0x000fee0000001824ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000054105b5b7816ULL, 0x004fce000000004cULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000001400147306ULL, 0x000e700000200c00ULL,
0x0000001500157306ULL, 0x000eb00000200c00ULL, 0x0000001600197306ULL, 0x0007220000200c00ULL,
0x000054104f147816ULL, 0x002fce0000000014ULL, 0x0000001b00187306ULL, 0x000e620000200c00ULL,
0x0000541055167816ULL, 0x008fe4000000004aULL, 0x0000541015157816ULL, 0x004fca000000001aULL,
0x00000016102c723cULL, 0x000fe2000000182cULL, 0x0000541019467816ULL, 0x010fcc0000000046ULL,
0x000054105a167816ULL, 0x000fe20000000065ULL, 0x000000141038723cULL, 0x000fe20000001838ULL,
0x0000541066177816ULL, 0x000fe40000000043ULL, 0x000054106a5a7816ULL, 0x000fe40000000049ULL,
0x0000541018477816ULL, 0x002fc6000000004bULL, 0x000000161030723cULL, 0x040ff00000001830ULL,
0x0000005a1034723cULL, 0x040ff00000001834ULL, 0x00000046101c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200005ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400002ff7f8cULL, 0x0005e2000c80043fULL, 0x0000991063107816ULL, 0x000fc400000000ffULL,
0x00000001ff3d7807ULL, 0x000fe40004000000ULL, 0x000000ff1000720cULL, 0x000fe40003f45270ULL,
0x00000001033f7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff489807ULL, 0x000fc80001000000ULL,
0x00007610483c7816ULL, 0x000fe4000000003cULL, 0x0000030042427a10ULL, 0x00cfe40007ffe0ffULL,
0x000000ff04ff7812ULL, 0x000fe4000780c0ffULL, 0x0000000f4200720cULL, 0x000fe40003f26070ULL,
0x00000001ff047807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff8af000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea40000002500ULL,
0x000000040f007c0cULL, 0x004fda000bf03070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000082d000047802ULL, 0x000fe40000000f00ULL,
0x0000892000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e000cULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000600037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000006ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000097919ULL, 0x000f220000000000ULL, 0x00000002ff0c7819ULL, 0x008fe40000011604ULL,
0x0000000809047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0c05007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000002000207220ULL, 0x044fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x000fe20000410000ULL,
0x0000002204227220ULL, 0x048fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000002c2d2c723eULL, 0x000fc400000000ffULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000343518723eULL, 0x000fe400000000ffULL, 0x000000383938723eULL, 0x000fe400000000ffULL,
0x0000001c1d1c723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fc400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x0000003a3b3a723eULL, 0x000fe400000000ffULL, 0x0000001e1f1d723eULL, 0x000fe400000000ffULL,
0x0000000203007812ULL, 0x002fe400078ec0ffULL, 0x00000002ff137819ULL, 0x000fe40000011603ULL,
0x00000004000c7811ULL, 0x000fc400078ff8ffULL, 0x0000000200047811ULL, 0x000fe400078ff8ffULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x000000070c0b7812ULL, 0x100fe400078e7813ULL,
0x0000000704097812ULL, 0x000fe400078e7813ULL, 0x00000008031b7811ULL, 0x000fe200078ff0ffULL,
0x0000000813117824ULL, 0x000fe200078e020bULL, 0x00000006000e7811ULL, 0x000fe200078ff8ffULL,
0x000010000d0b7824ULL, 0x000fe200078e00ffULL, 0x0000000702007812ULL, 0x000fe200078e7813ULL,
0x00000008130f7824ULL, 0x000fe200078e0209ULL, 0x000000070c0c7812ULL, 0x100fe200078e781bULL,
0x0000000803097824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x100fe200078e781bULL,
0x0000000813057824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e781bULL,
0x000008000a007824ULL, 0x000fe200078e020bULL, 0x000000070e107812ULL, 0x040fe200078e7813ULL,
0x000000081b197824ULL, 0x000fe200078e020cULL, 0x00000008090c7812ULL, 0x000fe200078ec0ffULL,
0x000000081b157824ULL, 0x000fe200078e0202ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x000000070e0e7812ULL, 0x000fe200078e781bULL,
0x000000081b177824ULL, 0x000fe200078e0204ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x000fc400078e0200ULL, 0x0000000105097824ULL, 0x000fe200078e020cULL,
0x000000282905723eULL, 0x000fe200000000ffULL, 0x0000000813137824ULL, 0x000fe200078e0210ULL,
0x0000541002147816ULL, 0x000fe20000000004ULL, 0x000000100f0f7824ULL, 0x000fe400078e0200ULL,
0x000000010c107824ULL, 0x000fe200078e0215ULL, 0x0000763202157816ULL, 0x000fe20000000004ULL,
0x000000010c0f7824ULL, 0x000fe200078e020fULL, 0x0000541005047816ULL, 0x000fe2000000002cULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x0000763205057816ULL, 0x000fe2000000002cULL,
0x0000001409007388ULL, 0x0003e20000000a00ULL, 0x000000081b1b7824ULL, 0x000fc400078e020eULL,
0x000000010c0e7824ULL, 0x040fe200078e0211ULL, 0x000000040f007388ULL, 0x0005e20000000a00ULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x000000262711723eULL, 0x000fe200000000ffULL,
0x0000001019197824ULL, 0x100fe400078e0200ULL, 0x000000010c137824ULL, 0x040fe400078e0213ULL,
0x000000010c127824ULL, 0x000fe200078e0219ULL, 0x0000002e2f15723eULL, 0x002fe200000000ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x000000363719723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0200ULL, 0x0000541030047816ULL, 0x104fe20000000018ULL,
0x000000010c177824ULL, 0x000fe200078e0217ULL, 0x0000763230057816ULL, 0x000fe20000000018ULL,
0x000000010c1b7824ULL, 0x000fe200078e021bULL, 0x000054102a147816ULL, 0x000fc40000000015ULL,
0x000076322a157816ULL, 0x000fe20000000015ULL, 0x000000040e007388ULL, 0x0003e20000000a00ULL,
0x0000541032187816ULL, 0x140fe40000000019ULL, 0x0000763232197816ULL, 0x000fe40000000019ULL,
0x0000541038047816ULL, 0x142fe4000000001cULL, 0x0000763238057816ULL, 0x000fca000000001cULL,
0x0000000413007388ULL, 0x0003e40000000a00ULL, 0x0000541022047816ULL, 0x142fe40000000011ULL,
0x0000763222057816ULL, 0x000fe20000000011ULL, 0x000000200a117824ULL, 0x000fc800078e0203ULL,
0x0000000410007388ULL, 0x0003e20000000a00ULL, 0x0000001011097824ULL, 0x000fc600078e020bULL,
0x0000001417007388ULL, 0x000fe80000000a00ULL, 0x0000001812007388ULL, 0x000fe20000000a00ULL,
0x000054103a047816ULL, 0x142fe4000000001dULL, 0x000076323a057816ULL, 0x000fca000000001dULL,
0x000000041b007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000009147984ULL, 0x000e680000000c00ULL, 0x00080000091c7984ULL, 0x000ea80000000c00ULL,
0x0004000009207984ULL, 0x000ee80000000c00ULL, 0x000c000009247984ULL, 0x000f220000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x0000001f17177230ULL, 0x004fe20000000000ULL, 0x00000300ff1f7624ULL, 0x000fe200078e00ffULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000011f00780cULL, 0x000fe20003f05270ULL, 0x200000ff23237230ULL, 0x008fe40000000000ULL,
0x200000ff22227230ULL, 0x000fc40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001e16167230ULL, 0x000fe40000000000ULL,
0x0000001d15157230ULL, 0x000fe40000000000ULL, 0x0000001c14147230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x010fc40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x0000001409007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x0004002009007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000303000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7919ULL, 0x000ea20000002700ULL, 0x000058001f027a24ULL, 0x000fe200078e02ffULL,
0x000000010aff7812ULL, 0x000fe2000780f841ULL, 0x000008000d0c7824ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x0000640002127a24ULL, 0x000fe200078e02ffULL,
0x00000040111d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000009147984ULL, 0x0022e40000000c00ULL,
0x00000fff12027811ULL, 0x040fe400078e40ffULL, 0x0004000009187984ULL, 0x0003220000000c00ULL,
0x01ffffff12127812ULL, 0x000fe200078ec0ffULL, 0x000058001e1e7a24ULL, 0x004fe400078e0205ULL,
0x00001000ff057424ULL, 0x000fe400078e00ffULL, 0x000003001e137a24ULL, 0x000fca00078e02ffULL,
0x00000004130f7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000f02047211ULL, 0x000fca00078fa0ffULL,
0x00006a0004047625ULL, 0x000fca00078e0005ULL, 0x0000000c04047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x0000001011107825ULL, 0x000fc800078e0004ULL, 0x000000101d1c7825ULL, 0x000fe200078e0004ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x01afe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x000000010f0e7824ULL, 0x000fe200078e0212ULL, 0x0000007004217812ULL, 0x000fe400078ec0ffULL,
0x0000000c05207812ULL, 0x000fe200078ec0ffULL, 0x00006a000f047625ULL, 0x000fc800078e0009ULL,
0x00006a000e0e7625ULL, 0x000fe200078e0009ULL, 0x0000000420047210ULL, 0x000fc80007a1e021ULL,
0x0000000e200e7210ULL, 0x000fe40007c7e021ULL, 0x00000005ff057210ULL, 0x000fe400007e44ffULL,
0x0000000fff0f7210ULL, 0x000fc60001fe84ffULL, 0x0000000704007986ULL, 0x0003e8000c101908ULL,
0x000000060e007986ULL, 0x0003e4000c101908ULL, 0x0000001410007986ULL, 0x01a3e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x000000181c007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0xffffffff1f077810ULL, 0x000fc60007ffe0ffULL,
0x000068001e047625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000007040479a8ULL, 0x000ea400099ee1c8ULL,
0x000000070400720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x00000006ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff047984ULL, 0x000ee40000000000ULL, 0x000000ff0400720cULL, 0x008fda0003f05270ULL,
0x00002c6000008947ULL, 0x000fea0003800000ULL, 0x000000ff4100720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe20000011603ULL, 0x00000080ff177424ULL, 0x002fe200078e00ffULL,
0x0000000113067810ULL, 0x004fe40007ffe0ffULL, 0x0000007004197812ULL, 0x000fe400078ec0ffULL,
0x0000000c05187812ULL, 0x000fe200078ec0ffULL, 0x00006a0013047625ULL, 0x000fc800078e0017ULL,
0x00006a0006067625ULL, 0x000fe200078e0017ULL, 0x00000004180e7210ULL, 0x000fc8000791e019ULL,
0x0000000618067210ULL, 0x000fe40007b5e019ULL, 0x00000005ff0f7210ULL, 0x000fe400007e24ffULL,
0x00000007ff077210ULL, 0x000fc600017e64ffULL, 0x000000080e047981ULL, 0x000368000c1e1900ULL,
0x0000000806057981ULL, 0x000362000c1e1900ULL, 0x000000021f00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000213067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x0000000618067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fcc00007e24ffULL, 0x0000000806077981ULL, 0x000362000c1e1900ULL,
0x000000041f00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003130e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0017ULL,
0x0000000e180e7210ULL, 0x000fc8000791e019ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e097981ULL, 0x000362000c1e1900ULL, 0x000000041f00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004130e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0017ULL, 0x0000000e180e7210ULL, 0x000fc8000791e019ULL,
0x0000000fff0f7210ULL, 0x000fcc00007e24ffULL, 0x000000080e0f7981ULL, 0x000362000c1e1900ULL,
0x000000061f00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000513107810ULL, 0x002fca0007ffe0ffULL, 0x00006a0010107625ULL, 0x000fca00078e0017ULL,
0x0000001018107210ULL, 0x000fc8000791e019ULL, 0x00000011ff117210ULL, 0x000fcc00007e24ffULL,
0x0000000810117981ULL, 0x000362000c1e1900ULL, 0x000000061f00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081f00780cULL, 0x002fe40003f06070ULL,
0x0000000613147810ULL, 0x000fca0007ffe0ffULL, 0x00006a0014147625ULL, 0x000fca00078e0017ULL,
0x0000001418147210ULL, 0x000fe40007a3e019ULL, 0x0000000713160810ULL, 0x000fe40007ffe0ffULL,
0x00000015ff157210ULL, 0x000fc60000fe44ffULL, 0x00006a0016160625ULL, 0x000fca00078e0017ULL,
0x0000001618160210ULL, 0x000fe40007c7e019ULL, 0x0000000814197981ULL, 0x000364000c1e1900ULL,
0x00000017ff170210ULL, 0x000fcc0001fe84ffULL, 0x0000000816170981ULL, 0x000366000c1e1900ULL,
0x000000071f067810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff167819ULL, 0x000fc80000011606ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x020fe400078e0004ULL,
0x000000081b187824ULL, 0x040fe200078e00ffULL, 0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL,
0x0000030018007a0cULL, 0x000fe40003f26070ULL, 0x000000161b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000818147810ULL, 0x040fe40007ffe0ffULL,
0x0000000118067810ULL, 0x000fe40007ffe0ffULL, 0x0000030014007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000001d04047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000113147824ULL, 0x000fe200078e0214ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff157424ULL, 0x000fe400078e00ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0014147625ULL, 0x000fc600078e0015ULL, 0x00000070061d7812ULL, 0x000fc800078ec0ffULL,
0x000000140e147210ULL, 0x000fc80007b3e01dULL, 0x00000015ff157210ULL, 0x000fca0000fe64ffULL,
0x00000008141d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000918147810ULL, 0x042fe40007ffe0ffULL, 0x0000000218067810ULL, 0x000fe40007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000000504047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000113147824ULL, 0x000fe200078e0214ULL, 0x00000001ff067819ULL, 0x000fe20000011603ULL,
0x00000080ff157424ULL, 0x000fe400078e00ffULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x0000000c06067812ULL, 0x000fe200078ec0ffULL, 0x00006a0014147625ULL, 0x000fc600078e0015ULL,
0x0000007005057812ULL, 0x000fc800078ec0ffULL, 0x0000001406147210ULL, 0x000fc80007b3e005ULL,
0x00000015ff157210ULL, 0x000fca0000fe64ffULL, 0x0000000814057981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a18067810ULL, 0x040fe40007ffe0ffULL,
0x00000003180e7810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000000704047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000113067824ULL, 0x000fe200078e0206ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff077424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0006067625ULL, 0x000fc600078e0007ULL, 0x000000700e157812ULL, 0x002fc800078ec0ffULL,
0x0000000610067210ULL, 0x000fc80007b3e015ULL, 0x00000007ff077210ULL, 0x000fcc0000fe64ffULL,
0x0000000806077981ULL, 0x000366000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b18147810ULL, 0x042fe40007ffe0ffULL, 0x0000000418067810ULL, 0x000fe40007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000000904047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000113147824ULL, 0x000fe200078e0214ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff157424ULL, 0x000fe400078e00ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0014147625ULL, 0x000fc600078e0015ULL,
0x0000007006097812ULL, 0x000fc800078ec0ffULL, 0x000000140e147210ULL, 0x000fc80007b3e009ULL,
0x00000015ff157210ULL, 0x000fca0000fe64ffULL, 0x0000000814097981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c180e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000518067810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000f04047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001130e7824ULL, 0x000fe200078e020eULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007006157812ULL, 0x002fc800078ec0ffULL,
0x0000000e100e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fcc0000fe64ffULL,
0x000000080e0f7981ULL, 0x000366000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d18107810ULL, 0x040fe40007ffe0ffULL, 0x0000000618067810ULL, 0x000fe40007ffe0ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000001104047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000113107824ULL, 0x000fe200078e0210ULL, 0x00000001ff0e7819ULL, 0x002fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x0000007006157812ULL, 0x000fc800078ec0ffULL, 0x000000100e107210ULL, 0x000fc80007b3e015ULL,
0x00000011ff117210ULL, 0x000fcc0000fe64ffULL, 0x0000000810117981ULL, 0x000366000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e18147810ULL, 0x042fe40007ffe0ffULL,
0x0000000718067810ULL, 0x000fe40007ffe0ffULL, 0x0000030014007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000001904047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000113147824ULL, 0x000fe200078e0214ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff157424ULL, 0x000fe400078e00ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0014147625ULL, 0x000fc600078e0015ULL, 0x0000007006197812ULL, 0x000fc800078ec0ffULL,
0x000000140e147210ULL, 0x000fc80007b3e019ULL, 0x00000015ff157210ULL, 0x000fca0000fe64ffULL,
0x0000000814197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f18147810ULL, 0x002fe40007ffe0ffULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000030014007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000113147824ULL, 0x000fe200078e0214ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff157424ULL, 0x000fe400078e00ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0014147625ULL, 0x000fc600078e0015ULL,
0x0000007006177812ULL, 0x000fc800078ec0ffULL, 0x000000140e147210ULL, 0x000fc80007a3e017ULL,
0x00000015ff157210ULL, 0x000fca0000fe44ffULL, 0x0000000814177981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003057824ULL, 0x024fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fc80000011603ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fca00078ec0ffULL,
0x0000000106057824ULL, 0x000fca00078e0205ULL, 0x0000000405007388ULL, 0x0003e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x000000010a157824ULL, 0x002fe200078e0213ULL,
0x00000001ff067819ULL, 0x004fe20000011603ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe20000011641ULL, 0x00001000ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001502047211ULL, 0x000fe200078fa0ffULL, 0x0000020041417824ULL, 0x000fe200078e00ffULL,
0x0000000c060e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007005097812ULL, 0x000fe200078ec0ffULL, 0x00006a0004047625ULL, 0x000fe200078e000fULL,
0x0000000107067812ULL, 0x000fe200078ec0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000040030f7810ULL, 0x040fe20007ffe0ffULL, 0x000000020a078824ULL, 0x000fe200078e020dULL,
0x0000000c04047210ULL, 0x000fe20007f3e0ffULL, 0x000000010e177824ULL, 0x000fe200078e0209ULL,
0x0000006003117810ULL, 0x000fe20007ffe0ffULL, 0x0000000207188824ULL, 0x100fe200078e0206ULL,
0x0000080041077812ULL, 0x000fe200078ec0ffULL, 0x000000020a098824ULL, 0x000fe200078e020dULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000108167824ULL, 0x000fe200078e020bULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000002091a8824ULL, 0x000fe200078e0206ULL,
0x0000002003097810ULL, 0x040fe20007ffe0ffULL, 0x0000000116067824ULL, 0x000fe200078e0207ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000003000a007a0cULL, 0x000fe20003f26070ULL, 0x0000000112108824ULL, 0x000fe200078e0215ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000080ff198424ULL, 0x000fe200078e00ffULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x00000010031f7824ULL, 0x000fe200078e0206ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000001009067825ULL, 0x100fe200078e0004ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000080ff148424ULL, 0x000fe200078e00ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000100f087825ULL, 0x000fe200078e0004ULL,
0x0000000000367805ULL, 0x000fc6000001ff00ULL, 0x00000010110e7825ULL, 0x000fc800078e0004ULL,
0x00006a0010108625ULL, 0x000fc800078e0019ULL, 0x00006a0015148625ULL, 0x000fc800078e0014ULL,
0x0000000818188824ULL, 0x000fe400078e0203ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x0000458018218811ULL, 0x000fe200078e20ffULL, 0x000000081a1a8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000041f7faeULL, 0x0005e2000b901c48ULL,
0x0000001003108825ULL, 0x040fe200078e0010ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x000041801a238811ULL, 0x000fe200078e20ffULL, 0x0000001003148825ULL, 0x000fe200078e0014ULL,
0x00380000061f7faeULL, 0x0005e2000b901c48ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00580000081f7faeULL, 0x0005e8000b901c48ULL,
0x007800000e1f7faeULL, 0x0005e8000b901c48ULL, 0x0000000010218faeULL, 0x0007e8000b901c48ULL,
0x0000000014238faeULL, 0x0009e8000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001e7805ULL, 0x004fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000227805ULL, 0x010fe2000001ff00ULL, 0x00000df000001947ULL, 0x000fea0003800000ULL,
0x00000de000007945ULL, 0x002fe20003800000ULL, 0x000000ffff187224ULL, 0x000fc400078e00ffULL,
0x000000ffff047224ULL, 0x000fca00078e000aULL, 0x00000002043c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fe200078e0004ULL, 0x00000002ff3a7819ULL, 0x000fe20000011603ULL,
0x000000020a077824ULL, 0x000fe200078e020dULL, 0x000003003c007a0cULL, 0x000fe20003f06070ULL,
0x0000004048047824ULL, 0x000fe200078e00ffULL, 0x000000073a057812ULL, 0x040fe200078ec0ffULL,
0x000000083a3e7824ULL, 0x040fe200078e00ffULL, 0x0000003aff3b7212ULL, 0x000fe200078e33ffULL,
0x000000083a067824ULL, 0x000fe200078e00ffULL, 0x0000008004047812ULL, 0x000fe200078ec0ffULL,
0x000000083a087824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0x000000013e427812ULL, 0x140fe200078ef605ULL, 0x00000010034b7824ULL, 0x000fe200078e00ffULL,
0x000000023e417812ULL, 0x140fe200078ef605ULL, 0x0000010007447824ULL, 0x000fe200078e0004ULL,
0x000000033e407812ULL, 0x000fc400078ef605ULL, 0x000000043e3f7812ULL, 0x140fe400078ef605ULL,
0x000000053e3d7812ULL, 0x100fe400078ef605ULL, 0xfffffff806437812ULL, 0x100fe400078ee205ULL,
0x000000063e3e7812ULL, 0x000fe400078ef605ULL, 0xfffffff8083b7812ULL, 0x000fe400078ee23bULL,
0x000000083a397810ULL, 0x008fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x0000000113097824ULL, 0x100fe200078e023cULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00001000ff057424ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc4000001163cULL,
0x0000000902047211ULL, 0x000fe400078fa0ffULL, 0x0000000106067812ULL, 0x000fe400078ec0ffULL,
0x0000004003477810ULL, 0x040fe20007ffe0ffULL, 0x00006a0004047625ULL, 0x000fe200078e0005ULL,
0x0000006003497810ULL, 0x000fc60007ffe0ffULL, 0x000000020a0f9824ULL, 0x000fe200078e020dULL,
0x0000000c040e7210ULL, 0x000fe20007f1e0ffULL, 0x000004003c047824ULL, 0x000fe400078e00ffULL,
0x000000020f4a9824ULL, 0x000fe400078e0206ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0605ULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x000000020a079824ULL, 0x000fe400078e020dULL,
0x0000000112109824ULL, 0x000fc400078e0209ULL, 0x0000000207469824ULL, 0x000fe200078e0206ULL,
0x0000002003077810ULL, 0x040fe20007ffe0ffULL, 0x0000000116047824ULL, 0x000fe400078e0205ULL,
0x00000080ff119424ULL, 0x000fe400078e00ffULL, 0x00000080ff089424ULL, 0x000fe400078e00ffULL,
0x0000001003457824ULL, 0x000fe400078e0204ULL, 0x0000001007047825ULL, 0x000fc800078e000eULL,
0x00006a0010109625ULL, 0x000fc800078e0011ULL, 0x0000001003147825ULL, 0x000fc800078e000eULL,
0x0000001047067825ULL, 0x100fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000014457faeULL, 0x0003e6000b901c48ULL, 0x00006a0009089625ULL, 0x000fe200078e0008ULL,
0x0038000004457faeULL, 0x0003e6000b901c48ULL, 0x00000010490e7825ULL, 0x000fe200078e000eULL,
0x0058000006457faeULL, 0x0003e6000b901c48ULL, 0x0000000846469824ULL, 0x100fe200078e0203ULL,
0x007800000e457faeULL, 0x0003e2000b901c48ULL, 0x000000084a499824ULL, 0x000fc400078e0203ULL,
0x0000001003109825ULL, 0x000fe200078e0010ULL, 0x0000458046479811ULL, 0x000fe400078e20ffULL,
0x0000418049499811ULL, 0x000fe200078e20ffULL, 0x0000001003089825ULL, 0x000fe400078e0008ULL,
0x0000000010479faeULL, 0x0003e8000b901c48ULL, 0x0000000008499faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff087819ULL, 0x002fe20000011603ULL, 0x00000008390e7824ULL, 0x000fe200078e00ffULL,
0x000000704b077812ULL, 0x000fe200078ec0ffULL, 0x0000000839067824ULL, 0x040fe200078e00ffULL,
0x0000000c08087812ULL, 0x000fe200078ec0ffULL, 0x0000040048047824ULL, 0x000fe200078e00ffULL,
0x0000000739057812ULL, 0x000fc400078ec0ffULL, 0x0000004408447210ULL, 0x000fe40007ffe007ULL,
0xfffffff80e0f7812ULL, 0x100fe400078ee205ULL, 0x0000000106117812ULL, 0x140fe400078ef605ULL,
0x0000000206157812ULL, 0x140fe400078ef605ULL, 0x0000000306457812ULL, 0x140fe400078ef605ULL,
0x0000000406477812ULL, 0x000fc400078ef605ULL, 0x0000000506497812ULL, 0x140fe400078ef605ULL,
0x00000006064b7812ULL, 0x000fe200078ef605ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800044087984ULL, 0x000e620000000800ULL, 0x0000080004057812ULL, 0x000fe200078ec0ffULL,
0x0000000403067824ULL, 0x000fe200078e00ffULL, 0x00000039ff4d7212ULL, 0x000fe200078e33ffULL,
0x00458000444f7984ULL, 0x000ea20000000800ULL, 0x0000018016047810ULL, 0x000fe40007ffe005ULL,
0xfffffff80e4d7812ULL, 0x000fe400078ee24dULL, 0x0000000c06067812ULL, 0x000fe200078ec0ffULL,
0x0000001043437824ULL, 0x000fc400078e0204ULL, 0x0000001042057824ULL, 0x100fe400078e0204ULL,
0x0000001041417824ULL, 0x100fe400078e0204ULL, 0x0000001040077824ULL, 0x100fe400078e0204ULL,
0x000000103f3f7824ULL, 0x100fe400078e0204ULL, 0x000000103d3d7824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x000fc400078e0204ULL, 0x0000001015157824ULL, 0x100fe400078e0204ULL,
0x0000001045457824ULL, 0x100fe400078e0204ULL, 0x0000001047477824ULL, 0x100fe400078e0204ULL,
0x0000001049497824ULL, 0x100fe400078e0204ULL, 0x000000104b4b7824ULL, 0x100fe400078e0204ULL,
0x000000104d4d7824ULL, 0x000fc400078e0204ULL, 0x000000103e097824ULL, 0x100fe400078e0204ULL,
0x0000001011117824ULL, 0x100fe400078e0204ULL, 0x000000103b3b7824ULL, 0x000fe200078e0204ULL,
0x0000000817087221ULL, 0x002fe20000010100ULL, 0x0000000143437824ULL, 0x000fe400078e0206ULL,
0x0000000106057824ULL, 0x000fe200078e0205ULL, 0x3fb8aa3b08087820ULL, 0x000fe20000410000ULL,
0x0000000106417824ULL, 0x000fc400078e0241ULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000000043437984ULL, 0x000e620000000800ULL, 0x00000001063f7824ULL, 0x040fe200078e023fULL,
0x0000000800087308ULL, 0x000ea20000000800ULL, 0x00000001063d7824ULL, 0x040fe200078e023dULL,
0x0000000005057984ULL, 0x000ee20000000800ULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x0000000041417984ULL, 0x000f220000000800ULL,
0x0000000106457824ULL, 0x000fc400078e0245ULL, 0x0000000106477824ULL, 0x040fe200078e0247ULL,
0x0000000007077984ULL, 0x000f620000000800ULL, 0x0000000106497824ULL, 0x040fe400078e0249ULL,
0x00000001064b7824ULL, 0x040fe200078e024bULL, 0x000000003f3f7984ULL, 0x000f620000000800ULL,
0x00000001064d7824ULL, 0x000fe200078e024dULL, 0x0000004f08557220ULL, 0x004fe20000410000ULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x000000003d3d7984ULL, 0x000ea20000000800ULL,
0x00000001063b7824ULL, 0x040fe200078e023bULL, 0x0000003855387221ULL, 0x000fe20000010000ULL,
0x0000000106117824ULL, 0x000fe200078e0211ULL, 0x000000000f0f7984ULL, 0x000ea20000000800ULL,
0x000000ffff047224ULL, 0x000fc600078e003cULL, 0x0000000015157984ULL, 0x000ea40000000800ULL,
0x0000030004007a0cULL, 0x000fe40003f06070ULL, 0x0000000045457984ULL, 0x000ea80000000800ULL,
0x0000000047477984ULL, 0x000ea80000000800ULL, 0x0000000049497984ULL, 0x000ea20000000800ULL,
0x20000043ff067230ULL, 0x002fc40000004100ULL, 0x30000043ff437230ULL, 0x000fe20000004100ULL,
0x000000004b4b7984ULL, 0x000e620000000800ULL, 0x20000005ff087230ULL, 0x108fe40000004100ULL,
0x30000005ff057230ULL, 0x000fe20000004100ULL, 0x000000004d4d7984ULL, 0x000ee20000000800ULL,
0x20000041ff147230ULL, 0x110fe40000004100ULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000000009097984ULL, 0x000f220000000800ULL, 0x20000007ff407230ULL, 0x020fc40000004100ULL,
0x30000007ff077230ULL, 0x000fe20000004100ULL, 0x000000003b3b7984ULL, 0x000f620000000800ULL,
0x2000003fff427230ULL, 0x100fe40000004100ULL, 0x3000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000000011117984ULL, 0x000f620000000800ULL, 0x2000003dff447230ULL, 0x104fe40000004100ULL,
0x3000003dff3d7230ULL, 0x000fe40000004100ULL, 0x2000000fff4a7230ULL, 0x000fc40000004100ULL,
0x3000000fff0f7230ULL, 0x000fe40000004100ULL, 0x20000015ff4e7230ULL, 0x100fe40000004100ULL,
0x30000015ff157230ULL, 0x000fe40000004100ULL, 0x20000045ff507230ULL, 0x100fe40000004100ULL,
0x30000045ff457230ULL, 0x000fe40000004100ULL, 0x20000047ff527230ULL, 0x000fc40000004100ULL,
0x30000047ff477230ULL, 0x000fe40000004100ULL, 0x20000049ff547230ULL, 0x100fe40000004100ULL,
0x30000049ff497230ULL, 0x000fe40000004100ULL, 0x2000004bff567230ULL, 0x102fe40000004100ULL,
0x3000004bff4b7230ULL, 0x000fe40000004100ULL, 0x2000004dff587230ULL, 0x008fc40000004100ULL,
0x3000004dff4d7230ULL, 0x000fe40000004100ULL, 0x20000009ff467230ULL, 0x110fe40000004100ULL,
0x30000009ff4f7230ULL, 0x000fe40000004100ULL, 0x2000003bff487230ULL, 0x120fe40000004100ULL,
0x3000003bff517230ULL, 0x000fe40000004100ULL, 0x20000011ff4c7230ULL, 0x000fc40000004100ULL,
0x30000011ff537230ULL, 0x000fe20000004100ULL, 0x000058927f007947ULL, 0x000fea000b800000ULL,
0x00001f3a553a7589ULL, 0x0002a400000e0000ULL, 0x000058f27f007947ULL, 0x000fea000b800000ULL,
0x00001f39550e7589ULL, 0x00072400000e0000ULL, 0x0000003a06377223ULL, 0x084fe20000010037ULL,
0x0000003a43367223ULL, 0x080fe20000010036ULL, 0x0000003a08337223ULL, 0x080fe20000010033ULL,
0x0000003a05327223ULL, 0x080fe20000010032ULL, 0x0000003a142f7223ULL, 0x080fe2000001002fULL,
0x0000003a412e7223ULL, 0x080fe2000001002eULL, 0x0000003a402b7223ULL, 0x080fe2000001002bULL,
0x0000003a072a7223ULL, 0x080fe2000001002aULL, 0x0000003a42277223ULL, 0x080fe20000010027ULL,
0x0000003a3f267223ULL, 0x080fe20000010026ULL, 0x0000003a44237223ULL, 0x080fe20000010023ULL,
0x0000003a3d227223ULL, 0x080fe20000010022ULL, 0x0000003a461f7223ULL, 0x080fe2000001001fULL,
0x0000003a4f1e7223ULL, 0x080fe2000001001eULL, 0x0000003a481b7223ULL, 0x080fe2000001001bULL,
0x0000003a511a7223ULL, 0x000fe2000001001aULL, 0x0000000e4a357223ULL, 0x090fe20000010035ULL,
0x0000000e0f347223ULL, 0x080fe20000010034ULL, 0x0000000e4c317223ULL, 0x080fe20000010031ULL,
0x0000000e53307223ULL, 0x080fe20000010030ULL, 0x0000000e4e2d7223ULL, 0x080fe2000001002dULL,
0x0000000e152c7223ULL, 0x080fe2000001002cULL, 0x0000000e50297223ULL, 0x080fe20000010029ULL,
0x0000000e45287223ULL, 0x080fe20000010028ULL, 0x0000000e52257223ULL, 0x080fe20000010025ULL,
0x0000000e47247223ULL, 0x080fe20000010024ULL, 0x0000000e54217223ULL, 0x080fe20000010021ULL,
0x0000000e49207223ULL, 0x080fe20000010020ULL, 0x0000000e561d7223ULL, 0x080fe2000001001dULL,
0x0000000e4b1c7223ULL, 0x080fe2000001001cULL, 0x0000000e58197223ULL, 0x080fe20000010019ULL,
0x0000000e4d187223ULL, 0x000fe20000010018ULL, 0xfffff25000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02057812ULL, 0x000fc600078ec0ffULL,
0x000000800a027824ULL, 0x000fc800078e0203ULL, 0x0000000105037824ULL, 0x000fca00078e0202ULL,
0x0049803803007388ULL, 0x0003e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800004027984ULL, 0x000ea80000000800ULL, 0x004a000004037984ULL, 0x002e620000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000302027221ULL, 0x002fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0002ULL,
0x0000b26000047802ULL, 0x000fe40000000f00ULL, 0x0000599000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e000cULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200057308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000005ULL,
0x800000ff03047221ULL, 0x000fc80000010100ULL, 0x0000000405057223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803027811ULL, 0x004fe400078ff0ffULL,
0x00000002ff087819ULL, 0x000fe40000011603ULL, 0x00000002ff397212ULL, 0x008fe200078e33ffULL,
0x00001f0205067589ULL, 0x002e6200000e0000ULL, 0x0000000708077812ULL, 0x040fe200078ec0ffULL,
0x00000008080c7824ULL, 0x000fc400078e00ffULL, 0x00001f0805047589ULL, 0x0004e200000e0000ULL,
0x0000000107097812ULL, 0x040fe200078e3cffULL, 0x00000008020e7824ULL, 0x000fe200078e00ffULL,
0x00000002070f7812ULL, 0x040fe400078e3cffULL, 0x0000000307117812ULL, 0x040fe400078e3cffULL,
0x0000000407137812ULL, 0x040fe400078e3cffULL, 0x0000000507157812ULL, 0x000fe400078e3cffULL,
0x00000008ff057212ULL, 0x004fc400078e33ffULL, 0x0000000607177812ULL, 0x000fe200078e3cffULL,
0x0000000808077824ULL, 0x000fe200078e0209ULL, 0xfffffff80c3b7812ULL, 0x000fe200078ee205ULL,
0x0000000808057824ULL, 0x000fe200078e00ffULL, 0xfffffff80e397812ULL, 0x000fe200078ee239ULL,
0x0000000808097824ULL, 0x000fe200078e020fULL, 0x0000003506357220ULL, 0x042fe20000410000ULL,
0x0000003406347220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000002806287220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001806067220ULL, 0x000fe20000410000ULL, 0x0000002304237220ULL, 0x048fe20000410000ULL,
0x0000002204227220ULL, 0x000fe20000410000ULL, 0x00000008080f7824ULL, 0x000fe200078e0211ULL,
0x0000003704377220ULL, 0x000fe20000410000ULL, 0x0000000808117824ULL, 0x000fe200078e0213ULL,
0x0000003604367220ULL, 0x000fe20000410000ULL, 0x0000000808137824ULL, 0x000fe200078e0215ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x000fe20000410000ULL, 0x000000190606723eULL, 0x000fe200000000ffULL,
0x0000000808157824ULL, 0x000fe200078e0217ULL, 0xfffffff805057812ULL, 0x000fe200078ee208ULL,
0x0000001a04047220ULL, 0x000fe20000410000ULL, 0x0000000802197824ULL, 0x000fe200078e00ffULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000000403087824ULL, 0x000fe200078e00ffULL,
0x0000000702237812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000001b0404723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0xfffffff819177812ULL, 0x000fe200078ee202ULL, 0x0000001013137824ULL, 0x100fe200078e0200ULL,
0x0000000c08107812ULL, 0x000fe200078ec0ffULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000000123197812ULL, 0x000fe200078e3cffULL, 0x0000001017087824ULL, 0x100fe200078e0200ULL,
0x00000002231b7812ULL, 0x040fe200078e3cffULL, 0x0000000110057824ULL, 0x000fe200078e0205ULL,
0x00000003231d7812ULL, 0x040fe200078e3cffULL, 0x0000000802197824ULL, 0x000fe200078e0219ULL,
0x00000004231f7812ULL, 0x040fe200078e3cffULL, 0x0000000110077824ULL, 0x000fe200078e0207ULL,
0x0000000523217812ULL, 0x040fe200078e3cffULL, 0x00000008021b7824ULL, 0x040fe200078e021bULL,
0x0000000623237812ULL, 0x000fe200078e3cffULL, 0x00000008021d7824ULL, 0x000fe200078e021dULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x00000008021f7824ULL, 0x000fe200078e021fULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000000802217824ULL, 0x000fe200078e0221ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x0000000802237824ULL, 0x000fe200078e0223ULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x0000000110097824ULL, 0x000fe200078e0209ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x000000103b027824ULL, 0x100fe200078e0200ULL,
0x0000003605007388ULL, 0x0003e20000000800ULL, 0x00000001100f7824ULL, 0x000fe200078e020fULL,
0x000000353434723eULL, 0x000fe200000000ffULL, 0x0000000110117824ULL, 0x000fe200078e0211ULL,
0x0000003207007388ULL, 0x000fe20000000800ULL, 0x00000010190c7824ULL, 0x100fe200078e0200ULL,
0x000000313030723eULL, 0x000fe200000000ffULL, 0x0000000110137824ULL, 0x000fe200078e0213ULL,
0x0000002e09007388ULL, 0x000fe20000000800ULL, 0x000000101b0e7824ULL, 0x100fe200078e0200ULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x0000000110157824ULL, 0x000fe200078e0215ULL,
0x0000002a0f007388ULL, 0x000fe20000000800ULL, 0x000000101d1d7824ULL, 0x000fe200078e0200ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000000110177824ULL, 0x000fe200078e0202ULL,
0x0000002611007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000000110197824ULL, 0x000fe200078e0208ULL,
0x0000002213007388ULL, 0x000fe20000000800ULL, 0x0000001021217824ULL, 0x000fc400078e0200ULL,
0x00000001101b7824ULL, 0x040fe200078e020cULL, 0x0000001e15007388ULL, 0x000fe20000000800ULL,
0x0000001023237824ULL, 0x000fe400078e0200ULL, 0x0000000110057824ULL, 0x042fe200078e020eULL,
0x0000000417007388ULL, 0x000fe20000000800ULL, 0x0000001039397824ULL, 0x000fe400078e0200ULL,
0x00000001101d7824ULL, 0x040fe200078e021dULL, 0x0000003419007388ULL, 0x000fe20000000800ULL,
0x00000001101f7824ULL, 0x000fc400078e021fULL, 0x0000000110217824ULL, 0x040fe200078e0221ULL,
0x000000301b007388ULL, 0x000fe20000000800ULL, 0x0000000110237824ULL, 0x040fe400078e0223ULL,
0x0000000110397824ULL, 0x000fe200078e0239ULL, 0x0000002c05007388ULL, 0x000fe20000000800ULL,
0x000000200a007824ULL, 0x000fc600078e0203ULL, 0x000000281d007388ULL, 0x000fe20000000800ULL,
0x0000001000007824ULL, 0x000fc600078e020bULL, 0x000000241f007388ULL, 0x000fe80000000800ULL,
0x0000002021007388ULL, 0x000fe80000000800ULL, 0x0000001c23007388ULL, 0x000fe80000000800ULL,
0x0000000639007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000107984ULL, 0x000e680000000c00ULL, 0x0004000000187984ULL, 0x000ea80000000c00ULL,
0x0008000000147984ULL, 0x000ee80000000c00ULL, 0x000c0000002c7984ULL, 0x000f220000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x004fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x008fe40000000000ULL, 0x0000001612127230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000002f1b1b7230ULL, 0x010fc40000000000ULL, 0x0000002e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000001000007388ULL, 0x0003e20000000c00ULL, 0x0000002d19197230ULL, 0x000fe40000000000ULL,
0x0000002c18187230ULL, 0x000fca0000000000ULL, 0x0004001800007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x002e620000002600ULL,
0x00000020031d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x00000040031f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000060031e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff007819ULL, 0x000fe20000011603ULL, 0x000000080d1a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fe2000001161dULL, 0x000000080d1c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0e7819ULL, 0x000fe2000001161fULL, 0x000000080d207824ULL, 0x000fe200078e00ffULL,
0x00000003ff0f7819ULL, 0x000fc4000001161eULL, 0x000000070c047812ULL, 0x100fe400078e481dULL,
0x000000070f077812ULL, 0x100fe400078e481eULL, 0x0ffffff804047812ULL, 0x000fe400078ef81dULL,
0x0ffffff8070a7812ULL, 0x000fe400078ef81eULL, 0xfffffff81a1b7812ULL, 0x000fe200078ee203ULL,
0x0000001018057824ULL, 0x002fe200078e00ffULL, 0xfffffff81c1d7812ULL, 0x000fe200078ee21dULL,
0x0000001004087824ULL, 0x100fe200078e020bULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x000000100a147824ULL, 0x000fe200078e020bULL, 0xfffffff005027812ULL, 0x000fe200078ee200ULL,
0x0000001018197824ULL, 0x000fe200078e00ffULL, 0x0000000700007812ULL, 0x000fe200078e4803ULL,
0x0000001018217824ULL, 0x000fe200078e00ffULL, 0x000000070e057812ULL, 0x000fe200078e481fULL,
0x0000000014147984ULL, 0x000fe20000000c00ULL, 0x0ffffff800007812ULL, 0x000fe200078ef803ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x0ffffff805067812ULL, 0x004fc400078ef81fULL,
0x0000000402037c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001000007824ULL, 0x100fe200078e020bULL,
0xfffffff0190c7812ULL, 0x000fe200078ee20cULL, 0x0000001006107824ULL, 0x000fe200078e020bULL,
0xfffffff0210e7812ULL, 0x000fe200078ee20eULL, 0x0000000008087984ULL, 0x000fe20000000c00ULL,
0xfffffff0180f7812ULL, 0x000fe200078ee20fULL, 0x000000080d217824ULL, 0x000fe200078e00ffULL,
0x000000040e1a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000000047984ULL, 0x0002a20000000c00ULL,
0xfffffff8201f7812ULL, 0x000fc400078ee21fULL, 0xfffffff821217812ULL, 0x000fe200078ee21eULL,
0x0000000010107984ULL, 0x000ee20000000c00ULL, 0x000000ffff007224ULL, 0x002fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fc800078040ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4400ULL,
0x000000040c1c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040f007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005a001a0e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005a001c0c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fe200078440ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005b001c0d7a11ULL, 0x000fc400000f440dULL,
0x00005b001a0f7a11ULL, 0x000fe400008f440fULL, 0x00005b0000197a11ULL, 0x000fe200010f4419ULL,
0x000000101d0c7825ULL, 0x000fc800078e000cULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d08ULL,
0x000000080c007986ULL, 0x000fe8000c101d08ULL, 0x000000100e007986ULL, 0x008fe8000c101d08ULL,
0x0000001418007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x002fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000804047981ULL, 0x000362000c1e9900ULL, 0x0000000142027810ULL, 0x000fe20007ffe0ffULL,
0x0000000210007824ULL, 0x000fe400078e00ffULL, 0x0000004041037824ULL, 0x000fe200078e00ffULL,
0x0000000f0200720cULL, 0x000fe20003f06070ULL, 0x0000580000007a24ULL, 0x000fe400078e0211ULL,
0x00000100420b7824ULL, 0x000fc800078e0203ULL, 0x00006200001a7a24ULL, 0x000fcc00078e020bULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x002e620000000000ULL,
0x00000080ff277424ULL, 0x000fe200078e00ffULL, 0x0000000b40027217ULL, 0x000fe40007800000ULL,
0x0000100041197811ULL, 0x000fc600078e68ffULL, 0x0000000102027824ULL, 0x000fe200078e0a0bULL,
0x00000002ff237819ULL, 0x102fe2000001160eULL, 0x000000100e257824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe4000001160eULL, 0x0000000823157810ULL, 0x040fe20007ffe0ffULL,
0x0000000123067824ULL, 0x100fe200078e021aULL, 0x0000003025257812ULL, 0x000fe400078ec0ffULL,
0x00000020231d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115087824ULL, 0x000fe200078e021aULL,
0x0000001023297810ULL, 0x040fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x00000018232b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000305057812ULL, 0x000fe200078e480eULL,
0x00005e0008087625ULL, 0x000fe200078e0027ULL, 0x0000002506107210ULL, 0x080fe40007f1e0ffULL,
0x00000028231f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001290a7824ULL, 0x100fe200078e021aULL,
0x0000002508127210ULL, 0x000fe20007f3e0ffULL, 0x000000011a087824ULL, 0x000fe200078e021dULL,
0x0000003023217810ULL, 0x000fe20007ffe0ffULL, 0x000000012b0c7824ULL, 0x000fe200078e021aULL,
0x000000022900720cULL, 0x080fe20003fa6070ULL, 0x000000ffff137224ULL, 0x000fe200008e0609ULL,
0x000000022b00720cULL, 0x080fe20003f86070ULL, 0x00005e0008087625ULL, 0x000fe200078e0027ULL,
0x000000021d00720cULL, 0x000fc60003f66070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x0000002508147210ULL, 0x000fc60007f5e0ffULL, 0x0000000415167824ULL, 0x000fe400078e00ffULL,
0x00005e000c0c7625ULL, 0x000fc600078e0027ULL, 0xfffffffc16087812ULL, 0x000fe200078ee205ULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0x000000250a067210ULL, 0x080fe20007f1e0ffULL,
0x0000000421187824ULL, 0x000fe200078e00ffULL, 0x000000250c0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000010081b7824ULL, 0x000fe200078e0219ULL, 0x0ffffffc050a7812ULL, 0x000fe200078ef80eULL,
0x000000ffff077224ULL, 0x000fe200000e060bULL, 0x000000022300720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000021500720cULL, 0x080fe20003f26070ULL,
0x000000011a087824ULL, 0x000fe200078e021fULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0609ULL, 0x000000021f00720cULL, 0x000fe20003f46070ULL,
0x00005e0008087625ULL, 0x000fe200078e0027ULL, 0xfffffffc18187812ULL, 0x000fc600078ee205ULL,
0x000000100a0b7824ULL, 0x000fe200078e0219ULL, 0x0000002508167210ULL, 0x000fe20007fde0ffULL,
0x000000011a087824ULL, 0x000fe400078e0221ULL, 0x000000042b0e7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100b7faeULL, 0x0003e2000c101c48ULL,
0x000000ffff177224ULL, 0x000fe200030e0609ULL, 0x000000022300720cULL, 0x080fe20003f06070ULL,
0x00005e0008087625ULL, 0x000fe200078e0027ULL, 0x00000000121b7faeULL, 0x0005e2000c901c48ULL,
0x000000022100720cULL, 0x000fc40003f26070ULL, 0x0000000429027824ULL, 0x000fe200078e00ffULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x000000011a0a7824ULL, 0x000fe200078e0223ULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee205ULL, 0x00000004231a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc02027812ULL, 0x100fe200078ee205ULL, 0x000000041d107824ULL, 0x002fe400078e00ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0xfffffffc1a1a7812ULL, 0x100fe400078ee205ULL,
0xfffffffc10107812ULL, 0x000fe200078ee205ULL, 0x000000041f127824ULL, 0x004fc400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x000000250a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000100e117824ULL, 0x000fe200078e0219ULL, 0xfffffffc12127812ULL, 0x000fe200078ee205ULL,
0x0000001002057824ULL, 0x100fe400078e0219ULL, 0x0000001010137824ULL, 0x100fe400078e0219ULL,
0x00000010121b7824ULL, 0x100fe200078e0219ULL, 0x0000000006057faeULL, 0x0003e2000e901c48ULL,
0x00000010181d7824ULL, 0x000fc400078e0219ULL, 0x000000101a197824ULL, 0x000fe200078e0219ULL,
0x000000000c117faeULL, 0x0003e2000e101c48ULL, 0x000000ffff0b7224ULL, 0x000fc600030e060bULL,
0x0000000014137faeULL, 0x0003e8000d901c48ULL, 0x00000000161b7faeULL, 0x0003e8000d101c48ULL,
0x00000000081d7faeULL, 0x0003e8000c901c48ULL, 0x000000000a197faeULL, 0x0003e2000c101c48ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x0000000000137919ULL, 0x002e620000000000ULL,
0x00000080ff257424ULL, 0x000fe200078e00ffULL, 0x00001000411c7811ULL, 0x000fc400078e68ffULL,
0x0000001813077811ULL, 0x042fe200078ff0ffULL, 0x0000001013087824ULL, 0x040fe200078e00ffULL,
0x0000001a13067211ULL, 0x040fe400078ff0ffULL, 0x00000003ff027819ULL, 0x000fe20000011613ULL,
0x000000011a0a7824ULL, 0x000fe200078e0207ULL, 0x0000000813117811ULL, 0x000fe200078ff0ffULL,
0x00000004071b7824ULL, 0x000fe200078e00ffULL, 0x00000028130b7811ULL, 0x040fe200078ff0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x0000002013097811ULL, 0x000fc400078ff0ffULL,
0x0000003008277812ULL, 0x000fe200078ec0ffULL, 0x0000000411157824ULL, 0x040fe200078e00ffULL,
0x0000000302167812ULL, 0x000fe200078e4813ULL, 0x0000000111027824ULL, 0x000fe200078e021aULL,
0x0000001013057811ULL, 0x040fe200078ff0ffULL, 0x000000011a117824ULL, 0x040fe200078e020bULL,
0x00000038130d7811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x00000030130c7811ULL, 0x000fe200078ff0ffULL, 0x000000011a0e7824ULL, 0x000fe200078e0209ULL,
0x0000002706127210ULL, 0x000fe20007f1e0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x0ffffffc16197812ULL, 0x000fe200078ef813ULL, 0x0000000405177824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b147812ULL, 0x100fe200078ee216ULL, 0x000000011a087824ULL, 0x000fe200078e0205ULL,
0xfffffffc09107812ULL, 0x100fe200078ee216ULL, 0x000000040d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc15057812ULL, 0x000fe200078ee216ULL, 0x000000040c1d7824ULL, 0x000fc400078e00ffULL,
0x000000ffff137224ULL, 0x000fe400000e0607ULL, 0x00005e0002067625ULL, 0x000fe200078e0025ULL,
0xfffffffc1d157812ULL, 0x000fc600078ee216ULL, 0x000000011a187824ULL, 0x000fe200078e020cULL,
0xfffffffc170c7812ULL, 0x100fe200078ee216ULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0xfffffffc1f177812ULL, 0x000fc600078ee216ULL, 0x00000010141f7824ULL, 0x000fe200078e021cULL,
0x0000002706147210ULL, 0x000fe20007f1e0ffULL, 0x000000011a1a7824ULL, 0x000fe200078e020dULL,
0xfffffffc1b0d7812ULL, 0x000fe200078ee216ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0025ULL,
0x0000002708167210ULL, 0x000fc60007f3e0ffULL, 0x0000001015217824ULL, 0x100fe400078e021cULL,
0x000000ffff157224ULL, 0x000fe200000e0607ULL, 0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001017237824ULL, 0x100fe400078e021cULL, 0x0000001019297824ULL, 0x100fe400078e021cULL,
0x000000ffff177224ULL, 0x000fe400008e0609ULL, 0x00005e000e067625ULL, 0x000fe200078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0003e6000b901c48ULL,
0x000000100c197824ULL, 0x000fc400078e021cULL, 0x000000100d1b7824ULL, 0x000fe400078e021cULL,
0x00005e0011087625ULL, 0x000fc800078e0025ULL, 0x00000010101d7824ULL, 0x000fe200078e021cULL,
0x0000002708087210ULL, 0x000fe20007f3e0ffULL, 0x00005e00180c7625ULL, 0x000fc800078e0025ULL,
0x00005e001a107625ULL, 0x000fe200078e0025ULL, 0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002706067210ULL, 0x080fe20007f1e0ffULL,
0x0000001005057824ULL, 0x000fe200078e021cULL, 0x0000002710107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000014057faeULL, 0x0003e2000b901c48ULL, 0x000000ffff0d7224ULL, 0x000fe400010e060dULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000000016197faeULL, 0x0003e8000b901c48ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c48ULL, 0x00000000061d7faeULL, 0x0003e8000b901c48ULL,
0x00000000081f7faeULL, 0x0003e8000b901c48ULL, 0x000000000c217faeULL, 0x0003e8000b901c48ULL,
0x0000000010237faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff027984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000002ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200057305ULL, 0x0022a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034100780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x0000002041027824ULL, 0x004fc800078e0202ULL,
0x0000001002067824ULL, 0x002fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011602ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7802ULL,
0x0000000707077812ULL, 0x000fc600078e7802ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x0000000005107984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x000fe200078e000bULL, 0x0000001405007388ULL, 0x0003e8000000cc00ULL,
0x0000001007007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200057305ULL, 0x0022a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000f4200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x3db504f304047820ULL, 0x020fe20000410000ULL, 0x0000001041057824ULL, 0x002fe200078e00ffULL,
0xffffffff0f077810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00007610ff087816ULL, 0x000fe40000000008ULL, 0x0000010042097824ULL, 0x002fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000094000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0006ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x000000010a0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe60003800000ULL, 0x00000001ff0b7819ULL, 0x000fc4000001160dULL,
0x000000020d00780cULL, 0x000fc60003f06070ULL, 0x000003000b067a24ULL, 0x000fe400078e0242ULL,
0x000000ffff0b7224ULL, 0x000fe400078e000aULL, 0x0000010006117824ULL, 0x040fe200078e0203ULL,
0x00000001060e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0x000000010c067812ULL, 0x000fe200078e0cffULL, 0x00006200001d7a24ULL, 0x000fe200078e0211ULL,
0x0000000f0e00720cULL, 0x000fe40003f26070ULL, 0x000000010d0e7812ULL, 0x000fd600078ec0ffULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x00000011400d7217ULL, 0x000fe20007800000ULL,
0x000000040e3d7824ULL, 0x000fe200078e00ffULL, 0x00000002ff147819ULL, 0x004fe20000011602ULL,
0x00000002410e7824ULL, 0x000fe200078e0206ULL, 0x00000003ff137819ULL, 0x100fe20000011602ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a11ULL, 0x0000000814167810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0x00000003133f7812ULL, 0x100fe200078e4802ULL,
0x0000000114107824ULL, 0x100fe200078e021dULL, 0x0000000d1600720cULL, 0x0c0fe20003f46070ULL,
0x0000000116127824ULL, 0x000fe200078e021dULL, 0x0000000d1400720cULL, 0x000fe20003f26070ULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee202ULL,
0x00005e0010107625ULL, 0x000fe200078e001fULL, 0x000010000e0e7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc3f157812ULL, 0x000fe200078ef802ULL, 0x00005e0012127625ULL, 0x000fe200078e001fULL,
0xfffffffc16177812ULL, 0x000fe400078ee23fULL, 0x0000001014167810ULL, 0x040fe20007ffe0ffULL,
0x0000001015157824ULL, 0x000fe200078e020eULL, 0x00000018141c7810ULL, 0x040fe20007ffe0ffULL,
0x000000103d107825ULL, 0x000fe200078e0010ULL, 0x00000020141e7810ULL, 0x040fe40007ffe0ffULL,
0x00000028143c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e020eULL,
0x00000030143e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103d127825ULL, 0x000fe200078e0012ULL,
0x0000003814447810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000c901c48ULL, 0x0000000d1600720cULL, 0x0c0fe20003f26070ULL,
0x0000000416467824ULL, 0x000fe200078e00ffULL, 0x0000000d1e00720cULL, 0x080fe20003f66070ULL,
0x0000000012177faeULL, 0x0005e2000d101c48ULL, 0x0000000d1c00720cULL, 0x0c0fe20003f46070ULL,
0x000000041c487824ULL, 0x000fe200078e00ffULL, 0x0000000d3c00720cULL, 0x080fe20003f86070ULL,
0x000000011e147824ULL, 0x100fe200078e021dULL, 0x0000000d3e00720cULL, 0x080fe20003fa6070ULL,
0x000000041e4a7824ULL, 0x000fe200078e00ffULL, 0x0000000d4400720cULL, 0x000fe20003fc6070ULL,
0x0000000116107824ULL, 0x002fe200078e021dULL, 0xfffffffc460d7812ULL, 0x000fe200078ee23fULL,
0x000000013c167824ULL, 0x000fe200078e021dULL, 0xfffffffc48437812ULL, 0x000fe200078ee23fULL,
0x000000011c127824ULL, 0x004fe200078e021dULL, 0xfffffffc4a457812ULL, 0x000fe200078ee23fULL,
0x000000013e1c7824ULL, 0x000fc400078e021dULL, 0x00000001441e7824ULL, 0x000fe400078e021dULL,
0x000000043c3c7824ULL, 0x000fe400078e00ffULL, 0x00005e0010107625ULL, 0x000fc600078e001fULL,
0xfffffffc3c477812ULL, 0x000fe200078ee23fULL, 0x00005e0012127625ULL, 0x000fc800078e001fULL,
0x00005e0014147625ULL, 0x000fc800078e001fULL, 0x00005e0016167625ULL, 0x000fc800078e001fULL,
0x00005e001c1c7625ULL, 0x000fc800078e001fULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x00005e001e1e7625ULL, 0x000fc600078e001fULL, 0xfffffffc3e497812ULL, 0x000fe200078ee23fULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x000000103d107825ULL, 0x000fc600078e0010ULL,
0xfffffffc444b7812ULL, 0x000fe200078ee23fULL, 0x000000103d127825ULL, 0x000fc800078e0012ULL,
0x000000103d147825ULL, 0x000fc800078e0014ULL, 0x000000103d167825ULL, 0x000fc800078e0016ULL,
0x000000103d1c7825ULL, 0x000fc800078e001cULL, 0x000000103d1e7825ULL, 0x000fc800078e001eULL,
0x000000100d0d7824ULL, 0x100fe400078e020eULL, 0x00000010433d7824ULL, 0x100fe400078e020eULL,
0x00000010453f7824ULL, 0x100fe200078e020eULL, 0x00000000100d7faeULL, 0x0003e2000c901c48ULL,
0x0000001047437824ULL, 0x100fe400078e020eULL, 0x0000001049457824ULL, 0x100fe200078e020eULL,
0x00000000123d7faeULL, 0x0003e2000d101c48ULL, 0x000000104b477824ULL, 0x000fc600078e020eULL,
0x00000000143f7faeULL, 0x0003e8000d901c48ULL, 0x0000000016437faeULL, 0x0003e8000e101c48ULL,
0x000000001c457faeULL, 0x0003e8000e901c48ULL, 0x000000001e477faeULL, 0x0003e2000f101c48ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x000000040e0d7824ULL, 0x000fe200078e00ffULL,
0x0000000802147811ULL, 0x044fe200078ff0ffULL, 0x00000002410e7824ULL, 0x000fe200078e0206ULL,
0x0000001002167811ULL, 0x040fe200078ff0ffULL, 0x00000080ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000018021c7811ULL, 0x000fe200078ff0ffULL, 0x0000000114127824ULL, 0x100fe200078e021dULL,
0x00000020021e7811ULL, 0x000fe200078ff0ffULL, 0x0000000416467824ULL, 0x000fe200078e00ffULL,
0x00000028023c7811ULL, 0x000fe200078ff0ffULL, 0x000000041c487824ULL, 0x000fe200078e00ffULL,
0x00000030023e7811ULL, 0x000fe200078ff0ffULL, 0x000000041e4a7824ULL, 0x000fe200078e00ffULL,
0x0000003802447811ULL, 0x000fe200078ff0ffULL, 0x000000043c4c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff117819ULL, 0x100fe20000011602ULL, 0x000000043e4e7824ULL, 0x000fe200078e00ffULL,
0x000010000e4d7811ULL, 0x000fe200078e60ffULL, 0x00000004140e7824ULL, 0x000fe200078e00ffULL,
0x0000000311137812ULL, 0x000fe200078e4802ULL, 0x0000000116147824ULL, 0x100fe200078e021dULL,
0x0000001d02107211ULL, 0x000fe200078ff0ffULL, 0x000000011c167824ULL, 0x000fe200078e021dULL,
0xfffffffc46467812ULL, 0x000fe200078ee213ULL, 0x000000011e1c7824ULL, 0x000fe200078e021dULL,
0xfffffffc48487812ULL, 0x100fe200078ee213ULL, 0x0000000444507824ULL, 0x000fe200078e00ffULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee213ULL, 0x000000013c1e7824ULL, 0x000fe200078e021dULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee213ULL, 0x000000013e3c7824ULL, 0x000fe200078e021dULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee213ULL, 0x00000001443e7824ULL, 0x000fe200078e021dULL,
0xfffffffc0e447812ULL, 0x100fe200078ee213ULL, 0x00005e0010107625ULL, 0x000fe200078e003fULL,
0xfffffffc50507812ULL, 0x000fc400078ee213ULL, 0x0ffffffc130e7812ULL, 0x100fe200078ef802ULL,
0x00005e0012127625ULL, 0x000fe200078e003fULL, 0xfffffffc0d0d7812ULL, 0x000fc600078ee202ULL,
0x00005e0014147625ULL, 0x000fc800078e003fULL, 0x00005e0016167625ULL, 0x000fc800078e003fULL,
0x00005e001c1c7625ULL, 0x000fc800078e003fULL, 0x00005e001e1e7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x000000100d107825ULL, 0x000fc800078e0010ULL, 0x000000100d127825ULL, 0x000fc800078e0012ULL,
0x000000100d147825ULL, 0x000fc800078e0014ULL, 0x000000100d167825ULL, 0x000fc800078e0016ULL,
0x000000100d1c7825ULL, 0x000fc800078e001cULL, 0x000000100d1e7825ULL, 0x000fc800078e001eULL,
0x000000100d3c7825ULL, 0x000fc800078e003cULL, 0x000000100d3e7825ULL, 0x000fc800078e003eULL,
0x000000100e4f7824ULL, 0x100fe400078e024dULL, 0x00000010440d7824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000104f7faeULL, 0x0003e2000b901c48ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x00000000120d7faeULL, 0x0003e2000b901c48ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x0000000014437faeULL, 0x0003e2000b901c48ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x0000000016457faeULL, 0x0003e8000b901c48ULL, 0x000000001c477faeULL, 0x0003e8000b901c48ULL,
0x000000001e497faeULL, 0x0003e8000b901c48ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c48ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020023f7810ULL, 0x042fe20007ffe0ffULL,
0x00000002410e7824ULL, 0x000fe200078e020cULL, 0xfffffff8020d7812ULL, 0x000fe200078ec0ffULL,
0x000000080b3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000000070d3e7812ULL, 0x000fc400078ef802ULL,
0x000000073f3f7812ULL, 0x000fe400078ef802ULL, 0x0000000702117812ULL, 0x000fe400078ec0ffULL,
0x00000001ff0c7819ULL, 0x000fe4000001163eULL, 0x00000001ff3c7819ULL, 0x000fe4000001163fULL,
0x000010000e0e7811ULL, 0x000fe400078e60ffULL, 0x00000008110d7812ULL, 0x000fc400078ef802ULL,
0x000000030c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000033c3c7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000b0c117212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000b3c147212ULL, 0x000fe400078e3cffULL,
0x000000010b457810ULL, 0x000fe20007ffe0ffULL, 0x000000043e117824ULL, 0x000fe200078e0211ULL,
0x0000003d02767211ULL, 0x000fe200078fe0ffULL, 0x000000043f157824ULL, 0x000fe200078e0214ULL,
0x000000020b0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x100fe200078e020eULL,
0x000000043d3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e020eULL,
0x000000040b00780cULL, 0x000fc60003f25270ULL, 0x000000001110783bULL, 0x000e680000000200ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000018ff5d7819ULL, 0x002fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x00008880116f7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011413ULL,
0x00010000101c7824ULL, 0x000fe200078e00ffULL, 0x00008880135f7816ULL, 0x000fe200000000ffULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff717819ULL, 0x000fe20000011410ULL, 0x0000001100727306ULL, 0x0003e20000200c00ULL,
0x0000888010737816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x004fe40000011414ULL, 0x0000888014547816ULL, 0x000fc400000000ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001c007a7306ULL, 0x000fe20000200c00ULL,
0x0001000013117824ULL, 0x042fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011415ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x0000888015657816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000001d00747306ULL, 0x000fe20000200c00ULL, 0x00000018ff577819ULL, 0x000fc40000011416ULL,
0x00000018ff437819ULL, 0x000fe40000011417ULL, 0x0000888016637816ULL, 0x000fe400000000ffULL,
0x00008880175b7816ULL, 0x000fe200000000ffULL, 0x00000011006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff607819ULL, 0x000fe40000011412ULL, 0x00008880126d7816ULL, 0x000fca00000000ffULL,
0x0000001300697306ULL, 0x0005e20000200c00ULL, 0x000000450c117212ULL, 0x002fce00078e3cffULL,
0x0000001000787306ULL, 0x0003e20000200c00ULL, 0x000000043e137824ULL, 0x004fe400078e0211ULL,
0x0001000015117824ULL, 0x000fe400078e00ffULL, 0x0000001013137824ULL, 0x000fe400078e020eULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0001000012107824ULL, 0x042fe200078e00ffULL, 0x00000000131c783bULL, 0x000e620000000200ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x00000011006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff127819ULL, 0x000fca0000011412ULL, 0x0000001000707306ULL, 0x0005f00000200c00ULL,
0x0000001500687306ULL, 0x0003e20000200c00ULL, 0x0001000014107824ULL, 0x044fe400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000012006b7306ULL, 0x000ff00000200c00ULL,
0x00000014006c7306ULL, 0x0005e20000200c00ULL, 0x000100001d157824ULL, 0x002fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001141cULL, 0x00000018ff4b7819ULL, 0x000fc8000001141dULL,
0x0000001000677306ULL, 0x0003e20000200c00ULL, 0x0001000017147824ULL, 0x044fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011415ULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x000088801d4d7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000453c107212ULL, 0x002fc400078e3cffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff4a7819ULL, 0x000fe2000001141eULL,
0x000000043f457824ULL, 0x000fe200078e0210ULL, 0x000088801e517816ULL, 0x000fe200000000ffULL,
0x00000014005e7306ULL, 0x0003e20000200c00ULL, 0x0001000016107824ULL, 0x040fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe2000001141fULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x000088801f567816ULL, 0x000fe200000000ffULL, 0x0000001045127824ULL, 0x000fe200078e020eULL,
0x00000018ff667819ULL, 0x000fc40000011410ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x000100001c147824ULL, 0x042fe200078e00ffULL, 0x00000017005c7306ULL, 0x000fe20000200c00ULL,
0x000088801c457816ULL, 0x040fe200000000ffULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011414ULL,
0x0000000776147812ULL, 0x000fe400078e780dULL, 0x0000001600627306ULL, 0x0005e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x000000100d147824ULL, 0x000fe200078e0214ULL,
0x0000000276767810ULL, 0x000fc60007ffe0ffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x0000000776767812ULL, 0x000fc800078e780dULL,
0x000000001414783bULL, 0x004ea20000000200ULL, 0x000000100d767824ULL, 0x000fe400078e0276ULL,
0x0000001c004f7306ULL, 0x0009f00000200c00ULL, 0x0000001d00507306ULL, 0x000be20000200c00ULL,
0x000100001e1c7824ULL, 0x010fc400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006f006f7306ULL, 0x000f220000200c00ULL,
0x000100001f1d7824ULL, 0x060fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x002fe40000011410ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00587306ULL, 0x0007e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x00000018ff447819ULL, 0x000fe40000011413ULL, 0x00000018ff467819ULL, 0x000fe20000011412ULL,
0x0000001d00597306ULL, 0x0003e20000200c00ULL, 0x00005410731c7816ULL, 0x008fce000000007aULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00005410781d7816ULL, 0x002fce0000000071ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x0000001c1438723cULL, 0x004fee0000001838ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054106f1c7816ULL, 0x010fe20000000074ULL,
0x00010000106f7824ULL, 0x000fe200078e00ffULL, 0x00005410721d7816ULL, 0x000fc8000000005dULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000005400547306ULL, 0x000ee40000200c00ULL,
0x0000001c1434723cULL, 0x000fec0000001834ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x000054106d1c7816ULL, 0x002fc40000000070ULL, 0x000054106b1d7816ULL, 0x000fe40000000060ULL,
0x000054106c557816ULL, 0x004fe40000000055ULL, 0x00008880116b7816ULL, 0x000fe200000000ffULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x008fe20000000067ULL,
0x0000001c1430723cULL, 0x040fec0000001830ULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x00005410691d7816ULL, 0x010fe20000000064ULL, 0x000000541428723cULL, 0x000fe20000001828ULL,
0x0001000011697824ULL, 0x000fc400078e00ffULL, 0x000000ffff647224ULL, 0x000fc600078e006bULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000054105f1c7816ULL, 0x002fe2000000006eULL,
0x0000010011547824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc80000011469ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000001e00537306ULL, 0x0003e20000200c00ULL,
0x0000001c142c723cULL, 0x000fe2000000182cULL, 0x0000541068117816ULL, 0x004fe40000000061ULL,
0x0000888012617816ULL, 0x000fc800000000ffULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00008880101e7816ULL, 0x042fe200000000ffULL, 0x0000010010107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000001e005d7306ULL, 0x0005f00000200c00ULL,
0x00000010005f7306ULL, 0x0007e20000200c00ULL, 0x00000010761e7824ULL, 0x004fce00078e00ffULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x0000541065107816ULL, 0x008fce000000006aULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000000101424723cULL, 0x000fee0000001824ULL,
0x0000001f005a7306ULL, 0x0007e20000200c00ULL, 0x0000541063107816ULL, 0x002fe40000000066ULL,
0x0000541062117816ULL, 0x000fe20000000057ULL, 0x000000ffff577224ULL, 0x000fc400078e0061ULL,
0x0001000012617824ULL, 0x000fe400078e00ffULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000001e1c783bULL, 0x008ee20000000200ULL, 0x000000101420723cULL, 0x000fe20000001820ULL,
0x00000018ff617819ULL, 0x000fca0000011461ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000054105b107816ULL, 0x004fe4000000005eULL, 0x000054105c117816ULL, 0x000fca0000000043ULL,
0x0000005200527306ULL, 0x000ea40000200c00ULL, 0x000000101418723cULL, 0x000fec0000001818ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000010012107824ULL, 0x000fe200078e00ffULL,
0x0000541050117816ULL, 0x002fc4000000004bULL, 0x0000888013147816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000001000157306ULL, 0x0005f00000200c00ULL, 0x0000004c004c7306ULL, 0x000f220000200c00ULL,
0x000054104d107816ULL, 0x004fce0000000052ULL, 0x000000101c34723cULL, 0x008fe20000001834ULL,
0x0000004a004a7306ULL, 0x000eac0000200c00ULL, 0x000000ffff117224ULL, 0x000fe200078e0014ULL,
0x0000541056107816ULL, 0x002fe20000000059ULL, 0x0001000013147824ULL, 0x040fe200078e00ffULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x000054104f4f7816ULL, 0x010fc4000000004cULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001100167306ULL, 0x0007e20000200c00ULL,
0x0000541053537816ULL, 0x004fce000000004aULL, 0x0000001400177306ULL, 0x000ea20000200c00ULL,
0x000054105a117816ULL, 0x008fe40000000049ULL, 0x000054105f5f7816ULL, 0x002fca0000000048ULL,
0x000000101c2c723cULL, 0x000fe2000000182cULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541016167816ULL, 0x004fce0000000017ULL, 0x0000004600467306ULL, 0x000ff00000200c00ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000ff00000200c00ULL,
0x0000004e004e7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000eb00000200c00ULL,
0x0000006f00607306ULL, 0x000ee20000200c00ULL, 0x00005410454e7816ULL, 0x002fce000000004eULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541051527816ULL, 0x004fe20000000058ULL,
0x0000004e1c38723cULL, 0x040fec0000001838ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000054105d5e7816ULL, 0x008fe20000000060ULL, 0x000000521c30723cULL, 0x040fec0000001830ULL,
0x0000005400547306ULL, 0x000ea40000200c00ULL, 0x0000005e1c28723cULL, 0x000fec0000001828ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x002fce0000000055ULL,
0x0000006100127306ULL, 0x000e620000200c00ULL, 0x0000541054657816ULL, 0x004fce0000000047ULL,
0x0000001300117306ULL, 0x0004e20000200c00ULL, 0x000000641c24723cULL, 0x000fe20000001824ULL,
0x0000541057127816ULL, 0x002fe40000000012ULL, 0x0000541015137816ULL, 0x004fe40000000046ULL,
0x0000541011177816ULL, 0x008fca0000000044ULL, 0x000000121c20723cULL, 0x040ff00000001820ULL,
0x000000161c18723cULL, 0x000fe20000001818ULL, 0xfffff0d000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0006ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe4d000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00f61400050b7984ULL, 0x000e620000000800ULL,
0x0000ffff080a7812ULL, 0x000fe200078ec0ffULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x000fe20000410000ULL,
0x000088800a3c7816ULL, 0x000fe200000000ffULL, 0x00000028040e7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x000fe20000410000ULL, 0x800000003c0a7824ULL, 0x000fe200078e00ffULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003a043a7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x00000035040c7220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x00000031040d7220ULL, 0x040fe20000410000ULL, 0x0000003204107220ULL, 0x040fe20000410000ULL,
0x0000003304117220ULL, 0x040fe20000410000ULL, 0x0000002e04127220ULL, 0x040fe20000410000ULL,
0x0000002a041c7220ULL, 0x040fe20000410000ULL, 0x0000002704137220ULL, 0x040fe20000410000ULL,
0x0000002204147220ULL, 0x040fe20000410000ULL, 0x00000025042a7220ULL, 0x040fe20000410000ULL,
0x0000001a04157220ULL, 0x040fe20000410000ULL, 0x0000001b04167220ULL, 0x040fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x0000002f041f7220ULL, 0x040fe20000410000ULL,
0x0000002b041d7220ULL, 0x040fe20000410000ULL, 0x00000026041e7220ULL, 0x040fe20000410000ULL,
0x0000002304177220ULL, 0x040fe20000410000ULL, 0x0000001804277220ULL, 0x040fe20000410000ULL,
0x00000019042e7220ULL, 0x040fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e002cULL,
0x0000002904297220ULL, 0x000fe20000410000ULL, 0x000000ffff287224ULL, 0x000fc400078e002dULL,
0x000000ffff1a7224ULL, 0x000fe200078e000eULL, 0x800000000bff7812ULL, 0x002fe2000780480aULL,
0x000000ffff227224ULL, 0x000fe400078e0020ULL, 0x000000ffff247224ULL, 0x000fe400078e0021ULL,
0x000000ffff357224ULL, 0x000fe400078e0038ULL, 0x000000ffff337224ULL, 0x000fe400078e0039ULL,
0x000000ffff327224ULL, 0x000fc400078e0034ULL, 0x000000ffff317224ULL, 0x000fe400078e000cULL,
0x000000ffff2f7224ULL, 0x000fe400078e0030ULL, 0x000000ffff197224ULL, 0x000fe400078e000dULL,
0x000000ffff267224ULL, 0x000fe400078e003aULL, 0x000000ffff2d7224ULL, 0x000fe400078e003bULL,
0x000000ffff187224ULL, 0x000fc400078e0036ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0037ULL,
0x000000ffff217224ULL, 0x000fe400078e0010ULL, 0x000000ffff237224ULL, 0x000fe400078e0011ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff207224ULL, 0x000fe400078e0013ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0014ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0015ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0016ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000003c3c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x3fa000000a0a7823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x00f61400050b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004020a7824ULL, 0x000fe200078e00ffULL, 0x000000074200720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff00a107812ULL, 0x000fca00078ec0ffULL,
0x00000080410b7824ULL, 0x000fca00078e0210ULL, 0x00f400000b107984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202147824ULL, 0x000fe400078e00ffULL,
0x0000000140097824ULL, 0x000fc600078e0a09ULL, 0x0000000614147812ULL, 0x000fc800078ec0ffULL,
0x0000000114167812ULL, 0x040fe400078efcffULL, 0x0000000814307812ULL, 0x000fe400078efcffULL,
0x000000091600720cULL, 0x080fe40003f26070ULL, 0x0000001014167812ULL, 0x000fe400078efcffULL,
0x000000093000720cULL, 0x080fe40003f06070ULL, 0x000000091600720cULL, 0x000fc40003fc6070ULL,
0x0000001114307812ULL, 0x040fe400078efcffULL, 0x0000001814167812ULL, 0x040fe400078efcffULL,
0x000000091400720cULL, 0x080fe40003f46070ULL, 0x000000093000720cULL, 0x080fe40003fa6070ULL,
0x000000091600720cULL, 0x000fe40003f66070ULL, 0x0000000914347812ULL, 0x000fc400078efcffULL,
0x0000001914307812ULL, 0x040fe400078efcffULL, 0x0000002014167812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005000000ULL, 0xff7fffff35357808ULL, 0x000fe40005000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL, 0xff7fffff33337808ULL, 0x000fc40004800000ULL,
0x000000093400720cULL, 0x080fe40003f86070ULL, 0x000000093000720cULL, 0x080fe40003f46070ULL,
0x000000091600720cULL, 0x000fe40003f26070ULL, 0x0000002114307812ULL, 0x040fe400078efcffULL,
0x0000002814167812ULL, 0x000fe400078efcffULL, 0xff7fffff18187808ULL, 0x000fc40004000000ULL,
0xff7fffff32327808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x000000093000720cULL, 0x080fe40003f06070ULL,
0x000000091600720cULL, 0x000fe40003f86070ULL, 0x0000002914307812ULL, 0x000fc400078efcffULL,
0x0000003014167812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40007000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff19197808ULL, 0x000fe40006800000ULL, 0x000000093000720cULL, 0x000fc40003fc6070ULL,
0x000000091600720cULL, 0x000fe40003fa6070ULL, 0x0000003114307812ULL, 0x040fe400078efcffULL,
0x0000003814167812ULL, 0x040fe400078efcffULL, 0x0000003914147812ULL, 0x000fe400078efcffULL,
0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fc40005800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff28287808ULL, 0x000fe40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40004800000ULL,
0x000000093000720cULL, 0x080fe40003f66070ULL, 0x000000091600720cULL, 0x000fc40003f46070ULL,
0x000000091400720cULL, 0x000fe40003f26070ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff20207808ULL, 0x000fc40007000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40006800000ULL,
0xff7fffff22227808ULL, 0x000fe40006800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff24247808ULL, 0x000fe40005800000ULL, 0xff7fffff0d0d7808ULL, 0x000fc40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004800000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003510107209ULL, 0x004fe20007810000ULL, 0x0000001fff387424ULL, 0x000fe200078e00ffULL,
0x0000002611147209ULL, 0x000fe20007810000ULL, 0xffffffffff3b7424ULL, 0x000fe200078e00ffULL,
0x0000003310097209ULL, 0x000fe40007810000ULL, 0x0000002d14117209ULL, 0x000fc40007810000ULL,
0x0000003209107209ULL, 0x000fe40007810000ULL, 0x0000001811117209ULL, 0x000fe40007810000ULL,
0x0000003110107209ULL, 0x000fe40007810000ULL, 0x0000002c11147209ULL, 0x000fe40007810000ULL,
0x0000002f10107209ULL, 0x000fe40007810000ULL, 0x0000002114147209ULL, 0x000fc40007810000ULL,
0x0000001910107209ULL, 0x000fe40007810000ULL, 0x0000002314147209ULL, 0x000fe40007810000ULL,
0x0000001b10097209ULL, 0x000fe40007810000ULL, 0x0000002b14147209ULL, 0x000fe40007810000ULL,
0x0000002809097209ULL, 0x000fe40007810000ULL, 0x0000001f14117209ULL, 0x000fc40007810000ULL,
0x0000001a09107209ULL, 0x000fe40007810000ULL, 0x0000001c11147209ULL, 0x000fe40007810000ULL,
0x0000002910107209ULL, 0x000fe40007810000ULL, 0x0000001d14097209ULL, 0x000fe40007810000ULL,
0x0000002510117209ULL, 0x000fe40007810000ULL, 0x0000001e09097209ULL, 0x000fc40007810000ULL,
0x0000002a11117209ULL, 0x000fe40007810000ULL, 0x0000002009097209ULL, 0x000fe40007810000ULL,
0x0000002211117209ULL, 0x000fe40007810000ULL, 0x0000000e09107209ULL, 0x000fe40007810000ULL,
0x0000002411147209ULL, 0x000fe40007810000ULL, 0x0000001710107209ULL, 0x000fc40007810000ULL,
0x0000002714097209ULL, 0x000fe40007810000ULL, 0x0000000d10117209ULL, 0x000fe40007810000ULL,
0x0000002e09147209ULL, 0x000fe40007810000ULL, 0x0000000c11347209ULL, 0x000fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0014097f89ULL, 0x0004e400000e0000ULL,
0x0000000914367209ULL, 0x008fe20007810000ULL, 0x00000ec27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034097f89ULL, 0x000ee800000e0000ULL, 0x0c401f0012117f89ULL, 0x000f2800000e0000ULL,
0x0c401f0013147f89ULL, 0x004ea800000e0000ULL, 0x0c201f0036157f89ULL, 0x000f6200000e0000ULL,
0x0000000934107209ULL, 0x008fc40007810000ULL, 0x0000001112117209ULL, 0x010fc60007810000ULL,
0x0c201f0010377f89ULL, 0x002e6200000e0000ULL, 0x0000001413097209ULL, 0x004fc60007810000ULL,
0x0c201f0011167f89ULL, 0x000ea200000e0000ULL, 0x0000001536147209ULL, 0x020fc60007810000ULL,
0x0c201f0009307f89ULL, 0x00072200000e0000ULL, 0x0000003710157209ULL, 0x002fe40007810000ULL,
0x0000001611167209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b14107820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010810ULL,
0x0000003300127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010810ULL,
0x0000002800337308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010810ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010810ULL, 0x3fb8aa3b2e107823ULL, 0x000fc60000010810ULL,
0x0000001900347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15287820ULL, 0x008fc80000410000ULL,
0x3fb8aa3b18117823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010828ULL,
0x00000022003a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010828ULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b0c0c7823ULL, 0x000fce0000010828ULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000351218723eULL, 0x008fce00000000ffULL, 0x0000002600197308ULL, 0x0007f00000000800ULL,
0x0000002d00227308ULL, 0x000a620000000800ULL, 0x3fb8aa3b1d267823ULL, 0x008fce0000010828ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000000fff2d7424ULL, 0x020fce00078e00ffULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x000000192219723eULL, 0x002fce00000000ffULL,
0x0000001b00367308ULL, 0x0007f00000000800ULL, 0x0000001a00377308ULL, 0x0003e20000000800ULL,
0x000000112c1b723eULL, 0x008fce00000000ffULL, 0x0000002500397308ULL, 0x0007e20000000800ULL,
0x00000032311a723eULL, 0x002fce00000000ffULL, 0x00000024003b7308ULL, 0x0003e20000000800ULL,
0x3c003c00ff257424ULL, 0x008fce00078e00ffULL, 0x00000010002e7308ULL, 0x0007e20000000800ULL,
0x3c003c00ff247424ULL, 0x002fce00078e00ffULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000241810723cULL, 0x008fee00000018ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x00000023003c7308ULL, 0x0007700000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c237823ULL, 0x008fe20000010828ULL, 0x0000002f341c723eULL, 0x002fcc00000000ffULL,
0x0000001f00227308ULL, 0x000e620000000800ULL, 0x000000213c1d723eULL, 0x020fce00000000ffULL,
0x0000002900387308ULL, 0x0007620000000800ULL, 0x0000002b221f723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b1e297823ULL, 0x108fe20000010828ULL, 0x00000036331e723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b202b7823ULL, 0x000fc80000010828ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000003a3b28723eULL, 0x000fe400000000ffULL, 0x000000373820723eULL, 0x020fe200000000ffULL,
0x000000241c10723cULL, 0x000fe80000001810ULL, 0x0000002600267308ULL, 0x000e700000000800ULL,
0x0000002a002a7308ULL, 0x000ef00000000800ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000232621723eULL, 0x002fc400000000ffULL, 0xfffffffc02267812ULL, 0x000fc800078ec0ffULL,
0x000000262d2d7219ULL, 0x000fe200000006ffULL, 0x0000002b002c7308ULL, 0x000e620000000800ULL,
0x000000392a22723eULL, 0x008fe400000000ffULL, 0x000000002d2673a1ULL, 0x000ee200000e8000ULL,
0x000000002d0473c4ULL, 0x000f680000004000ULL, 0x0000002700277308ULL, 0x000f220000000800ULL,
0x000000292c23723eULL, 0x002fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000242010723cULL, 0x000fe20000001810ULL, 0x000000272e2a723eULL, 0x010fcc00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000052dff7c12ULL, 0x008fce000f804026ULL,
0x0000000d000d7308ULL, 0x000ff00000000800ULL, 0x0000000c000c7308ULL, 0x000ee20000000800ULL,
0x0000000e1729723eULL, 0x002fe400000000ffULL, 0x0000000930177209ULL, 0x004fc40007810000ULL,
0x0000000d0c2b723eULL, 0x008fce00000000ffULL, 0x000000242810723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000009f204008947ULL, 0x020fde000b800000ULL,
0x001c1fff10247589ULL, 0x0002a400000e0000ULL, 0x000000002d0c73a1ULL, 0x000ee200000e8000ULL,
0x000000002d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000052dff7c12ULL, 0x008fda000f80400cULL, 0x00000a1204008947ULL, 0x010fea000b800000ULL,
0x001c1fff12257589ULL, 0x00072800000e0000ULL, 0x001c1fff26267589ULL, 0x00066800000e0000ULL,
0x001c1fff00277589ULL, 0x0006a400000e0000ULL, 0x00000002ff097819ULL, 0x002fe40000011602ULL,
0x0000000c0a3b7812ULL, 0x000fc400078ec0ffULL, 0x00000007090c7812ULL, 0x040fe200078ec0ffULL,
0x0000000809137824ULL, 0x040fe200078e00ffULL, 0x00000009ff117212ULL, 0x000fe200078e33ffULL,
0x00000008090d7824ULL, 0x040fe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000809347824ULL, 0x040fe200078e00ffULL, 0x0000000809097810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8130e7812ULL, 0x100fe400078ee20cULL, 0x000000010d107812ULL, 0x100fe200078ef60cULL,
0x0000000809487824ULL, 0x000fe200078e00ffULL, 0x000000020d127812ULL, 0x108fe200078ef60cULL,
0x0000000809137824ULL, 0x000fe200078e00ffULL, 0x000000030d2c7812ULL, 0x000fc400078ef60cULL,
0x000000040d2e7812ULL, 0x140fe400078ef60cULL, 0x000000050d307812ULL, 0x140fe400078ef60cULL,
0x000000060d327812ULL, 0x000fe200078ef60cULL, 0x00000008090d7824ULL, 0x040fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe400078ee211ULL, 0x00000009ff117212ULL, 0x000fe400078e33ffULL,
0x00000007090c7812ULL, 0x000fc400078ec0ffULL, 0x0000900041097811ULL, 0x000fe400078e58ffULL,
0xfffffff813367812ULL, 0x100fe400078ee20cULL, 0x000000010d387812ULL, 0x140fe200078ef60cULL,
0x000000100e0a7824ULL, 0x000fe200078e0209ULL, 0xfffffff848487812ULL, 0x000fe200078ee211ULL,
0x00000010120e7824ULL, 0x100fe200078e0209ULL, 0x000000020d3a7812ULL, 0x140fe200078ef60cULL,
0x000000102e127824ULL, 0x100fe200078e0209ULL, 0x000000030d3c7812ULL, 0x140fe200078ef60cULL,
0x00000010322e7824ULL, 0x100fe200078e0209ULL, 0x000000040d3e7812ULL, 0x140fe200078ef60cULL,
0x0000001038327824ULL, 0x100fe200078e0209ULL, 0x000000050d447812ULL, 0x140fe200078ef60cULL,
0x000000103c357824ULL, 0x100fe200078e0209ULL, 0x000000060d467812ULL, 0x000fe200078ef60cULL,
0x00000010100c7824ULL, 0x000fc400078e0209ULL, 0x000000102c107824ULL, 0x100fe400078e0209ULL,
0x00000010302c7824ULL, 0x100fe400078e0209ULL, 0x000000013b0d7824ULL, 0x000fe400078e020aULL,
0x0000001034307824ULL, 0x100fe400078e0209ULL, 0x00000010360a7824ULL, 0x100fe200078e0209ULL,
0x000000180d007388ULL, 0x0003e20000000800ULL, 0x000000103a347824ULL, 0x000fc400078e0209ULL,
0x000000103e367824ULL, 0x100fe400078e0209ULL, 0x0000001044377824ULL, 0x100fe400078e0209ULL,
0x0000001046387824ULL, 0x100fe400078e0209ULL, 0x0000001048397824ULL, 0x000fe400078e0209ULL,
0x000000013b097824ULL, 0x040fe400078e020cULL, 0x000000013b117824ULL, 0x000fc400078e020eULL,
0x000000013b137824ULL, 0x040fe200078e0210ULL, 0x0000001a09007388ULL, 0x0003e20000000800ULL,
0x000000013b2d7824ULL, 0x040fe400078e0212ULL, 0x000000013b2f7824ULL, 0x040fe200078e022cULL,
0x0000001c11007388ULL, 0x0003e20000000800ULL, 0x000000013b317824ULL, 0x040fe400078e022eULL,
0x000000013b337824ULL, 0x040fe200078e0230ULL, 0x0000001e13007388ULL, 0x0003e20000000800ULL,
0x000000013b0a7824ULL, 0x000fc400078e020aULL, 0x000000013b327824ULL, 0x040fe200078e0232ULL,
0x000000202d007388ULL, 0x0003e20000000800ULL, 0x000000013b347824ULL, 0x040fe400078e0234ULL,
0x000000013b0c7824ULL, 0x040fe200078e0235ULL, 0x000000222f007388ULL, 0x0003e20000000800ULL,
0x000000013b367824ULL, 0x040fe400078e0236ULL, 0x000000013b0e7824ULL, 0x040fe200078e0237ULL,
0x0000002831007388ULL, 0x0003e20000000800ULL, 0x000000013b387824ULL, 0x000fc400078e0238ULL,
0x000000013b107824ULL, 0x000fe200078e0239ULL, 0x0000002a33007388ULL, 0x0003e80000000800ULL,
0x000000190a007388ULL, 0x0003e80000000800ULL, 0x0000001b32007388ULL, 0x0003e80000000800ULL,
0x0000001d34007388ULL, 0x0003e80000000800ULL, 0x0000001f0c007388ULL, 0x0003e80000000800ULL,
0x0000002136007388ULL, 0x0003e80000000800ULL, 0x000000230e007388ULL, 0x0003e80000000800ULL,
0x0000002938007388ULL, 0x0003e80000000800ULL, 0x0000002b10007388ULL, 0x0003e80000000800ULL,
0x00f000140b008388ULL, 0x0003e80000000c00ULL, 0x00f200240b008388ULL, 0x0143e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030042427a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080005ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff08ff7812ULL, 0x000fc4000780c0ffULL,
0x0000000f4200720cULL, 0x000fe40003f26070ULL, 0x00000001ff087807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x004fe20003c00000ULL, 0xffffca7000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e003aULL,
0x0001071000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff097224ULL, 0x000fe400078e0055ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000006b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e000eULL,
0xffffa70000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x002fe200078e0055ULL,
0x0001079000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0039ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x004fea0003c00000ULL, 0xffffa6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0014ULL, 0x000107e000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fe400078e00ffULL, 0x000005a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0030ULL, 0xfffff12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0034ULL, 0x0001084000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x002fe400078e00ffULL, 0x0000054000007944ULL, 0x004fea0003c00000ULL,
0x0000003034157209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e0012ULL,
0x0001089000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x002fe400078e00ffULL,
0x000004f000007944ULL, 0x000fea0003c00000ULL, 0x0000003012397209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0013ULL, 0x000108e000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x002fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000003013097209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e0036ULL,
0x0001093000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x002fc400078e00ffULL,
0x0000045000007944ULL, 0x000fea0003c00000ULL, 0x0000003036147209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0015ULL, 0x0001098000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x002fc400078e00ffULL, 0x0000040000007944ULL, 0x000fea0003c00000ULL,
0x0000003015157209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e0039ULL,
0x000109d000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x002fc400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000003039167209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0009ULL, 0x00010a2000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x002fc400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0xffffefe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x000fe200078e0010ULL,
0x00010a9000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff3c7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3e7224ULL, 0x000fe400078e002dULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e000eULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x002fe200078e0012ULL,
0x00010b1000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff3c7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3e7224ULL, 0x000fe400078e002dULL,
0x000002b000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff3c7224ULL, 0x002fe200078e00ffULL,
0x00010b7000107802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fe400078e002dULL, 0x000000ffff257224ULL, 0x004fe400078e000eULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e002dULL,
0x00010bd000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff3c7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff267224ULL, 0x004fe400078e000eULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e000eULL,
0xfffff4e000007947ULL, 0x000fea000383ffffULL, 0x0180000006027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000600028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000006037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffef28002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c00003730307389ULL, 0x0002a200000e0038ULL, 0xfffef24010007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0000003c090e7389ULL, 0x0002a200000e003bULL, 0xfffef20010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000220ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007b8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000830ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000edcULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f30ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fa0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000fb8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000010f00ULL, 0x9b00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000fa0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000110e0ULL, 0x00000000000110e0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin_len = 75248;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
