/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012f90ULL, 0x0000000000012b10ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000011860ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x00000000000119f0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000011a30ULL, 0x00000000000000d0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000011b00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001186000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0045740400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080890828808081ULL, 0x86082880808a0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808086920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001186000000000ULL, 0x0000019000000000ULL,
0x00005c0400000000ULL, 0x8082288080860900ULL, 0x0000000000002880ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x93082880808e0828ULL, 0x288080ac08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080acULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x000119f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x93082880808e0828ULL, 0x288080ac08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080acULL, 0x0000001cffffffffULL, 0x0000018000000000ULL,
0x00011a3000000000ULL, 0x000000d000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000b9ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005001600000000dULL, 0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x000105b000183104ULL, 0x00010b3000010b10ULL,
0x00010be000010bd0ULL, 0x00c0290400010bf0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002005000020ULL, 0x0500002005000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000a000c02804ULL, 0x00001c20000000d0ULL,
0x00001d6000001cc0ULL, 0x00002d4000001d90ULL, 0x00004e5000002e00ULL, 0x00004fb000004f00ULL,
0x0000600000005000ULL, 0x000075d000006050ULL, 0x0000798000007600ULL, 0x0000a3d000007990ULL,
0x0000a8c00000a3f0ULL, 0x000104900000a8f0ULL, 0x000104d0000104c0ULL, 0x00010500000104e0ULL,
0x0001054000010520ULL, 0x00010bc000010550ULL, 0x00010c3000010c20ULL, 0x0001128000010c40ULL,
0x00011360000112f0ULL, 0x00011450000113e0ULL, 0x00011530000114c0ULL, 0x00011610000115a0ULL,
0x000116f000011680ULL, 0x000117d000011770ULL, 0x0280390400011830ULL, 0x000000ff00000160ULL,
0x003f01000001b600ULL, 0x0000000f000001a0ULL, 0x003f01300001b608ULL, 0x0000000f000001d0ULL,
0x003f01300001b610ULL, 0x0000000f00000200ULL, 0x003f01200001b648ULL, 0x0000000f00000230ULL,
0x003f01200001b668ULL, 0x000000ff00000460ULL, 0x003f01070001b600ULL, 0x00000005000006c0ULL,
0x003f010200000004ULL, 0x0000000500000af0ULL, 0x003f010100000000ULL, 0x000000ff00000e00ULL,
0x0004010700000000ULL, 0x0000000e00000e80ULL, 0x003f010100000020ULL, 0x0000000d000010b0ULL,
0x003f01060001b66cULL, 0x0000000d00001120ULL, 0x003f01060001b66cULL, 0x0000000d000011b0ULL,
0x003f01060001b66cULL, 0x00000048000019a0ULL, 0x0004010700000000ULL, 0x0000004a00001a10ULL,
0x0004010600000004ULL, 0x0000000700001a30ULL, 0x003f01060001b60cULL, 0x0000000700001b40ULL,
0x003f010600000004ULL, 0x0000004a00002010ULL, 0x0004010600000004ULL, 0x0000004a000020b0ULL,
0x0004010600000004ULL, 0x0000000800004180ULL, 0x003f010100000000ULL, 0x0000000700004200ULL,
0x003f010100000000ULL, 0x0000000d000042b0ULL, 0x003f01060001b66cULL, 0x0000000d00004300ULL,
0x003f01060001b66cULL, 0x0000000800004390ULL, 0x003f010600000004ULL, 0x000000ff00004bc0ULL,
0x0004010700000000ULL, 0x0000000700004c30ULL, 0x003f010600000004ULL, 0x0000001500004c50ULL,
0x003f01060001b62cULL, 0x0000000d00004d60ULL, 0x003f010600000004ULL, 0x00000008000052d0ULL,
0x003f01060001b64cULL, 0x0000000700005360ULL, 0x003f010600000004ULL, 0x0000000800007250ULL,
0x003f010100000000ULL, 0x00000007000072c0ULL, 0x003f010100000000ULL, 0x000000ff0000ce00ULL,
0x003f01060001b604ULL, 0x000000ff0000ce90ULL, 0x003f01060001b604ULL, 0x000000ff0000d0b0ULL,
0x003f01010001b600ULL, 0x000000ff0000d0c0ULL, 0x003f01060001b604ULL, 0x000000ff0000d140ULL,
0x003f01060001b604ULL, 0x000000310000f9c0ULL, 0x003f01060001b614ULL, 0x000000310000fd90ULL,
0x003f01060001b614ULL, 0x00000031000111c0ULL, 0x003f01010001b608ULL, 0x00141c0400053803ULL,
0x0000b7300000b2e0ULL, 0x0000d2300000d190ULL, 0x0000040100011230ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001ecULL, 0x0000001100000002ULL, 0x000000000000016cULL, 0x0000001100000002ULL,
0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001c7ULL, 0x0000001100000002ULL, 0x0000000000000147ULL, 0x0000001100000002ULL,
0x00000000000000b2ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000517919ULL, 0x000ea80000002100ULL, 0x00000000004d7919ULL, 0x000ee80000002700ULL,
0x00000000000e7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e0251ULL, 0x00000005ff517819ULL, 0x000fe20000011651ULL,
0x00001fff06007589ULL, 0x0002a600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe20003f44070ULL, 0x00001fff51517589ULL, 0x000f2200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x00000004ff067424ULL, 0x002fe200078e00ffULL,
0x000000010f00780cULL, 0x000fc60003f64070ULL, 0x000060004d067625ULL, 0x008fc800078e0006ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL,
0x01b60002ff008388ULL, 0x0003e20000000a00ULL, 0x000000ff0000720cULL, 0x004fe20003f05270ULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x01b608040f00a388ULL, 0x0003e2000000ca00ULL, 0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x01b610080f00a388ULL, 0x0003e2000000ca00ULL,
0xff317217ff109424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x01b6480a0f00a388ULL, 0x0003e20000008a00ULL, 0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL,
0x01b400100f009388ULL, 0x0003e80000004800ULL, 0x01b6680c0f00b388ULL, 0x0003e80000008a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000027000000947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x012e620000000000ULL, 0x0000000451047824ULL, 0x000fc400078e00ffULL,
0x00005800ff027624ULL, 0x000fe400078e00ffULL, 0x000000100e037824ULL, 0x000fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x00000100ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000004d02027224ULL, 0x000fe200078e0203ULL, 0x000000040d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709087812ULL, 0x000fe400078ec0ffULL,
0x000000070b0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000102057824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000cULL,
0x0000000f08087812ULL, 0x100fe400078e780dULL, 0x0000000f0a0a7812ULL, 0x000fe200078e780dULL,
0x00005c0005047625ULL, 0x000fe200078e000cULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009087824ULL, 0x000fe200078e0208ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0a7824ULL, 0x000fe400078e020aULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001008097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c46ULL, 0x00000000040b7faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000606507981ULL, 0x010ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff537e24ULL, 0x008fe2000f8e00ffULL, 0x000000ff504e7810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff4e7819ULL, 0x000fce000001164eULL, 0x0000b20000008947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000002051027824ULL, 0x002fe200078e00ffULL,
0x000058000e047a10ULL, 0x000fe20007ffe0ffULL, 0x000000024d4d7824ULL, 0x000fe200078e00ffULL,
0x0000000153057810ULL, 0x000fe20007ffe0ffULL, 0x00000001ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000002002037812ULL, 0x000fe200078ec0ffULL, 0x000058004d4d7a24ULL, 0x000fe200078e0204ULL,
0x0000004e0500720cULL, 0x000fe40003f06070ULL, 0x0001b61051057811ULL, 0x000fc400078e20ffULL,
0x00000003ff167819ULL, 0x004fc80000011600ULL, 0x0000000416187810ULL, 0x000fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fc800078e0216ULL, 0x00000001030b7824ULL, 0x000fe200078e0218ULL,
0x0000000009047212ULL, 0x0c0fe200078e3cffULL, 0x0000000809077824ULL, 0x000fe400078e00ffULL,
0x000000080b0d7824ULL, 0x040fe200078e00ffULL, 0x000000000b067212ULL, 0x000fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000c161c7810ULL, 0x000fe20007ffe0ffULL,
0x0000040a05ff738cULL, 0x0003e20000000000ULL, 0x00000001ff4c7819ULL, 0x000fe20000011651ULL,
0x00000010002b7824ULL, 0x000fe200078e00ffULL, 0x00000008161a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001030f7824ULL, 0x000fe200078e021cULL, 0xfffffff807087812ULL, 0x000fe200078ee204ULL,
0x0000000453047824ULL, 0x000fe200078e024cULL, 0x00000010161e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee206ULL,
0x00000001030d7824ULL, 0x000fe200078e021aULL, 0x000000000f077212ULL, 0x080fe200078e3cffULL,
0x0000000103117824ULL, 0x000fe200078e021eULL, 0x0000001416207810ULL, 0x000fe20007ffe0ffULL,
0x0000004004047824ULL, 0x000fe200078e00ffULL, 0x000000000d067212ULL, 0x040fe200078e3cffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x0000001816227810ULL, 0x000fe20007ffe0ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fc400078ee207ULL,
0x0000001c16267810ULL, 0x000fe20007ffe0ffULL, 0x0000000103177824ULL, 0x000fe200078e0222ULL,
0x00000000110a7212ULL, 0x002fe400078e3cffULL, 0x0000000450077217ULL, 0x000fe20007800000ULL,
0x0000000103197824ULL, 0x000fe200078e0226ULL, 0xfffffff8130e7812ULL, 0x000fe200078ee206ULL,
0x000062004d067a24ULL, 0x000fe200078e0204ULL, 0xfffffff815127812ULL, 0x000fe200078ee20aULL,
0x0000000103137824ULL, 0x000fe200078e0220ULL, 0x000000702b2b7812ULL, 0x000fe200078ec0ffULL,
0x00000001070a7824ULL, 0x000fc400078e0a04ULL, 0x0000000106077824ULL, 0x000fe200078e0209ULL,
0x0000000013097212ULL, 0x0c0fe200078e3cffULL, 0x0000000813147824ULL, 0x000fe400078e00ffULL,
0x000040004c047824ULL, 0x000fe400078e00ffULL, 0x0000000106157824ULL, 0x040fe200078e0211ULL,
0x0000000017117212ULL, 0x0c0fe200078e3cffULL, 0x0000000817287824ULL, 0x000fe400078e00ffULL,
0x0000000106217824ULL, 0x000fe200078e0213ULL, 0x0000000019137212ULL, 0x040fe200078e3cffULL,
0x00000008192a7824ULL, 0x000fc400078e00ffULL, 0x00000001060b7824ULL, 0x040fe400078e020bULL,
0x00000001060d7824ULL, 0x040fe400078e020dULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106247824ULL, 0x040fe400078e0217ULL, 0x0000000106277824ULL, 0x000fe200078e0219ULL,
0xfffffff814067812ULL, 0x000fe400078ee209ULL, 0xfffffff828147812ULL, 0x000fc400078ee211ULL,
0x0001300004097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82a287812ULL, 0x000fe200078ee213ULL,
0x00000080ff2a7424ULL, 0x000fe400078e00ffULL, 0x0000001006237824ULL, 0x100fe400078e0209ULL,
0x0000001008177824ULL, 0x100fe400078e0209ULL, 0x000000100c197824ULL, 0x100fe400078e0209ULL,
0x000000100e1b7824ULL, 0x000fc400078e0209ULL, 0x00000010101d7824ULL, 0x100fe400078e0209ULL,
0x00000010121f7824ULL, 0x100fe400078e0209ULL, 0x0000001014257824ULL, 0x100fe400078e0209ULL,
0x0000001028297824ULL, 0x000fe400078e0209ULL, 0x00005e0007067625ULL, 0x000fe200078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00005e000b087625ULL, 0x080fe200078e002aULL,
0x000000400a127807ULL, 0x000fe20000000000ULL, 0x0000000005ff7f8cULL, 0x0003e2000c80043fULL,
0x0000002b060e7210ULL, 0x080fe20007f1e0ffULL, 0x00005e000d0a7625ULL, 0x080fe200078e002aULL,
0x0000002b08107210ULL, 0x000fe20007f3e0ffULL, 0x000000004c0473c2ULL, 0x000ea200000e0000ULL,
0x0000000312067217ULL, 0x000fe20007800000ULL, 0x00005e000f0c7625ULL, 0x000fe200078e002aULL,
0x00000001514f7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0609ULL,
0x0000002b0c147210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x0000002b0a127210ULL, 0x000fe20007f1e0ffULL, 0x0000000106057824ULL, 0x002fe400078e0a03ULL,
0x00005e0021087625ULL, 0x000fc600078e002aULL, 0x000000051600720cULL, 0x080fe20003f86070ULL,
0x00005e0015067625ULL, 0x080fe200078e002aULL, 0x000000051800720cULL, 0x080fe40003fa6070ULL,
0x000000051a00720cULL, 0x000fe20003f66070ULL, 0x000000ffff157224ULL, 0x000fe200008e060dULL,
0x0000002b08087210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e060bULL,
0x0000002b06067210ULL, 0x000fe20007f1e0ffULL, 0x00005e00270c7625ULL, 0x000fe200078e002aULL,
0x000000051c00720cULL, 0x000fe20003f46070ULL, 0x0001b64804047891ULL, 0x004fc4000f8e203fULL,
0x00005e00240a7625ULL, 0x000fe200078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000e101c46ULL, 0x000000052200720cULL, 0x000fe40003f86070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000002b0c0c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000002b0a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000010197faeULL, 0x0005e2000e901c46ULL, 0x000000052600720cULL, 0x080fe20003fa6070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000051e00720cULL, 0x080fe20003f26070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000052000720cULL, 0x000fe20003f06070ULL,
0x00000000121b7faeULL, 0x0005e2000d901c46ULL, 0x0001b6484c0e7811ULL, 0x002fc600078e18ffULL,
0x00000000141d7faeULL, 0x0005ec000d101c46ULL, 0x00000000061f7faeULL, 0x0005e8000c901c46ULL,
0x0000000008237faeULL, 0x0005e2000c101c46ULL, 0x0000004e5300720cULL, 0x000fc60003f06070ULL,
0x000000000a257faeULL, 0x0005e8000e101c46ULL, 0x000000000c297faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020000eff7f8cULL, 0x0003e2000c80043fULL, 0xff317217ff057424ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff067224ULL, 0x004fe200078e00ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000063e000000947ULL, 0x000fea0003800000ULL,
0xff317217ff057424ULL, 0x002fe200078e00ffULL, 0x00007610ff0a7816ULL, 0x000fe2000000000aULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00007610ff0b7816ULL, 0x000fe2000000000bULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x00007610ff0c7816ULL, 0x000fc4000000000cULL,
0xffffffc002087812ULL, 0x002fca00078ec0ffULL, 0x0000010053117824ULL, 0x000fca00078e0208ULL,
0x000000501100720cULL, 0x000fda0003f06070ULL, 0x000062e000000947ULL, 0x000fea0003800000ULL,
0x00000004510d7824ULL, 0x000fe200078e00ffULL, 0x0000ffff0a077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0e7224ULL, 0x000fc600078e0009ULL, 0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000888007137816ULL, 0x000fc600000000ffULL, 0x01b66c000d087984ULL, 0x000e640000000800ULL,
0x8000000013077824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000076100b0f7816ULL, 0x000fe4000000000fULL,
0x000076100a107816ULL, 0x000fe20000000010ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01b66c000d087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000013137824ULL, 0x000fe400078e00ffULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0002a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe40003800000ULL, 0x01b66c000d087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fc40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000000153077810ULL, 0x000fe20007ffe0ffULL,
0x00000008094a7824ULL, 0x000fe200078e00ffULL, 0x00000004131d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103147824ULL, 0x000fe200078e0213ULL, 0x0000000c131f7810ULL, 0x040fe40007ffe0ffULL,
0x00000008131e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103167824ULL, 0x000fe200078e021dULL,
0x0000004e0700720cULL, 0x000fe20003f06070ULL, 0x00000008144c7824ULL, 0x000fe200078e00ffULL,
0x0000001013257810ULL, 0x000fe20007ffe0ffULL, 0x0000000816157824ULL, 0x040fe200078e00ffULL,
0x0000000016087212ULL, 0x080fe200078e3cffULL, 0x00000001031a7824ULL, 0x040fe200078e021fULL,
0x0000000014077212ULL, 0x080fe200078e3cffULL, 0x0000000103187824ULL, 0x000fe200078e021eULL,
0xfffffff815527812ULL, 0x000fe200078ee208ULL, 0x000000081a157824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee207ULL, 0x0000000818547824ULL, 0x000fe200078e00ffULL,
0x000000001a087212ULL, 0x080fe200078e3cffULL, 0x00000001031c7824ULL, 0x000fe200078e0225ULL,
0x0000000018077212ULL, 0x000fc400078e3cffULL, 0x0000001413267810ULL, 0x000fe20007ffe0ffULL,
0x000000081c197824ULL, 0x000fe200078e00ffULL, 0xfffffff815567812ULL, 0x000fe400078ee208ULL,
0xfffffff854547812ULL, 0x000fe200078ee207ULL, 0x0000000103157824ULL, 0x000fe200078e0226ULL,
0x000000001c087212ULL, 0x000fe400078e3cffULL, 0x0000008011077810ULL, 0x000fe20007ffe0ffULL,
0x00000008155a7824ULL, 0x000fe200078e00ffULL, 0x00000018134b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0xfffffff819587812ULL, 0x000fc400078ee208ULL,
0x0000000750087217ULL, 0x000fe20007800000ULL, 0x00000001033c7824ULL, 0x000fe200078e024bULL,
0x0000000015177212ULL, 0x080fe400078e3cffULL, 0x0000001c13557810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a07ULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee217ULL,
0x000062004d077a24ULL, 0x000fe200078e0207ULL, 0x000000003c177212ULL, 0x040fe200078e3cffULL,
0x000000083c5c7824ULL, 0x000fe200078e00ffULL, 0x0000007011497812ULL, 0x000fe200078ec0ffULL,
0x0000000114147824ULL, 0x100fe200078e0207ULL, 0x0000004008087807ULL, 0x000fe20000000000ULL,
0x0000000115117824ULL, 0x000fe200078e0207ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee217ULL,
0x0000000103177824ULL, 0x040fe200078e0255ULL, 0x0000000803087217ULL, 0x000fe20007800000ULL,
0x00005e0014147625ULL, 0x000fe200078e003fULL, 0x00000001ff747819ULL, 0x000fc40000011651ULL,
0x000000084a487812ULL, 0x000fe200078e0cffULL, 0x0000000116167824ULL, 0x100fe200078e0207ULL,
0x0000004914147210ULL, 0x000fe20007f1e0ffULL, 0x0000000118187824ULL, 0x100fe200078e0207ULL,
0x00000000480573c2ULL, 0x000e6200000e0000ULL, 0x000000011a1a7824ULL, 0x100fe400078e0207ULL,
0x000000011c1c7824ULL, 0x100fe400078e0207ULL, 0x000000013c3c7824ULL, 0x100fe400078e0207ULL,
0x00000001173e7824ULL, 0x040fe200078e0207ULL, 0x0000000017077212ULL, 0x040fe200078e3cffULL,
0x00000008175e7824ULL, 0x000fc400078e00ffULL, 0x00005e0016167625ULL, 0x000fc600078e003fULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee207ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000004916167210ULL, 0x000fe20007f1e0ffULL, 0x00005e0018187625ULL, 0x000fc800078e003fULL,
0x0000000108087824ULL, 0x000fe200078e0a03ULL, 0x0000004918187210ULL, 0x000fe20007f3e0ffULL,
0x00005e001a1a7625ULL, 0x000fc600078e003fULL, 0x000000081d00720cULL, 0x080fe20003fa6070ULL,
0x0000200009077824ULL, 0x000fe200078e00ffULL, 0x000000081300720cULL, 0x080fe20003f86070ULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x000000081e00720cULL, 0x080fe20003f06070ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000491a1e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e003fULL, 0x0000200007077812ULL, 0x000fe400078e0cffULL,
0x000000081f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff1f7224ULL, 0x000fe200010e061bULL,
0x000000491c247210ULL, 0x000fe20007f7e0ffULL, 0x00005e00111a7625ULL, 0x000fe200078e003fULL,
0x000000082500720cULL, 0x000fc60003f46070ULL, 0x0000400074117824ULL, 0x040fe400078e0207ULL,
0x0000001074077824ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200018e061dULL,
0x000000082600720cULL, 0x000fe20003f66070ULL, 0x00000000070473c2ULL, 0x000ea200000e0000ULL,
0x000000491a267210ULL, 0x000fe20007fde0ffULL, 0x00005e003e1c7625ULL, 0x000fe200078e003fULL,
0x0001300011117810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200030e061bULL,
0x000000491c1c7210ULL, 0x000fe20007fde0ffULL, 0x000000104c137824ULL, 0x000fe400078e0211ULL,
0x00005e003c1a7625ULL, 0x000fc600078e003fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014137faeULL, 0x0007e2000e101c46ULL, 0x00000010523d7824ULL, 0x100fe200078e0211ULL,
0x000000491a1a7210ULL, 0x000fe20007f9e0ffULL, 0x00000010543f7824ULL, 0x100fe400078e0211ULL,
0x0000001056497824ULL, 0x000fe200078e0211ULL, 0x00000000163d7faeULL, 0x0009e2000e901c46ULL,
0x000000084b00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x000000085500720cULL, 0x000fe20003f86070ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0001b64804047890ULL, 0x004fe2000fffe03fULL, 0x0000001058137824ULL, 0x108fe200078e0211ULL,
0x00000000183f7faeULL, 0x0005e2000c101c46ULL, 0x000000105a157824ULL, 0x000fe200078e0211ULL,
0x0000000504057290ULL, 0x002fc4000fffe03fULL, 0x000000001e497faeULL, 0x0005e2000c901c46ULL,
0x000000105c177824ULL, 0x110fe400078e0211ULL, 0x000000105e3d7824ULL, 0x000fe200078e0211ULL,
0x0000000024137faeULL, 0x0005e8000d101c46ULL, 0x0000000026157faeULL, 0x0005e8000d901c46ULL,
0x000000001a177faeULL, 0x0005e8000e901c46ULL, 0x000000001c3d7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004044a147984ULL, 0x0002e20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b60c0007167984ULL, 0x000f220000000800ULL,
0x0000ffff0b087812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0c137812ULL, 0x004fe400078ec0ffULL,
0x0000888008177816ULL, 0x000fe400000000ffULL, 0x0000888013087816ULL, 0x000fc600000000ffULL,
0x8000000017137824ULL, 0x000fe400078e00ffULL, 0x8000000008157824ULL, 0x000fc600078e00ffULL,
0x8000000014ff7812ULL, 0x008fe40007804813ULL, 0x8000000016ff7812ULL, 0x010fe20007824815ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x8000000008137824ULL, 0x000fe200078e00ffULL, 0x0001b60874077811ULL, 0x000fe200078e20ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800147305ULL, 0x0004e4000021f000ULL,
0x3fa0000008087823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x008fe40003800000ULL,
0x0000040007147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007824813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000001000197824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011600ULL,
0x00000001ff6e7424ULL, 0x000fc600078e00ffULL, 0x0000007019137812ULL, 0x000fe400078ec0ffULL,
0x0000000c07087812ULL, 0x000fc600078ec0ffULL, 0x0000008074077824ULL, 0x000fc800078e0213ULL,
0x0000000107077824ULL, 0x000fca00078e0208ULL, 0x01b0000007087984ULL, 0x000ea80000000800ULL,
0x01b2000007137984ULL, 0x0007220000000800ULL, 0x000000050800720bULL, 0x004fda0003f3d000ULL,
0x0000000000147806ULL, 0x000fc800008e0100ULL, 0x0000ffff14167812ULL, 0x000fda000782c0ffULL,
0x000003a000009947ULL, 0x000fea0003800000ULL, 0x000000050800720bULL, 0x018fe40003f54000ULL,
0x0000000805187209ULL, 0x040fe40007810000ULL, 0x00000002ff147819ULL, 0x000fe40000011600ULL,
0x000000517400720cULL, 0x000fe20003f25270ULL, 0x8000001805077221ULL, 0x000fe20000010000ULL,
0x0000000814157810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b07077820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fc800010e0100ULL, 0x0000ffff05057812ULL, 0x000fe200078e3cffULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x00000070191a9812ULL, 0x000fe400078ec0ffULL,
0x0000000516ff7212ULL, 0x000fe4000784c0ffULL, 0x00000001ff169819ULL, 0x000fe20000011600ULL,
0x0000008051059824ULL, 0x000fe200078e021aULL, 0x00000001ff6e7807ULL, 0x000fe40001000000ULL,
0x0000000c16169812ULL, 0x000fca00078ec0ffULL, 0x0000000116059824ULL, 0x000fe200078e0205ULL,
0x00001f1507157589ULL, 0x004ea200000e0000ULL, 0x8000001808082221ULL, 0x000fe40000010000ULL,
0x0000000706067220ULL, 0x000fe20000410000ULL, 0x00001f1407147589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b08082820ULL, 0x000fc60000410000ULL, 0x01b4001805009388ULL, 0x0009e20000000800ULL,
0x0000000800122308ULL, 0x000f620000000800ULL, 0x000000ffff057224ULL, 0x010fe400078e0018ULL,
0x000000153b3b7220ULL, 0x084fe40000410000ULL, 0x000000153a3a7220ULL, 0x080fe40000410000ULL,
0x0000001543437220ULL, 0x080fe40000410000ULL, 0x0000001542427220ULL, 0x000fc40000410000ULL,
0x0000001547477220ULL, 0x080fe40000410000ULL, 0x0000001546467220ULL, 0x080fe40000410000ULL,
0x0000001537377220ULL, 0x080fe40000410000ULL, 0x0000001536367220ULL, 0x080fe40000410000ULL,
0x0000001533337220ULL, 0x080fe40000410000ULL, 0x0000001532327220ULL, 0x000fc40000410000ULL,
0x0000001523237220ULL, 0x080fe40000410000ULL, 0x0000001522227220ULL, 0x080fe40000410000ULL,
0x000000152b2b7220ULL, 0x080fe40000410000ULL, 0x000000152a2a7220ULL, 0x080fe40000410000ULL,
0x000000152f2f7220ULL, 0x080fe40000410000ULL, 0x000000152e2e7220ULL, 0x000fc40000410000ULL,
0x0000001439397220ULL, 0x088fe40000410000ULL, 0x0000001438387220ULL, 0x080fe40000410000ULL,
0x0000001441417220ULL, 0x080fe40000410000ULL, 0x0000001440407220ULL, 0x080fe40000410000ULL,
0x0000001445457220ULL, 0x080fe40000410000ULL, 0x0000001444447220ULL, 0x000fc40000410000ULL,
0x0000001435357220ULL, 0x080fe40000410000ULL, 0x0000001434347220ULL, 0x080fe40000410000ULL,
0x0000001431317220ULL, 0x080fe40000410000ULL, 0x0000001430307220ULL, 0x080fe40000410000ULL,
0x0000001421217220ULL, 0x080fe40000410000ULL, 0x0000001420207220ULL, 0x000fc40000410000ULL,
0x0000001429297220ULL, 0x080fe40000410000ULL, 0x0000001428287220ULL, 0x080fe40000410000ULL,
0x000000142d2d7220ULL, 0x080fe40000410000ULL, 0x000000142c2c7220ULL, 0x000fe40000410000ULL,
0x0000001213132220ULL, 0x020fc80000410000ULL, 0x0000000613067221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x000004044a077984ULL, 0x000ea20008000800ULL,
0x8000000017087824ULL, 0x000fca00078e00ffULL, 0x8000000007ff7812ULL, 0x004fe20007804808ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000017177824ULL, 0x000fe400078e00ffULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0004e4000021f000ULL, 0x3fa0000007077823ULL, 0x004fe200000100ffULL,
0x000000080000735dULL, 0x008fe40003800000ULL, 0x000004044a087984ULL, 0x000ea40008000800ULL,
0x8000000008ff7812ULL, 0x004fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000451077824ULL, 0x000fe200078e00ffULL,
0x0000000800137812ULL, 0x000fe200078ec0ffULL, 0x0000200009547824ULL, 0x000fe200078e0204ULL,
0x00000001ff4c7819ULL, 0x000fe40000011651ULL, 0x0000000407077812ULL, 0x000fe400078ec0ffULL,
0x00000007131b7812ULL, 0x140fe200078ec800ULL, 0x000000024c577824ULL, 0x000fe200078e0209ULL,
0x0000000700187211ULL, 0x000fe400078fe0ffULL, 0x0000000713197812ULL, 0x000fc400078ef800ULL,
0x000000181b147212ULL, 0x000fe400078e3cffULL, 0x0001300054547810ULL, 0x000fe40007ffe0ffULL,
0x00000080195b7811ULL, 0x040fe200078e18ffULL, 0x0000000819077824ULL, 0x040fe200078e0214ULL,
0x0000010019557811ULL, 0x040fe400078e18ffULL, 0x0000018019597811ULL, 0x000fe200078e18ffULL,
0x0000001007077824ULL, 0x100fe200078e0254ULL, 0x0001300057577811ULL, 0x000fe200078e68ffULL,
0x0000000114157824ULL, 0x000fe200078e025bULL, 0x0000000218527810ULL, 0x000fe20007ffe0ffULL,
0x0000000114177824ULL, 0x000fe200078e0255ULL, 0x000000000748783bULL, 0x002e620000004200ULL,
0x0000001015157824ULL, 0x100fe200078e0254ULL, 0x000000521b527212ULL, 0x000fe200078e3cffULL,
0x0000001017177824ULL, 0x000fe200078e0254ULL, 0x0000000700817812ULL, 0x000fe200078ec0ffULL,
0x0000000114167824ULL, 0x000fe200078e0259ULL, 0x000000001524783bULL, 0x000ea20000004200ULL,
0x0000000819197824ULL, 0x000fe200078e0252ULL, 0x0000000881817812ULL, 0x000fe200078ef800ULL,
0x00000010163c7824ULL, 0x000fe200078e0257ULL, 0x00000000171c783bULL, 0x000ee20000004200ULL,
0x0000001019197824ULL, 0x000fe200078e0254ULL, 0x00000002ff8a7819ULL, 0x000fe20000011600ULL,
0x00000001525b7824ULL, 0x000fc400078e025bULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x0000000152557824ULL, 0x040fe400078e0255ULL, 0x0000000152587824ULL, 0x000fe200078e0259ULL,
0x00000018ff887819ULL, 0x002fe20000011448ULL, 0x00000100481a7824ULL, 0x040fe200078e00ffULL,
0x0000888048897816ULL, 0x040fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe20000011449ULL, 0x0000010049567824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x004fe20000011424ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x00000018ff487819ULL, 0x000fc40000011448ULL, 0x00008880249c7816ULL, 0x000fe400000000ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff787819ULL, 0x008fe2000001141cULL,
0x0000004800b37306ULL, 0x0003e20000200c00ULL, 0x000088801c7c7816ULL, 0x000fe200000000ffULL,
0x000001003e597824ULL, 0x010fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe4000001141aULL,
0x000000001918783bULL, 0x000ea20000004200ULL, 0x00000018ff077819ULL, 0x000fc4000001143cULL,
0x0000005600b57306ULL, 0x0007e20000200c00ULL, 0x000001004a487824ULL, 0x002fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001141dULL, 0x000088801d7b7816ULL, 0x000fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff6c7819ULL, 0x000fe2000001144aULL,
0x000001004b567824ULL, 0x008fe200078e00ffULL, 0x0000004800b07306ULL, 0x0003e20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc4000001144bULL, 0x0000888049b47816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x000088804ab17816ULL, 0x040fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000005600af7306ULL, 0x0007e20000200c00ULL, 0x0000010024487824ULL, 0x042fe200078e00ffULL,
0x000088804b967816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe2000001143dULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011448ULL, 0x000000105b487824ULL, 0x000fe200078e0254ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000010025567824ULL, 0x008fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ffa27819ULL, 0x004fe20000011418ULL,
0x0000002400987306ULL, 0x0003e20000200c00ULL, 0x0000888018ae7816ULL, 0x000fe200000000ffULL,
0x000001001aa77824ULL, 0x040fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011459ULL,
0x000001001ba67824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe2000001143eULL,
0x000100001aa47824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe2000001143fULL,
0x00000056009a7306ULL, 0x0005e20000200c00ULL, 0x0000010026247824ULL, 0x002fe200078e00ffULL,
0x000088803e5b7816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f597816ULL, 0x000fe200000000ffULL, 0x000100001ba37824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000004900b27306ULL, 0x000fe20000200c00ULL,
0x0000010027567824ULL, 0x004fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff9e7819ULL, 0x000fe40000011419ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000002400927306ULL, 0x0003e20000200c00ULL, 0x00008880199f7816ULL, 0x000fe400000000ffULL,
0x00000018ffa17819ULL, 0x000fc4000001141aULL, 0x00000018ffa07819ULL, 0x000fe4000001141bULL,
0x000088801aa87816ULL, 0x000fe200000000ffULL, 0x0000005600907306ULL, 0x0005e20000200c00ULL,
0x000001001c247824ULL, 0x042fe200078e00ffULL, 0x000088801ba57816ULL, 0x000fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x000000088a1a7810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011424ULL, 0x0000001055247824ULL, 0x000fe200078e0254ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000001001d547824ULL, 0x040fe200078e00ffULL,
0x000088803c567816ULL, 0x004fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x0000001c00797306ULL, 0x0003e20000200c00ULL, 0x00000018ff947819ULL, 0x000fc40000011425ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff857819ULL, 0x000fe20000011426ULL, 0x00000054007e7306ULL, 0x0005e20000200c00ULL,
0x000001001e1c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011427ULL,
0x0000888025997816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001d007a7306ULL, 0x0003e20000200c00ULL,
0x000001001f547824ULL, 0x004fe200078e00ffULL, 0x0000888026937816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00008880278f7816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000001c00767306ULL, 0x0005e20000200c00ULL, 0x000001003d1d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000005400757306ULL, 0x0003e20000200c00ULL,
0x000001003c1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa67819ULL, 0x000fe400000114a6ULL,
0x00000018ffa47819ULL, 0x000fc400000114a4ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004a009b7306ULL, 0x000fe20000200c00ULL, 0x000088803d547816ULL, 0x042fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x00000018ff697819ULL, 0x000fe4000001141eULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c005e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff687819ULL, 0x000fc4000001141fULL,
0x000088801e777816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x000088801f727816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe2000001141cULL, 0x0000004b00aa7306ULL, 0x0005e20000200c00ULL,
0x000001003f3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x00000010581c7824ULL, 0x000fe200078e0257ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000003d005c7306ULL, 0x0003e20000200c00ULL, 0x000000004848783bULL, 0x004ea20000004200ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff577819ULL, 0x000fc8000001141dULL,
0x0000003c00607306ULL, 0x0007e20000200c00ULL, 0x00000100193d7824ULL, 0x042fe400078e00ffULL,
0x0001000019197824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e00637306ULL, 0x000fe20000200c00ULL, 0x00000100183c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ffab7819ULL, 0x000fe20000011418ULL,
0x0000003f00647306ULL, 0x000fe20000200c00ULL, 0x00000004ff187819ULL, 0x000fc80000011600ULL,
0x0000000718187812ULL, 0x000fc600078e7881ULL, 0x0000003c00ad7306ULL, 0x0003e40000200c00ULL,
0x0000000881657824ULL, 0x000fe200078e0218ULL, 0x00000012ff18723eULL, 0x000fc600000000ffULL,
0x0000001065657824ULL, 0x000fe200078e00ffULL, 0x00005410181b7816ULL, 0x000fe20000000018ULL,
0x0000003d00ac7306ULL, 0x0007e20000200c00ULL, 0x0000010048187824ULL, 0x004fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011448ULL, 0x00000800743c7824ULL, 0x002fe200078e0265ULL,
0x00001f8a1b6f7589ULL, 0x0003e200000e0000ULL, 0x00008880488e7816ULL, 0x000fe200000000ffULL,
0x00000100498c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011418ULL,
0x0000001900a97306ULL, 0x0005e20000200c00ULL, 0x011000003c3c783bULL, 0x008ee20000000200ULL,
0x0000888049187816ULL, 0x000fc400000000ffULL, 0x00000018ff827819ULL, 0x000fe20000011449ULL,
0x00010000488a7824ULL, 0x002fe200078e00ffULL, 0x0000000200487811ULL, 0x000fe400078fe0ffULL,
0x000000b600b67306ULL, 0x000e620000200c00ULL, 0x000099106e197816ULL, 0x004fe400000000ffULL,
0x00001f1a1b6e7589ULL, 0x00052200000e0000ULL, 0x0000000748487812ULL, 0x000fe400078e7881ULL,
0x000000ff1900720cULL, 0x000fe20003f05270ULL, 0x0001000049197824ULL, 0x000fe200078e00ffULL,
0x000000b400b47306ULL, 0x000f620000200c00ULL, 0x0000000881487824ULL, 0x000fe200078e0248ULL,
0x00000018ff807819ULL, 0x000fc4000001144aULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001048497824ULL, 0x000fe200078e00ffULL, 0x000088804a1a7816ULL, 0x004fe200000000ffULL,
0x000001004b487824ULL, 0x000fe200078e00ffULL, 0x0000009100917306ULL, 0x000ea20000200c00ULL,
0x00000800741b7824ULL, 0x000fe200078e0249ULL, 0x00000018ff7f7819ULL, 0x000fe4000001144bULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x00000018ff8a7819ULL, 0x000fc4000001148aULL,
0x00000018008b7306ULL, 0x0003f00000200c00ULL, 0x000000b100b17306ULL, 0x000fe20000200c00ULL,
0x0000541089187816ULL, 0x002fe200000000b6ULL, 0x0000006f3c3c8232ULL, 0x008fc40000000000ULL,
0x0000006f3e3e8232ULL, 0x000fe40000000000ULL, 0x0000006e3d3d8232ULL, 0x090fe40000000000ULL,
0x0000001900897306ULL, 0x000be20000200c00ULL, 0x0000006e3f3f8232ULL, 0x000fce0000000000ULL,
0x0000009600967306ULL, 0x000fe20000200c00ULL, 0x00005410b4197816ULL, 0x020fe200000000b5ULL,
0x000000ffffb47224ULL, 0x000fe400078e001aULL, 0x000001004a1a7824ULL, 0x040fe400078e00ffULL,
0x000100004a4a7824ULL, 0x000fe400078e00ffULL, 0x000000183c2c723cULL, 0x000fe2000000182cULL,
0x0000006c006c7306ULL, 0x000e640000200c00ULL, 0x00000018ff4a7819ULL, 0x000fc8000001144aULL,
0x00005410b3187816ULL, 0x000fe40000000088ULL, 0x00005410b2197816ULL, 0x004fe20000000091ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff917819ULL, 0x000fe4000001141aULL,
0x000088804b1a7816ULL, 0x000fc600000000ffULL, 0x000000183c28723cULL, 0x000fe20000001828ULL,
0x000054109b6c7816ULL, 0x002fe2000000006cULL, 0x0000009f009f7306ULL, 0x000e620000200c00ULL,
0x00000018ff9b7819ULL, 0x000fe20000011448ULL, 0x000100004b487824ULL, 0x000fc600078e00ffULL,
0x00005410b1187816ULL, 0x000fe400000000b0ULL, 0x0000541096197816ULL, 0x000fe200000000afULL,
0x000000ffff967224ULL, 0x000fe200078e001aULL, 0x000000a200a27306ULL, 0x000fe20000200c00ULL,
0x00005410aa6d7816ULL, 0x004fc8000000006dULL, 0x000000183c20723cULL, 0x040fe20000001820ULL,
0x011000001b18783bULL, 0x000ea40000000200ULL, 0x0000009e009e7306ULL, 0x000eea0000200c00ULL,
0x0000006c3c30723cULL, 0x000fe60000001830ULL, 0x000000ab00ab7306ULL, 0x000f280000200c00ULL,
0x000054109f6d7816ULL, 0x002fc800000000acULL, 0x0000002500977306ULL, 0x000fe20000200c00ULL,
0x00005410a94b7816ULL, 0x008fe4000000009eULL, 0x00000018ff9e7819ULL, 0x000fca0000011448ULL,
0x0000002600867306ULL, 0x000ff00000200c00ULL, 0x0000002700877306ULL, 0x0003e20000200c00ULL,
0x0000006f18188232ULL, 0x004fce0000000000ULL, 0x000000a800a87306ULL, 0x000fe20000200c00ULL,
0x000000002424783bULL, 0x002e620000004200ULL, 0x0000006f1a1a8232ULL, 0x000fe40000000000ULL,
0x0000006e19198232ULL, 0x080fe40000000000ULL, 0x0000006e1b1b8232ULL, 0x000fe40000000000ULL,
0x000000a700a77306ULL, 0x000eb00000200c00ULL, 0x000000a500a57306ULL, 0x000ff00000200c00ULL,
0x000000a600a67306ULL, 0x000ef00000200c00ULL, 0x0000004a009f7306ULL, 0x0009f00000200c00ULL,
0x000000a100a17306ULL, 0x000fe20000200c00ULL, 0x00005410ab4a7816ULL, 0x010fc400000000a2ULL,
0x00000018ff6b7819ULL, 0x002fe40000011424ULL, 0x0000888024487816ULL, 0x000fe400000000ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011425ULL, 0x000000a000a07306ULL, 0x000fe20000200c00ULL,
0x0000004a3c44723cULL, 0x000fe20000001844ULL, 0x00000018ff667819ULL, 0x000fe40000011427ULL,
0x00000018ff677819ULL, 0x000fc80000011426ULL, 0x000000ae00ae7306ULL, 0x000e620000200c00ULL,
0x00005410a84a7816ULL, 0x004fe400000000a7ULL, 0x00005410a54b7816ULL, 0x008fca00000000a6ULL,
0x000000a400a47306ULL, 0x000ea40000200c00ULL, 0x0000004a3c40723cULL, 0x000fec0000001840ULL,
0x000000a300a37306ULL, 0x000ee20000200c00ULL, 0x00005410ae6c7816ULL, 0x002fce00000000adULL,
0x0000009c009c7306ULL, 0x000fe20000200c00ULL, 0x00005410a44a7816ULL, 0x004fe200000000a1ULL,
0x0000006c3c34723cULL, 0x000fec0000001834ULL, 0x0000009d009d7306ULL, 0x000e620000200c00ULL,
0x00005410a34b7816ULL, 0x008fe200000000a0ULL, 0x00000100246c7824ULL, 0x000fc400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000009900997306ULL, 0x000ea20000200c00ULL, 0x0000004a3c38723cULL, 0x000fee0000001838ULL,
0x0000009500957306ULL, 0x000ee20000200c00ULL, 0x000054109c3c7816ULL, 0x002fe2000000009dULL,
0x00000100253f7824ULL, 0x000fe200078e00ffULL, 0x00000004003e7811ULL, 0x000fc400078fe0ffULL,
0x00008880254a7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x000000073e3e7812ULL, 0x000fe200078e7881ULL, 0x0000009400947306ULL, 0x000e620000200c00ULL,
0x00005410993d7816ULL, 0x004fe4000000009aULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x00000008813e7824ULL, 0x000fe200078e023eULL, 0x00000018ff257819ULL, 0x000fc60000011425ULL,
0x0000009300937306ULL, 0x000ea20000200c00ULL, 0x0000003c182c723cULL, 0x000fe2000000182cULL,
0x000000103e4b7824ULL, 0x000fcc00078e00ffULL, 0x0000008f008f7306ULL, 0x000f220000200c00ULL,
0x00005410983c7816ULL, 0x008fe40000000095ULL, 0x00005410973d7816ULL, 0x002fca0000000094ULL,
0x0000008500857306ULL, 0x000fe40000200c00ULL, 0x0000003c1828723cULL, 0x000fec0000001828ULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x00005410933c7816ULL, 0x004fe40000000092ULL,
0x000054108f3d7816ULL, 0x010fc40000000090ULL, 0x0000888026907816ULL, 0x000fc600000000ffULL,
0x0000008e008e7306ULL, 0x000ff00000200c00ULL, 0x0000008d008d7306ULL, 0x000eb00000200c00ULL,
0x0000008c008c7306ULL, 0x000ef00000200c00ULL, 0x0000006c006d7306ULL, 0x0009f00000200c00ULL,
0x0000003f00957306ULL, 0x000be20000200c00ULL, 0x00000018ff6c7819ULL, 0x010fe20000011424ULL,
0x0000080074247824ULL, 0x000fcc00078e024bULL, 0x00000025008f7306ULL, 0x0003e20000200c00ULL,
0x0000003c183c723cULL, 0x020fe20000001820ULL, 0x011000002420783bULL, 0x00096c0000000200ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000541087257816ULL, 0x002fe20000000084ULL,
0x000000ffff847224ULL, 0x000fe200078e0090ULL, 0x0000541086247816ULL, 0x010fe20000000085ULL,
0x0000010026857824ULL, 0x040fe200078e00ffULL, 0x0000888027867816ULL, 0x000fe200000000ffULL,
0x0001000026267824ULL, 0x000fc400078e00ffULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x000000241830723cULL, 0x000fe20000001830ULL,
0x00000018ff267819ULL, 0x000fca0000011426ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000054108e247816ULL, 0x004fe4000000008dULL, 0x000054108b257816ULL, 0x008fca000000008cULL,
0x000000b400887306ULL, 0x000fe40000200c00ULL, 0x000000241834723cULL, 0x040fec0000001834ULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x000054108a247816ULL, 0x002fe20000000083ULL,
0x0000010027837824ULL, 0x000fe200078e00ffULL, 0x0000541089257816ULL, 0x000fe20000000082ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000006f20208232ULL, 0x0a0fe20000000000ULL,
0x000000ffff827224ULL, 0x000fe200078e0086ULL, 0x0000006f22228232ULL, 0x000fe20000000000ULL,
0x0000009600967306ULL, 0x000fe20000200c00ULL, 0x0000006e21218232ULL, 0x080fe20000000000ULL,
0x000000241844723cULL, 0x000fe20000001844ULL, 0x0000006e23238232ULL, 0x000fe20000000000ULL,
0x00000018ff837819ULL, 0x000fc80000011483ULL, 0x0000009b009b7306ULL, 0x000e620000200c00ULL,
0x0000541088247816ULL, 0x004fce0000000091ULL, 0x0000001e00707306ULL, 0x000ff00000200c00ULL,
0x0000001f00717306ULL, 0x0005e20000200c00ULL, 0x0000541096257816ULL, 0x002fce000000009bULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000000001c1c783bULL, 0x004ea20000004200ULL,
0x000000241840723cULL, 0x000fec0000001840ULL, 0x0000007f007f7306ULL, 0x000ff00000200c00ULL,
0x0000009e009e7306ULL, 0x000ee20000200c00ULL, 0x000054109f247816ULL, 0x002fc40000000080ULL,
0x0000000600807811ULL, 0x000fca00078fe0ffULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x000054109e257816ULL, 0x008fce000000007fULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x000000241818723cULL, 0x000fee0000001838ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x00000018ff627819ULL, 0x004fe4000001141cULL, 0x00000018ff617819ULL, 0x000fc4000001141dULL,
0x0000000780247812ULL, 0x000fe200078e7881ULL, 0x000001001c397824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011427ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe2000001141eULL, 0x0000000881277824ULL, 0x000fe200078e0224ULL,
0x000054107c247816ULL, 0x002fe4000000007dULL, 0x00000018ff5d7819ULL, 0x000fe2000001141fULL,
0x0000001027277824ULL, 0x000fe400078e00ffULL, 0x0000002500817306ULL, 0x0007e40000200c00ULL,
0x0000080074387824ULL, 0x000fe200078e0227ULL, 0x000088801d747816ULL, 0x000fca00000000ffULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x000054107b257816ULL, 0x008fce000000007eULL,
0x00000024202c723cULL, 0x000fe2000000182cULL, 0x0000007700777306ULL, 0x000eec0000200c00ULL,
0x000054107a257816ULL, 0x004fe40000000073ULL, 0x00000018ff737819ULL, 0x000fe20000011439ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x011000003838783bULL, 0x000f220000000200ULL,
0x0000541079247816ULL, 0x002fcc0000000078ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x000000242028723cULL, 0x000fee0000001828ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000541077247816ULL, 0x008fe40000000076ULL, 0x0000541072257816ULL, 0x004fca0000000075ULL,
0x0000008500857306ULL, 0x000ea20000200c00ULL, 0x0000541048947816ULL, 0x002fe2000000006dULL,
0x00000024203c723cULL, 0x000fec000000183cULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000001001d257824ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fc600078e0074ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x0000541084847816ULL, 0x004fe20000000085ULL, 0x0000006f38388232ULL, 0x090fe40000000000ULL,
0x0000006f3a3a8232ULL, 0x000fe40000000000ULL, 0x0000006e39398232ULL, 0x080fe40000000000ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541070707816ULL, 0x002fe20000000069ULL,
0x0000006e3b3b8232ULL, 0x000fcc0000000000ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541071717816ULL, 0x008fce0000000068ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000000702030723cULL, 0x000fee0000001830ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000054108f6d7816ULL, 0x002fce000000006aULL, 0x0000004a004a7306ULL, 0x000e700000200c00ULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x0000541081817816ULL, 0x004fce0000000066ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000054104a957816ULL, 0x002fe20000000095ULL,
0x000001001e4a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x000054106c6c7816ULL, 0x008fe2000000006bULL,
0x000000942034723cULL, 0x040fec0000001834ULL, 0x0000002600807306ULL, 0x0004e40000200c00ULL,
0x0000006c2044723cULL, 0x000fec0000001844ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541082857816ULL, 0x002fc40000000083ULL, 0x000088801c267816ULL, 0x044fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fc800078e00ffULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x0000541080807816ULL, 0x008fe20000000067ULL, 0x000000842040723cULL, 0x000fe20000001840ULL,
0x00000018ff487819ULL, 0x000fe2000001141cULL, 0x000100001d1c7824ULL, 0x000fc800078e00ffULL,
0x0000000700077306ULL, 0x000ea20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x000000802018723cULL, 0x000fec0000001818ULL, 0x0000001700177306ULL, 0x000ee20000200c00ULL,
0x000088801f207816ULL, 0x040fe200000000ffULL, 0x000001001f227824ULL, 0x040fe200078e00ffULL,
0x0000541054577816ULL, 0x002fe20000000057ULL, 0x000100001f1f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff547224ULL, 0x000fe400078e0020ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000054105e207816ULL, 0x004fe40000000007ULL, 0x00000018ff077819ULL, 0x000fca0000011422ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000054105c217816ULL, 0x008fe40000000017ULL,
0x00000018ff177819ULL, 0x000fca000001141fULL, 0x0000005900597306ULL, 0x000ea20000200c00ULL,
0x000000203828723cULL, 0x000fee0000001828ULL, 0x0000000800087306ULL, 0x000fe20000200c00ULL,
0x000054105b207816ULL, 0x002fce000000005aULL, 0x00000048001d7306ULL, 0x0003e20000200c00ULL,
0x0000541059217816ULL, 0x004fce0000000060ULL, 0x0000001500157306ULL, 0x000ea20000200c00ULL,
0x000088801e487816ULL, 0x042fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x000000203820723cULL, 0x000fe8000000183cULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000006200627306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00005410641f7816ULL, 0x004fce0000000015ULL, 0x0000001c001c7306ULL, 0x000ea20000200c00ULL,
0x000054101d607816ULL, 0x002fce0000000062ULL, 0x0000001e003c7306ULL, 0x0003f00000200c00ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00005410631e7816ULL, 0x002fe40000000008ULL,
0x000054101c617816ULL, 0x004fca0000000061ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x0000001e3830723cULL, 0x040fee0000001830ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x000000603844723cULL, 0x000fee0000001844ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541056567816ULL, 0x002fce0000000055ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00000056382c723cULL, 0x000fee000000182cULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x00005410261e7816ULL, 0x004fce0000000073ULL, 0x0000004800487306ULL, 0x000ff00000200c00ULL,
0x0000004a00677306ULL, 0x000ea20000200c00ULL, 0x00005410241f7816ULL, 0x002fce0000000025ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000001e3834723cULL, 0x000fee0000001834ULL,
0x0000000700077306ULL, 0x000e620000200c00ULL, 0x00005410481c7816ULL, 0x004fce0000000067ULL,
0x0000005f005f7306ULL, 0x000eb00000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00005410541d7816ULL, 0x002fe40000000007ULL, 0x0001b6104c077811ULL, 0x000fca00078e20ffULL,
0x0000001700087306ULL, 0x000e620000200c00ULL, 0x000054103c3c7816ULL, 0x004fe2000000005fULL,
0x0000001c3840723cULL, 0x000fe20000001840ULL, 0x00005410083d7816ULL, 0x002fe4000000005dULL,
0x0001b6684c087811ULL, 0x000fca00078e18ffULL, 0x0000003c3838723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000008ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000453157824ULL, 0x000fe200078e024cULL, 0x000000ff0bff7812ULL, 0x000fe2000780c0ffULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff0aff7812ULL, 0x000fe4000784c0ffULL,
0x0000008015157811ULL, 0x000fe400078e30ffULL, 0x00000001ff0a7807ULL, 0x000fe40000000000ULL,
0x000000501500720cULL, 0x000fc40003f06070ULL, 0x000000010900780cULL, 0x040fe40003f25270ULL,
0x00000001ff157807ULL, 0x000fe40001000000ULL, 0x0000000b0a0b7207ULL, 0x000fe40004800000ULL,
0x0000000109097812ULL, 0x000fe400078e0cffULL, 0x00007610150a7816ULL, 0x000fc6000000000aULL,
0x0000309000000947ULL, 0x000fea0003800000ULL, 0x01b66c000d0a7984ULL, 0x004ea20000000800ULL,
0x8000000015077824ULL, 0x000fca00078e00ffULL, 0x800000000aff7812ULL, 0x004fe20007804807ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01b66c000d0a7984ULL, 0x000ea40000000800ULL, 0x800000000aff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x80000000150a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700097305ULL, 0x0004e4000021f000ULL, 0x3fa0000007077823ULL, 0x004fe200000100ffULL,
0x000000090000735dULL, 0x008fe40003800000ULL, 0x0000040008097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003ff487819ULL, 0x000fe40000011600ULL,
0x00000300530a7a10ULL, 0x000fe40007ffe0ffULL, 0x00000004485e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001031d7824ULL, 0x000fe200078e0248ULL, 0x000000010a077810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011651ULL, 0x000000081d677824ULL, 0x000fe200078e00ffULL,
0x0000004e0700720cULL, 0x000fe20003f06070ULL, 0x000000080e077824ULL, 0x000fe200078e00ffULL,
0x000000001d087212ULL, 0x082fe200078e3cffULL, 0x0000000103557824ULL, 0x000fe200078e025eULL,
0x00000008481e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100d157824ULL, 0x000fe200078e00ffULL,
0xfffffff867677812ULL, 0x000fe200078ee208ULL, 0x00000008551a7824ULL, 0x000fe200078e00ffULL,
0x0000000807087812ULL, 0x000fe200078ec0ffULL, 0x00000001031b7824ULL, 0x000fe200078e021eULL,
0x0000000055097212ULL, 0x000fc400078e3cffULL, 0x00000010485c7810ULL, 0x040fe20007ffe0ffULL,
0x00000000080573c2ULL, 0x0002a200000e0000ULL, 0x00000014484a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000808077812ULL, 0x000fe200078e3cffULL, 0x0000000103257824ULL, 0x040fe200078e025cULL,
0xfffffff81a577812ULL, 0x000fe200078ee209ULL, 0x00000001033f7824ULL, 0x000fe200078e024aULL,
0x0001b64815187810ULL, 0x000fe20007ffe0ffULL, 0x000000081b087824ULL, 0x042fe200078e00ffULL,
0x000000001b097212ULL, 0x000fe200078e3cffULL, 0x00000008255d7824ULL, 0x000fe200078e00ffULL,
0x00000000180473c2ULL, 0x0002a200000e0000ULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0xfffffff808597812ULL, 0x000fc400078ee209ULL, 0x0000000025087212ULL, 0x080fe400078e3cffULL,
0x000000003f097212ULL, 0x0c0fe200078e3cffULL, 0x000000083f187824ULL, 0x002fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee208ULL, 0x000020000e087824ULL, 0x000fe200078e00ffULL,
0x0000000c484c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8185f7812ULL, 0x000fe200078ee209ULL,
0x000000040a097824ULL, 0x000fe200078e020dULL, 0x0000001848567810ULL, 0x000fe20007ffe0ffULL,
0x00000001033d7824ULL, 0x000fe200078e024cULL, 0x00002000080a7812ULL, 0x000fe200078ec0ffULL,
0x0000004009087824ULL, 0x000fe200078e00ffULL, 0x0000001c485a7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d1a7824ULL, 0x040fe200078e00ffULL, 0x000000003d177212ULL, 0x000fe200078e3cffULL,
0x00000001031f7824ULL, 0x040fe200078e0256ULL, 0x0000000850097217ULL, 0x000fe20007800000ULL,
0x0000000103197824ULL, 0x000fe200078e025aULL, 0xfffffff81a5b7812ULL, 0x000fe200078ee217ULL,
0x000000081f617824ULL, 0x040fe200078e00ffULL, 0x000000001f1a7212ULL, 0x080fe200078e3cffULL,
0x000040000d187824ULL, 0x000fe200078e020aULL, 0x00000000190a7212ULL, 0x040fe200078e3cffULL,
0x0000000819637824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee21aULL,
0x0000000109177824ULL, 0x100fe200078e0a08ULL, 0x00013000181a7810ULL, 0x000fe20007ffe0ffULL,
0x000062004d087a24ULL, 0x000fe200078e0208ULL, 0xfffffff863637812ULL, 0x000fe200078ee20aULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000004017247807ULL, 0x000fe20000000000ULL,
0x0000000155187824ULL, 0x100fe200078e0208ULL, 0x0000000504047290ULL, 0x004fe2000fffe03fULL,
0x00000080ff557424ULL, 0x000fe200078e00ffULL, 0x000000700a697812ULL, 0x000fe200078ec0ffULL,
0x000000011d097824ULL, 0x100fe200078e0208ULL, 0x0000002403267217ULL, 0x000fe20007800000ULL,
0x0000000119547824ULL, 0x000fc400078e0208ULL, 0x000000011b1b7824ULL, 0x100fe400078e0208ULL,
0x000000013d1c7824ULL, 0x100fe400078e0208ULL, 0x0000000125257824ULL, 0x100fe400078e0208ULL,
0x000000013f3c7824ULL, 0x100fe400078e0208ULL, 0x000000011f3e7824ULL, 0x000fe400078e0208ULL,
0x00005e0018187625ULL, 0x000fc800078e0055ULL, 0x00005e0009087625ULL, 0x000fe200078e0055ULL,
0x0000006918187210ULL, 0x000fc60007f3e0ffULL, 0x00000010671f7824ULL, 0x100fe200078e021aULL,
0x0000006908087210ULL, 0x000fe20007f1e0ffULL, 0x0000001057577824ULL, 0x100fe400078e021aULL,
0x0000001059597824ULL, 0x100fe400078e021aULL, 0x000000105b5b7824ULL, 0x100fe400078e021aULL,
0x000000105d5d7824ULL, 0x100fe400078e021aULL, 0x000000105f5f7824ULL, 0x000fc400078e021aULL,
0x0000001061617824ULL, 0x100fe400078e021aULL, 0x0000001063637824ULL, 0x000fe400078e021aULL,
0x00005e001c1c7625ULL, 0x000fc800078e0055ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0055ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000691c1c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000691a1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000126177824ULL, 0x000fe400078e0a03ULL, 0x00005e003c3c7625ULL, 0x000fc600078e0055ULL,
0x000000174800720cULL, 0x000fe20003f86070ULL, 0x00005e0025247625ULL, 0x000fe200078e0055ULL,
0x000000175e00720cULL, 0x080fe40003fa6070ULL, 0x000000171e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x000000693c3c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000006924247210ULL, 0x000fe20007f1e0ffULL,
0x00005e003e3e7625ULL, 0x000fe200078e0055ULL, 0x000000174c00720cULL, 0x000fc60003f46070ULL,
0x00005e0054547625ULL, 0x000fe200078e0055ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081f7faeULL, 0x0003e2000e101c46ULL, 0x000000175600720cULL, 0x000fe40003f86070ULL,
0x000000ffff3d7224ULL, 0x000fe200008e063dULL, 0x0000006954547210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x000000693e3e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000018577faeULL, 0x0005e2000e901c46ULL, 0x000000175a00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff557224ULL, 0x000fe200008e0655ULL, 0x000000175c00720cULL, 0x080fe20003f26070ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x000000174a00720cULL, 0x000fe20003f06070ULL,
0x000000001a597faeULL, 0x0005e8000d901c46ULL, 0x000000001c5b7faeULL, 0x0005ec000d101c46ULL,
0x00000000245d7faeULL, 0x0005e8000c901c46ULL, 0x000000003c5f7faeULL, 0x0005e8000c101c46ULL,
0x000000003e617faeULL, 0x0005e8000e101c46ULL, 0x0000000054637faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040007097984ULL, 0x0002e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b62c0015187984ULL, 0x004ea20000000800ULL,
0x0000ffff0b0b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0c087812ULL, 0x000fe400078ec0ffULL,
0x000088800b197816ULL, 0x000fe400000000ffULL, 0x0000888008177816ULL, 0x000fc600000000ffULL,
0x8000000019087824ULL, 0x000fe400078e00ffULL, 0x80000000170b7824ULL, 0x000fc600078e00ffULL,
0x8000000009ff7812ULL, 0x008fe40007804808ULL, 0x8000000018ff7812ULL, 0x004fe2000782480bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0001b6280d0d7811ULL, 0x000fe200078e20ffULL, 0x8000000017097824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x00000008000b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000008087823ULL, 0x004fe200000100ffULL, 0x0000000b0000735dULL, 0x008fe20003800000ULL,
0x000004000d187984ULL, 0x000ea40000000800ULL, 0x8000000018ff7812ULL, 0x004fc40007824809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000004051087824ULL, 0x000fe200078e00ffULL, 0x000000700a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff647424ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe40000011600ULL,
0xffffff8008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fe400078ec0ffULL,
0x000001000b087810ULL, 0x000fca0007ffe008ULL, 0x0000000109087824ULL, 0x000fca00078e0208ULL,
0x01b0000008187984ULL, 0x000ea80000000800ULL, 0x01b2000008097984ULL, 0x0007220000000800ULL,
0x000000051800720bULL, 0x004fda0003f3d000ULL, 0x00000000000b7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0b0d7812ULL, 0x000fda000782c0ffULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001805177209ULL, 0x058fe40007810000ULL, 0x000000051800720bULL, 0x000fe40003f54000ULL,
0x00000002ff1c7819ULL, 0x000fe20000011600ULL, 0x8000001705087221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x0000000251087811ULL, 0x000fc600078ff8ffULL,
0x0000000b00157308ULL, 0x0004e20000000800ULL, 0x000000510800720cULL, 0x000fe40003f25270ULL,
0x0000000000087806ULL, 0x000fc800010e0100ULL, 0x0000ffff081a7812ULL, 0x000fce00078e3cffULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000700a0a7812ULL, 0x004fe400078ec0ffULL,
0x00000001ff087819ULL, 0x000fc60000011600ULL, 0x00000080510b7824ULL, 0x000fe200078e020aULL,
0x0000000c080a7812ULL, 0x000fe400078ec0ffULL, 0x0000001805087209ULL, 0x000fc60007810000ULL,
0x000000010a0b7824ULL, 0x000fca00078e020bULL, 0x01b400080b007388ULL, 0x0005e40000000800ULL,
0x0000001a0dff7212ULL, 0x004fe2000782c0ffULL, 0x00001f1c15087589ULL, 0x008ea200000e0000ULL,
0x000000081c0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001506067220ULL, 0x000fe20000410000ULL,
0x0000001805057209ULL, 0x000fe40007810000ULL, 0x00000001ff647807ULL, 0x000fe40000800000ULL,
0x00001f0a150a7589ULL, 0x000eea00000e0000ULL, 0x80000017180b1221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0b0b1820ULL, 0x000fc80000410000ULL, 0x0000000b00121308ULL, 0x000f220000000800ULL,
0x000000082c2c7220ULL, 0x084fe40000410000ULL, 0x000000082d2d7220ULL, 0x080fe40000410000ULL,
0x0000000828287220ULL, 0x080fe40000410000ULL, 0x0000000829297220ULL, 0x080fe40000410000ULL,
0x0000000820207220ULL, 0x080fe40000410000ULL, 0x0000000821217220ULL, 0x000fc40000410000ULL,
0x0000000830307220ULL, 0x080fe40000410000ULL, 0x0000000831317220ULL, 0x080fe40000410000ULL,
0x0000000834347220ULL, 0x080fe40000410000ULL, 0x0000000835357220ULL, 0x080fe40000410000ULL,
0x0000000844447220ULL, 0x080fe40000410000ULL, 0x0000000845457220ULL, 0x000fc40000410000ULL,
0x0000000840407220ULL, 0x080fe40000410000ULL, 0x0000000841417220ULL, 0x080fe40000410000ULL,
0x0000000838387220ULL, 0x080fe40000410000ULL, 0x0000000839397220ULL, 0x000fe40000410000ULL,
0x0000000a2e2e7220ULL, 0x088fe40000410000ULL, 0x0000000a2f2f7220ULL, 0x000fc40000410000ULL,
0x0000000a2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000a2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000a22227220ULL, 0x080fe40000410000ULL, 0x0000000a23237220ULL, 0x080fe40000410000ULL,
0x0000000a32327220ULL, 0x080fe40000410000ULL, 0x0000000a33337220ULL, 0x000fc40000410000ULL,
0x0000000a36367220ULL, 0x080fe40000410000ULL, 0x0000000a37377220ULL, 0x080fe40000410000ULL,
0x0000000a46467220ULL, 0x080fe40000410000ULL, 0x0000000a47477220ULL, 0x080fe40000410000ULL,
0x0000000a42427220ULL, 0x080fe40000410000ULL, 0x0000000a43437220ULL, 0x000fc40000410000ULL,
0x0000000a3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000a3b3b7220ULL, 0x000fe40000410000ULL,
0x0000000912091220ULL, 0x010fc80000410000ULL, 0x0000000609067221ULL, 0x018fe20000010000ULL,
0x0000013000000947ULL, 0x000fea0003800000ULL, 0x000000080e087824ULL, 0x000fe400078e00ffULL,
0x0000000851097824ULL, 0x000fc600078e00ffULL, 0x0000000808087812ULL, 0x000fe400078e0cffULL,
0xfffffff009097812ULL, 0x000fca00078ec0ffULL, 0x0000000108087824ULL, 0x000fe400078e0209ULL,
0x8000000019097824ULL, 0x000fc800078e00ffULL, 0x01b64c0008087984ULL, 0x000ea40000000800ULL,
0x8000000008ff7812ULL, 0x004fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x80000000190a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0004e4000021f000ULL,
0x3fa0000008087823ULL, 0x004fe200000100ffULL, 0x000000090000735dULL, 0x008fe40003800000ULL,
0x0000040007097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fc4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000010161c7824ULL, 0x100fe400078e0211ULL, 0x0000001058187824ULL, 0x000fc800078e0211ULL,
0x000000001c1c783bULL, 0x000ea80000004200ULL, 0x000000001818783bULL, 0x000ee20000004200ULL,
0x000001001c157824ULL, 0x044fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe2000001141cULL,
0x000001001d167824ULL, 0x000fe200078e00ffULL, 0x000088801c597816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000001001e177824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe2000001141dULL,
0x0000002600267306ULL, 0x000fe20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x000088801d257816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff0d7819ULL, 0x000fe2000001141eULL,
0x0000001500487306ULL, 0x0005e20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fe4000001141fULL,
0x000088801e587816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001c005d7306ULL, 0x0009620000200c00ULL, 0x0000000713157812ULL, 0x004fe400078ef800ULL,
0x000088801f137816ULL, 0x000fe400000000ffULL, 0x00000018ff627819ULL, 0x000fe2000001141eULL,
0x00000008153c7824ULL, 0x040fe200078e0214ULL, 0x00000018ff087819ULL, 0x008fe20000011418ULL,
0x00000016004a7306ULL, 0x0005e20000200c00ULL, 0x00000008151c7824ULL, 0x010fe200078e0252ULL,
0x0000888018637816ULL, 0x000fe200000000ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0211ULL,
0x00000018ff077819ULL, 0x002fe2000001141aULL, 0x000000101c1c7824ULL, 0x000fe200078e0211ULL,
0x00000018ff097819ULL, 0x000fc4000001141bULL, 0x0000001d005b7306ULL, 0x0003e20000200c00ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x000001001f167824ULL, 0x004fe200078e00ffULL,
0x000054105d267816ULL, 0x020fe20000000026ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe40000011419ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x00000017005f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff607819ULL, 0x000fe4000001141fULL,
0x000000001c1c783bULL, 0x002e620000004200ULL, 0x0000888019617816ULL, 0x000fc800000000ffULL,
0x00000016005a7306ULL, 0x0009e20000200c00ULL, 0x0000010019177824ULL, 0x004fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x0000010018167824ULL, 0x010fca00078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000017005c7306ULL, 0x0005f00000200c00ULL, 0x00000016005e7306ULL, 0x0009e20000200c00ULL,
0x00000018ff4c7819ULL, 0x008fe2000001143dULL, 0x000001003d177824ULL, 0x044fe200078e00ffULL,
0x000088803da87816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc4000001143cULL, 0x000088803cad7816ULL, 0x040fe200000000ffULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000001003c167824ULL, 0x050fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x002fe4000001141cULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000003d00a77306ULL, 0x0003e20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x000088801ca07816ULL, 0x000fe400000000ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ffa17819ULL, 0x000fe2000001143eULL, 0x0000001600aa7306ULL, 0x0005e20000200c00ULL,
0x00000080153d7811ULL, 0x002fe400078e18ffULL, 0x00000018ff837819ULL, 0x000fe4000001143fULL,
0x000088803ea67816ULL, 0x000fc400000000ffULL, 0x000088803f7c7816ULL, 0x000fe200000000ffULL,
0x0000003c00a97306ULL, 0x0003e20000200c00ULL, 0x000001003e167824ULL, 0x044fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001141dULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088801d827816ULL, 0x000fe400000000ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000001700ab7306ULL, 0x0005e20000200c00ULL, 0x00000001143c7824ULL, 0x002fe200078e023dULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x000088801e9a7816ULL, 0x000fe200000000ffULL,
0x000000103c3c7824ULL, 0x000fe200078e0211ULL, 0x000088801f887816ULL, 0x000fe400000000ffULL,
0x0000001600a57306ULL, 0x0003e20000200c00ULL, 0x000001003f177824ULL, 0x044fe200078e00ffULL,
0x000000003c54783bULL, 0x000ea20000004200ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001141eULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000001001c167824ULL, 0x042fe200078e00ffULL,
0x0000003e00a47306ULL, 0x000fe20000200c00ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001141fULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000003f00a27306ULL, 0x000ff00000200c00ULL,
0x0000001c009e7306ULL, 0x0003f00000200c00ULL, 0x0000001700a37306ULL, 0x0007e20000200c00ULL,
0x00000001521c7824ULL, 0x002fc800078e023dULL, 0x000000101c1c7824ULL, 0x000fe200078e0211ULL,
0x00000018ff8d7819ULL, 0x004fe20000011454ULL, 0x00000100546e7824ULL, 0x000fc600078e00ffULL,
0x000000001c3c783bULL, 0x000e620000004200ULL, 0x0000888054937816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011455ULL,
0x000001001d177824ULL, 0x008fe200078e00ffULL, 0x0000888055917816ULL, 0x040fe200000000ffULL,
0x00000100556f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x0000005400927306ULL, 0x0005e20000200c00ULL,
0x00000018ff6e7819ULL, 0x000fc4000001146eULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff817819ULL, 0x000fe20000011456ULL,
0x0000001d009c7306ULL, 0x0007e20000200c00ULL, 0x0000010056547824ULL, 0x044fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011457ULL, 0x00008880568c7816ULL, 0x040fe200000000ffULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000005500907306ULL, 0x0003e20000200c00ULL, 0x00000100151d7811ULL, 0x008fe400078e18ffULL,
0x0000888057877816ULL, 0x000fe400000000ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000000114147824ULL, 0x000fe200078e021dULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x00000016009f7306ULL, 0x0005e20000200c00ULL, 0x0000000152527824ULL, 0x000fe400078e021dULL,
0x0000001014147824ULL, 0x000fc400078e0211ULL, 0x000001003d557824ULL, 0x002fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001143cULL, 0x000100003f717824ULL, 0x000fe200078e00ffULL,
0x00000017009d7306ULL, 0x0003e20000200c00ULL, 0x000001001e167824ULL, 0x004fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011455ULL, 0x000100003c557824ULL, 0x040fe200078e00ffULL,
0x000088803c807816ULL, 0x000fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x00000010521c7824ULL, 0x000fe200078e0211ULL,
0x0000005400897306ULL, 0x0005e20000200c00ULL, 0x000001001f177824ULL, 0x042fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011455ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc4000001143dULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000006e00967306ULL, 0x0003e20000200c00ULL, 0x000001003c547824ULL, 0x004fe200078e00ffULL,
0x000088803d7b7816ULL, 0x000fe200000000ffULL, 0x00000400513c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001143eULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0xfffff8003c3c7812ULL, 0x000fe200078ec0ffULL,
0x00000100576e7824ULL, 0x042fe200078e00ffULL, 0x0000001600997306ULL, 0x000fe20000200c00ULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x000120003c3c7810ULL, 0x000fe20007ffe065ULL,
0x000001003e657824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001146eULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000001700977306ULL, 0x0003e20000200c00ULL,
0x00000018ff767819ULL, 0x000fe40000011465ULL, 0x00000002ff657819ULL, 0x000fe40000011600ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803e797816ULL, 0x040fe200000000ffULL,
0x0000005600867306ULL, 0x000fe20000200c00ULL, 0x000000001414783bULL, 0x002e620000004200ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001143fULL,
0x000088803f747816ULL, 0x000fe400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005700847306ULL, 0x000fe20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff717819ULL, 0x000fc60000011471ULL,
0x00000054007d7306ULL, 0x0005f00000200c00ULL, 0x0000006e008a7306ULL, 0x0007e20000200c00ULL,
0x000000003c54783bULL, 0x0045ee0000000200ULL, 0x0000006f00947306ULL, 0x0009e20000200c00ULL,
0x00000012ff6e723eULL, 0x008fe200000000ffULL, 0x000001003f3c7824ULL, 0x004fc600078e00ffULL,
0x000054106e6e7816ULL, 0x000fe4000000006eULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003d00787306ULL, 0x0005e20000200c00ULL, 0x00000008656f7810ULL, 0x010fe40007ffe0ffULL,
0x00001f656e657589ULL, 0x000ee200000e0000ULL, 0x00000018ff6b7819ULL, 0x002fe40000011414ULL,
0x00000018ff6a7819ULL, 0x000fe40000011415ULL, 0x000000ad00ad7306ULL, 0x000fe20000200c00ULL,
0x00009910643d7816ULL, 0x004fc400000000ffULL, 0x00001f6f6e647589ULL, 0x0002a200000e0000ULL,
0x00000018ff697819ULL, 0x000fe40000011416ULL, 0x000000ff3d00720cULL, 0x000fe40003f05270ULL,
0x000000a800a87306ULL, 0x000f220000200c00ULL, 0x00008880143d7816ULL, 0x040fe400000000ffULL,
0x00000018ff687819ULL, 0x000fe20000011417ULL, 0x00000100146e7824ULL, 0x002fe400078e00ffULL,
0x000000ffff6f7224ULL, 0x000fc400078e003dULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000006554548232ULL, 0x088fe40000000000ULL, 0x0000006556568232ULL, 0x000fe20000000000ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000003c00777306ULL, 0x0007e20000200c00ULL,
0x00005410a83d7816ULL, 0x010fe200000000abULL, 0x0000006455558232ULL, 0x004fc40000000000ULL,
0x0000006457578232ULL, 0x000fc80000000000ULL, 0x000000a600a67306ULL, 0x000ea20000200c00ULL,
0x00005410ad3c7816ULL, 0x008fce00000000aaULL, 0x0000007c007c7306ULL, 0x000ee20000200c00ULL,
0x0000003c542c723cULL, 0x000fee000000182cULL, 0x000000a100a17306ULL, 0x000fe20000200c00ULL,
0x00005410a93c7816ULL, 0x002fe40000000072ULL, 0x00005410a73d7816ULL, 0x000fc4000000004cULL,
0x00000001ff4c7819ULL, 0x000fc60000011651ULL, 0x0000008300837306ULL, 0x000e640000200c00ULL,
0x0000003c5428723cULL, 0x000fe20000001828ULL, 0x000008004ca77824ULL, 0x000fca00078e0249ULL,
0x0000003e00707306ULL, 0x0009e20000200c00ULL, 0x00005410a63c7816ULL, 0x004fe400000000a5ULL,
0x000054107c3d7816ULL, 0x008fe200000000a3ULL, 0x0001000015a37824ULL, 0x000fc800078e00ffULL,
0x000000a000a07306ULL, 0x000ea20000200c00ULL, 0x00008880153e7816ULL, 0x010fca00000000ffULL,
0x000000ffffa87224ULL, 0x000fe400078e003eULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x00000100153e7824ULL, 0x000fe200078e00ffULL, 0x00005410a2157816ULL, 0x002fe40000000083ULL,
0x00000018ff837819ULL, 0x000fe400000114a3ULL, 0x00000018ffa97819ULL, 0x000fe4000001143eULL,
0x0000003c543c723cULL, 0x000fe20000001820ULL, 0x00000014007c7306ULL, 0x0003e20000200c00ULL,
0x01200000a720783bULL, 0x000f2e0000000200ULL, 0x0000009b009b7306ULL, 0x000f620000200c00ULL,
0x00005410a4147816ULL, 0x002fc400000000a1ULL, 0x0000888016a17816ULL, 0x000fca00000000ffULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000000145430723cULL, 0x000fee0000001830ULL,
0x0000009a009a7306ULL, 0x000e620000200c00ULL, 0x00005410a0147816ULL, 0x004fe4000000009fULL,
0x0000541082157816ULL, 0x008fe2000000009dULL, 0x00000100169d7824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe400078e00ffULL, 0x0000008800887306ULL, 0x000ea40000200c00ULL,
0x000000145434723cULL, 0x000fe20000001834ULL, 0x00000018ff167819ULL, 0x000fca0000011416ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x000054109e147816ULL, 0x020fe2000000009bULL,
0x0000006520208232ULL, 0x090fe20000000000ULL, 0x000054109c157816ULL, 0x002fe20000000085ULL,
0x0000006522228232ULL, 0x000fe20000000000ULL, 0x00008880179b7816ULL, 0x000fe200000000ffULL,
0x0000006421218232ULL, 0x080fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe2000001149dULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x0000006423238232ULL, 0x000fe20000000000ULL,
0x000000145444723cULL, 0x000fec0000001844ULL, 0x0000001e00987306ULL, 0x000e620000200c00ULL,
0x000054109a147816ULL, 0x000fc40000000099ULL, 0x0000541088157816ULL, 0x004fe20000000097ULL,
0x0000010017977824ULL, 0x040fe400078e00ffULL, 0x0001000017177824ULL, 0x000fe400078e00ffULL,
0x0000001f00957306ULL, 0x0004e20000200c00ULL, 0x000000ffff887224ULL, 0x000fe200078e009bULL,
0x000000145440723cULL, 0x000fe20000001840ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff977819ULL, 0x000fc60000011497ULL, 0x0000009300937306ULL, 0x000f220000200c00ULL,
0x000000001c1c783bULL, 0x004ea20000004200ULL, 0x0000541098147816ULL, 0x002fcc000000008fULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x0000541095157816ULL, 0x008fce000000008eULL,
0x0000008d008d7306ULL, 0x000ee20000200c00ULL, 0x000000145438723cULL, 0x000fee0000001838ULL,
0x0000008b008b7306ULL, 0x000f620000200c00ULL, 0x0000541093147816ULL, 0x010fe20000000096ULL,
0x000008004c557824ULL, 0x000fe200078e024bULL, 0x0000541091157816ULL, 0x002fca0000000094ULL,
0x0000008c008c7306ULL, 0x000e640000200c00ULL, 0x00000014202c723cULL, 0x000fec000000182cULL,
0x0000008700877306ULL, 0x000f220000200c00ULL, 0x0000541092147816ULL, 0x008fe4000000008dULL,
0x0000541090157816ULL, 0x020fc4000000008bULL, 0x000088801c547816ULL, 0x004fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe2000001141cULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00000018ff667819ULL, 0x000fe2000001141dULL, 0x000000142028723cULL, 0x000fe20000001828ULL,
0x00000018ff527819ULL, 0x000fe4000001141eULL, 0x00000018ff117819ULL, 0x000fc6000001141fULL,
0x0000007f007f7306ULL, 0x000ee20000200c00ULL, 0x000054108c147816ULL, 0x002fe40000000089ULL,
0x0000541087157816ULL, 0x010fe4000000008aULL, 0x000088801d877816ULL, 0x000fc600000000ffULL,
0x0000008000807306ULL, 0x000e640000200c00ULL, 0x00000014203c723cULL, 0x000fec000000183cULL,
0x0000007b007b7306ULL, 0x000ff00000200c00ULL, 0x0000007e007e7306ULL, 0x000f300000200c00ULL,
0x0000001600567306ULL, 0x000bf00000200c00ULL, 0x00000017008f7306ULL, 0x0003e20000200c00ULL,
0x000001001c167824ULL, 0x020fc400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011416ULL, 0x00000054004b7306ULL, 0x0005e20000200c00ULL,
0x012000005514783bULL, 0x0026620000000200ULL, 0x00000018ff1c7819ULL, 0x000fcc000001141cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541086547816ULL, 0x004fe20000000081ULL,
0x000001001d817824ULL, 0x000fe200078e00ffULL, 0x0000541084557816ULL, 0x008fe2000000007fULL,
0x000000ffff7f7224ULL, 0x000fc800078e0087ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000542030723cULL, 0x000fec0000001830ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000541080547816ULL, 0x000fe4000000007dULL, 0x000054107b557816ULL, 0x010fc4000000007eULL,
0x00000018ff7e7819ULL, 0x000fc60000011481ULL, 0x0000007900797306ULL, 0x000fe40000200c00ULL,
0x000000542034723cULL, 0x000fec0000001834ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x000054107a547816ULL, 0x004fe20000000075ULL, 0x0000006514148232ULL, 0x082fe20000000000ULL,
0x0000541078557816ULL, 0x000fe20000000073ULL, 0x0000006516168232ULL, 0x000fc40000000000ULL,
0x0000006415158232ULL, 0x080fe40000000000ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000006417178232ULL, 0x000fe20000000000ULL, 0x000000542044723cULL, 0x000fec0000001844ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x000100001d557824ULL, 0x000fce00078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410741d7816ULL, 0x002fce0000000077ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000541070707816ULL, 0x004fce000000006dULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000541071717816ULL, 0x002fce000000006cULL, 0x000000a800727306ULL, 0x000ff00000200c00ULL,
0x000000a900497306ULL, 0x000e620000200c00ULL, 0x000054106f6e7816ULL, 0x004fce000000006eULL,
0x0000001c00547306ULL, 0x0005f00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00005410791c7816ULL, 0x004fe40000000076ULL, 0x00005410726f7816ULL, 0x002fca0000000049ULL,
0x0000001c2040723cULL, 0x040fe20000001840ULL, 0x0000008300837306ULL, 0x000e6c0000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe20000011455ULL, 0x000000702020723cULL, 0x000fe20000001838ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000088801e557816ULL, 0x000fca00000000ffULL,
0x000088801f397816ULL, 0x000fe200000000ffULL, 0x000001001e387824ULL, 0x000fe200078e00ffULL,
0x0000009700577306ULL, 0x000ea20000200c00ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0055ULL,
0x00005410837d7816ULL, 0x002fe2000000006aULL, 0x000000ffff497224ULL, 0x000fe200078e0039ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000008004c397824ULL, 0x000fe200078e0227ULL,
0x0000006e142c723cULL, 0x000fe2000000182cULL, 0x000001001f277824ULL, 0x000fe200078e00ffULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x000100001e1e7824ULL, 0x000fc400078e00ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011427ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x0000541088837816ULL, 0x004fe40000000057ULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000003800557306ULL, 0x0005e20000200c00ULL, 0x0000541056567816ULL, 0x002fce0000000069ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x012000003938783bULL, 0x004ea20000000200ULL,
0x000054108f577816ULL, 0x008fcc0000000068ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000000561430723cULL, 0x000fee0000001830ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0001000018567824ULL, 0x000fe200078e00ffULL, 0x000054107c7c7816ULL, 0x002fc8000000006bULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x0000007c1428723cULL, 0x000fee0000001828ULL, 0x000000a100827306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000006538388232ULL, 0x004fc40000000000ULL,
0x000000653a3a8232ULL, 0x000fe40000000000ULL, 0x0000006439398232ULL, 0x080fe40000000000ULL,
0x000000643b3b8232ULL, 0x000fe20000000000ULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x000000010e00780cULL, 0x000fce0003f05270ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x002fce0000000085ULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x000054104b8a7816ULL, 0x004fe2000000008aULL, 0x00000082143c723cULL, 0x000fe2000000183cULL,
0x00010000194b7824ULL, 0x000fca00078e00ffULL, 0x0000006c001c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fce000001144bULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054107f8b7816ULL, 0x002fce000000007eULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x000054101c1c7816ULL, 0x004fe20000000055ULL, 0x0000008a1434723cULL, 0x000fec0000001834ULL,
0x0000005200527306ULL, 0x000ff00000200c00ULL, 0x0000001100117306ULL, 0x000ff00000200c00ULL,
0x0000001e00277306ULL, 0x0004f00000200c00ULL, 0x0000001f00187306ULL, 0x0009620000200c00ULL,
0x00005410541e7816ULL, 0x004fce0000000067ULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x000054101d1f7816ULL, 0x010fe40000000066ULL, 0x00005410491d7816ULL, 0x002fe4000000006aULL,
0x000088801a497816ULL, 0x000fc600000000ffULL, 0x0000001e1444723cULL, 0x040fe20000001844ULL,
0x0000000800087306ULL, 0x000fec0000200c00ULL, 0x00005410271e7816ULL, 0x008fe20000000052ULL,
0x0000001c1440723cULL, 0x040fe20000001840ULL, 0x00005410181f7816ULL, 0x020fe20000000011ULL,
0x000001001a187824ULL, 0x040fe200078e00ffULL, 0x000054105b277816ULL, 0x000fe20000000024ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x000000ffff117224ULL, 0x000fe200078e0049ULL, 0x000088801b1d7816ULL, 0x000fe200000000ffULL,
0x0000001e1414723cULL, 0x000fe20000001820ULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000005600197306ULL, 0x000fe40000200c00ULL,
0x000001001b1e7824ULL, 0x000fe200078e00ffULL, 0x0000541013217816ULL, 0x004fe2000000005aULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000000263828723cULL, 0x000fe40000001828ULL,
0x00000018ff1f7819ULL, 0x000fe2000001141eULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fc4000001141bULL, 0x0000541058207816ULL, 0x002fca000000005fULL,
0x0000000b000b7306ULL, 0x000fe40000200c00ULL, 0x000000203820723cULL, 0x000fec000000183cULL,
0x0000000a000a7306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000eb00000200c00ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541059487816ULL, 0x002fce0000000048ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x0000541025497816ULL, 0x004fce000000004aULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x00000048382c723cULL, 0x000fee000000182cULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x00005410601b7816ULL, 0x002fce000000000bULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x00005410635e7816ULL, 0x004fce000000005eULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x00005410615f7816ULL, 0x008fce000000005cULL, 0x00000018001c7306ULL, 0x0004e20000200c00ULL,
0x0000005e3834723cULL, 0x000fee0000001834ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x0000541019187816ULL, 0x004fe40000000008ULL, 0x000054104b197816ULL, 0x002fca000000000aULL,
0x0000001f00247306ULL, 0x000e620000200c00ULL, 0x00005410111c7816ULL, 0x008fe2000000001cULL,
0x000000183844723cULL, 0x000fec0000001844ULL, 0x0000000700077306ULL, 0x000ff00000200c00ULL,
0x0000000900097306ULL, 0x000fe20000200c00ULL, 0x000054101d1d7816ULL, 0x002fce0000000024ULL,
0x0000001a001e7306ULL, 0x0002a20000200c00ULL, 0x0000001c3840723cULL, 0x000fee0000001840ULL,
0x0000001300267306ULL, 0x000ee20000200c00ULL, 0x00005410621a7816ULL, 0x002fe4000000000dULL,
0x000054101e087816ULL, 0x004fca0000000007ULL, 0x0000001a3830723cULL, 0x000fe20000001830ULL,
0x0000541026097816ULL, 0x008fce0000000009ULL, 0x000000083838723cULL, 0x000fee0000001814ULL,
0x000000010e097812ULL, 0x000fe4000784c0ffULL, 0x0001b6684c087811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008ff7f8cULL, 0x0003e2000c80043fULL,
0x0001b6304c077811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff0fff7812ULL, 0x000fc8000782c0ffULL,
0x00000001ff0f8807ULL, 0x000fe40000800000ULL, 0x000000ff10ff7812ULL, 0x000fe4000780c0ffULL,
0x000000ff0fff7812ULL, 0x000fe4000782c0ffULL, 0x00000001ff0a7807ULL, 0x000fe40004000000ULL,
0x00000001ff0fa807ULL, 0x000fc80000800000ULL, 0x000076100f0b7816ULL, 0x000fe4000000000bULL,
0x0000030053537a10ULL, 0x004fe40007ffe0ffULL, 0x000000ff0cff7812ULL, 0x000fe4000780c0ffULL,
0x0000004e5300720cULL, 0x000fe40003f26070ULL, 0x00000001ff0c7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff9c8000007947ULL, 0x000fea000383ffffULL,
0x00000000000b7919ULL, 0x002e620000000000ULL, 0x000000024c007824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000ea40000002500ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000200027812ULL, 0x000fe200078e0cffULL, 0x0000008051007824ULL, 0x000fc600078e00ffULL,
0x0000000102027812ULL, 0x000fe200078ef851ULL, 0x000000100b037824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x100fe4000001160bULL, 0x00000002ff0b7819ULL, 0x000fe4000001160bULL,
0x00000070030d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c040f7812ULL, 0x000fe200078ec0ffULL,
0x0000008002047824ULL, 0x000fe200078e00ffULL, 0x0001b0000d027810ULL, 0x000fc40007ffe000ULL,
0x0001b2000d007810ULL, 0x040fe40007ffe000ULL, 0x0001b0000d037810ULL, 0x000fe20007ffe004ULL,
0x000000010f027824ULL, 0x000fe200078e0202ULL, 0x0001b2000d047810ULL, 0x000fe20007ffe004ULL,
0x000000010f077824ULL, 0x040fe200078e0200ULL, 0x000000044e007c0cULL, 0x004fe2000bf03070ULL,
0x000000010f007824ULL, 0x040fe200078e0203ULL, 0x0000000502007388ULL, 0x000fe20000000800ULL,
0x000000010f047824ULL, 0x000fc600078e0204ULL, 0x0000000607007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000007984ULL, 0x000e680000000800ULL,
0x0000000004047984ULL, 0x000ea20000000800ULL, 0x0000000500087209ULL, 0x002fca0007810000ULL,
0x0000000508037221ULL, 0x000fe40000010100ULL, 0x8000000800007221ULL, 0x000fe40000010000ULL,
0x3fb8aa3b03097820ULL, 0x000fe40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x3fb8aa3b00007820ULL, 0x000fe20000410000ULL, 0x00000009000a7308ULL, 0x000ef00000000800ULL,
0x0000000000097308ULL, 0x000ea20000000800ULL, 0x00001f0b0a027589ULL, 0x008ee200000e0000ULL,
0x0000000803077811ULL, 0x002fe200078ff0ffULL, 0x0000000904097220ULL, 0x004fc80000410000ULL,
0x00001f070a057589ULL, 0x000e6200000e0000ULL, 0x000000060a097223ULL, 0x000fe40000010009ULL,
0x0000002c022c7220ULL, 0x048fe40000410000ULL, 0x0000002d022d7220ULL, 0x040fe40000410000ULL,
0x0000002802287220ULL, 0x040fe40000410000ULL, 0x0000002902297220ULL, 0x040fe40000410000ULL,
0x0000002002207220ULL, 0x000fc40000410000ULL, 0x0000002102217220ULL, 0x040fe40000410000ULL,
0x0000003002307220ULL, 0x040fe40000410000ULL, 0x0000003102317220ULL, 0x040fe40000410000ULL,
0x0000003402347220ULL, 0x040fe40000410000ULL, 0x0000003502357220ULL, 0x040fe40000410000ULL,
0x0000004402447220ULL, 0x000fc40000410000ULL, 0x0000004502457220ULL, 0x040fe40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x040fe40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x000fe40000410000ULL,
0x0000002e052e7220ULL, 0x002fc40000410000ULL, 0x0000002f052f7220ULL, 0x040fe40000410000ULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x040fe40000410000ULL,
0x0000003205327220ULL, 0x000fc40000410000ULL, 0x0000003305337220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x040fe40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000004605467220ULL, 0x040fe40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x000fc40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x000fe20000410000ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000009007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000078a000067802ULL, 0x000fe40000000f00ULL, 0x00009fc000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0004ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000e640000001000ULL, 0xbf80000009027423ULL, 0x002fc80000000000ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff057624ULL, 0x000fe400078e00ffULL,
0x00006600ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000002ff0b7819ULL, 0x008fe40000011603ULL,
0x0000000803077811ULL, 0x000fe200078ff0ffULL, 0x0000000005007220ULL, 0x004fca0000410000ULL,
0x00001f0b00027589ULL, 0x000ea800000e0000ULL, 0x00001f0700067589ULL, 0x000ee200000e0000ULL,
0x000000022c2c7220ULL, 0x084fe40000410000ULL, 0x000000022d2d7220ULL, 0x080fe40000410000ULL,
0x0000000228287220ULL, 0x080fe40000410000ULL, 0x0000000229297220ULL, 0x000fc40000410000ULL,
0x0000000220207220ULL, 0x080fe40000410000ULL, 0x0000000221217220ULL, 0x080fe40000410000ULL,
0x0000000230307220ULL, 0x080fe40000410000ULL, 0x0000000231317220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x0000000235357220ULL, 0x000fc40000410000ULL,
0x0000000244447220ULL, 0x080fe40000410000ULL, 0x0000000245457220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x000fc40000410000ULL,
0x000000062e2e7220ULL, 0x088fe40000410000ULL, 0x000000062f2f7220ULL, 0x080fe40000410000ULL,
0x000000062a2a7220ULL, 0x080fe40000410000ULL, 0x000000062b2b7220ULL, 0x080fe40000410000ULL,
0x0000000622227220ULL, 0x080fe40000410000ULL, 0x0000000623237220ULL, 0x000fc40000410000ULL,
0x0000000632327220ULL, 0x080fe40000410000ULL, 0x0000000633337220ULL, 0x080fe40000410000ULL,
0x0000000636367220ULL, 0x080fe40000410000ULL, 0x0000000637377220ULL, 0x080fe40000410000ULL,
0x0000000646467220ULL, 0x080fe40000410000ULL, 0x0000000647477220ULL, 0x000fc40000410000ULL,
0x0000000642427220ULL, 0x080fe40000410000ULL, 0x0000000643437220ULL, 0x080fe40000410000ULL,
0x000000063a3a7220ULL, 0x080fe40000410000ULL, 0x000000063b3b7220ULL, 0x000fe40000410000ULL,
0x0000000203007812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff117819ULL, 0x000fe40000011603ULL, 0x0000000200047811ULL, 0x000fc400078ff8ffULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000400067811ULL, 0x040fe400078ff8ffULL,
0x00000006000c7811ULL, 0x000fe400078ff8ffULL, 0x0000000704057812ULL, 0x100fe400078e7811ULL,
0x0000000702007812ULL, 0x040fe400078e7811ULL, 0x0000000702027812ULL, 0x000fe200078e7807ULL,
0x00000008110d7824ULL, 0x000fe200078e0205ULL, 0x0000002c2d2c723eULL, 0x000fe200000000ffULL,
0x000010004f057824ULL, 0x000fe200078e00ffULL, 0x000000282916723eULL, 0x000fe200000000ffULL,
0x0000000807137824ULL, 0x000fe200078e0202ULL, 0x00000007060a7812ULL, 0x000fe200078e7811ULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0x000054102c187816ULL, 0x040fe20000000016ULL,
0x00000008110b7824ULL, 0x040fe200078e0200ULL, 0x000076322c197816ULL, 0x000fe20000000016ULL,
0x000008004c007824ULL, 0x000fe200078e0205ULL, 0x0000000802027812ULL, 0x000fe200078ec0ffULL,
0x00000008110f7824ULL, 0x000fe200078e020aULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x000000303110723eULL, 0x000fe200000000ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x0000000706067812ULL, 0x000fe200078e7807ULL,
0x000000010b0b7824ULL, 0x000fe200078e0202ULL, 0x000000070c0e7812ULL, 0x000fe200078e7811ULL,
0x00000001020d7824ULL, 0x000fe200078e020dULL, 0x00005410200a7816ULL, 0x000fe20000000010ULL,
0x0000000807177824ULL, 0x000fe200078e0206ULL, 0x000000180b007388ULL, 0x0005e20000000a00ULL,
0x000000100f0f7824ULL, 0x000fe200078e0200ULL, 0x000000343534723eULL, 0x000fe200000000ffULL,
0x0000000811117824ULL, 0x000fe200078e020eULL, 0x00000044451a723eULL, 0x000fe200000000ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e7807ULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0x000000070c0c7812ULL, 0x000fe200078e7807ULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x000000404140723eULL, 0x000fe200000000ffULL,
0x0000000807157824ULL, 0x000fe200078e0204ULL, 0x00007632200b7816ULL, 0x004fe20000000010ULL,
0x0000000102067824ULL, 0x040fe200078e0217ULL, 0x000000383920723eULL, 0x000fe200000000ffULL,
0x0000000807077824ULL, 0x000fe200078e020cULL, 0x0000002e2f2e723eULL, 0x000fe200000000ffULL,
0x0000000a0d007388ULL, 0x0005e20000000a00ULL, 0x0000000102047824ULL, 0x040fe200078e0211ULL,
0x0000002a2b17723eULL, 0x000fe200000000ffULL, 0x0000001013137824ULL, 0x100fe200078e0200ULL,
0x000000222322723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x000000323311723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x0000000102137824ULL, 0x040fe200078e0213ULL,
0x00000046471b723eULL, 0x000fe200000000ffULL, 0x0000000102157824ULL, 0x000fe200078e0215ULL,
0x00005410340a7816ULL, 0x104fe2000000001aULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x00007632340b7816ULL, 0x000fe2000000001aULL, 0x000000204c0e7824ULL, 0x000fe200078e0203ULL,
0x000000424342723eULL, 0x000fc400000000ffULL, 0x0000003a3b21723eULL, 0x000fe200000000ffULL,
0x0000000a0f007388ULL, 0x0005e20000000a00ULL, 0x000054102e167816ULL, 0x000fe20000000017ULL,
0x000000100e0c7824ULL, 0x000fe200078e0205ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe40000000011ULL,
0x00005410400a7816ULL, 0x004fc40000000020ULL, 0x00007632400b7816ULL, 0x000fe40000000020ULL,
0x0000541042207816ULL, 0x140fe40000000021ULL, 0x0000763242217816ULL, 0x000fe20000000021ULL,
0x0000000a04007388ULL, 0x0005e80000000a00ULL, 0x0000001613007388ULL, 0x000fe80000000a00ULL,
0x0000001015007388ULL, 0x000fe20000000a00ULL, 0x00005410360a7816ULL, 0x004fc4000000001bULL,
0x00007632360b7816ULL, 0x000fca000000001bULL, 0x0000000a06007388ULL, 0x000fe80000000a00ULL,
0x0000002007007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000400000c187984ULL, 0x000ea80000000c00ULL, 0x000c00000c1c7984ULL, 0x000ee80000000c00ULL,
0x000000000c107984ULL, 0x000f280000000c00ULL, 0x000800000c147984ULL, 0x000f620000000c00ULL,
0x200000ff18187230ULL, 0x004fc40000000000ULL, 0x200000ff1b1b7230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x008fe20000000000ULL, 0x00000300ff1c7624ULL, 0x000fe200078e00ffULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x010fe40000000000ULL,
0x000000011c00780cULL, 0x000fe20003f05270ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x020fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fc40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fe40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x000000100c007388ULL, 0x0005e20000000c00ULL,
0x0000001d19197230ULL, 0x000fca0000000000ULL, 0x000400180c007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000303000008947ULL, 0x000fea0003800000ULL,
0x0000000000127919ULL, 0x004ea20000002700ULL, 0x000058001c027a24ULL, 0x000fe200078e02ffULL,
0x000000014cff7812ULL, 0x000fe2000780f851ULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x0000640002067a24ULL, 0x000fe200078e02ffULL,
0x000000400e117810ULL, 0x000fe20007ffe0ffULL, 0x000008004f047824ULL, 0x000fe200078e00ffULL,
0x000000000c147984ULL, 0x0007240000000c00ULL, 0x00000fff06027811ULL, 0x000fc400078e40ffULL,
0x000400000c187984ULL, 0x0006620000000c00ULL, 0x01ffffff06067812ULL, 0x000fe200078ec0ffULL,
0x0000580012127a24ULL, 0x004fc800078e0207ULL, 0x0000030012077a24ULL, 0x000fca00078e02ffULL,
0x00000004070d7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000d020a7211ULL, 0x000fca00078fa0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000bULL, 0x000000040a0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x000000100e0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fe200078e000aULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x01afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x000fe200078e0206ULL, 0x000000700a1d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b1e7812ULL, 0x000fe200078ec0ffULL, 0x00006a000d0a7625ULL, 0x000fc800078e0013ULL,
0x00006a000c0c7625ULL, 0x000fe200078e0013ULL, 0x0000000a1e0a7210ULL, 0x000fc80007a1e01dULL,
0x0000000c1e0c7210ULL, 0x000fe40007c7e01dULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x000000080a007986ULL, 0x0003e8000c101906ULL,
0x000000090c007986ULL, 0x0003e4000c101906ULL, 0x000000140e007986ULL, 0x01a3e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001810007986ULL, 0x0003e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0xffffffff1c0b7810ULL, 0x000fc60007ffe0ffULL,
0x0000680012087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0800720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0a7807ULL, 0x000fca0000000000ULL, 0x0000000aff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x000ee40000000000ULL, 0x000000ff0800720cULL, 0x008fda0003f05270ULL,
0x00002c6000008947ULL, 0x000fea0003800000ULL, 0x000000ff5100720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001070a7810ULL, 0x004fe40007ffe0ffULL, 0x0000007008177812ULL, 0x002fe400078ec0ffULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0007087625ULL, 0x000fc800078e000dULL,
0x00006a000a0a7625ULL, 0x000fe200078e000dULL, 0x000000080e087210ULL, 0x000fc8000791e017ULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e017ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608087981ULL, 0x000368000c1e1900ULL,
0x000000060a0f7981ULL, 0x000362000c1e1900ULL, 0x000000021c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a097981ULL, 0x000362000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081c00780cULL, 0x002fe40003f06070ULL,
0x00000006070a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e017ULL, 0x00000007070c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c0e0c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000364000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c190981ULL, 0x000368000c1e1900ULL,
0x000000071c0a7810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x000fc8000001160aULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0008ULL,
0x000000080d0e7824ULL, 0x040fe200078e00ffULL, 0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000c0d00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080e0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x00000070101b7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090e0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000020e0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000f08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000030e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a097981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000040e0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001108087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000050e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000060e0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001508087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000070e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000001908087209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e197812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007a3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003097824ULL, 0x024fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011603ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x000000010a097824ULL, 0x000fca00078e0209ULL, 0x0000000809007388ULL, 0x0003e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x000000014c177824ULL, 0x002fe200078e0207ULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000010030a7824ULL, 0x004fe200078e00ffULL,
0x00000002ff087819ULL, 0x000fe20000011651ULL, 0x00001000ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000001702097211ULL, 0x000fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000c0b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000020051517824ULL, 0x000fe200078e00ffULL,
0x000000700a0c7812ULL, 0x000fe200078ec0ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000001080b7812ULL, 0x000fe200078ec0ffULL, 0x000000024c0a8824ULL, 0x000fe200078e024fULL,
0x0000080051517812ULL, 0x000fe200078ec0ffULL, 0x00006a0009087625ULL, 0x000fe200078e000eULL,
0x00000040030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000006003137810ULL, 0x000fe20007ffe0ffULL, 0x000000010d187824ULL, 0x000fe200078e020cULL,
0x00000020030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000020a148824ULL, 0x000fe200078e020bULL,
0x00000004080a7210ULL, 0x000fe20007f3e0ffULL, 0x000000024c0c8824ULL, 0x040fe200078e024fULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000020004c087824ULL, 0x000fe200078e0205ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000020c1a8824ULL, 0x000fe200078e020bULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000001080c7824ULL, 0x000fe200078e0251ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000106108824ULL, 0x000fc400078e0217ULL,
0x00000080ff118424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0609ULL,
0x000003004c007a0cULL, 0x000fe20003f26070ULL, 0x00000080ff168424ULL, 0x000fe200078e00ffULL,
0x0000000018097984ULL, 0x0002a20000000800ULL, 0x0000001003197824ULL, 0x000fe400078e020cULL,
0x00006a0010108625ULL, 0x000fc800078e0011ULL, 0x000000100d0c7825ULL, 0x000fc800078e000aULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001013127825ULL, 0x000fc800078e000aULL,
0x00006a0017168625ULL, 0x000fc800078e0016ULL, 0x00000008141b8824ULL, 0x000fe400078e0203ULL,
0x00000010030a7825ULL, 0x000fc600078e000aULL, 0x000045801b1b8811ULL, 0x000fe200078e20ffULL,
0x000000081a1a8824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a197faeULL, 0x0007e2000b901c46ULL, 0x0000001003148825ULL, 0x040fe400078e0010ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000041801a1d8811ULL, 0x000fe200078e20ffULL,
0x0000001003168825ULL, 0x000fe200078e0016ULL, 0x003800000c197faeULL, 0x0009e6000b901c46ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x005800000e197faeULL, 0x000be2000b901c46ULL,
0x00000000000a7805ULL, 0x008fc6000001ff00ULL, 0x0078000012197faeULL, 0x0007e8000b901c46ULL,
0x00000000141b8faeULL, 0x0005e2000b901c46ULL, 0x00000000000c7805ULL, 0x010fc6000001ff00ULL,
0x00000000161d8faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x002fe2000001ff00ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fca00078e004cULL, 0x000000022f2e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200078e002fULL, 0x00000002ff2c7819ULL, 0x002fe20000011603ULL,
0x000000024c307824ULL, 0x000fe200078e024fULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x00000040412d7824ULL, 0x000fe200078e00ffULL, 0x000000072c487812ULL, 0x040fe200078ec0ffULL,
0x000000082c2f7824ULL, 0x040fe200078e00ffULL, 0x0000002cff4a7212ULL, 0x000fe200078e33ffULL,
0x000000082c2b7824ULL, 0x040fe200078e00ffULL, 0x000000802d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000082c317824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff82f3c7812ULL, 0x100fe200078ee248ULL, 0x0000001003437824ULL, 0x000fe200078e00ffULL,
0x000000012b3e7812ULL, 0x140fe200078ef648ULL, 0x00000100303f7824ULL, 0x000fe200078e002dULL,
0x000000022b407812ULL, 0x000fc400078ef648ULL, 0x000000032b427812ULL, 0x140fe400078ef648ULL,
0x000000042b447812ULL, 0x140fe400078ef648ULL, 0x000000052b467812ULL, 0x140fe400078ef648ULL,
0x000000062b487812ULL, 0x000fe400078ef648ULL, 0xfffffff8314a7812ULL, 0x000fe400078ee24aULL,
0x000000082c2b7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x008fea0003800000ULL,
0x00000001073b7824ULL, 0x100fe200078e022eULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00001000ff317424ULL, 0x000fe200078e00ffULL, 0x00000001ff2d7819ULL, 0x000fc4000001162eULL,
0x0000003b02307211ULL, 0x000fe400078fa0ffULL, 0x000000012d2f7812ULL, 0x000fe200078ec0ffULL,
0x000004002e2d7824ULL, 0x000fe200078e00ffULL, 0x0000002003357810ULL, 0x040fe20007ffe0ffULL,
0x00006a0030307625ULL, 0x000fe200078e0031ULL, 0x0000004003377810ULL, 0x000fe40007ffe0ffULL,
0x000008002d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000024c329824ULL, 0x100fe200078e024fULL,
0x0000000430307210ULL, 0x000fe20007f1e0ffULL, 0x000000024c4e9824ULL, 0x000fc400078e024fULL,
0x0000000232509824ULL, 0x100fe400078e022fULL, 0x000000024e4e9824ULL, 0x000fe200078e022fULL,
0x00000060032f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108327824ULL, 0x000fe400078e022dULL,
0x000000ffff317224ULL, 0x000fe400000e0631ULL, 0x0000000106389824ULL, 0x000fe400078e023bULL,
0x00000080ff399424ULL, 0x000fc400078e00ffULL, 0x00000080ff3a9424ULL, 0x000fe400078e00ffULL,
0x00000010032d7824ULL, 0x040fe400078e0232ULL, 0x0000001003327825ULL, 0x000fc800078e0030ULL,
0x0000001035347825ULL, 0x100fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000322d7faeULL, 0x0003e6000b901c46ULL, 0x0000001037367825ULL, 0x100fe200078e0030ULL,
0x00380000342d7faeULL, 0x0003e6000b901c46ULL, 0x00006a0038389625ULL, 0x000fe200078e0039ULL,
0x00580000362d7faeULL, 0x0003e6000b901c46ULL, 0x000000102f307825ULL, 0x000fc800078e0030ULL,
0x00006a003b3a9625ULL, 0x000fe200078e003aULL, 0x00780000302d7faeULL, 0x0003e6000b901c46ULL,
0x000000084e2f9824ULL, 0x100fe400078e0203ULL, 0x00000008503d9824ULL, 0x000fe400078e0203ULL,
0x0000001003389825ULL, 0x000fe200078e0038ULL, 0x000045802f2f9811ULL, 0x000fe400078e20ffULL,
0x000041803d3d9811ULL, 0x000fe200078e20ffULL, 0x00000010033a9825ULL, 0x000fc400078e003aULL,
0x00000000382f9faeULL, 0x0003e8000b901c46ULL, 0x000000003a3d9faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff307819ULL, 0x002fe20000011603ULL, 0x00000400412d7824ULL, 0x000fe200078e00ffULL,
0x0000007043507812ULL, 0x000fe200078ec0ffULL, 0x000000082b347824ULL, 0x040fe200078e00ffULL,
0x0000000c30317812ULL, 0x000fe200078ec0ffULL, 0x000000082b327824ULL, 0x040fe200078e00ffULL,
0x000000072b2f7812ULL, 0x000fc400078ec0ffULL, 0x0000003f313f7210ULL, 0x000fe20007ffe050ULL,
0x000000082b317824ULL, 0x000fe200078e00ffULL, 0xfffffff834307812ULL, 0x100fe400078ee22fULL,
0x000008002d2d7812ULL, 0x000fe400078ec0ffULL, 0x0000000132347812ULL, 0x140fe400078ef62fULL,
0x0000000232367812ULL, 0x140fe400078ef62fULL, 0x0000000332387812ULL, 0x000fc400078ef62fULL,
0x00000004323a7812ULL, 0x140fe400078ef62fULL, 0x00000005324e7812ULL, 0x000fe200078ef62fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003f527984ULL, 0x000e620000000800ULL,
0x0000000632327812ULL, 0x000fe200078ef62fULL, 0x00000004032f7824ULL, 0x000fe200078e00ffULL,
0x0000002bff507212ULL, 0x000fe200078e33ffULL, 0x004580003f3f7984ULL, 0x000fe20000000800ULL,
0x00000180082d7810ULL, 0x000fe40007ffe02dULL, 0xfffffff831507812ULL, 0x000fe400078ee250ULL,
0x0000000c2f2f7812ULL, 0x000fe200078ec0ffULL, 0x000000103c3c7824ULL, 0x000fc400078e022dULL,
0x000000103e3e7824ULL, 0x100fe400078e022dULL, 0x0000001040407824ULL, 0x100fe400078e022dULL,
0x0000001042427824ULL, 0x100fe400078e022dULL, 0x0000001044447824ULL, 0x100fe400078e022dULL,
0x0000001046467824ULL, 0x100fe400078e022dULL, 0x0000001048487824ULL, 0x000fc400078e022dULL,
0x000000104a4a7824ULL, 0x100fe400078e022dULL, 0x0000001030307824ULL, 0x100fe400078e022dULL,
0x0000001034347824ULL, 0x100fe400078e022dULL, 0x000000104e4e7824ULL, 0x100fe400078e022dULL,
0x0000001032327824ULL, 0x100fe400078e022dULL, 0x0000001050507824ULL, 0x000fc400078e022dULL,
0x000000013c3c7824ULL, 0x000fe400078e022fULL, 0x000000012f3e7824ULL, 0x040fe400078e023eULL,
0x0000001036367824ULL, 0x100fe400078e022dULL, 0x0000001038387824ULL, 0x100fe200078e022dULL,
0x000000003c3c7984ULL, 0x000ea20000000800ULL, 0x000000103a3a7824ULL, 0x000fe400078e022dULL,
0x000000012f407824ULL, 0x040fe200078e0240ULL, 0x000000003e3e7984ULL, 0x000ee20000000800ULL,
0x000000012f427824ULL, 0x000fc400078e0242ULL, 0x000000012f447824ULL, 0x040fe400078e0244ULL,
0x000000012f467824ULL, 0x040fe200078e0246ULL, 0x0000000040407984ULL, 0x000f220000000800ULL,
0x000000012f487824ULL, 0x040fe400078e0248ULL, 0x000000012f4a7824ULL, 0x040fe200078e024aULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x000000012f307824ULL, 0x040fe400078e0230ULL,
0x000000012f347824ULL, 0x040fe200078e0234ULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x000000012f4e7824ULL, 0x000fc400078e024eULL, 0x000000012f327824ULL, 0x040fe200078e0232ULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x000000012f507824ULL, 0x040fe400078e0250ULL,
0x000000012f367824ULL, 0x040fe200078e0236ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x000000012f387824ULL, 0x040fe400078e0238ULL, 0x000000012f3a7824ULL, 0x000fe200078e023aULL,
0x000000004a4a7984ULL, 0x000f620000000800ULL, 0x0000005209527221ULL, 0x002fc40000010100ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x3fb8aa3b52527820ULL, 0x000fc60000410000ULL, 0x0000000034347984ULL, 0x000e620000000800ULL,
0x000003002f007a0cULL, 0x000fe20003f06070ULL, 0x2000003cff317230ULL, 0x104fe20000004100ULL,
0x0000005200527308ULL, 0x000ea20000000800ULL, 0x000000004e4e7984ULL, 0x000e620000000800ULL,
0x3000003cff337230ULL, 0x000fe40000004100ULL, 0x2000003eff357230ULL, 0x108fe20000004100ULL,
0x0000000032327984ULL, 0x000ee20000000800ULL, 0x3000003eff3b7230ULL, 0x000fc60000004100ULL,
0x0000000050507984ULL, 0x000ee20000000800ULL, 0x20000040ff3c7230ULL, 0x110fe40000004100ULL,
0x30000040ff3d7230ULL, 0x000fe20000004100ULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x20000042ff3e7230ULL, 0x120fe20000004100ULL, 0x0000003f52377220ULL, 0x004fe40000410000ULL,
0x0000000038387984ULL, 0x000ea20000000800ULL, 0x30000042ff3f7230ULL, 0x000fe40000004100ULL,
0x20000044ff407230ULL, 0x100fe20000004100ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x30000044ff417230ULL, 0x000fe20000004100ULL, 0x0000002a372a7221ULL, 0x000fe20000010000ULL,
0x20000046ff427230ULL, 0x000fc40000004100ULL, 0x30000046ff437230ULL, 0x000fe40000004100ULL,
0x20000048ff447230ULL, 0x100fe40000004100ULL, 0x30000048ff457230ULL, 0x000fe40000004100ULL,
0x2000004aff467230ULL, 0x100fe40000004100ULL, 0x3000004aff477230ULL, 0x000fe40000004100ULL,
0x20000030ff487230ULL, 0x002fc40000004100ULL, 0x20000034ff4a7230ULL, 0x000fe40000004100ULL,
0x30000030ff307230ULL, 0x000fe40000004100ULL, 0x2000004eff587230ULL, 0x000fe40000004100ULL,
0x30000034ff347230ULL, 0x000fe40000004100ULL, 0x20000032ff5a7230ULL, 0x008fe40000004100ULL,
0x3000004eff4e7230ULL, 0x000fc40000004100ULL, 0x20000050ff5c7230ULL, 0x000fe40000004100ULL,
0x30000032ff327230ULL, 0x000fe40000004100ULL, 0x20000036ff527230ULL, 0x110fe40000004100ULL,
0x30000036ff497230ULL, 0x000fe40000004100ULL, 0x20000038ff547230ULL, 0x104fe40000004100ULL,
0x30000038ff4b7230ULL, 0x000fc40000004100ULL, 0x2000003aff567230ULL, 0x120fe40000004100ULL,
0x3000003aff4d7230ULL, 0x000fe40000004100ULL, 0x30000050ff507230ULL, 0x000fe20000004100ULL,
0x00006e727f007947ULL, 0x000fea000b800000ULL, 0x00001f2c372e7589ULL, 0x0002a400000e0000ULL,
0x00006ec27f007947ULL, 0x000fea000b800000ULL, 0x00001f2b372b7589ULL, 0x00072400000e0000ULL,
0x0000002e31297223ULL, 0x084fe40000010029ULL, 0x0000002e33287223ULL, 0x080fe40000010028ULL,
0x0000002e35257223ULL, 0x080fe40000010025ULL, 0x0000002e3b247223ULL, 0x000fc40000010024ULL,
0x0000002e3c217223ULL, 0x080fe40000010021ULL, 0x0000002e3d207223ULL, 0x080fe40000010020ULL,
0x0000002e3e1d7223ULL, 0x080fe4000001001dULL, 0x0000002e3f1c7223ULL, 0x080fe4000001001cULL,
0x0000002e40197223ULL, 0x080fe40000010019ULL, 0x0000002e41187223ULL, 0x000fc40000010018ULL,
0x0000002e42157223ULL, 0x080fe40000010015ULL, 0x0000002e43147223ULL, 0x080fe40000010014ULL,
0x0000002e44117223ULL, 0x080fe40000010011ULL, 0x0000002e45107223ULL, 0x080fe40000010010ULL,
0x0000002e460d7223ULL, 0x080fe4000001000dULL, 0x0000002e470c7223ULL, 0x000fc4000001000cULL,
0x0000002b48277223ULL, 0x090fe40000010027ULL, 0x0000002b30267223ULL, 0x080fe40000010026ULL,
0x0000002b4a237223ULL, 0x080fe40000010023ULL, 0x0000002b34227223ULL, 0x080fe40000010022ULL,
0x0000002b521f7223ULL, 0x080fe4000001001fULL, 0x0000002b491e7223ULL, 0x000fc4000001001eULL,
0x0000002b541b7223ULL, 0x080fe4000001001bULL, 0x0000002b4b1a7223ULL, 0x080fe4000001001aULL,
0x0000002b56177223ULL, 0x080fe40000010017ULL, 0x0000002b4d167223ULL, 0x080fe40000010016ULL,
0x0000002b58137223ULL, 0x080fe40000010013ULL, 0x0000002b4e127223ULL, 0x000fc40000010012ULL,
0x0000002b5a0f7223ULL, 0x080fe4000001000fULL, 0x0000002b320e7223ULL, 0x080fe4000001000eULL,
0x0000002b5c0b7223ULL, 0x080fe4000001000bULL, 0x0000002b500a7223ULL, 0x000fe2000001000aULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000ff4f00720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x004fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fca00078ec0ffULL,
0x0000000102047824ULL, 0x000fe200078e0203ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x0000001002037824ULL, 0x004fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fc600078ec0ffULL, 0x000000804c037824ULL, 0x000fc800078e0203ULL,
0x0000000103037824ULL, 0x000fca00078e0202ULL, 0x0049802a03007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0049800004027984ULL, 0x000f280000000800ULL,
0x004a000004037984ULL, 0x004ea20000000800ULL, 0x00000002ff027221ULL, 0x010fc80000010000ULL,
0x0000000302027221ULL, 0x004fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0002ULL, 0x0000a81000067802ULL, 0x000fe40000000f00ULL,
0x0000705000007944ULL, 0x00afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000ea40000001000ULL, 0xbf80000002047423ULL, 0x004fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008032f7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2d7819ULL, 0x000fe40000011603ULL, 0x0000002fff2b7212ULL, 0x000fe200078e33ffULL,
0x00001f2f04067589ULL, 0x000ea200000e0000ULL, 0x000000082f087824ULL, 0x000fc400078e00ffULL,
0x000000082d317824ULL, 0x000fe200078e00ffULL, 0x00001f2d04027589ULL, 0x00096200000e0000ULL,
0x000000082f2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8082b7812ULL, 0x000fe200078ee22bULL,
0x000000082d087824ULL, 0x000fc800078e00ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0xfffffff808077812ULL, 0x000fe400078ee22dULL, 0x0000002dff047212ULL, 0x010fc600078e33ffULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0xfffffff831317812ULL, 0x000fe400078ee204ULL,
0x000000072d047812ULL, 0x000fe200078ec0ffULL, 0x0000002306237220ULL, 0x004fc60000410000ULL,
0x0000000104087812ULL, 0x000fe200078e3cffULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x00000004042a7812ULL, 0x000fe200078e3cffULL, 0x0000002102217220ULL, 0x020fe20000410000ULL,
0x00000005042c7812ULL, 0x002fe200078e3cffULL, 0x0000002002207220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000002902297220ULL, 0x040fe40000410000ULL,
0x0000002802287220ULL, 0x000fe20000410000ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x000000072f217812ULL, 0x000fe200078ec0ffULL,
0x0000002402247220ULL, 0x000fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000001d021d7220ULL, 0x000fc40000410000ULL, 0x0000001c021c7220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000001902197220ULL, 0x040fe40000410000ULL,
0x0000001802187220ULL, 0x000fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001502157220ULL, 0x040fe40000410000ULL, 0x0000001402147220ULL, 0x000fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000001102117220ULL, 0x000fc40000410000ULL,
0x0000001002107220ULL, 0x000fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000000d020d7220ULL, 0x000fe20000410000ULL, 0xfffffff82e157812ULL, 0x000fe200078ee22fULL,
0x0000002706277220ULL, 0x000fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000002606267220ULL, 0x040fe40000410000ULL, 0x0000001f061f7220ULL, 0x040fe40000410000ULL,
0x0000001e061e7220ULL, 0x000fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000001b061b7220ULL, 0x000fc40000410000ULL, 0x0000001a061a7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001706177220ULL, 0x040fe20000410000ULL,
0x00000005211f7812ULL, 0x000fe200078e3cffULL, 0x0000001606167220ULL, 0x000fe20000410000ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000001306137220ULL, 0x040fe40000410000ULL,
0x0000001206127220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000000f060f7220ULL, 0x000fc40000410000ULL, 0x0000000e060e7220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x000fe40000410000ULL,
0x0000000c02027220ULL, 0x000fe20000410000ULL, 0x00000003040c7812ULL, 0x000fe200078e3cffULL,
0x0000000a06067220ULL, 0x000fe20000410000ULL, 0x00000002040a7812ULL, 0x040fe200078e3cffULL,
0x0000000403237824ULL, 0x000fe200078e00ffULL, 0x0000000604047812ULL, 0x000fe200078e3cffULL,
0x000000082d097824ULL, 0x040fe200078e0208ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082d0f7824ULL, 0x040fe200078e022aULL, 0x0000000b0606723eULL, 0x000fe200000000ffULL,
0x000000082d0b7824ULL, 0x040fe200078e020aULL, 0x0000000d0202723eULL, 0x000fe200000000ffULL,
0x000000082d0d7824ULL, 0x000fe200078e020cULL, 0x0000000c232a7812ULL, 0x000fe200078ec0ffULL,
0x000000082d137824ULL, 0x000fe200078e0204ULL, 0x0000000121047812ULL, 0x000fe200078e3cffULL,
0x000000082d117824ULL, 0x000fe200078e022cULL, 0x0000000221087812ULL, 0x000fe200078e3cffULL,
0x0000001009097824ULL, 0x100fe200078e0200ULL, 0x00000003210a7812ULL, 0x000fe200078e3cffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x00000004210c7812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x0000000621217812ULL, 0x000fe200078e3cffULL,
0x000000012a077824ULL, 0x000fc400078e0207ULL, 0x000000100f0f7824ULL, 0x000fe400078e0200ULL,
0x000000082f177824ULL, 0x000fe200078e0204ULL, 0x0000002807007388ULL, 0x0003e20000000800ULL,
0x0000001011117824ULL, 0x000fe400078e0200ULL, 0x000000012a097824ULL, 0x040fe400078e0209ULL,
0x000000082f197824ULL, 0x000fe400078e0208ULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x0000002409007388ULL, 0x000fe20000000800ULL, 0x000000012a0b7824ULL, 0x000fc400078e020bULL,
0x000000082f1b7824ULL, 0x000fe400078e020aULL, 0x0000001031047824ULL, 0x000fe200078e0200ULL,
0x000000200b007388ULL, 0x000fe20000000800ULL, 0x000000012a0d7824ULL, 0x040fe400078e020dULL,
0x000000082f1d7824ULL, 0x000fe400078e020cULL, 0x0000001015087824ULL, 0x000fe200078e0200ULL,
0x0000001c0d007388ULL, 0x000fe20000000800ULL, 0x000000012a0f7824ULL, 0x000fc400078e020fULL,
0x000000082f1f7824ULL, 0x000fe400078e021fULL, 0x00000010170a7824ULL, 0x100fe200078e0200ULL,
0x000000180f007388ULL, 0x000fe20000000800ULL, 0x000000012a117824ULL, 0x040fe400078e0211ULL,
0x000000082f217824ULL, 0x000fe400078e0221ULL, 0x00000010190c7824ULL, 0x000fe200078e0200ULL,
0x0000001411007388ULL, 0x000fe20000000800ULL, 0x000000012a137824ULL, 0x000fc400078e0213ULL,
0x000000101b1b7824ULL, 0x000fe400078e0200ULL, 0x000000012a157824ULL, 0x040fe200078e0204ULL,
0x0000001013007388ULL, 0x000fe20000000800ULL, 0x000000101d1d7824ULL, 0x000fe400078e0200ULL,
0x000000012a177824ULL, 0x040fe200078e0208ULL, 0x0000000215007388ULL, 0x000fe20000000800ULL,
0x000000101f1f7824ULL, 0x000fe400078e0200ULL, 0x000000012a197824ULL, 0x000fe200078e020aULL,
0x0000002617007388ULL, 0x000fe20000000800ULL, 0x0000001021217824ULL, 0x000fc400078e0200ULL,
0x000000012a077824ULL, 0x042fe200078e020cULL, 0x0000002219007388ULL, 0x000fe20000000800ULL,
0x000000012a1b7824ULL, 0x040fe400078e021bULL, 0x000000012a1d7824ULL, 0x040fe200078e021dULL,
0x0000001e07007388ULL, 0x000fe20000000800ULL, 0x000000012a1f7824ULL, 0x040fe400078e021fULL,
0x000000012a217824ULL, 0x040fe200078e0221ULL, 0x0000001a1b007388ULL, 0x000fe20000000800ULL,
0x000000012a2b7824ULL, 0x000fc400078e022bULL, 0x000000204c007824ULL, 0x000fe200078e0203ULL,
0x000000161d007388ULL, 0x000fe60000000800ULL, 0x0000001000007824ULL, 0x000fe200078e0205ULL,
0x000000121f007388ULL, 0x000fe80000000800ULL, 0x0000000e21007388ULL, 0x000fe80000000800ULL,
0x000000062b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000087984ULL, 0x000e680000000c00ULL, 0x00040000002c7984ULL, 0x000ea80000000c00ULL,
0x0008000000247984ULL, 0x000f280000000c00ULL, 0x000c000000307984ULL, 0x000f620000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x004fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x000000270b0b7230ULL, 0x010fe40000000000ULL, 0x000000260a0a7230ULL, 0x000fe40000000000ULL,
0x0000002509097230ULL, 0x000fe40000000000ULL, 0x0000002408087230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x020fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000000800007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c00007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4c00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000177919ULL, 0x002e620000002600ULL,
0x00000020031d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000f220000002700ULL,
0x00000040031f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006003217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff007819ULL, 0x000fe20000011603ULL, 0x000000084f187824ULL, 0x044fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe2000001161dULL, 0x000000084f1c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe2000001161fULL, 0x000000084f1a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe20000011621ULL, 0x000000084f1e7824ULL, 0x000fe200078e00ffULL,
0x0000000714047812ULL, 0x000fc400078e481dULL, 0x0000000715067812ULL, 0x000fe400078e481fULL,
0x0ffffff804047812ULL, 0x000fe400078ef81dULL, 0x0ffffff806067812ULL, 0x000fe400078ef81fULL,
0xfffffff8181b7812ULL, 0x000fe200078ee203ULL, 0x0000001017077824ULL, 0x002fe200078e00ffULL,
0xfffffff81c1f7812ULL, 0x000fe200078ee21fULL, 0x0000001004087824ULL, 0x100fe200078e0205ULL,
0x00000004050472a4ULL, 0x010fe2000f8e023fULL, 0x00000010060c7824ULL, 0x000fe200078e0205ULL,
0xfffffff007027812ULL, 0x000fe200078ee200ULL, 0x0000001017197824ULL, 0x040fe200078e00ffULL,
0x0000000700007812ULL, 0x000fe200078e4803ULL, 0x0000001017187824ULL, 0x040fe200078e00ffULL,
0x0000000716077812ULL, 0x000fe200078e4821ULL, 0x000000000c0c7984ULL, 0x000fe20000000c00ULL,
0x0ffffff800007812ULL, 0x000fe200078ef803ULL, 0x0000001017177824ULL, 0x000fe200078e00ffULL,
0x0ffffff8070a7812ULL, 0x000fc400078ef821ULL, 0x0000000402037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001000007824ULL, 0x100fe200078e0205ULL, 0xfffffff019147812ULL, 0x000fe200078ee214ULL,
0x000000100a107824ULL, 0x000fe200078e0205ULL, 0xfffffff018157812ULL, 0x000fe200078ee215ULL,
0x0000000008087984ULL, 0x000fe20000000c00ULL, 0xfffffff017167812ULL, 0x000fe400078ee216ULL,
0x0000000415177c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000000047984ULL, 0x0002a20000000c00ULL,
0xfffffff81a1d7812ULL, 0x000fc400078ee21dULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x0000000010107984ULL, 0x000f220000000c00ULL, 0x000000ffff1a7224ULL, 0x000fe400008e06ffULL,
0x000000ffff007224ULL, 0x002fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fc800078040ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4400ULL, 0x00000004141c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000416007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x00005a0017167a11ULL, 0x000fc600078240ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005a001c147a11ULL, 0x000fe200078040ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x000fe400078440ffULL, 0x00005b001c157a11ULL, 0x000fe400000f4415ULL,
0x00005b0017177a11ULL, 0x000fe400008f441aULL, 0x00005b0000197a11ULL, 0x000fe200010f4419ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x000000101f167825ULL, 0x000fc800078e0016ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d06ULL,
0x0000000814007986ULL, 0x000fe8000c101d06ULL, 0x0000000c16007986ULL, 0x000fe8000c101d06ULL,
0x0000001018007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff307624ULL, 0x000fe400078e00ffULL, 0x00006700ff317624ULL, 0x000fca00078e00ffULL,
0x0000000630307981ULL, 0x000562000c1e9900ULL, 0x0000000153037810ULL, 0x002fe20007ffe0ffULL,
0x000000024d4d7824ULL, 0x000fe400078e00ffULL, 0x0000004051007824ULL, 0x000fe200078e00ffULL,
0x0000004e0300720cULL, 0x000fe20003f06070ULL, 0x000058004d027a24ULL, 0x000fe400078e020eULL,
0x0000010053077824ULL, 0x000fc800078e0200ULL, 0x0000620002037a24ULL, 0x000fcc00078e0207ULL,
0x00000ba000008947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x004e620000000000ULL,
0x0000000750047217ULL, 0x000fe20007800000ULL, 0x00000080ff257424ULL, 0x000fe200078e00ffULL,
0x0000100051197811ULL, 0x000fc600078e70ffULL, 0x0000000104187824ULL, 0x000fe200078e0a07ULL,
0x00000003ff247819ULL, 0x002fe20000011623ULL, 0x0000001023077824ULL, 0x000fc600078e00ffULL,
0x0000000424087810ULL, 0x040fe20007ffe0ffULL, 0x0000000124047824ULL, 0x040fe200078e0203ULL,
0x00000008240a7810ULL, 0x000fe40007ffe0ffULL, 0x0000002308057212ULL, 0x0c0fe200078e3cffULL,
0x0000000808167824ULL, 0x000fe200078e00ffULL, 0x000000230a067212ULL, 0x040fe200078e3cffULL,
0x000000080a097824ULL, 0x000fe200078e00ffULL, 0x0000000c240e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0xfffffff8091a7812ULL, 0x000fc400078ee206ULL, 0x0000007007277812ULL, 0x000fe200078ec0ffULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x0000001024107810ULL, 0x000fe20007ffe0ffULL,
0x00000010161d7824ULL, 0x000fe200078e0219ULL, 0x000000230e067212ULL, 0x000fe400078e3cffULL,
0x00000027040c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000810077824ULL, 0x000fe200078e00ffULL,
0xfffffff8091c7812ULL, 0x000fe200078ee206ULL, 0x0000000108047824ULL, 0x000fe200078e0203ULL,
0x0000002310067212ULL, 0x000fe200078e3cffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x000000180800720cULL, 0x000fe20003f86070ULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0xfffffff8071e7812ULL, 0x000fc400078ee206ULL, 0x000000180e00720cULL, 0x080fe20003f66070ULL,
0x000000010a067824ULL, 0x100fe200078e0203ULL, 0x0000001424147810ULL, 0x000fe20007ffe0ffULL,
0x000000010e087824ULL, 0x100fe200078e0203ULL, 0x00000027040e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000181000720cULL, 0x080fe40003f06070ULL,
0x000000180a00720cULL, 0x000fe20003f46070ULL, 0x0000000110097824ULL, 0x000fe200078e0203ULL,
0x0000001824227810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0605ULL,
0x0000002706107210ULL, 0x000fe20007f3e0ffULL, 0x00005e0008047625ULL, 0x000fe200078e0025ULL,
0x0000000724207812ULL, 0x000fc400078e4823ULL, 0x0000002314067212ULL, 0x040fe200078e3cffULL,
0x00000001140a7824ULL, 0x000fe200078e0203ULL, 0x0000001c24267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0607ULL, 0x0000002704127210ULL, 0x000fe20007f3e0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0025ULL, 0x0000002024217810ULL, 0x000fe40007ffe0ffULL,
0x00000023221f7212ULL, 0x000fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0025ULL,
0x0000002708087210ULL, 0x000fc60007fbe0ffULL, 0x0000000122047824ULL, 0x000fe200078e0203ULL,
0x000000270a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0605ULL,
0x000000181400720cULL, 0x000fe20003f26070ULL, 0x00005e0004047625ULL, 0x000fc800078e0025ULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x000000182400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0b7224ULL, 0x000fe400030e060bULL, 0x0000000814077824ULL, 0x000fe200078e00ffULL,
0x0000002704147210ULL, 0x000fe40007fde0ffULL, 0x0ffffff820047812ULL, 0x000fe400078ef823ULL,
0xfffffff807207812ULL, 0x000fe200078ee206ULL, 0x000000ffff157224ULL, 0x000fc400030e0605ULL,
0x00000010041b7824ULL, 0x000fe400078e0219ULL, 0x0000000126047824ULL, 0x000fe400078e0203ULL,
0x0000000103067824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1b7faeULL, 0x0003e2000e901c46ULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0x000000182200720cULL, 0x040fe40003fa6070ULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x0000002704167210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x0000002326047212ULL, 0x000fc400078e3cffULL,
0x000000182600720cULL, 0x080fe20003f86070ULL, 0x000000ffff177224ULL, 0x000fe200030e0605ULL,
0x00000024240c7810ULL, 0x002fe20007ffe0ffULL, 0x00000008260d7824ULL, 0x000fe200078e00ffULL,
0x0000002706067210ULL, 0x000fe20007fde0ffULL, 0x000000101c1b7824ULL, 0x000fe200078e0219ULL,
0xfffffff8220e7812ULL, 0x004fe200078ee21fULL, 0x000000101a0f7824ULL, 0x000fe200078e0219ULL,
0xfffffff80d227812ULL, 0x000fe200078ee204ULL, 0x0000000103047824ULL, 0x000fe200078e020cULL,
0x00000023210d7212ULL, 0x040fe200078e3cffULL, 0x00000008211c7824ULL, 0x000fe200078e00ffULL,
0x00000000100f7faeULL, 0x0003e2000d101c46ULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0x000000180c00720cULL, 0x000fc40003f46070ULL, 0x000000230c1a7212ULL, 0x040fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x00000000121b7faeULL, 0x0005e2000d901c46ULL,
0x000000080c1d7824ULL, 0x000fe200078e00ffULL, 0x00000027040c7210ULL, 0x000fe40007fde0ffULL,
0xfffffff81c047812ULL, 0x000fe200078ee20dULL, 0x000000101e0f7824ULL, 0x002fe200078e0219ULL,
0x000000182100720cULL, 0x080fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee21aULL, 0x0000001020057824ULL, 0x100fe200078e0219ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x00000010041b7824ULL, 0x104fe200078e0219ULL,
0x0000002824047810ULL, 0x000fe20007ffe0ffULL, 0x000000100e117824ULL, 0x100fe200078e0219ULL,
0x000000000a057faeULL, 0x0005e2000c901c46ULL, 0x0000001022137824ULL, 0x000fe200078e0219ULL,
0x000000180400720cULL, 0x040fe20003fc6070ULL, 0x0000000804107824ULL, 0x000fe200078e00ffULL,
0x0000002c240e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000014117faeULL, 0x0007e2000e901c46ULL,
0x0000003024127810ULL, 0x000fc40007ffe0ffULL, 0x000000230e097212ULL, 0x0c2fe200078e3cffULL,
0x0000000016137faeULL, 0x0003e2000e101c46ULL, 0x000000180e00720cULL, 0x080fe40003fa6070ULL,
0x0000002304057212ULL, 0x004fe200078e3cffULL, 0x0000000103047824ULL, 0x000fe200078e0204ULL,
0x00000000061b7faeULL, 0x0005e2000d901c46ULL, 0x000000101a0b7824ULL, 0x000fe200078e0219ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x000fe200078e0025ULL,
0x000000181200720cULL, 0x000fc40003f86070ULL, 0x000000000c0b7faeULL, 0x0009e2000d101c46ULL,
0x000000080e147824ULL, 0x008fe200078e00ffULL, 0x0000002704087210ULL, 0x000fe20007f5e0ffULL,
0x00000001030a7824ULL, 0x040fe200078e0212ULL, 0x00000034240f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000812117824ULL, 0x000fe200078e00ffULL, 0x00000038241c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103067824ULL, 0x004fe200078e020eULL, 0x00000023120e7212ULL, 0x000fe200078e3cffULL,
0x000000080f167824ULL, 0x042fe200078e00ffULL, 0xfffffff814127812ULL, 0x000fe200078ee209ULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000230f0d7212ULL, 0x010fc400078e3cffULL,
0x0000003c241d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x00005e000a047625ULL, 0x000fe200078e0025ULL,
0x00000027060a7210ULL, 0x080fe40007f5e0ffULL, 0xfffffff811147812ULL, 0x000fe200078ee20eULL,
0x0000000103067824ULL, 0x000fe200078e020fULL, 0x000000181d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0607ULL, 0x00000027040c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000180f00720cULL, 0x000fc40003f66070ULL,
0x000000181c00720cULL, 0x000fe20003f26070ULL, 0x0000000103047824ULL, 0x040fe400078e021cULL,
0x000000ffff0d7224ULL, 0x000fe200010e0605ULL, 0x00000027060e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000103117824ULL, 0x000fe200078e021dULL, 0x000000231d067212ULL, 0x000fe200078e3cffULL,
0x00005e0004047625ULL, 0x000fe200078e0025ULL, 0x000000231c037212ULL, 0x000fc600078e3cffULL,
0x000000081d1d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e0607ULL,
0x0000002704047210ULL, 0x000fe20007f5e0ffULL, 0x000000081c187824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee206ULL, 0x00005e0011067625ULL, 0x000fc600078e0025ULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000002706067210ULL, 0x000fe20007f5e0ffULL, 0x0000001010037824ULL, 0x100fe400078e0219ULL,
0x0000001012117824ULL, 0x100fe400078e0219ULL, 0x0000001014137824ULL, 0x100fe200078e0219ULL,
0x0000000008037faeULL, 0x0003e2000f101c46ULL, 0x0000001016157824ULL, 0x100fe400078e0219ULL,
0x0000001018177824ULL, 0x100fe200078e0219ULL, 0x000000000a117faeULL, 0x0003e2000e901c46ULL,
0x000000101a197824ULL, 0x000fc400078e0219ULL, 0x000000ffff077224ULL, 0x000fe200010e0607ULL,
0x000000000c137faeULL, 0x0003e8000e101c46ULL, 0x000000000e157faeULL, 0x0003e8000d901c46ULL,
0x0000000004177faeULL, 0x0003e8000c901c46ULL, 0x0000000006197faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x004e640000000000ULL,
0x00000003ff047819ULL, 0x002fc80000011606ULL, 0x0000000404087810ULL, 0x040fe40007ffe0ffULL,
0x00000008040a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000608057212ULL, 0x0c0fe200078e3cffULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0x0000000c040c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080a107824ULL, 0x040fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0203ULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee205ULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x00000010040e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c117824ULL, 0x000fe200078e0203ULL,
0x000000060a057212ULL, 0x000fc400078e3cffULL, 0x000000060c077212ULL, 0x080fe200078e3cffULL,
0x000000080e147824ULL, 0x040fe200078e00ffULL, 0x000000060e097212ULL, 0x040fe200078e3cffULL,
0x000000010e157824ULL, 0x000fe200078e0203ULL, 0xfffffff8100f7812ULL, 0x000fe400078ee205ULL,
0x0000001404107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff812137812ULL, 0x000fe400078ee207ULL,
0xfffffff814177812ULL, 0x000fe200078ee209ULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x0000001804127810ULL, 0x000fe20007ffe0ffULL, 0x0000000110197824ULL, 0x000fe200078e0203ULL,
0x0000001c04147810ULL, 0x000fc40007ffe0ffULL, 0x0000000610057212ULL, 0x080fe200078e3cffULL,
0x0000000812187824ULL, 0x040fe200078e00ffULL, 0x0000000612077212ULL, 0x080fe200078e3cffULL,
0x00000008141a7824ULL, 0x040fe200078e00ffULL, 0x0000000614097212ULL, 0x000fe200078e3cffULL,
0x00000001121d7824ULL, 0x000fe200078e0203ULL, 0xfffffff8161b7812ULL, 0x000fe200078ee205ULL,
0x0000000114217824ULL, 0x000fe200078e0203ULL, 0x0000002004167810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8181f7812ULL, 0x000fc400078ee207ULL, 0xfffffff81a237812ULL, 0x000fe200078ee209ULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0x0000002404187810ULL, 0x040fe20007ffe0ffULL,
0x0000000103357824ULL, 0x040fe200078e0216ULL, 0x00000028041a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000616057212ULL, 0x080fe200078e3cffULL, 0x00000008181e7824ULL, 0x040fe200078e00ffULL,
0x0000000618077212ULL, 0x080fe200078e3cffULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0x000000061a097212ULL, 0x000fe200078e3cffULL, 0x0000000103397824ULL, 0x040fe200078e0218ULL,
0xfffffff81c377812ULL, 0x000fe200078ee205ULL, 0x00000001033d7824ULL, 0x000fe200078e021aULL,
0x0000002c041c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81e3b7812ULL, 0x000fe400078ee207ULL,
0xfffffff8203f7812ULL, 0x000fe200078ee209ULL, 0x000000081c227824ULL, 0x000fe200078e00ffULL,
0x00000030041e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103417824ULL, 0x040fe200078e021cULL,
0x0000003404207810ULL, 0x000fe40007ffe0ffULL, 0x000000061c057212ULL, 0x080fe200078e3cffULL,
0x000000081e247824ULL, 0x040fe200078e00ffULL, 0x000000061e077212ULL, 0x080fe200078e3cffULL,
0x0000000820267824ULL, 0x040fe200078e00ffULL, 0x0000000620097212ULL, 0x000fe200078e3cffULL,
0x0000000103457824ULL, 0x040fe200078e021eULL, 0xfffffff822437812ULL, 0x000fe200078ee205ULL,
0x0000001006057824ULL, 0x000fe200078e00ffULL, 0xfffffff824477812ULL, 0x000fe200078ee207ULL,
0x00000080ff227424ULL, 0x000fe200078e00ffULL, 0xfffffff8264b7812ULL, 0x000fe200078ee209ULL,
0x0000000108097824ULL, 0x000fe200078e0203ULL, 0x0000003804247810ULL, 0x040fe20007ffe0ffULL,
0x0000000103497824ULL, 0x000fe200078e0220ULL, 0x0000003c04267810ULL, 0x000fc40007ffe0ffULL,
0x0000007005257812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0203ULL,
0x0000000704077812ULL, 0x000fe200078e4806ULL, 0x00000001034d7824ULL, 0x000fe200078e0224ULL,
0x00001000510c7811ULL, 0x000fe200078e70ffULL, 0x0000000103557824ULL, 0x000fe200078e0226ULL,
0x0000000624037212ULL, 0x040fe200078e3cffULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef806ULL, 0x00005e0005047625ULL, 0x000fe200078e0022ULL,
0x0000000626067212ULL, 0x000fc400078e3cffULL, 0xfffffff8244f7812ULL, 0x000fe200078ee203ULL,
0x0000000826577824ULL, 0x000fe200078e00ffULL, 0x0000002504047210ULL, 0x000fe20007f1e0ffULL,
0x0000001007037824ULL, 0x100fe400078e020cULL, 0x000000100d277824ULL, 0x000fe200078e020cULL,
0xfffffff857577812ULL, 0x000fe200078ee206ULL, 0x00005e0009067625ULL, 0x000fc800078e0022ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000002506067210ULL, 0x000fe20007f1e0ffULL,
0x000000100f297824ULL, 0x100fe400078e020cULL, 0x00000010132b7824ULL, 0x100fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x00000010172d7824ULL, 0x100fe400078e020cULL, 0x000000101b2f7824ULL, 0x100fe400078e020cULL,
0x000000101f317824ULL, 0x000fc400078e020cULL, 0x0000001023337824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe400078e020cULL, 0x000000103b3b7824ULL, 0x100fe400078e020cULL,
0x000000103f3f7824ULL, 0x100fe400078e020cULL, 0x0000001043437824ULL, 0x100fe400078e020cULL,
0x0000001047477824ULL, 0x000fc400078e020cULL, 0x000000104b4b7824ULL, 0x100fe400078e020cULL,
0x000000104f4f7824ULL, 0x100fe400078e020cULL, 0x0000001057577824ULL, 0x000fe400078e020cULL,
0x00005e00150c7625ULL, 0x000fc800078e0022ULL, 0x00005e000b087625ULL, 0x000fc800078e0022ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000250c0c7210ULL, 0x080fe20007f1e0ffULL,
0x00005e00110a7625ULL, 0x080fe200078e0022ULL, 0x0000002508087210ULL, 0x080fe40007f3e0ffULL,
0x0000000006277faeULL, 0x0003e2000b901c46ULL, 0x00005e001d107625ULL, 0x000fe200078e0022ULL,
0x000000250a0a7210ULL, 0x000fc60007f5e0ffULL, 0x00005e00190e7625ULL, 0x000fc800078e0022ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000002510107210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000250e0e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0035147625ULL, 0x000fc600078e0022ULL, 0x0000000008297faeULL, 0x0003e2000b901c46ULL,
0x00005e0021127625ULL, 0x000fc800078e0022ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000002514147210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000002512127210ULL, 0x000fe20007f3e0ffULL, 0x00005e00411a7625ULL, 0x000fc800078e0022ULL,
0x00005e0039167625ULL, 0x000fc800078e0022ULL, 0x00005e003d187625ULL, 0x000fc800078e0022ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x000000251a1a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000002516167210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000002518187210ULL, 0x000fe20007f5e0ffULL,
0x00005e00451c7625ULL, 0x000fc600078e0022ULL, 0x000000000a2b7faeULL, 0x0003e2000b901c46ULL,
0x00005e00491e7625ULL, 0x000fc600078e0022ULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x00005e004d207625ULL, 0x000fc600078e0022ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0055227625ULL, 0x000fc600078e0022ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x000000251c1c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000251e1e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000002520207210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000002522227210ULL, 0x000fe20007f7e0ffULL,
0x0000000012337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400008e061fULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x0000000014377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc600018e0623ULL, 0x00000000163b7faeULL, 0x0003e8000b901c46ULL,
0x00000000183f7faeULL, 0x0003e8000b901c46ULL, 0x000000001a437faeULL, 0x0003e8000b901c46ULL,
0x000000001c477faeULL, 0x0003e8000b901c46ULL, 0x000000001e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000204f7faeULL, 0x0003e8000b901c46ULL, 0x0000000022577faeULL, 0x0003e4000b901c46ULL,
0x01b60400ff037984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000003ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01b60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000035100780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002051037824ULL, 0x002fc800078e0204ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000000f005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104067812ULL, 0x040fe400078efcffULL,
0x0000000704047812ULL, 0x100fe400078e7803ULL, 0x0000000706067812ULL, 0x000fc600078e7803ULL,
0x0000000104047824ULL, 0x000fe400078e0205ULL, 0x0000000105067824ULL, 0x000fc600078e0206ULL,
0x00000000040c7984ULL, 0x000e68000000cc00ULL, 0x0000000006087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01b60400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0022a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01b60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000004e5300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x3db504f330307820ULL, 0x020fe20000410000ULL,
0xffffffff4e327810ULL, 0x000fe20007ffe0ffULL, 0x0000001051317824ULL, 0x000fe200078e00ffULL,
0x00007610ff337816ULL, 0x000fe20000000033ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x0000010053377824ULL, 0x000fe200078e0200ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000375000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000030053357a10ULL, 0x000fe20007ffe0ffULL, 0x0000168000007945ULL, 0x000fe20003800000ULL,
0x0000000104347812ULL, 0x000fe400078e0cffULL, 0x0000000135057810ULL, 0x040fe20007ffe0ffULL,
0x0000010035077824ULL, 0x000fc600078e0200ULL, 0x0000004e0500720cULL, 0x000fe20003f06070ULL,
0x0000620002057a24ULL, 0x000fd800078e0207ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1e7819ULL, 0x004fe20000011603ULL, 0x00000002511d7824ULL, 0x000fe200078e0234ULL,
0x0000000750067217ULL, 0x000fe40007800000ULL, 0x000000041e0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000081e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001061c7824ULL, 0x000fe200078e0a07ULL,
0x000000030a087212ULL, 0x0c0fe200078e3cffULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x0000000c1e0e7810ULL, 0x040fe20007ffe0ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x000000101e127810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee208ULL, 0x000000011e087824ULL, 0x000fe200078e0205ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x000000080c207824ULL, 0x040fe200078e00ffULL,
0x000000030c0b7212ULL, 0x000fe200078e3cffULL, 0x00005e0008087625ULL, 0x000fe200078e0007ULL,
0x0000001c0a00720cULL, 0x000fc40003f86070ULL, 0x0000001c0c00720cULL, 0x000fe20003f46070ULL,
0x000000080e227824ULL, 0x000fe200078e00ffULL, 0x0000000608107210ULL, 0x000fe20007f1e0ffULL,
0x000000010a087824ULL, 0x100fe200078e0205ULL, 0x000000030e0d7212ULL, 0x080fe200078e3cffULL,
0x000000010c0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c0e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff117224ULL, 0x000fe200000e0609ULL, 0x00000003120f7212ULL, 0x000fe200078e3cffULL,
0x00005e0008087625ULL, 0x000fe200078e0007ULL, 0xfffffff820207812ULL, 0x000fc400078ee20bULL,
0x0000001c1200720cULL, 0x000fe20003f06070ULL, 0x000000010e0c7824ULL, 0x100fe200078e0205ULL,
0x000000141e187810ULL, 0x000fe20007ffe0ffULL, 0x0000000812247824ULL, 0x000fe200078e00ffULL,
0x000000181e287810ULL, 0x000fe20007ffe0ffULL, 0x00000001120e7824ULL, 0x000fe200078e0205ULL,
0x0000000608127210ULL, 0x080fe20007f3e0ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0007ULL,
0xfffffff822227812ULL, 0x000fe400078ee20dULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x000000ffff137224ULL, 0x000fe200008e0609ULL, 0x000000060a147210ULL, 0x000fe20007fbe0ffULL,
0x0000000118167824ULL, 0x000fe200078e0205ULL, 0x000000071e0a7812ULL, 0x000fe200078e4803ULL,
0x00005e000e087625ULL, 0x000fe200078e0007ULL, 0x0000001c1e2a7810ULL, 0x000fc40007ffe0ffULL,
0x000010001d1d7811ULL, 0x000fe200078e68ffULL, 0x00005e000c0c7625ULL, 0x080fe200078e0007ULL,
0x0ffffff80a0a7812ULL, 0x000fe400078ef803ULL, 0x000000201e2c7810ULL, 0x000fe20007ffe0ffULL,
0x00005e00160e7625ULL, 0x000fe200078e0007ULL, 0x000000060c0c7210ULL, 0x080fe40007f3e0ffULL,
0x0000000328237212ULL, 0x000fe200078e3cffULL, 0x000000ffff157224ULL, 0x000fe200028e060bULL,
0x0000000608167210ULL, 0x080fe20007fbe0ffULL, 0x0000000128087824ULL, 0x000fe200078e0205ULL,
0x000000060e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000001c1800720cULL, 0x080fe20003f26070ULL, 0x000000ffff177224ULL, 0x000fe200028e0609ULL,
0x0000001c1e00720cULL, 0x000fe20003fa6070ULL, 0x00005e0008087625ULL, 0x000fe200078e0007ULL,
0x00000003180b7212ULL, 0x000fc600078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe400030e060fULL,
0x0000000818267824ULL, 0x000fe200078e00ffULL, 0x0000000608187210ULL, 0x000fe20007fde0ffULL,
0x000000012a087824ULL, 0x000fe400078e0205ULL, 0x000000100a1f7824ULL, 0x000fe200078e021dULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x000000ffff197224ULL, 0x000fe400030e0609ULL,
0x00005e0008087625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0003e2000e901c46ULL, 0x0000001c2800720cULL, 0x000fc40003fa6070ULL,
0x000000101a217824ULL, 0x000fe200078e021dULL, 0x00000006081a7210ULL, 0x000fe20007fde0ffULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x000000032a087212ULL, 0x000fe200078e3cffULL,
0x000000012c0a7824ULL, 0x000fe200078e0205ULL, 0x0000000012217faeULL, 0x0005e2000e101c46ULL,
0x000000ffff1b7224ULL, 0x000fe200030e0609ULL, 0x0000001c2a00720cULL, 0x000fe20003f86070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x000000241e107810ULL, 0x002fc60007ffe0ffULL,
0x000000082a117824ULL, 0x000fe200078e00ffULL, 0x000000060a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010221f7824ULL, 0x100fe200078e021dULL, 0x000000381e227810ULL, 0x000fe20007ffe0ffULL,
0x0000001020137824ULL, 0x004fe200078e021dULL, 0xfffffff828127812ULL, 0x000fe200078ee223ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0xfffffff811287812ULL, 0x000fe200078ee208ULL,
0x0000000110087824ULL, 0x000fe200078e0205ULL, 0x0000000014137faeULL, 0x0003e2000d101c46ULL,
0x000000032c117212ULL, 0x000fe200078e3cffULL, 0x0000000810217824ULL, 0x040fe200078e00ffULL,
0x0000001c1000720cULL, 0x080fe20003f46070ULL, 0x000000000c1f7faeULL, 0x0005e2000d901c46ULL,
0x0000001c2c00720cULL, 0x000fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fe200078e0007ULL,
0x0000000310207212ULL, 0x000fc600078e3cffULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x0000000608107210ULL, 0x000fe20007fde0ffULL, 0x0000001024137824ULL, 0x102fe200078e021dULL,
0xfffffff821207812ULL, 0x000fe200078ee220ULL, 0x0000001028157824ULL, 0x000fe200078e021dULL,
0xfffffff82c087812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0x0000000016137faeULL, 0x0003e2000c101c46ULL, 0x0000001026097824ULL, 0x100fe200078e021dULL,
0x0000002c1e0c7810ULL, 0x004fe20007ffe0ffULL, 0x00000010081f7824ULL, 0x100fe200078e021dULL,
0x000000281e087810ULL, 0x000fe20007ffe0ffULL, 0x00000010120d7824ULL, 0x000fe200078e021dULL,
0x000000000e097faeULL, 0x0005e2000c901c46ULL, 0x000000301e127810ULL, 0x000fc40007ffe0ffULL,
0x0000001c0800720cULL, 0x080fe20003fc6070ULL, 0x00000000180d7faeULL, 0x0007e2000e901c46ULL,
0x0000001c0c00720cULL, 0x080fe20003fa6070ULL, 0x0000000808167824ULL, 0x002fe200078e00ffULL,
0x000000341e147810ULL, 0x040fe20007ffe0ffULL, 0x000000001a157faeULL, 0x0003e2000e101c46ULL,
0x0000003c1e1e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001c1200720cULL, 0x080fe20003f86070ULL,
0x00000010200f7824ULL, 0x004fe200078e021dULL, 0x0000000308097212ULL, 0x0c0fe200078e3cffULL,
0x0000000108087824ULL, 0x000fe200078e0205ULL, 0x000000000a1f7faeULL, 0x0005e2000d901c46ULL,
0x000000030c0d7212ULL, 0x048fe200078e3cffULL, 0x000000080c187824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e0007ULL,
0x00000000100f7faeULL, 0x0007e2000d101c46ULL, 0x0000001c1400720cULL, 0x000fc40003f66070ULL,
0x00000001120e7824ULL, 0x000fe200078e0205ULL, 0xfffffff818187812ULL, 0x000fe200078ee20dULL,
0x00000008121a7824ULL, 0x002fe200078e00ffULL, 0x0000001c2200720cULL, 0x000fe20003f26070ULL,
0x000000010c0a7824ULL, 0x004fe200078e0205ULL, 0x00000006080c7210ULL, 0x000fe20007f5e0ffULL,
0x000000081e157824ULL, 0x040fe200078e00ffULL, 0x0000001c1e00720cULL, 0x000fe20003f06070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x0000000314117212ULL, 0x088fe400078e3cffULL,
0x0000000312137212ULL, 0x000fe200078e3cffULL, 0x000000ffff0d7224ULL, 0x000fc400010e0609ULL,
0x00005e000e087625ULL, 0x080fe200078e0007ULL, 0x000000060a0e7210ULL, 0x080fe40007f5e0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL, 0x00000001140a7824ULL, 0x040fe400078e0205ULL,
0x00000008141c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060bULL,
0x0000000608107210ULL, 0x000fe20007f5e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0007ULL,
0xfffffff81c1c7812ULL, 0x000fc600078ee211ULL, 0x0000000122087824ULL, 0x000fe400078e0205ULL,
0x000000ffff117224ULL, 0x000fe200010e0609ULL, 0x000000060a127210ULL, 0x000fe20007f5e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0007ULL, 0x000000031e0a7212ULL, 0x000fc600078e3cffULL,
0x000000011e147824ULL, 0x000fe200078e0205ULL, 0x0000000322057212ULL, 0x000fe200078e3cffULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x0000000608087210ULL, 0x000fe20007f5e0ffULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0xfffffff815207812ULL, 0x000fe200078ee20aULL,
0x00005e00140a7625ULL, 0x000fc600078e0007ULL, 0xfffffff8221e7812ULL, 0x000fe200078ee205ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x000000060a067210ULL, 0x000fe20007f5e0ffULL,
0x0000001016057824ULL, 0x100fe400078e021dULL, 0x0000001018157824ULL, 0x100fe400078e021dULL,
0x000000101a177824ULL, 0x100fe200078e021dULL, 0x000000000c057faeULL, 0x0003e2000f101c46ULL,
0x000000101c197824ULL, 0x100fe400078e021dULL, 0x000000101e1b7824ULL, 0x100fe200078e021dULL,
0x000000000e157faeULL, 0x0003e2000e901c46ULL, 0x00000010201d7824ULL, 0x000fc400078e021dULL,
0x000000ffff077224ULL, 0x000fe200010e060bULL, 0x0000000010177faeULL, 0x0003e8000e101c46ULL,
0x0000000012197faeULL, 0x0003e8000d901c46ULL, 0x00000000081b7faeULL, 0x0003e8000c901c46ULL,
0x00000000061d7faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x004fe20000011603ULL, 0x00000080ff247424ULL, 0x000fc600078e00ffULL,
0x00000004060a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c06127810ULL, 0x040fe40007ffe0ffULL,
0x00000008060c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080a0e7824ULL, 0x040fe200078e00ffULL,
0x000000030a077212ULL, 0x080fe200078e3cffULL, 0x00000008120b7824ULL, 0x040fe200078e00ffULL,
0x0000000312087212ULL, 0x000fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x00000018061e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001120d7824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fc400078ee207ULL, 0x00000014061a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e157824ULL, 0x100fe200078e0205ULL, 0x000000030c077212ULL, 0x080fe400078e3cffULL,
0xfffffff80b147812ULL, 0x000fe200078ee208ULL, 0x000000081e0b7824ULL, 0x000fe200078e00ffULL,
0x0000001006167810ULL, 0x000fe20007ffe0ffULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0x000000031e087212ULL, 0x080fe200078e3cffULL, 0x000000011a137824ULL, 0x000fe200078e0205ULL,
0x00000024062c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x0000000116117824ULL, 0x100fe200078e0205ULL,
0x0000002006287810ULL, 0x000fe20007ffe0ffULL, 0x000000012c1b7824ULL, 0x000fe200078e0205ULL,
0x000000031a077212ULL, 0x000fc400078e3cffULL, 0xfffffff80b207812ULL, 0x000fe200078ee208ULL,
0x000000082c0b7824ULL, 0x000fe200078e00ffULL, 0x0000001c06227810ULL, 0x000fe20007ffe0ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x0000000316097212ULL, 0x080fe200078e3cffULL,
0x0000000128197824ULL, 0x000fe200078e0205ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0x000000032c087212ULL, 0x000fe200078e3cffULL,
0x0000000122177824ULL, 0x000fe200078e0205ULL, 0x0000002c063a7810ULL, 0x000fc40007ffe0ffULL,
0x00000030063e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000328077212ULL, 0x080fe200078e3cffULL,
0x000000083a3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x000000013a1f7824ULL, 0x100fe200078e0205ULL, 0x0000002806367810ULL, 0x000fe20007ffe0ffULL,
0x000000013e217824ULL, 0x040fe200078e0205ULL, 0xfffffff80b2e7812ULL, 0x000fe200078ee208ULL,
0x000000083e0b7824ULL, 0x000fe200078e00ffULL, 0x0000000322097212ULL, 0x080fe200078e3cffULL,
0x0000000836387824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee207ULL,
0x00000001361d7824ULL, 0x000fe200078e0205ULL, 0x000000033a077212ULL, 0x000fc400078e3cffULL,
0x000000033e087212ULL, 0x080fe400078e3cffULL, 0xfffffff826267812ULL, 0x000fe400078ee209ULL,
0x0000003406427810ULL, 0x000fe40007ffe0ffULL, 0x0000000336097212ULL, 0x080fe400078e3cffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0xfffffff80b407812ULL, 0x000fe200078ee208ULL, 0x0000000251087824ULL, 0x000fe200078e0234ULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x0000000842447824ULL, 0x040fe200078e00ffULL,
0x0000000342097212ULL, 0x000fe200078e3cffULL, 0x000000010c0b7824ULL, 0x100fe200078e0205ULL,
0x0000003806467810ULL, 0x000fe20007ffe0ffULL, 0x0000000142237824ULL, 0x000fe200078e0205ULL,
0x0000003c06487810ULL, 0x000fe20007ffe0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0024ULL,
0x0000007007277812ULL, 0x000fc400078ec0ffULL, 0x00001000080f7811ULL, 0x000fe200078e68ffULL,
0x0000000106077824ULL, 0x040fe200078e0205ULL, 0x0000000706087812ULL, 0x000fe200078e4803ULL,
0x0000000146257824ULL, 0x000fe200078e0205ULL, 0xfffffff844447812ULL, 0x000fe200078ee209ULL,
0x000000010a097824ULL, 0x000fe200078e0205ULL, 0x0ffffff808087812ULL, 0x000fe200078ef803ULL,
0x00000001484d7824ULL, 0x000fe200078e0205ULL, 0x0000000346057212ULL, 0x0c0fe200078e3cffULL,
0x0000000846127824ULL, 0x000fe200078e00ffULL, 0x00000003480a7212ULL, 0x000fe200078e3cffULL,
0x00005e0007067625ULL, 0x000fe200078e0024ULL, 0x000000270c0c7210ULL, 0x000fc40007f5e0ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000000848297824ULL, 0x000fe200078e00ffULL,
0x0000002706067210ULL, 0x000fe20007f1e0ffULL, 0x0000001008057824ULL, 0x000fe400078e020fULL,
0x00005e0009087625ULL, 0x000fe200078e0024ULL, 0xfffffff829167812ULL, 0x000fc600078ee20aULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000002708087210ULL, 0x000fe20007f1e0ffULL,
0x000000100e297824ULL, 0x100fe400078e020fULL, 0x00000010102b7824ULL, 0x100fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x00000010142d7824ULL, 0x100fe400078e020fULL, 0x00000010182f7824ULL, 0x100fe400078e020fULL,
0x000000101c397824ULL, 0x000fc400078e020fULL, 0x00000010203b7824ULL, 0x100fe400078e020fULL,
0x00000010263d7824ULL, 0x100fe400078e020fULL, 0x000000102a3f7824ULL, 0x100fe400078e020fULL,
0x000000102e417824ULL, 0x100fe400078e020fULL, 0x0000001038437824ULL, 0x100fe400078e020fULL,
0x000000103c457824ULL, 0x000fc400078e020fULL, 0x0000001040477824ULL, 0x100fe400078e020fULL,
0x0000001044497824ULL, 0x100fe400078e020fULL, 0x00000010124b7824ULL, 0x100fe400078e020fULL,
0x00000010164f7824ULL, 0x000fe400078e020fULL, 0x00005e00110e7625ULL, 0x000fc800078e0024ULL,
0x00005e000b0a7625ULL, 0x000fc800078e0024ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x000000270e0e7210ULL, 0x080fe20007f1e0ffULL, 0x00005e0013107625ULL, 0x080fe200078e0024ULL,
0x000000270a0a7210ULL, 0x000fe40007f3e0ffULL, 0x0000000008297faeULL, 0x0003e2000b901c46ULL,
0x00005e0015127625ULL, 0x000fc800078e0024ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000002712127210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002710107210ULL, 0x000fe20007f3e0ffULL, 0x00005e0017147625ULL, 0x000fc600078e0024ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0019167625ULL, 0x000fc800078e0024ULL,
0x00005e001b187625ULL, 0x000fc800078e0024ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000002716167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000002714147210ULL, 0x000fe20007f3e0ffULL, 0x00005e001d1a7625ULL, 0x000fc800078e0024ULL,
0x00005e001f1c7625ULL, 0x000fc800078e0024ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000271c1c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000002718187210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000271a1a7210ULL, 0x000fe20007f5e0ffULL, 0x00005e00211e7625ULL, 0x000fc600078e0024ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c46ULL, 0x00005e0023207625ULL, 0x000fc600078e0024ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x00005e0025227625ULL, 0x000fc600078e0024ULL,
0x0000000010397faeULL, 0x0003e2000b901c46ULL, 0x00005e004d247625ULL, 0x000fc600078e0024ULL,
0x00000000123b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x000000271e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000002720207210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000002722227210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000002724247210ULL, 0x000fe20007f7e0ffULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fc400008e0621ULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x00000000163f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc600018e0625ULL,
0x0000000018417faeULL, 0x0003e8000b901c46ULL, 0x000000001a437faeULL, 0x0003e8000b901c46ULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x0000000020497faeULL, 0x0003e8000b901c46ULL, 0x00000000224b7faeULL, 0x0003e8000b901c46ULL,
0x00000000244f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003367810ULL, 0x000fe20007ffe0ffULL,
0x00000002513c7824ULL, 0x000fe200078e0204ULL, 0x00000007031c7812ULL, 0x042fe200078ec0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0xfffffff8033a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0xfffffff836367812ULL, 0x000fe200078ec0ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000010003c3c7811ULL, 0x000fe200078e68ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000081c3b7812ULL, 0x100fe400078ef803ULL,
0x000000073a3a7812ULL, 0x100fe400078ef803ULL, 0x0000000736367812ULL, 0x000fe400078ef803ULL,
0x00000007391d7812ULL, 0x040fe200078e783aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000739297812ULL, 0x040fe400078e7836ULL, 0x00000001393f7810ULL, 0x000fe20007ffe0ffULL,
0x000000083a1d7824ULL, 0x000fe200078e021dULL, 0x0000003803787211ULL, 0x000fe200078fe0ffULL,
0x0000000836297824ULL, 0x000fe200078e0229ULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e023cULL, 0x0000000438387810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e023cULL, 0x000000083900780cULL, 0x000fc60003f05270ULL,
0x000000001d1c783bULL, 0x000e680000000200ULL, 0x000000002928783bULL, 0x000ea20000000200ULL,
0x00000018ff597819ULL, 0x002fe2000001141dULL, 0x000100001d2d7824ULL, 0x040fe200078e00ffULL,
0x000088801d6c7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001141fULL, 0x000100001c2c7824ULL, 0x000fe200078e00ffULL,
0x000088801f677816ULL, 0x000fe200000000ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff647819ULL, 0x000fe2000001141cULL,
0x0000001d00767306ULL, 0x0003e20000200c00ULL, 0x000088801c6b7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x004fe40000011428ULL,
0x0000888028637816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000002c00747306ULL, 0x000fe20000200c00ULL, 0x000100001f1d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011429ULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888029617816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000002d006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fc4000001142aULL, 0x00000018ff3d7819ULL, 0x000fe4000001142bULL,
0x000088802a5d7816ULL, 0x000fe400000000ffULL, 0x000088802b4b7816ULL, 0x000fe200000000ffULL,
0x0000001d006e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff527819ULL, 0x000fe4000001141eULL,
0x000088801e697816ULL, 0x000fca00000000ffULL, 0x0000001f00707306ULL, 0x0005e20000200c00ULL,
0x000000073f1d7812ULL, 0x042fe400078e783aULL, 0x000000073f3f7812ULL, 0x000fca00078e7836ULL,
0x0000001c00717306ULL, 0x0003e20000200c00ULL, 0x000000083a1f7824ULL, 0x004fe400078e021dULL,
0x00010000291d7824ULL, 0x000fe400078e00ffULL, 0x000000101f1f7824ULL, 0x000fe400078e023cULL,
0x0000010029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000100001e1c7824ULL, 0x042fe200078e00ffULL, 0x000000001f2c783bULL, 0x000e620000000200ULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x00000008363f7824ULL, 0x000fe200078e023fULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001d00667306ULL, 0x000fe20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001c00727306ULL, 0x0005f00000200c00ULL, 0x0000002900657306ULL, 0x000fe20000200c00ULL,
0x00010000281c7824ULL, 0x044fe400078e00ffULL, 0x0000010028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000001e006d7306ULL, 0x0005f00000200c00ULL, 0x00000028006a7306ULL, 0x0007e20000200c00ULL,
0x000000103f1e7824ULL, 0x004fe200078e023cULL, 0x00000018ff467819ULL, 0x002fe2000001142cULL,
0x000100002d297824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fc4000001142dULL,
0x000088802c3f7816ULL, 0x000fe400000000ffULL, 0x0000001c00687306ULL, 0x0003e20000200c00ULL,
0x000100002b287824ULL, 0x048fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011429ULL,
0x000001002b2b7824ULL, 0x000fe200078e00ffULL, 0x000088802d4a7816ULL, 0x040fe200000000ffULL,
0x000001002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a1c7824ULL, 0x042fe200078e00ffULL,
0x0000002800547306ULL, 0x0003e20000200c00ULL, 0x000001002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x00000018ff607819ULL, 0x000fe4000001141cULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000000001e1c783bULL, 0x000ea20000000200ULL,
0x0000002b00567306ULL, 0x000fe20000200c00ULL, 0x000100002c287824ULL, 0x042fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe2000001142eULL, 0x000001002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe4000001142fULL, 0x00000018ff487819ULL, 0x000fc40000011428ULL,
0x0000000778287812ULL, 0x100fe200078e783bULL, 0x0000002a00627306ULL, 0x0003e20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x000088802e577816ULL, 0x000fe200000000ffULL,
0x000000103b287824ULL, 0x000fe200078e0228ULL, 0x000088802f5a7816ULL, 0x000fe400000000ffULL,
0x0000000278787810ULL, 0x000fe20007ffe0ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x0000006400647306ULL, 0x000fe40000200c00ULL, 0x0000000778787812ULL, 0x000fc600078e783bULL,
0x000000002828783bULL, 0x002e640000000200ULL, 0x000000103b787824ULL, 0x000fe200078e0278ULL,
0x0000006b006b7306ULL, 0x000ef00000200c00ULL, 0x0000002c00497306ULL, 0x0009e20000200c00ULL,
0x00000018ff427819ULL, 0x004fc4000001141cULL, 0x00000018ff417819ULL, 0x000fca000001141dULL,
0x0000002d00587306ULL, 0x0005e20000200c00ULL, 0x000100002e2c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001141fULL, 0x000001002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe4000001141eULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006c006c7306ULL, 0x000f220000200c00ULL, 0x000100002f2d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000001002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002c005c7306ULL, 0x0007e20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fce000001142fULL, 0x0000002d005f7306ULL, 0x0005e20000200c00ULL,
0x000054106b2c7816ULL, 0x008fce0000000074ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00005410712d7816ULL, 0x004fe20000000064ULL, 0x000100001c647824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000002c2824723cULL, 0x002fee0000001824ULL, 0x000054106c2c7816ULL, 0x010fe2000000006fULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x00005410762d7816ULL, 0x000fce0000000059ULL,
0x0000006700677306ULL, 0x000ee20000200c00ULL, 0x0000002c2820723cULL, 0x000fee0000001820ULL,
0x00005410692c7816ULL, 0x004fe20000000072ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000054106d2d7816ULL, 0x000fc40000000052ULL, 0x000088801d697816ULL, 0x000fe400000000ffULL,
0x0000541065657816ULL, 0x002fe4000000004cULL, 0x00005410676e7816ULL, 0x008fe2000000006eULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000002c2804723cULL, 0x000fe20000001804ULL,
0x000088801e4c7816ULL, 0x000fcc00000000ffULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000010782c7824ULL, 0x000fe200078e00ffULL, 0x00005410706f7816ULL, 0x004fe2000000004fULL,
0x000000ffff4f7224ULL, 0x000fca00078e0069ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0000006e2808723cULL, 0x000fee0000001808ULL, 0x0000003d003d7306ULL, 0x000eb00000200c00ULL,
0x0000006300637306ULL, 0x000ee20000200c00ULL, 0x000054106a697816ULL, 0x002fce000000004dULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00005410564d7816ULL, 0x004fce000000003dULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000541063687816ULL, 0x008fce0000000068ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00000068280c723cULL, 0x000fee000000180cULL,
0x0000002e005b7306ULL, 0x0005e20000200c00ULL, 0x000054105d607816ULL, 0x002fe20000000060ULL,
0x000100001e5d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000002f005e7306ULL, 0x0003e20000200c00ULL, 0x000088801c2e7816ULL, 0x004fce00000000ffULL,
0x0000002e00597306ULL, 0x0005e20000200c00ULL, 0x000001001c2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001142fULL, 0x00000064001c7306ULL, 0x0002e20000200c00ULL,
0x000000002c2c783bULL, 0x004eae0000000200ULL, 0x0000005200677306ULL, 0x000fe20000200c00ULL,
0x000100001d647824ULL, 0x002fc400078e00ffULL, 0x000001001d1d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x00005410591c7816ULL, 0x008fce000000001cULL,
0x0000006400527306ULL, 0x0007f00000200c00ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541061647816ULL, 0x008fe40000000066ULL, 0x0000541062617816ULL, 0x000fe20000000047ULL,
0x000000ffff477224ULL, 0x000fe200078e004cULL, 0x000054104b4c7816ULL, 0x000fc60000000054ULL,
0x000000642810723cULL, 0x040fe20000001810ULL, 0x0000001d00667306ULL, 0x0007ee0000200c00ULL,
0x000000602814723cULL, 0x000fe20000001814ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000001001e1d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000004c2818723cULL, 0x000fe20000001818ULL, 0x0000004600467306ULL, 0x000eec0000200c00ULL,
0x000088801f287816ULL, 0x040fe200000000ffULL, 0x000100001f2a7824ULL, 0x040fe200078e00ffULL,
0x0000001d00297306ULL, 0x0003e20000200c00ULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000004500457306ULL, 0x000f220000200c00ULL, 0x00005410671d7816ULL, 0x002fe40000000042ULL,
0x0000541049497816ULL, 0x008fca0000000046ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000001c2c0c723cULL, 0x004fee000000180cULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x00005410584b7816ULL, 0x010fce0000000045ULL, 0x0000003e003e7306ULL, 0x000ff00000200c00ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x00005410661d7816ULL, 0x002fce0000000041ULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054103f487816ULL, 0x002fce0000000048ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x000000482c24723cULL, 0x000fee0000001824ULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x000054104a4a7816ULL, 0x004fce0000000055ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x00005410575c7816ULL, 0x002fe2000000005cULL,
0x0000004a2c20723cULL, 0x000fec0000001820ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054105a5a7816ULL, 0x008fce000000005fULL, 0x0000005d001e7306ULL, 0x0002e20000200c00ULL,
0x000054104f1c7816ULL, 0x004fce0000000052ULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x000054105b5d7816ULL, 0x002fe20000000044ULL, 0x0000001c2c10723cULL, 0x000fe20000001810ULL,
0x000054105e5b7816ULL, 0x000fca0000000043ULL, 0x0000002a002b7306ULL, 0x000e620000200c00ULL,
0x00005410471e7816ULL, 0x008fe2000000001eULL, 0x0000005c2c04723cULL, 0x040fec0000001804ULL,
0x0000001f003d7306ULL, 0x0004e40000200c00ULL, 0x0000005a2c08723cULL, 0x000fe20000001808ULL,
0x0000541028287816ULL, 0x002fc4000000002bULL, 0x00005410291f7816ULL, 0x004fe40000000040ULL,
0x000054103d297816ULL, 0x008fca000000003eULL, 0x0000001e2c14723cULL, 0x040ff00000001814ULL,
0x000000282c18723cULL, 0x000fe20000001818ULL, 0xfffff0e000000947ULL, 0x000fee000383ffffULL,
0x01b61400311d7984ULL, 0x000e620000000800ULL, 0x0000002530297220ULL, 0x000fc40000410000ULL,
0x0000000430257220ULL, 0x040fe20000410000ULL, 0x0000ffff33047812ULL, 0x000fe200078ec0ffULL,
0x00000024302b7220ULL, 0x040fe40000410000ULL, 0x00000022302c7220ULL, 0x000fe20000410000ULL,
0x0000888004367816ULL, 0x000fe200000000ffULL, 0x00000023302d7220ULL, 0x040fe40000410000ULL,
0x0000000530247220ULL, 0x000fe40000410000ULL, 0x8000000036047824ULL, 0x000fc400078e00ffULL,
0x0000000830237220ULL, 0x040fe40000410000ULL, 0x0000000930227220ULL, 0x040fe40000410000ULL,
0x0000001230127220ULL, 0x040fe40000410000ULL, 0x0000001430147220ULL, 0x040fe40000410000ULL,
0x0000001830187220ULL, 0x040fe40000410000ULL, 0x0000002630267220ULL, 0x000fc40000410000ULL,
0x00000027302a7220ULL, 0x040fe40000410000ULL, 0x0000000630067220ULL, 0x040fe40000410000ULL,
0x0000000730077220ULL, 0x040fe40000410000ULL, 0x0000000a300a7220ULL, 0x040fe40000410000ULL,
0x0000000b300b7220ULL, 0x040fe40000410000ULL, 0x0000000e30057220ULL, 0x000fc40000410000ULL,
0x0000000f30087220ULL, 0x040fe20000410000ULL, 0x800000001dff7812ULL, 0x002fe20007804804ULL,
0x0000001330097220ULL, 0x040fe40000410000ULL, 0x0000002030287220ULL, 0x040fe40000410000ULL,
0x0000002130277220ULL, 0x040fe40000410000ULL, 0x00000010301f7220ULL, 0x040fe40000410000ULL,
0x00000011301e7220ULL, 0x000fc40000410000ULL, 0x0000001b302f7220ULL, 0x040fe40000410000ULL,
0x0000000c30217220ULL, 0x040fe40000410000ULL, 0x0000000d30207220ULL, 0x040fe40000410000ULL,
0x00000015301c7220ULL, 0x040fe40000410000ULL, 0x0000001630117220ULL, 0x040fe40000410000ULL,
0x0000001730107220ULL, 0x000fc40000410000ULL, 0x0000001a302e7220ULL, 0x040fe40000410000ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0014ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0018ULL,
0x000000ffff137224ULL, 0x000fe400078e0012ULL, 0x0000001930197220ULL, 0x000fe40000410000ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0026ULL, 0x000000ffff187224ULL, 0x000fe400078e002aULL,
0x000000ffff177224ULL, 0x000fe400078e002cULL, 0x000000ffff0f7224ULL, 0x000fe400078e002dULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0007ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000aULL, 0x000000ffff167224ULL, 0x000fe400078e000bULL,
0x000000ffff157224ULL, 0x000fe400078e0005ULL, 0x000000ffff147224ULL, 0x000fe400078e0008ULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e002eULL,
0x000000ffff0a7224ULL, 0x000fe200078e002fULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000036367824ULL, 0x000fe400078e00ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01b6140031057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804836ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403087824ULL, 0x000fe200078e00ffULL, 0x000000325300720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff008047812ULL, 0x000fca00078ec0ffULL,
0x0000008051097824ULL, 0x000fca00078e0204ULL, 0x01b4000009047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203267824ULL, 0x000fe400078e00ffULL,
0x0000000150377824ULL, 0x000fc600078e0a37ULL, 0x0000000626267812ULL, 0x000fc800078ec0ffULL,
0x00000001262a7812ULL, 0x040fe400078efcffULL, 0x00000008262c7812ULL, 0x000fe400078efcffULL,
0x000000372a00720cULL, 0x080fe40003f26070ULL, 0x00000010262a7812ULL, 0x000fe400078efcffULL,
0x000000372c00720cULL, 0x080fe40003f06070ULL, 0x000000372a00720cULL, 0x000fc40003fc6070ULL,
0x00000011262c7812ULL, 0x040fe400078efcffULL, 0x00000018262a7812ULL, 0x040fe400078efcffULL,
0x000000372600720cULL, 0x080fe40003f46070ULL, 0x000000372c00720cULL, 0x080fe40003fa6070ULL,
0x000000372a00720cULL, 0x000fe40003f66070ULL, 0x00000009262e7812ULL, 0x000fc400078efcffULL,
0x00000019262c7812ULL, 0x040fe400078efcffULL, 0x00000020262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40004800000ULL, 0xff7fffff29297808ULL, 0x000fc40004800000ULL,
0x000000372e00720cULL, 0x080fe40003f86070ULL, 0x000000372c00720cULL, 0x080fe40003f46070ULL,
0x000000372a00720cULL, 0x000fe40003f26070ULL, 0x00000021262c7812ULL, 0x040fe400078efcffULL,
0x00000028262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff17177808ULL, 0x000fc40004000000ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0x000000372c00720cULL, 0x080fe40003f06070ULL,
0x000000372a00720cULL, 0x000fe40003f86070ULL, 0x00000029262c7812ULL, 0x000fc400078efcffULL,
0x00000030262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006800000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0x000000372c00720cULL, 0x000fc40003fc6070ULL,
0x000000372a00720cULL, 0x000fe40003fa6070ULL, 0x00000031262c7812ULL, 0x040fe400078efcffULL,
0x00000038262a7812ULL, 0x040fe400078efcffULL, 0x0000003926267812ULL, 0x000fe400078efcffULL,
0xff7fffff0c0c7808ULL, 0x000fe40005800000ULL, 0xff7fffff23237808ULL, 0x000fc40005800000ULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0x000000372c00720cULL, 0x080fe40003f66070ULL, 0x000000372a00720cULL, 0x000fc40003f46070ULL,
0x000000372600720cULL, 0x000fe40003f26070ULL, 0xff7fffff14147808ULL, 0x000fe40004000000ULL,
0xff7fffff20207808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40006000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff12127808ULL, 0x000fc40007000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL, 0xff7fffff11117808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0xff7fffff10107808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002b04047209ULL, 0x004fe40007810000ULL, 0x0000001a052d7209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x000000182d047209ULL, 0x000fc40007810000ULL,
0x0000002805267209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000002726267209ULL, 0x000fe40007810000ULL, 0x0000000f04057209ULL, 0x000fe40007810000ULL,
0x00000025262d7209ULL, 0x000fe40007810000ULL, 0x0000000e05047209ULL, 0x000fc40007810000ULL,
0x000000242d267209ULL, 0x000fe40007810000ULL, 0x0000000d04057209ULL, 0x000fe40007810000ULL,
0x00000023262d7209ULL, 0x000fe40007810000ULL, 0x0000000c05057209ULL, 0x000fe40007810000ULL,
0x000000222d047209ULL, 0x000fe40007810000ULL, 0x0000001605267209ULL, 0x000fc40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x00000015262d7209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x000000142d267209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x00000013262d7209ULL, 0x000fc40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x000000122d267209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x00000011262d7209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x000000102d267209ULL, 0x000fc40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000000b26057209ULL, 0x000fe40007810000ULL,
0x00000019042a7209ULL, 0x000fe40007810000ULL, 0x0000000a052e7209ULL, 0x000fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f002a047f89ULL, 0x0004e400000e0000ULL,
0x000000042a367209ULL, 0x008fe20007810000ULL, 0x00000ed27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002e047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007267f89ULL, 0x000f6200000e0000ULL, 0x000000042e2a7209ULL, 0x00efc60007810000ULL,
0x0c201f0036047f89ULL, 0x000e6200000e0000ULL, 0x00000005062c7209ULL, 0x010fc60007810000ULL,
0x0c201f002a057f89ULL, 0x000ea200000e0000ULL, 0x0000002607267209ULL, 0x020fc60007810000ULL,
0x0c201f002c2d7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00262f7f89ULL, 0x00092200000e0000ULL,
0x0000000436047209ULL, 0x002fe40007810000ULL, 0x000000052a057209ULL, 0x004fe40007810000ULL,
0x0000002d2c067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b042a7820ULL, 0x002fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001082aULL,
0x00000029002c7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b19197823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe2000001082aULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b05297820ULL, 0x002fc40000410000ULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010829ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0f2e7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b18187823ULL, 0x000fe40000010829ULL, 0x3fb8aa3b24247823ULL, 0x000fc4000001082aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b20207823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL,
0x00000018002d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fc4000001082aULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe4000001082aULL,
0x3fb8aa3b0c387823ULL, 0x100fe20000010829ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000002b2c0c723eULL, 0x008fe200000000ffULL, 0x3c003c00ff2c7424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b0b0b7823ULL, 0x000fc40000010829ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fce0000010829ULL,
0x0000002e002e7308ULL, 0x000ef00000000800ULL, 0x00000019002a7308ULL, 0x000bf00000000800ULL,
0x0000001b00077308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b0d197823ULL, 0x120fe20000010829ULL,
0x0000001a2d0d723eULL, 0x002fe200000000ffULL, 0x3c003c00ff2d7424ULL, 0x000fe200078e00ffULL,
0x000000172e0f723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b16177823ULL, 0x000fc60000010829ULL,
0x0000001900377308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e1b7823ULL, 0x110fe20000010829ULL,
0x00000028270e723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b15277823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b14287823ULL, 0x000fc60000010829ULL, 0x0000001b00367308ULL, 0x0002f00000000800ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000002c0c18723cULL, 0x002fee00000018ffULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x000000363715723eULL, 0x008fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x000000252414723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b10247823ULL, 0x000fcc0000010829ULL,
0x0000003800387308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000232216723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b12227823ULL, 0x000fc40000010829ULL,
0x3fb8aa3b11237823ULL, 0x000fc80000010829ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000381717723eULL, 0x002fce00000000ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x0000002c1418723cULL, 0x000fee0000001818ULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ee20000000800ULL, 0x000000212010723eULL, 0x002fce00000000ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000001f1e12723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x000000272811723eULL, 0x002fce00000000ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x000000132213723eULL, 0x008fce00000000ffULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x0000002c1038723cULL, 0x000fee0000001818ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc03187812ULL, 0x000fcc00078ec0ffULL, 0x0000002400247308ULL, 0x000ee20000000800ULL,
0x000000072a1a723eULL, 0x000fe400000000ffULL, 0x0000001819207219ULL, 0x000fe400000006ffULL,
0x0000001d1c18723eULL, 0x002fe400000000ffULL, 0x00000000201f73a1ULL, 0x000e6200000e8000ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x00000000200473c4ULL, 0x000f220000004000ULL,
0x000000262f077209ULL, 0x004fcc0007810000ULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x000000232419723eULL, 0x008fe400000000ffULL, 0x0000000520ff7c12ULL, 0x002fe4000f80401fULL,
0x0000000b0a1b723eULL, 0x004fce00000000ffULL, 0x0000002c1828723cULL, 0x000fe80000001838ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000ae204008947ULL, 0x010fde000b800000ULL,
0x001c1fff281c7589ULL, 0x0002a400000e0000ULL, 0x00000000200b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000520ff7c12ULL, 0x008fda000f80400bULL, 0x00000b0204008947ULL, 0x010fea000b800000ULL,
0x001c1fff2a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff0a7819ULL, 0x000fe40000011603ULL,
0x0000000c083b7812ULL, 0x000fc400078ec0ffULL, 0x000000070a0b7812ULL, 0x040fe200078ec0ffULL,
0x000000080a247824ULL, 0x040fe200078e00ffULL, 0x0000000aff227212ULL, 0x000fe200078e33ffULL,
0x000000080a207824ULL, 0x04afe200078e00ffULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080a2d7824ULL, 0x040fe200078e00ffULL, 0x000000080a0a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824217812ULL, 0x100fe400078ee20bULL, 0x0000000120237812ULL, 0x100fe200078ef60bULL,
0x000000080a477824ULL, 0x000fe200078e00ffULL, 0x0000000220257812ULL, 0x100fe200078ef60bULL,
0x000000080a2f7824ULL, 0x000fe200078e00ffULL, 0x0000000320277812ULL, 0x100fe200078ef60bULL,
0x000000080a377824ULL, 0x000fe200078e00ffULL, 0x0000000420297812ULL, 0x000fc400078ef60bULL,
0x00000005202b7812ULL, 0x140fe400078ef60bULL, 0x00000006200b7812ULL, 0x000fe400078ef60bULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL, 0x0000000aff227212ULL, 0x000fe400078e33ffULL,
0x000000070a207812ULL, 0x000fe400078ec0ffULL, 0x00011000510a7811ULL, 0x000fc400078e58ffULL,
0xfffffff82f2f7812ULL, 0x100fe400078ee220ULL, 0x0000000137397812ULL, 0x000fe200078ef620ULL,
0x0000001021087824ULL, 0x000fe200078e020aULL, 0x00000002373d7812ULL, 0x000fe200078ef620ULL,
0x0000001027247824ULL, 0x000fe200078e020aULL, 0x00000003373f7812ULL, 0x000fe200078ef620ULL,
0x000000100b2a7824ULL, 0x000fe200078e020aULL, 0x0000000437417812ULL, 0x000fe200078ef620ULL,
0x0000001029267824ULL, 0x000fe200078e020aULL, 0x0000000537437812ULL, 0x000fe200078ef620ULL,
0x000000013b0b7824ULL, 0x000fe200078e0208ULL, 0x0000000637457812ULL, 0x000fe200078ef620ULL,
0x0000001023207824ULL, 0x000fe200078e020aULL, 0xfffffff847477812ULL, 0x000fe200078ee222ULL,
0x0000001025227824ULL, 0x100fe200078e020aULL, 0x0000000c0b007388ULL, 0x0003e20000000800ULL,
0x000000102b287824ULL, 0x000fc400078e020aULL, 0x000000013b217824ULL, 0x040fe400078e0220ULL,
0x000000013b237824ULL, 0x000fe400078e0222ULL, 0x000000102d2c7824ULL, 0x000fe200078e020aULL,
0x0000000e21007388ULL, 0x0007e20000000800ULL, 0x000000013b257824ULL, 0x000fe400078e0224ULL,
0x000000102f087824ULL, 0x000fe200078e020aULL, 0x0000001423007388ULL, 0x0007e20000000800ULL,
0x000000013b277824ULL, 0x000fc400078e0226ULL, 0x00000010392e7824ULL, 0x000fe200078e020aULL,
0x0000001625007388ULL, 0x0007e20000000800ULL, 0x000000013b297824ULL, 0x000fe400078e0228ULL,
0x000000103d2f7824ULL, 0x000fe200078e020aULL, 0x0000001027007388ULL, 0x0007e20000000800ULL,
0x000000013b2b7824ULL, 0x000fe400078e022aULL, 0x000000103f367824ULL, 0x000fe200078e020aULL,
0x0000001229007388ULL, 0x0007e20000000800ULL, 0x000000013b2d7824ULL, 0x000fc400078e022cULL,
0x0000001041377824ULL, 0x000fe200078e020aULL, 0x000000182b007388ULL, 0x0007e20000000800ULL,
0x000000013b087824ULL, 0x000fe400078e0208ULL, 0x0000001043387824ULL, 0x100fe200078e020aULL,
0x0000001a2d007388ULL, 0x0007e20000000800ULL, 0x0000001045397824ULL, 0x100fe400078e020aULL,
0x00000010473a7824ULL, 0x000fe200078e020aULL, 0x0000000d08007388ULL, 0x0007e20000000800ULL,
0x000000013b2e7824ULL, 0x000fc400078e022eULL, 0x000000013b0a7824ULL, 0x040fe400078e022fULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x0000000f2e007388ULL, 0x0007e20000000800ULL,
0x000000013b0c7824ULL, 0x042fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x000000150a007388ULL, 0x0007e20000000800ULL, 0x000000013b207824ULL, 0x040fe400078e0239ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000001736007388ULL, 0x0007e80000000800ULL,
0x000000110c007388ULL, 0x0007e80000000800ULL, 0x0000001338007388ULL, 0x0007e80000000800ULL,
0x0000001920007388ULL, 0x0007e80000000800ULL, 0x0000001b3a007388ULL, 0x0007e80000000800ULL,
0x01b0000409008388ULL, 0x0007e80000000c00ULL, 0x01b2001c09008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004e3500720cULL, 0x000fe20003f26070ULL,
0x01b6080031ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff33ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff537224ULL, 0x000fc400078e0035ULL, 0x000000ffff047224ULL, 0x008fe200078e0034ULL,
0x00000001ff337807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffbfd000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e002cULL, 0x00011290002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0036ULL,
0xffff913000007947ULL, 0x000fea000383ffffULL, 0x000000ffff387224ULL, 0x002fe200078e002bULL,
0x00011300002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e0036ULL, 0xffff90e000007947ULL, 0x000fea000383ffffULL,
0x00000002ff2f7424ULL, 0x000fe200078e00ffULL, 0x00011370002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000068000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002fULL,
0xfffff11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x006fe200078e002eULL,
0x000113f0002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000060000007944ULL, 0x000fea0003c00000ULL, 0x0000002f2e2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0006ULL, 0x00011460002c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000059000007944ULL, 0x000fea0003c00000ULL,
0x0000002f06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0007ULL,
0x000114d0002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x0000002f07267209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0036ULL, 0x00011540002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x0000002f36047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e002eULL,
0x000115b0002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000002f2e057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0006ULL, 0x00011620002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002f06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0026ULL,
0x00011690002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0xffffeef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x000fe200078e0028ULL, 0x00011700002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fc400078e00ffULL, 0x00001c1fff397424ULL, 0x000fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fe400078e0020ULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0036ULL, 0xfffff4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x00011780002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fe400078e00ffULL, 0x00001c1fff397424ULL, 0x000fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fe400078e0020ULL, 0x000002b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff387224ULL, 0x002fe200078e00ffULL, 0x000117e0002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff397424ULL, 0x000fc400078e00ffULL, 0x000000ffff3a7224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x004fe400078e0036ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3a7224ULL, 0x002fe200078e0020ULL, 0x00011840002c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fe400078e00ffULL, 0x00001c1fff397424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e0036ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e0036ULL, 0xfffff3f000007947ULL, 0x000fea000383ffffULL,
0x0180000009027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000900028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff09ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000009037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000900027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffee61002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000003800007348ULL, 0x000fe80003800000ULL, 0x0c00002f2a2f7389ULL, 0x0002a200000e0037ULL,
0xfffee5d02c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0000003837367389ULL, 0x0002a200000e0039ULL,
0xfffee5902c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000200ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000798ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000810ULL, 0x0000000000000500ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d30ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d60ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000dd8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000011b00ULL, 0xb900001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012b00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012b10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012b10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012f90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000dd0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011d30ULL, 0x0000000000011d30ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012f90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin_len = 77936;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
