/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000196c0ULL, 0x0000000000019340ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017760ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x00000000000178e0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017920ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017970ULL, 0x0000000000000110ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017a80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001776000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x005c440400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001776000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL,
0x809d082880808708ULL, 0x082880809f082880ULL, 0x8080a308288080a1ULL, 0xad08288080a50828ULL,
0x288080ea08288080ULL, 0x80f008288080ec08ULL, 0x08288080f2082880ULL, 0x80828016288080d2ULL,
0x0000000000031028ULL, 0x288080d292000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x000178e000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL, 0xa608288080a30828ULL,
0x288080ad08288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080a508288080f2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x0001792000000000ULL, 0x0000005000000000ULL, 0x0000040400000000ULL,
0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL,
0x8080a1082880809fULL, 0xa508288080a30828ULL, 0x288080ad08288080ULL, 0x80ec08288080ea08ULL,
0x08288080f0082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x0001797000000000ULL,
0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000dcULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x0000001600080a04ULL,
0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f0000058000aULL, 0x00000000000c1704ULL,
0x0021f00000500009ULL, 0x00000000000c1704ULL, 0x0011f00000480008ULL, 0x00000000000c1704ULL,
0x0061f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x019c2804ffffffffULL, 0x00000360000002f0ULL, 0x00002a80000005a0ULL, 0x00002c4000002b30ULL,
0x00002f2000002db0ULL, 0x0000350000003080ULL, 0x0000355000003540ULL, 0x000056e000003580ULL,
0x0000589000005780ULL, 0x00005b7000005a00ULL, 0x0000614000005cd0ULL, 0x0000619000006180ULL,
0x00008290000061c0ULL, 0x0000844000008330ULL, 0x00008720000085b0ULL, 0x00008cf000008880ULL,
0x00008d4000008d30ULL, 0x0000acf000008d70ULL, 0x0000aea00000ad90ULL, 0x0000b1800000b010ULL,
0x0000b7400000b2e0ULL, 0x0000b7900000b780ULL, 0x0000ccc00000b7c0ULL, 0x0000cce00000ccd0ULL,
0x000156700000ccf0ULL, 0x000156c0000156b0ULL, 0x00015720000156d0ULL, 0x0001576000015740ULL,
0x00016ad000015770ULL, 0x00016b6000016b20ULL, 0x00016bc000016b90ULL, 0x00016c3000016bf0ULL,
0x00016cb000016c70ULL, 0x00016d4000016cf0ULL, 0x00016dd000016d90ULL, 0x00016e3000016e00ULL,
0x00016ea000016e60ULL, 0x00016f2000016ee0ULL, 0x00016fb000016f60ULL, 0x0001704000017000ULL,
0x000170a000017070ULL, 0x00017110000170d0ULL, 0x0001719000017150ULL, 0x00017220000171d0ULL,
0x000172b000017270ULL, 0x00017310000172e0ULL, 0x0001738000017340ULL, 0x00017400000173c0ULL,
0x000174a000017440ULL, 0x0001756000017500ULL, 0x00017620000175c0ULL, 0x000176e000017680ULL,
0x0440390400017740ULL, 0x000000ff00000410ULL, 0x003f010000012600ULL, 0x0000000f00000440ULL,
0x003f012000012608ULL, 0x0000000f000004c0ULL, 0x003f012000012688ULL, 0x0000000f00000520ULL,
0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL, 0x000000ff00000ed0ULL,
0x003f010700012600ULL, 0x0000001400001020ULL, 0x003f01020001268cULL, 0x00000014000010b0ULL,
0x003f010100012688ULL, 0x000000ff000019e0ULL, 0x0004010700000000ULL, 0x000000ff00001a60ULL,
0x0004010100000000ULL, 0x0000000200001ac0ULL, 0x003f010100000020ULL, 0x0000000c00001c30ULL,
0x003f0105000126ccULL, 0x0000000c00001e00ULL, 0x003f0105000126ccULL, 0x0000001f00002620ULL,
0x003f0107000126b0ULL, 0x0000001f000026e0ULL, 0x003f0101000126b0ULL, 0x0000001c00002740ULL,
0x003f010100012608ULL, 0x0000002300002780ULL, 0x003f01050001260cULL, 0x0000002300002960ULL,
0x003f01050001260cULL, 0x0000001f00003230ULL, 0x003f0105000126acULL, 0x0000001f00003420ULL,
0x003f0105000126acULL, 0x0000006800004900ULL, 0x003f010100000000ULL, 0x0000001f00004960ULL,
0x003f010100012688ULL, 0x0000000d00004990ULL, 0x003f010500000004ULL, 0x0000000d00004b50ULL,
0x003f010500000004ULL, 0x00000008000052a0ULL, 0x003f010700000000ULL, 0x0000000800005380ULL,
0x003f010100000000ULL, 0x00000023000053e0ULL, 0x003f010100012628ULL, 0x0000006a00005440ULL,
0x003f01050001262cULL, 0x0000006a00005610ULL, 0x003f01050001262cULL, 0x0000006a00005ea0ULL,
0x003f0105000126b4ULL, 0x0000006a00006070ULL, 0x003f0105000126b4ULL, 0x0000006a000074d0ULL,
0x003f010100000000ULL, 0x0000002600007530ULL, 0x003f010100012690ULL, 0x0000000d00007560ULL,
0x003f010500000004ULL, 0x0000000d00007720ULL, 0x003f010500000004ULL, 0x000000ff00007ea0ULL,
0x0004010700000008ULL, 0x0000006800007f30ULL, 0x003f0101000126b0ULL, 0x0000002300007f90ULL,
0x003f010100012648ULL, 0x0000002300007ff0ULL, 0x003f01050001264cULL, 0x00000023000081c0ULL,
0x003f01050001264cULL, 0x0000000800008a50ULL, 0x003f010500000004ULL, 0x0000000800008c20ULL,
0x003f010500000004ULL, 0x0000002600009f50ULL, 0x003f010100000000ULL, 0x0000002000009fb0ULL,
0x003f010100012698ULL, 0x0000000d00009fe0ULL, 0x003f010500000004ULL, 0x0000000d0000a1a0ULL,
0x003f010500000004ULL, 0x000000ff0000a940ULL, 0x0004010700000000ULL, 0x000000080000a9f0ULL,
0x003f010100000000ULL, 0x0000000c0000aa50ULL, 0x003f010100012668ULL, 0x0000000c0000aa70ULL,
0x003f01050001266cULL, 0x0000000c0000ac40ULL, 0x003f01050001266cULL, 0x000000260000b4a0ULL,
0x003f0105000126b4ULL, 0x000000260000b670ULL, 0x003f0105000126b4ULL, 0x0000000d0000ca10ULL,
0x003f010100000000ULL, 0x0000000a0000ca90ULL, 0x003f010100000000ULL, 0x000000ff0000ecb0ULL,
0x003f010100012600ULL, 0x000000ff0000f890ULL, 0x003f010500012604ULL, 0x000000ff0000faa0ULL,
0x003f010500012604ULL, 0x000000ff0000fe20ULL, 0x003f010100012600ULL, 0x000000ff0000fe50ULL,
0x003f010500012604ULL, 0x000000ff00010010ULL, 0x003f010500012604ULL, 0x00000062000128a0ULL,
0x003f010100000000ULL, 0x00000062000129d0ULL, 0x003f010500000004ULL, 0x0000006200012ba0ULL,
0x003f010500000004ULL, 0x0000001800016930ULL, 0x003f010100000000ULL, 0x0000001800016990ULL,
0x003f010100000008ULL, 0x00000018000169f0ULL, 0x003f010100000010ULL, 0x0000001800016a60ULL,
0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000dc100000dbe0ULL, 0x0000e0900000dea0ULL,
0x0000e4700000e280ULL, 0x0000e8500000e660ULL, 0x0000ec000000ea50ULL, 0x00016aa000010070ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL,
0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000308ULL, 0x0000001900000002ULL, 0x0000000000000238ULL, 0x0000001900000002ULL,
0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x000000010e040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0003ULL,
0x00005c000e020625ULL, 0x000fe200078e0003ULL, 0x0000000604610981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000d7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000001a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e0210ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x0000000509037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000d037a24ULL, 0x002fe400078e0206ULL,
0x00000008051b7227ULL, 0x000fe200078e00ffULL, 0x00001fff0d0d7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a1bULL, 0x00000000030f7a24ULL, 0x100fe200078e021aULL,
0x00000005ff1a7819ULL, 0x000fe2000001161aULL, 0x0000000009007224ULL, 0x000fc600078e0208ULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000090000720cULL, 0x000fe20003fa6070ULL,
0x00001fff1a1a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x0000007f0f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff04b424ULL, 0x000fe400078e00ffULL,
0x0000000100005824ULL, 0x000fe200078e0a09ULL, 0x000000011b1b5810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x040fe20003fa4070ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x000000090000720cULL, 0x000fe20003fc6070ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x01260004ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ca424ULL, 0x000fc400078e00ffULL,
0x012608060f009388ULL, 0x000fe80000008a00ULL, 0x0124000c0f00a388ULL, 0x000fe20000004800ULL,
0x3fffff60ff04d424ULL, 0x008fe400078e00ffULL, 0x000000011b1b6810ULL, 0x000fe20007ffe0ffULL,
0x7fffff60ff05d424ULL, 0x000fe200078e00ffULL, 0x00000009ff1bc212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff0ab424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0bb424ULL, 0x000fe200078e00ffULL,
0x012688040f00d388ULL, 0x000fe20000008a00ULL, 0x000000ffff197224ULL, 0x000fc800078e0a1bULL,
0x0000001909197224ULL, 0x000fe400078e0208ULL, 0x3fffff80ff08d424ULL, 0x000fe400078e00ffULL,
0x0000002019197824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff09d424ULL, 0x000fca00078e00ffULL,
0x0126a8080f00d388ULL, 0x000fe80000008a00ULL, 0x0126c80a0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000161610824ULL, 0x004fe400078e0a02ULL, 0x00005800ff618624ULL, 0x000fe400078e00ffULL,
0x000058000e028a24ULL, 0x000fe400078e02ffULL, 0x00005a0061007a24ULL, 0x000fc400078e02ffULL,
0x00000011026e7224ULL, 0x000fe400078e02ffULL, 0x0000000100037824ULL, 0x040fe200078e0a19ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000190000720cULL, 0x000fe20003f26070ULL,
0x000000040d007824ULL, 0x002fe200078e021aULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x00005a001b137a24ULL, 0x000fc400078e026eULL, 0x0000000400007824ULL, 0x000fe200078e00ffULL,
0x000000ff03187207ULL, 0x000fc80000800000ULL, 0x000000201800780cULL, 0x000fda0003f05270ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff077819ULL, 0x004fc80000011617ULL,
0x0000000207097810ULL, 0x000fe20007ffe0ffULL, 0x0000000100087824ULL, 0x000fe200078e0207ULL,
0x0ffffffe03057810ULL, 0x002fc60007ffe0ffULL, 0x00000001000a7824ULL, 0x000fc600078e0209ULL,
0x0000000500057305ULL, 0x000e62000021f000ULL, 0x00000001190c7824ULL, 0x000fe400078e020aULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b05037227ULL, 0x000fc800078e0004ULL, 0x0000000119047824ULL, 0x000fe400078e0208ULL,
0x0000000c030b7227ULL, 0x000fc800078e00ffULL, 0x0000000403057227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a05ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0bULL,
0x00005a0003037a24ULL, 0x000fe400078e0204ULL, 0x00005a000f067a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0006007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0006062a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0006007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fe400078e33ffULL,
0x0000000018037217ULL, 0x000fe40007800000ULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000506057207ULL, 0x040fe20004000000ULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x0000000b06067207ULL, 0x000fc40004000000ULL, 0x000000000700720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a05ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a06ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000113047824ULL, 0x040fe400078e0204ULL, 0x00000001130b7824ULL, 0x000fc400078e020cULL,
0x0000001105047224ULL, 0x080fe400078e0204ULL, 0x0000001106067224ULL, 0x000fe400078e020bULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000108007824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0x0000600006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c46ULL,
0x00000000060b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x0000000000177919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fcc00078e00ffULL, 0x0000000300037308ULL, 0x002e620000001000ULL,
0x0000000017007211ULL, 0x004fc800078fe0ffULL, 0x00000002000a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0ffffffe03057810ULL, 0x002fe20007ffe0ffULL,
0x0000000119037824ULL, 0x040fe400078e0200ULL, 0x0000000119067824ULL, 0x000fc600078e020aULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705077227ULL, 0x000fcc00078e0004ULL,
0x0000000307047227ULL, 0x000fc800078e00ffULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x00005a0008057a24ULL, 0x000fe400078e0203ULL, 0x00005a0009087a24ULL, 0x000fc600078e0206ULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x00005a0008037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000113057824ULL, 0x040fe400078e0203ULL, 0x0000000113067824ULL, 0x000fc400078e0206ULL,
0x0000001017037824ULL, 0x000fe400078e00ffULL, 0x0000001104057224ULL, 0x080fe400078e0205ULL,
0x0000001107067224ULL, 0x000fe200078e0206ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000100087824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e0217ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b087812ULL, 0x000fe400078ee208ULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000001008097824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x00000000060b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff297424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000047300ULL, 0x000e7000000e0000ULL, 0x0000000000067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x000066000e047625ULL, 0x000fc800078e0029ULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01260406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604167981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x000000ff16007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff157819ULL, 0x000fce0000011600ULL,
0x0000dc2000008947ULL, 0x000fea0003800000ULL, 0x000000081a147824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01268c0514ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x000000020e027824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe2000001161aULL, 0x0126880014ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011a117812ULL, 0x000fe200078ec0ffULL, 0x0000590002027624ULL, 0x000fe400078e0210ULL,
0x00000020136f7824ULL, 0x000fc400078e00ffULL, 0x000000011b127824ULL, 0x000fc800078e0202ULL,
0x0000680012007a24ULL, 0x000fe200078e026fULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000006f16027217ULL, 0x008fe20007800000ULL, 0x0000001011057824ULL, 0x004fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc60000011617ULL, 0x0000000102027824ULL, 0x000fe200078e0a6fULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x002fe200078e0204ULL,
0x0000000c04097810ULL, 0x000fe40007ffe0ffULL, 0x0000000502027217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a05ULL, 0x00000001050a7824ULL, 0x040fe200078e0209ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000804077810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e020aULL, 0x000000020400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0206ULL, 0x000000020800720cULL, 0x080fe20003f46070ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x080fe20003f26070ULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef803ULL, 0x0000000108067824ULL, 0x040fe400078e0217ULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x100fe200078e0217ULL, 0xfffffff80d007812ULL, 0x000fe200078ee206ULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000e000130d7811ULL, 0x000fe200078e68ffULL,
0x000000010a047824ULL, 0x000fc400078e0217ULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010001d7824ULL, 0x000fe200078e020dULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL, 0xfffffff807107812ULL, 0x000fe200078ee204ULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x00006500050b7a10ULL, 0x000fc600027fe4ffULL,
0x0000008002047825ULL, 0x000fc800078e00ffULL, 0x000000800f087825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x100fe400078ef803ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x000000100c0f7824ULL, 0x000fe200078e020dULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x000000100e1f7824ULL, 0x100fe200078e020dULL, 0x0000640002027a10ULL, 0x000fe20007f9e0ffULL,
0x00000010100d7824ULL, 0x000fe200078e020dULL, 0x0000640004047a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c46ULL,
0x0000640003067a10ULL, 0x000fc40007fde0ffULL, 0x0000650005037a10ULL, 0x000fe400027fe4ffULL,
0x0000650007057a10ULL, 0x000fe40002ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200037fe4ffULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000041f7faeULL, 0x0003e8000c901c46ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011027824ULL, 0x008fe200078e00ffULL, 0x0000e000131f7811ULL, 0x000fc800078e68ffULL,
0x0000000217027211ULL, 0x000fc800078fe8ffULL, 0x0000000402067810ULL, 0x042fe20007ffe0ffULL,
0x0000000102057824ULL, 0x044fe200078e0217ULL, 0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008020c7824ULL, 0x040fe200078e00ffULL, 0x0000000802087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000106077824ULL, 0x000fe200078e0217ULL, 0x00000070040b7812ULL, 0x000fe200078ef803ULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x00000001000d7824ULL, 0x000fe400078e020aULL,
0x000000010a047824ULL, 0x040fe400078e0217ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0xfffffff80e007812ULL, 0x000fe200078ee207ULL, 0x0000000108097824ULL, 0x040fe200078e0217ULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00006500050b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008002047825ULL, 0x000fc600078e00ffULL,
0xfffffff8080e7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x000fc600078ef803ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fe400078ef803ULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e021fULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000640003067a10ULL, 0x000fe20007f5e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000650005037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200017fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000b901c46ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e4000b901c46ULL, 0x00000000130473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000126a813027811ULL, 0x002fe200078e18ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff6c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000af6000008947ULL, 0x000fea0003800000ULL, 0x00000010130e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x000fe2000001161aULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x000000100e0e7812ULL, 0x000fe200078ee2ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1c7224ULL, 0x00afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x000000041a0a7824ULL, 0x000fca00078e00ffULL, 0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL,
0x000126c80c0d7810ULL, 0x000fe20007ffe0ffULL, 0x0126cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000001d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f007810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0c7824ULL, 0x000fc600078e026fULL,
0x000000150000720cULL, 0x000fe40003f46070ULL, 0x000000400c037810ULL, 0x000fca0007ffe0ffULL,
0x00006800121f7a24ULL, 0x000fcc00078e0203ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x000fe20000011617ULL, 0x00000010110b7824ULL, 0x000fe200078e00ffULL,
0x0000000316007217ULL, 0x000fe40007800000ULL, 0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e020aULL, 0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x00000001021c7824ULL, 0x040fe400078e0217ULL,
0x0000000802237824ULL, 0x000fe200078e00ffULL, 0x000000000b007217ULL, 0x000fe20007800000ULL,
0x0000001017037824ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e021fULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b207824ULL, 0x000fe200078e021dULL,
0x0000007003217812ULL, 0x000fe200078ec0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x080fe40003fa6070ULL, 0x000000001c00720cULL, 0x080fe20003f86070ULL,
0x000000010b1e7824ULL, 0x040fe200078e021cULL, 0x00000021021c7212ULL, 0x000fe200078efcffULL,
0x000000010b267824ULL, 0x000fe200078e0224ULL, 0x000000001d00720cULL, 0x080fe20003f66070ULL,
0x000000011e0a7824ULL, 0x000fe200078e021fULL, 0x000000002400720cULL, 0x000fe20003f06070ULL,
0x000000011e007824ULL, 0x000fe200078e0217ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x00006500031d7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0x000000210a1e7212ULL, 0x080fe200078efcffULL,
0x0000000120027824ULL, 0x100fe400078e021fULL, 0x00000001260a7824ULL, 0x000fe200078e021fULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe400078ee200ULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002102027212ULL, 0x000fc400078efcffULL,
0x0000f00013007811ULL, 0x000fe200078e68ffULL, 0x0000000120247824ULL, 0x100fe200078e0217ULL,
0x0000640002027a10ULL, 0x000fe20007fde0ffULL, 0x0000000820277824ULL, 0x000fe200078e00ffULL,
0x000000210a0a7212ULL, 0x000fe200078efcffULL, 0x0000000126207824ULL, 0x040fe200078e0217ULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000000826697824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee224ULL, 0x0000001023217824ULL, 0x100fe200078e0200ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001025237824ULL, 0x000fe200078e0200ULL,
0xfffffff869697812ULL, 0x000fe200078ee220ULL, 0x0000001027257824ULL, 0x100fe200078e0200ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0005e4000e901c46ULL, 0x0000001069277824ULL, 0x000fc400078e0200ULL,
0x000000001e237faeULL, 0x0005e8000e101c46ULL, 0x0000000002257faeULL, 0x0005e8000d901c46ULL,
0x000000000a277faeULL, 0x0005e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000001017027824ULL, 0x000fc600078e00ffULL,
0x0000000017007211ULL, 0x000fe400078fe8ffULL, 0x0000007002257812ULL, 0x000fe400078ec0ffULL,
0x0000000c00247810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e0217ULL,
0x0000000800207810ULL, 0x040fe20007ffe0ffULL, 0x00000008000a7824ULL, 0x040fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e021fULL, 0x0000000824697824ULL, 0x000fe200078e00ffULL,
0xfffffff80a217812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x00000004000a7810ULL, 0x000fc60007ffe0ffULL, 0x00000001201d7824ULL, 0x000fe200078e0217ULL,
0x00000025021e7212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x040fe400078e021fULL,
0x000000010a0b7824ULL, 0x100fe200078e0217ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000080a267824ULL, 0x000fe400078e00ffULL, 0x0000000124027824ULL, 0x000fe400078e0217ULL,
0x00000001200a7824ULL, 0x000fe200078e021fULL, 0xfffffff826237812ULL, 0x000fe200078ee20bULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee202ULL,
0x00000001241c7824ULL, 0x000fe200078e021fULL, 0x00006500031f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008000027825ULL, 0x000fe200078e00ffULL, 0xfffffff820277812ULL, 0x000fc400078ee21dULL,
0x0000f00013207811ULL, 0x000fe200078e68ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002502027212ULL, 0x000fc600078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000250a0a7212ULL, 0x080fe400078efcffULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x000000251c1c7212ULL, 0x000fe200078efcffULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001027257824ULL, 0x100fe200078e0220ULL, 0x000064001c1c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001069277824ULL, 0x000fe200078e0220ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e217faeULL, 0x0005e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc40001ffe4ffULL, 0x000065001d1d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000002237faeULL, 0x0005e8000b901c46ULL, 0x000000000a257faeULL, 0x0005e8000b901c46ULL,
0x000000001c277faeULL, 0x0005e4000b901c46ULL, 0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL,
0xffffffe014007812ULL, 0x000fc400078ec0ffULL, 0x000000001f0573c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001014037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fc800078e0203ULL, 0x00000008111c7824ULL, 0x000fe200078e0200ULL,
0x000126b005057890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0001f207f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012608001c1c7f8cULL, 0x000ea4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x00000008140b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100237824ULL, 0x000fca00078e020bULL,
0x01260c00230b7984ULL, 0x000f240000000800ULL, 0x800000000bff7812ULL, 0x014fe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a02257210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01260c00230b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011617ULL,
0x000000201a007824ULL, 0x000fe400078e00ffULL, 0xffffffffff747424ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fc400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a007210ULL, 0x000fca0007ffe00bULL,
0x0120000000037984ULL, 0x000ea80000000800ULL, 0x0122000000027984ULL, 0x0006620000000800ULL,
0x000000080300720bULL, 0x004fe20003f1d000ULL, 0x000140327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x0000001fff767424ULL, 0x000fe400078e00ffULL,
0xffffffffff757424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001a1000720cULL, 0x000fe40003f05270ULL, 0x000000080300720bULL, 0x000fe20003f74000ULL,
0x00013fd27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x00000008031e7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124001e25008388ULL, 0x0005e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000081e087221ULL, 0x004fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00013f127f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00013dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x00013c927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00013b627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000001d00ff7212ULL, 0x000fda00078030ffULL, 0x8000001e03030221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x0000000300090308ULL, 0x000ea40000000800ULL, 0x0000000902020220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002202227221ULL, 0x002fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0126ac001f007984ULL, 0x000e620000000800ULL,
0x000126a81f087810ULL, 0x000fe40007ffe0ffULL, 0x8000000000ff7812ULL, 0x002fe2000780486dULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c02257210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001141dULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x0000000200007819ULL, 0x000fc8000000121dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac001f007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991024007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff027819ULL, 0x000fe40000011617ULL,
0x0000541000277816ULL, 0x000fe20000000000ULL, 0x000137127f007947ULL, 0x000fea000b800000ULL,
0x00001f0227077589ULL, 0x0002a400000e0000ULL, 0x0000000802267810ULL, 0x000fe20007ffe0ffULL,
0x000137327f007947ULL, 0x000fea000b800000ULL, 0x0000001002007810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0027057589ULL, 0x0006a400000e0000ULL,
0x0000001802267810ULL, 0x008fe20007ffe0ffULL, 0x000137627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004136c7824ULL, 0x000fe200078e00ffULL, 0x0000000817007812ULL, 0x000fe200078ec0ffULL,
0x000004001a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004ff7c7819ULL, 0x100fe20000011617ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000046c6c7812ULL, 0x000fe200078ec0ffULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000000700037812ULL, 0x000fc400078ef817ULL,
0x0000006c17007211ULL, 0x000fe400078fe0ffULL, 0x0000001003027812ULL, 0x042fe200078efcffULL,
0x00000008031f7824ULL, 0x000fe200078e00ffULL, 0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001031c7824ULL, 0x000fe400078e0200ULL, 0x0000000100007824ULL, 0x000fe200078e0202ULL,
0x0000a0001d6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000802257824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL, 0x00000004111f7824ULL, 0x000fc400078e027cULL,
0x0000000803277824ULL, 0x008fe200078e00ffULL, 0xfffffff8251d7812ULL, 0x000fe200078ee200ULL,
0x0000000103707824ULL, 0x000fe200078e021fULL, 0x0000e00013007811ULL, 0x000fe200078e68ffULL,
0x000000101c687824ULL, 0x100fe400078e026dULL, 0x000000101d247824ULL, 0x000fe200078e026dULL,
0xfffffff827257812ULL, 0x000fc600078ee270ULL, 0x000000006868783bULL, 0x000e640000000200ULL,
0x0000001025787824ULL, 0x000fe400078e0200ULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687232ULL, 0x086fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fe40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803717824ULL, 0x000fe200078e00ffULL, 0x0000000270707810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000001021f7824ULL, 0x000fe200078e021fULL,
0x000008d000007945ULL, 0x000fe20003800000ULL, 0xfffffff871717812ULL, 0x000fca00078ee270ULL,
0x0000001071717824ULL, 0x000fcc00078e0200ULL, 0x000000007170783bULL, 0x000ee20000004200ULL,
0x00000018ff7d7819ULL, 0x010fe20000011479ULL, 0x000001007b877824ULL, 0x040fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011478ULL, 0x000100007b897824ULL, 0x000fe200078e00ffULL,
0x0000007d00827306ULL, 0x0009e20000200c00ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147aULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x00000018ff807819ULL, 0x000fc4000001147bULL,
0x00000018ff897819ULL, 0x000fe20000011489ULL, 0x00000077007f7306ULL, 0x0005e20000200c00ULL,
0x00000100787d7824ULL, 0x010fe200078e00ffULL, 0x00000018ff837819ULL, 0x008fe20000011471ULL,
0x00000100708b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011472ULL,
0x0000010073957824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000008300907306ULL, 0x0007e20000200c00ULL, 0x0000888078777816ULL, 0x044fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc40000011470ULL,
0x00000018ff857819ULL, 0x000fe40000011473ULL, 0x0000888072917816ULL, 0x000fe200000000ffULL,
0x0000007e00867306ULL, 0x000fe20000200c00ULL, 0x000001007a837824ULL, 0x008fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000888073937816ULL, 0x000fc400000000ffULL, 0x00000018ff957819ULL, 0x000fca0000011495ULL,
0x0000007d007e7306ULL, 0x0004f00000200c00ULL, 0x0000008400947306ULL, 0x000fe20000200c00ULL,
0x000088807a7d7816ULL, 0x044fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000008300847306ULL, 0x0005f00000200c00ULL,
0x0000008700887306ULL, 0x0009e20000200c00ULL, 0x0000888070837816ULL, 0x044fe200000000ffULL,
0x0001000070707824ULL, 0x000fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000008500967306ULL, 0x0005e20000200c00ULL, 0x0000888071877816ULL, 0x010fce00000000ffULL,
0x00000080008a7306ULL, 0x0009e20000200c00ULL, 0x000088807b857816ULL, 0x004fce00000000ffULL,
0x00000081008e7306ULL, 0x0005e20000200c00ULL, 0x0000888079807816ULL, 0x010fce00000000ffULL,
0x00000070008f7306ULL, 0x0007220000200c00ULL, 0x0000010079817824ULL, 0x044fe400078e00ffULL,
0x0001000079797824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x0000007a007b7306ULL, 0x0004620000200c00ULL, 0x0000541077707816ULL, 0x008fe2000000007eULL,
0x0001000073777824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fc80000011479ULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x00000087008d7306ULL, 0x0007e20000200c00ULL,
0x00000100717a7824ULL, 0x004fe200078e00ffULL, 0x000054108f8e7816ULL, 0x010fe2000000008eULL,
0x0001000071717824ULL, 0x000fc600078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000010072877824ULL, 0x048fe200078e00ffULL,
0x0000008b008c7306ULL, 0x000fe20000200c00ULL, 0x0001000072727824ULL, 0x000fe200078e00ffULL,
0x000054107b867816ULL, 0x002fe40000000086ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff727819ULL, 0x000fc40000011472ULL, 0x0000008000807306ULL, 0x000ff00000200c00ULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000e700000200c00ULL,
0x0000007900797306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541078787816ULL, 0x002fce000000007fULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x0000541079797816ULL, 0x004fce0000000082ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000054107d847816ULL, 0x008fe20000000084ULL, 0x000000786860723cULL, 0x080f6c0000001860ULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541085857816ULL, 0x002fe20000000088ULL,
0x000000782440723cULL, 0x000f6c0000001840ULL, 0x0000007a007a7306ULL, 0x000e640000200c00ULL,
0x00000084685c723cULL, 0x080f6c000000185cULL, 0x00000071008b7306ULL, 0x0007220000200c00ULL,
0x00005410838c7816ULL, 0x004fe2000000008cULL, 0x00000084243c723cULL, 0x000f6c000000183cULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x0000541080717816ULL, 0x008fc40000000081ULL,
0x000054108d8d7816ULL, 0x002fca000000007aULL, 0x0000008700927306ULL, 0x0002a20000200c00ULL,
0x000054108b8f7816ULL, 0x010fe20000000090ULL, 0x000000706864723cULL, 0x040f6c0000001864ULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x0000541089877816ULL, 0x002fe2000000008aULL,
0x0000008c6854723cULL, 0x040f6c0000001854ULL, 0x00000095007e7306ULL, 0x000e620000200c00ULL,
0x0000541091927816ULL, 0x004fe20000000092ULL, 0x000000866858723cULL, 0x040f6c0000001858ULL,
0x0000007200737306ULL, 0x000ea40000200c00ULL, 0x0000008e6850723cULL, 0x000f6c0000001850ULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x0000541093937816ULL, 0x002fe2000000007eULL,
0x000000702444723cULL, 0x000f620000001844ULL, 0x0000541073947816ULL, 0x004fce0000000094ULL,
0x00000092684c723cULL, 0x000f62000000184cULL, 0x0000541077957816ULL, 0x008fce0000000096ULL,
0x000000862438723cULL, 0x000f700000001838ULL, 0x000000946848723cULL, 0x000b6e0000001848ULL,
0x000000026c697812ULL, 0x020fe200078efcffULL, 0x00000008036b7824ULL, 0x000fe200078e00ffULL,
0x0000008c2434723cULL, 0x000f620000001834ULL, 0x00000008026a7824ULL, 0x000fc400078e00ffULL,
0x000000017c697824ULL, 0x000fe400078e0269ULL, 0x00000008026c7824ULL, 0x040fe400078e00ffULL,
0x0000000103687824ULL, 0x100fe200078e0269ULL, 0x0000008e2430723cULL, 0x000f620000001830ULL,
0x0000000102697824ULL, 0x000fc600078e0269ULL, 0xfffffff86b687812ULL, 0x000fe400078ee268ULL,
0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL, 0xfffffff86c697812ULL, 0x000fe200078ee21fULL,
0x0000001068687824ULL, 0x100fe200078e026dULL, 0x00000092242c723cULL, 0x040f62000000182cULL,
0x000000106a6d7824ULL, 0x000fe400078e026dULL, 0x0000001069787824ULL, 0x000fe400078e0200ULL,
0x000000006868783bULL, 0x000e660000000200ULL, 0x000000942428723cULL, 0x000b640000001828ULL,
0x000000006d24783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000768687232ULL, 0x082fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fc40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fe40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008026c7824ULL, 0x000fe200078e00ffULL, 0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000f260000004200ULL, 0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL,
0x000000101f1f7824ULL, 0x000fca00078e0200ULL, 0x000000001f70783bULL, 0x0004e20000004200ULL,
0x00000018ff7c7819ULL, 0x010fe4000001147aULL, 0x00000018ff6c7819ULL, 0x000fe40000011478ULL,
0x0000007c00827306ULL, 0x0009e20000200c00ULL, 0x00000018ff6d7819ULL, 0x004fe40000011479ULL,
0x00008880781f7816ULL, 0x000fe400000000ffULL, 0x00000018ff7e7819ULL, 0x000fc6000001147bULL,
0x0000006c00777306ULL, 0x0005e20000200c00ULL, 0x00000018ff837819ULL, 0x008fe20000011473ULL,
0x00000100797c7824ULL, 0x010fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011472ULL,
0x0000010070887824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011470ULL,
0x00000018ff807819ULL, 0x000fe20000011471ULL, 0x0000006d007d7306ULL, 0x0007e20000200c00ULL,
0x00000100786c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x0000888070877816ULL, 0x040fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001146cULL,
0x0000008300917306ULL, 0x0005e20000200c00ULL, 0x00008880796d7816ULL, 0x048fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008100907306ULL, 0x0007e20000200c00ULL, 0x000001007b837824ULL, 0x004fe200078e00ffULL,
0x00008880728d7816ULL, 0x000fc400000000ffULL, 0x00008880738f7816ULL, 0x000fe400000000ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000007f008a7306ULL, 0x0005e20000200c00ULL,
0x000088807b817816ULL, 0x048fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc80000011488ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x00000080008b7306ULL, 0x0007e20000200c00ULL, 0x000088807a7f7816ULL, 0x004fce00000000ffULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000001007a807824ULL, 0x048fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff7a7819ULL, 0x000fce000001147aULL,
0x0000001f001f7306ULL, 0x000ff00000200c00ULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x000054106d6d7816ULL, 0x004fce000000007cULL, 0x0000007800787306ULL, 0x000ff00000200c00ULL,
0x0000008300847306ULL, 0x0005e20000200c00ULL, 0x000054101f6c7816ULL, 0x008fce000000006cULL,
0x0000007e00857306ULL, 0x000fe20000200c00ULL, 0x0000888071837816ULL, 0x044fe200000000ffULL,
0x0000006c2444723cULL, 0x080f6c0000001844ULL, 0x00000079007e7306ULL, 0x000fe40000200c00ULL,
0x0000006c6864723cULL, 0x002f6c0000001864ULL, 0x0000007b00867306ULL, 0x000ff00000200c00ULL,
0x0000007a00797306ULL, 0x0002b00000200c00ULL, 0x00000070007b7306ULL, 0x0007220000200c00ULL,
0x00000100717a7824ULL, 0x002fc400078e00ffULL, 0x0001000071717824ULL, 0x000fc600078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000008300897306ULL, 0x0003e20000200c00ULL,
0x0000010073707824ULL, 0x048fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x0000541079827816ULL, 0x004fe40000000082ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000010072837824ULL, 0x042fe200078e00ffULL, 0x00000070007c7306ULL, 0x0003e20000200c00ULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x000054107b8a7816ULL, 0x010fc4000000008aULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541078707816ULL, 0x002fce0000000077ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000008100817306ULL, 0x000eb00000200c00ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054107f807816ULL, 0x002fce0000000080ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x0000541081817816ULL, 0x004fce0000000084ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x00000080243c723cULL, 0x080f6e000000183cULL,
0x00000071008c7306ULL, 0x0007220000200c00ULL, 0x0000541087887816ULL, 0x002fe20000000088ULL,
0x00000080685c723cULL, 0x000f6c000000185cULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107e717816ULL, 0x008fc4000000007dULL, 0x0000541089897816ULL, 0x004fca000000007aULL,
0x00000083008e7306ULL, 0x0002a20000200c00ULL, 0x000054108c8b7816ULL, 0x010fe2000000008bULL,
0x000000702440723cULL, 0x040f6c0000001840ULL, 0x0000008f008f7306ULL, 0x000ee20000200c00ULL,
0x0000541086837816ULL, 0x002fe20000000085ULL, 0x000000882434723cULL, 0x040f6c0000001834ULL,
0x00000072001f7306ULL, 0x000e620000200c00ULL, 0x000054108d8e7816ULL, 0x004fe2000000008eULL,
0x000000822438723cULL, 0x040f6c0000001838ULL, 0x0000007300787306ULL, 0x000ea20000200c00ULL,
0x000054108f8f7816ULL, 0x008fe2000000007cULL, 0x0000008a2430723cULL, 0x000f620000001830ULL,
0x000054101f907816ULL, 0x002fe20000000090ULL, 0x000000021a1f7824ULL, 0x000fcc00078e00ffULL,
0x0000008e242c723cULL, 0x000f62000000182cULL, 0xfffffff81f1f7812ULL, 0x000fe400078ec0ffULL,
0x0000541078917816ULL, 0x004fca0000000091ULL, 0x000000706860723cULL, 0x000f700000001860ULL,
0x000000902428723cULL, 0x000f700000001828ULL, 0x000000826858723cULL, 0x040f700000001858ULL,
0x000000886854723cULL, 0x040f700000001854ULL, 0x0000008a6850723cULL, 0x040f700000001850ULL,
0x0000008e684c723cULL, 0x040f70000000184cULL, 0x000000906848723cULL, 0x000b6e0000001848ULL,
0x000126c813687811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012688001fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000000247805ULL, 0x000fc80000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc40007804869ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800c257810ULL, 0x000fca0007ffe0ffULL, 0x00006800126c7a24ULL, 0x000fe200078e0225ULL,
0x000003d00000a947ULL, 0x000fea0003800000ULL, 0x00000025161f7217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000011f1f7824ULL, 0x000fe200078e0a25ULL, 0x0000000427697810ULL, 0x040fe20007ffe0ffULL,
0x0000000170247824ULL, 0x040fe200078e0227ULL, 0x00000008276b7810ULL, 0x040fe40007ffe0ffULL,
0x0000001f701f7217ULL, 0x000fe20007800000ULL, 0x0000000124257824ULL, 0x040fe200078e0217ULL,
0x0000000c27737810ULL, 0x000fe20007ffe0ffULL, 0x0000000824267824ULL, 0x000fe400078e00ffULL,
0x0000000170717824ULL, 0x000fc400078e0269ULL, 0x0000000124247824ULL, 0x000fe200078e026cULL,
0xfffffff8266d7812ULL, 0x000fe200078ee225ULL, 0x000000011f1f7824ULL, 0x000fe400078e0a70ULL,
0x0000000171267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000001f2700720cULL, 0x080fe40003f06070ULL, 0x0000001f6900720cULL, 0x000fe20003f86070ULL,
0x0000000170727824ULL, 0x000fe200078e026bULL, 0x0000000b246a7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000001f6b00720cULL, 0x000fc40003f66070ULL,
0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000170707824ULL, 0x000fe200078e0273ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000000172687824ULL, 0x100fe200078e026cULL,
0x00006500256b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000000170247824ULL, 0x000fe200078e026cULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000001f7300720cULL, 0x000fe40003fa6070ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001716c7824ULL, 0x040fe200078e0217ULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x0000000871717824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000640068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff8711f7812ULL, 0x000fe200078ee26cULL,
0x00000001726c7824ULL, 0x100fe200078e0217ULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x0000000872717824ULL, 0x000fe200078e00ffULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x0000000170727824ULL, 0x000fe200078e0217ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000870737824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0xfffffff873737812ULL, 0x000fe200078ee272ULL,
0x0000001071717824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c46ULL, 0x0000001073737824ULL, 0x000fe200078e0200ULL,
0x00000000261f7faeULL, 0x0003e8000e101c46ULL, 0x0000000068717faeULL, 0x0003e8000d901c46ULL,
0x0000000024737faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001011247824ULL, 0x000fca00078e00ffULL, 0x00000024171f7211ULL, 0x000fc800078fe8ffULL,
0x000000041f267810ULL, 0x040fe20007ffe0ffULL, 0x000000011f247824ULL, 0x140fe200078e0217ULL,
0x000000081f687810ULL, 0x040fe20007ffe0ffULL, 0x000000081f6d7824ULL, 0x000fe400078e00ffULL,
0x0000000126257824ULL, 0x140fe400078e0217ULL, 0x00000008266a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL, 0x000000011f247824ULL, 0x040fe200078e026cULL,
0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000168277824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee225ULL, 0x0000000868707824ULL, 0x000fc400078e00ffULL,
0x0000000126267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee227ULL, 0x0000000168687824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x000000011f6a7824ULL, 0x000fe400078e026cULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640024247a10ULL, 0x000fc60007f1e0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000650025257a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x080fe400078efcffULL, 0x0000640026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000011f6c7824ULL, 0x040fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000640068687a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fe200007fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026717faeULL, 0x0003e8000b901c46ULL,
0x0000000068737faeULL, 0x0003e8000b901c46ULL, 0x000000006a1f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000080503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126280023687f8cULL, 0x000664000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL, 0x0000001014267812ULL, 0x000fca00078ec0ffULL,
0x000000011f267824ULL, 0x000fc800078e0226ULL, 0x00000008116a7824ULL, 0x000fca00078e0226ULL,
0x01262c006a1f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x012fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c006a1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f247812ULL, 0x000fc800078ec0ffULL,
0x000000800b1f7810ULL, 0x000fca0007ffe024ULL, 0x000000010a1f7824ULL, 0x000fca00078e021fULL,
0x012000001f697984ULL, 0x000e680000000800ULL, 0x012200001f687984ULL, 0x0006a20000000800ULL,
0x0000001e6900720bULL, 0x002fe20003f1d000ULL, 0x000116427f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e001eULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000110257810ULL, 0x000fe40007ffe0ffULL, 0x0000001e6900720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x000115f27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000707806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x0000001e69247209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124002425008388ULL, 0x0003e20000000800ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001e241e7221ULL, 0x002fe20000010100ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00277308ULL, 0x000e640000000800ULL, 0x0000002722227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000115327f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000113f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000112b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000111827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000701fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fd800078e00ffULL, 0x8000002469690221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x0000006900090308ULL, 0x000e640000000800ULL, 0x0000000968680220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002268227221ULL, 0x004fc20000010000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006a277984ULL, 0x008e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x000000261e697210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e1fULL, 0x003d09006900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910251e7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x00010d427f007947ULL, 0x000fea000b800000ULL,
0x00001f1e27077589ULL, 0x0002a400000e0000ULL, 0x000000081e267810ULL, 0x000fe20007ffe0ffULL,
0x00010d627f007947ULL, 0x000fea000b800000ULL, 0x000000101e047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000181e267810ULL, 0x008fe20007ffe0ffULL, 0x00010d927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041a1e7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a207824ULL, 0x040fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000010001a1f7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000803267824ULL, 0x008fe200078e00ffULL, 0xfffff00020207812ULL, 0x000fc400078ec0ffULL,
0x0000001e171e7211ULL, 0x000fe400078fe0ffULL, 0x0000b00020207810ULL, 0x000fe40007ffe0ffULL,
0xffffe0001f217812ULL, 0x000fe200078ec0ffULL, 0x00000001031f7824ULL, 0x000fe400078e021eULL,
0x000000101c707824ULL, 0x100fe200078e0220ULL, 0x0000f00021257810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0220ULL, 0xfffffff8261c7812ULL, 0x000fc600078ee21fULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000101c7c7824ULL, 0x000fe400078e0225ULL,
0x000000001d68783bULL, 0x0006a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x086fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fc40000000000ULL,
0x0000000568687232ULL, 0x080fe40000000000ULL, 0x000000056a6a7232ULL, 0x000fe40000000000ULL,
0x0000000469697232ULL, 0x080fe40000000000ULL, 0x000000046b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803267824ULL, 0x000fe200078e00ffULL,
0x000000021f217810ULL, 0x000fe20007ffe0ffULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000091000007945ULL, 0x000fe40003800000ULL, 0xfffffff826217812ULL, 0x000fca00078ee221ULL,
0x0000001021787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x00000018ff1f7819ULL, 0x010fe4000001147dULL, 0x00000018ff277819ULL, 0x000fe4000001147fULL,
0x0000001f00817306ULL, 0x0009e20000200c00ULL, 0x00000018ff267819ULL, 0x000fe4000001147eULL,
0x00000018ff1d7819ULL, 0x008fe4000001147cULL, 0x000088807f857816ULL, 0x000fc600000000ffULL,
0x0000002700897306ULL, 0x0007e20000200c00ULL, 0x000001007c1f7824ULL, 0x010fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011478ULL, 0x00000018ff837819ULL, 0x000fe4000001147bULL,
0x00000018ff807819ULL, 0x000fe40000011479ULL, 0x00000077008b7306ULL, 0x0009e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x000088807d277816ULL, 0x008fc400000000ffULL,
0x00000018ff827819ULL, 0x000fc6000001147aULL, 0x0000008300957306ULL, 0x0007e20000200c00ULL,
0x000001007d777824ULL, 0x050fe400078e00ffULL, 0x000100007d7d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x0000002600867306ULL, 0x000fe20000200c00ULL,
0x000001007e837824ULL, 0x008fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fc8000001147dULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000001d00257306ULL, 0x0007f00000200c00ULL,
0x0000001f00267306ULL, 0x0009e20000200c00ULL, 0x000088807c1d7816ULL, 0x048fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x00000080008f7306ULL, 0x000fe20000200c00ULL, 0x000088807e1f7816ULL, 0x050fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000007700807306ULL, 0x0007f00000200c00ULL, 0x0000008300847306ULL, 0x0009e20000200c00ULL,
0x000001007f777824ULL, 0x008fc400078e00ffULL, 0x000100007f7f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011477ULL, 0x0000008200947306ULL, 0x000fe20000200c00ULL,
0x0000010078837824ULL, 0x010fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc8000001147fULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000001d001d7306ULL, 0x000ef00000200c00ULL,
0x0000007d00827306ULL, 0x0009f00000200c00ULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x00008880787d7816ULL, 0x050fe200000000ffULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x000054101d267816ULL, 0x008fc80000000026ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007e00777306ULL, 0x0007300000200c00ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x00000100797e7824ULL, 0x008fe200078e00ffULL, 0x0000541027277816ULL, 0x004fc80000000080ULL,
0x00000018ff8d7819ULL, 0x000fe4000001147eULL, 0x0000007f008a7306ULL, 0x0005e20000200c00ULL,
0x000000267064723cULL, 0x002f620000001864ULL, 0x0000541077867816ULL, 0x010fcc0000000086ULL,
0x00000083008c7306ULL, 0x0003e20000200c00ULL, 0x000088807a7f7816ULL, 0x044fe200000000ffULL,
0x000000266844723cULL, 0x000b6c0000001844ULL, 0x0000008700887306ULL, 0x0005e20000200c00ULL,
0x000001007a837824ULL, 0x042fe400078e00ffULL, 0x000100007a7a7824ULL, 0x000fc400078e00ffULL,
0x0000000102277824ULL, 0x020fe200078e021eULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000078007e7306ULL, 0x0002e20000200c00ULL, 0x0000888079877816ULL, 0x044fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fc8000001147aULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x00000087008e7306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007a001d7306ULL, 0x000e620000200c00ULL, 0x000088807b877816ULL, 0x044fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fe200078e00ffULL, 0x000054107e7e7816ULL, 0x008fc8000000008bULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007800807306ULL, 0x0005f00000200c00ULL,
0x0000001f001f7306ULL, 0x000ee20000200c00ULL, 0x000054107c787816ULL, 0x004fe20000000025ULL,
0x000000021a257824ULL, 0x000fe200078e00ffULL, 0x000054101d947816ULL, 0x002fc80000000094ULL,
0x00000004251d7812ULL, 0x000fe200078ec0ffULL, 0x0000008500857306ULL, 0x000e660000200c00ULL,
0x000000021d267812ULL, 0x000fc800078efcffULL, 0x0000002617267211ULL, 0x000fe200078fe0ffULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x000054101f847816ULL, 0x008fe20000000084ULL,
0x00000008021f7824ULL, 0x040fe400078e00ffULL, 0x00000001031d7824ULL, 0x100fe400078e0226ULL,
0x0000000102267824ULL, 0x000fe400078e0226ULL, 0x0000008d008d7306ULL, 0x000ee20000200c00ULL,
0x0000541085857816ULL, 0x002fc40000000088ULL, 0xfffffff81f1e7812ULL, 0x000fe400078ee226ULL,
0x0000100000267810ULL, 0x000fc60007ffe0ffULL, 0x0000007900907306ULL, 0x0003220000200c00ULL,
0x000054107d8c7816ULL, 0x004fe2000000008cULL, 0x00000084705c723cULL, 0x080f6c000000185cULL,
0x0000007f00917306ULL, 0x0009e20000200c00ULL, 0x0000541082797816ULL, 0x002fe20000000081ULL,
0x00000084683c723cULL, 0x000f62000000183cULL, 0x000054108e8d7816ULL, 0x008fca000000008dULL,
0x0000008300927306ULL, 0x000e620000200c00ULL, 0x00005410907f7816ULL, 0x010fe2000000008fULL,
0x000000787060723cULL, 0x040f6c0000001860ULL, 0x0000008700937306ULL, 0x0004e40000200c00ULL,
0x0000008c7054723cULL, 0x040f6c0000001854ULL, 0x0000007b007c7306ULL, 0x000f220000200c00ULL,
0x000054108a877816ULL, 0x004fe20000000089ULL, 0x0000007e7050723cULL, 0x000f620000001850ULL,
0x0000541091927816ULL, 0x002fc40000000092ULL, 0x0000541093937816ULL, 0x008fca0000000080ULL,
0x000000867058723cULL, 0x000f620000001858ULL, 0x000054107c957816ULL, 0x010fce0000000095ULL,
0x00000092704c723cULL, 0x040f70000000184cULL, 0x000000947048723cULL, 0x000b6e0000001848ULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x000000786840723cULL, 0x000f620000001840ULL,
0x0000000802727824ULL, 0x000fc600078e00ffULL, 0xfffffff8701d7812ULL, 0x000fe400078ee21dULL,
0xfffffff8721f7812ULL, 0x000fe400078ee227ULL, 0x000000866838723cULL, 0x040f620000001838ULL,
0x000000101d707824ULL, 0x100fe400078e0220ULL, 0x000000101e207824ULL, 0x000fe400078e0220ULL,
0x000000101f7c7824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x0000008c6834723cULL, 0x040f700000001834ULL, 0x0000007e6830723cULL, 0x040f700000001830ULL,
0x00000092682c723cULL, 0x040f70000000182cULL, 0x000000946828723cULL, 0x000b640000001828ULL,
0x000000002068783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707232ULL, 0x082fe40000000000ULL,
0x0000000772727232ULL, 0x000fc40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fe40000000000ULL, 0x0000000568687232ULL, 0x088fe40000000000ULL,
0x000000056a6a7232ULL, 0x000fe40000000000ULL, 0x0000000469697232ULL, 0x080fe40000000000ULL,
0x000000046b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000802777824ULL, 0x000fe200078e00ffULL, 0x0000000227207810ULL, 0x004fe20007ffe0ffULL,
0x000000007c7c783bULL, 0x000ea60000004200ULL, 0xfffffff877207812ULL, 0x000fca00078ee220ULL,
0x0000001020787824ULL, 0x000fcc00078e0226ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000018ff277819ULL, 0x004fe4000001147dULL, 0x00000018ff817819ULL, 0x000fe4000001147fULL,
0x00000018ff267819ULL, 0x000fe2000001147cULL, 0x0000002700827306ULL, 0x0005e20000200c00ULL,
0x00000018ff807819ULL, 0x000fce000001147eULL, 0x0000008100887306ULL, 0x0007e20000200c00ULL,
0x000001007c277824ULL, 0x004fe200078e00ffULL, 0x00000018ff837819ULL, 0x010fe20000011478ULL,
0x00000100788a7824ULL, 0x040fe200078e00ffULL, 0x0000888078897816ULL, 0x040fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x00000100798d7824ULL, 0x000fe200078e00ffULL, 0x0000002600777306ULL, 0x0005e20000200c00ULL,
0x000001007d817824ULL, 0x008fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x000001007a927824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001148dULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000008000857306ULL, 0x0007e20000200c00ULL,
0x000088807c267816ULL, 0x044fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe40000011479ULL, 0x00000018ff867819ULL, 0x000fe4000001147aULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x000088807d807816ULL, 0x048fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc4000001147bULL, 0x000088807b937816ULL, 0x000fe400000000ffULL,
0x00008880798b7816ULL, 0x040fe200000000ffULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x000088807a917816ULL, 0x040fe200000000ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x00000018ff797819ULL, 0x000fc40000011479ULL,
0x00000018ff7a7819ULL, 0x000fca000001147aULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x0000541026267816ULL, 0x004fce0000000027ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x00000078008d7306ULL, 0x0005e20000200c00ULL, 0x0000541080277816ULL, 0x008fce0000000081ULL,
0x00000083008c7306ULL, 0x0007220000200c00ULL, 0x000001007b787824ULL, 0x044fe200078e00ffULL,
0x000000267064723cULL, 0x002f620000001864ULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000084008f7306ULL, 0x0003e20000200c00ULL,
0x000088807e837816ULL, 0x048fe200000000ffULL, 0x000000266844723cULL, 0x000b6c0000001844ULL,
0x0000008600947306ULL, 0x0005e20000200c00ULL, 0x000001007e847824ULL, 0x042fe200078e00ffULL,
0x000054108d8c7816ULL, 0x010fe2000000008cULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0xfffffff825267812ULL, 0x020fc400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000008700957306ULL, 0x0003e20000200c00ULL, 0x000088807f867816ULL, 0x004fe400000000ffULL,
0x00000018ff7e7819ULL, 0x000fca000001147eULL, 0x0000007800807306ULL, 0x0005e20000200c00ULL,
0x000001007f877824ULL, 0x042fe400078e00ffULL, 0x000100007f7f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054107c787816ULL, 0x004fe40000000077ULL,
0x00000018ff7c7819ULL, 0x000fca000001147bULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008400847306ULL, 0x000ff00000200c00ULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008700877306ULL, 0x000e700000200c00ULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000007f007f7306ULL, 0x000ee20000200c00ULL, 0x00005410867b7816ULL, 0x002fce0000000087ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054107e7e7816ULL, 0x004fce0000000085ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x000054107f7f7816ULL, 0x008fce0000000088ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000007e7058723cULL, 0x080f6e0000001858ULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x00005410898a7816ULL, 0x002fe2000000008aULL,
0x0000007e6838723cULL, 0x000f6c0000001838ULL, 0x0000007900907306ULL, 0x0002f00000200c00ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x000054107d797816ULL, 0x002fc40000000082ULL,
0x000054108b8b7816ULL, 0x004fca000000008eULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x00005410908d7816ULL, 0x008fe2000000008fULL, 0x000000787060723cULL, 0x040f6c0000001860ULL,
0x0000009300937306ULL, 0x000ea40000200c00ULL, 0x0000008a7054723cULL, 0x040f6c0000001854ULL,
0x0000007a00777306ULL, 0x0007220000200c00ULL, 0x0000541091927816ULL, 0x002fe20000000092ULL,
0x0000008c7050723cULL, 0x000f6c0000001850ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x00005410837a7816ULL, 0x008fe20000000084ULL, 0x000000786840723cULL, 0x000f620000001840ULL,
0x0000541093937816ULL, 0x004fc40000000080ULL, 0x0000541077947816ULL, 0x010fca0000000094ULL,
0x0000007a705c723cULL, 0x000f62000000185cULL, 0x000054107c957816ULL, 0x002fce0000000095ULL,
0x00000092704c723cULL, 0x040f70000000184cULL, 0x000000947048723cULL, 0x000f700000001848ULL,
0x0000007a683c723cULL, 0x040f70000000183cULL, 0x0000008a6834723cULL, 0x040f700000001834ULL,
0x0000008c6830723cULL, 0x040f700000001830ULL, 0x00000092682c723cULL, 0x040f70000000182cULL,
0x000000946828723cULL, 0x000b6e0000001828ULL, 0x000126c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x000004000d697984ULL, 0x000ea40000000800ULL, 0x8000000069ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000687805ULL, 0x000fcc0000015200ULL,
0x0000006826717210ULL, 0x000fca0007f1e1ffULL, 0x0000000169697824ULL, 0x000fe200000e0e27ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff687819ULL, 0x000fc80000011469ULL, 0x0000007168687211ULL, 0x000fca00078110ffULL,
0x000000ffff697224ULL, 0x000fca00000e0669ULL, 0x0000000268687819ULL, 0x000fc80000001269ULL,
0x000000680000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d697984ULL, 0x000e640000000800ULL, 0x8000000069ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00c277810ULL, 0x000fca0007ffe0ffULL,
0x0000680012717a24ULL, 0x000fe200078e0227ULL, 0x000003e00000a947ULL, 0x000fea0003800000ULL,
0x0000002716257217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff687819ULL, 0x000fe40000011617ULL, 0x0000100000797810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a27ULL, 0x0000000468697810ULL, 0x000fe20007ffe0ffULL,
0x0000000170267824ULL, 0x000fe200078e0268ULL, 0x00000008686b7810ULL, 0x000fe40007ffe0ffULL,
0x0000002570257217ULL, 0x000fe20007800000ULL, 0x0000000126277824ULL, 0x000fc400078e0217ULL,
0x0000000826727824ULL, 0x040fe400078e00ffULL, 0x0000000125257824ULL, 0x000fe400078e0a70ULL,
0x0000000126267824ULL, 0x000fe200078e0271ULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x0000000170787824ULL, 0x000fe200078e0269ULL, 0x000000256900720cULL, 0x080fe20003f86070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c68697810ULL, 0x040fe40007ffe0ffULL,
0x000000256800720cULL, 0x080fe20003fa6070ULL, 0x0000000178687824ULL, 0x000fe200078e0271ULL,
0x000000256900720cULL, 0x000fe20003f06070ULL, 0x00000001707c7824ULL, 0x000fe200078e0269ULL,
0x0000000b266a7212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x000000256b00720cULL, 0x000fc40003f66070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x00000001707a7824ULL, 0x000fe200078e026bULL, 0x0000000b68707212ULL, 0x000fe200078efcffULL,
0x0000000178257824ULL, 0x000fe200078e0217ULL, 0x00006500276b7a10ULL, 0x000fe200037fe4ffULL,
0x000000017a267824ULL, 0x000fe200078e0271ULL, 0x0000640070707a10ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee225ULL, 0x000000017c687824ULL, 0x000fe200078e0271ULL,
0x0000650069717a10ULL, 0x000fe200037fe4ffULL, 0x000000017a737824ULL, 0x000fe200078e0217ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fc600078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x000000017c257824ULL, 0x040fe200078e0217ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x000000087c7c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee273ULL, 0x0000001078737824ULL, 0x000fe200078e0279ULL,
0x0000640068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee225ULL,
0x0000001072257824ULL, 0x100fe200078e0279ULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x000000107a777824ULL, 0x000fc400078e0279ULL, 0x000000107c797824ULL, 0x000fe200078e0279ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a257faeULL, 0x0003e8000e901c46ULL,
0x0000000070737faeULL, 0x0003e8000e101c46ULL, 0x0000000026777faeULL, 0x0003e8000d901c46ULL,
0x0000000068797faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fe200078e00ffULL, 0x0000100000797810ULL, 0x000fc80007ffe0ffULL,
0x0000002617687211ULL, 0x000fc800078fe8ffULL, 0x00000004686a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000168267824ULL, 0x040fe200078e0271ULL, 0x0000000868787810ULL, 0x040fe20007ffe0ffULL,
0x0000000168257824ULL, 0x040fe200078e0217ULL, 0x0000000c687a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000868727824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000016a257824ULL, 0x000fe200078e0271ULL,
0x0000000b26707212ULL, 0x000fe200078efcffULL, 0x000000016a697824ULL, 0x040fe400078e0217ULL,
0x000000086a7c7824ULL, 0x000fe200078e00ffULL, 0x0000640070707a10ULL, 0x000fe20007f1e0ffULL,
0x0000000178687824ULL, 0x100fe400078e0271ULL, 0x000000017a6a7824ULL, 0x040fe400078e0271ULL,
0x000000017a267824ULL, 0x000fc400078e0217ULL, 0x000000087a717824ULL, 0x000fe400078e00ffULL,
0x00000001786b7824ULL, 0x040fe400078e0217ULL, 0x00000008787e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87c787812ULL, 0x000fe200078ee269ULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0xfffffff8717c7812ULL, 0x000fe400078ee226ULL, 0x0000650027717a10ULL, 0x000fe200007fe4ffULL,
0x0000008025267825ULL, 0x000fe200078e00ffULL, 0xfffffff87e7a7812ULL, 0x000fc400078ee26bULL,
0x0000000b68687212ULL, 0x080fe200078efcffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000640068687a10ULL, 0x000fe20007f7e0ffULL,
0x0000001072257824ULL, 0x100fe200078e0279ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000001078737824ULL, 0x100fe200078e0279ULL, 0x0000640026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000107a777824ULL, 0x100fe200078e0279ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x000000107c797824ULL, 0x000fe200078e0279ULL, 0x0000650027277a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000070257faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fc40001ffe4ffULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026737faeULL, 0x0003e8000b901c46ULL, 0x0000000068777faeULL, 0x0003e8000b901c46ULL,
0x000000006a797faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff014687812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b00068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126480023707f8cULL, 0x0004e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0xffffffe014237812ULL, 0x044fe400078ec0ffULL,
0x00000010146a7812ULL, 0x040fe400078ec0ffULL, 0x0000000814257812ULL, 0x000fc800078ec0ffULL,
0x0000002325237210ULL, 0x000fca0007ffe06aULL, 0x01264c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146bULL, 0x0000006a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000225257819ULL, 0x000fc8000000126aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01264c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a237824ULL, 0x000fca00078e00ffULL,
0xffffff8023267812ULL, 0x000fc800078ec0ffULL, 0x000001000b237810ULL, 0x000fca0007ffe026ULL,
0x000000010a237824ULL, 0x000fca00078e0223ULL, 0x0120000023717984ULL, 0x000ea80000000800ULL,
0x0122000023707984ULL, 0x0006620000000800ULL, 0x000000247100720bULL, 0x004fe20003f1d000ULL,
0x0000ed027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0024ULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x0000000210237810ULL, 0x000fe40007ffe0ffULL,
0x000000247100720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x0000ecb27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x000000801a278824ULL, 0x000fe200078e020bULL, 0x0000002471257209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0005e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x8000002524257221ULL, 0x004fe20000010000ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000ebf27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000eab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000e9727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000e8427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000002372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6a7424ULL, 0x000fe200078e00ffULL,
0x0000002471237209ULL, 0x000fd60007810000ULL, 0x8000002371710221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b71710820ULL, 0x000fc80000410000ULL,
0x0000007100090308ULL, 0x000ea40000000800ULL, 0x0000000970700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002270227221ULL, 0x002fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106a247816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff247819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000e4027f007947ULL, 0x000fea000b800000ULL, 0x00001f2427077589ULL, 0x0002a400000e0000ULL,
0x0000000824267810ULL, 0x000fe20007ffe0ffULL, 0x0000e4227f007947ULL, 0x000fea000b800000ULL,
0x0000001024047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x0000001824267810ULL, 0x008fe20007ffe0ffULL,
0x0000e4527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021a6a7824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a267824ULL, 0x008fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000008036c7824ULL, 0x000fe200078e00ffULL,
0x000000046a247812ULL, 0x002fe200078ec0ffULL, 0x0000000802277824ULL, 0x000fe200078e00ffULL,
0xfffff000266b7812ULL, 0x000fe200078ec0ffULL, 0x000000101c7c7824ULL, 0x000fe200078e0200ULL,
0x0000002417247211ULL, 0x000fc400078fe0ffULL, 0x0000c0006b6b7810ULL, 0x000fc60007ffe0ffULL,
0x0000000103257824ULL, 0x100fe400078e0224ULL, 0x0000000102267824ULL, 0x000fc600078e0224ULL,
0xfffffff86c247812ULL, 0x000fe400078ee225ULL, 0xfffffff827267812ULL, 0x000fc600078ee226ULL,
0x0000001024707824ULL, 0x100fe400078e026bULL, 0x0000001026267824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002624783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707232ULL, 0x086fe40000000000ULL,
0x0000000772727232ULL, 0x000fe40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x0000001021787824ULL, 0x000fe200078e0200ULL,
0x0000082000007945ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x00000018ff807819ULL, 0x010fe2000001147fULL, 0x000001007f877824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001147dULL, 0x0000008000897306ULL, 0x0009e20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fe4000001147eULL, 0x00000018ff217819ULL, 0x000fe2000001147cULL,
0x00000100788c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe2000001147bULL,
0x000100007a927824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011479ULL,
0x0000006c00817306ULL, 0x0007e20000200c00ULL, 0x000001007d807824ULL, 0x010fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fc4000001147aULL, 0x00000018ff827819ULL, 0x000fe40000011478ULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000006d00867306ULL, 0x0009e20000200c00ULL,
0x000001007c6c7824ULL, 0x008fe200078e00ffULL, 0x00008880788b7816ULL, 0x040fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff6c7819ULL, 0x000fc4000001146cULL, 0x0000002100777306ULL, 0x0007e20000200c00ULL,
0x000088807d6d7816ULL, 0x050fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff927819ULL, 0x000fe40000011492ULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000088807c217816ULL, 0x048fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fc4000001148cULL, 0x000088807a917816ULL, 0x000fe400000000ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000008000807306ULL, 0x000ef00000200c00ULL,
0x0000008500947306ULL, 0x0009f00000200c00ULL, 0x00000083008f7306ULL, 0x0005e20000200c00ULL,
0x000088807f857816ULL, 0x050fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x000054106d6d7816ULL, 0x008fe20000000080ULL, 0x000001007b807824ULL, 0x000fc600078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008400937306ULL, 0x0007e20000200c00ULL,
0x000088807e837816ULL, 0x004fe400000000ffULL, 0x00000018ff807819ULL, 0x000fca0000011480ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x000001007e847824ULL, 0x048fe400078e00ffULL,
0x000100007e7e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff7e7819ULL, 0x000fce000001147eULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000008700887306ULL, 0x0007e20000200c00ULL,
0x00005410216c7816ULL, 0x004fce000000006cULL, 0x00000082008e7306ULL, 0x000fe20000200c00ULL,
0x0000888079877816ULL, 0x048fe200000000ffULL, 0x0000006c7064723cULL, 0x082f6c0000001864ULL,
0x0000007d00827306ULL, 0x000fe40000200c00ULL, 0x0000006c2444723cULL, 0x000f6c0000001844ULL,
0x0000007f008a7306ULL, 0x000ff00000200c00ULL, 0x0000007e007d7306ULL, 0x0002b00000200c00ULL,
0x00000078007f7306ULL, 0x0007220000200c00ULL, 0x00000100797e7824ULL, 0x002fc400078e00ffULL,
0x0001000079797824ULL, 0x000fc600078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000087008d7306ULL, 0x0003e20000200c00ULL, 0x000088807b787816ULL, 0x048fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x000054107d867816ULL, 0x004fe20000000086ULL, 0x000000ffff217224ULL, 0x000fe200078e0078ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000009200927306ULL, 0x000ea20000200c00ULL,
0x000001007a877824ULL, 0x002fe200078e00ffULL, 0x000054107c787816ULL, 0x000fe20000000077ULL,
0x000000101f7c7824ULL, 0x000fe200078e0200ULL, 0x000054107f8e7816ULL, 0x010fc4000000008eULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x0000541092927816ULL, 0x004fce0000000093ULL,
0x0000008500857306ULL, 0x000eb00000200c00ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541083847816ULL, 0x002fce0000000084ULL, 0x0000008c008c7306ULL, 0x000e620000200c00ULL,
0x0000541085857816ULL, 0x004fce0000000088ULL, 0x0000007e007e7306ULL, 0x000ea20000200c00ULL,
0x00000084705c723cULL, 0x080f6e000000185cULL, 0x0000007900907306ULL, 0x0007220000200c00ULL,
0x000054108b8c7816ULL, 0x002fe2000000008cULL, 0x00000084243c723cULL, 0x000f6c000000183cULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x0000541082797816ULL, 0x008fc40000000081ULL,
0x000054108d8d7816ULL, 0x004fca000000007eULL, 0x00000087007a7306ULL, 0x0002a20000200c00ULL,
0x00005410908f7816ULL, 0x010fe2000000008fULL, 0x000000787060723cULL, 0x040f6c0000001860ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x000054108a877816ULL, 0x002fe20000000089ULL,
0x0000008c7054723cULL, 0x040f6c0000001854ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x00005410917a7816ULL, 0x004fe2000000007aULL, 0x000000867058723cULL, 0x040f6c0000001858ULL,
0x0000007b00777306ULL, 0x0002a40000200c00ULL, 0x0000008e7050723cULL, 0x000f620000001850ULL,
0x00005410217b7816ULL, 0x002fce0000000080ULL, 0x000000782440723cULL, 0x000f620000001840ULL,
0x0000541077937816ULL, 0x004fce0000000094ULL, 0x0000007a704c723cULL, 0x040f70000000184cULL,
0x000000927048723cULL, 0x000b6e0000001848ULL, 0x000000101d707824ULL, 0x120fe200078e026bULL,
0x000000862438723cULL, 0x000f620000001838ULL, 0x000000101e6b7824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x0000008c2434723cULL, 0x040f700000001834ULL,
0x0000008e2430723cULL, 0x040f700000001830ULL, 0x0000007a242c723cULL, 0x040f70000000182cULL,
0x000000922428723cULL, 0x000b640000001828ULL, 0x000000006b24783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707232ULL, 0x082fe40000000000ULL, 0x0000000772727232ULL, 0x000fc40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fe40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020787824ULL, 0x000fe200078e0200ULL,
0x000000007c7c783bULL, 0x000f2a0000004200ULL, 0x000000007878783bULL, 0x000ea40000004200ULL,
0x00000018ff6b7819ULL, 0x014fe2000001147eULL, 0x000001007e847824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc4000001147cULL, 0x00000018ff217819ULL, 0x000fe2000001147dULL,
0x0000006b00867306ULL, 0x0005e20000200c00ULL, 0x00000018ff777819ULL, 0x000fe20000011478ULL,
0x0000010078897824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011479ULL,
0x000100007a907824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001147fULL,
0x000001007a8f7824ULL, 0x000fe200078e00ffULL, 0x000088807f857816ULL, 0x000fe200000000ffULL,
0x00000020006c7306ULL, 0x0009e20000200c00ULL, 0x000001007d6b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fc4000001147bULL, 0x00000018ff827819ULL, 0x000fe4000001147aULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x0000002100817306ULL, 0x0005e20000200c00ULL,
0x000088807c207816ULL, 0x050fe400000000ffULL, 0x00008880798b7816ULL, 0x000fe400000000ffULL,
0x00000018ff907819ULL, 0x000fe40000011490ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x00000077008c7306ULL, 0x0009e20000200c00ULL, 0x000001007c217824ULL, 0x044fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000080008d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff777819ULL, 0x010fe4000001146bULL, 0x00000018ff7c7819ULL, 0x000fca000001147cULL,
0x0000007700807306ULL, 0x0005f00000200c00ULL, 0x0000006d00877306ULL, 0x0009e20000200c00ULL,
0x000001007f777824ULL, 0x044fe400078e00ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x0000007c006b7306ULL, 0x0004e20000200c00ULL, 0x000088807d6d7816ULL, 0x050fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc8000001147fULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000008300927306ULL, 0x0009e20000200c00ULL,
0x00000018ff7c7819ULL, 0x004fce0000011477ULL, 0x0000007f00887306ULL, 0x0004620000200c00ULL,
0x000088807e837816ULL, 0x050fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x000054106b6c7816ULL, 0x008fe2000000006cULL, 0x000100007b6b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008200917306ULL, 0x000fe20000200c00ULL,
0x00010000797f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc8000001146bULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007d00827306ULL, 0x0005e20000200c00ULL,
0x0000541088877816ULL, 0x002fce0000000087ULL, 0x0000007e00777306ULL, 0x0002e20000200c00ULL,
0x00008880787d7816ULL, 0x044fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007f008e7306ULL, 0x0005220000200c00ULL,
0x00000100797e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000089008a7306ULL, 0x0003e20000200c00ULL, 0x000001007b7f7824ULL, 0x004fe200078e00ffULL,
0x0000541077867816ULL, 0x008fc80000000086ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007800797306ULL, 0x0004e20000200c00ULL, 0x000088807a897816ULL, 0x002fe200000000ffULL,
0x000000867058723cULL, 0x000f620000001858ULL, 0x000054108e8d7816ULL, 0x010fca000000008dULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000088807b787816ULL, 0x004fe200000000ffULL,
0x000000862438723cULL, 0x000f6c0000001838ULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x00005410798c7816ULL, 0x008fce000000008cULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x0000008c7050723cULL, 0x080f6e0000001850ULL, 0x0000009000907306ULL, 0x000ee20000200c00ULL,
0x0000541020207816ULL, 0x002fe20000000021ULL, 0x0000008c2430723cULL, 0x000f6c0000001830ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000054106d217816ULL, 0x004fc40000000080ULL,
0x00005410826d7816ULL, 0x000fca0000000081ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x0000541090907816ULL, 0x008fe20000000091ULL, 0x0000006c7060723cULL, 0x040f6c0000001860ULL,
0x0000008500857306ULL, 0x000fe40000200c00ULL, 0x000000207064723cULL, 0x080f6c0000001864ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541083847816ULL, 0x002fe20000000084ULL,
0x000000202444723cULL, 0x040b6c0000001844ULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0xfffffff86a207812ULL, 0x020fe200078ec0ffULL, 0x0000006c2440723cULL, 0x000f6c0000001840ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000541085857816ULL, 0x004fce000000007cULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x000054107d8a7816ULL, 0x002fe2000000008aULL,
0x00000084705c723cULL, 0x080f6c000000185cULL, 0x0000008900897306ULL, 0x000fe40000200c00ULL,
0x00000084243c723cULL, 0x000f6c000000183cULL, 0x0000008f007a7306ULL, 0x000e620000200c00ULL,
0x000054108b8b7816ULL, 0x004fce000000007eULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000008a7054723cULL, 0x080f6e0000001854ULL, 0x0000007f007b7306ULL, 0x000ea20000200c00ULL,
0x00005410897a7816ULL, 0x002fe2000000007aULL, 0x0000008a2434723cULL, 0x000f6c0000001834ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x00005410787b7816ULL, 0x004fce000000007bULL,
0x0000007a704c723cULL, 0x000f62000000184cULL, 0x000054106b917816ULL, 0x002fce0000000092ULL,
0x000000907048723cULL, 0x000f700000001848ULL, 0x0000007a242c723cULL, 0x040f70000000182cULL,
0x000000902428723cULL, 0x000b6e0000001828ULL, 0x000126c813267811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000026267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126980020ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x004fc80000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc40007804827ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000006b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f207810ULL, 0x000fc80007ffe0ffULL,
0x000000152000720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f207810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152000720cULL, 0x000fc60003f06070ULL, 0x00006800126c7a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x0000001011277824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004256b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127207824ULL, 0x000fe200078e0225ULL, 0x0000000825717810ULL, 0x000fe40007ffe0ffULL,
0x0000000c270c7217ULL, 0x000fe20007800000ULL, 0x0000000120217824ULL, 0x040fe200078e0217ULL,
0x0000000c25737810ULL, 0x000fe20007ffe0ffULL, 0x0000000820247824ULL, 0x000fe400078e00ffULL,
0x0000000127707824ULL, 0x000fc400078e026bULL, 0x0000000120207824ULL, 0x100fe200078e026cULL,
0xfffffff8246d7812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a27ULL,
0x0000000170247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x080fe40003f06070ULL, 0x0000000c7100720cULL, 0x080fe20003f66070ULL,
0x0000000127727824ULL, 0x000fe200078e0271ULL, 0x0000000b206a7212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000c6b00720cULL, 0x000fc40003f86070ULL,
0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000172267824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x080fe200078efcffULL, 0x0000000127777824ULL, 0x000fe200078e0273ULL,
0x00006500216b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000640024247a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7300720cULL, 0x000fe20003fa6070ULL,
0x0000000177207824ULL, 0x000fe200078e026cULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x00000001706c7824ULL, 0x040fe200078e0217ULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x0000000870717824ULL, 0x000fe200078e00ffULL, 0x0000640026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x00000001720c7824ULL, 0x100fe200078e0217ULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x0000000872737824ULL, 0x000fe200078e00ffULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001776c7824ULL, 0x040fe200078e0217ULL, 0x0000640020207a10ULL, 0x000fe20007fde0ffULL,
0x0000000877777824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee20cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000650021217a10ULL, 0x000fe200037fe4ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff877777812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c46ULL, 0x0000001077777824ULL, 0x000fe200078e0200ULL,
0x0000000024717faeULL, 0x0003e8000e101c46ULL, 0x0000000026737faeULL, 0x0003e8000d901c46ULL,
0x0000000020777faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c247810ULL, 0x040fe20007ffe0ffULL, 0x000000010c207824ULL, 0x140fe200078e0217ULL,
0x000000080c267810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6d7824ULL, 0x000fe400078e00ffULL,
0x0000000124217824ULL, 0x140fe400078e0217ULL, 0x00000008246a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL, 0x000000010c207824ULL, 0x040fe200078e026cULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126257824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee221ULL, 0x0000000826707824ULL, 0x000fc400078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee225ULL, 0x0000000126267824ULL, 0x100fe200078e026cULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x000000010c6a7824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fc60007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000b24247212ULL, 0x080fe400078efcffULL,
0x0000650021217a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000640024247a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c6c7824ULL, 0x000fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000080c777824ULL, 0x000fe200078e00ffULL, 0x0000640026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff877777812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000650025257a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000b901c46ULL,
0x0000650027277a10ULL, 0x000fe200007fe4ffULL, 0x0000001077777824ULL, 0x000fe200078e0200ULL,
0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000024717faeULL, 0x0003e8000b901c46ULL,
0x0000000026737faeULL, 0x0003e8000b901c46ULL, 0x000000006a777faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x012668000c267f8cULL, 0x000664000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01266c000c257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011425ULL, 0x0000006b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01200000080c7984ULL, 0x008e680000000800ULL,
0x0122000008207984ULL, 0x0006a20000000800ULL, 0x000000230c00720bULL, 0x002fe20003f1d000ULL,
0x0000c5127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x008fc800000e0100ULL,
0x000000ff2100720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310257810ULL, 0x000fe40007ffe0ffULL,
0x000000230c00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x0000c4c27f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x004fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000230c087209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0b8824ULL, 0x000fca00078e020bULL,
0x012400080b008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000023080a7221ULL, 0x002fe20000010100ULL,
0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000c4027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000c2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000c1827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000c0527f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006c21ff7212ULL, 0x000fda00078030ffULL, 0x0000000c080c0221ULL, 0x000fe20000010100ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL,
0x0000000c00090308ULL, 0x000e640000000800ULL, 0x0000000920200220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002220227221ULL, 0x004fc20000010000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0xfffffff014267812ULL, 0x000fca00078ec0ffULL,
0x0126b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000200a237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e0bULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011421ULL,
0x000000230c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x000000020c0c7819ULL, 0x000fc80000001221ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910240a7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000bc227f007947ULL, 0x000fea000b800000ULL,
0x00001f0a27077589ULL, 0x0002a400000e0000ULL, 0x000000080a267810ULL, 0x000fe20007ffe0ffULL,
0x0000bc427f007947ULL, 0x000fea000b800000ULL, 0x000000100a047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000180a267810ULL, 0x008fe20007ffe0ffULL, 0x0000bc727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001130a7812ULL, 0x002fe200078ec0ffULL, 0x0000000803207824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802217824ULL, 0x000fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000040a0a7824ULL, 0x000fc400078e020bULL,
0x000000101c707824ULL, 0x000fe400078e0200ULL, 0x00000001030b7824ULL, 0x100fe400078e020aULL,
0x00000001020c7824ULL, 0x000fc600078e020aULL, 0xfffffff8200a7812ULL, 0x000fe200078ee20bULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x0000d000100b7811ULL, 0x000fe400078e60ffULL,
0xfffffff8210c7812ULL, 0x000fe400078ee20cULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x100fe400078e020bULL, 0x000000100c0c7824ULL, 0x000fe200078e020bULL,
0x00000002201c7812ULL, 0x000fc400078efcffULL, 0x000000000a68783bULL, 0x0002e80000000200ULL,
0x000000000c24783bULL, 0x0082e20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687232ULL, 0x084fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fe40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001c170a7211ULL, 0x002fe200078fe0ffULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x000000101e1e7824ULL, 0x000fe200078e020bULL, 0x0000083000007945ULL, 0x000fe20003800000ULL,
0x0000000103037824ULL, 0x000fca00078e020aULL, 0xfffffff80c037812ULL, 0x000fca00078ee203ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000374783bULL, 0x0008e20000004200ULL,
0x00000018ff207819ULL, 0x002fe20000011471ULL, 0x00010000737d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe40000011470ULL, 0x0000002000787306ULL, 0x0003e20000200c00ULL,
0x0000888070037816ULL, 0x010fe400000000ffULL, 0x00000018ff237819ULL, 0x000fe40000011473ULL,
0x00000018ff217819ULL, 0x000fc40000011472ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000000c001c7306ULL, 0x0009e20000200c00ULL, 0x0000888071207816ULL, 0x002fe400000000ffULL,
0x00000018ff6c7819ULL, 0x008fe20000011474ULL, 0x0000010074817824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011475ULL, 0x00000100700c7824ULL, 0x050fe400078e00ffULL,
0x0000006c00847306ULL, 0x000fe20000200c00ULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc40000011476ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000020006c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011477ULL, 0x0000888077897816ULL, 0x000fe400000000ffULL,
0x00000018ff817819ULL, 0x000fc60000011481ULL, 0x00000023007f7306ULL, 0x000fe20000200c00ULL,
0x0000010072207824ULL, 0x002fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000007000237306ULL, 0x0003f00000200c00ULL, 0x0000007900857306ULL, 0x0007e20000200c00ULL,
0x0000010073707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007a008a7306ULL, 0x000fe20000200c00ULL, 0x0000888072797816ULL, 0x048fe200000000ffULL,
0x0001000072727824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000020007a7306ULL, 0x0003f00000200c00ULL, 0x0000000300037306ULL, 0x000fe20000200c00ULL,
0x0000888074207816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000000c000c7306ULL, 0x000ff00000200c00ULL,
0x0000007b008b7306ULL, 0x0003f00000200c00ULL, 0x00000070007e7306ULL, 0x0007e20000200c00ULL,
0x00008880737b7816ULL, 0x002fce00000000ffULL, 0x0000007200737306ULL, 0x0003e20000200c00ULL,
0x0000888075707816ULL, 0x008fce00000000ffULL, 0x0000002000827306ULL, 0x0007e20000200c00ULL,
0x0000010075727824ULL, 0x002fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000021007c7306ULL, 0x0003220000200c00ULL, 0x0001000075207824ULL, 0x008fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000007400757306ULL, 0x0006a20000200c00ULL,
0x0000010071217824ULL, 0x042fe400078e00ffULL, 0x0001000071717824ULL, 0x000fc600078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000007d00807306ULL, 0x0003e20000200c00ULL,
0x0000010077747824ULL, 0x048fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0001000077777824ULL, 0x000fe200078e00ffULL, 0x00005410737c7816ULL, 0x010fe4000000007cULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000007000837306ULL, 0x0007e20000200c00ULL,
0x00008880767d7816ULL, 0x002fc400000000ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000541075847816ULL, 0x004fc60000000084ULL, 0x0000002000867306ULL, 0x0002a20000200c00ULL,
0x0000010076707824ULL, 0x048fe400078e00ffULL, 0x0001000076767824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000002100217306ULL, 0x000ee20000200c00ULL, 0x0000541003207816ULL, 0x002fe4000000000cULL,
0x0000541086857816ULL, 0x004fca0000000085ULL, 0x0000007100717306ULL, 0x000e640000200c00ULL,
0x000000846850723cULL, 0x080f6c0000001850ULL, 0x0000007900797306ULL, 0x000ea20000200c00ULL,
0x000054106c217816ULL, 0x008fe20000000021ULL, 0x000000842430723cULL, 0x000f6c0000001830ULL,
0x0000007b007b7306ULL, 0x000ee20000200c00ULL, 0x0000541071717816ULL, 0x002fe20000000078ULL,
0x000000206864723cULL, 0x080f6c0000001864ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x00005410797a7816ULL, 0x004fe2000000007aULL, 0x000000202444723cULL, 0x000f6c0000001844ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107b7b7816ULL, 0x008fce000000007eULL,
0x0000007d00877306ULL, 0x0007e20000200c00ULL, 0x0000541082827816ULL, 0x002fe20000000081ULL,
0x0000007a685c723cULL, 0x080f6c000000185cULL, 0x0000007000887306ULL, 0x0003220000200c00ULL,
0x00005410807d7816ULL, 0x008fe2000000007fULL, 0x0000007a243c723cULL, 0x000f62000000183cULL,
0x0000541083837816ULL, 0x004fca0000000072ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x0000541023707816ULL, 0x002fe2000000001cULL, 0x0000007c6858723cULL, 0x040f6c0000001858ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541087887816ULL, 0x010fe20000000088ULL,
0x000000706860723cULL, 0x040f6c0000001860ULL, 0x0000007600037306ULL, 0x000ea40000200c00ULL,
0x000000826854723cULL, 0x000f6c0000001854ULL, 0x00000077000c7306ULL, 0x000ee20000200c00ULL,
0x0000541089897816ULL, 0x002fe20000000074ULL, 0x000000702440723cULL, 0x000f620000001840ULL,
0x00005410038a7816ULL, 0x004fe2000000008aULL, 0x000000101d037824ULL, 0x000fcc00078e020bULL,
0x00000088684c723cULL, 0x000f62000000184cULL, 0x000054100c8b7816ULL, 0x008fce000000008bULL,
0x0000007c2438723cULL, 0x000f700000001838ULL, 0x0000008a6848723cULL, 0x000b6e0000001848ULL,
0x000000101f687824ULL, 0x020fe200078e0200ULL, 0x000000822434723cULL, 0x040f620000001834ULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x00000088242c723cULL, 0x040f70000000182cULL,
0x0000008a2428723cULL, 0x000b640000001828ULL, 0x000000000324783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000724247232ULL, 0x088fe40000000000ULL, 0x0000000726267232ULL, 0x000fc40000000000ULL,
0x0000000625257232ULL, 0x080fe40000000000ULL, 0x0000000627277232ULL, 0x000fe40000000000ULL,
0x000000051c1c7232ULL, 0x082fe40000000000ULL, 0x000000051e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802037824ULL, 0x044fe200078e00ffULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000000102027824ULL, 0x000fca00078e020aULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000f220000004200ULL, 0x00000018ff027819ULL, 0x004fe20000011469ULL,
0x000001006a747824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001146aULL,
0x0000000200237306ULL, 0x0005e20000200c00ULL, 0x00000018ff007819ULL, 0x000fe40000011468ULL,
0x00000018ff0c7819ULL, 0x000fe4000001146bULL, 0x00000018ff747819ULL, 0x000fc60000011474ULL,
0x0000000b00767306ULL, 0x0007e20000200c00ULL, 0x0000010068027824ULL, 0x004fe200078e00ffULL,
0x00000018ff037819ULL, 0x010fe20000011471ULL, 0x0000010070797824ULL, 0x000fc600078e00ffULL,
0x00000018ff027819ULL, 0x000fe20000011402ULL, 0x0000010072807824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011470ULL, 0x00000100690b7824ULL, 0x008fe200078e00ffULL,
0x00000000000a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff217819ULL, 0x000fe40000011472ULL,
0x00000018ff6c7819ULL, 0x000fe40000011473ULL, 0x00008880727f7816ULL, 0x040fe200000000ffULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000000c00787306ULL, 0x0007e20000200c00ULL, 0x0000888068007816ULL, 0x044fe200000000ffULL,
0x0001000068687824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x00000003007d7306ULL, 0x000fe20000200c00ULL, 0x00008880690c7816ULL, 0x048fe200000000ffULL,
0x0001000069697824ULL, 0x000fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000000200037306ULL, 0x0005f00000200c00ULL, 0x00000020007c7306ULL, 0x0007e20000200c00ULL,
0x000088806a027816ULL, 0x044fe200000000ffULL, 0x000100006a6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000002100827306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x008fce000001140bULL, 0x0000000000007306ULL, 0x000ff00000200c00ULL,
0x0000000200757306ULL, 0x0005f00000200c00ULL, 0x0000000c000c7306ULL, 0x000fe20000200c00ULL,
0x0000888070027816ULL, 0x044fe200000000ffULL, 0x0001000070707824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000002000217306ULL, 0x0005f00000200c00ULL,
0x0000006c00847306ULL, 0x000fe20000200c00ULL, 0x000088806b207816ULL, 0x004fce00000000ffULL,
0x00000002007a7306ULL, 0x0005f00000200c00ULL, 0x00000069006c7306ULL, 0x000fe20000200c00ULL,
0x0001000071027824ULL, 0x004fca00078e00ffULL, 0x00000018ff027819ULL, 0x000fe40000011402ULL,
0x0000006a00697306ULL, 0x0004f00000200c00ULL, 0x00000068000b7306ULL, 0x0008620000200c00ULL,
0x00000100716a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000002007e7306ULL, 0x0004620000200c00ULL, 0x000001006b687824ULL, 0x010fe200078e00ffULL,
0x0000541069767816ULL, 0x008fe20000000076ULL, 0x000100006b6b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000006a007b7306ULL, 0x0007e20000200c00ULL,
0x0000541000027816ULL, 0x004fe40000000003ULL, 0x000054100c037816ULL, 0x000fe20000000021ULL,
0x00000100730c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x000054100b0a7816ULL, 0x002fe2000000000aULL, 0x0000006800777306ULL, 0x0003e20000200c00ULL,
0x00008880736a7816ULL, 0x048fe200000000ffULL, 0x0001000073737824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000000022464723cULL, 0x000b620000001864ULL,
0x000054106c0b7816ULL, 0x000fe20000000023ULL, 0x000000ffff007224ULL, 0x000fe200078e006aULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x0000888071687816ULL, 0x002fc400000000ffULL, 0x000054107e7d7816ULL, 0x000fe2000000007dULL,
0x0000000a2460723cULL, 0x000b680000001860ULL, 0x0000002000207306ULL, 0x000e680000200c00ULL,
0x000000021c44723cULL, 0x000b680000001844ULL, 0x0000007200837306ULL, 0x000ee20000200c00ULL,
0x0000541075747816ULL, 0x004fc60000000074ULL, 0x0000000a1c40723cULL, 0x000b680000001840ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541020757816ULL, 0x002fce0000000077ULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x0000541083827816ULL, 0x008fe20000000082ULL,
0x00000074245c723cULL, 0x080b6c000000185cULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x000054106b777816ULL, 0x004fe20000000078ULL, 0x000000741c3c723cULL, 0x000b6c000000183cULL,
0x0000007000717306ULL, 0x000ea20000200c00ULL, 0x000054107a7a7816ULL, 0x002fe20000000079ULL,
0x000000762458723cULL, 0x080b6c0000001858ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410687b7816ULL, 0x008fe2000000007bULL, 0x000000761c38723cULL, 0x000b6c0000001838ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x00005410717c7816ULL, 0x004fe2000000007cULL,
0x0000007a2454723cULL, 0x040b6c0000001854ULL, 0x0000000000007306ULL, 0x000fe40000200c00ULL,
0x0000007c2450723cULL, 0x000b6c0000001850ULL, 0x0000000c00817306ULL, 0x000ea20000200c00ULL,
0x000054107f807816ULL, 0x002fe20000000080ULL, 0x0000007a1c34723cULL, 0x040b6c0000001834ULL,
0x0000007300737306ULL, 0x000e640000200c00ULL, 0x0000007c1c30723cULL, 0x000b620000001830ULL,
0x0000541000817816ULL, 0x004fce0000000081ULL, 0x00000080244c723cULL, 0x000b62000000184cULL,
0x0000541073837816ULL, 0x002fce0000000084ULL, 0x000000822448723cULL, 0x000b700000001848ULL,
0x000000801c2c723cULL, 0x040b70000000182cULL, 0x000000821c28723cULL, 0x000b620000001828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000d027f8cULL, 0x0202a2000c80043fULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x000126a0100a7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0003ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff511000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fe400078e002fULL, 0x000000ffff207224ULL, 0x000fc400078e002eULL,
0x000000ffff1f7224ULL, 0x000fe400078e0033ULL, 0x000000ffff147224ULL, 0x000fe400078e0032ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000cbc000047802ULL, 0x000fc40000000f00ULL, 0x0000aba000007944ULL, 0x00efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000087919ULL, 0x000ee80000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x048fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x010fca0000410000ULL,
0x00001f0706007589ULL, 0x000ea800000e0000ULL, 0x00001f0506057589ULL, 0x000ee800000e0000ULL,
0x00001f0906047589ULL, 0x000f2800000e0000ULL, 0x00001f0b06027589ULL, 0x000e6200000e0000ULL,
0x0000006400647220ULL, 0x044fe20000410000ULL, 0x0000006500657220ULL, 0x040fe20000410000ULL,
0x0000006000607220ULL, 0x040fe20000410000ULL, 0x0000006100617220ULL, 0x040fe20000410000ULL,
0x0000005c005c7220ULL, 0x040fe20000410000ULL, 0x0000005d005d7220ULL, 0x040fe20000410000ULL,
0x0000005800587220ULL, 0x040fe20000410000ULL, 0x0000005900597220ULL, 0x040fe20000410000ULL,
0x0000005400547220ULL, 0x040fe20000410000ULL, 0x0000005500557220ULL, 0x040fe20000410000ULL,
0x0000005000507220ULL, 0x040fe20000410000ULL, 0x0000005100517220ULL, 0x040fe20000410000ULL,
0x0000004c004c7220ULL, 0x040fe20000410000ULL, 0x0000004d004d7220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004605467220ULL, 0x048fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x0000000466667220ULL, 0x090fe20000410000ULL, 0x0000000467677220ULL, 0x080fe20000410000ULL,
0x0000000462627220ULL, 0x080fe20000410000ULL, 0x0000000463637220ULL, 0x080fe20000410000ULL,
0x000000045e5e7220ULL, 0x080fe20000410000ULL, 0x000000045f5f7220ULL, 0x080fe20000410000ULL,
0x000000045a5a7220ULL, 0x080fe20000410000ULL, 0x000000045b5b7220ULL, 0x080fe20000410000ULL,
0x0000000456567220ULL, 0x080fe20000410000ULL, 0x0000000457577220ULL, 0x080fe20000410000ULL,
0x0000000452527220ULL, 0x080fe20000410000ULL, 0x0000000453537220ULL, 0x080fe20000410000ULL,
0x000000044e4e7220ULL, 0x080fe20000410000ULL, 0x000000044f4f7220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x0000000244447220ULL, 0x082fe20000410000ULL, 0x0000000245457220ULL, 0x080fe20000410000ULL,
0x0000000240407220ULL, 0x080fe20000410000ULL, 0x0000000241417220ULL, 0x080fe20000410000ULL,
0x000000023c3c7220ULL, 0x080fe20000410000ULL, 0x000000023d3d7220ULL, 0x080fe20000410000ULL,
0x0000000238387220ULL, 0x080fe20000410000ULL, 0x0000000239397220ULL, 0x080fe20000410000ULL,
0x0000000234347220ULL, 0x080fe20000410000ULL, 0x0000000235357220ULL, 0x080fe20000410000ULL,
0x0000000230307220ULL, 0x080fe20000410000ULL, 0x0000000231317220ULL, 0x080fe20000410000ULL,
0x000000022c2c7220ULL, 0x080fe20000410000ULL, 0x000000022d2d7220ULL, 0x080fe20000410000ULL,
0x0000000228287220ULL, 0x080fe20000410000ULL, 0x0000000229297220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x000000666766723eULL, 0x000fc400000000ffULL,
0x000000626333723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e5f5e723eULL, 0x000fe400000000ffULL, 0x0000005a5b2f723eULL, 0x000fe400000000ffULL,
0x000000565756723eULL, 0x000fc400000000ffULL, 0x00000052532b723eULL, 0x000fe400000000ffULL,
0x0000004e4f4e723eULL, 0x000fe400000000ffULL, 0x0000004a4b27723eULL, 0x000fe400000000ffULL,
0x0000541066327816ULL, 0x000fe40000000033ULL, 0x0000000800037811ULL, 0x054fe200078ff0ffULL,
0x000000016f6f7824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008030d7824ULL, 0x002fe200078e00ffULL,
0x0000001000097811ULL, 0x040fe400078ff0ffULL, 0x00000018000b7811ULL, 0x000fe200078ff0ffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0x0000000302047211ULL, 0x040fe200078ff8ffULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000b02067211ULL, 0x040fe200078ff8ffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0xfffffff80b127812ULL, 0x000fe400078ee206ULL,
0xfffffff809087812ULL, 0x000fe200078ee202ULL, 0x0000200011027824ULL, 0x000fe200078e00ffULL,
0x0000000403067810ULL, 0x040fe40007ffe0ffULL, 0x0000000603077810ULL, 0x000fe20007ffe0ffULL,
0x000000106f6f7824ULL, 0x100fe200078e0202ULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000100013037824ULL, 0x000fe200078e0202ULL, 0xfffffff8090a7812ULL, 0x008fc400078ee206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0f7824ULL, 0x100fe200078e0203ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x000000606104723eULL, 0x000fe200000000ffULL, 0x0000001010157824ULL, 0x000fe200078e0203ULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x0000001012177824ULL, 0x100fe200078e0203ULL,
0x000000444544723eULL, 0x000fe200000000ffULL, 0x0000001008097824ULL, 0x100fe200078e0203ULL,
0x000000484908723eULL, 0x000fe200000000ffULL, 0x000000100a0b7824ULL, 0x100fe200078e0203ULL,
0x000000404122723eULL, 0x000fe200000000ffULL, 0x000000100c0d7824ULL, 0x000fe200078e0203ULL,
0x000000646503723eULL, 0x000fe200000000ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000545505723eULL, 0x000fe200000000ffULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x00005410031c7816ULL, 0x140fe20000000004ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x00007632031d7816ULL, 0x000fe20000000004ULL, 0x0000000106177824ULL, 0x040fe200078e0217ULL,
0x0000005c5d03723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x000000585904723eULL, 0x000fe200000000ffULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x0000001c07007388ULL, 0x0003e20000000a00ULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x000000505106723eULL, 0x000fc400000000ffULL, 0x000054105e2e7816ULL, 0x140fe4000000002fULL,
0x0000003c3d3c723eULL, 0x000fe400000000ffULL, 0x00000038391e723eULL, 0x000fe400000000ffULL,
0x000076325e2f7816ULL, 0x000fe4000000002fULL, 0x0000004c4d07723eULL, 0x002fe400000000ffULL,
0x00005410031c7816ULL, 0x000fc40000000004ULL, 0x00007632031d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c09007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040b007388ULL, 0x000fe20000000a00ULL,
0x00005410562a7816ULL, 0x000fc4000000002bULL, 0x00007632562b7816ULL, 0x000fe2000000002bULL,
0x000000060d007388ULL, 0x0003e20000000a00ULL, 0x000054104e267816ULL, 0x140fe40000000027ULL,
0x000076324e277816ULL, 0x000fe20000000027ULL, 0x000000320f007388ULL, 0x0005e20000000a00ULL,
0x000054103c0e7816ULL, 0x000fe4000000001eULL, 0x000000343534723eULL, 0x000fe200000000ffULL,
0x0004002e09007388ULL, 0x000fe20000000a00ULL, 0x00000030311a723eULL, 0x000fc400000000ffULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x0004002a0b007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260d007388ULL, 0x000fe20000000a00ULL, 0x000076323c0f7816ULL, 0x004fe4000000001eULL,
0x000000282916723eULL, 0x000fe200000000ffULL, 0x0000000615007388ULL, 0x0003e20000000a00ULL,
0x000000464703723eULL, 0x000fc400000000ffULL, 0x000000424304723eULL, 0x000fe200000000ffULL,
0x0008000e09007388ULL, 0x0005e20000000a00ULL, 0x0000003e3f05723eULL, 0x000fe400000000ffULL,
0x000000242308723eULL, 0x000fe400000000ffULL, 0x000000ff1300720cULL, 0x000fe40003f05270ULL,
0x0000003a3b06723eULL, 0x002fe400000000ffULL, 0x000000202107723eULL, 0x000fc400000000ffULL,
0x00005410340e7816ULL, 0x144fe4000000001aULL, 0x00007632340f7816ULL, 0x000fe4000000001aULL,
0x0000541007307816ULL, 0x140fe40000000008ULL, 0x0000763207317816ULL, 0x000fe20000000008ULL,
0x0008000e0b007388ULL, 0x0003e40000000a00ULL, 0x000054102c0e7816ULL, 0x142fe40000000016ULL,
0x000076322c0f7816ULL, 0x000fca0000000016ULL, 0x0008000e0d007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x000000363703723eULL, 0x000fe400000000ffULL, 0x000000141f04723eULL, 0x000fe200000000ffULL,
0x0000000e17007388ULL, 0x0003e40000000a00ULL, 0x00005410050e7816ULL, 0x002fc40000000006ULL,
0x00007632050f7816ULL, 0x000fca0000000006ULL, 0x000c000e09007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fca0000000004ULL,
0x000c000e0b007388ULL, 0x000fe80000000a00ULL, 0x000c00300d007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000006f047984ULL, 0x000e680000000c00ULL,
0x000400006f1c7984ULL, 0x000ea80000000c00ULL, 0x000800006f247984ULL, 0x000ee80000000c00ULL,
0x000c00006f087984ULL, 0x000f280000000c00ULL, 0x001000006f147984ULL, 0x000ee80000000c00ULL,
0x001400006f207984ULL, 0x000f280000000c00ULL, 0x001800006f287984ULL, 0x000f280000000c00ULL,
0x001c00006f2c7984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff0b0b7230ULL, 0x010fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x0000001707077230ULL, 0x000fe40000000000ULL,
0x0000001606067230ULL, 0x000fe40000000000ULL, 0x0000001505057230ULL, 0x000fc40000000000ULL,
0x0000001404047230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x000000046f007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001c6f007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x0000002f0b0b7230ULL, 0x000fe40000000000ULL,
0x0000002e0a0a7230ULL, 0x000fe20000000000ULL, 0x000800246f007388ULL, 0x000fe20000000c00ULL,
0x0000002d09097230ULL, 0x000fc40000000000ULL, 0x0000002c08087230ULL, 0x000fca0000000000ULL,
0x000c00086f007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x000000180900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL, 0x00000007000e7812ULL, 0x000fc800078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a05ULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x0000000305107227ULL, 0x000fc800078e0004ULL,
0x0000000119037824ULL, 0x000fc800078e0209ULL, 0x0000000310077227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a07ULL, 0x00005a0004057a24ULL, 0x000fe400078e0203ULL,
0x0000000109047824ULL, 0x000fc600078e0200ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805057812ULL, 0x000fca00078ef800ULL,
0x0000001005067824ULL, 0x000fe400078e0202ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000070f047207ULL, 0x000fe40004000000ULL,
0x0000002000077810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe200078e021bULL, 0x00000003ff067819ULL, 0x002fe20000011607ULL,
0x00005a000c037a24ULL, 0x000fc800078e0203ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x0000000811037824ULL, 0x000fe200078e020eULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000040000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x0000006000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000080000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000a000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000c0000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000e000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x040fe200078e0206ULL, 0x000000070d007812ULL, 0x000fe200078ec0ffULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe400078e0203ULL, 0x0000000119197824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001910007227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a00ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fc600078e0219ULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000100001810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0xfffffff806037812ULL, 0x000fca00078ef807ULL,
0x0000001003047824ULL, 0x000fca00078e0202ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000100002810ULL, 0x000fc80007ffe0ffULL, 0x000000000f007207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a00ULL, 0x0000590000007a24ULL, 0x000fe400078e021bULL,
0x00005a0002197a24ULL, 0x000fc800078e0219ULL, 0x00005a0000197a24ULL, 0x000fe200078e0219ULL,
0x0000000707007812ULL, 0x000fc800078ec0ffULL, 0x000000196e197210ULL, 0x000fe20007f1e0ffULL,
0x0000000811117824ULL, 0x000fc800078e0200ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0019027a11ULL, 0x000fc800078040ffULL, 0x00005f0019037a11ULL, 0x000fca00000f4406ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006c00ff647624ULL, 0x000fe400078e00ffULL,
0x00006d00ff657624ULL, 0x000fca00078e00ffULL, 0x0000000664647981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000001fff657424ULL, 0x004fe200078e00ffULL, 0x01260000ff047f8cULL, 0x000ea2000c80043fULL,
0x000000020e0e7824ULL, 0x000fe400078e00ffULL, 0x000000401a637824ULL, 0x000fe200078e00ffULL,
0x0000580065657a10ULL, 0x000fe20007ffe0ffULL, 0x000059000e007a24ULL, 0x000fc600078e021bULL,
0x00000005ff657819ULL, 0x000fe20000011665ULL, 0x0000680000147a24ULL, 0x000fe400078e0263ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff207819ULL, 0x000fe40000011617ULL,
0x0000001717107211ULL, 0x000fe400078fe8ffULL, 0x0000000820117810ULL, 0x000fe20007ffe0ffULL,
0x0000000114067824ULL, 0x002fe200078e0220ULL, 0x0000001020217810ULL, 0x040fe40007ffe0ffULL,
0x0000001820227810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000020201d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000310187812ULL, 0x000fe200078ec0ffULL,
0x0000000114087824ULL, 0x000fe200078e0211ULL, 0x00000030060e7812ULL, 0x000fe200078ef803ULL,
0x00000001140a7824ULL, 0x000fe200078e0221ULL, 0x0000006316067217ULL, 0x000fe20007800000ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe40007f1e0ffULL,
0x00000028201e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001140c7824ULL, 0x040fe200078e0222ULL,
0x00006500070f7a10ULL, 0x000fe200007fe4ffULL, 0x0000000114077824ULL, 0x000fe200078e021dULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000020001a1c7811ULL, 0x000fc400078e68ffULL, 0x0000640008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe400078ef803ULL,
0x0000650009097a10ULL, 0x000fe20000ffe4ffULL, 0x0000000106137824ULL, 0x000fe200078e0a63ULL,
0x000000300c0c7812ULL, 0x100fe200078ef803ULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe40007f1e0ffULL, 0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000004111b7824ULL, 0x000fe200078e00ffULL, 0x0000003006107812ULL, 0x000fe200078ef803ULL,
0x0000000114067824ULL, 0x000fe200078e021eULL, 0x000065000b0b7a10ULL, 0x000fc400007fe4ffULL,
0x0000640010107a10ULL, 0x000fe40007f5e0ffULL, 0x000065000d0d7a10ULL, 0x000fe40000ffe4ffULL,
0x000000132000720cULL, 0x080fe40003f06070ULL, 0x000000131100720cULL, 0x000fe40003f26070ULL,
0x0000650007117a10ULL, 0x000fe200017fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0ffffffc18177812ULL, 0x000fc400078ef817ULL, 0xfffffffc1b1b7812ULL, 0x000fe400078ee218ULL,
0x00000030201f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x100fe200078e021cULL,
0x0000003006127812ULL, 0x000fe200078ef803ULL, 0x000000101b1b7824ULL, 0x000fe200078e021cULL,
0x0000003820207810ULL, 0x000fe20007ffe0ffULL, 0x0000000114067824ULL, 0x000fe200078e021fULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000c101c46ULL, 0x000000132100720cULL, 0x000fc40003fa6070ULL,
0x000000132200720cULL, 0x080fe20003f86070ULL, 0x00000000081b7faeULL, 0x0007e2000c901c46ULL,
0x000000131d00720cULL, 0x080fe40003f66070ULL, 0x000000131e00720cULL, 0x080fe40003f46070ULL,
0x000000131f00720cULL, 0x0c0fe20003f26070ULL, 0x000000041f1f7824ULL, 0x000fe200078e00ffULL,
0x000000132000720cULL, 0x000fe20003f06070ULL, 0x00000004210f7824ULL, 0x002fe200078e00ffULL,
0x0000650007137a10ULL, 0x000fe200037fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffffc1f1f7812ULL, 0x000fc400078ee218ULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee218ULL,
0x0000000114087824ULL, 0x008fe200078e0220ULL, 0x0000003006067812ULL, 0x100fe200078ef803ULL,
0x0000000422177824ULL, 0x000fe400078e00ffULL, 0x000000041d1b7824ULL, 0x000fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe400078ee218ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee218ULL,
0x000000041e1d7824ULL, 0x000fe200078e00ffULL, 0x0000003008037812ULL, 0x000fe200078ef803ULL,
0x0000000420217824ULL, 0x000fe200078e00ffULL, 0x0000650007077a10ULL, 0x000fe200037fe4ffULL,
0x000000100f0f7824ULL, 0x000fe200078e021cULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee218ULL,
0x0000001017177824ULL, 0x000fe200078e021cULL, 0xfffffffc21217812ULL, 0x000fe200078ee218ULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x0000640003087a10ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x000000000a0f7faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e021cULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x000000000c177faeULL, 0x0003e8000e101c46ULL,
0x00000000101b7faeULL, 0x0003e8000d901c46ULL, 0x00000000121d7faeULL, 0x0003e8000d101c46ULL,
0x00000000061f7faeULL, 0x0003e8000c901c46ULL, 0x0000000008217faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000001717087211ULL, 0x040fe400078fe8ffULL,
0x00000008170f7811ULL, 0x000fc400078ff0ffULL, 0x0000001017117811ULL, 0x040fe400078ff0ffULL,
0x0000001817137811ULL, 0x040fe400078ff0ffULL, 0x0000002817097811ULL, 0x040fe200078ff0ffULL,
0x00000001140a7824ULL, 0x040fe200078e0211ULL, 0x0000002017077811ULL, 0x000fe200078ff0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x00000030170b7811ULL, 0x040fe200078ff0ffULL,
0x00000001140c7824ULL, 0x000fe200078e0213ULL, 0x00000003081c7812ULL, 0x000fe200078ec0ffULL,
0x0000000114087824ULL, 0x000fe200078e020fULL, 0x00000038170d7811ULL, 0x000fe200078ff0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000001417067211ULL, 0x002fe200078ff0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x000020001a277811ULL, 0x000fe200078e68ffULL,
0x00000001141e7824ULL, 0x040fe200078e0209ULL, 0xfffffffc0f0e7812ULL, 0x100fe200078ee21cULL,
0x00000004071b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc110f7812ULL, 0x100fe200078ee21cULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc13117812ULL, 0x100fe200078ee21cULL,
0x0000000114207824ULL, 0x040fe200078e020bULL, 0xfffffffc1b127812ULL, 0x100fe200078ee21cULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09137812ULL, 0x100fe200078ee21cULL,
0x0000000114187824ULL, 0x000fe200078e0207ULL, 0x0ffffffc1c177812ULL, 0x000fe200078ef817ULL,
0x0000000114227824ULL, 0x000fe200078e020dULL, 0xfffffffc0b147812ULL, 0x000fe200078ee21cULL,
0x000000040d0d7824ULL, 0x000fc400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffffc0d1c7812ULL, 0x000fe200078ee21cULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000003006107812ULL, 0x000fc600078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000001012217824ULL, 0x000fe200078e0227ULL,
0x0000003008127812ULL, 0x000fe200078ef803ULL, 0x00000010172b7824ULL, 0x000fe200078e0227ULL,
0x000000300a1d7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007f3e0ffULL, 0x000000100e177824ULL, 0x000fe200078e0227ULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x000000100f1b7824ULL, 0x100fe400078e0227ULL,
0x00000010111f7824ULL, 0x100fe200078e0227ULL, 0x0000650007117a10ULL, 0x000fe200007fe4ffULL,
0x0000001013237824ULL, 0x100fe200078e0227ULL, 0x0000650009137a10ULL, 0x000fe20000ffe4ffULL,
0x0000001014257824ULL, 0x100fe200078e0227ULL, 0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000101c277824ULL, 0x000fe200078e0227ULL, 0x000064001d1c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000008018067825ULL, 0x000fe200078e00ffULL, 0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x000065000b1d7a10ULL, 0x000fe200017fe4ffULL, 0x000000801e087825ULL, 0x000fe200078e00ffULL,
0x0000003006067812ULL, 0x100fe200078ef803ULL, 0x0000000012177faeULL, 0x0003e4000b901c46ULL,
0x00000080200a7825ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x100fe200078ef803ULL,
0x000000001c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000640006067a10ULL, 0x000fe20007f1e0ffULL,
0x00000080220e7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe200078ef803ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x0000640008087a10ULL, 0x000fc40007f3e0ffULL,
0x000000300e037812ULL, 0x000fe400078ef803ULL, 0x000064000a0a7a10ULL, 0x000fe40007f5e0ffULL,
0x00006400030e7a10ULL, 0x000fe40007f7e0ffULL, 0x0000650007077a10ULL, 0x000fe400007fe4ffULL,
0x0000650009097a10ULL, 0x000fe40000ffe4ffULL, 0x000065000b0b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000006217faeULL, 0x0003e2000b901c46ULL, 0x000065000f0f7a10ULL, 0x000fc60001ffe4ffULL,
0x0000000008237faeULL, 0x0003e8000b901c46ULL, 0x000000000a257faeULL, 0x0003e8000b901c46ULL,
0x000000000e277faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01260400ff037984ULL, 0x000e620000000800ULL,
0x0000006502027224ULL, 0x000fe400078e02ffULL, 0x0000000116677824ULL, 0x000fc400078e0a61ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x006fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0029ULL, 0x00000008ff677819ULL, 0x000fe20000011667ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000201a047824ULL, 0x002fca00078e0205ULL, 0x00000004ff057819ULL, 0x000fe40000011604ULL,
0x0000000104067810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000107097824ULL, 0x040fe400078e0206ULL,
0x0000000104087824ULL, 0x000fe200078e0207ULL, 0x0000000807077810ULL, 0x000fe20007ffe0ffULL,
0x00000010050a7824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010050b7824ULL, 0x000fe200078e00ffULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000001f00a097812ULL, 0x000fe200078ee209ULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x000001f00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005077824ULL, 0x040fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000e62000000cc00ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000f04047812ULL, 0x000fc400078ec0ffULL, 0x0000000008107984ULL, 0x000ea4000000cc00ULL,
0x000001f005067812ULL, 0x000fe400078ee206ULL, 0x000001f007047812ULL, 0x000fe200078ee204ULL,
0x000000ffff1e7224ULL, 0x002fe400078e000cULL, 0x000000ffff1f7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000001c08007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x0000002009007388ULL, 0x000fe8000000cc00ULL,
0x00000000060c7984ULL, 0x000e68000000cc00ULL, 0x0000000004107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002404007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01260400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000667919ULL, 0x000e620000000000ULL, 0x0000000265657824ULL, 0x000fe200078e00ffULL,
0x3db504f364647820ULL, 0x010fe20000410000ULL, 0x000126881a627811ULL, 0x040fe200078e18ffULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0xffffffff61607810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x00000009611b7810ULL, 0x000fe40007ffe0ffULL,
0x000126081a187811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x000fe200078e0017ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x00cfc4000001ff00ULL,
0x000000016800780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x00000001144c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6a7224ULL, 0x000fe200078e0068ULL,
0x00000001684d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000169177812ULL, 0x000fe400078e0cffULL,
0x000000024d00780cULL, 0x000fe20003f06070ULL, 0x000000ffff687224ULL, 0x000fc800078e004dULL,
0x000000ffff4c1224ULL, 0x000fc800078e0214ULL, 0x000001004c577824ULL, 0x060fe200078e0263ULL,
0x000000014c4e7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff4d4c7207ULL, 0x000fe20000800000ULL,
0x00006800006d7a24ULL, 0x000fe200078e0257ULL, 0x000000154e00720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x00000010664d7824ULL, 0x002fe200078e00ffULL,
0x00000002ff5c7819ULL, 0x000fe20000011666ULL, 0x000000021a5b7824ULL, 0x000fe200078e0217ULL,
0x0000005716547217ULL, 0x000fe40007800000ULL, 0x000000304d4d7812ULL, 0x000fe200078ec0ffULL,
0x000000015c4f7824ULL, 0x040fe200078e026dULL, 0x000000185c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001545a7824ULL, 0x000fe200078e0a57ULL, 0x000000085c587810ULL, 0x000fe20007ffe0ffULL,
0x000000404c4c7824ULL, 0x000fe200078e024dULL, 0x000000105c597810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e00ffULL, 0x000000205c6e7810ULL, 0x000fe20007ffe0ffULL,
0x000000016c557824ULL, 0x040fe200078e026dULL, 0x000020005b5b7811ULL, 0x000fe200078e60ffULL,
0x000000804f4e7825ULL, 0x000fe200078e004cULL, 0x0000005a6c00720cULL, 0x000fc60003fa6070ULL,
0x0000000158517824ULL, 0x000fe200078e026dULL, 0x000064004e567a10ULL, 0x000fe20007f3e0ffULL,
0x000000016d537824ULL, 0x000fe200078e0259ULL, 0x00000066664e7211ULL, 0x000fe200078fe8ffULL,
0x0000008055547825ULL, 0x100fe200078e004cULL, 0x000065004f577a10ULL, 0x000fe40000ffe4ffULL,
0x000000034e6f7812ULL, 0x000fe200078ec0ffULL, 0x0000008051507825ULL, 0x000fe200078e004cULL,
0x0000640054547a10ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc6f5e7812ULL, 0x000fe200078ef866ULL,
0x0000000459727824ULL, 0x000fe200078e00ffULL, 0x0000640050507a10ULL, 0x000fe20007f5e0ffULL,
0x0000008053527825ULL, 0x000fe200078e004cULL, 0x0000650055557a10ULL, 0x000fc40000ffe4ffULL,
0x0000005a5c00720cULL, 0x080fe20003f26070ULL, 0x000000016e4f7824ULL, 0x000fe200078e026dULL,
0x0000640052527a10ULL, 0x000fe20007f7e0ffULL, 0x000000105e5d7824ULL, 0x000fe200078e025bULL,
0xfffffffc725e7812ULL, 0x000fe200078ee26fULL, 0x000000804f4e7825ULL, 0x000fe200078e004cULL,
0x0000650051517a10ULL, 0x000fe400017fe4ffULL, 0x0000650053537a10ULL, 0x000fe20001ffe4ffULL,
0x0000000458707824ULL, 0x040fe200078e00ffULL, 0x0000005a5800720cULL, 0x080fe20003f46070ULL,
0x000000105e6b7824ULL, 0x000fe200078e025bULL, 0x0000005a5900720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000565d7faeULL, 0x0003e2000c901c46ULL,
0x000064004e587a10ULL, 0x000fc40007f9e0ffULL, 0x000000285c5e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc704e7812ULL, 0x000fe400078ee26fULL, 0x000065004f597a10ULL, 0x000fe200027fe4ffULL,
0x000000015e4f7824ULL, 0x000fe200078e026dULL, 0x000000305c707810ULL, 0x000fe20007ffe0ffULL,
0x000000104e5f7824ULL, 0x000fe200078e025bULL, 0x000000385c5c7810ULL, 0x000fe20007ffe0ffULL,
0x000000804f4e7825ULL, 0x000fe200078e004cULL, 0x0000005a6e00720cULL, 0x000fc40003f86070ULL,
0x00000000505f7faeULL, 0x0005e2000d101c46ULL, 0x0000000170577824ULL, 0x102fe200078e026dULL,
0x000064004e4e7a10ULL, 0x000fe20007fde0ffULL, 0x000000015c5d7824ULL, 0x000fe200078e026dULL,
0x00000000526b7faeULL, 0x0003e2000d901c46ULL, 0x0000005a5e00720cULL, 0x080fe20003f66070ULL,
0x000000046e567824ULL, 0x000fe200078e00ffULL, 0x0000005a7000720cULL, 0x0c0fe20003f46070ULL,
0x0000000470707824ULL, 0x000fe200078e00ffULL, 0x0000005a5c00720cULL, 0x000fe20003f26070ULL,
0x000000045e5a7824ULL, 0x000fe200078e00ffULL, 0x000065004f4f7a10ULL, 0x000fe200037fe4ffULL,
0x0000008057507825ULL, 0x004fe200078e004cULL, 0xfffffffc56567812ULL, 0x000fc400078ee26fULL,
0xfffffffc5a5a7812ULL, 0x100fe200078ee26fULL, 0x000000046c527824ULL, 0x002fe200078e00ffULL,
0x0000640050507a10ULL, 0x000fe20007fde0ffULL, 0x000000045c5e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc705c7812ULL, 0x000fe200078ee26fULL, 0x000000805d4c7825ULL, 0x000fe200078e004cULL,
0xfffffffc52527812ULL, 0x100fe400078ee26fULL, 0xfffffffc5e5e7812ULL, 0x000fe200078ee26fULL,
0x0000001056577824ULL, 0x100fe200078e025bULL, 0x0000650051517a10ULL, 0x000fe200037fe4ffULL,
0x0000001052537824ULL, 0x100fe200078e025bULL, 0x000064004c4c7a10ULL, 0x000fe20007fde0ffULL,
0x000000105a5d7824ULL, 0x000fc400078e025bULL, 0x000000105c5f7824ULL, 0x100fe200078e025bULL,
0x000065004d4d7a10ULL, 0x000fe200037fe4ffULL, 0x000000105e5b7824ULL, 0x000fe200078e025bULL,
0x0000000054537faeULL, 0x0003e8000e901c46ULL, 0x0000000058577faeULL, 0x0003e8000e101c46ULL,
0x000000004e5d7faeULL, 0x0003e8000d901c46ULL, 0x00000000505f7faeULL, 0x0003e8000d101c46ULL,
0x000000004c5b7faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x00000010664d7824ULL, 0x042fe200078e00ffULL, 0x0000001066507811ULL, 0x000fe200078ff0ffULL,
0x000000021a4f7824ULL, 0x000fe200078e0217ULL, 0x0000001866527811ULL, 0x000fe200078ff0ffULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0x000000304d4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000150517824ULL, 0x100fe200078e026dULL, 0x0000002066547811ULL, 0x000fe200078ff0ffULL,
0x0000000152537824ULL, 0x000fe200078e026dULL, 0x0000002866567811ULL, 0x000fe200078ff0ffULL,
0x000000404c5a7824ULL, 0x000fe200078e024dULL, 0x00000066664e7211ULL, 0x000fe200078fe8ffULL,
0x0000000154557824ULL, 0x100fe200078e026dULL, 0x00000008664c7811ULL, 0x000fe200078ff0ffULL,
0x0000000156577824ULL, 0x000fe200078e026dULL, 0x0000003066587811ULL, 0x000fe200078ff0ffULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x00000038665e7811ULL, 0x000fe200078ff0ffULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000034e4d7812ULL, 0x000fe200078ec0ffULL,
0x000000044c4e7824ULL, 0x000fe200078e00ffULL, 0x000020004f757811ULL, 0x000fe200078e60ffULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc50507812ULL, 0x100fe200078ee24dULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0xfffffffc4e4e7812ULL, 0x100fe200078ee24dULL,
0x00000004585c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc52527812ULL, 0x100fe200078ee24dULL,
0x000000045e6c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc54547812ULL, 0x000fe200078ee24dULL,
0x000000014c4f7824ULL, 0x000fe200078e026dULL, 0xfffffffc56567812ULL, 0x000fe200078ee24dULL,
0x000000104e5d7824ULL, 0x000fe200078e0275ULL, 0xfffffffc5c5c7812ULL, 0x000fe200078ee24dULL,
0x00000010505f7824ULL, 0x000fe200078e0275ULL, 0xfffffffc6c6c7812ULL, 0x000fe200078ee24dULL,
0x000000804f4e7825ULL, 0x000fe200078e005aULL, 0x0ffffffc4d4c7812ULL, 0x000fc400078ef866ULL,
0x0000006d664d7211ULL, 0x000fe200078ff0ffULL, 0x00000010526b7824ULL, 0x100fe200078e0275ULL,
0x000064004e4e7a10ULL, 0x000fe20007f5e0ffULL, 0x000000104c777824ULL, 0x000fe400078e0275ULL,
0x000000804d4c7825ULL, 0x000fe200078e005aULL, 0x000065004f4f7a10ULL, 0x000fc600017fe4ffULL,
0x0000008051507825ULL, 0x000fe200078e005aULL, 0x000064004c4c7a10ULL, 0x000fc60007f3e0ffULL,
0x0000000158597824ULL, 0x100fe200078e026dULL, 0x0000640050507a10ULL, 0x000fe20007f7e0ffULL,
0x000000015e737824ULL, 0x000fe200078e026dULL, 0x000065004d4d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008053527825ULL, 0x000fe200078e005aULL, 0x0000650051517a10ULL, 0x000fc60001ffe4ffULL,
0x00000010546d7824ULL, 0x100fe200078e0275ULL, 0x0000640052527a10ULL, 0x000fe20007f9e0ffULL,
0x00000010566f7824ULL, 0x000fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c777faeULL, 0x0003e2000b901c46ULL, 0x0000008055547825ULL, 0x100fe200078e005aULL,
0x0000650053537a10ULL, 0x000fe400027fe4ffULL, 0x000000004e5d7faeULL, 0x0003e2000b901c46ULL,
0x0000008057567825ULL, 0x100fe200078e005aULL, 0x0000640054547a10ULL, 0x000fe40007f3e0ffULL,
0x00000000505f7faeULL, 0x0003e2000b901c46ULL, 0x0000008059587825ULL, 0x000fe200078e005aULL,
0x0000640056567a10ULL, 0x000fc40007f5e0ffULL, 0x0000650055557a10ULL, 0x000fe20000ffe4ffULL,
0x00000080735a7825ULL, 0x000fe200078e005aULL, 0x0000640058587a10ULL, 0x000fe20007f7e0ffULL,
0x00000000526b7faeULL, 0x0003e2000b901c46ULL, 0x0000650057577a10ULL, 0x000fe200017fe4ffULL,
0x000000105c717824ULL, 0x100fe200078e0275ULL, 0x000064005a5a7a10ULL, 0x000fe20007f9e0ffULL,
0x000000106c757824ULL, 0x000fe200078e0275ULL, 0x0000650059597a10ULL, 0x000fe20001ffe4ffULL,
0x00000000546d7faeULL, 0x0003e2000b901c46ULL, 0x000065005b5b7a10ULL, 0x000fc600027fe4ffULL,
0x00000000566f7faeULL, 0x0003e8000b901c46ULL, 0x0000000058717faeULL, 0x0003e8000b901c46ULL,
0x000000005a757faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000086a6e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff777224ULL, 0x002fc400078e00ffULL, 0x00000010ff6d7424ULL, 0x000fe200078e00ffULL,
0x000000126e6c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x000000026e6e7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff8664d7812ULL, 0x000fe200078ec0ffULL, 0x000000021a517824ULL, 0x020fe200078e0269ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000016b5f7810ULL, 0x000fe40007ffe0ffULL,
0x000000074d507812ULL, 0x000fe400078ef866ULL, 0x0000200051517811ULL, 0x000fc400078e60ffULL,
0x00000001ff527819ULL, 0x000fe20000011650ULL, 0x00000004504d7824ULL, 0x040fe400078e00ffULL,
0x0000000450537824ULL, 0x000fe400078e00ffULL, 0x00000001524c7824ULL, 0x040fe400078e026bULL,
0x0000000152527824ULL, 0x000fc600078e025fULL, 0xfffffffc4d4c7812ULL, 0x000fe400078ee24cULL,
0xfffffffc53527812ULL, 0x000fe400078ee252ULL, 0x0000002066537810ULL, 0x000fe20007ffe0ffULL,
0x000000104c4c7824ULL, 0x100fe400078e0251ULL, 0x0000001052527824ULL, 0x000fe200078e0251ULL,
0xfffffff853537812ULL, 0x000fc600078ec0ffULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x0000000753537812ULL, 0x000fc600078ef866ULL, 0x000000005258783bULL, 0x0004e40000000200ULL,
0x0000000453557824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x002fe2000001144cULL,
0x000001004c547824ULL, 0x040fe200078e00ffULL, 0x000088804c527816ULL, 0x004fe200000000ffULL,
0x000100004d5e7824ULL, 0x000fe200078e00ffULL, 0x00000050008d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff727819ULL, 0x008fe40000011458ULL, 0x00000018ff5d7819ULL, 0x000fc40000011454ULL,
0x00000018ff717819ULL, 0x000fe40000011459ULL, 0x0000888058737816ULL, 0x000fe200000000ffULL,
0x00000052008b7306ULL, 0x0005e20000200c00ULL, 0x000100004c507824ULL, 0x002fe200078e00ffULL,
0x0000888059767816ULL, 0x000fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff5c7819ULL, 0x000fe40000011450ULL, 0x00000001ff507819ULL, 0x000fe20000011653ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x0000005c008c7306ULL, 0x0002e20000200c00ULL,
0x000088804d527816ULL, 0x004fc400000000ffULL, 0x00000001504c7824ULL, 0x040fe200078e026bULL,
0x00000018ff867819ULL, 0x000fe2000001144dULL, 0x0000000150507824ULL, 0x000fe200078e025fULL,
0x00000018ff827819ULL, 0x000fe2000001144fULL, 0x000001004d4d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc554c7812ULL, 0x000fe200078ee24cULL, 0x00000052008f7306ULL, 0x000fe20000200c00ULL,
0xfffffffc53507812ULL, 0x000fe400078ee250ULL, 0x0000000866537812ULL, 0x000fe200078ec0ffULL,
0x000000104c4c7824ULL, 0x000fe200078e0251ULL, 0x000088804e5c7816ULL, 0x002fc400000000ffULL,
0x000088804f877816ULL, 0x040fe200000000ffULL, 0x0000005d008e7306ULL, 0x0002a20000200c00ULL,
0x000000004c54783bULL, 0x0008a20000000200ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff707819ULL, 0x000fe4000001145aULL, 0x000088805a7a7816ULL, 0x000fe400000000ffULL,
0x0000005c00927306ULL, 0x000fe20000200c00ULL, 0x000100004f4c7824ULL, 0x010fe200078e00ffULL,
0x000054108b8c7816ULL, 0x008fe2000000008cULL, 0x000100004e5d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001144eULL, 0x000001004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000001004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000005e00907306ULL, 0x000e620000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x000054108e8d7816ULL, 0x004fe4000000008dULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff6f7819ULL, 0x000fe2000001145bULL,
0x0000004c00887306ULL, 0x0005e20000200c00ULL, 0x000000026b6b7810ULL, 0x000fce0007ffe0ffULL,
0x0000005d00937306ULL, 0x000fe20000200c00ULL, 0x00010000584c7824ULL, 0x044fe200078e00ffULL,
0x000054108f907816ULL, 0x002fe20000000090ULL, 0x0000010058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff747819ULL, 0x000fe2000001144cULL, 0x00000010504c7824ULL, 0x000fe200078e0251ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0001000059507824ULL, 0x040fe200078e00ffULL,
0x0000000766517812ULL, 0x000fe200078ec0ffULL, 0x0000010059597824ULL, 0x000fe200078e00ffULL,
0x0000005800757306ULL, 0x0003e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe20000011454ULL,
0x0001000054957824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011450ULL,
0x00010000558e7824ULL, 0x000fe200078e00ffULL, 0x0000005366507211ULL, 0x000fc400078fe0ffULL,
0x00000018ff787819ULL, 0x000fe20000011459ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x0000000753597812ULL, 0x000fe200078ef866ULL, 0x00000001518a7824ULL, 0x000fe200078e0250ULL,
0x00000018ff837819ULL, 0x000fe20000011455ULL, 0x000000086a517824ULL, 0x040fe200078e0277ULL,
0x0000001059587812ULL, 0x002fe200078efcffULL, 0x000000086a537824ULL, 0x000fe200078e026dULL,
0x0000888055967816ULL, 0x000fe200000000ffULL, 0x0000001059527824ULL, 0x000fe200078e00ffULL,
0x0000004d00917306ULL, 0x000e620000200c00ULL, 0x000000018a517824ULL, 0x040fe200078e0251ULL,
0x00000018ff817819ULL, 0x000fe20000011456ULL, 0x000000018a537824ULL, 0x000fe200078e0253ULL,
0x00000018ff807819ULL, 0x000fe20000011457ULL, 0x00000010585c7824ULL, 0x000fe200078e00ffULL,
0xfffffff052517812ULL, 0x000fe200078ee251ULL, 0x000100005a507824ULL, 0x040fe200078e00ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000001005a5a7824ULL, 0x000fe200078e00ffULL,
0xfffffff05c537812ULL, 0x000fe200078ee253ULL, 0x00000010515c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011450ULL, 0x0000010055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001145aULL, 0x0000001053537824ULL, 0x000fe200078e00ffULL,
0x0000004f00897306ULL, 0x000ea20000200c00ULL, 0x000000005c5c783bULL, 0x000ee20000000200ULL,
0x00008880545a7816ULL, 0x040fe200000000ffULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x000000005350783bULL, 0x000f220000000200ULL,
0x0000541091917816ULL, 0x002fe20000000086ULL, 0x000000ffff8b7224ULL, 0x000fe200078e0096ULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000001058587824ULL, 0x000fe200078e00ffULL, 0x0000888056867816ULL, 0x000fc400000000ffULL,
0x00000018ff957819ULL, 0x000fe40000011495ULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0000005400977306ULL, 0x000fe20000200c00ULL, 0x0000541089897816ULL, 0x004fe20000000082ULL,
0x0001000057827824ULL, 0x000fe200078e00ffULL, 0x0000541092927816ULL, 0x000fc80000000093ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000005500547306ULL, 0x0005e20000200c00ULL,
0x0000541087887816ULL, 0x002fce0000000088ULL, 0x0000004e00947306ULL, 0x0003e20000200c00ULL,
0x0000888057557816ULL, 0x044fe200000000ffULL, 0x0000010057577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000008c5c04723cULL, 0x088fe20000001804ULL, 0x000000004c4c783bULL, 0x002e6c0000000200ULL,
0x0000008400847306ULL, 0x000ee20000200c00ULL, 0x0000008c502c723cULL, 0x010bee000000182cULL,
0x00010000568c7824ULL, 0x060fe200078e00ffULL, 0x00000086008d7306ULL, 0x000fe20000200c00ULL,
0x0000010056567824ULL, 0x000fe200078e00ffULL, 0x000000885c10723cULL, 0x000fe20000001810ULL,
0x0000541094937816ULL, 0x004fc40000000085ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x0000541097877816ULL, 0x008fe20000000084ULL, 0x000000885038723cULL, 0x000be20000001838ULL,
0x0000006e8a857210ULL, 0x140fe40007ffe077ULL, 0x0000006c8a777210ULL, 0x000fe40007ffe077ULL,
0x000088805b847816ULL, 0x000fe200000000ffULL, 0x0000008c008c7306ULL, 0x000ee20000200c00ULL,
0xfffffff058777812ULL, 0x000fe200078ee277ULL, 0x000000905c08723cULL, 0x000fe80000001808ULL,
0x0000001077587824ULL, 0x000fc400078e00ffULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541054837816ULL, 0x004fe20000000083ULL, 0x000000925c0c723cULL, 0x000f62000000180cULL,
0x000100005b547824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x002fe4000001144cULL,
0x00000018ff7e7819ULL, 0x000fe4000001144dULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000054108d8c7816ULL, 0x008fe2000000008cULL, 0x000000905030723cULL, 0x000fe20000001830ULL,
0x00000018ff7c7819ULL, 0x000fc4000001144eULL, 0x00000018ff777819ULL, 0x000fc6000001144fULL,
0x0000005a005a7306ULL, 0x000fe40000200c00ULL, 0x000000925034723cULL, 0x000f6c0000001834ULL,
0x0000009500957306ULL, 0x000e700000200c00ULL, 0x0000008b008b7306ULL, 0x000ff00000200c00ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000054105a867816ULL, 0x002fe20000000095ULL,
0x00000010595a7824ULL, 0x000fc400078e00ffULL, 0x000000ffff597224ULL, 0x000fe200078e0084ULL,
0x00000018ff847819ULL, 0x000fe40000011454ULL, 0xfffffff05a857812ULL, 0x000fe200078ee285ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x000000865c1c723cULL, 0x000fe6000000181cULL,
0x0000001085547824ULL, 0x000fc800078e00ffULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x00000086503c723cULL, 0x000fee000000183cULL, 0x0000008200887306ULL, 0x0204e20000200c00ULL,
0x00005410568d7816ULL, 0x002fce0000000081ULL, 0x0000005700897306ULL, 0x0003220000200c00ULL,
0x000054108b827816ULL, 0x004fe2000000008eULL, 0x0000008c5c24723cULL, 0x000fe20000001824ULL,
0x0000541055887816ULL, 0x008fca0000000088ULL, 0x0000007a007a7306ULL, 0x000fe40000200c00ULL,
0x000000825c20723cULL, 0x000f620000001820ULL, 0x000000005454783bULL, 0x002e620000000200ULL,
0x0000541089897816ULL, 0x010fc80000000080ULL, 0x0000007b007b7306ULL, 0x000ea40000200c00ULL,
0x000000825040723cULL, 0x000fec0000001840ULL, 0x0000007000707306ULL, 0x000fe40000200c00ULL,
0x000000885c28723cULL, 0x000b6e0000001828ULL, 0x000001005b5c7824ULL, 0x020fe200078e00ffULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000088804c5d7816ULL, 0x040fe200000000ffULL,
0x000100004c5e7824ULL, 0x040fe200078e00ffULL, 0x0000008c5044723cULL, 0x000f620000001844ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x000001004c4c7824ULL, 0x000fe200078e00ffULL,
0x000088804d5f7816ULL, 0x000fc400000000ffULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x000054107a7a7816ULL, 0x004fe4000000007bULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000000885048723cULL, 0x000b620000001848ULL, 0x00000018ff5e7819ULL, 0x000fc6000001145eULL,
0x0000005c005c7306ULL, 0x000ea60000200c00ULL, 0x000100004d517824ULL, 0x060fe200078e00ffULL,
0x000088804e527816ULL, 0x040fe200000000ffULL, 0x000100004e537824ULL, 0x040fe400078e00ffULL,
0x000001004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000059008a7306ULL, 0x0009e20000200c00ULL,
0x000054107d7b7816ULL, 0x008fe20000000070ULL, 0x000001004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x000100004f707824ULL, 0x040fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x000000ffff507224ULL, 0x000fe200078e005fULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x000000005858783bULL, 0x010f220000000200ULL, 0x000054105c8b7816ULL, 0x004fe2000000006fULL,
0x000001004f5c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000007a540c723cULL, 0x002f62000000180cULL, 0x000088804f5f7816ULL, 0x000fc400000000ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff5c7819ULL, 0x000fca000001145cULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541075757816ULL, 0x008fce0000000072ULL, 0x0000007400747306ULL, 0x000e700000200c00ULL,
0x0000007800787306ULL, 0x000eb00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541073747816ULL, 0x002fe20000000074ULL, 0x0000007a5834723cULL, 0x010f6c0000001834ULL,
0x0000004c004c7306ULL, 0x000fe40000200c00ULL, 0x000000745404723cULL, 0x080f6c0000001804ULL,
0x0000007700807306ULL, 0x0005e40000200c00ULL, 0x00000074582c723cULL, 0x000f6c000000182cULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541078777816ULL, 0x004fce0000000071ULL,
0x0000005100517306ULL, 0x000e700000200c00ULL, 0x0000005200527306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541050507816ULL, 0x002fce0000000051ULL,
0x0000007600767306ULL, 0x000ff00000200c00ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541052527816ULL, 0x004fce0000000053ULL, 0x0000007e007e7306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000079ULL,
0x0000008400817306ULL, 0x000e620000200c00ULL, 0x000000765408723cULL, 0x080f6e0000001808ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000000765830723cULL, 0x000b6e0000001830ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054108a8a7816ULL, 0x002fc40000000081ULL,
0xfffffff46d777810ULL, 0x020fca0007ffe0ffULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0000008a5410723cULL, 0x080b6e0000001810ULL, 0x0000004e00717306ULL, 0x000ee20000200c00ULL,
0x000054105d5e7816ULL, 0x004fe2000000005eULL, 0x0000008a5838723cULL, 0x000b6c0000001838ULL,
0x0000005f00727306ULL, 0x0005e20000200c00ULL, 0x000054104d517816ULL, 0x002fce000000007eULL,
0x00000070004f7306ULL, 0x000e620000200c00ULL, 0x000054104c5f7816ULL, 0x004fe2000000007fULL,
0x000000505420723cULL, 0x040b620000001820ULL, 0x000000046d4c7810ULL, 0x000fe40007ffe0ffULL,
0x0000541071537816ULL, 0x008fe4000000007cULL, 0x000000184c00780cULL, 0x000fe20003f25270ULL,
0x0000005c00737306ULL, 0x000ea20000200c00ULL, 0x000000ffff6d7224ULL, 0x000fe200078e004cULL,
0x0000005e541c723cULL, 0x000b62000000181cULL, 0x0000541072727816ULL, 0x002fce000000004fULL,
0x000000525424723cULL, 0x000b620000001824ULL, 0x0000541073737816ULL, 0x004fce0000000080ULL,
0x0000005e583c723cULL, 0x000b70000000183cULL, 0x000000725428723cULL, 0x000b700000001828ULL,
0x000000505840723cULL, 0x040b700000001840ULL, 0x000000525844723cULL, 0x040b700000001844ULL,
0x000000725848723cULL, 0x000b620000001848ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffedb000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff697224ULL, 0x000fe200078e0017ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006422227220ULL, 0x0a0fe20000410000ULL, 0x0000006432567220ULL, 0x080fe20000410000ULL,
0x0000006434347220ULL, 0x080fe20000410000ULL, 0x0000006435327220ULL, 0x080fe20000410000ULL,
0x00000064044f7220ULL, 0x080fe20000410000ULL, 0x00000064054e7220ULL, 0x080fe20000410000ULL,
0x00000064084d7220ULL, 0x080fe20000410000ULL, 0x00000064094c7220ULL, 0x080fe20000410000ULL,
0x0000006411507220ULL, 0x080fe20000410000ULL, 0x000000641c517220ULL, 0x080fe20000410000ULL,
0x0000006424247220ULL, 0x080fe20000410000ULL, 0x0000006425257220ULL, 0x080fe20000410000ULL,
0x0000006426267220ULL, 0x080fe20000410000ULL, 0x0000006428287220ULL, 0x080fe20000410000ULL,
0x0000006429297220ULL, 0x080fe20000410000ULL, 0x000000642b2b7220ULL, 0x080fe20000410000ULL,
0x0000006439357220ULL, 0x080fe20000410000ULL, 0x0000006406067220ULL, 0x080fe20000410000ULL,
0x0000006407077220ULL, 0x080fe20000410000ULL, 0x000000640a0a7220ULL, 0x080fe20000410000ULL,
0x000000640b0b7220ULL, 0x080fe20000410000ULL, 0x000000640c0c7220ULL, 0x080fe20000410000ULL,
0x000000640d0d7220ULL, 0x080fe20000410000ULL, 0x000000640e0e7220ULL, 0x080fe20000410000ULL,
0x000000640f0f7220ULL, 0x080fe20000410000ULL, 0x0000006410107220ULL, 0x080fe20000410000ULL,
0x0000006412127220ULL, 0x080fe20000410000ULL, 0x0000006413137220ULL, 0x080fe20000410000ULL,
0x000000641d1d7220ULL, 0x080fe20000410000ULL, 0x000000641e1e7220ULL, 0x080fe20000410000ULL,
0x000000641f1f7220ULL, 0x080fe20000410000ULL, 0x0000006420207220ULL, 0x080fe20000410000ULL,
0x0000006421217220ULL, 0x080fe20000410000ULL, 0x0000006423047220ULL, 0x080fe20000410000ULL,
0x0000006427057220ULL, 0x080fe20000410000ULL, 0x000000642a087220ULL, 0x080fe20000410000ULL,
0x000000642c097220ULL, 0x080fe20000410000ULL, 0x000000642d117220ULL, 0x080fe20000410000ULL,
0x000000642f557220ULL, 0x080fe20000410000ULL, 0x00000064301c7220ULL, 0x080fe20000410000ULL,
0x0000006431527220ULL, 0x080fe20000410000ULL, 0x000000643c3c7220ULL, 0x080fe20000410000ULL,
0x0000006433577220ULL, 0x080fe20000410000ULL, 0x0000006436587220ULL, 0x080fe20000410000ULL,
0x000000643a5a7220ULL, 0x080fe20000410000ULL, 0x000000643f5d7220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0022ULL, 0x0000006437597220ULL, 0x080fe20000410000ULL,
0x0000006438337220ULL, 0x080fe20000410000ULL, 0x000000643b5b7220ULL, 0x080fe20000410000ULL,
0x000000643d367220ULL, 0x080fe20000410000ULL, 0x00000064425e7220ULL, 0x080fe20000410000ULL,
0x00000064435f7220ULL, 0x080fe20000410000ULL, 0x00000064443f7220ULL, 0x080fe20000410000ULL,
0x00000064453a7220ULL, 0x080fe20000410000ULL, 0x000000ffff227224ULL, 0x000fe200078e0034ULL,
0x000000642e547220ULL, 0x080fe20000410000ULL, 0x000000643e5c7220ULL, 0x080fe20000410000ULL,
0x0000006440377220ULL, 0x080fe20000410000ULL, 0x0000006441387220ULL, 0x080fe20000410000ULL,
0x0000006446687220ULL, 0x080fe20000410000ULL, 0x0000006447697220ULL, 0x080fe20000410000ULL,
0x00000064483b7220ULL, 0x080fe20000410000ULL, 0x0000006449537220ULL, 0x080fe20000410000ULL,
0x000000644a6a7220ULL, 0x080fe20000410000ULL, 0x000000644b6b7220ULL, 0x000fe20000410000ULL,
0x000000ffff457224ULL, 0x000fc400078e0024ULL, 0x000000ffff447224ULL, 0x000fe400078e0025ULL,
0x000000ffff437224ULL, 0x000fe400078e0028ULL, 0x000000ffff427224ULL, 0x000fe400078e0029ULL,
0x000000ffff307224ULL, 0x000fe400078e0026ULL, 0x000000ffff3d7224ULL, 0x000fe400078e002bULL,
0x000000ffff347224ULL, 0x000fc400078e0035ULL, 0x000000ffff4b7224ULL, 0x000fe400078e000cULL,
0x000000ffff4a7224ULL, 0x000fe400078e000dULL, 0x000000ffff497224ULL, 0x000fe400078e0010ULL,
0x000000ffff487224ULL, 0x000fe400078e001dULL, 0x000000ffff477224ULL, 0x000fe400078e0020ULL,
0x000000ffff467224ULL, 0x000fc400078e0021ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff297224ULL, 0x000fe400078e0007ULL, 0x000000ffff277224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff237224ULL, 0x000fe400078e000eULL,
0x000000ffff417224ULL, 0x000fc400078e000fULL, 0x000000ffff2c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0013ULL, 0x000000ffff2d7224ULL, 0x000fe400078e001eULL,
0x000000ffff407224ULL, 0x000fe400078e001fULL, 0x000000ffff397224ULL, 0x000fe400078e0004ULL,
0x000000ffff317224ULL, 0x000fc400078e0005ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0008ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0009ULL, 0x000000ffff287224ULL, 0x000fe400078e0011ULL,
0x000000ffff267224ULL, 0x000fe400078e001cULL, 0x000000ffff247224ULL, 0x000fe400078e0052ULL,
0x000000ffff357224ULL, 0x000fe200078e003cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000062087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fc400078e0053ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0054ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0055ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0056ULL, 0x000000ffff137224ULL, 0x000fe400078e0057ULL,
0x000000ffff217224ULL, 0x000fe400078e0058ULL, 0x000000ffff207224ULL, 0x000fc400078e0059ULL,
0x000000ffff1f7224ULL, 0x000fe400078e005aULL, 0x000000ffff127224ULL, 0x000fe400078e005bULL,
0x000000ffff117224ULL, 0x000fe400078e005cULL, 0x000000ffff107224ULL, 0x000fe400078e005dULL,
0x000000ffff0a7224ULL, 0x000fe400078e005eULL, 0x000000ffff0b7224ULL, 0x000fc400078e005fULL,
0x000000ffff0c7224ULL, 0x000fe400078e0068ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0069ULL,
0x000000ffff0e7224ULL, 0x000fe400078e006aULL, 0x000000ffff0f7224ULL, 0x000fc400078e006bULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040062077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000105200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604537210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000005306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040062077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000466097824ULL, 0x000fe200078e00ffULL,
0x000000671400720cULL, 0x000fc80003f06070ULL, 0xfffffff009057812ULL, 0x000fca00078ec0ffULL,
0x000000801a087824ULL, 0x000fca00078e0205ULL, 0x0124000008047984ULL, 0x0002a20000000c00ULL,
0x000021f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000557b06ULL, 0x000ee20000209000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x0000001966547211ULL, 0x000fe400078ff0ffULL,
0x00005a00ff5f7a12ULL, 0x000fc800078e33ffULL, 0x0000005500557308ULL, 0x008ee40000001000ULL,
0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL, 0x0000005700537305ULL, 0x000ee4000021f000ULL,
0x000000ffff597224ULL, 0x008fc800078e0a53ULL, 0x00005a0059597a24ULL, 0x000fc800078e02ffULL,
0x00000059535c7227ULL, 0x000fe200078e0052ULL, 0x0000000854527810ULL, 0x040fe40007ffe0ffULL,
0x0000001054537810ULL, 0x040fe40007ffe0ffULL, 0x0000001854597810ULL, 0x000fe20007ffe0ffULL,
0x000000525c587227ULL, 0x000fc800078e00ffULL, 0x000000545c567227ULL, 0x000fc800078e00ffULL,
0x000000ffff577224ULL, 0x000fe400078e0a58ULL, 0x000000ffff557224ULL, 0x000fe400078e0a56ULL,
0x000000535c5a7227ULL, 0x000fc800078e00ffULL, 0x00005a0057577a24ULL, 0x000fe400078e0252ULL,
0x00005a0055557a24ULL, 0x000fe400078e0254ULL, 0x000000ffff527224ULL, 0x000fe200078e0a5aULL,
0x00005a0057007a0cULL, 0x000fe20003fa6070ULL, 0x000000595c5c7227ULL, 0x000fe200078e00ffULL,
0x00005a0055007a0cULL, 0x000fc60003f06070ULL, 0x00005a0052547a24ULL, 0x000fe400078e0253ULL,
0x0000010014537824ULL, 0x000fe400078e0263ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0a5cULL,
0x00005a0054007a0cULL, 0x000fe40003f26070ULL, 0x0000005316527217ULL, 0x000fe20007800000ULL,
0x00005a005e5b7a24ULL, 0x000fe200078e0259ULL, 0x80005a0057575a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0055550a10ULL, 0x000fe20007ffe0ffULL, 0x0000000152527824ULL, 0x000fe200078e0a53ULL,
0x00005a005b007a0cULL, 0x000fe20003f66070ULL, 0x0000000266537824ULL, 0x000fe200078e00ffULL,
0x00005a0057007a0cULL, 0x000fc40003fc6070ULL, 0x00005a0055007a0cULL, 0x000fe40003f46070ULL,
0x0000000653537812ULL, 0x000fe400078ec0ffULL, 0x80005a0054541a10ULL, 0x000fe40007ffe0ffULL,
0x0000000158585810ULL, 0x000fe20007ffe0ffULL, 0x000000011b597824ULL, 0x000fe200078e0253ULL,
0x0000000156560810ULL, 0x000fe20007ffe0ffULL, 0x0000000153557824ULL, 0x000fe200078e0261ULL,
0x00005a0054007a0cULL, 0x000fc40003f86070ULL, 0x000000525900720cULL, 0x000fe20003f06070ULL,
0x0000000155577824ULL, 0x100fe200078e0a52ULL, 0x80005a005b5b3a10ULL, 0x000fe20007ffe0ffULL,
0x0000000159597824ULL, 0x000fe200078e0a52ULL, 0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL,
0x0000000158586810ULL, 0x000fe40007ffe0ffULL, 0x0000000156562810ULL, 0x000fe40007ffe0ffULL,
0x0000005760687217ULL, 0x000fc40003800000ULL, 0x00005a005b007a0cULL, 0x000fe40003f46070ULL,
0x000000565f577207ULL, 0x040fe40006800000ULL, 0x0000005960597217ULL, 0x040fe40003800000ULL,
0x000000585f5b7207ULL, 0x000fe40006800000ULL, 0x0000005760547217ULL, 0x000fe40003800000ULL,
0x00000004ff597819ULL, 0x000fc40000011659ULL, 0x000000015a5a1810ULL, 0x000fe20007ffe0ffULL,
0x0000005465857224ULL, 0x000fe200078e02ffULL, 0x0000005b60567217ULL, 0x000fe40003800000ULL,
0x000000525500720cULL, 0x000fe40003fc6070ULL, 0x000000015c5c3810ULL, 0x000fe20007ffe0ffULL,
0x0000005665897224ULL, 0x000fe200078e02ffULL, 0x000000ff595e7207ULL, 0x000fe40000000000ULL,
0x000000015a5a4810ULL, 0x000fc40007ffe0ffULL, 0x000000ff68687207ULL, 0x000fe20003000000ULL,
0x000000015e5d7824ULL, 0x000fe200078e0289ULL, 0x000000015c5c2810ULL, 0x000fe20007ffe0ffULL,
0x00000001855b7824ULL, 0x000fe200078e025eULL, 0x0000005a5f577207ULL, 0x000fe40006800000ULL,
0x0000008568597211ULL, 0x000fe200078fe0ffULL, 0x000000025b5a7825ULL, 0x100fe200078e0002ULL,
0x0000005c5f5f7207ULL, 0x000fe40006800000ULL, 0x0000005760567217ULL, 0x040fe20003800000ULL,
0x000000025d5c7825ULL, 0x000fe200078e0002ULL, 0x000000065a547981ULL, 0x000722000c1e9500ULL,
0x0000005f606a7217ULL, 0x000fc40003800000ULL, 0x0000000259587825ULL, 0x000fc800078e0002ULL,
0x00000056658b7224ULL, 0x000fe200078e02ffULL, 0x0000000658577981ULL, 0x000328000c1e9500ULL,
0x000000065c567981ULL, 0x000522000c1e9500ULL, 0x00000089686b7211ULL, 0x000fe200078fe0ffULL,
0x000000015e6f7824ULL, 0x000fe200078e028bULL, 0x0000008b686d7211ULL, 0x000fe400078fe0ffULL,
0x00000010535d7812ULL, 0x004fe200078efcffULL, 0x0000006a658d7224ULL, 0x000fc800078e02ffULL,
0x000000011b777824ULL, 0x000fe400078e025dULL, 0x000000026b6a7825ULL, 0x000fc800078e0002ULL,
0x000000026f6e7825ULL, 0x100fe200078e0002ULL, 0x000000066a597981ULL, 0x0022a6000c1e9500ULL,
0x000000026d6c7825ULL, 0x000fe200078e0002ULL, 0x000000066e587981ULL, 0x0002a6000c1e9500ULL,
0x0000000177757824ULL, 0x000fe200078e0a52ULL, 0x000000066c5b7981ULL, 0x0086a2000c1e9500ULL,
0x000000015d5f7824ULL, 0x000fe200078e0261ULL, 0x0000008d68717211ULL, 0x000fc400078fe0ffULL,
0x00000075605c7217ULL, 0x000fe20003800000ULL, 0x000000015f757824ULL, 0x000fe200078e0a52ULL,
0x000000527700720cULL, 0x080fe20003f26070ULL, 0x000000015e737824ULL, 0x000fe200078e028dULL,
0x00000004ff5c7819ULL, 0x000fe2000001165cULL, 0x0000000271707825ULL, 0x100fe200078e0002ULL,
0x000000525f00720cULL, 0x000fe40003f06070ULL, 0x0000007560757217ULL, 0x000fe20003800000ULL,
0x0000000273727825ULL, 0x000fe200078e0002ULL, 0x000000ff5c6e7207ULL, 0x002fe20000800000ULL,
0x0000000670697981ULL, 0x0002a2000c1e9500ULL, 0x000000ff757a7207ULL, 0x000fc40000000000ULL,
0x0000002053797812ULL, 0x000fe200078efcffULL, 0x00000006725a7981ULL, 0x0002a2000c1e9500ULL,
0x000000857a6b7211ULL, 0x040fe200078fe0ffULL, 0x00000001856d7824ULL, 0x008fe200078e026eULL,
0x000000897a6f7211ULL, 0x000fe200078fe0ffULL, 0x000000016e717824ULL, 0x002fe400078e0289ULL,
0x000000011b817824ULL, 0x000fe400078e0279ULL, 0x0000000271707825ULL, 0x000fc800078e0002ULL,
0x000000026d6c7825ULL, 0x100fe200078e0002ULL, 0x00000006705e7981ULL, 0x0002e6000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fe200078e0002ULL, 0x000000066c5c7981ULL, 0x0002e6000c1e9500ULL,
0x000000016e757824ULL, 0x040fe400078e028bULL, 0x000000016e7f7824ULL, 0x000fe200078e028dULL,
0x000000066a6b7981ULL, 0x0002e2000c1e9500ULL, 0x000000026f6e7825ULL, 0x000fe200078e0002ULL,
0x0000008d7a7d7211ULL, 0x000fc600078fe0ffULL, 0x0000000181717824ULL, 0x102fe200078e0a52ULL,
0x000000066e6d7981ULL, 0x0002e2000c1e9500ULL, 0x00000001797b7824ULL, 0x000fe200078e0261ULL,
0x0000008b7a737211ULL, 0x000fe400078fe0ffULL, 0x0000007160707217ULL, 0x000fe20003800000ULL,
0x000000017b717824ULL, 0x000fe400078e0a52ULL, 0x000000027d7c7825ULL, 0x000fe200078e0002ULL,
0x000000528100720cULL, 0x000fc60003f26070ULL, 0x0000000273727825ULL, 0x000fe200078e0002ULL,
0x000000527b00720cULL, 0x000fe20003f06070ULL, 0x000000067c7d7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff707819ULL, 0x000fe20000011670ULL, 0x0000000275747825ULL, 0x100fe200078e0002ULL,
0x0000007160717217ULL, 0x000fe20003800000ULL, 0x0000000672777981ULL, 0x0002e4000c1e9500ULL,
0x000000027f7e7825ULL, 0x000fe400078e0002ULL, 0x00000006746a7981ULL, 0x0002e4000c1e9500ULL,
0x000000ff717c7207ULL, 0x002fc40000000000ULL, 0x000000067e6c7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff70727207ULL, 0x000fe40000800000ULL, 0x000000897c737211ULL, 0x000fc600078fe0ffULL,
0x0000000172817824ULL, 0x000fe200078e0289ULL, 0x000000857c6f7211ULL, 0x000fe200078fe0ffULL,
0x0000000185717824ULL, 0x000fe400078e0272ULL, 0x0000000172757824ULL, 0x040fe400078e028bULL,
0x00000001728f7824ULL, 0x000fe400078e028dULL, 0x0000000281807825ULL, 0x000fc800078e0002ULL,
0x0000000273727825ULL, 0x100fe200078e0002ULL, 0x0000000680787981ULL, 0x0002e2000c1e9500ULL,
0x0000008d7c877211ULL, 0x040fe400078fe0ffULL, 0x000000026f6e7825ULL, 0x100fe200078e0002ULL,
0x0000000672cf7981ULL, 0x0002e2000c1e9500ULL, 0x0000003053b57812ULL, 0x000fe400078efcffULL,
0x0000000271707825ULL, 0x100fe200078e0002ULL, 0x0000008b7c7f7211ULL, 0x002fe200078fe0ffULL,
0x000000066e837981ULL, 0x0002e4000c1e9500ULL, 0x0000000275747825ULL, 0x000fc400078e0002ULL,
0x0000000670767981ULL, 0x0002e4000c1e9500ULL, 0x000000027f7e7825ULL, 0x100fe400078e0002ULL,
0x00000006748c7981ULL, 0x0002e4000c1e9500ULL, 0x00000002876e7825ULL, 0x002fe400078e0002ULL,
0x000000067ed37981ULL, 0x0002e4000c1e9500ULL, 0x000000011b877824ULL, 0x000fc400078e02b5ULL,
0x000000028f707825ULL, 0x000fe200078e0002ULL, 0x000000066ed77981ULL, 0x0002e6000c1e9500ULL,
0x0000000187817824ULL, 0x000fe200078e0a52ULL, 0x0000000670907981ULL, 0x0002e2000c1e9500ULL,
0x00000001b5b77824ULL, 0x000fc600078e0261ULL, 0x0000008160807217ULL, 0x040fe20003800000ULL,
0x00000001b7817824ULL, 0x000fe200078e0a52ULL, 0x000000528700720cULL, 0x080fe40003f26070ULL,
0x00000052b700720cULL, 0x000fe40003f06070ULL, 0x00000004ff807819ULL, 0x000fe40000011680ULL,
0x0000008160817217ULL, 0x000fe40003800000ULL, 0x000000ff80847207ULL, 0x000fc40000800000ULL,
0x000000ff81827207ULL, 0x000fc60000000000ULL, 0x00000001857f7824ULL, 0x002fe200078e0284ULL,
0x0000008582817211ULL, 0x000fe200078fe0ffULL, 0x0000000184737824ULL, 0x000fe200078e028bULL,
0x0000008b82757211ULL, 0x000fe200078fe0ffULL, 0x000000027f7e7825ULL, 0x000fc800078e0002ULL,
0x0000000281807825ULL, 0x100fe200078e0002ULL, 0x000000067e867981ULL, 0x0002e6000c1e9500ULL,
0x0000000273727825ULL, 0x100fe200078e0002ULL, 0x0000000680b97981ULL, 0x0002e6000c1e9500ULL,
0x0000000275747825ULL, 0x000fe200078e0002ULL, 0x00000006728e7981ULL, 0x0002e2000c1e9500ULL,
0x0000008982717211ULL, 0x000fc600078fe0ffULL, 0x0000000674d57981ULL, 0x0002e2000c1e9500ULL,
0x00000001846f7824ULL, 0x000fe400078e0289ULL, 0x0000000271707825ULL, 0x000fc800078e0002ULL,
0x000000026f6e7825ULL, 0x000fe200078e0002ULL, 0x0000000670d17981ULL, 0x0002e4000c1e9500ULL,
0x0000008d827f7211ULL, 0x002fe400078fe0ffULL, 0x000000066e8a7981ULL, 0x0002e2000c1e9500ULL,
0x0000000184817824ULL, 0x000fe400078e028dULL, 0x000000027f7e7825ULL, 0x000fc800078e0002ULL,
0x0000000281807825ULL, 0x000fe200078e0002ULL, 0x000000067ed97981ULL, 0x0002e8000c1e9500ULL,
0x0000000680927981ULL, 0x0002e4000c1e9500ULL, 0xfffffff0686f7812ULL, 0x002fe200078ec0ffULL,
0x00000001ffcd7424ULL, 0x000fc800078e00ffULL, 0x0000000152687824ULL, 0x000fe200078e026fULL,
0xfffffff07a6f7812ULL, 0x000fc600078ec0ffULL, 0x00000001556e7824ULL, 0x000fe200078e0a68ULL,
0x0000000153857812ULL, 0x000fe200078efcffULL, 0x0000000152747824ULL, 0x000fc600078e026fULL,
0x0000006ecd6f7219ULL, 0x000fe200000006ffULL, 0x0000000185717824ULL, 0x000fe200078e0261ULL,
0xfffffff07c737812ULL, 0x000fc600078ec0ffULL, 0x0000000171707824ULL, 0x100fe200078e0a68ULL,
0x0000000853877812ULL, 0x040fe200078efcffULL, 0x00000001527a7824ULL, 0x000fe200078e0273ULL,
0x0000000953897812ULL, 0x000fe400078efcffULL, 0x00000070cd737219ULL, 0x000fe200000006ffULL,
0x0000000187757824ULL, 0x100fe400078e0261ULL, 0x0000000189817824ULL, 0x000fe200078e0261ULL,
0xfffffff0827f7812ULL, 0x000fe200078ec0ffULL, 0x0000000175727824ULL, 0x000fc400078e0a68ULL,
0x0000000181687824ULL, 0x000fe200078e0a68ULL, 0x00000011538f7812ULL, 0x000fe200078efcffULL,
0x0000000152807824ULL, 0x000fe200078e027fULL, 0x00000072cd7f7219ULL, 0x040fe400000006ffULL,
0x00000068cd8b7219ULL, 0x000fe200000006ffULL, 0x000000018f917824ULL, 0x000fe400078e0261ULL,
0x000000015f687824ULL, 0x100fe400078e0a74ULL, 0x00000001916e7824ULL, 0x000fe200078e0a74ULL,
0x0000541057547816ULL, 0x010fc80000000054ULL, 0x000000546fff7212ULL, 0x000fc800078ac0ffULL,
0x000000525500720cULL, 0x000fc80002fa1470ULL, 0x000000525300720cULL, 0x000fe40002fa1070ULL,
0x0000005473ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000004f4f7808ULL, 0x000fe40002800000ULL,
0x000000527100720cULL, 0x000fe40000f21470ULL, 0x0000541059567816ULL, 0x004fc80000000056ULL,
0x000000566fff7212ULL, 0x080fe4000784c0ffULL, 0x000054105b587816ULL, 0x000fe40000000058ULL,
0x0000005673ff7212ULL, 0x000fe400078ac0ffULL, 0x000000586fff7212ULL, 0x000fe4000788c0ffULL,
0x000000525500720cULL, 0x0c0fe40001741470ULL, 0x000000525500720cULL, 0x000fc40002781470ULL,
0x000000527100720cULL, 0x080fe40002fa1470ULL, 0x000000525300720cULL, 0x0c0fe40001741070ULL,
0x000000525300720cULL, 0x080fe40002781070ULL, 0x000000528500720cULL, 0x0c0fe40000f21070ULL,
0x000000528500720cULL, 0x000fe40002fa1070ULL, 0x00005410695a7816ULL, 0x000fc4000000005aULL,
0xff8000002a2a7808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000004e4e7808ULL, 0x000fe40000800000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x000000547fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005a6fff7212ULL, 0x000fc4000780c0ffULL,
0x0000005873ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005a73ff7212ULL, 0x000fe4000788c0ffULL,
0x000000568bff7212ULL, 0x000fe4000782c0ffULL, 0x000000587fff7212ULL, 0x000fe400078ac0ffULL,
0x000000525500720cULL, 0x080fe40000701470ULL, 0x000000527100720cULL, 0x000fc40001741470ULL,
0x000000527100720cULL, 0x080fe40002781470ULL, 0x000000527500720cULL, 0x0c0fe40001f61470ULL,
0x000000527500720cULL, 0x080fe40002fa1470ULL, 0x000000528100720cULL, 0x000fe40000f21470ULL,
0x0000001853957812ULL, 0x040fe400078efcffULL, 0x00000019539b7812ULL, 0x000fc400078efcffULL,
0x000000525300720cULL, 0x080fe40000701070ULL, 0x000000528500720cULL, 0x0c0fe40001741070ULL,
0x000000528500720cULL, 0x080fe40002781070ULL, 0x000000528700720cULL, 0x0c0fe40001f61070ULL,
0x000000528700720cULL, 0x080fe40002fa1070ULL, 0x000000528900720cULL, 0x000fc40000f21070ULL,
0x00000068cd8d7219ULL, 0x040fe400000006ffULL, 0x0000006ecd937219ULL, 0x000fe400000006ffULL,
0x000054106b5c7816ULL, 0x008fe4000000005cULL, 0x000054106d5e7816ULL, 0x000fe2000000005eULL,
0x0000000195977824ULL, 0x100fe200078e0261ULL, 0xff8000001e1e7808ULL, 0x000fe20000000000ULL,
0x000000019b9d7824ULL, 0x000fe200078e0261ULL, 0xff80000028287808ULL, 0x000fc40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40001800000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0x000000567fff7212ULL, 0x000fe4000780c0ffULL, 0x000000588bff7212ULL, 0x000fc4000784c0ffULL,
0x0000005a7fff7212ULL, 0x080fe4000788c0ffULL, 0x0000005a8bff7212ULL, 0x000fe4000786c0ffULL,
0x0000005c93ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e8dff7212ULL, 0x000fe2000782c0ffULL,
0x0000000197707824ULL, 0x100fe200078e0a74ULL, 0x000000527500720cULL, 0x080fe20000701470ULL,
0x000000019d747824ULL, 0x000fe200078e0a74ULL, 0x000000527500720cULL, 0x000fc40002781470ULL,
0x000000528100720cULL, 0x0c0fe40001741470ULL, 0x000000528100720cULL, 0x080fe40001f61470ULL,
0x000000525f00720cULL, 0x080fe40000f21470ULL, 0x000000529100720cULL, 0x080fe40002fa1470ULL,
0x000000528700720cULL, 0x0c0fe40000701070ULL, 0x000000528700720cULL, 0x000fc40002781070ULL,
0x000000528900720cULL, 0x0c0fe40001741070ULL, 0x000000528900720cULL, 0x080fe40001f61070ULL,
0x000000525d00720cULL, 0x080fe40000f21070ULL, 0x000000528f00720cULL, 0x000fe40002fa1070ULL,
0x00000070cd997219ULL, 0x040fe400000006ffULL, 0x00000074cd9f7219ULL, 0x000fc400000006ffULL,
0x00005410776a7816ULL, 0x000fe4000000006aULL, 0x000054107d6c7816ULL, 0x000fe4000000006cULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fc40001800000ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40002800000ULL,
0x0000005c8dff7212ULL, 0x080fe4000780c0ffULL, 0x0000005c99ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006a8dff7212ULL, 0x040fe4000784c0ffULL, 0x0000006c8dff7212ULL, 0x000fc4000786c0ffULL,
0x0000006a93ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005e9fff7212ULL, 0x000fe200078ac0ffULL,
0x000000017b727824ULL, 0x000fe200078e0a7aULL, 0x000000525f00720cULL, 0x0c0fe40000701470ULL,
0x000000525f00720cULL, 0x0c0fe40001741470ULL, 0x000000525f00720cULL, 0x080fe40001f61470ULL,
0x000000529100720cULL, 0x000fc40000f21470ULL, 0x000000529700720cULL, 0x080fe40002781470ULL,
0x000000529d00720cULL, 0x080fe40002fa1470ULL, 0x0000002153a37812ULL, 0x000fe400078efcffULL,
0x000000525d00720cULL, 0x0c0fe40000701070ULL, 0x000000525d00720cULL, 0x0c0fe40001741070ULL,
0x000000525d00720cULL, 0x000fc40001f61070ULL, 0x000000528f00720cULL, 0x080fe40000f21070ULL,
0x000000529500720cULL, 0x080fe40002781070ULL, 0x000000529b00720cULL, 0x000fe40002fa1070ULL,
0x00000072cda17219ULL, 0x000fe400000006ffULL, 0x00005410cf787816ULL, 0x000fe20000000078ULL,
0x00000001a3a57824ULL, 0x000fe200078e0261ULL, 0xff8000004b4b7808ULL, 0x000fc40000000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0x0000005e93ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006c93ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005e99ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006a9fff7212ULL, 0x040fe4000782c0ffULL, 0x0000006c9fff7212ULL, 0x000fe4000788c0ffULL,
0x00000078a1ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a57c7824ULL, 0x000fe200078e0a7aULL,
0x000000529100720cULL, 0x000fc40000701470ULL, 0x000000529100720cULL, 0x080fe40001741470ULL,
0x000000529700720cULL, 0x080fe40001f61470ULL, 0x000000529d00720cULL, 0x0c0fe40000f21470ULL,
0x000000529d00720cULL, 0x080fe40002781470ULL, 0x000000527b00720cULL, 0x000fe40002fa1470ULL,
0x0000002853a97812ULL, 0x000fc400078efcffULL, 0x0000002953af7812ULL, 0x000fe400078efcffULL,
0x000000528f00720cULL, 0x0c0fe40000701070ULL, 0x000000528f00720cULL, 0x080fe40001741070ULL,
0x000000529500720cULL, 0x080fe40001f61070ULL, 0x000000529b00720cULL, 0x0c0fe40000f21070ULL,
0x000000529b00720cULL, 0x000fc40002781070ULL, 0x000000527900720cULL, 0x000fe40002fa1070ULL,
0x0000007ccda77219ULL, 0x000fe400000006ffULL, 0x0000541083767816ULL, 0x000fe40000000076ULL,
0x00005410d38c7816ULL, 0x000fe4000000008cULL, 0x00005410d7907816ULL, 0x000fe20000000090ULL,
0x00000001a9ab7824ULL, 0x100fe200078e0261ULL, 0xff80000041417808ULL, 0x000fe20000000000ULL,
0x00000001afb17824ULL, 0x000fe200078e0261ULL, 0xff80000020207808ULL, 0x000fc40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x000000548bff7212ULL, 0x000fe400078cc0ffULL, 0x0000006a99ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006c99ff7212ULL, 0x000fe4000784c0ffULL, 0x00000076a1ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008ca1ff7212ULL, 0x040fe4000782c0ffULL, 0x00000090a1ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008ca7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ab7e7824ULL, 0x100fe200078e0a7aULL,
0x000000528100720cULL, 0x080fe200037c1470ULL, 0x00000001b17a7824ULL, 0x000fe200078e0a7aULL,
0x000000529700720cULL, 0x000fc40000701470ULL, 0x000000529700720cULL, 0x080fe40001741470ULL,
0x000000527b00720cULL, 0x0c0fe40001f61470ULL, 0x000000527b00720cULL, 0x0c0fe40000f21470ULL,
0x000000527b00720cULL, 0x080fe40002781470ULL, 0x00000052a500720cULL, 0x080fe40002fa1470ULL,
0x000000528900720cULL, 0x000fc400037c1070ULL, 0x000000529500720cULL, 0x0c0fe40000701070ULL,
0x000000529500720cULL, 0x080fe40001741070ULL, 0x000000527900720cULL, 0x0c0fe40001f61070ULL,
0x000000527900720cULL, 0x0c0fe40000f21070ULL, 0x000000527900720cULL, 0x080fe40002781070ULL,
0x00000052a300720cULL, 0x000fc40002fa1070ULL, 0x0000007ecdad7219ULL, 0x040fe400000006ffULL,
0x0000007acdb37219ULL, 0x000fe400000006ffULL, 0xff8000004c4c7808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fc40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002000000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0x0000005c9fff7212ULL, 0x000fe400078cc0ffULL, 0x00000076a7ff7212ULL, 0x080fe4000780c0ffULL,
0x00000076adff7212ULL, 0x000fc4000784c0ffULL, 0x00000078a7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000090a7ff7212ULL, 0x000fe4000782c0ffULL, 0x00000078adff7212ULL, 0x000fe4000788c0ffULL,
0x0000008cb3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b7827824ULL, 0x000fe200078e0a80ULL,
0x000000529d00720cULL, 0x080fe400037c1470ULL, 0x00000052a500720cULL, 0x000fc40000701470ULL,
0x00000052a500720cULL, 0x0c0fe40001f61470ULL, 0x00000052a500720cULL, 0x080fe40000f21470ULL,
0x00000052ab00720cULL, 0x0c0fe40001741470ULL, 0x00000052ab00720cULL, 0x080fe40002781470ULL,
0x00000052b100720cULL, 0x000fe40002fa1470ULL, 0x0000003153bd7812ULL, 0x000fc400078efcffULL,
0x0000003853c37812ULL, 0x040fe400078efcffULL, 0x0000003953c97812ULL, 0x000fe400078efcffULL,
0x000000529b00720cULL, 0x080fe400037c1070ULL, 0x00000052a300720cULL, 0x0c0fe40000701070ULL,
0x00000052a300720cULL, 0x0c0fe40001f61070ULL, 0x00000052a300720cULL, 0x000fc40000f21070ULL,
0x00000052a900720cULL, 0x0c0fe40001741070ULL, 0x00000052a900720cULL, 0x080fe40002781070ULL,
0x00000052af00720cULL, 0x000fe40002fa1070ULL, 0x00000082cdbb7219ULL, 0x000fe400000006ffULL,
0x00005410b9867816ULL, 0x000fe40000000086ULL, 0x00005410d58e7816ULL, 0x000fe2000000008eULL,
0x00000001bdbf7824ULL, 0x100fe200078e0261ULL, 0xff80000050507808ULL, 0x000fe20003000000ULL,
0x00000001c3c57824ULL, 0x100fe200078e0261ULL, 0xff80000048487808ULL, 0x000fe20000000000ULL,
0x00000001c9cb7824ULL, 0x000fe200078e0261ULL, 0xff80000040407808ULL, 0x000fc40001800000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000047477808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000038387808ULL, 0x000fe40002800000ULL,
0x00000076b3ff7212ULL, 0x040fe400078cc0ffULL, 0x00000078b3ff7212ULL, 0x000fc4000780c0ffULL,
0x0000008cadff7212ULL, 0x040fe4000786c0ffULL, 0x00000090adff7212ULL, 0x080fe4000782c0ffULL,
0x00000090b3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000086bbff7212ULL, 0x040fe4000788c0ffULL,
0x0000008ebbff7212ULL, 0x000fe200078ac0ffULL, 0x00000001bf847824ULL, 0x100fe200078e0a80ULL,
0x00000052ab00720cULL, 0x080fe20001f61470ULL, 0x00000001c5887824ULL, 0x100fe200078e0a80ULL,
0x00000052ab00720cULL, 0x080fe20000f21470ULL, 0x00000001cb807824ULL, 0x000fe200078e0a80ULL,
0x00000052b100720cULL, 0x000fc400037c1470ULL, 0x00000052b100720cULL, 0x0c0fe40000701470ULL,
0x00000052b100720cULL, 0x080fe40001741470ULL, 0x00000052b700720cULL, 0x0c0fe40002781470ULL,
0x00000052b700720cULL, 0x000fe40002fa1470ULL, 0x00000084cdc17219ULL, 0x040fe400000006ffULL,
0x00000088cdc77219ULL, 0x000fc400000006ffULL, 0x00000052a900720cULL, 0x0c0fe40001f61070ULL,
0x00000052a900720cULL, 0x080fe40000f21070ULL, 0x00000052af00720cULL, 0x0c0fe400037c1070ULL,
0x00000052af00720cULL, 0x0c0fe40000701070ULL, 0x00000052af00720cULL, 0x080fe40001741070ULL,
0x00000052b500720cULL, 0x000fc40002781070ULL, 0x00000052b500720cULL, 0x000fe40002fa1070ULL,
0x00000080cdcd7219ULL, 0x000fe400000006ffULL, 0x00005410d18a7816ULL, 0x000fe4000000008aULL,
0xff80000037377808ULL, 0x000fe40001800000ULL, 0xff8000000a0a7808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fc40003000000ULL, 0xff80000039397808ULL, 0x000fe40000000000ULL,
0xff8000000b0b7808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x00000086c1ff7212ULL, 0x080fe4000786c0ffULL,
0x00000086c7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086cdff7212ULL, 0x000fe400078cc0ffULL,
0x0000008abbff7212ULL, 0x080fe4000780c0ffULL, 0x0000008ac1ff7212ULL, 0x080fe4000784c0ffULL,
0x0000008ac7ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ec1ff7212ULL, 0x000fe400078ac0ffULL,
0x00000052b700720cULL, 0x000fc40000701470ULL, 0x00000052bf00720cULL, 0x0c0fe40001f61470ULL,
0x00000052bf00720cULL, 0x0c0fe40001741470ULL, 0x00000052bf00720cULL, 0x080fe40002fa1470ULL,
0x00000052c500720cULL, 0x080fe40000f21470ULL, 0x00000052cb00720cULL, 0x080fe400037c1470ULL,
0x00000052c500720cULL, 0x000fc40002781470ULL, 0x00000052b500720cULL, 0x080fe40000701070ULL,
0x00000052bd00720cULL, 0x0c0fe40001f61070ULL, 0x00000052bd00720cULL, 0x0c0fe40001741070ULL,
0x00000052bd00720cULL, 0x080fe40002fa1070ULL, 0x00000052c300720cULL, 0x080fe40000f21070ULL,
0x00000052c900720cULL, 0x000fc400037c1070ULL, 0x00000052c300720cULL, 0x000fe40002781070ULL,
0x00005410d9927816ULL, 0x000fe40000000092ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0xff80000044447808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff8000003a3a7808ULL, 0x000fc40002800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000042427808ULL, 0x000fe40003000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002000000ULL,
0x0000008acdff7212ULL, 0x000fe4000780c0ffULL, 0x0000008ec7ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ecdff7212ULL, 0x000fc4000784c0ffULL, 0x00000092bbff7212ULL, 0x080fe400078ac0ffULL,
0x00000092c1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000092c7ff7212ULL, 0x080fe400078cc0ffULL,
0x00000092cdff7212ULL, 0x000fe4000788c0ffULL, 0x00000052b700720cULL, 0x080fe40002fa1470ULL,
0x00000052bf00720cULL, 0x000fc40000f21470ULL, 0x00000052c500720cULL, 0x0c0fe40001f61470ULL,
0x00000052c500720cULL, 0x080fe400037c1470ULL, 0x00000052cb00720cULL, 0x0c0fe40000701470ULL,
0x00000052cb00720cULL, 0x0c0fe40001741470ULL, 0x00000052cb00720cULL, 0x080fe40002781470ULL,
0x00000052b500720cULL, 0x000fc40002fa1070ULL, 0x00000052bd00720cULL, 0x080fe40000f21070ULL,
0x00000052c900720cULL, 0x080fe40000701070ULL, 0x00000052c300720cULL, 0x0c0fe40001f61070ULL,
0x00000052c300720cULL, 0x080fe400037c1070ULL, 0x00000052c900720cULL, 0x0c0fe40001741070ULL,
0x00000052c900720cULL, 0x000fc40002781070ULL, 0xff8000003d3d7808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001800000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000000c0c7808ULL, 0x000fe40002800000ULL, 0xff8000000d0d7808ULL, 0x000fe40000800000ULL,
0xff8000000e0e7808ULL, 0x000fc40003000000ULL, 0xff8000000f0f7808ULL, 0x000fc40002000000ULL,
0x0000004f0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff5a7424ULL, 0x000fe200078e00ffULL,
0x0000002a0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x0000002b0600720bULL, 0x000fe40003f5e000ULL, 0x0000001e0700720bULL, 0x000fe40003f7e000ULL,
0x000000044f537208ULL, 0x000fe40004000000ULL, 0x000000052a047208ULL, 0x000fc40004800000ULL,
0x000000062b057208ULL, 0x000fe40005000000ULL, 0x000000071e067208ULL, 0x000fe40005800000ULL,
0x0000004e5300720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x000000280500720bULL, 0x000fe40003f5e000ULL, 0x0000001d0600720bULL, 0x000fc40003f7e000ULL,
0x000000534e527208ULL, 0x000fe40004000000ULL, 0x0000000429047208ULL, 0x000fe40004800000ULL,
0x0000000528057208ULL, 0x000fe40005000000ULL, 0x000000061d077208ULL, 0x000fe40005800000ULL,
0x0000004d5200720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fc40003f3e000ULL,
0x000000260500720bULL, 0x000fe40003f5e000ULL, 0x0000001c0700720bULL, 0x000fe40003f7e000ULL,
0x000000524d537208ULL, 0x000fe40004000000ULL, 0x0000000427047208ULL, 0x000fe40004800000ULL,
0x0000000526057208ULL, 0x000fe40005000000ULL, 0x000000071c067208ULL, 0x000fc40005800000ULL,
0x0000004c5300720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x000000240500720bULL, 0x000fe40003f5e000ULL, 0x000000130600720bULL, 0x000fe40003f7e000ULL,
0x000000534c527208ULL, 0x000fe40004000000ULL, 0x0000000425047208ULL, 0x000fc40004800000ULL,
0x0000000524057208ULL, 0x000fe40005000000ULL, 0x0000000613067208ULL, 0x000fe40005800000ULL,
0x0000004b5200720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fe40003f3e000ULL,
0x000000220500720bULL, 0x000fe40003f5e000ULL, 0x000000210600720bULL, 0x000fc40003f7e000ULL,
0x000000524b077208ULL, 0x000fe40004000000ULL, 0x0000000423047208ULL, 0x000fe40004800000ULL,
0x0000000522057208ULL, 0x000fe40005000000ULL, 0x0000000621537208ULL, 0x000fe40005800000ULL,
0x0000004a0700720bULL, 0x000fe40003f1e000ULL, 0x000000410400720bULL, 0x000fc40003f3e000ULL,
0x000000320500720bULL, 0x000fe40003f5e000ULL, 0x000000205300720bULL, 0x000fe40003f7e000ULL,
0x000000074a067208ULL, 0x000fe40004000000ULL, 0x0000000441077208ULL, 0x000fe40004800000ULL,
0x0000000532047208ULL, 0x000fe40005000000ULL, 0x0000005320527208ULL, 0x000fc40005800000ULL,
0x000000490600720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x000000330400720bULL, 0x000fe40003f5e000ULL, 0x0000001f5200720bULL, 0x000fe40003f7e000ULL,
0x0000000649057208ULL, 0x000fe40004000000ULL, 0x000000072c077208ULL, 0x000fc40004800000ULL,
0x0000000433537208ULL, 0x000fe40005000000ULL, 0x000000521f557208ULL, 0x000fe40005800000ULL,
0x000000500500720bULL, 0x000fe40003f1e000ULL, 0x0000002e0700720bULL, 0x000fe40003f3e000ULL,
0x000000345300720bULL, 0x000fe40003f5e000ULL, 0x000000125500720bULL, 0x000fc40003f7e000ULL,
0x0000000550047208ULL, 0x000fe40004000000ULL, 0x000000072e067208ULL, 0x000fe40004800000ULL,
0x0000005334527208ULL, 0x000fe40005000000ULL, 0x0000005512547208ULL, 0x000fe40005800000ULL,
0x000000510400720bULL, 0x000fe40003f1e000ULL, 0x0000002d0600720bULL, 0x000fc40003f3e000ULL,
0x000000355200720bULL, 0x000fe40003f5e000ULL, 0x000000115400720bULL, 0x000fe40003f7e000ULL,
0x0000000451057208ULL, 0x000fe40004000000ULL, 0x000000062d077208ULL, 0x000fe40004800000ULL,
0x0000005235537208ULL, 0x000fe40005000000ULL, 0x0000005411557208ULL, 0x000fc40005800000ULL,
0x000000480500720bULL, 0x000fe40003f1e000ULL, 0x000000400700720bULL, 0x000fe40003f3e000ULL,
0x000000365300720bULL, 0x000fe40003f5e000ULL, 0x000000105500720bULL, 0x000fe40003f7e000ULL,
0x0000000548047208ULL, 0x000fe40004000000ULL, 0x0000000740067208ULL, 0x000fc40004800000ULL,
0x0000005336527208ULL, 0x000fe40005000000ULL, 0x0000005510557208ULL, 0x000fe40005800000ULL,
0x000000470400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0600720bULL, 0x000fe40003f3e000ULL,
0x000000375200720bULL, 0x000fe40003f5e000ULL, 0x0000000a5500720bULL, 0x000fc40003f7e000ULL,
0x0000000447057208ULL, 0x000fe40004000000ULL, 0x000000062f067208ULL, 0x000fe40004800000ULL,
0x0000005237077208ULL, 0x000fe40005000000ULL, 0x000000550a047208ULL, 0x000fe40005800000ULL,
0x000000460500720bULL, 0x000fe40003f1e000ULL, 0x000000390600720bULL, 0x000fc40003f3e000ULL,
0x000000380700720bULL, 0x000fe40003f5e000ULL, 0x0000000b0400720bULL, 0x000fe40003f7e000ULL,
0x0000000546527208ULL, 0x000fe40004000000ULL, 0x0000000639057208ULL, 0x000fe40004800000ULL,
0x0000000738067208ULL, 0x000fe40005000000ULL, 0x000000040b077208ULL, 0x000fc40005800000ULL,
0x000000300500720bULL, 0x000fe40003f3e000ULL, 0x0000003f0600720bULL, 0x000fe40003f5e000ULL,
0x000000455200720bULL, 0x000fe40003f1e000ULL, 0x0000000c0700720bULL, 0x000fe40003f7e000ULL,
0x0000000530047208ULL, 0x000fe40004800000ULL, 0x000000063f057208ULL, 0x000fc40005000000ULL,
0x0000005245537208ULL, 0x000fe40004000000ULL, 0x000000070c067208ULL, 0x000fe40005800000ULL,
0x000000310400720bULL, 0x000fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x000000445300720bULL, 0x000fe40003f1e000ULL, 0x0000000d0600720bULL, 0x000fc40003f7e000ULL,
0x0000000431077208ULL, 0x000fe40004800000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x0000005344527208ULL, 0x000fe40004000000ULL, 0x000000060d057208ULL, 0x000fe40005800000ULL,
0x0000003e0700720bULL, 0x000fe40003f3e000ULL, 0x0000003b0400720bULL, 0x000fc40003f5e000ULL,
0x000000435200720bULL, 0x000fe40003f1e000ULL, 0x0000000e0500720bULL, 0x000fe40003f7e000ULL,
0x000000073e067208ULL, 0x000fe40004800000ULL, 0x000000043b077208ULL, 0x000fe40005000000ULL,
0x0000005243537208ULL, 0x000fe40004000000ULL, 0x000000050e047208ULL, 0x000fc40005800000ULL,
0x000000425300720bULL, 0x000fe40003f1e000ULL, 0x0000003d0600720bULL, 0x000fe40003f3e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x0000000f0400720bULL, 0x000fe40003f7e000ULL,
0x0000005342057208ULL, 0x000fe40004000000ULL, 0x000000063d547208ULL, 0x000fc40004800000ULL,
0x000000073c587208ULL, 0x000fe40005000000ULL, 0x000000040f577208ULL, 0x000fe20005800000ULL,
0x00001e027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x0000000504597208ULL, 0x000fe20004000000ULL,
0x00001e227f007947ULL, 0x000fea000b800000ULL, 0x0c401f0054047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0058057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0057067f89ULL, 0x000f2200000e0000ULL,
0x000000045400720bULL, 0x008fc40003f1e000ULL, 0x000000055800720bULL, 0x004fe40003f3e000ULL,
0x0000005404077208ULL, 0x002fe40004000000ULL, 0x0000005805527208ULL, 0x000fe20004800000ULL,
0x0c201f0059047f89ULL, 0x000e6200000e0000ULL, 0x000000065700720bULL, 0x010fc60003f1e000ULL,
0x0c201f0007567f89ULL, 0x000ea200000e0000ULL, 0x0000005706547208ULL, 0x000fc60004000000ULL,
0x0c201f0052537f89ULL, 0x000ee800000e0000ULL, 0x0c201f0054557f89ULL, 0x0002e400000e0000ULL,
0x000000045900720bULL, 0x002fe40003f1e000ULL, 0x000000560700720bULL, 0x004fe40003f3e000ULL,
0x0000005904047208ULL, 0x000fc40004000000ULL, 0x000000535200720bULL, 0x008fe40003f5e000ULL,
0x0000000756057208ULL, 0x000fe40004800000ULL, 0x0000005253067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002ff687819ULL, 0x000fe20000011666ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b49527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL,
0x0000005000537308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b51497823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05507820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x00000008685d7824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3c3c7823ULL, 0x000fe20000010807ULL,
0x0000005455077208ULL, 0x000fe20004000000ULL, 0x00000031005c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL, 0x0000003200317308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010850ULL, 0x0000002300517308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b07327820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b3d3d7823ULL, 0x000fe20000010850ULL,
0x00000008686b7824ULL, 0x000fe200078e00ffULL, 0x0000000366ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010832ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL, 0x00000008686f7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010832ULL, 0x0000000868717824ULL, 0x040fe200078e00ffULL,
0x3fb8aa3b11117823ULL, 0x000fe20000010832ULL, 0x00000008685f7824ULL, 0x040fe200078e00ffULL,
0x0000004d004d7308ULL, 0x000ff00000000800ULL, 0x0000004c004c7308ULL, 0x000eb00000000800ULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000ef00000000800ULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002500567308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002400237308ULL, 0x0008700000000800ULL,
0x0000003800507308ULL, 0x000fe20000000800ULL, 0x0000000268247810ULL, 0x010fc80007ffe0ffULL,
0xfffffff85f5f7812ULL, 0x000fc600078ee224ULL, 0x0000003a005e7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000001e00387308ULL, 0x0009f00000000800ULL, 0x0000001d00557308ULL, 0x0003e20000000800ULL,
0x00000008681e7824ULL, 0x010fce00078e00ffULL, 0x0000001c003a7308ULL, 0x0009e20000000800ULL,
0x00000003681d7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff81e697812ULL, 0x000fe400078ee21dULL,
0x00000005681d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x00000004681c7810ULL, 0x050fe40007ffe0ffULL, 0x00000006681e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee21cULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee21eULL,
0x0000002e00577308ULL, 0x000fe20000000800ULL, 0x0000004f4e1c723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b0d4e7823ULL, 0x100fe20000010832ULL, 0x0000004d4c1e723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b0e4f7823ULL, 0x000fc80000010832ULL, 0x00000022002e7308ULL, 0x0005300000000800ULL,
0x0000003b00597308ULL, 0x000fe20000000800ULL, 0x0000000168227810ULL, 0x004fc80007ffe0ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee222ULL, 0x0000000868227824ULL, 0x000fe400078e00ffULL,
0x00000021003b7308ULL, 0x0005e60000000800ULL, 0xfffffff8226d7812ULL, 0x000fe400078ee21dULL,
0x0000002a291d723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b10297823ULL, 0x100fe20000010832ULL,
0x000000262322723eULL, 0x000fe200000000ffULL, 0x0000002000547308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b1f217823ULL, 0x004fe20000010832ULL, 0x00000027561f723eULL, 0x000fc400000000ffULL,
0x0000003a1323723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b0c3a7823ULL, 0x000fc60000010832ULL,
0x0000004100587308ULL, 0x000e620000000800ULL, 0xffffffff68207810ULL, 0x008fc80007ffe0ffULL,
0xfffffff871717812ULL, 0x000fe400078ee220ULL, 0x0000002b2820723eULL, 0x000fe200000000ffULL,
0x00000039005a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0a2b7823ULL, 0x000fe20000010832ULL,
0x0000002e3128723eULL, 0x010fcc00000000ffULL, 0x0000003000417308ULL, 0x000ea20000000800ULL,
0x00000051580d723eULL, 0x002fe200000000ffULL, 0x0000000868517824ULL, 0x000fca00078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee268ULL, 0x0000003400307308ULL, 0x0003f00000000800ULL,
0x0000003500397308ULL, 0x0007e20000000800ULL, 0x3c003c00ff347424ULL, 0x002fe200078e00ffULL,
0x000000415c31723eULL, 0x004fcc00000000ffULL, 0x00000021005b7308ULL, 0x0003e20000000800ULL,
0x3c003c00ff357424ULL, 0x008fce00078e00ffULL, 0x00000012004c7308ULL, 0x000fe20000000800ULL,
0x000000385521723eULL, 0x002fe200000000ffULL, 0x000000341c24723cULL, 0x000f6200000018ffULL,
0x3fb8aa3b0b387823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0f557823ULL, 0x000fc80000010832ULL,
0x00000011004d7308ULL, 0x0003f00000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000342010723cULL, 0x002f6e00000018ffULL, 0x0000004a004a7308ULL, 0x000e700000000800ULL,
0x0000005200527308ULL, 0x000eb00000000800ULL, 0x0000002c002c7308ULL, 0x000ee20000000800ULL,
0x0000004b4a0c723eULL, 0x002fce00000000ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x00000052530e723eULL, 0x004fe400000000ffULL, 0x0000000868537810ULL, 0x000fca0007ffe0ffULL,
0x00000029000a7308ULL, 0x0005e20000000800ULL, 0x0000002c570f723eULL, 0x008fe200000000ffULL,
0x00000008532c7824ULL, 0x000fe200078e00ffULL, 0x0000001068577810ULL, 0x040fe40007ffe0ffULL,
0x0000001868687810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c537812ULL, 0x000fe200078ee253ULL,
0x0000002b000b7308ULL, 0x0007e20000000800ULL, 0x00000033302a723eULL, 0x002fe200000000ffULL,
0x000000340c24723cULL, 0x020f620000001824ULL, 0x0000003b5429723eULL, 0x004fe200000000ffULL,
0x00000008572e7824ULL, 0x000fc800078e00ffULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x0000005b4c2b723eULL, 0x008fe200000000ffULL, 0x00000008685b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82e577812ULL, 0x000fc800078ee257ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee268ULL,
0x0000004800487308ULL, 0x000e620000000800ULL, 0x000000342810723cULL, 0x000f6e0000001810ULL,
0x0000004700477308ULL, 0x000ff00000000800ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x00000049482c723eULL, 0x002fce00000000ffULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x00000047462e723eULL, 0x004fce00000000ffULL,
0x0000002f002f7308ULL, 0x000eb00000000800ULL, 0x0000003600367308ULL, 0x000ee20000000800ULL,
0x0000002d402d723eULL, 0x002fce00000000ffULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x0000002f5a2f723eULL, 0x004fce00000000ffULL, 0x00000038004a7308ULL, 0x0006620000000800ULL,
0x000000342c24723cULL, 0x020f6e0000001824ULL, 0x0000003a004b7308ULL, 0x0005e20000000800ULL,
0x000000393638723eULL, 0x008fe400000000ffULL, 0x0000004d0a39723eULL, 0x000fc400000000ffULL,
0x0000a0001a367811ULL, 0x000fe400078e60ffULL, 0x0000000b4a3b723eULL, 0x002fe200000000ffULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x00000037503a723eULL, 0x004fe200000000ffULL,
0x0000001051517824ULL, 0x100fe400078e0236ULL, 0x000000105d5d7824ULL, 0x100fe400078e0236ULL,
0x000000105f5f7824ULL, 0x100fe400078e0236ULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x000000343810723cULL, 0x000fe20000001810ULL, 0x0000001069697824ULL, 0x000fc400078e0236ULL,
0x000000106b6b7824ULL, 0x100fe400078e0236ULL, 0x000000106d6d7824ULL, 0x100fe400078e0236ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x000000106f6f7824ULL, 0x100fe400078e0236ULL,
0x0000001071717824ULL, 0x100fe400078e0236ULL, 0x0000001053537824ULL, 0x100fe400078e0236ULL,
0x0000001057577824ULL, 0x100fe200078e0236ULL, 0x0000004400447308ULL, 0x000ea20000000800ULL,
0x0000003e3d33723eULL, 0x002fe200000000ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0236ULL,
0x0000000c093e7812ULL, 0x000fca00078ec0ffULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x0000000151517824ULL, 0x000fe400078e023eULL, 0x000000013e5d7824ULL, 0x040fe400078e025dULL,
0x000000013e5f7824ULL, 0x040fe200078e025fULL, 0x0000001c51007388ULL, 0x0003e20000000800ULL,
0x000000013e697824ULL, 0x000fe200078e0269ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x000000454430723eULL, 0x004fe200000000ffULL, 0x000000013e6b7824ULL, 0x040fe200078e026bULL,
0x0000001e5d007388ULL, 0x0003e20000000800ULL, 0x000000013e6d7824ULL, 0x000fc400078e026dULL,
0x000000013e6f7824ULL, 0x040fe200078e026fULL, 0x0000000c5f007388ULL, 0x0003e20000000800ULL,
0x0000003f003f7308ULL, 0x000ea20000000800ULL, 0x000000013e717824ULL, 0x040fe400078e0271ULL,
0x0000000e69007388ULL, 0x0003e20000000800ULL, 0x000000013e577824ULL, 0x000fc600078e0257ULL,
0x0000002c6b007388ULL, 0x0003e20000000800ULL, 0x0000003c003c7308ULL, 0x000f220000000800ULL,
0x000000434232723eULL, 0x008fe400000000ffULL, 0x0000002e6d007388ULL, 0x0003e80000000800ULL,
0x000000306f007388ULL, 0x0003e20000000800ULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x0000003f5e40723eULL, 0x004fe200000000ffULL, 0x000000343024723cULL, 0x020f620000001824ULL,
0x0000003271007388ULL, 0x0003ea0000000800ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x000000593c42723eULL, 0x010fce00000000ffULL, 0x00000055000a7308ULL, 0x000ea20000000800ULL,
0x0000004b4e41723eULL, 0x008fd200000000ffULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0000004f0a43723eULL, 0x004fe200000000ffULL, 0x000000013e0a7824ULL, 0x040fe400078e0253ULL,
0x000000013e3e7824ULL, 0x000fc600078e025bULL, 0x0000001d0a007388ULL, 0x0003e20000000800ULL,
0x000000344010723cULL, 0x000f660000001810ULL, 0x0004001f5d007388ULL, 0x0003e80000000800ULL,
0x0004000d5f007388ULL, 0x0003e80000000800ULL, 0x0004000f69007388ULL, 0x0003e80000000800ULL,
0x0004002d6b007388ULL, 0x0003e80000000800ULL, 0x0004002f6d007388ULL, 0x0003e80000000800ULL,
0x000400316f007388ULL, 0x0003e20000000800ULL, 0x000000ffff267224ULL, 0x020fc400078e0010ULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0004003371007388ULL, 0x0003e80000000800ULL,
0x0000002057007388ULL, 0x0003e80000000800ULL, 0x000800225d007388ULL, 0x0003e80000000800ULL,
0x000800285f007388ULL, 0x0003e80000000800ULL, 0x0008002a69007388ULL, 0x0003e80000000800ULL,
0x000800386b007388ULL, 0x0003e80000000800ULL, 0x0008003a6d007388ULL, 0x0003e80000000800ULL,
0x000800406f007388ULL, 0x0003e80000000800ULL, 0x0008004271007388ULL, 0x0003e80000000800ULL,
0x000000213e007388ULL, 0x0003e80000000800ULL, 0x000c00235d007388ULL, 0x0003e80000000800ULL,
0x000c00295f007388ULL, 0x0003e80000000800ULL, 0x000c002b69007388ULL, 0x0003e80000000800ULL,
0x000c00396b007388ULL, 0x0003e80000000800ULL, 0x000c003b6d007388ULL, 0x0003e80000000800ULL,
0x000c00416f007388ULL, 0x0003e80000000800ULL, 0x000c004371007388ULL, 0x0003e80000000800ULL,
0x0120000408008388ULL, 0x0003e80000000c00ULL, 0x0122002408008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000018ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080018ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100018ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000114147810ULL, 0x000fe20007ffe0ffULL,
0x0000180018ff7f8cULL, 0x0003e6000c80043fULL, 0x000000151400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff967000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x00016ae000267802ULL, 0x000fc40000000f00ULL, 0x00000e9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffebf9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x00016b3000267802ULL, 0x000fc40000000f00ULL,
0x00000e4000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0025ULL,
0xfffebff000007947ULL, 0x000fea000383ffffULL, 0x00016b7000257802ULL, 0x000fc40000000f00ULL,
0x00000db000007944ULL, 0x002fea0003c00000ULL, 0xfffec0d000007947ULL, 0x000fea000383ffffULL,
0x00016ba000257802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x002fea0003c00000ULL,
0xfffec21000007947ULL, 0x000fea000383ffffULL, 0x00016bd000257802ULL, 0x000fc40000000f00ULL,
0x00000d5000007944ULL, 0x002fea0003c00000ULL, 0xfffec35000007947ULL, 0x000fea000383ffffULL,
0x00016c0000257802ULL, 0x000fc40000000f00ULL, 0x00000d2000007944ULL, 0x002fea0003c00000ULL,
0xfffec48000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00016c4000257802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffec8b000007947ULL, 0x000fea000383ffffULL,
0x00016c8000257802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001002267810ULL, 0x000fe40007ffe0ffULL,
0x00016cc000257802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffec88000007947ULL, 0x000fea000383ffffULL,
0x00016d0000257802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffec87000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00016d5000267802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffee98000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x00016da000267802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffee9d000007947ULL, 0x000fea000383ffffULL,
0x00016de000257802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x004fea0003c00000ULL,
0xfffeeab000007947ULL, 0x000fea000383ffffULL, 0x00016e1000257802ULL, 0x000fc40000000f00ULL,
0x00000b1000007944ULL, 0x006fea0003c00000ULL, 0xfffeebf000007947ULL, 0x000fea000383ffffULL,
0x00016e4000257802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x00efea0003c00000ULL,
0xfffeed3000007947ULL, 0x000fea000383ffffULL, 0x00016e7000257802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x00efea0003c00000ULL, 0xfffeee6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001eULL, 0x00016eb000257802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffef28000007947ULL, 0x000fea000383ffffULL, 0x00016ef000257802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000101e267810ULL, 0x000fc40007ffe0ffULL, 0x00016f3000257802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffef25000007947ULL, 0x000fea000383ffffULL, 0x00016f7000257802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffef24000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x00016fc000267802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0025ULL, 0xffff12c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001701000267802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff237224ULL, 0x000fe200078e0025ULL,
0xffff131000007947ULL, 0x000fea000383ffffULL, 0x0001705000257802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x002fea0003c00000ULL, 0xffff13f000007947ULL, 0x000fea000383ffffULL,
0x0001708000257802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x002fea0003c00000ULL,
0xffff153000007947ULL, 0x000fea000383ffffULL, 0x000170b000257802ULL, 0x000fc40000000f00ULL,
0x0000087000007944ULL, 0x002fea0003c00000ULL, 0xffff167000007947ULL, 0x000fea000383ffffULL,
0x000170e000257802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xffff17a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0024ULL,
0x0001712000257802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff1bc000007947ULL, 0x000fea000383ffffULL,
0x0001716000257802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001024267810ULL, 0x000fc40007ffe0ffULL,
0x000171a000257802ULL, 0x000fc40000000f00ULL, 0x0000078000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff1b9000007947ULL, 0x000fea000383ffffULL,
0x000171e000257802ULL, 0x000fc40000000f00ULL, 0x0000074000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff1b8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001723000267802ULL, 0x000fc40000000f00ULL,
0x0000074000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0025ULL,
0xffff3ab000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001728000267802ULL, 0x000fc40000000f00ULL, 0x000006f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0xffff3b0000007947ULL, 0x000fea000383ffffULL,
0x000172c000257802ULL, 0x000fc40000000f00ULL, 0x0000066000007944ULL, 0x000fea0003c00000ULL,
0xffff3be000007947ULL, 0x000fea000383ffffULL, 0x000172f000257802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x002fea0003c00000ULL, 0xffff3d2000007947ULL, 0x000fea000383ffffULL,
0x0001732000257802ULL, 0x000fc40000000f00ULL, 0x0000060000007944ULL, 0x002fea0003c00000ULL,
0xffff3e6000007947ULL, 0x000fea000383ffffULL, 0x0001735000257802ULL, 0x000fc40000000f00ULL,
0x000005d000007944ULL, 0x002fea0003c00000ULL, 0xffff3f9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000aULL, 0x0001739000257802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff43a000007947ULL, 0x000fea000383ffffULL, 0x000173d000257802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000100a267810ULL, 0x000fc40007ffe0ffULL, 0x0001741000257802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff437000007947ULL, 0x000fea000383ffffULL, 0x0001745000257802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff436000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x000174b000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0055ULL,
0xffffe1b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001751000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x004fea0003c00000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x0001757000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005455067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x000175d000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855587208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000555700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0059ULL, 0x0001763000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005755547208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000555900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x0001769000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005955047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000550600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x000176f000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000000655057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001775000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe08000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe872002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c00005607557389ULL, 0x0002a200000e005aULL, 0xfffe86e052007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0025ULL, 0x0000007500007348ULL, 0x000fe80003800000ULL,
0x00000000ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000002627267389ULL, 0x0002a600000e0076ULL,
0xfffe86906a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000007400007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000007425257212ULL, 0x000fe200078ec0ffULL,
0xfffe863026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c70ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d30ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017a80ULL, 0xdc00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019300ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019340ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000196c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017c80ULL,
0x0000000000017c80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000196c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_89_cubin_len = 104352;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
