/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b440ULL, 0x000000000001b0c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x00000000000194b0ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000019630ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000019670ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x00000000000196c0ULL, 0x0000000000000140ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000019800ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000194b000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x0063980400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x000194b000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880809d082880ULL, 0x80809f082880809eULL, 0xa308288080a10828ULL,
0x288080a508288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080d208288080f2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080d292ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x0001963000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880809d082880ULL, 0x80809f082880809eULL, 0xa308288080a10828ULL,
0x288080a608288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080a508288080f2ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x0001967000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL,
0x80809f082880809eULL, 0xa308288080a10828ULL, 0x288080a508288080ULL, 0x80ec08288080ea08ULL,
0x08288080f0082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x000196c000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000dcULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000016ULL, 0x000c170400601903ULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000eb000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00000310019c2804ULL, 0x000005b000000370ULL, 0x00002b0000002a70ULL,
0x00002d8000002c10ULL, 0x0000305000002ef0ULL, 0x00003510000034d0ULL, 0x0000355000003520ULL,
0x00005750000056b0ULL, 0x000059d000005860ULL, 0x00005ca000005b40ULL, 0x0000615000006110ULL,
0x0000619000006160ULL, 0x0000830000008260ULL, 0x0000858000008410ULL, 0x00008850000086f0ULL,
0x00008d0000008cc0ULL, 0x00008d4000008d10ULL, 0x0000ad600000acc0ULL, 0x0000afe00000ae70ULL,
0x0000b2b00000b150ULL, 0x0000b7500000b710ULL, 0x0000b7900000b760ULL, 0x0000cca00000cc90ULL,
0x0000ccc00000ccb0ULL, 0x00016e8000016e40ULL, 0x00016ea000016e90ULL, 0x00016f1000016ef0ULL,
0x00016f4000016f30ULL, 0x00018320000182c0ULL, 0x000183d000018380ULL, 0x0001847000018420ULL,
0x00018530000184d0ULL, 0x000185f000018590ULL, 0x000186b000018650ULL, 0x0001876000018710ULL,
0x00018800000187b0ULL, 0x000188c000018860ULL, 0x0001898000018920ULL, 0x00018a40000189e0ULL,
0x00018af000018aa0ULL, 0x00018b9000018b40ULL, 0x00018c5000018bf0ULL, 0x00018d1000018cb0ULL,
0x00018dd000018d70ULL, 0x00018e8000018e30ULL, 0x00018f2000018ed0ULL, 0x00018fe000018f80ULL,
0x000190a000019040ULL, 0x0001919000019110ULL, 0x0001929000019210ULL, 0x0001939000019310ULL,
0x0001949000019410ULL, 0x0000041004403904ULL, 0x0001a600000000ffULL, 0x00000440003f0100ULL,
0x0001a6080000000dULL, 0x000004d0003f0120ULL, 0x0001a6880000000dULL, 0x00000520003f0120ULL,
0x0001a6a80000000dULL, 0x00000530003f0120ULL, 0x0001a6c80000000dULL, 0x00000ec0003f0120ULL,
0x0001a600000000ffULL, 0x00001020003f0107ULL, 0x0001a68c00000014ULL, 0x000010b0003f0102ULL,
0x0001a68800000014ULL, 0x000019e0003f0101ULL, 0x00000000000000ffULL, 0x00001a6000040107ULL,
0x00000000000000ffULL, 0x00001ac000040101ULL, 0x0000002000000002ULL, 0x00001c30003f0101ULL,
0x0001a6cc0000000cULL, 0x00001e00003f0105ULL, 0x0001a6cc0000000cULL, 0x00002620003f0105ULL,
0x0001a6b00000001fULL, 0x000026e0003f0107ULL, 0x0001a6b00000001fULL, 0x00002740003f0101ULL,
0x0001a6080000001cULL, 0x00002780003f0101ULL, 0x0001a60c00000023ULL, 0x00002960003f0105ULL,
0x0001a60c00000023ULL, 0x00003200003f0105ULL, 0x0001a6ac0000001fULL, 0x000033f0003f0105ULL,
0x0001a6ac0000001fULL, 0x000048d0003f0105ULL, 0x0000000000000068ULL, 0x00004930003f0101ULL,
0x0001a6880000001fULL, 0x00004960003f0101ULL, 0x000000040000000dULL, 0x00004b20003f0105ULL,
0x000000040000000dULL, 0x00005270003f0105ULL, 0x0000000000000008ULL, 0x00005350003f0107ULL,
0x0000000000000008ULL, 0x000053b0003f0101ULL, 0x0001a62800000023ULL, 0x00005410003f0101ULL,
0x0001a62c0000006aULL, 0x000055e0003f0105ULL, 0x0001a62c0000006aULL, 0x00005e70003f0105ULL,
0x0001a6b40000006aULL, 0x00006040003f0105ULL, 0x0001a6b40000006aULL, 0x000074a0003f0105ULL,
0x000000000000006aULL, 0x00007500003f0101ULL, 0x0001a69000000026ULL, 0x00007530003f0101ULL,
0x000000040000000dULL, 0x000076f0003f0105ULL, 0x000000040000000dULL, 0x00007e70003f0105ULL,
0x00000008000000ffULL, 0x00007f0000040107ULL, 0x0001a6b000000068ULL, 0x00007f60003f0101ULL,
0x0001a64800000023ULL, 0x00007fc0003f0101ULL, 0x0001a64c00000023ULL, 0x00008190003f0105ULL,
0x0001a64c00000023ULL, 0x00008a20003f0105ULL, 0x0000000400000008ULL, 0x00008bf0003f0105ULL,
0x0000000400000008ULL, 0x00009f20003f0105ULL, 0x0000000000000026ULL, 0x00009f80003f0101ULL,
0x0001a69800000020ULL, 0x00009fb0003f0101ULL, 0x000000040000000dULL, 0x0000a170003f0105ULL,
0x000000040000000dULL, 0x0000a910003f0105ULL, 0x00000000000000ffULL, 0x0000a9c000040107ULL,
0x0000000000000008ULL, 0x0000aa20003f0101ULL, 0x0001a6680000000cULL, 0x0000aa40003f0101ULL,
0x0001a66c0000000cULL, 0x0000ac10003f0105ULL, 0x0001a66c0000000cULL, 0x0000b470003f0105ULL,
0x0001a6b400000026ULL, 0x0000b640003f0105ULL, 0x0001a6b400000026ULL, 0x0000c9e0003f0105ULL,
0x000000000000000dULL, 0x0000ca60003f0101ULL, 0x000000000000000aULL, 0x0000ec80003f0101ULL,
0x0001a600000000ffULL, 0x000104c0003f0101ULL, 0x0001a604000000ffULL, 0x000106d0003f0105ULL,
0x0001a604000000ffULL, 0x00010a50003f0105ULL, 0x0001a600000000ffULL, 0x00010a80003f0101ULL,
0x0001a604000000ffULL, 0x00010c40003f0105ULL, 0x0001a604000000ffULL, 0x00014090003f0105ULL,
0x0000000000000062ULL, 0x000141c0003f0101ULL, 0x0000000400000062ULL, 0x00014390003f0105ULL,
0x0000000400000062ULL, 0x00018100003f0105ULL, 0x000000000000005eULL, 0x00018160003f0101ULL,
0x000000080000005eULL, 0x000181c0003f0101ULL, 0x000000100000005eULL, 0x00018230003f0101ULL,
0x000000180000005eULL, 0x00053803003f0101ULL, 0x0000dbb000301c04ULL, 0x0000de700000dbe0ULL,
0x0000e2500000e060ULL, 0x0000e6300000e440ULL, 0x0000ea200000e820ULL, 0x00010ca00000ebd0ULL,
0x0000040100018280ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL,
0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000308ULL, 0x0000001900000002ULL, 0x0000000000000238ULL, 0x0000001900000002ULL,
0x0000000000000178ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff050424ULL, 0x000fe200078e00ffULL,
0x000000010e020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0005ULL,
0x00005c000e040625ULL, 0x000fe200078e0005ULL, 0x00000006025d0981ULL, 0x0002a8000c1e1900ULL,
0x0000000604000981ULL, 0x0006a2000c1e1900ULL, 0x0000590000087b06ULL, 0x000f220000209000ULL,
0x00005900ff117624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000000b7919ULL, 0x000e620000002300ULL, 0x00005a00ff0f7624ULL, 0x000fc600078e00ffULL,
0x00000000001a7919ULL, 0x000e620000002100ULL, 0x000059000f0f7a24ULL, 0x000fe200078e02ffULL,
0x0000000800087308ULL, 0x010f240000001000ULL, 0x0ffffffe08067810ULL, 0x010fe40007ffe0ffULL,
0x0000000000087919ULL, 0x000f280000002200ULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fc400078e00ffULL, 0x000000ffff097224ULL, 0x008fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002600ULL, 0x0000040007077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a07ULL, 0x0000040002027624ULL, 0x000fca00078e0211ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x0000000107072810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07ba12ULL, 0x000fc800078e33ffULL,
0x0000000700047306ULL, 0x000ee20000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027810ULL, 0x008fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000664000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x0000000307057224ULL, 0x002fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a05ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000006031b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a1bULL, 0x0000000307027224ULL, 0x000fe400078e0206ULL,
0x000001000b037a24ULL, 0x010fe400078e0208ULL, 0x00001fff0b0b7589ULL, 0x000fe200000e0000ULL,
0x000000070200720cULL, 0x000fe20003fa6070ULL, 0x00000000030d7a24ULL, 0x100fe200078e021aULL,
0x00000005ff1a7819ULL, 0x000fc8000001161aULL, 0x000000ff0d00720cULL, 0x040fe40003f65270ULL,
0x0000000f0d00780cULL, 0x040fe20003f24070ULL, 0x00001fff1a1a7589ULL, 0x000e6200000e0000ULL,
0x0000007f0d00780cULL, 0x000fc60003f44070ULL, 0x0000000102025824ULL, 0x000fe200078e0a07ULL,
0x000000011b1b5810ULL, 0x000fe40007ffe0ffULL, 0x000000030d00780cULL, 0x000fe40003fa4070ULL,
0x000000070200720cULL, 0x000fe20003fc6070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff049424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x01a60002ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010d00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0aa424ULL, 0x000fe400078e00ffULL,
0x01a608040d009388ULL, 0x000fe20000008a00ULL, 0x000000011b1b6810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff1bc212ULL, 0x000fe200078e33ffULL, 0x01a4000a0d00a388ULL, 0x000fe20000004800ULL,
0x3fffff60ff02d424ULL, 0x008fc600078e00ffULL, 0x000000ffff197224ULL, 0x000fe400078e0a1bULL,
0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL, 0x0000001907197224ULL, 0x000fe400078e0206ULL,
0x3fffff80ff06d424ULL, 0x000fe200078e00ffULL, 0x01a688020d00d388ULL, 0x0003e20000008a00ULL,
0x0000002019197824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff07d424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08b424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL,
0x01a6a8060d00d388ULL, 0x000fe80000008a00ULL, 0x01a6c8080d00b388ULL, 0x000fe20000008a00ULL,
0x000000040b027824ULL, 0x002fe400078e021aULL, 0x000000015d5d0824ULL, 0x004fc400078e0a00ULL,
0x00005800ff5d8624ULL, 0x000fe400078e00ffULL, 0x000058000e008a24ULL, 0x000fe400078e02ffULL,
0x00005a005d047a24ULL, 0x000fe400078e02ffULL, 0x0000000f006e7224ULL, 0x000fe400078e02ffULL,
0x0000000104057824ULL, 0x040fe200078e0a19ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000190400720cULL, 0x000fe20003f26070ULL, 0x0000000402047824ULL, 0x000fe200078e00ffULL,
0x0000002005057817ULL, 0x000fe20003800000ULL, 0x00005a001b157a24ULL, 0x000fc600078e026eULL,
0x000000ff05187207ULL, 0x000fc80000800000ULL, 0x000000201800780cULL, 0x000fda0003f05270ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fcc00078e00ffULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc80000011617ULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x0000000104087824ULL, 0x000fe200078e0205ULL,
0x0ffffffe06037810ULL, 0x002fc60007ffe0ffULL, 0x00000001040a7824ULL, 0x000fc600078e0209ULL,
0x0000000300037305ULL, 0x000e62000021f000ULL, 0x00000001190c7824ULL, 0x000fe400078e020aULL,
0x000000ffff077224ULL, 0x002fc800078e0a03ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x0000000703077227ULL, 0x000fc800078e0002ULL, 0x0000000119027824ULL, 0x000fe400078e0208ULL,
0x0000000c070d7227ULL, 0x000fc800078e00ffULL, 0x0000000207037227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x000000ffff137224ULL, 0x000fe400078e0a0dULL,
0x00005a0007067a24ULL, 0x000fe400078e0202ULL, 0x00005a0013077a24ULL, 0x000fc600078e020cULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0007007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0007072a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0007007a0cULL, 0x000fe40003f66070ULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d3810ULL, 0x000fe40007ffe0ffULL,
0x0000000306077207ULL, 0x040fe40004000000ULL, 0x0000000d06067207ULL, 0x000fe40004000000ULL,
0x0000000418037217ULL, 0x000fe20007800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x000000ffff137224ULL, 0x000fc400078e0a06ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00005a00130c7a24ULL, 0x000fe400078e020cULL, 0x0000000115027824ULL, 0x040fe400078e0202ULL,
0x00000001150d7824ULL, 0x000fe400078e020cULL, 0x0000000103037824ULL, 0x000fe400078e0a04ULL,
0x0000000f07047224ULL, 0x000fc400078e0202ULL, 0x0000001017027824ULL, 0x000fe200078e00ffULL,
0x000000030500720cULL, 0x000fe20003f06070ULL, 0x0000000f06067224ULL, 0x000fe200078e020dULL,
0x000000030900720cULL, 0x000fe20003f26070ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f002037812ULL, 0x000fc600078ec0ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000304047212ULL, 0x000fc600078efcffULL, 0x0000000108097824ULL, 0x100fe200078e0217ULL,
0x0000000306037212ULL, 0x000fe200078efcffULL, 0x00000010080c7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010a087824ULL, 0x040fe200078e0217ULL,
0x0000600003067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c097812ULL, 0x000fe400078ee209ULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00d087812ULL, 0x000fe200078ee208ULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x0000001008037824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c46ULL,
0x0000000006037faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000057b06ULL, 0x000e620000209000ULL, 0x0000000000177919ULL, 0x000ea20000000000ULL,
0x000000ffff027224ULL, 0x000fcc00078e00ffULL, 0x0000000500057308ULL, 0x002e620000001000ULL,
0x0000000417087211ULL, 0x004fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffffe05067810ULL, 0x002fc60007ffe0ffULL, 0x0000000119057824ULL, 0x000fe200078e020aULL,
0x0000000600037305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000703077227ULL, 0x000fc800078e0002ULL,
0x0000000119027824ULL, 0x000fe400078e0208ULL, 0x0000000507067227ULL, 0x000fc800078e00ffULL,
0x0000000207037227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a06ULL, 0x00005a0007047a24ULL, 0x000fe400078e0202ULL,
0x00005a000c077a24ULL, 0x000fe400078e0205ULL, 0x00000010080c7824ULL, 0x000fe200078e00ffULL,
0x00005a0004007a0cULL, 0x000fe40003f06070ULL, 0x00005a0007007a0cULL, 0x000fd60003f46070ULL,
0x80005a0004040a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0007072a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0x00005a0007007a0cULL, 0x000fe40003f66070ULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x0000000106062810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff047a12ULL, 0x000fc600078e33ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x0000000106063810ULL, 0x000fe40007ffe0ffULL,
0x0000000304037207ULL, 0x040fe40004000000ULL, 0x0000000604067207ULL, 0x000fc60004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x000000ffff047224ULL, 0x000fe400078e0a06ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x00005a0004057a24ULL, 0x000fe400078e0205ULL,
0x0000000115047824ULL, 0x040fe400078e0202ULL, 0x0000000115057824ULL, 0x000fc400078e0205ULL,
0x0000001017027824ULL, 0x000fe400078e00ffULL, 0x0000000f03047224ULL, 0x080fe400078e0204ULL,
0x0000000f06067224ULL, 0x000fe200078e0205ULL, 0x000000f002097812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000108037824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00c037812ULL, 0x000fe400078ee203ULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x0000001008097824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000b901c46ULL, 0x0000000006097faeULL, 0x0003e4000b901c46ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000000000067806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600037300ULL, 0x000e7000000e0000ULL,
0x0000000600057309ULL, 0x000ea20000000000ULL, 0x000000040300720cULL, 0x002fe20003f02070ULL,
0x00000004ff037424ULL, 0x000fc400078e00ffULL, 0x000000ffff077224ULL, 0x004fe400078e0a05ULL,
0x000066000e047625ULL, 0x000fd000078e0003ULL, 0x01a60407ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604167981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x000000ff16067810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff157819ULL, 0x000fce0000011606ULL,
0x0000dbf000008947ULL, 0x000fea0003800000ULL, 0x000000081a147824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a68c0314ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x000000020e007824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe2000001161aULL, 0x01a6880014ff7f8cULL, 0x0007e4000c80043fULL,
0x0000590000007624ULL, 0x000fe200078e0211ULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x00000020136f7824ULL, 0x000fc400078e00ffULL, 0x000000011b127824ULL, 0x000fc800078e0200ULL,
0x0000680012007a24ULL, 0x000fe200078e026fULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000006f16047217ULL, 0x008fe20007800000ULL, 0x0000001011037824ULL, 0x004fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc60000011617ULL, 0x0000000104047824ULL, 0x000fe200078e0a6fULL,
0x0000000405087810ULL, 0x000fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fe200078e0205ULL,
0x0000000c05097810ULL, 0x000fe40007ffe0ffULL, 0x0000000304047217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x042fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fc400078e0a03ULL, 0x00000001030a7824ULL, 0x000fe200078e0209ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000805077810ULL, 0x040fe20007ffe0ffULL,
0x00000001000d7824ULL, 0x040fe200078e020aULL, 0x000000040500720cULL, 0x080fe20003f66070ULL,
0x0000000100057824ULL, 0x000fe200078e0206ULL, 0x000000040800720cULL, 0x080fe20003f46070ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x000000040700720cULL, 0x080fe20003f26070ULL,
0x0000000103077824ULL, 0x000fe200078e0207ULL, 0x000000040900720cULL, 0x000fe20003f06070ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef802ULL, 0x0000000108037824ULL, 0x040fe400078e0217ULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x040fe200078e0217ULL, 0xfffffff80e007812ULL, 0x000fe200078ee203ULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0x0001600013037811ULL, 0x000fe200078e68ffULL,
0x000000010a047824ULL, 0x000fc400078e0217ULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010000f7824ULL, 0x000fe200078e0203ULL,
0xfffffff8100e7812ULL, 0x000fe400078ee209ULL, 0xfffffff807107812ULL, 0x000fe400078ee204ULL,
0x00006500050b7a10ULL, 0x000fe200027fe4ffULL, 0x0000008006047825ULL, 0x000fc800078e00ffULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x0000007004007812ULL, 0x000fc600078ef802ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x000fc600078ef802ULL,
0x000000100c0d7824ULL, 0x100fe200078e0203ULL, 0x0000007008067812ULL, 0x000fe200078ef802ULL,
0x000000100e1d7824ULL, 0x100fe200078e0203ULL, 0x0000640000027a10ULL, 0x000fe20007f9e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e0203ULL, 0x0000640004047a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000d901c46ULL,
0x0000640006067a10ULL, 0x000fe40007fde0ffULL, 0x0000650005037a10ULL, 0x000fe400027fe4ffULL,
0x0000650007057a10ULL, 0x000fc40002ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200037fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000d101c46ULL, 0x00000000041d7faeULL, 0x0003e8000c901c46ULL,
0x00000000061f7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011047824ULL, 0x008fe200078e00ffULL, 0x00016000131f7811ULL, 0x000fc800078e68ffULL,
0x0000000417037211ULL, 0x004fc800078fe8ffULL, 0x0000000403067810ULL, 0x040fe20007ffe0ffULL,
0x0000000103057824ULL, 0x040fe200078e0217ULL, 0x0000000c030a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x0000000803087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe400078e0203ULL, 0x0000000100037824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000106077824ULL, 0x102fe200078e0217ULL, 0x00000070040b7812ULL, 0x000fe200078ef802ULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x00000001000d7824ULL, 0x000fe400078e020aULL,
0x000000010a047824ULL, 0x040fe400078e0217ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0xfffffff80e007812ULL, 0x000fe200078ee207ULL, 0x0000000108097824ULL, 0x040fe200078e0217ULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00006500050b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008003047825ULL, 0x000fc600078e00ffULL,
0xfffffff8080e7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007004037812ULL, 0x000fc600078ef802ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fc600078ef802ULL, 0x000000100c0d7824ULL, 0x100fe200078e021fULL,
0x0000007008067812ULL, 0x000fe200078ef802ULL, 0x00000010000f7824ULL, 0x100fe200078e021fULL,
0x0000640003027a10ULL, 0x000fe20007f1e0ffULL, 0x000000100e1d7824ULL, 0x100fe200078e021fULL,
0x0000640004047a10ULL, 0x000fe20007f3e0ffULL, 0x00000010101f7824ULL, 0x000fe200078e021fULL,
0x0000640006067a10ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x0000650005037a10ULL, 0x000fe400007fe4ffULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200017fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000b901c46ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e4000b901c46ULL, 0x00000000130473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x0001a6a813027811ULL, 0x002fe200078e18ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff6c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000af3000008947ULL, 0x000fea0003800000ULL, 0x00000010130e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x000fe2000001161aULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x000000100e0e7812ULL, 0x000fe200078ee2ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1c7224ULL, 0x00afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x000000041a0a7824ULL, 0x000fca00078e00ffULL, 0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL,
0x0001a6c80c0d7810ULL, 0x000fe20007ffe0ffULL, 0x01a6cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000001d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a6cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f007810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0c7824ULL, 0x000fc600078e026fULL,
0x000000150000720cULL, 0x000fe40003f46070ULL, 0x000000400c037810ULL, 0x000fca0007ffe0ffULL,
0x00006800121f7a24ULL, 0x000fcc00078e0203ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x000fe20000011617ULL, 0x00000010110b7824ULL, 0x000fe200078e00ffULL,
0x0000000316007217ULL, 0x000fe40007800000ULL, 0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e020aULL, 0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x00000001021c7824ULL, 0x040fe400078e0217ULL,
0x0000000802237824ULL, 0x000fe200078e00ffULL, 0x000000000b007217ULL, 0x000fe20007800000ULL,
0x0000001017037824ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e021fULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b207824ULL, 0x000fe200078e021dULL,
0x0000007003217812ULL, 0x000fe200078ec0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x080fe40003fa6070ULL, 0x000000001c00720cULL, 0x080fe20003f86070ULL,
0x000000010b1e7824ULL, 0x040fe200078e021cULL, 0x00000021021c7212ULL, 0x000fe200078efcffULL,
0x000000010b267824ULL, 0x000fe200078e0224ULL, 0x000000001d00720cULL, 0x080fe20003f66070ULL,
0x000000011e0a7824ULL, 0x000fe200078e021fULL, 0x000000002400720cULL, 0x000fe20003f06070ULL,
0x000000011e007824ULL, 0x000fe200078e0217ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x00006500031d7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0x000000210a1e7212ULL, 0x080fe200078efcffULL,
0x0000000120027824ULL, 0x100fe400078e021fULL, 0x00000001260a7824ULL, 0x000fe200078e021fULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe400078ee200ULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002102027212ULL, 0x000fc400078efcffULL,
0x0001700013007811ULL, 0x000fe200078e68ffULL, 0x0000000120247824ULL, 0x100fe200078e0217ULL,
0x0000640002027a10ULL, 0x000fe20007fde0ffULL, 0x0000000820277824ULL, 0x000fe200078e00ffULL,
0x000000210a0a7212ULL, 0x000fe200078efcffULL, 0x0000000126207824ULL, 0x040fe200078e0217ULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000000826697824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee224ULL, 0x0000001023217824ULL, 0x100fe200078e0200ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001025237824ULL, 0x000fe200078e0200ULL,
0xfffffff869697812ULL, 0x000fe200078ee220ULL, 0x0000001027257824ULL, 0x100fe200078e0200ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0005e4000e901c46ULL, 0x0000001069277824ULL, 0x000fc400078e0200ULL,
0x000000001e237faeULL, 0x0005e8000e101c46ULL, 0x0000000002257faeULL, 0x0005e8000d901c46ULL,
0x000000000a277faeULL, 0x0005e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000001017027824ULL, 0x000fc600078e00ffULL,
0x0000000017007211ULL, 0x000fe400078fe8ffULL, 0x0000007002257812ULL, 0x000fe400078ec0ffULL,
0x0000000c00247810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e0217ULL,
0x0000000800207810ULL, 0x040fe20007ffe0ffULL, 0x00000008000a7824ULL, 0x040fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e021fULL, 0x0000000824697824ULL, 0x000fe200078e00ffULL,
0xfffffff80a217812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x00000004000a7810ULL, 0x000fc60007ffe0ffULL, 0x00000001201d7824ULL, 0x000fe200078e0217ULL,
0x00000025021e7212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x040fe400078e021fULL,
0x000000010a0b7824ULL, 0x100fe200078e0217ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000080a267824ULL, 0x000fe400078e00ffULL, 0x0000000124027824ULL, 0x000fe400078e0217ULL,
0x00000001200a7824ULL, 0x000fe200078e021fULL, 0xfffffff826237812ULL, 0x000fe200078ee20bULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee202ULL,
0x00000001241c7824ULL, 0x000fe200078e021fULL, 0x00006500031f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008000027825ULL, 0x000fe200078e00ffULL, 0xfffffff820277812ULL, 0x000fc400078ee21dULL,
0x0001700013207811ULL, 0x000fe200078e68ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002502027212ULL, 0x000fc600078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000250a0a7212ULL, 0x080fe400078efcffULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x000000251c1c7212ULL, 0x000fe200078efcffULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001027257824ULL, 0x100fe200078e0220ULL, 0x000064001c1c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001069277824ULL, 0x000fe200078e0220ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e217faeULL, 0x0005e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc40001ffe4ffULL, 0x000065001d1d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000002237faeULL, 0x0005e8000b901c46ULL, 0x000000000a257faeULL, 0x0005e8000b901c46ULL,
0x000000001c277faeULL, 0x0005e4000b901c46ULL, 0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL,
0xffffffe014007812ULL, 0x000fc400078ec0ffULL, 0x000000001f0573c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001014037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fc800078e0203ULL, 0x00000008111c7824ULL, 0x000fe200078e0200ULL,
0x0001a6b005057890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b0001f207f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a608001c1c7f8cULL, 0x000ea4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x00000008140b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100237824ULL, 0x000fca00078e020bULL,
0x01a60c00230b7984ULL, 0x000f240000000800ULL, 0x800000000bff7812ULL, 0x014fe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a02257210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a60c00230b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011617ULL,
0x000000201a007824ULL, 0x000fc600078e00ffULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a007210ULL, 0x000fca0007ffe00bULL, 0x01a0000000037984ULL, 0x000ea80000000800ULL,
0x01a2000000027984ULL, 0x0006620000000800ULL, 0x000000080300720bULL, 0x004fe20003f1d000ULL,
0x000158227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800000e0100ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fd200078e0008ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001a1000720cULL, 0x000fe40003f05270ULL,
0x000000080300720bULL, 0x000fe20003f74000ULL, 0x000157f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x00000008031e7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x01a4001e25008388ULL, 0x0005e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000081e087221ULL, 0x004fe20000010100ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000157427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000156227f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000155027f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000153f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000001d00ff7212ULL, 0x000fda00078030ffULL,
0x8000001e03030221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300090308ULL, 0x000ea40000000800ULL,
0x0000000902020220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002202227221ULL, 0x002fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x01a6ac001f007984ULL, 0x000e620000000800ULL, 0x0001a6a81f087810ULL, 0x000fe40007ffe0ffULL,
0x8000000000ff7812ULL, 0x002fe2000780486dULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c02257210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141dULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x0000000200007819ULL, 0x000fc8000000121dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac001f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991024007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff027819ULL, 0x000fe40000011617ULL, 0x0000541000277816ULL, 0x000fe20000000000ULL,
0x00014fc27f007947ULL, 0x000fea000b800000ULL, 0x00001f0227077589ULL, 0x0002a400000e0000ULL,
0x0000000802267810ULL, 0x000fe20007ffe0ffULL, 0x000150027f007947ULL, 0x000fea000b800000ULL,
0x0000001002007810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0027057589ULL, 0x0006a400000e0000ULL, 0x0000001802267810ULL, 0x008fe20007ffe0ffULL,
0x000150727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004136c7824ULL, 0x000fe200078e00ffULL,
0x0000000817007812ULL, 0x000fe200078ec0ffULL, 0x000004001a1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff787819ULL, 0x100fe20000011617ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000046c6c7812ULL, 0x000fe200078ec0ffULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000000700037812ULL, 0x000fc400078ef817ULL, 0x0000006c17007211ULL, 0x000fe400078fe0ffULL,
0x0000001003027812ULL, 0x042fe200078efcffULL, 0x00000008031f7824ULL, 0x000fe200078e00ffULL,
0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001031c7824ULL, 0x000fe400078e0200ULL,
0x0000000100007824ULL, 0x000fe200078e0202ULL, 0x000120001d6d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000802257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x00000004111f7824ULL, 0x000fc400078e0278ULL, 0x0000000803277824ULL, 0x008fe200078e00ffULL,
0xfffffff8251d7812ULL, 0x000fe200078ee200ULL, 0x0000000103707824ULL, 0x000fe200078e021fULL,
0x0001600013007811ULL, 0x000fe200078e68ffULL, 0x000000101c687824ULL, 0x100fe400078e026dULL,
0x000000101d247824ULL, 0x000fe200078e026dULL, 0xfffffff827257812ULL, 0x000fc600078ee270ULL,
0x000000006868783bULL, 0x000e640000000200ULL, 0x0000001025747824ULL, 0x000fe400078e0200ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687232ULL, 0x086fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fe40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803717824ULL, 0x000fe200078e00ffULL,
0x0000000270707810ULL, 0x000fe20007ffe0ffULL, 0x000000007474783bULL, 0x000f220000004200ULL,
0x00000001021f7824ULL, 0x000fe200078e021fULL, 0x000008d000007945ULL, 0x000fe20003800000ULL,
0xfffffff871717812ULL, 0x000fca00078ee270ULL, 0x0000001071717824ULL, 0x000fcc00078e0200ULL,
0x000000007170783bULL, 0x000ee20000004200ULL, 0x00000018ff7a7819ULL, 0x010fe20000011475ULL,
0x0001000077857824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011474ULL,
0x0000007a007e7306ULL, 0x0009e20000200c00ULL, 0x00000018ff7c7819ULL, 0x000fe40000011476ULL,
0x00000018ff7d7819ULL, 0x000fe40000011477ULL, 0x00000018ff857819ULL, 0x000fc60000011485ULL,
0x00000079007b7306ULL, 0x0005e20000200c00ULL, 0x00000100747a7824ULL, 0x010fe200078e00ffULL,
0x00000018ff837819ULL, 0x008fe20000011473ULL, 0x0000010070887824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011470ULL, 0x0000010073927824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff807819ULL, 0x000fe20000011471ULL,
0x0000008300937306ULL, 0x0007e20000200c00ULL, 0x0000888074797816ULL, 0x044fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x0000888070877816ULL, 0x040fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc40000011472ULL,
0x00008880728e7816ULL, 0x000fe200000000ffULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x0000010077837824ULL, 0x008fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000888073917816ULL, 0x000fe400000000ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff927819ULL, 0x000fc40000011492ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff887819ULL, 0x000fc60000011488ULL,
0x0000007f008a7306ULL, 0x0005f00000200c00ULL, 0x00000080008c7306ULL, 0x0007e20000200c00ULL,
0x00008880767f7816ULL, 0x004fce00000000ffULL, 0x0000008300847306ULL, 0x0005e20000200c00ULL,
0x0000010076807824ULL, 0x048fe400078e00ffULL, 0x0001000076767824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000008100907306ULL, 0x0007e20000200c00ULL, 0x0000888071837816ULL, 0x004fce00000000ffULL,
0x0000007c00827306ULL, 0x0005e20000200c00ULL, 0x0000888077817816ULL, 0x008fce00000000ffULL,
0x0000007d00867306ULL, 0x0007e20000200c00ULL, 0x00008880757c7816ULL, 0x004fce00000000ffULL,
0x0000007600777306ULL, 0x0005220000200c00ULL, 0x00000100757d7824ULL, 0x048fe400078e00ffULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000008300897306ULL, 0x0007e20000200c00ULL, 0x0000010071767824ULL, 0x044fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0001000071717824ULL, 0x000fc600078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000070008b7306ULL, 0x0004620000200c00ULL,
0x0000010072837824ULL, 0x048fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x0000541077827816ULL, 0x010fe40000000082ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x0000541079707816ULL, 0x004fe2000000007aULL,
0x0001000073797824ULL, 0x000fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x00000083008f7306ULL, 0x000ea20000200c00ULL, 0x000054108b8a7816ULL, 0x002fce000000008aULL,
0x0000009100917306ULL, 0x000ff00000200c00ULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x000054108e8e7816ULL, 0x004fce000000008fULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x00005410918f7816ULL, 0x002fce0000000092ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000008e684c723cULL, 0x080f6e000000184cULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x0000008e242c723cULL, 0x000f6e000000182cULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541074747816ULL, 0x002fce000000007bULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x0000541075757816ULL, 0x004fce000000007eULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x000000746860723cULL, 0x080f6e0000001860ULL,
0x0000008500857306ULL, 0x000ee20000200c00ULL, 0x000054107f807816ULL, 0x002fe20000000080ULL,
0x000000742440723cULL, 0x000f6c0000001840ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000541081817816ULL, 0x004fce0000000084ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x0000541085837816ULL, 0x008fe20000000086ULL, 0x00000080685c723cULL, 0x040f6c000000185cULL,
0x0000007600767306ULL, 0x000ea40000200c00ULL, 0x000000826858723cULL, 0x000f6c0000001858ULL,
0x00000071008d7306ULL, 0x0007220000200c00ULL, 0x0000541087887816ULL, 0x002fe20000000088ULL,
0x00000080243c723cULL, 0x040f6c000000183cULL, 0x0000007200737306ULL, 0x000e620000200c00ULL,
0x000054107c717816ULL, 0x008fe2000000007dULL, 0x000000822438723cULL, 0x000f620000001838ULL,
0x0000541089897816ULL, 0x004fca0000000076ULL, 0x00000079007a7306ULL, 0x000ea20000200c00ULL,
0x000054108d8b7816ULL, 0x010fe2000000008cULL, 0x000000706864723cULL, 0x000f620000001864ULL,
0x0000541073907816ULL, 0x002fce0000000090ULL, 0x000000886854723cULL, 0x000f620000001854ULL,
0x000054107a917816ULL, 0x004fce0000000093ULL, 0x0000008a6850723cULL, 0x040f700000001850ULL,
0x000000906848723cULL, 0x000b6e0000001848ULL, 0x000000026c697812ULL, 0x020fe200078efcffULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0x000000702444723cULL, 0x000f620000001844ULL,
0x00000008026a7824ULL, 0x000fc400078e00ffULL, 0x0000000178697824ULL, 0x000fe400078e0269ULL,
0x00000008026c7824ULL, 0x040fe400078e00ffULL, 0x0000000103687824ULL, 0x100fe200078e0269ULL,
0x000000882434723cULL, 0x000f620000001834ULL, 0x0000000102697824ULL, 0x000fc600078e0269ULL,
0xfffffff86b687812ULL, 0x000fe400078ee268ULL, 0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL,
0xfffffff86c697812ULL, 0x000fe200078ee21fULL, 0x0000001068687824ULL, 0x100fe200078e026dULL,
0x0000008a2430723cULL, 0x040f620000001830ULL, 0x000000106a6d7824ULL, 0x000fe400078e026dULL,
0x0000001069747824ULL, 0x000fe400078e0200ULL, 0x000000006868783bULL, 0x000e660000000200ULL,
0x000000902428723cULL, 0x000b640000001828ULL, 0x000000006d24783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000768687232ULL, 0x082fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fc40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fe40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008026c7824ULL, 0x000fe200078e00ffULL,
0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000007474783bULL, 0x000f260000004200ULL,
0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL, 0x000000101f1f7824ULL, 0x000fca00078e0200ULL,
0x000000001f70783bULL, 0x0004e20000004200ULL, 0x00000018ff6c7819ULL, 0x010fe40000011474ULL,
0x00000018ff797819ULL, 0x000fe40000011476ULL, 0x0000006c00787306ULL, 0x0009e20000200c00ULL,
0x00000018ff6d7819ULL, 0x004fe40000011475ULL, 0x00000018ff7a7819ULL, 0x000fe40000011477ULL,
0x00008880741f7816ULL, 0x000fc600000000ffULL, 0x0000007900807306ULL, 0x0005e20000200c00ULL,
0x00000100746c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x008fe20000011471ULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011472ULL,
0x0000010070847824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011473ULL,
0x00000100728a7824ULL, 0x000fe200078e00ffULL, 0x0000006d007c7306ULL, 0x0007e20000200c00ULL,
0x0000010075797824ULL, 0x004fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc40000011470ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000888070837816ULL, 0x040fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x0000007d00887306ULL, 0x0005e20000200c00ULL,
0x00008880756d7816ULL, 0x008fe400000000ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000007e008c7306ULL, 0x0007e20000200c00ULL, 0x00008880767d7816ULL, 0x004fc400000000ffULL,
0x00008880738d7816ULL, 0x000fe400000000ffULL, 0x0000888071857816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000007f008e7306ULL, 0x0005e20000200c00ULL,
0x00000100767e7824ULL, 0x048fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0001000076767824ULL, 0x000fc600078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007a00817306ULL, 0x000fe20000200c00ULL, 0x00010000777f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fc80000011476ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x00000079007a7306ULL, 0x0004f00000200c00ULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x0000888077797816ULL, 0x004fce00000000ffULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000054106d6d7816ULL, 0x008fce000000007aULL,
0x0000007b00867306ULL, 0x0007f00000200c00ULL, 0x0000007000877306ULL, 0x0008620000200c00ULL,
0x00010000757b7824ULL, 0x008fe200078e00ffULL, 0x000054101f6c7816ULL, 0x004fc8000000006cULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000007400757306ULL, 0x0005e20000200c00ULL,
0x0000010073707824ULL, 0x050fe200078e00ffULL, 0x0000006c2444723cULL, 0x000f620000001844ULL,
0x0001000073737824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007f00827306ULL, 0x0007220000200c00ULL, 0x0000010077747824ULL, 0x004fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000006c6864723cULL, 0x002f620000001864ULL,
0x0000541087867816ULL, 0x000fe40000000086ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000007600777306ULL, 0x0002a20000200c00ULL, 0x00008880727f7816ULL, 0x048fe200000000ffULL,
0x0001000072727824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000007f008b7306ULL, 0x000fe20000200c00ULL, 0x0000010071767824ULL, 0x042fe200078e00ffULL,
0x0000541082817816ULL, 0x010fe20000000081ULL, 0x0001000071717824ULL, 0x000fc600078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x0000541077807816ULL, 0x004fce0000000080ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000000802438723cULL, 0x080f6e0000001838ULL,
0x00000070007a7306ULL, 0x0004e20000200c00ULL, 0x000054108b8a7816ULL, 0x002fe2000000008aULL,
0x000000806858723cULL, 0x000f6c0000001858ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x0000541075707816ULL, 0x004fce0000000078ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000054108d8b7816ULL, 0x008fce000000007aULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x0000008a242c723cULL, 0x080f6e000000182cULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x0000008a684c723cULL, 0x000f6e000000184cULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000054107d7e7816ULL, 0x002fce000000007eULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x00005410797f7816ULL, 0x004fce0000000074ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000007e243c723cULL, 0x080f6e000000183cULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x0000541083847816ULL, 0x002fe20000000084ULL,
0x0000007e685c723cULL, 0x000f6c000000185cULL, 0x0000007100897306ULL, 0x0002f00000200c00ULL,
0x00000072001f7306ULL, 0x000f220000200c00ULL, 0x000054107b717816ULL, 0x002fc4000000007cULL,
0x0000541085857816ULL, 0x004fca0000000076ULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x0000541089877816ULL, 0x008fe20000000088ULL, 0x000000702440723cULL, 0x000f620000001840ULL,
0x000054101f8c7816ULL, 0x010fe2000000008cULL, 0x000000021a1f7824ULL, 0x000fcc00078e00ffULL,
0x000000842434723cULL, 0x000f620000001834ULL, 0xfffffff81f1f7812ULL, 0x000fe400078ec0ffULL,
0x00005410738d7816ULL, 0x002fca000000008eULL, 0x000000862430723cULL, 0x040f700000001830ULL,
0x0000008c2428723cULL, 0x000f700000001828ULL, 0x000000706860723cULL, 0x040f700000001860ULL,
0x000000846854723cULL, 0x040f700000001854ULL, 0x000000866850723cULL, 0x040f700000001850ULL,
0x0000008c6848723cULL, 0x000b6e0000001848ULL, 0x0001a6c813687811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a688001fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000000247805ULL, 0x000fc80000015200ULL,
0x000004000d1f7984ULL, 0x004ea40000000800ULL, 0x800000001fff7812ULL, 0x006fc40007804869ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800c257810ULL, 0x000fca0007ffe0ffULL,
0x00006800126c7a24ULL, 0x000fe200078e0225ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x00000025161f7217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a25ULL,
0x0000000427697810ULL, 0x040fe20007ffe0ffULL, 0x0000000170247824ULL, 0x040fe200078e0227ULL,
0x00000008276b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001f701f7217ULL, 0x000fe20007800000ULL,
0x0000000124257824ULL, 0x040fe200078e0217ULL, 0x0000000c27737810ULL, 0x000fe20007ffe0ffULL,
0x0000000824267824ULL, 0x000fe400078e00ffULL, 0x0000000170717824ULL, 0x000fc400078e0269ULL,
0x0000000124247824ULL, 0x000fe200078e026cULL, 0xfffffff8266d7812ULL, 0x000fe200078ee225ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a70ULL, 0x0000000171267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000001f2700720cULL, 0x080fe40003f06070ULL,
0x0000001f6900720cULL, 0x000fe20003f86070ULL, 0x0000000170727824ULL, 0x000fe200078e026bULL,
0x0000000b246a7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000001f6b00720cULL, 0x000fc40003f66070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000170707824ULL, 0x000fe200078e0273ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000000172687824ULL, 0x100fe200078e026cULL, 0x00006500256b7a10ULL, 0x000fe20002ffe4ffULL,
0x0000000170247824ULL, 0x000fe200078e026cULL, 0x0000640026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000001f7300720cULL, 0x000fe40003fa6070ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x00000001716c7824ULL, 0x040fe200078e0217ULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x0000000871717824ULL, 0x000fc400078e00ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000640068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff8711f7812ULL, 0x000fe200078ee26cULL, 0x00000001726c7824ULL, 0x100fe200078e0217ULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x0000000872717824ULL, 0x000fe200078e00ffULL,
0x0000650069697a10ULL, 0x000fe200037fe4ffULL, 0x0000000170727824ULL, 0x000fe200078e0217ULL,
0x0000640024247a10ULL, 0x000fe20007fde0ffULL, 0x0000000870737824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee26cULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x0000650025257a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0xfffffff873737812ULL, 0x000fe200078ee272ULL, 0x0000001071717824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a6d7faeULL, 0x0003e6000c101c46ULL,
0x0000001073737824ULL, 0x000fe200078e0200ULL, 0x00000000261f7faeULL, 0x0003e8000e101c46ULL,
0x0000000068717faeULL, 0x0003e8000d901c46ULL, 0x0000000024737faeULL, 0x0003e2000e901c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001011247824ULL, 0x000fca00078e00ffULL,
0x00000024171f7211ULL, 0x000fc800078fe8ffULL, 0x000000041f267810ULL, 0x040fe20007ffe0ffULL,
0x000000011f247824ULL, 0x140fe200078e0217ULL, 0x000000081f687810ULL, 0x040fe20007ffe0ffULL,
0x000000081f6d7824ULL, 0x000fe400078e00ffULL, 0x0000000126257824ULL, 0x140fe400078e0217ULL,
0x00000008266a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL,
0x000000011f247824ULL, 0x040fe200078e026cULL, 0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000168277824ULL, 0x000fe200078e0217ULL, 0xfffffff86a717812ULL, 0x000fe200078ee225ULL,
0x0000000868707824ULL, 0x000fc400078e00ffULL, 0x0000000126267824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0xfffffff870737812ULL, 0x000fc600078ee227ULL,
0x0000000168687824ULL, 0x100fe200078e026cULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x000000011f6a7824ULL, 0x000fe400078e026cULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000640024247a10ULL, 0x000fc60007f1e0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000650025257a10ULL, 0x000fe200007fe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x080fe400078efcffULL,
0x0000640026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000011f6c7824ULL, 0x040fe200078e0217ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000640068687a10ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x0000650027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000b901c46ULL, 0x0000650069697a10ULL, 0x000fe200007fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026717faeULL, 0x0003e8000b901c46ULL, 0x0000000068737faeULL, 0x0003e8000b901c46ULL,
0x000000006a1f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000080503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6280023687f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL,
0x0000001014267812ULL, 0x000fca00078ec0ffULL, 0x000000011f267824ULL, 0x000fc800078e0226ULL,
0x00000008116a7824ULL, 0x000fca00078e0226ULL, 0x01a62c006a1f7984ULL, 0x000f240000000800ULL,
0x800000001fff7812ULL, 0x012fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011427ULL, 0x000000261f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x000000021f1f7819ULL, 0x000fc80000001226ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c006a1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a1f7824ULL, 0x000fca00078e00ffULL,
0xffffff801f247812ULL, 0x000fc800078ec0ffULL, 0x000000800b1f7810ULL, 0x000fca0007ffe024ULL,
0x000000010a1f7824ULL, 0x000fca00078e021fULL, 0x01a000001f697984ULL, 0x000e680000000800ULL,
0x01a200001f687984ULL, 0x0006a20000000800ULL, 0x0000001e6900720bULL, 0x002fe20003f1d000ULL,
0x00012f727f007947ULL, 0x000fd8000b800000ULL, 0x00000000001f7806ULL, 0x008fc800000e0100ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e001eULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000110257810ULL, 0x000fe40007ffe0ffULL,
0x0000001e6900720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x00012f327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x0000001e69247209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x01a4002425008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001e241e7221ULL, 0x002fe20000010100ULL,
0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00012e827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00012d627f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x00012c427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000070ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00012b327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000701fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fd800078e00ffULL,
0x8000002469690221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL, 0x0000006900090308ULL, 0x000e640000000800ULL,
0x0000000968680220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002268227221ULL, 0x004fc40000010000ULL, 0x00000000001e7805ULL, 0x000fca0000015200ULL,
0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006a277984ULL, 0x008e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x000000261e697210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e1fULL,
0x003d09006900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910251e7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff1e7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x000127127f007947ULL, 0x000fea000b800000ULL, 0x00001f1e27077589ULL, 0x0002a400000e0000ULL,
0x000000081e267810ULL, 0x000fe20007ffe0ffULL, 0x000127527f007947ULL, 0x000fea000b800000ULL,
0x000000101e047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000181e267810ULL, 0x008fe20007ffe0ffULL,
0x000127c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041a1e7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a207824ULL, 0x040fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000010001a1f7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000803267824ULL, 0x008fe200078e00ffULL,
0xfffff00020207812ULL, 0x000fc400078ec0ffULL, 0x0000001e171e7211ULL, 0x000fe400078fe0ffULL,
0x0001300020207810ULL, 0x000fe40007ffe0ffULL, 0xffffe0001f217812ULL, 0x000fe200078ec0ffULL,
0x00000001031f7824ULL, 0x000fe400078e021eULL, 0x000000101c707824ULL, 0x100fe200078e0220ULL,
0x0001700021257810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0220ULL,
0xfffffff8261c7812ULL, 0x000fc600078ee21fULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x000000101c787824ULL, 0x000fe400078e0225ULL, 0x000000001d68783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707232ULL, 0x086fe40000000000ULL,
0x0000000772727232ULL, 0x000fe40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fc40000000000ULL, 0x0000000568687232ULL, 0x080fe40000000000ULL,
0x000000056a6a7232ULL, 0x000fe40000000000ULL, 0x0000000469697232ULL, 0x080fe40000000000ULL,
0x000000046b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803267824ULL, 0x000fe200078e00ffULL, 0x000000021f217810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000091000007945ULL, 0x000fe40003800000ULL,
0xfffffff826217812ULL, 0x000fca00078ee221ULL, 0x0000001021747824ULL, 0x000fcc00078e0225ULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x00000018ff1f7819ULL, 0x010fe20000011479ULL,
0x000001007b837824ULL, 0x040fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe4000001147aULL,
0x0000001f007d7306ULL, 0x0009e20000200c00ULL, 0x00000018ff277819ULL, 0x000fe4000001147bULL,
0x00000018ff1d7819ULL, 0x008fe40000011478ULL, 0x000088807b817816ULL, 0x040fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000002700857306ULL, 0x0007e20000200c00ULL, 0x00000100781f7824ULL, 0x010fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011476ULL, 0x0000010074877824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc40000011474ULL, 0x00000018ff807819ULL, 0x000fe40000011477ULL,
0x0000007f008d7306ULL, 0x0009e20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000888079277816ULL, 0x008fe400000000ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011475ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007c008a7306ULL, 0x0007e20000200c00ULL,
0x000001007a7f7824ULL, 0x010fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc40000011487ULL,
0x00008880778f7816ULL, 0x000fe400000000ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000008000907306ULL, 0x000fe20000200c00ULL, 0x00000100797c7824ULL, 0x048fe400078e00ffULL,
0x0001000079797824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000001d00257306ULL, 0x0007e20000200c00ULL, 0x00000018ff797819ULL, 0x000fce0000011479ULL,
0x0000002600827306ULL, 0x000fe20000200c00ULL, 0x00008880781d7816ULL, 0x048fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007f00807306ULL, 0x0007f00000200c00ULL, 0x0000001f00267306ULL, 0x0009e20000200c00ULL,
0x00008880747f7816ULL, 0x048fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000008300847306ULL, 0x0007e20000200c00ULL,
0x000088807a1f7816ULL, 0x050fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000888075837816ULL, 0x008fce00000000ffULL, 0x0000007c007c7306ULL, 0x000ef00000200c00ULL,
0x0000007e008b7306ULL, 0x000ff00000200c00ULL, 0x0000007b00867306ULL, 0x000fe20000200c00ULL,
0x0000541027277816ULL, 0x008fce000000007cULL, 0x00000079007e7306ULL, 0x000ff00000200c00ULL,
0x0000008700887306ULL, 0x0007f00000200c00ULL, 0x0000008300897306ULL, 0x0009e20000200c00ULL,
0x0000888076877816ULL, 0x008fce00000000ffULL, 0x00000074007b7306ULL, 0x0006a20000200c00ULL,
0x0000010076837824ULL, 0x050fe400078e00ffULL, 0x0001000076767824ULL, 0x000fc600078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000007a00797306ULL, 0x0008620000200c00ULL,
0x0000010077747824ULL, 0x048fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0001000077777824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x00000100757a7824ULL, 0x050fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x000054107b8a7816ULL, 0x004fe4000000008aULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000001d001d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff757819ULL, 0x000fc40000011475ULL,
0x0000541079827816ULL, 0x002fca0000000082ULL, 0x0000001f001f7306ULL, 0x000e700000200c00ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054101d267816ULL, 0x004fce0000000026ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x000000267064723cULL, 0x000f620000001864ULL,
0x000054101f807816ULL, 0x002fe20000000080ULL, 0x00000008021f7824ULL, 0x000fca00078e00ffULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x000000266844723cULL, 0x000b620000001844ULL,
0x0000541081817816ULL, 0x008fcc0000000084ULL, 0x00000075008c7306ULL, 0x0007220000200c00ULL,
0x000054107f887816ULL, 0x004fe20000000088ULL, 0x00000080705c723cULL, 0x000f64000000185cULL,
0x0000000102277824ULL, 0x020fc800078e021eULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000054107e757816ULL, 0x008fe2000000007dULL, 0x00000080683c723cULL, 0x000f62000000183cULL,
0x0000541089897816ULL, 0x002fca000000007aULL, 0x00000083008e7306ULL, 0x0002a20000200c00ULL,
0x000054108c8b7816ULL, 0x010fe2000000008bULL, 0x000000887054723cULL, 0x040f6c0000001854ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000541086837816ULL, 0x002fe20000000085ULL,
0x0000008a7050723cULL, 0x040f6c0000001850ULL, 0x00000074007c7306ULL, 0x0002e20000200c00ULL,
0x00005410878e7816ULL, 0x004fe2000000008eULL, 0x000000827058723cULL, 0x080f6c0000001858ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x0000541078747816ULL, 0x002fe20000000025ULL,
0x000000021a257824ULL, 0x000fe200078e00ffULL, 0x000000826838723cULL, 0x000f680000001838ULL,
0x00000004251d7812ULL, 0x000fe200078ec0ffULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x000054108f8f7816ULL, 0x008fc4000000007cULL, 0x000000021d267812ULL, 0x000fe200078efcffULL,
0x000000747060723cULL, 0x000f660000001860ULL, 0x0000002617267211ULL, 0x000fe400078fe0ffULL,
0x0000541076767816ULL, 0x004fc6000000008dULL, 0x0000008e704c723cULL, 0x000f62000000184cULL,
0x00000001031d7824ULL, 0x100fe400078e0226ULL, 0x0000000102267824ULL, 0x000fe200078e0226ULL,
0x0000541077777816ULL, 0x002fc80000000090ULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee226ULL,
0x000000746840723cULL, 0x000f620000001840ULL, 0x0000100000267810ULL, 0x000fce0007ffe0ffULL,
0x000000767048723cULL, 0x000b6e0000001848ULL, 0x0000000803707824ULL, 0x020fe200078e00ffULL,
0x000000886834723cULL, 0x000f620000001834ULL, 0x0000000802727824ULL, 0x000fc600078e00ffULL,
0xfffffff8701d7812ULL, 0x000fe400078ee21dULL, 0xfffffff8721f7812ULL, 0x000fe400078ee227ULL,
0x0000008a6830723cULL, 0x040f620000001830ULL, 0x000000101d707824ULL, 0x100fe400078e0220ULL,
0x000000101e207824ULL, 0x000fe400078e0220ULL, 0x000000101f787824ULL, 0x000fe400078e0226ULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x0000008e682c723cULL, 0x040f70000000182cULL,
0x000000766828723cULL, 0x000b640000001828ULL, 0x000000002068783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707232ULL, 0x082fe40000000000ULL, 0x0000000772727232ULL, 0x000fc40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fe40000000000ULL,
0x0000000568687232ULL, 0x088fe40000000000ULL, 0x000000056a6a7232ULL, 0x000fe40000000000ULL,
0x0000000469697232ULL, 0x080fe40000000000ULL, 0x000000046b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802757824ULL, 0x000fe200078e00ffULL,
0x0000000227207810ULL, 0x004fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ea60000004200ULL,
0xfffffff875207812ULL, 0x000fca00078ee220ULL, 0x0000001020747824ULL, 0x000fcc00078e0226ULL,
0x000000007474783bULL, 0x000f220000004200ULL, 0x00000018ff277819ULL, 0x004fe20000011479ULL,
0x000100007b857824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147bULL,
0x00000018ff267819ULL, 0x000fe20000011478ULL, 0x0000002700807306ULL, 0x0005e20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147aULL, 0x00000018ff857819ULL, 0x000fca0000011485ULL,
0x0000007e00867306ULL, 0x0007e20000200c00ULL, 0x0000010078277824ULL, 0x004fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x010fe20000011474ULL, 0x0000010074887824ULL, 0x040fe200078e00ffULL,
0x0000888074877816ULL, 0x040fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x00000100768f7824ULL, 0x000fe200078e00ffULL,
0x00000026007c7306ULL, 0x0005e20000200c00ULL, 0x00000100797e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fc40000011475ULL, 0x00000018ff827819ULL, 0x000fe40000011476ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007d00847306ULL, 0x0007e20000200c00ULL,
0x0000888078267816ULL, 0x044fe200000000ffULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff837819ULL, 0x000fe40000011477ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x00008880797d7816ULL, 0x008fc400000000ffULL, 0x0000888075897816ULL, 0x000fe400000000ffULL,
0x00008880768e7816ULL, 0x040fe200000000ffULL, 0x0001000076767824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x0000888077917816ULL, 0x000fe400000000ffULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff767819ULL, 0x000fc60000011476ULL, 0x0000007f008a7306ULL, 0x0007f00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x00010000797f7824ULL, 0x008fe200078e00ffULL,
0x0000541026267816ULL, 0x004fc80000000027ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000007800797306ULL, 0x0007f00000200c00ULL,
0x00000081008c7306ULL, 0x0009e20000200c00ULL, 0x000054107d277816ULL, 0x004fe2000000007eULL,
0x000001007b787824ULL, 0x008fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000008200907306ULL, 0x0005e20000200c00ULL, 0x000088807a817816ULL, 0x050fe200000000ffULL,
0x000000267064723cULL, 0x082f6c0000001864ULL, 0x00000074008b7306ULL, 0x0002e20000200c00ULL,
0x000001007a827824ULL, 0x044fe200078e00ffULL, 0x000000266844723cULL, 0x000b620000001844ULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000010077747824ULL, 0x002fe200078e00ffULL,
0x0000008300927306ULL, 0x0003e20000200c00ULL, 0xfffffff825267812ULL, 0x020fc600078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x000054108b8a7816ULL, 0x008fe4000000008aULL,
0x00000074007e7306ULL, 0x0005e20000200c00ULL, 0x000088807b837816ULL, 0x002fce00000000ffULL,
0x0000007a007b7306ULL, 0x0002e20000200c00ULL, 0x0000541079747816ULL, 0x004fe2000000007cULL,
0x0001000077797824ULL, 0x000fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x00000100757a7824ULL, 0x042fe400078e00ffULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x000054107b847816ULL, 0x008fce0000000084ULL, 0x0000009100917306ULL, 0x000eb00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108e8e7816ULL, 0x002fce000000008fULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00005410918f7816ULL, 0x004fce000000007eULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000008e704c723cULL, 0x080f6e000000184cULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000008e682c723cULL, 0x000f6e000000182cULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541081827816ULL, 0x002fce0000000082ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000541083837816ULL, 0x004fce0000000078ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x0000541085857816ULL, 0x002fe20000000086ULL, 0x00000082705c723cULL, 0x040f6c000000185cULL,
0x0000008900897306ULL, 0x000fe40000200c00ULL, 0x000000847058723cULL, 0x000f6c0000001858ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541087887816ULL, 0x004fe20000000088ULL,
0x00000082683c723cULL, 0x040f6c000000183cULL, 0x00000075008d7306ULL, 0x0004e40000200c00ULL,
0x000000846838723cULL, 0x000f6c0000001838ULL, 0x0000007600777306ULL, 0x000f220000200c00ULL,
0x000054107f757816ULL, 0x004fc40000000080ULL, 0x0000541089897816ULL, 0x002fca000000007aULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054108d8b7816ULL, 0x008fe2000000008cULL,
0x000000747060723cULL, 0x000f620000001860ULL, 0x0000541077907816ULL, 0x010fce0000000090ULL,
0x000000887054723cULL, 0x000f620000001854ULL, 0x0000541079917816ULL, 0x002fce0000000092ULL,
0x0000008a7050723cULL, 0x040f700000001850ULL, 0x000000907048723cULL, 0x000f700000001848ULL,
0x000000746840723cULL, 0x040f700000001840ULL, 0x000000886834723cULL, 0x040f700000001834ULL,
0x0000008a6830723cULL, 0x040f700000001830ULL, 0x000000906828723cULL, 0x000b6e0000001828ULL,
0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x000004000d697984ULL, 0x000ea40000000800ULL,
0x8000000069ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000687805ULL, 0x000fcc0000015200ULL, 0x0000006826717210ULL, 0x000fca0007f1e1ffULL,
0x0000000169697824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff687819ULL, 0x000fc80000011469ULL,
0x0000007168687211ULL, 0x000fca00078110ffULL, 0x000000ffff697224ULL, 0x000fca00000e0669ULL,
0x0000000268687819ULL, 0x000fc80000001269ULL, 0x000000680000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d697984ULL, 0x000e640000000800ULL,
0x8000000069ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c277810ULL, 0x000fca0007ffe0ffULL, 0x0000680012717a24ULL, 0x000fe200078e0227ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000002716257217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe40000011617ULL,
0x0000100000777810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a27ULL,
0x0000000468697810ULL, 0x000fe20007ffe0ffULL, 0x0000000170267824ULL, 0x000fe200078e0268ULL,
0x00000008686b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002570257217ULL, 0x000fe20007800000ULL,
0x0000000126277824ULL, 0x000fc400078e0217ULL, 0x0000000826727824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe400078e0a70ULL, 0x0000000126267824ULL, 0x000fe200078e0271ULL,
0xfffffff872727812ULL, 0x000fe200078ee227ULL, 0x0000000170747824ULL, 0x000fe200078e0269ULL,
0x000000256900720cULL, 0x080fe20003f86070ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c68697810ULL, 0x040fe40007ffe0ffULL, 0x000000256800720cULL, 0x080fe20003fa6070ULL,
0x0000000174687824ULL, 0x000fe200078e0271ULL, 0x000000256900720cULL, 0x000fe20003f06070ULL,
0x0000000170787824ULL, 0x000fe200078e0269ULL, 0x0000000b266a7212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x000000256b00720cULL, 0x000fc40003f66070ULL,
0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000170767824ULL, 0x000fe200078e026bULL,
0x0000000b68707212ULL, 0x000fe200078efcffULL, 0x0000000174257824ULL, 0x000fe200078e0217ULL,
0x00006500276b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000176267824ULL, 0x000fe200078e0271ULL,
0x0000640070707a10ULL, 0x000fe20007fde0ffULL, 0x0000000874747824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee225ULL,
0x0000000178687824ULL, 0x000fe200078e0271ULL, 0x0000650069717a10ULL, 0x000fe200037fe4ffULL,
0x0000000176737824ULL, 0x000fe200078e0217ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fc600078e00ffULL, 0x0000640026267a10ULL, 0x000fe20007fde0ffULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x0000000178257824ULL, 0x040fe200078e0217ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee273ULL,
0x0000001074737824ULL, 0x000fe200078e0277ULL, 0x0000640068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff878787812ULL, 0x000fe200078ee225ULL, 0x0000001072257824ULL, 0x100fe200078e0277ULL,
0x0000650069697a10ULL, 0x000fe200037fe4ffULL, 0x0000001076757824ULL, 0x000fc400078e0277ULL,
0x0000001078777824ULL, 0x000fe200078e0277ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a257faeULL, 0x0003e8000e901c46ULL, 0x0000000070737faeULL, 0x0003e8000e101c46ULL,
0x0000000026757faeULL, 0x0003e8000d901c46ULL, 0x0000000068777faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fe200078e00ffULL,
0x0000100000777810ULL, 0x000fc80007ffe0ffULL, 0x0000002617687211ULL, 0x000fc800078fe8ffULL,
0x00000004686a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000168267824ULL, 0x040fe200078e0271ULL,
0x0000000868747810ULL, 0x040fe20007ffe0ffULL, 0x0000000168257824ULL, 0x040fe200078e0217ULL,
0x0000000c68767810ULL, 0x040fe20007ffe0ffULL, 0x0000000868727824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000016a257824ULL, 0x000fe200078e0271ULL, 0x0000000b26707212ULL, 0x000fe200078efcffULL,
0x000000016a697824ULL, 0x040fe400078e0217ULL, 0x000000086a787824ULL, 0x000fe200078e00ffULL,
0x0000640070707a10ULL, 0x000fe20007f1e0ffULL, 0x0000000174687824ULL, 0x100fe400078e0271ULL,
0x00000001766a7824ULL, 0x040fe400078e0271ULL, 0x0000000176267824ULL, 0x000fc400078e0217ULL,
0x0000000876717824ULL, 0x000fe400078e00ffULL, 0x00000001746b7824ULL, 0x040fe400078e0217ULL,
0x00000008747a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878747812ULL, 0x000fe200078ee269ULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0xfffffff871787812ULL, 0x000fe400078ee226ULL,
0x0000650027717a10ULL, 0x000fe200007fe4ffULL, 0x0000008025267825ULL, 0x000fe200078e00ffULL,
0xfffffff87a767812ULL, 0x000fc400078ee26bULL, 0x0000000b68687212ULL, 0x080fe200078efcffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000640068687a10ULL, 0x000fe20007f7e0ffULL, 0x0000001072257824ULL, 0x100fe200078e0277ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000001074737824ULL, 0x100fe200078e0277ULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x0000001076757824ULL, 0x100fe200078e0277ULL,
0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001078777824ULL, 0x000fe200078e0277ULL,
0x0000650027277a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070257faeULL, 0x0003e2000b901c46ULL, 0x0000650069697a10ULL, 0x000fc40001ffe4ffULL,
0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026737faeULL, 0x0003e8000b901c46ULL,
0x0000000068757faeULL, 0x0003e8000b901c46ULL, 0x000000006a777faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff014687812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b00068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6480023707f8cULL, 0x0004e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0xffffffe014237812ULL, 0x044fe400078ec0ffULL, 0x00000010146a7812ULL, 0x040fe400078ec0ffULL,
0x0000000814257812ULL, 0x000fc800078ec0ffULL, 0x0000002325237210ULL, 0x000fca0007ffe06aULL,
0x01a64c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x00cfe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146bULL,
0x0000006a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000225257819ULL, 0x000fc8000000126aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a64c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a237824ULL, 0x000fca00078e00ffULL, 0xffffff8023267812ULL, 0x000fc800078ec0ffULL,
0x000001000b237810ULL, 0x000fca0007ffe026ULL, 0x000000010a237824ULL, 0x000fca00078e0223ULL,
0x01a0000023737984ULL, 0x000ea80000000800ULL, 0x01a2000023707984ULL, 0x0006620000000800ULL,
0x000000247300720bULL, 0x004fe20003f1d000ULL, 0x000107527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0024ULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x0000000210237810ULL, 0x000fe40007ffe0ffULL, 0x000000247300720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x000107127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000237806ULL, 0x000fc400018e0100ULL, 0x000000801a278824ULL, 0x000fe200078e020bULL,
0x0000002473257209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a268824ULL, 0x000fca00078e0227ULL, 0x01a4002526008388ULL, 0x0005e20000000800ULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000002524257221ULL, 0x004fe20000010000ULL, 0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500277308ULL, 0x000ea40000000800ULL, 0x0000002722227220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000106627f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000105427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000104227f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000023ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000103127f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000002372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff6a7424ULL, 0x000fe200078e00ffULL, 0x0000002473237209ULL, 0x000fd60007810000ULL,
0x8000002373730221ULL, 0x000fe20000010000ULL, 0x00007610ff6a0816ULL, 0x000fc6000000006aULL,
0x3fb8aa3b73730820ULL, 0x000fc80000410000ULL, 0x0000007300090308ULL, 0x000ea40000000800ULL,
0x0000000970700220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002270227221ULL, 0x002fc40000010000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026246b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106a247816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff247819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000fef27f007947ULL, 0x000fea000b800000ULL,
0x00001f2427077589ULL, 0x0002a400000e0000ULL, 0x0000000824267810ULL, 0x000fe20007ffe0ffULL,
0x0000ff327f007947ULL, 0x000fea000b800000ULL, 0x0000001024047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x0000001824267810ULL, 0x008fe20007ffe0ffULL, 0x0000ffa27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a6a7824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a267824ULL, 0x008fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000008036c7824ULL, 0x000fe200078e00ffULL, 0x000000046a247812ULL, 0x002fe200078ec0ffULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0xfffff000266b7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0x0000002417247211ULL, 0x000fc400078fe0ffULL,
0x000140006b6b7810ULL, 0x000fc60007ffe0ffULL, 0x0000000103257824ULL, 0x100fe400078e0224ULL,
0x0000000102267824ULL, 0x000fc600078e0224ULL, 0xfffffff86c247812ULL, 0x000fe400078ee225ULL,
0xfffffff827267812ULL, 0x000fc600078ee226ULL, 0x0000001024707824ULL, 0x100fe400078e026bULL,
0x0000001026267824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002624783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x086fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0000001021747824ULL, 0x000fe200078e0200ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x00000018ff7d7819ULL, 0x010fe2000001147bULL,
0x000100007b837824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001147aULL,
0x00000018ff6c7819ULL, 0x000fe20000011479ULL, 0x0000007d00857306ULL, 0x0009e20000200c00ULL,
0x00000018ff217819ULL, 0x000fe20000011478ULL, 0x0000010074887824ULL, 0x008fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011474ULL, 0x00000100768e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011476ULL, 0x00000018ff827819ULL, 0x000fe20000011477ULL,
0x0000006d00847306ULL, 0x0007e20000200c00ULL, 0x00000100797d7824ULL, 0x010fe200078e00ffULL,
0x0000888074877816ULL, 0x040fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc40000011475ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000006c00807306ULL, 0x0009e20000200c00ULL, 0x00008880796d7816ULL, 0x008fe400000000ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000888075897816ULL, 0x000fe200000000ffULL, 0x00000021007c7306ULL, 0x0007e20000200c00ULL,
0x00000100786c7824ULL, 0x010fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001148eULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000007e008a7306ULL, 0x000fe20000200c00ULL, 0x0000888078217816ULL, 0x048fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x0000007d007e7306ULL, 0x0007300000200c00ULL,
0x0000008100907306ULL, 0x0005e20000200c00ULL, 0x000088807b7d7816ULL, 0x008fce00000000ffULL,
0x0000008200927306ULL, 0x0007e20000200c00ULL, 0x000088807a817816ULL, 0x004fe400000000ffULL,
0x000054106d6d7816ULL, 0x010fe2000000007eULL, 0x00000100777e7824ULL, 0x000fc800078e00ffULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x000001007a827824ULL, 0x048fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fce000001147aULL, 0x0000007f008c7306ULL, 0x0007f00000200c00ULL,
0x00000074008b7306ULL, 0x0008620000200c00ULL, 0x00010000797f7824ULL, 0x008fe200078e00ffULL,
0x00005410216c7816ULL, 0x004fc8000000006cULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007800797306ULL, 0x0004e20000200c00ULL, 0x0000888077747816ULL, 0x050fe200000000ffULL,
0x0001000077777824ULL, 0x000fe200078e00ffULL, 0x0000006c7064723cULL, 0x082f660000001864ULL,
0x000000ffff217224ULL, 0x000fe200078e0074ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000008300867306ULL, 0x0003220000200c00ULL, 0x000001007b787824ULL, 0x004fe200078e00ffULL,
0x000054108b8a7816ULL, 0x000fe2000000008aULL, 0x0000006c2444723cULL, 0x000f660000001844ULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000007a007b7306ULL, 0x0005220000200c00ULL,
0x0000888076837816ULL, 0x042fe200000000ffULL, 0x0001000076767824ULL, 0x000fe200078e00ffULL,
0x0000541079747816ULL, 0x008fc8000000007cULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x00000083008f7306ULL, 0x000fe20000200c00ULL, 0x00000100757a7824ULL, 0x044fe200078e00ffULL,
0x0000541086857816ULL, 0x010fe20000000085ULL, 0x0001000075757824ULL, 0x000fc600078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000008e008e7306ULL, 0x000e620000200c00ULL, 0x000054107b847816ULL, 0x000fce0000000084ULL,
0x0000007600917306ULL, 0x000ea20000200c00ULL, 0x000000847058723cULL, 0x080f6e0000001858ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108f8e7816ULL, 0x002fe2000000008eULL,
0x000000842438723cULL, 0x000f6c0000001838ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541091907816ULL, 0x004fce0000000090ULL, 0x0000008200827306ULL, 0x000e700000200c00ULL,
0x0000007d007d7306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000541081827816ULL, 0x002fce0000000082ULL, 0x0000008700877306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x000054107d837816ULL, 0x004fe20000000078ULL,
0x000000101f787824ULL, 0x000fcc00078e0200ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00000082705c723cULL, 0x080f6e000000185cULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000541087887816ULL, 0x002fe20000000088ULL, 0x00000082243c723cULL, 0x000f6c000000183cULL,
0x00000075008d7306ULL, 0x0002f00000200c00ULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x000054107f757816ULL, 0x002fc40000000080ULL, 0x0000541089897816ULL, 0x004fca000000007aULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x000054108d8b7816ULL, 0x008fe2000000008cULL,
0x000000747060723cULL, 0x040f6c0000001860ULL, 0x0000007700777306ULL, 0x000ea40000200c00ULL,
0x000000887054723cULL, 0x000f620000001854ULL, 0x00005410218f7816ULL, 0x002fce000000007eULL,
0x0000008a7050723cULL, 0x000f620000001850ULL, 0x0000541077917816ULL, 0x004fce0000000092ULL,
0x0000008e704c723cULL, 0x040f70000000184cULL, 0x000000907048723cULL, 0x000b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e026bULL, 0x000000742440723cULL, 0x000f620000001840ULL,
0x000000101e6b7824ULL, 0x000fc800078e026bULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x000000882434723cULL, 0x040f700000001834ULL, 0x0000008a2430723cULL, 0x040f700000001830ULL,
0x0000008e242c723cULL, 0x040f70000000182cULL, 0x000000902428723cULL, 0x000b640000001828ULL,
0x000000006b24783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707232ULL, 0x082fe40000000000ULL,
0x0000000772727232ULL, 0x000fc40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fe40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000001020747824ULL, 0x000fcc00078e0200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x00000018ff207819ULL, 0x010fe40000011478ULL,
0x00000018ff217819ULL, 0x000fe40000011479ULL, 0x00000020006c7306ULL, 0x0009e20000200c00ULL,
0x00000018ff6b7819ULL, 0x004fe4000001147aULL, 0x00000018ff7c7819ULL, 0x000fe20000011474ULL,
0x0000010074867824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001147bULL,
0x00000100768c7824ULL, 0x000fe200078e00ffULL, 0x000088807b817816ULL, 0x000fe200000000ffULL,
0x00000021007d7306ULL, 0x0005e20000200c00ULL, 0x0000888078207816ULL, 0x010fc400000000ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011476ULL, 0x00000018ff807819ULL, 0x000fe40000011477ULL,
0x0000888074857816ULL, 0x000fe200000000ffULL, 0x0000006b00827306ULL, 0x0009e20000200c00ULL,
0x0000010078217824ULL, 0x044fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011475ULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x0000888075877816ULL, 0x000fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x00008880768b7816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00000100796b7824ULL, 0x010fe200078e00ffULL, 0x0000007c00887306ULL, 0x0005e20000200c00ULL,
0x00000018ff747819ULL, 0x000fc40000011474ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x0000006d00837306ULL, 0x0009e20000200c00ULL, 0x00000018ff7c7819ULL, 0x004fe4000001146bULL,
0x00000018ff767819ULL, 0x000fca0000011476ULL, 0x00000078006b7306ULL, 0x0004e20000200c00ULL,
0x00008880796d7816ULL, 0x050fe200000000ffULL, 0x0001000079797824ULL, 0x000fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000007f008e7306ULL, 0x0009e20000200c00ULL,
0x000001007b787824ULL, 0x044fe400078e00ffULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000008000907306ULL, 0x0005e20000200c00ULL, 0x000088807a7f7816ULL, 0x010fe400000000ffULL,
0x000054106b6c7816ULL, 0x008fca000000006cULL, 0x0000007b00847306ULL, 0x0007220000200c00ULL,
0x000001007a807824ULL, 0x044fe400078e00ffULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x00010000757b7824ULL, 0x008fe200078e00ffULL, 0x0000007e00897306ULL, 0x000fe80000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000541084837816ULL, 0x010fc40000000083ULL,
0x00000079007e7306ULL, 0x000ff00000200c00ULL, 0x0000007a00797306ULL, 0x0004f00000200c00ULL,
0x0000007b008a7306ULL, 0x0008620000200c00ULL, 0x00000100757a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007400757306ULL, 0x0004620000200c00ULL,
0x00000100777b7824ULL, 0x010fe200078e00ffULL, 0x0000541079827816ULL, 0x008fc80000000082ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x0000888077747816ULL, 0x044fe200000000ffULL, 0x0001000077777824ULL, 0x000fe200078e00ffULL,
0x000054108a897816ULL, 0x002fe20000000089ULL, 0x000000827058723cULL, 0x000f660000001858ULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x0000541075887816ULL, 0x000fc60000000088ULL, 0x000000822438723cULL, 0x000f680000001838ULL,
0x0000006d006d7306ULL, 0x000fe80000200c00ULL, 0x000000887050723cULL, 0x000f680000001850ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541020207816ULL, 0x002fc60000000021ULL,
0x000000882430723cULL, 0x000f680000001830ULL, 0x00000076008f7306ULL, 0x000e700000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054106d217816ULL, 0x004fc4000000007cULL,
0x000054107e6d7816ULL, 0x000fca000000007dULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x000054108f8e7816ULL, 0x002fe2000000008eULL, 0x0000006c7060723cULL, 0x040f6c0000001860ULL,
0x0000008100817306ULL, 0x000fe40000200c00ULL, 0x000000207064723cULL, 0x080f6c0000001864ULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x000054107f807816ULL, 0x004fe20000000080ULL,
0x000000202444723cULL, 0x040b6c0000001844ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0xfffffff86a207812ULL, 0x020fe200078ec0ffULL, 0x0000006c2440723cULL, 0x000f6c0000001840ULL,
0x0000008600867306ULL, 0x000ea20000200c00ULL, 0x0000541081817816ULL, 0x002fce0000000078ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x00000080705c723cULL, 0x080f6e000000185cULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541085867816ULL, 0x004fe20000000086ULL,
0x00000080243c723cULL, 0x000f6c000000183cULL, 0x0000008b008b7306ULL, 0x000ff00000200c00ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x0000541087877816ULL, 0x002fce000000007aULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000000867054723cULL, 0x080f6e0000001854ULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x000054108b8c7816ULL, 0x004fe2000000008cULL,
0x000000862434723cULL, 0x000f6c0000001834ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x00005410748d7816ULL, 0x002fce000000007bULL, 0x0000008c704c723cULL, 0x000f62000000184cULL,
0x00005410778f7816ULL, 0x004fce0000000090ULL, 0x0000008e7048723cULL, 0x000f700000001848ULL,
0x0000008c242c723cULL, 0x040f70000000182cULL, 0x0000008e2428723cULL, 0x000b6e0000001828ULL,
0x0001a6c813267811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000026267f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980020ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000000207805ULL, 0x004fc80000015200ULL, 0x000004000d257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc40007804827ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024206b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e21ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011425ULL,
0x0000006b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000224247819ULL, 0x000fc80000001225ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f207810ULL, 0x000fc80007ffe0ffULL, 0x000000152000720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x000000020f207810ULL, 0x000fe40007ffe0ffULL,
0x000001000c217810ULL, 0x000fe40007ffe0ffULL, 0x000000152000720cULL, 0x000fc60003f06070ULL,
0x00006800126c7a24ULL, 0x000fd400078e0221ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000021160c7217ULL, 0x000fe20007800000ULL, 0x0000001011277824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x000fc60000011617ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a21ULL,
0x00000004256b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127207824ULL, 0x000fe200078e0225ULL,
0x0000000825717810ULL, 0x000fe40007ffe0ffULL, 0x0000000c270c7217ULL, 0x000fe20007800000ULL,
0x0000000120217824ULL, 0x040fe200078e0217ULL, 0x0000000c25737810ULL, 0x000fe20007ffe0ffULL,
0x0000000820247824ULL, 0x000fe400078e00ffULL, 0x0000000127707824ULL, 0x000fc400078e026bULL,
0x0000000120207824ULL, 0x100fe200078e026cULL, 0xfffffff8246d7812ULL, 0x000fe200078ee221ULL,
0x000000010c0c7824ULL, 0x000fe400078e0a27ULL, 0x0000000170247824ULL, 0x000fe400078e026cULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000c2500720cULL, 0x080fe40003f06070ULL,
0x0000000c7100720cULL, 0x080fe20003f66070ULL, 0x0000000127727824ULL, 0x000fe200078e0271ULL,
0x0000000b206a7212ULL, 0x000fe200078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000000c6b00720cULL, 0x000fc40003f86070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000172267824ULL, 0x100fe200078e026cULL, 0x0000000b24247212ULL, 0x080fe200078efcffULL,
0x0000000127747824ULL, 0x000fe200078e0273ULL, 0x00006500216b7a10ULL, 0x000fe20002ffe4ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640024247a10ULL, 0x000fe40007fde0ffULL,
0x0000000c7300720cULL, 0x000fe20003fa6070ULL, 0x0000000174207824ULL, 0x000fe200078e026cULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x00000001706c7824ULL, 0x040fe200078e0217ULL,
0x0000650025257a10ULL, 0x000fe200037fe4ffULL, 0x0000000870717824ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee26cULL, 0x00000001720c7824ULL, 0x100fe200078e0217ULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x0000000872737824ULL, 0x000fe200078e00ffULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x00000001746c7824ULL, 0x000fe200078e0217ULL,
0x0000640020207a10ULL, 0x000fe20007fde0ffULL, 0x0000000874757824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee20cULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x0000650021217a10ULL, 0x000fe200037fe4ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff875757812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a6d7faeULL, 0x0003e6000c101c46ULL,
0x0000001075757824ULL, 0x000fe200078e0200ULL, 0x0000000024717faeULL, 0x0003e8000e101c46ULL,
0x0000000026737faeULL, 0x0003e8000d901c46ULL, 0x0000000020757faeULL, 0x0003e2000e901c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010110c7824ULL, 0x000fca00078e00ffULL,
0x0000000c170c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c247810ULL, 0x040fe20007ffe0ffULL,
0x000000010c207824ULL, 0x140fe200078e0217ULL, 0x000000080c267810ULL, 0x040fe20007ffe0ffULL,
0x000000080c6d7824ULL, 0x000fe400078e00ffULL, 0x0000000124217824ULL, 0x140fe400078e0217ULL,
0x00000008246a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL,
0x000000010c207824ULL, 0x040fe200078e026cULL, 0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126257824ULL, 0x000fe200078e0217ULL, 0xfffffff86a717812ULL, 0x000fe200078ee221ULL,
0x0000000826707824ULL, 0x000fc400078e00ffULL, 0x0000000124247824ULL, 0x000fe400078e026cULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff870737812ULL, 0x000fc600078ee225ULL,
0x0000000126267824ULL, 0x100fe200078e026cULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x000000010c6a7824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000640020207a10ULL, 0x000fc60007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000b24247212ULL, 0x080fe400078efcffULL, 0x0000650021217a10ULL, 0x000fe200007fe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000640024247a10ULL, 0x000fe20007f7e0ffULL, 0x000000010c6c7824ULL, 0x000fe200078e0217ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000080c757824ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff875757812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x0000650025257a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000206d7faeULL, 0x0003e2000b901c46ULL, 0x0000650027277a10ULL, 0x000fe200007fe4ffULL,
0x0000001075757824ULL, 0x000fe200078e0200ULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000024717faeULL, 0x0003e8000b901c46ULL, 0x0000000026737faeULL, 0x0003e8000b901c46ULL,
0x000000006a757faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000814217812ULL, 0x000fe200078ec0ffULL, 0x00000020100c7824ULL, 0x000fc400078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x00000001210c7824ULL, 0x000fe200078e020cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a668000c267f8cULL, 0x000664000c80043fULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x01a66c000c257984ULL, 0x000f240000000800ULL, 0x8000000025ff7812ULL, 0x012fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024206b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e21ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011425ULL,
0x0000006b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a66c000c257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018010087811ULL, 0x000fc800078e38ffULL, 0x000000080a087210ULL, 0x000fca0007ffe00bULL,
0x01a00000080c7984ULL, 0x008e680000000800ULL, 0x01a2000008207984ULL, 0x0006a20000000800ULL,
0x000000230c00720bULL, 0x002fe20003f1d000ULL, 0x0000e0827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x008fc800000e0100ULL, 0x000000ff2100720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e0023ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000310257810ULL, 0x000fe40007ffe0ffULL, 0x000000230c00720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x0000e0427f007947ULL, 0x000fd4000b800000ULL,
0x00000000006c7806ULL, 0x004fc400018e0100ULL, 0x000000801a0b8824ULL, 0x000fe200078e020bULL,
0x000000230c087209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a0b8824ULL, 0x000fca00078e020bULL, 0x01a400080b008388ULL, 0x0003e20000000800ULL,
0x000000ff6c00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x00000023080a7221ULL, 0x002fe20000010100ULL, 0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00277308ULL, 0x000e640000000800ULL, 0x0000002722227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000df927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002a400000e0000ULL,
0x0000002664647220ULL, 0x084fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000de727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000dd527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000dc427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c21ff7212ULL, 0x000fda00078030ffULL,
0x0000000c080c0221ULL, 0x000fe20000010100ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL, 0x0000000c00090308ULL, 0x000e640000000800ULL,
0x0000000920200220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002220227221ULL, 0x004fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0xfffffff014267812ULL, 0x000fca00078ec0ffULL, 0x01a6b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000200a237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e0bULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011421ULL, 0x000000230c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x000000020c0c7819ULL, 0x000fc80000001221ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910240a7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff0a7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000d8327f007947ULL, 0x000fea000b800000ULL, 0x00001f0a27077589ULL, 0x0002a400000e0000ULL,
0x000000080a267810ULL, 0x000fe20007ffe0ffULL, 0x0000d8727f007947ULL, 0x000fea000b800000ULL,
0x000000100a047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000180a267810ULL, 0x008fe20007ffe0ffULL,
0x0000d8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001130a7812ULL, 0x002fe200078ec0ffULL,
0x0000000803207824ULL, 0x000fe200078e00ffULL, 0x00000004ff0b7819ULL, 0x000fe20000011617ULL,
0x0000000802217824ULL, 0x000fe200078e00ffULL, 0x0000100000007810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x000000040a0a7824ULL, 0x000fc400078e020bULL, 0x000000101c707824ULL, 0x000fe400078e0200ULL,
0x00000001030b7824ULL, 0x100fe400078e020aULL, 0x00000001020c7824ULL, 0x000fc600078e020aULL,
0xfffffff8200a7812ULL, 0x000fe200078ee20bULL, 0x000000041a207824ULL, 0x000fe200078e00ffULL,
0x00015000100b7811ULL, 0x000fe400078e60ffULL, 0xfffffff8210c7812ULL, 0x000fe400078ee20cULL,
0x0000000420207812ULL, 0x000fe200078ec0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e020bULL,
0x000000100c0c7824ULL, 0x000fe200078e020bULL, 0x00000002201c7812ULL, 0x000fc400078efcffULL,
0x000000000a68783bULL, 0x0002e80000000200ULL, 0x000000000c24783bULL, 0x0082e20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687232ULL, 0x084fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fe40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001c170a7211ULL, 0x002fe200078fe0ffULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e020bULL,
0x0000083000007945ULL, 0x000fe20003800000ULL, 0x0000000103037824ULL, 0x000fca00078e020aULL,
0xfffffff80c037812ULL, 0x000fca00078ee203ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000374783bULL, 0x0008e20000004200ULL, 0x00000018ff207819ULL, 0x002fe20000011471ULL,
0x00010000737d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe40000011470ULL,
0x0000002000787306ULL, 0x0003e20000200c00ULL, 0x0000888070037816ULL, 0x010fe400000000ffULL,
0x00000018ff237819ULL, 0x000fe40000011473ULL, 0x00000018ff217819ULL, 0x000fc40000011472ULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000000c001c7306ULL, 0x0009e20000200c00ULL,
0x0000888071207816ULL, 0x002fe400000000ffULL, 0x00000018ff6c7819ULL, 0x008fe20000011474ULL,
0x0000010074817824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011475ULL,
0x00000100700c7824ULL, 0x050fe400078e00ffULL, 0x0000006c00847306ULL, 0x000fe20000200c00ULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fc40000011476ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000020006c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe40000011477ULL,
0x0000888077897816ULL, 0x000fe400000000ffULL, 0x00000018ff817819ULL, 0x000fc60000011481ULL,
0x00000023007f7306ULL, 0x000fe20000200c00ULL, 0x0000010072207824ULL, 0x002fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000007000237306ULL, 0x0003f00000200c00ULL,
0x0000007900857306ULL, 0x0007e20000200c00ULL, 0x0000010073707824ULL, 0x002fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007a008a7306ULL, 0x000fe20000200c00ULL,
0x0000888072797816ULL, 0x048fe200000000ffULL, 0x0001000072727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x00000020007a7306ULL, 0x0003f00000200c00ULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x0000888074207816ULL, 0x042fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000000c000c7306ULL, 0x000ff00000200c00ULL, 0x0000007b008b7306ULL, 0x0003f00000200c00ULL,
0x00000070007e7306ULL, 0x0007e20000200c00ULL, 0x00008880737b7816ULL, 0x002fce00000000ffULL,
0x0000007200737306ULL, 0x0003e20000200c00ULL, 0x0000888075707816ULL, 0x008fce00000000ffULL,
0x0000002000827306ULL, 0x0007e20000200c00ULL, 0x0000010075727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000021007c7306ULL, 0x0003220000200c00ULL,
0x0001000075207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000007400757306ULL, 0x0006a20000200c00ULL, 0x0000010071217824ULL, 0x042fe400078e00ffULL,
0x0001000071717824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000007d00807306ULL, 0x0003e20000200c00ULL, 0x0000010077747824ULL, 0x048fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0001000077777824ULL, 0x000fe200078e00ffULL,
0x00005410737c7816ULL, 0x010fe4000000007cULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000007000837306ULL, 0x0007e20000200c00ULL, 0x00008880767d7816ULL, 0x002fc400000000ffULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x0000541075847816ULL, 0x004fc60000000084ULL,
0x0000002000867306ULL, 0x0002a20000200c00ULL, 0x0000010076707824ULL, 0x048fe400078e00ffULL,
0x0001000076767824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000002100217306ULL, 0x000ee20000200c00ULL,
0x0000541003207816ULL, 0x002fe4000000000cULL, 0x0000541086857816ULL, 0x004fca0000000085ULL,
0x0000007100717306ULL, 0x000e640000200c00ULL, 0x000000846850723cULL, 0x080f6c0000001850ULL,
0x0000007900797306ULL, 0x000ea20000200c00ULL, 0x000054106c217816ULL, 0x008fe20000000021ULL,
0x000000842430723cULL, 0x000f6c0000001830ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x0000541071717816ULL, 0x002fe20000000078ULL, 0x000000206864723cULL, 0x080f6c0000001864ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x00005410797a7816ULL, 0x004fe2000000007aULL,
0x000000202444723cULL, 0x000f6c0000001844ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054107b7b7816ULL, 0x008fce000000007eULL, 0x0000007d00877306ULL, 0x0007e20000200c00ULL,
0x0000541082827816ULL, 0x002fe20000000081ULL, 0x0000007a685c723cULL, 0x080f6c000000185cULL,
0x0000007000887306ULL, 0x0003220000200c00ULL, 0x00005410807d7816ULL, 0x008fe2000000007fULL,
0x0000007a243c723cULL, 0x000f62000000183cULL, 0x0000541083837816ULL, 0x004fca0000000072ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541023707816ULL, 0x002fe2000000001cULL,
0x0000007c6858723cULL, 0x040f6c0000001858ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000541087887816ULL, 0x010fe20000000088ULL, 0x000000706860723cULL, 0x040f6c0000001860ULL,
0x0000007600037306ULL, 0x000ea40000200c00ULL, 0x000000826854723cULL, 0x000f6c0000001854ULL,
0x00000077000c7306ULL, 0x000ee20000200c00ULL, 0x0000541089897816ULL, 0x002fe20000000074ULL,
0x000000702440723cULL, 0x000f620000001840ULL, 0x00005410038a7816ULL, 0x004fe2000000008aULL,
0x000000101d037824ULL, 0x000fcc00078e020bULL, 0x00000088684c723cULL, 0x000f62000000184cULL,
0x000054100c8b7816ULL, 0x008fce000000008bULL, 0x0000007c2438723cULL, 0x000f700000001838ULL,
0x0000008a6848723cULL, 0x000b6e0000001848ULL, 0x000000101f687824ULL, 0x020fe200078e0200ULL,
0x000000822434723cULL, 0x040f620000001834ULL, 0x000000001e1c783bULL, 0x000e6e0000000200ULL,
0x00000088242c723cULL, 0x040f70000000182cULL, 0x0000008a2428723cULL, 0x000b640000001828ULL,
0x000000000324783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000724247232ULL, 0x088fe40000000000ULL,
0x0000000726267232ULL, 0x000fc40000000000ULL, 0x0000000625257232ULL, 0x080fe40000000000ULL,
0x0000000627277232ULL, 0x000fe40000000000ULL, 0x000000051c1c7232ULL, 0x082fe40000000000ULL,
0x000000051e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000802037824ULL, 0x044fe200078e00ffULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000000102027824ULL, 0x000fca00078e020aULL, 0xfffffff803037812ULL, 0x000fca00078ee202ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x000f220000004200ULL,
0x00000018ff027819ULL, 0x004fe20000011469ULL, 0x000001006a747824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001146aULL, 0x0000000200237306ULL, 0x0005e20000200c00ULL,
0x00000018ff007819ULL, 0x000fe40000011468ULL, 0x00000018ff0c7819ULL, 0x000fe4000001146bULL,
0x00000018ff747819ULL, 0x000fc60000011474ULL, 0x0000000b00767306ULL, 0x0007e20000200c00ULL,
0x0000010068027824ULL, 0x004fe200078e00ffULL, 0x00000018ff037819ULL, 0x010fe20000011471ULL,
0x0000010070797824ULL, 0x000fc600078e00ffULL, 0x00000018ff027819ULL, 0x000fe20000011402ULL,
0x0000010072807824ULL, 0x040fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011470ULL,
0x00000100690b7824ULL, 0x008fe200078e00ffULL, 0x00000000000a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011472ULL, 0x00000018ff6c7819ULL, 0x000fe40000011473ULL,
0x00008880727f7816ULL, 0x040fe200000000ffULL, 0x0001000072727824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000000c00787306ULL, 0x0007e20000200c00ULL,
0x0000888068007816ULL, 0x044fe200000000ffULL, 0x0001000068687824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc40000011480ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000003007d7306ULL, 0x000fe20000200c00ULL,
0x00008880690c7816ULL, 0x048fe200000000ffULL, 0x0001000069697824ULL, 0x000fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000000200037306ULL, 0x0005f00000200c00ULL,
0x00000020007c7306ULL, 0x0007e20000200c00ULL, 0x000088806a027816ULL, 0x044fe200000000ffULL,
0x000100006a6a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000002100827306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x008fce000001140bULL,
0x0000000000007306ULL, 0x000ff00000200c00ULL, 0x0000000200757306ULL, 0x0005f00000200c00ULL,
0x0000000c000c7306ULL, 0x000fe20000200c00ULL, 0x0000888070027816ULL, 0x044fe200000000ffULL,
0x0001000070707824ULL, 0x000fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000002000217306ULL, 0x0005f00000200c00ULL, 0x0000006c00847306ULL, 0x000fe20000200c00ULL,
0x000088806b207816ULL, 0x004fce00000000ffULL, 0x00000002007a7306ULL, 0x0005f00000200c00ULL,
0x00000069006c7306ULL, 0x000fe20000200c00ULL, 0x0001000071027824ULL, 0x004fca00078e00ffULL,
0x00000018ff027819ULL, 0x000fe40000011402ULL, 0x0000006a00697306ULL, 0x0004f00000200c00ULL,
0x00000068000b7306ULL, 0x0008620000200c00ULL, 0x00000100716a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000002007e7306ULL, 0x0004620000200c00ULL,
0x000001006b687824ULL, 0x010fe200078e00ffULL, 0x0000541069767816ULL, 0x008fe20000000076ULL,
0x000100006b6b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000006a007b7306ULL, 0x0007e20000200c00ULL, 0x0000541000027816ULL, 0x004fe40000000003ULL,
0x000054100c037816ULL, 0x000fe20000000021ULL, 0x00000100730c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x000054100b0a7816ULL, 0x002fe2000000000aULL,
0x0000006800777306ULL, 0x0003e20000200c00ULL, 0x00008880736a7816ULL, 0x048fe200000000ffULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x000000022464723cULL, 0x000b620000001864ULL, 0x000054106c0b7816ULL, 0x000fe20000000023ULL,
0x000000ffff007224ULL, 0x000fe200078e006aULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x0000888071687816ULL, 0x002fc400000000ffULL,
0x000054107e7d7816ULL, 0x000fe2000000007dULL, 0x0000000a2460723cULL, 0x000b680000001860ULL,
0x0000002000207306ULL, 0x000e680000200c00ULL, 0x000000021c44723cULL, 0x000b680000001844ULL,
0x0000007200837306ULL, 0x000ee20000200c00ULL, 0x0000541075747816ULL, 0x004fc60000000074ULL,
0x0000000a1c40723cULL, 0x000b680000001840ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x0000541020757816ULL, 0x002fce0000000077ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x0000541083827816ULL, 0x008fe20000000082ULL, 0x00000074245c723cULL, 0x080b6c000000185cULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x000054106b777816ULL, 0x004fe20000000078ULL,
0x000000741c3c723cULL, 0x000b6c000000183cULL, 0x0000007000717306ULL, 0x000ea20000200c00ULL,
0x000054107a7a7816ULL, 0x002fe20000000079ULL, 0x000000762458723cULL, 0x080b6c0000001858ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x00005410687b7816ULL, 0x008fe2000000007bULL,
0x000000761c38723cULL, 0x000b6c0000001838ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x00005410717c7816ULL, 0x004fe2000000007cULL, 0x0000007a2454723cULL, 0x040b6c0000001854ULL,
0x0000000000007306ULL, 0x000fe40000200c00ULL, 0x0000007c2450723cULL, 0x000b6c0000001850ULL,
0x0000000c00817306ULL, 0x000ea20000200c00ULL, 0x000054107f807816ULL, 0x002fe20000000080ULL,
0x0000007a1c34723cULL, 0x040b6c0000001834ULL, 0x0000007300737306ULL, 0x000e640000200c00ULL,
0x0000007c1c30723cULL, 0x000b620000001830ULL, 0x0000541000817816ULL, 0x004fce0000000081ULL,
0x00000080244c723cULL, 0x000b62000000184cULL, 0x0000541073837816ULL, 0x002fce0000000084ULL,
0x000000822448723cULL, 0x000b700000001848ULL, 0x000000801c2c723cULL, 0x040b70000000182cULL,
0x000000821c28723cULL, 0x000b620000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000d027f8cULL, 0x0202a2000c80043fULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0001a6a0100a7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0003ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff514000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff237224ULL, 0x000fe400078e002bULL,
0x000000ffff247224ULL, 0x000fe400078e002aULL, 0x000000ffff217224ULL, 0x000fe400078e002fULL,
0x000000ffff207224ULL, 0x000fc400078e002eULL, 0x000000ffff1f7224ULL, 0x000fe400078e0033ULL,
0x000000ffff147224ULL, 0x000fe400078e0032ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cb9000047802ULL, 0x000fc40000000f00ULL,
0x0000c92000007944ULL, 0x00efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002200037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000022ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000087919ULL, 0x000ee80000000000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000001808057811ULL, 0x048fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x004fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x010fca0000410000ULL, 0x00001f0706007589ULL, 0x000ea800000e0000ULL,
0x00001f0506057589ULL, 0x000ee800000e0000ULL, 0x00001f0906047589ULL, 0x000f2800000e0000ULL,
0x00001f0b06027589ULL, 0x000e6200000e0000ULL, 0x0000006400647220ULL, 0x004fc40000410000ULL,
0x0000006500657220ULL, 0x040fe40000410000ULL, 0x0000006000607220ULL, 0x040fe40000410000ULL,
0x0000006100617220ULL, 0x040fe40000410000ULL, 0x0000005c005c7220ULL, 0x040fe40000410000ULL,
0x0000005d005d7220ULL, 0x040fe40000410000ULL, 0x0000005800587220ULL, 0x000fc40000410000ULL,
0x0000005900597220ULL, 0x040fe40000410000ULL, 0x0000005400547220ULL, 0x040fe40000410000ULL,
0x0000005500557220ULL, 0x040fe40000410000ULL, 0x0000005000507220ULL, 0x040fe40000410000ULL,
0x0000005100517220ULL, 0x040fe40000410000ULL, 0x0000004c004c7220ULL, 0x000fc40000410000ULL,
0x0000004d004d7220ULL, 0x040fe40000410000ULL, 0x0000004800487220ULL, 0x040fe40000410000ULL,
0x0000004900497220ULL, 0x000fe40000410000ULL, 0x0000004605467220ULL, 0x048fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004205427220ULL, 0x000fc40000410000ULL,
0x0000004305437220ULL, 0x040fe40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x040fe40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x040fe40000410000ULL, 0x0000003605367220ULL, 0x000fc40000410000ULL,
0x0000003705377220ULL, 0x040fe40000410000ULL, 0x0000001405147220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000002005207220ULL, 0x040fe40000410000ULL,
0x0000002105217220ULL, 0x040fe40000410000ULL, 0x0000002405247220ULL, 0x000fc40000410000ULL,
0x0000002305237220ULL, 0x000fe40000410000ULL, 0x0000000466667220ULL, 0x090fe40000410000ULL,
0x0000000467677220ULL, 0x080fe40000410000ULL, 0x0000000462627220ULL, 0x080fe40000410000ULL,
0x0000000463637220ULL, 0x080fe40000410000ULL, 0x000000045e5e7220ULL, 0x000fc40000410000ULL,
0x000000045f5f7220ULL, 0x080fe40000410000ULL, 0x000000045a5a7220ULL, 0x080fe40000410000ULL,
0x000000045b5b7220ULL, 0x080fe40000410000ULL, 0x0000000456567220ULL, 0x080fe40000410000ULL,
0x0000000457577220ULL, 0x080fe40000410000ULL, 0x0000000452527220ULL, 0x000fc40000410000ULL,
0x0000000453537220ULL, 0x080fe40000410000ULL, 0x000000044e4e7220ULL, 0x080fe40000410000ULL,
0x000000044f4f7220ULL, 0x080fe40000410000ULL, 0x000000044a4a7220ULL, 0x080fe40000410000ULL,
0x000000044b4b7220ULL, 0x000fe40000410000ULL, 0x0000000244447220ULL, 0x002fc40000410000ULL,
0x0000000245457220ULL, 0x080fe40000410000ULL, 0x0000000240407220ULL, 0x080fe40000410000ULL,
0x0000000241417220ULL, 0x080fe40000410000ULL, 0x000000023c3c7220ULL, 0x080fe40000410000ULL,
0x000000023d3d7220ULL, 0x080fe40000410000ULL, 0x0000000238387220ULL, 0x000fc40000410000ULL,
0x0000000239397220ULL, 0x080fe40000410000ULL, 0x0000000234347220ULL, 0x080fe40000410000ULL,
0x0000000235357220ULL, 0x080fe40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000231317220ULL, 0x080fe40000410000ULL, 0x000000022c2c7220ULL, 0x000fc40000410000ULL,
0x000000022d2d7220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000666766723eULL, 0x000fe400000000ffULL, 0x000000626333723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005e5f5e723eULL, 0x000fc400000000ffULL,
0x0000005a5b2f723eULL, 0x000fe400000000ffULL, 0x000000565756723eULL, 0x000fe400000000ffULL,
0x00000052532b723eULL, 0x000fe400000000ffULL, 0x0000004e4f4e723eULL, 0x000fe400000000ffULL,
0x0000004a4b27723eULL, 0x000fe400000000ffULL, 0x0000541066327816ULL, 0x000fc40000000033ULL,
0x0000000800037811ULL, 0x054fe200078ff0ffULL, 0x000000016f6f7824ULL, 0x100fe200078e0200ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x00000008030d7824ULL, 0x002fe200078e00ffULL, 0x0000001000097811ULL, 0x040fe400078ff0ffULL,
0x00000018000b7811ULL, 0x000fe200078ff0ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000000302047211ULL, 0x040fe200078ff8ffULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fc400078ff8ffULL, 0x0000000b02067211ULL, 0x040fe200078ff8ffULL,
0x000000080b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0xfffffff80b127812ULL, 0x000fe400078ee206ULL, 0xfffffff809087812ULL, 0x000fe200078ee202ULL,
0x0000200011027824ULL, 0x000fe200078e00ffULL, 0x0000000403067810ULL, 0x000fc40007ffe0ffULL,
0x0000000603077810ULL, 0x000fe20007ffe0ffULL, 0x000000106f6f7824ULL, 0x100fe200078e0202ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000000800057824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000100013037824ULL, 0x000fe200078e0202ULL,
0xfffffff8090a7812ULL, 0x008fe400078ee206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0f7824ULL, 0x100fe200078e0203ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000606104723eULL, 0x000fe200000000ffULL,
0x0000001010157824ULL, 0x000fe200078e0203ULL, 0x0000763266337816ULL, 0x000fe20000000033ULL,
0x0000001012177824ULL, 0x100fe200078e0203ULL, 0x000000444544723eULL, 0x000fe200000000ffULL,
0x0000001008097824ULL, 0x100fe200078e0203ULL, 0x000000484908723eULL, 0x000fe200000000ffULL,
0x000000100a0b7824ULL, 0x100fe200078e0203ULL, 0x000000404122723eULL, 0x000fe200000000ffULL,
0x000000100c0d7824ULL, 0x000fe200078e0203ULL, 0x000000646503723eULL, 0x000fe200000000ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000545505723eULL, 0x000fe200000000ffULL,
0x00000001060f7824ULL, 0x040fe200078e020fULL, 0x00005410031c7816ULL, 0x140fe20000000004ULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x00007632031d7816ULL, 0x000fe20000000004ULL,
0x0000000106177824ULL, 0x040fe200078e0217ULL, 0x0000005c5d03723eULL, 0x000fe200000000ffULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x000000585904723eULL, 0x000fe200000000ffULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x0000001c07007388ULL, 0x0003e20000000a00ULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x000000505106723eULL, 0x000fc400000000ffULL,
0x000054105e2e7816ULL, 0x140fe4000000002fULL, 0x0000003c3d3c723eULL, 0x000fe400000000ffULL,
0x00000038391e723eULL, 0x000fe400000000ffULL, 0x000076325e2f7816ULL, 0x000fe4000000002fULL,
0x0000004c4d07723eULL, 0x002fe400000000ffULL, 0x00005410031c7816ULL, 0x000fc40000000004ULL,
0x00007632031d7816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001c09007388ULL, 0x000fe20000000a00ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040b007388ULL, 0x000fe20000000a00ULL, 0x00005410562a7816ULL, 0x000fc4000000002bULL,
0x00007632562b7816ULL, 0x000fe2000000002bULL, 0x000000060d007388ULL, 0x0003e20000000a00ULL,
0x000054104e267816ULL, 0x140fe40000000027ULL, 0x000076324e277816ULL, 0x000fe20000000027ULL,
0x000000320f007388ULL, 0x0005e20000000a00ULL, 0x000054103c0e7816ULL, 0x000fe4000000001eULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x0004002e09007388ULL, 0x000fe20000000a00ULL,
0x00000030311a723eULL, 0x000fc400000000ffULL, 0x0000002c2d2c723eULL, 0x000fe200000000ffULL,
0x0004002a0b007388ULL, 0x000fe20000000a00ULL, 0x0000541044067816ULL, 0x142fe40000000022ULL,
0x0000763244077816ULL, 0x000fe20000000022ULL, 0x000400260d007388ULL, 0x000fe20000000a00ULL,
0x000076323c0f7816ULL, 0x004fe4000000001eULL, 0x000000282916723eULL, 0x000fe200000000ffULL,
0x0000000615007388ULL, 0x0003e20000000a00ULL, 0x000000464703723eULL, 0x000fc400000000ffULL,
0x000000424304723eULL, 0x000fe200000000ffULL, 0x0008000e09007388ULL, 0x0005e20000000a00ULL,
0x0000003e3f05723eULL, 0x000fe400000000ffULL, 0x000000242308723eULL, 0x000fe400000000ffULL,
0x000000ff1300720cULL, 0x000fe40003f05270ULL, 0x0000003a3b06723eULL, 0x002fe400000000ffULL,
0x000000202107723eULL, 0x000fc400000000ffULL, 0x00005410340e7816ULL, 0x144fe4000000001aULL,
0x00007632340f7816ULL, 0x000fe4000000001aULL, 0x0000541007307816ULL, 0x140fe40000000008ULL,
0x0000763207317816ULL, 0x000fe20000000008ULL, 0x0008000e0b007388ULL, 0x0003e40000000a00ULL,
0x000054102c0e7816ULL, 0x142fe40000000016ULL, 0x000076322c0f7816ULL, 0x000fca0000000016ULL,
0x0008000e0d007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000363703723eULL, 0x000fe400000000ffULL,
0x000000141f04723eULL, 0x000fe200000000ffULL, 0x0000000e17007388ULL, 0x0003e40000000a00ULL,
0x00005410050e7816ULL, 0x002fc40000000006ULL, 0x00007632050f7816ULL, 0x000fca0000000006ULL,
0x000c000e09007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fca0000000004ULL, 0x000c000e0b007388ULL, 0x000fe80000000a00ULL,
0x000c00300d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000006f047984ULL, 0x000e680000000c00ULL, 0x000400006f1c7984ULL, 0x000ea80000000c00ULL,
0x000800006f247984ULL, 0x000ee80000000c00ULL, 0x000c00006f087984ULL, 0x000f280000000c00ULL,
0x001000006f147984ULL, 0x000ee80000000c00ULL, 0x001400006f207984ULL, 0x000f280000000c00ULL,
0x001800006f287984ULL, 0x000f280000000c00ULL, 0x001c00006f2c7984ULL, 0x000f220000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff0b0b7230ULL, 0x010fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x0000001707077230ULL, 0x000fe40000000000ULL, 0x0000001606067230ULL, 0x000fe40000000000ULL,
0x0000001505057230ULL, 0x000fc40000000000ULL, 0x0000001404047230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x000000046f007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0004001c6f007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x0000002f0b0b7230ULL, 0x000fe40000000000ULL, 0x0000002e0a0a7230ULL, 0x000fe20000000000ULL,
0x000800246f007388ULL, 0x000fe20000000c00ULL, 0x0000002d09097230ULL, 0x000fc40000000000ULL,
0x0000002c08087230ULL, 0x000fca0000000000ULL, 0x000c00086f007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x000000180900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff037224ULL, 0x002fc800078e0a05ULL, 0x00005a0003037a24ULL, 0x000fc800078e02ffULL,
0x0000000305107227ULL, 0x000fc800078e0004ULL, 0x0000000119037824ULL, 0x000fc800078e0209ULL,
0x0000000310077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x00005a0004057a24ULL, 0x000fe400078e0203ULL, 0x0000000109047824ULL, 0x000fc600078e0200ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x000000070f047207ULL, 0x000fe40004000000ULL, 0x0000002000077810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe200078e021bULL,
0x00000003ff067819ULL, 0x002fe20000011607ULL, 0x00005a000c037a24ULL, 0x000fc800078e0203ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x0000000811037824ULL, 0x000fe200078e020eULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x00000040000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x0000006000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x000000070d0c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x00000080000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000a000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x000000070d0c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000c0000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000e000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x040fe200078e0206ULL,
0x000000070d007812ULL, 0x000fe200078ec0ffULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe400078e0203ULL,
0x0000000119197824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x0000000811037824ULL, 0x000fe200078e0200ULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001910007227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a00ULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fc600078e0219ULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fda0003f26070ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000100001810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f46070ULL,
0xfffffff806037812ULL, 0x000fca00078ef807ULL, 0x0000001003047824ULL, 0x000fca00078e0202ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000f007207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a00ULL,
0x0000590000007a24ULL, 0x000fe400078e021bULL, 0x00005a0002197a24ULL, 0x000fc800078e0219ULL,
0x00005a0000197a24ULL, 0x000fe200078e0219ULL, 0x0000000707007812ULL, 0x000fc800078ec0ffULL,
0x000000196e197210ULL, 0x000fe20007f1e0ffULL, 0x0000000811117824ULL, 0x000fc800078e0200ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0019027a11ULL, 0x000fc800078040ffULL,
0x00005f0019037a11ULL, 0x000fca00000f4406ULL, 0x0000001011027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006c00ff047624ULL, 0x000fe400078e00ffULL, 0x00006d00ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604637981ULL, 0x000522000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x0000001fff077424ULL, 0x002fe200078e00ffULL,
0x01a60000ff047f8cULL, 0x004e62000c80043fULL, 0x000000020e0e7824ULL, 0x000fe400078e00ffULL,
0x000000401a067824ULL, 0x000fe200078e00ffULL, 0x0000580007077a10ULL, 0x000fe20007ffe0ffULL,
0x000059000e1b7a24ULL, 0x000fc600078e021bULL, 0x00000005ff077819ULL, 0x000fe20000011607ULL,
0x000068001b147a24ULL, 0x000fe400078e0206ULL, 0x00000c7000000947ULL, 0x000fea0003800000ULL,
0x00000003ff3d7819ULL, 0x000fe40000011617ULL, 0x0000000616097217ULL, 0x000fe40007800000ULL,
0x000000043d0d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000114087824ULL, 0x000fe200078e023dULL,
0x000000083d0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109187824ULL, 0x000fe200078e0a06ULL,
0x0000000c3d117810ULL, 0x000fe20007ffe0ffULL, 0x000000010d097824ULL, 0x100fe200078e0217ULL,
0x000000143d237810ULL, 0x000fe20007ffe0ffULL, 0x000000080d0c7824ULL, 0x040fe200078e00ffULL,
0x000000180d00720cULL, 0x000fe20003fa6070ULL, 0x000000010f0b7824ULL, 0x000fe200078e0217ULL,
0x000000183d317810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c257812ULL, 0x000fe200078ee209ULL, 0x00000001140a7824ULL, 0x000fe200078e020dULL,
0x000000103d0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffff80e297812ULL, 0x000fc400078ee20bULL, 0x0000001c3d337810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008127812ULL, 0x100fe400078ef802ULL,
0x000000181100720cULL, 0x080fe20003f46070ULL, 0x000000010d087824ULL, 0x040fe200078e0217ULL,
0x000000700a1c7812ULL, 0x000fe200078ef802ULL, 0x000000080d2d7824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x00000001140a7824ULL, 0x000fe200078e0211ULL,
0x000064001c1c7a10ULL, 0x000fe20007f3e0ffULL, 0x00000001140e7824ULL, 0x040fe200078e0223ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x0000000114087824ULL, 0x040fe200078e020fULL,
0x0000650009137a10ULL, 0x000fe200007fe4ffULL, 0x0000000114107824ULL, 0x000fe200078e0231ULL,
0x000065000b1d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000180f00720cULL, 0x000fc40003f26070ULL, 0x000000180d00720cULL, 0x000fe20003f06070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000070081e7812ULL, 0x100fe400078ef802ULL,
0x000000203d357810ULL, 0x000fe20007ffe0ffULL, 0x00000001110c7824ULL, 0x040fe200078e0217ULL,
0x000000700a207812ULL, 0x000fe200078ef802ULL, 0x00000008112b7824ULL, 0x000fe200078e00ffULL,
0x000064001e1e7a10ULL, 0x000fe20007f7e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000640020207a10ULL, 0x000fc40007f9e0ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x00000001140d7824ULL, 0x000fe200078e020dULL, 0x000000700e0e7812ULL, 0x100fe200078ef802ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00006500091f7a10ULL, 0x000fe40001ffe4ffULL,
0x000065000b217a10ULL, 0x000fe200027fe4ffULL, 0x0000000114087824ULL, 0x000fe200078e0233ULL,
0x0000007010107812ULL, 0x000fe200078ef802ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000064000e0e7a10ULL, 0x000fc40007f9e0ffULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x000000013d0a7824ULL, 0x100fe200078e0217ULL, 0x000000700c0c7812ULL, 0x100fe200078ef802ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe400027fe4ffULL,
0x000000070a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008232f7824ULL, 0x040fe200078e00ffULL,
0x0000007008227812ULL, 0x000fe200078ef802ULL, 0x0000000123087824ULL, 0x000fe200078e0217ULL,
0x000064000c0c7a10ULL, 0x000fc40007f7e0ffULL, 0x000000183d00720cULL, 0x000fe40003f86070ULL,
0x0000650011117a10ULL, 0x000fe400037fe4ffULL, 0x0ffffff80a277812ULL, 0x000fe200078ef817ULL,
0x00000001140a7824ULL, 0x000fe200078e0235ULL, 0x0000640022227a10ULL, 0x000fe40007fde0ffULL,
0x000020001a267811ULL, 0x000fe400078e70ffULL, 0x000065000d0d7a10ULL, 0x000fc40001ffe4ffULL,
0x000000182300720cULL, 0x080fe20003f66070ULL, 0x0000001027277824ULL, 0x000fe200078e0226ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL, 0x0000001029297824ULL, 0x100fe200078e0226ULL,
0x0000650009237a10ULL, 0x000fe200037fe4ffULL, 0x000000800a087825ULL, 0x000fe200078e00ffULL,
0x000000243d377810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012277faeULL, 0x0005e2000e101c46ULL, 0x000000283d397810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0226ULL, 0x0000007008247812ULL, 0x000fe200078ef802ULL,
0x00000001140a7824ULL, 0x000fe200078e0237ULL, 0x000000183100720cULL, 0x040fe20003f86070ULL,
0x0000000131087824ULL, 0x040fe200078e0217ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x0000002c3d3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114287824ULL, 0x000fc400078e0239ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fc600078ee208ULL, 0x0000001025277824ULL, 0x004fe200078e0226ULL,
0x0000650009257a10ULL, 0x000fe200037fe4ffULL, 0x0000008028087825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x100fe400078ef802ULL, 0x000000001c277faeULL, 0x0005e2000e901c46ULL,
0x0000000133137824ULL, 0x040fe200078e0217ULL, 0x0000007008127812ULL, 0x000fe200078ef802ULL,
0x0000000833087824ULL, 0x040fe200078e00ffULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000001e297faeULL, 0x0007e2000c901c46ULL, 0x000000183300720cULL, 0x080fe20003fa6070ULL,
0x0000000835287824ULL, 0x000fe200078e00ffULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000202b7faeULL, 0x0003e2000d101c46ULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0226ULL, 0xfffffff808337812ULL, 0x000fe200078ee213ULL,
0x0000000114087824ULL, 0x000fe200078e023bULL, 0x0000650009137a10ULL, 0x000fe200037fe4ffULL,
0x00000001351d7824ULL, 0x104fe200078e0217ULL, 0x000000183700720cULL, 0x080fe20003f46070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000303d277810ULL, 0x000fe20007ffe0ffULL,
0x000000000c2d7faeULL, 0x0005e2000c101c46ULL, 0x000000183500720cULL, 0x000fe20003f26070ULL,
0x000000102f2f7824ULL, 0x000fe200078e0226ULL, 0x00000070081c7812ULL, 0x000fe200078ef802ULL,
0x0000000137087824ULL, 0x040fe200078e0217ULL, 0xfffffff8281f7812ULL, 0x008fe200078ee21dULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe200078e0226ULL, 0x000000343d297810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e0226ULL, 0xfffffff837217812ULL, 0x002fe200078ee208ULL,
0x0000000114087824ULL, 0x000fe200078e0227ULL, 0x00006500091d7a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0226ULL, 0x000000000e2f7faeULL, 0x0003e2000d901c46ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000383d2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000010317faeULL, 0x0007e2000e101c46ULL, 0x0000001021217824ULL, 0x000fe200078e0226ULL,
0x00000070080c7812ULL, 0x004fe200078ef802ULL, 0x00000001390d7824ULL, 0x100fe200078e0217ULL,
0x0000000022337faeULL, 0x0005e2000e901c46ULL, 0x000000013b087824ULL, 0x000fe200078e0217ULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x00000001140e7824ULL, 0x002fe200078e0229ULL,
0x00000000241f7faeULL, 0x0003e2000c901c46ULL, 0x0000003c3d2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000839107824ULL, 0x008fc400078e00ffULL, 0x000000000a217faeULL, 0x0007e2000d101c46ULL,
0x000000183900720cULL, 0x080fe40003fa6070ULL, 0x000000182900720cULL, 0x080fe20003f46070ULL,
0x000000082b237824ULL, 0x004fe200078e00ffULL, 0xfffffff810117812ULL, 0x000fe200078ee20dULL,
0x0000000827107824ULL, 0x000fe200078e00ffULL, 0x00006500090d7a10ULL, 0x000fe200037fe4ffULL,
0x000000083b1f7824ULL, 0x042fe200078e00ffULL, 0x000000183b00720cULL, 0x080fe20003f86070ULL,
0x0000000127097824ULL, 0x040fe200078e0217ULL, 0x000000182700720cULL, 0x000fe20003f66070ULL,
0x000000800e0a7825ULL, 0x008fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee208ULL,
0xfffffff810217812ULL, 0x000fe200078ee209ULL, 0x0000000129107824ULL, 0x000fe200078e0217ULL,
0x000000700a0e7812ULL, 0x100fe200078ef802ULL, 0x00000001140a7824ULL, 0x000fe200078e022bULL,
0x000000182b00720cULL, 0x080fe20003f26070ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a087825ULL, 0x000fe200078e00ffULL,
0x000000182d00720cULL, 0x000fe40003f06070ULL, 0x000065000b0f7a10ULL, 0x000fe200037fe4ffULL,
0x00000001140a7824ULL, 0x000fe200078e022dULL, 0x0000007008087812ULL, 0x000fe200078ef802ULL,
0x000000012b147824ULL, 0x000fc400078e0217ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000640008087a10ULL, 0x000fe40007fde0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee214ULL,
0x000000012d187824ULL, 0x040fe200078e0217ULL, 0x000000700a027812ULL, 0x000fe200078ef802ULL,
0x000000082d257824ULL, 0x000fe200078e00ffULL, 0xfffffff829177812ULL, 0x000fe200078ee210ULL,
0x0000001011117824ULL, 0x100fe200078e0226ULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0226ULL, 0xfffffff825257812ULL, 0x000fe200078ee218ULL,
0x0000001021217824ULL, 0x100fe200078e0226ULL, 0x00006400020a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e0226ULL, 0x0000000012117faeULL, 0x0003e2000e901c46ULL,
0x0000001023237824ULL, 0x100fe200078e0226ULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0226ULL, 0x000000001c1f7faeULL, 0x0003e8000e101c46ULL,
0x000000000c217faeULL, 0x0003e8000d901c46ULL, 0x000000000e177faeULL, 0x0003e8000d101c46ULL,
0x0000000008237faeULL, 0x0003e8000c901c46ULL, 0x000000000a257faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x00000004170b7811ULL, 0x040fe400078fe8ffULL,
0x00000008170c7811ULL, 0x000fc400078fe8ffULL, 0x0000000c170d7811ULL, 0x000fe200078fe8ffULL,
0x000000010b087824ULL, 0x100fe200078e0217ULL, 0x00000010170e7811ULL, 0x000fe200078fe8ffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x0000001417127811ULL, 0x040fe200078fe8ffULL,
0x000000010c097824ULL, 0x140fe200078e0217ULL, 0x0000001c17227811ULL, 0x000fe200078fe8ffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee208ULL,
0x000000010d0a7824ULL, 0x000fe200078e0217ULL, 0x00000018171e7811ULL, 0x000fe200078fe8ffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x000000010e087824ULL, 0x140fe200078e0217ULL, 0x0000002017247811ULL, 0x040fe200078fe8ffULL,
0x000000080e1d7824ULL, 0x000fe200078e00ffULL, 0x0000002417277811ULL, 0x000fe200078fe8ffULL,
0x0000000112097824ULL, 0x140fe200078e0217ULL, 0xfffffff813137812ULL, 0x000fe200078ee20aULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0x0000002c172d7811ULL, 0x000fe200078fe8ffULL,
0x0000000122117824ULL, 0x040fe200078e0217ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee208ULL,
0x0000000822207824ULL, 0x000fe200078e00ffULL, 0xfffffff8181d7812ULL, 0x000fe200078ee209ULL,
0x000000011e0a7824ULL, 0x040fe200078e0217ULL, 0x00000028172b7811ULL, 0x040fe200078fe8ffULL,
0x000000081e217824ULL, 0x000fe200078e00ffULL, 0xfffffff820237812ULL, 0x000fe200078ee211ULL,
0x0000000124087824ULL, 0x140fe200078e0217ULL, 0x00000030172f7811ULL, 0x000fe200078fe8ffULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20aULL,
0x0000000127097824ULL, 0x100fe200078e0217ULL, 0x0000003417317811ULL, 0x000fe200078fe8ffULL,
0x00000008272a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f267812ULL, 0x000fe200078ee208ULL,
0x000000012d117824ULL, 0x000fe200078e0217ULL, 0x0000001417087211ULL, 0x000fe200078fe8ffULL,
0x000000082d2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL,
0x000000012b0a7824ULL, 0x000fe200078e0217ULL, 0x0000001717097211ULL, 0x000fe200078fe8ffULL,
0x000000082b257824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL,
0x0000000114117824ULL, 0x040fe200078e020dULL, 0x0000003817337811ULL, 0x040fe200078fe8ffULL,
0x00000001141f7824ULL, 0x040fe200078e0212ULL, 0x0000003c17357811ULL, 0x000fe200078fe8ffULL,
0x0000000114207824ULL, 0x000fe200078e021eULL, 0xfffffff8252c7812ULL, 0x000fe200078ee20aULL,
0x000000012f0d7824ULL, 0x000fe200078e0217ULL, 0x00000007090a7812ULL, 0x000fe200078ec0ffULL,
0x000000082f1e7824ULL, 0x000fe200078e00ffULL, 0x000020001a4d7811ULL, 0x000fe200078e70ffULL,
0x0000000114327824ULL, 0x000fc400078e0231ULL, 0x0000000131127824ULL, 0x040fe400078e0217ULL,
0x0000000831317824ULL, 0x000fe400078e00ffULL, 0x00000001140b7824ULL, 0x000fe400078e020bULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x00000001140c7824ULL, 0x040fe400078e020cULL,
0x0000000114187824ULL, 0x000fe200078e020eULL, 0x0ffffff80a0e7812ULL, 0x000fe200078ef817ULL,
0x0000000114257824ULL, 0x040fe400078e0222ULL, 0x0000000114287824ULL, 0x040fe400078e0224ULL,
0x0000000114297824ULL, 0x040fe400078e0227ULL, 0x00000001142b7824ULL, 0x000fc400078e022bULL,
0x00000001142d7824ULL, 0x040fe400078e022dULL, 0x0000000114307824ULL, 0x040fe400078e022fULL,
0x0000000114347824ULL, 0x040fe400078e0233ULL, 0x0000000114367824ULL, 0x000fe200078e0235ULL,
0xfffffff81e147812ULL, 0x000fe200078ee20dULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff8311e7812ULL, 0x000fe400078ee212ULL, 0x0000007008127812ULL, 0x100fe200078ef802ULL,
0x000000101c377824ULL, 0x000fe200078e024dULL, 0x000000700a1c7812ULL, 0x000fe200078ef802ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fc40007f1e0ffULL,
0x000064001c1c7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000133227824ULL, 0x100fe400078e0217ULL,
0x0000000135177824ULL, 0x040fe400078e0217ULL, 0x0000000835247824ULL, 0x000fe400078e00ffULL,
0x0000000833337824ULL, 0x000fe400078e00ffULL, 0x0000001013357824ULL, 0x100fe200078e024dULL,
0x0000650009137a10ULL, 0x000fe200007fe4ffULL, 0x000000101e497824ULL, 0x000fe200078e024dULL,
0x000000700c1e7812ULL, 0x000fe200078ef802ULL, 0x0000008011087825ULL, 0x000fe200078e00ffULL,
0xfffffff833227812ULL, 0x000fc400078ee222ULL, 0xfffffff824247812ULL, 0x000fe200078ee217ULL,
0x000000101d397824ULL, 0x100fe200078e024dULL, 0x000065000b1d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000010213b7824ULL, 0x000fe200078e024dULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000080180a7825ULL, 0x000fe200078e00ffULL, 0x0000007008217812ULL, 0x000fc600078ef802ULL,
0x000000100e177824ULL, 0x100fe400078e024dULL, 0x000000100f317824ULL, 0x100fe400078e024dULL,
0x000000801f0e7825ULL, 0x000fe200078e00ffULL, 0x000065000d1f7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0005e4000b901c46ULL,
0x0000001010337824ULL, 0x100fe400078e024dULL, 0x00000010224b7824ULL, 0x100fe200078e024dULL,
0x000000700a227812ULL, 0x100fe200078ef802ULL, 0x0000008020107825ULL, 0x000fe200078e00ffULL,
0x0000640021207a10ULL, 0x000fe20007f1e0ffULL, 0x000000001c317faeULL, 0x0005e2000b901c46ULL,
0x0000640022227a10ULL, 0x000fe20007f3e0ffULL, 0x00000010233d7824ULL, 0x100fe200078e024dULL,
0x0000650009217a10ULL, 0x000fe200007fe4ffULL, 0x00000010263f7824ULL, 0x100fe200078e024dULL,
0x0000007010267812ULL, 0x100fe200078ef802ULL, 0x000000102a417824ULL, 0x100fe200078e024dULL,
0x000065000b237a10ULL, 0x000fe20000ffe4ffULL, 0x000000102c437824ULL, 0x100fe200078e024dULL,
0x0000640026267a10ULL, 0x000fe20007f5e0ffULL, 0x000000102e457824ULL, 0x100fe200078e024dULL,
0x000000001e337faeULL, 0x0005e2000b901c46ULL, 0x0000001014477824ULL, 0x100fe200078e024dULL,
0x0000650011277a10ULL, 0x000fe200017fe4ffULL, 0x00000010244d7824ULL, 0x000fe200078e024dULL,
0x000000700e247812ULL, 0x100fe200078ef802ULL, 0x0000008025087825ULL, 0x000fe200078e00ffULL,
0x0000000020357faeULL, 0x0005e4000b901c46ULL, 0x0000640024247a10ULL, 0x000fe20007f1e0ffULL,
0x00000080280a7825ULL, 0x000fe200078e00ffULL, 0x0000007008287812ULL, 0x100fe200078ef802ULL,
0x0000000022377faeULL, 0x0005e2000b901c46ULL, 0x000065000f257a10ULL, 0x000fe200007fe4ffULL,
0x00000080290c7825ULL, 0x000fe200078e00ffULL, 0x000000700a2a7812ULL, 0x000fc400078ef802ULL,
0x0000640028287a10ULL, 0x000fe20007f1e0ffULL, 0x000000802b0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c2c7812ULL, 0x100fe200078ef802ULL, 0x0000000024397faeULL, 0x0005e2000b901c46ULL,
0x000064002a2a7a10ULL, 0x000fe20007f3e0ffULL, 0x000000802d107825ULL, 0x000fe200078e00ffULL,
0x000000700e2e7812ULL, 0x000fe200078ef802ULL, 0x00000000263b7faeULL, 0x0005e2000b901c46ULL,
0x0000650009297a10ULL, 0x000fe200007fe4ffULL, 0x0000008030087825ULL, 0x000fe200078e00ffULL,
0x000064002c2c7a10ULL, 0x000fc40007f1e0ffULL, 0x000064002e2e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000283d7faeULL, 0x0005e2000b901c46ULL, 0x000065000b2b7a10ULL, 0x000fe20000ffe4ffULL,
0x00000080320a7825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef802ULL,
0x000065000d2d7a10ULL, 0x000fe200007fe4ffULL, 0x00000080340c7825ULL, 0x000fe200078e00ffULL,
0x000065000f2f7a10ULL, 0x000fe200017fe4ffULL, 0x000000002a3f7faeULL, 0x0005e2000b901c46ULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x00000080360e7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x100fe200078ef802ULL, 0x000000002c417faeULL, 0x0005e2000b901c46ULL,
0x000000700a0a7812ULL, 0x000fc400078ef802ULL, 0x000000700c0c7812ULL, 0x100fe200078ef802ULL,
0x000000002e437faeULL, 0x0005e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe400007fe4ffULL,
0x000000700e027812ULL, 0x000fe400078ef802ULL, 0x0000640008087a10ULL, 0x000fe20007f1e0ffULL,
0x0000000010457faeULL, 0x0005e2000b901c46ULL, 0x000064000a0a7a10ULL, 0x000fe40007f3e0ffULL,
0x000064000c0c7a10ULL, 0x000fc40007f5e0ffULL, 0x00006400020e7a10ULL, 0x000fe40007f7e0ffULL,
0x0000650009097a10ULL, 0x000fe400007fe4ffULL, 0x000065000b0b7a10ULL, 0x000fe40000ffe4ffULL,
0x000065000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x0000000008477faeULL, 0x0005e2000b901c46ULL,
0x000065000f0f7a10ULL, 0x000fc60001ffe4ffULL, 0x000000000a497faeULL, 0x0005e8000b901c46ULL,
0x000000000c4b7faeULL, 0x0005e8000b901c46ULL, 0x000000000e4d7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x006fc40000015200ULL,
0x01a60400ff0b7984ULL, 0x000e620000000800ULL, 0x0000000700027224ULL, 0x000fe400078e02ffULL,
0x0000000116007824ULL, 0x000fc400078e0a5dULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x800000000bff7812ULL, 0x002fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620002027625ULL, 0x000fe200078e0003ULL,
0x00000008ff007819ULL, 0x000fe20000011600ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000201a047824ULL, 0x002fca00078e0205ULL,
0x00000004ff057819ULL, 0x000fe40000011604ULL, 0x0000000104087810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe05097812ULL, 0x000fe400078ec0ffULL, 0x0000001f04057812ULL, 0x000fc600078ec0ffULL,
0x00000001090b7824ULL, 0x040fe400078e0208ULL, 0x00000001040a7824ULL, 0x000fe200078e0209ULL,
0x0000000809097810ULL, 0x000fe20007ffe0ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010050d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0209ULL,
0x000001f00c0b7812ULL, 0x000fe200078ee20bULL, 0x0000000104047824ULL, 0x000fe200078e0209ULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000001005097824ULL, 0x040fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x000000000b0c7984ULL, 0x000e62000000cc00ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fc400078ec0ffULL,
0x000000000a107984ULL, 0x000ea4000000cc00ULL, 0x000001f005087812ULL, 0x000fe400078ee208ULL,
0x000001f009047812ULL, 0x000fe200078ee204ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x0000001c0a007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fca00078e0013ULL,
0x000000200b007388ULL, 0x000fe8000000cc00ULL, 0x00000000080c7984ULL, 0x000e68000000cc00ULL,
0x0000000004107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002404007388ULL, 0x0003e8000000cc00ULL, 0x0000000c08007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x002fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01a60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008040d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e05ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x000e620000000000ULL,
0x0000010006177810ULL, 0x000fe20007ffe0ffULL, 0x0000000207187824ULL, 0x000fe200078e00ffULL,
0x0001a6881a627811ULL, 0x040fe200078e18ffULL, 0x3db504f363637820ULL, 0x010fe20000410000ULL,
0xffffffff5d617810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff5c7224ULL, 0x000fe200078e00ffULL,
0x000000095d607810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0x0001a6081a5e7811ULL, 0x000fc400078e28ffULL, 0x000000025c047810ULL, 0x040fe20007ffe0ffULL,
0x000001005c647824ULL, 0x000fe200078e0217ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000001655f7812ULL, 0x000fc400078e0cffULL, 0x000000150400720cULL, 0x000fe20003f06070ULL,
0x000068001b057a24ULL, 0x000fd800078e0264ULL, 0x00000ca000008947ULL, 0x004fea0003800000ULL,
0x00000003ff2b7819ULL, 0x102fe20000011614ULL, 0x0000001014097824ULL, 0x000fe200078e00ffULL,
0x0000006416077217ULL, 0x000fe20007800000ULL, 0x000000021a247824ULL, 0x000fe200078e025fULL,
0x000000042b0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000012b067824ULL, 0x140fe200078e0205ULL,
0x000000082b0d7810ULL, 0x000fe40007ffe0ffULL, 0x00000070092d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b047824ULL, 0x000fe200078e0214ULL, 0x000000102b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b237824ULL, 0x000fe200078e00ffULL, 0x000000142b217810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0a7824ULL, 0x000fe200078e00ffULL, 0x000000182b337810ULL, 0x000fe20007ffe0ffULL,
0x000000010b087824ULL, 0x000fe200078e0205ULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x0000000107047824ULL, 0x000fe200078e0a64ULL, 0x0000001c2b357810ULL, 0x000fe20007ffe0ffULL,
0x000000010d077824ULL, 0x000fe200078e0214ULL, 0x000000202b377810ULL, 0x000fe20007ffe0ffULL,
0x000000080f2f7824ULL, 0x000fe200078e00ffULL, 0x000000040b00720cULL, 0x000fe20003fa6070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffff80a277812ULL, 0x000fc400078ee207ULL,
0x0000000c2b0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002d08127212ULL, 0x080fe400078efcffULL, 0x000000040b00720cULL, 0x040fe20003f46070ULL,
0x000000010b0a7824ULL, 0x100fe200078e0214ULL, 0x0000002d06107212ULL, 0x000fe200078efcffULL,
0x000000010f067824ULL, 0x000fe200078e0214ULL, 0x0000640012127a10ULL, 0x000fe20007f3e0ffULL,
0x000000080b297824ULL, 0x040fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe20007f1e0ffULL,
0x000000010b087824ULL, 0x100fe200078e0205ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee206ULL,
0x000000010d067824ULL, 0x100fe200078e0205ULL, 0x0000650007117a10ULL, 0x000fe200007fe4ffULL,
0x00000001210c7824ULL, 0x000fe200078e0205ULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000650009137a10ULL, 0x000fc40000ffe4ffULL,
0x000000040d00720cULL, 0x080fe20003f26070ULL, 0x000000010f0a7824ULL, 0x140fe200078e0205ULL,
0x0000002d061c7212ULL, 0x080fe200078efcffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000040f00720cULL, 0x000fe40003f06070ULL, 0x000064001c1c7a10ULL, 0x000fe20007f7e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002d081e7212ULL, 0x080fe400078efcffULL,
0x00006500071d7a10ULL, 0x000fe20001ffe4ffULL, 0x00000001330e7824ULL, 0x100fe200078e0205ULL,
0x0000002d0a0a7212ULL, 0x000fe200078efcffULL, 0x0000000135067824ULL, 0x000fe200078e0205ULL,
0x000064001e1e7a10ULL, 0x000fe20007f9e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fc40007f7e0ffULL, 0x00006500091f7a10ULL, 0x000fe200027fe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000002d0c0c7212ULL, 0x080fe400078efcffULL,
0x000065000b0b7a10ULL, 0x000fe20001ffe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002d0e0e7212ULL, 0x080fe400078efcffULL, 0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL,
0x000000012b087824ULL, 0x100fe200078e0214ULL, 0x0000002d06207212ULL, 0x000fe200078efcffULL,
0x0000000137067824ULL, 0x000fe200078e0205ULL, 0x000064000e0e7a10ULL, 0x000fe20007f9e0ffULL,
0x0000000821317824ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007fde0ffULL,
0x0000000133267824ULL, 0x000fe200078e0214ULL, 0x000065000d0d7a10ULL, 0x000fc40001ffe4ffULL,
0x000065000f0f7a10ULL, 0x000fe400027fe4ffULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x0000000121087824ULL, 0x000fe200078e0214ULL, 0x000000042b00720cULL, 0x080fe40003f86070ULL,
0x000000042100720cULL, 0x000fe40003f66070ULL, 0x0000650007217a10ULL, 0x000fe200037fe4ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000200024247811ULL, 0x000fc400078e68ffULL,
0x0ffffff809097812ULL, 0x000fe400078ef814ULL, 0x000000242b397810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x000000282b3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001009257824ULL, 0x000fe200078e0224ULL, 0x0000002d06227212ULL, 0x000fe400078efcffULL,
0xfffffff831317812ULL, 0x000fe200078ee208ULL, 0x0000000139087824ULL, 0x100fe200078e0205ULL,
0x0000640022227a10ULL, 0x000fe20007fde0ffULL, 0x000000013b067824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010257faeULL, 0x0003e2000e101c46ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002c2b3d7810ULL, 0x000fc40007ffe0ffULL,
0x000000043300720cULL, 0x040fe20003f86070ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000002d08087212ULL, 0x000fc800078efcffULL, 0xfffffff833337812ULL, 0x000fe200078ee226ULL,
0x0000000837267824ULL, 0x000fe400078e00ffULL, 0x0000001023257824ULL, 0x002fe200078e0224ULL,
0x0000650007237a10ULL, 0x000fe200037fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000640008087a10ULL, 0x000fe40007fde0ffULL, 0x0000000012257faeULL, 0x0003e2000e901c46ULL,
0x0000000135117824ULL, 0x040fe200078e0214ULL, 0x0000002d06107212ULL, 0x000fe200078efcffULL,
0x0000000835067824ULL, 0x040fe200078e00ffULL, 0x000000043500720cULL, 0x000fe20003fa6070ULL,
0x000000001c277faeULL, 0x0005e2000c901c46ULL, 0x0000650009097a10ULL, 0x000fc400037fe4ffULL,
0x0000640010107a10ULL, 0x000fe40007fde0ffULL, 0xfffffff806357812ULL, 0x000fe200078ee211ULL,
0x000000013d067824ULL, 0x000fe200078e0205ULL, 0x0000650007117a10ULL, 0x000fe200037fe4ffULL,
0x0000000137137824ULL, 0x042fe200078e0214ULL, 0x000000043700720cULL, 0x000fe20003f26070ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff826277812ULL, 0x004fe200078ee213ULL,
0x0000001029257824ULL, 0x000fe200078e0224ULL, 0x0000002d06127212ULL, 0x000fe200078efcffULL,
0x0000000139067824ULL, 0x040fe400078e0214ULL, 0x0000000839297824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x000000102f1d7824ULL, 0x100fe200078e0224ULL,
0x000000302b2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000001e257faeULL, 0x0003e2000d101c46ULL,
0x0000650007137a10ULL, 0x000fe200037fe4ffULL, 0x0000001031077824ULL, 0x000fe200078e0224ULL,
0xfffffff829297812ULL, 0x000fe200078ee206ULL, 0x000000012f067824ULL, 0x000fe200078e0205ULL,
0x000000043900720cULL, 0x000fe20003f46070ULL, 0x000000000a1d7faeULL, 0x0005e2000c101c46ULL,
0x000000342b317810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fc400078e0224ULL,
0x000000000c077faeULL, 0x0007e2000d901c46ULL, 0x0000001029297824ULL, 0x100fe200078e0224ULL,
0x000000042f00720cULL, 0x080fe20003f66070ULL, 0x00000010331f7824ULL, 0x102fe200078e0224ULL,
0x000000382b337810ULL, 0x000fe20007ffe0ffULL, 0x0000001035257824ULL, 0x000fe200078e0224ULL,
0x0000003c2b2b7810ULL, 0x000fe40007ffe0ffULL, 0x000000000e1f7faeULL, 0x0003e2000e101c46ULL,
0x00000001310b7824ULL, 0x004fe200078e0205ULL, 0x000000043d00720cULL, 0x080fe20003f86070ULL,
0x000000012b1c7824ULL, 0x000fe200078e0214ULL, 0x0000000020257faeULL, 0x0005e2000e901c46ULL,
0x0000008006067825ULL, 0x008fe200078e00ffULL, 0x000000043b00720cULL, 0x000fc40003fa6070ULL,
0x0000000022277faeULL, 0x0007e2000c901c46ULL, 0x000000013b0c7824ULL, 0x040fe200078e0214ULL,
0x0000002d060a7212ULL, 0x000fe200078efcffULL, 0x000000083b0d7824ULL, 0x000fe200078e00ffULL,
0x0000000008297faeULL, 0x0009e2000d101c46ULL, 0x0000000133067824ULL, 0x100fe200078e0205ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x000000083d0f7824ULL, 0x002fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x000000082f0c7824ULL, 0x000fe200078e00ffULL,
0x000000043100720cULL, 0x080fe20003f46070ULL, 0x000000012b057824ULL, 0x000fe200078e0205ULL,
0x000000043300720cULL, 0x080fe20003f26070ULL, 0x00000008311f7824ULL, 0x000fe200078e00ffULL,
0x000000042b00720cULL, 0x000fe20003f06070ULL, 0x000000013d047824ULL, 0x000fc400078e0214ULL,
0x000000800b087825ULL, 0x010fe200078e00ffULL, 0x00006500070b7a10ULL, 0x000fe400037fe4ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee204ULL, 0x000000012f077824ULL, 0x000fe200078e0214ULL,
0x0000002d08087212ULL, 0x000fe200078efcffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff80c1d7812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000640008087a10ULL, 0x000fe40007fde0ffULL, 0x0000002d04047212ULL, 0x080fe200078efcffULL,
0x00000001310c7824ULL, 0x100fe200078e0214ULL, 0x0000002d06067212ULL, 0x000fe200078efcffULL,
0x00000001330e7824ULL, 0x000fe200078e0214ULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000000833217824ULL, 0x004fe200078e00ffULL, 0x0000640006067a10ULL, 0x000fe20007fde0ffULL,
0x000000082b237824ULL, 0x008fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL,
0x000000100d0d7824ULL, 0x000fe200078e0224ULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x000000100f0f7824ULL, 0x000fe200078e0224ULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x000000101d1d7824ULL, 0x100fe200078e0224ULL, 0x0000650007077a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x0000640004047a10ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x100fe200078e0224ULL, 0x00000000100d7faeULL, 0x0003e2000e901c46ULL,
0x0000001023237824ULL, 0x000fe200078e0224ULL, 0x0000650005057a10ULL, 0x000fc400037fe4ffULL,
0x00000000120f7faeULL, 0x0003e8000e101c46ULL, 0x000000000a1d7faeULL, 0x0003e8000d901c46ULL,
0x00000000081f7faeULL, 0x0003e8000d101c46ULL, 0x0000000006217faeULL, 0x0003e8000c901c46ULL,
0x0000000004237faeULL, 0x0003e2000c101c46ULL, 0x00000b6000007947ULL, 0x000fea0003800000ULL,
0x0000000414067811ULL, 0x042fe400078fe8ffULL, 0x0000000814087811ULL, 0x000fc400078fe8ffULL,
0x0000000c140a7811ULL, 0x000fe200078fe8ffULL, 0x0000000106047824ULL, 0x100fe200078e0214ULL,
0x00000010140b7811ULL, 0x000fe200078fe8ffULL, 0x00000008062f7824ULL, 0x000fe200078e00ffULL,
0x00000018140d7811ULL, 0x000fe200078fe8ffULL, 0x0000000108077824ULL, 0x000fe200078e0214ULL,
0x0000001c14217811ULL, 0x000fe200078fe8ffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x000000010a047824ULL, 0x100fe200078e0214ULL,
0x0000002014247811ULL, 0x000fe200078fe8ffULL, 0x000000080a337824ULL, 0x000fe200078e00ffULL,
0xfffffff80c317812ULL, 0x000fe200078ee207ULL, 0x000000010b077824ULL, 0x040fe200078e0214ULL,
0x00000014140c7811ULL, 0x040fe200078fe8ffULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee204ULL, 0x000000010d0e7824ULL, 0x140fe200078e0214ULL,
0x0000002814267811ULL, 0x000fe200078fe8ffULL, 0x000000080d397824ULL, 0x000fe200078e00ffULL,
0xfffffff810357812ULL, 0x000fe200078ee207ULL, 0x000000010c097824ULL, 0x100fe200078e0214ULL,
0x0000002414257811ULL, 0x000fe200078fe8ffULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x0000002c14277811ULL, 0x040fe200078fe8ffULL, 0x0000000121047824ULL, 0x040fe200078e0214ULL,
0x00000030142c7811ULL, 0x000fe200078fe8ffULL, 0x00000008213b7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20eULL, 0x0000000124077824ULL, 0x000fe200078e0214ULL,
0xfffffff812377812ULL, 0x000fe200078ee209ULL, 0x0000000824107824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL, 0x00000001260e7824ULL, 0x100fe200078e0214ULL,
0x0000003814307811ULL, 0x000fe200078fe8ffULL, 0x0000000826417824ULL, 0x000fe200078e00ffULL,
0xfffffff8103d7812ULL, 0x000fe200078ee207ULL, 0x0000000125097824ULL, 0x040fe200078e0214ULL,
0x00000034142e7811ULL, 0x040fe200078fe8ffULL, 0x0000000825127824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20eULL, 0x0000000127047824ULL, 0x140fe200078e0214ULL,
0x0000003c140f7811ULL, 0x000fe200078fe8ffULL, 0x0000000827437824ULL, 0x000fe200078e00ffULL,
0xfffffff8123f7812ULL, 0x000fe200078ee209ULL, 0x000000012c077824ULL, 0x000fc400078e0214ULL,
0x000000082c107824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee204ULL,
0x00000001300e7824ULL, 0x100fe200078e0214ULL, 0x0000000514047211ULL, 0x000fe200078fe8ffULL,
0x0000000830497824ULL, 0x000fe200078e00ffULL, 0xfffffff810457812ULL, 0x000fe200078ee207ULL,
0x000000012e097824ULL, 0x040fe400078e0214ULL, 0x000000082e127824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee20eULL, 0x0000001014077824ULL, 0x000fc400078e00ffULL,
0x000000021a0e7824ULL, 0x000fe200078e025fULL, 0xfffffff812477812ULL, 0x000fe200078ee209ULL,
0x0000000106067824ULL, 0x100fe200078e0205ULL, 0x0000001414097211ULL, 0x000fe200078fe8ffULL,
0x0000000108087824ULL, 0x100fe200078e0205ULL, 0x00000070074d7812ULL, 0x000fe200078ec0ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0205ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0205ULL, 0x000020000e127811ULL, 0x000fe200078e68ffULL,
0x000000010c0c7824ULL, 0x100fe200078e0205ULL, 0x0ffffff8092d7812ULL, 0x000fe200078ef814ULL,
0x000000010d0d7824ULL, 0x000fc400078e0205ULL, 0x0000000121217824ULL, 0x100fe400078e0205ULL,
0x0000000124247824ULL, 0x100fe400078e0205ULL, 0x0000000125257824ULL, 0x100fe400078e0205ULL,
0x0000000126267824ULL, 0x100fe400078e0205ULL, 0x0000000127277824ULL, 0x100fe400078e0205ULL,
0x000000012c2c7824ULL, 0x000fc400078e0205ULL, 0x000000012e2e7824ULL, 0x100fe400078e0205ULL,
0x0000000130307824ULL, 0x100fe400078e0205ULL, 0x000000010f327824ULL, 0x000fe400078e0205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x000000010f107824ULL, 0x040fe200078e0214ULL,
0x0000004d040e7212ULL, 0x080fe200078efcffULL, 0x000000080f4b7824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee210ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000004d06107212ULL, 0x000fe400078efcffULL, 0x00006500050f7a10ULL, 0x000fe200007fe4ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0212ULL, 0x0000640010107a10ULL, 0x000fe20007f3e0ffULL,
0x000000102f2f7824ULL, 0x000fc400078e0212ULL, 0x0000001031317824ULL, 0x100fe200078e0212ULL,
0x0000650007117a10ULL, 0x000fe20000ffe4ffULL, 0x0000001033337824ULL, 0x100fe200078e0212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x0000001035357824ULL, 0x100fe400078e0212ULL, 0x0000001037377824ULL, 0x100fe200078e0212ULL,
0x00000000102f7faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x100fe400078e0212ULL,
0x000000103b3b7824ULL, 0x000fc400078e0212ULL, 0x000000103d3d7824ULL, 0x100fe400078e0212ULL,
0x000000103f3f7824ULL, 0x100fe400078e0212ULL, 0x0000001041417824ULL, 0x100fe400078e0212ULL,
0x0000001043437824ULL, 0x100fe400078e0212ULL, 0x0000001045457824ULL, 0x100fe400078e0212ULL,
0x0000001047477824ULL, 0x000fc400078e0212ULL, 0x0000001049497824ULL, 0x100fe400078e0212ULL,
0x000000104b4b7824ULL, 0x000fe200078e0212ULL, 0x0000004d08127212ULL, 0x000fe200078efcffULL,
0x000000800a047825ULL, 0x000fc600078e00ffULL, 0x0000640012127a10ULL, 0x000fe20007f1e0ffULL,
0x000000800b067825ULL, 0x000fe200078e00ffULL, 0x0000004d041c7212ULL, 0x080fe400078efcffULL,
0x0000650009137a10ULL, 0x000fe200007fe4ffULL, 0x000000800c0a7825ULL, 0x000fe200078e00ffULL,
0x0000004d061e7212ULL, 0x080fe400078efcffULL, 0x000064001c1c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000004d0a207212ULL, 0x000fe200078efcffULL,
0x0000000012317faeULL, 0x0003e2000b901c46ULL, 0x000064001e1e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008025087825ULL, 0x000fe200078e00ffULL, 0x00006500051d7a10ULL, 0x000fc400007fe4ffULL,
0x0000640020207a10ULL, 0x000fe20007f1e0ffULL, 0x0000008021047825ULL, 0x000fe200078e00ffULL,
0x0000004d0c227212ULL, 0x080fe200078efcffULL, 0x000000001c337faeULL, 0x0003e2000b901c46ULL,
0x00006500071f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008024067825ULL, 0x000fe200078e00ffULL,
0x000065000b217a10ULL, 0x000fe400007fe4ffULL, 0x0000004d04247212ULL, 0x080fe200078efcffULL,
0x00000080260a7825ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fe20007f5e0ffULL,
0x000000001e357faeULL, 0x0003e2000b901c46ULL, 0x0000004d06267212ULL, 0x000fc400078efcffULL,
0x0000640024247a10ULL, 0x000fe20007f1e0ffULL, 0x0000000020377faeULL, 0x0003e2000b901c46ULL,
0x0000004d08287212ULL, 0x080fe400078efcffULL, 0x000065000d237a10ULL, 0x000fe200017fe4ffULL,
0x00000080270c7825ULL, 0x000fe200078e00ffULL, 0x0000004d0a2a7212ULL, 0x000fe400078efcffULL,
0x0000640026267a10ULL, 0x000fe20007f3e0ffULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x0000650005257a10ULL, 0x000fe200007fe4ffULL, 0x000000802c047825ULL, 0x000fe200078e00ffULL,
0x0000640028287a10ULL, 0x000fc40007f1e0ffULL, 0x000064002a2a7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000243b7faeULL, 0x0003e2000b901c46ULL, 0x0000650007277a10ULL, 0x000fe20000ffe4ffULL,
0x000000802e067825ULL, 0x000fe200078e00ffULL, 0x0000004d0c0c7212ULL, 0x080fe400078efcffULL,
0x0000650009297a10ULL, 0x000fe200007fe4ffULL, 0x0000008030087825ULL, 0x000fe200078e00ffULL,
0x000065000b2b7a10ULL, 0x000fe200017fe4ffULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000080320a7825ULL, 0x000fe200078e00ffULL,
0x0000004d04047212ULL, 0x080fe200078efcffULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x0000004d06067212ULL, 0x000fc400078efcffULL, 0x0000004d08087212ULL, 0x080fe200078efcffULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000065000d0d7a10ULL, 0x000fe400007fe4ffULL,
0x0000004d0a0a7212ULL, 0x000fe400078efcffULL, 0x0000640004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000000c437faeULL, 0x0003e2000b901c46ULL, 0x0000640006067a10ULL, 0x000fe40007f3e0ffULL,
0x0000640008087a10ULL, 0x000fc40007f5e0ffULL, 0x000064000a0a7a10ULL, 0x000fe40007f7e0ffULL,
0x0000650005057a10ULL, 0x000fe400007fe4ffULL, 0x0000650007077a10ULL, 0x000fe40000ffe4ffULL,
0x0000650009097a10ULL, 0x000fe200017fe4ffULL, 0x0000000004457faeULL, 0x0003e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc60001ffe4ffULL, 0x0000000006477faeULL, 0x0003e8000b901c46ULL,
0x0000000008497faeULL, 0x0003e8000b901c46ULL, 0x000000000a4b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff8144d7812ULL, 0x020fe200078ec0ffULL,
0x000000021a7d7824ULL, 0x000fe200078e0265ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001667e7810ULL, 0x000fc40007ffe0ffULL, 0x000000074d517812ULL, 0x000fe400078ef814ULL,
0x000020007d7d7811ULL, 0x000fe400078e68ffULL, 0x0000000814817812ULL, 0x000fe200078ec0ffULL,
0x00000001514c7824ULL, 0x040fe400078e0266ULL, 0x00000008514d7824ULL, 0x000fe200078e00ffULL,
0x0000000781817812ULL, 0x000fe200078ef814ULL, 0x0000000851507824ULL, 0x040fe400078e00ffULL,
0x0000000151517824ULL, 0x000fe200078e027eULL, 0xfffffff84d4c7812ULL, 0x000fc400078ee24cULL,
0x0000001081807812ULL, 0x000fe400078efcffULL, 0xfffffff850507812ULL, 0x000fe200078ee251ULL,
0x000000104c4c7824ULL, 0x000fc800078e027dULL, 0x0000001050507824ULL, 0x000fe400078e027dULL,
0x000000004c4c783bULL, 0x000e680000000200ULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x002fe2000001144cULL, 0x000100004d5a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe4000001144dULL, 0x000088804d597816ULL, 0x040fe200000000ffULL,
0x000001004d4d7824ULL, 0x000fe200078e00ffULL, 0x0000005400867306ULL, 0x0003e20000200c00ULL,
0x000088804c567816ULL, 0x000fc400000000ffULL, 0x00000018ff797819ULL, 0x000fe4000001144fULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x000088804f7f7816ULL, 0x000fe200000000ffULL,
0x00000055008a7306ULL, 0x0007e20000200c00ULL, 0x000100004c547824ULL, 0x042fe200078e00ffULL,
0x00000018ff677819ULL, 0x004fe20000011450ULL, 0x000001004c4c7824ULL, 0x000fe200078e00ffULL,
0x00008880506b7816ULL, 0x000fe400000000ffULL, 0x00000018ff587819ULL, 0x000fc40000011454ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004d008b7306ULL, 0x0003e20000200c00ULL,
0x0000002014557810ULL, 0x008fe40007ffe0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001144eULL,
0xfffffff855557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000004c00877306ULL, 0x0005e20000200c00ULL, 0x000100004f4d7824ULL, 0x002fe200078e00ffULL,
0x0000000755837812ULL, 0x000fe200078ef814ULL, 0x000001004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc40000011451ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000000183547824ULL, 0x040fe200078e0266ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000000883557824ULL, 0x000fe200078e00ffULL, 0x000088804e4c7816ULL, 0x004fe200000000ffULL,
0x0000004d00907306ULL, 0x0003e20000200c00ULL, 0x00008880516d7816ULL, 0x000fe400000000ffULL,
0xfffffff855547812ULL, 0x000fe400078ee254ULL, 0x00000018ff697819ULL, 0x000fc40000011452ULL,
0x00008880526f7816ULL, 0x000fe200000000ffULL, 0x0000004c008c7306ULL, 0x0005e20000200c00ULL,
0x00010000514d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011453ULL,
0x0000001054547824ULL, 0x000fe200078e027dULL, 0x0000888053737816ULL, 0x000fe200000000ffULL,
0x0000010051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004f00927306ULL, 0x0003e20000200c00ULL, 0x00010000504c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000010050507824ULL, 0x000fc600078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000005800857306ULL, 0x0005e20000200c00ULL, 0x00000004ff4f7819ULL, 0x002fca0000011614ULL,
0x0000000266827824ULL, 0x040fe200078e024fULL, 0x0000000266667810ULL, 0x000fe20007ffe0ffULL,
0x0000004c006e7306ULL, 0x0003e20000200c00ULL, 0x000100004e587824ULL, 0x044fe400078e00ffULL,
0x000001004e4e7824ULL, 0x000fe200078e00ffULL, 0x000000086600780cULL, 0x000fe20003f05270ULL,
0x00000010814f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000050006c7306ULL, 0x0005e20000200c00ULL, 0x00000001814c7824ULL, 0x002fe200078e0282ULL,
0x00000018ff4e7819ULL, 0x000fc8000001144eULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000004d00707306ULL, 0x0003e20000200c00ULL, 0x0000001080507824ULL, 0x004fce00078e00ffULL,
0x00000058008d7306ULL, 0x0004e20000200c00ULL, 0x00000001804d7824ULL, 0x002fca00078e0282ULL,
0xfffffff0504d7812ULL, 0x000fe200078ee24dULL, 0x0001000053507824ULL, 0x000fe200078e00ffULL,
0x0000004e008e7306ULL, 0x0003e20000200c00ULL, 0x000000104c587824ULL, 0x004fe400078e00ffULL,
0x000000104d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011450ULL,
0x0000010053537824ULL, 0x000fc600078e00ffULL, 0x0000005600847306ULL, 0x0005220000200c00ULL,
0x00010000524e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000010052527824ULL, 0x000fe200078e00ffULL, 0x000054108c8c7816ULL, 0x008fe4000000008dULL,
0x00000018ff727819ULL, 0x000fe4000001144eULL, 0x0000005900887306ULL, 0x000fe20000200c00ULL,
0x000000005454783bULL, 0x004e620000000200ULL, 0x00000018ff527819ULL, 0x000fc60000011452ULL,
0x000000004d4c783bULL, 0x000ea60000000200ULL, 0x0000005a00897306ULL, 0x0006e20000200c00ULL,
0x0000541084847816ULL, 0x010fe40000000085ULL, 0x0000541087857816ULL, 0x000fca0000000086ULL,
0x0000005100717306ULL, 0x0003e20000200c00ULL, 0x000000005858783bULL, 0x008eee0000000200ULL,
0x0000005200747306ULL, 0x0009e20000200c00ULL, 0x0000541088887816ULL, 0x000fe40000000089ULL,
0x000054108b897816ULL, 0x000fca000000008aULL, 0x0000007900797306ULL, 0x000ef00000200c00ULL,
0x0000007b007b7306ULL, 0x000ee20000200c00ULL, 0x0001000054517824ULL, 0x042fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011454ULL, 0x0000010054527824ULL, 0x050fe200078e00ffULL,
0x0000888054507816ULL, 0x000fe200000000ffULL, 0x000000844c0c723cULL, 0x004fe2000000180cULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x00000050008f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff787819ULL, 0x000fe40000011456ULL,
0x00000018ff777819ULL, 0x000fe20000011457ULL, 0x000000884c04723cULL, 0x000fe20000001804ULL,
0x00000018ff7a7819ULL, 0x000fe40000011455ULL, 0x0000541092917816ULL, 0x008fe20000000079ULL,
0x0000005100547306ULL, 0x0004e20000200c00ULL, 0x0001000055507824ULL, 0x002fe200078e00ffULL,
0x000054108e8d7816ULL, 0x000fc4000000007bULL, 0x000000845810723cULL, 0x040b640000001810ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005200937306ULL, 0x0003e20000200c00ULL,
0x0000010055517824ULL, 0x004fe400078e00ffULL, 0x0000000183847824ULL, 0x060fe200078e027eULL,
0x000000885808723cULL, 0x000be20000001808ULL, 0x0000000883837824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fc40000011451ULL, 0x0000005300757306ULL, 0x0005e20000200c00ULL,
0x0000888056527816ULL, 0x002fe400000000ffULL, 0xfffffff883847812ULL, 0x000fe200078ee284ULL,
0x0000008c582c723cULL, 0x080fe8000000182cULL, 0x0000001084517824ULL, 0x000fe200078e027dULL,
0x0000888055537816ULL, 0x004fe200000000ffULL, 0x000000ffff7d7224ULL, 0x000fe200078e0052ULL,
0x0000007e00837306ULL, 0x0003e20000200c00ULL, 0x0001000056847824ULL, 0x040fe200078e00ffULL,
0x0000008c4c34723cULL, 0x000fe20000001834ULL, 0x0000010056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x0000007d00857306ULL, 0x0005e20000200c00ULL,
0x00008880577e7816ULL, 0x002fe400000000ffULL, 0x00000018ff567819ULL, 0x000fc60000011456ULL,
0x000000ffff797224ULL, 0x000fe200078e007eULL, 0x000054108f7e7816ULL, 0x008fe20000000054ULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x00010000577d7824ULL, 0x044fe200078e00ffULL,
0x0000000282547810ULL, 0x000fe20007ffe0ffULL, 0x0000010057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff577819ULL, 0x000fce0000011457ULL, 0x0000005300867306ULL, 0x000fe20000200c00ULL,
0x000054107f907816ULL, 0x002fce0000000090ULL, 0x0000005000557306ULL, 0x0002e20000200c00ULL,
0x00005410937f7816ULL, 0x004fe2000000007cULL, 0x000000905828723cULL, 0x040fec0000001828ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000000005150783bULL, 0x002e620000000200ULL,
0x0000007e5848723cULL, 0x000fec0000001848ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410867c7816ULL, 0x008fe20000000055ULL, 0x0000001080557824ULL, 0x000fe200078e00ffULL,
0x000000904c40723cULL, 0x000fea0000001840ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541085847816ULL, 0x004fc40000000084ULL, 0x0000007e4c30723cULL, 0x000fea0000001830ULL,
0x0000007700777306ULL, 0x000ff00000200c00ULL, 0x00000056007b7306ULL, 0x0004f00000200c00ULL,
0x0000007900877306ULL, 0x0009e20000200c00ULL, 0x0000001081567824ULL, 0x004fc400078e00ffULL,
0x0000000181817824ULL, 0x100fe400078e0254ULL, 0x0000000180547824ULL, 0x000fe200078e0254ULL,
0x00000018ff807819ULL, 0x002fe40000011452ULL, 0x0000007d00887306ULL, 0x0202a20000200c00ULL,
0xfffffff056817812ULL, 0x000fe400078ee281ULL, 0xfffffff055557812ULL, 0x000fe400078ee254ULL,
0x000054107b857816ULL, 0x008fe20000000078ULL, 0x0000001081547824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x010fe20000011450ULL, 0x0000005700827306ULL, 0x0007220000200c00ULL,
0x00005410837d7816ULL, 0x002fe2000000007aULL, 0x0000001055787824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011451ULL, 0x00000084583c723cULL, 0x000fe2000000183cULL,
0x00000018ff817819ULL, 0x000fc40000011453ULL, 0x0000541087887816ULL, 0x004fe20000000088ULL,
0x000000005454783bULL, 0x008e620000000200ULL, 0x0000006700677306ULL, 0x000fe60000200c00ULL,
0x0000007c5838723cULL, 0x000f620000001838ULL, 0x0000541082897816ULL, 0x010fc80000000077ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000888050777816ULL, 0x000fe400000000ffULL,
0x0000007c4c20723cULL, 0x000f6a0000001820ULL, 0x0000006a006a7306ULL, 0x000ea60000200c00ULL,
0x000000885844723cULL, 0x000b640000001844ULL, 0x000000007858783bULL, 0x0207260000000200ULL,
0x0000006900697306ULL, 0x000fe60000200c00ULL, 0x000000844c24723cULL, 0x000f620000001824ULL,
0x0000888051787816ULL, 0x008fc800000000ffULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541071717816ULL, 0x004fe4000000006aULL, 0x000000884c1c723cULL, 0x000b62000000181cULL,
0x00000100526a7824ULL, 0x000fc800078e00ffULL, 0x0000007200727306ULL, 0x000fe40000200c00ULL,
0x000000ffff4c7224ULL, 0x020fe200078e0078ULL, 0x000054106c4d7816ULL, 0x000fe20000000067ULL,
0x00010000514e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000010051517824ULL, 0x000fe400078e00ffULL, 0x0000004c004f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff517819ULL, 0x000fca0000011451ULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x000054106b4c7816ULL, 0x004fce000000006eULL,
0x0000004c5410723cULL, 0x082f620000001810ULL, 0x0000007a007b7306ULL, 0x0003ee0000200c00ULL,
0x0000004c580c723cULL, 0x010b62000000180cULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x00010000507a7824ULL, 0x042fe200078e00ffULL, 0x0000541075757816ULL, 0x008fe20000000068ULL,
0x0000010050507824ULL, 0x000fc600078e00ffULL, 0x00010000524d7824ULL, 0x060fe200078e00ffULL,
0x00008880524c7816ULL, 0x000fe200000000ffULL, 0x00000051006c7306ULL, 0x000e620000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff507819ULL, 0x000fc60000011450ULL, 0x0000004c00677306ULL, 0x0007e20000200c00ULL,
0x000054104f4e7816ULL, 0x004fce000000004eULL, 0x0000004d00527306ULL, 0x0005220000200c00ULL,
0x000054106f4c7816ULL, 0x008fe40000000072ULL, 0x000054106c4f7816ULL, 0x002fca000000007bULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x00005410744d7816ULL, 0x004fe20000000069ULL,
0x0000004e5438723cULL, 0x000f620000001838ULL, 0x0000888053697816ULL, 0x000fca00000000ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541067527816ULL, 0x010fe20000000052ULL,
0x0000004c542c723cULL, 0x080f6c000000182cULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x000054106d707816ULL, 0x002fe20000000070ULL, 0x0000004c5834723cULL, 0x000b6c0000001834ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000000ffff4c7224ULL, 0x020fe200078e0069ULL,
0x000000705408723cULL, 0x000b620000001808ULL, 0x0001000053697824ULL, 0x000fc400078e00ffULL,
0x0000010053537824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x000000705804723cULL, 0x000b620000001804ULL, 0x0000541073747816ULL, 0x004fca0000000076ULL,
0x0000008100817306ULL, 0x000fe40000200c00ULL, 0x000000745428723cULL, 0x080b6c0000001828ULL,
0x0000007700777306ULL, 0x000fe40000200c00ULL, 0x000000745840723cULL, 0x040b6c0000001840ULL,
0x0000007a007a7306ULL, 0x000e640000200c00ULL, 0x0000004e5820723cULL, 0x000b6c0000001820ULL,
0x0000005000507306ULL, 0x000eb00000200c00ULL, 0x0000006a00517306ULL, 0x000fe20000200c00ULL,
0x0000541077787816ULL, 0x002fce000000007aULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541050797816ULL, 0x004fce0000000079ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000000785448723cULL, 0x080b6e0000001848ULL, 0x0000005300687306ULL, 0x0004e20000200c00ULL,
0x000000785830723cULL, 0x000b620000001830ULL, 0x000054104c4c7816ULL, 0x002fc40000000069ULL,
0x0000541051537816ULL, 0x004fe40000000080ULL, 0x00005410684d7816ULL, 0x008fca0000000081ULL,
0x00000052543c723cULL, 0x040b70000000183cULL, 0x0000004c5444723cULL, 0x000b700000001844ULL,
0x000000525824723cULL, 0x040b700000001824ULL, 0x0000004c581c723cULL, 0x000b62000000181cULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffee1000007947ULL, 0x000fcc000383ffffULL,
0x00000063104f7220ULL, 0x0a0fe40000410000ULL, 0x000000632d2d7220ULL, 0x000fc40000410000ULL,
0x000000632e2e7220ULL, 0x080fe40000410000ULL, 0x000000632f2f7220ULL, 0x080fe40000410000ULL,
0x00000063294e7220ULL, 0x080fe40000410000ULL, 0x0000006339397220ULL, 0x080fe40000410000ULL,
0x00000063375b7220ULL, 0x080fe40000410000ULL, 0x00000063114d7220ULL, 0x000fc40000410000ULL,
0x00000063084c7220ULL, 0x080fe40000410000ULL, 0x000000630a107220ULL, 0x080fe40000410000ULL,
0x000000632c2c7220ULL, 0x080fe40000410000ULL, 0x000000632b297220ULL, 0x080fe40000410000ULL,
0x0000006338387220ULL, 0x080fe40000410000ULL, 0x000000633a3a7220ULL, 0x000fc40000410000ULL,
0x000000633b3b7220ULL, 0x080fe40000410000ULL, 0x000000633d3d7220ULL, 0x080fe40000410000ULL,
0x000000633e3e7220ULL, 0x080fe40000410000ULL, 0x000000633f3f7220ULL, 0x080fe40000410000ULL,
0x000000630e567220ULL, 0x080fe40000410000ULL, 0x000000630f577220ULL, 0x000fc40000410000ULL,
0x0000006306587220ULL, 0x080fe40000410000ULL, 0x0000006307597220ULL, 0x080fe40000410000ULL,
0x0000006334347220ULL, 0x080fe40000410000ULL, 0x0000006335357220ULL, 0x080fe40000410000ULL,
0x0000006320377220ULL, 0x080fe40000410000ULL, 0x0000006322697220ULL, 0x000fc40000410000ULL,
0x0000006312127220ULL, 0x080fe40000410000ULL, 0x0000006313137220ULL, 0x080fe40000410000ULL,
0x0000006309097220ULL, 0x080fe40000410000ULL, 0x000000630b0b7220ULL, 0x080fe40000410000ULL,
0x000000632a117220ULL, 0x080fe40000410000ULL, 0x0000006348507220ULL, 0x000fc40000410000ULL,
0x000000634a527220ULL, 0x080fe40000410000ULL, 0x000000634b537220ULL, 0x080fe40000410000ULL,
0x000000633c3c7220ULL, 0x080fe40000410000ULL, 0x0000006344087220ULL, 0x080fe40000410000ULL,
0x00000063450a7220ULL, 0x080fe40000410000ULL, 0x0000006346547220ULL, 0x000fc40000410000ULL,
0x0000006347557220ULL, 0x080fe40000410000ULL, 0x000000630c0c7220ULL, 0x080fe40000410000ULL,
0x000000630d0d7220ULL, 0x080fe40000410000ULL, 0x0000006304047220ULL, 0x080fe40000410000ULL,
0x0000006305057220ULL, 0x080fe40000410000ULL, 0x0000006340067220ULL, 0x000fc40000410000ULL,
0x0000006341077220ULL, 0x080fe40000410000ULL, 0x00000063300e7220ULL, 0x080fe40000410000ULL,
0x00000063210f7220ULL, 0x080fe40000410000ULL, 0x0000006324207220ULL, 0x080fe40000410000ULL,
0x0000006325227220ULL, 0x080fe40000410000ULL, 0x000000631c1c7220ULL, 0x000fc40000410000ULL,
0x0000006349487220ULL, 0x080fe40000410000ULL, 0x00000063365a7220ULL, 0x080fe40000410000ULL,
0x0000006331367220ULL, 0x080fe40000410000ULL, 0x0000006332677220ULL, 0x000fe40000410000ULL,
0x000000ffff497224ULL, 0x000fe400078e002dULL, 0x000000ffff467224ULL, 0x000fc400078e0039ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002eULL, 0x000000ffff417224ULL, 0x000fe400078e002fULL,
0x0000006328517220ULL, 0x080fe40000410000ULL, 0x0000006342657220ULL, 0x080fe40000410000ULL,
0x0000006343667220ULL, 0x080fe40000410000ULL, 0x0000006333687220ULL, 0x000fc40000410000ULL,
0x00000063236a7220ULL, 0x080fe40000410000ULL, 0x00000063266b7220ULL, 0x080fe40000410000ULL,
0x00000063276c7220ULL, 0x000fe40000410000ULL, 0x000000ffff4a7224ULL, 0x000fe400078e002cULL,
0x000000ffff477224ULL, 0x000fe400078e0038ULL, 0x000000ffff447224ULL, 0x000fc400078e003dULL,
0x000000ffff2d7224ULL, 0x000fe400078e0029ULL, 0x000000ffff2e7224ULL, 0x000fe400078e003aULL,
0x000000ffff397224ULL, 0x000fe400078e003bULL, 0x000000ffff2f7224ULL, 0x000fe400078e003eULL,
0x000000ffff307224ULL, 0x000fe400078e003fULL, 0x000000ffff317224ULL, 0x000fc400078e0034ULL,
0x000000ffff327224ULL, 0x000fe400078e0035ULL, 0x000000631d1d7220ULL, 0x080fe40000410000ULL,
0x000000631e6d7220ULL, 0x080fe40000410000ULL, 0x000000631f6e7220ULL, 0x000fe40000410000ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0009ULL, 0x000000ffff457224ULL, 0x000fc400078e003cULL,
0x000000ffff437224ULL, 0x000fe400078e0008ULL, 0x000000ffff427224ULL, 0x000fe400078e000aULL,
0x000000ffff287224ULL, 0x000fe400078e0012ULL, 0x000000ffff277224ULL, 0x000fe400078e0013ULL,
0x000000ffff257224ULL, 0x000fe400078e0010ULL, 0x000000ffff237224ULL, 0x000fc400078e000bULL,
0x000000ffff2b7224ULL, 0x000fe400078e0011ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0052ULL,
0x000000ffff407224ULL, 0x000fe400078e0053ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0054ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0055ULL, 0x000000ffff297224ULL, 0x000fc400078e000cULL,
0x000000ffff267224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x000fe400078e0004ULL,
0x000000ffff217224ULL, 0x000fe400078e0005ULL, 0x000000ffff337224ULL, 0x000fe400078e0006ULL,
0x000000ffff347224ULL, 0x000fe400078e0007ULL, 0x000000ffff357224ULL, 0x000fc400078e000eULL,
0x000000ffff387224ULL, 0x000fe400078e000fULL, 0x000000ffff3f7224ULL, 0x000fe400078e0020ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0022ULL, 0x000000ffff3b7224ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000062087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe400078e001dULL, 0x000000ffff227224ULL, 0x000fc400078e0056ULL,
0x000000ffff207224ULL, 0x000fe400078e0057ULL, 0x000000ffff137224ULL, 0x000fe400078e0058ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0059ULL, 0x000000ffff1f7224ULL, 0x000fe400078e005aULL,
0x000000ffff1e7224ULL, 0x000fe400078e005bULL, 0x000000ffff1d7224ULL, 0x000fc400078e0065ULL,
0x000000ffff127224ULL, 0x000fe400078e0066ULL, 0x000000ffff117224ULL, 0x000fe400078e0067ULL,
0x000000ffff107224ULL, 0x000fe400078e0068ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0069ULL,
0x000000ffff0b7224ULL, 0x000fe400078e006aULL, 0x000000ffff0c7224ULL, 0x000fc400078e006bULL,
0x000000ffff0d7224ULL, 0x000fe400078e006cULL, 0x000000ffff0e7224ULL, 0x000fe400078e006dULL,
0x000000ffff0f7224ULL, 0x000fc400078e006eULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040062077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604537210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09005300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000005306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000152527810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040062077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000414097824ULL, 0x000fe200078e00ffULL, 0x000000005c00720cULL, 0x000fc80003f06070ULL,
0xfffffff009057812ULL, 0x000fca00078ec0ffULL, 0x000000801a087824ULL, 0x000fca00078e0205ULL,
0x01a4000008047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a0000557b06ULL, 0x000ee20000209000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0000001914547211ULL, 0x000fc800078ff0ffULL, 0x0000001854587810ULL, 0x000fe40007ffe0ffULL,
0x0000005500557308ULL, 0x008ee40000001000ULL, 0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL,
0x0000005700537305ULL, 0x000ee4000021f000ULL, 0x000000ffff597224ULL, 0x008fc800078e0a53ULL,
0x00005a0059597a24ULL, 0x000fc800078e02ffULL, 0x0000005953657227ULL, 0x000fe200078e0052ULL,
0x0000000854527810ULL, 0x040fe40007ffe0ffULL, 0x0000001054537810ULL, 0x000fc60007ffe0ffULL,
0x0000005265597227ULL, 0x000fc800078e00ffULL, 0x0000005465567227ULL, 0x000fc800078e00ffULL,
0x000000ffff577224ULL, 0x000fe400078e0a59ULL, 0x000000ffff557224ULL, 0x000fe400078e0a56ULL,
0x00000053655a7227ULL, 0x000fc800078e00ffULL, 0x00005a0057577a24ULL, 0x000fe400078e0252ULL,
0x00005a0055557a24ULL, 0x000fe400078e0254ULL, 0x000000ffff527224ULL, 0x000fe200078e0a5aULL,
0x00005a0057007a0cULL, 0x000fe20003fa6070ULL, 0x0000005865657227ULL, 0x000fe200078e00ffULL,
0x00005a0055007a0cULL, 0x000fc60003f06070ULL, 0x00005a0052547a24ULL, 0x000fe200078e0253ULL,
0xffffff0064537810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0a65ULL,
0x00005a00ff647a12ULL, 0x000fe400078e33ffULL, 0x0000005316527217ULL, 0x000fe20007800000ULL,
0x00005a005b5b7a24ULL, 0x000fe200078e0258ULL, 0x00005a0054007a0cULL, 0x000fe40003f26070ULL,
0x80005a0057575a10ULL, 0x000fe20007ffe0ffULL, 0x0000000152527824ULL, 0x000fe200078e0a53ULL,
0x80005a0055550a10ULL, 0x000fe20007ffe0ffULL, 0x0000000214537824ULL, 0x000fe200078e00ffULL,
0x00005a005b007a0cULL, 0x000fc40003f66070ULL, 0x00005a0057007a0cULL, 0x000fe40003fc6070ULL,
0x00005a0055007a0cULL, 0x000fe40003f46070ULL, 0x0000000653537812ULL, 0x000fe400078ec0ffULL,
0x80005a0054541a10ULL, 0x000fe40007ffe0ffULL, 0x0000000159595810ULL, 0x000fe20007ffe0ffULL,
0x0000000153557824ULL, 0x000fe200078e025dULL, 0x00005a0054007a0cULL, 0x000fe20003f86070ULL,
0x0000000160577824ULL, 0x000fe200078e0253ULL, 0x0000000156560810ULL, 0x000fe20007ffe0ffULL,
0x0000000155547824ULL, 0x100fe200078e0a52ULL, 0x80005a005b5b3a10ULL, 0x000fe20007ffe0ffULL,
0x0000000157587824ULL, 0x000fe200078e0a52ULL, 0x0000000159596810ULL, 0x000fc40007ffe0ffULL,
0x0000000156562810ULL, 0x000fe40007ffe0ffULL, 0x000000525500720cULL, 0x000fe40003fc6070ULL,
0x0000005461547217ULL, 0x000fe40003800000ULL, 0x00005a005b007a0cULL, 0x000fe40003f46070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x000000ff54687207ULL, 0x000fc40003000000ULL,
0x0000005861587217ULL, 0x000fe40003800000ULL, 0x0000005964547207ULL, 0x040fe40006800000ULL,
0x000000525700720cULL, 0x000fe40003f06070ULL, 0x0000005664567207ULL, 0x000fe40006800000ULL,
0x00000004ff587819ULL, 0x000fe40000011658ULL, 0x0000000165653810ULL, 0x000fc40007ffe0ffULL,
0x0000005461597217ULL, 0x040fe40003800000ULL, 0x0000005661577217ULL, 0x000fe40003800000ULL,
0x000000015a5a1810ULL, 0x000fe20007ffe0ffULL, 0x0000005918877224ULL, 0x000fe200078e02ffULL,
0x000000ff58667207ULL, 0x000fe20000000000ULL, 0x0000005718857224ULL, 0x000fe200078e02ffULL,
0x0000000165652810ULL, 0x000fe40007ffe0ffULL, 0x000000015a5a4810ULL, 0x000fe20007ffe0ffULL,
0x00000001855b7824ULL, 0x000fe200078e0266ULL, 0x0000006564567207ULL, 0x000fe20006800000ULL,
0x0000000166657824ULL, 0x000fe200078e0287ULL, 0x0000005a64547207ULL, 0x000fe20006800000ULL,
0x000000025b5a7825ULL, 0x000fe200078e0002ULL, 0x0000008568597211ULL, 0x000fc400078fe0ffULL,
0x0000005461577217ULL, 0x000fe20003800000ULL, 0x0000000265647825ULL, 0x100fe200078e0002ULL,
0x0000005661677217ULL, 0x000fe20003800000ULL, 0x000000065a547981ULL, 0x000724000c1e9500ULL,
0x0000000259587825ULL, 0x000fe400078e0002ULL, 0x0000000664567981ULL, 0x0042a4000c1e9500ULL,
0x0000005718897224ULL, 0x040fe400078e02ffULL, 0x0000000658577981ULL, 0x000722000c1e9500ULL,
0x0000001053657812ULL, 0x002fe200078efcffULL, 0x00000067188b7224ULL, 0x000fe200078e02ffULL,
0x00000087686b7211ULL, 0x000fc600078fe0ffULL, 0x0000000160757824ULL, 0x000fe200078e0265ULL,
0x00000089686d7211ULL, 0x000fe200078fe0ffULL, 0x00000001666f7824ULL, 0x040fe400078e0289ULL,
0x0000000175647824ULL, 0x000fe400078e0a52ULL, 0x0000000166737824ULL, 0x000fe400078e028bULL,
0x000000026b6a7825ULL, 0x000fe200078e0002ULL, 0x0000006461667217ULL, 0x000fc60003800000ULL,
0x000000026f6e7825ULL, 0x100fe200078e0002ULL, 0x0000008b68717211ULL, 0x000fe200078fe0ffULL,
0x000000066a597981ULL, 0x0082a4000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fe200078e0002ULL,
0x000000527500720cULL, 0x000fe20003f26070ULL, 0x000000066e587981ULL, 0x0006a4000c1e9500ULL,
0x0000000165677824ULL, 0x000fe200078e025dULL, 0x00000004ff667819ULL, 0x000fe20000011666ULL,
0x000000066c5b7981ULL, 0x0002a2000c1e9500ULL, 0x0000000271707825ULL, 0x000fc800078e0002ULL,
0x0000000167647824ULL, 0x000fe200078e0a52ULL, 0x000000ff666e7207ULL, 0x008fe20000800000ULL,
0x0000000273727825ULL, 0x000fe200078e0002ULL, 0x000000526700720cULL, 0x000fe20003f06070ULL,
0x0000000670697981ULL, 0x0006a2000c1e9500ULL, 0x0000006461647217ULL, 0x000fe40003800000ULL,
0x0000002053797812ULL, 0x000fe200078efcffULL, 0x00000006725a7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff647a7207ULL, 0x000fe20000000000ULL, 0x000000016e717824ULL, 0x008fc600078e0287ULL,
0x000000857a6b7211ULL, 0x042fe200078fe0ffULL, 0x0000000271707825ULL, 0x000fe200078e0002ULL,
0x000000877a6f7211ULL, 0x000fc600078fe0ffULL, 0x00000001856d7824ULL, 0x000fe200078e026eULL,
0x0000000670667981ULL, 0x0002e2000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fc800078e0002ULL,
0x000000026d6c7825ULL, 0x000fc800078e0002ULL, 0x000000016e757824ULL, 0x000fe200078e0289ULL,
0x000000066c647981ULL, 0x0002e4000c1e9500ULL, 0x0000000160717824ULL, 0x002fe400078e0279ULL,
0x000000016e7f7824ULL, 0x000fe200078e028bULL, 0x000000066a6b7981ULL, 0x0002e2000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fe200078e0002ULL, 0x0000008b7a7d7211ULL, 0x000fc600078fe0ffULL,
0x0000000171707824ULL, 0x100fe200078e0a52ULL, 0x000000066e6d7981ULL, 0x0002e2000c1e9500ULL,
0x00000001797b7824ULL, 0x000fe200078e025dULL, 0x000000897a737211ULL, 0x000fe400078fe0ffULL,
0x0000007061767217ULL, 0x000fe20003800000ULL, 0x000000017b707824ULL, 0x000fe400078e0a52ULL,
0x000000027d7c7825ULL, 0x000fe200078e0002ULL, 0x000000527100720cULL, 0x000fc60003f26070ULL,
0x0000000273727825ULL, 0x000fe200078e0002ULL, 0x000000527b00720cULL, 0x000fe20003f06070ULL,
0x000000067c7d7981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff767819ULL, 0x000fe20000011676ULL,
0x0000000275747825ULL, 0x100fe200078e0002ULL, 0x0000007061707217ULL, 0x000fe20003800000ULL,
0x0000000672777981ULL, 0x0002e4000c1e9500ULL, 0x000000027f7e7825ULL, 0x000fe400078e0002ULL,
0x00000006746a7981ULL, 0x0022e2000c1e9500ULL, 0x000000ff707c7207ULL, 0x000fc60000000000ULL,
0x000000067e6c7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff76727207ULL, 0x000fe40000800000ULL,
0x000000877c737211ULL, 0x000fc600078fe0ffULL, 0x0000000172817824ULL, 0x040fe400078e0287ULL,
0x0000000185717824ULL, 0x000fe400078e0272ULL, 0x0000000172757824ULL, 0x042fe400078e0289ULL,
0x00000001728f7824ULL, 0x000fe400078e028bULL, 0x0000000281807825ULL, 0x000fe200078e0002ULL,
0x000000857c6f7211ULL, 0x000fc600078fe0ffULL, 0x0000000273727825ULL, 0x000fe200078e0002ULL,
0x0000000680787981ULL, 0x0002e2000c1e9500ULL, 0x0000003053b57812ULL, 0x000fc600078efcffULL,
0x0000000672cf7981ULL, 0x0002e2000c1e9500ULL, 0x0000000271707825ULL, 0x100fe200078e0002ULL,
0x000000897c7f7211ULL, 0x040fe400078fe0ffULL, 0x0000008b7c8d7211ULL, 0x000fe200078fe0ffULL,
0x000000026f6e7825ULL, 0x000fe200078e0002ULL, 0x0000000670767981ULL, 0x0002e6000c1e9500ULL,
0x0000000160817824ULL, 0x002fe200078e02b5ULL, 0x000000066e837981ULL, 0x0002e2000c1e9500ULL,
0x0000000275747825ULL, 0x000fc800078e0002ULL, 0x000000027f7e7825ULL, 0x100fe200078e0002ULL,
0x00000006748c7981ULL, 0x0002e6000c1e9500ULL, 0x000000028f707825ULL, 0x100fe200078e0002ULL,
0x000000067ed37981ULL, 0x0002e6000c1e9500ULL, 0x000000028d6e7825ULL, 0x002fe200078e0002ULL,
0x0000000670907981ULL, 0x0002e6000c1e9500ULL, 0x0000000181807824ULL, 0x000fe200078e0a52ULL,
0x000000066ed77981ULL, 0x0002e2000c1e9500ULL, 0x00000001b5b77824ULL, 0x000fc600078e025dULL,
0x0000008061827217ULL, 0x000fe20003800000ULL, 0x00000001b7807824ULL, 0x000fe200078e0a52ULL,
0x000000528100720cULL, 0x080fe40003f26070ULL, 0x00000004ff827819ULL, 0x000fe40000011682ULL,
0x00000052b700720cULL, 0x000fe40003f06070ULL, 0x0000008061807217ULL, 0x000fe40003800000ULL,
0x000000ff82847207ULL, 0x000fc40000800000ULL, 0x000000ff80827207ULL, 0x000fc60000000000ULL,
0x00000001857f7824ULL, 0x000fe200078e0284ULL, 0x0000008582817211ULL, 0x000fe200078fe0ffULL,
0x0000000184737824ULL, 0x000fe200078e0289ULL, 0x0000008982757211ULL, 0x000fe200078fe0ffULL,
0x000000027f7e7825ULL, 0x000fc800078e0002ULL, 0x0000000281807825ULL, 0x100fe200078e0002ULL,
0x000000067e867981ULL, 0x0002e6000c1e9500ULL, 0x0000000273727825ULL, 0x100fe200078e0002ULL,
0x0000000680b97981ULL, 0x0002e6000c1e9500ULL, 0x0000000275747825ULL, 0x000fe200078e0002ULL,
0x00000006728e7981ULL, 0x0002e4000c1e9500ULL, 0x0000008782717211ULL, 0x002fc400078fe0ffULL,
0x0000000674d57981ULL, 0x0002e2000c1e9500ULL, 0x00000001846f7824ULL, 0x000fe400078e0287ULL,
0x0000000271707825ULL, 0x000fc800078e0002ULL, 0x000000026f6e7825ULL, 0x000fe200078e0002ULL,
0x0000000670d17981ULL, 0x0002e2000c1e9500ULL, 0x0000008b827f7211ULL, 0x000fc600078fe0ffULL,
0x000000066e8a7981ULL, 0x0002e2000c1e9500ULL, 0x0000000184817824ULL, 0x000fe400078e028bULL,
0x000000027f7e7825ULL, 0x000fc800078e0002ULL, 0x0000000281807825ULL, 0x000fe200078e0002ULL,
0x000000067ed97981ULL, 0x0002e8000c1e9500ULL, 0x0000000680927981ULL, 0x0002e4000c1e9500ULL,
0xfffffff0686f7812ULL, 0x002fe200078ec0ffULL, 0x00000001ffcd7424ULL, 0x000fc800078e00ffULL,
0x0000000152687824ULL, 0x000fe200078e026fULL, 0xfffffff07a6f7812ULL, 0x000fc600078ec0ffULL,
0x00000001556e7824ULL, 0x000fe200078e0a68ULL, 0x0000000153857812ULL, 0x000fe200078efcffULL,
0x0000000152747824ULL, 0x000fc600078e026fULL, 0x0000006ecd6f7219ULL, 0x000fe200000006ffULL,
0x0000000185717824ULL, 0x000fe200078e025dULL, 0xfffffff07c737812ULL, 0x000fc600078ec0ffULL,
0x0000000171707824ULL, 0x100fe200078e0a68ULL, 0x0000000853877812ULL, 0x040fe200078efcffULL,
0x00000001527a7824ULL, 0x000fe200078e0273ULL, 0x0000000953897812ULL, 0x000fe400078efcffULL,
0x00000070cd737219ULL, 0x000fe200000006ffULL, 0x0000000187757824ULL, 0x100fe400078e025dULL,
0x0000000189817824ULL, 0x000fe200078e025dULL, 0xfffffff0827f7812ULL, 0x000fe200078ec0ffULL,
0x0000000175727824ULL, 0x000fc400078e0a68ULL, 0x0000000181687824ULL, 0x000fe200078e0a68ULL,
0x00000011538f7812ULL, 0x000fe200078efcffULL, 0x0000000152807824ULL, 0x000fe200078e027fULL,
0x00000072cd7f7219ULL, 0x040fe400000006ffULL, 0x00000068cd8b7219ULL, 0x000fe200000006ffULL,
0x000000018f917824ULL, 0x000fe400078e025dULL, 0x0000000167687824ULL, 0x100fe400078e0a74ULL,
0x00000001916e7824ULL, 0x000fe200078e0a74ULL, 0x0000541057547816ULL, 0x010fc80000000054ULL,
0x000000546fff7212ULL, 0x000fc800078ac0ffULL, 0x000000525500720cULL, 0x000fc80002fa1470ULL,
0x000000525300720cULL, 0x000fe40002fa1070ULL, 0x0000005473ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000004f4f7808ULL, 0x000fe40002800000ULL, 0x0000541059567816ULL, 0x004fc80000000056ULL,
0x000000566fff7212ULL, 0x080fe4000784c0ffULL, 0x000054105b587816ULL, 0x000fe40000000058ULL,
0x0000005673ff7212ULL, 0x000fe400078ac0ffULL, 0x000000586fff7212ULL, 0x000fe4000788c0ffULL,
0x000000525500720cULL, 0x0c0fe40001741470ULL, 0x000000525500720cULL, 0x000fc40002781470ULL,
0x000000527100720cULL, 0x0c0fe40000f21470ULL, 0x000000527100720cULL, 0x080fe40002fa1470ULL,
0x000000525300720cULL, 0x0c0fe40001741070ULL, 0x000000525300720cULL, 0x080fe40002781070ULL,
0x000000528500720cULL, 0x0c0fe40000f21070ULL, 0x000000528500720cULL, 0x000fc40002fa1070ULL,
0x00005410695a7816ULL, 0x000fe4000000005aULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x000000547fff7212ULL, 0x000fc4000786c0ffULL,
0x0000005a6fff7212ULL, 0x000fe4000780c0ffULL, 0x0000005873ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005a73ff7212ULL, 0x000fe4000788c0ffULL, 0x000000568bff7212ULL, 0x000fe4000782c0ffULL,
0x000000587fff7212ULL, 0x000fe400078ac0ffULL, 0x000000525500720cULL, 0x000fc40000701470ULL,
0x000000527100720cULL, 0x0c0fe40001741470ULL, 0x000000527100720cULL, 0x080fe40002781470ULL,
0x000000527500720cULL, 0x0c0fe40001f61470ULL, 0x000000527500720cULL, 0x080fe40002fa1470ULL,
0x000000528100720cULL, 0x000fe40000f21470ULL, 0x0000001853957812ULL, 0x000fc400078efcffULL,
0x00000019539b7812ULL, 0x040fe400078efcffULL, 0x000000525300720cULL, 0x080fe40000701070ULL,
0x000000528500720cULL, 0x0c0fe40001741070ULL, 0x000000528500720cULL, 0x080fe40002781070ULL,
0x000000528700720cULL, 0x0c0fe40001f61070ULL, 0x000000528700720cULL, 0x000fc40002fa1070ULL,
0x000000528900720cULL, 0x000fe40000f21070ULL, 0x00000068cd8d7219ULL, 0x040fe400000006ffULL,
0x0000006ecd937219ULL, 0x000fe400000006ffULL, 0x000054106b647816ULL, 0x008fe40000000064ULL,
0x000054106d667816ULL, 0x000fe20000000066ULL, 0x0000000195977824ULL, 0x100fe200078e025dULL,
0xff80000022227808ULL, 0x000fe20000000000ULL, 0x000000019b9d7824ULL, 0x000fe200078e025dULL,
0xff80000026267808ULL, 0x000fc40001000000ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0x000000567fff7212ULL, 0x000fe4000780c0ffULL,
0x000000588bff7212ULL, 0x000fc4000784c0ffULL, 0x0000005a7fff7212ULL, 0x080fe4000788c0ffULL,
0x0000005a8bff7212ULL, 0x000fe4000786c0ffULL, 0x0000006493ff7212ULL, 0x000fe400078ac0ffULL,
0x000000668dff7212ULL, 0x000fe2000782c0ffULL, 0x0000000197707824ULL, 0x100fe200078e0a74ULL,
0x000000527500720cULL, 0x080fe20000701470ULL, 0x000000019d747824ULL, 0x000fe200078e0a74ULL,
0x000000527500720cULL, 0x000fc40002781470ULL, 0x000000528100720cULL, 0x0c0fe40001741470ULL,
0x000000528100720cULL, 0x080fe40001f61470ULL, 0x000000526700720cULL, 0x080fe40000f21470ULL,
0x000000529100720cULL, 0x080fe40002fa1470ULL, 0x000000528700720cULL, 0x0c0fe40000701070ULL,
0x000000528700720cULL, 0x000fc40002781070ULL, 0x000000528900720cULL, 0x0c0fe40001741070ULL,
0x000000528900720cULL, 0x080fe40001f61070ULL, 0x000000526500720cULL, 0x080fe40000f21070ULL,
0x000000528f00720cULL, 0x000fe40002fa1070ULL, 0x00000070cd997219ULL, 0x040fe400000006ffULL,
0x00000074cd9f7219ULL, 0x000fc400000006ffULL, 0x00005410776a7816ULL, 0x000fe4000000006aULL,
0x000054107d6c7816ULL, 0x000fe4000000006cULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40002000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff8000001c1c7808ULL, 0x000fc40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002800000ULL, 0x000000648dff7212ULL, 0x080fe4000780c0ffULL,
0x0000006499ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006a8dff7212ULL, 0x040fe4000784c0ffULL,
0x0000006c8dff7212ULL, 0x000fc4000786c0ffULL, 0x0000006a93ff7212ULL, 0x000fe4000782c0ffULL,
0x000000669fff7212ULL, 0x000fe200078ac0ffULL, 0x000000017b727824ULL, 0x000fe200078e0a7aULL,
0x000000526700720cULL, 0x0c0fe40000701470ULL, 0x000000526700720cULL, 0x0c0fe40001741470ULL,
0x000000526700720cULL, 0x080fe40001f61470ULL, 0x000000529100720cULL, 0x000fc40000f21470ULL,
0x000000529700720cULL, 0x080fe40002781470ULL, 0x000000529d00720cULL, 0x080fe40002fa1470ULL,
0x0000002153a37812ULL, 0x000fe400078efcffULL, 0x000000526500720cULL, 0x0c0fe40000701070ULL,
0x000000526500720cULL, 0x0c0fe40001741070ULL, 0x000000526500720cULL, 0x000fc40001f61070ULL,
0x000000528f00720cULL, 0x080fe40000f21070ULL, 0x000000529500720cULL, 0x080fe40002781070ULL,
0x000000529b00720cULL, 0x000fe40002fa1070ULL, 0x00000072cda17219ULL, 0x000fe400000006ffULL,
0x00005410cf787816ULL, 0x000fe20000000078ULL, 0x00000001a3a57824ULL, 0x000fe200078e025dULL,
0xff8000004a4a7808ULL, 0x000fc40000000000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x0000006693ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c93ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006699ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006a9fff7212ULL, 0x040fe4000782c0ffULL,
0x0000006c9fff7212ULL, 0x000fe4000788c0ffULL, 0x00000078a1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a57c7824ULL, 0x000fe200078e0a7aULL, 0x000000529100720cULL, 0x000fc40000701470ULL,
0x000000529100720cULL, 0x080fe40001741470ULL, 0x000000529700720cULL, 0x080fe40001f61470ULL,
0x000000529d00720cULL, 0x0c0fe40000f21470ULL, 0x000000529d00720cULL, 0x080fe40002781470ULL,
0x000000527b00720cULL, 0x000fe40002fa1470ULL, 0x0000002853a97812ULL, 0x000fc400078efcffULL,
0x0000002953af7812ULL, 0x000fe400078efcffULL, 0x000000528f00720cULL, 0x0c0fe40000701070ULL,
0x000000528f00720cULL, 0x080fe40001741070ULL, 0x000000529500720cULL, 0x080fe40001f61070ULL,
0x000000529b00720cULL, 0x0c0fe40000f21070ULL, 0x000000529b00720cULL, 0x000fc40002781070ULL,
0x000000527900720cULL, 0x000fe40002fa1070ULL, 0x0000007ccda77219ULL, 0x000fe400000006ffULL,
0x0000541083767816ULL, 0x000fe40000000076ULL, 0x00005410d38c7816ULL, 0x000fe4000000008cULL,
0x00005410d7907816ULL, 0x000fe20000000090ULL, 0x00000001a9ab7824ULL, 0x100fe200078e025dULL,
0xff80000041417808ULL, 0x000fe20000000000ULL, 0x00000001afb17824ULL, 0x000fe200078e025dULL,
0xff8000001e1e7808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40002800000ULL, 0x000000548bff7212ULL, 0x000fe400078cc0ffULL,
0x0000006a99ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c99ff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a1ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008ca1ff7212ULL, 0x040fe4000782c0ffULL,
0x00000090a1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ca7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab7e7824ULL, 0x100fe200078e0a7aULL, 0x000000528100720cULL, 0x080fe200037c1470ULL,
0x00000001b17a7824ULL, 0x000fe200078e0a7aULL, 0x000000529700720cULL, 0x000fc40000701470ULL,
0x000000529700720cULL, 0x080fe40001741470ULL, 0x000000527b00720cULL, 0x0c0fe40001f61470ULL,
0x000000527b00720cULL, 0x0c0fe40000f21470ULL, 0x000000527b00720cULL, 0x080fe40002781470ULL,
0x00000052a500720cULL, 0x080fe40002fa1470ULL, 0x000000528900720cULL, 0x000fc400037c1070ULL,
0x000000529500720cULL, 0x0c0fe40000701070ULL, 0x000000529500720cULL, 0x080fe40001741070ULL,
0x000000527900720cULL, 0x0c0fe40001f61070ULL, 0x000000527900720cULL, 0x0c0fe40000f21070ULL,
0x000000527900720cULL, 0x080fe40002781070ULL, 0x00000052a300720cULL, 0x000fc40002fa1070ULL,
0x0000007ecdad7219ULL, 0x040fe400000006ffULL, 0x0000007acdb37219ULL, 0x000fe400000006ffULL,
0xff8000004b4b7808ULL, 0x000fe40003000000ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001000000ULL, 0xff80000050507808ULL, 0x000fc40001800000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40002000000ULL,
0xff80000036367808ULL, 0x000fe40002800000ULL, 0x000000649fff7212ULL, 0x000fe400078cc0ffULL,
0x00000076a7ff7212ULL, 0x080fe4000780c0ffULL, 0x00000076adff7212ULL, 0x000fc4000784c0ffULL,
0x00000078a7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000090a7ff7212ULL, 0x000fe4000782c0ffULL,
0x00000078adff7212ULL, 0x000fe4000788c0ffULL, 0x0000008cb3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b7827824ULL, 0x000fe200078e0a80ULL, 0x000000529d00720cULL, 0x080fe400037c1470ULL,
0x00000052a500720cULL, 0x000fc40000701470ULL, 0x00000052a500720cULL, 0x0c0fe40001f61470ULL,
0x00000052a500720cULL, 0x080fe40000f21470ULL, 0x00000052ab00720cULL, 0x0c0fe40001741470ULL,
0x00000052ab00720cULL, 0x080fe40002781470ULL, 0x00000052b100720cULL, 0x000fe40002fa1470ULL,
0x0000003153bd7812ULL, 0x000fc400078efcffULL, 0x0000003853c37812ULL, 0x040fe400078efcffULL,
0x0000003953c97812ULL, 0x000fe400078efcffULL, 0x000000529b00720cULL, 0x080fe400037c1070ULL,
0x00000052a300720cULL, 0x0c0fe40000701070ULL, 0x00000052a300720cULL, 0x0c0fe40001f61070ULL,
0x00000052a300720cULL, 0x000fc40000f21070ULL, 0x00000052a900720cULL, 0x0c0fe40001741070ULL,
0x00000052a900720cULL, 0x080fe40002781070ULL, 0x00000052af00720cULL, 0x000fe40002fa1070ULL,
0x00000082cdbb7219ULL, 0x000fe400000006ffULL, 0x00005410b9867816ULL, 0x000fe40000000086ULL,
0x00005410d58e7816ULL, 0x000fe2000000008eULL, 0x00000001bdbf7824ULL, 0x100fe200078e025dULL,
0xff8000004e4e7808ULL, 0x000fe20003000000ULL, 0x00000001c3c57824ULL, 0x100fe200078e025dULL,
0xff80000048487808ULL, 0x000fe20000000000ULL, 0x00000001c9cb7824ULL, 0x000fe200078e025dULL,
0xff80000040407808ULL, 0x000fc40001800000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000047477808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0xff80000038387808ULL, 0x000fe40002800000ULL, 0x00000076b3ff7212ULL, 0x040fe400078cc0ffULL,
0x00000078b3ff7212ULL, 0x000fc4000780c0ffULL, 0x0000008cadff7212ULL, 0x040fe4000786c0ffULL,
0x00000090adff7212ULL, 0x080fe4000782c0ffULL, 0x00000090b3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000086bbff7212ULL, 0x040fe4000788c0ffULL, 0x0000008ebbff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bf847824ULL, 0x100fe200078e0a80ULL, 0x00000052ab00720cULL, 0x080fe20001f61470ULL,
0x00000001c5887824ULL, 0x100fe200078e0a80ULL, 0x00000052ab00720cULL, 0x080fe20000f21470ULL,
0x00000001cb807824ULL, 0x000fe200078e0a80ULL, 0x00000052b100720cULL, 0x000fc400037c1470ULL,
0x00000052b100720cULL, 0x0c0fe40000701470ULL, 0x00000052b100720cULL, 0x080fe40001741470ULL,
0x00000052b700720cULL, 0x0c0fe40002781470ULL, 0x00000052b700720cULL, 0x000fe40002fa1470ULL,
0x00000084cdc17219ULL, 0x040fe400000006ffULL, 0x00000088cdc77219ULL, 0x000fc400000006ffULL,
0x00000052a900720cULL, 0x0c0fe40001f61070ULL, 0x00000052a900720cULL, 0x080fe40000f21070ULL,
0x00000052af00720cULL, 0x0c0fe400037c1070ULL, 0x00000052af00720cULL, 0x0c0fe40000701070ULL,
0x00000052af00720cULL, 0x080fe40001741070ULL, 0x00000052b500720cULL, 0x000fc40002781070ULL,
0x00000052b500720cULL, 0x000fe40002fa1070ULL, 0x00000080cdcd7219ULL, 0x000fe400000006ffULL,
0x00005410d18a7816ULL, 0x000fe4000000008aULL, 0xff80000037377808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff8000000b0b7808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x00000086c1ff7212ULL, 0x080fe4000786c0ffULL, 0x00000086c7ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086cdff7212ULL, 0x000fe400078cc0ffULL, 0x0000008abbff7212ULL, 0x080fe4000780c0ffULL,
0x0000008ac1ff7212ULL, 0x080fe4000784c0ffULL, 0x0000008ac7ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008ec1ff7212ULL, 0x000fe400078ac0ffULL, 0x00000052b700720cULL, 0x000fc40000701470ULL,
0x00000052bf00720cULL, 0x0c0fe40001f61470ULL, 0x00000052bf00720cULL, 0x0c0fe40001741470ULL,
0x00000052bf00720cULL, 0x080fe40002fa1470ULL, 0x00000052c500720cULL, 0x080fe40000f21470ULL,
0x00000052cb00720cULL, 0x080fe400037c1470ULL, 0x00000052c500720cULL, 0x000fc40002781470ULL,
0x00000052b500720cULL, 0x080fe40000701070ULL, 0x00000052bd00720cULL, 0x0c0fe40001f61070ULL,
0x00000052bd00720cULL, 0x0c0fe40001741070ULL, 0x00000052bd00720cULL, 0x080fe40002fa1070ULL,
0x00000052c300720cULL, 0x080fe40000f21070ULL, 0x00000052c900720cULL, 0x000fc400037c1070ULL,
0x00000052c300720cULL, 0x000fe40002781070ULL, 0x00005410d9927816ULL, 0x000fe40000000092ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff8000003a3a7808ULL, 0x000fc40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fe40003000000ULL,
0xff8000003e3e7808ULL, 0x000fe40002000000ULL, 0x0000008acdff7212ULL, 0x000fe4000780c0ffULL,
0x0000008ec7ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ecdff7212ULL, 0x000fc4000784c0ffULL,
0x00000092bbff7212ULL, 0x080fe400078ac0ffULL, 0x00000092c1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000092c7ff7212ULL, 0x080fe400078cc0ffULL, 0x00000092cdff7212ULL, 0x000fe4000788c0ffULL,
0x00000052b700720cULL, 0x080fe40002fa1470ULL, 0x00000052bf00720cULL, 0x000fc40000f21470ULL,
0x00000052c500720cULL, 0x0c0fe40001f61470ULL, 0x00000052c500720cULL, 0x080fe400037c1470ULL,
0x00000052cb00720cULL, 0x0c0fe40000701470ULL, 0x00000052cb00720cULL, 0x0c0fe40001741470ULL,
0x00000052cb00720cULL, 0x080fe40002781470ULL, 0x00000052b500720cULL, 0x000fc40002fa1070ULL,
0x00000052bd00720cULL, 0x080fe40000f21070ULL, 0x00000052c900720cULL, 0x080fe40000701070ULL,
0x00000052c300720cULL, 0x0c0fe40001f61070ULL, 0x00000052c300720cULL, 0x080fe400037c1070ULL,
0x00000052c900720cULL, 0x0c0fe40001741070ULL, 0x00000052c900720cULL, 0x000fc40002781070ULL,
0xff8000003d3d7808ULL, 0x000fe40000000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0xff8000000d0d7808ULL, 0x000fe40000800000ULL, 0xff8000000e0e7808ULL, 0x000fc40003000000ULL,
0xff8000000f0f7808ULL, 0x000fc40002000000ULL, 0x0000004f0400720bULL, 0x004fe40003f1e000ULL,
0x000000280500720bULL, 0x000fe40003f3e000ULL, 0x000000290600720bULL, 0x000fe40003f5e000ULL,
0x000000220700720bULL, 0x000fe40003f7e000ULL, 0x000000044f047208ULL, 0x000fe40004000000ULL,
0x0000000528527208ULL, 0x000fc40004800000ULL, 0x0000000629057208ULL, 0x000fe40005000000ULL,
0x0000000722077208ULL, 0x000fe40005800000ULL, 0x0000004d0400720bULL, 0x000fe40003f1e000ULL,
0x000000275200720bULL, 0x000fe40003f3e000ULL, 0x000000260500720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fc40003f7e000ULL, 0x000000044d537208ULL, 0x000fe40004000000ULL,
0x0000005227527208ULL, 0x000fe40004800000ULL, 0x0000000526057208ULL, 0x000fe40005000000ULL,
0x0000000720047208ULL, 0x000fe40005800000ULL, 0x0000004c5300720bULL, 0x000fe40003f1e000ULL,
0x000000255200720bULL, 0x000fc40003f3e000ULL, 0x000000240500720bULL, 0x000fe40003f5e000ULL,
0x000000130400720bULL, 0x000fe40003f7e000ULL, 0x000000534c067208ULL, 0x000fe40004000000ULL,
0x0000005225527208ULL, 0x000fe40004800000ULL, 0x0000000524547208ULL, 0x000fe40005000000ULL,
0x0000000413057208ULL, 0x000fc40005800000ULL, 0x0000004b0600720bULL, 0x000fe40003f1e000ULL,
0x000000235200720bULL, 0x000fe40003f3e000ULL, 0x000000215400720bULL, 0x000fe40003f5e000ULL,
0x0000001c0500720bULL, 0x000fe40003f7e000ULL, 0x000000064b077208ULL, 0x000fe40004000000ULL,
0x0000005223537208ULL, 0x000fc40004800000ULL, 0x0000005421547208ULL, 0x000fe40005000000ULL,
0x000000051c047208ULL, 0x000fe40005800000ULL, 0x0000004a0700720bULL, 0x000fe40003f1e000ULL,
0x0000002a5300720bULL, 0x000fe40003f3e000ULL, 0x000000315400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0400720bULL, 0x000fc40003f7e000ULL, 0x000000074a067208ULL, 0x000fe40004000000ULL,
0x000000532a527208ULL, 0x000fe40004800000ULL, 0x0000005431057208ULL, 0x000fe40005000000ULL,
0x000000041f077208ULL, 0x000fe40005800000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x000000415200720bULL, 0x000fc40003f3e000ULL, 0x000000320500720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x0000000649067208ULL, 0x000fe40004000000ULL,
0x0000005241527208ULL, 0x000fe40004800000ULL, 0x0000000532047208ULL, 0x000fe40005000000ULL,
0x000000071e547208ULL, 0x000fc40005800000ULL, 0x000000510600720bULL, 0x000fe40003f1e000ULL,
0x0000002b5200720bULL, 0x000fe40003f3e000ULL, 0x000000330400720bULL, 0x000fe40003f5e000ULL,
0x0000001d5400720bULL, 0x000fe40003f7e000ULL, 0x0000000651057208ULL, 0x000fe40004000000ULL,
0x000000522b527208ULL, 0x000fc40004800000ULL, 0x0000000433077208ULL, 0x000fe40005000000ULL,
0x000000541d537208ULL, 0x000fe40005800000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x0000002d5200720bULL, 0x000fe40003f3e000ULL, 0x000000340700720bULL, 0x000fe40003f5e000ULL,
0x000000125300720bULL, 0x000fc40003f7e000ULL, 0x000000054e057208ULL, 0x000fe40004000000ULL,
0x000000522d557208ULL, 0x000fe40004800000ULL, 0x0000000734047208ULL, 0x000fe40005000000ULL,
0x0000005312067208ULL, 0x000fe40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x0000002c5500720bULL, 0x000fc40003f3e000ULL, 0x000000350400720bULL, 0x000fe40003f5e000ULL,
0x000000110600720bULL, 0x000fe40003f7e000ULL, 0x0000000550057208ULL, 0x000fe40004000000ULL,
0x000000552c557208ULL, 0x000fe40004800000ULL, 0x0000000435077208ULL, 0x000fe40005000000ULL,
0x0000000611537208ULL, 0x000fc40005800000ULL, 0x000000480500720bULL, 0x000fe40003f1e000ULL,
0x000000405500720bULL, 0x000fe40003f3e000ULL, 0x000000360700720bULL, 0x000fe40003f5e000ULL,
0x000000105300720bULL, 0x000fe40003f7e000ULL, 0x0000000548047208ULL, 0x000fe40004000000ULL,
0x0000005540557208ULL, 0x000fc40004800000ULL, 0x0000000736067208ULL, 0x000fe40005000000ULL,
0x0000005310537208ULL, 0x000fe40005800000ULL, 0x000000470400720bULL, 0x000fe40003f1e000ULL,
0x0000002e5500720bULL, 0x000fe40003f3e000ULL, 0x000000370600720bULL, 0x000fe40003f5e000ULL,
0x0000000a5300720bULL, 0x000fc40003f7e000ULL, 0x0000000447057208ULL, 0x000fe40004000000ULL,
0x000000552e047208ULL, 0x000fe40004800000ULL, 0x0000000637077208ULL, 0x000fe40005000000ULL,
0x000000530a067208ULL, 0x000fe40005800000ULL, 0x000000460500720bULL, 0x000fe40003f1e000ULL,
0x000000390400720bULL, 0x000fc40003f3e000ULL, 0x000000380700720bULL, 0x000fe40003f5e000ULL,
0x0000000b0600720bULL, 0x000fe40003f7e000ULL, 0x0000000546527208ULL, 0x000fe40004000000ULL,
0x0000000439047208ULL, 0x000fe40004800000ULL, 0x0000000738547208ULL, 0x000fe40005000000ULL,
0x000000060b057208ULL, 0x000fc40005800000ULL, 0x000000455200720bULL, 0x000fe40003f1e000ULL,
0x0000002f0400720bULL, 0x000fe40003f3e000ULL, 0x0000003f5400720bULL, 0x000fe40003f5e000ULL,
0x0000000c0500720bULL, 0x000fe40003f7e000ULL, 0x0000005245077208ULL, 0x000fe40004000000ULL,
0x000000042f537208ULL, 0x000fc40004800000ULL, 0x000000543f557208ULL, 0x000fe40005000000ULL,
0x000000050c047208ULL, 0x000fe40005800000ULL, 0x000000440700720bULL, 0x000fe40003f1e000ULL,
0x000000305300720bULL, 0x000fe40003f3e000ULL, 0x0000003a5500720bULL, 0x000fe40003f5e000ULL,
0x0000000d0400720bULL, 0x000fc40003f7e000ULL, 0x0000000744067208ULL, 0x000fe40004000000ULL,
0x0000005330537208ULL, 0x000fe40004800000ULL, 0x000000553a527208ULL, 0x000fe40005000000ULL,
0x000000040d057208ULL, 0x000fe40005800000ULL, 0x000000430600720bULL, 0x000fe40003f1e000ULL,
0x0000003e5300720bULL, 0x000fc40003f3e000ULL, 0x0000003b5200720bULL, 0x000fe40003f5e000ULL,
0x0000000e0500720bULL, 0x000fe40003f7e000ULL, 0x0000000643077208ULL, 0x000fe40004000000ULL,
0x000000533e047208ULL, 0x000fe40004800000ULL, 0x000000523b537208ULL, 0x000fe40005000000ULL,
0x000000050e067208ULL, 0x000fc40005800000ULL, 0x000000420700720bULL, 0x000fe40003f1e000ULL,
0x0000003d0400720bULL, 0x000fe40003f3e000ULL, 0x0000003c5300720bULL, 0x000fe40003f5e000ULL,
0x0000000f0600720bULL, 0x000fe40003f7e000ULL, 0x0000000742077208ULL, 0x000fe40004000000ULL,
0x000000043d547208ULL, 0x000fc40004800000ULL, 0x000000533c587208ULL, 0x000fe40005000000ULL,
0x000000060f577208ULL, 0x000fe20005800000ULL, 0x000022927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704597208ULL, 0x000fe20004000000ULL, 0x000022c27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0054047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0058057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0057067f89ULL, 0x000e6200000e0000ULL, 0x000000045400720bULL, 0x008fc40003f1e000ULL,
0x000000055800720bULL, 0x010fe40003f3e000ULL, 0x0000005404077208ULL, 0x006fe40004000000ULL,
0x0000005805527208ULL, 0x000fe20004800000ULL, 0x0c201f0059047f89ULL, 0x000e6200000e0000ULL,
0x000000065700720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007567f89ULL, 0x000ea200000e0000ULL,
0x0000005706547208ULL, 0x000fc60004000000ULL, 0x0c201f0052537f89ULL, 0x000ee800000e0000ULL,
0x0c201f0054557f89ULL, 0x0002e400000e0000ULL, 0x000000045900720bULL, 0x002fe40003f1e000ULL,
0x000000560700720bULL, 0x004fe40003f3e000ULL, 0x0000005904047208ULL, 0x000fc40004000000ULL,
0x000000535200720bULL, 0x008fe40003f5e000ULL, 0x0000000756057208ULL, 0x000fe40004800000ULL,
0x0000005253067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002ff687819ULL, 0x000fe20000011614ULL, 0x3fb8aa3b49537823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b50497823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x0000004d00527308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b45457823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b43437823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b06077820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b05507820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b24247823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b35357823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x000fe20000010807ULL, 0x0000005455077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010850ULL, 0x0000000314ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010850ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe40000010850ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010850ULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010850ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010850ULL,
0x0000002d00587308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010850ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010850ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fe40000010850ULL,
0x0000000868677824ULL, 0x000fe200078e00ffULL, 0x0000002300567308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b072d7820ULL, 0x004fc40000410000ULL, 0x0000000868557824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL,
0x0000002e00577308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe4000001082dULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc40000010850ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe40000010850ULL, 0x3fb8aa3b40407823ULL, 0x100fe40000010850ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010850ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010850ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x000fc40000010850ULL,
0x0000000868697824ULL, 0x040fe400078e00ffULL, 0x00000008686b7824ULL, 0x040fe400078e00ffULL,
0x00000008686d7824ULL, 0x040fe200078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082dULL, 0x00000008686f7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b12127823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001082dULL,
0x0000003000647308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0f547823ULL, 0x000fce000001082dULL,
0x0000002200237308ULL, 0x0007f00000000800ULL, 0x00000020002e7308ULL, 0x0008620000000800ULL,
0x0000000868227824ULL, 0x008fce00078e00ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000000368207810ULL, 0x010fc80007ffe0ffULL, 0xfffffff867677812ULL, 0x000fe200078ee220ULL,
0x3fb8aa3b1e207823ULL, 0x100fe2000001082dULL, 0x00000005681e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001c00307308ULL, 0x0007260000000800ULL, 0xfffffff86b6b7812ULL, 0x000fe400078ee21eULL,
0x0000004c4b1e723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b0c4c7823ULL, 0x000fe4000001082dULL,
0x00000039005a7308ULL, 0x000fe20000000800ULL, 0x00000004681c7810ULL, 0x008fc80007ffe0ffULL,
0xfffffff869697812ULL, 0x000fe400078ee21cULL, 0x0000004f521c723eULL, 0x000fe200000000ffULL,
0x0000002c004d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d4f7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b0e527823ULL, 0x000fca000001082dULL, 0x0000003500397308ULL, 0x0003f00000000800ULL,
0x00000034002c7308ULL, 0x0007e20000000800ULL, 0x0000000268357810ULL, 0x002fc80007ffe0ffULL,
0xfffffff822657812ULL, 0x000fe200078ee235ULL, 0x3fb8aa3b1d227823ULL, 0x000fe2000001082dULL,
0x00000028271d723eULL, 0x004fe200000000ffULL, 0x0000003800507308ULL, 0x000fe20000000800ULL,
0x0000000168347810ULL, 0x008fe20007ffe0ffULL, 0x3c003c00ff357424ULL, 0x000fc600078e00ffULL,
0xfffffff855557812ULL, 0x000fe400078ee234ULL, 0x0000000668347810ULL, 0x000fe20007ffe0ffULL,
0x0000002000387308ULL, 0x0003e60000000800ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee234ULL,
0x3c003c00ff347424ULL, 0x000fc800078e00ffULL, 0x0000003a00667308ULL, 0x000fe20000000800ULL,
0xffffffff68207810ULL, 0x002fc80007ffe0ffULL, 0xfffffff86f6f7812ULL, 0x000fe400078ee220ULL,
0x000000292620723eULL, 0x000fe200000000ffULL, 0x0000002f00597308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b10297823ULL, 0x000fce000001082dULL, 0x00000022003a7308ULL, 0x0003f00000000800ULL,
0x0000001f002f7308ULL, 0x0005e20000000800ULL, 0x000000242122723eULL, 0x002fe400000000ffULL,
0x000000232e21723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0a2e7823ULL, 0x100fe2000001082dULL,
0x000000133023723eULL, 0x010fe200000000ffULL, 0x3fb8aa3b0b307823ULL, 0x000fc4000001082dULL,
0x0000003b005b7308ULL, 0x000fe20000000800ULL, 0x00000025561f723eULL, 0x004fce00000000ffULL,
0x00000012003b7308ULL, 0x000fe20000000800ULL, 0x000000341c24723cULL, 0x080f6e00000018ffULL,
0x00000011004b7308ULL, 0x0003f00000000800ULL, 0x0000004a004a7308ULL, 0x000ea20000000800ULL,
0x000000342010723cULL, 0x002f6e00000018ffULL, 0x0000005100517308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x0000004a530c723eULL, 0x004fc400000000ffULL,
0x0000001068537810ULL, 0x000fca0007ffe0ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x000000514e0e723eULL, 0x002fe400000000ffULL,
0x0000000868517810ULL, 0x000fca0007ffe0ffULL, 0x0000002b002b7308ULL, 0x000e700000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x0000002a410d723eULL, 0x004fe200000000ffULL,
0x0000000868417824ULL, 0x000fca00078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee268ULL,
0x0000003200327308ULL, 0x000ea20000000800ULL, 0x0000002b580f723eULL, 0x002fe400000000ffULL,
0x0000003a3b2b723eULL, 0x000fe400000000ffULL, 0x0000001868687810ULL, 0x000fc60007ffe0ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000340c24723cULL, 0x020f620000001824ULL,
0x0000000868717824ULL, 0x000fca00078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee268ULL,
0x00000029000a7308ULL, 0x0007e20000000800ULL, 0x000000313228723eULL, 0x004fe400000000ffULL,
0x000000596431723eULL, 0x000fe400000000ffULL, 0x000000332c2a723eULL, 0x002fc600000000ffULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x0000002f3829723eULL, 0x008fe200000000ffULL,
0x00000008512c7824ULL, 0x000fe200078e00ffULL, 0x000000575a2f723eULL, 0x000fc800000000ffULL,
0xfffffff82c517812ULL, 0x000fe200078ee251ULL, 0x0000004800487308ULL, 0x000e620000000800ULL,
0x000000342810723cULL, 0x000f6e0000001810ULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x00000049482c723eULL, 0x002fce00000000ffULL,
0x0000004000407308ULL, 0x000e700000000800ULL, 0x0000003600367308ULL, 0x000eb00000000800ULL,
0x0000003700377308ULL, 0x000ee20000000800ULL, 0x0000004d402d723eULL, 0x002fce00000000ffULL,
0x0000002e000b7308ULL, 0x0003e20000000800ULL, 0x000000393638723eULL, 0x004fe400000000ffULL,
0x0000004b0a39723eULL, 0x000fe400000000ffULL, 0x0000000c090a7812ULL, 0x000fe400078ec0ffULL,
0x000120001a367811ULL, 0x000fe200078e60ffULL, 0x00000030004a7308ULL, 0x000ea20000000800ULL,
0x00000008532e7824ULL, 0x002fe200078e00ffULL, 0x00000037503a723eULL, 0x008fc400000000ffULL,
0x0000001041417824ULL, 0x100fe400078e0236ULL, 0xfffffff82e537812ULL, 0x000fe200078ee253ULL,
0x0000001055557824ULL, 0x100fe200078e0236ULL, 0x00000047462e723eULL, 0x000fe200000000ffULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x0000001065657824ULL, 0x100fe400078e0236ULL,
0x0000001067677824ULL, 0x100fe400078e0236ULL, 0x0000001069697824ULL, 0x000fe200078e0236ULL,
0x000000342c24723cULL, 0x020f620000001824ULL, 0x0000000b4a3b723eULL, 0x004fe200000000ffULL,
0x0000004400447308ULL, 0x000e620000000800ULL, 0x00000001410b7824ULL, 0x000fc400078e020aULL,
0x000000106b6b7824ULL, 0x100fe400078e0236ULL, 0x000000010a557824ULL, 0x040fe200078e0255ULL,
0x000000343810723cULL, 0x000fe20000001810ULL, 0x000000106d6d7824ULL, 0x100fe200078e0236ULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000010a657824ULL, 0x040fe200078e0265ULL,
0x0000001c0b007388ULL, 0x0005e20000000800ULL, 0x000000106f6f7824ULL, 0x100fe400078e0236ULL,
0x000000010a677824ULL, 0x000fe200078e0267ULL, 0x0000001e55007388ULL, 0x0007e20000000800ULL,
0x0000001051517824ULL, 0x000fe200078e0236ULL, 0x0000004200427308ULL, 0x000f220000000800ULL,
0x000000454430723eULL, 0x002fe200000000ffULL, 0x000000010a697824ULL, 0x040fe200078e0269ULL,
0x0000000c65007388ULL, 0x0007e20000000800ULL, 0x000000010a6b7824ULL, 0x000fc400078e026bULL,
0x000000010a6d7824ULL, 0x040fe200078e026dULL, 0x0000000e67007388ULL, 0x0007e20000000800ULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x000000010a6f7824ULL, 0x040fe400078e026fULL,
0x000000010a1c7824ULL, 0x004fe200078e0251ULL, 0x0000002c69007388ULL, 0x0007e20000000800ULL,
0x0000001053537824ULL, 0x100fe400078e0236ULL, 0x0000001071717824ULL, 0x000fe200078e0236ULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x000000434232723eULL, 0x010fe200000000ffULL,
0x0000002e6b007388ULL, 0x0007e20000000800ULL, 0x000000010a537824ULL, 0x000fc400078e0253ULL,
0x000000010a0a7824ULL, 0x000fe200078e0271ULL, 0x000000306d007388ULL, 0x0007e40000000800ULL,
0x0000003f003f7308ULL, 0x000ea40000000800ULL, 0x000000326f007388ULL, 0x0007e80000000800ULL,
0x0000001d1c007388ULL, 0x0007e40000000800ULL, 0x0000003c003c7308ULL, 0x000f220000000800ULL,
0x0000003e3d33723eULL, 0x002fe200000000ffULL, 0x0004001f55007388ULL, 0x0007e80000000800ULL,
0x0004000d65007388ULL, 0x0007e40000000800ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x0000003f6640723eULL, 0x004fe200000000ffULL, 0x000000343024723cULL, 0x020f620000001824ULL,
0x0004000f67007388ULL, 0x0007e80000000800ULL, 0x0004002d69007388ULL, 0x0007e20000000800ULL,
0x0000004f004f7308ULL, 0x000e620000000800ULL, 0x0000005b3c42723eULL, 0x010fc400000000ffULL,
0x0004002f6b007388ULL, 0x0007e80000000800ULL, 0x000400316d007388ULL, 0x0007e20000000800ULL,
0x0000005200527308ULL, 0x000fe60000000800ULL, 0x000400336f007388ULL, 0x0007e80000000800ULL,
0x0000002053007388ULL, 0x0007e20000000800ULL, 0x0000005400097308ULL, 0x000ea20000000800ULL,
0x0000004c4f41723eULL, 0x002fe200000000ffULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0008002255007388ULL, 0x0007e80000000800ULL, 0x0008002865007388ULL, 0x0007e80000000800ULL,
0x0008002a67007388ULL, 0x0007e80000000800ULL, 0x0008003869007388ULL, 0x0007e20000000800ULL,
0x000000520943723eULL, 0x004fc600000000ffULL, 0x0008003a6b007388ULL, 0x0007e80000000800ULL,
0x000000344010723cULL, 0x000f620000001810ULL, 0x000800406d007388ULL, 0x0007e80000000800ULL,
0x000800426f007388ULL, 0x0007e80000000800ULL, 0x000000210a007388ULL, 0x0007e80000000800ULL,
0x000c002355007388ULL, 0x0007e80000000800ULL, 0x000c002965007388ULL, 0x0007e80000000800ULL,
0x000c002b67007388ULL, 0x0007e60000000800ULL, 0x000000ffff267224ULL, 0x020fe200078e0010ULL,
0x000c003969007388ULL, 0x0007e20000000800ULL, 0x000000ffff277224ULL, 0x000fc600078e0012ULL,
0x000c003b6b007388ULL, 0x0007e80000000800ULL, 0x000c00416d007388ULL, 0x0007e80000000800ULL,
0x000c00436f007388ULL, 0x0007e80000000800ULL, 0x01a0000408008388ULL, 0x0007e80000000c00ULL,
0x01a2002408008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008005eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010005eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000015c5c7810ULL, 0x000fe20007ffe0ffULL, 0x000018005eff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff657224ULL, 0x008fc400078e005fULL, 0x000000155c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff8ad000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000182d000267802ULL, 0x000fc40000000f00ULL,
0x000013f000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0025ULL,
0xfffea79000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001833000267802ULL, 0x000fc40000000f00ULL,
0x0000139000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0025ULL,
0xfffea7c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001839000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000012e000007944ULL, 0x002fea0003c00000ULL, 0xfffea88000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x000183e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000129000007944ULL, 0x002fea0003c00000ULL,
0xfffea9a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001843000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000124000007944ULL, 0x002fea0003c00000ULL, 0xfffeaac000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x0001848000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000011f000007944ULL, 0x002fea0003c00000ULL,
0xfffeabd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x000184e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000119000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffeafe000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x0001854000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000113000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001002267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x000185a000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000010d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffeaf7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x0001860000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000107000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffeaf4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001866000267802ULL, 0x000fc40000000f00ULL, 0x0000106000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0025ULL, 0xfffed04000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000186c000267802ULL, 0x000fc40000000f00ULL, 0x0000100000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffed08000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x0001872000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000f5000007944ULL, 0x004fea0003c00000ULL,
0xfffed14000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001877000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000f0000007944ULL, 0x006fea0003c00000ULL, 0xfffed26000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x000187c000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000eb000007944ULL, 0x00efea0003c00000ULL,
0xfffed38000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001881000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x00efea0003c00000ULL, 0xfffed49000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001eULL, 0x0001887000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000e0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffed89000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x000188d000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000101e267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001893000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000d4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffed82000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001899000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffed7f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000189f000267802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xfffef86000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00018a5000267802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff237224ULL, 0x000fe200078e0025ULL,
0xfffef8a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x00018ab000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xfffef96000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018b0000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000b7000007944ULL, 0x002fea0003c00000ULL,
0xfffefa8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x00018b5000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000b2000007944ULL, 0x002fea0003c00000ULL, 0xfffefba000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018ba000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x002fea0003c00000ULL,
0xfffefcb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0024ULL,
0x00018c0000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000a7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff00b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018c6000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000a1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001024267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018cc000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000009b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff004000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018d2000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000095000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff001000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00018d8000267802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0025ULL, 0xffff1f3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00018de000267802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0xffff1f7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018e4000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x000fea0003c00000ULL,
0xffff203000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x00018e9000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000007e000007944ULL, 0x002fea0003c00000ULL, 0xffff215000007947ULL, 0x000fea000383ffffULL,
0x0000001fff717424ULL, 0x000fe200078e00ffULL, 0x00018ee000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000079000007944ULL, 0x002fea0003c00000ULL,
0xffff227000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x00018f3000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000074000007944ULL, 0x002fea0003c00000ULL, 0xffff238000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000aULL, 0x00018f9000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000006e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff277000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x00018ff000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000068000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000100a267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x0001905000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff270000007947ULL, 0x000fea000383ffffULL, 0x0000001fff717424ULL, 0x000fe200078e00ffULL,
0x000190b000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff26d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0001912000527802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0055ULL, 0xffffdd1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e0054ULL, 0x000191a000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe400078e00ffULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x0001922000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005455067208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x000192a000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855587208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000555700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0059ULL,
0x0001932000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005755547208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000555900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x000193a000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005955047208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000550600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x0001942000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000000655057208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x000194a000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855067208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdb0000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe69d002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005a00007348ULL, 0x000fe80003800000ULL, 0x0c00005607557389ULL, 0x0002a200000e0055ULL,
0xfffe699052007950ULL, 0x000fea0003c3ffffULL, 0x0000006a00007348ULL, 0x000fe80003800000ULL,
0x0000002627267389ULL, 0x0002a200000e0071ULL, 0x00000000ff6b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff6a7224ULL, 0x002fc800078e0025ULL, 0xfffe69406a007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f65070ULL, 0x0000002700007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000002725257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe68e026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c70ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d30ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019800ULL, 0xdc00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b080ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b0c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b440ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019a00ULL,
0x0000000000019a00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b080ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b440ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin_len = 111904;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
