/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000143c0ULL, 0x0000000000014040ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x00000000000129e0ULL,
0x0000000000000220ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012c00ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000129e000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000129e000000000ULL, 0x0000022000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x000823040000007fULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL, 0x0000001700081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d000942804ULL,
0x000009f000000370ULL, 0x00002940000028d0ULL, 0x00002b5000002a10ULL, 0x0000307000003060ULL,
0x00004c5000004be0ULL, 0x00004e7000004d30ULL, 0x0000539000005380ULL, 0x00006f2000006ec0ULL,
0x0000716000007020ULL, 0x000075b0000075a0ULL, 0x00009130000090c0ULL, 0x0000935000009210ULL,
0x000097c0000097b0ULL, 0x0000a8e00000a8d0ULL, 0x00011e2000011b70ULL, 0x0001210000011ed0ULL,
0x000124d000012190ULL, 0x00012700000126c0ULL, 0x0000053004303904ULL, 0x00017600000000ffULL,
0x0000061000040100ULL, 0x0001760800000009ULL, 0x00000720003f0100ULL, 0x0001768800000009ULL,
0x00000860003f0100ULL, 0x000176a800000000ULL, 0x00000960003f0100ULL, 0x000176c800000004ULL,
0x000010b0003f0100ULL, 0x00017600000000ffULL, 0x000011f000080107ULL, 0x000176880000000bULL,
0x00001a6000080101ULL, 0x00000000000000ffULL, 0x00001a9000040107ULL, 0x00000000000000ffULL,
0x00001b1000040101ULL, 0x0000002000000003ULL, 0x00001bd0003f0101ULL, 0x000176c800000017ULL,
0x00001d6000080109ULL, 0x000176c800000035ULL, 0x000025b0003f0109ULL, 0x000176b000000017ULL,
0x0000262000080107ULL, 0x000176b000000048ULL, 0x00002630003f0101ULL, 0x0001760800000034ULL,
0x00002670003f0101ULL, 0x000176080000004bULL, 0x000027e0003f0109ULL, 0x000176080000004bULL,
0x00002d00003f0109ULL, 0x000176a800000016ULL, 0x00002e8000080109ULL, 0x000176a800000036ULL,
0x00003f40003f0109ULL, 0x000176c800000035ULL, 0x00003f60003f0101ULL, 0x0001768800000037ULL,
0x0000400000080101ULL, 0x0000000000000004ULL, 0x00004170003f0109ULL, 0x0000000000000004ULL,
0x00004910003f0109ULL, 0x000176a800000014ULL, 0x0000499000080107ULL, 0x000176a800000056ULL,
0x000049a0003f0101ULL, 0x0001762800000015ULL, 0x000049c0003f0101ULL, 0x000176280000004bULL,
0x00004b30003f0109ULL, 0x000176280000004bULL, 0x00005040003f0109ULL, 0x000176b000000017ULL,
0x000051c000080109ULL, 0x000176b000000037ULL, 0x00006220003f0109ULL, 0x000176c800000034ULL,
0x00006240003f0101ULL, 0x0001769000000053ULL, 0x000062e000080101ULL, 0x0000000000000004ULL,
0x00006450003f0109ULL, 0x0000000000000004ULL, 0x00006bb0003f0109ULL, 0x00000008000000ffULL,
0x00006c2000040107ULL, 0x0000000800000054ULL, 0x00006c30003f0101ULL, 0x000176480000004bULL,
0x00006ca0003f0101ULL, 0x000176480000003dULL, 0x00006e10003f0109ULL, 0x000176480000003dULL,
0x00007320003f0109ULL, 0x000176a800000017ULL, 0x000074a000080109ULL, 0x000176a800000037ULL,
0x000083e0003f0109ULL, 0x0000000000000004ULL, 0x00008410003f0101ULL, 0x0001769800000037ULL,
0x000084c0003f0101ULL, 0x0000000000000004ULL, 0x00008630003f0109ULL, 0x0000000000000004ULL,
0x00008dd0003f0109ULL, 0x00000000000000ffULL, 0x00008e6000040107ULL, 0x000176a800000014ULL,
0x00008e80003f0101ULL, 0x0001766800000037ULL, 0x00008eb0003f0101ULL, 0x0001766800000037ULL,
0x00009020003f0109ULL, 0x0001766800000037ULL, 0x00009510003f0109ULL, 0x000176b000000017ULL,
0x000096b000080109ULL, 0x000176b00000003dULL, 0x0000a530003f0109ULL, 0x0000000000000004ULL,
0x0000a570003f0101ULL, 0x000176a000000004ULL, 0x0000ba60003f0101ULL, 0x00017600000000ffULL,
0x0000d2b000080101ULL, 0x00017600000000ffULL, 0x0000d47000080109ULL, 0x00017600000000ffULL,
0x0000d65000080109ULL, 0x00017600000000ffULL, 0x0000d67000080101ULL, 0x00017600000000ffULL,
0x0000d7e000080109ULL, 0x00017600000000ffULL, 0x0001030000080109ULL, 0x0001768800000006ULL,
0x000104d0003f0101ULL, 0x0001768800000006ULL, 0x00010640003f0109ULL, 0x0001768800000006ULL,
0x00012970003f0109ULL, 0x0001760800000009ULL, 0x00012990003f0101ULL, 0x0001761000000009ULL,
0x000129a0003f0101ULL, 0x0001761800000009ULL, 0x000129b0003f0101ULL, 0x0001762000000009ULL,
0x00053803003f0101ULL, 0x0000b13000201c04ULL, 0x0000b4200000b160ULL, 0x0000b8100000b610ULL,
0x0000d8100000b9c0ULL, 0x000c0504000129d0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0060190300000000ULL, 0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x00000000000129e0ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000077919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff087b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000ea20000000a00ULL,
0x0000000107092836ULL, 0x008fe40000000000ULL, 0x0000000407022825ULL, 0x004fc800078e0004ULL,
0x0000000409042825ULL, 0x000fe400078e0004ULL, 0x0000000602022981ULL, 0x0004e8000c1e1900ULL,
0x0000000604092981ULL, 0x000ae2000c1e1900ULL, 0x0000000800007306ULL, 0x010f220000209000ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x000000ff0800720cULL, 0x000fe20003f65070ULL,
0x0000000000067919ULL, 0x000ea20000002300ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000397919ULL, 0x000ea40000002100ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe000a7836ULL, 0x010fcc0000000000ULL,
0x0000000a000b7305ULL, 0x0008a4000021f000ULL, 0x000000ffff0a7224ULL, 0x010fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x006fc800078e0a0bULL, 0x000000080d0d7224ULL, 0x000fc800078e02ffULL,
0x0000000d0b0b7227ULL, 0x000fe400078e000aULL, 0x00000000000d7919ULL, 0x000e680000002200ULL,
0x000000040b0b7c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a0bULL,
0x0000000408037e24ULL, 0x000fe2000f8e0203ULL, 0x00000000000479c3ULL, 0x000ea80000002600ULL,
0x000000080300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a08ULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x000000080300720cULL, 0x000fda0003f26070ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000008ff0bb212ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000f220000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x010f640000001000ULL, 0x0ffffffe00047836ULL, 0x020fe40000000000ULL,
0x0000000506007c24ULL, 0x002fe2000f8e020dULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x000322000021f000ULL, 0x00001fff06067589ULL, 0x000f6200000e0000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000050b037224ULL, 0x010fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fc800078e0004ULL,
0x0000000500047c24ULL, 0x100fe2000f8e0239ULL, 0x00000005ff397819ULL, 0x000fe20000011639ULL,
0x00000004053b7c27ULL, 0x004fc6000f8e00ffULL, 0x0000007f0400780cULL, 0x040fe20003fa4070ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0a3bULL, 0x00001fff39397589ULL, 0x000f6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x000000040b007e24ULL, 0x000fe4000f8e020aULL,
0x00008400ff0aab82ULL, 0x000f660000000800ULL, 0x0000000b0000720cULL, 0x000fc60003f06070ULL,
0x000000000005d919ULL, 0x000e740000008800ULL, 0x0000000100000824ULL, 0x000fc400078e0a0bULL,
0x000000013b3b0836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x0000000b0000720cULL, 0x000fe40003f26070ULL, 0x000004000000d802ULL, 0x000fd60000000f00ULL,
0x000000013b3b1836ULL, 0x000fe20000000000ULL, 0x0000000bff3bb212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff3a7224ULL, 0x000fc800078e0a3bULL, 0x000000040b3a7e24ULL, 0x000fe4000f8e023aULL,
0x0000000109032824ULL, 0x008fe200078e0a02ULL, 0x000006540509d816ULL, 0x002fe20000000000ULL,
0xff317217ff05d424ULL, 0x000fc800078e00ffULL, 0x00008400ff03ab82ULL, 0x000ee20000000800ULL,
0x000000040400d824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x020fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01760008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404097c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000090812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01760804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404097c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01768804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400050000d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x000000103a3a7824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0a3aULL, 0x0000003a0500720cULL, 0x000fe20003f06070ULL,
0x0000000a0702a224ULL, 0x000fc400078e02ffULL, 0x0000000808137c24ULL, 0x000fe2000f8e02ffULL,
0x00000010050f7446ULL, 0x000fe20003800000ULL, 0x0000000406007824ULL, 0x000fe400078e0239ULL,
0x00000013020e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x00000002000a7824ULL, 0x000fe400078e00ffULL, 0x000000083b157c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c48947ULL, 0x000fea0003800000ULL,
0x0000000800007d06ULL, 0x000e620008209000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000177919ULL, 0x000ee80000008800ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047836ULL, 0x002fe20000000000ULL, 0x00000004ff097819ULL, 0x004fca000001160dULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x000000010a0b7824ULL, 0x000fc800078e0209ULL,
0x000000013a007824ULL, 0x000fe400078e020bULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff117224ULL, 0x004fc800078e0a05ULL, 0x0000000811117c24ULL, 0x000fc8000f8e02ffULL,
0x0000001105057227ULL, 0x000fcc00078e0004ULL, 0x00000000050c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0cULL, 0x0000000805047c24ULL, 0x000fca000f8e0200ULL,
0x0000000804007c0cULL, 0x000fda000bf06070ULL, 0x8000000804040c36ULL, 0x000fe40008000000ULL,
0x000000010c0c0836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0x0000040000047802ULL, 0x000fc80000000f00ULL, 0x0000065417177816ULL, 0x008fce0000000004ULL,
0x000000010c0c1836ULL, 0x000fe20000000000ULL, 0x00000008ff0cac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0cULL, 0x0000000805007c24ULL, 0x000fe2000f8e0200ULL,
0x0000000a0f057248ULL, 0x000fe40007fe0000ULL, 0x00000000170872caULL, 0x000fe200000e0000ULL,
0x0000000115117824ULL, 0x000fe400078e0200ULL, 0x000000100d007824ULL, 0x000fe400078e00ffULL,
0x000000130c047224ULL, 0x000fe400078e0211ULL, 0x00000001050a7824ULL, 0x000fe200078e0a0aULL,
0x000000f000117812ULL, 0x000fe200078ec0ffULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x0000000a0900720cULL, 0x000fe20003f06070ULL, 0x000000010b097824ULL, 0x040fe200078e020dULL,
0x0000001104117212ULL, 0x000fe200078efcffULL, 0x000000100b0a7824ULL, 0x000fc600078e00ffULL,
0x0000000411047c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00a097812ULL, 0x000fe400078ee209ULL,
0x0000000505057c10ULL, 0x000fe40008ffe4ffULL, 0x0000000809097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c46ULL,
0x0000000000b07947ULL, 0x000fea0003800000ULL, 0x0000000800097d06ULL, 0x000e620008209000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000c7919ULL, 0x000ee60000008800ULL, 0x0000000900097308ULL, 0x002e640000001000ULL,
0x0ffffffe090b7836ULL, 0x002fe20000000000ULL, 0x0000040000097802ULL, 0x000fc40000000f00ULL,
0x0000000a0d0a7211ULL, 0x004fc600078fe0ffULL, 0x0000000b00057305ULL, 0x000e62000021f000ULL,
0x000006540c097816ULL, 0x008fe20000000009ULL, 0x000000013a007824ULL, 0x000fe400078e020aULL,
0x000000ffff117224ULL, 0x002fc800078e0a05ULL, 0x0000000811117c24ULL, 0x000fc8000f8e02ffULL,
0x0000001105117227ULL, 0x000fcc00078e0004ULL, 0x0000000011047227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000805057c24ULL, 0x000fca000f8e0200ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000104040836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fe20000000000ULL, 0x00000008ff04ac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000805007c24ULL, 0x000fe2000f8e0200ULL,
0x00000000090872caULL, 0x000fe200000e0000ULL, 0x000000010a097824ULL, 0x000fe400078e020dULL,
0x0000000115057824ULL, 0x000fe400078e0200ULL, 0x000000100d007824ULL, 0x000fe400078e00ffULL,
0x0000001304057224ULL, 0x000fe400078e0205ULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x000000f0000b7812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0xfffffff00a097812ULL, 0x000fe400078ee209ULL, 0x0000000b04047212ULL, 0x000fe400078efcffULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000404047c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000505057c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x0001760008047890ULL, 0x000fe2000fffe03fULL,
0x00009200ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000407047825ULL, 0x002fe200078e0004ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000604387981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x000000ff38097836ULL, 0x004fca0000000000ULL, 0x00000008ff0c7819ULL, 0x000fce0000011609ULL,
0x000000a800208947ULL, 0x000fea0003800000ULL, 0x0000000207077824ULL, 0x000fe200078e00ffULL,
0x000001ff0900780cULL, 0x000fe20003f04070ULL, 0x00000008390b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011639ULL, 0x0000000807087224ULL, 0x000fe200078e0208ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x00000004ff027424ULL, 0x000fe200078e00ffULL,
0x0000000139077812ULL, 0x000fe200078ec0ffULL, 0x000000200a097824ULL, 0x000fe400078e00ffULL,
0x000000013b087824ULL, 0x000fe200078e0208ULL, 0x017688020bff79a7ULL, 0x0003e60008500008ULL,
0x0000000408047c24ULL, 0x000fe2000f8e0209ULL, 0x0000000400000947ULL, 0x000fec0003800000ULL,
0x0000000938027248ULL, 0x002fe20007fe0000ULL, 0x0000001007037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe2000001160dULL, 0x0000900000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000102027824ULL, 0x000fe400078e0a09ULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x0000000405117836ULL, 0x000fe20000000000ULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000106107824ULL, 0x000fc400078e020dULL, 0x0000000806137824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a03ULL, 0x0000000c05127836ULL, 0x000fe20000000000ULL,
0xfffffff813147812ULL, 0x000fe200078ee210ULL, 0x0000000805107836ULL, 0x000fe20000000000ULL,
0x000000021100720cULL, 0x080fe20003f46070ULL, 0x0000000103117824ULL, 0x000fe200078e0211ULL,
0x000000020500720cULL, 0x080fe20003f66070ULL, 0x0000000104067824ULL, 0x000fe200078e0206ULL,
0x000000021000720cULL, 0x080fe20003f26070ULL, 0x0000000111057824ULL, 0x040fe200078e020dULL,
0x000000021200720cULL, 0x000fe20003f06070ULL, 0x0000000811167824ULL, 0x000fc400078e00ffULL,
0x0000000103107824ULL, 0x040fe400078e0210ULL, 0x0000000103137824ULL, 0x000fe200078e0212ULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000000104117824ULL, 0x040fe200078e0211ULL, 0x0000007002127812ULL, 0x000fe200078ef800ULL,
0x0000000104057824ULL, 0x000fe200078e0210ULL, 0x000000080a027c11ULL, 0x000fe2000f8e68ffULL,
0x0000000104177824ULL, 0x000fe200078e0213ULL, 0x0000000412127c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000110047824ULL, 0x140fe400078e020dULL, 0x0000000810157824ULL, 0x000fe400078e00ffULL,
0x0000000113107824ULL, 0x000fc400078e020dULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff815067812ULL, 0x000fe200078ee204ULL, 0x0001300002157836ULL, 0x000fe40000000000ULL,
0x0000008005047825ULL, 0x000fe200078e00ffULL, 0xfffffff813187812ULL, 0x000fe400078ee210ULL,
0x0000000503137c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008011027825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fc600078ef800ULL, 0x0000008017107825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fe400078ef800ULL, 0x0000000404047c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001014177824ULL, 0x100fe200078e0215ULL, 0x0000007010007812ULL, 0x000fe200078ef800ULL,
0x0000001016197824ULL, 0x100fe200078e0215ULL, 0x0000000402027c10ULL, 0x000fe2000ff9e0ffULL,
0x00000010061b7824ULL, 0x100fe200078e0215ULL, 0x0000000400107c10ULL, 0x000fe2000ffde0ffULL,
0x0000001018157824ULL, 0x000fe200078e0215ULL, 0x0000000503037c10ULL, 0x000fe2000a7fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000d901c46ULL,
0x0000000505057c10ULL, 0x000fc4000affe4ffULL, 0x0000000511117c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000002197faeULL, 0x0003e8000d101c46ULL, 0x00000000041b7faeULL, 0x0003e8000c901c46ULL,
0x0000000010157faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000001007027824ULL, 0x002fe200078e00ffULL, 0x0000900000047ab9ULL, 0x000fc80000000a00ULL,
0x000000020d027211ULL, 0x000fca00078fe8ffULL, 0x0000000402057836ULL, 0x000fe40000000000ULL,
0x0000000102037824ULL, 0x140fe400078e020dULL, 0x0000000802067824ULL, 0x000fe400078e00ffULL,
0x0000000105107824ULL, 0x040fe400078e020dULL, 0x0000000805117824ULL, 0x000fe200078e00ffULL,
0xfffffff806067812ULL, 0x000fe200078ee203ULL, 0x0000000104037824ULL, 0x000fc400078e0202ULL,
0x0000000c02127836ULL, 0x000fe20000000000ULL, 0xfffffff811147812ULL, 0x000fe200078ee210ULL,
0x0000000802107836ULL, 0x000fe40000000000ULL, 0x0000008003027825ULL, 0x000fc800078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e0205ULL, 0x0000007002137812ULL, 0x000fe200078ef800ULL,
0x0000000104117824ULL, 0x040fe400078e0210ULL, 0x0000000104157824ULL, 0x000fe400078e0212ULL,
0x0000000112027824ULL, 0x140fe400078e020dULL, 0x0000000812197824ULL, 0x000fe200078e00ffULL,
0x0000000413127c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000110047824ULL, 0x000fc400078e020dULL,
0x0000000810177824ULL, 0x000fe200078e00ffULL, 0x000000080a107c11ULL, 0x000fe4000f8e68ffULL,
0xfffffff819187812ULL, 0x000fe400078ee202ULL, 0x0000000503137c10ULL, 0x000fe200087fe4ffULL,
0x0000008005027825ULL, 0x000fe200078e00ffULL, 0xfffffff817167812ULL, 0x000fc600078ee204ULL,
0x00013000101b7836ULL, 0x000fe20000000000ULL, 0x0000007002027812ULL, 0x000fe200078ef800ULL,
0x0000008011047825ULL, 0x000fc600078e00ffULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008015107825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fe400078ef800ULL,
0x0000000503037c10ULL, 0x000fe200087fe4ffULL, 0x0000001006157824ULL, 0x100fe200078e021bULL,
0x0000007010007812ULL, 0x000fe200078ef800ULL, 0x0000001014177824ULL, 0x100fe200078e021bULL,
0x0000000404047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001016197824ULL, 0x100fe200078e021bULL,
0x0000000400107c10ULL, 0x000fe2000ff5e0ffULL, 0x00000010181b7824ULL, 0x000fe200078e021bULL,
0x0000000505057c10ULL, 0x000fe20008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000b901c46ULL, 0x0000000511117c10ULL, 0x000fc600097fe4ffULL,
0x0000000002177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e8000b901c46ULL,
0x00000000101b7faeULL, 0x0003e4000b901c46ULL, 0x00000008ff037e24ULL, 0x002fe2000f8e00ffULL,
0x000000000a0472caULL, 0x000fe200000e0000ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000176a803037836ULL, 0x000fe20000000000ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff517224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000030572caULL, 0x000fc400000e0000ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x000000080a037824ULL, 0x000fe400078e0203ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000002ff4c79a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00002002030279a7ULL, 0x002e62000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000008c00008947ULL, 0x000fec0003800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0003ULL,
0x00000002ff067819ULL, 0x000fe20000011639ULL, 0xff317217ff457424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000000439047824ULL, 0x000fca00078e00ffULL,
0xfffffff804177812ULL, 0x000fc800078ec0ffULL, 0x0176c834170075a7ULL, 0x000e620008000148ULL,
0x0000000817357c36ULL, 0x000fc80008000000ULL, 0x000176c835047836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176c834350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000105157836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010005447824ULL, 0x000fc600078e0209ULL, 0x0000000c1500720cULL, 0x000fe20003f26070ULL,
0x0000004044157836ULL, 0x000fc80000000000ULL, 0x0000000508367c24ULL, 0x000fd0000f8e0215ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x0000001538147248ULL, 0x000fe20007fe0000ULL,
0x0000001007177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000117157824ULL, 0x000fe400078e0216ULL, 0x0000000416357836ULL, 0x000fe20000000000ULL,
0x0000001417147248ULL, 0x000fe20007fe0000ULL, 0x0000000115347824ULL, 0x000fc400078e020dULL,
0x00000008153f7824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a17ULL,
0x0000000117377824ULL, 0x000fe200078e0235ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL,
0x0000000816347836ULL, 0x000fe20000000000ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000c163c7836ULL, 0x000fe20000000000ULL, 0x000000143500720cULL, 0x080fe20003f66070ULL,
0x0000000137167824ULL, 0x040fe200078e020dULL, 0x000000143400720cULL, 0x080fe20003f46070ULL,
0x0000000837417824ULL, 0x000fe200078e00ffULL, 0x000000143c00720cULL, 0x000fe20003f06070ULL,
0x0000000117357824ULL, 0x000fc400078e0234ULL, 0x00000001173d7824ULL, 0x000fe200078e023cULL,
0xfffffff841417812ULL, 0x000fe200078ee216ULL, 0x000000100d177824ULL, 0x000fe400078e00ffULL,
0x0000000115147824ULL, 0x100fe400078e0236ULL, 0x0000000137167824ULL, 0x100fe400078e0236ULL,
0x0000000135347824ULL, 0x040fe400078e0236ULL, 0x0000000135377824ULL, 0x000fc400078e020dULL,
0x00000008353c7824ULL, 0x000fe400078e00ffULL, 0x000000013d367824ULL, 0x040fe400078e0236ULL,
0x000000013d357824ULL, 0x040fe200078e020dULL, 0xfffffff83c437812ULL, 0x000fe200078ee237ULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0x00000070173d7812ULL, 0x000fe200078ec0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000080a3c7c11ULL, 0x000fe4000f8e68ffULL,
0xfffffff83e477812ULL, 0x000fe200078ee235ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003d14147212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000003d16167212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fe4000ffde0ffULL,
0x0000003d34347212ULL, 0x080fe200078efcffULL, 0x000140003c3c7836ULL, 0x000fe20000000000ULL,
0x0000003d36367212ULL, 0x000fe400078efcffULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x000000103f3d7824ULL, 0x100fe200078e023cULL, 0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010413f7824ULL, 0x100fe200078e023cULL, 0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001043417824ULL, 0x100fe200078e023cULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x0000001047437824ULL, 0x000fe200078e023cULL, 0x0000000b35357c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fc6000b7fe4ffULL, 0x00000000163f7faeULL, 0x0003e8000d901c46ULL,
0x0000000034417faeULL, 0x0003e8000d101c46ULL, 0x0000000036437faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000100d167824ULL, 0x000fc600078e00ffULL,
0x000000140d157211ULL, 0x000fe400078fe8ffULL, 0x0000007016417812ULL, 0x000fc600078ec0ffULL,
0x0000000415177836ULL, 0x000fe40000000000ULL, 0x0000000115147824ULL, 0x140fe400078e020dULL,
0x00000008153d7824ULL, 0x000fe400078e00ffULL, 0x0000000117347824ULL, 0x040fe400078e020dULL,
0x00000008173f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee214ULL,
0x0000000815357836ULL, 0x000fc40000000000ULL, 0x0000000c153c7836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL, 0x0000000115147824ULL, 0x100fe400078e0236ULL,
0x0000000117167824ULL, 0x100fe200078e0236ULL, 0x000000080a177c11ULL, 0x000fe2000f8e68ffULL,
0x0000000135347824ULL, 0x040fe400078e0236ULL, 0x0000000135377824ULL, 0x040fe400078e020dULL,
0x00000008353e7824ULL, 0x000fc400078e00ffULL, 0x000000013c367824ULL, 0x040fe400078e0236ULL,
0x000000013c357824ULL, 0x040fe200078e020dULL, 0xfffffff83e437812ULL, 0x000fe200078ee237ULL,
0x000000083c3c7824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee235ULL, 0x00014000173c7836ULL, 0x000fe20000000000ULL,
0x0000004114147212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004116167212ULL, 0x080fe400078efcffULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004134347212ULL, 0x080fe400078efcffULL,
0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e023cULL,
0x0000004136367212ULL, 0x000fe200078efcffULL, 0x000000103f3f7824ULL, 0x100fe200078e023cULL,
0x0000000a34347c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001043417824ULL, 0x100fe200078e023cULL,
0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001047437824ULL, 0x000fe200078e023cULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b35357c10ULL, 0x000fc400097fe4ffULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034417faeULL, 0x0003e8000b901c46ULL, 0x0000000036437faeULL, 0x0003e4000b901c46ULL,
0xfffffff00b177812ULL, 0x042fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0xffffffe00b147812ULL, 0x040fe400078ec0ffULL, 0x000000100b157812ULL, 0x000fe200078ec0ffULL,
0x0000000817487c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000815167c10ULL, 0x000fe4000fffe014ULL, 0x00000000480572caULL, 0x000fc600000e0000ULL,
0x0000000807347824ULL, 0x000fd400078e0216ULL, 0x000176b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176b035484879a7ULL, 0x0002e4000850003fULL, 0x01760835343479a7ULL, 0x002e64000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x000000080b177812ULL, 0x000fca00078ec0ffULL,
0x00000001164b7824ULL, 0x000fc800078e0217ULL, 0x017608354b0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017608354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100d437824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe2000001160dULL,
0x0000002039147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000007043437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff527224ULL, 0x000fe200078e0045ULL,
0xffffff8014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c46467812ULL, 0x000fe400078ec0ffULL,
0x0000000843157c10ULL, 0x000fca000fffe014ULL, 0x0000000115157824ULL, 0x000fca00078e0246ULL,
0x0170000015147984ULL, 0x000e680000000800ULL, 0x0172000015177984ULL, 0x0009220000000800ULL,
0x000000451400720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16357812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x01cfea0003800000ULL,
0x000000390600720cULL, 0x000fe40003f45270ULL, 0x000000451400720bULL, 0x0c0fe40003f14000ULL,
0x0000004514527209ULL, 0x000fd20007810000ULL, 0x000000083915ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x000000154615a210ULL, 0x000fe40007ffe043ULL,
0x0000991034167816ULL, 0x000fc600000000ffULL, 0x017400521500a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000004552157221ULL, 0x000fe20000010100ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b15157820ULL, 0x000fc80000410000ULL,
0x0000001500167308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff157819ULL, 0x002fcc000001160dULL, 0x00001f1516157589ULL, 0x004e6400000e0000ULL,
0x0000001518187220ULL, 0x082fe20000410000ULL, 0x0000001519197220ULL, 0x080fe20000410000ULL,
0x000000152c2c7220ULL, 0x080fe20000410000ULL, 0x000000152d2d7220ULL, 0x080fe20000410000ULL,
0x0000001530307220ULL, 0x080fe20000410000ULL, 0x0000001531317220ULL, 0x080fe20000410000ULL,
0x0000001528287220ULL, 0x080fe20000410000ULL, 0x0000001529297220ULL, 0x080fe20000410000ULL,
0x0000001524247220ULL, 0x080fe20000410000ULL, 0x0000001525257220ULL, 0x080fe20000410000ULL,
0x0000001520207220ULL, 0x080fe20000410000ULL, 0x0000001521217220ULL, 0x080fe20000410000ULL,
0x000000151c1c7220ULL, 0x080fe20000410000ULL, 0x000000151d1d7220ULL, 0x080fe20000410000ULL,
0x0000001510107220ULL, 0x080fe20000410000ULL, 0x0000001511117220ULL, 0x000fce0000410000ULL,
0x0000001651517220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d157811ULL, 0x002fcc00078ff0ffULL, 0x00001f1516157589ULL, 0x000e6400000e0000ULL,
0x000000151a1a7220ULL, 0x082fe20000410000ULL, 0x000000151b1b7220ULL, 0x080fe20000410000ULL,
0x000000152e2e7220ULL, 0x080fe20000410000ULL, 0x000000152f2f7220ULL, 0x080fe20000410000ULL,
0x0000001532327220ULL, 0x080fe20000410000ULL, 0x0000001533337220ULL, 0x080fe20000410000ULL,
0x000000152a2a7220ULL, 0x080fe20000410000ULL, 0x000000152b2b7220ULL, 0x080fe20000410000ULL,
0x0000001526267220ULL, 0x080fe20000410000ULL, 0x0000001527277220ULL, 0x080fe20000410000ULL,
0x0000001522227220ULL, 0x080fe20000410000ULL, 0x0000001523237220ULL, 0x080fe20000410000ULL,
0x000000151e1e7220ULL, 0x080fe20000410000ULL, 0x000000151f1f7220ULL, 0x080fe20000410000ULL,
0x0000001512127220ULL, 0x080fe20000410000ULL, 0x0000001513137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x8000005214140221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005117517221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe40000015200ULL, 0xfffffff00b167812ULL, 0x000fc800078ec0ffULL,
0x0176a84d160075a7ULL, 0x000ea20008000148ULL, 0x0000000816367c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176a84d360075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034157816ULL, 0x000fe200000000ffULL, 0x0000020039147824ULL, 0x000fe200078e00ffULL,
0x000000070d547812ULL, 0x040fe400078ec0ffULL, 0x00000004ff4e7819ULL, 0x000fe4000001160dULL,
0x000000080d417812ULL, 0x000fe400078ec0ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000040a507824ULL, 0x100fe200078e024eULL, 0x00000008544f7812ULL, 0x000fe200078ef80dULL,
0x00000004074e7824ULL, 0x000fe200078e024eULL, 0x0000005441157212ULL, 0x000fc400078efcffULL,
0xfffff80014147812ULL, 0x000fe200078ec0ffULL, 0x000000014f507824ULL, 0x040fe200078e0250ULL,
0x000000080a407c11ULL, 0x000fe2000f8e68ffULL, 0x000000084f177824ULL, 0x000fe400078e00ffULL,
0x0000000115167824ULL, 0x040fe400078e024eULL, 0x0000000815357824ULL, 0x000fe400078e00ffULL,
0x0000000814457c36ULL, 0x000fe20008000000ULL, 0xfffffff817147812ULL, 0x000fe200078ee250ULL,
0x0001300040427836ULL, 0x000fe20000000000ULL, 0xfffffff835177812ULL, 0x000fe200078ee216ULL,
0x0000000216347836ULL, 0x000fc40000000000ULL, 0x0000001014167824ULL, 0x000fe400078e0245ULL,
0x00000010173c7824ULL, 0x000fe200078e0242ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011000001614783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x088fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0xfffffff835357812ULL, 0x000fe200078ee234ULL,
0x000000084f4f7824ULL, 0x000fe200078e00ffULL, 0x0000001041417812ULL, 0x000fe200078efe54ULL,
0x0000000250507836ULL, 0x000fe40000000000ULL, 0x0000001035357824ULL, 0x000fe400078e0242ULL,
0x000000014e4e7824ULL, 0x000fe200078e0241ULL, 0xfffffff84f507812ULL, 0x000fc600078ee250ULL,
0x000000003534783bULL, 0x000f620000004200ULL, 0x000001003c537824ULL, 0x050fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x000001003d587824ULL, 0x040fe200078e00ffULL,
0x000088803d657816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x000088803c577816ULL, 0x000fe200000000ffULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x00000018ff5b7819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x028fe40000011434ULL, 0x00008880345d7816ULL, 0x000fe200000000ffULL,
0x0000005300667306ULL, 0x0007e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff557819ULL, 0x000fe40000011435ULL, 0x00008880355a7816ULL, 0x000fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003d00677306ULL, 0x0009e20000200c00ULL,
0x000001003e537824ULL, 0x048fe200078e00ffULL, 0x000088803e607816ULL, 0x000fe400000000ffULL,
0x000088803f617816ULL, 0x000fe400000000ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005700577306ULL, 0x000ee20000200c00ULL, 0x00000100343d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001143eULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001143fULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005300637306ULL, 0x0009e20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff477819ULL, 0x000fe40000011436ULL, 0x00000018ff4a7819ULL, 0x000fc60000011437ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000010035537824ULL, 0x050fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005800687306ULL, 0x000f220000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000003400597306ULL, 0x000bf00000200c00ULL, 0x0000003c00647306ULL, 0x0007e20000200c00ULL,
0x0000010037347824ULL, 0x024fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000001003f3c7824ULL, 0x04afe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003500587306ULL, 0x0003e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x000100003e357824ULL, 0x002fce00078e00ffULL,
0x00000034003e7306ULL, 0x0003f00000200c00ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541057347816ULL, 0x002fe40000000066ULL, 0x00000018ff577819ULL, 0x000fc40000011435ULL,
0x0000541065357816ULL, 0x010fc60000000068ULL, 0x0000003c00627306ULL, 0x0003280000200c00ULL,
0x000000341418723cULL, 0x000fe80000001818ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00008880363c7816ULL, 0x002fe400000000ffULL, 0x0000541064347816ULL, 0x004fc4000000005bULL,
0x0000541067357816ULL, 0x000fc6000000005cULL, 0x0000003d005e7306ULL, 0x0002a80000200c00ULL,
0x00000034142c723cULL, 0x000fe8000000182cULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000100363d7824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000541060347816ULL, 0x008fc40000000063ULL, 0x0000541061357816ULL, 0x010fe40000000062ULL,
0x00000053005f7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000000341430723cULL, 0x000fe60000001830ULL,
0x0000005600567306ULL, 0x000f220000200c00ULL, 0x0000888037537816ULL, 0x042fe200000000ffULL,
0x0001000037377824ULL, 0x000fc400078e00ffULL, 0x000054105d347816ULL, 0x004fc6000000005eULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000054105a357816ULL, 0x008fce000000005fULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000000341424723cULL, 0x000fee0000001824ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000541059347816ULL, 0x010fe40000000056ULL, 0x0000541058357816ULL, 0x002fca0000000055ULL,
0x0000005700577306ULL, 0x000e640000200c00ULL, 0x000000341420723cULL, 0x000fec0000001820ULL,
0x0000003f005c7306ULL, 0x000ea20000200c00ULL, 0x0000000841357824ULL, 0x000fca00078e00ffULL,
0xfffffff835357812ULL, 0x000fe400078ee24eULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00005410574c7816ULL, 0x002fe4000000004cULL, 0x000054105c4d7816ULL, 0x004fca000000004dULL,
0x0000003d003d7306ULL, 0x000e640000200c00ULL, 0x0000004c1428723cULL, 0x000fec0000001828ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000010504c7824ULL, 0x000fe200078e0245ULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x00005410533d7816ULL, 0x002fce000000003eULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x0000541036367816ULL, 0x004fcc0000000047ULL,
0x00000010353c7824ULL, 0x000fe200078e0242ULL, 0x0000541037377816ULL, 0x002fce000000004aULL,
0x000000361410723cULL, 0x000fe20000001810ULL, 0x011000004c14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000841357824ULL, 0x000fe400078e00ffULL,
0x000000024e4e7836ULL, 0x000fca0000000000ULL, 0xfffffff835357812ULL, 0x000fca00078ee24eULL,
0x0000001035357824ULL, 0x000fcc00078e0242ULL, 0x000000003534783bULL, 0x000f220000004200ULL,
0x00000018ff587819ULL, 0x008fe2000001143cULL, 0x000001003c4f7824ULL, 0x040fe200078e00ffULL,
0x000088803c557816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001143dULL, 0x000001003d507824ULL, 0x040fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d5e7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff577819ULL, 0x000fe2000001143eULL, 0x0000004f00607306ULL, 0x0007e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff567819ULL, 0x000fe4000001143fULL,
0x000088803e5a7816ULL, 0x040fe400000000ffULL, 0x000088803f5b7816ULL, 0x000fe200000000ffULL,
0x0000003c005f7306ULL, 0x000be20000200c00ULL, 0x000001003e4f7824ULL, 0x048fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x010fe20000011434ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc40000011435ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000001003f3c7824ULL, 0x062fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888037657816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff4a7819ULL, 0x000fe40000011437ULL, 0x00000018ff477819ULL, 0x000fc60000011436ULL,
0x0000005000637306ULL, 0x0003300000200c00ULL, 0x0000003d00627306ULL, 0x000be20000200c00ULL,
0x0000888034507816ULL, 0x002fce00000000ffULL, 0x0000004f005d7306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x064fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00647306ULL, 0x0005e20000200c00ULL,
0x00008880354f7816ULL, 0x002fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00000100353c7824ULL, 0x044fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe4000001143cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003e005c7306ULL, 0x000fe20000200c00ULL,
0x00008880363c7816ULL, 0x000fce00000000ffULL, 0x0000003f00617306ULL, 0x000ff00000200c00ULL,
0x00000034003e7306ULL, 0x0007f00000200c00ULL, 0x00000035003f7306ULL, 0x0009e20000200c00ULL,
0x0000541055347816ULL, 0x008fe20000000060ULL, 0x000000ffff557224ULL, 0x000fcc00078e0065ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000054105e357816ULL, 0x010fe20000000063ULL,
0x00000100375e7824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054105f347816ULL, 0x000fe20000000058ULL,
0x0000005700577306ULL, 0x000f220000200c00ULL, 0x0000541062357816ULL, 0x002fce0000000059ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x0000003d00537306ULL, 0x000be20000200c00ULL,
0x000054105a347816ULL, 0x004fc6000000005dULL, 0x00000018ff587819ULL, 0x000fe40000011435ULL,
0x000054105b357816ULL, 0x008fe40000000064ULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000100363d7824ULL, 0x020fc800078e00ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004f004f7306ULL, 0x000fe80000200c00ULL,
0x000054105c347816ULL, 0x010fe40000000057ULL, 0x0000541061357816ULL, 0x002fe40000000056ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00000018ff567819ULL, 0x000fc80000011437ULL,
0x000000341428723cULL, 0x000fe60000001828ULL, 0x0000004d004d7306ULL, 0x000ee80000200c00ULL,
0x0000541050347816ULL, 0x004fe40000000053ULL, 0x000054104f357816ULL, 0x002fe40000000054ULL,
0x0000004e004e7306ULL, 0x000e6a0000200c00ULL, 0x000000341424723cULL, 0x000fe20000001824ULL,
0x000054103e3e7816ULL, 0x008fc4000000004dULL, 0x0000003c003c7306ULL, 0x000fe80000200c00ULL,
0x0000000239347824ULL, 0x000fe200078e00ffULL, 0x000000080a357c11ULL, 0x000fc6000f8e18ffULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000054103f3f7816ULL, 0x002fe4000000004eULL,
0xfffffff834377812ULL, 0x000fca00078ec0ffULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000003e1420723cULL, 0x000fe20000001820ULL, 0x000054103c3c7816ULL, 0x004fcc000000003dULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00000001ff3e7424ULL, 0x000fc800078e00ffULL,
0x0176c83e353479a7ULL, 0x000e66000850003fULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0176883e37ff79a7ULL, 0x0005ee0008500008ULL, 0x0000005e00367306ULL, 0x000ef00000200c00ULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x00005410553d7816ULL, 0x008fce0000000036ULL,
0x0000005600597306ULL, 0x000ee20000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x0000541058587816ULL, 0x010fe40000000047ULL, 0x0000541059597816ULL, 0x008fce000000004aULL,
0x000000581410723cULL, 0x000fee0000001810ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x00000035040075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000008044157836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fc60000000800ULL, 0x0000000508357c24ULL, 0x000fe2000f8e0215ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000001538147248ULL, 0x000fe20007fe0000ULL,
0x0000001007177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000416367836ULL, 0x000fe40000000000ULL, 0x0000000117347824ULL, 0x000fe200078e0216ULL,
0x0000001417147248ULL, 0x000fe20007fe0000ULL, 0x0000000816377836ULL, 0x000fc40000000000ULL,
0x0000000134157824ULL, 0x000fe400078e020dULL, 0x0000000114147824ULL, 0x000fe400078e0a17ULL,
0x00000008343c7824ULL, 0x000fe400078e00ffULL, 0x0000000c163e7836ULL, 0x000fe20000000000ULL,
0x000000143600720cULL, 0x080fe20003f66070ULL, 0x0000000117367824ULL, 0x040fe200078e0236ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x00000001174a7824ULL, 0x000fe200078e023eULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL, 0x0000000136167824ULL, 0x040fe200078e020dULL,
0x000000143700720cULL, 0x080fe20003f46070ULL, 0x00000008363f7824ULL, 0x000fe200078e00ffULL,
0x000000143e00720cULL, 0x000fe20003f06070ULL, 0x0000000134157824ULL, 0x000fc400078e0235ULL,
0x00000001173c7824ULL, 0x000fe200078e0237ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x0000008015147825ULL, 0x000fc800078e00ffULL, 0x0000000136167824ULL, 0x100fe200078e0235ULL,
0x0000004314147212ULL, 0x080fe200078efcffULL, 0x000000013c347824ULL, 0x040fe400078e0235ULL,
0x000000013c377824ULL, 0x040fe200078e020dULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x000000083c3c7824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe4000affe4ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee237ULL,
0x000000014a367824ULL, 0x000fe200078e0235ULL, 0x0000004316167212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004334347212ULL, 0x080fe400078efcffULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x000000014a3c7824ULL, 0x000fe200078e020dULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000084a4d7824ULL, 0x000fe200078e00ffULL,
0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0242ULL,
0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0242ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee23cULL, 0x0000001047477824ULL, 0x100fe200078e0242ULL,
0x0000000b35357c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL,
0x000000104d4d7824ULL, 0x000fc400078e0242ULL, 0x00000000163f7faeULL, 0x0003e8000d901c46ULL,
0x0000000034477faeULL, 0x0003e8000d101c46ULL, 0x00000000364d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000140d167211ULL, 0x000fca00078fe8ffULL,
0x0000000116157824ULL, 0x040fe400078e020dULL, 0x0000000816367824ULL, 0x040fe400078e00ffULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000c163e7836ULL, 0x000fe20000000000ULL,
0xfffffff8363d7812ULL, 0x000fe200078ee215ULL, 0x00000008163c7836ULL, 0x000fe40000000000ULL,
0x0000000116147824ULL, 0x000fc400078e0235ULL, 0x0000000134367824ULL, 0x040fe400078e0235ULL,
0x0000000134177824ULL, 0x040fe400078e020dULL, 0x00000008344a7824ULL, 0x000fe400078e00ffULL,
0x000000013e347824ULL, 0x040fe400078e0235ULL, 0x000000013e377824ULL, 0x000fe200078e020dULL,
0xfffffff84a3f7812ULL, 0x000fe200078ee217ULL, 0x000000013c167824ULL, 0x000fc400078e0235ULL,
0x000000083e3e7824ULL, 0x000fe400078e00ffULL, 0x000000013c357824ULL, 0x040fe400078e020dULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e4d7812ULL, 0x000fe200078ee237ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004314147212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004336367212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x080fe400078efcffULL, 0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0242ULL, 0x0000004334347212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0242ULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000001047477824ULL, 0x100fe200078e0242ULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000104d4d7824ULL, 0x000fe200078e0242ULL, 0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b37377c10ULL, 0x000fc400097fe4ffULL, 0x0000000b17177c10ULL, 0x000fe400087fe4ffULL,
0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL, 0x00000000363f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e8000b901c46ULL, 0x00000000344d7faeULL, 0x0003e4000b901c46ULL,
0x000000100a147824ULL, 0x002fe200078e00ffULL, 0xffffffe00b167812ULL, 0x000fe200078ec0ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x0000000814567c36ULL, 0x000fe20008000000ULL,
0x0000001014157812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000560572caULL, 0x000fe400000e0000ULL, 0x0000000815157c10ULL, 0x000fe4000fffe016ULL,
0x000000080b167812ULL, 0x000fca00078ec0ffULL, 0x0000000116157824ULL, 0x000fc800078e0215ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176a834565679a7ULL, 0x0002a4000850003fULL,
0x01762834153479a7ULL, 0x0022e4000850003fULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x017628354b0075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017628354b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002039147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000008015147810ULL, 0x000fc80007ffe014ULL,
0x0000001446147210ULL, 0x000fca0007ffe043ULL, 0x0170000014157984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0006e20000000800ULL, 0x000000521500720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16167812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x0000000106147836ULL, 0x000fe20000000000ULL,
0x000000521500720bULL, 0x0c0fe40003f14000ULL, 0x0000005215367209ULL, 0x000fe40007810000ULL,
0x000000391400720cULL, 0x000fd20003f45270ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000083914ac11ULL, 0x000fc8000f8e38ffULL, 0x000000144637a210ULL, 0x000fe40007ffe043ULL,
0x0000991035147816ULL, 0x000fc600000000ffULL, 0x017400363700a388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000003652527221ULL, 0x000fe20000010000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b52527820ULL, 0x000fcc0000410000ULL,
0x0000005200527308ULL, 0x000e680000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fca000001160dULL, 0x00001f3752147589ULL, 0x002e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000005251517220ULL, 0x002fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d377811ULL, 0x000fca00078ff0ffULL, 0x00001f3752147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007806035ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff527224ULL, 0x000fd400078e0036ULL, 0x8000003615150221ULL, 0x100fe20000010000ULL,
0x000000ffff520224ULL, 0x000fe200078e0036ULL, 0x00007610ff340816ULL, 0x000fe40000000034ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500020308ULL, 0x000e640000000800ULL,
0x0000000217170220ULL, 0x002fce0000410000ULL, 0x0000005117517221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x000fe40000015200ULL, 0xfffffff00b177812ULL, 0x000fc800078ec0ffULL,
0x0176b049170075a7ULL, 0x000e620008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b049370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000239537824ULL, 0x040fe200078e00ffULL, 0x0000991034347816ULL, 0x000fe200000000ffULL,
0x00000004394e7824ULL, 0x000fe200078e00ffULL, 0x000000070d167812ULL, 0x040fe200078ec0ffULL,
0x0001400040487836ULL, 0x000fe20000000000ULL, 0x000000080d157812ULL, 0x000fe400078ec0ffULL,
0x0000000453147812ULL, 0x000fe400078ec0ffULL, 0x0000001615357212ULL, 0x000fe200078efcffULL,
0x000000ffff157224ULL, 0x000fe200078e0034ULL, 0x0000000816177812ULL, 0x000fc400078ef80dULL,
0x000000140d147211ULL, 0x000fe200078fe0ffULL, 0x0000000835497824ULL, 0x000fe200078e00ffULL,
0x000000ff1500720cULL, 0x000fe40003f05270ULL, 0x000000044e4e7812ULL, 0x000fe200078ec0ffULL,
0x00000001174a7824ULL, 0x040fe400078e0214ULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x0000004e0d4e7211ULL, 0x000fc800078fe0ffULL, 0xfffffff817507812ULL, 0x000fe200078ee24aULL,
0x0000000135347824ULL, 0x000fc800078e024eULL, 0x0000001050507824ULL, 0x000fe200078e0245ULL,
0xfffffff849497812ULL, 0x000fe200078ee234ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011800005014783bULL, 0x0022e20000000200ULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x080fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x00000000493c783bULL, 0x000f220000004200ULL,
0x0000000835367824ULL, 0x000fe400078e00ffULL, 0x00000002344f7836ULL, 0x000fca0000000000ULL,
0xfffffff8364f7812ULL, 0x000fca00078ee24fULL, 0x000000104f347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff637819ULL, 0x010fe2000001143cULL,
0x000001003c587824ULL, 0x040fe200078e00ffULL, 0x000088803c667816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe2000001143dULL,
0x000001003d597824ULL, 0x040fe200078e00ffULL, 0x000088803d6b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000018ff587819ULL, 0x000fc40000011458ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803e647816ULL, 0x000fe200000000ffULL, 0x0000003c006a7306ULL, 0x0009e20000200c00ULL,
0x000088803f657816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x022fe40000011434ULL,
0x00000018ff477819ULL, 0x000fc40000011435ULL, 0x00008880345b7816ULL, 0x000fe200000000ffULL,
0x0000005800697306ULL, 0x0003620000200c00ULL, 0x000001003f3c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001143eULL, 0x00000018ff5d7819ULL, 0x000fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000001003e587824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc40000011436ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000059006e7306ULL, 0x0003220000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff547819ULL, 0x000fca0000011437ULL, 0x0000003d006c7306ULL, 0x0009e20000200c00ULL,
0x0000888035597816ULL, 0x002fce00000000ffULL, 0x0000003c00687306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x054fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001143cULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fca00000000ffULL, 0x0000005800677306ULL, 0x000ff00000200c00ULL,
0x00000034005a7306ULL, 0x000bf00000200c00ULL, 0x0000003500587306ULL, 0x0009e20000200c00ULL,
0x0000541066347816ULL, 0x028fce0000000069ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x000054106b357816ULL, 0x010fce000000006eULL, 0x0000006500657306ULL, 0x000f220000200c00ULL,
0x000000341418723cULL, 0x000fee0000001818ULL, 0x000054106a347816ULL, 0x004fe20000000063ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000054106c357816ULL, 0x002fce0000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000003e00627306ULL, 0x0002a20000200c00ULL, 0x0000541064347816ULL, 0x008fe40000000067ULL,
0x0000541065357816ULL, 0x010fca0000000068ULL, 0x0000003f00607306ULL, 0x0007220000200c00ULL,
0x00008880373e7816ULL, 0x042fe200000000ffULL, 0x000000341430723cULL, 0x000fec0000001830ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000100373f7824ULL, 0x048fe200078e00ffULL,
0x0000541062347816ULL, 0x004fe2000000005fULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003d005c7306ULL, 0x0002a20000200c00ULL,
0x0000541060357816ULL, 0x010fe4000000005dULL, 0x00000018ff377819ULL, 0x000fca0000011437ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x042fe200078e00ffULL,
0x000000341428723cULL, 0x000fe20000001828ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000054105b347816ULL, 0x004fca000000005cULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x0000541059357816ULL, 0x002fce000000005eULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105a347816ULL, 0x004fe40000000055ULL,
0x0000541058357816ULL, 0x002fca0000000047ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x0000000841477824ULL, 0x040fe200078e00ffULL, 0x000000341420723cULL, 0x000fec0000001820ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000000141347824ULL, 0x000fe200078e024eULL,
0x000054103c3c7816ULL, 0x002fcc000000003dULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0xfffffff847477812ULL, 0x000fce00078ee234ULL, 0x0000003e003e7306ULL, 0x000ff00000200c00ULL,
0x0000003f003f7306ULL, 0x000e700000200c00ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000003fULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x0000541036367816ULL, 0x004fcc000000004dULL,
0x00000010473c7824ULL, 0x000fe200078e0248ULL, 0x0000541037377816ULL, 0x002fce0000000054ULL,
0x000000361410723cULL, 0x000fe20000001810ULL, 0x011800004c14783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000841367824ULL, 0x000fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ec0ffULL, 0x00000002344d7836ULL, 0x000fca0000000000ULL,
0xfffffff8364d7812ULL, 0x000fca00078ee24dULL, 0x000000104d347824ULL, 0x000fcc00078e0248ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x00000018ff637819ULL, 0x008fe2000001143cULL,
0x000001003c597824ULL, 0x040fe200078e00ffULL, 0x000088803c667816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001143dULL,
0x000001003d5a7824ULL, 0x040fe200078e00ffULL, 0x000088803d6b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000018ff597819ULL, 0x000fc40000011459ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5f7819ULL, 0x000fe2000001143eULL, 0x0000003c006a7306ULL, 0x0007e20000200c00ULL,
0x000088803e647816ULL, 0x000fe400000000ffULL, 0x00000018ff587819ULL, 0x010fe40000011434ULL,
0x00000018ff557819ULL, 0x000fc40000011435ULL, 0x00008880345b7816ULL, 0x000fe200000000ffULL,
0x0000005900697306ULL, 0x0009620000200c00ULL, 0x000001003f3c7824ULL, 0x048fe200078e00ffULL,
0x000088803f657816ULL, 0x040fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000001003e597824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x002fc40000011436ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005a006c7306ULL, 0x0002e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff547819ULL, 0x000fca0000011437ULL, 0x0000003d006d7306ULL, 0x0009e20000200c00ULL,
0x00008880355a7816ULL, 0x002fce00000000ffULL, 0x0000003c00687306ULL, 0x0003e20000200c00ULL,
0x00000100343d7824ULL, 0x050fe400078e00ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006300637306ULL, 0x000f220000200c00ULL,
0x00000100353c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001143cULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00008880363c7816ULL, 0x000fca00000000ffULL, 0x0000005900677306ULL, 0x000ff00000200c00ULL,
0x0000003e00607306ULL, 0x000ff00000200c00ULL, 0x0000003400597306ULL, 0x000bf00000200c00ULL,
0x00000035003e7306ULL, 0x0007e20000200c00ULL, 0x0000541066347816ULL, 0x024fe20000000069ULL,
0x0000010037667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000054106b357816ULL, 0x008fce000000006cULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x000054106a347816ULL, 0x010fe20000000063ULL, 0x0000005f005f7306ULL, 0x000f220000200c00ULL,
0x000054106d357816ULL, 0x002fe20000000062ULL, 0x0001000037637824ULL, 0x000fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000034142c723cULL, 0x000fee000000182cULL, 0x0000003f00617306ULL, 0x0003620000200c00ULL,
0x0001000036357824ULL, 0x000fe200078e00ffULL, 0x0000541064347816ULL, 0x004fc80000000067ULL,
0x00000018ff627819ULL, 0x000fe40000011435ULL, 0x0000541065357816ULL, 0x008fe20000000068ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00008880373f7816ULL, 0x002fca00000000ffULL,
0x000000341430723cULL, 0x000fe40000001830ULL, 0x0000003d005c7306ULL, 0x0002aa0000200c00ULL,
0x0000541060347816ULL, 0x010fe4000000005fULL, 0x0000541061357816ULL, 0x020fe2000000005eULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000100363d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000341428723cULL, 0x000fe20000001828ULL,
0x0000005d005d7306ULL, 0x000e6c0000200c00ULL, 0x000054105b347816ULL, 0x004fe4000000005cULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000054105a357816ULL, 0x002fce000000005dULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x000000341424723cULL, 0x000fee0000001824ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541059347816ULL, 0x004fe40000000058ULL,
0x000054103e357816ULL, 0x002fca0000000055ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x00000001ff3e7424ULL, 0x000fe200078e00ffULL, 0x000000341420723cULL, 0x000fec0000001820ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000000080a347c11ULL, 0x000fe4000f8e18ffULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000006600367306ULL, 0x000e620000200c00ULL,
0x0176c83e343479a7ULL, 0x000eae000850003fULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0176903e53ff79a7ULL, 0x0007e20008500008ULL, 0x000054103f3d7816ULL, 0x002fcc0000000036ULL,
0x0000006200377306ULL, 0x000e620000200c00ULL, 0x0000003c141c723cULL, 0x000fee000000181cULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541037367816ULL, 0x002fce000000004cULL,
0x0000006300637306ULL, 0x000e640000200c00ULL, 0x0000541063377816ULL, 0x002fce0000000054ULL,
0x000000361410723cULL, 0x000fee0000001810ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x00000035040075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x00afdc0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000c044157836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fc60000000800ULL, 0x0000000508177c24ULL, 0x000fe2000f8e0215ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000001538147248ULL, 0x000fe20007fe0000ULL,
0x0000001007357824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000135347824ULL, 0x000fe400078e0216ULL, 0x0000000416367836ULL, 0x000fe20000000000ULL,
0x0000001435147248ULL, 0x000fe20007fe0000ULL, 0x0000000134157824ULL, 0x000fc400078e020dULL,
0x00000008343c7824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000816377836ULL, 0x000fe20000000000ULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL,
0x0000000c163c7836ULL, 0x000fe20000000000ULL, 0x000000143600720cULL, 0x080fe20003f66070ULL,
0x0000000135367824ULL, 0x000fe200078e0236ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000134157824ULL, 0x000fe200078e0217ULL, 0x000000143700720cULL, 0x080fe20003f46070ULL,
0x0000000136167824ULL, 0x000fe200078e020dULL, 0x000000143c00720cULL, 0x000fe20003f06070ULL,
0x00000008363f7824ULL, 0x000fc400078e00ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x0000000135347824ULL, 0x040fe200078e0237ULL,
0x0000004314147212ULL, 0x000fe200078efcffULL, 0x0000000136367824ULL, 0x000fe400078e0217ULL,
0x00000001353e7824ULL, 0x000fe200078e023cULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000000134357824ULL, 0x040fe400078e020dULL, 0x00000008343c7824ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff83c537812ULL, 0x000fe200078ee235ULL, 0x0000000134167824ULL, 0x100fe200078e0217ULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000013e347824ULL, 0x000fe400078e0217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a36367c10ULL, 0x000fc6000ffbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000b37377c10ULL, 0x000fe2000affe4ffULL, 0x000000013e3c7824ULL, 0x000fe200078e020dULL,
0x0000004334347212ULL, 0x000fe200078efcffULL, 0x000000083e557824ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0248ULL,
0x0000000a34347c10ULL, 0x000fe2000ffde0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0248ULL,
0xfffffff855557812ULL, 0x000fe200078ee23cULL, 0x0000001053537824ULL, 0x100fe200078e0248ULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001055557824ULL, 0x000fc400078e0248ULL, 0x00000000363f7faeULL, 0x0003e8000d901c46ULL,
0x0000000016537faeULL, 0x0003e8000d101c46ULL, 0x0000000034557faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000140d167211ULL, 0x000fca00078fe8ffULL,
0x0000000116157824ULL, 0x040fe400078e020dULL, 0x0000000816367824ULL, 0x040fe400078e00ffULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x00000008163c7836ULL, 0x000fe20000000000ULL,
0xfffffff8363d7812ULL, 0x000fe200078ee215ULL, 0x0000000c163e7836ULL, 0x000fe40000000000ULL,
0x0000000116147824ULL, 0x000fc400078e0217ULL, 0x0000000134167824ULL, 0x040fe400078e0217ULL,
0x0000000134357824ULL, 0x040fe400078e020dULL, 0x00000008344c7824ULL, 0x000fe400078e00ffULL,
0x000000013c347824ULL, 0x100fe400078e0217ULL, 0x000000013e367824ULL, 0x000fe200078e0217ULL,
0xfffffff84c3f7812ULL, 0x000fe200078ee235ULL, 0x000000013c177824ULL, 0x000fc400078e020dULL,
0x000000083c3c7824ULL, 0x000fe400078e00ffULL, 0x000000013e377824ULL, 0x040fe400078e020dULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c537812ULL, 0x000fe200078ee217ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83e557812ULL, 0x000fe200078ee237ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004314147212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004334347212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0248ULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0248ULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000001053537824ULL, 0x100fe200078e0248ULL, 0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001055557824ULL, 0x000fe200078e0248ULL, 0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b17177c10ULL, 0x000fc400097fe4ffULL, 0x0000000b35357c10ULL, 0x000fe400087fe4ffULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034537faeULL, 0x0003e8000b901c46ULL, 0x0000000036557faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008ff157e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff00b547812ULL, 0x000fe200078ec0ffULL,
0x00000001ff167424ULL, 0x000fc600078e00ffULL, 0x000176a854547810ULL, 0x000fe40007ffe015ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000816545479a7ULL, 0x0002a4000850003fULL, 0x017648164b1679a7ULL, 0x0022e4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0xffffffe00b347812ULL, 0x040fe400078ec0ffULL,
0x000000100b357812ULL, 0x040fe400078ec0ffULL, 0x000000080b367812ULL, 0x000fe400078ec0ffULL,
0x0000000835357c10ULL, 0x000fca000fffe034ULL, 0x00000001353d7824ULL, 0x000fc800078e0236ULL,
0x017648173d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648173d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000002039147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001446147210ULL, 0x000fca0007ffe043ULL, 0x0170000014157984ULL, 0x000ee80000000800ULL,
0x0172000014177984ULL, 0x0009220000000800ULL, 0x000000521500720bULL, 0x008fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x016fea0003800000ULL, 0x0000000206147836ULL, 0x000fe20000000000ULL,
0x000000521500720bULL, 0x000fc80003f14000ULL, 0x000000391400720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000083916ac11ULL, 0x000fe4000f8e38ffULL,
0x000000521514a209ULL, 0x000fe40007810000ULL, 0x000000164637a210ULL, 0x000fe40007ffe043ULL,
0x0000991034167816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005215377209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005237147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400167308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff377819ULL, 0x000fca000001160dULL,
0x00001f3716147589ULL, 0x006e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001651517220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d377811ULL, 0x000fca00078ff0ffULL,
0x00001f3716147589ULL, 0x002e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005215527209ULL, 0x000fd60007810000ULL,
0x8000005215150221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005117517221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe40000015200ULL, 0xfffffff00b177812ULL, 0x000fc800078ec0ffULL,
0x0176a857170075a7ULL, 0x000ea20008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a857370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000080d147812ULL, 0x000fe400078ec0ffULL, 0x0000991034347816ULL, 0x000fe400000000ffULL,
0x0000000714157812ULL, 0x000fc600078ef80dULL, 0x000000ffff147224ULL, 0x000fe400078e0034ULL,
0x00000001154e7824ULL, 0x040fe400078e024eULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x000000ff1400720cULL, 0x000fc80003f05270ULL, 0xfffffff815157812ULL, 0x000fca00078ee24eULL,
0x00000010153c7824ULL, 0x000fc800078e0242ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000005014783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x000000104f347824ULL, 0x000fcc00078e0242ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x00000018ff5b7819ULL, 0x010fe2000001143cULL,
0x000001003c507824ULL, 0x042fe200078e00ffULL, 0x000088803c587816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d537824ULL, 0x040fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000088803d617816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff5a7819ULL, 0x000fe2000001143eULL,
0x0000005000637306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff597819ULL, 0x000fe4000001143fULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x000088803f5e7816ULL, 0x000fe200000000ffULL, 0x0000003c00627306ULL, 0x0009e20000200c00ULL,
0x000001003e507824ULL, 0x042fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x020fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fc40000011435ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011436ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff4e7819ULL, 0x000fe40000011437ULL,
0x0000888037687816ULL, 0x000fc600000000ffULL, 0x0000005300667306ULL, 0x0009700000200c00ULL,
0x0000003d00657306ULL, 0x0003e20000200c00ULL, 0x0000888034537816ULL, 0x010fce00000000ffULL,
0x0000005000607306ULL, 0x0009e20000200c00ULL, 0x00000100343d7824ULL, 0x046fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00677306ULL, 0x0003e20000200c00ULL, 0x0000888035507816ULL, 0x010fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x042fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003e005f7306ULL, 0x000fe20000200c00ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000003f00647306ULL, 0x000ff00000200c00ULL, 0x00000034003f7306ULL, 0x0003f00000200c00ULL,
0x00000035003e7306ULL, 0x000be20000200c00ULL, 0x0000541058347816ULL, 0x002fe20000000063ULL,
0x000000ffff587224ULL, 0x000fcc00078e0068ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000541061357816ULL, 0x028fe20000000066ULL, 0x0000010037617824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc800078e00ffULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000000341418723cULL, 0x000fe20000001818ULL, 0x00000018ff377819ULL, 0x000fcc0000011437ULL,
0x0000541062347816ULL, 0x000fe2000000005bULL, 0x0000005a005a7306ULL, 0x000f220000200c00ULL,
0x0000541065357816ULL, 0x004fe4000000005cULL, 0x00000018ff5b7819ULL, 0x000fca0000011461ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x00000034142c723cULL, 0x000fee000000182cULL,
0x0000003d00567306ULL, 0x000be20000200c00ULL, 0x000054105d347816ULL, 0x002fe40000000060ULL,
0x000054105e357816ULL, 0x008fca0000000067ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x00000100363d7824ULL, 0x060fe200078e00ffULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000054105f347816ULL, 0x010fe4000000005aULL, 0x0000541064357816ULL, 0x004fe40000000059ULL,
0x000000070d5a7812ULL, 0x000fe200078ec0ffULL, 0x0000005700577306ULL, 0x000ea60000200c00ULL,
0x000000085a5a7812ULL, 0x000fe200078ef80dULL, 0x000000341428723cULL, 0x000fe80000001828ULL,
0x0000004c004c7306ULL, 0x000ee60000200c00ULL, 0x0000541053347816ULL, 0x002fe20000000056ULL,
0x000000085a537824ULL, 0x000fe200078e00ffULL, 0x0000541050357816ULL, 0x004fc60000000057ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000000024a507836ULL, 0x000fc60000000000ULL,
0x000000341424723cULL, 0x000fe80000001824ULL, 0x0000003d003d7306ULL, 0x000e660000200c00ULL,
0x000054103f347816ULL, 0x008fe4000000004cULL, 0xfffffff8534c7812ULL, 0x000fc600078ee250ULL,
0x0000004f004f7306ULL, 0x000ea40000200c00ULL, 0x000000104c457824ULL, 0x000fe200078e0245ULL,
0x000054103c3c7816ULL, 0x002fca000000003dULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000054103e357816ULL, 0x004fce000000004fULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000000341420723cULL, 0x000fee0000001820ULL, 0x0000005800587306ULL, 0x000ff00000200c00ULL,
0x0000005b005b7306ULL, 0x000e700000200c00ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x00005410583d7816ULL, 0x002fce000000005bULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000003c141c723cULL, 0x000fe2000000181cULL, 0x0000541036367816ULL, 0x004fcc000000004bULL,
0x00000010473c7824ULL, 0x000fe200078e0242ULL, 0x0000541037377816ULL, 0x002fce000000004eULL,
0x000000361410723cULL, 0x000fe20000001810ULL, 0x012000004514783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x084fe40000000000ULL, 0x0000000316167232ULL, 0x000fe40000000000ULL,
0x0000000015157232ULL, 0x080fe40000000000ULL, 0x0000000017177232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x000000104d347824ULL, 0x000fcc00078e0242ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x00000018ff5c7819ULL, 0x008fe2000001143cULL,
0x000001003c4f7824ULL, 0x040fe200078e00ffULL, 0x000088803c5b7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001143dULL,
0x000001003d507824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000010037677824ULL, 0x010fe200078e00ffULL, 0x000088803d617816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff577819ULL, 0x000fe2000001143fULL, 0x0000004f00667306ULL, 0x0007e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000088803f5e7816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011434ULL, 0x00000018ff4e7819ULL, 0x000fe20000011435ULL,
0x0000003c005f7306ULL, 0x0009e20000200c00ULL, 0x000001003e4f7824ULL, 0x008fe200078e00ffULL,
0x0000888034537816ULL, 0x000fc400000000ffULL, 0x000088803e5d7816ULL, 0x040fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000001003f3c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x002fe20000011436ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff4b7819ULL, 0x000fc60000011437ULL,
0x0000005000687306ULL, 0x000e700000200c00ULL, 0x0000003d00637306ULL, 0x0009f00000200c00ULL,
0x0000004f00607306ULL, 0x000be20000200c00ULL, 0x00000100343d7824ULL, 0x010fc400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00657306ULL, 0x0009e20000200c00ULL, 0x00008880354f7816ULL, 0x024fe400000000ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x00000100353c7824ULL, 0x050fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003f00647306ULL, 0x000fe20000200c00ULL, 0x00008880363c7816ULL, 0x000fce00000000ffULL,
0x0000003400507306ULL, 0x0007f00000200c00ULL, 0x00000035003f7306ULL, 0x0003e20000200c00ULL,
0x000054105b347816ULL, 0x008fe40000000066ULL, 0x00000018ff5b7819ULL, 0x000fca0000011467ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x0000541061357816ULL, 0x002fce0000000068ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x000000341418723cULL, 0x000fee0000001818ULL,
0x000054105f347816ULL, 0x000fe2000000005cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541063357816ULL, 0x004fce000000005aULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000034142c723cULL, 0x000fee000000182cULL, 0x0000003e00627306ULL, 0x0005220000200c00ULL,
0x000054105d347816ULL, 0x008fe40000000060ULL, 0x000054105e357816ULL, 0x002fca0000000065ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00008880373e7816ULL, 0x044fe200000000ffULL,
0x000000341430723cULL, 0x000fe20000001830ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x0000003d00567306ULL, 0x0002a20000200c00ULL, 0x0000541062347816ULL, 0x010fe40000000059ULL,
0x0000541064357816ULL, 0x000fe40000000057ULL, 0x00000018ff5a7819ULL, 0x000fe40000011437ULL,
0x0000000806377c11ULL, 0x000fe2000f8e18ffULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x00000100363d7824ULL, 0x042fe200078e00ffULL, 0x000000341428723cULL, 0x000fe20000001828ULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005800587306ULL, 0x000e620000200c00ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000541053347816ULL, 0x004fca0000000056ULL, 0x0000004d004d7306ULL, 0x000ea20000200c00ULL,
0x000054104f357816ULL, 0x002fce0000000058ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x000000341424723cULL, 0x000fee0000001824ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541050347816ULL, 0x004fe4000000004dULL, 0x000054103f357816ULL, 0x002fca000000004eULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000001ff3f7424ULL, 0x000fe200078e00ffULL,
0x000000341420723cULL, 0x000fec0000001820ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000003f043479a7ULL, 0x000ea2000850003fULL, 0x000054103c3c7816ULL, 0x002fcc000000003dULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0176983f37ff79a7ULL, 0x0003ee000850003fULL,
0x0000003e003e7306ULL, 0x000ff00000200c00ULL, 0x0000005b005b7306ULL, 0x000ef00000200c00ULL,
0x0000003600367306ULL, 0x000f220000200c00ULL, 0x000054103e3d7816ULL, 0x008fce000000005bULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x0000541036367816ULL, 0x010fe40000000045ULL, 0x000054105a377816ULL, 0x002fce000000004bULL,
0x000000361410723cULL, 0x000fee0000001810ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x00000035040075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fdc0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000105157836ULL, 0x000fca0000000000ULL,
0x0000000c1500720cULL, 0x000fda0003f06070ULL, 0x0000000400d40947ULL, 0x000fea0003800000ULL,
0x0000000205157836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fc80000000800ULL,
0x0000000c1500720cULL, 0x000fe20003f06070ULL, 0x0000010044157836ULL, 0x000fc80000000000ULL,
0x0000000508377c24ULL, 0x000fd0000f8e0215ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000001538147248ULL, 0x000fe20007fe0000ULL, 0x0000001007177824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001160dULL, 0x00009000000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000117347824ULL, 0x000fe400078e0216ULL,
0x0000000416357836ULL, 0x000fe20000000000ULL, 0x0000001417147248ULL, 0x000fe20007fe0000ULL,
0x0000000134157824ULL, 0x000fc400078e020dULL, 0x0000000834367824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fc600078e0a17ULL, 0xfffffff8363d7812ULL, 0x000fe200078ee215ULL,
0x0000000816157836ULL, 0x000fe20000000000ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000c16167836ULL, 0x000fe20000000000ULL, 0x000000143500720cULL, 0x080fe20003f66070ULL,
0x0000000117367824ULL, 0x000fe200078e0235ULL, 0x000000141500720cULL, 0x080fe20003f46070ULL,
0x00000001173c7824ULL, 0x040fe200078e0215ULL, 0x000000141600720cULL, 0x000fe20003f06070ULL,
0x00000001173e7824ULL, 0x000fe400078e0216ULL, 0x0000000136147824ULL, 0x000fc400078e020dULL,
0x00000008363f7824ULL, 0x000fe400078e00ffULL, 0x0000000134167824ULL, 0x100fe400078e0237ULL,
0x0000000136347824ULL, 0x000fe200078e0237ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x000000013c157824ULL, 0x040fe400078e020dULL, 0x000000083c447824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff844457812ULL, 0x000fe200078ee215ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x000fc600078efcffULL,
0x000000013c147824ULL, 0x100fe200078e0237ULL, 0x0000004334347212ULL, 0x080fe200078efcffULL,
0x000000013e367824ULL, 0x000fe200078e0237ULL, 0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a34347c10ULL, 0x000fe4000ffde0ffULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004314147212ULL, 0x080fe400078efcffULL, 0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL,
0x000000013e3c7824ULL, 0x000fe200078e020dULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000083e4b7824ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0242ULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0242ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL,
0x0000001045457824ULL, 0x100fe200078e0242ULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163d7faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104b4b7824ULL, 0x000fc400078e0242ULL,
0x00000000343f7faeULL, 0x0003e8000d901c46ULL, 0x0000000014457faeULL, 0x0003e8000d101c46ULL,
0x00000000364b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001007147824ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000140d167211ULL, 0x000fca00078fe8ffULL, 0x0000000116157824ULL, 0x040fe400078e020dULL,
0x0000000816347824ULL, 0x040fe400078e00ffULL, 0x00000008163c7836ULL, 0x000fe40000000000ULL,
0x0000000c163e7836ULL, 0x000fe20000000000ULL, 0xfffffff8343d7812ULL, 0x000fe200078ee215ULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fc400078e0237ULL,
0x0000000134167824ULL, 0x040fe400078e0237ULL, 0x0000000134177824ULL, 0x040fe400078e020dULL,
0x0000000834447824ULL, 0x000fe400078e00ffULL, 0x000000013c367824ULL, 0x100fe400078e0237ULL,
0x000000013e347824ULL, 0x040fe200078e0237ULL, 0xfffffff8443f7812ULL, 0x000fe200078ee217ULL,
0x000000013e377824ULL, 0x000fc400078e020dULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000013c357824ULL, 0x000fe200078e020dULL, 0x0000004314147212ULL, 0x080fe200078efcffULL,
0x000000083e3e7824ULL, 0x000fe400078e00ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff83e4b7812ULL, 0x000fe400078ee237ULL, 0xfffffff83c457812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x000fc400078efcffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004336367212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0242ULL, 0x0000004334347212ULL, 0x000fe200078efcffULL,
0x000000103f3f7824ULL, 0x100fe200078e0242ULL, 0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001045457824ULL, 0x100fe200078e0242ULL, 0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e0242ULL, 0x0000000b17177c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b37377c10ULL, 0x000fc400097fe4ffULL, 0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL,
0x00000000163f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036457faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000010a147812ULL, 0x000fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000000806157c11ULL, 0x000fe2000f8e28ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000080b377812ULL, 0x000fc600078ec0ffULL, 0x0000001014167824ULL, 0x000fe200078e0215ULL,
0x000000080a147c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0176a834141479a7ULL, 0x0002a2000850003fULL, 0x0000000137377824ULL, 0x000fc800078e0216ULL,
0x01766834373479a7ULL, 0x0022e4000850003fULL, 0x000000ffff4d7224ULL, 0x006fce00078e0015ULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x01766835370075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x00afea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016143d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003d16167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01766835370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000806147c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff457224ULL, 0x000fe200078e0052ULL, 0x0000018043157810ULL, 0x000fca0007ffe014ULL,
0x0000000146157824ULL, 0x000fca00078e0215ULL, 0x0170000015177984ULL, 0x000e680000000800ULL,
0x0172000015167984ULL, 0x0004a20000000800ULL, 0x000000521700720bULL, 0x002fda0003f1d000ULL,
0x0000000000147806ULL, 0x000fc800000e0100ULL, 0x0000ffff14357812ULL, 0x000fda000780c0ffULL,
0x0000000000f88947ULL, 0x004fea0003800000ULL, 0x0000000306147836ULL, 0x000fe20000000000ULL,
0x000000521700720bULL, 0x0c0fe40003f14000ULL, 0x0000005217457209ULL, 0x000fe40007810000ULL,
0x000000391400720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000083914ac11ULL, 0x000fc8000f8e38ffULL, 0x000000144646a210ULL, 0x000fe40007ffe043ULL,
0x0000991034147816ULL, 0x000fc600000000ffULL, 0x017400454600a388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000005245147221ULL, 0x000fe20000010100ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400367308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff157819ULL, 0x000fca000001160dULL, 0x00001f1536147589ULL, 0x006e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000003651517220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d157811ULL, 0x000fca00078ff0ffULL, 0x00001f1536147589ULL, 0x002e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x0000001745170221ULL, 0x000fe20000010100ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700020308ULL, 0x000ea40000000800ULL,
0x0000000216160220ULL, 0x004fce0000410000ULL, 0x0000005116517221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe40000015200ULL, 0xfffffff00b177812ULL, 0x000fe200078ec0ffULL,
0x0000000439167824ULL, 0x000fc600078e00ffULL, 0x0176b055170075a7ULL, 0x000ea20008000148ULL,
0x00000008173d7c36ULL, 0x000fe20008000000ULL, 0x0000000416167812ULL, 0x000fc800078ec0ffULL,
0x0000000216357812ULL, 0x000fe200078efcffULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b0553d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000070d377812ULL, 0x000fe400078ec0ffULL,
0x0000991034147816ULL, 0x000fe400000000ffULL, 0x0000000837157812ULL, 0x000fe400078ef80dULL,
0x000000ff1400720cULL, 0x000fe40003f05270ULL, 0x0000000806147c11ULL, 0x000fe2000f8e58ffULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x000000080d367812ULL, 0x000fc800078ec0ffULL,
0xfffffff815157812ULL, 0x000fca00078ee24aULL, 0x0000001015147824ULL, 0x000fe200078e0214ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff167819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x0000541000157816ULL, 0x000fca0000000000ULL, 0x00001f1615037589ULL, 0x0002a800000e0000ULL,
0x00001f3415007589ULL, 0x0002e400000e0000ULL, 0x012800001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000000000ULL,
0x0000000316167232ULL, 0x000fe40000000000ULL, 0x0000000015157232ULL, 0x088fe40000000000ULL,
0x0000000017177232ULL, 0x000fce0000000000ULL, 0x000000350d427211ULL, 0x000fe200078fe0ffULL,
0x00000000493c783bULL, 0x000f220000004200ULL, 0x0000003736377212ULL, 0x000fca00078efcffULL,
0x0000000137347824ULL, 0x040fe400078e0242ULL, 0x0000000837357824ULL, 0x000fca00078e00ffULL,
0xfffffff835357812ULL, 0x000fca00078ee234ULL, 0x0000001035357824ULL, 0x000fcc00078e0248ULL,
0x000000003534783bULL, 0x000f620000004200ULL, 0x000001003c497824ULL, 0x050fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe2000001143cULL, 0x000001003d4b7824ULL, 0x040fe200078e00ffULL,
0x000088803c4a7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe4000001143dULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000088803d5a7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc4000001143cULL,
0x00000018ff547819ULL, 0x000fe4000001143eULL, 0x000088803e3c7816ULL, 0x040fe200000000ffULL,
0x00000049005f7306ULL, 0x0009e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff527819ULL, 0x000fe4000001143fULL,
0x000088803f587816ULL, 0x000fe200000000ffULL, 0x0000004b00637306ULL, 0x000be20000200c00ULL,
0x000001003e497824ULL, 0x050fe200078e00ffULL, 0x00000018ff467819ULL, 0x028fe20000011434ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00008880344e7816ULL, 0x000fc400000000ffULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x0000003d005c7306ULL, 0x0007e20000200c00ULL,
0x000001003f4b7824ULL, 0x044fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011435ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000888035507816ULL, 0x000fe400000000ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff3d7819ULL, 0x008fe2000001143eULL, 0x00000100343e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fc40000011436ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff447819ULL, 0x000fca0000011437ULL, 0x00000049005b7306ULL, 0x0009f00000200c00ULL,
0x0000004b00617306ULL, 0x000fe20000200c00ULL, 0x0000010035497824ULL, 0x050fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000034004b7306ULL, 0x0009e20000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000005d005d7306ULL, 0x000f620000200c00ULL, 0x0000010037347824ULL, 0x010fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011434ULL, 0x00000035004f7306ULL, 0x0007e20000200c00ULL,
0x000054104a347816ULL, 0x004fce000000005fULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x000054105a357816ULL, 0x008fce0000000063ULL, 0x000000341418723cULL, 0x002fe20000001818ULL,
0x0000003f00597306ULL, 0x0003ec0000200c00ULL, 0x0000000306357836ULL, 0x000fe20000000000ULL,
0x000054105d347816ULL, 0x020fe20000000056ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x00000100363f7824ULL, 0x002fc400078e00ffULL, 0x00000008355d7c11ULL, 0x000fe4000f8e58ffULL,
0x000054105c357816ULL, 0x004fe40000000055ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000003e00537306ULL, 0x0003e20000200c00ULL, 0x000000104c5d7824ULL, 0x000fc600078e025dULL,
0x00000034142c723cULL, 0x000fe8000000182cULL, 0x0000004900577306ULL, 0x0005e20000200c00ULL,
0x00008880363e7816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000054103c347816ULL, 0x008fc8000000005bULL, 0x00000018ff5a7819ULL, 0x000fe20000011436ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000888037497816ULL, 0x044fe200000000ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011437ULL,
0x0000003d003d7306ULL, 0x000e700000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000054103d3c7816ULL, 0x002fce0000000054ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x00005410593d7816ULL, 0x004fce0000000052ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x0000003c1428723cULL, 0x000fe20000001828ULL, 0x0000541058357816ULL, 0x002fcc0000000061ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000000341430723cULL, 0x000fe20000001830ULL,
0x000054104e3c7816ULL, 0x004fcc0000000053ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x011000005d34783bULL, 0x0004a20000000200ULL, 0x00005410503d7816ULL, 0x002fcc0000000057ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000003c1424723cULL, 0x000fee0000001824ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000054103e3e7816ULL, 0x002fce000000003fULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000054104b4e7816ULL, 0x008fce0000000046ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000054104f4f7816ULL, 0x002fce0000000048ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000004e1420723cULL, 0x000fee0000001820ULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000005e004a7306ULL, 0x000e700000200c00ULL,
0x0000005a00567306ULL, 0x000ee20000200c00ULL, 0x00005410493f7816ULL, 0x002fce000000004aULL,
0x0000004c00557306ULL, 0x000e620000200c00ULL, 0x0000003e141c723cULL, 0x000fe2000000181cULL,
0x0000541056567816ULL, 0x008fe40000000043ULL, 0x0000541055577816ULL, 0x002fce0000000044ULL,
0x000000561410723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x004fde0003800000ULL, 0x0000000334347232ULL, 0x080fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x0001400040167836ULL, 0x000fe40000000000ULL,
0x0000000141427824ULL, 0x000fe400078e0242ULL, 0x00000010473c7824ULL, 0x000fe400078e0216ULL,
0x0000000841417824ULL, 0x000fe400078e00ffULL, 0x0000000105057836ULL, 0x000fe40000000000ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0xfffffff841427812ULL, 0x000fe200078ee242ULL,
0x000001003c147824ULL, 0x042fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe2000001143cULL,
0x000001003d157824ULL, 0x000fe200078e00ffULL, 0x000088803c487816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011414ULL,
0x0000001042147824ULL, 0x000fe200078e0216ULL, 0x00000018ff567819ULL, 0x000fe20000011415ULL,
0x000001003e417824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fe2000001143eULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x00000018ff437819ULL, 0x000fc4000001143fULL,
0x000088803e4a7816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f4e7816ULL, 0x000fe200000000ffULL, 0x0000003c00557306ULL, 0x0005e20000200c00ULL,
0x000088803d4b7816ULL, 0x040fe400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff447819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x000001003f3c7824ULL, 0x004fc400078e00ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000005600567306ULL, 0x000eb00000200c00ULL, 0x0000003e00537306ULL, 0x0009e20000200c00ULL,
0x00000018ff427819ULL, 0x002fe20000011414ULL, 0x00000100175a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fc40000011415ULL, 0x00008880144c7816ULL, 0x040fe400000000ffULL,
0x0000888015507816ULL, 0x000fe200000000ffULL, 0x0000003f00527306ULL, 0x0003e20000200c00ULL,
0x00000100143e7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0001000014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000100153f7824ULL, 0x042fe200078e00ffULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000003d00577306ULL, 0x0009700000200c00ULL,
0x00000014005b7306ULL, 0x0007e20000200c00ULL, 0x00000018ff3d7819ULL, 0x010fce0000011417ULL,
0x0000001500547306ULL, 0x0005e20000200c00ULL, 0x0000541048147816ULL, 0x008fe20000000049ULL,
0x00000001ff497424ULL, 0x000fcc00078e00ffULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054104b157816ULL, 0x004fce0000000056ULL, 0x000000143418723cULL, 0x000fe20000001818ULL,
0x0000004300437306ULL, 0x000eac0000200c00ULL, 0x0001000016157824ULL, 0x000fe200078e00ffULL,
0x0000541055147816ULL, 0x002fe20000000046ULL, 0x00000041004f7306ULL, 0x0003e60000200c00ULL,
0x00000018ff467819ULL, 0x000fc40000011415ULL, 0x0000541057157816ULL, 0x020fc60000000044ULL,
0x0000003c005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x002fc60000011416ULL,
0x00000014342c723cULL, 0x000fe8000000182cULL, 0x00000041003c7306ULL, 0x0003e60000200c00ULL,
0x0001000017147824ULL, 0x000fe200078e00ffULL, 0x0000541052157816ULL, 0x004fc80000000043ULL,
0x0000003e00597306ULL, 0x0005e20000200c00ULL, 0x0000010016417824ULL, 0x042fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011414ULL, 0x0000541053147816ULL, 0x000fe40000000040ULL,
0x00000018ff587819ULL, 0x000fe40000011441ULL, 0x0000888017417816ULL, 0x000fe200000000ffULL,
0x0000003f005f7306ULL, 0x000fe20000200c00ULL, 0x00008880163e7816ULL, 0x004fe200000000ffULL,
0x000000143428723cULL, 0x000fe20000001828ULL, 0x00000049041479a7ULL, 0x0002aa000850003fULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000000806047c11ULL, 0x002fce000f8e18ffULL,
0x00000058003f7306ULL, 0x000e620000200c00ULL, 0x0176a04904ff79a7ULL, 0x0007ee000850003fULL,
0x0000004a004a7306ULL, 0x000f220000200c00ULL, 0x000054103e3e7816ULL, 0x002fce000000003fULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054104a4a7816ULL, 0x010fce000000004fULL,
0x0000004200427306ULL, 0x000f220000200c00ULL, 0x000054104e4b7816ULL, 0x002fce000000005dULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x0000004a3430723cULL, 0x000fe20000001830ULL,
0x000054105b427816ULL, 0x010fcc0000000042ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541054437816ULL, 0x002fce0000000047ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000000423420723cULL, 0x000fee0000001820ULL, 0x0000005000507306ULL, 0x000f220000200c00ULL,
0x000054104c5e7816ULL, 0x002fce0000000059ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x00005410505f7816ULL, 0x010fce000000005fULL, 0x0000005a00167306ULL, 0x000e620000200c00ULL,
0x0000005e3424723cULL, 0x000fee0000001824ULL, 0x0000004600177306ULL, 0x000f220000200c00ULL,
0x00005410413f7816ULL, 0x002fce0000000016ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000003e341c723cULL, 0x000fe2000000181cULL, 0x00005410173c7816ULL, 0x010fe4000000003cULL,
0x00005410443d7816ULL, 0x002fce000000003dULL, 0x0000003c3410723cULL, 0x000fee0000001810ULL,
0x000000ffff347224ULL, 0x004fe200078e0015ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff7400149947ULL, 0x008fde000383ffffULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff157224ULL, 0x000fe400078e0024ULL, 0x000000ffff0d7224ULL, 0x000fe400078e001bULL,
0x000000ffff247224ULL, 0x000fd000078e001aULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000051007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000a81000047802ULL, 0x000fce0000000f00ULL,
0x0000008000747944ULL, 0x006fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000051ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f240000000a00ULL,
0x0000000602037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff0b7819ULL, 0x022fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0b00047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000002405247220ULL, 0x044fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000202120723eULL, 0x000fe400000000ffULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000101110723eULL, 0x000fc400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000000121312723eULL, 0x000fe400000000ffULL, 0x000000ff0a00720cULL, 0x000fc40003f05270ULL,
0x00000002ff057819ULL, 0x008fe40000011600ULL, 0x0000000200027812ULL, 0x042fe400078ec0ffULL,
0x00000008000b7811ULL, 0x000fe200078ff0ffULL, 0x0000000805177824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x0000000805147824ULL, 0x000fe200078e00ffULL,
0x0000000b02037211ULL, 0x000fe200078ff8ffULL, 0x000000080b167824ULL, 0x000fe400078e00ffULL,
0x0000000204027836ULL, 0x000fc40000000000ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x0000000404067836ULL, 0x000fe20000000000ULL,
0x0000000807037c11ULL, 0x000fe4000f8e60ffULL, 0xfffffff817087812ULL, 0x000fe400078ee202ULL,
0xfffffff80b027812ULL, 0x000fe200078ee204ULL, 0x00000006040b7836ULL, 0x000fe20000000000ULL,
0xfffffff8170c7812ULL, 0x000fe200078ee206ULL, 0x0000000800047824ULL, 0x000fc400078e00ffULL,
0x000008000a057824ULL, 0x000fe200078e0203ULL, 0xfffffff814147812ULL, 0x000fe400078ee20bULL,
0x00000008040b7812ULL, 0x000fe200078ec0ffULL, 0x0000001002067824ULL, 0x100fe200078e0205ULL,
0x000000181902723eULL, 0x000fe200000000ffULL, 0x0000001008087824ULL, 0x000fe200078e0205ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe400078e020bULL,
0x0000001016167824ULL, 0x100fe200078e0205ULL, 0x0000541002187816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x0000763202197816ULL, 0x000fe20000000004ULL,
0x0000001014147824ULL, 0x000fe200078e0205ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x000000010b087824ULL, 0x000fe200078e0208ULL, 0x000000282904723eULL, 0x000fe200000000ffULL,
0x0000001806007388ULL, 0x0003e20000000a00ULL, 0x000000152505723eULL, 0x000fe200000000ffULL,
0x000000010b0c7824ULL, 0x000fc400078e020cULL, 0x000000010b147824ULL, 0x000fe200078e0214ULL,
0x00005410051a7816ULL, 0x000fe20000000020ULL, 0x000000010b167824ULL, 0x000fe200078e0216ULL,
0x00007632051b7816ULL, 0x000fe40000000020ULL, 0x0000763226057816ULL, 0x000fe40000000022ULL,
0x0000541002187816ULL, 0x142fe40000000004ULL, 0x0000763202197816ULL, 0x000fe40000000004ULL,
0x000000240d02723eULL, 0x000fc400000000ffULL, 0x0000002e2f04723eULL, 0x000fe200000000ffULL,
0x0000001808007388ULL, 0x0003e60000000a00ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000001a0c007388ULL, 0x0007e20000000a00ULL, 0x0000002a2b19723eULL, 0x002fe400000000ffULL,
0x000054101c1a7816ULL, 0x148fe40000000010ULL, 0x000076321c1b7816ULL, 0x000fc40000000010ULL,
0x0000541002107816ULL, 0x000fe20000000004ULL, 0x0000000109027824ULL, 0x000fe200078e0200ULL,
0x0000541032187816ULL, 0x140fe20000000019ULL, 0x0000001a14007388ULL, 0x000fe20000000a00ULL,
0x0000763232197816ULL, 0x000fe20000000019ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x0000541026047816ULL, 0x000fe20000000022ULL, 0x0000001016007388ULL, 0x000fe20000000a00ULL,
0x000076321e097816ULL, 0x000fc60000000012ULL, 0x0004001808007388ULL, 0x0003e80000000a00ULL,
0x000400040c007388ULL, 0x000fe20000000a00ULL, 0x000054101e087816ULL, 0x002fca0000000012ULL,
0x0004000814007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002107984ULL, 0x000e680000000c00ULL, 0x00040000021c7984ULL, 0x000ee80000000c00ULL,
0x0008000002187984ULL, 0x000f280000000c00ULL, 0x000c000002207984ULL, 0x000f620000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b13137230ULL, 0x010fe40000000000ULL, 0x0000001a12127230ULL, 0x000fe40000000000ULL,
0x0000001911117230ULL, 0x000fe40000000000ULL, 0x0000001810107230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x024fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000001002007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c02007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x0000000f0900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000013a027824ULL, 0x002fe200078e0209ULL, 0x0000000800067d06ULL, 0x000e620008209000ULL,
0x00000008ff107c12ULL, 0x000fe2000f8e33ffULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00008a0000047ab9ULL, 0x000fca0000000a00ULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06047836ULL, 0x002fcc0000000000ULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a05ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b05137227ULL, 0x000fc800078e0004ULL,
0x0000000109047824ULL, 0x000fe400078e0200ULL, 0x00000002130c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0cULL, 0x0000000805057c24ULL, 0x000fca000f8e0202ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x000000010c0c0836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x000000010c0c1836ULL, 0x000fc60000000000ULL, 0x0000000006087984ULL, 0x0002a40000000c00ULL,
0x0000000c100c7207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0a0cULL,
0x0000000700067812ULL, 0x002fe200078ec0ffULL, 0x000000090c057c24ULL, 0x000fe4000f8e023bULL,
0x000000080d027c24ULL, 0x000fe4000f8e0202ULL, 0x00000008070d7824ULL, 0x000fe400078e0206ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0202ULL, 0x0000002000027836ULL, 0x000fc60000000000ULL,
0x000000050e057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff117819ULL, 0x000fc60000011602ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f440cULL, 0x0000000f1100720cULL, 0x000fe20003f26070ULL,
0x000000100d047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000013a047824ULL, 0x102fe400078e0211ULL,
0x0000000102117824ULL, 0x000fe400078e0211ULL, 0x0000000413057227ULL, 0x000fc600078e00ffULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x0000000809067c24ULL, 0x000fca000f8e0204ULL, 0x0000000806007c0cULL, 0x000fda000bf26070ULL,
0x8000000806061c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000806007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff811067812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001006067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x00000005100c7207ULL, 0x000fe20004000000ULL, 0x0000004000067836ULL, 0x002fc80000000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x000000090c057c24ULL, 0x000fe2000f8e023bULL,
0x00000003ff117819ULL, 0x000fe20000011606ULL, 0x000000080d047c24ULL, 0x000fe4000f8e0204ULL,
0x00000008070d7824ULL, 0x000fe400078e0202ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x000000050e057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000000f1100720cULL, 0x000fe20003f26070ULL, 0x000000100d047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000013a027824ULL, 0x100fe400078e0211ULL, 0x0000000106117824ULL, 0x000fe400078e0211ULL,
0x0000000213057227ULL, 0x002fc600078e00ffULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x0000006000007836ULL, 0x000fe40000000000ULL,
0x0000000809047c24ULL, 0x000fca000f8e0202ULL, 0x0000000804007c0cULL, 0x000fda000bf26070ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff811047812ULL, 0x000fe400078ef806ULL,
0x00000003ff117819ULL, 0x000fe40000011600ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001004087824ULL, 0x000fe400078e0203ULL, 0x000000013a3a7824ULL, 0x000fc800078e0211ULL,
0x0000000105052836ULL, 0x000fe20000000000ULL, 0x0000000008087984ULL, 0x000e680000000c00ULL,
0x0000000510047207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a04ULL,
0x0000000904057c24ULL, 0x000fe4000f8e023bULL, 0x000000080d027c24ULL, 0x000fe4000f8e0202ULL,
0x00000008070d7824ULL, 0x000fe400078e0206ULL, 0x0000000805057c24ULL, 0x000fca000f8e0202ULL,
0x000000050e057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4402ULL,
0x0000000f1100720cULL, 0x000fe20003f26070ULL, 0x000000100d047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000003a13057227ULL, 0x002fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x0000000100117824ULL, 0x000fe400078e0211ULL, 0x0000000809027c24ULL, 0x000fc6000f8e023aULL,
0x0000000711117812ULL, 0x000fe400078ec0ffULL, 0x0000000802007c0cULL, 0x000fda000bf26070ULL,
0x8000000802021c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000802007c0cULL, 0x000fe4000bf46070ULL, 0xfffffff811027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000000807077824ULL, 0x000fc600078e0200ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x0000000510027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000000902037c24ULL, 0x000fe4000f8e023bULL,
0x00000008053a7c24ULL, 0x000fc8000f8e023aULL, 0x0000000803037c24ULL, 0x000fca000f8e023aULL,
0x000000030e037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8040ffULL, 0x0000000503037c11ULL, 0x000fc600080f4406ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009800ff0a7b82ULL, 0x000e620000000a00ULL,
0x000001ff0900780cULL, 0x000fe20003f04070ULL, 0x00000002070e7824ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000001ff047424ULL, 0x000fe200078e00ffULL,
0x0000940000057ab9ULL, 0x000fe20000000800ULL, 0x000000060a067981ULL, 0x002322000c1e9900ULL,
0x0000001f04047890ULL, 0x000fe2000fffe03fULL, 0x0000004039077824ULL, 0x000fe400078e00ffULL,
0x01760004ff0479a7ULL, 0x000ea20008500008ULL, 0x000000080e3b7224ULL, 0x000fe200078e023bULL,
0x000000053f047899ULL, 0x000fc60008011604ULL, 0x000000053b087c24ULL, 0x000fe2000f8e0207ULL,
0x0000000c00240947ULL, 0x000ff00003800000ULL, 0x00000003ff207819ULL, 0x000fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x00000007380a7248ULL, 0x002fc60007fe0000ULL,
0x00000004200e7836ULL, 0x000fe40000000000ULL, 0x0000000820167836ULL, 0x000fe40000000000ULL,
0x000000010e0b7824ULL, 0x040fe400078e020dULL, 0x000000080e107824ULL, 0x000fe400078e00ffULL,
0x000000010a097824ULL, 0x000fe400078e0a07ULL, 0x00000001160f7824ULL, 0x040fe200078e020dULL,
0xfffffff810217812ULL, 0x000fe200078ee20bULL, 0x0000000816107824ULL, 0x000fe200078e00ffULL,
0x000000090e00720cULL, 0x000fe20003fa6070ULL, 0x00000001080e7824ULL, 0x000fc400078e020eULL,
0x00000001080a7824ULL, 0x000fe200078e0220ULL, 0xfffffff810257812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700e147812ULL, 0x000fc600078ef800ULL, 0x0000001020127836ULL, 0x000fe20000000000ULL,
0x000000700a1a7812ULL, 0x000fe200078ef800ULL, 0x0000000c20187836ULL, 0x000fe20000000000ULL,
0x0000000a14147c10ULL, 0x000fe2000ff3e0ffULL, 0x00000001120a7824ULL, 0x040fe200078e020dULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000812297824ULL, 0x000fe200078e00ffULL,
0x0000000b0f157c10ULL, 0x000fe20008ffe4ffULL, 0x00000001080e7824ULL, 0x040fe200078e0218ULL,
0x0000000b0b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000001820227836ULL, 0x000fe20000000000ULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000001080a7824ULL, 0x000fe200078e0216ULL,
0x000000091600720cULL, 0x080fe20003f26070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000091800720cULL, 0x000fc40003f46070ULL, 0x000000091200720cULL, 0x000fe20003f06070ULL,
0x0000000118107824ULL, 0x040fe200078e020dULL, 0x000000700e167812ULL, 0x000fe200078ef800ULL,
0x0000000818277824ULL, 0x000fe400078e00ffULL, 0x00000001081c7824ULL, 0x000fe200078e0222ULL,
0x0000000a16167c10ULL, 0x000fe2000ff9e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe400078ee210ULL, 0x0000000b0f177c10ULL, 0x000fe2000a7fe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000700a187812ULL, 0x000fc600078ef800ULL,
0x0000000108107824ULL, 0x000fe200078e0212ULL, 0x000000701c0a7812ULL, 0x000fe200078ef800ULL,
0x00000014201e7836ULL, 0x000fe20000000000ULL, 0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000a0a0a7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000b0b197c10ULL, 0x000fe20009ffe4ffULL, 0x0000000108127824ULL, 0x000fe200078e021eULL,
0x0000007010107812ULL, 0x000fe200078ef800ULL, 0x0000001c20267836ULL, 0x000fe20000000000ULL,
0x0000000b1d0b7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fc4000ff7e0ffULL, 0x00000008391c7c11ULL, 0x000fe2000f8e70ffULL,
0x00000001201d7824ULL, 0x100fe200078e020dULL, 0x00000070120e7812ULL, 0x000fe200078ef800ULL,
0x0000000108127824ULL, 0x000fe200078e0226ULL, 0x0000000b11117c10ULL, 0x000fe20009ffe4ffULL,
0x000000081e2a7824ULL, 0x040fe200078e00ffULL, 0x000000071d247812ULL, 0x000fe200078ec0ffULL,
0x000000011e1d7824ULL, 0x100fe200078e020dULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000002020287836ULL, 0x000fe20000000000ULL, 0x000000092000720cULL, 0x080fe20003f86070ULL,
0x000010001c1c7836ULL, 0x000fe20000000000ULL, 0x0ffffff8241f7812ULL, 0x000fe200078ef80dULL,
0x0000000122247824ULL, 0x000fe200078e020dULL, 0x0000000b130f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000091e00720cULL, 0x000fc40003f66070ULL,
0xfffffff82a2b7812ULL, 0x000fe200078ee21dULL, 0x00000001081e7824ULL, 0x000fe200078e0228ULL,
0x0000007012127812ULL, 0x000fe200078ef800ULL, 0x00000024202a7836ULL, 0x000fe40000000000ULL,
0x000000101f1d7824ULL, 0x000fe200078e021cULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1d7faeULL, 0x0003e2000e101c46ULL, 0x00000008222d7824ULL, 0x040fe200078e00ffULL,
0x000000092200720cULL, 0x080fe20003f86070ULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x000000701e1e7812ULL, 0x000fe200078ef800ULL, 0x0000000108237824ULL, 0x000fe200078e022aULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL, 0x00000028202c7836ULL, 0x000fe20000000000ULL,
0x0000000014217faeULL, 0x0007e2000e901c46ULL, 0x0000008023227825ULL, 0x000fe200078e00ffULL,
0x000000092600720cULL, 0x000fc40003fa6070ULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e021cULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x00000001082e7824ULL, 0x000fe200078e022cULL, 0x0000007022227812ULL, 0x000fe200078ef800ULL,
0x00000001261d7824ULL, 0x042fe200078e020dULL, 0x0000000018257faeULL, 0x000fe2000c901c46ULL,
0x0000000826247824ULL, 0x000fe200078e00ffULL, 0x0000000b1f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001027277824ULL, 0x000fe200078e021cULL, 0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL,
0x0000002c20267836ULL, 0x000fe20000000000ULL, 0xfffffff8241d7812ULL, 0x000fe200078ee21dULL,
0x000000802e1a7825ULL, 0x000fe200078e00ffULL, 0x0000000016277faeULL, 0x0003e2000d101c46ULL,
0x000000092800720cULL, 0x000fc40003f26070ULL, 0x0000001029297824ULL, 0x000fe200078e021cULL,
0x000000701a1a7812ULL, 0x000fe200078ef800ULL, 0x0000000108147824ULL, 0x008fe200078e0226ULL,
0x0000000b23237c10ULL, 0x000fe2000b7fe4ffULL, 0x000000102b2b7824ULL, 0x100fe200078e021cULL,
0x0000000010297faeULL, 0x0007e2000c101c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e021cULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000000e2b7faeULL, 0x000fe2000d901c46ULL, 0x000000092a00720cULL, 0x000fc40003f46070ULL,
0x0000003020167836ULL, 0x006fe20000000000ULL, 0x000000000a2d7faeULL, 0x0003e2000e101c46ULL,
0x0000000128217824ULL, 0x140fe200078e020dULL, 0x0000007014147812ULL, 0x000fe200078ef800ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000108107824ULL, 0x008fe200078e0216ULL, 0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL,
0x000000012a247824ULL, 0x040fe200078e020dULL, 0xfffffff828217812ULL, 0x000fe200078ee221ULL,
0x000000082a2f7824ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021cULL, 0x000000092600720cULL, 0x000fe20003f86070ULL,
0x00000080100a7825ULL, 0x002fe200078e00ffULL, 0xfffffff82f177812ULL, 0x000fc400078ee224ULL,
0x00000000121d7faeULL, 0x0003e2000e901c46ULL, 0x0000003420187836ULL, 0x000fe20000000000ULL,
0x000000700a107812ULL, 0x000fe200078ef800ULL, 0x000000012c117824ULL, 0x140fe200078e020dULL,
0x000000092c00720cULL, 0x0c0fe20003fa6070ULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x0000001021217824ULL, 0x100fe200078e021cULL,
0x000000091600720cULL, 0x080fe20003f66070ULL, 0x0000001017177824ULL, 0x000fe400078e021cULL,
0x0000003820247836ULL, 0x000fe20000000000ULL, 0xfffffff82c137812ULL, 0x002fe200078ee211ULL,
0x00000001080e7824ULL, 0x000fe200078e0218ULL, 0x000000001e217faeULL, 0x000fe2000c901c46ULL,
0x0000003c20207836ULL, 0x000fe20000000000ULL, 0x0000000b0b117c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001160a7824ULL, 0x040fe200078e020dULL, 0x0000000022177faeULL, 0x0003e2000d101c46ULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0x000000091800720cULL, 0x080fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000092400720cULL, 0x000fc40003f26070ULL,
0x000000092000720cULL, 0x000fe20003f06070ULL, 0x00000001080b7824ULL, 0x000fe200078e0224ULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x0000000126097824ULL, 0x140fe200078e020dULL,
0x000000700e0e7812ULL, 0x000fe200078ef800ULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff826177812ULL, 0x002fe200078ee209ULL, 0x0000000108087824ULL, 0x000fe200078e0220ULL,
0x000000700a0a7812ULL, 0x000fe200078ef800ULL, 0x0000000118127824ULL, 0x000fe200078e020dULL,
0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000a0a0a7c10ULL, 0x000fc6000ffde0ffULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0x0000007008007812ULL, 0x000fe200078ef800ULL, 0x0000000124167824ULL, 0x140fe200078e020dULL,
0x0000000b0b0b7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008241f7824ULL, 0x000fe200078e00ffULL,
0x0000000a00087c10ULL, 0x000fe2000ffde0ffULL, 0x0000000120187824ULL, 0x040fe200078e020dULL,
0xfffffff81d0d7812ULL, 0x000fe200078ee212ULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1d7812ULL, 0x000fe200078ee216ULL, 0x0000001013137824ULL, 0x100fe200078e021cULL,
0x0000000b09097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001017177824ULL, 0x100fe200078e021cULL,
0xfffffff8211f7812ULL, 0x000fe200078ee218ULL, 0x0000001019197824ULL, 0x100fe200078e021cULL,
0x000000001a137faeULL, 0x0003e2000e901c46ULL, 0x000000100d0d7824ULL, 0x000fc400078e021cULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x0000000014177faeULL, 0x0003e2000e101c46ULL,
0x000000101f1f7824ULL, 0x000fc600078e021cULL, 0x0000000010197faeULL, 0x0003e8000d901c46ULL,
0x000000000e0d7faeULL, 0x0003e8000d101c46ULL, 0x000000000a1d7faeULL, 0x0003e8000c901c46ULL,
0x00000000081f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x000000040d0b7811ULL, 0x042fe200078fe8ffULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000140d137811ULL, 0x040fe400078fe8ffULL, 0x0000000c0d0f7811ULL, 0x000fe200078fe8ffULL,
0x000000010b097824ULL, 0x100fe200078e020dULL, 0x000000080d0e7811ULL, 0x000fe200078fe8ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0x000000240d1a7811ULL, 0x000fe200078fe8ffULL,
0x0000000113127824ULL, 0x100fe200078e020dULL, 0x000000100d107811ULL, 0x000fe200078fe8ffULL,
0x0000000813237824ULL, 0x000fe200078e00ffULL, 0xfffffff80a197812ULL, 0x000fe200078ee209ULL,
0x000000010f0a7824ULL, 0x100fe200078e020dULL, 0x0000001c0d177811ULL, 0x000fe200078fe8ffULL,
0x000000080f1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee212ULL,
0x000000010e097824ULL, 0x140fe200078e020dULL, 0x000000180d157811ULL, 0x040fe200078fe8ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x000000011a127824ULL, 0x140fe200078e020dULL, 0x000000200d187811ULL, 0x040fe200078fe8ffULL,
0x000000081a1d7824ULL, 0x000fe200078e00ffULL, 0x0000002c0d1e7811ULL, 0x000fe200078fe8ffULL,
0x0000000110117824ULL, 0x140fe200078e020dULL, 0xfffffff8141b7812ULL, 0x000fe200078ee209ULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0xfffffff81d227812ULL, 0x000fe200078ee212ULL,
0x00000001170a7824ULL, 0x100fe200078e020dULL, 0x000000280d1d7811ULL, 0x000fe200078fe8ffULL,
0x0000000817277824ULL, 0x000fe200078e00ffULL, 0xfffffff816217812ULL, 0x000fe200078ee211ULL,
0x0000000115097824ULL, 0x100fe200078e020dULL, 0x000000300d247811ULL, 0x000fe200078fe8ffULL,
0x0000000815147824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x0000000118117824ULL, 0x140fe200078e020dULL, 0x000000340d2d7811ULL, 0x040fe200078fe8ffULL,
0x0000000818207824ULL, 0x000fe200078e00ffULL, 0xfffffff814257812ULL, 0x000fe200078ee209ULL,
0x000000011e0a7824ULL, 0x140fe200078e020dULL, 0x000000380d307811ULL, 0x000fe200078fe8ffULL,
0x000000081e297824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x000000011d097824ULL, 0x100fe200078e020dULL, 0x0000003c0d317811ULL, 0x000fe200078fe8ffULL,
0x000000081d267824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x0000000124117824ULL, 0x140fe200078e020dULL, 0x0000000d0d0a7211ULL, 0x000fe200078fe8ffULL,
0x0000000824147824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x000000012d127824ULL, 0x000fe200078e020dULL, 0x000000080d097211ULL, 0x000fe200078fe8ffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000001082a7824ULL, 0x040fe200078e021aULL, 0xfffffff8142b7812ULL, 0x000fe200078ee211ULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL,
0x0000000108127824ULL, 0x040fe200078e0210ULL, 0x0ffffff80a107812ULL, 0x000fe200078ef80dULL,
0x0000000108287824ULL, 0x040fe200078e0218ULL, 0x00000008390a7c11ULL, 0x000fe2000f8e70ffULL,
0x00000001082e7824ULL, 0x000fc400078e021eULL, 0x00000001081a7824ULL, 0x000fe400078e0230ULL,
0x00000001300f7824ULL, 0x000fe400078e020dULL, 0x00000001080b7824ULL, 0x040fe400078e020bULL,
0x00000001080e7824ULL, 0x040fe400078e020eULL, 0x0000000108147824ULL, 0x040fe400078e0213ULL,
0x0000000108167824ULL, 0x000fc400078e0215ULL, 0x00000001081c7824ULL, 0x040fe400078e0217ULL,
0x00000001082c7824ULL, 0x040fe400078e021dULL, 0x0000000108247824ULL, 0x040fe400078e0224ULL,
0x00000001081e7824ULL, 0x000fe400078e022dULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x0000000108187824ULL, 0x000fc400078e0231ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0xfffffff830137812ULL, 0x000fc600078ee20fULL, 0x00000001310d7824ULL, 0x040fe200078e020dULL,
0x0000007008087812ULL, 0x000fe200078ef800ULL, 0x0000000831327824ULL, 0x000fe400078e00ffULL,
0x000010000a307836ULL, 0x000fe20000000000ULL, 0x0000000a08087c10ULL, 0x000fe2000ff1e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff832157812ULL, 0x000fe400078ee20dULL,
0x0000000b09097c10ULL, 0x000fe200087fe4ffULL, 0x00000010100d7824ULL, 0x000fe200078e0230ULL,
0x000000700e0e7812ULL, 0x000fe200078ef800ULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x000fe200078ef800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL,
0x0000001015457824ULL, 0x100fe200078e0230ULL, 0x000000700a0a7812ULL, 0x000fe200078ef800ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000a0a0a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001013437824ULL, 0x000fe200078e0230ULL,
0x0000007014147812ULL, 0x000fe200078ef800ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b11117c10ULL, 0x000fc400087fe4ffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe400078ef800ULL,
0x0000000b0b0b7c10ULL, 0x000fe20008ffe4ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe400078ef800ULL, 0x0000000a12127c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010293d7824ULL, 0x100fe200078e0230ULL, 0x0000007016167812ULL, 0x000fe200078ef800ULL,
0x000000102b3f7824ULL, 0x000fe200078e0230ULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007028327812ULL, 0x000fe400078ef800ULL, 0x0000000b13137c10ULL, 0x000fe20008ffe4ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000702a347812ULL, 0x000fe400078ef800ULL,
0x0000000a32327c10ULL, 0x000fe2000ff3e0ffULL, 0x000000102f417824ULL, 0x000fe200078e0230ULL,
0x000000702c367812ULL, 0x000fe200078ef800ULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000b1d1d7c10ULL, 0x000fc400087fe4ffULL, 0x0000000b17177c10ULL, 0x000fe200097fe4ffULL,
0x0000001019197824ULL, 0x100fe200078e0230ULL, 0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0230ULL, 0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0230ULL, 0x0000000b29337c10ULL, 0x000fe20008ffe4ffULL,
0x0000008024287825ULL, 0x000fe200078e00ffULL, 0x000000702e2e7812ULL, 0x000fe200078ef800ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x0000000b2b357c10ULL, 0x000fe200087fe4ffULL,
0x000000801e2a7825ULL, 0x000fe200078e00ffULL, 0x0000000b2d377c10ULL, 0x000fe200097fe4ffULL,
0x000000000e1b7faeULL, 0x0003e2000b901c46ULL, 0x0000000a2e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0230ULL, 0x0000007028287812ULL, 0x000fe200078ef800ULL,
0x0000001023237824ULL, 0x100fe200078e0230ULL, 0x000000702a2a7812ULL, 0x000fe200078ef800ULL,
0x0000001025257824ULL, 0x100fe200078e0230ULL, 0x0000000b2f2f7c10ULL, 0x000fe200087fe4ffULL,
0x0000001027277824ULL, 0x100fe200078e0230ULL, 0x0000000a28287c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001020207824ULL, 0x100fe200078e0230ULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x0000001022227824ULL, 0x100fe200078e0230ULL, 0x0000000a2a2a7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001026267824ULL, 0x000fe200078e0230ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x000000801a2c7825ULL, 0x000fe200078e00ffULL, 0x0000000b29297c10ULL, 0x000fc400087fe4ffULL,
0x0000000014237faeULL, 0x0003e2000b901c46ULL, 0x0000008018307825ULL, 0x000fe200078e00ffULL,
0x000000702c2c7812ULL, 0x000fe400078ef800ULL, 0x0000000016257faeULL, 0x0003e2000b901c46ULL,
0x0000000b2b2b7c10ULL, 0x000fe40008ffe4ffULL, 0x0000007030007812ULL, 0x000fe200078ef800ULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x0000000a2c2c7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a00307c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000032207faeULL, 0x0003e2000b901c46ULL,
0x0000000b2d2d7c10ULL, 0x000fc400097fe4ffULL, 0x0000000b31317c10ULL, 0x000fe20009ffe4ffULL,
0x0000000034227faeULL, 0x0003e8000b901c46ULL, 0x0000000036267faeULL, 0x0003e8000b901c46ULL,
0x000000002e3d7faeULL, 0x0003e8000b901c46ULL, 0x00000000283f7faeULL, 0x0003e8000b901c46ULL,
0x000000002a417faeULL, 0x0003e8000b901c46ULL, 0x000000002c437faeULL, 0x0003e8000b901c46ULL,
0x0000000030457faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x01760005ff0075a7ULL, 0x004e620008000148ULL,
0x0000000138007824ULL, 0x000fe400078e0a03ULL, 0x00000004020b7c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff007819ULL, 0x000fe20000011600ULL, 0x00008e00ff767b82ULL, 0x000ea40000000a00ULL,
0x000000040b767825ULL, 0x004fe200078e0076ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140bULL, 0x0000000d02027211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000202027819ULL, 0x000fc8000000120bULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01760005ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002039027824ULL, 0x002fca00078e0202ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001004087824ULL, 0x040fe400078e00ffULL,
0x0000000105027836ULL, 0x000fe20000000000ULL, 0x0000000f05057812ULL, 0x000fe200078ec0ffULL,
0x0000001004097824ULL, 0x000fc600078e00ffULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x000000f008057812ULL, 0x000fe400078ee205ULL, 0x000000f009027812ULL, 0x000fe400078ee202ULL,
0x0000000805057c11ULL, 0x000fe4000f8e20ffULL, 0x0000000802027c11ULL, 0x000fc6000f8e20ffULL,
0x0000000005107984ULL, 0x000e680000000c00ULL, 0x0000000002087984ULL, 0x000ea20000000c00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0009ULL, 0x000000ffff137224ULL, 0x000fe200078e000bULL,
0x0000001405007388ULL, 0x0003e20000000c00ULL, 0x00000001ff0a7424ULL, 0x000fc600078e00ffULL,
0x0000001002007388ULL, 0x0003e60000000c00ULL, 0x0176000aff0a79a7ULL, 0x000ea40008500008ULL,
0x0000000000047805ULL, 0x002fce0000015200ULL, 0x0176000bff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000d02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x0176000bff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x0000010007027836ULL, 0x000fe40000000000ULL,
0x3db504f306047820ULL, 0x010fe20000410000ULL, 0x0000000839067c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff03077836ULL, 0x000fe20000000000ULL, 0x0000000839097c11ULL, 0x000fe2000f8e28ffULL,
0x0000000903087836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fd200078e00ffULL,
0x000000020b0d7836ULL, 0x000fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x000001000b0a7824ULL, 0x008fc600078e0202ULL, 0x0000000c0d00720cULL, 0x000fe20003f06070ULL,
0x000000043b0e7c24ULL, 0x000fe2000f8e020aULL, 0x00000001140d7812ULL, 0x000fd600078e0cffULL,
0x0000000c00308947ULL, 0x002fea0003800000ULL, 0x00000003ff247819ULL, 0x002fe20000011605ULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000a38157248ULL, 0x000fc60007fe0000ULL,
0x0000000424127836ULL, 0x000fe40000000000ULL, 0x0000000115157824ULL, 0x000fe400078e0a0aULL,
0x00000001120f7824ULL, 0x040fe400078e0205ULL, 0x00000008122e7824ULL, 0x040fe200078e00ffULL,
0x000000151200720cULL, 0x040fe20003fa6070ULL, 0x0000000112127824ULL, 0x000fe400078e020eULL,
0x0000000824167836ULL, 0x000fe20000000000ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x00000010050f7824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000000700f0f7812ULL, 0x000fe200078ec0ffULL, 0x00000001162c7824ULL, 0x040fe400078e0205ULL,
0x0000000816117824ULL, 0x000fe200078e00ffULL, 0x0000000f121e7212ULL, 0x000fe200078efcffULL,
0x0000000124107824ULL, 0x000fe400078e020eULL, 0x0000000c24187836ULL, 0x000fe20000000000ULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010241a7836ULL, 0x000fe20000000000ULL,
0xfffffff8112c7812ULL, 0x000fe200078ee22cULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000b131f7c10ULL, 0x000fc40008ffe4ffULL, 0x000000151600720cULL, 0x040fe20003f26070ULL,
0x0000000116127824ULL, 0x100fe200078e020eULL, 0x0000000f10107212ULL, 0x000fe200078efcffULL,
0x0000000118177824ULL, 0x140fe200078e0205ULL, 0x000000151800720cULL, 0x0c0fe20003f46070ULL,
0x0000000818307824ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000011a2a7824ULL, 0x040fe400078e0205ULL, 0x000000081a197824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee217ULL, 0x0000000118167824ULL, 0x000fe200078e020eULL,
0x0000000b11117c10ULL, 0x000fe200087fe4ffULL, 0x0000001424287836ULL, 0x000fe20000000000ULL,
0xfffffff8192a7812ULL, 0x000fe200078ee22aULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000151a00720cULL, 0x000fc60003f06070ULL, 0x000000011a187824ULL, 0x000fe200078e020eULL,
0x0000000f121c7212ULL, 0x000fe200078efcffULL, 0x0000001824347836ULL, 0x000fe40000000000ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fc6000ff7e0ffULL,
0x0000000128227824ULL, 0x100fe200078e020eULL, 0x0000000f16207212ULL, 0x080fe200078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000b131d7c10ULL, 0x000fe40009ffe4ffULL,
0x0000000a20207c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000134267824ULL, 0x000fe200078e020eULL,
0x0000000f181a7212ULL, 0x080fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000b17217c10ULL, 0x000fe4000a7fe4ffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000f22187212ULL, 0x000fc400078efcffULL,
0x0000000839167c11ULL, 0x000fe2000f8e70ffULL, 0x0000000124257824ULL, 0x100fe200078e0205ULL,
0x0000000f26127212ULL, 0x000fe200078efcffULL, 0x0000000828327824ULL, 0x040fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fe2000ff9e0ffULL, 0x000020000d177824ULL, 0x000fe200078e0216ULL,
0x0000000b191b7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001c24367836ULL, 0x000fe20000000000ULL,
0x0000000a12127c10ULL, 0x000fe2000ff7e0ffULL, 0x0000100017177836ULL, 0x000fe20000000000ULL,
0x0000000b23197c10ULL, 0x000fe2000a7fe4ffULL, 0x0000002824407836ULL, 0x000fe20000000000ULL,
0x0000000725267812ULL, 0x000fe200078ec0ffULL, 0x0000000128257824ULL, 0x000fe200078e0205ULL,
0x000000152400720cULL, 0x080fe20003f86070ULL, 0x0000000136227824ULL, 0x100fe200078e020eULL,
0x0000000b27137c10ULL, 0x000fe20009ffe4ffULL, 0x00000001402b7824ULL, 0x000fe200078e020eULL,
0x000000152800720cULL, 0x000fe20003f66070ULL, 0x00000020243c7836ULL, 0x000fe20000000000ULL,
0x0ffffff826287812ULL, 0x000fe200078ef805ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fc600078ee225ULL, 0x0000001028257824ULL, 0x000fe200078e0217ULL,
0x0000000f22227212ULL, 0x000fe200078efcffULL, 0x000000013c267824ULL, 0x100fe400078e020eULL,
0x00000024243e7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0003e2000e101c46ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x000000153400720cULL, 0x000fe40003f86070ULL, 0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL,
0x000000013e287824ULL, 0x000fe200078e020eULL, 0x0000000f26267212ULL, 0x000fe200078efcffULL,
0x00000001342d7824ULL, 0x040fe200078e0205ULL, 0x0000000b23237c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0x0000000a26267c10ULL, 0x000fe2000ffde0ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee22dULL,
0x000000102e257824ULL, 0x002fe200078e0217ULL, 0x0000000f28287212ULL, 0x000fe200078efcffULL,
0x000000802b107825ULL, 0x000fe200078e00ffULL, 0x0000000b27277c10ULL, 0x000fe4000b7fe4ffULL,
0x000000001e257faeULL, 0x0003e2000e901c46ULL, 0x00000001362b7824ULL, 0x040fe200078e0205ULL,
0x000000153600720cULL, 0x040fe20003fa6070ULL, 0x00000008362e7824ULL, 0x000fe200078e00ffULL,
0x0000000a28287c10ULL, 0x000fe2000ffde0ffULL, 0x000000083c2f7824ULL, 0x000fe200078e00ffULL,
0x0000000f10107212ULL, 0x000fe200078efcffULL, 0x0000002c24367836ULL, 0x000fe20000000000ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee22bULL, 0x000000102c2b7824ULL, 0x000fe200078e0217ULL,
0x0000000b29297c10ULL, 0x000fe2000b7fe4ffULL, 0x000000013c2c7824ULL, 0x000fe200078e0205ULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x0000001030257824ULL, 0x002fe200078e0217ULL,
0x000000001c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000013e2d7824ULL, 0x000fe200078e0205ULL,
0xfffffff82f2c7812ULL, 0x000fe200078ee22cULL, 0x00000001361e7824ULL, 0x000fe200078e020eULL,
0x0000000020257faeULL, 0x0005e2000d101c46ULL, 0x000000153e00720cULL, 0x0c0fe20003f46070ULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000153c00720cULL, 0x000fc60003f26070ULL,
0x000000102a1d7824ULL, 0x102fe200078e0217ULL, 0xfffffff83e1c7812ULL, 0x000fe200078ee22dULL,
0x00000030242a7836ULL, 0x000fe20000000000ULL, 0x0000000f1e1e7212ULL, 0x000fe200078efcffULL,
0x0000001032217824ULL, 0x104fe200078e0217ULL, 0x000000001a1d7faeULL, 0x0003e2000c101c46ULL,
0x0000001034257824ULL, 0x100fe200078e0217ULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000102c2d7824ULL, 0x100fe200078e0217ULL, 0x0000000018217faeULL, 0x0005e2000d901c46ULL,
0x00000034242c7836ULL, 0x000fe20000000000ULL, 0x0000000b1f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101c2f7824ULL, 0x100fe200078e0217ULL, 0x0000000012257faeULL, 0x0007e2000e101c46ULL,
0x000000102e2b7824ULL, 0x000fe200078e0217ULL, 0x000000153600720cULL, 0x080fe20003f86070ULL,
0x00000038242e7836ULL, 0x000fe20000000000ULL, 0x000000152a00720cULL, 0x0c0fe20003f66070ULL,
0x000000012a1a7824ULL, 0x102fe200078e020eULL, 0x00000000222b7faeULL, 0x0003e2000e901c46ULL,
0x00000008401b7824ULL, 0x040fe200078e00ffULL, 0x000000154000720cULL, 0x080fe20003fa6070ULL,
0x000000012c187824ULL, 0x004fe200078e020eULL, 0x00000000262d7faeULL, 0x0005e2000c901c46ULL,
0x0000003c24307836ULL, 0x000fe20000000000ULL, 0x000000152e00720cULL, 0x080fe20003f26070ULL,
0x000000801a127825ULL, 0x008fe200078e00ffULL, 0x00000000282f7faeULL, 0x0007e2000d101c46ULL,
0x000000152c00720cULL, 0x000fc40003f46070ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000f12127212ULL, 0x000fe400078efcffULL, 0x000000153000720cULL, 0x000fe20003f06070ULL,
0x00000001401a7824ULL, 0x100fe200078e0205ULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x0000000136157824ULL, 0x100fe200078e0205ULL, 0x0000000f181c7212ULL, 0x000fe200078efcffULL,
0x000000012e187824ULL, 0x000fe200078e020eULL, 0xfffffff81b207812ULL, 0x000fe200078ee21aULL,
0x000000012a1a7824ULL, 0x040fe200078e0205ULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000082a1b7824ULL, 0x000fe200078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000836227824ULL, 0x002fc400078e00ffULL, 0x000000082c267824ULL, 0x004fe200078e00ffULL,
0x0000000b191d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0xfffffff81b247812ULL, 0x000fe400078ee21aULL, 0xfffffff822227812ULL, 0x000fe200078ee215ULL,
0x00000001301a7824ULL, 0x000fe200078e020eULL, 0x0000000f18187212ULL, 0x000fe200078efcffULL,
0x000000012c157824ULL, 0x000fe400078e0205ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc4000ffde0ffULL, 0xfffffff826267812ULL, 0x000fe200078ee215ULL,
0x000000012e0e7824ULL, 0x100fe200078e0205ULL, 0x0000000f1a0f7212ULL, 0x000fe200078efcffULL,
0x000000082e237824ULL, 0x000fe200078e00ffULL, 0x0000000b19197c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000130217824ULL, 0x040fe400078e0205ULL, 0x00000008302a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823287812ULL, 0x008fe200078ee20eULL, 0x0000001020157824ULL, 0x100fe200078e0217ULL,
0x0000000a0f0e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001024237824ULL, 0x100fe200078e0217ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee221ULL, 0x0000001022217824ULL, 0x100fe200078e0217ULL,
0x0000000b1b0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001026257824ULL, 0x100fe200078e0217ULL,
0x0000000010157faeULL, 0x0003e2000e901c46ULL, 0x0000001028277824ULL, 0x000fc400078e0217ULL,
0x000000102a177824ULL, 0x000fe200078e0217ULL, 0x000000001e217faeULL, 0x0003e8000e101c46ULL,
0x0000000012237faeULL, 0x0003e8000d901c46ULL, 0x000000001c257faeULL, 0x0003e8000d101c46ULL,
0x0000000018277faeULL, 0x0003e8000c901c46ULL, 0x000000000e177faeULL, 0x0003e2000c101c46ULL,
0x0000000800e07947ULL, 0x000fea0003800000ULL, 0x0000000805127811ULL, 0x042fe200078fe8ffULL,
0x0000001005497824ULL, 0x040fe200078e00ffULL, 0x0000000405107811ULL, 0x040fe200078fe8ffULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x00000010051a7811ULL, 0x040fe200078fe8ffULL,
0x0000000112117824ULL, 0x140fe200078e0205ULL, 0x0000000c05187811ULL, 0x040fe200078fe8ffULL,
0x0000000812367824ULL, 0x000fe200078e00ffULL, 0x00000014051c7811ULL, 0x040fe200078fe8ffULL,
0x00000001100f7824ULL, 0x140fe200078e0205ULL, 0x00000018051e7811ULL, 0x040fe200078fe8ffULL,
0x0000000810347824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x000000011a117824ULL, 0x140fe200078e0205ULL, 0x0000002005227811ULL, 0x040fe200078fe8ffULL,
0x000000081a3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x00000001180f7824ULL, 0x140fe200078e0205ULL, 0x0000001c05207811ULL, 0x040fe200078fe8ffULL,
0x00000008183c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee211ULL,
0x000000011c137824ULL, 0x140fe200078e0205ULL, 0x0000002405247811ULL, 0x040fe200078fe8ffULL,
0x000000081c407824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL,
0x000000011e157824ULL, 0x140fe200078e0205ULL, 0x0000002805267811ULL, 0x040fe200078fe8ffULL,
0x000000081e427824ULL, 0x000fe200078e00ffULL, 0x0000003005327811ULL, 0x040fe200078fe8ffULL,
0x0000000122117824ULL, 0x140fe200078e0205ULL, 0x0000002c05287811ULL, 0x040fe200078fe8ffULL,
0x0000000822467824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x00000001200f7824ULL, 0x140fe200078e0205ULL, 0xfffffff842427812ULL, 0x000fe200078ee215ULL,
0x0000000820447824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee211ULL,
0x0000000124137824ULL, 0x140fe200078e0205ULL, 0x0000003405307811ULL, 0x040fe200078fe8ffULL,
0x0000000824487824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20fULL,
0x0000000126157824ULL, 0x140fe200078e0205ULL, 0x00000038052e7811ULL, 0x040fe200078fe8ffULL,
0x00000008264a7824ULL, 0x000fe200078e00ffULL, 0x0000003c052c7811ULL, 0x000fe200078fe8ffULL,
0x0000000132117824ULL, 0x140fe200078e0205ULL, 0xfffffff848487812ULL, 0x000fe200078ee213ULL,
0x00000008324e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee215ULL,
0x00000001280f7824ULL, 0x140fe200078e0205ULL, 0x0000007049497812ULL, 0x000fe200078ec0ffULL,
0x00000008284c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee211ULL,
0x0000000130137824ULL, 0x140fe200078e0205ULL, 0x0000000839167c11ULL, 0x000fe2000f8e70ffULL,
0x0000000830507824ULL, 0x000fe200078e00ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee20fULL,
0x000000012e157824ULL, 0x140fe200078e0205ULL, 0x00000005050f7211ULL, 0x000fe200078fe8ffULL,
0x000000082e527824ULL, 0x000fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee213ULL,
0x000000012c117824ULL, 0x040fe200078e0205ULL, 0x000000070f2a7812ULL, 0x000fe200078ec0ffULL,
0x000000082c547824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee215ULL,
0x0000000110107824ULL, 0x100fe200078e020eULL, 0x0ffffff82a2a7812ULL, 0x000fe200078ef805ULL,
0x0000000112127824ULL, 0x100fe200078e020eULL, 0xfffffff854547812ULL, 0x000fe200078ee211ULL,
0x0000000118187824ULL, 0x000fc400078e020eULL, 0x000000011a1a7824ULL, 0x100fe400078e020eULL,
0x000000011c1c7824ULL, 0x100fe400078e020eULL, 0x000000011e1e7824ULL, 0x100fe400078e020eULL,
0x0000000120207824ULL, 0x100fe400078e020eULL, 0x0000000122227824ULL, 0x100fe400078e020eULL,
0x0000000124247824ULL, 0x000fc400078e020eULL, 0x0000000126267824ULL, 0x100fe400078e020eULL,
0x0000000128287824ULL, 0x100fe400078e020eULL, 0x0000000132327824ULL, 0x100fe400078e020eULL,
0x0000000130307824ULL, 0x100fe400078e020eULL, 0x000000012e2e7824ULL, 0x100fe400078e020eULL,
0x000000012c2c7824ULL, 0x000fe200078e020eULL, 0x0000000e050e7211ULL, 0x000fe200078fe8ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004912127212ULL, 0x000fc600078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000490e0e7212ULL, 0x000fc600078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000004918187212ULL, 0x080fe200078efcffULL,
0x000020000d117824ULL, 0x000fe200078e0216ULL, 0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000a12127c10ULL, 0x000fe4000ff1e0ffULL,
0x000000491c1c7212ULL, 0x000fe200078efcffULL, 0x0000100011157836ULL, 0x000fe20000000000ULL,
0x0000000b13137c10ULL, 0x000fe200087fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc4000ff1e0ffULL, 0x0000004920207212ULL, 0x080fe200078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000b19197c10ULL, 0x000fe400087fe4ffULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004910107212ULL, 0x000fe400078efcffULL, 0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000a20207c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000a10107c10ULL, 0x000fe2000ff3e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000004924247212ULL, 0x080fe400078efcffULL, 0x000000491a1a7212ULL, 0x080fe200078efcffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000000491e1e7212ULL, 0x000fe400078efcffULL,
0x0000000b21217c10ULL, 0x000fe200087fe4ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000b11117c10ULL, 0x000fc40008ffe4ffULL, 0x0000000a24247c10ULL, 0x000fe2000ff1e0ffULL,
0x000000104a2f7824ULL, 0x100fe200078e0215ULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000104c2d7824ULL, 0x100fe200078e0215ULL, 0x0000004928287212ULL, 0x080fe200078efcffULL,
0x00000080324a7825ULL, 0x000fe200078e00ffULL, 0x0000000a1e1e7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000004922227212ULL, 0x080fe200078efcffULL, 0x000000102a477824ULL, 0x100fe200078e0215ULL,
0x0000004926267212ULL, 0x000fe200078efcffULL, 0x000000104e2b7824ULL, 0x100fe200078e0215ULL,
0x0000000b25257c10ULL, 0x000fe200087fe4ffULL, 0x00000080304c7825ULL, 0x000fe200078e00ffULL,
0x0000000b1b1b7c10ULL, 0x000fe20008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e477faeULL, 0x0003e2000b901c46ULL, 0x0000000a28287c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001034457824ULL, 0x100fe200078e0215ULL, 0x0000000b1f1f7c10ULL, 0x000fe200097fe4ffULL,
0x00000010502a7824ULL, 0x100fe200078e0215ULL, 0x0000000a22227c10ULL, 0x000fe2000ff3e0ffULL,
0x000000802e4e7825ULL, 0x000fe200078e00ffULL, 0x0000000a26267c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000010457faeULL, 0x0003e2000b901c46ULL, 0x0000000b29297c10ULL, 0x000fe200087fe4ffULL,
0x0000001036437824ULL, 0x000fe200078e0215ULL, 0x0000000b23237c10ULL, 0x000fe20008ffe4ffULL,
0x000000802c507825ULL, 0x000fe200078e00ffULL, 0x0000000b27277c10ULL, 0x000fc400097fe4ffULL,
0x0000000012437faeULL, 0x0003e2000b901c46ULL, 0x000000103c417824ULL, 0x100fe400078e0215ULL,
0x0000001048317824ULL, 0x100fe200078e0215ULL, 0x000000494a487212ULL, 0x080fe200078efcffULL,
0x000000103e3f7824ULL, 0x100fe200078e0215ULL, 0x000000494c4a7212ULL, 0x080fe200078efcffULL,
0x00000010403d7824ULL, 0x100fe200078e0215ULL, 0x000000494e4c7212ULL, 0x080fe200078efcffULL,
0x0000001042377824ULL, 0x100fe200078e0215ULL, 0x0000004950497212ULL, 0x000fe200078efcffULL,
0x0000001044357824ULL, 0x100fe200078e0215ULL, 0x0000000a48487c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001046337824ULL, 0x100fe200078e0215ULL, 0x0000000018417faeULL, 0x0003e2000b901c46ULL,
0x0000000a4a4a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001052177824ULL, 0x100fe200078e0215ULL,
0x0000000a4c4c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000001a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000a494e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001054157824ULL, 0x000fe200078e0215ULL,
0x0000000b4b497c10ULL, 0x000fe200087fe4ffULL, 0x000000001c3d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b4d4b7c10ULL, 0x000fc40008ffe4ffULL, 0x0000000b4f4d7c10ULL, 0x000fe200097fe4ffULL,
0x000000001e377faeULL, 0x0003e2000b901c46ULL, 0x0000000b514f7c10ULL, 0x000fc60009ffe4ffULL,
0x0000000020357faeULL, 0x0003e8000b901c46ULL, 0x0000000022337faeULL, 0x0003e8000b901c46ULL,
0x0000000024317faeULL, 0x0003e8000b901c46ULL, 0x00000000262f7faeULL, 0x0003e8000b901c46ULL,
0x00000000282d7faeULL, 0x0003e8000b901c46ULL, 0x00000000482b7faeULL, 0x0003e8000b901c46ULL,
0x000000004a2a7faeULL, 0x0003e8000b901c46ULL, 0x000000004c177faeULL, 0x0003e8000b901c46ULL,
0x000000004e157faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020050e7836ULL, 0x002fe20000000000ULL, 0xfffffff805427812ULL, 0x040fe200078ec0ffULL,
0x0000200014417824ULL, 0x000fe200078e0216ULL, 0x0000000705407812ULL, 0x000fe200078ec0ffULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ec0ffULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x00000004ff0f7819ULL, 0x000fc40000011605ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000100041417836ULL, 0x000fe20000000000ULL,
0x0000000742427812ULL, 0x000fe200078ef805ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000840437812ULL, 0x000fe400078ef805ULL, 0x000000070e0e7812ULL, 0x000fce00078ef805ULL,
0x0000000142107824ULL, 0x140fe400078e0245ULL, 0x0000000842117824ULL, 0x000fe400078e00ffULL,
0x000000010e147824ULL, 0x040fe400078e0245ULL, 0x000000080e157824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x0000000145477836ULL, 0x000fe40000000000ULL,
0x0000000245607824ULL, 0x000fe200078e020fULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x0000001010107824ULL, 0x000fc400078e0241ULL, 0x0000000245457836ULL, 0x000fe40000000000ULL,
0x0000001014147824ULL, 0x000fe400078e0241ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000084500780cULL, 0x000fc60003f05270ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010587816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115b7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x00000018ff637819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880125e7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00000010005d7306ULL, 0x0002e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff667819ULL, 0x004fe40000011414ULL, 0x00008880146a7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe20000011415ULL, 0x00000011005a7306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x042fe200078e00ffULL, 0x0000888015687816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011416ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x004fe200078e00ffULL, 0x0000001c00797306ULL, 0x000fe20000200c00ULL,
0x00000018ff447819ULL, 0x000fc40000011417ULL, 0x0000888016647816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880175c7816ULL, 0x000fe200000000ffULL,
0x0000001200707306ULL, 0x0003e20000200c00ULL, 0x00000018ff657819ULL, 0x000fe40000011413ULL,
0x00008880136e7816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fc800078e00ffULL,
0x0000001100737306ULL, 0x0005e20000200c00ULL, 0x0000000842127824ULL, 0x002fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fcc0000011413ULL, 0x0000001d00727306ULL, 0x0003e20000200c00ULL,
0x0000000142117824ULL, 0x104fe400078e0247ULL, 0x000000010e477824ULL, 0x000fc600078e0247ULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0001000015117824ULL, 0x040fe200078e00ffULL,
0x0000001000757306ULL, 0x0005e20000200c00ULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e0241ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000000121c783bULL, 0x002e620000000200ULL,
0x0001000014107824ULL, 0x044fe200078e00ffULL, 0x00000011006d7306ULL, 0x000fe20000200c00ULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000015006b7306ULL, 0x0005f00000200c00ULL,
0x00000014006f7306ULL, 0x0009e20000200c00ULL, 0x0000001043157824ULL, 0x004fce00078e00ffULL,
0x0000001000717306ULL, 0x0005e20000200c00ULL, 0x000000080e147824ULL, 0x010fca00078e00ffULL,
0xfffffff814147812ULL, 0x000fe400078ee247ULL, 0x00000013006c7306ULL, 0x0009e20000200c00ULL,
0x0001000016107824ULL, 0x004fe400078e00ffULL, 0x0000001014117824ULL, 0x000fe400078e0241ULL,
0x0001000017147824ULL, 0x040fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011410ULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x002fe2000001141cULL,
0x0000010017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000000001110783bULL, 0x010e620000000200ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x000088801c487816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001141dULL,
0x000088801d507816ULL, 0x000fe200000000ffULL, 0x0000001400617306ULL, 0x0009e20000200c00ULL,
0x00000018ff4d7819ULL, 0x000fe4000001141eULL, 0x000088801e527816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fc6000001141fULL, 0x0000001600677306ULL, 0x000fe20000200c00ULL,
0x000100001c147824ULL, 0x050fe400078e00ffULL, 0x000001001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011414ULL, 0x0000000143147824ULL, 0x000fe200078e0260ULL,
0x00000017005f7306ULL, 0x0009e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fc6000001141cULL,
0xfffffff015147812ULL, 0x000fe200078ee214ULL, 0x000100001d157824ULL, 0x040fe400078e00ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000814147c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c00517306ULL, 0x000be20000200c00ULL, 0x00000018ff537819ULL, 0x000fe40000011415ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x000000001414783bULL, 0x010f220000000200ULL,
0x00000018ff4b7819ULL, 0x002fc40000011410ULL, 0x0000001d00557306ULL, 0x0007e20000200c00ULL,
0x000100001e1c7824ULL, 0x060fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011411ULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011412ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000054105d1d7816ULL, 0x008fe40000000054ULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x00000018ff477819ULL, 0x000fc60000011413ULL, 0x0000001c00577306ULL, 0x0005f00000200c00ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x00005410581c7816ULL, 0x004fe40000000079ULL,
0x000088801f587816ULL, 0x000fca00000000ffULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x0000001c143c723cULL, 0x010fee000000183cULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000100001f1d7824ULL, 0x000fe200078e00ffULL, 0x000054105b1c7816ULL, 0x002fe20000000072ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888011727816ULL, 0x000fc800000000ffULL,
0x0000001e00547306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff1f7819ULL, 0x000fca000001141fULL, 0x0000001d005d7306ULL, 0x0007e20000200c00ULL,
0x00008880101e7816ULL, 0x002fce00000000ffULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x000054105a1d7816ULL, 0x008fe20000000059ULL, 0x00010000105a7824ULL, 0x040fe400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000001c1434723cULL, 0x000fe20000001834ULL, 0x0000006e006e7306ULL, 0x000eec0000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe20000011410ULL, 0x00000010431d7824ULL, 0x040fe200078e00ffULL,
0x0000000243107810ULL, 0x000fe20007ffe060ULL, 0x0000001e00597306ULL, 0x0009e60000200c00ULL,
0xfffffff01d107812ULL, 0x000fc400078ee210ULL, 0x00005410701d7816ULL, 0x004fe20000000063ULL,
0x0000010011707824ULL, 0x040fe200078e00ffULL, 0x0000000810107c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c00607306ULL, 0x0005e20000200c00ULL, 0x00010000111e7824ULL, 0x010fe200078e00ffULL,
0x000054106c117816ULL, 0x002fe20000000065ULL, 0x00010000126c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011470ULL, 0x00000018ff637819ULL, 0x000fe4000001141eULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x000054105e1c7816ULL, 0x004fce0000000075ULL,
0x0000001f005b7306ULL, 0x0005e20000200c00ULL, 0x0000001c1430723cULL, 0x000fee0000001830ULL,
0x0000006600667306ULL, 0x000f220000200c00ULL, 0x00000000101c783bULL, 0x0046ae0000000200ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000054106e107816ULL, 0x008fce0000000073ULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x00000010142c723cULL, 0x000fee000000182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000054106a107816ULL, 0x002fe20000000071ULL, 0x0000010012127824ULL, 0x000fc400078e00ffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0011ULL, 0x000054106f117816ULL, 0x010fe40000000066ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000006400647306ULL, 0x000fe80000200c00ULL,
0x000000101428723cULL, 0x000fe80000001828ULL, 0x0000006900697306ULL, 0x000e660000200c00ULL,
0x0000541068107816ULL, 0x008fc4000000006dULL, 0x000054106b117816ULL, 0x000fe40000000062ULL,
0x00000018ff6b7819ULL, 0x000fe2000001146cULL, 0x0000004400447306ULL, 0x000fe80000200c00ULL,
0x000000101424723cULL, 0x000fe80000001824ULL, 0x0000005c005c7306ULL, 0x000ee60000200c00ULL,
0x0000541064107816ULL, 0x002fc40000000069ULL, 0x0000541067117816ULL, 0x000fe40000000056ULL,
0x0000888013567816ULL, 0x000fe200000000ffULL, 0x0000004600467306ULL, 0x000fe80000200c00ULL,
0x000000101420723cULL, 0x000fe80000001820ULL, 0x0000004800487306ULL, 0x000fe60000200c00ULL,
0x000054105c107816ULL, 0x008fc40000000061ULL, 0x000054105f117816ULL, 0x000fe20000000044ULL,
0x000000ffff447224ULL, 0x000fe400078e0056ULL, 0x0000004f004f7306ULL, 0x000e680000200c00ULL,
0x000000101418723cULL, 0x000fe80000001818ULL, 0x0000004c004c7306ULL, 0x000ee60000200c00ULL,
0x0001000013117824ULL, 0x000fc400078e00ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x0000541048107816ULL, 0x002fe4000000004fULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541051117816ULL, 0x000fe40000000046ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x000054105b177816ULL, 0x008fe2000000004cULL,
0x0000005300537306ULL, 0x000e640000200c00ULL, 0x000000101c3c723cULL, 0x004fec000000183cULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541050507816ULL, 0x002fce0000000053ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541055517816ULL, 0x004fce000000004eULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000000501c34723cULL, 0x000fe20000001834ULL,
0x0000541054537816ULL, 0x002fcc000000004dULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00005410605b7816ULL, 0x004fce000000004bULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000004700477306ULL, 0x000ff00000200c00ULL, 0x0000005200527306ULL, 0x000e700000200c00ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x0000541052527816ULL, 0x002fce0000000057ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000000521c30723cULL, 0x000fe20000001830ULL,
0x0000541058167816ULL, 0x004fcc000000005dULL, 0x00000072005e7306ULL, 0x000fe20000200c00ULL,
0x000000161c2c723cULL, 0x000fe2000000182cULL, 0x00005410595a7816ULL, 0x002fcc000000005aULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000005a1c28723cULL, 0x000fee0000001828ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x000054105e5e7816ULL, 0x002fce0000000063ULL,
0x0000006a00667306ULL, 0x000fe20000200c00ULL, 0x00005410655f7816ULL, 0x004fce000000004aULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x0000005e1c24723cULL, 0x000fee0000001824ULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x0000541066487816ULL, 0x002fce000000006bULL,
0x0000004400147306ULL, 0x000fe20000200c00ULL, 0x0000541012497816ULL, 0x004fce0000000049ULL,
0x0000001500117306ULL, 0x000e620000200c00ULL, 0x000000481c20723cULL, 0x000fee0000001820ULL,
0x0000001300107306ULL, 0x000ea20000200c00ULL, 0x0000541014147816ULL, 0x002fe40000000011ULL,
0x0000541010157816ULL, 0x004fce0000000047ULL, 0x000000141c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000280947ULL, 0x000fde000383ffffULL,
0x00000001ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000043c1d7220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x000000043e3e7220ULL, 0x080fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0176880f060e79a7ULL, 0x000e62000850003fULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x0000000430307220ULL, 0x080fe20000410000ULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x00000004181e7220ULL, 0x080fe20000410000ULL, 0x00000004191f7220ULL, 0x080fe20000410000ULL,
0x000000041a1c7220ULL, 0x080fe20000410000ULL, 0x000000041b1b7220ULL, 0x000fe20000410000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x0176880f060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff147224ULL, 0x000fce00078e00ffULL,
0x000000101400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000114147836ULL, 0x000fce0000000000ULL,
0x0176880f060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004050e7824ULL, 0x000fe200078e00ffULL, 0x00000008390f7c11ULL, 0x000fe4000f8e38ffULL,
0x000000000b00720cULL, 0x000fe40003f06070ULL, 0xfffffff00e0e7812ULL, 0x000fca00078ec0ffULL,
0x000000010f1a7824ULL, 0x000fca00078e020eULL, 0x017400001a107984ULL, 0x0002a20000000c00ULL,
0x0000001400248947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000000400147d06ULL, 0x000ee20008209000ULL,
0xffffff000a417836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf85070ULL,
0x00000002053c7824ULL, 0x000fe200078e00ffULL, 0x00000004ff427c12ULL, 0x000fe4000f8e33ffULL,
0x00000041380a7248ULL, 0x000fe40007fe0000ULL, 0x000000063c3c7812ULL, 0x000fc600078ec0ffULL,
0x000000010a417824ULL, 0x000fe400078e0a41ULL, 0x000000013c0a7824ULL, 0x000fe200078e0203ULL,
0x0000001400147308ULL, 0x008ee20000001000ULL, 0x000000ffff5c7224ULL, 0x000fca00078e0a41ULL,
0x0000005c0a517246ULL, 0x000fe20003800007ULL, 0x0ffffffe14167836ULL, 0x008fc80000000000ULL,
0x00000016000f7305ULL, 0x000ee4000021f000ULL, 0x000000ffff157224ULL, 0x008fc800078e0a0fULL,
0x0000000415157c24ULL, 0x000fc8000f8e02ffULL, 0x000000150f177227ULL, 0x000fe200078e000eULL,
0x0000003a050e7211ULL, 0x000fca00078ff0ffULL, 0x0000000e170f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fc800078e0a0fULL, 0x0000000415147c24ULL, 0x000fe4000f8e020eULL,
0x000000080e0e7836ULL, 0x000fc60000000000ULL, 0x0000000414007c0cULL, 0x000fe2000bf06070ULL,
0x0000000e17157227ULL, 0x000fc800078e00ffULL, 0x000000ffff177224ULL, 0x000fc800078e0a15ULL,
0x0000000417167c24ULL, 0x000fc8000f8e020eULL, 0x8000000414140c36ULL, 0x000fe20008000000ULL,
0x0000000416007c0cULL, 0x000fe2000bf46070ULL, 0x000000010f0f0836ULL, 0x000fc60000000000ULL,
0x0000000414007c0cULL, 0x000fe2000bf26070ULL, 0x0000000108147824ULL, 0x000fca00078e023cULL,
0x000000411400720cULL, 0x080fe40003f66070ULL, 0x0000005c14147246ULL, 0x000fe20003800007ULL,
0x8000000416162c36ULL, 0x000fe40008000000ULL, 0x0000000115152836ULL, 0x000fe20000000000ULL,
0x00000004ff147819ULL, 0x000fe20000011614ULL, 0x000000010f0f1836ULL, 0x000fe20000000000ULL,
0x0000000416007c0cULL, 0x000fe4000bf06070ULL, 0x000000410a00720cULL, 0x000fc40003f26070ULL,
0x0000000f420e7207ULL, 0x000fe40006000000ULL, 0x000000ff140f7207ULL, 0x000fe40001800000ULL,
0x0000000e070e7248ULL, 0x000fe40003fe0000ULL, 0x000000ff51517207ULL, 0x000fc60000800000ULL,
0x000000050e5e7c24ULL, 0x000fe4000f8e02ffULL, 0x0000000115150836ULL, 0x000fe40000000000ULL,
0x000000015e177824ULL, 0x000fe200078e020fULL, 0x0000005e51197211ULL, 0x000fe400078fe0ffULL,
0x00000015420e7207ULL, 0x000fe20006000000ULL, 0x0000000217167825ULL, 0x100fe200078e0076ULL,
0x000000103c447812ULL, 0x000fe400078efcffULL, 0x0000000e070e7248ULL, 0x000fe20003fe0000ULL,
0x0000000219187825ULL, 0x000fe200078e0076ULL, 0x0000000616537981ULL, 0x000726000c1e9500ULL,
0x0000000144467824ULL, 0x000fe200078e0203ULL, 0x00000006185a7981ULL, 0x000b22000c1e9500ULL,
0x000000050e607c24ULL, 0x000fc4000f8e02ffULL, 0x0000000108167824ULL, 0x008fe200078e0244ULL,
0x000000414600720cULL, 0x080fe20003f06070ULL, 0x000000010f157824ULL, 0x000fe200078e0260ULL,
0x0000005c46427246ULL, 0x000fe40003800007ULL, 0x0000005c16177246ULL, 0x000fe20003800007ULL,
0x0000000215147825ULL, 0x000fe200078e0076ULL, 0x00000060510f7211ULL, 0x000fe400078fe0ffULL,
0x000000411600720cULL, 0x000fe40003f26070ULL, 0x00000004ff177819ULL, 0x000fe20000011617ULL,
0x000000020f0e7825ULL, 0x000fe200078e0076ULL, 0x000000ff42427207ULL, 0x000fe20000000000ULL,
0x00000006144d7981ULL, 0x0044e2000c1e9500ULL, 0x000000203c4a7812ULL, 0x000fc400078efcffULL,
0x000000ff17457207ULL, 0x000fe20000800000ULL, 0x000000060e587981ULL, 0x0004e2000c1e9500ULL,
0x0000005e42177211ULL, 0x000fe200078fe0ffULL, 0x00000001084e7824ULL, 0x000fe400078e024aULL,
0x000000014a4c7824ULL, 0x000fe400078e0203ULL, 0x0000000217167825ULL, 0x000fe200078e0076ULL,
0x0000005c4e477246ULL, 0x000fe40003800007ULL, 0x000000414e00720cULL, 0x080fe20003f26070ULL,
0x000000015e197824ULL, 0x022fe200078e0245ULL, 0x0000000616487981ULL, 0x000362000c1e9500ULL,
0x0000006042157211ULL, 0x004fe200078fe0ffULL, 0x00000001450f7824ULL, 0x000fe200078e0260ULL,
0x000000414c00720cULL, 0x000fe20003f06070ULL, 0x0000000219187825ULL, 0x000fe200078e0076ULL,
0x000000303c507812ULL, 0x000fc400078efcffULL, 0x00000004ff167819ULL, 0x002fe20000011647ULL,
0x000000020f0e7825ULL, 0x100fe200078e0076ULL, 0x0000005c4c477246ULL, 0x000fe20003800007ULL,
0x0000000618437981ULL, 0x000362000c1e9500ULL, 0x000000ff164b7207ULL, 0x000fe20000800000ULL,
0x0000000215147825ULL, 0x000fe200078e0076ULL, 0x000000ff47477207ULL, 0x000fe20000000000ULL,
0x000000060e457981ULL, 0x000564000c1e9500ULL, 0x000000015e177824ULL, 0x000fe400078e024bULL,
0x0000000108627824ULL, 0x000fe200078e0250ULL, 0x00000006144e7981ULL, 0x000562000c1e9500ULL,
0x0000005e47197211ULL, 0x002fe200078fe0ffULL, 0x0000000217167825ULL, 0x000fc400078e0076ULL,
0x0000005c624f7246ULL, 0x000fe40003800007ULL, 0x0000000150547824ULL, 0x000fe200078e0203ULL,
0x0000000616497981ULL, 0x000362000c1e9500ULL, 0x000000014b0f7824ULL, 0x004fe200078e0260ULL,
0x0000006047157211ULL, 0x000fe200078fe0ffULL, 0x0000000219187825ULL, 0x100fe200078e0076ULL,
0x000000416200720cULL, 0x080fe40003f26070ULL, 0x000000415400720cULL, 0x000fe20003f06070ULL,
0x000000020f0e7825ULL, 0x000fe200078e0076ULL, 0x0000000618527981ULL, 0x000562000c1e9500ULL,
0x00000004ff167819ULL, 0x002fc4000001164fULL, 0x0000005c544f7246ULL, 0x000fe20003800007ULL,
0x0000000215147825ULL, 0x000fe200078e0076ULL, 0x000000060e4b7981ULL, 0x000364000c1e9500ULL,
0x000000ff4f4f7207ULL, 0x000fe40000000000ULL, 0x0000000614567981ULL, 0x000362000c1e9500ULL,
0x000000ff16197207ULL, 0x004fe40000800000ULL, 0x0000005e4f177211ULL, 0x000fc600078fe0ffULL,
0x000000015e557824ULL, 0x000fc800078e0219ULL, 0x00000002550e7825ULL, 0x002fc800078e0076ULL,
0x0000000217147825ULL, 0x000fe400078e0076ULL, 0x000000060e0e7981ULL, 0x0002a2000c1e9500ULL,
0x000000604f177211ULL, 0x000fc600078fe0ffULL, 0x0000000614157981ULL, 0x0002a2000c1e9500ULL,
0x0000000119197824ULL, 0x000fe400078e0260ULL, 0x0000000217167825ULL, 0x000fc800078e0076ULL,
0x0000000219187825ULL, 0x000fe400078e0076ULL, 0x0000000616167981ULL, 0x0002a8000c1e9500ULL,
0x0000000618197981ULL, 0x0008a2000c1e9500ULL, 0xfffffff0515c7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff517424ULL, 0x000fc800078e00ffULL, 0x00000001410f7824ULL, 0x002fc800078e025cULL,
0x000000010a647824ULL, 0x000fe200078e0a0fULL, 0x000000083c627812ULL, 0x040fe400078efcffULL,
0x000000093c607812ULL, 0x000fe400078efcffULL, 0x0000006451647219ULL, 0x000fe200000006ffULL,
0x00000001625c7824ULL, 0x100fe400078e0203ULL, 0x0000000160147824ULL, 0x000fe400078e0203ULL,
0x000000015c667824ULL, 0x000fc400078e0a0fULL, 0x0000000114687824ULL, 0x000fc600078e0a0fULL,
0x0000006651667219ULL, 0x040fe400000006ffULL, 0x0000006851687219ULL, 0x000fe400000006ffULL,
0x000000183c787812ULL, 0x040fe400078efcffULL, 0xfffffff04f4f7812ULL, 0x000fe400078ec0ffULL,
0x000000113c7a7812ULL, 0x040fe400078efcffULL, 0x000000193c747812ULL, 0x000fe200078efcffULL,
0x0000000141617824ULL, 0x000fc400078e024fULL, 0x000000017a177824ULL, 0x100fe400078e0203ULL,
0x00000001747c7824ULL, 0x000fe200078e0203ULL, 0x000000213c6c7812ULL, 0x040fe400078efcffULL,
0x000000283c6a7812ULL, 0x000fc600078efcffULL, 0x000000016c727824ULL, 0x100fe400078e0203ULL,
0x000000016a707824ULL, 0x000fe400078e0203ULL, 0x0000000154637824ULL, 0x000fca00078e0a61ULL,
0x0000006351637219ULL, 0x000fe400000006ffULL, 0x000054105a537816ULL, 0x010fe40000000053ULL,
0x000000013c5a7812ULL, 0x000fe400078efcffULL, 0x0000005364ff7212ULL, 0x000fc6000780c0ffULL,
0x000000015a5e7824ULL, 0x000fe200078e0203ULL, 0x000000410a00720cULL, 0x000fc60000701470ULL,
0x000000015e187824ULL, 0x000fe200078e0a0fULL, 0x000000413c00720cULL, 0x000fc800007a1070ULL,
0x0000001851187219ULL, 0x000fe400000006ffULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x00005410584d7816ULL, 0x008fc8000000004dULL, 0x0000004d64ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004d18ff7212ULL, 0x080fe4000780c0ffULL, 0x0000004d66ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004d68ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff0424d7812ULL, 0x000fe200078ec0ffULL,
0x00000001780f7824ULL, 0x000fe200078e0203ULL, 0x0000005318ff7212ULL, 0x000fc4000782c0ffULL,
0x0000005366ff7212ULL, 0x080fe2000786c0ffULL, 0x00000001414d7824ULL, 0x000fe200078e024dULL,
0x0000005368ff7212ULL, 0x000fe4000788c0ffULL, 0xfffffff047537812ULL, 0x000fe200078ec0ffULL,
0x00000001464f7824ULL, 0x100fe200078e0a4dULL, 0x000000410a00720cULL, 0x080fe20001741470ULL,
0x000000010f557824ULL, 0x000fe200078e0a4dULL, 0x000000415c00720cULL, 0x080fe400037c1470ULL,
0x000000411400720cULL, 0x080fe20002fa1470ULL, 0x0000000141597824ULL, 0x000fe200078e0253ULL,
0x000000413c00720cULL, 0x080fe20001741070ULL, 0x0000000117537824ULL, 0x100fe200078e0a4dULL,
0x000000416200720cULL, 0x080fe200037c1070ULL, 0x000000017c577824ULL, 0x000fe200078e0a4dULL,
0x000000416000720cULL, 0x000fc40002fa1070ULL, 0x0000004f514d7219ULL, 0x040fe400000006ffULL,
0x0000005551557219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x020fe40000000043ULL,
0x000054104e4e7816ULL, 0x000fe40000000045ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fc40003000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x000000484dff7212ULL, 0x040fe4000784c0ffULL, 0x0000004e4dff7212ULL, 0x080fe400078cc0ffULL,
0x0000004e55ff7212ULL, 0x000fe200078ac0ffULL, 0x000000014c5b7824ULL, 0x000fe200078e0a59ULL,
0x000000415e00720cULL, 0x0c0fe40000f21470ULL, 0x000000415e00720cULL, 0x000fc40000701470ULL,
0x000000415c00720cULL, 0x080fe40001f61470ULL, 0x000000411400720cULL, 0x080fe40002781470ULL,
0x000000414600720cULL, 0x0c0fe40001741470ULL, 0x000000414600720cULL, 0x080fe400037c1470ULL,
0x000000410f00720cULL, 0x000fe40002fa1470ULL, 0x000000293c687812ULL, 0x000fc400078efcffULL,
0x000000415a00720cULL, 0x0c0fe40000f21070ULL, 0x000000415a00720cULL, 0x080fe40000701070ULL,
0x000000416200720cULL, 0x080fe40001f61070ULL, 0x000000416000720cULL, 0x080fe40002781070ULL,
0x000000414400720cULL, 0x0c0fe40001741070ULL, 0x000000414400720cULL, 0x000fc400037c1070ULL,
0x000000417800720cULL, 0x000fe40002fa1070ULL, 0x00000053514f7219ULL, 0x040fe400000006ffULL,
0x0000005751577219ULL, 0x040fe400000006ffULL, 0x0000005b515b7219ULL, 0x000fe400000006ffULL,
0x0000541052497816ULL, 0x000fe40000000049ULL, 0x0000541056567816ULL, 0x000fe2000000004bULL,
0x00000001686e7824ULL, 0x000fe200078e0203ULL, 0xff8000003d3d7808ULL, 0x000fc40000800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fc40002800000ULL,
0x000000484fff7212ULL, 0x080fe4000782c0ffULL, 0x0000004855ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004857ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004e4fff7212ULL, 0x080fe4000788c0ffULL,
0x0000004e57ff7212ULL, 0x000fe4000784c0ffULL, 0x000000495bff7212ULL, 0x000fc400078cc0ffULL,
0x000000565bff7212ULL, 0x000fe200078ac0ffULL, 0x00000001725d7824ULL, 0x100fe200078e0a59ULL,
0x000000411700720cULL, 0x0c0fe20000f21470ULL, 0x00000001705f7824ULL, 0x100fe200078e0a59ULL,
0x000000411700720cULL, 0x080fe20002781470ULL, 0x000000016e597824ULL, 0x000fe200078e0a59ULL,
0x000000410f00720cULL, 0x080fe40000701470ULL, 0x000000417c00720cULL, 0x0c0fe40001f61470ULL,
0x000000417c00720cULL, 0x000fc40001741470ULL, 0x000000414c00720cULL, 0x0c0fe400037c1470ULL,
0x000000414c00720cULL, 0x080fe40002fa1470ULL, 0x000000313c647812ULL, 0x040fe400078efcffULL,
0x000000383c587812ULL, 0x040fe400078efcffULL, 0x000000393c187812ULL, 0x000fe400078efcffULL,
0x000000417a00720cULL, 0x000fc40000f21070ULL, 0x000000417a00720cULL, 0x080fe40002781070ULL,
0x000000417800720cULL, 0x080fe40000701070ULL, 0x000000417400720cULL, 0x0c0fe40001f61070ULL,
0x000000417400720cULL, 0x080fe40001741070ULL, 0x000000414a00720cULL, 0x0c0fe400037c1070ULL,
0x000000414a00720cULL, 0x000fc40002fa1070ULL, 0x0000005d515d7219ULL, 0x040fe400000006ffULL,
0x0000005f515f7219ULL, 0x040fe400000006ffULL, 0x0000005951597219ULL, 0x000fe400000006ffULL,
0x00005410150e7816ULL, 0x004fe2000000000eULL, 0x0000000164667824ULL, 0x100fe200078e0203ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x0000000158427824ULL, 0x100fe200078e0203ULL,
0xff80000033337808ULL, 0x000fe20002000000ULL, 0x0000000118477824ULL, 0x000fe200078e0203ULL,
0xff8000002c2c7808ULL, 0x000fc40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x000000495dff7212ULL, 0x080fe4000782c0ffULL,
0x000000495fff7212ULL, 0x000fc4000788c0ffULL, 0x0000004959ff7212ULL, 0x000fe4000780c0ffULL,
0x000000565dff7212ULL, 0x080fe4000786c0ffULL, 0x000000565fff7212ULL, 0x080fe4000784c0ffULL,
0x0000005659ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000e63ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000166657824ULL, 0x100fe200078e0a61ULL, 0x000000417200720cULL, 0x080fe20000f21470ULL,
0x0000000142677824ULL, 0x100fe200078e0a61ULL, 0x000000417200720cULL, 0x080fe20001f61470ULL,
0x0000000147617824ULL, 0x000fe200078e0a61ULL, 0x000000417000720cULL, 0x000fc40002781470ULL,
0x000000417000720cULL, 0x080fe40001741470ULL, 0x000000416e00720cULL, 0x0c0fe40000701470ULL,
0x000000416e00720cULL, 0x080fe400037c1470ULL, 0x000000415400720cULL, 0x080fe40002fa1470ULL,
0x000000416c00720cULL, 0x0c0fe40000f21070ULL, 0x000000416c00720cULL, 0x000fc40001f61070ULL,
0x000000416a00720cULL, 0x0c0fe40002781070ULL, 0x000000416a00720cULL, 0x080fe40001741070ULL,
0x000000416800720cULL, 0x0c0fe40000701070ULL, 0x000000416800720cULL, 0x080fe400037c1070ULL,
0x000000415000720cULL, 0x000fe40002fa1070ULL, 0x0000006551657219ULL, 0x000fc400000006ffULL,
0x0000006751677219ULL, 0x040fe400000006ffULL, 0x0000006151617219ULL, 0x000fe400000006ffULL,
0x0000541016167816ULL, 0x000fe40000000019ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fc40002000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x0000000e65ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000e67ff7212ULL, 0x000fc4000786c0ffULL,
0x0000000e61ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001663ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001665ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001667ff7212ULL, 0x080fe400078cc0ffULL,
0x0000001661ff7212ULL, 0x000fe400078ac0ffULL, 0x000000415400720cULL, 0x000fc40001741470ULL,
0x000000416600720cULL, 0x0c0fe40000f21470ULL, 0x000000416600720cULL, 0x080fe40000701470ULL,
0x000000414200720cULL, 0x0c0fe40001f61470ULL, 0x000000414200720cULL, 0x080fe400037c1470ULL,
0x000000414700720cULL, 0x0c0fe40002781470ULL, 0x000000414700720cULL, 0x000fc40002fa1470ULL,
0x000000415000720cULL, 0x080fe40001741070ULL, 0x000000416400720cULL, 0x0c0fe40000f21070ULL,
0x000000416400720cULL, 0x080fe40000701070ULL, 0x000000415800720cULL, 0x0c0fe40001f61070ULL,
0x000000415800720cULL, 0x080fe400037c1070ULL, 0x000000411800720cULL, 0x000fc40002781070ULL,
0x000000411800720cULL, 0x000fe40002fa1070ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fc40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff8000001b1b7808ULL, 0x000fce0002800000ULL,
0x0000001d1000720bULL, 0x004fe20003f1e000ULL, 0x0c401f0012197f89ULL, 0x000fe200000e0000ULL,
0x000000010b0b7836ULL, 0x000fe40000000000ULL, 0x000000101d107208ULL, 0x000fc80004000000ULL,
0x0000003d1000720bULL, 0x000fc80003f1e000ULL, 0x000000103d0f7208ULL, 0x000fc80004000000ULL,
0x000000340f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f340a7208ULL, 0x000fc80004000000ULL,
0x000000350a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a350f7208ULL, 0x000fc80004000000ULL,
0x000000300f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f300a7208ULL, 0x000fc80004000000ULL,
0x000000310a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a310f7208ULL, 0x000fc80004000000ULL,
0x0000002c0f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f2c0a7208ULL, 0x000fc80004000000ULL,
0x0000002d0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a2d0f7208ULL, 0x000fc80004000000ULL,
0x000000280f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f280a7208ULL, 0x000fc80004000000ULL,
0x000000290a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a290f7208ULL, 0x000fc80004000000ULL,
0x000000240f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f240a7208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f1e000ULL, 0x000000250a00720bULL, 0x000fc80003f3e000ULL,
0x0000000a250f7208ULL, 0x000fe40004800000ULL, 0x000000113e0a7208ULL, 0x000fe40004000000ULL,
0x000000200f00720bULL, 0x000fe40003f3e000ULL, 0x0000003f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000000f200e7208ULL, 0x000fe40004800000ULL, 0x0000000a3f0f7208ULL, 0x000fc40004000000ULL,
0x000000210e00720bULL, 0x000fe40003f3e000ULL, 0x000000360f00720bULL, 0x000fe40003f1e000ULL,
0x0000000e21117208ULL, 0x000fe40004800000ULL, 0x0000000f360a7208ULL, 0x000fe40004000000ULL,
0x0000001e1100720bULL, 0x000fe40003f3e000ULL, 0x000000370a00720bULL, 0x000fc40003f1e000ULL,
0x000000111e0e7208ULL, 0x000fe40004800000ULL, 0x0000000a370f7208ULL, 0x000fe40004000000ULL,
0x0000001f0e00720bULL, 0x000fe40003f3e000ULL, 0x000000320f00720bULL, 0x000fe40003f1e000ULL,
0x0000000e1f0e7208ULL, 0x000fe40004800000ULL, 0x0000000f320a7208ULL, 0x000fc60004000000ULL,
0x0c401f000e117f89ULL, 0x000ea200000e0000ULL, 0x000000330a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a330f7208ULL, 0x000fc80004000000ULL, 0x0000002e0f00720bULL, 0x000fc80003f1e000ULL,
0x0000000f2e0a7208ULL, 0x000fc80004000000ULL, 0x0000002f0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a2f0f7208ULL, 0x000fe40004000000ULL, 0x000000110e00720bULL, 0x004fe40003f3e000ULL,
0x0000002a0f00720bULL, 0x000fe40003f1e000ULL, 0x0000000e11117208ULL, 0x000fe40004800000ULL,
0x0000000f2a0a7208ULL, 0x000fc60004000000ULL, 0x0c201f0011107f89ULL, 0x000ea200000e0000ULL,
0x0000002b0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a2b0f7208ULL, 0x000fc80004000000ULL,
0x000000260f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f260a7208ULL, 0x000fc80004000000ULL,
0x000000270a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a270f7208ULL, 0x000fe40004000000ULL,
0x000000101100720bULL, 0x004fe40003f3e000ULL, 0x000000220f00720bULL, 0x000fe40003f1e000ULL,
0x0000001110107208ULL, 0x000fe40004800000ULL, 0x0000000f220a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b100e7820ULL, 0x000fe20000410000ULL, 0x000000230a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080eULL, 0x0000000a230f7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080eULL, 0x0000001c0f00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080eULL, 0x0000000f1c0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080eULL, 0x0000001b0a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001080eULL, 0x0000000a1b0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b1f0e7823ULL, 0x000fe2000001080eULL, 0x0000001d00147308ULL, 0x000fe20000000800ULL,
0x0c401f000a0f7f89ULL, 0x000eae00000e0000ULL, 0x0000001e003c7308ULL, 0x000ff00000000800ULL,
0x0000003d003d7308ULL, 0x000ef00000000800ULL, 0x0000003400167308ULL, 0x000fe20000000800ULL,
0x0000000f0a00720bULL, 0x004fc80003f1e000ULL, 0x0000000a0f0a7208ULL, 0x000fe20004000000ULL,
0x3c003c00ff0f7424ULL, 0x000fe200078e00ffULL, 0x000000143d14723eULL, 0x008fe200000000ffULL,
0x0000003500357308ULL, 0x000ea40000000800ULL, 0x0c201f000a117f89ULL, 0x000eec00000e0000ULL,
0x0000000e00437308ULL, 0x0009e20000000800ULL, 0x000000163516723eULL, 0x004fce00000000ffULL,
0x0000002800187308ULL, 0x000fe20000000800ULL, 0x3c003c00ff0e7424ULL, 0x010fce00078e00ffULL,
0x00000029001d7308ULL, 0x000fe20000000800ULL, 0x000000110a00720bULL, 0x008fc80003f1e000ULL,
0x0000000a11117208ULL, 0x000fc60004000000ULL, 0x0000002500417308ULL, 0x000fe20000000800ULL,
0x000000191200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b111f7820ULL, 0x000fc60000410000ULL,
0x0000001219127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b37377823ULL, 0x100fe2000001081fULL, 0x0000003e00157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b26357823ULL, 0x100fe2000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081fULL, 0x0000003f000a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe2000001081fULL, 0xfffffff8ff197812ULL, 0x000fcc00078ee240ULL,
0x0000003600177308ULL, 0x0007e20000000800ULL, 0x000000150a15723eULL, 0x004fce00000000ffULL,
0x00000037001e7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b2a0a7823ULL, 0x100fe2000001081fULL,
0x3fb8aa3b27367823ULL, 0x008fcc000001081fULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000171e17723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b2b1e7823ULL, 0x000fcc000001081fULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x0000000e1428723cULL, 0x000fee00000018ffULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000eb00000000800ULL,
0x0000003200257308ULL, 0x000fe20000000800ULL, 0x0000002c2d26723eULL, 0x004fce00000000ffULL,
0x0000003300427308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b1c2d7823ULL, 0x000fe2000001081fULL,
0x000000181d1c723eULL, 0x000fcc00000000ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000254225723eULL, 0x004fce00000000ffULL, 0x0000002f002f7308ULL, 0x000eb00000000800ULL,
0x0000002400347308ULL, 0x0007220000000800ULL, 0x0000002e2f27723eULL, 0x004fce00000000ffULL,
0x0000000a00327308ULL, 0x0005e20000000800ULL, 0x000000303124723eULL, 0x008fce00000000ffULL,
0x0000000e2428723cULL, 0x000fe20000001828ULL, 0x0c401f00130a7f89ULL, 0x004ea200000e0000ULL,
0x0000001e00337308ULL, 0x0008f00000000800ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x00000034411e723eULL, 0x010fca00000000ffULL, 0x000000ffff317224ULL, 0x000fe200078e001eULL,
0x00000032331d723eULL, 0x008fe200000000ffULL, 0x0000003600367308ULL, 0x000ee20000000800ULL,
0x0000000819327824ULL, 0x000fe200078e00ffULL, 0x0000000a1300720bULL, 0x004fcc0003f3e000ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000130a137208ULL, 0x000fe40004800000ULL,
0x00000003ff0a7819ULL, 0x000fe40000011605ULL, 0x00000035361f723eULL, 0x008fc600000000ffULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x000000030a0a7812ULL, 0x000fc600078ec0ffULL,
0x0000000e1c28723cULL, 0x000fe80000001828ULL, 0x00000022002c7308ULL, 0x0007e20000000800ULL,
0x000000202120723eULL, 0x004fce00000000ffULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x0000003c4322723eULL, 0x008fca00000000ffULL, 0x000000ffff337224ULL, 0x000fe400078e0022ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x0000002c2321723eULL, 0x004fce00000000ffULL,
0x0000001b00187308ULL, 0x0004e20000000800ULL, 0x00000008392c7c11ULL, 0x000fe2000f8e58ffULL,
0x000000ffff1e7224ULL, 0x000fe400078e0021ULL, 0x00000008191b7836ULL, 0x004fc80000000000ULL,
0x000000010a2e7824ULL, 0x000fe200078e021bULL, 0x0000002d1823723eULL, 0x008fe200000000ffULL,
0x00000008192d7824ULL, 0x000fe400078e00ffULL, 0x000000010a187824ULL, 0x000fe400078e0219ULL,
0x0c201f0012197f89ULL, 0x000ea200000e0000ULL, 0x000000081b2f7824ULL, 0x040fe200078e00ffULL,
0x0000000e2028723cULL, 0x000fe20000001828ULL, 0x000000081b357824ULL, 0x000fe200078e00ffULL,
0x0c201f00130a7f89ULL, 0x000ee200000e0000ULL, 0xfffffff82d1b7812ULL, 0x000fe200078ee218ULL,
0x00000004182d7836ULL, 0x000fe20000000000ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee22eULL,
0x0000000c18307836ULL, 0x000fc40000000000ULL, 0x000110002c187836ULL, 0x000fe20000000000ULL,
0xfffffff8322d7812ULL, 0x000fe200078ee22dULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0xfffffff835357812ULL, 0x000fe200078ee230ULL, 0x000000102f0f7824ULL, 0x100fe400078e0218ULL,
0x000000102d0e7824ULL, 0x100fe400078e0218ULL, 0x000000101b1b7824ULL, 0x000fe400078e0218ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0016ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0024ULL,
0x000000191200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0026ULL,
0x000000ffff307224ULL, 0x000fe200078e001cULL, 0x0000001219127208ULL, 0x000fe20004000000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff327224ULL, 0x000fe200078e0020ULL, 0x0000000a1300720bULL, 0x008fe20003f3e000ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0x0000002c1b007844ULL, 0x000fe20000000200ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001dULL, 0x000000130a137208ULL, 0x000fe20004800000ULL,
0x000000ffff167224ULL, 0x000fe200078e0025ULL, 0x000000300e007844ULL, 0x000fe20000000200ULL,
0x000000ffff177224ULL, 0x000fc400078e0027ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001fULL,
0x0000001035357824ULL, 0x000fe200078e0218ULL, 0x000000140f007844ULL, 0x0005e20000000200ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0023ULL, 0x000000ffff297224ULL, 0x000fe400078e002aULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000001c35007844ULL, 0x0007e80000000200ULL,
0x017000101a008388ULL, 0x0007e80000000c00ULL, 0x017200281a008388ULL, 0x0007e20000000a00ULL,
0x0000000c0b00720cULL, 0x000fe20003f06070ULL, 0x0176080a09ff79a7ULL, 0x0007e2000850003fULL,
0x000000ffff147224ULL, 0x004fe200078e000dULL, 0x0176100a09ff79a7ULL, 0x0007e2000850003fULL,
0x0176180a09ff79a7ULL, 0x0007e2000850003fULL, 0x0176200a09ff79a7ULL, 0x0007f0000850003fULL,
0xffffffac00bc8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000051007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005100008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff51ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000051027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffed402287950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006f8ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000950ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a84ULL,
0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f8ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f8ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001140ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012c00ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013d80ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013dd0ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000143c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001140ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012c00ULL, 0x0000000000012c00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013dd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_90_cubin_len = 83216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
