/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016950ULL, 0x00000000000165d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000014990ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000014b10ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000014b50ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000014ba0ULL, 0x0000000000000160ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000014d00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001499000000000ULL,
0x0000040400000000ULL, 0x810c000000100400ULL, 0x0052480408288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080820828ULL, 0x2880809508288080ULL,
0x80a808288080a508ULL, 0x08288080a9082880ULL, 0x8080b008288080abULL, 0xb508288080b40828ULL,
0x288080de08288080ULL, 0x8280162880808408ULL, 0x0000000003102880ULL, 0x8080849200000000ULL,
0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001499000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8e08288080820828ULL,
0x2880809208288080ULL, 0x80a5082880809508ULL, 0x08288080a8082880ULL, 0x8080ab08288080a9ULL,
0xb008288080ae0828ULL, 0x288080b408288080ULL, 0x80de08288080b508ULL, 0x162880808c082880ULL,
0x0000031028808280ULL, 0x8c92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000013800000000ULL, 0x00014b1000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080820828ULL, 0x2880809508288080ULL,
0x80a808288080a508ULL, 0x08288080a9082880ULL, 0x8080ae08288080abULL, 0xb408288080b00828ULL,
0x288080de08288080ULL, 0x828016288080b508ULL, 0x0000000003102880ULL, 0x8080b59200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL, 0x00014b5000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80b4288080b50900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080820828ULL, 0x2880809508288080ULL,
0x80a808288080a508ULL, 0x08288080a9082880ULL, 0x8080ae08288080abULL, 0xb508288080b00828ULL,
0x288080de08288080ULL, 0x828016288080b408ULL, 0x0000000003102880ULL, 0x8080b49200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL, 0x00014ba000000000ULL,
0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000018ULL, 0x000c170400601903ULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x00000ba000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000030001342804ULL, 0x000005b000000430ULL, 0x0000270000002670ULL, 0x0000298000002820ULL,
0x00002e2000002df0ULL, 0x00002f0000002e90ULL, 0x00004df000004d60ULL, 0x0000507000004f10ULL,
0x00005520000054f0ULL, 0x0000560000005590ULL, 0x000074a000007410ULL, 0x00007730000075d0ULL,
0x00007be000007bb0ULL, 0x00007cc000007c50ULL, 0x00009ac000009a20ULL, 0x00009d4000009be0ULL,
0x0000a2300000a200ULL, 0x0000a3100000a2a0ULL, 0x0000b5300000b520ULL, 0x00012f4000012f00ULL,
0x00012f6000012f50ULL, 0x00012fd000012f70ULL, 0x0001301000012ff0ULL, 0x00013cb000013c60ULL,
0x00013d8000013d20ULL, 0x00013e6000013df0ULL, 0x00013f1000013ec0ULL, 0x00013fe000013f80ULL,
0x000140c000014050ULL, 0x0001417000014120ULL, 0x00014240000141e0ULL, 0x00014320000142b0ULL,
0x000143d000014380ULL, 0x000144a000014440ULL, 0x0001458000014510ULL, 0x00014670000145f0ULL,
0x00014770000146f0ULL, 0x00014870000147f0ULL, 0x00014970000148f0ULL, 0x000003f004403904ULL,
0x00017600000000ffULL, 0x00000460003f0100ULL, 0x0001760800000015ULL, 0x000004f0003f0120ULL,
0x0001768800000015ULL, 0x00000520003f0120ULL, 0x000176a800000015ULL, 0x00000540003f0120ULL,
0x000176c800000015ULL, 0x00000c10003f0120ULL, 0x00017600000000ffULL, 0x00000d10003f0107ULL,
0x0001768c0000000dULL, 0x00000da0003f0102ULL, 0x000176880000000dULL, 0x000015d0003f0101ULL,
0x00000000000000ffULL, 0x0000165000040107ULL, 0x00000000000000ffULL, 0x000016b000040101ULL,
0x0000002000000006ULL, 0x000017f0003f0101ULL, 0x000176cc00000004ULL, 0x000019e0003f0105ULL,
0x000176cc00000004ULL, 0x00002240003f0105ULL, 0x000176b00000000eULL, 0x000022e0003f0107ULL,
0x000176b00000000eULL, 0x00002340003f0101ULL, 0x0001760800000024ULL, 0x00002380003f0101ULL,
0x0001760c00000009ULL, 0x00002560003f0105ULL, 0x0001760c00000009ULL, 0x00002b50003f0105ULL,
0x000176ac00000024ULL, 0x00002d20003f0105ULL, 0x000176ac00000024ULL, 0x00003fd0003f0105ULL,
0x0000000000000036ULL, 0x00004030003f0101ULL, 0x0001768800000010ULL, 0x00004060003f0101ULL,
0x000000040000000bULL, 0x00004220003f0105ULL, 0x000000040000000bULL, 0x00004970003f0105ULL,
0x00000000000000ffULL, 0x00004a4000040107ULL, 0x00000000000000ffULL, 0x00004aa000040101ULL,
0x0001762800000010ULL, 0x00004ac0003f0101ULL, 0x0001762c00000009ULL, 0x00004c90003f0105ULL,
0x0001762c00000009ULL, 0x00005250003f0105ULL, 0x000176b400000039ULL, 0x00005420003f0105ULL,
0x000176b400000039ULL, 0x00006670003f0105ULL, 0x0000000000000020ULL, 0x000066d0003f0101ULL,
0x0001769000000067ULL, 0x00006700003f0101ULL, 0x000000040000000bULL, 0x000068c0003f0105ULL,
0x000000040000000bULL, 0x00007020003f0105ULL, 0x00000008000000ffULL, 0x000070b000040107ULL,
0x000176b000000020ULL, 0x00007110003f0101ULL, 0x0001764800000009ULL, 0x00007170003f0101ULL,
0x0001764c00000009ULL, 0x00007340003f0105ULL, 0x0001764c00000009ULL, 0x00007910003f0105ULL,
0x000176ac00000037ULL, 0x00007ae0003f0105ULL, 0x000176ac00000037ULL, 0x00008c50003f0105ULL,
0x000000000000000bULL, 0x00008cb0003f0101ULL, 0x0000000000000005ULL, 0x00008ce0003f0101ULL,
0x000000040000000bULL, 0x00008ea0003f0105ULL, 0x000000040000000bULL, 0x00009640003f0105ULL,
0x00000000000000ffULL, 0x0000971000040107ULL, 0x00000000000000ffULL, 0x0000977000040101ULL,
0x000176680000000aULL, 0x000097a0003f0101ULL, 0x0001766c0000000aULL, 0x00009970003f0105ULL,
0x0001766c0000000aULL, 0x00009f20003f0105ULL, 0x000176b400000013ULL, 0x0000a120003f0105ULL,
0x000176b400000013ULL, 0x0000b2f0003f0105ULL, 0x000000000000000bULL, 0x0000b370003f0101ULL,
0x0000000000000004ULL, 0x0000c6c0003f0101ULL, 0x00017600000000ffULL, 0x0000df00003f0101ULL,
0x00017604000000ffULL, 0x0000e110003f0105ULL, 0x00017604000000ffULL, 0x0000e340003f0105ULL,
0x00017600000000ffULL, 0x0000e370003f0101ULL, 0x00017604000000ffULL, 0x0000e530003f0105ULL,
0x00017604000000ffULL, 0x000112f0003f0105ULL, 0x0000000000000073ULL, 0x00011380003f0101ULL,
0x0000000400000073ULL, 0x00011550003f0105ULL, 0x0000000400000073ULL, 0x00013aa0003f0105ULL,
0x0000000000000076ULL, 0x00013b00003f0101ULL, 0x0000000800000076ULL, 0x00013b60003f0101ULL,
0x0000001000000076ULL, 0x00013bd0003f0101ULL, 0x0000001800000076ULL, 0x00053803003f0101ULL,
0x0000bd9000201c04ULL, 0x0000c0700000bdd0ULL, 0x0000c4600000c260ULL, 0x0000e5900000c610ULL,
0x0000040100013c20ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000034cULL, 0x0000001b00000002ULL,
0x000000000000028cULL, 0x0000001b00000002ULL, 0x00000000000001dcULL, 0x0000001b00000002ULL,
0x000000000000010cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x0000000000000324ULL, 0x0000001b00000002ULL, 0x0000000000000264ULL, 0x0000001b00000002ULL,
0x00000000000001b6ULL, 0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017810ULL, 0x000fe40007ffe0ffULL, 0x00005d00ff007a0cULL, 0x000fda0003f05300ULL,
0x00000004ff040424ULL, 0x000fe200078e00ffULL, 0x0000000109020810ULL, 0x002fca0007ffe0ffULL,
0x00005c0002020625ULL, 0x000fc800078e0004ULL, 0x00005c0009040625ULL, 0x000fe200078e0004ULL,
0x0000000602000981ULL, 0x0002a8000c1e1900ULL, 0x0000000604070981ULL, 0x0006a2000c1e1900ULL,
0x0000590000067b06ULL, 0x000f220000209000ULL, 0x00005900ff007a0cULL, 0x000fe40003f65070ULL,
0x0000000000087919ULL, 0x000e680000002600ULL, 0x0000000000137919ULL, 0x000e620000002300ULL,
0x00005900ff047624ULL, 0x008fe200078e00ffULL, 0x0000000600067308ULL, 0x010ee40000001000ULL,
0x0ffffffe060a7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000a000b7305ULL, 0x000724000021f000ULL,
0x000000ffff0a7224ULL, 0x008fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x010fc800078e0a0bULL,
0x000059000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d0b0b7227ULL, 0x000fe400078e000aULL,
0x00000000000a7919ULL, 0x000ee80000002200ULL, 0x000004000b0d7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x002fc800078e0a0dULL, 0x0000040003027624ULL, 0x000fca00078e0204ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0dba12ULL, 0x000fc800078e33ffULL,
0x0000000d00057306ULL, 0x000e620000209000ULL, 0x000000ff0d00720cULL, 0x000fce0003f85070ULL,
0x0000000500057308ULL, 0x002e640000001000ULL, 0x0ffffffe05027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000030d067224ULL, 0x010fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000000000067919ULL, 0x000e640000002100ULL, 0x0000000b03037227ULL, 0x000fcc00078e0002ULL,
0x00000008037d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a7dULL,
0x000000030d027224ULL, 0x000fe400078e0208ULL, 0x0000010013037a24ULL, 0x008fe400078e020aULL,
0x00001fff13137589ULL, 0x000fe200000e0000ULL, 0x0000000d0200720cULL, 0x000fe20003fa6070ULL,
0x0000000003157a24ULL, 0x102fe200078e0206ULL, 0x00000005ff057819ULL, 0x000fc80000011606ULL,
0x000000ff1500720cULL, 0x040fe40003f65270ULL, 0x0000000f1500780cULL, 0x040fe40003f24070ULL,
0x0000007f1500780cULL, 0x000fc60003f44070ULL, 0x0000000102025824ULL, 0x000fe200078e0a0dULL,
0x000000017d7d5810ULL, 0x000fe40007ffe0ffULL, 0x000000031500780cULL, 0x000fe40003fa4070ULL,
0x0000000d0200720cULL, 0x000fe20003fc6070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0a9424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff0b9424ULL, 0x000fe200078e00ffULL, 0x01760002ff00b388ULL, 0x000fe20000000a00ULL,
0x000000011500780cULL, 0x000fe20003f64070ULL, 0xff317217ff12a424ULL, 0x000fc600078e00ffULL,
0x000000017d7d6810ULL, 0x000fe20007ffe0ffULL, 0x00001fff05027589ULL, 0x000e6200000e0000ULL,
0x0000000dff7dc212ULL, 0x000fe200078e33ffULL, 0x3fffff60ff0cd424ULL, 0x000fe400078e00ffULL,
0x0176080a15009388ULL, 0x000fe20000008a00ULL, 0x3fffff80ff0ed424ULL, 0x000fe400078e00ffULL,
0x000000ffff7b7224ULL, 0x000fe200078e0a7dULL, 0x017400121500a388ULL, 0x0007e20000004800ULL,
0x7fffff80ff0fd424ULL, 0x000fc400078e00ffULL, 0x0000007b0d7b7224ULL, 0x000fe400078e0208ULL,
0x7fffff60ff0dd424ULL, 0x000fe400078e00ffULL, 0x000000107b7b7824ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff10b424ULL, 0x000fe200078e00ffULL, 0x0176880c1500d388ULL, 0x000fe20000008a00ULL,
0x00005a00ff127624ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff11b424ULL, 0x000fe200078e00ffULL,
0x0176a80e1500d388ULL, 0x000fe20000008a00ULL, 0x0000590012127a24ULL, 0x000fc600078e02ffULL,
0x0176c8101500b388ULL, 0x000fe20000008a00ULL, 0x0000000100000824ULL, 0x004fe400078e0a07ULL,
0x00005800ff008624ULL, 0x000fe400078e00ffULL, 0x0000580009078a24ULL, 0x000fe400078e02ffULL,
0x00005a0000067a24ULL, 0x000fe400078e02ffULL, 0x0000001207147224ULL, 0x000fe400078e02ffULL,
0x0000000106037824ULL, 0x040fe200078e0a7bULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000007b0600720cULL, 0x000fc40003f26070ULL, 0x0000001003037817ULL, 0x000fc80003800000ULL,
0x000000ff03167207ULL, 0x000fe20000800000ULL, 0x0000000413037824ULL, 0x002fc600078e0202ULL,
0x000000101600780cULL, 0x000fe20003f05270ULL, 0x0000001601007387ULL, 0x000fe20000100800ULL,
0x0000000203087824ULL, 0x000fc600078e00ffULL, 0x0000041401007387ULL, 0x0003e40000100800ULL,
0x00005a007d147a24ULL, 0x002fcc00078e0214ULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a0000057b06ULL, 0x000e620000209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL, 0x0000000500057308ULL, 0x002e620000001000ULL,
0x00000004ff0c7819ULL, 0x004fca0000011603ULL, 0x00000001080e7824ULL, 0x000fe200078e020cULL,
0x0ffffffe050a7810ULL, 0x002fc60007ffe0ffULL, 0x000000017b057824ULL, 0x000fe200078e020eULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x000000ffff0a7224ULL, 0x002fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fc800078e0a0bULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d0b067227ULL, 0x000fcc00078e000aULL, 0x0000000506067227ULL, 0x000fc800078e00ffULL,
0x000000ffff107224ULL, 0x000fc800078e0a06ULL, 0x00005a00100a7a24ULL, 0x000fca00078e0205ULL,
0x00005a000a007a0cULL, 0x000fda0003f06070ULL, 0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fda0003f26070ULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff0a7224ULL, 0x000fc800078e0a06ULL, 0x00005a000a057a24ULL, 0x000fc800078e0205ULL,
0x00000001140b7824ULL, 0x000fe200078e0205ULL, 0x0000000816057217ULL, 0x000fc60007800000ULL,
0x00000012060b7224ULL, 0x000fe400078e020bULL, 0x0000001003067824ULL, 0x000fe400078e00ffULL,
0x0000000105057824ULL, 0x000fe400078e0a08ULL, 0x000001000b0a7825ULL, 0x000fe200078e00ffULL,
0x000000f0060d7812ULL, 0x000fe400078ec0ffULL, 0x000000050c00720cULL, 0x000fe20003f06070ULL,
0x000000010e057824ULL, 0x000fe200078e0203ULL, 0x0000000d0a0d7212ULL, 0x000fe200078efcffULL,
0x000000100e0e7824ULL, 0x000fc600078e00ffULL, 0x000060000d0a7a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00e057812ULL, 0x000fe400078ee205ULL, 0x000061000b0b7a10ULL, 0x000fc60000ffe4ffULL,
0x0000001005057824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x0000000803087211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe060b7810ULL, 0x002fcc0007ffe0ffULL, 0x0000000b000b7305ULL, 0x000e64000021f000ULL,
0x000000ffff057224ULL, 0x002fc800078e0a0bULL, 0x00005a0005057a24ULL, 0x000fc800078e02ffULL,
0x000000050b0a7227ULL, 0x000fc800078e000aULL, 0x000000017b057824ULL, 0x000fc800078e0208ULL,
0x000000050a067227ULL, 0x000fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a06ULL,
0x00005a000a0a7a24ULL, 0x000fca00078e0205ULL, 0x00005a000a007a0cULL, 0x000fda0003f06070ULL,
0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106060810ULL, 0x000fe40007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fda0003f26070ULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a06ULL,
0x00005a000a057a24ULL, 0x000fc800078e0205ULL, 0x0000000114057824ULL, 0x000fc800078e0205ULL,
0x0000001206057224ULL, 0x000fe400078e0205ULL, 0x0000001003067824ULL, 0x000fe400078e00ffULL,
0x00000100050a7825ULL, 0x000fc600078e00ffULL, 0x000000f0060d7812ULL, 0x000fe200078ec0ffULL,
0x0000000108057824ULL, 0x040fe400078e0203ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000000d0a0a7212ULL, 0x000fc800078efcffULL, 0xfffffff008057812ULL, 0x000fe400078ee205ULL,
0x000060000a0a7a10ULL, 0x000fc60007f1e0ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x000061000b0b7a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e8000b901c46ULL, 0x00000000000b7919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fe200038e0000ULL, 0x00000004ff427424ULL, 0x000fc600078e00ffULL,
0x0000000500087300ULL, 0x000e6200000e0000ULL, 0x0000660009687625ULL, 0x000fce00078e0042ULL,
0x00000005000a7309ULL, 0x000ea20000000000ULL, 0x0000000b0800720cULL, 0x002fe20003f02070ULL,
0x000000ffff087224ULL, 0x004fe400078e0a0aULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x01760408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000668687981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1300720cULL, 0x000fc40003f05270ULL, 0x000000ff680a7810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff757819ULL, 0x000fce000001160aULL, 0x0000b94000008947ULL, 0x000fea0003800000ULL,
0x00000008020d7824ULL, 0x000fe400078e00ffULL, 0x00000003ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01768c000dff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000000209097824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011602ULL,
0x017688000dff7f8cULL, 0x0007e2000c80043fULL, 0x0000000102747812ULL, 0x000fe200078ec0ffULL,
0x0000590009767624ULL, 0x000fe400078e0204ULL, 0x000000206e087824ULL, 0x002fc400078e00ffULL,
0x000000017d767824ULL, 0x000fc800078e0276ULL, 0x0000680076007a24ULL, 0x004fe200078e0208ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000000868047217ULL, 0x008fe20007800000ULL,
0x0000001074057824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fc60000011603ULL,
0x0000000104047824ULL, 0x000fe200078e0a08ULL, 0x00000004070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fc600078e0207ULL, 0x0000000504047217ULL, 0x000fe20007800000ULL,
0x0000000108097824ULL, 0x040fe400078e0203ULL, 0x00000008080c7824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe400078e0a05ULL, 0x0000000100087824ULL, 0x000fe200078e0208ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee209ULL, 0x0000000807097810ULL, 0x000fc40007ffe0ffULL,
0x000000040700720cULL, 0x0c0fe40003f66070ULL, 0x0000000c07077810ULL, 0x000fe40007ffe0ffULL,
0x000000040a00720cULL, 0x080fe20003f46070ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x000000040900720cULL, 0x080fe20003f26070ULL, 0x0000000105097824ULL, 0x000fe200078e0209ULL,
0x000000040700720cULL, 0x000fe20003f06070ULL, 0x00000001050e7824ULL, 0x000fe400078e0207ULL,
0x0000008008047825ULL, 0x000fc800078e00ffULL, 0x0000000100087824ULL, 0x000fe200078e020aULL,
0x00000070040f7812ULL, 0x000fe200078ef806ULL, 0x000000010a077824ULL, 0x040fe400078e0203ULL,
0x000000080a107824ULL, 0x000fe400078e00ffULL, 0x00000001000a7824ULL, 0x000fe400078e0209ULL,
0x00000001090b7824ULL, 0x040fe400078e0203ULL, 0x0000000809127824ULL, 0x000fc400078e00ffULL,
0x0000000100117824ULL, 0x000fe200078e020eULL, 0xfffffff810007812ULL, 0x000fe200078ee207ULL,
0x000000010e047824ULL, 0x000fe200078e0203ULL, 0xfffffff812107812ULL, 0x000fe200078ee20bULL,
0x000000080e097824ULL, 0x000fe200078e00ffULL, 0x000064000f0e7a10ULL, 0x000fe40007f9e0ffULL,
0x000130006e077811ULL, 0x000fe400078e68ffULL, 0xfffffff809127812ULL, 0x000fe400078ee204ULL,
0x00006500050f7a10ULL, 0x000fe200027fe4ffULL, 0x0000008008047825ULL, 0x000fc800078e00ffULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef806ULL,
0x00000080110a7825ULL, 0x000fe200078e00ffULL, 0x0000640004047a10ULL, 0x000fc60007f9e0ffULL,
0x0000001000137824ULL, 0x100fe200078e0207ULL, 0x0000007008007812ULL, 0x100fe200078ef806ULL,
0x000000100c117824ULL, 0x100fe200078e0207ULL, 0x000000700a087812ULL, 0x000fe200078ef806ULL,
0x0000001010157824ULL, 0x100fe200078e0207ULL, 0x0000640000067a10ULL, 0x000fe20007fbe0ffULL,
0x0000001012177824ULL, 0x000fe200078e0207ULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000d901c46ULL,
0x0000650005057a10ULL, 0x000fe400027fe4ffULL, 0x0000650009077a10ULL, 0x000fc40002ffe4ffULL,
0x000065000b097a10ULL, 0x000fe200037fe4ffULL, 0x0000000004137faeULL, 0x0003e8000d101c46ULL,
0x0000000006157faeULL, 0x0003e8000c901c46ULL, 0x0000000008177faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001074047824ULL, 0x008fe200078e00ffULL,
0x000130006e177811ULL, 0x000fc800078e68ffULL, 0x0000000403047211ULL, 0x000fc800078fe8ffULL,
0x0000000404087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100057824ULL, 0x000fe200078e0204ULL,
0x00000008040b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104077824ULL, 0x040fe200078e0203ULL,
0x0000000c040e7810ULL, 0x040fe20007ffe0ffULL, 0x00000008040a7824ULL, 0x000fe400078e00ffULL,
0x0000008005047825ULL, 0x000fc600078e00ffULL, 0xfffffff80a077812ULL, 0x000fe200078ee207ULL,
0x0000000100097824ULL, 0x000fe200078e0208ULL, 0x00000070040f7812ULL, 0x000fe200078ef806ULL,
0x00000001080a7824ULL, 0x140fe400078e0203ULL, 0x0000000808117824ULL, 0x000fe400078e00ffULL,
0x0000000100107824ULL, 0x000fe400078e020eULL, 0x000000010e047824ULL, 0x040fe400078e0203ULL,
0x000000080e137824ULL, 0x000fe200078e00ffULL, 0x000064000f0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000100087824ULL, 0x000fe200078e020bULL, 0xfffffff811007812ULL, 0x000fe200078ee20aULL,
0x000000010b0c7824ULL, 0x000fe200078e0203ULL, 0xfffffff813127812ULL, 0x000fe200078ee204ULL,
0x000000080b0b7824ULL, 0x000fe200078e00ffULL, 0x00006500050f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008009047825ULL, 0x000fc600078e00ffULL, 0xfffffff80b0c7812ULL, 0x000fe200078ee20cULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef806ULL,
0x00000080100a7825ULL, 0x000fe200078e00ffULL, 0x0000640004047a10ULL, 0x000fc60007f1e0ffULL,
0x0000001007117824ULL, 0x100fe200078e0217ULL, 0x0000007008077812ULL, 0x100fe200078ef806ULL,
0x0000001000137824ULL, 0x100fe200078e0217ULL, 0x000000700a087812ULL, 0x000fe200078ef806ULL,
0x000000100c157824ULL, 0x100fe200078e0217ULL, 0x0000640007067a10ULL, 0x000fe20007f3e0ffULL,
0x0000001012177824ULL, 0x000fe200078e0217ULL, 0x0000640008087a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000b901c46ULL,
0x0000650005057a10ULL, 0x000fe400007fe4ffULL, 0x0000650009077a10ULL, 0x000fc40000ffe4ffULL,
0x000065000b097a10ULL, 0x000fe200017fe4ffULL, 0x0000000004137faeULL, 0x0003e8000b901c46ULL,
0x0000000006157faeULL, 0x0003e8000b901c46ULL, 0x0000000008177faeULL, 0x0003e4000b901c46ULL,
0x000000006e0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff7500720cULL, 0x000fe20003f05270ULL,
0x000000ffff117224ULL, 0x002fe200078e00ffULL, 0x000176a86e067811ULL, 0x000fe200078e18ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000176a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff047f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00009c5000008947ULL, 0x000fea0003800000ULL,
0x000000ffff007224ULL, 0x004fe200078e0007ULL, 0x00000002ff7a7819ULL, 0x000fe20000011602ULL,
0xff317217ff127424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x024fca00078e00ffULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x0000000402047824ULL, 0x002fca00078e00ffULL,
0xfffffff804047812ULL, 0x000fca00078ec0ffULL, 0x0176cc0004097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804800ULL, 0x000176c804097810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0009ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a0e137210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e0fULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000130a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc00040b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0009ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010c007810ULL, 0x000fe20007ffe0ffULL,
0x000000206e047824ULL, 0x000fc600078e00ffULL, 0x000000750000720cULL, 0x000fe20003f26070ULL,
0x000001000c0a7824ULL, 0x000fca00078e0204ULL, 0x000000400a097810ULL, 0x000fca0007ffe0ffULL,
0x0000680076247a24ULL, 0x000fe400078e0209ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000000968007217ULL, 0x000fe20007800000ULL, 0x00000010740f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc60000011603ULL, 0x0000000100007824ULL, 0x000fe200078e0a09ULL,
0x0000000404107810ULL, 0x040fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x040fe200078e0204ULL,
0x0000000c04167810ULL, 0x000fe40007ffe0ffULL, 0x000000000f007217ULL, 0x000fe20007800000ULL,
0x000000010e097824ULL, 0x040fe400078e0203ULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc400078e0a0fULL, 0x000000010e0e7824ULL, 0x000fe200078e0224ULL,
0xfffffff814137812ULL, 0x000fe200078ee209ULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x0000000804147810ULL, 0x000fe20007ffe0ffULL, 0x000000010f177824ULL, 0x040fe200078e0216ULL,
0x000000001000720cULL, 0x080fe20003f66070ULL, 0x000000010f107824ULL, 0x040fe200078e0210ULL,
0x000000001400720cULL, 0x080fe20003f46070ULL, 0x000000010f157824ULL, 0x000fe200078e0214ULL,
0x000000000400720cULL, 0x080fe20003f86070ULL, 0x0000000110147824ULL, 0x000fe200078e0224ULL,
0x000000001600720cULL, 0x000fe20003f06070ULL, 0x0000000110047824ULL, 0x040fe200078e0203ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000000810277824ULL, 0x000fc400078e00ffULL,
0x0000000115167824ULL, 0x000fe400078e0224ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fc600078ee204ULL, 0x0000000115007824ULL, 0x140fe200078e0203ULL,
0x000000090e0e7212ULL, 0x080fe200078efcffULL, 0x0000000815357824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe40007fbe0ffULL,
0xfffffff835357812ULL, 0x000fe200078ee200ULL, 0x0000000117247824ULL, 0x040fe200078e0224ULL,
0x0000000914147212ULL, 0x000fe200078efcffULL, 0x0000000117047824ULL, 0x040fe200078e0203ULL,
0x000140006e007811ULL, 0x000fe200078e68ffULL, 0x0000000817377824ULL, 0x000fe200078e00ffULL,
0x0000640014147a10ULL, 0x000fe20007fde0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000065000f0f7a10ULL, 0x000fc40002ffe4ffULL, 0xfffffff837377812ULL, 0x000fe200078ee204ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000916167212ULL, 0x080fe400078efcffULL,
0x0000650015157a10ULL, 0x000fe400037fe4ffULL, 0x0000000924247212ULL, 0x000fe200078efcffULL,
0x0000001013097824ULL, 0x100fe200078e0200ULL, 0x0000640016167a10ULL, 0x000fe20007fbe0ffULL,
0x0000001027137824ULL, 0x100fe200078e0200ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000001035277824ULL, 0x100fe200078e0200ULL, 0x0000650017177a10ULL, 0x000fe20002ffe4ffULL,
0x0000001037357824ULL, 0x000fe200078e0200ULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0003e8000e101c46ULL,
0x0000000014137faeULL, 0x0003e8000d901c46ULL, 0x0000000016277faeULL, 0x0003e8000d101c46ULL,
0x0000000024357faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001074007824ULL, 0x000fe400078e00ffULL, 0x0000001003047824ULL, 0x000fc600078e00ffULL,
0x0000000003007211ULL, 0x000fe400078fe8ffULL, 0x0000007004277812ULL, 0x000fe400078ec0ffULL,
0x0000000400047810ULL, 0x040fe20007ffe0ffULL, 0x0000000100097824ULL, 0x040fe200078e0203ULL,
0x0000000c00137810ULL, 0x040fe20007ffe0ffULL, 0x0000000800107824ULL, 0x040fe400078e00ffULL,
0x00000001000e7824ULL, 0x000fe400078e0224ULL, 0x0000000804157824ULL, 0x000fe200078e00ffULL,
0xfffffff810097812ULL, 0x000fe200078ee209ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000800107810ULL, 0x000fc60007ffe0ffULL, 0x0000000104007824ULL, 0x100fe200078e0203ULL,
0x000000270e0e7212ULL, 0x000fe200078efcffULL, 0x0000000104147824ULL, 0x100fe400078e0224ULL,
0x0000000110167824ULL, 0x100fe200078e0224ULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000110047824ULL, 0x040fe400078e0203ULL, 0x0000000810357824ULL, 0x000fe200078e00ffULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x0000000113247824ULL, 0x000fc400078e0224ULL,
0x0000000113107824ULL, 0x000fe200078e0203ULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x0000000813377824ULL, 0x000fe200078e00ffULL, 0xfffffff815137812ULL, 0x000fe200078ee200ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000140006e007811ULL, 0x000fe400078e68ffULL,
0xfffffff837377812ULL, 0x000fe200078ee210ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000002714147212ULL, 0x000fc600078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000002716167212ULL, 0x080fe400078efcffULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000001009097824ULL, 0x100fe200078e0200ULL, 0x0000002724247212ULL, 0x000fe200078efcffULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x0000640016167a10ULL, 0x000fe20007f5e0ffULL,
0x0000001035277824ULL, 0x100fe200078e0200ULL, 0x0000640024247a10ULL, 0x000fe20007f7e0ffULL,
0x0000001037357824ULL, 0x000fe200078e0200ULL, 0x0000650015157a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0003e2000b901c46ULL,
0x0000650017177a10ULL, 0x000fc400017fe4ffULL, 0x0000650025257a10ULL, 0x000fe20001ffe4ffULL,
0x0000000014137faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000024357faeULL, 0x0003e4000b901c46ULL, 0xfffffff00d0e7812ULL, 0x042fe400078ec0ffULL,
0xffffffe00d007812ULL, 0x000fc400078ec0ffULL, 0x000000000e0573c2ULL, 0x000e6200000e0000ULL,
0x000000100d097812ULL, 0x000fca00078ec0ffULL, 0x0000000100097824ULL, 0x000fe400078e0209ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000874247824ULL, 0x000fe200078e0209ULL,
0x000176b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b0000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176080024247f8cULL, 0x000ea4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x000000080d007812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0200ULL,
0x01760c0009137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614137210ULL, 0x000fca0007f1e1ffULL, 0x0000000117167824ULL, 0x000fe200000e0e15ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000001300007211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0616ULL, 0x0000000200007819ULL, 0x000fc80000001213ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000104047810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01760c0009137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010035f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff7c7819ULL, 0x000fe20000011603ULL,
0x0000002002007824ULL, 0x000fc600078e00ffULL, 0x000000705f5f7812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c7c7c7812ULL, 0x000fc800078ec0ffULL,
0x000000007c007210ULL, 0x000fca0007ffe05fULL, 0x0170000000157984ULL, 0x000ea80000000800ULL,
0x0172000000047984ULL, 0x0006620000000800ULL, 0x000000121500720bULL, 0x004fe20003f1d000ULL,
0x000115c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff13177812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fd200078e0012ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000027a00720cULL, 0x000fe40003f05270ULL,
0x000000121500720bULL, 0x000fe20003f54000ULL, 0x000115827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fc400010e0100ULL, 0x0000008002138824ULL, 0x000fe200078e025fULL,
0x0000001215007209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991010147816ULL, 0x000fe200000000ffULL, 0x000000017c138824ULL, 0x000fca00078e0213ULL,
0x0174000013008388ULL, 0x0005e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000001200127221ULL, 0x004fe20000010100ULL,
0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL, 0x0000001200127308ULL, 0x000ea40000000800ULL,
0x0000001211117220ULL, 0x004fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011603ULL, 0x000114c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1312137589ULL, 0x0004e400000e0000ULL, 0x0000001330307220ULL, 0x08cfe40000410000ULL,
0x0000001331317220ULL, 0x080fe40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x000fc40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x000000133c3c7220ULL, 0x080fe40000410000ULL,
0x000000133d3d7220ULL, 0x080fe40000410000ULL, 0x0000001338387220ULL, 0x080fe40000410000ULL,
0x0000001339397220ULL, 0x000fc40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x080fe40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x080fe40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803137811ULL, 0x000fe200078ff0ffULL, 0x000113c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1312137589ULL, 0x0004e400000e0000ULL, 0x0000001332327220ULL, 0x08cfe40000410000ULL,
0x0000001333337220ULL, 0x080fe40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x080fe40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x000fc40000410000ULL, 0x000000133e3e7220ULL, 0x080fe40000410000ULL,
0x000000133f3f7220ULL, 0x080fe40000410000ULL, 0x000000133a3a7220ULL, 0x080fe40000410000ULL,
0x000000133b3b7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x000fc40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x080fe40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff17ff7812ULL, 0x000fe20007806010ULL, 0x00000001ff107424ULL, 0x000fd800078e00ffULL,
0x8000000015150221ULL, 0x000fe20000010000ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500080308ULL, 0x000ea40000000800ULL,
0x0000000804040220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001104117221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff00d247812ULL, 0x000fca00078ec0ffULL, 0x0176ac0024047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011415ULL, 0x0000001704047211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000204047819ULL, 0x000fc80000001215ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0024047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991010047816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x00010fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f0504077589ULL, 0x0002a400000e0000ULL,
0x0000000805137810ULL, 0x000fe20007ffe0ffULL, 0x000110027f007947ULL, 0x000fea000b800000ULL,
0x00001f1304067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001005137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0004ULL,
0x00002ea000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00011cb000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001805137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0004ULL, 0x00002f1000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00011c4000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000703137812ULL, 0x00cfe200078ec0ffULL, 0x0000020002057824ULL, 0x002fe200078e00ffULL,
0x00000004ff157819ULL, 0x100fe20000011603ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008135b7812ULL, 0x000fe400078ef803ULL, 0xfffff80005057812ULL, 0x000fe200078ec0ffULL,
0x000000046e627824ULL, 0x000fe200078e0215ULL, 0x0000000803047812ULL, 0x000fe200078ec0ffULL,
0x000000085b177824ULL, 0x040fe400078e00ffULL, 0x000000015b627824ULL, 0x000fca00078e0262ULL,
0xfffffff817347812ULL, 0x000fca00078ee262ULL, 0x0000001034347824ULL, 0x000fc600078e0205ULL,
0x0000001304127212ULL, 0x000fe200078efcffULL, 0x0000000474157824ULL, 0x000fe200078e0215ULL,
0x000130006e617811ULL, 0x000fe200078e68ffULL, 0x011000003434783bULL, 0x000e620000000200ULL,
0x0000001004047812ULL, 0x000fe200078efe13ULL, 0x0000000112147824ULL, 0x040fe400078e0215ULL,
0x0000000812177824ULL, 0x000fe400078e00ffULL, 0x0000000804137824ULL, 0x000fc600078e00ffULL,
0xfffffff817107812ULL, 0x000fe400078ee214ULL, 0x0000000214147810ULL, 0x000fc60007ffe0ffULL,
0x0000001010247824ULL, 0x100fe400078e0261ULL, 0x0000000115107824ULL, 0x000fe400078e0204ULL,
0x0000000812157824ULL, 0x000fe400078e00ffULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0xfffffff813167812ULL, 0x000fe400078ee210ULL, 0xfffffff815147812ULL, 0x000fe400078ee214ULL,
0x0000000210107810ULL, 0x000fe20007ffe0ffULL, 0x0000001016167824ULL, 0x000fc400078e0261ULL,
0x0000001014147824ULL, 0x000fc600078e0261ULL, 0x000000001644783bULL, 0x000ee80000004200ULL,
0x000000001414783bULL, 0x000f220000004200ULL, 0x0000000734348232ULL, 0x082fe40000000000ULL,
0x0000000736368232ULL, 0x000fe40000000000ULL, 0x0000000635358232ULL, 0x080fe40000000000ULL,
0x0000000637378232ULL, 0x000fe20000000000ULL, 0x00000018ff5d7819ULL, 0x004fe20000011424ULL,
0x0000010024137824ULL, 0x040fe200078e00ffULL, 0x0000888024527816ULL, 0x040fe200000000ffULL,
0x0000010025127824ULL, 0x040fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011425ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000888025537816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff557819ULL, 0x000fe40000011426ULL,
0x00000018ff547819ULL, 0x000fe20000011427ULL, 0x0000002400607306ULL, 0x0003e20000200c00ULL,
0x00008880266a7816ULL, 0x000fe400000000ffULL, 0x0000888027487816ULL, 0x000fe400000000ffULL,
0x00000018ff127819ULL, 0x000fc40000011412ULL, 0x00000018ff427819ULL, 0x008fe20000011447ULL,
0x00000025005e7306ULL, 0x0005e20000200c00ULL, 0x0000010027247824ULL, 0x002fe200078e00ffULL,
0x00008880474a7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011444ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000001300597306ULL, 0x0002e20000200c00ULL, 0x0000000804257824ULL, 0x004fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00008880444c7816ULL, 0x000fe400000000ffULL,
0xfffffff825107812ULL, 0x000fe400078ee210ULL, 0x00000024005a7306ULL, 0x0005e20000200c00ULL,
0x0000010026137824ULL, 0x042fe200078e00ffULL, 0x00000018ff577819ULL, 0x010fe20000011414ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888014657816ULL, 0x000fe200000000ffULL,
0x0000001010107824ULL, 0x000fe200078e0261ULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000010045247824ULL, 0x004fe200078e00ffULL,
0x0000002700677306ULL, 0x000fe20000200c00ULL, 0x0000541052527816ULL, 0x008fe40000000059ULL,
0x00000018ff417819ULL, 0x000fe40000011446ULL, 0x00000018ff4f7819ULL, 0x000fe40000011424ULL,
0x00000018ff567819ULL, 0x000fe20000011415ULL, 0x0000002600697306ULL, 0x0003e20000200c00ULL,
0x0000888015597816ULL, 0x000fc400000000ffULL, 0x00000018ff507819ULL, 0x000fe40000011416ULL,
0x00000018ff517819ULL, 0x000fe40000011417ULL, 0x00000018ff497819ULL, 0x000fe20000011445ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000000001024783bULL, 0x0022a20000004200ULL,
0x00008880454e7816ULL, 0x040fe200000000ffULL, 0x0001000045457824ULL, 0x000fca00078e00ffULL,
0x0000001200127306ULL, 0x000ee20000200c00ULL, 0x0000010047107824ULL, 0x042fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011445ULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011410ULL, 0x0001000046107824ULL, 0x000fe200078e00ffULL,
0x00000013006b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff477819ULL, 0x000fc60000011447ULL,
0x00000018ff6d7819ULL, 0x000fc80000011410ULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x0000010044137824ULL, 0x042fe200078e00ffULL, 0x0000541053537816ULL, 0x008fe20000000012ULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x000000523430723cULL, 0x000b6c0000001830ULL, 0x00000047006c7306ULL, 0x0007e20000200c00ULL,
0x0000010015527824ULL, 0x060fe200078e00ffULL, 0x00000018ff407819ULL, 0x004fe20000011425ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011426ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x00000013004d7306ULL, 0x0005e20000200c00ULL,
0x0000010014477824ULL, 0x048fe400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004400587306ULL, 0x0007e20000200c00ULL,
0x0000010046137824ULL, 0x004fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc80000011414ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000888046447816ULL, 0x008fce00000000ffULL, 0x0000006300467306ULL, 0x0005f00000200c00ULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x00000018ff637819ULL, 0x004fce0000011427ULL,
0x0000006300127306ULL, 0x000ff00000200c00ULL, 0x0000001400637306ULL, 0x0009f00000200c00ULL,
0x0000004700667306ULL, 0x0005e20000200c00ULL, 0x0000541060147816ULL, 0x010fc4000000005dULL,
0x00000018ff5d7819ULL, 0x000fe40000011415ULL, 0x000054105e157816ULL, 0x002fe4000000005cULL,
0x00008880165e7816ULL, 0x000fe200000000ffULL, 0x0000005200647306ULL, 0x0003e20000200c00ULL,
0x0000000262477810ULL, 0x004fe40007ffe0ffULL, 0x00008880175c7816ULL, 0x000fe200000000ffULL,
0x00000014342c723cULL, 0x000be8000000182cULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x000000085b527824ULL, 0x002fc400078e00ffULL, 0x0000010017147824ULL, 0x060fe400078e00ffULL,
0x0000010016157824ULL, 0x040fe400078e00ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011414ULL, 0x0001000016147824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0xfffffff852167812ULL, 0x000fe400078ee247ULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff527819ULL, 0x000fe40000011417ULL, 0x0000888024477816ULL, 0x000fe200000000ffULL,
0x0000001500607306ULL, 0x0007f00000200c00ULL, 0x00000014005b7306ULL, 0x0005e20000200c00ULL,
0x0000541048157816ULL, 0x008fe2000000005aULL, 0x0000001016487824ULL, 0x000fe200078e0205ULL,
0x0000541067537816ULL, 0x002fe20000000054ULL, 0x0000010024547824ULL, 0x000fc800078e00ffULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000054106a147816ULL, 0x004fce000000006bULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000000143428723cULL, 0x000b640000001828ULL,
0x011000004814783bULL, 0x020eea0000000200ULL, 0x00000052005a7306ULL, 0x0009f00000200c00ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x0000541069527816ULL, 0x010fc40000000055ULL,
0x00000018ff557819ULL, 0x000fe40000011454ULL, 0x0000888025547816ULL, 0x000fc600000000ffULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00000052343c723cULL, 0x000b6e000000183cULL,
0x0000005d005d7306ULL, 0x000f220000200c00ULL, 0x0000541065527816ULL, 0x022fe20000000066ULL,
0x0000010025657824ULL, 0x000fe200078e00ffULL, 0x0000541059537816ULL, 0x004fc80000000064ULL,
0x00000018ff597819ULL, 0x000fe20000011465ULL, 0x0000005e005e7306ULL, 0x000fe40000200c00ULL,
0x000000523438723cULL, 0x000b620000001838ULL, 0x0000000714148232ULL, 0x088fe40000000000ULL,
0x0000000716168232ULL, 0x000fe40000000000ULL, 0x0000000615158232ULL, 0x080fe20000000000ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541063527816ULL, 0x020fe20000000057ULL,
0x0000000617178232ULL, 0x000fe20000000000ULL, 0x000054105d537816ULL, 0x010fca0000000056ULL,
0x0000006200627306ULL, 0x000e640000200c00ULL, 0x00000052341c723cULL, 0x000b6c000000181cULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x0001000025537824ULL, 0x020fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x000054105c257816ULL, 0x002fce0000000062ULL, 0x0000001300457306ULL, 0x0003e20000200c00ULL,
0x000054105b507816ULL, 0x004fce0000000050ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff137819ULL, 0x002fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x000054105a517816ULL, 0x008fc80000000051ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000004e004e7306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x000054104c4c7816ULL, 0x004fce000000004dULL, 0x0000004400447306ULL, 0x000eb00000200c00ULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x000054104e4d7816ULL, 0x002fce000000004fULL,
0x0000002400527306ULL, 0x0003e20000200c00ULL, 0x0000541044447816ULL, 0x004fe20000000045ULL,
0x0000004c1430723cULL, 0x000fec0000001830ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054105e247816ULL, 0x002fe40000000060ULL, 0x000054104a457816ULL, 0x008fca0000000046ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000243418723cULL, 0x040b6e0000001818ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x000000503434723cULL, 0x000b640000001820ULL,
0x0000888026257816ULL, 0x020fca00000000ffULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000010026207824ULL, 0x040fe200078e00ffULL, 0x0000888027217816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x000000441428723cULL, 0x000b620000001828ULL,
0x0000010027227824ULL, 0x040fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054106d247816ULL, 0x002fe20000000041ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0021ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00000018ff447819ULL, 0x020fc60000011427ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000002500507306ULL, 0x0005f00000200c00ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054106c257816ULL, 0x004fc40000000042ULL,
0x000054104b217816ULL, 0x002fca0000000049ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000ff00000200c00ULL,
0x0000002000517306ULL, 0x0002b00000200c00ULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x0000541058207816ULL, 0x002fc40000000043ULL, 0x00000018ff437819ULL, 0x000fe40000011426ULL,
0x000000241424723cULL, 0x000f66000000183cULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541050507816ULL, 0x004fc80000000051ULL, 0x00000020142c723cULL, 0x000b66000000182cULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000541052527816ULL, 0x008fc60000000013ULL,
0x0000541047207816ULL, 0x020fe40000000055ULL, 0x0000541054217816ULL, 0x000fe40000000059ULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000002200497306ULL, 0x0004e20000200c00ULL,
0x0000541053537816ULL, 0x002fce0000000040ULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x000000201420723cULL, 0x044b6e0000001838ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000054104c517816ULL, 0x008fe20000000049ULL, 0x00000052141c723cULL, 0x040f6c000000181cULL,
0x00000044003d7306ULL, 0x000ea40000200c00ULL, 0x000000501418723cULL, 0x000f640000001818ULL,
0x0000541043387816ULL, 0x022fe20000000010ULL, 0x0000000202107824ULL, 0x000fca00078e00ffULL,
0xfffffff810107812ULL, 0x000fe400078ec0ffULL, 0x000054103d397816ULL, 0x004fce0000000012ULL,
0x000000381414723cULL, 0x000b6e0000001834ULL, 0x000176c86e367811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000036367f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176880010ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff387224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x000004000b357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804837ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412397210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x004fc80000011435ULL, 0x0000003910107211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000210107819ULL, 0x000fc80000001235ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000b357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800a137810ULL, 0x000fca0007ffe0ffULL,
0x0000680076377a24ULL, 0x000fe200078e0213ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001368107217ULL, 0x004fe20007800000ULL, 0x0000001074357824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc60000011603ULL, 0x0000000110107824ULL, 0x000fe200078e0a13ULL,
0x0000000412367810ULL, 0x040fe20007ffe0ffULL, 0x0000000135347824ULL, 0x040fe200078e0212ULL,
0x0000000812387810ULL, 0x000fe40007ffe0ffULL, 0x0000001035107217ULL, 0x000fe20007800000ULL,
0x0000000134137824ULL, 0x000fe200078e0203ULL, 0x0000000c12397810ULL, 0x000fe20007ffe0ffULL,
0x00000008343a7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fc400078e0a35ULL,
0x00000001353e7824ULL, 0x040fe200078e0239ULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee213ULL,
0x000000103600720cULL, 0x080fe20003f66070ULL, 0x0000000135367824ULL, 0x000fe200078e0236ULL,
0x000000101200720cULL, 0x080fe20003f86070ULL, 0x0000000134127824ULL, 0x000fe200078e0237ULL,
0x000000103800720cULL, 0x080fe20003f46070ULL, 0x0000000136137824ULL, 0x040fe200078e0203ULL,
0x000000103900720cULL, 0x000fe20003f06070ULL, 0x0000000836347824ULL, 0x000fc400078e00ffULL,
0x0000000135387824ULL, 0x000fe400078e0238ULL, 0x000000013e3b7824ULL, 0x000fe200078e0203ULL,
0xfffffff834107812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000136347824ULL, 0x000fe200078e0237ULL, 0x0000005f12127212ULL, 0x000fe200078efcffULL,
0x0000000138397824ULL, 0x040fe400078e0203ULL, 0x00000008383c7824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007fbe0ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL, 0x0000000138367824ULL, 0x100fe200078e0237ULL,
0x0000005f34347212ULL, 0x000fe200078efcffULL, 0x000000013e387824ULL, 0x000fe200078e0237ULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000640034347a10ULL, 0x000fc60007fbe0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000005f36367212ULL, 0x080fe400078efcffULL, 0x0000650035357a10ULL, 0x000fe20002ffe4ffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000005f38387212ULL, 0x000fe200078efcffULL,
0x00000010103d7824ULL, 0x100fe200078e0261ULL, 0x0000640036367a10ULL, 0x000fe20007fbe0ffULL,
0x000000103c3f7824ULL, 0x000fe200078e0261ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL,
0x000000103a3b7824ULL, 0x000fe200078e0261ULL, 0x0000640038387a10ULL, 0x000fc40007fde0ffULL,
0x0000650037377a10ULL, 0x000fe20002ffe4ffULL, 0x000000103e417824ULL, 0x000fe200078e0261ULL,
0x0000650039397a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e8000e101c46ULL, 0x00000000343d7faeULL, 0x0003e8000d901c46ULL,
0x00000000363f7faeULL, 0x0003e8000d101c46ULL, 0x0000000038417faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001074107824ULL, 0x004fca00078e00ffULL,
0x0000001003107211ULL, 0x000fc800078fe8ffULL, 0x0000000410387810ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x140fe200078e0203ULL, 0x0000000810347810ULL, 0x040fe20007ffe0ffULL,
0x0000000810397824ULL, 0x000fe400078e00ffULL, 0x0000000138137824ULL, 0x040fe400078e0203ULL,
0x00000008383c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8393a7812ULL, 0x000fe200078ee212ULL,
0x0000000110127824ULL, 0x040fe200078e0237ULL, 0x0000000c10107810ULL, 0x000fe20007ffe0ffULL,
0x0000000134357824ULL, 0x000fe200078e0203ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x00000008343e7824ULL, 0x000fc400078e00ffULL, 0x0000000138387824ULL, 0x000fe400078e0237ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fc600078ee235ULL,
0x0000000134347824ULL, 0x100fe200078e0237ULL, 0x0000005f12127212ULL, 0x000fe200078efcffULL,
0x0000000110367824ULL, 0x000fe400078e0237ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007f1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005f38387212ULL, 0x080fe400078efcffULL, 0x0000650013137a10ULL, 0x000fe200007fe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000005f34347212ULL, 0x080fe400078efcffULL,
0x0000640038387a10ULL, 0x000fe20007f5e0ffULL, 0x00000001103b7824ULL, 0x000fe200078e0203ULL,
0x0000005f36367212ULL, 0x000fe200078efcffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x0000640034347a10ULL, 0x000fe20007f1e0ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0261ULL,
0x0000640036367a10ULL, 0x000fe20007f7e0ffULL, 0x000000103e3f7824ULL, 0x000fe200078e0261ULL,
0xfffffff810107812ULL, 0x000fe200078ee23bULL, 0x000000103a3b7824ULL, 0x000fe200078e0261ULL,
0x0000650039397a10ULL, 0x000fc400017fe4ffULL, 0x0000650035357a10ULL, 0x000fe200007fe4ffULL,
0x0000001010417824ULL, 0x000fe200078e0261ULL, 0x0000650037377a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0003e8000b901c46ULL,
0x00000000383d7faeULL, 0x0003e8000b901c46ULL, 0x00000000343f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036417faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000106e107824ULL, 0x000fe200078e00ffULL, 0xffffffe00d137812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x000000080d127812ULL, 0x000fe400078ec0ffULL,
0x0000001010107812ULL, 0x000fc800078ec0ffULL, 0x0000001312107210ULL, 0x000fe20007ffe010ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff447f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280010367f8cULL, 0x0004e4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01762c0009357984ULL, 0x000f240000000800ULL, 0x8000000035ff7812ULL, 0x018fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412397210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x004fc80000011435ULL,
0x0000003910107211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000210107819ULL, 0x000fc80000001235ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c0009357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002107824ULL, 0x004fca00078e00ffULL, 0xffffff8010107812ULL, 0x000fc800078ec0ffULL,
0x000000805f137810ULL, 0x000fca0007ffe010ULL, 0x000000017c137824ULL, 0x000fca00078e0213ULL,
0x0170000013397984ULL, 0x000ea80000000800ULL, 0x0172000013107984ULL, 0x0006620000000800ULL,
0x000000003900720bULL, 0x004fe20003f1d000ULL, 0x0000f1327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x008fc800000e0100ULL, 0x0000ffff133b7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff367424ULL, 0x000fd600078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000017a137810ULL, 0x000fe40007ffe0ffULL,
0x000000003900720bULL, 0x000fe40003f54000ULL, 0x000000021300720cULL, 0x000fe20003f05270ULL,
0x0000f0f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000127806ULL, 0x000fc400010e0100ULL,
0x0000008002138824ULL, 0x000fe200078e025fULL, 0x0000000039357209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000017c348824ULL, 0x000fe200078e0213ULL,
0x0000991012137816ULL, 0x000fc800000000ffULL, 0x0174003534008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000003500137221ULL, 0x004fe20000010000ULL, 0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300387308ULL, 0x000ea40000000800ULL, 0x0000003811117220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011603ULL,
0x0000f0327f007947ULL, 0x000fea000b800000ULL, 0x00001f1338137589ULL, 0x0004e400000e0000ULL,
0x0000001330307220ULL, 0x08cfe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x080fe40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x000fc40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x000fc40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803137811ULL, 0x000fe200078ff0ffULL,
0x0000ef327f007947ULL, 0x000fea000b800000ULL, 0x00001f1338137589ULL, 0x0004e400000e0000ULL,
0x0000001332327220ULL, 0x08cfe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806012ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000000039007209ULL, 0x000fd60007810000ULL,
0x8000000039390221ULL, 0x000fe20000010000ULL, 0x00007610ff360816ULL, 0x000fc60000000036ULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000ea40000000800ULL,
0x0000000810100220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001110117221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff00d397812ULL, 0x000fca00078ec0ffULL, 0x0176b40039357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011435ULL, 0x0000003710107211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000210107819ULL, 0x000fc80000001235ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b40039357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910360e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x00005410060e7816ULL, 0x000fe20000000006ULL,
0x0000eb127f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e077589ULL, 0x0002a400000e0000ULL,
0x000000080f137810ULL, 0x000fe20007ffe0ffULL, 0x0000eb627f007947ULL, 0x000fea000b800000ULL,
0x00001f130e067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e000eULL,
0x000055a000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000f5b000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x0000561000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000f54000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000202677824ULL, 0x000fe200078e00ffULL, 0x0000000703127812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x00000004670e7812ULL, 0x00afe400078ec0ffULL,
0x00000008120f7812ULL, 0x000fe400078ef803ULL, 0x0000000e030e7211ULL, 0x000fc600078fe0ffULL,
0x000000080f137824ULL, 0x044fe400078e00ffULL, 0x000000010f107824ULL, 0x000fe200078e020eULL,
0x00000008030f7812ULL, 0x000fc800078ec0ffULL, 0xfffffff8130e7812ULL, 0x000fca00078ee210ULL,
0x000000100e477824ULL, 0x000fc400078e0205ULL, 0x00000004020e7824ULL, 0x000fe200078e00ffULL,
0x000000120f3a7212ULL, 0x000fe200078efcffULL, 0x0000000804537824ULL, 0x000fe200078e00ffULL,
0x0000100061797810ULL, 0x000fe40007ffe0ffULL, 0x000000040e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000083a137824ULL, 0x000fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe400078ec0ffULL,
0x0000000e030f7211ULL, 0x000fca00078fe0ffULL, 0x000000013a387824ULL, 0x100fe400078e020fULL,
0x0000000104127824ULL, 0x000fc600078e020fULL, 0xfffffff813607812ULL, 0x000fe200078ee238ULL,
0x0000000804137824ULL, 0x000fe200078e00ffULL, 0x0000000238467810ULL, 0x000fc60007ffe0ffULL,
0x0000001060607824ULL, 0x100fe200078e0279ULL, 0xfffffff8130e7812ULL, 0x000fe400078ee212ULL,
0x0000000212127810ULL, 0x000fe40007ffe0ffULL, 0x00000000603c783bULL, 0x000e620000004200ULL,
0x000000100e347824ULL, 0x000fe200078e0279ULL, 0xfffffff853127812ULL, 0x000fca00078ee212ULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x00000018ff4c7819ULL, 0x002fe2000001143cULL,
0x000001003c397824ULL, 0x040fe200078e00ffULL, 0x000088803c407816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe2000001143dULL,
0x000001003d437824ULL, 0x040fe200078e00ffULL, 0x000088803d427816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003f507824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001143eULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000018ff637819ULL, 0x000fe2000001143fULL,
0x0000010035517824ULL, 0x004fe200078e00ffULL, 0x000088803e697816ULL, 0x000fc400000000ffULL,
0x000088803f497816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff417819ULL, 0x000fe20000011439ULL, 0x000000083a397824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0xfffffff839467812ULL, 0x000fe200078ee246ULL, 0x0000003d004f7306ULL, 0x000fe20000200c00ULL,
0x000001003e3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011434ULL,
0x0000001046387824ULL, 0x000fe200078e0279ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff667819ULL, 0x000fe2000001143eULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe20000011435ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000888034547816ULL, 0x000fe400000000ffULL, 0x0000888035567816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000003c006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc40000011436ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff4a7819ULL, 0x000fe40000011437ULL,
0x0000888037527816ULL, 0x000fe200000000ffULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x01180000473c783bULL, 0x004eae0000000200ULL, 0x0000004300437306ULL, 0x000ef00000200c00ULL,
0x00000050006b7306ULL, 0x0009f00000200c00ULL, 0x00000035005d7306ULL, 0x0007e20000200c00ULL,
0x0000010034507824ULL, 0x050fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x002fe20000011438ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fc40000011439ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000541042357816ULL, 0x008fe40000000043ULL,
0x00000018ff587819ULL, 0x000fe4000001143aULL, 0x00000018ff597819ULL, 0x000fc6000001143bULL,
0x00000034005a7306ULL, 0x0007e20000200c00ULL, 0x000000073c3c8232ULL, 0x084fe40000000000ULL,
0x000000073e3e8232ULL, 0x000fe40000000000ULL, 0x000000063d3d8232ULL, 0x080fe40000000000ULL,
0x000000063f3f8232ULL, 0x000fe20000000000ULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541040347816ULL, 0x008fe20000000041ULL, 0x0000001012407824ULL, 0x000fcc00078e0279ULL,
0x000000343c30723cULL, 0x000be20000001830ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x000000004040783bULL, 0x000f2a0000004200ULL, 0x0000010036347824ULL, 0x020fe400078e00ffULL,
0x0000010037357824ULL, 0x040fe200078e00ffULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000005100577306ULL, 0x000ff00000200c00ULL, 0x0000003400517306ULL, 0x0003f00000200c00ULL,
0x0000003500537306ULL, 0x0005e20000200c00ULL, 0x000054105e347816ULL, 0x002fce000000004cULL,
0x0000005000557306ULL, 0x0003e20000200c00ULL, 0x000054104f357816ULL, 0x004fe40000000013ULL,
0x00000018ff4c7819ULL, 0x010fe40000011440ULL, 0x00000018ff4f7819ULL, 0x000fe40000011441ULL,
0x00000018ff137819ULL, 0x000fe20000011442ULL, 0x000000343c2c723cULL, 0x000b62000000182cULL,
0x0000888036507816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000006400647306ULL, 0x000fe80000200c00ULL, 0x0000541069347816ULL, 0x028fc4000000006aULL,
0x0000541049357816ULL, 0x000fe4000000006bULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000018ff697819ULL, 0x000fe40000011443ULL,
0x000000343c28723cULL, 0x000be60000001828ULL, 0x0000006600667306ULL, 0x000e680000200c00ULL,
0x0000010038347824ULL, 0x020fc400078e00ffULL, 0x0000010039357824ULL, 0x000fe400078e00ffULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fca0000011435ULL, 0x0000003600627306ULL, 0x0007f00000200c00ULL,
0x00000037005e7306ULL, 0x0009e20000200c00ULL, 0x0000888039367816ULL, 0x048fe200000000ffULL,
0x0001000039397824ULL, 0x000fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00000034006b7306ULL, 0x0003e20000200c00ULL, 0x0000888038377816ULL, 0x050fe200000000ffULL,
0x0001000038387824ULL, 0x000fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x00000035006c7306ULL, 0x0005e20000200c00ULL, 0x0000541066347816ULL, 0x002fce0000000064ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541065357816ULL, 0x004fe40000000063ULL,
0x000088803b657816ULL, 0x000fca00000000ffULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000000343c24723cULL, 0x000b6e0000001824ULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x000001003b357824ULL, 0x020fe400078e00ffULL, 0x000001003a347824ULL, 0x000fc400078e00ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011435ULL,
0x0000003900397306ULL, 0x000ea20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff3b7819ULL, 0x000fca000001143bULL, 0x0000003700377306ULL, 0x000fe20000200c00ULL,
0x0000541038387816ULL, 0x002fce000000005cULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x0000541039397816ULL, 0x004fe2000000005bULL, 0x00000100405b7824ULL, 0x000fcc00078e00ffULL,
0x0000006900497306ULL, 0x0005e20000200c00ULL, 0x000000383c1c723cULL, 0x000bee000000181cULL,
0x00000034006a7306ULL, 0x0007e20000200c00ULL, 0x000088803a697816ULL, 0x044fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541036357816ULL, 0x002fe2000000006cULL,
0x0000010041397824ULL, 0x020fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc4000001145bULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541037347816ULL, 0x008fe4000000006bULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00008880406b7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe400078e00ffULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000343c34723cULL, 0x000b640000001820ULL,
0x011800004820783bULL, 0x020e620000000200ULL, 0x00000018ff407819ULL, 0x000fc80000011440ULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000005800587306ULL, 0x000ff00000200c00ULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000003a00647306ULL, 0x000eb00000200c00ULL,
0x0000003b00637306ULL, 0x0007220000200c00ULL, 0x0000000720208232ULL, 0x002fc40000000000ULL,
0x0000000722228232ULL, 0x000fe40000000000ULL, 0x0000000621218232ULL, 0x000fc60000000000ULL,
0x0000003800487306ULL, 0x0003e20000200c00ULL, 0x0000541064587816ULL, 0x004fe20000000058ULL,
0x0000000623238232ULL, 0x000fe20000000000ULL, 0x00008880413b7816ULL, 0x048fe200000000ffULL,
0x0001000041417824ULL, 0x000fc800078e00ffULL, 0x00000039005b7306ULL, 0x0005e20000200c00ULL,
0x0000541069387816ULL, 0x002fe4000000006aULL, 0x0000541063597816ULL, 0x010fe40000000059ULL,
0x00000018ff417819ULL, 0x000fc60000011441ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x0000541065397816ULL, 0x004fe20000000066ULL, 0x000000583c14723cULL, 0x040fec0000001814ULL,
0x0000004d004d7306ULL, 0x000fe40000200c00ULL, 0x000000383c18723cULL, 0x000b6c0000001818ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000888042387816ULL, 0x060fe200000000ffULL,
0x0000010042397824ULL, 0x000fe200078e00ffULL, 0x00008880433e7816ULL, 0x040fe200000000ffULL,
0x00000100433f7824ULL, 0x040fe200078e00ffULL, 0x000054105e637816ULL, 0x002fe2000000004aULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000018ff437819ULL, 0x000fca0000011443ULL, 0x0000005000507306ULL, 0x000eb00000200c00ULL,
0x00000038003c7306ULL, 0x0007e20000200c00ULL, 0x0000541054547816ULL, 0x002fce0000000055ULL,
0x00000039003d7306ULL, 0x0003220000200c00ULL, 0x000054105a387816ULL, 0x008fe4000000004dULL,
0x0000541050507816ULL, 0x004fca0000000051ULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x000054105d397816ULL, 0x002fce000000004eULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x000054103c3c7816ULL, 0x010fe2000000003dULL, 0x00000038202c723cULL, 0x000f6c000000182cULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x0000541062627816ULL, 0x004fce000000004bULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541056557816ULL, 0x002fe20000000057ULL,
0x000000622024723cULL, 0x040f6c0000001824ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541052517816ULL, 0x008fe20000000053ULL, 0x000000542030723cULL, 0x040f6c0000001830ULL,
0x0000001300137306ULL, 0x000fe40000200c00ULL, 0x000000502028723cULL, 0x000f6c0000001828ULL,
0x0000006b003a7306ULL, 0x000e700000200c00ULL, 0x0000003b003b7306ULL, 0x000eb00000200c00ULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x000054103a3a7816ULL, 0x002fce0000000048ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000054103b3b7816ULL, 0x004fce000000005bULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541040407816ULL, 0x008fe2000000004cULL,
0x0000003a2038723cULL, 0x000f6c0000001834ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541041417816ULL, 0x002fce000000004fULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x00000040201c723cULL, 0x000f6e000000181cULL, 0x00000043004a7306ULL, 0x000ee20000200c00ULL,
0x000054103e3d7816ULL, 0x004fe4000000003fULL, 0x0000541042427816ULL, 0x002fca0000000013ULL,
0x0000003c2018723cULL, 0x000f620000001818ULL, 0x000054104a437816ULL, 0x008fce0000000049ULL,
0x000000422014723cULL, 0x000b6e0000001814ULL, 0x000176c86e207811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000020207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900067ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff137224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x000fc80000015200ULL,
0x000004000b357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804821ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003422377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e23ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000b357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00a217810ULL, 0x000fca0007ffe0ffULL,
0x0000680076367a24ULL, 0x000fe200078e0221ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000002168137217ULL, 0x000fe20007800000ULL, 0x0000001074227824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fc60000011603ULL, 0x0000000113137824ULL, 0x000fe200078e0a21ULL,
0x0000000420347810ULL, 0x000fe20007ffe0ffULL, 0x0000000122217824ULL, 0x000fe200078e0220ULL,
0x0000000c20357810ULL, 0x000fe40007ffe0ffULL, 0x0000001322137217ULL, 0x000fe20007800000ULL,
0x0000000121237824ULL, 0x040fe400078e0203ULL, 0x00000008213c7824ULL, 0x000fe400078e00ffULL,
0x0000000113137824ULL, 0x000fc400078e0a22ULL, 0x00000001223d7824ULL, 0x000fe200078e0235ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee223ULL, 0x000000133400720cULL, 0x080fe20003f66070ULL,
0x0000000122347824ULL, 0x000fe200078e0234ULL, 0x0000000820237810ULL, 0x040fe20007ffe0ffULL,
0x000000083d427824ULL, 0x000fe200078e00ffULL, 0x000000132000720cULL, 0x080fe20003f86070ULL,
0x0000000121207824ULL, 0x000fe200078e0236ULL, 0x000000132300720cULL, 0x080fe20003f46070ULL,
0x0000000134217824ULL, 0x040fe200078e0203ULL, 0x000000133500720cULL, 0x000fe20003f06070ULL,
0x00000008343e7824ULL, 0x000fc400078e00ffULL, 0x0000000122237824ULL, 0x000fe400078e0223ULL,
0x0000000134227824ULL, 0x000fe200078e0236ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee221ULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x0000000123347824ULL, 0x040fe200078e0236ULL,
0x0000005f20207212ULL, 0x000fe200078efcffULL, 0x0000000123137824ULL, 0x040fe400078e0203ULL,
0x0000000823407824ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007fbe0ffULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x000000013d367824ULL, 0x000fe200078e0236ULL, 0x0000005f22227212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000650021217a10ULL, 0x000fe40002ffe4ffULL,
0x0000640022227a10ULL, 0x000fe20007fbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005f34347212ULL, 0x080fe400078efcffULL, 0x0000650023237a10ULL, 0x000fe20002ffe4ffULL,
0x000000013d137824ULL, 0x000fe200078e0203ULL, 0x0000005f36367212ULL, 0x000fe200078efcffULL,
0x000000103e3d7824ULL, 0x100fe200078e0279ULL, 0x0000640034347a10ULL, 0x000fe20007fbe0ffULL,
0x00000010403f7824ULL, 0x000fe200078e0279ULL, 0xfffffff842427812ULL, 0x000fe200078ee213ULL,
0x000000103c137824ULL, 0x000fe200078e0279ULL, 0x0000640036367a10ULL, 0x000fc40007fde0ffULL,
0x0000650035357a10ULL, 0x000fe20002ffe4ffULL, 0x0000001042417824ULL, 0x000fe200078e0279ULL,
0x0000650037377a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020137faeULL, 0x0003e8000e101c46ULL, 0x00000000223d7faeULL, 0x0003e8000d901c46ULL,
0x00000000343f7faeULL, 0x0003e8000d101c46ULL, 0x0000000036417faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001074207824ULL, 0x000fca00078e00ffULL,
0x0000002003137211ULL, 0x000fc800078fe8ffULL, 0x00000004133c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113207824ULL, 0x140fe200078e0203ULL, 0x0000000813347810ULL, 0x040fe20007ffe0ffULL,
0x0000000813237824ULL, 0x000fe400078e00ffULL, 0x000000013c217824ULL, 0x140fe400078e0203ULL,
0x000000083c407824ULL, 0x000fe200078e00ffULL, 0xfffffff8233e7812ULL, 0x000fe200078ee220ULL,
0x0000000113207824ULL, 0x040fe200078e0236ULL, 0x0000000c13137810ULL, 0x000fe20007ffe0ffULL,
0x0000000134227824ULL, 0x000fe200078e0203ULL, 0xfffffff840407812ULL, 0x000fe200078ee221ULL,
0x0000000834357824ULL, 0x000fc400078e00ffULL, 0x000000013c3c7824ULL, 0x000fe400078e0236ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff835427812ULL, 0x000fc600078ee222ULL,
0x0000000134347824ULL, 0x100fe200078e0236ULL, 0x0000005f20227212ULL, 0x000fe200078efcffULL,
0x0000000113367824ULL, 0x000fe400078e0236ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fc60007f1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005f3c207212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005f34347212ULL, 0x080fe400078efcffULL, 0x0000640020207a10ULL, 0x000fe20007f5e0ffULL,
0x0000000113237824ULL, 0x040fe200078e0203ULL, 0x0000005f36367212ULL, 0x000fe200078efcffULL,
0x0000000813487824ULL, 0x000fe400078e00ffULL, 0x000000103e137824ULL, 0x100fe200078e0279ULL,
0x0000640036367a10ULL, 0x000fe20007f7e0ffULL, 0x00000010423f7824ULL, 0x000fe200078e0279ULL,
0xfffffff848487812ULL, 0x000fc400078ee223ULL, 0x0000650021237a10ULL, 0x000fe400007fe4ffULL,
0x0000640034347a10ULL, 0x000fe20007f1e0ffULL, 0x0000001048417824ULL, 0x100fe200078e0279ULL,
0x000065003d217a10ULL, 0x000fe200017fe4ffULL, 0x00000010403d7824ULL, 0x000fe200078e0279ULL,
0x0000650035357a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022137faeULL, 0x0003e2000b901c46ULL, 0x0000650037377a10ULL, 0x000fc60001ffe4ffULL,
0x00000000203d7faeULL, 0x0003e8000b901c46ULL, 0x00000000343f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036417faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff00d207812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b00020207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480009227f8cULL, 0x0006a4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0xffffffe00d097812ULL, 0x048fe400078ec0ffULL,
0x000000100d367812ULL, 0x040fe400078ec0ffULL, 0x000000080d137812ULL, 0x000fc800078ec0ffULL,
0x0000000913097210ULL, 0x000fca0007ffe036ULL, 0x01764c0009137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00cfe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011437ULL, 0x0000003613137211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000213137819ULL, 0x000fc80000001236ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c0009137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002097824ULL, 0x000fca00078e00ffULL,
0xffffff8009227812ULL, 0x000fc800078ec0ffULL, 0x000001005f097810ULL, 0x000fca0007ffe022ULL,
0x000000017c097824ULL, 0x000fca00078e0209ULL, 0x0170000009237984ULL, 0x000ea80000000800ULL,
0x0172000009227984ULL, 0x0006620000000800ULL, 0x000000002300720bULL, 0x004fe20003f1d000ULL,
0x0000cce27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff133c7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff097424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000027a097810ULL, 0x000fe40007ffe0ffULL, 0x000000002300720bULL, 0x000fe40003f54000ULL,
0x000000020900720cULL, 0x000fe20003f05270ULL, 0x0000cca27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400010e0100ULL, 0x0000008002358824ULL, 0x000fe200078e025fULL,
0x0000000023138209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991009347816ULL, 0x000fe200000000ffULL, 0x000000017c368824ULL, 0x000fca00078e0235ULL,
0x0174001336008388ULL, 0x0005e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000023137209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000013137221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x00000013003e7308ULL, 0x000ea40000000800ULL, 0x0000003e11117220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011603ULL,
0x0000cbd27f007947ULL, 0x000fea000b800000ULL, 0x00001f133e137589ULL, 0x0004e400000e0000ULL,
0x0000001330307220ULL, 0x08cfe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001338387220ULL, 0x080fe40000410000ULL, 0x0000001339397220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803137811ULL, 0x000fe200078ff0ffULL,
0x0000cad27f007947ULL, 0x000fea000b800000ULL, 0x00001f133e137589ULL, 0x0004e400000e0000ULL,
0x0000001332327220ULL, 0x08cfe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x000000133a3a7220ULL, 0x080fe40000410000ULL, 0x000000133b3b7220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe20007806009ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000023007209ULL, 0x000fd60007810000ULL,
0x8000000023230221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300080308ULL, 0x000ea40000000800ULL,
0x0000000822220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001122117221ULL, 0x002fc40000010000ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0xfffffff00d377812ULL, 0x000fca00078ec0ffULL, 0x0176ac0037137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003422347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e23ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011435ULL, 0x0000003413137211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x0000000213137819ULL, 0x000fc80000001234ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0037137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991009097816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff227819ULL, 0x000fe40000011603ULL, 0x0000541006097816ULL, 0x000fe20000000006ULL,
0x0000c6b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2209077589ULL, 0x0002a400000e0000ULL,
0x0000000822137810ULL, 0x000fe20007ffe0ffULL, 0x0000c7027f007947ULL, 0x000fea000b800000ULL,
0x00001f1309067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001022137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0009ULL,
0x00007c6000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000cef000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001822137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x00007cd000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000ce8000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001046407824ULL, 0x100fe200078e0261ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000100e347824ULL, 0x100fe200078e0261ULL, 0x012000004744783bULL, 0x000f220000000200ULL,
0x00000010123c7824ULL, 0x000fc600078e0261ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000000744448232ULL, 0x094fe40000000000ULL, 0x0000000746468232ULL, 0x000fe20000000000ULL,
0x00000018ff487819ULL, 0x008fe20000011440ULL, 0x0000010040097824ULL, 0x042fe200078e00ffULL,
0x00008880404c7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011441ULL, 0x0000010041137824ULL, 0x040fe200078e00ffULL,
0x00008880414e7816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000000645458232ULL, 0x080fe20000000000ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000000647478232ULL, 0x000fe20000000000ULL,
0x00000018ff547819ULL, 0x000fe20000011442ULL, 0x0000010034227824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x00000009004d7306ULL, 0x0002a20000200c00ULL,
0x0000888042507816ULL, 0x000fc400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011434ULL,
0x00000018ff557819ULL, 0x000fe40000011443ULL, 0x0000888043517816ULL, 0x000fe200000000ffULL,
0x00000040004b7306ULL, 0x0007e20000200c00ULL, 0x0000010042097824ULL, 0x042fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe2000001143eULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x000088803e657816ULL, 0x000fe400000000ffULL, 0x00000018ff097819ULL, 0x000fc40000011409ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000010035407824ULL, 0x008fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x000054104c4c7816ULL, 0x004fe4000000004dULL,
0x000088803c6b7816ULL, 0x000fe400000000ffULL, 0x00000013004f7306ULL, 0x0002a20000200c00ULL,
0x000088803d6a7816ULL, 0x000fe400000000ffULL, 0x00000018ff637819ULL, 0x000fc4000001143cULL,
0x00000018ff627819ULL, 0x000fe4000001143dULL, 0x000088803f647816ULL, 0x000fe200000000ffULL,
0x00000041004a7306ULL, 0x0007e20000200c00ULL, 0x0000010043137824ULL, 0x042fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011422ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011435ULL, 0x00000018ff527819ULL, 0x000fe40000011413ULL,
0x0000004200577306ULL, 0x0003e20000200c00ULL, 0x00000018ff417819ULL, 0x008fe20000011440ULL,
0x0001000034407824ULL, 0x000fe200078e00ffULL, 0x000054104e4d7816ULL, 0x004fc4000000004fULL,
0x0000888034137816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x0000000803427812ULL, 0x002fe200078ec0ffULL,
0x0000004c444c723cULL, 0x000b620000001838ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000000742427812ULL, 0x000fe400078ef803ULL, 0x0000888035227816ULL, 0x000fe200000000ffULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x00000007033a7812ULL, 0x020fe200078ec0ffULL,
0x00000001420f7824ULL, 0x040fe200078e020fULL, 0x00000018ff587819ULL, 0x000fe2000001143fULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x000000083a3a7812ULL, 0x000fe200078ef803ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011437ULL,
0x0000004000787306ULL, 0x0007e20000200c00ULL, 0x000054104b487816ULL, 0x004fe20000000048ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011438ULL,
0x000100003e387824ULL, 0x000fe200078e00ffULL, 0x00008880365a7816ULL, 0x000fc400000000ffULL,
0x00000018ff777819ULL, 0x000fe20000011435ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000001003c407824ULL, 0x008fe200078e00ffULL, 0x000054104a497816ULL, 0x002fe20000000049ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000010036357824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000000900097306ULL, 0x000e620000200c00ULL, 0x000000484448723cULL, 0x000b62000000181cULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff597819ULL, 0x000fe40000011435ULL,
0x0000888037357816ULL, 0x000fe400000000ffULL, 0x00000040006c7306ULL, 0x0005e20000200c00ULL,
0x000000083a1c7824ULL, 0x020fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fcc0000011436ULL,
0x0000004100347306ULL, 0x0007e20000200c00ULL, 0xfffffff842407812ULL, 0x004fe200078ee20fULL,
0x000001003e0f7824ULL, 0x000fe200078e00ffULL, 0x0000541050507816ULL, 0x002fc60000000009ULL,
0x0000001040407824ULL, 0x000fe200078e0261ULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000004300567306ULL, 0x000fe20000200c00ULL, 0x000001003d417824ULL, 0x048fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000000f00667306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x00000041006d7306ULL, 0x0005e20000200c00ULL, 0x00000002100f7810ULL, 0x002fc80007ffe0ffULL,
0xfffffff81c1c7812ULL, 0x000fc600078ee20fULL, 0x00000038006f7306ULL, 0x0003e20000200c00ULL,
0x000000004040783bULL, 0x004ea20000004200ULL, 0x000000101c097824ULL, 0x000fcc00078e00ffULL,
0x00000039003e7306ULL, 0x0007e20000200c00ULL, 0x0001200005387810ULL, 0x002fce0007ffe009ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000000003838783bULL, 0x008eee0000000200ULL,
0x0000005500557306ULL, 0x000f300000200c00ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x0000541057547816ULL, 0x002fce0000000054ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541056557816ULL, 0x010fe40000000055ULL, 0x0000888040717816ULL, 0x004fe400000000ffULL,
0x0000888041707816ULL, 0x000fe400000000ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011442ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000544454723cULL, 0x000b620000001814ULL,
0x000054106b1c7816ULL, 0x000fc4000000006cULL, 0x00000018ff057819ULL, 0x000fc80000011443ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000010040147824ULL, 0x020fe200078e00ffULL,
0x0000000738388232ULL, 0x088fe20000000000ULL, 0x0000010041157824ULL, 0x000fe200078e00ffULL,
0x000000073a3a8232ULL, 0x000fe20000000000ULL, 0x000054106a1d7816ULL, 0x002fe2000000006dULL,
0x0000000639398232ULL, 0x080fe20000000000ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000063b3b8232ULL, 0x000fe20000000000ULL,
0x00000018ff157819ULL, 0x000fcc0000011415ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541051517816ULL, 0x004fe20000000052ULL, 0x0000001c381c723cULL, 0x000bec000000184cULL,
0x0000003c00697306ULL, 0x0002a20000200c00ULL, 0x00008880434e7816ULL, 0x020fe200000000ffULL,
0x000000504450723cULL, 0x000bec0000001818ULL, 0x0000003d00677306ULL, 0x0007220000200c00ULL,
0x00000018ff3c7819ULL, 0x002fe20000011440ULL, 0x0001000040407824ULL, 0x000fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000001400727306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x008fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x0000541069187816ULL, 0x024fc80000000063ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000888042147816ULL, 0x002fe400000000ffULL,
0x0000541067197816ULL, 0x010fc60000000062ULL, 0x000000ffff4c7224ULL, 0x000fe400078e0014ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000010042147824ULL, 0x000fe200078e00ffULL,
0x000000183818723cULL, 0x000be80000001848ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000001500737306ULL, 0x0003f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000010043157824ULL, 0x002fc400078e00ffULL, 0x0001000043437824ULL, 0x000fca00078e00ffULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff437819ULL, 0x000fce0000011443ULL,
0x00000040006b7306ULL, 0x0002b00000200c00ULL, 0x00000041006a7306ULL, 0x0007220000200c00ULL,
0x0001000042407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x00000018ff417819ULL, 0x008fe40000011415ULL,
0x000054106b3c7816ULL, 0x004fca000000003cULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054106a3d7816ULL, 0x010fce000000003dULL, 0x00000014004d7306ULL, 0x000ea20000200c00ULL,
0x0000541064157816ULL, 0x002fce000000003eULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004100427306ULL, 0x0002f00000200c00ULL, 0x0000004000487306ULL, 0x0209e20000200c00ULL,
0x0000541070417816ULL, 0x002fce0000000073ULL, 0x0000000f000f7306ULL, 0x000e620000200c00ULL,
0x0000541071407816ULL, 0x010fce0000000072ULL, 0x0000000500057306ULL, 0x000fe20000200c00ULL,
0x000000404430723cULL, 0x040b6e0000001830ULL, 0x00000043004a7306ULL, 0x000f220000200c00ULL,
0x000100003f417824ULL, 0x020fe400078e00ffULL, 0x0000003c443c723cULL, 0x000b62000000182cULL,
0x0000010037407824ULL, 0x000fc400078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000001200127306ULL, 0x000e620000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x000054104c2c7816ULL, 0x024fe4000000004dULL,
0x000054104e2d7816ULL, 0x008fe40000000042ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005800587306ULL, 0x000fe80000200c00ULL, 0x0000002c442c723cULL, 0x000b680000001828ULL,
0x0000004100417306ULL, 0x000ea60000200c00ULL, 0x00010000362a7824ULL, 0x020fe200078e00ffULL,
0x0000541048287816ULL, 0x002fc4000000000fULL, 0x000054104a297816ULL, 0x010fe40000000005ULL,
0x00000018ff057819ULL, 0x000fe2000001142aULL, 0x0000002200227306ULL, 0x000e680000200c00ULL,
0x000000284444723cULL, 0x000b680000001824ULL, 0x0000005c005c7306ULL, 0x000ee60000200c00ULL,
0x000054106f247816ULL, 0x020fc40000000012ULL, 0x0000541041257816ULL, 0x004fc60000000058ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541022297816ULL, 0x002fc60000000034ULL,
0x000000243854723cULL, 0x000b680000001854ULL, 0x0000001300137306ULL, 0x000fe60000200c00ULL,
0x0000541078247816ULL, 0x028fca000000005cULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541013287816ULL, 0x002fce0000000023ULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541077257816ULL, 0x004fe2000000005bULL, 0x000000283828723cULL, 0x040b6c0000001830ULL,
0x0000003500357306ULL, 0x000fe40000200c00ULL, 0x000000243824723cULL, 0x000b6c000000183cULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x000054105a347816ULL, 0x002fce0000000059ULL,
0x0000004000367306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541065147816ULL, 0x004fce0000000066ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x002fe20000000036ULL, 0x000000143814723cULL, 0x040b6c0000001850ULL,
0x0000000500057306ULL, 0x000e640000200c00ULL, 0x00000034382c723cULL, 0x000b6c000000182cULL,
0x0000003700127306ULL, 0x000ea20000200c00ULL, 0x00005410055c7816ULL, 0x002fc4000000005eULL,
0x000176987a057811ULL, 0x000fe400078e18ffULL, 0x00005410125d7816ULL, 0x004fce000000005dULL,
0x0000005c3838723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000b307f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0f7224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x000004000b057984ULL, 0x008ee40000000800ULL, 0x8000000005ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002212227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e13ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011423ULL, 0x0000002205057211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x0000000205057819ULL, 0x000fc80000001222ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000b057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010c127810ULL, 0x000fc80007ffe0ffULL,
0x000000751200720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020c127810ULL, 0x000fe40007ffe0ffULL, 0x000001000a0f7810ULL, 0x000fe40007ffe0ffULL,
0x000000751200720cULL, 0x000fc60003f06070ULL, 0x00006800760a7a24ULL, 0x000fd400078e020fULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x0000000f68057217ULL, 0x000fe20007800000ULL,
0x0000001074227824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fc60000011603ULL,
0x0000000105057824ULL, 0x000fe200078e0a0fULL, 0x0000000412237810ULL, 0x000fe20007ffe0ffULL,
0x00000001220f7824ULL, 0x000fe200078e0212ULL, 0x0000000c12307810ULL, 0x000fe40007ffe0ffULL,
0x0000000522057217ULL, 0x000fe20007800000ULL, 0x000000010f137824ULL, 0x040fe400078e0203ULL,
0x000000080f347824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fc400078e0a22ULL,
0x0000000122357824ULL, 0x000fe200078e0230ULL, 0xfffffff834347812ULL, 0x000fe400078ee213ULL,
0x0000000812137810ULL, 0x040fe20007ffe0ffULL, 0x0000000135327824ULL, 0x100fe200078e020aULL,
0x000000051200720cULL, 0x080fe20003f86070ULL, 0x000000010f127824ULL, 0x000fe200078e020aULL,
0x000000052300720cULL, 0x080fe20003f66070ULL, 0x0000000122237824ULL, 0x040fe200078e0223ULL,
0x000000051300720cULL, 0x080fe20003f46070ULL, 0x0000000122317824ULL, 0x000fe200078e0213ULL,
0x000000053000720cULL, 0x000fe20003f06070ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000123227824ULL, 0x040fe200078e020aULL, 0x0000005f12127212ULL, 0x000fe200078efcffULL,
0x00000001230f7824ULL, 0x040fe400078e0203ULL, 0x0000000823367824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007fbe0ffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x0000000131307824ULL, 0x040fe200078e020aULL,
0x0000005f22227212ULL, 0x000fe200078efcffULL, 0x0000000131057824ULL, 0x040fe200078e0203ULL,
0xfffffff836367812ULL, 0x000fe200078ee20fULL, 0x00000008313c7824ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fe20007fbe0ffULL, 0x0000008030307825ULL, 0x000fc600078e00ffULL,
0xfffffff83c0a7812ULL, 0x000fe200078ee205ULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000005f30307212ULL, 0x080fe400078efcffULL, 0x0000650023237a10ULL, 0x000fe20002ffe4ffULL,
0x0000000135057824ULL, 0x040fe200078e0203ULL, 0x0000005f32327212ULL, 0x000fe200078efcffULL,
0x00000008353c7824ULL, 0x000fe200078e00ffULL, 0x0000640030307a10ULL, 0x000fe20007fbe0ffULL,
0x00000010360f7824ULL, 0x100fe200078e0261ULL, 0x0000640032327a10ULL, 0x000fe20007fde0ffULL,
0x000000100a357824ULL, 0x000fe200078e0261ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x0000001034057824ULL, 0x000fe200078e0261ULL, 0x0000650031317a10ULL, 0x000fc40002ffe4ffULL,
0x0000650033337a10ULL, 0x000fe200037fe4ffULL, 0x000000103c377824ULL, 0x000fe200078e0261ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012057faeULL, 0x0005e8000e101c46ULL,
0x00000000220f7faeULL, 0x0005e8000d901c46ULL, 0x0000000030357faeULL, 0x0005e8000d101c46ULL,
0x0000000032377faeULL, 0x0005e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001074127824ULL, 0x000fca00078e00ffULL, 0x0000001203057211ULL, 0x000fc800078fe8ffULL,
0x0000000405327810ULL, 0x040fe20007ffe0ffULL, 0x00000001050f7824ULL, 0x140fe200078e0203ULL,
0x0000000805227810ULL, 0x040fe20007ffe0ffULL, 0x0000000805347824ULL, 0x000fe400078e00ffULL,
0x0000000132127824ULL, 0x040fe400078e0203ULL, 0x0000000832237824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee20fULL, 0x0000000122137824ULL, 0x040fe400078e0203ULL,
0x00000008223c7824ULL, 0x000fe200078e00ffULL, 0xfffffff823367812ULL, 0x000fe200078ee212ULL,
0x0000000105127824ULL, 0x140fe200078e020aULL, 0x0000000c05057810ULL, 0x000fe20007ffe0ffULL,
0x0000000132327824ULL, 0x000fe200078e020aULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000122227824ULL, 0x100fe200078e020aULL,
0x0000005f12127212ULL, 0x000fe200078efcffULL, 0x0000000105307824ULL, 0x000fe400078e020aULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fc60007f1e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000005f32327212ULL, 0x080fe400078efcffULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000005f22227212ULL, 0x080fe400078efcffULL, 0x0000640032327a10ULL, 0x000fe20007f5e0ffULL,
0x00000001050a7824ULL, 0x040fe200078e0203ULL, 0x0000005f30307212ULL, 0x000fe200078efcffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fe20007f1e0ffULL,
0x00000010360f7824ULL, 0x100fe200078e0261ULL, 0x0000640030307a10ULL, 0x000fe20007f7e0ffULL,
0x000000103c357824ULL, 0x100fe200078e0261ULL, 0xfffffff8050a7812ULL, 0x000fe200078ee20aULL,
0x0000001034057824ULL, 0x000fe200078e0261ULL, 0x0000650033337a10ULL, 0x000fc400017fe4ffULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000000100a377824ULL, 0x000fe200078e0261ULL,
0x0000650031317a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012057faeULL, 0x0005e8000b901c46ULL, 0x00000000320f7faeULL, 0x0005e8000b901c46ULL,
0x0000000022357faeULL, 0x0005e8000b901c46ULL, 0x0000000030377faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000106e057824ULL, 0x000fe200078e00ffULL,
0x000000080d0a7812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x0000001005057812ULL, 0x000fca00078ee2ffULL, 0x000000207a057824ULL, 0x000fc800078e0205ULL,
0x000000010a0a7824ULL, 0x000fe200078e0205ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff127f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017668000a307f8cULL, 0x000662000c80043fULL,
0x000000ffff057224ULL, 0x004fc600078e0013ULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x01766c000a0f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e13ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011423ULL,
0x000000220f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x000000020f0f7819ULL, 0x000fc80000001222ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c000a0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001807a0a7811ULL, 0x008fc800078e38ffULL, 0x0000000a7c0a7210ULL, 0x000fca0007ffe05fULL,
0x017000000a0f7984ULL, 0x000e680000000800ULL, 0x017200000a227984ULL, 0x0004e20000000800ULL,
0x000000000f00720bULL, 0x002fe20003f1d000ULL, 0x0000a9327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13237812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fd200078e0000ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000037a137810ULL, 0x000fe40007ffe0ffULL, 0x000000000f00720bULL, 0x000fe40003f54000ULL,
0x000000021300720cULL, 0x000fe20003f05270ULL, 0x0000a8e27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400010e0100ULL, 0x00000080025f8824ULL, 0x000fe200078e025fULL,
0x000000000f127209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100a137816ULL, 0x000fe200000000ffULL, 0x000000017c5f8824ULL, 0x000fca00078e025fULL,
0x017400125f008388ULL, 0x0003e20000000800ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000012007221ULL, 0x002fe20000010100ULL,
0x000000ff0aff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b00007820ULL, 0x000fcc0000410000ULL, 0x0000000000007308ULL, 0x000e640000000800ULL,
0x0000000011117220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011603ULL, 0x0000a8227f007947ULL, 0x000fea000b800000ULL,
0x00001f1300137589ULL, 0x0002a400000e0000ULL, 0x0000001328287220ULL, 0x084fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x000fc40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x080fe40000410000ULL, 0x0000001338387220ULL, 0x080fe40000410000ULL,
0x0000001339397220ULL, 0x080fe40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x000fc40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x080fe40000410000ULL, 0x0000001314147220ULL, 0x080fe40000410000ULL,
0x0000001315157220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803137811ULL, 0x000fe200078ff0ffULL, 0x0000a7227f007947ULL, 0x000fea000b800000ULL,
0x00001f1300137589ULL, 0x00046400000e0000ULL, 0x000000132a2a7220ULL, 0x086fe40000410000ULL,
0x000000132b2b7220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x000fc40000410000ULL, 0x000000133a3a7220ULL, 0x080fe40000410000ULL,
0x000000133b3b7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x000fc40000410000ULL, 0x0000001316167220ULL, 0x080fe40000410000ULL,
0x0000001317177220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x080fe40000410000ULL,
0x0000001357577220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff23ff7812ULL, 0x000fe2000780600aULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000f120f0221ULL, 0x000fe20000010100ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00080308ULL, 0x000e640000000800ULL,
0x0000000822220220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001122117221ULL, 0x008fc40000010000ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0xfffffff00d137812ULL, 0x000fe200078ec0ffULL, 0x0000000402007824ULL, 0x000fc800078e00ffULL,
0x0176b400130f7984ULL, 0x000e620000000800ULL, 0x0000000400007812ULL, 0x000fc800078ec0ffULL,
0x0000000200007812ULL, 0x000fe400078efcffULL, 0x800000000fff7812ULL, 0x002fe20007804821ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003022307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e23ULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011431ULL, 0x000000300f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x000000020f0f7819ULL, 0x000fc80000001230ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176b400130f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100a0a7816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011603ULL,
0x00005410060a7816ULL, 0x000fe20000000006ULL, 0x0000a2c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0a077589ULL, 0x0002a400000e0000ULL, 0x000000080f137810ULL, 0x000fe20007ffe0ffULL,
0x0000a3127f007947ULL, 0x000fea000b800000ULL, 0x00001f130a067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e000aULL, 0x0000a2b000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000a8a000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e000aULL,
0x0000a32000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000a83000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007030a7812ULL, 0x04afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000803357812ULL, 0x000fe400078ec0ffULL,
0x000000080a0f7812ULL, 0x000fe400078ef803ULL, 0x000000037a467810ULL, 0x000fc60007ffe0ffULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fca00078ee210ULL,
0x000000807a347824ULL, 0x000fca00078e020fULL, 0x0001280034347811ULL, 0x000fc400078e20ffULL,
0x000000006030783bULL, 0x000e620000004200ULL, 0x0000100061137810ULL, 0x004fca0007ffe0ffULL,
0x000000100e207824ULL, 0x000fcc00078e0213ULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x00000018ff5f7819ULL, 0x002fe20000011432ULL, 0x00000100320e7824ULL, 0x040fe200078e00ffULL,
0x0000888032437816ULL, 0x040fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011431ULL, 0x0000010031107824ULL, 0x040fe200078e00ffULL,
0x00008880314a7816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x00000100300f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011430ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x0000888030507816ULL, 0x040fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x00000018ff5e7819ULL, 0x000fe20000011433ULL, 0x0000003200677306ULL, 0x0003e20000200c00ULL,
0x0000888033417816ULL, 0x000fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff0e7819ULL, 0x000fc4000001140eULL, 0x00000018ff5b7819ULL, 0x004fe20000011420ULL,
0x00000031006b7306ULL, 0x0005e20000200c00ULL, 0x0000000a35327212ULL, 0x002fe200078efcffULL,
0x00000100210a7824ULL, 0x000fe200078e00ffULL, 0x0000000003357211ULL, 0x000fe400078fe0ffULL,
0x0000888020627816ULL, 0x000fe400000000ffULL, 0x00000018ff637819ULL, 0x000fe2000001140aULL,
0x0000000132007824ULL, 0x040fe200078e0235ULL, 0x0000000f004c7306ULL, 0x0003e20000200c00ULL,
0x0000000832317824ULL, 0x004fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011421ULL,
0x00000001040a7824ULL, 0x040fe200078e0235ULL, 0x0000888021607816ULL, 0x000fe200000000ffULL,
0x0000000804357824ULL, 0x000fe200078e00ffULL, 0xfffffff831007812ULL, 0x000fe200078ee200ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000030006c7306ULL, 0x0005e20000200c00ULL,
0x00000100330f7824ULL, 0x002fe200078e00ffULL, 0xfffffff8350a7812ULL, 0x000fe200078ee20aULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x0000001000007824ULL, 0x000fe200078e0279ULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000010022047824ULL, 0x000fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000000e00407306ULL, 0x0007e20000200c00ULL, 0x00000018ff307819ULL, 0x004fe20000011422ULL,
0x000000100a0a7824ULL, 0x000fe200078e0213ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000888022537816ULL, 0x000fe200000000ffULL,
0x0000000f00427306ULL, 0x000fe20000200c00ULL, 0x00000100200e7824ULL, 0x048fe200078e00ffULL,
0x0000888023587816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x000000000a3c783bULL, 0x000ea20000004200ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000003300667306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff047819ULL, 0x000fc60000011404ULL, 0x00000030000f7306ULL, 0x0007f00000200c00ULL,
0x00000020005d7306ULL, 0x000fe20000200c00ULL, 0x000000000030783bULL, 0x0087220000004200ULL,
0x0000000734348232ULL, 0x002fc40000000000ULL, 0x0000000736368232ULL, 0x000fe40000000000ULL,
0x0000000635358232ULL, 0x080fe40000000000ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x0000010023007824ULL, 0x008fe200078e00ffULL, 0x0000000637378232ULL, 0x000fc80000000000ULL,
0x00000018ff007819ULL, 0x000fe40000011400ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff0a7819ULL, 0x004fce000001143cULL, 0x00000010006d7306ULL, 0x0004f00000200c00ULL,
0x00000021005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff107819ULL, 0x004fe20000011423ULL,
0x0001000023237824ULL, 0x000fca00078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x00000022006a7306ULL, 0x0005e20000200c00ULL, 0x0000010030207824ULL, 0x050fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011430ULL, 0x0000010031217824ULL, 0x002fe200078e00ffULL,
0x00008880304f7816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000080046227824ULL, 0x004fe200078e0209ULL, 0x00000020004d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000010033097824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc40000011431ULL, 0x00008880314e7816ULL, 0x040fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011432ULL,
0x0000003000657306ULL, 0x0005e20000200c00ULL, 0x0000010032207824ULL, 0x042fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011433ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000888032457816ULL, 0x040fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x0000002100517306ULL, 0x0007e20000200c00ULL, 0x00000018ff307819ULL, 0x004fc40000011420ULL,
0x0000541050207816ULL, 0x000fe4000000004cULL, 0x00008880334c7816ULL, 0x040fe200000000ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000002300697306ULL, 0x0003e20000200c00ULL, 0x000054104a217816ULL, 0x008fe4000000006dULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff337819ULL, 0x000fc60000011433ULL,
0x000000203428723cULL, 0x000be20000001828ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x011000002220783bULL, 0x022e6e0000000200ULL, 0x0000004300437306ULL, 0x000eb00000200c00ULL,
0x0000004100417306ULL, 0x000ef00000200c00ULL, 0x0000005f005f7306ULL, 0x000f220000200c00ULL,
0x0000541043407816ULL, 0x004fce0000000040ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541041417816ULL, 0x008fce0000000042ULL, 0x0000003100647306ULL, 0x0007e20000200c00ULL,
0x000000403440723cULL, 0x000be2000000182cULL, 0x0000000720208232ULL, 0x082fe40000000000ULL,
0x0000000722228232ULL, 0x000fe40000000000ULL, 0x0000000621218232ULL, 0x080fe40000000000ULL,
0x0000003000467306ULL, 0x0003e20000200c00ULL, 0x000054106b317816ULL, 0x008fe2000000004bULL,
0x0000000623238232ULL, 0x000fe20000000000ULL, 0x00005410672c7816ULL, 0x030fc4000000005fULL,
0x00005410662d7816ULL, 0x004fe4000000005eULL, 0x000088803d2e7816ULL, 0x000fe200000000ffULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000054106c307816ULL, 0x002fe40000000049ULL,
0x000088803c6c7816ULL, 0x000fe200000000ffULL, 0x0000002c3438723cULL, 0x000be20000001838ULL,
0x000000ffff5e7224ULL, 0x000fc600078e002eULL, 0x0000005a005a7306ULL, 0x000e660000200c00ULL,
0x000001003d2c7824ULL, 0x020fe200078e00ffULL, 0x000000303424723cULL, 0x000b680000001824ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe4000001142cULL,
0x000001003c317824ULL, 0x020fe200078e00ffULL, 0x000054105d2c7816ULL, 0x004fe2000000005bULL,
0x000000ffff307224ULL, 0x000fc400078e006cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000054105c2d7816ULL, 0x002fe4000000005aULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff3c7819ULL, 0x000fc6000001143cULL,
0x0000006200627306ULL, 0x000fe80000200c00ULL, 0x0000002c202c723cULL, 0x000be80000001824ULL,
0x0000000e00617306ULL, 0x0003e60000200c00ULL, 0x000054104f247816ULL, 0x028fc4000000004dULL,
0x000054104e257816ULL, 0x004fe40000000051ULL, 0x000088803e277816ULL, 0x000fe200000000ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00000018ff0e7819ULL, 0x002fe2000001143dULL,
0x000100003d3d7824ULL, 0x000fe400078e00ffULL, 0x00000024341c723cULL, 0x000b66000000181cULL,
0x00000018ff267819ULL, 0x000fe2000001143dULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000088803f3d7816ULL, 0x000fce00000000ffULL, 0x0000004700477306ULL, 0x000e700000200c00ULL,
0x0000004800487306ULL, 0x000eb00000200c00ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x0000541065247816ULL, 0x022fce0000000047ULL, 0x0000000400527306ULL, 0x0003e20000200c00ULL,
0x0000541064257816ULL, 0x004fce0000000048ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000000243418723cULL, 0x000b620000001818ULL, 0x00000018ff047819ULL, 0x002fcc000001143fULL,
0x0000000000597306ULL, 0x0003e20000200c00ULL, 0x000001003f257824ULL, 0x060fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fe400078e003dULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000000900507306ULL, 0x000fe20000200c00ULL,
0x00000018ff007819ULL, 0x002fce000001143eULL, 0x0000003000097306ULL, 0x0003f00000200c00ULL,
0x00000031004b7306ULL, 0x0005e20000200c00ULL, 0x0000541062307816ULL, 0x002fce0000000061ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x0000541060317816ULL, 0x004fce0000000063ULL,
0x0000004500457306ULL, 0x000eb00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x00005410693d7816ULL, 0x002fce0000000010ULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541045467816ULL, 0x004fce0000000046ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x000054104c477816ULL, 0x008fce0000000050ULL, 0x00000032004a7306ULL, 0x000e620000200c00ULL,
0x000000463414723cULL, 0x000f6e0000001814ULL, 0x0000003300497306ULL, 0x0004f00000200c00ULL,
0x0000003c00607306ULL, 0x0009e20000200c00ULL, 0x000000302030723cULL, 0x004be20000001828ULL,
0x000054104a487816ULL, 0x002fcc0000000013ULL, 0x0000541053287816ULL, 0x020fe20000000052ULL,
0x000001003e3c7824ULL, 0x010fe200078e00ffULL, 0x0000541058297816ULL, 0x000fe20000000059ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000541049497816ULL, 0x008fe40000000044ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000282028723cULL, 0x000be20000001840ULL, 0x00000018ff137819ULL, 0x000fe2000001143eULL,
0x0000005f005f7306ULL, 0x000e6a0000200c00ULL, 0x00000018ff417819ULL, 0x020fe2000001143fULL,
0x000000483434723cULL, 0x000f640000001854ULL, 0x0000003c00407306ULL, 0x0005f00000200c00ULL,
0x0000000a000a7306ULL, 0x000ee20000200c00ULL, 0x000054106a3c7816ULL, 0x004fce000000000fULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x0000003c203c723cULL, 0x000b6e0000001838ULL,
0x0000002600267306ULL, 0x000ea20000200c00ULL, 0x0000541009387816ULL, 0x020fe4000000004bULL,
0x000054105e397816ULL, 0x002fca000000005fULL, 0x0000002700277306ULL, 0x000e640000200c00ULL,
0x000000382038723cULL, 0x000b6c000000181cULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00005410601c7816ULL, 0x028fe4000000000aULL, 0x00005410261d7816ULL, 0x004fca000000000eULL,
0x0000002500257306ULL, 0x000ea40000200c00ULL, 0x0000001c201c723cULL, 0x000b6c0000001818ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541027187816ULL, 0x022fce0000000040ULL,
0x0000000400047306ULL, 0x000fe20000200c00ULL, 0x0000541024197816ULL, 0x004fce0000000025ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x000000182018723cULL, 0x000b6e0000001814ULL,
0x00000041000f7306ULL, 0x000ea20000200c00ULL, 0x00005410130e7816ULL, 0x002fe40000000000ULL,
0x000054100f0f7816ULL, 0x004fce0000000004ULL, 0x0000000e2020723cULL, 0x000b620000001834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000b0a7f8cULL, 0x000e62000c80043fULL,
0x000000010c0c7810ULL, 0x000fe40007ffe0ffULL, 0x000176a07a047811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000004ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff007224ULL, 0x002fe200078e000bULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff640000007947ULL, 0x000fea000383ffffULL, 0x000000ff7500720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000011007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b44000047802ULL, 0x006fc40000000f00ULL, 0x0000955000007944ULL, 0x020fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x008fc80000000011ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x006e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x018fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003000307220ULL, 0x042fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x000fc40000410000ULL,
0x0000002800287220ULL, 0x040fe40000410000ULL, 0x0000002900297220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x040fe40000410000ULL, 0x0000003900397220ULL, 0x000fc40000410000ULL,
0x0000001c001c7220ULL, 0x040fe40000410000ULL, 0x0000001d001d7220ULL, 0x040fe40000410000ULL,
0x0000001800187220ULL, 0x060fe40000410000ULL, 0x0000001900197220ULL, 0x040fe40000410000ULL,
0x0000002000207220ULL, 0x040fe40000410000ULL, 0x0000002100217220ULL, 0x000fc40000410000ULL,
0x0000003204327220ULL, 0x044fe40000410000ULL, 0x0000003304337220ULL, 0x040fe40000410000ULL,
0x0000002e042e7220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002b042b7220ULL, 0x000fc40000410000ULL,
0x0000003e043e7220ULL, 0x040fe40000410000ULL, 0x0000003f043f7220ULL, 0x040fe40000410000ULL,
0x0000003a043a7220ULL, 0x040fe40000410000ULL, 0x0000003b043b7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x000fc40000410000ULL,
0x0000001a041a7220ULL, 0x040fe40000410000ULL, 0x0000001b041b7220ULL, 0x040fe40000410000ULL,
0x0000002204227220ULL, 0x040fe40000410000ULL, 0x0000002304237220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x000000206e0b7824ULL, 0x000fe200078e00ffULL, 0x000000181918723eULL, 0x020fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fc400000000ffULL,
0x0000003e3f15723eULL, 0x000fe400000000ffULL, 0x0000003a3b3a723eULL, 0x000fe400000000ffULL,
0x0000001e1f1d723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x00000022230d723eULL, 0x000fe400000000ffULL, 0x000054102a147816ULL, 0x000fc40000000015ULL,
0x00000002ff057819ULL, 0x00afe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x004fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000100074037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x000008006e057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000076322a157816ULL, 0x000fe20000000015ULL, 0x0000000107087824ULL, 0x040fe200078e0208ULL,
0x0000541002107816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000282902723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x000000383905723eULL, 0x000fe200000000ffULL, 0x0000000107077824ULL, 0x000fe200078e020cULL,
0x00000020210c723eULL, 0x000fc400000000ffULL, 0x000000ff6e00720cULL, 0x000fe40003f05270ULL,
0x0000541002107816ULL, 0x142fe40000000004ULL, 0x0000763202117816ULL, 0x000fe40000000004ULL,
0x000000323302723eULL, 0x000fe400000000ffULL, 0x0000002e2f04723eULL, 0x000fe200000000ffULL,
0x0000001008007388ULL, 0x0003e40000000a00ULL, 0x0000541005107816ULL, 0x002fc4000000001cULL,
0x0000763205117816ULL, 0x000fe4000000001cULL, 0x000054103a1c7816ULL, 0x140fe4000000001dULL,
0x000076323a1d7816ULL, 0x000fe2000000001dULL, 0x000000100a007388ULL, 0x0003e20000000a00ULL,
0x000076321a057816ULL, 0x000fe4000000000dULL, 0x0000541018107816ULL, 0x142fe4000000000cULL,
0x0000763218117816ULL, 0x000fca000000000cULL, 0x0000001007007388ULL, 0x0003e40000000a00ULL,
0x0000541002107816ULL, 0x142fe40000000004ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x000000010b027824ULL, 0x000fe200078e0200ULL, 0x000054101a047816ULL, 0x000fc6000000000dULL,
0x000000100e007388ULL, 0x000fe20000000a00ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x0004001408007388ULL, 0x000fe80000000a00ULL, 0x0004001c0a007388ULL, 0x000fe80000000a00ULL,
0x0004000407007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x0008000002107984ULL, 0x000ee80000000c00ULL, 0x000c000002187984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c02007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000011f7983ULL, 0x000ea20000100800ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000001f0600720cULL, 0x004fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000400011e7983ULL, 0x000ea20000100800ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x000000017b027824ULL, 0x000fe200078e0206ULL, 0x00005a00ff0f7a12ULL, 0x000fcc00078e33ffULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x008fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x00000007050d7227ULL, 0x000fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0200ULL,
0x000000020d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805047812ULL, 0x000fca00078ef800ULL,
0x0000001004067824ULL, 0x000fe400078e0203ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002e20000000c00ULL, 0x000000070f047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e027dULL,
0x00005a0007027a24ULL, 0x000fe200078e0202ULL, 0x0000000700077812ULL, 0x000fc600078ec0ffULL,
0x00005a0005027a24ULL, 0x000fe400078e0202ULL, 0x0000000874077824ULL, 0x000fc600078e0207ULL,
0x000000021e057210ULL, 0x004fe40007f3e0ffULL, 0x0000002000027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff067819ULL, 0x002fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x0000001f0600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b047824ULL, 0x102fe400078e0206ULL, 0x0000000102067824ULL, 0x000fe400078e0206ULL,
0x000000040d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805067812ULL, 0x000fca00078ef802ULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x0000000107072810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x000000070f0c7207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a0cULL,
0x000059000c057a24ULL, 0x000fe200078e027dULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x00000003ff027819ULL, 0x000fe2000001160cULL, 0x00005a0005047a24ULL, 0x000fe400078e0204ULL,
0x0000000874077824ULL, 0x000fc600078e0207ULL, 0x000000041e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x0000001f0200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b047824ULL, 0x102fe200078e0202ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000010c027824ULL, 0x000fe400078e0202ULL,
0x000000040d067227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a06ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef80cULL, 0x0000001002027824ULL, 0x000fe400078e0203ULL,
0x0000000106062810ULL, 0x000fc60007ffe0ffULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x000000060f067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e027dULL, 0x00000003ff027819ULL, 0x002fe20000011600ULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x000000070c077812ULL, 0x000fc600078ec0ffULL,
0x00005a0005047a24ULL, 0x000fe400078e0204ULL, 0x0000000874077824ULL, 0x000fe400078e0207ULL,
0x000000017b7b7824ULL, 0x000fe200078e0202ULL, 0x000000041e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4406ULL, 0x0000001f0200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007b0d067227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a06ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x00005a0004047a24ULL, 0x000fc600078e027bULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805027812ULL, 0x000fe400078ef800ULL,
0x0000000700057812ULL, 0x000fca00078ec0ffULL, 0x0000000874057824ULL, 0x000fc800078e0205ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe20003f46070ULL, 0x0000001002047824ULL, 0x000fca00078e0203ULL,
0x0000000004087984ULL, 0x000e6e0000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x000000060f067207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a06ULL,
0x0000590006067a24ULL, 0x000fe400078e027dULL, 0x00005a00027b7a24ULL, 0x000fc800078e027bULL,
0x00005a00067b7a24ULL, 0x000fca00078e027bULL, 0x0000007b1e7b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e007b027a11ULL, 0x000fc800078040ffULL,
0x00005f007b037a11ULL, 0x000fca00000f4406ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006c00ff047624ULL, 0x000fe400078e00ffULL, 0x00006d00ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604087981ULL, 0x002322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000001fff647424ULL, 0x000fe200078e00ffULL,
0x01760000ff047f8cULL, 0x002e62000c80043fULL, 0x00000002096c7824ULL, 0x000fe400078e00ffULL,
0x0000004002097824ULL, 0x000fe200078e00ffULL, 0x0000580064647a10ULL, 0x000fe20007ffe0ffULL,
0x000059006c6c7a24ULL, 0x000fc600078e027dULL, 0x00000005ff647819ULL, 0x000fe20000011664ULL,
0x000068006c0a7a24ULL, 0x000fe400078e0209ULL, 0x00000c7000000947ULL, 0x000fea0003800000ULL,
0x00000003ff207819ULL, 0x000fe40000011603ULL, 0x00000009680c7217ULL, 0x000fe40007800000ULL,
0x00000004200e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000820167810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0b7824ULL, 0x000fe200078e0a09ULL, 0x0000000c20187810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x100fe200078e0203ULL, 0x0000001420227810ULL, 0x000fe20007ffe0ffULL,
0x000000080e107824ULL, 0x040fe200078e00ffULL, 0x0000000b0e00720cULL, 0x080fe20003fa6070ULL,
0x00000001160f7824ULL, 0x000fe200078e0203ULL, 0x0000001820247810ULL, 0x000fe20007ffe0ffULL,
0x0000000816127824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee20dULL,
0x000000010a0c7824ULL, 0x000fe200078e0220ULL, 0x0000000b1800720cULL, 0x000fe20003f46070ULL,
0x000000010a0e7824ULL, 0x000fe200078e020eULL, 0xfffffff812257812ULL, 0x000fe200078ee20fULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001020127810ULL, 0x000fc40007ffe0ffULL,
0x0000001c20287810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1a7812ULL, 0x100fe400078ef806ULL, 0x00000020202a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118107824ULL, 0x100fe200078e0203ULL, 0x000000700e147812ULL, 0x000fe200078ef806ULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x00000001120c7824ULL, 0x000fe200078e0203ULL, 0x0000640014147a10ULL, 0x000fe20007f3e0ffULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee210ULL,
0x000000010a0e7824ULL, 0x040fe200078e0218ULL, 0x000065000d1b7a10ULL, 0x000fe200007fe4ffULL,
0x000000010a107824ULL, 0x000fe200078e0212ULL, 0x000065000f157a10ULL, 0x000fe20000ffe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b1200720cULL, 0x000fc40003f06070ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000010a127824ULL, 0x000fe200078e0222ULL,
0x000000700e187812ULL, 0x000fe200078ef806ULL, 0x000000010a0c7824ULL, 0x000fe200078e0216ULL,
0x0000000b1600720cULL, 0x000fe20003f26070ULL, 0x000000010a1c7824ULL, 0x000fe200078e0224ULL,
0x0000640018187a10ULL, 0x000fe20007f9e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00001000021e7811ULL, 0x000fe400078e70ffULL, 0x000065000f197a10ULL, 0x000fe200027fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000070120e7812ULL, 0x000fc400078ef806ULL,
0x00000024202c7810ULL, 0x000fe20007ffe0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000700c167812ULL, 0x100fe400078ef806ULL, 0x000064000e0e7a10ULL, 0x000fe20007f9e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000701c0c7812ULL, 0x000fe400078ef806ULL,
0x0000640016167a10ULL, 0x000fe20007f7e0ffULL, 0x00000001201c7824ULL, 0x100fe200078e0203ULL,
0x00006500130f7a10ULL, 0x000fe200027fe4ffULL, 0x000000010a127824ULL, 0x000fe200078e0228ULL,
0x0000007010107812ULL, 0x000fe200078ef806ULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0x000000071c267812ULL, 0x000fe200078ec0ffULL, 0x00000001221c7824ULL, 0x000fe200078e0203ULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b2000720cULL, 0x000fc40003f86070ULL, 0x000065000d177a10ULL, 0x000fe20001ffe4ffULL,
0x00000008242d7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8261f7812ULL, 0x100fe200078ef803ULL,
0x0000000124267824ULL, 0x000fe200078e0203ULL, 0x0000640010107a10ULL, 0x000fe20007f7e0ffULL,
0x0000001021217824ULL, 0x000fe200078e021eULL, 0x000065001d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000010a1d7824ULL, 0x000fe200078e022aULL, 0x0000650011117a10ULL, 0x000fe20001ffe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021eULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee21cULL,
0x000000801d1c7825ULL, 0x000fe200078e00ffULL, 0x0000000b2200720cULL, 0x000fc40003f66070ULL,
0x0000007012127812ULL, 0x000fe200078ef806ULL, 0x000000010a227824ULL, 0x000fe200078e022cULL,
0x00000028202e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1f7faeULL, 0x0005e2000e101c46ULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000b2400720cULL, 0x080fe20003f86070ULL,
0x0000000014217faeULL, 0x0007e2000e901c46ULL, 0x000000701c1c7812ULL, 0x000fe200078ef806ULL,
0x0000001025257824ULL, 0x000fe200078e021eULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL,
0x000000010a247824ULL, 0x000fe200078e022eULL, 0x0000002c20267810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x000fe200078e021eULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x00000001281f7824ULL, 0x004fe200078e0203ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x00000080241a7825ULL, 0x000fe200078e00ffULL, 0x0000000b2800720cULL, 0x080fe20003fa6070ULL,
0x0000000016257faeULL, 0x0005e2000c901c46ULL, 0x0000007022227812ULL, 0x000fe200078ef806ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001029297824ULL, 0x000fe200078e021eULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x000000010a147824ULL, 0x008fe200078e0226ULL, 0x0000000018277faeULL, 0x0007e2000d101c46ULL,
0x000000102b2b7824ULL, 0x000fe200078e021eULL, 0x000000701a1a7812ULL, 0x000fe200078ef806ULL,
0x000000102d2d7824ULL, 0x000fe200078e021eULL, 0xfffffff8281f7812ULL, 0x000fe200078ee21fULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003020167810ULL, 0x004fe20007ffe0ffULL,
0x0000000010297faeULL, 0x0005e2000c101c46ULL, 0x0000000b2a00720cULL, 0x0c0fe20003f26070ULL,
0x000000012a217824ULL, 0x140fe200078e0203ULL, 0x0000650023237a10ULL, 0x000fe200037fe4ffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x000000000e2b7faeULL, 0x0003e2000d901c46ULL,
0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x100fe200078e0203ULL,
0x0000007014147812ULL, 0x000fe200078ef806ULL, 0x000000082c2f7824ULL, 0x040fe200078e00ffULL,
0x000000000c2d7faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x0000000b2c00720cULL, 0x080fe20003f46070ULL, 0x000000010a107824ULL, 0x004fe200078e0216ULL,
0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL, 0x000000012e117824ULL, 0x000fe200078e0203ULL,
0xfffffff82a217812ULL, 0x000fe200078ee221ULL, 0x00000000121f7faeULL, 0x0005e2000e901c46ULL,
0x0000640014147a10ULL, 0x000fe20007fde0ffULL, 0x0000000816197824ULL, 0x008fe200078e00ffULL,
0xfffffff82f177812ULL, 0x000fe200078ee224ULL, 0x0000001021217824ULL, 0x000fe200078e021eULL,
0x0000003420187810ULL, 0x000fe20007ffe0ffULL, 0x00000080100c7825ULL, 0x002fe200078e00ffULL,
0x0000000b2e00720cULL, 0x000fc40003fa6070ULL, 0x0000650015157a10ULL, 0x000fe200037fe4ffULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x000000700c107812ULL, 0x000fe200078ef806ULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x0000003820247810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0e7824ULL, 0x000fe200078e0218ULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x00000001160c7824ULL, 0x000fe200078e0203ULL, 0x0000003c20207810ULL, 0x000fe20007ffe0ffULL,
0x000000001c217faeULL, 0x0003e2000c901c46ULL, 0xfffffff82e137812ULL, 0x004fe200078ee211ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000065000d117a10ULL, 0x000fe200037fe4ffULL,
0x0000000022177faeULL, 0x0005e2000d101c46ULL, 0x0000000b2600720cULL, 0x080fe20003f86070ULL,
0x000000010a0d7824ULL, 0x000fe200078e0224ULL, 0x0000000b1600720cULL, 0x080fe20003f66070ULL,
0x000000010a0a7824ULL, 0x000fe200078e0220ULL, 0x0000000b1800720cULL, 0x0c0fe20003f46070ULL,
0x0000000118127824ULL, 0x100fe200078e0203ULL, 0x0000000b2400720cULL, 0x080fe20003f26070ULL,
0x00000008181d7824ULL, 0x002fe200078e00ffULL, 0x0000000b2000720cULL, 0x000fe20003f06070ULL,
0x00000001260b7824ULL, 0x040fe200078e0203ULL, 0xfffffff819197812ULL, 0x000fe200078ee20cULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fe200078ef806ULL,
0x000000800d0c7825ULL, 0x000fc600078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000124167824ULL, 0x000fe200078e0203ULL, 0xfffffff826177812ULL, 0x004fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x100fe400078ef806ULL,
0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x00000008241f7824ULL, 0x000fe200078e00ffULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000120187824ULL, 0x000fe200078e0203ULL,
0x000000700a067812ULL, 0x000fe200078ef806ULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0xfffffff81d037812ULL, 0x000fe200078ee212ULL, 0x0000001013137824ULL, 0x000fe200078e021eULL,
0xfffffff81f1d7812ULL, 0x000fe200078ee216ULL, 0x0000001017177824ULL, 0x000fe200078e021eULL,
0xfffffff8211f7812ULL, 0x000fe200078ee218ULL, 0x0000001019197824ULL, 0x100fe200078e021eULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x0000001003037824ULL, 0x100fe200078e021eULL,
0x00006400060a7a10ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021eULL,
0x000000001a137faeULL, 0x0003e2000e901c46ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x000065000b0b7a10ULL, 0x000fc400037fe4ffULL, 0x0000000014177faeULL, 0x0003e8000e101c46ULL,
0x0000000010197faeULL, 0x0003e8000d901c46ULL, 0x000000000e037faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000c030f7811ULL, 0x040fe400078fe8ffULL,
0x00000008030e7811ULL, 0x000fc400078fe8ffULL, 0x00000004030d7811ULL, 0x000fe200078fe8ffULL,
0x000000010f107824ULL, 0x100fe200078e0203ULL, 0x0000001403137811ULL, 0x000fe200078fe8ffULL,
0x000000080f1f7824ULL, 0x000fe200078e00ffULL, 0x0000001c03177811ULL, 0x040fe200078fe8ffULL,
0x000000010e0c7824ULL, 0x140fe200078e0203ULL, 0x0000001803157811ULL, 0x000fe200078fe8ffULL,
0x000000080e1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x000000010d0b7824ULL, 0x100fe200078e0203ULL, 0x0000001003107811ULL, 0x000fe200078fe8ffULL,
0x000000080d127824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x00000001130c7824ULL, 0x000fe200078e0203ULL, 0x00000024031b7811ULL, 0x000fe200078fe8ffULL,
0x0000000813257824ULL, 0x000fe200078e00ffULL, 0xfffffff812197812ULL, 0x000fe200078ee20bULL,
0x0000000117127824ULL, 0x100fe200078e0203ULL, 0x0000002c031e7811ULL, 0x000fe200078fe8ffULL,
0x0000000817297824ULL, 0x000fe200078e00ffULL, 0x0000002003187811ULL, 0x000fe200078fe8ffULL,
0x00000001100b7824ULL, 0x140fe200078e0203ULL, 0xfffffff825257812ULL, 0x000fe200078ee20cULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x00000028031c7811ULL, 0x000fe200078fe8ffULL,
0x0000000115117824ULL, 0x000fe200078e0203ULL, 0xfffffff829297812ULL, 0x000fe200078ee212ULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0xfffffff814237812ULL, 0x000fe200078ee20bULL,
0x000000011b0c7824ULL, 0x000fe200078e0203ULL, 0x00000034032a7811ULL, 0x000fe200078fe8ffULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0xfffffff816277812ULL, 0x000fe200078ee211ULL,
0x000000011e127824ULL, 0x140fe200078e0203ULL, 0x0000003c032f7811ULL, 0x000fe200078fe8ffULL,
0x000000081e2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff821247812ULL, 0x000fe200078ee20cULL,
0x00000001180b7824ULL, 0x140fe200078e0203ULL, 0x0000003003217811ULL, 0x000fe200078fe8ffULL,
0x0000000818147824ULL, 0x000fe200078e00ffULL, 0xfffffff82d287812ULL, 0x000fe200078ee212ULL,
0x000000011c117824ULL, 0x040fe200078e0203ULL, 0x00000003030c7211ULL, 0x040fe200078fe8ffULL,
0x000000081c267824ULL, 0x000fe200078e00ffULL, 0xfffffff8142b7812ULL, 0x000fe200078ee20bULL,
0x000000010a207824ULL, 0x040fe200078e0218ULL, 0x00000038032d7811ULL, 0x040fe200078fe8ffULL,
0x000000010a2e7824ULL, 0x040fe200078e021cULL, 0x0000000a030b7211ULL, 0x000fe200078fe8ffULL,
0x000000010a307824ULL, 0x000fe200078e021eULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x000000010a117824ULL, 0x000fe200078e020fULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000001210f7824ULL, 0x000fc400078e0203ULL, 0x0000000821327824ULL, 0x000fe400078e00ffULL,
0x000000010a0d7824ULL, 0x040fe400078e020dULL, 0x000000010a0e7824ULL, 0x040fe400078e020eULL,
0x000000010a127824ULL, 0x000fe200078e0210ULL, 0x0ffffff80c107812ULL, 0x000fe200078ef803ULL,
0x000000010a147824ULL, 0x040fe400078e0213ULL, 0x000000010a167824ULL, 0x000fc400078e0215ULL,
0x000000010a1a7824ULL, 0x040fe400078e0217ULL, 0x000000010a2c7824ULL, 0x040fe400078e021bULL,
0x000000010a227824ULL, 0x040fe400078e0221ULL, 0x000000010a1e7824ULL, 0x040fe400078e022aULL,
0x000000010a1c7824ULL, 0x040fe400078e022dULL, 0x000000010a187824ULL, 0x000fc400078e022fULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000012a137824ULL, 0x000fe200078e0203ULL,
0x000000700a0a7812ULL, 0x000fe200078ef806ULL, 0x000000082a347824ULL, 0x000fe200078e00ffULL,
0xfffffff8322a7812ULL, 0x000fe200078ee20fULL, 0x000000012d157824ULL, 0x100fe200078e0203ULL,
0x0000100002327811ULL, 0x000fe200078e70ffULL, 0x000000012f037824ULL, 0x040fe200078e0203ULL,
0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000082f0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff834137812ULL, 0x000fe200078ee213ULL, 0x000000082d367824ULL, 0x000fe200078e00ffULL,
0x000065000b0b7a10ULL, 0x000fe200007fe4ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff80c177812ULL, 0x000fc400078ee203ULL, 0xfffffff836157812ULL, 0x000fe200078ee215ULL,
0x0000001010037824ULL, 0x000fe200078e0232ULL, 0x000000700e0e7812ULL, 0x000fe200078ef806ULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000010153d7824ULL, 0x000fe200078e0232ULL, 0x0000007010107812ULL, 0x000fe200078ef806ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0005e2000b901c46ULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x00000010173f7824ULL, 0x000fe200078e0232ULL,
0x0000007014147812ULL, 0x000fe200078ef806ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fc400007fe4ffULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x100fe400078ef806ULL,
0x0000650015157a10ULL, 0x000fe200007fe4ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x100fe400078ef806ULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc400078ef806ULL,
0x0000640016167a10ULL, 0x000fe20007f5e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000702c367812ULL, 0x000fe400078ef806ULL, 0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL,
0x00000010133b7824ULL, 0x000fe200078e0232ULL, 0x000000702e387812ULL, 0x000fe200078ef806ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe40007f3e0ffULL,
0x0000650017177a10ULL, 0x000fe200017fe4ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000640036367a10ULL, 0x000fc40007f1e0ffULL, 0x0000007012127812ULL, 0x000fe200078ef806ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000640038387a10ULL, 0x000fe40007f5e0ffULL,
0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001019197824ULL, 0x000fe200078e0232ULL,
0x000065002d377a10ULL, 0x000fe200007fe4ffULL, 0x00000080222c7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe40007f3e0ffULL, 0x0000007030307812ULL, 0x000fe200078ef806ULL,
0x000000101d1d7824ULL, 0x100fe200078e0232ULL, 0x000065002f397a10ULL, 0x000fe200017fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0232ULL, 0x0000007020207812ULL, 0x000fe200078ef806ULL,
0x0000001023237824ULL, 0x100fe200078e0232ULL, 0x0000650013137a10ULL, 0x000fe20000ffe4ffULL,
0x0000001025257824ULL, 0x100fe200078e0232ULL, 0x0000640030307a10ULL, 0x000fe20007f1e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0232ULL, 0x0000640020207a10ULL, 0x000fe20007f3e0ffULL,
0x0000001029297824ULL, 0x000fe200078e0232ULL, 0x000000702c2c7812ULL, 0x000fe200078ef806ULL,
0x000000102b2b7824ULL, 0x100fe200078e0232ULL, 0x000000000c197faeULL, 0x0005e2000b901c46ULL,
0x0000001024247824ULL, 0x100fe200078e0232ULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x0000001026267824ULL, 0x100fe200078e0232ULL, 0x000000000e1d7faeULL, 0x0005e2000b901c46ULL,
0x0000001028287824ULL, 0x100fe200078e0232ULL, 0x0000650021217a10ULL, 0x000fe20000ffe4ffULL,
0x000000102a2a7824ULL, 0x000fe200078e0232ULL, 0x000064002c2c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000801e2e7825ULL, 0x000fe200078e00ffULL, 0x00000000101f7faeULL, 0x0005e4000b901c46ULL,
0x000065002d2d7a10ULL, 0x000fe200007fe4ffULL, 0x000000801c327825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x100fe200078ef806ULL, 0x0000000012237faeULL, 0x0005e4000b901c46ULL,
0x0000008018347825ULL, 0x000fe200078e00ffULL, 0x0000007032327812ULL, 0x000fe200078ef806ULL,
0x0000000014257faeULL, 0x0005e2000b901c46ULL, 0x000064002e2e7a10ULL, 0x000fc40007f3e0ffULL,
0x0000007034067812ULL, 0x000fe200078ef806ULL, 0x0000000016277faeULL, 0x0005e2000b901c46ULL,
0x0000640032327a10ULL, 0x000fe40007f5e0ffULL, 0x0000640006347a10ULL, 0x000fe20007f7e0ffULL,
0x000000001a297faeULL, 0x0005e2000b901c46ULL, 0x000065002f2f7a10ULL, 0x000fe40000ffe4ffULL,
0x0000650033337a10ULL, 0x000fe200017fe4ffULL, 0x00000000202b7faeULL, 0x0005e2000b901c46ULL,
0x0000650035357a10ULL, 0x000fc60001ffe4ffULL, 0x0000000036247faeULL, 0x0005e8000b901c46ULL,
0x0000000038267faeULL, 0x0005e8000b901c46ULL, 0x0000000030287faeULL, 0x0005e8000b901c46ULL,
0x000000002c2a7faeULL, 0x0005e8000b901c46ULL, 0x000000002e3b7faeULL, 0x0005e8000b901c46ULL,
0x00000000323d7faeULL, 0x0005e8000b901c46ULL, 0x00000000343f7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x006fc40000015200ULL,
0x01760400ff037984ULL, 0x000e620000000800ULL, 0x0000006407437224ULL, 0x000fc400078e02ffULL,
0x0000000168717824ULL, 0x000fe400078e0a00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620043427625ULL, 0x000fe200078e0042ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x000000060a067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0bULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe04067812ULL, 0x000fe400078ec0ffULL,
0x0000000f03047812ULL, 0x000fc600078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x00000010040a7824ULL, 0x040fe400078e00ffULL, 0x0000001004057824ULL, 0x000fe200078e00ffULL,
0x0000000f06037812ULL, 0x040fe400078ec0ffULL, 0x0000000106067810ULL, 0x000fe40007ffe0ffULL,
0x000000f00a037812ULL, 0x000fe400078ee203ULL, 0x0000000f06067812ULL, 0x000fc600078ec0ffULL,
0x0000000003107984ULL, 0x000e62000000cc00ULL, 0x000000f005067812ULL, 0x000fca00078ee206ULL,
0x00000000060c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001403007388ULL, 0x0003e8000000cc00ULL,
0x0000001006007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01760400ff037984ULL, 0x002e640000000800ULL,
0x8000000003ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010009727810ULL, 0x000fe20007ffe0ffULL,
0x0000000264647824ULL, 0x000fe200078e00ffULL, 0x0001768802737811ULL, 0x000fe200078e18ffULL,
0x3db504f308047820ULL, 0x010fe20000410000ULL, 0xffffffff005f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000000900627810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0001760802767811ULL, 0x000fc400078e28ffULL,
0x0000000260067810ULL, 0x040fe20007ffe0ffULL, 0x0000010060617824ULL, 0x000fe200078e0272ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000105637812ULL, 0x000fc400078e0cffULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x000068006c067a24ULL, 0x000fd800078e0261ULL,
0x00000ca000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff177819ULL, 0x002fe20000011603ULL,
0x00000002021c7824ULL, 0x000fe200078e0263ULL, 0x0000006168167217ULL, 0x000fe40007800000ULL,
0x0000000417097810ULL, 0x040fe40007ffe0ffULL, 0x00000008170d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116167824ULL, 0x000fe200078e0a61ULL, 0x0000000c170f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109077824ULL, 0x100fe200078e0203ULL, 0x0000001017117810ULL, 0x000fe20007ffe0ffULL,
0x0000000809087824ULL, 0x000fe200078e00ffULL, 0x00000018172b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x040fe200078e0206ULL, 0x000000160900720cULL, 0x080fe20003fa6070ULL,
0x000000010d217824ULL, 0x000fe200078e0203ULL, 0xfffffff808257812ULL, 0x000fe200078ee207ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000014171f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0c7824ULL, 0x000fe200078e00ffULL, 0x000000160f00720cULL, 0x000fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fc400078ec0ffULL,
0xfffffff80c217812ULL, 0x000fe200078ee221ULL, 0x000000010f0c7824ULL, 0x140fe200078e0203ULL,
0x000000070a147212ULL, 0x000fe200078efcffULL, 0x000000080f277824ULL, 0x000fe200078e00ffULL,
0x000010001c1c7811ULL, 0x000fe200078e68ffULL, 0x00000001111d7824ULL, 0x040fe200078e0203ULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x00000008110a7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x100fe200078e0206ULL,
0x000065000b157a10ULL, 0x000fe20000ffe4ffULL, 0x0000000117087824ULL, 0x100fe200078e0206ULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee21dULL, 0x000000010d0a7824ULL, 0x040fe200078e0206ULL,
0x000000160d00720cULL, 0x000fe20003f26070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002817337810ULL, 0x000fc40007ffe0ffULL, 0x0000001c172d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b1a7824ULL, 0x000fe200078e0206ULL, 0x000000070c127212ULL, 0x080fe200078efcffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000020172f7810ULL, 0x000fe40007ffe0ffULL,
0x0000640012127a10ULL, 0x000fe20007f9e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000708087212ULL, 0x080fe400078efcffULL, 0x000065000d137a10ULL, 0x000fe200027fe4ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000070a107212ULL, 0x000fc400078efcffULL,
0x0000640008087a10ULL, 0x000fe20007f1e0ffULL, 0x00000001110e7824ULL, 0x100fe200078e0206ULL,
0x000000071a0a7212ULL, 0x000fe200078efcffULL, 0x00000001171a7824ULL, 0x000fe200078e0203ULL,
0x0000640010107a10ULL, 0x000fe20007f7e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe40007f9e0ffULL, 0x0000650009097a10ULL, 0x000fe200007fe4ffULL,
0x000000011f187824ULL, 0x100fe200078e0206ULL, 0x000000161100720cULL, 0x000fe20003f06070ULL,
0x0000000133207824ULL, 0x000fe200078e0206ULL, 0x000065000b117a10ULL, 0x000fe20001ffe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000065001b0b7a10ULL, 0x000fc400027fe4ffULL,
0x000000071a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000011f1b7824ULL, 0x100fe200078e0203ULL,
0x000000161700720cULL, 0x000fe20003f86070ULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0x000000070e0e7212ULL, 0x080fe200078efcffULL, 0x000000012b227824ULL, 0x100fe200078e0203ULL,
0x0ffffff81a237812ULL, 0x000fe200078ef803ULL, 0x000000012f1a7824ULL, 0x000fe200078e0206ULL,
0x000064000e0e7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001021217824ULL, 0x100fe200078e021cULL,
0x00000007180c7212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x000fe200078e021cULL,
0x000065000f0f7a10ULL, 0x000fe20001ffe4ffULL, 0x000000012d187824ULL, 0x000fe200078e0206ULL,
0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008237faeULL, 0x0003e2000e101c46ULL,
0x0000002417317810ULL, 0x000fc40007ffe0ffULL, 0x00006500190d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffff81e297812ULL, 0x000fe400078ee21bULL,
0x000000162b00720cULL, 0x080fe20003f86070ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000718187212ULL, 0x080fe400078efcffULL, 0x000000161f00720cULL, 0x000fe20003f66070ULL,
0x0000001025237824ULL, 0x002fe200078e021cULL, 0x0000640018187a10ULL, 0x000fe20007fde0ffULL,
0x0000008020087825ULL, 0x000fe200078e00ffULL, 0x000000071a1a7212ULL, 0x000fc400078efcffULL,
0x0000000014237faeULL, 0x0003e2000e901c46ULL, 0x000000012d207824ULL, 0x100fe200078e0203ULL,
0x0000002c17357810ULL, 0x000fe20007ffe0ffULL, 0x000000082d257824ULL, 0x000fe200078e00ffULL,
0x0000650019197a10ULL, 0x000fe200037fe4ffULL, 0x00000001311e7824ULL, 0x000fe200078e0206ULL,
0x0000000010217faeULL, 0x0005e2000c901c46ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee220ULL, 0x000000012f207824ULL, 0x000fe200078e0203ULL,
0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee222ULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001027237824ULL, 0x002fe200078e021cULL, 0x000000071e1e7212ULL, 0x080fe200078efcffULL,
0x000000082f277824ULL, 0x000fe200078e00ffULL, 0x0000000708087212ULL, 0x080fe200078efcffULL,
0x0000000135147824ULL, 0x000fe200078e0206ULL, 0x0000000012237faeULL, 0x0003e2000d101c46ULL,
0x0000001029117824ULL, 0x004fe200078e021cULL, 0xfffffff827277812ULL, 0x000fe200078ee220ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x000000000e1d7faeULL, 0x0005e2000c101c46ULL, 0x000000162d00720cULL, 0x080fe20003fa6070ULL,
0x0000000131227824ULL, 0x100fe200078e0203ULL, 0x000065001f1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000000c117faeULL, 0x0007e2000d901c46ULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000008312d7824ULL, 0x000fe200078e00ffULL, 0x0000000714147212ULL, 0x080fe200078efcffULL,
0x0000001027237824ULL, 0x102fe200078e021cULL, 0x0000003017277810ULL, 0x000fe20007ffe0ffULL,
0x000000102b137824ULL, 0x100fe200078e021cULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000001025217824ULL, 0x000fe200078e021cULL, 0x00000034171d7810ULL, 0x004fe20007ffe0ffULL,
0x00000001270e7824ULL, 0x140fe200078e0206ULL, 0x000000000a137faeULL, 0x0003e2000e101c46ULL,
0x0000640014147a10ULL, 0x000fe20007fde0ffULL, 0x00000001270f7824ULL, 0x000fe200078e0203ULL,
0x000000162f00720cULL, 0x080fe20003f26070ULL, 0x000000011d0c7824ULL, 0x008fe200078e0206ULL,
0x0000650015157a10ULL, 0x000fe200037fe4ffULL, 0x0000000827127824ULL, 0x000fe200078e00ffULL,
0x0000003817297810ULL, 0x000fe20007ffe0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000163100720cULL, 0x000fe20003f46070ULL, 0x0000000018217faeULL, 0x0005e2000e901c46ULL,
0x0000003c172b7810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0a7825ULL, 0x002fe200078e00ffULL,
0x000000070c107212ULL, 0x000fc400078efcffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL,
0x00000001330e7824ULL, 0x140fe200078e0203ULL, 0x000000070a0a7212ULL, 0x080fe200078efcffULL,
0x0000000833137824ULL, 0x000fe200078e00ffULL, 0x000000001a237faeULL, 0x0003e2000c901c46ULL,
0x0000000835177824ULL, 0x000fe200078e00ffULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x00000001290c7824ULL, 0x000fe200078e0206ULL, 0xfffffff813137812ULL, 0x000fe200078ee20eULL,
0x00000001350e7824ULL, 0x000fe200078e0203ULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x000000102d257824ULL, 0x100fe200078e021cULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x000fe200078e021cULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000012b0e7824ULL, 0x000fe200078e0206ULL, 0x000065000d117a10ULL, 0x000fe200037fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff812197812ULL, 0x004fe200078ee20fULL,
0x000000001e257faeULL, 0x0005e2000d101c46ULL, 0x000000163300720cULL, 0x000fe20003fa6070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000070c0c7212ULL, 0x000fc400078efcffULL,
0x000000163500720cULL, 0x080fe20003f86070ULL, 0x000000011d127824ULL, 0x140fe200078e0203ULL,
0x000000161d00720cULL, 0x0c0fe20003f46070ULL, 0x000000081d1b7824ULL, 0x002fe200078e00ffULL,
0x000000162700720cULL, 0x080fe20003f66070ULL, 0x0000000129067824ULL, 0x140fe200078e0203ULL,
0x000000162900720cULL, 0x0c0fe20003f26070ULL, 0x00000008291d7824ULL, 0x000fe200078e00ffULL,
0x000000162b00720cULL, 0x040fe20003f06070ULL, 0x000000012b167824ULL, 0x040fe200078e0203ULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000082b1f7824ULL, 0x004fe200078e00ffULL,
0x000000070e077212ULL, 0x000fe200078efcffULL, 0x0000001017177824ULL, 0x000fe200078e021cULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL, 0x0000001019197824ULL, 0x000fe200078e021cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x0000000008137faeULL, 0x0003e2000e901c46ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x000000101b1b7824ULL, 0x100fe200078e021cULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021cULL,
0x0000640007067a10ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e021cULL,
0x0000000014177faeULL, 0x0003e4000e101c46ULL, 0x000065000f077a10ULL, 0x000fc400037fe4ffULL,
0x000000000a197faeULL, 0x0003e8000d901c46ULL, 0x00000000101b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x00000000061f7faeULL, 0x0003e2000c101c46ULL,
0x00000b6000007947ULL, 0x000fea0003800000ULL, 0x0000000403087811ULL, 0x042fe200078fe8ffULL,
0x00000010033b7824ULL, 0x040fe200078e00ffULL, 0x00000008030a7811ULL, 0x000fc400078fe8ffULL,
0x0000001803127811ULL, 0x040fe200078fe8ffULL, 0x0000000108077824ULL, 0x140fe200078e0203ULL,
0x0000000c030c7811ULL, 0x040fe200078fe8ffULL, 0x0000000808207824ULL, 0x000fe200078e00ffULL,
0x00000010030e7811ULL, 0x040fe200078fe8ffULL, 0x000000010a097824ULL, 0x040fe200078e0203ULL,
0x0000001403107811ULL, 0x040fe200078fe8ffULL, 0x000000080a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x00000001120d7824ULL, 0x040fe200078e0203ULL,
0x00000028031a7811ULL, 0x040fe200078fe8ffULL, 0x0000000812327824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x000000010c077824ULL, 0x140fe200078e0203ULL,
0x0000001c03147811ULL, 0x040fe200078fe8ffULL, 0x000000080c2c7824ULL, 0x000fe200078e00ffULL,
0x0000002003167811ULL, 0x040fe200078fe8ffULL, 0x000000010e097824ULL, 0x000fe200078e0203ULL,
0xfffffff832327812ULL, 0x000fe200078ee20dULL, 0x000000080e2e7824ULL, 0x000fe200078e00ffULL,
0x0000002403187811ULL, 0x040fe200078fe8ffULL, 0x00000001100b7824ULL, 0x000fe200078e0203ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee207ULL, 0x0000000810307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee209ULL, 0x000000011a0d7824ULL, 0x140fe200078e0203ULL,
0x0000003803247811ULL, 0x040fe200078fe8ffULL, 0x000000081a3a7824ULL, 0x000fe200078e00ffULL,
0x0000002c031c7811ULL, 0x040fe200078fe8ffULL, 0x0000000114077824ULL, 0x040fe200078e0203ULL,
0x0000003003287811ULL, 0x040fe200078fe8ffULL, 0x0000000814347824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee20bULL, 0x0000000116097824ULL, 0x000fe200078e0203ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20dULL, 0x0000000816367824ULL, 0x000fe200078e00ffULL,
0x0000003403267811ULL, 0x000fe200078fe8ffULL, 0x00000001180b7824ULL, 0x000fe200078e0203ULL,
0xfffffff834347812ULL, 0x000fe200078ee207ULL, 0x0000000818387824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee209ULL, 0x00000001240d7824ULL, 0x040fe200078e0203ULL,
0x000000703b3b7812ULL, 0x000fe200078ec0ffULL, 0x0000000824447824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee20bULL, 0x000000011c077824ULL, 0x000fc400078e0203ULL,
0x000000081c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20dULL,
0x0000000128097824ULL, 0x040fe200078e0203ULL, 0x0000003c030d7811ULL, 0x040fe200078fe8ffULL,
0x00000008283e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL,
0x00000001260b7824ULL, 0x040fe200078e0203ULL, 0x0000000603077211ULL, 0x040fe200078fe8ffULL,
0x0000000826407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee209ULL,
0x0000000108087824ULL, 0x100fe200078e0206ULL, 0x0000000303097211ULL, 0x000fe200078fe8ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0206ULL, 0xfffffff840407812ULL, 0x000fe200078ee20bULL,
0x00000002020b7824ULL, 0x000fe200078e0263ULL, 0x00000007091e7812ULL, 0x000fe200078ec0ffULL,
0x000000010c0c7824ULL, 0x000fc400078e0206ULL, 0x000000010e0e7824ULL, 0x100fe200078e0206ULL,
0x0ffffff81e1e7812ULL, 0x000fe200078ef803ULL, 0x0000000110107824ULL, 0x100fe400078e0206ULL,
0x0000000112127824ULL, 0x100fe400078e0206ULL, 0x0000000114147824ULL, 0x100fe400078e0206ULL,
0x0000000116167824ULL, 0x100fe400078e0206ULL, 0x0000000118187824ULL, 0x000fc400078e0206ULL,
0x000000011a1a7824ULL, 0x100fe400078e0206ULL, 0x000000011c1c7824ULL, 0x100fe400078e0206ULL,
0x0000000128287824ULL, 0x100fe400078e0206ULL, 0x0000000126267824ULL, 0x100fe400078e0206ULL,
0x0000000124247824ULL, 0x100fe400078e0206ULL, 0x000000010d227824ULL, 0x000fc400078e0206ULL,
0x000000010d0f7824ULL, 0x040fe400078e0203ULL, 0x000000080d467824ULL, 0x000fe200078e00ffULL,
0x000010000b0d7811ULL, 0x000fe200078e68ffULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee20fULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003b06067212ULL, 0x000fc600078efcffULL, 0x000000101e397824ULL, 0x100fe200078e020dULL,
0x0000640006067a10ULL, 0x000fe20007f1e0ffULL, 0x0000001020377824ULL, 0x100fe200078e020dULL,
0x0000003b0a0a7212ULL, 0x000fe200078efcffULL, 0x000000102a357824ULL, 0x100fe200078e020dULL,
0x0000650007077a10ULL, 0x000fe200007fe4ffULL, 0x000000102c337824ULL, 0x100fe200078e020dULL,
0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000102e317824ULL, 0x100fe400078e020dULL,
0x00000010302f7824ULL, 0x100fe200078e020dULL, 0x000065000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x00000010322d7824ULL, 0x100fe200078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006397faeULL, 0x0003e2000b901c46ULL, 0x00000010342b7824ULL, 0x000fc400078e020dULL,
0x0000001036297824ULL, 0x100fe400078e020dULL, 0x0000001038277824ULL, 0x100fe400078e020dULL,
0x000000103a257824ULL, 0x100fe400078e020dULL, 0x000000103c237824ULL, 0x100fe400078e020dULL,
0x000000103e217824ULL, 0x100fe400078e020dULL, 0x0000001040207824ULL, 0x000fc400078e020dULL,
0x00000010441f7824ULL, 0x100fe400078e020dULL, 0x00000010461e7824ULL, 0x000fe400078e020dULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000003b0c0c7212ULL, 0x000fc600078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000064000c0c7a10ULL, 0x000fe40007f1e0ffULL, 0x0000003b10107212ULL, 0x080fe200078efcffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000065000d0d7a10ULL, 0x000fe400007fe4ffULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003b14147212ULL, 0x080fe400078efcffULL, 0x0000003b08087212ULL, 0x000fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000650011117a10ULL, 0x000fc400007fe4ffULL,
0x0000640014147a10ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000640008087a10ULL, 0x000fe40007f3e0ffULL, 0x0000003b18187212ULL, 0x080fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000003b0e0e7212ULL, 0x080fe400078efcffULL,
0x0000003b12127212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000650015157a10ULL, 0x000fc400007fe4ffULL, 0x0000650009097a10ULL, 0x000fe20000ffe4ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000640018187a10ULL, 0x000fe40007f1e0ffULL,
0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x00000080283c7825ULL, 0x000fe200078e00ffULL,
0x0000003b1c1c7212ULL, 0x080fe200078efcffULL, 0x0000000008377faeULL, 0x0003e2000b901c46ULL,
0x0000640012127a10ULL, 0x000fe20007f5e0ffULL, 0x00000080263e7825ULL, 0x000fe200078e00ffULL,
0x0000003b16167212ULL, 0x080fe200078efcffULL, 0x000000000a357faeULL, 0x0003e2000b901c46ULL,
0x0000003b1a1a7212ULL, 0x000fe200078efcffULL, 0x0000008024407825ULL, 0x000fe200078e00ffULL,
0x0000650019197a10ULL, 0x000fe200007fe4ffULL, 0x000000000c337faeULL, 0x0003e2000b901c46ULL,
0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008022447825ULL, 0x000fe200078e00ffULL,
0x000064001c1c7a10ULL, 0x000fc40007f1e0ffULL, 0x0000650013137a10ULL, 0x000fe200017fe4ffULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x0000640016167a10ULL, 0x000fe40007f3e0ffULL,
0x0000003b3c3a7212ULL, 0x080fe200078efcffULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x000064001a1a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000003b3e3c7212ULL, 0x080fe200078efcffULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x0000003b403e7212ULL, 0x000fc400078efcffULL,
0x000065001d1d7a10ULL, 0x000fe200007fe4ffULL, 0x00000000142b7faeULL, 0x0003e2000b901c46ULL,
0x0000003b443b7212ULL, 0x000fe400078efcffULL, 0x0000650017177a10ULL, 0x000fe40000ffe4ffULL,
0x000064003a3a7a10ULL, 0x000fe40007f1e0ffULL, 0x000065001b1b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000016297faeULL, 0x0003e2000b901c46ULL, 0x000064003c3c7a10ULL, 0x000fc40007f3e0ffULL,
0x000064003e3e7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000018277faeULL, 0x0003e2000b901c46ULL,
0x000064003b407a10ULL, 0x000fe40007f7e0ffULL, 0x000065003d3b7a10ULL, 0x000fe200007fe4ffULL,
0x000000001a257faeULL, 0x0003e2000b901c46ULL, 0x000065003f3d7a10ULL, 0x000fe40000ffe4ffULL,
0x00006500413f7a10ULL, 0x000fe200017fe4ffULL, 0x000000001c237faeULL, 0x0003e2000b901c46ULL,
0x0000650045417a10ULL, 0x000fc60001ffe4ffULL, 0x000000003a217faeULL, 0x0003e8000b901c46ULL,
0x000000003c207faeULL, 0x0003e8000b901c46ULL, 0x000000003e1f7faeULL, 0x0003e8000b901c46ULL,
0x00000000401e7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020030a7810ULL, 0x042fe20007ffe0ffULL, 0x0000000202067824ULL, 0x000fe200078e0205ULL,
0x00000007030c7812ULL, 0x040fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0xfffffff8035e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0xfffffff80a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000004ff6d7819ULL, 0x000fe20000011603ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000100006067811ULL, 0x000fe400078e68ffULL, 0x000000080c077812ULL, 0x100fe400078ef803ULL,
0x000000075e5e7812ULL, 0x100fe400078ef803ULL, 0x000000070a057812ULL, 0x000fc600078ef803ULL,
0x000000015e097824ULL, 0x040fe200078e0208ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000085e0a7824ULL, 0x020fe400078e00ffULL, 0x00000008050b7824ULL, 0x000fc400078e00ffULL,
0x00000002086f7824ULL, 0x000fe200078e026dULL, 0xfffffff80a097812ULL, 0x000fe200078ee209ULL,
0x00000001050a7824ULL, 0x000fc800078e0208ULL, 0x0000001009097824ULL, 0x000fe200078e0206ULL,
0xfffffff80b0b7812ULL, 0x000fc800078ee20aULL, 0x000000000910783bULL, 0x000e620000000200ULL,
0x000000100b0b7824ULL, 0x000fca00078e0206ULL, 0x000000000b0c783bULL, 0x0004e40000000200ULL,
0x00000001080b7810ULL, 0x044fe40007ffe0ffULL, 0x0000000208087810ULL, 0x000fc80007ffe0ffULL,
0x000000080800780cULL, 0x000fe20003f05270ULL, 0x00010000110a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011411ULL, 0x0001000010097824ULL, 0x000fe200078e00ffULL,
0x00008880114e7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x00000018ff477819ULL, 0x000fe20000011410ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x0000888010487816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff677819ULL, 0x000fe20000011412ULL,
0x0000000a00707306ULL, 0x0003e20000200c00ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff517819ULL, 0x000fe40000011413ULL, 0x0000888012697816ULL, 0x000fc400000000ffULL,
0x0000888013507816ULL, 0x040fe200000000ffULL, 0x00000011006e7306ULL, 0x0005e20000200c00ULL,
0x00010000130a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff557819ULL, 0x008fe2000001140cULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x000088800c547816ULL, 0x000fe400000000ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x00000010004d7306ULL, 0x000fe20000200c00ULL,
0x000000085e117824ULL, 0x004fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff587819ULL, 0x000fe4000001140dULL, 0x000088800d5a7816ULL, 0x000fe400000000ffULL,
0x0000000a00667306ULL, 0x0003e20000200c00ULL, 0x00000018ff527819ULL, 0x000fe4000001140eULL,
0x00000018ff497819ULL, 0x000fe4000001140fULL, 0x000088800e537816ULL, 0x000fe400000000ffULL,
0x000088800f4a7816ULL, 0x000fe200000000ffULL, 0x0000000900747306ULL, 0x0005e20000200c00ULL,
0x000000015e0a7824ULL, 0x002fc400078e020bULL, 0x00000001050b7824ULL, 0x000fc600078e020bULL,
0xfffffff811117812ULL, 0x000fe200078ee20aULL, 0x000100000d0a7824ULL, 0x000fe200078e00ffULL,
0x0000001300657306ULL, 0x000fe20000200c00ULL, 0x0001000012097824ULL, 0x044fe400078e00ffULL,
0x0000001011117824ULL, 0x000fe200078e0206ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x00000000111c783bULL, 0x0002a20000000200ULL,
0x0000000a005b7306ULL, 0x0007e20000200c00ULL, 0x00000018ff127819ULL, 0x000fc40000011412ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0000001007117824ULL, 0x002fc800078e00ffULL,
0x00000009006b7306ULL, 0x0003e20000200c00ULL, 0x000100000f0a7824ULL, 0x048fe400078e00ffULL,
0x000001000f0f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001140aULL,
0x00000012006a7306ULL, 0x000fe20000200c00ULL, 0x000100000c097824ULL, 0x042fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x000001000c0c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000004700477306ULL, 0x000e700000200c00ULL, 0x0000000c005c7306ULL, 0x0007e20000200c00ULL,
0x000100001c107824ULL, 0x044fe200078e00ffULL, 0x000088801c3d7816ULL, 0x000fcc00000000ffULL,
0x00000009005d7306ULL, 0x0005e20000200c00ULL, 0x00000008050c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001141dULL, 0x00000018ff3e7819ULL, 0x000fe20000011410ULL,
0x0000000107107824ULL, 0x000fe200078e026fULL, 0xfffffff80c0b7812ULL, 0x000fe400078ee20bULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x000100000e097824ULL, 0x004fe200078e00ffULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x000100001d117824ULL, 0x040fe200078e00ffULL,
0x000088801d407816ULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011411ULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000900567306ULL, 0x0005e20000200c00ULL, 0x000000000b18783bULL, 0x0008e20000000200ULL,
0x000088801e447816ULL, 0x000fe200000000ffULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000001010783bULL, 0x000ee20000000200ULL,
0x00000002076f7810ULL, 0x000fc40007ffe06fULL, 0x0000001d00457306ULL, 0x0003e20000200c00ULL,
0x00000018ff097819ULL, 0x004fe2000001141cULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x010fe4000001141eULL, 0x00000018ff0c7819ULL, 0x000fe4000001141fULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000054104d1d7816ULL, 0x002fe40000000047ULL, 0x000088801f477816ULL, 0x000fc400000000ffULL,
0x00000018ff0e7819ULL, 0x000fc6000001140eULL, 0x0000001c003f7306ULL, 0x0003f00000200c00ULL,
0x0000006700677306ULL, 0x000f220000200c00ULL, 0x000100001e1c7824ULL, 0x042fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x008fce000001141bULL, 0x0000001c00467306ULL, 0x0003f00000200c00ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00005410481c7816ULL, 0x002fce0000000074ULL,
0x0000001c1038723cULL, 0x000be20000001838ULL, 0x0000001e00487306ULL, 0x0003ec0000200c00ULL,
0x000100001f1d7824ULL, 0x060fe200078e00ffULL, 0x000054104e1c7816ULL, 0x004fe20000000070ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x00008880181e7816ULL, 0x002fe200000000ffULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc8000001141dULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000001d004d7306ULL, 0x0003f00000200c00ULL,
0x0000000d00597306ULL, 0x0005e20000200c00ULL, 0x000054106e1d7816ULL, 0x002fe2000000004fULL,
0x000000ffff4f7224ULL, 0x000fc400078e001eULL, 0x00000010071e7824ULL, 0x000fc800078e00ffULL,
0x0000001c1034723cULL, 0x000b620000001834ULL, 0xfffffff01e6f7812ULL, 0x000fe200078ee26fULL,
0x00000100181e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x004fe20000011418ULL,
0x0000005500557306ULL, 0x000e660000200c00ULL, 0x00010000181c7824ULL, 0x020fe200078e00ffULL,
0x000054106a1d7816ULL, 0x010fe40000000067ULL, 0x00000018ff677819ULL, 0x000fe2000001141eULL,
0x000000106f1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x000054105c557816ULL, 0x002fce0000000055ULL,
0x0000001c00187306ULL, 0x0003e20000200c00ULL, 0x00000100195c7824ULL, 0x000fce00078e00ffULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x00005410691c7816ULL, 0x002fe4000000006bULL,
0x0000541054547816ULL, 0x004fca000000005dULL, 0x0000001c1030723cULL, 0x040b620000001830ULL,
0x0000005a005a7306ULL, 0x000e6c0000200c00ULL, 0x00005410501c7816ULL, 0x020fe20000000066ULL,
0x000000541028723cULL, 0x000be20000001828ULL, 0x00005410651d7816ULL, 0x000fe20000000051ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000888019667816ULL, 0x040fe200000000ffULL,
0x0001000019657824ULL, 0x000fc600078e00ffULL, 0x0000541059557816ULL, 0x028fe20000000058ULL,
0x0000001c102c723cULL, 0x000f62000000182cULL, 0x000054105a547816ULL, 0x002fe2000000005bULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000000ffff517224ULL, 0x000fe200078e0066ULL,
0x00000018ff657819ULL, 0x000fc80000011465ULL, 0x000000541024723cULL, 0x000b640000001824ULL,
0x0000005200527306ULL, 0x000fea0000200c00ULL, 0x000088801a557816ULL, 0x020fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe2000001145cULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054104a4a7816ULL, 0x002fce000000004bULL, 0x0000005300537306ULL, 0x000e700000200c00ULL,
0x0000000e00577306ULL, 0x0004f00000200c00ULL, 0x0000000f004c7306ULL, 0x0009220000200c00ULL,
0x0000541053567816ULL, 0x002fe20000000056ULL, 0x000100001a537824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x004fca0000011419ULL, 0x0000001f004e7306ULL, 0x0003e20000200c00ULL,
0x0000541057577816ULL, 0x008fe20000000052ULL, 0x000000ffff527224ULL, 0x000fe200078e0055ULL,
0x00000018ff0f7819ULL, 0x010fe2000001141aULL, 0x000001001a1a7824ULL, 0x000fc800078e00ffULL,
0x0000000900097306ULL, 0x000ea20000200c00ULL, 0x000000001e1c783bULL, 0x002e620000000200ULL,
0x000054104c4b7816ULL, 0x000fe20000000049ULL, 0x000000561020723cULL, 0x040f6a0000001820ULL,
0x0000004000407306ULL, 0x000fe60000200c00ULL, 0x0000004a1014723cULL, 0x000b6a0000001814ULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x000054103f3f7816ULL, 0x004fe20000000009ULL,
0x000100001b127824ULL, 0x060fe200078e00ffULL, 0x000088801b097816ULL, 0x040fe200000000ffULL,
0x000001001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc40000011453ULL,
0x00000018ff107819ULL, 0x000fe2000001141aULL, 0x0000000a000a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff1b7819ULL, 0x000fca000001141bULL,
0x0000000b000b7306ULL, 0x000f220000200c00ULL, 0x0000541040407816ULL, 0x008fce0000000041ULL,
0x0000004400447306ULL, 0x000ee20000200c00ULL, 0x0000541045417816ULL, 0x004fce000000000aULL,
0x0000000c000c7306ULL, 0x000fe20000200c00ULL, 0x00005410480b7816ULL, 0x010fe2000000000bULL,
0x000000401c34723cULL, 0x002f6c0000001834ULL, 0x0000004700477306ULL, 0x000e620000200c00ULL,
0x00005410440a7816ULL, 0x008fce0000000046ULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x0000000a1c30723cULL, 0x000b6e0000001830ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x00005410470a7816ULL, 0x022fe4000000004dULL, 0x000054104e0b7816ULL, 0x000fca000000000cULL,
0x0000000d000d7306ULL, 0x000fe40000200c00ULL, 0x0000000a1c2c723cULL, 0x000b6c000000182cULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x00005410540b7816ULL, 0x024fce000000000eULL,
0x0000003c003c7306ULL, 0x000ff00000200c00ULL, 0x0000003d003d7306ULL, 0x000ff00000200c00ULL,
0x0000003e003e7306ULL, 0x000e700000200c00ULL, 0x0000004f004f7306ULL, 0x000eb00000200c00ULL,
0x0000006700507306ULL, 0x000ee20000200c00ULL, 0x000054103d3e7816ULL, 0x002fce000000003eULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054104f0c7816ULL, 0x004fe20000000018ULL,
0x0000003e1c38723cULL, 0x000b6c0000001838ULL, 0x0000006500197306ULL, 0x000e620000200c00ULL,
0x00005410500d7816ULL, 0x008fce000000000dULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x0000000c1c28723cULL, 0x000b6e0000001828ULL, 0x0000001100117306ULL, 0x000ea20000200c00ULL,
0x00005410510a7816ULL, 0x002fce0000000019ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x0000000a1c24723cULL, 0x000b6e0000001824ULL, 0x0000000900097306ULL, 0x000fe20000200c00ULL,
0x00005410520e7816ULL, 0x004fce0000000011ULL, 0x0000001200127306ULL, 0x000ea20000200c00ULL,
0x00005410100f7816ULL, 0x002fce000000000fULL, 0x0000001b00137306ULL, 0x000e620000200c00ULL,
0x0000000e1c20723cULL, 0x000b620000001820ULL, 0x0000541009127816ULL, 0x004fe40000000012ULL,
0x0000541013137816ULL, 0x002fce000000003cULL, 0x000000121c14723cULL, 0x000b620000001814ULL,
0xfffff09000000947ULL, 0x000fce000383ffffULL, 0x0000000430307220ULL, 0x080fe40000410000ULL,
0x0000000428287220ULL, 0x0a0fe40000410000ULL, 0x000000042c2c7220ULL, 0x080fe40000410000ULL,
0x0000000429297220ULL, 0x080fe40000410000ULL, 0x0000000438387220ULL, 0x080fe40000410000ULL,
0x0000000439397220ULL, 0x000fc40000410000ULL, 0x0000000434347220ULL, 0x080fe40000410000ULL,
0x0000000435357220ULL, 0x080fe40000410000ULL, 0x0000000431317220ULL, 0x080fe40000410000ULL,
0x000000042b0b7220ULL, 0x080fe40000410000ULL, 0x0000000424057220ULL, 0x080fe40000410000ULL,
0x0000000420207220ULL, 0x000fc40000410000ULL, 0x00000004321f7220ULL, 0x080fe40000410000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0030ULL, 0x000000042d327220ULL, 0x080fe40000410000ULL,
0x00000004270d7220ULL, 0x080fe40000410000ULL, 0x000000ffff307224ULL, 0x000fe400078e0028ULL,
0x000000042e087220ULL, 0x000fc40000410000ULL, 0x000000042a0a7220ULL, 0x080fe40000410000ULL,
0x00000004252d7220ULL, 0x080fe40000410000ULL, 0x00000004260c7220ULL, 0x080fe40000410000ULL,
0x0000000422137220ULL, 0x080fe40000410000ULL, 0x0000000423187220ULL, 0x080fe40000410000ULL,
0x00000004171a7220ULL, 0x000fc40000410000ULL, 0x000000ffff277224ULL, 0x000fe400078e002cULL,
0x000000ffff287224ULL, 0x000fe400078e0029ULL, 0x000000043a1c7220ULL, 0x080fe40000410000ULL,
0x000000043b1b7220ULL, 0x080fe40000410000ULL, 0x00000004361d7220ULL, 0x080fe40000410000ULL,
0x0000000437377220ULL, 0x000fc40000410000ULL, 0x00000004331e7220ULL, 0x080fe40000410000ULL,
0x000000042f097220ULL, 0x080fe40000410000ULL, 0x00000004212a7220ULL, 0x080fe40000410000ULL,
0x0000000414227220ULL, 0x080fe40000410000ULL, 0x0000000415237220ULL, 0x080fe40000410000ULL,
0x0000000416197220ULL, 0x000fc40000410000ULL, 0x000000ffff177224ULL, 0x000fe400078e0038ULL,
0x000000ffff247224ULL, 0x000fe400078e0039ULL, 0x000000ffff257224ULL, 0x000fe400078e0034ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0035ULL, 0x000000ffff267224ULL, 0x000fe400078e0031ULL,
0x000000ffff297224ULL, 0x000fc400078e0005ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000073067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2f7224ULL, 0x000fe400078e0037ULL, 0x000000ffff207224ULL, 0x000fe400078e0008ULL,
0x000000ffff317224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x000000ffff167224ULL, 0x000fc400078e000bULL, 0x000000ffff157224ULL, 0x000fe400078e000cULL,
0x000000ffff147224ULL, 0x000fc400078e000dULL, 0x0000000000087805ULL, 0x002fca0000015200ULL,
0x0000040073057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040073057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403127824ULL, 0x000fe200078e00ffULL, 0x000000716000720cULL, 0x000fc80003f06070ULL,
0xfffffff012057812ULL, 0x000fca00078ec0ffULL, 0x0000008002057824ULL, 0x000fca00078e0205ULL,
0x0174000005087984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000ee20000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0xffffff0061617810ULL, 0x000fe20007ffe0ffULL, 0x0000000203357824ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f85070ULL, 0x0000006168347217ULL, 0x000fe40007800000ULL,
0x0000000635357812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff377a12ULL, 0x000fe200078e33ffULL,
0x0000000134347824ULL, 0x000fc400078e0a61ULL, 0x0000000135337824ULL, 0x000fe200078e0200ULL,
0x0000000c000c7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0c0e7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000e00077305ULL, 0x000ee4000021f000ULL, 0x000000ffff0d7224ULL, 0x008fc800078e0a07ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d070f7227ULL, 0x000fe200078e0006ULL,
0x0000007b03067211ULL, 0x000fca00078ff0ffULL, 0x000000060f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a07ULL, 0x00005a000d0c7a24ULL, 0x000fe200078e0206ULL,
0x0000000806067810ULL, 0x000fc80007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe20003f06070ULL,
0x000000060f367227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a36ULL,
0x00005a000d0e7a24ULL, 0x000fe400078e0206ULL, 0x00000001620d7824ULL, 0x000fe400078e0235ULL,
0x80005a000c0c0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe40003f46070ULL,
0x00005a000c007a0cULL, 0x000fe20003f26070ULL, 0x000000010d0c7824ULL, 0x000fe200078e0a34ULL,
0x0000000107070810ULL, 0x000fc40007ffe0ffULL, 0x000000340d00720cULL, 0x000fce0003f66070ULL,
0x80005a000e0e2a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a000e007a0cULL, 0x000fe40003f06070ULL, 0x0000000737067207ULL, 0x000fe40006000000ULL,
0x0000000c5f077217ULL, 0x000fe20003800000ULL, 0x00000001330c7824ULL, 0x000fe200078e0a34ULL,
0x000000065f517217ULL, 0x000fc40003800000ULL, 0x00000004ff077819ULL, 0x000fe40000011607ULL,
0x0000000136362810ULL, 0x000fe20007ffe0ffULL, 0x0000005164517224ULL, 0x000fe200078e02ffULL,
0x000000ff07067207ULL, 0x000fe40001800000ULL, 0x000000343300720cULL, 0x000fe40003f26070ULL,
0x0000000c5f0c7217ULL, 0x000fe20003800000ULL, 0x00000001510f7824ULL, 0x000fe200078e0206ULL,
0x0000000136360810ULL, 0x000fc40007ffe0ffULL, 0x000000ff0c487207ULL, 0x000fe20000800000ULL,
0x000000020f0e7825ULL, 0x000fe200078e0042ULL, 0x0000001035397812ULL, 0x000fe400078efcffULL,
0x0000003637367207ULL, 0x000fe40006000000ULL, 0x0000005148117211ULL, 0x000fe200078fe0ffULL,
0x000000060e4a7981ULL, 0x000722000c1e9500ULL, 0x000000365f537217ULL, 0x000fc60003800000ULL,
0x0000000211107825ULL, 0x000fc800078e0042ULL, 0x00000001620f7824ULL, 0x008fe200078e0239ULL,
0x00000006104f7981ULL, 0x000722000c1e9500ULL, 0x0000005364537224ULL, 0x000fe400078e02ffULL,
0x000000010f0e7824ULL, 0x000fe200078e0a34ULL, 0x00000020353b7812ULL, 0x000fe400078efcffULL,
0x0000005348077211ULL, 0x000fe400078fe0ffULL, 0x0000000e5f107217ULL, 0x008fe40003800000ULL,
0x000000340f00720cULL, 0x000fc40003f26070ULL, 0x00000004ff107819ULL, 0x000fe20000011610ULL,
0x00000001060d7824ULL, 0x000fe400078e0253ULL, 0x0000000207067825ULL, 0x000fe200078e0042ULL,
0x000000ff10107207ULL, 0x000fc60000800000ULL, 0x0000000162417824ULL, 0x000fe200078e023bULL,
0x00000006064d7981ULL, 0x0046a2000c1e9500ULL, 0x0000000139377824ULL, 0x000fe400078e0200ULL,
0x00000001413c7824ULL, 0x100fe400078e0a34ULL, 0x00000001370e7824ULL, 0x000fe400078e0a34ULL,
0x000000020d0c7825ULL, 0x000fe200078e0042ULL, 0x0000003c5f3c7217ULL, 0x000fc60003800000ULL,
0x0000000151077824ULL, 0x008fe200078e0210ULL, 0x000000343700720cULL, 0x000fe20003f06070ULL,
0x000000013b3f7824ULL, 0x000fe200078e0200ULL, 0x0000000e5f0e7217ULL, 0x000fe20003800000ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x000000344100720cULL, 0x000fe20003f26070ULL,
0x000000060c447981ULL, 0x0006a2000c1e9500ULL, 0x00000004ff3c7819ULL, 0x000fe4000001163cULL,
0x000000ff0e367207ULL, 0x000fe20000000000ULL, 0x0000000606387981ULL, 0x0002a2000c1e9500ULL,
0x000000ff3c407207ULL, 0x000fc40000800000ULL, 0x0000003035417812ULL, 0x000fe200078efcffULL,
0x00000001100f7824ULL, 0x000fe200078e0253ULL, 0x0000005336117211ULL, 0x040fe200078fe0ffULL,
0x000000013f067824ULL, 0x002fe200078e0a34ULL, 0x00000051360d7211ULL, 0x008fe200078fe0ffULL,
0x0000000151077824ULL, 0x000fe200078e0240ULL, 0x000000343f00720cULL, 0x000fe40003f06070ULL,
0x000000065f067217ULL, 0x000fe20003800000ULL, 0x0000000162557824ULL, 0x000fe400078e0241ULL,
0x000000020d0c7825ULL, 0x000fe200078e0042ULL, 0x000000ff063c7207ULL, 0x000fc60000000000ULL,
0x000000020f0e7825ULL, 0x100fe200078e0042ULL, 0x000000060c3d7981ULL, 0x0002e6000c1e9500ULL,
0x0000000211107825ULL, 0x100fe200078e0042ULL, 0x000000060e3a7981ULL, 0x0002e6000c1e9500ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x0000000610457981ULL, 0x0002e6000c1e9500ULL,
0x0000000155467824ULL, 0x000fe200078e0a34ULL, 0x00000006063e7981ULL, 0x0002e2000c1e9500ULL,
0x0000000141497824ULL, 0x000fe200078e0200ULL, 0x000000513c0d7211ULL, 0x002fc400078fe0ffULL,
0x000000465f467217ULL, 0x000fe20003800000ULL, 0x00000001400f7824ULL, 0x000fe200078e0253ULL,
0x000000533c117211ULL, 0x000fe200078fe0ffULL, 0x0000000149067824ULL, 0x000fe200078e0a34ULL,
0x000000345500720cULL, 0x080fe40003f26070ULL, 0x00000004ff467819ULL, 0x000fe20000011646ULL,
0x000000020d0c7825ULL, 0x100fe200078e0042ULL, 0x000000344900720cULL, 0x000fe40003f06070ULL,
0x000000065f067217ULL, 0x000fe20003800000ULL, 0x000000020f0e7825ULL, 0x100fe200078e0042ULL,
0x000000ff464c7207ULL, 0x000fe20000800000ULL, 0x000000060c477981ULL, 0x0002e4000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x000000ff06467207ULL, 0x000fe20000000000ULL,
0x000000060e407981ULL, 0x0002e8000c1e9500ULL, 0x00000006104b7981ULL, 0x0002e2000c1e9500ULL,
0x0000000151077824ULL, 0x000fe200078e024cULL, 0x00000051460d7211ULL, 0x002fc600078fe0ffULL,
0x0000000207067825ULL, 0x000fc800078e0042ULL, 0x000000020d0c7825ULL, 0x000fe400078e0042ULL,
0x0000000606067981ULL, 0x0002e2000c1e9500ULL, 0x00000053460f7211ULL, 0x000fc600078fe0ffULL,
0x000000060c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014c117824ULL, 0x000fe400078e0253ULL,
0x000000020f0e7825ULL, 0x000fc800078e0042ULL, 0x0000000211107825ULL, 0x000fe400078e0042ULL,
0x000000060e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000610117981ULL, 0x0002e2000c1e9500ULL,
0xfffffff048517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff487424ULL, 0x000fc800078e00ffULL,
0x00000001344c7824ULL, 0x000fc800078e0251ULL, 0x0000000133577824ULL, 0x000fe200078e0a4cULL,
0x0000000135077812ULL, 0x042fe400078efcffULL, 0x0000000935537812ULL, 0x000fe400078efcffULL,
0x0000005748577219ULL, 0x000fe200000006ffULL, 0x0000000107557824ULL, 0x100fe400078e0200ULL,
0x00000001530f7824ULL, 0x000fe400078e0200ULL, 0x0000000155597824ULL, 0x000fc400078e0a4cULL,
0x000000010f5d7824ULL, 0x000fe200078e0a4cULL, 0x0000001835777812ULL, 0x000fe400078efcffULL,
0x0000005948597219ULL, 0x040fe400000006ffULL, 0x0000005d485d7219ULL, 0x000fe400000006ffULL,
0xfffffff036367812ULL, 0x000fe200078ec0ffULL, 0x00000001770c7824ULL, 0x000fe200078e0200ULL,
0x00000019356f7812ULL, 0x040fe400078efcffULL, 0x0000001135797812ULL, 0x000fc400078efcffULL,
0x0000002135657812ULL, 0x040fe400078efcffULL, 0x0000002835617812ULL, 0x000fe200078efcffULL,
0x000000016f7d7824ULL, 0x100fe400078e0200ULL, 0x0000000179107824ULL, 0x100fe400078e0200ULL,
0x00000001656b7824ULL, 0x100fe400078e0200ULL, 0x0000000161697824ULL, 0x000fe200078e0200ULL,
0x000054104f4a7816ULL, 0x010fc4000000004aULL, 0x00000008354f7812ULL, 0x000fe400078efcffULL,
0x0000004a57ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014f517824ULL, 0x000fe200078e0200ULL,
0x000000343300720cULL, 0x000fc60000701470ULL, 0x00000001515b7824ULL, 0x000fe200078e0a4cULL,
0x000000343500720cULL, 0x000fc800007a1070ULL, 0x0000005b485b7219ULL, 0x000fe400000006ffULL,
0xff80000017177808ULL, 0x000fe40002800000ULL, 0x0000004a59ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004a5bff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a5dff7212ULL, 0x000fe4000788c0ffULL,
0xfffffff0464a7812ULL, 0x000fc400078ec0ffULL, 0x000054104d447816ULL, 0x004fc80000000044ULL,
0x0000004457ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004459ff7212ULL, 0x080fe4000780c0ffULL,
0x000000445bff7212ULL, 0x080fe400078cc0ffULL, 0x000000445dff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff03c447812ULL, 0x000fe200078ec0ffULL, 0x00000001343c7824ULL, 0x000fe200078e0236ULL,
0x000000343300720cULL, 0x000fc40001741470ULL, 0x000000345100720cULL, 0x080fe200037c1470ULL,
0x0000000134467824ULL, 0x000fe200078e0244ULL, 0x000000340f00720cULL, 0x080fe20002fa1470ULL,
0x0000000137447824ULL, 0x100fe400078e0a3cULL, 0x000000010c4c7824ULL, 0x000fe200078e0a3cULL,
0x000000343500720cULL, 0x080fe40001741070ULL, 0x000000344f00720cULL, 0x080fe400037c1070ULL,
0x000000345300720cULL, 0x000fc40002fa1070ULL, 0x0000004448447219ULL, 0x040fe400000006ffULL,
0x0000004c484c7219ULL, 0x000fe400000006ffULL, 0x000054103d3d7816ULL, 0x008fe40000000038ULL,
0x00000029355d7812ULL, 0x000fe400078efcffULL, 0x0000541045457816ULL, 0x000fe4000000003aULL,
0x0000003135597812ULL, 0x000fc400078efcffULL, 0x0000003835577812ULL, 0x040fe400078efcffULL,
0x00000039354d7812ULL, 0x000fe400078efcffULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000003d44ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004544ff7212ULL, 0x080fe400078cc0ffULL,
0x000000454cff7212ULL, 0x000fe200078ac0ffULL, 0x000000015d677824ULL, 0x100fe200078e0200ULL,
0x000000345500720cULL, 0x080fe20000f21470ULL, 0x00000001595b7824ULL, 0x100fe200078e0200ULL,
0x000000345500720cULL, 0x080fe20000701470ULL, 0x00000001576d7824ULL, 0x100fe200078e0200ULL,
0x000000345100720cULL, 0x080fe20001f61470ULL, 0x000000014d367824ULL, 0x000fe200078e0200ULL,
0x000000340f00720cULL, 0x080fe20002781470ULL, 0x0000000134507824ULL, 0x000fe200078e024aULL,
0x000000343700720cULL, 0x080fe20001741470ULL, 0x000000017d4e7824ULL, 0x100fe200078e0a3cULL,
0x000000343700720cULL, 0x080fe200037c1470ULL, 0x00000001104a7824ULL, 0x000fe200078e0a3cULL,
0x000000340c00720cULL, 0x000fe20002fa1470ULL, 0x000000013f527824ULL, 0x000fc400078e0a46ULL,
0x000000016b547824ULL, 0x100fe400078e0a46ULL, 0x0000000169567824ULL, 0x100fe400078e0a46ULL,
0x0000000167587824ULL, 0x000fe200078e0a46ULL, 0x000000340700720cULL, 0x080fe20000f21070ULL,
0x00000001495a7824ULL, 0x100fe200078e0a50ULL, 0x000000340700720cULL, 0x080fe20000701070ULL,
0x000000015b5c7824ULL, 0x100fe200078e0a50ULL, 0x000000344f00720cULL, 0x080fe20001f61070ULL,
0x000000016d3c7824ULL, 0x100fe200078e0a50ULL, 0x000000345300720cULL, 0x000fe20002781070ULL,
0x0000000136467824ULL, 0x000fe200078e0a50ULL, 0x0000004e48507219ULL, 0x000fc400000006ffULL,
0x000000343900720cULL, 0x0c0fe40001741070ULL, 0x000000343900720cULL, 0x080fe400037c1070ULL,
0x000000347700720cULL, 0x000fe40002fa1070ULL, 0x0000004a484a7219ULL, 0x040fe400000006ffULL,
0x00000052484e7219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x000fc4000000003eULL,
0x000054104b4b7816ULL, 0x000fe40000000040ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fc40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x0000003d4aff7212ULL, 0x080fe4000782c0ffULL, 0x0000003d4cff7212ULL, 0x080fe4000780c0ffULL,
0x0000003d50ff7212ULL, 0x000fe4000786c0ffULL, 0x000000454aff7212ULL, 0x000fc4000788c0ffULL,
0x0000004550ff7212ULL, 0x000fe4000784c0ffULL, 0x000000474eff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b4eff7212ULL, 0x000fe400078ac0ffULL, 0x000000341000720cULL, 0x0c0fe40000f21470ULL,
0x000000341000720cULL, 0x080fe40002781470ULL, 0x000000340c00720cULL, 0x000fc40000701470ULL,
0x000000347d00720cULL, 0x0c0fe40001f61470ULL, 0x000000347d00720cULL, 0x080fe40001741470ULL,
0x000000343f00720cULL, 0x0c0fe400037c1470ULL, 0x000000343f00720cULL, 0x080fe40002fa1470ULL,
0x000000347900720cULL, 0x0c0fe40000f21070ULL, 0x000000347900720cULL, 0x000fc40002781070ULL,
0x000000347700720cULL, 0x080fe40000701070ULL, 0x000000346f00720cULL, 0x0c0fe40001f61070ULL,
0x000000346f00720cULL, 0x080fe40001741070ULL, 0x000000343b00720cULL, 0x0c0fe400037c1070ULL,
0x000000343b00720cULL, 0x000fe40002fa1070ULL, 0x0000005448547219ULL, 0x000fc400000006ffULL,
0x0000005648567219ULL, 0x040fe400000006ffULL, 0x0000005848587219ULL, 0x040fe400000006ffULL,
0x0000005a485a7219ULL, 0x000fe400000006ffULL, 0x000054100d067816ULL, 0x000fe40000000006ULL,
0xff80000026267808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fc40002000000ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40003000000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0x0000004754ff7212ULL, 0x000fc4000782c0ffULL,
0x0000004756ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004758ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004b54ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b56ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004b58ff7212ULL, 0x000fe400078cc0ffULL, 0x000000065aff7212ULL, 0x000fc400078ac0ffULL,
0x000000346b00720cULL, 0x0c0fe40000f21470ULL, 0x000000346b00720cULL, 0x080fe40001f61470ULL,
0x000000346900720cULL, 0x0c0fe40002781470ULL, 0x000000346900720cULL, 0x080fe40001741470ULL,
0x000000346700720cULL, 0x0c0fe40000701470ULL, 0x000000346700720cULL, 0x000fc400037c1470ULL,
0x000000344900720cULL, 0x080fe40002fa1470ULL, 0x000000346500720cULL, 0x0c0fe40000f21070ULL,
0x000000346500720cULL, 0x080fe40001f61070ULL, 0x000000346100720cULL, 0x0c0fe40002781070ULL,
0x000000346100720cULL, 0x080fe40001741070ULL, 0x000000345d00720cULL, 0x000fc40000701070ULL,
0x000000345d00720cULL, 0x080fe400037c1070ULL, 0x000000344100720cULL, 0x000fe40002fa1070ULL,
0x0000005c485c7219ULL, 0x040fe400000006ffULL, 0x0000003c483c7219ULL, 0x040fe400000006ffULL,
0x0000004648467219ULL, 0x000fe400000006ffULL, 0x000054100e117816ULL, 0x000fc40000000011ULL,
0xff80000028287808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fe40001800000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000015157808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fc40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40002800000ULL, 0x000000065cff7212ULL, 0x080fe4000782c0ffULL,
0x000000063cff7212ULL, 0x080fe4000786c0ffULL, 0x0000000646ff7212ULL, 0x000fe4000788c0ffULL,
0x000000115aff7212ULL, 0x080fe4000784c0ffULL, 0x000000115cff7212ULL, 0x000fc4000780c0ffULL,
0x000000113cff7212ULL, 0x080fe400078cc0ffULL, 0x0000001146ff7212ULL, 0x000fe400078ac0ffULL,
0x000000344900720cULL, 0x080fe40001741470ULL, 0x000000345b00720cULL, 0x0c0fe40000f21470ULL,
0x000000345b00720cULL, 0x080fe40000701470ULL, 0x000000346d00720cULL, 0x000fc40001f61470ULL,
0x000000346d00720cULL, 0x080fe400037c1470ULL, 0x000000343600720cULL, 0x0c0fe40002781470ULL,
0x000000343600720cULL, 0x080fe40002fa1470ULL, 0x000000344100720cULL, 0x080fe40001741070ULL,
0x000000345900720cULL, 0x0c0fe40000f21070ULL, 0x000000345900720cULL, 0x000fc40000701070ULL,
0x000000345700720cULL, 0x0c0fe40001f61070ULL, 0x000000345700720cULL, 0x080fe400037c1070ULL,
0x000000344d00720cULL, 0x0c0fe40002781070ULL, 0x000000344d00720cULL, 0x000fe40002fa1070ULL,
0xff8000002a2a7808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40001800000ULL,
0xff80000023237808ULL, 0x000fe40002000000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff80000018187808ULL, 0x000fe40000000000ULL, 0xff80000019197808ULL, 0x000fe40003000000ULL,
0xff8000001a1a7808ULL, 0x000fc40002800000ULL, 0x000000170800720bULL, 0x004fe40003f1e000ULL,
0x0000001c0900720bULL, 0x000fc40003f3e000ULL, 0x0000000817077208ULL, 0x000fe40004000000ULL,
0x000000091c067208ULL, 0x000fe40004800000ULL, 0x000000240700720bULL, 0x000fe40003f1e000ULL,
0x0000001b0600720bULL, 0x000fe40003f3e000ULL, 0x0000000724087208ULL, 0x000fe40004000000ULL,
0x000000061b067208ULL, 0x000fc40004800000ULL, 0x000000250800720bULL, 0x000fe40003f1e000ULL,
0x0000001d0600720bULL, 0x000fe40003f3e000ULL, 0x0000000825077208ULL, 0x000fe40004000000ULL,
0x000000061d067208ULL, 0x000fe40004800000ULL, 0x0000002e0700720bULL, 0x000fe40003f1e000ULL,
0x0000002f0600720bULL, 0x000fc40003f3e000ULL, 0x000000072e087208ULL, 0x000fe40004000000ULL,
0x000000062f067208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x0000001f0600720bULL, 0x000fe40003f3e000ULL, 0x000000082b077208ULL, 0x000fe40004000000ULL,
0x000000061f097208ULL, 0x000fc40004800000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x0000000726067208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fe40004800000ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fc40003f3e000ULL, 0x0000000627077208ULL, 0x000fe40004000000ULL,
0x0000000920067208ULL, 0x000fe40004800000ULL, 0x000000320700720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fe40003f3e000ULL, 0x0000000732077208ULL, 0x000fe40004000000ULL,
0x0000000631067208ULL, 0x000fc40004800000ULL, 0x000000300700720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fe40003f3e000ULL, 0x0000000730077208ULL, 0x000fe40004000000ULL,
0x0000000621097208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fe40003f1e000ULL,
0x000000160900720bULL, 0x000fc40003f3e000ULL, 0x0000000728067208ULL, 0x000fe40004000000ULL,
0x0000000916087208ULL, 0x000fe40004800000ULL, 0x000000290600720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x0000000629067208ULL, 0x000fe40004000000ULL,
0x0000000815077208ULL, 0x000fc40004800000ULL, 0x0000002d0600720bULL, 0x000fe40003f1e000ULL,
0x000000140700720bULL, 0x000fe40003f3e000ULL, 0x000000062d097208ULL, 0x000fe40004000000ULL,
0x0000000714067208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x000000130600720bULL, 0x000fc40003f3e000ULL, 0x000000092c097208ULL, 0x000fe40004000000ULL,
0x0000000613077208ULL, 0x000fe40004800000ULL, 0x0000002a0900720bULL, 0x000fe40003f1e000ULL,
0x000000180700720bULL, 0x000fe40003f3e000ULL, 0x000000092a097208ULL, 0x000fe40004000000ULL,
0x0000000718067208ULL, 0x000fc40004800000ULL, 0x000000220900720bULL, 0x000fe40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x0000000922087208ULL, 0x000fe40004000000ULL,
0x0000000619077208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0700720bULL, 0x000fc40003f3e000ULL, 0x00000008230e7208ULL, 0x000fe40004000000ULL,
0x000000071a107208ULL, 0x000fe20004800000ULL, 0x000016b27f007947ULL, 0x000fec000b800000ULL,
0x0c401f000e067f89ULL, 0x0004e400000e0000ULL, 0x000000060e00720bULL, 0x008fc80003f1e000ULL,
0x0000000e06347208ULL, 0x000fe20004000000ULL, 0x000016e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0010067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000e6800000e0000ULL, 0x0c201f0034097f89ULL, 0x000ea200000e0000ULL,
0x000000061000720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x010fe40003f3e000ULL,
0x00000010060c7208ULL, 0x000fe40004000000ULL, 0x0000000a070d7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL,
0x0000000b08067208ULL, 0x000fe20004000000ULL, 0x0c201f000d0e7f89ULL, 0x004ea200000e0000ULL,
0x000000093400720bULL, 0x000fc60003f1e000ULL, 0x0c201f0006077f89ULL, 0x0006e200000e0000ULL,
0x0000003409087208ULL, 0x000fe40004000000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000e0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c0f097208ULL, 0x000fe40004800000ULL,
0x0000000d0e0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080d7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000c12127812ULL, 0x000fc400078ec0ffULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080dULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080dULL, 0x000000070600720bULL, 0x004fe20003f3e000ULL,
0x00000024000f7308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001080dULL,
0x3fb8aa3b260b7823ULL, 0x100fe4000001080dULL, 0x3fb8aa3b27107823ULL, 0x100fe4000001080dULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080dULL, 0x00000017000c7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b2a247823ULL, 0x002fc4000001080dULL, 0x3fb8aa3b092a7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b28267823ULL, 0x000fe4000001080dULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL,
0x00000025000e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b2f2f7823ULL, 0x000fc4000001082aULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080dULL, 0x0000000b00347308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001080dULL, 0x0000000c0f0c723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b30257823ULL, 0x102fe4000001080dULL, 0x3fb8aa3b29277823ULL, 0x100fe4000001080dULL,
0x3fb8aa3b2d287823ULL, 0x100fe2000001080dULL, 0x0000001000177308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c0b7823ULL, 0x008fc4000001080dULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001080dULL,
0x3fb8aa3b23237823ULL, 0x000fe4000001080dULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL,
0x0000002e00117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b20207823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b31317823ULL, 0x000fc4000001082aULL,
0x3fb8aa3b152d7823ULL, 0x100fe2000001082aULL, 0x0000001c000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b13137823ULL, 0x000fca000001082aULL,
0x0000001b00107308ULL, 0x0004e20000000800ULL, 0x0000000e110e723eULL, 0x002fe200000000ffULL,
0x3c003c00ff117424ULL, 0x000fcc00078e00ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b161b7823ULL, 0x004fce000001082aULL, 0x0000002f002c7308ULL, 0x0002a20000000800ULL,
0x0000000d100d723eULL, 0x008fe200000000ffULL, 0x3c003c00ff107424ULL, 0x000fcc00078e00ffULL,
0x0000001f00297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b142f7823ULL, 0x002fe2000001082aULL,
0x0000001d2c0f723eULL, 0x004fcc00000000ffULL, 0x0000001e002e7308ULL, 0x0002b00000000800ULL,
0x0000003200327308ULL, 0x000ee20000000800ULL, 0x000000100c1c723cULL, 0x002f6e00000018ffULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000292e15723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b1a297823ULL, 0x000fcc000001082aULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x000000173216723eULL, 0x008fe400000000ffULL, 0x00000002ff327819ULL, 0x000fc80000011603ULL,
0x00000003321a7810ULL, 0x000fe20007ffe0ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x0000002b3414723eULL, 0x002fe200000000ffULL, 0x00000008322b7824ULL, 0x040fe200078e00ffULL,
0x00000004322e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000832347824ULL, 0x040fe400078e00ffULL,
0x0000000832337824ULL, 0x040fe400078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000000832357824ULL, 0x000fc400078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee22eULL,
0x00000008322e7824ULL, 0x040fe400078e00ffULL, 0x0000000832377824ULL, 0x040fe200078e00ffULL,
0x000000203117723eULL, 0x004fe200000000ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19207823ULL, 0x000fe2000001082aULL, 0x0000000232197810ULL, 0x040fe20007ffe0ffULL,
0x0000000832317824ULL, 0x000fc600078e00ffULL, 0x00000010141c723cULL, 0x020f64000000181cULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0xfffffff831317812ULL, 0x000fce00078ee21aULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000001b002c7308ULL, 0x0004e20000000800ULL, 0x00000027281a723eULL, 0x002fe200000000ffULL,
0x0000000832277824ULL, 0x040fe200078e00ffULL, 0x0000000632287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe200078ee232ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b181b7823ULL, 0x004fe2000001082aULL, 0x0000000132187810ULL, 0x000fe40007ffe0ffULL,
0xfffffff835357812ULL, 0x000fe400078ee228ULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee218ULL,
0x0000002f00307308ULL, 0x0002a20000000800ULL, 0x000000252618723eULL, 0x000fce00000000ffULL,
0x0000001b002a7308ULL, 0x0005e20000000800ULL, 0xfffffff8342f7812ULL, 0x002fe400078ee219ULL,
0x000000212c19723eULL, 0x008fe400000000ffULL, 0x0000000532217810ULL, 0x040fe40007ffe0ffULL,
0xffffffff322c7810ULL, 0x000fe20007ffe0ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x0000002d301b723eULL, 0x004fe400000000ffULL, 0xfffffff82e2d7812ULL, 0x000fc400078ee221ULL,
0xfffffff837377812ULL, 0x000fc600078ee22cULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000010181c723cULL, 0x020f6e000000181cULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000222322723eULL, 0x002fce00000000ffULL,
0x0000001300137308ULL, 0x000e700000000800ULL, 0x0000002000257308ULL, 0x0005f00000000800ULL,
0x0000002900267308ULL, 0x0007220000000800ULL, 0x0000000832207810ULL, 0x004fc40007ffe0ffULL,
0x000000132a21723eULL, 0x002fc600000000ffULL, 0x0000000820397824ULL, 0x000fca00078e00ffULL,
0xfffffff839297812ULL, 0x008fe400078ee220ULL, 0x0000000b2420723eULL, 0x000fe400000000ffULL,
0x0001100002247811ULL, 0x000fe400078e58ffULL, 0x000000252623723eULL, 0x010fe400000000ffULL,
0x00000006070b7208ULL, 0x000fe20004800000ULL, 0x0000001027277824ULL, 0x100fe400078e0224ULL,
0x000000102b2b7824ULL, 0x000fc400078e0224ULL, 0x00000010201c723cULL, 0x020f62000000181cULL,
0x000000102f2f7824ULL, 0x100fe400078e0224ULL, 0x0000001031317824ULL, 0x100fe400078e0224ULL,
0x0000001033337824ULL, 0x000fe400078e0224ULL, 0x0000000127277824ULL, 0x000fe400078e0212ULL,
0x000000102d2d7824ULL, 0x100fe400078e0224ULL, 0x00000001122b7824ULL, 0x000fe200078e022bULL,
0x0000000c27007388ULL, 0x0003e20000000800ULL, 0x0000001035357824ULL, 0x000fc400078e0224ULL,
0x00000001122f7824ULL, 0x040fe200078e022fULL, 0x0000000e2b007388ULL, 0x0003e20000000800ULL,
0x0000001037377824ULL, 0x100fe400078e0224ULL, 0x0000000112317824ULL, 0x040fe200078e0231ULL,
0x000000142f007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e0224ULL,
0x0000000112337824ULL, 0x040fe200078e0233ULL, 0x0000001631007388ULL, 0x0003e20000000800ULL,
0x00000001122d7824ULL, 0x000fc400078e022dULL, 0x0000000112357824ULL, 0x040fe200078e0235ULL,
0x0000001833007388ULL, 0x0003e20000000800ULL, 0x0000000112377824ULL, 0x040fe400078e0237ULL,
0x0000000112127824ULL, 0x000fe200078e0229ULL, 0x0000001a2d007388ULL, 0x0003e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0000002035007388ULL, 0x0003e80000000800ULL,
0x0000002237007388ULL, 0x0003e80000000800ULL, 0x0000000d12007388ULL, 0x0003e80000000800ULL,
0x0004000f2b007388ULL, 0x0003e80000000800ULL, 0x000400152f007388ULL, 0x0003e80000000800ULL,
0x0004001731007388ULL, 0x0003e80000000800ULL, 0x0004001933007388ULL, 0x0003e80000000800ULL,
0x0004001b2d007388ULL, 0x0003e80000000800ULL, 0x0004002135007388ULL, 0x0003e80000000800ULL,
0x0004002337007388ULL, 0x0003e80000000800ULL, 0x0170000805008388ULL, 0x0003e80000000c00ULL,
0x0172001c05008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000076ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080076ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000160607810ULL, 0x000fe20007ffe0ffULL, 0x0000180076ff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff057224ULL, 0x002fe200078e0063ULL, 0x000000756000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaa2000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00013c7000347802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x002fea0003c00000ULL, 0xfffeea0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00013cc000347802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0013ULL, 0xfffeea3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0012ULL, 0x00013d3000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000e2000007944ULL, 0x002fea0003c00000ULL, 0xfffeeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0012ULL, 0x00013d9000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x002fea0003c00000ULL, 0xfffeebf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0004ULL, 0x00013e0000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0005ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0013ULL, 0xfffeefe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0004ULL, 0x00013e7000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0013ULL,
0xfffeefa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00013ed000347802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x002fea0003c00000ULL, 0xffff0e9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00013f2000347802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e0013ULL, 0xffff0ec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0x00013f9000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xffff0f8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0x00013ff000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x002fea0003c00000ULL, 0xffff108000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x0001406000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e000fULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0013ULL, 0xffff148000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x000140d000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0013ULL,
0xffff144000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001413000347802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x002fea0003c00000ULL, 0xffff32e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0001418000347802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e0013ULL, 0xffff331000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e003eULL, 0x000141f000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x002fea0003c00000ULL, 0xffff33e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e003eULL, 0x0001425000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000090000007944ULL, 0x002fea0003c00000ULL, 0xffff34e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x000142c000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0022ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0013ULL, 0xffff38e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x0001433000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0013ULL,
0xffff38a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x004fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001439000347802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x008fea0003c00000ULL, 0xffff569000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x000143e000347802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0013ULL, 0xffff56d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0000ULL, 0x0001445000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x008fea0003c00000ULL, 0xffff579000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0000ULL, 0x000144b000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x00afea0003c00000ULL, 0xffff589000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000aULL, 0x0001452000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e000fULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0013ULL, 0xffff5cd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000aULL, 0x0001459000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0013ULL,
0xffff5c9000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00014600000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffe8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00014680000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00014700000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00014780000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x00014800000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00014880000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00014900000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00014980000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe6e000007947ULL, 0x000fea000383ffffULL, 0x0180000011007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff11ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000011027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffeb4f002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0007ULL,
0xfffeb4b00c007950ULL, 0x000fea0003c3ffffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0000001334137389ULL, 0x0002a400000e0037ULL, 0x000000ffff347224ULL, 0x002fc400078e0035ULL,
0x00000000ff357424ULL, 0x000fc800078e00ffULL, 0xfffeb46034007950ULL, 0x000fea0003c3ffffULL,
0x000000011300780cULL, 0x000fe20003f45070ULL, 0x0000003500007348ULL, 0x000fd80003800000ULL,
0x0000000000137806ULL, 0x000fc800050e0100ULL, 0x0000003513137212ULL, 0x000fe200078ec0ffULL,
0x00000000ff357424ULL, 0x000fc800078e00ffULL, 0xfffeb40034007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000360ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d50ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e10ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001684ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000014d00ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016580ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000165d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016950ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001680ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014f00ULL, 0x0000000000014f00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016950ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin_len = 92720;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
