/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012e78ULL, 0x00000000000129f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x00000000000118b0ULL, 0x0000000000000250ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000011b00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000118b000000000ULL, 0x0000500400000000ULL, 0x0400288080810c00ULL, 0x00000000000045d0ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8016288080850828ULL, 0x0000000310288082ULL,
0x8085920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL,
0x000118b000000000ULL, 0x0000025000000000ULL, 0x00002c0400000000ULL, 0x8082288080820900ULL,
0x090000003c042880ULL, 0x2880808228808085ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x000089c000183104ULL, 0x00010d1000008f80ULL, 0x00010d3000010d20ULL,
0x00fc290400010d40ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001205000009ULL, 0x0500000905000012ULL, 0x0500000905000009ULL, 0x0500002f0500002fULL,
0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL,
0x00fc28040500002fULL, 0x00000120000000b0ULL, 0x00002cc000001ab0ULL, 0x00002df000002d90ULL,
0x0000336000002e20ULL, 0x00003670000033a0ULL, 0x00004360000042c0ULL, 0x00004400000043e0ULL,
0x0000476000004730ULL, 0x000055a000004a20ULL, 0x000056d000005650ULL, 0x00005ab0000056f0ULL,
0x00005d1000005ac0ULL, 0x0000683000006780ULL, 0x000068e0000068c0ULL, 0x00006c1000006c00ULL,
0x00006f9000006f80ULL, 0x00008f80000089c0ULL, 0x0000945000009420ULL, 0x00009a5000009a30ULL,
0x0001064000010630ULL, 0x0001066000010650ULL, 0x000106b000010690ULL, 0x000106e0000106d0ULL,
0x00010d2000010d00ULL, 0x00010d7000010d30ULL, 0x00010d9000010d80ULL, 0x00011440000113b0ULL,
0x00011500000114a0ULL, 0x000115d000011570ULL, 0x0001169000011630ULL, 0x000117d000011730ULL,
0x01f0390400011870ULL, 0x000000ff00000190ULL, 0x000501000001b600ULL, 0x0000000000000270ULL,
0x003f01000001b608ULL, 0x0000000000000380ULL, 0x003f01000001b688ULL, 0x000000ff00000640ULL,
0x000701070001b600ULL, 0x00000005000007c0ULL, 0x000701010001b688ULL, 0x0000000f00002bb0ULL,
0x001101010001b608ULL, 0x0000000d00002bf0ULL, 0x001101090001b608ULL, 0x0000001100003620ULL,
0x000701010001b688ULL, 0x0000000f000041a0ULL, 0x001101010001b628ULL, 0x0000000f00004200ULL,
0x001101090001b628ULL, 0x00000011000049d0ULL, 0x000701010001b690ULL, 0x0000000f00005500ULL,
0x001101010001b648ULL, 0x0000000f00005540ULL, 0x001101090001b648ULL, 0x0000001100005cb0ULL,
0x000701010001b698ULL, 0x00000005000066f0ULL, 0x001101010001b668ULL, 0x0000000500006730ULL,
0x001101090001b668ULL, 0x0000000300006c80ULL, 0x000701010001b6a0ULL, 0x000000ff0000a310ULL,
0x000701010001b600ULL, 0x000000ff0000c0a0ULL, 0x000701090001b600ULL, 0x000000ff0000fc60ULL,
0x000401010001b688ULL, 0x000000ff0000fcb0ULL, 0x000401090001b688ULL, 0x00000003000110a0ULL,
0x003f01010001b608ULL, 0x00000003000110b0ULL, 0x003f01010001b610ULL, 0x00000003000110c0ULL,
0x003f01010001b618ULL, 0x00000003000110d0ULL, 0x003f01010001b620ULL, 0x000000ff00011100ULL,
0x002601090001b608ULL, 0x000000ff00011160ULL, 0x002601090001b628ULL, 0x000000ff000111c0ULL,
0x002601090001b648ULL, 0x000000ff00011220ULL, 0x002601090001b668ULL, 0x000000ff00011280ULL,
0x000701090001b600ULL, 0x00000005000112f0ULL, 0x003f01090001b688ULL, 0x00141c0400033803ULL,
0x0000a2e00000a070ULL, 0x0000c1200000c0d0ULL, 0x000c0504000110f0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000000f00080a04ULL, 0x0004360400580210ULL,
0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000ccULL,
0x0000000e00000002ULL, 0x00000000000118b0ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x00000000000000a5ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000eae0000002100ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000000000067919ULL, 0x000f220000002300ULL, 0x0000000000077919ULL, 0x000f2a0000002200ULL,
0x00008800ff027b82ULL, 0x000f700000000a00ULL, 0x00000000000479c3ULL, 0x000f700000002700ULL,
0x00000000000979c3ULL, 0x000f620000002600ULL, 0x00000005ff5d7e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff057819ULL, 0x004fcc0000011609ULL, 0x00001fff05057589ULL, 0x000ea200000e0000ULL,
0x0000000106007824ULL, 0x010fc800078e0207ULL, 0x0000008000047824ULL, 0x000fca00078e0209ULL,
0x000000ff0400720cULL, 0x040fe40003f05270ULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000030400780cULL, 0x000fe40003f44070ULL, 0x00000000051b72caULL, 0x004fe400000e0000ULL,
0x00001fff06057589ULL, 0x0004ea00000e0000ULL, 0x0000000000240947ULL, 0x022ff00003800000ULL,
0x00000000000679c3ULL, 0x000e620000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065406057896ULL, 0x002fc60008000005ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e6e0000000000ULL, 0x01b60006053f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000679c3ULL, 0x000e620000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffe000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x002fc60008000005ULL, 0x001fff8000067882ULL, 0x000fc60000000000ULL,
0x0000000504007c11ULL, 0x000fe2000f8e18ffULL, 0x0000000000007918ULL, 0x004fcc0000000000ULL,
0x00000000000512caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01b60806053f75b2ULL, 0x0043300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000679c3ULL, 0x002e620000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7ffb000000077882ULL, 0x000fe20000000000ULL, 0x0000065406057896ULL, 0x002fc60008000005ULL,
0x001ffec000067882ULL, 0x000fc60000000000ULL, 0x0000000504007c11ULL, 0x000fe2000f8e18ffULL,
0x0000000000007918ULL, 0x004fcc0000000000ULL, 0x00000000000512caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b68806053f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000207919ULL, 0x000f220000000000ULL, 0x00000000000879c3ULL, 0x000f620000008800ULL,
0x0000001b05007c11ULL, 0x008fe2000f8e10ffULL, 0x0000040000077882ULL, 0x002fe20000000000ULL,
0x0000007f0400780cULL, 0x000fe20003f04070ULL, 0x00008400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000000309057899ULL, 0x000fe2000800063fULL, 0x0000000200007824ULL, 0x000fe200078e00ffULL,
0x000000030d067899ULL, 0x000fe2000800063fULL, 0x0000820000187ab9ULL, 0x000fc60000000a00ULL,
0x0000000800077848ULL, 0x000fe20007fe0000ULL, 0x00000004060572a4ULL, 0x000fc8000f8e0205ULL,
0x0000000107077824ULL, 0x000fe200078e0a00ULL, 0x0000065408077896ULL, 0x020fcc0008000007ULL,
0x0000000704048c11ULL, 0x000fe4000f8e10ffULL, 0x00000004ff067819ULL, 0x014fc80000011620ULL,
0x000000070600720cULL, 0x000fe20003f26070ULL, 0xff317217ff078424ULL, 0x000fe400078e00ffULL,
0x0000000100087824ULL, 0x000fe400078e0206ULL, 0x0000001020007824ULL, 0x000fe200078e00ffULL,
0x01b4000704008388ULL, 0x0003e20000000800ULL, 0x0000000508097c36ULL, 0x040fe20008000000ULL,
0x00000007080a7812ULL, 0x000fe200078ec0ffULL, 0x0001b60007057890ULL, 0x000fe2000fffe03fULL,
0x000000f0000b7812ULL, 0x000fe200078ec0ffULL, 0x0000010009027825ULL, 0x000fe200078e0002ULL,
0x0000000f0a097812ULL, 0x000fe200078e7820ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000b02027210ULL, 0x000fc60007f5e0ffULL, 0x0000001008097824ULL, 0x000fe400078e0209ULL,
0x000000ffff037224ULL, 0x000fc600010e0603ULL, 0x0000000709097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000c901c58ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200405ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a85ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x00000004040a78a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff027e24ULL, 0x002fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fca000f8e00ffULL,
0x0000001802027981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000300001e7ab9ULL, 0x000fe20000000800ULL, 0x00000000022272caULL, 0x004fda00000e0000ULL,
0x0000003f22087890ULL, 0x000fe4000fffe03fULL, 0x000000ff22057890ULL, 0x000fe4000fffe03fULL,
0x000000063f087899ULL, 0x000fe40008011608ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x0000009800e88947ULL, 0x000ff60003800000ULL, 0x000000005d0e72caULL, 0x000fe200000e0000ULL,
0x000000023f1f7899ULL, 0x000fe2000801161bULL, 0x00000004ff007424ULL, 0x000fe200078e00ffULL,
0x000000031b237899ULL, 0x000fe4000800063fULL, 0x03ffffff1f067892ULL, 0x000fc8000f8ec03fULL,
0x00000023ff057e24ULL, 0x000fc8000f8e00ffULL, 0x000000060e0c7291ULL, 0x000fe2000f8e103fULL,
0x01b6880005ff79a7ULL, 0x0003e60008500007ULL, 0x000000080c00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000104068899ULL, 0x000fe2000800063fULL,
0x00009000000a8ab9ULL, 0x000fc60000000800ULL, 0x0000000a060682a4ULL, 0x000fc6000f8e020aULL,
0x00008c00000a8ab9ULL, 0x000fe20000000a00ULL, 0x000000060c068290ULL, 0x000fc8000fffe03fULL,
0x00000004060a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001802028981ULL, 0x000ea2000c1e1900ULL,
0x000000015d007836ULL, 0x002fe20000000000ULL, 0x000000013f067899ULL, 0x000fe2000801161bULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x0000000609097899ULL, 0x000fe4000800063fULL,
0x0000000506207899ULL, 0x000fe4000800063fULL, 0x000000011b217892ULL, 0x000fe4000f8ec03fULL,
0x000000200e0b7291ULL, 0x000fc8000f8e403fULL, 0x0000002009107892ULL, 0x000fe2000f8ef80bULL,
0x00000000020f82caULL, 0x004fe400000e0000ULL, 0x0000000500007c0cULL, 0x000fd6000bf06070ULL,
0x0000000f000a8c82ULL, 0x000fe40008000000ULL, 0x0000000d0a0a72a4ULL, 0x000fc8000f8e023fULL,
0x000000060a0d7899ULL, 0x000fe2000800063fULL, 0x0000000400dc8947ULL, 0x000ff60003800000ULL,
0x00000003ff0f7819ULL, 0x000fe20000011620ULL, 0x0000000b2200728cULL, 0x000fe4000bf01070ULL,
0x8000000bff007e24ULL, 0x000fe2000f8e02ffULL, 0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000040f057836ULL, 0x040fe20000000000ULL, 0x0000000b220a7287ULL, 0x000fe2000c000000ULL,
0x000000080f077836ULL, 0x000fe20000000000ULL, 0x00000003210b7899ULL, 0x000fe2000800063fULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000002005027212ULL, 0x000fe200078e3cffULL,
0x00000008070b7824ULL, 0x000fc400078e00ffULL, 0x0000000aff037e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff809127812ULL, 0x000fe200078ee202ULL, 0x0000000c0f097836ULL, 0x000fe20000000000ULL,
0x0000002007027212ULL, 0x000fe200078e3cffULL, 0x000000100f117836ULL, 0x000fe20000000000ULL,
0x0000002003007446ULL, 0x000fe20003800000ULL, 0x000000140f177836ULL, 0x040fe20000000000ULL,
0xfffffff80b147812ULL, 0x000fe200078ee202ULL, 0x000000100f027c36ULL, 0x000fe20008000000ULL,
0x0000002009037212ULL, 0x0c0fe200078e3cffULL, 0x0000000809167824ULL, 0x000fe200078e00ffULL,
0x0000002011047212ULL, 0x0c0fe200078e3cffULL, 0x00000008110d7824ULL, 0x000fe200078e00ffULL,
0x0000000d02087c10ULL, 0x000fe2000ff1e0ffULL, 0x000000180f197836ULL, 0x000fe20000000000ULL,
0x0000002017067212ULL, 0x0c0fe200078e3cffULL, 0x0000000817137824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x0000001c0f1d7836ULL, 0x000fe20000000000ULL,
0xfffffff80d187812ULL, 0x000fe200078ee204ULL, 0x00000008190a7824ULL, 0x040fe200078e00ffULL,
0x0000002019037212ULL, 0x080fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x0000000e08027c11ULL, 0x040fe2000f8040ffULL, 0x0000001005047c36ULL, 0x000fe20008000000ULL,
0xfffffff8131a7812ULL, 0x000fe200078ee206ULL, 0x000000081d0d7824ULL, 0x040fe200078e00ffULL,
0x000000201d067212ULL, 0x000fe200078e3cffULL, 0x00000007060a7291ULL, 0x000fe2000f8e703fULL,
0xfffffff80a1b7812ULL, 0x000fe200078ee203ULL, 0x00000010170a7c36ULL, 0x000fe20008000000ULL,
0x0000000f08037c11ULL, 0x000fe200080f440bULL, 0x0000000a210a7291ULL, 0x000fe2000f8e683fULL,
0x000000000700720cULL, 0x0c0fe20003f26070ULL, 0x0000001007077c36ULL, 0x000fe20008000000ULL,
0x0000000d04087c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000bff137e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee206ULL, 0x0000001009067c36ULL, 0x000fe20008000000ULL,
0x000000000500720cULL, 0x000fe20003f06070ULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x0000000d07077c10ULL, 0x000fe2000ff9e0ffULL, 0x000130000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000000e08047c11ULL, 0x000fc4000f8640ffULL, 0x0000000d060c7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x000000000900720cULL, 0x000fe20003f46070ULL,
0x0000001011097c36ULL, 0x000fe20008000000ULL, 0x0000000f08057c11ULL, 0x000fe200098f4405ULL,
0x000000ffff0d7224ULL, 0x000fe200028e06ffULL, 0x0000000e07067c11ULL, 0x040fe4000f8640ffULL,
0x0000000e0c087c11ULL, 0x000fe4000f8840ffULL, 0x0000000f07077c11ULL, 0x000fc400098f440eULL,
0x0000000d090b7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000f0c097c11ULL, 0x000fe4000a0f440dULL,
0x0000000d0a0d7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000000e0b0a7c11ULL, 0x000fe4000f8640ffULL, 0x000000000f00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x0000000e0d0c7c11ULL, 0x000fc4000f8840ffULL,
0x0000000f0b0b7c11ULL, 0x000fe200098f4410ULL, 0x000000101d107c36ULL, 0x000fe20008000000ULL,
0x0000000f0d0d7c11ULL, 0x000fe2000a0f440eULL, 0x00000010190e7c36ULL, 0x000fe20008000000ULL,
0x000000070f0f7812ULL, 0x000fe400078e4820ULL, 0x0000000d101e7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000d0e1f7c10ULL, 0x000fe4000ff7e0ffULL, 0x0ffffff80f0f7812ULL, 0x000fc400078ef820ULL,
0xfffffff813137812ULL, 0x000fe200078ee220ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000000e1f0e7c11ULL, 0x000fe4000f8c40ffULL, 0x0000000a0f157c11ULL, 0x000fe2000f8e20ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x000000001100720cULL, 0x080fe40003f66070ULL,
0x0000000f1f0f7c11ULL, 0x000fe2000b0f4410ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x0000000e1e107c11ULL, 0x040fe2000f8840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000e901c58ULL, 0x000000001700720cULL, 0x000fe20003fc6070ULL,
0x0000001013047825ULL, 0x000fe200078e0004ULL, 0x0000000f1e117c11ULL, 0x000fc4000a0f4411ULL,
0x000000001900720cULL, 0x080fe20003fa6070ULL, 0x0000001013067825ULL, 0x000fe200078e0006ULL,
0x000000001d00720cULL, 0x000fe40003f86070ULL, 0x0000000a12177c11ULL, 0x000fe2000f8e20ffULL,
0x0000001013087825ULL, 0x040fe200078e0008ULL, 0x0000000a14197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a1a157c11ULL, 0x002fe2000f8e20ffULL, 0x0000001013027825ULL, 0x000fe200078e000cULL,
0x0000000004177faeULL, 0x0003e2000c101c58ULL, 0x0000000a1b1b7c11ULL, 0x000fc4000f8e20ffULL,
0x00000010130c7825ULL, 0x040fe200078e000eULL, 0x0000000006197faeULL, 0x0003e2000c901c58ULL,
0x0000000a1c1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000010130e7825ULL, 0x000fe200078e0010ULL,
0x0000000a16117c11ULL, 0x000fc6000f8e20ffULL, 0x00000010130a7825ULL, 0x000fe200078e000aULL,
0x0000000a18137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008117faeULL, 0x0003e8000d101c58ULL,
0x000000000a137faeULL, 0x0003e8000d901c58ULL, 0x0000000002157faeULL, 0x0003e8000f101c58ULL,
0x000000000c1b7faeULL, 0x0003e8000e901c58ULL, 0x000000000e1d7faeULL, 0x0003e2000e101c58ULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011620ULL,
0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL, 0x00000007060a7291ULL, 0x000fe4000f8e703fULL,
0x00000003210b7899ULL, 0x000fe2000800063fULL, 0x0000000400057836ULL, 0x040fe20000000000ULL,
0x0000000a210a7291ULL, 0x000fe2000f8e683fULL, 0x0000000800067836ULL, 0x000fe40000000000ULL,
0x0000000805077824ULL, 0x040fe200078e00ffULL, 0x0000002005027212ULL, 0x080fe200078e3cffULL,
0x0000000806147824ULL, 0x040fe200078e00ffULL, 0x0000002006037212ULL, 0x080fe200078e3cffULL,
0x0000000c00087836ULL, 0x040fe20000000000ULL, 0xfffffff807127812ULL, 0x000fe200078ee202ULL,
0x00000010000b7836ULL, 0x000fe20000000000ULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x0000000808077824ULL, 0x040fe200078e00ffULL, 0x0000002008027212ULL, 0x080fe200078e3cffULL,
0x000000080b187824ULL, 0x040fe200078e00ffULL, 0x000000200b037212ULL, 0x080fe200078e3cffULL,
0x00000014000c7836ULL, 0x040fe20000000000ULL, 0xfffffff807167812ULL, 0x000fe200078ee202ULL,
0x00000018000d7836ULL, 0x000fe20000000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee203ULL,
0x000000080c0a7824ULL, 0x040fe200078e00ffULL, 0x000000200c037212ULL, 0x080fe200078e3cffULL,
0x0000001000027c36ULL, 0x040fe20008000000ULL, 0x000000200d047212ULL, 0x0c0fe200078e3cffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee203ULL,
0x0000001c000e7836ULL, 0x000fe20000000000ULL, 0x0000000d02037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001006067c36ULL, 0x000fe20008000000ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL,
0x000000080e0a7824ULL, 0x040fe200078e00ffULL, 0x000000200e077212ULL, 0x000fe200078e3cffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000e03027c11ULL, 0x000fe2000f8040ffULL,
0x0000001005057c36ULL, 0x000fe20008000000ULL, 0xfffffff80a1f7812ULL, 0x000fe200078ee207ULL,
0x0000001008097c36ULL, 0x000fe20008000000ULL, 0x0000000f03037c11ULL, 0x000fe200080f4404ULL,
0x000000100b0b7c36ULL, 0x000fe20008000000ULL, 0x0000000d06077c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100c0c7c36ULL, 0x000fe20008000000ULL, 0x0000000d05057c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100e0e7c36ULL, 0x000fe20008000000ULL, 0x0000000d09097c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000000e07067c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000e05047c11ULL, 0x000fe2000f8040ffULL,
0x000130000a0a7890ULL, 0x000fe2000fffe03fULL, 0x0000000f07077c11ULL, 0x000fe200088f440aULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000000f05057c11ULL, 0x000fe200080f4408ULL,
0x0000000bff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e09087c11ULL, 0x000fc4000f8040ffULL,
0x0000000700007812ULL, 0x000fe400078e4820ULL, 0x0000000f09097c11ULL, 0x000fe200080f440aULL,
0x000000100d0a7c36ULL, 0x000fe20008000000ULL, 0x0ffffff800007812ULL, 0x000fe400078ef820ULL,
0x0000000d0b0b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000d0c0d7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000d0a0f7c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000d0e117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0xfffffff813137812ULL, 0x000fe200078ee220ULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000000a00157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000000e0b0a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000000e0d0c7c11ULL, 0x000fe2000f8240ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x0000000e0f0e7c11ULL, 0x000fc4000f8440ffULL,
0x0000000e11107c11ULL, 0x000fe2000f8640ffULL, 0x0000001013047825ULL, 0x000fe200078e0004ULL,
0x0000000f0b0b7c11ULL, 0x000fe200080f4400ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c58ULL, 0x0000000f0d0d7c11ULL, 0x000fe200088f441aULL,
0x0000001013067825ULL, 0x000fe200078e0006ULL, 0x0000000f0f0f7c11ULL, 0x000fe400090f441cULL,
0x0000000f11117c11ULL, 0x000fe200098f441eULL, 0x0000001013087825ULL, 0x000fe200078e0008ULL,
0x0000000a12177c11ULL, 0x000fc4000f8e20ffULL, 0x0000000a14197c11ULL, 0x000fe2000f8e20ffULL,
0x00000010130a7825ULL, 0x000fe200078e000aULL, 0x0000000a1b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000004177faeULL, 0x0005e2000b901c58ULL, 0x0000000a16037c11ULL, 0x002fe2000f8e20ffULL,
0x00000010130c7825ULL, 0x000fe200078e000cULL, 0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000006197faeULL, 0x0005e2000b901c58ULL, 0x0000000a1f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010130e7825ULL, 0x040fe400078e000eULL, 0x0000000008037faeULL, 0x0005e4000b901c58ULL,
0x0000001013107825ULL, 0x000fe200078e0010ULL, 0x0000000a18137c11ULL, 0x000fca000f8e20ffULL,
0x000000000a137faeULL, 0x0005e8000b901c58ULL, 0x000000000c1b7faeULL, 0x0005e8000b901c58ULL,
0x000000000e1d7faeULL, 0x0005e8000b901c58ULL, 0x00000000101f7faeULL, 0x0005e4000b901c58ULL,
0x000000030c0a7892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd1e247891ULL, 0x000fe4000f8e103fULL, 0x000000030a00788cULL, 0x000fc8000bf05270ULL,
0x00000001240a7887ULL, 0x000fc8000c000000ULL, 0x0000000a0c0a7290ULL, 0x000fc8000fffe03fULL,
0x000000080a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001040b8899ULL, 0x000fe2000800063fULL, 0x00009000000c8ab9ULL, 0x000fc60000000800ULL,
0x0000000c0b0b82a4ULL, 0x000fc6000f8e020cULL, 0x00008c00000c8ab9ULL, 0x000fe20000000a00ULL,
0x0000000a0b0b8290ULL, 0x000fc8000fffe03fULL, 0x000000040b0c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff027e24ULL, 0x002fe4000f8e00ffULL, 0x0000000dff037e24ULL, 0x004fca000f8e00ffULL,
0x0000001802028981ULL, 0x000ea2000c1e1900ULL, 0xffffffff001a7882ULL, 0x000fe20000000000ULL,
0xff317217ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000020b82caULL, 0x004fc400000e0000ULL, 0x000000055d007c0cULL, 0x000fd6000bf06070ULL,
0x0000000b001a8c82ULL, 0x000fe40008000000ULL, 0x0000005400180947ULL, 0x000fea0003800000ULL,
0x00000001040b7899ULL, 0x000fe2000800063fULL, 0xff317217ff007424ULL, 0x000fe400078e00ffULL,
0x0000900000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x000000040b0b72a4ULL, 0x000fc6000f8e0204ULL, 0x0000003f00047c82ULL, 0x000fd20008000000ULL,
0x000001005d027824ULL, 0x000fca00078e00ffULL, 0x0000002202007c0cULL, 0x000fda000bf06070ULL,
0x0000005000e80947ULL, 0x000fea0003800000ULL, 0x000000005d0d72caULL, 0x040fe200000e0000ULL,
0x000000015d027836ULL, 0x000fe20000000000ULL, 0x0000000000227919ULL, 0x000e620000000000ULL,
0x000000041b0c7899ULL, 0x000fe2000800063fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0xffffffe00c0e7892ULL, 0x000fe2000f8ec03fULL, 0x0000000502007c0cULL, 0x000fe2000bf06070ULL,
0x0000000a00127c82ULL, 0x000fe20008000000ULL, 0x00008400000c7ab9ULL, 0x000fc60000000800ULL,
0x0000000e0d0e7291ULL, 0x000fe4000f8e403fULL, 0x0000000c1a1a72a4ULL, 0x000fe4000f8e023fULL,
0x000000400e107890ULL, 0x000fe4000fffe03fULL, 0x000000061a1a7899ULL, 0x000fe4000800063fULL,
0x0000002009137892ULL, 0x000fe2000f8ef810ULL, 0x00000004000d7c82ULL, 0x000fe20008000000ULL,
0x0000000400f48947ULL, 0x000ff40003800000ULL, 0x00000003ff027819ULL, 0x002fe20000011622ULL,
0x000000102200728cULL, 0x000fe4000bf01070ULL, 0x80000010ff0d7e24ULL, 0x000fe2000f8e02ffULL,
0x00008a00001c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000d1b167899ULL, 0x000fe2000800063fULL,
0x0000000402037836ULL, 0x040fe20000000000ULL, 0x00000010220f7287ULL, 0x000fe2000c000000ULL,
0x0000001002067836ULL, 0x000fe20000000000ULL, 0x0000000c04117899ULL, 0x000fe2000800063fULL,
0x0000000803057824ULL, 0x040fe200078e00ffULL, 0x0000002203567212ULL, 0x080fe200078e3cffULL,
0x00000008060a7824ULL, 0x040fe200078e00ffULL, 0x00000022065b7212ULL, 0x080fe200078e3cffULL,
0x0000000fff047e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff805567812ULL, 0x000fe200078ee256ULL,
0x0000000c02057836ULL, 0x040fe20000000000ULL, 0xfffffff80a5b7812ULL, 0x000fe200078ee25bULL,
0x0000001402077836ULL, 0x000fe20000000000ULL, 0x00000020040d7446ULL, 0x000fe2000380000dULL,
0x0000000802047836ULL, 0x000fe20000000000ULL, 0x00000022055c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x00000022075a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000804087824ULL, 0x040fe200078e00ffULL, 0x0000002204557212ULL, 0x080fe200078e3cffULL,
0x00000018020a7836ULL, 0x040fe20000000000ULL, 0xfffffff8095c7812ULL, 0x000fe200078ee25cULL,
0x0000001302097c36ULL, 0x040fe20008000000ULL, 0xfffffff808557812ULL, 0x000fe200078ee255ULL,
0x0000001c02087836ULL, 0x000fe20000000000ULL, 0x000000220a597212ULL, 0x0c0fe200078e3cffULL,
0x00000008070f7824ULL, 0x000fe200078e00ffULL, 0x0000001a090c7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000080a0e7824ULL, 0x000fe200078e00ffULL, 0x0000002208587212ULL, 0x040fe200078e3cffULL,
0x0000000808097824ULL, 0x000fe200078e00ffULL, 0xfffffff80f5a7812ULL, 0x000fe200078ee25aULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0xfffffff80e597812ULL, 0x000fe200078ee259ULL,
0x00000013050e7c36ULL, 0x000fe20008000000ULL, 0xfffffff809587812ULL, 0x000fe200078ee258ULL,
0x0000001303097c36ULL, 0x000fe20008000000ULL, 0x0000001c0c167c11ULL, 0x040fe2000f8240ffULL,
0x0000000321147899ULL, 0x000fe2000800063fULL, 0x0000001a0e0e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000706107291ULL, 0x000fe2000f8e703fULL, 0x0000001d0c177c11ULL, 0x000fe200088f440fULL,
0x00000013040c7c36ULL, 0x000fe20008000000ULL, 0x0000001a09127c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001306097c36ULL, 0x000fe20008000000ULL, 0x00002000160f7892ULL, 0x000fe2000f8ec03fULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x0000001a0c107c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000001c0e147c11ULL, 0x000fe2000f8640ffULL,
0x0000100011117892ULL, 0x000fe2000f8e0c3fULL, 0x0000001a090c7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000001307097c36ULL, 0x000fe20008000000ULL, 0x0000001c121a7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001d0e157c11ULL, 0x000fe200098f440fULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x0000001d121b7c11ULL, 0x000fe200088f4413ULL,
0x00000014ff1d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001c0c0e7c11ULL, 0x000fe2000f8240ffULL,
0x0000001011117290ULL, 0x000fe2000fffe00fULL, 0x0000001c10187c11ULL, 0x000fe2000f8440ffULL,
0x00000013081c7c36ULL, 0x000fe20008000000ULL, 0x0000001d0c0f7c11ULL, 0x000fe200088f440fULL,
0x0001300011117890ULL, 0x000fe2000fffe03fULL, 0x0000001a09097c10ULL, 0x000fc4000ff3e0ffULL,
0x0000001d10197c11ULL, 0x000fe400090f4411ULL, 0x0000002202117212ULL, 0x000fe200078e3cffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000001c09127c11ULL, 0x000fe4000f8240ffULL,
0x0000000711117812ULL, 0x000fe400078ec0ffULL, 0x0000001d09137c11ULL, 0x000fe200088f4410ULL,
0x000000130a107c36ULL, 0x000fe20008000000ULL, 0x00000007220c7812ULL, 0x000fc400078ec0ffULL,
0x0ffffff811577812ULL, 0x000fe400078ef822ULL, 0x0000001a10117c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000d0200720cULL, 0x080fe40003f26070ULL, 0x0000000d0300720cULL, 0x080fe20003f46070ULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x0000000d0400720cULL, 0x000fe40003f66070ULL,
0x000000081d097812ULL, 0x000fc400078ee20cULL, 0x0000001c11107c11ULL, 0x000fe4000f8840ffULL,
0x00000011571f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009167825ULL, 0x000fe200078e0016ULL,
0x0000001156217c11ULL, 0x000fe4000f8e20ffULL, 0x0000001155237c11ULL, 0x000fe2000f8e20ffULL,
0x00000010091a7825ULL, 0x000fe200078e001aULL, 0x0000001d11117c11ULL, 0x000fe2000a0f441eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161f7faeULL, 0x000fe2000c901c58ULL,
0x0000001a1c1d7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000001009187825ULL, 0x000fe200078e0018ULL,
0x0000000d0500720cULL, 0x080fe20003f26070ULL, 0x000000001a217faeULL, 0x0003e2000d101c58ULL,
0x0000000d0600720cULL, 0x080fe20003f46070ULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x0000001c1d1c7c11ULL, 0x000fe2000f8c40ffULL, 0x0000000018237faeULL, 0x0005e2000d901c58ULL,
0x0000000d0700720cULL, 0x080fe20003f66070ULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x0000000d0a00720cULL, 0x000fc40003f86070ULL, 0x0000000d0800720cULL, 0x000fe20003fa6070ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001d1d1d7c11ULL, 0x000fe4000b0f441eULL,
0x000000115c0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009127825ULL, 0x000fe200078e0012ULL,
0x000000115b1b7c11ULL, 0x002fe4000f8e20ffULL, 0x000000115a197c11ULL, 0x004fe2000f8e20ffULL,
0x0000001009107825ULL, 0x000fe200078e0010ULL, 0x00000011591f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000140d7faeULL, 0x0003e2000c901c58ULL, 0x0000001158217c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009167825ULL, 0x000fc400078e001cULL, 0x000000000e1b7faeULL, 0x0003e8000d101c58ULL,
0x0000000012197faeULL, 0x0003e8000d901c58ULL, 0x00000000101f7faeULL, 0x0003e8000e101c58ULL,
0x0000000016217faeULL, 0x0003e2000e901c58ULL, 0x0000000400bc7947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x002fe20000011622ULL, 0x00008a00001c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000321147899ULL, 0x000fe4000800063fULL, 0x0000000d1b167899ULL, 0x000fe2000800063fULL,
0x0000000402037836ULL, 0x040fe20000000000ULL, 0x0000000c04117899ULL, 0x000fe2000800063fULL,
0x0000000802047836ULL, 0x040fe20000000000ULL, 0x0000000706107291ULL, 0x000fe2000f8e703fULL,
0x0000000c02057836ULL, 0x000fe20000000000ULL, 0x0000002203567212ULL, 0x0c0fe200078e3cffULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0x0000002204557212ULL, 0x0c0fe200078e3cffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x00000022055c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff807567812ULL, 0x000fe200078ee256ULL,
0x0000001402077836ULL, 0x040fe20000000000ULL, 0xfffffff806557812ULL, 0x000fe200078ee255ULL,
0x0000001002067836ULL, 0x040fe20000000000ULL, 0xfffffff8095c7812ULL, 0x000fe200078ee25cULL,
0x00000018020a7836ULL, 0x000fe20000000000ULL, 0x00000022075a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x00000022065b7212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x000000220a597212ULL, 0x0c0fe200078e3cffULL,
0x000000080a0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8095a7812ULL, 0x000fe200078ee25aULL,
0x0000001c02087836ULL, 0x040fe20000000000ULL, 0xfffffff80c5b7812ULL, 0x000fe200078ee25bULL,
0x0000001302097c36ULL, 0x000fe20008000000ULL, 0xfffffff80e597812ULL, 0x000fe200078ee259ULL,
0x00000008080d7824ULL, 0x040fe200078e00ffULL, 0x0000002208587212ULL, 0x000fe200078e3cffULL,
0x00000013030c7c36ULL, 0x000fe20008000000ULL, 0x0000001a09097c10ULL, 0x000fe2000ff5e0ffULL,
0x00000013040e7c36ULL, 0x000fe20008000000ULL, 0xfffffff80d587812ULL, 0x000fe200078ee258ULL,
0x0000001305107c36ULL, 0x000fe20008000000ULL, 0x0000001a0c0d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000001a0e0f7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000014ff1b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001a10177c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x0000001c09147c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x0000001c0f107c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000001d09157c11ULL, 0x000fe200090f440cULL,
0x0000001306097c36ULL, 0x000fe20008000000ULL, 0x0000001c170e7c11ULL, 0x000fe2000f8240ffULL,
0x00000013070c7c36ULL, 0x000fe20008000000ULL, 0x0000001d0f117c11ULL, 0x000fe2000a0f4418ULL,
0x00002000160f7892ULL, 0x000fe2000f8ec03fULL, 0x0000001c0d127c11ULL, 0x000fe2000f8640ffULL,
0x0000100011117892ULL, 0x000fe2000f8e0c3fULL, 0x0000001d170f7c11ULL, 0x000fc400088f441aULL,
0x0000001a09097c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001011117290ULL, 0x000fe2000fffe00fULL,
0x0000001d0d137c11ULL, 0x000fe400098f4416ULL, 0x0000001a0c0d7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000001c09187c11ULL, 0x040fe2000f8240ffULL,
0x0001300011117890ULL, 0x000fe4000fffe03fULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x0000001d09197c11ULL, 0x000fc400088f440cULL, 0x0000001c0d167c11ULL, 0x040fe4000f8440ffULL,
0x0000002202097212ULL, 0x000fe400078e3cffULL, 0x0000001d0d177c11ULL, 0x000fe200090f441aULL,
0x000000130a0d7c36ULL, 0x000fe20008000000ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x00000013081a7c36ULL, 0x000fe20008000000ULL, 0x00000007220c7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff809577812ULL, 0x000fc400078ef822ULL, 0x000000081b097812ULL, 0x000fe400078ee20cULL,
0x0000001a0d1b7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001a1a207c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001009147825ULL, 0x000fe200078e0014ULL, 0x00000011570d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000011561f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000001c1b1c7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x0000001c201a7c11ULL, 0x040fe2000f8440ffULL, 0x0000001009127825ULL, 0x000fe200078e0012ULL,
0x0000001d1b1d7c11ULL, 0x000fe200088f441eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e2000b901c58ULL, 0x0000001155217c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009107825ULL, 0x040fe200078e0010ULL, 0x0000001d201b7c11ULL, 0x000fe200090f4423ULL,
0x00000000121f7faeULL, 0x0003e2000b901c58ULL, 0x000000115c237c11ULL, 0x000fe2000f8e20ffULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x000000115b297c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010217faeULL, 0x0003e2000b901c58ULL, 0x000000115a2b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009187825ULL, 0x000fe200078e0018ULL, 0x0000001159497c11ULL, 0x000fe2000f8e20ffULL,
0x000000000e237faeULL, 0x0003e2000b901c58ULL, 0x00000011584b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009167825ULL, 0x000fc400078e0016ULL, 0x0000000018297faeULL, 0x0003e4000b901c58ULL,
0x00000010091c7825ULL, 0x040fe400078e001cULL, 0x00000000162b7faeULL, 0x0003e4000b901c58ULL,
0x00000010091a7825ULL, 0x000fe400078e001aULL, 0x000000001c497faeULL, 0x0003e8000b901c58ULL,
0x000000001a4b7faeULL, 0x0003e4000b901c58ULL, 0x000000030a117892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000031100788cULL, 0x000fc8000bf05270ULL,
0x0000000124137887ULL, 0x000fc8000c000000ULL, 0x000000130a117290ULL, 0x000fc8000fffe03fULL,
0x000000081100728cULL, 0x000fe4000bf06070ULL, 0x0000000823257892ULL, 0x000fc8000f8ec03fULL,
0x000000000000781cULL, 0x000fca0003f2f008ULL, 0x000000130b118290ULL, 0x000fe2000fffe00aULL,
0x00008c0000148ab9ULL, 0x000fc60000000a00ULL, 0x00000004111488a5ULL, 0x000fe4000f8e0014ULL,
0xffffffe023117892ULL, 0x000fc8000f8ec03fULL, 0x00000014ff107e24ULL, 0x002fe2000f8e00ffULL,
0x0000001023147892ULL, 0x000fe2000f8ec03fULL, 0x00000015ff117e24ULL, 0x000fc6000f8e00ffULL,
0x0000000714117290ULL, 0x000fe2000fffe011ULL, 0x00000025ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001810619981ULL, 0x000362000c1e1900ULL, 0x00000001ff7c7424ULL, 0x000fe200078e00ffULL,
0x00000001ff787819ULL, 0x000fe20000011622ULL, 0x00000025ff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x000000071f147291ULL, 0x000fe2000f8e383fULL, 0x0000001022797824ULL, 0x000fe200078e00ffULL,
0x0000000c78787812ULL, 0x000fe200078ec0ffULL, 0x01b6087c0f0e79a7ULL, 0x000ea20008500011ULL,
0x0000002511267290ULL, 0x000fc4000fffe03fULL, 0x0000007079797812ULL, 0x000fc800078ec0ffULL,
0x00000014785e7c10ULL, 0x000fe2000fffe079ULL, 0x01b6080f0d0075a7ULL, 0x004ea40008040151ULL,
0x000000e4003ca947ULL, 0x006fea0003800000ULL, 0x01b000005e0d7984ULL, 0x000e620000000800ULL,
0x000000011b177899ULL, 0x000fe4000800063fULL, 0xffffc00016167892ULL, 0x000fe2000f8ec03fULL,
0x0000000000147919ULL, 0x000ea20000000000ULL, 0x0000000417147892ULL, 0x000fe2000f8ec03fULL,
0x01b200005e5e7984ULL, 0x000ee20000000800ULL, 0x00000004ff197819ULL, 0x004fe40000011614ULL,
0x000000080c6c7812ULL, 0x000fe400078ef814ULL, 0x000000000d00720bULL, 0x002fe20003f5d000ULL,
0x0000001419117c36ULL, 0x000fc80008000000ULL, 0x0000000211137836ULL, 0x000fd00000000000ULL,
0x00000000000e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0e127812ULL, 0x000fe2000784c0ffULL,
0x00000001ff0e7424ULL, 0x000fd800078e00ffULL, 0x0000000000e0a947ULL, 0x008fea0003800000ULL,
0x000000000d00720bULL, 0x000fe20003f54000ULL, 0x0000001b1f00728cULL, 0x000fe2000bf25270ULL,
0x0000000d00177209ULL, 0x000fe40007810000ULL, 0x00000002ff0f7819ULL, 0x000fc60000011614ULL,
0x80000017000e7221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fe20003f6f018ULL,
0x000000080f107836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fe20000410000ULL,
0x000000071b149291ULL, 0x000fe2000f8e383fULL, 0x0000000000007806ULL, 0x000fc800010e0100ULL,
0x0000ffff00157812ULL, 0x000fe200078e3cffULL, 0x0000000e000e7308ULL, 0x000e660000000800ULL,
0x0000001512ff7212ULL, 0x000fe4000784c0ffULL, 0x000000147800bc10ULL, 0x000fca000fffe079ULL,
0x01b400170000b388ULL, 0x0005e80000000800ULL, 0x00001f100e107589ULL, 0x002e6400000e0000ULL,
0x800000170d0d2221ULL, 0x100fe20000010000ULL, 0x0000000e0b0b7220ULL, 0x000fe20000410000ULL,
0x00001f0f0e0f7589ULL, 0x00072400000e0000ULL, 0x3fb8aa3b0d0d2820ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x004fc600078e0017ULL, 0x0000000d00542308ULL, 0x000ea20000000800ULL,
0x00000001ff0e7807ULL, 0x008fe20001000000ULL, 0x0000001027277220ULL, 0x082fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103f3f7220ULL, 0x080fe20000410000ULL,
0x000000103e3e7220ULL, 0x080fe20000410000ULL, 0x0000001043437220ULL, 0x080fe20000410000ULL,
0x0000001042427220ULL, 0x080fe20000410000ULL, 0x0000001047477220ULL, 0x080fe20000410000ULL,
0x0000001046467220ULL, 0x000fe20000410000ULL, 0x0000000f25257220ULL, 0x090fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f31317220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x080fe20000410000ULL, 0x0000000f35357220ULL, 0x080fe20000410000ULL,
0x0000000f34347220ULL, 0x080fe20000410000ULL, 0x0000000f39397220ULL, 0x080fe20000410000ULL,
0x0000000f38387220ULL, 0x080fe20000410000ULL, 0x0000000f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000f41417220ULL, 0x080fe20000410000ULL,
0x0000000f40407220ULL, 0x080fe20000410000ULL, 0x0000000f45457220ULL, 0x080fe20000410000ULL,
0x0000000f44447220ULL, 0x000fe20000410000ULL, 0x000000545e5e2220ULL, 0x004fce0000410000ULL,
0x0000000711117812ULL, 0x000fe200078e786cULL, 0x0000001607157290ULL, 0x000fe2000fffe03fULL,
0x0000000713137812ULL, 0x000fe200078e786cULL, 0x00000002190f7836ULL, 0x040fe20000000000ULL,
0x000000080c0c7812ULL, 0x000fe200078ef814ULL, 0x000000086c667824ULL, 0x040fe200078e0211ULL,
0x0000001521157291ULL, 0x000fe2000f8e683fULL, 0x000000086c6c7824ULL, 0x000fe200078e0213ULL,
0x000000071f277291ULL, 0x000fe2000f8e583fULL, 0x0000000419137836ULL, 0x040fe20000000000ULL,
0x0000001504167291ULL, 0x000fe2000f8e603fULL, 0x0000000619157836ULL, 0x000fe20000000000ULL,
0x00000007196f7812ULL, 0x000fe200078e780cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000070f117812ULL, 0x000fe200078e780cULL, 0x0001300016167890ULL, 0x000fe2000fffe03fULL,
0x0000000713137812ULL, 0x000fe200078e780cULL, 0x000000080c6a7824ULL, 0x040fe200078e026fULL,
0x0000000715157812ULL, 0x000fe200078e780cULL, 0x000000080c697824ULL, 0x000fe200078e0211ULL,
0x0000002766207c11ULL, 0x000fe2000f8e20ffULL, 0x000000080c687824ULL, 0x000fe200078e0213ULL,
0x000000166a507c11ULL, 0x000fe2000f8e20ffULL, 0x000000080c6b7824ULL, 0x000fe200078e0215ULL,
0x00000016694c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001021147291ULL, 0x000fe2000f8e683fULL,
0x011000002020783bULL, 0x000fe20000000200ULL, 0x0000001668487c11ULL, 0x000fe2000f8e20ffULL,
0x000000130a0a7290ULL, 0x000fe2000fffe03fULL, 0x000000166b287c11ULL, 0x000fe2000f8e20ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000002ff7b7819ULL, 0x000fe20000011614ULL,
0x00000014041a7291ULL, 0x000fe2000f8e603fULL, 0x00000054ff0d723eULL, 0x000fe200000000ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x000000800c707811ULL, 0x000fe200078e18ffULL,
0x000000087b7a7836ULL, 0x000fe20000000000ULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x000099100e0e7816ULL, 0x000fe200000000ffULL,
0x000130001a1a7890ULL, 0x000fe2000fffe03fULL, 0x000000276c0c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x000000016f6f7824ULL, 0x100fe200078e0270ULL,
0x000000ff0e00720cULL, 0x000fe20003f45270ULL, 0x00000001116e7824ULL, 0x100fe200078e0270ULL,
0x00001f7b0d5f7589ULL, 0x000e6200000e0000ULL, 0x00000001136d7824ULL, 0x100fe200078e0270ULL,
0x0000001a6f1c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000115707824ULL, 0x000fe200078e0270ULL,
0x00001f7a0d607589ULL, 0x000ea200000e0000ULL, 0x0000001a6e187c11ULL, 0x000fe2000f8e20ffULL,
0xfffffff817167892ULL, 0x000fe2000f8ec03fULL, 0x0000001a6d147c11ULL, 0x000fe2000f8e20ffULL,
0x011000000c0c783bULL, 0x000ee20000000200ULL, 0x0000001a70107c11ULL, 0x000fe2000f8e20ffULL,
0xffffffff001a7882ULL, 0x000fe20000000000ULL, 0x00000000611792caULL, 0x020fe200000e0000ULL,
0x000000001c1c783bULL, 0x000f220000004200ULL, 0x0000000104047892ULL, 0x000fe2000f8e0c3fULL,
0x0000000b5e0b7221ULL, 0x000fc40000010000ULL, 0x000000001818783bULL, 0x000f680000004200ULL,
0x000000001414783bULL, 0x000f280000004200ULL, 0x000000001010783bULL, 0x000f220000004200ULL,
0x0000005f2020a232ULL, 0x082fe20000000000ULL, 0x00000017001a8c82ULL, 0x000fe20008000000ULL,
0x0000005f2222a232ULL, 0x000fc40000000000ULL, 0x000000602121a232ULL, 0x084fe40000000000ULL,
0x000000602323a232ULL, 0x000fce0000000000ULL, 0x000000502044723cULL, 0x000fec0000001844ULL,
0x000000522040723cULL, 0x000fe20000001840ULL, 0x0000005f0c0ca232ULL, 0x008fca0000000000ULL,
0x0000004c203c723cULL, 0x000fe2000000183cULL, 0x0000005f0e0ea232ULL, 0x000fe40000000000ULL,
0x000000600d0da232ULL, 0x080fe40000000000ULL, 0x000000600f0fa232ULL, 0x000fe20000000000ULL,
0x0000004e2038723cULL, 0x000fec0000001838ULL, 0x000000482034723cULL, 0x000fec0000001834ULL,
0x0000004a2030723cULL, 0x000fec0000001830ULL, 0x00000028202c723cULL, 0x000fec000000182cULL,
0x0000002a2024723cULL, 0x000fec0000001824ULL, 0x0000001c0c44723cULL, 0x010fec0000001844ULL,
0x0000001e0c40723cULL, 0x000fec0000001840ULL, 0x000000180c3c723cULL, 0x020fec000000183cULL,
0x0000001a0c38723cULL, 0x000fec0000001838ULL, 0x000000140c34723cULL, 0x000fec0000001834ULL,
0x000000160c30723cULL, 0x000fec0000001830ULL, 0x000000100c2c723cULL, 0x000fec000000182cULL,
0x000000120c24723cULL, 0x000fe20000001824ULL, 0x00000016ff117e24ULL, 0x000fc8000f8e00ffULL,
0x01b6887c11ff79a7ULL, 0x0003e40008500007ULL, 0x000000405d0c7811ULL, 0x000fc800078e40ffULL,
0x000000220c007c0cULL, 0x000fda000bf26070ULL, 0x0000003400ec1947ULL, 0x002fea0003800000ULL,
0x000000800e0a7890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000c1a1a72a4ULL, 0x000fe4000f8e023fULL, 0x0000002009277892ULL, 0x000fe4000f8ef80aULL,
0x000000061a1a7899ULL, 0x000fe2000800063fULL, 0x0000000400548947ULL, 0x000ff60003800000ULL,
0x00000027020c7c36ULL, 0x000fe20008000000ULL, 0x0000000a2200728cULL, 0x000fe2000bf01070ULL,
0x00000027030d7c36ULL, 0x000fe40008000000ULL, 0x8000000aff1d7e24ULL, 0x000fe2000f8e02ffULL,
0x0000001a0c0c7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000a22047287ULL, 0x000fe2000c000000ULL,
0x0000001a0d0d7c10ULL, 0x000fc6000ff5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x0000001c0c167c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x0000001c0d1a7c11ULL, 0x040fe2000f8440ffULL, 0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL,
0x0000001d0c177c11ULL, 0x000fe200088f440fULL, 0x00000027040c7c36ULL, 0x000fe20008000000ULL,
0x0000001d0d1b7c11ULL, 0x000fe200090f440eULL, 0x00000027050d7c36ULL, 0x000fe20008000000ULL,
0x000000201d1d7446ULL, 0x000fe20003800010ULL, 0x00000027060e7c36ULL, 0x000fe20008000000ULL,
0x0000001a0c137c10ULL, 0x000fe2000ff3e0ffULL, 0x00000027070f7c36ULL, 0x000fe20008000000ULL,
0x0000001a0d0d7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000c0d047899ULL, 0x000fe2000800063fULL,
0x0000001a0e0e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x0000001c13187c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000001c0d0c7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000001d13197c11ULL, 0x000fe200088f4414ULL, 0x0000100004177892ULL, 0x000fe2000f8ec03fULL,
0x0000001d0d0d7c11ULL, 0x000fe200090f4412ULL, 0x0000001009167825ULL, 0x000fe200078e0016ULL,
0x0000001a0f127c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010170a7290ULL, 0x000fe2000fffe00fULL,
0x0000001c0e107c11ULL, 0x000fe2000f8640ffULL, 0x00000027080f7c36ULL, 0x000fc40008000000ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x0000001d0e117c11ULL, 0x000fe200098f4411ULL,
0x000000270a0e7c36ULL, 0x000fe20008000000ULL, 0x0000001c12147c11ULL, 0x000fe2000f8240ffULL,
0x000130000a0a7890ULL, 0x000fe2000fffe03fULL, 0x0000001d0400720cULL, 0x000fe20003f66070ULL,
0x00000010091a7825ULL, 0x040fe200078e001aULL, 0x0000001d12157c11ULL, 0x000fe400088f4415ULL,
0x0000001a0f0f7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001009187825ULL, 0x000fe200078e0018ULL,
0x0000001a0e137c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000a57657c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000001d0200720cULL, 0x080fe20003f26070ULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x0000001d0300720cULL, 0x000fe20003f46070ULL,
0x00000010090c7825ULL, 0x000fe200078e000cULL, 0x0000000a56647c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a55637c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009107825ULL, 0x000fe200078e0010ULL,
0x0000001c13127c11ULL, 0x000fc4000f8840ffULL, 0x0000001c0f0e7c11ULL, 0x000fe2000f8a40ffULL,
0x0000001009147825ULL, 0x000fe200078e0014ULL, 0x0000001d13137c11ULL, 0x000fe2000a0f441eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016657faeULL, 0x0003e2000c901c58ULL,
0x0000001d0500720cULL, 0x080fe40003f26070ULL, 0x0000001d0f0f7c11ULL, 0x000fe2000a8f441cULL,
0x000000001a647faeULL, 0x0003e2000d101c58ULL, 0x0000001d0600720cULL, 0x080fe20003f46070ULL,
0x0000001009127825ULL, 0x000fe200078e0012ULL, 0x0000001d0a00720cULL, 0x080fe20003f86070ULL,
0x0000000018637faeULL, 0x0003e2000d901c58ULL, 0x0000001d0700720cULL, 0x080fe20003f66070ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001d0800720cULL, 0x000fc40003fa6070ULL,
0x0000000a5c627c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a5b617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a5a607c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c627faeULL, 0x0003e2000c901c58ULL,
0x0000000a595f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a585e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010617faeULL, 0x0003e8000d101c58ULL, 0x0000000014607faeULL, 0x0003e8000d901c58ULL,
0x00000000125f7faeULL, 0x0003e8000e101c58ULL, 0x000000000e5e7faeULL, 0x0003e2000e901c58ULL,
0x00000004001c7947ULL, 0x000fea0003800000ULL, 0x00000027020c7c36ULL, 0x000fe20008000000ULL,
0x0000000c0d047899ULL, 0x000fe2000800063fULL, 0x00000027030d7c36ULL, 0x000fe40008000000ULL,
0x0000002706107c36ULL, 0x000fe20008000000ULL, 0x0000001a0c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000002707137c36ULL, 0x000fe20008000000ULL, 0x0000001a0d0e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000100004177892ULL, 0x000fe2000f8ec03fULL, 0x0000001a10117c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x0000001c0c167c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x0000001c0e1a7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x0000001d0c177c11ULL, 0x000fe200088f440dULL,
0x00000027040c7c36ULL, 0x000fe20008000000ULL, 0x0000001d0e1b7c11ULL, 0x000fe200090f440fULL,
0x00000027050e7c36ULL, 0x000fe20008000000ULL, 0x0000001c11107c11ULL, 0x000fe2000f8640ffULL,
0x00000010170a7290ULL, 0x000fe2000fffe00fULL, 0x0000001a0c0d7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001009167825ULL, 0x000fe200078e0016ULL, 0x0000001a0e0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x000130000a0a7890ULL, 0x000fe2000fffe03fULL, 0x0000001d11117c11ULL, 0x000fe200098f4414ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x0000001c0d187c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000001c0f0c7c11ULL, 0x000fe2000f8440ffULL,
0x00000010091a7825ULL, 0x000fe200078e001aULL, 0x0000001d0d197c11ULL, 0x000fc400088f440eULL,
0x0000001d0f0d7c11ULL, 0x000fe200090f4412ULL, 0x000000270a0f7c36ULL, 0x000fe20008000000ULL,
0x0000001a13137c10ULL, 0x000fe2000ff3e0ffULL, 0x0000002708127c36ULL, 0x000fe20008000000ULL,
0x0000000a57657c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009187825ULL, 0x000fe200078e0018ULL,
0x0000001a0f0f7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001a121d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x0000001c13147c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000000a56647c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000001d13157c11ULL, 0x000fe200088f440eULL,
0x00000010090c7825ULL, 0x000fe200078e000cULL, 0x0000001c0f127c11ULL, 0x000fe2000f8240ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016657faeULL, 0x0003e2000b901c58ULL,
0x0000001c1d0e7c11ULL, 0x000fe2000f8440ffULL, 0x0000001009107825ULL, 0x000fe200078e0010ULL,
0x0000001d0f137c11ULL, 0x000fe200088f441cULL, 0x000000001a647faeULL, 0x0003e2000b901c58ULL,
0x0000000a55637c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x0000001d1d0f7c11ULL, 0x000fc400090f441eULL, 0x0000000a5c627c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009127825ULL, 0x000fe200078e0012ULL, 0x0000000a5b617c11ULL, 0x000fe2000f8e20ffULL,
0x0000000018637faeULL, 0x0003e2000b901c58ULL, 0x0000000a5a607c11ULL, 0x000fe2000f8e20ffULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000000a595f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c627faeULL, 0x0003e2000b901c58ULL, 0x0000000a585e7c11ULL, 0x000fc6000f8e20ffULL,
0x0000000010617faeULL, 0x0003e8000b901c58ULL, 0x0000000014607faeULL, 0x0003e8000b901c58ULL,
0x00000000125f7faeULL, 0x0003e8000b901c58ULL, 0x000000000e5e7faeULL, 0x0003e4000b901c58ULL,
0x0000001312127290ULL, 0x000fe2000fffe03fULL, 0x00000025ff0f7e24ULL, 0x002fe2000f8e00ffULL,
0xffffffff001a7882ULL, 0x000fe40000000000ULL, 0x00000003120a7892ULL, 0x000fc8000f8ec03fULL,
0x000000030a00788cULL, 0x000fc8000bf05270ULL, 0x00000001240a7887ULL, 0x000fc8000c000000ULL,
0x0000000a120a7290ULL, 0x000fc8000fffe03fULL, 0x000000080a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f2f008ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000a0b1a7290ULL, 0x000fe2000fffe03fULL, 0x00008c0000127ab9ULL, 0x000fc60000000a00ULL,
0x000000041a1278a5ULL, 0x000fcc000f8e0012ULL, 0x00000012ff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x00000013ff0d7e24ULL, 0x000fca000f8e00ffULL, 0x000000180c0c7981ULL, 0x000ea4000c1e1900ULL,
0x000000000c1a72caULL, 0x004fde00000e0000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b6287c0f0c79a7ULL, 0x0002a20008500011ULL, 0x000000051b127899ULL, 0x000fc8000800063fULL,
0xffffff8012127892ULL, 0x000fc8000f8ec03fULL, 0x0000008007137890ULL, 0x000fe2000fffe012ULL,
0x00000025ff0f7e24ULL, 0x002fca000f8e00ffULL, 0x00000013784e7c10ULL, 0x000fe2000fffe079ULL,
0x01b6280d0f0075a7ULL, 0x004e640008020151ULL, 0x000000cc00d09947ULL, 0x002fea0003800000ULL,
0x01b000004e0d7984ULL, 0x000e620000000800ULL, 0x000000091b137899ULL, 0x000fe2000800063fULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000100004277892ULL, 0x000fe2000f8e0c3fULL,
0x01b200004e4e7984ULL, 0x000ea20000000800ULL, 0xfffff80013137892ULL, 0x000fe4000f8ec03fULL,
0x0001300015287890ULL, 0x000fe4000fffe027ULL, 0x0000001307137290ULL, 0x000fcc000fffe03fULL,
0x0000001366677c11ULL, 0x000fe4000f8e20ffULL, 0x000000000d00720bULL, 0x002fda0003f3d000ULL,
0x00000000000c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0c0e7812ULL, 0x000fda000782c0ffULL,
0x0000000000dc9947ULL, 0x004fea0003800000ULL, 0x000000000d00720bULL, 0x000fe20003f34000ULL,
0x000000011f047890ULL, 0x000fe2000fffe03fULL, 0x0000000d00117209ULL, 0x000fc60007810000ULL,
0x0000001b0400728cULL, 0x000fe4000bf05270ULL, 0x80000011000c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe20000410000ULL, 0x000000000000781cULL, 0x000fe40003f4f008ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x000000071b048291ULL, 0x000fe2000f8e383fULL,
0x0000000c000c7308ULL, 0x000e620000000800ULL, 0x0000ffff000f7812ULL, 0x000fc800078e3cffULL,
0x0000000f0eff7212ULL, 0x000fc6000782c0ffULL, 0x000000047810ac10ULL, 0x000fca000fffe079ULL,
0x01b400111000a388ULL, 0x0005e20000000800ULL, 0x0000000c0b0b7220ULL, 0x002fc60000410000ULL,
0x00001f7b0c007589ULL, 0x000e6200000e0000ULL, 0x800000110d0e1221ULL, 0x000fc60000010000ULL,
0x00001f7a0c0d7589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fe20000410000ULL,
0x00000001ff107807ULL, 0x004fc60000800000ULL, 0x0000000e00541308ULL, 0x000ea20000000800ULL,
0x0000000044447220ULL, 0x082fe20000410000ULL, 0x0000000045457220ULL, 0x080fe20000410000ULL,
0x0000000040407220ULL, 0x080fe20000410000ULL, 0x0000000041417220ULL, 0x080fe20000410000ULL,
0x000000003c3c7220ULL, 0x080fe20000410000ULL, 0x000000003d3d7220ULL, 0x080fe20000410000ULL,
0x0000000038387220ULL, 0x080fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x000fe20000410000ULL,
0x0000000d46467220ULL, 0x088fe20000410000ULL, 0x0000000d47477220ULL, 0x080fe20000410000ULL,
0x0000000d42427220ULL, 0x080fe20000410000ULL, 0x0000000d43437220ULL, 0x080fe20000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e0011ULL, 0x0000004e544e1220ULL, 0x004fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x011800006718783bULL, 0x000fe20000000200ULL,
0x000000286a777c11ULL, 0x000fe2000f8e20ffULL, 0x0001300014047890ULL, 0x000fe2000fffe027ULL,
0x00000054ff11723eULL, 0x000fe200000000ffULL, 0x0000000b4e0b7221ULL, 0x000fe20000010000ULL,
0x0000002869767c11ULL, 0x000fe2000f8e20ffULL, 0x00000000770c783bULL, 0x000fe20000004200ULL,
0x0000541011157816ULL, 0x000fe40000000011ULL, 0x0000991010147816ULL, 0x000fe400000000ffULL,
0x000000007610783bULL, 0x000fe20000004200ULL, 0x0000002868757c11ULL, 0x000fc4000f8e20ffULL,
0x000000286b747c11ULL, 0x000fe2000f8e20ffULL, 0x00001f7b154d7589ULL, 0x000e6200000e0000ULL,
0x000000ff1400720cULL, 0x000fe40003f25270ULL, 0x000000136c667c11ULL, 0x000fe2000f8e20ffULL,
0x00001f7a154c7589ULL, 0x000ea200000e0000ULL, 0x000000046f737c11ULL, 0x000fe2000f8e20ffULL,
0x000000010d137892ULL, 0x000fe2000f8ec03fULL, 0x000000046e727c11ULL, 0x000fe2000f8e20ffULL,
0x00000000751c783bULL, 0x000ee20000004200ULL, 0x000000046d717c11ULL, 0x000fc4000f8e20ffULL,
0x00000004706c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000007428783bULL, 0x000f220000004200ULL,
0x0000001300047c82ULL, 0x000fc60008000000ULL, 0x000000007348783bULL, 0x000fe80000004200ULL,
0x000000007220783bULL, 0x000fe80000004200ULL, 0x000000007114783bULL, 0x000fe20000004200ULL,
0x0000004d18189232ULL, 0x082fe40000000000ULL, 0x0000004d1a1a9232ULL, 0x000fc40000000000ULL,
0x0000004c19199232ULL, 0x084fe40000000000ULL, 0x0000004c1b1b9232ULL, 0x000fce0000000000ULL,
0x0000000c1844723cULL, 0x000fec0000001844ULL, 0x0000000e1840723cULL, 0x000fe20000001840ULL,
0x01180000660c783bULL, 0x000e6a0000000200ULL, 0x00000010183c723cULL, 0x000fec000000183cULL,
0x000000121838723cULL, 0x000fe20000001838ULL, 0x000000006c10783bULL, 0x000eaa0000004200ULL,
0x0000001c1834723cULL, 0x008fec0000001834ULL, 0x0000001e1830723cULL, 0x000fec0000001830ULL,
0x00000028182c723cULL, 0x010fec000000182cULL, 0x0000002a1824723cULL, 0x000fe20000001824ULL,
0x0000004d0c0c9232ULL, 0x002fc40000000000ULL, 0x0000004d0e0e9232ULL, 0x000fe40000000000ULL,
0x0000004c0d0d9232ULL, 0x080fe40000000000ULL, 0x0000004c0f0f9232ULL, 0x000fce0000000000ULL,
0x000000480c44723cULL, 0x000fec0000001844ULL, 0x0000004a0c40723cULL, 0x000fec0000001840ULL,
0x000000200c3c723cULL, 0x000fec000000183cULL, 0x000000220c38723cULL, 0x000fec0000001838ULL,
0x000000140c34723cULL, 0x000fec0000001834ULL, 0x000000160c30723cULL, 0x000fec0000001830ULL,
0x000000100c2c723cULL, 0x004fec000000182cULL, 0x000000120c24723cULL, 0x000fe20000001824ULL,
0x00000016ff117e24ULL, 0x000fc8000f8e00ffULL, 0x01b6907c11ff79a7ULL, 0x0003e40008500007ULL,
0x000000805d0c7811ULL, 0x000fc800078e40ffULL, 0x000000220c007c0cULL, 0x000fda000bf26070ULL,
0x0000002400001947ULL, 0x002fea0003800000ULL, 0x000000c00e0e7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000c1a1a72a4ULL, 0x000fe4000f8e023fULL,
0x0000002009287892ULL, 0x000fe4000f8ef80eULL, 0x000000061a1a7899ULL, 0x000fe2000800063fULL,
0x00000004004c8947ULL, 0x000ff60003800000ULL, 0x00000028020c7c36ULL, 0x000fe20008000000ULL,
0x0000000e2200728cULL, 0x000fe4000bf01070ULL, 0x8000000eff1d7e24ULL, 0x000fe2000f8e02ffULL,
0x00000010270f7290ULL, 0x000fe2000fffe00fULL, 0x0000002808197c36ULL, 0x000fe20008000000ULL,
0x0000001a0c0d7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000028030c7c36ULL, 0x000fe20008000000ULL,
0x0000000e22047287ULL, 0x000fe4000c000000ULL, 0x000130000f0f7890ULL, 0x000fe2000fffe03fULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000001c0d167c11ULL, 0x000fc4000f8040ffULL,
0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL, 0x0000001a19197c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001d0d177c11ULL, 0x000fe200080f440eULL, 0x00000028050d7c36ULL, 0x000fe20008000000ULL,
0x0000001a0c0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000028040c7c36ULL, 0x000fe20008000000ULL,
0x000000201d1d7446ULL, 0x000fe20003800010ULL, 0x0000001009167825ULL, 0x000fe200078e0016ULL,
0x0000001a0d0d7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001a0c0f7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001c0e147c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x0000001d0300720cULL, 0x000fe20003f46070ULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000001d0e157c11ULL, 0x000fe200080f4411ULL,
0x00000028060e7c36ULL, 0x000fe20008000000ULL, 0x0000001c0f127c11ULL, 0x000fc4000f8040ffULL,
0x0000001c0d0c7c11ULL, 0x000fe2000f8240ffULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x0000001d0f137c11ULL, 0x000fe400080f4418ULL, 0x0000001d0d0d7c11ULL, 0x000fe200088f4410ULL,
0x00000028070f7c36ULL, 0x000fe20008000000ULL, 0x0000001a0e1b7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000280a187c36ULL, 0x000fe20008000000ULL, 0x0000000f57577c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009127825ULL, 0x000fe200078e0012ULL, 0x0000001a0f117c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000f561f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000001c1b0e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000001c11107c11ULL, 0x000fe2000f8240ffULL, 0x00000010090c7825ULL, 0x000fe200078e000cULL,
0x0000001d1b0f7c11ULL, 0x000fe400080f441cULL, 0x0000001d11117c11ULL, 0x000fe200088f441aULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000001d0200720cULL, 0x000fe20003f26070ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001a181b7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000001c19187c11ULL, 0x000fe2000f8840ffULL, 0x0000001009107825ULL, 0x000fe200078e0010ULL,
0x0000001c1b1a7c11ULL, 0x000fe4000f8640ffULL, 0x0000001d19197c11ULL, 0x000fe2000a0f441cULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000001d0400720cULL, 0x080fe40003f06070ULL,
0x0000001d0a00720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016577faeULL, 0x000fe2000c901c58ULL, 0x0000001d0500720cULL, 0x080fe20003f26070ULL,
0x0000001009187825ULL, 0x000fe200078e0018ULL, 0x0000001d1b1b7c11ULL, 0x000fe200098f441eULL,
0x00000000141f7faeULL, 0x0003e2000d101c58ULL, 0x0000001d0600720cULL, 0x000fc40003f46070ULL,
0x0000001d0700720cULL, 0x080fe20003f66070ULL, 0x00000010091a7825ULL, 0x000fe200078e001aULL,
0x0000001d0800720cULL, 0x000fe40003fa6070ULL, 0x0000000f55557c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f5c1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f5b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000012557faeULL, 0x0007e2000c101c58ULL, 0x0000000f5a157c11ULL, 0x002fc4000f8e20ffULL,
0x0000000f59597c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c1d7faeULL, 0x0007e2000c901c58ULL,
0x0000000f58177c11ULL, 0x000fc6000f8e20ffULL, 0x000000000e5b7faeULL, 0x0007e8000d101c58ULL,
0x0000000010157faeULL, 0x0007e8000d901c58ULL, 0x000000001a597faeULL, 0x0007e8000e101c58ULL,
0x0000000018177faeULL, 0x0007e2000e901c58ULL, 0x0000000400147947ULL, 0x000fea0003800000ULL,
0x00000028020c7c36ULL, 0x000fe20008000000ULL, 0x00000010270f7290ULL, 0x000fe2000fffe00fULL,
0x00000028030e7c36ULL, 0x000fe40008000000ULL, 0x0000002804117c36ULL, 0x000fe20008000000ULL,
0x0000001a0c0d7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000002805137c36ULL, 0x000fe20008000000ULL,
0x0000001a0e0f7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000002806157c36ULL, 0x000fe20008000000ULL,
0x0000001a11117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000001c0d0c7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000001a13137c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x0000001d0d0d7c11ULL, 0x000fe200080f4410ULL, 0x000000280a197c36ULL, 0x000fe20008000000ULL,
0x0000001c0f0e7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001c11107c11ULL, 0x000fe2000f8040ffULL, 0x00000028081b7c36ULL, 0x000fe20008000000ULL,
0x0000001d0f0f7c11ULL, 0x000fe200088f4412ULL, 0x000130000f0f7890ULL, 0x000fe2000fffe03fULL,
0x0000001d11117c11ULL, 0x000fe200080f4414ULL, 0x0000002807147c36ULL, 0x000fe20008000000ULL,
0x0000001c13127c11ULL, 0x000fe2000f8240ffULL, 0x00000010090c7825ULL, 0x000fe200078e000cULL,
0x0000001a15157c10ULL, 0x000fc4000ff1e0ffULL, 0x0000001d13137c11ULL, 0x000fe200088f4416ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001a14177c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000f57577c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000001c15147c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000001c17167c11ULL, 0x000fe2000f8240ffULL, 0x0000001009107825ULL, 0x000fe200078e0010ULL,
0x0000001d15157c11ULL, 0x000fe200080f4418ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c577faeULL, 0x0003e2000b901c58ULL, 0x0000001d17177c11ULL, 0x000fe200088f441aULL,
0x0000001009127825ULL, 0x000fe200078e0012ULL, 0x0000001a19197c10ULL, 0x000fc4000ff1e0ffULL,
0x0000001a1b1e7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x0000000f561d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f55557c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000001c191a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x0000001c1e187c11ULL, 0x040fe2000f8240ffULL,
0x0000001009167825ULL, 0x000fe200078e0016ULL, 0x0000001d191b7c11ULL, 0x000fe200080f441cULL,
0x000000000e1d7faeULL, 0x0003e2000b901c58ULL, 0x0000001d1e197c11ULL, 0x000fc400088f441fULL,
0x0000000f5c1f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010091a7825ULL, 0x000fe200078e001aULL,
0x0000000f5b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000010557faeULL, 0x0003e2000b901c58ULL,
0x0000000f5a217c11ULL, 0x000fe2000f8e20ffULL, 0x0000001009187825ULL, 0x000fe200078e0018ULL,
0x0000000f59597c11ULL, 0x000fe2000f8e20ffULL, 0x00000000121f7faeULL, 0x0003e2000b901c58ULL,
0x0000000f58237c11ULL, 0x000fc6000f8e20ffULL, 0x00000000145b7faeULL, 0x0003e8000b901c58ULL,
0x0000000016217faeULL, 0x0003e8000b901c58ULL, 0x000000001a597faeULL, 0x0003e8000b901c58ULL,
0x0000000018237faeULL, 0x0003e4000b901c58ULL, 0x000000030a047892ULL, 0x000fe2000f8ec03fULL,
0x00000025ff0f7e24ULL, 0x00afe2000f8e00ffULL, 0xffffffff001a7882ULL, 0x000fe40000000000ULL,
0x000000030400788cULL, 0x000fc8000bf05270ULL, 0x0000000124047887ULL, 0x000fc8000c000000ULL,
0x000000040a0a7290ULL, 0x000fc8000fffe03fULL, 0x000000080a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000000a0b047290ULL, 0x000fe2000fffe03fULL, 0x00008c00000e7ab9ULL, 0x000fc60000000a00ULL,
0x00000004040e78a5ULL, 0x000fcc000f8e000eULL, 0x0000000eff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000fff0d7e24ULL, 0x000fca000f8e00ffULL, 0x000000180c0c7981ULL, 0x000ea4000c1e1900ULL,
0x000000000c1a72caULL, 0x004fde00000e0000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b6487c0f0c79a7ULL, 0x0002a20008500011ULL, 0x0000010007047890ULL, 0x000fcc000fffe012ULL,
0x00000004780e7c10ULL, 0x000fe2000fffe079ULL, 0x00000025ff0f7e24ULL, 0x002fc8000f8e00ffULL,
0x01b6480d0f0075a7ULL, 0x004e640008000151ULL, 0x000000bc00188947ULL, 0x002fea0003800000ULL,
0x01b000000e0d7984ULL, 0x000e620000000800ULL, 0x0001300015157890ULL, 0x000fc6000fffe017ULL,
0x01b200000e557984ULL, 0x0004a20000000800ULL, 0x000000000d00720bULL, 0x002fda0003f1d000ULL,
0x00000000000c7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0c0f7812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000000000e08947ULL, 0x004fea0003800000ULL,
0x000000000d00720bULL, 0x000fe20003f14000ULL, 0x000000021f047890ULL, 0x000fe2000fffe03fULL,
0x0000000d000c7209ULL, 0x000fc60007810000ULL, 0x0000001b0400728cULL, 0x000fe4000bf05270ULL,
0x8000000c000e7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fe20000410000ULL,
0x000000000000781cULL, 0x000fe40003f2f008ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000071b048291ULL, 0x000fe2000f8e383fULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x0000ffff00107812ULL, 0x000fc800078e3cffULL, 0x000000100fff7212ULL, 0x000fc6000780c0ffULL,
0x0000000478119c10ULL, 0x000fca000fffe079ULL, 0x01b4000c11009388ULL, 0x000fe20000000800ULL,
0x0000000e0b0b7220ULL, 0x002fc60000410000ULL, 0x00001f7b0e007589ULL, 0x000e6200000e0000ULL,
0x8000000c0d0f0221ULL, 0x000fc60000010000ULL, 0x00001f7a0e0d7589ULL, 0x0004e200000e0000ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00540308ULL, 0x000f220000000800ULL,
0x00000001ff0e7807ULL, 0x004fe20000000000ULL, 0x0000000044447220ULL, 0x082fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x000000003c3c7220ULL, 0x080fe20000410000ULL,
0x000000003d3d7220ULL, 0x080fe20000410000ULL, 0x0000000038387220ULL, 0x080fe20000410000ULL,
0x0000000039397220ULL, 0x080fe20000410000ULL, 0x0000000034347220ULL, 0x080fe20000410000ULL,
0x0000000035357220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x080fe20000410000ULL, 0x0000000024247220ULL, 0x080fe20000410000ULL,
0x0000000025257220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e000cULL,
0x0000000d46467220ULL, 0x088fe20000410000ULL, 0x0000000d47477220ULL, 0x080fe20000410000ULL,
0x0000000d42427220ULL, 0x080fe20000410000ULL, 0x0000000d43437220ULL, 0x080fe20000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fe20000410000ULL,
0x000076100e0c7816ULL, 0x000fe2000000000cULL, 0x0000005554550220ULL, 0x010fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x012000006720783bULL, 0x000fe20000000200ULL,
0x000000156a507c11ULL, 0x000fe2000f8e20ffULL, 0x0001300014147890ULL, 0x000fe2000fffe017ULL,
0x00000015694c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010d047892ULL, 0x000fe2000f8e0c3fULL,
0x0000001568487c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b550b7221ULL, 0x000fe20000010000ULL,
0x000000156b287c11ULL, 0x000fe2000f8e20ffULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x00000054ff0d723eULL, 0x000fe400000000ffULL, 0x000099100c107816ULL, 0x000fe200000000ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x000054100d117816ULL, 0x000fc4000000000dULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x000000146f1c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000146e187c11ULL, 0x000fe2000f8e20ffULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x000000146d147c11ULL, 0x000fe4000f8e20ffULL,
0x0000001470107c11ULL, 0x000fe2000f8e20ffULL, 0x00001f7b11567589ULL, 0x000e6800000e0000ULL,
0x00001f7a11577589ULL, 0x000ea800000e0000ULL, 0x01200000660c783bULL, 0x000ee80000000200ULL,
0x000000001c1c783bULL, 0x000f280000004200ULL, 0x000000001818783bULL, 0x000f680000004200ULL,
0x000000001414783bULL, 0x000f280000004200ULL, 0x000000001010783bULL, 0x000f220000004200ULL,
0x0000005620208232ULL, 0x002fc40000000000ULL, 0x0000005622228232ULL, 0x000fe40000000000ULL,
0x0000005721218232ULL, 0x084fe40000000000ULL, 0x0000005723238232ULL, 0x000fce0000000000ULL,
0x000000502044723cULL, 0x000fec0000001844ULL, 0x000000522040723cULL, 0x000fe20000001840ULL,
0x000000560c0c8232ULL, 0x008fca0000000000ULL, 0x0000004c203c723cULL, 0x000fe2000000183cULL,
0x000000560e0e8232ULL, 0x000fe40000000000ULL, 0x000000570d0d8232ULL, 0x080fe40000000000ULL,
0x000000570f0f8232ULL, 0x000fe20000000000ULL, 0x0000004e2038723cULL, 0x000fec0000001838ULL,
0x000000482034723cULL, 0x000fec0000001834ULL, 0x0000004a2030723cULL, 0x000fec0000001830ULL,
0x00000028202c723cULL, 0x000fec000000182cULL, 0x0000002a2024723cULL, 0x000fec0000001824ULL,
0x0000001c0c44723cULL, 0x010fec0000001844ULL, 0x0000001e0c40723cULL, 0x000fec0000001840ULL,
0x000000180c3c723cULL, 0x020fec000000183cULL, 0x0000001a0c38723cULL, 0x000fec0000001838ULL,
0x000000140c34723cULL, 0x000fec0000001834ULL, 0x000000160c30723cULL, 0x000fec0000001830ULL,
0x000000100c2c723cULL, 0x000fec000000182cULL, 0x000000120c24723cULL, 0x000fe20000001824ULL,
0x00000016ff117e24ULL, 0x000fc8000f8e00ffULL, 0x01b6987c11ff79a7ULL, 0x0003e40008500007ULL,
0x000000c05d0c7811ULL, 0x000fc800078e40ffULL, 0x000000220c007c0cULL, 0x000fda000bf06070ULL,
0x0000001000480947ULL, 0x002fea0003800000ULL, 0x000000005d0472caULL, 0x000fe200000e0000ULL,
0x0000000c1a0c72a4ULL, 0x000fe2000f8e023fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x000000060c0c7899ULL, 0x000fd0000800063fULL, 0x000000041e047290ULL, 0x000fc8000fffe03fULL,
0x00000001040d7890ULL, 0x000fe4000fffe03fULL, 0x0000002004047291ULL, 0x000fe4000f8e403fULL,
0x000000050d00728cULL, 0x000fe4000bf06070ULL, 0x00000020090e7892ULL, 0x000fc8000f8ef804ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400248947ULL, 0x000fea0003800000ULL,
0x000000042200728cULL, 0x000fe4000bf01070ULL, 0x80000004ff1d7e24ULL, 0x000fe4000f8e02ffULL,
0x0000000e030d7c36ULL, 0x000fe20008000000ULL, 0x00000004220d7287ULL, 0x000fe2000c000000ULL,
0x0000000e020c7c36ULL, 0x000fe40008000000ULL, 0x0000000e050f7c36ULL, 0x000fe20008000000ULL,
0x0000000c0d137c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000dff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c0c157c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000c0f0d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x000000200e1d7446ULL, 0x000fe2000380001dULL,
0x0000000e040e7c36ULL, 0x000fe20008000000ULL, 0x0000001c13187c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000001c151a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000000c0e117c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001c0d0c7c11ULL, 0x000fc4000f8640ffULL, 0x0000001d151b7c11ULL, 0x000fe200080f4416ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000001c110e7c11ULL, 0x000fe4000f8440ffULL,
0x0000001d0d0d7c11ULL, 0x000fe200098f4410ULL, 0x0000000e07107c36ULL, 0x000fe20008000000ULL,
0x0000001d110f7c11ULL, 0x000fe200090f4412ULL, 0x0000000e0a117c36ULL, 0x000fe20008000000ULL,
0x0000001d0200720cULL, 0x000fe20003f06070ULL, 0x0000000e06027c36ULL, 0x000fe20008000000ULL,
0x0000001d13197c11ULL, 0x000fe200088f4414ULL, 0x0000000e08127c36ULL, 0x000fe20008000000ULL,
0x0000000c11137c10ULL, 0x000fe2000ff9e0ffULL, 0x00000010091a7825ULL, 0x000fe200078e001aULL,
0x0000000c10157c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000c02177c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000000c12027c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000001c13127c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x0000001c15147c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000001c17167c11ULL, 0x000fe2000f8440ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a657faeULL, 0x0003e2000c101c58ULL,
0x0000001c02107c11ULL, 0x000fe2000f8240ffULL, 0x0000001009187825ULL, 0x000fe200078e0018ULL,
0x0000001d13137c11ULL, 0x000fc4000a0f441cULL, 0x0000001d0300720cULL, 0x080fe20003fa6070ULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000001d15157c11ULL, 0x000fe400098f441eULL,
0x0000001d0400720cULL, 0x080fe20003f86070ULL, 0x00000010090c7825ULL, 0x000fe200078e000cULL,
0x0000001d17177c11ULL, 0x000fe400090f4420ULL, 0x0000001d0500720cULL, 0x000fe20003f66070ULL,
0x0000001009147825ULL, 0x000fe200078e0014ULL, 0x0000001d02117c11ULL, 0x000fc400088f4411ULL,
0x0000001d0600720cULL, 0x080fe20003f46070ULL, 0x0000001009167825ULL, 0x000fe200078e0016ULL,
0x0000001d0700720cULL, 0x080fe20003f26070ULL, 0x0000000018647faeULL, 0x0003e2000e901c58ULL,
0x0000001d0a00720cULL, 0x080fe20003f06070ULL, 0x0000001009127825ULL, 0x040fe200078e0012ULL,
0x0000001d0800720cULL, 0x000fe20003fc6070ULL, 0x000000000e637faeULL, 0x0003e4000e101c58ULL,
0x0000001009107825ULL, 0x000fe400078e0010ULL, 0x000000000c627faeULL, 0x0003e8000d901c58ULL,
0x0000000016617faeULL, 0x0003e8000d101c58ULL, 0x0000000014607faeULL, 0x0003e8000c901c58ULL,
0x00000000125f7faeULL, 0x0003e8000c101c58ULL, 0x00000000105e7faeULL, 0x0003e2000f101c58ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000e02027c36ULL, 0x000fe40008000000ULL,
0x0000000e030c7c36ULL, 0x000fe40008000000ULL, 0x0000000e04047c36ULL, 0x000fe20008000000ULL,
0x0000000c02037c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000e050d7c36ULL, 0x000fe20008000000ULL,
0x0000000c0c057c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000e06067c36ULL, 0x000fe20008000000ULL,
0x0000000c04117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000c0d137c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000001c030e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x0000001c050c7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001c11047c11ULL, 0x000fe2000f8440ffULL, 0x0000000e08087c36ULL, 0x000fe20008000000ULL,
0x0000001d030f7c11ULL, 0x000fe200080f4410ULL, 0x0000000e07107c36ULL, 0x000fe20008000000ULL,
0x0000001d050d7c11ULL, 0x000fc400088f4412ULL, 0x0000001d11057c11ULL, 0x000fe200090f4414ULL,
0x0000000e0a117c36ULL, 0x000fe20008000000ULL, 0x0000001c13027c11ULL, 0x000fe2000f8640ffULL,
0x00000010090e7825ULL, 0x000fe200078e000eULL, 0x0000000c06077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000001d13037c11ULL, 0x000fe200098f4416ULL, 0x00000010090c7825ULL, 0x040fe200078e000cULL,
0x0000000c100a7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e657faeULL, 0x0003e2000b901c58ULL, 0x0000000c11167c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c08187c10ULL, 0x000fe2000ff7e0ffULL,
0x000000000c647faeULL, 0x0003e4000b901c58ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000001c07147c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x0000001c0a127c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001c16107c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x0000001c18067c11ULL, 0x000fe2000f8640ffULL, 0x0000001009027825ULL, 0x000fe200078e0002ULL,
0x0000001d07157c11ULL, 0x000fe200080f4408ULL, 0x0000000004637faeULL, 0x0003e2000b901c58ULL,
0x0000001d0a137c11ULL, 0x000fc400088f4411ULL, 0x0000001d16117c11ULL, 0x000fe200090f4417ULL,
0x0000001009147825ULL, 0x040fe200078e0014ULL, 0x0000001d18077c11ULL, 0x000fe200098f4419ULL,
0x0000000002627faeULL, 0x0003e4000b901c58ULL, 0x0000001009127825ULL, 0x040fe400078e0012ULL,
0x0000000014617faeULL, 0x0003e4000b901c58ULL, 0x0000001009107825ULL, 0x040fe400078e0010ULL,
0x0000000012607faeULL, 0x0003e4000b901c58ULL, 0x0000001009067825ULL, 0x000fc400078e0006ULL,
0x00000000105f7faeULL, 0x0003e8000b901c58ULL, 0x00000000065e7faeULL, 0x0003e4000b901c58ULL,
0x000000030a047892ULL, 0x000fe2000f8ec03fULL, 0x00000025ff057e24ULL, 0x002fe2000f8e00ffULL,
0xffffffff001a7882ULL, 0x000fe40000000000ULL, 0x000000030400788cULL, 0x000fc8000bf05270ULL,
0x0000000124047887ULL, 0x000fc8000c000000ULL, 0x000000040a0a7290ULL, 0x000fc8000fffe03fULL,
0x000000080a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x0000000a0b047290ULL, 0x000fe2000fffe03fULL,
0x00008c00000c7ab9ULL, 0x000fc60000000a00ULL, 0x00000004040c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff037e24ULL, 0x000fca000f8e00ffULL,
0x0000001802027981ULL, 0x000ea4000c1e1900ULL, 0x00000000021a72caULL, 0x004fde00000e0000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b6687c050279a7ULL, 0x0002a20008500011ULL,
0x0000018007127890ULL, 0x000fcc000fffe012ULL, 0x0000001278047c10ULL, 0x000fe2000fffe079ULL,
0x00000025ff057e24ULL, 0x002fc8000f8e00ffULL, 0x01b66803050075a7ULL, 0x004e640008000151ULL,
0x000000a800b48947ULL, 0x002fea0003800000ULL, 0x01b0000004037984ULL, 0x000e620000000800ULL,
0x00000001ff087424ULL, 0x000fe200078e00ffULL, 0x000000000300720bULL, 0x002fda0003f1d000ULL,
0x0000000000027806ULL, 0x000fc800000e0100ULL, 0x0000ffff02057812ULL, 0x000fe4000780c0ffULL,
0x01b2000004027984ULL, 0x0002b60000000800ULL, 0x0000000000dc8947ULL, 0x002fea0003800000ULL,
0x000000000300720bULL, 0x000fe20003f14000ULL, 0x000000031f047890ULL, 0x000fe2000fffe03fULL,
0x0000000300077209ULL, 0x000fc60007810000ULL, 0x0000001b0400728cULL, 0x000fe4000bf05270ULL,
0x8000000700047221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b04047820ULL, 0x000fe20000410000ULL,
0x000000000000781cULL, 0x000fe40003f2f008ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000071b048291ULL, 0x000fe2000f8e383fULL, 0x0000000400047308ULL, 0x000e620000000800ULL,
0x0000ffff00067812ULL, 0x000fc800078e3cffULL, 0x0000000605ff7212ULL, 0x000fc6000780c0ffULL,
0x0000000478789c10ULL, 0x000fe4000fffe079ULL, 0x00000001ff087807ULL, 0x000fc60000000000ULL,
0x01b4000778009388ULL, 0x000fe20000000800ULL, 0x000000040b0b7220ULL, 0x002fc60000410000ULL,
0x00001f7b04007589ULL, 0x000e6200000e0000ULL, 0x8000000703050221ULL, 0x000fc60000010000ULL,
0x00001f7a04037589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500540308ULL, 0x000f220000000800ULL, 0x0000000044447220ULL, 0x082fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x000000003c3c7220ULL, 0x080fe20000410000ULL,
0x000000003d3d7220ULL, 0x080fe20000410000ULL, 0x0000000038387220ULL, 0x080fe20000410000ULL,
0x0000000039397220ULL, 0x080fe20000410000ULL, 0x0000000034347220ULL, 0x080fe20000410000ULL,
0x0000000035357220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x080fe20000410000ULL, 0x0000000024247220ULL, 0x080fe20000410000ULL,
0x0000000025257220ULL, 0x000fe20000410000ULL, 0x0000000346467220ULL, 0x088fe20000410000ULL,
0x0000000347477220ULL, 0x080fe20000410000ULL, 0x0000000342427220ULL, 0x080fe20000410000ULL,
0x0000000343437220ULL, 0x080fe20000410000ULL, 0x000000033e3e7220ULL, 0x080fe20000410000ULL,
0x000000033f3f7220ULL, 0x080fe20000410000ULL, 0x000000033a3a7220ULL, 0x080fe20000410000ULL,
0x000000033b3b7220ULL, 0x080fe20000410000ULL, 0x0000000336367220ULL, 0x080fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x000000032e2e7220ULL, 0x080fe20000410000ULL,
0x000000032f2f7220ULL, 0x080fe20000410000ULL, 0x0000000326267220ULL, 0x080fe20000410000ULL,
0x0000000327277220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e0007ULL,
0x0000000254020220ULL, 0x014fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x012800006704783bULL, 0x000fe20000000200ULL, 0x00000054ff03723eULL, 0x000fe200000000ffULL,
0x0000000b020b7221ULL, 0x004fe20000010000ULL, 0x0000001300047c82ULL, 0x000fe20008000000ULL,
0x00000000770c783bULL, 0x000fe20000004200ULL, 0x0000541003097816ULL, 0x000fe40000000003ULL,
0x0000991008037816ULL, 0x000fe200000000ffULL, 0x000000007610783bULL, 0x000fe60000004200ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x000000007514783bULL, 0x000fe20000004200ULL,
0x00000016ff037e24ULL, 0x000fc6000f8e00ffULL, 0x000000007418783bULL, 0x000fe80000004200ULL,
0x00001f7b097b7589ULL, 0x000e6800000e0000ULL, 0x00001f7a097a7589ULL, 0x000ea800000e0000ULL,
0x012800006664783bULL, 0x000ee80000000200ULL, 0x00000000731c783bULL, 0x000f280000004200ULL,
0x000000007220783bULL, 0x000f680000004200ULL, 0x000000007128783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000f220000004200ULL, 0x0000007b04048232ULL, 0x082fe20000000000ULL,
0x01b6a07c03ff79a7ULL, 0x0003e20008500007ULL, 0x0000007b06068232ULL, 0x000fc40000000000ULL,
0x0000007a05058232ULL, 0x084fe40000000000ULL, 0x0000007a07078232ULL, 0x000fce0000000000ULL,
0x0000000c0444723cULL, 0x000fec0000001844ULL, 0x0000000e0440723cULL, 0x000fe20000001840ULL,
0x0000007b64648232ULL, 0x008fca0000000000ULL, 0x00000010043c723cULL, 0x000fe2000000183cULL,
0x0000007b66668232ULL, 0x000fe40000000000ULL, 0x0000007a65658232ULL, 0x080fe40000000000ULL,
0x0000007a67678232ULL, 0x000fe20000000000ULL, 0x000000120438723cULL, 0x000fec0000001838ULL,
0x000000140434723cULL, 0x000fec0000001834ULL, 0x000000160430723cULL, 0x000fec0000001830ULL,
0x00000018042c723cULL, 0x000fec000000182cULL, 0x0000001a0424723cULL, 0x000fec0000001824ULL,
0x0000001c6444723cULL, 0x010fec0000001844ULL, 0x0000001e6440723cULL, 0x000fec0000001840ULL,
0x00000020643c723cULL, 0x020fec000000183cULL, 0x000000226438723cULL, 0x000fec0000001838ULL,
0x000000286434723cULL, 0x000fec0000001834ULL, 0x0000002a6430723cULL, 0x000fec0000001830ULL,
0x0000006c642c723cULL, 0x000fec000000182cULL, 0x0000006e6424723cULL, 0x002fde0000001824ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000001e5d5d7c36ULL, 0x000fca0008000000ULL,
0x000000055d007c0cULL, 0x000fda000bf06070ULL, 0xffffffac00008947ULL, 0x000fea000383ffffULL,
0x00000000001279c3ULL, 0x000e640000002500ULL, 0x000000051200728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x018000000b027836ULL, 0x000fca0000000000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00006ee000057802ULL, 0x000fce0000000f00ULL, 0x000000a800747944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0004ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000b00027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc8000000000bULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fce0000000002ULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0302037589ULL, 0x000ea800000e0000ULL, 0x00001f0502057589ULL, 0x000ee200000e0000ULL,
0x0000004403447220ULL, 0x044fe20000410000ULL, 0x0000004503457220ULL, 0x040fe20000410000ULL,
0x0000004003407220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x0000003c033c7220ULL, 0x040fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x000fe20000410000ULL,
0x0000004605467220ULL, 0x048fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fce0000410000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000721077291ULL, 0x000fe2000f8e603fULL,
0x00000034350c723eULL, 0x000fe200000000ffULL, 0x000000011e00788cULL, 0x000fe2000bf05270ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000706137291ULL, 0x000fe2000f8e583fULL,
0x0000002c2d0e723eULL, 0x000fe400000000ffULL, 0x000000464710723eULL, 0x000fe400000000ffULL,
0x000000424311723eULL, 0x000fc400000000ffULL, 0x0000003e3f12723eULL, 0x000fe400000000ffULL,
0x0000003a3b13723eULL, 0x000fe400000000ffULL, 0x000000363714723eULL, 0x000fe400000000ffULL,
0x000000323315723eULL, 0x000fe400000000ffULL, 0x0000002e2f16723eULL, 0x000fe400000000ffULL,
0x000000262717723eULL, 0x000fc400000000ffULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x00000003ff037819ULL, 0x004fe20000011602ULL, 0x0000002002197c36ULL, 0x000fe20008000000ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee202ULL, 0x0000000303047812ULL, 0x000fe400078ec0ffULL,
0x00000007191a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000805097836ULL, 0x040fe20000000000ULL,
0x0000000404087812ULL, 0x000fe200078efcffULL, 0x0000000805067824ULL, 0x000fe200078e00ffULL,
0x0000000704077812ULL, 0x000fc400078e7805ULL, 0x00000007040d7812ULL, 0x000fe200078e7809ULL,
0x0000000809047824ULL, 0x000fe200078e00ffULL, 0x0000000708057812ULL, 0x000fe400078e7805ULL,
0x00000007080f7812ULL, 0x000fe400078e7809ULL, 0x0000000607087212ULL, 0x080fe400078efcffULL,
0x0000000605097212ULL, 0x000fe400078efcffULL, 0x000000040d0a7212ULL, 0x000fc400078efcffULL,
0x000000040f187212ULL, 0x000fe400078efcffULL, 0x000000444504723eULL, 0x000fe400000000ffULL,
0x000000404105723eULL, 0x000fe400000000ffULL, 0x0000003c3d06723eULL, 0x000fe400000000ffULL,
0x000000383907723eULL, 0x000fe400000000ffULL, 0x0000001308087c11ULL, 0x000fc4000f8e20ffULL,
0x00000030310d723eULL, 0x000fe400000000ffULL, 0x00000024250f723eULL, 0x000fe200000000ffULL,
0x0000000408007844ULL, 0x000fe20000000200ULL, 0x0000001309097c11ULL, 0x000fe4000f8e20ffULL,
0x000000130a0a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001318187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c09007844ULL, 0x000fe80000000200ULL, 0x000000100a007844ULL, 0x000fe80000000200ULL,
0x0000001418007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000001a1c7984ULL, 0x000ea80000000c00ULL, 0x000400001a247984ULL, 0x000ee80000000c00ULL,
0x000800001a207984ULL, 0x000f280000000c00ULL, 0x000c00001a287984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x004fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x020fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001c1a007388ULL, 0x0005e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x000400241a007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800908947ULL, 0x000fea0003800000ULL,
0x000000001a0c7984ULL, 0x0006e20000000c00ULL, 0x00000000000a79c3ULL, 0x000fe20000002700ULL,
0x00000001063f7892ULL, 0x000fe2000f80f81bULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000920000097ab9ULL, 0x000fe20000000800ULL, 0x000000081e0472a4ULL, 0x000fc6000f8e023fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000000000579c3ULL, 0x000f220000002600ULL,
0x00000009040972a4ULL, 0x000fc8000f8e023fULL, 0x01ffffff09147892ULL, 0x000fe4000f8ec03fULL,
0x000000080a0a72a4ULL, 0x010fc8000f8e0205ULL, 0x0000001e0a0872a4ULL, 0x000fc8000f8e023fULL,
0x00000012080b7290ULL, 0x000fe2000fffe03fULL, 0x0000000000380947ULL, 0x008ff60003800000ULL,
0x000000140b0c7290ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x0000980000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000000800b0e78a5ULL, 0x000fe4000f8e0004ULL, 0x000000800c0478a5ULL, 0x000fe2000f8e0004ULL,
0x0000007004067812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x140fe4000fa3e006ULL, 0x0000000405067c10ULL, 0x000fe4000fc7e006ULL,
0x0000000fff057c10ULL, 0x000fe40008fe44ffULL, 0x00000005ff077c10ULL, 0x000fc60009fe84ffULL,
0x0000000004007986ULL, 0x0007e8000c101918ULL, 0x0000000b06007986ULL, 0x0007e4000c101918ULL,
0x000007ff09097891ULL, 0x000fe2000f8e403fULL, 0x000000ff0200720cULL, 0x000fe20000705670ULL,
0x00009800000e7ab9ULL, 0x000fe20000000a00ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000b09047291ULL, 0x000fc8000f8fa83fULL, 0x00000800040478a5ULL, 0x000fc8000f8e000eULL,
0x00000400210478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff047e24ULL, 0x008fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL, 0x0000001019047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0007e2000c101d18ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000580947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff1e0b7890ULL, 0x000fe4000fffe03fULL, 0x000000040a0478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000bff077e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x008fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0007ec0000008000ULL,
0x0000000000007992ULL, 0x008fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ee800099ee1d8ULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x008fe20008000004ULL,
0x0000000b04007c0cULL, 0x000fc8000bf05270ULL, 0x00000001ff007807ULL, 0x000fca0000000000ULL,
0x00000000ff007988ULL, 0x0007e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000f300000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000400000a7882ULL, 0x000fc40000000000ULL, 0x00000654040a7896ULL, 0x010fd2000800000aULL,
0x0000000aff007984ULL, 0x008ee40008000000ULL, 0x000000ff0000720cULL, 0x008fda0003f05270ULL,
0x0000002400748947ULL, 0x000fea0003800000ULL, 0x0000001bff007c0cULL, 0x000fda000bf05270ULL,
0x0000000c008c0947ULL, 0x000fea0003800000ULL, 0x0000001eff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000000108047890ULL, 0x000fe2000fffe03fULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe20000011602ULL,
0x00000080080c78a5ULL, 0x000fe4000f8e000eULL, 0x00000080040478a5ULL, 0x000fe2000f8e000eULL,
0x0000007000037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04087812ULL, 0x000fc800078ec0ffULL,
0x0000000c08047c10ULL, 0x140fe4000f91e003ULL, 0x0000000408067c10ULL, 0x000fe4000fb5e003ULL,
0x0000000dff057c10ULL, 0x000fe400087e24ffULL, 0x00000005ff077c10ULL, 0x000fc600097e64ffULL,
0x0000001804007981ULL, 0x000768000c1e1900ULL, 0x0000001806097981ULL, 0x000762000c1e1900ULL,
0x000000021e00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b08947ULL, 0x008fea0003800000ULL, 0x0000000208047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e000eULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040b7981ULL, 0x002362000c1e1900ULL,
0x000000041e00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000908947ULL, 0x002fea0003800000ULL, 0x0000000308047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e000eULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040d7981ULL, 0x000362000c1e1900ULL,
0x000000041e00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000708947ULL, 0x002fea0003800000ULL, 0x0000000408047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e000eULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040f7981ULL, 0x000362000c1e1900ULL,
0x000000061e00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x002fea0003800000ULL, 0x0000000508047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e000eULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001804117981ULL, 0x000362000c1e1900ULL,
0x000000061e00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x002fea0003800000ULL, 0x000000081e00788cULL, 0x000fe4000bf06070ULL,
0x0000000608047890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f8f008ULL,
0x00000080040478a5ULL, 0x000fc8000f8e000eULL, 0x00000007080c0890ULL, 0x000fe4000fffe03fULL,
0x0000000408047c10ULL, 0x000fe4000f91e003ULL, 0x000000800c0c08a5ULL, 0x000fe4000f8e000eULL,
0x00000005ff057c10ULL, 0x000fc800087e24ffULL, 0x0000000c08064c10ULL, 0x000fe2000fb5e003ULL,
0x0000001804137981ULL, 0x000366000c1e1900ULL, 0x0000000dff074c10ULL, 0x000fca00097e64ffULL,
0x0000001806154981ULL, 0x000368000c1e1900ULL, 0x000000071e0b7890ULL, 0x000fc8000fffe03fULL,
0x000000033f0b7899ULL, 0x000fcc000801160bULL, 0x0000000bff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x020fe200078e0000ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00000008000c7c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000980000167ab9ULL, 0x000fca0000000a00ULL,
0x0000001e0400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000b0500728cULL, 0x000fd8000bf06070ULL,
0x0000000800300947ULL, 0x022fea0003800000ULL, 0x00000008040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000300007209ULL, 0x000fe20007810000ULL, 0x0000000104107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000080c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x002fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000001004047c10ULL, 0x000fc8000f91e003ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001804037981ULL, 0x000368000c1e1900ULL,
0x0000000400e82947ULL, 0x000fea0003800000ULL, 0x00000009040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000900007209ULL, 0x000fe20007810000ULL, 0x0000000204107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000090c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001804097981ULL, 0x000368000c1e1900ULL,
0x0000000400a02947ULL, 0x000fea0003800000ULL, 0x0000000a040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000b00007209ULL, 0x000fe20007810000ULL, 0x0000000304107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000a0c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040b7981ULL, 0x000368000c1e1900ULL,
0x0000000400582947ULL, 0x000fea0003800000ULL, 0x0000000b040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000d00007209ULL, 0x000fe20007810000ULL, 0x0000000404107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000b0c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040d7981ULL, 0x000368000c1e1900ULL,
0x0000000400102947ULL, 0x000fea0003800000ULL, 0x0000000c040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000f00007209ULL, 0x000fe20007810000ULL, 0x0000000504107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000c0c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x00000018040f7981ULL, 0x000368000c1e1900ULL,
0x0000000000c82947ULL, 0x000fea0003800000ULL, 0x0000000d040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001100007209ULL, 0x000fe20007810000ULL, 0x0000000604107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000d0c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001804117981ULL, 0x000368000c1e1900ULL,
0x0000000000802947ULL, 0x000fea0003800000ULL, 0x0000000e040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001300007209ULL, 0x000fe20007810000ULL, 0x0000000704107890ULL, 0x000fe4000fffe03fULL,
0x0000001e0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001e1000728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000e0c107890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080101078a5ULL, 0x000fe4000f8e0016ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001005047c10ULL, 0x000fc8000f91e004ULL,
0x00000011ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001804137981ULL, 0x000368000c1e1900ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x0000000f040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001500007209ULL, 0x000fc60007810000ULL, 0x0000001e0d00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000f0c107890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x00000080101078a5ULL, 0x000fe4000f8e0016ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000001005047c10ULL, 0x000fc8000f91e004ULL, 0x00000011ff057c10ULL, 0x000fca00087e24ffULL,
0x0000001804157981ULL, 0x000368000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x000000080c0c7890ULL, 0x000fd4000fffe03fULL,
0xfffffff400ac8947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x0000001002037824ULL, 0x028fe200078e00ffULL, 0x00000001ff047819ULL, 0x002fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000a04037c10ULL, 0x000fca000fffe003ULL, 0x0000000003007388ULL, 0x0003e40000000800ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000000806167290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000a06047291ULL, 0x000fe2000f8e683fULL,
0x0000001002007824ULL, 0x042fe200078e00ffULL, 0x0000001609107291ULL, 0x000fe2000f8fa83fULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0x0000000b1f057899ULL, 0x000fe2000800063fULL,
0x0000002002077836ULL, 0x000fe20000000000ULL, 0x00009800000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000421047291ULL, 0x000fe2000f8e603fULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x00000800101078a5ULL, 0x000fe2000f8e000cULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000400211078a5ULL, 0x000fe2000f8e0010ULL, 0x0000000a03147c10ULL, 0x000fe2000fffe000ULL,
0x00000800050b7892ULL, 0x000fe2000f8ec03fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000001614158290ULL, 0x000fe2000fffe03fULL, 0x0000000000247805ULL, 0x004fe2000001ff00ULL,
0x0000000a061a8291ULL, 0x000fe2000f8e483fULL, 0x00000010ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a061c8291ULL, 0x000fe2000f8e483fULL, 0x00000011ff057e24ULL, 0x000fe2000f8e00ffULL,
0x00000080161688a5ULL, 0x000fe2000f8e000cULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x000000011f057892ULL, 0x000fe2000f8ec03fULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x00000080150c88a5ULL, 0x000fe2000f8e000cULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001a211a8291ULL, 0x000fe2000f8e403fULL, 0x00000016ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001c211c8291ULL, 0x000fe2000f8e403fULL, 0x00000017ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b040b7290ULL, 0x000fe2000fffe03fULL, 0x0000000cff087e24ULL, 0x000fe2000f8e00ffULL,
0x0000001a051a8291ULL, 0x000fe2000f8e383fULL, 0x0000000dff097e24ULL, 0x000fe2000f8e00ffULL,
0x0000001c051c8291ULL, 0x000fe2000f8e383fULL, 0x0000001002047825ULL, 0x040fe200078e0004ULL,
0x0000000b020d7c11ULL, 0x040fe2000f8e20ffULL, 0x0000001e0600728cULL, 0x000fe2000bf06070ULL,
0x0000001a020f8c11ULL, 0x040fe2000f8e20ffULL, 0x0000001002088825ULL, 0x040fe200078e0008ULL,
0x0000001c02118c11ULL, 0x040fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0003e2000b901c58ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000010020a8825ULL, 0x000fe200078e000aULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00380000060d7faeULL, 0x0003e2000b901c58ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x04580000080f8faeULL, 0x0003e2000b901c58ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x041800000a118faeULL, 0x0003e2000b901c58ULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fc6000001ff00ULL,
0x0000000800980947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011602ULL,
0x0000000a06057291ULL, 0x000fe2000f8e483fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee202ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000521057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff377819ULL, 0x000fe20000011602ULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078e7805ULL,
0x00000008373b7836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe200078e7809ULL,
0x00000005ff3d7e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7809ULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x0000000600057c82ULL, 0x000fe20008000000ULL, 0x0000003807367212ULL, 0x080fe200078efcffULL,
0x00009800001c7ab9ULL, 0x000fe20000000a00ULL, 0x0000003805387212ULL, 0x000fc400078efcffULL,
0x0000000904397212ULL, 0x080fe400078efcffULL, 0x000000093a3a7212ULL, 0x000fce00078efcffULL,
0x00000002050b7890ULL, 0x000fc8000fffe03fULL, 0x0000001e0b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b00947ULL, 0x000fea0003800000ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000000b08177290ULL, 0x000fe2000fffe03fULL,
0x0000002002077836ULL, 0x000fe20000000000ULL, 0x000000013f0c7899ULL, 0x000fe4000801160bULL,
0x0000001709107291ULL, 0x000fe4000f8fa83fULL, 0x0000000a0b0d7899ULL, 0x000fe4000800063fULL,
0x000000010c1a7892ULL, 0x000fe4000f8ec03fULL, 0x00000800101078a5ULL, 0x000fc4000f8e001cULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x000008000d0d7892ULL, 0x000fe2000f8ec03fULL,
0x0000001aff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x00000400211078a5ULL, 0x000fe4000f8e0010ULL,
0x0000000a06228291ULL, 0x000fe4000f8e483fULL, 0x0000000a06238291ULL, 0x000fe4000f8e483fULL,
0x0000002221228291ULL, 0x000fe2000f8e403fULL, 0x00000010ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000001714168290ULL, 0x000fe2000fffe03fULL, 0x00000011ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000002321238291ULL, 0x000fc4000f8e403fULL, 0x0000000d04157290ULL, 0x000fe2000fffe03fULL,
0x00000022ff3d8e24ULL, 0x000fe2000f8e00ffULL, 0x00000080170c88a5ULL, 0x000fe2000f8e001cULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x00000080161688a5ULL, 0x000fe4000f8e001cULL,
0x00000015020d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000800c0f8824ULL, 0x000fe400078e023dULL,
0x00000023ff3d8e24ULL, 0x000fe4000f8e00ffULL, 0x00000016ff087e24ULL, 0x000fc4000f8e00ffULL,
0x00000017ff097e24ULL, 0x000fe4000f8e00ffULL, 0x0000000cff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff0b7e24ULL, 0x000fe4000f8e00ffULL, 0x000000800c118824ULL, 0x000fe400078e023dULL,
0x0000001002047825ULL, 0x000fc800078e0004ULL, 0x0000001002088825ULL, 0x040fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0003e6000b901c58ULL,
0x00000010020f8824ULL, 0x040fe200078e020fULL, 0x00380000060d7faeULL, 0x0003e2000b901c58ULL,
0x00000010020a8825ULL, 0x000fc600078e000aULL, 0x04580000080f8faeULL, 0x0003e2000b901c58ULL,
0x0000001002118824ULL, 0x000fca00078e0211ULL, 0x041800000a118faeULL, 0x0003e4000b901c58ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000005000c7c82ULL, 0x000fe40008000000ULL,
0x000000060c057899ULL, 0x000fc8000800063fULL, 0x0000008005057892ULL, 0x000fcc000f8ec03fULL,
0x0000000500047c10ULL, 0x002fe2000fffe03dULL, 0x0000000a0c057899ULL, 0x000fc8000800063fULL,
0x00000001033c7824ULL, 0x000fe200078e0204ULL, 0x0000080005057892ULL, 0x000fc8000f8ec03fULL,
0x0000018004057890ULL, 0x000fe2000fffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003c0d7984ULL, 0x000e620000000800ULL, 0x0000000536047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000538087c11ULL, 0x000fe2000f8e20ffULL, 0x004580003c3f7984ULL, 0x000fe20000000800ULL,
0x00000005390c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000053a107c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000ea20000000200ULL, 0x0000000b00057c82ULL, 0x000fe40008000000ULL,
0x0000001e0500728cULL, 0x000fe2000bf06070ULL, 0x000000000808783bULL, 0x000eea0000000200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000d14117221ULL, 0x002fc40000010100ULL,
0x000000000c0c783bULL, 0x000e640000000200ULL, 0x3fb8aa3b11407820ULL, 0x000fe40000410000ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x20000005ff417230ULL, 0x004fc60000004100ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x30000005ff3c7230ULL, 0x000fe40000004100ULL,
0x20000007ff437230ULL, 0x000fe40000004100ULL, 0x30000007ff3e7230ULL, 0x000fe40000004100ULL,
0x20000009ff457230ULL, 0x008fe40000004100ULL, 0x2000000bff477230ULL, 0x000fe40000004100ULL,
0x3000000bff427230ULL, 0x000fc40000004100ULL, 0x20000006ff057230ULL, 0x000fe40000004100ULL,
0x0000003f404c7220ULL, 0x004fe20000410000ULL, 0x30000009ff407230ULL, 0x000fe40000004100ULL,
0x20000004ff3f7230ULL, 0x000fe40000004100ULL, 0x000000354c357221ULL, 0x000fe20000010000ULL,
0x00001f374c4e7589ULL, 0x000ea200000e0000ULL, 0x20000008ff077230ULL, 0x000fe40000004100ULL,
0x2000000aff097230ULL, 0x000fe20000004100ULL, 0x00001f3b4c507589ULL, 0x000ee200000e0000ULL,
0x30000004ff047230ULL, 0x000fc40000004100ULL, 0x30000006ff067230ULL, 0x000fe40000004100ULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x2000000dff497230ULL, 0x002fe40000004100ULL, 0x3000000dff447230ULL, 0x000fe40000004100ULL,
0x2000000fff4b7230ULL, 0x000fc40000004100ULL, 0x3000000fff467230ULL, 0x000fe40000004100ULL,
0x20000011ff4d7230ULL, 0x010fe40000004100ULL, 0x30000011ff487230ULL, 0x000fe40000004100ULL,
0x0000004e3f347223ULL, 0x084fe20000010034ULL, 0x2000000cff0b7230ULL, 0x000fe40000004100ULL,
0x0000004e04337223ULL, 0x000fe20000010033ULL, 0x2000000eff0d7230ULL, 0x000fc40000004100ULL,
0x0000004e41327223ULL, 0x080fe20000010032ULL, 0x20000010ff0f7230ULL, 0x000fe40000004100ULL,
0x0000004e3c317223ULL, 0x080fe20000010031ULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x0000004e05307223ULL, 0x080fe20000010030ULL, 0x3000000cff0c7230ULL, 0x000fe40000004100ULL,
0x0000004e062f7223ULL, 0x000fe2000001002fULL, 0x3000000eff0e7230ULL, 0x000fc40000004100ULL,
0x0000004e432e7223ULL, 0x080fe2000001002eULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000004e3e2d7223ULL, 0x080fe2000001002dULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x0000004e072c7223ULL, 0x080fe2000001002cULL, 0x20000013ff4f7230ULL, 0x000fe40000004100ULL,
0x0000004e082b7223ULL, 0x000fe2000001002bULL, 0x30000013ff4a7230ULL, 0x000fc40000004100ULL,
0x0000004e452a7223ULL, 0x080fe2000001002aULL, 0x0000004e40297223ULL, 0x080fe20000010029ULL,
0x0000004e09287223ULL, 0x080fe20000010028ULL, 0x0000004e0a277223ULL, 0x080fe20000010027ULL,
0x0000004e47267223ULL, 0x080fe20000010026ULL, 0x0000004e42257223ULL, 0x000fe20000010025ULL,
0x000000500b247223ULL, 0x088fe20000010024ULL, 0x000000500c237223ULL, 0x080fe20000010023ULL,
0x0000005049227223ULL, 0x080fe20000010022ULL, 0x0000005044217223ULL, 0x080fe20000010021ULL,
0x000000500d207223ULL, 0x080fe20000010020ULL, 0x000000500e1f7223ULL, 0x080fe2000001001fULL,
0x000000504b1e7223ULL, 0x080fe2000001001eULL, 0x00000050461d7223ULL, 0x080fe2000001001dULL,
0x000000500f1c7223ULL, 0x080fe2000001001cULL, 0x00000050101b7223ULL, 0x080fe2000001001bULL,
0x000000504d1a7223ULL, 0x080fe2000001001aULL, 0x0000005048197223ULL, 0x080fe20000010019ULL,
0x0000005011187223ULL, 0x080fe20000010018ULL, 0x0000005012177223ULL, 0x080fe20000010017ULL,
0x000000504f167223ULL, 0x080fe20000010016ULL, 0x000000504a157223ULL, 0x000fe20000010015ULL,
0xfffffff400c48947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00000021ff007c0cULL, 0x000fe2000bf05270ULL, 0x000049800a047890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c00037812ULL, 0x000fc800078ec0ffULL,
0x0000000403027c10ULL, 0x000fe2000fffe002ULL, 0x0000000000200947ULL, 0x000fec0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000000a060a7291ULL, 0x000fe2000f8e383fULL,
0x0000001000037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011600ULL,
0x0000007003007812ULL, 0x000fe400078ec0ffULL, 0x0000000c04037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03007c10ULL, 0x000fca000fffe000ULL, 0x0049803500007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000002007984ULL, 0x002e680000000800ULL,
0x0000800002037984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000300007221ULL, 0x004fc80000010000ULL, 0x0180000000037836ULL, 0x000fca0000000000ULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0000ULL, 0x0000999000057802ULL, 0x000fce0000000f00ULL,
0x0000007c00c87944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000000037308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000003ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fce0000000003ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe40000011602ULL,
0x00000008020b7811ULL, 0x002fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011602ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0904007589ULL, 0x000e6200000e0000ULL,
0xfffffff8ff0d7812ULL, 0x000fc600078ee202ULL, 0x00001f0b040c7589ULL, 0x0004e400000e0000ULL,
0x000000080d117836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000303047812ULL, 0x004fc800078ec0ffULL, 0x00000004040e7812ULL, 0x000fe400078efcffULL,
0x00000007040f7812ULL, 0x000fe400078e780dULL, 0x0000000704137812ULL, 0x000fe200078e7811ULL,
0x0000000811047824ULL, 0x000fe400078e00ffULL, 0x0000003400347220ULL, 0x042fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000003200057220ULL, 0x040fe20000410000ULL,
0x0000003100067220ULL, 0x000fe20000410000ULL, 0x000000240c247220ULL, 0x048fe20000410000ULL,
0x000000230c237220ULL, 0x040fe20000410000ULL, 0x000000220c227220ULL, 0x040fe20000410000ULL,
0x000000210c217220ULL, 0x040fe20000410000ULL, 0x000000200c207220ULL, 0x040fe20000410000ULL,
0x0000001f0c1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0c1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0c1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0c1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0c1b7220ULL, 0x040fe20000410000ULL, 0x0000001a0c1a7220ULL, 0x040fe20000410000ULL,
0x000000190c197220ULL, 0x040fe20000410000ULL, 0x000000180c187220ULL, 0x040fe20000410000ULL,
0x000000170c177220ULL, 0x040fe20000410000ULL, 0x000000160c167220ULL, 0x040fe20000410000ULL,
0x000000150c157220ULL, 0x000fe20000410000ULL, 0x000000080d0c7824ULL, 0x000fc400078e00ffULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000002e00077220ULL, 0x040fe20000410000ULL, 0x0000002d00087220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002a00097220ULL, 0x040fe20000410000ULL, 0x00000029000a7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x00000026000b7220ULL, 0x040fe20000410000ULL, 0x000000070e0d7812ULL, 0x000fe200078e780dULL,
0x0000002500007220ULL, 0x000fe20000410000ULL, 0x000000070e117812ULL, 0x000fc400078e7811ULL,
0x0000000c0f0f7212ULL, 0x080fe400078efcffULL, 0x0000000c0d0d7212ULL, 0x000fe200078efcffULL,
0x00000020020c7c36ULL, 0x000fe20008000000ULL, 0x0000000413137212ULL, 0x080fe400078efcffULL,
0x0000000411117212ULL, 0x000fe400078efcffULL, 0x000000050605723eULL, 0x000fe400000000ffULL,
0x0000000b000b723eULL, 0x000fc400000000ffULL, 0x000000343304723eULL, 0x000fe400000000ffULL,
0x000000302f06723eULL, 0x000fe400000000ffULL, 0x000000070807723eULL, 0x000fe400000000ffULL,
0x000000090a09723eULL, 0x000fe400000000ffULL, 0x000000201f26723eULL, 0x000fe400000000ffULL,
0x000000130f007c11ULL, 0x000fc4000f8e20ffULL, 0x0000002c2b08723eULL, 0x000fe400000000ffULL,
0x00000028270a723eULL, 0x000fe200000000ffULL, 0x0000000400007844ULL, 0x000fe20000000200ULL,
0x000000222125723eULL, 0x000fe400000000ffULL, 0x000000130d207c11ULL, 0x000fe4000f8e20ffULL,
0x000000242324723eULL, 0x000fe400000000ffULL, 0x0000001e1d27723eULL, 0x000fe200000000ffULL,
0x0000000820007844ULL, 0x000fe20000000200ULL, 0x0000001313217c11ULL, 0x000fc4000f8e20ffULL,
0x0000001c1b1c723eULL, 0x000fe400000000ffULL, 0x0000001a191d723eULL, 0x000fe200000000ffULL,
0x0000002421007844ULL, 0x000fe20000000200ULL, 0x00000018171e723eULL, 0x000fe400000000ffULL,
0x00000016151f723eULL, 0x000fe400000000ffULL, 0x0000001311227c11ULL, 0x000fe4000f8e20ffULL,
0x000000070c237c11ULL, 0x000fc6000f8e20ffULL, 0x0000001c22007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000230c7984ULL, 0x000e680000000c00ULL,
0x0004000023147984ULL, 0x000ea80000000c00ULL, 0x0008000023107984ULL, 0x000ee80000000c00ULL,
0x000c000023187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c23007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001423007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x0000002002117836ULL, 0x000fe20000000000ULL,
0x0000000703057812ULL, 0x000fe200078e4802ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000321067899ULL, 0x000fe2000800063fULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0ffffff805077812ULL, 0x000fe200078ef802ULL, 0x0000860000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000704007812ULL, 0x000fe200078e4811ULL, 0x00000006ff127e24ULL, 0x000fc6000f8e00ffULL,
0x0ffffff800057812ULL, 0x000fe400078ef811ULL, 0x0000000707007c11ULL, 0x000fe4000f8e20ffULL,
0x0000000705057c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000000000087984ULL, 0x0023680000000c00ULL, 0x00000000050c7984ULL, 0x0003620000000c00ULL,
0x00000005040472a4ULL, 0x010fc4000f8e023fULL, 0x0000000321057899ULL, 0x000fe2000800063fULL,
0x0000000806107824ULL, 0x048fe400078e00ffULL, 0x0000000806077824ULL, 0x000fc600078e00ffULL,
0x00000005ff137e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff810037812ULL, 0x000fe400078ee203ULL,
0xfffffff807047812ULL, 0x000fe400078ee204ULL, 0x0000000403077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404007c10ULL, 0x002fe4000ff3e0ffULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000807047c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x0000000800067c11ULL, 0x000fc4000f8240ffULL,
0x0000000907057c11ULL, 0x004fe400080f4410ULL, 0x0000000900077c11ULL, 0x000fe200088f4403ULL,
0x0000001013027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x020fe8000c101d18ULL, 0x0000000c04007986ULL, 0x000fe2000c101d18ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000005d0672caULL, 0x000fe200000e0000ULL,
0x00000001ff027424ULL, 0x000fcc00078e00ffULL, 0x01b60002ff0279a7ULL, 0x000e6c0008500007ULL,
0x0000001b06067291ULL, 0x000fc8000f8e103fULL, 0x000000080600728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00000001040c8899ULL, 0x000fe2000800063fULL,
0x00009000000a8ab9ULL, 0x000fc60000000800ULL, 0x0000000a0c0c82a4ULL, 0x000fc6000f8e0206ULL,
0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL, 0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff057e24ULL, 0x000fca000f8e00ffULL,
0x0000001804048981ULL, 0x000ea2000c1e1900ULL, 0x000000015d067836ULL, 0x000fe20000000000ULL,
0x000000060d0c7899ULL, 0x000fe2000800063fULL, 0x0000000000227919ULL, 0x000e620000000000ULL,
0xffffffff000f7882ULL, 0x000fe20000000000ULL, 0x000000061b107899ULL, 0x000fe2000800063fULL,
0x00000000040a82caULL, 0x004fe400000e0000ULL, 0x0000000506007c0cULL, 0x000fd6000bf06070ULL,
0x0000000a000f8c82ULL, 0x000fe40008000000ULL, 0x0000000c0f0b72a4ULL, 0x000fe2000f8e023fULL,
0x0000000c00ac8947ULL, 0x002ff60003800000ULL, 0x000000105d047c11ULL, 0x000fe2000f8e40ffULL,
0x00000009ff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff077819ULL, 0x000fe20000011622ULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x0000002204057c48ULL, 0x000fe2000ffe0000ULL,
0x000000071b0a7291ULL, 0x000fe2000f8e703fULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000407097836ULL, 0x000fe40000000000ULL, 0x0000000105047824ULL, 0x000fe200078e0a04ULL,
0x000010000a0a7890ULL, 0x000fe2000fffe03fULL, 0x0000000809107824ULL, 0x040fe200078e00ffULL,
0x0000002209057212ULL, 0x000fe200078e3cffULL, 0x00000008070b7836ULL, 0x000fe20000000000ULL,
0x000000040900720cULL, 0x000fe20003f06070ULL, 0x0000000c07097836ULL, 0x000fe20000000000ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000080b147824ULL, 0x040fe200078e00ffULL,
0x000000220b057212ULL, 0x000fe200078e3cffULL, 0x0000001407117836ULL, 0x000fe20000000000ULL,
0x000000040b00720cULL, 0x000fe20003f46070ULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0x0000002209067212ULL, 0x000fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000004008057824ULL, 0x000fe200078e0207ULL,
0xfffffff80b167812ULL, 0x000fe200078ee206ULL, 0x0000001807177836ULL, 0x000fe20000000000ULL,
0x000000040900720cULL, 0x000fe20003f26070ULL, 0x0000000405067836ULL, 0x000fe20000000000ULL,
0x0000000b050a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001007097836ULL, 0x000fe20000000000ULL,
0x00000022110e7212ULL, 0x080fe200078e3cffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x0000000b06067c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000809197824ULL, 0x040fe200078e00ffULL,
0x0000002209087212ULL, 0x040fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x000000040900720cULL, 0x000fe20003f86070ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00000012060b7c11ULL, 0x000fc4000f8a40ffULL, 0x000000120a0d7c11ULL, 0x000fe4000f8640ffULL,
0x00000013060c7c11ULL, 0x000fe2000a8f4409ULL, 0x0000000805067836ULL, 0x000fe20000000000ULL,
0x000000130a0a7c11ULL, 0x000fe400098f440fULL, 0x0000000707097812ULL, 0x000fe400078e4822ULL,
0x0000000b06067c10ULL, 0x000fe4000ffde0ffULL, 0x000000040700720cULL, 0x000fc40003f66070ULL,
0xfffffff819197812ULL, 0x000fe200078ee208ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x0000000d00087210ULL, 0x000fe40007fbe0ffULL, 0x0ffffff8090d7812ULL, 0x000fe400078ef822ULL,
0x0000001206157c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff097224ULL, 0x000fe200028e060aULL,
0xfffffff8131e7812ULL, 0x000fe400078ee20eULL, 0x0000000b000a7210ULL, 0x000fc40007fbe0ffULL,
0x0000000a0d0d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000013060e7c11ULL, 0x000fe2000b0f440fULL,
0x0000000c05067836ULL, 0x000fe20000000000ULL, 0x0000000a100f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e060cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000d901c58ULL, 0x000000041100720cULL, 0x000fe40003fa6070ULL,
0x0000000b060c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001005067836ULL, 0x000fe20000000000ULL,
0x000000000a0f7faeULL, 0x0005e2000c101c58ULL, 0x0000002217107212ULL, 0x000fc400078e3cffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000000b06127c10ULL, 0x000fe2000ffde0ffULL,
0x0000001405067836ULL, 0x000fe20000000000ULL, 0x000000120c117c11ULL, 0x000fe2000f8640ffULL,
0x0000001c070d7836ULL, 0x002fe20000000000ULL, 0x000000041700720cULL, 0x000fe20003f06070ULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x0000001212177c11ULL, 0x000fe2000f8c40ffULL,
0x000000080d217824ULL, 0x000fe200078e00ffULL, 0x000000130c0c7c11ULL, 0x000fe400098f4413ULL,
0x0000001500087210ULL, 0x000fc40007f7e0ffULL, 0x0000001312127c11ULL, 0x000fe4000b0f4409ULL,
0x0000000b06067c10ULL, 0x000fe2000ffde0ffULL, 0x000000ffff097224ULL, 0x000fe200018e060eULL,
0x00000011000a7210ULL, 0x004fe20007f7e0ffULL, 0x0000002007117836ULL, 0x000fe20000000000ULL,
0xfffffff81b207812ULL, 0x000fe200078ee210ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x0000001206157c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e060cULL,
0x000000220d0e7212ULL, 0x000fc400078e3cffULL, 0x000000040d00720cULL, 0x000fe40003f66070ULL,
0x0000000a140d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001306107c11ULL, 0x000fe2000b0f440fULL,
0x0000001805067836ULL, 0x000fe20000000000ULL, 0x0000000a160f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000080d7faeULL, 0x0003e2000d101c58ULL, 0x00000022110c7212ULL, 0x000fe400078e3cffULL,
0x0000000b061c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001c05067836ULL, 0x000fe20000000000ULL,
0x000000000a0f7faeULL, 0x0005e2000c901c58ULL, 0x000000041100720cULL, 0x040fe20003f26070ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000000b061a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000002005067836ULL, 0x000fe20000000000ULL, 0x000000121c1d7c11ULL, 0x040fe2000f8440ffULL,
0x00000024070d7836ULL, 0x002fe20000000000ULL, 0xfffffff8110e7812ULL, 0x000fe200078ee20cULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x000000131c1c7c11ULL, 0x000fe200090f4413ULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x000000121a1b7c11ULL, 0x000fc4000f8c40ffULL,
0x0000001700087210ULL, 0x000fe40007f5e0ffULL, 0x000000131a1a7c11ULL, 0x000fe4000b0f4409ULL,
0x0000000b06187c10ULL, 0x000fe2000ffde0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0612ULL,
0x00000015000a7210ULL, 0x004fe40007f5e0ffULL, 0x000000220d067212ULL, 0x040fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000001218157c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e0610ULL, 0x000000040d00720cULL, 0x000fc40003f46070ULL,
0xfffffff811107812ULL, 0x000fe200078ee206ULL, 0x0000002405067836ULL, 0x000fe20000000000ULL,
0x0000000a190d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002807117836ULL, 0x000fe20000000000ULL,
0x0000001318187c11ULL, 0x000fe4000b0f440fULL, 0x0000000a1e0f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000080d7faeULL, 0x0003e2000e101c58ULL, 0x0000000b06167c10ULL, 0x000fe2000ff9e0ffULL,
0x0000002805067836ULL, 0x000fe20000000000ULL, 0x00000022110c7212ULL, 0x040fe200078e3cffULL,
0x000000000a0f7faeULL, 0x0005e2000e901c58ULL, 0x000000041100720cULL, 0x040fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000001216197c11ULL, 0x040fe2000f8840ffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000000b061f7c10ULL, 0x000fe2000ffde0ffULL,
0x0000002c05067836ULL, 0x000fe20000000000ULL, 0x0000001316167c11ULL, 0x000fe2000a0f4413ULL,
0x0000002c070d7836ULL, 0x002fe20000000000ULL, 0x0000001d00087210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000121f177c11ULL, 0x000fe2000f8c40ffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fe200078ee20cULL,
0x000000ffff097224ULL, 0x000fe200020e061cULL, 0x000000131f1f7c11ULL, 0x000fc4000b0f4414ULL,
0x0000001b000a7210ULL, 0x004fe40007f9e0ffULL, 0x0000000b061e7c10ULL, 0x000fe4000ffde0ffULL,
0x000000220d067212ULL, 0x040fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200020e061aULL,
0x000000040d00720cULL, 0x000fe20003f86070ULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0xfffffff813147812ULL, 0x000fe200078ee206ULL, 0x00000030070d7836ULL, 0x000fe20000000000ULL,
0x000000121e1b7c11ULL, 0x000fe2000f8c40ffULL, 0x0000003005067836ULL, 0x000fe20000000000ULL,
0x0000000a200f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000080d1a7824ULL, 0x000fe200078e00ffULL,
0x000000131e1e7c11ULL, 0x000fc4000b0f4411ULL, 0x000000220d137212ULL, 0x000fe200078e3cffULL,
0x00000000080f7faeULL, 0x0003e2000c101c58ULL, 0x0000000b061c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000003405067836ULL, 0x000fe20000000000ULL, 0x0000000a21117c11ULL, 0x000fe4000f8e20ffULL,
0x00000015000c7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff81a157812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x000000000a117faeULL, 0x0005e2000d901c58ULL,
0x000000040d00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0618ULL,
0x000000121c0f7c11ULL, 0x002fc4000f8c40ffULL, 0x0000001900087210ULL, 0x000fe20007f1e0ffULL,
0x0000003c07197836ULL, 0x000fe20000000000ULL, 0x000000131c1c7c11ULL, 0x000fe4000b0f4413ULL,
0x0000000b061a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0616ULL,
0x0000000a15157c11ULL, 0x000fe2000f8e20ffULL, 0x00000034070b7836ULL, 0x004fe20000000000ULL,
0x0000000a0e117c11ULL, 0x000fe2000f8e20ffULL, 0x00000038050a7836ULL, 0x000fe40000000000ULL,
0x000000080b137824ULL, 0x040fe200078e00ffULL, 0x000000220b067212ULL, 0x040fe200078e3cffULL,
0x000000000c117faeULL, 0x0003e2000c901c58ULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0xfffffff813167812ULL, 0x000fe200078ee206ULL,
0x0000003c05057836ULL, 0x000fe20000000000ULL, 0x0000000a10137c11ULL, 0x000fc4000f8e20ffULL,
0x000000121a1d7c11ULL, 0x040fe4000f8c40ffULL, 0x0000000b0a187c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000008137faeULL, 0x0005e2000d101c58ULL, 0x0000001700067210ULL, 0x000fe20007f5e0ffULL,
0x0000003807177836ULL, 0x000fe20000000000ULL, 0x000000131a1a7c11ULL, 0x000fe2000b0f440bULL,
0x000000ffff0d7224ULL, 0x002fe200008e06ffULL, 0x0000001b000a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200010e061fULL, 0x00000012181b7c11ULL, 0x000fc4000f8240ffULL,
0x0000000f000e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e061eULL,
0x0000001318187c11ULL, 0x000fe200088f440dULL, 0x0000000817097824ULL, 0x044fe200078e00ffULL,
0x0000000b05107c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x000000041700720cULL, 0x080fe20003fc6070ULL, 0x0000000819087824ULL, 0x040fe200078e00ffULL,
0x000000041900720cULL, 0x000fe20003f46070ULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x0000002217047212ULL, 0x000fc400078e3cffULL, 0x0000001210177c11ULL, 0x000fe4000f8240ffULL,
0x0000000a12117c11ULL, 0x000fe4000f8e20ffULL, 0x0000001310107c11ULL, 0x000fe400088f4413ULL,
0x0000000a14137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006117faeULL, 0x0003e2000e901c58ULL,
0x0000002219057212ULL, 0x000fe400078e3cffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x000000000a137faeULL, 0x0003e2000e101c58ULL, 0xfffffff8080d7812ULL, 0x000fc400078ee205ULL,
0x0000001d00047210ULL, 0x000fe20007f3e0ffULL, 0x000000000e157faeULL, 0x0003e2000d901c58ULL,
0x0000001b00087210ULL, 0x000fe40007f7e0ffULL, 0x00000017000c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e061aULL, 0x0000000a16177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a09197c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200018e0618ULL,
0x0000000a0d1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0610ULL,
0x0000000004177faeULL, 0x0003e8000c101c58ULL, 0x0000000008197faeULL, 0x0003e8000f101c58ULL,
0x000000000c1b7faeULL, 0x0003e2000d101c58ULL, 0x0000000c005c7947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011622ULL, 0x00000009ff167e24ULL, 0x000fe2000f8e00ffULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x000000071b0a7291ULL, 0x000fe2000f8e703fULL, 0x0000000413047836ULL, 0x040fe40000000000ULL,
0x0000000813067836ULL, 0x040fe20000000000ULL, 0x000010000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000000c13087836ULL, 0x040fe20000000000ULL, 0x0000002204057212ULL, 0x0c0fe200078e3cffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000002206077212ULL, 0x0c0fe200078e3cffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x0000002208067212ULL, 0x0c0fe200078e3cffULL,
0x0000000808097824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee205ULL,
0x0000001013057836ULL, 0x040fe20000000000ULL, 0xfffffff80a077812ULL, 0x000fe200078ee207ULL,
0x0000001c130b7836ULL, 0x040fe20000000000ULL, 0xfffffff809067812ULL, 0x000fe200078ee206ULL,
0x0000001413097836ULL, 0x000fe20000000000ULL, 0x0000002205087212ULL, 0x0c0fe200078e3cffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000000a07077c11ULL, 0x000fe2000f8e20ffULL,
0x00000008090d7824ULL, 0x040fe200078e00ffULL, 0x00000022090a7212ULL, 0x080fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff805057812ULL, 0x000fe200078ee208ULL,
0x0000001813087836ULL, 0x040fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x00000028130d7836ULL, 0x000fe20000000000ULL, 0x0000000a05057c11ULL, 0x000fe2000f8e20ffULL,
0x00000008080c7824ULL, 0x040fe200078e00ffULL, 0x0000002208097212ULL, 0x080fe200078e3cffULL,
0x0000003413117836ULL, 0x000fe20000000000ULL, 0x000000220b087212ULL, 0x000fe200078e3cffULL,
0x00000020130b7836ULL, 0x040fe20000000000ULL, 0xfffffff80c097812ULL, 0x000fe200078ee209ULL,
0x00000024130c7836ULL, 0x000fe20000000000ULL, 0xfffffff80f087812ULL, 0x000fc400078ee208ULL,
0x000000220b107212ULL, 0x0c0fe200078e3cffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x000000220c0f7212ULL, 0x0c0fe200078e3cffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x000000220d0e7212ULL, 0x0c0fe200078e3cffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee210ULL, 0x0000002c130b7836ULL, 0x040fe20000000000ULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee20fULL, 0x00000030130c7836ULL, 0x000fe20000000000ULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee20eULL, 0x000000080b147824ULL, 0x040fe200078e00ffULL,
0x000000220b0d7212ULL, 0x000fc400078e3cffULL, 0x000000220c0b7212ULL, 0x0c0fe200078e3cffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000002211127212ULL, 0x0c0fe200078e3cffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0xfffffff8140d7812ULL, 0x000fe200078ee20dULL,
0x0000004016147824ULL, 0x000fe200078e0213ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x0000003c13167836ULL, 0x040fe20000000000ULL, 0xfffffff8110b7812ULL, 0x000fe200078ee212ULL,
0x0000000414117836ULL, 0x000fe20000000000ULL, 0x0000000b14157c10ULL, 0x000fe2000ff1e0ffULL,
0x0000003813127836ULL, 0x000fe20000000000ULL, 0x00000022161c7212ULL, 0x000fc400078e3cffULL,
0x0000000b11187c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000816117824ULL, 0x000fe200078e00ffULL,
0x00000022121a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000001215177c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x00000012181b7c11ULL, 0x000fe2000f8240ffULL, 0x00000008121d7824ULL, 0x000fe200078e00ffULL,
0x0000001315167c11ULL, 0x000fe200080f4416ULL, 0x0000000814157836ULL, 0x000fe20000000000ULL,
0x0000001318197c11ULL, 0x000fe200088f4419ULL, 0x0000000c14187836ULL, 0x040fe20000000000ULL,
0xfffffff81d127812ULL, 0x000fe200078ee21aULL, 0x00000014141d7836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fc4000ff1e0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee21cULL,
0x00000010141c7836ULL, 0x040fe20000000000ULL, 0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000b1d1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x00000012151d7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x0000000b1c1c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x00000013151f7c11ULL, 0x000fe200080f4418ULL, 0x0000001814157836ULL, 0x000fe20000000000ULL,
0x000000121a237c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x000000121c277c11ULL, 0x000fe2000f8440ffULL, 0x0000001c14187836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fc4000ff1e0ffULL, 0x000000131c257c11ULL, 0x000fe200090f4425ULL,
0x00000020141c7836ULL, 0x000fe20000000000ULL, 0x000000131a217c11ULL, 0x000fe400088f4421ULL,
0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00000012152d7c11ULL, 0x000fe4000f8040ffULL, 0x000000121e2b7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x0000000b1c1c7c10ULL, 0x000fc4000ff5e0ffULL,
0x00000013152c7c11ULL, 0x000fe200080f4418ULL, 0x0000002814157836ULL, 0x000fe20000000000ULL,
0x000000131e297c11ULL, 0x000fe200098f4429ULL, 0x00000024141e7836ULL, 0x000fe20000000000ULL,
0x000000121a317c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x000000121c357c11ULL, 0x000fe2000f8440ffULL, 0x0000002c14187836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b1e1e7c10ULL, 0x000fc4000ff7e0ffULL,
0x000000131c337c11ULL, 0x000fe200090f4433ULL, 0x00000030141c7836ULL, 0x000fe20000000000ULL,
0x000000131a2f7c11ULL, 0x000fe200088f442fULL, 0x000000ffff377224ULL, 0x000fe200018e06ffULL,
0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00000012153b7c11ULL, 0x000fe4000f8040ffULL, 0x000000121e397c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x0000000b1c1c7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001315347c11ULL, 0x000fe200080f4418ULL, 0x0000003814157836ULL, 0x000fe20000000000ULL,
0x000000131e377c11ULL, 0x000fe200098f4437ULL, 0x00000034141e7836ULL, 0x000fe20000000000ULL,
0x000000121a3f7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff417224ULL, 0x000fe200010e06ffULL,
0x000000121c437c11ULL, 0x000fe2000f8440ffULL, 0x0000003c14147836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fe4000ff1e0ffULL, 0x000000131a3d7c11ULL, 0x000fc400088f443dULL,
0x000000131c417c11ULL, 0x000fe200090f4441ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000000b141a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000b1e1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001215497c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x0000001700147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x0000000713137812ULL, 0x000fc400078e4822ULL, 0x000000121a4d7c11ULL, 0x000fe4000f8440ffULL,
0x000000121e477c11ULL, 0x000fe4000f8640ffULL, 0x0000001315367c11ULL, 0x000fe200088f4418ULL,
0x000000ffff157224ULL, 0x000fe200000e0616ULL, 0x0ffffff813137812ULL, 0x000fe400078ef822ULL,
0x000000131a4b7c11ULL, 0x000fe400090f444bULL, 0x0000001b00167210ULL, 0x000fc40007f3e0ffULL,
0x000000131e457c11ULL, 0x000fe400098f4445ULL, 0x0000001d00187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0619ULL, 0x00000023001a7210ULL, 0x000fe40007f7e0ffULL,
0x00000027001c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200010e061fULL,
0x0000000a13137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e0621ULL,
0x0000002b001e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e0625ULL,
0x0000002d00207210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014137faeULL, 0x000fe2000b901c58ULL, 0x0000000a04277c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e0629ULL, 0x0000003100227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e062cULL, 0x0000003500247210ULL, 0x000fe20007f5e0ffULL,
0x0000000016277faeULL, 0x0003e2000b901c58ULL, 0x0000000a062b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff237224ULL, 0x000fe200008e062fULL, 0x0000003900287210ULL, 0x000fe20007f7e0ffULL,
0x0000000018077faeULL, 0x000fe2000b901c58ULL, 0x0000003b00267210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e0633ULL, 0x0000000a0a2d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001a2b7faeULL, 0x0005e2000b901c58ULL, 0x0000003f002a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e0637ULL, 0x0000000a09097c11ULL, 0x000fe2000f8e20ffULL,
0x000000001c057faeULL, 0x000fe2000b901c58ULL, 0x00000043002c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff277224ULL, 0x002fe200028e0634ULL, 0x0000000a08137c11ULL, 0x000fe2000f8e20ffULL,
0x000000001e2d7faeULL, 0x0003e2000b901c58ULL, 0x00000047002e7210ULL, 0x000fc40007f3e0ffULL,
0x0000000a10157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000020097faeULL, 0x0007e2000b901c58ULL,
0x0000004900307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x004fe200020e063dULL,
0x0000000a0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000022137faeULL, 0x0009e2000b901c58ULL,
0x0000004d00327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0645ULL,
0x0000000a0e077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff2d7224ULL, 0x002fe200000e0641ULL,
0x0000000a0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000024157faeULL, 0x0009e2000b901c58ULL,
0x0000000a0c057c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200010e0636ULL,
0x0000000a0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000280f7faeULL, 0x0009e2000b901c58ULL,
0x0000000a12097c11ULL, 0x008fe2000f8e20ffULL, 0x000000ffff337224ULL, 0x000fe200018e064bULL,
0x0000000a11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000026077faeULL, 0x0009e8000b901c58ULL,
0x000000002a0d7faeULL, 0x0009e8000b901c58ULL, 0x000000002c057faeULL, 0x0009e8000b901c58ULL,
0x000000002e0b7faeULL, 0x0009e8000b901c58ULL, 0x0000000030097faeULL, 0x0009e8000b901c58ULL,
0x0000000032117faeULL, 0x0009e4000b901c58ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b60003ff0075a7ULL, 0x000ea20008000147ULL, 0x000000055d007c0cULL, 0x000fe2000bf26070ULL,
0x00000050006c8947ULL, 0x004fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00009000000d7ab9ULL, 0x000fe40000000800ULL, 0x0000000d040d72a4ULL, 0x000fd8000f8e023fULL,
0x000000105d317c11ULL, 0x010fc8000f8e40ffULL, 0x0000002231007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000015d007836ULL, 0x000fe20000000000ULL,
0x00000000006c7919ULL, 0x000ea20000000000ULL, 0x0000000f0c0a72a4ULL, 0x000fc6000f8e023fULL,
0x0000000500007c0cULL, 0x000fda000bf06070ULL, 0x0000000c006c8947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x004fe2000001166cULL, 0x00000009ff0d7e24ULL, 0x002fe2000f8e00ffULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x0000002231317c10ULL, 0x000fe2000fffe1ffULL,
0x000000071b047291ULL, 0x000fe2000f8e703fULL, 0x0000000800037836ULL, 0x040fe40000000000ULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0000300004117890ULL, 0x000fe2000fffe03fULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x0000006c03557212ULL, 0x080fe200078e3cffULL,
0x0000000804097824ULL, 0x040fe200078e00ffULL, 0x0000006c04547212ULL, 0x080fe200078e3cffULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0xfffffff806557812ULL, 0x000fe200078ee255ULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0xfffffff809547812ULL, 0x000fe200078ee254ULL,
0x0000000805087824ULL, 0x040fe200078e00ffULL, 0x0000006c05537212ULL, 0x080fe200078e3cffULL,
0x0000000806097824ULL, 0x040fe200078e00ffULL, 0x0000006c06527212ULL, 0x080fe200078e3cffULL,
0x0000000400027836ULL, 0x040fe20000000000ULL, 0xfffffff808537812ULL, 0x000fe200078ee253ULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0xfffffff809527812ULL, 0x000fe200078ee252ULL,
0x000000400d097824ULL, 0x000fe200078e0200ULL, 0x0000006c02567212ULL, 0x0c0fe200078e3cffULL,
0x0000000802077824ULL, 0x000fe200078e00ffULL, 0x0000006c08507212ULL, 0x0c0fe200078e3cffULL,
0x00000008080b7824ULL, 0x000fe200078e00ffULL, 0x0000000a090f7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000008096a7836ULL, 0x040fe20000000000ULL, 0xfffffff807567812ULL, 0x000fe200078ee256ULL,
0x00000004096b7836ULL, 0x000fe20000000000ULL, 0xfffffff80b507812ULL, 0x000fe200078ee250ULL,
0x0000001800077836ULL, 0x040fe20000000000ULL, 0x0000000a6a0b7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000a6b0d7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000006c07517212ULL, 0x080fe200078e3cffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x000000120f2a7c11ULL, 0x000fe2000f8040ffULL,
0x0000000c09697836ULL, 0x000fe20000000000ULL, 0x000000120b2c7c11ULL, 0x000fe2000f8440ffULL,
0x0000001809627836ULL, 0x000fe20000000000ULL, 0xfffffff80a517812ULL, 0x000fe200078ee251ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x000000120d2e7c11ULL, 0x000fe2000f8240ffULL,
0x00000020000a7836ULL, 0x000fe20000000000ULL, 0x000000130f2b7c11ULL, 0x000fe200080f4410ULL,
0x0000001009677836ULL, 0x000fe20000000000ULL, 0x000000130b2d7c11ULL, 0x000fe200090f440cULL,
0x0000001409637836ULL, 0x040fe20000000000ULL, 0x0000000a69117c10ULL, 0x000fe2000ff1e0ffULL,
0x000000080a127824ULL, 0x040fe200078e00ffULL, 0x0000000a620b7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000028095e7836ULL, 0x000fe20000000000ULL, 0x000000130d2f7c11ULL, 0x000fe200088f440eULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x0000006c0a4f7212ULL, 0x000fe200078e3cffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x0000000a670f7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001c09617836ULL, 0x040fe20000000000ULL, 0x0000000a630d7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000024095f7836ULL, 0x000fe20000000000ULL, 0x0000001211287c11ULL, 0x000fe2000f8040ffULL,
0x0000002009607836ULL, 0x000fe20000000000ULL, 0xfffffff8124f7812ULL, 0x000fe200078ee24fULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x000000120b107c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x000000120f247c11ULL, 0x000fe2000f8240ffULL,
0x0000003809597836ULL, 0x000fe20000000000ULL, 0x000000120d227c11ULL, 0x000fe2000f8440ffULL,
0x0000002c095c7836ULL, 0x000fe20000000000ULL, 0x0000001311297c11ULL, 0x000fe200080f4414ULL,
0x00000034095a7836ULL, 0x000fe20000000000ULL, 0x000000130b117c11ULL, 0x000fe200098f440cULL,
0x00000030095b7836ULL, 0x040fe20000000000ULL, 0x0000000a5e0b7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000003c09587836ULL, 0x000fe20000000000ULL, 0x000000130f257c11ULL, 0x000fc400088f4412ULL,
0x000000130d237c11ULL, 0x000fe200090f440eULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x0000000a610f7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000a5f137c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a600d7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x000000120b1e7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x000000120f0e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000001213207c11ULL, 0x000fc4000f8440ffULL, 0x000000130b1f7c11ULL, 0x000fe400098f4412ULL,
0x000000120d0c7c11ULL, 0x000fe4000f8240ffULL, 0x0000000a590b7c10ULL, 0x000fe4000ff7e0ffULL,
0x000000130f0f7c11ULL, 0x000fe400080f4418ULL, 0x0000001313217c11ULL, 0x000fe200090f4414ULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x0000000a5c177c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000a5a137c10ULL, 0x000fe4000ff5e0ffULL, 0x000000130d0d7c11ULL, 0x000fe200088f4416ULL,
0x000000ffff307224ULL, 0x000fe200000e06ffULL, 0x0000000a5b157c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x000000120b187c11ULL, 0x000fe4000f8640ffULL,
0x00000012171c7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff267224ULL, 0x000fe200008e06ffULL,
0x0000001213167c11ULL, 0x000fc4000f8440ffULL, 0x000000130b197c11ULL, 0x000fe400098f4412ULL,
0x0000001215147c11ULL, 0x000fe4000f8240ffULL, 0x0000006c000b7212ULL, 0x000fe400078e3cffULL,
0x00000013171d7c11ULL, 0x000fe400080f4430ULL, 0x0000001313177c11ULL, 0x000fe400090f441aULL,
0x000000076c137812ULL, 0x000fc400078ec0ffULL, 0x0000001315157c11ULL, 0x000fe400088f4426ULL,
0x000000310000720cULL, 0x080fe40003f06070ULL, 0x000000070b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000310200720cULL, 0x000fe40003f26070ULL, 0x0000000813277812ULL, 0x000fe400078efcffULL,
0x0ffffff80b577812ULL, 0x000fc400078ef86cULL, 0x000000310300720cULL, 0x080fe20003f46070ULL,
0x00000010272a7825ULL, 0x000fe200078e002aULL, 0x000000310400720cULL, 0x080fe40003f66070ULL,
0x00000011570b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010272e7825ULL, 0x000fe200078e002eULL,
0x0000001156337c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a58127c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a0b7faeULL, 0x000fe2000c101c58ULL,
0x000000310500720cULL, 0x080fe20003f06070ULL, 0x00000010272c7825ULL, 0x000fe200078e002cULL,
0x0000001155357c11ULL, 0x000fe2000f8e20ffULL, 0x000000002e337faeULL, 0x000fe2000c901c58ULL,
0x000000310600720cULL, 0x080fe20003f26070ULL, 0x0000001027287825ULL, 0x000fe200078e0028ULL,
0x0000001154377c11ULL, 0x000fe2000f8e20ffULL, 0x000000002c357faeULL, 0x0003e2000d101c58ULL,
0x000000310700720cULL, 0x080fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x00000012121a7c11ULL, 0x000fe2000f8840ffULL, 0x0000000028377faeULL, 0x0005e2000d901c58ULL,
0x000000310800720cULL, 0x000fe20003f66070ULL, 0x0000001027247825ULL, 0x000fe200078e0024ULL,
0x00000013121b7c11ULL, 0x000fc4000a0f441bULL, 0x0000001153397c11ULL, 0x000fe2000f8e20ffULL,
0x0000001027227825ULL, 0x040fe200078e0022ULL, 0x000000310a00720cULL, 0x000fe40003f86070ULL,
0x00000011523b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010272c7825ULL, 0x002fe200078e000cULL,
0x0000000024397faeULL, 0x000fe2000c101c58ULL, 0x00000011513d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000002400127836ULL, 0x040fe20000000000ULL, 0x00000000223b7faeULL, 0x0003e2000c901c58ULL,
0x00000028000b7836ULL, 0x000fe20000000000ULL, 0x00000011502f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002c000c7836ULL, 0x000fe20000000000ULL, 0x0000006c124e7212ULL, 0x080fe200078e3cffULL,
0x0000001027287825ULL, 0x004fe200078e0010ULL, 0x0000006c0b4d7212ULL, 0x000fc400078e3cffULL,
0x000000114f337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0x0000006c0c4c7212ULL, 0x080fe200078e3cffULL, 0x00000010272a7825ULL, 0x000fe200078e000eULL,
0x000000311200720cULL, 0x080fe20003f06070ULL, 0x00000000283d7faeULL, 0x0005e2000d101c58ULL,
0x000000310b00720cULL, 0x0c0fe20003f26070ULL, 0x000000080b227824ULL, 0x002fe200078e00ffULL,
0xfffffff8114e7812ULL, 0x000fe200078ee24eULL, 0x000000080c237824ULL, 0x000fe200078e00ffULL,
0x000000002a2f7faeULL, 0x0003e2000d901c58ULL, 0x00000030000d7836ULL, 0x040fe20000000000ULL,
0xfffffff8224d7812ULL, 0x000fe200078ee24dULL, 0x00000034000e7836ULL, 0x000fe20000000000ULL,
0x000000310c00720cULL, 0x080fe20003f46070ULL, 0x0000003c00107836ULL, 0x040fe20000000000ULL,
0xfffffff8234c7812ULL, 0x000fe200078ee24cULL, 0x00000038000f7836ULL, 0x000fe20000000000ULL,
0x000000002c337faeULL, 0x0009e2000e101c58ULL, 0x000000080d227824ULL, 0x040fe200078e00ffULL,
0x000000310d00720cULL, 0x0c0fe20003f66070ULL, 0x000000080e117824ULL, 0x000fe200078e00ffULL,
0x0000006c0d4b7212ULL, 0x080fe200078e3cffULL, 0x0000000810237824ULL, 0x000fe200078e00ffULL,
0x0000006c0e4a7212ULL, 0x0c0fe200078e3cffULL, 0x000000080f247824ULL, 0x000fe200078e00ffULL,
0x000000310e00720cULL, 0x000fe20003f86070ULL, 0x0000001027207825ULL, 0x000fe200078e0020ULL,
0x0000006c10487212ULL, 0x000fc400078e3cffULL, 0x000000310f00720cULL, 0x080fe20003fa6070ULL,
0x00000010271e7825ULL, 0x000fe200078e001eULL, 0x0000006c0f497212ULL, 0x000fe400078e3cffULL,
0x000000311000720cULL, 0x000fe20003fc6070ULL, 0x00000010271c7825ULL, 0x040fe200078e001cULL,
0xfffffff8224b7812ULL, 0x000fe400078ee24bULL, 0xfffffff8114a7812ULL, 0x000fe200078ee24aULL,
0x0000001027147825ULL, 0x000fe200078e0014ULL, 0xfffffff823487812ULL, 0x000fc400078ee248ULL,
0x000000114e117c11ULL, 0x000fe2000f8e20ffULL, 0x0000001027167825ULL, 0x000fe200078e0016ULL,
0xfffffff824497812ULL, 0x000fe400078ee249ULL, 0x000000114d237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001027187825ULL, 0x040fe200078e0018ULL, 0x000000114c257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000020117faeULL, 0x0007e2000c101c58ULL, 0x000000114a297c11ULL, 0x004fe2000f8e20ffULL,
0x00000010271a7825ULL, 0x000fe200078e001aULL, 0x000000114b277c11ULL, 0x000fe2000f8e20ffULL,
0x000000001e237faeULL, 0x0007e2000c901c58ULL, 0x00000011492b7c11ULL, 0x002fc4000f8e20ffULL,
0x00000011482d7c11ULL, 0x010fe2000f8e20ffULL, 0x000000001c257faeULL, 0x0007e8000d101c58ULL,
0x0000000014277faeULL, 0x0007e8000d901c58ULL, 0x0000000016297faeULL, 0x0007e8000e101c58ULL,
0x00000000182b7faeULL, 0x0007e8000e901c58ULL, 0x000000001a2d7faeULL, 0x0007e2000f101c58ULL,
0x0000000c00247947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe2000001166cULL,
0x00000009ff117e24ULL, 0x002fe2000f8e00ffULL, 0x00008a0000127ab9ULL, 0x000fe20000000a00ULL,
0x000000071b047291ULL, 0x000fe4000f8e703fULL, 0x0000000c00047836ULL, 0x040fe40000000000ULL,
0x0000000800037836ULL, 0x000fe20000000000ULL, 0x0000300004117890ULL, 0x000fe2000fffe03fULL,
0x0000000804077824ULL, 0x040fe200078e00ffULL, 0x0000006c04547212ULL, 0x080fe200078e3cffULL,
0x0000000400027836ULL, 0x040fe20000000000ULL, 0x0000006c03557212ULL, 0x0c0fe200078e3cffULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0xfffffff807547812ULL, 0x000fe200078ee254ULL,
0x0000001800077836ULL, 0x000fe20000000000ULL, 0x0000006c02567212ULL, 0x0c0fe200078e3cffULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0xfffffff806557812ULL, 0x000fe200078ee255ULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000006c07517212ULL, 0x080fe200078e3cffULL,
0x0000001400067836ULL, 0x040fe20000000000ULL, 0xfffffff805567812ULL, 0x000fe200078ee256ULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0xfffffff80a517812ULL, 0x000fe200078ee251ULL,
0x00000020000a7836ULL, 0x000fe20000000000ULL, 0x0000006c06527212ULL, 0x0c0fe200078e3cffULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0x0000006c05537212ULL, 0x0c0fe200078e3cffULL,
0x0000002400127836ULL, 0x000fe20000000000ULL, 0x0000006c0a4f7212ULL, 0x0c0fe200078e3cffULL,
0x000000080a0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff809527812ULL, 0x000fe200078ee252ULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0x0000006c124e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000812097824ULL, 0x000fe200078e00ffULL, 0xfffffff80c4f7812ULL, 0x000fe200078ee24fULL,
0x0000002c000c7836ULL, 0x040fe20000000000ULL, 0xfffffff808537812ULL, 0x000fe200078ee253ULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0xfffffff8094e7812ULL, 0x000fe200078ee24eULL,
0x000000080c097824ULL, 0x040fe200078e00ffULL, 0x0000006c0c4c7212ULL, 0x080fe200078e3cffULL,
0x00000008080b7824ULL, 0x040fe200078e00ffULL, 0x0000006c08507212ULL, 0x080fe200078e3cffULL,
0x00000030000d7836ULL, 0x040fe20000000000ULL, 0xfffffff8094c7812ULL, 0x000fe200078ee24cULL,
0x0000004011097824ULL, 0x000fe200078e0200ULL, 0xfffffff80b507812ULL, 0x000fe200078ee250ULL,
0x00000028000b7836ULL, 0x040fe20000000000ULL, 0x0000006c0d4b7212ULL, 0x0c0fe200078e3cffULL,
0x000000080d107824ULL, 0x000fe200078e00ffULL, 0x0000000a09117c10ULL, 0x000fe2000ff1e0ffULL,
0x000000080b0e7824ULL, 0x040fe200078e00ffULL, 0x0000006c0b4d7212ULL, 0x080fe200078e3cffULL,
0x00000004096b7836ULL, 0x000fe20000000000ULL, 0xfffffff8104b7812ULL, 0x000fe200078ee24bULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0xfffffff80e4d7812ULL, 0x000fe200078ee24dULL,
0x00000034000e7836ULL, 0x040fe20000000000ULL, 0x0000001211327c11ULL, 0x000fe2000f8040ffULL,
0x0000003c00107836ULL, 0x000fe20000000000ULL, 0x00000011513b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x0000001311337c11ULL, 0x000fe200080f4414ULL,
0x0000000810137824ULL, 0x000fe200078e00ffULL, 0x0000000a6b117c10ULL, 0x000fe2000ff1e0ffULL,
0x00000008096a7836ULL, 0x040fe20000000000ULL, 0x0000006c0e4a7212ULL, 0x080fe200078e3cffULL,
0x0000000c09697836ULL, 0x000fe20000000000ULL, 0x0000006c10487212ULL, 0x080fe200078e3cffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0xfffffff80f4a7812ULL, 0x000fe200078ee24aULL,
0x00000038000f7836ULL, 0x000fe20000000000ULL, 0x0000001211307c11ULL, 0x000fe2000f8040ffULL,
0x0000001009677836ULL, 0x000fe20000000000ULL, 0xfffffff813487812ULL, 0x000fe200078ee248ULL,
0x000000080f167824ULL, 0x000fe200078e00ffULL, 0x0000001311317c11ULL, 0x000fe200080f4414ULL,
0x0000001409637836ULL, 0x000fe20000000000ULL, 0x0000006c0f497212ULL, 0x000fe200078e3cffULL,
0x0000001809627836ULL, 0x040fe20000000000ULL, 0x0000000a6a137c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001c09617836ULL, 0x040fe20000000000ULL, 0x0000000a69157c10ULL, 0x000fe2000ff5e0ffULL,
0x00000024095f7836ULL, 0x040fe20000000000ULL, 0x0000000a67117c10ULL, 0x000fe2000ff1e0ffULL,
0x0000002009607836ULL, 0x000fe20000000000ULL, 0xfffffff816497812ULL, 0x000fe200078ee249ULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000001213287c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00000012151c7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00000012112c7c11ULL, 0x000fe2000f8040ffULL,
0x00000028095e7836ULL, 0x000fe20000000000ULL, 0x0000001313297c11ULL, 0x000fe200088f4416ULL,
0x0000002c095c7836ULL, 0x000fe20000000000ULL, 0x00000013151d7c11ULL, 0x000fe200090f4418ULL,
0x00000030095b7836ULL, 0x000fe20000000000ULL, 0x00000013112d7c11ULL, 0x000fe200080f4414ULL,
0x00000034095a7836ULL, 0x040fe20000000000ULL, 0x0000000a63137c10ULL, 0x000fe2000ff3e0ffULL,
0x0000003809597836ULL, 0x040fe20000000000ULL, 0x0000000a62117c10ULL, 0x000fe2000ff5e0ffULL,
0x0000003c09587836ULL, 0x000fe20000000000ULL, 0x0000000a61157c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00000012132e7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00000012112a7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x00000013132f7c11ULL, 0x000fc400080f4414ULL,
0x00000013112b7c11ULL, 0x000fe400088f4416ULL, 0x0000000a5f137c10ULL, 0x000fe4000ff3e0ffULL,
0x00000012151e7c11ULL, 0x040fe4000f8440ffULL, 0x0000000a60117c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x00000013151f7c11ULL, 0x000fe400090f4418ULL,
0x0000000a5e157c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x0000001213227c11ULL, 0x000fc4000f8240ffULL, 0x0000000a5c177c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0000001211267c11ULL, 0x000fe4000f8040ffULL,
0x0000001313237c11ULL, 0x000fe200088f4416ULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001311277c11ULL, 0x000fe400080f4414ULL, 0x0000001215247c11ULL, 0x000fe4000f8440ffULL,
0x0000001217207c11ULL, 0x000fc4000f8040ffULL, 0x0000006c00147212ULL, 0x000fe400078e3cffULL,
0x0000001315257c11ULL, 0x000fe400090f4418ULL, 0x0000001317217c11ULL, 0x000fe400080f4416ULL,
0x0000000a5b157c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000a5a177c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000a59377c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x0000000a58397c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff367224ULL, 0x000fe200008e06ffULL,
0x0000000714147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x000000076c137812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x0ffffff814577812ULL, 0x000fc400078ef86cULL, 0x00000012151a7c11ULL, 0x000fe4000f8040ffULL,
0x0000001217187c11ULL, 0x000fe4000f8240ffULL, 0x0000000813117812ULL, 0x000fe400078efcffULL,
0x0000001237167c11ULL, 0x000fe4000f8440ffULL, 0x0000001239147c11ULL, 0x000fe2000f8640ffULL,
0x0000001011327825ULL, 0x000fe200078e0032ULL, 0x00000013151b7c11ULL, 0x000fc400080f4434ULL,
0x0000001317197c11ULL, 0x000fe200088f4436ULL, 0x0000001011307825ULL, 0x000fe200078e0030ULL,
0x0000001337177c11ULL, 0x000fe400090f4438ULL, 0x0000001339157c11ULL, 0x000fe200098f443aULL,
0x0000001011287825ULL, 0x000fe200078e0028ULL, 0x0000001157357c11ULL, 0x000fe4000f8e20ffULL,
0x0000001153377c11ULL, 0x000fe2000f8e20ffULL, 0x00000010111c7825ULL, 0x040fe200078e001cULL,
0x0000001152397c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032357faeULL, 0x0003e2000b901c58ULL, 0x00000011503d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010112c7825ULL, 0x000fe200078e002cULL, 0x000000114f3f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000114e417c11ULL, 0x000fe2000f8e20ffULL, 0x00000010112e7825ULL, 0x000fe200078e002eULL,
0x000000114d437c11ULL, 0x000fc6000f8e20ffULL, 0x00000010112a7825ULL, 0x000fe200078e002aULL,
0x0000001155337c11ULL, 0x002fc6000f8e20ffULL, 0x00000010111e7825ULL, 0x000fe200078e001eULL,
0x0000001154357c11ULL, 0x000fc6000f8e20ffULL, 0x0000001011267825ULL, 0x000fc800078e0026ULL,
0x0000001011227825ULL, 0x000fc800078e0022ULL, 0x0000001011247825ULL, 0x000fc800078e0024ULL,
0x0000001011207825ULL, 0x000fc800078e0020ULL, 0x00000010111a7825ULL, 0x000fc800078e001aULL,
0x0000001011187825ULL, 0x000fc800078e0018ULL, 0x0000001011167825ULL, 0x000fc800078e0016ULL,
0x0000001011147825ULL, 0x000fe200078e0014ULL, 0x0000001156117c11ULL, 0x000fca000f8e20ffULL,
0x0000000030117faeULL, 0x0003e8000b901c58ULL, 0x0000000028337faeULL, 0x0005e8000b901c58ULL,
0x000000001c357faeULL, 0x0007e8000b901c58ULL, 0x000000002c377faeULL, 0x0009e2000b901c58ULL,
0x000000114c117c11ULL, 0x002fc6000f8e20ffULL, 0x000000002e397faeULL, 0x0003e2000b901c58ULL,
0x000000114a297c11ULL, 0x004fc6000f8e20ffULL, 0x000000002a3b7faeULL, 0x0005e2000b901c58ULL,
0x000000114b1d7c11ULL, 0x008fc6000f8e20ffULL, 0x000000001e3d7faeULL, 0x0005e2000b901c58ULL,
0x00000011492d7c11ULL, 0x010fc6000f8e20ffULL, 0x00000000263f7faeULL, 0x0005e2000b901c58ULL,
0x00000011482f7c11ULL, 0x002fc6000f8e20ffULL, 0x0000000022417faeULL, 0x0005e8000b901c58ULL,
0x0000000024437faeULL, 0x0005e8000b901c58ULL, 0x0000000020117faeULL, 0x0005e8000b901c58ULL,
0x000000001a1d7faeULL, 0x0005e8000b901c58ULL, 0x0000000018297faeULL, 0x0005e8000b901c58ULL,
0x00000000162d7faeULL, 0x0005e8000b901c58ULL, 0x00000000142f7faeULL, 0x0005e4000b901c58ULL,
0x000000061e067291ULL, 0x000fe2000f8e103fULL, 0x00000004ff167819ULL, 0x00cfe2000001166cULL,
0x00001000040e7890ULL, 0x000fe2000fffe03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000080600728cULL, 0x000fe2000bf06070ULL, 0x0000000813117812ULL, 0x000fe200078ef86cULL,
0x00000008161a7824ULL, 0x000fe200078e00ffULL, 0x0000000100777812ULL, 0x000fe400078ec0ffULL,
0x0000000716147812ULL, 0x000fe200078e7811ULL, 0x0000000216167836ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000001011147824ULL, 0x040fe200078e0214ULL, 0x000000060d048291ULL, 0x000fe2000f8e083fULL,
0x0000000716167812ULL, 0x000fe200078e7811ULL, 0x00008c00000a8ab9ULL, 0x000fe20000000a00ULL,
0x000000071a727812ULL, 0x040fe200078ec0ffULL, 0x00000004040a88a5ULL, 0x000fe2000f8e000aULL,
0x000000081a687824ULL, 0x000fe200078e00ffULL, 0x0000000714147c11ULL, 0x000fe2000f8e20ffULL,
0x0000001011167824ULL, 0x000fe200078e0216ULL, 0x0000000172157812ULL, 0x000fe200078e7800ULL,
0x000000201a6f7836ULL, 0x000fc40000000000ULL, 0x0000000aff187e24ULL, 0x000fe2000f8e00ffULL,
0x00000068157c7212ULL, 0x000fe200078efcffULL, 0x0000000bff197e24ULL, 0x000fe2000f8e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000018187d8981ULL, 0x0002a2000c1e1900ULL,
0x0000000e7c1c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000101a667836ULL, 0x000fe20000000000ULL,
0x0000000272157812ULL, 0x000fe200078e1e77ULL, 0x000000001440783bULL, 0x0007e20000000200ULL,
0x00000007162c7c11ULL, 0x000fe4000f8e20ffULL, 0x00000068157a7212ULL, 0x000fe200078efcffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x000000076f717812ULL, 0x040fe200078ec0ffULL,
0x000000301a707836ULL, 0x000fe20000000000ULL, 0x0000000766657812ULL, 0x000fe200078ec0ffULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x0000000e7a147c11ULL, 0x008fe2000f8e20ffULL,
0x000000086f6f7824ULL, 0x000fe200078e00ffULL, 0x0000000171247812ULL, 0x000fe200078e7800ULL,
0x0000000866667824ULL, 0x000fe200078e00ffULL, 0x0000000770647812ULL, 0x000fc400078ec0ffULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000006f24797212ULL, 0x000fe200078efcffULL,
0x0000000870707824ULL, 0x000fe200078e00ffULL, 0x00000001657b7812ULL, 0x000fe400078e7800ULL,
0x0000000164297812ULL, 0x000fe400078e7800ULL, 0x0000000e79247c11ULL, 0x000fe4000f8e20ffULL,
0x000000667b7b7212ULL, 0x000fe400078efcffULL, 0x0000007029787212ULL, 0x000fc400078efcffULL,
0x0000000e7b207c11ULL, 0x000fe2000f8e20ffULL, 0x000000002424783bULL, 0x000f220000000200ULL,
0x0000000e78447c11ULL, 0x000fc8000f8e20ffULL, 0x000000002020783bULL, 0x000f620000000200ULL,
0x0000000271287812ULL, 0x000fc600078e1e77ULL, 0x000000004444783bULL, 0x000f220000000200ULL,
0x0000001c4018723cULL, 0x002fec00000018ffULL, 0x0000001e401c723cULL, 0x000fe200000018ffULL,
0x0000006f28757212ULL, 0x000fe400078efcffULL, 0x0000000265297812ULL, 0x000fc400078e1e77ULL,
0x0000000e75347c11ULL, 0x000fe4000f8e20ffULL, 0x0000006629767212ULL, 0x000fc800078efcffULL,
0x000000003434783bULL, 0x000e6e0000000200ULL, 0x000000142c18723cULL, 0x008fec0000001818ULL,
0x000000162c14723cULL, 0x000fee000000181cULL, 0x00000002641d7812ULL, 0x000fc800078e1e77ULL,
0x000000701d747212ULL, 0x000fe400078efcffULL, 0x0000000e76387c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e74307c11ULL, 0x000fc8000f8e20ffULL, 0x000000003838783bULL, 0x000ee80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x00000024401c723cULL, 0x010fec00000018ffULL,
0x00000020403c723cULL, 0x020fec00000018ffULL, 0x000000224020723cULL, 0x000fec00000018ffULL,
0x000000264024723cULL, 0x000fec00000018ffULL, 0x000000444028723cULL, 0x000fec00000018ffULL,
0x000000464040723cULL, 0x000fe200000018ffULL, 0x00000004ff457819ULL, 0x000fca000001166cULL,
0x000000342c1c723cULL, 0x002fee000000181cULL, 0x0000000445347836ULL, 0x000fe20000000000ULL,
0x000000382c3c723cULL, 0x008fe2000000183cULL, 0x0000000472737812ULL, 0x000fc600078e1e77ULL,
0x0000000734347812ULL, 0x000fe400078e7811ULL, 0x0000003a2c20723cULL, 0x000fe20000001820ULL,
0x0000006873737212ULL, 0x000fe400078efcffULL, 0x0000001011347824ULL, 0x000fc600078e0234ULL,
0x000000362c24723cULL, 0x000fec0000001824ULL, 0x000000302c28723cULL, 0x000fec0000001828ULL,
0x000000322c40723cULL, 0x000fee0000001840ULL, 0x00000004652d7812ULL, 0x000fc800078e1e77ULL,
0x000000662d6e7212ULL, 0x000fe400078efcffULL, 0x0000000734307c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e73347c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e6e2c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x000000363014723cULL, 0x002fec0000001814ULL,
0x0000002c303c723cULL, 0x008fe2000000183cULL, 0x0000000471367812ULL, 0x000fcc00078e1e77ULL,
0x00000004642d7812ULL, 0x000fe400078e1e77ULL, 0x0000006f366d7212ULL, 0x000fe400078efcffULL,
0x000000702d6c7212ULL, 0x000fe200078efcffULL, 0x000000343018723cULL, 0x000fe60000001818ULL,
0x0000000e6c387c11ULL, 0x000fc8000f8e20ffULL, 0x0000000e6d357c11ULL, 0x000fe4000f8e20ffULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000003534783bULL, 0x000ee20000000200ULL,
0x00000006452c7836ULL, 0x000fe20000000000ULL, 0x0000002e3020723cULL, 0x000fe20000001820ULL,
0x00000006722d7812ULL, 0x000fe400078e1e77ULL, 0x0000000665657812ULL, 0x000fc400078e1e77ULL,
0x000000072c2c7812ULL, 0x000fe400078e7811ULL, 0x0000006665667212ULL, 0x000fe400078efcffULL,
0x000000682d687212ULL, 0x000fe200078efcffULL, 0x00000010112c7824ULL, 0x000fca00078e022cULL,
0x000000072c2c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000005d0b72caULL, 0x000fc800000e0000ULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x000000383028723cULL, 0x002fec0000001828ULL,
0x00000034301c723cULL, 0x008fec000000181cULL, 0x000000363024723cULL, 0x000fec0000001824ULL,
0x0000003a3040723cULL, 0x000fee0000001840ULL, 0x0000000671327812ULL, 0x000fc400078e1e77ULL,
0x0000000664777812ULL, 0x000fe400078e1e77ULL, 0x0000006f32657212ULL, 0x000fe400078efcffULL,
0x0000007077647212ULL, 0x000fe400078efcffULL, 0x0000000e68347c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e66307c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e65387c11ULL, 0x000fc4000f8e20ffULL,
0x0000000e64447c11ULL, 0x000fe2000f8e20ffULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000003838783bULL, 0x000f280000000200ULL,
0x000000004444783bULL, 0x000f620000000200ULL, 0x0000000b1e0b7290ULL, 0x000fc8000fffe03fULL,
0x000000010b0a7890ULL, 0x000fe2000fffe03fULL, 0x0000000000727919ULL, 0x000ee60000000000ULL,
0x000000050a00728cULL, 0x000fe2000bf26070ULL, 0x000000007d0482caULL, 0x004fca00000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f018ULL, 0xffffffff000f7882ULL, 0x000fce0000000000ULL,
0x00000004000f8c82ULL, 0x000fe40008000000ULL, 0x0000000c0f1472a4ULL, 0x000fe2000f8e023fULL,
0x000000342c18723cULL, 0x002fec0000001818ULL, 0x000000362c14723cULL, 0x000fec0000001814ULL,
0x000000302c3c723cULL, 0x008fec000000183cULL, 0x000000322c20723cULL, 0x000fec0000001820ULL,
0x000000382c1c723cULL, 0x010fec000000181cULL, 0x0000003a2c24723cULL, 0x000fec0000001824ULL,
0x000000442c28723cULL, 0x020fec0000001828ULL, 0x000000462c40723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000800688947ULL, 0x000fde0003800000ULL,
0x00000014096f7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000100b047291ULL, 0x000fe2000f8e403fULL,
0x000000146b097c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000e57577c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x000000126f707c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00000012096b7c11ULL, 0x000fe2000f8240ffULL,
0x000000042200728cULL, 0x000fe2000bf01070ULL, 0x000000136f6f7c11ULL, 0x000fc400080f442cULL,
0x000000146a2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000004220a7287ULL, 0x000fe2000c000000ULL,
0x00000013096a7c11ULL, 0x000fe400088f442eULL, 0x00000014692d7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x00000014672e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000a040a7290ULL, 0x000fe2000fffe13fULL, 0x000000122c697c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x000000122d677c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x000000132c2c7c11ULL, 0x000fc400080f4431ULL,
0x0000001463317c10ULL, 0x000fe4000ff1e0ffULL, 0x000000122e097c11ULL, 0x040fe4000f8440ffULL,
0x000000132d2d7c11ULL, 0x000fe200088f4430ULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x000000132e2e7c11ULL, 0x000fe400090f442fULL, 0x0000001462327c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001461337c10ULL, 0x000fc4000ff5e0ffULL, 0x0000001231377c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff357224ULL, 0x000fe200008e06ffULL, 0x0000001232307c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x0000001331317c11ULL, 0x000fe400080f4436ULL,
0x0000001460367c10ULL, 0x000fe4000ff1e0ffULL, 0x00000012332f7c11ULL, 0x040fe4000f8440ffULL,
0x0000001332327c11ULL, 0x000fe200088f4435ULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x0000001333337c11ULL, 0x000fc400090f4434ULL, 0x000000145f387c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001236347c11ULL, 0x000fe4000f8040ffULL, 0x0000000a02007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0000001336367c11ULL, 0x000fe400080f443bULL,
0x0000001238357c11ULL, 0x000fe4000f8240ffULL, 0x000000145e3b7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000001338387c11ULL, 0x000fe400088f4439ULL, 0x000000145c447c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x000000123b397c11ULL, 0x040fe4000f8040ffULL,
0x0000000a00007c0cULL, 0x000fe2000bf46070ULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0x000000133b3b7c11ULL, 0x000fe400080f4446ULL, 0x00000012443a7c11ULL, 0x000fc4000f8240ffULL,
0x000000145b477c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001344447c11ULL, 0x000fe400088f4445ULL,
0x000000145a457c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200000e06ffULL,
0x00000012475a7c11ULL, 0x040fe4000f8040ffULL, 0x00000014585e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x0000001347477c11ULL, 0x000fe200080f445cULL,
0x00000010725c7824ULL, 0x000fe200078e00ffULL, 0x0000001245467c11ULL, 0x000fc4000f8240ffULL,
0x0000001459597c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001345457c11ULL, 0x000fe400088f4402ULL,
0x000000705c5c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00000012595b7c11ULL, 0x000fe4000f8040ffULL, 0x0000000a03007c0cULL, 0x000fe4000bf86070ULL,
0x0000001359597c11ULL, 0x000fc400080f4402ULL, 0x000000705c027210ULL, 0x000fe40007f3e0ffULL,
0x0000000a05007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff057224ULL, 0x000fe200030e06ffULL,
0x0000000a04007c0cULL, 0x000fe2000bfa6070ULL, 0x000000ffff037224ULL, 0x000fe200008e066fULL,
0x000000125e587c11ULL, 0x040fe4000f8c40ffULL, 0x0000006b5c047210ULL, 0x000fe40007f3e0ffULL,
0x000000135e5e7c11ULL, 0x000fe2000b0f4405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002577faeULL, 0x0003e2000d101c58ULL, 0x0000000e565f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200008e066aULL, 0x0000000e55557c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a06007c0cULL, 0x000fe4000bf26070ULL, 0x00000000045f7faeULL, 0x0005e2000d901c58ULL,
0x0000000e53537c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e51517c11ULL, 0x000fe4000f8e20ffULL,
0x000000695c027210ULL, 0x002fe40007f5e0ffULL, 0x0000000e4f4f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e4d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200010e062cULL,
0x0000000a07007c0cULL, 0x000fc4000bf46070ULL, 0x000000675c047210ULL, 0x004fe40007f7e0ffULL,
0x0000000e54077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002557faeULL, 0x0003e2000e101c58ULL,
0x0000000e4b4b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe200018e062dULL,
0x0000000a08007c0cULL, 0x000fe4000bf66070ULL, 0x0000000e49497c11ULL, 0x000fe4000f8e20ffULL,
0x0000000004077faeULL, 0x0005e2000e901c58ULL, 0x0000000a0a007c0cULL, 0x000fc4000bfa6070ULL,
0x000000095c027210ULL, 0x002fe40007f9e0ffULL, 0x0000000e52097c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200020e062eULL, 0x0000000a12007c0cULL, 0x000fe4000bf86070ULL,
0x000000375c047210ULL, 0x004fe40007fde0ffULL, 0x0000000002537faeULL, 0x0003e2000c101c58ULL,
0x000000305c307210ULL, 0x000fe40007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200030e0631ULL,
0x0000000e50077c11ULL, 0x000fe4000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200000e0632ULL,
0x0000000a0b007c0cULL, 0x000fe2000bf06070ULL, 0x0000000004097faeULL, 0x0005e2000c901c58ULL,
0x0000000e4c0b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000002f5c027210ULL, 0x002fe20007f3e0ffULL,
0x0000000030517faeULL, 0x000fe2000d101c58ULL, 0x000000345c347210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e0633ULL, 0x0000000a0c007c0cULL, 0x000fe4000bf26070ULL,
0x0000000e4e097c11ULL, 0x004fe4000f8e20ffULL, 0x0000000002077faeULL, 0x0005e4000d901c58ULL,
0x000000355c027210ULL, 0x004fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200010e0636ULL,
0x0000000a0d007c0cULL, 0x000fe4000bf46070ULL, 0x0000000e480d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200018e0638ULL, 0x00000000344f7faeULL, 0x000fe2000e901c58ULL,
0x000000395c047210ULL, 0x000fc40007fbe0ffULL, 0x0000000a0e007c0cULL, 0x000fe2000bf66070ULL,
0x0000000002097faeULL, 0x0005e2000e101c58ULL, 0x0000003a5c3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200028e063bULL, 0x0000005a5c067210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e0644ULL, 0x0000000a0f007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff077224ULL, 0x000fe200028e0647ULL, 0x0000000a10007c0cULL, 0x000fe2000bfa6070ULL,
0x00000000044d7faeULL, 0x0003e2000c101c58ULL, 0x000000465c467210ULL, 0x000fe40007f1e0ffULL,
0x0000000e4a097c11ULL, 0x004fe2000f8e20ffULL, 0x000000003a0b7faeULL, 0x0003e2000c901c58ULL,
0x0000005b5c027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff477224ULL, 0x000fc400000e0645ULL,
0x00000000064b7faeULL, 0x0003e2000d101c58ULL, 0x000000585c587210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe400008e0659ULL, 0x0000000046097faeULL, 0x0003e4000d901c58ULL,
0x000000ffff597224ULL, 0x000fe400010e065eULL, 0x0000000002497faeULL, 0x0003e8000e101c58ULL,
0x00000000580d7faeULL, 0x0003e2000e901c58ULL, 0x0000000800147947ULL, 0x000fea0003800000ULL,
0x0000001409037c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001072337824ULL, 0x000fe200078e00ffULL,
0x000000146b057c10ULL, 0x000fe4000ff3e0ffULL, 0x000000146a077c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000001203027c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000001469097c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000001303037c11ULL, 0x000fc400080f4404ULL,
0x00000014670b7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x0000001205047c11ULL, 0x000fe4000f8040ffULL, 0x0000001207067c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x0000001209087c11ULL, 0x000fe4000f8440ffULL,
0x0000001305057c11ULL, 0x000fe400080f440cULL, 0x0000001307077c11ULL, 0x000fc400088f440eULL,
0x0000001309097c11ULL, 0x000fe400090f4410ULL, 0x00000014630d7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000120b0a7c11ULL, 0x040fe4000f8640ffULL, 0x00000014620f7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00000014612d7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000130b0b7c11ULL, 0x000fe200098f4412ULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000001460607c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x000000120d0c7c11ULL, 0x000fc4000f8040ffULL, 0x000000120f0e7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff2f7224ULL, 0x000fe200018e06ffULL, 0x000000122d2c7c11ULL, 0x000fe4000f8440ffULL,
0x000000130d0d7c11ULL, 0x000fe400080f4410ULL, 0x000000130f0f7c11ULL, 0x000fe400088f4412ULL,
0x000000132d2d7c11ULL, 0x000fe400090f4430ULL, 0x000000145f317c10ULL, 0x000fc4000ff1e0ffULL,
0x00000012602e7c11ULL, 0x040fe4000f8640ffULL, 0x000000145e5e7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x000000145c357c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001360107c11ULL, 0x000fe200098f442fULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x0000001231307c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x000000145b377c10ULL, 0x000fc4000ff7e0ffULL, 0x000000125e327c11ULL, 0x040fe4000f8240ffULL,
0x0000001235347c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x0000001331317c11ULL, 0x000fe400080f4412ULL, 0x000000135e127c11ULL, 0x000fe400088f442fULL,
0x0000001335357c11ULL, 0x000fe400090f4438ULL, 0x000000145a397c10ULL, 0x000fc4000ff1e0ffULL,
0x00000014593b7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001458457c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x0000001237367c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff587224ULL, 0x000fe200008e06ffULL, 0x0000001239387c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff5a7224ULL, 0x000fe200010e06ffULL, 0x0000001337377c11ULL, 0x000fe400098f443aULL,
0x000000123b3a7c11ULL, 0x000fc4000f8240ffULL, 0x0000001245447c11ULL, 0x000fe4000f8440ffULL,
0x0000007033337812ULL, 0x000fe400078ec0ffULL, 0x0000001339397c11ULL, 0x000fe400080f4446ULL,
0x000000133b3b7c11ULL, 0x000fe400088f4458ULL, 0x0000001345457c11ULL, 0x000fe400090f445aULL,
0x0000000233027210ULL, 0x000fc40007f5e0ffULL, 0x0000000633067210ULL, 0x000fe40007f3e0ffULL,
0x0000000833087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x0000000a330a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c330c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000000e330e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x0000002c332c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000002e332e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e060fULL,
0x0000003033307210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e062dULL,
0x0000000433047210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0610ULL,
0x0000000e57577c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0x0000003233327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000003433347210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002577faeULL, 0x0003e2000b901c58ULL, 0x0000003633367210ULL, 0x000fc40007f7e0ffULL,
0x0000003833387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff357224ULL, 0x000fe200020e0635ULL,
0x0000003a333a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff377224ULL, 0x000fe200018e0637ULL,
0x0000004433447210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e0639ULL,
0x0000000e56337c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e063bULL,
0x0000000e55557c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff457224ULL, 0x000fe200000e0645ULL,
0x0000000e54477c11ULL, 0x000fe2000f8e20ffULL, 0x0000000004337faeULL, 0x0005e2000b901c58ULL,
0x0000000e53537c11ULL, 0x000fc4000f8e20ffULL, 0x0000000e52597c11ULL, 0x000fe2000f8e20ffULL,
0x0000000006557faeULL, 0x0007e2000b901c58ULL, 0x0000000e51517c11ULL, 0x000fe4000f8e20ffULL,
0x0000000e50037c11ULL, 0x002fe2000f8e20ffULL, 0x0000000008477faeULL, 0x000fe2000b901c58ULL,
0x0000000e4f4f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e4d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a537faeULL, 0x000fe2000b901c58ULL, 0x0000000e4e057c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff337224ULL, 0x000fe200028e0612ULL, 0x0000000e4b4b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c597faeULL, 0x000fe2000b901c58ULL, 0x0000000e4c077c11ULL, 0x008fc4000f8e20ffULL,
0x0000000e49497c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e517faeULL, 0x000fe8000b901c58ULL,
0x000000002c037faeULL, 0x0005e8000b901c58ULL, 0x000000002e4f7faeULL, 0x000fe8000b901c58ULL,
0x0000000030057faeULL, 0x0007e2000b901c58ULL, 0x0000000e4a037c11ULL, 0x004fc6000f8e20ffULL,
0x00000000324d7faeULL, 0x0003e8000b901c58ULL, 0x0000000034077faeULL, 0x0003e2000b901c58ULL,
0x0000000e48057c11ULL, 0x008fc6000f8e20ffULL, 0x00000000364b7faeULL, 0x0003e8000b901c58ULL,
0x0000000038037faeULL, 0x0003e8000b901c58ULL, 0x000000003a497faeULL, 0x0003e8000b901c58ULL,
0x0000000044057faeULL, 0x0003e4000b901c58ULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x000000117c087c11ULL, 0x000fe2000f8e20ffULL, 0x000000071b047291ULL, 0x000fe2000f8e183fULL,
0x000000117b0c7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000011792c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000071b0a7291ULL, 0x000fe2000f8e383fULL,
0x0000001178307c11ULL, 0x000fe4000f8e20ffULL, 0x000000117a347c11ULL, 0x000fe4000f8e20ffULL,
0x0000001174747c11ULL, 0x000fc4000f8e20ffULL, 0x0000001168687c11ULL, 0x000fe4000f8e20ffULL,
0x0000001166667c11ULL, 0x000fe4000f8e20ffULL, 0x0000001164647c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004ff037819ULL, 0x002fe20000011602ULL,
0x000000000808783bULL, 0x000fe80000000200ULL, 0x0000000803027836ULL, 0x040fe20000000000ULL,
0x000000000c0c783bULL, 0x000fe20000000200ULL, 0x0000000a03107836ULL, 0x000fc60000000000ULL,
0x0000000702027812ULL, 0x000fe200078e7811ULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x0000000710107812ULL, 0x000fc600078e7811ULL, 0x0000001011027824ULL, 0x040fe200078e0202ULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0x0000001011107824ULL, 0x000fc600078e0210ULL,
0x0000000702027c11ULL, 0x000fe2000f8e20ffULL, 0x000000003434783bULL, 0x000fe20000000200ULL,
0x0000000710107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000204783bULL, 0x0002a80000000200ULL,
0x000000001038783bULL, 0x0007220000000200ULL, 0x0000000c03027836ULL, 0x042fe40000000000ULL,
0x0000000e03107836ULL, 0x008fc60000000000ULL, 0x0000000702027812ULL, 0x000fe400078e7811ULL,
0x0000000710107812ULL, 0x000fc600078e7811ULL, 0x0000001011027824ULL, 0x040fe400078e0202ULL,
0x0000001011107824ULL, 0x000fc600078e0210ULL, 0x0000000702027c11ULL, 0x000fe2000f8e20ffULL,
0x000000080418723cULL, 0x004fec0000001818ULL, 0x0000000a0414723cULL, 0x000fe20000001814ULL,
0x0000001176087c11ULL, 0x000fca000f8e20ffULL, 0x0000000c043c723cULL, 0x000fe2000000183cULL,
0x000000000808783bULL, 0x000e6a0000000200ULL, 0x0000000e0420723cULL, 0x000fe20000001820ULL,
0x00000011750c7c11ULL, 0x000fca000f8e20ffULL, 0x0000002c041c723cULL, 0x000fe2000000181cULL,
0x000000000c0c783bULL, 0x000eaa0000000200ULL, 0x0000002e0424723cULL, 0x000fe20000001824ULL,
0x00000011732c7c11ULL, 0x000fca000f8e20ffULL, 0x000000300428723cULL, 0x000fe20000001828ULL,
0x000000002c2c783bULL, 0x000fea0000000200ULL, 0x000000320440723cULL, 0x000fe20000001840ULL,
0x000000007404783bULL, 0x000ee80000000200ULL, 0x000000000230783bULL, 0x000f620000000200ULL,
0x000000343818723cULL, 0x010fec0000001818ULL, 0x00000008383c723cULL, 0x002fe2000000183cULL,
0x000000116c347c11ULL, 0x000fca000f8e20ffULL, 0x0000000a3820723cULL, 0x000fe20000001820ULL,
0x000000116e087c11ULL, 0x000fca000f8e20ffULL, 0x0000000c381c723cULL, 0x004fe2000000181cULL,
0x000000000808783bULL, 0x000e6a0000000200ULL, 0x0000000e3824723cULL, 0x000fe20000001824ULL,
0x000000116d0c7c11ULL, 0x000fca000f8e20ffULL, 0x000000363814723cULL, 0x000fe20000001814ULL,
0x000000000c0c783bULL, 0x000ea80000000200ULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x000000043828723cULL, 0x008fec0000001828ULL, 0x0000002c3018723cULL, 0x020fe20000001818ULL,
0x0000000710047c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff107424ULL, 0x000fc800078e00ffULL,
0x000000063840723cULL, 0x000fe20000001840ULL, 0x00000011652c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000fe80000000200ULL, 0x0000002e3044723cULL, 0x000fe20000001814ULL,
0x000000002c2c783bULL, 0x000fe80000000200ULL, 0x000000006838783bULL, 0x000ee20000000200ULL,
0x00000008303c723cULL, 0x002fe6000000183cULL, 0x000000006614783bULL, 0x000e660000000200ULL,
0x0000000a3008723cULL, 0x000fe20000001820ULL, 0x000000006420783bULL, 0x000f620000000200ULL,
0x01b68810ff0279a7ULL, 0x000ee80008500004ULL, 0x0000000c3048723cULL, 0x004fec000000181cULL,
0x0000000e300c723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x010fec0000001828ULL,
0x000000363040723cULL, 0x000fe20000001840ULL, 0x01b68803ff0075a7ULL, 0x008eaa0008000144ULL,
0x000000380424723cULL, 0x000fec0000001818ULL, 0x0000002e040c723cULL, 0x000fec000000180cULL,
0x000000160418723cULL, 0x002fec0000001808ULL, 0x00000014041c723cULL, 0x000fec000000183cULL,
0x000000200408723cULL, 0x020fe20000001828ULL, 0x3db504f324117820ULL, 0x000fe20000410000ULL,
0x3db504f325127820ULL, 0x000fc80000410000ULL, 0x0000003a0444723cULL, 0x000fe20000001844ULL,
0x3db504f326207820ULL, 0x000fe20000410000ULL, 0x3db504f327217820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fe20000410000ULL, 0x0000002c0414723cULL, 0x000fe20000001848ULL,
0x3db504f318187820ULL, 0x000fe20000410000ULL, 0x3db504f319197820ULL, 0x000fe20000410000ULL,
0x3db504f31a1a7820ULL, 0x000fe20000410000ULL, 0x3db504f31b1b7820ULL, 0x000fc40000410000ULL,
0x000000220404723cULL, 0x000fe20000001840ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe40000410000ULL, 0x3db504f309247820ULL, 0x000fe20000410000ULL,
0x3db504f30c227820ULL, 0x000fe20000410000ULL, 0x00000004720c7824ULL, 0x000fe400078e00ffULL,
0x3db504f308237820ULL, 0x000fe20000410000ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fe20000410000ULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0xfffffff00c087812ULL, 0x000fe200078ec0ffULL, 0x3db504f345457820ULL, 0x000fe20000410000ULL,
0x3db504f346467820ULL, 0x000fe20000410000ULL, 0x3db504f347477820ULL, 0x000fe20000410000ULL,
0x3db504f314147820ULL, 0x000fe20000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x3db504f316167820ULL, 0x000fe20000410000ULL, 0x3db504f317177820ULL, 0x000fc60000410000ULL,
0x3db504f304257820ULL, 0x000fe20000410000ULL, 0x3db504f305267820ULL, 0x000fe20000410000ULL,
0x3db504f306097820ULL, 0x000fe20000410000ULL, 0x3db504f3070c7820ULL, 0x000fe20000410000ULL,
0x0000001000dc8947ULL, 0x004fec0003800000ULL, 0x01b4000a08047984ULL, 0x0002a20008000c00ULL,
0xffffffff05047890ULL, 0x000fe2000fffe03fULL, 0x0000000000337919ULL, 0x000eea0000000000ULL,
0x000000045d007c0cULL, 0x000fda000bf05270ULL, 0x00000004000c0947ULL, 0x002fea0003800000ULL,
0x0000000233027824ULL, 0x008fe200078e00ffULL, 0x000000105d2a7c11ULL, 0x000fc8000f8e40ffULL,
0x0000000602027812ULL, 0x000fe400078ec0ffULL, 0x000000222a2a7c10ULL, 0x000fe4000fffe1ffULL,
0x0000000102037812ULL, 0x040fe400078efcffULL, 0x0000000802277812ULL, 0x040fe400078efcffULL,
0x0000002a0300720cULL, 0x000fe40003f26070ULL, 0x0000001002037812ULL, 0x000fc400078efcffULL,
0x0000002a2700720cULL, 0x080fe40003f06070ULL, 0x0000002a0300720cULL, 0x080fe40003fc6070ULL,
0x0000001102277812ULL, 0x040fe400078efcffULL, 0x0000001802037812ULL, 0x040fe400078efcffULL,
0x0000002a0200720cULL, 0x080fe40003f46070ULL, 0x0000002a2700720cULL, 0x000fc40003fa6070ULL,
0x0000002a0300720cULL, 0x000fe40003f66070ULL, 0x0000000902287812ULL, 0x040fe400078efcffULL,
0x0000001902277812ULL, 0x040fe400078efcffULL, 0x0000002002037812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fc40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000002a2800720cULL, 0x080fe40003f86070ULL, 0x0000002a2700720cULL, 0x080fe40003f46070ULL,
0x0000002a0300720cULL, 0x000fe40003f26070ULL, 0x0000002102277812ULL, 0x000fc400078efcffULL,
0x0000002802037812ULL, 0x000fe400078efcffULL, 0xff7fffff46467808ULL, 0x000fe40004000000ULL,
0xff7fffff44447808ULL, 0x000fe40004000000ULL, 0xff7fffff47477808ULL, 0x000fe40006000000ULL,
0xff7fffff45457808ULL, 0x000fe40006000000ULL, 0x0000002a2700720cULL, 0x000fc40003f06070ULL,
0x0000002a0300720cULL, 0x000fe40003f86070ULL, 0x0000002902277812ULL, 0x040fe400078efcffULL,
0x0000003002037812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL, 0xff7fffff1f1f7808ULL, 0x000fc40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0x0000002a2700720cULL, 0x080fe40003fc6070ULL,
0x0000002a0300720cULL, 0x000fe40003fa6070ULL, 0x0000003102277812ULL, 0x040fe400078efcffULL,
0x0000003802037812ULL, 0x040fe400078efcffULL, 0x0000003902027812ULL, 0x000fc400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005800000ULL, 0xff7fffff18187808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40005000000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0xff7fffff14147808ULL, 0x000fc40004800000ULL,
0x0000002a2700720cULL, 0x080fe40003f66070ULL, 0x0000002a0300720cULL, 0x080fe40003f46070ULL,
0x0000002a0200720cULL, 0x000fe40003f26070ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff15157808ULL, 0x000fe40004000000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40006000000ULL,
0xff7fffff22227808ULL, 0x000fe40006000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40007000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006800000ULL,
0xff7fffff23237808ULL, 0x000fe40006800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40005800000ULL,
0xff7fffff24247808ULL, 0x000fe40005800000ULL, 0xff7fffff09097808ULL, 0x000fe40005000000ULL,
0xff7fffff25257808ULL, 0x000fe40005000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fce0004800000ULL, 0x0000001104037209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000002005027209ULL, 0x000fe40007810000ULL,
0x0000001203037209ULL, 0x000fe40007810000ULL, 0x0000002102057209ULL, 0x000fe40007810000ULL,
0x0000004403027209ULL, 0x000fe40007810000ULL, 0x0000004605047209ULL, 0x000fc40007810000ULL,
0x0000004502037209ULL, 0x000fe40007810000ULL, 0x0000004704057209ULL, 0x000fe40007810000ULL,
0x0000001c03027209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000001d02037209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000001803027209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000001902037209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000001403027209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fc40007810000ULL,
0x0000001502037209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000002203027209ULL, 0x000fe40007810000ULL, 0x0000000e05047209ULL, 0x000fe40007810000ULL,
0x0000000d02027209ULL, 0x000fe40007810000ULL, 0x0000000f04037209ULL, 0x000fc40007810000ULL,
0x0000002302057209ULL, 0x000fe40007810000ULL, 0x0000000a03027209ULL, 0x000fe20007810000ULL,
0x0000001bff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x0000000b02027209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x0000000902277209ULL, 0x000fc40007810000ULL, 0x0000000703037c11ULL, 0x000fe4000f8e28ffULL,
0x0000002605057209ULL, 0x000fe40007810000ULL, 0x0000000c27047209ULL, 0x000fe20007810000ULL,
0x0000000e04487947ULL, 0x000fec000b800000ULL, 0x0c401f0005027f89ULL, 0x000e6800000e0000ULL,
0x0c401f0004277f89ULL, 0x000ea800000e0000ULL, 0x0c401f00062b7f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f6200000e0000ULL, 0x0000000205287209ULL, 0x002fc40007810000ULL,
0x0000002704297209ULL, 0x004fc60007810000ULL, 0x0c201f00282d7f89ULL, 0x000e6200000e0000ULL,
0x0000002b062b7209ULL, 0x010fc60007810000ULL, 0x0c201f00292c7f89ULL, 0x000ea200000e0000ULL,
0x0000002a07027209ULL, 0x020fc60007810000ULL, 0x0c201f002b2e7f89ULL, 0x000f2800000e0000ULL,
0x0c201f0002277f89ULL, 0x0006e200000e0000ULL, 0x0000002d28047209ULL, 0x002fe40007810000ULL,
0x0000002c29057209ULL, 0x004fe40007810000ULL, 0x0000002e2b067209ULL, 0x010fce0007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05267820ULL, 0x000fe20000410000ULL,
0x0000001d00297308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010826ULL,
0x00000014002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b09097823ULL, 0x000fc80000010826ULL, 0x0000001100117308ULL, 0x000ff00000000800ULL,
0x0000001200127308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000ff00000000800ULL,
0x0000004500457308ULL, 0x000ff00000000800ULL, 0x00000020001d7308ULL, 0x0003f00000000800ULL,
0x0000002100147308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b16207823ULL, 0x002fce0000010826ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x0000001d141d723eULL, 0x004fce00000000ffULL,
0x0000004700477308ULL, 0x000e700000000800ULL, 0x00000018002a7308ULL, 0x0005f00000000800ULL,
0x00000015002d7308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b1f187823ULL, 0x004fe20000010826ULL,
0x00000046471f723eULL, 0x002fcc00000000ffULL, 0x0000001c00287308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b1e157823ULL, 0x010fe20000010826ULL, 0x00000044451e723eULL, 0x000fcc00000000ffULL,
0x00000024002f7308ULL, 0x0009e20000000800ULL, 0x00000011121c723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b1a117823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1b127823ULL, 0x000fe20000010826ULL,
0x000000282914723eULL, 0x004fc800000000ffULL, 0x0000002500307308ULL, 0x0003e20000000800ULL,
0x3c003c00ff247424ULL, 0x010fce00078e00ffULL, 0x00000019002b7308ULL, 0x000ea20000000800ULL,
0x3c003c00ff257424ULL, 0x002fce00078e00ffULL, 0x0000001800327308ULL, 0x0003e20000000800ULL,
0x0000002a2b16723eULL, 0x004fce00000000ffULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000241c18723cULL, 0x002fe400000018ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x000000153215723eULL, 0x004fce00000000ffULL,
0x0000001200127308ULL, 0x000e700000000800ULL, 0x00000023002e7308ULL, 0x0005300000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17237823ULL, 0x104fe20000010826ULL,
0x000000111217723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b0c267823ULL, 0x000fe20000010826ULL,
0x0000002e2f0c723eULL, 0x010fc800000000ffULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x000000241418723cULL, 0x000fee0000001818ULL, 0x0000002000217308ULL, 0x0005e20000000800ULL,
0x000000220d22723eULL, 0x002fce00000000ffULL, 0x0000002300347308ULL, 0x000e620000000800ULL,
0x0000002c2d20723eULL, 0x004fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000213421723eULL, 0x002fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e700000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x0000000e0f23723eULL, 0x002fce00000000ffULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x000000242018723cULL, 0x000fe20000001818ULL,
0x00000030070e723eULL, 0x004fcc00000000ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0xfffffffc33077812ULL, 0x008fce00078ec0ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x0000000a0b0d723eULL, 0x002fce00000000ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000000fff0a7424ULL, 0x000fe200078e00ffULL, 0x00000009260f723eULL, 0x002fc800000000ffULL,
0x000000070a097219ULL, 0x000fe400000006ffULL, 0x0000002702077209ULL, 0x000fe20007810000ULL,
0x000000240c28723cULL, 0x000fde0000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff28187589ULL, 0x00026200000e0000ULL, 0x0000000000127806ULL, 0x000fe200038e0100ULL,
0x00000000090a73a1ULL, 0x000eb000000e8000ULL, 0x00000000090473c4ULL, 0x000ee20000004000ULL,
0x00000000000e7886ULL, 0x000fc400038e0100ULL, 0x0000000e09ff7c12ULL, 0x004fda000f80400aULL,
0x0000000a045c8947ULL, 0x00afea000b800000ULL, 0x001c1fff2a197589ULL, 0x0002a800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x000ee800000e0000ULL, 0x001c1fff001b7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff137812ULL, 0x000fe200078ee213ULL, 0x000000071b047291ULL, 0x000fe2000f8e583fULL,
0x00000003000b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fe200078e001cULL,
0x0000000333ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000813027836ULL, 0x000fe20000000000ULL,
0x000000040b117812ULL, 0x000fe200078efcffULL, 0x0000000813007824ULL, 0x002fe200078e00ffULL,
0x000000070b097812ULL, 0x000fe200078e7813ULL, 0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL,
0x0000000711137812ULL, 0x000fe200078e7813ULL, 0x00000008020a7824ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078e7802ULL, 0x000000ffff257224ULL, 0x000fe200078e001eULL,
0x0000000711117812ULL, 0x000fe200078e7802ULL, 0x0001100012027836ULL, 0x000fe20000000000ULL,
0x0000000009097212ULL, 0x080fe200078efcffULL, 0x000000ffff267224ULL, 0x000fe200078e0014ULL,
0x0000000013137212ULL, 0x000fe200078efcffULL, 0x000000ffff277224ULL, 0x000fe200078e0016ULL,
0x0000000a0b0b7212ULL, 0x080fe200078efcffULL, 0x0000001009097824ULL, 0x000fe200078e0202ULL,
0x0000000a11117212ULL, 0x000fe200078efcffULL, 0x000000ffff1c7224ULL, 0x000fc400078e001dULL,
0x0000001013137824ULL, 0x000fe200078e0202ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002409007844ULL, 0x0003e20000000200ULL, 0x000000ffff287224ULL, 0x000fe400078e0020ULL,
0x000000ffff297224ULL, 0x000fe400078e0022ULL, 0x000000ffff2a7224ULL, 0x000fc400078e000cULL,
0x000000ffff2b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1d7224ULL, 0x000fe400078e001fULL,
0x000000100b0b7824ULL, 0x100fe200078e0202ULL, 0x0000002813007844ULL, 0x0003e20000000200ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0017ULL,
0x0000001011117824ULL, 0x000fc400078e0202ULL, 0x000000ffff147224ULL, 0x000fe200078e0021ULL,
0x0000001c0b007844ULL, 0x0003e20000000200ULL, 0x000000ffff157224ULL, 0x000fe400078e0023ULL,
0x000000ffff167224ULL, 0x000fe400078e000dULL, 0x000000ffff177224ULL, 0x000fe400078e000fULL,
0x0000000bff5d7e24ULL, 0x000fc6000f8e00ffULL, 0x0000001411007844ULL, 0x0003e20000000200ULL,
0x000000050b00728cULL, 0x000fc6000bf06070ULL, 0x01b0000408008988ULL, 0x0003e80008000c0aULL,
0x01b2001808008988ULL, 0x01c3e20008000c0aULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01b6081003ff79a7ULL, 0x0003e2000850003fULL, 0x01b6101003ff79a7ULL, 0x0003e2000850003fULL,
0x01b6181003ff79a7ULL, 0x0003e2000850003fULL, 0x01b6201003ff79a7ULL, 0x0003f2000850003fULL,
0xffffffb000048947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x01b6080fff0075a7ULL, 0x0002620008040166ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01b6080fff00a5a7ULL, 0x000e640008040066ULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff1800ac7947ULL, 0x020fea000383ffffULL,
0x01b6280dff0075a7ULL, 0x0002620008020166ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b6280dff0095a7ULL, 0x000e640008020066ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff3000187947ULL, 0x000fea000383ffffULL,
0x01b6480dff0075a7ULL, 0x0002620008000166ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b6480dff0085a7ULL, 0x000e640008000066ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff4000d07947ULL, 0x000fea000383ffffULL,
0x01b66803ff0075a7ULL, 0x0002620008000166ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b66803ff0085a7ULL, 0x000e640008000066ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff5400347947ULL, 0x000fea000383ffffULL,
0x01b60003ff0075a7ULL, 0x0004a20008000147ULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b60003ff0085a7ULL, 0x000e640008000047ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffac007c7947ULL, 0x012fea000383ffffULL,
0x00000004ff057e24ULL, 0x000fc8000f8e00ffULL, 0x01b68803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b68803050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffec00087947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe400078e0005ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fce00078e00ffULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003132307389ULL, 0x0009240000000034ULL,
0x000000000000791bULL, 0x010fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x002fe400078e0004ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x004fce00078e0030ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003132307389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000205287209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0006ULL,
0x000000ffff277224ULL, 0x000fce00078e0030ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003132307389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002704297209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0007ULL,
0x000000ffff2b7224ULL, 0x000fce00078e0030ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003132307389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002b062b7209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0028ULL,
0x00000001ff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff2a7224ULL, 0x000fce00078e0030ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003132307389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a07027209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0029ULL, 0x000000ffff2d7224ULL, 0x000fce00078e0030ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003132307389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002d28047209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e002bULL, 0x000000ffff2c7224ULL, 0x000fce00078e0030ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003132307389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c29057209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0002ULL, 0x000000ffff2e7224ULL, 0x000fce00078e0030ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003132307389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002e2b067209ULL, 0x000fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e0030ULL, 0xfffffff000107947ULL, 0x008fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e0009ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x004fe400078e001bULL,
0x000000ffff2a7224ULL, 0x002fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e0009ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000000ffff2a7224ULL, 0x002fe400078e0000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e0009ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff4003c7947ULL, 0x006fea000383ffffULL, 0x018000000b027836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000b00028308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff027807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff0b027812ULL, 0x000fc800078ec0ffULL, 0x000000ff0200720cULL, 0x000fc80003f02070ULL,
0xffffffffff027807ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000b037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000b00027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffee402647950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000678ULL, 0x00000000000004ecULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b64ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b88ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b88ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bb8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c08ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000011b00ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012780ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000012790ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012790ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000012790ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000012e78ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012e78ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000c00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000011b00ULL, 0x0000000000011b00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000012780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012790ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 77768;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
