/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011ff8ULL, 0x0000000000011b78ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000010b50ULL, 0x00000000000002b0ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000010e00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00010b5000000000ULL, 0x0000140400000000ULL, 0x0408288080810c00ULL, 0x00000000000042b4ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080c90828808081ULL, 0x8016288080860828ULL, 0x0000000310288082ULL,
0x8086920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000006800000000ULL,
0x00010b5000000000ULL, 0x000002b000000000ULL, 0x0000680400000000ULL, 0x8082288080860900ULL,
0x0000000000002880ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL, 0x000000080000000bULL,
0x0000000b00081104ULL, 0x0008120400000008ULL, 0x000000080000000eULL, 0x0000000e00081104ULL,
0x0008120400000008ULL, 0x000000080000000eULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00801b0380005003ULL,
0x000085a000183104ULL, 0x0001004000008b90ULL, 0x0001006000010050ULL, 0x00cc290400010070ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001c05000003ULL, 0x050000030500001cULL, 0x0500000305000003ULL,
0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL,
0x0500002b0500002bULL, 0x00cc28040500002bULL, 0x000000d0000000b0ULL, 0x00003e60000023f0ULL,
0x00003f8000003f20ULL, 0x000043a000003fc0ULL, 0x00004b90000043e0ULL, 0x00005b2000005a40ULL,
0x00005bd000005ba0ULL, 0x00005f3000005f00ULL, 0x0000678000006770ULL, 0x00006ad000006ac0ULL,
0x00008b90000085a0ULL, 0x000090a000009070ULL, 0x000096b000009690ULL, 0x0000f9800000f970ULL,
0x0000f9a00000f990ULL, 0x0000f9f00000f9d0ULL, 0x0000fa200000fa10ULL, 0x0001005000010030ULL,
0x000100a000010060ULL, 0x000100c0000100b0ULL, 0x000106e000010650ULL, 0x000107a000010740ULL,
0x0001087000010810ULL, 0x00010930000108d0ULL, 0x00010a70000109d0ULL, 0x0100390400010b10ULL,
0x000000ff00000180ULL, 0x0005010000023600ULL, 0x0000000200000270ULL, 0x003f010000023608ULL,
0x00000002000002e0ULL, 0x003f010000023610ULL, 0x000000ff000006b0ULL, 0x0005010700023600ULL,
0x000000ff000008a0ULL, 0x000c010100023610ULL, 0x000000ff00003d10ULL, 0x001c010a00023608ULL,
0x000000ff00004af0ULL, 0x001c010100023610ULL, 0x000000ff00005970ULL, 0x001c010a00023628ULL,
0x000000ff00006360ULL, 0x001c010100023630ULL, 0x000000ff0000bbc0ULL, 0x0013010a00023600ULL,
0x000000ff0000f060ULL, 0x0019010a00023610ULL, 0x000000ff000103e0ULL, 0x0019010100023608ULL,
0x000000ff00010430ULL, 0x001c010a00023608ULL, 0x000000ff000104b0ULL, 0x001c010a00023628ULL,
0x000000ff00010510ULL, 0x0013010a00023600ULL, 0x000000ff00010590ULL, 0x0019010a00023610ULL,
0x00141c0400033803ULL, 0x0000a16000009ce0ULL, 0x0000bc900000bbf0ULL, 0x000c050400010400ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000000f00080a04ULL,
0x0004360400580210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000ccULL, 0x0000000e00000002ULL, 0x0000000000010b50ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0xfffffff801017836ULL, 0x002fe20000000000ULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000479c3ULL, 0x000f300000002700ULL,
0x00000000000979c3ULL, 0x000f220000002600ULL, 0x00000005ff4a7e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff027819ULL, 0x004fcc0000011605ULL, 0x00001fff02027589ULL, 0x000ea200000e0000ULL,
0x0000000108007824ULL, 0x002fc600078e0203ULL, 0x00001fff08087589ULL, 0x000e6200000e0000ULL,
0x0000008000007824ULL, 0x000fca00078e0205ULL, 0x000000ff0000720cULL, 0x040fe40003f05270ULL,
0x000000030000780cULL, 0x000fe40003f24070ULL, 0x00000000020f72caULL, 0x004fd200000e0000ULL,
0x0000000000240947ULL, 0x012fec0003800000ULL, 0x00000000000679c3ULL, 0x000ea20000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x004fc60008000005ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eae0000000000ULL,
0x02360006053f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030000127ab9ULL, 0x000fe20000000800ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000601947ULL, 0x000fea0003800000ULL,
0x00000000000679c3ULL, 0x000ea20000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7fff000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x004fc60008000005ULL, 0x001fffc000067882ULL, 0x000fc60000000000ULL,
0x0000000500027c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000020512caULL, 0x004fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x02360806053f75b2ULL, 0x0085300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007918ULL, 0x008fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff8000067882ULL, 0x004fe20000000000ULL, 0x7ffe000000077882ULL, 0x000fd60000000000ULL,
0x00000000020512caULL, 0x004fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x02361006053f75b2ULL, 0x0085300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0000780cULL, 0x000fe20003f04070ULL,
0x00008e0000067ab9ULL, 0x004fe20000000a00ULL, 0x000000ff0800720cULL, 0x002fe20003f25270ULL,
0x00000004040678a5ULL, 0x000fe2000f8e0006ULL, 0x0000820000107ab9ULL, 0x000fe20000000a00ULL,
0x00008400000d7ab9ULL, 0x000fc80000000800ULL, 0x00000006ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000007ff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000000000038919ULL, 0x000e620000008800ULL,
0x0000040000028802ULL, 0x000fc80000000f00ULL, 0x0000065403058816ULL, 0x002fe20000000002ULL,
0xff317217ff038424ULL, 0x000fc800078e00ffULL, 0x0000000400008824ULL, 0x000fca00078e0205ULL,
0x0234000300008388ULL, 0x0003e20000000800ULL, 0x0000000000007b1dULL, 0x008fec0000010000ULL,
0x0000000000981947ULL, 0x002fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00008800ff047b82ULL, 0x000ea20000000a00ULL, 0x000000020f087899ULL, 0x000fe4000800063fULL,
0x000000040d057899ULL, 0x000fe4000800063fULL, 0x0000000409067899ULL, 0x000fc6000800063fULL,
0x00000000000779c3ULL, 0x000ee20000008800ULL, 0x00000004050572a4ULL, 0x000fe2000f8e0206ULL,
0x000000080d007c11ULL, 0x002fc8000f8fe0ffULL, 0x00000007000a7812ULL, 0x040fe200078ec0ffULL,
0x00000002000b7836ULL, 0x040fe40000000000ULL, 0x0000000500037c36ULL, 0x000fe40008000000ULL,
0x000000050b097c36ULL, 0x040fe20008000000ULL, 0x000000070b0c7812ULL, 0x000fe200078ec0ffULL,
0x0000010003027825ULL, 0x104fe200078e0004ULL, 0x0000040000057882ULL, 0x000fe40000000000ULL,
0x0000000f0c0c7812ULL, 0x000fe200078e780dULL, 0x0000010009047825ULL, 0x000fe200078e0004ULL,
0x0000065407057896ULL, 0x008fc60008000005ULL, 0x000000100d097824ULL, 0x000fe400078e00ffULL,
0x000000100b0c7824ULL, 0x000fc600078e020cULL, 0x000000f0090f7812ULL, 0x000fe400078ec0ffULL,
0x0000000f0a097812ULL, 0x000fe400078e780dULL, 0x0000000f02027210ULL, 0x000fe40007f1e0ffULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x0000001000097824ULL, 0x000fe200078e0209ULL,
0x000000050c0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000000509097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c50ULL,
0x00000000040b7faeULL, 0x0003e2000b901c50ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0002360005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000001006067981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe40003f05270ULL, 0x00000000061672caULL, 0x004fda00000e0000ULL,
0x0000003f16057890ULL, 0x000fe4000fffe03fULL, 0x000000ff16077890ULL, 0x000fe4000fffe03fULL,
0x000000063f057899ULL, 0x000fe40008011605ULL, 0x000000083f077899ULL, 0x000fe20008011607ULL,
0x0000009800808947ULL, 0x000ff60003800000ULL, 0x000000004a0e72caULL, 0x000fe200000e0000ULL,
0x000000013f067899ULL, 0x000fe2000801160fULL, 0x00000000000b79c3ULL, 0x000e620000008800ULL,
0x00000002ff007424ULL, 0x000fe400078e00ffULL, 0x03ffffff06087892ULL, 0x000fd0000f8ec03fULL,
0x000000080e0e7291ULL, 0x000fc8000f8e103fULL, 0x000000050e00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000104088899ULL, 0x000fe2000800063fULL,
0x00009000000a8ab9ULL, 0x000fc60000000800ULL, 0x0000000a080a82a4ULL, 0x000fc6000f8e020aULL,
0x0000040000087882ULL, 0x000fe20000000000ULL, 0x0000000a0e0c8290ULL, 0x000fe4000fffe03fULL,
0x000006540b087896ULL, 0x002fc60008000008ULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x000000040c0a88a5ULL, 0x000fe4000f8e000aULL, 0x000000080f0c7291ULL, 0x000fc8000f8e203fULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fc6000f8e00ffULL,
0x02361000ffff79a7ULL, 0x0003e4000850000cULL, 0x0000001002028981ULL, 0x000ea2000c1e1900ULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x0000000609097899ULL, 0x000fe4000800063fULL,
0x000000010f137892ULL, 0x000fe2000f8ec03fULL, 0x000000014a007836ULL, 0x002fe20000000000ULL,
0x000000060d0b7899ULL, 0x000fe2000800063fULL, 0x00000000020c82caULL, 0x004fc600000e0000ULL,
0x0000000700007c0cULL, 0x000fd4000bf06070ULL, 0x0000000c000a8c82ULL, 0x000fc60008000000ULL,
0x0000000c00088947ULL, 0x000fea0003800000ULL, 0x0000000000257919ULL, 0x000e620000000000ULL,
0x000000064a007c11ULL, 0x000fe2000f8e10ffULL, 0x0000000a0b0a72a4ULL, 0x000fe4000f8e0209ULL,
0x00000008060b7291ULL, 0x000fe4000f8e783fULL, 0x0000004000007824ULL, 0x000fe200078e00ffULL,
0x00000003130c7899ULL, 0x000fe4000800063fULL, 0x0000000b130b7291ULL, 0x000fe4000f8e703fULL,
0x0000001600097c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff007224ULL, 0x000fe200078e0a00ULL,
0x000130000b0b7890ULL, 0x000fc8000fffe03fULL, 0x0000004009097446ULL, 0x000fe40003800000ULL,
0x00000003ff0a7819ULL, 0x002fe40000011625ULL, 0x0ffffff825037812ULL, 0x000fe400078ec0ffULL,
0x000000250a007212ULL, 0x0c0fe200078e3cffULL, 0x000000080a107836ULL, 0x040fe20000000000ULL,
0x0000003f0a087812ULL, 0x040fe200078ec0ffULL, 0x000000140a1c7836ULL, 0x000fe20000000000ULL,
0x00000007030b7812ULL, 0x000fe200078ef800ULL, 0x0000000810077824ULL, 0x040fe200078e00ffULL,
0x0000002510047212ULL, 0x080fe200078e3cffULL, 0x000000040a0c7836ULL, 0x000fe20000000000ULL,
0x000000251c037212ULL, 0x080fe200078e3cffULL, 0x000000100a187836ULL, 0x000fe20000000000ULL,
0xfffffff807147812ULL, 0x000fe200078ee204ULL, 0x000000081c047824ULL, 0x000fe200078e00ffULL,
0x000000250c027212ULL, 0x040fe200078e3cffULL, 0x000000080c057824ULL, 0x040fe200078e00ffULL,
0x000000090c00720cULL, 0x000fe20003f26070ULL, 0x000000200a227836ULL, 0x000fe20000000000ULL,
0xfffffff8041d7812ULL, 0x000fe200078ee203ULL, 0x0000000818077824ULL, 0x000fe200078e00ffULL,
0xfffffff8050e7812ULL, 0x000fe200078ee202ULL, 0x0000000822047824ULL, 0x000fe200078e00ffULL,
0x0000002518027212ULL, 0x080fe200078e3cffULL, 0x0000001c0a207836ULL, 0x000fe20000000000ULL,
0x0000002522037212ULL, 0x080fe200078e3cffULL, 0x000000240a247836ULL, 0x040fe20000000000ULL,
0xfffffff8071a7812ULL, 0x000fe200078ee202ULL, 0x0000000c0a127836ULL, 0x000fe20000000000ULL,
0xfffffff804237812ULL, 0x000fe200078ee203ULL, 0x0000000820217824ULL, 0x040fe200078e00ffULL,
0x0000002520027212ULL, 0x080fe200078e3cffULL, 0x0000000824037824ULL, 0x040fe200078e00ffULL,
0x0000002524067212ULL, 0x080fe200078e3cffULL, 0x0000000812057824ULL, 0x040fe200078e00ffULL,
0x0000002512007212ULL, 0x080fe200078e3cffULL, 0x000000180a1e7836ULL, 0x040fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee202ULL, 0x000000280a267836ULL, 0x000fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0xfffffff805167812ULL, 0x000fe200078ee200ULL,
0x0000002c0a287836ULL, 0x000fe20000000000ULL, 0x000000251e007212ULL, 0x080fe200078e3cffULL,
0x000000300a2a7836ULL, 0x000fe20000000000ULL, 0x0000002526077212ULL, 0x080fe200078e3cffULL,
0x0000000828057824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL,
0x0000000826007824ULL, 0x000fe200078e00ffULL, 0x0000002528047212ULL, 0x000fe200078e3cffULL,
0x000000082a0d7824ULL, 0x000fe200078e00ffULL, 0x0000003f0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000340a2c7836ULL, 0x000fe20000000000ULL, 0xfffffff800077812ULL, 0x000fc400078ee207ULL,
0x000000252a007212ULL, 0x000fe200078e3cffULL, 0x0000000a0c0f7c36ULL, 0x000fe20008000000ULL,
0x000000091000720cULL, 0x080fe20003f46070ULL, 0x000000082c1b7824ULL, 0x000fe200078e00ffULL,
0x0000003f10107812ULL, 0x000fe400078ec0ffULL, 0x000000091200720cULL, 0x080fe40003f66070ULL,
0xfffffff805047812ULL, 0x000fe200078ee204ULL, 0x0000000cff057e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80d007812ULL, 0x000fe200078ee200ULL, 0x0000000a080d7c36ULL, 0x000fe20008000000ULL,
0x0000003f12127812ULL, 0x000fe200078ec0ffULL, 0x0000000a10117c36ULL, 0x000fe20008000000ULL,
0x000000090a00720cULL, 0x000fe20003f06070ULL, 0x000001000d0c7825ULL, 0x002fe200078e0002ULL,
0x0000000b0e157c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff805057812ULL, 0x000fe200078ee225ULL,
0x0000000a12137c36ULL, 0x000fe20008000000ULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000001000f0e7825ULL, 0x100fe200078e0002ULL, 0x0000000b14177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b16197c11ULL, 0x000fe2000f8e20ffULL, 0x0000010011107825ULL, 0x100fe200078e0002ULL,
0x000000252c087212ULL, 0x000fe400078e3cffULL, 0x000000092200720cULL, 0x000fe20003f86070ULL,
0x0000010013127825ULL, 0x000fe200078e0002ULL, 0xfffffff81b087812ULL, 0x000fc400078ee208ULL,
0x0000003f22227812ULL, 0x000fe200078ec0ffULL, 0x00000010050c7825ULL, 0x000fe200078e000cULL,
0x0000000b1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b1f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010050e7825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000c101c50ULL, 0x000000091800720cULL, 0x040fe40003f06070ULL,
0x0000001005107825ULL, 0x000fe200078e0010ULL, 0x000000000e157faeULL, 0x000fe2000c901c50ULL,
0x0000003f18187812ULL, 0x000fc400078ec0ffULL, 0x0000001005127825ULL, 0x000fe200078e0012ULL,
0x000000091c00720cULL, 0x0c0fe20003f26070ULL, 0x0000000010177faeULL, 0x0005e2000d101c50ULL,
0x0000003f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000a181b7c36ULL, 0x000fe20008000000ULL,
0x000000091e00720cULL, 0x0c0fe20003f46070ULL, 0x0000000012197faeULL, 0x0007e2000d901c50ULL,
0x0000003f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000a1c0b7c36ULL, 0x002fe20008000000ULL,
0x000000092000720cULL, 0x040fe20003f66070ULL, 0x000001001b0c7825ULL, 0x000fe200078e0002ULL,
0x0000003f20207812ULL, 0x000fc400078ec0ffULL, 0x0000000b21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a1e117c36ULL, 0x004fe20008000000ULL, 0x0000000b23237c11ULL, 0x000fe2000f8e20ffULL,
0x000001000b0e7825ULL, 0x100fe200078e0002ULL, 0x0000000b1a0b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a20137c36ULL, 0x008fe20008000000ULL,
0x0000000b00177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a22157c36ULL, 0x000fe20008000000ULL,
0x0000000b08197c11ULL, 0x000fe2000f8e20ffULL, 0x0000010011107825ULL, 0x000fc800078e0002ULL,
0x0000010013127825ULL, 0x000fc800078e0002ULL, 0x0000010015147825ULL, 0x000fc800078e0002ULL,
0x00000010050c7825ULL, 0x000fc800078e000cULL, 0x00000010050e7825ULL, 0x040fe200078e000eULL,
0x000000000c0b7faeULL, 0x0003e2000c101c50ULL, 0x000000092400720cULL, 0x080fe40003f06070ULL,
0x0000001005107825ULL, 0x040fe200078e0010ULL, 0x000000000e1d7faeULL, 0x0005e2000c901c50ULL,
0x000000092600720cULL, 0x080fe40003f26070ULL, 0x0000001005127825ULL, 0x000fe200078e0012ULL,
0x00000000101f7faeULL, 0x0007e2000d101c50ULL, 0x000000092800720cULL, 0x000fc40003f46070ULL,
0x0000001005147825ULL, 0x000fe200078e0014ULL, 0x0000000012217faeULL, 0x0009e2000d901c50ULL,
0x000000092a00720cULL, 0x080fe40003f66070ULL, 0x000000380a0c7836ULL, 0x042fe20000000000ULL,
0x0000000014237faeULL, 0x0003e2000e101c50ULL, 0x0000003c0a0e7836ULL, 0x004fe20000000000ULL,
0x000000092c00720cULL, 0x000fe20003f86070ULL, 0x000000080c0d7824ULL, 0x040fe200078e00ffULL,
0x000000250c0a7212ULL, 0x000fe200078e3cffULL, 0x000000080e187824ULL, 0x000fe200078e00ffULL,
0x000000090c00720cULL, 0x000fc40003fa6070ULL, 0x000000250e0b7212ULL, 0x040fe400078e3cffULL,
0x000000090e00720cULL, 0x000fe40003fc6070ULL, 0x0000003f24247812ULL, 0x000fe400078ec0ffULL,
0x0000003f26267812ULL, 0x000fe400078ec0ffULL, 0x0000003f28287812ULL, 0x000fe400078ec0ffULL,
0x0000003f2a2a7812ULL, 0x000fc400078ec0ffULL, 0x0000003f2c2c7812ULL, 0x000fe200078ec0ffULL,
0x0000000a280f7c36ULL, 0x000fe20008000000ULL, 0x0000003f0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000a2a117c36ULL, 0x008fe20008000000ULL, 0x0000003f0e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a2c137c36ULL, 0x010fe20008000000ULL, 0xfffffff80d167812ULL, 0x000fe200078ee20aULL,
0x0000000a260d7c36ULL, 0x000fe20008000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x0000000a240b7c36ULL, 0x000fe20008000000ULL, 0x0000000b161b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0c157c36ULL, 0x002fe20008000000ULL, 0x0000000b181d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0e097c36ULL, 0x000fc40008000000ULL, 0x000001000b0a7825ULL, 0x000fc800078e0002ULL,
0x000001000d0c7825ULL, 0x000fc800078e0002ULL, 0x000001000f0e7825ULL, 0x000fc800078e0002ULL,
0x0000010011107825ULL, 0x000fc800078e0002ULL, 0x0000010013127825ULL, 0x000fc800078e0002ULL,
0x0000010015147825ULL, 0x000fc800078e0002ULL, 0x0000010009027825ULL, 0x000fe200078e0002ULL,
0x0000000b06097c11ULL, 0x000fc6000f8e20ffULL, 0x00000010050a7825ULL, 0x000fc800078e000aULL,
0x00000010050c7825ULL, 0x040fe200078e000cULL, 0x000000000a097faeULL, 0x0003e6000c101c50ULL,
0x00000010050e7825ULL, 0x040fe200078e000eULL, 0x000000000c077faeULL, 0x0003e6000c901c50ULL,
0x0000001005107825ULL, 0x000fc800078e0010ULL, 0x0000001005127825ULL, 0x000fc800078e0012ULL,
0x0000001005147825ULL, 0x000fc800078e0014ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x0000000b04057c11ULL, 0x000fca000f8e20ffULL, 0x000000000e057faeULL, 0x0003e8000d101c50ULL,
0x0000000010177faeULL, 0x0003e8000d901c50ULL, 0x0000000012197faeULL, 0x0003e8000e101c50ULL,
0x00000000141b7faeULL, 0x0003e8000e901c50ULL, 0x00000000021d7faeULL, 0x0003e2000f101c50ULL,
0x0000000800b07947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000e620000000000ULL,
0x00000003130d7899ULL, 0x000fe4000800063fULL, 0x00000008060c7291ULL, 0x000fe4000f8e783fULL,
0x0000000a0b0a72a4ULL, 0x000fe4000f8e0209ULL, 0x0000000c130c7291ULL, 0x000fc8000f8e703fULL,
0x000130000c0c7890ULL, 0x000fe2000fffe03fULL, 0x00000003ff027819ULL, 0x002fe40000011618ULL,
0x0ffffff818037812ULL, 0x000fe400078ec0ffULL, 0x0000001802007212ULL, 0x0c0fe200078e3cffULL,
0x0000000c02177836ULL, 0x040fe20000000000ULL, 0x0000003f02137812ULL, 0x040fe200078ec0ffULL,
0x0000000402157836ULL, 0x040fe20000000000ULL, 0x0000000703147812ULL, 0x000fe200078ef800ULL,
0x0000000802167836ULL, 0x000fe20000000000ULL, 0x0000001817107212ULL, 0x0c0fe200078e3cffULL,
0x0000000817037824ULL, 0x000fe200078e00ffULL, 0x0000001815097212ULL, 0x0c0fe200078e3cffULL,
0x0000000815047824ULL, 0x000fe200078e00ffULL, 0x0000001816117212ULL, 0x080fe200078e3cffULL,
0x00000014021b7836ULL, 0x040fe20000000000ULL, 0xfffffff803107812ULL, 0x000fe200078ee210ULL,
0x0000001002197836ULL, 0x000fe20000000000ULL, 0xfffffff804097812ULL, 0x000fe200078ee209ULL,
0x0000000816007824ULL, 0x000fe200078e00ffULL, 0x000000181b0e7212ULL, 0x080fe200078e3cffULL,
0x0000001c021f7836ULL, 0x040fe20000000000ULL, 0x00000018190f7212ULL, 0x080fe200078e3cffULL,
0x00000018021d7836ULL, 0x040fe20000000000ULL, 0xfffffff800117812ULL, 0x000fe200078ee211ULL,
0x000000081b037824ULL, 0x000fe200078e00ffULL, 0x000000181f0c7212ULL, 0x080fe200078e3cffULL,
0x0000000819047824ULL, 0x000fe200078e00ffULL, 0x000000181d0d7212ULL, 0x080fe200078e3cffULL,
0x000000081f057824ULL, 0x000fe200078e00ffULL, 0xfffffff8030e7812ULL, 0x000fe200078ee20eULL,
0x0000002402237836ULL, 0x040fe20000000000ULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x000000081d007824ULL, 0x000fe200078e00ffULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000002002217836ULL, 0x040fe20000000000ULL, 0x00000018230a7212ULL, 0x0c0fe200078e3cffULL,
0x0000002802257836ULL, 0x040fe20000000000ULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000823037824ULL, 0x000fe200078e00ffULL, 0x00000018210b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000821047824ULL, 0x000fe200078e00ffULL, 0x0000001825007212ULL, 0x0c0fe200078e3cffULL,
0x0000000825057824ULL, 0x000fe200078e00ffULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x0000002c02277836ULL, 0x040fe20000000000ULL, 0xfffffff8040b7812ULL, 0x000fe200078ee20bULL,
0x0000003002297836ULL, 0x040fe20000000000ULL, 0xfffffff805007812ULL, 0x000fe200078ee200ULL,
0x0000000827037824ULL, 0x040fe200078e00ffULL, 0x0000001827047212ULL, 0x080fe200078e3cffULL,
0x0000000829087824ULL, 0x040fe200078e00ffULL, 0x0000001829057212ULL, 0x080fe200078e3cffULL,
0x0000003c022f7836ULL, 0x040fe20000000000ULL, 0xfffffff803047812ULL, 0x000fe200078ee204ULL,
0x00000034022b7836ULL, 0x040fe20000000000ULL, 0xfffffff808057812ULL, 0x000fe200078ee205ULL,
0x000000082f037824ULL, 0x040fe200078e00ffULL, 0x000000182f087212ULL, 0x080fe200078e3cffULL,
0x00000038022d7836ULL, 0x000fe20000000000ULL, 0x000000182b067212ULL, 0x040fe200078e3cffULL,
0x000000082b077824ULL, 0x000fe200078e00ffULL, 0xfffffff803087812ULL, 0x000fe200078ee208ULL,
0x000000082d127824ULL, 0x000fe200078e00ffULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x0000003f15157812ULL, 0x000fe200078ec0ffULL, 0x0000000a13137c36ULL, 0x000fe20008000000ULL,
0xfffffff807067812ULL, 0x000fc400078ee206ULL, 0x000000182d077212ULL, 0x000fe400078e3cffULL,
0x0000003f16167812ULL, 0x000fe400078ec0ffULL, 0xfffffff812077812ULL, 0x000fe200078ee207ULL,
0x0000000dff127e24ULL, 0x000fe2000f8e00ffULL, 0x0000003f191a7812ULL, 0x000fe200078ec0ffULL,
0x0000000a16197c36ULL, 0x000fe20008000000ULL, 0x0000003f1b1c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff812127812ULL, 0x000fc400078ee218ULL, 0x0000003f17187812ULL, 0x000fe200078ec0ffULL,
0x0000000a15177c36ULL, 0x000fe20008000000ULL, 0x0000003f1d1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a1a1d7c36ULL, 0x000fe20008000000ULL, 0x0000003f1f207812ULL, 0x000fe200078ec0ffULL,
0x0000000a181b7c36ULL, 0x000fe20008000000ULL, 0x0000003f21227812ULL, 0x000fe200078ec0ffULL,
0x0000000a1c1f7c36ULL, 0x000fe20008000000ULL, 0x0000003f23247812ULL, 0x000fe200078ec0ffULL,
0x0000010017167825ULL, 0x002fe200078e0002ULL, 0x0000003f25267812ULL, 0x000fc400078ec0ffULL,
0x0000003f27287812ULL, 0x000fe200078ec0ffULL, 0x0000000a1e217c36ULL, 0x000fe20008000000ULL,
0x0000003f292a7812ULL, 0x000fe200078ec0ffULL, 0x0000010019187825ULL, 0x100fe200078e0002ULL,
0x0000003f2b2c7812ULL, 0x000fe400078ec0ffULL, 0x0000003f2d2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a20237c36ULL, 0x000fe20008000000ULL, 0x0000000c14337c11ULL, 0x000fe2000f8e20ffULL,
0x0000010013147825ULL, 0x000fe200078e0002ULL, 0x0000003f2f307812ULL, 0x000fc400078ec0ffULL,
0x0000000c09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a22257c36ULL, 0x000fe20008000000ULL,
0x0000000c11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a24277c36ULL, 0x000fe20008000000ULL,
0x0000000c0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a26297c36ULL, 0x000fe20008000000ULL,
0x0000000c0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a282b7c36ULL, 0x000fe20008000000ULL,
0x0000000c0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2a2d7c36ULL, 0x000fe20008000000ULL,
0x0000000c0a357c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2c2f7c36ULL, 0x000fe20008000000ULL,
0x0000000c00377c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2e317c36ULL, 0x000fe20008000000ULL,
0x0000000c05057c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000c07077c11ULL, 0x000fc6000f8e20ffULL, 0x0000000a30137c36ULL, 0x000fe40008000000ULL,
0x000001001d1c7825ULL, 0x000fc800078e0002ULL, 0x0000001012147825ULL, 0x000fc800078e0014ULL,
0x000001001f1e7825ULL, 0x100fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0003e6000b901c50ULL, 0x0000010021207825ULL, 0x000fc800078e0002ULL,
0x0000010023227825ULL, 0x000fc800078e0002ULL, 0x0000010025247825ULL, 0x100fe200078e0002ULL,
0x0000000c0e157c11ULL, 0x002fe4000f8e20ffULL, 0x0000000c0c337c11ULL, 0x000fe2000f8e20ffULL,
0x0000010027267825ULL, 0x000fc800078e0002ULL, 0x0000010029287825ULL, 0x000fc800078e0002ULL,
0x000001002b2a7825ULL, 0x000fc800078e0002ULL, 0x000001002d2c7825ULL, 0x000fc800078e0002ULL,
0x000001002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fc800078e0002ULL,
0x0000001012167825ULL, 0x000fc800078e0016ULL, 0x0000010013027825ULL, 0x000fe200078e0002ULL,
0x0000000c10137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016097faeULL, 0x0003e4000b901c50ULL,
0x0000001012187825ULL, 0x000fc800078e0018ULL, 0x00000010121a7825ULL, 0x040fe200078e001aULL,
0x0000000018117faeULL, 0x0005e6000b901c50ULL, 0x00000010121c7825ULL, 0x000fe200078e001cULL,
0x000000001a137faeULL, 0x000fe2000b901c50ULL, 0x0000000c04097c11ULL, 0x002fe4000f8e20ffULL,
0x00000010121e7825ULL, 0x040fe200078e001eULL, 0x000000001c0f7faeULL, 0x0003e6000b901c50ULL,
0x0000001012207825ULL, 0x000fe200078e0020ULL, 0x000000001e157faeULL, 0x0007e2000b901c50ULL,
0x0000000c08117c11ULL, 0x004fc4000f8e20ffULL, 0x0000001012227825ULL, 0x040fe200078e0022ULL,
0x00000000200d7faeULL, 0x0007e6000b901c50ULL, 0x0000001012247825ULL, 0x000fe200078e0024ULL,
0x0000000022337faeULL, 0x0007e2000b901c50ULL, 0x0000000c060f7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001012267825ULL, 0x040fe200078e0026ULL, 0x00000000240b7faeULL, 0x0007e6000b901c50ULL,
0x0000001012287825ULL, 0x040fe200078e0028ULL, 0x0000000026357faeULL, 0x0007e6000b901c50ULL,
0x00000010122a7825ULL, 0x040fe200078e002aULL, 0x0000000028377faeULL, 0x0007e6000b901c50ULL,
0x00000010122c7825ULL, 0x040fe200078e002cULL, 0x000000002a097faeULL, 0x0007e6000b901c50ULL,
0x00000010122e7825ULL, 0x040fe200078e002eULL, 0x000000002c057faeULL, 0x0007e6000b901c50ULL,
0x0000001012307825ULL, 0x040fe200078e0030ULL, 0x000000002e0f7faeULL, 0x0007e6000b901c50ULL,
0x0000001012027825ULL, 0x000fe200078e0002ULL, 0x0000000030077faeULL, 0x0007e8000b901c50ULL,
0x0000000002117faeULL, 0x0007e4000b901c50ULL, 0x000000030e0a7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffe12197891ULL, 0x000fe4000f8e103fULL,
0x000000020a0a7890ULL, 0x000fc8000fffe03fULL, 0x000000030a00788cULL, 0x000fc8000bf04070ULL,
0x00000002190a7887ULL, 0x000fc80008000000ULL, 0x0000000a0e0a7290ULL, 0x000fc8000fffe03fULL,
0x000000050a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001040b8899ULL, 0x000fe2000800063fULL, 0x00009000000c8ab9ULL, 0x000fc60000000800ULL,
0x0000000c0b0b82a4ULL, 0x000fc6000f8e020cULL, 0x00008c00000c8ab9ULL, 0x000fe20000000a00ULL,
0x0000000a0b0b8290ULL, 0x000fc8000fffe03fULL, 0x000000040b0c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff027e24ULL, 0x00afe4000f8e00ffULL, 0x0000000dff037e24ULL, 0x000fca000f8e00ffULL,
0x0000001002028981ULL, 0x000ea2000c1e1900ULL, 0xffffffff00147882ULL, 0x000fe20000000000ULL,
0xff317217ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fc4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000020b82caULL, 0x004fc400000e0000ULL, 0x000000074a007c0cULL, 0x000fd6000bf06070ULL,
0x0000000b00148c82ULL, 0x000fe40008000000ULL, 0x0000004000980947ULL, 0x000fea0003800000ULL,
0x00007610ff027816ULL, 0x000fe20000000002ULL, 0x00000001040b7899ULL, 0x000fe2000800063fULL,
0xff317217ff007424ULL, 0x000fe200078e00ffULL, 0x00000002061b7890ULL, 0x000fe2000fffe03fULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000040201007387ULL, 0x0003e20000100600ULL,
0x0000900000047ab9ULL, 0x000fe20000000800ULL, 0x00000008061c7291ULL, 0x000fe4000f8e203fULL,
0x000000040b0b72a4ULL, 0x000fc6000f8e0204ULL, 0x0000003f00047c82ULL, 0x000fd20008000000ULL,
0x000000050f0c7899ULL, 0x000fc8000800063fULL, 0xffffffc00c177892ULL, 0x000fcc000f8ec03fULL,
0x000000174a037c11ULL, 0x000fc8000f8e40ffULL, 0x0000001603007c0cULL, 0x000fda000bf06070ULL,
0x0000004000400947ULL, 0x000fea0003800000ULL, 0x000000014a027836ULL, 0x002fe20000000000ULL,
0x0000000000427919ULL, 0x000e620000000000ULL, 0x00000004000c7c82ULL, 0x000fe20008000000ULL,
0x0000000104047892ULL, 0x000fe2000f8e0c3fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000702007c0cULL, 0x000fda000bf06070ULL, 0x0000000c00208947ULL, 0x000fea0003800000ULL,
0x0000008003037836ULL, 0x000fe20000000000ULL, 0x00000003ff027819ULL, 0x002fe20000011642ULL,
0x0000840000157ab9ULL, 0x000fe20000000800ULL, 0x0000000e0f0e7899ULL, 0x000fe2000800063fULL,
0x000000ffff057224ULL, 0x000fe200078e0a03ULL, 0x00000016033c7c48ULL, 0x000fe2000ffe0000ULL,
0x0000000402037836ULL, 0x040fe20000000000ULL, 0x00000006151a7899ULL, 0x000fe2000800063fULL,
0x0000000802047836ULL, 0x040fe20000000000ULL, 0x00000008060d7291ULL, 0x000fe2000f8e783fULL,
0x0000001002067836ULL, 0x000fe20000000000ULL, 0x0000004203667212ULL, 0x0c0fe200078e3cffULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0x00000042045b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000004206577212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x0000001402077836ULL, 0x040fe20000000000ULL, 0xfffffff8085b7812ULL, 0x000fe200078ee25bULL,
0x0000001802087836ULL, 0x000fe20000000000ULL, 0xfffffff80c577812ULL, 0x000fe200078ee257ULL,
0x00000008070c7824ULL, 0x040fe200078e00ffULL, 0x0000004207557212ULL, 0x080fe200078e3cffULL,
0x00000008080e7824ULL, 0x040fe200078e00ffULL, 0x0000004208537212ULL, 0x080fe200078e3cffULL,
0x0000002402447836ULL, 0x040fe20000000000ULL, 0xfffffff80c557812ULL, 0x000fe200078ee255ULL,
0x0000002802377836ULL, 0x000fe20000000000ULL, 0x000040000e0e7892ULL, 0x000fe2000f8ec03fULL,
0x00000008440c7824ULL, 0x040fe200078e00ffULL, 0xfffffff80e537812ULL, 0x000fe200078ee253ULL,
0x000000141a1472a4ULL, 0x000fe2000f8e0209ULL, 0x00000042444d7212ULL, 0x080fe200078e3cffULL,
0x0000001c02097836ULL, 0x000fe20000000000ULL, 0x0000000313187899ULL, 0x000fe2000800063fULL,
0x00000008370e7824ULL, 0x040fe200078e00ffULL, 0x000000403c3c7446ULL, 0x000fe20003800005ULL,
0x0000000c02057836ULL, 0x040fe20000000000ULL, 0x00000042374b7212ULL, 0x080fe200078e3cffULL,
0x0000000e0d157290ULL, 0x000fe2000fffe03fULL, 0x0000003f025d7812ULL, 0x040fe200078ec0ffULL,
0x00000008092c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL,
0x00008a00001e7ab9ULL, 0x000fe20000000a00ULL, 0x00000042020c7212ULL, 0x0c0fe200078e3cffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000004209517212ULL, 0x080fe200078e3cffULL,
0x00000018ff0d7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80e4b7812ULL, 0x000fe200078ee24bULL,
0x0000001eff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x000000145d2d7c12ULL, 0x000fe2000f8efcffULL,
0x0000001fff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001504157291ULL, 0x000fe2000f8e683fULL,
0x0000004205597212ULL, 0x000fe200078e3cffULL, 0x0000003002357836ULL, 0x000fe20000000000ULL,
0x0000000742407812ULL, 0x000fe200078ec0ffULL, 0x0001300015157890ULL, 0x000fe2000fffe03fULL,
0x000000070c647812ULL, 0x000fe200078ec0ffULL, 0x00000038020b7836ULL, 0x040fe20000000000ULL,
0x0000003c0200720cULL, 0x000fe20003f06070ULL, 0x00000008352f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c517812ULL, 0x000fe200078ee251ULL, 0x000001002d2c7825ULL, 0x000fe200078e000eULL,
0xfffffff80a597812ULL, 0x000fc400078ee259ULL, 0x000000080d0c7812ULL, 0x000fe200078ee240ULL,
0x00000020020a7836ULL, 0x000fe20000000000ULL, 0x0ffffff864647812ULL, 0x000fe200078ef842ULL,
0x000000080b397824ULL, 0x000fe200078e00ffULL, 0x00000042356a7212ULL, 0x080fe200078e3cffULL,
0x000000080a2e7824ULL, 0x000fe200078e00ffULL, 0x0000003f035c7812ULL, 0x000fe200078ec0ffULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x00000015640d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000003f04657812ULL, 0x000fe200078ec0ffULL, 0x0000002c02367836ULL, 0x000fe20000000000ULL,
0x000000420a4f7212ULL, 0x080fe200078e3cffULL, 0x0000003402347836ULL, 0x000fe20000000000ULL,
0x000000420b687212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c0d7faeULL, 0x0003e2000c101c50ULL, 0xfffffff82f6a7812ULL, 0x000fe200078ee26aULL,
0x0000000834387824ULL, 0x000fe200078e00ffULL, 0x0000003f055a7812ULL, 0x000fc400078ec0ffULL,
0x000000145c3b7c12ULL, 0x000fe4000f8efcffULL, 0x0000003f06587812ULL, 0x000fe400078ec0ffULL,
0x00000014652f7c12ULL, 0x000fe2000f8efcffULL, 0x000001003b3a7825ULL, 0x100fe200078e000eULL,
0xfffffff82e4f7812ULL, 0x000fe400078ee24fULL, 0xfffffff839687812ULL, 0x000fe200078ee268ULL,
0x00000008362e7824ULL, 0x040fe200078e00ffULL, 0x0000003c0300720cULL, 0x000fe20003f06070ULL,
0x000001002f2c7825ULL, 0x002fe200078e000eULL, 0x00000042366b7212ULL, 0x000fc400078e3cffULL,
0x000000145a397c12ULL, 0x000fe2000f8efcffULL, 0x000000100c3a7825ULL, 0x000fe200078e003aULL,
0x0000003c0400720cULL, 0x000fe40003f26070ULL, 0x0000004234697212ULL, 0x000fe200078e3cffULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x00000014583d7c12ULL, 0x000fe4000f8efcffULL,
0x0000003c0500720cULL, 0x080fe40003f46070ULL, 0xfffffff82e6b7812ULL, 0x000fe200078ee26bULL,
0x00000100392e7825ULL, 0x000fe200078e000eULL, 0x0000003c0600720cULL, 0x000fc40003f66070ULL,
0xfffffff838697812ULL, 0x000fe200078ee269ULL, 0x000001003d387825ULL, 0x000fe200078e000eULL,
0x00000015660d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000155b3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c2e7825ULL, 0x000fe200078e002eULL, 0x0000003f07567812ULL, 0x000fe200078ec0ffULL,
0x000000003a0d7faeULL, 0x0003e2000c101c50ULL, 0x0000003f08547812ULL, 0x000fe200078ec0ffULL,
0x000000100c387825ULL, 0x000fe200078e0038ULL, 0x0000003f09527812ULL, 0x000fe200078ec0ffULL,
0x000000002c3d7faeULL, 0x0005e2000c901c50ULL, 0x00000015593f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001557417c11ULL, 0x000fe4000f8e20ffULL, 0x0000001456437c12ULL, 0x000fe2000f8efcffULL,
0x000000002e3f7faeULL, 0x0007e2000d101c50ULL, 0x0000003c0700720cULL, 0x000fe40003f06070ULL,
0x00000014540d7c12ULL, 0x002fe2000f8efcffULL, 0x0000000038417faeULL, 0x0003e2000d901c50ULL,
0x0000003f0a507812ULL, 0x000fe200078ec0ffULL, 0x00000100433a7825ULL, 0x000fe200078e000eULL,
0x00000014522d7c12ULL, 0x004fc4000f8efcffULL, 0x0000003c0800720cULL, 0x080fe40003f26070ULL,
0x0000003c0900720cULL, 0x080fe20003f46070ULL, 0x000001002d2c7825ULL, 0x100fe200078e000eULL,
0x00000014502f7c12ULL, 0x008fe4000f8efcffULL, 0x0000003f444e7812ULL, 0x000fe200078ec0ffULL,
0x000001000d387825ULL, 0x002fe200078e000eULL, 0x00000015553d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000003c0a00720cULL, 0x000fe20003f66070ULL, 0x000000100c3a7825ULL, 0x000fe200078e003aULL,
0x00000015533f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001551417c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c387825ULL, 0x000fe200078e0038ULL, 0x000000144e457c12ULL, 0x000fe2000f8efcffULL,
0x000000003a3d7faeULL, 0x000fe2000c101c50ULL, 0x0000003c4400720cULL, 0x000fe20003f06070ULL,
0x000001002f2e7825ULL, 0x000fe200078e000eULL, 0x000000154f437c11ULL, 0x000fe2000f8e20ffULL,
0x00000000383f7faeULL, 0x0003e2000c901c50ULL, 0x0000003f374c7812ULL, 0x000fe200078ec0ffULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x0000003f36637812ULL, 0x000fc400078ec0ffULL,
0x0000003f35627812ULL, 0x000fe200078ec0ffULL, 0x000000100c2e7825ULL, 0x000fe200078e002eULL,
0x000000002c417faeULL, 0x0005e2000d101c50ULL, 0x0000003f34617812ULL, 0x000fe400078ec0ffULL,
0x0000003c020d7836ULL, 0x000fe20000000000ULL, 0x000000002e437faeULL, 0x0007e2000d901c50ULL,
0x000000154d397c11ULL, 0x002fe4000f8e20ffULL, 0x0000003f0b607812ULL, 0x000fe200078ec0ffULL,
0x000000080d3a7824ULL, 0x040fe200078e00ffULL, 0x0000003f0d5e7812ULL, 0x000fc400078ec0ffULL,
0x00000014633b7c12ULL, 0x000fe2000f8efcffULL, 0x00000100452c7825ULL, 0x004fe200078e000eULL,
0x00000014623d7c12ULL, 0x000fe4000f8efcffULL, 0x000000420d677212ULL, 0x000fe400078e3cffULL,
0x000000144c2f7c12ULL, 0x008fe2000f8efcffULL, 0x000000100c2c7825ULL, 0x000fe200078e002cULL,
0x0000003c3700720cULL, 0x080fe40003f26070ULL, 0x00000014613f7c12ULL, 0x000fe2000f8efcffULL,
0x000001002f2e7825ULL, 0x000fe200078e000eULL, 0x0000003c3600720cULL, 0x000fe20003f46070ULL,
0x000000002c397faeULL, 0x0003e2000c101c50ULL, 0x0000001460437c12ULL, 0x000fc4000f8efcffULL,
0x0000003c3500720cULL, 0x080fe20003f66070ULL, 0x000000100c2e7825ULL, 0x000fe200078e002eULL,
0x000000145e457c12ULL, 0x000fe4000f8efcffULL, 0x0000003c3400720cULL, 0x080fe40003f86070ULL,
0x0000003c0b00720cULL, 0x080fe40003fa6070ULL, 0xfffffff83a677812ULL, 0x000fe200078ee267ULL,
0x000001003b2c7825ULL, 0x002fe200078e000eULL, 0x0000003c0d00720cULL, 0x000fc40003fc6070ULL,
0x000000154b417c11ULL, 0x000fe2000f8e20ffULL, 0x000001003d387825ULL, 0x100fe200078e000eULL,
0x0000001569477c11ULL, 0x000fe4000f8e20ffULL, 0x00000015685f7c11ULL, 0x000fe2000f8e20ffULL,
0x000001003f3a7825ULL, 0x100fe200078e000eULL, 0x000000002e417faeULL, 0x0003e2000c901c50ULL,
0x00000015676d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000100433c7825ULL, 0x000fe200078e000eULL,
0x000000156b437c11ULL, 0x000fc6000f8e20ffULL, 0x00000100453e7825ULL, 0x000fe200078e000eULL,
0x000000156a457c11ULL, 0x000fc6000f8e20ffULL, 0x000000100c2c7825ULL, 0x000fc800078e002cULL,
0x000000100c387825ULL, 0x040fe200078e0038ULL, 0x000000002c437faeULL, 0x0003e6000d101c50ULL,
0x000000100c3a7825ULL, 0x040fe200078e003aULL, 0x0000000038457faeULL, 0x0003e6000d901c50ULL,
0x000000100c3c7825ULL, 0x040fe200078e003cULL, 0x000000003a477faeULL, 0x0003e6000e101c50ULL,
0x000000100c3e7825ULL, 0x000fe200078e003eULL, 0x000000003c5f7faeULL, 0x0003e8000e901c50ULL,
0x000000003e6d7faeULL, 0x0003e2000f101c50ULL, 0x0000000800c47947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x002fe20000011642ULL, 0x0000000313157899ULL, 0x000fe2000800063fULL,
0x0000000742407812ULL, 0x000fe200078ec0ffULL, 0x00008400001a7ab9ULL, 0x000fe20000000800ULL,
0x0000000e0f0e7899ULL, 0x000fe2000800063fULL, 0x0000000402037836ULL, 0x040fe20000000000ULL,
0x000000061a1a7899ULL, 0x000fe2000800063fULL, 0x0000000802047836ULL, 0x040fe20000000000ULL,
0x00000008060d7291ULL, 0x000fe2000f8e783fULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x0000004203667212ULL, 0x080fe200078e3cffULL, 0x0000001c02097836ULL, 0x000fe20000000000ULL,
0x00000042045b7212ULL, 0x080fe200078e3cffULL, 0x0000001002067836ULL, 0x040fe20000000000ULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x0000001402077836ULL, 0x000fe20000000000ULL,
0x0000004209517212ULL, 0x080fe200078e3cffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000004206577212ULL, 0x0c0fe200078e3cffULL, 0x00000008070e7824ULL, 0x040fe200078e00ffULL,
0x0000004207557212ULL, 0x080fe200078e3cffULL, 0x00000008060c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8085b7812ULL, 0x000fe200078ee25bULL, 0x0000001802087836ULL, 0x040fe20000000000ULL,
0xfffffff80e557812ULL, 0x000fe200078ee255ULL, 0x00000008090e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c577812ULL, 0x000fe200078ee257ULL, 0x0000000c02057836ULL, 0x000fe20000000000ULL,
0x0000004208537212ULL, 0x0c0fe200078e3cffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e517812ULL, 0x000fe200078ee251ULL, 0x00000008050a7824ULL, 0x040fe200078e00ffULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0x0000004205597212ULL, 0x080fe200078e3cffULL,
0x0000002802377836ULL, 0x040fe20000000000ULL, 0xfffffff80c537812ULL, 0x000fe200078ee253ULL,
0x000040000e0e7892ULL, 0x000fe2000f8ec03fULL, 0xfffffff80a597812ULL, 0x000fe200078ee259ULL,
0x00000008370c7824ULL, 0x040fe200078e00ffULL, 0x00000042374b7212ULL, 0x080fe200078e3cffULL,
0x00000020020a7836ULL, 0x000fe20000000000ULL, 0x000000141a1472a4ULL, 0x000fe2000f8e0209ULL,
0x00000015ff2d7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80c4b7812ULL, 0x000fe200078ee24bULL,
0x000000080a2c7824ULL, 0x040fe200078e00ffULL, 0x000000420a4f7212ULL, 0x080fe200078e3cffULL,
0x0000002c02367836ULL, 0x040fe20000000000ULL, 0x00000042020c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000e0d157290ULL, 0x000fe2000fffe03fULL, 0x0000003f025d7812ULL, 0x040fe200078ec0ffULL,
0x0000003002357836ULL, 0x000fe20000000000ULL, 0xfffffff82c4f7812ULL, 0x000fe200078ee24fULL,
0x00000008362c7824ULL, 0x000fe200078e00ffULL, 0x000000070c647812ULL, 0x000fe200078ec0ffULL,
0x0000001504157291ULL, 0x000fe2000f8e683fULL, 0x000000082d0c7812ULL, 0x000fe200078ee240ULL,
0x00000038020b7836ULL, 0x000fe20000000000ULL, 0x00000042366b7212ULL, 0x080fe200078e3cffULL,
0x0001300015157890ULL, 0x000fe2000fffe03fULL, 0x000000145d2d7c12ULL, 0x000fe2000f8efcffULL,
0x0000000835397824ULL, 0x040fe200078e00ffULL, 0xfffffff82c6b7812ULL, 0x000fe200078ee26bULL,
0x0000002402447836ULL, 0x000fe20000000000ULL, 0x00000042356a7212ULL, 0x000fe200078e3cffULL,
0x000001002d2c7825ULL, 0x002fe200078e000eULL, 0x0ffffff864647812ULL, 0x000fc400078ef842ULL,
0x000000420b687212ULL, 0x0c0fe200078e3cffULL, 0x000000080b3b7824ULL, 0x000fe200078e00ffULL,
0x0000003f035c7812ULL, 0x000fe200078ec0ffULL, 0x0000003c020d7836ULL, 0x000fe20000000000ULL,
0x0000003f04657812ULL, 0x000fe200078ec0ffULL, 0x00000008442e7824ULL, 0x000fe200078e00ffULL,
0x0000003f055a7812ULL, 0x000fe200078ec0ffULL, 0x000000100c2c7825ULL, 0x000fe200078e002cULL,
0x00000015642f7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff8396a7812ULL, 0x000fe200078ee26aULL,
0x000000080d387824ULL, 0x000fe200078e00ffULL, 0x00000042444d7212ULL, 0x000fe200078e3cffULL,
0x0000003402347836ULL, 0x000fe20000000000ULL, 0xfffffff83b687812ULL, 0x000fe200078ee268ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000b901c50ULL,
0x000000145c397c12ULL, 0x000fc4000f8efcffULL, 0x000000420d677212ULL, 0x000fe400078e3cffULL,
0x0000003f06587812ULL, 0x000fe400078ec0ffULL, 0x00000014653b7c12ULL, 0x000fe4000f8efcffULL,
0x0000003f07567812ULL, 0x000fe400078ec0ffULL, 0x000000145a3d7c12ULL, 0x000fe2000f8efcffULL,
0x00000100392c7825ULL, 0x002fe200078e000eULL, 0xfffffff82e4d7812ULL, 0x000fc400078ee24dULL,
0xfffffff838677812ULL, 0x000fe200078ee267ULL, 0x00000008342e7824ULL, 0x000fe200078e00ffULL,
0x00000014583f7c12ULL, 0x000fe2000f8efcffULL, 0x000001003b387825ULL, 0x100fe200078e000eULL,
0x0000004234697212ULL, 0x000fe400078e3cffULL, 0x0000001456417c12ULL, 0x000fe2000f8efcffULL,
0x000001003d3c7825ULL, 0x100fe200078e000eULL, 0xfffffff82e697812ULL, 0x000fe400078ee269ULL,
0x0000003f08547812ULL, 0x000fe200078ec0ffULL, 0x000001003f3a7825ULL, 0x000fe200078e000eULL,
0x00000015663f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001559437c11ULL, 0x000fe2000f8e20ffULL,
0x00000100412e7825ULL, 0x000fe200078e000eULL, 0x000000155b417c11ULL, 0x000fe4000f8e20ffULL,
0x0000003f09527812ULL, 0x000fe200078ec0ffULL, 0x000000100c2c7825ULL, 0x000fe200078e002cULL,
0x0000003f0a507812ULL, 0x000fe400078ec0ffULL, 0x0000003f444e7812ULL, 0x000fe200078ec0ffULL,
0x000000100c387825ULL, 0x000fe200078e0038ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c50ULL,
0x00000014545f7c12ULL, 0x000fc4000f8efcffULL, 0x000000100c3c7825ULL, 0x040fe200078e003cULL,
0x0000000038417faeULL, 0x0005e2000b901c50ULL, 0x0000001557457c11ULL, 0x000fe4000f8e20ffULL,
0x000000100c3a7825ULL, 0x000fe200078e003aULL, 0x000000003c437faeULL, 0x0007e2000b901c50ULL,
0x0000003f374c7812ULL, 0x000fe400078ec0ffULL, 0x0000001555477c11ULL, 0x000fe2000f8e20ffULL,
0x000001005f2c7825ULL, 0x002fe200078e000eULL, 0x00000014523f7c12ULL, 0x000fe2000f8efcffULL,
0x000000003a457faeULL, 0x0003e2000b901c50ULL, 0x0000003f36637812ULL, 0x000fe200078ec0ffULL,
0x000000100c2e7825ULL, 0x000fe200078e002eULL, 0x0000001450417c12ULL, 0x004fc4000f8efcffULL,
0x0000003f35627812ULL, 0x000fe200078ec0ffULL, 0x000001003f387825ULL, 0x100fe200078e000eULL,
0x000000144e437c12ULL, 0x008fe2000f8efcffULL, 0x000000002e477faeULL, 0x0005e2000b901c50ULL,
0x00000015533f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000100413c7825ULL, 0x100fe200078e000eULL,
0x0000001551417c11ULL, 0x000fe4000f8e20ffULL, 0x000000144c457c12ULL, 0x002fe2000f8efcffULL,
0x00000100433a7825ULL, 0x000fe200078e000eULL, 0x000000154f437c11ULL, 0x000fc4000f8e20ffULL,
0x0000003f34617812ULL, 0x000fe200078ec0ffULL, 0x000000100c2c7825ULL, 0x040fe200078e002cULL,
0x0000003f0b607812ULL, 0x000fe400078ec0ffULL, 0x0000003f0d5e7812ULL, 0x000fe200078ec0ffULL,
0x000000100c387825ULL, 0x040fe200078e0038ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c50ULL,
0x00000014635f7c12ULL, 0x000fe4000f8efcffULL, 0x00000100452e7825ULL, 0x004fe200078e000eULL,
0x000000154d457c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038417faeULL, 0x0005e2000b901c50ULL,
0x000000154b477c11ULL, 0x000fe2000f8e20ffULL, 0x000000100c3c7825ULL, 0x000fc800078e003cULL,
0x000000100c3a7825ULL, 0x000fe200078e003aULL, 0x00000014623f7c12ULL, 0x002fe2000f8efcffULL,
0x000000003c437faeULL, 0x0003e4000b901c50ULL, 0x000000100c2e7825ULL, 0x000fe200078e002eULL,
0x0000001461417c12ULL, 0x004fe2000f8efcffULL, 0x000000003a457faeULL, 0x0005e4000b901c50ULL,
0x000001005f2c7825ULL, 0x100fe400078e000eULL, 0x000000002e477faeULL, 0x0007e4000b901c50ULL,
0x000001003f387825ULL, 0x000fe200078e000eULL, 0x000000156b3f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001460437c12ULL, 0x002fe2000f8efcffULL, 0x00000100413c7825ULL, 0x100fe200078e000eULL,
0x000000156a417c11ULL, 0x000fe4000f8e20ffULL, 0x000000145e457c12ULL, 0x004fe2000f8efcffULL,
0x00000100433a7825ULL, 0x100fe200078e000eULL, 0x0000001569437c11ULL, 0x000fe4000f8e20ffULL,
0x0000001567477c11ULL, 0x008fe2000f8e20ffULL, 0x00000100452e7825ULL, 0x000fe200078e000eULL,
0x0000001568457c11ULL, 0x000fc6000f8e20ffULL, 0x000000100c2c7825ULL, 0x000fc800078e002cULL,
0x000000100c387825ULL, 0x040fe200078e0038ULL, 0x000000002c3f7faeULL, 0x0003e6000b901c50ULL,
0x000000100c3c7825ULL, 0x040fe200078e003cULL, 0x0000000038417faeULL, 0x0003e6000b901c50ULL,
0x000000100c3a7825ULL, 0x040fe200078e003aULL, 0x000000003c437faeULL, 0x0003e6000b901c50ULL,
0x000000100c2e7825ULL, 0x000fe200078e002eULL, 0x000000003a457faeULL, 0x0003e8000b901c50ULL,
0x000000002e477faeULL, 0x0003e4000b901c50ULL, 0x00000400012c7983ULL, 0x002ea20000100800ULL,
0x000000030a147892ULL, 0x000fc6000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000214147890ULL, 0x000fc8000fffe03fULL, 0x000000031400788cULL, 0x000fc8000bf04070ULL,
0x0000000219157887ULL, 0x000fc80008000000ULL, 0x000000150a0a7290ULL, 0x000fc8000fffe03fULL,
0x000000050a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000a0b1d8290ULL, 0x000fe2000fffe03fULL, 0x00000010422f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff2e7819ULL, 0x000fe40000011642ULL, 0x0000ffff2c2c7812ULL, 0x004fc800078ec0ffULL,
0x000000002c1472caULL, 0x000fda00000e0000ULL, 0x0000888014187896ULL, 0x000fc6000800003fULL,
0x00008c0000148ab9ULL, 0x000fe40000000a00ULL, 0x000000041d1488a5ULL, 0x000fe4000f8e0014ULL,
0x0000001f181d7899ULL, 0x000fc8000800063fULL, 0x00000014ff2c7e24ULL, 0x000fe4000f8e00ffULL,
0x00000015ff2d7e24ULL, 0x000fe4000f8e00ffULL, 0x0000001dff387e24ULL, 0x000fc6000f8e00ffULL,
0x000000102c708981ULL, 0x000362000c1e1900ULL, 0x02360838ff0075a7ULL, 0x000ea2000802015cULL,
0x0000000806147291ULL, 0x000fe2000f8e383fULL, 0x000000702f2d7812ULL, 0x002fe400078ec0ffULL,
0x0000000c2e2c7812ULL, 0x000fc800078ec0ffULL, 0x000000142c5f7c10ULL, 0x000fe2000fffe02dULL,
0x000000c400a89947ULL, 0x004fec0003800000ULL, 0x023000005f2d7984ULL, 0x000e620000000800ULL,
0x0000000d131d7291ULL, 0x000fe2000f8e703fULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x00000008061c7291ULL, 0x000fe2000f8e583fULL, 0x0000000000737919ULL, 0x000ea20000000000ULL,
0x0000001d0c147291ULL, 0x000fe2000f8e683fULL, 0x023200005f5f7984ULL, 0x000ee20000000800ULL,
0x0000000840457812ULL, 0x004fe400078ef873ULL, 0x00000004ff417819ULL, 0x000fe40000011673ULL,
0x000000002d00720bULL, 0x002fc40003f3d000ULL, 0x00000008732f7812ULL, 0x000fe400078ec0ffULL,
0x0000000741787812ULL, 0x000fe400078e7845ULL, 0x000000402f487212ULL, 0x000fe400078efcffULL,
0x000000072f407812ULL, 0x000fe200078ec840ULL, 0x0000000845787824ULL, 0x000fc800078e0278ULL,
0x00000000002c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff2c397812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x008fea0003800000ULL, 0x000000002d00720bULL, 0x000fe20003f34000ULL,
0x00000000003c7919ULL, 0x000e620000000000ULL, 0x0000002d003b7209ULL, 0x000fe20007810000ULL,
0x0000000f0600728cULL, 0x000fe2000bf25270ULL, 0x00000002ff2e7819ULL, 0x000fc60000011673ULL,
0x8000003b002c7221ULL, 0x000fe40000010000ULL, 0x000000082e2f7836ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f4f018ULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe200008e0100ULL, 0x000000080f069291ULL, 0x000fc6000f8e383fULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x0000002c002c7308ULL, 0x000ea60000000800ULL,
0x0000000039ff7212ULL, 0x000fc8000782c0ffULL, 0x00000001ff387807ULL, 0x000fe20000800000ULL,
0x00001f2f2c2f7589ULL, 0x004eb000000e0000ULL, 0x8000003b2d2d1221ULL, 0x000fe20000010000ULL,
0x00000001ff3a7819ULL, 0x002fe2000001163cULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x00001f2e2c2e7589ULL, 0x000e6200000e0000ULL, 0x3fb8aa3b2d2d1820ULL, 0x000fe20000410000ULL,
0x0000000c3a3a7812ULL, 0x000fe200078ec0ffULL, 0x0000002c49497220ULL, 0x000fe20000410000ULL,
0x000000703c3c7812ULL, 0x000fe200078ec0ffULL, 0x0000002d006e1308ULL, 0x000ee60000000800ULL,
0x000000063a00ac10ULL, 0x000fca000fffe03cULL, 0x0234003b0000a388ULL, 0x0009e20000000800ULL,
0x0000002f33337220ULL, 0x084fe20000410000ULL, 0x0000002f32327220ULL, 0x080fe20000410000ULL,
0x0000002f13137220ULL, 0x080fe20000410000ULL, 0x0000002f12127220ULL, 0x080fe20000410000ULL,
0x0000002f17177220ULL, 0x080fe20000410000ULL, 0x0000002f16167220ULL, 0x080fe20000410000ULL,
0x0000002f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002f23237220ULL, 0x080fe20000410000ULL, 0x0000002f22227220ULL, 0x080fe20000410000ULL,
0x0000002f27277220ULL, 0x080fe20000410000ULL, 0x0000002f26267220ULL, 0x080fe20000410000ULL,
0x0000002f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000002f2a2a7220ULL, 0x000fe20000410000ULL,
0x0000002e31317220ULL, 0x082fe20000410000ULL, 0x0000002e30307220ULL, 0x080fe20000410000ULL,
0x0000002e11117220ULL, 0x080fe20000410000ULL, 0x0000002e10107220ULL, 0x080fe20000410000ULL,
0x0000002e15157220ULL, 0x080fe20000410000ULL, 0x0000002e14147220ULL, 0x080fe20000410000ULL,
0x0000002e19197220ULL, 0x080fe20000410000ULL, 0x0000002e18187220ULL, 0x080fe20000410000ULL,
0x0000002e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002e21217220ULL, 0x080fe20000410000ULL, 0x0000002e20207220ULL, 0x080fe20000410000ULL,
0x0000002e25257220ULL, 0x080fe20000410000ULL, 0x0000002e24247220ULL, 0x080fe20000410000ULL,
0x0000002e29297220ULL, 0x080fe20000410000ULL, 0x0000002e28287220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x010fc400078e003bULL, 0x0000006e5f5f1220ULL, 0x008fce0000410000ULL,
0x0000004140727212ULL, 0x000fe200078e3cffULL, 0x0001300014147890ULL, 0x000fe2000fffe03fULL,
0x0000001c782c7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000848777824ULL, 0x000fe200078e0272ULL, 0x011000002c2c783bULL, 0x000fe20000000200ULL,
0x00000002ff3e7819ULL, 0x000fe20000011673ULL, 0x0000000241717836ULL, 0x040fe20000000000ULL,
0x00009910383d7816ULL, 0x000fe200000000ffULL, 0x00000006416d7836ULL, 0x000fe20000000000ULL,
0x0000001477397c11ULL, 0x000fe2000f8e20ffULL, 0x000000083e437836ULL, 0x000fe20000000000ULL,
0x0000006eff3c723eULL, 0x000fe200000000ffULL, 0x000000495f497221ULL, 0x000fe20000010000ULL,
0x000000ff3d00720cULL, 0x000fe20003f25270ULL, 0x000000013f067899ULL, 0x000fe2000801160fULL,
0x000000003938783bULL, 0x000fe20000004200ULL, 0x000054103c427816ULL, 0x000fc4000000003cULL,
0x00000071406f7212ULL, 0x040fe400078e3cffULL, 0x0000006d406d7212ULL, 0x000fe200078e3cffULL,
0x00001f4342467589ULL, 0x0002a200000e0000ULL, 0x0000000771767812ULL, 0x000fe200078e7845ULL,
0x00000008487c7824ULL, 0x000fe200078e026fULL, 0x00000000701582caULL, 0x020fe200000e0000ULL,
0x00001f3e42477589ULL, 0x000ee400000e0000ULL, 0x0000000845767824ULL, 0x000fe200078e0276ULL,
0x000000147c3c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000848437824ULL, 0x002fca00078e026dULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x0000004301007387ULL, 0x000fe20000100800ULL,
0x000000462d2d9232ULL, 0x084fe40000000000ULL, 0x000000462f2f9232ULL, 0x000fe40000000000ULL,
0x000000472c2c9232ULL, 0x088fe40000000000ULL, 0x000000472e2e9232ULL, 0x000fce0000000000ULL,
0x000000382c28723cULL, 0x000fec0000001828ULL, 0x0000003a2c24723cULL, 0x000fe20000001824ULL,
0x0000000441397836ULL, 0x000fe20000000000ULL, 0x0000001443387c11ULL, 0x000fc8000f8e20ffULL,
0x00000039406c7212ULL, 0x000fe400078e3cffULL, 0x000000003838783bULL, 0x000ea20000004200ULL,
0x0000003c2c20723cULL, 0x002fe40000001820ULL, 0x00000008487b7824ULL, 0x000fca00078e026cULL,
0x000000147b417c11ULL, 0x000fe2000f8e20ffULL, 0x0000003e2c1c723cULL, 0x000fe2000000181cULL,
0x0000001c763c7c11ULL, 0x000fc8000f8e20ffULL, 0x000000004140783bULL, 0x000e620000004200ULL,
0x000000382c10723cULL, 0x004fec0000001810ULL, 0x0000003a2c30723cULL, 0x000fec0000001830ULL,
0x000000402c18723cULL, 0x002fec0000001818ULL, 0x000000422c14723cULL, 0x000fe20000001814ULL,
0x0000008048407811ULL, 0x000fe200078e18ffULL, 0x011000003c2c783bULL, 0x000e680000000200ULL,
0x00000001727a7824ULL, 0x100fe200078e0240ULL, 0x0000010048437811ULL, 0x040fe200078e18ffULL,
0x000000016f757824ULL, 0x100fe200078e0240ULL, 0x0000018048487811ULL, 0x000fe200078e18ffULL,
0x000000016c747824ULL, 0x100fe200078e0240ULL, 0x000000147a387c11ULL, 0x000fe2000f8e20ffULL,
0x000000016d7d7824ULL, 0x000fe200078e0240ULL, 0x0000001475417c11ULL, 0x000fe2000f8e20ffULL,
0x000000016f717824ULL, 0x000fc400078e0243ULL, 0x000000016c707824ULL, 0x000fe200078e0243ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x0000000172427824ULL, 0x100fe400078e0248ULL,
0x000000016c407824ULL, 0x100fe200078e0248ULL, 0x00000000413c783bULL, 0x0007220000004200ULL,
0x00000001ff6c7424ULL, 0x000fe400078e00ffULL, 0x000000016f417824ULL, 0x108fe400078e0248ULL,
0x000000016d487824ULL, 0x000fc400078e0248ULL, 0x000000472c2c9232ULL, 0x082fe40000000000ULL,
0x000000472e2e9232ULL, 0x000fe40000000000ULL, 0x000000462d2d9232ULL, 0x080fe40000000000ULL,
0x000000462f2f9232ULL, 0x000fce0000000000ULL, 0x000000382c28723cULL, 0x004fec0000001828ULL,
0x0000003c2c20723cULL, 0x010fe20000001820ULL, 0x0000001474387c11ULL, 0x000fca000f8e20ffULL,
0x0000003a2c24723cULL, 0x000fe20000001824ULL, 0x000000147d3c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003838783bULL, 0x000e680000004200ULL, 0x0000003e2c1c723cULL, 0x000fe2000000181cULL,
0x000000003c3c783bULL, 0x000eaa0000004200ULL, 0x000000382c18723cULL, 0x002fec0000001818ULL,
0x0000003a2c14723cULL, 0x000fec0000001814ULL, 0x0000003c2c10723cULL, 0x004fec0000001810ULL,
0x0000003e2c30723cULL, 0x000fee0000001830ULL, 0x00000004732c7811ULL, 0x000fe200078fe0ffULL,
0x0000000172737824ULL, 0x000fc400078e0243ULL, 0x000000016d437824ULL, 0x000fe200078e0243ULL,
0x000000072c2c7812ULL, 0x000fe200078e7845ULL, 0x0000000000727919ULL, 0x000e620000000000ULL,
0x00000014733c7c11ULL, 0x000fc6000f8e20ffULL, 0x0000000845797824ULL, 0x000fe400078e022cULL,
0x000000003c38783bULL, 0x0005e60000004200ULL, 0x0000001c793d7c11ULL, 0x000fca000f8e20ffULL,
0x011000003d2c783bULL, 0x0007220000000200ULL, 0x00000014703c7c11ULL, 0x004fe4000f8e20ffULL,
0x00000014713d7c11ULL, 0x008fe2000f8e20ffULL, 0x000000472c2c9232ULL, 0x090fe40000000000ULL,
0x000000472e2e9232ULL, 0x000fe40000000000ULL, 0x000000462d2d9232ULL, 0x080fe40000000000ULL,
0x000000462f2f9232ULL, 0x000fce0000000000ULL, 0x000000382c28723cULL, 0x000fec0000001828ULL,
0x0000003a2c24723cULL, 0x000fe20000001824ULL, 0x000000003d38783bULL, 0x0004e40000004200ULL,
0x00000014433d7c11ULL, 0x004fc6000f8e20ffULL, 0x000000382c20723cULL, 0x008fec0000001820ULL,
0x0000003a2c1c723cULL, 0x000fe2000000181cULL, 0x000000003c38783bULL, 0x000eaa0000004200ULL,
0x000000382c18723cULL, 0x004fec0000001818ULL, 0x0000003a2c14723cULL, 0x000fe20000001814ULL,
0x000000003d38783bULL, 0x000eaa0000004200ULL, 0x000000382c10723cULL, 0x004fec0000001810ULL,
0x0000003a2c2c723cULL, 0x000fe20000001830ULL, 0x0000001442387c11ULL, 0x000fcc000f8e20ffULL,
0x0000000672307811ULL, 0x002fe200078fe0ffULL, 0x000000003838783bULL, 0x000fe60000004200ULL,
0x0000000730307812ULL, 0x000fca00078e7845ULL, 0x0000000845457824ULL, 0x000fca00078e0230ULL,
0x0000001c455f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000008061c7291ULL, 0x000fc8000f8e203fULL,
0x011000005f30783bULL, 0x000e640000000200ULL, 0x0000004631319232ULL, 0x082fe40000000000ULL,
0x0000004633339232ULL, 0x000fe20000000000ULL, 0x0000001441467c11ULL, 0x000fe2000f8e20ffULL,
0x0000004730309232ULL, 0x080fe40000000000ULL, 0x0000004732329232ULL, 0x000fe40000000000ULL,
0x00000000463c783bULL, 0x000e6a0000004200ULL, 0x000000383028723cULL, 0x000fec0000001828ULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0x0000001440397c11ULL, 0x000fcc000f8e20ffULL,
0x000000003938783bULL, 0x000ea20000004200ULL, 0x0000003c3020723cULL, 0x002fec0000001820ULL,
0x0000003e301c723cULL, 0x000fe2000000181cULL, 0x00000014483c7c11ULL, 0x000fe2000f8e20ffULL,
0xffffffff00147882ULL, 0x000fe20000000000ULL, 0x0000001500148c82ULL, 0x000fc80008000000ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x0236106cffff79a7ULL, 0x0007e2000850001cULL,
0x000000383018723cULL, 0x004fec0000001818ULL, 0x0000003a3014723cULL, 0x000fec0000001814ULL,
0x0000003c3010723cULL, 0x002fec0000001810ULL, 0x0000003e3030723cULL, 0x000fee000000182cULL,
0x000000064a2c7c11ULL, 0x000fc8000f8e10ffULL, 0x000000802c2c7811ULL, 0x000fc800078e30ffULL,
0x000000162c007c0cULL, 0x000fda000bf06070ULL, 0x00000018004c0947ULL, 0x008fea0003800000ULL,
0x000000124a2c7c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x000000012c2d7836ULL, 0x000fca0000000000ULL, 0x000000072d007c0cULL, 0x000fda000bf06070ULL,
0x0000000400b48947ULL, 0x000fea0003800000ULL, 0x000000172c2c7c11ULL, 0x000fe2000f8e40ffULL,
0x0000000d0c157899ULL, 0x000fe4000800063fULL, 0x000000141a1472a4ULL, 0x000fe2000f8e0209ULL,
0x000000162c2e7c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0a2cULL,
0x0000200015157892ULL, 0x000fc6000f8ec03fULL, 0x000000145d5d7c12ULL, 0x000fe2000f8efcffULL,
0x0000000d15157290ULL, 0x000fe2000fffe00eULL, 0x000000402e2e7446ULL, 0x000fe4000380002dULL,
0x000000145c2d7c12ULL, 0x000fe2000f8efcffULL, 0x0001300015157890ULL, 0x000fe2000fffe03fULL,
0x0000002e0200720cULL, 0x080fe40003f46070ULL, 0x0000002e0300720cULL, 0x000fe20003f26070ULL,
0x000001005d027825ULL, 0x000fe200078e000eULL, 0x00000014655d7c12ULL, 0x000fc4000f8efcffULL,
0x0000002e0500720cULL, 0x080fe20003f86070ULL, 0x000001002d2c7825ULL, 0x000fe200078e000eULL,
0x000000145a477c12ULL, 0x000fe4000f8efcffULL, 0x0000001564057c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c027825ULL, 0x000fe200078e0002ULL, 0x00000014583f7c12ULL, 0x000fe4000f8efcffULL,
0x0000002e0400720cULL, 0x080fe20003f06070ULL, 0x000000100c2c7825ULL, 0x000fe200078e002cULL,
0x00000015662f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x000fe2000d101c50ULL, 0x0000002e0700720cULL, 0x000fe20003fa6070ULL,
0x000001005d5c7825ULL, 0x100fe200078e000eULL, 0x00000014563d7c12ULL, 0x000fe2000f8efcffULL,
0x000000002c2f7faeULL, 0x0003e2000c901c50ULL, 0x00000014543b7c12ULL, 0x000fe2000f8efcffULL,
0x0000010047467825ULL, 0x000fe200078e000eULL, 0x0000001450077c12ULL, 0x000fc4000f8efcffULL,
0x0000002e0600720cULL, 0x080fe20003fc6070ULL, 0x000001003f3e7825ULL, 0x100fe200078e000eULL,
0x0000001452397c12ULL, 0x000fe4000f8efcffULL, 0x0000001463637c12ULL, 0x000fe2000f8efcffULL,
0x000001003d3c7825ULL, 0x100fe200078e000eULL, 0x0000002e0800720cULL, 0x080fe40003f66070ULL,
0x0000002e0900720cULL, 0x080fe20003f46070ULL, 0x000001003b3a7825ULL, 0x000fe200078e000eULL,
0x0000002e0a00720cULL, 0x000fc40003f26070ULL, 0x0000001559597c11ULL, 0x000fe2000f8e20ffULL,
0x00000100072c7825ULL, 0x102fe200078e000eULL, 0x0000001557577c11ULL, 0x000fe4000f8e20ffULL,
0x000000144e097c12ULL, 0x000fe2000f8efcffULL, 0x0000010039387825ULL, 0x100fe200078e000eULL,
0x0000001555557c11ULL, 0x000fe4000f8e20ffULL, 0x000000144c057c12ULL, 0x000fe2000f8efcffULL,
0x0000010063067825ULL, 0x000fe200078e000eULL, 0x000000155b637c11ULL, 0x000fc4000f8e20ffULL,
0x0000001553537c11ULL, 0x000fe2000f8e20ffULL, 0x000000100c5c7825ULL, 0x000fe200078e005cULL,
0x0000001551517c11ULL, 0x000fe4000f8e20ffULL, 0x0000001462037c12ULL, 0x000fe2000f8efcffULL,
0x000000100c467825ULL, 0x000fe200078e0046ULL, 0x000000005c637faeULL, 0x0003e2000c101c50ULL,
0x0000002e4400720cULL, 0x000fe40003f06070ULL, 0x000000100c3e7825ULL, 0x000fe200078e003eULL,
0x0000000046597faeULL, 0x0003e2000e101c50ULL, 0x000000154f4f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000100c3c7825ULL, 0x040fe200078e003cULL, 0x00000014615f7c12ULL, 0x000fe2000f8efcffULL,
0x000000003e577faeULL, 0x0003e2000f101c50ULL, 0x0000002e3700720cULL, 0x080fe20003f86070ULL,
0x000000100c3a7825ULL, 0x000fe200078e003aULL, 0x0000001460617c12ULL, 0x000fe2000f8efcffULL,
0x000000003c557faeULL, 0x0003e2000e901c50ULL, 0x0000002e3600720cULL, 0x080fe20003fc6070ULL,
0x000000100c387825ULL, 0x000fe200078e0038ULL, 0x000000145e2f7c12ULL, 0x000fe2000f8efcffULL,
0x000000003a537faeULL, 0x0003e2000d901c50ULL, 0x0000002e3500720cULL, 0x080fe20003fa6070ULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x0000002e3400720cULL, 0x080fe20003f66070ULL,
0x0000000038517faeULL, 0x0003e2000d101c50ULL, 0x0000002e0b00720cULL, 0x080fe20003f46070ULL,
0x0000010009087825ULL, 0x100fe200078e000eULL, 0x000000154d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c4f7faeULL, 0x0003e2000c901c50ULL, 0x0000002e0d00720cULL, 0x000fe20003f26070ULL,
0x0000010005047825ULL, 0x000fe200078e000eULL, 0x000000154b4b7c11ULL, 0x000fc4000f8e20ffULL,
0x000000156b6b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010003027825ULL, 0x100fe200078e000eULL,
0x000000156a0b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001569697c11ULL, 0x000fe2000f8e20ffULL,
0x000001005f5e7825ULL, 0x100fe200078e000eULL, 0x00000015680d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001567677c11ULL, 0x000fe2000f8e20ffULL, 0x00000100615a7825ULL, 0x000fc800078e000eULL,
0x000001002f0e7825ULL, 0x000fc800078e000eULL, 0x000000100c087825ULL, 0x000fc800078e0008ULL,
0x000000100c047825ULL, 0x040fe200078e0004ULL, 0x00000000084d7faeULL, 0x0003e6000c101c50ULL,
0x000000100c067825ULL, 0x040fe200078e0006ULL, 0x00000000044b7faeULL, 0x0003e6000e101c50ULL,
0x000000100c027825ULL, 0x040fe200078e0002ULL, 0x00000000066b7faeULL, 0x0003e6000f101c50ULL,
0x000000100c5e7825ULL, 0x040fe200078e005eULL, 0x00000000020b7faeULL, 0x0003e6000e901c50ULL,
0x000000100c5a7825ULL, 0x040fe200078e005aULL, 0x000000005e697faeULL, 0x0003e6000d901c50ULL,
0x000000100c0e7825ULL, 0x000fe200078e000eULL, 0x000000005a0d7faeULL, 0x0003e8000d101c50ULL,
0x000000000e677faeULL, 0x0003e2000c901c50ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x000000141a1a72a4ULL, 0x000fe4000f8e0209ULL, 0x0000000d0c147899ULL, 0x000fc8000800063fULL,
0x0000200014147892ULL, 0x000fe2000f8ec03fULL, 0x0000001a5d5d7c12ULL, 0x000fe4000f8efcffULL,
0x0000001a5c037c12ULL, 0x000fe2000f8efcffULL, 0x0000000d14147290ULL, 0x000fe2000fffe00eULL,
0x0000001a65377c12ULL, 0x000fe2000f8efcffULL, 0x000001005d5c7825ULL, 0x100fe200078e000eULL,
0x0000001a5a3f7c12ULL, 0x000fe2000f8efcffULL, 0x0001300014147890ULL, 0x000fe2000fffe03fULL,
0x0000001a583d7c12ULL, 0x000fe2000f8efcffULL, 0x0000010003027825ULL, 0x000fe200078e000eULL,
0x0000001a563b7c12ULL, 0x000fc4000f8efcffULL, 0x0000001a54397c12ULL, 0x000fe2000f8efcffULL,
0x0000010037367825ULL, 0x100fe200078e000eULL, 0x0000001a52097c12ULL, 0x000fe4000f8efcffULL,
0x0000001a50357c12ULL, 0x000fe2000f8efcffULL, 0x000001003f3e7825ULL, 0x100fe200078e000eULL,
0x0000001a4e2f7c12ULL, 0x000fe4000f8efcffULL, 0x0000001a4c2d7c12ULL, 0x000fe2000f8efcffULL,
0x000001003d3c7825ULL, 0x000fe200078e000eULL, 0x0000001a630b7c12ULL, 0x000fc4000f8efcffULL,
0x0000001a62477c12ULL, 0x000fe2000f8efcffULL, 0x000001003b3a7825ULL, 0x100fe200078e000eULL,
0x0000001a61077c12ULL, 0x000fe4000f8efcffULL, 0x0000001a60057c12ULL, 0x000fe2000f8efcffULL,
0x0000010039387825ULL, 0x100fe200078e000eULL, 0x0000001a5e0d7c12ULL, 0x000fe4000f8efcffULL,
0x00000014665f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010009087825ULL, 0x000fe200078e000eULL,
0x000000145b5b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001459597c11ULL, 0x000fe2000f8e20ffULL,
0x0000010035347825ULL, 0x100fe200078e000eULL, 0x0000001457577c11ULL, 0x000fe4000f8e20ffULL,
0x0000001455557c11ULL, 0x000fe2000f8e20ffULL, 0x000001002f2e7825ULL, 0x100fe200078e000eULL,
0x0000001453537c11ULL, 0x000fe4000f8e20ffULL, 0x0000001451517c11ULL, 0x000fe2000f8e20ffULL,
0x000001002d2c7825ULL, 0x000fe200078e000eULL, 0x000000144f4f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000144d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x000001000b0a7825ULL, 0x100fe200078e000eULL,
0x000000144b4b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000146b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010047467825ULL, 0x100fe200078e000eULL, 0x0000001469697c11ULL, 0x000fe4000f8e20ffULL,
0x0000001467677c11ULL, 0x000fe2000f8e20ffULL, 0x0000010007067825ULL, 0x000fc800078e000eULL,
0x0000010005047825ULL, 0x000fc800078e000eULL, 0x000001000d0e7825ULL, 0x000fe200078e000eULL,
0x00000014640d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100c5c7825ULL, 0x000fc800078e005cULL,
0x000000100c027825ULL, 0x040fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005c0d7faeULL, 0x0003e6000b901c50ULL, 0x000000100c367825ULL, 0x040fe200078e0036ULL,
0x00000000025f7faeULL, 0x0005e6000b901c50ULL, 0x000000100c3e7825ULL, 0x040fe200078e003eULL,
0x00000000365b7faeULL, 0x0007e6000b901c50ULL, 0x000000100c3c7825ULL, 0x000fe200078e003cULL,
0x000000003e597faeULL, 0x0007e2000b901c50ULL, 0x00000014680d7c11ULL, 0x002fc4000f8e20ffULL,
0x000000100c3a7825ULL, 0x000fe200078e003aULL, 0x000000003c577faeULL, 0x0007e2000b901c50ULL,
0x000000146a037c11ULL, 0x004fe4000f8e20ffULL, 0x000000100c387825ULL, 0x040fe200078e0038ULL,
0x000000003a557faeULL, 0x0007e6000b901c50ULL, 0x000000100c087825ULL, 0x040fe200078e0008ULL,
0x0000000038537faeULL, 0x0007e6000b901c50ULL, 0x000000100c347825ULL, 0x040fe200078e0034ULL,
0x0000000008517faeULL, 0x0007e6000b901c50ULL, 0x000000100c2e7825ULL, 0x040fe200078e002eULL,
0x00000000344f7faeULL, 0x0007e6000b901c50ULL, 0x000000100c2c7825ULL, 0x040fe200078e002cULL,
0x000000002e4d7faeULL, 0x0007e6000b901c50ULL, 0x000000100c0a7825ULL, 0x040fe200078e000aULL,
0x000000002c4b7faeULL, 0x0007e6000b901c50ULL, 0x000000100c467825ULL, 0x040fe200078e0046ULL,
0x000000000a6b7faeULL, 0x0007e6000b901c50ULL, 0x000000100c067825ULL, 0x040fe200078e0006ULL,
0x0000000046037faeULL, 0x0007e6000b901c50ULL, 0x000000100c047825ULL, 0x040fe200078e0004ULL,
0x0000000006697faeULL, 0x0007e6000b901c50ULL, 0x000000100c0e7825ULL, 0x000fe200078e000eULL,
0x00000000040d7faeULL, 0x0007e8000b901c50ULL, 0x000000000e677faeULL, 0x0007e4000b901c50ULL,
0x000000030a0d7892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001072067824ULL, 0x00afe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe20000011672ULL,
0x000000020d0d7890ULL, 0x000fe4000fffe03fULL, 0x000000081b0e7291ULL, 0x000fe2000f8e383fULL,
0x0000000c04047812ULL, 0x000fe200078ec0ffULL, 0x000000030d00788cULL, 0x000fe2000bf04070ULL,
0x0000007006067812ULL, 0x000fc600078ec0ffULL, 0x00000002190d7887ULL, 0x000fc80008000000ULL,
0x0000000d0a0a7290ULL, 0x000fc8000fffe03fULL, 0x000000050a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fca0003f0f018ULL, 0x0000000a0b0d9290ULL, 0x000fe2000fffe03fULL,
0x00008c0000149ab9ULL, 0x000fc60000000a00ULL, 0x000000040d1498a5ULL, 0x000fe4000f8e0014ULL,
0x0000001f180d7899ULL, 0x000fc8000800063fULL, 0x00000014ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000015ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff057e24ULL, 0x000fc6000f8e00ffULL,
0x0000001002028981ULL, 0x000362000c1e1900ULL, 0x02362805ff0075a7ULL, 0x000ea2000802015cULL,
0x0000000e04047c10ULL, 0x000fe2000fffe006ULL, 0x000000a800bc9947ULL, 0x006fec0003800000ULL,
0x0230000004057984ULL, 0x000e620000000800ULL, 0x000000081b0d7291ULL, 0x000fe2000f8e583fULL,
0x00000001ff087424ULL, 0x000fe200078e00ffULL, 0x0000001d04047291ULL, 0x000fe2000f8e683fULL,
0x00000000000b7919ULL, 0x000ea60000000000ULL, 0x0001300004047890ULL, 0x000fe2000fffe03fULL,
0x0000000d78787c11ULL, 0x000fe4000f8e20ffULL, 0x00000002ff0a7819ULL, 0x004fc4000001160bULL,
0x000000000500720bULL, 0x002fc60003f3d000ULL, 0x000000080a3d7836ULL, 0x000fd40000000000ULL,
0x0000000000037806ULL, 0x000fc800008e0100ULL, 0x0000ffff03077812ULL, 0x000fe4000782c0ffULL,
0x0232000004037984ULL, 0x0002b60000000800ULL, 0x0000000000e89947ULL, 0x002fea0003800000ULL,
0x000000000500720bULL, 0x000fe20003f34000ULL, 0x0000000f1b00728cULL, 0x000fe2000bf05270ULL,
0x0000000500047209ULL, 0x040fe40007810000ULL, 0x00000001ff097819ULL, 0x000fe2000001160bULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x8000000400067221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fe40003f4f008ULL, 0x0000000c09097812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b06067820ULL, 0x000fe20000410000ULL, 0x000000080f0e8291ULL, 0x000fe2000f8e383fULL,
0x0000000000007806ULL, 0x000fc400008e0100ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff00087812ULL, 0x000fe200078e3cffULL, 0x0000000600067308ULL, 0x000e660000000800ULL,
0x0000000807ff7212ULL, 0x000fe4000782c0ffULL, 0x0000000e0909ac10ULL, 0x000fe4000fffe00bULL,
0x00000001ff087807ULL, 0x000fc60000800000ULL, 0x023400040900a388ULL, 0x000fe80000000800ULL,
0x00001f0a06007589ULL, 0x002e6400000e0000ULL, 0x8000000405071221ULL, 0x000fe20000010000ULL,
0x0000000649497220ULL, 0x000fe20000410000ULL, 0x00001f3d06057589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b07071820ULL, 0x000fc80000410000ULL, 0x00000007006e1308ULL, 0x000f220000000800ULL,
0x0000000028287220ULL, 0x082fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x000fe20000410000ULL,
0x000000052a2a7220ULL, 0x088fe20000410000ULL, 0x000000052b2b7220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x080fe20000410000ULL, 0x0000000527277220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x0000000523237220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x000000051f1f7220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x000000051b1b7220ULL, 0x080fe20000410000ULL,
0x0000000516167220ULL, 0x080fe20000410000ULL, 0x0000000517177220ULL, 0x080fe20000410000ULL,
0x0000000512127220ULL, 0x080fe20000410000ULL, 0x0000000513137220ULL, 0x080fe20000410000ULL,
0x0000000532327220ULL, 0x080fe20000410000ULL, 0x0000000533337220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e0004ULL, 0x000000036e031220ULL, 0x014fce0000410000ULL,
0x0000000001357983ULL, 0x000ee20000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x011000007804783bULL, 0x000fe20000000200ULL, 0x00000004772c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000004903497221ULL, 0x004fe20000010000ULL, 0x0000006eff09723eULL, 0x000fe200000000ffULL,
0xffffffff00147882ULL, 0x000fe20000000000ULL, 0x000000047b0c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x00005410093c7816ULL, 0x000fe40000000009ULL,
0x000000047c097c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c0c783bULL, 0x000fe20000004200ULL,
0x0000991008347816ULL, 0x000fc400000000ffULL, 0x000000047a4c7c11ULL, 0x000fe2000f8e20ffULL,
0x00001f0a3c467589ULL, 0x000e6200000e0000ULL, 0x000000ff3400720cULL, 0x000fe40003f25270ULL,
0x0000000d76347c11ULL, 0x000fe2000f8e20ffULL, 0x00001f3d3c447589ULL, 0x00052200000e0000ULL,
0x0000000474747c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d79797c11ULL, 0x000fe2000f8e20ffULL,
0x000000000908783bULL, 0x000f220000004200ULL, 0x0000000470707c11ULL, 0x000fc6000f8e20ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x00000004753c7c11ULL, 0x004fcc000f8e20ffULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000004604049232ULL, 0x082fe40000000000ULL,
0x0000004606069232ULL, 0x000fe40000000000ULL, 0x0000004405059232ULL, 0x090fe40000000000ULL,
0x0000004407079232ULL, 0x000fce0000000000ULL, 0x0000002c0428723cULL, 0x000fec0000001828ULL,
0x0000002e042c723cULL, 0x000fe20000001824ULL, 0x000000007424783bULL, 0x000fea0000004200ULL,
0x000000080420723cULL, 0x000fec0000001820ULL, 0x0000000a0408723cULL, 0x000fec000000181cULL,
0x0000000c0418723cULL, 0x000fe20000001818ULL, 0x00000004731c7c11ULL, 0x000fca000f8e20ffULL,
0x0000000e040c723cULL, 0x000fe20000001814ULL, 0x000000001c1c783bULL, 0x000fec0000004200ULL,
0x000000047d147c11ULL, 0x000fcc000f8e20ffULL, 0x000000001414783bULL, 0x000fe20000004200ULL,
0x0000000435387c11ULL, 0x008fc6000f8e20ffULL, 0x011000003434783bULL, 0x000e680000000200ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x0000004634349232ULL, 0x082fe40000000000ULL,
0x0000004636369232ULL, 0x000fe40000000000ULL, 0x0000004435359232ULL, 0x080fe20000000000ULL,
0x000000380410723cULL, 0x004fe20000001810ULL, 0x0000004437379232ULL, 0x000fca0000000000ULL,
0x0000003a0404723cULL, 0x000fe20000001830ULL, 0x0000000471387c11ULL, 0x000fca000f8e20ffULL,
0x0000003c3420723cULL, 0x000fe20000001820ULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x0000000d45307c11ULL, 0x000fe4000f8e20ffULL, 0x00000000020d82caULL, 0x020fe400000e0000ULL,
0x0000003e343c723cULL, 0x000fe20000001808ULL, 0x011000007908783bULL, 0x000e680000000200ULL,
0x011000003030783bULL, 0x000ea20000000200ULL, 0x0000004c3428723cULL, 0x000fea0000001828ULL,
0x0000000d00149c82ULL, 0x000fe20008000000ULL, 0x000000243418723cULL, 0x000fe20000001818ULL,
0x00000004434c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010c047892ULL, 0x000fc8000f8e0c3fULL,
0x000000263424723cULL, 0x000fe2000000180cULL, 0x00000000700c783bULL, 0x000ee20000004200ULL,
0x0000001d04047291ULL, 0x000fc8000f8e683fULL, 0x0000004e342c723cULL, 0x000fe2000000182cULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x0001300004047890ULL, 0x000fc8000fffe03fULL,
0x000000143410723cULL, 0x000fe40000001810ULL, 0x0000000442507c11ULL, 0x000fe4000f8e20ffULL,
0x0000000441417c11ULL, 0x000fe4000f8e20ffULL, 0x000000163434723cULL, 0x000fe20000001804ULL,
0x0000000440147c11ULL, 0x000fe2000f8e20ffULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000004608089232ULL, 0x002fc60000000000ULL, 0x000000004140783bULL, 0x000fe20000004200ULL,
0x0000000448047c11ULL, 0x000fe2000f8e20ffULL, 0x000000460a0a9232ULL, 0x000fe20000000000ULL,
0x000000010c047892ULL, 0x000fe2000f8ec03fULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x0000004409099232ULL, 0x080fe40000000000ULL, 0x000000440b0b9232ULL, 0x000fe20000000000ULL,
0x000000000404783bULL, 0x000f620000004200ULL, 0x0000004630309232ULL, 0x084fe20000000000ULL,
0x0236306cffff79a7ULL, 0x0005e2000850001cULL, 0x0000004632329232ULL, 0x000fc40000000000ULL,
0x0000004431319232ULL, 0x080fe20000000000ULL, 0x0000001c0828723cULL, 0x000fe20000001828ULL,
0x0000004433339232ULL, 0x000fca0000000000ULL, 0x0000000c0818723cULL, 0x008fec0000001818ULL,
0x0000001e082c723cULL, 0x000fec000000182cULL, 0x000000380820723cULL, 0x000fec0000001820ULL,
0x0000003a083c723cULL, 0x000fec000000183cULL, 0x0000000e080c723cULL, 0x000fec0000001824ULL,
0x0000004c0810723cULL, 0x010fec0000001810ULL, 0x0000004e0834723cULL, 0x000fec0000001834ULL,
0x000000143018723cULL, 0x002fec0000001818ULL, 0x000000503028723cULL, 0x000fec0000001828ULL,
0x000000523024723cULL, 0x000fec000000182cULL, 0x000000403020723cULL, 0x000fec0000001820ULL,
0x00000042301c723cULL, 0x000fec000000183cULL, 0x000000163014723cULL, 0x000fec000000180cULL,
0x000000043010723cULL, 0x020fec0000001810ULL, 0x000000063030723cULL, 0x004fde0000001834ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000040001027983ULL, 0x002ea20000300800ULL,
0x000000124a4a7c36ULL, 0x000fca0008000000ULL, 0x000000074a007c0cULL, 0x000fe4000bf26070ULL,
0x000000ff02ff7812ULL, 0x004fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fca0000000000ULL,
0x0000040201007387ULL, 0x0003e40000100600ULL, 0xffffffbc00909947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0002300008047890ULL, 0x000fe2000fffe03fULL,
0x00000000000e79c3ULL, 0x000ea20000002500ULL, 0x0000000106057899ULL, 0x000fce000800063fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000040f097291ULL, 0x000fe4000f8e383fULL,
0x0000000205057892ULL, 0x000fc8000f8e0c3fULL, 0x0000000105057892ULL, 0x000fc8000f8ef80fULL,
0x0000000405057291ULL, 0x000fcc000f8e383fULL, 0x00000005ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x000000070e00728cULL, 0x004fe2000bf06070ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x100fe40000011602ULL, 0x00000002ff077819ULL, 0x000fe40000011602ULL,
0x0000007003087812ULL, 0x000fe200078ec0ffULL, 0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c04097812ULL, 0x000fe400078ec0ffULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x0000020008047810ULL, 0x000fe40007ffe003ULL, 0x0000000909037c10ULL, 0x140fe4000fffe008ULL,
0x0000000509057c10ULL, 0x040fe2000fffe008ULL, 0x0000000109047824ULL, 0x000fe400078e0204ULL,
0x0000000003007388ULL, 0x0003e80000000800ULL, 0x0000004904007388ULL, 0x000fe20000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000802037811ULL, 0x002fca00078ff0ffULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x00000000050d7209ULL, 0x002fca0007810000ULL,
0x000000000d067221ULL, 0x000fe20000010100ULL, 0x0000020008007810ULL, 0x000fe20007ffe00bULL,
0x8000000d05057221ULL, 0x000fe40000010000ULL, 0x3fb8aa3b06067820ULL, 0x000fe40000410000ULL,
0x0000000109007824ULL, 0x000fe400078e0200ULL, 0x3fb8aa3b05057820ULL, 0x000fe40000410000ULL,
0x0000000600067308ULL, 0x000e640000000800ULL, 0x0000000000007984ULL, 0x000fec0000000800ULL,
0x0000000500057308ULL, 0x000ea20000000800ULL, 0x00001f0706077589ULL, 0x002e6800000e0000ULL,
0x00001f0306037589ULL, 0x000ee200000e0000ULL, 0x0000002807047220ULL, 0x042fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000000500057220ULL, 0x004fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000001807087220ULL, 0x040fe20000410000ULL, 0x0000001907197220ULL, 0x040fe20000410000ULL,
0x0000001407097220ULL, 0x040fe20000410000ULL, 0x00000015070a7220ULL, 0x040fe20000410000ULL,
0x0000001007107220ULL, 0x040fe20000410000ULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x00000030070b7220ULL, 0x040fe20000410000ULL, 0x00000031070c7220ULL, 0x000fe20000410000ULL,
0x0000002a032a7220ULL, 0x048fe20000410000ULL, 0x0000002b032b7220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001703177220ULL, 0x040fe20000410000ULL,
0x0000001203007220ULL, 0x040fe20000410000ULL, 0x00000013030f7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x000fe20000410000ULL,
0x0000004906497223ULL, 0x000fe20000010005ULL, 0x0000000000c80947ULL, 0x000fec0003800000ULL,
0x0180000049027836ULL, 0x000fca0000000000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00006a2000067802ULL, 0x000fce0000000f00ULL, 0x000000a0004c7944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0005ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000004900027308ULL, 0x000e640000001000ULL, 0xbf80000049037423ULL, 0x002fc80000000002ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302037223ULL, 0x000fce0000000002ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x00000002ff0e7819ULL, 0x004fe40000011602ULL,
0x0000000802067811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0e03057589ULL, 0x000ea800000e0000ULL, 0x00001f0603067589ULL, 0x000ee200000e0000ULL,
0x0000000504047220ULL, 0x084fe20000410000ULL, 0x0000000529297220ULL, 0x080fe20000410000ULL,
0x0000000524247220ULL, 0x080fe20000410000ULL, 0x0000000525257220ULL, 0x080fe20000410000ULL,
0x0000000520207220ULL, 0x080fe20000410000ULL, 0x0000000521217220ULL, 0x080fe20000410000ULL,
0x000000051c1c7220ULL, 0x080fe20000410000ULL, 0x000000051d1d7220ULL, 0x080fe20000410000ULL,
0x0000000508087220ULL, 0x080fe20000410000ULL, 0x0000000519197220ULL, 0x080fe20000410000ULL,
0x0000000509097220ULL, 0x080fe20000410000ULL, 0x000000050a0a7220ULL, 0x080fe20000410000ULL,
0x0000000510107220ULL, 0x080fe20000410000ULL, 0x0000000511117220ULL, 0x080fe20000410000ULL,
0x000000050b0b7220ULL, 0x080fe20000410000ULL, 0x000000050c0c7220ULL, 0x000fe20000410000ULL,
0x000000062a2a7220ULL, 0x088fe20000410000ULL, 0x000000062b2b7220ULL, 0x080fe20000410000ULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x0000000627277220ULL, 0x080fe20000410000ULL,
0x0000000622227220ULL, 0x080fe20000410000ULL, 0x0000000623237220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x080fe20000410000ULL,
0x000000061a1a7220ULL, 0x080fe20000410000ULL, 0x000000061b1b7220ULL, 0x080fe20000410000ULL,
0x0000000616167220ULL, 0x080fe20000410000ULL, 0x0000000617177220ULL, 0x080fe20000410000ULL,
0x0000000600007220ULL, 0x080fe20000410000ULL, 0x000000060f0f7220ULL, 0x080fe20000410000ULL,
0x0000000632327220ULL, 0x080fe20000410000ULL, 0x0000000633337220ULL, 0x000fce0000410000ULL,
0x00000003ff037819ULL, 0x000fe20000011602ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0xfffffff8ff067812ULL, 0x000fe200078ee202ULL, 0x0000000813077291ULL, 0x000fe2000f8e603fULL,
0x0000000303057812ULL, 0x000fe200078ec0ffULL, 0x000000011200788cULL, 0x000fe2000bf05270ULL,
0x000000042904723eULL, 0x000fe200000000ffULL, 0x0000000806127836ULL, 0x040fe20000000000ULL,
0x0000000405137812ULL, 0x000fe200078efcffULL, 0x0000000806077824ULL, 0x000fe200078e00ffULL,
0x00000007050e7812ULL, 0x000fe200078e7806ULL, 0x0000000706187291ULL, 0x000fe2000f8e583fULL,
0x0000000705147812ULL, 0x000fe200078e7812ULL, 0x0000000812057824ULL, 0x000fe200078e00ffULL,
0x0000000713067812ULL, 0x000fc400078e7806ULL, 0x0000000713127812ULL, 0x000fe400078e7812ULL,
0x000000070e0e7212ULL, 0x080fe400078efcffULL, 0x0000000706187212ULL, 0x000fe400078efcffULL,
0x0000000514287212ULL, 0x080fe400078efcffULL, 0x00000005122c7212ULL, 0x000fe400078efcffULL,
0x000000242505723eULL, 0x000fc400000000ffULL, 0x000000202106723eULL, 0x000fe400000000ffULL,
0x0000001c1d07723eULL, 0x000fe400000000ffULL, 0x000000090a09723eULL, 0x000fe400000000ffULL,
0x000000180e0e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000081908723eULL, 0x000fe400000000ffULL,
0x00000010110a723eULL, 0x000fe200000000ffULL, 0x000000040e007844ULL, 0x000fe20000000200ULL,
0x0000000b0c0b723eULL, 0x000fc400000000ffULL, 0x0000001818187c11ULL, 0x000fe4000f8e20ffULL,
0x0000002a2b10723eULL, 0x000fe400000000ffULL, 0x000000262711723eULL, 0x000fe200000000ffULL,
0x0000000818007844ULL, 0x000fe20000000200ULL, 0x000000222312723eULL, 0x000fe400000000ffULL,
0x0000001e1f13723eULL, 0x000fe400000000ffULL, 0x000000161715723eULL, 0x000fc400000000ffULL,
0x0000001828287c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a1b14723eULL, 0x000fe400000000ffULL,
0x000000000f16723eULL, 0x000fe200000000ffULL, 0x0000001028007844ULL, 0x000fe20000000200ULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x00000006ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x000000182c2c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000200f0f7824ULL, 0x000fc400078e0202ULL, 0x000000142c007844ULL, 0x000fe60000000200ULL,
0x000000070f007c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000001c7984ULL, 0x000ea80000000c00ULL, 0x0004000000247984ULL, 0x000ee80000000c00ULL,
0x0008000000207984ULL, 0x000f280000000c00ULL, 0x000c000000307984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x004fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000003327277230ULL, 0x020fc40000000000ULL, 0x0000003226267230ULL, 0x000fe20000000000ULL,
0x0000001c00007388ULL, 0x0005e20000000c00ULL, 0x0000003125257230ULL, 0x000fe40000000000ULL,
0x0000003024247230ULL, 0x000fca0000000000ULL, 0x0004002400007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800dc8947ULL, 0x000fea0003800000ULL,
0x0000000000087984ULL, 0x0006e20000000c00ULL, 0x00000000000a79c3ULL, 0x000fe20000002700ULL,
0x00000001063f7892ULL, 0x000fe4000f80f80fULL, 0x0004000000107984ULL, 0x0006620000000c00ULL,
0x0000840000087ab9ULL, 0x000fe20000000800ULL, 0x0000920000097ab9ULL, 0x000fe20000000800ULL,
0x00000008120472a4ULL, 0x000fe2000f8e023fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x00000000000579c3ULL, 0x000f240000002600ULL, 0x00000009040972a4ULL, 0x000fc8000f8e023fULL,
0x01ffffff09197892ULL, 0x000fe4000f8ec03fULL, 0x000000080a0a72a4ULL, 0x010fc8000f8e0205ULL,
0x000000120a0872a4ULL, 0x000fc8000f8e023fULL, 0x0000000e080b7290ULL, 0x000fe2000fffe03fULL,
0x0000000000380947ULL, 0x008ff60003800000ULL, 0x000000190b0c7290ULL, 0x000fe2000fffe03fULL,
0x0000001002007824ULL, 0x004fe200078e00ffULL, 0x0000980000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff047819ULL, 0x000fe20000011602ULL, 0x000000800b1478a5ULL, 0x000fe4000f8e0004ULL,
0x000000800c0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04077812ULL, 0x000fc800078ec0ffULL, 0x0000001407047c10ULL, 0x140fe4000fa3e000ULL,
0x0000000407067c10ULL, 0x000fe4000fc7e000ULL, 0x00000015ff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff077c10ULL, 0x000fc60009fe84ffULL, 0x0000000d04007986ULL, 0x0005e8000c101910ULL,
0x0000004906007986ULL, 0x0005e4000c101910ULL, 0x00000fff09097891ULL, 0x000fe2000f8e403fULL,
0x000000ff0200720cULL, 0x000fe20000705670ULL, 0x0000980000167ab9ULL, 0x000fe20000000a00ULL,
0x000000400f0d7836ULL, 0x004fe20000000000ULL, 0x0000000b09047291ULL, 0x000fe2000f8fa03fULL,
0x0000021000007945ULL, 0x000fe60003800000ULL, 0x00001000040478a5ULL, 0x000fc8000f8e0016ULL,
0x00000800130478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL, 0x000000100f047825ULL, 0x000fc800078e0006ULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x0000000804007986ULL, 0x0005e8000c101d10ULL,
0x0000001006007986ULL, 0x0025e2000c101d10ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000580947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff120b7890ULL, 0x000fe4000fffe03fULL, 0x000000040a0478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000bff077e24ULL, 0x004fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1d0ULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000b04007c0cULL, 0x000fc8000bf05270ULL, 0x00000001ff007807ULL, 0x000fca0000000000ULL,
0x00000000ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000400000a7882ULL, 0x000fc40000000000ULL, 0x00000654040a7896ULL, 0x008fd2000800000aULL,
0x0000000aff007984ULL, 0x002e640008000000ULL, 0x000000ff0000720cULL, 0x002fda0003f05270ULL,
0x0000002400b08947ULL, 0x000fea0003800000ULL, 0x0000000fff007c0cULL, 0x000fda000bf05270ULL,
0x0000000c008c0947ULL, 0x000fea0003800000ULL, 0x00000012ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000000108047890ULL, 0x000fe2000fffe03fULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x004fe20000011602ULL,
0x00000080080c78a5ULL, 0x000fe4000f8e0016ULL, 0x00000080040478a5ULL, 0x000fe2000f8e0016ULL,
0x0000007000037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04087812ULL, 0x000fc800078ec0ffULL,
0x0000000c08047c10ULL, 0x140fe4000f91e003ULL, 0x0000000408067c10ULL, 0x000fe4000fb5e003ULL,
0x0000000dff057c10ULL, 0x000fe400087e24ffULL, 0x00000005ff077c10ULL, 0x000fc600097e64ffULL,
0x0000001004007981ULL, 0x000368000c1e1900ULL, 0x0000001006097981ULL, 0x000362000c1e1900ULL,
0x000000021200788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000000208047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0016ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040b7981ULL, 0x000362000c1e1900ULL,
0x000000041200788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000908947ULL, 0x002fea0003800000ULL, 0x0000000308047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0016ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040d7981ULL, 0x000362000c1e1900ULL,
0x000000041200788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000708947ULL, 0x002fea0003800000ULL, 0x0000000408047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0016ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040f7981ULL, 0x000362000c1e1900ULL,
0x000000061200788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x002fea0003800000ULL, 0x0000000508047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0016ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004117981ULL, 0x000362000c1e1900ULL,
0x000000061200788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x002fea0003800000ULL, 0x000000081200788cULL, 0x000fe4000bf06070ULL,
0x0000000608047890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f8f008ULL,
0x00000080040478a5ULL, 0x000fc8000f8e0016ULL, 0x00000007080c0890ULL, 0x000fe4000fffe03fULL,
0x0000000408047c10ULL, 0x000fe4000f91e003ULL, 0x000000800c0c08a5ULL, 0x000fe4000f8e0016ULL,
0x00000005ff057c10ULL, 0x000fc800087e24ffULL, 0x0000000c08064c10ULL, 0x000fe2000fb5e003ULL,
0x0000001004137981ULL, 0x000366000c1e1900ULL, 0x0000000dff074c10ULL, 0x000fca00097e64ffULL,
0x0000001006154981ULL, 0x000368000c1e1900ULL, 0x00000007120b7890ULL, 0x000fc8000fffe03fULL,
0x000000033f0b7899ULL, 0x000fcc000801160bULL, 0x0000000bff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x020fe200078e0000ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00000008000c7c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x00009800001a7ab9ULL, 0x000fca0000000a00ULL,
0x000000120400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000b0500728cULL, 0x000fd8000bf06070ULL,
0x0000000800300947ULL, 0x022fea0003800000ULL, 0x00000008040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000300007209ULL, 0x000fe20007810000ULL, 0x0000000104147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000080c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x006fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000001404047c10ULL, 0x000fc8000f91e003ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004037981ULL, 0x000368000c1e1900ULL,
0x0000000400e82947ULL, 0x000fea0003800000ULL, 0x00000009040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000900007209ULL, 0x000fe20007810000ULL, 0x0000000204147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000090c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004097981ULL, 0x000368000c1e1900ULL,
0x0000000400a02947ULL, 0x000fea0003800000ULL, 0x0000000a040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000b00007209ULL, 0x000fe20007810000ULL, 0x0000000304147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000a0c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040b7981ULL, 0x000368000c1e1900ULL,
0x0000000400582947ULL, 0x000fea0003800000ULL, 0x0000000b040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000d00007209ULL, 0x000fe20007810000ULL, 0x0000000404147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000b0c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040d7981ULL, 0x000368000c1e1900ULL,
0x0000000400102947ULL, 0x000fea0003800000ULL, 0x0000000c040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000f00007209ULL, 0x000fe20007810000ULL, 0x0000000504147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000c0c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040f7981ULL, 0x000368000c1e1900ULL,
0x0000000000c82947ULL, 0x000fea0003800000ULL, 0x0000000d040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001100007209ULL, 0x000fe20007810000ULL, 0x0000000604147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000d0c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004117981ULL, 0x000368000c1e1900ULL,
0x0000000000802947ULL, 0x000fea0003800000ULL, 0x0000000e040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001300007209ULL, 0x000fe20007810000ULL, 0x0000000704147890ULL, 0x000fe4000fffe03fULL,
0x000000120d00728cULL, 0x000fe4000bf26070ULL, 0x000000121400728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000e0c147890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x00000080141478a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001405047c10ULL, 0x000fc8000f91e004ULL,
0x00000015ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004137981ULL, 0x000368000c1e1900ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x0000000f040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001500007209ULL, 0x000fc60007810000ULL, 0x000000120d00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000f0c147890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x00000080141478a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000001405047c10ULL, 0x000fc8000f91e004ULL, 0x00000015ff057c10ULL, 0x000fca00087e24ffULL,
0x0000001004157981ULL, 0x000368000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x000000080c0c7890ULL, 0x000fd4000fffe03fULL,
0xfffffff400ac8947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x0000001002037824ULL, 0x028fe200078e00ffULL, 0x00000001ff047819ULL, 0x006fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000a04037c10ULL, 0x000fca000fffe003ULL, 0x0000000003007388ULL, 0x0003e40000000800ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000000806147290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000023f047899ULL, 0x000fe2000801160fULL,
0x0000001002007824ULL, 0x042fe200078e00ffULL, 0x0000000a060b7291ULL, 0x000fe2000f8e683fULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0x000000090f0d7899ULL, 0x000fe2000800063fULL,
0x0000002002077836ULL, 0x004fe20000000000ULL, 0x00000014090c7291ULL, 0x000fe2000f8fa03fULL,
0x0000007000007812ULL, 0x000fe200078ec0ffULL, 0x0000000104057892ULL, 0x000fe2000f8ec03fULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x00009800001a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000b13047291ULL, 0x000fe2000f8e603fULL, 0x0000004002097836ULL, 0x040fe20000000000ULL,
0x000008000d0b7892ULL, 0x000fe2000f8ec03fULL, 0x00000060020b7836ULL, 0x040fe20000000000ULL,
0x000010000c0c78a5ULL, 0x000fe2000f8e001aULL, 0x0000000a03147c10ULL, 0x000fe2000fffe000ULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000800130c78a5ULL, 0x000fe2000f8e000cULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000b040b7290ULL, 0x000fe2000fffe03fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000014191c8290ULL, 0x000fe2000fffe03fULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x0000000a061d8291ULL, 0x000fe2000f8e483fULL, 0x0000000cff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a061e8291ULL, 0x000fe2000f8e483fULL, 0x0000000dff057e24ULL, 0x000fe2000f8e00ffULL,
0x000000801c0c88a5ULL, 0x000fe2000f8e001aULL, 0x0000000b02117c11ULL, 0x000fe2000f8e20ffULL,
0x0000001d131d8291ULL, 0x000fe2000f8e403fULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x00000080141488a5ULL, 0x000fe2000f8e001aULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000001e131e8291ULL, 0x000fe2000f8e403fULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x0000001d051d8291ULL, 0x000fe2000f8e383fULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000001e051e8291ULL, 0x000fe2000f8e383fULL, 0x000000100b0a7825ULL, 0x000fe200078e0004ULL,
0x000000120600728cULL, 0x000fe2000bf06070ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x0000001d02138c11ULL, 0x040fe2000f8e20ffULL, 0x0000001002047825ULL, 0x040fe200078e0004ULL,
0x0000001e02218c11ULL, 0x040fe4000f8e20ffULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000cff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x000fe2000b901c50ULL,
0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000014ff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x0038000006117faeULL, 0x000fe2000b901c50ULL,
0x00000015ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000010020c8825ULL, 0x000fe200078e000cULL, 0x0058000008117faeULL, 0x000fe2000b901c50ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000010020e8825ULL, 0x000fe200078e000eULL, 0x007800000a117faeULL, 0x000fe2000b901c50ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x045800000c138faeULL, 0x000fe2000b901c50ULL,
0x0000000000347805ULL, 0x000fc6000001ff00ULL, 0x041800000e218faeULL, 0x0005e2000b901c50ULL,
0x000000000000781cULL, 0x000fc60003f0f008ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000207805ULL, 0x004fd2000001ff00ULL, 0x0000000800b00947ULL, 0x002fea0003800000ULL,
0x00000003ff047819ULL, 0x100fe20000011602ULL, 0x0000000a06057291ULL, 0x000fe2000f8e483fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee202ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000000513057291ULL, 0x000fe2000f8e403fULL,
0x00000002ff397819ULL, 0x000fe20000011602ULL, 0x0000000805097836ULL, 0x040fe20000000000ULL,
0x0000000404067812ULL, 0x000fe200078efcffULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000704077812ULL, 0x000fe200078e7805ULL, 0x00000008393c7836ULL, 0x000fe20000000000ULL,
0x0000000706057812ULL, 0x000fe200078e7805ULL, 0x00000005ff377e24ULL, 0x000fe2000f8e00ffULL,
0x00000007043a7812ULL, 0x000fe200078e7809ULL, 0x0000000600057c82ULL, 0x000fe20008000000ULL,
0x0000000706067812ULL, 0x000fe200078e7809ULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x0000003807367212ULL, 0x080fe200078efcffULL, 0x00009800001e7ab9ULL, 0x000fe20000000a00ULL,
0x0000003805387212ULL, 0x000fc400078efcffULL, 0x000000093a3a7212ULL, 0x080fe400078efcffULL,
0x00000009063b7212ULL, 0x000fce00078efcffULL, 0x00000002050b7890ULL, 0x000fc8000fffe03fULL,
0x000000120b00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x0000000b081a7290ULL, 0x000fe2000fffe03fULL, 0x0000002002077836ULL, 0x040fe20000000000ULL,
0x000000013f0c7899ULL, 0x000fe2000801160bULL, 0x0000004002097836ULL, 0x040fe20000000000ULL,
0x0000000a0b147899ULL, 0x000fe2000800063fULL, 0x00000060023d7836ULL, 0x000fe20000000000ULL,
0x0000001a090d7291ULL, 0x000fe4000f8fa03fULL, 0x000000010c1d7892ULL, 0x000fe4000f8ec03fULL,
0x0000080014147892ULL, 0x000fc4000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x000010000d0c78a5ULL, 0x000fe2000f8e001eULL, 0x0000001dff107e24ULL, 0x000fe2000f8e00ffULL,
0x00000014041c7290ULL, 0x000fe4000fffe03fULL, 0x0000000a06208291ULL, 0x000fe4000f8e483fULL,
0x0000000a06218291ULL, 0x000fe4000f8e483fULL, 0x0000002013208291ULL, 0x000fe2000f8e403fULL,
0x0000001c02117c11ULL, 0x000fe2000f8e20ffULL, 0x00000800130c78a5ULL, 0x000fc4000f8e000cULL,
0x0000001a19148290ULL, 0x000fe4000fffe03fULL, 0x0000002113218291ULL, 0x000fe2000f8e403fULL,
0x00000020ff378e24ULL, 0x000fe2000f8e00ffULL, 0x00000080141488a5ULL, 0x000fe2000f8e001eULL,
0x0000000cff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x000000801a1a88a5ULL, 0x000fe2000f8e001eULL,
0x0000000dff0b7e24ULL, 0x000fe4000f8e00ffULL, 0x0000008010138824ULL, 0x000fe400078e0237ULL,
0x00000021ff378e24ULL, 0x000fc4000f8e00ffULL, 0x0000001007067825ULL, 0x000fc800078e000aULL,
0x0000001002047825ULL, 0x000fc800078e000aULL, 0x0000001009087825ULL, 0x100fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x0003e6000b901c50ULL,
0x00000014ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x0038000006117faeULL, 0x0003e2000b901c50ULL,
0x00000015ff0d7e24ULL, 0x000fe4000f8e00ffULL, 0x000000103d0a7825ULL, 0x000fe200078e000aULL,
0x0058000008117faeULL, 0x0003e6000b901c50ULL, 0x0000001aff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x007800000a117faeULL, 0x0003e2000b901c50ULL, 0x0000001bff0f7e24ULL, 0x000fc4000f8e00ffULL,
0x00000080103d8824ULL, 0x000fe400078e0237ULL, 0x00000010020c8825ULL, 0x000fc800078e000cULL,
0x0000001002138824ULL, 0x040fe400078e0213ULL, 0x00000010020e8825ULL, 0x000fc600078e000eULL,
0x045800000c138faeULL, 0x0003e2000b901c50ULL, 0x00000010023d8824ULL, 0x000fca00078e023dULL,
0x041800000e3d8faeULL, 0x0003e4000b901c50ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000005000c7c82ULL, 0x000fe40008000000ULL, 0x000000060c057899ULL, 0x000fc8000800063fULL,
0x0000008005057892ULL, 0x000fcc000f8ec03fULL, 0x0000000500047c10ULL, 0x002fe2000fffe037ULL,
0x0000000a0c057899ULL, 0x000fc8000800063fULL, 0x00000001033d7824ULL, 0x000fe200078e0204ULL,
0x0000080005057892ULL, 0x000fc8000f8ec03fULL, 0x0000018004057890ULL, 0x000fe2000fffe005ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003d0d7984ULL, 0x000e620000000800ULL,
0x0000000536047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000538087c11ULL, 0x000fe2000f8e20ffULL,
0x004580003d3f7984ULL, 0x000fe20000000800ULL, 0x000000053a0c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000053b107c11ULL, 0x000fe2000f8e20ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000000b00057c82ULL, 0x000fe40008000000ULL, 0x000000120500728cULL, 0x000fe2000bf06070ULL,
0x000000000808783bULL, 0x000eea0000000200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000d14117221ULL, 0x002fc40000010100ULL, 0x000000000c0c783bULL, 0x000e640000000200ULL,
0x3fb8aa3b11427820ULL, 0x000fe40000410000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x30000005ff3e7230ULL, 0x004fc60000004100ULL, 0x0000004200427308ULL, 0x000ea20000000800ULL,
0x20000007ff417230ULL, 0x000fe40000004100ULL, 0x30000007ff407230ULL, 0x000fe40000004100ULL,
0x20000009ff437230ULL, 0x008fe40000004100ULL, 0x2000000bff457230ULL, 0x000fe40000004100ULL,
0x3000000bff447230ULL, 0x000fe40000004100ULL, 0x20000004ff3d7230ULL, 0x000fc40000004100ULL,
0x20000008ff077230ULL, 0x000fe40000004100ULL, 0x0000003f424e7220ULL, 0x004fe20000410000ULL,
0x20000005ff3f7230ULL, 0x000fe40000004100ULL, 0x30000009ff427230ULL, 0x000fe40000004100ULL,
0x000000354e357221ULL, 0x000fe20000010000ULL, 0x00001f394e4f7589ULL, 0x000ea200000e0000ULL,
0x20000006ff057230ULL, 0x000fe40000004100ULL, 0x2000000aff097230ULL, 0x000fe20000004100ULL,
0x00001f3c4e507589ULL, 0x000ee200000e0000ULL, 0x30000004ff047230ULL, 0x000fc40000004100ULL,
0x30000006ff067230ULL, 0x000fe40000004100ULL, 0x30000008ff087230ULL, 0x000fe40000004100ULL,
0x3000000aff0a7230ULL, 0x000fe40000004100ULL, 0x2000000dff477230ULL, 0x002fe40000004100ULL,
0x3000000dff467230ULL, 0x000fe40000004100ULL, 0x2000000fff497230ULL, 0x000fc40000004100ULL,
0x3000000fff487230ULL, 0x000fe40000004100ULL, 0x20000011ff4b7230ULL, 0x010fe40000004100ULL,
0x30000011ff4a7230ULL, 0x000fe40000004100ULL, 0x0000004f3d347223ULL, 0x084fe20000010034ULL,
0x2000000cff0b7230ULL, 0x000fe40000004100ULL, 0x0000004f04337223ULL, 0x000fe20000010033ULL,
0x2000000eff0d7230ULL, 0x000fc40000004100ULL, 0x0000004f3f327223ULL, 0x080fe20000010032ULL,
0x20000010ff0f7230ULL, 0x000fe40000004100ULL, 0x0000004f3e2f7223ULL, 0x080fe2000001002fULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x0000004f052e7223ULL, 0x080fe2000001002eULL,
0x3000000cff0c7230ULL, 0x000fe40000004100ULL, 0x0000004f062b7223ULL, 0x000fe2000001002bULL,
0x3000000eff0e7230ULL, 0x000fc40000004100ULL, 0x0000004f412a7223ULL, 0x080fe2000001002aULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000004f40277223ULL, 0x080fe20000010027ULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000004f07267223ULL, 0x080fe20000010026ULL,
0x20000013ff4d7230ULL, 0x000fe40000004100ULL, 0x0000004f08237223ULL, 0x000fe20000010023ULL,
0x30000013ff4c7230ULL, 0x000fc40000004100ULL, 0x0000004f43227223ULL, 0x080fe20000010022ULL,
0x0000004f421f7223ULL, 0x080fe2000001001fULL, 0x0000004f091e7223ULL, 0x080fe2000001001eULL,
0x0000004f0a1b7223ULL, 0x080fe2000001001bULL, 0x0000004f451a7223ULL, 0x080fe2000001001aULL,
0x0000004f44177223ULL, 0x000fe20000010017ULL, 0x000000500b167223ULL, 0x088fe20000010016ULL,
0x000000500c317223ULL, 0x080fe20000010031ULL, 0x0000005047307223ULL, 0x080fe20000010030ULL,
0x00000050462d7223ULL, 0x080fe2000001002dULL, 0x000000500d2c7223ULL, 0x080fe2000001002cULL,
0x000000500e297223ULL, 0x080fe20000010029ULL, 0x0000005049287223ULL, 0x080fe20000010028ULL,
0x0000005048257223ULL, 0x080fe20000010025ULL, 0x000000500f247223ULL, 0x080fe20000010024ULL,
0x0000005010217223ULL, 0x080fe20000010021ULL, 0x000000504b207223ULL, 0x080fe20000010020ULL,
0x000000504a1d7223ULL, 0x080fe2000001001dULL, 0x00000050111c7223ULL, 0x080fe2000001001cULL,
0x0000005012197223ULL, 0x080fe20000010019ULL, 0x000000504d187223ULL, 0x080fe20000010018ULL,
0x000000504c157223ULL, 0x000fe20000010015ULL, 0xfffffff400ac8947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00000013ff007c0cULL, 0x000fe2000bf05270ULL,
0x000049800a047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000403007c10ULL, 0x000fe2000fffe000ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000000a060a7291ULL, 0x000fe2000f8e383fULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ec0ffULL, 0x0000000a02027c10ULL, 0x000fca000fffe003ULL,
0x0049803502007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000027984ULL, 0x002e680000000800ULL, 0x0000800000037984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000302027221ULL, 0x004fc80000010000ULL,
0x0180000002037836ULL, 0x000fca0000000000ULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e0002ULL,
0x000095e000067802ULL, 0x000fce0000000f00ULL, 0x00000074005c7944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0005ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002007423ULL, 0x002fc80000000003ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe40000011602ULL,
0x00000008020d7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011602ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0900047589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff117812ULL, 0x000fc600078ee202ULL, 0x00001f0d000d7589ULL, 0x00072400000e0000ULL,
0x0000000811137836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000003404347220ULL, 0x044fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003204057220ULL, 0x040fe20000410000ULL, 0x0000002f04067220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002a04077220ULL, 0x040fe20000410000ULL, 0x0000002704087220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204097220ULL, 0x040fe20000410000ULL, 0x0000001f04007220ULL, 0x048fe20000410000ULL,
0x0000001e040a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a040b7220ULL, 0x040fe20000410000ULL, 0x00000017040c7220ULL, 0x000fe20000410000ULL,
0x0000000303047812ULL, 0x000fe200078ec0ffULL, 0x000000160d167220ULL, 0x050fe20000410000ULL,
0x000000310d317220ULL, 0x040fe20000410000ULL, 0x000000300d307220ULL, 0x040fe20000410000ULL,
0x0000000404147812ULL, 0x000fe200078efcffULL, 0x0000002d0d2d7220ULL, 0x040fe20000410000ULL,
0x0000002c0d0e7220ULL, 0x040fe20000410000ULL, 0x000000290d297220ULL, 0x040fe20000410000ULL,
0x000000280d0f7220ULL, 0x040fe20000410000ULL, 0x000000250d107220ULL, 0x040fe20000410000ULL,
0x000000240d247220ULL, 0x040fe20000410000ULL, 0x000000210d217220ULL, 0x040fe20000410000ULL,
0x000000200d207220ULL, 0x040fe20000410000ULL, 0x0000001d0d1d7220ULL, 0x040fe20000410000ULL,
0x0000001c0d1c7220ULL, 0x040fe20000410000ULL, 0x000000190d197220ULL, 0x040fe20000410000ULL,
0x000000180d187220ULL, 0x040fe20000410000ULL, 0x000000150d157220ULL, 0x000fe20000410000ULL,
0x00000008110d7824ULL, 0x000fe200078e00ffULL, 0x0000000704127812ULL, 0x000fe200078e7811ULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x00000007041a7812ULL, 0x000fc400078e7813ULL,
0x0000000714047812ULL, 0x000fe400078e7811ULL, 0x0000000714147812ULL, 0x000fe200078e7813ULL,
0x00000006ff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000000d12127212ULL, 0x080fe400078efcffULL,
0x0000000d04117212ULL, 0x000fe400078efcffULL, 0x000000171a1a7212ULL, 0x080fe400078efcffULL,
0x0000001714147212ULL, 0x000fc400078efcffULL, 0x000000050605723eULL, 0x000fe400000000ffULL,
0x000000090009723eULL, 0x000fe400000000ffULL, 0x000000343304723eULL, 0x000fe400000000ffULL,
0x0000002e2b06723eULL, 0x000fe400000000ffULL, 0x000000070807723eULL, 0x000fe400000000ffULL,
0x000000201d25723eULL, 0x000fc400000000ffULL, 0x0000001812007c11ULL, 0x000fe4000f8e20ffULL,
0x000000262308723eULL, 0x000fe400000000ffULL, 0x0000000a1b0a723eULL, 0x000fe200000000ffULL,
0x0000000400007844ULL, 0x000fe20000000200ULL, 0x0000000b0c0b723eULL, 0x000fe400000000ffULL,
0x000000242124723eULL, 0x000fe400000000ffULL, 0x0000001811207c11ULL, 0x000fc4000f8e20ffULL,
0x00000016310c723eULL, 0x000fe400000000ffULL, 0x000000302d0d723eULL, 0x000fe200000000ffULL,
0x0000000820007844ULL, 0x000fe20000000200ULL, 0x0000000e290e723eULL, 0x000fe400000000ffULL,
0x0000000f100f723eULL, 0x000fe200000000ffULL, 0x0000002013107824ULL, 0x000fe200078e0202ULL,
0x000000181a217c11ULL, 0x000fe4000f8e20ffULL, 0x0000001c1926723eULL, 0x000fc400000000ffULL,
0x000000181527723eULL, 0x000fe200000000ffULL, 0x0000000c21007844ULL, 0x000fe20000000200ULL,
0x0000001814227c11ULL, 0x000fe4000f8e20ffULL, 0x0000000710237c11ULL, 0x000fc6000f8e20ffULL,
0x0000002422007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000023107984ULL, 0x000ea80000000c00ULL, 0x0004000023187984ULL, 0x000ee80000000c00ULL,
0x0008000023147984ULL, 0x000f280000000c00ULL, 0x000c0000231c7984ULL, 0x000f620000000c00ULL,
0x200000ff13137230ULL, 0x004fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x008fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x010fe40000000000ULL, 0x0000001612127230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x020fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000001023007388ULL, 0x0005e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001823007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000006ff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000177919ULL, 0x000e620000002600ULL,
0x0000000313067899ULL, 0x000fe2000800063fULL, 0x0000002002047836ULL, 0x044fe20000000000ULL,
0x0000000313087899ULL, 0x000fe2000800063fULL, 0x00000040021d7836ULL, 0x040fe20000000000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000060021f7836ULL, 0x000fe20000000000ULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x00000006ff217e24ULL, 0x000fe2000f8e00ffULL,
0x00000003ff157819ULL, 0x000fe2000001161dULL, 0x00000008ff1b7e24ULL, 0x000fe2000f8e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001161fULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0xfffffff821217812ULL, 0x000fe200078ee202ULL, 0x0000860000087ab9ULL, 0x000fe20000000a00ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL, 0x00000006ff1a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000716067812ULL, 0x000fc800078e481fULL, 0x0ffffff806067812ULL, 0x000fc800078ef81fULL,
0x0000000706107c11ULL, 0x000fe2000f8e20ffULL, 0x00000004050472a4ULL, 0x004fca000f8e023fULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0000001017007824ULL, 0x042fe200078e00ffULL,
0x0000000313057899ULL, 0x000fe2000800063fULL, 0x0000001017147824ULL, 0x040fe400078e00ffULL,
0x0000001017187824ULL, 0x040fe200078e00ffULL, 0xfffffff000007812ULL, 0x000fe200078ee203ULL,
0x0000001017177824ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x000fe200078e4802ULL,
0x00000005ff1e7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000400007c10ULL, 0x000fc4000ff1e0ffULL,
0x0ffffff803077812ULL, 0x000fe400078ef802ULL, 0x00000003ff037819ULL, 0x000fe40000011604ULL,
0xfffffff017167812ULL, 0x000fe400078ee216ULL, 0x0000000703027812ULL, 0x000fe400078e4804ULL,
0xfffffff014147812ULL, 0x000fe200078ee203ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0ffffff802027812ULL, 0x000fc400078ef804ULL, 0x0000000715047812ULL, 0x000fe400078e481dULL,
0x0000000702027c11ULL, 0x000fe4000f8e20ffULL, 0x0ffffff804057812ULL, 0x000fe400078ef81dULL,
0x0000000707047c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002087984ULL, 0x0003e20000000c00ULL,
0x00000007050c7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff018157812ULL, 0x000fc400078ee215ULL,
0x0000000004047984ULL, 0x000ea20000000c00ULL, 0xfffffff81a1d7812ULL, 0x000fe400078ee21dULL,
0x0000000800027c11ULL, 0x042fe2000f8040ffULL, 0x000000000c0c7984ULL, 0x000e620000000c00ULL,
0x0000000415177c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000900037c11ULL, 0x000fe400080f4403ULL,
0x00000004141c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000416007c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001021027825ULL, 0x000fe200078e0002ULL,
0x0000000817167c11ULL, 0x000fc4000f8240ffULL, 0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000081c147c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x0000000800187c11ULL, 0x000fe4000f8440ffULL,
0x000000091c157c11ULL, 0x000fe400080f4415ULL, 0x0000000917177c11ULL, 0x000fe400088f441aULL,
0x0000000900197c11ULL, 0x000fe200090f4419ULL, 0x000000101b147825ULL, 0x000fc800078e0014ULL,
0x000000101d167825ULL, 0x000fc800078e0016ULL, 0x000000101f187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x004fe8000c101d10ULL, 0x0000000814007986ULL, 0x000fe8000c101d10ULL,
0x0000000c16007986ULL, 0x002fe8000c101d10ULL, 0x0000001018007986ULL, 0x000fe2000c101d10ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000004a0872caULL, 0x000fe200000e0000ULL,
0x03ffffff0f067892ULL, 0x000fd8000f8ec03fULL, 0x0000000608067291ULL, 0x000fc8000f8e103fULL,
0x000000050600728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000104088899ULL, 0x000fe2000800063fULL, 0x00009000000a8ab9ULL, 0x000fc60000000800ULL,
0x0000000a080882a4ULL, 0x000fc6000f8e0206ULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x00000004080a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001002028981ULL, 0x000ea2000c1e1900ULL,
0x000000014a007836ULL, 0x000fe20000000000ULL, 0xffffffff000a7882ULL, 0x000fe20000000000ULL,
0x000000060f157899ULL, 0x000fe4000800063fULL, 0x0000000609097899ULL, 0x000fe4000800063fULL,
0x000000060d087899ULL, 0x000fe2000800063fULL, 0x00000000020b82caULL, 0x004fe400000e0000ULL,
0x0000000700007c0cULL, 0x000fd6000bf06070ULL, 0x0000000b000a8c82ULL, 0x000fe40008000000ULL,
0x0000000c00448947ULL, 0x000fea0003800000ULL, 0x00000000007d7919ULL, 0x000e620000000000ULL,
0x000000154a047c11ULL, 0x000fe2000f8e40ffULL, 0x00008a00ff027b82ULL, 0x000ea20000000a00ULL,
0x000000080a0d72a4ULL, 0x000fe4000f8e0209ULL, 0x0000001604077c48ULL, 0x000fe2000ffe0000ULL,
0x00000400000b7882ULL, 0x000fc80000000000ULL, 0x0000000107047824ULL, 0x000fe200078e0a04ULL,
0x00000000000c79c3ULL, 0x000ee20000008800ULL, 0x00000003ff057819ULL, 0x002fe4000001167dULL,
0x0ffffff87d077812ULL, 0x000fe200078ec0ffULL, 0x000006540c137896ULL, 0x008fe2000800000bULL,
0x0000007d05007212ULL, 0x0c0fe200078e3cffULL, 0x00000008050a7836ULL, 0x040fe40000000000ULL,
0x0000000405067836ULL, 0x000fe20000000000ULL, 0x0000000707157812ULL, 0x000fe200078ef800ULL,
0x000000080a0c7824ULL, 0x040fe200078e00ffULL, 0x0000007d0a077212ULL, 0x080fe200078e3cffULL,
0x000000107d007824ULL, 0x000fe200078e00ffULL, 0x0000003f06097812ULL, 0x040fe200078ec0ffULL,
0x00000008061b7824ULL, 0x040fe200078e00ffULL, 0xfffffff80c1d7812ULL, 0x000fe200078ee207ULL,
0x0000000c050c7836ULL, 0x040fe20000000000ULL, 0x0000003f05077812ULL, 0x000fe200078ec0ffULL,
0x0000000d09097c36ULL, 0x000fe20008000000ULL, 0x0000007d06087212ULL, 0x080fe200078e3cffULL,
0x000000080c0f7824ULL, 0x000fe200078e00ffULL, 0x000000040600720cULL, 0x080fe20003fa6070ULL,
0x0000000d07077c36ULL, 0x000fe20008000000ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000001405147836ULL, 0x000fe20000000000ULL, 0x0000003f0c0d7812ULL, 0x040fe200078ec0ffULL,
0x0000010007067825ULL, 0x104fe200078e0002ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x000000130f0b7291ULL, 0x000fe2000f8e703fULL, 0x000000040c00720cULL, 0x0c0fe20003f06070ULL,
0x0000010009087825ULL, 0x000fe200078e0002ULL, 0x0000000600107210ULL, 0x000fe20007f5e0ffULL,
0x000010000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000007d0c0e7212ULL, 0x000fe200078e3cffULL,
0x0000000d0d0d7c36ULL, 0x000fe20008000000ULL, 0x0000000800127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x0000003f0a0b7812ULL, 0x040fe200078ec0ffULL,
0x000001000d067825ULL, 0x000fe200078e0002ULL, 0x000000040a00720cULL, 0x000fc40003f26070ULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee20eULL, 0x0000001005087836ULL, 0x000fe20000000000ULL,
0x00000006000c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000d0b0b7c36ULL, 0x000fe20008000000ULL,
0x0000003f140f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0609ULL,
0x0000003f08067812ULL, 0x040fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0607ULL,
0x000000040800720cULL, 0x040fe20003f46070ULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0x0000007d08097212ULL, 0x000fc400078e3cffULL, 0x000000041400720cULL, 0x080fe20003f66070ULL,
0x0000000d06077c36ULL, 0x000fe20008000000ULL, 0x0000000a000a7210ULL, 0x000fe20007f9e0ffULL,
0x00000008081c7824ULL, 0x000fe200078e00ffULL, 0x0000000b15157c11ULL, 0x000fe2000f8e20ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x0000000b1b1b7c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x0000000814177824ULL, 0x040fe200078e00ffULL,
0x0000000600087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x0000007d14067212ULL, 0x080fe200078e3cffULL, 0x0000001805147836ULL, 0x040fe20000000000ULL,
0x000000040500720cULL, 0x000fe20003f86070ULL, 0x0000000d0f0f7c36ULL, 0x000fe20008000000ULL,
0xfffffff8171e7812ULL, 0x000fe200078ee206ULL, 0x000000ffff097224ULL, 0x000fe200030e0607ULL,
0x0000003f14077812ULL, 0x040fe200078ec0ffULL, 0x0000001c05207836ULL, 0x000fe20000000000ULL,
0x0000007d14167212ULL, 0x000fe200078e3cffULL, 0x000001000f0e7825ULL, 0x000fe200078e0002ULL,
0x0000000b1d1d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000003f20177812ULL, 0x000fe200078ec0ffULL,
0x0000000d07077c36ULL, 0x000fe20008000000ULL, 0x0000000e000e7210ULL, 0x000fe20007fde0ffULL,
0x0000002005217836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000e101c50ULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x000000041400720cULL, 0x080fe40003f86070ULL, 0x0000003f21187812ULL, 0x000fe200078ec0ffULL,
0x0000000d17177c36ULL, 0x000fe20008000000ULL, 0x00000000121b7faeULL, 0x0005e2000e901c50ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x000000042000720cULL, 0x000fe20003fa6070ULL,
0x00000008141f7824ULL, 0x000fe200078e00ffULL, 0x0000000600147210ULL, 0x000fe20007fde0ffULL,
0x0000002405227836ULL, 0x000fe20000000000ULL, 0x000000000a1d7faeULL, 0x0007e2000c901c50ULL,
0x0000010017107825ULL, 0x002fe200078e0002ULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee216ULL,
0x0000003f22197812ULL, 0x000fe200078ec0ffULL, 0x0000000d18177c36ULL, 0x000fe20008000000ULL,
0x0000000b1a137c11ULL, 0x004fe2000f8e20ffULL, 0x000000ffff157224ULL, 0x000fe200030e0607ULL,
0x0000001000167210ULL, 0x000fe20007fde0ffULL, 0x0000010017067825ULL, 0x000fe200078e0002ULL,
0x0000007d21127212ULL, 0x0c0fe200078e3cffULL, 0x000000000c137faeULL, 0x0003e2000c101c50ULL,
0x000000042100720cULL, 0x000fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fe200030e0611ULL,
0x0000000600187210ULL, 0x000fe20007fde0ffULL, 0x0000000d19197c36ULL, 0x000fe20008000000ULL,
0x0000007d20067212ULL, 0x080fe200078e3cffULL, 0x0000002805237836ULL, 0x000fe20000000000ULL,
0x0000007d221a7212ULL, 0x000fe200078e3cffULL, 0x0000010019107825ULL, 0x000fe200078e0002ULL,
0x0000000b1c0b7c11ULL, 0x008fc4000f8e20ffULL, 0x000000042200720cULL, 0x080fe20003f26070ULL,
0x000000ffff197224ULL, 0x000fe200030e0607ULL, 0x0000003f23077812ULL, 0x000fe200078ec0ffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000000b1e0d7c11ULL, 0x002fe2000f8e20ffULL,
0x0000002c050c7836ULL, 0x000fe20000000000ULL, 0x0000001000107210ULL, 0x000fe20007fde0ffULL,
0x0000000820257824ULL, 0x000fe200078e00ffULL, 0xfffffff821127812ULL, 0x000fe200078ee212ULL,
0x00000008221b7824ULL, 0x000fe200078e00ffULL, 0x0000003f0c0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000d07077c36ULL, 0x000fe20008000000ULL, 0xfffffff825207812ULL, 0x000fe200078ee206ULL,
0x00000000080b7faeULL, 0x0003e2000d101c50ULL, 0x0000000b1f137c11ULL, 0x000fe2000f8e20ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee21aULL,
0x000000000e0d7faeULL, 0x000fe2000d901c50ULL, 0x0000000b121d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000003005127836ULL, 0x040fe20000000000ULL, 0x0000000b1a1f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000000014137faeULL, 0x0005e2000e101c50ULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x00000034051a7836ULL, 0x000fe20000000000ULL,
0x0000000b201b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d0a097c36ULL, 0x002fe20008000000ULL,
0x000000040c00720cULL, 0x080fe20003f86070ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x000000041200720cULL, 0x080fe20003f66070ULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x00000000161b7faeULL, 0x0003e2000e901c50ULL, 0x000000042300720cULL, 0x000fc40003fa6070ULL,
0x0000003805137836ULL, 0x044fe20000000000ULL, 0x00000008000a7210ULL, 0x000fe20007fde0ffULL,
0x0000003c05147836ULL, 0x000fe20000000000ULL, 0x0000003f12057812ULL, 0x000fe200078ec0ffULL,
0x00000000181d7faeULL, 0x000fe2000c101c50ULL, 0x000000041a00720cULL, 0x080fe20003f46070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0609ULL, 0x000000041400720cULL, 0x080fe20003f06070ULL,
0x0000000d05057c36ULL, 0x000fe20008000000ULL, 0x00000000101f7faeULL, 0x0005e2000c901c50ULL,
0x000000041300720cULL, 0x000fe20003f26070ULL, 0x0000000812177824ULL, 0x002fe200078e00ffULL,
0x0000003f1a097812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x0000007d0c0d7212ULL, 0x000fc400078e3cffULL, 0x0000003f130f7812ULL, 0x000fe200078ec0ffULL,
0x0000000d09097c36ULL, 0x000fe20008000000ULL, 0x0000007d23087212ULL, 0x0c0fe200078e3cffULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x0000003f14157812ULL, 0x000fe200078ec0ffULL,
0x000000080c107824ULL, 0x004fe200078e00ffULL, 0x00000004000c7210ULL, 0x000fe20007fde0ffULL,
0x0000000d0f0f7c36ULL, 0x000fe20008000000ULL, 0xfffffff8230e7812ULL, 0x000fe200078ee208ULL,
0x000000081a197824ULL, 0x000fe200078e00ffULL, 0xfffffff810117812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000007d12107212ULL, 0x080fe200078e3cffULL,
0x0000010009047825ULL, 0x000fe200078e0002ULL, 0x0000007d1a127212ULL, 0x000fc400078e3cffULL,
0xfffffff817107812ULL, 0x000fe200078ee210ULL, 0x000001000f087825ULL, 0x000fe200078e0002ULL,
0x0000000400047210ULL, 0x000fe40007fde0ffULL, 0xfffffff819127812ULL, 0x000fe200078ee212ULL,
0x0000000d150f7c36ULL, 0x000fe20008000000ULL, 0x0000000b11117c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000000800087210ULL, 0x000fe20007fde0ffULL,
0x000001000f027825ULL, 0x000fe200078e0002ULL, 0x0000007d130f7212ULL, 0x000fc400078e3cffULL,
0x0000000b12157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0x0000007d14137212ULL, 0x040fe200078e3cffULL, 0x0000000814147824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0xfffffff816177812ULL, 0x000fe400078ee20fULL,
0x0000000200027210ULL, 0x000fe40007fde0ffULL, 0x0000000b0e0f7c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff814197812ULL, 0x000fe200078ee213ULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000000b10137c11ULL, 0x000fe2000f8e20ffULL, 0x00000000060f7faeULL, 0x0003e2000e901c50ULL,
0x0000000b17177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b19197c11ULL, 0x000fe2000f8e20ffULL,
0x000000000a117faeULL, 0x0003e8000e101c50ULL, 0x000000000c137faeULL, 0x0003e8000d901c50ULL,
0x0000000004157faeULL, 0x0003e8000d101c50ULL, 0x0000000008177faeULL, 0x0003e8000c901c50ULL,
0x0000000002197faeULL, 0x0003e2000c101c50ULL, 0x0000000800f47947ULL, 0x000fea0003800000ULL,
0x00000000007d7919ULL, 0x000e620000000000ULL, 0x000000080a0c72a4ULL, 0x000fe2000f8e0209ULL,
0x00000000000b79c3ULL, 0x000ea20000008800ULL, 0x0000040000137882ULL, 0x000fe40000000000ULL,
0x000006540b137896ULL, 0x004fc80008000013ULL, 0x000000130f0b7291ULL, 0x000fe2000f8e703fULL,
0x00000003ff027819ULL, 0x002fe4000001167dULL, 0x0ffffff87d007812ULL, 0x000fe200078ec0ffULL,
0x000010000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000007d020b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000402167836ULL, 0x040fe40000000000ULL, 0x0000000802187836ULL, 0x000fe20000000000ULL,
0x00000007000b7812ULL, 0x000fe200078ef80bULL, 0x0000000816037824ULL, 0x040fe200078e00ffULL,
0x0000007d160a7212ULL, 0x080fe200078e3cffULL, 0x0000000818057824ULL, 0x040fe200078e00ffULL,
0x0000007d180c7212ULL, 0x080fe200078e3cffULL, 0x0000001802207836ULL, 0x040fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x0000001c02227836ULL, 0x000fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x0000000820037824ULL, 0x040fe200078e00ffULL,
0x0000007d20107212ULL, 0x080fe200078e3cffULL, 0x0000000822057824ULL, 0x040fe200078e00ffULL,
0x0000007d220e7212ULL, 0x080fe200078e3cffULL, 0x0000002402267836ULL, 0x040fe20000000000ULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x0000002802287836ULL, 0x000fe20000000000ULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000000826037824ULL, 0x040fe200078e00ffULL,
0x0000007d26127212ULL, 0x080fe200078e3cffULL, 0x0000000828057824ULL, 0x040fe200078e00ffULL,
0x0000007d28087212ULL, 0x080fe200078e3cffULL, 0x00000034022e7836ULL, 0x040fe20000000000ULL,
0xfffffff803127812ULL, 0x000fe200078ee212ULL, 0x00000030022c7836ULL, 0x040fe20000000000ULL,
0xfffffff805087812ULL, 0x000fe200078ee208ULL, 0x0000000c021a7836ULL, 0x000fe20000000000ULL,
0x0000007d2e057212ULL, 0x0c0fe200078e3cffULL, 0x000000082e147824ULL, 0x000fe200078e00ffULL,
0x0000007d2c067212ULL, 0x0c0fe200078e3cffULL, 0x000000082c037824ULL, 0x000fe200078e00ffULL,
0x0000007d1a097212ULL, 0x0c0fe200078e3cffULL, 0x000000081a047824ULL, 0x000fe200078e00ffULL,
0xfffffff814057812ULL, 0x000fe200078ee205ULL, 0x00000010021c7836ULL, 0x040fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x00000014021e7836ULL, 0x040fe20000000000ULL,
0x0000003f02147812ULL, 0x040fe200078ec0ffULL, 0x0000002002247836ULL, 0x040fe20000000000ULL,
0xfffffff804097812ULL, 0x000fe200078ee209ULL, 0x0000002c022a7836ULL, 0x000fe20000000000ULL,
0x0000007d1c0d7212ULL, 0x080fe200078e3cffULL, 0x0000003802307836ULL, 0x000fe20000000000ULL,
0x0000007d1e0f7212ULL, 0x080fe200078e3cffULL, 0x0000003c02327836ULL, 0x000fe20000000000ULL,
0x0000007d24117212ULL, 0x080fe200078e3cffULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x000000081c007824ULL, 0x000fe200078e00ffULL, 0x0000007d2a077212ULL, 0x080fe200078e3cffULL,
0x000000081e047824ULL, 0x000fe200078e00ffULL, 0x0000003f16167812ULL, 0x000fe200078ec0ffULL,
0x0000000830137824ULL, 0x000fe200078e00ffULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000824007824ULL, 0x000fe200078e00ffULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x000000082a047824ULL, 0x000fe200078e00ffULL, 0x0000003f18187812ULL, 0x000fe200078ec0ffULL,
0x0000000832157824ULL, 0x000fe200078e00ffULL, 0xfffffff800117812ULL, 0x000fe200078ee211ULL,
0x0000000c16177c36ULL, 0x000fe20008000000ULL, 0xfffffff804077812ULL, 0x000fe200078ee207ULL,
0x0000000c18197c36ULL, 0x000fe20008000000ULL, 0x0000007d30047212ULL, 0x000fc400078e3cffULL,
0x0000007d32007212ULL, 0x000fe400078e3cffULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x000000107d137824ULL, 0x000fe200078e00ffULL, 0xfffffff815007812ULL, 0x000fe200078ee200ULL,
0x0000000c14157c36ULL, 0x000fe20008000000ULL, 0x0000003f1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000010017167825ULL, 0x102fe200078e0002ULL, 0x0000003f1c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000003f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000010015147825ULL, 0x000fe200078e0002ULL,
0x0000003f20207812ULL, 0x000fc400078ec0ffULL, 0x0000003f22227812ULL, 0x000fe200078ec0ffULL,
0x0000000c1a1b7c36ULL, 0x000fe20008000000ULL, 0x0000003f24247812ULL, 0x000fe200078ec0ffULL,
0x0000000c1c1d7c36ULL, 0x000fe20008000000ULL, 0x0000003f26267812ULL, 0x000fe200078ec0ffULL,
0x0000000c1e1f7c36ULL, 0x000fe20008000000ULL, 0x0000003f28287812ULL, 0x000fe200078ec0ffULL,
0x0000000c20217c36ULL, 0x000fe20008000000ULL, 0x0000003f2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000c22237c36ULL, 0x000fe20008000000ULL, 0x0000003f2c2c7812ULL, 0x000fe200078ec0ffULL,
0x0000000c24257c36ULL, 0x000fe20008000000ULL, 0x0000003f2e2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000c26277c36ULL, 0x000fe20008000000ULL, 0x0000003f30307812ULL, 0x000fe200078ec0ffULL,
0x0000000c28297c36ULL, 0x000fe20008000000ULL, 0x0000003f32327812ULL, 0x000fe200078ec0ffULL,
0x0000000c2a2b7c36ULL, 0x000fe20008000000ULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000000c2c2d7c36ULL, 0x000fe20008000000ULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c2e2f7c36ULL, 0x000fe20008000000ULL, 0x0000001413147210ULL, 0x000fe20007f1e0ffULL,
0x0000000c30317c36ULL, 0x000fe20008000000ULL, 0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c32337c36ULL, 0x000fe20008000000ULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010019187825ULL, 0x000fe200078e0002ULL, 0x0000000b0f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b10357c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x100fe200078e0002ULL,
0x0000000b11117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0002ULL, 0x0000000b05057c11ULL, 0x000fc6000f8e20ffULL,
0x000001001f1e7825ULL, 0x000fc800078e0002ULL, 0x0000010021207825ULL, 0x000fc800078e0002ULL,
0x0000010023227825ULL, 0x000fc800078e0002ULL, 0x0000010025247825ULL, 0x000fc800078e0002ULL,
0x0000010027267825ULL, 0x000fc800078e0002ULL, 0x0000010029287825ULL, 0x000fc800078e0002ULL,
0x000001002b2a7825ULL, 0x000fc800078e0002ULL, 0x000001002d2c7825ULL, 0x000fc800078e0002ULL,
0x000001002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fc800078e0002ULL,
0x0000010033327825ULL, 0x000fe200078e0002ULL, 0x0000001613027210ULL, 0x000fe40007f3e0ffULL,
0x0000001813167210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001a13187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0617ULL,
0x0000001c131a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c50ULL,
0x000000ffff197224ULL, 0x000fe200000e061bULL, 0x0000001e131c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061dULL, 0x00000020131e7210ULL, 0x000fc40007f5e0ffULL,
0x0000002213207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061fULL,
0x0000002413227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe400010e0621ULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x0000002613247210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000002813267210ULL, 0x000fe40007f1e0ffULL,
0x0000000b0e0b7c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200008e0627ULL,
0x0000002a13287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000002c132a7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e062bULL,
0x0000002e132c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062dULL,
0x00000030132e7210ULL, 0x000fe40007f1e0ffULL, 0x0000003213307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062fULL, 0x0000000b0a137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe400000e0631ULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x0000000b0c337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002137faeULL, 0x0003e8000b901c50ULL,
0x0000000016337faeULL, 0x000fe8000b901c50ULL, 0x0000000018097faeULL, 0x0007e8000b901c50ULL,
0x000000001a0d7faeULL, 0x0009e2000b901c50ULL, 0x0000000b12037c11ULL, 0x002fc6000f8e20ffULL,
0x000000001c0f7faeULL, 0x0003e2000b901c50ULL, 0x0000000b08097c11ULL, 0x008fc6000f8e20ffULL,
0x000000001e357faeULL, 0x000fe2000b901c50ULL, 0x0000000b060d7c11ULL, 0x010fc6000f8e20ffULL,
0x00000000200b7faeULL, 0x0007e2000b901c50ULL, 0x0000000b000f7c11ULL, 0x002fc6000f8e20ffULL,
0x0000000022117faeULL, 0x0005e8000b901c50ULL, 0x0000000024037faeULL, 0x0005e2000b901c50ULL,
0x0000000b040b7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000026097faeULL, 0x0005e8000b901c50ULL,
0x0000000028077faeULL, 0x0005e8000b901c50ULL, 0x000000002a0d7faeULL, 0x0005e8000b901c50ULL,
0x000000002c057faeULL, 0x0005e8000b901c50ULL, 0x000000002e0b7faeULL, 0x0005e8000b901c50ULL,
0x00000000300f7faeULL, 0x0005e4000b901c50ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x023600ffff0075a7ULL, 0x000ee20008000153ULL, 0x000000074a007c0cULL, 0x000fe2000bf26070ULL,
0x0000004800488947ULL, 0x008fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00007610ff7c7816ULL, 0x000fe2000000007cULL, 0x00009000000c7ab9ULL, 0x000fe20000000800ULL,
0x000000130f197291ULL, 0x000fe4000f8e203fULL, 0xffffffff07177890ULL, 0x000fe4000fffe03fULL,
0x0000000c040c72a4ULL, 0x000fd8000f8e023fULL, 0x000000004a0d72caULL, 0x000fda00000e0000ULL,
0x000000150d0d7291ULL, 0x000fc8000f8e403fULL, 0x0000000d1600728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000014a007836ULL, 0x000fca0000000000ULL, 0x0000000700007c0cULL, 0x000fda000bf06070ULL,
0x0000000800f48947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001167dULL,
0x0000000a080a72a4ULL, 0x000fe2000f8e0209ULL, 0x000000077d447812ULL, 0x000fe200078ec0ffULL,
0x8000000d160b7290ULL, 0x000fe2000fffe03fULL, 0x0000003f00527812ULL, 0x040fe200078ec0ffULL,
0x0000000800037836ULL, 0x046fe20000000000ULL, 0x00008a00001a7ab9ULL, 0x000fe20000000a00ULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0x0000007d00147212ULL, 0x0c0fe200078e3cffULL,
0x0000000803077824ULL, 0x040fe200078e00ffULL, 0x0000007d03667212ULL, 0x080fe200078e3cffULL,
0x00000008050a7824ULL, 0x040fe200078e00ffULL, 0x0000007d05517212ULL, 0x080fe200078e3cffULL,
0x0000000400027836ULL, 0x040fe20000000000ULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x0000001800077836ULL, 0x000fe20000000000ULL, 0xfffffff80a517812ULL, 0x000fe200078ee251ULL,
0x0000000802067824ULL, 0x040fe200078e00ffULL, 0x0000007d02677212ULL, 0x080fe200078e3cffULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000007d074f7212ULL, 0x080fe200078e3cffULL,
0x0000000c00047836ULL, 0x040fe20000000000ULL, 0xfffffff806677812ULL, 0x000fe200078ee267ULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0xfffffff80a4f7812ULL, 0x000fe200078ee24fULL,
0x0000000804087824ULL, 0x040fe200078e00ffULL, 0x0000007d04657212ULL, 0x080fe200078e3cffULL,
0x00000024000a7836ULL, 0x000fe20000000000ULL, 0x0000007d06507212ULL, 0x0c0fe200078e3cffULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0xfffffff808657812ULL, 0x000fe200078ee265ULL,
0x000000080a0d7824ULL, 0x040fe200078e00ffULL, 0x0000007d0a4c7212ULL, 0x080fe200078e3cffULL,
0x0000001c00087836ULL, 0x040fe20000000000ULL, 0xfffffff809507812ULL, 0x000fe200078ee250ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x00000008080b7824ULL, 0x040fe200078e00ffULL, 0x0000007d084e7212ULL, 0x080fe200078e3cffULL,
0x00000030000d7836ULL, 0x040fe20000000000ULL, 0x0000007d094d7212ULL, 0x0c0fe200078e3cffULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b4e7812ULL, 0x000fe200078ee24eULL,
0x000000080d117824ULL, 0x040fe200078e00ffULL, 0x0000007d0d487212ULL, 0x080fe200078e3cffULL,
0x00000028000b7836ULL, 0x000fe20000000000ULL, 0x0000003f025a7812ULL, 0x000fe200078ec0ffULL,
0x00000038000f7836ULL, 0x040fe20000000000ULL, 0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000003f03597812ULL, 0x000fe200078ec0ffULL,
0x0000002c000c7836ULL, 0x000fe20000000000ULL, 0xfffffff811487812ULL, 0x000fe200078ee248ULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000003f04587812ULL, 0x000fe200078ec0ffULL,
0x000000130f047291ULL, 0x000fe2000f8e703fULL, 0x0000007d0b4b7212ULL, 0x080fe200078e3cffULL,
0x0000001aff127e24ULL, 0x000fe2000f8e00ffULL, 0x0000007d0f467212ULL, 0x080fe200078e3cffULL,
0x0000001bff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b00007c0cULL, 0x000fe2000bf06070ULL,
0x0000000a52157c36ULL, 0x000fe20008000000ULL, 0x0000000714687812ULL, 0x000fe200078ec0ffULL,
0x0000000a5a177c36ULL, 0x000fe20008000000ULL, 0xfffffff80e4b7812ULL, 0x000fe200078ee24bULL,
0x000000080c107824ULL, 0x040fe200078e00ffULL, 0x0000007d0c497212ULL, 0x000fe200078e3cffULL,
0x0000000a59197c36ULL, 0x000fe20008000000ULL, 0x0000000b02007c0cULL, 0x000fe2000bf26070ULL,
0x0000000a581b7c36ULL, 0x000fe20008000000ULL, 0xfffffff811467812ULL, 0x000fe200078ee246ULL,
0x00000034000e7836ULL, 0x000fe20000000000ULL, 0x0000300004187890ULL, 0x000fe2000fffe03fULL,
0x0000000b03007c0cULL, 0x000fe2000bf46070ULL, 0x0000010015147825ULL, 0x000fe200078e0012ULL,
0x0000000844117812ULL, 0x000fc400078efcffULL, 0x0000000b04007c0cULL, 0x000fe2000bf66070ULL,
0x0000010017167825ULL, 0x100fe200078e0012ULL, 0x0ffffff868687812ULL, 0x000fe400078ef87dULL,
0xfffffff810497812ULL, 0x000fe200078ee249ULL, 0x0000010019187825ULL, 0x100fe200078e0012ULL,
0x0000007d0e477212ULL, 0x000fe400078e3cffULL, 0x00000018681d7c11ULL, 0x000fe2000f8e20ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0012ULL, 0x00000018671f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000003f05577812ULL, 0x000fe200078ec0ffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x0000001866217c11ULL, 0x000fe2000f8e20ffULL, 0x0000001011147825ULL, 0x040fe200078e0014ULL,
0x0000003f06567812ULL, 0x000fe400078ec0ffULL, 0xfffffff810477812ULL, 0x000fe200078ee247ULL,
0x0000001011167825ULL, 0x000fe200078e0016ULL, 0x0000001865237c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e2000c101c50ULL,
0x0000003f07557812ULL, 0x000fe200078ec0ffULL, 0x0000001011187825ULL, 0x000fe200078e0018ULL,
0x0000003f08547812ULL, 0x000fe200078ec0ffULL, 0x00000000161f7faeULL, 0x0005e2000c901c50ULL,
0x0000003f09537812ULL, 0x000fe200078ec0ffULL, 0x00000010111a7825ULL, 0x000fe200078e001aULL,
0x0000000b05007c0cULL, 0x000fe2000bf06070ULL, 0x0000000018217faeULL, 0x0007e2000d101c50ULL,
0x0000000b06007c0cULL, 0x000fe2000bf26070ULL, 0x0000003c00107836ULL, 0x000fe20000000000ULL,
0x0000000b07007c0cULL, 0x000fe2000bf46070ULL, 0x0000000a57157c36ULL, 0x002fe20008000000ULL,
0x000000001a237faeULL, 0x0003e2000d901c50ULL, 0x00000008101c7824ULL, 0x040fe200078e00ffULL,
0x0000007d10457212ULL, 0x000fe200078e3cffULL, 0x0000000a56177c36ULL, 0x004fe20008000000ULL,
0x0000000b08007c0cULL, 0x000fe2000bf66070ULL, 0x0000000a531d7c36ULL, 0x000fe20008000000ULL,
0x0000000b09007c0cULL, 0x000fe2000bf86070ULL, 0x0000000a55197c36ULL, 0x008fe20008000000ULL,
0xfffffff81c457812ULL, 0x000fe200078ee245ULL, 0x0000010015147825ULL, 0x000fe200078e0012ULL,
0x00000018511f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001850217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a541b7c36ULL, 0x002fe20008000000ULL, 0x000000184f237c11ULL, 0x000fe2000f8e20ffULL,
0x0000010017167825ULL, 0x100fe200078e0012ULL, 0x000000184e257c11ULL, 0x000fe4000f8e20ffULL,
0x000000184d277c11ULL, 0x000fe2000f8e20ffULL, 0x0000010019187825ULL, 0x100fe200078e0012ULL,
0x0000003f0a637812ULL, 0x000fe400078ec0ffULL, 0x0000003f0b627812ULL, 0x000fe200078ec0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0012ULL, 0x0000003f0c617812ULL, 0x000fc400078ec0ffULL,
0x0000003f0d607812ULL, 0x000fe200078ec0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0012ULL,
0x0000003f0e5d7812ULL, 0x000fe400078ec0ffULL, 0x0000003f0f5c7812ULL, 0x000fe200078ec0ffULL,
0x0000001011147825ULL, 0x000fe200078e0014ULL, 0x0000003f105b7812ULL, 0x000fe400078ec0ffULL,
0x0000000b0f007c0cULL, 0x000fe2000bfa6070ULL, 0x0000001011167825ULL, 0x000fe200078e0016ULL,
0x00000000141f7faeULL, 0x0003e2000c101c50ULL, 0x0000000b0a007c0cULL, 0x000fc4000bf06070ULL,
0x0000001011187825ULL, 0x000fe200078e0018ULL, 0x0000000016217faeULL, 0x0005e2000c901c50ULL,
0x0000000b0b007c0cULL, 0x000fe4000bf26070ULL, 0x00000010111a7825ULL, 0x040fe200078e001aULL,
0x0000000018237faeULL, 0x0007e2000d101c50ULL, 0x0000000b0c007c0cULL, 0x000fe4000bf46070ULL,
0x00000010111c7825ULL, 0x000fe200078e001cULL, 0x000000001a257faeULL, 0x0009e2000d901c50ULL,
0x0000000b0d007c0cULL, 0x000fc4000bf66070ULL, 0x0000000a63157c36ULL, 0x002fe20008000000ULL,
0x000000001c277faeULL, 0x0003e2000e101c50ULL, 0x0000000a611f7c36ULL, 0x000fe20008000000ULL,
0x0000000b0e007c0cULL, 0x000fe2000bf86070ULL, 0x0000000a60217c36ULL, 0x004fe20008000000ULL,
0x0000000b10007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000a62197c36ULL, 0x008fe20008000000ULL,
0x000000184c237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a5b177c36ULL, 0x000fe20008000000ULL,
0x000000184b257c11ULL, 0x010fe2000f8e20ffULL, 0x0000000a5c1b7c36ULL, 0x000fe20008000000ULL,
0x0000001847297c11ULL, 0x000fe2000f8e20ffULL, 0x0000010015147825ULL, 0x000fe200078e0012ULL,
0x0000001848277c11ULL, 0x002fc4000f8e20ffULL, 0x00000018462b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a5d1d7c36ULL, 0x000fe20008000000ULL, 0x00000018452d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010019187825ULL, 0x000fc800078e0012ULL, 0x000001001f1e7825ULL, 0x000fc800078e0012ULL,
0x0000010021207825ULL, 0x000fc800078e0012ULL, 0x000001001d1c7825ULL, 0x000fc800078e0012ULL,
0x000001001b1a7825ULL, 0x000fc800078e0012ULL, 0x0000010017167825ULL, 0x000fc800078e0012ULL,
0x0000001011147825ULL, 0x000fc800078e0014ULL, 0x0000001011187825ULL, 0x040fe200078e0018ULL,
0x0000000014237faeULL, 0x0003e6000c101c50ULL, 0x00000010111e7825ULL, 0x040fe200078e001eULL,
0x0000000018257faeULL, 0x0003e6000c901c50ULL, 0x0000001011207825ULL, 0x000fc800078e0020ULL,
0x00000010111c7825ULL, 0x000fc800078e001cULL, 0x00000010111a7825ULL, 0x000fc800078e001aULL,
0x0000001011167825ULL, 0x000fe200078e0016ULL, 0x0000001849117c11ULL, 0x000fca000f8e20ffULL,
0x000000001e117faeULL, 0x0003e8000d101c50ULL, 0x0000000020277faeULL, 0x0003e8000d901c50ULL,
0x000000001c297faeULL, 0x0003e8000e101c50ULL, 0x000000001a2b7faeULL, 0x0003e8000e901c50ULL,
0x00000000162d7faeULL, 0x0003e2000f101c50ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001167dULL, 0x00008a00ff127b82ULL, 0x002e620000000a00ULL,
0x0000000a080a72a4ULL, 0x000fe2000f8e0209ULL, 0x000000077d447812ULL, 0x000fe200078ec0ffULL,
0x000000130f047291ULL, 0x000fe2000f8e703fULL, 0x0000000400027836ULL, 0x040fe20000000000ULL,
0x0000003f00527812ULL, 0x040fe200078ec0ffULL, 0x0000000800037836ULL, 0x044fe20000000000ULL,
0x0000007d00147212ULL, 0x0c0fe200078e3cffULL, 0x0000000c00047836ULL, 0x000fe20000000000ULL,
0x0000007d02677212ULL, 0x0c0fe200078e3cffULL, 0x0000000802067824ULL, 0x000fe200078e00ffULL,
0x0000007d03667212ULL, 0x0c0fe200078e3cffULL, 0x0000000803057824ULL, 0x000fe200078e00ffULL,
0x0000007d04657212ULL, 0x0c0fe200078e3cffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x0000001400067836ULL, 0x040fe20000000000ULL,
0xfffffff805667812ULL, 0x000fe200078ee266ULL, 0x0000001000057836ULL, 0x000fe20000000000ULL,
0xfffffff808657812ULL, 0x000fe200078ee265ULL, 0x0000000806097824ULL, 0x040fe200078e00ffULL,
0x0000007d06507212ULL, 0x080fe200078e3cffULL, 0x0000000805087824ULL, 0x040fe200078e00ffULL,
0x0000007d05517212ULL, 0x080fe200078e3cffULL, 0x0000001800077836ULL, 0x040fe20000000000ULL,
0xfffffff809507812ULL, 0x000fe200078ee250ULL, 0x0000002000097836ULL, 0x040fe20000000000ULL,
0xfffffff808517812ULL, 0x000fe200078ee251ULL, 0x0000001c00087836ULL, 0x000fe20000000000ULL,
0x0000007d074f7212ULL, 0x0c0fe200078e3cffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x0000007d094d7212ULL, 0x0c0fe200078e3cffULL, 0x00000008080b7824ULL, 0x040fe200078e00ffULL,
0x0000007d084e7212ULL, 0x080fe200078e3cffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a4f7812ULL, 0x000fe200078ee24fULL, 0x00000024000a7836ULL, 0x040fe20000000000ULL,
0xfffffff80b4e7812ULL, 0x000fe200078ee24eULL, 0x00000028000b7836ULL, 0x040fe20000000000ULL,
0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL, 0x0000002c000c7836ULL, 0x000fe20000000000ULL,
0x0000007d0a4c7212ULL, 0x0c0fe200078e3cffULL, 0x000000080a0d7824ULL, 0x000fe200078e00ffULL,
0x0000007d0b4b7212ULL, 0x0c0fe200078e3cffULL, 0x000000080b0e7824ULL, 0x000fe200078e00ffULL,
0x0000007d0c497212ULL, 0x040fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000000714687812ULL, 0x000fe200078ec0ffULL, 0x0000000a52157c36ULL, 0x000fe20008000000ULL,
0x0000300004187890ULL, 0x000fe2000fffe03fULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x00000030000d7836ULL, 0x000fe20000000000ULL, 0xfffffff80e4b7812ULL, 0x000fe200078ee24bULL,
0x0000010015147825ULL, 0x002fe200078e0012ULL, 0xfffffff810497812ULL, 0x000fc400078ee249ULL,
0x0000000844117812ULL, 0x000fe200078efcffULL, 0x00000034000e7836ULL, 0x040fe20000000000ULL,
0x0ffffff868687812ULL, 0x000fe200078ef87dULL, 0x00000038000f7836ULL, 0x040fe20000000000ULL,
0x0000007d0d487212ULL, 0x0c0fe200078e3cffULL, 0x0000003c00107836ULL, 0x000fe20000000000ULL,
0x0000001868177c11ULL, 0x000fe2000f8e20ffULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x0000007d0f467212ULL, 0x040fe200078e3cffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0x0000003f025a7812ULL, 0x000fe200078ec0ffULL, 0x0000001011147825ULL, 0x000fe200078e0014ULL,
0x0000003f03597812ULL, 0x000fc400078ec0ffULL, 0x0000003f04587812ULL, 0x000fe200078ec0ffULL,
0x000000080e167824ULL, 0x000fe200078e00ffULL, 0x0000003f05577812ULL, 0x000fe200078ec0ffULL,
0x0000000810187824ULL, 0x000fe200078e00ffULL, 0x0000003f06567812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000b901c50ULL,
0x0000003f07557812ULL, 0x000fe200078ec0ffULL, 0x0000000a5a277c36ULL, 0x000fe20008000000ULL,
0x0000003f08547812ULL, 0x000fe200078ec0ffULL, 0x0000000a582b7c36ULL, 0x000fe20008000000ULL,
0x0000003f09537812ULL, 0x000fe200078ec0ffULL, 0x0000000a572d7c36ULL, 0x000fe20008000000ULL,
0x0000003f0a637812ULL, 0x000fe200078ec0ffULL, 0x0000000a56297c36ULL, 0x000fe20008000000ULL,
0x0000003f0b627812ULL, 0x000fe200078ec0ffULL, 0x0000000a551f7c36ULL, 0x000fe20008000000ULL,
0x0000003f0c617812ULL, 0x000fe200078ec0ffULL, 0x0000000a59177c36ULL, 0x002fe20008000000ULL,
0x0000003f0d607812ULL, 0x000fe200078ec0ffULL, 0x0000000a54257c36ULL, 0x000fe20008000000ULL,
0x0000003f0e5d7812ULL, 0x000fe200078ec0ffULL, 0x0000000a53317c36ULL, 0x000fe20008000000ULL,
0x0000003f0f5c7812ULL, 0x000fe200078ec0ffULL, 0x0000000a632f7c36ULL, 0x000fe20008000000ULL,
0x0000003f105b7812ULL, 0x000fe200078ec0ffULL, 0x0000000a62237c36ULL, 0x000fe20008000000ULL,
0x0000007d0e477212ULL, 0x080fe200078e3cffULL, 0x0000000a61217c36ULL, 0x000fe20008000000ULL,
0x0000007d10457212ULL, 0x000fe200078e3cffULL, 0x0000000a60157c36ULL, 0x000fe20008000000ULL,
0xfffffff819487812ULL, 0x000fe200078ee248ULL, 0x0000000a5d1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff81b467812ULL, 0x000fe200078ee246ULL, 0x0000000a5c197c36ULL, 0x000fe20008000000ULL,
0xfffffff816477812ULL, 0x000fe200078ee247ULL, 0x0000000a5b1b7c36ULL, 0x000fe20008000000ULL,
0xfffffff818457812ULL, 0x000fe200078ee245ULL, 0x0000010027267825ULL, 0x000fe200078e0012ULL,
0x0000001866337c11ULL, 0x000fc4000f8e20ffULL, 0x0000001865357c11ULL, 0x000fe2000f8e20ffULL,
0x0000010017167825ULL, 0x100fe200078e0012ULL, 0x0000001851377c11ULL, 0x000fe4000f8e20ffULL,
0x0000001850397c11ULL, 0x000fe2000f8e20ffULL, 0x000001002b2a7825ULL, 0x100fe200078e0012ULL,
0x000000184f3b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000184e3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000001002d2c7825ULL, 0x000fe200078e0012ULL, 0x000000184d3f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000184c417c11ULL, 0x000fe2000f8e20ffULL, 0x0000010029287825ULL, 0x000fe200078e0012ULL,
0x000000184b437c11ULL, 0x000fc6000f8e20ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0012ULL,
0x0000010025247825ULL, 0x000fc800078e0012ULL, 0x0000010031307825ULL, 0x000fc800078e0012ULL,
0x000001002f2e7825ULL, 0x000fc800078e0012ULL, 0x0000010023227825ULL, 0x000fc800078e0012ULL,
0x0000010021207825ULL, 0x000fc800078e0012ULL, 0x0000010015147825ULL, 0x000fc800078e0012ULL,
0x000001001d1c7825ULL, 0x000fc800078e0012ULL, 0x0000010019187825ULL, 0x000fc800078e0012ULL,
0x000001001b1a7825ULL, 0x000fc800078e0012ULL, 0x0000001011267825ULL, 0x000fc800078e0026ULL,
0x0000001011167825ULL, 0x000fc800078e0016ULL, 0x00000010112a7825ULL, 0x000fc800078e002aULL,
0x00000010112c7825ULL, 0x000fc800078e002cULL, 0x0000001011287825ULL, 0x000fc800078e0028ULL,
0x00000010111e7825ULL, 0x000fc800078e001eULL, 0x0000001011247825ULL, 0x000fc800078e0024ULL,
0x0000001011307825ULL, 0x000fc800078e0030ULL, 0x00000010112e7825ULL, 0x000fc800078e002eULL,
0x0000001011227825ULL, 0x000fc800078e0022ULL, 0x0000001011207825ULL, 0x000fc800078e0020ULL,
0x0000001011147825ULL, 0x000fc800078e0014ULL, 0x00000010111c7825ULL, 0x000fc800078e001cULL,
0x0000001011187825ULL, 0x000fc800078e0018ULL, 0x00000010111a7825ULL, 0x000fe200078e001aULL,
0x0000001867117c11ULL, 0x000fca000f8e20ffULL, 0x0000000026117faeULL, 0x0003e8000b901c50ULL,
0x0000000016337faeULL, 0x0005e8000b901c50ULL, 0x000000002a357faeULL, 0x0007e8000b901c50ULL,
0x000000002c377faeULL, 0x000fe2000b901c50ULL, 0x0000001849117c11ULL, 0x002fc4000f8e20ffULL,
0x0000001847277c11ULL, 0x000fe2000f8e20ffULL, 0x0000000028397faeULL, 0x0003e2000b901c50ULL,
0x0000001848177c11ULL, 0x004fc6000f8e20ffULL, 0x000000001e3b7faeULL, 0x0009e2000b901c50ULL,
0x00000018452b7c11ULL, 0x008fc6000f8e20ffULL, 0x00000000243d7faeULL, 0x0009e8000b901c50ULL,
0x00000000303f7faeULL, 0x0009e2000b901c50ULL, 0x0000001846297c11ULL, 0x002fc6000f8e20ffULL,
0x000000002e417faeULL, 0x0009e8000b901c50ULL, 0x0000000022437faeULL, 0x0009e8000b901c50ULL,
0x0000000020117faeULL, 0x0009e8000b901c50ULL, 0x0000000014177faeULL, 0x0009e8000b901c50ULL,
0x000000001c277faeULL, 0x0009e8000b901c50ULL, 0x0000000018297faeULL, 0x0009e8000b901c50ULL,
0x000000001a2b7faeULL, 0x0009e4000b901c50ULL, 0x00000004ff6c7819ULL, 0x000fe2000001167dULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000844117812ULL, 0x012fe200078ef87dULL,
0x0000100004147890ULL, 0x000fe2000fffe03fULL, 0x0000000100727812ULL, 0x000fe200078ec0ffULL,
0x000000086c157824ULL, 0x000fe200078e00ffULL, 0x000000076c147812ULL, 0x000fe200078e7811ULL,
0x0000000612067291ULL, 0x000fc6000f8e103fULL, 0xfffffff815157812ULL, 0x000fe200078ee244ULL,
0x0000001011147824ULL, 0x000fe200078e0214ULL, 0x000000050600728cULL, 0x000fe4000bf06070ULL,
0x00000007156b7812ULL, 0x040fe200078ec0ffULL, 0x0000000815697824ULL, 0x040fe200078e00ffULL,
0x0000001314147c11ULL, 0x000fe2000f8e20ffULL, 0x00000030156e7836ULL, 0x040fe20000000000ULL,
0x000000016b167812ULL, 0x000fe200078e7800ULL, 0x0000001015647836ULL, 0x040fe20000000000ULL,
0x000000026b187812ULL, 0x000fe200078e1e72ULL, 0x00000020156d7836ULL, 0x000fe20000000000ULL,
0x00000069167b7212ULL, 0x000fe200078efcffULL, 0x000000026c167836ULL, 0x000fe20000000000ULL,
0x000000076e5f7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000147b247c11ULL, 0x000fe2000f8e20ffULL, 0x000000001438783bULL, 0x0003e20000000200ULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0x0000000716167812ULL, 0x000fe200078e7811ULL,
0x000000060c048291ULL, 0x000fe2000f8e083fULL, 0x00000007645e7812ULL, 0x040fe200078ec0ffULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x000000076d6a7812ULL, 0x040fe200078ec0ffULL,
0x0000000864647824ULL, 0x000fe200078e00ffULL, 0x000000015f1d7812ULL, 0x000fe200078e7800ULL,
0x000000086d6d7824ULL, 0x000fe200078e00ffULL, 0x000000015e157812ULL, 0x000fe200078e7800ULL,
0x0000001011167824ULL, 0x000fe200078e0216ULL, 0x000000016a147812ULL, 0x002fe200078e7800ULL,
0x00008c00000a8ab9ULL, 0x000fe20000000a00ULL, 0x0000006e1d787212ULL, 0x000fe200078efcffULL,
0x00000004040a88a5ULL, 0x000fe2000f8e000aULL, 0x0000006918777212ULL, 0x000fc400078efcffULL,
0x00000064157a7212ULL, 0x000fe400078efcffULL, 0x0000006d14797212ULL, 0x000fe400078efcffULL,
0x0000001478307c11ULL, 0x000fe4000f8e20ffULL, 0x0000001316167c11ULL, 0x000fe4000f8e20ffULL,
0x0000001477187c11ULL, 0x000fe4000f8e20ffULL, 0x000000147a347c11ULL, 0x000fe2000f8e20ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x0000001479287c11ULL, 0x000fc4000f8e20ffULL,
0x000000026a2c7812ULL, 0x000fe200078e1e72ULL, 0x000000001614783bULL, 0x000fe20000000200ULL,
0x000000025e217812ULL, 0x000fe400078e1e72ULL, 0x0000006d2c757212ULL, 0x000fe200078efcffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000006421767212ULL, 0x000fe200078efcffULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x000000025f737812ULL, 0x000fc400078e1e72ULL, 0x0000001476207c11ULL, 0x000fe2000f8e20ffULL,
0x000000002828783bULL, 0x000f620000000200ULL, 0x00000024381c723cULL, 0x004fe200000018ffULL,
0x0000006e73737212ULL, 0x000fc600078efcffULL, 0x000000002020783bULL, 0x000ea20000000200ULL,
0x00000014733c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000263824723cULL, 0x000fea00000018ffULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x00000030382c723cULL, 0x002fee00000018ffULL,
0x0000001475307c11ULL, 0x000fca000f8e20ffULL, 0x00000018141c723cULL, 0x008fec000000181cULL,
0x0000001a1418723cULL, 0x000fec0000001824ULL, 0x000000343840723cULL, 0x010fec00000018ffULL,
0x000000283824723cULL, 0x020fec00000018ffULL, 0x000000363834723cULL, 0x000fec00000018ffULL,
0x0000002a3828723cULL, 0x000fec00000018ffULL, 0x000000323838723cULL, 0x000fe200000018ffULL,
0x000000003030783bULL, 0x000e6a0000000200ULL, 0x000000201440723cULL, 0x004fec0000001840ULL,
0x000000221420723cULL, 0x000fec0000001834ULL, 0x000000301424723cULL, 0x002fec0000001824ULL,
0x000000321428723cULL, 0x000fe20000001828ULL, 0x0000000aff307e24ULL, 0x000fc4000f8e00ffULL,
0x0000000bff317e24ULL, 0x000fca000f8e00ffULL, 0x0000001030748981ULL, 0x0002a2000c1e1900ULL,
0x000000046c327836ULL, 0x000fe20000000000ULL, 0x000000046b347812ULL, 0x000fe200078e1e72ULL,
0x0000003c142c723cULL, 0x000fe2000000182cULL, 0x000000004a0e72caULL, 0x000fe200000e0000ULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x0000000732327812ULL, 0x000fe400078e7811ULL,
0x0000006934717212ULL, 0x000fe200078efcffULL, 0x0000003e1414723cULL, 0x000fe40000001838ULL,
0x0000001011327824ULL, 0x000fe200078e0232ULL, 0x00000014713c7c11ULL, 0x000fc8000f8e20ffULL,
0x0000001332347c11ULL, 0x000fe2000f8e20ffULL, 0x0000000e120e7290ULL, 0x000fe2000fffe03fULL,
0x000000003c30783bULL, 0x0023e60000000200ULL, 0x000000010e047890ULL, 0x000fe2000fffe03fULL,
0x000000003434783bULL, 0x000ee60000000200ULL, 0x000000070400728cULL, 0x000fe2000bf26070ULL,
0x00000004ff3c7819ULL, 0x002fe2000001167dULL, 0x00000030341c723cULL, 0x008fec000000181cULL,
0x000000323418723cULL, 0x000fe20000001818ULL, 0x000000045e317812ULL, 0x000fc400078e1e72ULL,
0x000000046a307812ULL, 0x000fe400078e1e72ULL, 0x0000006431707212ULL, 0x000fe400078efcffULL,
0x0000006d306f7212ULL, 0x000fe400078efcffULL, 0x00000014703d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000146f387c11ULL, 0x000fc6000f8e20ffULL, 0x000000003d30783bULL, 0x000e680000000200ULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x000000303440723cULL, 0x002fec0000001840ULL,
0x000000383424723cULL, 0x008fe20000001824ULL, 0x000000045f317812ULL, 0x000fc400078e1e72ULL,
0x000000065f5f7812ULL, 0x000fe400078e1e72ULL, 0x0000006e316c7212ULL, 0x080fe200078efcffULL,
0x000000323420723cULL, 0x000fe20000001820ULL, 0x0000006e5f5f7212ULL, 0x000fe400078efcffULL,
0x000000146c397c11ULL, 0x000fc6000f8e20ffULL, 0x0000003a3428723cULL, 0x000fe40000001828ULL,
0x000000003930783bULL, 0x0002e40000000200ULL, 0x000000065e397812ULL, 0x002fe400078e1e72ULL,
0x000000066a5e7812ULL, 0x000fe400078e1e72ULL, 0x0000006439647212ULL, 0x000fe400078efcffULL,
0x0000006d5e5e7212ULL, 0x000fe200078efcffULL, 0x00000030342c723cULL, 0x008fec000000182cULL,
0x000000323430723cULL, 0x000fee0000001814ULL, 0x000000063c147836ULL, 0x000fe20000000000ULL,
0x000000066b167812ULL, 0x000fc400078e1e72ULL, 0x000000145f3c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000714147812ULL, 0x000fe400078e7811ULL, 0x0000006916697212ULL, 0x000fe400078efcffULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000001011147824ULL, 0x000fe200078e0214ULL,
0x0000001469387c11ULL, 0x000fc8000f8e20ffULL, 0x0000001314347c11ULL, 0x000fe4000f8e20ffULL,
0x000000003814783bULL, 0x0003e80000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x000000145e387c11ULL, 0x002fcc000f8e20ffULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x00000014341c723cULL, 0x008fec000000181cULL, 0x000000163418723cULL, 0x000fe20000001818ULL,
0x0000001464147c11ULL, 0x000fca000f8e20ffULL, 0x000000383424723cULL, 0x002fe20000001824ULL,
0x000000001414783bULL, 0x000e6a0000000200ULL, 0x0000003a3428723cULL, 0x000fec0000001828ULL,
0x0000003c342c723cULL, 0x000fec000000182cULL, 0x0000003e3430723cULL, 0x000fe20000001830ULL,
0x00000000740482caULL, 0x004fc400000e0000ULL, 0x000000000000781cULL, 0x000fc60003f0f018ULL,
0x000000143440723cULL, 0x002ff00000001840ULL, 0x00000004000a8c82ULL, 0x000fe20008000000ULL,
0x000000163420723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000400ec8947ULL, 0x000fde0003800000ULL, 0x000000080a1a72a4ULL, 0x000fe2000f8e0209ULL,
0x000000107d6a7824ULL, 0x000fe200078e00ffULL, 0x000000150e047291ULL, 0x000fe2000f8e403fULL,
0x0000001467677c11ULL, 0x000fe4000f8e20ffULL, 0x0000001465657c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a52157c36ULL, 0x000fe20008000000ULL, 0x000000041600728cULL, 0x000fe2000bf01070ULL,
0x0000001a5a177c36ULL, 0x000fe20008000000ULL, 0x000000706a6a7812ULL, 0x000fe200078ec0ffULL,
0x0000010015147825ULL, 0x000fe200078e0012ULL, 0x00000004160b7287ULL, 0x000fe2000c000000ULL,
0x0000001451517c11ULL, 0x000fc4000f8e20ffULL, 0x0000010017167825ULL, 0x100fe200078e0012ULL,
0x0000000b040b7290ULL, 0x000fe2000fffe13fULL, 0x000000146a147210ULL, 0x000fe40007f1e0ffULL,
0x0000001a59357c36ULL, 0x000fe20008000000ULL, 0x000000166a167210ULL, 0x000fe20007f3e0ffULL,
0x0000001a58377c36ULL, 0x000fe20008000000ULL, 0x0000000b03007c0cULL, 0x000fe2000bf66070ULL,
0x0000010035347825ULL, 0x100fe200078e0012ULL, 0x0000000b05007c0cULL, 0x000fe4000bf86070ULL,
0x0000000b06007c0cULL, 0x000fe2000bfa6070ULL, 0x0000010037367825ULL, 0x000fe200078e0012ULL,
0x000000144f4f7c11ULL, 0x000fc4000f8e20ffULL, 0x000000144d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000b02007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000346a027210ULL, 0x000fe20007f5e0ffULL,
0x0000001a57577c36ULL, 0x000fe20008000000ULL, 0x000000366a347210ULL, 0x000fe20007f3e0ffULL,
0x0000001a53397c36ULL, 0x000fe20008000000ULL, 0x000000144b4b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200010e0635ULL, 0x0000000b04007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff357224ULL, 0x000fe200008e0637ULL, 0x0000000b00007c0cULL, 0x000fe2000bf26070ULL,
0x0000001a553b7c36ULL, 0x000fe20008000000ULL, 0x0000001449497c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a54057c36ULL, 0x000fe20008000000ULL, 0x0000001447477c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a61537c36ULL, 0x000fe20008000000ULL, 0x0000001445457c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a56597c36ULL, 0x000fc40008000000ULL, 0x0000001a63557c36ULL, 0x000fe40008000000ULL,
0x0000001a623d7c36ULL, 0x000fe40008000000ULL, 0x0000001a60617c36ULL, 0x000fe40008000000ULL,
0x0000001a5d3f7c36ULL, 0x000fe40008000000ULL, 0x0000001a5c377c36ULL, 0x000fe40008000000ULL,
0x0000001a5b5d7c36ULL, 0x000fc40008000000ULL, 0x00000100575a7825ULL, 0x000fc800078e0012ULL,
0x0000010005567825ULL, 0x000fe200078e0012ULL, 0x0000005a6a5a7210ULL, 0x000fc60007fde0ffULL,
0x0000010059587825ULL, 0x000fc800078e0012ULL, 0x000001003b3a7825ULL, 0x000fc800078e0012ULL,
0x0000010039387825ULL, 0x000fc800078e0012ULL, 0x0000010055547825ULL, 0x000fc800078e0012ULL,
0x000001003d3c7825ULL, 0x000fc800078e0012ULL, 0x0000010053527825ULL, 0x000fc800078e0012ULL,
0x0000010061047825ULL, 0x000fc800078e0012ULL, 0x000001003f3e7825ULL, 0x000fc800078e0012ULL,
0x0000010037367825ULL, 0x000fc800078e0012ULL, 0x000001005d127825ULL, 0x000fe200078e0012ULL,
0x00000014685d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff5b7224ULL, 0x000fe200030e065bULL,
0x000000586a587210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000145d7faeULL, 0x0003e2000c901c50ULL, 0x0000003a6a067210ULL, 0x000fc60007f3e0ffULL,
0x0000000016677faeULL, 0x000fe2000c101c50ULL, 0x0000000b07007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff077224ULL, 0x000fe200008e063bULL, 0x00000014663b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff597224ULL, 0x000fe200030e0659ULL, 0x0000000b08007c0cULL, 0x000fc6000bf26070ULL,
0x00000000023b7faeULL, 0x0005e2000d901c50ULL, 0x000000566a147210ULL, 0x002fc60007fde0ffULL,
0x0000000034657faeULL, 0x0003e2000d101c50ULL, 0x0000000b09007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff157224ULL, 0x000fe200030e0657ULL, 0x000000546a087210ULL, 0x000fe20007fde0ffULL,
0x000000005a517faeULL, 0x000fe2000e101c50ULL, 0x000000386a027210ULL, 0x004fc60007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0655ULL, 0x000000526a167210ULL, 0x000fe40007fde0ffULL,
0x000000144e357c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200018e0639ULL,
0x0000000b0a007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff177224ULL, 0x000fe200030e0653ULL,
0x0000001450397c11ULL, 0x000fe4000f8e20ffULL, 0x0000003c6a0a7210ULL, 0x000fc60007f9e0ffULL,
0x0000000058397faeULL, 0x0003e2000e901c50ULL, 0x0000000b0b007c0cULL, 0x000fe2000bfa6070ULL,
0x000000ffff0b7224ULL, 0x000fe200020e063dULL, 0x0000000b0c007c0cULL, 0x000fe2000bf86070ULL,
0x00000000064f7faeULL, 0x0005e2000c101c50ULL, 0x000000046a047210ULL, 0x000fe40007f1e0ffULL,
0x0000003e6a0c7210ULL, 0x000fe20007fde0ffULL, 0x0000000014357faeULL, 0x000fe2000c901c50ULL,
0x0000000b0d007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000b0e007c0cULL, 0x000fe2000bf06070ULL, 0x00000000024d7faeULL, 0x0007e2000d101c50ULL,
0x000000144c397c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e063fULL,
0x000000366a067210ULL, 0x004fc60007f5e0ffULL, 0x0000000008397faeULL, 0x0003e2000d901c50ULL,
0x0000000b0f007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff077224ULL, 0x000fe200010e0637ULL,
0x0000000b10007c0cULL, 0x000fe2000bf46070ULL, 0x000000000a4b7faeULL, 0x0009e2000e901c50ULL,
0x000000126a6a7210ULL, 0x000fe40007fde0ffULL, 0x0000001448037c11ULL, 0x008fe2000f8e20ffULL,
0x0000000016497faeULL, 0x0009e4000e101c50ULL, 0x000000ffff6b7224ULL, 0x000fe200030e0613ULL,
0x0000001446097c11ULL, 0x002fe2000f8e20ffULL, 0x0000000004037faeULL, 0x0009e8000c901c50ULL,
0x000000000c477faeULL, 0x0009e8000c101c50ULL, 0x0000000006097faeULL, 0x0009e8000d901c50ULL,
0x000000006a457faeULL, 0x0009e2000d101c50ULL, 0x0000000400987947ULL, 0x000fea0003800000ULL,
0x000000080a0472a4ULL, 0x000fe2000f8e0209ULL, 0x000000107d107824ULL, 0x000fe200078e00ffULL,
0x0000001467677c11ULL, 0x000fe4000f8e20ffULL, 0x0000001465657c11ULL, 0x000fe4000f8e20ffULL,
0x00000004523f7c36ULL, 0x000fe20008000000ULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x000000045a397c36ULL, 0x000fe20008000000ULL, 0x0000001451517c11ULL, 0x000fe2000f8e20ffULL,
0x000001003f3e7825ULL, 0x000fe200078e0012ULL, 0x000000144f4f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000144d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010039387825ULL, 0x100fe200078e0012ULL,
0x0000003e103e7210ULL, 0x000fe40007f1e0ffULL, 0x000000144b4b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000459377c36ULL, 0x000fe20008000000ULL, 0x0000003810387210ULL, 0x000fe20007f3e0ffULL,
0x0000000457357c36ULL, 0x000fe20008000000ULL, 0x0000001450577c11ULL, 0x000fe2000f8e20ffULL,
0x0000010037367825ULL, 0x000fe200078e0012ULL, 0x0000001449497c11ULL, 0x000fc4000f8e20ffULL,
0x0000001447477c11ULL, 0x000fe2000f8e20ffULL, 0x0000010035347825ULL, 0x000fe200078e0012ULL,
0x0000001445457c11ULL, 0x000fc6000f8e20ffULL, 0x0000000456157c36ULL, 0x000fe40008000000ULL,
0x00000004550f7c36ULL, 0x000fe20008000000ULL, 0x0000001466557c11ULL, 0x000fe2000f8e20ffULL,
0x00000004583b7c36ULL, 0x000fe40008000000ULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0x0000003610367210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e0639ULL,
0x0000003410347210ULL, 0x000fe20007f3e0ffULL, 0x0000010015147825ULL, 0x000fc800078e0012ULL,
0x000001000f0e7825ULL, 0x000fc800078e0012ULL, 0x00000004530d7c36ULL, 0x000fe20008000000ULL,
0x0000001468537c11ULL, 0x000fe2000f8e20ffULL, 0x000001003b3a7825ULL, 0x000fc800078e0012ULL,
0x0000000463097c36ULL, 0x000fe20008000000ULL, 0x0000003a103a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000454177c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e537faeULL, 0x0003e2000b901c50ULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x0000001410147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000000e100e7210ULL, 0x000fe20007f3e0ffULL, 0x000001000d0c7825ULL, 0x100fe200078e0012ULL,
0x0000000038677faeULL, 0x000fe6000b901c50ULL, 0x0000010009087825ULL, 0x000fe200078e0012ULL,
0x0000000036557faeULL, 0x0007e2000b901c50ULL, 0x000000144e3f7c11ULL, 0x002fc4000f8e20ffULL,
0x0000000462077c36ULL, 0x000fe40008000000ULL, 0x0000010017167825ULL, 0x000fc800078e0012ULL,
0x0000000460037c36ULL, 0x000fe40008000000ULL, 0x00000004610b7c36ULL, 0x000fe20008000000ULL,
0x000000144c377c11ULL, 0x008fe2000f8e20ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000000c100c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000810087210ULL, 0x000fe20007f3e0ffULL, 0x0000010007067825ULL, 0x000fc800078e0012ULL,
0x000000ffff3b7224ULL, 0x000fe200010e063bULL, 0x0000001610167210ULL, 0x000fe20007f5e0ffULL,
0x0000010003027825ULL, 0x000fc600078e0012ULL, 0x000000003a657faeULL, 0x000fe2000b901c50ULL,
0x000000045d057c36ULL, 0x000fe40008000000ULL, 0x000001000b0a7825ULL, 0x000fe200078e0012ULL,
0x0000000034517faeULL, 0x000fe6000b901c50ULL, 0x000000045c3d7c36ULL, 0x000fe20008000000ULL,
0x0000000014577faeULL, 0x0003e2000b901c50ULL, 0x000000045b5b7c36ULL, 0x000fe40008000000ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000000610067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000000210027210ULL, 0x000fe20007f3e0ffULL,
0x0000010005047825ULL, 0x000fe200078e0012ULL, 0x000000000e4f7faeULL, 0x0007e6000b901c50ULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000000a100a7210ULL, 0x000fe20007f5e0ffULL,
0x000001003d3c7825ULL, 0x000fe200078e0012ULL, 0x0000001448157c11ULL, 0x002fc4000f8e20ffULL,
0x00000000163f7faeULL, 0x0005e2000b901c50ULL, 0x000001005b127825ULL, 0x000fc600078e0012ULL,
0x000000000c4d7faeULL, 0x0005e2000b901c50ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000410047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0603ULL,
0x0000003c103c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000001210127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000008377faeULL, 0x0005e2000b901c50ULL, 0x000000ffff3d7224ULL, 0x000fe200008e063dULL,
0x00000014460f7c11ULL, 0x008fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x00000000064b7faeULL, 0x0005e8000b901c50ULL, 0x000000000a497faeULL, 0x0005e8000b901c50ULL,
0x0000000002157faeULL, 0x0005e8000b901c50ULL, 0x0000000004477faeULL, 0x0005e8000b901c50ULL,
0x000000003c0f7faeULL, 0x0005e8000b901c50ULL, 0x0000000012457faeULL, 0x0005e4000b901c50ULL,
0x00000004ff037819ULL, 0x014fe2000001167dULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000187b087c11ULL, 0x000fe2000f8e20ffULL, 0x000000130f0b7291ULL, 0x000fe2000f8e383fULL,
0x000000187a0c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000803027836ULL, 0x000fe20000000000ULL,
0x0000001879147c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a03107836ULL, 0x000fe20000000000ULL,
0x0000001878347c11ULL, 0x000fe4000f8e20ffULL, 0x0000000702027812ULL, 0x000fc400078e7811ULL,
0x0000000710107812ULL, 0x000fe400078e7811ULL, 0x0000001877387c11ULL, 0x000fe2000f8e20ffULL,
0x0000001011027824ULL, 0x040fe200078e0202ULL, 0x000000185e5e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001011107824ULL, 0x000fe200078e0210ULL, 0x00000018694c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001302027c11ULL, 0x000fe4000f8e20ffULL, 0x0000001310107c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x000000000204783bULL, 0x0002a80000000200ULL, 0x000000000c0c783bULL, 0x000ee80000000200ULL,
0x000000001414783bULL, 0x000f220000000200ULL, 0x0000000c03027836ULL, 0x002fc60000000000ULL,
0x000000003434783bULL, 0x000e640000000200ULL, 0x0000000702027812ULL, 0x000fe400078e7811ULL,
0x00000000103c783bULL, 0x000be60000000200ULL, 0x0000001011027824ULL, 0x000fe200078e0202ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x0000001302027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000e03107836ULL, 0x020fe20000000000ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x00000008041c723cULL, 0x004fec000000181cULL, 0x0000000a0418723cULL, 0x000fe20000001818ULL,
0x0000001876087c11ULL, 0x000fca000f8e20ffULL, 0x0000000c0440723cULL, 0x008fe20000001840ULL,
0x000000000808783bULL, 0x000eaa0000000200ULL, 0x0000000e0420723cULL, 0x000fe20000001820ULL,
0x00000018750c7c11ULL, 0x000fca000f8e20ffULL, 0x000000140424723cULL, 0x010fe20000001824ULL,
0x000000000c0c783bULL, 0x000eea0000000200ULL, 0x000000160428723cULL, 0x000fe20000001828ULL,
0x0000001873147c11ULL, 0x000fca000f8e20ffULL, 0x00000034042c723cULL, 0x002fe2000000182cULL,
0x000000001414783bULL, 0x000e6a0000000200ULL, 0x000000360430723cULL, 0x000fe20000001830ULL,
0x000000000234783bULL, 0x0009ea0000000200ULL, 0x000000383c1c723cULL, 0x000fe2000000181cULL,
0x0000001871047c11ULL, 0x000fc4000f8e20ffULL, 0x0000ffff7c027812ULL, 0x010fc600078ec0ffULL,
0x000000083c40723cULL, 0x004fe20000001840ULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000001870387c11ULL, 0x000fe4000f8e20ffULL, 0x0000888002027816ULL, 0x000fe400000000ffULL,
0x0000000a3c20723cULL, 0x000fe20000001820ULL, 0x000000186f087c11ULL, 0x000fca000f8e20ffULL,
0x0000000c3c24723cULL, 0x008fe20000001824ULL, 0x000000000808783bULL, 0x000eea0000000200ULL,
0x0000000e3c28723cULL, 0x000fe20000001828ULL, 0x00000007100c7812ULL, 0x000fe400078e7811ULL,
0x000000186c107c11ULL, 0x000fc6000f8e20ffULL, 0x00000010110c7824ULL, 0x000fe200078e020cULL,
0x0000003a3c18723cULL, 0x000fe20000001818ULL, 0x000000003838783bULL, 0x000f260000000200ULL,
0x000000130c0c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x000000143c2c723cULL, 0x002fe8000000182cULL, 0x000000000c0c783bULL, 0x000fe40000000200ULL,
0x000000163c30723cULL, 0x000fe20000001830ULL, 0x0000001864147c11ULL, 0x000fca000f8e20ffULL,
0x00000004343c723cULL, 0x004fe2000000181cULL, 0x000000005e1c783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x000000063404723cULL, 0x000fec0000001818ULL,
0x000000083424723cULL, 0x008fe20000001824ULL, 0x000000185f187c11ULL, 0x000fca000f8e20ffULL,
0x0000000a3408723cULL, 0x000fe20000001828ULL, 0x000000001818783bULL, 0x000eea0000000200ULL,
0x000000383440723cULL, 0x010fec0000001840ULL, 0x0000003a3438723cULL, 0x000fec0000001820ULL,
0x00000010342c723cULL, 0x020fec000000182cULL, 0x0000001e0c08723cULL, 0x002fec0000001808ULL,
0x000000123430723cULL, 0x000fe20000001830ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0002ULL,
0x000000047d027824ULL, 0x000fe400078e00ffULL, 0x800000001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000004c0c3c723cULL, 0x000fe4000000183cULL, 0xfffffff002027812ULL, 0x000fe200078ec0ffULL,
0x0236101fff0075a7ULL, 0x000e660008000159ULL, 0x0000004e0c4c723cULL, 0x000fec0000001804ULL,
0x000000140c20723cULL, 0x004fe20000001840ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fc80000410000ULL, 0x000000160c14723cULL, 0x000fec0000001838ULL,
0x0000001c0c10723cULL, 0x000fe20000001824ULL, 0x3db504f33c037820ULL, 0x000fca0000410000ULL,
0x000000180c04723cULL, 0x008fe2000000182cULL, 0x3db504f3091c7820ULL, 0x000fe20000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe20000410000ULL,
0x0000001a0c0c723cULL, 0x000fe20000001830ULL, 0x3db504f33d187820ULL, 0x000fe20000410000ULL,
0x3db504f33f197820ULL, 0x000fe20000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f321217820ULL, 0x000fe20000410000ULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x3db504f323237820ULL, 0x000fe20000410000ULL, 0x3db504f3081b7820ULL, 0x000fe20000410000ULL,
0x3db504f33e1a7820ULL, 0x000fe20000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316167820ULL, 0x000fe20000410000ULL,
0x3db504f317177820ULL, 0x000fe20000410000ULL, 0x3db504f310107820ULL, 0x000fe20000410000ULL,
0x3db504f311117820ULL, 0x000fe20000410000ULL, 0x3db504f312127820ULL, 0x000fe20000410000ULL,
0x3db504f313137820ULL, 0x000fc40000410000ULL, 0x3db504f3041d7820ULL, 0x000fe20000410000ULL,
0x3db504f3051e7820ULL, 0x000fe20000410000ULL, 0x3db504f306087820ULL, 0x000fe20000410000ULL,
0x3db504f307097820ULL, 0x000fc60000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fe20000410000ULL, 0x0000001000a48947ULL, 0x002fec0003800000ULL,
0x0234000b02047984ULL, 0x0002a20008000c00ULL, 0x000000174a007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x000000027d1f7824ULL, 0x000fe200078e00ffULL,
0x8000000d160d7290ULL, 0x000fc8000fffe03fULL, 0x000000061f1f7812ULL, 0x000fc800078ec0ffULL,
0x000000011f247812ULL, 0x040fe400078efcffULL, 0x000000081f257812ULL, 0x040fe400078efcffULL,
0x0000000d24007c0cULL, 0x000fe4000bf26070ULL, 0x000000101f247812ULL, 0x000fe400078efcffULL,
0x0000000d25007c0cULL, 0x000fe4000bf06070ULL, 0x0000000d24007c0cULL, 0x000fc4000bfc6070ULL,
0x000000111f257812ULL, 0x040fe400078efcffULL, 0x000000181f247812ULL, 0x040fe400078efcffULL,
0x0000000d1f007c0cULL, 0x000fe4000bf46070ULL, 0x0000000d25007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000d24007c0cULL, 0x000fe4000bf66070ULL, 0x000000091f267812ULL, 0x000fc400078efcffULL,
0x000000191f257812ULL, 0x040fe400078efcffULL, 0x000000201f247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff18187808ULL, 0x000fc40004800000ULL,
0x0000000d26007c0cULL, 0x000fe4000bf86070ULL, 0x0000000d25007c0cULL, 0x000fe4000bf46070ULL,
0x0000000d24007c0cULL, 0x000fe4000bf26070ULL, 0x000000211f257812ULL, 0x040fe400078efcffULL,
0x000000281f247812ULL, 0x000fe400078efcffULL, 0xff7fffff4e4e7808ULL, 0x000fc40004000000ULL,
0xff7fffff4c4c7808ULL, 0x000fe40004000000ULL, 0xff7fffff4f4f7808ULL, 0x000fe40006000000ULL,
0xff7fffff4d4d7808ULL, 0x000fe40006000000ULL, 0x0000000d25007c0cULL, 0x000fe4000bf06070ULL,
0x0000000d24007c0cULL, 0x000fe4000bf86070ULL, 0x000000291f257812ULL, 0x000fc400078efcffULL,
0x000000301f247812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0x0000000d25007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000d24007c0cULL, 0x000fe4000bfa6070ULL, 0x000000311f257812ULL, 0x040fe400078efcffULL,
0x000000381f247812ULL, 0x040fe400078efcffULL, 0x000000391f1f7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0x0000000d25007c0cULL, 0x000fe4000bf66070ULL, 0x0000000d24007c0cULL, 0x000fc4000bf46070ULL,
0x0000000d1f007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40006000000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL, 0xff7fffff08087808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0xff7fffff09097808ULL, 0x000fe40005800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0xff7fffff0d0d7808ULL, 0x000fce0004800000ULL, 0x00000003041f7209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x000000181f1f7209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000004c1f047209ULL, 0x000fe40007810000ULL, 0x0000004e05247209ULL, 0x000fc40007810000ULL,
0x0000004d04057209ULL, 0x000fe40007810000ULL, 0x0000004f241f7209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x000000221f247209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x00000023241f7209ULL, 0x000fc40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x000000161f247209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x00000017241f7209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x000000121f247209ULL, 0x000fc40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000001324057209ULL, 0x000fe40007810000ULL,
0x0000001b041f7209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fe40007810000ULL,
0x0000001c1f247209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fc40007810000ULL,
0x0000001d241f7209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x0000001e1f1f7209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000ff7cff7812ULL, 0x000fe4000780c0ffULL, 0x0000000c1f047209ULL, 0x000fc40007810000ULL,
0x0000000e05247209ULL, 0x000fe40007810000ULL, 0x00000001ff7c7807ULL, 0x000fe40000000000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000000f24057209ULL, 0x000fe20007810000ULL,
0x0000000e04207947ULL, 0x000fec000b800000ULL, 0x0c401f00041f7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0005247f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006277f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007287f89ULL, 0x000f2200000e0000ULL, 0x0000001f04257209ULL, 0x002fc40007810000ULL,
0x0000002405267209ULL, 0x004fc60007810000ULL, 0x0c201f00252a7f89ULL, 0x000e6200000e0000ULL,
0x0000002706277209ULL, 0x008fc60007810000ULL, 0x0c201f0026297f89ULL, 0x000ea200000e0000ULL,
0x00000028071f7209ULL, 0x010fc60007810000ULL, 0x0c201f00272c7f89ULL, 0x000ee800000e0000ULL,
0x0c201f001f247f89ULL, 0x00092200000e0000ULL, 0x0000002a25047209ULL, 0x002fe40007810000ULL,
0x0000002926057209ULL, 0x004fe40007810000ULL, 0x0000002c27067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052b7820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b4f4f7823ULL, 0x000fe2000001082bULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010807ULL, 0x0000001000277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b132d7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe2000001082bULL, 0x0000001b00297308ULL, 0x000ff00000000800ULL,
0x0000000c002a7308ULL, 0x000ff00000000800ULL, 0x0000001a000d7308ULL, 0x000ff00000000800ULL,
0x0000001900107308ULL, 0x000e700000000800ULL, 0x0000004e001b7308ULL, 0x000fe20000000800ULL,
0x0000000d1019723eULL, 0x002fce00000000ffULL, 0x0000004f000c7308ULL, 0x000e620000000800ULL,
0x3c003c00ff0d7424ULL, 0x000fce00078e00ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x0000001b0c1b723eULL, 0x002fce00000000ffULL, 0x0000001800187308ULL, 0x000e620000000800ULL,
0x3c003c00ff0c7424ULL, 0x000fce00078e00ffULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x000000031818723eULL, 0x002fce00000000ffULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b16037823ULL, 0x000fce000001082bULL, 0x0000001100287308ULL, 0x000fe20000000800ULL,
0x0000004c4d1a723eULL, 0x002fce00000000ffULL, 0x0000002200117308ULL, 0x0003f00000000800ULL,
0x0000001400257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17227823ULL, 0x002fce000001082bULL,
0x0000001500267308ULL, 0x0003f00000000800ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000c1814723cULL, 0x002fe400000018ffULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x00000023002c7308ULL, 0x0004e20000000800ULL,
0x000000202110723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12237823ULL, 0x104fe2000001082bULL, 0x000000252612723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b08217823ULL, 0x100fe2000001082bULL, 0x000000272808723eULL, 0x000fe400000000ffULL,
0x000000112c11723eULL, 0x008fe400000000ffULL, 0x0000002200227308ULL, 0x000e700000000800ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000032213723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b0b037823ULL, 0x000fcc000001082bULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b09227823ULL, 0x000fe2000001082bULL, 0x0000000c1014723cULL, 0x000fec0000001814ULL,
0x0000002d002e7308ULL, 0x000e700000000800ULL, 0x0000000a00207308ULL, 0x0005e20000000800ULL,
0x000000232e09723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000e620000000800ULL,
0x000000291c0a723eULL, 0x004fce00000000ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x00000020030b723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0xfffffffc7d037812ULL, 0x000fe200078ec0ffULL, 0x0000000c082c723cULL, 0x000fec0000001814ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x0000001d1e14723eULL, 0x002fce00000000ffULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000002a0716723eULL, 0x004fce00000000ffULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x000000241f077209ULL, 0x010fce0007810000ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x000000212215723eULL, 0x002fce00000000ffULL,
0x0000000f000f7308ULL, 0x000e640000000800ULL, 0x0000000e0f17723eULL, 0x002fce00000000ffULL,
0x0000000c142c723cULL, 0x000fee000000182cULL, 0x0000000fff0c7424ULL, 0x000fca00078e00ffULL,
0x000000030c037219ULL, 0x000fd600000006ffULL, 0x001c1fff2c0c7589ULL, 0x00026200000e0000ULL,
0x00000000001c7806ULL, 0x000fe200038e0100ULL, 0x00000000030e73a1ULL, 0x000eb000000e8000ULL,
0x00000000030473c4ULL, 0x000ee20000004000ULL, 0x00000000000d7886ULL, 0x000fc400038e0100ULL,
0x0000000d03ff7c12ULL, 0x004fda000f80400eULL, 0x0000000a04388947ULL, 0x00afea000b800000ULL,
0x001c1fff2e0d7589ULL, 0x0002a800000e0000ULL, 0x001c1fff0e0e7589ULL, 0x000ee800000e0000ULL,
0x001c1fff000f7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff447812ULL, 0x000fe200078ee244ULL,
0x000000130f047291ULL, 0x000fe2000f8e583fULL, 0x00000003001f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200078e0018ULL, 0x000000037dff7812ULL, 0x000fe2000780c0ffULL,
0x00000008441c7836ULL, 0x040fe20000000000ULL, 0x000000041f217812ULL, 0x000fe200078efcffULL,
0x0000000844007824ULL, 0x002fe200078e00ffULL, 0x000000071f037812ULL, 0x000fe200078e7844ULL,
0x00000004ff207e24ULL, 0x000fe2000f8e00ffULL, 0x00000007211d7812ULL, 0x000fe200078e7844ULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x000000071f1f7812ULL, 0x000fe200078e781cULL,
0x000000ffff257224ULL, 0x000fe200078e001aULL, 0x0000000721217812ULL, 0x000fe200078e781cULL,
0x00011000201c7836ULL, 0x000fe20000000000ULL, 0x0000000003037212ULL, 0x080fe200078efcffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x000000001d1d7212ULL, 0x000fe200078efcffULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0000001e1f1f7212ULL, 0x080fe200078efcffULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x0000001e21217212ULL, 0x000fe200078efcffULL,
0x000000ffff287224ULL, 0x000fc400078e0008ULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002403007844ULL, 0x0003e20000000200ULL,
0x000000101d1d7824ULL, 0x000fe400078e021cULL, 0x000000ffff297224ULL, 0x000fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fc400078e0014ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x000000281d007844ULL, 0x0003e20000000200ULL, 0x000000101f1f7824ULL, 0x000fe400078e021cULL,
0x000000ffff1a7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0013ULL,
0x000000ffff097224ULL, 0x000fe400078e000bULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x000000181f007844ULL, 0x0003e20000000200ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0015ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0017ULL, 0x00000001ff007424ULL, 0x000fe400078e00ffULL,
0x0000000eff4a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000821007844ULL, 0x0003e20000000200ULL,
0x000000070e00728cULL, 0x000fc6000bf06070ULL, 0x0230000402008988ULL, 0x0003e80008000c0bULL,
0x0232000c02008988ULL, 0x01c3e20008000c0bULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x02360800ffff79a7ULL, 0x0003d80008500019ULL, 0xffffffb800148947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000001dff2c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000001dff2d7e24ULL, 0x000fce000f8e00ffULL, 0x0236082dff0075a7ULL, 0x000262000802015cULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0236082dff0095a7ULL, 0x000e64000802005cULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff3800387947ULL, 0x020fea000383ffffULL, 0x0000000dff067e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff077e24ULL, 0x000fce000f8e00ffULL, 0x02362807ff0075a7ULL, 0x000262000802015cULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x02362807ff0095a7ULL, 0x000e64000802005cULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff5400247947ULL, 0x020fea000383ffffULL, 0x023600ffff0075a7ULL, 0x000ee20008000153ULL,
0x0000b0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x023600ffff0085a7ULL, 0x000e640008000053ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffb400a07947ULL, 0x006fea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e001fULL,
0x000000ffff057224ULL, 0x000fce00078e001fULL, 0x02361005ff0075a7ULL, 0x0002620008000159ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02361005ff0085a7ULL, 0x000e640008000059ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffec003c7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0004ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fce00078e00ffULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0006e40000000030ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0005ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x004fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001f04257209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff247224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002405267209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0007ULL,
0x000000ffff277224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002706277209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0025ULL,
0x00000001ff2f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000028071f7209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0026ULL, 0x000000ffff2a7224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a25047209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0027ULL, 0x000000ffff297224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002926057209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e001fULL, 0x000000ffff2c7224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c27067209ULL, 0x000fe20007810000ULL,
0x000000ffff247224ULL, 0x000fe200078e002dULL, 0xfffffff000387947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x004fe400078e000fULL,
0x000000ffff2e7224ULL, 0x002fe400078e000eULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x004fe400078e000fULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff400607947ULL, 0x006fea000383ffffULL, 0x0180000049027836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000004900028308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff027807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff49027812ULL, 0x000fc800078ec0ffULL, 0x000000ff0200720cULL, 0x000fc80003f02070ULL,
0xffffffffff027807ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000049037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000004900027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffef002bc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000670ULL, 0x000000000000039cULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a0cULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a60ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000aa8ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000ab0ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000b00ULL, 0x0000000000010e00ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011900ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000011910ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011910ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000011910ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000011ff8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011ff8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000aa8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010e00ULL, 0x0000000000010e00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011900ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011910ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_16_m_16_sm_90_cubin_len = 74056;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
