/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a738ULL, 0x000000000001a3b8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a002200000388ULL, 0x0000000000019040ULL, 0x0000000000000240ULL, 0x00040003000003feULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000019280ULL, 0x000d00030000042eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001904000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080920828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809292ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0001904000000000ULL,
0x0000024000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL, 0x00082304000000eaULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff010c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002e0010c2804ULL, 0x0000081000000410ULL,
0x0000344000002490ULL, 0x000035a0000034c0ULL, 0x00003800000036d0ULL, 0x00003d1000003940ULL,
0x00003d3000003d20ULL, 0x0000447000003d40ULL, 0x0000541000005370ULL, 0x00005620000054f0ULL,
0x0000589000005750ULL, 0x00005b2000005b10ULL, 0x00005b4000005b30ULL, 0x0000700000006110ULL,
0x0000717000007080ULL, 0x000073d0000072a0ULL, 0x0000777000007510ULL, 0x0000779000007780ULL,
0x00007ca0000077a0ULL, 0x00008d3000008c90ULL, 0x00008f3000008e00ULL, 0x000091a000009060ULL,
0x0000941000009400ULL, 0x0000943000009420ULL, 0x00009c6000009c50ULL, 0x00009c8000009c70ULL,
0x0000c8700000c810ULL, 0x0000c9d00000c990ULL, 0x0000d2500000d230ULL, 0x0000d2c00000d290ULL,
0x0001790000017850ULL, 0x00017d3000017c20ULL, 0x0001827000018140ULL, 0x000185f000018540ULL,
0x0000053001f03904ULL, 0x0001e600000000ffULL, 0x0000061000040100ULL, 0x0001e60800000006ULL,
0x00000720003f0100ULL, 0x0001e68800000005ULL, 0x000011d0003f0100ULL, 0x0001e6000000000aULL,
0x00001380003f0107ULL, 0x0001e6880000000eULL, 0x000031f0003f0101ULL, 0x0001e60800000081ULL,
0x00003210003f0101ULL, 0x0001e60800000081ULL, 0x00003380003f0109ULL, 0x0001e60800000081ULL,
0x00004350003f0109ULL, 0x0001e68800000025ULL, 0x00005100003f0101ULL, 0x0001e62800000081ULL,
0x00005170003f0101ULL, 0x0001e62800000080ULL, 0x000052e0003f0109ULL, 0x0001e62800000080ULL,
0x00006040003f0109ULL, 0x0001e69000000025ULL, 0x00006d90003f0101ULL, 0x0001e64800000080ULL,
0x00006e00003f0101ULL, 0x0001e64800000081ULL, 0x00006f70003f0109ULL, 0x0001e64800000081ULL,
0x00007c20003f0109ULL, 0x0001e69800000025ULL, 0x00008a10003f0101ULL, 0x0001e66800000081ULL,
0x00008a80003f0101ULL, 0x0001e6680000005dULL, 0x00008bf0003f0109ULL, 0x0001e6680000005dULL,
0x00009800003f0109ULL, 0x0001e6a000000025ULL, 0x0000ef00003f0101ULL, 0x0001e6000000000aULL,
0x00010800003f0101ULL, 0x0001e6000000000aULL, 0x000109c0003f0109ULL, 0x0001e6000000000aULL,
0x00014d70003f0109ULL, 0x0001e6880000001dULL, 0x000152b0003f0101ULL, 0x0001e6880000001dULL,
0x00015420003f0109ULL, 0x0001e6880000001dULL, 0x00018fe0003f0109ULL, 0x0001e6080000001bULL,
0x00018ff0003f0101ULL, 0x0001e6100000001bULL, 0x00019000003f0101ULL, 0x0001e6180000001bULL,
0x00019010003f0101ULL, 0x0001e6200000001bULL, 0x00033803003f0101ULL, 0x0000de4000301c04ULL,
0x0000e1300000de70ULL, 0x0000e5100000e320ULL, 0x0000e8f00000e700ULL, 0x0000ece00000eae0ULL,
0x000109f00000ee90ULL, 0x000c050400019030ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001400080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001300000002ULL, 0x0000000000019040ULL, 0x0000000000000044ULL, 0x0000001300000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001300000002ULL, 0x0000000000000000ULL,
0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000001f7919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff1b7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x000000011f072836ULL, 0x008fe40000000000ULL, 0x000000041f042825ULL, 0x004fc800078e0002ULL,
0x0000000407022825ULL, 0x000fe200078e0002ULL, 0x00000006040f2981ULL, 0x0004e8000c1e1900ULL,
0x00000006020e2981ULL, 0x000ae2000c1e1900ULL, 0x0000001b00087306ULL, 0x010f220000209000ULL,
0x00000300ff007b82ULL, 0x000ea20000000800ULL, 0x000000ff1b00720cULL, 0x000fe20003f65070ULL,
0x0000000000127919ULL, 0x000ea20000002300ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x00000400ff0a7b82ULL, 0x000f620000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000800087308ULL, 0x010f240000001000ULL,
0x0ffffffe08067836ULL, 0x010fcc0000000000ULL, 0x0000000600077305ULL, 0x0008a4000021f000ULL,
0x000000ff00067202ULL, 0x010fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x006fc800078e0a07ULL,
0x0000001b0c057224ULL, 0x000fc800078e02ffULL, 0x0000000507077227ULL, 0x000fe400078e0006ULL,
0x0000000000057919ULL, 0x000e680000002200ULL, 0x0000000a07077227ULL, 0x020fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea60000002600ULL, 0x000000ffff027224ULL, 0x000fc800078e0a07ULL,
0x000000021b027224ULL, 0x000fe400078e020aULL, 0x00008400ff0aab82ULL, 0x000f260000000800ULL,
0x0000001b0200720cULL, 0x000fda0003f06070ULL, 0x0000000102020824ULL, 0x000fe400078e0a1bULL,
0x0000000107070836ULL, 0x000fc60000000000ULL, 0x0000001b0200720cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x0000001bff07b212ULL, 0x000fc800078e33ffULL,
0x0000000700047306ULL, 0x000f620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000400047308ULL, 0x020f640000001000ULL, 0x0ffffffe04037836ULL, 0x020fe40000000000ULL,
0x0000000412047c24ULL, 0x002fe2000f8e0205ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00001fff12127589ULL, 0x000f2400000e0000ULL, 0x0000000300037305ULL, 0x000e62000021f000ULL,
0x0000000404057c24ULL, 0x000fca000f8e0209ULL, 0x0000007f0500780cULL, 0x000fe20003f64070ULL,
0x0000000307027224ULL, 0x002fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fd000078e0a02ULL,
0x000000000008b919ULL, 0x000e620000008800ULL, 0x000000ffff027224ULL, 0x000fc800078e00ffULL,
0x0000000b03027227ULL, 0x000fcc00078e0002ULL, 0x0000000602027227ULL, 0x004fca00078e00ffULL,
0x000000ff02037210ULL, 0x000fca0007ffe1ffULL, 0x0000000307047224ULL, 0x000fe200078e0206ULL,
0x000004000003b802ULL, 0x000fc80000000f00ULL, 0x000000070400720cULL, 0x000fe40003f06070ULL,
0x000006540808b816ULL, 0x002fe40000000003ULL, 0x00000005ff037819ULL, 0x000fe20000011609ULL,
0xff317217ff09b424ULL, 0x000fe400078e00ffULL, 0x000000040508b824ULL, 0x000fcc00078e0208ULL,
0x0000000104040824ULL, 0x000fe200078e0a07ULL, 0x00001fff03037589ULL, 0x000f2200000e0000ULL,
0x0000000102020836ULL, 0x000fe20000000000ULL, 0x000000ff0500720cULL, 0x000fe40003f05270ULL,
0x000000070400720cULL, 0x000fda0003f26070ULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff02c212ULL, 0x000fe400078e33ffULL, 0x0000000f0500780cULL, 0x040fe40003f24070ULL,
0x000000030500780cULL, 0x000fe20003f84070ULL, 0x000000ffff047224ULL, 0x000fc800078e0a02ULL,
0x0000000407047224ULL, 0x000fe400078e0206ULL, 0x000000010e0e2824ULL, 0x008fcc00078e0a0fULL,
0x00008400ff0eab82ULL, 0x000ee20000000800ULL, 0x0000000000240947ULL, 0x010fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01e60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000405067c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01e60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000405057c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01e68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000504047819ULL, 0x000fe200000006ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000057919ULL, 0x000e620000002500ULL, 0x000000040e077c24ULL, 0x008fe4000f8e02ffULL,
0x000000ffff067224ULL, 0x000fe200078e0a04ULL, 0x01e400090800b388ULL, 0x0005e20000000800ULL,
0x0000000a1f0fa224ULL, 0x000fe200078e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000040700720cULL, 0x000fe20003f06070ULL, 0x000000041b187c24ULL, 0x000fe2000f8e02ffULL,
0x0000002007067446ULL, 0x000fe20003800006ULL, 0x0000000412087824ULL, 0x004fc400078e0203ULL,
0x000000180f077224ULL, 0x000fe200078e02ffULL, 0x000000ff06067207ULL, 0x000fe20000000000ULL,
0x0000000408097824ULL, 0x000fe400078e00ffULL, 0x0000000402197c24ULL, 0x000fe2000f8e0207ULL,
0x000000200600780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x002fea0003800000ULL,
0x00000004000d7d06ULL, 0x000e620008209000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000000001a7919ULL, 0x000eea0000008800ULL,
0x0000000d000d7308ULL, 0x002e640000001000ULL, 0x0ffffffe0d0b7810ULL, 0x002fc40007ffe0ffULL,
0x00000004ff0c7819ULL, 0x004fc80000011608ULL, 0x0000000b000b7305ULL, 0x000e62000021f000ULL,
0x000000020c147836ULL, 0x000fe40000000000ULL, 0x0000000109157824ULL, 0x000fc600078e020cULL,
0x0000001409177210ULL, 0x000fca0007ffe0ffULL, 0x0000000104167824ULL, 0x000fe400078e0217ULL,
0x000000ffff117224ULL, 0x002fc800078e0a0bULL, 0x0000000411117c24ULL, 0x000fc8000f8e02ffULL,
0x000000110b0d7227ULL, 0x000fc800078e000aULL, 0x00000001040a7824ULL, 0x000fe400078e0215ULL,
0x000000160d117227ULL, 0x000fc800078e00ffULL, 0x0000000a0d0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe200078e0a11ULL, 0x000000ff0b0d7210ULL, 0x000fc60007ffe1ffULL,
0x0000000413107c24ULL, 0x000fe4000f8e0216ULL, 0x000000040d0d7c24ULL, 0x000fc6000f8e020aULL,
0x0000000410007c0cULL, 0x000fe4000bf46070ULL, 0x000000040d007c0cULL, 0x000fd6000bf06070ULL,
0x8000000410102c36ULL, 0x000fe40008000000ULL, 0x800000040d0d0c36ULL, 0x000fe20008000000ULL,
0x000000010b0b0810ULL, 0x000fe20007ffe0ffULL, 0x0000000111112836ULL, 0x000fe20000000000ULL,
0x0000000410007c0cULL, 0x000fe4000bf66070ULL, 0x000000040d007c0cULL, 0x000fe4000bf26070ULL,
0x00000004ff007c0cULL, 0x000fe4000bf05070ULL, 0x00000004ff107c12ULL, 0x000fce000f8e33ffULL,
0x0000000111113836ULL, 0x000fe40000000000ULL, 0x000000010b0b1836ULL, 0x000fc60000000000ULL,
0x0000001110117207ULL, 0x040fe40004000000ULL, 0x0000000b100b7207ULL, 0x000fc60004000000ULL,
0x000000ffff137224ULL, 0x000fe200078e0a11ULL, 0x000000ff0b0d7210ULL, 0x000fc60007ffe1ffULL,
0x0000000413167c24ULL, 0x000fe2000f8e0216ULL, 0x0000040000137802ULL, 0x000fe20000000f00ULL,
0x000000040d0d7c24ULL, 0x000fe2000f8e020aULL, 0x00000009060a7248ULL, 0x000fe20007fe0000ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000001619167210ULL, 0x000fe20007ffe0ffULL,
0x0000000119107824ULL, 0x000fe400078e020dULL, 0x000000010a097824ULL, 0x000fe200078e0a09ULL,
0x000006541a0a7816ULL, 0x008fe20000000013ULL, 0x0000001008137824ULL, 0x000fc400078e00ffULL,
0x0000001811117224ULL, 0x080fe200078e0216ULL, 0x000000090c00720cULL, 0x080fe20003f06070ULL,
0x000000180b0c7224ULL, 0x000fe200078e0210ULL, 0x000000091400720cULL, 0x000fe20003f26070ULL,
0x0000010011107825ULL, 0x000fe200078e00ffULL, 0x000000f013097812ULL, 0x000fe400078ec0ffULL,
0x0000000817147210ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fc800078e00ffULL,
0x00000001150b7824ULL, 0x040fe200078e0208ULL, 0x000000090c0c7212ULL, 0x080fe200078efcffULL,
0x0000001015167824ULL, 0x000fe200078e00ffULL, 0x0000000910097212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x000fe200078e00ffULL, 0x000000040c0c7c10ULL, 0x000fe4000ff5e0ffULL,
0xfffffff0160b7812ULL, 0x000fe400078ee20bULL, 0x0000000409107c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff017097812ULL, 0x000fe200078ee214ULL, 0x000000100b0b7824ULL, 0x000fe200078e020aULL,
0x000000050d0d7c10ULL, 0x000fc400097fe4ffULL, 0x0000000511117c10ULL, 0x000fe20009ffe4ffULL,
0x0000001009097824ULL, 0x000fe400078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e8000c101c46ULL, 0x0000000010097faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x00000004000c7d06ULL, 0x000e620008209000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x000000ffff0a7224ULL, 0x000fcc00078e00ffULL,
0x0000000c000c7308ULL, 0x002e640000001000ULL, 0x0ffffffe0c107810ULL, 0x002fe40007ffe0ffULL,
0x0000000908097211ULL, 0x004fc800078fe0ffULL, 0x00000010000b7305ULL, 0x000e62000021f000ULL,
0x0000001008137824ULL, 0x000fe400078e00ffULL, 0x0000000209157836ULL, 0x000fc60000000000ULL,
0x000000f013177812ULL, 0x000fe200078ec0ffULL, 0x0000001015167824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a0bULL, 0x000000040d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d0b117227ULL, 0x000fe200078e000aULL, 0x00000009040a7210ULL, 0x000fc60007ffe0ffULL,
0x00000001040d7824ULL, 0x000fe400078e0215ULL, 0x0000000a110b7227ULL, 0x000fc800078e00ffULL,
0x0000000d11107227ULL, 0x000fc800078e00ffULL, 0x000000ffff117224ULL, 0x000fe400078e0a0bULL,
0x000000ffff147224ULL, 0x000fe400078e0a10ULL, 0x00000004110c7c24ULL, 0x000fe4000f8e020aULL,
0x0000000414117c24ULL, 0x000fe4000f8e020dULL, 0x0000000000147919ULL, 0x000e620000008800ULL,
0x000000040c007c0cULL, 0x000fe4000bf06070ULL, 0x0000000411007c0cULL, 0x000fd6000bf46070ULL,
0x800000040c0c0c10ULL, 0x000fe2000fffe0ffULL, 0x000000010b0b0836ULL, 0x000fe20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bf05070ULL, 0x8000000411112c36ULL, 0x000fe20008000000ULL,
0x000000040c007c0cULL, 0x000fe2000bf26070ULL, 0x0000000110102836ULL, 0x000fe20000000000ULL,
0x00000004ff0c7c12ULL, 0x000fe4000f8e33ffULL, 0x0000000411007c0cULL, 0x000fd2000bf66070ULL,
0x000000010b0b1810ULL, 0x000fc80007ffe0ffULL, 0x0000000110103836ULL, 0x000fe20000000000ULL,
0x0000000b0c0b7207ULL, 0x000fc80004000000ULL, 0x000000100c107207ULL, 0x000fe20004000000ULL,
0x000000ffff117224ULL, 0x000fc800078e0a0bULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a10ULL,
0x00000004110a7c24ULL, 0x000fe2000f8e020aULL, 0x0000040000117802ULL, 0x000fe20000000f00ULL,
0x000000040c0d7c24ULL, 0x000fe2000f8e020dULL, 0x00008c0000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000a190a7210ULL, 0x000fe20007ffe0ffULL, 0x00000001190d7824ULL, 0x000fc800078e020dULL,
0x000000180b0c7224ULL, 0x080fe200078e020aULL, 0x00000654140a7816ULL, 0x002fe20000000011ULL,
0x0000001810107224ULL, 0x000fe200078e020dULL, 0x0000000409147819ULL, 0x000fe200000006ffULL,
0x000001000c0c7825ULL, 0x000fc800078e00ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000170c0c7212ULL, 0x000fc600078efcffULL, 0x00000001090b7824ULL, 0x100fe200078e0208ULL,
0x0000001710107212ULL, 0x000fe200078efcffULL, 0x0000000115097824ULL, 0x000fe200078e0208ULL,
0x000000040c0c7c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff0140b7812ULL, 0x000fe400078ee20bULL,
0x0000000410107c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff016097812ULL, 0x000fe200078ee209ULL,
0x000000100b0b7824ULL, 0x000fe200078e020aULL, 0x000000050d0d7c10ULL, 0x000fc400087fe4ffULL,
0x0000000511117c10ULL, 0x000fe40008ffe4ffULL, 0x0000000a09097211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e8000b901c46ULL,
0x0000000010097faeULL, 0x0003e4000b901c46ULL, 0x000000000a0472caULL, 0x000fe200000e0000ULL,
0x00009400ff107b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001e60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000041f107825ULL, 0x002fe200078e0010ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000610097981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1200720cULL, 0x000fe20003f05270ULL, 0x0000003f090b7836ULL, 0x004fe40000000000ULL,
0x000000ff090c7836ULL, 0x000fc60000000000ULL, 0x00000006ff0b7819ULL, 0x000fe4000001160bULL,
0x00000008ff0c7819ULL, 0x000fca000001160cULL, 0x000000dc00008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011603ULL, 0x00000004ff157424ULL, 0x000fe200078e00ffULL,
0xffffffff00107802ULL, 0x000fe40000000f00ULL, 0x03ffffff0d0e7812ULL, 0x000fca00078ec0ffULL,
0x0000000405397824ULL, 0x000fca00078e020eULL, 0x0000000b3900720cULL, 0x000fda0003f06070ULL,
0x00009600ff0f8b82ULL, 0x000e620000000800ULL, 0x000000011f0e8819ULL, 0x000fce00000006ffULL,
0x00009200ff168b82ULL, 0x000ea20000000a00ULL, 0x0000000f0e0e8224ULL, 0x002fe400078e020fULL,
0x00000008030f7824ULL, 0x000fe400078e00ffULL, 0x0000000139118824ULL, 0x000fe400078e020eULL,
0x000000010a0e7824ULL, 0x000fe400078e020fULL, 0x0000000411168825ULL, 0x004fe400078e0016ULL,
0x01e688150eff79a7ULL, 0x0003e6000850003fULL, 0x0000000616108981ULL, 0x000ea2000c1e1900ULL,
0x0000000105197836ULL, 0x000fe20000000000ULL, 0x00000001ff277819ULL, 0x000fc80000011603ULL,
0x0000000c1900720cULL, 0x000fe20003f06070ULL, 0x00000020270e7824ULL, 0x002fe200078e00ffULL,
0x00009000ff147b82ULL, 0x000e620000000a00ULL, 0x0000001b10107224ULL, 0x004fe400078e02ffULL,
0x00000100051b7824ULL, 0x000fc600078e020eULL, 0x0000000610117819ULL, 0x000fe200000006ffULL,
0x0000004002107824ULL, 0x000fc800078e00ffULL, 0x0000010011147825ULL, 0x002fe200078e0014ULL,
0x0000000103117812ULL, 0x000fe400078ec0ffULL, 0x0000002010327812ULL, 0x000fe200078ef81bULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x0000007013127812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x00000003ff217819ULL, 0x000fe40000011608ULL,
0x0000001b09187248ULL, 0x000fe20007fe0000ULL, 0x0000008011127824ULL, 0x000fe200078e0212ULL,
0x0000002132177210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0a1bULL,
0x0000000821297810ULL, 0x000fe20007ffe0ffULL, 0x0000000421197836ULL, 0x000fe20000000000ULL,
0x0000001c21337810ULL, 0x000fe20007ffe0ffULL, 0x0000010017167825ULL, 0x000fe200078e0012ULL,
0x00000020181e7446ULL, 0x000fc4000380001bULL, 0x0000000821187210ULL, 0x000fe20007ffe0ffULL,
0x0000000819257824ULL, 0x000fe200078e00ffULL, 0x00000016141c7210ULL, 0x000fe20007f1e0ffULL,
0x0000400027167824ULL, 0x000fe200078e020aULL, 0x0000000718237812ULL, 0x000fe200078ec0ffULL,
0x00000010212d7836ULL, 0x000fe20000000000ULL, 0x00000008191a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001151d7824ULL, 0x000fe200000e0617ULL, 0x0000001e2100720cULL, 0x080fe20003f06070ULL,
0x0000000132177824ULL, 0x000fe200078e0219ULL, 0x0000001e1900720cULL, 0x000fe20003f26070ULL,
0x0000200011207824ULL, 0x000fe200078e0216ULL, 0x0ffffff823237812ULL, 0x000fe200078ef808ULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0xfffffff825257812ULL, 0x000fc400078ee21aULL,
0x0000001e2900720cULL, 0x080fe20003fa6070ULL, 0x0001600020227836ULL, 0x000fe20000000000ULL,
0x0000001614167210ULL, 0x000fe20007f5e0ffULL, 0x0000000c212b7836ULL, 0x000fe40000000000ULL,
0x0000001023237824ULL, 0x100fe200078e0222ULL, 0x0000001715177210ULL, 0x000fe200017fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0222ULL, 0x0000001e2b00720cULL, 0x080fe20003f86070ULL,
0x00000014212f7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c237faeULL, 0x0003e2000c101c46ULL, 0x0000001821317836ULL, 0x000fe20000000000ULL,
0x0000001e3300720cULL, 0x080fe20003f06070ULL, 0x0000000132217824ULL, 0x040fe200078e022dULL,
0x0000000016257faeULL, 0x0005e2000c901c46ULL, 0x0000000132197824ULL, 0x040fe200078e0229ULL,
0x0000001e3100720cULL, 0x000fe20003f26070ULL, 0x00000001321b7824ULL, 0x000fc400078e022bULL,
0x0000010019187825ULL, 0x000fe200078e0012ULL, 0x000000082b1d7210ULL, 0x002fc60007ffe0ffULL,
0x000000082b247824ULL, 0x000fe200078e00ffULL, 0x0000001814187210ULL, 0x000fe20007f7e0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e0012ULL, 0xfffffff824257812ULL, 0x004fe200078ee21dULL,
0x0000010021167825ULL, 0x000fe200078e0012ULL, 0x0000001a141a7210ULL, 0x000fc60007f5e0ffULL,
0x0000000132217824ULL, 0x000fe200078e022fULL, 0x00000016141c7210ULL, 0x000fe20007fde0ffULL,
0x0000000129207824ULL, 0x040fe200078e0208ULL, 0x0000001b151b7210ULL, 0x000fe200017fe4ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000001e2f00720cULL, 0x000fe20003f46070ULL,
0x00000001151d7824ULL, 0x000fe400030e0617ULL, 0x0000010021167825ULL, 0x000fe200078e0012ULL,
0xfffffff829237812ULL, 0x000fc600078ee220ULL, 0x0000000115197824ULL, 0x000fe200018e0619ULL,
0x0000001e2d00720cULL, 0x000fe20003f66070ULL, 0x000000012f217824ULL, 0x040fe200078e0208ULL,
0x000000082d1e7210ULL, 0x000fe20007ffe0ffULL, 0x000000082f247824ULL, 0x000fe200078e00ffULL,
0x0000001614207210ULL, 0x000fe20007fde0ffULL, 0x000000082d297824ULL, 0x000fe200078e00ffULL,
0x00000031322d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001322f7824ULL, 0x000fe200078e0233ULL,
0xfffffff8242b7812ULL, 0x000fe200078ee221ULL, 0x0000000115217824ULL, 0x000fe200030e0617ULL,
0xfffffff829297812ULL, 0x000fe200078ee21eULL, 0x000001002d167825ULL, 0x000fe200078e0012ULL,
0x00000003312d7819ULL, 0x000fc400000006ffULL, 0x0000002223237211ULL, 0x080fe200078e20ffULL,
0x0000000133247824ULL, 0x100fe200078e0208ULL, 0x0000001614167210ULL, 0x000fe20007fde0ffULL,
0x00000001311e7824ULL, 0x000fe400078e0208ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000018237faeULL, 0x0003e2000e901c46ULL, 0x000001002f127825ULL, 0x000fe200078e0012ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee21eULL, 0xfffffff8332f7812ULL, 0x000fe200078ee224ULL,
0x0000000115177824ULL, 0x000fe200030e0617ULL, 0x0000001214127210ULL, 0x000fe20007fde0ffULL,
0x0000001025257824ULL, 0x100fe200078e0222ULL, 0x000000222d2d7211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x000fc400078e0222ULL, 0x000000102b2b7824ULL, 0x100fe200078e0222ULL,
0x000000001a257faeULL, 0x0003e2000e101c46ULL, 0x000000102f2f7824ULL, 0x000fe400078e0222ULL,
0x0000000115137824ULL, 0x000fe200030e0613ULL, 0x000000001c297faeULL, 0x0003e8000d901c46ULL,
0x00000000202b7faeULL, 0x0003e8000d101c46ULL, 0x00000000162d7faeULL, 0x0003e8000c901c46ULL,
0x00000000122f7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000008081b7811ULL, 0x040fe400078fe8ffULL, 0x0000000408197811ULL, 0x040fe400078fe8ffULL,
0x0000000c081d7811ULL, 0x040fe200078fe8ffULL, 0x000000011b167824ULL, 0x100fe200078e0208ULL,
0x0000000319177819ULL, 0x000fe200000006ffULL, 0x000000081b217824ULL, 0x000fe200078e00ffULL,
0x0000001408237811ULL, 0x040fe200078fe8ffULL, 0x0000000119127824ULL, 0x100fe200078e0208ULL,
0x0000001808257811ULL, 0x000fe200078fe8ffULL, 0x0000000132197824ULL, 0x040fe200078e0219ULL,
0xfffffff821287812ULL, 0x000fe200078ee216ULL, 0x00000001321b7824ULL, 0x000fe200078e021bULL,
0x0000001008217811ULL, 0x040fe200078fe8ffULL, 0x0000000125187824ULL, 0x100fe200078e0208ULL,
0xfffffff817267812ULL, 0x000fe200078ee212ULL, 0x000000011d127824ULL, 0x140fe200078e0208ULL,
0x000000031d297819ULL, 0x000fe200000006ffULL, 0x0000000121167824ULL, 0x100fe200078e0208ULL,
0x00000003232e7819ULL, 0x000fe200000006ffULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8292a7812ULL, 0x000fe200078ee212ULL, 0x0000000123177824ULL, 0x000fe200078e0208ULL,
0x0000007013247812ULL, 0x000fe200078ec0ffULL, 0x00000008252d7824ULL, 0x000fe200078e00ffULL,
0x0000000808127211ULL, 0x000fe200078fe8ffULL, 0x0000000132297824ULL, 0x000fe200078e0225ULL,
0x0000001c08137811ULL, 0x000fe200078fe8ffULL, 0x0000000132217824ULL, 0x040fe200078e0221ULL,
0xfffffff82b2c7812ULL, 0x000fe200078ee216ULL, 0x0000400027167824ULL, 0x000fe200078e020aULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL, 0x00000001322b7824ULL, 0x000fe200078e0213ULL,
0xfffffff82d307812ULL, 0x000fe200078ee218ULL, 0x0000200011167824ULL, 0x000fe200078e0216ULL,
0x0000000712177812ULL, 0x000fe200078ec0ffULL, 0x0000000113127824ULL, 0x040fe200078e0208ULL,
0x00000003132d7819ULL, 0x000fe200000006ffULL, 0x0000000132237824ULL, 0x000fe200078e0223ULL,
0x0000002411247211ULL, 0x000fe200078e38ffULL, 0x0001600016377836ULL, 0x000fe20000000000ULL,
0x0000003208137211ULL, 0x000fc400078fe8ffULL, 0x000000ff00257202ULL, 0x000fe20000000f00ULL,
0x000000102c317824ULL, 0x100fe200078e0237ULL, 0x0000001d321d7210ULL, 0x000fe20007ffe0ffULL,
0x000000102e337824ULL, 0x000fe200078e0237ULL, 0xfffffff82d327812ULL, 0x000fe200078ee212ULL,
0x0000010013127825ULL, 0x100fe200078e0024ULL, 0x0ffffff8171e7812ULL, 0x000fe400078ef808ULL,
0x000000372a2f7211ULL, 0x000fe200078e20ffULL, 0x0000010019167825ULL, 0x000fe200078e0024ULL,
0x0000001214127210ULL, 0x000fc60007f1e0ffULL, 0x000001001b187825ULL, 0x000fe200078e0024ULL,
0x0000001614167210ULL, 0x000fc60007f3e0ffULL, 0x000001001d1a7825ULL, 0x000fe200078e0024ULL,
0x0000001814187210ULL, 0x000fc60007f5e0ffULL, 0x00000100211c7825ULL, 0x000fe200078e0024ULL,
0x0000001a141a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010023207825ULL, 0x000fe200078e0024ULL,
0x0000001b151b7210ULL, 0x000fc60001ffe4ffULL, 0x0000010029227825ULL, 0x000fc800078e0024ULL,
0x000001002b247825ULL, 0x000fc800078e0024ULL, 0x0000000115137824ULL, 0x040fe200000e0613ULL,
0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115177824ULL, 0x040fe200008e0617ULL,
0x0000002014207210ULL, 0x000fe20007f3e0ffULL, 0x000000101e297824ULL, 0x000fe400078e0237ULL,
0x0000000115197824ULL, 0x040fe200010e0619ULL, 0x0000002214227210ULL, 0x000fe20007f5e0ffULL,
0x00000010262b7824ULL, 0x100fe200078e0237ULL, 0x0000002414147210ULL, 0x000fe20007f7e0ffULL,
0x00000010282d7824ULL, 0x000fe200078e0237ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012297faeULL, 0x0003e2000b901c46ULL, 0x00000001151d7824ULL, 0x000fc400000e061dULL,
0x0000000115217824ULL, 0x040fe200008e0621ULL, 0x00000000162b7faeULL, 0x0003e2000b901c46ULL,
0x0000001030357824ULL, 0x000fe200078e0237ULL, 0x0000003732377211ULL, 0x000fe200078e20ffULL,
0x0000000115237824ULL, 0x000fe200010e0623ULL, 0x0000002515157210ULL, 0x000fe20001ffe4ffULL,
0x00000000182d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a2f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c317faeULL, 0x0003e8000b901c46ULL, 0x0000000020337faeULL, 0x0003e8000b901c46ULL,
0x0000000022357faeULL, 0x0003e8000b901c46ULL, 0x0000000014377faeULL, 0x0003e4000b901c46ULL,
0x0000000339137812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd00127811ULL, 0x000fe400078e10ffULL, 0x000000031300780cULL, 0x000fe40003f05270ULL,
0xffffffff00267802ULL, 0x000fe40000000f00ULL, 0x0000000112867807ULL, 0x000fca0004000000ULL,
0x0000000139867824ULL, 0x000fca00078e0286ULL, 0x0000000b8600720cULL, 0x000fda0003f06070ULL,
0x00009600ff168b82ULL, 0x000e620000000800ULL, 0x000000021f138824ULL, 0x000fce00078e00ffULL,
0x00009200ff148b82ULL, 0x000ea20000000a00ULL, 0x0000001613138224ULL, 0x002fc800078e0216ULL,
0x0000000113138824ULL, 0x000fc800078e0286ULL, 0x0000000413148825ULL, 0x004fca00078e0014ULL,
0x0000000614268981ULL, 0x000322000c1e1900ULL, 0x0000000c0500720cULL, 0x000fe20003f06070ULL,
0xff317217ff897424ULL, 0x000fe200078e00ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff807224ULL, 0x000fe200078e00ffULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fc4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000006e7805ULL, 0x000fe4000001ff00ULL, 0x00000000006c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000727805ULL, 0x000fe4000001ff00ULL, 0x0000000000707805ULL, 0x000fe4000001ff00ULL,
0x00000000007e7805ULL, 0x000fc4000001ff00ULL, 0x00000000007c7805ULL, 0x000fe4000001ff00ULL,
0x00000000007a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000787805ULL, 0x000fe4000001ff00ULL,
0x0000000000767805ULL, 0x000fe4000001ff00ULL, 0x0000000000747805ULL, 0x000fe4000001ff00ULL,
0x00000000005a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000007400700947ULL, 0x002fec0003800000ULL, 0x00009600ff147b82ULL, 0x000e620000000800ULL,
0x000000021f137824ULL, 0x000fe200078e00ffULL, 0xff31721700897802ULL, 0x000fe20000000f00ULL,
0x000000ffff4b7224ULL, 0x000fe400078e00ffULL, 0x0000001413137224ULL, 0x002fce00078e0214ULL,
0x00009000ff147b82ULL, 0x000e620000000a00ULL, 0x0000001003177824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001051b7836ULL, 0x000fe40000000000ULL,
0x0000000426267c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe017187812ULL, 0x000fe400078ec0ffULL,
0x0000000c1b00720cULL, 0x000fe20003f06070ULL, 0x0000004026197824ULL, 0x000fe400078e00ffULL,
0x0000010005187824ULL, 0x000fca00078e0218ULL, 0x0000004018187810ULL, 0x000fc80007ffe0ffULL,
0x0000002018177812ULL, 0x000fe200078ec0ffULL, 0x0000010019147825ULL, 0x002fc800078e0014ULL,
0x0000000110517824ULL, 0x000fe200078e0217ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x0000000408197819ULL, 0x000fe200000006ffULL,
0x000000ffff1a7224ULL, 0x000fe200078e0a18ULL, 0x0000001809177248ULL, 0x000fe20007fe0000ULL,
0x0000008003187824ULL, 0x000fe200078e00ffULL, 0x0000007019197812ULL, 0x000fe400078ec0ffULL,
0x00000003ff267819ULL, 0x100fe40000011608ULL, 0x0000008019187812ULL, 0x000fe200078ef818ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000d031c7819ULL, 0x000fe200000006ffULL,
0x00000001261b7824ULL, 0x040fe200078e0251ULL, 0x0000002017177446ULL, 0x000fe2000380001aULL,
0x0000000126217824ULL, 0x000fe200078e0208ULL, 0x0000000a27277211ULL, 0x000fe200078e70ffULL,
0x00000004264c7836ULL, 0x000fe20000000000ULL, 0x000020001c1c7812ULL, 0x000fe200078ec0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0018ULL, 0x0000000721217812ULL, 0x000fc400078ec0ffULL,
0x000000172600720cULL, 0x080fe20003f26070ULL, 0x000000014c237824ULL, 0x040fe200078e0251ULL,
0x0000001a141a7210ULL, 0x000fe20007f1e0ffULL, 0x000000014c257824ULL, 0x040fe200078e0208ULL,
0x00017000271c7810ULL, 0x000fe20007ffe01cULL, 0x0000010023227825ULL, 0x000fe200078e0018ULL,
0x0ffffff821217812ULL, 0x000fe400078ef808ULL, 0x000000034c4e7819ULL, 0x040fe200000006ffULL,
0x00000001151b7824ULL, 0x000fe200000e061bULL, 0x0000002214247210ULL, 0x000fe20007f5e0ffULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x000000174c00720cULL, 0x080fe20003f06070ULL,
0x0000000826227836ULL, 0x000fe20000000000ULL, 0xfffffff84e277812ULL, 0x000fe200078ee225ULL,
0x0000000115257824ULL, 0x000fe200010e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a217faeULL, 0x0003e2000c901c46ULL, 0x00000008224f7824ULL, 0x040fe200078e00ffULL,
0x0000000c264c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010264e7836ULL, 0x000fe20000000000ULL,
0x0000001c265c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001426507836ULL, 0x000fe20000000000ULL,
0x000000172200720cULL, 0x080fe20003fc6070ULL, 0x0000001826527836ULL, 0x000fe20000000000ULL,
0x000000174c00720cULL, 0x0c0fe20003fa6070ULL, 0x000000014c237824ULL, 0x000fe200078e0251ULL,
0x000000174e00720cULL, 0x080fe20003f86070ULL, 0x000000084c5e7824ULL, 0x000fe200078e00ffULL,
0x00000051221b7210ULL, 0x002fe20007ffe0ffULL, 0x00000001221a7824ULL, 0x000fe200078e0208ULL,
0x000000175000720cULL, 0x080fe20003f66070ULL, 0x0000001027217824ULL, 0x000fe200078e021cULL,
0x000000175200720cULL, 0x080fe20003f46070ULL, 0x000000014c277824ULL, 0x000fe200078e0208ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21aULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000000024217faeULL, 0x0003e2000c101c46ULL, 0x000000175c00720cULL, 0x000fc40003f26070ULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000001a14267210ULL, 0x000fe40007f1e0ffULL,
0x000000514e177210ULL, 0x000fe20007ffe0ffULL, 0x000000014e4c7824ULL, 0x000fe200078e0208ULL,
0xfffffff85e537812ULL, 0x000fe200078ee227ULL, 0x0000000115277824ULL, 0x000fe200000e061bULL,
0x0000000352617819ULL, 0x000fe200000006ffULL, 0x000000084e5d7824ULL, 0x000fe200078e00ffULL,
0x0000002214247210ULL, 0x002fe20007f1e0ffULL, 0x00000100171a7825ULL, 0x000fe200078e0018ULL,
0x0000000850217210ULL, 0x000fc40007ffe0ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee24cULL,
0x0000000850227824ULL, 0x040fe400078e00ffULL, 0x0000000150177824ULL, 0x000fe400078e0251ULL,
0x0000000115257824ULL, 0x000fe200000e0623ULL, 0x0000001a144c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001524e7824ULL, 0x000fe200078e0208ULL, 0xfffffff8225f7812ULL, 0x000fe200078ee221ULL,
0x0000010017227825ULL, 0x000fe200078e0018ULL, 0x0000005152217210ULL, 0x000fc40007ffe0ffULL,
0xfffffff861617812ULL, 0x000fe200078ee24eULL, 0x00000001154d7824ULL, 0x000fe200000e061bULL,
0x0000002214227210ULL, 0x000fe20007f1e0ffULL, 0x00000100211a7825ULL, 0x000fc800078e0018ULL,
0x000000015c177824ULL, 0x040fe200078e0251ULL, 0x0000001c5f517211ULL, 0x000fe200078e20ffULL,
0x000000015c217824ULL, 0x040fe400078e0208ULL, 0x0000000115237824ULL, 0x000fe200000e0623ULL,
0x0000001a141a7210ULL, 0x000fe20007f1e0ffULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x0000010017187825ULL, 0x000fe200078e0018ULL, 0x0000001b151b7210ULL, 0x000fe400007fe4ffULL,
0xfffffff85c637812ULL, 0x000fe200078ee221ULL, 0x000000104f177824ULL, 0x100fe200078e021cULL,
0x0000001814147210ULL, 0x000fe20007f1e0ffULL, 0x0000001053217824ULL, 0x000fc400078e021cULL,
0x000000105d4f7824ULL, 0x100fe200078e021cULL, 0x0000000026177faeULL, 0x0003e2000f101c46ULL,
0x0000001061537824ULL, 0x100fe400078e021cULL, 0x00000010635d7824ULL, 0x000fe200078e021cULL,
0x0000000024217faeULL, 0x0003e2000e901c46ULL, 0x0000000115157824ULL, 0x000fc600000e0619ULL,
0x000000004c4f7faeULL, 0x0003e8000e101c46ULL, 0x0000000022517faeULL, 0x0003e8000d901c46ULL,
0x000000001a537faeULL, 0x0003e8000d101c46ULL, 0x00000000145d7faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000200003187824ULL, 0x000fe200078e00ffULL,
0x00000004081b7811ULL, 0x040fe200078fe8ffULL, 0x0000001008177824ULL, 0x000fe200078e00ffULL,
0x0000000a27277211ULL, 0x000fe200078e70ffULL, 0x0000008003507824ULL, 0x000fe200078e00ffULL,
0x0000200018187812ULL, 0x000fe200078ec0ffULL, 0x000000081b1a7824ULL, 0x000fe200078e00ffULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x0000000808237811ULL, 0x000fe400078fe8ffULL,
0x0001700027187810ULL, 0x000fc40007ffe018ULL, 0x000000081b197210ULL, 0x000fe20007ffe0ffULL,
0x00000008231c7824ULL, 0x000fe200078e00ffULL, 0x0000000c08257811ULL, 0x040fe200078fe8ffULL,
0x000000011b1b7824ULL, 0x100fe200078e0251ULL, 0x0000001008277811ULL, 0x040fe400078fe8ffULL,
0x0000008017507812ULL, 0x000fe200078ef850ULL, 0x0000000123177824ULL, 0x100fe200078e0208ULL,
0xfffffff81a217812ULL, 0x000fe200078ee219ULL, 0x0000000825227824ULL, 0x000fe200078e00ffULL,
0x0000000825197210ULL, 0x000fe20007ffe0ffULL, 0x00000001271a7824ULL, 0x040fe200078e0208ULL,
0x00000014084d7811ULL, 0x040fe200078fe8ffULL, 0x00000008275f7824ULL, 0x000fe200078e00ffULL,
0x00000018084f7811ULL, 0x040fe200078fe8ffULL, 0x0000000123237824ULL, 0x100fe200078e0251ULL,
0xfffffff81c537812ULL, 0x000fe200078ee217ULL, 0x0000000127277824ULL, 0x100fe200078e0251ULL,
0x0000001c08657811ULL, 0x040fe200078fe8ffULL, 0x000000084f637824ULL, 0x000fe200078e00ffULL,
0x0000000808177211ULL, 0x000fe200078fe8ffULL, 0x0000001021217824ULL, 0x000fe200078e0218ULL,
0xfffffff8225d7812ULL, 0x000fe200078ee219ULL, 0x000000084d227824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee21aULL, 0x000000014f1a7824ULL, 0x000fe200078e0208ULL,
0x000000084d197210ULL, 0x000fe20007ffe0ffULL, 0x0000000865677824ULL, 0x000fe200078e00ffULL,
0x0000000717177812ULL, 0x000fe200078ec0ffULL, 0x000000014d4d7824ULL, 0x100fe200078e0251ULL,
0x00000008651c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014f4f7824ULL, 0x000fe200078e0251ULL,
0xfffffff822617812ULL, 0x000fe200078ee219ULL, 0x0000001053537824ULL, 0x100fe200078e0218ULL,
0xfffffff863637812ULL, 0x000fe200078ee21aULL, 0x000000105f5f7824ULL, 0x100fe200078e0218ULL,
0x0ffffff817177812ULL, 0x000fe200078ef808ULL, 0x0000001061617824ULL, 0x100fe200078e0218ULL,
0xfffffff867677812ULL, 0x000fe200078ee21cULL, 0x0000001063637824ULL, 0x100fe200078e0218ULL,
0x0000005125257210ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e0218ULL,
0x0000005165657210ULL, 0x000fc40007ffe0ffULL, 0x0000005108197211ULL, 0x000fe200078fe8ffULL,
0x000000ffff517224ULL, 0x000fe200078e00ffULL, 0x000000185d5d7211ULL, 0x080fe400078e20ffULL,
0x0000001867677211ULL, 0x000fe200078e20ffULL, 0x0000010019187825ULL, 0x000fc800078e0050ULL,
0x000001001b1a7825ULL, 0x000fe200078e0050ULL, 0x0000001814187210ULL, 0x000fc60007f1e0ffULL,
0x0000010023227825ULL, 0x000fe200078e0050ULL, 0x0000001a141a7210ULL, 0x000fc60007f3e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0050ULL, 0x0000002214227210ULL, 0x000fc60007f5e0ffULL,
0x0000010027267825ULL, 0x100fe200078e0050ULL, 0x0000002414247210ULL, 0x000fe40007f7e0ffULL,
0x0000002315237210ULL, 0x000fe200017fe4ffULL, 0x000001004d4c7825ULL, 0x000fc800078e0050ULL,
0x000001004f4e7825ULL, 0x000fc800078e0050ULL, 0x0000010065507825ULL, 0x000fe200078e0050ULL,
0x0000004e144e7210ULL, 0x000fc60007f5e0ffULL, 0x0000000115197824ULL, 0x040fe200000e0619ULL,
0x0000002614267210ULL, 0x000fe20007f1e0ffULL, 0x00000001151b7824ULL, 0x040fe200008e061bULL,
0x0000004c144c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000115257824ULL, 0x040fe200018e0625ULL,
0x0000005014147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115277824ULL, 0x040fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018177faeULL, 0x0003e2000b901c46ULL,
0x00000001154d7824ULL, 0x040fe200008e064dULL, 0x0000004f154f7210ULL, 0x000fe200017fe4ffULL,
0x0000000115157824ULL, 0x000fe200018e0651ULL, 0x000000001a217faeULL, 0x0003e8000b901c46ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x00000000245d7faeULL, 0x0003e8000b901c46ULL,
0x00000000265f7faeULL, 0x0003e8000b901c46ULL, 0x000000004c617faeULL, 0x0003e8000b901c46ULL,
0x000000004e637faeULL, 0x0003e8000b901c46ULL, 0x0000000014677faeULL, 0x0003e4000b901c46ULL,
0x0000000386147812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff00887802ULL, 0x000fe40000000f00ULL, 0x000000031400780cULL, 0x000fc80003f05270ULL,
0x0000000112157807ULL, 0x000fca0004000000ULL, 0x0000000115867824ULL, 0x000fca00078e0286ULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x0000000113178824ULL, 0x000fe200078e0286ULL, 0x000000100f187812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000000417148825ULL, 0x002fe200078e0014ULL,
0xffffffe00f177812ULL, 0x000fc800078ec0ffULL, 0x0000000a18177210ULL, 0x000fe20007ffe017ULL,
0x0000000614888981ULL, 0x000322000c1e1900ULL, 0x000000080f187812ULL, 0x000fca00078ec0ffULL,
0x0000000117817824ULL, 0x000fc800078e0218ULL, 0x01e6081a811a79a7ULL, 0x0002a6000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x01e6081b810075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x0000001814187210ULL, 0x000fc80007f1e1ffULL,
0x0000001915197210ULL, 0x000fe400007fe5ffULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc80000011419ULL,
0x0000001817177211ULL, 0x000fca00078110ffULL, 0x000000ffff187224ULL, 0x000fca00000e0619ULL,
0x0000000217177819ULL, 0x000fc80000001218ULL, 0x000000170000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01e6081b810075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001008147824ULL, 0x000fe200078e00ffULL, 0x00000001ff157819ULL, 0x000fe20000011608ULL,
0x000000ffff827224ULL, 0x000fe200078e0089ULL, 0x0000000a0d177211ULL, 0x000fe400078e38ffULL,
0x0000007014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c15157812ULL, 0x000fc800078ec0ffULL,
0x0000001715177210ULL, 0x000fca0007ffe014ULL, 0x01e0000017187984ULL, 0x000e680000000800ULL,
0x01e2000017877984ULL, 0x0004a20000000800ULL, 0x000000891800720bULL, 0x002fda0003f1d000ULL,
0x0000000000197806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff1900720cULL, 0x000fda0003f25270ULL, 0x00000004008c9947ULL, 0x004fea0003800000ULL,
0x000000030d00720cULL, 0x000fe40003f45270ULL, 0x000000891800720bULL, 0x0c0fe40003f34000ULL,
0x0000008918827209ULL, 0x000fd20007810000ULL, 0x000000800317a824ULL, 0x000fe400078e020aULL,
0x00000000001a7806ULL, 0x000fc600008e0100ULL, 0x000000171517a210ULL, 0x000fe40007ffe014ULL,
0x000000ff1a00720cULL, 0x000fc60003f25270ULL, 0x01e400821700a388ULL, 0x0003f40000000800ULL,
0x0000000400509947ULL, 0x002fea0003800000ULL, 0x0000008982177221ULL, 0x000fe20000010100ULL,
0x000000ff1aff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff001aff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b17177820ULL, 0x000fe20000410000ULL, 0x00ff00001aff7812ULL, 0x040fe4000786c0ffULL,
0xff0000001aff7812ULL, 0x000fe2000788c0ffULL, 0x00000017001c7308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff177819ULL, 0x002fcc0000011608ULL,
0x00001f171c177589ULL, 0x004e6400000e0000ULL, 0x0000001754547220ULL, 0x082fe20000410000ULL,
0x0000001755557220ULL, 0x080fe20000410000ULL, 0x0000001758587220ULL, 0x080fe20000410000ULL,
0x0000001759597220ULL, 0x080fe20000410000ULL, 0x0000001774747220ULL, 0x080fe20000410000ULL,
0x0000001775757220ULL, 0x080fe20000410000ULL, 0x0000001778787220ULL, 0x080fe20000410000ULL,
0x0000001779797220ULL, 0x080fe20000410000ULL, 0x000000177c7c7220ULL, 0x080fe20000410000ULL,
0x000000177d7d7220ULL, 0x080fe20000410000ULL, 0x0000001770707220ULL, 0x080fe20000410000ULL,
0x0000001771717220ULL, 0x080fe20000410000ULL, 0x000000176c6c7220ULL, 0x080fe20000410000ULL,
0x000000176d6d7220ULL, 0x080fe20000410000ULL, 0x0000001728287220ULL, 0x080fe20000410000ULL,
0x0000001729297220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000808177811ULL, 0x002fcc00078ff0ffULL, 0x00001f171c177589ULL, 0x004e6400000e0000ULL,
0x0000001756567220ULL, 0x082fe20000410000ULL, 0x0000001757577220ULL, 0x080fe20000410000ULL,
0x000000175a5a7220ULL, 0x080fe20000410000ULL, 0x000000175b5b7220ULL, 0x080fe20000410000ULL,
0x0000001776767220ULL, 0x080fe20000410000ULL, 0x0000001777777220ULL, 0x080fe20000410000ULL,
0x000000177a7a7220ULL, 0x080fe20000410000ULL, 0x000000177b7b7220ULL, 0x080fe20000410000ULL,
0x000000177e7e7220ULL, 0x080fe20000410000ULL, 0x000000177f7f7220ULL, 0x080fe20000410000ULL,
0x0000001772727220ULL, 0x080fe20000410000ULL, 0x0000001773737220ULL, 0x080fe20000410000ULL,
0x000000176e6e7220ULL, 0x080fe20000410000ULL, 0x000000176f6f7220ULL, 0x080fe20000410000ULL,
0x000000172a2a7220ULL, 0x080fe20000410000ULL, 0x000000172b2b7220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001008177811ULL, 0x002fcc00078ff0ffULL,
0x00001f171c177589ULL, 0x004e6400000e0000ULL, 0x000000172c2c7220ULL, 0x082fe20000410000ULL,
0x000000172d2d7220ULL, 0x080fe20000410000ULL, 0x0000001730307220ULL, 0x080fe20000410000ULL,
0x0000001731317220ULL, 0x080fe20000410000ULL, 0x0000001734347220ULL, 0x080fe20000410000ULL,
0x0000001735357220ULL, 0x080fe20000410000ULL, 0x0000001738387220ULL, 0x080fe20000410000ULL,
0x0000001739397220ULL, 0x080fe20000410000ULL, 0x000000173c3c7220ULL, 0x080fe20000410000ULL,
0x000000173d3d7220ULL, 0x080fe20000410000ULL, 0x0000001740407220ULL, 0x080fe20000410000ULL,
0x0000001741417220ULL, 0x080fe20000410000ULL, 0x0000001744447220ULL, 0x080fe20000410000ULL,
0x0000001745457220ULL, 0x080fe20000410000ULL, 0x0000001748487220ULL, 0x080fe20000410000ULL,
0x0000001749497220ULL, 0x000fce0000410000ULL, 0x0000001c80807220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001808177811ULL, 0x002fcc00078ff0ffULL,
0x00001f171c177589ULL, 0x000e6400000e0000ULL, 0x000000172e2e7220ULL, 0x082fe20000410000ULL,
0x000000172f2f7220ULL, 0x080fe20000410000ULL, 0x0000001732327220ULL, 0x080fe20000410000ULL,
0x0000001733337220ULL, 0x080fe20000410000ULL, 0x0000001736367220ULL, 0x080fe20000410000ULL,
0x0000001737377220ULL, 0x080fe20000410000ULL, 0x000000173a3a7220ULL, 0x080fe20000410000ULL,
0x000000173b3b7220ULL, 0x080fe20000410000ULL, 0x000000173e3e7220ULL, 0x080fe20000410000ULL,
0x000000173f3f7220ULL, 0x080fe20000410000ULL, 0x0000001742427220ULL, 0x080fe20000410000ULL,
0x0000001743437220ULL, 0x080fe20000410000ULL, 0x0000001746467220ULL, 0x080fe20000410000ULL,
0x0000001747477220ULL, 0x080fe20000410000ULL, 0x000000174a4a7220ULL, 0x080fe20000410000ULL,
0x000000174b4b7220ULL, 0x000fce0000410000ULL, 0x0000001a19ff7212ULL, 0x000fda00078230ffULL,
0x8000008218181221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b18181820ULL, 0x000fc80000410000ULL, 0x0000001800161308ULL, 0x000ea40000000800ULL,
0x0000001687871220ULL, 0x004fce0000410000ULL, 0x0000000808177812ULL, 0x002fe200078ec0ffULL,
0x0000000203897824ULL, 0x040fe200078e00ffULL, 0x0000000d03837819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000717237812ULL, 0x000fe400078ef808ULL,
0x0000000489697812ULL, 0x000fe400078ec0ffULL, 0x00000023081b7211ULL, 0x040fe200078fe0ffULL,
0x00000008231c7824ULL, 0x040fe200078e00ffULL, 0x0000006908187211ULL, 0x000fe200078fe0ffULL,
0x00000008231a7824ULL, 0x040fe200078e00ffULL, 0x00000010236b7812ULL, 0x000fe200078efcffULL,
0x000000021b197836ULL, 0x000fe20000000000ULL, 0xffffc00083217812ULL, 0x000fe200078ec0ffULL,
0x0000000123177824ULL, 0x000fe200078e0218ULL, 0x0000006b18187210ULL, 0x000fe20007ffe0ffULL,
0x000000086b257824ULL, 0x000fe200078e00ffULL, 0xfffffff81c197812ULL, 0x000fe200078ee219ULL,
0x000000010a1c7824ULL, 0x000fe200078e0221ULL, 0x0000000323277819ULL, 0x040fe200000006ffULL,
0x000000041b247836ULL, 0x000fe20000000000ULL, 0xfffffff825187812ULL, 0x000fe200078ee218ULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0x0000000a0d217211ULL, 0x000fe200078e60ffULL,
0x000000061b257836ULL, 0x000fe20000000000ULL, 0xfffffff81a177812ULL, 0x000fe200078ee217ULL,
0x0000200011227824ULL, 0x000fe200078e021cULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee21bULL,
0x0001200021687836ULL, 0x000fe20000000000ULL, 0xfffffff8271b7812ULL, 0x000fe200078ee224ULL,
0x0001600022247836ULL, 0x000fe20000000000ULL, 0xfffffff8261c7812ULL, 0x000fe200078ee225ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff267819ULL, 0x000fe40000011608ULL,
0x00000016ff1d723eULL, 0x000fe400000000ffULL, 0x00000008261e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001826207836ULL, 0x000fe20000000000ULL, 0x000054101d217816ULL, 0x000fe2000000001dULL,
0x0000001026227836ULL, 0x000fc80000000000ULL, 0x00001f1e211e7589ULL, 0x0002a800000e0000ULL,
0x00001f22211d7589ULL, 0x0002e800000e0000ULL, 0x00001f26211f7589ULL, 0x00026800000e0000ULL,
0x00001f2021207589ULL, 0x00026400000e0000ULL, 0x0000001017647824ULL, 0x000fe200078e0268ULL,
0x00000068184c7211ULL, 0x000fe200078e20ffULL, 0x000000101a607824ULL, 0x100fe400078e0224ULL,
0x00000010195c7824ULL, 0x100fe400078e0224ULL, 0x000000006464783bULL, 0x000ee20000000200ULL,
0x000000101b507824ULL, 0x000fc600078e0224ULL, 0x000000004c4c783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f64647232ULL, 0x08afe40000000000ULL,
0x0000001f66667232ULL, 0x000fe40000000000ULL, 0x0000001e65657232ULL, 0x084fe40000000000ULL,
0x0000001e67677232ULL, 0x000fe40000000000ULL, 0x0000001d4c4c7232ULL, 0x080fe40000000000ULL,
0x0000001d4e4e7232ULL, 0x000fc40000000000ULL, 0x000000204d4d7232ULL, 0x080fe40000000000ULL,
0x000000204f4f7232ULL, 0x000fce0000000000ULL, 0x000000005050783bULL, 0x000f620000004200ULL,
0x000000241c247211ULL, 0x000fe200078e20ffULL, 0x000000086b217824ULL, 0x002fe200078e00ffULL,
0x0000000269697812ULL, 0x000fe200078efcffULL, 0x000000006060783bULL, 0x000fe20000004200ULL,
0x00000001ff8b7819ULL, 0x000fe40000011603ULL, 0x0000006908227211ULL, 0x040fe200078fe0ffULL,
0x000000002424783bULL, 0x000e640000004200ULL, 0x000040008b8a7824ULL, 0x000fe200078e020aULL,
0x000000226b847210ULL, 0x000fe20007ffe0ffULL, 0x000000005c5c783bULL, 0x000e620000004200ULL,
0x0000000123857824ULL, 0x000fe200078e0222ULL, 0x0000006b08227211ULL, 0x000fc400078fe0ffULL,
0xfffffff821847812ULL, 0x000fe400078ee284ULL, 0xfffffff821217812ULL, 0x000fe200078ee222ULL,
0x00000050647c723cULL, 0x028fec000000187cULL, 0x000000504c3c723cULL, 0x004fec000000183cULL,
0x000000526470723cULL, 0x000fe20000001870ULL, 0x0000000823507824ULL, 0x000fc400078e00ffULL,
0x0000000222237836ULL, 0x000fe40000000000ULL, 0x000000086b517824ULL, 0x000fe200078e00ffULL,
0xfffffff850857812ULL, 0x000fe200078ee285ULL, 0x000000524c40723cULL, 0x000fe20000001840ULL,
0x0000008a11507211ULL, 0x000fc600078e68ffULL, 0x0000001085697824ULL, 0x000fe400078e0268ULL,
0x00000024646c723cULL, 0x002fe2000000186cULL, 0x000000086b527824ULL, 0x000fe400078e00ffULL,
0x0001600050507836ULL, 0x000fc60000000000ULL, 0x000000244c44723cULL, 0x000fec0000001844ULL,
0x000000604c2c723cULL, 0x000fe2000000182cULL, 0x0000000422247836ULL, 0x000fe40000000000ULL,
0x0000000622257836ULL, 0x000fe20000000000ULL, 0xfffffff852227812ULL, 0x000fc400078ee223ULL,
0x000000624c30723cULL, 0x000fe20000001830ULL, 0xfffffff851237812ULL, 0x000fca00078ee224ULL,
0x0000005c4c34723cULL, 0x000fec0000001834ULL, 0x0000005e4c38723cULL, 0x000fec0000001838ULL,
0x000000264c48723cULL, 0x000fec0000001848ULL, 0x0000005c6474723cULL, 0x000fe20000001874ULL,
0x00000010844c7824ULL, 0x000fca00078e0268ULL, 0x000000606454723cULL, 0x000fe20000001854ULL,
0x000000036b5c7819ULL, 0x000fe200000006ffULL, 0x000000004c4c783bULL, 0x000e660000000200ULL,
0xfffffff85c247812ULL, 0x000fe200078ee225ULL, 0x000000626458723cULL, 0x000fe20000001858ULL,
0x000000006968783bULL, 0x000ea20000000200ULL, 0x00000050215c7211ULL, 0x000fe200078e20ffULL,
0x0000001023607824ULL, 0x000fc600078e0250ULL, 0x0000005e6478723cULL, 0x000fec0000001878ULL,
0x000000266428723cULL, 0x000fee0000001828ULL, 0x0000001022647824ULL, 0x000fe200078e0250ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000208947ULL, 0x000fde0003800000ULL,
0x0000001f68687232ULL, 0x084fe40000000000ULL, 0x0000001f6a6a7232ULL, 0x000fe40000000000ULL,
0x0000001e69697232ULL, 0x080fe40000000000ULL, 0x0000001e6b6b7232ULL, 0x000fe40000000000ULL,
0x0000001d4c4c7232ULL, 0x082fe40000000000ULL, 0x0000001d4e4e7232ULL, 0x000fc40000000000ULL,
0x000000204d4d7232ULL, 0x080fe40000000000ULL, 0x000000204f4f7232ULL, 0x000fce0000000000ULL,
0x0000001024507824ULL, 0x000fe200078e0250ULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x00009000ff267b82ULL, 0x000f620000000a00ULL, 0xfffffff889257812ULL, 0x000fe200078ec0ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x000000006464783bULL, 0x000f620000004200ULL,
0x0000000488887c24ULL, 0x010fe4000f8e02ffULL, 0x000000010a257824ULL, 0x000fe200078e0225ULL,
0x000000005050783bULL, 0x000f280000004200ULL, 0x000000006060783bULL, 0x000f220000004200ULL,
0x0000005c4c2c723cULL, 0x00afec000000182cULL, 0x000000644c34723cULL, 0x020fec0000001834ULL,
0x00000050686c723cULL, 0x014fec000000186cULL, 0x000000504c44723cULL, 0x000fec0000001844ULL,
0x000000664c38723cULL, 0x000fe20000001838ULL, 0x0000000105517836ULL, 0x000fe20000000000ULL,
0x0000000100507802ULL, 0x000fc80000000f00ULL, 0x000000604c3c723cULL, 0x000fe2000000183cULL,
0x0000000c5100720cULL, 0x000fe20003f06070ULL, 0x01e6885025ff79a7ULL, 0x0003e8000850003fULL,
0x000000624c40723cULL, 0x000fec0000001840ULL, 0x0000005e4c30723cULL, 0x000fec0000001830ULL,
0x000000524c48723cULL, 0x000fec0000001848ULL, 0x0000005c6854723cULL, 0x000fe20000001854ULL,
0x00000008054c7824ULL, 0x000fe200078e028bULL, 0x00000006884f7819ULL, 0x000fe200000006ffULL,
0x0000008087887221ULL, 0x000fc60000010000ULL, 0x000000804c4e7811ULL, 0x000fe200078e28ffULL,
0x0000005e6858723cULL, 0x000fe20000001858ULL, 0x000001004f267825ULL, 0x000fe400078e0026ULL,
0x000000204e4d7812ULL, 0x000fc600078ec0ffULL, 0x000000646874723cULL, 0x000fec0000001874ULL,
0x000000666878723cULL, 0x000fec0000001878ULL, 0x00000060687c723cULL, 0x000fe2000000187cULL,
0x0000000110677824ULL, 0x000fca00078e024dULL, 0x000000626870723cULL, 0x000fec0000001870ULL,
0x000000526828723cULL, 0x000fe20000001828ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400908947ULL, 0x002fde0003800000ULL,
0x000000ffff517224ULL, 0x000fe200078e0a4eULL, 0x0000004e094c7248ULL, 0x000fe20007fe0000ULL,
0x00000080034d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff647819ULL, 0x100fe40000011608ULL,
0x000000204c517446ULL, 0x000fe40003800051ULL, 0x00000080144c7812ULL, 0x000fe200078ef84dULL,
0x00000001644d7824ULL, 0x000fe200078e0208ULL, 0x00000067644f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000464527836ULL, 0x000fe20000000000ULL, 0x0000200083837812ULL, 0x000fe200078ec0ffULL,
0x0000000864667836ULL, 0x000fe20000000000ULL, 0x000000074d637812ULL, 0x000fe200078ec0ffULL,
0x0000000852697824ULL, 0x040fe200078e00ffULL, 0x00000008524e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000152537824ULL, 0x100fe200078e0267ULL, 0x000000ff004d7202ULL, 0x000fe20000000f00ULL,
0x0000000c64687836ULL, 0x000fe20000000000ULL, 0xfffffff869697812ULL, 0x000fe200078ee24eULL,
0x00000001665d7824ULL, 0x000fe200078e0267ULL, 0x000000515200720cULL, 0x080fe20003f26070ULL,
0x000001004f4e7825ULL, 0x000fe200078e004cULL, 0x000000516400720cULL, 0x000fc40003f06070ULL,
0x000160008a8a7810ULL, 0x000fe20007ffe083ULL, 0x0000010053527825ULL, 0x000fe200078e004cULL,
0x0000004e26607210ULL, 0x000fe40007f5e0ffULL, 0x0ffffff863657812ULL, 0x000fe200078ef808ULL,
0x00000001685f7824ULL, 0x000fe200078e0267ULL, 0x0000005226627210ULL, 0x000fe20007f7e0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e004cULL, 0x0000001c648e7810ULL, 0x000fe40007ffe0ffULL,
0x0000005327637210ULL, 0x000fe20001ffe4ffULL, 0x000001005f5e7825ULL, 0x000fe200078e004cULL,
0x000000516600720cULL, 0x000fc40003fa6070ULL, 0x000000516800720cULL, 0x080fe20003f86070ULL,
0x0000000127617824ULL, 0x000fe200010e064fULL, 0x0000005c264e7210ULL, 0x000fe20007f5e0ffULL,
0x00000010646a7836ULL, 0x000fe20000000000ULL, 0x0000005e26527210ULL, 0x000fe20007f7e0ffULL,
0x0000001065657824ULL, 0x100fe400078e028aULL, 0x00000001274f7824ULL, 0x000fe200010e065dULL,
0x0000005f27537210ULL, 0x000fe20001ffe4ffULL, 0x00000010695d7824ULL, 0x000fe200078e028aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000060657faeULL, 0x0003e2000c101c46ULL,
0x000000016a5f7824ULL, 0x140fe200078e0267ULL, 0x000000516a00720cULL, 0x080fe20003f66070ULL,
0x0000001464807836ULL, 0x000fe20000000000ULL, 0x00000000625d7faeULL, 0x0005e2000c901c46ULL,
0x00000018648c7836ULL, 0x000fe20000000000ULL, 0x000000518e00720cULL, 0x080fe20003f06070ULL,
0x0000000166647824ULL, 0x000fe200078e0208ULL, 0x000000518000720cULL, 0x080fe20003f46070ULL,
0x0000000866697824ULL, 0x000fe200078e00ffULL, 0x000000518c00720cULL, 0x000fe20003f26070ULL,
0x0000000880837824ULL, 0x040fe200078e00ffULL, 0x0000000868607210ULL, 0x002fe20007ffe0ffULL,
0x0000000180617824ULL, 0x000fe200078e0267ULL, 0xfffffff869657812ULL, 0x000fe200078ee264ULL,
0x000000088e897824ULL, 0x000fe200078e00ffULL, 0x000000678c517210ULL, 0x000fe20007ffe0ffULL,
0x000001005f5c7825ULL, 0x004fc800078e004cULL, 0x0000000868637824ULL, 0x000fe200078e00ffULL,
0x0000005c265e7210ULL, 0x000fe20007fde0ffULL, 0x0000000180627824ULL, 0x000fc600078e0208ULL,
0xfffffff863697812ULL, 0x000fe200078ee260ULL, 0x00000001275f7824ULL, 0x000fe200030e065dULL,
0xfffffff883837812ULL, 0x000fe200078ee262ULL, 0x00000100615c7825ULL, 0x000fe200078e004cULL,
0x000000086a617210ULL, 0x000fc60007ffe0ffULL, 0x000000086a6a7824ULL, 0x000fe200078e00ffULL,
0x0000005c26607210ULL, 0x000fe20007fde0ffULL, 0x000000018e637824ULL, 0x040fe400078e0267ULL,
0x000000018e627824ULL, 0x000fe200078e0208ULL, 0xfffffff86a6b7812ULL, 0x000fe200078ee261ULL,
0x0000000127617824ULL, 0x000fe400030e065dULL, 0x00000100515c7825ULL, 0x000fe200078e004cULL,
0xfffffff889897812ULL, 0x000fc600078ee262ULL, 0x000000018c517824ULL, 0x040fe200078e0208ULL,
0x0000005c265c7210ULL, 0x000fe20007fde0ffULL, 0x00000100634c7825ULL, 0x000fe200078e004cULL,
0x000000038c8c7819ULL, 0x000fc600000006ffULL, 0x00000001275d7824ULL, 0x000fe200030e065dULL,
0xfffffff88c877812ULL, 0x000fe200078ee251ULL, 0x0000001069637824ULL, 0x100fe200078e028aULL,
0x0000008a65517211ULL, 0x080fe200078e20ffULL, 0x000000106b657824ULL, 0x100fe200078e028aULL,
0x0000004c26267210ULL, 0x000fe20007fde0ffULL, 0x0000001083677824ULL, 0x100fe200078e028aULL,
0x0000008a87697211ULL, 0x000fe200078e20ffULL, 0x00000010896b7824ULL, 0x000fe200078e028aULL,
0x000000004e517faeULL, 0x0003e2000e901c46ULL, 0x0000000127277824ULL, 0x000fc600030e064dULL,
0x0000000052637faeULL, 0x0003e8000e101c46ULL, 0x000000005e657faeULL, 0x0003e8000d901c46ULL,
0x0000000060677faeULL, 0x0003e8000d101c46ULL, 0x000000005c697faeULL, 0x0003e8000c901c46ULL,
0x00000000266b7faeULL, 0x0003e2000c101c46ULL, 0x00000004005c7947ULL, 0x000fea0003800000ULL,
0x00000004084f7811ULL, 0x040fe200078fe8ffULL, 0x0000008003657824ULL, 0x000fe200078e00ffULL,
0x0000200083837812ULL, 0x000fe400078ec0ffULL, 0x000000034f6b7819ULL, 0x040fe200000006ffULL,
0x000000014f4c7824ULL, 0x040fe200078e0208ULL, 0x0000000808537811ULL, 0x040fe200078fe8ffULL,
0x000000014f4f7824ULL, 0x000fe200078e0267ULL, 0x0000000c085d7811ULL, 0x040fe400078fe8ffULL,
0x0000001408617811ULL, 0x000fc400078fe8ffULL, 0x000160008a8a7810ULL, 0x000fe20007ffe083ULL,
0x0000000853837824ULL, 0x040fe200078e00ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee24cULL,
0x00000001534c7824ULL, 0x100fe200078e0208ULL, 0x00000010085f7811ULL, 0x040fe200078fe8ffULL,
0x000000015d4d7824ULL, 0x140fe200078e0208ULL, 0x000000035d527819ULL, 0x000fe200000006ffULL,
0x0000000161517824ULL, 0x140fe200078e0208ULL, 0x00000003615c7819ULL, 0x000fe200000006ffULL,
0x000000015f4e7824ULL, 0x040fe200078e0208ULL, 0xfffffff883837812ULL, 0x000fe200078ee24cULL,
0x000000085f897824ULL, 0x000fe200078e00ffULL, 0xfffffff852877812ULL, 0x000fe200078ee24dULL,
0x0000000153537824ULL, 0x100fe200078e0267ULL, 0xfffffff85c8b7812ULL, 0x000fe200078ee251ULL,
0x000000015f5f7824ULL, 0x100fe200078e0267ULL, 0x00000008084c7211ULL, 0x040fe200078fe8ffULL,
0x0000000161617824ULL, 0x000fe200078e0267ULL, 0x00000018084d7811ULL, 0x000fc400078fe8ffULL,
0x0000001c08517811ULL, 0x000fe400078fe8ffULL, 0x000000074c697812ULL, 0x000fe200078ec0ffULL,
0x000000014d637824ULL, 0x040fe200078e0267ULL, 0xfffffff889897812ULL, 0x000fe200078ee24eULL,
0x000000084d8d7824ULL, 0x000fe200078e00ffULL, 0x000000084d4c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001514e7824ULL, 0x040fe200078e0208ULL, 0x0000008014647812ULL, 0x000fe200078ef865ULL,
0x00000008518f7824ULL, 0x000fe200078e00ffULL, 0x00000067084d7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0x000000675d5d7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff88d8d7812ULL, 0x000fe200078ee24cULL, 0x000001004d4c7825ULL, 0x100fe200078e0064ULL,
0xfffffff88f8f7812ULL, 0x000fe400078ee24eULL, 0x0000006751517210ULL, 0x000fe20007ffe0ffULL,
0x000001004f4e7825ULL, 0x100fe200078e0064ULL, 0x0000004c264c7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff869697812ULL, 0x000fe200078ef808ULL, 0x0000010053527825ULL, 0x000fe200078e0064ULL,
0x0000004e264e7210ULL, 0x000fc60007f3e0ffULL, 0x000001005d5c7825ULL, 0x000fe200078e0064ULL,
0x0000005226527210ULL, 0x000fc60007f5e0ffULL, 0x000001005f5e7825ULL, 0x100fe200078e0064ULL,
0x0000005c265c7210ULL, 0x000fe40007f7e0ffULL, 0x0000005327537210ULL, 0x000fe200017fe4ffULL,
0x0000010061607825ULL, 0x000fc800078e0064ULL, 0x0000010063627825ULL, 0x000fc800078e0064ULL,
0x0000010051647825ULL, 0x000fe200078e0064ULL, 0x0000006226627210ULL, 0x000fc60007f5e0ffULL,
0x00000001274d7824ULL, 0x040fe200000e064dULL, 0x0000005e265e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001274f7824ULL, 0x000fe200008e064fULL, 0x0000006026607210ULL, 0x000fe20007f3e0ffULL,
0x0000001069517824ULL, 0x100fe200078e028aULL, 0x0000008a83697211ULL, 0x080fe200078e20ffULL,
0x000000106b677824ULL, 0x100fe200078e028aULL, 0x0000006327637210ULL, 0x000fe200017fe4ffULL,
0x00000001275d7824ULL, 0x000fe200018e065dULL, 0x0000006426267210ULL, 0x000fe20007f7e0ffULL,
0x00000010876b7824ULL, 0x100fe200078e028aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c517faeULL, 0x0003e2000b901c46ULL, 0x0000001089837824ULL, 0x100fe200078e028aULL,
0x0000008a8d897211ULL, 0x000fe200078e20ffULL, 0x00000001275f7824ULL, 0x000fe200000e065fULL,
0x000000004e677faeULL, 0x0003e2000b901c46ULL, 0x000000108b877824ULL, 0x000fc400078e028aULL,
0x0000000127617824ULL, 0x000fe200008e0661ULL, 0x0000000052697faeULL, 0x0003e2000b901c46ULL,
0x000000108f8b7824ULL, 0x000fe400078e028aULL, 0x0000000127277824ULL, 0x000fe200018e0665ULL,
0x000000005c6b7faeULL, 0x0003e8000b901c46ULL, 0x000000005e837faeULL, 0x0003e8000b901c46ULL,
0x0000000060877faeULL, 0x0003e8000b901c46ULL, 0x0000000062897faeULL, 0x0003e8000b901c46ULL,
0x00000000268b7faeULL, 0x0003e4000b901c46ULL, 0x0000000386267812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff00837802ULL, 0x000fe40000000f00ULL,
0x000000032600780cULL, 0x000fc80003f05270ULL, 0x0000000112277807ULL, 0x000fca0004000000ULL,
0x0000000186867824ULL, 0x000fca00078e0227ULL, 0x0000000b8600720cULL, 0x000fda0003f06070ULL,
0x00009200ff268b82ULL, 0x000e620000000a00ULL, 0x00000001134d8824ULL, 0x000fc800078e0286ULL,
0x000000044d268825ULL, 0x002fca00078e0026ULL, 0x0000000626838981ULL, 0x000322000c1e1900ULL,
0x01e62850815079a7ULL, 0x0002a4000850003fULL, 0x0000000000267805ULL, 0x002fce0000015200ULL,
0xffffffe00f4d7812ULL, 0x040fe400078ec0ffULL, 0x000000100f4c7812ULL, 0x040fe400078ec0ffULL,
0x000000080f807812ULL, 0x000fe400078ec0ffULL, 0x0000000a4c4d7210ULL, 0x000fca0007ffe04dULL,
0x000000014d807824ULL, 0x000fc800078e0280ULL, 0x01e62851800075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff4e7224ULL, 0x000fce00078e00ffULL,
0x000000104e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000004c7805ULL, 0x000fce0000015200ULL, 0x0000004c264f7210ULL, 0x000fca0007f1e1ffULL,
0x000000014d4d7824ULL, 0x000fe200000e0e27ULL, 0x003d09004f00780cULL, 0x000fc80003f06070ULL,
0x000000ff4d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404f00780cULL, 0x000fc80003f06070ULL, 0x000000ff4d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff4c7819ULL, 0x000fc8000001144dULL,
0x0000004f4c4c7211ULL, 0x000fc800078110ffULL, 0x0000004dff4d7210ULL, 0x000fc800007fe4ffULL,
0x000000024c4c7819ULL, 0x000fc8000000124dULL, 0x0000004c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014e4e7836ULL, 0x000fce0000000000ULL,
0x01e62851800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002003267824ULL, 0x000fca00078e00ffULL, 0xffffff8026277812ULL, 0x000fc800078ec0ffULL,
0x000000800a277810ULL, 0x000fc80007ffe027ULL, 0x0000002715277210ULL, 0x000fca0007ffe014ULL,
0x01e00000274d7984ULL, 0x000e680000000800ULL, 0x01e2000027817984ULL, 0x0004a20000000800ULL,
0x000000824d00720bULL, 0x002fda0003f1d000ULL, 0x00000000004c7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff4c00720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x004fea0003800000ULL, 0x000000010d267836ULL, 0x000fe20000000000ULL,
0x000000824d00720bULL, 0x000fc80003f14000ULL, 0x000000032600720cULL, 0x000fda0003f25270ULL,
0x0000000a03279211ULL, 0x000fe400078e38ffULL, 0x000000824d269209ULL, 0x000fe40007810000ULL,
0x00000027154f9210ULL, 0x000fe40007ffe014ULL, 0x0000000000277806ULL, 0x000fc600000e0100ULL,
0x01e400264f009388ULL, 0x0003e20000000800ULL, 0x000000ff2700720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000824d4f7209ULL, 0x000fe40007810000ULL,
0x000000ff27ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0027ff7812ULL, 0x000fe2000782c0ffULL,
0x000000824f267221ULL, 0x000fe20000010100ULL, 0x00ff000027ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000027ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026004f7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff267819ULL, 0x002fcc0000011608ULL, 0x00001f264f267589ULL, 0x004e6400000e0000ULL,
0x0000005426547220ULL, 0x042fe20000410000ULL, 0x0000005526557220ULL, 0x040fe20000410000ULL,
0x0000005826587220ULL, 0x040fe20000410000ULL, 0x0000005926597220ULL, 0x040fe20000410000ULL,
0x0000007426747220ULL, 0x040fe20000410000ULL, 0x0000007526757220ULL, 0x040fe20000410000ULL,
0x0000007826787220ULL, 0x040fe20000410000ULL, 0x0000007926797220ULL, 0x040fe20000410000ULL,
0x0000007c267c7220ULL, 0x040fe20000410000ULL, 0x0000007d267d7220ULL, 0x040fe20000410000ULL,
0x0000007026707220ULL, 0x040fe20000410000ULL, 0x0000007126717220ULL, 0x040fe20000410000ULL,
0x0000006c266c7220ULL, 0x040fe20000410000ULL, 0x0000006d266d7220ULL, 0x040fe20000410000ULL,
0x0000002826287220ULL, 0x040fe20000410000ULL, 0x0000002926297220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000808267811ULL, 0x002fcc00078ff0ffULL,
0x00001f264f267589ULL, 0x004e6400000e0000ULL, 0x0000005626567220ULL, 0x042fe20000410000ULL,
0x0000005726577220ULL, 0x040fe20000410000ULL, 0x0000005a265a7220ULL, 0x040fe20000410000ULL,
0x0000005b265b7220ULL, 0x040fe20000410000ULL, 0x0000007626767220ULL, 0x040fe20000410000ULL,
0x0000007726777220ULL, 0x040fe20000410000ULL, 0x0000007a267a7220ULL, 0x040fe20000410000ULL,
0x0000007b267b7220ULL, 0x040fe20000410000ULL, 0x0000007e267e7220ULL, 0x040fe20000410000ULL,
0x0000007f267f7220ULL, 0x040fe20000410000ULL, 0x0000007226727220ULL, 0x040fe20000410000ULL,
0x0000007326737220ULL, 0x040fe20000410000ULL, 0x0000006e266e7220ULL, 0x040fe20000410000ULL,
0x0000006f266f7220ULL, 0x040fe20000410000ULL, 0x0000002a262a7220ULL, 0x040fe20000410000ULL,
0x0000002b262b7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001008267811ULL, 0x002fcc00078ff0ffULL, 0x00001f264f267589ULL, 0x004e6400000e0000ULL,
0x0000002c262c7220ULL, 0x042fe20000410000ULL, 0x0000002d262d7220ULL, 0x040fe20000410000ULL,
0x0000003026307220ULL, 0x040fe20000410000ULL, 0x0000003126317220ULL, 0x040fe20000410000ULL,
0x0000003426347220ULL, 0x040fe20000410000ULL, 0x0000003526357220ULL, 0x040fe20000410000ULL,
0x0000003826387220ULL, 0x040fe20000410000ULL, 0x0000003926397220ULL, 0x040fe20000410000ULL,
0x0000003c263c7220ULL, 0x040fe20000410000ULL, 0x0000003d263d7220ULL, 0x040fe20000410000ULL,
0x0000004026407220ULL, 0x040fe20000410000ULL, 0x0000004126417220ULL, 0x040fe20000410000ULL,
0x0000004426447220ULL, 0x040fe20000410000ULL, 0x0000004526457220ULL, 0x040fe20000410000ULL,
0x0000004826487220ULL, 0x040fe20000410000ULL, 0x0000004926497220ULL, 0x000fce0000410000ULL,
0x0000004f88887220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001808267811ULL, 0x002fcc00078ff0ffULL, 0x00001f264f267589ULL, 0x000e6400000e0000ULL,
0x0000002e262e7220ULL, 0x042fe20000410000ULL, 0x0000002f262f7220ULL, 0x040fe20000410000ULL,
0x0000003226327220ULL, 0x040fe20000410000ULL, 0x0000003326337220ULL, 0x040fe20000410000ULL,
0x0000003626367220ULL, 0x040fe20000410000ULL, 0x0000003726377220ULL, 0x040fe20000410000ULL,
0x0000003a263a7220ULL, 0x040fe20000410000ULL, 0x0000003b263b7220ULL, 0x040fe20000410000ULL,
0x0000003e263e7220ULL, 0x040fe20000410000ULL, 0x0000003f263f7220ULL, 0x040fe20000410000ULL,
0x0000004226427220ULL, 0x040fe20000410000ULL, 0x0000004326437220ULL, 0x040fe20000410000ULL,
0x0000004626467220ULL, 0x040fe20000410000ULL, 0x0000004726477220ULL, 0x040fe20000410000ULL,
0x0000004a264a7220ULL, 0x040fe20000410000ULL, 0x0000004b264b7220ULL, 0x000fce0000410000ULL,
0x000000274cff7212ULL, 0x000fe400078030ffULL, 0x000000824d827209ULL, 0x000fd60007810000ULL,
0x800000824d4d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b4d4d0820ULL, 0x000fc80000410000ULL,
0x0000004d00160308ULL, 0x000ea40000000800ULL, 0x0000001681810220ULL, 0x004fce0000410000ULL,
0x0000200003267824ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000040003277824ULL, 0x000fe200078e00ffULL, 0xffffc000264d7812ULL, 0x000fc800078ec0ffULL,
0xfffff00027277812ULL, 0x000fe200078ec0ffULL, 0x000000010a4c7824ULL, 0x000fc600078e024dULL,
0x000130000a877810ULL, 0x000fe40007ffe027ULL, 0x0000004c11277211ULL, 0x000fc600078e68ffULL,
0x0000001017687824ULL, 0x000fe400078e0287ULL, 0x0001700027277836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe40000011608ULL,
0x00000016ff1d723eULL, 0x000fe400000000ffULL, 0x000000101f4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f4d7836ULL, 0x000fe20000000000ULL, 0x000054101d4c7816ULL, 0x000fe2000000001dULL,
0x000000181f517836ULL, 0x000fc80000000000ULL, 0x00001f4d4c1e7589ULL, 0x0002a800000e0000ULL,
0x00001f4f4c1d7589ULL, 0x0002e800000e0000ULL, 0x00001f1f4c1f7589ULL, 0x00026800000e0000ULL,
0x00001f514c207589ULL, 0x00026400000e0000ULL, 0x00000010184c7824ULL, 0x002fe200078e0287ULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0x000000101a647824ULL, 0x100fe200078e0227ULL,
0x0000002719607211ULL, 0x000fe200078e20ffULL, 0x000000101b5c7824ULL, 0x000fe400078e0227ULL,
0x000000004c4c783bULL, 0x000ee20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000001f68687232ULL, 0x082fe40000000000ULL, 0x0000001f6a6a7232ULL, 0x000fe40000000000ULL,
0x0000001e69697232ULL, 0x084fe40000000000ULL, 0x0000001e6b6b7232ULL, 0x000fe40000000000ULL,
0x0000001d4c4c7232ULL, 0x088fe40000000000ULL, 0x0000001d4e4e7232ULL, 0x000fc40000000000ULL,
0x000000204d4d7232ULL, 0x080fe40000000000ULL, 0x000000204f4f7232ULL, 0x000fce0000000000ULL,
0x000000101c507824ULL, 0x000fe200078e0227ULL, 0x000000006060783bULL, 0x000f620000004200ULL,
0x00000001ff277819ULL, 0x000fc60000011603ULL, 0x000000006464783bULL, 0x000fe40000004200ULL,
0x00004000278a7824ULL, 0x000fe400078e020aULL, 0x000000005c5c783bULL, 0x000fe80000004200ULL,
0x000000005050783bULL, 0x000f640000004200ULL, 0x000000606874723cULL, 0x02afec0000001874ULL,
0x000000604c34723cULL, 0x000fec0000001834ULL, 0x00000050686c723cULL, 0x004fe2000000186cULL,
0x0000008a11607211ULL, 0x000fca00078e68ffULL, 0x000000644c2c723cULL, 0x000fe2000000182cULL,
0x0001700060607836ULL, 0x000fc80000000000ULL, 0x0000001022617824ULL, 0x000fe200078e0260ULL,
0x000000664c30723cULL, 0x000fec0000001830ULL, 0x000000624c38723cULL, 0x000fec0000001838ULL,
0x0000005c4c3c723cULL, 0x000fec000000183cULL, 0x0000005e4c40723cULL, 0x000fec0000001840ULL,
0x000000504c44723cULL, 0x000fec0000001844ULL, 0x000000524c48723cULL, 0x000fe20000001848ULL,
0x0000001084507824ULL, 0x000fca00078e0287ULL, 0x000000526828723cULL, 0x000fe20000001828ULL,
0x00000010854c7824ULL, 0x000fe200078e0287ULL, 0x000000005050783bULL, 0x000e680000000200ULL,
0x000000646854723cULL, 0x000fe20000001854ULL, 0x000000004c4c783bULL, 0x000eaa0000000200ULL,
0x000000666858723cULL, 0x000fe20000001858ULL, 0x0000001023647824ULL, 0x000fca00078e0260ULL,
0x000000626878723cULL, 0x000fec0000001878ULL, 0x0000005c687c723cULL, 0x000fec000000187cULL,
0x0000005e6870723cULL, 0x000fe20000001870ULL, 0x00000060215c7211ULL, 0x000fe200078e20ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000208947ULL, 0x000fde0003800000ULL,
0x0000001f4c4c7232ULL, 0x084fe40000000000ULL, 0x0000001f4e4e7232ULL, 0x000fe40000000000ULL,
0x0000001e4d4d7232ULL, 0x080fe40000000000ULL, 0x0000001e4f4f7232ULL, 0x000fe40000000000ULL,
0x0000001d50507232ULL, 0x082fe40000000000ULL, 0x0000001d52527232ULL, 0x000fc40000000000ULL,
0x0000002051517232ULL, 0x080fe40000000000ULL, 0x0000002053537232ULL, 0x000fce0000000000ULL,
0x0000001024687824ULL, 0x000fe200078e0260ULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000008881887221ULL, 0x000fe20000010000ULL,
0x0000000483837c24ULL, 0x010fe2000f8e02ffULL, 0x000000006160783bULL, 0x000f280000004200ULL,
0x000000006464783bULL, 0x000f680000004200ULL, 0x000000006868783bULL, 0x000f220000004200ULL,
0x0000005c4c54723cULL, 0x00cfec0000001854ULL, 0x0000005e4c58723cULL, 0x000fec0000001858ULL,
0x000000604c74723cULL, 0x010fec0000001874ULL, 0x000000624c78723cULL, 0x000fec0000001878ULL,
0x000000644c7c723cULL, 0x022fec000000187cULL, 0x000000664c70723cULL, 0x000fec0000001870ULL,
0x000000684c6c723cULL, 0x000fec000000186cULL, 0x0000006a4c28723cULL, 0x000fe20000001828ULL,
0x00009000ff4e7b82ULL, 0x000e6a0000000a00ULL, 0x0000005c502c723cULL, 0x000fe2000000182cULL,
0x00000001054d7836ULL, 0x000fe20000000000ULL, 0x00000001004c7802ULL, 0x000fc80000000f00ULL,
0x0000005e5030723cULL, 0x000fe20000001830ULL, 0x0000000c4d00720cULL, 0x000fe20003f06070ULL,
0x01e6904c25ff79a7ULL, 0x0005e8000850003fULL, 0x000000605034723cULL, 0x000fec0000001834ULL,
0x000000625038723cULL, 0x000fec0000001838ULL, 0x00000064503c723cULL, 0x000fec000000183cULL,
0x000000665040723cULL, 0x000fec0000001840ULL, 0x000000685044723cULL, 0x000fec0000001844ULL,
0x0000006a5050723cULL, 0x000fee0000001848ULL, 0x00000008054a7824ULL, 0x000fc400078e0227ULL,
0x0000004083497824ULL, 0x000fc600078e00ffULL, 0x000000c04a4a7811ULL, 0x000fe200078e28ffULL,
0x0000010049487825ULL, 0x002fc600078e004eULL, 0x000000204a4b7812ULL, 0x000fc800078ec0ffULL,
0x0000004b10677210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400908947ULL, 0x004fea0003800000ULL, 0x00000003ff4d7819ULL, 0x000fe20000011608ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0a4aULL, 0x00002000265d7812ULL, 0x000fe200078ec0ffULL,
0x00000080034f7824ULL, 0x000fe200078e00ffULL, 0x0000004a09267248ULL, 0x000fe20007fe0000ULL,
0x000000044d5f7836ULL, 0x000fe20000000000ULL, 0x000000084d817810ULL, 0x000fe20007ffe0ffULL,
0x0000000c4d837836ULL, 0x000fe20000000000ULL, 0x0000002026267446ULL, 0x000fe2000380004bULL,
0x000000015f4a7824ULL, 0x140fe200078e0208ULL, 0x000000035f6b7819ULL, 0x000fe200000006ffULL,
0x000000014d4b7824ULL, 0x000fe200078e0208ULL, 0x000170008a8a7810ULL, 0x000fe20007ffe05dULL,
0x000000015f5d7824ULL, 0x100fe200078e0267ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee24aULL,
0x0000000183617824ULL, 0x100fe200078e0267ULL, 0x00000080144a7812ULL, 0x000fe200078ef84fULL,
0x000000014d4f7824ULL, 0x000fe200078e0267ULL, 0x000000074b657812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000000265f00720cULL, 0x000fe20003f26070ULL,
0x000000144d897836ULL, 0x000fe20000000000ULL, 0x00000067815f7210ULL, 0x000fe20007ffe0ffULL,
0x000001004f4e7825ULL, 0x000fe200078e004aULL, 0x000000104d877810ULL, 0x000fc40007ffe0ffULL,
0x000000264d00720cULL, 0x080fe20003f06070ULL, 0x000001005f5e7825ULL, 0x100fe200078e004aULL,
0x0000004e48627210ULL, 0x000fe40007f5e0ffULL, 0x000000268300720cULL, 0x080fe20003f86070ULL,
0x000001005d5c7825ULL, 0x000fe200078e004aULL, 0x000000268100720cULL, 0x000fc60003fa6070ULL,
0x0000000149637824ULL, 0x000fe200010e064fULL, 0x0ffffff8654f7812ULL, 0x000fe200078ef808ULL,
0x0000010061607825ULL, 0x000fe200078e004aULL, 0x0000005e484e7210ULL, 0x000fe40007f5e0ffULL,
0x0000005c48647210ULL, 0x000fe20007f7e0ffULL, 0x0000000881667824ULL, 0x000fe200078e00ffULL,
0x0000008a4f697211ULL, 0x000fe200078e20ffULL, 0x00000001494f7824ULL, 0x000fe200010e065fULL,
0x000000268900720cULL, 0x000fe20003f46070ULL, 0x00000001875f7824ULL, 0x000fc400078e0267ULL,
0x0000000149657824ULL, 0x000fe200018e065dULL, 0x00000060485c7210ULL, 0x000fe20007f7e0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e004aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e6000c101c46ULL, 0x00000001495d7824ULL, 0x000fe200018e0661ULL,
0x0000000881617210ULL, 0x000fe20007ffe0ffULL, 0x000000106b6b7824ULL, 0x000fe200078e028aULL,
0x0000005e48607210ULL, 0x000fe20007fde0ffULL, 0x000000184d8b7836ULL, 0x000fe20000000000ULL,
0x000000268700720cULL, 0x080fe20003f66070ULL, 0x0000001c4d8d7836ULL, 0x000fe20000000000ULL,
0x00000000646b7faeULL, 0x0005e2000c901c46ULL, 0x00000001894d7824ULL, 0x000fe200078e0267ULL,
0xfffffff866697812ULL, 0x002fe200078ee261ULL, 0x0000000183627824ULL, 0x000fe200078e0208ULL,
0x000000268b00720cULL, 0x080fe20003f26070ULL, 0x0000000149617824ULL, 0x000fe200030e065fULL,
0x000000268d00720cULL, 0x000fe20003f06070ULL, 0x000001004d5e7825ULL, 0x000fe200078e004aULL,
0x0000000387817819ULL, 0x000fc600000006ffULL, 0x0000000189637824ULL, 0x100fe200078e0208ULL,
0x00000003836b7819ULL, 0x004fe200000006ffULL, 0x0000000889647824ULL, 0x000fe400078e00ffULL,
0x000000018b4d7824ULL, 0x100fe200078e0267ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee262ULL,
0x0000000187267824ULL, 0x000fe200078e0208ULL, 0x0000005e48627210ULL, 0x000fe20007fde0ffULL,
0x000000018d657824ULL, 0x000fe200078e0267ULL, 0xfffffff864837812ULL, 0x000fe200078ee263ULL,
0x0000001069697824ULL, 0x000fe200078e028aULL, 0x0000005f49637210ULL, 0x000fe200037fe4ffULL,
0x000001004d5e7825ULL, 0x000fe200078e004aULL, 0xfffffff881817812ULL, 0x000fc400078ee226ULL,
0x000000088d647210ULL, 0x000fe20007ffe0ffULL, 0x000000018b267824ULL, 0x040fe200078e0208ULL,
0x0000005e485e7210ULL, 0x000fe20007fde0ffULL, 0x000000088b4d7824ULL, 0x000fe200078e00ffULL,
0x0000008a6b6b7211ULL, 0x000fe200078e20ffULL, 0x00000100654a7825ULL, 0x000fe200078e004aULL,
0x000000004e697faeULL, 0x0003e4000e901c46ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee226ULL,
0x000000088d8d7824ULL, 0x000fe200078e00ffULL, 0x000000005c6b7faeULL, 0x0003e2000e101c46ULL,
0x00000001495f7824ULL, 0x000fe200030e065fULL, 0x0000004a48487210ULL, 0x000fe20007fde0ffULL,
0x0000001081817824ULL, 0x100fe200078e028aULL, 0xfffffff88d657812ULL, 0x000fe200078ee264ULL,
0x0000001083837824ULL, 0x000fc400078e028aULL, 0x000000104d4d7824ULL, 0x000fe200078e028aULL,
0x0000008a65657211ULL, 0x000fe200078e20ffULL, 0x0000000149497824ULL, 0x000fe200030e064bULL,
0x0000000060817faeULL, 0x0003e8000d901c46ULL, 0x0000000062837faeULL, 0x0003e8000d101c46ULL,
0x000000005e4d7faeULL, 0x0003e8000c901c46ULL, 0x0000000048657faeULL, 0x0003e2000c101c46ULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x00000004084f7811ULL, 0x000fe400078fe8ffULL,
0x00002000264b7812ULL, 0x000fe400078ec0ffULL, 0x00000008085d7811ULL, 0x040fe200078fe8ffULL,
0x000000014f267824ULL, 0x140fe200078e0208ULL, 0x0000000c085f7811ULL, 0x040fe200078fe8ffULL,
0x000000084f6b7824ULL, 0x000fe200078e00ffULL, 0x0000001408637811ULL, 0x040fe200078fe8ffULL,
0x000000085d817824ULL, 0x000fe200078e00ffULL, 0x0000001008617811ULL, 0x000fe200078fe8ffULL,
0x000000015f4a7824ULL, 0x140fe200078e0208ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee226ULL,
0x000000085f837824ULL, 0x000fe200078e00ffULL, 0x000000085d267210ULL, 0x000fe20007ffe0ffULL,
0x00000001634d7824ULL, 0x040fe200078e0208ULL, 0x000170008a8a7810ULL, 0x000fe20007ffe04bULL,
0x00000008635c7824ULL, 0x000fe200078e00ffULL, 0x00000008614b7210ULL, 0x000fe20007ffe0ffULL,
0x00000008614e7824ULL, 0x000fe200078e00ffULL, 0xfffffff881817812ULL, 0x000fe200078ee226ULL,
0x000000014f4f7824ULL, 0x100fe200078e0267ULL, 0xfffffff883837812ULL, 0x000fe200078ee24aULL,
0x000000015d5d7824ULL, 0x100fe200078e0267ULL, 0xfffffff85c897812ULL, 0x000fe200078ee24dULL,
0x000000015f5f7824ULL, 0x100fe200078e0267ULL, 0x0000000808267211ULL, 0x040fe200078fe8ffULL,
0x0000000163637824ULL, 0x100fe200078e0267ULL, 0x00000018084a7811ULL, 0x040fe200078fe8ffULL,
0x000000106b6b7824ULL, 0x100fe200078e028aULL, 0xfffffff84e877812ULL, 0x000fe200078ee24bULL,
0x0000001081817824ULL, 0x100fe200078e028aULL, 0x0000001c084d7811ULL, 0x000fe200078fe8ffULL,
0x000000014a657824ULL, 0x100fe200078e0267ULL, 0x00000007034b7819ULL, 0x000fe200000006ffULL,
0x0000001087877824ULL, 0x000fe200078e028aULL, 0x0000000726697812ULL, 0x000fe200078ec0ffULL,
0x000000014a267824ULL, 0x140fe200078e0208ULL, 0x000000034a8b7819ULL, 0x000fe200000006ffULL,
0x000000014d4a7824ULL, 0x040fe200078e0208ULL, 0x0000008014667812ULL, 0x000fe200078ef84bULL,
0x000000084d8d7824ULL, 0x040fe200078e00ffULL, 0x0000006761617210ULL, 0x000fe20007ffe0ffULL,
0x000000014d4d7824ULL, 0x000fe200078e0267ULL, 0x00000067084b7211ULL, 0x000fe200078fe8ffULL,
0x0000001089897824ULL, 0x000fe200078e028aULL, 0x000000ff00677202ULL, 0x000fc40000000f00ULL,
0xfffffff88d8d7812ULL, 0x000fe400078ee24aULL, 0x0ffffff869697812ULL, 0x000fe200078ef808ULL,
0x000001004b4a7825ULL, 0x100fe200078e0066ULL, 0xfffffff88b8b7812ULL, 0x000fe400078ee226ULL,
0x0000008a83837211ULL, 0x080fe200078e20ffULL, 0x000001004f4e7825ULL, 0x100fe200078e0066ULL,
0x0000004a484a7210ULL, 0x000fe40007f1e0ffULL, 0x0000008a8d8d7211ULL, 0x000fe200078e20ffULL,
0x000001005d5c7825ULL, 0x000fe200078e0066ULL, 0x0000004e484e7210ULL, 0x000fc60007f3e0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e0066ULL, 0x0000005c485c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010061607825ULL, 0x000fe200078e0066ULL, 0x0000005e485e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010063627825ULL, 0x000fe200078e0066ULL, 0x0000005f495f7210ULL, 0x000fc60001ffe4ffULL,
0x0000010065647825ULL, 0x000fc800078e0066ULL, 0x000001004d667825ULL, 0x000fc800078e0066ULL,
0x00000001494b7824ULL, 0x040fe200000e064bULL, 0x0000006048607210ULL, 0x000fe20007f1e0ffULL,
0x00000001494f7824ULL, 0x000fe200008e064fULL, 0x0000006248627210ULL, 0x000fe20007f3e0ffULL,
0x0000001069697824ULL, 0x100fe400078e028aULL, 0x00000001495d7824ULL, 0x040fe200010e065dULL,
0x0000006448647210ULL, 0x000fe20007f5e0ffULL, 0x0000000149617824ULL, 0x040fe200000e0661ULL,
0x0000006648487210ULL, 0x000fe20007f7e0ffULL, 0x0000000149637824ULL, 0x000fe200008e0663ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a697faeULL, 0x0003e2000b901c46ULL,
0x000000108b8b7824ULL, 0x000fc400078e028aULL, 0x0000000149657824ULL, 0x000fe200010e0665ULL,
0x000000004e6b7faeULL, 0x0003e2000b901c46ULL, 0x0000006749497210ULL, 0x000fc60001ffe4ffULL,
0x000000005c817faeULL, 0x0003e8000b901c46ULL, 0x000000005e837faeULL, 0x0003e8000b901c46ULL,
0x0000000060877faeULL, 0x0003e8000b901c46ULL, 0x0000000062897faeULL, 0x0003e8000b901c46ULL,
0x00000000648b7faeULL, 0x0003e8000b901c46ULL, 0x00000000488d7faeULL, 0x0003e4000b901c46ULL,
0x0000000386267812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000032600780cULL, 0x000fe20003f05270ULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x0000000112497807ULL, 0x002fca0004000000ULL, 0x0000000186867824ULL, 0x000fca00078e0249ULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x00009200ff488b82ULL, 0x000e620000000a00ULL,
0x00000001134b8824ULL, 0x000fc800078e0286ULL, 0x000000044b488825ULL, 0x002fca00078e0048ULL,
0x0000000648268981ULL, 0x000322000c1e1900ULL, 0x01e6484c804c79a7ULL, 0x0002a4000850003fULL,
0x0000000000487805ULL, 0x002fce0000015200ULL, 0xffffffe00f4b7812ULL, 0x040fe400078ec0ffULL,
0x000000100f4a7812ULL, 0x040fe400078ec0ffULL, 0x000000080f817812ULL, 0x000fe400078ec0ffULL,
0x0000000a4a4a7210ULL, 0x000fc80007ffe04bULL, 0x000000814a817210ULL, 0x000fc80007ffe0ffULL,
0x01e6484d810075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4e7224ULL, 0x000fce00078e00ffULL, 0x000000104e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000004a7805ULL, 0x000fce0000015200ULL,
0x0000004a484f7210ULL, 0x000fca0007f1e1ffULL, 0x000000014b4b7824ULL, 0x000fe200000e0e49ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff4b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff4b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff4a7819ULL, 0x000fc8000001144bULL, 0x0000004f4a4a7211ULL, 0x000fca00078110ffULL,
0x000000ffff4b7224ULL, 0x000fca00000e064bULL, 0x000000024a4a7819ULL, 0x000fc8000000124bULL,
0x0000004a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014e4e7810ULL, 0x000fce0007ffe0ffULL, 0x01e6484d810075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002003487824ULL, 0x000fca00078e00ffULL,
0xffffff8048497812ULL, 0x000fc800078ec0ffULL, 0x000001000a487810ULL, 0x000fc80007ffe049ULL,
0x0000004815487210ULL, 0x000fca0007ffe014ULL, 0x01e0000048497984ULL, 0x000e680000000800ULL,
0x01e2000048837984ULL, 0x0004a20000000800ULL, 0x000000824900720bULL, 0x002fda0003f1d000ULL,
0x00000000004a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff4a00720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x004fea0003800000ULL,
0x000000020d487836ULL, 0x000fe20000000000ULL, 0x000000824900720bULL, 0x0c0fe40003f14000ULL,
0x00000082494c7209ULL, 0x000fe40007810000ULL, 0x000000034800720cULL, 0x000fd20003f25270ULL,
0x00000000004b7806ULL, 0x000fc800000e0100ULL, 0x0000008003489824ULL, 0x000fe200078e020aULL,
0x000000ff4b00720cULL, 0x000fc80003f05270ULL, 0x00000048154d9210ULL, 0x000fca0007ffe014ULL,
0x01e4004c4d009388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x8000004c82827221ULL, 0x000fe20000010000ULL, 0x000000ff4bff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff004bff7812ULL, 0x040fe2000782c0ffULL, 0x3fb8aa3b82827820ULL, 0x000fe20000410000ULL,
0x00ff00004bff7812ULL, 0x040fe4000784c0ffULL, 0xff0000004bff7812ULL, 0x000fe2000786c0ffULL,
0x00000082004d7308ULL, 0x0022ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff487819ULL, 0x000fcc0000011608ULL, 0x00001f484d487589ULL, 0x004ea400000e0000ULL,
0x0000005448547220ULL, 0x044fe20000410000ULL, 0x0000005548557220ULL, 0x040fe20000410000ULL,
0x0000005848587220ULL, 0x040fe20000410000ULL, 0x0000005948597220ULL, 0x040fe20000410000ULL,
0x0000007448747220ULL, 0x040fe20000410000ULL, 0x0000007548757220ULL, 0x040fe20000410000ULL,
0x0000007848787220ULL, 0x040fe20000410000ULL, 0x0000007948797220ULL, 0x040fe20000410000ULL,
0x0000007c487c7220ULL, 0x040fe20000410000ULL, 0x0000007d487d7220ULL, 0x040fe20000410000ULL,
0x0000007048707220ULL, 0x040fe20000410000ULL, 0x0000007148717220ULL, 0x040fe20000410000ULL,
0x0000006c486c7220ULL, 0x040fe20000410000ULL, 0x0000006d486d7220ULL, 0x040fe20000410000ULL,
0x0000002848287220ULL, 0x040fe20000410000ULL, 0x0000002948297220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000808487811ULL, 0x000fcc00078ff0ffULL,
0x00001f484d487589ULL, 0x004ea400000e0000ULL, 0x0000005648567220ULL, 0x044fe20000410000ULL,
0x0000005748577220ULL, 0x040fe20000410000ULL, 0x0000005a485a7220ULL, 0x040fe20000410000ULL,
0x0000005b485b7220ULL, 0x040fe20000410000ULL, 0x0000007648767220ULL, 0x040fe20000410000ULL,
0x0000007748777220ULL, 0x040fe20000410000ULL, 0x0000007a487a7220ULL, 0x040fe20000410000ULL,
0x0000007b487b7220ULL, 0x040fe20000410000ULL, 0x0000007e487e7220ULL, 0x040fe20000410000ULL,
0x0000007f487f7220ULL, 0x040fe20000410000ULL, 0x0000007248727220ULL, 0x040fe20000410000ULL,
0x0000007348737220ULL, 0x040fe20000410000ULL, 0x0000006e486e7220ULL, 0x040fe20000410000ULL,
0x0000006f486f7220ULL, 0x040fe20000410000ULL, 0x0000002a482a7220ULL, 0x040fe20000410000ULL,
0x0000002b482b7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001008487811ULL, 0x000fcc00078ff0ffULL, 0x00001f484d487589ULL, 0x004ea400000e0000ULL,
0x0000002c482c7220ULL, 0x044fe20000410000ULL, 0x0000002d482d7220ULL, 0x040fe20000410000ULL,
0x0000003048307220ULL, 0x040fe20000410000ULL, 0x0000003148317220ULL, 0x040fe20000410000ULL,
0x0000003448347220ULL, 0x040fe20000410000ULL, 0x0000003548357220ULL, 0x040fe20000410000ULL,
0x0000003848387220ULL, 0x040fe20000410000ULL, 0x0000003948397220ULL, 0x040fe20000410000ULL,
0x0000003c483c7220ULL, 0x040fe20000410000ULL, 0x0000003d483d7220ULL, 0x040fe20000410000ULL,
0x0000004048407220ULL, 0x040fe20000410000ULL, 0x0000004148417220ULL, 0x040fe20000410000ULL,
0x0000004448447220ULL, 0x040fe20000410000ULL, 0x0000004548457220ULL, 0x040fe20000410000ULL,
0x0000005048507220ULL, 0x040fe20000410000ULL, 0x0000005148517220ULL, 0x000fce0000410000ULL,
0x0000004d88887220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001808487811ULL, 0x000fcc00078ff0ffULL, 0x00001f484d487589ULL, 0x000ea400000e0000ULL,
0x0000002e482e7220ULL, 0x044fe20000410000ULL, 0x0000002f482f7220ULL, 0x040fe20000410000ULL,
0x0000003248327220ULL, 0x040fe20000410000ULL, 0x0000003348337220ULL, 0x040fe20000410000ULL,
0x0000003648367220ULL, 0x040fe20000410000ULL, 0x0000003748377220ULL, 0x040fe20000410000ULL,
0x0000003a483a7220ULL, 0x040fe20000410000ULL, 0x0000003b483b7220ULL, 0x040fe20000410000ULL,
0x0000003e483e7220ULL, 0x040fe20000410000ULL, 0x0000003f483f7220ULL, 0x040fe20000410000ULL,
0x0000004248427220ULL, 0x040fe20000410000ULL, 0x0000004348437220ULL, 0x040fe20000410000ULL,
0x0000004648467220ULL, 0x040fe20000410000ULL, 0x0000004748477220ULL, 0x040fe20000410000ULL,
0x0000005248527220ULL, 0x040fe20000410000ULL, 0x0000005348537220ULL, 0x000fce0000410000ULL,
0x0000004b4aff7212ULL, 0x000fe400078030ffULL, 0x0000004c00827202ULL, 0x002fd60000000f00ULL,
0x8000004c49490221ULL, 0x100fe20000010000ULL, 0x000000ffff820224ULL, 0x000fc600078e004cULL,
0x3fb8aa3b49490820ULL, 0x000fc80000410000ULL, 0x0000004900160308ULL, 0x000e640000000800ULL,
0x0000001683830220ULL, 0x002fce0000410000ULL, 0x0000040003487824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000400027807824ULL, 0x000fe200078e020aULL,
0xfffff00048877812ULL, 0x000fc800078ec0ffULL, 0x0000008011487211ULL, 0x000fe400078e68ffULL,
0x000140000a877810ULL, 0x000fc60007ffe087ULL, 0x0001600048897836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe40000011608ULL,
0x00000016ff1d723eULL, 0x000fe400000000ffULL, 0x000000181f4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f497836ULL, 0x000fe20000000000ULL, 0x000054101d487816ULL, 0x000fe2000000001dULL,
0x000000101f4b7836ULL, 0x000fc80000000000ULL, 0x00001f49481e7589ULL, 0x0002a800000e0000ULL,
0x00001f4b481d7589ULL, 0x0002e800000e0000ULL, 0x00001f1f481f7589ULL, 0x00026800000e0000ULL,
0x00001f4d48207589ULL, 0x00026400000e0000ULL, 0x00000010174c7824ULL, 0x100fe200078e0287ULL,
0x0000008919607211ULL, 0x000fe200078e20ffULL, 0x0000001018487824ULL, 0x002fe400078e0287ULL,
0x000000101a5c7824ULL, 0x100fe400078e0289ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x000000101b647824ULL, 0x000fc600078e0289ULL, 0x000000004848783bULL, 0x000ee20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f4c4c7232ULL, 0x082fe40000000000ULL,
0x0000001f4e4e7232ULL, 0x000fe40000000000ULL, 0x0000001e4d4d7232ULL, 0x084fe40000000000ULL,
0x0000001e4f4f7232ULL, 0x000fe40000000000ULL, 0x0000001d48487232ULL, 0x088fe40000000000ULL,
0x0000001d4a4a7232ULL, 0x000fc40000000000ULL, 0x0000002049497232ULL, 0x080fe40000000000ULL,
0x000000204b4b7232ULL, 0x000fce0000000000ULL, 0x000000101c687824ULL, 0x000fe200078e0289ULL,
0x000000005c5c783bULL, 0x000f680000004200ULL, 0x000000006060783bULL, 0x000f680000004200ULL,
0x000000006464783bULL, 0x000f680000004200ULL, 0x000000006868783bULL, 0x000f640000004200ULL,
0x0000005c4c54723cULL, 0x02afec0000001854ULL, 0x0000005e4c58723cULL, 0x000fec0000001858ULL,
0x000000604c74723cULL, 0x004fec0000001874ULL, 0x000000624c78723cULL, 0x000fec0000001878ULL,
0x000000644c7c723cULL, 0x000fec000000187cULL, 0x000000664c70723cULL, 0x000fec0000001870ULL,
0x000000684c6c723cULL, 0x000fec000000186cULL, 0x0000006a4c28723cULL, 0x000fec0000001828ULL,
0x0000005c482c723cULL, 0x000fe2000000182cULL, 0x00000010854c7824ULL, 0x000fca00078e0287ULL,
0x0000005e4830723cULL, 0x000fe20000001830ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x00000010215c7824ULL, 0x000fc800078e0289ULL, 0x000000604834723cULL, 0x000fec0000001834ULL,
0x000000624838723cULL, 0x000fe20000001838ULL, 0x0000001022607824ULL, 0x000fca00078e0289ULL,
0x00000064483c723cULL, 0x000fec000000183cULL, 0x000000664840723cULL, 0x000fe20000001840ULL,
0x0000001023647824ULL, 0x000fca00078e0289ULL, 0x000000684844723cULL, 0x000fec0000001844ULL,
0x0000006a4850723cULL, 0x000fee0000001850ULL, 0x0000008784487211ULL, 0x000fcc00078e20ffULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x0000000000208947ULL, 0x002ff40003800000ULL,
0x0000001f4c4c7232ULL, 0x080fe40000000000ULL, 0x0000001f4e4e7232ULL, 0x000fe40000000000ULL,
0x0000001e4d4d7232ULL, 0x080fe40000000000ULL, 0x0000001e4f4f7232ULL, 0x000fe40000000000ULL,
0x0000001d48487232ULL, 0x084fe40000000000ULL, 0x0000001d4a4a7232ULL, 0x000fc40000000000ULL,
0x0000002049497232ULL, 0x080fe40000000000ULL, 0x000000204b4b7232ULL, 0x000fce0000000000ULL,
0x0000008924687211ULL, 0x000fe200078e20ffULL, 0x000000005c5c783bULL, 0x000e620000004200ULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x0000008883887221ULL, 0x000fe20000010000ULL,
0x000000006060783bULL, 0x000ee40000004200ULL, 0x0000000c0500720cULL, 0x000fe40003f06070ULL,
0x000000006464783bULL, 0x000f680000004200ULL, 0x000000006868783bULL, 0x000ee20000004200ULL,
0x0000005c4c54723cULL, 0x002fec0000001854ULL, 0x0000005e4c58723cULL, 0x000fec0000001858ULL,
0x000000604c74723cULL, 0x008fec0000001874ULL, 0x000000624c78723cULL, 0x000fec0000001878ULL,
0x000000644c7c723cULL, 0x024fec000000187cULL, 0x000000664c70723cULL, 0x000fec0000001870ULL,
0x000000684c6c723cULL, 0x000fec000000186cULL, 0x0000006a4c28723cULL, 0x000fec0000001828ULL,
0x0000005c482c723cULL, 0x000fe2000000182cULL, 0x00000001ff4e7424ULL, 0x000fc800078e00ffULL,
0x01e6984e25ff79a7ULL, 0x0003e2000850003fULL, 0x0000005e4830723cULL, 0x000fec0000001830ULL,
0x000000604834723cULL, 0x000fec0000001834ULL, 0x000000624838723cULL, 0x000fec0000001838ULL,
0x00000064483c723cULL, 0x000fec000000183cULL, 0x000000664840723cULL, 0x000fec0000001840ULL,
0x000000684844723cULL, 0x000fec0000001844ULL, 0x0000006a4848723cULL, 0x000fe20000001850ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000c004c0947ULL, 0x002fde0003800000ULL, 0x00009000ff4c7b82ULL, 0x000e620000000a00ULL,
0x00000001054f7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000000e05507211ULL, 0x000fe200078e40ffULL, 0x0000000426267c24ULL, 0x010fe4000f8e02ffULL,
0x0000000c4f00720cULL, 0x000fe40003f06070ULL, 0x00000020504f7812ULL, 0x000fe200078ec0ffULL,
0x0000004026517824ULL, 0x000fc800078e00ffULL, 0x0000000110677824ULL, 0x000fe400078e024fULL,
0x00000100514c7825ULL, 0x002fc800078e004cULL, 0x0000000400948947ULL, 0x000fea0003800000ULL,
0x00000003ff697819ULL, 0x000fe20000011608ULL, 0x0000200003517824ULL, 0x000fe200078e00ffULL,
0x0000005009267248ULL, 0x000fe20007fe0000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0a50ULL,
0x00000004695d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000869837836ULL, 0x000fe20000000000ULL,
0x0000200051537812ULL, 0x000fe200078ec0ffULL, 0x0000001069897836ULL, 0x000fe20000000000ULL,
0x0000000703517819ULL, 0x000fe200000006ffULL, 0x000000015d507824ULL, 0x140fe200078e0208ULL,
0x0001600080807810ULL, 0x000fe20007ffe053ULL, 0x000000085d6b7824ULL, 0x000fe200078e00ffULL,
0x0000002026267446ULL, 0x000fe2000380004fULL, 0x0000000169537824ULL, 0x100fe200078e0267ULL,
0x0000000c69877810ULL, 0x000fe20007ffe0ffULL, 0x00000001835f7824ULL, 0x100fe200078e0267ULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee250ULL, 0x00000001694f7824ULL, 0x000fe200078e0208ULL,
0x0000008014507812ULL, 0x000fe200078ef851ULL, 0x000000ffff517224ULL, 0x000fe200078e00ffULL,
0x000000265d00720cULL, 0x040fe20003f26070ULL, 0x000000015d5d7824ULL, 0x000fe200078e0267ULL,
0x0000006787617210ULL, 0x000fe20007ffe0ffULL, 0x0000010053527825ULL, 0x000fe200078e0050ULL,
0x000000074f4f7812ULL, 0x000fc400078ec0ffULL, 0x000000266900720cULL, 0x080fe20003f06070ULL,
0x000001005f5e7825ULL, 0x100fe200078e0050ULL, 0x000000524c627210ULL, 0x000fe40007f5e0ffULL,
0x0ffffff84f4f7812ULL, 0x000fe200078ef808ULL, 0x000001005d5c7825ULL, 0x000fe200078e0050ULL,
0x00000014698b7810ULL, 0x000fe40007ffe0ffULL, 0x000000268300720cULL, 0x000fe20003fa6070ULL,
0x000000014d637824ULL, 0x000fe200010e0653ULL, 0x0000005e4c527210ULL, 0x000fe20007f5e0ffULL,
0x0000010061607825ULL, 0x000fe200078e0050ULL, 0x0000005c4c647210ULL, 0x000fc40007f7e0ffULL,
0x0000005f4d537210ULL, 0x000fe200017fe4ffULL, 0x000000104f4f7824ULL, 0x100fe200078e0280ULL,
0x00000067895f7210ULL, 0x000fe20007ffe0ffULL, 0x000000014d657824ULL, 0x000fe200018e065dULL,
0x000000604c5c7210ULL, 0x000fe20007f7e0ffULL, 0x000000106b6b7824ULL, 0x000fe200078e0280ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000624f7faeULL, 0x0003e2000c101c46ULL,
0x000001005f5e7825ULL, 0x000fe200078e0050ULL, 0x000000268700720cULL, 0x080fe40003f86070ULL,
0x00000000646b7faeULL, 0x0005e2000c901c46ULL, 0x000000014d5d7824ULL, 0x000fe200018e0661ULL,
0x0000005e4c607210ULL, 0x000fe20007fde0ffULL, 0x0000000183617824ULL, 0x100fe200078e0208ULL,
0x000000268900720cULL, 0x080fe20003f66070ULL, 0x0000000883667824ULL, 0x000fe200078e00ffULL,
0x000000268b00720cULL, 0x080fe20003f46070ULL, 0x00000018698d7836ULL, 0x000fe20000000000ULL,
0x000000678b4f7210ULL, 0x002fe20007ffe0ffULL, 0x0000001c698f7836ULL, 0x000fe20000000000ULL,
0xfffffff866697812ULL, 0x000fe200078ee261ULL, 0x0000000187627824ULL, 0x040fe200078e0208ULL,
0x000000088b637210ULL, 0x000fe20007ffe0ffULL, 0x00000008876b7824ULL, 0x004fe200078e00ffULL,
0x000000268d00720cULL, 0x080fe20003f26070ULL, 0x000000014d617824ULL, 0x000fe200030e065fULL,
0x000000268f00720cULL, 0x000fe20003f06070ULL, 0x000001004f5e7825ULL, 0x000fe200078e0050ULL,
0xfffffff86b6b7812ULL, 0x000fc400078ee262ULL, 0x000000678f657210ULL, 0x000fe20007ffe0ffULL,
0x000000088b647824ULL, 0x000fe200078e00ffULL, 0x0000005e4c627210ULL, 0x000fe20007fde0ffULL,
0x000000018d4f7824ULL, 0x000fe400078e0267ULL, 0x0000000189267824ULL, 0x040fe200078e0208ULL,
0xfffffff864877812ULL, 0x000fe200078ee263ULL, 0x0000000889837824ULL, 0x000fe400078e00ffULL,
0x000000014d637824ULL, 0x000fe400030e065fULL, 0x000001004f5e7825ULL, 0x000fe200078e0050ULL,
0xfffffff883837812ULL, 0x000fc600078ee226ULL, 0x000000018d267824ULL, 0x140fe200078e0208ULL,
0x0000005e4c5e7210ULL, 0x000fe20007fde0ffULL, 0x000000088d4f7824ULL, 0x000fe200078e00ffULL,
0x0000008083837211ULL, 0x000fe200078e20ffULL, 0x000000018f647824ULL, 0x040fe200078e0208ULL,
0x000000038f8f7819ULL, 0x000fe200000006ffULL, 0x0000010065507825ULL, 0x000fe200078e0050ULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee226ULL, 0xfffffff88f657812ULL, 0x000fe200078ee264ULL,
0x000000014d5f7824ULL, 0x000fe200030e065fULL, 0x000000504c4c7210ULL, 0x000fe20007fde0ffULL,
0x0000001069697824ULL, 0x000fc400078e0280ULL, 0x000000106b6b7824ULL, 0x100fe200078e0280ULL,
0x000000514d4d7210ULL, 0x000fe200037fe4ffULL, 0x0000001087877824ULL, 0x100fe200078e0280ULL,
0x0000000052697faeULL, 0x0003e2000e901c46ULL, 0x000000104f4f7824ULL, 0x100fe400078e0280ULL,
0x0000001065657824ULL, 0x000fe200078e0280ULL, 0x000000005c6b7faeULL, 0x0003e8000e101c46ULL,
0x0000000060837faeULL, 0x0003e8000d901c46ULL, 0x0000000062877faeULL, 0x0003e8000d101c46ULL,
0x000000005e4f7faeULL, 0x0003e8000c901c46ULL, 0x000000004c657faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x0000200003267824ULL, 0x000fe200078e00ffULL,
0x0000000408537811ULL, 0x040fe400078fe8ffULL, 0x00000008085d7811ULL, 0x000fe400078fe8ffULL,
0x00002000264f7812ULL, 0x000fe200078ec0ffULL, 0x0000000153267824ULL, 0x140fe200078e0208ULL,
0x0000001008617811ULL, 0x040fe200078fe8ffULL, 0x00000008536b7824ULL, 0x000fe200078e00ffULL,
0x0000000c085f7811ULL, 0x040fe200078fe8ffULL, 0x000000085d837824ULL, 0x000fe200078e00ffULL,
0x0000001408637811ULL, 0x000fe200078fe8ffULL, 0x0000000861897824ULL, 0x000fe200078e00ffULL,
0x0001600080807810ULL, 0x000fe20007ffe04fULL, 0x000000015f4f7824ULL, 0x140fe200078e0208ULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee226ULL, 0x000000085f527824ULL, 0x000fe200078e00ffULL,
0x000000085d267210ULL, 0x000fe20007ffe0ffULL, 0x0000000163517824ULL, 0x040fe200078e0208ULL,
0x0000000861507210ULL, 0x000fe20007ffe0ffULL, 0x00000008635c7824ULL, 0x000fe200078e00ffULL,
0xfffffff883837812ULL, 0x000fe200078ee226ULL, 0x0000000153537824ULL, 0x100fe200078e0267ULL,
0xfffffff889897812ULL, 0x000fe200078ee250ULL, 0x000000015d5d7824ULL, 0x100fe200078e0267ULL,
0xfffffff852877812ULL, 0x000fe200078ee24fULL, 0x000000015f5f7824ULL, 0x100fe200078e0267ULL,
0xfffffff85c8b7812ULL, 0x000fe200078ee251ULL, 0x0000000163637824ULL, 0x100fe200078e0267ULL,
0x0000000808267211ULL, 0x040fe200078fe8ffULL, 0x000000106b6b7824ULL, 0x100fe200078e0280ULL,
0x0000001808507811ULL, 0x040fe200078fe8ffULL, 0x0000001083837824ULL, 0x100fe200078e0280ULL,
0x00000007034f7819ULL, 0x000fe200000006ffULL, 0x0000001089897824ULL, 0x000fe200078e0280ULL,
0x0000001c08517811ULL, 0x000fe200078fe8ffULL, 0x0000000150657824ULL, 0x100fe200078e0267ULL,
0x0000000726697812ULL, 0x000fe200078ec0ffULL, 0x0000000150267824ULL, 0x140fe200078e0208ULL,
0x0000008014667812ULL, 0x000fe200078ef84fULL, 0x00000008518f7824ULL, 0x040fe200078e00ffULL,
0x00000003508d7819ULL, 0x000fe200000006ffULL, 0x0000000151507824ULL, 0x040fe200078e0208ULL,
0x0000006761617210ULL, 0x000fe20007ffe0ffULL, 0x00000001514f7824ULL, 0x000fe200078e0267ULL,
0x0000006708517211ULL, 0x000fe200078fe8ffULL, 0x000000108b8b7824ULL, 0x000fe200078e0280ULL,
0x000000ff00677202ULL, 0x000fc40000000f00ULL, 0xfffffff88f8f7812ULL, 0x000fe400078ee250ULL,
0x0ffffff869697812ULL, 0x000fe200078ef808ULL, 0x0000010051507825ULL, 0x100fe200078e0066ULL,
0xfffffff88d8d7812ULL, 0x000fe400078ee226ULL, 0x0000008087877211ULL, 0x080fe200078e20ffULL,
0x0000010053527825ULL, 0x100fe200078e0066ULL, 0x000000504c507210ULL, 0x000fe40007f1e0ffULL,
0x000000808f8f7211ULL, 0x000fe200078e20ffULL, 0x000001005d5c7825ULL, 0x000fe200078e0066ULL,
0x000000524c527210ULL, 0x000fc60007f3e0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0066ULL,
0x0000005c4c5c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010061607825ULL, 0x000fe200078e0066ULL,
0x0000005e4c5e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010063627825ULL, 0x000fe200078e0066ULL,
0x0000005f4d5f7210ULL, 0x000fc60001ffe4ffULL, 0x0000010065647825ULL, 0x000fc800078e0066ULL,
0x000001004f667825ULL, 0x000fc800078e0066ULL, 0x000000014d517824ULL, 0x040fe200000e0651ULL,
0x000000604c607210ULL, 0x000fe20007f1e0ffULL, 0x000000014d537824ULL, 0x000fe200008e0653ULL,
0x000000624c627210ULL, 0x000fe20007f3e0ffULL, 0x0000001069697824ULL, 0x100fe400078e0280ULL,
0x000000014d5d7824ULL, 0x040fe200010e065dULL, 0x000000644c647210ULL, 0x000fe20007f5e0ffULL,
0x000000014d617824ULL, 0x040fe200000e0661ULL, 0x000000664c4c7210ULL, 0x000fe20007f7e0ffULL,
0x000000014d637824ULL, 0x000fe200008e0663ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000050697faeULL, 0x0003e2000b901c46ULL, 0x000000108d8d7824ULL, 0x000fc400078e0280ULL,
0x000000014d657824ULL, 0x000fe200010e0665ULL, 0x00000000526b7faeULL, 0x0003e2000b901c46ULL,
0x000000674d4d7210ULL, 0x000fc60001ffe4ffULL, 0x000000005c837faeULL, 0x0003e8000b901c46ULL,
0x000000005e877faeULL, 0x0003e8000b901c46ULL, 0x0000000060897faeULL, 0x0003e8000b901c46ULL,
0x00000000628b7faeULL, 0x0003e8000b901c46ULL, 0x00000000648d7faeULL, 0x0003e8000b901c46ULL,
0x000000004c8f7faeULL, 0x0003e4000b901c46ULL, 0x0000000386267812ULL, 0x000fc800078ec0ffULL,
0x000000032600780cULL, 0x000fe20003f05270ULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x00000001124d7807ULL, 0x002fca0004000000ULL, 0x0000000186867824ULL, 0x000fca00078e024dULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00009200ff4c7b82ULL, 0x000e620000000a00ULL, 0x00000001134f7824ULL, 0x000fc800078e0286ULL,
0x000000044f4c7825ULL, 0x002fca00078e004cULL, 0x000000064c267981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01e6684e815079a7ULL, 0x0004e4000850003fULL,
0x00000000004c7805ULL, 0x002fce0000015200ULL, 0xffffffe00f4f7812ULL, 0x040fe400078ec0ffULL,
0x000000100f4e7812ULL, 0x044fe400078ec0ffULL, 0x000000080f527812ULL, 0x000fe400078ec0ffULL,
0x0000000a4e4f7210ULL, 0x000fc80007ffe04fULL, 0x000000524f5d7210ULL, 0x000fc80007ffe0ffULL,
0x01e668515d0075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff527224ULL, 0x000fce00078e00ffULL, 0x000000105200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000004e7805ULL, 0x000fce0000015200ULL,
0x0000004e4c537210ULL, 0x000fca0007f1e1ffULL, 0x000000014f4f7824ULL, 0x000fe200000e0e4dULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff4f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff4f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff4e7819ULL, 0x000fc8000001144fULL, 0x000000534e4e7211ULL, 0x000fca00078110ffULL,
0x000000ffff4f7224ULL, 0x000fca00000e064fULL, 0x000000024e4e7819ULL, 0x000fc8000000124fULL,
0x0000004e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fce0007ffe0ffULL, 0x01e668515d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020034c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff897224ULL, 0x000fc600078e0082ULL, 0xffffff804c4d7812ULL, 0x000fc800078ec0ffULL,
0x000001800a4c7810ULL, 0x000fc80007ffe04dULL, 0x0000004c154c7210ULL, 0x000fca0007ffe014ULL,
0x01e000004c4d7984ULL, 0x000e680000000800ULL, 0x01e200004c877984ULL, 0x0004a20000000800ULL,
0x000000824d00720bULL, 0x002fda0003f1d000ULL, 0x00000000004e7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff4e00720cULL, 0x000fda0003f25270ULL,
0x00000004008c9947ULL, 0x004fea0003800000ULL, 0x000000030d4c7836ULL, 0x000fe20000000000ULL,
0x000000824d00720bULL, 0x0c0fe40003f14000ULL, 0x000000824d897209ULL, 0x000fe40007810000ULL,
0x000000034c00720cULL, 0x000fda0003f25270ULL, 0x0000000a034c9211ULL, 0x000fc800078e38ffULL,
0x0000004c154c9210ULL, 0x000fe40007ffe014ULL, 0x0000000000157806ULL, 0x000fc600000e0100ULL,
0x01e400894c009388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000008289147221ULL, 0x000fe20000010100ULL,
0x000000ff15ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0015ff7812ULL, 0x040fe2000782c0ffULL,
0x3fb8aa3b14147820ULL, 0x000fe20000410000ULL, 0x00ff000015ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000015ff7812ULL, 0x000fe2000786c0ffULL, 0x00000014004f7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff147819ULL, 0x002fcc0000011608ULL,
0x00001f144f147589ULL, 0x004e6400000e0000ULL, 0x0000005414547220ULL, 0x042fe20000410000ULL,
0x0000005514557220ULL, 0x040fe20000410000ULL, 0x0000005814587220ULL, 0x040fe20000410000ULL,
0x0000005914597220ULL, 0x040fe20000410000ULL, 0x0000007414747220ULL, 0x040fe20000410000ULL,
0x0000007514757220ULL, 0x040fe20000410000ULL, 0x0000007814787220ULL, 0x040fe20000410000ULL,
0x0000007914797220ULL, 0x040fe20000410000ULL, 0x0000007c147c7220ULL, 0x040fe20000410000ULL,
0x0000007d147d7220ULL, 0x040fe20000410000ULL, 0x0000007014707220ULL, 0x040fe20000410000ULL,
0x0000007114717220ULL, 0x040fe20000410000ULL, 0x0000006c146c7220ULL, 0x040fe20000410000ULL,
0x0000006d146d7220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000808147811ULL, 0x002fcc00078ff0ffULL, 0x00001f144f147589ULL, 0x004e6400000e0000ULL,
0x0000005614567220ULL, 0x042fe20000410000ULL, 0x0000005714577220ULL, 0x040fe20000410000ULL,
0x0000005a145a7220ULL, 0x040fe20000410000ULL, 0x0000005b145b7220ULL, 0x040fe20000410000ULL,
0x0000007614767220ULL, 0x040fe20000410000ULL, 0x0000007714777220ULL, 0x040fe20000410000ULL,
0x0000007a147a7220ULL, 0x040fe20000410000ULL, 0x0000007b147b7220ULL, 0x040fe20000410000ULL,
0x0000007e147e7220ULL, 0x040fe20000410000ULL, 0x0000007f147f7220ULL, 0x040fe20000410000ULL,
0x0000007214727220ULL, 0x040fe20000410000ULL, 0x0000007314737220ULL, 0x040fe20000410000ULL,
0x0000006e146e7220ULL, 0x040fe20000410000ULL, 0x0000006f146f7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001008147811ULL, 0x002fcc00078ff0ffULL,
0x00001f144f147589ULL, 0x004e6400000e0000ULL, 0x0000002c142c7220ULL, 0x042fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000003414347220ULL, 0x040fe20000410000ULL,
0x0000003514357220ULL, 0x040fe20000410000ULL, 0x0000003814387220ULL, 0x040fe20000410000ULL,
0x0000003914397220ULL, 0x040fe20000410000ULL, 0x0000003c143c7220ULL, 0x040fe20000410000ULL,
0x0000003d143d7220ULL, 0x040fe20000410000ULL, 0x0000004014407220ULL, 0x040fe20000410000ULL,
0x0000004114417220ULL, 0x040fe20000410000ULL, 0x0000004414447220ULL, 0x040fe20000410000ULL,
0x0000004514457220ULL, 0x040fe20000410000ULL, 0x0000004814487220ULL, 0x040fe20000410000ULL,
0x0000004914497220ULL, 0x000fce0000410000ULL, 0x0000004f88887220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001808147811ULL, 0x002fcc00078ff0ffULL,
0x00001f144f147589ULL, 0x000e6400000e0000ULL, 0x0000002e142e7220ULL, 0x042fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000003614367220ULL, 0x040fe20000410000ULL,
0x0000003714377220ULL, 0x040fe20000410000ULL, 0x0000003a143a7220ULL, 0x040fe20000410000ULL,
0x0000003b143b7220ULL, 0x040fe20000410000ULL, 0x0000003e143e7220ULL, 0x040fe20000410000ULL,
0x0000003f143f7220ULL, 0x040fe20000410000ULL, 0x0000004214427220ULL, 0x040fe20000410000ULL,
0x0000004314437220ULL, 0x040fe20000410000ULL, 0x0000004614467220ULL, 0x040fe20000410000ULL,
0x0000004714477220ULL, 0x040fe20000410000ULL, 0x0000004a144a7220ULL, 0x040fe20000410000ULL,
0x0000004b144b7220ULL, 0x000fce0000410000ULL, 0x000000154eff7212ULL, 0x000fda00078030ffULL,
0x0000004d894d0221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b4d4d0820ULL, 0x000fc80000410000ULL,
0x0000004d00160308ULL, 0x000ea40000000800ULL, 0x0000001687870220ULL, 0x004fce0000410000ULL,
0x0000040003147824ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00004000274c7824ULL, 0x000fe200078e020aULL, 0xfffff00014157812ULL, 0x000fc600078ec0ffULL,
0x00002000114c7824ULL, 0x000fe200078e024cULL, 0x000150000a147810ULL, 0x000fc80007ffe015ULL,
0x000170004c8a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x100fe400078e0214ULL,
0x0000001018187824ULL, 0x000fe200078e0214ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff4c7819ULL, 0x000fe40000011608ULL, 0x00000016ff15723eULL, 0x000fe400000000ffULL,
0x000000104c4e7810ULL, 0x000fe20007ffe0ffULL, 0x000000084c1e7836ULL, 0x000fe20000000000ULL,
0x0000541015157816ULL, 0x000fe20000000015ULL, 0x000000184c207836ULL, 0x000fc80000000000ULL,
0x00001f1e151e7589ULL, 0x0002a800000e0000ULL, 0x00001f4e151d7589ULL, 0x0002e800000e0000ULL,
0x00001f4c151f7589ULL, 0x00026800000e0000ULL, 0x00001f2015207589ULL, 0x00026400000e0000ULL,
0x000000001780783bULL, 0x0006a20000000200ULL, 0x000000101a687824ULL, 0x100fe400078e028aULL,
0x00000010195c7824ULL, 0x000fe200078e028aULL, 0x000000001850783bULL, 0x0006620000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f80807232ULL, 0x086fe40000000000ULL,
0x0000001f82827232ULL, 0x000fe40000000000ULL, 0x0000001e81817232ULL, 0x080fe40000000000ULL,
0x0000001e83837232ULL, 0x000fe40000000000ULL, 0x0000001d50507232ULL, 0x088fe40000000000ULL,
0x0000001d52527232ULL, 0x000fc40000000000ULL, 0x0000002051517232ULL, 0x080fe40000000000ULL,
0x0000002053537232ULL, 0x000fce0000000000ULL, 0x0000008a1b607211ULL, 0x000fe200078e20ffULL,
0x000000101c647824ULL, 0x000fe200078e028aULL, 0x000000006868783bULL, 0x000f620000004200ULL,
0x00000010854c7824ULL, 0x102fe400078e0214ULL, 0x0000001084147824ULL, 0x000fe200078e0214ULL,
0x000000005c5c783bULL, 0x000e680000004200ULL, 0x000000006060783bULL, 0x000e680000004200ULL,
0x000000006464783bULL, 0x000e680000004200ULL, 0x000000004c4c783bULL, 0x000e680000000200ULL,
0x000000001418783bULL, 0x0086e20000000200ULL, 0x000000688054723cULL, 0x024fec0000001854ULL,
0x0000006a8058723cULL, 0x000fec0000001858ULL, 0x0000005c8074723cULL, 0x002fec0000001874ULL,
0x0000005e8078723cULL, 0x000fec0000001878ULL, 0x00000060807c723cULL, 0x000fec000000187cULL,
0x000000628070723cULL, 0x000fec0000001870ULL, 0x00000064806c723cULL, 0x000fec000000186cULL,
0x000000668028723cULL, 0x000fec0000001828ULL, 0x00000068502c723cULL, 0x000fe2000000182cULL,
0x0000008887807221ULL, 0x000fca0000010000ULL, 0x0000006a5030723cULL, 0x000fec0000001830ULL,
0x0000005c5034723cULL, 0x000fec0000001834ULL, 0x0000005e5038723cULL, 0x000fec0000001838ULL,
0x00000060503c723cULL, 0x000fec000000183cULL, 0x000000625040723cULL, 0x000fec0000001840ULL,
0x000000645044723cULL, 0x000fec0000001844ULL, 0x000000665048723cULL, 0x000fe20000001848ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000208947ULL, 0x008fde0003800000ULL,
0x0000001f4c4c7232ULL, 0x080fe40000000000ULL, 0x0000001f4e4e7232ULL, 0x000fe40000000000ULL,
0x0000001e4d4d7232ULL, 0x080fe40000000000ULL, 0x0000001e4f4f7232ULL, 0x000fe40000000000ULL,
0x0000001d18187232ULL, 0x080fe40000000000ULL, 0x0000001d1a1a7232ULL, 0x000fc40000000000ULL,
0x0000002019197232ULL, 0x080fe40000000000ULL, 0x000000201b1b7232ULL, 0x000fce0000000000ULL,
0x0000008a21647211ULL, 0x000fe200078e20ffULL, 0x0000001022607824ULL, 0x100fe200078e028aULL,
0x0000000c0500720cULL, 0x000fe20003f06070ULL, 0x00000010235c7824ULL, 0x100fe200078e028aULL,
0x0000000100147802ULL, 0x000fe20000000f00ULL, 0x0000001024507824ULL, 0x000fe200078e028aULL,
0x000000006464783bULL, 0x000e680000004200ULL, 0x000000006060783bULL, 0x000ea80000004200ULL,
0x000000005c5c783bULL, 0x000ee80000004200ULL, 0x000000005050783bULL, 0x000f620000004200ULL,
0x01e6a01425ff79a7ULL, 0x0003e4000850003fULL, 0x000000644c54723cULL, 0x002fec0000001854ULL,
0x000000664c58723cULL, 0x000fec0000001858ULL, 0x000000604c74723cULL, 0x004fec0000001874ULL,
0x000000624c78723cULL, 0x000fec0000001878ULL, 0x0000005c4c7c723cULL, 0x008fec000000187cULL,
0x0000005e4c70723cULL, 0x000fec0000001870ULL, 0x000000504c6c723cULL, 0x020fec000000186cULL,
0x000000524c28723cULL, 0x000fec0000001828ULL, 0x00000064182c723cULL, 0x000fec000000182cULL,
0x000000661830723cULL, 0x000fec0000001830ULL, 0x000000601834723cULL, 0x000fec0000001834ULL,
0x000000621838723cULL, 0x000fec0000001838ULL, 0x0000005c183c723cULL, 0x000fec000000183cULL,
0x0000005e1840723cULL, 0x000fec0000001840ULL, 0x000000501844723cULL, 0x000fec0000001844ULL,
0x000000521848723cULL, 0x000fe20000001848ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff8800a48947ULL, 0x000fde000383ffffULL, 0x0000000000097919ULL, 0x000e620000002500ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0049ULL, 0x0000004400497202ULL, 0x000fe20000000f00ULL,
0x000000ffff4f7224ULL, 0x000fe200078e004bULL, 0x00000048004d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fe400078e004aULL, 0x000000ffff447224ULL, 0x000fe200078e0041ULL,
0x0000003c00417202ULL, 0x000fe20000000f00ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0047ULL,
0x000000ffff4a7224ULL, 0x000fc400078e0046ULL, 0x000000ffff487224ULL, 0x000fe200078e0045ULL,
0x0000004000457202ULL, 0x000fe20000000f00ULL, 0x000000ffff477224ULL, 0x000fe400078e0043ULL,
0x000000ffff467224ULL, 0x000fe400078e0042ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0039ULL,
0x000000ffff437224ULL, 0x000fe400078e003fULL, 0x000000ffff427224ULL, 0x000fc400078e003eULL,
0x000000ffff397224ULL, 0x000fe400078e0035ULL, 0x000000ffff407224ULL, 0x000fe200078e003dULL,
0x00000038003d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fe400078e003bULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000000c0900720cULL, 0x002fe20003f06070ULL,
0x000000ffff357224ULL, 0x000fe400078e0033ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0037ULL,
0x0000003400377202ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fc400078e0036ULL,
0x000000ffff337224ULL, 0x000fe200078e0031ULL, 0x0000003000317202ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fe400078e0032ULL, 0x000000ffff257224ULL, 0x000fe400078e002fULL,
0x000000ffff367224ULL, 0x000fe200078e002eULL, 0x0000000400540947ULL, 0x000fec0003800000ULL,
0x0180000080057836ULL, 0x000fca0000000000ULL, 0x7f80000005057812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x00009ba000127802ULL, 0x000fce0000000f00ULL, 0x000000f400287944ULL, 0x010fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008000057308ULL, 0x000e640000001000ULL,
0xbf80000005087423ULL, 0x002fc80000000080ULL, 0x800000ff08087221ULL, 0x000fc80000010100ULL,
0x0000000805057223ULL, 0x000fce0000000005ULL, 0x00000000000c7919ULL, 0x000f640000000000ULL,
0x00000002ff087819ULL, 0x022fe4000001160cULL, 0x000000080c107811ULL, 0x040fe400078ff0ffULL,
0x000000100c127811ULL, 0x040fe400078ff0ffULL, 0x000000180c147811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0805087589ULL, 0x000e6800000e0000ULL,
0x00001f10050b7589ULL, 0x000ea800000e0000ULL, 0x00001f12050c7589ULL, 0x000ee800000e0000ULL,
0x00001f14050f7589ULL, 0x000f6200000e0000ULL, 0x0000005408547220ULL, 0x042fe20000410000ULL,
0x0000005508557220ULL, 0x040fe20000410000ULL, 0x0000005808587220ULL, 0x040fe20000410000ULL,
0x0000005908597220ULL, 0x040fe20000410000ULL, 0x0000007408747220ULL, 0x040fe20000410000ULL,
0x0000007508757220ULL, 0x040fe20000410000ULL, 0x0000007808787220ULL, 0x040fe20000410000ULL,
0x0000007908797220ULL, 0x040fe20000410000ULL, 0x0000007c087c7220ULL, 0x040fe20000410000ULL,
0x0000007d087d7220ULL, 0x040fe20000410000ULL, 0x0000007008707220ULL, 0x040fe20000410000ULL,
0x0000007108717220ULL, 0x040fe20000410000ULL, 0x0000006c086c7220ULL, 0x040fe20000410000ULL,
0x0000006d086d7220ULL, 0x040fe20000410000ULL, 0x0000002808287220ULL, 0x040fe20000410000ULL,
0x0000002908297220ULL, 0x000fe20000410000ULL, 0x000000560b567220ULL, 0x044fe20000410000ULL,
0x000000570b577220ULL, 0x040fe20000410000ULL, 0x0000005a0b5a7220ULL, 0x040fe20000410000ULL,
0x0000005b0b5b7220ULL, 0x040fe20000410000ULL, 0x000000760b767220ULL, 0x040fe20000410000ULL,
0x000000770b777220ULL, 0x040fe20000410000ULL, 0x0000007a0b7a7220ULL, 0x040fe20000410000ULL,
0x0000007b0b7b7220ULL, 0x040fe20000410000ULL, 0x0000007e0b7e7220ULL, 0x040fe20000410000ULL,
0x0000007f0b7f7220ULL, 0x040fe20000410000ULL, 0x000000720b727220ULL, 0x040fe20000410000ULL,
0x000000730b737220ULL, 0x040fe20000410000ULL, 0x0000006e0b6e7220ULL, 0x040fe20000410000ULL,
0x0000006f0b6f7220ULL, 0x040fe20000410000ULL, 0x0000002a0b2a7220ULL, 0x040fe20000410000ULL,
0x0000002b0b2b7220ULL, 0x000fe20000410000ULL, 0x0000002c0c2c7220ULL, 0x048fe20000410000ULL,
0x0000002d0c2d7220ULL, 0x040fe20000410000ULL, 0x000000310c317220ULL, 0x040fe20000410000ULL,
0x000000330c337220ULL, 0x040fe20000410000ULL, 0x000000370c377220ULL, 0x040fe20000410000ULL,
0x000000390c397220ULL, 0x040fe20000410000ULL, 0x0000003d0c3d7220ULL, 0x040fe20000410000ULL,
0x0000003c0c3c7220ULL, 0x040fe20000410000ULL, 0x000000410c417220ULL, 0x040fe20000410000ULL,
0x000000400c407220ULL, 0x040fe20000410000ULL, 0x000000450c457220ULL, 0x040fe20000410000ULL,
0x000000440c447220ULL, 0x040fe20000410000ULL, 0x000000490c497220ULL, 0x040fe20000410000ULL,
0x000000480c487220ULL, 0x040fe20000410000ULL, 0x0000004d0c4d7220ULL, 0x040fe20000410000ULL,
0x0000004c0c4c7220ULL, 0x000fe20000410000ULL, 0x000000360f367220ULL, 0x060fe20000410000ULL,
0x000000250f257220ULL, 0x040fe20000410000ULL, 0x000000380f387220ULL, 0x040fe20000410000ULL,
0x000000350f357220ULL, 0x040fe20000410000ULL, 0x0000003a0f3a7220ULL, 0x040fe20000410000ULL,
0x0000003b0f3b7220ULL, 0x040fe20000410000ULL, 0x0000003e0f3e7220ULL, 0x040fe20000410000ULL,
0x0000003f0f3f7220ULL, 0x040fe20000410000ULL, 0x000000420f427220ULL, 0x040fe20000410000ULL,
0x000000430f437220ULL, 0x040fe20000410000ULL, 0x000000460f467220ULL, 0x040fe20000410000ULL,
0x000000470f477220ULL, 0x040fe20000410000ULL, 0x0000004a0f4a7220ULL, 0x040fe20000410000ULL,
0x0000004b0f4b7220ULL, 0x040fe20000410000ULL, 0x0000004e0f4e7220ULL, 0x040fe20000410000ULL,
0x0000004f0f4f7220ULL, 0x000fce0000410000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x000000545514723eULL, 0x000fe400000000ffULL, 0x000000747516723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000787917723eULL, 0x000fc400000000ffULL,
0x0000007c7d18723eULL, 0x000fe400000000ffULL, 0x000000707119723eULL, 0x000fe400000000ffULL,
0x0000006c6d1a723eULL, 0x000fe400000000ffULL, 0x00000028291b723eULL, 0x000fe400000000ffULL,
0x00000056571c723eULL, 0x000fe400000000ffULL, 0x0000005a5b1d723eULL, 0x000fc400000000ffULL,
0x00000076771e723eULL, 0x000fe400000000ffULL, 0x0000007a7b1f723eULL, 0x000fe400000000ffULL,
0x0000007e7f20723eULL, 0x000fe400000000ffULL, 0x000000727321723eULL, 0x000fe400000000ffULL,
0x0000ffff05087812ULL, 0x002fe400078ec0ffULL, 0xfffffff8ff0c7812ULL, 0x000fc400078ee205ULL,
0x00000003ff087819ULL, 0x000fe40000011608ULL, 0x000000180c137810ULL, 0x000fe20007ffe0ffULL,
0x000000080c0f7836ULL, 0x000fe20000000000ULL, 0x0000000308087812ULL, 0x000fe200078ec0ffULL,
0x000000100c127836ULL, 0x000fe20000000000ULL, 0x000000030c107819ULL, 0x000fe200000006ffULL,
0x000000080f247824ULL, 0x000fe200078e00ffULL, 0x0000006e6f22723eULL, 0x000fe200000000ffULL,
0x0000000108087824ULL, 0x000fe200078e0205ULL, 0x0000002a2b23723eULL, 0x000fe200000000ffULL,
0x0000000812307824ULL, 0x000fe200078e00ffULL, 0x0000002c2d28723eULL, 0x000fe200000000ffULL,
0x0000000813347824ULL, 0x000fe200078e00ffULL, 0x00000007080b7812ULL, 0x040fe200078ec0ffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000408087812ULL, 0x000fe200078e3cffULL,
0x0000000812157824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fc400078ee20bULL,
0xfffffff830307812ULL, 0x000fe400078ee20bULL, 0xfffffff834347812ULL, 0x000fe400078ee20bULL,
0x000000030c0b7819ULL, 0x000fe400000006ffULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x0000000a110c7211ULL, 0x000fe400078e68ffULL, 0xfffffff80f267812ULL, 0x010fc400078ee208ULL,
0xfffffff80b127812ULL, 0x000fe200078ee208ULL, 0x00001000270f7824ULL, 0x100fe200078e020cULL,
0xfffffff815327812ULL, 0x000fe200078ee208ULL, 0x000000010e0b7824ULL, 0x000fe200078e0205ULL,
0x000000585915723eULL, 0x000fe200000000ffULL, 0x0000001010107824ULL, 0x100fe200078e020fULL,
0x0000000f12127211ULL, 0x000fe200078e20ffULL, 0x0000001024247824ULL, 0x100fe200078e020fULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000001026267824ULL, 0x100fe200078e020fULL,
0x000000313329723eULL, 0x000fe200000000ffULL, 0x0000001030307824ULL, 0x100fe200078e020fULL,
0x00000037392a723eULL, 0x000fe200000000ffULL, 0x0000001410007844ULL, 0x0003e20000000200ULL,
0x0000003d3c2b723eULL, 0x000fe200000000ffULL, 0x0000001032327824ULL, 0x100fe200078e020fULL,
0x00000041402c723eULL, 0x000fe200000000ffULL, 0x0000001812007844ULL, 0x0005e20000000200ULL,
0x00000045442d723eULL, 0x000fe200000000ffULL, 0x0000001008087824ULL, 0x000fe200078e020fULL,
0x00000049482e723eULL, 0x000fe200000000ffULL, 0x0000001c24007844ULL, 0x000fe20000000200ULL,
0x0000004d4c2f723eULL, 0x000fe200000000ffULL, 0x000000100b0a7824ULL, 0x000fe200078e020cULL,
0x0000000f34347211ULL, 0x000fe200078e20ffULL, 0x0000002026007844ULL, 0x000fe20000000200ULL,
0x000000010000780cULL, 0x000fc40003f05270ULL, 0x000000362514723eULL, 0x002fe200000000ffULL,
0x0000002830007844ULL, 0x000fe20000000200ULL, 0x000000383515723eULL, 0x000fe400000000ffULL,
0x0000003a3b16723eULL, 0x000fe200000000ffULL, 0x0000002c32007844ULL, 0x000fe20000000200ULL,
0x0000003e3f17723eULL, 0x000fe400000000ffULL, 0x000000424318723eULL, 0x004fe400000000ffULL,
0x000000464719723eULL, 0x000fe200000000ffULL, 0x0000001434007844ULL, 0x000fe20000000200ULL,
0x0000004a4b1a723eULL, 0x000fc400000000ffULL, 0x0000004e4f1b723eULL, 0x000fca00000000ffULL,
0x0000001808007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000a1c7984ULL, 0x000e680000000c00ULL, 0x000400000a387984ULL, 0x000ea80000000c00ULL,
0x000800000a407984ULL, 0x000ee80000000c00ULL, 0x000c00000a2c7984ULL, 0x000f280000000c00ULL,
0x001000000a207984ULL, 0x000f680000000c00ULL, 0x001400000a3c7984ULL, 0x000f280000000c00ULL,
0x001800000a287984ULL, 0x000f280000000c00ULL, 0x001c00000a147984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x002fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff3b3b7230ULL, 0x004fe40000000000ULL, 0x200000ff3a3a7230ULL, 0x000fe40000000000ULL,
0x200000ff39397230ULL, 0x000fc40000000000ULL, 0x200000ff38387230ULL, 0x000fe40000000000ULL,
0x200000ff43437230ULL, 0x008fe40000000000ULL, 0x200000ff42427230ULL, 0x000fe40000000000ULL,
0x200000ff41417230ULL, 0x000fe40000000000ULL, 0x200000ff40407230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x010fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x020fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fc40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000003f3b3b7230ULL, 0x000fe40000000000ULL, 0x0000003e3a3a7230ULL, 0x000fe20000000000ULL,
0x0000001c0a007388ULL, 0x0003e20000000c00ULL, 0x0000003d39397230ULL, 0x000fe40000000000ULL,
0x0000003c38387230ULL, 0x000fe40000000000ULL, 0x0000002b43437230ULL, 0x000fc40000000000ULL,
0x0000002a42427230ULL, 0x000fe20000000000ULL, 0x000400380a007388ULL, 0x0003e20000000c00ULL,
0x0000002941417230ULL, 0x000fe40000000000ULL, 0x0000002840407230ULL, 0x000fe40000000000ULL,
0x000000172f2f7230ULL, 0x000fe40000000000ULL, 0x000000162e2e7230ULL, 0x000fe20000000000ULL,
0x000800400a007388ULL, 0x0003e20000000c00ULL, 0x000000152d2d7230ULL, 0x000fc40000000000ULL,
0x000000142c2c7230ULL, 0x000fca0000000000ULL, 0x000c002c0a007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003400648947ULL, 0x000fea0003800000ULL,
0x00000400ff1b7b82ULL, 0x000ea20000000800ULL, 0x0000000000127919ULL, 0x000ee20000002600ULL,
0x000000800b157836ULL, 0x000fe40000000000ULL, 0x000000c00b177836ULL, 0x000fe20000000000ULL,
0x0000000000147919ULL, 0x000ee60000002700ULL, 0x00009800ff087b82ULL, 0x000ea20000000800ULL,
0x000000000a207984ULL, 0x000f280000000c00ULL, 0x000400000a287984ULL, 0x000f260000000c00ULL,
0x00009c00ff367b82ULL, 0x000f620000000a00ULL, 0x000800000a2c7984ULL, 0x002f280000000c00ULL,
0x000c00000a307984ULL, 0x0003220000000c00ULL, 0x000000081b137224ULL, 0x004fc800078e02ffULL,
0x0000000013107224ULL, 0x040fe200078e02ffULL, 0x0000000f13087811ULL, 0x000fe200078e10ffULL,
0x0000001b141b7224ULL, 0x008fe400078e0212ULL, 0x000000400b137836ULL, 0x000fe20000000000ULL,
0xfffffff0081d7812ULL, 0x000fc800078ec0ffULL, 0x0000001d10257211ULL, 0x000fca00078e38ffULL,
0x0000008010107824ULL, 0x000fc800078e0225ULL, 0x0000007f10087836ULL, 0x000fe40000000000ULL,
0x000000001b107224ULL, 0x000fc600078e02ffULL, 0xffffff80081f7812ULL, 0x000fe200078ec0ffULL,
0x0000000110167824ULL, 0x000fc600078e0209ULL, 0x000000361f097210ULL, 0x020fc80007f1e0ffULL,
0x0000000916087211ULL, 0x040fe400078268ffULL, 0x00000037ff097210ULL, 0x000fe400007fe4ffULL,
0x0000000127ff7812ULL, 0x000fe4000780f803ULL, 0x0000000916097211ULL, 0x000fe400008f6cffULL,
0x000000361d1c7210ULL, 0x000fe20007f3e0ffULL, 0x0000100011087825ULL, 0x000fc600078e0008ULL,
0x00000037ff357210ULL, 0x000fe20000ffe4ffULL, 0x000000100b0a7825ULL, 0x002fc800078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x0000001017087825ULL, 0x000fe200078e0008ULL, 0x0000000000400947ULL, 0x010fec0003800000ULL,
0x0000001005187824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011605ULL,
0x0000008016177824ULL, 0x000fc600078e00ffULL, 0x0000007018197812ULL, 0x000fe400078ec0ffULL,
0x0000000c1a1e7812ULL, 0x000fe400078ec0ffULL, 0x0000003617187210ULL, 0x000fe40007ebe025ULL,
0x00000019ff1a7819ULL, 0x000fe40000011616ULL, 0x0000001c19177210ULL, 0x000fe40007a3e017ULL,
0x000000181e187210ULL, 0x000fc40007c7e019ULL, 0x000000371a197210ULL, 0x000fe40002fec4ffULL,
0x000000171e167210ULL, 0x000fe40007fbe0ffULL, 0x00000035ff1a7210ULL, 0x000fe40000fe441aULL,
0x00000019ff197210ULL, 0x000fc60001fe84ffULL, 0x000000ffff177224ULL, 0x000fca00028e061aULL,
0x0000008916007986ULL, 0x0003e8000c101906ULL, 0x0000008018007986ULL, 0x0003e4000c101906ULL,
0x000000ff0500720cULL, 0x000fe20000705670ULL, 0x000000200a007986ULL, 0x0005e8000c101d06ULL,
0x0000002812007986ULL, 0x0005e8000c101d06ULL, 0x0000002c14007986ULL, 0x0005e8000c101d06ULL,
0x0000003008007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009c00ff087b82ULL, 0x004ea20000000a00ULL,
0xffffffff000b7810ULL, 0x000fe20007ffe0ffULL, 0x000000041b087825ULL, 0x004fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000000b080879a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000b0800720cULL, 0x010fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000008ff007988ULL, 0x0007e60008000004ULL, 0x0000000000097919ULL, 0x004ea20000008800ULL,
0x0000040000247802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065409247816ULL, 0x004fca0000000024ULL,
0x0000000024087984ULL, 0x008ea40000000000ULL, 0x000000ff0800720cULL, 0x004fda0003f05270ULL,
0x0000002c00e88947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001005037824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011605ULL, 0x0000001c10087211ULL, 0x000fe400078038ffULL,
0x0000007003097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000003510037211ULL, 0x000fe400000f3cffULL, 0x000000080a087210ULL, 0x000fc8000791e009ULL,
0x00000003ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608037981ULL, 0x000528000c1e1900ULL,
0x00008006080a7981ULL, 0x000522000c1e1900ULL, 0x000000020000780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x0001000608147981ULL, 0x000522000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x0001800608167981ULL, 0x002322000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x0002000608187981ULL, 0x000322000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x00028006081a7981ULL, 0x000322000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000080000780cULL, 0x000fe20003f06070ULL,
0x00030006081c7981ULL, 0x000318000c1e1900ULL, 0x00038006081e0981ULL, 0x000324000c1e1900ULL,
0x0000000700087836ULL, 0x002fca0000000000ULL, 0x00000003ff0b7819ULL, 0x000fc80000011608ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001d10137211ULL, 0x040fe200078038ffULL, 0x000000ffff127224ULL, 0x010fe200078e0003ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000003613137210ULL, 0x000fe40007f3e0ffULL, 0x000000ff10087211ULL, 0x000fe400000f3cffULL,
0x0000078013137810ULL, 0x000fc80007f5e0ffULL, 0x00000008ff157210ULL, 0x000fd200017e2437ULL,
0x0000000400007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050b007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000001203037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000405087819ULL, 0x000fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffc800608127981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000a03037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffd0006080a7981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000001403037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000405087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffd800608147981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001603037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffe000608167981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001803037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000405087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffe800608187981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001a03037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xffff0006081a7981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001c03037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000405087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xffff8006081c7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001e03037209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000813087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0x00000006081e7981ULL, 0x000326000c1e1900ULL, 0x0000040013137810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc6000fffe03fULL, 0x00000015ff157210ULL, 0x000fe20000ffe4ffULL,
0xfffffff8002c8947ULL, 0x000ff0000383ffffULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x0000001005087824ULL, 0x006fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x010fc80000011605ULL,
0x0000007008097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a087812ULL, 0x000fc800078ec0ffULL,
0x0000002408087210ULL, 0x000fca0007ffe009ULL, 0x0000000308007388ULL, 0x0003e40000000800ULL,
0x00009c00ff207b82ULL, 0x000ea20000000a00ULL, 0x000000070500780cULL, 0x000fe20003f04070ULL,
0x0000100011037824ULL, 0x002fe200078e00ffULL, 0x0000001027237210ULL, 0x000fe20007ffe0ffULL,
0x00000010052d7824ULL, 0x000fe200078e00ffULL, 0x000000010d0a7812ULL, 0x040fe200078ec0ffULL,
0x0000006005177836ULL, 0x000fe20000000000ULL, 0x0000000c0d0d7819ULL, 0x000fe200000006ffULL,
0x0000008005197836ULL, 0x000fe20000000000ULL, 0x00000001ff2c7819ULL, 0x000fe40000011605ULL,
0x0000000000707805ULL, 0x000fc4000001ff00ULL, 0x000000a0051b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000000702d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000020027148824ULL, 0x140fe200078e0224ULL, 0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL,
0x0000020027088824ULL, 0x000fe200078e0224ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000001411158211ULL, 0x040fe200078e40ffULL,
0x00000100110b8824ULL, 0x000fe200078e0208ULL, 0x000000242c2e7210ULL, 0x000fe20007ffe02dULL,
0x0000400027147824ULL, 0x000fe200078e0224ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000201f127210ULL, 0x004fe20007f3e0ffULL, 0x000000800a288824ULL, 0x040fe200078e020bULL,
0x000000201d267210ULL, 0x000fe20007f7e0ffULL, 0x000000800a2a8824ULL, 0x000fe200078e0215ULL,
0x000010000d0a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0621ULL,
0x0000002025257210ULL, 0x000fe20007f3e0ffULL, 0x00002000110d7824ULL, 0x000fe200078e0214ULL,
0x0000004005157810ULL, 0x000fe20007ffe0ffULL, 0x0000200023087825ULL, 0x000fe200078e0012ULL,
0x000000002e2e7984ULL, 0x000e620000000800ULL, 0x0000000000427805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000010d0a7824ULL, 0x000fe200078e020aULL,
0x0000000308087210ULL, 0x000fe20007f5e0ffULL, 0x00000020050b7836ULL, 0x000fe20000000000ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000000c0051d7836ULL, 0x000fe20000000000ULL,
0x0000000a05297211ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000002623228211ULL, 0x040fe200078438ffULL, 0x000000e0051f7836ULL, 0x000fe20000000000ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2f7224ULL, 0x000fe200008e0621ULL,
0x0000002523208211ULL, 0x000fe200078238ffULL, 0x000000100b0a7825ULL, 0x000fe200078e0008ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000001015147825ULL, 0x100fe200078e0008ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000001017167825ULL, 0x000fe200078e0008ULL,
0x00000000004c7805ULL, 0x000fc4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x0000001019187825ULL, 0x100fe200078e0008ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x0000000000607805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x000000101b1a7825ULL, 0x000fe200078e0008ULL,
0x0000000000627805ULL, 0x000fc4000001ff00ULL, 0x0000000000547805ULL, 0x000fe4000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x000000101d1c7825ULL, 0x100fe200078e0008ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000667805ULL, 0x000fe4000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x000000101f1e7825ULL, 0x000fe200078e0008ULL,
0x0000000000687805ULL, 0x000fc4000001ff00ULL, 0x00000000005a7805ULL, 0x000fe4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff307224ULL, 0x000fe200018e0621ULL,
0x0000002f23218211ULL, 0x000fe200008f3cffULL, 0x0000001005087825ULL, 0x000fe200078e0008ULL,
0x000000002700720cULL, 0x000fe40003f26070ULL, 0x00000000005c7805ULL, 0x000fe4000001ff00ULL,
0x0000003023238211ULL, 0x000fc400010f3cffULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008297faeULL, 0x0005e2000b901c46ULL,
0x00000000005e7805ULL, 0x000fe4000001ff00ULL, 0x00000000006e7805ULL, 0x000fe2000001ff00ULL,
0x003800000a297faeULL, 0x0007e8000b901c46ULL, 0x0058000014297faeULL, 0x0009e8000b901c46ULL,
0x0078000016297faeULL, 0x000be2000b901c46ULL, 0x0000001005088825ULL, 0x004fc600078e0020ULL,
0x0098000018297faeULL, 0x0005e2000b901c46ULL, 0x00000010050a8825ULL, 0x008fc600078e0022ULL,
0x00b800001a297faeULL, 0x0005e2000b901c46ULL, 0x0000001005158824ULL, 0x050fe200078e0228ULL,
0x0000002a05178211ULL, 0x020fe400078e20ffULL, 0x00d800001c297faeULL, 0x0005e8000b901c46ULL,
0x00f800001e297faeULL, 0x0005e8000b901c46ULL, 0x0858000008158faeULL, 0x0005e8000b901c46ULL,
0x081800000a178faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001000001947ULL, 0x002fea0003800000ULL, 0x00000003ff0a7819ULL, 0x104fe20000011605ULL,
0x00000200277e7824ULL, 0x000fe200078e0224ULL, 0xfffffff8ff0b7812ULL, 0x000fe200078ee205ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000000030a087812ULL, 0x000fe200078ec0ffULL,
0x00000100117e7824ULL, 0x000fe200078e027eULL, 0x0000000405097810ULL, 0x000fe20007ffe00aULL,
0x000000080b0a7836ULL, 0x000fe20000000000ULL, 0x000000100b147810ULL, 0x000fe20007ffe0ffULL,
0x000000180b157836ULL, 0x000fe20000000000ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000080b167824ULL, 0x000fe200078e00ffULL, 0x0000000314747819ULL, 0x000fe200000006ffULL,
0x000000080a727824ULL, 0x000fe200078e00ffULL, 0x00000002ff7c7819ULL, 0x100fe20000011605ULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0xfffffff816737812ULL, 0x000fe200078ee209ULL,
0x0000000108087824ULL, 0x000fe200078e0205ULL, 0xfffffff872727812ULL, 0x000fe200078ee209ULL,
0x000000080b777824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee209ULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0xfffffff818757812ULL, 0x000fe200078ee209ULL,
0x000000080a097824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000087c7d7836ULL, 0x000fe20000000000ULL, 0x00000003140b7819ULL, 0x000fe200000006ffULL,
0x000000107c7f7836ULL, 0x000fe20000000000ULL, 0xfffffff809767812ULL, 0x000fc400078ee208ULL,
0xfffffff877777812ULL, 0x000fe400078ee208ULL, 0xfffffff80b787812ULL, 0x000fe400078ee208ULL,
0xfffffff8157a7812ULL, 0x000fe400078ee208ULL, 0x0000002700297202ULL, 0x000fe40000000f00ULL,
0x000000187c797810ULL, 0x000fce0007ffe0ffULL, 0x00000002297b7836ULL, 0x000fca0000000000ULL,
0x000000007b00720cULL, 0x000fda0003f06070ULL, 0x0000000000cc0947ULL, 0x000fea0003800000ULL,
0x000000070500780cULL, 0x000fe20003f44070ULL, 0x0000000110237824ULL, 0x100fe200078e027bULL,
0x00000001ff0a7819ULL, 0x000fe2000001167bULL, 0x0000004005177836ULL, 0x000fe20000000000ULL,
0x0000002005157810ULL, 0x000fe20007ffe0ffULL, 0x0000200023087825ULL, 0x000fe200078e0012ULL,
0x000000010a817812ULL, 0x000fc600078ec0ffULL, 0x000008007b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000308087210ULL, 0x000fe20007f1e0ffULL, 0x0000006005197836ULL, 0x000fe40000000000ULL,
0x000002002714a824ULL, 0x000fe200078e0224ULL, 0x000010000a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000252320a211ULL, 0x000fe200078038ffULL,
0x00000080051b7836ULL, 0x000fe20000000000ULL, 0x0000000a0d0a7210ULL, 0x000fe20007ffe0ffULL,
0x000000a0051d7836ULL, 0x000fe20000000000ULL, 0x00000014117ea211ULL, 0x000fe200078e40ffULL,
0x000000c0051f7836ULL, 0x000fe20000000000ULL, 0x0000000a052b7211ULL, 0x000fe200078e20ffULL,
0x000000e005217836ULL, 0x000fe20000000000ULL, 0x000000262322a211ULL, 0x000fe200078238ffULL,
0x00000010050a7825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x100fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001017167825ULL, 0x100fe200078e0008ULL, 0x00380000142b7faeULL, 0x0005e6000b901c46ULL,
0x0000001019187825ULL, 0x100fe200078e0008ULL, 0x00580000162b7faeULL, 0x0005e6000b901c46ULL,
0x000000101b1a7825ULL, 0x100fe200078e0008ULL, 0x00780000182b7faeULL, 0x0005e6000b901c46ULL,
0x000000101d1c7825ULL, 0x100fe200078e0008ULL, 0x009800001a2b7faeULL, 0x0005e6000b901c46ULL,
0x000000101f1e7825ULL, 0x100fe200078e0008ULL, 0x00b800001c2b7faeULL, 0x0005e6000b901c46ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000002f2321a211ULL, 0x040fe200000f3cffULL,
0x00d800001e2b7faeULL, 0x0005e2000b901c46ULL, 0x000000302323a211ULL, 0x000fe200008f3cffULL,
0x000000808128a824ULL, 0x000fc400078e027eULL, 0x00000080812aa824ULL, 0x000fe200078e027eULL,
0x00f80000082b7faeULL, 0x0005e2000b901c46ULL, 0x000000100520a825ULL, 0x000fc800078e0020ULL,
0x000000100581a824ULL, 0x040fe400078e0228ULL, 0x000000100522a825ULL, 0x000fc600078e0022ULL,
0x085800002081afaeULL, 0x0005e2000b901c46ULL, 0x00000010050ba824ULL, 0x002fca00078e022aULL,
0x08180000220bafaeULL, 0x0005e4000b901c46ULL, 0x0000002900097202ULL, 0x004fe20000000f00ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000080009087824ULL, 0x000fca00078e00ffULL,
0x0000100008087812ULL, 0x000fc800078ec0ffULL, 0x000001800d297810ULL, 0x000fe20007ffe008ULL,
0x0000004009087824ULL, 0x000fc600078e00ffULL, 0x00000029731c7211ULL, 0x080fe200078e20ffULL,
0x0000001077207824ULL, 0x100fe200078e0229ULL, 0x0000008008087812ULL, 0x000fe200078ec0ffULL,
0x0000001075817824ULL, 0x100fe200078e0229ULL, 0x0000002978187211ULL, 0x000fe200078e20ffULL,
0x000000107a287824ULL, 0x000fe200078e0229ULL, 0x0000007e2d097210ULL, 0x000fe20007ffe008ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000012c2a7824ULL, 0x000fe200078e0209ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000001076087824ULL, 0x100fe400078e0229ULL,
0x0000001072147824ULL, 0x100fe200078e0229ULL, 0x008180002a8f7984ULL, 0x000ea20000000800ULL,
0x0000001074807824ULL, 0x000fc600078e0229ULL, 0x008580002a997984ULL, 0x000fe80000000800ULL,
0x000000002020783bULL, 0x000ee80000000200ULL, 0x000000002828783bULL, 0x000f280000000200ULL,
0x000000000808783bULL, 0x000f680000000200ULL, 0x000000001414783bULL, 0x000f280000000200ULL,
0x000000001818783bULL, 0x000fe20000000200ULL, 0x2000001cff8a7230ULL, 0x002fc40000004100ULL,
0x3000001cff8b7230ULL, 0x000fe40000004100ULL, 0x0000008f2e1c7221ULL, 0x004fe20000010100ULL,
0x2000001dff8c7230ULL, 0x000fe40000004100ULL, 0x3000001dff8d7230ULL, 0x000fe40000004100ULL,
0x3fb8aa3b1c967820ULL, 0x000fe20000410000ULL, 0x2000001eff8e7230ULL, 0x000fe40000004100ULL,
0x3000001eff8f7230ULL, 0x000fe20000004100ULL, 0x0000009600987308ULL, 0x000e620000000800ULL,
0x2000001fff907230ULL, 0x000fc40000004100ULL, 0x3000001fff917230ULL, 0x000fe40000004100ULL,
0x00000000811c783bULL, 0x000fe20000000200ULL, 0x20000020ff827230ULL, 0x008fe40000004100ULL,
0x30000020ff837230ULL, 0x000fe40000004100ULL, 0x20000021ff847230ULL, 0x000fe40000004100ULL,
0x30000021ff857230ULL, 0x000fe40000004100ULL, 0x20000022ff867230ULL, 0x000fc40000004100ULL,
0x0000009998aa7220ULL, 0x002fe20000410000ULL, 0x30000022ff877230ULL, 0x000fe40000004100ULL,
0x20000023ff887230ULL, 0x000fe40000004100ULL, 0x00000070aa707221ULL, 0x000fe20000010000ULL,
0x30000023ff897230ULL, 0x000fe20000004100ULL, 0x00001f7caaa97589ULL, 0x000e6200000e0000ULL,
0x20000028ffa07230ULL, 0x010fe40000004100ULL, 0x30000028ffa17230ULL, 0x000fe20000004100ULL,
0x000000008020783bULL, 0x0004e20000000200ULL, 0x20000029ff287230ULL, 0x000fc40000004100ULL,
0x30000029ff297230ULL, 0x000fe20000004100ULL, 0x00001f7daaab7589ULL, 0x000f2200000e0000ULL,
0x30000008ff937230ULL, 0x020fe40000004100ULL, 0x2000000aff927230ULL, 0x000fe40000004100ULL,
0x20000008ff807230ULL, 0x004fe40000004100ULL, 0x3000000aff957230ULL, 0x000fe40000004100ULL,
0x20000014ff947230ULL, 0x000fc40000004100ULL, 0x30000014ff817230ULL, 0x000fe40000004100ULL,
0x20000016ff967230ULL, 0x000fe40000004100ULL, 0x30000016ff977230ULL, 0x000fe40000004100ULL,
0x000000a9826f7223ULL, 0x082fe2000001006fULL, 0x2000001effa67230ULL, 0x000fe40000004100ULL,
0x000000a9836e7223ULL, 0x000fe2000001006eULL, 0x3000001effa77230ULL, 0x000fc40000004100ULL,
0x000000a9846d7223ULL, 0x080fe2000001006dULL, 0x2000001fff1e7230ULL, 0x000fe40000004100ULL,
0x000000a9856c7223ULL, 0x080fe2000001006cULL, 0x3000001fffa87230ULL, 0x000fe40000004100ULL,
0x000000a9866b7223ULL, 0x080fe2000001006bULL, 0x00001f7faa1f7589ULL, 0x000fe200000e0000ULL,
0x20000018ff987230ULL, 0x000fe40000004100ULL, 0x000000a9876a7223ULL, 0x000fe2000001006aULL,
0x30000018ff997230ULL, 0x000fe20000004100ULL, 0x00001f79aaaa7589ULL, 0x000e6200000e0000ULL,
0x2000001aff9a7230ULL, 0x000fc40000004100ULL, 0x000000a988697223ULL, 0x080fe20000010069ULL,
0x3000001aff9b7230ULL, 0x000fe40000004100ULL, 0x000000a989687223ULL, 0x080fe20000010068ULL,
0x2000002affa27230ULL, 0x000fe40000004100ULL, 0x000000a98a677223ULL, 0x080fe20000010067ULL,
0x20000020ff9c7230ULL, 0x008fe40000004100ULL, 0x000000a98b667223ULL, 0x000fe20000010066ULL,
0x30000020ff9d7230ULL, 0x000fc40000004100ULL, 0x000000a98c657223ULL, 0x080fe20000010065ULL,
0x20000022ff9e7230ULL, 0x000fe40000004100ULL, 0x000000a98d647223ULL, 0x080fe20000010064ULL,
0x30000022ff9f7230ULL, 0x000fe40000004100ULL, 0x000000a98e637223ULL, 0x080fe20000010063ULL,
0x3000002affa37230ULL, 0x000fe40000004100ULL, 0x000000a98f627223ULL, 0x000fe20000010062ULL,
0x2000001cffa47230ULL, 0x000fc40000004100ULL, 0x000000a990617223ULL, 0x080fe20000010061ULL,
0x3000001cffa57230ULL, 0x000fe40000004100ULL, 0x000000a991607223ULL, 0x000fe20000010060ULL,
0x20000009ff087230ULL, 0x000fe40000004100ULL, 0x000000ab805f7223ULL, 0x010fe2000001005fULL,
0x2000000bff0a7230ULL, 0x000fe40000004100ULL, 0x000000aa293c7223ULL, 0x002fe2000001003cULL,
0x0000007b00297202ULL, 0x000fe20000000f00ULL, 0x20000015ff147230ULL, 0x000fc40000004100ULL,
0x000000ab935e7223ULL, 0x080fe2000001005eULL, 0x20000017ff167230ULL, 0x000fe20000004100ULL,
0x000000002900720cULL, 0x000fe20003f06070ULL, 0x20000019ff187230ULL, 0x000fe40000004100ULL,
0x000000ab085d7223ULL, 0x080fe2000001005dULL, 0x2000001bff1a7230ULL, 0x000fe40000004100ULL,
0x000000ab925b7223ULL, 0x080fe2000001005bULL, 0x20000021ff207230ULL, 0x000fe40000004100ULL,
0x000000ab955a7223ULL, 0x000fe2000001005aULL, 0x20000023ff227230ULL, 0x000fc40000004100ULL,
0x000000ab0a597223ULL, 0x080fe20000010059ULL, 0x2000002bff2a7230ULL, 0x000fe40000004100ULL,
0x000000ab94577223ULL, 0x080fe20000010057ULL, 0x2000001dff1c7230ULL, 0x000fe40000004100ULL,
0x000000ab81567223ULL, 0x080fe20000010056ULL, 0x30000009ff097230ULL, 0x000fe40000004100ULL,
0x000000ab14557223ULL, 0x000fe20000010055ULL, 0x3000000bff0b7230ULL, 0x000fc40000004100ULL,
0x000000ab96537223ULL, 0x080fe20000010053ULL, 0x30000015ff157230ULL, 0x000fe40000004100ULL,
0x000000ab095c7223ULL, 0x080fe2000001005cULL, 0x30000017ff177230ULL, 0x000fe40000004100ULL,
0x000000ab0b587223ULL, 0x080fe20000010058ULL, 0x30000019ff197230ULL, 0x000fe40000004100ULL,
0x000000ab15547223ULL, 0x000fe20000010054ULL, 0x3000001bff1b7230ULL, 0x000fc40000004100ULL,
0x000000ab97527223ULL, 0x080fe20000010052ULL, 0x30000021ff217230ULL, 0x000fe40000004100ULL,
0x000000ab16517223ULL, 0x080fe20000010051ULL, 0x30000023ff237230ULL, 0x000fe40000004100ULL,
0x000000ab17507223ULL, 0x000fe20000010050ULL, 0x3000002bff2b7230ULL, 0x000fe40000004100ULL,
0x0000001f984f7223ULL, 0x000fe2000001004fULL, 0x3000001dff1d7230ULL, 0x000fc40000004100ULL,
0x0000001f994e7223ULL, 0x080fe2000001004eULL, 0x0000001f184d7223ULL, 0x080fe2000001004dULL,
0x0000001f194c7223ULL, 0x080fe2000001004cULL, 0x0000001f9a4b7223ULL, 0x080fe2000001004bULL,
0x0000001f9b4a7223ULL, 0x080fe2000001004aULL, 0x0000001f1a497223ULL, 0x080fe20000010049ULL,
0x0000001f1b487223ULL, 0x080fe20000010048ULL, 0x0000001f9c477223ULL, 0x080fe20000010047ULL,
0x0000001f9d467223ULL, 0x080fe20000010046ULL, 0x0000001f20457223ULL, 0x080fe20000010045ULL,
0x0000001f21447223ULL, 0x080fe20000010044ULL, 0x0000001f9e437223ULL, 0x080fe20000010043ULL,
0x0000001f9f427223ULL, 0x080fe20000010042ULL, 0x0000001f22417223ULL, 0x080fe20000010041ULL,
0x0000001f23407223ULL, 0x000fe20000010040ULL, 0x000000aaa03f7223ULL, 0x080fe2000001003fULL,
0x000000aaa13e7223ULL, 0x080fe2000001003eULL, 0x000000aa283d7223ULL, 0x080fe2000001003dULL,
0x000000aaa23b7223ULL, 0x080fe2000001003bULL, 0x000000aaa33a7223ULL, 0x080fe2000001003aULL,
0x000000aa2a397223ULL, 0x080fe20000010039ULL, 0x000000aa2b387223ULL, 0x080fe20000010038ULL,
0x000000aaa4377223ULL, 0x080fe20000010037ULL, 0x000000aaa5367223ULL, 0x080fe20000010036ULL,
0x000000aa1c357223ULL, 0x080fe20000010035ULL, 0x000000aa1d347223ULL, 0x080fe20000010034ULL,
0x000000aaa6337223ULL, 0x080fe20000010033ULL, 0x000000aaa7327223ULL, 0x080fe20000010032ULL,
0x000000aa1e317223ULL, 0x080fe20000010031ULL, 0x000000aaa8717223ULL, 0x000fe20000010071ULL,
0xfffffff000888947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x0000001000037824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe20000011600ULL, 0x0000898024007836ULL, 0x000fc60000000000ULL,
0x0000007003097812ULL, 0x004fe400078ec0ffULL, 0x0000000c050a7812ULL, 0x000fca00078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000002427247211ULL, 0x000fe200078e38ffULL, 0x0000001003057824ULL, 0x002fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011603ULL, 0x0000007005037812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000002408037210ULL, 0x000fca0007ffe003ULL,
0x0089807003007388ULL, 0x0003e40000000800ULL, 0x000000000a007210ULL, 0x000fe20007ffe009ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000037984ULL, 0x002e680000000800ULL,
0x0000800000087984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000803037221ULL, 0x004fc80000010000ULL, 0x0180000003057836ULL, 0x000fca0000000000ULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff807224ULL, 0x000fe200078e0003ULL, 0x0000d17000127802ULL, 0x000fce0000000f00ULL,
0x000000bc00b47944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0005ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000300007308ULL, 0x000e640000001000ULL,
0xbf80000003057423ULL, 0x002fc80000000000ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000500007223ULL, 0x000fce0000000000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011605ULL, 0x00000008050d7811ULL, 0x040fe400078ff0ffULL,
0x0000001005137811ULL, 0x040fe400078ff0ffULL, 0x0000001805157811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0300037589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff227812ULL, 0x000fc600078ee205ULL, 0x00001f0d00107589ULL, 0x000ee200000e0000ULL,
0x0000001822287810ULL, 0x000fe20007ffe0ffULL, 0x0000000822237836ULL, 0x000fe20000000000ULL,
0x0000000322247819ULL, 0x000fe200000006ffULL, 0x00001f1300127589ULL, 0x000f2200000e0000ULL,
0x0000001022257836ULL, 0x000fe40000000000ULL, 0x0000000823267824ULL, 0x000fe200078e00ffULL,
0x00001f1500207589ULL, 0x000ae200000e0000ULL, 0x00000008252a7824ULL, 0x000fe400078e00ffULL,
0x00000008282e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000ffff05007812ULL, 0x022fe200078ec0ffULL, 0x0000000823237824ULL, 0x000fc400078e00ffULL,
0x0000006f03087220ULL, 0x044fe20000410000ULL, 0x0000006e03097220ULL, 0x040fe20000410000ULL,
0x00000003ff007819ULL, 0x000fe20000011600ULL, 0x0000006b030a7220ULL, 0x040fe20000410000ULL,
0x0000006a030b7220ULL, 0x040fe20000410000ULL, 0x0000006d036d7220ULL, 0x040fe20000410000ULL,
0x0000000300007812ULL, 0x000fe200078ec0ffULL, 0x0000006c036c7220ULL, 0x040fe20000410000ULL,
0x0000006903697220ULL, 0x040fe20000410000ULL, 0x0000006803687220ULL, 0x040fe20000410000ULL,
0x0000006703147220ULL, 0x000fe20000410000ULL, 0x0000000100007824ULL, 0x000fc400078e0205ULL,
0x00000066030d7220ULL, 0x040fe20000410000ULL, 0x0000006503157220ULL, 0x040fe20000410000ULL,
0x0000006403647220ULL, 0x040fe20000410000ULL, 0x0000006303167220ULL, 0x040fe20000410000ULL,
0x0000000700217812ULL, 0x040fe200078ec0ffULL, 0x0000006203137220ULL, 0x040fe20000410000ULL,
0x0000000400007812ULL, 0x000fe200078e3cffULL, 0x0000006103177220ULL, 0x040fe20000410000ULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x0000006003607220ULL, 0x000fe20000410000ULL,
0xfffffff826267812ULL, 0x000fe200078ee221ULL, 0x0000005b101a7220ULL, 0x048fe20000410000ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee221ULL, 0x0000005a101b7220ULL, 0x000fe20000410000ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee221ULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000000322217819ULL, 0x000fe200000006ffULL, 0x0000005f10187220ULL, 0x000fe20000410000ULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000005e10037220ULL, 0x040fe20000410000ULL,
0x0000005d10197220ULL, 0x040fe20000410000ULL, 0x0000005c105c7220ULL, 0x040fe20000410000ULL,
0xfffffff821227812ULL, 0x000fe200078ee200ULL, 0x0000005910597220ULL, 0x040fe20000410000ULL,
0x0000005810587220ULL, 0x040fe20000410000ULL, 0x00000057101c7220ULL, 0x040fe20000410000ULL,
0x00000056101d7220ULL, 0x040fe20000410000ULL, 0x0000005510557220ULL, 0x040fe20000410000ULL,
0x0000005410547220ULL, 0x040fe20000410000ULL, 0x00000053101e7220ULL, 0x040fe20000410000ULL,
0x00000052101f7220ULL, 0x040fe20000410000ULL, 0x0000005110517220ULL, 0x000fe20000410000ULL,
0x0000000828297824ULL, 0x000fe200078e00ffULL, 0x000000080908723eULL, 0x000fe200000000ffULL,
0x0000005010107220ULL, 0x000fe20000410000ULL, 0x0000000a0b0a723eULL, 0x000fe200000000ffULL,
0x0000004f124f7220ULL, 0x050fe20000410000ULL, 0xfffffff823287812ULL, 0x000fe200078ee200ULL,
0x0000004e124e7220ULL, 0x000fe20000410000ULL, 0x0000006d6c09723eULL, 0x000fe200000000ffULL,
0x0000004d124d7220ULL, 0x000fe20000410000ULL, 0x00000069680b723eULL, 0x000fe200000000ffULL,
0x0000004c124c7220ULL, 0x000fe20000410000ULL, 0x0000000f24247211ULL, 0x000fe200078e20ffULL,
0x0000004b124b7220ULL, 0x040fe20000410000ULL, 0x0000004a124a7220ULL, 0x040fe20000410000ULL,
0x0000004912497220ULL, 0x040fe20000410000ULL, 0x0000004812487220ULL, 0x040fe20000410000ULL,
0x0000004712477220ULL, 0x040fe20000410000ULL, 0x0000004612467220ULL, 0x040fe20000410000ULL,
0x0000004512457220ULL, 0x040fe20000410000ULL, 0x0000004412447220ULL, 0x040fe20000410000ULL,
0x0000004312437220ULL, 0x040fe20000410000ULL, 0x0000004212427220ULL, 0x040fe20000410000ULL,
0x0000004112417220ULL, 0x040fe20000410000ULL, 0x0000004012127220ULL, 0x000fe20000410000ULL,
0xfffffff8252c7812ULL, 0x000fe200078ee200ULL, 0x0000001022227824ULL, 0x100fe200078e020fULL,
0x000000140d14723eULL, 0x000fe200000000ffULL, 0x0000003f203f7220ULL, 0x000fe20000410000ULL,
0x000000156415723eULL, 0x000fe200000000ffULL, 0x0000003e203e7220ULL, 0x040fe20000410000ULL,
0x000000161316723eULL, 0x000fe200000000ffULL, 0x0000003d203d7220ULL, 0x000fe20000410000ULL,
0x000000176017723eULL, 0x000fe200000000ffULL, 0x0000003c203c7220ULL, 0x040fe20000410000ULL,
0x0000001a1b1a723eULL, 0x000fe200000000ffULL, 0x0000003b203b7220ULL, 0x040fe20000410000ULL,
0x0000003a203a7220ULL, 0x040fe20000410000ULL, 0x0000003920397220ULL, 0x040fe20000410000ULL,
0x0000003820387220ULL, 0x040fe20000410000ULL, 0x0000003720377220ULL, 0x040fe20000410000ULL,
0x0000003620367220ULL, 0x040fe20000410000ULL, 0x0000003520357220ULL, 0x040fe20000410000ULL,
0x0000003420347220ULL, 0x040fe20000410000ULL, 0x0000003320337220ULL, 0x040fe20000410000ULL,
0x0000003220327220ULL, 0x040fe20000410000ULL, 0x0000003120317220ULL, 0x000fe20000410000ULL,
0x000000180318723eULL, 0x000fe200000000ffULL, 0x0000001026267824ULL, 0x100fe200078e020fULL,
0x000000195c19723eULL, 0x000fe200000000ffULL, 0x0000007120207220ULL, 0x000fe20000410000ULL,
0x00000059581b723eULL, 0x000fe200000000ffULL, 0x0000000824007844ULL, 0x0003e20000000200ULL,
0xfffffff829307812ULL, 0x000fe200078ee200ULL, 0x0000001028007824ULL, 0x100fe200078e020fULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x000000102a037824ULL, 0x100fe200078e020fULL,
0x0000001e1f1e723eULL, 0x000fe200000000ffULL, 0x000000102c0d7824ULL, 0x000fe200078e020fULL,
0x00000055541d723eULL, 0x000fe200000000ffULL, 0x0000001422007844ULL, 0x0005e20000000200ULL,
0x00000051101f723eULL, 0x000fc400000000ffULL, 0x000000050e137210ULL, 0x000fe20007ffe0ffULL,
0x0000001826007844ULL, 0x0007e20000000200ULL, 0x000000474628723eULL, 0x000fe400000000ffULL,
0x000000454429723eULL, 0x000fe200000000ffULL, 0x0000001c00007844ULL, 0x000fe20000000200ULL,
0x0000004f4e08723eULL, 0x002fe200000000ffULL, 0x0000001013137824ULL, 0x000fe200078e020cULL,
0x0000004d4c09723eULL, 0x000fe400000000ffULL, 0x0000004b4a0a723eULL, 0x000fc400000000ffULL,
0x00000049480b723eULL, 0x000fe400000000ffULL, 0x00000043422a723eULL, 0x000fe400000000ffULL,
0x00000041122b723eULL, 0x000fe200000000ffULL, 0x0000000803007844ULL, 0x000fe20000000200ULL,
0x0000000f2e107211ULL, 0x000fe200078e20ffULL, 0x00000010300f7824ULL, 0x000fe200078e020fULL,
0x0000003f3e14723eULL, 0x004fe200000000ffULL, 0x000000280d007844ULL, 0x000fe20000000200ULL,
0x0000003d3c15723eULL, 0x000fc400000000ffULL, 0x0000003b3a16723eULL, 0x000fe400000000ffULL,
0x000000393817723eULL, 0x000fe400000000ffULL, 0x000000373618723eULL, 0x008fe400000000ffULL,
0x000000353419723eULL, 0x000fe200000000ffULL, 0x0000001410007844ULL, 0x000fe20000000200ULL,
0x00000033321a723eULL, 0x000fe400000000ffULL, 0x00000031201b723eULL, 0x000fca00000000ffULL,
0x000000180f007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000131c7984ULL, 0x000e680000000c00ULL, 0x00040000132c7984ULL, 0x000ea80000000c00ULL,
0x0008000013347984ULL, 0x000ee80000000c00ULL, 0x000c000013287984ULL, 0x000f280000000c00ULL,
0x0010000013207984ULL, 0x000f680000000c00ULL, 0x0014000013307984ULL, 0x000f280000000c00ULL,
0x0018000013087984ULL, 0x000f280000000c00ULL, 0x001c000013147984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x002fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x004fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff37377230ULL, 0x008fe40000000000ULL, 0x200000ff36367230ULL, 0x000fe40000000000ULL,
0x200000ff35357230ULL, 0x000fe40000000000ULL, 0x200000ff34347230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x010fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x020fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fc40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fe40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000001c13007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fe40000000000ULL, 0x0000000b37377230ULL, 0x000fc40000000000ULL,
0x0000000a36367230ULL, 0x000fe20000000000ULL, 0x0004002c13007388ULL, 0x0003e20000000c00ULL,
0x0000000935357230ULL, 0x000fe40000000000ULL, 0x0000000834347230ULL, 0x000fe40000000000ULL,
0x000000172b2b7230ULL, 0x000fe40000000000ULL, 0x000000162a2a7230ULL, 0x000fe20000000000ULL,
0x0008003413007388ULL, 0x0003e20000000c00ULL, 0x0000001529297230ULL, 0x000fc40000000000ULL,
0x0000001428287230ULL, 0x000fca0000000000ULL, 0x000c002813007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff2700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x000fc80000011605ULL,
0x000000060b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ff00087202ULL, 0x000fe20000000f00ULL,
0x00000008000a7d06ULL, 0x002e620008209000ULL, 0x0000000104007824ULL, 0x000fe200078e020bULL,
0x000000050b0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00000008ff0e7c12ULL, 0x000fe2000f8e33ffULL, 0x0000002005107836ULL, 0x000fe20000000000ULL,
0x00008a0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000a000a7308ULL, 0x002e640000001000ULL,
0x0ffffffe0a097836ULL, 0x002fe20000000000ULL, 0x000000070b0a7812ULL, 0x000fca00078ec0ffULL,
0x0000000900097305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a09ULL,
0x0000000803037c24ULL, 0x000fc8000f8e02ffULL, 0x00000003090d7227ULL, 0x000fcc00078e0008ULL,
0x000000000d087227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a08ULL,
0x0000000803037c24ULL, 0x000fca000f8e0200ULL, 0x0000000803007c0cULL, 0x000fda000bf06070ULL,
0x8000000803030c36ULL, 0x000fe40008000000ULL, 0x0000000108080836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000803007c0cULL, 0x000fe4000bf26070ULL,
0x0ffffff80a037812ULL, 0x000fe400078ef805ULL, 0x00000007050a7812ULL, 0x000fc600078ec0ffULL,
0x0000001003037824ULL, 0x000fca00078e020cULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000108081836ULL, 0x000fca0000000000ULL, 0x000000080e097207ULL, 0x000fe20004000000ULL,
0x0000000811037824ULL, 0x002fc600078e020aULL, 0x000000ff090b7210ULL, 0x000fe20007ffe1ffULL,
0x0000000909097c24ULL, 0x000fc8000f8e0202ULL, 0x000000080b007c24ULL, 0x000fe2000f8e0200ULL,
0x00000003ff0b7819ULL, 0x000fc60000011610ULL, 0x0000000809007c24ULL, 0x000fca000f8e0200ULL,
0x0000000007007210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000400087c11ULL, 0x000fc8000f8240ffULL, 0x0000000500097c11ULL, 0x000fe400088f4409ULL,
0x000000060b00720cULL, 0x000fe20003f26070ULL, 0x0000001003087825ULL, 0x000fca00078e0008ULL,
0x0000001408007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000b04007210ULL, 0x000fe20007ffe0ffULL, 0x00000001100b7824ULL, 0x000fc800078e020bULL,
0x000000000d037227ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff097224ULL, 0x002fe200078e0a03ULL, 0x0ffffff80b0b7812ULL, 0x000fc600078ef810ULL,
0x0000000809087c24ULL, 0x000fe4000f8e0200ULL, 0x000000100b0b7824ULL, 0x000fc600078e020cULL,
0x0000000808007c0cULL, 0x000fe4000bf26070ULL, 0x000000000b147984ULL, 0x0002b60000000c00ULL,
0x8000000808081c36ULL, 0x000fe20008000000ULL, 0x0000000103031810ULL, 0x000fc80007ffe0ffULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0202ULL, 0x0000000809007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000803007c24ULL, 0x000fca000f8e0200ULL, 0x0000000007037210ULL, 0x000fe40007f3e0ffULL,
0x0000000710007812ULL, 0x000fe200078ec0ffULL, 0x0000004005107836ULL, 0x000fe20000000000ULL,
0x000000ffff0a7210ULL, 0x000fe40000ffe4ffULL, 0x0000000403087c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0b7819ULL, 0x002fe40000011610ULL, 0x0000000503097c11ULL, 0x000fe200088f440aULL,
0x0000000811037824ULL, 0x000fe200078e0200ULL, 0x000000060b00720cULL, 0x000fc60003f26070ULL,
0x0000001003087825ULL, 0x000fca00078e0008ULL, 0x0000001408007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x100fe400078e020bULL,
0x00000001100b7824ULL, 0x000fe400078e020bULL, 0x000000000d037227ULL, 0x000fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff03097210ULL, 0x002fe40007ffe1ffULL,
0x0ffffff80b0b7812ULL, 0x000fc600078ef810ULL, 0x0000000809087c24ULL, 0x000fe2000f8e0200ULL,
0x0000000c0b0b7211ULL, 0x000fc800078e20ffULL, 0x0000000808007c0cULL, 0x000fe2000bf26070ULL,
0x000000000b147984ULL, 0x0002980000000c00ULL, 0x8000000808081c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000808007c0cULL, 0x000fda000bf46070ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x000000030e037207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a03ULL, 0x0000000903037c24ULL, 0x000fe4000f8e0202ULL,
0x0000000809007c24ULL, 0x000fc8000f8e0200ULL, 0x0000000803007c24ULL, 0x000fca000f8e0200ULL,
0x0000000007037210ULL, 0x000fe40007f3e0ffULL, 0x0000000710007812ULL, 0x000fe400078ec0ffULL,
0x0000006005107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403087c11ULL, 0x040fe4000f8240ffULL, 0x00000003ff0b7819ULL, 0x002fe40000011610ULL,
0x0000000503097c11ULL, 0x000fe200088f440aULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000060b00720cULL, 0x000fc60003f26070ULL, 0x0000001003087825ULL, 0x000fca00078e0008ULL,
0x0000001408007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000104007824ULL, 0x100fe400078e020bULL, 0x00000001100b7824ULL, 0x000fe400078e020bULL,
0x000000000d037227ULL, 0x000fc600078e00ffULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x002fc600078e0a03ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef810ULL,
0x0000000809087c24ULL, 0x000fc8000f8e0200ULL, 0x000000100b0b7824ULL, 0x000fe200078e020cULL,
0x0000000808007c0cULL, 0x000fc8000bf26070ULL, 0x000000000b147984ULL, 0x0002b20000000c00ULL,
0x8000000808081c10ULL, 0x000fe2000fffe0ffULL, 0x0000000103031836ULL, 0x000fc60000000000ULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0202ULL, 0x0000000809007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000803007c24ULL, 0x000fca000f8e0200ULL, 0x0000000007037210ULL, 0x000fe40007f3e0ffULL,
0x0000000710007812ULL, 0x000fe200078ec0ffULL, 0x0000008005107836ULL, 0x000fe40000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000000403087c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0b7819ULL, 0x002fe40000011610ULL, 0x0000000503097c11ULL, 0x000fc400088f440aULL,
0x000000060b00720cULL, 0x000fe40003f26070ULL, 0x0000000011037211ULL, 0x000fca00078e18ffULL,
0x0000001003087825ULL, 0x000fca00078e0008ULL, 0x0000001408007986ULL, 0x0043e2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x000fe200078e020bULL,
0x0000000b100b7210ULL, 0x000fc60007ffe0ffULL, 0x000000000d037227ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff097224ULL, 0x002fe200078e0a03ULL,
0x0ffffff80b0b7812ULL, 0x000fc600078ef810ULL, 0x0000000809087c24ULL, 0x000fe4000f8e0200ULL,
0x000000100b0b7824ULL, 0x000fc600078e020cULL, 0x0000000808007c0cULL, 0x000fe4000bf26070ULL,
0x000000000b147984ULL, 0x0002b60000000c00ULL, 0x8000000808081c36ULL, 0x000fc40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000808007c0cULL, 0x000fda000bf46070ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x000000030e037207ULL, 0x000fc80004000000ULL,
0x000000ff03097210ULL, 0x000fe20007ffe1ffULL, 0x0000000903037c24ULL, 0x000fc8000f8e0202ULL,
0x0000000809007c24ULL, 0x000fc8000f8e0200ULL, 0x0000000803007c24ULL, 0x000fca000f8e0200ULL,
0x0000000007037210ULL, 0x000fe40007f3e0ffULL, 0x0000000710007812ULL, 0x000fe200078ec0ffULL,
0x000000a005107836ULL, 0x000fe40000000000ULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403087c11ULL, 0x040fe4000f8240ffULL, 0x00000003ff0b7819ULL, 0x002fe40000011610ULL,
0x0000000503097c11ULL, 0x000fe200088f440aULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000060b00720cULL, 0x000fc60003f26070ULL, 0x0000001003087825ULL, 0x000fca00078e0008ULL,
0x0000001408007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000b04007210ULL, 0x000fe20007ffe0ffULL, 0x00000001100b7824ULL, 0x000fc800078e020bULL,
0x000000000d037227ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff097224ULL, 0x002fe200078e0a03ULL, 0x0ffffff80b0b7812ULL, 0x000fc600078ef810ULL,
0x0000000809087c24ULL, 0x000fe4000f8e0200ULL, 0x000000100b0b7824ULL, 0x000fc600078e020cULL,
0x0000000808007c0cULL, 0x000fe4000bf26070ULL, 0x000000000b147984ULL, 0x0002b60000000c00ULL,
0x8000000808081c36ULL, 0x000fe20008000000ULL, 0x0000000103031810ULL, 0x000fc80007ffe0ffULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0202ULL, 0x0000000809007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000803007c24ULL, 0x000fca000f8e0200ULL, 0x0000000007037210ULL, 0x000fe40007f3e0ffULL,
0x0000000710007812ULL, 0x000fe200078ec0ffULL, 0x000000c005107836ULL, 0x000fe20000000000ULL,
0x000000ffff0a7210ULL, 0x000fe40000ffe4ffULL, 0x0000000403087c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0b7819ULL, 0x002fe40000011610ULL, 0x0000000503097c11ULL, 0x000fe200088f440aULL,
0x0000000811037824ULL, 0x000fe200078e0200ULL, 0x000000060b00720cULL, 0x000fc60003f26070ULL,
0x0000001003087825ULL, 0x000fca00078e0008ULL, 0x0000001408007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000104007824ULL, 0x100fe400078e020bULL,
0x00000001100b7824ULL, 0x000fe400078e020bULL, 0x000000000d037227ULL, 0x000fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff03097210ULL, 0x002fe40007ffe1ffULL,
0x0ffffff80b0b7812ULL, 0x000fc600078ef810ULL, 0x0000000809087c24ULL, 0x000fe2000f8e0200ULL,
0x0000000c0b0b7211ULL, 0x000fc800078e20ffULL, 0x0000000808007c0cULL, 0x000fe2000bf26070ULL,
0x000000000b147984ULL, 0x000e580000000c00ULL, 0x8000000808081c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000808007c0cULL, 0x000fda000bf46070ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x000000030e037207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a03ULL, 0x0000000903037c24ULL, 0x000fe4000f8e0202ULL,
0x0000000809007c24ULL, 0x000fc8000f8e0200ULL, 0x0000000803007c24ULL, 0x000fca000f8e0200ULL,
0x0000000007037210ULL, 0x000fe40007f3e0ffULL, 0x0000000710007812ULL, 0x000fe400078ec0ffULL,
0x000000e005107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403087c11ULL, 0x040fe4000f8240ffULL, 0x00000003ff057819ULL, 0x000fe40000011610ULL,
0x0000000503097c11ULL, 0x000fe200088f440aULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000060500720cULL, 0x000fe20003f26070ULL, 0x0000000104047824ULL, 0x000fc400078e0205ULL,
0x0000001003087825ULL, 0x000fca00078e0008ULL, 0x0000001408007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000040d007227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a00ULL, 0x0000000110057824ULL, 0x000fe400078e0205ULL,
0x0000000803037c24ULL, 0x000fc6000f8e0204ULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x0000000803007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff805057812ULL, 0x000fca00078ef810ULL,
0x0000001005057824ULL, 0x000fca00078e020cULL, 0x0000000005087984ULL, 0x002e620000000c00ULL,
0x8000000803031c10ULL, 0x000fe2000fffe0ffULL, 0x0000000100001836ULL, 0x000fc60000000000ULL,
0x0000000803007c0cULL, 0x000fda000bf46070ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000e037207ULL, 0x000fe40004000000ULL, 0x0000000710007812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL, 0x0000000903037c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d047c24ULL, 0x000fe4000f8e0204ULL, 0x0000000811117824ULL, 0x000fe400078e0200ULL,
0x0000000803047c24ULL, 0x000fca000f8e0204ULL, 0x0000000407047210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000404027c11ULL, 0x000fc8000f8040ffULL,
0x0000000504037c11ULL, 0x000fc600080f4403ULL, 0x0000001011027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000305067211ULL, 0x000fe200078e10ffULL, 0x00000001ff157424ULL, 0x000fe200078e00ffULL,
0x00009000ff167b82ULL, 0x000e620000000a00ULL, 0x000000061b107819ULL, 0x000fe200000006ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000b0600720cULL, 0x000fe40003f06070ULL,
0x01e600150a1479a7ULL, 0x0004b6000850003fULL, 0x00009600ff078b82ULL, 0x000ee20000000800ULL,
0x000000021f0d8824ULL, 0x000fce00078e00ffULL, 0x00009200ff188b82ULL, 0x000f220000000a00ULL,
0x000000070d0d8224ULL, 0x008fe400078e0206ULL, 0xffffffffff077424ULL, 0x000fe400078e00ffULL,
0x000000040d188825ULL, 0x010fca00078e0018ULL, 0x0000000618078981ULL, 0x000ee2000c1e1900ULL,
0x00000001050d7836ULL, 0x000fe20000000000ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000004003127824ULL, 0x000fc600078e00ffULL, 0x0000000c0d00720cULL, 0x000fe20003f06070ULL,
0x000000053f047899ULL, 0x000fe20008011604ULL, 0x00000010070d7224ULL, 0x008fc800078e02ffULL,
0x000001000d167825ULL, 0x002fc800078e0016ULL, 0x00000040020d7824ULL, 0x000fc600078e00ffULL,
0x0000000c00248947ULL, 0x004fea0003800000ULL, 0x0000001205187211ULL, 0x000fe400078e40ffULL,
0x00000003ff3b7819ULL, 0x000fe40000011608ULL, 0x0000001809117248ULL, 0x000fc60007fe0000ULL,
0x000000043b197836ULL, 0x000fe40000000000ULL, 0x0000000111117824ULL, 0x000fe400078e0a18ULL,
0x0000000119187824ULL, 0x140fe200078e0208ULL, 0x0000000319277819ULL, 0x040fe200000006ffULL,
0x000000083b1a7836ULL, 0x000fe20000000000ULL, 0x000000111900720cULL, 0x080fe20003f46070ULL,
0x0000000c3b197836ULL, 0x000fe20000000000ULL, 0xfffffff827277812ULL, 0x000fe200078ee218ULL,
0x000000011a187824ULL, 0x140fe200078e0208ULL, 0x000000031a297819ULL, 0x040fe200000006ffULL,
0x000000103b1b7836ULL, 0x000fe20000000000ULL, 0x000000111a00720cULL, 0x080fe20003f66070ULL,
0x00000001191a7824ULL, 0x140fe200078e0208ULL, 0xfffffff829297812ULL, 0x000fe200078ee218ULL,
0x00000008192d7824ULL, 0x000fe200078e00ffULL, 0x000000081b187210ULL, 0x000fe20007ffe0ffULL,
0x000000081b2f7824ULL, 0x040fe200078e00ffULL, 0x000000111b00720cULL, 0x080fe20003fa6070ULL,
0x0000004002027824ULL, 0x000fe200078e023bULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee21aULL,
0x000000143b1a7836ULL, 0x000fe20000000000ULL, 0x000000111900720cULL, 0x000fe20003f86070ULL,
0x000000013b1b7824ULL, 0x000fe200078e0208ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee218ULL,
0x0000010002187825ULL, 0x000fe200078e00ffULL, 0x000000081a1c7210ULL, 0x000fc40007ffe0ffULL,
0x000000111a00720cULL, 0x0c0fe20003f06070ULL, 0x000000081a377824ULL, 0x000fe200078e00ffULL,
0x000000071b217812ULL, 0x000fe200078ec0ffULL, 0x00004000031a7824ULL, 0x000fe200078e020aULL,
0x00000004021b7810ULL, 0x000fe20007ffe0ffULL, 0x000000183b227836ULL, 0x000fe20000000000ULL,
0x00000070181d7812ULL, 0x000fe200078ef813ULL, 0x000020001a1e7836ULL, 0x000fe20000000000ULL,
0xfffffff837377812ULL, 0x000fe200078ee21cULL, 0x000001001b1a7825ULL, 0x000fe200078e00ffULL,
0x000000113b00720cULL, 0x000fc40003f26070ULL, 0x0000001d161c7210ULL, 0x000fe20007fde0ffULL,
0x0000000802187836ULL, 0x000fe20000000000ULL, 0x0ffffff821217812ULL, 0x000fe200078ef808ULL,
0x0000000122247824ULL, 0x000fe200078e0208ULL, 0x0000001e27277211ULL, 0x080fe200078e20ffULL,
0x00000001171d7824ULL, 0x000fe200030e0619ULL, 0x0000001e21257211ULL, 0x000fe200078e20ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000701a217812ULL, 0x000fe400078ef813ULL,
0x0000000c021a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c257faeULL, 0x0003e2000c901c46ULL, 0x0000002116207210ULL, 0x000fe20007fde0ffULL,
0x0000000822397824ULL, 0x040fe200078e00ffULL, 0x0000007018237812ULL, 0x000fe200078ef813ULL,
0x0000001002187836ULL, 0x000fe20000000000ULL, 0x000000112200720cULL, 0x000fe20003f26070ULL,
0x0000000117217824ULL, 0x000fe200030e061bULL, 0x0000002316227210ULL, 0x000fe20007fde0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fc400078ee224ULL,
0x0000000020277faeULL, 0x0005e2000d101c46ULL, 0x0000000117237824ULL, 0x000fe200030e0619ULL,
0x000000701a1d7812ULL, 0x002fe200078ef813ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00000014021a7810ULL, 0x000fe40007ffe0ffULL, 0x0000001d161c7210ULL, 0x000fe20007fde0ffULL,
0x0000001c3b247836ULL, 0x000fe20000000000ULL, 0x0000007018257812ULL, 0x000fe200078ef813ULL,
0x0000001802187836ULL, 0x000fe20000000000ULL, 0x0000001e29297211ULL, 0x000fe200078e20ffULL,
0x0000000124267824ULL, 0x040fe200078e0208ULL, 0x000000112400720cULL, 0x040fe20003f46070ULL,
0x00000008243d7824ULL, 0x000fc400078e00ffULL, 0x00000001171d7824ULL, 0x040fe200030e061bULL,
0x0000002516247210ULL, 0x000fe20007fde0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000022297faeULL, 0x0003e2000d901c46ULL, 0xfffffff83d3d7812ULL, 0x000fe400078ee226ULL,
0x0000000117257824ULL, 0x000fe200030e0619ULL, 0x000000701a2b7812ULL, 0x000fe200078ef813ULL,
0x0000010018187825ULL, 0x000fc600078e00ffULL, 0x0000002b16207210ULL, 0x004fe20007fde0ffULL,
0x000000203b217836ULL, 0x000fe20000000000ULL, 0x00000070182b7812ULL, 0x000fe200078ef813ULL,
0x0000001c021a7836ULL, 0x000fe40000000000ULL, 0x0000000121277824ULL, 0x040fe200078e0208ULL,
0x000000112100720cULL, 0x080fe20003f66070ULL, 0x000000102d297824ULL, 0x002fe200078e021eULL,
0x0000000321187819ULL, 0x000fe200000006ffULL, 0x0000000117217824ULL, 0x040fe200030e061bULL,
0x0000002b16267210ULL, 0x000fe20007fde0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff818317812ULL, 0x000fe200078ee227ULL, 0x000000001c297faeULL, 0x0003e4000e101c46ULL,
0x0000000117277824ULL, 0x000fe200030e0619ULL, 0x000000243b197810ULL, 0x000fe20007ffe0ffULL,
0x0000002002187836ULL, 0x000fe20000000000ULL, 0x000000701a237812ULL, 0x000fe200078ef813ULL,
0x000000283b2a7836ULL, 0x000fe20000000000ULL, 0x000000111900720cULL, 0x040fe20003f86070ULL,
0x00000001191a7824ULL, 0x040fe200078e0208ULL, 0x0000002316227210ULL, 0x000fe20007fde0ffULL,
0x0000000819337824ULL, 0x000fe200078e00ffULL, 0x0000001e31317211ULL, 0x000fe200078e20ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000001b17237210ULL, 0x000fc400037fe4ffULL,
0xfffffff833337812ULL, 0x000fe200078ee21aULL, 0x00000024021a7836ULL, 0x000fe20000000000ULL,
0x0000007018297812ULL, 0x002fe200078ef813ULL, 0x000000102f2d7824ULL, 0x000fe200078e021eULL,
0x00000028021c7810ULL, 0x000fe20007ffe0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002916287210ULL, 0x000fe40007fde0ffULL, 0x00000000242d7faeULL, 0x0003e2000e901c46ULL,
0x000000012a187824ULL, 0x040fe200078e0208ULL, 0x000000701a2b7812ULL, 0x000fe200078ef813ULL,
0x000000082a357824ULL, 0x040fe200078e00ffULL, 0x000000112a00720cULL, 0x000fe20003fa6070ULL,
0x000001001c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee218ULL,
0x0000000117297824ULL, 0x000fe200030e0619ULL, 0x0000002b162a7210ULL, 0x000fe20007fde0ffULL,
0x0000002c3b1a7836ULL, 0x000fe20000000000ULL, 0x000000701c197812ULL, 0x000fe200078ef813ULL,
0x00000010372d7824ULL, 0x002fe200078e021eULL, 0x0000002c02187810ULL, 0x000fe20007ffe0ffULL,
0x00000001172b7824ULL, 0x000fe200030e061bULL, 0x00000019161c7210ULL, 0x000fe20007fde0ffULL,
0x00000030021b7836ULL, 0x000fe20000000000ULL, 0x00000000202d7faeULL, 0x0003e2000c101c46ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000001d171d7210ULL, 0x000fc400037fe4ffULL,
0x000000111a00720cULL, 0x0c0fe20003f06070ULL, 0x000000011a257824ULL, 0x040fe200078e0208ULL,
0x00000070182f7812ULL, 0x000fe200078ef813ULL, 0x000000081a2c7824ULL, 0x000fe200078e00ffULL,
0x000000303b187810ULL, 0x000fe20007ffe0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e00ffULL,
0x0000002f16247210ULL, 0x000fe40007fde0ffULL, 0xfffffff82c377812ULL, 0x000fe200078ee225ULL,
0x00000010392d7824ULL, 0x002fe200078e021eULL, 0x000000701a217812ULL, 0x000fe200078ef813ULL,
0x0000000117257824ULL, 0x000fe200030e0619ULL, 0x00000003181a7819ULL, 0x040fe200000006ffULL,
0x0000000118197824ULL, 0x040fe200078e0208ULL, 0x00000000262d7faeULL, 0x0003e2000c901c46ULL,
0x000000111800720cULL, 0x000fe20003f26070ULL, 0x0000003402187836ULL, 0x000fe20000000000ULL,
0x0000002116207210ULL, 0x000fe20007fde0ffULL, 0x000000103d2f7824ULL, 0x000fe200078e021eULL,
0xfffffff81a397812ULL, 0x000fe200078ee219ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000003c3b2c7810ULL, 0x000fc40007ffe0ffULL, 0x00000000222f7faeULL, 0x0005e2000d101c46ULL,
0x0000000117217824ULL, 0x000fe200030e061bULL, 0x000000112c00720cULL, 0x080fe20003f46070ULL,
0x0000001033337824ULL, 0x100fe200078e021eULL, 0x0000007018277812ULL, 0x002fe200078ef813ULL,
0x000000343b1a7836ULL, 0x000fe20000000000ULL, 0x0000000028317faeULL, 0x0003e2000d901c46ULL,
0x000000383b1b7836ULL, 0x000fe20000000000ULL, 0x0000002716267210ULL, 0x000fe20007fde0ffULL,
0x0000003802187836ULL, 0x000fe20000000000ULL, 0x000000002a337faeULL, 0x0007e2000e101c46ULL,
0x000000111a00720cULL, 0x0c0fe20003f86070ULL, 0x0000001035357824ULL, 0x000fe200078e021eULL,
0x000000111b00720cULL, 0x000fe20003f66070ULL, 0x0000000117277824ULL, 0x000fe200030e0619ULL,
0x000000031a227819ULL, 0x004fe200000006ffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000001e37377211ULL, 0x000fe200078e20ffULL, 0x000000001c357faeULL, 0x0005e4000e901c46ULL,
0x000000011a117824ULL, 0x100fe200078e0208ULL, 0x0000007018237812ULL, 0x000fe200078ef813ULL,
0x0000003c021a7836ULL, 0x000fe20000000000ULL, 0x0000000024377faeULL, 0x0005e2000c101c46ULL,
0x000000011b027824ULL, 0x040fe200078e0208ULL, 0x0000002316187210ULL, 0x000fe20007fde0ffULL,
0x000000081b297824ULL, 0x002fe200078e00ffULL, 0x000000082c087210ULL, 0x000fe20007ffe0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff822117812ULL, 0x000fc400078ee211ULL,
0xfffffff829237812ULL, 0x000fe200078ee202ULL, 0x000000082c2b7824ULL, 0x008fe200078e00ffULL,
0x000000701a137812ULL, 0x000fe200078ef813ULL, 0x0000000117197824ULL, 0x000fe400030e0619ULL,
0x0000001039397824ULL, 0x100fe200078e021eULL, 0x0000001316167210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x100fe200078e021eULL, 0xfffffff82b297812ULL, 0x000fe200078ee208ULL,
0x0000001023237824ULL, 0x000fe200078e021eULL, 0x0000000020397faeULL, 0x0005e2000c901c46ULL,
0x0000000117177824ULL, 0x000fe200030e061bULL, 0x0000001e29297211ULL, 0x000fc400078e20ffULL,
0x0000000026117faeULL, 0x0005e8000e101c46ULL, 0x0000000018237faeULL, 0x0005e8000d901c46ULL,
0x0000000016297faeULL, 0x0005e2000d101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000408257811ULL, 0x040fe400078fe8ffULL, 0x0000000808287811ULL, 0x040fe400078fe8ffULL,
0x0000000c08297811ULL, 0x040fe200078fe8ffULL, 0x0000000125027824ULL, 0x140fe200078e0208ULL,
0x0000002808317811ULL, 0x040fe200078fe8ffULL, 0x0000000825117824ULL, 0x000fe200078e00ffULL,
0x0000001c08337811ULL, 0x000fe200078fe8ffULL, 0x00000008281b7824ULL, 0x000fe200078e00ffULL,
0x00000010082b7811ULL, 0x040fe200078fe8ffULL, 0x00000008292c7824ULL, 0x040fe200078e00ffULL,
0xfffffff811267812ULL, 0x000fe200078ee202ULL, 0x0000000129117824ULL, 0x100fe200078e0208ULL,
0x0000000828027210ULL, 0x000fe20007ffe0ffULL, 0x0000000831207824ULL, 0x000fe200078e00ffULL,
0x00000034083c7811ULL, 0x040fe200078fe8ffULL, 0x00000001331a7824ULL, 0x140fe200078e0208ULL,
0xfffffff81b2a7812ULL, 0x000fe200078ee202ULL, 0x00000008331b7824ULL, 0x000fe200078e00ffULL,
0x0000002008027811ULL, 0x000fe200078fe8ffULL, 0x000000082b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee211ULL, 0x000000083c237824ULL, 0x000fe200078e00ffULL,
0x0000000802117210ULL, 0x000fe20007ffe0ffULL, 0x00000008021c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b367812ULL, 0x000fe200078ee21aULL, 0x000000013c1a7824ULL, 0x000fe200078e0208ULL,
0x000000082b187210ULL, 0x000fc40007ffe0ffULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee211ULL,
0x0000000831117210ULL, 0x000fe40007ffe0ffULL, 0x00000024081e7811ULL, 0x040fe400078fe8ffULL,
0xfffffff820207812ULL, 0x000fe400078ee211ULL, 0x0000000808117211ULL, 0x040fe400078fe8ffULL,
0x00000014082d7811ULL, 0x000fc400078fe8ffULL, 0x0000003c08407811ULL, 0x000fe400078fe8ffULL,
0x00000007111b7812ULL, 0x000fe200078ec0ffULL, 0x000000012d197824ULL, 0x140fe200078e0208ULL,
0xfffffff81d2e7812ULL, 0x000fe200078ee218ULL, 0x000000011e187824ULL, 0x140fe200078e0208ULL,
0xfffffff823237812ULL, 0x000fe200078ee21aULL, 0x000000081e1d7824ULL, 0x000fe200078e00ffULL,
0x00000018082f7811ULL, 0x040fe200078fe8ffULL, 0x000000082d307824ULL, 0x000fe200078e00ffULL,
0x0000002c08327811ULL, 0x000fe200078fe8ffULL, 0x000000010d1a7824ULL, 0x000fe200078e0225ULL,
0x0000000a03247211ULL, 0x000fe200078e70ffULL, 0x0000000840427824ULL, 0x000fe200078e00ffULL,
0x0ffffff81b257812ULL, 0x000fe200078ef808ULL, 0x000000082f347824ULL, 0x000fe200078e00ffULL,
0x00000008401b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000832217824ULL, 0x040fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL, 0x0000000132187824ULL, 0x000fe200078e0208ULL,
0xfffffff830307812ULL, 0x000fe200078ee219ULL, 0x0000200024577836ULL, 0x000fe20000000000ULL,
0x00000030083a7811ULL, 0x000fc400078fe8ffULL, 0x000000082f197210ULL, 0x000fe20007ffe0ffULL,
0x000000101c497824ULL, 0x000fe200078e0257ULL, 0xfffffff842247812ULL, 0x000fe200078ee21bULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe400078ee219ULL,
0xfffffff821217812ULL, 0x000fe200078ee218ULL, 0x000000083a227824ULL, 0x000fe200078e00ffULL,
0x00000038083e7811ULL, 0x000fe200078fe8ffULL, 0x000000010d1c7824ULL, 0x000fe200078e0229ULL,
0x000000083a197210ULL, 0x000fe20007ffe0ffULL, 0x000000102a3d7824ULL, 0x000fe200078e0257ULL,
0x0000000d08187211ULL, 0x000fe200078fe8ffULL, 0x000000013e117824ULL, 0x040fe200078e0208ULL,
0x000000701a277812ULL, 0x000fe200078ef813ULL, 0x000000083e387824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee219ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00000057263b7211ULL, 0x000fc400078e20ffULL, 0x0000002716267210ULL, 0x000fe20007f3e0ffULL,
0x0000001022517824ULL, 0x100fe200078e0257ULL, 0x000000280d1a7210ULL, 0x000fe20007ffe0ffULL,
0x000000102c3f7824ULL, 0x000fe200078e0257ULL, 0xfffffff838087812ULL, 0x000fe200078ee211ULL,
0x0000000117277824ULL, 0x000fe200008e061bULL, 0x0000007018117812ULL, 0x000fe200078ef813ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000002d0d227210ULL, 0x000fe40007ffe0ffULL,
0x0000001116187210ULL, 0x000fe20007f1e0ffULL, 0x0000001025117824ULL, 0x100fe200078e0257ULL,
0x0000005723537211ULL, 0x080fe200078e20ffULL, 0x000000102e417824ULL, 0x100fe200078e0257ULL,
0x000000701a297812ULL, 0x000fe200078ef813ULL, 0x0000001034457824ULL, 0x100fe200078e0257ULL,
0x0000005730437211ULL, 0x080fe200078e20ffULL, 0x0000001036477824ULL, 0x100fe200078e0257ULL,
0x000000571d4b7211ULL, 0x000fe200078e20ffULL, 0x00000010204d7824ULL, 0x000fc400078e0257ULL,
0x00000010214f7824ULL, 0x100fe400078e0257ULL, 0x0000001008557824ULL, 0x000fe400078e0257ULL,
0x0000010022227825ULL, 0x000fc800078e00ffULL, 0x0000001024577824ULL, 0x000fe400078e0257ULL,
0x0000000117197824ULL, 0x000fe200000e0619ULL, 0x0000002916287210ULL, 0x000fe20007f1e0ffULL,
0x000000010d247824ULL, 0x040fe200078e022fULL, 0x00000070222f7812ULL, 0x000fe200078ef813ULL,
0x000000010d207824ULL, 0x000fe200078e022bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018117faeULL, 0x0003e2000b901c46ULL, 0x0000010024247825ULL, 0x000fc600078e00ffULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x0000010020207825ULL, 0x000fc800078e00ffULL,
0x0000000117297824ULL, 0x000fe200000e061bULL, 0x0000002f162e7210ULL, 0x000fe20007f1e0ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x00000070241b7812ULL, 0x000fe400078ef813ULL,
0x00000070202d7812ULL, 0x000fe200078ef813ULL, 0x000000010d1a7824ULL, 0x000fe200078e0233ULL,
0x000000701c2b7812ULL, 0x000fe200078ef813ULL, 0x00000001172f7824ULL, 0x000fe200000e0623ULL,
0x0000001b16307210ULL, 0x000fe20007f1e0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002d162c7210ULL, 0x000fe20007f5e0ffULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x0000001e0d207210ULL, 0x000fe20007ffe0ffULL, 0x000000010d1c7824ULL, 0x040fe200078e0202ULL,
0x0000002b162a7210ULL, 0x000fe20007f3e0ffULL, 0x000000010d227824ULL, 0x000fe200078e0231ULL,
0x00000021172d7210ULL, 0x000fe200017fe4ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x000000701a337812ULL, 0x000fc600078ef813ULL, 0x00000001172b7824ULL, 0x040fe200008e061dULL,
0x0000007020377812ULL, 0x000fe200078ef813ULL, 0x0000000117317824ULL, 0x000fe400000e0625ULL,
0x000000010d1a7824ULL, 0x000fe200078e0232ULL, 0x0000003316327210ULL, 0x000fe20007f1e0ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000002a3f7faeULL, 0x0003e4000b901c46ULL,
0x0000001b17337210ULL, 0x000fe200007fe4ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x000000701c357812ULL, 0x000fe200078ef813ULL, 0x000000002c417faeULL, 0x0003e2000b901c46ULL,
0x0000003716367210ULL, 0x000fe20007f1e0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007022397812ULL, 0x000fe200078ef813ULL, 0x000000002e437faeULL, 0x0003e2000b901c46ULL,
0x0000003516347210ULL, 0x000fe20007f3e0ffULL, 0x0000000117377824ULL, 0x000fe200000e0621ULL,
0x0000003a0d1c7210ULL, 0x000fe20007ffe0ffULL, 0x000000010d207824ULL, 0x040fe200078e023cULL,
0x0000003916387210ULL, 0x000fe20007f5e0ffULL, 0x000000010d227824ULL, 0x000fe200078e023eULL,
0x000000701a217812ULL, 0x000fe200078ef813ULL, 0x0000000117357824ULL, 0x000fe200008e061dULL,
0x0000000030457faeULL, 0x0003e2000b901c46ULL, 0x000000010d247824ULL, 0x000fe200078e0240ULL,
0x00000021161a7210ULL, 0x000fe20007f1e0ffULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000032477faeULL, 0x0003e4000b901c46ULL, 0x0000001b171b7210ULL, 0x000fe200007fe4ffULL,
0x0000000117397824ULL, 0x040fe200010e0623ULL, 0x000000701c5d7812ULL, 0x000fe200078ef813ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000000034497faeULL, 0x0003e4000b901c46ULL,
0x0000005d161c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000070205b7812ULL, 0x000fe200078ef813ULL, 0x00000000364b7faeULL, 0x0003e4000b901c46ULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x0000007022597812ULL, 0x000fe200078ef813ULL,
0x00000000384d7faeULL, 0x0003e2000b901c46ULL, 0x0000005b16207210ULL, 0x000fe20007f3e0ffULL,
0x00000001171d7824ULL, 0x040fe200000e061dULL, 0x0000007024137812ULL, 0x000fe200078ef813ULL,
0x000000001a4f7faeULL, 0x0003e2000b901c46ULL, 0x0000005916227210ULL, 0x000fe20007f5e0ffULL,
0x0000000117217824ULL, 0x040fe200008e0621ULL, 0x0000001316167210ULL, 0x000fe20007f7e0ffULL,
0x000000001c517faeULL, 0x0003e4000b901c46ULL, 0x0000000117237824ULL, 0x000fe200010e0623ULL,
0x0000002517177210ULL, 0x000fe20001ffe4ffULL, 0x0000000020537faeULL, 0x0003e8000b901c46ULL,
0x0000000022557faeULL, 0x0003e8000b901c46ULL, 0x0000000016577faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000167805ULL, 0x006fe20000015200ULL,
0x01e600150a0075a7ULL, 0x000ee2000800017fULL, 0x0000000109027824ULL, 0x000fe400078e0a0eULL,
0x000000040f0f7c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff027819ULL, 0x000fe20000011602ULL,
0x00008e00ffac7b82ULL, 0x000f240000000a00ULL, 0x000000040fac7825ULL, 0x010fe200078e00acULL,
0x00000000005c0947ULL, 0x00efec0003800000ULL, 0x000000ffff117224ULL, 0x000fce00078e00ffULL,
0x000000101100780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018160f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119187824ULL, 0x000fe200000e0e17ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011418ULL,
0x0000000f08087211ULL, 0x000fc800078110ffULL, 0x00000018ff0f7210ULL, 0x000fc800007fe4ffULL,
0x0000000208087819ULL, 0x000fc8000000120fULL, 0x000000080000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000111117836ULL, 0x000fce0000000000ULL,
0x01e600150a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000c0500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009600ff147b82ULL, 0x000e620000000800ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000008031d7824ULL, 0x140fe200078e020aULL, 0x000000090e117810ULL, 0x000fe20007ffe0ffULL,
0xffffffff0e0f7836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x00000020031b7824ULL, 0x000fe400078e020aULL, 0x000000141f1f7224ULL, 0x002fd200078e02ffULL,
0x00009000ffae7b82ULL, 0x000e620000000a00ULL, 0x0000000105137836ULL, 0x008fe40000000000ULL,
0x0000000710177224ULL, 0x000fe400078e02ffULL, 0x0000010005147824ULL, 0x000fe200078e0212ULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x0000010017167825ULL, 0x002fd800078e00aeULL,
0x0000000800f08947ULL, 0x000fea0003800000ULL, 0x0000000408257819ULL, 0x004fe200000006ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x00000003ff1a7819ULL, 0x000fe40000011608ULL,
0x0000007025257812ULL, 0x000fe400078ec0ffULL, 0x0000000c1a227810ULL, 0x000fe20007ffe0ffULL,
0x000000010d217824ULL, 0x000fe200078e021aULL, 0x0000008025187812ULL, 0x000fe200078efcffULL,
0x000000041a1c7836ULL, 0x000fe20000000000ULL, 0x000000220d277210ULL, 0x000fe20007ffe0ffULL,
0x000000081a1e7836ULL, 0x000fe20000000000ULL, 0x00000003223a7819ULL, 0x000fe200000006ffULL,
0x0000010021207825ULL, 0x000fe200078e0018ULL, 0x000000031c247819ULL, 0x000fc400000006ffULL,
0x0000001c1a3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000011c077824ULL, 0x100fe200078e0208ULL,
0x00000020162a7210ULL, 0x000fe20007f1e0ffULL, 0x000000011e137824ULL, 0x040fe400078e0208ULL,
0x000000081e387824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x000000101a267836ULL, 0x000fe20000000000ULL, 0x0000001409077248ULL, 0x000fe20007fe0000ULL,
0x000000141a347836ULL, 0x000fe20000000000ULL, 0x00000021172b7210ULL, 0x000fe200007fe4ffULL,
0x000000010d217824ULL, 0x000fe200078e021cULL, 0xfffffff838387812ULL, 0x000fe200078ee213ULL,
0x0000000107077824ULL, 0x000fc400078e0a14ULL, 0x0000010021207825ULL, 0x000fc600078e0018ULL,
0x000000072600720cULL, 0x080fe20003f06070ULL, 0x0000000122137824ULL, 0x100fe200078e0208ULL,
0x00000020162c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000126157824ULL, 0x000fe200078e0208ULL,
0x000000072200720cULL, 0x080fe20003f46070ULL, 0x00000008263c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL, 0x000000010d297824ULL, 0x000fe200078e0226ULL,
0x000000071c00720cULL, 0x000fe20003f86070ULL, 0x0000010027267825ULL, 0x000fe200078e0018ULL,
0xfffffff83c3c7812ULL, 0x000fc400078ee215ULL, 0x0000000834157210ULL, 0x000fe20007ffe0ffULL,
0x000000010d137824ULL, 0x040fe200078e0234ULL, 0x000000071e00720cULL, 0x000fe20003f26070ULL,
0x000000010d237824ULL, 0x000fe400078e021eULL, 0x00000001172d7824ULL, 0x000fe200018e0621ULL,
0x0000002616307210ULL, 0x000fe20007f7e0ffULL, 0x0000010013207825ULL, 0x000fc800078e0018ULL,
0x000000181a267836ULL, 0x000fe20000000000ULL, 0x0000002016327210ULL, 0x000fe20007fde0ffULL,
0x0000010023227825ULL, 0x000fc600078e0018ULL, 0x000000260d137210ULL, 0x000fe20007ffe0ffULL,
0x0000010029287825ULL, 0x000fe200078e0018ULL, 0x00000022162e7210ULL, 0x000fc60007fbe0ffULL,
0x0000000117337824ULL, 0x000fe200030e0621ULL, 0x00000023172f7210ULL, 0x000fe20002ffe4ffULL,
0x0000010013207825ULL, 0x000fe200078e0018ULL, 0x0000002816287210ULL, 0x000fe40007fbe0ffULL,
0x0ffffff808237812ULL, 0x000fe200078ec0ffULL, 0x0000000117317824ULL, 0x000fe200018e0627ULL,
0x000000073400720cULL, 0x040fe20003f66070ULL, 0x0000000834227824ULL, 0x000fe200078e00ffULL,
0x0000002016347210ULL, 0x000fe20007fde0ffULL, 0x000000011a1c7824ULL, 0x000fc400078e0208ULL,
0x0000000117297824ULL, 0x000fe200028e0629ULL, 0x000000071a00720cULL, 0x000fe20003fa6070ULL,
0x00004000031e7824ULL, 0x000fe200078e020aULL, 0x00000007231c7812ULL, 0x000fe200078ef81cULL,
0x0000000117357824ULL, 0x000fe200030e0621ULL, 0x0000003e0d217210ULL, 0x000fe20007ffe0ffULL,
0x000040001e137836ULL, 0x000fe20000000000ULL, 0xfffffff822227812ULL, 0x000fe200078ee215ULL,
0x000000201a407836ULL, 0x000fe40000000000ULL, 0x000000101c157824ULL, 0x000fc400078e0213ULL,
0x0000010021207825ULL, 0x000fc600078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a157faeULL, 0x0003e2000e901c46ULL, 0x0000001024397824ULL, 0x000fe200078e0213ULL,
0x0000002016367210ULL, 0x000fe20007fde0ffULL, 0x000000010d277824ULL, 0x000fe200078e0240ULL,
0x000000083e207210ULL, 0x000fe20007ffe0ffULL, 0x00000001261c7824ULL, 0x040fe200078e0208ULL,
0x000000002c397faeULL, 0x0005e2000e101c46ULL, 0x000000072600720cULL, 0x0c0fe20003fa6070ULL,
0x00000008263b7824ULL, 0x000fe200078e00ffULL, 0x000000073e00720cULL, 0x000fe20003f86070ULL,
0x0000010027267825ULL, 0x000fe200078e0018ULL, 0x00000008402a7210ULL, 0x002fc60007ffe0ffULL,
0x000000083e157824ULL, 0x000fe200078e00ffULL, 0xfffffff83b1c7812ULL, 0x000fe200078ee21cULL,
0x000000103a2b7824ULL, 0x100fe400078e0213ULL, 0x000000241a2c7836ULL, 0x004fe20000000000ULL,
0xfffffff815247812ULL, 0x000fe200078ee220ULL, 0x0000001038157824ULL, 0x000fe400078e0213ULL,
0x0000000117377824ULL, 0x000fe200030e0621ULL, 0x0000002616267210ULL, 0x000fe20007fde0ffULL,
0x000000010d217824ULL, 0x000fe200078e022cULL, 0x000000002e157faeULL, 0x0003e2000c901c46ULL,
0x0000000840397824ULL, 0x040fe200078e00ffULL, 0x000000074000720cULL, 0x080fe20003f26070ULL,
0x000000012c2d7824ULL, 0x040fe200078e0208ULL, 0x00000000302b7faeULL, 0x0005e2000d101c46ULL,
0x000000072c00720cULL, 0x000fe20003f46070ULL, 0x0000010021207825ULL, 0x000fe200078e0018ULL,
0x0000002717277210ULL, 0x000fc400037fe4ffULL, 0xfffffff8392a7812ULL, 0x000fe200078ee22aULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x0000002016207210ULL, 0x000fe20007fde0ffULL,
0x000000341a2e7836ULL, 0x002fe20000000000ULL, 0x000000133c157211ULL, 0x080fe400078e20ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee22dULL, 0x00000010222b7824ULL, 0x104fe200078e0213ULL,
0x00000013242f7211ULL, 0x000fe200078e20ffULL, 0x000000101c2d7824ULL, 0x100fe200078e0213ULL,
0x0000000028157faeULL, 0x0003e2000c101c46ULL, 0x000000281a1c7836ULL, 0x000fe20000000000ULL,
0x0000002c1a227810ULL, 0x000fe20007ffe0ffULL, 0x000000102a317824ULL, 0x000fe200078e0213ULL,
0x00000000322b7faeULL, 0x0005e2000d901c46ULL, 0x0000000117217824ULL, 0x000fc400030e0621ULL,
0x000000102c397824ULL, 0x000fe200078e0213ULL, 0x00000000342d7faeULL, 0x000fe2000e901c46ULL,
0x000000301a247836ULL, 0x000fe20000000000ULL, 0x000000071c00720cULL, 0x080fe20003fa6070ULL,
0x000000381a307836ULL, 0x000fe20000000000ULL, 0x00000000362f7faeULL, 0x0007e2000e101c46ULL,
0x000000010d157824ULL, 0x002fe200078e021cULL, 0x000000072200720cULL, 0x080fe20003f86070ULL,
0x000000081c297824ULL, 0x040fe200078e00ffULL, 0x0000000026317faeULL, 0x0003e2000c901c46ULL,
0x0000003c1a327810ULL, 0x004fe20007ffe0ffULL, 0x000000011c1a7824ULL, 0x000fe200078e0208ULL,
0x000000072400720cULL, 0x080fe20003f66070ULL, 0x0000000020397faeULL, 0x0005e2000d101c46ULL,
0x000000072e00720cULL, 0x000fc40003f46070ULL, 0xfffffff8291a7812ULL, 0x000fe200078ee21aULL,
0x00000008242f7824ULL, 0x008fe200078e00ffULL, 0x000000073000720cULL, 0x080fe40003f26070ULL,
0x000000073200720cULL, 0x000fe20003f06070ULL, 0x000000010d077824ULL, 0x000fe200078e022eULL,
0x000000220d277210ULL, 0x002fe40007ffe0ffULL, 0x00000003221c7819ULL, 0x000fe200000006ffULL,
0x0000010015207825ULL, 0x004fc800078e0018ULL, 0x0000010027267825ULL, 0x000fe200078e0018ULL,
0x0000002016287210ULL, 0x000fc60007fde0ffULL, 0x000000010d157824ULL, 0x000fe400078e0224ULL,
0x0000000117297824ULL, 0x000fe200030e0621ULL, 0x00000026162a7210ULL, 0x000fe20007fde0ffULL,
0x0000010015207825ULL, 0x000fc800078e0018ULL, 0x0000000122157824ULL, 0x000fe400078e0208ULL,
0x00000001172b7824ULL, 0x000fe200030e0627ULL, 0x00000020162c7210ULL, 0x000fe20007fde0ffULL,
0x0000010007267825ULL, 0x000fe200078e0018ULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee215ULL,
0x00000021172d7210ULL, 0x000fe200037fe4ffULL, 0x000000010d157824ULL, 0x040fe200078e0230ULL,
0x0000002616267210ULL, 0x000fe20007fde0ffULL, 0x000000010d077824ULL, 0x000fc400078e0232ULL,
0x0000010015207825ULL, 0x000fc800078e0018ULL, 0x0000000124227824ULL, 0x100fe200078e0208ULL,
0x000000032e247819ULL, 0x040fe200000006ffULL, 0x000000012e157824ULL, 0x000fe400078e0208ULL,
0x0000000117277824ULL, 0x000fe200030e0627ULL, 0x0000002016207210ULL, 0x000fe20007fde0ffULL,
0x0000010007187825ULL, 0x000fe200078e0018ULL, 0x0000000830077210ULL, 0x000fe40007ffe0ffULL,
0xfffffff824247812ULL, 0x000fe200078ee215ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0xfffffff82f227812ULL, 0x000fe200078ee222ULL, 0x0000000132157824ULL, 0x000fe200078e0208ULL,
0x00000013242f7211ULL, 0x000fe200078e20ffULL, 0x0000000117217824ULL, 0x000fe200030e0621ULL,
0x0000001816167210ULL, 0x000fe20007fde0ffULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0xfffffff830187812ULL, 0x000fc400078ee207ULL, 0x000000131a077211ULL, 0x000fe200078e20ffULL,
0x0000000117177824ULL, 0x000fe200030e0619ULL, 0xfffffff8321a7812ULL, 0x000fe200078ee215ULL,
0x000000101c157824ULL, 0x100fe400078e0213ULL, 0x0000001022197824ULL, 0x100fe200078e0213ULL,
0x0000000028077faeULL, 0x0003e2000e901c46ULL, 0x0000001018317824ULL, 0x100fe400078e0213ULL,
0x000000101a337824ULL, 0x000fe200078e0213ULL, 0x000000002a157faeULL, 0x0003e8000e101c46ULL,
0x000000002c197faeULL, 0x0003e8000d901c46ULL, 0x00000000262f7faeULL, 0x0003e8000d101c46ULL,
0x0000000020317faeULL, 0x0003e8000c901c46ULL, 0x0000000016337faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000408077811ULL, 0x044fe200078fe8ffULL,
0x0000001008257824ULL, 0x040fe200078e00ffULL, 0x0000000808157811ULL, 0x040fe200078fe8ffULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0x00000003071c7819ULL, 0x040fe200000006ffULL,
0x0000000107137824ULL, 0x100fe200078e0208ULL, 0x0000000c081a7811ULL, 0x040fe200078fe8ffULL,
0x0000000115187824ULL, 0x140fe200078e0208ULL, 0x0000001808207811ULL, 0x000fe200078fe8ffULL,
0x0000000815217824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee213ULL,
0x000000011a197824ULL, 0x100fe200078e0208ULL, 0x0000001008137811ULL, 0x000fe200078fe8ffULL,
0x0000000820487824ULL, 0x040fe200078e00ffULL, 0xfffffff821247812ULL, 0x000fe200078ee218ULL,
0x0000000120217824ULL, 0x100fe200078e0208ULL, 0x000000031a427819ULL, 0x000fe200000006ffULL,
0x0000000113187824ULL, 0x040fe200078e0208ULL, 0x00000014081e7811ULL, 0x040fe200078fe8ffULL,
0x0000000813237824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee219ULL,
0x000000010d2d7824ULL, 0x040fe200078e0220ULL, 0x0000002008227811ULL, 0x000fe200078fe8ffULL,
0x000000011e197824ULL, 0x040fe200078e0208ULL, 0xfffffff823447812ULL, 0x000fe200078ee218ULL,
0x000000010d297824ULL, 0x040fe200078e0213ULL, 0x000000031e467819ULL, 0x000fe200000006ffULL,
0x00000008224c7824ULL, 0x000fe200078e00ffULL, 0x0000001c08187811ULL, 0x000fe200078fe8ffULL,
0x000000010d317824ULL, 0x040fe200078e0222ULL, 0xfffffff848487812ULL, 0x000fe200078ee221ULL,
0x0000000122217824ULL, 0x100fe200078e0208ULL, 0xfffffff846467812ULL, 0x000fe200078ee219ULL,
0x0000000118197824ULL, 0x000fe200078e0208ULL, 0x0000002c082a7811ULL, 0x000fe200078fe8ffULL,
0x000000010d2b7824ULL, 0x000fe200078e021eULL, 0x00000003184a7819ULL, 0x000fc400000006ffULL,
0x0000002808287811ULL, 0x040fe400078fe8ffULL, 0x0000002408267811ULL, 0x000fe400078fe8ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL, 0x000000012a217824ULL, 0x100fe200078e0208ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee219ULL, 0x0000000128197824ULL, 0x100fe200078e0208ULL,
0x000000032a527819ULL, 0x000fe200000006ffULL, 0x0000000828507824ULL, 0x000fe200078e00ffULL,
0x0000003808307811ULL, 0x000fe200078fe8ffULL, 0x0000000126237824ULL, 0x000fe200078e0208ULL,
0x00000034082e7811ULL, 0x000fe200078fe8ffULL, 0x000000010d357824ULL, 0x040fe200078e0228ULL,
0x00000003264e7819ULL, 0x000fe200000006ffULL, 0x0000000830587824ULL, 0x000fe200078e00ffULL,
0x00000030082c7811ULL, 0x000fe200078fe8ffULL, 0x000000010d337824ULL, 0x000fe200078e0226ULL,
0xfffffff852527812ULL, 0x000fe200078ee221ULL, 0x0000000130217824ULL, 0x100fe200078e0208ULL,
0xfffffff850507812ULL, 0x000fe200078ee219ULL, 0x000000012e197824ULL, 0x100fe200078e0208ULL,
0x0000007025257812ULL, 0x000fe200078ec0ffULL, 0x000000082c547824ULL, 0x040fe200078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee223ULL, 0x000000012c237824ULL, 0x000fe200078e0208ULL,
0x000000032e567819ULL, 0x000fe200000006ffULL, 0x000000010d3b7824ULL, 0x040fe200078e022eULL,
0x0000003c08327811ULL, 0x000fe200078fe8ffULL, 0x000000010d397824ULL, 0x040fe200078e022cULL,
0xfffffff858587812ULL, 0x000fe200078ee221ULL, 0x000000010d217824ULL, 0x000fe200078e0207ULL,
0x00000080253e7812ULL, 0x000fe200078efcffULL, 0x000000010d077824ULL, 0x000fe200078e0232ULL,
0xfffffff856567812ULL, 0x000fc400078ee219ULL, 0xfffffff854547812ULL, 0x000fe200078ee223ULL,
0x0000000132237824ULL, 0x000fe200078e0208ULL, 0x0000000d08197211ULL, 0x000fe200078fe8ffULL,
0x0000010021207825ULL, 0x100fe200078e003eULL, 0x00000003325a7819ULL, 0x000fe400000006ffULL,
0x000000180d2f7210ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x000fe200078e003eULL,
0x0000001a0d277210ULL, 0x000fe40007ffe0ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee223ULL,
0x000000010d237824ULL, 0x000fe200078e0215ULL, 0x0000002016207210ULL, 0x000fe20007f3e0ffULL,
0x0000010029287825ULL, 0x000fe200078e003eULL, 0x0000001816187210ULL, 0x000fc40007f1e0ffULL,
0x000000300d3d7210ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x100fe200078e003eULL,
0x0000001917197210ULL, 0x000fe400007fe4ffULL, 0x0000002a0d377210ULL, 0x000fe20007ffe0ffULL,
0x0000010023227825ULL, 0x000fe200078e003eULL, 0x0000002616267210ULL, 0x000fe40007f1e0ffULL,
0x00000008081a7211ULL, 0x000fe200078fe8ffULL, 0x0000000117217824ULL, 0x000fe200008e0621ULL,
0x0000002816287210ULL, 0x000fe20007f3e0ffULL, 0x0000010031307825ULL, 0x000fe200078e003eULL,
0x0000002216407210ULL, 0x000fc40007f5e0ffULL, 0x0000002717277210ULL, 0x000fe200007fe4ffULL,
0x000001002f2e7825ULL, 0x000fe200078e003eULL, 0x0000000a031e7211ULL, 0x000fc600078e70ffULL,
0x000001002b2a7825ULL, 0x000fe200078e003eULL, 0x0000002e162e7210ULL, 0x000fc60007f1e0ffULL,
0x0000000117297824ULL, 0x000fe200008e0629ULL, 0x0000003016307210ULL, 0x000fe20007f3e0ffULL,
0x0000010039387825ULL, 0x000fc800078e003eULL, 0x000001002d2c7825ULL, 0x000fc800078e003eULL,
0x0000010037367825ULL, 0x000fe200078e003eULL, 0x0000002c162c7210ULL, 0x000fc60007f7e0ffULL,
0x0000000117417824ULL, 0x000fe200010e0623ULL, 0x0000002a162a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010033327825ULL, 0x000fe200078e003eULL, 0x0ffffff808237812ULL, 0x000fe400078ec0ffULL,
0x0000002d172d7210ULL, 0x000fe20001ffe4ffULL, 0x0000000117317824ULL, 0x040fe200008e0631ULL,
0x0000003816387210ULL, 0x000fe20007f3e0ffULL, 0x00000001172f7824ULL, 0x000fe200000e062fULL,
0x0000003616367210ULL, 0x000fe20007f1e0ffULL, 0x0000010035347825ULL, 0x000fe200078e003eULL,
0x00000007231a7812ULL, 0x000fc600078ef81aULL, 0x000001003d3c7825ULL, 0x000fe200078e003eULL,
0x0000003416347210ULL, 0x000fc60007f7e0ffULL, 0x000001003b3a7825ULL, 0x000fc800078e003eULL,
0x00000001172b7824ULL, 0x000fe200010e062bULL, 0x0000003216327210ULL, 0x000fe20007f5e0ffULL,
0x00000100073e7825ULL, 0x000fc600078e003eULL, 0x0000003317337210ULL, 0x000fe200017fe4ffULL,
0x0000000117397824ULL, 0x040fe200008e0639ULL, 0x0000003c163c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117377824ULL, 0x040fe200000e0637ULL, 0x0000003a163a7210ULL, 0x000fe20007f1e0ffULL,
0x000040001e137836ULL, 0x000fe20000000000ULL, 0x0000003e16167210ULL, 0x000fe20007f5e0ffULL,
0x0000000117357824ULL, 0x040fe200018e0635ULL, 0x0000003b173b7210ULL, 0x000fe200007fe4ffULL,
0x000000101a077824ULL, 0x000fe200078e0213ULL, 0x0000001342437211ULL, 0x080fe200078e20ffULL,
0x00000001173d7824ULL, 0x000fe200008e063dULL, 0x0000003f17177210ULL, 0x000fe200017fe4ffULL,
0x000000101c157824ULL, 0x100fe200078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018077faeULL, 0x0003e2000b901c46ULL, 0x00000010243f7824ULL, 0x100fe200078e0213ULL,
0x0000001348497211ULL, 0x000fe200078e20ffULL, 0x0000001044457824ULL, 0x100fe200078e0213ULL,
0x0000000020157faeULL, 0x0005e2000b901c46ULL, 0x0000001046477824ULL, 0x000fc600078e0213ULL,
0x00000000403f7faeULL, 0x000fe2000b901c46ULL, 0x000000104a077824ULL, 0x002fc600078e0213ULL,
0x0000000026437faeULL, 0x0003e2000b901c46ULL, 0x000000134e197211ULL, 0x000fe200078e20ffULL,
0x000000104c157824ULL, 0x104fe400078e0213ULL, 0x0000000028457faeULL, 0x0005e2000b901c46ULL,
0x0000001050217824ULL, 0x000fc600078e0213ULL, 0x000000002a477faeULL, 0x0007e8000b901c46ULL,
0x000000002c497faeULL, 0x0009e2000b901c46ULL, 0x0000001052277824ULL, 0x002fc600078e0213ULL,
0x000000002e077faeULL, 0x0003e2000b901c46ULL, 0x0000001354297211ULL, 0x004fc600078e20ffULL,
0x0000000030157faeULL, 0x0005e2000b901c46ULL, 0x00000010562b7824ULL, 0x008fc600078e0213ULL,
0x0000000032197faeULL, 0x0005e2000b901c46ULL, 0x000000135a2d7211ULL, 0x010fe200078e20ffULL,
0x0000001058077824ULL, 0x002fe400078e0213ULL, 0x0000000034217faeULL, 0x0005e8000b901c46ULL,
0x0000000036277faeULL, 0x0005e8000b901c46ULL, 0x0000000038297faeULL, 0x0005e8000b901c46ULL,
0x000000003a2b7faeULL, 0x0005e8000b901c46ULL, 0x000000003c077faeULL, 0x0005e8000b901c46ULL,
0x00000000162d7faeULL, 0x0005e4000b901c46ULL, 0x0000000406067836ULL, 0x000fe20000000000ULL,
0xffffffff00077802ULL, 0x006fe20000000f00ULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000000b0600720cULL, 0x000fda0003f06070ULL, 0x00009200ff268b82ULL, 0x000e620000000a00ULL,
0x000000021f158824ULL, 0x000fe200078e0206ULL, 0x00000004ff1a7819ULL, 0x100fe20000011608ULL,
0x000020001e217836ULL, 0x000fe20000000000ULL, 0x0000000808197812ULL, 0x000fe400078ec0ffULL,
0x00000003ff177819ULL, 0x000fe20000011608ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000415268825ULL, 0x002fca00078e0026ULL, 0x0000000626078981ULL, 0x0002a2000c1e1900ULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0x0000000708157812ULL, 0x000fe400078ec0ffULL,
0x0000000719167812ULL, 0x000fe400078ef808ULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee215ULL,
0x00000001171c7812ULL, 0x000fe200078ec0ffULL, 0x0000001016297824ULL, 0x040fe200078e00ffULL,
0x0000001016197812ULL, 0x000fe200078efcffULL, 0x000000101e657836ULL, 0x000fe20000000000ULL,
0x000000201e277810ULL, 0x002fe20007ffe0ffULL, 0x000000301e267836ULL, 0x000fe20000000000ULL,
0x000000161a187210ULL, 0x000fe20007ffe0ffULL, 0x000000011c647824ULL, 0x000fe200078e021eULL,
0x000000031e2d7819ULL, 0x000fe200000006ffULL, 0x00000010192b7824ULL, 0x000fe200078e00ffULL,
0x000000191a1a7210ULL, 0x000fe20007ffe0ffULL, 0x000000011ca87824ULL, 0x040fe200078e0265ULL,
0x0000000327317819ULL, 0x000fe200000006ffULL, 0x000000011ca67824ULL, 0x040fe200078e0227ULL,
0xfffffff029297812ULL, 0x000fe200078ee218ULL, 0x00000008652f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82daa7812ULL, 0x000fe200078ee264ULL, 0x000000011ca47824ULL, 0x000fe200078e0226ULL,
0xfffffff02b2b7812ULL, 0x000fe200078ee21aULL, 0x0000000826337824ULL, 0x000fe200078e00ffULL,
0xfffffff82fa87812ULL, 0x000fe200078ee2a8ULL, 0x0000001029297824ULL, 0x100fe200078e020aULL,
0xfffffff831a67812ULL, 0x000fe200078ee2a6ULL, 0x0000001016357824ULL, 0x000fe200078e00ffULL,
0xfffffff833a47812ULL, 0x000fe200078ee2a4ULL, 0x0000000218207836ULL, 0x000fe20000000000ULL,
0x00000021aa587211ULL, 0x080fe200078e20ffULL, 0x00000010a8347824ULL, 0x100fe200078e0221ULL,
0x0000000a2b2b7211ULL, 0x080fe200078e20ffULL, 0x00000010a6287824ULL, 0x100fe200078e0221ULL,
0x00000021a4547211ULL, 0x080fe200078e20ffULL, 0x00000000294c783bULL, 0x000fe20000000200ULL,
0x00000010192f7824ULL, 0x000fe200078e00ffULL, 0xfffffff0352d7812ULL, 0x000fe200078ee220ULL,
0x000000021a1c7836ULL, 0x000fe20000000000ULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x000000031e317819ULL, 0x000fe200000006ffULL, 0x00000022649e7836ULL, 0x000fe20000000000ULL,
0x0000000264a27810ULL, 0x000fe20007ffe0ffULL, 0x000000002b68783bULL, 0x000ee20000000200ULL,
0xfffffff02f2f7812ULL, 0x000fe200078ee21cULL, 0x00000032649c7836ULL, 0x000fe20000000000ULL,
0xfffffff831a27812ULL, 0x000fe200078ee2a2ULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x0000000a2f847211ULL, 0x000fe200078e20ffULL, 0x00000008262f7824ULL, 0x000fe200078e00ffULL,
0x0000000327317819ULL, 0x000fe200000006ffULL, 0x000000002828783bULL, 0x000f620000000200ULL,
0x0000001264a07836ULL, 0x000fe20000000000ULL, 0x000000041a207810ULL, 0x000fe20007ffe0ffULL,
0x0000000865337824ULL, 0x000fe200078e00ffULL, 0x000000005454783bULL, 0x000f220000000200ULL,
0xfffffff8319e7812ULL, 0x000fe200078ee29eULL, 0x00000010a27c7824ULL, 0x100fe200078e0221ULL,
0xfffffff82f9c7812ULL, 0x000fe200078ee29cULL, 0x000000102d2d7824ULL, 0x000fe200078e020aULL,
0xfffffff833a07812ULL, 0x000fe200078ee2a0ULL, 0x000000109e707824ULL, 0x100fe200078e0221ULL,
0x000000008484783bULL, 0x000fe20000000200ULL, 0x000000109c5c7824ULL, 0x000fe200078e0221ULL,
0x00000021a0747211ULL, 0x000fe200078e20ffULL, 0x00000004181c7836ULL, 0x000fe20000000000ULL,
0x000000002d78783bULL, 0x0007e20000000200ULL, 0x0000000464227836ULL, 0x000fc40000000000ULL,
0x000000081e677824ULL, 0x000fe200078e00ffULL, 0x000000007c7c783bULL, 0x000f620000000200ULL,
0x0000000618247836ULL, 0x000fc60000000000ULL, 0x000000007474783bULL, 0x000f680000000200ULL,
0x000000007070783bULL, 0x000f620000000200ULL, 0x000000584c98723cULL, 0x002fe600000018ffULL,
0x000000005c5c783bULL, 0x000e660000000200ULL, 0x00000058682c723cULL, 0x008fec00000018ffULL,
0x0000005a4c30723cULL, 0x000fec00000018ffULL, 0x0000005a6858723cULL, 0x000fec00000018ffULL,
0x000000344c38723cULL, 0x010fec00000018ffULL, 0x000000364c3c723cULL, 0x000fec00000018ffULL,
0x000000284c44723cULL, 0x020fec00000018ffULL, 0x0000002a4c48723cULL, 0x000fec00000018ffULL,
0x000000544c40723cULL, 0x000fec00000018ffULL, 0x000000564c4c723cULL, 0x000fec00000018ffULL,
0x000000346850723cULL, 0x000fec00000018ffULL, 0x000000366834723cULL, 0x000fec00000018ffULL,
0x0000007c7898723cULL, 0x000fec0000001898ULL, 0x0000007c842c723cULL, 0x000fec000000182cULL,
0x0000007e7830723cULL, 0x000fec0000001830ULL, 0x0000007e847c723cULL, 0x000fec0000001858ULL,
0x000000286858723cULL, 0x000fec00000018ffULL, 0x0000002a6828723cULL, 0x000fec00000018ffULL,
0x000000546860723cULL, 0x000fec00000018ffULL, 0x000000747838723cULL, 0x000fe20000001838ULL,
0x0000001016557824ULL, 0x000fca00078e00ffULL, 0x00000076783c723cULL, 0x000fe2000000183cULL,
0xfffffff055557812ULL, 0x000fe400078ee224ULL, 0x0000000664247810ULL, 0x000fc60007ffe0ffULL,
0x000000707844723cULL, 0x000fe20000001844ULL, 0xfffffff867247812ULL, 0x000fca00078ee224ULL,
0x000000727848723cULL, 0x000fec0000001848ULL, 0x0000005c7840723cULL, 0x002fec0000001840ULL,
0x000000566868723cULL, 0x000fec00000018ffULL, 0x0000005e7878723cULL, 0x000fe2000000184cULL,
0x000000081e577824ULL, 0x000fe200078e00ffULL, 0x00000014641e7810ULL, 0x000fc80007ffe0ffULL,
0x000000748450723cULL, 0x000fe20000001850ULL, 0x00000004164d7819ULL, 0x000fe400000006ffULL,
0x00000004194f7819ULL, 0x000fe400000006ffULL, 0xfffffff04d4d7812ULL, 0x000fe200078ee21cULL,
0x000000768474723cULL, 0x000fe20000001834ULL, 0xfffffff8571c7812ULL, 0x000fe200078ee222ULL,
0x0000002464227836ULL, 0x000fe20000000000ULL, 0xfffffff04f4f7812ULL, 0x000fe200078ee220ULL,
0x0000003464207836ULL, 0x000fe20000000000ULL, 0x0000000326577819ULL, 0x000fe200000006ffULL,
0x000000101c947824ULL, 0x100fe200078e0221ULL, 0x0000000a4f4f7211ULL, 0x080fe200078e20ffULL,
0x0000000865357824ULL, 0x000fe200078e00ffULL, 0xfffffff857207812ULL, 0x000fe200078ee220ULL,
0x0000000827377824ULL, 0x000fe200078e00ffULL, 0x000000708458723cULL, 0x000fe20000001858ULL,
0x000000104d4d7824ULL, 0x000fe200078e020aULL, 0xfffffff8351e7812ULL, 0x000fe200078ee21eULL,
0x000000009494783bULL, 0x000fe20000000200ULL, 0xfffffff837227812ULL, 0x000fe200078ee222ULL,
0x0000001019347824ULL, 0x000fe200078e00ffULL, 0x0000002120807211ULL, 0x000fe200078e20ffULL,
0x000000101e8c7824ULL, 0x100fe200078e0221ULL, 0x000000004d90783bULL, 0x000e620000000200ULL,
0x0000001022887824ULL, 0x000fe200078e0221ULL, 0x000000728470723cULL, 0x000fe20000001828ULL,
0x0000000865657824ULL, 0x000fe200078e00ffULL, 0x000000004f6c783bULL, 0x000ee20000000200ULL,
0x0000000a554c7211ULL, 0x000fc600078e20ffULL, 0x000000008c8c783bULL, 0x000f220000000200ULL,
0x00000003262b7819ULL, 0x000fe200000006ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0x0000002664287810ULL, 0x000fe20007ffe0ffULL, 0x000000008888783bULL, 0x000f620000000200ULL,
0x0000001664267836ULL, 0x000fe20000000000ULL, 0x0000005c8460723cULL, 0x000fe20000001860ULL,
0x000000061a277836ULL, 0x000fe20000000000ULL, 0x000000008080783bULL, 0x000ea20000000200ULL,
0x00000036642a7836ULL, 0x000fe20000000000ULL, 0xfffffff829287812ULL, 0x000fc400078ee228ULL,
0xfffffff865267812ULL, 0x000fe200078ee226ULL, 0x0000005e8484723cULL, 0x000fe20000001868ULL,
0xfffffff034277812ULL, 0x000fe200078ee227ULL, 0x0000001024347824ULL, 0x100fe200078e0221ULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee22aULL, 0x00000010285c7824ULL, 0x100fe200078e0221ULL,
0x0000002126547211ULL, 0x000fe200078e20ffULL, 0x0000001027277824ULL, 0x000fe200078e020aULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0x000000102a297824ULL, 0x000fc600078e0221ULL,
0x000000003434783bULL, 0x000f680000000200ULL, 0x000000002764783bULL, 0x0007680000000200ULL,
0x000000005454783bULL, 0x000f620000000200ULL, 0x000000949098723cULL, 0x002fe60000001898ULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x0000000500277210ULL, 0x008fc40007ffe0ffULL,
0x000000946c2c723cULL, 0x000fe2000000182cULL, 0x000000002968783bULL, 0x00066a0000000200ULL,
0x000000969030723cULL, 0x000fe20000001830ULL, 0x0000000127297836ULL, 0x008fca0000000000ULL,
0x0000008c9038723cULL, 0x010fe20000001838ULL, 0x0000000c2900720cULL, 0x000fe20003f06070ULL,
0x0000001007297224ULL, 0x004fc800078e02ffULL, 0x0000008e903c723cULL, 0x000fe2000000183cULL,
0x0000010029ae7825ULL, 0x000fca00078e00aeULL, 0x000000889044723cULL, 0x020fec0000001844ULL,
0x0000008a9048723cULL, 0x000fec0000001848ULL, 0x0000008c6c50723cULL, 0x000fec0000001850ULL,
0x000000886c58723cULL, 0x000fec0000001858ULL, 0x000000966c7c723cULL, 0x000fec000000187cULL,
0x000000809040723cULL, 0x000fec0000001840ULL, 0x0000008e6c74723cULL, 0x000fec0000001874ULL,
0x000000806c60723cULL, 0x000fec0000001860ULL, 0x0000008a6c70723cULL, 0x000fec0000001870ULL,
0x000000829078723cULL, 0x000fec0000001878ULL, 0x000000826c6c723cULL, 0x000fec0000001884ULL,
0x000000344c98723cULL, 0x000fec0000001898ULL, 0x00000034642c723cULL, 0x000fec000000182cULL,
0x000000364c30723cULL, 0x000fec0000001830ULL, 0x000000544c38723cULL, 0x000fec0000001838ULL,
0x000000564c3c723cULL, 0x000fec000000183cULL, 0x0000005c4c44723cULL, 0x002fec0000001844ULL,
0x0000005e4c48723cULL, 0x000fec0000001848ULL, 0x000000546450723cULL, 0x000fec0000001850ULL,
0x0000005c6458723cULL, 0x000fec0000001858ULL, 0x000000366434723cULL, 0x000fec000000187cULL,
0x000000684c40723cULL, 0x000fec0000001840ULL, 0x000000566454723cULL, 0x000fec0000001874ULL,
0x0000005e645c723cULL, 0x000fec0000001870ULL, 0x000000686460723cULL, 0x000fec0000001860ULL,
0x0000006a4c4c723cULL, 0x000fec0000001878ULL, 0x0000006a6464723cULL, 0x000fe2000000186cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c00148947ULL, 0x000fde0003800000ULL,
0x0000000117687824ULL, 0x100fe200078e0208ULL, 0x0000000c176b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000817697836ULL, 0x000fe20000000000ULL, 0x0000001227727211ULL, 0x000fe200078e40ffULL,
0x0000001817797836ULL, 0x000fe20000000000ULL, 0x0000000723867812ULL, 0x000fe200078ef868ULL,
0x00000008696d7824ULL, 0x000fe200078e00ffULL, 0x0000000869687210ULL, 0x000fe20007ffe0ffULL,
0x000000016b6a7824ULL, 0x140fe200078e0208ULL, 0x000000036b6f7819ULL, 0x000fe200000006ffULL,
0x0000002817837836ULL, 0x000fe20000000000ULL, 0x0000007209237248ULL, 0x000fe20007fe0000ULL,
0x0000001c177d7836ULL, 0x000fe20000000000ULL, 0xfffffff86d8a7812ULL, 0x000fe200078ee268ULL,
0x00000010176d7836ULL, 0x000fe20000000000ULL, 0xfffffff86f8c7812ULL, 0x000fe200078ee26aULL,
0x0000000179687824ULL, 0x040fe200078e0208ULL, 0x000000087d6a7210ULL, 0x000fe20007ffe0ffULL,
0x00000008796f7824ULL, 0x000fe200078e00ffULL, 0x00000034178f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000123727824ULL, 0x000fe200078e0a72ULL, 0x000000086d237210ULL, 0x000fe20007ffe0ffULL,
0x000000086d8e7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f927812ULL, 0x000fe200078ee268ULL,
0x00000020177f7836ULL, 0x000fe20000000000ULL, 0x000000726900720cULL, 0x080fe20003f06070ULL,
0x00000001837c7824ULL, 0x040fe200078e0208ULL, 0xfffffff88e8e7812ULL, 0x000fe200078ee223ULL,
0x00000008836f7824ULL, 0x000fe200078e00ffULL, 0x000000087f237210ULL, 0x000fe20007ffe0ffULL,
0x000000087d717824ULL, 0x000fe200078e00ffULL, 0x0000001417757810ULL, 0x000fe20007ffe0ffULL,
0x000000087f967824ULL, 0x000fe200078e00ffULL, 0xfffffff86f7c7812ULL, 0x000fe200078ee27cULL,
0x00000030178d7836ULL, 0x000fe20000000000ULL, 0xfffffff871947812ULL, 0x000fe200078ee26aULL,
0x000000010d687824ULL, 0x000fe200078e0217ULL, 0xfffffff896967812ULL, 0x000fe200078ee223ULL,
0x00000004172b7836ULL, 0x000fe20000000000ULL, 0x000000088d807210ULL, 0x000fe20007ffe0ffULL,
0x0000002c178b7836ULL, 0x000fe20000000000ULL, 0x000000726b00720cULL, 0x000fe20003f26070ULL,
0x000000088d6f7824ULL, 0x000fe200078e00ffULL, 0x0000002b0d6a7210ULL, 0x000fe20007ffe0ffULL,
0x000000010d7a7824ULL, 0x000fe200078e0269ULL, 0x000000088b7e7210ULL, 0x000fe20007ffe0ffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0xfffffff86f807812ULL, 0x000fc400078ee280ULL,
0x0000002417817810ULL, 0x000fe20007ffe0ffULL, 0x000000088b717824ULL, 0x000fe200078e00ffULL,
0x00000025686f7212ULL, 0x000fe200078efcffULL, 0x0000003817237836ULL, 0x000fe20000000000ULL,
0x0000000375907819ULL, 0x000fe200000006ffULL, 0x000000012b297824ULL, 0x140fe200078e0208ULL,
0xfffffff8717e7812ULL, 0x000fe200078ee27eULL, 0x000000082b887824ULL, 0x000fe200078e00ffULL,
0x000000038f717819ULL, 0x000fe200000006ffULL, 0x0000000123767824ULL, 0x100fe200078e0208ULL,
0x000000726d00720cULL, 0x000fe20003f46070ULL, 0x0000000823737824ULL, 0x000fe200078e00ffULL,
0xfffffff888887812ULL, 0x000fe200078ee229ULL, 0x000000010d847824ULL, 0x000fe200078e026bULL,
0x0000006fae6e7210ULL, 0x000fe20007f7e0ffULL, 0x000000018f747824ULL, 0x000fe200078e0208ULL,
0xfffffff873767812ULL, 0x000fe200078ee276ULL, 0x000001007a7a7825ULL, 0x000fe200078e00ffULL,
0x0000006d0d6d7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff871747812ULL, 0x000fe200078ee274ULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x000000257a737212ULL, 0x080fe400078efcffULL,
0x000000722b00720cULL, 0x000fe20003f86070ULL, 0x0000000175297824ULL, 0x000fe200078e0208ULL,
0x000000256a717212ULL, 0x000fe200078efcffULL, 0x0000010084847825ULL, 0x000fc600078e00ffULL,
0xfffffff890907812ULL, 0x000fe200078ee229ULL, 0x0000000181827824ULL, 0x040fe200078e0208ULL,
0x0000000381297819ULL, 0x000fe200000006ffULL, 0x00000001af6f7824ULL, 0x000fe200018e0669ULL,
0x00000025842b7212ULL, 0x080fe200078efcffULL, 0x000001006d6c7825ULL, 0x000fe200078e00ffULL,
0x00000073ae687210ULL, 0x000fe40007f7e0ffULL, 0x00000071ae707210ULL, 0x000fe20007fbe0ffULL,
0x000000010d7a7824ULL, 0x000fe200078e0275ULL, 0xfffffff829827812ULL, 0x000fe200078ee282ULL,
0x0000003c17297836ULL, 0x000fe20000000000ULL, 0x0000002bae6a7210ULL, 0x000fe20007fde0ffULL,
0x00000001af717824ULL, 0x000fe200028e066bULL, 0x0000007baf697210ULL, 0x000fe20001ffe4ffULL,
0x000001007a7a7825ULL, 0x000fe200078e00ffULL, 0x000000256c2b7212ULL, 0x000fc400078efcffULL,
0x000000727500720cULL, 0x080fe20003f66070ULL, 0x0000001086757824ULL, 0x000fe200078e0221ULL,
0x000000721700720cULL, 0x000fe20003fa6070ULL, 0x0000000829777824ULL, 0x000fe200078e00ffULL,
0x0000007d0d867210ULL, 0x000fe20007ffe0ffULL, 0x00000001af6b7824ULL, 0x000fe200030e0685ULL,
0x0000000829787210ULL, 0x000fe40007ffe0ffULL, 0x0000002bae6c7210ULL, 0x000fe20007fde0ffULL,
0x0000010086867825ULL, 0x000fe200078e00ffULL, 0x000000790d847210ULL, 0x000fc40007ffe0ffULL,
0x000000257a897212ULL, 0x080fe200078efcffULL, 0x00000001af6d7824ULL, 0x000fe200030e066dULL,
0xfffffff877787812ULL, 0x000fe200078ee278ULL, 0x0000010084847825ULL, 0x000fe200078e00ffULL,
0x00000025862b7212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e757faeULL, 0x0003e2000e901c46ULL, 0x000000727900720cULL, 0x000fe20003fa6070ULL,
0x0000001088777824ULL, 0x000fe200078e0221ULL, 0x00000089ae887210ULL, 0x000fe40007fde0ffULL,
0x0000002584737212ULL, 0x000fc400078efcffULL, 0x0000000070777faeULL, 0x0005e2000e101c46ULL,
0x00000001af897824ULL, 0x000fe200030e067bULL, 0x00000073ae7a7210ULL, 0x000fe20007f9e0ffULL,
0x000000108e737824ULL, 0x100fe200078e0221ULL, 0x0000002bae6e7210ULL, 0x002fe20007fde0ffULL,
0x000000108a2b7824ULL, 0x100fe200078e0221ULL, 0x00000085af7b7210ULL, 0x000fe200027fe4ffULL,
0x0000001090757824ULL, 0x000fe200078e0221ULL, 0x000000727d00720cULL, 0x000fe20003f86070ULL,
0x00000001af6f7824ULL, 0x000fe200030e0687ULL, 0x00000000682b7faeULL, 0x000fe2000c101c46ULL,
0x000000218c717211ULL, 0x084fe200078e20ffULL, 0x000000010d707824ULL, 0x000fe200078e028bULL,
0x0000002192777211ULL, 0x000fc400078e20ffULL, 0x000000728300720cULL, 0x080fe20003f06070ULL,
0x000000006a717faeULL, 0x0003e2000c901c46ULL, 0x000000010d837824ULL, 0x000fe200078e0283ULL,
0x000000728b00720cULL, 0x080fe40003f26070ULL, 0x000000006c737faeULL, 0x000fe2000d101c46ULL,
0x000000727f00720cULL, 0x080fe40003f46070ULL, 0x0000007f0d7f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000088757faeULL, 0x0005e2000d901c46ULL, 0x000000728100720cULL, 0x000fe20003f66070ULL,
0x000000010d817824ULL, 0x000fc400078e0281ULL, 0x000000007a777faeULL, 0x0007e2000e901c46ULL,
0x0000010070707825ULL, 0x002fc800078e00ffULL, 0x00000100816a7825ULL, 0x000fe200078e00ffULL,
0x00000025702b7212ULL, 0x000fe400078efcffULL, 0x0000002182757211ULL, 0x004fe200078e20ffULL,
0x000001007f687825ULL, 0x000fe200078e00ffULL, 0x000000256a877212ULL, 0x000fc600078efcffULL,
0x000000010d6a7824ULL, 0x000fe200078e028dULL, 0x00000087ae867210ULL, 0x000fe20007fbe0ffULL,
0x00000100836c7825ULL, 0x000fe200078e00ffULL, 0x0000002568857212ULL, 0x000fc600078efcffULL,
0x00000001af877824ULL, 0x040fe200028e066bULL, 0x0000002bae707210ULL, 0x000fe20007fbe0ffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x00000085ae847210ULL, 0x000fe40007fde0ffULL,
0x000000256c737212ULL, 0x080fe200078efcffULL, 0x00000001af717824ULL, 0x000fe200028e0671ULL,
0x000000256a7b7212ULL, 0x008fe200078efcffULL, 0x000000010d6a7824ULL, 0x000fe200078e028fULL,
0x00000069af857210ULL, 0x000fe400037fe4ffULL, 0x0000007bae7a7210ULL, 0x000fc40007fbe0ffULL,
0x00000073ae687210ULL, 0x000fe20007fde0ffULL, 0x0000001096737824ULL, 0x000fe200078e0221ULL,
0x00000021942b7211ULL, 0x000fe200078e20ffULL, 0x00000001af7b7824ULL, 0x000fe200028e066bULL,
0x000000230d6c7210ULL, 0x000fe20007ffe0ffULL, 0x000001006a6a7825ULL, 0x000fe400078e00ffULL,
0x000000006e2b7faeULL, 0x0003e2000e101c46ULL, 0x000000728f00720cULL, 0x080fe20003f86070ULL,
0x00000001af697824ULL, 0x000fe200030e066dULL, 0x000000728d00720cULL, 0x080fe20003fc6070ULL,
0x000001006c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000084737faeULL, 0x0005e8000d101c46ULL,
0x0000000086757faeULL, 0x0007e2000d901c46ULL, 0x000000722300720cULL, 0x000fe20003f66070ULL,
0x000000107c237824ULL, 0x000fe200078e0221ULL, 0x000000256a6f7212ULL, 0x082fe200078efcffULL,
0x000000010d6e7824ULL, 0x000fe200078e0229ULL, 0x000000256c2b7212ULL, 0x000fc400078efcffULL,
0x0000006fae6a7210ULL, 0x000fe20007fbe0ffULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x0000002bae6c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000068237faeULL, 0x0007e2000c101c46ULL,
0x00000021802b7211ULL, 0x000fe200078e20ffULL, 0x00000001af6b7824ULL, 0x000fe200028e066bULL,
0x000000256e257212ULL, 0x000fe200078efcffULL, 0x0000001076737824ULL, 0x104fe200078e0221ULL,
0x000000722900720cULL, 0x000fe20003fa6070ULL, 0x000000107e297824ULL, 0x000fe200078e0221ULL,
0x0000006daf6d7210ULL, 0x000fc400017fe4ffULL, 0x00000025ae6e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001074257824ULL, 0x000fe200078e0221ULL, 0x0000002178217211ULL, 0x000fe200078e20ffULL,
0x0000000070297faeULL, 0x0007e4000c901c46ULL, 0x00000001af6f7824ULL, 0x000fe400010e066fULL,
0x000000007a2b7faeULL, 0x0007e8000f101c46ULL, 0x000000006a257faeULL, 0x0007e8000e101c46ULL,
0x000000006c737faeULL, 0x0007e8000d901c46ULL, 0x000000006e217faeULL, 0x0007e2000e901c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000417297836ULL, 0x000fe20000000000ULL,
0x0000000817687210ULL, 0x000fe20007ffe0ffULL, 0x0000000c176f7836ULL, 0x000fe20000000000ULL,
0x00000008176d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001292b7824ULL, 0x140fe200078e0208ULL,
0x00000007236a7812ULL, 0x000fe200078ef868ULL, 0x00000008296c7824ULL, 0x000fe200078e00ffULL,
0x000000036d6e7819ULL, 0x000fe200000006ffULL, 0x000000086f707824ULL, 0x000fe200078e00ffULL,
0x0000001017717810ULL, 0x000fe20007ffe0ffULL, 0x000000016d237824ULL, 0x100fe200078e0208ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee22bULL, 0x000000016f2b7824ULL, 0x100fe200078e0208ULL,
0x0000000371727819ULL, 0x040fe200000006ffULL, 0x0000001417737836ULL, 0x000fe20000000000ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee223ULL, 0x0000000171237824ULL, 0x100fe200078e0208ULL,
0xfffffff870707812ULL, 0x000fe200078ee22bULL, 0x00000001732b7824ULL, 0x140fe200078e0208ULL,
0x0000001817757810ULL, 0x000fe20007ffe0ffULL, 0x0000000873747824ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee223ULL, 0x0000001c17787836ULL, 0x000fe20000000000ULL,
0x0000000375767819ULL, 0x040fe200000006ffULL, 0x0000000175237824ULL, 0x100fe200078e0208ULL,
0xfffffff874747812ULL, 0x000fe200078ee22bULL, 0x00000001782b7824ULL, 0x140fe200078e0208ULL,
0x0000002017797810ULL, 0x000fe20007ffe0ffULL, 0x00000008787a7824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee223ULL, 0x00000024177b7836ULL, 0x000fe20000000000ULL,
0x00000003797c7819ULL, 0x040fe200000006ffULL, 0x0000000179237824ULL, 0x100fe200078e0208ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee22bULL, 0x000000017b2b7824ULL, 0x140fe200078e0208ULL,
0x00000028177d7810ULL, 0x000fe20007ffe0ffULL, 0x000000087b7e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee223ULL, 0x0000002c177f7836ULL, 0x000fe20000000000ULL,
0x000000037d807819ULL, 0x040fe200000006ffULL, 0x000000017d237824ULL, 0x100fe200078e0208ULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee22bULL, 0x000000017f2b7824ULL, 0x140fe200078e0208ULL,
0x0000003017817810ULL, 0x000fe20007ffe0ffULL, 0x000000087f827824ULL, 0x000fe200078e00ffULL,
0x000000170d687210ULL, 0x000fe20007ffe0ffULL, 0x0000003417837836ULL, 0x000fe20000000000ULL,
0xfffffff880807812ULL, 0x000fe200078ee223ULL, 0x0000000181237824ULL, 0x100fe200078e0208ULL,
0xfffffff882827812ULL, 0x000fe200078ee22bULL, 0x00000001832b7824ULL, 0x000fe200078e0208ULL,
0x0000000381847819ULL, 0x000fe200000006ffULL, 0x0000000883867824ULL, 0x000fe200078e00ffULL,
0x00000021728d7211ULL, 0x000fe200078e20ffULL, 0x0000010068687825ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fc400078ee223ULL, 0xfffffff886867812ULL, 0x000fe200078ee22bULL,
0x0000003817857836ULL, 0x000fe20000000000ULL, 0x000000217a937211ULL, 0x080fe200078e20ffULL,
0x0000003c17877836ULL, 0x000fe20000000000ULL, 0x00000021809d7211ULL, 0x000fe200078e20ffULL,
0x000000010d6b7824ULL, 0x000fe200078e0229ULL, 0x0000002568297212ULL, 0x000fe200078efcffULL,
0x0000000885887824ULL, 0x000fe200078e00ffULL, 0x0000000885237210ULL, 0x000fe20007ffe0ffULL,
0x00000001872b7824ULL, 0x040fe200078e0208ULL, 0x00000003878a7819ULL, 0x000fe200000006ffULL,
0x000000010d6d7824ULL, 0x040fe200078e026dULL, 0x00000029ae687210ULL, 0x000fe20007f1e0ffULL,
0x000000010d737824ULL, 0x040fe200078e0273ULL, 0xfffffff888887812ULL, 0x000fe200078ee223ULL,
0x000000010d717824ULL, 0x000fe200078e0271ULL, 0xfffffff88a8a7812ULL, 0x000fe200078ee22bULL,
0x000000106a237824ULL, 0x000fe200078e0221ULL, 0x000000216c297211ULL, 0x080fe200078e20ffULL,
0x000001006d6c7825ULL, 0x000fe200078e00ffULL, 0x0000002186a37211ULL, 0x000fc400078e20ffULL,
0x000000750d757210ULL, 0x000fe20007ffe0ffULL, 0x000000106e897824ULL, 0x100fe200078e0221ULL,
0x00000069af697210ULL, 0x000fe200007fe4ffULL, 0x00000010708b7824ULL, 0x100fe200078e0221ULL,
0x000000790d797210ULL, 0x000fe20007ffe0ffULL, 0x00000010748f7824ULL, 0x100fe200078e0221ULL,
0x000000810d817210ULL, 0x000fe20007ffe0ffULL, 0x0000001076917824ULL, 0x100fe200078e0221ULL,
0x000000870d877210ULL, 0x000fe20007ffe0ffULL, 0x000000107c957824ULL, 0x100fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000068237faeULL, 0x0003e2000b901c46ULL,
0x000000107e977824ULL, 0x000fc400078e0221ULL, 0x00000010829f7824ULL, 0x100fe400078e0221ULL,
0x0000001084a17824ULL, 0x100fe400078e0221ULL, 0x0000001088a77824ULL, 0x100fe400078e0221ULL,
0x000000108aa97824ULL, 0x000fe200078e0221ULL, 0x000000256c217212ULL, 0x000fe200078efcffULL,
0x0000010073727825ULL, 0x000fc600078e00ffULL, 0x00000021ae6c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010071707825ULL, 0x000fe200078e00ffULL, 0x0000002572217212ULL, 0x000fc600078efcffULL,
0x0000010075747825ULL, 0x000fe200078e00ffULL, 0x0000002570777212ULL, 0x000fc600078efcffULL,
0x000000010d767824ULL, 0x000fe200078e0278ULL, 0x00000077ae707210ULL, 0x000fe20007f5e0ffULL,
0x00000001af6d7824ULL, 0x000fe200000e066dULL, 0x00000021ae727210ULL, 0x000fe20007f1e0ffULL,
0x000000010d7d7824ULL, 0x000fe200078e027dULL, 0x0000002574217212ULL, 0x000fe200078efcffULL,
0x0000010076767825ULL, 0x000fe200078e00ffULL, 0x00000071af717210ULL, 0x000fc600017fe4ffULL,
0x000000010d7b7824ULL, 0x000fe400078e027bULL, 0x000001007d7c7825ULL, 0x000fc800078e00ffULL,
0x00000001af737824ULL, 0x000fe200000e0673ULL, 0x00000021ae747210ULL, 0x000fe20007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e00ffULL, 0x0000002576217212ULL, 0x080fe400078efcffULL,
0x00000075af757210ULL, 0x000fe200007fe4ffULL, 0x000000010d6f7824ULL, 0x000fe200078e026fULL,
0x000000256a2b7212ULL, 0x080fe200078efcffULL, 0x000001007b7a7825ULL, 0x000fe200078e00ffULL,
0x00000021ae767210ULL, 0x000fe40007f1e0ffULL, 0x0000002bae6a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010d7e7824ULL, 0x000fe200078e027fULL, 0x000000257c7f7212ULL, 0x080fe200078efcffULL,
0x000001006f6e7825ULL, 0x000fe200078e00ffULL, 0x000000257a217212ULL, 0x000fc400078efcffULL,
0x0000007fae7c7210ULL, 0x000fe20007f5e0ffULL, 0x000001007e7e7825ULL, 0x000fe200078e00ffULL,
0x000000256e2b7212ULL, 0x080fe400078efcffULL, 0x0000006baf6b7210ULL, 0x000fe20000ffe4ffULL,
0x00000001af777824ULL, 0x000fe200000e0677ULL, 0x00000021ae7a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010079787825ULL, 0x000fe200078e00ffULL, 0x000000257e217212ULL, 0x080fe200078efcffULL,
0x000000006a297faeULL, 0x0003e2000b901c46ULL, 0x0000002bae6e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010d837824ULL, 0x040fe200078e0283ULL, 0x00000025782b7212ULL, 0x000fe200078efcffULL,
0x000000010d857824ULL, 0x000fe200078e0285ULL, 0x000000006c897faeULL, 0x0003e2000b901c46ULL,
0x0000010081807825ULL, 0x000fc800078e00ffULL, 0x00000001af7b7824ULL, 0x000fe200000e067bULL,
0x00000021ae7e7210ULL, 0x000fe20007f1e0ffULL, 0x0000010083827825ULL, 0x000fe200078e00ffULL,
0x0000002580217212ULL, 0x000fc600078efcffULL, 0x0000010085847825ULL, 0x000fc800078e00ffULL,
0x0000010087867825ULL, 0x000fe200078e00ffULL, 0x0000002584a57212ULL, 0x000fc600078efcffULL,
0x00000001af6f7824ULL, 0x040fe200008e066fULL, 0x0000002bae787210ULL, 0x000fe20007f3e0ffULL,
0x00000001af7f7824ULL, 0x040fe200000e067fULL, 0x00000025822b7212ULL, 0x080fe200078efcffULL,
0x00000001af7d7824ULL, 0x040fe200010e067dULL, 0x0000002586257212ULL, 0x000fe200078efcffULL,
0x000000006e8b7faeULL, 0x0003e2000b901c46ULL, 0x00000021ae807210ULL, 0x000fe40007f1e0ffULL,
0x00000079af797210ULL, 0x000fe20000ffe4ffULL, 0x00000000708d7faeULL, 0x0003e2000b901c46ULL,
0x0000002bae827210ULL, 0x000fe20007f3e0ffULL, 0x00000001af817824ULL, 0x000fe200000e0681ULL,
0x000000a5ae847210ULL, 0x000fe20007f5e0ffULL, 0x00000000728f7faeULL, 0x0003e2000b901c46ULL,
0x00000025ae867210ULL, 0x000fc40007f7e0ffULL, 0x00000083af837210ULL, 0x000fe20000ffe4ffULL,
0x0000000074917faeULL, 0x0003e2000b901c46ULL, 0x00000001af857824ULL, 0x040fe400010e0685ULL,
0x00000001af877824ULL, 0x000fe200018e0687ULL, 0x0000000076937faeULL, 0x0003e8000b901c46ULL,
0x0000000078957faeULL, 0x0003e8000b901c46ULL, 0x000000007a977faeULL, 0x0003e8000b901c46ULL,
0x000000007c9d7faeULL, 0x0003e8000b901c46ULL, 0x000000007e9f7faeULL, 0x0003e8000b901c46ULL,
0x0000000080a17faeULL, 0x0003e8000b901c46ULL, 0x0000000082a37faeULL, 0x0003e8000b901c46ULL,
0x0000000084a77faeULL, 0x0003e8000b901c46ULL, 0x0000000086a97faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016687824ULL, 0x00afe200078e00ffULL,
0x0000000818217810ULL, 0x000fe20007ffe0ffULL, 0x000000081a237836ULL, 0x000fe20000000000ULL,
0x00000004196a7819ULL, 0x000fe200000006ffULL, 0x00000010a8707824ULL, 0x100fe200078e0213ULL,
0xfffffff068217812ULL, 0x000fe200078ee221ULL, 0x00000010aa687824ULL, 0x100fe200078e0213ULL,
0xfffffff06a237812ULL, 0x000fe200078ee223ULL, 0x00000010a4787824ULL, 0x100fe200078e0213ULL,
0x00000013a6747211ULL, 0x080fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e020aULL,
0x0000000a23237211ULL, 0x000fe200078e20ffULL, 0x0000001019827824ULL, 0x000fe200078e00ffULL,
0x0000000a1a297810ULL, 0x000fe20007ffe0ffULL, 0x0000000a18257836ULL, 0x000fe20000000000ULL,
0x000000139c907211ULL, 0x000fe200078e20ffULL, 0x0000001016807824ULL, 0x000fe200078e00ffULL,
0xfffffff082297812ULL, 0x000fe200078ee229ULL, 0x00000010a0887824ULL, 0x000fc400078e0213ULL,
0x000000109e8c7824ULL, 0x100fe200078e0213ULL, 0xfffffff080257812ULL, 0x000fe200078ee225ULL,
0x00000010a2807824ULL, 0x000fe200078e0213ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006868783bULL, 0x000fe20000000200ULL, 0x0000000a25257211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x000fe400078e020aULL, 0x00000000216c783bULL, 0x0002a20000000200ULL,
0x000000102a2a7824ULL, 0x000fc600078e0213ULL, 0x00000000237c783bULL, 0x000ee80000000200ULL,
0x000000007070783bULL, 0x000f220000000200ULL, 0x0000000c18217836ULL, 0x002fe40000000000ULL,
0x0000000e18187836ULL, 0x000fe20000000000ULL, 0x000000007474783bULL, 0x000e680000000200ULL,
0x000000007878783bULL, 0x000f680000000200ULL, 0x000000008080783bULL, 0x000fe80000000200ULL,
0x000000002584783bULL, 0x0004680000000200ULL, 0x000000008888783bULL, 0x000e680000000200ULL,
0x000000008c8c783bULL, 0x000e620000000200ULL, 0x0000001019257824ULL, 0x004fc400078e00ffULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x000000009090783bULL, 0x000ea80000000200ULL,
0x000000002994783bULL, 0x0008a20000000200ULL, 0x000000686c98723cULL, 0x000fec0000001898ULL,
0x000000687c2c723cULL, 0x008fe2000000182cULL, 0x0000000416297819ULL, 0x010fc800000006ffULL,
0xfffffff029297812ULL, 0x000fe200078ee218ULL, 0x0000006a6c30723cULL, 0x000fe20000001830ULL,
0x0000000416687819ULL, 0x000fe400000006ffULL, 0x0000000a29297211ULL, 0x000fe400078e20ffULL,
0xfffffff068217812ULL, 0x000fe200078ee221ULL, 0x000000101c687824ULL, 0x000fe200078e0213ULL,
0x0000000c1a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000706c38723cULL, 0x000fe20000001838ULL,
0x0000000e1a1a7836ULL, 0x000fc40000000000ULL, 0xfffffff025257812ULL, 0x000fc600078ee21cULL,
0x000000726c3c723cULL, 0x000fe2000000183cULL, 0xfffffff019197812ULL, 0x000fe200078ee21aULL,
0x0000001025257824ULL, 0x000fc600078e020aULL, 0x0000000a19197211ULL, 0x000fe200078e20ffULL,
0x000000746c44723cULL, 0x002fec0000001844ULL, 0x000000766c48723cULL, 0x000fec0000001848ULL,
0x000000786c40723cULL, 0x020fec0000001840ULL, 0x0000007a6c4c723cULL, 0x000fec000000184cULL,
0x0000006a7c34723cULL, 0x000fe20000001834ULL, 0x00000010216c7824ULL, 0x000fe200078e020aULL,
0x000000006868783bULL, 0x000fe20000000200ULL, 0x000000101e217824ULL, 0x000fc600078e0213ULL,
0x000000707c50723cULL, 0x000fe20000001850ULL, 0x000000006c6c783bULL, 0x000e6a0000000200ULL,
0x000000727c54723cULL, 0x000fe20000001854ULL, 0x0000001020707824ULL, 0x000fca00078e0213ULL,
0x000000747c58723cULL, 0x000fe20000001858ULL, 0x000000007070783bULL, 0x000fea0000000200ULL,
0x000000767c5c723cULL, 0x000fe2000000185cULL, 0x0000001322747211ULL, 0x000fe400078e20ffULL,
0x000000002120783bULL, 0x000ee60000000200ULL, 0x000000787c60723cULL, 0x000fe20000001860ULL,
0x000000007474783bULL, 0x000f2a0000000200ULL, 0x0000007a7c64723cULL, 0x000fe20000001864ULL,
0x000000002578783bULL, 0x000f6a0000000200ULL, 0x000000808498723cULL, 0x000fe20000001898ULL,
0x00000010247c7824ULL, 0x000fca00078e0213ULL, 0x000000828430723cULL, 0x000fe20000001830ULL,
0x000000007c7c783bULL, 0x000fea0000000200ULL, 0x000000888438723cULL, 0x000fec0000001838ULL,
0x0000008a843c723cULL, 0x000fec000000183cULL, 0x0000008c8444723cULL, 0x000fec0000001844ULL,
0x0000008e8448723cULL, 0x000fec0000001848ULL, 0x000000908440723cULL, 0x004fec0000001840ULL,
0x00000092844c723cULL, 0x000fec000000184cULL, 0x00000080942c723cULL, 0x000fe2000000182cULL,
0x0000001326847211ULL, 0x000fca00078e20ffULL, 0x000000829434723cULL, 0x000fe20000001834ULL,
0x000000008484783bULL, 0x000fe80000000200ULL, 0x000000002980783bULL, 0x000ea20000000200ULL,
0x000000889450723cULL, 0x000fec0000001850ULL, 0x0000008a9454723cULL, 0x000fe20000001854ULL,
0x0000001028887824ULL, 0x000fc400078e0213ULL, 0x000000002a28783bULL, 0x000fe60000000200ULL,
0x0000008c9458723cULL, 0x000fe20000001858ULL, 0x000000008888783bULL, 0x000eaa0000000200ULL,
0x0000008e945c723cULL, 0x000fe2000000185cULL, 0x00000000198c783bULL, 0x000eaa0000000200ULL,
0x000000909460723cULL, 0x000fec0000001860ULL, 0x000000929464723cULL, 0x000fec0000001864ULL,
0x000000686c98723cULL, 0x002fec0000001898ULL, 0x0000006a6c30723cULL, 0x000fec0000001830ULL,
0x000000206c38723cULL, 0x008fec0000001838ULL, 0x000000226c3c723cULL, 0x000fec000000183cULL,
0x000000746c44723cULL, 0x010fec0000001844ULL, 0x000000766c48723cULL, 0x000fec0000001848ULL,
0x000000706c40723cULL, 0x000fec0000001840ULL, 0x000000726c4c723cULL, 0x000fec000000184cULL,
0x00000068782c723cULL, 0x020fec000000182cULL, 0x0000006a7834723cULL, 0x000fec0000001834ULL,
0x000000207850723cULL, 0x000fec0000001850ULL, 0x000000227854723cULL, 0x000fec0000001854ULL,
0x000000747858723cULL, 0x000fe20000001858ULL, 0x00000001ff227424ULL, 0x000fca00078e00ffULL,
0x00000076785c723cULL, 0x000fe2000000185cULL, 0x01e688221d2279a7ULL, 0x000e6a000850003fULL,
0x000000707860723cULL, 0x000fec0000001860ULL, 0x000000727864723cULL, 0x000fec0000001864ULL,
0x0000007c8098723cULL, 0x004fec0000001898ULL, 0x0000007e8030723cULL, 0x000fec0000001830ULL,
0x000000848038723cULL, 0x000fec0000001838ULL, 0x00000086803c723cULL, 0x000fec000000183cULL,
0x000000888044723cULL, 0x000fe20000001844ULL, 0x3db504f398697820ULL, 0x000fe20000410000ULL,
0x3db504f399997820ULL, 0x000fe20000410000ULL, 0x3db504f39a9a7820ULL, 0x000fe20000410000ULL,
0x3db504f39b9b7820ULL, 0x000fc40000410000ULL, 0x0000008a8048723cULL, 0x000fe20000001848ULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fe40000410000ULL,
0x000000288040723cULL, 0x000fe20000001840ULL, 0x3db504f338387820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x0000002a804c723cULL, 0x000fe2000000184cULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33e3e7820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fe40000410000ULL,
0x0000007c8c2c723cULL, 0x000fe2000000182cULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0x3db504f345457820ULL, 0x000fe20000410000ULL, 0x3db504f346467820ULL, 0x000fe20000410000ULL,
0x3db504f347477820ULL, 0x000fc40000410000ULL, 0x0000007e8c34723cULL, 0x000fe20000001834ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x3db504f34a4a7820ULL, 0x000fe20000410000ULL, 0x3db504f34b4b7820ULL, 0x000fe40000410000ULL,
0x000000848c50723cULL, 0x000fe20000001850ULL, 0x3db504f340407820ULL, 0x000fe20000410000ULL,
0x3db504f341417820ULL, 0x000fe20000410000ULL, 0x3db504f342427820ULL, 0x000fe20000410000ULL,
0x3db504f343437820ULL, 0x000fc40000410000ULL, 0x000000868c54723cULL, 0x000fe20000001854ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe40000410000ULL,
0x000000888c58723cULL, 0x000fe20000001858ULL, 0x3db504f32c6b7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fc40000410000ULL, 0x0000008a8c5c723cULL, 0x000fe2000000185cULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fe40000410000ULL,
0x000000288c60723cULL, 0x000fe20000001860ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fc40000410000ULL, 0x0000002a8c64723cULL, 0x000fe20000001864ULL,
0x3db504f354547820ULL, 0x000fe20000410000ULL, 0x3db504f355557820ULL, 0x000fe20000410000ULL,
0x3db504f356567820ULL, 0x000fe20000410000ULL, 0x3db504f357577820ULL, 0x000fe40000410000ULL,
0x3db504f358587820ULL, 0x000fe20000410000ULL, 0x3db504f359597820ULL, 0x000fe20000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b5b7820ULL, 0x000fc60000410000ULL,
0x3db504f35c5c7820ULL, 0x000fe20000410000ULL, 0x3db504f35d5d7820ULL, 0x000fe20000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe20000410000ULL, 0x3db504f35f5f7820ULL, 0x000fc60000410000ULL,
0x3db504f360607820ULL, 0x000fe20000410000ULL, 0x3db504f361617820ULL, 0x000fe20000410000ULL,
0x3db504f362627820ULL, 0x000fe20000410000ULL, 0x3db504f363637820ULL, 0x000fc60000410000ULL,
0x3db504f364647820ULL, 0x000fe20000410000ULL, 0x3db504f365657820ULL, 0x000fe20000410000ULL,
0x3db504f366667820ULL, 0x000fe20000410000ULL, 0x3db504f367677820ULL, 0x000fe20000410000ULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x01e688231d0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002018167210ULL, 0x000fc80007f1e1ffULL,
0x0000002119207210ULL, 0x000fe400007fe5ffULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011420ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0620ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01e688231d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000208137819ULL, 0x000fe200000006ffULL, 0x0000008003167824ULL, 0x000fe200078e020aULL,
0x000000020500720cULL, 0x000fe40003f06070ULL, 0xfffffff013137812ULL, 0x000fca00078ec0ffULL,
0x0000000116137824ULL, 0x000fca00078e0213ULL, 0x01e4000013207984ULL, 0x0002a20000000c00ULL,
0x0000002000608947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x0000000400167d06ULL, 0x000ee20008209000ULL,
0x0000000408057211ULL, 0x000fca00078ff0ffULL, 0x00000010051a7836ULL, 0x000fe40000000000ULL,
0x0000001600167308ULL, 0x008ee40000001000ULL, 0x0ffffffe161c7810ULL, 0x008fcc0007ffe0ffULL,
0x0000001c00197305ULL, 0x000724000021f000ULL, 0x00000018051c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x010fc800078e0a19ULL, 0x0000000425257c24ULL, 0x000fc8000f8e02ffULL,
0x0000002519297227ULL, 0x000fe200078e0018ULL, 0x0000000805187810ULL, 0x000fca0007ffe0ffULL,
0x0000001829197227ULL, 0x000fc800078e00ffULL, 0x0000000529167227ULL, 0x000fc800078e00ffULL,
0x000000ffff257224ULL, 0x000fe400078e0a19ULL, 0x000000ffff267224ULL, 0x000fe400078e0a16ULL,
0x0000000425187c24ULL, 0x000fe4000f8e0218ULL, 0x0000000426057c24ULL, 0x000fe4000f8e0205ULL,
0x0000001a291e7227ULL, 0x000fe200078e00ffULL, 0x0000000418007c0cULL, 0x000fe4000bf06070ULL,
0x0000000405007c0cULL, 0x000fe2000bfa6070ULL, 0x0000001c29247227ULL, 0x000fc800078e00ffULL,
0x000000ffff257224ULL, 0x000fe200078e0a1eULL, 0x000000ff24297210ULL, 0x000fc60007ffe1ffULL,
0x00000004251a7c24ULL, 0x000fe2000f8e021aULL, 0x0000001409257248ULL, 0x000fe20007fe0000ULL,
0x00000004291c7c24ULL, 0x000fe2000f8e021cULL, 0x00000004ff297c12ULL, 0x000fe2000f8e33ffULL,
0x8000000418180c36ULL, 0x000fe20008000000ULL, 0x000000041a007c0cULL, 0x000fe2000bf46070ULL,
0x8000000405055c36ULL, 0x000fe20008000000ULL, 0x000000041c007c0cULL, 0x000fe2000bf66070ULL,
0x0000000119190836ULL, 0x000fe20000000000ULL, 0x0000000418007c0cULL, 0x000fe4000bfc6070ULL,
0x0000000405007c0cULL, 0x000fc4000bf86070ULL, 0x0000000108057819ULL, 0x000fe400000006ffULL,
0x0000000116165810ULL, 0x000fe40007ffe0ffULL, 0x0000002514147210ULL, 0x000fe20007ffe1ffULL,
0x800000041a1a2c36ULL, 0x000fe20008000000ULL, 0x0000000605057812ULL, 0x000fe200078ec0ffULL,
0x800000041c1c3c36ULL, 0x000fe20008000000ULL, 0x0000000124243810ULL, 0x000fe20007ffe0ffULL,
0x0000000119196836ULL, 0x000fe20000000000ULL, 0x000000041a007c0cULL, 0x000fe2000bf26070ULL,
0x0000000116164836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x000000ffff7a7224ULL, 0x000fe200078e0a14ULL, 0x0000000511187210ULL, 0x000fe20007ffe0ffULL,
0x0000000105717824ULL, 0x000fe200078e020eULL, 0x000000041c007c0cULL, 0x000fe2000bf06070ULL,
0x000000011e1e2836ULL, 0x000fe20000000000ULL, 0x0000001629167207ULL, 0x000fc40007000000ULL,
0x000000141800720cULL, 0x080fe40003fa6070ULL, 0x0000007a18187246ULL, 0x000fe2000380000fULL,
0x000000011e1e1836ULL, 0x000fe20000000000ULL, 0x000000160f167248ULL, 0x000fe40003fe0000ULL,
0x000000147100720cULL, 0x000fe40003f86070ULL, 0x0000007a716a7246ULL, 0x000fe2000380000fULL,
0x0000000516937c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff187819ULL, 0x000fe20000011618ULL,
0x0000000124240836ULL, 0x000fe20000000000ULL, 0x000000ff6a6a7207ULL, 0x000fc40002000000ULL,
0x000000ff181c7207ULL, 0x000fe40002800000ULL, 0x00000019291a7207ULL, 0x040fe40007000000ULL,
0x0000001e291e7207ULL, 0x000fe40007000000ULL, 0x0000001c93257210ULL, 0x000fe40007ffe0ffULL,
0x000000936a197211ULL, 0x000fe400078fe0ffULL, 0x0000001a0f1a7248ULL, 0x000fc40003fe0000ULL,
0x0000002429167207ULL, 0x000fe20007000000ULL, 0x0000000225247825ULL, 0x000fe200078e00acULL,
0x0000001e0f1e7248ULL, 0x000fc60003fe0000ULL, 0x0000000219187825ULL, 0x000fc800078e00acULL,
0x000000051a957c24ULL, 0x000fe2000f8e02ffULL, 0x000000160f1a7248ULL, 0x000fe20003fe0000ULL,
0x000000051e977c24ULL, 0x000fe2000f8e02ffULL, 0x0000000624167981ULL, 0x000722000c1e9500ULL,
0x000000011c2b7824ULL, 0x000fc600078e0295ULL, 0x0000000618737981ULL, 0x000f22000c1e9500ULL,
0x000000051a9d7c24ULL, 0x000fe2000f8e02ffULL, 0x000000956a297211ULL, 0x000fe200078fe0ffULL,
0x000000011c6d7824ULL, 0x000fe200078e0297ULL, 0x000000976a6f7211ULL, 0x040fe200078fe0ffULL,
0x000000022b2a7825ULL, 0x100fe200078e00acULL, 0x0000001005797812ULL, 0x000fe400078efcffULL,
0x0000009d1c777210ULL, 0x000fe20007ffe0ffULL, 0x0000000229287825ULL, 0x100fe200078e00acULL,
0x0000009d6a757211ULL, 0x000fe200078fe0ffULL, 0x000000062a1a7981ULL, 0x000b24000c1e9500ULL,
0x000000026d6c7825ULL, 0x000fc800078e00acULL, 0x000000026f247825ULL, 0x008fe200078e00acULL,
0x000000066c1c7981ULL, 0x000ee6000c1e9500ULL, 0x0000000111267824ULL, 0x000fe400078e0279ULL,
0x00000002776e7825ULL, 0x100fe400078e00acULL, 0x0000000624777981ULL, 0x000ee2000c1e9500ULL,
0x0000007a262a7246ULL, 0x024fe2000380000fULL, 0x0000000275187825ULL, 0x002fc400078e00acULL,
0x0000000628757981ULL, 0x0002a4000c1e9500ULL, 0x00000001797b7824ULL, 0x000fe200078e020eULL,
0x000000142600720cULL, 0x080fe20003f26070ULL, 0x000000066e1e7981ULL, 0x000f62000c1e9500ULL,
0x00000004ff2a7819ULL, 0x000fe4000001162aULL, 0x000000147b00720cULL, 0x000fe20003f06070ULL,
0x00000006187d7981ULL, 0x000362000c1e9500ULL, 0x0000007a7b747246ULL, 0x000fe4000380000fULL,
0x000000ff2a287207ULL, 0x002fc40000800000ULL, 0x000000ff74747207ULL, 0x000fc60000000000ULL,
0x00000001282b7824ULL, 0x000fe200078e0295ULL, 0x0000009374197211ULL, 0x040fe400078fe0ffULL,
0x0000002893257210ULL, 0x000fe20007ffe0ffULL, 0x000000022b2a7825ULL, 0x100fe200078e00acULL,
0x0000009574297211ULL, 0x040fe400078fe0ffULL, 0x0000002005857812ULL, 0x000fe200078efcffULL,
0x0000000219187825ULL, 0x000fe200078e00acULL, 0x0000009d28837210ULL, 0x000fe20007ffe0ffULL,
0x000000062a2c7981ULL, 0x000362000c1e9500ULL, 0x0000009d74817211ULL, 0x000fe200078fe0ffULL,
0x00000001286f7824ULL, 0x000fc400078e0297ULL, 0x0000000225247825ULL, 0x100fe200078e00acULL,
0x00000006187f7981ULL, 0x000366000c1e9500ULL, 0x0000000229287825ULL, 0x000fe200078e00acULL,
0x0000000624267981ULL, 0x000f66000c1e9500ULL, 0x00000001112a7824ULL, 0x002fe400078e0285ULL,
0x0000000281187825ULL, 0x000fc400078e00acULL, 0x0000000628817981ULL, 0x000362000c1e9500ULL,
0x0000007a2a2b7246ULL, 0x000fe2000380000fULL, 0x0000000185877824ULL, 0x000fe200078e020eULL,
0x00000097746d7211ULL, 0x000fe200078fe0ffULL, 0x000000026f6e7825ULL, 0x000fe200078e00acULL,
0x000000142a00720cULL, 0x080fe20003f26070ULL, 0x0000000618897981ULL, 0x000f62000c1e9500ULL,
0x00000004ff2b7819ULL, 0x000fe2000001162bULL, 0x000000026d6c7825ULL, 0x100fe200078e00acULL,
0x000000148700720cULL, 0x000fe20003f06070ULL, 0x000000066e687981ULL, 0x000f62000c1e9500ULL,
0x0000007a87287246ULL, 0x002fe2000380000fULL, 0x0000000283247825ULL, 0x000fe200078e00acULL,
0x000000ff2b2a7207ULL, 0x000fe20000800000ULL, 0x000000066c837981ULL, 0x000362000c1e9500ULL,
0x000000ff28787207ULL, 0x000fc60000000000ULL, 0x0000000624707981ULL, 0x000362000c1e9500ULL,
0x000000012a8b7824ULL, 0x000fe200078e0295ULL, 0x00000095786d7211ULL, 0x002fc600078fe0ffULL,
0x000000028b8a7825ULL, 0x000fe200078e00acULL, 0x0000002a93197210ULL, 0x000fc60007ffe0ffULL,
0x000000026d6c7825ULL, 0x100fe400078e00acULL, 0x000000068a8a7981ULL, 0x000362000c1e9500ULL,
0x00000093786f7211ULL, 0x040fe200078fe0ffULL, 0x0000000219187825ULL, 0x000fe200078e00acULL,
0x0000009d788f7211ULL, 0x040fe400078fe0ffULL, 0x0000009778297211ULL, 0x000fe200078fe0ffULL,
0x000000012a2b7824ULL, 0x000fe200078e0297ULL, 0x0000009d2a257210ULL, 0x000fe20007ffe0ffULL,
0x0000000618727981ULL, 0x000368000c1e9500ULL, 0x000000066c8b7981ULL, 0x002f62000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fc800078e00acULL, 0x000000028f187825ULL, 0x100fe200078e00acULL,
0x00000030058f7812ULL, 0x000fe200078efcffULL, 0x000000066e8d7981ULL, 0x000364000c1e9500ULL,
0x000000022b2a7825ULL, 0x100fe400078e00acULL, 0x0000000618e57981ULL, 0x000f64000c1e9500ULL,
0x0000000229287825ULL, 0x100fe400078e00acULL, 0x000000062a767981ULL, 0x000364000c1e9500ULL,
0x0000000225247825ULL, 0x000fc400078e00acULL, 0x0000000628e17981ULL, 0x000364000c1e9500ULL,
0x00000001116e7824ULL, 0x002fe400078e028fULL, 0x0000000624867981ULL, 0x000362000c1e9500ULL,
0x000000018f917824ULL, 0x000fe400078e020eULL, 0x0000007a6e6f7246ULL, 0x000fe4000380000fULL,
0x000000146e00720cULL, 0x080fe40003f26070ULL, 0x000000149100720cULL, 0x000fc40003f06070ULL,
0x00000004ff6f7819ULL, 0x000fe4000001166fULL, 0x0000007a912a7246ULL, 0x000fe4000380000fULL,
0x000000ff6f7c7207ULL, 0x000fe40000800000ULL, 0x000000ff2a7a7207ULL, 0x000fe40000000000ULL,
0x0000007c936d7210ULL, 0x000fe20007ffe0ffULL, 0x000000017c297824ULL, 0x000fe200078e0297ULL,
0x000000937a6f7211ULL, 0x000fc400078fe0ffULL, 0x000000977a2b7211ULL, 0x000fe200078fe0ffULL,
0x000000026d6c7825ULL, 0x000fc800078e00acULL, 0x000000026f6e7825ULL, 0x100fe200078e00acULL,
0x000000066c7e7981ULL, 0x000366000c1e9500ULL, 0x0000000229287825ULL, 0x100fe200078e00acULL,
0x000000066ec97981ULL, 0x000366000c1e9500ULL, 0x000000022b2a7825ULL, 0x000fe200078e00acULL,
0x0000000628847981ULL, 0x000f62000c1e9500ULL, 0x000000957a257211ULL, 0x002fc600078fe0ffULL,
0x000000062ae37981ULL, 0x000f62000c1e9500ULL, 0x000000017c197824ULL, 0x000fe400078e0295ULL,
0x0000000225247825ULL, 0x000fc800078e00acULL, 0x0000000219187825ULL, 0x000fe200078e00acULL,
0x0000000624df7981ULL, 0x000f62000c1e9500ULL, 0x0000009d7a6d7211ULL, 0x000fc600078fe0ffULL,
0x0000000618827981ULL, 0x000362000c1e9500ULL, 0x0000009d7c6f7210ULL, 0x000fe20007ffe0ffULL,
0x000000026d6c7825ULL, 0x000fc800078e00acULL, 0x000000026f6e7825ULL, 0x000fe200078e00acULL,
0x000000066ce77981ULL, 0x000f68000c1e9500ULL, 0x000000066e887981ULL, 0x000364000c1e9500ULL,
0xfffffff06a197812ULL, 0x002fe200078ec0ffULL, 0x00000001ffdd7424ULL, 0x000fc800078e00ffULL,
0x0000000114187824ULL, 0x000fe200078e0219ULL, 0x0000000105937812ULL, 0x000fc800078efcffULL,
0x8000001871197210ULL, 0x000fc80007ffe0ffULL, 0x00000019dd197219ULL, 0x000fe200000006ffULL,
0x0000000193257824ULL, 0x000fe200078e020eULL, 0xfffffff074297812ULL, 0x000fc600078ec0ffULL,
0x0000000125247824ULL, 0x000fe200078e0a18ULL, 0x0000000805957812ULL, 0x040fe200078efcffULL,
0x00000001142a7824ULL, 0x000fe200078e0229ULL, 0x0000000905977812ULL, 0x000fe400078efcffULL,
0x00000024dd297219ULL, 0x000fe400000006ffULL, 0x0000000e952b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001976f7824ULL, 0x000fe200078e020eULL, 0xfffffff0786d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff07a9d7812ULL, 0x000fe200078ec0ffULL, 0x000000012b287824ULL, 0x000fe200078e0a18ULL,
0x0000006f18187210ULL, 0x000fe20007ffe1ffULL, 0x00000001146a7824ULL, 0x000fe200078e026dULL,
0x0000001105a17812ULL, 0x000fc400078efcffULL, 0x0000009d14787210ULL, 0x000fe40007ffe0ffULL,
0x00000028dd6d7219ULL, 0x040fe400000006ffULL, 0x00000018dd9d7219ULL, 0x000fe200000006ffULL,
0x00000001a1a37824ULL, 0x000fe400078e020eULL, 0x000000017b187824ULL, 0x100fe400078e0a2aULL,
0x00000001a3247824ULL, 0x000fe200078e0a2aULL, 0x0000001805a77812ULL, 0x000fc400078efcffULL,
0x0000001905af7812ULL, 0x000fe400078efcffULL, 0x00000018dd9f7219ULL, 0x040fe400000006ffULL,
0x00000024dda57219ULL, 0x000fe200000006ffULL, 0x00000001afb17824ULL, 0x000fe200078e020eULL,
0x0000000ea7a97210ULL, 0x000fe40007ffe0ffULL, 0x0000541073167816ULL, 0x010fc80000000016ULL,
0x0000001619ff7212ULL, 0x000fc800078ac0ffULL, 0x000000147100720cULL, 0x000fc80002fa1470ULL,
0x000000140500720cULL, 0x000fe40002fa1070ULL, 0x0000001629ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000069697808ULL, 0x000fe40002800000ULL, 0x00005410771c7816ULL, 0x008fe4000000001cULL,
0x00005410751a7816ULL, 0x004fe4000000001aULL, 0x0000001c19ff7212ULL, 0x000fc4000788c0ffULL,
0x0000001a19ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001a29ff7212ULL, 0x000fe400078ac0ffULL,
0x000000147100720cULL, 0x0c0fe40001741470ULL, 0x000000147100720cULL, 0x080fe40002781470ULL,
0x000000142500720cULL, 0x0c0fe40000f21470ULL, 0x000000142500720cULL, 0x000fc40002fa1470ULL,
0x000000140500720cULL, 0x0c0fe40001741070ULL, 0x000000140500720cULL, 0x080fe40002781070ULL,
0x000000149300720cULL, 0x0c0fe40000f21070ULL, 0x000000149300720cULL, 0x000fe40002fa1070ULL,
0x000054107d1e7816ULL, 0x020fe4000000001eULL, 0xff8000009a9a7808ULL, 0x000fc40001000000ULL,
0xff8000006b6b7808ULL, 0x000fe40002000000ULL, 0xff80000099997808ULL, 0x000fe40000800000ULL,
0xff8000009b9b7808ULL, 0x000fe40002800000ULL, 0x000000166dff7212ULL, 0x000fe4000786c0ffULL,
0x0000001e19ff7212ULL, 0x000fe4000780c0ffULL, 0x0000001c29ff7212ULL, 0x000fc4000784c0ffULL,
0x0000001e29ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001a9dff7212ULL, 0x000fe4000782c0ffULL,
0x0000001c6dff7212ULL, 0x000fe400078ac0ffULL, 0x000000147100720cULL, 0x080fe40000701470ULL,
0x000000142500720cULL, 0x0c0fe40001741470ULL, 0x000000142500720cULL, 0x000fc40002781470ULL,
0x000000142b00720cULL, 0x0c0fe40001f61470ULL, 0x000000142b00720cULL, 0x080fe40002fa1470ULL,
0x000000146f00720cULL, 0x080fe40000f21470ULL, 0x000000140500720cULL, 0x080fe40000701070ULL,
0x000000149300720cULL, 0x0c0fe40001741070ULL, 0x000000149300720cULL, 0x000fc40002781070ULL,
0x000000149500720cULL, 0x0c0fe40001f61070ULL, 0x000000149500720cULL, 0x080fe40002fa1070ULL,
0x000000149700720cULL, 0x000fe40000f21070ULL, 0x000054107f267816ULL, 0x000fe40000000026ULL,
0x00005410812c7816ULL, 0x000fe4000000002cULL, 0xff8000002e2e7808ULL, 0x000fc40000000000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0x0000001a6dff7212ULL, 0x000fc4000780c0ffULL,
0x0000001c9dff7212ULL, 0x000fe4000784c0ffULL, 0x0000001e6dff7212ULL, 0x080fe4000788c0ffULL,
0x0000001e9dff7212ULL, 0x000fe4000786c0ffULL, 0x00000026a5ff7212ULL, 0x000fe400078ac0ffULL,
0x0000002c9fff7212ULL, 0x000fe4000782c0ffULL, 0x000000a92a287210ULL, 0x000fe20007ffe1ffULL,
0x00000001b12a7824ULL, 0x000fe200078e0a2aULL, 0x000000142b00720cULL, 0x000fc40000701470ULL,
0x000000142b00720cULL, 0x080fe40002781470ULL, 0x000000146f00720cULL, 0x0c0fe40001741470ULL,
0x000000146f00720cULL, 0x080fe40001f61470ULL, 0x000000147b00720cULL, 0x080fe40000f21470ULL,
0x00000014a300720cULL, 0x080fe40002fa1470ULL, 0x000000149500720cULL, 0x000fc40000701070ULL,
0x000000149500720cULL, 0x080fe40002781070ULL, 0x000000149700720cULL, 0x0c0fe40001741070ULL,
0x000000149700720cULL, 0x080fe40001f61070ULL, 0x000000147900720cULL, 0x080fe40000f21070ULL,
0x00000014a100720cULL, 0x000fe40002fa1070ULL, 0x00000028ddab7219ULL, 0x000fc400000006ffULL,
0x0000002addb37219ULL, 0x000fe400000006ffULL, 0x0000541083687816ULL, 0x000fe40000000068ULL,
0x0000541089707816ULL, 0x000fe40000000070ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0xff80000035357808ULL, 0x000fc40001000000ULL,
0xff80000037377808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x000000269fff7212ULL, 0x080fe4000780c0ffULL,
0x00000026abff7212ULL, 0x000fe4000788c0ffULL, 0x000000689fff7212ULL, 0x000fc4000784c0ffULL,
0x000000709fff7212ULL, 0x000fe4000786c0ffULL, 0x00000068a5ff7212ULL, 0x000fe4000782c0ffULL,
0x0000002cb3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001876c7824ULL, 0x000fe200078e0a6aULL,
0x000000147b00720cULL, 0x0c0fe40000701470ULL, 0x000000147b00720cULL, 0x0c0fe40001741470ULL,
0x000000147b00720cULL, 0x000fc40001f61470ULL, 0x00000014a300720cULL, 0x080fe40000f21470ULL,
0x00000014a900720cULL, 0x080fe40002781470ULL, 0x00000014b100720cULL, 0x080fe40002fa1470ULL,
0x0000002105b77812ULL, 0x000fe400078efcffULL, 0x000000147900720cULL, 0x0c0fe40000701070ULL,
0x000000147900720cULL, 0x000fc40001741070ULL, 0x000000147900720cULL, 0x080fe40001f61070ULL,
0x00000014a100720cULL, 0x080fe40000f21070ULL, 0x00000014a700720cULL, 0x080fe40002781070ULL,
0x00000014af00720cULL, 0x000fe40002fa1070ULL, 0x0000006cddb57219ULL, 0x000fe400000006ffULL,
0x000054108b8a7816ULL, 0x000fe2000000008aULL, 0x00000001b7b97824ULL, 0x000fe200078e020eULL,
0xff80000038387808ULL, 0x000fc40000000000ULL, 0xff80000050507808ULL, 0x000fe40001000000ULL,
0xff80000052527808ULL, 0x000fe40001800000ULL, 0xff80000051517808ULL, 0x000fe40000800000ULL,
0xff8000003c3c7808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000002ca5ff7212ULL, 0x000fc4000780c0ffULL, 0x00000070a5ff7212ULL, 0x000fe4000784c0ffULL,
0x0000002cabff7212ULL, 0x000fe4000786c0ffULL, 0x00000068b3ff7212ULL, 0x040fe4000782c0ffULL,
0x00000070b3ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ab5ff7212ULL, 0x000fe400078ac0ffULL,
0x00000014a300720cULL, 0x000fc40000701470ULL, 0x00000014a300720cULL, 0x080fe40001741470ULL,
0x00000014a900720cULL, 0x080fe40001f61470ULL, 0x00000014b100720cULL, 0x0c0fe40000f21470ULL,
0x00000014b100720cULL, 0x080fe40002781470ULL, 0x000000148700720cULL, 0x000fe40002fa1470ULL,
0x000000b96a6e7210ULL, 0x000fc40007ffe1ffULL, 0x0000002805bd7812ULL, 0x040fe400078efcffULL,
0x0000002905c37812ULL, 0x000fe400078efcffULL, 0x00000014a100720cULL, 0x0c0fe40000701070ULL,
0x00000014a100720cULL, 0x080fe40001741070ULL, 0x00000014a700720cULL, 0x080fe40001f61070ULL,
0x00000014af00720cULL, 0x000fc40000f21070ULL, 0x00000014af00720cULL, 0x080fe40002781070ULL,
0x000000148500720cULL, 0x000fe40002fa1070ULL, 0x0000006eddbb7219ULL, 0x000fe400000006ffULL,
0x000054108d727816ULL, 0x000fe40000000072ULL, 0x00005410e1767816ULL, 0x000fe40000000076ULL,
0x00005410e5867816ULL, 0x000fc40000000086ULL, 0x0000000ebdbf7210ULL, 0x000fe20007ffe0ffULL,
0x00000001c3c57824ULL, 0x000fe200078e020eULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff80000057577808ULL, 0x000fc40002000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0x000000169dff7212ULL, 0x000fe400078cc0ffULL,
0x00000068abff7212ULL, 0x040fe4000780c0ffULL, 0x00000070abff7212ULL, 0x000fe4000784c0ffULL,
0x00000072b5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000076b5ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086b5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000076bbff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bf747824ULL, 0x100fe200078e0a6aULL, 0x000000146f00720cULL, 0x080fe200037c1470ULL,
0x00000001c56a7824ULL, 0x000fe200078e0a6aULL, 0x00000014a900720cULL, 0x0c0fe40000701470ULL,
0x00000014a900720cULL, 0x080fe40001741470ULL, 0x000000148700720cULL, 0x000fc40001f61470ULL,
0x000000148700720cULL, 0x0c0fe40000f21470ULL, 0x000000148700720cULL, 0x080fe40002781470ULL,
0x00000014b900720cULL, 0x080fe40002fa1470ULL, 0x000000149700720cULL, 0x080fe400037c1070ULL,
0x00000014a700720cULL, 0x0c0fe40000701070ULL, 0x00000014a700720cULL, 0x000fc40001741070ULL,
0x000000148500720cULL, 0x0c0fe40001f61070ULL, 0x000000148500720cULL, 0x0c0fe40000f21070ULL,
0x000000148500720cULL, 0x080fe40002781070ULL, 0x00000014b700720cULL, 0x000fe40002fa1070ULL,
0x00000074ddc17219ULL, 0x040fe400000006ffULL, 0x0000006addc77219ULL, 0x000fc400000006ffULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000054547808ULL, 0x000fe40000000000ULL,
0xff80000056567808ULL, 0x000fe40001000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000058587808ULL, 0x000fe40000800000ULL, 0xff8000005a5a7808ULL, 0x000fc40002000000ULL,
0xff80000059597808ULL, 0x000fe40002800000ULL, 0x00000026b3ff7212ULL, 0x000fe400078cc0ffULL,
0x00000072bbff7212ULL, 0x080fe4000780c0ffULL, 0x00000072c1ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008abbff7212ULL, 0x040fe4000786c0ffULL, 0x00000086bbff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ac1ff7212ULL, 0x000fe4000788c0ffULL, 0x00000076c7ff7212ULL, 0x000fe400078ac0ffULL,
0x00000014b100720cULL, 0x080fe400037c1470ULL, 0x00000014b900720cULL, 0x0c0fe40000701470ULL,
0x00000014b900720cULL, 0x0c0fe40001f61470ULL, 0x00000014b900720cULL, 0x000fc40000f21470ULL,
0x00000014bf00720cULL, 0x0c0fe40001741470ULL, 0x00000014bf00720cULL, 0x080fe40002781470ULL,
0x00000014c500720cULL, 0x000fe40002fa1470ULL, 0x80000078917a7210ULL, 0x000fe40007ffe0ffULL,
0x0000003105cd7812ULL, 0x040fe400078efcffULL, 0x0000003805d37812ULL, 0x000fc400078efcffULL,
0x0000003905d97812ULL, 0x000fe400078efcffULL, 0x00000014af00720cULL, 0x080fe400037c1070ULL,
0x00000014b700720cULL, 0x0c0fe40000701070ULL, 0x00000014b700720cULL, 0x0c0fe40001f61070ULL,
0x00000014b700720cULL, 0x080fe40000f21070ULL, 0x00000014bd00720cULL, 0x000fc40001741070ULL,
0x00000014bd00720cULL, 0x080fe40002781070ULL, 0x00000014c300720cULL, 0x000fe40002fa1070ULL,
0x0000007addcb7219ULL, 0x000fe400000006ffULL, 0x00005410c97e7816ULL, 0x000fe4000000007eULL,
0x00005410e3847816ULL, 0x000fe20000000084ULL, 0x00000001cdcf7824ULL, 0x100fe200078e020eULL,
0x0000000ed3d57210ULL, 0x000fe20007ffe0ffULL, 0x00000001d9db7824ULL, 0x000fe200078e020eULL,
0xff8000003d3d7808ULL, 0x000fc40003000000ULL, 0xff80000045457808ULL, 0x000fe40000000000ULL,
0xff80000047477808ULL, 0x000fe40001800000ULL, 0xff8000005b5b7808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fe40002000000ULL,
0xff8000005d5d7808ULL, 0x000fc40002800000ULL, 0x00000072c7ff7212ULL, 0x040fe400078cc0ffULL,
0x0000008ac7ff7212ULL, 0x000fe4000780c0ffULL, 0x00000076c1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000086c1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000086c7ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ecbff7212ULL, 0x000fc4000788c0ffULL, 0x00000084cbff7212ULL, 0x000fe200078ac0ffULL,
0x00000001cf7c7824ULL, 0x100fe200078e0a78ULL, 0x00000014bf00720cULL, 0x080fe20001f61470ULL,
0x00000001d5807824ULL, 0x000fe200078e0a78ULL, 0x00000014bf00720cULL, 0x080fe40000f21470ULL,
0x00000014c500720cULL, 0x0c0fe400037c1470ULL, 0x00000014c500720cULL, 0x0c0fe40000701470ULL,
0x00000014c500720cULL, 0x000fc40001741470ULL, 0x000000149100720cULL, 0x0c0fe40002781470ULL,
0x000000149100720cULL, 0x000fe40002fa1470ULL, 0x000000db78787210ULL, 0x000fe40007ffe1ffULL,
0x0000007cddd17219ULL, 0x040fe400000006ffULL, 0x00000080ddd77219ULL, 0x000fe400000006ffULL,
0x00000014bd00720cULL, 0x000fc40001f61070ULL, 0x00000014bd00720cULL, 0x080fe40000f21070ULL,
0x00000014c300720cULL, 0x0c0fe400037c1070ULL, 0x00000014c300720cULL, 0x0c0fe40000701070ULL,
0x00000014c300720cULL, 0x080fe40001741070ULL, 0x000000148f00720cULL, 0x0c0fe40002781070ULL,
0x000000148f00720cULL, 0x000fc40002fa1070ULL, 0x00000078dddd7219ULL, 0x000fe400000006ffULL,
0x00005410df827816ULL, 0x000fe40000000082ULL, 0xff8000005c5c7808ULL, 0x000fe40001800000ULL,
0xff8000005e5e7808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff8000004b4b7808ULL, 0x000fc40000000000ULL, 0xff8000005f5f7808ULL, 0x000fe40001000000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000060607808ULL, 0x000fe40002800000ULL,
0x0000007ed1ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007ed7ff7212ULL, 0x080fe4000782c0ffULL,
0x0000007eddff7212ULL, 0x000fc400078cc0ffULL, 0x00000082cbff7212ULL, 0x080fe4000780c0ffULL,
0x00000082d1ff7212ULL, 0x080fe4000784c0ffULL, 0x00000082d7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084d1ff7212ULL, 0x000fe400078ac0ffULL, 0x000000149100720cULL, 0x080fe40000701470ULL,
0x00000014cf00720cULL, 0x000fc40001f61470ULL, 0x00000014cf00720cULL, 0x0c0fe40001741470ULL,
0x00000014cf00720cULL, 0x080fe40002fa1470ULL, 0x00000014d500720cULL, 0x080fe40000f21470ULL,
0x00000014db00720cULL, 0x080fe400037c1470ULL, 0x00000014d500720cULL, 0x080fe40002781470ULL,
0x000000148f00720cULL, 0x000fc40000701070ULL, 0x00000014cd00720cULL, 0x0c0fe40001f61070ULL,
0x00000014cd00720cULL, 0x0c0fe40001741070ULL, 0x00000014cd00720cULL, 0x080fe40002fa1070ULL,
0x00000014d300720cULL, 0x080fe40000f21070ULL, 0x00000014d900720cULL, 0x080fe400037c1070ULL,
0x00000014d300720cULL, 0x000fc40002781070ULL, 0x00005410e7887816ULL, 0x000fe40000000088ULL,
0xff80000042427808ULL, 0x000fe40000000000ULL, 0xff80000041417808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40001000000ULL, 0xff80000061617808ULL, 0x000fe40002800000ULL,
0xff8000004c4c7808ULL, 0x000fc40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff8000004e4e7808ULL, 0x000fe40002000000ULL, 0x00000082ddff7212ULL, 0x000fe4000780c0ffULL,
0x00000084d7ff7212ULL, 0x080fe4000786c0ffULL, 0x00000084ddff7212ULL, 0x000fe4000784c0ffULL,
0x00000088cbff7212ULL, 0x000fc400078ac0ffULL, 0x00000088d1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000088d7ff7212ULL, 0x080fe400078cc0ffULL, 0x00000088ddff7212ULL, 0x000fe4000788c0ffULL,
0x000000149100720cULL, 0x080fe40002fa1470ULL, 0x00000014cf00720cULL, 0x080fe40000f21470ULL,
0x00000014d500720cULL, 0x000fc40001f61470ULL, 0x00000014d500720cULL, 0x080fe400037c1470ULL,
0x00000014db00720cULL, 0x0c0fe40000701470ULL, 0x00000014db00720cULL, 0x0c0fe40001741470ULL,
0x00000014db00720cULL, 0x080fe40002781470ULL, 0x000000148f00720cULL, 0x080fe40002fa1070ULL,
0x00000014cd00720cULL, 0x000fc40000f21070ULL, 0x00000014d900720cULL, 0x080fe40000701070ULL,
0x00000014d300720cULL, 0x0c0fe40001f61070ULL, 0x00000014d300720cULL, 0x080fe400037c1070ULL,
0x00000014d900720cULL, 0x0c0fe40001741070ULL, 0x00000014d900720cULL, 0x000fe40002781070ULL,
0xff8000004f4f7808ULL, 0x000fc40000000000ULL, 0xff80000064647808ULL, 0x000fe40001800000ULL,
0xff80000065657808ULL, 0x000fe40001000000ULL, 0xff80000062627808ULL, 0x000fe40002800000ULL,
0xff80000063637808ULL, 0x000fe40000800000ULL, 0xff80000066667808ULL, 0x000fe40003000000ULL,
0xff80000067677808ULL, 0x000fce0002000000ULL, 0x000000692000720bULL, 0x004fc80003f1e000ULL,
0x0000002069207208ULL, 0x000fc80004000000ULL, 0x000000992000720bULL, 0x000fc80003f1e000ULL,
0x0000002099057208ULL, 0x000fc80004000000ULL, 0x000000300500720bULL, 0x000fc80003f1e000ULL,
0x0000000530147208ULL, 0x000fc80004000000ULL, 0x000000311400720bULL, 0x000fc80003f1e000ULL,
0x0000001431057208ULL, 0x000fc80004000000ULL, 0x000000380500720bULL, 0x000fc80003f1e000ULL,
0x0000000538147208ULL, 0x000fc80004000000ULL, 0x000000391400720bULL, 0x000fc80003f1e000ULL,
0x0000001439057208ULL, 0x000fc80004000000ULL, 0x0000003c0500720bULL, 0x000fc80003f1e000ULL,
0x000000053c147208ULL, 0x000fc80004000000ULL, 0x0000003d1400720bULL, 0x000fc80003f1e000ULL,
0x000000143d057208ULL, 0x000fc80004000000ULL, 0x000000440500720bULL, 0x000fc80003f1e000ULL,
0x0000000544147208ULL, 0x000fc80004000000ULL, 0x000000451400720bULL, 0x000fc80003f1e000ULL,
0x0000001445057208ULL, 0x000fc80004000000ULL, 0x000000480500720bULL, 0x000fc80003f1e000ULL,
0x0000000548147208ULL, 0x000fc80004000000ULL, 0x000000491400720bULL, 0x000fc80003f1e000ULL,
0x0000001449057208ULL, 0x000fc80004000000ULL, 0x000000400500720bULL, 0x000fc80003f1e000ULL,
0x0000000540147208ULL, 0x000fc80004000000ULL, 0x000000411400720bULL, 0x000fc80003f1e000ULL,
0x0000001441057208ULL, 0x000fc80004000000ULL, 0x0000004c0500720bULL, 0x000fc80003f1e000ULL,
0x000000054c147208ULL, 0x000fe40004000000ULL, 0x0000009a2100720bULL, 0x000fe40003f1e000ULL,
0x0000004d1400720bULL, 0x000fc80003f3e000ULL, 0x000000144d167208ULL, 0x000fe40004800000ULL,
0x000000219a147208ULL, 0x000fc60004000000ULL, 0x0c401f0016197f89ULL, 0x000ea200000e0000ULL,
0x0000009b1400720bULL, 0x000fc80003f1e000ULL, 0x000000149b057208ULL, 0x000fc80004000000ULL,
0x000000320500720bULL, 0x000fc80003f1e000ULL, 0x0000000532147208ULL, 0x000fc80004000000ULL,
0x000000331400720bULL, 0x000fc80003f1e000ULL, 0x0000001433057208ULL, 0x000fe40004000000ULL,
0x000000191600720bULL, 0x004fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f1e000ULL,
0x0000001619197208ULL, 0x000fe40004800000ULL, 0x000000053a147208ULL, 0x000fc60004000000ULL,
0x0c201f0019207f89ULL, 0x000ea200000e0000ULL, 0x0000003b1400720bULL, 0x000fc80003f1e000ULL,
0x000000143b057208ULL, 0x000fc80004000000ULL, 0x0000003e0500720bULL, 0x000fc80003f1e000ULL,
0x000000053e147208ULL, 0x000fc80004000000ULL, 0x0000003f1400720bULL, 0x000fc80003f1e000ULL,
0x000000143f057208ULL, 0x000fe40004000000ULL, 0x000000201900720bULL, 0x004fe40003f3e000ULL,
0x000000460500720bULL, 0x000fe40003f1e000ULL, 0x0000001920207208ULL, 0x000fe40004800000ULL,
0x0000000546147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b201e7820ULL, 0x000fe20000410000ULL,
0x000000471400720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b69287823ULL, 0x100fe2000001081eULL,
0x0000001447057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b99257823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081eULL,
0x0000004a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b382c7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe2000001081eULL,
0x000000054a147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b48487823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b40407823ULL, 0x100fe2000001081eULL,
0x0000004b1400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b4c4c7823ULL, 0x000fe2000001081eULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000144b057208ULL, 0x000fc80004000000ULL, 0x000000420500720bULL, 0x000fc60003f1e000ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x0000000542147208ULL, 0x000fc80004000000ULL,
0x000000431400720bULL, 0x000fc60003f1e000ULL, 0x00000030002a7308ULL, 0x000fe20000000800ULL,
0x0000001443057208ULL, 0x000fc80004000000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x000000282528723eULL, 0x004fe200000000ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x000000054e147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b44057823ULL, 0x000fe2000001081eULL,
0x3c003c00ff257424ULL, 0x000fe400078e00ffULL, 0x0000004f1400720bULL, 0x000fc60003f1e000ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000144f187208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b45147823ULL, 0x100fe2000001081eULL, 0x0000006b2200720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b49457823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b4d497823ULL, 0x000fe2000001081eULL,
0x0c401f0018217f89ULL, 0x000ee200000e0000ULL, 0x000000226b227208ULL, 0x000fe20004000000ULL,
0x0000003900397308ULL, 0x000f220000000800ULL, 0x0000002a312a723eULL, 0x004fe400000000ffULL,
0x0000002d2200720bULL, 0x000fc80003f1e000ULL, 0x000000222d197208ULL, 0x000fe20004000000ULL,
0x0000003c003c7308ULL, 0x000fe60000000800ULL, 0x000000341900720bULL, 0x000fc80003f1e000ULL,
0x0000001934167208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x0000002c392c723eULL, 0x010fe400000000ffULL, 0x000000351600720bULL, 0x000fe40003f1e000ULL,
0x000000211800720bULL, 0x008fe40003f3e000ULL, 0x0000001635197208ULL, 0x000fe20004000000ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x0000001821217208ULL, 0x000fc40004800000ULL,
0x000000501900720bULL, 0x000fc60003f1e000ULL, 0x0c201f00211c7f89ULL, 0x000ea200000e0000ULL,
0x0000001950167208ULL, 0x000fe20004000000ULL, 0x0000004800187308ULL, 0x000fe60000000800ULL,
0x000000511600720bULL, 0x000fc80003f1e000ULL, 0x0000001651197208ULL, 0x000fe20004000000ULL,
0x0000000500057308ULL, 0x000fe60000000800ULL, 0x000000541900720bULL, 0x000fc80003f1e000ULL,
0x00000019541a7208ULL, 0x000fe20004000000ULL, 0x0000001400147308ULL, 0x000fe60000000800ULL,
0x000000551a00720bULL, 0x000fe40003f1e000ULL, 0x0000001c2100720bULL, 0x004fe40003f3e000ULL,
0x0000001a55297208ULL, 0x000fe20004000000ULL, 0x0000004100197308ULL, 0x000fe20000000800ULL,
0x000000211c217208ULL, 0x000fc40004800000ULL, 0x000000582900720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b21247820ULL, 0x000fe20000410000ULL, 0x00000029581c7208ULL, 0x000fe20004000000ULL,
0x0000004000167308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b9a9a7823ULL, 0x100fe20000010824ULL,
0x000000591c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b9b9b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010824ULL,
0x0000001c59297208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010824ULL,
0x00000032002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010824ULL,
0x0000005c2900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010824ULL,
0x000000295c1c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010824ULL,
0x0000003300267308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010824ULL,
0x0000005d1c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010824ULL,
0x0000001c5d297208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010824ULL,
0x0000002e2300720bULL, 0x000fe20003f1e000ULL, 0x0000009a009a7308ULL, 0x000fe20000000800ULL,
0x000000602900720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b4f247823ULL, 0x000fe20000010824ULL,
0x000000232e1c7208ULL, 0x000fc40004000000ULL, 0x00000029601e7208ULL, 0x000fe40004800000ULL,
0x0000002f1c00720bULL, 0x000fe20003f1e000ULL, 0x0000009b009b7308ULL, 0x000ee20000000800ULL,
0x000000611e00720bULL, 0x000fe40003f3e000ULL, 0x0000001c2f237208ULL, 0x000fe40004000000ULL,
0x0000001e61297208ULL, 0x000fe40004800000ULL, 0x000000362300720bULL, 0x000fe20003f1e000ULL,
0x0000004300487308ULL, 0x000fe20000000800ULL, 0x000000642900720bULL, 0x000fc40003f3e000ULL,
0x00000023361c7208ULL, 0x000fe40004000000ULL, 0x00000029641e7208ULL, 0x000fe40004800000ULL,
0x000000371c00720bULL, 0x000fe20003f1e000ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x000000651e00720bULL, 0x000fe40003f3e000ULL, 0x0000001c37237208ULL, 0x000fe40004000000ULL,
0x0000001e651e7208ULL, 0x000fc40004800000ULL, 0x000000522300720bULL, 0x000fe20003f1e000ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0000002b262b723eULL, 0x004fe200000000ffULL,
0x0c401f001e297f89ULL, 0x000ea200000e0000ULL, 0x00000023521c7208ULL, 0x000fe40004000000ULL,
0x000000051440723eULL, 0x000fe200000000ffULL, 0x0000100003057824ULL, 0x000fe200078e020aULL,
0x000000531c00720bULL, 0x000fe20003f1e000ULL, 0x0000003e003e7308ULL, 0x000fe40000000800ULL,
0x0001200005057836ULL, 0x000fe20000000000ULL, 0x0000001c53237208ULL, 0x000fc80004000000ULL,
0x000000562300720bULL, 0x000fe20003f1e000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x00000023561c7208ULL, 0x000fc80004000000ULL, 0x000000571c00720bULL, 0x000fe20003f1e000ULL,
0x00000024004d7308ULL, 0x0009e20000000800ULL, 0x000000291e00720bULL, 0x004fe40003f3e000ULL,
0x0000001c57237208ULL, 0x000fe40004000000ULL, 0x0000001e291e7208ULL, 0x000fe40004800000ULL,
0x0000005a2300720bULL, 0x000fe20003f1e000ULL, 0x3c003c00ff247424ULL, 0x010fe200078e00ffULL,
0x0000004600417308ULL, 0x000fe20000000800ULL, 0x0c201f001e297f89ULL, 0x000ea200000e0000ULL,
0x000000235a1c7208ULL, 0x000fc80004000000ULL, 0x0000005b1c00720bULL, 0x000fe40003f1e000ULL,
0x0000004700447308ULL, 0x000f240000000800ULL, 0x0000001c5b237208ULL, 0x000fc80004000000ULL,
0x0000005e2300720bULL, 0x000fe40003f1e000ULL, 0x0000004a004a7308ULL, 0x000fe40000000800ULL,
0x000000235e1c7208ULL, 0x000fc80004000000ULL, 0x0000005f1c00720bULL, 0x000fe40003f1e000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000291e00720bULL, 0x004fe40003f3e000ULL,
0x0000001c5f237208ULL, 0x000fe40004000000ULL, 0x0000001e29227208ULL, 0x000fe40004800000ULL,
0x000000622300720bULL, 0x000fe20003f1e000ULL, 0x0000004c001a7308ULL, 0x000fe20000000800ULL,
0x0000009a9b29723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b221e7820ULL, 0x000fe20000410000ULL,
0x00000023621c7208ULL, 0x000fc40004000000ULL, 0x000000414441723eULL, 0x010fe200000000ffULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081eULL, 0x000000631c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b6b6b7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081eULL, 0x0000001c63237208ULL, 0x000fe20004000000ULL,
0x0000003400327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b50507823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b51517823ULL, 0x100fe2000001081eULL, 0x000000662300720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b54547823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b55557823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b58587823ULL, 0x100fe2000001081eULL, 0x00000023661c7208ULL, 0x000fe20004000000ULL,
0x0000006b00307308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b59597823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b5c5c7823ULL, 0x100fe2000001081eULL, 0x000000671c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b60607823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b61617823ULL, 0x100fe2000001081eULL, 0x0000001c671c7208ULL, 0x000fe20004000000ULL,
0x0000002d00337308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b64647823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b651e7823ULL, 0x000fe2000001081eULL, 0x000000161944723eULL, 0x000fe200000000ffULL,
0x0c401f001c237f89ULL, 0x000f2800000e0000ULL, 0x0000003500357308ULL, 0x000f620000000800ULL,
0x0000003a3b2d723eULL, 0x004fc400000000ffULL, 0x000000242838723cULL, 0x000fe200000018ffULL,
0x000000303330723eULL, 0x008fc800000000ffULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x000000323532723eULL, 0x022fce00000000ffULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x000000231c00720bULL, 0x010fc80003f1e000ULL, 0x0000001c23237208ULL, 0x000fc60004000000ULL,
0x0000005400547308ULL, 0x000fe40000000800ULL, 0x0c201f00231c7f89ULL, 0x000e6c00000e0000ULL,
0x0000005500557308ULL, 0x000ff00000000800ULL, 0x0000001e004f7308ULL, 0x0005f00000000800ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0xfffffff8ff1e7812ULL, 0x004fc400078ee215ULL,
0x0000000317157812ULL, 0x000fe400078ec0ffULL, 0x0000001c2300720bULL, 0x002fe20003f1e000ULL,
0x000000081e4c7836ULL, 0x000fe20000000000ULL, 0x0000000815157210ULL, 0x000fe20007ffe0ffULL,
0x0000005900597308ULL, 0x000e620000000800ULL, 0x000000231c237208ULL, 0x000fe20004000000ULL,
0x000000081e267824ULL, 0x000fe200078e00ffULL, 0x0000000715157812ULL, 0x000fe400078ec0ffULL,
0x0000000308ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b231c7820ULL, 0x000fe20000410000ULL,
0xfffffff826267812ULL, 0x000fe200078ee215ULL, 0x0000005c005c7308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b52527823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b53537823ULL, 0x100fe2000001081cULL,
0x0000002e00347308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b56567823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b57577823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b5e5e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b5f5f7823ULL, 0x100fe2000001081cULL, 0x000000585914723eULL, 0x002fe200000000ffULL,
0x0000002f00437308ULL, 0x0002e20000000800ULL, 0x0000003c3d2e723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b62627823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b63637823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b66667823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b671c7823ULL, 0x000fe2000001081cULL,
0x0000002800587202ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe200078e002aULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000003e3f2f723eULL, 0x002fe200000000ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e002dULL, 0x0000000526267211ULL, 0x000fc400078e20ffULL,
0x0000002900287202ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe200078e002bULL,
0x000000344331723eULL, 0x008fe200000000ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000505134723eULL, 0x000fe200000000ffULL, 0x000000242c38723cULL, 0x000fe20000001838ULL,
0x000000101e517810ULL, 0x000fe20007ffe0ffULL, 0x000000084c507824ULL, 0x000fe200078e00ffULL,
0x0000004a4b43723eULL, 0x000fc600000000ffULL, 0x0000002f002b7202ULL, 0x000fe20000000f00ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0xfffffff850507812ULL, 0x000fe200078ee215ULL,
0x000000ffff2d7224ULL, 0x000fc800078e0043ULL, 0x0000001050507824ULL, 0x000fe200078e0205ULL,
0x000000363733723eULL, 0x002fe200000000ffULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x000000545536723eULL, 0x000fca00000000ffULL, 0x00000024303c723cULL, 0x000fe400000018ffULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000525335723eULL, 0x002fce00000000ffULL,
0x0000005700577308ULL, 0x000e620000000800ULL, 0x000000181e537836ULL, 0x000fe20000000000ULL,
0x0000000351527819ULL, 0x000fc600000006ffULL, 0x0000000853547824ULL, 0x000fe200078e00ffULL,
0xfffffff852527812ULL, 0x000fe400078ee215ULL, 0x0000005d005d7308ULL, 0x000ea40000000800ULL,
0xfffffff854547812ULL, 0x000fe200078ee215ULL, 0x0000001052527824ULL, 0x000fc600078e0205ULL,
0x0000000554547211ULL, 0x000fe400078e20ffULL, 0x000000565737723eULL, 0x002fe200000000ffULL,
0x0000005a005a7308ULL, 0x000fec0000000800ULL, 0x00000024343c723cULL, 0x000fe2000000183cULL,
0x0000005c5d16723eULL, 0x004fe200000000ffULL, 0x0000005b005b7308ULL, 0x000e620000000800ULL,
0x000000ffff5c7224ULL, 0x000fce00078e0040ULL, 0x0000005e005e7308ULL, 0x000fe20000000800ULL,
0x0000005a5b15723eULL, 0x002fce00000000ffULL, 0x0000005f005f7308ULL, 0x000e620000000800ULL,
0x000000ffff5a7224ULL, 0x000fe200078e002cULL, 0x0000002e005b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff2c7224ULL, 0x000fc800078e0041ULL, 0x0000005826007844ULL, 0x0005e20000000200ULL,
0x0000004200477308ULL, 0x0007300000000800ULL, 0x0000004900497308ULL, 0x000f620000000800ULL,
0x000000184542723eULL, 0x008fc400000000ffULL, 0x0000000408187810ULL, 0x000fe40007ffe017ULL,
0x0000005e5f17723eULL, 0x002fe200000000ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0044ULL,
0x000000474845723eULL, 0x010fe200000000ffULL, 0x000000244038723cULL, 0x000fe20000001838ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x0000000718197812ULL, 0x000fe400078ec0ffULL,
0x000000031e187819ULL, 0x000fe200000006ffULL, 0x00000008511e7824ULL, 0x000fe200078e00ffULL,
0x00000024143c723cULL, 0x000fe2000000183cULL, 0x0000001a4946723eULL, 0x020fe200000000ffULL,
0x000000084c1a7824ULL, 0x000fe200078e00ffULL, 0x0000006000607308ULL, 0x000fe20000000800ULL,
0xfffffff818187812ULL, 0x000fe200078ee219ULL, 0x000000ffff407224ULL, 0x000fe200078e0030ULL,
0x00000003534c7819ULL, 0x000fe200000006ffULL, 0x000000ffff5f7224ULL, 0x000fe200078e0046ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL, 0x0000001018187824ULL, 0x100fe200078e0205ULL,
0x0000004e4d47723eULL, 0x002fe200000000ffULL, 0x0000006100617308ULL, 0x000e620000000800ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee219ULL, 0x000000101a1a7824ULL, 0x000fe200078e0205ULL,
0x00000042005d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0047ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee219ULL, 0x000000ffff427224ULL, 0x000fe200078e0034ULL,
0x000000244438723cULL, 0x000fe20000001838ULL, 0x0000006400647308ULL, 0x000f2a0000000800ULL,
0x00000045002e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff437224ULL, 0x000fe200078e0036ULL,
0x0000003200417202ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe200078e0031ULL,
0x0000005c18007844ULL, 0x0007e20000000200ULL, 0x000000101e1e7824ULL, 0x000fe200078e0205ULL,
0x000000606148723eULL, 0x002fe200000000ffULL, 0x0000006200627308ULL, 0x000fe20000000800ULL,
0x0000001400447202ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fe200078e0016ULL,
0x0000003500327202ULL, 0x000fe20000000f00ULL, 0x000000ffff467224ULL, 0x000fe200078e0048ULL,
0x0000002850007844ULL, 0x0007e20000000200ULL, 0x000000ffff317224ULL, 0x000fe200078e0033ULL,
0x000000644f4a723eULL, 0x010fe200000000ffULL, 0x0000006300637308ULL, 0x000e620000000800ULL,
0x000000ffff337224ULL, 0x000fe200078e0037ULL, 0x0000001700357202ULL, 0x000fe20000000f00ULL,
0x000000104c4c7824ULL, 0x000fe200078e0205ULL, 0x0000004a00477202ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe200078e0015ULL, 0x0000002c1a007844ULL, 0x0007e20000000200ULL,
0x0000003a00397202ULL, 0x000fe20000000f00ULL, 0x00000066004b7308ULL, 0x000fe20000000800ULL,
0x0000000100147802ULL, 0x000fe20000000f00ULL, 0x0000004052007844ULL, 0x0007e20000000200ULL,
0x000000ffff057224ULL, 0x000fc600078e0027ULL, 0x000000441e007844ULL, 0x0007e20000000200ULL,
0x000000626349723eULL, 0x002fe200000000ffULL, 0x0000001c001c7308ULL, 0x000e640000000800ULL,
0x0000003054007844ULL, 0x0007e40000000200ULL, 0x000000ffff367224ULL, 0x000fe200078e0049ULL,
0x0000004b1c4b723eULL, 0x002fca00000000ffULL, 0x000000ffff377224ULL, 0x000fe400078e004bULL,
0x00000024483c723cULL, 0x000fe6000000183cULL, 0x000000344c007844ULL, 0x0007e80000000200ULL,
0x01e0002013008388ULL, 0x0007de0000000c00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000ffff3a7224ULL, 0x000fe400078e003cULL, 0x000000ffff3b7224ULL, 0x000fca00078e003eULL,
0x01e2003813008388ULL, 0x0007e20000000c00ULL, 0x0000000c2700720cULL, 0x000fe20003f06070ULL,
0x01e608141bff79a7ULL, 0x0007e2000850003fULL, 0x01e610141bff79a7ULL, 0x0007e2000850003fULL,
0x01e618141bff79a7ULL, 0x0007e2000850003fULL, 0x01e620141bff79a7ULL, 0x0007f2000850003fULL,
0xffffff7800948947ULL, 0x004fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000080057836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000005087812ULL, 0x000fc800078ec0ffULL, 0x018000000800780cULL, 0x000fda0003f05070ULL,
0x0000008000058308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0800720cULL, 0x040fe40003f25070ULL, 0x008000000800780cULL, 0x000fe40003f02070ULL,
0x00000001ff087807ULL, 0x000fe40000800000ULL, 0x00000001ff057807ULL, 0x004fc80004000000ULL,
0x0000000508ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff80ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x0000000508ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000080087812ULL, 0x000fd600078ec0ffULL,
0x0080000008050812ULL, 0x000fe400078efcffULL, 0x0000000800058202ULL, 0x000fe20000000f00ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000008000057308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff137424ULL, 0x000fc800078e00ffULL,
0xfffffe6c12947950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000447ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005c8ULL, 0x00000000000001f8ULL,
0x0000001300000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000007c0ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008e4ULL, 0x0000000000000530ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e60ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000019280ULL,
0x0000001300000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a100ULL, 0x0000000000000038ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a140ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001a140ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x000000000001a738ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a738ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000019280ULL, 0x0000000000019280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x000000000001a100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a140ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 108680;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
