/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015338ULL, 0x0000000000014fb8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000373ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000003ceULL,
0x0000000000013bf0ULL, 0x0000000000000290ULL, 0x0004000300000444ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013e80ULL,
0x000d000300000474ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013bf000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080d60828808081ULL, 0x80162880808d0828ULL, 0x0000000310288082ULL, 0x808d920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x00013bf000000000ULL,
0x0000029000000000ULL, 0x00005c0400000000ULL, 0x80882880808d0900ULL, 0x0000000000002880ULL,
0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000020000b42804ULL, 0x0000081000000380ULL, 0x0000300000002050ULL,
0x0000315000003080ULL, 0x0000361000003290ULL, 0x00003b4000003620ULL, 0x00004ad000004a60ULL,
0x00004d1000004bd0ULL, 0x00004f6000004f50ULL, 0x0000626000005340ULL, 0x000063d0000062d0ULL,
0x0000671000006510ULL, 0x00006ae000006720ULL, 0x00007b3000007ac0ULL, 0x00007d7000007c30ULL,
0x00007f9000007f80ULL, 0x000084f0000084e0ULL, 0x0000a6b00000a680ULL, 0x0000ace00000acc0ULL,
0x0001310000013050ULL, 0x000133b000013310ULL, 0x000136e0000136b0ULL, 0x0001389000013830ULL,
0x0000053001f03904ULL, 0x0001b600000000ffULL, 0x0000061000040100ULL, 0x0001b60800000004ULL,
0x00000720003f0100ULL, 0x0001b68800000003ULL, 0x00000e90003f0100ULL, 0x0001b60000000002ULL,
0x00001040003f0107ULL, 0x0001b68800000007ULL, 0x00002db0003f0101ULL, 0x0001b60800000058ULL,
0x00002dd0003f0101ULL, 0x0001b60800000058ULL, 0x00002f40003f0109ULL, 0x0001b60800000058ULL,
0x00003af0003f0109ULL, 0x0001b6880000004eULL, 0x000047e0003f0101ULL, 0x0001b62800000058ULL,
0x00004850003f0101ULL, 0x0001b62800000056ULL, 0x000049c0003f0109ULL, 0x0001b62800000056ULL,
0x00005280003f0109ULL, 0x0001b6900000004eULL, 0x00005fe0003f0101ULL, 0x0001b64800000056ULL,
0x00006050003f0101ULL, 0x0001b64800000056ULL, 0x000061c0003f0109ULL, 0x0001b64800000056ULL,
0x00006a60003f0109ULL, 0x0001b6980000004eULL, 0x00007840003f0101ULL, 0x0001b66800000056ULL,
0x000078b0003f0101ULL, 0x0001b6680000001fULL, 0x00007a20003f0109ULL, 0x0001b6680000001fULL,
0x00008270003f0109ULL, 0x0001b6a00000004eULL, 0x0000bc50003f0101ULL, 0x0001b60000000002ULL,
0x0000d500003f0101ULL, 0x0001b60000000002ULL, 0x0000d6c0003f0109ULL, 0x0001b60000000002ULL,
0x00011440003f0109ULL, 0x0001b68800000007ULL, 0x00011710003f0101ULL, 0x0001b68800000007ULL,
0x00011880003f0109ULL, 0x0001b68800000007ULL, 0x00013b90003f0109ULL, 0x0001b6080000000aULL,
0x00013ba0003f0101ULL, 0x0001b6100000000aULL, 0x00013bb0003f0101ULL, 0x0001b6180000000aULL,
0x00013bc0003f0101ULL, 0x0001b6200000000aULL, 0x00033803003f0101ULL, 0x0000b31000201c04ULL,
0x0000b5f00000b330ULL, 0x0000b9e00000b7e0ULL, 0x0000d6f00000bb90ULL, 0x000c050400013be0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL, 0x0000001500080a04ULL,
0x0000000000680210ULL, 0x00000000000000c4ULL, 0x0000001400000002ULL, 0x0000000000013bf0ULL,
0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000000009dULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000087919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff0e7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000108052836ULL, 0x008fe40000000000ULL, 0x00000004080c2825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x000000060c0c2981ULL, 0x000ea8000c1e1900ULL,
0x00000006025f2981ULL, 0x0006a2000c1e1900ULL, 0x0000000e00067306ULL, 0x010f220000209000ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x000000ff0e00720cULL, 0x000fe20003f65070ULL,
0x00000000005e7919ULL, 0x000ee20000002600ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x0000000000107919ULL, 0x000ee80000002300ULL, 0x00000400ff097b82ULL, 0x000ee20000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000600067308ULL, 0x010f240000001000ULL,
0x0ffffffe06047836ULL, 0x010fc40000000000ULL, 0x0000000000067919ULL, 0x000f280000002100ULL,
0x0000000400057305ULL, 0x000b64000021f000ULL, 0x000000ffff047224ULL, 0x022fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x0000000e07077224ULL, 0x000fc800078e02ffULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000905077227ULL, 0x008fe200078e00ffULL,
0x00000005ff5d7819ULL, 0x010fc80000011606ULL, 0x000000ff07037210ULL, 0x000fe40007ffe1ffULL,
0x00001fff5d5d7589ULL, 0x000e6600000e0000ULL, 0x000000030e037224ULL, 0x000fe400078e0209ULL,
0x0000000000097919ULL, 0x000ee60000002200ULL, 0x0000000e0300720cULL, 0x000fda0003f06070ULL,
0x0000000103030824ULL, 0x000fe400078e0a0eULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x0000000e0300720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x0000000eff07b212ULL, 0x000fc800078e33ffULL, 0x0000000700047306ULL, 0x000f220000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f85070ULL, 0x0000000400047308ULL, 0x010f240000001000ULL,
0x0ffffffe04027836ULL, 0x010fcc0000000000ULL, 0x0000000200037305ULL, 0x000964000021f000ULL,
0x000000ffff027224ULL, 0x010fe400078e00ffULL, 0x0000000307057224ULL, 0x020fca00078e02ffULL,
0x000000ff05057210ULL, 0x000fca0007ffe1ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000005e03057227ULL, 0x000fc800078e00ffULL, 0x0000000410037c24ULL, 0x008fe2000f8e0209ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a05ULL,
0x00008400ff09ab82ULL, 0x000e620000000800ULL, 0x0000000403037c24ULL, 0x000fe2000f8e0206ULL,
0x00001fff10107589ULL, 0x000e6200000e0000ULL, 0x0000000207027224ULL, 0x000fc600078e025eULL,
0x0000007f0300780cULL, 0x000fe40003f64070ULL, 0x000000070200720cULL, 0x000fd60003f06070ULL,
0x00000000000bb919ULL, 0x000ee20000008800ULL, 0x000004000004b802ULL, 0x000fe20000000f00ULL,
0x0000000102020824ULL, 0x000fe200078e0a07ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0300720cULL, 0x000fe40003f05270ULL, 0x000000070200720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000007ff05c212ULL, 0x000fe400078e33ffULL,
0x0000000f0300780cULL, 0x040fe40003f24070ULL, 0x000000030300780cULL, 0x000fe20003f84070ULL,
0x000000ffff027224ULL, 0x000fc800078e0a05ULL, 0x00000002075e7224ULL, 0x000fe200078e025eULL,
0x000006540b04b816ULL, 0x008fe20000000004ULL, 0xff317217ff07b424ULL, 0x000fc800078e00ffULL,
0x000000040302b824ULL, 0x000fe400078e0204ULL, 0x000000015f5f2824ULL, 0x004fcc00078e0a0cULL,
0x00008400ff5fab82ULL, 0x000ea20000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000403047c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000040812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000030812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000045e5e7819ULL, 0x000fe200000006ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000607919ULL, 0x000e620000002500ULL, 0x000000045f037c24ULL, 0x004fe4000f8e02ffULL,
0x000000ffff067224ULL, 0x000fe200078e0a5eULL, 0x01b400070200b388ULL, 0x0005e20000000800ULL,
0x00000009080ca224ULL, 0x000fe200078e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e0300720cULL, 0x000fe20003f06070ULL, 0x000000040e117c24ULL, 0x000fe2000f8e02ffULL,
0x0000001003067446ULL, 0x000fe20003800006ULL, 0x0000000410027824ULL, 0x004fc400078e025dULL,
0x000000110c037224ULL, 0x000fe200078e02ffULL, 0x000000ff06067207ULL, 0x000fe20000000000ULL,
0x0000000202077824ULL, 0x000fe400078e00ffULL, 0x0000000405137c24ULL, 0x000fe2000f8e0203ULL,
0x000000100600780cULL, 0x000fda0003f05270ULL, 0x0000000000c08947ULL, 0x002fea0003800000ULL,
0x0000000400027d06ULL, 0x000e620008209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bf45070ULL, 0x0000000000157919ULL, 0x000eea0000008800ULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe020a7836ULL, 0x002fe20000000000ULL,
0x00000004ff0d7819ULL, 0x004fca0000011604ULL, 0x0000000a000b7305ULL, 0x0002a2000021f000ULL,
0x00000001070f7824ULL, 0x000fc800078e020dULL, 0x000000015e027824ULL, 0x000fe400078e020fULL,
0x000000ffff0a7224ULL, 0x002fe400078e00ffULL, 0x000000100f127824ULL, 0x000fe200078e00ffULL,
0x8000000bff097210ULL, 0x004fca0007ffe0ffULL, 0x0000000409097c24ULL, 0x000fc8000f8e02ffULL,
0x000000090b0b7227ULL, 0x000fcc00078e000aULL, 0x000000020b0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0bULL, 0x0000000409097c24ULL, 0x000fca000f8e0202ULL,
0x0000000409007c0cULL, 0x000fda000bf06070ULL, 0x8000000409090c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x0000000409007c0cULL, 0x000fda000bf26070ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000004ff0bac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0bULL, 0x0000000409027c24ULL, 0x000fe2000f8e0202ULL,
0x0000000404097819ULL, 0x000fe200000006ffULL, 0x00008c0000047ab9ULL, 0x000fe40000000a00ULL,
0x00000001130a7824ULL, 0x000fe200078e0202ULL, 0x0000000706027248ULL, 0x000fc60007fe0000ULL,
0x000000110b0a7224ULL, 0x000fe400078e020aULL, 0x0000000102027824ULL, 0x000fe200078e0a07ULL,
0x000000f009077812ULL, 0x000fe200078ec0ffULL, 0x000001000a0a7825ULL, 0x000fc600078e00ffULL,
0x000000020d00720cULL, 0x000fe20003f06070ULL, 0x000000010f0d7824ULL, 0x000fe200078e0204ULL,
0x0000040000027802ULL, 0x000fe40000000f00ULL, 0x000000070a077212ULL, 0x000fe400078efcffULL,
0x0000065415027816ULL, 0x008fe40000000002ULL, 0xfffffff0120d7812ULL, 0x000fe400078ee20dULL,
0x00000004070a7c10ULL, 0x000fc6000ff3e0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x000000050b0b7c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x0000000400097d06ULL, 0x000e620008209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000004ff007c0cULL, 0x000fe2000bf45070ULL,
0x0000000000157919ULL, 0x000ee80000008800ULL, 0x0000000900097308ULL, 0x002e640000001000ULL,
0x0ffffffe090d7810ULL, 0x002fc40007ffe0ffULL, 0x0000000704077211ULL, 0x004fc800078fe0ffULL,
0x0000000d000b7305ULL, 0x0002a2000021f000ULL, 0x000000015e027824ULL, 0x000fe400078e0207ULL,
0x0000001007127824ULL, 0x040fe400078e00ffULL, 0x00000001070d7824ULL, 0x002fca00078e0204ULL,
0xfffffff0120d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0f7224ULL, 0x004fc800078e0a0bULL,
0x000000040f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f0b0f7227ULL, 0x000fcc00078e000aULL,
0x000000020f097227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL,
0x000000040b0a7c24ULL, 0x000fca000f8e0202ULL, 0x000000040a007c0cULL, 0x000fda000bf06070ULL,
0x800000040a0a0c10ULL, 0x000fe2000fffe0ffULL, 0x0000000109090836ULL, 0x000fc60000000000ULL,
0x000000040a007c0cULL, 0x000fda000bf26070ULL, 0x0000000109091836ULL, 0x000fe20000000000ULL,
0x00000004ff09ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL,
0x000000040b027c24ULL, 0x000fe2000f8e0202ULL, 0x00008c0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000113027824ULL, 0x000fc800078e0202ULL, 0x0000001109027224ULL, 0x000fe200078e0202ULL,
0x0000000404097819ULL, 0x000fc600000006ffULL, 0x00000100020a7825ULL, 0x000fe200078e00ffULL,
0x000000f0090f7812ULL, 0x000fe400078ec0ffULL, 0x0000040000027802ULL, 0x000fe40000000f00ULL,
0x0000000f0a0a7212ULL, 0x000fe400078efcffULL, 0x0000065415027816ULL, 0x008fe40000000002ULL,
0x000000040a0a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x000000050b0b7c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e8000b901c46ULL, 0x00000000020472caULL, 0x000fe200000e0000ULL,
0x00009400ff0a7b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x00000004080a7825ULL, 0x002fe200078e000aULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000060a5c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x0000003f5c5b7836ULL, 0x004fe20000000000ULL,
0x000000ff5c5a7810ULL, 0x000fc80007ffe0ffULL, 0x00000006ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff5a7819ULL, 0x000fca000001165aULL, 0x000000ac00108947ULL, 0x000fea0003800000ULL,
0x00000002ff477819ULL, 0x000fe2000001165dULL, 0x000000085d487824ULL, 0x000fe400078e00ffULL,
0xffffffffff0d7424ULL, 0x000fe200078e00ffULL, 0x03ffffff47077812ULL, 0x000fca00078ec0ffULL,
0x00000004600c7824ULL, 0x000fca00078e0207ULL, 0x0000005b0c00720cULL, 0x000fda0003f06070ULL,
0x00009600ff0a8b82ULL, 0x000e620000000800ULL, 0x0000000208078824ULL, 0x000fce00078e00ffULL,
0x00009200ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000a07078224ULL, 0x002fe200078e020aULL,
0x00000004000a7802ULL, 0x000fc60000000f00ULL, 0x000000010c078824ULL, 0x000fc800078e0207ULL,
0x0000000407108825ULL, 0x004fc800078e0010ULL, 0x0000000102077824ULL, 0x000fc800078e0248ULL,
0x01b6880a07ff79a7ULL, 0x0003e2000850003fULL, 0x00000006100d8981ULL, 0x000ea2000c1e1900ULL,
0x00000001ff537819ULL, 0x000fe2000001165dULL, 0x0000004005457824ULL, 0x000fc800078e00ffULL,
0x0000002053467824ULL, 0x000fe400078e00ffULL, 0x0000000160077836ULL, 0x002fe40000000000ULL,
0x0000010060147824ULL, 0x000fc600078e0246ULL, 0x0000005a0700720cULL, 0x000fe20003f06070ULL,
0x00009000ff0a7b82ULL, 0x000e620000000a00ULL, 0x000000015d077812ULL, 0x000fe200078ec0ffULL,
0x0000000e0d0d7224ULL, 0x004fca00078e02ffULL, 0x000000060d0d7819ULL, 0x000fca00000006ffULL,
0x000001000d0a7825ULL, 0x002fe200078e000aULL, 0x00000020450d7812ULL, 0x000fe200078ef814ULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x00000070090e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000003ff1a7819ULL, 0x000fe40000011604ULL,
0x000000145c097248ULL, 0x000fe20007fe0000ULL, 0x00000080070e7824ULL, 0x000fe200078e020eULL,
0x000000041a127810ULL, 0x000fe20007ffe0ffULL, 0x000000010d117824ULL, 0x000fe200078e021aULL,
0x000000101a227810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe400078e0a14ULL,
0x0000010011107825ULL, 0x000fc600078e000eULL, 0x0000002009097446ULL, 0x000fe20003800014ULL,
0x0000000112137824ULL, 0x040fe200078e0204ULL, 0x000000100a167210ULL, 0x000fe20007f1e0ffULL,
0x0000000812187824ULL, 0x040fe200078e00ffULL, 0x000000091200720cULL, 0x080fe20003f26070ULL,
0x0000400053107824ULL, 0x000fe200078e0202ULL, 0x000000110b177210ULL, 0x000fe200007fe4ffULL,
0x000000081a1e7836ULL, 0x000fe20000000000ULL, 0xfffffff8181d7812ULL, 0x000fe200078ee213ULL,
0x000000010d117824ULL, 0x000fe200078e0212ULL, 0x00000010071b7211ULL, 0x000fe200078e68ffULL,
0x0000000c1a207836ULL, 0x000fe20000000000ULL, 0x000000091a00720cULL, 0x0c0fe20003f06070ULL,
0x000000011a127824ULL, 0x000fe200078e0204ULL, 0x000000091e00720cULL, 0x080fe20003fa6070ULL,
0x000000010d137824ULL, 0x000fe200078e021eULL, 0x000000092000720cULL, 0x000fe20003f86070ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x0000000712197812ULL, 0x000fc600078ec0ffULL,
0x000000010d157824ULL, 0x000fe200078e0220ULL, 0x000000100a187210ULL, 0x000fe20007f5e0ffULL,
0x0000010013127825ULL, 0x000fc800078e000eULL, 0x0000010015147825ULL, 0x000fe200078e000eULL,
0x000000120a107210ULL, 0x000fc60007f7e0ffULL, 0x000130001b1c7836ULL, 0x000fe20000000000ULL,
0x0ffffff8191b7812ULL, 0x000fe200078ef804ULL, 0x000000141a247836ULL, 0x000fe20000000000ULL,
0x000000110b197210ULL, 0x000fe200017fe4ffULL, 0x000000010b117824ULL, 0x000fe200018e0613ULL,
0x000000140a127210ULL, 0x000fe20007f5e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021cULL,
0x000000092200720cULL, 0x080fe20003f66070ULL, 0x000000101d1d7824ULL, 0x000fe400078e021cULL,
0x000000010b137824ULL, 0x000fe200010e0615ULL, 0x000000220d157210ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161b7faeULL, 0x0003e2000c101c46ULL,
0x000000181a267836ULL, 0x000fe20000000000ULL, 0x000000092400720cULL, 0x000fe20003f46070ULL,
0x0000001c1a287836ULL, 0x000fe20000000000ULL, 0x00000000181d7faeULL, 0x0005e2000c901c46ULL,
0x0000010015147825ULL, 0x000fe200078e000eULL, 0x000000260d217210ULL, 0x000fc40007ffe0ffULL,
0x000000092600720cULL, 0x080fe20003f26070ULL, 0x000000011e1a7824ULL, 0x140fe200078e0204ULL,
0x000000140a147210ULL, 0x000fe20007fde0ffULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0x000000092800720cULL, 0x000fe20003f06070ULL, 0x0000000120167824ULL, 0x042fe200078e0204ULL,
0x000000150b157210ULL, 0x000fe200037fe4ffULL, 0x00000008201b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f097812ULL, 0x000fe200078ee21aULL, 0x000000010d177824ULL, 0x000fe400078e0224ULL,
0x0000000122197824ULL, 0x004fe200078e0204ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x0000010017167825ULL, 0x000fc800078e000eULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000160a187210ULL, 0x000fe20007fde0ffULL, 0x00000001241a7824ULL, 0x040fe400078e0204ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8221d7812ULL, 0x000fe200078ee219ULL,
0x000000010b197824ULL, 0x000fe400030e0617ULL, 0x0000010021167825ULL, 0x000fe200078e000eULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee21aULL, 0x00000004281a7210ULL, 0x000fe20007ffe0ffULL,
0x000000010d237824ULL, 0x000fe200078e0228ULL, 0x000000160a167210ULL, 0x000fe20007fde0ffULL,
0x00000001260d7824ULL, 0x040fe200078e0204ULL, 0x0000001c1d1d7211ULL, 0x000fe200078e20ffULL,
0x0000000826267824ULL, 0x000fc400078e00ffULL, 0x0000000828217824ULL, 0x000fe400078e00ffULL,
0x00000100230e7825ULL, 0x000fe200078e000eULL, 0xfffffff8260d7812ULL, 0x000fe400078ee20dULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x000000010b177824ULL, 0x000fe200030e0617ULL,
0x0000000e0a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x100fe400078e021cULL,
0x000000101b1b7824ULL, 0x000fc400078e021cULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x0000000010097faeULL, 0x0003e2000e901c46ULL, 0x000000100d0d7824ULL, 0x100fe400078e021cULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x00000000121b7faeULL, 0x0003e2000e101c46ULL,
0x000000010b0b7824ULL, 0x000fc600030e060fULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000181f7faeULL, 0x0003e8000d101c46ULL, 0x00000000160d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a217faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000004040e7811ULL, 0x040fe200078fe8ffULL, 0x00004000531a7824ULL, 0x000fe200078e0202ULL,
0x0000000804107811ULL, 0x000fe400078fe8ffULL, 0x000000040e0f7210ULL, 0x000fe20007ffe0ffULL,
0x000000080e1e7824ULL, 0x000fe200078e00ffULL, 0x0000001404147811ULL, 0x000fe200078fe8ffULL,
0x0000000110117824ULL, 0x100fe200078e0204ULL, 0x0000001c04187811ULL, 0x000fe200078fe8ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL,
0x0000000114157824ULL, 0x100fe200078e0204ULL, 0x0000000c040f7811ULL, 0x000fe200078fe8ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0xfffffff8121f7812ULL, 0x000fe200078ee211ULL,
0x00000008181d7824ULL, 0x000fe200078e00ffULL, 0x000000030f207819ULL, 0x040fe200000006ffULL,
0x000000010f117824ULL, 0x000fe200078e0204ULL, 0x0000001004127811ULL, 0x040fe200078fe8ffULL,
0x000000010d197824ULL, 0x000fe200078e0214ULL, 0x0000001804167811ULL, 0x000fe200078fe8ffULL,
0x00002000071a7824ULL, 0x000fe200078e021aULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x0000000112137824ULL, 0x040fe200078e0204ULL, 0x0000000e0d117210ULL, 0x000fe20007ffe0ffULL,
0x0000000812227824ULL, 0x000fe200078e00ffULL, 0x00000004180e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000816267824ULL, 0x000fe200078e00ffULL, 0x00000070091c7812ULL, 0x000fe200078ec0ffULL,
0x000000010d1b7824ULL, 0x040fe200078e0216ULL, 0xfffffff824247812ULL, 0x000fe200078ee215ULL,
0x000000010d157824ULL, 0x000fe200078e020fULL, 0xfffffff81d287812ULL, 0x000fe200078ee20eULL,
0x00000080071c7824ULL, 0x000fe200078e021cULL, 0x0000000d040f7211ULL, 0x000fe200078fe8ffULL,
0x000000010d217824ULL, 0x000fe200078e0218ULL, 0x000000ff001d7202ULL, 0x000fe20000000f00ULL,
0x000130001a297836ULL, 0x000fe20000000000ULL, 0x0000000416177210ULL, 0x000fc40007ffe0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee213ULL, 0x000000010d137824ULL, 0x000fe200078e0210ULL,
0x0000000404097211ULL, 0x000fe200078fe8ffULL, 0x000001000f0e7825ULL, 0x000fe200078e001cULL,
0xfffffff826267812ULL, 0x000fe400078ee217ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000010d177824ULL, 0x000fe200078e0212ULL, 0x0000000e0a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fe200078e001cULL, 0x0ffffff809097812ULL, 0x000fc400078ef804ULL,
0x0000002922237211ULL, 0x000fe200078e20ffULL, 0x0000010013127825ULL, 0x000fe200078e001cULL,
0x000000100a107210ULL, 0x000fc60007f3e0ffULL, 0x0000010015147825ULL, 0x100fe200078e001cULL,
0x000000120a127210ULL, 0x000fe40007f5e0ffULL, 0x000000110b117210ULL, 0x000fe20000ffe4ffULL,
0x0000010017167825ULL, 0x000fe200078e001cULL, 0x000000140a147210ULL, 0x000fc60007f7e0ffULL,
0x0000010019187825ULL, 0x000fc800078e001cULL, 0x000001001b1a7825ULL, 0x000fe200078e001cULL,
0x000000180a187210ULL, 0x000fc60007f3e0ffULL, 0x00000100211c7825ULL, 0x000fc800078e001cULL,
0x000000010b0f7824ULL, 0x000fe200000e060fULL, 0x000000160a167210ULL, 0x000fe20007f1e0ffULL,
0x0000001009097824ULL, 0x000fe400078e0229ULL, 0x000000010b137824ULL, 0x040fe200010e0613ULL,
0x0000001a0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000101e0d7824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0003e2000b901c46ULL,
0x000000010b157824ULL, 0x000fe200018e0615ULL, 0x0000001c0a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0229ULL, 0x0000001b0b1b7210ULL, 0x000fe200017fe4ffULL,
0x0000001020217824ULL, 0x000fe200078e0229ULL, 0x00000000100d7faeULL, 0x0003e2000b901c46ULL,
0x000000010b177824ULL, 0x000fc400000e0617ULL, 0x0000001024257824ULL, 0x000fe200078e0229ULL,
0x00000000121f7faeULL, 0x0003e2000b901c46ULL, 0x000000010b197824ULL, 0x040fe400008e0619ULL,
0x0000001026277824ULL, 0x100fe200078e0229ULL, 0x0000000014217faeULL, 0x0003e2000b901c46ULL,
0x0000001028297824ULL, 0x000fe400078e0229ULL, 0x000000010b0b7824ULL, 0x000fe200018e061dULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e8000b901c46ULL,
0x000000001a277faeULL, 0x0003e8000b901c46ULL, 0x000000000a297faeULL, 0x0003e4000b901c46ULL,
0x000000030c097812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd00447811ULL, 0x000fe400078e10ffULL, 0x000000030900780cULL, 0x000fe40003f05270ULL,
0xffffffff00547802ULL, 0x000fe40000000f00ULL, 0x0000000144557807ULL, 0x000fca0004000000ULL,
0x000000010c557824ULL, 0x000fca00078e0255ULL, 0x0000005b5500720cULL, 0x000fda0003f06070ULL,
0x00009600ff0c8b82ULL, 0x000e620000000800ULL, 0x0000000208098824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000c090c8224ULL, 0x002fc800078e020cULL,
0x000000010c098824ULL, 0x000fc800078e0255ULL, 0x00000004090a8825ULL, 0x004fca00078e000aULL,
0x000000060a548981ULL, 0x000322000c1e1900ULL, 0x0000005a6000720cULL, 0x000fe20003f06070ULL,
0xff317217ff527424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff567224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000006000f40947ULL, 0x002fec0003800000ULL, 0x00009600ff097b82ULL, 0x000e620000000800ULL,
0x0000000208087824ULL, 0x000fe200078e00ffULL, 0x000000ff001b7202ULL, 0x000fe20000000f00ULL,
0xff317217ff527424ULL, 0x000fe400078e00ffULL, 0x0000000908087224ULL, 0x002fce00078e0209ULL,
0x00009000ff147b82ULL, 0x000e620000000a00ULL, 0x000000105d167824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001601d7836ULL, 0x000fe40000000000ULL,
0x0000000454547c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe016177812ULL, 0x000fe400078ec0ffULL,
0x0000005a1d00720cULL, 0x000fc60003f06070ULL, 0x0000010060177824ULL, 0x000fc800078e0217ULL,
0x00000040171f7836ULL, 0x000fe20000000000ULL, 0x0000000654177819ULL, 0x000fc800000006ffULL,
0x000000201f167812ULL, 0x000fe200078ec0ffULL, 0x0000010017147825ULL, 0x002fc800078e0014ULL,
0x0000000145237824ULL, 0x000fe200078e0216ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x00000010041c7824ULL, 0x000fe200078e00ffULL,
0x0000001f5c167248ULL, 0x000fe20007fe0000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0a1fULL,
0x00000003ff257819ULL, 0x100fe20000011604ULL, 0x000000805d177824ULL, 0x040fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x000020005d1e7824ULL, 0x000fe200078e00ffULL,
0x0000002016207446ULL, 0x000fe2000380001dULL, 0x0000000125217824ULL, 0x000fe200078e0204ULL,
0x000000801c167812ULL, 0x000fe200078ef817ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x00000023251d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000425277836ULL, 0x000fe20000000000ULL,
0x0000000253537211ULL, 0x000fe200078e70ffULL, 0x0000000c25417836ULL, 0x000fe20000000000ULL,
0x000020001e1e7812ULL, 0x000fe200078ec0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0016ULL,
0x0000000721217812ULL, 0x000fc400078ec0ffULL, 0x000000202500720cULL, 0x080fe20003f26070ULL,
0x0000000127247824ULL, 0x040fe200078e0204ULL, 0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL,
0x00000008273d7824ULL, 0x000fe200078e00ffULL, 0x0001400053227810ULL, 0x000fe20007ffe01eULL,
0x00000001271f7824ULL, 0x000fe200078e0223ULL, 0x0ffffff821217812ULL, 0x000fe200078ef804ULL,
0x00000001151d7824ULL, 0x000fe200000e061dULL, 0x000000202700720cULL, 0x000fe20003f06070ULL,
0x000001001f1e7825ULL, 0x000fe200078e0016ULL, 0x0000002221217211ULL, 0x000fc400078e20ffULL,
0xfffffff83d277812ULL, 0x000fe200078ee224ULL, 0x00000008253d7836ULL, 0x000fe20000000000ULL,
0x0000001e141e7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e2000c901c46ULL, 0x0000001025437836ULL, 0x000fe20000000000ULL,
0x0000001425497810ULL, 0x000fe20007ffe0ffULL, 0x000000083d3f7824ULL, 0x040fe200078e00ffULL,
0x000000203d00720cULL, 0x080fe20003fc6070ULL, 0x00000018254b7836ULL, 0x000fe20000000000ULL,
0x000000204100720cULL, 0x000fe20003fa6070ULL, 0x0000001c254d7836ULL, 0x000fe20000000000ULL,
0x0000002227257211ULL, 0x000fe200078e20ffULL, 0x00000001151f7824ULL, 0x000fe200010e061fULL,
0x000000204300720cULL, 0x080fe20003f86070ULL, 0x0000000141247824ULL, 0x100fe200078e0204ULL,
0x000000204900720cULL, 0x080fe20003f66070ULL, 0x000000013d1c7824ULL, 0x042fe200078e0204ULL,
0x000000001e257faeULL, 0x0003e2000c101c46ULL, 0x000000013d1d7824ULL, 0x100fe200078e0223ULL,
0x000000204b00720cULL, 0x080fe20003f46070ULL, 0x0000000141217824ULL, 0x000fe200078e0223ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee21cULL, 0x000001001d1c7825ULL, 0x000fe200078e0016ULL,
0x000000204d00720cULL, 0x000fc40003f26070ULL, 0x0000002343277210ULL, 0x000fe20007ffe0ffULL,
0x0000000143267824ULL, 0x000fe200078e0204ULL, 0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000841417824ULL, 0x000fe200078e00ffULL, 0x00000003493d7819ULL, 0x000fe200000006ffULL,
0x0000000843437824ULL, 0x000fe400078e00ffULL, 0x0000010021207825ULL, 0x000fe200078e0016ULL,
0xfffffff841417812ULL, 0x000fe400078ee224ULL, 0xfffffff843437812ULL, 0x000fe200078ee226ULL,
0x00000001151d7824ULL, 0x000fe200000e061dULL, 0x00000020141e7210ULL, 0x002fe20007f1e0ffULL,
0x0000010027267825ULL, 0x000fc800078e0016ULL, 0x0000000149247824ULL, 0x140fe400078e0204ULL,
0x0000000149257824ULL, 0x000fe400078e0223ULL, 0x00000001151f7824ULL, 0x000fe200000e0621ULL,
0x0000002614207210ULL, 0x000fe20007f1e0ffULL, 0x000000014b3c7824ULL, 0x000fe200078e0204ULL,
0xfffffff83d497812ULL, 0x000fe200078ee224ULL, 0x0000010025247825ULL, 0x000fc800078e0016ULL,
0x000000014b3d7824ULL, 0x000fe200078e0223ULL, 0x000000234d237210ULL, 0x000fe20007ffe0ffULL,
0x0000000115217824ULL, 0x000fe200000e0627ULL, 0x0000002414247210ULL, 0x000fe20007f1e0ffULL,
0x000001003d267825ULL, 0x000fc600078e0016ULL, 0x0000002515257210ULL, 0x000fe200007fe4ffULL,
0x000000084b4b7824ULL, 0x000fe200078e00ffULL, 0x0000002614267210ULL, 0x000fe20007f1e0ffULL,
0x000000014d3d7824ULL, 0x040fe400078e0204ULL, 0x000000084d3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee23cULL, 0x0000010023167825ULL, 0x000fc600078e0016ULL,
0xfffffff83e4d7812ULL, 0x000fe200078ee23dULL, 0x0000000115277824ULL, 0x000fe200000e0627ULL,
0x0000001614147210ULL, 0x000fe20007f1e0ffULL, 0x000000103f237824ULL, 0x100fe400078e0222ULL,
0x00000010413d7824ULL, 0x100fe200078e0222ULL, 0x0000002249417211ULL, 0x000fe200078e20ffULL,
0x00000010433f7824ULL, 0x100fe200078e0222ULL, 0x000000001c237faeULL, 0x0003e2000f101c46ULL,
0x000000104b437824ULL, 0x100fe400078e0222ULL, 0x000000104d497824ULL, 0x000fe200078e0222ULL,
0x000000001e3d7faeULL, 0x0003e2000e901c46ULL, 0x0000000115157824ULL, 0x000fc600000e0617ULL,
0x00000000203f7faeULL, 0x0003e8000e101c46ULL, 0x0000000024417faeULL, 0x0003e8000d901c46ULL,
0x0000000026437faeULL, 0x0003e8000d101c46ULL, 0x0000000014497faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000000404217811ULL, 0x040fe200078fe8ffULL,
0x000000805d177824ULL, 0x040fe200078e00ffULL, 0x0000000404167819ULL, 0x040fe200000006ffULL,
0x000020005d1c7824ULL, 0x000fe200078e00ffULL, 0x00000008041e7811ULL, 0x000fe200078fe8ffULL,
0x00000001211d7824ULL, 0x040fe200078e0204ULL, 0x0000007016167812ULL, 0x000fe200078ec0ffULL,
0x0000000821207824ULL, 0x000fe200078e00ffULL, 0x0000001004277811ULL, 0x000fe200078fe8ffULL,
0x0000400053537824ULL, 0x000fe200078e0202ULL, 0x0000008016167812ULL, 0x000fe200078ef817ULL,
0x0000000121217824ULL, 0x000fe200078e0223ULL, 0xfffffff820417812ULL, 0x000fe200078ee21dULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x000000041e177210ULL, 0x000fe20007ffe0ffULL,
0x00000001271f7824ULL, 0x000fe200078e0204ULL, 0x0000000c04257811ULL, 0x000fc400078fe8ffULL,
0xfffffff820437812ULL, 0x000fe400078ee217ULL, 0x0000000404177211ULL, 0x040fe200078fe8ffULL,
0x00000001251d7824ULL, 0x000fe200078e0204ULL, 0x0000000327247819ULL, 0x000fe200000006ffULL,
0x0000000825227824ULL, 0x040fe200078e00ffULL, 0x00000018044f7811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x000fe200078e0223ULL, 0x000020001c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000717177812ULL, 0x000fc400078ec0ffULL, 0x00000014043d7811ULL, 0x040fe400078fe8ffULL,
0xfffffff8244b7812ULL, 0x000fe200078ee21fULL, 0x000000014f1f7824ULL, 0x000fe200078e0204ULL,
0x00014000531c7810ULL, 0x000fe20007ffe01cULL, 0x000000084f247824ULL, 0x040fe200078e00ffULL,
0x0000001c04537811ULL, 0x040fe200078fe8ffULL, 0x000000014f4f7824ULL, 0x100fe200078e0223ULL,
0x0ffffff817177812ULL, 0x000fe200078ef804ULL, 0x0000001043437824ULL, 0x000fe200078e021cULL,
0xfffffff822497812ULL, 0x000fe200078ee21dULL, 0x000000013d1d7824ULL, 0x040fe200078e0204ULL,
0xfffffff824517812ULL, 0x000fe200078ee21fULL, 0x000000083d227824ULL, 0x000fe200078e00ffULL,
0x00000023041f7211ULL, 0x000fe200078fe8ffULL, 0x0000000853577824ULL, 0x000fe200078e00ffULL,
0x0000000453207210ULL, 0x000fe20007ffe0ffULL, 0x00000010173f7824ULL, 0x000fe200078e021cULL,
0xfffffff8224d7812ULL, 0x000fe200078ee21dULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee220ULL, 0x000000011e1d7824ULL, 0x000fe200078e0223ULL,
0x0000002327277210ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0016ULL,
0x0000001c41417211ULL, 0x000fc400078e20ffULL, 0x0000001c51517211ULL, 0x000fe200078e20ffULL,
0x0000010021207825ULL, 0x000fe200078e0016ULL, 0x0000001e141e7210ULL, 0x000fc60007f1e0ffULL,
0x000000013d3d7824ULL, 0x100fe200078e0223ULL, 0x0000002014207210ULL, 0x000fe20007f3e0ffULL,
0x0000000153537824ULL, 0x000fe400078e0223ULL, 0x000001001d227825ULL, 0x000fc800078e0016ULL,
0x0000010025247825ULL, 0x000fe200078e0016ULL, 0x0000002214227210ULL, 0x000fc60007f5e0ffULL,
0x0000010027267825ULL, 0x000fe200078e0016ULL, 0x0000002414247210ULL, 0x000fe40007f7e0ffULL,
0x0000002315237210ULL, 0x000fe200017fe4ffULL, 0x0000001049497824ULL, 0x100fe400078e021cULL,
0x000000104b4b7824ULL, 0x100fe400078e021cULL, 0x000000104d4d7824ULL, 0x100fe400078e021cULL,
0x0000001057577824ULL, 0x000fc400078e021cULL, 0x000001003d3c7825ULL, 0x000fc800078e0016ULL,
0x000001004f1c7825ULL, 0x000fc800078e0016ULL, 0x0000010053167825ULL, 0x000fe200078e0016ULL,
0x0000001c141c7210ULL, 0x000fc60007f5e0ffULL, 0x00000001151f7824ULL, 0x040fe200000e061fULL,
0x0000002614267210ULL, 0x000fe20007f1e0ffULL, 0x0000000115217824ULL, 0x040fe200008e0621ULL,
0x0000003c143c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000115257824ULL, 0x040fe200018e0625ULL,
0x0000001614147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115277824ULL, 0x040fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e3f7faeULL, 0x0003e2000b901c46ULL,
0x00000001153d7824ULL, 0x040fe400008e063dULL, 0x00000001151d7824ULL, 0x000fe200010e061dULL,
0x0000000020417faeULL, 0x0003e2000b901c46ULL, 0x0000001715157210ULL, 0x000fc60001ffe4ffULL,
0x0000000022437faeULL, 0x0003e8000b901c46ULL, 0x0000000024497faeULL, 0x0003e8000b901c46ULL,
0x00000000264b7faeULL, 0x0003e8000b901c46ULL, 0x000000003c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c517faeULL, 0x0003e8000b901c46ULL, 0x0000000014577faeULL, 0x0003e4000b901c46ULL,
0x0000000355147812ULL, 0x002fe200078ec0ffULL, 0xffffffffff5f7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000031400780cULL, 0x000fc80003f05270ULL,
0x0000000144147807ULL, 0x000fca0004000000ULL, 0x0000000114597824ULL, 0x000fca00078e0255ULL,
0x0000005b5900720cULL, 0x000fda0003f06070ULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x0000000108178824ULL, 0x000fe200078e0259ULL, 0x0000001048167812ULL, 0x040fe400078ec0ffULL,
0x00000001001d7802ULL, 0x000fe20000000f00ULL, 0x0000000417148825ULL, 0x002fe200078e0014ULL,
0xffffffe048177812ULL, 0x000fc800078ec0ffULL, 0x0000000216167210ULL, 0x000fe20007ffe017ULL,
0x00000006145f8981ULL, 0x000322000c1e1900ULL, 0x0000000848177812ULL, 0x000fca00078ec0ffULL,
0x0000000116587824ULL, 0x000fc800078e0217ULL, 0x01b6081d581c79a7ULL, 0x0002a6000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x01b6081d580075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fce00078e00ffULL,
0x000000101e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x00000016141f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000001f16167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011e1e7836ULL, 0x000fce0000000000ULL,
0x01b6081d580075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000404407819ULL, 0x000fe200000006ffULL, 0x0000008047147824ULL, 0x000fe200078e0202ULL,
0x00000001ff517819ULL, 0x000fe20000011604ULL, 0x000000ffff577224ULL, 0x000fe200078e0052ULL,
0x0000007040407812ULL, 0x000fe400078ec0ffULL, 0x0000000c51517812ULL, 0x000fc800078ec0ffULL,
0x0000001451147210ULL, 0x000fca0007ffe040ULL, 0x01b0000014157984ULL, 0x000e680000000800ULL,
0x01b2000014617984ULL, 0x0004a20000000800ULL, 0x000000521500720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff16177812ULL, 0x000fda000782c0ffULL, 0x0000000000f09947ULL, 0x004fea0003800000ULL,
0x0000005d4700720cULL, 0x000fe40003f45270ULL, 0x000000521500720bULL, 0x0c0fe40003f34000ULL,
0x0000005215577209ULL, 0x000fd20007810000ULL, 0x000000805d14a824ULL, 0x000fe400078e0202ULL,
0x00000000001c7806ULL, 0x000fc600008e0100ULL, 0x000000145114a210ULL, 0x000fe40007ffe040ULL,
0x000099101c167816ULL, 0x000fc600000000ffULL, 0x01b400571400a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f25270ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x0000005257147221ULL, 0x000fe20000010100ULL, 0x000000ff1cff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff001cff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x00000014001d7308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc0000011604ULL, 0x00001f141d147589ULL, 0x004e6400000e0000ULL,
0x0000001428287220ULL, 0x082fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001434347220ULL, 0x080fe20000410000ULL, 0x0000001435357220ULL, 0x080fe20000410000ULL,
0x0000001438387220ULL, 0x080fe20000410000ULL, 0x0000001439397220ULL, 0x080fe20000410000ULL,
0x000000140c0c7220ULL, 0x080fe20000410000ULL, 0x000000140d0d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x080fe20000410000ULL,
0x0000001418187220ULL, 0x080fe20000410000ULL, 0x0000001419197220ULL, 0x000fce0000410000ULL,
0x0000001d56567220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000804147811ULL, 0x002fcc00078ff0ffULL, 0x00001f141d147589ULL, 0x000e6400000e0000ULL,
0x000000142a2a7220ULL, 0x082fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000140e0e7220ULL, 0x080fe20000410000ULL, 0x000000140f0f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x080fe20000410000ULL,
0x000000141a1a7220ULL, 0x080fe20000410000ULL, 0x000000141b1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff17ff7812ULL, 0x000fda000782601cULL, 0x8000005715151221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b15151820ULL, 0x000fc80000410000ULL,
0x00000015000b1308ULL, 0x000ea40000000800ULL, 0x0000000b61611220ULL, 0x004fce0000410000ULL,
0x00000007044b7812ULL, 0x040fe200078ec0ffULL, 0x0000080047497824ULL, 0x000fe200078e0202ULL,
0x00000008044a7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004ff4d7819ULL, 0x000fe40000011604ULL, 0x0000004b4a147212ULL, 0x002fe400078efcffULL,
0x000000015d4e7819ULL, 0x000fe400000006ffULL, 0x000000084b4c7812ULL, 0x000fe200078ef804ULL,
0x000000014d1c7824ULL, 0x000fe200078e0214ULL, 0x000000044e157812ULL, 0x000fe200078ec0ffULL,
0x0000000814177824ULL, 0x000fe200078e00ffULL, 0x00000001ff547819ULL, 0x000fe2000001165dULL,
0x000000021c427836ULL, 0x000fe20000000000ULL, 0x0000001504157211ULL, 0x000fe200078fe0ffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x0000000254557211ULL, 0x000fe200078e70ffULL,
0x000000041c417836ULL, 0x000fe20000000000ULL, 0xfffffff817427812ULL, 0x000fe200078ee242ULL,
0x000000084c177824ULL, 0x000fe200078e00ffULL, 0x0000000314437819ULL, 0x000fe200000006ffULL,
0x000000014c527824ULL, 0x000fe200078e0215ULL, 0xfffffff816417812ULL, 0x000fe200078ee241ULL,
0x0000200007627824ULL, 0x000fe200078e0255ULL, 0xfffffff843437812ULL, 0x000fe200078ee21cULL,
0x00000008141e7824ULL, 0x000fe200078e00ffULL, 0xfffffff817507812ULL, 0x000fe200078ee252ULL,
0x0001300062627836ULL, 0x000fc80000000000ULL, 0x0000001050167824ULL, 0x000fe200078e0249ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff177819ULL, 0x000fe40000011604ULL,
0x0000000bff09723eULL, 0x000fc600000000ffULL, 0x0000000817157836ULL, 0x000fe20000000000ULL,
0x0000541009147816ULL, 0x000fca0000000009ULL, 0x00001f17140a7589ULL, 0x0002a800000e0000ULL,
0x00001f1514097589ULL, 0x0002e400000e0000ULL, 0x011000001614783bULL, 0x002e620000000200ULL,
0x0000006243537211ULL, 0x000fe200078e20ffULL, 0x00000010423c7824ULL, 0x100fe400078e0262ULL,
0x0000001041247824ULL, 0x000fe200078e0262ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000a14147232ULL, 0x086fe40000000000ULL, 0x0000000a16167232ULL, 0x000fe40000000000ULL,
0x0000000915157232ULL, 0x088fe40000000000ULL, 0x0000000917177232ULL, 0x000fce0000000000ULL,
0x000000061c4f7836ULL, 0x000fe20000000000ULL, 0x000000002424783bULL, 0x000f620000004200ULL,
0x0000004d544d7211ULL, 0x000fe400078e10ffULL, 0x000000104a4b7812ULL, 0x000fe200078efe4bULL,
0x000000005320783bULL, 0x000b620000004200ULL, 0xfffffff81e4f7812ULL, 0x000fe400078ee24fULL,
0x000000024d4d7810ULL, 0x000fe20007ffe04cULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000084c4c7824ULL, 0x000fc400078e00ffULL, 0x000000104f1c7824ULL, 0x000fc600078e0262ULL,
0xfffffff84c537812ULL, 0x024fe400078ee24dULL, 0x0000004b044d7211ULL, 0x000fe200078fe0ffULL,
0x000000001c1c783bULL, 0x000ea80000004200ULL, 0x000000024d4c7836ULL, 0x000fe40000000000ULL,
0x000000064d4a7836ULL, 0x000fe20000000000ULL, 0x000000241438723cULL, 0x00afec0000001838ULL,
0x000000201428723cULL, 0x000fe20000001828ULL, 0x000000084b247824ULL, 0x040fe200078e00ffULL,
0x000000034b257819ULL, 0x000fc800000006ffULL, 0x0000003c1430723cULL, 0x000fe20000001830ULL,
0xfffffff8254a7812ULL, 0x000fca00078ee24aULL, 0x0000001c1410723cULL, 0x004fec0000001810ULL,
0x0000003e1434723cULL, 0x000fe20000001834ULL, 0x000000084b1c7824ULL, 0x040fe400078e00ffULL,
0x000000084b1d7824ULL, 0x000fe400078e00ffULL, 0x000000044d4b7836ULL, 0x000fe20000000000ULL,
0xfffffff81c4d7812ULL, 0x000fe200078ee24dULL, 0x00000010531c7824ULL, 0x000fe200078e0249ULL,
0xfffffff81d4c7812ULL, 0x000fe200078ee24cULL, 0x00000026140c723cULL, 0x000fe2000000180cULL,
0xfffffff8244b7812ULL, 0x000fc600078ee24bULL, 0x000000104c3c7824ULL, 0x000fe400078e0262ULL,
0x000000221420723cULL, 0x000fe2000000182cULL, 0x000000624d267211ULL, 0x000fca00078e20ffULL,
0x0000001e1418723cULL, 0x000fe20000001818ULL, 0x000000104b2c7824ULL, 0x000fe200078e0262ULL,
0x011000001c14783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000a14147232ULL, 0x084fe40000000000ULL,
0x0000000a16167232ULL, 0x000fe40000000000ULL, 0x0000000915157232ULL, 0x080fe40000000000ULL,
0x0000000917177232ULL, 0x000fce0000000000ULL, 0x000000104a1c7824ULL, 0x002fe200078e0262ULL,
0x000000002624783bULL, 0x000e620000004200ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000005661617221ULL, 0x000fe20000010000ULL, 0x000000045f5f7c24ULL, 0x010fe2000f8e02ffULL,
0x000000003c3c783bULL, 0x000ee60000004200ULL, 0x000000405f5f7824ULL, 0x000fe200078e00ffULL,
0x000000002c2c783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f620000004200ULL,
0x000000241428723cULL, 0x006fe20000001828ULL, 0x00009000ff247b82ULL, 0x000e6a0000000a00ULL,
0x0000003c1430723cULL, 0x008fec0000001830ULL, 0x0000003e1434723cULL, 0x000fec0000001834ULL,
0x0000002c1438723cULL, 0x010fe20000001838ULL, 0x00000001ff3e7424ULL, 0x000fca00078e00ffULL,
0x0000002e140c723cULL, 0x000fe2000000180cULL, 0x000001005f247825ULL, 0x002fca00078e0024ULL,
0x000000261420723cULL, 0x000fec0000001820ULL, 0x0000001c1410723cULL, 0x020fec0000001810ULL,
0x0000001e1414723cULL, 0x000fe20000001818ULL, 0xfffffff84e1d7812ULL, 0x000fc800078ec0ffULL,
0x0000001d024e7210ULL, 0x000fe40007ffe0ffULL, 0x00000001601b7836ULL, 0x000fe40000000000ULL,
0x0000000860187824ULL, 0x000fe200078e0254ULL, 0x01b6883e4eff79a7ULL, 0x0003e4000850003fULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x0000008018197811ULL, 0x000fc800078e28ffULL,
0x0000002019187812ULL, 0x000fca00078ec0ffULL, 0x00000001452f7824ULL, 0x000fe200078e0218ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff5f7819ULL, 0x100fe40000011604ULL, 0x000000195c2e7248ULL, 0x000fe20007fe0000ULL,
0x000000ffff197224ULL, 0x000fe200078e0a19ULL, 0x0000000d5d187819ULL, 0x040fe200000006ffULL,
0x000000045f1f7836ULL, 0x000fe20000000000ULL, 0x000000075d1b7819ULL, 0x000fe200000006ffULL,
0x000000085f637836ULL, 0x000fe20000000000ULL, 0x000000202e2e7446ULL, 0x000fe20003800019ULL,
0x000000011f1a7824ULL, 0x140fe200078e0204ULL, 0x0000200018187812ULL, 0x000fe200078ec0ffULL,
0x000000081f1d7824ULL, 0x040fe200078e00ffULL, 0x0000002e1f00720cULL, 0x080fe20003f26070ULL,
0x000000015f197824ULL, 0x000fe200078e0204ULL, 0x0001300055557810ULL, 0x000fe20007ffe018ULL,
0x0000000c5f657836ULL, 0x000fe20000000000ULL, 0xfffffff81d567812ULL, 0x000fe200078ee21aULL,
0x000000015f1d7824ULL, 0x100fe200078e022fULL, 0x0000008040187812ULL, 0x000fe200078ef81bULL,
0x0000000163277824ULL, 0x100fe200078e022fULL, 0x00000007192d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000002f1f1b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001651f7824ULL, 0x000fe200078e022fULL, 0x0000002e5f00720cULL, 0x000fe20003f06070ULL,
0x000001001d1c7825ULL, 0x000fe200078e0018ULL, 0x0ffffff82d3c7812ULL, 0x000fc400078ef804ULL,
0x000000105f677810ULL, 0x000fe20007ffe0ffULL, 0x000001001b1a7825ULL, 0x100fe200078e0018ULL,
0x0000001c241c7210ULL, 0x000fe40007f5e0ffULL, 0x0000002e6500720cULL, 0x080fe20003f86070ULL,
0x0000010027267825ULL, 0x100fe200078e0018ULL, 0x0000001a241a7210ULL, 0x000fe40007f7e0ffULL,
0x0000002e6300720cULL, 0x000fe20003fa6070ULL, 0x000001001f1e7825ULL, 0x000fe200078e0018ULL,
0x0000001b251b7210ULL, 0x000fc60001ffe4ffULL, 0x00000001251d7824ULL, 0x040fe200010e061dULL,
0x00000026242c7210ULL, 0x000fe20007f5e0ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0255ULL,
0x0000001e24267210ULL, 0x000fe20007f7e0ffULL, 0x00000010563f7824ULL, 0x000fe400078e0255ULL,
0x00000001252d7824ULL, 0x040fe200010e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c3d7faeULL, 0x0003e2000c101c46ULL, 0x0000000125277824ULL, 0x000fe200018e061fULL,
0x0000002f671f7210ULL, 0x000fe20007ffe0ffULL, 0x000000145f697836ULL, 0x000fe20000000000ULL,
0x000000001a3f7faeULL, 0x0005e2000c901c46ULL, 0x000000185f6b7836ULL, 0x000fe20000000000ULL,
0x0000002e6700720cULL, 0x080fe20003f66070ULL, 0x0000001c5f5f7836ULL, 0x000fe20000000000ULL,
0x0000002e6900720cULL, 0x080fe20003f46070ULL, 0x0000000867567824ULL, 0x000fe200078e00ffULL,
0x0000002e6b00720cULL, 0x080fe20003f26070ULL, 0x00000001633c7824ULL, 0x100fe200078e0204ULL,
0x0000002e5f00720cULL, 0x000fe20003f06070ULL, 0x00000001691d7824ULL, 0x002fe200078e022fULL,
0x0000002f6b3d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001651c7824ULL, 0x000fc400078e0204ULL,
0x000001001f1a7825ULL, 0x004fc800078e0018ULL, 0x0000000865657824ULL, 0x000fe200078e00ffULL,
0x0000001a241e7210ULL, 0x000fe20007fde0ffULL, 0x0000000863637824ULL, 0x000fe400078e00ffULL,
0x00000001693f7824ULL, 0x000fe200078e0204ULL, 0x0000001b251f7210ULL, 0x000fe200037fe4ffULL,
0x000001001d1a7825ULL, 0x000fe200078e0018ULL, 0xfffffff8652e7812ULL, 0x000fe400078ee21cULL,
0xfffffff8633c7812ULL, 0x000fe200078ee23cULL, 0x00000001671d7824ULL, 0x000fe200078e0204ULL,
0x0000001a241c7210ULL, 0x000fe20007fde0ffULL, 0x0000000869627824ULL, 0x000fc400078e00ffULL,
0x000000015f2f7824ULL, 0x000fe200078e022fULL, 0xfffffff856567812ULL, 0x000fe200078ee21dULL,
0x00000001251d7824ULL, 0x000fe200030e061bULL, 0xfffffff862627812ULL, 0x000fe200078ee23fULL,
0x000001003d1a7825ULL, 0x000fe200078e0018ULL, 0x000000045f3f7210ULL, 0x000fc60007ffe0ffULL,
0x000000016b3d7824ULL, 0x040fe200078e0204ULL, 0x0000001a241a7210ULL, 0x000fe20007fde0ffULL,
0x000000086b647824ULL, 0x000fe400078e00ffULL, 0x000000085f667824ULL, 0x000fe400078e00ffULL,
0x000001002f187825ULL, 0x000fe200078e0018ULL, 0xfffffff864647812ULL, 0x000fe400078ee23dULL,
0xfffffff866667812ULL, 0x000fe200078ee23fULL, 0x00000001251b7824ULL, 0x000fe200030e061bULL,
0x0000001824187210ULL, 0x000fe20007fde0ffULL, 0x000000103c2f7824ULL, 0x100fe200078e0255ULL,
0x00000055563f7211ULL, 0x000fe200078e20ffULL, 0x000000102e3d7824ULL, 0x000fc400078e0255ULL,
0x00000010625f7824ULL, 0x100fe200078e0255ULL, 0x000000002c2f7faeULL, 0x0003e2000e901c46ULL,
0x0000001064637824ULL, 0x100fe400078e0255ULL, 0x0000001066557824ULL, 0x000fe200078e0255ULL,
0x00000000263d7faeULL, 0x0003e2000e101c46ULL, 0x0000000125197824ULL, 0x000fc600030e0619ULL,
0x000000001e3f7faeULL, 0x0003e8000d901c46ULL, 0x000000001c5f7faeULL, 0x0003e8000d101c46ULL,
0x000000001a637faeULL, 0x0003e8000c901c46ULL, 0x0000000018557faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00000004041b7811ULL, 0x040fe400078fe8ffULL,
0x00000008042d7811ULL, 0x040fe400078fe8ffULL, 0x0000000d5d187819ULL, 0x000fe200000006ffULL,
0x000000011b687824ULL, 0x140fe200078e0204ULL, 0x00000014041d7811ULL, 0x000fe200078fe8ffULL,
0x000000081b197824ULL, 0x000fe200078e00ffULL, 0x0000200018187812ULL, 0x000fe200078ec0ffULL,
0x000000012d667824ULL, 0x100fe200078e0204ULL, 0x0000000c04277811ULL, 0x040fe200078fe8ffULL,
0x000000011d567824ULL, 0x000fe200078e0204ULL, 0xfffffff819687812ULL, 0x000fe200078ee268ULL,
0x000000082d197824ULL, 0x000fe200078e00ffULL, 0x0001300055557810ULL, 0x000fe20007ffe018ULL,
0x00000008273d7824ULL, 0x000fe200078e00ffULL, 0x0000000404187211ULL, 0x040fe200078fe8ffULL,
0x000000011b1b7824ULL, 0x100fe200078e022fULL, 0xfffffff819667812ULL, 0x000fe200078ee266ULL,
0x000000805d197824ULL, 0x000fe200078e00ffULL, 0x00000018041a7811ULL, 0x040fe200078fe8ffULL,
0x000000012d2d7824ULL, 0x000fe200078e022fULL, 0x00000010041f7811ULL, 0x000fc400078fe8ffULL,
0x0000000718637812ULL, 0x000fe200078ec0ffULL, 0x000000081a6c7824ULL, 0x040fe200078e00ffULL,
0x000000031d5f7819ULL, 0x000fe200000006ffULL, 0x000000011f627824ULL, 0x140fe200078e0204ULL,
0x0000008040187812ULL, 0x000fe200078ef819ULL, 0x000000011a197824ULL, 0x000fe200078e0204ULL,
0x0000000427647210ULL, 0x000fe20007ffe0ffULL, 0x000000081f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85f567812ULL, 0x000fe200078ee256ULL, 0x0000000127277824ULL, 0x100fe200078e022fULL,
0xfffffff83d647812ULL, 0x000fe200078ee264ULL, 0x000000011d1d7824ULL, 0x000fe200078e022fULL,
0x0000001c045f7811ULL, 0x000fe200078fe8ffULL, 0x0000001056697824ULL, 0x000fe200078e0255ULL,
0x0000002f043d7211ULL, 0x000fc400078fe8ffULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee219ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0xfffffff83f627812ULL, 0x000fe200078ee262ULL,
0x000000011a3f7824ULL, 0x100fe200078e022fULL, 0x000000045f1a7210ULL, 0x000fe20007ffe0ffULL,
0x000000085f657824ULL, 0x040fe200078e00ffULL, 0x0000002f1f1f7210ULL, 0x000fe20007ffe0ffULL,
0x000000015f5f7824ULL, 0x000fe200078e022fULL, 0x0ffffff8636a7812ULL, 0x000fe200078ef804ULL,
0x000001003d3c7825ULL, 0x000fe200078e0018ULL, 0xfffffff8656e7812ULL, 0x000fc400078ee21aULL,
0x000000556c6b7211ULL, 0x000fe200078e20ffULL, 0x000001001b2e7825ULL, 0x000fe200078e0018ULL,
0x0000003c243c7210ULL, 0x000fc60007f1e0ffULL, 0x000001002d2c7825ULL, 0x000fe200078e0018ULL,
0x0000002e242e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010027267825ULL, 0x000fe200078e0018ULL,
0x0000002c242c7210ULL, 0x000fc60007f5e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0018ULL,
0x0000002624267210ULL, 0x000fc60007f7e0ffULL, 0x000001001d1a7825ULL, 0x000fe200078e0018ULL,
0x0000002725277210ULL, 0x000fc60001ffe4ffULL, 0x000001003f1c7825ULL, 0x000fc800078e0018ULL,
0x000001005f187825ULL, 0x000fe200078e0018ULL, 0x00000055685f7211ULL, 0x000fc600078e20ffULL,
0x00000001253d7824ULL, 0x040fe200000e063dULL, 0x0000001e241e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001252f7824ULL, 0x040fe200008e062fULL, 0x0000001a241a7210ULL, 0x000fe20007f3e0ffULL,
0x000000106a3f7824ULL, 0x000fe200078e0255ULL, 0x0000001824187210ULL, 0x000fe20007f7e0ffULL,
0x00000001252d7824ULL, 0x000fe200010e062dULL, 0x0000001c241c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001066637824ULL, 0x100fe200078e0255ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c3f7faeULL, 0x0003e2000b901c46ULL, 0x0000001064657824ULL, 0x000fc400078e0255ULL,
0x0000001062677824ULL, 0x000fe200078e0255ULL, 0x000000002e5f7faeULL, 0x0003e2000b901c46ULL,
0x00000001251f7824ULL, 0x040fe400000e061fULL, 0x00000001251b7824ULL, 0x040fe200008e061bULL,
0x000000002c637faeULL, 0x0003e2000b901c46ULL, 0x00000001251d7824ULL, 0x040fe400010e061dULL,
0x000000106e557824ULL, 0x000fe200078e0255ULL, 0x0000000026657faeULL, 0x0003e2000b901c46ULL,
0x0000000125197824ULL, 0x000fc600018e0619ULL, 0x000000001e677faeULL, 0x0003e8000b901c46ULL,
0x000000001a697faeULL, 0x0003e8000b901c46ULL, 0x000000001c6b7faeULL, 0x0003e8000b901c46ULL,
0x0000000018557faeULL, 0x0003e4000b901c46ULL, 0x0000000359187812ULL, 0x002fe200078ec0ffULL,
0xffffffffff5f7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000031800780cULL, 0x000fc80003f05270ULL, 0x0000000144187807ULL, 0x000fc80004000000ULL,
0x0000001859557210ULL, 0x000fc80007ffe0ffULL, 0x0000005b5500720cULL, 0x000fda0003f06070ULL,
0x00009200ff188b82ULL, 0x000e620000000a00ULL, 0x00000001081b8824ULL, 0x000fc800078e0255ULL,
0x000000041b188825ULL, 0x002fca00078e0018ULL, 0x00000006185f8981ULL, 0x000322000c1e1900ULL,
0x01b6283e583e79a7ULL, 0x0002a4000850003fULL, 0x0000000000187805ULL, 0x002fce0000015200ULL,
0xffffffe0481b7812ULL, 0x040fe400078ec0ffULL, 0x00000010481a7812ULL, 0x040fe400078ec0ffULL,
0x0000000848567812ULL, 0x000fe400078ec0ffULL, 0x000000021a1b7210ULL, 0x000fca0007ffe01bULL,
0x000000011b567824ULL, 0x000fc800078e0256ULL, 0x01b6283f560075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181d7210ULL, 0x000fc80007f1e1ffULL,
0x0000001b191b7210ULL, 0x000fe400007fe5ffULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01b6283f560075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000205d187824ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fc600078e0057ULL,
0xffffff8018197812ULL, 0x000fc800078ec0ffULL, 0x0000008002197810ULL, 0x000fc80007ffe019ULL,
0x0000001951197210ULL, 0x000fca0007ffe040ULL, 0x01b0000019187984ULL, 0x000e680000000800ULL,
0x01b2000019597984ULL, 0x0004a20000000800ULL, 0x000000571800720bULL, 0x002fda0003f1d000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x00000001471a7810ULL, 0x000fe40007ffe0ffULL, 0x000000571800720bULL, 0x000fe40003f14000ULL,
0x0000005d1a00720cULL, 0x000fd60003f25270ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000805d1a9824ULL, 0x000fe200078e0202ULL, 0x0000005718199209ULL, 0x000fc80007810000ULL,
0x0000001a511e9210ULL, 0x000fe40007ffe040ULL, 0x000099101c1a7816ULL, 0x000fc600000000ffULL,
0x01b400191e009388ULL, 0x0003e20000000800ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x00000057181a7209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x000000571a197221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b19197820ULL, 0x000fc80000410000ULL,
0x00000019001a7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x002fcc0000011604ULL, 0x00001f191a197589ULL, 0x004e6400000e0000ULL,
0x0000002819287220ULL, 0x042fe20000410000ULL, 0x0000002919297220ULL, 0x040fe20000410000ULL,
0x0000002019207220ULL, 0x040fe20000410000ULL, 0x0000002119217220ULL, 0x040fe20000410000ULL,
0x0000003019307220ULL, 0x040fe20000410000ULL, 0x0000003119317220ULL, 0x040fe20000410000ULL,
0x0000003419347220ULL, 0x040fe20000410000ULL, 0x0000003519357220ULL, 0x040fe20000410000ULL,
0x0000003819387220ULL, 0x040fe20000410000ULL, 0x0000003919397220ULL, 0x040fe20000410000ULL,
0x0000000c190c7220ULL, 0x040fe20000410000ULL, 0x0000000d190d7220ULL, 0x040fe20000410000ULL,
0x0000001019107220ULL, 0x040fe20000410000ULL, 0x0000001119117220ULL, 0x040fe20000410000ULL,
0x0000001419147220ULL, 0x040fe20000410000ULL, 0x0000001519157220ULL, 0x000fce0000410000ULL,
0x0000001a61617220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000804197811ULL, 0x002fcc00078ff0ffULL, 0x00001f191a197589ULL, 0x000e6400000e0000ULL,
0x0000002a192a7220ULL, 0x042fe20000410000ULL, 0x0000002b192b7220ULL, 0x040fe20000410000ULL,
0x0000002219227220ULL, 0x040fe20000410000ULL, 0x0000002319237220ULL, 0x040fe20000410000ULL,
0x0000003219327220ULL, 0x040fe20000410000ULL, 0x0000003319337220ULL, 0x040fe20000410000ULL,
0x0000003619367220ULL, 0x040fe20000410000ULL, 0x0000003719377220ULL, 0x040fe20000410000ULL,
0x0000003a193a7220ULL, 0x040fe20000410000ULL, 0x0000003b193b7220ULL, 0x040fe20000410000ULL,
0x0000000e190e7220ULL, 0x040fe20000410000ULL, 0x0000000f190f7220ULL, 0x040fe20000410000ULL,
0x0000001219127220ULL, 0x040fe20000410000ULL, 0x0000001319137220ULL, 0x040fe20000410000ULL,
0x0000001619167220ULL, 0x040fe20000410000ULL, 0x0000001719177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x0000005718587209ULL, 0x000fd60007810000ULL,
0x8000005818180221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b18180820ULL, 0x000fc80000410000ULL,
0x00000018000b0308ULL, 0x000ea40000000800ULL, 0x0000000b59590220ULL, 0x004fce0000410000ULL,
0x000002005d187824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffff80018637812ULL, 0x000fe200078ec0ffULL, 0x0000400054547824ULL, 0x000fc600078e0202ULL,
0x0000006302637210ULL, 0x000fe20007ffe0ffULL, 0x0000200007627824ULL, 0x000fc800078e0254ULL,
0x0001400062627836ULL, 0x000fe40000000000ULL, 0x0000001050577824ULL, 0x000fe200078e0263ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x002fe40000011604ULL,
0x0000000bff09723eULL, 0x000fc600000000ffULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0x0000541009187816ULL, 0x000fca0000000009ULL, 0x00001f19180a7589ULL, 0x0002a800000e0000ULL,
0x00001f1b18097589ULL, 0x0002e400000e0000ULL, 0x011800005718783bULL, 0x0022e20000000200ULL,
0x0000001043647824ULL, 0x100fe200078e0262ULL, 0x00000062423c7211ULL, 0x000fe200078e20ffULL,
0x0000001041247824ULL, 0x000fe200078e0262ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000a18187232ULL, 0x08cfe40000000000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000919197232ULL, 0x080fe40000000000ULL, 0x000000091b1b7232ULL, 0x000fce0000000000ULL,
0x000000104f1c7824ULL, 0x000fe200078e0262ULL, 0x00000000642c783bULL, 0x000f620000004200ULL,
0x0000001053537824ULL, 0x000fc600078e0263ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000002424783bULL, 0x000f680000004200ULL, 0x000000001c1c783bULL, 0x000f640000004200ULL,
0x0000002c1828723cULL, 0x02afec0000001828ULL, 0x0000002e182c723cULL, 0x000fec0000001820ULL,
0x0000003c1830723cULL, 0x000fe20000001830ULL, 0x000000104b227824ULL, 0x000fca00078e0262ULL,
0x0000003e1834723cULL, 0x000fe20000001834ULL, 0x000000104d3c7824ULL, 0x000fca00078e0262ULL,
0x000000241838723cULL, 0x004fec0000001838ULL, 0x00000026180c723cULL, 0x000fe2000000180cULL,
0x000000624c247211ULL, 0x000fca00078e20ffULL, 0x0000001c1810723cULL, 0x000fec0000001810ULL,
0x0000001e1814723cULL, 0x000fe20000001814ULL, 0x011800005318783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000a18187232ULL, 0x084fe40000000000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000919197232ULL, 0x080fe40000000000ULL, 0x000000091b1b7232ULL, 0x000fce0000000000ULL,
0x000000104a1c7824ULL, 0x000fe200078e0262ULL, 0x000000002220783bULL, 0x000ee20000004200ULL,
0x00000001ff537819ULL, 0x002fe2000001165dULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000006159597221ULL, 0x000fe20000010000ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x000000045f5f7c24ULL, 0x010fc6000f8e02ffULL, 0x000000002424783bULL, 0x000f220000004200ULL,
0x000000405f5f7824ULL, 0x000fc600078e00ffULL, 0x000000001c1c783bULL, 0x000f620000004200ULL,
0x000000201838723cULL, 0x00cfe20000001838ULL, 0x00009000ff207b82ULL, 0x000eaa0000000a00ULL,
0x0000003c1828723cULL, 0x002fec0000001828ULL, 0x0000003e182c723cULL, 0x000fec000000182cULL,
0x000000241830723cULL, 0x010fe20000001830ULL, 0x00000001ff3e7424ULL, 0x000fc800078e00ffULL,
0x01b6903e4eff79a7ULL, 0x0003e2000850003fULL, 0x000000261834723cULL, 0x000fe20000001834ULL,
0x000001005f207825ULL, 0x004fca00078e0020ULL, 0x00000022180c723cULL, 0x000fec000000180cULL,
0x0000001c1810723cULL, 0x020fec0000001810ULL, 0x0000001e1814723cULL, 0x000fee0000001814ULL,
0x00000001601b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000860197824ULL, 0x000fc600078e0253ULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x000000c019197811ULL, 0x000fc800078e28ffULL,
0x0000002019187812ULL, 0x000fca00078ec0ffULL, 0x0000000145277824ULL, 0x000fe200078e0218ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff3d7819ULL, 0x100fe20000011604ULL, 0x000020005d187824ULL, 0x040fe200078e00ffULL,
0x000000195c267248ULL, 0x000fe20007fe0000ULL, 0x000000805d1b7824ULL, 0x000fe200078e00ffULL,
0x000000ff19197210ULL, 0x000fe20007ffe1ffULL, 0x000000043d1f7836ULL, 0x000fe20000000000ULL,
0x00002000181d7812ULL, 0x000fe200078ec0ffULL, 0x000000083d617836ULL, 0x000fe20000000000ULL,
0x0000002026267446ULL, 0x000fe20003800019ULL, 0x000000011f187824ULL, 0x140fe200078e0204ULL,
0x0001400054547810ULL, 0x000fe20007ffe01dULL, 0x000000081f5f7824ULL, 0x000fe200078e00ffULL,
0x000000273d1d7210ULL, 0x000fe20007ffe0ffULL, 0x000000013d197824ULL, 0x000fe200078e0204ULL,
0x0000002761237210ULL, 0x000fe20007ffe0ffULL, 0x0000000c3d637836ULL, 0x000fe20000000000ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee218ULL, 0x000000103d657836ULL, 0x000fe20000000000ULL,
0x0000008040187812ULL, 0x000fe200078ef81bULL, 0x000000011f1b7824ULL, 0x100fe200078e0227ULL,
0x0000000719257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000261f00720cULL, 0x080fe20003f26070ULL, 0x00000001631f7824ULL, 0x000fe200078e0227ULL,
0x000000263d00720cULL, 0x000fe20003f06070ULL, 0x000001001d1c7825ULL, 0x000fe200078e0018ULL,
0x0ffffff825257812ULL, 0x000fc400078ef804ULL, 0x000000266100720cULL, 0x080fe20003fa6070ULL,
0x000001001b1a7825ULL, 0x100fe200078e0018ULL, 0x0000001c201c7210ULL, 0x000fe40007f5e0ffULL,
0x000000183d697810ULL, 0x000fe20007ffe0ffULL, 0x0000010023227825ULL, 0x100fe200078e0018ULL,
0x0000001a201a7210ULL, 0x000fe40007f7e0ffULL, 0x000000266300720cULL, 0x000fe20003f86070ULL,
0x000001001f1e7825ULL, 0x000fc800078e0018ULL, 0x00000001211d7824ULL, 0x040fe200010e061dULL,
0x0000002220247210ULL, 0x000fe20007f5e0ffULL, 0x00000001211b7824ULL, 0x000fe200018e061bULL,
0x0000001e20227210ULL, 0x000fe20007f7e0ffULL, 0x00000010253f7824ULL, 0x100fe200078e0254ULL,
0x0000002321257210ULL, 0x000fe200017fe4ffULL, 0x000000105f5f7824ULL, 0x000fe400078e0254ULL,
0x0000000121237824ULL, 0x000fe200018e061fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c3f7faeULL, 0x0003e2000c101c46ULL, 0x00000001651f7824ULL, 0x040fe200078e0227ULL,
0x000000266500720cULL, 0x080fe20003f66070ULL, 0x000000143d677836ULL, 0x000fe20000000000ULL,
0x000000001a5f7faeULL, 0x0005e2000c901c46ULL, 0x00000001613c7824ULL, 0x000fe200078e0204ULL,
0x000000266900720cULL, 0x080fe20003f26070ULL, 0x0000000861617824ULL, 0x000fe200078e00ffULL,
0x000000266700720cULL, 0x000fe20003f46070ULL, 0x0000001c3d6b7836ULL, 0x000fc40000000000ULL,
0x00000001693d7824ULL, 0x100fe200078e0227ULL, 0x00000004631c7210ULL, 0x002fe20007ffe0ffULL,
0x00000001671d7824ULL, 0x000fe200078e0227ULL, 0xfffffff8613f7812ULL, 0x000fe200078ee23cULL,
0x000001001f1a7825ULL, 0x004fe200078e0018ULL, 0x00000003653c7819ULL, 0x000fe400000006ffULL,
0x000000266b00720cULL, 0x000fe20003f06070ULL, 0x00000008635f7824ULL, 0x000fe200078e00ffULL,
0x0000001a201e7210ULL, 0x000fe20007fde0ffULL, 0x0000000167267824ULL, 0x040fe200078e0204ULL,
0x000000276b277210ULL, 0x000fe20007ffe0ffULL, 0x0000000867637824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee21cULL, 0x00000001211f7824ULL, 0x000fc400030e061bULL,
0x000001001d1a7825ULL, 0x000fe200078e0018ULL, 0xfffffff863637812ULL, 0x000fc600078ee226ULL,
0x00000001651d7824ULL, 0x100fe200078e0204ULL, 0x0000001a201c7210ULL, 0x000fe20007fde0ffULL,
0x0000000169267824ULL, 0x040fe400078e0204ULL, 0x0000000869697824ULL, 0x000fe200078e00ffULL,
0xfffffff83c617812ULL, 0x000fe200078ee21dULL, 0x00000001211d7824ULL, 0x000fe400030e061bULL,
0x000001003d1a7825ULL, 0x000fc800078e0018ULL, 0x000000016b3c7824ULL, 0x040fe200078e0204ULL,
0x0000001a201a7210ULL, 0x000fe20007fde0ffULL, 0x000000086b3d7824ULL, 0x000fe400078e00ffULL,
0x0000010027187825ULL, 0x000fe200078e0018ULL, 0x0000001b211b7210ULL, 0x000fe400037fe4ffULL,
0xfffffff869277812ULL, 0x000fe200078ee226ULL, 0x000000103f3f7824ULL, 0x100fe200078e0254ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL, 0x000000105f5f7824ULL, 0x100fe200078e0254ULL,
0x0000001820187210ULL, 0x000fe20007fde0ffULL, 0x0000001061617824ULL, 0x100fe200078e0254ULL,
0x0000005427277211ULL, 0x000fe200078e20ffULL, 0x0000001063637824ULL, 0x100fe200078e0254ULL,
0x00000000243f7faeULL, 0x0003e2000e901c46ULL, 0x000000103d3d7824ULL, 0x000fc400078e0254ULL,
0x0000000121197824ULL, 0x000fe200030e0619ULL, 0x00000000225f7faeULL, 0x0003e8000e101c46ULL,
0x000000001e617faeULL, 0x0003e8000d901c46ULL, 0x000000001c637faeULL, 0x0003e8000d101c46ULL,
0x000000001a277faeULL, 0x0003e8000c901c46ULL, 0x00000000183d7faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x000020005d187824ULL, 0x000fe200078e00ffULL,
0x00000004041b7811ULL, 0x040fe400078fe8ffULL, 0x0000000804257811ULL, 0x000fe400078fe8ffULL,
0x0000200018197812ULL, 0x000fe200078ec0ffULL, 0x000000011b657824ULL, 0x140fe200078e0204ULL,
0x000000031b187819ULL, 0x000fe200000006ffULL, 0x0000000125637824ULL, 0x140fe200078e0204ULL,
0x0000000c04237811ULL, 0x040fe400078fe8ffULL, 0xfffffff818657812ULL, 0x000fe200078ee265ULL,
0x0000000825187824ULL, 0x000fe200078e00ffULL, 0x00000010041f7811ULL, 0x000fe200078fe8ffULL,
0x0000000123617824ULL, 0x040fe200078e0204ULL, 0x0001400054547810ULL, 0x000fe20007ffe019ULL,
0x00000008231a7824ULL, 0x000fe200078e00ffULL, 0xfffffff818637812ULL, 0x000fe200078ee263ULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0x0000000404187211ULL, 0x040fe200078fe8ffULL,
0x000000805d197824ULL, 0x000fe200078e00ffULL, 0xfffffff81a617812ULL, 0x000fe200078ee261ULL,
0x0000000125257824ULL, 0x100fe200078e0227ULL, 0x000000041f5f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000123237824ULL, 0x100fe200078e0227ULL, 0x00000018041a7811ULL, 0x000fe200078fe8ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0227ULL, 0x00000007186b7812ULL, 0x000fe200078ec0ffULL,
0x0000001065657824ULL, 0x000fe200078e0254ULL, 0xfffffff81c5f7812ULL, 0x000fe200078ee25fULL,
0x000000081a1c7824ULL, 0x040fe200078e00ffULL, 0x0000008040187812ULL, 0x000fe200078ef819ULL,
0x000000011a197824ULL, 0x000fe200078e0204ULL, 0x00000014041d7811ULL, 0x040fe200078fe8ffULL,
0x0000001063637824ULL, 0x100fe200078e0254ULL, 0x0000001c04697811ULL, 0x040fe200078fe8ffULL,
0x000000105f5f7824ULL, 0x000fe200078e0254ULL, 0x00000027043d7211ULL, 0x000fe200078fe8ffULL,
0x000000011d3f7824ULL, 0x140fe200078e0204ULL, 0xfffffff81c6d7812ULL, 0x000fe200078ee219ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000000271b1b7210ULL, 0x000fe20007ffe0ffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0x000000271a677210ULL, 0x000fe20007ffe0ffULL,
0x00000001691a7824ULL, 0x040fe200078e0204ULL, 0x0ffffff86b6b7812ULL, 0x000fe200078ef804ULL,
0x00000008696f7824ULL, 0x000fe200078e00ffULL, 0x0000002769697210ULL, 0x000fe20007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0227ULL, 0xfffffff81e3f7812ULL, 0x000fe200078ee23fULL,
0x000001003d3c7825ULL, 0x000fe200078e0018ULL, 0xfffffff86f6f7812ULL, 0x000fc400078ee21aULL,
0x0000005461617211ULL, 0x000fe200078e20ffULL, 0x000001001b267825ULL, 0x000fe200078e0018ULL,
0x0000003c203c7210ULL, 0x000fc60007f1e0ffULL, 0x0000010025247825ULL, 0x100fe200078e0018ULL,
0x0000002620267210ULL, 0x000fe40007f3e0ffULL, 0x0000003d213d7210ULL, 0x000fe200007fe4ffULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000002420247210ULL, 0x000fc60007f5e0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0018ULL, 0x0000002220227210ULL, 0x000fc60007f7e0ffULL,
0x000001001d1a7825ULL, 0x000fe200078e0018ULL, 0x0000001e201e7210ULL, 0x000fc60007f1e0ffULL,
0x00000100671c7825ULL, 0x000fc800078e0018ULL, 0x0000010069187825ULL, 0x000fc800078e0018ULL,
0x000000106b6b7824ULL, 0x100fe400078e0254ULL, 0x0000000121277824ULL, 0x040fe200008e0627ULL,
0x0000001a201a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000121257824ULL, 0x040fe200010e0625ULL,
0x0000001c201c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000121237824ULL, 0x040fe200018e0623ULL,
0x0000001820187210ULL, 0x000fe20007f7e0ffULL, 0x00000001211f7824ULL, 0x000fe200000e061fULL,
0x0000001b211b7210ULL, 0x000fe20000ffe4ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0254ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c6b7faeULL, 0x0003e2000b901c46ULL,
0x000000106d6d7824ULL, 0x000fc400078e0254ULL, 0x00000001211d7824ULL, 0x000fe200010e061dULL,
0x0000000026657faeULL, 0x0003e2000b901c46ULL, 0x000000106f6f7824ULL, 0x000fe400078e0254ULL,
0x0000000121197824ULL, 0x000fe200018e0619ULL, 0x0000000024637faeULL, 0x0003e8000b901c46ULL,
0x0000000022617faeULL, 0x0003e8000b901c46ULL, 0x000000001e5f7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3f7faeULL, 0x0003e8000b901c46ULL, 0x000000001c6d7faeULL, 0x0003e8000b901c46ULL,
0x00000000186f7faeULL, 0x0003e4000b901c46ULL, 0x0000000355187812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff00547802ULL, 0x000fe40000000f00ULL,
0x000000031800780cULL, 0x000fc80003f05270ULL, 0x0000000144187807ULL, 0x000fca0004000000ULL,
0x0000000155557824ULL, 0x000fca00078e0218ULL, 0x0000005b5500720cULL, 0x000fda0003f06070ULL,
0x00009200ff188b82ULL, 0x000e620000000a00ULL, 0x00000001081b8824ULL, 0x000fc800078e0255ULL,
0x000000041b188825ULL, 0x002fca00078e0018ULL, 0x0000000618548981ULL, 0x000322000c1e1900ULL,
0x01b6483e563e79a7ULL, 0x0002a4000850003fULL, 0x0000000000187805ULL, 0x002fce0000015200ULL,
0xffffffe0481b7812ULL, 0x040fe400078ec0ffULL, 0x00000010481a7812ULL, 0x040fe400078ec0ffULL,
0x0000000848567812ULL, 0x000fe400078ec0ffULL, 0x000000021a1b7210ULL, 0x000fca0007ffe01bULL,
0x000000011b567824ULL, 0x000fc800078e0256ULL, 0x01b6483f560075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fce0007ffe0ffULL,
0x01b6483f560075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000205d187824ULL, 0x000fe400078e00ffULL, 0x000000ffff617224ULL, 0x000fc600078e0058ULL,
0xffffff8018197812ULL, 0x000fc800078ec0ffULL, 0x0000010002187810ULL, 0x000fc80007ffe019ULL,
0x0000001851187210ULL, 0x000fca0007ffe040ULL, 0x01b0000018197984ULL, 0x000e680000000800ULL,
0x01b20000185f7984ULL, 0x0004a20000000800ULL, 0x000000581900720bULL, 0x002fda0003f1d000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x0000000247187836ULL, 0x000fe20000000000ULL, 0x000000581900720bULL, 0x000fc80003f14000ULL,
0x0000005d1800720cULL, 0x000fd20003f25270ULL, 0x00000000001c7806ULL, 0x000fc800000e0100ULL,
0x000000805d1a9824ULL, 0x000fe200078e0202ULL, 0x0000005819189209ULL, 0x000fc80007810000ULL,
0x0000001a511d9210ULL, 0x000fe40007ffe040ULL, 0x000099101c1a7816ULL, 0x000fc600000000ffULL,
0x01b400181d009388ULL, 0x0003e20000000800ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x00000058191d7209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x000000581d187221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x00000018001a7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x000fca0000011604ULL, 0x00001f1d1a187589ULL, 0x006e6400000e0000ULL,
0x0000002818287220ULL, 0x042fe20000410000ULL, 0x0000002918297220ULL, 0x040fe20000410000ULL,
0x0000002c182c7220ULL, 0x040fe20000410000ULL, 0x0000002d182d7220ULL, 0x040fe20000410000ULL,
0x0000003018307220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000003418347220ULL, 0x040fe20000410000ULL, 0x0000003518357220ULL, 0x040fe20000410000ULL,
0x0000003818387220ULL, 0x040fe20000410000ULL, 0x0000003918397220ULL, 0x040fe20000410000ULL,
0x0000000c180c7220ULL, 0x040fe20000410000ULL, 0x0000000d180d7220ULL, 0x040fe20000410000ULL,
0x0000001018107220ULL, 0x040fe20000410000ULL, 0x0000001118117220ULL, 0x040fe20000410000ULL,
0x0000001418147220ULL, 0x040fe20000410000ULL, 0x0000001518157220ULL, 0x000fce0000410000ULL,
0x0000001a59597220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008041d7811ULL, 0x000fca00078ff0ffULL, 0x00001f1d1a187589ULL, 0x002e6400000e0000ULL,
0x0000002a182a7220ULL, 0x042fe20000410000ULL, 0x0000002b182b7220ULL, 0x040fe20000410000ULL,
0x0000002e182e7220ULL, 0x040fe20000410000ULL, 0x0000002f182f7220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003718377220ULL, 0x040fe20000410000ULL,
0x0000003a183a7220ULL, 0x040fe20000410000ULL, 0x0000003b183b7220ULL, 0x040fe20000410000ULL,
0x0000000e180e7220ULL, 0x040fe20000410000ULL, 0x0000000f180f7220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x0000005819617209ULL, 0x000fd60007810000ULL,
0x8000006119190221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL,
0x00000019000b0308ULL, 0x000ea40000000800ULL, 0x0000000b5f5f0220ULL, 0x004fce0000410000ULL,
0x0000000253587211ULL, 0x000fe200078e70ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000200007627824ULL, 0x000fc800078e0258ULL, 0x0001300062627836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x000fe40000011604ULL,
0x0000000bff09723eULL, 0x000fc600000000ffULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0x0000541009187816ULL, 0x002fca0000000009ULL, 0x00001f19180a7589ULL, 0x0002a800000e0000ULL,
0x00001f1b18097589ULL, 0x0002e400000e0000ULL, 0x012000005718783bULL, 0x0022e20000000200ULL,
0x00000010433c7824ULL, 0x100fe200078e0262ULL, 0x0000006242247211ULL, 0x000fe200078e20ffULL,
0x0000001041207824ULL, 0x000fe200078e0262ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000a18187232ULL, 0x08cfe40000000000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000919197232ULL, 0x080fe40000000000ULL, 0x000000091b1b7232ULL, 0x000fce0000000000ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x000000104f1c7824ULL, 0x000fe200078e0262ULL,
0x0000000252577810ULL, 0x002fe40007ffe0ffULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000001c1c783bULL, 0x000e680000004200ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000201838723cULL, 0x028fec0000001838ULL, 0x00000022180c723cULL, 0x000fe2000000180cULL,
0x0000000704217812ULL, 0x000fe200078ec0ffULL, 0x000002005d207824ULL, 0x000fc600078e00ffULL,
0x0000000821217812ULL, 0x000fe200078ef804ULL, 0x0000001c1810723cULL, 0x002fe80000001810ULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0xfffff80020217812ULL, 0x000fe200078ec0ffULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x000000104b207824ULL, 0x000fe400078e0262ULL,
0xfffffff822577812ULL, 0x000fe200078ee257ULL, 0x00000001021c7824ULL, 0x000fc400078e0221ULL,
0x0000003e182c723cULL, 0x000fe2000000182cULL, 0x000000624d3c7211ULL, 0x000fe200078e20ffULL,
0x00000010571c7824ULL, 0x000fc800078e021cULL, 0x000000241830723cULL, 0x000fec0000001830ULL,
0x000000261834723cULL, 0x000fe20000001834ULL, 0x000000104c247824ULL, 0x000fca00078e0262ULL,
0x0000001e1814723cULL, 0x000fe20000001814ULL, 0x012000001c18783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000a18187232ULL, 0x08cfe40000000000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000919197232ULL, 0x080fe40000000000ULL, 0x000000091b1b7232ULL, 0x000fce0000000000ULL,
0x000000104a1c7824ULL, 0x002fe200078e0262ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x000000595f597221ULL, 0x000fc60000010000ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000f680000004200ULL, 0x000000001c1c783bULL, 0x000f620000004200ULL,
0x0000003c1828723cULL, 0x00afec0000001828ULL, 0x0000003e182c723cULL, 0x000fec000000182cULL,
0x000000241830723cULL, 0x020fe20000001830ULL, 0x00000001003e7802ULL, 0x000fc80000000f00ULL,
0x01b6983e4eff79a7ULL, 0x0003e2000850003fULL, 0x000000261834723cULL, 0x000fec0000001834ULL,
0x000000201838723cULL, 0x004fec0000001838ULL, 0x00000022180c723cULL, 0x000fec000000180cULL,
0x0000001c1810723cULL, 0x000fec0000001810ULL, 0x0000001e1814723cULL, 0x000fee0000001814ULL,
0x00000001001b7824ULL, 0x000fca00078e0260ULL, 0x0000005a1b00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000c004c0947ULL, 0x002fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000a00ULL, 0x000001001b1d7824ULL, 0x000fe200078e0246ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x000000011b1b7836ULL, 0x000fe40000000000ULL,
0x0000000454547c24ULL, 0x010fe2000f8e02ffULL, 0x000000201d1a7812ULL, 0x000fe400078ec0ffULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x00000006541b7819ULL, 0x000fe200000006ffULL,
0x0000000145277824ULL, 0x000fc800078e021aULL, 0x000001001b187825ULL, 0x002fcc00078e0018ULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x00000003ff3d7819ULL, 0x100fe20000011604ULL,
0x000020005d1a7824ULL, 0x040fe200078e00ffULL, 0x0000001d5c267248ULL, 0x000fe40007fe0000ULL,
0x000000ff1d1b7210ULL, 0x000fe20007ffe1ffULL, 0x000000043d217836ULL, 0x000fe20000000000ULL,
0x000020001a1f7812ULL, 0x000fe200078ec0ffULL, 0x000000805d1d7824ULL, 0x000fe200078e00ffULL,
0x0000002026267446ULL, 0x000fe2000380001bULL, 0x00000001211a7824ULL, 0x040fe200078e0204ULL,
0x000000043d1b7210ULL, 0x000fe20007ffe0ffULL, 0x00000008215f7824ULL, 0x000fe200078e00ffULL,
0x0001300058587810ULL, 0x000fe20007ffe01fULL, 0x000000013d1f7824ULL, 0x100fe200078e0227ULL,
0x000000071b257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee21aULL, 0x000000083d637836ULL, 0x000fe20000000000ULL,
0x00000080401a7812ULL, 0x000fe200078ef81dULL, 0x0000000c3d657836ULL, 0x000fe20000000000ULL,
0x00000027211d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000163237824ULL, 0x000fe200078e0227ULL,
0x000000262100720cULL, 0x080fe20003f26070ULL, 0x000001001f1e7825ULL, 0x000fe200078e001aULL,
0x000000263d00720cULL, 0x000fc40003f06070ULL, 0x0ffffff825257812ULL, 0x000fe200078ef804ULL,
0x000001001d1c7825ULL, 0x000fe200078e001aULL, 0x0000001e181e7210ULL, 0x000fe40007f5e0ffULL,
0x000000585f5f7211ULL, 0x000fe200078e20ffULL, 0x0000000165217824ULL, 0x000fe200078e0227ULL,
0x0000001c181c7210ULL, 0x000fe20007f7e0ffULL, 0x0000010023227825ULL, 0x100fe200078e001aULL,
0x0000001f191f7210ULL, 0x000fe400017fe4ffULL, 0x000000183d6b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001aULL, 0x0000002218247210ULL, 0x000fc40007f5e0ffULL,
0x000000266300720cULL, 0x080fe20003fa6070ULL, 0x00000001191d7824ULL, 0x000fe200018e061dULL,
0x0000002018227210ULL, 0x000fe20007f7e0ffULL, 0x000000103d677836ULL, 0x000fe20000000000ULL,
0x000000266500720cULL, 0x080fe20003f86070ULL, 0x00000010253f7824ULL, 0x000fe400078e0258ULL,
0x0000000119257824ULL, 0x040fe400010e0623ULL, 0x0000000119237824ULL, 0x000fe200018e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e3f7faeULL, 0x0003e2000c101c46ULL,
0x0000000167217824ULL, 0x040fe200078e0227ULL, 0x000000266700720cULL, 0x080fe20003f66070ULL,
0x000000143d697836ULL, 0x000fe20000000000ULL, 0x000000001c5f7faeULL, 0x0005e2000c901c46ULL,
0x0000001c3d6d7836ULL, 0x000fe20000000000ULL, 0x000000266b00720cULL, 0x080fe20003f26070ULL,
0x00000001633c7824ULL, 0x000fe200078e0204ULL, 0x000000266900720cULL, 0x000fc40003f46070ULL,
0x000000266d00720cULL, 0x000fe20003f06070ULL, 0x0000000169267824ULL, 0x100fe200078e0204ULL,
0x00000003633d7819ULL, 0x000fe200000006ffULL, 0x00000001651e7824ULL, 0x002fe200078e0204ULL,
0x0000000369637819ULL, 0x000fe200000006ffULL, 0x00000008653f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL, 0x00000100211c7825ULL, 0x004fe200078e001aULL,
0xfffffff863637812ULL, 0x000fe400078ee226ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee21eULL,
0x00000001691f7824ULL, 0x000fe200078e0227ULL, 0x0000001c18207210ULL, 0x000fe20007fde0ffULL,
0x00000001671e7824ULL, 0x040fe200078e0204ULL, 0x000000046b267210ULL, 0x000fe20007ffe0ffULL,
0x00000008675f7824ULL, 0x000fe200078e00ffULL, 0x0000001d19217210ULL, 0x000fe200037fe4ffULL,
0x000001001f1c7825ULL, 0x000fe200078e001aULL, 0x0000005863637211ULL, 0x000fc400078e20ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee21eULL, 0x000000016b1f7824ULL, 0x100fe200078e0227ULL,
0x0000001c181c7210ULL, 0x000fe20007fde0ffULL, 0x000000016d277824ULL, 0x000fe400078e0227ULL,
0x000001001f1e7825ULL, 0x000fc800078e001aULL, 0x00000001191d7824ULL, 0x000fe200030e061dULL,
0x0000001e181e7210ULL, 0x000fe20007fde0ffULL, 0x000000086b6b7824ULL, 0x000fe400078e00ffULL,
0x000000016d3c7824ULL, 0x040fe200078e0204ULL, 0x0000001f191f7210ULL, 0x000fe200037fe4ffULL,
0x000000086d657824ULL, 0x000fe400078e00ffULL, 0x00000100271a7825ULL, 0x000fe200078e001aULL,
0xfffffff86b277812ULL, 0x000fe400078ee226ULL, 0xfffffff865657812ULL, 0x000fe200078ee23cULL,
0x000000103d3d7824ULL, 0x100fe200078e0258ULL, 0x0000001a18187210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0258ULL, 0x000000105f5f7824ULL, 0x100fe200078e0258ULL,
0x00000000243d7faeULL, 0x0003e2000e901c46ULL, 0x0000001027277824ULL, 0x100fe400078e0258ULL,
0x0000001065657824ULL, 0x000fe200078e0258ULL, 0x00000000223f7faeULL, 0x0003e2000e101c46ULL,
0x0000000119197824ULL, 0x000fc600030e061bULL, 0x00000000205f7faeULL, 0x0003e8000d901c46ULL,
0x000000001c637faeULL, 0x0003e8000d101c46ULL, 0x000000001e277faeULL, 0x0003e8000c901c46ULL,
0x0000000018657faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x0000000d5d1a7819ULL, 0x000fe400000006ffULL, 0x00000004041d7811ULL, 0x000fe400078fe8ffULL,
0x000020001a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000804257811ULL, 0x040fe200078fe8ffULL,
0x000000011d677824ULL, 0x140fe200078e0204ULL, 0x0000000c04237811ULL, 0x040fe200078fe8ffULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0x00000010041f7811ULL, 0x000fe200078fe8ffULL,
0x0000000125657824ULL, 0x100fe200078e0204ULL, 0x0001300058587810ULL, 0x000fe20007ffe01bULL,
0x0000000123637824ULL, 0x140fe200078e0204ULL, 0xfffffff81a677812ULL, 0x000fe200078ee267ULL,
0x00000008231c7824ULL, 0x000fe200078e00ffULL, 0x00000003251a7819ULL, 0x000fe200000006ffULL,
0x000000011f5f7824ULL, 0x040fe200078e0204ULL, 0x000000031f1e7819ULL, 0x000fe200000006ffULL,
0x000000805d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a657812ULL, 0x000fe200078ee265ULL,
0x0000000125257824ULL, 0x100fe200078e0227ULL, 0xfffffff81c637812ULL, 0x000fe200078ee263ULL,
0x0000000123237824ULL, 0x100fe200078e0227ULL, 0x00000004041a7211ULL, 0x040fe200078fe8ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0227ULL, 0x00000018041c7811ULL, 0x000fe200078fe8ffULL,
0x0000001067677824ULL, 0x100fe200078e0258ULL, 0x000000071a6d7812ULL, 0x000fe200078ec0ffULL,
0x0000001065657824ULL, 0x000fe200078e0258ULL, 0xfffffff81e5f7812ULL, 0x000fe200078ee25fULL,
0x000000081c1e7824ULL, 0x040fe200078e00ffULL, 0x00000080401a7812ULL, 0x000fe200078ef81bULL,
0x000000011c1b7824ULL, 0x000fe200078e0204ULL, 0x0000001404217811ULL, 0x000fe200078fe8ffULL,
0x000000011c697824ULL, 0x100fe200078e0227ULL, 0x0000001c046b7811ULL, 0x040fe200078fe8ffULL,
0x0000001063637824ULL, 0x000fe200078e0258ULL, 0x000000271d1d7210ULL, 0x000fe20007ffe0ffULL,
0x00000001213f7824ULL, 0x040fe200078e0204ULL, 0xfffffff81e6f7812ULL, 0x000fe200078ee21bULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x00000027043d7211ULL, 0x000fe200078fe8ffULL,
0x0000000821207824ULL, 0x000fe200078e00ffULL, 0x000000046b1c7210ULL, 0x000fe20007ffe0ffULL,
0x000000086b717824ULL, 0x040fe200078e00ffULL, 0x0000002721217210ULL, 0x000fe20007ffe0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0227ULL, 0xfffffff8203f7812ULL, 0x000fe200078ee23fULL,
0x000001001d267825ULL, 0x000fe200078e001aULL, 0xfffffff871717812ULL, 0x000fc400078ee21cULL,
0x0ffffff86d6d7812ULL, 0x000fe200078ef804ULL, 0x000001003d3c7825ULL, 0x100fe200078e001aULL,
0x0000002618267210ULL, 0x000fe40007f3e0ffULL, 0x000000586d6d7211ULL, 0x080fe200078e20ffULL,
0x0000010025247825ULL, 0x100fe200078e001aULL, 0x0000003c183c7210ULL, 0x000fe40007f1e0ffULL,
0x000000585f5f7211ULL, 0x000fe200078e20ffULL, 0x0000010023227825ULL, 0x000fe200078e001aULL,
0x0000002418247210ULL, 0x000fc40007f5e0ffULL, 0x0000003d193d7210ULL, 0x000fe200007fe4ffULL,
0x000001001f1c7825ULL, 0x000fe200078e001aULL, 0x0000002218227210ULL, 0x000fc60007f7e0ffULL,
0x00000100211e7825ULL, 0x100fe200078e001aULL, 0x0000001c181c7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c6d7faeULL, 0x0003e4000b901c46ULL,
0x0000010069207825ULL, 0x000fe200078e001aULL, 0x0000001d191d7210ULL, 0x000fc600007fe4ffULL,
0x000001006b1a7825ULL, 0x000fc800078e001aULL, 0x0000000119277824ULL, 0x040fe200008e0627ULL,
0x0000001e181e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000119257824ULL, 0x040fe200010e0625ULL,
0x0000002018207210ULL, 0x000fe20007f5e0ffULL, 0x0000000119237824ULL, 0x000fe200018e0623ULL,
0x0000001a18187210ULL, 0x000fe20007f7e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0258ULL,
0x0000000026677faeULL, 0x0003e2000b901c46ULL, 0x00000001191f7824ULL, 0x000fe400008e061fULL,
0x000000106f6f7824ULL, 0x000fe200078e0258ULL, 0x0000000024657faeULL, 0x0003e2000b901c46ULL,
0x0000000119217824ULL, 0x000fc400010e0621ULL, 0x0000001071717824ULL, 0x000fe200078e0258ULL,
0x0000000022637faeULL, 0x0003e2000b901c46ULL, 0x0000000119197824ULL, 0x000fc600018e061bULL,
0x000000001c5f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e3f7faeULL, 0x0003e8000b901c46ULL,
0x00000000206f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018717faeULL, 0x0003e4000b901c46ULL,
0x0000000355187812ULL, 0x002fe200078ec0ffULL, 0xffffffffff547424ULL, 0x000fc600078e00ffULL,
0x000000031800780cULL, 0x000fc80003f05270ULL, 0x0000000144187807ULL, 0x000fc80004000000ULL,
0x0000001855557210ULL, 0x000fc80007ffe0ffULL, 0x0000005b5500720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff187b82ULL, 0x000e620000000a00ULL,
0x00000001081b7824ULL, 0x000fc800078e0255ULL, 0x000000041b187825ULL, 0x002fca00078e0018ULL,
0x0000000618547981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b6683e563e79a7ULL, 0x0004e4000850003fULL, 0x0000000000187805ULL, 0x002fce0000015200ULL,
0xffffffe0481b7812ULL, 0x040fe400078ec0ffULL, 0x00000010481a7812ULL, 0x040fe400078ec0ffULL,
0x00000008481c7812ULL, 0x000fe400078ec0ffULL, 0x000000021a1b7210ULL, 0x000fca0007ffe01bULL,
0x000000011b1f7824ULL, 0x000fc800078e021cULL, 0x01b6683f1f0075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff001c7202ULL, 0x000fce0000000f00ULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01b6683f1f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000055d187819ULL, 0x000fe200000006ffULL, 0x000000ffff527224ULL, 0x000fc600078e0061ULL,
0xffffff8018197812ULL, 0x000fc800078ec0ffULL, 0x0000018002187810ULL, 0x000fc80007ffe019ULL,
0x0000001851187210ULL, 0x000fca0007ffe040ULL, 0x01b00000181a7984ULL, 0x000e680000000800ULL,
0x01b2000018567984ULL, 0x0044a20000000800ULL, 0x000000611a00720bULL, 0x002fda0003f1d000ULL,
0x0000000000197806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff191b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x0000000347187836ULL, 0x000fe20000000000ULL, 0x000000611a00720bULL, 0x000fc80003f14000ULL,
0x0000005d1800720cULL, 0x000fd20003f25270ULL, 0x00000000001c7806ULL, 0x000fc800000e0100ULL,
0x000000805d199824ULL, 0x000fe200078e0202ULL, 0x000000611a189209ULL, 0x000fc80007810000ULL,
0x0000001951519210ULL, 0x000fe40007ffe040ULL, 0x000099101c197816ULL, 0x000fc600000000ffULL,
0x01b4001851009388ULL, 0x0003e20000000800ULL, 0x000000ff1900720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x000000611a187209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x0000006118187221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x00000018001e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x000fca0000011604ULL, 0x00001f191e187589ULL, 0x006e6400000e0000ULL,
0x0000002818287220ULL, 0x042fe20000410000ULL, 0x0000002918297220ULL, 0x040fe20000410000ULL,
0x0000002c182c7220ULL, 0x040fe20000410000ULL, 0x0000002d182d7220ULL, 0x040fe20000410000ULL,
0x0000003018307220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000003418347220ULL, 0x040fe20000410000ULL, 0x0000003518357220ULL, 0x040fe20000410000ULL,
0x0000003818387220ULL, 0x040fe20000410000ULL, 0x0000003918397220ULL, 0x040fe20000410000ULL,
0x0000000c180c7220ULL, 0x040fe20000410000ULL, 0x0000000d180d7220ULL, 0x040fe20000410000ULL,
0x0000001018107220ULL, 0x040fe20000410000ULL, 0x0000001118117220ULL, 0x040fe20000410000ULL,
0x0000001418147220ULL, 0x040fe20000410000ULL, 0x0000001518157220ULL, 0x000fce0000410000ULL,
0x0000001e59597220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000804197811ULL, 0x000fca00078ff0ffULL, 0x00001f191e187589ULL, 0x002e6400000e0000ULL,
0x0000002a182a7220ULL, 0x042fe20000410000ULL, 0x0000002b182b7220ULL, 0x040fe20000410000ULL,
0x0000002e182e7220ULL, 0x040fe20000410000ULL, 0x0000002f182f7220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003718377220ULL, 0x040fe20000410000ULL,
0x0000003a183a7220ULL, 0x040fe20000410000ULL, 0x0000003b183b7220ULL, 0x040fe20000410000ULL,
0x0000000e180e7220ULL, 0x040fe20000410000ULL, 0x0000000f180f7220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x000000611a527209ULL, 0x000fd60007810000ULL,
0x800000521a1a0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL,
0x0000001a000b0308ULL, 0x000ea40000000800ULL, 0x0000000b56560220ULL, 0x004fce0000410000ULL,
0x0000000253187211ULL, 0x002fe200078e70ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000200007187824ULL, 0x000fe400078e0218ULL, 0x00000010501a7824ULL, 0x000fe400078e0249ULL,
0x0001400018507836ULL, 0x000fe20000000000ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff197819ULL, 0x000fe40000011604ULL, 0x0000000bff09723eULL, 0x000fe400000000ffULL,
0x00000008191b7810ULL, 0x000fe40007ffe0ffULL, 0x0000541009187816ULL, 0x000fca0000000009ULL,
0x00001f19180a7589ULL, 0x0002a800000e0000ULL, 0x00001f1b18097589ULL, 0x0002e400000e0000ULL,
0x012800001a18783bULL, 0x002e620000000200ULL, 0x0000001043437824ULL, 0x100fe400078e0250ULL,
0x00000010423c7824ULL, 0x100fe400078e0250ULL, 0x0000001041207824ULL, 0x000fe200078e0250ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000a18187232ULL, 0x086fe40000000000ULL,
0x0000000a1a1a7232ULL, 0x000fe40000000000ULL, 0x0000000919197232ULL, 0x088fe40000000000ULL,
0x000000091b1b7232ULL, 0x000fce0000000000ULL, 0x000000504f247211ULL, 0x000fe200078e20ffULL,
0x000000004340783bULL, 0x000f620000004200ULL, 0x00001800491c7836ULL, 0x000fe40000000000ULL,
0x0000005956567221ULL, 0x000fe20000010000ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x00000010571c7824ULL, 0x000fc600078e021cULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000002424783bULL, 0x000f680000004200ULL, 0x011000001c1c783bULL, 0x000f640000000200ULL,
0x000000401828723cULL, 0x02afec0000001828ULL, 0x00000042182c723cULL, 0x000fec000000182cULL,
0x0000003c1830723cULL, 0x004fec0000001830ULL, 0x0000003e1834723cULL, 0x000fec0000001834ULL,
0x000000201838723cULL, 0x000fec0000001838ULL, 0x00000022180c723cULL, 0x000fec000000180cULL,
0x000000241810723cULL, 0x000fec0000001810ULL, 0x000000261818723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000a1c1c7232ULL, 0x080fe40000000000ULL, 0x0000000a1e1e7232ULL, 0x000fe40000000000ULL,
0x000000091d1d7232ULL, 0x080fe40000000000ULL, 0x000000091f1f7232ULL, 0x000fce0000000000ULL,
0x000000104a147824ULL, 0x100fe200078e0250ULL, 0x000000504c247211ULL, 0x000fe200078e20ffULL,
0x000000104d3c7824ULL, 0x100fe200078e0250ULL, 0x0000006000607210ULL, 0x000fe20007ffe0ffULL,
0x000000104b207824ULL, 0x000fe400078e0250ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x0000005a6000720cULL, 0x000fc60003f06070ULL, 0x000000003c3c783bULL, 0x000ea80000004200ULL,
0x000000002424783bULL, 0x000ee80000004200ULL, 0x000000002020783bULL, 0x000f620000004200ULL,
0x000000141c10723cULL, 0x002fec0000001810ULL, 0x0000003c1c28723cULL, 0x004fe20000001828ULL,
0x00000001ff157424ULL, 0x000fc800078e00ffULL, 0x01b6a0154eff79a7ULL, 0x0003e2000850003fULL,
0x0000003e1c2c723cULL, 0x000fec000000182cULL, 0x000000241c30723cULL, 0x008fec0000001830ULL,
0x000000261c34723cULL, 0x000fec0000001834ULL, 0x000000201c38723cULL, 0x020fec0000001838ULL,
0x000000221c0c723cULL, 0x000fec000000180cULL, 0x000000161c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff9c00208947ULL, 0x002fde000383ffffULL,
0x00000000001d7919ULL, 0x000e620000002500ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0012ULL,
0x00000013000a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0018ULL,
0x0000000f00187202ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000eULL, 0x000000ffff0b7224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x000fc400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e0010ULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe200078e000cULL,
0x0000005a1d00720cULL, 0x002fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000056047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00008440000d7802ULL, 0x000fce0000000f00ULL, 0x000000b400ec7944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e000cULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000005600097308ULL, 0x000e640000001000ULL, 0xbf80000009047423ULL, 0x002fc80000000056ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000409047223ULL, 0x000fce0000000009ULL,
0x0000000000097919ULL, 0x000ea40000000000ULL, 0x00000002ff0d7819ULL, 0x004fe40000011609ULL,
0x0000000809097811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0d04087589ULL, 0x000ea800000e0000ULL, 0x00001f0904097589ULL, 0x000ee200000e0000ULL,
0x0000002808287220ULL, 0x044fe20000410000ULL, 0x0000002908297220ULL, 0x040fe20000410000ULL,
0x0000002c082c7220ULL, 0x040fe20000410000ULL, 0x0000002d082d7220ULL, 0x040fe20000410000ULL,
0x0000003008307220ULL, 0x040fe20000410000ULL, 0x0000003108317220ULL, 0x040fe20000410000ULL,
0x0000003408347220ULL, 0x040fe20000410000ULL, 0x0000003508357220ULL, 0x040fe20000410000ULL,
0x0000003808387220ULL, 0x040fe20000410000ULL, 0x0000003908397220ULL, 0x040fe20000410000ULL,
0x0000001108117220ULL, 0x040fe20000410000ULL, 0x0000000e080e7220ULL, 0x040fe20000410000ULL,
0x0000001308137220ULL, 0x040fe20000410000ULL, 0x0000001208127220ULL, 0x040fe20000410000ULL,
0x0000003d083d7220ULL, 0x040fe20000410000ULL, 0x0000001e081e7220ULL, 0x000fe20000410000ULL,
0x0000002a092a7220ULL, 0x048fe20000410000ULL, 0x0000002b092b7220ULL, 0x040fe20000410000ULL,
0x0000002e092e7220ULL, 0x040fe20000410000ULL, 0x0000002f092f7220ULL, 0x040fe20000410000ULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x0000003309337220ULL, 0x040fe20000410000ULL,
0x0000003609367220ULL, 0x040fe20000410000ULL, 0x0000003709377220ULL, 0x040fe20000410000ULL,
0x0000003a093a7220ULL, 0x040fe20000410000ULL, 0x0000003b093b7220ULL, 0x040fe20000410000ULL,
0x0000001c091c7220ULL, 0x040fe20000410000ULL, 0x0000001809187220ULL, 0x040fe20000410000ULL,
0x0000001f091f7220ULL, 0x040fe20000410000ULL, 0x0000000a090a7220ULL, 0x040fe20000410000ULL,
0x0000001a091a7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x000fce0000410000ULL,
0x00000000001b7919ULL, 0x000ea20000000000ULL, 0x000000282914723eULL, 0x000fe400000000ffULL,
0x0000002c2d15723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000303116723eULL, 0x000fc400000000ffULL, 0x000000343517723eULL, 0x000fe400000000ffULL,
0x000000131212723eULL, 0x000fe400000000ffULL, 0x0000001a0b0b723eULL, 0x000fe400000000ffULL,
0x000000110e11723eULL, 0x000fe400000000ffULL, 0x0000003d1e13723eULL, 0x000fe400000000ffULL,
0x00000032330e723eULL, 0x000fc400000000ffULL, 0x00000036370f723eULL, 0x000fe400000000ffULL,
0x0000001f0a0a723eULL, 0x000fe400000000ffULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x00000003ff197819ULL, 0x004fe4000001161bULL, 0xfffffff8ff097812ULL, 0x000fe400078ee21bULL,
0x0000000319047812ULL, 0x000fc400078ec0ffULL, 0x0000000309237819ULL, 0x040fe200000006ffULL,
0x00000008090d7836ULL, 0x000fe20000000000ULL, 0x0000001b46297210ULL, 0x000fe20007ffe0ffULL,
0x0000000809107824ULL, 0x000fe400078e00ffULL, 0x0000000104097824ULL, 0x040fe200078e0209ULL,
0x000000030d277819ULL, 0x040fe200000006ffULL, 0x0000000104087824ULL, 0x000fe400078e020dULL,
0x0000000409047836ULL, 0x000fe20000000000ULL, 0xfffffff810217812ULL, 0x000fe200078ee209ULL,
0x000000080d257824ULL, 0x000fe200078e00ffULL, 0x000000383910723eULL, 0x000fe200000000ffULL,
0x0000000c090c7836ULL, 0x000fe20000000000ULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x0000100007047824ULL, 0x000fe200078e0202ULL, 0xfffffff825257812ULL, 0x000fc400078ee208ULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x0000001029287824ULL, 0x000fe200078e0204ULL,
0x0000000453027211ULL, 0x000fe400078e58ffULL, 0x0000001c1809723eULL, 0x000fe400000000ffULL,
0x0000002a2b0c723eULL, 0x000fe200000000ffULL, 0x0000001021187824ULL, 0x100fe200078e0202ULL,
0x0000002e2f0d723eULL, 0x000fe200000000ffULL, 0x00000010231a7824ULL, 0x100fe200078e0202ULL,
0x0000003a3b08723eULL, 0x000fe200000000ffULL, 0x00000010251c7824ULL, 0x100fe200078e0202ULL,
0x0000001418007844ULL, 0x000fe20000000200ULL, 0x00000010271e7824ULL, 0x000fc600078e0202ULL,
0x000000101a007844ULL, 0x000fe80000000200ULL, 0x0000000c1c007844ULL, 0x000fe80000000200ULL,
0x000000081e007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000282c7984ULL, 0x000ea80000000c00ULL, 0x0004000028247984ULL, 0x000ee80000000c00ULL,
0x0008000028307984ULL, 0x000f680000000c00ULL, 0x000c000028207984ULL, 0x000f620000000c00ULL,
0x200000ff2f2f7230ULL, 0x004fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26117230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24107230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x022fe40000000000ULL, 0x000000322e2e7230ULL, 0x000fe40000000000ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fe40000000000ULL,
0x0000002327237230ULL, 0x000fc40000000000ULL, 0x0000002211227230ULL, 0x000fe20000000000ULL,
0x0000002c28007388ULL, 0x0003e20000000c00ULL, 0x0000002125217230ULL, 0x000fe40000000000ULL,
0x0000002010207230ULL, 0x000fca0000000000ULL, 0x0004002028007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002400e08947ULL, 0x000fea0003800000ULL,
0x00000400ff257b82ULL, 0x000ea20000000800ULL, 0x0000000000147919ULL, 0x000ee20000002600ULL,
0x0000004029217810ULL, 0x002fe20007ffe0ffULL, 0x0000000000157919ULL, 0x000eea0000002700ULL,
0x00009800ff087b82ULL, 0x000eb00000000800ULL, 0x00009c00ff107b82ULL, 0x000e620000000a00ULL,
0x0000000825097224ULL, 0x004fc800078e02ffULL, 0x00000000090c7224ULL, 0x0c0fe200078e02ffULL,
0x0000000f091f7811ULL, 0x000fe200078e10ffULL, 0x0000002515257224ULL, 0x008fe200078e0214ULL,
0x0000000028087984ULL, 0x0004a40000000c00ULL, 0xfffffff01f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000000251a7224ULL, 0x000fc800078e02ffULL, 0x000000800c137824ULL, 0x000fca00078e021fULL,
0x000000130c127211ULL, 0x000fe400078e38ffULL, 0x00040000280c7984ULL, 0x0004a60000000c00ULL,
0x0000007f12127836ULL, 0x000fca0000000000ULL, 0xffffff8012157812ULL, 0x000fe200078ec0ffULL,
0x000000011a127824ULL, 0x000fc600078e021dULL, 0x0000001015177210ULL, 0x002fc80007f1e0ffULL,
0x0000001712167211ULL, 0x000fe200078260ffULL, 0x000000ffff177224ULL, 0x000fe200000e0611ULL,
0x0000000153ff7812ULL, 0x000fc8000780f85dULL, 0x0000001712177211ULL, 0x000fe400008f64ffULL,
0x000000101f277210ULL, 0x000fe20007f3e0ffULL, 0x0000080007167825ULL, 0x000fc800078e0016ULL,
0x00000010291c7825ULL, 0x000fc800078e0016ULL, 0x0000001021167825ULL, 0x000fc800078e0016ULL,
0x000000ffff297224ULL, 0x000fe200008e0611ULL, 0x0000000000400947ULL, 0x004fec0003800000ULL,
0x000000101b187824ULL, 0x000fe200078e00ffULL, 0x00000001ff1e7819ULL, 0x000fe2000001161bULL,
0x0000008012147824ULL, 0x000fe200078e00ffULL, 0x00000019ff127819ULL, 0x000fe40000011612ULL,
0x0000007018237812ULL, 0x000fe400078ec0ffULL, 0x0000001014227210ULL, 0x000fe40007ebe013ULL,
0x0000000c1e217812ULL, 0x000fe400078ec0ffULL, 0x0000002723147210ULL, 0x000fc40007a3e014ULL,
0x0000001112187210ULL, 0x000fe40002fec4ffULL, 0x0000001421207210ULL, 0x000fe40007fbe0ffULL,
0x00000029ff127210ULL, 0x000fe40000fe4412ULL, 0x0000002221227210ULL, 0x000fe40007c7e023ULL,
0x00000012ff217210ULL, 0x000fe40002ffe4ffULL, 0x00000018ff237210ULL, 0x000fc60001fe84ffULL,
0x0000005220007986ULL, 0x0003e8000c101906ULL, 0x0000005622007986ULL, 0x0003e4000c101906ULL,
0x000000ff1b00720cULL, 0x000fe20000705670ULL, 0x000000081c007986ULL, 0x0005e8000c101d06ULL,
0x0000000c16007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fee0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009c00ff087b82ULL, 0x004ea20000000a00ULL,
0xffffffff000b7836ULL, 0x000fe40000000000ULL, 0x0000000425087825ULL, 0x004fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000000b080879a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000b0800720cULL, 0x010fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000008ff007988ULL, 0x0007e60008000004ULL, 0x0000000000097919ULL, 0x004ea20000008800ULL,
0x00000400001c7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654091c7816ULL, 0x004fca000000001cULL,
0x000000001c087984ULL, 0x008ea40000000000ULL, 0x000000ff0800720cULL, 0x004fda0003f05270ULL,
0x0000002000848947ULL, 0x000fea0003800000ULL, 0x000000ff5d00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x000000101b097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe4000001161bULL, 0x000000271a087211ULL, 0x000fe400078038ffULL,
0x00000070090b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000291a097211ULL, 0x000fe400000f3cffULL, 0x000000080a087210ULL, 0x000fc8000791e00bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080a7981ULL, 0x000528000c1e1900ULL,
0x00008006080b7981ULL, 0x000522000c1e1900ULL, 0x000000020000780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x00010006080d7981ULL, 0x000522000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x00018006080f7981ULL, 0x000522000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x004fea0003800000ULL, 0x0002000608177981ULL, 0x000522000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x004fea0003800000ULL,
0x0002800608197981ULL, 0x000522000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x004fea0003800000ULL, 0x000000080000780cULL, 0x000fe20003f06070ULL,
0x00030006081d7981ULL, 0x000518000c1e1900ULL, 0x0003800608210981ULL, 0x002524000c1e1900ULL,
0x0000000700087836ULL, 0x004fca0000000000ULL, 0x00000003ff0c7819ULL, 0x000fc80000011608ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001f1a097211ULL, 0x040fe200078038ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000000a00237202ULL, 0x012fe20000000f00ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000001009107210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1a087211ULL, 0x000fe400000f3cffULL,
0x0000078010257810ULL, 0x000fc80007f5e0ffULL, 0x00000008ff117210ULL, 0x000fd200017e2411ULL,
0x0000000400007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x000000230a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffc800608237981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000b0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff097210ULL, 0x000fca0000ffe4ffULL,
0xfffd0006080b7981ULL, 0x000328000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffd8006080d7981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff097210ULL, 0x000fca0000ffe4ffULL,
0xfffe0006080f7981ULL, 0x000328000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x000000170a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffe800608177981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x000000190a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff097210ULL, 0x000fca0000ffe4ffULL,
0xffff000608197981ULL, 0x000328000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001d0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xffff8006081d7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x000000210a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101b087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc8000001161bULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff097210ULL, 0x000fca0000ffe4ffULL,
0x0000000608217981ULL, 0x000328000c1e1900ULL, 0x0000040025257810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x00000000001b7919ULL, 0x000ea40000000000ULL,
0x000000101b087824ULL, 0x006fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x010fc8000001161bULL,
0x0000007008097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000001c0b097210ULL, 0x000fca0007ffe009ULL, 0x0000000a09007388ULL, 0x0003e40000000800ULL,
0x00009c00ff247b82ULL, 0x000ea20000000a00ULL, 0x000000071b00780cULL, 0x000fe20003f04070ULL,
0x000008005d1d7824ULL, 0x000fe200078e00ffULL, 0x00000001470a7812ULL, 0x002fe200078ec0ffULL,
0x0000000153147824ULL, 0x000fe200078e021aULL, 0x00000001ff227819ULL, 0x000fe2000001161bULL,
0x0000080047477824ULL, 0x000fe200078e00ffULL, 0x000008001d1d7812ULL, 0x000fe200078ee2ffULL,
0x0000200053207824ULL, 0x000fe200078e021cULL, 0x0000000c22227812ULL, 0x000fe200078ec0ffULL,
0x000000101b217824ULL, 0x000fe200078e00ffULL, 0x0000080047477812ULL, 0x000fc400078ec0ffULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000002007207211ULL, 0x000fe200078e60ffULL,
0x00000200530c8824ULL, 0x040fe200078e021cULL, 0x0000001c53088211ULL, 0x000fe400078e48ffULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x0000007021217812ULL, 0x000fe200078ec0ffULL,
0x00000100070d8824ULL, 0x040fe200078e020cULL, 0x00000008070b8211ULL, 0x000fc400078e40ffULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x000000601b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000800a268824ULL, 0x040fe200078e020dULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000002415187210ULL, 0x004fe20007f3e0ffULL, 0x000000800a168824ULL, 0x000fe200078e020bULL,
0x000000241f1f7210ULL, 0x000fe20007f7e0ffULL, 0x00000001200a7824ULL, 0x000fe200078e0247ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200008e0625ULL,
0x00000024131e7210ULL, 0x000fe20007f3e0ffULL, 0x000000201b0b7836ULL, 0x000fe20000000000ULL,
0x0000001c22247210ULL, 0x000fe20007ffe021ULL, 0x0000100014087825ULL, 0x040fe200078e0018ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001d08087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x100fe200008e0625ULL, 0x0000001e14108211ULL, 0x040fe200078238ffULL,
0x000000401b0d7836ULL, 0x000fe20000000000ULL, 0x00000009ff097210ULL, 0x000fe200017fe4ffULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x0000001f14128211ULL, 0x040fe200078438ffULL,
0x000000101b157824ULL, 0x000fe200078e020aULL, 0x0000002314118211ULL, 0x040fe200008f3cffULL,
0x000000100b0a7825ULL, 0x100fe200078e0008ULL, 0x000000005300720cULL, 0x000fe20003f26070ULL,
0x0000000024247984ULL, 0x000e620000000800ULL, 0x0000002514138211ULL, 0x000fe200010f3cffULL,
0x000000100d0c7825ULL, 0x000fe200078e0008ULL, 0x000000161b178211ULL, 0x000fc400078e20ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000100f0e7825ULL, 0x100fe200078e0008ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000101b087825ULL, 0x000fe200078e0008ULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000101b108825ULL, 0x040fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008157faeULL, 0x000fe2000b901c46ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000101b278824ULL, 0x040fe200078e0226ULL,
0x003800000a157faeULL, 0x000fe2000b901c46ULL, 0x000000101b128825ULL, 0x000fc600078e0012ULL,
0x005800000c157faeULL, 0x000fe2000b901c46ULL, 0x000000ffff477224ULL, 0x000fc600078e00ffULL,
0x007800000e157faeULL, 0x000fe8000b901c46ULL, 0x0458000010178faeULL, 0x000fe8000b901c46ULL,
0x0418000012278faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000267805ULL, 0x004fe2000001ff00ULL, 0x00000008007c1947ULL, 0x002fec0003800000ULL,
0x00000003ff087819ULL, 0x000fe2000001161bULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0xfffffff8ff097812ULL, 0x000fe200078ee21bULL, 0x000000ffff157224ULL, 0x000fe200078e0053ULL,
0x0000000308087812ULL, 0x000fe400078ec0ffULL, 0x00000003090d7819ULL, 0x000fe200000006ffULL,
0x00000008090b7836ULL, 0x000fe20000000000ULL, 0x0000001c53507211ULL, 0x000fe200078e48ffULL,
0x00000008094a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff4e7819ULL, 0x000fe2000001161bULL,
0x0000000108097824ULL, 0x000fc400078e0209ULL, 0x00000001084b7824ULL, 0x000fe200078e020bULL,
0x000000030b087819ULL, 0x040fe200000006ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee209ULL, 0x00000004094c7836ULL, 0x000fe20000000000ULL,
0xfffffff8084b7812ULL, 0x000fe200078ee24bULL, 0x0000000c094d7836ULL, 0x000fe20000000000ULL,
0x000000084e487810ULL, 0x000fe20007ffe0ffULL, 0x0000010007507824ULL, 0x000fe200078e0250ULL,
0xfffffff80d4c7812ULL, 0x000fe400078ee24cULL, 0xfffffff80a4d7812ULL, 0x000fce00078ee24dULL,
0x0000000215497836ULL, 0x000fca0000000000ULL, 0x000000004900720cULL, 0x000fda0003f06070ULL,
0x0000000000a40947ULL, 0x000fea0003800000ULL, 0x000000071b00780cULL, 0x000fe20003f44070ULL,
0x000000011a167824ULL, 0x100fe200078e0249ULL, 0x00000001ff0a7819ULL, 0x000fe20000011649ULL,
0x000000201b0b7836ULL, 0x000fe40000000000ULL, 0x0000100016087825ULL, 0x000fe200078e0018ULL,
0x000000010a4f7812ULL, 0x000fc600078ec0ffULL, 0x000000401b517836ULL, 0x000fe20000000000ULL,
0x0000001d080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000040049087824ULL, 0x000fe400078e00ffULL,
0x00000200530ca824ULL, 0x140fe400078e021cULL, 0x000000ffff0f7224ULL, 0x000fe200000e0609ULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x00000200530aa824ULL, 0x000fe200078e021cULL,
0x0000000c0750a211ULL, 0x000fe200078e40ffULL, 0x000000601b557836ULL, 0x000fe20000000000ULL,
0x0000001e1610a211ULL, 0x000fe200078038ffULL, 0x000000101b127825ULL, 0x000fe200078e000eULL,
0x0000000920087210ULL, 0x000fc40007ffe0ffULL, 0x000000504f14a211ULL, 0x000fe200078e38ffULL,
0x000001000750a824ULL, 0x000fe200078e020aULL, 0x0000001f160ca211ULL, 0x040fe200078238ffULL,
0x000000101b177824ULL, 0x000fe200078e0208ULL, 0x000000231611a211ULL, 0x040fe200000f3cffULL,
0x000000100b087825ULL, 0x000fe200078e000eULL, 0x00000025160da211ULL, 0x000fe400008f3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000012177faeULL, 0x0003e2000b901c46ULL,
0x000000804f16a824ULL, 0x000fe200078e0250ULL, 0x000000141b4fa211ULL, 0x000fe200078e20ffULL,
0x00000010510a7825ULL, 0x100fe200078e000eULL, 0x0038000008177faeULL, 0x0003e6000b901c46ULL,
0x00000010550e7825ULL, 0x000fe200078e000eULL, 0x005800000a177faeULL, 0x0003e6000b901c46ULL,
0x000000101b10a825ULL, 0x040fe200078e0010ULL, 0x007800000e177faeULL, 0x0003e6000b901c46ULL,
0x000000101b0ca825ULL, 0x040fe200078e000cULL, 0x04580000104fafaeULL, 0x0003e6000b901c46ULL,
0x000000101b51a824ULL, 0x000fca00078e0216ULL, 0x041800000c51afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000004015087824ULL, 0x002fca00078e00ffULL,
0x0000008008087812ULL, 0x000fc800078ec0ffULL, 0x0000005021097210ULL, 0x000fe40007ffe008ULL,
0x0000000a15087819ULL, 0x000fc600000006ffULL, 0x00000001224f7824ULL, 0x000fe200078e0209ULL,
0x0000080008097812ULL, 0x000fc800078ec0ffULL, 0x0000018020147810ULL, 0x000fe20007ffe009ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180004f117984ULL, 0x000e620000000800ULL,
0x000000104a087824ULL, 0x100fe400078e0214ULL, 0x000000104c0c7824ULL, 0x100fe200078e0214ULL,
0x004580004f517984ULL, 0x000fe20000000800ULL, 0x000000104b107824ULL, 0x000fe200078e0214ULL,
0x000000144d147211ULL, 0x000fe400078e20ffULL, 0x000000000808783bULL, 0x000ea80000000200ULL,
0x000000000c0c783bULL, 0x000ee20000000200ULL, 0x0000001124157221ULL, 0x002fc60000010100ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x3fb8aa3b15567820ULL, 0x000fc60000410000ULL,
0x000000001414783bULL, 0x000f620000000200ULL, 0x30000009ff527230ULL, 0x004fe40000004100ULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x2000000bff557230ULL, 0x000fe40000004100ULL,
0x2000000fff597230ULL, 0x008fe40000004100ULL, 0x3000000fff587230ULL, 0x000fe40000004100ULL,
0x3000000bff547230ULL, 0x010fc40000004100ULL, 0x2000000dff577230ULL, 0x000fe40000004100ULL,
0x20000008ff4f7230ULL, 0x000fe40000004100ULL, 0x2000000cff0b7230ULL, 0x000fe40000004100ULL,
0x0000005156637220ULL, 0x004fe20000410000ULL, 0x20000009ff517230ULL, 0x000fe40000004100ULL,
0x3000000dff567230ULL, 0x000fe40000004100ULL, 0x0000004763477221ULL, 0x000fe20000010000ULL,
0x00001f4e63647589ULL, 0x000ea200000e0000ULL, 0x2000000aff097230ULL, 0x000fc40000004100ULL,
0x2000000eff0d7230ULL, 0x000fe20000004100ULL, 0x00001f4863657589ULL, 0x000ee200000e0000ULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x3000000cff0c7230ULL, 0x000fe40000004100ULL, 0x3000000eff0e7230ULL, 0x000fe40000004100ULL,
0x20000012ff5c7230ULL, 0x002fc40000004100ULL, 0x30000012ff5b7230ULL, 0x000fe40000004100ULL,
0x20000015ff5d7230ULL, 0x020fe40000004100ULL, 0x30000015ff627230ULL, 0x000fe40000004100ULL,
0x000000ffff157224ULL, 0x000fe400078e0049ULL, 0x20000010ff5a7230ULL, 0x000fe40000004100ULL,
0x000000644f3c7223ULL, 0x004fe2000001003cULL, 0x30000010ff0f7230ULL, 0x000fe20000004100ULL,
0x000000001500720cULL, 0x000fe20003f06070ULL, 0x20000013ff127230ULL, 0x000fc40000004100ULL,
0x00000064083b7223ULL, 0x080fe2000001003bULL, 0x30000013ff607230ULL, 0x000fe40000004100ULL,
0x00000064513a7223ULL, 0x080fe2000001003aULL, 0x20000011ff107230ULL, 0x000fe40000004100ULL,
0x0000006452397223ULL, 0x080fe20000010039ULL, 0x20000014ff137230ULL, 0x000fe40000004100ULL,
0x0000006409387223ULL, 0x000fe20000010038ULL, 0x20000016ff5f7230ULL, 0x000fc40000004100ULL,
0x000000640a377223ULL, 0x080fe20000010037ULL, 0x20000017ff617230ULL, 0x000fe40000004100ULL,
0x0000006455367223ULL, 0x080fe20000010036ULL, 0x30000011ff117230ULL, 0x000fe40000004100ULL,
0x0000006454457223ULL, 0x080fe20000010045ULL, 0x30000014ff147230ULL, 0x000fe40000004100ULL,
0x000000640b447223ULL, 0x000fe20000010044ULL, 0x30000016ff167230ULL, 0x000fc40000004100ULL,
0x000000640c437223ULL, 0x080fe20000010043ULL, 0x30000017ff177230ULL, 0x000fe40000004100ULL,
0x0000006457427223ULL, 0x080fe20000010042ULL, 0x0000006456417223ULL, 0x080fe20000010041ULL,
0x000000640d407223ULL, 0x080fe20000010040ULL, 0x000000640e3f7223ULL, 0x080fe2000001003fULL,
0x00000064593e7223ULL, 0x080fe2000001003eULL, 0x00000064583d7223ULL, 0x000fe2000001003dULL,
0x000000655a277223ULL, 0x088fe20000010027ULL, 0x000000650f347223ULL, 0x080fe20000010034ULL,
0x0000006510337223ULL, 0x080fe20000010033ULL, 0x0000006511327223ULL, 0x080fe20000010032ULL,
0x000000655c317223ULL, 0x080fe20000010031ULL, 0x000000655b307223ULL, 0x080fe20000010030ULL,
0x00000065122f7223ULL, 0x080fe2000001002fULL, 0x0000006560357223ULL, 0x080fe20000010035ULL,
0x00000065132e7223ULL, 0x080fe2000001002eULL, 0x00000065142d7223ULL, 0x080fe2000001002dULL,
0x000000655d2c7223ULL, 0x080fe2000001002cULL, 0x00000065622b7223ULL, 0x080fe2000001002bULL,
0x000000655f2a7223ULL, 0x080fe2000001002aULL, 0x0000006516297223ULL, 0x080fe20000010029ULL,
0x0000006561287223ULL, 0x080fe20000010028ULL, 0x0000006517267223ULL, 0x000fe20000010026ULL,
0xfffffff400dc8947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001000087824ULL, 0x002fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x000049801c007836ULL, 0x000fc60000000000ULL,
0x00000070080b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c090a7812ULL, 0x000fca00078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x00000080531c7824ULL, 0x000fe200078e021cULL, 0x0000000408097819ULL, 0x002fe400000006ffULL,
0x00000001ff087819ULL, 0x000fe40000011608ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000001c081c7210ULL, 0x000fca0007ffe009ULL,
0x004980471c007388ULL, 0x0003e40000000800ULL, 0x000000000a007210ULL, 0x000fe20007ffe00bULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000087984ULL, 0x000ea80000000800ULL,
0x0000800000097984ULL, 0x000ee20000000800ULL, 0x00000008ff087221ULL, 0x004fc80000010000ULL,
0x0000000908087221ULL, 0x008fc80000010000ULL, 0x0180000008097836ULL, 0x000fca0000000000ULL,
0x7f80000009097812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0900780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff567224ULL, 0x000fe200078e0008ULL, 0x0000ac10000d7802ULL, 0x000fce0000000f00ULL,
0x0000008c00f87944ULL, 0x012fea0003c00000ULL, 0x0000000c00007202ULL, 0x000fe20000000f00ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000800097308ULL, 0x000ea40000001000ULL,
0xbf80000008007423ULL, 0x004fc80000000009ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000009007223ULL, 0x000fce0000000009ULL, 0x00000000001b7919ULL, 0x000ea40000000000ULL,
0x00000002ff0d7819ULL, 0x104fe4000001161bULL, 0x000000081b117811ULL, 0x000fe400078ff0ffULL,
0x00000003ff197819ULL, 0x000fe2000001161bULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0d00087589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff177812ULL, 0x000fc600078ee21bULL,
0x00001f1100117589ULL, 0x00076400000e0000ULL, 0x00000008171a7824ULL, 0x040fe400078e00ffULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000003c083c7220ULL, 0x044fe20000410000ULL, 0x0000003b083b7220ULL, 0x040fe20000410000ULL,
0x0000003a08097220ULL, 0x040fe20000410000ULL, 0x00000039080a7220ULL, 0x040fe20000410000ULL,
0x0000003808387220ULL, 0x040fe20000410000ULL, 0x0000003708377220ULL, 0x040fe20000410000ULL,
0x00000036080b7220ULL, 0x040fe20000410000ULL, 0x00000045080c7220ULL, 0x040fe20000410000ULL,
0x0000004408447220ULL, 0x040fe20000410000ULL, 0x0000004308437220ULL, 0x040fe20000410000ULL,
0x00000042080d7220ULL, 0x040fe20000410000ULL, 0x0000004108007220ULL, 0x048fe20000410000ULL,
0x00000040080e7220ULL, 0x040fe20000410000ULL, 0x0000003f083f7220ULL, 0x040fe20000410000ULL,
0x0000003e080f7220ULL, 0x040fe20000410000ULL, 0x0000003d08107220ULL, 0x000fe20000410000ULL,
0x0000000319087812ULL, 0x000fe200078ec0ffULL, 0x0000002711277220ULL, 0x062fe20000410000ULL,
0x0000003411347220ULL, 0x040fe20000410000ULL, 0x0000003311337220ULL, 0x040fe20000410000ULL,
0x0000003211327220ULL, 0x040fe20000410000ULL, 0x0000003111127220ULL, 0x040fe20000410000ULL,
0x0000003011137220ULL, 0x040fe20000410000ULL, 0x0000002f112f7220ULL, 0x040fe20000410000ULL,
0x0000003511147220ULL, 0x040fe20000410000ULL, 0x0000002e112e7220ULL, 0x040fe20000410000ULL,
0x0000002d112d7220ULL, 0x040fe20000410000ULL, 0x0000002c112c7220ULL, 0x040fe20000410000ULL,
0x0000002b112b7220ULL, 0x040fe20000410000ULL, 0x0000002a112a7220ULL, 0x040fe20000410000ULL,
0x0000002911297220ULL, 0x040fe20000410000ULL, 0x0000002811287220ULL, 0x040fe20000410000ULL,
0x0000002611157220ULL, 0x000fe20000410000ULL, 0x0000000817117836ULL, 0x000fe20000000000ULL,
0x0000001708177210ULL, 0x000fc40007ffe0ffULL, 0x000000090a09723eULL, 0x000fe200000000ffULL,
0x0000000108167824ULL, 0x000fe200078e0211ULL, 0x0000000417087810ULL, 0x000fe20007ffe0ffULL,
0x00000008111d7824ULL, 0x000fe200078e00ffULL, 0x00000038370a723eULL, 0x000fe200000000ffULL,
0x0000000811217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f117812ULL, 0x000fe200078ee208ULL,
0x0000000c17187836ULL, 0x000fe20000000000ULL, 0xfffffff81a177812ULL, 0x000fe400078ee217ULL,
0xfffffff81d1d7812ULL, 0x000fc400078ee216ULL, 0xfffffff8211f7812ULL, 0x000fe200078ee218ULL,
0x0000001017187824ULL, 0x100fe200078e0202ULL, 0x00000002111a7211ULL, 0x000fe200078e20ffULL,
0x000000101d307824ULL, 0x100fe200078e0202ULL, 0x0000003c3b08723eULL, 0x000fe200000000ffULL,
0x000000101f027824ULL, 0x000fe200078e0202ULL, 0x0000000b0c0b723eULL, 0x000fe400000000ffULL,
0x00000028151f723eULL, 0x000fe200000000ffULL, 0x0000000146157824ULL, 0x000fe200078e021bULL,
0x00000044430c723eULL, 0x000fe200000000ffULL, 0x0000000818007844ULL, 0x000fe20000000200ULL,
0x0000000d000d723eULL, 0x000fe200000000ffULL, 0x0000001015007824ULL, 0x000fe200078e0204ULL,
0x0000000e3f0e723eULL, 0x000fc400000000ffULL, 0x0000000f100f723eULL, 0x000fe400000000ffULL,
0x000000121312723eULL, 0x000fe400000000ffULL, 0x000000273410723eULL, 0x000fe200000000ffULL,
0x0000000c1a007844ULL, 0x000fe20000000200ULL, 0x000000333211723eULL, 0x000fe400000000ffULL,
0x0000002f1413723eULL, 0x000fe400000000ffULL, 0x0000002e2d1c723eULL, 0x000fc400000000ffULL,
0x0000002c2b1d723eULL, 0x000fe200000000ffULL, 0x0000001030007844ULL, 0x000fe20000000200ULL,
0x0000002a291e723eULL, 0x000fca00000000ffULL, 0x0000001c02007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000147984ULL, 0x000e680000000c00ULL,
0x0004000000247984ULL, 0x000ea80000000c00ULL, 0x0008000000207984ULL, 0x000ee80000000c00ULL,
0x000c000000287984ULL, 0x000f620000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000002317177230ULL, 0x008fe40000000000ULL,
0x0000002216167230ULL, 0x000fe40000000000ULL, 0x0000002115157230ULL, 0x000fe40000000000ULL,
0x0000002014147230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x020fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001400007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002400007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff5300720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000061900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000000800027d06ULL, 0x000ea20008209000ULL, 0x000000015e007824ULL, 0x002fe200078e0219ULL,
0x00000008ff177c12ULL, 0x000fe2000f8e33ffULL, 0x0000000119197824ULL, 0x000fe200078e021bULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000200027308ULL, 0x004e640000001000ULL, 0x0ffffffe020a7810ULL, 0x002fcc0007ffe0ffULL,
0x0000000a00097305ULL, 0x0002a4000021f000ULL, 0x000000201b0a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff117819ULL, 0x000fe2000001160aULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a09ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b09157227ULL, 0x000fcc00078e0008ULL,
0x0000000015087227ULL, 0x000fca00078e00ffULL, 0x000000ff08097210ULL, 0x000fca0007ffe1ffULL,
0x0000000809027c24ULL, 0x000fca000f8e0200ULL, 0x0000000802007c0cULL, 0x000fda000bf06070ULL,
0x8000000802020c36ULL, 0x000fe40008000000ULL, 0x0000000108080836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000802007c0cULL, 0x000fe4000bf26070ULL,
0x0000000719027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802097812ULL, 0x000fc800078ef81bULL,
0x0000000409027211ULL, 0x000fc600078e20ffULL, 0x0000000108081836ULL, 0x000fe40000000000ULL,
0x00000000020c7984ULL, 0x0002a60000000c00ULL, 0x0000000817087207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a08ULL, 0x000000071b027812ULL, 0x002fe200078ec0ffULL,
0x0000000908097c24ULL, 0x000fe4000f8e0205ULL, 0x000000080b007c24ULL, 0x000fe4000f8e0200ULL,
0x00000008070b7824ULL, 0x000fe400078e0202ULL, 0x0000000809007c24ULL, 0x000fca000f8e0200ULL,
0x0000000003007210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000400087c11ULL, 0x000fc8000f8240ffULL, 0x0000000500097c11ULL, 0x000fe400088f4409ULL,
0x000000061100720cULL, 0x000fe20003f26070ULL, 0x000000100b087825ULL, 0x000fca00078e0008ULL,
0x0000000c08007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000015e007824ULL, 0x100fe400078e0211ULL, 0x000000010a117824ULL, 0x000fe400078e0211ULL,
0x0000000015027227ULL, 0x000fc600078e00ffULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x002fc600078e0a02ULL, 0x0ffffff811117812ULL, 0x000fe200078ef80aULL,
0x0000000809087c24ULL, 0x000fc8000f8e0200ULL, 0x0000001011117824ULL, 0x000fe200078e0204ULL,
0x0000000808007c0cULL, 0x000fca000bf26070ULL, 0x0000000011107984ULL, 0x000e700000000c00ULL,
0x8000000808081c10ULL, 0x000fe2000fffe0ffULL, 0x0000000102021836ULL, 0x000fc60000000000ULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000102022810ULL, 0x000fc80007ffe0ffULL,
0x0000000217027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902097c24ULL, 0x000fe4000f8e0205ULL, 0x000000080b007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000809007c24ULL, 0x000fca000f8e0200ULL, 0x0000000003027210ULL, 0x000fe40007f3e0ffULL,
0x000000070a007812ULL, 0x000fe200078ec0ffULL, 0x000000401b0a7836ULL, 0x000fe40000000000ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x0000000402087c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0d7819ULL, 0x000fe4000001160aULL, 0x0000000502097c11ULL, 0x000fc400088f4409ULL,
0x000000060d00720cULL, 0x000fe40003f26070ULL, 0x00000000070b7211ULL, 0x000fca00078e18ffULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000001008007986ULL, 0x0023e2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000015e007824ULL, 0x000fe200078e020dULL,
0x0000000d0a0d7210ULL, 0x000fc60007ffe0ffULL, 0x0000000015027227ULL, 0x000fe200078e00ffULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff097224ULL, 0x002fe200078e0a02ULL,
0x0ffffff80d0d7812ULL, 0x000fc600078ef80aULL, 0x0000000809087c24ULL, 0x000fe4000f8e0200ULL,
0x000000100d0d7824ULL, 0x000fc600078e0204ULL, 0x0000000808007c0cULL, 0x000fc6000bf26070ULL,
0x000000000d0c7984ULL, 0x000e740000000c00ULL, 0x8000000808081c36ULL, 0x000fc40008000000ULL,
0x0000000102021836ULL, 0x000fc60000000000ULL, 0x0000000808007c0cULL, 0x000fda000bf46070ULL,
0x0000000102022836ULL, 0x000fca0000000000ULL, 0x0000000217027207ULL, 0x000fc80004000000ULL,
0x000000ff020b7210ULL, 0x000fe20007ffe1ffULL, 0x0000000902097c24ULL, 0x000fc8000f8e0205ULL,
0x000000080b007c24ULL, 0x000fc8000f8e0200ULL, 0x0000000809007c24ULL, 0x000fca000f8e0200ULL,
0x0000000003027210ULL, 0x000fe40007f3e0ffULL, 0x000000070a007812ULL, 0x000fe200078ec0ffULL,
0x000000601b0a7836ULL, 0x000fe40000000000ULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000402087c11ULL, 0x040fe2000f8240ffULL, 0x00000008070b7824ULL, 0x000fe200078e0200ULL,
0x00000003ff117819ULL, 0x000fe4000001160aULL, 0x0000000502097c11ULL, 0x000fc400088f4409ULL,
0x000000061100720cULL, 0x000fe40003f26070ULL, 0x000000115e5e7210ULL, 0x000fe20007ffe0ffULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000000c08007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000005e15007227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x002fe400078e0a00ULL, 0x000000010a117824ULL, 0x000fe400078e0211ULL,
0x0000000809027c24ULL, 0x000fc6000f8e025eULL, 0x0000000711117812ULL, 0x000fe400078ec0ffULL,
0x0000000802007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff811117812ULL, 0x000fca00078ef80aULL,
0x0000001011117824ULL, 0x000fcc00078e0204ULL, 0x8000000802021c36ULL, 0x000fe20008000000ULL,
0x0000000100001810ULL, 0x000fe20007ffe0ffULL, 0x0000000011107984ULL, 0x000e660000000c00ULL,
0x0000000802007c0cULL, 0x000fda000bf46070ULL, 0x0000000100002836ULL, 0x000fca0000000000ULL,
0x0000000017007207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a00ULL,
0x0000000900057c24ULL, 0x000fe2000f8e0205ULL, 0x000000070a007812ULL, 0x000fe200078ec0ffULL,
0x00000008095e7c24ULL, 0x000fc8000f8e025eULL, 0x00000008055e7c24ULL, 0x000fe4000f8e025eULL,
0x0000000807077824ULL, 0x000fc600078e0200ULL, 0x0000005e035e7210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff037210ULL, 0x000fe400007fe4ffULL, 0x000000045e027c11ULL, 0x000fc8000f8040ffULL,
0x000000055e037c11ULL, 0x000fc600080f4403ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000001002007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000460597824ULL, 0x000fe200078e025dULL, 0x0000000100077802ULL, 0x000fe20000000f00ULL,
0xffffffffff587424ULL, 0x000fe200078e00ffULL, 0x00009000ff0a7b82ULL, 0x000e620000000a00ULL,
0x000000400e0e7824ULL, 0x000fe200078e00ffULL, 0x0000005b5900720cULL, 0x000fe20003f06070ULL,
0x0000840000047ab9ULL, 0x000fd80000000800ULL, 0x00009600ff038b82ULL, 0x000ea20000000800ULL,
0x0000000208068824ULL, 0x000fce00078e00ffULL, 0x00009200ff108b82ULL, 0x000ee20000000a00ULL,
0x0000000306038224ULL, 0x004fe400078e0259ULL, 0x01b60007020679a7ULL, 0x0004a4000850003fULL,
0x0000000403108825ULL, 0x008fca00078e0010ULL, 0x0000000610588981ULL, 0x000ee2000c1e1900ULL,
0x0000000160037836ULL, 0x000fe20000000000ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x000000065d0f7819ULL, 0x000fc600000006ffULL, 0x0000005a0300720cULL, 0x000fe20003f06070ULL,
0x000000053f047899ULL, 0x000fe20008011604ULL, 0x0000000e58037224ULL, 0x008fc800078e02ffULL,
0x00000100030a7825ULL, 0x002fc800078e000aULL, 0x0000004005037824ULL, 0x000fc600078e00ffULL,
0x0000000c00248947ULL, 0x004fea0003800000ULL, 0x00000100600d7824ULL, 0x000fe200078e020fULL,
0x00000003ff177819ULL, 0x000fc80000011604ULL, 0x0000000d5c167248ULL, 0x000fe20007fe0000ULL,
0x0000000417117836ULL, 0x000fe20000000000ULL, 0x0000000417127210ULL, 0x000fe20007ffe0ffULL,
0x0000000817137836ULL, 0x000fe20000000000ULL, 0x000000160d167210ULL, 0x000fe20007ffe1ffULL,
0x00000001110d7824ULL, 0x140fe400078e0204ULL, 0x00000008111e7824ULL, 0x040fe200078e00ffULL,
0x000000161100720cULL, 0x080fe20003f46070ULL, 0x0000000813207824ULL, 0x040fe200078e00ffULL,
0x0000000c17117810ULL, 0x000fe20007ffe0ffULL, 0x00000018171f7836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000001130d7824ULL, 0x140fe200078e0204ULL,
0x000000161300720cULL, 0x080fe20003f66070ULL, 0x0000000111107824ULL, 0x140fe200078e0204ULL,
0x0000000311157819ULL, 0x040fe200000006ffULL, 0x0000001017137836ULL, 0x000fe20000000000ULL,
0x000000161100720cULL, 0x080fe20003f86070ULL, 0x000000081f2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff815247812ULL, 0x000fe200078ee210ULL, 0x0000000113107824ULL, 0x140fe200078e0204ULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0x0000001417157810ULL, 0x000fe20007ffe0ffULL, 0x00000040050d7824ULL, 0x000fe200078e0217ULL,
0x000000161300720cULL, 0x080fe20003fa6070ULL, 0x00000038172b7836ULL, 0x000fe20000000000ULL,
0xfffffff811267812ULL, 0x000fe200078ee210ULL, 0x0000000115187824ULL, 0x040fe200078e0204ULL,
0x0000000712137812ULL, 0x000fe200078ec0ffULL, 0x0000000815057824ULL, 0x040fe200078e00ffULL,
0x000000161500720cULL, 0x000fe20003f06070ULL, 0x000001000d107825ULL, 0x000fe200078e00ffULL,
0x0ffffff8131a7812ULL, 0x000fc400078ef804ULL, 0xfffffff805187812ULL, 0x000fe200078ee218ULL,
0x000000040d127836ULL, 0x000fe20000000000ULL, 0x0000007010157812ULL, 0x000fe200078ef809ULL,
0x000040005d057824ULL, 0x000fe200078e0202ULL, 0x000000080d107810ULL, 0x000fe20007ffe0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000150a147210ULL, 0x000fe40007fde0ffULL,
0x000000161700720cULL, 0x000fe20003f26070ULL, 0x0000100005057836ULL, 0x000fe20000000000ULL,
0x00000070121b7812ULL, 0x000fe200078ef809ULL, 0x000000010b157824ULL, 0x000fe200030e0611ULL,
0x000000041f217210ULL, 0x000fe20007ffe0ffULL, 0x000000101a197824ULL, 0x000fe200078e0205ULL,
0x0000001b0a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fc600078ee221ULL, 0x0000000c0d127836ULL, 0x000fe20000000000ULL,
0x00000070101d7812ULL, 0x000fe200078ef809ULL, 0x000000010b1b7824ULL, 0x000fe200030e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c901c46ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000001d0a1c7210ULL, 0x000fe40007fde0ffULL,
0x000000161f00720cULL, 0x000fe20003f26070ULL, 0x0000001c17217836ULL, 0x000fe20000000000ULL,
0x000000100d107810ULL, 0x000fe20007ffe0ffULL, 0x000000010b1d7824ULL, 0x000fe200030e0611ULL,
0x00000070121f7812ULL, 0x000fe200078ef809ULL, 0x000000140d127836ULL, 0x000fe20000000000ULL,
0x0000000421227210ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fc800078e00ffULL,
0x000000101e197824ULL, 0x002fe200078e0205ULL, 0x0000001f0a1e7210ULL, 0x000fe40007fde0ffULL,
0x0000007010157812ULL, 0x000fe400078ef809ULL, 0x000000001a197faeULL, 0x0003e2000d101c46ULL,
0x000000162100720cULL, 0x040fe20003f46070ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x000000180d107810ULL, 0x000fe20007ffe0ffULL, 0x000000010b1f7824ULL, 0x000fe200030e0613ULL,
0x000000150a147210ULL, 0x000fe20007fde0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffff8212c7812ULL, 0x000fc600078ee222ULL, 0x000000010b157824ULL, 0x000fe200030e0611ULL,
0x0000007012217812ULL, 0x000fe200078ef809ULL, 0x0000001020197824ULL, 0x002fe200078e0205ULL,
0x0000001c0d127810ULL, 0x000fe20007ffe0ffULL, 0x00000020171b7836ULL, 0x000fe20000000000ULL,
0x000000210a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000001c197faeULL, 0x0003e4000d901c46ULL, 0x000000161b00720cULL, 0x040fe20003f66070ULL,
0x000000011b207824ULL, 0x040fe200078e0204ULL, 0x0000007010217812ULL, 0x000fe200078ef809ULL,
0x000000081b237824ULL, 0x000fc400078e00ffULL, 0x000000010b1b7824ULL, 0x000fe200030e0613ULL,
0x000000210a107210ULL, 0x000fe20007fde0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffff823227812ULL, 0x000fe400078ee220ULL, 0x0000000524197211ULL, 0x002fe200078e20ffULL,
0x00000024171d7836ULL, 0x000fe20000000000ULL, 0x0000007012217812ULL, 0x000fe200078ef809ULL,
0x000000200d1c7836ULL, 0x000fe40000000000ULL, 0x000000011d207824ULL, 0x040fe200078e0204ULL,
0x000000031d237819ULL, 0x040fe200000006ffULL, 0x000000001e197faeULL, 0x0003e2000e101c46ULL,
0x000000161d00720cULL, 0x000fe20003f86070ULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff823247812ULL, 0x000fc400078ee220ULL, 0x0000002817237810ULL, 0x000fe20007ffe0ffULL,
0x000000010b117824ULL, 0x000fe200030e0611ULL, 0x000000210a127210ULL, 0x000fe20007fde0ffULL,
0x000000240d207836ULL, 0x000fe20000000000ULL, 0x000000701c277812ULL, 0x000fe200078ef809ULL,
0x000000280d217836ULL, 0x000fe40000000000ULL, 0x00000100201e7825ULL, 0x002fc800078e00ffULL,
0x000000010b137824ULL, 0x000fe200030e0613ULL, 0x000000270a1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001026197824ULL, 0x000fe200078e0205ULL, 0x000000701e277812ULL, 0x000fe200078ef809ULL,
0x0000010021207825ULL, 0x000fe200078e00ffULL, 0x0000000323267819ULL, 0x000fe400000006ffULL,
0x0000000014197faeULL, 0x0003e2000e901c46ULL, 0x000000010b1d7824ULL, 0x000fe200030e061dULL,
0x000000270a1e7210ULL, 0x000fe20007fde0ffULL, 0x0000000123257824ULL, 0x140fe200078e0204ULL,
0x000000162300720cULL, 0x000fe20003fa6070ULL, 0x0000001024297824ULL, 0x000fe200078e0205ULL,
0x0000007020237812ULL, 0x000fe200078ef809ULL, 0x000000010b1f7824ULL, 0x000fe200030e061fULL,
0xfffffff826267812ULL, 0x000fe200078ee225ULL, 0x0000002c17257836ULL, 0x000fe20000000000ULL,
0x000000300d207810ULL, 0x000fe20007ffe0ffULL, 0x0000002c0d197836ULL, 0x002fe20000000000ULL,
0x000000230a147210ULL, 0x000fe20007fde0ffULL, 0x0000000125277824ULL, 0x000fe200078e0204ULL,
0x0000000518237211ULL, 0x000fe200078e20ffULL, 0x0000010019187825ULL, 0x000fc800078e00ffULL,
0x000000010b157824ULL, 0x000fe200030e0621ULL, 0x0000007018217812ULL, 0x000fe200078ef809ULL,
0x0000000825287824ULL, 0x040fe200078e00ffULL, 0x000000001a237faeULL, 0x0003e2000c101c46ULL,
0x000000162500720cULL, 0x000fe20003f06070ULL, 0x0000003017257836ULL, 0x000fe20000000000ULL,
0x000000210a187210ULL, 0x000fe20007fde0ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fc600078ee227ULL, 0x000000010b197824ULL, 0x000fe200030e0619ULL,
0x0000007020277812ULL, 0x000fe200078ef809ULL, 0x000000340d207836ULL, 0x000fe20000000000ULL,
0x000000052a237211ULL, 0x002fe200078e20ffULL, 0x00000001251b7824ULL, 0x040fe200078e0204ULL,
0x000000270a1a7210ULL, 0x000fe20007fde0ffULL, 0x00000008252a7824ULL, 0x040fe400078e00ffULL,
0x0000000010237faeULL, 0x0003e2000c901c46ULL, 0x000000162500720cULL, 0x080fe20003f26070ULL,
0x000000102c257824ULL, 0x100fe200078e0205ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee21bULL,
0x0000001022277824ULL, 0x000fe200078e0205ULL, 0x000000210b1b7210ULL, 0x000fe200037fe4ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000000012257faeULL, 0x0005e8000d101c46ULL,
0x000000001c277faeULL, 0x0007e2000d901c46ULL, 0x0000007020117812ULL, 0x002fe200078ef809ULL,
0x000000380d107836ULL, 0x000fe20000000000ULL, 0x0000003417237810ULL, 0x000fe20007ffe0ffULL,
0x0000003c17177836ULL, 0x000fe20000000000ULL, 0x000000110a207210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000001e297faeULL, 0x0003e2000e101c46ULL,
0x000000162300720cULL, 0x000fc40003f86070ULL, 0x0000003c0d127836ULL, 0x004fe20000000000ULL,
0x000000162b00720cULL, 0x0c0fe20003f66070ULL, 0x000000082b1c7824ULL, 0x008fe200078e00ffULL,
0x000000161700720cULL, 0x000fe20003f46070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000070101d7812ULL, 0x000fe400078ef809ULL, 0x000000042b0d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000123167824ULL, 0x100fe200078e0204ULL, 0x000000210b217210ULL, 0x000fe200037fe4ffULL,
0x0000000117047824ULL, 0x000fe200078e0204ULL, 0x0000001d0a107210ULL, 0x000fe20007fde0ffULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x00000070121d7812ULL, 0x000fe200078ef809ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL,
0x0000001026097824ULL, 0x100fe200078e0205ULL, 0xfffffff823167812ULL, 0x000fe200078ee216ULL,
0x00000010280d7824ULL, 0x100fe200078e0205ULL, 0xfffffff8171e7812ULL, 0x002fe200078ee204ULL,
0x000000102a177824ULL, 0x100fe200078e0205ULL, 0x000000110b117210ULL, 0x000fe200037fe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0205ULL, 0x0000001d0a047210ULL, 0x000fe20007fde0ffULL,
0x000000101e237824ULL, 0x000fe200078e0205ULL, 0x00000005161d7211ULL, 0x000fe200078e20ffULL,
0x0000000014097faeULL, 0x0003e4000e901c46ULL, 0x000000010b057824ULL, 0x000fc400030e0613ULL,
0x00000000180d7faeULL, 0x0003e8000c101c46ULL, 0x000000001a177faeULL, 0x0003e8000c901c46ULL,
0x00000000201d7faeULL, 0x0003e8000e101c46ULL, 0x00000000101f7faeULL, 0x0003e8000d901c46ULL,
0x0000000004237faeULL, 0x0003e2000d101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000c041a7811ULL, 0x040fe400078fe8ffULL, 0x0000000404147811ULL, 0x040fe400078fe8ffULL,
0x00000010041b7811ULL, 0x000fe200078fe8ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0x00000024041d7811ULL, 0x000fe200078fe8ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x000000041a0d7210ULL, 0x000fe20007ffe0ffULL, 0x000000011b107824ULL, 0x040fe200078e0204ULL,
0x0000000414057210ULL, 0x000fe20007ffe0ffULL, 0x000000081b137824ULL, 0x000fe200078e00ffULL,
0x0000000804177811ULL, 0x000fe200078fe8ffULL, 0x000000081d1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fc400078ee20dULL, 0x0000001804317811ULL, 0x040fe200078fe8ffULL,
0x0000000817187824ULL, 0x040fe200078e00ffULL, 0x000000041d0d7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x0000000117057824ULL, 0x100fe200078e0204ULL,
0x00000028041e7811ULL, 0x040fe400078fe8ffULL, 0x0000001404217811ULL, 0x040fe400078fe8ffULL,
0xfffffff813307812ULL, 0x000fe200078ee210ULL, 0x0000000131107824ULL, 0x140fe200078e0204ULL,
0x00000020041f7811ULL, 0x000fe200078fe8ffULL, 0x0000000831137824ULL, 0x000fe200078e00ffULL,
0xfffffff81c357812ULL, 0x000fe200078ee20dULL, 0x000000011e0d7824ULL, 0x100fe200078e0204ULL,
0x0000002c041c7811ULL, 0x000fe200078fe8ffULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x0000000821367824ULL, 0x000fe200078e00ffULL,
0x0000001c04197811ULL, 0x040fe200078fe8ffULL, 0x000000011f057824ULL, 0x040fe200078e0204ULL,
0x00000034042c7811ULL, 0x000fe200078fe8ffULL, 0x000000081f127824ULL, 0x000fe200078e00ffULL,
0x0000000421117210ULL, 0x000fe20007ffe0ffULL, 0x00000008193a7824ULL, 0x000fe200078e00ffULL,
0xfffffff813387812ULL, 0x000fe200078ee210ULL, 0x000000081c137824ULL, 0x000fe200078e00ffULL,
0x000000041c107210ULL, 0x000fe20007ffe0ffULL, 0x000000082c157824ULL, 0x000fe200078e00ffULL,
0xfffffff822377812ULL, 0x000fe200078ee20dULL, 0x00000001031f7824ULL, 0x040fe200078e021fULL,
0x00000004040d7211ULL, 0x000fe200078fe8ffULL, 0x00000001033c7824ULL, 0x000fe200078e022cULL,
0xfffffff836367812ULL, 0x000fc400078ee211ULL, 0xfffffff812057812ULL, 0x000fe400078ee205ULL,
0x0000000419117210ULL, 0x000fe40007ffe0ffULL, 0x0000003004327811ULL, 0x000fe400078fe8ffULL,
0x000000042c127210ULL, 0x000fe40007ffe0ffULL, 0xfffffff813227812ULL, 0x000fe200078ee210ULL,
0x0000000832247824ULL, 0x000fe200078e00ffULL, 0x0000003804347811ULL, 0x000fc400078fe8ffULL,
0x0000003c042e7811ULL, 0x000fe400078fe8ffULL, 0x000000070d137812ULL, 0x000fe200078ec0ffULL,
0x0000000834287824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL,
0x0000000132117824ULL, 0x000fe200078e0204ULL, 0xfffffff815267812ULL, 0x000fe200078ee212ULL,
0x0000000103127824ULL, 0x000fe200078e0214ULL, 0x0000000304107211ULL, 0x000fe200078fe8ffULL,
0x000040005d157824ULL, 0x000fe200078e0202ULL, 0x00000004340d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000103407824ULL, 0x000fe200078e022eULL, 0x0ffffff813147812ULL, 0x000fe200078ef804ULL,
0x000000012e047824ULL, 0x040fe200078e0204ULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000082e137824ULL, 0x000fe200078e00ffULL, 0x0000100015157810ULL, 0x000fe20007ffe0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fc400078ee20dULL,
0xfffffff8132a7812ULL, 0x000fe200078ee204ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000070100d7812ULL, 0x000fe400078ef809ULL, 0x0000001520277211ULL, 0x080fe200078e20ffULL,
0x0000001005337824ULL, 0x000fe200078e0215ULL, 0x0000007012057812ULL, 0x000fe200078ef809ULL,
0x0000000103127824ULL, 0x040fe200078e0217ULL, 0x0000000d0a047210ULL, 0x000fe20007f1e0ffULL,
0x00000010140d7824ULL, 0x000fe200078e0215ULL, 0x000000050a107210ULL, 0x000fe20007f3e0ffULL,
0x0000000103147824ULL, 0x000fe200078e021aULL, 0x000000153a2f7211ULL, 0x080fe200078e20ffULL,
0x000000010b057824ULL, 0x000fe200000e0611ULL, 0x0000001522227211ULL, 0x080fe200078e20ffULL,
0x0000001016237824ULL, 0x100fe200078e0215ULL, 0x000000152a2a7211ULL, 0x000fe200078e20ffULL,
0x0000001018257824ULL, 0x100fe200078e0215ULL, 0x000000130b117210ULL, 0x000fe20000ffe4ffULL,
0x0000001030297824ULL, 0x100fe200078e0215ULL, 0x00000034033e7210ULL, 0x000fe20007ffe0ffULL,
0x00000010362b7824ULL, 0x100fe200078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000b901c46ULL, 0x00000010382d7824ULL, 0x000fc400078e0215ULL,
0x0000001035357824ULL, 0x100fe200078e0215ULL, 0x0000000010237faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e0215ULL, 0x0000001024247824ULL, 0x100fe400078e0215ULL,
0x0000001026267824ULL, 0x100fe400078e0215ULL, 0x0000001028287824ULL, 0x000fe400078e0215ULL,
0x0000010012127825ULL, 0x000fc800078e00ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x00000070123b7812ULL, 0x000fc600078ef809ULL, 0x0000000103207824ULL, 0x040fe200078e0221ULL,
0x0000003b0a127210ULL, 0x000fe20007f1e0ffULL, 0x00000001031a7824ULL, 0x040fe200078e0231ULL,
0x0000007014317812ULL, 0x000fe200078ef809ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x000000130b137210ULL, 0x000fe400007fe4ffULL, 0x000000310a147210ULL, 0x000fe20007f3e0ffULL,
0x0000000103167824ULL, 0x000fe200078e021bULL, 0x0000007020317812ULL, 0x000fe200078ef809ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000012257faeULL, 0x0003e4000b901c46ULL,
0x000000310a187210ULL, 0x000fe20007f1e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000701a317812ULL, 0x000fc600078ef809ULL, 0x0000000103207824ULL, 0x040fe200078e0219ULL,
0x000000210b197210ULL, 0x000fe200007fe4ffULL, 0x0000000103387824ULL, 0x040fe200078e021eULL,
0x0000007016397812ULL, 0x000fe200078ef809ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x000000310a1a7210ULL, 0x000fe40007f1e0ffULL, 0x000000390a167210ULL, 0x000fe20007f5e0ffULL,
0x0000000103307824ULL, 0x000fe200078e021dULL, 0x00000070203b7812ULL, 0x000fe200078ef809ULL,
0x0000010038387825ULL, 0x000fe200078e00ffULL, 0x0000001b0b1b7210ULL, 0x000fc600007fe4ffULL,
0x000001001f1e7825ULL, 0x000fc800078e00ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000701e1d7812ULL, 0x000fc600078ef809ULL, 0x00000001033a7824ULL, 0x000fe200078e021cULL,
0x0000003b0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b177824ULL, 0x040fe200010e0617ULL,
0x00000070383b7812ULL, 0x000fe200078ef809ULL, 0x000000010b157824ULL, 0x000fe200008e0615ULL,
0x00000070303d7812ULL, 0x000fe200078ef809ULL, 0x0000000103387824ULL, 0x000fe200078e0232ULL,
0x0000003b0a307210ULL, 0x000fe20007f5e0ffULL, 0x000001003a3a7825ULL, 0x000fe200078e00ffULL,
0x0000001d0a1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000014277faeULL, 0x0003e4000b901c46ULL,
0x000000010b1d7824ULL, 0x040fe200000e0621ULL, 0x0000003d0a207210ULL, 0x000fe20007f1e0ffULL,
0x000001003e3e7825ULL, 0x000fe200078e00ffULL, 0x000000703a3d7812ULL, 0x000fe200078ef809ULL,
0x0000000016297faeULL, 0x0003e2000b901c46ULL, 0x000000310b217210ULL, 0x000fe200007fe4ffULL,
0x000000010b317824ULL, 0x040fe200010e0639ULL, 0x0000003d0a3a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010038387825ULL, 0x000fe200078e00ffULL, 0x000000703e437812ULL, 0x000fe200078ef809ULL,
0x00000000182b7faeULL, 0x0003e4000b901c46ULL, 0x000001003c3c7825ULL, 0x000fe200078e00ffULL,
0x0000007038477812ULL, 0x000fe200078ef809ULL, 0x000000001a2d7faeULL, 0x0003e2000b901c46ULL,
0x000000430a3e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010040407825ULL, 0x000fe200078e00ffULL,
0x000000703c457812ULL, 0x000fe200078ef809ULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x000000010b3b7824ULL, 0x040fe200000e063bULL, 0x0000007040097812ULL, 0x000fe200078ef809ULL,
0x000000010b1f7824ULL, 0x040fe200008e061fULL, 0x000000470a387210ULL, 0x000fe20007f1e0ffULL,
0x000000010b3f7824ULL, 0x000fe200010e063fULL, 0x000000450a3c7210ULL, 0x000fc40007f3e0ffULL,
0x000000090a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b397824ULL, 0x040fe200000e0639ULL,
0x0000003d0b3d7210ULL, 0x000fe20000ffe4ffULL, 0x000000001e337faeULL, 0x0003e4000b901c46ULL,
0x000000010b0b7824ULL, 0x000fe400018e0641ULL, 0x0000000020357faeULL, 0x0003e8000b901c46ULL,
0x0000000030377faeULL, 0x0003e8000b901c46ULL, 0x000000003a227faeULL, 0x0003e8000b901c46ULL,
0x0000000038247faeULL, 0x0003e8000b901c46ULL, 0x000000003c267faeULL, 0x0003e8000b901c46ULL,
0x000000003e287faeULL, 0x0003e8000b901c46ULL, 0x000000000a2a7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000a7805ULL, 0x002fe20000015200ULL,
0x01b60007020075a7ULL, 0x000ea2000800017fULL, 0x000000015c047824ULL, 0x000fe400078e0a5fULL,
0x000000040c057c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff047819ULL, 0x000fe20000011604ULL,
0x00008e00ff747b82ULL, 0x000ee40000000a00ULL, 0x0000000405747825ULL, 0x008fe200078e0074ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ff00097202ULL, 0x000fce0000000f00ULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140dULL,
0x0000000c05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000205057819ULL, 0x000fc8000000120cULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x01b60007020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000005a6000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009600ff077b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000095f097836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000205d0a7824ULL, 0x040fe400078e0202ULL, 0x0000000708067224ULL, 0x002fe200078e02ffULL,
0x000000025d077211ULL, 0x000fe200078e18ffULL, 0xffffffff5f087836ULL, 0x000fce0000000000ULL,
0x00009000ff767b82ULL, 0x000e620000000a00ULL, 0x00000001600b7810ULL, 0x004fe20007ffe0ffULL,
0x000000580e0d7224ULL, 0x000fc600078e02ffULL, 0x0000005a0b00720cULL, 0x000fe20003f06070ULL,
0x00000100600b7824ULL, 0x000fe400078e020fULL, 0x000001000d0c7825ULL, 0x002fd400078e0076ULL,
0x0000000800f08947ULL, 0x004fea0003800000ULL, 0x00000003ff227819ULL, 0x104fe20000011605ULL,
0x0000001005727824ULL, 0x040fe200078e00ffULL, 0x0000000b5c1e7248ULL, 0x000fe40007fe0000ULL,
0x0000000822167810ULL, 0x000fe20007ffe0ffULL, 0x0000000422147836ULL, 0x000fe20000000000ULL,
0x0000007072727812ULL, 0x000fe200078ec0ffULL, 0x0000000c22187836ULL, 0x000fe20000000000ULL,
0x00000003162a7819ULL, 0x000fe200000006ffULL, 0x0000000114107824ULL, 0x140fe200078e0205ULL,
0x0ffffff805717812ULL, 0x000fe200078ec0ffULL, 0x0000000814137824ULL, 0x000fe200078e00ffULL,
0x000000025d707211ULL, 0x000fe200078e70ffULL, 0x0000000116117824ULL, 0x100fe200078e0205ULL,
0x0000002022367810ULL, 0x000fe20007ffe0ffULL, 0x00000010221a7836ULL, 0x000fe20000000000ULL,
0xfffffff813287812ULL, 0x000fe200078ee210ULL, 0x0000000118157824ULL, 0x140fe200078e0205ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL, 0x00000008182c7824ULL, 0x000fe200078e00ffULL,
0x0000008072107812ULL, 0x000fe200078efcffULL, 0x0000000103137824ULL, 0x000fe200078e0222ULL,
0x000000ff00117202ULL, 0x000fe20000000f00ULL, 0x000000011a177824ULL, 0x040fe200078e0205ULL,
0x000000031a2e7819ULL, 0x000fe200000006ffULL, 0x000000011e1e7824ULL, 0x000fe200078e0a0bULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL, 0x0000010013127825ULL, 0x000fe200078e0010ULL,
0x0000001403157210ULL, 0x000fc40007ffe0ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL,
0x0000000103177824ULL, 0x040fe200078e0216ULL, 0x000000120c127210ULL, 0x000fe20007f1e0ffULL,
0x00000001031b7824ULL, 0x000fe200078e0218ULL, 0x0000001e1400720cULL, 0x080fe20003f86070ULL,
0x0000010015147825ULL, 0x100fe200078e0010ULL, 0x0000001e1600720cULL, 0x080fe40003f26070ULL,
0x0000001e1800720cULL, 0x000fe20003f46070ULL, 0x0000010017167825ULL, 0x000fe200078e0010ULL,
0x000000140c247210ULL, 0x000fc40007f7e0ffULL, 0x0000300070617810ULL, 0x000fe20007ffe0ffULL,
0x000000010d137824ULL, 0x000fe200000e0613ULL, 0x0000001e1a00720cULL, 0x000fe20003f06070ULL,
0x0000001422307836ULL, 0x000fe20000000000ULL, 0x000000160c187210ULL, 0x000fe20007fbe0ffULL,
0x0000000103217824ULL, 0x000fe400078e021aULL, 0x000001001b1a7825ULL, 0x000fe200078e0010ULL,
0x0000003003277210ULL, 0x000fc60007ffe0ffULL, 0x0000010021207825ULL, 0x000fc800078e0010ULL,
0x000000010d257824ULL, 0x040fe200018e0615ULL, 0x0000001a0c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001822327836ULL, 0x000fe40000000000ULL, 0x000000010d197824ULL, 0x000fe200028e0617ULL,
0x000000200c147210ULL, 0x000fe20007fbe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0010ULL,
0x0000001b0d1d7210ULL, 0x000fe40001ffe4ffULL, 0x0000001e3000720cULL, 0x000fe20003f66070ULL,
0x0000000122207824ULL, 0x000fe200078e0205ULL, 0x000000260c167210ULL, 0x000fe20007fde0ffULL,
0x00000001031b7824ULL, 0x000fc400078e0232ULL, 0x00000001301f7824ULL, 0x040fe200078e0205ULL,
0x0000000771207812ULL, 0x000fe200078ef820ULL, 0x0000001c22347836ULL, 0x000fe40000000000ULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x000001001b1a7825ULL, 0x000fc600078e0010ULL,
0xfffffff830307812ULL, 0x000fe200078ee21fULL, 0x000000010d157824ULL, 0x000fe200028e0621ULL,
0x0000001e2200720cULL, 0x000fe20003fa6070ULL, 0x0000000103217824ULL, 0x000fe400078e0234ULL,
0x000000010d177824ULL, 0x000fe200030e0627ULL, 0x0000001a0c1a7210ULL, 0x000fe20007fde0ffULL,
0x00000010201f7824ULL, 0x000fe400078e0261ULL, 0x0000010021207825ULL, 0x000fc800078e0010ULL,
0x0000000103277824ULL, 0x000fe400078e0236ULL, 0x000000010d1b7824ULL, 0x000fe200030e061bULL,
0x000000200c207210ULL, 0x000fe20007fde0ffULL, 0x0000010027267825ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121f7faeULL, 0x0003e2000e901c46ULL,
0x0000001e3200720cULL, 0x080fe40003fa6070ULL, 0x0000001028237824ULL, 0x000fe200078e0261ULL,
0x000000210d217210ULL, 0x000fe200037fe4ffULL, 0x00000008322b7824ULL, 0x000fe200078e00ffULL,
0x0000000532287210ULL, 0x000fe20007ffe0ffULL, 0x0000000134297824ULL, 0x040fe200078e0205ULL,
0x0000000024237faeULL, 0x0005e2000e101c46ULL, 0x0000001e3400720cULL, 0x040fe20003f86070ULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x000000102a1f7824ULL, 0x002fe200078e0261ULL, 0x000000260c127210ULL, 0x000fe20007fde0ffULL,
0x00000024222a7836ULL, 0x000fe20000000000ULL, 0xfffffff834267812ULL, 0x000fc400078ee229ULL,
0x00000000181f7faeULL, 0x0003e2000c901c46ULL, 0x000000010d137824ULL, 0x000fe200030e0627ULL,
0x0000001e3600720cULL, 0x0c0fe20003f26070ULL, 0x0000000136277824ULL, 0x000fe200078e0205ULL,
0x000000612c237211ULL, 0x004fe200078e20ffULL, 0x0000000836367824ULL, 0x000fe200078e00ffULL,
0x000000052a297210ULL, 0x000fe20007ffe0ffULL, 0x0000000103257824ULL, 0x000fe400078e022aULL,
0x000000001c237faeULL, 0x0005e2000d101c46ULL, 0x0000001e2a00720cULL, 0x000fe20003f46070ULL,
0x0000010025247825ULL, 0x000fe200078e0010ULL, 0xfffffff836187812ULL, 0x002fc600078ee227ULL,
0x000000102e197824ULL, 0x100fe200078e0261ULL, 0x000000240c247210ULL, 0x000fe20007fde0ffULL,
0x0000001018277824ULL, 0x100fe400078e0261ULL, 0x00000010281f7824ULL, 0x100fe200078e0261ULL,
0x0000000014197faeULL, 0x0003e2000c101c46ULL, 0x00000061301d7211ULL, 0x004fe200078e20ffULL,
0x0000002822187836ULL, 0x000fe40000000000ULL, 0x0000001026237824ULL, 0x000fe400078e0261ULL,
0x00000000161d7faeULL, 0x0005e2000d901c46ULL, 0x0000002c22267836ULL, 0x000fc40000000000ULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x000000001a1f7faeULL, 0x000fe2000e901c46ULL,
0x0000003022287836ULL, 0x000fe20000000000ULL, 0x0000001e1800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000103157824ULL, 0x002fe200078e0218ULL, 0x0000000020237faeULL, 0x000fe2000e101c46ULL,
0xfffffff82a1c7812ULL, 0x000fe200078ee229ULL, 0x000000010d257824ULL, 0x000fe200030e0625ULL,
0x00000034222a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000012277faeULL, 0x0003e2000c901c46ULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0x0000000518167210ULL, 0x004fe20007ffe0ffULL,
0x0000000103177824ULL, 0x000fe200078e0228ULL, 0x000000611c297211ULL, 0x000fe200078e20ffULL,
0x00000038222c7836ULL, 0x000fe20000000000ULL, 0xfffffff8191c7812ULL, 0x000fe200078ee216ULL,
0x0000003c222e7836ULL, 0x000fe20000000000ULL, 0x0000001e2600720cULL, 0x080fe20003f86070ULL,
0x0000010017167825ULL, 0x000fe200078e0010ULL, 0x0000000024297faeULL, 0x0005e2000d101c46ULL,
0x0000001e2800720cULL, 0x000fc40003f66070ULL, 0x0000010015127825ULL, 0x002fe200078e0010ULL,
0x0000001e2a00720cULL, 0x080fe40003f46070ULL, 0x0000001e2c00720cULL, 0x080fe20003f26070ULL,
0x0000000103157824ULL, 0x000fe200078e0226ULL, 0x000000120c127210ULL, 0x000fe20007fde0ffULL,
0x0000000126187824ULL, 0x000fe200078e0205ULL, 0x0000001e2e00720cULL, 0x000fe20003f06070ULL,
0x0000010015147825ULL, 0x000fe200078e0010ULL, 0x000000130d137210ULL, 0x000fe400037fe4ffULL,
0x0000000328207819ULL, 0x000fe200000006ffULL, 0x00000008261b7824ULL, 0x000fe200078e00ffULL,
0x000000140c147210ULL, 0x000fe20007fde0ffULL, 0x0000000103197824ULL, 0x000fc400078e022aULL,
0x00000001031d7824ULL, 0x000fe200078e022eULL, 0x000000150d157210ULL, 0x000fe200037fe4ffULL,
0x00000001281f7824ULL, 0x100fe200078e0205ULL, 0x000000160c167210ULL, 0x000fe20007fde0ffULL,
0x000000012a217824ULL, 0x000fe200078e0205ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee218ULL,
0x0000010019187825ULL, 0x000fe200078e0010ULL, 0xfffffff820207812ULL, 0x000fe400078ee21fULL,
0x000000052e1f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001031b7824ULL, 0x000fc400078e022cULL,
0x000000010d177824ULL, 0x000fe200030e0617ULL, 0x000000180c187210ULL, 0x000fe20007fde0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e0010ULL, 0x000000190d197210ULL, 0x000fe200037fe4ffULL,
0x000001001d107825ULL, 0x000fe200078e0010ULL, 0x0000001a0c1a7210ULL, 0x000fc60007fde0ffULL,
0x000000082a227824ULL, 0x000fe400078e00ffULL, 0x000000012c1d7824ULL, 0x040fe400078e0205ULL,
0x000000010d1b7824ULL, 0x040fe200030e061bULL, 0x000000100c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee221ULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fe200030e0611ULL,
0xfffffff82c107812ULL, 0x000fe200078ee21dULL, 0x000000101c1d7824ULL, 0x100fe200078e0261ULL,
0xfffffff82e1c7812ULL, 0x000fe200078ee21fULL, 0x00000010201f7824ULL, 0x100fe200078e0261ULL,
0x000000611e117211ULL, 0x080fe200078e20ffULL, 0x0000001022217824ULL, 0x100fe200078e0261ULL,
0x00000000121d7faeULL, 0x0003e2000e901c46ULL, 0x0000001010237824ULL, 0x000fe200078e0261ULL,
0x000000611c257211ULL, 0x004fc400078e20ffULL, 0x0000000014117faeULL, 0x0003e8000e101c46ULL,
0x00000000161f7faeULL, 0x0003e8000d901c46ULL, 0x0000000018217faeULL, 0x0003e8000d101c46ULL,
0x000000001a237faeULL, 0x0003e8000c901c46ULL, 0x000000000c257faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000405107811ULL, 0x044fe200078fe8ffULL,
0x0000001005727824ULL, 0x040fe200078e00ffULL, 0x0000000805127811ULL, 0x040fe200078fe8ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000c05147811ULL, 0x040fe200078fe8ffULL,
0x00000001104a7824ULL, 0x140fe200078e0205ULL, 0x0000001005167811ULL, 0x040fe200078fe8ffULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0x0000000312137819ULL, 0x040fe200000006ffULL,
0x0000000112487824ULL, 0x100fe200078e0205ULL, 0x0000001405187811ULL, 0x040fe200078fe8ffULL,
0x00000001144c7824ULL, 0x140fe200078e0205ULL, 0xfffffff8114a7812ULL, 0x000fe200078ee24aULL,
0x0000000814157824ULL, 0x000fe200078e00ffULL, 0x00000018051a7811ULL, 0x040fe200078fe8ffULL,
0x0000000116467824ULL, 0x100fe200078e0205ULL, 0xfffffff813487812ULL, 0x000fe200078ee248ULL,
0x0000000118447824ULL, 0x100fe200078e0205ULL, 0x0000000316117819ULL, 0x000fe200000006ffULL,
0x0000000818137824ULL, 0x000fe200078e00ffULL, 0x0000001c051c7811ULL, 0x040fe200078fe8ffULL,
0x000000011a427824ULL, 0x100fe200078e0205ULL, 0x00000020051e7811ULL, 0x000fe200078fe8ffULL,
0x0000000103177824ULL, 0x000fe200078e0214ULL, 0xfffffff8154c7812ULL, 0x000fe200078ee24cULL,
0x000000011c407824ULL, 0x140fe200078e0205ULL, 0xfffffff811467812ULL, 0x000fe200078ee246ULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0x000000031a157819ULL, 0x000fe200000006ffULL,
0x000000011e3e7824ULL, 0x100fe200078e0205ULL, 0x0000002405207811ULL, 0x000fe200078fe8ffULL,
0x0000000103237824ULL, 0x000fe200078e021cULL, 0x0000002805227811ULL, 0x000fe200078fe8ffULL,
0x0000000103197824ULL, 0x000fe200078e0216ULL, 0xfffffff813447812ULL, 0x000fe200078ee244ULL,
0x00000001203c7824ULL, 0x100fe200078e0205ULL, 0x000000031e137819ULL, 0x000fe200000006ffULL,
0x00000001223a7824ULL, 0x100fe200078e0205ULL, 0x0000002c05247811ULL, 0x000fe200078fe8ffULL,
0x0000000103277824ULL, 0x000fe200078e021eULL, 0xfffffff815427812ULL, 0x000fe200078ee242ULL,
0x0000000820157824ULL, 0x000fe200078e00ffULL, 0xfffffff811407812ULL, 0x000fe200078ee240ULL,
0x0000000124387824ULL, 0x140fe200078e0205ULL, 0x0000003005267811ULL, 0x000fe200078fe8ffULL,
0x00000001032d7824ULL, 0x000fe200078e0222ULL, 0xfffffff8133e7812ULL, 0x000fe200078ee23eULL,
0x0000000824137824ULL, 0x000fe200078e00ffULL, 0x0000000322117819ULL, 0x000fe200000006ffULL,
0x0000000126367824ULL, 0x100fe200078e0205ULL, 0x0000003405287811ULL, 0x000fe200078fe8ffULL,
0x00000001031f7824ULL, 0x000fe200078e021aULL, 0x00000038052a7811ULL, 0x000fe200078fe8ffULL,
0x0000000103297824ULL, 0x000fe200078e0226ULL, 0xfffffff8153c7812ULL, 0x000fe200078ee23cULL,
0x0000000128347824ULL, 0x140fe200078e0205ULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x0000000828117824ULL, 0x000fe200078e00ffULL, 0x0000000326157819ULL, 0x000fe200000006ffULL,
0x000000012a327824ULL, 0x140fe200078e0205ULL, 0x0000003c052c7811ULL, 0x000fe200078fe8ffULL,
0x00000001032f7824ULL, 0x040fe200078e0224ULL, 0xfffffff813387812ULL, 0x000fe200078ee238ULL,
0x0000000103217824ULL, 0x040fe200078e022aULL, 0x000000032a137819ULL, 0x000fe200000006ffULL,
0x000000012c307824ULL, 0x000fe200078e0205ULL, 0x0000007072727812ULL, 0x000fe200078ec0ffULL,
0x0000000103317824ULL, 0x000fe200078e022cULL, 0xfffffff815367812ULL, 0x000fe200078ee236ULL,
0x000000082c157824ULL, 0x000fe200078e00ffULL, 0xfffffff811347812ULL, 0x000fc400078ee234ULL,
0xfffffff813327812ULL, 0x000fe400078ee232ULL, 0x0000000305117211ULL, 0x000fe400078fe8ffULL,
0x00000080721c7812ULL, 0x000fe400078efcffULL, 0x0000001003137210ULL, 0x000fe40007ffe0ffULL,
0xfffffff815307812ULL, 0x000fe200078ee230ULL, 0x0000000103157824ULL, 0x000fe200078e0212ULL,
0x00000018031b7210ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e001cULL,
0x00000020032b7210ULL, 0x000fc40007ffe0ffULL, 0x0000002803257210ULL, 0x000fe20007ffe0ffULL,
0x0000010013127825ULL, 0x100fe200078e001cULL, 0x000000100c107210ULL, 0x000fe40007f1e0ffULL,
0x000000025d707211ULL, 0x000fe200078e70ffULL, 0x0000010017167825ULL, 0x100fe200078e001cULL,
0x000000120c127210ULL, 0x000fe40007f3e0ffULL, 0x000000110d117210ULL, 0x000fe200007fe4ffULL,
0x0000010015147825ULL, 0x000fe200078e001cULL, 0x000000160c167210ULL, 0x000fc40007f1e0ffULL,
0x00000005054e7211ULL, 0x000fe200078fe8ffULL, 0x0000010019187825ULL, 0x100fe200078e001cULL,
0x000000140c147210ULL, 0x000fe40007f5e0ffULL, 0x0ffffff805717812ULL, 0x000fe200078ec0ffULL,
0x0000010023227825ULL, 0x000fc600078e001cULL, 0x00000007714e7812ULL, 0x000fe200078ef84eULL,
0x000000010d137824ULL, 0x000fe200008e0613ULL, 0x000000180c187210ULL, 0x000fe20007f3e0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e001cULL, 0x000000190d197210ULL, 0x000fe20000ffe4ffULL,
0x0000010027267825ULL, 0x000fc800078e001cULL, 0x000000010d177824ULL, 0x040fe200000e0617ULL,
0x000000220c227210ULL, 0x000fe20007f1e0ffULL, 0x000000010d157824ULL, 0x000fe200010e0615ULL,
0x0000001a0c1a7210ULL, 0x000fe20007f5e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x000000260c267210ULL, 0x000fc60007f3e0ffULL, 0x000001002f2e7825ULL, 0x100fe200078e001cULL,
0x000000270d277210ULL, 0x000fe40000ffe4ffULL, 0x0000001e0c1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000010029287825ULL, 0x000fc800078e001cULL, 0x000001002b2a7825ULL, 0x000fe200078e001cULL,
0x000000280c287210ULL, 0x000fc60007f3e0ffULL, 0x000000010d237824ULL, 0x040fe200000e0623ULL,
0x0000002e0c2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d1b7824ULL, 0x000fe200010e061bULL,
0x0000002a0c2a7210ULL, 0x000fe20007f5e0ffULL, 0x000001002d2c7825ULL, 0x000fc800078e001cULL,
0x0000010025247825ULL, 0x000fc800078e001cULL, 0x0000010021207825ULL, 0x000fc800078e001cULL,
0x00000100311c7825ULL, 0x000fc800078e001cULL, 0x000000010d1f7824ULL, 0x040fe200018e061fULL,
0x0000002c0c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d2f7824ULL, 0x040fe200000e062fULL,
0x000000240c247210ULL, 0x000fe20007f1e0ffULL, 0x000000010d297824ULL, 0x040fe200008e0629ULL,
0x000000200c207210ULL, 0x000fe20007f3e0ffULL, 0x000000010d2b7824ULL, 0x040fe200010e062bULL,
0x0000001c0c0c7210ULL, 0x000fe20007f5e0ffULL, 0x0000300070617836ULL, 0x000fe40000000000ULL,
0x000000010d2d7824ULL, 0x000fc400018e062dULL, 0x000000010d257824ULL, 0x040fe200000e0625ULL,
0x000000614e317211ULL, 0x080fe200078e20ffULL, 0x000000010d217824ULL, 0x040fe200008e0621ULL,
0x0000006148337211ULL, 0x080fe200078e20ffULL, 0x000000010d0d7824ULL, 0x000fe200010e061dULL,
0x00000061423b7211ULL, 0x000fe200078e20ffULL, 0x000000104a1d7824ULL, 0x100fe200078e0261ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000104c357824ULL, 0x100fe400078e0261ULL, 0x0000001046377824ULL, 0x100fe200078e0261ULL,
0x00000000121d7faeULL, 0x0005e2000b901c46ULL, 0x0000001044397824ULL, 0x000fc600078e0261ULL,
0x0000000014337faeULL, 0x0007e2000b901c46ULL, 0x0000001040117824ULL, 0x002fc600078e0261ULL,
0x0000000016357faeULL, 0x0003e2000b901c46ULL, 0x000000103e137824ULL, 0x004fc600078e0261ULL,
0x0000000018377faeULL, 0x0005e2000b901c46ULL, 0x00000010341d7824ULL, 0x100fe400078e0261ULL,
0x000000103c157824ULL, 0x008fe200078e0261ULL, 0x000000001a397faeULL, 0x0007e2000b901c46ULL,
0x000000613a177211ULL, 0x002fc600078e20ffULL, 0x000000001e3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001038197824ULL, 0x004fc600078e0261ULL, 0x0000000022117faeULL, 0x0005e2000b901c46ULL,
0x00000010361b7824ULL, 0x008fc600078e0261ULL, 0x0000000026137faeULL, 0x0007e8000b901c46ULL,
0x000000002a157faeULL, 0x0007e2000b901c46ULL, 0x00000010301f7824ULL, 0x002fe200078e0261ULL,
0x0000006132117211ULL, 0x004fe400078e20ffULL, 0x000000002c177faeULL, 0x0007e8000b901c46ULL,
0x000000002e197faeULL, 0x0007e8000b901c46ULL, 0x00000000281b7faeULL, 0x0007e8000b901c46ULL,
0x00000000241d7faeULL, 0x0007e8000b901c46ULL, 0x0000000020117faeULL, 0x0007e8000b901c46ULL,
0x000000000c1f7faeULL, 0x0007e4000b901c46ULL, 0x0000000459597836ULL, 0x000fe20000000000ULL,
0xffffffff00587802ULL, 0x000fe20000000f00ULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000005b5900720cULL, 0x000fda0003f06070ULL, 0x00009200ff108b82ULL, 0x00ae620000000a00ULL,
0x00000002060d8824ULL, 0x000fe200078e0259ULL, 0x00000004ff637819ULL, 0x000fe40000011605ULL,
0x00000007050c7812ULL, 0x000fe200078ec0ffULL, 0x0000100070707836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000040d108825ULL, 0x002fca00078e0010ULL,
0x0000000610588981ULL, 0x0002a2000c1e1900ULL, 0x0000000863137824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011605ULL, 0x00000001006d7824ULL, 0x000fe200078e0260ULL,
0x000000080c627812ULL, 0x000fe400078ef805ULL, 0xfffffff8133c7812ULL, 0x000fe400078ee20cULL,
0x000000010d157812ULL, 0x000fe200078ec0ffULL, 0x0000000163637824ULL, 0x000fe400078e0262ULL,
0x0000001062127824ULL, 0x000fe200078e00ffULL, 0x0000003c15537210ULL, 0x000fe20007ffe0ffULL,
0x000000083c107824ULL, 0x002fc400078e00ffULL, 0x0000001062177824ULL, 0x000fe200078e00ffULL,
0xfffffff012117812ULL, 0x000fe200078ee263ULL, 0x0000000263147836ULL, 0x000fe20000000000ULL,
0xfffffff810737812ULL, 0x000fe200078ee253ULL, 0x000000103c527836ULL, 0x000fe20000000000ULL,
0x0000000253567810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e0202ULL,
0x0000007073187211ULL, 0x000fe200078e20ffULL, 0x00000001156f7824ULL, 0x000fe200078e0252ULL,
0xfffffff017177812ULL, 0x000fe200078ee214ULL, 0x0000000852147824ULL, 0x040fe200078e00ffULL,
0x0000000352247819ULL, 0x000fe200000006ffULL, 0x000000001110783bULL, 0x000fe20000000200ULL,
0x000000203c517836ULL, 0x000fe20000000000ULL, 0x0000000217407211ULL, 0x000fe200078e20ffULL,
0x000000303c507836ULL, 0x000fe20000000000ULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0xfffffff8146f7812ULL, 0x000fe200078ee26fULL, 0x000000083c1d7824ULL, 0x000fe200078e00ffULL,
0x0000000351177819ULL, 0x000fe200000006ffULL, 0x00000001156e7824ULL, 0x000fe200078e0251ULL,
0x000000706f147211ULL, 0x000fe200078e20ffULL, 0x0000000115577824ULL, 0x000fe200078e0250ULL,
0xfffffff81d567812ULL, 0x000fe200078ee256ULL, 0x0000000850167824ULL, 0x000fe200078e00ffULL,
0xfffffff8176e7812ULL, 0x000fe200078ee26eULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x0000001253557836ULL, 0x000fe20000000000ULL, 0x0000002453687810ULL, 0x000fe20007ffe0ffULL,
0x0000001056387824ULL, 0x100fe200078e0270ULL, 0xfffffff816577812ULL, 0x000fe200078ee257ULL,
0x000000106e2c7824ULL, 0x100fe200078e0270ULL, 0x000000001414783bULL, 0x000ee20000000200ULL,
0xfffffff824557812ULL, 0x000fe200078ee255ULL, 0x0000002253547836ULL, 0x000fe20000000000ULL,
0x0000003653647810ULL, 0x000fe20007ffe0ffULL, 0x000000003838783bULL, 0x000f220000000200ULL,
0x0000001057207824ULL, 0x000fc400078e0270ULL, 0x0000001055347824ULL, 0x100fe200078e0270ULL,
0x000000002c2c783bULL, 0x000f620000000200ULL, 0x0000000851257824ULL, 0x000fe400078e00ffULL,
0x00000032536c7836ULL, 0x000fe20000000000ULL, 0x000000002020783bULL, 0x000f220000000200ULL,
0x0000000850297824ULL, 0x000fe200078e00ffULL, 0xfffffff825547812ULL, 0x000fe200078ee254ULL,
0x0000000463287836ULL, 0x000fe20000000000ULL, 0x000000003434783bULL, 0x000f620000000200ULL,
0x000000083c2b7824ULL, 0x000fe200078e00ffULL, 0x0000007054307211ULL, 0x000fe200078e20ffULL,
0x00000004536a7836ULL, 0x000fe20000000000ULL, 0xfffffff8296c7812ULL, 0x000fe200078ee26cULL,
0x0000003453677836ULL, 0x000fe20000000000ULL, 0x0000000462297819ULL, 0x000fe200000006ffULL,
0x00000008503e7824ULL, 0x000fe200078e00ffULL, 0x00000018101c723cULL, 0x002fe200000018ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0xfffffff029297812ULL, 0x000fe200078ee228ULL,
0x00000014536b7836ULL, 0x000fe20000000000ULL, 0xfffffff82b6a7812ULL, 0x000fe200078ee26aULL,
0x0000000653697836ULL, 0x000fe20000000000ULL, 0x0000001a1018723cULL, 0x000fe200000018ffULL,
0x0000000229297211ULL, 0x000fe200078e20ffULL, 0x0000001653667836ULL, 0x000fe20000000000ULL,
0xfffffff83e677812ULL, 0x000fe200078ee267ULL, 0x000000106a3d7824ULL, 0x000fc400078e0270ULL,
0x0000002653657836ULL, 0x000fe20000000000ULL, 0x000000002928783bULL, 0x000fe20000000200ULL,
0x000000141024723cULL, 0x008fec00000018ffULL, 0x000000161014723cULL, 0x000fec00000018ffULL,
0x00000038401c723cULL, 0x010fec000000181cULL, 0x0000003a4038723cULL, 0x000fec0000001818ULL,
0x0000002c1018723cULL, 0x020fec00000018ffULL, 0x0000002e102c723cULL, 0x000fec00000018ffULL,
0x00000020104c723cULL, 0x000fec00000018ffULL, 0x000000221010723cULL, 0x000fe200000018ffULL,
0x000000106c207824ULL, 0x000fca00078e0270ULL, 0x000000344024723cULL, 0x000fe20000001824ULL,
0x000000002020783bULL, 0x000eea0000000200ULL, 0x000000364034723cULL, 0x000fe20000001814ULL,
0x000000003d14783bULL, 0x000f2a0000000200ULL, 0x000000304018723cULL, 0x002fee0000001818ULL,
0x0000000852307824ULL, 0x000fc400078e00ffULL, 0x0000000851317824ULL, 0x000fc600078e00ffULL,
0xfffffff8306b7812ULL, 0x000fe400078ee26bULL, 0xfffffff831687812ULL, 0x000fe400078ee268ULL,
0x000000324030723cULL, 0x000fe2000000182cULL, 0x000000106b487824ULL, 0x000fe200078e0270ULL,
0x0000007068447211ULL, 0x000fca00078e20ffULL, 0x000000083c2e7824ULL, 0x000fe200078e00ffULL,
0x00000004622c7819ULL, 0x000fe200000006ffULL, 0x00000010673c7824ULL, 0x000fe200078e0270ULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00000006632d7836ULL, 0x000fe20000000000ULL,
0xfffffff82e697812ULL, 0x000fe200078ee269ULL, 0x00000008502f7824ULL, 0x000fe200078e00ffULL,
0x000000004444783bULL, 0x000f620000000200ULL, 0x00000020404c723cULL, 0x008fe2000000184cULL,
0xfffffff02c2d7812ULL, 0x000fe400078ee22dULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0xfffffff82f647812ULL, 0x000fc400078ee264ULL, 0x00000014281c723cULL, 0x010fe2000000181cULL,
0x000000102d2d7824ULL, 0x000fe200078e0202ULL, 0x0000000351207819ULL, 0x000fe200000006ffULL,
0x0000000852217824ULL, 0x000fc600078e00ffULL, 0x000000162838723cULL, 0x000fe20000001838ULL,
0x0000001064147824ULL, 0x100fe200078e0270ULL, 0x000000002d2c783bULL, 0x000fe20000000200ULL,
0xfffffff821667812ULL, 0x000fe400078ee266ULL, 0xfffffff820657812ULL, 0x000fe200078ee265ULL,
0x000000224040723cULL, 0x000fe20000001810ULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x0000001066207824ULL, 0x000fe200078e0270ULL, 0x0000007065507211ULL, 0x000fc800078e20ffULL,
0x0000001069107824ULL, 0x000fe200078e0270ULL, 0x000000002020783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x000000482824723cULL, 0x002fec0000001824ULL, 0x000000442818723cULL, 0x020fec0000001818ULL,
0x0000003c284c723cULL, 0x008fec000000184cULL, 0x0000004a2834723cULL, 0x000fec0000001834ULL,
0x000000462830723cULL, 0x000fec0000001830ULL, 0x0000003e2828723cULL, 0x000fec0000001840ULL,
0x000000142c4c723cULL, 0x010fec000000184cULL, 0x000000102c1c723cULL, 0x000fe2000000181cULL,
0x000000016d157836ULL, 0x000fca0000000000ULL, 0x0000005a1500720cULL, 0x000fe20003f06070ULL,
0x000000202c24723cULL, 0x000fec0000001824ULL, 0x000000502c18723cULL, 0x000fec0000001818ULL,
0x000000122c10723cULL, 0x000fec0000001838ULL, 0x000000222c20723cULL, 0x000fec0000001834ULL,
0x000000522c50723cULL, 0x000fec0000001830ULL, 0x000000162c2c723cULL, 0x000fe20000001828ULL,
0x0000000e58157224ULL, 0x004fc800078e02ffULL, 0x0000010015767825ULL, 0x000fe200078e0076ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c00148947ULL, 0x000fde0003800000ULL,
0x0000000f6d3b7211ULL, 0x000fe200078e40ffULL, 0x000000040d2a7836ULL, 0x000fe20000000000ULL,
0x000000280d367810ULL, 0x000fe20007ffe0ffULL, 0x000000140d487836ULL, 0x000fe20000000000ULL,
0x0000003b5c147248ULL, 0x000fe20007fe0000ULL, 0x000000082a307824ULL, 0x000fe200078e00ffULL,
0x000000052a317210ULL, 0x000fe20007ffe0ffULL, 0x000000100d467836ULL, 0x000fe20000000000ULL,
0x000000143b3b7210ULL, 0x000fe20007ffe1ffULL, 0x000000010d167824ULL, 0x140fe200078e0205ULL,
0xfffffff830317812ULL, 0x000fe200078ee231ULL, 0x0000000148417824ULL, 0x100fe200078e0205ULL,
0x0000000346177819ULL, 0x000fe200000006ffULL, 0x0000000848147824ULL, 0x000fe200078e00ffULL,
0x0000000771717812ULL, 0x000fe200078ef816ULL, 0x0000000c0d307836ULL, 0x000fe20000000000ULL,
0x0000000336167819ULL, 0x000fe200000006ffULL, 0x0000001c0d447836ULL, 0x000fe20000000000ULL,
0xfffffff814417812ULL, 0x000fe200078ee241ULL, 0x0000000146387824ULL, 0x100fe200078e0205ULL,
0x000000180d4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000240d3d7836ULL, 0x000fe20000000000ULL,
0x0000003b0d00720cULL, 0x080fe20003f66070ULL, 0x0000000136337824ULL, 0x100fe200078e0205ULL,
0xfffffff817387812ULL, 0x000fe200078ee238ULL, 0x000000080d287836ULL, 0x000fe20000000000ULL,
0x000000034a297819ULL, 0x000fe200000006ffULL, 0x00000001303a7824ULL, 0x140fe200078e0205ULL,
0xfffffff816337812ULL, 0x000fe200078ee233ULL, 0x0000000830157824ULL, 0x000fe200078e00ffULL,
0x0000003b2a00720cULL, 0x080fe20003f06070ULL, 0x0000000144397824ULL, 0x100fe200078e0205ULL,
0x0000003b2800720cULL, 0x080fe20003f46070ULL, 0x0000000844147824ULL, 0x000fe200078e00ffULL,
0xfffffff8153a7812ULL, 0x000fe200078ee23aULL, 0x000000200d407836ULL, 0x000fe20000000000ULL,
0x0000003b3000720cULL, 0x000fe20003f26070ULL, 0x000000013d3c7824ULL, 0x140fe200078e0205ULL,
0xfffffff814397812ULL, 0x000fe200078ee239ULL, 0x000000083d177824ULL, 0x000fe200078e00ffULL,
0x0000000340157819ULL, 0x000fe200000006ffULL, 0x0000000128457824ULL, 0x140fe200078e0205ULL,
0x0000002a03147210ULL, 0x000fe20007ffe0ffULL, 0x0000000828327824ULL, 0x000fe200078e00ffULL,
0xfffffff8173c7812ULL, 0x000fe200078ee23cULL, 0x0000000140347824ULL, 0x000fc400078e0205ULL,
0x0000000103167824ULL, 0x000fe200078e020dULL, 0xfffffff832457812ULL, 0x000fe200078ee245ULL,
0x000000014a327824ULL, 0x000fe200078e0205ULL, 0xfffffff815347812ULL, 0x000fe200078ee234ULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0xfffffff829327812ULL, 0x000fe200078ee232ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x00000072162b7212ULL, 0x000fc600078efcffULL,
0x0000002c0d3f7836ULL, 0x000fe20000000000ULL, 0x0000007214297212ULL, 0x000fe200078efcffULL,
0x0000000103147824ULL, 0x000fe200078e0228ULL, 0x0000002b762a7210ULL, 0x000fe20007f9e0ffULL,
0x000000013f377824ULL, 0x040fe200078e0205ULL, 0x0000002976167210ULL, 0x000fe20007fbe0ffULL,
0x000000083f427824ULL, 0x000fe400078e00ffULL, 0x0000000103287824ULL, 0x000fe400078e0230ULL,
0x00000001772b7824ULL, 0x000fe200020e0617ULL, 0x0000001577177210ULL, 0x000fe20002ffe4ffULL,
0x0000001071717824ULL, 0x000fe200078e0270ULL, 0xfffffff842377812ULL, 0x000fe200078ee237ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000003b4a00720cULL, 0x000fc40003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a717faeULL, 0x0003e2000d901c46ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000007228437212ULL, 0x000fc600078efcffULL,
0x000000340d427836ULL, 0x000fe20000000000ULL, 0x0000007214477212ULL, 0x000fe200078efcffULL,
0x00000001034a7824ULL, 0x000fe200078e024aULL, 0x0000004376307210ULL, 0x000fe20007f9e0ffULL,
0x0000000142287824ULL, 0x040fe200078e0205ULL, 0x0000000342497819ULL, 0x000fe200000006ffULL,
0x0000001041417824ULL, 0x100fe200078e0270ULL, 0x00000046032a7210ULL, 0x002fe20007ffe0ffULL,
0x00000010324b7824ULL, 0x100fe200078e0270ULL, 0x0000004776147210ULL, 0x000fe20007f7e0ffULL,
0x0000001031477824ULL, 0x000fe200078e0270ULL, 0xfffffff849437812ULL, 0x000fe200078ee228ULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000007045497211ULL, 0x000fc400078e20ffULL,
0x0000000016477faeULL, 0x0003e2000c101c46ULL, 0x0000000103287824ULL, 0x000fe200078e0248ULL,
0x000000722a457212ULL, 0x080fe200078efcffULL, 0x0000000177317824ULL, 0x040fe200020e0629ULL,
0x0000003b4400720cULL, 0x080fe20003f06070ULL, 0x0000000177157824ULL, 0x000fe200018e0615ULL,
0x00000045762a7210ULL, 0x000fe20007fde0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000003b4800720cULL, 0x080fe40003f66070ULL, 0x0000000014497faeULL, 0x0005e2000d101c46ULL,
0x0000000103447824ULL, 0x000fe200078e0244ULL, 0x0000007228477212ULL, 0x002fe200078efcffULL,
0x000001004a167825ULL, 0x000fe200078e00ffULL, 0x0000003b4600720cULL, 0x000fc40003f86070ULL,
0x0000004776287210ULL, 0x000fe20007f5e0ffULL, 0x00000001772b7824ULL, 0x000fe200030e062bULL,
0x0000007216457212ULL, 0x000fe200078efcffULL, 0x0000003c0d467836ULL, 0x000fe20000000000ULL,
0x0000007043437211ULL, 0x000fe200078e20ffULL, 0x0000000177297824ULL, 0x000fe200010e0629ULL,
0x0000004576167210ULL, 0x000fe20007fde0ffULL, 0x0000010044147825ULL, 0x004fc600078e00ffULL,
0x0000001777177210ULL, 0x000fe200037fe4ffULL, 0x000000380d447836ULL, 0x000fe20000000000ULL,
0x0000007214457212ULL, 0x000fe200078efcffULL, 0x0000000846497824ULL, 0x000fe400078e00ffULL,
0x0000000144477824ULL, 0x040fe200078e0205ULL, 0x0000004576147210ULL, 0x000fe20007f5e0ffULL,
0x0000000844487824ULL, 0x000fe400078e00ffULL, 0x0000000103327824ULL, 0x000fe200078e023fULL,
0x0000001577157210ULL, 0x000fe200017fe4ffULL, 0x000000300d3e7836ULL, 0x000fe20000000000ULL,
0xfffffff848457812ULL, 0x000fe200078ee247ULL, 0x0000000146487824ULL, 0x000fe200078e0205ULL,
0x0000003b3d00720cULL, 0x080fe20003f46070ULL, 0x000000103a477824ULL, 0x000fe200078e0270ULL,
0x000000033e787819ULL, 0x040fe200000006ffULL, 0x00000001033d7824ULL, 0x040fe200078e023dULL,
0xfffffff8493a7812ULL, 0x000fe200078ee248ULL, 0x000000013e357824ULL, 0x000fe200078e0205ULL,
0x0000007038497211ULL, 0x000fe200078e20ffULL, 0x0000000030477faeULL, 0x0003e2000c901c46ULL,
0x0000003b4000720cULL, 0x080fe20003f26070ULL, 0x0000000103407824ULL, 0x000fe200078e0240ULL,
0xfffffff878357812ULL, 0x000fe200078ee235ULL, 0x000000002a497faeULL, 0x0005e2000e101c46ULL,
0x0000003b3f00720cULL, 0x000fe20003f86070ULL, 0x0000000103387824ULL, 0x000fc400078e0244ULL,
0x0000000028417faeULL, 0x0007e2000d901c46ULL, 0x0000003b3600720cULL, 0x000fe20003f66070ULL,
0x0000001033337824ULL, 0x100fe200078e0270ULL, 0x0000003603367210ULL, 0x000fe20007ffe0ffULL,
0x00000000164b7faeULL, 0x0009e2000e901c46ULL, 0x0000001034477824ULL, 0x102fe400078e0270ULL,
0x0000001037377824ULL, 0x000fe400078e0270ULL, 0x000001003d2a7825ULL, 0x004fc800078e00ffULL,
0x0000010040287825ULL, 0x008fe200078e00ffULL, 0x000000722a3d7212ULL, 0x000fc600078efcffULL,
0x0000010036307825ULL, 0x000fe200078e00ffULL, 0x00000072283f7212ULL, 0x080fe400078efcffULL,
0x0000003d762a7210ULL, 0x000fe20007fbe0ffULL, 0x0000010032167825ULL, 0x010fe200078e00ffULL,
0x0000003f76287210ULL, 0x000fe40007fde0ffULL, 0x00000072303f7212ULL, 0x080fe200078efcffULL,
0x0000000103407824ULL, 0x000fe200078e023eULL, 0x0000002977297210ULL, 0x000fe200037fe4ffULL,
0x00000001772b7824ULL, 0x000fe200028e062bULL, 0x00000072163d7212ULL, 0x000fe200078efcffULL,
0x0000010040407825ULL, 0x000fe200078e00ffULL, 0x0000003f76307210ULL, 0x000fc40007fde0ffULL,
0x0000003d76167210ULL, 0x000fe20007fbe0ffULL, 0x00000010393d7824ULL, 0x000fe200078e0270ULL,
0x0000007240397212ULL, 0x080fe200078efcffULL, 0x0000000177317824ULL, 0x000fe200030e0631ULL,
0x0000003b3e00720cULL, 0x080fe20003fc6070ULL, 0x00000001033e7824ULL, 0x040fe200078e0242ULL,
0x0000001777177210ULL, 0x000fe20002ffe4ffULL, 0x00000000143d7faeULL, 0x0003e2000c101c46ULL,
0x000000103c497824ULL, 0x000fe200078e0270ULL, 0x0000003b4200720cULL, 0x080fe20003f06070ULL,
0x000001003e3e7825ULL, 0x000fe200078e00ffULL, 0x0000000028477faeULL, 0x0005e6000c901c46ULL,
0x0000000103327824ULL, 0x000fe200078e0246ULL, 0x000000002a497faeULL, 0x0007e2000d101c46ULL,
0x0000003b4400720cULL, 0x000fe20003f46070ULL, 0x0000001035357824ULL, 0x100fe200078e0270ULL,
0x0000003976147210ULL, 0x002fe20007fbe0ffULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x0000000030337faeULL, 0x0003e4000d901c46ULL, 0x0000004177157210ULL, 0x000fe20002ffe4ffULL,
0x0000010032287825ULL, 0x004fe200078e00ffULL, 0x000000723e417212ULL, 0x080fe200078efcffULL,
0x0000000016377faeULL, 0x0003e2000e101c46ULL, 0x00000072383d7212ULL, 0x000fe200078efcffULL,
0x0000001045457824ULL, 0x000fe200078e0270ULL, 0x00000041762a7210ULL, 0x008fe20007fbe0ffULL,
0x0000000014357faeULL, 0x0003e2000f101c46ULL, 0x0000003d76387210ULL, 0x000fc60007f3e0ffULL,
0x00000001772b7824ULL, 0x040fe200028e063fULL, 0x0000003b4600720cULL, 0x000fe40003fa6070ULL,
0x00000072283b7212ULL, 0x000fe400078efcffULL, 0x0000003977397210ULL, 0x000fe20000ffe4ffULL,
0x000000002a437faeULL, 0x0003e2000c101c46ULL, 0x0000003b76287210ULL, 0x000fe20007f3e0ffULL,
0x000000103a3b7824ULL, 0x000fe400078e0270ULL, 0x0000000038457faeULL, 0x0003e4000d101c46ULL,
0x0000000177297824ULL, 0x000fca00008e0629ULL, 0x00000000283b7faeULL, 0x0003e2000e901c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x000000040d147810ULL, 0x000fe20007ffe0ffULL,
0x0000000103307824ULL, 0x000fe200078e020dULL, 0x000000100d437810ULL, 0x000fe20007ffe0ffULL,
0x000000080d167836ULL, 0x000fe20000000000ULL, 0x000000200d477810ULL, 0x000fe20007ffe0ffULL,
0x00000001143d7824ULL, 0x040fe200078e0205ULL, 0x0000002c0d4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000814287824ULL, 0x000fe200078e00ffULL, 0x00000005163c7210ULL, 0x000fe20007ffe0ffULL,
0x0000010030307825ULL, 0x000fc600078e00ffULL, 0xfffffff8283d7812ULL, 0x000fe200078ee23dULL,
0x0000000103287824ULL, 0x040fe200078e0216ULL, 0x0000007230377212ULL, 0x000fe200078efcffULL,
0x00000001032a7824ULL, 0x000fe200078e0214ULL, 0x0000004303147210ULL, 0x000fe20007ffe0ffULL,
0x0000000c0d427836ULL, 0x000fe20000000000ULL, 0x0000003776367210ULL, 0x000fe20007f1e0ffULL,
0x0000000816157824ULL, 0x000fe400078e00ffULL, 0x0000010028287825ULL, 0x000fc600078e00ffULL,
0xfffffff8153c7812ULL, 0x000fe200078ee23cULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007228397212ULL, 0x000fe400078efcffULL, 0x000000703c797211ULL, 0x000fe200078e20ffULL,
0x0000000103167824ULL, 0x000fe200078e0242ULL, 0x000000722a357212ULL, 0x000fe200078efcffULL,
0x0000010014147825ULL, 0x000fc600078e00ffULL, 0x0000003576347210ULL, 0x000fe20007f3e0ffULL,
0x000000140d457836ULL, 0x000fe40000000000ULL, 0x0000010016167825ULL, 0x000fc600078e00ffULL,
0x00000045032a7210ULL, 0x000fe20007ffe0ffULL, 0x000000180d447836ULL, 0x000fe20000000000ULL,
0x0000007216337212ULL, 0x080fe200078efcffULL, 0x0000000177377824ULL, 0x000fe200000e0631ULL,
0x0000003976387210ULL, 0x000fe20007f1e0ffULL, 0x0000000103287824ULL, 0x000fe200078e0244ULL,
0x0000007214317212ULL, 0x000fe200078efcffULL, 0x0000001c0d487836ULL, 0x000fe20000000000ULL,
0x0000003376327210ULL, 0x000fe20007f5e0ffULL, 0x0000000177397824ULL, 0x040fe200000e0629ULL,
0x0000003176307210ULL, 0x000fe20007f1e0ffULL, 0x0000000177357824ULL, 0x000fe200008e062bULL,
0x0000001777337210ULL, 0x000fe200017fe4ffULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000072283b7212ULL, 0x000fc600078efcffULL,
0x0000000103167824ULL, 0x000fe200078e0248ULL, 0x0000003b76287210ULL, 0x000fe20007f3e0ffULL,
0x000000240d467836ULL, 0x000fe40000000000ULL, 0x0000000177317824ULL, 0x000fe200000e0615ULL,
0x000000722a157212ULL, 0x000fe200078efcffULL, 0x0000010016167825ULL, 0x000fc600078e00ffULL,
0x00000015762a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001033a7824ULL, 0x040fe200078e0246ULL,
0x00000072163f7212ULL, 0x000fe200078efcffULL, 0x0000000103147824ULL, 0x000fe200078e0247ULL,
0x0000002b772b7210ULL, 0x000fe200007fe4ffULL, 0x000001003a3a7825ULL, 0x000fe200078e00ffULL,
0x0000003f76167210ULL, 0x000fc60007f5e0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000723a417212ULL, 0x000fc600078efcffULL, 0x000000010d3e7824ULL, 0x000fe200078e0205ULL,
0x00000072143f7212ULL, 0x000fe200078efcffULL, 0x0000000177297824ULL, 0x040fe200008e0629ULL,
0x0000004176407210ULL, 0x000fe20007f3e0ffULL, 0x000000340d497836ULL, 0x000fe20000000000ULL,
0x0000000771717812ULL, 0x000fe200078ef83eULL, 0x000000300d4a7836ULL, 0x000fe20000000000ULL,
0x0000003f76147210ULL, 0x000fe20007f1e0ffULL, 0x0000000177417824ULL, 0x000fe400008e063bULL,
0x00000010713f7824ULL, 0x000fe200078e0270ULL, 0x0000001577157210ULL, 0x000fe200007fe4ffULL,
0x000000280d717836ULL, 0x000fc40000000000ULL, 0x000000103d3b7824ULL, 0x000fe200078e0270ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000363f7faeULL, 0x0003e2000b901c46ULL,
0x00000001033a7824ULL, 0x040fe400078e0271ULL, 0x00000001033d7824ULL, 0x000fe200078e024bULL,
0x00000000343b7faeULL, 0x0005e2000b901c46ULL, 0x0000003c0d787836ULL, 0x000fe40000000000ULL,
0x000000380d7a7836ULL, 0x000fe20000000000ULL, 0x0000000038797faeULL, 0x0007e2000b901c46ULL,
0x0000000177177824ULL, 0x000fe200010e0617ULL, 0x00000005787d7210ULL, 0x000fe20007ffe0ffULL,
0x000001003a367825ULL, 0x002fc800078e00ffULL, 0x000001003d347825ULL, 0x004fe200078e00ffULL,
0x00000072363d7212ULL, 0x000fc600078efcffULL, 0x0000000103367824ULL, 0x000fe200078e024aULL,
0x00000072343f7212ULL, 0x000fe400078efcffULL, 0x0000003d763e7210ULL, 0x000fe40007f1e0ffULL,
0x0000003f763c7210ULL, 0x000fe40007f3e0ffULL, 0x0000004903347210ULL, 0x000fe20007ffe0ffULL,
0x00000001773f7824ULL, 0x040fe400000e0637ULL, 0x00000001773d7824ULL, 0x000fc400008e0635ULL,
0x0000010036367825ULL, 0x000fc800078e00ffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x00000072363b7212ULL, 0x000fc600078efcffULL, 0x0000000103367824ULL, 0x000fe200078e027aULL,
0x0000007234397212ULL, 0x008fe400078efcffULL, 0x0000003b763a7210ULL, 0x000fe40007f1e0ffULL,
0x0000003976387210ULL, 0x000fe40007f3e0ffULL, 0x0000007803347210ULL, 0x000fe20007ffe0ffULL,
0x00000001773b7824ULL, 0x000fe200000e0637ULL, 0x0000003577397210ULL, 0x000fe20000ffe4ffULL,
0x0000010036367825ULL, 0x000fc800078e00ffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x0000007236797212ULL, 0x000fc600078efcffULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0x00000072347b7212ULL, 0x000fe200078efcffULL, 0x0000000142727824ULL, 0x000fe200078e0205ULL,
0x0000007976367210ULL, 0x000fe20007f1e0ffULL, 0x0000000843797824ULL, 0x000fe200078e00ffULL,
0x0000007b76347210ULL, 0x000fe20007f3e0ffULL, 0x00000008487b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8787d7812ULL, 0x000fe200078ee27dULL, 0x0000000177377824ULL, 0x040fe400000e0637ULL,
0x0000000177357824ULL, 0x000fe200008e0635ULL, 0x0000000342777819ULL, 0x000fe200000006ffULL,
0x0000000143427824ULL, 0x100fe200078e0205ULL, 0x0000000545437210ULL, 0x000fe20007ffe0ffULL,
0x000000107d7d7824ULL, 0x000fe200078e0270ULL, 0xfffffff877777812ULL, 0x000fe200078ee272ULL,
0x0000000845727824ULL, 0x000fe200078e00ffULL, 0xfffffff879457812ULL, 0x000fe200078ee242ULL,
0x0000000144427824ULL, 0x000fc400078e0205ULL, 0x0000001077777824ULL, 0x100fe200078e0270ULL,
0xfffffff872437812ULL, 0x000fe200078ee243ULL, 0x0000000844797824ULL, 0x000fe200078e00ffULL,
0x0000000548447210ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x100fe200078e0270ULL,
0x0000000032777faeULL, 0x0003e2000b901c46ULL, 0x0000001043437824ULL, 0x000fc600078e0270ULL,
0x0000000030457faeULL, 0x0005e8000b901c46ULL, 0x000000002a437faeULL, 0x0005e2000b901c46ULL,
0xfffffff879777812ULL, 0x002fe200078ee242ULL, 0x0000000147797824ULL, 0x140fe200078e0205ULL,
0xfffffff87b337812ULL, 0x000fe200078ee244ULL, 0x0000000847327824ULL, 0x000fe200078e00ffULL,
0x0000000546477210ULL, 0x000fe20007ffe0ffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0x000000054b427210ULL, 0x000fe20007ffe0ffULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff832797812ULL, 0x000fe200078ee279ULL, 0x0000000171327824ULL, 0x140fe200078e0205ULL,
0xfffffff846477812ULL, 0x000fe200078ee247ULL, 0x0000000871717824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee242ULL, 0x000000014a7b7824ULL, 0x140fe200078e0205ULL,
0x0000007077777211ULL, 0x080fe200078e20ffULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee232ULL, 0x0000001033337824ULL, 0x100fe200078e0270ULL,
0x0000000549327210ULL, 0x000fe20007ffe0ffULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0xfffffff84a7b7812ULL, 0x000fe200078ee27bULL, 0x0000001079797824ULL, 0x100fe200078e0270ULL,
0x0000007071717211ULL, 0x000fe200078e20ffULL, 0x0000001047477824ULL, 0x000fe200078e0270ULL,
0xfffffff849497812ULL, 0x000fe200078ee232ULL, 0x000000017a327824ULL, 0x040fe200078e0205ULL,
0x0000000028777faeULL, 0x0005e2000b901c46ULL, 0x000000087a7a7824ULL, 0x000fc400078e00ffULL,
0x000000104b4b7824ULL, 0x100fe200078e0270ULL, 0x0000000016337faeULL, 0x0005e2000b901c46ULL,
0x000000107b7b7824ULL, 0x100fe200078e0270ULL, 0xfffffff87a327812ULL, 0x000fe200078ee232ULL,
0x0000001049497824ULL, 0x000fe200078e0270ULL, 0x0000000014797faeULL, 0x0005e4000b901c46ULL,
0x0000007032327211ULL, 0x000fe400078e20ffULL, 0x0000000040477faeULL, 0x0005e8000b901c46ULL,
0x000000003e717faeULL, 0x0005e8000b901c46ULL, 0x000000003c4b7faeULL, 0x0005e8000b901c46ULL,
0x000000003a7b7faeULL, 0x0005e8000b901c46ULL, 0x0000000038497faeULL, 0x0005e8000b901c46ULL,
0x0000000036327faeULL, 0x0005e8000b901c46ULL, 0x00000000347d7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000863147836ULL, 0x006fe20000000000ULL,
0x0000006157347211ULL, 0x080fe200078e20ffULL, 0x0000001062157824ULL, 0x040fe400078e00ffULL,
0x0000000a63287836ULL, 0x000fe40000000000ULL, 0x0000001062297824ULL, 0x000fe200078e00ffULL,
0xfffffff015157812ULL, 0x000fe200078ee214ULL, 0x000000106f3c7824ULL, 0x100fe200078e0261ULL,
0x0000006173147211ULL, 0x000fe200078e20ffULL, 0x000000106e387824ULL, 0x000fe200078e0261ULL,
0xfffffff029297812ULL, 0x000fe200078ee228ULL, 0x0000001015307824ULL, 0x000fc400078e0202ULL,
0x0000001056287824ULL, 0x100fe200078e0261ULL, 0x0000000229447211ULL, 0x000fe200078e20ffULL,
0x0000001054547824ULL, 0x100fe400078e0261ULL, 0x000000106c487824ULL, 0x100fe400078e0261ULL,
0x000000106a407824ULL, 0x000fe200078e0261ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea80000000200ULL, 0x000000003c3c783bULL, 0x000ee80000000200ULL,
0x000000003838783bULL, 0x000f280000000200ULL, 0x000000002828783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000f680000000200ULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x00000034304c723cULL, 0x002fec000000184cULL,
0x00000014301c723cULL, 0x004fe2000000181cULL, 0x0000000c63347836ULL, 0x000fe20000000000ULL,
0x0000000462357819ULL, 0x000fe200000006ffULL, 0x0000000e63637836ULL, 0x000fc40000000000ULL,
0x0000001062627824ULL, 0x000fe200078e00ffULL, 0xfffffff035357812ULL, 0x000fe200078ee234ULL,
0x0000001055147824ULL, 0x100fe200078e0261ULL, 0x000000163010723cULL, 0x000fe20000001810ULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0xfffffff062637812ULL, 0x000fe200078ee263ULL,
0x0000001035357824ULL, 0x000fe400078e0202ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x00000036302c723cULL, 0x000fe6000000182cULL, 0x000000003534783bULL, 0x000ea60000000200ULL,
0x0000003c3024723cULL, 0x008fec0000001824ULL, 0x0000003e3020723cULL, 0x000fe20000001820ULL,
0x00000010683c7824ULL, 0x000fca00078e0261ULL, 0x000000383018723cULL, 0x010fe20000001818ULL,
0x000000003c3c783bULL, 0x000fea0000000200ULL, 0x0000003a3050723cULL, 0x000fe20000001850ULL,
0x0000006167387211ULL, 0x000fca00078e20ffULL, 0x00000028441c723cULL, 0x020fe2000000181cULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x0000001069307824ULL, 0x000fc800078e0261ULL,
0x0000002a4428723cULL, 0x000fe40000001810ULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x000000144424723cULL, 0x002fe20000001824ULL, 0x000000616b107211ULL, 0x000fca00078e20ffULL,
0x000000164414723cULL, 0x000fe20000001820ULL, 0x000000001010783bULL, 0x000e6a0000000200ULL,
0x000000544418723cULL, 0x000fe20000001818ULL, 0x0000001063207824ULL, 0x000fca00078e0202ULL,
0x000000564450723cULL, 0x000fe20000001850ULL, 0x0000001066547824ULL, 0x000fe200078e0261ULL,
0x000000002020783bULL, 0x000ee80000000200ULL, 0x00000048444c723cULL, 0x000fe2000000184cULL,
0x000000005454783bULL, 0x000f2a0000000200ULL, 0x0000004a442c723cULL, 0x000fec000000182cULL,
0x00000040341c723cULL, 0x004fe2000000181cULL, 0x0000006165447211ULL, 0x000fca00078e20ffULL,
0x000000423428723cULL, 0x000fe20000001828ULL, 0x0000001064407824ULL, 0x000fe200078e0261ULL,
0x000000004444783bULL, 0x000ea80000000200ULL, 0x000000103424723cULL, 0x002fe20000001824ULL,
0x000000004040783bULL, 0x000e6a0000000200ULL, 0x000000123414723cULL, 0x000fe20000001814ULL,
0x00000001ff107424ULL, 0x000fca00078e00ffULL, 0x0000003c3418723cULL, 0x000fe20000001818ULL,
0x01b68810071079a7ULL, 0x000f6a000850003fULL, 0x0000003e3450723cULL, 0x000fec0000001850ULL,
0x00000038344c723cULL, 0x000fec000000184cULL, 0x0000003a342c723cULL, 0x000fec000000182cULL,
0x00000030201c723cULL, 0x008fec000000181cULL, 0x000000322028723cULL, 0x000fec0000001828ULL,
0x000000542024723cULL, 0x010fec0000001824ULL, 0x000000562014723cULL, 0x000fec0000001814ULL,
0x000000442018723cULL, 0x004fe20000001818ULL, 0x3db504f31d1d7820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x3db504f31f1f7820ULL, 0x000fc60000410000ULL,
0x000000462050723cULL, 0x000fe20000001850ULL, 0x3db504f328287820ULL, 0x000fe20000410000ULL,
0x3db504f329297820ULL, 0x000fe20000410000ULL, 0x3db504f32a2a7820ULL, 0x000fe20000410000ULL,
0x3db504f32b2b7820ULL, 0x000fe40000410000ULL, 0x00000040204c723cULL, 0x002fe2000000184cULL,
0x3db504f324247820ULL, 0x000fe20000410000ULL, 0x3db504f325257820ULL, 0x000fe20000410000ULL,
0x3db504f326267820ULL, 0x000fe20000410000ULL, 0x3db504f327277820ULL, 0x000fc40000410000ULL,
0x00000042202c723cULL, 0x000fe2000000182cULL, 0x3db504f316317820ULL, 0x000fca0000410000ULL,
0x3db504f318337820ULL, 0x000fe20000410000ULL, 0x3db504f31c217820ULL, 0x000fe20000410000ULL,
0x3db504f314207820ULL, 0x000fe20000410000ULL, 0x3db504f315237820ULL, 0x000fe20000410000ULL,
0x3db504f317227820ULL, 0x000fe20000410000ULL, 0x3db504f319347820ULL, 0x000fe20000410000ULL,
0x3db504f31a327820ULL, 0x000fe20000410000ULL, 0x3db504f31b1c7820ULL, 0x000fe20000410000ULL,
0x3db504f350507820ULL, 0x000fe20000410000ULL, 0x3db504f351517820ULL, 0x000fe20000410000ULL,
0x3db504f352527820ULL, 0x000fe20000410000ULL, 0x3db504f353537820ULL, 0x000fe20000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fc60000410000ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x0000000000127805ULL, 0x000fe20000015200ULL, 0x01b68811070075a7ULL, 0x020e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fc80007f1e1ffULL,
0x0000001513157210ULL, 0x000fe400007fe5ffULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x01b68811070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000405107824ULL, 0x000fe200078e00ffULL, 0x000000025d117211ULL, 0x000fe400078e38ffULL,
0x000000046000720cULL, 0x000fe40003f06070ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000000111307824ULL, 0x000fca00078e0210ULL, 0x01b4000030107984ULL, 0x0002a20000000c00ULL,
0x0000001400208947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ff00147202ULL, 0x000fe20000000f00ULL, 0x0000000400167d06ULL, 0x000ee20008209000ULL,
0x0000000205367824ULL, 0x000fe200078e00ffULL, 0x00000004ff007c0cULL, 0x000fe4000bf85070ULL,
0x00000004ff1b7c12ULL, 0x000fe4000f8e33ffULL, 0x0000000636367812ULL, 0x000fc800078ec0ffULL,
0x0000005f36387210ULL, 0x000fe20007ffe0ffULL, 0x0000001600167308ULL, 0x008ee40000001000ULL,
0x0ffffffe16187836ULL, 0x008fcc0000000000ULL, 0x0000001800157305ULL, 0x000ee4000021f000ULL,
0x000000ffff177224ULL, 0x008fc800078e0a15ULL, 0x0000000417177c24ULL, 0x000fc8000f8e02ffULL,
0x0000001715197227ULL, 0x000fe200078e0014ULL, 0x0000005e05147211ULL, 0x000fca00078ff0ffULL,
0x0000001419157227ULL, 0x000fc800078e00ffULL, 0x000000ffff177224ULL, 0x000fc800078e0a15ULL,
0x0000000417167c24ULL, 0x000fe4000f8e0214ULL, 0x0000000814147836ULL, 0x000fc60000000000ULL,
0x0000000416007c0cULL, 0x000fe2000bf06070ULL, 0x0000001419187227ULL, 0x000fc800078e00ffULL,
0x000000ffff177224ULL, 0x000fc800078e0a18ULL, 0x0000000417177c24ULL, 0x000fe2000f8e0214ULL,
0x0000000b5c147248ULL, 0x000fc60007fe0000ULL, 0x8000000416160c10ULL, 0x000fe2000fffe0ffULL,
0x0000000115150836ULL, 0x000fe20000000000ULL, 0x0000000417007c0cULL, 0x000fe2000bf46070ULL,
0x00000001140b7824ULL, 0x000fe200078e0a0bULL, 0x0000000416007c0cULL, 0x000fe2000bf26070ULL,
0x0000000109147824ULL, 0x000fe400078e0236ULL, 0x000000ffff477224ULL, 0x000fc600078e0a0bULL,
0x0000000b1400720cULL, 0x080fe40003f66070ULL, 0x0000004714147246ULL, 0x000fe40003800008ULL,
0x0000004738437246ULL, 0x000fe20003800008ULL, 0x0000000118182836ULL, 0x000fe20000000000ULL,
0x8000000417172c10ULL, 0x000fe2000fffe0ffULL, 0x0000000115151836ULL, 0x000fe20000000000ULL,
0x0000000b3800720cULL, 0x000fe40003f26070ULL, 0x0000000417007c0cULL, 0x000fc4000bf06070ULL,
0x000000151b157207ULL, 0x000fe40006000000ULL, 0x00000004ff147819ULL, 0x000fe40000011614ULL,
0x0000001508157248ULL, 0x000fe40003fe0000ULL, 0x000000ff14197207ULL, 0x000fe40001800000ULL,
0x000000ff43437207ULL, 0x000fe20000800000ULL, 0x0000000515607c24ULL, 0x000fe4000f8e02ffULL,
0x0000000118180836ULL, 0x000fc40000000000ULL, 0x0000000160157824ULL, 0x000fe200078e0219ULL,
0x0000006043177211ULL, 0x000fe400078fe0ffULL, 0x000000181b1b7207ULL, 0x000fe20006000000ULL,
0x0000000215147825ULL, 0x000fc600078e0074ULL, 0x0000001b081b7248ULL, 0x000fe20003fe0000ULL,
0x0000000217167825ULL, 0x000fe200078e0074ULL, 0x0000000614457981ULL, 0x000726000c1e9500ULL,
0x000000051b627c24ULL, 0x000fe2000f8e02ffULL, 0x0000000616567981ULL, 0x000f22000c1e9500ULL,
0x00000010363c7812ULL, 0x000fc600078efcffULL, 0x0000006219197210ULL, 0x000fe40007ffe0ffULL,
0x00000062431b7211ULL, 0x000fe200078fe0ffULL, 0x0000000109147824ULL, 0x008fe400078e023cULL,
0x0000000219187825ULL, 0x000fc800078e0074ULL, 0x000000021b1a7825ULL, 0x000fe200078e0074ULL,
0x0000004714157246ULL, 0x000fe20003800008ULL, 0x0000000618417981ULL, 0x0044e4000c1e9500ULL,
0x000000013c3a7824ULL, 0x000fe400078e025fULL, 0x000000061a667981ULL, 0x000ae2000c1e9500ULL,
0x0000002036407812ULL, 0x000fe400078efcffULL, 0x0000000b1400720cULL, 0x080fe40003f26070ULL,
0x0000000b3a00720cULL, 0x000fc40003f06070ULL, 0x00000004ff157819ULL, 0x000fe40000011615ULL,
0x000000473a357246ULL, 0x000fe20003800008ULL, 0x0000000109447824ULL, 0x000fe200078e0240ULL,
0x000000ff15397207ULL, 0x000fe40000800000ULL, 0x000000ff35357207ULL, 0x000fe20000000000ULL,
0x0000000140427824ULL, 0x000fe200078e025fULL, 0x0000006239197210ULL, 0x004fe20007ffe0ffULL,
0x0000000160157824ULL, 0x000fe200078e0239ULL, 0x0000006035177211ULL, 0x002fc400078fe0ffULL,
0x00000062351b7211ULL, 0x020fe200078fe0ffULL, 0x0000000215147825ULL, 0x100fe200078e0074ULL,
0x00000047443b7246ULL, 0x000fe40003800008ULL, 0x0000003036467812ULL, 0x000fe200078efcffULL,
0x0000000217167825ULL, 0x100fe200078e0074ULL, 0x0000000b4400720cULL, 0x080fe20003f26070ULL,
0x0000000614377981ULL, 0x000ea2000c1e9500ULL, 0x0000000b4200720cULL, 0x000fe20003f06070ULL,
0x0000000219187825ULL, 0x000fe200078e0074ULL, 0x00000004ff3b7819ULL, 0x000fe2000001163bULL,
0x00000006163e7981ULL, 0x0002a2000c1e9500ULL, 0x00000047423f7246ULL, 0x000fe20003800008ULL,
0x000000021b1a7825ULL, 0x000fe200078e0074ULL, 0x000000ff3b3d7207ULL, 0x000fe20000800000ULL,
0x0000000618397981ULL, 0x000aa2000c1e9500ULL, 0x000000ff3f3f7207ULL, 0x000fe20000000000ULL,
0x0000000109647824ULL, 0x000fc400078e0246ULL, 0x000000061a447981ULL, 0x000aa2000c1e9500ULL,
0x00000001464a7824ULL, 0x000fe200078e025fULL, 0x000000603f177211ULL, 0x002fe200078fe0ffULL,
0x0000000160157824ULL, 0x000fe200078e023dULL, 0x0000004764497246ULL, 0x000fe40003800008ULL,
0x000000623d197210ULL, 0x020fe20007ffe0ffULL, 0x0000000215147825ULL, 0x000fe200078e0074ULL,
0x000000623f1b7211ULL, 0x000fc600078fe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0074ULL,
0x0000000b6400720cULL, 0x080fe20003f26070ULL, 0x00000006143b7981ULL, 0x000362000c1e9500ULL,
0x00000004ff497819ULL, 0x000fe20000011649ULL, 0x0000000219187825ULL, 0x100fe200078e0074ULL,
0x0000000b4a00720cULL, 0x000fe20003f06070ULL, 0x0000000616487981ULL, 0x000362000c1e9500ULL,
0x000000474a477246ULL, 0x000fe20003800008ULL, 0x000000021b1a7825ULL, 0x000fe200078e0074ULL,
0x000000ff49497207ULL, 0x000fe20000800000ULL, 0x00000006183d7981ULL, 0x000f62000c1e9500ULL,
0x000000ff47477207ULL, 0x000fc60000000000ULL, 0x000000061a547981ULL, 0x000364000c1e9500ULL,
0x0000000160157824ULL, 0x002fe200078e0249ULL, 0x0000006047177211ULL, 0x000fc600078fe0ffULL,
0x0000000215147825ULL, 0x000fc800078e0074ULL, 0x0000000217167825ULL, 0x100fe400078e0074ULL,
0x0000000614147981ULL, 0x000362000c1e9500ULL, 0x00000062491b7210ULL, 0x000fe40007ffe0ffULL,
0x0000006247197211ULL, 0x000fe200078fe0ffULL, 0x0000000616177981ULL, 0x000364000c1e9500ULL,
0x000000021b1a7825ULL, 0x000fc800078e0074ULL, 0x0000000219187825ULL, 0x000fe400078e0074ULL,
0x000000061a1b7981ULL, 0x000368000c1e9500ULL, 0x0000000618187981ULL, 0x000362000c1e9500ULL,
0xfffffff043627812ULL, 0x000fe200078ec0ffULL, 0x00000001ff437424ULL, 0x000fc800078e00ffULL,
0x000000010b157824ULL, 0x002fe200078e0262ULL, 0x0000000136607812ULL, 0x000fc800078efcffULL,
0x8000001538687210ULL, 0x000fe40007ffe0ffULL, 0x0000000936167812ULL, 0x000fe400078efcffULL,
0x0000006843687219ULL, 0x000fe200000006ffULL, 0x0000000160647824ULL, 0x100fe400078e025fULL,
0x00000001161a7824ULL, 0x000fe400078e025fULL, 0x00000001646a7824ULL, 0x100fe400078e0a15ULL,
0x000000011a6e7824ULL, 0x000fc600078e0a15ULL, 0x0000006a436a7219ULL, 0x040fe400000006ffULL,
0x0000006e436e7219ULL, 0x000fe400000006ffULL, 0x00000011367a7812ULL, 0x040fe400078efcffULL,
0x0000001836787812ULL, 0x040fe400078efcffULL, 0xfffffff03f3f7812ULL, 0x000fe400078ec0ffULL,
0x0000001936767812ULL, 0x000fe200078efcffULL, 0x000000017a197824ULL, 0x000fc400078e025fULL,
0x000000010b6f7824ULL, 0x000fe200078e023fULL, 0x0000005f767c7210ULL, 0x000fc60007ffe0ffULL,
0x0000000142657824ULL, 0x000fe200078e0a6fULL, 0x0000002136707812ULL, 0x000fe400078efcffULL,
0xfffffff047477812ULL, 0x000fe400078ec0ffULL, 0x0000006543657219ULL, 0x000fe200000006ffULL,
0x0000000170727824ULL, 0x000fe400078e025fULL, 0x000000010b477824ULL, 0x000fc600078e0247ULL,
0x000000726f677210ULL, 0x000fe20007ffe1ffULL, 0x000000014a6b7824ULL, 0x000fc600078e0a47ULL,
0x0000006743677219ULL, 0x040fe400000006ffULL, 0x0000006b436b7219ULL, 0x000fe400000006ffULL,
0x0000541056457816ULL, 0x010fe40000000045ULL, 0x0000000836567812ULL, 0x000fe400078efcffULL,
0x0000004568ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000156627824ULL, 0x000fe200078e025fULL,
0x0000000b3800720cULL, 0x000fc80000701470ULL, 0x00000062156c7210ULL, 0x000fe40007ffe1ffULL,
0x0000000b3600720cULL, 0x000fe400007a1070ULL, 0x0000006c436c7219ULL, 0x000fe400000006ffULL,
0x0000541066417816ULL, 0x008fe40000000041ULL, 0xff80000021217808ULL, 0x000fe40002800000ULL,
0x0000004168ff7212ULL, 0x000fc4000784c0ffULL, 0x000000416aff7212ULL, 0x080fe4000780c0ffULL,
0x000000416cff7212ULL, 0x080fe400078cc0ffULL, 0x000000416eff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff035417812ULL, 0x000fe200078ec0ffULL, 0x0000000178157824ULL, 0x000fc800078e025fULL,
0x000000010b417824ULL, 0x000fe200078e0241ULL, 0x000000456aff7212ULL, 0x080fe4000782c0ffULL,
0x000000456cff7212ULL, 0x080fe2000786c0ffULL, 0x000000013a3f7824ULL, 0x100fe200078e0a41ULL,
0x000000456eff7212ULL, 0x000fe2000788c0ffULL, 0x0000000115617824ULL, 0x000fe200078e0a41ULL,
0x0000001941457210ULL, 0x000fe40007ffe1ffULL, 0x0000000b3800720cULL, 0x080fe40001741470ULL,
0x0000000b6200720cULL, 0x000fc400037c1470ULL, 0x0000000b1a00720cULL, 0x000fe20002fa1470ULL,
0x000000017c737824ULL, 0x000fe200078e0a41ULL, 0x0000003f43417219ULL, 0x040fe400000006ffULL,
0x00000045433f7219ULL, 0x000fe400000006ffULL, 0x0000000b3600720cULL, 0x080fe40001741070ULL,
0x0000000b5600720cULL, 0x080fe400037c1070ULL, 0x0000000b1600720cULL, 0x000fc40002fa1070ULL,
0x0000006143457219ULL, 0x000fe400000006ffULL, 0x000054103e3e7816ULL, 0x004fe40000000037ULL,
0x0000541044447816ULL, 0x000fe40000000039ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fc40002800000ULL,
0x0000003e41ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004441ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004445ff7212ULL, 0x000fe400078ac0ffULL, 0x0000000b6400720cULL, 0x0c0fe40000f21470ULL,
0x0000000b6400720cULL, 0x080fe40000701470ULL, 0x0000000b6200720cULL, 0x000fc40001f61470ULL,
0x0000000b1a00720cULL, 0x080fe40002781470ULL, 0x0000000b3a00720cULL, 0x0c0fe40001741470ULL,
0x0000000b3a00720cULL, 0x080fe400037c1470ULL, 0x0000000b1500720cULL, 0x000fe40002fa1470ULL,
0x00000028366e7812ULL, 0x040fe400078efcffULL, 0x00000029366c7812ULL, 0x000fc400078efcffULL,
0x0000000b6000720cULL, 0x0c0fe40000f21070ULL, 0x0000000b6000720cULL, 0x080fe40000701070ULL,
0x0000000b5600720cULL, 0x080fe40001f61070ULL, 0x0000000b1600720cULL, 0x080fe40002781070ULL,
0x0000000b3c00720cULL, 0x0c0fe40001741070ULL, 0x0000000b3c00720cULL, 0x000fc400037c1070ULL,
0x0000000b7800720cULL, 0x000fe40002fa1070ULL, 0x0000007343617219ULL, 0x000fe400000006ffULL,
0x0000541048487816ULL, 0x020fe4000000003bULL, 0x0000541054547816ULL, 0x000fe2000000003dULL,
0x000000016e357824ULL, 0x000fe200078e025fULL, 0x0000005f6c577210ULL, 0x000fe40007ffe0ffULL,
0xff8000001d1d7808ULL, 0x000fc40000800000ULL, 0xff8000001f1f7808ULL, 0x000fe40000000000ULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff80000029297808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40003000000ULL,
0xff80000031317808ULL, 0x000fc40002800000ULL, 0x0000003e3fff7212ULL, 0x080fe4000782c0ffULL,
0x0000003e45ff7212ULL, 0x080fe4000780c0ffULL, 0x0000003e61ff7212ULL, 0x000fe4000786c0ffULL,
0x000000443fff7212ULL, 0x080fe4000788c0ffULL, 0x0000004461ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004865ff7212ULL, 0x000fc400078cc0ffULL, 0x0000005465ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000135717824ULL, 0x100fe200078e0a6fULL, 0x0000000b1900720cULL, 0x080fe20000f21470ULL,
0x00000001576f7824ULL, 0x000fe200078e0a6fULL, 0x0000000b1900720cULL, 0x080fe40002781470ULL,
0x0000000b1500720cULL, 0x080fe40000701470ULL, 0x0000000b7c00720cULL, 0x0c0fe40001f61470ULL,
0x0000000b7c00720cULL, 0x000fc40001741470ULL, 0x0000000b4200720cULL, 0x0c0fe400037c1470ULL,
0x0000000b4200720cULL, 0x080fe40002fa1470ULL, 0x00000031366a7812ULL, 0x040fe400078efcffULL,
0x0000003836687812ULL, 0x040fe400078efcffULL, 0x0000003936667812ULL, 0x000fe400078efcffULL,
0x0000000b7a00720cULL, 0x000fc40000f21070ULL, 0x0000000b7a00720cULL, 0x080fe40002781070ULL,
0x0000000b7800720cULL, 0x080fe40000701070ULL, 0x0000000b7600720cULL, 0x0c0fe40001f61070ULL,
0x0000000b7600720cULL, 0x080fe40001741070ULL, 0x0000000b4000720cULL, 0x0c0fe400037c1070ULL,
0x0000000b4000720cULL, 0x000fc40002fa1070ULL, 0x0000007143717219ULL, 0x040fe400000006ffULL,
0x0000006f436f7219ULL, 0x000fe400000006ffULL, 0x0000541017147816ULL, 0x000fe20000000014ULL,
0x000000016a557824ULL, 0x100fe200078e025fULL, 0x0000005f684b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000166497824ULL, 0x000fe200078e025fULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fc40002000000ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0x0000004867ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004871ff7212ULL, 0x080fe4000788c0ffULL,
0x000000486fff7212ULL, 0x000fe4000780c0ffULL, 0x0000005467ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005471ff7212ULL, 0x080fe4000784c0ffULL, 0x000000546fff7212ULL, 0x000fe400078cc0ffULL,
0x000000146bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000155697824ULL, 0x100fe200078e0a47ULL,
0x0000004b47637210ULL, 0x000fe20007ffe1ffULL, 0x0000000149477824ULL, 0x000fe200078e0a47ULL,
0x0000000b7200720cULL, 0x000fc40000f21470ULL, 0x0000000b7200720cULL, 0x080fe40001f61470ULL,
0x0000000b3500720cULL, 0x0c0fe40002781470ULL, 0x0000000b3500720cULL, 0x080fe40001741470ULL,
0x0000000b5700720cULL, 0x0c0fe40000701470ULL, 0x0000000b5700720cULL, 0x080fe400037c1470ULL,
0x0000000b4a00720cULL, 0x000fc40002fa1470ULL, 0x0000000b7000720cULL, 0x0c0fe40000f21070ULL,
0x0000000b7000720cULL, 0x080fe40001f61070ULL, 0x0000000b6e00720cULL, 0x0c0fe40002781070ULL,
0x0000000b6e00720cULL, 0x080fe40001741070ULL, 0x0000000b6c00720cULL, 0x0c0fe40000701070ULL,
0x0000000b6c00720cULL, 0x000fc400037c1070ULL, 0x0000000b4600720cULL, 0x000fe40002fa1070ULL,
0x0000006943697219ULL, 0x040fe400000006ffULL, 0x0000006343637219ULL, 0x040fe400000006ffULL,
0x0000004743477219ULL, 0x000fe400000006ffULL, 0x0000541018187816ULL, 0x000fe4000000001bULL,
0xff80000034347808ULL, 0x000fc40000800000ULL, 0xff8000001c1c7808ULL, 0x000fe40001800000ULL,
0xff80000050507808ULL, 0x000fe40002000000ULL, 0xff80000052527808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40000000000ULL, 0xff80000053537808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fc40002800000ULL, 0x0000001469ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001463ff7212ULL, 0x080fe4000786c0ffULL, 0x0000001447ff7212ULL, 0x000fe4000788c0ffULL,
0x000000186bff7212ULL, 0x080fe4000784c0ffULL, 0x0000001869ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001863ff7212ULL, 0x000fc400078cc0ffULL, 0x0000001847ff7212ULL, 0x000fe400078ac0ffULL,
0x0000000b4a00720cULL, 0x080fe40001741470ULL, 0x0000000b5500720cULL, 0x0c0fe40000f21470ULL,
0x0000000b5500720cULL, 0x080fe40000701470ULL, 0x0000000b4b00720cULL, 0x0c0fe40001f61470ULL,
0x0000000b4b00720cULL, 0x000fc400037c1470ULL, 0x0000000b4900720cULL, 0x0c0fe40002781470ULL,
0x0000000b4900720cULL, 0x080fe40002fa1470ULL, 0x0000000b4600720cULL, 0x080fe40001741070ULL,
0x0000000b6a00720cULL, 0x0c0fe40000f21070ULL, 0x0000000b6a00720cULL, 0x080fe40000701070ULL,
0x0000000b6800720cULL, 0x000fc40001f61070ULL, 0x0000000b6800720cULL, 0x080fe400037c1070ULL,
0x0000000b6600720cULL, 0x0c0fe40002781070ULL, 0x0000000b6600720cULL, 0x000fe40002fa1070ULL,
0xff8000004d4d7808ULL, 0x000fe40000800000ULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fc40002000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40000000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fce0002800000ULL, 0x000000211000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff607224ULL, 0x000fe200078e006dULL, 0xfffffff8ff0c7812ULL, 0x000fe400078ee20cULL,
0x0000001021107208ULL, 0x000fc80004000000ULL, 0x0000001d1000720bULL, 0x000fc80003f1e000ULL,
0x000000101d0b7208ULL, 0x000fc80004000000ULL, 0x000000280b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b28107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x00000010290b7208ULL, 0x000fc80004000000ULL, 0x000000240b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b24107208ULL, 0x000fc80004000000ULL, 0x000000251000720bULL, 0x000fc80003f1e000ULL,
0x00000010250b7208ULL, 0x000fc80004000000ULL, 0x000000200b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b20107208ULL, 0x000fc80004000000ULL, 0x000000231000720bULL, 0x000fc80003f1e000ULL,
0x0000001023107208ULL, 0x000fc80004000000ULL, 0x000000331000720bULL, 0x000fc80003f1e000ULL,
0x00000010330b7208ULL, 0x000fc80004000000ULL, 0x000000340b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b340b7208ULL, 0x000fc80004000000ULL, 0x000000500b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b50107208ULL, 0x000fe40004000000ULL, 0x0000001e1100720bULL, 0x000fe40003f1e000ULL,
0x000000511000720bULL, 0x000fc80003f3e000ULL, 0x00000010510b7208ULL, 0x000fe40004800000ULL,
0x000000111e107208ULL, 0x000fe40004000000ULL, 0x0000004c0b00720bULL, 0x000fe40003f3e000ULL,
0x0000001f1000720bULL, 0x000fe40003f1e000ULL, 0x0000000b4c147208ULL, 0x000fe40004800000ULL,
0x000000101f0b7208ULL, 0x000fc40004000000ULL, 0x0000004d1400720bULL, 0x000fe40003f3e000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x000000144d117208ULL, 0x000fe40004800000ULL,
0x0000000b2a107208ULL, 0x000fe40004000000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x0000002b1000720bULL, 0x000fc40003f1e000ULL, 0x000000112c147208ULL, 0x000fe40004800000ULL,
0x000000102b0b7208ULL, 0x000fe40004000000ULL, 0x0000002d1400720bULL, 0x000fe40003f3e000ULL,
0x000000260b00720bULL, 0x000fe40003f1e000ULL, 0x000000142d147208ULL, 0x000fe40004800000ULL,
0x0000000b26107208ULL, 0x000fc60004000000ULL, 0x0c401f0014117f89ULL, 0x000ea200000e0000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x00000010310b7208ULL, 0x000fc80004000000ULL,
0x000000220b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b220b7208ULL, 0x000fe40004000000ULL,
0x000000111400720bULL, 0x004fe40003f3e000ULL, 0x000000320b00720bULL, 0x000fe40003f1e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000000b320b7208ULL, 0x000fc60004000000ULL,
0x0c201f0011147f89ULL, 0x000ea200000e0000ULL, 0x0000001c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b1c0b7208ULL, 0x000fc80004000000ULL, 0x000000520b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b52107208ULL, 0x000fc80004000000ULL, 0x000000531000720bULL, 0x000fc80003f1e000ULL,
0x00000010530b7208ULL, 0x000fe40004000000ULL, 0x000000141100720bULL, 0x004fe40003f3e000ULL,
0x0000004e0b00720bULL, 0x000fe40003f1e000ULL, 0x0000001114107208ULL, 0x000fe40004800000ULL,
0x0000000b4e147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL,
0x0000004f1400720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010816ULL,
0x000000144f0b7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x0000001d00187308ULL, 0x0005e20000000800ULL,
0x0000002e0b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010816ULL,
0x0000000b2e147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010816ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002f1400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b331d7823ULL, 0x104fe20000010816ULL,
0x3fb8aa3b51367823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL,
0x000000142f147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc40000010816ULL,
0x0000002900297308ULL, 0x000ea40000000800ULL, 0x0c401f00140b7f89ULL, 0x000eec00000e0000ULL,
0x00000020001b7308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000f300000000800ULL,
0x0000002400197308ULL, 0x000be20000000800ULL, 0x0000000b1400720bULL, 0x008fc80003f1e000ULL,
0x000000140b117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4c0b7823ULL, 0x100fe40000010816ULL,
0x00000025001a7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b34247823ULL, 0x122fe20000010816ULL,
0x3fb8aa3b4d347823ULL, 0x100fe20000010816ULL, 0x0c201f0011147f89ULL, 0x000e6a00000e0000ULL,
0x0000002300387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b50257823ULL, 0x008fe20000010816ULL,
0x000000282916723eULL, 0x004fe200000000ffULL, 0x3c003c00ff287424ULL, 0x000fc400078e00ffULL,
0x3c003c00ff297424ULL, 0x000fc600078e00ffULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000141100720bULL, 0x002fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fc60004000000ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000211814723eULL, 0x010fe200000000ffULL, 0x3fb8aa3b11337820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010833ULL,
0x0000001e00157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b22187823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010833ULL,
0x0000001f00207308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe20000010833ULL,
0x000000080c337824ULL, 0x000fc400078e00ffULL, 0x0000002a00177308ULL, 0x0005e20000000800ULL,
0x000000152015723eULL, 0x002fce00000000ffULL, 0x0000002b003a7308ULL, 0x0002e20000000800ULL,
0x000000080c2a7824ULL, 0x004fce00078e00ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000008005d2b7824ULL, 0x002fe200078e0202ULL, 0x000000173a17723eULL, 0x008fcc00000000ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000281420723cULL, 0x000fee00000018ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x00000018001e7308ULL, 0x0004f00000000800ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000191a18723eULL, 0x004fc400000000ffULL,
0x0000001b381a723eULL, 0x000fe400000000ffULL, 0x000000262719723eULL, 0x002fe400000000ffULL,
0x000000311e1b723eULL, 0x008fe200000000ffULL, 0x0c401f0012277f89ULL, 0x000e6200000e0000ULL,
0x0000001c001f7308ULL, 0x0004e20000000800ULL, 0x000000030d317812ULL, 0x000fe400078ec0ffULL,
0x0c401f0013267f89ULL, 0x000f2400000e0000ULL, 0x000000281820723cULL, 0x000fe20000001820ULL,
0x0000000c310d7210ULL, 0x000fc40007ffe0ffULL, 0x0000003600367308ULL, 0x000f620000000800ULL,
0x0000001d241c723eULL, 0x004fe400000000ffULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee20dULL,
0x000000321f1d723eULL, 0x008fc600000000ffULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x00000025361e723eULL, 0x020fce00000000ffULL, 0x0000005300537308ULL, 0x000ea20000000800ULL,
0x000000271200720bULL, 0x002fe40003f1e000ULL, 0x000000261300720bULL, 0x010fe40003f3e000ULL,
0x0000001227127208ULL, 0x000fe40004000000ULL, 0x0000001326137208ULL, 0x000fe20004800000ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x00000052531f723eULL, 0x004fce00000000ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x000000281c24723cULL, 0x000fee0000001820ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x0000000b3420723eULL, 0x002fce00000000ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0c201f00120b7f89ULL, 0x000eae00000e0000ULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x0000002c2d22723eULL, 0x002fce00000000ffULL,
0x0000004f004f7308ULL, 0x000e620000000800ULL, 0x000000080c2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000040d2c7836ULL, 0x000fe20000000000ULL, 0x0c201f00130c7f89ULL, 0x000ee600000e0000ULL,
0x000000082d327824ULL, 0x000fe200078e00ffULL, 0xfffffff8332c7812ULL, 0x000fe200078ee22cULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000000b1200720bULL, 0x004fc80003f1e000ULL,
0x000000120b127208ULL, 0x000fe40004000000ULL, 0x0000004e4f21723eULL, 0x002fe200000000ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000000305ff7812ULL, 0x000fe4000780c0ffULL,
0x00000001000b7802ULL, 0x000fe40000000f00ULL, 0x0000000c1300720bULL, 0x008fe40003f3e000ULL,
0x0000002e2f23723eULL, 0x002fe200000000ffULL, 0x00000001312e7824ULL, 0x000fe200078e022dULL,
0x000000032d317819ULL, 0x000fe200000006ffULL, 0x0000000c0d2f7836ULL, 0x000fe20000000000ULL,
0x000000130c137208ULL, 0x000fe20004800000ULL, 0x000110002b0d7836ULL, 0x000fe20000000000ULL,
0xfffffff8312e7812ULL, 0x000fe200078ee22eULL, 0x000000282024723cULL, 0x000fe20000001824ULL,
0xfffffff832327812ULL, 0x000fe200078ee22fULL, 0x000000ffff2b7224ULL, 0x000fc400078e001aULL,
0x000000102e317824ULL, 0x000fe400078e020dULL, 0x00000020002e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e001eULL, 0x000000ffff287224ULL, 0x000fe400078e0014ULL,
0x000000ffff297224ULL, 0x000fe400078e0016ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000001700157202ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0022ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0000001f00197202ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fe400078e001bULL, 0x000000102a257824ULL, 0x100fe200078e020dULL,
0x00000018002a7202ULL, 0x000fe20000000f00ULL, 0x0000001032327824ULL, 0x000fe200078e020dULL,
0x0000000d2c277211ULL, 0x000fe200078e20ffULL, 0x000000ffff2c7224ULL, 0x000fe400078e001cULL,
0x0000002825007844ULL, 0x0003e20000000200ULL, 0x000000ffff187224ULL, 0x000fc400078e001dULL,
0x000000ffff1a7224ULL, 0x000fe200078e0021ULL, 0x0000002c27007844ULL, 0x0005e20000000200ULL,
0x000000ffff1b7224ULL, 0x000fc600078e0023ULL, 0x0000001431007844ULL, 0x0005e80000000200ULL,
0x0000001832007844ULL, 0x0005e20000000200ULL, 0x000000ffff257224ULL, 0x002fc600078e0026ULL,
0x01b0001030008388ULL, 0x0005e80000000c00ULL, 0x01b2002430008388ULL, 0x0005e20000000a00ULL,
0x0000005a6d00720cULL, 0x000fe20003f06070ULL, 0x01b6080b0aff79a7ULL, 0x0005e2000850003fULL,
0x01b6100b0aff79a7ULL, 0x0005e2000850003fULL, 0x01b6180b0aff79a7ULL, 0x0005e2000850003fULL,
0x01b6200b0aff79a7ULL, 0x0005f2000850003fULL, 0xffffff9800e88947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000056087836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000008097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000005600088308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff087807ULL, 0x004fc80004000000ULL, 0x0000000809ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff56ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff087807ULL, 0x000fc80000000000ULL, 0x0000000809ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000056097812ULL, 0x000fd600078ec0ffULL, 0x0080000009080812ULL, 0x000fe200078efcffULL,
0x000000ffff088224ULL, 0x000fe200078e0009ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005600087308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008000c7202ULL, 0x00cfe20000000f00ULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffffec008a07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x000000000000048dULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000608ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000818ULL, 0x00000000000000e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000954ULL, 0x0000000000000470ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e10ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000013e80ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014d00ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014d40ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000014d40ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000015338ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015338ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e10ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000013e80ULL, 0x0000000000013e80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000014d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014d40ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 87176;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
